// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#pragma pack(1)
struct BFs1c_BFs1s_BFu1ll_BFs1s { signed char v1:1; signed short v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1c_BFs1s_BFu1ll_BFu1c { signed char v1:1; signed short v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1c_BFs1s_BFu1ll_BFu1i { signed char v1:1; signed short v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1c_BFs1s_BFu1ll_BFu1ll { signed char v1:1; signed short v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1s_BFu1ll_BFu1s { signed char v1:1; signed short v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1c_BFs1s_BFu1s { signed char v1:1; signed short v2:1; unsigned short v3:1; };
struct BFs1c_BFs1s_BFu1s_BFs1c { signed char v1:1; signed short v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1c_BFs1s_BFu1s_BFs1i { signed char v1:1; signed short v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1c_BFs1s_BFu1s_BFs1ll { signed char v1:1; signed short v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1c_BFs1s_BFu1s_BFs1s { signed char v1:1; signed short v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1c_BFs1s_BFu1s_BFu1c { signed char v1:1; signed short v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1c_BFs1s_BFu1s_BFu1i { signed char v1:1; signed short v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1c_BFs1s_BFu1s_BFu1ll { signed char v1:1; signed short v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1s_BFu1s_BFu1s { signed char v1:1; signed short v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1c_BFu1c { signed char v1:1; unsigned char v2:1; };
struct BFs1c_BFu1c_BFs1c { signed char v1:1; unsigned char v2:1; signed char v3:1; };
struct BFs1c_BFu1c_BFs1c_BFs1c { signed char v1:1; unsigned char v2:1; signed char v3:1; signed char v4:1; };
struct BFs1c_BFu1c_BFs1c_BFs1i { signed char v1:1; unsigned char v2:1; signed char v3:1; signed int v4:1; };
struct BFs1c_BFu1c_BFs1c_BFs1ll { signed char v1:1; unsigned char v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1c_BFu1c_BFs1c_BFs1s { signed char v1:1; unsigned char v2:1; signed char v3:1; signed short v4:1; };
struct BFs1c_BFu1c_BFs1c_BFu1c { signed char v1:1; unsigned char v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1c_BFu1c_BFs1c_BFu1i { signed char v1:1; unsigned char v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1c_BFu1c_BFs1c_BFu1ll { signed char v1:1; unsigned char v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1c_BFs1c_BFu1s { signed char v1:1; unsigned char v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1c_BFu1c_BFs1i { signed char v1:1; unsigned char v2:1; signed int v3:1; };
struct BFs1c_BFu1c_BFs1i_BFs1c { signed char v1:1; unsigned char v2:1; signed int v3:1; signed char v4:1; };
struct BFs1c_BFu1c_BFs1i_BFs1i { signed char v1:1; unsigned char v2:1; signed int v3:1; signed int v4:1; };
struct BFs1c_BFu1c_BFs1i_BFs1ll { signed char v1:1; unsigned char v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1c_BFu1c_BFs1i_BFs1s { signed char v1:1; unsigned char v2:1; signed int v3:1; signed short v4:1; };
struct BFs1c_BFu1c_BFs1i_BFu1c { signed char v1:1; unsigned char v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1c_BFu1c_BFs1i_BFu1i { signed char v1:1; unsigned char v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1c_BFu1c_BFs1i_BFu1ll { signed char v1:1; unsigned char v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1c_BFs1i_BFu1s { signed char v1:1; unsigned char v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1c_BFu1c_BFs1ll { signed char v1:1; unsigned char v2:1; signed long long v3:1; };
struct BFs1c_BFu1c_BFs1ll_BFs1c { signed char v1:1; unsigned char v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1c_BFu1c_BFs1ll_BFs1i { signed char v1:1; unsigned char v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1c_BFu1c_BFs1ll_BFs1ll { signed char v1:1; unsigned char v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1c_BFu1c_BFs1ll_BFs1s { signed char v1:1; unsigned char v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1c_BFu1c_BFs1ll_BFu1c { signed char v1:1; unsigned char v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1c_BFu1c_BFs1ll_BFu1i { signed char v1:1; unsigned char v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1c_BFu1c_BFs1ll_BFu1ll { signed char v1:1; unsigned char v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1c_BFs1ll_BFu1s { signed char v1:1; unsigned char v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1c_BFu1c_BFs1s { signed char v1:1; unsigned char v2:1; signed short v3:1; };
struct BFs1c_BFu1c_BFs1s_BFs1c { signed char v1:1; unsigned char v2:1; signed short v3:1; signed char v4:1; };
struct BFs1c_BFu1c_BFs1s_BFs1i { signed char v1:1; unsigned char v2:1; signed short v3:1; signed int v4:1; };
struct BFs1c_BFu1c_BFs1s_BFs1ll { signed char v1:1; unsigned char v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1c_BFu1c_BFs1s_BFs1s { signed char v1:1; unsigned char v2:1; signed short v3:1; signed short v4:1; };
struct BFs1c_BFu1c_BFs1s_BFu1c { signed char v1:1; unsigned char v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1c_BFu1c_BFs1s_BFu1i { signed char v1:1; unsigned char v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1c_BFu1c_BFs1s_BFu1ll { signed char v1:1; unsigned char v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1c_BFs1s_BFu1s { signed char v1:1; unsigned char v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1c_BFu1c_BFu1c { signed char v1:1; unsigned char v2:1; unsigned char v3:1; };
struct BFs1c_BFu1c_BFu1c_BFs1c { signed char v1:1; unsigned char v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1c_BFu1c_BFu1c_BFs1i { signed char v1:1; unsigned char v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1c_BFu1c_BFu1c_BFs1ll { signed char v1:1; unsigned char v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1c_BFu1c_BFu1c_BFs1s { signed char v1:1; unsigned char v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1c_BFu1c_BFu1c_BFu1c { signed char v1:1; unsigned char v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1c_BFu1c_BFu1c_BFu1i { signed char v1:1; unsigned char v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1c_BFu1c_BFu1c_BFu1ll { signed char v1:1; unsigned char v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1c_BFu1c_BFu1s { signed char v1:1; unsigned char v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1c_BFu1c_BFu1i { signed char v1:1; unsigned char v2:1; unsigned int v3:1; };
struct BFs1c_BFu1c_BFu1i_BFs1c { signed char v1:1; unsigned char v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1c_BFu1c_BFu1i_BFs1i { signed char v1:1; unsigned char v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1c_BFu1c_BFu1i_BFs1ll { signed char v1:1; unsigned char v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1c_BFu1c_BFu1i_BFs1s { signed char v1:1; unsigned char v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1c_BFu1c_BFu1i_BFu1c { signed char v1:1; unsigned char v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1c_BFu1c_BFu1i_BFu1i { signed char v1:1; unsigned char v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1c_BFu1c_BFu1i_BFu1ll { signed char v1:1; unsigned char v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1c_BFu1i_BFu1s { signed char v1:1; unsigned char v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1c_BFu1c_BFu1ll { signed char v1:1; unsigned char v2:1; unsigned long long v3:1; };
struct BFs1c_BFu1c_BFu1ll_BFs1c { signed char v1:1; unsigned char v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1c_BFu1c_BFu1ll_BFs1i { signed char v1:1; unsigned char v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1c_BFu1c_BFu1ll_BFs1ll { signed char v1:1; unsigned char v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1c_BFu1c_BFu1ll_BFs1s { signed char v1:1; unsigned char v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1c_BFu1c_BFu1ll_BFu1c { signed char v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1c_BFu1c_BFu1ll_BFu1i { signed char v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1c_BFu1c_BFu1ll_BFu1ll { signed char v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1c_BFu1ll_BFu1s { signed char v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1c_BFu1c_BFu1s { signed char v1:1; unsigned char v2:1; unsigned short v3:1; };
struct BFs1c_BFu1c_BFu1s_BFs1c { signed char v1:1; unsigned char v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1c_BFu1c_BFu1s_BFs1i { signed char v1:1; unsigned char v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1c_BFu1c_BFu1s_BFs1ll { signed char v1:1; unsigned char v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1c_BFu1c_BFu1s_BFs1s { signed char v1:1; unsigned char v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1c_BFu1c_BFu1s_BFu1c { signed char v1:1; unsigned char v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1c_BFu1c_BFu1s_BFu1i { signed char v1:1; unsigned char v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1c_BFu1c_BFu1s_BFu1ll { signed char v1:1; unsigned char v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1c_BFu1s_BFu1s { signed char v1:1; unsigned char v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1c_BFu1i { signed char v1:1; unsigned int v2:1; };
struct BFs1c_BFu1i_BFs1c { signed char v1:1; unsigned int v2:1; signed char v3:1; };
struct BFs1c_BFu1i_BFs1c_BFs1c { signed char v1:1; unsigned int v2:1; signed char v3:1; signed char v4:1; };
struct BFs1c_BFu1i_BFs1c_BFs1i { signed char v1:1; unsigned int v2:1; signed char v3:1; signed int v4:1; };
struct BFs1c_BFu1i_BFs1c_BFs1ll { signed char v1:1; unsigned int v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1c_BFu1i_BFs1c_BFs1s { signed char v1:1; unsigned int v2:1; signed char v3:1; signed short v4:1; };
struct BFs1c_BFu1i_BFs1c_BFu1c { signed char v1:1; unsigned int v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1c_BFu1i_BFs1c_BFu1i { signed char v1:1; unsigned int v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1c_BFu1i_BFs1c_BFu1ll { signed char v1:1; unsigned int v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1i_BFs1c_BFu1s { signed char v1:1; unsigned int v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1c_BFu1i_BFs1i { signed char v1:1; unsigned int v2:1; signed int v3:1; };
struct BFs1c_BFu1i_BFs1i_BFs1c { signed char v1:1; unsigned int v2:1; signed int v3:1; signed char v4:1; };
struct BFs1c_BFu1i_BFs1i_BFs1i { signed char v1:1; unsigned int v2:1; signed int v3:1; signed int v4:1; };
struct BFs1c_BFu1i_BFs1i_BFs1ll { signed char v1:1; unsigned int v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1c_BFu1i_BFs1i_BFs1s { signed char v1:1; unsigned int v2:1; signed int v3:1; signed short v4:1; };
struct BFs1c_BFu1i_BFs1i_BFu1c { signed char v1:1; unsigned int v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1c_BFu1i_BFs1i_BFu1i { signed char v1:1; unsigned int v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1c_BFu1i_BFs1i_BFu1ll { signed char v1:1; unsigned int v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1i_BFs1i_BFu1s { signed char v1:1; unsigned int v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1c_BFu1i_BFs1ll { signed char v1:1; unsigned int v2:1; signed long long v3:1; };
struct BFs1c_BFu1i_BFs1ll_BFs1c { signed char v1:1; unsigned int v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1c_BFu1i_BFs1ll_BFs1i { signed char v1:1; unsigned int v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1c_BFu1i_BFs1ll_BFs1ll { signed char v1:1; unsigned int v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1c_BFu1i_BFs1ll_BFs1s { signed char v1:1; unsigned int v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1c_BFu1i_BFs1ll_BFu1c { signed char v1:1; unsigned int v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1c_BFu1i_BFs1ll_BFu1i { signed char v1:1; unsigned int v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1c_BFu1i_BFs1ll_BFu1ll { signed char v1:1; unsigned int v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1i_BFs1ll_BFu1s { signed char v1:1; unsigned int v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1c_BFu1i_BFs1s { signed char v1:1; unsigned int v2:1; signed short v3:1; };
struct BFs1c_BFu1i_BFs1s_BFs1c { signed char v1:1; unsigned int v2:1; signed short v3:1; signed char v4:1; };
struct BFs1c_BFu1i_BFs1s_BFs1i { signed char v1:1; unsigned int v2:1; signed short v3:1; signed int v4:1; };
struct BFs1c_BFu1i_BFs1s_BFs1ll { signed char v1:1; unsigned int v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1c_BFu1i_BFs1s_BFs1s { signed char v1:1; unsigned int v2:1; signed short v3:1; signed short v4:1; };
struct BFs1c_BFu1i_BFs1s_BFu1c { signed char v1:1; unsigned int v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1c_BFu1i_BFs1s_BFu1i { signed char v1:1; unsigned int v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1c_BFu1i_BFs1s_BFu1ll { signed char v1:1; unsigned int v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1i_BFs1s_BFu1s { signed char v1:1; unsigned int v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1c_BFu1i_BFu1c { signed char v1:1; unsigned int v2:1; unsigned char v3:1; };
struct BFs1c_BFu1i_BFu1c_BFs1c { signed char v1:1; unsigned int v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1c_BFu1i_BFu1c_BFs1i { signed char v1:1; unsigned int v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1c_BFu1i_BFu1c_BFs1ll { signed char v1:1; unsigned int v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1c_BFu1i_BFu1c_BFs1s { signed char v1:1; unsigned int v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1c_BFu1i_BFu1c_BFu1c { signed char v1:1; unsigned int v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1c_BFu1i_BFu1c_BFu1i { signed char v1:1; unsigned int v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1c_BFu1i_BFu1c_BFu1ll { signed char v1:1; unsigned int v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1i_BFu1c_BFu1s { signed char v1:1; unsigned int v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1c_BFu1i_BFu1i { signed char v1:1; unsigned int v2:1; unsigned int v3:1; };
struct BFs1c_BFu1i_BFu1i_BFs1c { signed char v1:1; unsigned int v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1c_BFu1i_BFu1i_BFs1i { signed char v1:1; unsigned int v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1c_BFu1i_BFu1i_BFs1ll { signed char v1:1; unsigned int v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1c_BFu1i_BFu1i_BFs1s { signed char v1:1; unsigned int v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1c_BFu1i_BFu1i_BFu1c { signed char v1:1; unsigned int v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1c_BFu1i_BFu1i_BFu1i { signed char v1:1; unsigned int v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1c_BFu1i_BFu1i_BFu1ll { signed char v1:1; unsigned int v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1i_BFu1i_BFu1s { signed char v1:1; unsigned int v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1c_BFu1i_BFu1ll { signed char v1:1; unsigned int v2:1; unsigned long long v3:1; };
struct BFs1c_BFu1i_BFu1ll_BFs1c { signed char v1:1; unsigned int v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1c_BFu1i_BFu1ll_BFs1i { signed char v1:1; unsigned int v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1c_BFu1i_BFu1ll_BFs1ll { signed char v1:1; unsigned int v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1c_BFu1i_BFu1ll_BFs1s { signed char v1:1; unsigned int v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1c_BFu1i_BFu1ll_BFu1c { signed char v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1c_BFu1i_BFu1ll_BFu1i { signed char v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1c_BFu1i_BFu1ll_BFu1ll { signed char v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1i_BFu1ll_BFu1s { signed char v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1c_BFu1i_BFu1s { signed char v1:1; unsigned int v2:1; unsigned short v3:1; };
struct BFs1c_BFu1i_BFu1s_BFs1c { signed char v1:1; unsigned int v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1c_BFu1i_BFu1s_BFs1i { signed char v1:1; unsigned int v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1c_BFu1i_BFu1s_BFs1ll { signed char v1:1; unsigned int v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1c_BFu1i_BFu1s_BFs1s { signed char v1:1; unsigned int v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1c_BFu1i_BFu1s_BFu1c { signed char v1:1; unsigned int v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1c_BFu1i_BFu1s_BFu1i { signed char v1:1; unsigned int v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1c_BFu1i_BFu1s_BFu1ll { signed char v1:1; unsigned int v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1i_BFu1s_BFu1s { signed char v1:1; unsigned int v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1c_BFu1ll { signed char v1:1; unsigned long long v2:1; };
struct BFs1c_BFu1ll_BFs1c { signed char v1:1; unsigned long long v2:1; signed char v3:1; };
struct BFs1c_BFu1ll_BFs1c_BFs1c { signed char v1:1; unsigned long long v2:1; signed char v3:1; signed char v4:1; };
struct BFs1c_BFu1ll_BFs1c_BFs1i { signed char v1:1; unsigned long long v2:1; signed char v3:1; signed int v4:1; };
struct BFs1c_BFu1ll_BFs1c_BFs1ll { signed char v1:1; unsigned long long v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1c_BFu1ll_BFs1c_BFs1s { signed char v1:1; unsigned long long v2:1; signed char v3:1; signed short v4:1; };
struct BFs1c_BFu1ll_BFs1c_BFu1c { signed char v1:1; unsigned long long v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1c_BFu1ll_BFs1c_BFu1i { signed char v1:1; unsigned long long v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1c_BFu1ll_BFs1c_BFu1ll { signed char v1:1; unsigned long long v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1ll_BFs1c_BFu1s { signed char v1:1; unsigned long long v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1c_BFu1ll_BFs1i { signed char v1:1; unsigned long long v2:1; signed int v3:1; };
struct BFs1c_BFu1ll_BFs1i_BFs1c { signed char v1:1; unsigned long long v2:1; signed int v3:1; signed char v4:1; };
struct BFs1c_BFu1ll_BFs1i_BFs1i { signed char v1:1; unsigned long long v2:1; signed int v3:1; signed int v4:1; };
struct BFs1c_BFu1ll_BFs1i_BFs1ll { signed char v1:1; unsigned long long v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1c_BFu1ll_BFs1i_BFs1s { signed char v1:1; unsigned long long v2:1; signed int v3:1; signed short v4:1; };
struct BFs1c_BFu1ll_BFs1i_BFu1c { signed char v1:1; unsigned long long v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1c_BFu1ll_BFs1i_BFu1i { signed char v1:1; unsigned long long v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1c_BFu1ll_BFs1i_BFu1ll { signed char v1:1; unsigned long long v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1ll_BFs1i_BFu1s { signed char v1:1; unsigned long long v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1c_BFu1ll_BFs1ll { signed char v1:1; unsigned long long v2:1; signed long long v3:1; };
struct BFs1c_BFu1ll_BFs1ll_BFs1c { signed char v1:1; unsigned long long v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1c_BFu1ll_BFs1ll_BFs1i { signed char v1:1; unsigned long long v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1c_BFu1ll_BFs1ll_BFs1ll { signed char v1:1; unsigned long long v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1c_BFu1ll_BFs1ll_BFs1s { signed char v1:1; unsigned long long v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1c_BFu1ll_BFs1ll_BFu1c { signed char v1:1; unsigned long long v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1c_BFu1ll_BFs1ll_BFu1i { signed char v1:1; unsigned long long v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1c_BFu1ll_BFs1ll_BFu1ll { signed char v1:1; unsigned long long v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1ll_BFs1ll_BFu1s { signed char v1:1; unsigned long long v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1c_BFu1ll_BFs1s { signed char v1:1; unsigned long long v2:1; signed short v3:1; };
struct BFs1c_BFu1ll_BFs1s_BFs1c { signed char v1:1; unsigned long long v2:1; signed short v3:1; signed char v4:1; };
struct BFs1c_BFu1ll_BFs1s_BFs1i { signed char v1:1; unsigned long long v2:1; signed short v3:1; signed int v4:1; };
struct BFs1c_BFu1ll_BFs1s_BFs1ll { signed char v1:1; unsigned long long v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1c_BFu1ll_BFs1s_BFs1s { signed char v1:1; unsigned long long v2:1; signed short v3:1; signed short v4:1; };
struct BFs1c_BFu1ll_BFs1s_BFu1c { signed char v1:1; unsigned long long v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1c_BFu1ll_BFs1s_BFu1i { signed char v1:1; unsigned long long v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1c_BFu1ll_BFs1s_BFu1ll { signed char v1:1; unsigned long long v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1ll_BFs1s_BFu1s { signed char v1:1; unsigned long long v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1c_BFu1ll_BFu1c { signed char v1:1; unsigned long long v2:1; unsigned char v3:1; };
struct BFs1c_BFu1ll_BFu1c_BFs1c { signed char v1:1; unsigned long long v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1c_BFu1ll_BFu1c_BFs1i { signed char v1:1; unsigned long long v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1c_BFu1ll_BFu1c_BFs1ll { signed char v1:1; unsigned long long v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1c_BFu1ll_BFu1c_BFs1s { signed char v1:1; unsigned long long v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1c_BFu1ll_BFu1c_BFu1c { signed char v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1c_BFu1ll_BFu1c_BFu1i { signed char v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1c_BFu1ll_BFu1c_BFu1ll { signed char v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1ll_BFu1c_BFu1s { signed char v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1c_BFu1ll_BFu1i { signed char v1:1; unsigned long long v2:1; unsigned int v3:1; };
struct BFs1c_BFu1ll_BFu1i_BFs1c { signed char v1:1; unsigned long long v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1c_BFu1ll_BFu1i_BFs1i { signed char v1:1; unsigned long long v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1c_BFu1ll_BFu1i_BFs1ll { signed char v1:1; unsigned long long v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1c_BFu1ll_BFu1i_BFs1s { signed char v1:1; unsigned long long v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1c_BFu1ll_BFu1i_BFu1c { signed char v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1c_BFu1ll_BFu1i_BFu1i { signed char v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1c_BFu1ll_BFu1i_BFu1ll { signed char v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1ll_BFu1i_BFu1s { signed char v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1c_BFu1ll_BFu1ll { signed char v1:1; unsigned long long v2:1; unsigned long long v3:1; };
struct BFs1c_BFu1ll_BFu1ll_BFs1c { signed char v1:1; unsigned long long v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1c_BFu1ll_BFu1ll_BFs1i { signed char v1:1; unsigned long long v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1c_BFu1ll_BFu1ll_BFs1ll { signed char v1:1; unsigned long long v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1c_BFu1ll_BFu1ll_BFs1s { signed char v1:1; unsigned long long v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1c_BFu1ll_BFu1ll_BFu1c { signed char v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1c_BFu1ll_BFu1ll_BFu1i { signed char v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1c_BFu1ll_BFu1ll_BFu1ll { signed char v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1ll_BFu1ll_BFu1s { signed char v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1c_BFu1ll_BFu1s { signed char v1:1; unsigned long long v2:1; unsigned short v3:1; };
struct BFs1c_BFu1ll_BFu1s_BFs1c { signed char v1:1; unsigned long long v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1c_BFu1ll_BFu1s_BFs1i { signed char v1:1; unsigned long long v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1c_BFu1ll_BFu1s_BFs1ll { signed char v1:1; unsigned long long v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1c_BFu1ll_BFu1s_BFs1s { signed char v1:1; unsigned long long v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1c_BFu1ll_BFu1s_BFu1c { signed char v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1c_BFu1ll_BFu1s_BFu1i { signed char v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1c_BFu1ll_BFu1s_BFu1ll { signed char v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1ll_BFu1s_BFu1s { signed char v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1c_BFu1s { signed char v1:1; unsigned short v2:1; };
struct BFs1c_BFu1s_BFs1c { signed char v1:1; unsigned short v2:1; signed char v3:1; };
struct BFs1c_BFu1s_BFs1c_BFs1c { signed char v1:1; unsigned short v2:1; signed char v3:1; signed char v4:1; };
struct BFs1c_BFu1s_BFs1c_BFs1i { signed char v1:1; unsigned short v2:1; signed char v3:1; signed int v4:1; };
struct BFs1c_BFu1s_BFs1c_BFs1ll { signed char v1:1; unsigned short v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1c_BFu1s_BFs1c_BFs1s { signed char v1:1; unsigned short v2:1; signed char v3:1; signed short v4:1; };
struct BFs1c_BFu1s_BFs1c_BFu1c { signed char v1:1; unsigned short v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1c_BFu1s_BFs1c_BFu1i { signed char v1:1; unsigned short v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1c_BFu1s_BFs1c_BFu1ll { signed char v1:1; unsigned short v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1s_BFs1c_BFu1s { signed char v1:1; unsigned short v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1c_BFu1s_BFs1i { signed char v1:1; unsigned short v2:1; signed int v3:1; };
struct BFs1c_BFu1s_BFs1i_BFs1c { signed char v1:1; unsigned short v2:1; signed int v3:1; signed char v4:1; };
struct BFs1c_BFu1s_BFs1i_BFs1i { signed char v1:1; unsigned short v2:1; signed int v3:1; signed int v4:1; };
struct BFs1c_BFu1s_BFs1i_BFs1ll { signed char v1:1; unsigned short v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1c_BFu1s_BFs1i_BFs1s { signed char v1:1; unsigned short v2:1; signed int v3:1; signed short v4:1; };
struct BFs1c_BFu1s_BFs1i_BFu1c { signed char v1:1; unsigned short v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1c_BFu1s_BFs1i_BFu1i { signed char v1:1; unsigned short v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1c_BFu1s_BFs1i_BFu1ll { signed char v1:1; unsigned short v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1s_BFs1i_BFu1s { signed char v1:1; unsigned short v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1c_BFu1s_BFs1ll { signed char v1:1; unsigned short v2:1; signed long long v3:1; };
struct BFs1c_BFu1s_BFs1ll_BFs1c { signed char v1:1; unsigned short v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1c_BFu1s_BFs1ll_BFs1i { signed char v1:1; unsigned short v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1c_BFu1s_BFs1ll_BFs1ll { signed char v1:1; unsigned short v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1c_BFu1s_BFs1ll_BFs1s { signed char v1:1; unsigned short v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1c_BFu1s_BFs1ll_BFu1c { signed char v1:1; unsigned short v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1c_BFu1s_BFs1ll_BFu1i { signed char v1:1; unsigned short v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1c_BFu1s_BFs1ll_BFu1ll { signed char v1:1; unsigned short v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1s_BFs1ll_BFu1s { signed char v1:1; unsigned short v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1c_BFu1s_BFs1s { signed char v1:1; unsigned short v2:1; signed short v3:1; };
struct BFs1c_BFu1s_BFs1s_BFs1c { signed char v1:1; unsigned short v2:1; signed short v3:1; signed char v4:1; };
struct BFs1c_BFu1s_BFs1s_BFs1i { signed char v1:1; unsigned short v2:1; signed short v3:1; signed int v4:1; };
struct BFs1c_BFu1s_BFs1s_BFs1ll { signed char v1:1; unsigned short v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1c_BFu1s_BFs1s_BFs1s { signed char v1:1; unsigned short v2:1; signed short v3:1; signed short v4:1; };
struct BFs1c_BFu1s_BFs1s_BFu1c { signed char v1:1; unsigned short v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1c_BFu1s_BFs1s_BFu1i { signed char v1:1; unsigned short v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1c_BFu1s_BFs1s_BFu1ll { signed char v1:1; unsigned short v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1s_BFs1s_BFu1s { signed char v1:1; unsigned short v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1c_BFu1s_BFu1c { signed char v1:1; unsigned short v2:1; unsigned char v3:1; };
struct BFs1c_BFu1s_BFu1c_BFs1c { signed char v1:1; unsigned short v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1c_BFu1s_BFu1c_BFs1i { signed char v1:1; unsigned short v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1c_BFu1s_BFu1c_BFs1ll { signed char v1:1; unsigned short v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1c_BFu1s_BFu1c_BFs1s { signed char v1:1; unsigned short v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1c_BFu1s_BFu1c_BFu1c { signed char v1:1; unsigned short v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1c_BFu1s_BFu1c_BFu1i { signed char v1:1; unsigned short v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1c_BFu1s_BFu1c_BFu1ll { signed char v1:1; unsigned short v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1s_BFu1c_BFu1s { signed char v1:1; unsigned short v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1c_BFu1s_BFu1i { signed char v1:1; unsigned short v2:1; unsigned int v3:1; };
struct BFs1c_BFu1s_BFu1i_BFs1c { signed char v1:1; unsigned short v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1c_BFu1s_BFu1i_BFs1i { signed char v1:1; unsigned short v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1c_BFu1s_BFu1i_BFs1ll { signed char v1:1; unsigned short v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1c_BFu1s_BFu1i_BFs1s { signed char v1:1; unsigned short v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1c_BFu1s_BFu1i_BFu1c { signed char v1:1; unsigned short v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1c_BFu1s_BFu1i_BFu1i { signed char v1:1; unsigned short v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1c_BFu1s_BFu1i_BFu1ll { signed char v1:1; unsigned short v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1s_BFu1i_BFu1s { signed char v1:1; unsigned short v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1c_BFu1s_BFu1ll { signed char v1:1; unsigned short v2:1; unsigned long long v3:1; };
struct BFs1c_BFu1s_BFu1ll_BFs1c { signed char v1:1; unsigned short v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1c_BFu1s_BFu1ll_BFs1i { signed char v1:1; unsigned short v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1c_BFu1s_BFu1ll_BFs1ll { signed char v1:1; unsigned short v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1c_BFu1s_BFu1ll_BFs1s { signed char v1:1; unsigned short v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1c_BFu1s_BFu1ll_BFu1c { signed char v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1c_BFu1s_BFu1ll_BFu1i { signed char v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1c_BFu1s_BFu1ll_BFu1ll { signed char v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1s_BFu1ll_BFu1s { signed char v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1c_BFu1s_BFu1s { signed char v1:1; unsigned short v2:1; unsigned short v3:1; };
struct BFs1c_BFu1s_BFu1s_BFs1c { signed char v1:1; unsigned short v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1c_BFu1s_BFu1s_BFs1i { signed char v1:1; unsigned short v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1c_BFu1s_BFu1s_BFs1ll { signed char v1:1; unsigned short v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1c_BFu1s_BFu1s_BFs1s { signed char v1:1; unsigned short v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1c_BFu1s_BFu1s_BFu1c { signed char v1:1; unsigned short v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1c_BFu1s_BFu1s_BFu1i { signed char v1:1; unsigned short v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1c_BFu1s_BFu1s_BFu1ll { signed char v1:1; unsigned short v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1c_BFu1s_BFu1s_BFu1s { signed char v1:1; unsigned short v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1i_BFs1c { signed int v1:1; signed char v2:1; };
struct BFs1i_BFs1c_BFs1c { signed int v1:1; signed char v2:1; signed char v3:1; };
struct BFs1i_BFs1c_BFs1c_BFs1c { signed int v1:1; signed char v2:1; signed char v3:1; signed char v4:1; };
struct BFs1i_BFs1c_BFs1c_BFs1i { signed int v1:1; signed char v2:1; signed char v3:1; signed int v4:1; };
struct BFs1i_BFs1c_BFs1c_BFs1ll { signed int v1:1; signed char v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1i_BFs1c_BFs1c_BFs1s { signed int v1:1; signed char v2:1; signed char v3:1; signed short v4:1; };
struct BFs1i_BFs1c_BFs1c_BFu1c { signed int v1:1; signed char v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1i_BFs1c_BFs1c_BFu1i { signed int v1:1; signed char v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1i_BFs1c_BFs1c_BFu1ll { signed int v1:1; signed char v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1c_BFs1c_BFu1s { signed int v1:1; signed char v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1i_BFs1c_BFs1i { signed int v1:1; signed char v2:1; signed int v3:1; };
struct BFs1i_BFs1c_BFs1i_BFs1c { signed int v1:1; signed char v2:1; signed int v3:1; signed char v4:1; };
struct BFs1i_BFs1c_BFs1i_BFs1i { signed int v1:1; signed char v2:1; signed int v3:1; signed int v4:1; };
struct BFs1i_BFs1c_BFs1i_BFs1ll { signed int v1:1; signed char v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1i_BFs1c_BFs1i_BFs1s { signed int v1:1; signed char v2:1; signed int v3:1; signed short v4:1; };
struct BFs1i_BFs1c_BFs1i_BFu1c { signed int v1:1; signed char v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1i_BFs1c_BFs1i_BFu1i { signed int v1:1; signed char v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1i_BFs1c_BFs1i_BFu1ll { signed int v1:1; signed char v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1c_BFs1i_BFu1s { signed int v1:1; signed char v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1i_BFs1c_BFs1ll { signed int v1:1; signed char v2:1; signed long long v3:1; };
struct BFs1i_BFs1c_BFs1ll_BFs1c { signed int v1:1; signed char v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1i_BFs1c_BFs1ll_BFs1i { signed int v1:1; signed char v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1i_BFs1c_BFs1ll_BFs1ll { signed int v1:1; signed char v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1i_BFs1c_BFs1ll_BFs1s { signed int v1:1; signed char v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1i_BFs1c_BFs1ll_BFu1c { signed int v1:1; signed char v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1i_BFs1c_BFs1ll_BFu1i { signed int v1:1; signed char v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1i_BFs1c_BFs1ll_BFu1ll { signed int v1:1; signed char v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1c_BFs1ll_BFu1s { signed int v1:1; signed char v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1i_BFs1c_BFs1s { signed int v1:1; signed char v2:1; signed short v3:1; };
struct BFs1i_BFs1c_BFs1s_BFs1c { signed int v1:1; signed char v2:1; signed short v3:1; signed char v4:1; };
struct BFs1i_BFs1c_BFs1s_BFs1i { signed int v1:1; signed char v2:1; signed short v3:1; signed int v4:1; };
struct BFs1i_BFs1c_BFs1s_BFs1ll { signed int v1:1; signed char v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1i_BFs1c_BFs1s_BFs1s { signed int v1:1; signed char v2:1; signed short v3:1; signed short v4:1; };
struct BFs1i_BFs1c_BFs1s_BFu1c { signed int v1:1; signed char v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1i_BFs1c_BFs1s_BFu1i { signed int v1:1; signed char v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1i_BFs1c_BFs1s_BFu1ll { signed int v1:1; signed char v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1c_BFs1s_BFu1s { signed int v1:1; signed char v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1i_BFs1c_BFu1c { signed int v1:1; signed char v2:1; unsigned char v3:1; };
struct BFs1i_BFs1c_BFu1c_BFs1c { signed int v1:1; signed char v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1i_BFs1c_BFu1c_BFs1i { signed int v1:1; signed char v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1i_BFs1c_BFu1c_BFs1ll { signed int v1:1; signed char v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1i_BFs1c_BFu1c_BFs1s { signed int v1:1; signed char v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1i_BFs1c_BFu1c_BFu1c { signed int v1:1; signed char v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1i_BFs1c_BFu1c_BFu1i { signed int v1:1; signed char v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1i_BFs1c_BFu1c_BFu1ll { signed int v1:1; signed char v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1c_BFu1c_BFu1s { signed int v1:1; signed char v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1i_BFs1c_BFu1i { signed int v1:1; signed char v2:1; unsigned int v3:1; };
struct BFs1i_BFs1c_BFu1i_BFs1c { signed int v1:1; signed char v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1i_BFs1c_BFu1i_BFs1i { signed int v1:1; signed char v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1i_BFs1c_BFu1i_BFs1ll { signed int v1:1; signed char v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1i_BFs1c_BFu1i_BFs1s { signed int v1:1; signed char v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1i_BFs1c_BFu1i_BFu1c { signed int v1:1; signed char v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1i_BFs1c_BFu1i_BFu1i { signed int v1:1; signed char v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1i_BFs1c_BFu1i_BFu1ll { signed int v1:1; signed char v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1c_BFu1i_BFu1s { signed int v1:1; signed char v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1i_BFs1c_BFu1ll { signed int v1:1; signed char v2:1; unsigned long long v3:1; };
struct BFs1i_BFs1c_BFu1ll_BFs1c { signed int v1:1; signed char v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1i_BFs1c_BFu1ll_BFs1i { signed int v1:1; signed char v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1i_BFs1c_BFu1ll_BFs1ll { signed int v1:1; signed char v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1i_BFs1c_BFu1ll_BFs1s { signed int v1:1; signed char v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1i_BFs1c_BFu1ll_BFu1c { signed int v1:1; signed char v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1i_BFs1c_BFu1ll_BFu1i { signed int v1:1; signed char v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1i_BFs1c_BFu1ll_BFu1ll { signed int v1:1; signed char v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1c_BFu1ll_BFu1s { signed int v1:1; signed char v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1i_BFs1c_BFu1s { signed int v1:1; signed char v2:1; unsigned short v3:1; };
struct BFs1i_BFs1c_BFu1s_BFs1c { signed int v1:1; signed char v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1i_BFs1c_BFu1s_BFs1i { signed int v1:1; signed char v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1i_BFs1c_BFu1s_BFs1ll { signed int v1:1; signed char v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1i_BFs1c_BFu1s_BFs1s { signed int v1:1; signed char v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1i_BFs1c_BFu1s_BFu1c { signed int v1:1; signed char v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1i_BFs1c_BFu1s_BFu1i { signed int v1:1; signed char v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1i_BFs1c_BFu1s_BFu1ll { signed int v1:1; signed char v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1c_BFu1s_BFu1s { signed int v1:1; signed char v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1i_BFs1i { signed int v1:1; signed int v2:1; };
struct BFs1i_BFs1i_BFs1c { signed int v1:1; signed int v2:1; signed char v3:1; };
struct BFs1i_BFs1i_BFs1c_BFs1c { signed int v1:1; signed int v2:1; signed char v3:1; signed char v4:1; };
struct BFs1i_BFs1i_BFs1c_BFs1i { signed int v1:1; signed int v2:1; signed char v3:1; signed int v4:1; };
struct BFs1i_BFs1i_BFs1c_BFs1ll { signed int v1:1; signed int v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1i_BFs1i_BFs1c_BFs1s { signed int v1:1; signed int v2:1; signed char v3:1; signed short v4:1; };
struct BFs1i_BFs1i_BFs1c_BFu1c { signed int v1:1; signed int v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1i_BFs1i_BFs1c_BFu1i { signed int v1:1; signed int v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1i_BFs1i_BFs1c_BFu1ll { signed int v1:1; signed int v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1i_BFs1c_BFu1s { signed int v1:1; signed int v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1i_BFs1i_BFs1i { signed int v1:1; signed int v2:1; signed int v3:1; };
struct BFs1i_BFs1i_BFs1i_BFs1c { signed int v1:1; signed int v2:1; signed int v3:1; signed char v4:1; };
struct BFs1i_BFs1i_BFs1i_BFs1i { signed int v1:1; signed int v2:1; signed int v3:1; signed int v4:1; };
struct BFs1i_BFs1i_BFs1i_BFs1ll { signed int v1:1; signed int v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1i_BFs1i_BFs1i_BFs1s { signed int v1:1; signed int v2:1; signed int v3:1; signed short v4:1; };
struct BFs1i_BFs1i_BFs1i_BFu1c { signed int v1:1; signed int v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1i_BFs1i_BFs1i_BFu1i { signed int v1:1; signed int v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1i_BFs1i_BFs1i_BFu1ll { signed int v1:1; signed int v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1i_BFs1i_BFu1s { signed int v1:1; signed int v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1i_BFs1i_BFs1ll { signed int v1:1; signed int v2:1; signed long long v3:1; };
struct BFs1i_BFs1i_BFs1ll_BFs1c { signed int v1:1; signed int v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1i_BFs1i_BFs1ll_BFs1i { signed int v1:1; signed int v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1i_BFs1i_BFs1ll_BFs1ll { signed int v1:1; signed int v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1i_BFs1i_BFs1ll_BFs1s { signed int v1:1; signed int v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1i_BFs1i_BFs1ll_BFu1c { signed int v1:1; signed int v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1i_BFs1i_BFs1ll_BFu1i { signed int v1:1; signed int v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1i_BFs1i_BFs1ll_BFu1ll { signed int v1:1; signed int v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1i_BFs1ll_BFu1s { signed int v1:1; signed int v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1i_BFs1i_BFs1s { signed int v1:1; signed int v2:1; signed short v3:1; };
struct BFs1i_BFs1i_BFs1s_BFs1c { signed int v1:1; signed int v2:1; signed short v3:1; signed char v4:1; };
struct BFs1i_BFs1i_BFs1s_BFs1i { signed int v1:1; signed int v2:1; signed short v3:1; signed int v4:1; };
struct BFs1i_BFs1i_BFs1s_BFs1ll { signed int v1:1; signed int v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1i_BFs1i_BFs1s_BFs1s { signed int v1:1; signed int v2:1; signed short v3:1; signed short v4:1; };
struct BFs1i_BFs1i_BFs1s_BFu1c { signed int v1:1; signed int v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1i_BFs1i_BFs1s_BFu1i { signed int v1:1; signed int v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1i_BFs1i_BFs1s_BFu1ll { signed int v1:1; signed int v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1i_BFs1s_BFu1s { signed int v1:1; signed int v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1i_BFs1i_BFu1c { signed int v1:1; signed int v2:1; unsigned char v3:1; };
struct BFs1i_BFs1i_BFu1c_BFs1c { signed int v1:1; signed int v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1i_BFs1i_BFu1c_BFs1i { signed int v1:1; signed int v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1i_BFs1i_BFu1c_BFs1ll { signed int v1:1; signed int v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1i_BFs1i_BFu1c_BFs1s { signed int v1:1; signed int v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1i_BFs1i_BFu1c_BFu1c { signed int v1:1; signed int v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1i_BFs1i_BFu1c_BFu1i { signed int v1:1; signed int v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1i_BFs1i_BFu1c_BFu1ll { signed int v1:1; signed int v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1i_BFu1c_BFu1s { signed int v1:1; signed int v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1i_BFs1i_BFu1i { signed int v1:1; signed int v2:1; unsigned int v3:1; };
struct BFs1i_BFs1i_BFu1i_BFs1c { signed int v1:1; signed int v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1i_BFs1i_BFu1i_BFs1i { signed int v1:1; signed int v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1i_BFs1i_BFu1i_BFs1ll { signed int v1:1; signed int v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1i_BFs1i_BFu1i_BFs1s { signed int v1:1; signed int v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1i_BFs1i_BFu1i_BFu1c { signed int v1:1; signed int v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1i_BFs1i_BFu1i_BFu1i { signed int v1:1; signed int v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1i_BFs1i_BFu1i_BFu1ll { signed int v1:1; signed int v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1i_BFu1i_BFu1s { signed int v1:1; signed int v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1i_BFs1i_BFu1ll { signed int v1:1; signed int v2:1; unsigned long long v3:1; };
struct BFs1i_BFs1i_BFu1ll_BFs1c { signed int v1:1; signed int v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1i_BFs1i_BFu1ll_BFs1i { signed int v1:1; signed int v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1i_BFs1i_BFu1ll_BFs1ll { signed int v1:1; signed int v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1i_BFs1i_BFu1ll_BFs1s { signed int v1:1; signed int v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1i_BFs1i_BFu1ll_BFu1c { signed int v1:1; signed int v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1i_BFs1i_BFu1ll_BFu1i { signed int v1:1; signed int v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1i_BFs1i_BFu1ll_BFu1ll { signed int v1:1; signed int v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1i_BFu1ll_BFu1s { signed int v1:1; signed int v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1i_BFs1i_BFu1s { signed int v1:1; signed int v2:1; unsigned short v3:1; };
struct BFs1i_BFs1i_BFu1s_BFs1c { signed int v1:1; signed int v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1i_BFs1i_BFu1s_BFs1i { signed int v1:1; signed int v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1i_BFs1i_BFu1s_BFs1ll { signed int v1:1; signed int v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1i_BFs1i_BFu1s_BFs1s { signed int v1:1; signed int v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1i_BFs1i_BFu1s_BFu1c { signed int v1:1; signed int v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1i_BFs1i_BFu1s_BFu1i { signed int v1:1; signed int v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1i_BFs1i_BFu1s_BFu1ll { signed int v1:1; signed int v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1i_BFu1s_BFu1s { signed int v1:1; signed int v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1i_BFs1ll { signed int v1:1; signed long long v2:1; };
struct BFs1i_BFs1ll_BFs1c { signed int v1:1; signed long long v2:1; signed char v3:1; };
struct BFs1i_BFs1ll_BFs1c_BFs1c { signed int v1:1; signed long long v2:1; signed char v3:1; signed char v4:1; };
struct BFs1i_BFs1ll_BFs1c_BFs1i { signed int v1:1; signed long long v2:1; signed char v3:1; signed int v4:1; };
struct BFs1i_BFs1ll_BFs1c_BFs1ll { signed int v1:1; signed long long v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1i_BFs1ll_BFs1c_BFs1s { signed int v1:1; signed long long v2:1; signed char v3:1; signed short v4:1; };
struct BFs1i_BFs1ll_BFs1c_BFu1c { signed int v1:1; signed long long v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1i_BFs1ll_BFs1c_BFu1i { signed int v1:1; signed long long v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1i_BFs1ll_BFs1c_BFu1ll { signed int v1:1; signed long long v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1ll_BFs1c_BFu1s { signed int v1:1; signed long long v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1i_BFs1ll_BFs1i { signed int v1:1; signed long long v2:1; signed int v3:1; };
struct BFs1i_BFs1ll_BFs1i_BFs1c { signed int v1:1; signed long long v2:1; signed int v3:1; signed char v4:1; };
struct BFs1i_BFs1ll_BFs1i_BFs1i { signed int v1:1; signed long long v2:1; signed int v3:1; signed int v4:1; };
struct BFs1i_BFs1ll_BFs1i_BFs1ll { signed int v1:1; signed long long v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1i_BFs1ll_BFs1i_BFs1s { signed int v1:1; signed long long v2:1; signed int v3:1; signed short v4:1; };
struct BFs1i_BFs1ll_BFs1i_BFu1c { signed int v1:1; signed long long v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1i_BFs1ll_BFs1i_BFu1i { signed int v1:1; signed long long v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1i_BFs1ll_BFs1i_BFu1ll { signed int v1:1; signed long long v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1ll_BFs1i_BFu1s { signed int v1:1; signed long long v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1i_BFs1ll_BFs1ll { signed int v1:1; signed long long v2:1; signed long long v3:1; };
struct BFs1i_BFs1ll_BFs1ll_BFs1c { signed int v1:1; signed long long v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1i_BFs1ll_BFs1ll_BFs1i { signed int v1:1; signed long long v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1i_BFs1ll_BFs1ll_BFs1ll { signed int v1:1; signed long long v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1i_BFs1ll_BFs1ll_BFs1s { signed int v1:1; signed long long v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1i_BFs1ll_BFs1ll_BFu1c { signed int v1:1; signed long long v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1i_BFs1ll_BFs1ll_BFu1i { signed int v1:1; signed long long v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1i_BFs1ll_BFs1ll_BFu1ll { signed int v1:1; signed long long v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1ll_BFs1ll_BFu1s { signed int v1:1; signed long long v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1i_BFs1ll_BFs1s { signed int v1:1; signed long long v2:1; signed short v3:1; };
struct BFs1i_BFs1ll_BFs1s_BFs1c { signed int v1:1; signed long long v2:1; signed short v3:1; signed char v4:1; };
struct BFs1i_BFs1ll_BFs1s_BFs1i { signed int v1:1; signed long long v2:1; signed short v3:1; signed int v4:1; };
struct BFs1i_BFs1ll_BFs1s_BFs1ll { signed int v1:1; signed long long v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1i_BFs1ll_BFs1s_BFs1s { signed int v1:1; signed long long v2:1; signed short v3:1; signed short v4:1; };
struct BFs1i_BFs1ll_BFs1s_BFu1c { signed int v1:1; signed long long v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1i_BFs1ll_BFs1s_BFu1i { signed int v1:1; signed long long v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1i_BFs1ll_BFs1s_BFu1ll { signed int v1:1; signed long long v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1ll_BFs1s_BFu1s { signed int v1:1; signed long long v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1i_BFs1ll_BFu1c { signed int v1:1; signed long long v2:1; unsigned char v3:1; };
struct BFs1i_BFs1ll_BFu1c_BFs1c { signed int v1:1; signed long long v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1i_BFs1ll_BFu1c_BFs1i { signed int v1:1; signed long long v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1i_BFs1ll_BFu1c_BFs1ll { signed int v1:1; signed long long v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1i_BFs1ll_BFu1c_BFs1s { signed int v1:1; signed long long v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1i_BFs1ll_BFu1c_BFu1c { signed int v1:1; signed long long v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1i_BFs1ll_BFu1c_BFu1i { signed int v1:1; signed long long v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1i_BFs1ll_BFu1c_BFu1ll { signed int v1:1; signed long long v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1ll_BFu1c_BFu1s { signed int v1:1; signed long long v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1i_BFs1ll_BFu1i { signed int v1:1; signed long long v2:1; unsigned int v3:1; };
struct BFs1i_BFs1ll_BFu1i_BFs1c { signed int v1:1; signed long long v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1i_BFs1ll_BFu1i_BFs1i { signed int v1:1; signed long long v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1i_BFs1ll_BFu1i_BFs1ll { signed int v1:1; signed long long v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1i_BFs1ll_BFu1i_BFs1s { signed int v1:1; signed long long v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1i_BFs1ll_BFu1i_BFu1c { signed int v1:1; signed long long v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1i_BFs1ll_BFu1i_BFu1i { signed int v1:1; signed long long v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1i_BFs1ll_BFu1i_BFu1ll { signed int v1:1; signed long long v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1ll_BFu1i_BFu1s { signed int v1:1; signed long long v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1i_BFs1ll_BFu1ll { signed int v1:1; signed long long v2:1; unsigned long long v3:1; };
struct BFs1i_BFs1ll_BFu1ll_BFs1c { signed int v1:1; signed long long v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1i_BFs1ll_BFu1ll_BFs1i { signed int v1:1; signed long long v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1i_BFs1ll_BFu1ll_BFs1ll { signed int v1:1; signed long long v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1i_BFs1ll_BFu1ll_BFs1s { signed int v1:1; signed long long v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1i_BFs1ll_BFu1ll_BFu1c { signed int v1:1; signed long long v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1i_BFs1ll_BFu1ll_BFu1i { signed int v1:1; signed long long v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1i_BFs1ll_BFu1ll_BFu1ll { signed int v1:1; signed long long v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1ll_BFu1ll_BFu1s { signed int v1:1; signed long long v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1i_BFs1ll_BFu1s { signed int v1:1; signed long long v2:1; unsigned short v3:1; };
struct BFs1i_BFs1ll_BFu1s_BFs1c { signed int v1:1; signed long long v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1i_BFs1ll_BFu1s_BFs1i { signed int v1:1; signed long long v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1i_BFs1ll_BFu1s_BFs1ll { signed int v1:1; signed long long v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1i_BFs1ll_BFu1s_BFs1s { signed int v1:1; signed long long v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1i_BFs1ll_BFu1s_BFu1c { signed int v1:1; signed long long v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1i_BFs1ll_BFu1s_BFu1i { signed int v1:1; signed long long v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1i_BFs1ll_BFu1s_BFu1ll { signed int v1:1; signed long long v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1ll_BFu1s_BFu1s { signed int v1:1; signed long long v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1i_BFs1s { signed int v1:1; signed short v2:1; };
struct BFs1i_BFs1s_BFs1c { signed int v1:1; signed short v2:1; signed char v3:1; };
struct BFs1i_BFs1s_BFs1c_BFs1c { signed int v1:1; signed short v2:1; signed char v3:1; signed char v4:1; };
struct BFs1i_BFs1s_BFs1c_BFs1i { signed int v1:1; signed short v2:1; signed char v3:1; signed int v4:1; };
struct BFs1i_BFs1s_BFs1c_BFs1ll { signed int v1:1; signed short v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1i_BFs1s_BFs1c_BFs1s { signed int v1:1; signed short v2:1; signed char v3:1; signed short v4:1; };
struct BFs1i_BFs1s_BFs1c_BFu1c { signed int v1:1; signed short v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1i_BFs1s_BFs1c_BFu1i { signed int v1:1; signed short v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1i_BFs1s_BFs1c_BFu1ll { signed int v1:1; signed short v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1s_BFs1c_BFu1s { signed int v1:1; signed short v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1i_BFs1s_BFs1i { signed int v1:1; signed short v2:1; signed int v3:1; };
struct BFs1i_BFs1s_BFs1i_BFs1c { signed int v1:1; signed short v2:1; signed int v3:1; signed char v4:1; };
struct BFs1i_BFs1s_BFs1i_BFs1i { signed int v1:1; signed short v2:1; signed int v3:1; signed int v4:1; };
struct BFs1i_BFs1s_BFs1i_BFs1ll { signed int v1:1; signed short v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1i_BFs1s_BFs1i_BFs1s { signed int v1:1; signed short v2:1; signed int v3:1; signed short v4:1; };
struct BFs1i_BFs1s_BFs1i_BFu1c { signed int v1:1; signed short v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1i_BFs1s_BFs1i_BFu1i { signed int v1:1; signed short v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1i_BFs1s_BFs1i_BFu1ll { signed int v1:1; signed short v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1s_BFs1i_BFu1s { signed int v1:1; signed short v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1i_BFs1s_BFs1ll { signed int v1:1; signed short v2:1; signed long long v3:1; };
struct BFs1i_BFs1s_BFs1ll_BFs1c { signed int v1:1; signed short v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1i_BFs1s_BFs1ll_BFs1i { signed int v1:1; signed short v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1i_BFs1s_BFs1ll_BFs1ll { signed int v1:1; signed short v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1i_BFs1s_BFs1ll_BFs1s { signed int v1:1; signed short v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1i_BFs1s_BFs1ll_BFu1c { signed int v1:1; signed short v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1i_BFs1s_BFs1ll_BFu1i { signed int v1:1; signed short v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1i_BFs1s_BFs1ll_BFu1ll { signed int v1:1; signed short v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1s_BFs1ll_BFu1s { signed int v1:1; signed short v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1i_BFs1s_BFs1s { signed int v1:1; signed short v2:1; signed short v3:1; };
struct BFs1i_BFs1s_BFs1s_BFs1c { signed int v1:1; signed short v2:1; signed short v3:1; signed char v4:1; };
struct BFs1i_BFs1s_BFs1s_BFs1i { signed int v1:1; signed short v2:1; signed short v3:1; signed int v4:1; };
struct BFs1i_BFs1s_BFs1s_BFs1ll { signed int v1:1; signed short v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1i_BFs1s_BFs1s_BFs1s { signed int v1:1; signed short v2:1; signed short v3:1; signed short v4:1; };
struct BFs1i_BFs1s_BFs1s_BFu1c { signed int v1:1; signed short v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1i_BFs1s_BFs1s_BFu1i { signed int v1:1; signed short v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1i_BFs1s_BFs1s_BFu1ll { signed int v1:1; signed short v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1s_BFs1s_BFu1s { signed int v1:1; signed short v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1i_BFs1s_BFu1c { signed int v1:1; signed short v2:1; unsigned char v3:1; };
struct BFs1i_BFs1s_BFu1c_BFs1c { signed int v1:1; signed short v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1i_BFs1s_BFu1c_BFs1i { signed int v1:1; signed short v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1i_BFs1s_BFu1c_BFs1ll { signed int v1:1; signed short v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1i_BFs1s_BFu1c_BFs1s { signed int v1:1; signed short v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1i_BFs1s_BFu1c_BFu1c { signed int v1:1; signed short v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1i_BFs1s_BFu1c_BFu1i { signed int v1:1; signed short v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1i_BFs1s_BFu1c_BFu1ll { signed int v1:1; signed short v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1s_BFu1c_BFu1s { signed int v1:1; signed short v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1i_BFs1s_BFu1i { signed int v1:1; signed short v2:1; unsigned int v3:1; };
struct BFs1i_BFs1s_BFu1i_BFs1c { signed int v1:1; signed short v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1i_BFs1s_BFu1i_BFs1i { signed int v1:1; signed short v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1i_BFs1s_BFu1i_BFs1ll { signed int v1:1; signed short v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1i_BFs1s_BFu1i_BFs1s { signed int v1:1; signed short v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1i_BFs1s_BFu1i_BFu1c { signed int v1:1; signed short v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1i_BFs1s_BFu1i_BFu1i { signed int v1:1; signed short v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1i_BFs1s_BFu1i_BFu1ll { signed int v1:1; signed short v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1s_BFu1i_BFu1s { signed int v1:1; signed short v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1i_BFs1s_BFu1ll { signed int v1:1; signed short v2:1; unsigned long long v3:1; };
struct BFs1i_BFs1s_BFu1ll_BFs1c { signed int v1:1; signed short v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1i_BFs1s_BFu1ll_BFs1i { signed int v1:1; signed short v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1i_BFs1s_BFu1ll_BFs1ll { signed int v1:1; signed short v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1i_BFs1s_BFu1ll_BFs1s { signed int v1:1; signed short v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1i_BFs1s_BFu1ll_BFu1c { signed int v1:1; signed short v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1i_BFs1s_BFu1ll_BFu1i { signed int v1:1; signed short v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1i_BFs1s_BFu1ll_BFu1ll { signed int v1:1; signed short v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1s_BFu1ll_BFu1s { signed int v1:1; signed short v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1i_BFs1s_BFu1s { signed int v1:1; signed short v2:1; unsigned short v3:1; };
struct BFs1i_BFs1s_BFu1s_BFs1c { signed int v1:1; signed short v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1i_BFs1s_BFu1s_BFs1i { signed int v1:1; signed short v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1i_BFs1s_BFu1s_BFs1ll { signed int v1:1; signed short v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1i_BFs1s_BFu1s_BFs1s { signed int v1:1; signed short v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1i_BFs1s_BFu1s_BFu1c { signed int v1:1; signed short v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1i_BFs1s_BFu1s_BFu1i { signed int v1:1; signed short v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1i_BFs1s_BFu1s_BFu1ll { signed int v1:1; signed short v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1i_BFs1s_BFu1s_BFu1s { signed int v1:1; signed short v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1i_BFu1c { signed int v1:1; unsigned char v2:1; };
struct BFs1i_BFu1c_BFs1c { signed int v1:1; unsigned char v2:1; signed char v3:1; };
struct BFs1i_BFu1c_BFs1c_BFs1c { signed int v1:1; unsigned char v2:1; signed char v3:1; signed char v4:1; };
struct BFs1i_BFu1c_BFs1c_BFs1i { signed int v1:1; unsigned char v2:1; signed char v3:1; signed int v4:1; };
struct BFs1i_BFu1c_BFs1c_BFs1ll { signed int v1:1; unsigned char v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1i_BFu1c_BFs1c_BFs1s { signed int v1:1; unsigned char v2:1; signed char v3:1; signed short v4:1; };
struct BFs1i_BFu1c_BFs1c_BFu1c { signed int v1:1; unsigned char v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1i_BFu1c_BFs1c_BFu1i { signed int v1:1; unsigned char v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1i_BFu1c_BFs1c_BFu1ll { signed int v1:1; unsigned char v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1c_BFs1c_BFu1s { signed int v1:1; unsigned char v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1i_BFu1c_BFs1i { signed int v1:1; unsigned char v2:1; signed int v3:1; };
struct BFs1i_BFu1c_BFs1i_BFs1c { signed int v1:1; unsigned char v2:1; signed int v3:1; signed char v4:1; };
struct BFs1i_BFu1c_BFs1i_BFs1i { signed int v1:1; unsigned char v2:1; signed int v3:1; signed int v4:1; };
struct BFs1i_BFu1c_BFs1i_BFs1ll { signed int v1:1; unsigned char v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1i_BFu1c_BFs1i_BFs1s { signed int v1:1; unsigned char v2:1; signed int v3:1; signed short v4:1; };
struct BFs1i_BFu1c_BFs1i_BFu1c { signed int v1:1; unsigned char v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1i_BFu1c_BFs1i_BFu1i { signed int v1:1; unsigned char v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1i_BFu1c_BFs1i_BFu1ll { signed int v1:1; unsigned char v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1c_BFs1i_BFu1s { signed int v1:1; unsigned char v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1i_BFu1c_BFs1ll { signed int v1:1; unsigned char v2:1; signed long long v3:1; };
struct BFs1i_BFu1c_BFs1ll_BFs1c { signed int v1:1; unsigned char v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1i_BFu1c_BFs1ll_BFs1i { signed int v1:1; unsigned char v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1i_BFu1c_BFs1ll_BFs1ll { signed int v1:1; unsigned char v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1i_BFu1c_BFs1ll_BFs1s { signed int v1:1; unsigned char v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1i_BFu1c_BFs1ll_BFu1c { signed int v1:1; unsigned char v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1i_BFu1c_BFs1ll_BFu1i { signed int v1:1; unsigned char v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1i_BFu1c_BFs1ll_BFu1ll { signed int v1:1; unsigned char v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1c_BFs1ll_BFu1s { signed int v1:1; unsigned char v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1i_BFu1c_BFs1s { signed int v1:1; unsigned char v2:1; signed short v3:1; };
struct BFs1i_BFu1c_BFs1s_BFs1c { signed int v1:1; unsigned char v2:1; signed short v3:1; signed char v4:1; };
struct BFs1i_BFu1c_BFs1s_BFs1i { signed int v1:1; unsigned char v2:1; signed short v3:1; signed int v4:1; };
struct BFs1i_BFu1c_BFs1s_BFs1ll { signed int v1:1; unsigned char v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1i_BFu1c_BFs1s_BFs1s { signed int v1:1; unsigned char v2:1; signed short v3:1; signed short v4:1; };
struct BFs1i_BFu1c_BFs1s_BFu1c { signed int v1:1; unsigned char v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1i_BFu1c_BFs1s_BFu1i { signed int v1:1; unsigned char v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1i_BFu1c_BFs1s_BFu1ll { signed int v1:1; unsigned char v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1c_BFs1s_BFu1s { signed int v1:1; unsigned char v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1i_BFu1c_BFu1c { signed int v1:1; unsigned char v2:1; unsigned char v3:1; };
struct BFs1i_BFu1c_BFu1c_BFs1c { signed int v1:1; unsigned char v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1i_BFu1c_BFu1c_BFs1i { signed int v1:1; unsigned char v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1i_BFu1c_BFu1c_BFs1ll { signed int v1:1; unsigned char v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1i_BFu1c_BFu1c_BFs1s { signed int v1:1; unsigned char v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1i_BFu1c_BFu1c_BFu1c { signed int v1:1; unsigned char v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1i_BFu1c_BFu1c_BFu1i { signed int v1:1; unsigned char v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1i_BFu1c_BFu1c_BFu1ll { signed int v1:1; unsigned char v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1c_BFu1c_BFu1s { signed int v1:1; unsigned char v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1i_BFu1c_BFu1i { signed int v1:1; unsigned char v2:1; unsigned int v3:1; };
struct BFs1i_BFu1c_BFu1i_BFs1c { signed int v1:1; unsigned char v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1i_BFu1c_BFu1i_BFs1i { signed int v1:1; unsigned char v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1i_BFu1c_BFu1i_BFs1ll { signed int v1:1; unsigned char v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1i_BFu1c_BFu1i_BFs1s { signed int v1:1; unsigned char v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1i_BFu1c_BFu1i_BFu1c { signed int v1:1; unsigned char v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1i_BFu1c_BFu1i_BFu1i { signed int v1:1; unsigned char v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1i_BFu1c_BFu1i_BFu1ll { signed int v1:1; unsigned char v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1c_BFu1i_BFu1s { signed int v1:1; unsigned char v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1i_BFu1c_BFu1ll { signed int v1:1; unsigned char v2:1; unsigned long long v3:1; };
struct BFs1i_BFu1c_BFu1ll_BFs1c { signed int v1:1; unsigned char v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1i_BFu1c_BFu1ll_BFs1i { signed int v1:1; unsigned char v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1i_BFu1c_BFu1ll_BFs1ll { signed int v1:1; unsigned char v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1i_BFu1c_BFu1ll_BFs1s { signed int v1:1; unsigned char v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1i_BFu1c_BFu1ll_BFu1c { signed int v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1i_BFu1c_BFu1ll_BFu1i { signed int v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1i_BFu1c_BFu1ll_BFu1ll { signed int v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1c_BFu1ll_BFu1s { signed int v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1i_BFu1c_BFu1s { signed int v1:1; unsigned char v2:1; unsigned short v3:1; };
struct BFs1i_BFu1c_BFu1s_BFs1c { signed int v1:1; unsigned char v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1i_BFu1c_BFu1s_BFs1i { signed int v1:1; unsigned char v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1i_BFu1c_BFu1s_BFs1ll { signed int v1:1; unsigned char v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1i_BFu1c_BFu1s_BFs1s { signed int v1:1; unsigned char v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1i_BFu1c_BFu1s_BFu1c { signed int v1:1; unsigned char v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1i_BFu1c_BFu1s_BFu1i { signed int v1:1; unsigned char v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1i_BFu1c_BFu1s_BFu1ll { signed int v1:1; unsigned char v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1c_BFu1s_BFu1s { signed int v1:1; unsigned char v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1i_BFu1i { signed int v1:1; unsigned int v2:1; };
struct BFs1i_BFu1i_BFs1c { signed int v1:1; unsigned int v2:1; signed char v3:1; };
struct BFs1i_BFu1i_BFs1c_BFs1c { signed int v1:1; unsigned int v2:1; signed char v3:1; signed char v4:1; };
struct BFs1i_BFu1i_BFs1c_BFs1i { signed int v1:1; unsigned int v2:1; signed char v3:1; signed int v4:1; };
struct BFs1i_BFu1i_BFs1c_BFs1ll { signed int v1:1; unsigned int v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1i_BFu1i_BFs1c_BFs1s { signed int v1:1; unsigned int v2:1; signed char v3:1; signed short v4:1; };
struct BFs1i_BFu1i_BFs1c_BFu1c { signed int v1:1; unsigned int v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1i_BFu1i_BFs1c_BFu1i { signed int v1:1; unsigned int v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1i_BFu1i_BFs1c_BFu1ll { signed int v1:1; unsigned int v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1i_BFs1c_BFu1s { signed int v1:1; unsigned int v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1i_BFu1i_BFs1i { signed int v1:1; unsigned int v2:1; signed int v3:1; };
struct BFs1i_BFu1i_BFs1i_BFs1c { signed int v1:1; unsigned int v2:1; signed int v3:1; signed char v4:1; };
struct BFs1i_BFu1i_BFs1i_BFs1i { signed int v1:1; unsigned int v2:1; signed int v3:1; signed int v4:1; };
struct BFs1i_BFu1i_BFs1i_BFs1ll { signed int v1:1; unsigned int v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1i_BFu1i_BFs1i_BFs1s { signed int v1:1; unsigned int v2:1; signed int v3:1; signed short v4:1; };
struct BFs1i_BFu1i_BFs1i_BFu1c { signed int v1:1; unsigned int v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1i_BFu1i_BFs1i_BFu1i { signed int v1:1; unsigned int v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1i_BFu1i_BFs1i_BFu1ll { signed int v1:1; unsigned int v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1i_BFs1i_BFu1s { signed int v1:1; unsigned int v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1i_BFu1i_BFs1ll { signed int v1:1; unsigned int v2:1; signed long long v3:1; };
struct BFs1i_BFu1i_BFs1ll_BFs1c { signed int v1:1; unsigned int v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1i_BFu1i_BFs1ll_BFs1i { signed int v1:1; unsigned int v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1i_BFu1i_BFs1ll_BFs1ll { signed int v1:1; unsigned int v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1i_BFu1i_BFs1ll_BFs1s { signed int v1:1; unsigned int v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1i_BFu1i_BFs1ll_BFu1c { signed int v1:1; unsigned int v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1i_BFu1i_BFs1ll_BFu1i { signed int v1:1; unsigned int v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1i_BFu1i_BFs1ll_BFu1ll { signed int v1:1; unsigned int v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1i_BFs1ll_BFu1s { signed int v1:1; unsigned int v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1i_BFu1i_BFs1s { signed int v1:1; unsigned int v2:1; signed short v3:1; };
struct BFs1i_BFu1i_BFs1s_BFs1c { signed int v1:1; unsigned int v2:1; signed short v3:1; signed char v4:1; };
struct BFs1i_BFu1i_BFs1s_BFs1i { signed int v1:1; unsigned int v2:1; signed short v3:1; signed int v4:1; };
struct BFs1i_BFu1i_BFs1s_BFs1ll { signed int v1:1; unsigned int v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1i_BFu1i_BFs1s_BFs1s { signed int v1:1; unsigned int v2:1; signed short v3:1; signed short v4:1; };
struct BFs1i_BFu1i_BFs1s_BFu1c { signed int v1:1; unsigned int v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1i_BFu1i_BFs1s_BFu1i { signed int v1:1; unsigned int v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1i_BFu1i_BFs1s_BFu1ll { signed int v1:1; unsigned int v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1i_BFs1s_BFu1s { signed int v1:1; unsigned int v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1i_BFu1i_BFu1c { signed int v1:1; unsigned int v2:1; unsigned char v3:1; };
struct BFs1i_BFu1i_BFu1c_BFs1c { signed int v1:1; unsigned int v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1i_BFu1i_BFu1c_BFs1i { signed int v1:1; unsigned int v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1i_BFu1i_BFu1c_BFs1ll { signed int v1:1; unsigned int v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1i_BFu1i_BFu1c_BFs1s { signed int v1:1; unsigned int v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1i_BFu1i_BFu1c_BFu1c { signed int v1:1; unsigned int v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1i_BFu1i_BFu1c_BFu1i { signed int v1:1; unsigned int v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1i_BFu1i_BFu1c_BFu1ll { signed int v1:1; unsigned int v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1i_BFu1c_BFu1s { signed int v1:1; unsigned int v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1i_BFu1i_BFu1i { signed int v1:1; unsigned int v2:1; unsigned int v3:1; };
struct BFs1i_BFu1i_BFu1i_BFs1c { signed int v1:1; unsigned int v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1i_BFu1i_BFu1i_BFs1i { signed int v1:1; unsigned int v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1i_BFu1i_BFu1i_BFs1ll { signed int v1:1; unsigned int v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1i_BFu1i_BFu1i_BFs1s { signed int v1:1; unsigned int v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1i_BFu1i_BFu1i_BFu1c { signed int v1:1; unsigned int v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1i_BFu1i_BFu1i_BFu1i { signed int v1:1; unsigned int v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1i_BFu1i_BFu1i_BFu1ll { signed int v1:1; unsigned int v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1i_BFu1i_BFu1s { signed int v1:1; unsigned int v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1i_BFu1i_BFu1ll { signed int v1:1; unsigned int v2:1; unsigned long long v3:1; };
struct BFs1i_BFu1i_BFu1ll_BFs1c { signed int v1:1; unsigned int v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1i_BFu1i_BFu1ll_BFs1i { signed int v1:1; unsigned int v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1i_BFu1i_BFu1ll_BFs1ll { signed int v1:1; unsigned int v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1i_BFu1i_BFu1ll_BFs1s { signed int v1:1; unsigned int v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1i_BFu1i_BFu1ll_BFu1c { signed int v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1i_BFu1i_BFu1ll_BFu1i { signed int v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1i_BFu1i_BFu1ll_BFu1ll { signed int v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1i_BFu1ll_BFu1s { signed int v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1i_BFu1i_BFu1s { signed int v1:1; unsigned int v2:1; unsigned short v3:1; };
struct BFs1i_BFu1i_BFu1s_BFs1c { signed int v1:1; unsigned int v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1i_BFu1i_BFu1s_BFs1i { signed int v1:1; unsigned int v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1i_BFu1i_BFu1s_BFs1ll { signed int v1:1; unsigned int v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1i_BFu1i_BFu1s_BFs1s { signed int v1:1; unsigned int v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1i_BFu1i_BFu1s_BFu1c { signed int v1:1; unsigned int v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1i_BFu1i_BFu1s_BFu1i { signed int v1:1; unsigned int v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1i_BFu1i_BFu1s_BFu1ll { signed int v1:1; unsigned int v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1i_BFu1s_BFu1s { signed int v1:1; unsigned int v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1i_BFu1ll { signed int v1:1; unsigned long long v2:1; };
struct BFs1i_BFu1ll_BFs1c { signed int v1:1; unsigned long long v2:1; signed char v3:1; };
struct BFs1i_BFu1ll_BFs1c_BFs1c { signed int v1:1; unsigned long long v2:1; signed char v3:1; signed char v4:1; };
struct BFs1i_BFu1ll_BFs1c_BFs1i { signed int v1:1; unsigned long long v2:1; signed char v3:1; signed int v4:1; };
struct BFs1i_BFu1ll_BFs1c_BFs1ll { signed int v1:1; unsigned long long v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1i_BFu1ll_BFs1c_BFs1s { signed int v1:1; unsigned long long v2:1; signed char v3:1; signed short v4:1; };
struct BFs1i_BFu1ll_BFs1c_BFu1c { signed int v1:1; unsigned long long v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1i_BFu1ll_BFs1c_BFu1i { signed int v1:1; unsigned long long v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1i_BFu1ll_BFs1c_BFu1ll { signed int v1:1; unsigned long long v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1ll_BFs1c_BFu1s { signed int v1:1; unsigned long long v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1i_BFu1ll_BFs1i { signed int v1:1; unsigned long long v2:1; signed int v3:1; };
struct BFs1i_BFu1ll_BFs1i_BFs1c { signed int v1:1; unsigned long long v2:1; signed int v3:1; signed char v4:1; };
struct BFs1i_BFu1ll_BFs1i_BFs1i { signed int v1:1; unsigned long long v2:1; signed int v3:1; signed int v4:1; };
struct BFs1i_BFu1ll_BFs1i_BFs1ll { signed int v1:1; unsigned long long v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1i_BFu1ll_BFs1i_BFs1s { signed int v1:1; unsigned long long v2:1; signed int v3:1; signed short v4:1; };
struct BFs1i_BFu1ll_BFs1i_BFu1c { signed int v1:1; unsigned long long v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1i_BFu1ll_BFs1i_BFu1i { signed int v1:1; unsigned long long v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1i_BFu1ll_BFs1i_BFu1ll { signed int v1:1; unsigned long long v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1ll_BFs1i_BFu1s { signed int v1:1; unsigned long long v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1i_BFu1ll_BFs1ll { signed int v1:1; unsigned long long v2:1; signed long long v3:1; };
struct BFs1i_BFu1ll_BFs1ll_BFs1c { signed int v1:1; unsigned long long v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1i_BFu1ll_BFs1ll_BFs1i { signed int v1:1; unsigned long long v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1i_BFu1ll_BFs1ll_BFs1ll { signed int v1:1; unsigned long long v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1i_BFu1ll_BFs1ll_BFs1s { signed int v1:1; unsigned long long v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1i_BFu1ll_BFs1ll_BFu1c { signed int v1:1; unsigned long long v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1i_BFu1ll_BFs1ll_BFu1i { signed int v1:1; unsigned long long v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1i_BFu1ll_BFs1ll_BFu1ll { signed int v1:1; unsigned long long v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1ll_BFs1ll_BFu1s { signed int v1:1; unsigned long long v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1i_BFu1ll_BFs1s { signed int v1:1; unsigned long long v2:1; signed short v3:1; };
struct BFs1i_BFu1ll_BFs1s_BFs1c { signed int v1:1; unsigned long long v2:1; signed short v3:1; signed char v4:1; };
struct BFs1i_BFu1ll_BFs1s_BFs1i { signed int v1:1; unsigned long long v2:1; signed short v3:1; signed int v4:1; };
struct BFs1i_BFu1ll_BFs1s_BFs1ll { signed int v1:1; unsigned long long v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1i_BFu1ll_BFs1s_BFs1s { signed int v1:1; unsigned long long v2:1; signed short v3:1; signed short v4:1; };
struct BFs1i_BFu1ll_BFs1s_BFu1c { signed int v1:1; unsigned long long v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1i_BFu1ll_BFs1s_BFu1i { signed int v1:1; unsigned long long v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1i_BFu1ll_BFs1s_BFu1ll { signed int v1:1; unsigned long long v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1ll_BFs1s_BFu1s { signed int v1:1; unsigned long long v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1i_BFu1ll_BFu1c { signed int v1:1; unsigned long long v2:1; unsigned char v3:1; };
struct BFs1i_BFu1ll_BFu1c_BFs1c { signed int v1:1; unsigned long long v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1i_BFu1ll_BFu1c_BFs1i { signed int v1:1; unsigned long long v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1i_BFu1ll_BFu1c_BFs1ll { signed int v1:1; unsigned long long v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1i_BFu1ll_BFu1c_BFs1s { signed int v1:1; unsigned long long v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1i_BFu1ll_BFu1c_BFu1c { signed int v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1i_BFu1ll_BFu1c_BFu1i { signed int v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1i_BFu1ll_BFu1c_BFu1ll { signed int v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1ll_BFu1c_BFu1s { signed int v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1i_BFu1ll_BFu1i { signed int v1:1; unsigned long long v2:1; unsigned int v3:1; };
struct BFs1i_BFu1ll_BFu1i_BFs1c { signed int v1:1; unsigned long long v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1i_BFu1ll_BFu1i_BFs1i { signed int v1:1; unsigned long long v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1i_BFu1ll_BFu1i_BFs1ll { signed int v1:1; unsigned long long v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1i_BFu1ll_BFu1i_BFs1s { signed int v1:1; unsigned long long v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1i_BFu1ll_BFu1i_BFu1c { signed int v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1i_BFu1ll_BFu1i_BFu1i { signed int v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1i_BFu1ll_BFu1i_BFu1ll { signed int v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1ll_BFu1i_BFu1s { signed int v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1i_BFu1ll_BFu1ll { signed int v1:1; unsigned long long v2:1; unsigned long long v3:1; };
struct BFs1i_BFu1ll_BFu1ll_BFs1c { signed int v1:1; unsigned long long v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1i_BFu1ll_BFu1ll_BFs1i { signed int v1:1; unsigned long long v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1i_BFu1ll_BFu1ll_BFs1ll { signed int v1:1; unsigned long long v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1i_BFu1ll_BFu1ll_BFs1s { signed int v1:1; unsigned long long v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1i_BFu1ll_BFu1ll_BFu1c { signed int v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1i_BFu1ll_BFu1ll_BFu1i { signed int v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1i_BFu1ll_BFu1ll_BFu1ll { signed int v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1ll_BFu1ll_BFu1s { signed int v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1i_BFu1ll_BFu1s { signed int v1:1; unsigned long long v2:1; unsigned short v3:1; };
struct BFs1i_BFu1ll_BFu1s_BFs1c { signed int v1:1; unsigned long long v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1i_BFu1ll_BFu1s_BFs1i { signed int v1:1; unsigned long long v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1i_BFu1ll_BFu1s_BFs1ll { signed int v1:1; unsigned long long v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1i_BFu1ll_BFu1s_BFs1s { signed int v1:1; unsigned long long v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1i_BFu1ll_BFu1s_BFu1c { signed int v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1i_BFu1ll_BFu1s_BFu1i { signed int v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1i_BFu1ll_BFu1s_BFu1ll { signed int v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1ll_BFu1s_BFu1s { signed int v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1i_BFu1s { signed int v1:1; unsigned short v2:1; };
struct BFs1i_BFu1s_BFs1c { signed int v1:1; unsigned short v2:1; signed char v3:1; };
struct BFs1i_BFu1s_BFs1c_BFs1c { signed int v1:1; unsigned short v2:1; signed char v3:1; signed char v4:1; };
struct BFs1i_BFu1s_BFs1c_BFs1i { signed int v1:1; unsigned short v2:1; signed char v3:1; signed int v4:1; };
struct BFs1i_BFu1s_BFs1c_BFs1ll { signed int v1:1; unsigned short v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1i_BFu1s_BFs1c_BFs1s { signed int v1:1; unsigned short v2:1; signed char v3:1; signed short v4:1; };
struct BFs1i_BFu1s_BFs1c_BFu1c { signed int v1:1; unsigned short v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1i_BFu1s_BFs1c_BFu1i { signed int v1:1; unsigned short v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1i_BFu1s_BFs1c_BFu1ll { signed int v1:1; unsigned short v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1s_BFs1c_BFu1s { signed int v1:1; unsigned short v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1i_BFu1s_BFs1i { signed int v1:1; unsigned short v2:1; signed int v3:1; };
struct BFs1i_BFu1s_BFs1i_BFs1c { signed int v1:1; unsigned short v2:1; signed int v3:1; signed char v4:1; };
struct BFs1i_BFu1s_BFs1i_BFs1i { signed int v1:1; unsigned short v2:1; signed int v3:1; signed int v4:1; };
struct BFs1i_BFu1s_BFs1i_BFs1ll { signed int v1:1; unsigned short v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1i_BFu1s_BFs1i_BFs1s { signed int v1:1; unsigned short v2:1; signed int v3:1; signed short v4:1; };
struct BFs1i_BFu1s_BFs1i_BFu1c { signed int v1:1; unsigned short v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1i_BFu1s_BFs1i_BFu1i { signed int v1:1; unsigned short v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1i_BFu1s_BFs1i_BFu1ll { signed int v1:1; unsigned short v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1s_BFs1i_BFu1s { signed int v1:1; unsigned short v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1i_BFu1s_BFs1ll { signed int v1:1; unsigned short v2:1; signed long long v3:1; };
struct BFs1i_BFu1s_BFs1ll_BFs1c { signed int v1:1; unsigned short v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1i_BFu1s_BFs1ll_BFs1i { signed int v1:1; unsigned short v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1i_BFu1s_BFs1ll_BFs1ll { signed int v1:1; unsigned short v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1i_BFu1s_BFs1ll_BFs1s { signed int v1:1; unsigned short v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1i_BFu1s_BFs1ll_BFu1c { signed int v1:1; unsigned short v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1i_BFu1s_BFs1ll_BFu1i { signed int v1:1; unsigned short v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1i_BFu1s_BFs1ll_BFu1ll { signed int v1:1; unsigned short v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1s_BFs1ll_BFu1s { signed int v1:1; unsigned short v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1i_BFu1s_BFs1s { signed int v1:1; unsigned short v2:1; signed short v3:1; };
struct BFs1i_BFu1s_BFs1s_BFs1c { signed int v1:1; unsigned short v2:1; signed short v3:1; signed char v4:1; };
struct BFs1i_BFu1s_BFs1s_BFs1i { signed int v1:1; unsigned short v2:1; signed short v3:1; signed int v4:1; };
struct BFs1i_BFu1s_BFs1s_BFs1ll { signed int v1:1; unsigned short v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1i_BFu1s_BFs1s_BFs1s { signed int v1:1; unsigned short v2:1; signed short v3:1; signed short v4:1; };
struct BFs1i_BFu1s_BFs1s_BFu1c { signed int v1:1; unsigned short v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1i_BFu1s_BFs1s_BFu1i { signed int v1:1; unsigned short v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1i_BFu1s_BFs1s_BFu1ll { signed int v1:1; unsigned short v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1s_BFs1s_BFu1s { signed int v1:1; unsigned short v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1i_BFu1s_BFu1c { signed int v1:1; unsigned short v2:1; unsigned char v3:1; };
struct BFs1i_BFu1s_BFu1c_BFs1c { signed int v1:1; unsigned short v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1i_BFu1s_BFu1c_BFs1i { signed int v1:1; unsigned short v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1i_BFu1s_BFu1c_BFs1ll { signed int v1:1; unsigned short v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1i_BFu1s_BFu1c_BFs1s { signed int v1:1; unsigned short v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1i_BFu1s_BFu1c_BFu1c { signed int v1:1; unsigned short v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1i_BFu1s_BFu1c_BFu1i { signed int v1:1; unsigned short v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1i_BFu1s_BFu1c_BFu1ll { signed int v1:1; unsigned short v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1s_BFu1c_BFu1s { signed int v1:1; unsigned short v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1i_BFu1s_BFu1i { signed int v1:1; unsigned short v2:1; unsigned int v3:1; };
struct BFs1i_BFu1s_BFu1i_BFs1c { signed int v1:1; unsigned short v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1i_BFu1s_BFu1i_BFs1i { signed int v1:1; unsigned short v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1i_BFu1s_BFu1i_BFs1ll { signed int v1:1; unsigned short v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1i_BFu1s_BFu1i_BFs1s { signed int v1:1; unsigned short v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1i_BFu1s_BFu1i_BFu1c { signed int v1:1; unsigned short v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1i_BFu1s_BFu1i_BFu1i { signed int v1:1; unsigned short v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1i_BFu1s_BFu1i_BFu1ll { signed int v1:1; unsigned short v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1s_BFu1i_BFu1s { signed int v1:1; unsigned short v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1i_BFu1s_BFu1ll { signed int v1:1; unsigned short v2:1; unsigned long long v3:1; };
struct BFs1i_BFu1s_BFu1ll_BFs1c { signed int v1:1; unsigned short v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1i_BFu1s_BFu1ll_BFs1i { signed int v1:1; unsigned short v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1i_BFu1s_BFu1ll_BFs1ll { signed int v1:1; unsigned short v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1i_BFu1s_BFu1ll_BFs1s { signed int v1:1; unsigned short v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1i_BFu1s_BFu1ll_BFu1c { signed int v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1i_BFu1s_BFu1ll_BFu1i { signed int v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1i_BFu1s_BFu1ll_BFu1ll { signed int v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1s_BFu1ll_BFu1s { signed int v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1i_BFu1s_BFu1s { signed int v1:1; unsigned short v2:1; unsigned short v3:1; };
struct BFs1i_BFu1s_BFu1s_BFs1c { signed int v1:1; unsigned short v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1i_BFu1s_BFu1s_BFs1i { signed int v1:1; unsigned short v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1i_BFu1s_BFu1s_BFs1ll { signed int v1:1; unsigned short v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1i_BFu1s_BFu1s_BFs1s { signed int v1:1; unsigned short v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1i_BFu1s_BFu1s_BFu1c { signed int v1:1; unsigned short v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1i_BFu1s_BFu1s_BFu1i { signed int v1:1; unsigned short v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1i_BFu1s_BFu1s_BFu1ll { signed int v1:1; unsigned short v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1i_BFu1s_BFu1s_BFu1s { signed int v1:1; unsigned short v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1c { signed long long v1:1; signed char v2:1; };
struct BFs1ll_BFs1c_BFs1c { signed long long v1:1; signed char v2:1; signed char v3:1; };
struct BFs1ll_BFs1c_BFs1c_BFs1c { signed long long v1:1; signed char v2:1; signed char v3:1; signed char v4:1; };
struct BFs1ll_BFs1c_BFs1c_BFs1i { signed long long v1:1; signed char v2:1; signed char v3:1; signed int v4:1; };
struct BFs1ll_BFs1c_BFs1c_BFs1ll { signed long long v1:1; signed char v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1ll_BFs1c_BFs1c_BFs1s { signed long long v1:1; signed char v2:1; signed char v3:1; signed short v4:1; };
struct BFs1ll_BFs1c_BFs1c_BFu1c { signed long long v1:1; signed char v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1c_BFs1c_BFu1i { signed long long v1:1; signed char v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1c_BFs1c_BFu1ll { signed long long v1:1; signed char v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1c_BFs1c_BFu1s { signed long long v1:1; signed char v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1c_BFs1i { signed long long v1:1; signed char v2:1; signed int v3:1; };
struct BFs1ll_BFs1c_BFs1i_BFs1c { signed long long v1:1; signed char v2:1; signed int v3:1; signed char v4:1; };
struct BFs1ll_BFs1c_BFs1i_BFs1i { signed long long v1:1; signed char v2:1; signed int v3:1; signed int v4:1; };
struct BFs1ll_BFs1c_BFs1i_BFs1ll { signed long long v1:1; signed char v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1ll_BFs1c_BFs1i_BFs1s { signed long long v1:1; signed char v2:1; signed int v3:1; signed short v4:1; };
struct BFs1ll_BFs1c_BFs1i_BFu1c { signed long long v1:1; signed char v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1c_BFs1i_BFu1i { signed long long v1:1; signed char v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1c_BFs1i_BFu1ll { signed long long v1:1; signed char v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1c_BFs1i_BFu1s { signed long long v1:1; signed char v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1c_BFs1ll { signed long long v1:1; signed char v2:1; signed long long v3:1; };
struct BFs1ll_BFs1c_BFs1ll_BFs1c { signed long long v1:1; signed char v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1ll_BFs1c_BFs1ll_BFs1i { signed long long v1:1; signed char v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1ll_BFs1c_BFs1ll_BFs1ll { signed long long v1:1; signed char v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1ll_BFs1c_BFs1ll_BFs1s { signed long long v1:1; signed char v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1ll_BFs1c_BFs1ll_BFu1c { signed long long v1:1; signed char v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1c_BFs1ll_BFu1i { signed long long v1:1; signed char v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1c_BFs1ll_BFu1ll { signed long long v1:1; signed char v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1c_BFs1ll_BFu1s { signed long long v1:1; signed char v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1c_BFs1s { signed long long v1:1; signed char v2:1; signed short v3:1; };
struct BFs1ll_BFs1c_BFs1s_BFs1c { signed long long v1:1; signed char v2:1; signed short v3:1; signed char v4:1; };
struct BFs1ll_BFs1c_BFs1s_BFs1i { signed long long v1:1; signed char v2:1; signed short v3:1; signed int v4:1; };
struct BFs1ll_BFs1c_BFs1s_BFs1ll { signed long long v1:1; signed char v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1ll_BFs1c_BFs1s_BFs1s { signed long long v1:1; signed char v2:1; signed short v3:1; signed short v4:1; };
struct BFs1ll_BFs1c_BFs1s_BFu1c { signed long long v1:1; signed char v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1c_BFs1s_BFu1i { signed long long v1:1; signed char v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1c_BFs1s_BFu1ll { signed long long v1:1; signed char v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1c_BFs1s_BFu1s { signed long long v1:1; signed char v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1c_BFu1c { signed long long v1:1; signed char v2:1; unsigned char v3:1; };
struct BFs1ll_BFs1c_BFu1c_BFs1c { signed long long v1:1; signed char v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1ll_BFs1c_BFu1c_BFs1i { signed long long v1:1; signed char v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1ll_BFs1c_BFu1c_BFs1ll { signed long long v1:1; signed char v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1ll_BFs1c_BFu1c_BFs1s { signed long long v1:1; signed char v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1ll_BFs1c_BFu1c_BFu1c { signed long long v1:1; signed char v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1c_BFu1c_BFu1i { signed long long v1:1; signed char v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1c_BFu1c_BFu1ll { signed long long v1:1; signed char v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1c_BFu1c_BFu1s { signed long long v1:1; signed char v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1c_BFu1i { signed long long v1:1; signed char v2:1; unsigned int v3:1; };
struct BFs1ll_BFs1c_BFu1i_BFs1c { signed long long v1:1; signed char v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1ll_BFs1c_BFu1i_BFs1i { signed long long v1:1; signed char v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1ll_BFs1c_BFu1i_BFs1ll { signed long long v1:1; signed char v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1ll_BFs1c_BFu1i_BFs1s { signed long long v1:1; signed char v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1ll_BFs1c_BFu1i_BFu1c { signed long long v1:1; signed char v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1c_BFu1i_BFu1i { signed long long v1:1; signed char v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1c_BFu1i_BFu1ll { signed long long v1:1; signed char v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1c_BFu1i_BFu1s { signed long long v1:1; signed char v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1c_BFu1ll { signed long long v1:1; signed char v2:1; unsigned long long v3:1; };
struct BFs1ll_BFs1c_BFu1ll_BFs1c { signed long long v1:1; signed char v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1ll_BFs1c_BFu1ll_BFs1i { signed long long v1:1; signed char v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1ll_BFs1c_BFu1ll_BFs1ll { signed long long v1:1; signed char v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1ll_BFs1c_BFu1ll_BFs1s { signed long long v1:1; signed char v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1ll_BFs1c_BFu1ll_BFu1c { signed long long v1:1; signed char v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1c_BFu1ll_BFu1i { signed long long v1:1; signed char v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1c_BFu1ll_BFu1ll { signed long long v1:1; signed char v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1c_BFu1ll_BFu1s { signed long long v1:1; signed char v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1c_BFu1s { signed long long v1:1; signed char v2:1; unsigned short v3:1; };
struct BFs1ll_BFs1c_BFu1s_BFs1c { signed long long v1:1; signed char v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1ll_BFs1c_BFu1s_BFs1i { signed long long v1:1; signed char v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1ll_BFs1c_BFu1s_BFs1ll { signed long long v1:1; signed char v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1ll_BFs1c_BFu1s_BFs1s { signed long long v1:1; signed char v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1ll_BFs1c_BFu1s_BFu1c { signed long long v1:1; signed char v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1c_BFu1s_BFu1i { signed long long v1:1; signed char v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1c_BFu1s_BFu1ll { signed long long v1:1; signed char v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1c_BFu1s_BFu1s { signed long long v1:1; signed char v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1i { signed long long v1:1; signed int v2:1; };
struct BFs1ll_BFs1i_BFs1c { signed long long v1:1; signed int v2:1; signed char v3:1; };
struct BFs1ll_BFs1i_BFs1c_BFs1c { signed long long v1:1; signed int v2:1; signed char v3:1; signed char v4:1; };
struct BFs1ll_BFs1i_BFs1c_BFs1i { signed long long v1:1; signed int v2:1; signed char v3:1; signed int v4:1; };
struct BFs1ll_BFs1i_BFs1c_BFs1ll { signed long long v1:1; signed int v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1ll_BFs1i_BFs1c_BFs1s { signed long long v1:1; signed int v2:1; signed char v3:1; signed short v4:1; };
struct BFs1ll_BFs1i_BFs1c_BFu1c { signed long long v1:1; signed int v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1i_BFs1c_BFu1i { signed long long v1:1; signed int v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1i_BFs1c_BFu1ll { signed long long v1:1; signed int v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1i_BFs1c_BFu1s { signed long long v1:1; signed int v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1i_BFs1i { signed long long v1:1; signed int v2:1; signed int v3:1; };
struct BFs1ll_BFs1i_BFs1i_BFs1c { signed long long v1:1; signed int v2:1; signed int v3:1; signed char v4:1; };
struct BFs1ll_BFs1i_BFs1i_BFs1i { signed long long v1:1; signed int v2:1; signed int v3:1; signed int v4:1; };
struct BFs1ll_BFs1i_BFs1i_BFs1ll { signed long long v1:1; signed int v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1ll_BFs1i_BFs1i_BFs1s { signed long long v1:1; signed int v2:1; signed int v3:1; signed short v4:1; };
struct BFs1ll_BFs1i_BFs1i_BFu1c { signed long long v1:1; signed int v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1i_BFs1i_BFu1i { signed long long v1:1; signed int v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1i_BFs1i_BFu1ll { signed long long v1:1; signed int v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1i_BFs1i_BFu1s { signed long long v1:1; signed int v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1i_BFs1ll { signed long long v1:1; signed int v2:1; signed long long v3:1; };
struct BFs1ll_BFs1i_BFs1ll_BFs1c { signed long long v1:1; signed int v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1ll_BFs1i_BFs1ll_BFs1i { signed long long v1:1; signed int v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1ll_BFs1i_BFs1ll_BFs1ll { signed long long v1:1; signed int v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1ll_BFs1i_BFs1ll_BFs1s { signed long long v1:1; signed int v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1ll_BFs1i_BFs1ll_BFu1c { signed long long v1:1; signed int v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1i_BFs1ll_BFu1i { signed long long v1:1; signed int v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1i_BFs1ll_BFu1ll { signed long long v1:1; signed int v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1i_BFs1ll_BFu1s { signed long long v1:1; signed int v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1i_BFs1s { signed long long v1:1; signed int v2:1; signed short v3:1; };
struct BFs1ll_BFs1i_BFs1s_BFs1c { signed long long v1:1; signed int v2:1; signed short v3:1; signed char v4:1; };
struct BFs1ll_BFs1i_BFs1s_BFs1i { signed long long v1:1; signed int v2:1; signed short v3:1; signed int v4:1; };
struct BFs1ll_BFs1i_BFs1s_BFs1ll { signed long long v1:1; signed int v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1ll_BFs1i_BFs1s_BFs1s { signed long long v1:1; signed int v2:1; signed short v3:1; signed short v4:1; };
struct BFs1ll_BFs1i_BFs1s_BFu1c { signed long long v1:1; signed int v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1i_BFs1s_BFu1i { signed long long v1:1; signed int v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1i_BFs1s_BFu1ll { signed long long v1:1; signed int v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1i_BFs1s_BFu1s { signed long long v1:1; signed int v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1i_BFu1c { signed long long v1:1; signed int v2:1; unsigned char v3:1; };
struct BFs1ll_BFs1i_BFu1c_BFs1c { signed long long v1:1; signed int v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1ll_BFs1i_BFu1c_BFs1i { signed long long v1:1; signed int v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1ll_BFs1i_BFu1c_BFs1ll { signed long long v1:1; signed int v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1ll_BFs1i_BFu1c_BFs1s { signed long long v1:1; signed int v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1ll_BFs1i_BFu1c_BFu1c { signed long long v1:1; signed int v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1i_BFu1c_BFu1i { signed long long v1:1; signed int v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1i_BFu1c_BFu1ll { signed long long v1:1; signed int v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1i_BFu1c_BFu1s { signed long long v1:1; signed int v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1i_BFu1i { signed long long v1:1; signed int v2:1; unsigned int v3:1; };
struct BFs1ll_BFs1i_BFu1i_BFs1c { signed long long v1:1; signed int v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1ll_BFs1i_BFu1i_BFs1i { signed long long v1:1; signed int v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1ll_BFs1i_BFu1i_BFs1ll { signed long long v1:1; signed int v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1ll_BFs1i_BFu1i_BFs1s { signed long long v1:1; signed int v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1ll_BFs1i_BFu1i_BFu1c { signed long long v1:1; signed int v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1i_BFu1i_BFu1i { signed long long v1:1; signed int v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1i_BFu1i_BFu1ll { signed long long v1:1; signed int v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1i_BFu1i_BFu1s { signed long long v1:1; signed int v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1i_BFu1ll { signed long long v1:1; signed int v2:1; unsigned long long v3:1; };
struct BFs1ll_BFs1i_BFu1ll_BFs1c { signed long long v1:1; signed int v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1ll_BFs1i_BFu1ll_BFs1i { signed long long v1:1; signed int v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1ll_BFs1i_BFu1ll_BFs1ll { signed long long v1:1; signed int v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1ll_BFs1i_BFu1ll_BFs1s { signed long long v1:1; signed int v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1ll_BFs1i_BFu1ll_BFu1c { signed long long v1:1; signed int v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1i_BFu1ll_BFu1i { signed long long v1:1; signed int v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1i_BFu1ll_BFu1ll { signed long long v1:1; signed int v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1i_BFu1ll_BFu1s { signed long long v1:1; signed int v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1i_BFu1s { signed long long v1:1; signed int v2:1; unsigned short v3:1; };
struct BFs1ll_BFs1i_BFu1s_BFs1c { signed long long v1:1; signed int v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1ll_BFs1i_BFu1s_BFs1i { signed long long v1:1; signed int v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1ll_BFs1i_BFu1s_BFs1ll { signed long long v1:1; signed int v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1ll_BFs1i_BFu1s_BFs1s { signed long long v1:1; signed int v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1ll_BFs1i_BFu1s_BFu1c { signed long long v1:1; signed int v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1i_BFu1s_BFu1i { signed long long v1:1; signed int v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1i_BFu1s_BFu1ll { signed long long v1:1; signed int v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1i_BFu1s_BFu1s { signed long long v1:1; signed int v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1ll { signed long long v1:1; signed long long v2:1; };
struct BFs1ll_BFs1ll_BFs1c { signed long long v1:1; signed long long v2:1; signed char v3:1; };
struct BFs1ll_BFs1ll_BFs1c_BFs1c { signed long long v1:1; signed long long v2:1; signed char v3:1; signed char v4:1; };
struct BFs1ll_BFs1ll_BFs1c_BFs1i { signed long long v1:1; signed long long v2:1; signed char v3:1; signed int v4:1; };
struct BFs1ll_BFs1ll_BFs1c_BFs1ll { signed long long v1:1; signed long long v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1ll_BFs1ll_BFs1c_BFs1s { signed long long v1:1; signed long long v2:1; signed char v3:1; signed short v4:1; };
struct BFs1ll_BFs1ll_BFs1c_BFu1c { signed long long v1:1; signed long long v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1ll_BFs1c_BFu1i { signed long long v1:1; signed long long v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1ll_BFs1c_BFu1ll { signed long long v1:1; signed long long v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1ll_BFs1c_BFu1s { signed long long v1:1; signed long long v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1ll_BFs1i { signed long long v1:1; signed long long v2:1; signed int v3:1; };
struct BFs1ll_BFs1ll_BFs1i_BFs1c { signed long long v1:1; signed long long v2:1; signed int v3:1; signed char v4:1; };
struct BFs1ll_BFs1ll_BFs1i_BFs1i { signed long long v1:1; signed long long v2:1; signed int v3:1; signed int v4:1; };
struct BFs1ll_BFs1ll_BFs1i_BFs1ll { signed long long v1:1; signed long long v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1ll_BFs1ll_BFs1i_BFs1s { signed long long v1:1; signed long long v2:1; signed int v3:1; signed short v4:1; };
struct BFs1ll_BFs1ll_BFs1i_BFu1c { signed long long v1:1; signed long long v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1ll_BFs1i_BFu1i { signed long long v1:1; signed long long v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1ll_BFs1i_BFu1ll { signed long long v1:1; signed long long v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1ll_BFs1i_BFu1s { signed long long v1:1; signed long long v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1ll_BFs1ll { signed long long v1:1; signed long long v2:1; signed long long v3:1; };
struct BFs1ll_BFs1ll_BFs1ll_BFs1c { signed long long v1:1; signed long long v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1ll_BFs1ll_BFs1ll_BFs1i { signed long long v1:1; signed long long v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1ll_BFs1ll_BFs1ll_BFs1ll { signed long long v1:1; signed long long v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1ll_BFs1ll_BFs1ll_BFs1s { signed long long v1:1; signed long long v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1ll_BFs1ll_BFs1ll_BFu1c { signed long long v1:1; signed long long v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1ll_BFs1ll_BFu1i { signed long long v1:1; signed long long v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1ll_BFs1ll_BFu1ll { signed long long v1:1; signed long long v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1ll_BFs1ll_BFu1s { signed long long v1:1; signed long long v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1ll_BFs1s { signed long long v1:1; signed long long v2:1; signed short v3:1; };
struct BFs1ll_BFs1ll_BFs1s_BFs1c { signed long long v1:1; signed long long v2:1; signed short v3:1; signed char v4:1; };
struct BFs1ll_BFs1ll_BFs1s_BFs1i { signed long long v1:1; signed long long v2:1; signed short v3:1; signed int v4:1; };
struct BFs1ll_BFs1ll_BFs1s_BFs1ll { signed long long v1:1; signed long long v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1ll_BFs1ll_BFs1s_BFs1s { signed long long v1:1; signed long long v2:1; signed short v3:1; signed short v4:1; };
struct BFs1ll_BFs1ll_BFs1s_BFu1c { signed long long v1:1; signed long long v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1ll_BFs1s_BFu1i { signed long long v1:1; signed long long v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1ll_BFs1s_BFu1ll { signed long long v1:1; signed long long v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1ll_BFs1s_BFu1s { signed long long v1:1; signed long long v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1ll_BFu1c { signed long long v1:1; signed long long v2:1; unsigned char v3:1; };
struct BFs1ll_BFs1ll_BFu1c_BFs1c { signed long long v1:1; signed long long v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1ll_BFs1ll_BFu1c_BFs1i { signed long long v1:1; signed long long v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1ll_BFs1ll_BFu1c_BFs1ll { signed long long v1:1; signed long long v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1ll_BFs1ll_BFu1c_BFs1s { signed long long v1:1; signed long long v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1ll_BFs1ll_BFu1c_BFu1c { signed long long v1:1; signed long long v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1ll_BFu1c_BFu1i { signed long long v1:1; signed long long v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1ll_BFu1c_BFu1ll { signed long long v1:1; signed long long v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1ll_BFu1c_BFu1s { signed long long v1:1; signed long long v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1ll_BFu1i { signed long long v1:1; signed long long v2:1; unsigned int v3:1; };
struct BFs1ll_BFs1ll_BFu1i_BFs1c { signed long long v1:1; signed long long v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1ll_BFs1ll_BFu1i_BFs1i { signed long long v1:1; signed long long v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1ll_BFs1ll_BFu1i_BFs1ll { signed long long v1:1; signed long long v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1ll_BFs1ll_BFu1i_BFs1s { signed long long v1:1; signed long long v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1ll_BFs1ll_BFu1i_BFu1c { signed long long v1:1; signed long long v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1ll_BFu1i_BFu1i { signed long long v1:1; signed long long v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1ll_BFu1i_BFu1ll { signed long long v1:1; signed long long v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1ll_BFu1i_BFu1s { signed long long v1:1; signed long long v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1ll_BFu1ll { signed long long v1:1; signed long long v2:1; unsigned long long v3:1; };
struct BFs1ll_BFs1ll_BFu1ll_BFs1c { signed long long v1:1; signed long long v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1ll_BFs1ll_BFu1ll_BFs1i { signed long long v1:1; signed long long v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1ll_BFs1ll_BFu1ll_BFs1ll { signed long long v1:1; signed long long v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1ll_BFs1ll_BFu1ll_BFs1s { signed long long v1:1; signed long long v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1ll_BFs1ll_BFu1ll_BFu1c { signed long long v1:1; signed long long v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1ll_BFu1ll_BFu1i { signed long long v1:1; signed long long v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1ll_BFu1ll_BFu1ll { signed long long v1:1; signed long long v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1ll_BFu1ll_BFu1s { signed long long v1:1; signed long long v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1ll_BFu1s { signed long long v1:1; signed long long v2:1; unsigned short v3:1; };
struct BFs1ll_BFs1ll_BFu1s_BFs1c { signed long long v1:1; signed long long v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1ll_BFs1ll_BFu1s_BFs1i { signed long long v1:1; signed long long v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1ll_BFs1ll_BFu1s_BFs1ll { signed long long v1:1; signed long long v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1ll_BFs1ll_BFu1s_BFs1s { signed long long v1:1; signed long long v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1ll_BFs1ll_BFu1s_BFu1c { signed long long v1:1; signed long long v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1ll_BFu1s_BFu1i { signed long long v1:1; signed long long v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1ll_BFu1s_BFu1ll { signed long long v1:1; signed long long v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1ll_BFu1s_BFu1s { signed long long v1:1; signed long long v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1s { signed long long v1:1; signed short v2:1; };
struct BFs1ll_BFs1s_BFs1c { signed long long v1:1; signed short v2:1; signed char v3:1; };
struct BFs1ll_BFs1s_BFs1c_BFs1c { signed long long v1:1; signed short v2:1; signed char v3:1; signed char v4:1; };
struct BFs1ll_BFs1s_BFs1c_BFs1i { signed long long v1:1; signed short v2:1; signed char v3:1; signed int v4:1; };
struct BFs1ll_BFs1s_BFs1c_BFs1ll { signed long long v1:1; signed short v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1ll_BFs1s_BFs1c_BFs1s { signed long long v1:1; signed short v2:1; signed char v3:1; signed short v4:1; };
struct BFs1ll_BFs1s_BFs1c_BFu1c { signed long long v1:1; signed short v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1s_BFs1c_BFu1i { signed long long v1:1; signed short v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1s_BFs1c_BFu1ll { signed long long v1:1; signed short v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1s_BFs1c_BFu1s { signed long long v1:1; signed short v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1s_BFs1i { signed long long v1:1; signed short v2:1; signed int v3:1; };
struct BFs1ll_BFs1s_BFs1i_BFs1c { signed long long v1:1; signed short v2:1; signed int v3:1; signed char v4:1; };
struct BFs1ll_BFs1s_BFs1i_BFs1i { signed long long v1:1; signed short v2:1; signed int v3:1; signed int v4:1; };
struct BFs1ll_BFs1s_BFs1i_BFs1ll { signed long long v1:1; signed short v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1ll_BFs1s_BFs1i_BFs1s { signed long long v1:1; signed short v2:1; signed int v3:1; signed short v4:1; };
struct BFs1ll_BFs1s_BFs1i_BFu1c { signed long long v1:1; signed short v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1s_BFs1i_BFu1i { signed long long v1:1; signed short v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1s_BFs1i_BFu1ll { signed long long v1:1; signed short v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1s_BFs1i_BFu1s { signed long long v1:1; signed short v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1s_BFs1ll { signed long long v1:1; signed short v2:1; signed long long v3:1; };
struct BFs1ll_BFs1s_BFs1ll_BFs1c { signed long long v1:1; signed short v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1ll_BFs1s_BFs1ll_BFs1i { signed long long v1:1; signed short v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1ll_BFs1s_BFs1ll_BFs1ll { signed long long v1:1; signed short v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1ll_BFs1s_BFs1ll_BFs1s { signed long long v1:1; signed short v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1ll_BFs1s_BFs1ll_BFu1c { signed long long v1:1; signed short v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1s_BFs1ll_BFu1i { signed long long v1:1; signed short v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1s_BFs1ll_BFu1ll { signed long long v1:1; signed short v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1s_BFs1ll_BFu1s { signed long long v1:1; signed short v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1s_BFs1s { signed long long v1:1; signed short v2:1; signed short v3:1; };
struct BFs1ll_BFs1s_BFs1s_BFs1c { signed long long v1:1; signed short v2:1; signed short v3:1; signed char v4:1; };
struct BFs1ll_BFs1s_BFs1s_BFs1i { signed long long v1:1; signed short v2:1; signed short v3:1; signed int v4:1; };
struct BFs1ll_BFs1s_BFs1s_BFs1ll { signed long long v1:1; signed short v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1ll_BFs1s_BFs1s_BFs1s { signed long long v1:1; signed short v2:1; signed short v3:1; signed short v4:1; };
struct BFs1ll_BFs1s_BFs1s_BFu1c { signed long long v1:1; signed short v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1s_BFs1s_BFu1i { signed long long v1:1; signed short v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1s_BFs1s_BFu1ll { signed long long v1:1; signed short v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1s_BFs1s_BFu1s { signed long long v1:1; signed short v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1s_BFu1c { signed long long v1:1; signed short v2:1; unsigned char v3:1; };
struct BFs1ll_BFs1s_BFu1c_BFs1c { signed long long v1:1; signed short v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1ll_BFs1s_BFu1c_BFs1i { signed long long v1:1; signed short v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1ll_BFs1s_BFu1c_BFs1ll { signed long long v1:1; signed short v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1ll_BFs1s_BFu1c_BFs1s { signed long long v1:1; signed short v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1ll_BFs1s_BFu1c_BFu1c { signed long long v1:1; signed short v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1s_BFu1c_BFu1i { signed long long v1:1; signed short v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1s_BFu1c_BFu1ll { signed long long v1:1; signed short v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1s_BFu1c_BFu1s { signed long long v1:1; signed short v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1s_BFu1i { signed long long v1:1; signed short v2:1; unsigned int v3:1; };
struct BFs1ll_BFs1s_BFu1i_BFs1c { signed long long v1:1; signed short v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1ll_BFs1s_BFu1i_BFs1i { signed long long v1:1; signed short v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1ll_BFs1s_BFu1i_BFs1ll { signed long long v1:1; signed short v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1ll_BFs1s_BFu1i_BFs1s { signed long long v1:1; signed short v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1ll_BFs1s_BFu1i_BFu1c { signed long long v1:1; signed short v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1s_BFu1i_BFu1i { signed long long v1:1; signed short v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1s_BFu1i_BFu1ll { signed long long v1:1; signed short v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1s_BFu1i_BFu1s { signed long long v1:1; signed short v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1s_BFu1ll { signed long long v1:1; signed short v2:1; unsigned long long v3:1; };
struct BFs1ll_BFs1s_BFu1ll_BFs1c { signed long long v1:1; signed short v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1ll_BFs1s_BFu1ll_BFs1i { signed long long v1:1; signed short v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1ll_BFs1s_BFu1ll_BFs1ll { signed long long v1:1; signed short v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1ll_BFs1s_BFu1ll_BFs1s { signed long long v1:1; signed short v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1ll_BFs1s_BFu1ll_BFu1c { signed long long v1:1; signed short v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1s_BFu1ll_BFu1i { signed long long v1:1; signed short v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1s_BFu1ll_BFu1ll { signed long long v1:1; signed short v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1s_BFu1ll_BFu1s { signed long long v1:1; signed short v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFs1s_BFu1s { signed long long v1:1; signed short v2:1; unsigned short v3:1; };
struct BFs1ll_BFs1s_BFu1s_BFs1c { signed long long v1:1; signed short v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1ll_BFs1s_BFu1s_BFs1i { signed long long v1:1; signed short v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1ll_BFs1s_BFu1s_BFs1ll { signed long long v1:1; signed short v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1ll_BFs1s_BFu1s_BFs1s { signed long long v1:1; signed short v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1ll_BFs1s_BFu1s_BFu1c { signed long long v1:1; signed short v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1ll_BFs1s_BFu1s_BFu1i { signed long long v1:1; signed short v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1ll_BFs1s_BFu1s_BFu1ll { signed long long v1:1; signed short v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFs1s_BFu1s_BFu1s { signed long long v1:1; signed short v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1c { signed long long v1:1; unsigned char v2:1; };
struct BFs1ll_BFu1c_BFs1c { signed long long v1:1; unsigned char v2:1; signed char v3:1; };
struct BFs1ll_BFu1c_BFs1c_BFs1c { signed long long v1:1; unsigned char v2:1; signed char v3:1; signed char v4:1; };
struct BFs1ll_BFu1c_BFs1c_BFs1i { signed long long v1:1; unsigned char v2:1; signed char v3:1; signed int v4:1; };
struct BFs1ll_BFu1c_BFs1c_BFs1ll { signed long long v1:1; unsigned char v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1ll_BFu1c_BFs1c_BFs1s { signed long long v1:1; unsigned char v2:1; signed char v3:1; signed short v4:1; };
struct BFs1ll_BFu1c_BFs1c_BFu1c { signed long long v1:1; unsigned char v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1c_BFs1c_BFu1i { signed long long v1:1; unsigned char v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1c_BFs1c_BFu1ll { signed long long v1:1; unsigned char v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1c_BFs1c_BFu1s { signed long long v1:1; unsigned char v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1c_BFs1i { signed long long v1:1; unsigned char v2:1; signed int v3:1; };
struct BFs1ll_BFu1c_BFs1i_BFs1c { signed long long v1:1; unsigned char v2:1; signed int v3:1; signed char v4:1; };
struct BFs1ll_BFu1c_BFs1i_BFs1i { signed long long v1:1; unsigned char v2:1; signed int v3:1; signed int v4:1; };
struct BFs1ll_BFu1c_BFs1i_BFs1ll { signed long long v1:1; unsigned char v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1ll_BFu1c_BFs1i_BFs1s { signed long long v1:1; unsigned char v2:1; signed int v3:1; signed short v4:1; };
struct BFs1ll_BFu1c_BFs1i_BFu1c { signed long long v1:1; unsigned char v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1c_BFs1i_BFu1i { signed long long v1:1; unsigned char v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1c_BFs1i_BFu1ll { signed long long v1:1; unsigned char v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1c_BFs1i_BFu1s { signed long long v1:1; unsigned char v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1c_BFs1ll { signed long long v1:1; unsigned char v2:1; signed long long v3:1; };
struct BFs1ll_BFu1c_BFs1ll_BFs1c { signed long long v1:1; unsigned char v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1ll_BFu1c_BFs1ll_BFs1i { signed long long v1:1; unsigned char v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1ll_BFu1c_BFs1ll_BFs1ll { signed long long v1:1; unsigned char v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1ll_BFu1c_BFs1ll_BFs1s { signed long long v1:1; unsigned char v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1ll_BFu1c_BFs1ll_BFu1c { signed long long v1:1; unsigned char v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1c_BFs1ll_BFu1i { signed long long v1:1; unsigned char v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1c_BFs1ll_BFu1ll { signed long long v1:1; unsigned char v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1c_BFs1ll_BFu1s { signed long long v1:1; unsigned char v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1c_BFs1s { signed long long v1:1; unsigned char v2:1; signed short v3:1; };
struct BFs1ll_BFu1c_BFs1s_BFs1c { signed long long v1:1; unsigned char v2:1; signed short v3:1; signed char v4:1; };
struct BFs1ll_BFu1c_BFs1s_BFs1i { signed long long v1:1; unsigned char v2:1; signed short v3:1; signed int v4:1; };
struct BFs1ll_BFu1c_BFs1s_BFs1ll { signed long long v1:1; unsigned char v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1ll_BFu1c_BFs1s_BFs1s { signed long long v1:1; unsigned char v2:1; signed short v3:1; signed short v4:1; };
struct BFs1ll_BFu1c_BFs1s_BFu1c { signed long long v1:1; unsigned char v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1c_BFs1s_BFu1i { signed long long v1:1; unsigned char v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1c_BFs1s_BFu1ll { signed long long v1:1; unsigned char v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1c_BFs1s_BFu1s { signed long long v1:1; unsigned char v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1c_BFu1c { signed long long v1:1; unsigned char v2:1; unsigned char v3:1; };
struct BFs1ll_BFu1c_BFu1c_BFs1c { signed long long v1:1; unsigned char v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1ll_BFu1c_BFu1c_BFs1i { signed long long v1:1; unsigned char v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1ll_BFu1c_BFu1c_BFs1ll { signed long long v1:1; unsigned char v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1ll_BFu1c_BFu1c_BFs1s { signed long long v1:1; unsigned char v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1ll_BFu1c_BFu1c_BFu1c { signed long long v1:1; unsigned char v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1c_BFu1c_BFu1i { signed long long v1:1; unsigned char v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1c_BFu1c_BFu1ll { signed long long v1:1; unsigned char v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1c_BFu1c_BFu1s { signed long long v1:1; unsigned char v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1c_BFu1i { signed long long v1:1; unsigned char v2:1; unsigned int v3:1; };
struct BFs1ll_BFu1c_BFu1i_BFs1c { signed long long v1:1; unsigned char v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1ll_BFu1c_BFu1i_BFs1i { signed long long v1:1; unsigned char v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1ll_BFu1c_BFu1i_BFs1ll { signed long long v1:1; unsigned char v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1ll_BFu1c_BFu1i_BFs1s { signed long long v1:1; unsigned char v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1ll_BFu1c_BFu1i_BFu1c { signed long long v1:1; unsigned char v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1c_BFu1i_BFu1i { signed long long v1:1; unsigned char v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1c_BFu1i_BFu1ll { signed long long v1:1; unsigned char v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1c_BFu1i_BFu1s { signed long long v1:1; unsigned char v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1c_BFu1ll { signed long long v1:1; unsigned char v2:1; unsigned long long v3:1; };
struct BFs1ll_BFu1c_BFu1ll_BFs1c { signed long long v1:1; unsigned char v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1ll_BFu1c_BFu1ll_BFs1i { signed long long v1:1; unsigned char v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1ll_BFu1c_BFu1ll_BFs1ll { signed long long v1:1; unsigned char v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1ll_BFu1c_BFu1ll_BFs1s { signed long long v1:1; unsigned char v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1ll_BFu1c_BFu1ll_BFu1c { signed long long v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1c_BFu1ll_BFu1i { signed long long v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1c_BFu1ll_BFu1ll { signed long long v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1c_BFu1ll_BFu1s { signed long long v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1c_BFu1s { signed long long v1:1; unsigned char v2:1; unsigned short v3:1; };
struct BFs1ll_BFu1c_BFu1s_BFs1c { signed long long v1:1; unsigned char v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1ll_BFu1c_BFu1s_BFs1i { signed long long v1:1; unsigned char v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1ll_BFu1c_BFu1s_BFs1ll { signed long long v1:1; unsigned char v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1ll_BFu1c_BFu1s_BFs1s { signed long long v1:1; unsigned char v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1ll_BFu1c_BFu1s_BFu1c { signed long long v1:1; unsigned char v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1c_BFu1s_BFu1i { signed long long v1:1; unsigned char v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1c_BFu1s_BFu1ll { signed long long v1:1; unsigned char v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1c_BFu1s_BFu1s { signed long long v1:1; unsigned char v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1i { signed long long v1:1; unsigned int v2:1; };
struct BFs1ll_BFu1i_BFs1c { signed long long v1:1; unsigned int v2:1; signed char v3:1; };
struct BFs1ll_BFu1i_BFs1c_BFs1c { signed long long v1:1; unsigned int v2:1; signed char v3:1; signed char v4:1; };
struct BFs1ll_BFu1i_BFs1c_BFs1i { signed long long v1:1; unsigned int v2:1; signed char v3:1; signed int v4:1; };
struct BFs1ll_BFu1i_BFs1c_BFs1ll { signed long long v1:1; unsigned int v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1ll_BFu1i_BFs1c_BFs1s { signed long long v1:1; unsigned int v2:1; signed char v3:1; signed short v4:1; };
struct BFs1ll_BFu1i_BFs1c_BFu1c { signed long long v1:1; unsigned int v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1i_BFs1c_BFu1i { signed long long v1:1; unsigned int v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1i_BFs1c_BFu1ll { signed long long v1:1; unsigned int v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1i_BFs1c_BFu1s { signed long long v1:1; unsigned int v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1i_BFs1i { signed long long v1:1; unsigned int v2:1; signed int v3:1; };
struct BFs1ll_BFu1i_BFs1i_BFs1c { signed long long v1:1; unsigned int v2:1; signed int v3:1; signed char v4:1; };
struct BFs1ll_BFu1i_BFs1i_BFs1i { signed long long v1:1; unsigned int v2:1; signed int v3:1; signed int v4:1; };
struct BFs1ll_BFu1i_BFs1i_BFs1ll { signed long long v1:1; unsigned int v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1ll_BFu1i_BFs1i_BFs1s { signed long long v1:1; unsigned int v2:1; signed int v3:1; signed short v4:1; };
struct BFs1ll_BFu1i_BFs1i_BFu1c { signed long long v1:1; unsigned int v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1i_BFs1i_BFu1i { signed long long v1:1; unsigned int v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1i_BFs1i_BFu1ll { signed long long v1:1; unsigned int v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1i_BFs1i_BFu1s { signed long long v1:1; unsigned int v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1i_BFs1ll { signed long long v1:1; unsigned int v2:1; signed long long v3:1; };
struct BFs1ll_BFu1i_BFs1ll_BFs1c { signed long long v1:1; unsigned int v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1ll_BFu1i_BFs1ll_BFs1i { signed long long v1:1; unsigned int v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1ll_BFu1i_BFs1ll_BFs1ll { signed long long v1:1; unsigned int v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1ll_BFu1i_BFs1ll_BFs1s { signed long long v1:1; unsigned int v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1ll_BFu1i_BFs1ll_BFu1c { signed long long v1:1; unsigned int v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1i_BFs1ll_BFu1i { signed long long v1:1; unsigned int v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1i_BFs1ll_BFu1ll { signed long long v1:1; unsigned int v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1i_BFs1ll_BFu1s { signed long long v1:1; unsigned int v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1i_BFs1s { signed long long v1:1; unsigned int v2:1; signed short v3:1; };
struct BFs1ll_BFu1i_BFs1s_BFs1c { signed long long v1:1; unsigned int v2:1; signed short v3:1; signed char v4:1; };
struct BFs1ll_BFu1i_BFs1s_BFs1i { signed long long v1:1; unsigned int v2:1; signed short v3:1; signed int v4:1; };
struct BFs1ll_BFu1i_BFs1s_BFs1ll { signed long long v1:1; unsigned int v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1ll_BFu1i_BFs1s_BFs1s { signed long long v1:1; unsigned int v2:1; signed short v3:1; signed short v4:1; };
struct BFs1ll_BFu1i_BFs1s_BFu1c { signed long long v1:1; unsigned int v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1i_BFs1s_BFu1i { signed long long v1:1; unsigned int v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1i_BFs1s_BFu1ll { signed long long v1:1; unsigned int v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1i_BFs1s_BFu1s { signed long long v1:1; unsigned int v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1i_BFu1c { signed long long v1:1; unsigned int v2:1; unsigned char v3:1; };
struct BFs1ll_BFu1i_BFu1c_BFs1c { signed long long v1:1; unsigned int v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1ll_BFu1i_BFu1c_BFs1i { signed long long v1:1; unsigned int v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1ll_BFu1i_BFu1c_BFs1ll { signed long long v1:1; unsigned int v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1ll_BFu1i_BFu1c_BFs1s { signed long long v1:1; unsigned int v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1ll_BFu1i_BFu1c_BFu1c { signed long long v1:1; unsigned int v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1i_BFu1c_BFu1i { signed long long v1:1; unsigned int v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1i_BFu1c_BFu1ll { signed long long v1:1; unsigned int v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1i_BFu1c_BFu1s { signed long long v1:1; unsigned int v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1i_BFu1i { signed long long v1:1; unsigned int v2:1; unsigned int v3:1; };
struct BFs1ll_BFu1i_BFu1i_BFs1c { signed long long v1:1; unsigned int v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1ll_BFu1i_BFu1i_BFs1i { signed long long v1:1; unsigned int v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1ll_BFu1i_BFu1i_BFs1ll { signed long long v1:1; unsigned int v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1ll_BFu1i_BFu1i_BFs1s { signed long long v1:1; unsigned int v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1ll_BFu1i_BFu1i_BFu1c { signed long long v1:1; unsigned int v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1i_BFu1i_BFu1i { signed long long v1:1; unsigned int v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1i_BFu1i_BFu1ll { signed long long v1:1; unsigned int v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1i_BFu1i_BFu1s { signed long long v1:1; unsigned int v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1i_BFu1ll { signed long long v1:1; unsigned int v2:1; unsigned long long v3:1; };
struct BFs1ll_BFu1i_BFu1ll_BFs1c { signed long long v1:1; unsigned int v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1ll_BFu1i_BFu1ll_BFs1i { signed long long v1:1; unsigned int v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1ll_BFu1i_BFu1ll_BFs1ll { signed long long v1:1; unsigned int v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1ll_BFu1i_BFu1ll_BFs1s { signed long long v1:1; unsigned int v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1ll_BFu1i_BFu1ll_BFu1c { signed long long v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1i_BFu1ll_BFu1i { signed long long v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1i_BFu1ll_BFu1ll { signed long long v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1i_BFu1ll_BFu1s { signed long long v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1i_BFu1s { signed long long v1:1; unsigned int v2:1; unsigned short v3:1; };
struct BFs1ll_BFu1i_BFu1s_BFs1c { signed long long v1:1; unsigned int v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1ll_BFu1i_BFu1s_BFs1i { signed long long v1:1; unsigned int v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1ll_BFu1i_BFu1s_BFs1ll { signed long long v1:1; unsigned int v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1ll_BFu1i_BFu1s_BFs1s { signed long long v1:1; unsigned int v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1ll_BFu1i_BFu1s_BFu1c { signed long long v1:1; unsigned int v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1i_BFu1s_BFu1i { signed long long v1:1; unsigned int v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1i_BFu1s_BFu1ll { signed long long v1:1; unsigned int v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1i_BFu1s_BFu1s { signed long long v1:1; unsigned int v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1ll { signed long long v1:1; unsigned long long v2:1; };
struct BFs1ll_BFu1ll_BFs1c { signed long long v1:1; unsigned long long v2:1; signed char v3:1; };
struct BFs1ll_BFu1ll_BFs1c_BFs1c { signed long long v1:1; unsigned long long v2:1; signed char v3:1; signed char v4:1; };
struct BFs1ll_BFu1ll_BFs1c_BFs1i { signed long long v1:1; unsigned long long v2:1; signed char v3:1; signed int v4:1; };
struct BFs1ll_BFu1ll_BFs1c_BFs1ll { signed long long v1:1; unsigned long long v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1ll_BFu1ll_BFs1c_BFs1s { signed long long v1:1; unsigned long long v2:1; signed char v3:1; signed short v4:1; };
struct BFs1ll_BFu1ll_BFs1c_BFu1c { signed long long v1:1; unsigned long long v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1ll_BFs1c_BFu1i { signed long long v1:1; unsigned long long v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1ll_BFs1c_BFu1ll { signed long long v1:1; unsigned long long v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1ll_BFs1c_BFu1s { signed long long v1:1; unsigned long long v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1ll_BFs1i { signed long long v1:1; unsigned long long v2:1; signed int v3:1; };
struct BFs1ll_BFu1ll_BFs1i_BFs1c { signed long long v1:1; unsigned long long v2:1; signed int v3:1; signed char v4:1; };
struct BFs1ll_BFu1ll_BFs1i_BFs1i { signed long long v1:1; unsigned long long v2:1; signed int v3:1; signed int v4:1; };
struct BFs1ll_BFu1ll_BFs1i_BFs1ll { signed long long v1:1; unsigned long long v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1ll_BFu1ll_BFs1i_BFs1s { signed long long v1:1; unsigned long long v2:1; signed int v3:1; signed short v4:1; };
struct BFs1ll_BFu1ll_BFs1i_BFu1c { signed long long v1:1; unsigned long long v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1ll_BFs1i_BFu1i { signed long long v1:1; unsigned long long v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1ll_BFs1i_BFu1ll { signed long long v1:1; unsigned long long v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1ll_BFs1i_BFu1s { signed long long v1:1; unsigned long long v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1ll_BFs1ll { signed long long v1:1; unsigned long long v2:1; signed long long v3:1; };
struct BFs1ll_BFu1ll_BFs1ll_BFs1c { signed long long v1:1; unsigned long long v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1ll_BFu1ll_BFs1ll_BFs1i { signed long long v1:1; unsigned long long v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1ll_BFu1ll_BFs1ll_BFs1ll { signed long long v1:1; unsigned long long v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1ll_BFu1ll_BFs1ll_BFs1s { signed long long v1:1; unsigned long long v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1ll_BFu1ll_BFs1ll_BFu1c { signed long long v1:1; unsigned long long v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1ll_BFs1ll_BFu1i { signed long long v1:1; unsigned long long v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1ll_BFs1ll_BFu1ll { signed long long v1:1; unsigned long long v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1ll_BFs1ll_BFu1s { signed long long v1:1; unsigned long long v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1ll_BFs1s { signed long long v1:1; unsigned long long v2:1; signed short v3:1; };
struct BFs1ll_BFu1ll_BFs1s_BFs1c { signed long long v1:1; unsigned long long v2:1; signed short v3:1; signed char v4:1; };
struct BFs1ll_BFu1ll_BFs1s_BFs1i { signed long long v1:1; unsigned long long v2:1; signed short v3:1; signed int v4:1; };
struct BFs1ll_BFu1ll_BFs1s_BFs1ll { signed long long v1:1; unsigned long long v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1ll_BFu1ll_BFs1s_BFs1s { signed long long v1:1; unsigned long long v2:1; signed short v3:1; signed short v4:1; };
struct BFs1ll_BFu1ll_BFs1s_BFu1c { signed long long v1:1; unsigned long long v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1ll_BFs1s_BFu1i { signed long long v1:1; unsigned long long v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1ll_BFs1s_BFu1ll { signed long long v1:1; unsigned long long v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1ll_BFs1s_BFu1s { signed long long v1:1; unsigned long long v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1ll_BFu1c { signed long long v1:1; unsigned long long v2:1; unsigned char v3:1; };
struct BFs1ll_BFu1ll_BFu1c_BFs1c { signed long long v1:1; unsigned long long v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1ll_BFu1ll_BFu1c_BFs1i { signed long long v1:1; unsigned long long v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1ll_BFu1ll_BFu1c_BFs1ll { signed long long v1:1; unsigned long long v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1ll_BFu1ll_BFu1c_BFs1s { signed long long v1:1; unsigned long long v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1ll_BFu1ll_BFu1c_BFu1c { signed long long v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1ll_BFu1c_BFu1i { signed long long v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1ll_BFu1c_BFu1ll { signed long long v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1ll_BFu1c_BFu1s { signed long long v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1ll_BFu1i { signed long long v1:1; unsigned long long v2:1; unsigned int v3:1; };
struct BFs1ll_BFu1ll_BFu1i_BFs1c { signed long long v1:1; unsigned long long v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1ll_BFu1ll_BFu1i_BFs1i { signed long long v1:1; unsigned long long v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1ll_BFu1ll_BFu1i_BFs1ll { signed long long v1:1; unsigned long long v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1ll_BFu1ll_BFu1i_BFs1s { signed long long v1:1; unsigned long long v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1ll_BFu1ll_BFu1i_BFu1c { signed long long v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1ll_BFu1i_BFu1i { signed long long v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1ll_BFu1i_BFu1ll { signed long long v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1ll_BFu1i_BFu1s { signed long long v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1ll_BFu1ll { signed long long v1:1; unsigned long long v2:1; unsigned long long v3:1; };
struct BFs1ll_BFu1ll_BFu1ll_BFs1c { signed long long v1:1; unsigned long long v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1ll_BFu1ll_BFu1ll_BFs1i { signed long long v1:1; unsigned long long v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1ll_BFu1ll_BFu1ll_BFs1ll { signed long long v1:1; unsigned long long v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1ll_BFu1ll_BFu1ll_BFs1s { signed long long v1:1; unsigned long long v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1ll_BFu1ll_BFu1ll_BFu1c { signed long long v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1ll_BFu1ll_BFu1i { signed long long v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1ll_BFu1ll_BFu1ll { signed long long v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1ll_BFu1ll_BFu1s { signed long long v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1ll_BFu1s { signed long long v1:1; unsigned long long v2:1; unsigned short v3:1; };
struct BFs1ll_BFu1ll_BFu1s_BFs1c { signed long long v1:1; unsigned long long v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1ll_BFu1ll_BFu1s_BFs1i { signed long long v1:1; unsigned long long v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1ll_BFu1ll_BFu1s_BFs1ll { signed long long v1:1; unsigned long long v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1ll_BFu1ll_BFu1s_BFs1s { signed long long v1:1; unsigned long long v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1ll_BFu1ll_BFu1s_BFu1c { signed long long v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1ll_BFu1s_BFu1i { signed long long v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1ll_BFu1s_BFu1ll { signed long long v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1ll_BFu1s_BFu1s { signed long long v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1s { signed long long v1:1; unsigned short v2:1; };
struct BFs1ll_BFu1s_BFs1c { signed long long v1:1; unsigned short v2:1; signed char v3:1; };
struct BFs1ll_BFu1s_BFs1c_BFs1c { signed long long v1:1; unsigned short v2:1; signed char v3:1; signed char v4:1; };
struct BFs1ll_BFu1s_BFs1c_BFs1i { signed long long v1:1; unsigned short v2:1; signed char v3:1; signed int v4:1; };
struct BFs1ll_BFu1s_BFs1c_BFs1ll { signed long long v1:1; unsigned short v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1ll_BFu1s_BFs1c_BFs1s { signed long long v1:1; unsigned short v2:1; signed char v3:1; signed short v4:1; };
struct BFs1ll_BFu1s_BFs1c_BFu1c { signed long long v1:1; unsigned short v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1s_BFs1c_BFu1i { signed long long v1:1; unsigned short v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1s_BFs1c_BFu1ll { signed long long v1:1; unsigned short v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1s_BFs1c_BFu1s { signed long long v1:1; unsigned short v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1s_BFs1i { signed long long v1:1; unsigned short v2:1; signed int v3:1; };
struct BFs1ll_BFu1s_BFs1i_BFs1c { signed long long v1:1; unsigned short v2:1; signed int v3:1; signed char v4:1; };
struct BFs1ll_BFu1s_BFs1i_BFs1i { signed long long v1:1; unsigned short v2:1; signed int v3:1; signed int v4:1; };
struct BFs1ll_BFu1s_BFs1i_BFs1ll { signed long long v1:1; unsigned short v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1ll_BFu1s_BFs1i_BFs1s { signed long long v1:1; unsigned short v2:1; signed int v3:1; signed short v4:1; };
struct BFs1ll_BFu1s_BFs1i_BFu1c { signed long long v1:1; unsigned short v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1s_BFs1i_BFu1i { signed long long v1:1; unsigned short v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1s_BFs1i_BFu1ll { signed long long v1:1; unsigned short v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1s_BFs1i_BFu1s { signed long long v1:1; unsigned short v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1s_BFs1ll { signed long long v1:1; unsigned short v2:1; signed long long v3:1; };
struct BFs1ll_BFu1s_BFs1ll_BFs1c { signed long long v1:1; unsigned short v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1ll_BFu1s_BFs1ll_BFs1i { signed long long v1:1; unsigned short v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1ll_BFu1s_BFs1ll_BFs1ll { signed long long v1:1; unsigned short v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1ll_BFu1s_BFs1ll_BFs1s { signed long long v1:1; unsigned short v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1ll_BFu1s_BFs1ll_BFu1c { signed long long v1:1; unsigned short v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1s_BFs1ll_BFu1i { signed long long v1:1; unsigned short v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1s_BFs1ll_BFu1ll { signed long long v1:1; unsigned short v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1s_BFs1ll_BFu1s { signed long long v1:1; unsigned short v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1s_BFs1s { signed long long v1:1; unsigned short v2:1; signed short v3:1; };
struct BFs1ll_BFu1s_BFs1s_BFs1c { signed long long v1:1; unsigned short v2:1; signed short v3:1; signed char v4:1; };
struct BFs1ll_BFu1s_BFs1s_BFs1i { signed long long v1:1; unsigned short v2:1; signed short v3:1; signed int v4:1; };
struct BFs1ll_BFu1s_BFs1s_BFs1ll { signed long long v1:1; unsigned short v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1ll_BFu1s_BFs1s_BFs1s { signed long long v1:1; unsigned short v2:1; signed short v3:1; signed short v4:1; };
struct BFs1ll_BFu1s_BFs1s_BFu1c { signed long long v1:1; unsigned short v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1s_BFs1s_BFu1i { signed long long v1:1; unsigned short v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1s_BFs1s_BFu1ll { signed long long v1:1; unsigned short v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1s_BFs1s_BFu1s { signed long long v1:1; unsigned short v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1s_BFu1c { signed long long v1:1; unsigned short v2:1; unsigned char v3:1; };
struct BFs1ll_BFu1s_BFu1c_BFs1c { signed long long v1:1; unsigned short v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1ll_BFu1s_BFu1c_BFs1i { signed long long v1:1; unsigned short v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1ll_BFu1s_BFu1c_BFs1ll { signed long long v1:1; unsigned short v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1ll_BFu1s_BFu1c_BFs1s { signed long long v1:1; unsigned short v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1ll_BFu1s_BFu1c_BFu1c { signed long long v1:1; unsigned short v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1s_BFu1c_BFu1i { signed long long v1:1; unsigned short v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1s_BFu1c_BFu1ll { signed long long v1:1; unsigned short v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1s_BFu1c_BFu1s { signed long long v1:1; unsigned short v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1s_BFu1i { signed long long v1:1; unsigned short v2:1; unsigned int v3:1; };
struct BFs1ll_BFu1s_BFu1i_BFs1c { signed long long v1:1; unsigned short v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1ll_BFu1s_BFu1i_BFs1i { signed long long v1:1; unsigned short v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1ll_BFu1s_BFu1i_BFs1ll { signed long long v1:1; unsigned short v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1ll_BFu1s_BFu1i_BFs1s { signed long long v1:1; unsigned short v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1ll_BFu1s_BFu1i_BFu1c { signed long long v1:1; unsigned short v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1s_BFu1i_BFu1i { signed long long v1:1; unsigned short v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1s_BFu1i_BFu1ll { signed long long v1:1; unsigned short v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1s_BFu1i_BFu1s { signed long long v1:1; unsigned short v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1s_BFu1ll { signed long long v1:1; unsigned short v2:1; unsigned long long v3:1; };
struct BFs1ll_BFu1s_BFu1ll_BFs1c { signed long long v1:1; unsigned short v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1ll_BFu1s_BFu1ll_BFs1i { signed long long v1:1; unsigned short v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1ll_BFu1s_BFu1ll_BFs1ll { signed long long v1:1; unsigned short v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1ll_BFu1s_BFu1ll_BFs1s { signed long long v1:1; unsigned short v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1ll_BFu1s_BFu1ll_BFu1c { signed long long v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1s_BFu1ll_BFu1i { signed long long v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1s_BFu1ll_BFu1ll { signed long long v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1s_BFu1ll_BFu1s { signed long long v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1ll_BFu1s_BFu1s { signed long long v1:1; unsigned short v2:1; unsigned short v3:1; };
struct BFs1ll_BFu1s_BFu1s_BFs1c { signed long long v1:1; unsigned short v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1ll_BFu1s_BFu1s_BFs1i { signed long long v1:1; unsigned short v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1ll_BFu1s_BFu1s_BFs1ll { signed long long v1:1; unsigned short v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1ll_BFu1s_BFu1s_BFs1s { signed long long v1:1; unsigned short v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1ll_BFu1s_BFu1s_BFu1c { signed long long v1:1; unsigned short v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1ll_BFu1s_BFu1s_BFu1i { signed long long v1:1; unsigned short v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1ll_BFu1s_BFu1s_BFu1ll { signed long long v1:1; unsigned short v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1ll_BFu1s_BFu1s_BFu1s { signed long long v1:1; unsigned short v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1s_BFs1c { signed short v1:1; signed char v2:1; };
struct BFs1s_BFs1c_BFs1c { signed short v1:1; signed char v2:1; signed char v3:1; };
struct BFs1s_BFs1c_BFs1c_BFs1c { signed short v1:1; signed char v2:1; signed char v3:1; signed char v4:1; };
struct BFs1s_BFs1c_BFs1c_BFs1i { signed short v1:1; signed char v2:1; signed char v3:1; signed int v4:1; };
struct BFs1s_BFs1c_BFs1c_BFs1ll { signed short v1:1; signed char v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1s_BFs1c_BFs1c_BFs1s { signed short v1:1; signed char v2:1; signed char v3:1; signed short v4:1; };
struct BFs1s_BFs1c_BFs1c_BFu1c { signed short v1:1; signed char v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1s_BFs1c_BFs1c_BFu1i { signed short v1:1; signed char v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1s_BFs1c_BFs1c_BFu1ll { signed short v1:1; signed char v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1c_BFs1c_BFu1s { signed short v1:1; signed char v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1s_BFs1c_BFs1i { signed short v1:1; signed char v2:1; signed int v3:1; };
struct BFs1s_BFs1c_BFs1i_BFs1c { signed short v1:1; signed char v2:1; signed int v3:1; signed char v4:1; };
struct BFs1s_BFs1c_BFs1i_BFs1i { signed short v1:1; signed char v2:1; signed int v3:1; signed int v4:1; };
struct BFs1s_BFs1c_BFs1i_BFs1ll { signed short v1:1; signed char v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1s_BFs1c_BFs1i_BFs1s { signed short v1:1; signed char v2:1; signed int v3:1; signed short v4:1; };
struct BFs1s_BFs1c_BFs1i_BFu1c { signed short v1:1; signed char v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1s_BFs1c_BFs1i_BFu1i { signed short v1:1; signed char v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1s_BFs1c_BFs1i_BFu1ll { signed short v1:1; signed char v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1c_BFs1i_BFu1s { signed short v1:1; signed char v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1s_BFs1c_BFs1ll { signed short v1:1; signed char v2:1; signed long long v3:1; };
struct BFs1s_BFs1c_BFs1ll_BFs1c { signed short v1:1; signed char v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1s_BFs1c_BFs1ll_BFs1i { signed short v1:1; signed char v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1s_BFs1c_BFs1ll_BFs1ll { signed short v1:1; signed char v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1s_BFs1c_BFs1ll_BFs1s { signed short v1:1; signed char v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1s_BFs1c_BFs1ll_BFu1c { signed short v1:1; signed char v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1s_BFs1c_BFs1ll_BFu1i { signed short v1:1; signed char v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1s_BFs1c_BFs1ll_BFu1ll { signed short v1:1; signed char v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1c_BFs1ll_BFu1s { signed short v1:1; signed char v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1s_BFs1c_BFs1s { signed short v1:1; signed char v2:1; signed short v3:1; };
struct BFs1s_BFs1c_BFs1s_BFs1c { signed short v1:1; signed char v2:1; signed short v3:1; signed char v4:1; };
struct BFs1s_BFs1c_BFs1s_BFs1i { signed short v1:1; signed char v2:1; signed short v3:1; signed int v4:1; };
struct BFs1s_BFs1c_BFs1s_BFs1ll { signed short v1:1; signed char v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1s_BFs1c_BFs1s_BFs1s { signed short v1:1; signed char v2:1; signed short v3:1; signed short v4:1; };
struct BFs1s_BFs1c_BFs1s_BFu1c { signed short v1:1; signed char v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1s_BFs1c_BFs1s_BFu1i { signed short v1:1; signed char v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1s_BFs1c_BFs1s_BFu1ll { signed short v1:1; signed char v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1c_BFs1s_BFu1s { signed short v1:1; signed char v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1s_BFs1c_BFu1c { signed short v1:1; signed char v2:1; unsigned char v3:1; };
struct BFs1s_BFs1c_BFu1c_BFs1c { signed short v1:1; signed char v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1s_BFs1c_BFu1c_BFs1i { signed short v1:1; signed char v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1s_BFs1c_BFu1c_BFs1ll { signed short v1:1; signed char v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1s_BFs1c_BFu1c_BFs1s { signed short v1:1; signed char v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1s_BFs1c_BFu1c_BFu1c { signed short v1:1; signed char v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1s_BFs1c_BFu1c_BFu1i { signed short v1:1; signed char v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1s_BFs1c_BFu1c_BFu1ll { signed short v1:1; signed char v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1c_BFu1c_BFu1s { signed short v1:1; signed char v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1s_BFs1c_BFu1i { signed short v1:1; signed char v2:1; unsigned int v3:1; };
struct BFs1s_BFs1c_BFu1i_BFs1c { signed short v1:1; signed char v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1s_BFs1c_BFu1i_BFs1i { signed short v1:1; signed char v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1s_BFs1c_BFu1i_BFs1ll { signed short v1:1; signed char v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1s_BFs1c_BFu1i_BFs1s { signed short v1:1; signed char v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1s_BFs1c_BFu1i_BFu1c { signed short v1:1; signed char v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1s_BFs1c_BFu1i_BFu1i { signed short v1:1; signed char v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1s_BFs1c_BFu1i_BFu1ll { signed short v1:1; signed char v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1c_BFu1i_BFu1s { signed short v1:1; signed char v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1s_BFs1c_BFu1ll { signed short v1:1; signed char v2:1; unsigned long long v3:1; };
struct BFs1s_BFs1c_BFu1ll_BFs1c { signed short v1:1; signed char v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1s_BFs1c_BFu1ll_BFs1i { signed short v1:1; signed char v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1s_BFs1c_BFu1ll_BFs1ll { signed short v1:1; signed char v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1s_BFs1c_BFu1ll_BFs1s { signed short v1:1; signed char v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1s_BFs1c_BFu1ll_BFu1c { signed short v1:1; signed char v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1s_BFs1c_BFu1ll_BFu1i { signed short v1:1; signed char v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1s_BFs1c_BFu1ll_BFu1ll { signed short v1:1; signed char v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1c_BFu1ll_BFu1s { signed short v1:1; signed char v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1s_BFs1c_BFu1s { signed short v1:1; signed char v2:1; unsigned short v3:1; };
struct BFs1s_BFs1c_BFu1s_BFs1c { signed short v1:1; signed char v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1s_BFs1c_BFu1s_BFs1i { signed short v1:1; signed char v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1s_BFs1c_BFu1s_BFs1ll { signed short v1:1; signed char v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1s_BFs1c_BFu1s_BFs1s { signed short v1:1; signed char v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1s_BFs1c_BFu1s_BFu1c { signed short v1:1; signed char v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1s_BFs1c_BFu1s_BFu1i { signed short v1:1; signed char v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1s_BFs1c_BFu1s_BFu1ll { signed short v1:1; signed char v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1c_BFu1s_BFu1s { signed short v1:1; signed char v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1s_BFs1i { signed short v1:1; signed int v2:1; };
struct BFs1s_BFs1i_BFs1c { signed short v1:1; signed int v2:1; signed char v3:1; };
struct BFs1s_BFs1i_BFs1c_BFs1c { signed short v1:1; signed int v2:1; signed char v3:1; signed char v4:1; };
struct BFs1s_BFs1i_BFs1c_BFs1i { signed short v1:1; signed int v2:1; signed char v3:1; signed int v4:1; };
struct BFs1s_BFs1i_BFs1c_BFs1ll { signed short v1:1; signed int v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1s_BFs1i_BFs1c_BFs1s { signed short v1:1; signed int v2:1; signed char v3:1; signed short v4:1; };
struct BFs1s_BFs1i_BFs1c_BFu1c { signed short v1:1; signed int v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1s_BFs1i_BFs1c_BFu1i { signed short v1:1; signed int v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1s_BFs1i_BFs1c_BFu1ll { signed short v1:1; signed int v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1i_BFs1c_BFu1s { signed short v1:1; signed int v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1s_BFs1i_BFs1i { signed short v1:1; signed int v2:1; signed int v3:1; };
struct BFs1s_BFs1i_BFs1i_BFs1c { signed short v1:1; signed int v2:1; signed int v3:1; signed char v4:1; };
struct BFs1s_BFs1i_BFs1i_BFs1i { signed short v1:1; signed int v2:1; signed int v3:1; signed int v4:1; };
struct BFs1s_BFs1i_BFs1i_BFs1ll { signed short v1:1; signed int v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1s_BFs1i_BFs1i_BFs1s { signed short v1:1; signed int v2:1; signed int v3:1; signed short v4:1; };
struct BFs1s_BFs1i_BFs1i_BFu1c { signed short v1:1; signed int v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1s_BFs1i_BFs1i_BFu1i { signed short v1:1; signed int v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1s_BFs1i_BFs1i_BFu1ll { signed short v1:1; signed int v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1i_BFs1i_BFu1s { signed short v1:1; signed int v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1s_BFs1i_BFs1ll { signed short v1:1; signed int v2:1; signed long long v3:1; };
struct BFs1s_BFs1i_BFs1ll_BFs1c { signed short v1:1; signed int v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1s_BFs1i_BFs1ll_BFs1i { signed short v1:1; signed int v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1s_BFs1i_BFs1ll_BFs1ll { signed short v1:1; signed int v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1s_BFs1i_BFs1ll_BFs1s { signed short v1:1; signed int v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1s_BFs1i_BFs1ll_BFu1c { signed short v1:1; signed int v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1s_BFs1i_BFs1ll_BFu1i { signed short v1:1; signed int v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1s_BFs1i_BFs1ll_BFu1ll { signed short v1:1; signed int v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1i_BFs1ll_BFu1s { signed short v1:1; signed int v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1s_BFs1i_BFs1s { signed short v1:1; signed int v2:1; signed short v3:1; };
struct BFs1s_BFs1i_BFs1s_BFs1c { signed short v1:1; signed int v2:1; signed short v3:1; signed char v4:1; };
struct BFs1s_BFs1i_BFs1s_BFs1i { signed short v1:1; signed int v2:1; signed short v3:1; signed int v4:1; };
struct BFs1s_BFs1i_BFs1s_BFs1ll { signed short v1:1; signed int v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1s_BFs1i_BFs1s_BFs1s { signed short v1:1; signed int v2:1; signed short v3:1; signed short v4:1; };
struct BFs1s_BFs1i_BFs1s_BFu1c { signed short v1:1; signed int v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1s_BFs1i_BFs1s_BFu1i { signed short v1:1; signed int v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1s_BFs1i_BFs1s_BFu1ll { signed short v1:1; signed int v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1i_BFs1s_BFu1s { signed short v1:1; signed int v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1s_BFs1i_BFu1c { signed short v1:1; signed int v2:1; unsigned char v3:1; };
struct BFs1s_BFs1i_BFu1c_BFs1c { signed short v1:1; signed int v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1s_BFs1i_BFu1c_BFs1i { signed short v1:1; signed int v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1s_BFs1i_BFu1c_BFs1ll { signed short v1:1; signed int v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1s_BFs1i_BFu1c_BFs1s { signed short v1:1; signed int v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1s_BFs1i_BFu1c_BFu1c { signed short v1:1; signed int v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1s_BFs1i_BFu1c_BFu1i { signed short v1:1; signed int v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1s_BFs1i_BFu1c_BFu1ll { signed short v1:1; signed int v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1i_BFu1c_BFu1s { signed short v1:1; signed int v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1s_BFs1i_BFu1i { signed short v1:1; signed int v2:1; unsigned int v3:1; };
struct BFs1s_BFs1i_BFu1i_BFs1c { signed short v1:1; signed int v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1s_BFs1i_BFu1i_BFs1i { signed short v1:1; signed int v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1s_BFs1i_BFu1i_BFs1ll { signed short v1:1; signed int v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1s_BFs1i_BFu1i_BFs1s { signed short v1:1; signed int v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1s_BFs1i_BFu1i_BFu1c { signed short v1:1; signed int v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1s_BFs1i_BFu1i_BFu1i { signed short v1:1; signed int v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1s_BFs1i_BFu1i_BFu1ll { signed short v1:1; signed int v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1i_BFu1i_BFu1s { signed short v1:1; signed int v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1s_BFs1i_BFu1ll { signed short v1:1; signed int v2:1; unsigned long long v3:1; };
struct BFs1s_BFs1i_BFu1ll_BFs1c { signed short v1:1; signed int v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1s_BFs1i_BFu1ll_BFs1i { signed short v1:1; signed int v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1s_BFs1i_BFu1ll_BFs1ll { signed short v1:1; signed int v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1s_BFs1i_BFu1ll_BFs1s { signed short v1:1; signed int v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1s_BFs1i_BFu1ll_BFu1c { signed short v1:1; signed int v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1s_BFs1i_BFu1ll_BFu1i { signed short v1:1; signed int v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1s_BFs1i_BFu1ll_BFu1ll { signed short v1:1; signed int v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1i_BFu1ll_BFu1s { signed short v1:1; signed int v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1s_BFs1i_BFu1s { signed short v1:1; signed int v2:1; unsigned short v3:1; };
struct BFs1s_BFs1i_BFu1s_BFs1c { signed short v1:1; signed int v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1s_BFs1i_BFu1s_BFs1i { signed short v1:1; signed int v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1s_BFs1i_BFu1s_BFs1ll { signed short v1:1; signed int v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1s_BFs1i_BFu1s_BFs1s { signed short v1:1; signed int v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1s_BFs1i_BFu1s_BFu1c { signed short v1:1; signed int v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1s_BFs1i_BFu1s_BFu1i { signed short v1:1; signed int v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1s_BFs1i_BFu1s_BFu1ll { signed short v1:1; signed int v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1i_BFu1s_BFu1s { signed short v1:1; signed int v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1s_BFs1ll { signed short v1:1; signed long long v2:1; };
struct BFs1s_BFs1ll_BFs1c { signed short v1:1; signed long long v2:1; signed char v3:1; };
struct BFs1s_BFs1ll_BFs1c_BFs1c { signed short v1:1; signed long long v2:1; signed char v3:1; signed char v4:1; };
struct BFs1s_BFs1ll_BFs1c_BFs1i { signed short v1:1; signed long long v2:1; signed char v3:1; signed int v4:1; };
struct BFs1s_BFs1ll_BFs1c_BFs1ll { signed short v1:1; signed long long v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1s_BFs1ll_BFs1c_BFs1s { signed short v1:1; signed long long v2:1; signed char v3:1; signed short v4:1; };
struct BFs1s_BFs1ll_BFs1c_BFu1c { signed short v1:1; signed long long v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1s_BFs1ll_BFs1c_BFu1i { signed short v1:1; signed long long v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1s_BFs1ll_BFs1c_BFu1ll { signed short v1:1; signed long long v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1ll_BFs1c_BFu1s { signed short v1:1; signed long long v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1s_BFs1ll_BFs1i { signed short v1:1; signed long long v2:1; signed int v3:1; };
struct BFs1s_BFs1ll_BFs1i_BFs1c { signed short v1:1; signed long long v2:1; signed int v3:1; signed char v4:1; };
struct BFs1s_BFs1ll_BFs1i_BFs1i { signed short v1:1; signed long long v2:1; signed int v3:1; signed int v4:1; };
struct BFs1s_BFs1ll_BFs1i_BFs1ll { signed short v1:1; signed long long v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1s_BFs1ll_BFs1i_BFs1s { signed short v1:1; signed long long v2:1; signed int v3:1; signed short v4:1; };
struct BFs1s_BFs1ll_BFs1i_BFu1c { signed short v1:1; signed long long v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1s_BFs1ll_BFs1i_BFu1i { signed short v1:1; signed long long v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1s_BFs1ll_BFs1i_BFu1ll { signed short v1:1; signed long long v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1ll_BFs1i_BFu1s { signed short v1:1; signed long long v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1s_BFs1ll_BFs1ll { signed short v1:1; signed long long v2:1; signed long long v3:1; };
struct BFs1s_BFs1ll_BFs1ll_BFs1c { signed short v1:1; signed long long v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1s_BFs1ll_BFs1ll_BFs1i { signed short v1:1; signed long long v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1s_BFs1ll_BFs1ll_BFs1ll { signed short v1:1; signed long long v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1s_BFs1ll_BFs1ll_BFs1s { signed short v1:1; signed long long v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1s_BFs1ll_BFs1ll_BFu1c { signed short v1:1; signed long long v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1s_BFs1ll_BFs1ll_BFu1i { signed short v1:1; signed long long v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1s_BFs1ll_BFs1ll_BFu1ll { signed short v1:1; signed long long v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1ll_BFs1ll_BFu1s { signed short v1:1; signed long long v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1s_BFs1ll_BFs1s { signed short v1:1; signed long long v2:1; signed short v3:1; };
struct BFs1s_BFs1ll_BFs1s_BFs1c { signed short v1:1; signed long long v2:1; signed short v3:1; signed char v4:1; };
struct BFs1s_BFs1ll_BFs1s_BFs1i { signed short v1:1; signed long long v2:1; signed short v3:1; signed int v4:1; };
struct BFs1s_BFs1ll_BFs1s_BFs1ll { signed short v1:1; signed long long v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1s_BFs1ll_BFs1s_BFs1s { signed short v1:1; signed long long v2:1; signed short v3:1; signed short v4:1; };
struct BFs1s_BFs1ll_BFs1s_BFu1c { signed short v1:1; signed long long v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1s_BFs1ll_BFs1s_BFu1i { signed short v1:1; signed long long v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1s_BFs1ll_BFs1s_BFu1ll { signed short v1:1; signed long long v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1ll_BFs1s_BFu1s { signed short v1:1; signed long long v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1s_BFs1ll_BFu1c { signed short v1:1; signed long long v2:1; unsigned char v3:1; };
struct BFs1s_BFs1ll_BFu1c_BFs1c { signed short v1:1; signed long long v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1s_BFs1ll_BFu1c_BFs1i { signed short v1:1; signed long long v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1s_BFs1ll_BFu1c_BFs1ll { signed short v1:1; signed long long v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1s_BFs1ll_BFu1c_BFs1s { signed short v1:1; signed long long v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1s_BFs1ll_BFu1c_BFu1c { signed short v1:1; signed long long v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1s_BFs1ll_BFu1c_BFu1i { signed short v1:1; signed long long v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1s_BFs1ll_BFu1c_BFu1ll { signed short v1:1; signed long long v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1ll_BFu1c_BFu1s { signed short v1:1; signed long long v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1s_BFs1ll_BFu1i { signed short v1:1; signed long long v2:1; unsigned int v3:1; };
struct BFs1s_BFs1ll_BFu1i_BFs1c { signed short v1:1; signed long long v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1s_BFs1ll_BFu1i_BFs1i { signed short v1:1; signed long long v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1s_BFs1ll_BFu1i_BFs1ll { signed short v1:1; signed long long v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1s_BFs1ll_BFu1i_BFs1s { signed short v1:1; signed long long v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1s_BFs1ll_BFu1i_BFu1c { signed short v1:1; signed long long v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1s_BFs1ll_BFu1i_BFu1i { signed short v1:1; signed long long v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1s_BFs1ll_BFu1i_BFu1ll { signed short v1:1; signed long long v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1ll_BFu1i_BFu1s { signed short v1:1; signed long long v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1s_BFs1ll_BFu1ll { signed short v1:1; signed long long v2:1; unsigned long long v3:1; };
struct BFs1s_BFs1ll_BFu1ll_BFs1c { signed short v1:1; signed long long v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1s_BFs1ll_BFu1ll_BFs1i { signed short v1:1; signed long long v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1s_BFs1ll_BFu1ll_BFs1ll { signed short v1:1; signed long long v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1s_BFs1ll_BFu1ll_BFs1s { signed short v1:1; signed long long v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1s_BFs1ll_BFu1ll_BFu1c { signed short v1:1; signed long long v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1s_BFs1ll_BFu1ll_BFu1i { signed short v1:1; signed long long v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1s_BFs1ll_BFu1ll_BFu1ll { signed short v1:1; signed long long v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1ll_BFu1ll_BFu1s { signed short v1:1; signed long long v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1s_BFs1ll_BFu1s { signed short v1:1; signed long long v2:1; unsigned short v3:1; };
struct BFs1s_BFs1ll_BFu1s_BFs1c { signed short v1:1; signed long long v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1s_BFs1ll_BFu1s_BFs1i { signed short v1:1; signed long long v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1s_BFs1ll_BFu1s_BFs1ll { signed short v1:1; signed long long v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1s_BFs1ll_BFu1s_BFs1s { signed short v1:1; signed long long v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1s_BFs1ll_BFu1s_BFu1c { signed short v1:1; signed long long v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1s_BFs1ll_BFu1s_BFu1i { signed short v1:1; signed long long v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1s_BFs1ll_BFu1s_BFu1ll { signed short v1:1; signed long long v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1ll_BFu1s_BFu1s { signed short v1:1; signed long long v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1s_BFs1s { signed short v1:1; signed short v2:1; };
struct BFs1s_BFs1s_BFs1c { signed short v1:1; signed short v2:1; signed char v3:1; };
struct BFs1s_BFs1s_BFs1c_BFs1c { signed short v1:1; signed short v2:1; signed char v3:1; signed char v4:1; };
struct BFs1s_BFs1s_BFs1c_BFs1i { signed short v1:1; signed short v2:1; signed char v3:1; signed int v4:1; };
struct BFs1s_BFs1s_BFs1c_BFs1ll { signed short v1:1; signed short v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1s_BFs1s_BFs1c_BFs1s { signed short v1:1; signed short v2:1; signed char v3:1; signed short v4:1; };
struct BFs1s_BFs1s_BFs1c_BFu1c { signed short v1:1; signed short v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1s_BFs1s_BFs1c_BFu1i { signed short v1:1; signed short v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1s_BFs1s_BFs1c_BFu1ll { signed short v1:1; signed short v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1s_BFs1c_BFu1s { signed short v1:1; signed short v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1s_BFs1s_BFs1i { signed short v1:1; signed short v2:1; signed int v3:1; };
struct BFs1s_BFs1s_BFs1i_BFs1c { signed short v1:1; signed short v2:1; signed int v3:1; signed char v4:1; };
struct BFs1s_BFs1s_BFs1i_BFs1i { signed short v1:1; signed short v2:1; signed int v3:1; signed int v4:1; };
struct BFs1s_BFs1s_BFs1i_BFs1ll { signed short v1:1; signed short v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1s_BFs1s_BFs1i_BFs1s { signed short v1:1; signed short v2:1; signed int v3:1; signed short v4:1; };
struct BFs1s_BFs1s_BFs1i_BFu1c { signed short v1:1; signed short v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1s_BFs1s_BFs1i_BFu1i { signed short v1:1; signed short v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1s_BFs1s_BFs1i_BFu1ll { signed short v1:1; signed short v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1s_BFs1i_BFu1s { signed short v1:1; signed short v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1s_BFs1s_BFs1ll { signed short v1:1; signed short v2:1; signed long long v3:1; };
struct BFs1s_BFs1s_BFs1ll_BFs1c { signed short v1:1; signed short v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1s_BFs1s_BFs1ll_BFs1i { signed short v1:1; signed short v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1s_BFs1s_BFs1ll_BFs1ll { signed short v1:1; signed short v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1s_BFs1s_BFs1ll_BFs1s { signed short v1:1; signed short v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1s_BFs1s_BFs1ll_BFu1c { signed short v1:1; signed short v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1s_BFs1s_BFs1ll_BFu1i { signed short v1:1; signed short v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1s_BFs1s_BFs1ll_BFu1ll { signed short v1:1; signed short v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1s_BFs1ll_BFu1s { signed short v1:1; signed short v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1s_BFs1s_BFs1s { signed short v1:1; signed short v2:1; signed short v3:1; };
struct BFs1s_BFs1s_BFs1s_BFs1c { signed short v1:1; signed short v2:1; signed short v3:1; signed char v4:1; };
struct BFs1s_BFs1s_BFs1s_BFs1i { signed short v1:1; signed short v2:1; signed short v3:1; signed int v4:1; };
struct BFs1s_BFs1s_BFs1s_BFs1ll { signed short v1:1; signed short v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1s_BFs1s_BFs1s_BFs1s { signed short v1:1; signed short v2:1; signed short v3:1; signed short v4:1; };
struct BFs1s_BFs1s_BFs1s_BFu1c { signed short v1:1; signed short v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1s_BFs1s_BFs1s_BFu1i { signed short v1:1; signed short v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1s_BFs1s_BFs1s_BFu1ll { signed short v1:1; signed short v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1s_BFs1s_BFu1s { signed short v1:1; signed short v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1s_BFs1s_BFu1c { signed short v1:1; signed short v2:1; unsigned char v3:1; };
struct BFs1s_BFs1s_BFu1c_BFs1c { signed short v1:1; signed short v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1s_BFs1s_BFu1c_BFs1i { signed short v1:1; signed short v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1s_BFs1s_BFu1c_BFs1ll { signed short v1:1; signed short v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1s_BFs1s_BFu1c_BFs1s { signed short v1:1; signed short v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1s_BFs1s_BFu1c_BFu1c { signed short v1:1; signed short v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1s_BFs1s_BFu1c_BFu1i { signed short v1:1; signed short v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1s_BFs1s_BFu1c_BFu1ll { signed short v1:1; signed short v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1s_BFu1c_BFu1s { signed short v1:1; signed short v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1s_BFs1s_BFu1i { signed short v1:1; signed short v2:1; unsigned int v3:1; };
struct BFs1s_BFs1s_BFu1i_BFs1c { signed short v1:1; signed short v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1s_BFs1s_BFu1i_BFs1i { signed short v1:1; signed short v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1s_BFs1s_BFu1i_BFs1ll { signed short v1:1; signed short v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1s_BFs1s_BFu1i_BFs1s { signed short v1:1; signed short v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1s_BFs1s_BFu1i_BFu1c { signed short v1:1; signed short v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1s_BFs1s_BFu1i_BFu1i { signed short v1:1; signed short v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1s_BFs1s_BFu1i_BFu1ll { signed short v1:1; signed short v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1s_BFu1i_BFu1s { signed short v1:1; signed short v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1s_BFs1s_BFu1ll { signed short v1:1; signed short v2:1; unsigned long long v3:1; };
struct BFs1s_BFs1s_BFu1ll_BFs1c { signed short v1:1; signed short v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1s_BFs1s_BFu1ll_BFs1i { signed short v1:1; signed short v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1s_BFs1s_BFu1ll_BFs1ll { signed short v1:1; signed short v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1s_BFs1s_BFu1ll_BFs1s { signed short v1:1; signed short v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1s_BFs1s_BFu1ll_BFu1c { signed short v1:1; signed short v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1s_BFs1s_BFu1ll_BFu1i { signed short v1:1; signed short v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1s_BFs1s_BFu1ll_BFu1ll { signed short v1:1; signed short v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1s_BFu1ll_BFu1s { signed short v1:1; signed short v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1s_BFs1s_BFu1s { signed short v1:1; signed short v2:1; unsigned short v3:1; };
struct BFs1s_BFs1s_BFu1s_BFs1c { signed short v1:1; signed short v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1s_BFs1s_BFu1s_BFs1i { signed short v1:1; signed short v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1s_BFs1s_BFu1s_BFs1ll { signed short v1:1; signed short v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1s_BFs1s_BFu1s_BFs1s { signed short v1:1; signed short v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1s_BFs1s_BFu1s_BFu1c { signed short v1:1; signed short v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1s_BFs1s_BFu1s_BFu1i { signed short v1:1; signed short v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1s_BFs1s_BFu1s_BFu1ll { signed short v1:1; signed short v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1s_BFs1s_BFu1s_BFu1s { signed short v1:1; signed short v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1s_BFu1c { signed short v1:1; unsigned char v2:1; };
struct BFs1s_BFu1c_BFs1c { signed short v1:1; unsigned char v2:1; signed char v3:1; };
struct BFs1s_BFu1c_BFs1c_BFs1c { signed short v1:1; unsigned char v2:1; signed char v3:1; signed char v4:1; };
struct BFs1s_BFu1c_BFs1c_BFs1i { signed short v1:1; unsigned char v2:1; signed char v3:1; signed int v4:1; };
struct BFs1s_BFu1c_BFs1c_BFs1ll { signed short v1:1; unsigned char v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1s_BFu1c_BFs1c_BFs1s { signed short v1:1; unsigned char v2:1; signed char v3:1; signed short v4:1; };
struct BFs1s_BFu1c_BFs1c_BFu1c { signed short v1:1; unsigned char v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1s_BFu1c_BFs1c_BFu1i { signed short v1:1; unsigned char v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1s_BFu1c_BFs1c_BFu1ll { signed short v1:1; unsigned char v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1c_BFs1c_BFu1s { signed short v1:1; unsigned char v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1s_BFu1c_BFs1i { signed short v1:1; unsigned char v2:1; signed int v3:1; };
struct BFs1s_BFu1c_BFs1i_BFs1c { signed short v1:1; unsigned char v2:1; signed int v3:1; signed char v4:1; };
struct BFs1s_BFu1c_BFs1i_BFs1i { signed short v1:1; unsigned char v2:1; signed int v3:1; signed int v4:1; };
struct BFs1s_BFu1c_BFs1i_BFs1ll { signed short v1:1; unsigned char v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1s_BFu1c_BFs1i_BFs1s { signed short v1:1; unsigned char v2:1; signed int v3:1; signed short v4:1; };
struct BFs1s_BFu1c_BFs1i_BFu1c { signed short v1:1; unsigned char v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1s_BFu1c_BFs1i_BFu1i { signed short v1:1; unsigned char v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1s_BFu1c_BFs1i_BFu1ll { signed short v1:1; unsigned char v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1c_BFs1i_BFu1s { signed short v1:1; unsigned char v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1s_BFu1c_BFs1ll { signed short v1:1; unsigned char v2:1; signed long long v3:1; };
struct BFs1s_BFu1c_BFs1ll_BFs1c { signed short v1:1; unsigned char v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1s_BFu1c_BFs1ll_BFs1i { signed short v1:1; unsigned char v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1s_BFu1c_BFs1ll_BFs1ll { signed short v1:1; unsigned char v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1s_BFu1c_BFs1ll_BFs1s { signed short v1:1; unsigned char v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1s_BFu1c_BFs1ll_BFu1c { signed short v1:1; unsigned char v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1s_BFu1c_BFs1ll_BFu1i { signed short v1:1; unsigned char v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1s_BFu1c_BFs1ll_BFu1ll { signed short v1:1; unsigned char v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1c_BFs1ll_BFu1s { signed short v1:1; unsigned char v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1s_BFu1c_BFs1s { signed short v1:1; unsigned char v2:1; signed short v3:1; };
struct BFs1s_BFu1c_BFs1s_BFs1c { signed short v1:1; unsigned char v2:1; signed short v3:1; signed char v4:1; };
struct BFs1s_BFu1c_BFs1s_BFs1i { signed short v1:1; unsigned char v2:1; signed short v3:1; signed int v4:1; };
struct BFs1s_BFu1c_BFs1s_BFs1ll { signed short v1:1; unsigned char v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1s_BFu1c_BFs1s_BFs1s { signed short v1:1; unsigned char v2:1; signed short v3:1; signed short v4:1; };
struct BFs1s_BFu1c_BFs1s_BFu1c { signed short v1:1; unsigned char v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1s_BFu1c_BFs1s_BFu1i { signed short v1:1; unsigned char v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1s_BFu1c_BFs1s_BFu1ll { signed short v1:1; unsigned char v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1c_BFs1s_BFu1s { signed short v1:1; unsigned char v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1s_BFu1c_BFu1c { signed short v1:1; unsigned char v2:1; unsigned char v3:1; };
struct BFs1s_BFu1c_BFu1c_BFs1c { signed short v1:1; unsigned char v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1s_BFu1c_BFu1c_BFs1i { signed short v1:1; unsigned char v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1s_BFu1c_BFu1c_BFs1ll { signed short v1:1; unsigned char v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1s_BFu1c_BFu1c_BFs1s { signed short v1:1; unsigned char v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1s_BFu1c_BFu1c_BFu1c { signed short v1:1; unsigned char v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1s_BFu1c_BFu1c_BFu1i { signed short v1:1; unsigned char v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1s_BFu1c_BFu1c_BFu1ll { signed short v1:1; unsigned char v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1c_BFu1c_BFu1s { signed short v1:1; unsigned char v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1s_BFu1c_BFu1i { signed short v1:1; unsigned char v2:1; unsigned int v3:1; };
struct BFs1s_BFu1c_BFu1i_BFs1c { signed short v1:1; unsigned char v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1s_BFu1c_BFu1i_BFs1i { signed short v1:1; unsigned char v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1s_BFu1c_BFu1i_BFs1ll { signed short v1:1; unsigned char v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1s_BFu1c_BFu1i_BFs1s { signed short v1:1; unsigned char v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1s_BFu1c_BFu1i_BFu1c { signed short v1:1; unsigned char v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1s_BFu1c_BFu1i_BFu1i { signed short v1:1; unsigned char v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1s_BFu1c_BFu1i_BFu1ll { signed short v1:1; unsigned char v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1c_BFu1i_BFu1s { signed short v1:1; unsigned char v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1s_BFu1c_BFu1ll { signed short v1:1; unsigned char v2:1; unsigned long long v3:1; };
struct BFs1s_BFu1c_BFu1ll_BFs1c { signed short v1:1; unsigned char v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1s_BFu1c_BFu1ll_BFs1i { signed short v1:1; unsigned char v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1s_BFu1c_BFu1ll_BFs1ll { signed short v1:1; unsigned char v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1s_BFu1c_BFu1ll_BFs1s { signed short v1:1; unsigned char v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1s_BFu1c_BFu1ll_BFu1c { signed short v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1s_BFu1c_BFu1ll_BFu1i { signed short v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1s_BFu1c_BFu1ll_BFu1ll { signed short v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1c_BFu1ll_BFu1s { signed short v1:1; unsigned char v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1s_BFu1c_BFu1s { signed short v1:1; unsigned char v2:1; unsigned short v3:1; };
struct BFs1s_BFu1c_BFu1s_BFs1c { signed short v1:1; unsigned char v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1s_BFu1c_BFu1s_BFs1i { signed short v1:1; unsigned char v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1s_BFu1c_BFu1s_BFs1ll { signed short v1:1; unsigned char v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1s_BFu1c_BFu1s_BFs1s { signed short v1:1; unsigned char v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1s_BFu1c_BFu1s_BFu1c { signed short v1:1; unsigned char v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1s_BFu1c_BFu1s_BFu1i { signed short v1:1; unsigned char v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1s_BFu1c_BFu1s_BFu1ll { signed short v1:1; unsigned char v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1c_BFu1s_BFu1s { signed short v1:1; unsigned char v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1s_BFu1i { signed short v1:1; unsigned int v2:1; };
struct BFs1s_BFu1i_BFs1c { signed short v1:1; unsigned int v2:1; signed char v3:1; };
struct BFs1s_BFu1i_BFs1c_BFs1c { signed short v1:1; unsigned int v2:1; signed char v3:1; signed char v4:1; };
struct BFs1s_BFu1i_BFs1c_BFs1i { signed short v1:1; unsigned int v2:1; signed char v3:1; signed int v4:1; };
struct BFs1s_BFu1i_BFs1c_BFs1ll { signed short v1:1; unsigned int v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1s_BFu1i_BFs1c_BFs1s { signed short v1:1; unsigned int v2:1; signed char v3:1; signed short v4:1; };
struct BFs1s_BFu1i_BFs1c_BFu1c { signed short v1:1; unsigned int v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1s_BFu1i_BFs1c_BFu1i { signed short v1:1; unsigned int v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1s_BFu1i_BFs1c_BFu1ll { signed short v1:1; unsigned int v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1i_BFs1c_BFu1s { signed short v1:1; unsigned int v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1s_BFu1i_BFs1i { signed short v1:1; unsigned int v2:1; signed int v3:1; };
struct BFs1s_BFu1i_BFs1i_BFs1c { signed short v1:1; unsigned int v2:1; signed int v3:1; signed char v4:1; };
struct BFs1s_BFu1i_BFs1i_BFs1i { signed short v1:1; unsigned int v2:1; signed int v3:1; signed int v4:1; };
struct BFs1s_BFu1i_BFs1i_BFs1ll { signed short v1:1; unsigned int v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1s_BFu1i_BFs1i_BFs1s { signed short v1:1; unsigned int v2:1; signed int v3:1; signed short v4:1; };
struct BFs1s_BFu1i_BFs1i_BFu1c { signed short v1:1; unsigned int v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1s_BFu1i_BFs1i_BFu1i { signed short v1:1; unsigned int v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1s_BFu1i_BFs1i_BFu1ll { signed short v1:1; unsigned int v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1i_BFs1i_BFu1s { signed short v1:1; unsigned int v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1s_BFu1i_BFs1ll { signed short v1:1; unsigned int v2:1; signed long long v3:1; };
struct BFs1s_BFu1i_BFs1ll_BFs1c { signed short v1:1; unsigned int v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1s_BFu1i_BFs1ll_BFs1i { signed short v1:1; unsigned int v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1s_BFu1i_BFs1ll_BFs1ll { signed short v1:1; unsigned int v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1s_BFu1i_BFs1ll_BFs1s { signed short v1:1; unsigned int v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1s_BFu1i_BFs1ll_BFu1c { signed short v1:1; unsigned int v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1s_BFu1i_BFs1ll_BFu1i { signed short v1:1; unsigned int v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1s_BFu1i_BFs1ll_BFu1ll { signed short v1:1; unsigned int v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1i_BFs1ll_BFu1s { signed short v1:1; unsigned int v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1s_BFu1i_BFs1s { signed short v1:1; unsigned int v2:1; signed short v3:1; };
struct BFs1s_BFu1i_BFs1s_BFs1c { signed short v1:1; unsigned int v2:1; signed short v3:1; signed char v4:1; };
struct BFs1s_BFu1i_BFs1s_BFs1i { signed short v1:1; unsigned int v2:1; signed short v3:1; signed int v4:1; };
struct BFs1s_BFu1i_BFs1s_BFs1ll { signed short v1:1; unsigned int v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1s_BFu1i_BFs1s_BFs1s { signed short v1:1; unsigned int v2:1; signed short v3:1; signed short v4:1; };
struct BFs1s_BFu1i_BFs1s_BFu1c { signed short v1:1; unsigned int v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1s_BFu1i_BFs1s_BFu1i { signed short v1:1; unsigned int v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1s_BFu1i_BFs1s_BFu1ll { signed short v1:1; unsigned int v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1i_BFs1s_BFu1s { signed short v1:1; unsigned int v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1s_BFu1i_BFu1c { signed short v1:1; unsigned int v2:1; unsigned char v3:1; };
struct BFs1s_BFu1i_BFu1c_BFs1c { signed short v1:1; unsigned int v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1s_BFu1i_BFu1c_BFs1i { signed short v1:1; unsigned int v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1s_BFu1i_BFu1c_BFs1ll { signed short v1:1; unsigned int v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1s_BFu1i_BFu1c_BFs1s { signed short v1:1; unsigned int v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1s_BFu1i_BFu1c_BFu1c { signed short v1:1; unsigned int v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1s_BFu1i_BFu1c_BFu1i { signed short v1:1; unsigned int v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1s_BFu1i_BFu1c_BFu1ll { signed short v1:1; unsigned int v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1i_BFu1c_BFu1s { signed short v1:1; unsigned int v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1s_BFu1i_BFu1i { signed short v1:1; unsigned int v2:1; unsigned int v3:1; };
struct BFs1s_BFu1i_BFu1i_BFs1c { signed short v1:1; unsigned int v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1s_BFu1i_BFu1i_BFs1i { signed short v1:1; unsigned int v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1s_BFu1i_BFu1i_BFs1ll { signed short v1:1; unsigned int v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1s_BFu1i_BFu1i_BFs1s { signed short v1:1; unsigned int v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1s_BFu1i_BFu1i_BFu1c { signed short v1:1; unsigned int v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1s_BFu1i_BFu1i_BFu1i { signed short v1:1; unsigned int v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1s_BFu1i_BFu1i_BFu1ll { signed short v1:1; unsigned int v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1i_BFu1i_BFu1s { signed short v1:1; unsigned int v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1s_BFu1i_BFu1ll { signed short v1:1; unsigned int v2:1; unsigned long long v3:1; };
struct BFs1s_BFu1i_BFu1ll_BFs1c { signed short v1:1; unsigned int v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1s_BFu1i_BFu1ll_BFs1i { signed short v1:1; unsigned int v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1s_BFu1i_BFu1ll_BFs1ll { signed short v1:1; unsigned int v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1s_BFu1i_BFu1ll_BFs1s { signed short v1:1; unsigned int v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1s_BFu1i_BFu1ll_BFu1c { signed short v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1s_BFu1i_BFu1ll_BFu1i { signed short v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1s_BFu1i_BFu1ll_BFu1ll { signed short v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1i_BFu1ll_BFu1s { signed short v1:1; unsigned int v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1s_BFu1i_BFu1s { signed short v1:1; unsigned int v2:1; unsigned short v3:1; };
struct BFs1s_BFu1i_BFu1s_BFs1c { signed short v1:1; unsigned int v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1s_BFu1i_BFu1s_BFs1i { signed short v1:1; unsigned int v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1s_BFu1i_BFu1s_BFs1ll { signed short v1:1; unsigned int v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1s_BFu1i_BFu1s_BFs1s { signed short v1:1; unsigned int v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1s_BFu1i_BFu1s_BFu1c { signed short v1:1; unsigned int v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1s_BFu1i_BFu1s_BFu1i { signed short v1:1; unsigned int v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1s_BFu1i_BFu1s_BFu1ll { signed short v1:1; unsigned int v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1i_BFu1s_BFu1s { signed short v1:1; unsigned int v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1s_BFu1ll { signed short v1:1; unsigned long long v2:1; };
struct BFs1s_BFu1ll_BFs1c { signed short v1:1; unsigned long long v2:1; signed char v3:1; };
struct BFs1s_BFu1ll_BFs1c_BFs1c { signed short v1:1; unsigned long long v2:1; signed char v3:1; signed char v4:1; };
struct BFs1s_BFu1ll_BFs1c_BFs1i { signed short v1:1; unsigned long long v2:1; signed char v3:1; signed int v4:1; };
struct BFs1s_BFu1ll_BFs1c_BFs1ll { signed short v1:1; unsigned long long v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1s_BFu1ll_BFs1c_BFs1s { signed short v1:1; unsigned long long v2:1; signed char v3:1; signed short v4:1; };
struct BFs1s_BFu1ll_BFs1c_BFu1c { signed short v1:1; unsigned long long v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1s_BFu1ll_BFs1c_BFu1i { signed short v1:1; unsigned long long v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1s_BFu1ll_BFs1c_BFu1ll { signed short v1:1; unsigned long long v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1ll_BFs1c_BFu1s { signed short v1:1; unsigned long long v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1s_BFu1ll_BFs1i { signed short v1:1; unsigned long long v2:1; signed int v3:1; };
struct BFs1s_BFu1ll_BFs1i_BFs1c { signed short v1:1; unsigned long long v2:1; signed int v3:1; signed char v4:1; };
struct BFs1s_BFu1ll_BFs1i_BFs1i { signed short v1:1; unsigned long long v2:1; signed int v3:1; signed int v4:1; };
struct BFs1s_BFu1ll_BFs1i_BFs1ll { signed short v1:1; unsigned long long v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1s_BFu1ll_BFs1i_BFs1s { signed short v1:1; unsigned long long v2:1; signed int v3:1; signed short v4:1; };
struct BFs1s_BFu1ll_BFs1i_BFu1c { signed short v1:1; unsigned long long v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1s_BFu1ll_BFs1i_BFu1i { signed short v1:1; unsigned long long v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1s_BFu1ll_BFs1i_BFu1ll { signed short v1:1; unsigned long long v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1ll_BFs1i_BFu1s { signed short v1:1; unsigned long long v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1s_BFu1ll_BFs1ll { signed short v1:1; unsigned long long v2:1; signed long long v3:1; };
struct BFs1s_BFu1ll_BFs1ll_BFs1c { signed short v1:1; unsigned long long v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1s_BFu1ll_BFs1ll_BFs1i { signed short v1:1; unsigned long long v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1s_BFu1ll_BFs1ll_BFs1ll { signed short v1:1; unsigned long long v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1s_BFu1ll_BFs1ll_BFs1s { signed short v1:1; unsigned long long v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1s_BFu1ll_BFs1ll_BFu1c { signed short v1:1; unsigned long long v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1s_BFu1ll_BFs1ll_BFu1i { signed short v1:1; unsigned long long v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1s_BFu1ll_BFs1ll_BFu1ll { signed short v1:1; unsigned long long v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1ll_BFs1ll_BFu1s { signed short v1:1; unsigned long long v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1s_BFu1ll_BFs1s { signed short v1:1; unsigned long long v2:1; signed short v3:1; };
struct BFs1s_BFu1ll_BFs1s_BFs1c { signed short v1:1; unsigned long long v2:1; signed short v3:1; signed char v4:1; };
struct BFs1s_BFu1ll_BFs1s_BFs1i { signed short v1:1; unsigned long long v2:1; signed short v3:1; signed int v4:1; };
struct BFs1s_BFu1ll_BFs1s_BFs1ll { signed short v1:1; unsigned long long v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1s_BFu1ll_BFs1s_BFs1s { signed short v1:1; unsigned long long v2:1; signed short v3:1; signed short v4:1; };
struct BFs1s_BFu1ll_BFs1s_BFu1c { signed short v1:1; unsigned long long v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1s_BFu1ll_BFs1s_BFu1i { signed short v1:1; unsigned long long v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1s_BFu1ll_BFs1s_BFu1ll { signed short v1:1; unsigned long long v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1ll_BFs1s_BFu1s { signed short v1:1; unsigned long long v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1s_BFu1ll_BFu1c { signed short v1:1; unsigned long long v2:1; unsigned char v3:1; };
struct BFs1s_BFu1ll_BFu1c_BFs1c { signed short v1:1; unsigned long long v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1s_BFu1ll_BFu1c_BFs1i { signed short v1:1; unsigned long long v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1s_BFu1ll_BFu1c_BFs1ll { signed short v1:1; unsigned long long v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1s_BFu1ll_BFu1c_BFs1s { signed short v1:1; unsigned long long v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1s_BFu1ll_BFu1c_BFu1c { signed short v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1s_BFu1ll_BFu1c_BFu1i { signed short v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1s_BFu1ll_BFu1c_BFu1ll { signed short v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1ll_BFu1c_BFu1s { signed short v1:1; unsigned long long v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1s_BFu1ll_BFu1i { signed short v1:1; unsigned long long v2:1; unsigned int v3:1; };
struct BFs1s_BFu1ll_BFu1i_BFs1c { signed short v1:1; unsigned long long v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1s_BFu1ll_BFu1i_BFs1i { signed short v1:1; unsigned long long v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1s_BFu1ll_BFu1i_BFs1ll { signed short v1:1; unsigned long long v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1s_BFu1ll_BFu1i_BFs1s { signed short v1:1; unsigned long long v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1s_BFu1ll_BFu1i_BFu1c { signed short v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1s_BFu1ll_BFu1i_BFu1i { signed short v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1s_BFu1ll_BFu1i_BFu1ll { signed short v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1ll_BFu1i_BFu1s { signed short v1:1; unsigned long long v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1s_BFu1ll_BFu1ll { signed short v1:1; unsigned long long v2:1; unsigned long long v3:1; };
struct BFs1s_BFu1ll_BFu1ll_BFs1c { signed short v1:1; unsigned long long v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1s_BFu1ll_BFu1ll_BFs1i { signed short v1:1; unsigned long long v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1s_BFu1ll_BFu1ll_BFs1ll { signed short v1:1; unsigned long long v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1s_BFu1ll_BFu1ll_BFs1s { signed short v1:1; unsigned long long v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1s_BFu1ll_BFu1ll_BFu1c { signed short v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1s_BFu1ll_BFu1ll_BFu1i { signed short v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1s_BFu1ll_BFu1ll_BFu1ll { signed short v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1ll_BFu1ll_BFu1s { signed short v1:1; unsigned long long v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1s_BFu1ll_BFu1s { signed short v1:1; unsigned long long v2:1; unsigned short v3:1; };
struct BFs1s_BFu1ll_BFu1s_BFs1c { signed short v1:1; unsigned long long v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1s_BFu1ll_BFu1s_BFs1i { signed short v1:1; unsigned long long v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1s_BFu1ll_BFu1s_BFs1ll { signed short v1:1; unsigned long long v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1s_BFu1ll_BFu1s_BFs1s { signed short v1:1; unsigned long long v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1s_BFu1ll_BFu1s_BFu1c { signed short v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1s_BFu1ll_BFu1s_BFu1i { signed short v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1s_BFu1ll_BFu1s_BFu1ll { signed short v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1ll_BFu1s_BFu1s { signed short v1:1; unsigned long long v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1s_BFu1s { signed short v1:1; unsigned short v2:1; };
struct BFs1s_BFu1s_BFs1c { signed short v1:1; unsigned short v2:1; signed char v3:1; };
struct BFs1s_BFu1s_BFs1c_BFs1c { signed short v1:1; unsigned short v2:1; signed char v3:1; signed char v4:1; };
struct BFs1s_BFu1s_BFs1c_BFs1i { signed short v1:1; unsigned short v2:1; signed char v3:1; signed int v4:1; };
struct BFs1s_BFu1s_BFs1c_BFs1ll { signed short v1:1; unsigned short v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1s_BFu1s_BFs1c_BFs1s { signed short v1:1; unsigned short v2:1; signed char v3:1; signed short v4:1; };
struct BFs1s_BFu1s_BFs1c_BFu1c { signed short v1:1; unsigned short v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1s_BFu1s_BFs1c_BFu1i { signed short v1:1; unsigned short v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1s_BFu1s_BFs1c_BFu1ll { signed short v1:1; unsigned short v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1s_BFs1c_BFu1s { signed short v1:1; unsigned short v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1s_BFu1s_BFs1i { signed short v1:1; unsigned short v2:1; signed int v3:1; };
struct BFs1s_BFu1s_BFs1i_BFs1c { signed short v1:1; unsigned short v2:1; signed int v3:1; signed char v4:1; };
struct BFs1s_BFu1s_BFs1i_BFs1i { signed short v1:1; unsigned short v2:1; signed int v3:1; signed int v4:1; };
struct BFs1s_BFu1s_BFs1i_BFs1ll { signed short v1:1; unsigned short v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1s_BFu1s_BFs1i_BFs1s { signed short v1:1; unsigned short v2:1; signed int v3:1; signed short v4:1; };
struct BFs1s_BFu1s_BFs1i_BFu1c { signed short v1:1; unsigned short v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1s_BFu1s_BFs1i_BFu1i { signed short v1:1; unsigned short v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1s_BFu1s_BFs1i_BFu1ll { signed short v1:1; unsigned short v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1s_BFs1i_BFu1s { signed short v1:1; unsigned short v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1s_BFu1s_BFs1ll { signed short v1:1; unsigned short v2:1; signed long long v3:1; };
struct BFs1s_BFu1s_BFs1ll_BFs1c { signed short v1:1; unsigned short v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1s_BFu1s_BFs1ll_BFs1i { signed short v1:1; unsigned short v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1s_BFu1s_BFs1ll_BFs1ll { signed short v1:1; unsigned short v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1s_BFu1s_BFs1ll_BFs1s { signed short v1:1; unsigned short v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1s_BFu1s_BFs1ll_BFu1c { signed short v1:1; unsigned short v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1s_BFu1s_BFs1ll_BFu1i { signed short v1:1; unsigned short v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1s_BFu1s_BFs1ll_BFu1ll { signed short v1:1; unsigned short v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1s_BFs1ll_BFu1s { signed short v1:1; unsigned short v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1s_BFu1s_BFs1s { signed short v1:1; unsigned short v2:1; signed short v3:1; };
struct BFs1s_BFu1s_BFs1s_BFs1c { signed short v1:1; unsigned short v2:1; signed short v3:1; signed char v4:1; };
struct BFs1s_BFu1s_BFs1s_BFs1i { signed short v1:1; unsigned short v2:1; signed short v3:1; signed int v4:1; };
struct BFs1s_BFu1s_BFs1s_BFs1ll { signed short v1:1; unsigned short v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1s_BFu1s_BFs1s_BFs1s { signed short v1:1; unsigned short v2:1; signed short v3:1; signed short v4:1; };
struct BFs1s_BFu1s_BFs1s_BFu1c { signed short v1:1; unsigned short v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1s_BFu1s_BFs1s_BFu1i { signed short v1:1; unsigned short v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1s_BFu1s_BFs1s_BFu1ll { signed short v1:1; unsigned short v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1s_BFs1s_BFu1s { signed short v1:1; unsigned short v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1s_BFu1s_BFu1c { signed short v1:1; unsigned short v2:1; unsigned char v3:1; };
struct BFs1s_BFu1s_BFu1c_BFs1c { signed short v1:1; unsigned short v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1s_BFu1s_BFu1c_BFs1i { signed short v1:1; unsigned short v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1s_BFu1s_BFu1c_BFs1ll { signed short v1:1; unsigned short v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1s_BFu1s_BFu1c_BFs1s { signed short v1:1; unsigned short v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1s_BFu1s_BFu1c_BFu1c { signed short v1:1; unsigned short v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1s_BFu1s_BFu1c_BFu1i { signed short v1:1; unsigned short v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1s_BFu1s_BFu1c_BFu1ll { signed short v1:1; unsigned short v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1s_BFu1c_BFu1s { signed short v1:1; unsigned short v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1s_BFu1s_BFu1i { signed short v1:1; unsigned short v2:1; unsigned int v3:1; };
struct BFs1s_BFu1s_BFu1i_BFs1c { signed short v1:1; unsigned short v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1s_BFu1s_BFu1i_BFs1i { signed short v1:1; unsigned short v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1s_BFu1s_BFu1i_BFs1ll { signed short v1:1; unsigned short v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1s_BFu1s_BFu1i_BFs1s { signed short v1:1; unsigned short v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1s_BFu1s_BFu1i_BFu1c { signed short v1:1; unsigned short v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1s_BFu1s_BFu1i_BFu1i { signed short v1:1; unsigned short v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1s_BFu1s_BFu1i_BFu1ll { signed short v1:1; unsigned short v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1s_BFu1i_BFu1s { signed short v1:1; unsigned short v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1s_BFu1s_BFu1ll { signed short v1:1; unsigned short v2:1; unsigned long long v3:1; };
struct BFs1s_BFu1s_BFu1ll_BFs1c { signed short v1:1; unsigned short v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1s_BFu1s_BFu1ll_BFs1i { signed short v1:1; unsigned short v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1s_BFu1s_BFu1ll_BFs1ll { signed short v1:1; unsigned short v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1s_BFu1s_BFu1ll_BFs1s { signed short v1:1; unsigned short v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1s_BFu1s_BFu1ll_BFu1c { signed short v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1s_BFu1s_BFu1ll_BFu1i { signed short v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1s_BFu1s_BFu1ll_BFu1ll { signed short v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1s_BFu1ll_BFu1s { signed short v1:1; unsigned short v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1s_BFu1s_BFu1s { signed short v1:1; unsigned short v2:1; unsigned short v3:1; };
struct BFs1s_BFu1s_BFu1s_BFs1c { signed short v1:1; unsigned short v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1s_BFu1s_BFu1s_BFs1i { signed short v1:1; unsigned short v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1s_BFu1s_BFu1s_BFs1ll { signed short v1:1; unsigned short v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1s_BFu1s_BFu1s_BFs1s { signed short v1:1; unsigned short v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1s_BFu1s_BFu1s_BFu1c { signed short v1:1; unsigned short v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1s_BFu1s_BFu1s_BFu1i { signed short v1:1; unsigned short v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1s_BFu1s_BFu1s_BFu1ll { signed short v1:1; unsigned short v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1s_BFu1s_BFu1s_BFu1s { signed short v1:1; unsigned short v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs31i_BFs31i { signed int v1:31; signed int v2:31; };
struct BFs31i_BFs31i_BFs31i { signed int v1:31; signed int v2:31; signed int v3:31; };
struct BFs31i_BFs31i_BFs31i_BFs31i { signed int v1:31; signed int v2:31; signed int v3:31; signed int v4:31; };
struct BFs31i_BFs31i_BFs31i_BFs31ll { signed int v1:31; signed int v2:31; signed int v3:31; signed long long v4:31; };
struct BFs31i_BFs31i_BFs31i_BFu31i { signed int v1:31; signed int v2:31; signed int v3:31; unsigned int v4:31; };
struct BFs31i_BFs31i_BFs31i_BFu31ll { signed int v1:31; signed int v2:31; signed int v3:31; unsigned long long v4:31; };
struct BFs31i_BFs31i_BFs31ll { signed int v1:31; signed int v2:31; signed long long v3:31; };
struct BFs31i_BFs31i_BFs31ll_BFs31i { signed int v1:31; signed int v2:31; signed long long v3:31; signed int v4:31; };
struct BFs31i_BFs31i_BFs31ll_BFs31ll { signed int v1:31; signed int v2:31; signed long long v3:31; signed long long v4:31; };
struct BFs31i_BFs31i_BFs31ll_BFu31i { signed int v1:31; signed int v2:31; signed long long v3:31; unsigned int v4:31; };
struct BFs31i_BFs31i_BFs31ll_BFu31ll { signed int v1:31; signed int v2:31; signed long long v3:31; unsigned long long v4:31; };
struct BFs31i_BFs31i_BFu31i { signed int v1:31; signed int v2:31; unsigned int v3:31; };
struct BFs31i_BFs31i_BFu31i_BFs31i { signed int v1:31; signed int v2:31; unsigned int v3:31; signed int v4:31; };
struct BFs31i_BFs31i_BFu31i_BFs31ll { signed int v1:31; signed int v2:31; unsigned int v3:31; signed long long v4:31; };
struct BFs31i_BFs31i_BFu31i_BFu31i { signed int v1:31; signed int v2:31; unsigned int v3:31; unsigned int v4:31; };
struct BFs31i_BFs31i_BFu31i_BFu31ll { signed int v1:31; signed int v2:31; unsigned int v3:31; unsigned long long v4:31; };
struct BFs31i_BFs31i_BFu31ll { signed int v1:31; signed int v2:31; unsigned long long v3:31; };
struct BFs31i_BFs31i_BFu31ll_BFs31i { signed int v1:31; signed int v2:31; unsigned long long v3:31; signed int v4:31; };
struct BFs31i_BFs31i_BFu31ll_BFs31ll { signed int v1:31; signed int v2:31; unsigned long long v3:31; signed long long v4:31; };
struct BFs31i_BFs31i_BFu31ll_BFu31i { signed int v1:31; signed int v2:31; unsigned long long v3:31; unsigned int v4:31; };
struct BFs31i_BFs31i_BFu31ll_BFu31ll { signed int v1:31; signed int v2:31; unsigned long long v3:31; unsigned long long v4:31; };
struct BFs31i_BFs31ll { signed int v1:31; signed long long v2:31; };
struct BFs31i_BFs31ll_BFs31i { signed int v1:31; signed long long v2:31; signed int v3:31; };
struct BFs31i_BFs31ll_BFs31i_BFs31i { signed int v1:31; signed long long v2:31; signed int v3:31; signed int v4:31; };
struct BFs31i_BFs31ll_BFs31i_BFs31ll { signed int v1:31; signed long long v2:31; signed int v3:31; signed long long v4:31; };
struct BFs31i_BFs31ll_BFs31i_BFu31i { signed int v1:31; signed long long v2:31; signed int v3:31; unsigned int v4:31; };
struct BFs31i_BFs31ll_BFs31i_BFu31ll { signed int v1:31; signed long long v2:31; signed int v3:31; unsigned long long v4:31; };
struct BFs31i_BFs31ll_BFs31ll { signed int v1:31; signed long long v2:31; signed long long v3:31; };
struct BFs31i_BFs31ll_BFs31ll_BFs31i { signed int v1:31; signed long long v2:31; signed long long v3:31; signed int v4:31; };
struct BFs31i_BFs31ll_BFs31ll_BFs31ll { signed int v1:31; signed long long v2:31; signed long long v3:31; signed long long v4:31; };
struct BFs31i_BFs31ll_BFs31ll_BFu31i { signed int v1:31; signed long long v2:31; signed long long v3:31; unsigned int v4:31; };
struct BFs31i_BFs31ll_BFs31ll_BFu31ll { signed int v1:31; signed long long v2:31; signed long long v3:31; unsigned long long v4:31; };
struct BFs31i_BFs31ll_BFu31i { signed int v1:31; signed long long v2:31; unsigned int v3:31; };
struct BFs31i_BFs31ll_BFu31i_BFs31i { signed int v1:31; signed long long v2:31; unsigned int v3:31; signed int v4:31; };
struct BFs31i_BFs31ll_BFu31i_BFs31ll { signed int v1:31; signed long long v2:31; unsigned int v3:31; signed long long v4:31; };
struct BFs31i_BFs31ll_BFu31i_BFu31i { signed int v1:31; signed long long v2:31; unsigned int v3:31; unsigned int v4:31; };
struct BFs31i_BFs31ll_BFu31i_BFu31ll { signed int v1:31; signed long long v2:31; unsigned int v3:31; unsigned long long v4:31; };
struct BFs31i_BFs31ll_BFu31ll { signed int v1:31; signed long long v2:31; unsigned long long v3:31; };
struct BFs31i_BFs31ll_BFu31ll_BFs31i { signed int v1:31; signed long long v2:31; unsigned long long v3:31; signed int v4:31; };
struct BFs31i_BFs31ll_BFu31ll_BFs31ll { signed int v1:31; signed long long v2:31; unsigned long long v3:31; signed long long v4:31; };
struct BFs31i_BFs31ll_BFu31ll_BFu31i { signed int v1:31; signed long long v2:31; unsigned long long v3:31; unsigned int v4:31; };
struct BFs31i_BFs31ll_BFu31ll_BFu31ll { signed int v1:31; signed long long v2:31; unsigned long long v3:31; unsigned long long v4:31; };
struct BFs31i_BFu31i { signed int v1:31; unsigned int v2:31; };
struct BFs31i_BFu31i_BFs31i { signed int v1:31; unsigned int v2:31; signed int v3:31; };
struct BFs31i_BFu31i_BFs31i_BFs31i { signed int v1:31; unsigned int v2:31; signed int v3:31; signed int v4:31; };
struct BFs31i_BFu31i_BFs31i_BFs31ll { signed int v1:31; unsigned int v2:31; signed int v3:31; signed long long v4:31; };
struct BFs31i_BFu31i_BFs31i_BFu31i { signed int v1:31; unsigned int v2:31; signed int v3:31; unsigned int v4:31; };
struct BFs31i_BFu31i_BFs31i_BFu31ll { signed int v1:31; unsigned int v2:31; signed int v3:31; unsigned long long v4:31; };
struct BFs31i_BFu31i_BFs31ll { signed int v1:31; unsigned int v2:31; signed long long v3:31; };
struct BFs31i_BFu31i_BFs31ll_BFs31i { signed int v1:31; unsigned int v2:31; signed long long v3:31; signed int v4:31; };
struct BFs31i_BFu31i_BFs31ll_BFs31ll { signed int v1:31; unsigned int v2:31; signed long long v3:31; signed long long v4:31; };
struct BFs31i_BFu31i_BFs31ll_BFu31i { signed int v1:31; unsigned int v2:31; signed long long v3:31; unsigned int v4:31; };
struct BFs31i_BFu31i_BFs31ll_BFu31ll { signed int v1:31; unsigned int v2:31; signed long long v3:31; unsigned long long v4:31; };
struct BFs31i_BFu31i_BFu31i { signed int v1:31; unsigned int v2:31; unsigned int v3:31; };
struct BFs31i_BFu31i_BFu31i_BFs31i { signed int v1:31; unsigned int v2:31; unsigned int v3:31; signed int v4:31; };
struct BFs31i_BFu31i_BFu31i_BFs31ll { signed int v1:31; unsigned int v2:31; unsigned int v3:31; signed long long v4:31; };
struct BFs31i_BFu31i_BFu31i_BFu31i { signed int v1:31; unsigned int v2:31; unsigned int v3:31; unsigned int v4:31; };
struct BFs31i_BFu31i_BFu31i_BFu31ll { signed int v1:31; unsigned int v2:31; unsigned int v3:31; unsigned long long v4:31; };
struct BFs31i_BFu31i_BFu31ll { signed int v1:31; unsigned int v2:31; unsigned long long v3:31; };
struct BFs31i_BFu31i_BFu31ll_BFs31i { signed int v1:31; unsigned int v2:31; unsigned long long v3:31; signed int v4:31; };
struct BFs31i_BFu31i_BFu31ll_BFs31ll { signed int v1:31; unsigned int v2:31; unsigned long long v3:31; signed long long v4:31; };
struct BFs31i_BFu31i_BFu31ll_BFu31i { signed int v1:31; unsigned int v2:31; unsigned long long v3:31; unsigned int v4:31; };
struct BFs31i_BFu31i_BFu31ll_BFu31ll { signed int v1:31; unsigned int v2:31; unsigned long long v3:31; unsigned long long v4:31; };
struct BFs31i_BFu31ll { signed int v1:31; unsigned long long v2:31; };
struct BFs31i_BFu31ll_BFs31i { signed int v1:31; unsigned long long v2:31; signed int v3:31; };
struct BFs31i_BFu31ll_BFs31i_BFs31i { signed int v1:31; unsigned long long v2:31; signed int v3:31; signed int v4:31; };
struct BFs31i_BFu31ll_BFs31i_BFs31ll { signed int v1:31; unsigned long long v2:31; signed int v3:31; signed long long v4:31; };
struct BFs31i_BFu31ll_BFs31i_BFu31i { signed int v1:31; unsigned long long v2:31; signed int v3:31; unsigned int v4:31; };
struct BFs31i_BFu31ll_BFs31i_BFu31ll { signed int v1:31; unsigned long long v2:31; signed int v3:31; unsigned long long v4:31; };
struct BFs31i_BFu31ll_BFs31ll { signed int v1:31; unsigned long long v2:31; signed long long v3:31; };
struct BFs31i_BFu31ll_BFs31ll_BFs31i { signed int v1:31; unsigned long long v2:31; signed long long v3:31; signed int v4:31; };
struct BFs31i_BFu31ll_BFs31ll_BFs31ll { signed int v1:31; unsigned long long v2:31; signed long long v3:31; signed long long v4:31; };
struct BFs31i_BFu31ll_BFs31ll_BFu31i { signed int v1:31; unsigned long long v2:31; signed long long v3:31; unsigned int v4:31; };
struct BFs31i_BFu31ll_BFs31ll_BFu31ll { signed int v1:31; unsigned long long v2:31; signed long long v3:31; unsigned long long v4:31; };
struct BFs31i_BFu31ll_BFu31i { signed int v1:31; unsigned long long v2:31; unsigned int v3:31; };
struct BFs31i_BFu31ll_BFu31i_BFs31i { signed int v1:31; unsigned long long v2:31; unsigned int v3:31; signed int v4:31; };
struct BFs31i_BFu31ll_BFu31i_BFs31ll { signed int v1:31; unsigned long long v2:31; unsigned int v3:31; signed long long v4:31; };
struct BFs31i_BFu31ll_BFu31i_BFu31i { signed int v1:31; unsigned long long v2:31; unsigned int v3:31; unsigned int v4:31; };
struct BFs31i_BFu31ll_BFu31i_BFu31ll { signed int v1:31; unsigned long long v2:31; unsigned int v3:31; unsigned long long v4:31; };
struct BFs31i_BFu31ll_BFu31ll { signed int v1:31; unsigned long long v2:31; unsigned long long v3:31; };
struct BFs31i_BFu31ll_BFu31ll_BFs31i { signed int v1:31; unsigned long long v2:31; unsigned long long v3:31; signed int v4:31; };
struct BFs31i_BFu31ll_BFu31ll_BFs31ll { signed int v1:31; unsigned long long v2:31; unsigned long long v3:31; signed long long v4:31; };
struct BFs31i_BFu31ll_BFu31ll_BFu31i { signed int v1:31; unsigned long long v2:31; unsigned long long v3:31; unsigned int v4:31; };
struct BFs31i_BFu31ll_BFu31ll_BFu31ll { signed int v1:31; unsigned long long v2:31; unsigned long long v3:31; unsigned long long v4:31; };
struct BFs31ll_BFs31i { signed long long v1:31; signed int v2:31; };
struct BFs31ll_BFs31i_BFs31i { signed long long v1:31; signed int v2:31; signed int v3:31; };
struct BFs31ll_BFs31i_BFs31i_BFs31i { signed long long v1:31; signed int v2:31; signed int v3:31; signed int v4:31; };
struct BFs31ll_BFs31i_BFs31i_BFs31ll { signed long long v1:31; signed int v2:31; signed int v3:31; signed long long v4:31; };
struct BFs31ll_BFs31i_BFs31i_BFu31i { signed long long v1:31; signed int v2:31; signed int v3:31; unsigned int v4:31; };
struct BFs31ll_BFs31i_BFs31i_BFu31ll { signed long long v1:31; signed int v2:31; signed int v3:31; unsigned long long v4:31; };
struct BFs31ll_BFs31i_BFs31ll { signed long long v1:31; signed int v2:31; signed long long v3:31; };
struct BFs31ll_BFs31i_BFs31ll_BFs31i { signed long long v1:31; signed int v2:31; signed long long v3:31; signed int v4:31; };
struct BFs31ll_BFs31i_BFs31ll_BFs31ll { signed long long v1:31; signed int v2:31; signed long long v3:31; signed long long v4:31; };
struct BFs31ll_BFs31i_BFs31ll_BFu31i { signed long long v1:31; signed int v2:31; signed long long v3:31; unsigned int v4:31; };
struct BFs31ll_BFs31i_BFs31ll_BFu31ll { signed long long v1:31; signed int v2:31; signed long long v3:31; unsigned long long v4:31; };
struct BFs31ll_BFs31i_BFu31i { signed long long v1:31; signed int v2:31; unsigned int v3:31; };
struct BFs31ll_BFs31i_BFu31i_BFs31i { signed long long v1:31; signed int v2:31; unsigned int v3:31; signed int v4:31; };
struct BFs31ll_BFs31i_BFu31i_BFs31ll { signed long long v1:31; signed int v2:31; unsigned int v3:31; signed long long v4:31; };
struct BFs31ll_BFs31i_BFu31i_BFu31i { signed long long v1:31; signed int v2:31; unsigned int v3:31; unsigned int v4:31; };
struct BFs31ll_BFs31i_BFu31i_BFu31ll { signed long long v1:31; signed int v2:31; unsigned int v3:31; unsigned long long v4:31; };
struct BFs31ll_BFs31i_BFu31ll { signed long long v1:31; signed int v2:31; unsigned long long v3:31; };
struct BFs31ll_BFs31i_BFu31ll_BFs31i { signed long long v1:31; signed int v2:31; unsigned long long v3:31; signed int v4:31; };
struct BFs31ll_BFs31i_BFu31ll_BFs31ll { signed long long v1:31; signed int v2:31; unsigned long long v3:31; signed long long v4:31; };
struct BFs31ll_BFs31i_BFu31ll_BFu31i { signed long long v1:31; signed int v2:31; unsigned long long v3:31; unsigned int v4:31; };
struct BFs31ll_BFs31i_BFu31ll_BFu31ll { signed long long v1:31; signed int v2:31; unsigned long long v3:31; unsigned long long v4:31; };
struct BFs31ll_BFs31ll { signed long long v1:31; signed long long v2:31; };
struct BFs31ll_BFs31ll_BFs31i { signed long long v1:31; signed long long v2:31; signed int v3:31; };
struct BFs31ll_BFs31ll_BFs31i_BFs31i { signed long long v1:31; signed long long v2:31; signed int v3:31; signed int v4:31; };
struct BFs31ll_BFs31ll_BFs31i_BFs31ll { signed long long v1:31; signed long long v2:31; signed int v3:31; signed long long v4:31; };
struct BFs31ll_BFs31ll_BFs31i_BFu31i { signed long long v1:31; signed long long v2:31; signed int v3:31; unsigned int v4:31; };
struct BFs31ll_BFs31ll_BFs31i_BFu31ll { signed long long v1:31; signed long long v2:31; signed int v3:31; unsigned long long v4:31; };
struct BFs31ll_BFs31ll_BFs31ll { signed long long v1:31; signed long long v2:31; signed long long v3:31; };
struct BFs31ll_BFs31ll_BFs31ll_BFs31i { signed long long v1:31; signed long long v2:31; signed long long v3:31; signed int v4:31; };
struct BFs31ll_BFs31ll_BFs31ll_BFs31ll { signed long long v1:31; signed long long v2:31; signed long long v3:31; signed long long v4:31; };
struct BFs31ll_BFs31ll_BFs31ll_BFu31i { signed long long v1:31; signed long long v2:31; signed long long v3:31; unsigned int v4:31; };
struct BFs31ll_BFs31ll_BFs31ll_BFu31ll { signed long long v1:31; signed long long v2:31; signed long long v3:31; unsigned long long v4:31; };
struct BFs31ll_BFs31ll_BFu31i { signed long long v1:31; signed long long v2:31; unsigned int v3:31; };
struct BFs31ll_BFs31ll_BFu31i_BFs31i { signed long long v1:31; signed long long v2:31; unsigned int v3:31; signed int v4:31; };
struct BFs31ll_BFs31ll_BFu31i_BFs31ll { signed long long v1:31; signed long long v2:31; unsigned int v3:31; signed long long v4:31; };
struct BFs31ll_BFs31ll_BFu31i_BFu31i { signed long long v1:31; signed long long v2:31; unsigned int v3:31; unsigned int v4:31; };
struct BFs31ll_BFs31ll_BFu31i_BFu31ll { signed long long v1:31; signed long long v2:31; unsigned int v3:31; unsigned long long v4:31; };
struct BFs31ll_BFs31ll_BFu31ll { signed long long v1:31; signed long long v2:31; unsigned long long v3:31; };
struct BFs31ll_BFs31ll_BFu31ll_BFs31i { signed long long v1:31; signed long long v2:31; unsigned long long v3:31; signed int v4:31; };
struct BFs31ll_BFs31ll_BFu31ll_BFs31ll { signed long long v1:31; signed long long v2:31; unsigned long long v3:31; signed long long v4:31; };
struct BFs31ll_BFs31ll_BFu31ll_BFu31i { signed long long v1:31; signed long long v2:31; unsigned long long v3:31; unsigned int v4:31; };
struct BFs31ll_BFs31ll_BFu31ll_BFu31ll { signed long long v1:31; signed long long v2:31; unsigned long long v3:31; unsigned long long v4:31; };
struct BFs31ll_BFu31i { signed long long v1:31; unsigned int v2:31; };
struct BFs31ll_BFu31i_BFs31i { signed long long v1:31; unsigned int v2:31; signed int v3:31; };
struct BFs31ll_BFu31i_BFs31i_BFs31i { signed long long v1:31; unsigned int v2:31; signed int v3:31; signed int v4:31; };
struct BFs31ll_BFu31i_BFs31i_BFs31ll { signed long long v1:31; unsigned int v2:31; signed int v3:31; signed long long v4:31; };
struct BFs31ll_BFu31i_BFs31i_BFu31i { signed long long v1:31; unsigned int v2:31; signed int v3:31; unsigned int v4:31; };
struct BFs31ll_BFu31i_BFs31i_BFu31ll { signed long long v1:31; unsigned int v2:31; signed int v3:31; unsigned long long v4:31; };
struct BFs31ll_BFu31i_BFs31ll { signed long long v1:31; unsigned int v2:31; signed long long v3:31; };
struct BFs31ll_BFu31i_BFs31ll_BFs31i { signed long long v1:31; unsigned int v2:31; signed long long v3:31; signed int v4:31; };
struct BFs31ll_BFu31i_BFs31ll_BFs31ll { signed long long v1:31; unsigned int v2:31; signed long long v3:31; signed long long v4:31; };
struct BFs31ll_BFu31i_BFs31ll_BFu31i { signed long long v1:31; unsigned int v2:31; signed long long v3:31; unsigned int v4:31; };
struct BFs31ll_BFu31i_BFs31ll_BFu31ll { signed long long v1:31; unsigned int v2:31; signed long long v3:31; unsigned long long v4:31; };
struct BFs31ll_BFu31i_BFu31i { signed long long v1:31; unsigned int v2:31; unsigned int v3:31; };
struct BFs31ll_BFu31i_BFu31i_BFs31i { signed long long v1:31; unsigned int v2:31; unsigned int v3:31; signed int v4:31; };
struct BFs31ll_BFu31i_BFu31i_BFs31ll { signed long long v1:31; unsigned int v2:31; unsigned int v3:31; signed long long v4:31; };
struct BFs31ll_BFu31i_BFu31i_BFu31i { signed long long v1:31; unsigned int v2:31; unsigned int v3:31; unsigned int v4:31; };
struct BFs31ll_BFu31i_BFu31i_BFu31ll { signed long long v1:31; unsigned int v2:31; unsigned int v3:31; unsigned long long v4:31; };
struct BFs31ll_BFu31i_BFu31ll { signed long long v1:31; unsigned int v2:31; unsigned long long v3:31; };
struct BFs31ll_BFu31i_BFu31ll_BFs31i { signed long long v1:31; unsigned int v2:31; unsigned long long v3:31; signed int v4:31; };
struct BFs31ll_BFu31i_BFu31ll_BFs31ll { signed long long v1:31; unsigned int v2:31; unsigned long long v3:31; signed long long v4:31; };
struct BFs31ll_BFu31i_BFu31ll_BFu31i { signed long long v1:31; unsigned int v2:31; unsigned long long v3:31; unsigned int v4:31; };
struct BFs31ll_BFu31i_BFu31ll_BFu31ll { signed long long v1:31; unsigned int v2:31; unsigned long long v3:31; unsigned long long v4:31; };
struct BFs31ll_BFu31ll { signed long long v1:31; unsigned long long v2:31; };
struct BFs31ll_BFu31ll_BFs31i { signed long long v1:31; unsigned long long v2:31; signed int v3:31; };
struct BFs31ll_BFu31ll_BFs31i_BFs31i { signed long long v1:31; unsigned long long v2:31; signed int v3:31; signed int v4:31; };
struct BFs31ll_BFu31ll_BFs31i_BFs31ll { signed long long v1:31; unsigned long long v2:31; signed int v3:31; signed long long v4:31; };
struct BFs31ll_BFu31ll_BFs31i_BFu31i { signed long long v1:31; unsigned long long v2:31; signed int v3:31; unsigned int v4:31; };
struct BFs31ll_BFu31ll_BFs31i_BFu31ll { signed long long v1:31; unsigned long long v2:31; signed int v3:31; unsigned long long v4:31; };
struct BFs31ll_BFu31ll_BFs31ll { signed long long v1:31; unsigned long long v2:31; signed long long v3:31; };
struct BFs31ll_BFu31ll_BFs31ll_BFs31i { signed long long v1:31; unsigned long long v2:31; signed long long v3:31; signed int v4:31; };
struct BFs31ll_BFu31ll_BFs31ll_BFs31ll { signed long long v1:31; unsigned long long v2:31; signed long long v3:31; signed long long v4:31; };
struct BFs31ll_BFu31ll_BFs31ll_BFu31i { signed long long v1:31; unsigned long long v2:31; signed long long v3:31; unsigned int v4:31; };
struct BFs31ll_BFu31ll_BFs31ll_BFu31ll { signed long long v1:31; unsigned long long v2:31; signed long long v3:31; unsigned long long v4:31; };
struct BFs31ll_BFu31ll_BFu31i { signed long long v1:31; unsigned long long v2:31; unsigned int v3:31; };
struct BFs31ll_BFu31ll_BFu31i_BFs31i { signed long long v1:31; unsigned long long v2:31; unsigned int v3:31; signed int v4:31; };
struct BFs31ll_BFu31ll_BFu31i_BFs31ll { signed long long v1:31; unsigned long long v2:31; unsigned int v3:31; signed long long v4:31; };
struct BFs31ll_BFu31ll_BFu31i_BFu31i { signed long long v1:31; unsigned long long v2:31; unsigned int v3:31; unsigned int v4:31; };
struct BFs31ll_BFu31ll_BFu31i_BFu31ll { signed long long v1:31; unsigned long long v2:31; unsigned int v3:31; unsigned long long v4:31; };
struct BFs31ll_BFu31ll_BFu31ll { signed long long v1:31; unsigned long long v2:31; unsigned long long v3:31; };
struct BFs31ll_BFu31ll_BFu31ll_BFs31i { signed long long v1:31; unsigned long long v2:31; unsigned long long v3:31; signed int v4:31; };
struct BFs31ll_BFu31ll_BFu31ll_BFs31ll { signed long long v1:31; unsigned long long v2:31; unsigned long long v3:31; signed long long v4:31; };
struct BFs31ll_BFu31ll_BFu31ll_BFu31i { signed long long v1:31; unsigned long long v2:31; unsigned long long v3:31; unsigned int v4:31; };
struct BFs31ll_BFu31ll_BFu31ll_BFu31ll { signed long long v1:31; unsigned long long v2:31; unsigned long long v3:31; unsigned long long v4:31; };
struct BFs32i_BFs32i { signed int v1:32; signed int v2:32; };
struct BFs32i_BFs32i_BFs32i { signed int v1:32; signed int v2:32; signed int v3:32; };
struct BFs32i_BFs32i_BFs32i_BFs32i { signed int v1:32; signed int v2:32; signed int v3:32; signed int v4:32; };
struct BFs32i_BFs32i_BFs32i_BFs32ll { signed int v1:32; signed int v2:32; signed int v3:32; signed long long v4:32; };
struct BFs32i_BFs32i_BFs32i_BFu32i { signed int v1:32; signed int v2:32; signed int v3:32; unsigned int v4:32; };
struct BFs32i_BFs32i_BFs32i_BFu32ll { signed int v1:32; signed int v2:32; signed int v3:32; unsigned long long v4:32; };
struct BFs32i_BFs32i_BFs32ll { signed int v1:32; signed int v2:32; signed long long v3:32; };
struct BFs32i_BFs32i_BFs32ll_BFs32i { signed int v1:32; signed int v2:32; signed long long v3:32; signed int v4:32; };
struct BFs32i_BFs32i_BFs32ll_BFs32ll { signed int v1:32; signed int v2:32; signed long long v3:32; signed long long v4:32; };
struct BFs32i_BFs32i_BFs32ll_BFu32i { signed int v1:32; signed int v2:32; signed long long v3:32; unsigned int v4:32; };
struct BFs32i_BFs32i_BFs32ll_BFu32ll { signed int v1:32; signed int v2:32; signed long long v3:32; unsigned long long v4:32; };
struct BFs32i_BFs32i_BFu32i { signed int v1:32; signed int v2:32; unsigned int v3:32; };
struct BFs32i_BFs32i_BFu32i_BFs32i { signed int v1:32; signed int v2:32; unsigned int v3:32; signed int v4:32; };
struct BFs32i_BFs32i_BFu32i_BFs32ll { signed int v1:32; signed int v2:32; unsigned int v3:32; signed long long v4:32; };
struct BFs32i_BFs32i_BFu32i_BFu32i { signed int v1:32; signed int v2:32; unsigned int v3:32; unsigned int v4:32; };
struct BFs32i_BFs32i_BFu32i_BFu32ll { signed int v1:32; signed int v2:32; unsigned int v3:32; unsigned long long v4:32; };
struct BFs32i_BFs32i_BFu32ll { signed int v1:32; signed int v2:32; unsigned long long v3:32; };
struct BFs32i_BFs32i_BFu32ll_BFs32i { signed int v1:32; signed int v2:32; unsigned long long v3:32; signed int v4:32; };
struct BFs32i_BFs32i_BFu32ll_BFs32ll { signed int v1:32; signed int v2:32; unsigned long long v3:32; signed long long v4:32; };
struct BFs32i_BFs32i_BFu32ll_BFu32i { signed int v1:32; signed int v2:32; unsigned long long v3:32; unsigned int v4:32; };
struct BFs32i_BFs32i_BFu32ll_BFu32ll { signed int v1:32; signed int v2:32; unsigned long long v3:32; unsigned long long v4:32; };
struct BFs32i_BFs32ll { signed int v1:32; signed long long v2:32; };
struct BFs32i_BFs32ll_BFs32i { signed int v1:32; signed long long v2:32; signed int v3:32; };
struct BFs32i_BFs32ll_BFs32i_BFs32i { signed int v1:32; signed long long v2:32; signed int v3:32; signed int v4:32; };
struct BFs32i_BFs32ll_BFs32i_BFs32ll { signed int v1:32; signed long long v2:32; signed int v3:32; signed long long v4:32; };
struct BFs32i_BFs32ll_BFs32i_BFu32i { signed int v1:32; signed long long v2:32; signed int v3:32; unsigned int v4:32; };
struct BFs32i_BFs32ll_BFs32i_BFu32ll { signed int v1:32; signed long long v2:32; signed int v3:32; unsigned long long v4:32; };
struct BFs32i_BFs32ll_BFs32ll { signed int v1:32; signed long long v2:32; signed long long v3:32; };
struct BFs32i_BFs32ll_BFs32ll_BFs32i { signed int v1:32; signed long long v2:32; signed long long v3:32; signed int v4:32; };
struct BFs32i_BFs32ll_BFs32ll_BFs32ll { signed int v1:32; signed long long v2:32; signed long long v3:32; signed long long v4:32; };
struct BFs32i_BFs32ll_BFs32ll_BFu32i { signed int v1:32; signed long long v2:32; signed long long v3:32; unsigned int v4:32; };
struct BFs32i_BFs32ll_BFs32ll_BFu32ll { signed int v1:32; signed long long v2:32; signed long long v3:32; unsigned long long v4:32; };
struct BFs32i_BFs32ll_BFu32i { signed int v1:32; signed long long v2:32; unsigned int v3:32; };
struct BFs32i_BFs32ll_BFu32i_BFs32i { signed int v1:32; signed long long v2:32; unsigned int v3:32; signed int v4:32; };
struct BFs32i_BFs32ll_BFu32i_BFs32ll { signed int v1:32; signed long long v2:32; unsigned int v3:32; signed long long v4:32; };
struct BFs32i_BFs32ll_BFu32i_BFu32i { signed int v1:32; signed long long v2:32; unsigned int v3:32; unsigned int v4:32; };
struct BFs32i_BFs32ll_BFu32i_BFu32ll { signed int v1:32; signed long long v2:32; unsigned int v3:32; unsigned long long v4:32; };
struct BFs32i_BFs32ll_BFu32ll { signed int v1:32; signed long long v2:32; unsigned long long v3:32; };
struct BFs32i_BFs32ll_BFu32ll_BFs32i { signed int v1:32; signed long long v2:32; unsigned long long v3:32; signed int v4:32; };
struct BFs32i_BFs32ll_BFu32ll_BFs32ll { signed int v1:32; signed long long v2:32; unsigned long long v3:32; signed long long v4:32; };
struct BFs32i_BFs32ll_BFu32ll_BFu32i { signed int v1:32; signed long long v2:32; unsigned long long v3:32; unsigned int v4:32; };
struct BFs32i_BFs32ll_BFu32ll_BFu32ll { signed int v1:32; signed long long v2:32; unsigned long long v3:32; unsigned long long v4:32; };
struct BFs32i_BFu32i { signed int v1:32; unsigned int v2:32; };
struct BFs32i_BFu32i_BFs32i { signed int v1:32; unsigned int v2:32; signed int v3:32; };
struct BFs32i_BFu32i_BFs32i_BFs32i { signed int v1:32; unsigned int v2:32; signed int v3:32; signed int v4:32; };
struct BFs32i_BFu32i_BFs32i_BFs32ll { signed int v1:32; unsigned int v2:32; signed int v3:32; signed long long v4:32; };
struct BFs32i_BFu32i_BFs32i_BFu32i { signed int v1:32; unsigned int v2:32; signed int v3:32; unsigned int v4:32; };
struct BFs32i_BFu32i_BFs32i_BFu32ll { signed int v1:32; unsigned int v2:32; signed int v3:32; unsigned long long v4:32; };
struct BFs32i_BFu32i_BFs32ll { signed int v1:32; unsigned int v2:32; signed long long v3:32; };
struct BFs32i_BFu32i_BFs32ll_BFs32i { signed int v1:32; unsigned int v2:32; signed long long v3:32; signed int v4:32; };
struct BFs32i_BFu32i_BFs32ll_BFs32ll { signed int v1:32; unsigned int v2:32; signed long long v3:32; signed long long v4:32; };
struct BFs32i_BFu32i_BFs32ll_BFu32i { signed int v1:32; unsigned int v2:32; signed long long v3:32; unsigned int v4:32; };
struct BFs32i_BFu32i_BFs32ll_BFu32ll { signed int v1:32; unsigned int v2:32; signed long long v3:32; unsigned long long v4:32; };
struct BFs32i_BFu32i_BFu32i { signed int v1:32; unsigned int v2:32; unsigned int v3:32; };
struct BFs32i_BFu32i_BFu32i_BFs32i { signed int v1:32; unsigned int v2:32; unsigned int v3:32; signed int v4:32; };
struct BFs32i_BFu32i_BFu32i_BFs32ll { signed int v1:32; unsigned int v2:32; unsigned int v3:32; signed long long v4:32; };
struct BFs32i_BFu32i_BFu32i_BFu32i { signed int v1:32; unsigned int v2:32; unsigned int v3:32; unsigned int v4:32; };
struct BFs32i_BFu32i_BFu32i_BFu32ll { signed int v1:32; unsigned int v2:32; unsigned int v3:32; unsigned long long v4:32; };
struct BFs32i_BFu32i_BFu32ll { signed int v1:32; unsigned int v2:32; unsigned long long v3:32; };
struct BFs32i_BFu32i_BFu32ll_BFs32i { signed int v1:32; unsigned int v2:32; unsigned long long v3:32; signed int v4:32; };
struct BFs32i_BFu32i_BFu32ll_BFs32ll { signed int v1:32; unsigned int v2:32; unsigned long long v3:32; signed long long v4:32; };
struct BFs32i_BFu32i_BFu32ll_BFu32i { signed int v1:32; unsigned int v2:32; unsigned long long v3:32; unsigned int v4:32; };
struct BFs32i_BFu32i_BFu32ll_BFu32ll { signed int v1:32; unsigned int v2:32; unsigned long long v3:32; unsigned long long v4:32; };
struct BFs32i_BFu32ll { signed int v1:32; unsigned long long v2:32; };
struct BFs32i_BFu32ll_BFs32i { signed int v1:32; unsigned long long v2:32; signed int v3:32; };
struct BFs32i_BFu32ll_BFs32i_BFs32i { signed int v1:32; unsigned long long v2:32; signed int v3:32; signed int v4:32; };
struct BFs32i_BFu32ll_BFs32i_BFs32ll { signed int v1:32; unsigned long long v2:32; signed int v3:32; signed long long v4:32; };
struct BFs32i_BFu32ll_BFs32i_BFu32i { signed int v1:32; unsigned long long v2:32; signed int v3:32; unsigned int v4:32; };
struct BFs32i_BFu32ll_BFs32i_BFu32ll { signed int v1:32; unsigned long long v2:32; signed int v3:32; unsigned long long v4:32; };
struct BFs32i_BFu32ll_BFs32ll { signed int v1:32; unsigned long long v2:32; signed long long v3:32; };
struct BFs32i_BFu32ll_BFs32ll_BFs32i { signed int v1:32; unsigned long long v2:32; signed long long v3:32; signed int v4:32; };
struct BFs32i_BFu32ll_BFs32ll_BFs32ll { signed int v1:32; unsigned long long v2:32; signed long long v3:32; signed long long v4:32; };
struct BFs32i_BFu32ll_BFs32ll_BFu32i { signed int v1:32; unsigned long long v2:32; signed long long v3:32; unsigned int v4:32; };
struct BFs32i_BFu32ll_BFs32ll_BFu32ll { signed int v1:32; unsigned long long v2:32; signed long long v3:32; unsigned long long v4:32; };
struct BFs32i_BFu32ll_BFu32i { signed int v1:32; unsigned long long v2:32; unsigned int v3:32; };
struct BFs32i_BFu32ll_BFu32i_BFs32i { signed int v1:32; unsigned long long v2:32; unsigned int v3:32; signed int v4:32; };
struct BFs32i_BFu32ll_BFu32i_BFs32ll { signed int v1:32; unsigned long long v2:32; unsigned int v3:32; signed long long v4:32; };
struct BFs32i_BFu32ll_BFu32i_BFu32i { signed int v1:32; unsigned long long v2:32; unsigned int v3:32; unsigned int v4:32; };
struct BFs32i_BFu32ll_BFu32i_BFu32ll { signed int v1:32; unsigned long long v2:32; unsigned int v3:32; unsigned long long v4:32; };
struct BFs32i_BFu32ll_BFu32ll { signed int v1:32; unsigned long long v2:32; unsigned long long v3:32; };
struct BFs32i_BFu32ll_BFu32ll_BFs32i { signed int v1:32; unsigned long long v2:32; unsigned long long v3:32; signed int v4:32; };
struct BFs32i_BFu32ll_BFu32ll_BFs32ll { signed int v1:32; unsigned long long v2:32; unsigned long long v3:32; signed long long v4:32; };
struct BFs32i_BFu32ll_BFu32ll_BFu32i { signed int v1:32; unsigned long long v2:32; unsigned long long v3:32; unsigned int v4:32; };
struct BFs32i_BFu32ll_BFu32ll_BFu32ll { signed int v1:32; unsigned long long v2:32; unsigned long long v3:32; unsigned long long v4:32; };
struct BFs32ll_BFs32i { signed long long v1:32; signed int v2:32; };
struct BFs32ll_BFs32i_BFs32i { signed long long v1:32; signed int v2:32; signed int v3:32; };
struct BFs32ll_BFs32i_BFs32i_BFs32i { signed long long v1:32; signed int v2:32; signed int v3:32; signed int v4:32; };
struct BFs32ll_BFs32i_BFs32i_BFs32ll { signed long long v1:32; signed int v2:32; signed int v3:32; signed long long v4:32; };
struct BFs32ll_BFs32i_BFs32i_BFu32i { signed long long v1:32; signed int v2:32; signed int v3:32; unsigned int v4:32; };
struct BFs32ll_BFs32i_BFs32i_BFu32ll { signed long long v1:32; signed int v2:32; signed int v3:32; unsigned long long v4:32; };
struct BFs32ll_BFs32i_BFs32ll { signed long long v1:32; signed int v2:32; signed long long v3:32; };
struct BFs32ll_BFs32i_BFs32ll_BFs32i { signed long long v1:32; signed int v2:32; signed long long v3:32; signed int v4:32; };
struct BFs32ll_BFs32i_BFs32ll_BFs32ll { signed long long v1:32; signed int v2:32; signed long long v3:32; signed long long v4:32; };
struct BFs32ll_BFs32i_BFs32ll_BFu32i { signed long long v1:32; signed int v2:32; signed long long v3:32; unsigned int v4:32; };
struct BFs32ll_BFs32i_BFs32ll_BFu32ll { signed long long v1:32; signed int v2:32; signed long long v3:32; unsigned long long v4:32; };
struct BFs32ll_BFs32i_BFu32i { signed long long v1:32; signed int v2:32; unsigned int v3:32; };
struct BFs32ll_BFs32i_BFu32i_BFs32i { signed long long v1:32; signed int v2:32; unsigned int v3:32; signed int v4:32; };
struct BFs32ll_BFs32i_BFu32i_BFs32ll { signed long long v1:32; signed int v2:32; unsigned int v3:32; signed long long v4:32; };
struct BFs32ll_BFs32i_BFu32i_BFu32i { signed long long v1:32; signed int v2:32; unsigned int v3:32; unsigned int v4:32; };
struct BFs32ll_BFs32i_BFu32i_BFu32ll { signed long long v1:32; signed int v2:32; unsigned int v3:32; unsigned long long v4:32; };
struct BFs32ll_BFs32i_BFu32ll { signed long long v1:32; signed int v2:32; unsigned long long v3:32; };
struct BFs32ll_BFs32i_BFu32ll_BFs32i { signed long long v1:32; signed int v2:32; unsigned long long v3:32; signed int v4:32; };
struct BFs32ll_BFs32i_BFu32ll_BFs32ll { signed long long v1:32; signed int v2:32; unsigned long long v3:32; signed long long v4:32; };
struct BFs32ll_BFs32i_BFu32ll_BFu32i { signed long long v1:32; signed int v2:32; unsigned long long v3:32; unsigned int v4:32; };
struct BFs32ll_BFs32i_BFu32ll_BFu32ll { signed long long v1:32; signed int v2:32; unsigned long long v3:32; unsigned long long v4:32; };
struct BFs32ll_BFs32ll { signed long long v1:32; signed long long v2:32; };
struct BFs32ll_BFs32ll_BFs32i { signed long long v1:32; signed long long v2:32; signed int v3:32; };
struct BFs32ll_BFs32ll_BFs32i_BFs32i { signed long long v1:32; signed long long v2:32; signed int v3:32; signed int v4:32; };
struct BFs32ll_BFs32ll_BFs32i_BFs32ll { signed long long v1:32; signed long long v2:32; signed int v3:32; signed long long v4:32; };
struct BFs32ll_BFs32ll_BFs32i_BFu32i { signed long long v1:32; signed long long v2:32; signed int v3:32; unsigned int v4:32; };
struct BFs32ll_BFs32ll_BFs32i_BFu32ll { signed long long v1:32; signed long long v2:32; signed int v3:32; unsigned long long v4:32; };
struct BFs32ll_BFs32ll_BFs32ll { signed long long v1:32; signed long long v2:32; signed long long v3:32; };
struct BFs32ll_BFs32ll_BFs32ll_BFs32i { signed long long v1:32; signed long long v2:32; signed long long v3:32; signed int v4:32; };
struct BFs32ll_BFs32ll_BFs32ll_BFs32ll { signed long long v1:32; signed long long v2:32; signed long long v3:32; signed long long v4:32; };
struct BFs32ll_BFs32ll_BFs32ll_BFu32i { signed long long v1:32; signed long long v2:32; signed long long v3:32; unsigned int v4:32; };
struct BFs32ll_BFs32ll_BFs32ll_BFu32ll { signed long long v1:32; signed long long v2:32; signed long long v3:32; unsigned long long v4:32; };
struct BFs32ll_BFs32ll_BFu32i { signed long long v1:32; signed long long v2:32; unsigned int v3:32; };
struct BFs32ll_BFs32ll_BFu32i_BFs32i { signed long long v1:32; signed long long v2:32; unsigned int v3:32; signed int v4:32; };
struct BFs32ll_BFs32ll_BFu32i_BFs32ll { signed long long v1:32; signed long long v2:32; unsigned int v3:32; signed long long v4:32; };
struct BFs32ll_BFs32ll_BFu32i_BFu32i { signed long long v1:32; signed long long v2:32; unsigned int v3:32; unsigned int v4:32; };
struct BFs32ll_BFs32ll_BFu32i_BFu32ll { signed long long v1:32; signed long long v2:32; unsigned int v3:32; unsigned long long v4:32; };
struct BFs32ll_BFs32ll_BFu32ll { signed long long v1:32; signed long long v2:32; unsigned long long v3:32; };
struct BFs32ll_BFs32ll_BFu32ll_BFs32i { signed long long v1:32; signed long long v2:32; unsigned long long v3:32; signed int v4:32; };
struct BFs32ll_BFs32ll_BFu32ll_BFs32ll { signed long long v1:32; signed long long v2:32; unsigned long long v3:32; signed long long v4:32; };
struct BFs32ll_BFs32ll_BFu32ll_BFu32i { signed long long v1:32; signed long long v2:32; unsigned long long v3:32; unsigned int v4:32; };
struct BFs32ll_BFs32ll_BFu32ll_BFu32ll { signed long long v1:32; signed long long v2:32; unsigned long long v3:32; unsigned long long v4:32; };
struct BFs32ll_BFu32i { signed long long v1:32; unsigned int v2:32; };
struct BFs32ll_BFu32i_BFs32i { signed long long v1:32; unsigned int v2:32; signed int v3:32; };
struct BFs32ll_BFu32i_BFs32i_BFs32i { signed long long v1:32; unsigned int v2:32; signed int v3:32; signed int v4:32; };
struct BFs32ll_BFu32i_BFs32i_BFs32ll { signed long long v1:32; unsigned int v2:32; signed int v3:32; signed long long v4:32; };
struct BFs32ll_BFu32i_BFs32i_BFu32i { signed long long v1:32; unsigned int v2:32; signed int v3:32; unsigned int v4:32; };
struct BFs32ll_BFu32i_BFs32i_BFu32ll { signed long long v1:32; unsigned int v2:32; signed int v3:32; unsigned long long v4:32; };
struct BFs32ll_BFu32i_BFs32ll { signed long long v1:32; unsigned int v2:32; signed long long v3:32; };
struct BFs32ll_BFu32i_BFs32ll_BFs32i { signed long long v1:32; unsigned int v2:32; signed long long v3:32; signed int v4:32; };
struct BFs32ll_BFu32i_BFs32ll_BFs32ll { signed long long v1:32; unsigned int v2:32; signed long long v3:32; signed long long v4:32; };
struct BFs32ll_BFu32i_BFs32ll_BFu32i { signed long long v1:32; unsigned int v2:32; signed long long v3:32; unsigned int v4:32; };
struct BFs32ll_BFu32i_BFs32ll_BFu32ll { signed long long v1:32; unsigned int v2:32; signed long long v3:32; unsigned long long v4:32; };
struct BFs32ll_BFu32i_BFu32i { signed long long v1:32; unsigned int v2:32; unsigned int v3:32; };
struct BFs32ll_BFu32i_BFu32i_BFs32i { signed long long v1:32; unsigned int v2:32; unsigned int v3:32; signed int v4:32; };
struct BFs32ll_BFu32i_BFu32i_BFs32ll { signed long long v1:32; unsigned int v2:32; unsigned int v3:32; signed long long v4:32; };
struct BFs32ll_BFu32i_BFu32i_BFu32i { signed long long v1:32; unsigned int v2:32; unsigned int v3:32; unsigned int v4:32; };
struct BFs32ll_BFu32i_BFu32i_BFu32ll { signed long long v1:32; unsigned int v2:32; unsigned int v3:32; unsigned long long v4:32; };
struct BFs32ll_BFu32i_BFu32ll { signed long long v1:32; unsigned int v2:32; unsigned long long v3:32; };
struct BFs32ll_BFu32i_BFu32ll_BFs32i { signed long long v1:32; unsigned int v2:32; unsigned long long v3:32; signed int v4:32; };
struct BFs32ll_BFu32i_BFu32ll_BFs32ll { signed long long v1:32; unsigned int v2:32; unsigned long long v3:32; signed long long v4:32; };
struct BFs32ll_BFu32i_BFu32ll_BFu32i { signed long long v1:32; unsigned int v2:32; unsigned long long v3:32; unsigned int v4:32; };
struct BFs32ll_BFu32i_BFu32ll_BFu32ll { signed long long v1:32; unsigned int v2:32; unsigned long long v3:32; unsigned long long v4:32; };
struct BFs32ll_BFu32ll { signed long long v1:32; unsigned long long v2:32; };
struct BFs32ll_BFu32ll_BFs32i { signed long long v1:32; unsigned long long v2:32; signed int v3:32; };
struct BFs32ll_BFu32ll_BFs32i_BFs32i { signed long long v1:32; unsigned long long v2:32; signed int v3:32; signed int v4:32; };
struct BFs32ll_BFu32ll_BFs32i_BFs32ll { signed long long v1:32; unsigned long long v2:32; signed int v3:32; signed long long v4:32; };
struct BFs32ll_BFu32ll_BFs32i_BFu32i { signed long long v1:32; unsigned long long v2:32; signed int v3:32; unsigned int v4:32; };
struct BFs32ll_BFu32ll_BFs32i_BFu32ll { signed long long v1:32; unsigned long long v2:32; signed int v3:32; unsigned long long v4:32; };
struct BFs32ll_BFu32ll_BFs32ll { signed long long v1:32; unsigned long long v2:32; signed long long v3:32; };
struct BFs32ll_BFu32ll_BFs32ll_BFs32i { signed long long v1:32; unsigned long long v2:32; signed long long v3:32; signed int v4:32; };
struct BFs32ll_BFu32ll_BFs32ll_BFs32ll { signed long long v1:32; unsigned long long v2:32; signed long long v3:32; signed long long v4:32; };
struct BFs32ll_BFu32ll_BFs32ll_BFu32i { signed long long v1:32; unsigned long long v2:32; signed long long v3:32; unsigned int v4:32; };
struct BFs32ll_BFu32ll_BFs32ll_BFu32ll { signed long long v1:32; unsigned long long v2:32; signed long long v3:32; unsigned long long v4:32; };
struct BFs32ll_BFu32ll_BFu32i { signed long long v1:32; unsigned long long v2:32; unsigned int v3:32; };
struct BFs32ll_BFu32ll_BFu32i_BFs32i { signed long long v1:32; unsigned long long v2:32; unsigned int v3:32; signed int v4:32; };
struct BFs32ll_BFu32ll_BFu32i_BFs32ll { signed long long v1:32; unsigned long long v2:32; unsigned int v3:32; signed long long v4:32; };
struct BFs32ll_BFu32ll_BFu32i_BFu32i { signed long long v1:32; unsigned long long v2:32; unsigned int v3:32; unsigned int v4:32; };
struct BFs32ll_BFu32ll_BFu32i_BFu32ll { signed long long v1:32; unsigned long long v2:32; unsigned int v3:32; unsigned long long v4:32; };
struct BFs32ll_BFu32ll_BFu32ll { signed long long v1:32; unsigned long long v2:32; unsigned long long v3:32; };
struct BFs32ll_BFu32ll_BFu32ll_BFs32i { signed long long v1:32; unsigned long long v2:32; unsigned long long v3:32; signed int v4:32; };
struct BFs32ll_BFu32ll_BFu32ll_BFs32ll { signed long long v1:32; unsigned long long v2:32; unsigned long long v3:32; signed long long v4:32; };
struct BFs32ll_BFu32ll_BFu32ll_BFu32i { signed long long v1:32; unsigned long long v2:32; unsigned long long v3:32; unsigned int v4:32; };
struct BFs32ll_BFu32ll_BFu32ll_BFu32ll { signed long long v1:32; unsigned long long v2:32; unsigned long long v3:32; unsigned long long v4:32; };
struct BFs33_BFs33 { signed long long v1:33; signed long long v2:33; };
struct BFs33_BFs33_BFs33 { signed long long v1:33; signed long long v2:33; signed long long v3:33; };
struct BFs33_BFs33_BFs33_BFs33 { signed long long v1:33; signed long long v2:33; signed long long v3:33; signed long long v4:33; };
struct BFs33_BFs33_BFs33_BFu33 { signed long long v1:33; signed long long v2:33; signed long long v3:33; unsigned long long v4:33; };
struct BFs33_BFs33_BFu33 { signed long long v1:33; signed long long v2:33; unsigned long long v3:33; };
struct BFs33_BFs33_BFu33_BFs33 { signed long long v1:33; signed long long v2:33; unsigned long long v3:33; signed long long v4:33; };
struct BFs33_BFs33_BFu33_BFu33 { signed long long v1:33; signed long long v2:33; unsigned long long v3:33; unsigned long long v4:33; };
struct BFs33_BFu33 { signed long long v1:33; unsigned long long v2:33; };
struct BFs33_BFu33_BFs33 { signed long long v1:33; unsigned long long v2:33; signed long long v3:33; };
struct BFs33_BFu33_BFs33_BFs33 { signed long long v1:33; unsigned long long v2:33; signed long long v3:33; signed long long v4:33; };
struct BFs33_BFu33_BFs33_BFu33 { signed long long v1:33; unsigned long long v2:33; signed long long v3:33; unsigned long long v4:33; };
struct BFs33_BFu33_BFu33 { signed long long v1:33; unsigned long long v2:33; unsigned long long v3:33; };
struct BFs33_BFu33_BFu33_BFs33 { signed long long v1:33; unsigned long long v2:33; unsigned long long v3:33; signed long long v4:33; };
struct BFs33_BFu33_BFu33_BFu33 { signed long long v1:33; unsigned long long v2:33; unsigned long long v3:33; unsigned long long v4:33; };
struct BFs63_BFs63 { signed long long v1:63; signed long long v2:63; };
struct BFs63_BFs63_BFs63 { signed long long v1:63; signed long long v2:63; signed long long v3:63; };
struct BFs63_BFs63_BFs63_BFs63 { signed long long v1:63; signed long long v2:63; signed long long v3:63; signed long long v4:63; };
struct BFs63_BFs63_BFs63_BFu63 { signed long long v1:63; signed long long v2:63; signed long long v3:63; unsigned long long v4:63; };
struct BFs63_BFs63_BFu63 { signed long long v1:63; signed long long v2:63; unsigned long long v3:63; };
struct BFs63_BFs63_BFu63_BFs63 { signed long long v1:63; signed long long v2:63; unsigned long long v3:63; signed long long v4:63; };
struct BFs63_BFs63_BFu63_BFu63 { signed long long v1:63; signed long long v2:63; unsigned long long v3:63; unsigned long long v4:63; };
struct BFs63_BFu63 { signed long long v1:63; unsigned long long v2:63; };
struct BFs63_BFu63_BFs63 { signed long long v1:63; unsigned long long v2:63; signed long long v3:63; };
struct BFs63_BFu63_BFs63_BFs63 { signed long long v1:63; unsigned long long v2:63; signed long long v3:63; signed long long v4:63; };
struct BFs63_BFu63_BFs63_BFu63 { signed long long v1:63; unsigned long long v2:63; signed long long v3:63; unsigned long long v4:63; };
struct BFs63_BFu63_BFu63 { signed long long v1:63; unsigned long long v2:63; unsigned long long v3:63; };
struct BFs63_BFu63_BFu63_BFs63 { signed long long v1:63; unsigned long long v2:63; unsigned long long v3:63; signed long long v4:63; };
struct BFs63_BFu63_BFu63_BFu63 { signed long long v1:63; unsigned long long v2:63; unsigned long long v3:63; unsigned long long v4:63; };
struct BFs64_BFs64 { signed long long v1:64; signed long long v2:64; };
struct BFs64_BFs64_BFs64 { signed long long v1:64; signed long long v2:64; signed long long v3:64; };
struct BFs64_BFs64_BFs64_BFs64 { signed long long v1:64; signed long long v2:64; signed long long v3:64; signed long long v4:64; };
struct BFs64_BFs64_BFs64_BFu64 { signed long long v1:64; signed long long v2:64; signed long long v3:64; unsigned long long v4:64; };
struct BFs64_BFs64_BFu64 { signed long long v1:64; signed long long v2:64; unsigned long long v3:64; };
struct BFs64_BFs64_BFu64_BFs64 { signed long long v1:64; signed long long v2:64; unsigned long long v3:64; signed long long v4:64; };
struct BFs64_BFs64_BFu64_BFu64 { signed long long v1:64; signed long long v2:64; unsigned long long v3:64; unsigned long long v4:64; };
struct BFs64_BFu64 { signed long long v1:64; unsigned long long v2:64; };
struct BFs64_BFu64_BFs64 { signed long long v1:64; unsigned long long v2:64; signed long long v3:64; };
struct BFs64_BFu64_BFs64_BFs64 { signed long long v1:64; unsigned long long v2:64; signed long long v3:64; signed long long v4:64; };
struct BFs64_BFu64_BFs64_BFu64 { signed long long v1:64; unsigned long long v2:64; signed long long v3:64; unsigned long long v4:64; };
struct BFs64_BFu64_BFu64 { signed long long v1:64; unsigned long long v2:64; unsigned long long v3:64; };
struct BFs64_BFu64_BFu64_BFs64 { signed long long v1:64; unsigned long long v2:64; unsigned long long v3:64; signed long long v4:64; };
struct BFs64_BFu64_BFu64_BFu64 { signed long long v1:64; unsigned long long v2:64; unsigned long long v3:64; unsigned long long v4:64; };
struct BFs7c_BFs7c { signed char v1:7; signed char v2:7; };
struct BFs7c_BFs7c_BFs7c { signed char v1:7; signed char v2:7; signed char v3:7; };
struct BFs7c_BFs7c_BFs7c_BFs7c { signed char v1:7; signed char v2:7; signed char v3:7; signed char v4:7; };
struct BFs7c_BFs7c_BFs7c_BFs7i { signed char v1:7; signed char v2:7; signed char v3:7; signed int v4:7; };
struct BFs7c_BFs7c_BFs7c_BFs7ll { signed char v1:7; signed char v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7c_BFs7c_BFs7c_BFs7s { signed char v1:7; signed char v2:7; signed char v3:7; signed short v4:7; };
struct BFs7c_BFs7c_BFs7c_BFu7c { signed char v1:7; signed char v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7c_BFs7c_BFs7c_BFu7i { signed char v1:7; signed char v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7c_BFs7c_BFs7c_BFu7ll { signed char v1:7; signed char v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7c_BFs7c_BFu7s { signed char v1:7; signed char v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7c_BFs7c_BFs7i { signed char v1:7; signed char v2:7; signed int v3:7; };
struct BFs7c_BFs7c_BFs7i_BFs7c { signed char v1:7; signed char v2:7; signed int v3:7; signed char v4:7; };
struct BFs7c_BFs7c_BFs7i_BFs7i { signed char v1:7; signed char v2:7; signed int v3:7; signed int v4:7; };
struct BFs7c_BFs7c_BFs7i_BFs7ll { signed char v1:7; signed char v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7c_BFs7c_BFs7i_BFs7s { signed char v1:7; signed char v2:7; signed int v3:7; signed short v4:7; };
struct BFs7c_BFs7c_BFs7i_BFu7c { signed char v1:7; signed char v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7c_BFs7c_BFs7i_BFu7i { signed char v1:7; signed char v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7c_BFs7c_BFs7i_BFu7ll { signed char v1:7; signed char v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7c_BFs7i_BFu7s { signed char v1:7; signed char v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7c_BFs7c_BFs7ll { signed char v1:7; signed char v2:7; signed long long v3:7; };
struct BFs7c_BFs7c_BFs7ll_BFs7c { signed char v1:7; signed char v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7c_BFs7c_BFs7ll_BFs7i { signed char v1:7; signed char v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7c_BFs7c_BFs7ll_BFs7ll { signed char v1:7; signed char v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7c_BFs7c_BFs7ll_BFs7s { signed char v1:7; signed char v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7c_BFs7c_BFs7ll_BFu7c { signed char v1:7; signed char v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7c_BFs7c_BFs7ll_BFu7i { signed char v1:7; signed char v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7c_BFs7c_BFs7ll_BFu7ll { signed char v1:7; signed char v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7c_BFs7ll_BFu7s { signed char v1:7; signed char v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7c_BFs7c_BFs7s { signed char v1:7; signed char v2:7; signed short v3:7; };
struct BFs7c_BFs7c_BFs7s_BFs7c { signed char v1:7; signed char v2:7; signed short v3:7; signed char v4:7; };
struct BFs7c_BFs7c_BFs7s_BFs7i { signed char v1:7; signed char v2:7; signed short v3:7; signed int v4:7; };
struct BFs7c_BFs7c_BFs7s_BFs7ll { signed char v1:7; signed char v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7c_BFs7c_BFs7s_BFs7s { signed char v1:7; signed char v2:7; signed short v3:7; signed short v4:7; };
struct BFs7c_BFs7c_BFs7s_BFu7c { signed char v1:7; signed char v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7c_BFs7c_BFs7s_BFu7i { signed char v1:7; signed char v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7c_BFs7c_BFs7s_BFu7ll { signed char v1:7; signed char v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7c_BFs7s_BFu7s { signed char v1:7; signed char v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7c_BFs7c_BFu7c { signed char v1:7; signed char v2:7; unsigned char v3:7; };
struct BFs7c_BFs7c_BFu7c_BFs7c { signed char v1:7; signed char v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7c_BFs7c_BFu7c_BFs7i { signed char v1:7; signed char v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7c_BFs7c_BFu7c_BFs7ll { signed char v1:7; signed char v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7c_BFs7c_BFu7c_BFs7s { signed char v1:7; signed char v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7c_BFs7c_BFu7c_BFu7c { signed char v1:7; signed char v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7c_BFs7c_BFu7c_BFu7i { signed char v1:7; signed char v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7c_BFs7c_BFu7c_BFu7ll { signed char v1:7; signed char v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7c_BFu7c_BFu7s { signed char v1:7; signed char v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7c_BFs7c_BFu7i { signed char v1:7; signed char v2:7; unsigned int v3:7; };
struct BFs7c_BFs7c_BFu7i_BFs7c { signed char v1:7; signed char v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7c_BFs7c_BFu7i_BFs7i { signed char v1:7; signed char v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7c_BFs7c_BFu7i_BFs7ll { signed char v1:7; signed char v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7c_BFs7c_BFu7i_BFs7s { signed char v1:7; signed char v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7c_BFs7c_BFu7i_BFu7c { signed char v1:7; signed char v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7c_BFs7c_BFu7i_BFu7i { signed char v1:7; signed char v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7c_BFs7c_BFu7i_BFu7ll { signed char v1:7; signed char v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7c_BFu7i_BFu7s { signed char v1:7; signed char v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7c_BFs7c_BFu7ll { signed char v1:7; signed char v2:7; unsigned long long v3:7; };
struct BFs7c_BFs7c_BFu7ll_BFs7c { signed char v1:7; signed char v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7c_BFs7c_BFu7ll_BFs7i { signed char v1:7; signed char v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7c_BFs7c_BFu7ll_BFs7ll { signed char v1:7; signed char v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7c_BFs7c_BFu7ll_BFs7s { signed char v1:7; signed char v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7c_BFs7c_BFu7ll_BFu7c { signed char v1:7; signed char v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7c_BFs7c_BFu7ll_BFu7i { signed char v1:7; signed char v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7c_BFs7c_BFu7ll_BFu7ll { signed char v1:7; signed char v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7c_BFu7ll_BFu7s { signed char v1:7; signed char v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7c_BFs7c_BFu7s { signed char v1:7; signed char v2:7; unsigned short v3:7; };
struct BFs7c_BFs7c_BFu7s_BFs7c { signed char v1:7; signed char v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7c_BFs7c_BFu7s_BFs7i { signed char v1:7; signed char v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7c_BFs7c_BFu7s_BFs7ll { signed char v1:7; signed char v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7c_BFs7c_BFu7s_BFs7s { signed char v1:7; signed char v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7c_BFs7c_BFu7s_BFu7c { signed char v1:7; signed char v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7c_BFs7c_BFu7s_BFu7i { signed char v1:7; signed char v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7c_BFs7c_BFu7s_BFu7ll { signed char v1:7; signed char v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7c_BFu7s_BFu7s { signed char v1:7; signed char v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7c_BFs7i { signed char v1:7; signed int v2:7; };
struct BFs7c_BFs7i_BFs7c { signed char v1:7; signed int v2:7; signed char v3:7; };
struct BFs7c_BFs7i_BFs7c_BFs7c { signed char v1:7; signed int v2:7; signed char v3:7; signed char v4:7; };
struct BFs7c_BFs7i_BFs7c_BFs7i { signed char v1:7; signed int v2:7; signed char v3:7; signed int v4:7; };
struct BFs7c_BFs7i_BFs7c_BFs7ll { signed char v1:7; signed int v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7c_BFs7i_BFs7c_BFs7s { signed char v1:7; signed int v2:7; signed char v3:7; signed short v4:7; };
struct BFs7c_BFs7i_BFs7c_BFu7c { signed char v1:7; signed int v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7c_BFs7i_BFs7c_BFu7i { signed char v1:7; signed int v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7c_BFs7i_BFs7c_BFu7ll { signed char v1:7; signed int v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7i_BFs7c_BFu7s { signed char v1:7; signed int v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7c_BFs7i_BFs7i { signed char v1:7; signed int v2:7; signed int v3:7; };
struct BFs7c_BFs7i_BFs7i_BFs7c { signed char v1:7; signed int v2:7; signed int v3:7; signed char v4:7; };
struct BFs7c_BFs7i_BFs7i_BFs7i { signed char v1:7; signed int v2:7; signed int v3:7; signed int v4:7; };
struct BFs7c_BFs7i_BFs7i_BFs7ll { signed char v1:7; signed int v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7c_BFs7i_BFs7i_BFs7s { signed char v1:7; signed int v2:7; signed int v3:7; signed short v4:7; };
struct BFs7c_BFs7i_BFs7i_BFu7c { signed char v1:7; signed int v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7c_BFs7i_BFs7i_BFu7i { signed char v1:7; signed int v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7c_BFs7i_BFs7i_BFu7ll { signed char v1:7; signed int v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7i_BFs7i_BFu7s { signed char v1:7; signed int v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7c_BFs7i_BFs7ll { signed char v1:7; signed int v2:7; signed long long v3:7; };
struct BFs7c_BFs7i_BFs7ll_BFs7c { signed char v1:7; signed int v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7c_BFs7i_BFs7ll_BFs7i { signed char v1:7; signed int v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7c_BFs7i_BFs7ll_BFs7ll { signed char v1:7; signed int v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7c_BFs7i_BFs7ll_BFs7s { signed char v1:7; signed int v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7c_BFs7i_BFs7ll_BFu7c { signed char v1:7; signed int v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7c_BFs7i_BFs7ll_BFu7i { signed char v1:7; signed int v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7c_BFs7i_BFs7ll_BFu7ll { signed char v1:7; signed int v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7i_BFs7ll_BFu7s { signed char v1:7; signed int v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7c_BFs7i_BFs7s { signed char v1:7; signed int v2:7; signed short v3:7; };
struct BFs7c_BFs7i_BFs7s_BFs7c { signed char v1:7; signed int v2:7; signed short v3:7; signed char v4:7; };
struct BFs7c_BFs7i_BFs7s_BFs7i { signed char v1:7; signed int v2:7; signed short v3:7; signed int v4:7; };
struct BFs7c_BFs7i_BFs7s_BFs7ll { signed char v1:7; signed int v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7c_BFs7i_BFs7s_BFs7s { signed char v1:7; signed int v2:7; signed short v3:7; signed short v4:7; };
struct BFs7c_BFs7i_BFs7s_BFu7c { signed char v1:7; signed int v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7c_BFs7i_BFs7s_BFu7i { signed char v1:7; signed int v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7c_BFs7i_BFs7s_BFu7ll { signed char v1:7; signed int v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7i_BFs7s_BFu7s { signed char v1:7; signed int v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7c_BFs7i_BFu7c { signed char v1:7; signed int v2:7; unsigned char v3:7; };
struct BFs7c_BFs7i_BFu7c_BFs7c { signed char v1:7; signed int v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7c_BFs7i_BFu7c_BFs7i { signed char v1:7; signed int v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7c_BFs7i_BFu7c_BFs7ll { signed char v1:7; signed int v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7c_BFs7i_BFu7c_BFs7s { signed char v1:7; signed int v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7c_BFs7i_BFu7c_BFu7c { signed char v1:7; signed int v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7c_BFs7i_BFu7c_BFu7i { signed char v1:7; signed int v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7c_BFs7i_BFu7c_BFu7ll { signed char v1:7; signed int v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7i_BFu7c_BFu7s { signed char v1:7; signed int v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7c_BFs7i_BFu7i { signed char v1:7; signed int v2:7; unsigned int v3:7; };
struct BFs7c_BFs7i_BFu7i_BFs7c { signed char v1:7; signed int v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7c_BFs7i_BFu7i_BFs7i { signed char v1:7; signed int v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7c_BFs7i_BFu7i_BFs7ll { signed char v1:7; signed int v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7c_BFs7i_BFu7i_BFs7s { signed char v1:7; signed int v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7c_BFs7i_BFu7i_BFu7c { signed char v1:7; signed int v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7c_BFs7i_BFu7i_BFu7i { signed char v1:7; signed int v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7c_BFs7i_BFu7i_BFu7ll { signed char v1:7; signed int v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7i_BFu7i_BFu7s { signed char v1:7; signed int v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7c_BFs7i_BFu7ll { signed char v1:7; signed int v2:7; unsigned long long v3:7; };
struct BFs7c_BFs7i_BFu7ll_BFs7c { signed char v1:7; signed int v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7c_BFs7i_BFu7ll_BFs7i { signed char v1:7; signed int v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7c_BFs7i_BFu7ll_BFs7ll { signed char v1:7; signed int v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7c_BFs7i_BFu7ll_BFs7s { signed char v1:7; signed int v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7c_BFs7i_BFu7ll_BFu7c { signed char v1:7; signed int v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7c_BFs7i_BFu7ll_BFu7i { signed char v1:7; signed int v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7c_BFs7i_BFu7ll_BFu7ll { signed char v1:7; signed int v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7i_BFu7ll_BFu7s { signed char v1:7; signed int v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7c_BFs7i_BFu7s { signed char v1:7; signed int v2:7; unsigned short v3:7; };
struct BFs7c_BFs7i_BFu7s_BFs7c { signed char v1:7; signed int v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7c_BFs7i_BFu7s_BFs7i { signed char v1:7; signed int v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7c_BFs7i_BFu7s_BFs7ll { signed char v1:7; signed int v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7c_BFs7i_BFu7s_BFs7s { signed char v1:7; signed int v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7c_BFs7i_BFu7s_BFu7c { signed char v1:7; signed int v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7c_BFs7i_BFu7s_BFu7i { signed char v1:7; signed int v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7c_BFs7i_BFu7s_BFu7ll { signed char v1:7; signed int v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7i_BFu7s_BFu7s { signed char v1:7; signed int v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7c_BFs7ll { signed char v1:7; signed long long v2:7; };
struct BFs7c_BFs7ll_BFs7c { signed char v1:7; signed long long v2:7; signed char v3:7; };
struct BFs7c_BFs7ll_BFs7c_BFs7c { signed char v1:7; signed long long v2:7; signed char v3:7; signed char v4:7; };
struct BFs7c_BFs7ll_BFs7c_BFs7i { signed char v1:7; signed long long v2:7; signed char v3:7; signed int v4:7; };
struct BFs7c_BFs7ll_BFs7c_BFs7ll { signed char v1:7; signed long long v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7c_BFs7ll_BFs7c_BFs7s { signed char v1:7; signed long long v2:7; signed char v3:7; signed short v4:7; };
struct BFs7c_BFs7ll_BFs7c_BFu7c { signed char v1:7; signed long long v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7c_BFs7ll_BFs7c_BFu7i { signed char v1:7; signed long long v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7c_BFs7ll_BFs7c_BFu7ll { signed char v1:7; signed long long v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7ll_BFs7c_BFu7s { signed char v1:7; signed long long v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7c_BFs7ll_BFs7i { signed char v1:7; signed long long v2:7; signed int v3:7; };
struct BFs7c_BFs7ll_BFs7i_BFs7c { signed char v1:7; signed long long v2:7; signed int v3:7; signed char v4:7; };
struct BFs7c_BFs7ll_BFs7i_BFs7i { signed char v1:7; signed long long v2:7; signed int v3:7; signed int v4:7; };
struct BFs7c_BFs7ll_BFs7i_BFs7ll { signed char v1:7; signed long long v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7c_BFs7ll_BFs7i_BFs7s { signed char v1:7; signed long long v2:7; signed int v3:7; signed short v4:7; };
struct BFs7c_BFs7ll_BFs7i_BFu7c { signed char v1:7; signed long long v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7c_BFs7ll_BFs7i_BFu7i { signed char v1:7; signed long long v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7c_BFs7ll_BFs7i_BFu7ll { signed char v1:7; signed long long v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7ll_BFs7i_BFu7s { signed char v1:7; signed long long v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7c_BFs7ll_BFs7ll { signed char v1:7; signed long long v2:7; signed long long v3:7; };
struct BFs7c_BFs7ll_BFs7ll_BFs7c { signed char v1:7; signed long long v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7c_BFs7ll_BFs7ll_BFs7i { signed char v1:7; signed long long v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7c_BFs7ll_BFs7ll_BFs7ll { signed char v1:7; signed long long v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7c_BFs7ll_BFs7ll_BFs7s { signed char v1:7; signed long long v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7c_BFs7ll_BFs7ll_BFu7c { signed char v1:7; signed long long v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7c_BFs7ll_BFs7ll_BFu7i { signed char v1:7; signed long long v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7c_BFs7ll_BFs7ll_BFu7ll { signed char v1:7; signed long long v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7ll_BFs7ll_BFu7s { signed char v1:7; signed long long v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7c_BFs7ll_BFs7s { signed char v1:7; signed long long v2:7; signed short v3:7; };
struct BFs7c_BFs7ll_BFs7s_BFs7c { signed char v1:7; signed long long v2:7; signed short v3:7; signed char v4:7; };
struct BFs7c_BFs7ll_BFs7s_BFs7i { signed char v1:7; signed long long v2:7; signed short v3:7; signed int v4:7; };
struct BFs7c_BFs7ll_BFs7s_BFs7ll { signed char v1:7; signed long long v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7c_BFs7ll_BFs7s_BFs7s { signed char v1:7; signed long long v2:7; signed short v3:7; signed short v4:7; };
struct BFs7c_BFs7ll_BFs7s_BFu7c { signed char v1:7; signed long long v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7c_BFs7ll_BFs7s_BFu7i { signed char v1:7; signed long long v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7c_BFs7ll_BFs7s_BFu7ll { signed char v1:7; signed long long v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7ll_BFs7s_BFu7s { signed char v1:7; signed long long v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7c_BFs7ll_BFu7c { signed char v1:7; signed long long v2:7; unsigned char v3:7; };
struct BFs7c_BFs7ll_BFu7c_BFs7c { signed char v1:7; signed long long v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7c_BFs7ll_BFu7c_BFs7i { signed char v1:7; signed long long v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7c_BFs7ll_BFu7c_BFs7ll { signed char v1:7; signed long long v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7c_BFs7ll_BFu7c_BFs7s { signed char v1:7; signed long long v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7c_BFs7ll_BFu7c_BFu7c { signed char v1:7; signed long long v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7c_BFs7ll_BFu7c_BFu7i { signed char v1:7; signed long long v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7c_BFs7ll_BFu7c_BFu7ll { signed char v1:7; signed long long v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7ll_BFu7c_BFu7s { signed char v1:7; signed long long v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7c_BFs7ll_BFu7i { signed char v1:7; signed long long v2:7; unsigned int v3:7; };
struct BFs7c_BFs7ll_BFu7i_BFs7c { signed char v1:7; signed long long v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7c_BFs7ll_BFu7i_BFs7i { signed char v1:7; signed long long v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7c_BFs7ll_BFu7i_BFs7ll { signed char v1:7; signed long long v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7c_BFs7ll_BFu7i_BFs7s { signed char v1:7; signed long long v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7c_BFs7ll_BFu7i_BFu7c { signed char v1:7; signed long long v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7c_BFs7ll_BFu7i_BFu7i { signed char v1:7; signed long long v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7c_BFs7ll_BFu7i_BFu7ll { signed char v1:7; signed long long v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7ll_BFu7i_BFu7s { signed char v1:7; signed long long v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7c_BFs7ll_BFu7ll { signed char v1:7; signed long long v2:7; unsigned long long v3:7; };
struct BFs7c_BFs7ll_BFu7ll_BFs7c { signed char v1:7; signed long long v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7c_BFs7ll_BFu7ll_BFs7i { signed char v1:7; signed long long v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7c_BFs7ll_BFu7ll_BFs7ll { signed char v1:7; signed long long v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7c_BFs7ll_BFu7ll_BFs7s { signed char v1:7; signed long long v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7c_BFs7ll_BFu7ll_BFu7c { signed char v1:7; signed long long v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7c_BFs7ll_BFu7ll_BFu7i { signed char v1:7; signed long long v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7c_BFs7ll_BFu7ll_BFu7ll { signed char v1:7; signed long long v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7ll_BFu7ll_BFu7s { signed char v1:7; signed long long v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7c_BFs7ll_BFu7s { signed char v1:7; signed long long v2:7; unsigned short v3:7; };
struct BFs7c_BFs7ll_BFu7s_BFs7c { signed char v1:7; signed long long v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7c_BFs7ll_BFu7s_BFs7i { signed char v1:7; signed long long v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7c_BFs7ll_BFu7s_BFs7ll { signed char v1:7; signed long long v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7c_BFs7ll_BFu7s_BFs7s { signed char v1:7; signed long long v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7c_BFs7ll_BFu7s_BFu7c { signed char v1:7; signed long long v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7c_BFs7ll_BFu7s_BFu7i { signed char v1:7; signed long long v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7c_BFs7ll_BFu7s_BFu7ll { signed char v1:7; signed long long v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7ll_BFu7s_BFu7s { signed char v1:7; signed long long v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7c_BFs7s { signed char v1:7; signed short v2:7; };
struct BFs7c_BFs7s_BFs7c { signed char v1:7; signed short v2:7; signed char v3:7; };
struct BFs7c_BFs7s_BFs7c_BFs7c { signed char v1:7; signed short v2:7; signed char v3:7; signed char v4:7; };
struct BFs7c_BFs7s_BFs7c_BFs7i { signed char v1:7; signed short v2:7; signed char v3:7; signed int v4:7; };
struct BFs7c_BFs7s_BFs7c_BFs7ll { signed char v1:7; signed short v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7c_BFs7s_BFs7c_BFs7s { signed char v1:7; signed short v2:7; signed char v3:7; signed short v4:7; };
struct BFs7c_BFs7s_BFs7c_BFu7c { signed char v1:7; signed short v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7c_BFs7s_BFs7c_BFu7i { signed char v1:7; signed short v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7c_BFs7s_BFs7c_BFu7ll { signed char v1:7; signed short v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7s_BFs7c_BFu7s { signed char v1:7; signed short v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7c_BFs7s_BFs7i { signed char v1:7; signed short v2:7; signed int v3:7; };
struct BFs7c_BFs7s_BFs7i_BFs7c { signed char v1:7; signed short v2:7; signed int v3:7; signed char v4:7; };
struct BFs7c_BFs7s_BFs7i_BFs7i { signed char v1:7; signed short v2:7; signed int v3:7; signed int v4:7; };
struct BFs7c_BFs7s_BFs7i_BFs7ll { signed char v1:7; signed short v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7c_BFs7s_BFs7i_BFs7s { signed char v1:7; signed short v2:7; signed int v3:7; signed short v4:7; };
struct BFs7c_BFs7s_BFs7i_BFu7c { signed char v1:7; signed short v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7c_BFs7s_BFs7i_BFu7i { signed char v1:7; signed short v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7c_BFs7s_BFs7i_BFu7ll { signed char v1:7; signed short v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7s_BFs7i_BFu7s { signed char v1:7; signed short v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7c_BFs7s_BFs7ll { signed char v1:7; signed short v2:7; signed long long v3:7; };
struct BFs7c_BFs7s_BFs7ll_BFs7c { signed char v1:7; signed short v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7c_BFs7s_BFs7ll_BFs7i { signed char v1:7; signed short v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7c_BFs7s_BFs7ll_BFs7ll { signed char v1:7; signed short v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7c_BFs7s_BFs7ll_BFs7s { signed char v1:7; signed short v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7c_BFs7s_BFs7ll_BFu7c { signed char v1:7; signed short v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7c_BFs7s_BFs7ll_BFu7i { signed char v1:7; signed short v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7c_BFs7s_BFs7ll_BFu7ll { signed char v1:7; signed short v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7s_BFs7ll_BFu7s { signed char v1:7; signed short v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7c_BFs7s_BFs7s { signed char v1:7; signed short v2:7; signed short v3:7; };
struct BFs7c_BFs7s_BFs7s_BFs7c { signed char v1:7; signed short v2:7; signed short v3:7; signed char v4:7; };
struct BFs7c_BFs7s_BFs7s_BFs7i { signed char v1:7; signed short v2:7; signed short v3:7; signed int v4:7; };
struct BFs7c_BFs7s_BFs7s_BFs7ll { signed char v1:7; signed short v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7c_BFs7s_BFs7s_BFs7s { signed char v1:7; signed short v2:7; signed short v3:7; signed short v4:7; };
struct BFs7c_BFs7s_BFs7s_BFu7c { signed char v1:7; signed short v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7c_BFs7s_BFs7s_BFu7i { signed char v1:7; signed short v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7c_BFs7s_BFs7s_BFu7ll { signed char v1:7; signed short v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7s_BFs7s_BFu7s { signed char v1:7; signed short v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7c_BFs7s_BFu7c { signed char v1:7; signed short v2:7; unsigned char v3:7; };
struct BFs7c_BFs7s_BFu7c_BFs7c { signed char v1:7; signed short v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7c_BFs7s_BFu7c_BFs7i { signed char v1:7; signed short v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7c_BFs7s_BFu7c_BFs7ll { signed char v1:7; signed short v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7c_BFs7s_BFu7c_BFs7s { signed char v1:7; signed short v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7c_BFs7s_BFu7c_BFu7c { signed char v1:7; signed short v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7c_BFs7s_BFu7c_BFu7i { signed char v1:7; signed short v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7c_BFs7s_BFu7c_BFu7ll { signed char v1:7; signed short v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7s_BFu7c_BFu7s { signed char v1:7; signed short v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7c_BFs7s_BFu7i { signed char v1:7; signed short v2:7; unsigned int v3:7; };
struct BFs7c_BFs7s_BFu7i_BFs7c { signed char v1:7; signed short v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7c_BFs7s_BFu7i_BFs7i { signed char v1:7; signed short v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7c_BFs7s_BFu7i_BFs7ll { signed char v1:7; signed short v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7c_BFs7s_BFu7i_BFs7s { signed char v1:7; signed short v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7c_BFs7s_BFu7i_BFu7c { signed char v1:7; signed short v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7c_BFs7s_BFu7i_BFu7i { signed char v1:7; signed short v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7c_BFs7s_BFu7i_BFu7ll { signed char v1:7; signed short v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7s_BFu7i_BFu7s { signed char v1:7; signed short v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7c_BFs7s_BFu7ll { signed char v1:7; signed short v2:7; unsigned long long v3:7; };
struct BFs7c_BFs7s_BFu7ll_BFs7c { signed char v1:7; signed short v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7c_BFs7s_BFu7ll_BFs7i { signed char v1:7; signed short v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7c_BFs7s_BFu7ll_BFs7ll { signed char v1:7; signed short v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7c_BFs7s_BFu7ll_BFs7s { signed char v1:7; signed short v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7c_BFs7s_BFu7ll_BFu7c { signed char v1:7; signed short v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7c_BFs7s_BFu7ll_BFu7i { signed char v1:7; signed short v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7c_BFs7s_BFu7ll_BFu7ll { signed char v1:7; signed short v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7s_BFu7ll_BFu7s { signed char v1:7; signed short v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7c_BFs7s_BFu7s { signed char v1:7; signed short v2:7; unsigned short v3:7; };
struct BFs7c_BFs7s_BFu7s_BFs7c { signed char v1:7; signed short v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7c_BFs7s_BFu7s_BFs7i { signed char v1:7; signed short v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7c_BFs7s_BFu7s_BFs7ll { signed char v1:7; signed short v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7c_BFs7s_BFu7s_BFs7s { signed char v1:7; signed short v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7c_BFs7s_BFu7s_BFu7c { signed char v1:7; signed short v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7c_BFs7s_BFu7s_BFu7i { signed char v1:7; signed short v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7c_BFs7s_BFu7s_BFu7ll { signed char v1:7; signed short v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7c_BFs7s_BFu7s_BFu7s { signed char v1:7; signed short v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7c_BFu7c { signed char v1:7; unsigned char v2:7; };
struct BFs7c_BFu7c_BFs7c { signed char v1:7; unsigned char v2:7; signed char v3:7; };
struct BFs7c_BFu7c_BFs7c_BFs7c { signed char v1:7; unsigned char v2:7; signed char v3:7; signed char v4:7; };
struct BFs7c_BFu7c_BFs7c_BFs7i { signed char v1:7; unsigned char v2:7; signed char v3:7; signed int v4:7; };
struct BFs7c_BFu7c_BFs7c_BFs7ll { signed char v1:7; unsigned char v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7c_BFu7c_BFs7c_BFs7s { signed char v1:7; unsigned char v2:7; signed char v3:7; signed short v4:7; };
struct BFs7c_BFu7c_BFs7c_BFu7c { signed char v1:7; unsigned char v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7c_BFu7c_BFs7c_BFu7i { signed char v1:7; unsigned char v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7c_BFu7c_BFs7c_BFu7ll { signed char v1:7; unsigned char v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7c_BFs7c_BFu7s { signed char v1:7; unsigned char v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7c_BFu7c_BFs7i { signed char v1:7; unsigned char v2:7; signed int v3:7; };
struct BFs7c_BFu7c_BFs7i_BFs7c { signed char v1:7; unsigned char v2:7; signed int v3:7; signed char v4:7; };
struct BFs7c_BFu7c_BFs7i_BFs7i { signed char v1:7; unsigned char v2:7; signed int v3:7; signed int v4:7; };
struct BFs7c_BFu7c_BFs7i_BFs7ll { signed char v1:7; unsigned char v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7c_BFu7c_BFs7i_BFs7s { signed char v1:7; unsigned char v2:7; signed int v3:7; signed short v4:7; };
struct BFs7c_BFu7c_BFs7i_BFu7c { signed char v1:7; unsigned char v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7c_BFu7c_BFs7i_BFu7i { signed char v1:7; unsigned char v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7c_BFu7c_BFs7i_BFu7ll { signed char v1:7; unsigned char v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7c_BFs7i_BFu7s { signed char v1:7; unsigned char v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7c_BFu7c_BFs7ll { signed char v1:7; unsigned char v2:7; signed long long v3:7; };
struct BFs7c_BFu7c_BFs7ll_BFs7c { signed char v1:7; unsigned char v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7c_BFu7c_BFs7ll_BFs7i { signed char v1:7; unsigned char v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7c_BFu7c_BFs7ll_BFs7ll { signed char v1:7; unsigned char v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7c_BFu7c_BFs7ll_BFs7s { signed char v1:7; unsigned char v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7c_BFu7c_BFs7ll_BFu7c { signed char v1:7; unsigned char v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7c_BFu7c_BFs7ll_BFu7i { signed char v1:7; unsigned char v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7c_BFu7c_BFs7ll_BFu7ll { signed char v1:7; unsigned char v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7c_BFs7ll_BFu7s { signed char v1:7; unsigned char v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7c_BFu7c_BFs7s { signed char v1:7; unsigned char v2:7; signed short v3:7; };
struct BFs7c_BFu7c_BFs7s_BFs7c { signed char v1:7; unsigned char v2:7; signed short v3:7; signed char v4:7; };
struct BFs7c_BFu7c_BFs7s_BFs7i { signed char v1:7; unsigned char v2:7; signed short v3:7; signed int v4:7; };
struct BFs7c_BFu7c_BFs7s_BFs7ll { signed char v1:7; unsigned char v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7c_BFu7c_BFs7s_BFs7s { signed char v1:7; unsigned char v2:7; signed short v3:7; signed short v4:7; };
struct BFs7c_BFu7c_BFs7s_BFu7c { signed char v1:7; unsigned char v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7c_BFu7c_BFs7s_BFu7i { signed char v1:7; unsigned char v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7c_BFu7c_BFs7s_BFu7ll { signed char v1:7; unsigned char v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7c_BFs7s_BFu7s { signed char v1:7; unsigned char v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7c_BFu7c_BFu7c { signed char v1:7; unsigned char v2:7; unsigned char v3:7; };
struct BFs7c_BFu7c_BFu7c_BFs7c { signed char v1:7; unsigned char v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7c_BFu7c_BFu7c_BFs7i { signed char v1:7; unsigned char v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7c_BFu7c_BFu7c_BFs7ll { signed char v1:7; unsigned char v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7c_BFu7c_BFu7c_BFs7s { signed char v1:7; unsigned char v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7c_BFu7c_BFu7c_BFu7c { signed char v1:7; unsigned char v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7c_BFu7c_BFu7c_BFu7i { signed char v1:7; unsigned char v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7c_BFu7c_BFu7c_BFu7ll { signed char v1:7; unsigned char v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7c_BFu7c_BFu7s { signed char v1:7; unsigned char v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7c_BFu7c_BFu7i { signed char v1:7; unsigned char v2:7; unsigned int v3:7; };
struct BFs7c_BFu7c_BFu7i_BFs7c { signed char v1:7; unsigned char v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7c_BFu7c_BFu7i_BFs7i { signed char v1:7; unsigned char v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7c_BFu7c_BFu7i_BFs7ll { signed char v1:7; unsigned char v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7c_BFu7c_BFu7i_BFs7s { signed char v1:7; unsigned char v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7c_BFu7c_BFu7i_BFu7c { signed char v1:7; unsigned char v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7c_BFu7c_BFu7i_BFu7i { signed char v1:7; unsigned char v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7c_BFu7c_BFu7i_BFu7ll { signed char v1:7; unsigned char v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7c_BFu7i_BFu7s { signed char v1:7; unsigned char v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7c_BFu7c_BFu7ll { signed char v1:7; unsigned char v2:7; unsigned long long v3:7; };
struct BFs7c_BFu7c_BFu7ll_BFs7c { signed char v1:7; unsigned char v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7c_BFu7c_BFu7ll_BFs7i { signed char v1:7; unsigned char v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7c_BFu7c_BFu7ll_BFs7ll { signed char v1:7; unsigned char v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7c_BFu7c_BFu7ll_BFs7s { signed char v1:7; unsigned char v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7c_BFu7c_BFu7ll_BFu7c { signed char v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7c_BFu7c_BFu7ll_BFu7i { signed char v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7c_BFu7c_BFu7ll_BFu7ll { signed char v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7c_BFu7ll_BFu7s { signed char v1:7; unsigned char v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7c_BFu7c_BFu7s { signed char v1:7; unsigned char v2:7; unsigned short v3:7; };
struct BFs7c_BFu7c_BFu7s_BFs7c { signed char v1:7; unsigned char v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7c_BFu7c_BFu7s_BFs7i { signed char v1:7; unsigned char v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7c_BFu7c_BFu7s_BFs7ll { signed char v1:7; unsigned char v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7c_BFu7c_BFu7s_BFs7s { signed char v1:7; unsigned char v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7c_BFu7c_BFu7s_BFu7c { signed char v1:7; unsigned char v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7c_BFu7c_BFu7s_BFu7i { signed char v1:7; unsigned char v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7c_BFu7c_BFu7s_BFu7ll { signed char v1:7; unsigned char v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7c_BFu7s_BFu7s { signed char v1:7; unsigned char v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7c_BFu7i { signed char v1:7; unsigned int v2:7; };
struct BFs7c_BFu7i_BFs7c { signed char v1:7; unsigned int v2:7; signed char v3:7; };
struct BFs7c_BFu7i_BFs7c_BFs7c { signed char v1:7; unsigned int v2:7; signed char v3:7; signed char v4:7; };
struct BFs7c_BFu7i_BFs7c_BFs7i { signed char v1:7; unsigned int v2:7; signed char v3:7; signed int v4:7; };
struct BFs7c_BFu7i_BFs7c_BFs7ll { signed char v1:7; unsigned int v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7c_BFu7i_BFs7c_BFs7s { signed char v1:7; unsigned int v2:7; signed char v3:7; signed short v4:7; };
struct BFs7c_BFu7i_BFs7c_BFu7c { signed char v1:7; unsigned int v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7c_BFu7i_BFs7c_BFu7i { signed char v1:7; unsigned int v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7c_BFu7i_BFs7c_BFu7ll { signed char v1:7; unsigned int v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7i_BFs7c_BFu7s { signed char v1:7; unsigned int v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7c_BFu7i_BFs7i { signed char v1:7; unsigned int v2:7; signed int v3:7; };
struct BFs7c_BFu7i_BFs7i_BFs7c { signed char v1:7; unsigned int v2:7; signed int v3:7; signed char v4:7; };
struct BFs7c_BFu7i_BFs7i_BFs7i { signed char v1:7; unsigned int v2:7; signed int v3:7; signed int v4:7; };
struct BFs7c_BFu7i_BFs7i_BFs7ll { signed char v1:7; unsigned int v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7c_BFu7i_BFs7i_BFs7s { signed char v1:7; unsigned int v2:7; signed int v3:7; signed short v4:7; };
struct BFs7c_BFu7i_BFs7i_BFu7c { signed char v1:7; unsigned int v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7c_BFu7i_BFs7i_BFu7i { signed char v1:7; unsigned int v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7c_BFu7i_BFs7i_BFu7ll { signed char v1:7; unsigned int v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7i_BFs7i_BFu7s { signed char v1:7; unsigned int v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7c_BFu7i_BFs7ll { signed char v1:7; unsigned int v2:7; signed long long v3:7; };
struct BFs7c_BFu7i_BFs7ll_BFs7c { signed char v1:7; unsigned int v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7c_BFu7i_BFs7ll_BFs7i { signed char v1:7; unsigned int v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7c_BFu7i_BFs7ll_BFs7ll { signed char v1:7; unsigned int v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7c_BFu7i_BFs7ll_BFs7s { signed char v1:7; unsigned int v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7c_BFu7i_BFs7ll_BFu7c { signed char v1:7; unsigned int v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7c_BFu7i_BFs7ll_BFu7i { signed char v1:7; unsigned int v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7c_BFu7i_BFs7ll_BFu7ll { signed char v1:7; unsigned int v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7i_BFs7ll_BFu7s { signed char v1:7; unsigned int v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7c_BFu7i_BFs7s { signed char v1:7; unsigned int v2:7; signed short v3:7; };
struct BFs7c_BFu7i_BFs7s_BFs7c { signed char v1:7; unsigned int v2:7; signed short v3:7; signed char v4:7; };
struct BFs7c_BFu7i_BFs7s_BFs7i { signed char v1:7; unsigned int v2:7; signed short v3:7; signed int v4:7; };
struct BFs7c_BFu7i_BFs7s_BFs7ll { signed char v1:7; unsigned int v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7c_BFu7i_BFs7s_BFs7s { signed char v1:7; unsigned int v2:7; signed short v3:7; signed short v4:7; };
struct BFs7c_BFu7i_BFs7s_BFu7c { signed char v1:7; unsigned int v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7c_BFu7i_BFs7s_BFu7i { signed char v1:7; unsigned int v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7c_BFu7i_BFs7s_BFu7ll { signed char v1:7; unsigned int v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7i_BFs7s_BFu7s { signed char v1:7; unsigned int v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7c_BFu7i_BFu7c { signed char v1:7; unsigned int v2:7; unsigned char v3:7; };
struct BFs7c_BFu7i_BFu7c_BFs7c { signed char v1:7; unsigned int v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7c_BFu7i_BFu7c_BFs7i { signed char v1:7; unsigned int v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7c_BFu7i_BFu7c_BFs7ll { signed char v1:7; unsigned int v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7c_BFu7i_BFu7c_BFs7s { signed char v1:7; unsigned int v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7c_BFu7i_BFu7c_BFu7c { signed char v1:7; unsigned int v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7c_BFu7i_BFu7c_BFu7i { signed char v1:7; unsigned int v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7c_BFu7i_BFu7c_BFu7ll { signed char v1:7; unsigned int v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7i_BFu7c_BFu7s { signed char v1:7; unsigned int v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7c_BFu7i_BFu7i { signed char v1:7; unsigned int v2:7; unsigned int v3:7; };
struct BFs7c_BFu7i_BFu7i_BFs7c { signed char v1:7; unsigned int v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7c_BFu7i_BFu7i_BFs7i { signed char v1:7; unsigned int v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7c_BFu7i_BFu7i_BFs7ll { signed char v1:7; unsigned int v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7c_BFu7i_BFu7i_BFs7s { signed char v1:7; unsigned int v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7c_BFu7i_BFu7i_BFu7c { signed char v1:7; unsigned int v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7c_BFu7i_BFu7i_BFu7i { signed char v1:7; unsigned int v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7c_BFu7i_BFu7i_BFu7ll { signed char v1:7; unsigned int v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7i_BFu7i_BFu7s { signed char v1:7; unsigned int v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7c_BFu7i_BFu7ll { signed char v1:7; unsigned int v2:7; unsigned long long v3:7; };
struct BFs7c_BFu7i_BFu7ll_BFs7c { signed char v1:7; unsigned int v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7c_BFu7i_BFu7ll_BFs7i { signed char v1:7; unsigned int v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7c_BFu7i_BFu7ll_BFs7ll { signed char v1:7; unsigned int v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7c_BFu7i_BFu7ll_BFs7s { signed char v1:7; unsigned int v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7c_BFu7i_BFu7ll_BFu7c { signed char v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7c_BFu7i_BFu7ll_BFu7i { signed char v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7c_BFu7i_BFu7ll_BFu7ll { signed char v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7i_BFu7ll_BFu7s { signed char v1:7; unsigned int v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7c_BFu7i_BFu7s { signed char v1:7; unsigned int v2:7; unsigned short v3:7; };
struct BFs7c_BFu7i_BFu7s_BFs7c { signed char v1:7; unsigned int v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7c_BFu7i_BFu7s_BFs7i { signed char v1:7; unsigned int v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7c_BFu7i_BFu7s_BFs7ll { signed char v1:7; unsigned int v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7c_BFu7i_BFu7s_BFs7s { signed char v1:7; unsigned int v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7c_BFu7i_BFu7s_BFu7c { signed char v1:7; unsigned int v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7c_BFu7i_BFu7s_BFu7i { signed char v1:7; unsigned int v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7c_BFu7i_BFu7s_BFu7ll { signed char v1:7; unsigned int v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7i_BFu7s_BFu7s { signed char v1:7; unsigned int v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7c_BFu7ll { signed char v1:7; unsigned long long v2:7; };
struct BFs7c_BFu7ll_BFs7c { signed char v1:7; unsigned long long v2:7; signed char v3:7; };
struct BFs7c_BFu7ll_BFs7c_BFs7c { signed char v1:7; unsigned long long v2:7; signed char v3:7; signed char v4:7; };
struct BFs7c_BFu7ll_BFs7c_BFs7i { signed char v1:7; unsigned long long v2:7; signed char v3:7; signed int v4:7; };
struct BFs7c_BFu7ll_BFs7c_BFs7ll { signed char v1:7; unsigned long long v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7c_BFu7ll_BFs7c_BFs7s { signed char v1:7; unsigned long long v2:7; signed char v3:7; signed short v4:7; };
struct BFs7c_BFu7ll_BFs7c_BFu7c { signed char v1:7; unsigned long long v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7c_BFu7ll_BFs7c_BFu7i { signed char v1:7; unsigned long long v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7c_BFu7ll_BFs7c_BFu7ll { signed char v1:7; unsigned long long v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7ll_BFs7c_BFu7s { signed char v1:7; unsigned long long v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7c_BFu7ll_BFs7i { signed char v1:7; unsigned long long v2:7; signed int v3:7; };
struct BFs7c_BFu7ll_BFs7i_BFs7c { signed char v1:7; unsigned long long v2:7; signed int v3:7; signed char v4:7; };
struct BFs7c_BFu7ll_BFs7i_BFs7i { signed char v1:7; unsigned long long v2:7; signed int v3:7; signed int v4:7; };
struct BFs7c_BFu7ll_BFs7i_BFs7ll { signed char v1:7; unsigned long long v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7c_BFu7ll_BFs7i_BFs7s { signed char v1:7; unsigned long long v2:7; signed int v3:7; signed short v4:7; };
struct BFs7c_BFu7ll_BFs7i_BFu7c { signed char v1:7; unsigned long long v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7c_BFu7ll_BFs7i_BFu7i { signed char v1:7; unsigned long long v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7c_BFu7ll_BFs7i_BFu7ll { signed char v1:7; unsigned long long v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7ll_BFs7i_BFu7s { signed char v1:7; unsigned long long v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7c_BFu7ll_BFs7ll { signed char v1:7; unsigned long long v2:7; signed long long v3:7; };
struct BFs7c_BFu7ll_BFs7ll_BFs7c { signed char v1:7; unsigned long long v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7c_BFu7ll_BFs7ll_BFs7i { signed char v1:7; unsigned long long v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7c_BFu7ll_BFs7ll_BFs7ll { signed char v1:7; unsigned long long v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7c_BFu7ll_BFs7ll_BFs7s { signed char v1:7; unsigned long long v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7c_BFu7ll_BFs7ll_BFu7c { signed char v1:7; unsigned long long v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7c_BFu7ll_BFs7ll_BFu7i { signed char v1:7; unsigned long long v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7c_BFu7ll_BFs7ll_BFu7ll { signed char v1:7; unsigned long long v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7ll_BFs7ll_BFu7s { signed char v1:7; unsigned long long v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7c_BFu7ll_BFs7s { signed char v1:7; unsigned long long v2:7; signed short v3:7; };
struct BFs7c_BFu7ll_BFs7s_BFs7c { signed char v1:7; unsigned long long v2:7; signed short v3:7; signed char v4:7; };
struct BFs7c_BFu7ll_BFs7s_BFs7i { signed char v1:7; unsigned long long v2:7; signed short v3:7; signed int v4:7; };
struct BFs7c_BFu7ll_BFs7s_BFs7ll { signed char v1:7; unsigned long long v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7c_BFu7ll_BFs7s_BFs7s { signed char v1:7; unsigned long long v2:7; signed short v3:7; signed short v4:7; };
struct BFs7c_BFu7ll_BFs7s_BFu7c { signed char v1:7; unsigned long long v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7c_BFu7ll_BFs7s_BFu7i { signed char v1:7; unsigned long long v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7c_BFu7ll_BFs7s_BFu7ll { signed char v1:7; unsigned long long v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7ll_BFs7s_BFu7s { signed char v1:7; unsigned long long v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7c_BFu7ll_BFu7c { signed char v1:7; unsigned long long v2:7; unsigned char v3:7; };
struct BFs7c_BFu7ll_BFu7c_BFs7c { signed char v1:7; unsigned long long v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7c_BFu7ll_BFu7c_BFs7i { signed char v1:7; unsigned long long v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7c_BFu7ll_BFu7c_BFs7ll { signed char v1:7; unsigned long long v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7c_BFu7ll_BFu7c_BFs7s { signed char v1:7; unsigned long long v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7c_BFu7ll_BFu7c_BFu7c { signed char v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7c_BFu7ll_BFu7c_BFu7i { signed char v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7c_BFu7ll_BFu7c_BFu7ll { signed char v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7ll_BFu7c_BFu7s { signed char v1:7; unsigned long long v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7c_BFu7ll_BFu7i { signed char v1:7; unsigned long long v2:7; unsigned int v3:7; };
struct BFs7c_BFu7ll_BFu7i_BFs7c { signed char v1:7; unsigned long long v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7c_BFu7ll_BFu7i_BFs7i { signed char v1:7; unsigned long long v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7c_BFu7ll_BFu7i_BFs7ll { signed char v1:7; unsigned long long v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7c_BFu7ll_BFu7i_BFs7s { signed char v1:7; unsigned long long v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7c_BFu7ll_BFu7i_BFu7c { signed char v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7c_BFu7ll_BFu7i_BFu7i { signed char v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned int v4:7; };
struct BFs7c_BFu7ll_BFu7i_BFu7ll { signed char v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7ll_BFu7i_BFu7s { signed char v1:7; unsigned long long v2:7; unsigned int v3:7; unsigned short v4:7; };
struct BFs7c_BFu7ll_BFu7ll { signed char v1:7; unsigned long long v2:7; unsigned long long v3:7; };
struct BFs7c_BFu7ll_BFu7ll_BFs7c { signed char v1:7; unsigned long long v2:7; unsigned long long v3:7; signed char v4:7; };
struct BFs7c_BFu7ll_BFu7ll_BFs7i { signed char v1:7; unsigned long long v2:7; unsigned long long v3:7; signed int v4:7; };
struct BFs7c_BFu7ll_BFu7ll_BFs7ll { signed char v1:7; unsigned long long v2:7; unsigned long long v3:7; signed long long v4:7; };
struct BFs7c_BFu7ll_BFu7ll_BFs7s { signed char v1:7; unsigned long long v2:7; unsigned long long v3:7; signed short v4:7; };
struct BFs7c_BFu7ll_BFu7ll_BFu7c { signed char v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned char v4:7; };
struct BFs7c_BFu7ll_BFu7ll_BFu7i { signed char v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned int v4:7; };
struct BFs7c_BFu7ll_BFu7ll_BFu7ll { signed char v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7ll_BFu7ll_BFu7s { signed char v1:7; unsigned long long v2:7; unsigned long long v3:7; unsigned short v4:7; };
struct BFs7c_BFu7ll_BFu7s { signed char v1:7; unsigned long long v2:7; unsigned short v3:7; };
struct BFs7c_BFu7ll_BFu7s_BFs7c { signed char v1:7; unsigned long long v2:7; unsigned short v3:7; signed char v4:7; };
struct BFs7c_BFu7ll_BFu7s_BFs7i { signed char v1:7; unsigned long long v2:7; unsigned short v3:7; signed int v4:7; };
struct BFs7c_BFu7ll_BFu7s_BFs7ll { signed char v1:7; unsigned long long v2:7; unsigned short v3:7; signed long long v4:7; };
struct BFs7c_BFu7ll_BFu7s_BFs7s { signed char v1:7; unsigned long long v2:7; unsigned short v3:7; signed short v4:7; };
struct BFs7c_BFu7ll_BFu7s_BFu7c { signed char v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned char v4:7; };
struct BFs7c_BFu7ll_BFu7s_BFu7i { signed char v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned int v4:7; };
struct BFs7c_BFu7ll_BFu7s_BFu7ll { signed char v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7ll_BFu7s_BFu7s { signed char v1:7; unsigned long long v2:7; unsigned short v3:7; unsigned short v4:7; };
struct BFs7c_BFu7s { signed char v1:7; unsigned short v2:7; };
struct BFs7c_BFu7s_BFs7c { signed char v1:7; unsigned short v2:7; signed char v3:7; };
struct BFs7c_BFu7s_BFs7c_BFs7c { signed char v1:7; unsigned short v2:7; signed char v3:7; signed char v4:7; };
struct BFs7c_BFu7s_BFs7c_BFs7i { signed char v1:7; unsigned short v2:7; signed char v3:7; signed int v4:7; };
struct BFs7c_BFu7s_BFs7c_BFs7ll { signed char v1:7; unsigned short v2:7; signed char v3:7; signed long long v4:7; };
struct BFs7c_BFu7s_BFs7c_BFs7s { signed char v1:7; unsigned short v2:7; signed char v3:7; signed short v4:7; };
struct BFs7c_BFu7s_BFs7c_BFu7c { signed char v1:7; unsigned short v2:7; signed char v3:7; unsigned char v4:7; };
struct BFs7c_BFu7s_BFs7c_BFu7i { signed char v1:7; unsigned short v2:7; signed char v3:7; unsigned int v4:7; };
struct BFs7c_BFu7s_BFs7c_BFu7ll { signed char v1:7; unsigned short v2:7; signed char v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7s_BFs7c_BFu7s { signed char v1:7; unsigned short v2:7; signed char v3:7; unsigned short v4:7; };
struct BFs7c_BFu7s_BFs7i { signed char v1:7; unsigned short v2:7; signed int v3:7; };
struct BFs7c_BFu7s_BFs7i_BFs7c { signed char v1:7; unsigned short v2:7; signed int v3:7; signed char v4:7; };
struct BFs7c_BFu7s_BFs7i_BFs7i { signed char v1:7; unsigned short v2:7; signed int v3:7; signed int v4:7; };
struct BFs7c_BFu7s_BFs7i_BFs7ll { signed char v1:7; unsigned short v2:7; signed int v3:7; signed long long v4:7; };
struct BFs7c_BFu7s_BFs7i_BFs7s { signed char v1:7; unsigned short v2:7; signed int v3:7; signed short v4:7; };
struct BFs7c_BFu7s_BFs7i_BFu7c { signed char v1:7; unsigned short v2:7; signed int v3:7; unsigned char v4:7; };
struct BFs7c_BFu7s_BFs7i_BFu7i { signed char v1:7; unsigned short v2:7; signed int v3:7; unsigned int v4:7; };
struct BFs7c_BFu7s_BFs7i_BFu7ll { signed char v1:7; unsigned short v2:7; signed int v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7s_BFs7i_BFu7s { signed char v1:7; unsigned short v2:7; signed int v3:7; unsigned short v4:7; };
struct BFs7c_BFu7s_BFs7ll { signed char v1:7; unsigned short v2:7; signed long long v3:7; };
struct BFs7c_BFu7s_BFs7ll_BFs7c { signed char v1:7; unsigned short v2:7; signed long long v3:7; signed char v4:7; };
struct BFs7c_BFu7s_BFs7ll_BFs7i { signed char v1:7; unsigned short v2:7; signed long long v3:7; signed int v4:7; };
struct BFs7c_BFu7s_BFs7ll_BFs7ll { signed char v1:7; unsigned short v2:7; signed long long v3:7; signed long long v4:7; };
struct BFs7c_BFu7s_BFs7ll_BFs7s { signed char v1:7; unsigned short v2:7; signed long long v3:7; signed short v4:7; };
struct BFs7c_BFu7s_BFs7ll_BFu7c { signed char v1:7; unsigned short v2:7; signed long long v3:7; unsigned char v4:7; };
struct BFs7c_BFu7s_BFs7ll_BFu7i { signed char v1:7; unsigned short v2:7; signed long long v3:7; unsigned int v4:7; };
struct BFs7c_BFu7s_BFs7ll_BFu7ll { signed char v1:7; unsigned short v2:7; signed long long v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7s_BFs7ll_BFu7s { signed char v1:7; unsigned short v2:7; signed long long v3:7; unsigned short v4:7; };
struct BFs7c_BFu7s_BFs7s { signed char v1:7; unsigned short v2:7; signed short v3:7; };
struct BFs7c_BFu7s_BFs7s_BFs7c { signed char v1:7; unsigned short v2:7; signed short v3:7; signed char v4:7; };
struct BFs7c_BFu7s_BFs7s_BFs7i { signed char v1:7; unsigned short v2:7; signed short v3:7; signed int v4:7; };
struct BFs7c_BFu7s_BFs7s_BFs7ll { signed char v1:7; unsigned short v2:7; signed short v3:7; signed long long v4:7; };
struct BFs7c_BFu7s_BFs7s_BFs7s { signed char v1:7; unsigned short v2:7; signed short v3:7; signed short v4:7; };
struct BFs7c_BFu7s_BFs7s_BFu7c { signed char v1:7; unsigned short v2:7; signed short v3:7; unsigned char v4:7; };
struct BFs7c_BFu7s_BFs7s_BFu7i { signed char v1:7; unsigned short v2:7; signed short v3:7; unsigned int v4:7; };
struct BFs7c_BFu7s_BFs7s_BFu7ll { signed char v1:7; unsigned short v2:7; signed short v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7s_BFs7s_BFu7s { signed char v1:7; unsigned short v2:7; signed short v3:7; unsigned short v4:7; };
struct BFs7c_BFu7s_BFu7c { signed char v1:7; unsigned short v2:7; unsigned char v3:7; };
struct BFs7c_BFu7s_BFu7c_BFs7c { signed char v1:7; unsigned short v2:7; unsigned char v3:7; signed char v4:7; };
struct BFs7c_BFu7s_BFu7c_BFs7i { signed char v1:7; unsigned short v2:7; unsigned char v3:7; signed int v4:7; };
struct BFs7c_BFu7s_BFu7c_BFs7ll { signed char v1:7; unsigned short v2:7; unsigned char v3:7; signed long long v4:7; };
struct BFs7c_BFu7s_BFu7c_BFs7s { signed char v1:7; unsigned short v2:7; unsigned char v3:7; signed short v4:7; };
struct BFs7c_BFu7s_BFu7c_BFu7c { signed char v1:7; unsigned short v2:7; unsigned char v3:7; unsigned char v4:7; };
struct BFs7c_BFu7s_BFu7c_BFu7i { signed char v1:7; unsigned short v2:7; unsigned char v3:7; unsigned int v4:7; };
struct BFs7c_BFu7s_BFu7c_BFu7ll { signed char v1:7; unsigned short v2:7; unsigned char v3:7; unsigned long long v4:7; };
struct BFs7c_BFu7s_BFu7c_BFu7s { signed char v1:7; unsigned short v2:7; unsigned char v3:7; unsigned short v4:7; };
struct BFs7c_BFu7s_BFu7i { signed char v1:7; unsigned short v2:7; unsigned int v3:7; };
struct BFs7c_BFu7s_BFu7i_BFs7c { signed char v1:7; unsigned short v2:7; unsigned int v3:7; signed char v4:7; };
struct BFs7c_BFu7s_BFu7i_BFs7i { signed char v1:7; unsigned short v2:7; unsigned int v3:7; signed int v4:7; };
struct BFs7c_BFu7s_BFu7i_BFs7ll { signed char v1:7; unsigned short v2:7; unsigned int v3:7; signed long long v4:7; };
struct BFs7c_BFu7s_BFu7i_BFs7s { signed char v1:7; unsigned short v2:7; unsigned int v3:7; signed short v4:7; };
struct BFs7c_BFu7s_BFu7i_BFu7c { signed char v1:7; unsigned short v2:7; unsigned int v3:7; unsigned char v4:7; };
struct BFs7c_BFu7s_BFu7i_BFu7i { signed char v1:7; unsigned short v2:7; unsigned int v3:7; unsigned int v4:7; };


static void Test_BFs1c_BFs1s_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFs1s_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1ll_BFs1s, BFs1c_BFs1s_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1c_BFs1s_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFs1s_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1ll_BFu1c, BFs1c_BFs1s_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1c_BFs1s_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFs1s_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1ll_BFu1i, BFs1c_BFs1s_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1c_BFs1s_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFs1s_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1ll_BFu1ll, BFs1c_BFs1s_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1c_BFs1s_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFs1s_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1ll_BFu1s, BFs1c_BFs1s_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1c_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1s, BFs1c_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1c_BFs1s_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFs1s_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1s_BFs1c, BFs1c_BFs1s_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1c_BFs1s_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFs1s_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1s_BFs1i, BFs1c_BFs1s_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1c_BFs1s_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFs1s_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1s_BFs1ll, BFs1c_BFs1s_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1c_BFs1s_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFs1s_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1s_BFs1s, BFs1c_BFs1s_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1c_BFs1s_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFs1s_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1s_BFu1c, BFs1c_BFs1s_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1c_BFs1s_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFs1s_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1s_BFu1i, BFs1c_BFs1s_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1c_BFs1s_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFs1s_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1s_BFu1ll, BFs1c_BFs1s_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1c_BFs1s_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1c_BFs1s_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1c_BFs1s_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFs1s_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFs1s_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1c_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFs1s_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFs1s_BFu1s_BFu1s, BFs1c_BFs1s_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c, BFs1c_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1c, BFs1c_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1c_BFs1c, BFs1c_BFu1c_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1c_BFs1i, BFs1c_BFu1c_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1c_BFs1ll, BFs1c_BFu1c_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1c_BFs1s, BFs1c_BFu1c_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1c_BFu1c, BFs1c_BFu1c_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1c_BFu1i, BFs1c_BFu1c_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1c_BFu1ll, BFs1c_BFu1c_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1c_BFu1s, BFs1c_BFu1c_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1i, BFs1c_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1i_BFs1c, BFs1c_BFu1c_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1i_BFs1i, BFs1c_BFu1c_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1i_BFs1ll, BFs1c_BFu1c_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1i_BFs1s, BFs1c_BFu1c_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1i_BFu1c, BFs1c_BFu1c_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1i_BFu1i, BFs1c_BFu1c_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1i_BFu1ll, BFs1c_BFu1c_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1i_BFu1s, BFs1c_BFu1c_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1ll, BFs1c_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1ll_BFs1c, BFs1c_BFu1c_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1ll_BFs1i, BFs1c_BFu1c_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1ll_BFs1ll, BFs1c_BFu1c_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1ll_BFs1s, BFs1c_BFu1c_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1ll_BFu1c, BFs1c_BFu1c_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1ll_BFu1i, BFs1c_BFu1c_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1ll_BFu1ll, BFs1c_BFu1c_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1ll_BFu1s, BFs1c_BFu1c_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1s, BFs1c_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1s_BFs1c, BFs1c_BFu1c_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1s_BFs1i, BFs1c_BFu1c_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1s_BFs1ll, BFs1c_BFu1c_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1s_BFs1s, BFs1c_BFu1c_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1s_BFu1c, BFs1c_BFu1c_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1s_BFu1i, BFs1c_BFu1c_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1s_BFu1ll, BFs1c_BFu1c_BFs1s_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFs1s_BFu1s, BFs1c_BFu1c_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1c, BFs1c_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1c_BFs1c, BFs1c_BFu1c_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1c_BFs1i, BFs1c_BFu1c_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1c_BFs1ll, BFs1c_BFu1c_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1c_BFs1s, BFs1c_BFu1c_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1c_BFu1c, BFs1c_BFu1c_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1c_BFu1i, BFs1c_BFu1c_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1c_BFu1ll, BFs1c_BFu1c_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1c_BFu1s, BFs1c_BFu1c_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1i, BFs1c_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1i_BFs1c, BFs1c_BFu1c_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1i_BFs1i, BFs1c_BFu1c_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1i_BFs1ll, BFs1c_BFu1c_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1i_BFs1s, BFs1c_BFu1c_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1i_BFu1c, BFs1c_BFu1c_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1i_BFu1i, BFs1c_BFu1c_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1i_BFu1ll, BFs1c_BFu1c_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1i_BFu1s, BFs1c_BFu1c_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1ll, BFs1c_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1ll_BFs1c, BFs1c_BFu1c_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1ll_BFs1i, BFs1c_BFu1c_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1ll_BFs1ll, BFs1c_BFu1c_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1ll_BFs1s, BFs1c_BFu1c_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1ll_BFu1c, BFs1c_BFu1c_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1ll_BFu1i, BFs1c_BFu1c_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1ll_BFu1ll, BFs1c_BFu1c_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1ll_BFu1s, BFs1c_BFu1c_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1s, BFs1c_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1s_BFs1c, BFs1c_BFu1c_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1s_BFs1i, BFs1c_BFu1c_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1s_BFs1ll, BFs1c_BFu1c_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1c_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1s_BFs1s, BFs1c_BFu1c_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1s_BFu1c, BFs1c_BFu1c_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1s_BFu1i, BFs1c_BFu1c_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1s_BFu1ll, BFs1c_BFu1c_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1c_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1c_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1c_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1c_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1c_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1c_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1c_BFu1s_BFu1s, BFs1c_BFu1c_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i, BFs1c_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1c, BFs1c_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1c_BFs1c, BFs1c_BFu1i_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1c_BFs1i, BFs1c_BFu1i_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1c_BFs1ll, BFs1c_BFu1i_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1c_BFs1s, BFs1c_BFu1i_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1c_BFu1c, BFs1c_BFu1i_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1c_BFu1i, BFs1c_BFu1i_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1c_BFu1ll, BFs1c_BFu1i_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1c_BFu1s, BFs1c_BFu1i_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1i, BFs1c_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1i_BFs1c, BFs1c_BFu1i_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1i_BFs1i, BFs1c_BFu1i_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1i_BFs1ll, BFs1c_BFu1i_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1i_BFs1s, BFs1c_BFu1i_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1i_BFu1c, BFs1c_BFu1i_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1i_BFu1i, BFs1c_BFu1i_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1i_BFu1ll, BFs1c_BFu1i_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1i_BFu1s, BFs1c_BFu1i_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1ll, BFs1c_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1ll_BFs1c, BFs1c_BFu1i_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1ll_BFs1i, BFs1c_BFu1i_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1ll_BFs1ll, BFs1c_BFu1i_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1ll_BFs1s, BFs1c_BFu1i_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1ll_BFu1c, BFs1c_BFu1i_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1ll_BFu1i, BFs1c_BFu1i_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1ll_BFu1ll, BFs1c_BFu1i_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1ll_BFu1s, BFs1c_BFu1i_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1s, BFs1c_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1s_BFs1c, BFs1c_BFu1i_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1s_BFs1i, BFs1c_BFu1i_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1s_BFs1ll, BFs1c_BFu1i_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1s_BFs1s, BFs1c_BFu1i_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1s_BFu1c, BFs1c_BFu1i_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1s_BFu1i, BFs1c_BFu1i_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1s_BFu1ll, BFs1c_BFu1i_BFs1s_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFs1s_BFu1s, BFs1c_BFu1i_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1c, BFs1c_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1c_BFs1c, BFs1c_BFu1i_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1c_BFs1i, BFs1c_BFu1i_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1c_BFs1ll, BFs1c_BFu1i_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1c_BFs1s, BFs1c_BFu1i_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1c_BFu1c, BFs1c_BFu1i_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1c_BFu1i, BFs1c_BFu1i_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1c_BFu1ll, BFs1c_BFu1i_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1c_BFu1s, BFs1c_BFu1i_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1i, BFs1c_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1i_BFs1c, BFs1c_BFu1i_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1i_BFs1i, BFs1c_BFu1i_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1i_BFs1ll, BFs1c_BFu1i_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1i_BFs1s, BFs1c_BFu1i_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1i_BFu1c, BFs1c_BFu1i_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1i_BFu1i, BFs1c_BFu1i_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1i_BFu1ll, BFs1c_BFu1i_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1i_BFu1s, BFs1c_BFu1i_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1ll, BFs1c_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1ll_BFs1c, BFs1c_BFu1i_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1ll_BFs1i, BFs1c_BFu1i_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1ll_BFs1ll, BFs1c_BFu1i_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1ll_BFs1s, BFs1c_BFu1i_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1ll_BFu1c, BFs1c_BFu1i_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1ll_BFu1i, BFs1c_BFu1i_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1ll_BFu1ll, BFs1c_BFu1i_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1ll_BFu1s, BFs1c_BFu1i_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1s, BFs1c_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1s_BFs1c, BFs1c_BFu1i_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1s_BFs1i, BFs1c_BFu1i_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1s_BFs1ll, BFs1c_BFu1i_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1i_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1s_BFs1s, BFs1c_BFu1i_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1s_BFu1c, BFs1c_BFu1i_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1s_BFu1i, BFs1c_BFu1i_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1s_BFu1ll, BFs1c_BFu1i_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1i_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1i_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1i_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1i_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1i_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1i_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1i_BFu1s_BFu1s, BFs1c_BFu1i_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll, BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1c, BFs1c_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1c_BFs1c, BFs1c_BFu1ll_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1c_BFs1i, BFs1c_BFu1ll_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1c_BFs1ll, BFs1c_BFu1ll_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1c_BFs1s, BFs1c_BFu1ll_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1c_BFu1c, BFs1c_BFu1ll_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1c_BFu1i, BFs1c_BFu1ll_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1c_BFu1ll, BFs1c_BFu1ll_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1c_BFu1s, BFs1c_BFu1ll_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1i, BFs1c_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1i_BFs1c, BFs1c_BFu1ll_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1i_BFs1i, BFs1c_BFu1ll_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1i_BFs1ll, BFs1c_BFu1ll_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1i_BFs1s, BFs1c_BFu1ll_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1i_BFu1c, BFs1c_BFu1ll_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1i_BFu1i, BFs1c_BFu1ll_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1i_BFu1ll, BFs1c_BFu1ll_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1i_BFu1s, BFs1c_BFu1ll_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1ll, BFs1c_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1ll_BFs1c, BFs1c_BFu1ll_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1ll_BFs1i, BFs1c_BFu1ll_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1ll_BFs1ll, BFs1c_BFu1ll_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1ll_BFs1s, BFs1c_BFu1ll_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1ll_BFu1c, BFs1c_BFu1ll_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1ll_BFu1i, BFs1c_BFu1ll_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1ll_BFu1ll, BFs1c_BFu1ll_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1ll_BFu1s, BFs1c_BFu1ll_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1s, BFs1c_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1s_BFs1c, BFs1c_BFu1ll_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1s_BFs1i, BFs1c_BFu1ll_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1s_BFs1ll, BFs1c_BFu1ll_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1s_BFs1s, BFs1c_BFu1ll_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1s_BFu1c, BFs1c_BFu1ll_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1s_BFu1i, BFs1c_BFu1ll_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1s_BFu1ll, BFs1c_BFu1ll_BFs1s_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFs1s_BFu1s, BFs1c_BFu1ll_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1c, BFs1c_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1c_BFs1c, BFs1c_BFu1ll_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1c_BFs1i, BFs1c_BFu1ll_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1c_BFs1ll, BFs1c_BFu1ll_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1c_BFs1s, BFs1c_BFu1ll_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1c_BFu1c, BFs1c_BFu1ll_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1c_BFu1i, BFs1c_BFu1ll_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1c_BFu1ll, BFs1c_BFu1ll_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1c_BFu1s, BFs1c_BFu1ll_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1i, BFs1c_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1i_BFs1c, BFs1c_BFu1ll_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1i_BFs1i, BFs1c_BFu1ll_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1i_BFs1ll, BFs1c_BFu1ll_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1i_BFs1s, BFs1c_BFu1ll_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1i_BFu1c, BFs1c_BFu1ll_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1i_BFu1i, BFs1c_BFu1ll_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1i_BFu1ll, BFs1c_BFu1ll_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1i_BFu1s, BFs1c_BFu1ll_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1ll, BFs1c_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1ll_BFs1c, BFs1c_BFu1ll_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1ll_BFs1i, BFs1c_BFu1ll_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1ll_BFs1ll, BFs1c_BFu1ll_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1ll_BFs1s, BFs1c_BFu1ll_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1ll_BFu1c, BFs1c_BFu1ll_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1ll_BFu1i, BFs1c_BFu1ll_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1ll_BFu1ll, BFs1c_BFu1ll_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1ll_BFu1s, BFs1c_BFu1ll_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1s, BFs1c_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1s_BFs1c, BFs1c_BFu1ll_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1s_BFs1i, BFs1c_BFu1ll_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1s_BFs1ll, BFs1c_BFu1ll_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1ll_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1s_BFs1s, BFs1c_BFu1ll_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1s_BFu1c, BFs1c_BFu1ll_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1s_BFu1i, BFs1c_BFu1ll_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1s_BFu1ll, BFs1c_BFu1ll_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1ll_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1ll_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1ll_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1ll_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1ll_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1ll_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1ll_BFu1s_BFu1s, BFs1c_BFu1ll_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s, BFs1c_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1c, BFs1c_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1c_BFs1c, BFs1c_BFu1s_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1c_BFs1i, BFs1c_BFu1s_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1c_BFs1ll, BFs1c_BFu1s_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1c_BFs1s, BFs1c_BFu1s_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1c_BFu1c, BFs1c_BFu1s_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1c_BFu1i, BFs1c_BFu1s_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1c_BFu1ll, BFs1c_BFu1s_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1c_BFu1s, BFs1c_BFu1s_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1i, BFs1c_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1i_BFs1c, BFs1c_BFu1s_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1i_BFs1i, BFs1c_BFu1s_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1i_BFs1ll, BFs1c_BFu1s_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1i_BFs1s, BFs1c_BFu1s_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1i_BFu1c, BFs1c_BFu1s_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1i_BFu1i, BFs1c_BFu1s_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1i_BFu1ll, BFs1c_BFu1s_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1i_BFu1s, BFs1c_BFu1s_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1ll, BFs1c_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1ll_BFs1c, BFs1c_BFu1s_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1ll_BFs1i, BFs1c_BFu1s_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1ll_BFs1ll, BFs1c_BFu1s_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1ll_BFs1s, BFs1c_BFu1s_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1ll_BFu1c, BFs1c_BFu1s_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1ll_BFu1i, BFs1c_BFu1s_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1ll_BFu1ll, BFs1c_BFu1s_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1ll_BFu1s, BFs1c_BFu1s_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1s, BFs1c_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1s_BFs1c, BFs1c_BFu1s_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1s_BFs1i, BFs1c_BFu1s_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1s_BFs1ll, BFs1c_BFu1s_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1s_BFs1s, BFs1c_BFu1s_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1s_BFu1c, BFs1c_BFu1s_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1s_BFu1i, BFs1c_BFu1s_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1s_BFu1ll, BFs1c_BFu1s_BFs1s_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1c_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFs1s_BFu1s, BFs1c_BFu1s_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1c, BFs1c_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1c_BFs1c, BFs1c_BFu1s_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1c_BFs1i, BFs1c_BFu1s_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1c_BFs1ll, BFs1c_BFu1s_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1c_BFs1s, BFs1c_BFu1s_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1c_BFu1c, BFs1c_BFu1s_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1c_BFu1i, BFs1c_BFu1s_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1c_BFu1ll, BFs1c_BFu1s_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1c_BFu1s, BFs1c_BFu1s_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1i, BFs1c_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1i_BFs1c, BFs1c_BFu1s_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1i_BFs1i, BFs1c_BFu1s_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1i_BFs1ll, BFs1c_BFu1s_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1i_BFs1s, BFs1c_BFu1s_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1i_BFu1c, BFs1c_BFu1s_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1i_BFu1i, BFs1c_BFu1s_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1i_BFu1ll, BFs1c_BFu1s_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1i_BFu1s, BFs1c_BFu1s_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1ll, BFs1c_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1ll_BFs1c, BFs1c_BFu1s_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1ll_BFs1i, BFs1c_BFu1s_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1ll_BFs1ll, BFs1c_BFu1s_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1ll_BFs1s, BFs1c_BFu1s_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1ll_BFu1c, BFs1c_BFu1s_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1ll_BFu1i, BFs1c_BFu1s_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1ll_BFu1ll, BFs1c_BFu1s_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1ll_BFu1s, BFs1c_BFu1s_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1s, BFs1c_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1s_BFs1c, BFs1c_BFu1s_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1s_BFs1i, BFs1c_BFu1s_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1s_BFs1ll, BFs1c_BFu1s_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1c_BFu1s_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1s_BFs1s, BFs1c_BFu1s_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1s_BFu1c, BFs1c_BFu1s_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1s_BFu1i, BFs1c_BFu1s_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1s_BFu1ll, BFs1c_BFu1s_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1c_BFu1s_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1c_BFu1s_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1c_BFu1s_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1c_BFu1s_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1c_BFu1s_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1c_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1c_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1c_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1c_BFu1s_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1c_BFu1s_BFu1s_BFu1s, BFs1c_BFu1s_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c, BFs1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1c, BFs1i_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1c_BFs1c, BFs1i_BFs1c_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1c_BFs1i, BFs1i_BFs1c_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1c_BFs1ll, BFs1i_BFs1c_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1c_BFs1s, BFs1i_BFs1c_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1c_BFu1c, BFs1i_BFs1c_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1c_BFu1i, BFs1i_BFs1c_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1c_BFu1ll, BFs1i_BFs1c_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1c_BFu1s, BFs1i_BFs1c_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1i, BFs1i_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1i_BFs1c, BFs1i_BFs1c_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1i_BFs1i, BFs1i_BFs1c_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1i_BFs1ll, BFs1i_BFs1c_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1i_BFs1s, BFs1i_BFs1c_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1i_BFu1c, BFs1i_BFs1c_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1i_BFu1i, BFs1i_BFs1c_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1i_BFu1ll, BFs1i_BFs1c_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1i_BFu1s, BFs1i_BFs1c_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1ll, BFs1i_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1ll_BFs1c, BFs1i_BFs1c_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1ll_BFs1i, BFs1i_BFs1c_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1ll_BFs1ll, BFs1i_BFs1c_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1ll_BFs1s, BFs1i_BFs1c_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1ll_BFu1c, BFs1i_BFs1c_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1ll_BFu1i, BFs1i_BFs1c_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1ll_BFu1ll, BFs1i_BFs1c_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1ll_BFu1s, BFs1i_BFs1c_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1s, BFs1i_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1s_BFs1c, BFs1i_BFs1c_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1s_BFs1i, BFs1i_BFs1c_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1s_BFs1ll, BFs1i_BFs1c_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1s_BFs1s, BFs1i_BFs1c_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1s_BFu1c, BFs1i_BFs1c_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1s_BFu1i, BFs1i_BFs1c_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1s_BFu1ll, BFs1i_BFs1c_BFs1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFs1s_BFu1s, BFs1i_BFs1c_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1c, BFs1i_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1c_BFs1c, BFs1i_BFs1c_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1c_BFs1i, BFs1i_BFs1c_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1c_BFs1ll, BFs1i_BFs1c_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1c_BFs1s, BFs1i_BFs1c_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1c_BFu1c, BFs1i_BFs1c_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1c_BFu1i, BFs1i_BFs1c_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1c_BFu1ll, BFs1i_BFs1c_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1c_BFu1s, BFs1i_BFs1c_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1i, BFs1i_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1i_BFs1c, BFs1i_BFs1c_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1i_BFs1i, BFs1i_BFs1c_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1i_BFs1ll, BFs1i_BFs1c_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1i_BFs1s, BFs1i_BFs1c_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1i_BFu1c, BFs1i_BFs1c_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1i_BFu1i, BFs1i_BFs1c_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1i_BFu1ll, BFs1i_BFs1c_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1i_BFu1s, BFs1i_BFs1c_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1ll, BFs1i_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1ll_BFs1c, BFs1i_BFs1c_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1ll_BFs1i, BFs1i_BFs1c_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1ll_BFs1ll, BFs1i_BFs1c_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1ll_BFs1s, BFs1i_BFs1c_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1ll_BFu1c, BFs1i_BFs1c_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1ll_BFu1i, BFs1i_BFs1c_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1ll_BFu1ll, BFs1i_BFs1c_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1ll_BFu1s, BFs1i_BFs1c_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1s, BFs1i_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1s_BFs1c, BFs1i_BFs1c_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1s_BFs1i, BFs1i_BFs1c_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1s_BFs1ll, BFs1i_BFs1c_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1c_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1s_BFs1s, BFs1i_BFs1c_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1s_BFu1c, BFs1i_BFs1c_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1s_BFu1i, BFs1i_BFs1c_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1s_BFu1ll, BFs1i_BFs1c_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1c_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1c_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1c_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1c_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1c_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1c_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1c_BFu1s_BFu1s, BFs1i_BFs1c_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i, BFs1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1c, BFs1i_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1c_BFs1c, BFs1i_BFs1i_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1c_BFs1i, BFs1i_BFs1i_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1c_BFs1ll, BFs1i_BFs1i_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1c_BFs1s, BFs1i_BFs1i_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1c_BFu1c, BFs1i_BFs1i_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1c_BFu1i, BFs1i_BFs1i_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1c_BFu1ll, BFs1i_BFs1i_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1c_BFu1s, BFs1i_BFs1i_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1i, BFs1i_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1i_BFs1c, BFs1i_BFs1i_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1i_BFs1i, BFs1i_BFs1i_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1i_BFs1ll, BFs1i_BFs1i_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1i_BFs1s, BFs1i_BFs1i_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1i_BFu1c, BFs1i_BFs1i_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1i_BFu1i, BFs1i_BFs1i_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1i_BFu1ll, BFs1i_BFs1i_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1i_BFu1s, BFs1i_BFs1i_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1ll, BFs1i_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1ll_BFs1c, BFs1i_BFs1i_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1ll_BFs1i, BFs1i_BFs1i_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1ll_BFs1ll, BFs1i_BFs1i_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1ll_BFs1s, BFs1i_BFs1i_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1ll_BFu1c, BFs1i_BFs1i_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1ll_BFu1i, BFs1i_BFs1i_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1ll_BFu1ll, BFs1i_BFs1i_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1ll_BFu1s, BFs1i_BFs1i_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1s, BFs1i_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1s_BFs1c, BFs1i_BFs1i_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1s_BFs1i, BFs1i_BFs1i_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1s_BFs1ll, BFs1i_BFs1i_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1s_BFs1s, BFs1i_BFs1i_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1s_BFu1c, BFs1i_BFs1i_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1s_BFu1i, BFs1i_BFs1i_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1s_BFu1ll, BFs1i_BFs1i_BFs1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFs1s_BFu1s, BFs1i_BFs1i_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1c, BFs1i_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1c_BFs1c, BFs1i_BFs1i_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1c_BFs1i, BFs1i_BFs1i_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1c_BFs1ll, BFs1i_BFs1i_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1c_BFs1s, BFs1i_BFs1i_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1c_BFu1c, BFs1i_BFs1i_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1c_BFu1i, BFs1i_BFs1i_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1c_BFu1ll, BFs1i_BFs1i_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1c_BFu1s, BFs1i_BFs1i_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1i, BFs1i_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1i_BFs1c, BFs1i_BFs1i_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1i_BFs1i, BFs1i_BFs1i_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1i_BFs1ll, BFs1i_BFs1i_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1i_BFs1s, BFs1i_BFs1i_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1i_BFu1c, BFs1i_BFs1i_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1i_BFu1i, BFs1i_BFs1i_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1i_BFu1ll, BFs1i_BFs1i_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1i_BFu1s, BFs1i_BFs1i_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1ll, BFs1i_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1ll_BFs1c, BFs1i_BFs1i_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1ll_BFs1i, BFs1i_BFs1i_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1ll_BFs1ll, BFs1i_BFs1i_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1ll_BFs1s, BFs1i_BFs1i_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1ll_BFu1c, BFs1i_BFs1i_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1ll_BFu1i, BFs1i_BFs1i_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1ll_BFu1ll, BFs1i_BFs1i_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1ll_BFu1s, BFs1i_BFs1i_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1s, BFs1i_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1s_BFs1c, BFs1i_BFs1i_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1s_BFs1i, BFs1i_BFs1i_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1s_BFs1ll, BFs1i_BFs1i_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1i_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1s_BFs1s, BFs1i_BFs1i_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1s_BFu1c, BFs1i_BFs1i_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1s_BFu1i, BFs1i_BFs1i_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1s_BFu1ll, BFs1i_BFs1i_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1i_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1i_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1i_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1i_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1i_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1i_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1i_BFu1s_BFu1s, BFs1i_BFs1i_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll, BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1c, BFs1i_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1c_BFs1c, BFs1i_BFs1ll_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1c_BFs1i, BFs1i_BFs1ll_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1c_BFs1ll, BFs1i_BFs1ll_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1c_BFs1s, BFs1i_BFs1ll_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1c_BFu1c, BFs1i_BFs1ll_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1c_BFu1i, BFs1i_BFs1ll_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1c_BFu1ll, BFs1i_BFs1ll_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1c_BFu1s, BFs1i_BFs1ll_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1i, BFs1i_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1i_BFs1c, BFs1i_BFs1ll_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1i_BFs1i, BFs1i_BFs1ll_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1i_BFs1ll, BFs1i_BFs1ll_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1i_BFs1s, BFs1i_BFs1ll_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1i_BFu1c, BFs1i_BFs1ll_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1i_BFu1i, BFs1i_BFs1ll_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1i_BFu1ll, BFs1i_BFs1ll_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1i_BFu1s, BFs1i_BFs1ll_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1ll, BFs1i_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1ll_BFs1c, BFs1i_BFs1ll_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1ll_BFs1i, BFs1i_BFs1ll_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1ll_BFs1ll, BFs1i_BFs1ll_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1ll_BFs1s, BFs1i_BFs1ll_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1ll_BFu1c, BFs1i_BFs1ll_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1ll_BFu1i, BFs1i_BFs1ll_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1ll_BFu1ll, BFs1i_BFs1ll_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1ll_BFu1s, BFs1i_BFs1ll_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1s, BFs1i_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1s_BFs1c, BFs1i_BFs1ll_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1s_BFs1i, BFs1i_BFs1ll_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1s_BFs1ll, BFs1i_BFs1ll_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1s_BFs1s, BFs1i_BFs1ll_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1s_BFu1c, BFs1i_BFs1ll_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1s_BFu1i, BFs1i_BFs1ll_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1s_BFu1ll, BFs1i_BFs1ll_BFs1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFs1s_BFu1s, BFs1i_BFs1ll_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1c, BFs1i_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1c_BFs1c, BFs1i_BFs1ll_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1c_BFs1i, BFs1i_BFs1ll_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1c_BFs1ll, BFs1i_BFs1ll_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1c_BFs1s, BFs1i_BFs1ll_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1c_BFu1c, BFs1i_BFs1ll_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1c_BFu1i, BFs1i_BFs1ll_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1c_BFu1ll, BFs1i_BFs1ll_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1c_BFu1s, BFs1i_BFs1ll_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1i, BFs1i_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1i_BFs1c, BFs1i_BFs1ll_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1i_BFs1i, BFs1i_BFs1ll_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1i_BFs1ll, BFs1i_BFs1ll_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1i_BFs1s, BFs1i_BFs1ll_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1i_BFu1c, BFs1i_BFs1ll_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1i_BFu1i, BFs1i_BFs1ll_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1i_BFu1ll, BFs1i_BFs1ll_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1i_BFu1s, BFs1i_BFs1ll_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1ll, BFs1i_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1ll_BFs1c, BFs1i_BFs1ll_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1ll_BFs1i, BFs1i_BFs1ll_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1ll_BFs1ll, BFs1i_BFs1ll_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1ll_BFs1s, BFs1i_BFs1ll_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1ll_BFu1c, BFs1i_BFs1ll_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1ll_BFu1i, BFs1i_BFs1ll_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1ll_BFu1ll, BFs1i_BFs1ll_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1ll_BFu1s, BFs1i_BFs1ll_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1s, BFs1i_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1s_BFs1c, BFs1i_BFs1ll_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1s_BFs1i, BFs1i_BFs1ll_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1s_BFs1ll, BFs1i_BFs1ll_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1ll_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1s_BFs1s, BFs1i_BFs1ll_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1s_BFu1c, BFs1i_BFs1ll_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1s_BFu1i, BFs1i_BFs1ll_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1s_BFu1ll, BFs1i_BFs1ll_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1ll_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1ll_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1ll_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1ll_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1ll_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1ll_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1ll_BFu1s_BFu1s, BFs1i_BFs1ll_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s, BFs1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1c, BFs1i_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1c_BFs1c, BFs1i_BFs1s_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1c_BFs1i, BFs1i_BFs1s_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1c_BFs1ll, BFs1i_BFs1s_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1c_BFs1s, BFs1i_BFs1s_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1c_BFu1c, BFs1i_BFs1s_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1c_BFu1i, BFs1i_BFs1s_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1c_BFu1ll, BFs1i_BFs1s_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1c_BFu1s, BFs1i_BFs1s_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1i, BFs1i_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1i_BFs1c, BFs1i_BFs1s_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1i_BFs1i, BFs1i_BFs1s_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1i_BFs1ll, BFs1i_BFs1s_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1i_BFs1s, BFs1i_BFs1s_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1i_BFu1c, BFs1i_BFs1s_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1i_BFu1i, BFs1i_BFs1s_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1i_BFu1ll, BFs1i_BFs1s_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1i_BFu1s, BFs1i_BFs1s_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1ll, BFs1i_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1ll_BFs1c, BFs1i_BFs1s_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1ll_BFs1i, BFs1i_BFs1s_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1ll_BFs1ll, BFs1i_BFs1s_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1ll_BFs1s, BFs1i_BFs1s_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1ll_BFu1c, BFs1i_BFs1s_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1ll_BFu1i, BFs1i_BFs1s_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1ll_BFu1ll, BFs1i_BFs1s_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1ll_BFu1s, BFs1i_BFs1s_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1s, BFs1i_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1s_BFs1c, BFs1i_BFs1s_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1s_BFs1i, BFs1i_BFs1s_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1s_BFs1ll, BFs1i_BFs1s_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1s_BFs1s, BFs1i_BFs1s_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1s_BFu1c, BFs1i_BFs1s_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1s_BFu1i, BFs1i_BFs1s_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1s_BFu1ll, BFs1i_BFs1s_BFs1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFs1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFs1s_BFu1s, BFs1i_BFs1s_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1c, BFs1i_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1c_BFs1c, BFs1i_BFs1s_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1c_BFs1i, BFs1i_BFs1s_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1c_BFs1ll, BFs1i_BFs1s_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1c_BFs1s, BFs1i_BFs1s_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1c_BFu1c, BFs1i_BFs1s_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1c_BFu1i, BFs1i_BFs1s_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1c_BFu1ll, BFs1i_BFs1s_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1c_BFu1s, BFs1i_BFs1s_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1i, BFs1i_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1i_BFs1c, BFs1i_BFs1s_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1i_BFs1i, BFs1i_BFs1s_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1i_BFs1ll, BFs1i_BFs1s_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1i_BFs1s, BFs1i_BFs1s_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1i_BFu1c, BFs1i_BFs1s_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1i_BFu1i, BFs1i_BFs1s_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1i_BFu1ll, BFs1i_BFs1s_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1i_BFu1s, BFs1i_BFs1s_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1ll, BFs1i_BFs1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1ll_BFs1c, BFs1i_BFs1s_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1ll_BFs1i, BFs1i_BFs1s_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1ll_BFs1ll, BFs1i_BFs1s_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1ll_BFs1s, BFs1i_BFs1s_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1ll_BFu1c, BFs1i_BFs1s_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1ll_BFu1i, BFs1i_BFs1s_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1ll_BFu1ll, BFs1i_BFs1s_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1ll_BFu1s, BFs1i_BFs1s_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1s, BFs1i_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1s_BFs1c, BFs1i_BFs1s_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1s_BFs1i, BFs1i_BFs1s_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1s_BFs1ll, BFs1i_BFs1s_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFs1s_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1s_BFs1s, BFs1i_BFs1s_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1s_BFu1c, BFs1i_BFs1s_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1s_BFu1i, BFs1i_BFs1s_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1s_BFu1ll, BFs1i_BFs1s_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFs1s_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFs1s_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFs1s_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFs1s_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFs1s_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1i_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFs1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFs1s_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFs1s_BFu1s_BFu1s, BFs1i_BFs1s_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c, BFs1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1c, BFs1i_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1c_BFs1c, BFs1i_BFu1c_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1c_BFs1i, BFs1i_BFu1c_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1c_BFs1ll, BFs1i_BFu1c_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1c_BFs1s, BFs1i_BFu1c_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1c_BFu1c, BFs1i_BFu1c_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1c_BFu1i, BFs1i_BFu1c_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1c_BFu1ll, BFs1i_BFu1c_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1c_BFu1s, BFs1i_BFu1c_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1i, BFs1i_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1i_BFs1c, BFs1i_BFu1c_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1i_BFs1i, BFs1i_BFu1c_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1i_BFs1ll, BFs1i_BFu1c_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1i_BFs1s, BFs1i_BFu1c_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1i_BFu1c, BFs1i_BFu1c_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1i_BFu1i, BFs1i_BFu1c_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1i_BFu1ll, BFs1i_BFu1c_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1i_BFu1s, BFs1i_BFu1c_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1ll, BFs1i_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1ll_BFs1c, BFs1i_BFu1c_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1ll_BFs1i, BFs1i_BFu1c_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1ll_BFs1ll, BFs1i_BFu1c_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1ll_BFs1s, BFs1i_BFu1c_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1ll_BFu1c, BFs1i_BFu1c_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1ll_BFu1i, BFs1i_BFu1c_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1ll_BFu1ll, BFs1i_BFu1c_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1ll_BFu1s, BFs1i_BFu1c_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1s, BFs1i_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1s_BFs1c, BFs1i_BFu1c_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1s_BFs1i, BFs1i_BFu1c_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1s_BFs1ll, BFs1i_BFu1c_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1s_BFs1s, BFs1i_BFu1c_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1s_BFu1c, BFs1i_BFu1c_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1s_BFu1i, BFs1i_BFu1c_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1s_BFu1ll, BFs1i_BFu1c_BFs1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1c_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFs1s_BFu1s, BFs1i_BFu1c_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1c, BFs1i_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1c_BFs1c, BFs1i_BFu1c_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1c_BFs1i, BFs1i_BFu1c_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1c_BFs1ll, BFs1i_BFu1c_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1c_BFs1s, BFs1i_BFu1c_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1c_BFu1c, BFs1i_BFu1c_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1c_BFu1i, BFs1i_BFu1c_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1c_BFu1ll, BFs1i_BFu1c_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1c_BFu1s, BFs1i_BFu1c_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1i, BFs1i_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1i_BFs1c, BFs1i_BFu1c_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1i_BFs1i, BFs1i_BFu1c_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1i_BFs1ll, BFs1i_BFu1c_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1i_BFs1s, BFs1i_BFu1c_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1i_BFu1c, BFs1i_BFu1c_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1i_BFu1i, BFs1i_BFu1c_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1i_BFu1ll, BFs1i_BFu1c_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1i_BFu1s, BFs1i_BFu1c_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1ll, BFs1i_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1ll_BFs1c, BFs1i_BFu1c_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1ll_BFs1i, BFs1i_BFu1c_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1ll_BFs1ll, BFs1i_BFu1c_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1ll_BFs1s, BFs1i_BFu1c_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1ll_BFu1c, BFs1i_BFu1c_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1ll_BFu1i, BFs1i_BFu1c_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1ll_BFu1ll, BFs1i_BFu1c_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1ll_BFu1s, BFs1i_BFu1c_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1s, BFs1i_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1s_BFs1c, BFs1i_BFu1c_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1s_BFs1i, BFs1i_BFu1c_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1s_BFs1ll, BFs1i_BFu1c_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1c_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1s_BFs1s, BFs1i_BFu1c_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1s_BFu1c, BFs1i_BFu1c_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1s_BFu1i, BFs1i_BFu1c_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1s_BFu1ll, BFs1i_BFu1c_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1c_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1c_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1c_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1c_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1c_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1c_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1c_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1c_BFu1s_BFu1s, BFs1i_BFu1c_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i, BFs1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1c, BFs1i_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1c_BFs1c, BFs1i_BFu1i_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1c_BFs1i, BFs1i_BFu1i_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1c_BFs1ll, BFs1i_BFu1i_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1c_BFs1s, BFs1i_BFu1i_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1c_BFu1c, BFs1i_BFu1i_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1c_BFu1i, BFs1i_BFu1i_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1c_BFu1ll, BFs1i_BFu1i_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1c_BFu1s, BFs1i_BFu1i_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1i, BFs1i_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1i_BFs1c, BFs1i_BFu1i_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1i_BFs1i, BFs1i_BFu1i_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1i_BFs1ll, BFs1i_BFu1i_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1i_BFs1s, BFs1i_BFu1i_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1i_BFu1c, BFs1i_BFu1i_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1i_BFu1i, BFs1i_BFu1i_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1i_BFu1ll, BFs1i_BFu1i_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1i_BFu1s, BFs1i_BFu1i_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1ll, BFs1i_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1ll_BFs1c, BFs1i_BFu1i_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1ll_BFs1i, BFs1i_BFu1i_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1ll_BFs1ll, BFs1i_BFu1i_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1ll_BFs1s, BFs1i_BFu1i_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1ll_BFu1c, BFs1i_BFu1i_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1ll_BFu1i, BFs1i_BFu1i_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1ll_BFu1ll, BFs1i_BFu1i_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1ll_BFu1s, BFs1i_BFu1i_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1s, BFs1i_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1s_BFs1c, BFs1i_BFu1i_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1s_BFs1i, BFs1i_BFu1i_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1s_BFs1ll, BFs1i_BFu1i_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1s_BFs1s, BFs1i_BFu1i_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1s_BFu1c, BFs1i_BFu1i_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1s_BFu1i, BFs1i_BFu1i_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1s_BFu1ll, BFs1i_BFu1i_BFs1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1i_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFs1s_BFu1s, BFs1i_BFu1i_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1c, BFs1i_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1c_BFs1c, BFs1i_BFu1i_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1c_BFs1i, BFs1i_BFu1i_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1c_BFs1ll, BFs1i_BFu1i_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1c_BFs1s, BFs1i_BFu1i_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1c_BFu1c, BFs1i_BFu1i_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1c_BFu1i, BFs1i_BFu1i_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1c_BFu1ll, BFs1i_BFu1i_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1c_BFu1s, BFs1i_BFu1i_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1i, BFs1i_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1i_BFs1c, BFs1i_BFu1i_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1i_BFs1i, BFs1i_BFu1i_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1i_BFs1ll, BFs1i_BFu1i_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1i_BFs1s, BFs1i_BFu1i_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1i_BFu1c, BFs1i_BFu1i_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1i_BFu1i, BFs1i_BFu1i_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1i_BFu1ll, BFs1i_BFu1i_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1i_BFu1s, BFs1i_BFu1i_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1ll, BFs1i_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1ll_BFs1c, BFs1i_BFu1i_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1ll_BFs1i, BFs1i_BFu1i_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1ll_BFs1ll, BFs1i_BFu1i_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1ll_BFs1s, BFs1i_BFu1i_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1ll_BFu1c, BFs1i_BFu1i_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1ll_BFu1i, BFs1i_BFu1i_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1ll_BFu1ll, BFs1i_BFu1i_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1ll_BFu1s, BFs1i_BFu1i_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1s, BFs1i_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1s_BFs1c, BFs1i_BFu1i_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1s_BFs1i, BFs1i_BFu1i_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1s_BFs1ll, BFs1i_BFu1i_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1i_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1s_BFs1s, BFs1i_BFu1i_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1s_BFu1c, BFs1i_BFu1i_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1s_BFu1i, BFs1i_BFu1i_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1s_BFu1ll, BFs1i_BFu1i_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1i_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1i_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1i_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1i_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1i_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1i_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1i_BFu1s_BFu1s, BFs1i_BFu1i_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll, BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1c, BFs1i_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1c_BFs1c, BFs1i_BFu1ll_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1c_BFs1i, BFs1i_BFu1ll_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1c_BFs1ll, BFs1i_BFu1ll_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1c_BFs1s, BFs1i_BFu1ll_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1c_BFu1c, BFs1i_BFu1ll_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1c_BFu1i, BFs1i_BFu1ll_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1c_BFu1ll, BFs1i_BFu1ll_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1c_BFu1s, BFs1i_BFu1ll_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1i, BFs1i_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1i_BFs1c, BFs1i_BFu1ll_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1i_BFs1i, BFs1i_BFu1ll_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1i_BFs1ll, BFs1i_BFu1ll_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1i_BFs1s, BFs1i_BFu1ll_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1i_BFu1c, BFs1i_BFu1ll_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1i_BFu1i, BFs1i_BFu1ll_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1i_BFu1ll, BFs1i_BFu1ll_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1i_BFu1s, BFs1i_BFu1ll_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1ll, BFs1i_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1ll_BFs1c, BFs1i_BFu1ll_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1ll_BFs1i, BFs1i_BFu1ll_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1ll_BFs1ll, BFs1i_BFu1ll_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1ll_BFs1s, BFs1i_BFu1ll_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1ll_BFu1c, BFs1i_BFu1ll_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1ll_BFu1i, BFs1i_BFu1ll_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1ll_BFu1ll, BFs1i_BFu1ll_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1ll_BFu1s, BFs1i_BFu1ll_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1s, BFs1i_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1s_BFs1c, BFs1i_BFu1ll_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1s_BFs1i, BFs1i_BFu1ll_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1s_BFs1ll, BFs1i_BFu1ll_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1s_BFs1s, BFs1i_BFu1ll_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1s_BFu1c, BFs1i_BFu1ll_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1s_BFu1i, BFs1i_BFu1ll_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1s_BFu1ll, BFs1i_BFu1ll_BFs1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1ll_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFs1s_BFu1s, BFs1i_BFu1ll_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1c, BFs1i_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1c_BFs1c, BFs1i_BFu1ll_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1c_BFs1i, BFs1i_BFu1ll_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1c_BFs1ll, BFs1i_BFu1ll_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1c_BFs1s, BFs1i_BFu1ll_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1c_BFu1c, BFs1i_BFu1ll_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1c_BFu1i, BFs1i_BFu1ll_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1c_BFu1ll, BFs1i_BFu1ll_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1c_BFu1s, BFs1i_BFu1ll_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1i, BFs1i_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1i_BFs1c, BFs1i_BFu1ll_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1i_BFs1i, BFs1i_BFu1ll_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1i_BFs1ll, BFs1i_BFu1ll_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1i_BFs1s, BFs1i_BFu1ll_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1i_BFu1c, BFs1i_BFu1ll_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1i_BFu1i, BFs1i_BFu1ll_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1i_BFu1ll, BFs1i_BFu1ll_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1i_BFu1s, BFs1i_BFu1ll_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1ll, BFs1i_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1ll_BFs1c, BFs1i_BFu1ll_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1ll_BFs1i, BFs1i_BFu1ll_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1ll_BFs1ll, BFs1i_BFu1ll_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1ll_BFs1s, BFs1i_BFu1ll_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1ll_BFu1c, BFs1i_BFu1ll_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1ll_BFu1i, BFs1i_BFu1ll_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1ll_BFu1ll, BFs1i_BFu1ll_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1ll_BFu1s, BFs1i_BFu1ll_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1s, BFs1i_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1s_BFs1c, BFs1i_BFu1ll_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1s_BFs1i, BFs1i_BFu1ll_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1s_BFs1ll, BFs1i_BFu1ll_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1ll_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1s_BFs1s, BFs1i_BFu1ll_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1s_BFu1c, BFs1i_BFu1ll_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1s_BFu1i, BFs1i_BFu1ll_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1s_BFu1ll, BFs1i_BFu1ll_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1ll_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1ll_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1ll_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1ll_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1ll_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1ll_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1ll_BFu1s_BFu1s, BFs1i_BFu1ll_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s, BFs1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1c, BFs1i_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1c_BFs1c, BFs1i_BFu1s_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1c_BFs1i, BFs1i_BFu1s_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1c_BFs1ll, BFs1i_BFu1s_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1c_BFs1s, BFs1i_BFu1s_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1c_BFu1c, BFs1i_BFu1s_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1c_BFu1i, BFs1i_BFu1s_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1c_BFu1ll, BFs1i_BFu1s_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1c_BFu1s, BFs1i_BFu1s_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1i, BFs1i_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1i_BFs1c, BFs1i_BFu1s_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1i_BFs1i, BFs1i_BFu1s_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1i_BFs1ll, BFs1i_BFu1s_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1i_BFs1s, BFs1i_BFu1s_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1i_BFu1c, BFs1i_BFu1s_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1i_BFu1i, BFs1i_BFu1s_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1i_BFu1ll, BFs1i_BFu1s_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1i_BFu1s, BFs1i_BFu1s_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1ll, BFs1i_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1ll_BFs1c, BFs1i_BFu1s_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1ll_BFs1i, BFs1i_BFu1s_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1ll_BFs1ll, BFs1i_BFu1s_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1ll_BFs1s, BFs1i_BFu1s_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1ll_BFu1c, BFs1i_BFu1s_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1ll_BFu1i, BFs1i_BFu1s_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1ll_BFu1ll, BFs1i_BFu1s_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1ll_BFu1s, BFs1i_BFu1s_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1s, BFs1i_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1s_BFs1c, BFs1i_BFu1s_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1s_BFs1i, BFs1i_BFu1s_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1s_BFs1ll, BFs1i_BFu1s_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1s_BFs1s, BFs1i_BFu1s_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1s_BFu1c, BFs1i_BFu1s_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1s_BFu1i, BFs1i_BFu1s_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1s_BFu1ll, BFs1i_BFu1s_BFs1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFs1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFs1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFs1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFs1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFs1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1i_BFu1s_BFs1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFs1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFs1s_BFu1s, BFs1i_BFu1s_BFs1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1c, BFs1i_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1c_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1c_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1c_BFs1c, BFs1i_BFu1s_BFu1c_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1c_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1c_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1c_BFs1i, BFs1i_BFu1s_BFu1c_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1c_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1c_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1c_BFs1ll, BFs1i_BFu1s_BFu1c_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1c_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1c_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1c_BFs1s, BFs1i_BFu1s_BFu1c_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1c_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1c_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1c_BFu1c, BFs1i_BFu1s_BFu1c_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1c_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1c_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1c_BFu1i, BFs1i_BFu1s_BFu1c_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1c_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1c_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1c_BFu1ll, BFs1i_BFu1s_BFu1c_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1c_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1c_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1c_BFu1s, BFs1i_BFu1s_BFu1c_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1i, BFs1i_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1i_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1i_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1i_BFs1c, BFs1i_BFu1s_BFu1i_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1i_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1i_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1i_BFs1i, BFs1i_BFu1s_BFu1i_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1i_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1i_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1i_BFs1ll, BFs1i_BFu1s_BFu1i_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1i_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1i_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1i_BFs1s, BFs1i_BFu1s_BFu1i_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1i_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1i_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1i_BFu1c, BFs1i_BFu1s_BFu1i_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1i_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1i_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1i_BFu1i, BFs1i_BFu1s_BFu1i_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1i_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1i_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1i_BFu1ll, BFs1i_BFu1s_BFu1i_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1i_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1i_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1i_BFu1s, BFs1i_BFu1s_BFu1i_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1ll, BFs1i_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1ll_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1ll_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1ll_BFs1c, BFs1i_BFu1s_BFu1ll_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1ll_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1ll_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1ll_BFs1i, BFs1i_BFu1s_BFu1ll_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1ll_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1ll_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1ll_BFs1ll, BFs1i_BFu1s_BFu1ll_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1ll_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1ll_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1ll_BFs1s, BFs1i_BFu1s_BFu1ll_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1ll_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1ll_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1ll_BFu1c, BFs1i_BFu1s_BFu1ll_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1ll_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1ll_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1ll_BFu1i, BFs1i_BFu1s_BFu1ll_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1ll_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1ll_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1ll_BFu1ll, BFs1i_BFu1s_BFu1ll_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1ll_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1ll_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1ll_BFu1s, BFs1i_BFu1s_BFu1ll_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1s, BFs1i_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1s_BFs1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1s_BFs1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1s_BFs1c, BFs1i_BFu1s_BFu1s_BFs1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1s_BFs1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1s_BFs1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1s_BFs1i, BFs1i_BFu1s_BFu1s_BFs1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1s_BFs1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1s_BFs1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1s_BFs1ll, BFs1i_BFu1s_BFu1s_BFs1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1s_BFs1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1s_BFs1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1i_BFu1s_BFu1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1s_BFs1s, BFs1i_BFu1s_BFu1s_BFs1s)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1s_BFu1c()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1s_BFu1c");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1s_BFu1c, BFs1i_BFu1s_BFu1s_BFu1c)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1s_BFu1i()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1s_BFu1i");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1s_BFu1i, BFs1i_BFu1s_BFu1s_BFu1i)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1s_BFu1ll()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1s_BFu1ll");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1s_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1s_BFu1ll, BFs1i_BFu1s_BFu1s_BFu1ll)
//============================================================================



static void Test_BFs1i_BFu1s_BFu1s_BFu1s()
{
  {
    init_simple_test("BFs1i_BFu1s_BFu1s_BFu1s");
    static STRUCT_IF_C BFs1i_BFu1s_BFu1s_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1i_BFu1s_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1i_BFu1s_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1i_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, 1, "BFs1i_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, 1, "BFs1i_BFu1s_BFu1s_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1i_BFu1s_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1i_BFu1s_BFu1s_BFu1s, BFs1i_BFu1s_BFu1s_BFu1s)
//============================================================================



static void Test_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c, BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1c, BFs1ll_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1c_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1c_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1c_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1c_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1c_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1c_BFs1c, BFs1ll_BFs1c_BFs1c_BFs1c)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1c_BFs1i, BFs1ll_BFs1c_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1c_BFs1ll, BFs1ll_BFs1c_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1c_BFs1s, BFs1ll_BFs1c_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1c_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1c_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1c_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1c_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1c_BFu1c, BFs1ll_BFs1c_BFs1c_BFu1c)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1c_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1c_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1c_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1c_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1c_BFu1i, BFs1ll_BFs1c_BFs1c_BFu1i)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1c_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1c_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1c_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1c_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1c_BFu1ll, BFs1ll_BFs1c_BFs1c_BFu1ll)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1c_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1c_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1c_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1c_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1c_BFu1s, BFs1ll_BFs1c_BFs1c_BFu1s)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1i, BFs1ll_BFs1c_BFs1i)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1i_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1i_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1i_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1i_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1i_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1i_BFs1c, BFs1ll_BFs1c_BFs1i_BFs1c)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1i_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1i_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1i_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1i_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1i_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1i_BFs1i, BFs1ll_BFs1c_BFs1i_BFs1i)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1i_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1i_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1i_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1i_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1i_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1i_BFs1ll, BFs1ll_BFs1c_BFs1i_BFs1ll)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1i_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1i_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1i_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1i_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1i_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1i_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1i_BFs1s, BFs1ll_BFs1c_BFs1i_BFs1s)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1i_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1i_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1i_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1i_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1i_BFu1c, BFs1ll_BFs1c_BFs1i_BFu1c)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1i_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1i_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1i_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1i_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1i_BFu1i, BFs1ll_BFs1c_BFs1i_BFu1i)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1i_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1i_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1i_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1i_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1i_BFu1ll, BFs1ll_BFs1c_BFs1i_BFu1ll)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1i_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1i_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1i_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1i_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1i_BFu1s, BFs1ll_BFs1c_BFs1i_BFu1s)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1ll, BFs1ll_BFs1c_BFs1ll)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1ll_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1ll_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1ll_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1ll_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1ll_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1ll_BFs1c, BFs1ll_BFs1c_BFs1ll_BFs1c)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1ll_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1ll_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1ll_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1ll_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1ll_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1ll_BFs1i, BFs1ll_BFs1c_BFs1ll_BFs1i)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1ll_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1ll_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1ll_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1ll_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1ll_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1ll_BFs1ll, BFs1ll_BFs1c_BFs1ll_BFs1ll)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1ll_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1ll_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1ll_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1ll_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1ll_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1ll_BFs1s, BFs1ll_BFs1c_BFs1ll_BFs1s)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1ll_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1ll_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1ll_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1ll_BFu1c, BFs1ll_BFs1c_BFs1ll_BFu1c)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1ll_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1ll_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1ll_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1ll_BFu1i, BFs1ll_BFs1c_BFs1ll_BFu1i)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1ll_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1ll_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1ll_BFu1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFu1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1ll_BFu1ll, BFs1ll_BFs1c_BFs1ll_BFu1ll)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1ll_BFu1s()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1ll_BFu1s");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1ll_BFu1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1ll_BFu1s");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1ll_BFu1s, BFs1ll_BFs1c_BFs1ll_BFu1s)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1s, BFs1ll_BFs1c_BFs1s)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1s_BFs1c()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1s_BFs1c");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1s_BFs1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1s_BFs1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1s_BFs1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1c");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1s_BFs1c, BFs1ll_BFs1c_BFs1s_BFs1c)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1s_BFs1i()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1s_BFs1i");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1s_BFs1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1s_BFs1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1s_BFs1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1i");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1s_BFs1i, BFs1ll_BFs1c_BFs1s_BFs1i)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1s_BFs1ll()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1s_BFs1ll");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1s_BFs1ll lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1s_BFs1ll)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1s_BFs1ll)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1ll");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1s_BFs1ll, BFs1ll_BFs1c_BFs1s_BFs1ll)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1s_BFs1s()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1s_BFs1s");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1s_BFs1s lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1s_BFs1s)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1s_BFs1s)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1s");
    set_bf_and_test(lv, v4, 0, 3, 1, -1, "BFs1ll_BFs1c_BFs1s_BFs1s");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1s_BFs1s, BFs1ll_BFs1c_BFs1s_BFs1s)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1s_BFu1c()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1s_BFu1c");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1s_BFu1c lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1s_BFu1c");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1s_BFu1c, BFs1ll_BFs1c_BFs1s_BFu1c)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1s_BFu1i()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1s_BFu1i");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1s_BFu1i lv;
    check2(sizeof(lv), 1, "sizeof(BFs1ll_BFs1c_BFs1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(BFs1ll_BFs1c_BFs1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 1, -1, "BFs1ll_BFs1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v2, 0, 1, 1, -1, "BFs1ll_BFs1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v3, 0, 2, 1, -1, "BFs1ll_BFs1c_BFs1s_BFu1i");
    set_bf_and_test(lv, v4, 0, 3, 1, 1, "BFs1ll_BFs1c_BFs1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_BFs1ll_BFs1c_BFs1s_BFu1i, BFs1ll_BFs1c_BFs1s_BFu1i)
//============================================================================



static void Test_BFs1ll_BFs1c_BFs1s_BFu1ll()
{
  {
    init_simple_test("BFs1ll_BFs1c_BFs1s_BFu1ll");
    static STRUCT_IF_C BFs1ll_BFs1c_BFs1s_BFu1ll