// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
struct __attribute__((packed)) aVp_BFu32ll_BFu7i { void * v1; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu32ll_BFu7ll { void * v1; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu32ll_BFu7s { void * v1; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu32ll_BFu8c { void * v1; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu32ll_BFu8i { void * v1; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu32ll_BFu8ll { void * v1; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu32ll_BFu8s { void * v1; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu32ll_BFu9i { void * v1; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu32ll_BFu9ll { void * v1; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu32ll_BFu9s { void * v1; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu32ll_C { void * v1; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aVp_BFu32ll_D { void * v1; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aVp_BFu32ll_F { void * v1; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aVp_BFu32ll_I { void * v1; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aVp_BFu32ll_Ip { void * v1; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aVp_BFu32ll_L { void * v1; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aVp_BFu32ll_S { void * v1; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aVp_BFu32ll_Uc { void * v1; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu32ll_Ui { void * v1; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu32ll_Ul { void * v1; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu32ll_Us { void * v1; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu32ll_Vp { void * v1; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aVp_BFu33 { void * v1; unsigned long long v2:33; };
struct __attribute__((packed)) aVp_BFu33_BFu15i { void * v1; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu33_BFu15ll { void * v1; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu33_BFu15s { void * v1; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu33_BFu16i { void * v1; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu33_BFu16ll { void * v1; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu33_BFu16s { void * v1; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu33_BFu17i { void * v1; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu33_BFu17ll { void * v1; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu33_BFu1c { void * v1; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu33_BFu1i { void * v1; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu33_BFu1ll { void * v1; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu33_BFu1s { void * v1; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu33_BFu31i { void * v1; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu33_BFu31ll { void * v1; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu33_BFu32i { void * v1; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu33_BFu32ll { void * v1; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu33_BFu33 { void * v1; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu33_BFu7c { void * v1; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu33_BFu7i { void * v1; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu33_BFu7ll { void * v1; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu33_BFu7s { void * v1; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu33_BFu8c { void * v1; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu33_BFu8i { void * v1; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu33_BFu8ll { void * v1; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu33_BFu8s { void * v1; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu33_BFu9i { void * v1; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu33_BFu9ll { void * v1; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu33_BFu9s { void * v1; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu33_C { void * v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aVp_BFu33_D { void * v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aVp_BFu33_F { void * v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aVp_BFu33_I { void * v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aVp_BFu33_Ip { void * v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aVp_BFu33_L { void * v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aVp_BFu33_S { void * v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aVp_BFu33_Uc { void * v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu33_Ui { void * v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu33_Ul { void * v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu33_Us { void * v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu33_Vp { void * v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aVp_BFu7c { void * v1; unsigned char v2:7; };
struct __attribute__((packed)) aVp_BFu7c_BFu15i { void * v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu7c_BFu15ll { void * v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu7c_BFu15s { void * v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu7c_BFu16i { void * v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu7c_BFu16ll { void * v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu7c_BFu16s { void * v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu7c_BFu17i { void * v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu7c_BFu17ll { void * v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu7c_BFu1c { void * v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu7c_BFu1i { void * v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu7c_BFu1ll { void * v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu7c_BFu1s { void * v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu7c_BFu31i { void * v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu7c_BFu31ll { void * v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu7c_BFu32i { void * v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu7c_BFu32ll { void * v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu7c_BFu33 { void * v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu7c_BFu7c { void * v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu7c_BFu7i { void * v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu7c_BFu7ll { void * v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu7c_BFu7s { void * v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu7c_BFu8c { void * v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu7c_BFu8i { void * v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu7c_BFu8ll { void * v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu7c_BFu8s { void * v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu7c_BFu9i { void * v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu7c_BFu9ll { void * v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu7c_BFu9s { void * v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu7c_C { void * v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aVp_BFu7c_D { void * v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aVp_BFu7c_F { void * v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aVp_BFu7c_I { void * v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aVp_BFu7c_Ip { void * v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aVp_BFu7c_L { void * v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aVp_BFu7c_S { void * v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aVp_BFu7c_Uc { void * v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu7c_Ui { void * v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu7c_Ul { void * v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu7c_Us { void * v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu7c_Vp { void * v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aVp_BFu7i { void * v1; unsigned int v2:7; };
struct __attribute__((packed)) aVp_BFu7i_BFu15i { void * v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu7i_BFu15ll { void * v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu7i_BFu15s { void * v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu7i_BFu16i { void * v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu7i_BFu16ll { void * v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu7i_BFu16s { void * v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu7i_BFu17i { void * v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu7i_BFu17ll { void * v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu7i_BFu1c { void * v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu7i_BFu1i { void * v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu7i_BFu1ll { void * v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu7i_BFu1s { void * v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu7i_BFu31i { void * v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu7i_BFu31ll { void * v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu7i_BFu32i { void * v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu7i_BFu32ll { void * v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu7i_BFu33 { void * v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu7i_BFu7c { void * v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu7i_BFu7i { void * v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu7i_BFu7ll { void * v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu7i_BFu7s { void * v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu7i_BFu8c { void * v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu7i_BFu8i { void * v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu7i_BFu8ll { void * v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu7i_BFu8s { void * v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu7i_BFu9i { void * v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu7i_BFu9ll { void * v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu7i_BFu9s { void * v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu7i_C { void * v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aVp_BFu7i_D { void * v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aVp_BFu7i_F { void * v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aVp_BFu7i_I { void * v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aVp_BFu7i_Ip { void * v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aVp_BFu7i_L { void * v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aVp_BFu7i_S { void * v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aVp_BFu7i_Uc { void * v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu7i_Ui { void * v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu7i_Ul { void * v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu7i_Us { void * v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu7i_Vp { void * v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aVp_BFu7ll { void * v1; unsigned long long v2:7; };
struct __attribute__((packed)) aVp_BFu7ll_BFu15i { void * v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu7ll_BFu15ll { void * v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu7ll_BFu15s { void * v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu7ll_BFu16i { void * v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu7ll_BFu16ll { void * v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu7ll_BFu16s { void * v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu7ll_BFu17i { void * v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu7ll_BFu17ll { void * v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu7ll_BFu1c { void * v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu7ll_BFu1i { void * v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu7ll_BFu1ll { void * v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu7ll_BFu1s { void * v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu7ll_BFu31i { void * v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu7ll_BFu31ll { void * v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu7ll_BFu32i { void * v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu7ll_BFu32ll { void * v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu7ll_BFu33 { void * v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu7ll_BFu7c { void * v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu7ll_BFu7i { void * v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu7ll_BFu7ll { void * v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu7ll_BFu7s { void * v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu7ll_BFu8c { void * v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu7ll_BFu8i { void * v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu7ll_BFu8ll { void * v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu7ll_BFu8s { void * v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu7ll_BFu9i { void * v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu7ll_BFu9ll { void * v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu7ll_BFu9s { void * v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu7ll_C { void * v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aVp_BFu7ll_D { void * v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aVp_BFu7ll_F { void * v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aVp_BFu7ll_I { void * v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aVp_BFu7ll_Ip { void * v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aVp_BFu7ll_L { void * v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aVp_BFu7ll_S { void * v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aVp_BFu7ll_Uc { void * v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu7ll_Ui { void * v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu7ll_Ul { void * v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu7ll_Us { void * v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu7ll_Vp { void * v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aVp_BFu7s { void * v1; unsigned short v2:7; };
struct __attribute__((packed)) aVp_BFu7s_BFu15i { void * v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu7s_BFu15ll { void * v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu7s_BFu15s { void * v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu7s_BFu16i { void * v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu7s_BFu16ll { void * v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu7s_BFu16s { void * v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu7s_BFu17i { void * v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu7s_BFu17ll { void * v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu7s_BFu1c { void * v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu7s_BFu1i { void * v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu7s_BFu1ll { void * v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu7s_BFu1s { void * v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu7s_BFu31i { void * v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu7s_BFu31ll { void * v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu7s_BFu32i { void * v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu7s_BFu32ll { void * v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu7s_BFu33 { void * v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu7s_BFu7c { void * v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu7s_BFu7i { void * v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu7s_BFu7ll { void * v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu7s_BFu7s { void * v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu7s_BFu8c { void * v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu7s_BFu8i { void * v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu7s_BFu8ll { void * v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu7s_BFu8s { void * v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu7s_BFu9i { void * v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu7s_BFu9ll { void * v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu7s_BFu9s { void * v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu7s_C { void * v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aVp_BFu7s_D { void * v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aVp_BFu7s_F { void * v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aVp_BFu7s_I { void * v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aVp_BFu7s_Ip { void * v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aVp_BFu7s_L { void * v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aVp_BFu7s_S { void * v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aVp_BFu7s_Uc { void * v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu7s_Ui { void * v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu7s_Ul { void * v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu7s_Us { void * v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu7s_Vp { void * v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aVp_BFu8c { void * v1; unsigned char v2:8; };
struct __attribute__((packed)) aVp_BFu8c_BFu15i { void * v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu8c_BFu15ll { void * v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu8c_BFu15s { void * v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu8c_BFu16i { void * v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu8c_BFu16ll { void * v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu8c_BFu16s { void * v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu8c_BFu17i { void * v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu8c_BFu17ll { void * v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu8c_BFu1c { void * v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu8c_BFu1i { void * v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu8c_BFu1ll { void * v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu8c_BFu1s { void * v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu8c_BFu31i { void * v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu8c_BFu31ll { void * v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu8c_BFu32i { void * v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu8c_BFu32ll { void * v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu8c_BFu33 { void * v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu8c_BFu7c { void * v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu8c_BFu7i { void * v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu8c_BFu7ll { void * v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu8c_BFu7s { void * v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu8c_BFu8c { void * v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu8c_BFu8i { void * v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu8c_BFu8ll { void * v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu8c_BFu8s { void * v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu8c_BFu9i { void * v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu8c_BFu9ll { void * v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu8c_BFu9s { void * v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu8c_C { void * v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aVp_BFu8c_D { void * v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aVp_BFu8c_F { void * v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aVp_BFu8c_I { void * v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aVp_BFu8c_Ip { void * v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aVp_BFu8c_L { void * v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aVp_BFu8c_S { void * v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aVp_BFu8c_Uc { void * v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu8c_Ui { void * v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu8c_Ul { void * v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu8c_Us { void * v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu8c_Vp { void * v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aVp_BFu8i { void * v1; unsigned int v2:8; };
struct __attribute__((packed)) aVp_BFu8i_BFu15i { void * v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu8i_BFu15ll { void * v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu8i_BFu15s { void * v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu8i_BFu16i { void * v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu8i_BFu16ll { void * v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu8i_BFu16s { void * v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu8i_BFu17i { void * v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu8i_BFu17ll { void * v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu8i_BFu1c { void * v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu8i_BFu1i { void * v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu8i_BFu1ll { void * v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu8i_BFu1s { void * v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu8i_BFu31i { void * v1; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu8i_BFu31ll { void * v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu8i_BFu32i { void * v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu8i_BFu32ll { void * v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu8i_BFu33 { void * v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu8i_BFu7c { void * v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu8i_BFu7i { void * v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu8i_BFu7ll { void * v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu8i_BFu7s { void * v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu8i_BFu8c { void * v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu8i_BFu8i { void * v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu8i_BFu8ll { void * v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu8i_BFu8s { void * v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu8i_BFu9i { void * v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu8i_BFu9ll { void * v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu8i_BFu9s { void * v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu8i_C { void * v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aVp_BFu8i_D { void * v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aVp_BFu8i_F { void * v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aVp_BFu8i_I { void * v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aVp_BFu8i_Ip { void * v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aVp_BFu8i_L { void * v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aVp_BFu8i_S { void * v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aVp_BFu8i_Uc { void * v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu8i_Ui { void * v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu8i_Ul { void * v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu8i_Us { void * v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu8i_Vp { void * v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aVp_BFu8ll { void * v1; unsigned long long v2:8; };
struct __attribute__((packed)) aVp_BFu8ll_BFu15i { void * v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu8ll_BFu15ll { void * v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu8ll_BFu15s { void * v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu8ll_BFu16i { void * v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu8ll_BFu16ll { void * v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu8ll_BFu16s { void * v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu8ll_BFu17i { void * v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu8ll_BFu17ll { void * v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu8ll_BFu1c { void * v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu8ll_BFu1i { void * v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu8ll_BFu1ll { void * v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu8ll_BFu1s { void * v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu8ll_BFu31i { void * v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu8ll_BFu31ll { void * v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu8ll_BFu32i { void * v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu8ll_BFu32ll { void * v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu8ll_BFu33 { void * v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu8ll_BFu7c { void * v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu8ll_BFu7i { void * v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu8ll_BFu7ll { void * v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu8ll_BFu7s { void * v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu8ll_BFu8c { void * v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu8ll_BFu8i { void * v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu8ll_BFu8ll { void * v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu8ll_BFu8s { void * v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu8ll_BFu9i { void * v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu8ll_BFu9ll { void * v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu8ll_BFu9s { void * v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu8ll_C { void * v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aVp_BFu8ll_D { void * v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aVp_BFu8ll_F { void * v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aVp_BFu8ll_I { void * v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aVp_BFu8ll_Ip { void * v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aVp_BFu8ll_L { void * v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aVp_BFu8ll_S { void * v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aVp_BFu8ll_Uc { void * v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu8ll_Ui { void * v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu8ll_Ul { void * v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu8ll_Us { void * v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu8ll_Vp { void * v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aVp_BFu8s { void * v1; unsigned short v2:8; };
struct __attribute__((packed)) aVp_BFu8s_BFu15i { void * v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu8s_BFu15ll { void * v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu8s_BFu15s { void * v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu8s_BFu16i { void * v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu8s_BFu16ll { void * v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu8s_BFu16s { void * v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu8s_BFu17i { void * v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu8s_BFu17ll { void * v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu8s_BFu1c { void * v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu8s_BFu1i { void * v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu8s_BFu1ll { void * v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu8s_BFu1s { void * v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu8s_BFu31i { void * v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu8s_BFu31ll { void * v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu8s_BFu32i { void * v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu8s_BFu32ll { void * v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu8s_BFu33 { void * v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu8s_BFu7c { void * v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu8s_BFu7i { void * v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu8s_BFu7ll { void * v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu8s_BFu7s { void * v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu8s_BFu8c { void * v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu8s_BFu8i { void * v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu8s_BFu8ll { void * v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu8s_BFu8s { void * v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu8s_BFu9i { void * v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu8s_BFu9ll { void * v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu8s_BFu9s { void * v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu8s_C { void * v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aVp_BFu8s_D { void * v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aVp_BFu8s_F { void * v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aVp_BFu8s_I { void * v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aVp_BFu8s_Ip { void * v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aVp_BFu8s_L { void * v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aVp_BFu8s_S { void * v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aVp_BFu8s_Uc { void * v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu8s_Ui { void * v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu8s_Ul { void * v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu8s_Us { void * v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu8s_Vp { void * v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aVp_BFu9i { void * v1; unsigned int v2:9; };
struct __attribute__((packed)) aVp_BFu9i_BFu15i { void * v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu9i_BFu15ll { void * v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu9i_BFu15s { void * v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu9i_BFu16i { void * v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu9i_BFu16ll { void * v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu9i_BFu16s { void * v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu9i_BFu17i { void * v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu9i_BFu17ll { void * v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu9i_BFu1c { void * v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu9i_BFu1i { void * v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu9i_BFu1ll { void * v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu9i_BFu1s { void * v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu9i_BFu31i { void * v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu9i_BFu31ll { void * v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu9i_BFu32i { void * v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu9i_BFu32ll { void * v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu9i_BFu33 { void * v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu9i_BFu7c { void * v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu9i_BFu7i { void * v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu9i_BFu7ll { void * v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu9i_BFu7s { void * v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu9i_BFu8c { void * v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu9i_BFu8i { void * v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu9i_BFu8ll { void * v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu9i_BFu8s { void * v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu9i_BFu9i { void * v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu9i_BFu9ll { void * v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu9i_BFu9s { void * v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu9i_C { void * v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aVp_BFu9i_D { void * v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aVp_BFu9i_F { void * v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aVp_BFu9i_I { void * v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aVp_BFu9i_Ip { void * v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aVp_BFu9i_L { void * v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aVp_BFu9i_S { void * v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aVp_BFu9i_Uc { void * v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu9i_Ui { void * v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu9i_Ul { void * v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu9i_Us { void * v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu9i_Vp { void * v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aVp_BFu9ll { void * v1; unsigned long long v2:9; };
struct __attribute__((packed)) aVp_BFu9ll_BFu15i { void * v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu9ll_BFu15ll { void * v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu9ll_BFu15s { void * v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu9ll_BFu16i { void * v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu9ll_BFu16ll { void * v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu9ll_BFu16s { void * v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu9ll_BFu17i { void * v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu9ll_BFu17ll { void * v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu9ll_BFu1c { void * v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu9ll_BFu1i { void * v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu9ll_BFu1ll { void * v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu9ll_BFu1s { void * v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu9ll_BFu31i { void * v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu9ll_BFu31ll { void * v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu9ll_BFu32i { void * v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu9ll_BFu32ll { void * v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu9ll_BFu33 { void * v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu9ll_BFu7c { void * v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu9ll_BFu7i { void * v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu9ll_BFu7ll { void * v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu9ll_BFu7s { void * v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu9ll_BFu8c { void * v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu9ll_BFu8i { void * v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu9ll_BFu8ll { void * v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu9ll_BFu8s { void * v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu9ll_BFu9i { void * v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu9ll_BFu9ll { void * v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu9ll_BFu9s { void * v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu9ll_C { void * v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aVp_BFu9ll_D { void * v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aVp_BFu9ll_F { void * v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aVp_BFu9ll_I { void * v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aVp_BFu9ll_Ip { void * v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aVp_BFu9ll_L { void * v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aVp_BFu9ll_S { void * v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aVp_BFu9ll_Uc { void * v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu9ll_Ui { void * v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu9ll_Ul { void * v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu9ll_Us { void * v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu9ll_Vp { void * v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aVp_BFu9s { void * v1; unsigned short v2:9; };
struct __attribute__((packed)) aVp_BFu9s_BFu15i { void * v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu9s_BFu15ll { void * v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu9s_BFu15s { void * v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu9s_BFu16i { void * v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu9s_BFu16ll { void * v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu9s_BFu16s { void * v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu9s_BFu17i { void * v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu9s_BFu17ll { void * v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu9s_BFu1c { void * v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu9s_BFu1i { void * v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu9s_BFu1ll { void * v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu9s_BFu1s { void * v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu9s_BFu31i { void * v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu9s_BFu31ll { void * v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu9s_BFu32i { void * v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu9s_BFu32ll { void * v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu9s_BFu33 { void * v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu9s_BFu7c { void * v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu9s_BFu7i { void * v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu9s_BFu7ll { void * v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu9s_BFu7s { void * v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu9s_BFu8c { void * v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu9s_BFu8i { void * v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu9s_BFu8ll { void * v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu9s_BFu8s { void * v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu9s_BFu9i { void * v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu9s_BFu9ll { void * v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu9s_BFu9s { void * v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu9s_C { void * v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aVp_BFu9s_D { void * v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aVp_BFu9s_F { void * v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aVp_BFu9s_I { void * v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aVp_BFu9s_Ip { void * v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aVp_BFu9s_L { void * v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aVp_BFu9s_S { void * v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aVp_BFu9s_Uc { void * v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu9s_Ui { void * v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu9s_Ul { void * v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu9s_Us { void * v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu9s_Vp { void * v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aVp_C { void * v1; char v2; };
struct __attribute__((packed)) aVp_C_BFu15i { void * v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_C_BFu15ll { void * v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_C_BFu15s { void * v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_C_BFu16i { void * v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_C_BFu16ll { void * v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_C_BFu16s { void * v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_C_BFu17i { void * v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_C_BFu17ll { void * v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_C_BFu1c { void * v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_C_BFu1i { void * v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_C_BFu1ll { void * v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_C_BFu1s { void * v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_C_BFu31i { void * v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_C_BFu31ll { void * v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_C_BFu32i { void * v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_C_BFu32ll { void * v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_C_BFu33 { void * v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_C_BFu7c { void * v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_C_BFu7i { void * v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_C_BFu7ll { void * v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_C_BFu7s { void * v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_C_BFu8c { void * v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_C_BFu8i { void * v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_C_BFu8ll { void * v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_C_BFu8s { void * v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_C_BFu9i { void * v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_C_BFu9ll { void * v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_C_BFu9s { void * v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_C_C { void * v1; char v2; char v3; };
struct __attribute__((packed)) aVp_C_D { void * v1; char v2; double v3; };
struct __attribute__((packed)) aVp_C_F { void * v1; char v2; float v3; };
struct __attribute__((packed)) aVp_C_I { void * v1; char v2; int v3; };
struct __attribute__((packed)) aVp_C_Ip { void * v1; char v2; int * v3; };
struct __attribute__((packed)) aVp_C_L { void * v1; char v2; long long v3; };
struct __attribute__((packed)) aVp_C_S { void * v1; char v2; short v3; };
struct __attribute__((packed)) aVp_C_Uc { void * v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aVp_C_Ui { void * v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aVp_C_Ul { void * v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_C_Us { void * v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aVp_C_Vp { void * v1; char v2; void * v3; };
struct __attribute__((packed)) aVp_D { void * v1; double v2; };
struct __attribute__((packed)) aVp_D_BFu15i { void * v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_D_BFu15ll { void * v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_D_BFu15s { void * v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_D_BFu16i { void * v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_D_BFu16ll { void * v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_D_BFu16s { void * v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_D_BFu17i { void * v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_D_BFu17ll { void * v1; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_D_BFu1c { void * v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_D_BFu1i { void * v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_D_BFu1ll { void * v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_D_BFu1s { void * v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_D_BFu31i { void * v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_D_BFu31ll { void * v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_D_BFu32i { void * v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_D_BFu32ll { void * v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_D_BFu33 { void * v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_D_BFu7c { void * v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_D_BFu7i { void * v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_D_BFu7ll { void * v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_D_BFu7s { void * v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_D_BFu8c { void * v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_D_BFu8i { void * v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_D_BFu8ll { void * v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_D_BFu8s { void * v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_D_BFu9i { void * v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_D_BFu9ll { void * v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_D_BFu9s { void * v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_D_C { void * v1; double v2; char v3; };
struct __attribute__((packed)) aVp_D_D { void * v1; double v2; double v3; };
struct __attribute__((packed)) aVp_D_F { void * v1; double v2; float v3; };
struct __attribute__((packed)) aVp_D_I { void * v1; double v2; int v3; };
struct __attribute__((packed)) aVp_D_Ip { void * v1; double v2; int * v3; };
struct __attribute__((packed)) aVp_D_L { void * v1; double v2; long long v3; };
struct __attribute__((packed)) aVp_D_S { void * v1; double v2; short v3; };
struct __attribute__((packed)) aVp_D_Uc { void * v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aVp_D_Ui { void * v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aVp_D_Ul { void * v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_D_Us { void * v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aVp_D_Vp { void * v1; double v2; void * v3; };
struct __attribute__((packed)) aVp_F { void * v1; float v2; };
struct __attribute__((packed)) aVp_F_BFu15i { void * v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_F_BFu15ll { void * v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_F_BFu15s { void * v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_F_BFu16i { void * v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_F_BFu16ll { void * v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_F_BFu16s { void * v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_F_BFu17i { void * v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_F_BFu17ll { void * v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_F_BFu1c { void * v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_F_BFu1i { void * v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_F_BFu1ll { void * v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_F_BFu1s { void * v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_F_BFu31i { void * v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_F_BFu31ll { void * v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_F_BFu32i { void * v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_F_BFu32ll { void * v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_F_BFu33 { void * v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_F_BFu7c { void * v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_F_BFu7i { void * v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_F_BFu7ll { void * v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_F_BFu7s { void * v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_F_BFu8c { void * v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_F_BFu8i { void * v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_F_BFu8ll { void * v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_F_BFu8s { void * v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_F_BFu9i { void * v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_F_BFu9ll { void * v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_F_BFu9s { void * v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_F_C { void * v1; float v2; char v3; };
struct __attribute__((packed)) aVp_F_D { void * v1; float v2; double v3; };
struct __attribute__((packed)) aVp_F_F { void * v1; float v2; float v3; };
struct __attribute__((packed)) aVp_F_I { void * v1; float v2; int v3; };
struct __attribute__((packed)) aVp_F_Ip { void * v1; float v2; int * v3; };
struct __attribute__((packed)) aVp_F_L { void * v1; float v2; long long v3; };
struct __attribute__((packed)) aVp_F_S { void * v1; float v2; short v3; };
struct __attribute__((packed)) aVp_F_Uc { void * v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aVp_F_Ui { void * v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aVp_F_Ul { void * v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_F_Us { void * v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aVp_F_Vp { void * v1; float v2; void * v3; };
struct __attribute__((packed)) aVp_I { void * v1; int v2; };
struct __attribute__((packed)) aVp_I_BFu15i { void * v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_I_BFu15ll { void * v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_I_BFu15s { void * v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_I_BFu16i { void * v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_I_BFu16ll { void * v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_I_BFu16s { void * v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_I_BFu17i { void * v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_I_BFu17ll { void * v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_I_BFu1c { void * v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_I_BFu1i { void * v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_I_BFu1ll { void * v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_I_BFu1s { void * v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_I_BFu31i { void * v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_I_BFu31ll { void * v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_I_BFu32i { void * v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_I_BFu32ll { void * v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_I_BFu33 { void * v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_I_BFu7c { void * v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_I_BFu7i { void * v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_I_BFu7ll { void * v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_I_BFu7s { void * v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_I_BFu8c { void * v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_I_BFu8i { void * v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_I_BFu8ll { void * v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_I_BFu8s { void * v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_I_BFu9i { void * v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_I_BFu9ll { void * v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_I_BFu9s { void * v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_I_C { void * v1; int v2; char v3; };
struct __attribute__((packed)) aVp_I_D { void * v1; int v2; double v3; };
struct __attribute__((packed)) aVp_I_F { void * v1; int v2; float v3; };
struct __attribute__((packed)) aVp_I_I { void * v1; int v2; int v3; };
struct __attribute__((packed)) aVp_I_Ip { void * v1; int v2; int * v3; };
struct __attribute__((packed)) aVp_I_L { void * v1; int v2; long long v3; };
struct __attribute__((packed)) aVp_I_S { void * v1; int v2; short v3; };
struct __attribute__((packed)) aVp_I_Uc { void * v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aVp_I_Ui { void * v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aVp_I_Ul { void * v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_I_Us { void * v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aVp_I_Vp { void * v1; int v2; void * v3; };
struct __attribute__((packed)) aVp_Ip { void * v1; int * v2; };
struct __attribute__((packed)) aVp_Ip_BFu15i { void * v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_Ip_BFu15ll { void * v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_Ip_BFu15s { void * v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_Ip_BFu16i { void * v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_Ip_BFu16ll { void * v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_Ip_BFu16s { void * v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_Ip_BFu17i { void * v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_Ip_BFu17ll { void * v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_Ip_BFu1c { void * v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_Ip_BFu1i { void * v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_Ip_BFu1ll { void * v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_Ip_BFu1s { void * v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_Ip_BFu31i { void * v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_Ip_BFu31ll { void * v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_Ip_BFu32i { void * v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_Ip_BFu32ll { void * v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_Ip_BFu33 { void * v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_Ip_BFu7c { void * v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_Ip_BFu7i { void * v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_Ip_BFu7ll { void * v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_Ip_BFu7s { void * v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_Ip_BFu8c { void * v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_Ip_BFu8i { void * v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_Ip_BFu8ll { void * v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_Ip_BFu8s { void * v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_Ip_BFu9i { void * v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_Ip_BFu9ll { void * v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_Ip_BFu9s { void * v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_Ip_C { void * v1; int * v2; char v3; };
struct __attribute__((packed)) aVp_Ip_D { void * v1; int * v2; double v3; };
struct __attribute__((packed)) aVp_Ip_F { void * v1; int * v2; float v3; };
struct __attribute__((packed)) aVp_Ip_I { void * v1; int * v2; int v3; };
struct __attribute__((packed)) aVp_Ip_Ip { void * v1; int * v2; int * v3; };
struct __attribute__((packed)) aVp_Ip_L { void * v1; int * v2; long long v3; };
struct __attribute__((packed)) aVp_Ip_S { void * v1; int * v2; short v3; };
struct __attribute__((packed)) aVp_Ip_Uc { void * v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aVp_Ip_Ui { void * v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aVp_Ip_Ul { void * v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_Ip_Us { void * v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aVp_Ip_Vp { void * v1; int * v2; void * v3; };
struct __attribute__((packed)) aVp_L { void * v1; long long v2; };
struct __attribute__((packed)) aVp_L_BFu15i { void * v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_L_BFu15ll { void * v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_L_BFu15s { void * v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_L_BFu16i { void * v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_L_BFu16ll { void * v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_L_BFu16s { void * v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_L_BFu17i { void * v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_L_BFu17ll { void * v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_L_BFu1c { void * v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_L_BFu1i { void * v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_L_BFu1ll { void * v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_L_BFu1s { void * v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_L_BFu31i { void * v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_L_BFu31ll { void * v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_L_BFu32i { void * v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_L_BFu32ll { void * v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_L_BFu33 { void * v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_L_BFu7c { void * v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_L_BFu7i { void * v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_L_BFu7ll { void * v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_L_BFu7s { void * v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_L_BFu8c { void * v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_L_BFu8i { void * v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_L_BFu8ll { void * v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_L_BFu8s { void * v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_L_BFu9i { void * v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_L_BFu9ll { void * v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_L_BFu9s { void * v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_L_C { void * v1; long long v2; char v3; };
struct __attribute__((packed)) aVp_L_D { void * v1; long long v2; double v3; };
struct __attribute__((packed)) aVp_L_F { void * v1; long long v2; float v3; };
struct __attribute__((packed)) aVp_L_I { void * v1; long long v2; int v3; };
struct __attribute__((packed)) aVp_L_Ip { void * v1; long long v2; int * v3; };
struct __attribute__((packed)) aVp_L_L { void * v1; long long v2; long long v3; };
struct __attribute__((packed)) aVp_L_S { void * v1; long long v2; short v3; };
struct __attribute__((packed)) aVp_L_Uc { void * v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aVp_L_Ui { void * v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aVp_L_Ul { void * v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_L_Us { void * v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aVp_L_Vp { void * v1; long long v2; void * v3; };
struct __attribute__((packed)) aVp_S { void * v1; short v2; };
struct __attribute__((packed)) aVp_S_BFu15i { void * v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_S_BFu15ll { void * v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_S_BFu15s { void * v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_S_BFu16i { void * v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_S_BFu16ll { void * v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_S_BFu16s { void * v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_S_BFu17i { void * v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_S_BFu17ll { void * v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_S_BFu1c { void * v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_S_BFu1i { void * v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_S_BFu1ll { void * v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_S_BFu1s { void * v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_S_BFu31i { void * v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_S_BFu31ll { void * v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_S_BFu32i { void * v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_S_BFu32ll { void * v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_S_BFu33 { void * v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_S_BFu7c { void * v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_S_BFu7i { void * v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_S_BFu7ll { void * v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_S_BFu7s { void * v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_S_BFu8c { void * v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_S_BFu8i { void * v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_S_BFu8ll { void * v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_S_BFu8s { void * v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_S_BFu9i { void * v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_S_BFu9ll { void * v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_S_BFu9s { void * v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_S_C { void * v1; short v2; char v3; };
struct __attribute__((packed)) aVp_S_D { void * v1; short v2; double v3; };
struct __attribute__((packed)) aVp_S_F { void * v1; short v2; float v3; };
struct __attribute__((packed)) aVp_S_I { void * v1; short v2; int v3; };
struct __attribute__((packed)) aVp_S_Ip { void * v1; short v2; int * v3; };
struct __attribute__((packed)) aVp_S_L { void * v1; short v2; long long v3; };
struct __attribute__((packed)) aVp_S_S { void * v1; short v2; short v3; };
struct __attribute__((packed)) aVp_S_Uc { void * v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aVp_S_Ui { void * v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aVp_S_Ul { void * v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_S_Us { void * v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aVp_S_Vp { void * v1; short v2; void * v3; };
struct __attribute__((packed)) aVp_Uc { void * v1; unsigned char v2; };
struct __attribute__((packed)) aVp_Uc_BFu15i { void * v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_Uc_BFu15ll { void * v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_Uc_BFu15s { void * v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_Uc_BFu16i { void * v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_Uc_BFu16ll { void * v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_Uc_BFu16s { void * v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_Uc_BFu17i { void * v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_Uc_BFu17ll { void * v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_Uc_BFu1c { void * v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_Uc_BFu1i { void * v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_Uc_BFu1ll { void * v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_Uc_BFu1s { void * v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_Uc_BFu31i { void * v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_Uc_BFu31ll { void * v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_Uc_BFu32i { void * v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_Uc_BFu32ll { void * v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_Uc_BFu33 { void * v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_Uc_BFu7c { void * v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_Uc_BFu7i { void * v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_Uc_BFu7ll { void * v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_Uc_BFu7s { void * v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_Uc_BFu8c { void * v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_Uc_BFu8i { void * v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_Uc_BFu8ll { void * v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_Uc_BFu8s { void * v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_Uc_BFu9i { void * v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_Uc_BFu9ll { void * v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_Uc_BFu9s { void * v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_Uc_C { void * v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aVp_Uc_D { void * v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aVp_Uc_F { void * v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aVp_Uc_I { void * v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aVp_Uc_Ip { void * v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aVp_Uc_L { void * v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aVp_Uc_S { void * v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aVp_Uc_Uc { void * v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aVp_Uc_Ui { void * v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aVp_Uc_Ul { void * v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_Uc_Us { void * v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aVp_Uc_Vp { void * v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aVp_Ui { void * v1; unsigned int v2; };
struct __attribute__((packed)) aVp_Ui_BFu15i { void * v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_Ui_BFu15ll { void * v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_Ui_BFu15s { void * v1; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_Ui_BFu16i { void * v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_Ui_BFu16ll { void * v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_Ui_BFu16s { void * v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_Ui_BFu17i { void * v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_Ui_BFu17ll { void * v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_Ui_BFu1c { void * v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_Ui_BFu1i { void * v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_Ui_BFu1ll { void * v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_Ui_BFu1s { void * v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_Ui_BFu31i { void * v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_Ui_BFu31ll { void * v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_Ui_BFu32i { void * v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_Ui_BFu32ll { void * v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_Ui_BFu33 { void * v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_Ui_BFu7c { void * v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_Ui_BFu7i { void * v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_Ui_BFu7ll { void * v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_Ui_BFu7s { void * v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_Ui_BFu8c { void * v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_Ui_BFu8i { void * v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_Ui_BFu8ll { void * v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_Ui_BFu8s { void * v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_Ui_BFu9i { void * v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_Ui_BFu9ll { void * v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_Ui_BFu9s { void * v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_Ui_C { void * v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aVp_Ui_D { void * v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aVp_Ui_F { void * v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aVp_Ui_I { void * v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aVp_Ui_Ip { void * v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aVp_Ui_L { void * v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aVp_Ui_S { void * v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aVp_Ui_Uc { void * v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aVp_Ui_Ui { void * v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aVp_Ui_Ul { void * v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_Ui_Us { void * v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aVp_Ui_Vp { void * v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aVp_Ul { void * v1; unsigned long long v2; };
struct __attribute__((packed)) aVp_Ul_BFu15i { void * v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_Ul_BFu15ll { void * v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_Ul_BFu15s { void * v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_Ul_BFu16i { void * v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_Ul_BFu16ll { void * v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_Ul_BFu16s { void * v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_Ul_BFu17i { void * v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_Ul_BFu17ll { void * v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_Ul_BFu1c { void * v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_Ul_BFu1i { void * v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_Ul_BFu1ll { void * v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_Ul_BFu1s { void * v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_Ul_BFu31i { void * v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_Ul_BFu31ll { void * v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_Ul_BFu32i { void * v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_Ul_BFu32ll { void * v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_Ul_BFu33 { void * v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_Ul_BFu7c { void * v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_Ul_BFu7i { void * v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_Ul_BFu7ll { void * v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_Ul_BFu7s { void * v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_Ul_BFu8c { void * v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_Ul_BFu8i { void * v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_Ul_BFu8ll { void * v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_Ul_BFu8s { void * v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_Ul_BFu9i { void * v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_Ul_BFu9ll { void * v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_Ul_BFu9s { void * v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_Ul_C { void * v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aVp_Ul_D { void * v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aVp_Ul_F { void * v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aVp_Ul_I { void * v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aVp_Ul_Ip { void * v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aVp_Ul_L { void * v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aVp_Ul_S { void * v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aVp_Ul_Uc { void * v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aVp_Ul_Ui { void * v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aVp_Ul_Ul { void * v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_Ul_Us { void * v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aVp_Ul_Vp { void * v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aVp_Us { void * v1; unsigned short v2; };
struct __attribute__((packed)) aVp_Us_BFu15i { void * v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_Us_BFu15ll { void * v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_Us_BFu15s { void * v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_Us_BFu16i { void * v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_Us_BFu16ll { void * v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_Us_BFu16s { void * v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_Us_BFu17i { void * v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_Us_BFu17ll { void * v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_Us_BFu1c { void * v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_Us_BFu1i { void * v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_Us_BFu1ll { void * v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_Us_BFu1s { void * v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_Us_BFu31i { void * v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_Us_BFu31ll { void * v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_Us_BFu32i { void * v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_Us_BFu32ll { void * v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_Us_BFu33 { void * v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_Us_BFu7c { void * v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_Us_BFu7i { void * v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_Us_BFu7ll { void * v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_Us_BFu7s { void * v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_Us_BFu8c { void * v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_Us_BFu8i { void * v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_Us_BFu8ll { void * v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_Us_BFu8s { void * v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_Us_BFu9i { void * v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_Us_BFu9ll { void * v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_Us_BFu9s { void * v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_Us_C { void * v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aVp_Us_D { void * v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aVp_Us_F { void * v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aVp_Us_I { void * v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aVp_Us_Ip { void * v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aVp_Us_L { void * v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aVp_Us_S { void * v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aVp_Us_Uc { void * v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aVp_Us_Ui { void * v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aVp_Us_Ul { void * v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_Us_Us { void * v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aVp_Us_Vp { void * v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aVp_Vp { void * v1; void * v2; };
struct __attribute__((packed)) aVp_Vp_BFu15i { void * v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aVp_Vp_BFu15ll { void * v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_Vp_BFu15s { void * v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aVp_Vp_BFu16i { void * v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aVp_Vp_BFu16ll { void * v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_Vp_BFu16s { void * v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aVp_Vp_BFu17i { void * v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aVp_Vp_BFu17ll { void * v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_Vp_BFu1c { void * v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aVp_Vp_BFu1i { void * v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aVp_Vp_BFu1ll { void * v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_Vp_BFu1s { void * v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aVp_Vp_BFu31i { void * v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aVp_Vp_BFu31ll { void * v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_Vp_BFu32i { void * v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aVp_Vp_BFu32ll { void * v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_Vp_BFu33 { void * v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_Vp_BFu7c { void * v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aVp_Vp_BFu7i { void * v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aVp_Vp_BFu7ll { void * v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_Vp_BFu7s { void * v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aVp_Vp_BFu8c { void * v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aVp_Vp_BFu8i { void * v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aVp_Vp_BFu8ll { void * v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_Vp_BFu8s { void * v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aVp_Vp_BFu9i { void * v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aVp_Vp_BFu9ll { void * v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_Vp_BFu9s { void * v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aVp_Vp_C { void * v1; void * v2; char v3; };
struct __attribute__((packed)) aVp_Vp_D { void * v1; void * v2; double v3; };
struct __attribute__((packed)) aVp_Vp_F { void * v1; void * v2; float v3; };
struct __attribute__((packed)) aVp_Vp_I { void * v1; void * v2; int v3; };
struct __attribute__((packed)) aVp_Vp_Ip { void * v1; void * v2; int * v3; };
struct __attribute__((packed)) aVp_Vp_L { void * v1; void * v2; long long v3; };
struct __attribute__((packed)) aVp_Vp_S { void * v1; void * v2; short v3; };
struct __attribute__((packed)) aVp_Vp_Uc { void * v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aVp_Vp_Ui { void * v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aVp_Vp_Ul { void * v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aVp_Vp_Us { void * v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aVp_Vp_Vp { void * v1; void * v2; void * v3; };
#pragma pack(1)
struct BFs15i_BFs15i { signed int v1:15; signed int v2:15; };
struct BFs15i_BFs15i_BFs15i { signed int v1:15; signed int v2:15; signed int v3:15; };
struct BFs15i_BFs15i_BFs15i_BFs15i { signed int v1:15; signed int v2:15; signed int v3:15; signed int v4:15; };
struct BFs15i_BFs15i_BFs15i_BFs15ll { signed int v1:15; signed int v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15i_BFs15i_BFs15i_BFs15s { signed int v1:15; signed int v2:15; signed int v3:15; signed short v4:15; };
struct BFs15i_BFs15i_BFs15i_BFu15i { signed int v1:15; signed int v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15i_BFs15i_BFs15i_BFu15ll { signed int v1:15; signed int v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15i_BFs15i_BFu15s { signed int v1:15; signed int v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15i_BFs15i_BFs15ll { signed int v1:15; signed int v2:15; signed long long v3:15; };
struct BFs15i_BFs15i_BFs15ll_BFs15i { signed int v1:15; signed int v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15i_BFs15i_BFs15ll_BFs15ll { signed int v1:15; signed int v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15i_BFs15i_BFs15ll_BFs15s { signed int v1:15; signed int v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15i_BFs15i_BFs15ll_BFu15i { signed int v1:15; signed int v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15i_BFs15i_BFs15ll_BFu15ll { signed int v1:15; signed int v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15i_BFs15ll_BFu15s { signed int v1:15; signed int v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15i_BFs15i_BFs15s { signed int v1:15; signed int v2:15; signed short v3:15; };
struct BFs15i_BFs15i_BFs15s_BFs15i { signed int v1:15; signed int v2:15; signed short v3:15; signed int v4:15; };
struct BFs15i_BFs15i_BFs15s_BFs15ll { signed int v1:15; signed int v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15i_BFs15i_BFs15s_BFs15s { signed int v1:15; signed int v2:15; signed short v3:15; signed short v4:15; };
struct BFs15i_BFs15i_BFs15s_BFu15i { signed int v1:15; signed int v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15i_BFs15i_BFs15s_BFu15ll { signed int v1:15; signed int v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15i_BFs15s_BFu15s { signed int v1:15; signed int v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15i_BFs15i_BFu15i { signed int v1:15; signed int v2:15; unsigned int v3:15; };
struct BFs15i_BFs15i_BFu15i_BFs15i { signed int v1:15; signed int v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15i_BFs15i_BFu15i_BFs15ll { signed int v1:15; signed int v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15i_BFs15i_BFu15i_BFs15s { signed int v1:15; signed int v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15i_BFs15i_BFu15i_BFu15i { signed int v1:15; signed int v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15i_BFs15i_BFu15i_BFu15ll { signed int v1:15; signed int v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15i_BFu15i_BFu15s { signed int v1:15; signed int v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15i_BFs15i_BFu15ll { signed int v1:15; signed int v2:15; unsigned long long v3:15; };
struct BFs15i_BFs15i_BFu15ll_BFs15i { signed int v1:15; signed int v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15i_BFs15i_BFu15ll_BFs15ll { signed int v1:15; signed int v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15i_BFs15i_BFu15ll_BFs15s { signed int v1:15; signed int v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15i_BFs15i_BFu15ll_BFu15i { signed int v1:15; signed int v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15i_BFs15i_BFu15ll_BFu15ll { signed int v1:15; signed int v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15i_BFu15ll_BFu15s { signed int v1:15; signed int v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15i_BFs15i_BFu15s { signed int v1:15; signed int v2:15; unsigned short v3:15; };
struct BFs15i_BFs15i_BFu15s_BFs15i { signed int v1:15; signed int v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15i_BFs15i_BFu15s_BFs15ll { signed int v1:15; signed int v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15i_BFs15i_BFu15s_BFs15s { signed int v1:15; signed int v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15i_BFs15i_BFu15s_BFu15i { signed int v1:15; signed int v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15i_BFs15i_BFu15s_BFu15ll { signed int v1:15; signed int v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15i_BFu15s_BFu15s { signed int v1:15; signed int v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15i_BFs15ll { signed int v1:15; signed long long v2:15; };
struct BFs15i_BFs15ll_BFs15i { signed int v1:15; signed long long v2:15; signed int v3:15; };
struct BFs15i_BFs15ll_BFs15i_BFs15i { signed int v1:15; signed long long v2:15; signed int v3:15; signed int v4:15; };
struct BFs15i_BFs15ll_BFs15i_BFs15ll { signed int v1:15; signed long long v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15i_BFs15ll_BFs15i_BFs15s { signed int v1:15; signed long long v2:15; signed int v3:15; signed short v4:15; };
struct BFs15i_BFs15ll_BFs15i_BFu15i { signed int v1:15; signed long long v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15i_BFs15ll_BFs15i_BFu15ll { signed int v1:15; signed long long v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15ll_BFs15i_BFu15s { signed int v1:15; signed long long v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15i_BFs15ll_BFs15ll { signed int v1:15; signed long long v2:15; signed long long v3:15; };
struct BFs15i_BFs15ll_BFs15ll_BFs15i { signed int v1:15; signed long long v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15i_BFs15ll_BFs15ll_BFs15ll { signed int v1:15; signed long long v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15i_BFs15ll_BFs15ll_BFs15s { signed int v1:15; signed long long v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15i_BFs15ll_BFs15ll_BFu15i { signed int v1:15; signed long long v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15i_BFs15ll_BFs15ll_BFu15ll { signed int v1:15; signed long long v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15ll_BFs15ll_BFu15s { signed int v1:15; signed long long v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15i_BFs15ll_BFs15s { signed int v1:15; signed long long v2:15; signed short v3:15; };
struct BFs15i_BFs15ll_BFs15s_BFs15i { signed int v1:15; signed long long v2:15; signed short v3:15; signed int v4:15; };
struct BFs15i_BFs15ll_BFs15s_BFs15ll { signed int v1:15; signed long long v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15i_BFs15ll_BFs15s_BFs15s { signed int v1:15; signed long long v2:15; signed short v3:15; signed short v4:15; };
struct BFs15i_BFs15ll_BFs15s_BFu15i { signed int v1:15; signed long long v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15i_BFs15ll_BFs15s_BFu15ll { signed int v1:15; signed long long v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15ll_BFs15s_BFu15s { signed int v1:15; signed long long v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15i_BFs15ll_BFu15i { signed int v1:15; signed long long v2:15; unsigned int v3:15; };
struct BFs15i_BFs15ll_BFu15i_BFs15i { signed int v1:15; signed long long v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15i_BFs15ll_BFu15i_BFs15ll { signed int v1:15; signed long long v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15i_BFs15ll_BFu15i_BFs15s { signed int v1:15; signed long long v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15i_BFs15ll_BFu15i_BFu15i { signed int v1:15; signed long long v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15i_BFs15ll_BFu15i_BFu15ll { signed int v1:15; signed long long v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15ll_BFu15i_BFu15s { signed int v1:15; signed long long v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15i_BFs15ll_BFu15ll { signed int v1:15; signed long long v2:15; unsigned long long v3:15; };
struct BFs15i_BFs15ll_BFu15ll_BFs15i { signed int v1:15; signed long long v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15i_BFs15ll_BFu15ll_BFs15ll { signed int v1:15; signed long long v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15i_BFs15ll_BFu15ll_BFs15s { signed int v1:15; signed long long v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15i_BFs15ll_BFu15ll_BFu15i { signed int v1:15; signed long long v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15i_BFs15ll_BFu15ll_BFu15ll { signed int v1:15; signed long long v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15ll_BFu15ll_BFu15s { signed int v1:15; signed long long v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15i_BFs15ll_BFu15s { signed int v1:15; signed long long v2:15; unsigned short v3:15; };
struct BFs15i_BFs15ll_BFu15s_BFs15i { signed int v1:15; signed long long v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15i_BFs15ll_BFu15s_BFs15ll { signed int v1:15; signed long long v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15i_BFs15ll_BFu15s_BFs15s { signed int v1:15; signed long long v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15i_BFs15ll_BFu15s_BFu15i { signed int v1:15; signed long long v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15i_BFs15ll_BFu15s_BFu15ll { signed int v1:15; signed long long v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15ll_BFu15s_BFu15s { signed int v1:15; signed long long v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15i_BFs15s { signed int v1:15; signed short v2:15; };
struct BFs15i_BFs15s_BFs15i { signed int v1:15; signed short v2:15; signed int v3:15; };
struct BFs15i_BFs15s_BFs15i_BFs15i { signed int v1:15; signed short v2:15; signed int v3:15; signed int v4:15; };
struct BFs15i_BFs15s_BFs15i_BFs15ll { signed int v1:15; signed short v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15i_BFs15s_BFs15i_BFs15s { signed int v1:15; signed short v2:15; signed int v3:15; signed short v4:15; };
struct BFs15i_BFs15s_BFs15i_BFu15i { signed int v1:15; signed short v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15i_BFs15s_BFs15i_BFu15ll { signed int v1:15; signed short v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15s_BFs15i_BFu15s { signed int v1:15; signed short v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15i_BFs15s_BFs15ll { signed int v1:15; signed short v2:15; signed long long v3:15; };
struct BFs15i_BFs15s_BFs15ll_BFs15i { signed int v1:15; signed short v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15i_BFs15s_BFs15ll_BFs15ll { signed int v1:15; signed short v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15i_BFs15s_BFs15ll_BFs15s { signed int v1:15; signed short v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15i_BFs15s_BFs15ll_BFu15i { signed int v1:15; signed short v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15i_BFs15s_BFs15ll_BFu15ll { signed int v1:15; signed short v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15s_BFs15ll_BFu15s { signed int v1:15; signed short v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15i_BFs15s_BFs15s { signed int v1:15; signed short v2:15; signed short v3:15; };
struct BFs15i_BFs15s_BFs15s_BFs15i { signed int v1:15; signed short v2:15; signed short v3:15; signed int v4:15; };
struct BFs15i_BFs15s_BFs15s_BFs15ll { signed int v1:15; signed short v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15i_BFs15s_BFs15s_BFs15s { signed int v1:15; signed short v2:15; signed short v3:15; signed short v4:15; };
struct BFs15i_BFs15s_BFs15s_BFu15i { signed int v1:15; signed short v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15i_BFs15s_BFs15s_BFu15ll { signed int v1:15; signed short v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15s_BFs15s_BFu15s { signed int v1:15; signed short v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15i_BFs15s_BFu15i { signed int v1:15; signed short v2:15; unsigned int v3:15; };
struct BFs15i_BFs15s_BFu15i_BFs15i { signed int v1:15; signed short v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15i_BFs15s_BFu15i_BFs15ll { signed int v1:15; signed short v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15i_BFs15s_BFu15i_BFs15s { signed int v1:15; signed short v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15i_BFs15s_BFu15i_BFu15i { signed int v1:15; signed short v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15i_BFs15s_BFu15i_BFu15ll { signed int v1:15; signed short v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15s_BFu15i_BFu15s { signed int v1:15; signed short v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15i_BFs15s_BFu15ll { signed int v1:15; signed short v2:15; unsigned long long v3:15; };
struct BFs15i_BFs15s_BFu15ll_BFs15i { signed int v1:15; signed short v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15i_BFs15s_BFu15ll_BFs15ll { signed int v1:15; signed short v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15i_BFs15s_BFu15ll_BFs15s { signed int v1:15; signed short v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15i_BFs15s_BFu15ll_BFu15i { signed int v1:15; signed short v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15i_BFs15s_BFu15ll_BFu15ll { signed int v1:15; signed short v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15s_BFu15ll_BFu15s { signed int v1:15; signed short v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15i_BFs15s_BFu15s { signed int v1:15; signed short v2:15; unsigned short v3:15; };
struct BFs15i_BFs15s_BFu15s_BFs15i { signed int v1:15; signed short v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15i_BFs15s_BFu15s_BFs15ll { signed int v1:15; signed short v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15i_BFs15s_BFu15s_BFs15s { signed int v1:15; signed short v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15i_BFs15s_BFu15s_BFu15i { signed int v1:15; signed short v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15i_BFs15s_BFu15s_BFu15ll { signed int v1:15; signed short v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15i_BFs15s_BFu15s_BFu15s { signed int v1:15; signed short v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15i_BFu15i { signed int v1:15; unsigned int v2:15; };
struct BFs15i_BFu15i_BFs15i { signed int v1:15; unsigned int v2:15; signed int v3:15; };
struct BFs15i_BFu15i_BFs15i_BFs15i { signed int v1:15; unsigned int v2:15; signed int v3:15; signed int v4:15; };
struct BFs15i_BFu15i_BFs15i_BFs15ll { signed int v1:15; unsigned int v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15i_BFu15i_BFs15i_BFs15s { signed int v1:15; unsigned int v2:15; signed int v3:15; signed short v4:15; };
struct BFs15i_BFu15i_BFs15i_BFu15i { signed int v1:15; unsigned int v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15i_BFu15i_BFs15i_BFu15ll { signed int v1:15; unsigned int v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15i_BFs15i_BFu15s { signed int v1:15; unsigned int v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15i_BFu15i_BFs15ll { signed int v1:15; unsigned int v2:15; signed long long v3:15; };
struct BFs15i_BFu15i_BFs15ll_BFs15i { signed int v1:15; unsigned int v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15i_BFu15i_BFs15ll_BFs15ll { signed int v1:15; unsigned int v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15i_BFu15i_BFs15ll_BFs15s { signed int v1:15; unsigned int v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15i_BFu15i_BFs15ll_BFu15i { signed int v1:15; unsigned int v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15i_BFu15i_BFs15ll_BFu15ll { signed int v1:15; unsigned int v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15i_BFs15ll_BFu15s { signed int v1:15; unsigned int v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15i_BFu15i_BFs15s { signed int v1:15; unsigned int v2:15; signed short v3:15; };
struct BFs15i_BFu15i_BFs15s_BFs15i { signed int v1:15; unsigned int v2:15; signed short v3:15; signed int v4:15; };
struct BFs15i_BFu15i_BFs15s_BFs15ll { signed int v1:15; unsigned int v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15i_BFu15i_BFs15s_BFs15s { signed int v1:15; unsigned int v2:15; signed short v3:15; signed short v4:15; };
struct BFs15i_BFu15i_BFs15s_BFu15i { signed int v1:15; unsigned int v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15i_BFu15i_BFs15s_BFu15ll { signed int v1:15; unsigned int v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15i_BFs15s_BFu15s { signed int v1:15; unsigned int v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15i_BFu15i_BFu15i { signed int v1:15; unsigned int v2:15; unsigned int v3:15; };
struct BFs15i_BFu15i_BFu15i_BFs15i { signed int v1:15; unsigned int v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15i_BFu15i_BFu15i_BFs15ll { signed int v1:15; unsigned int v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15i_BFu15i_BFu15i_BFs15s { signed int v1:15; unsigned int v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15i_BFu15i_BFu15i_BFu15i { signed int v1:15; unsigned int v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15i_BFu15i_BFu15i_BFu15ll { signed int v1:15; unsigned int v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15i_BFu15i_BFu15s { signed int v1:15; unsigned int v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15i_BFu15i_BFu15ll { signed int v1:15; unsigned int v2:15; unsigned long long v3:15; };
struct BFs15i_BFu15i_BFu15ll_BFs15i { signed int v1:15; unsigned int v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15i_BFu15i_BFu15ll_BFs15ll { signed int v1:15; unsigned int v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15i_BFu15i_BFu15ll_BFs15s { signed int v1:15; unsigned int v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15i_BFu15i_BFu15ll_BFu15i { signed int v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15i_BFu15i_BFu15ll_BFu15ll { signed int v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15i_BFu15ll_BFu15s { signed int v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15i_BFu15i_BFu15s { signed int v1:15; unsigned int v2:15; unsigned short v3:15; };
struct BFs15i_BFu15i_BFu15s_BFs15i { signed int v1:15; unsigned int v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15i_BFu15i_BFu15s_BFs15ll { signed int v1:15; unsigned int v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15i_BFu15i_BFu15s_BFs15s { signed int v1:15; unsigned int v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15i_BFu15i_BFu15s_BFu15i { signed int v1:15; unsigned int v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15i_BFu15i_BFu15s_BFu15ll { signed int v1:15; unsigned int v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15i_BFu15s_BFu15s { signed int v1:15; unsigned int v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15i_BFu15ll { signed int v1:15; unsigned long long v2:15; };
struct BFs15i_BFu15ll_BFs15i { signed int v1:15; unsigned long long v2:15; signed int v3:15; };
struct BFs15i_BFu15ll_BFs15i_BFs15i { signed int v1:15; unsigned long long v2:15; signed int v3:15; signed int v4:15; };
struct BFs15i_BFu15ll_BFs15i_BFs15ll { signed int v1:15; unsigned long long v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15i_BFu15ll_BFs15i_BFs15s { signed int v1:15; unsigned long long v2:15; signed int v3:15; signed short v4:15; };
struct BFs15i_BFu15ll_BFs15i_BFu15i { signed int v1:15; unsigned long long v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15i_BFu15ll_BFs15i_BFu15ll { signed int v1:15; unsigned long long v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15ll_BFs15i_BFu15s { signed int v1:15; unsigned long long v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15i_BFu15ll_BFs15ll { signed int v1:15; unsigned long long v2:15; signed long long v3:15; };
struct BFs15i_BFu15ll_BFs15ll_BFs15i { signed int v1:15; unsigned long long v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15i_BFu15ll_BFs15ll_BFs15ll { signed int v1:15; unsigned long long v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15i_BFu15ll_BFs15ll_BFs15s { signed int v1:15; unsigned long long v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15i_BFu15ll_BFs15ll_BFu15i { signed int v1:15; unsigned long long v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15i_BFu15ll_BFs15ll_BFu15ll { signed int v1:15; unsigned long long v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15ll_BFs15ll_BFu15s { signed int v1:15; unsigned long long v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15i_BFu15ll_BFs15s { signed int v1:15; unsigned long long v2:15; signed short v3:15; };
struct BFs15i_BFu15ll_BFs15s_BFs15i { signed int v1:15; unsigned long long v2:15; signed short v3:15; signed int v4:15; };
struct BFs15i_BFu15ll_BFs15s_BFs15ll { signed int v1:15; unsigned long long v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15i_BFu15ll_BFs15s_BFs15s { signed int v1:15; unsigned long long v2:15; signed short v3:15; signed short v4:15; };
struct BFs15i_BFu15ll_BFs15s_BFu15i { signed int v1:15; unsigned long long v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15i_BFu15ll_BFs15s_BFu15ll { signed int v1:15; unsigned long long v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15ll_BFs15s_BFu15s { signed int v1:15; unsigned long long v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15i_BFu15ll_BFu15i { signed int v1:15; unsigned long long v2:15; unsigned int v3:15; };
struct BFs15i_BFu15ll_BFu15i_BFs15i { signed int v1:15; unsigned long long v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15i_BFu15ll_BFu15i_BFs15ll { signed int v1:15; unsigned long long v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15i_BFu15ll_BFu15i_BFs15s { signed int v1:15; unsigned long long v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15i_BFu15ll_BFu15i_BFu15i { signed int v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15i_BFu15ll_BFu15i_BFu15ll { signed int v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15ll_BFu15i_BFu15s { signed int v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15i_BFu15ll_BFu15ll { signed int v1:15; unsigned long long v2:15; unsigned long long v3:15; };
struct BFs15i_BFu15ll_BFu15ll_BFs15i { signed int v1:15; unsigned long long v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15i_BFu15ll_BFu15ll_BFs15ll { signed int v1:15; unsigned long long v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15i_BFu15ll_BFu15ll_BFs15s { signed int v1:15; unsigned long long v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15i_BFu15ll_BFu15ll_BFu15i { signed int v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15i_BFu15ll_BFu15ll_BFu15ll { signed int v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15ll_BFu15ll_BFu15s { signed int v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15i_BFu15ll_BFu15s { signed int v1:15; unsigned long long v2:15; unsigned short v3:15; };
struct BFs15i_BFu15ll_BFu15s_BFs15i { signed int v1:15; unsigned long long v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15i_BFu15ll_BFu15s_BFs15ll { signed int v1:15; unsigned long long v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15i_BFu15ll_BFu15s_BFs15s { signed int v1:15; unsigned long long v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15i_BFu15ll_BFu15s_BFu15i { signed int v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15i_BFu15ll_BFu15s_BFu15ll { signed int v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15ll_BFu15s_BFu15s { signed int v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15i_BFu15s { signed int v1:15; unsigned short v2:15; };
struct BFs15i_BFu15s_BFs15i { signed int v1:15; unsigned short v2:15; signed int v3:15; };
struct BFs15i_BFu15s_BFs15i_BFs15i { signed int v1:15; unsigned short v2:15; signed int v3:15; signed int v4:15; };
struct BFs15i_BFu15s_BFs15i_BFs15ll { signed int v1:15; unsigned short v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15i_BFu15s_BFs15i_BFs15s { signed int v1:15; unsigned short v2:15; signed int v3:15; signed short v4:15; };
struct BFs15i_BFu15s_BFs15i_BFu15i { signed int v1:15; unsigned short v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15i_BFu15s_BFs15i_BFu15ll { signed int v1:15; unsigned short v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15s_BFs15i_BFu15s { signed int v1:15; unsigned short v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15i_BFu15s_BFs15ll { signed int v1:15; unsigned short v2:15; signed long long v3:15; };
struct BFs15i_BFu15s_BFs15ll_BFs15i { signed int v1:15; unsigned short v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15i_BFu15s_BFs15ll_BFs15ll { signed int v1:15; unsigned short v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15i_BFu15s_BFs15ll_BFs15s { signed int v1:15; unsigned short v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15i_BFu15s_BFs15ll_BFu15i { signed int v1:15; unsigned short v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15i_BFu15s_BFs15ll_BFu15ll { signed int v1:15; unsigned short v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15s_BFs15ll_BFu15s { signed int v1:15; unsigned short v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15i_BFu15s_BFs15s { signed int v1:15; unsigned short v2:15; signed short v3:15; };
struct BFs15i_BFu15s_BFs15s_BFs15i { signed int v1:15; unsigned short v2:15; signed short v3:15; signed int v4:15; };
struct BFs15i_BFu15s_BFs15s_BFs15ll { signed int v1:15; unsigned short v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15i_BFu15s_BFs15s_BFs15s { signed int v1:15; unsigned short v2:15; signed short v3:15; signed short v4:15; };
struct BFs15i_BFu15s_BFs15s_BFu15i { signed int v1:15; unsigned short v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15i_BFu15s_BFs15s_BFu15ll { signed int v1:15; unsigned short v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15s_BFs15s_BFu15s { signed int v1:15; unsigned short v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15i_BFu15s_BFu15i { signed int v1:15; unsigned short v2:15; unsigned int v3:15; };
struct BFs15i_BFu15s_BFu15i_BFs15i { signed int v1:15; unsigned short v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15i_BFu15s_BFu15i_BFs15ll { signed int v1:15; unsigned short v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15i_BFu15s_BFu15i_BFs15s { signed int v1:15; unsigned short v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15i_BFu15s_BFu15i_BFu15i { signed int v1:15; unsigned short v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15i_BFu15s_BFu15i_BFu15ll { signed int v1:15; unsigned short v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15s_BFu15i_BFu15s { signed int v1:15; unsigned short v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15i_BFu15s_BFu15ll { signed int v1:15; unsigned short v2:15; unsigned long long v3:15; };
struct BFs15i_BFu15s_BFu15ll_BFs15i { signed int v1:15; unsigned short v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15i_BFu15s_BFu15ll_BFs15ll { signed int v1:15; unsigned short v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15i_BFu15s_BFu15ll_BFs15s { signed int v1:15; unsigned short v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15i_BFu15s_BFu15ll_BFu15i { signed int v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15i_BFu15s_BFu15ll_BFu15ll { signed int v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15s_BFu15ll_BFu15s { signed int v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15i_BFu15s_BFu15s { signed int v1:15; unsigned short v2:15; unsigned short v3:15; };
struct BFs15i_BFu15s_BFu15s_BFs15i { signed int v1:15; unsigned short v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15i_BFu15s_BFu15s_BFs15ll { signed int v1:15; unsigned short v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15i_BFu15s_BFu15s_BFs15s { signed int v1:15; unsigned short v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15i_BFu15s_BFu15s_BFu15i { signed int v1:15; unsigned short v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15i_BFu15s_BFu15s_BFu15ll { signed int v1:15; unsigned short v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15i_BFu15s_BFu15s_BFu15s { signed int v1:15; unsigned short v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15i { signed long long v1:15; signed int v2:15; };
struct BFs15ll_BFs15i_BFs15i { signed long long v1:15; signed int v2:15; signed int v3:15; };
struct BFs15ll_BFs15i_BFs15i_BFs15i { signed long long v1:15; signed int v2:15; signed int v3:15; signed int v4:15; };
struct BFs15ll_BFs15i_BFs15i_BFs15ll { signed long long v1:15; signed int v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15ll_BFs15i_BFs15i_BFs15s { signed long long v1:15; signed int v2:15; signed int v3:15; signed short v4:15; };
struct BFs15ll_BFs15i_BFs15i_BFu15i { signed long long v1:15; signed int v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15i_BFs15i_BFu15ll { signed long long v1:15; signed int v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15i_BFs15i_BFu15s { signed long long v1:15; signed int v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15i_BFs15ll { signed long long v1:15; signed int v2:15; signed long long v3:15; };
struct BFs15ll_BFs15i_BFs15ll_BFs15i { signed long long v1:15; signed int v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15ll_BFs15i_BFs15ll_BFs15ll { signed long long v1:15; signed int v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15ll_BFs15i_BFs15ll_BFs15s { signed long long v1:15; signed int v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15ll_BFs15i_BFs15ll_BFu15i { signed long long v1:15; signed int v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15i_BFs15ll_BFu15ll { signed long long v1:15; signed int v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15i_BFs15ll_BFu15s { signed long long v1:15; signed int v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15i_BFs15s { signed long long v1:15; signed int v2:15; signed short v3:15; };
struct BFs15ll_BFs15i_BFs15s_BFs15i { signed long long v1:15; signed int v2:15; signed short v3:15; signed int v4:15; };
struct BFs15ll_BFs15i_BFs15s_BFs15ll { signed long long v1:15; signed int v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15ll_BFs15i_BFs15s_BFs15s { signed long long v1:15; signed int v2:15; signed short v3:15; signed short v4:15; };
struct BFs15ll_BFs15i_BFs15s_BFu15i { signed long long v1:15; signed int v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15i_BFs15s_BFu15ll { signed long long v1:15; signed int v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15i_BFs15s_BFu15s { signed long long v1:15; signed int v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15i_BFu15i { signed long long v1:15; signed int v2:15; unsigned int v3:15; };
struct BFs15ll_BFs15i_BFu15i_BFs15i { signed long long v1:15; signed int v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15ll_BFs15i_BFu15i_BFs15ll { signed long long v1:15; signed int v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15ll_BFs15i_BFu15i_BFs15s { signed long long v1:15; signed int v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15ll_BFs15i_BFu15i_BFu15i { signed long long v1:15; signed int v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15i_BFu15i_BFu15ll { signed long long v1:15; signed int v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15i_BFu15i_BFu15s { signed long long v1:15; signed int v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15i_BFu15ll { signed long long v1:15; signed int v2:15; unsigned long long v3:15; };
struct BFs15ll_BFs15i_BFu15ll_BFs15i { signed long long v1:15; signed int v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15ll_BFs15i_BFu15ll_BFs15ll { signed long long v1:15; signed int v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15ll_BFs15i_BFu15ll_BFs15s { signed long long v1:15; signed int v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15ll_BFs15i_BFu15ll_BFu15i { signed long long v1:15; signed int v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15i_BFu15ll_BFu15ll { signed long long v1:15; signed int v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15i_BFu15ll_BFu15s { signed long long v1:15; signed int v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15i_BFu15s { signed long long v1:15; signed int v2:15; unsigned short v3:15; };
struct BFs15ll_BFs15i_BFu15s_BFs15i { signed long long v1:15; signed int v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15ll_BFs15i_BFu15s_BFs15ll { signed long long v1:15; signed int v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15ll_BFs15i_BFu15s_BFs15s { signed long long v1:15; signed int v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15ll_BFs15i_BFu15s_BFu15i { signed long long v1:15; signed int v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15i_BFu15s_BFu15ll { signed long long v1:15; signed int v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15i_BFu15s_BFu15s { signed long long v1:15; signed int v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15ll { signed long long v1:15; signed long long v2:15; };
struct BFs15ll_BFs15ll_BFs15i { signed long long v1:15; signed long long v2:15; signed int v3:15; };
struct BFs15ll_BFs15ll_BFs15i_BFs15i { signed long long v1:15; signed long long v2:15; signed int v3:15; signed int v4:15; };
struct BFs15ll_BFs15ll_BFs15i_BFs15ll { signed long long v1:15; signed long long v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15ll_BFs15ll_BFs15i_BFs15s { signed long long v1:15; signed long long v2:15; signed int v3:15; signed short v4:15; };
struct BFs15ll_BFs15ll_BFs15i_BFu15i { signed long long v1:15; signed long long v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15ll_BFs15i_BFu15ll { signed long long v1:15; signed long long v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15ll_BFs15i_BFu15s { signed long long v1:15; signed long long v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15ll_BFs15ll { signed long long v1:15; signed long long v2:15; signed long long v3:15; };
struct BFs15ll_BFs15ll_BFs15ll_BFs15i { signed long long v1:15; signed long long v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15ll_BFs15ll_BFs15ll_BFs15ll { signed long long v1:15; signed long long v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15ll_BFs15ll_BFs15ll_BFs15s { signed long long v1:15; signed long long v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15ll_BFs15ll_BFs15ll_BFu15i { signed long long v1:15; signed long long v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15ll_BFs15ll_BFu15ll { signed long long v1:15; signed long long v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15ll_BFs15ll_BFu15s { signed long long v1:15; signed long long v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15ll_BFs15s { signed long long v1:15; signed long long v2:15; signed short v3:15; };
struct BFs15ll_BFs15ll_BFs15s_BFs15i { signed long long v1:15; signed long long v2:15; signed short v3:15; signed int v4:15; };
struct BFs15ll_BFs15ll_BFs15s_BFs15ll { signed long long v1:15; signed long long v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15ll_BFs15ll_BFs15s_BFs15s { signed long long v1:15; signed long long v2:15; signed short v3:15; signed short v4:15; };
struct BFs15ll_BFs15ll_BFs15s_BFu15i { signed long long v1:15; signed long long v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15ll_BFs15s_BFu15ll { signed long long v1:15; signed long long v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15ll_BFs15s_BFu15s { signed long long v1:15; signed long long v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15ll_BFu15i { signed long long v1:15; signed long long v2:15; unsigned int v3:15; };
struct BFs15ll_BFs15ll_BFu15i_BFs15i { signed long long v1:15; signed long long v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15ll_BFs15ll_BFu15i_BFs15ll { signed long long v1:15; signed long long v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15ll_BFs15ll_BFu15i_BFs15s { signed long long v1:15; signed long long v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15ll_BFs15ll_BFu15i_BFu15i { signed long long v1:15; signed long long v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15ll_BFu15i_BFu15ll { signed long long v1:15; signed long long v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15ll_BFu15i_BFu15s { signed long long v1:15; signed long long v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15ll_BFu15ll { signed long long v1:15; signed long long v2:15; unsigned long long v3:15; };
struct BFs15ll_BFs15ll_BFu15ll_BFs15i { signed long long v1:15; signed long long v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15ll_BFs15ll_BFu15ll_BFs15ll { signed long long v1:15; signed long long v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15ll_BFs15ll_BFu15ll_BFs15s { signed long long v1:15; signed long long v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15ll_BFs15ll_BFu15ll_BFu15i { signed long long v1:15; signed long long v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15ll_BFu15ll_BFu15ll { signed long long v1:15; signed long long v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15ll_BFu15ll_BFu15s { signed long long v1:15; signed long long v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15ll_BFu15s { signed long long v1:15; signed long long v2:15; unsigned short v3:15; };
struct BFs15ll_BFs15ll_BFu15s_BFs15i { signed long long v1:15; signed long long v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15ll_BFs15ll_BFu15s_BFs15ll { signed long long v1:15; signed long long v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15ll_BFs15ll_BFu15s_BFs15s { signed long long v1:15; signed long long v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15ll_BFs15ll_BFu15s_BFu15i { signed long long v1:15; signed long long v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15ll_BFu15s_BFu15ll { signed long long v1:15; signed long long v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15ll_BFu15s_BFu15s { signed long long v1:15; signed long long v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15s { signed long long v1:15; signed short v2:15; };
struct BFs15ll_BFs15s_BFs15i { signed long long v1:15; signed short v2:15; signed int v3:15; };
struct BFs15ll_BFs15s_BFs15i_BFs15i { signed long long v1:15; signed short v2:15; signed int v3:15; signed int v4:15; };
struct BFs15ll_BFs15s_BFs15i_BFs15ll { signed long long v1:15; signed short v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15ll_BFs15s_BFs15i_BFs15s { signed long long v1:15; signed short v2:15; signed int v3:15; signed short v4:15; };
struct BFs15ll_BFs15s_BFs15i_BFu15i { signed long long v1:15; signed short v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15s_BFs15i_BFu15ll { signed long long v1:15; signed short v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15s_BFs15i_BFu15s { signed long long v1:15; signed short v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15s_BFs15ll { signed long long v1:15; signed short v2:15; signed long long v3:15; };
struct BFs15ll_BFs15s_BFs15ll_BFs15i { signed long long v1:15; signed short v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15ll_BFs15s_BFs15ll_BFs15ll { signed long long v1:15; signed short v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15ll_BFs15s_BFs15ll_BFs15s { signed long long v1:15; signed short v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15ll_BFs15s_BFs15ll_BFu15i { signed long long v1:15; signed short v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15s_BFs15ll_BFu15ll { signed long long v1:15; signed short v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15s_BFs15ll_BFu15s { signed long long v1:15; signed short v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15s_BFs15s { signed long long v1:15; signed short v2:15; signed short v3:15; };
struct BFs15ll_BFs15s_BFs15s_BFs15i { signed long long v1:15; signed short v2:15; signed short v3:15; signed int v4:15; };
struct BFs15ll_BFs15s_BFs15s_BFs15ll { signed long long v1:15; signed short v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15ll_BFs15s_BFs15s_BFs15s { signed long long v1:15; signed short v2:15; signed short v3:15; signed short v4:15; };
struct BFs15ll_BFs15s_BFs15s_BFu15i { signed long long v1:15; signed short v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15s_BFs15s_BFu15ll { signed long long v1:15; signed short v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15s_BFs15s_BFu15s { signed long long v1:15; signed short v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15s_BFu15i { signed long long v1:15; signed short v2:15; unsigned int v3:15; };
struct BFs15ll_BFs15s_BFu15i_BFs15i { signed long long v1:15; signed short v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15ll_BFs15s_BFu15i_BFs15ll { signed long long v1:15; signed short v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15ll_BFs15s_BFu15i_BFs15s { signed long long v1:15; signed short v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15ll_BFs15s_BFu15i_BFu15i { signed long long v1:15; signed short v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15s_BFu15i_BFu15ll { signed long long v1:15; signed short v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15s_BFu15i_BFu15s { signed long long v1:15; signed short v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15s_BFu15ll { signed long long v1:15; signed short v2:15; unsigned long long v3:15; };
struct BFs15ll_BFs15s_BFu15ll_BFs15i { signed long long v1:15; signed short v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15ll_BFs15s_BFu15ll_BFs15ll { signed long long v1:15; signed short v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15ll_BFs15s_BFu15ll_BFs15s { signed long long v1:15; signed short v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15ll_BFs15s_BFu15ll_BFu15i { signed long long v1:15; signed short v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15s_BFu15ll_BFu15ll { signed long long v1:15; signed short v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15s_BFu15ll_BFu15s { signed long long v1:15; signed short v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15ll_BFs15s_BFu15s { signed long long v1:15; signed short v2:15; unsigned short v3:15; };
struct BFs15ll_BFs15s_BFu15s_BFs15i { signed long long v1:15; signed short v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15ll_BFs15s_BFu15s_BFs15ll { signed long long v1:15; signed short v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15ll_BFs15s_BFu15s_BFs15s { signed long long v1:15; signed short v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15ll_BFs15s_BFu15s_BFu15i { signed long long v1:15; signed short v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15ll_BFs15s_BFu15s_BFu15ll { signed long long v1:15; signed short v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15ll_BFs15s_BFu15s_BFu15s { signed long long v1:15; signed short v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15i { signed long long v1:15; unsigned int v2:15; };
struct BFs15ll_BFu15i_BFs15i { signed long long v1:15; unsigned int v2:15; signed int v3:15; };
struct BFs15ll_BFu15i_BFs15i_BFs15i { signed long long v1:15; unsigned int v2:15; signed int v3:15; signed int v4:15; };
struct BFs15ll_BFu15i_BFs15i_BFs15ll { signed long long v1:15; unsigned int v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15ll_BFu15i_BFs15i_BFs15s { signed long long v1:15; unsigned int v2:15; signed int v3:15; signed short v4:15; };
struct BFs15ll_BFu15i_BFs15i_BFu15i { signed long long v1:15; unsigned int v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15i_BFs15i_BFu15ll { signed long long v1:15; unsigned int v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15i_BFs15i_BFu15s { signed long long v1:15; unsigned int v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15i_BFs15ll { signed long long v1:15; unsigned int v2:15; signed long long v3:15; };
struct BFs15ll_BFu15i_BFs15ll_BFs15i { signed long long v1:15; unsigned int v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15ll_BFu15i_BFs15ll_BFs15ll { signed long long v1:15; unsigned int v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15ll_BFu15i_BFs15ll_BFs15s { signed long long v1:15; unsigned int v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15ll_BFu15i_BFs15ll_BFu15i { signed long long v1:15; unsigned int v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15i_BFs15ll_BFu15ll { signed long long v1:15; unsigned int v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15i_BFs15ll_BFu15s { signed long long v1:15; unsigned int v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15i_BFs15s { signed long long v1:15; unsigned int v2:15; signed short v3:15; };
struct BFs15ll_BFu15i_BFs15s_BFs15i { signed long long v1:15; unsigned int v2:15; signed short v3:15; signed int v4:15; };
struct BFs15ll_BFu15i_BFs15s_BFs15ll { signed long long v1:15; unsigned int v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15ll_BFu15i_BFs15s_BFs15s { signed long long v1:15; unsigned int v2:15; signed short v3:15; signed short v4:15; };
struct BFs15ll_BFu15i_BFs15s_BFu15i { signed long long v1:15; unsigned int v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15i_BFs15s_BFu15ll { signed long long v1:15; unsigned int v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15i_BFs15s_BFu15s { signed long long v1:15; unsigned int v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15i_BFu15i { signed long long v1:15; unsigned int v2:15; unsigned int v3:15; };
struct BFs15ll_BFu15i_BFu15i_BFs15i { signed long long v1:15; unsigned int v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15ll_BFu15i_BFu15i_BFs15ll { signed long long v1:15; unsigned int v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15ll_BFu15i_BFu15i_BFs15s { signed long long v1:15; unsigned int v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15ll_BFu15i_BFu15i_BFu15i { signed long long v1:15; unsigned int v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15i_BFu15i_BFu15ll { signed long long v1:15; unsigned int v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15i_BFu15i_BFu15s { signed long long v1:15; unsigned int v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15i_BFu15ll { signed long long v1:15; unsigned int v2:15; unsigned long long v3:15; };
struct BFs15ll_BFu15i_BFu15ll_BFs15i { signed long long v1:15; unsigned int v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15ll_BFu15i_BFu15ll_BFs15ll { signed long long v1:15; unsigned int v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15ll_BFu15i_BFu15ll_BFs15s { signed long long v1:15; unsigned int v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15ll_BFu15i_BFu15ll_BFu15i { signed long long v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15i_BFu15ll_BFu15ll { signed long long v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15i_BFu15ll_BFu15s { signed long long v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15i_BFu15s { signed long long v1:15; unsigned int v2:15; unsigned short v3:15; };
struct BFs15ll_BFu15i_BFu15s_BFs15i { signed long long v1:15; unsigned int v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15ll_BFu15i_BFu15s_BFs15ll { signed long long v1:15; unsigned int v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15ll_BFu15i_BFu15s_BFs15s { signed long long v1:15; unsigned int v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15ll_BFu15i_BFu15s_BFu15i { signed long long v1:15; unsigned int v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15i_BFu15s_BFu15ll { signed long long v1:15; unsigned int v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15i_BFu15s_BFu15s { signed long long v1:15; unsigned int v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15ll { signed long long v1:15; unsigned long long v2:15; };
struct BFs15ll_BFu15ll_BFs15i { signed long long v1:15; unsigned long long v2:15; signed int v3:15; };
struct BFs15ll_BFu15ll_BFs15i_BFs15i { signed long long v1:15; unsigned long long v2:15; signed int v3:15; signed int v4:15; };
struct BFs15ll_BFu15ll_BFs15i_BFs15ll { signed long long v1:15; unsigned long long v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15ll_BFu15ll_BFs15i_BFs15s { signed long long v1:15; unsigned long long v2:15; signed int v3:15; signed short v4:15; };
struct BFs15ll_BFu15ll_BFs15i_BFu15i { signed long long v1:15; unsigned long long v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15ll_BFs15i_BFu15ll { signed long long v1:15; unsigned long long v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15ll_BFs15i_BFu15s { signed long long v1:15; unsigned long long v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15ll_BFs15ll { signed long long v1:15; unsigned long long v2:15; signed long long v3:15; };
struct BFs15ll_BFu15ll_BFs15ll_BFs15i { signed long long v1:15; unsigned long long v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15ll_BFu15ll_BFs15ll_BFs15ll { signed long long v1:15; unsigned long long v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15ll_BFu15ll_BFs15ll_BFs15s { signed long long v1:15; unsigned long long v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15ll_BFu15ll_BFs15ll_BFu15i { signed long long v1:15; unsigned long long v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15ll_BFs15ll_BFu15ll { signed long long v1:15; unsigned long long v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15ll_BFs15ll_BFu15s { signed long long v1:15; unsigned long long v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15ll_BFs15s { signed long long v1:15; unsigned long long v2:15; signed short v3:15; };
struct BFs15ll_BFu15ll_BFs15s_BFs15i { signed long long v1:15; unsigned long long v2:15; signed short v3:15; signed int v4:15; };
struct BFs15ll_BFu15ll_BFs15s_BFs15ll { signed long long v1:15; unsigned long long v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15ll_BFu15ll_BFs15s_BFs15s { signed long long v1:15; unsigned long long v2:15; signed short v3:15; signed short v4:15; };
struct BFs15ll_BFu15ll_BFs15s_BFu15i { signed long long v1:15; unsigned long long v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15ll_BFs15s_BFu15ll { signed long long v1:15; unsigned long long v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15ll_BFs15s_BFu15s { signed long long v1:15; unsigned long long v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15ll_BFu15i { signed long long v1:15; unsigned long long v2:15; unsigned int v3:15; };
struct BFs15ll_BFu15ll_BFu15i_BFs15i { signed long long v1:15; unsigned long long v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15ll_BFu15ll_BFu15i_BFs15ll { signed long long v1:15; unsigned long long v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15ll_BFu15ll_BFu15i_BFs15s { signed long long v1:15; unsigned long long v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15ll_BFu15ll_BFu15i_BFu15i { signed long long v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15ll_BFu15i_BFu15ll { signed long long v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15ll_BFu15i_BFu15s { signed long long v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15ll_BFu15ll { signed long long v1:15; unsigned long long v2:15; unsigned long long v3:15; };
struct BFs15ll_BFu15ll_BFu15ll_BFs15i { signed long long v1:15; unsigned long long v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15ll_BFu15ll_BFu15ll_BFs15ll { signed long long v1:15; unsigned long long v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15ll_BFu15ll_BFu15ll_BFs15s { signed long long v1:15; unsigned long long v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15ll_BFu15ll_BFu15ll_BFu15i { signed long long v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15ll_BFu15ll_BFu15ll { signed long long v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15ll_BFu15ll_BFu15s { signed long long v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15ll_BFu15s { signed long long v1:15; unsigned long long v2:15; unsigned short v3:15; };
struct BFs15ll_BFu15ll_BFu15s_BFs15i { signed long long v1:15; unsigned long long v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15ll_BFu15ll_BFu15s_BFs15ll { signed long long v1:15; unsigned long long v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15ll_BFu15ll_BFu15s_BFs15s { signed long long v1:15; unsigned long long v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15ll_BFu15ll_BFu15s_BFu15i { signed long long v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15ll_BFu15s_BFu15ll { signed long long v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15ll_BFu15s_BFu15s { signed long long v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15s { signed long long v1:15; unsigned short v2:15; };
struct BFs15ll_BFu15s_BFs15i { signed long long v1:15; unsigned short v2:15; signed int v3:15; };
struct BFs15ll_BFu15s_BFs15i_BFs15i { signed long long v1:15; unsigned short v2:15; signed int v3:15; signed int v4:15; };
struct BFs15ll_BFu15s_BFs15i_BFs15ll { signed long long v1:15; unsigned short v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15ll_BFu15s_BFs15i_BFs15s { signed long long v1:15; unsigned short v2:15; signed int v3:15; signed short v4:15; };
struct BFs15ll_BFu15s_BFs15i_BFu15i { signed long long v1:15; unsigned short v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15s_BFs15i_BFu15ll { signed long long v1:15; unsigned short v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15s_BFs15i_BFu15s { signed long long v1:15; unsigned short v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15s_BFs15ll { signed long long v1:15; unsigned short v2:15; signed long long v3:15; };
struct BFs15ll_BFu15s_BFs15ll_BFs15i { signed long long v1:15; unsigned short v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15ll_BFu15s_BFs15ll_BFs15ll { signed long long v1:15; unsigned short v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15ll_BFu15s_BFs15ll_BFs15s { signed long long v1:15; unsigned short v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15ll_BFu15s_BFs15ll_BFu15i { signed long long v1:15; unsigned short v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15s_BFs15ll_BFu15ll { signed long long v1:15; unsigned short v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15s_BFs15ll_BFu15s { signed long long v1:15; unsigned short v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15s_BFs15s { signed long long v1:15; unsigned short v2:15; signed short v3:15; };
struct BFs15ll_BFu15s_BFs15s_BFs15i { signed long long v1:15; unsigned short v2:15; signed short v3:15; signed int v4:15; };
struct BFs15ll_BFu15s_BFs15s_BFs15ll { signed long long v1:15; unsigned short v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15ll_BFu15s_BFs15s_BFs15s { signed long long v1:15; unsigned short v2:15; signed short v3:15; signed short v4:15; };
struct BFs15ll_BFu15s_BFs15s_BFu15i { signed long long v1:15; unsigned short v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15s_BFs15s_BFu15ll { signed long long v1:15; unsigned short v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15s_BFs15s_BFu15s { signed long long v1:15; unsigned short v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15s_BFu15i { signed long long v1:15; unsigned short v2:15; unsigned int v3:15; };
struct BFs15ll_BFu15s_BFu15i_BFs15i { signed long long v1:15; unsigned short v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15ll_BFu15s_BFu15i_BFs15ll { signed long long v1:15; unsigned short v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15ll_BFu15s_BFu15i_BFs15s { signed long long v1:15; unsigned short v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15ll_BFu15s_BFu15i_BFu15i { signed long long v1:15; unsigned short v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15s_BFu15i_BFu15ll { signed long long v1:15; unsigned short v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15s_BFu15i_BFu15s { signed long long v1:15; unsigned short v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15s_BFu15ll { signed long long v1:15; unsigned short v2:15; unsigned long long v3:15; };
struct BFs15ll_BFu15s_BFu15ll_BFs15i { signed long long v1:15; unsigned short v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15ll_BFu15s_BFu15ll_BFs15ll { signed long long v1:15; unsigned short v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15ll_BFu15s_BFu15ll_BFs15s { signed long long v1:15; unsigned short v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15ll_BFu15s_BFu15ll_BFu15i { signed long long v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15s_BFu15ll_BFu15ll { signed long long v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15s_BFu15ll_BFu15s { signed long long v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15ll_BFu15s_BFu15s { signed long long v1:15; unsigned short v2:15; unsigned short v3:15; };
struct BFs15ll_BFu15s_BFu15s_BFs15i { signed long long v1:15; unsigned short v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15ll_BFu15s_BFu15s_BFs15ll { signed long long v1:15; unsigned short v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15ll_BFu15s_BFu15s_BFs15s { signed long long v1:15; unsigned short v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15ll_BFu15s_BFu15s_BFu15i { signed long long v1:15; unsigned short v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15ll_BFu15s_BFu15s_BFu15ll { signed long long v1:15; unsigned short v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15ll_BFu15s_BFu15s_BFu15s { signed long long v1:15; unsigned short v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15s_BFs15i { signed short v1:15; signed int v2:15; };
struct BFs15s_BFs15i_BFs15i { signed short v1:15; signed int v2:15; signed int v3:15; };
struct BFs15s_BFs15i_BFs15i_BFs15i { signed short v1:15; signed int v2:15; signed int v3:15; signed int v4:15; };
struct BFs15s_BFs15i_BFs15i_BFs15ll { signed short v1:15; signed int v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15s_BFs15i_BFs15i_BFs15s { signed short v1:15; signed int v2:15; signed int v3:15; signed short v4:15; };
struct BFs15s_BFs15i_BFs15i_BFu15i { signed short v1:15; signed int v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15s_BFs15i_BFs15i_BFu15ll { signed short v1:15; signed int v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15i_BFs15i_BFu15s { signed short v1:15; signed int v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15s_BFs15i_BFs15ll { signed short v1:15; signed int v2:15; signed long long v3:15; };
struct BFs15s_BFs15i_BFs15ll_BFs15i { signed short v1:15; signed int v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15s_BFs15i_BFs15ll_BFs15ll { signed short v1:15; signed int v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15s_BFs15i_BFs15ll_BFs15s { signed short v1:15; signed int v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15s_BFs15i_BFs15ll_BFu15i { signed short v1:15; signed int v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15s_BFs15i_BFs15ll_BFu15ll { signed short v1:15; signed int v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15i_BFs15ll_BFu15s { signed short v1:15; signed int v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15s_BFs15i_BFs15s { signed short v1:15; signed int v2:15; signed short v3:15; };
struct BFs15s_BFs15i_BFs15s_BFs15i { signed short v1:15; signed int v2:15; signed short v3:15; signed int v4:15; };
struct BFs15s_BFs15i_BFs15s_BFs15ll { signed short v1:15; signed int v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15s_BFs15i_BFs15s_BFs15s { signed short v1:15; signed int v2:15; signed short v3:15; signed short v4:15; };
struct BFs15s_BFs15i_BFs15s_BFu15i { signed short v1:15; signed int v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15s_BFs15i_BFs15s_BFu15ll { signed short v1:15; signed int v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15i_BFs15s_BFu15s { signed short v1:15; signed int v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15s_BFs15i_BFu15i { signed short v1:15; signed int v2:15; unsigned int v3:15; };
struct BFs15s_BFs15i_BFu15i_BFs15i { signed short v1:15; signed int v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15s_BFs15i_BFu15i_BFs15ll { signed short v1:15; signed int v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15s_BFs15i_BFu15i_BFs15s { signed short v1:15; signed int v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15s_BFs15i_BFu15i_BFu15i { signed short v1:15; signed int v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15s_BFs15i_BFu15i_BFu15ll { signed short v1:15; signed int v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15i_BFu15i_BFu15s { signed short v1:15; signed int v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15s_BFs15i_BFu15ll { signed short v1:15; signed int v2:15; unsigned long long v3:15; };
struct BFs15s_BFs15i_BFu15ll_BFs15i { signed short v1:15; signed int v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15s_BFs15i_BFu15ll_BFs15ll { signed short v1:15; signed int v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15s_BFs15i_BFu15ll_BFs15s { signed short v1:15; signed int v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15s_BFs15i_BFu15ll_BFu15i { signed short v1:15; signed int v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15s_BFs15i_BFu15ll_BFu15ll { signed short v1:15; signed int v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15i_BFu15ll_BFu15s { signed short v1:15; signed int v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15s_BFs15i_BFu15s { signed short v1:15; signed int v2:15; unsigned short v3:15; };
struct BFs15s_BFs15i_BFu15s_BFs15i { signed short v1:15; signed int v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15s_BFs15i_BFu15s_BFs15ll { signed short v1:15; signed int v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15s_BFs15i_BFu15s_BFs15s { signed short v1:15; signed int v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15s_BFs15i_BFu15s_BFu15i { signed short v1:15; signed int v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15s_BFs15i_BFu15s_BFu15ll { signed short v1:15; signed int v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15i_BFu15s_BFu15s { signed short v1:15; signed int v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15s_BFs15ll { signed short v1:15; signed long long v2:15; };
struct BFs15s_BFs15ll_BFs15i { signed short v1:15; signed long long v2:15; signed int v3:15; };
struct BFs15s_BFs15ll_BFs15i_BFs15i { signed short v1:15; signed long long v2:15; signed int v3:15; signed int v4:15; };
struct BFs15s_BFs15ll_BFs15i_BFs15ll { signed short v1:15; signed long long v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15s_BFs15ll_BFs15i_BFs15s { signed short v1:15; signed long long v2:15; signed int v3:15; signed short v4:15; };
struct BFs15s_BFs15ll_BFs15i_BFu15i { signed short v1:15; signed long long v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15s_BFs15ll_BFs15i_BFu15ll { signed short v1:15; signed long long v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15ll_BFs15i_BFu15s { signed short v1:15; signed long long v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15s_BFs15ll_BFs15ll { signed short v1:15; signed long long v2:15; signed long long v3:15; };
struct BFs15s_BFs15ll_BFs15ll_BFs15i { signed short v1:15; signed long long v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15s_BFs15ll_BFs15ll_BFs15ll { signed short v1:15; signed long long v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15s_BFs15ll_BFs15ll_BFs15s { signed short v1:15; signed long long v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15s_BFs15ll_BFs15ll_BFu15i { signed short v1:15; signed long long v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15s_BFs15ll_BFs15ll_BFu15ll { signed short v1:15; signed long long v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15ll_BFs15ll_BFu15s { signed short v1:15; signed long long v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15s_BFs15ll_BFs15s { signed short v1:15; signed long long v2:15; signed short v3:15; };
struct BFs15s_BFs15ll_BFs15s_BFs15i { signed short v1:15; signed long long v2:15; signed short v3:15; signed int v4:15; };
struct BFs15s_BFs15ll_BFs15s_BFs15ll { signed short v1:15; signed long long v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15s_BFs15ll_BFs15s_BFs15s { signed short v1:15; signed long long v2:15; signed short v3:15; signed short v4:15; };
struct BFs15s_BFs15ll_BFs15s_BFu15i { signed short v1:15; signed long long v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15s_BFs15ll_BFs15s_BFu15ll { signed short v1:15; signed long long v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15ll_BFs15s_BFu15s { signed short v1:15; signed long long v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15s_BFs15ll_BFu15i { signed short v1:15; signed long long v2:15; unsigned int v3:15; };
struct BFs15s_BFs15ll_BFu15i_BFs15i { signed short v1:15; signed long long v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15s_BFs15ll_BFu15i_BFs15ll { signed short v1:15; signed long long v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15s_BFs15ll_BFu15i_BFs15s { signed short v1:15; signed long long v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15s_BFs15ll_BFu15i_BFu15i { signed short v1:15; signed long long v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15s_BFs15ll_BFu15i_BFu15ll { signed short v1:15; signed long long v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15ll_BFu15i_BFu15s { signed short v1:15; signed long long v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15s_BFs15ll_BFu15ll { signed short v1:15; signed long long v2:15; unsigned long long v3:15; };
struct BFs15s_BFs15ll_BFu15ll_BFs15i { signed short v1:15; signed long long v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15s_BFs15ll_BFu15ll_BFs15ll { signed short v1:15; signed long long v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15s_BFs15ll_BFu15ll_BFs15s { signed short v1:15; signed long long v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15s_BFs15ll_BFu15ll_BFu15i { signed short v1:15; signed long long v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15s_BFs15ll_BFu15ll_BFu15ll { signed short v1:15; signed long long v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15ll_BFu15ll_BFu15s { signed short v1:15; signed long long v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15s_BFs15ll_BFu15s { signed short v1:15; signed long long v2:15; unsigned short v3:15; };
struct BFs15s_BFs15ll_BFu15s_BFs15i { signed short v1:15; signed long long v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15s_BFs15ll_BFu15s_BFs15ll { signed short v1:15; signed long long v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15s_BFs15ll_BFu15s_BFs15s { signed short v1:15; signed long long v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15s_BFs15ll_BFu15s_BFu15i { signed short v1:15; signed long long v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15s_BFs15ll_BFu15s_BFu15ll { signed short v1:15; signed long long v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15ll_BFu15s_BFu15s { signed short v1:15; signed long long v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15s_BFs15s { signed short v1:15; signed short v2:15; };
struct BFs15s_BFs15s_BFs15i { signed short v1:15; signed short v2:15; signed int v3:15; };
struct BFs15s_BFs15s_BFs15i_BFs15i { signed short v1:15; signed short v2:15; signed int v3:15; signed int v4:15; };
struct BFs15s_BFs15s_BFs15i_BFs15ll { signed short v1:15; signed short v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15s_BFs15s_BFs15i_BFs15s { signed short v1:15; signed short v2:15; signed int v3:15; signed short v4:15; };
struct BFs15s_BFs15s_BFs15i_BFu15i { signed short v1:15; signed short v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15s_BFs15s_BFs15i_BFu15ll { signed short v1:15; signed short v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15s_BFs15i_BFu15s { signed short v1:15; signed short v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15s_BFs15s_BFs15ll { signed short v1:15; signed short v2:15; signed long long v3:15; };
struct BFs15s_BFs15s_BFs15ll_BFs15i { signed short v1:15; signed short v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15s_BFs15s_BFs15ll_BFs15ll { signed short v1:15; signed short v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15s_BFs15s_BFs15ll_BFs15s { signed short v1:15; signed short v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15s_BFs15s_BFs15ll_BFu15i { signed short v1:15; signed short v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15s_BFs15s_BFs15ll_BFu15ll { signed short v1:15; signed short v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15s_BFs15ll_BFu15s { signed short v1:15; signed short v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15s_BFs15s_BFs15s { signed short v1:15; signed short v2:15; signed short v3:15; };
struct BFs15s_BFs15s_BFs15s_BFs15i { signed short v1:15; signed short v2:15; signed short v3:15; signed int v4:15; };
struct BFs15s_BFs15s_BFs15s_BFs15ll { signed short v1:15; signed short v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15s_BFs15s_BFs15s_BFs15s { signed short v1:15; signed short v2:15; signed short v3:15; signed short v4:15; };
struct BFs15s_BFs15s_BFs15s_BFu15i { signed short v1:15; signed short v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15s_BFs15s_BFs15s_BFu15ll { signed short v1:15; signed short v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15s_BFs15s_BFu15s { signed short v1:15; signed short v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15s_BFs15s_BFu15i { signed short v1:15; signed short v2:15; unsigned int v3:15; };
struct BFs15s_BFs15s_BFu15i_BFs15i { signed short v1:15; signed short v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15s_BFs15s_BFu15i_BFs15ll { signed short v1:15; signed short v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15s_BFs15s_BFu15i_BFs15s { signed short v1:15; signed short v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15s_BFs15s_BFu15i_BFu15i { signed short v1:15; signed short v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15s_BFs15s_BFu15i_BFu15ll { signed short v1:15; signed short v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15s_BFu15i_BFu15s { signed short v1:15; signed short v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15s_BFs15s_BFu15ll { signed short v1:15; signed short v2:15; unsigned long long v3:15; };
struct BFs15s_BFs15s_BFu15ll_BFs15i { signed short v1:15; signed short v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15s_BFs15s_BFu15ll_BFs15ll { signed short v1:15; signed short v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15s_BFs15s_BFu15ll_BFs15s { signed short v1:15; signed short v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15s_BFs15s_BFu15ll_BFu15i { signed short v1:15; signed short v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15s_BFs15s_BFu15ll_BFu15ll { signed short v1:15; signed short v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15s_BFu15ll_BFu15s { signed short v1:15; signed short v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15s_BFs15s_BFu15s { signed short v1:15; signed short v2:15; unsigned short v3:15; };
struct BFs15s_BFs15s_BFu15s_BFs15i { signed short v1:15; signed short v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15s_BFs15s_BFu15s_BFs15ll { signed short v1:15; signed short v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15s_BFs15s_BFu15s_BFs15s { signed short v1:15; signed short v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15s_BFs15s_BFu15s_BFu15i { signed short v1:15; signed short v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15s_BFs15s_BFu15s_BFu15ll { signed short v1:15; signed short v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15s_BFs15s_BFu15s_BFu15s { signed short v1:15; signed short v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15s_BFu15i { signed short v1:15; unsigned int v2:15; };
struct BFs15s_BFu15i_BFs15i { signed short v1:15; unsigned int v2:15; signed int v3:15; };
struct BFs15s_BFu15i_BFs15i_BFs15i { signed short v1:15; unsigned int v2:15; signed int v3:15; signed int v4:15; };
struct BFs15s_BFu15i_BFs15i_BFs15ll { signed short v1:15; unsigned int v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15s_BFu15i_BFs15i_BFs15s { signed short v1:15; unsigned int v2:15; signed int v3:15; signed short v4:15; };
struct BFs15s_BFu15i_BFs15i_BFu15i { signed short v1:15; unsigned int v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15s_BFu15i_BFs15i_BFu15ll { signed short v1:15; unsigned int v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15i_BFs15i_BFu15s { signed short v1:15; unsigned int v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15s_BFu15i_BFs15ll { signed short v1:15; unsigned int v2:15; signed long long v3:15; };
struct BFs15s_BFu15i_BFs15ll_BFs15i { signed short v1:15; unsigned int v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15s_BFu15i_BFs15ll_BFs15ll { signed short v1:15; unsigned int v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15s_BFu15i_BFs15ll_BFs15s { signed short v1:15; unsigned int v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15s_BFu15i_BFs15ll_BFu15i { signed short v1:15; unsigned int v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15s_BFu15i_BFs15ll_BFu15ll { signed short v1:15; unsigned int v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15i_BFs15ll_BFu15s { signed short v1:15; unsigned int v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15s_BFu15i_BFs15s { signed short v1:15; unsigned int v2:15; signed short v3:15; };
struct BFs15s_BFu15i_BFs15s_BFs15i { signed short v1:15; unsigned int v2:15; signed short v3:15; signed int v4:15; };
struct BFs15s_BFu15i_BFs15s_BFs15ll { signed short v1:15; unsigned int v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15s_BFu15i_BFs15s_BFs15s { signed short v1:15; unsigned int v2:15; signed short v3:15; signed short v4:15; };
struct BFs15s_BFu15i_BFs15s_BFu15i { signed short v1:15; unsigned int v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15s_BFu15i_BFs15s_BFu15ll { signed short v1:15; unsigned int v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15i_BFs15s_BFu15s { signed short v1:15; unsigned int v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15s_BFu15i_BFu15i { signed short v1:15; unsigned int v2:15; unsigned int v3:15; };
struct BFs15s_BFu15i_BFu15i_BFs15i { signed short v1:15; unsigned int v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15s_BFu15i_BFu15i_BFs15ll { signed short v1:15; unsigned int v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15s_BFu15i_BFu15i_BFs15s { signed short v1:15; unsigned int v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15s_BFu15i_BFu15i_BFu15i { signed short v1:15; unsigned int v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15s_BFu15i_BFu15i_BFu15ll { signed short v1:15; unsigned int v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15i_BFu15i_BFu15s { signed short v1:15; unsigned int v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15s_BFu15i_BFu15ll { signed short v1:15; unsigned int v2:15; unsigned long long v3:15; };
struct BFs15s_BFu15i_BFu15ll_BFs15i { signed short v1:15; unsigned int v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15s_BFu15i_BFu15ll_BFs15ll { signed short v1:15; unsigned int v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15s_BFu15i_BFu15ll_BFs15s { signed short v1:15; unsigned int v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15s_BFu15i_BFu15ll_BFu15i { signed short v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15s_BFu15i_BFu15ll_BFu15ll { signed short v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15i_BFu15ll_BFu15s { signed short v1:15; unsigned int v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15s_BFu15i_BFu15s { signed short v1:15; unsigned int v2:15; unsigned short v3:15; };
struct BFs15s_BFu15i_BFu15s_BFs15i { signed short v1:15; unsigned int v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15s_BFu15i_BFu15s_BFs15ll { signed short v1:15; unsigned int v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15s_BFu15i_BFu15s_BFs15s { signed short v1:15; unsigned int v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15s_BFu15i_BFu15s_BFu15i { signed short v1:15; unsigned int v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15s_BFu15i_BFu15s_BFu15ll { signed short v1:15; unsigned int v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15i_BFu15s_BFu15s { signed short v1:15; unsigned int v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15s_BFu15ll { signed short v1:15; unsigned long long v2:15; };
struct BFs15s_BFu15ll_BFs15i { signed short v1:15; unsigned long long v2:15; signed int v3:15; };
struct BFs15s_BFu15ll_BFs15i_BFs15i { signed short v1:15; unsigned long long v2:15; signed int v3:15; signed int v4:15; };
struct BFs15s_BFu15ll_BFs15i_BFs15ll { signed short v1:15; unsigned long long v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15s_BFu15ll_BFs15i_BFs15s { signed short v1:15; unsigned long long v2:15; signed int v3:15; signed short v4:15; };
struct BFs15s_BFu15ll_BFs15i_BFu15i { signed short v1:15; unsigned long long v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15s_BFu15ll_BFs15i_BFu15ll { signed short v1:15; unsigned long long v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15ll_BFs15i_BFu15s { signed short v1:15; unsigned long long v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15s_BFu15ll_BFs15ll { signed short v1:15; unsigned long long v2:15; signed long long v3:15; };
struct BFs15s_BFu15ll_BFs15ll_BFs15i { signed short v1:15; unsigned long long v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15s_BFu15ll_BFs15ll_BFs15ll { signed short v1:15; unsigned long long v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15s_BFu15ll_BFs15ll_BFs15s { signed short v1:15; unsigned long long v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15s_BFu15ll_BFs15ll_BFu15i { signed short v1:15; unsigned long long v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15s_BFu15ll_BFs15ll_BFu15ll { signed short v1:15; unsigned long long v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15ll_BFs15ll_BFu15s { signed short v1:15; unsigned long long v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15s_BFu15ll_BFs15s { signed short v1:15; unsigned long long v2:15; signed short v3:15; };
struct BFs15s_BFu15ll_BFs15s_BFs15i { signed short v1:15; unsigned long long v2:15; signed short v3:15; signed int v4:15; };
struct BFs15s_BFu15ll_BFs15s_BFs15ll { signed short v1:15; unsigned long long v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15s_BFu15ll_BFs15s_BFs15s { signed short v1:15; unsigned long long v2:15; signed short v3:15; signed short v4:15; };
struct BFs15s_BFu15ll_BFs15s_BFu15i { signed short v1:15; unsigned long long v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15s_BFu15ll_BFs15s_BFu15ll { signed short v1:15; unsigned long long v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15ll_BFs15s_BFu15s { signed short v1:15; unsigned long long v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15s_BFu15ll_BFu15i { signed short v1:15; unsigned long long v2:15; unsigned int v3:15; };
struct BFs15s_BFu15ll_BFu15i_BFs15i { signed short v1:15; unsigned long long v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15s_BFu15ll_BFu15i_BFs15ll { signed short v1:15; unsigned long long v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15s_BFu15ll_BFu15i_BFs15s { signed short v1:15; unsigned long long v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15s_BFu15ll_BFu15i_BFu15i { signed short v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15s_BFu15ll_BFu15i_BFu15ll { signed short v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15ll_BFu15i_BFu15s { signed short v1:15; unsigned long long v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15s_BFu15ll_BFu15ll { signed short v1:15; unsigned long long v2:15; unsigned long long v3:15; };
struct BFs15s_BFu15ll_BFu15ll_BFs15i { signed short v1:15; unsigned long long v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15s_BFu15ll_BFu15ll_BFs15ll { signed short v1:15; unsigned long long v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15s_BFu15ll_BFu15ll_BFs15s { signed short v1:15; unsigned long long v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15s_BFu15ll_BFu15ll_BFu15i { signed short v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15s_BFu15ll_BFu15ll_BFu15ll { signed short v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15ll_BFu15ll_BFu15s { signed short v1:15; unsigned long long v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15s_BFu15ll_BFu15s { signed short v1:15; unsigned long long v2:15; unsigned short v3:15; };
struct BFs15s_BFu15ll_BFu15s_BFs15i { signed short v1:15; unsigned long long v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15s_BFu15ll_BFu15s_BFs15ll { signed short v1:15; unsigned long long v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15s_BFu15ll_BFu15s_BFs15s { signed short v1:15; unsigned long long v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15s_BFu15ll_BFu15s_BFu15i { signed short v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15s_BFu15ll_BFu15s_BFu15ll { signed short v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15ll_BFu15s_BFu15s { signed short v1:15; unsigned long long v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs15s_BFu15s { signed short v1:15; unsigned short v2:15; };
struct BFs15s_BFu15s_BFs15i { signed short v1:15; unsigned short v2:15; signed int v3:15; };
struct BFs15s_BFu15s_BFs15i_BFs15i { signed short v1:15; unsigned short v2:15; signed int v3:15; signed int v4:15; };
struct BFs15s_BFu15s_BFs15i_BFs15ll { signed short v1:15; unsigned short v2:15; signed int v3:15; signed long long v4:15; };
struct BFs15s_BFu15s_BFs15i_BFs15s { signed short v1:15; unsigned short v2:15; signed int v3:15; signed short v4:15; };
struct BFs15s_BFu15s_BFs15i_BFu15i { signed short v1:15; unsigned short v2:15; signed int v3:15; unsigned int v4:15; };
struct BFs15s_BFu15s_BFs15i_BFu15ll { signed short v1:15; unsigned short v2:15; signed int v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15s_BFs15i_BFu15s { signed short v1:15; unsigned short v2:15; signed int v3:15; unsigned short v4:15; };
struct BFs15s_BFu15s_BFs15ll { signed short v1:15; unsigned short v2:15; signed long long v3:15; };
struct BFs15s_BFu15s_BFs15ll_BFs15i { signed short v1:15; unsigned short v2:15; signed long long v3:15; signed int v4:15; };
struct BFs15s_BFu15s_BFs15ll_BFs15ll { signed short v1:15; unsigned short v2:15; signed long long v3:15; signed long long v4:15; };
struct BFs15s_BFu15s_BFs15ll_BFs15s { signed short v1:15; unsigned short v2:15; signed long long v3:15; signed short v4:15; };
struct BFs15s_BFu15s_BFs15ll_BFu15i { signed short v1:15; unsigned short v2:15; signed long long v3:15; unsigned int v4:15; };
struct BFs15s_BFu15s_BFs15ll_BFu15ll { signed short v1:15; unsigned short v2:15; signed long long v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15s_BFs15ll_BFu15s { signed short v1:15; unsigned short v2:15; signed long long v3:15; unsigned short v4:15; };
struct BFs15s_BFu15s_BFs15s { signed short v1:15; unsigned short v2:15; signed short v3:15; };
struct BFs15s_BFu15s_BFs15s_BFs15i { signed short v1:15; unsigned short v2:15; signed short v3:15; signed int v4:15; };
struct BFs15s_BFu15s_BFs15s_BFs15ll { signed short v1:15; unsigned short v2:15; signed short v3:15; signed long long v4:15; };
struct BFs15s_BFu15s_BFs15s_BFs15s { signed short v1:15; unsigned short v2:15; signed short v3:15; signed short v4:15; };
struct BFs15s_BFu15s_BFs15s_BFu15i { signed short v1:15; unsigned short v2:15; signed short v3:15; unsigned int v4:15; };
struct BFs15s_BFu15s_BFs15s_BFu15ll { signed short v1:15; unsigned short v2:15; signed short v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15s_BFs15s_BFu15s { signed short v1:15; unsigned short v2:15; signed short v3:15; unsigned short v4:15; };
struct BFs15s_BFu15s_BFu15i { signed short v1:15; unsigned short v2:15; unsigned int v3:15; };
struct BFs15s_BFu15s_BFu15i_BFs15i { signed short v1:15; unsigned short v2:15; unsigned int v3:15; signed int v4:15; };
struct BFs15s_BFu15s_BFu15i_BFs15ll { signed short v1:15; unsigned short v2:15; unsigned int v3:15; signed long long v4:15; };
struct BFs15s_BFu15s_BFu15i_BFs15s { signed short v1:15; unsigned short v2:15; unsigned int v3:15; signed short v4:15; };
struct BFs15s_BFu15s_BFu15i_BFu15i { signed short v1:15; unsigned short v2:15; unsigned int v3:15; unsigned int v4:15; };
struct BFs15s_BFu15s_BFu15i_BFu15ll { signed short v1:15; unsigned short v2:15; unsigned int v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15s_BFu15i_BFu15s { signed short v1:15; unsigned short v2:15; unsigned int v3:15; unsigned short v4:15; };
struct BFs15s_BFu15s_BFu15ll { signed short v1:15; unsigned short v2:15; unsigned long long v3:15; };
struct BFs15s_BFu15s_BFu15ll_BFs15i { signed short v1:15; unsigned short v2:15; unsigned long long v3:15; signed int v4:15; };
struct BFs15s_BFu15s_BFu15ll_BFs15ll { signed short v1:15; unsigned short v2:15; unsigned long long v3:15; signed long long v4:15; };
struct BFs15s_BFu15s_BFu15ll_BFs15s { signed short v1:15; unsigned short v2:15; unsigned long long v3:15; signed short v4:15; };
struct BFs15s_BFu15s_BFu15ll_BFu15i { signed short v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned int v4:15; };
struct BFs15s_BFu15s_BFu15ll_BFu15ll { signed short v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15s_BFu15ll_BFu15s { signed short v1:15; unsigned short v2:15; unsigned long long v3:15; unsigned short v4:15; };
struct BFs15s_BFu15s_BFu15s { signed short v1:15; unsigned short v2:15; unsigned short v3:15; };
struct BFs15s_BFu15s_BFu15s_BFs15i { signed short v1:15; unsigned short v2:15; unsigned short v3:15; signed int v4:15; };
struct BFs15s_BFu15s_BFu15s_BFs15ll { signed short v1:15; unsigned short v2:15; unsigned short v3:15; signed long long v4:15; };
struct BFs15s_BFu15s_BFu15s_BFs15s { signed short v1:15; unsigned short v2:15; unsigned short v3:15; signed short v4:15; };
struct BFs15s_BFu15s_BFu15s_BFu15i { signed short v1:15; unsigned short v2:15; unsigned short v3:15; unsigned int v4:15; };
struct BFs15s_BFu15s_BFu15s_BFu15ll { signed short v1:15; unsigned short v2:15; unsigned short v3:15; unsigned long long v4:15; };
struct BFs15s_BFu15s_BFu15s_BFu15s { signed short v1:15; unsigned short v2:15; unsigned short v3:15; unsigned short v4:15; };
struct BFs16i_BFs16i { signed int v1:16; signed int v2:16; };
struct BFs16i_BFs16i_BFs16i { signed int v1:16; signed int v2:16; signed int v3:16; };
struct BFs16i_BFs16i_BFs16i_BFs16i { signed int v1:16; signed int v2:16; signed int v3:16; signed int v4:16; };
struct BFs16i_BFs16i_BFs16i_BFs16ll { signed int v1:16; signed int v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16i_BFs16i_BFs16i_BFs16s { signed int v1:16; signed int v2:16; signed int v3:16; signed short v4:16; };
struct BFs16i_BFs16i_BFs16i_BFu16i { signed int v1:16; signed int v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16i_BFs16i_BFs16i_BFu16ll { signed int v1:16; signed int v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16i_BFs16i_BFu16s { signed int v1:16; signed int v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16i_BFs16i_BFs16ll { signed int v1:16; signed int v2:16; signed long long v3:16; };
struct BFs16i_BFs16i_BFs16ll_BFs16i { signed int v1:16; signed int v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16i_BFs16i_BFs16ll_BFs16ll { signed int v1:16; signed int v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16i_BFs16i_BFs16ll_BFs16s { signed int v1:16; signed int v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16i_BFs16i_BFs16ll_BFu16i { signed int v1:16; signed int v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16i_BFs16i_BFs16ll_BFu16ll { signed int v1:16; signed int v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16i_BFs16ll_BFu16s { signed int v1:16; signed int v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16i_BFs16i_BFs16s { signed int v1:16; signed int v2:16; signed short v3:16; };
struct BFs16i_BFs16i_BFs16s_BFs16i { signed int v1:16; signed int v2:16; signed short v3:16; signed int v4:16; };
struct BFs16i_BFs16i_BFs16s_BFs16ll { signed int v1:16; signed int v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16i_BFs16i_BFs16s_BFs16s { signed int v1:16; signed int v2:16; signed short v3:16; signed short v4:16; };
struct BFs16i_BFs16i_BFs16s_BFu16i { signed int v1:16; signed int v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16i_BFs16i_BFs16s_BFu16ll { signed int v1:16; signed int v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16i_BFs16s_BFu16s { signed int v1:16; signed int v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16i_BFs16i_BFu16i { signed int v1:16; signed int v2:16; unsigned int v3:16; };
struct BFs16i_BFs16i_BFu16i_BFs16i { signed int v1:16; signed int v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16i_BFs16i_BFu16i_BFs16ll { signed int v1:16; signed int v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16i_BFs16i_BFu16i_BFs16s { signed int v1:16; signed int v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16i_BFs16i_BFu16i_BFu16i { signed int v1:16; signed int v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16i_BFs16i_BFu16i_BFu16ll { signed int v1:16; signed int v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16i_BFu16i_BFu16s { signed int v1:16; signed int v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16i_BFs16i_BFu16ll { signed int v1:16; signed int v2:16; unsigned long long v3:16; };
struct BFs16i_BFs16i_BFu16ll_BFs16i { signed int v1:16; signed int v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16i_BFs16i_BFu16ll_BFs16ll { signed int v1:16; signed int v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16i_BFs16i_BFu16ll_BFs16s { signed int v1:16; signed int v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16i_BFs16i_BFu16ll_BFu16i { signed int v1:16; signed int v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16i_BFs16i_BFu16ll_BFu16ll { signed int v1:16; signed int v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16i_BFu16ll_BFu16s { signed int v1:16; signed int v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16i_BFs16i_BFu16s { signed int v1:16; signed int v2:16; unsigned short v3:16; };
struct BFs16i_BFs16i_BFu16s_BFs16i { signed int v1:16; signed int v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16i_BFs16i_BFu16s_BFs16ll { signed int v1:16; signed int v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16i_BFs16i_BFu16s_BFs16s { signed int v1:16; signed int v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16i_BFs16i_BFu16s_BFu16i { signed int v1:16; signed int v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16i_BFs16i_BFu16s_BFu16ll { signed int v1:16; signed int v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16i_BFu16s_BFu16s { signed int v1:16; signed int v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16i_BFs16ll { signed int v1:16; signed long long v2:16; };
struct BFs16i_BFs16ll_BFs16i { signed int v1:16; signed long long v2:16; signed int v3:16; };
struct BFs16i_BFs16ll_BFs16i_BFs16i { signed int v1:16; signed long long v2:16; signed int v3:16; signed int v4:16; };
struct BFs16i_BFs16ll_BFs16i_BFs16ll { signed int v1:16; signed long long v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16i_BFs16ll_BFs16i_BFs16s { signed int v1:16; signed long long v2:16; signed int v3:16; signed short v4:16; };
struct BFs16i_BFs16ll_BFs16i_BFu16i { signed int v1:16; signed long long v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16i_BFs16ll_BFs16i_BFu16ll { signed int v1:16; signed long long v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16ll_BFs16i_BFu16s { signed int v1:16; signed long long v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16i_BFs16ll_BFs16ll { signed int v1:16; signed long long v2:16; signed long long v3:16; };
struct BFs16i_BFs16ll_BFs16ll_BFs16i { signed int v1:16; signed long long v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16i_BFs16ll_BFs16ll_BFs16ll { signed int v1:16; signed long long v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16i_BFs16ll_BFs16ll_BFs16s { signed int v1:16; signed long long v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16i_BFs16ll_BFs16ll_BFu16i { signed int v1:16; signed long long v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16i_BFs16ll_BFs16ll_BFu16ll { signed int v1:16; signed long long v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16ll_BFs16ll_BFu16s { signed int v1:16; signed long long v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16i_BFs16ll_BFs16s { signed int v1:16; signed long long v2:16; signed short v3:16; };
struct BFs16i_BFs16ll_BFs16s_BFs16i { signed int v1:16; signed long long v2:16; signed short v3:16; signed int v4:16; };
struct BFs16i_BFs16ll_BFs16s_BFs16ll { signed int v1:16; signed long long v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16i_BFs16ll_BFs16s_BFs16s { signed int v1:16; signed long long v2:16; signed short v3:16; signed short v4:16; };
struct BFs16i_BFs16ll_BFs16s_BFu16i { signed int v1:16; signed long long v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16i_BFs16ll_BFs16s_BFu16ll { signed int v1:16; signed long long v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16ll_BFs16s_BFu16s { signed int v1:16; signed long long v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16i_BFs16ll_BFu16i { signed int v1:16; signed long long v2:16; unsigned int v3:16; };
struct BFs16i_BFs16ll_BFu16i_BFs16i { signed int v1:16; signed long long v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16i_BFs16ll_BFu16i_BFs16ll { signed int v1:16; signed long long v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16i_BFs16ll_BFu16i_BFs16s { signed int v1:16; signed long long v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16i_BFs16ll_BFu16i_BFu16i { signed int v1:16; signed long long v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16i_BFs16ll_BFu16i_BFu16ll { signed int v1:16; signed long long v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16ll_BFu16i_BFu16s { signed int v1:16; signed long long v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16i_BFs16ll_BFu16ll { signed int v1:16; signed long long v2:16; unsigned long long v3:16; };
struct BFs16i_BFs16ll_BFu16ll_BFs16i { signed int v1:16; signed long long v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16i_BFs16ll_BFu16ll_BFs16ll { signed int v1:16; signed long long v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16i_BFs16ll_BFu16ll_BFs16s { signed int v1:16; signed long long v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16i_BFs16ll_BFu16ll_BFu16i { signed int v1:16; signed long long v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16i_BFs16ll_BFu16ll_BFu16ll { signed int v1:16; signed long long v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16ll_BFu16ll_BFu16s { signed int v1:16; signed long long v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16i_BFs16ll_BFu16s { signed int v1:16; signed long long v2:16; unsigned short v3:16; };
struct BFs16i_BFs16ll_BFu16s_BFs16i { signed int v1:16; signed long long v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16i_BFs16ll_BFu16s_BFs16ll { signed int v1:16; signed long long v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16i_BFs16ll_BFu16s_BFs16s { signed int v1:16; signed long long v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16i_BFs16ll_BFu16s_BFu16i { signed int v1:16; signed long long v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16i_BFs16ll_BFu16s_BFu16ll { signed int v1:16; signed long long v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16ll_BFu16s_BFu16s { signed int v1:16; signed long long v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16i_BFs16s { signed int v1:16; signed short v2:16; };
struct BFs16i_BFs16s_BFs16i { signed int v1:16; signed short v2:16; signed int v3:16; };
struct BFs16i_BFs16s_BFs16i_BFs16i { signed int v1:16; signed short v2:16; signed int v3:16; signed int v4:16; };
struct BFs16i_BFs16s_BFs16i_BFs16ll { signed int v1:16; signed short v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16i_BFs16s_BFs16i_BFs16s { signed int v1:16; signed short v2:16; signed int v3:16; signed short v4:16; };
struct BFs16i_BFs16s_BFs16i_BFu16i { signed int v1:16; signed short v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16i_BFs16s_BFs16i_BFu16ll { signed int v1:16; signed short v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16s_BFs16i_BFu16s { signed int v1:16; signed short v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16i_BFs16s_BFs16ll { signed int v1:16; signed short v2:16; signed long long v3:16; };
struct BFs16i_BFs16s_BFs16ll_BFs16i { signed int v1:16; signed short v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16i_BFs16s_BFs16ll_BFs16ll { signed int v1:16; signed short v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16i_BFs16s_BFs16ll_BFs16s { signed int v1:16; signed short v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16i_BFs16s_BFs16ll_BFu16i { signed int v1:16; signed short v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16i_BFs16s_BFs16ll_BFu16ll { signed int v1:16; signed short v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16s_BFs16ll_BFu16s { signed int v1:16; signed short v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16i_BFs16s_BFs16s { signed int v1:16; signed short v2:16; signed short v3:16; };
struct BFs16i_BFs16s_BFs16s_BFs16i { signed int v1:16; signed short v2:16; signed short v3:16; signed int v4:16; };
struct BFs16i_BFs16s_BFs16s_BFs16ll { signed int v1:16; signed short v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16i_BFs16s_BFs16s_BFs16s { signed int v1:16; signed short v2:16; signed short v3:16; signed short v4:16; };
struct BFs16i_BFs16s_BFs16s_BFu16i { signed int v1:16; signed short v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16i_BFs16s_BFs16s_BFu16ll { signed int v1:16; signed short v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16s_BFs16s_BFu16s { signed int v1:16; signed short v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16i_BFs16s_BFu16i { signed int v1:16; signed short v2:16; unsigned int v3:16; };
struct BFs16i_BFs16s_BFu16i_BFs16i { signed int v1:16; signed short v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16i_BFs16s_BFu16i_BFs16ll { signed int v1:16; signed short v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16i_BFs16s_BFu16i_BFs16s { signed int v1:16; signed short v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16i_BFs16s_BFu16i_BFu16i { signed int v1:16; signed short v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16i_BFs16s_BFu16i_BFu16ll { signed int v1:16; signed short v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16s_BFu16i_BFu16s { signed int v1:16; signed short v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16i_BFs16s_BFu16ll { signed int v1:16; signed short v2:16; unsigned long long v3:16; };
struct BFs16i_BFs16s_BFu16ll_BFs16i { signed int v1:16; signed short v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16i_BFs16s_BFu16ll_BFs16ll { signed int v1:16; signed short v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16i_BFs16s_BFu16ll_BFs16s { signed int v1:16; signed short v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16i_BFs16s_BFu16ll_BFu16i { signed int v1:16; signed short v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16i_BFs16s_BFu16ll_BFu16ll { signed int v1:16; signed short v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16s_BFu16ll_BFu16s { signed int v1:16; signed short v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16i_BFs16s_BFu16s { signed int v1:16; signed short v2:16; unsigned short v3:16; };
struct BFs16i_BFs16s_BFu16s_BFs16i { signed int v1:16; signed short v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16i_BFs16s_BFu16s_BFs16ll { signed int v1:16; signed short v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16i_BFs16s_BFu16s_BFs16s { signed int v1:16; signed short v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16i_BFs16s_BFu16s_BFu16i { signed int v1:16; signed short v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16i_BFs16s_BFu16s_BFu16ll { signed int v1:16; signed short v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16i_BFs16s_BFu16s_BFu16s { signed int v1:16; signed short v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16i_BFu16i { signed int v1:16; unsigned int v2:16; };
struct BFs16i_BFu16i_BFs16i { signed int v1:16; unsigned int v2:16; signed int v3:16; };
struct BFs16i_BFu16i_BFs16i_BFs16i { signed int v1:16; unsigned int v2:16; signed int v3:16; signed int v4:16; };
struct BFs16i_BFu16i_BFs16i_BFs16ll { signed int v1:16; unsigned int v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16i_BFu16i_BFs16i_BFs16s { signed int v1:16; unsigned int v2:16; signed int v3:16; signed short v4:16; };
struct BFs16i_BFu16i_BFs16i_BFu16i { signed int v1:16; unsigned int v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16i_BFu16i_BFs16i_BFu16ll { signed int v1:16; unsigned int v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16i_BFs16i_BFu16s { signed int v1:16; unsigned int v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16i_BFu16i_BFs16ll { signed int v1:16; unsigned int v2:16; signed long long v3:16; };
struct BFs16i_BFu16i_BFs16ll_BFs16i { signed int v1:16; unsigned int v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16i_BFu16i_BFs16ll_BFs16ll { signed int v1:16; unsigned int v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16i_BFu16i_BFs16ll_BFs16s { signed int v1:16; unsigned int v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16i_BFu16i_BFs16ll_BFu16i { signed int v1:16; unsigned int v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16i_BFu16i_BFs16ll_BFu16ll { signed int v1:16; unsigned int v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16i_BFs16ll_BFu16s { signed int v1:16; unsigned int v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16i_BFu16i_BFs16s { signed int v1:16; unsigned int v2:16; signed short v3:16; };
struct BFs16i_BFu16i_BFs16s_BFs16i { signed int v1:16; unsigned int v2:16; signed short v3:16; signed int v4:16; };
struct BFs16i_BFu16i_BFs16s_BFs16ll { signed int v1:16; unsigned int v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16i_BFu16i_BFs16s_BFs16s { signed int v1:16; unsigned int v2:16; signed short v3:16; signed short v4:16; };
struct BFs16i_BFu16i_BFs16s_BFu16i { signed int v1:16; unsigned int v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16i_BFu16i_BFs16s_BFu16ll { signed int v1:16; unsigned int v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16i_BFs16s_BFu16s { signed int v1:16; unsigned int v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16i_BFu16i_BFu16i { signed int v1:16; unsigned int v2:16; unsigned int v3:16; };
struct BFs16i_BFu16i_BFu16i_BFs16i { signed int v1:16; unsigned int v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16i_BFu16i_BFu16i_BFs16ll { signed int v1:16; unsigned int v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16i_BFu16i_BFu16i_BFs16s { signed int v1:16; unsigned int v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16i_BFu16i_BFu16i_BFu16i { signed int v1:16; unsigned int v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16i_BFu16i_BFu16i_BFu16ll { signed int v1:16; unsigned int v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16i_BFu16i_BFu16s { signed int v1:16; unsigned int v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16i_BFu16i_BFu16ll { signed int v1:16; unsigned int v2:16; unsigned long long v3:16; };
struct BFs16i_BFu16i_BFu16ll_BFs16i { signed int v1:16; unsigned int v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16i_BFu16i_BFu16ll_BFs16ll { signed int v1:16; unsigned int v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16i_BFu16i_BFu16ll_BFs16s { signed int v1:16; unsigned int v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16i_BFu16i_BFu16ll_BFu16i { signed int v1:16; unsigned int v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16i_BFu16i_BFu16ll_BFu16ll { signed int v1:16; unsigned int v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16i_BFu16ll_BFu16s { signed int v1:16; unsigned int v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16i_BFu16i_BFu16s { signed int v1:16; unsigned int v2:16; unsigned short v3:16; };
struct BFs16i_BFu16i_BFu16s_BFs16i { signed int v1:16; unsigned int v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16i_BFu16i_BFu16s_BFs16ll { signed int v1:16; unsigned int v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16i_BFu16i_BFu16s_BFs16s { signed int v1:16; unsigned int v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16i_BFu16i_BFu16s_BFu16i { signed int v1:16; unsigned int v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16i_BFu16i_BFu16s_BFu16ll { signed int v1:16; unsigned int v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16i_BFu16s_BFu16s { signed int v1:16; unsigned int v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16i_BFu16ll { signed int v1:16; unsigned long long v2:16; };
struct BFs16i_BFu16ll_BFs16i { signed int v1:16; unsigned long long v2:16; signed int v3:16; };
struct BFs16i_BFu16ll_BFs16i_BFs16i { signed int v1:16; unsigned long long v2:16; signed int v3:16; signed int v4:16; };
struct BFs16i_BFu16ll_BFs16i_BFs16ll { signed int v1:16; unsigned long long v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16i_BFu16ll_BFs16i_BFs16s { signed int v1:16; unsigned long long v2:16; signed int v3:16; signed short v4:16; };
struct BFs16i_BFu16ll_BFs16i_BFu16i { signed int v1:16; unsigned long long v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16i_BFu16ll_BFs16i_BFu16ll { signed int v1:16; unsigned long long v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16ll_BFs16i_BFu16s { signed int v1:16; unsigned long long v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16i_BFu16ll_BFs16ll { signed int v1:16; unsigned long long v2:16; signed long long v3:16; };
struct BFs16i_BFu16ll_BFs16ll_BFs16i { signed int v1:16; unsigned long long v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16i_BFu16ll_BFs16ll_BFs16ll { signed int v1:16; unsigned long long v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16i_BFu16ll_BFs16ll_BFs16s { signed int v1:16; unsigned long long v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16i_BFu16ll_BFs16ll_BFu16i { signed int v1:16; unsigned long long v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16i_BFu16ll_BFs16ll_BFu16ll { signed int v1:16; unsigned long long v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16ll_BFs16ll_BFu16s { signed int v1:16; unsigned long long v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16i_BFu16ll_BFs16s { signed int v1:16; unsigned long long v2:16; signed short v3:16; };
struct BFs16i_BFu16ll_BFs16s_BFs16i { signed int v1:16; unsigned long long v2:16; signed short v3:16; signed int v4:16; };
struct BFs16i_BFu16ll_BFs16s_BFs16ll { signed int v1:16; unsigned long long v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16i_BFu16ll_BFs16s_BFs16s { signed int v1:16; unsigned long long v2:16; signed short v3:16; signed short v4:16; };
struct BFs16i_BFu16ll_BFs16s_BFu16i { signed int v1:16; unsigned long long v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16i_BFu16ll_BFs16s_BFu16ll { signed int v1:16; unsigned long long v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16ll_BFs16s_BFu16s { signed int v1:16; unsigned long long v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16i_BFu16ll_BFu16i { signed int v1:16; unsigned long long v2:16; unsigned int v3:16; };
struct BFs16i_BFu16ll_BFu16i_BFs16i { signed int v1:16; unsigned long long v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16i_BFu16ll_BFu16i_BFs16ll { signed int v1:16; unsigned long long v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16i_BFu16ll_BFu16i_BFs16s { signed int v1:16; unsigned long long v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16i_BFu16ll_BFu16i_BFu16i { signed int v1:16; unsigned long long v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16i_BFu16ll_BFu16i_BFu16ll { signed int v1:16; unsigned long long v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16ll_BFu16i_BFu16s { signed int v1:16; unsigned long long v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16i_BFu16ll_BFu16ll { signed int v1:16; unsigned long long v2:16; unsigned long long v3:16; };
struct BFs16i_BFu16ll_BFu16ll_BFs16i { signed int v1:16; unsigned long long v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16i_BFu16ll_BFu16ll_BFs16ll { signed int v1:16; unsigned long long v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16i_BFu16ll_BFu16ll_BFs16s { signed int v1:16; unsigned long long v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16i_BFu16ll_BFu16ll_BFu16i { signed int v1:16; unsigned long long v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16i_BFu16ll_BFu16ll_BFu16ll { signed int v1:16; unsigned long long v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16ll_BFu16ll_BFu16s { signed int v1:16; unsigned long long v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16i_BFu16ll_BFu16s { signed int v1:16; unsigned long long v2:16; unsigned short v3:16; };
struct BFs16i_BFu16ll_BFu16s_BFs16i { signed int v1:16; unsigned long long v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16i_BFu16ll_BFu16s_BFs16ll { signed int v1:16; unsigned long long v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16i_BFu16ll_BFu16s_BFs16s { signed int v1:16; unsigned long long v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16i_BFu16ll_BFu16s_BFu16i { signed int v1:16; unsigned long long v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16i_BFu16ll_BFu16s_BFu16ll { signed int v1:16; unsigned long long v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16ll_BFu16s_BFu16s { signed int v1:16; unsigned long long v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16i_BFu16s { signed int v1:16; unsigned short v2:16; };
struct BFs16i_BFu16s_BFs16i { signed int v1:16; unsigned short v2:16; signed int v3:16; };
struct BFs16i_BFu16s_BFs16i_BFs16i { signed int v1:16; unsigned short v2:16; signed int v3:16; signed int v4:16; };
struct BFs16i_BFu16s_BFs16i_BFs16ll { signed int v1:16; unsigned short v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16i_BFu16s_BFs16i_BFs16s { signed int v1:16; unsigned short v2:16; signed int v3:16; signed short v4:16; };
struct BFs16i_BFu16s_BFs16i_BFu16i { signed int v1:16; unsigned short v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16i_BFu16s_BFs16i_BFu16ll { signed int v1:16; unsigned short v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16s_BFs16i_BFu16s { signed int v1:16; unsigned short v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16i_BFu16s_BFs16ll { signed int v1:16; unsigned short v2:16; signed long long v3:16; };
struct BFs16i_BFu16s_BFs16ll_BFs16i { signed int v1:16; unsigned short v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16i_BFu16s_BFs16ll_BFs16ll { signed int v1:16; unsigned short v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16i_BFu16s_BFs16ll_BFs16s { signed int v1:16; unsigned short v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16i_BFu16s_BFs16ll_BFu16i { signed int v1:16; unsigned short v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16i_BFu16s_BFs16ll_BFu16ll { signed int v1:16; unsigned short v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16s_BFs16ll_BFu16s { signed int v1:16; unsigned short v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16i_BFu16s_BFs16s { signed int v1:16; unsigned short v2:16; signed short v3:16; };
struct BFs16i_BFu16s_BFs16s_BFs16i { signed int v1:16; unsigned short v2:16; signed short v3:16; signed int v4:16; };
struct BFs16i_BFu16s_BFs16s_BFs16ll { signed int v1:16; unsigned short v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16i_BFu16s_BFs16s_BFs16s { signed int v1:16; unsigned short v2:16; signed short v3:16; signed short v4:16; };
struct BFs16i_BFu16s_BFs16s_BFu16i { signed int v1:16; unsigned short v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16i_BFu16s_BFs16s_BFu16ll { signed int v1:16; unsigned short v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16s_BFs16s_BFu16s { signed int v1:16; unsigned short v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16i_BFu16s_BFu16i { signed int v1:16; unsigned short v2:16; unsigned int v3:16; };
struct BFs16i_BFu16s_BFu16i_BFs16i { signed int v1:16; unsigned short v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16i_BFu16s_BFu16i_BFs16ll { signed int v1:16; unsigned short v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16i_BFu16s_BFu16i_BFs16s { signed int v1:16; unsigned short v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16i_BFu16s_BFu16i_BFu16i { signed int v1:16; unsigned short v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16i_BFu16s_BFu16i_BFu16ll { signed int v1:16; unsigned short v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16s_BFu16i_BFu16s { signed int v1:16; unsigned short v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16i_BFu16s_BFu16ll { signed int v1:16; unsigned short v2:16; unsigned long long v3:16; };
struct BFs16i_BFu16s_BFu16ll_BFs16i { signed int v1:16; unsigned short v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16i_BFu16s_BFu16ll_BFs16ll { signed int v1:16; unsigned short v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16i_BFu16s_BFu16ll_BFs16s { signed int v1:16; unsigned short v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16i_BFu16s_BFu16ll_BFu16i { signed int v1:16; unsigned short v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16i_BFu16s_BFu16ll_BFu16ll { signed int v1:16; unsigned short v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16s_BFu16ll_BFu16s { signed int v1:16; unsigned short v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16i_BFu16s_BFu16s { signed int v1:16; unsigned short v2:16; unsigned short v3:16; };
struct BFs16i_BFu16s_BFu16s_BFs16i { signed int v1:16; unsigned short v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16i_BFu16s_BFu16s_BFs16ll { signed int v1:16; unsigned short v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16i_BFu16s_BFu16s_BFs16s { signed int v1:16; unsigned short v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16i_BFu16s_BFu16s_BFu16i { signed int v1:16; unsigned short v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16i_BFu16s_BFu16s_BFu16ll { signed int v1:16; unsigned short v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16i_BFu16s_BFu16s_BFu16s { signed int v1:16; unsigned short v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16i { signed long long v1:16; signed int v2:16; };
struct BFs16ll_BFs16i_BFs16i { signed long long v1:16; signed int v2:16; signed int v3:16; };
struct BFs16ll_BFs16i_BFs16i_BFs16i { signed long long v1:16; signed int v2:16; signed int v3:16; signed int v4:16; };
struct BFs16ll_BFs16i_BFs16i_BFs16ll { signed long long v1:16; signed int v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16ll_BFs16i_BFs16i_BFs16s { signed long long v1:16; signed int v2:16; signed int v3:16; signed short v4:16; };
struct BFs16ll_BFs16i_BFs16i_BFu16i { signed long long v1:16; signed int v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16i_BFs16i_BFu16ll { signed long long v1:16; signed int v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16i_BFs16i_BFu16s { signed long long v1:16; signed int v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16i_BFs16ll { signed long long v1:16; signed int v2:16; signed long long v3:16; };
struct BFs16ll_BFs16i_BFs16ll_BFs16i { signed long long v1:16; signed int v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16ll_BFs16i_BFs16ll_BFs16ll { signed long long v1:16; signed int v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16ll_BFs16i_BFs16ll_BFs16s { signed long long v1:16; signed int v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16ll_BFs16i_BFs16ll_BFu16i { signed long long v1:16; signed int v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16i_BFs16ll_BFu16ll { signed long long v1:16; signed int v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16i_BFs16ll_BFu16s { signed long long v1:16; signed int v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16i_BFs16s { signed long long v1:16; signed int v2:16; signed short v3:16; };
struct BFs16ll_BFs16i_BFs16s_BFs16i { signed long long v1:16; signed int v2:16; signed short v3:16; signed int v4:16; };
struct BFs16ll_BFs16i_BFs16s_BFs16ll { signed long long v1:16; signed int v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16ll_BFs16i_BFs16s_BFs16s { signed long long v1:16; signed int v2:16; signed short v3:16; signed short v4:16; };
struct BFs16ll_BFs16i_BFs16s_BFu16i { signed long long v1:16; signed int v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16i_BFs16s_BFu16ll { signed long long v1:16; signed int v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16i_BFs16s_BFu16s { signed long long v1:16; signed int v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16i_BFu16i { signed long long v1:16; signed int v2:16; unsigned int v3:16; };
struct BFs16ll_BFs16i_BFu16i_BFs16i { signed long long v1:16; signed int v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16ll_BFs16i_BFu16i_BFs16ll { signed long long v1:16; signed int v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16ll_BFs16i_BFu16i_BFs16s { signed long long v1:16; signed int v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16ll_BFs16i_BFu16i_BFu16i { signed long long v1:16; signed int v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16i_BFu16i_BFu16ll { signed long long v1:16; signed int v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16i_BFu16i_BFu16s { signed long long v1:16; signed int v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16i_BFu16ll { signed long long v1:16; signed int v2:16; unsigned long long v3:16; };
struct BFs16ll_BFs16i_BFu16ll_BFs16i { signed long long v1:16; signed int v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16ll_BFs16i_BFu16ll_BFs16ll { signed long long v1:16; signed int v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16ll_BFs16i_BFu16ll_BFs16s { signed long long v1:16; signed int v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16ll_BFs16i_BFu16ll_BFu16i { signed long long v1:16; signed int v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16i_BFu16ll_BFu16ll { signed long long v1:16; signed int v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16i_BFu16ll_BFu16s { signed long long v1:16; signed int v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16i_BFu16s { signed long long v1:16; signed int v2:16; unsigned short v3:16; };
struct BFs16ll_BFs16i_BFu16s_BFs16i { signed long long v1:16; signed int v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16ll_BFs16i_BFu16s_BFs16ll { signed long long v1:16; signed int v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16ll_BFs16i_BFu16s_BFs16s { signed long long v1:16; signed int v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16ll_BFs16i_BFu16s_BFu16i { signed long long v1:16; signed int v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16i_BFu16s_BFu16ll { signed long long v1:16; signed int v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16i_BFu16s_BFu16s { signed long long v1:16; signed int v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16ll { signed long long v1:16; signed long long v2:16; };
struct BFs16ll_BFs16ll_BFs16i { signed long long v1:16; signed long long v2:16; signed int v3:16; };
struct BFs16ll_BFs16ll_BFs16i_BFs16i { signed long long v1:16; signed long long v2:16; signed int v3:16; signed int v4:16; };
struct BFs16ll_BFs16ll_BFs16i_BFs16ll { signed long long v1:16; signed long long v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16ll_BFs16ll_BFs16i_BFs16s { signed long long v1:16; signed long long v2:16; signed int v3:16; signed short v4:16; };
struct BFs16ll_BFs16ll_BFs16i_BFu16i { signed long long v1:16; signed long long v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16ll_BFs16i_BFu16ll { signed long long v1:16; signed long long v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16ll_BFs16i_BFu16s { signed long long v1:16; signed long long v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16ll_BFs16ll { signed long long v1:16; signed long long v2:16; signed long long v3:16; };
struct BFs16ll_BFs16ll_BFs16ll_BFs16i { signed long long v1:16; signed long long v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16ll_BFs16ll_BFs16ll_BFs16ll { signed long long v1:16; signed long long v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16ll_BFs16ll_BFs16ll_BFs16s { signed long long v1:16; signed long long v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16ll_BFs16ll_BFs16ll_BFu16i { signed long long v1:16; signed long long v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16ll_BFs16ll_BFu16ll { signed long long v1:16; signed long long v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16ll_BFs16ll_BFu16s { signed long long v1:16; signed long long v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16ll_BFs16s { signed long long v1:16; signed long long v2:16; signed short v3:16; };
struct BFs16ll_BFs16ll_BFs16s_BFs16i { signed long long v1:16; signed long long v2:16; signed short v3:16; signed int v4:16; };
struct BFs16ll_BFs16ll_BFs16s_BFs16ll { signed long long v1:16; signed long long v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16ll_BFs16ll_BFs16s_BFs16s { signed long long v1:16; signed long long v2:16; signed short v3:16; signed short v4:16; };
struct BFs16ll_BFs16ll_BFs16s_BFu16i { signed long long v1:16; signed long long v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16ll_BFs16s_BFu16ll { signed long long v1:16; signed long long v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16ll_BFs16s_BFu16s { signed long long v1:16; signed long long v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16ll_BFu16i { signed long long v1:16; signed long long v2:16; unsigned int v3:16; };
struct BFs16ll_BFs16ll_BFu16i_BFs16i { signed long long v1:16; signed long long v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16ll_BFs16ll_BFu16i_BFs16ll { signed long long v1:16; signed long long v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16ll_BFs16ll_BFu16i_BFs16s { signed long long v1:16; signed long long v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16ll_BFs16ll_BFu16i_BFu16i { signed long long v1:16; signed long long v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16ll_BFu16i_BFu16ll { signed long long v1:16; signed long long v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16ll_BFu16i_BFu16s { signed long long v1:16; signed long long v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16ll_BFu16ll { signed long long v1:16; signed long long v2:16; unsigned long long v3:16; };
struct BFs16ll_BFs16ll_BFu16ll_BFs16i { signed long long v1:16; signed long long v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16ll_BFs16ll_BFu16ll_BFs16ll { signed long long v1:16; signed long long v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16ll_BFs16ll_BFu16ll_BFs16s { signed long long v1:16; signed long long v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16ll_BFs16ll_BFu16ll_BFu16i { signed long long v1:16; signed long long v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16ll_BFu16ll_BFu16ll { signed long long v1:16; signed long long v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16ll_BFu16ll_BFu16s { signed long long v1:16; signed long long v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16ll_BFu16s { signed long long v1:16; signed long long v2:16; unsigned short v3:16; };
struct BFs16ll_BFs16ll_BFu16s_BFs16i { signed long long v1:16; signed long long v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16ll_BFs16ll_BFu16s_BFs16ll { signed long long v1:16; signed long long v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16ll_BFs16ll_BFu16s_BFs16s { signed long long v1:16; signed long long v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16ll_BFs16ll_BFu16s_BFu16i { signed long long v1:16; signed long long v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16ll_BFu16s_BFu16ll { signed long long v1:16; signed long long v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16ll_BFu16s_BFu16s { signed long long v1:16; signed long long v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16s { signed long long v1:16; signed short v2:16; };
struct BFs16ll_BFs16s_BFs16i { signed long long v1:16; signed short v2:16; signed int v3:16; };
struct BFs16ll_BFs16s_BFs16i_BFs16i { signed long long v1:16; signed short v2:16; signed int v3:16; signed int v4:16; };
struct BFs16ll_BFs16s_BFs16i_BFs16ll { signed long long v1:16; signed short v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16ll_BFs16s_BFs16i_BFs16s { signed long long v1:16; signed short v2:16; signed int v3:16; signed short v4:16; };
struct BFs16ll_BFs16s_BFs16i_BFu16i { signed long long v1:16; signed short v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16s_BFs16i_BFu16ll { signed long long v1:16; signed short v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16s_BFs16i_BFu16s { signed long long v1:16; signed short v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16s_BFs16ll { signed long long v1:16; signed short v2:16; signed long long v3:16; };
struct BFs16ll_BFs16s_BFs16ll_BFs16i { signed long long v1:16; signed short v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16ll_BFs16s_BFs16ll_BFs16ll { signed long long v1:16; signed short v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16ll_BFs16s_BFs16ll_BFs16s { signed long long v1:16; signed short v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16ll_BFs16s_BFs16ll_BFu16i { signed long long v1:16; signed short v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16s_BFs16ll_BFu16ll { signed long long v1:16; signed short v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16s_BFs16ll_BFu16s { signed long long v1:16; signed short v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16s_BFs16s { signed long long v1:16; signed short v2:16; signed short v3:16; };
struct BFs16ll_BFs16s_BFs16s_BFs16i { signed long long v1:16; signed short v2:16; signed short v3:16; signed int v4:16; };
struct BFs16ll_BFs16s_BFs16s_BFs16ll { signed long long v1:16; signed short v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16ll_BFs16s_BFs16s_BFs16s { signed long long v1:16; signed short v2:16; signed short v3:16; signed short v4:16; };
struct BFs16ll_BFs16s_BFs16s_BFu16i { signed long long v1:16; signed short v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16s_BFs16s_BFu16ll { signed long long v1:16; signed short v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16s_BFs16s_BFu16s { signed long long v1:16; signed short v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16s_BFu16i { signed long long v1:16; signed short v2:16; unsigned int v3:16; };
struct BFs16ll_BFs16s_BFu16i_BFs16i { signed long long v1:16; signed short v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16ll_BFs16s_BFu16i_BFs16ll { signed long long v1:16; signed short v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16ll_BFs16s_BFu16i_BFs16s { signed long long v1:16; signed short v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16ll_BFs16s_BFu16i_BFu16i { signed long long v1:16; signed short v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16s_BFu16i_BFu16ll { signed long long v1:16; signed short v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16s_BFu16i_BFu16s { signed long long v1:16; signed short v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16s_BFu16ll { signed long long v1:16; signed short v2:16; unsigned long long v3:16; };
struct BFs16ll_BFs16s_BFu16ll_BFs16i { signed long long v1:16; signed short v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16ll_BFs16s_BFu16ll_BFs16ll { signed long long v1:16; signed short v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16ll_BFs16s_BFu16ll_BFs16s { signed long long v1:16; signed short v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16ll_BFs16s_BFu16ll_BFu16i { signed long long v1:16; signed short v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16s_BFu16ll_BFu16ll { signed long long v1:16; signed short v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16s_BFu16ll_BFu16s { signed long long v1:16; signed short v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16ll_BFs16s_BFu16s { signed long long v1:16; signed short v2:16; unsigned short v3:16; };
struct BFs16ll_BFs16s_BFu16s_BFs16i { signed long long v1:16; signed short v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16ll_BFs16s_BFu16s_BFs16ll { signed long long v1:16; signed short v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16ll_BFs16s_BFu16s_BFs16s { signed long long v1:16; signed short v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16ll_BFs16s_BFu16s_BFu16i { signed long long v1:16; signed short v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16ll_BFs16s_BFu16s_BFu16ll { signed long long v1:16; signed short v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16ll_BFs16s_BFu16s_BFu16s { signed long long v1:16; signed short v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16i { signed long long v1:16; unsigned int v2:16; };
struct BFs16ll_BFu16i_BFs16i { signed long long v1:16; unsigned int v2:16; signed int v3:16; };
struct BFs16ll_BFu16i_BFs16i_BFs16i { signed long long v1:16; unsigned int v2:16; signed int v3:16; signed int v4:16; };
struct BFs16ll_BFu16i_BFs16i_BFs16ll { signed long long v1:16; unsigned int v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16ll_BFu16i_BFs16i_BFs16s { signed long long v1:16; unsigned int v2:16; signed int v3:16; signed short v4:16; };
struct BFs16ll_BFu16i_BFs16i_BFu16i { signed long long v1:16; unsigned int v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16i_BFs16i_BFu16ll { signed long long v1:16; unsigned int v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16i_BFs16i_BFu16s { signed long long v1:16; unsigned int v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16i_BFs16ll { signed long long v1:16; unsigned int v2:16; signed long long v3:16; };
struct BFs16ll_BFu16i_BFs16ll_BFs16i { signed long long v1:16; unsigned int v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16ll_BFu16i_BFs16ll_BFs16ll { signed long long v1:16; unsigned int v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16ll_BFu16i_BFs16ll_BFs16s { signed long long v1:16; unsigned int v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16ll_BFu16i_BFs16ll_BFu16i { signed long long v1:16; unsigned int v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16i_BFs16ll_BFu16ll { signed long long v1:16; unsigned int v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16i_BFs16ll_BFu16s { signed long long v1:16; unsigned int v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16i_BFs16s { signed long long v1:16; unsigned int v2:16; signed short v3:16; };
struct BFs16ll_BFu16i_BFs16s_BFs16i { signed long long v1:16; unsigned int v2:16; signed short v3:16; signed int v4:16; };
struct BFs16ll_BFu16i_BFs16s_BFs16ll { signed long long v1:16; unsigned int v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16ll_BFu16i_BFs16s_BFs16s { signed long long v1:16; unsigned int v2:16; signed short v3:16; signed short v4:16; };
struct BFs16ll_BFu16i_BFs16s_BFu16i { signed long long v1:16; unsigned int v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16i_BFs16s_BFu16ll { signed long long v1:16; unsigned int v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16i_BFs16s_BFu16s { signed long long v1:16; unsigned int v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16i_BFu16i { signed long long v1:16; unsigned int v2:16; unsigned int v3:16; };
struct BFs16ll_BFu16i_BFu16i_BFs16i { signed long long v1:16; unsigned int v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16ll_BFu16i_BFu16i_BFs16ll { signed long long v1:16; unsigned int v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16ll_BFu16i_BFu16i_BFs16s { signed long long v1:16; unsigned int v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16ll_BFu16i_BFu16i_BFu16i { signed long long v1:16; unsigned int v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16i_BFu16i_BFu16ll { signed long long v1:16; unsigned int v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16i_BFu16i_BFu16s { signed long long v1:16; unsigned int v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16i_BFu16ll { signed long long v1:16; unsigned int v2:16; unsigned long long v3:16; };
struct BFs16ll_BFu16i_BFu16ll_BFs16i { signed long long v1:16; unsigned int v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16ll_BFu16i_BFu16ll_BFs16ll { signed long long v1:16; unsigned int v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16ll_BFu16i_BFu16ll_BFs16s { signed long long v1:16; unsigned int v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16ll_BFu16i_BFu16ll_BFu16i { signed long long v1:16; unsigned int v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16i_BFu16ll_BFu16ll { signed long long v1:16; unsigned int v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16i_BFu16ll_BFu16s { signed long long v1:16; unsigned int v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16i_BFu16s { signed long long v1:16; unsigned int v2:16; unsigned short v3:16; };
struct BFs16ll_BFu16i_BFu16s_BFs16i { signed long long v1:16; unsigned int v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16ll_BFu16i_BFu16s_BFs16ll { signed long long v1:16; unsigned int v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16ll_BFu16i_BFu16s_BFs16s { signed long long v1:16; unsigned int v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16ll_BFu16i_BFu16s_BFu16i { signed long long v1:16; unsigned int v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16i_BFu16s_BFu16ll { signed long long v1:16; unsigned int v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16i_BFu16s_BFu16s { signed long long v1:16; unsigned int v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16ll { signed long long v1:16; unsigned long long v2:16; };
struct BFs16ll_BFu16ll_BFs16i { signed long long v1:16; unsigned long long v2:16; signed int v3:16; };
struct BFs16ll_BFu16ll_BFs16i_BFs16i { signed long long v1:16; unsigned long long v2:16; signed int v3:16; signed int v4:16; };
struct BFs16ll_BFu16ll_BFs16i_BFs16ll { signed long long v1:16; unsigned long long v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16ll_BFu16ll_BFs16i_BFs16s { signed long long v1:16; unsigned long long v2:16; signed int v3:16; signed short v4:16; };
struct BFs16ll_BFu16ll_BFs16i_BFu16i { signed long long v1:16; unsigned long long v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16ll_BFs16i_BFu16ll { signed long long v1:16; unsigned long long v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16ll_BFs16i_BFu16s { signed long long v1:16; unsigned long long v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16ll_BFs16ll { signed long long v1:16; unsigned long long v2:16; signed long long v3:16; };
struct BFs16ll_BFu16ll_BFs16ll_BFs16i { signed long long v1:16; unsigned long long v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16ll_BFu16ll_BFs16ll_BFs16ll { signed long long v1:16; unsigned long long v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16ll_BFu16ll_BFs16ll_BFs16s { signed long long v1:16; unsigned long long v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16ll_BFu16ll_BFs16ll_BFu16i { signed long long v1:16; unsigned long long v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16ll_BFs16ll_BFu16ll { signed long long v1:16; unsigned long long v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16ll_BFs16ll_BFu16s { signed long long v1:16; unsigned long long v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16ll_BFs16s { signed long long v1:16; unsigned long long v2:16; signed short v3:16; };
struct BFs16ll_BFu16ll_BFs16s_BFs16i { signed long long v1:16; unsigned long long v2:16; signed short v3:16; signed int v4:16; };
struct BFs16ll_BFu16ll_BFs16s_BFs16ll { signed long long v1:16; unsigned long long v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16ll_BFu16ll_BFs16s_BFs16s { signed long long v1:16; unsigned long long v2:16; signed short v3:16; signed short v4:16; };
struct BFs16ll_BFu16ll_BFs16s_BFu16i { signed long long v1:16; unsigned long long v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16ll_BFs16s_BFu16ll { signed long long v1:16; unsigned long long v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16ll_BFs16s_BFu16s { signed long long v1:16; unsigned long long v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16ll_BFu16i { signed long long v1:16; unsigned long long v2:16; unsigned int v3:16; };
struct BFs16ll_BFu16ll_BFu16i_BFs16i { signed long long v1:16; unsigned long long v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16ll_BFu16ll_BFu16i_BFs16ll { signed long long v1:16; unsigned long long v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16ll_BFu16ll_BFu16i_BFs16s { signed long long v1:16; unsigned long long v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16ll_BFu16ll_BFu16i_BFu16i { signed long long v1:16; unsigned long long v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16ll_BFu16i_BFu16ll { signed long long v1:16; unsigned long long v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16ll_BFu16i_BFu16s { signed long long v1:16; unsigned long long v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16ll_BFu16ll { signed long long v1:16; unsigned long long v2:16; unsigned long long v3:16; };
struct BFs16ll_BFu16ll_BFu16ll_BFs16i { signed long long v1:16; unsigned long long v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16ll_BFu16ll_BFu16ll_BFs16ll { signed long long v1:16; unsigned long long v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16ll_BFu16ll_BFu16ll_BFs16s { signed long long v1:16; unsigned long long v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16ll_BFu16ll_BFu16ll_BFu16i { signed long long v1:16; unsigned long long v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16ll_BFu16ll_BFu16ll { signed long long v1:16; unsigned long long v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16ll_BFu16ll_BFu16s { signed long long v1:16; unsigned long long v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16ll_BFu16s { signed long long v1:16; unsigned long long v2:16; unsigned short v3:16; };
struct BFs16ll_BFu16ll_BFu16s_BFs16i { signed long long v1:16; unsigned long long v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16ll_BFu16ll_BFu16s_BFs16ll { signed long long v1:16; unsigned long long v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16ll_BFu16ll_BFu16s_BFs16s { signed long long v1:16; unsigned long long v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16ll_BFu16ll_BFu16s_BFu16i { signed long long v1:16; unsigned long long v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16ll_BFu16s_BFu16ll { signed long long v1:16; unsigned long long v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16ll_BFu16s_BFu16s { signed long long v1:16; unsigned long long v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16s { signed long long v1:16; unsigned short v2:16; };
struct BFs16ll_BFu16s_BFs16i { signed long long v1:16; unsigned short v2:16; signed int v3:16; };
struct BFs16ll_BFu16s_BFs16i_BFs16i { signed long long v1:16; unsigned short v2:16; signed int v3:16; signed int v4:16; };
struct BFs16ll_BFu16s_BFs16i_BFs16ll { signed long long v1:16; unsigned short v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16ll_BFu16s_BFs16i_BFs16s { signed long long v1:16; unsigned short v2:16; signed int v3:16; signed short v4:16; };
struct BFs16ll_BFu16s_BFs16i_BFu16i { signed long long v1:16; unsigned short v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16s_BFs16i_BFu16ll { signed long long v1:16; unsigned short v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16s_BFs16i_BFu16s { signed long long v1:16; unsigned short v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16s_BFs16ll { signed long long v1:16; unsigned short v2:16; signed long long v3:16; };
struct BFs16ll_BFu16s_BFs16ll_BFs16i { signed long long v1:16; unsigned short v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16ll_BFu16s_BFs16ll_BFs16ll { signed long long v1:16; unsigned short v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16ll_BFu16s_BFs16ll_BFs16s { signed long long v1:16; unsigned short v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16ll_BFu16s_BFs16ll_BFu16i { signed long long v1:16; unsigned short v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16s_BFs16ll_BFu16ll { signed long long v1:16; unsigned short v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16s_BFs16ll_BFu16s { signed long long v1:16; unsigned short v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16s_BFs16s { signed long long v1:16; unsigned short v2:16; signed short v3:16; };
struct BFs16ll_BFu16s_BFs16s_BFs16i { signed long long v1:16; unsigned short v2:16; signed short v3:16; signed int v4:16; };
struct BFs16ll_BFu16s_BFs16s_BFs16ll { signed long long v1:16; unsigned short v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16ll_BFu16s_BFs16s_BFs16s { signed long long v1:16; unsigned short v2:16; signed short v3:16; signed short v4:16; };
struct BFs16ll_BFu16s_BFs16s_BFu16i { signed long long v1:16; unsigned short v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16s_BFs16s_BFu16ll { signed long long v1:16; unsigned short v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16s_BFs16s_BFu16s { signed long long v1:16; unsigned short v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16s_BFu16i { signed long long v1:16; unsigned short v2:16; unsigned int v3:16; };
struct BFs16ll_BFu16s_BFu16i_BFs16i { signed long long v1:16; unsigned short v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16ll_BFu16s_BFu16i_BFs16ll { signed long long v1:16; unsigned short v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16ll_BFu16s_BFu16i_BFs16s { signed long long v1:16; unsigned short v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16ll_BFu16s_BFu16i_BFu16i { signed long long v1:16; unsigned short v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16s_BFu16i_BFu16ll { signed long long v1:16; unsigned short v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16s_BFu16i_BFu16s { signed long long v1:16; unsigned short v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16s_BFu16ll { signed long long v1:16; unsigned short v2:16; unsigned long long v3:16; };
struct BFs16ll_BFu16s_BFu16ll_BFs16i { signed long long v1:16; unsigned short v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16ll_BFu16s_BFu16ll_BFs16ll { signed long long v1:16; unsigned short v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16ll_BFu16s_BFu16ll_BFs16s { signed long long v1:16; unsigned short v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16ll_BFu16s_BFu16ll_BFu16i { signed long long v1:16; unsigned short v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16s_BFu16ll_BFu16ll { signed long long v1:16; unsigned short v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16s_BFu16ll_BFu16s { signed long long v1:16; unsigned short v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16ll_BFu16s_BFu16s { signed long long v1:16; unsigned short v2:16; unsigned short v3:16; };
struct BFs16ll_BFu16s_BFu16s_BFs16i { signed long long v1:16; unsigned short v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16ll_BFu16s_BFu16s_BFs16ll { signed long long v1:16; unsigned short v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16ll_BFu16s_BFu16s_BFs16s { signed long long v1:16; unsigned short v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16ll_BFu16s_BFu16s_BFu16i { signed long long v1:16; unsigned short v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16ll_BFu16s_BFu16s_BFu16ll { signed long long v1:16; unsigned short v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16ll_BFu16s_BFu16s_BFu16s { signed long long v1:16; unsigned short v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16s_BFs16i { signed short v1:16; signed int v2:16; };
struct BFs16s_BFs16i_BFs16i { signed short v1:16; signed int v2:16; signed int v3:16; };
struct BFs16s_BFs16i_BFs16i_BFs16i { signed short v1:16; signed int v2:16; signed int v3:16; signed int v4:16; };
struct BFs16s_BFs16i_BFs16i_BFs16ll { signed short v1:16; signed int v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16s_BFs16i_BFs16i_BFs16s { signed short v1:16; signed int v2:16; signed int v3:16; signed short v4:16; };
struct BFs16s_BFs16i_BFs16i_BFu16i { signed short v1:16; signed int v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16s_BFs16i_BFs16i_BFu16ll { signed short v1:16; signed int v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16i_BFs16i_BFu16s { signed short v1:16; signed int v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16s_BFs16i_BFs16ll { signed short v1:16; signed int v2:16; signed long long v3:16; };
struct BFs16s_BFs16i_BFs16ll_BFs16i { signed short v1:16; signed int v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16s_BFs16i_BFs16ll_BFs16ll { signed short v1:16; signed int v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16s_BFs16i_BFs16ll_BFs16s { signed short v1:16; signed int v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16s_BFs16i_BFs16ll_BFu16i { signed short v1:16; signed int v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16s_BFs16i_BFs16ll_BFu16ll { signed short v1:16; signed int v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16i_BFs16ll_BFu16s { signed short v1:16; signed int v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16s_BFs16i_BFs16s { signed short v1:16; signed int v2:16; signed short v3:16; };
struct BFs16s_BFs16i_BFs16s_BFs16i { signed short v1:16; signed int v2:16; signed short v3:16; signed int v4:16; };
struct BFs16s_BFs16i_BFs16s_BFs16ll { signed short v1:16; signed int v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16s_BFs16i_BFs16s_BFs16s { signed short v1:16; signed int v2:16; signed short v3:16; signed short v4:16; };
struct BFs16s_BFs16i_BFs16s_BFu16i { signed short v1:16; signed int v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16s_BFs16i_BFs16s_BFu16ll { signed short v1:16; signed int v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16i_BFs16s_BFu16s { signed short v1:16; signed int v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16s_BFs16i_BFu16i { signed short v1:16; signed int v2:16; unsigned int v3:16; };
struct BFs16s_BFs16i_BFu16i_BFs16i { signed short v1:16; signed int v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16s_BFs16i_BFu16i_BFs16ll { signed short v1:16; signed int v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16s_BFs16i_BFu16i_BFs16s { signed short v1:16; signed int v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16s_BFs16i_BFu16i_BFu16i { signed short v1:16; signed int v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16s_BFs16i_BFu16i_BFu16ll { signed short v1:16; signed int v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16i_BFu16i_BFu16s { signed short v1:16; signed int v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16s_BFs16i_BFu16ll { signed short v1:16; signed int v2:16; unsigned long long v3:16; };
struct BFs16s_BFs16i_BFu16ll_BFs16i { signed short v1:16; signed int v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16s_BFs16i_BFu16ll_BFs16ll { signed short v1:16; signed int v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16s_BFs16i_BFu16ll_BFs16s { signed short v1:16; signed int v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16s_BFs16i_BFu16ll_BFu16i { signed short v1:16; signed int v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16s_BFs16i_BFu16ll_BFu16ll { signed short v1:16; signed int v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16i_BFu16ll_BFu16s { signed short v1:16; signed int v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16s_BFs16i_BFu16s { signed short v1:16; signed int v2:16; unsigned short v3:16; };
struct BFs16s_BFs16i_BFu16s_BFs16i { signed short v1:16; signed int v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16s_BFs16i_BFu16s_BFs16ll { signed short v1:16; signed int v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16s_BFs16i_BFu16s_BFs16s { signed short v1:16; signed int v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16s_BFs16i_BFu16s_BFu16i { signed short v1:16; signed int v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16s_BFs16i_BFu16s_BFu16ll { signed short v1:16; signed int v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16i_BFu16s_BFu16s { signed short v1:16; signed int v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16s_BFs16ll { signed short v1:16; signed long long v2:16; };
struct BFs16s_BFs16ll_BFs16i { signed short v1:16; signed long long v2:16; signed int v3:16; };
struct BFs16s_BFs16ll_BFs16i_BFs16i { signed short v1:16; signed long long v2:16; signed int v3:16; signed int v4:16; };
struct BFs16s_BFs16ll_BFs16i_BFs16ll { signed short v1:16; signed long long v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16s_BFs16ll_BFs16i_BFs16s { signed short v1:16; signed long long v2:16; signed int v3:16; signed short v4:16; };
struct BFs16s_BFs16ll_BFs16i_BFu16i { signed short v1:16; signed long long v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16s_BFs16ll_BFs16i_BFu16ll { signed short v1:16; signed long long v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16ll_BFs16i_BFu16s { signed short v1:16; signed long long v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16s_BFs16ll_BFs16ll { signed short v1:16; signed long long v2:16; signed long long v3:16; };
struct BFs16s_BFs16ll_BFs16ll_BFs16i { signed short v1:16; signed long long v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16s_BFs16ll_BFs16ll_BFs16ll { signed short v1:16; signed long long v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16s_BFs16ll_BFs16ll_BFs16s { signed short v1:16; signed long long v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16s_BFs16ll_BFs16ll_BFu16i { signed short v1:16; signed long long v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16s_BFs16ll_BFs16ll_BFu16ll { signed short v1:16; signed long long v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16ll_BFs16ll_BFu16s { signed short v1:16; signed long long v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16s_BFs16ll_BFs16s { signed short v1:16; signed long long v2:16; signed short v3:16; };
struct BFs16s_BFs16ll_BFs16s_BFs16i { signed short v1:16; signed long long v2:16; signed short v3:16; signed int v4:16; };
struct BFs16s_BFs16ll_BFs16s_BFs16ll { signed short v1:16; signed long long v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16s_BFs16ll_BFs16s_BFs16s { signed short v1:16; signed long long v2:16; signed short v3:16; signed short v4:16; };
struct BFs16s_BFs16ll_BFs16s_BFu16i { signed short v1:16; signed long long v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16s_BFs16ll_BFs16s_BFu16ll { signed short v1:16; signed long long v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16ll_BFs16s_BFu16s { signed short v1:16; signed long long v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16s_BFs16ll_BFu16i { signed short v1:16; signed long long v2:16; unsigned int v3:16; };
struct BFs16s_BFs16ll_BFu16i_BFs16i { signed short v1:16; signed long long v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16s_BFs16ll_BFu16i_BFs16ll { signed short v1:16; signed long long v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16s_BFs16ll_BFu16i_BFs16s { signed short v1:16; signed long long v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16s_BFs16ll_BFu16i_BFu16i { signed short v1:16; signed long long v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16s_BFs16ll_BFu16i_BFu16ll { signed short v1:16; signed long long v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16ll_BFu16i_BFu16s { signed short v1:16; signed long long v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16s_BFs16ll_BFu16ll { signed short v1:16; signed long long v2:16; unsigned long long v3:16; };
struct BFs16s_BFs16ll_BFu16ll_BFs16i { signed short v1:16; signed long long v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16s_BFs16ll_BFu16ll_BFs16ll { signed short v1:16; signed long long v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16s_BFs16ll_BFu16ll_BFs16s { signed short v1:16; signed long long v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16s_BFs16ll_BFu16ll_BFu16i { signed short v1:16; signed long long v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16s_BFs16ll_BFu16ll_BFu16ll { signed short v1:16; signed long long v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16ll_BFu16ll_BFu16s { signed short v1:16; signed long long v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16s_BFs16ll_BFu16s { signed short v1:16; signed long long v2:16; unsigned short v3:16; };
struct BFs16s_BFs16ll_BFu16s_BFs16i { signed short v1:16; signed long long v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16s_BFs16ll_BFu16s_BFs16ll { signed short v1:16; signed long long v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16s_BFs16ll_BFu16s_BFs16s { signed short v1:16; signed long long v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16s_BFs16ll_BFu16s_BFu16i { signed short v1:16; signed long long v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16s_BFs16ll_BFu16s_BFu16ll { signed short v1:16; signed long long v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16ll_BFu16s_BFu16s { signed short v1:16; signed long long v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16s_BFs16s { signed short v1:16; signed short v2:16; };
struct BFs16s_BFs16s_BFs16i { signed short v1:16; signed short v2:16; signed int v3:16; };
struct BFs16s_BFs16s_BFs16i_BFs16i { signed short v1:16; signed short v2:16; signed int v3:16; signed int v4:16; };
struct BFs16s_BFs16s_BFs16i_BFs16ll { signed short v1:16; signed short v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16s_BFs16s_BFs16i_BFs16s { signed short v1:16; signed short v2:16; signed int v3:16; signed short v4:16; };
struct BFs16s_BFs16s_BFs16i_BFu16i { signed short v1:16; signed short v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16s_BFs16s_BFs16i_BFu16ll { signed short v1:16; signed short v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16s_BFs16i_BFu16s { signed short v1:16; signed short v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16s_BFs16s_BFs16ll { signed short v1:16; signed short v2:16; signed long long v3:16; };
struct BFs16s_BFs16s_BFs16ll_BFs16i { signed short v1:16; signed short v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16s_BFs16s_BFs16ll_BFs16ll { signed short v1:16; signed short v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16s_BFs16s_BFs16ll_BFs16s { signed short v1:16; signed short v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16s_BFs16s_BFs16ll_BFu16i { signed short v1:16; signed short v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16s_BFs16s_BFs16ll_BFu16ll { signed short v1:16; signed short v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16s_BFs16ll_BFu16s { signed short v1:16; signed short v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16s_BFs16s_BFs16s { signed short v1:16; signed short v2:16; signed short v3:16; };
struct BFs16s_BFs16s_BFs16s_BFs16i { signed short v1:16; signed short v2:16; signed short v3:16; signed int v4:16; };
struct BFs16s_BFs16s_BFs16s_BFs16ll { signed short v1:16; signed short v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16s_BFs16s_BFs16s_BFs16s { signed short v1:16; signed short v2:16; signed short v3:16; signed short v4:16; };
struct BFs16s_BFs16s_BFs16s_BFu16i { signed short v1:16; signed short v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16s_BFs16s_BFs16s_BFu16ll { signed short v1:16; signed short v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16s_BFs16s_BFu16s { signed short v1:16; signed short v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16s_BFs16s_BFu16i { signed short v1:16; signed short v2:16; unsigned int v3:16; };
struct BFs16s_BFs16s_BFu16i_BFs16i { signed short v1:16; signed short v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16s_BFs16s_BFu16i_BFs16ll { signed short v1:16; signed short v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16s_BFs16s_BFu16i_BFs16s { signed short v1:16; signed short v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16s_BFs16s_BFu16i_BFu16i { signed short v1:16; signed short v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16s_BFs16s_BFu16i_BFu16ll { signed short v1:16; signed short v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16s_BFu16i_BFu16s { signed short v1:16; signed short v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16s_BFs16s_BFu16ll { signed short v1:16; signed short v2:16; unsigned long long v3:16; };
struct BFs16s_BFs16s_BFu16ll_BFs16i { signed short v1:16; signed short v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16s_BFs16s_BFu16ll_BFs16ll { signed short v1:16; signed short v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16s_BFs16s_BFu16ll_BFs16s { signed short v1:16; signed short v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16s_BFs16s_BFu16ll_BFu16i { signed short v1:16; signed short v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16s_BFs16s_BFu16ll_BFu16ll { signed short v1:16; signed short v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16s_BFu16ll_BFu16s { signed short v1:16; signed short v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16s_BFs16s_BFu16s { signed short v1:16; signed short v2:16; unsigned short v3:16; };
struct BFs16s_BFs16s_BFu16s_BFs16i { signed short v1:16; signed short v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16s_BFs16s_BFu16s_BFs16ll { signed short v1:16; signed short v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16s_BFs16s_BFu16s_BFs16s { signed short v1:16; signed short v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16s_BFs16s_BFu16s_BFu16i { signed short v1:16; signed short v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16s_BFs16s_BFu16s_BFu16ll { signed short v1:16; signed short v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16s_BFs16s_BFu16s_BFu16s { signed short v1:16; signed short v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16s_BFu16i { signed short v1:16; unsigned int v2:16; };
struct BFs16s_BFu16i_BFs16i { signed short v1:16; unsigned int v2:16; signed int v3:16; };
struct BFs16s_BFu16i_BFs16i_BFs16i { signed short v1:16; unsigned int v2:16; signed int v3:16; signed int v4:16; };
struct BFs16s_BFu16i_BFs16i_BFs16ll { signed short v1:16; unsigned int v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16s_BFu16i_BFs16i_BFs16s { signed short v1:16; unsigned int v2:16; signed int v3:16; signed short v4:16; };
struct BFs16s_BFu16i_BFs16i_BFu16i { signed short v1:16; unsigned int v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16s_BFu16i_BFs16i_BFu16ll { signed short v1:16; unsigned int v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16i_BFs16i_BFu16s { signed short v1:16; unsigned int v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16s_BFu16i_BFs16ll { signed short v1:16; unsigned int v2:16; signed long long v3:16; };
struct BFs16s_BFu16i_BFs16ll_BFs16i { signed short v1:16; unsigned int v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16s_BFu16i_BFs16ll_BFs16ll { signed short v1:16; unsigned int v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16s_BFu16i_BFs16ll_BFs16s { signed short v1:16; unsigned int v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16s_BFu16i_BFs16ll_BFu16i { signed short v1:16; unsigned int v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16s_BFu16i_BFs16ll_BFu16ll { signed short v1:16; unsigned int v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16i_BFs16ll_BFu16s { signed short v1:16; unsigned int v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16s_BFu16i_BFs16s { signed short v1:16; unsigned int v2:16; signed short v3:16; };
struct BFs16s_BFu16i_BFs16s_BFs16i { signed short v1:16; unsigned int v2:16; signed short v3:16; signed int v4:16; };
struct BFs16s_BFu16i_BFs16s_BFs16ll { signed short v1:16; unsigned int v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16s_BFu16i_BFs16s_BFs16s { signed short v1:16; unsigned int v2:16; signed short v3:16; signed short v4:16; };
struct BFs16s_BFu16i_BFs16s_BFu16i { signed short v1:16; unsigned int v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16s_BFu16i_BFs16s_BFu16ll { signed short v1:16; unsigned int v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16i_BFs16s_BFu16s { signed short v1:16; unsigned int v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16s_BFu16i_BFu16i { signed short v1:16; unsigned int v2:16; unsigned int v3:16; };
struct BFs16s_BFu16i_BFu16i_BFs16i { signed short v1:16; unsigned int v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16s_BFu16i_BFu16i_BFs16ll { signed short v1:16; unsigned int v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16s_BFu16i_BFu16i_BFs16s { signed short v1:16; unsigned int v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16s_BFu16i_BFu16i_BFu16i { signed short v1:16; unsigned int v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16s_BFu16i_BFu16i_BFu16ll { signed short v1:16; unsigned int v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16i_BFu16i_BFu16s { signed short v1:16; unsigned int v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16s_BFu16i_BFu16ll { signed short v1:16; unsigned int v2:16; unsigned long long v3:16; };
struct BFs16s_BFu16i_BFu16ll_BFs16i { signed short v1:16; unsigned int v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16s_BFu16i_BFu16ll_BFs16ll { signed short v1:16; unsigned int v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16s_BFu16i_BFu16ll_BFs16s { signed short v1:16; unsigned int v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16s_BFu16i_BFu16ll_BFu16i { signed short v1:16; unsigned int v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16s_BFu16i_BFu16ll_BFu16ll { signed short v1:16; unsigned int v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16i_BFu16ll_BFu16s { signed short v1:16; unsigned int v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16s_BFu16i_BFu16s { signed short v1:16; unsigned int v2:16; unsigned short v3:16; };
struct BFs16s_BFu16i_BFu16s_BFs16i { signed short v1:16; unsigned int v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16s_BFu16i_BFu16s_BFs16ll { signed short v1:16; unsigned int v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16s_BFu16i_BFu16s_BFs16s { signed short v1:16; unsigned int v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16s_BFu16i_BFu16s_BFu16i { signed short v1:16; unsigned int v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16s_BFu16i_BFu16s_BFu16ll { signed short v1:16; unsigned int v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16i_BFu16s_BFu16s { signed short v1:16; unsigned int v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16s_BFu16ll { signed short v1:16; unsigned long long v2:16; };
struct BFs16s_BFu16ll_BFs16i { signed short v1:16; unsigned long long v2:16; signed int v3:16; };
struct BFs16s_BFu16ll_BFs16i_BFs16i { signed short v1:16; unsigned long long v2:16; signed int v3:16; signed int v4:16; };
struct BFs16s_BFu16ll_BFs16i_BFs16ll { signed short v1:16; unsigned long long v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16s_BFu16ll_BFs16i_BFs16s { signed short v1:16; unsigned long long v2:16; signed int v3:16; signed short v4:16; };
struct BFs16s_BFu16ll_BFs16i_BFu16i { signed short v1:16; unsigned long long v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16s_BFu16ll_BFs16i_BFu16ll { signed short v1:16; unsigned long long v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16ll_BFs16i_BFu16s { signed short v1:16; unsigned long long v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16s_BFu16ll_BFs16ll { signed short v1:16; unsigned long long v2:16; signed long long v3:16; };
struct BFs16s_BFu16ll_BFs16ll_BFs16i { signed short v1:16; unsigned long long v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16s_BFu16ll_BFs16ll_BFs16ll { signed short v1:16; unsigned long long v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16s_BFu16ll_BFs16ll_BFs16s { signed short v1:16; unsigned long long v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16s_BFu16ll_BFs16ll_BFu16i { signed short v1:16; unsigned long long v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16s_BFu16ll_BFs16ll_BFu16ll { signed short v1:16; unsigned long long v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16ll_BFs16ll_BFu16s { signed short v1:16; unsigned long long v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16s_BFu16ll_BFs16s { signed short v1:16; unsigned long long v2:16; signed short v3:16; };
struct BFs16s_BFu16ll_BFs16s_BFs16i { signed short v1:16; unsigned long long v2:16; signed short v3:16; signed int v4:16; };
struct BFs16s_BFu16ll_BFs16s_BFs16ll { signed short v1:16; unsigned long long v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16s_BFu16ll_BFs16s_BFs16s { signed short v1:16; unsigned long long v2:16; signed short v3:16; signed short v4:16; };
struct BFs16s_BFu16ll_BFs16s_BFu16i { signed short v1:16; unsigned long long v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16s_BFu16ll_BFs16s_BFu16ll { signed short v1:16; unsigned long long v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16ll_BFs16s_BFu16s { signed short v1:16; unsigned long long v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16s_BFu16ll_BFu16i { signed short v1:16; unsigned long long v2:16; unsigned int v3:16; };
struct BFs16s_BFu16ll_BFu16i_BFs16i { signed short v1:16; unsigned long long v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16s_BFu16ll_BFu16i_BFs16ll { signed short v1:16; unsigned long long v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16s_BFu16ll_BFu16i_BFs16s { signed short v1:16; unsigned long long v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16s_BFu16ll_BFu16i_BFu16i { signed short v1:16; unsigned long long v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16s_BFu16ll_BFu16i_BFu16ll { signed short v1:16; unsigned long long v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16ll_BFu16i_BFu16s { signed short v1:16; unsigned long long v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16s_BFu16ll_BFu16ll { signed short v1:16; unsigned long long v2:16; unsigned long long v3:16; };
struct BFs16s_BFu16ll_BFu16ll_BFs16i { signed short v1:16; unsigned long long v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16s_BFu16ll_BFu16ll_BFs16ll { signed short v1:16; unsigned long long v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16s_BFu16ll_BFu16ll_BFs16s { signed short v1:16; unsigned long long v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16s_BFu16ll_BFu16ll_BFu16i { signed short v1:16; unsigned long long v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16s_BFu16ll_BFu16ll_BFu16ll { signed short v1:16; unsigned long long v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16ll_BFu16ll_BFu16s { signed short v1:16; unsigned long long v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16s_BFu16ll_BFu16s { signed short v1:16; unsigned long long v2:16; unsigned short v3:16; };
struct BFs16s_BFu16ll_BFu16s_BFs16i { signed short v1:16; unsigned long long v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16s_BFu16ll_BFu16s_BFs16ll { signed short v1:16; unsigned long long v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16s_BFu16ll_BFu16s_BFs16s { signed short v1:16; unsigned long long v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16s_BFu16ll_BFu16s_BFu16i { signed short v1:16; unsigned long long v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16s_BFu16ll_BFu16s_BFu16ll { signed short v1:16; unsigned long long v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16ll_BFu16s_BFu16s { signed short v1:16; unsigned long long v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs16s_BFu16s { signed short v1:16; unsigned short v2:16; };
struct BFs16s_BFu16s_BFs16i { signed short v1:16; unsigned short v2:16; signed int v3:16; };
struct BFs16s_BFu16s_BFs16i_BFs16i { signed short v1:16; unsigned short v2:16; signed int v3:16; signed int v4:16; };
struct BFs16s_BFu16s_BFs16i_BFs16ll { signed short v1:16; unsigned short v2:16; signed int v3:16; signed long long v4:16; };
struct BFs16s_BFu16s_BFs16i_BFs16s { signed short v1:16; unsigned short v2:16; signed int v3:16; signed short v4:16; };
struct BFs16s_BFu16s_BFs16i_BFu16i { signed short v1:16; unsigned short v2:16; signed int v3:16; unsigned int v4:16; };
struct BFs16s_BFu16s_BFs16i_BFu16ll { signed short v1:16; unsigned short v2:16; signed int v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16s_BFs16i_BFu16s { signed short v1:16; unsigned short v2:16; signed int v3:16; unsigned short v4:16; };
struct BFs16s_BFu16s_BFs16ll { signed short v1:16; unsigned short v2:16; signed long long v3:16; };
struct BFs16s_BFu16s_BFs16ll_BFs16i { signed short v1:16; unsigned short v2:16; signed long long v3:16; signed int v4:16; };
struct BFs16s_BFu16s_BFs16ll_BFs16ll { signed short v1:16; unsigned short v2:16; signed long long v3:16; signed long long v4:16; };
struct BFs16s_BFu16s_BFs16ll_BFs16s { signed short v1:16; unsigned short v2:16; signed long long v3:16; signed short v4:16; };
struct BFs16s_BFu16s_BFs16ll_BFu16i { signed short v1:16; unsigned short v2:16; signed long long v3:16; unsigned int v4:16; };
struct BFs16s_BFu16s_BFs16ll_BFu16ll { signed short v1:16; unsigned short v2:16; signed long long v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16s_BFs16ll_BFu16s { signed short v1:16; unsigned short v2:16; signed long long v3:16; unsigned short v4:16; };
struct BFs16s_BFu16s_BFs16s { signed short v1:16; unsigned short v2:16; signed short v3:16; };
struct BFs16s_BFu16s_BFs16s_BFs16i { signed short v1:16; unsigned short v2:16; signed short v3:16; signed int v4:16; };
struct BFs16s_BFu16s_BFs16s_BFs16ll { signed short v1:16; unsigned short v2:16; signed short v3:16; signed long long v4:16; };
struct BFs16s_BFu16s_BFs16s_BFs16s { signed short v1:16; unsigned short v2:16; signed short v3:16; signed short v4:16; };
struct BFs16s_BFu16s_BFs16s_BFu16i { signed short v1:16; unsigned short v2:16; signed short v3:16; unsigned int v4:16; };
struct BFs16s_BFu16s_BFs16s_BFu16ll { signed short v1:16; unsigned short v2:16; signed short v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16s_BFs16s_BFu16s { signed short v1:16; unsigned short v2:16; signed short v3:16; unsigned short v4:16; };
struct BFs16s_BFu16s_BFu16i { signed short v1:16; unsigned short v2:16; unsigned int v3:16; };
struct BFs16s_BFu16s_BFu16i_BFs16i { signed short v1:16; unsigned short v2:16; unsigned int v3:16; signed int v4:16; };
struct BFs16s_BFu16s_BFu16i_BFs16ll { signed short v1:16; unsigned short v2:16; unsigned int v3:16; signed long long v4:16; };
struct BFs16s_BFu16s_BFu16i_BFs16s { signed short v1:16; unsigned short v2:16; unsigned int v3:16; signed short v4:16; };
struct BFs16s_BFu16s_BFu16i_BFu16i { signed short v1:16; unsigned short v2:16; unsigned int v3:16; unsigned int v4:16; };
struct BFs16s_BFu16s_BFu16i_BFu16ll { signed short v1:16; unsigned short v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16s_BFu16i_BFu16s { signed short v1:16; unsigned short v2:16; unsigned int v3:16; unsigned short v4:16; };
struct BFs16s_BFu16s_BFu16ll { signed short v1:16; unsigned short v2:16; unsigned long long v3:16; };
struct BFs16s_BFu16s_BFu16ll_BFs16i { signed short v1:16; unsigned short v2:16; unsigned long long v3:16; signed int v4:16; };
struct BFs16s_BFu16s_BFu16ll_BFs16ll { signed short v1:16; unsigned short v2:16; unsigned long long v3:16; signed long long v4:16; };
struct BFs16s_BFu16s_BFu16ll_BFs16s { signed short v1:16; unsigned short v2:16; unsigned long long v3:16; signed short v4:16; };
struct BFs16s_BFu16s_BFu16ll_BFu16i { signed short v1:16; unsigned short v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct BFs16s_BFu16s_BFu16ll_BFu16ll { signed short v1:16; unsigned short v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16s_BFu16ll_BFu16s { signed short v1:16; unsigned short v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct BFs16s_BFu16s_BFu16s { signed short v1:16; unsigned short v2:16; unsigned short v3:16; };
struct BFs16s_BFu16s_BFu16s_BFs16i { signed short v1:16; unsigned short v2:16; unsigned short v3:16; signed int v4:16; };
struct BFs16s_BFu16s_BFu16s_BFs16ll { signed short v1:16; unsigned short v2:16; unsigned short v3:16; signed long long v4:16; };
struct BFs16s_BFu16s_BFu16s_BFs16s { signed short v1:16; unsigned short v2:16; unsigned short v3:16; signed short v4:16; };
struct BFs16s_BFu16s_BFu16s_BFu16i { signed short v1:16; unsigned short v2:16; unsigned short v3:16; unsigned int v4:16; };
struct BFs16s_BFu16s_BFu16s_BFu16ll { signed short v1:16; unsigned short v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct BFs16s_BFu16s_BFu16s_BFu16s { signed short v1:16; unsigned short v2:16; unsigned short v3:16; unsigned short v4:16; };
struct BFs17i_BFs17i { signed int v1:17; signed int v2:17; };
struct BFs17i_BFs17i_BFs17i { signed int v1:17; signed int v2:17; signed int v3:17; };
struct BFs17i_BFs17i_BFs17i_BFs17i { signed int v1:17; signed int v2:17; signed int v3:17; signed int v4:17; };
struct BFs17i_BFs17i_BFs17i_BFs17ll { signed int v1:17; signed int v2:17; signed int v3:17; signed long long v4:17; };
struct BFs17i_BFs17i_BFs17i_BFu17i { signed int v1:17; signed int v2:17; signed int v3:17; unsigned int v4:17; };
struct BFs17i_BFs17i_BFs17i_BFu17ll { signed int v1:17; signed int v2:17; signed int v3:17; unsigned long long v4:17; };
struct BFs17i_BFs17i_BFs17ll { signed int v1:17; signed int v2:17; signed long long v3:17; };
struct BFs17i_BFs17i_BFs17ll_BFs17i { signed int v1:17; signed int v2:17; signed long long v3:17; signed int v4:17; };
struct BFs17i_BFs17i_BFs17ll_BFs17ll { signed int v1:17; signed int v2:17; signed long long v3:17; signed long long v4:17; };
struct BFs17i_BFs17i_BFs17ll_BFu17i { signed int v1:17; signed int v2:17; signed long long v3:17; unsigned int v4:17; };
struct BFs17i_BFs17i_BFs17ll_BFu17ll { signed int v1:17; signed int v2:17; signed long long v3:17; unsigned long long v4:17; };
struct BFs17i_BFs17i_BFu17i { signed int v1:17; signed int v2:17; unsigned int v3:17; };
struct BFs17i_BFs17i_BFu17i_BFs17i { signed int v1:17; signed int v2:17; unsigned int v3:17; signed int v4:17; };
struct BFs17i_BFs17i_BFu17i_BFs17ll { signed int v1:17; signed int v2:17; unsigned int v3:17; signed long long v4:17; };
struct BFs17i_BFs17i_BFu17i_BFu17i { signed int v1:17; signed int v2:17; unsigned int v3:17; unsigned int v4:17; };
struct BFs17i_BFs17i_BFu17i_BFu17ll { signed int v1:17; signed int v2:17; unsigned int v3:17; unsigned long long v4:17; };
struct BFs17i_BFs17i_BFu17ll { signed int v1:17; signed int v2:17; unsigned long long v3:17; };
struct BFs17i_BFs17i_BFu17ll_BFs17i { signed int v1:17; signed int v2:17; unsigned long long v3:17; signed int v4:17; };
struct BFs17i_BFs17i_BFu17ll_BFs17ll { signed int v1:17; signed int v2:17; unsigned long long v3:17; signed long long v4:17; };
struct BFs17i_BFs17i_BFu17ll_BFu17i { signed int v1:17; signed int v2:17; unsigned long long v3:17; unsigned int v4:17; };
struct BFs17i_BFs17i_BFu17ll_BFu17ll { signed int v1:17; signed int v2:17; unsigned long long v3:17; unsigned long long v4:17; };
struct BFs17i_BFs17ll { signed int v1:17; signed long long v2:17; };
struct BFs17i_BFs17ll_BFs17i { signed int v1:17; signed long long v2:17; signed int v3:17; };
struct BFs17i_BFs17ll_BFs17i_BFs17i { signed int v1:17; signed long long v2:17; signed int v3:17; signed int v4:17; };
struct BFs17i_BFs17ll_BFs17i_BFs17ll { signed int v1:17; signed long long v2:17; signed int v3:17; signed long long v4:17; };
struct BFs17i_BFs17ll_BFs17i_BFu17i { signed int v1:17; signed long long v2:17; signed int v3:17; unsigned int v4:17; };
struct BFs17i_BFs17ll_BFs17i_BFu17ll { signed int v1:17; signed long long v2:17; signed int v3:17; unsigned long long v4:17; };
struct BFs17i_BFs17ll_BFs17ll { signed int v1:17; signed long long v2:17; signed long long v3:17; };
struct BFs17i_BFs17ll_BFs17ll_BFs17i { signed int v1:17; signed long long v2:17; signed long long v3:17; signed int v4:17; };
struct BFs17i_BFs17ll_BFs17ll_BFs17ll { signed int v1:17; signed long long v2:17; signed long long v3:17; signed long long v4:17; };
struct BFs17i_BFs17ll_BFs17ll_BFu17i { signed int v1:17; signed long long v2:17; signed long long v3:17; unsigned int v4:17; };
struct BFs17i_BFs17ll_BFs17ll_BFu17ll { signed int v1:17; signed long long v2:17; signed long long v3:17; unsigned long long v4:17; };
struct BFs17i_BFs17ll_BFu17i { signed int v1:17; signed long long v2:17; unsigned int v3:17; };
struct BFs17i_BFs17ll_BFu17i_BFs17i { signed int v1:17; signed long long v2:17; unsigned int v3:17; signed int v4:17; };
struct BFs17i_BFs17ll_BFu17i_BFs17ll { signed int v1:17; signed long long v2:17; unsigned int v3:17; signed long long v4:17; };
struct BFs17i_BFs17ll_BFu17i_BFu17i { signed int v1:17; signed long long v2:17; unsigned int v3:17; unsigned int v4:17; };
struct BFs17i_BFs17ll_BFu17i_BFu17ll { signed int v1:17; signed long long v2:17; unsigned int v3:17; unsigned long long v4:17; };
struct BFs17i_BFs17ll_BFu17ll { signed int v1:17; signed long long v2:17; unsigned long long v3:17; };
struct BFs17i_BFs17ll_BFu17ll_BFs17i { signed int v1:17; signed long long v2:17; unsigned long long v3:17; signed int v4:17; };
struct BFs17i_BFs17ll_BFu17ll_BFs17ll { signed int v1:17; signed long long v2:17; unsigned long long v3:17; signed long long v4:17; };
struct BFs17i_BFs17ll_BFu17ll_BFu17i { signed int v1:17; signed long long v2:17; unsigned long long v3:17; unsigned int v4:17; };
struct BFs17i_BFs17ll_BFu17ll_BFu17ll { signed int v1:17; signed long long v2:17; unsigned long long v3:17; unsigned long long v4:17; };
struct BFs17i_BFu17i { signed int v1:17; unsigned int v2:17; };
struct BFs17i_BFu17i_BFs17i { signed int v1:17; unsigned int v2:17; signed int v3:17; };
struct BFs17i_BFu17i_BFs17i_BFs17i { signed int v1:17; unsigned int v2:17; signed int v3:17; signed int v4:17; };
struct BFs17i_BFu17i_BFs17i_BFs17ll { signed int v1:17; unsigned int v2:17; signed int v3:17; signed long long v4:17; };
struct BFs17i_BFu17i_BFs17i_BFu17i { signed int v1:17; unsigned int v2:17; signed int v3:17; unsigned int v4:17; };
struct BFs17i_BFu17i_BFs17i_BFu17ll { signed int v1:17; unsigned int v2:17; signed int v3:17; unsigned long long v4:17; };
struct BFs17i_BFu17i_BFs17ll { signed int v1:17; unsigned int v2:17; signed long long v3:17; };
struct BFs17i_BFu17i_BFs17ll_BFs17i { signed int v1:17; unsigned int v2:17; signed long long v3:17; signed int v4:17; };
struct BFs17i_BFu17i_BFs17ll_BFs17ll { signed int v1:17; unsigned int v2:17; signed long long v3:17; signed long long v4:17; };
struct BFs17i_BFu17i_BFs17ll_BFu17i { signed int v1:17; unsigned int v2:17; signed long long v3:17; unsigned int v4:17; };
struct BFs17i_BFu17i_BFs17ll_BFu17ll { signed int v1:17; unsigned int v2:17; signed long long v3:17; unsigned long long v4:17; };
struct BFs17i_BFu17i_BFu17i { signed int v1:17; unsigned int v2:17; unsigned int v3:17; };
struct BFs17i_BFu17i_BFu17i_BFs17i { signed int v1:17; unsigned int v2:17; unsigned int v3:17; signed int v4:17; };
struct BFs17i_BFu17i_BFu17i_BFs17ll { signed int v1:17; unsigned int v2:17; unsigned int v3:17; signed long long v4:17; };
struct BFs17i_BFu17i_BFu17i_BFu17i { signed int v1:17; unsigned int v2:17; unsigned int v3:17; unsigned int v4:17; };
struct BFs17i_BFu17i_BFu17i_BFu17ll { signed int v1:17; unsigned int v2:17; unsigned int v3:17; unsigned long long v4:17; };
struct BFs17i_BFu17i_BFu17ll { signed int v1:17; unsigned int v2:17; unsigned long long v3:17; };
struct BFs17i_BFu17i_BFu17ll_BFs17i { signed int v1:17; unsigned int v2:17; unsigned long long v3:17; signed int v4:17; };
struct BFs17i_BFu17i_BFu17ll_BFs17ll { signed int v1:17; unsigned int v2:17; unsigned long long v3:17; signed long long v4:17; };
struct BFs17i_BFu17i_BFu17ll_BFu17i { signed int v1:17; unsigned int v2:17; unsigned long long v3:17; unsigned int v4:17; };
struct BFs17i_BFu17i_BFu17ll_BFu17ll { signed int v1:17; unsigned int v2:17; unsigned long long v3:17; unsigned long long v4:17; };
struct BFs17i_BFu17ll { signed int v1:17; unsigned long long v2:17; };
struct BFs17i_BFu17ll_BFs17i { signed int v1:17; unsigned long long v2:17; signed int v3:17; };
struct BFs17i_BFu17ll_BFs17i_BFs17i { signed int v1:17; unsigned long long v2:17; signed int v3:17; signed int v4:17; };
struct BFs17i_BFu17ll_BFs17i_BFs17ll { signed int v1:17; unsigned long long v2:17; signed int v3:17; signed long long v4:17; };
struct BFs17i_BFu17ll_BFs17i_BFu17i { signed int v1:17; unsigned long long v2:17; signed int v3:17; unsigned int v4:17; };
struct BFs17i_BFu17ll_BFs17i_BFu17ll { signed int v1:17; unsigned long long v2:17; signed int v3:17; unsigned long long v4:17; };
struct BFs17i_BFu17ll_BFs17ll { signed int v1:17; unsigned long long v2:17; signed long long v3:17; };
struct BFs17i_BFu17ll_BFs17ll_BFs17i { signed int v1:17; unsigned long long v2:17; signed long long v3:17; signed int v4:17; };
struct BFs17i_BFu17ll_BFs17ll_BFs17ll { signed int v1:17; unsigned long long v2:17; signed long long v3:17; signed long long v4:17; };
struct BFs17i_BFu17ll_BFs17ll_BFu17i { signed int v1:17; unsigned long long v2:17; signed long long v3:17; unsigned int v4:17; };
struct BFs17i_BFu17ll_BFs17ll_BFu17ll { signed int v1:17; unsigned long long v2:17; signed long long v3:17; unsigned long long v4:17; };
struct BFs17i_BFu17ll_BFu17i { signed int v1:17; unsigned long long v2:17; unsigned int v3:17; };
struct BFs17i_BFu17ll_BFu17i_BFs17i { signed int v1:17; unsigned long long v2:17; unsigned int v3:17; signed int v4:17; };
struct BFs17i_BFu17ll_BFu17i_BFs17ll { signed int v1:17; unsigned long long v2:17; unsigned int v3:17; signed long long v4:17; };
struct BFs17i_BFu17ll_BFu17i_BFu17i { signed int v1:17; unsigned long long v2:17; unsigned int v3:17; unsigned int v4:17; };
struct BFs17i_BFu17ll_BFu17i_BFu17ll { signed int v1:17; unsigned long long v2:17; unsigned int v3:17; unsigned long long v4:17; };
struct BFs17i_BFu17ll_BFu17ll { signed int v1:17; unsigned long long v2:17; unsigned long long v3:17; };
struct BFs17i_BFu17ll_BFu17ll_BFs17i { signed int v1:17; unsigned long long v2:17; unsigned long long v3:17; signed int v4:17; };
struct BFs17i_BFu17ll_BFu17ll_BFs17ll { signed int v1:17; unsigned long long v2:17; unsigned long long v3:17; signed long long v4:17; };
struct BFs17i_BFu17ll_BFu17ll_BFu17i { signed int v1:17; unsigned long long v2:17; unsigned long long v3:17; unsigned int v4:17; };
struct BFs17i_BFu17ll_BFu17ll_BFu17ll { signed int v1:17; unsigned long long v2:17; unsigned long long v3:17; unsigned long long v4:17; };
struct BFs17ll_BFs17i { signed long long v1:17; signed int v2:17; };
struct BFs17ll_BFs17i_BFs17i { signed long long v1:17; signed int v2:17; signed int v3:17; };
struct BFs17ll_BFs17i_BFs17i_BFs17i { signed long long v1:17; signed int v2:17; signed int v3:17; signed int v4:17; };
struct BFs17ll_BFs17i_BFs17i_BFs17ll { signed long long v1:17; signed int v2:17; signed int v3:17; signed long long v4:17; };
struct BFs17ll_BFs17i_BFs17i_BFu17i { signed long long v1:17; signed int v2:17; signed int v3:17; unsigned int v4:17; };
struct BFs17ll_BFs17i_BFs17i_BFu17ll { signed long long v1:17; signed int v2:17; signed int v3:17; unsigned long long v4:17; };
struct BFs17ll_BFs17i_BFs17ll { signed long long v1:17; signed int v2:17; signed long long v3:17; };
struct BFs17ll_BFs17i_BFs17ll_BFs17i { signed long long v1:17; signed int v2:17; signed long long v3:17; signed int v4:17; };
struct BFs17ll_BFs17i_BFs17ll_BFs17ll { signed long long v1:17; signed int v2:17; signed long long v3:17; signed long long v4:17; };
struct BFs17ll_BFs17i_BFs17ll_BFu17i { signed long long v1:17; signed int v2:17; signed long long v3:17; unsigned int v4:17; };
struct BFs17ll_BFs17i_BFs17ll_BFu17ll { signed long long v1:17; signed int v2:17; signed long long v3:17; unsigned long long v4:17; };
struct BFs17ll_BFs17i_BFu17i { signed long long v1:17; signed int v2:17; unsigned int v3:17; };
struct BFs17ll_BFs17i_BFu17i_BFs17i { signed long long v1:17; signed int v2:17; unsigned int v3:17; signed int v4:17; };
struct BFs17ll_BFs17i_BFu17i_BFs17ll { signed long long v1:17; signed int v2:17; unsigned int v3:17; signed long long v4:17; };
struct BFs17ll_BFs17i_BFu17i_BFu17i { signed long long v1:17; signed int v2:17; unsigned int v3:17; unsigned int v4:17; };
struct BFs17ll_BFs17i_BFu17i_BFu17ll { signed long long v1:17; signed int v2:17; unsigned int v3:17; unsigned long long v4:17; };
struct BFs17ll_BFs17i_BFu17ll { signed long long v1:17; signed int v2:17; unsigned long long v3:17; };
struct BFs17ll_BFs17i_BFu17ll_BFs17i { signed long long v1:17; signed int v2:17; unsigned long long v3:17; signed int v4:17; };
struct BFs17ll_BFs17i_BFu17ll_BFs17ll { signed long long v1:17; signed int v2:17; unsigned long long v3:17; signed long long v4:17; };
struct BFs17ll_BFs17i_BFu17ll_BFu17i { signed long long v1:17; signed int v2:17; unsigned long long v3:17; unsigned int v4:17; };
struct BFs17ll_BFs17i_BFu17ll_BFu17ll { signed long long v1:17; signed int v2:17; unsigned long long v3:17; unsigned long long v4:17; };
struct BFs17ll_BFs17ll { signed long long v1:17; signed long long v2:17; };
struct BFs17ll_BFs17ll_BFs17i { signed long long v1:17; signed long long v2:17; signed int v3:17; };
struct BFs17ll_BFs17ll_BFs17i_BFs17i { signed long long v1:17; signed long long v2:17; signed int v3:17; signed int v4:17; };
struct BFs17ll_BFs17ll_BFs17i_BFs17ll { signed long long v1:17; signed long long v2:17; signed int v3:17; signed long long v4:17; };
struct BFs17ll_BFs17ll_BFs17i_BFu17i { signed long long v1:17; signed long long v2:17; signed int v3:17; unsigned int v4:17; };
struct BFs17ll_BFs17ll_BFs17i_BFu17ll { signed long long v1:17; signed long long v2:17; signed int v3:17; unsigned long long v4:17; };
struct BFs17ll_BFs17ll_BFs17ll { signed long long v1:17; signed long long v2:17; signed long long v3:17; };
struct BFs17ll_BFs17ll_BFs17ll_BFs17i { signed long long v1:17; signed long long v2:17; signed long long v3:17; signed int v4:17; };
struct BFs17ll_BFs17ll_BFs17ll_BFs17ll { signed long long v1:17; signed long long v2:17; signed long long v3:17; signed long long v4:17; };
struct BFs17ll_BFs17ll_BFs17ll_BFu17i { signed long long v1:17; signed long long v2:17; signed long long v3:17; unsigned int v4:17; };
struct BFs17ll_BFs17ll_BFs17ll_BFu17ll { signed long long v1:17; signed long long v2:17; signed long long v3:17; unsigned long long v4:17; };
struct BFs17ll_BFs17ll_BFu17i { signed long long v1:17; signed long long v2:17; unsigned int v3:17; };
struct BFs17ll_BFs17ll_BFu17i_BFs17i { signed long long v1:17; signed long long v2:17; unsigned int v3:17; signed int v4:17; };
struct BFs17ll_BFs17ll_BFu17i_BFs17ll { signed long long v1:17; signed long long v2:17; unsigned int v3:17; signed long long v4:17; };
struct BFs17ll_BFs17ll_BFu17i_BFu17i { signed long long v1:17; signed long long v2:17; unsigned int v3:17; unsigned int v4:17; };
struct BFs17ll_BFs17ll_BFu17i_BFu17ll { signed long long v1:17; signed long long v2:17; unsigned int v3:17; unsigned long long v4:17; };
struct BFs17ll_BFs17ll_BFu17ll { signed long long v1:17; signed long long v2:17; unsigned long long v3:17; };
struct BFs17ll_BFs17ll_BFu17ll_BFs17i { signed long long v1:17; signed long long v2:17; unsigned long long v3:17; signed int v4:17; };
struct BFs17ll_BFs17ll_BFu17ll_BFs17ll { signed long long v1:17; signed long long v2:17; unsigned long long v3:17; signed long long v4:17; };
struct BFs17ll_BFs17ll_BFu17ll_BFu17i { signed long long v1:17; signed long long v2:17; unsigned long long v3:17; unsigned int v4:17; };
struct BFs17ll_BFs17ll_BFu17ll_BFu17ll { signed long long v1:17; signed long long v2:17; unsigned long long v3:17; unsigned long long v4:17; };
struct BFs17ll_BFu17i { signed long long v1:17; unsigned int v2:17; };
struct BFs17ll_BFu17i_BFs17i { signed long long v1:17; unsigned int v2:17; signed int v3:17; };
struct BFs17ll_BFu17i_BFs17i_BFs17i { signed long long v1:17; unsigned int v2:17; signed int v3:17; signed int v4:17; };
struct BFs17ll_BFu17i_BFs17i_BFs17ll { signed long long v1:17; unsigned int v2:17; signed int v3:17; signed long long v4:17; };
struct BFs17ll_BFu17i_BFs17i_BFu17i { signed long long v1:17; unsigned int v2:17; signed int v3:17; unsigned int v4:17; };
struct BFs17ll_BFu17i_BFs17i_BFu17ll { signed long long v1:17; unsigned int v2:17; signed int v3:17; unsigned long long v4:17; };
struct BFs17ll_BFu17i_BFs17ll { signed long long v1:17; unsigned int v2:17; signed long long v3:17; };
struct BFs17ll_BFu17i_BFs17ll_BFs17i { signed long long v1:17; unsigned int v2:17; signed long long v3:17; signed int v4:17; };
struct BFs17ll_BFu17i_BFs17ll_BFs17ll { signed long long v1:17; unsigned int v2:17; signed long long v3:17; signed long long v4:17; };
struct BFs17ll_BFu17i_BFs17ll_BFu17i { signed long long v1:17; unsigned int v2:17; signed long long v3:17; unsigned int v4:17; };
struct BFs17ll_BFu17i_BFs17ll_BFu17ll { signed long long v1:17; unsigned int v2:17; signed long long v3:17; unsigned long long v4:17; };
struct BFs17ll_BFu17i_BFu17i { signed long long v1:17; unsigned int v2:17; unsigned int v3:17; };
struct BFs17ll_BFu17i_BFu17i_BFs17i { signed long long v1:17; unsigned int v2:17; unsigned int v3:17; signed int v4:17; };
struct BFs17ll_BFu17i_BFu17i_BFs17ll { signed long long v1:17; unsigned int v2:17; unsigned int v3:17; signed long long v4:17; };
struct BFs17ll_BFu17i_BFu17i_BFu17i { signed long long v1:17; unsigned int v2:17; unsigned int v3:17; unsigned int v4:17; };
struct BFs17ll_BFu17i_BFu17i_BFu17ll { signed long long v1:17; unsigned int v2:17; unsigned int v3:17; unsigned long long v4:17; };
struct BFs17ll_BFu17i_BFu17ll { signed long long v1:17; unsigned int v2:17; unsigned long long v3:17; };
struct BFs17ll_BFu17i_BFu17ll_BFs17i { signed long long v1:17; unsigned int v2:17; unsigned long long v3:17; signed int v4:17; };
struct BFs17ll_BFu17i_BFu17ll_BFs17ll { signed long long v1:17; unsigned int v2:17; unsigned long long v3:17; signed long long v4:17; };
struct BFs17ll_BFu17i_BFu17ll_BFu17i { signed long long v1:17; unsigned int v2:17; unsigned long long v3:17; unsigned int v4:17; };
struct BFs17ll_BFu17i_BFu17ll_BFu17ll { signed long long v1:17; unsigned int v2:17; unsigned long long v3:17; unsigned long long v4:17; };
struct BFs17ll_BFu17ll { signed long long v1:17; unsigned long long v2:17; };
struct BFs17ll_BFu17ll_BFs17i { signed long long v1:17; unsigned long long v2:17; signed int v3:17; };
struct BFs17ll_BFu17ll_BFs17i_BFs17i { signed long long v1:17; unsigned long long v2:17; signed int v3:17; signed int v4:17; };
struct BFs17ll_BFu17ll_BFs17i_BFs17ll { signed long long v1:17; unsigned long long v2:17; signed int v3:17; signed long long v4:17; };
struct BFs17ll_BFu17ll_BFs17i_BFu17i { signed long long v1:17; unsigned long long v2:17; signed int v3:17; unsigned int v4:17; };
struct BFs17ll_BFu17ll_BFs17i_BFu17ll { signed long long v1:17; unsigned long long v2:17; signed int v3:17; unsigned long long v4:17; };
struct BFs17ll_BFu17ll_BFs17ll { signed long long v1:17; unsigned long long v2:17; signed long long v3:17; };
struct BFs17ll_BFu17ll_BFs17ll_BFs17i { signed long long v1:17; unsigned long long v2:17; signed long long v3:17; signed int v4:17; };
struct BFs17ll_BFu17ll_BFs17ll_BFs17ll { signed long long v1:17; unsigned long long v2:17; signed long long v3:17; signed long long v4:17; };
struct BFs17ll_BFu17ll_BFs17ll_BFu17i { signed long long v1:17; unsigned long long v2:17; signed long long v3:17; unsigned int v4:17; };
struct BFs17ll_BFu17ll_BFs17ll_BFu17ll { signed long long v1:17; unsigned long long v2:17; signed long long v3:17; unsigned long long v4:17; };
struct BFs17ll_BFu17ll_BFu17i { signed long long v1:17; unsigned long long v2:17; unsigned int v3:17; };
struct BFs17ll_BFu17ll_BFu17i_BFs17i { signed long long v1:17; unsigned long long v2:17; unsigned int v3:17; signed int v4:17; };
struct BFs17ll_BFu17ll_BFu17i_BFs17ll { signed long long v1:17; unsigned long long v2:17; unsigned int v3:17; signed long long v4:17; };
struct BFs17ll_BFu17ll_BFu17i_BFu17i { signed long long v1:17; unsigned long long v2:17; unsigned int v3:17; unsigned int v4:17; };
struct BFs17ll_BFu17ll_BFu17i_BFu17ll { signed long long v1:17; unsigned long long v2:17; unsigned int v3:17; unsigned long long v4:17; };
struct BFs17ll_BFu17ll_BFu17ll { signed long long v1:17; unsigned long long v2:17; unsigned long long v3:17; };
struct BFs17ll_BFu17ll_BFu17ll_BFs17i { signed long long v1:17; unsigned long long v2:17; unsigned long long v3:17; signed int v4:17; };
struct BFs17ll_BFu17ll_BFu17ll_BFs17ll { signed long long v1:17; unsigned long long v2:17; unsigned long long v3:17; signed long long v4:17; };
struct BFs17ll_BFu17ll_BFu17ll_BFu17i { signed long long v1:17; unsigned long long v2:17; unsigned long long v3:17; unsigned int v4:17; };
struct BFs17ll_BFu17ll_BFu17ll_BFu17ll { signed long long v1:17; unsigned long long v2:17; unsigned long long v3:17; unsigned long long v4:17; };
struct BFs1c_BFs1c { signed char v1:1; signed char v2:1; };
struct BFs1c_BFs1c_BFs1c { signed char v1:1; signed char v2:1; signed char v3:1; };
struct BFs1c_BFs1c_BFs1c_BFs1c { signed char v1:1; signed char v2:1; signed char v3:1; signed char v4:1; };
struct BFs1c_BFs1c_BFs1c_BFs1i { signed char v1:1; signed char v2:1; signed char v3:1; signed int v4:1; };
struct BFs1c_BFs1c_BFs1c_BFs1ll { signed char v1:1; signed char v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1c_BFs1c_BFs1c_BFs1s { signed char v1:1; signed char v2:1; signed char v3:1; signed short v4:1; };
struct BFs1c_BFs1c_BFs1c_BFu1c { signed char v1:1; signed char v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1c_BFs1c_BFs1c_BFu1i { signed char v1:1; signed char v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1c_BFs1c_BFs1c_BFu1ll { signed char v1:1; signed char v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1c_BFs1c_BFu1s { signed char v1:1; signed char v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1c_BFs1c_BFs1i { signed char v1:1; signed char v2:1; signed int v3:1; };
struct BFs1c_BFs1c_BFs1i_BFs1c { signed char v1:1; signed char v2:1; signed int v3:1; signed char v4:1; };
struct BFs1c_BFs1c_BFs1i_BFs1i { signed char v1:1; signed char v2:1; signed int v3:1; signed int v4:1; };
struct BFs1c_BFs1c_BFs1i_BFs1ll { signed char v1:1; signed char v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1c_BFs1c_BFs1i_BFs1s { signed char v1:1; signed char v2:1; signed int v3:1; signed short v4:1; };
struct BFs1c_BFs1c_BFs1i_BFu1c { signed char v1:1; signed char v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1c_BFs1c_BFs1i_BFu1i { signed char v1:1; signed char v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1c_BFs1c_BFs1i_BFu1ll { signed char v1:1; signed char v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1c_BFs1i_BFu1s { signed char v1:1; signed char v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1c_BFs1c_BFs1ll { signed char v1:1; signed char v2:1; signed long long v3:1; };
struct BFs1c_BFs1c_BFs1ll_BFs1c { signed char v1:1; signed char v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1c_BFs1c_BFs1ll_BFs1i { signed char v1:1; signed char v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1c_BFs1c_BFs1ll_BFs1ll { signed char v1:1; signed char v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1c_BFs1c_BFs1ll_BFs1s { signed char v1:1; signed char v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1c_BFs1c_BFs1ll_BFu1c { signed char v1:1; signed char v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1c_BFs1c_BFs1ll_BFu1i { signed char v1:1; signed char v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1c_BFs1c_BFs1ll_BFu1ll { signed char v1:1; signed char v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1c_BFs1ll_BFu1s { signed char v1:1; signed char v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1c_BFs1c_BFs1s { signed char v1:1; signed char v2:1; signed short v3:1; };
struct BFs1c_BFs1c_BFs1s_BFs1c { signed char v1:1; signed char v2:1; signed short v3:1; signed char v4:1; };
struct BFs1c_BFs1c_BFs1s_BFs1i { signed char v1:1; signed char v2:1; signed short v3:1; signed int v4:1; };
struct BFs1c_BFs1c_BFs1s_BFs1ll { signed char v1:1; signed char v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1c_BFs1c_BFs1s_BFs1s { signed char v1:1; signed char v2:1; signed short v3:1; signed short v4:1; };
struct BFs1c_BFs1c_BFs1s_BFu1c { signed char v1:1; signed char v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1c_BFs1c_BFs1s_BFu1i { signed char v1:1; signed char v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1c_BFs1c_BFs1s_BFu1ll { signed char v1:1; signed char v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1c_BFs1s_BFu1s { signed char v1:1; signed char v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1c_BFs1c_BFu1c { signed char v1:1; signed char v2:1; unsigned char v3:1; };
struct BFs1c_BFs1c_BFu1c_BFs1c { signed char v1:1; signed char v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1c_BFs1c_BFu1c_BFs1i { signed char v1:1; signed char v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1c_BFs1c_BFu1c_BFs1ll { signed char v1:1; signed char v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1c_BFs1c_BFu1c_BFs1s { signed char v1:1; signed char v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1c_BFs1c_BFu1c_BFu1c { signed char v1:1; signed char v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1c_BFs1c_BFu1c_BFu1i { signed char v1:1; signed char v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1c_BFs1c_BFu1c_BFu1ll { signed char v1:1; signed char v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1c_BFu1c_BFu1s { signed char v1:1; signed char v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1c_BFs1c_BFu1i { signed char v1:1; signed char v2:1; unsigned int v3:1; };
struct BFs1c_BFs1c_BFu1i_BFs1c { signed char v1:1; signed char v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1c_BFs1c_BFu1i_BFs1i { signed char v1:1; signed char v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1c_BFs1c_BFu1i_BFs1ll { signed char v1:1; signed char v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1c_BFs1c_BFu1i_BFs1s { signed char v1:1; signed char v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1c_BFs1c_BFu1i_BFu1c { signed char v1:1; signed char v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1c_BFs1c_BFu1i_BFu1i { signed char v1:1; signed char v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1c_BFs1c_BFu1i_BFu1ll { signed char v1:1; signed char v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1c_BFu1i_BFu1s { signed char v1:1; signed char v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1c_BFs1c_BFu1ll { signed char v1:1; signed char v2:1; unsigned long long v3:1; };
struct BFs1c_BFs1c_BFu1ll_BFs1c { signed char v1:1; signed char v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1c_BFs1c_BFu1ll_BFs1i { signed char v1:1; signed char v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1c_BFs1c_BFu1ll_BFs1ll { signed char v1:1; signed char v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1c_BFs1c_BFu1ll_BFs1s { signed char v1:1; signed char v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1c_BFs1c_BFu1ll_BFu1c { signed char v1:1; signed char v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1c_BFs1c_BFu1ll_BFu1i { signed char v1:1; signed char v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1c_BFs1c_BFu1ll_BFu1ll { signed char v1:1; signed char v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1c_BFu1ll_BFu1s { signed char v1:1; signed char v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1c_BFs1c_BFu1s { signed char v1:1; signed char v2:1; unsigned short v3:1; };
struct BFs1c_BFs1c_BFu1s_BFs1c { signed char v1:1; signed char v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1c_BFs1c_BFu1s_BFs1i { signed char v1:1; signed char v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1c_BFs1c_BFu1s_BFs1ll { signed char v1:1; signed char v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1c_BFs1c_BFu1s_BFs1s { signed char v1:1; signed char v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1c_BFs1c_BFu1s_BFu1c { signed char v1:1; signed char v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1c_BFs1c_BFu1s_BFu1i { signed char v1:1; signed char v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1c_BFs1c_BFu1s_BFu1ll { signed char v1:1; signed char v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1c_BFu1s_BFu1s { signed char v1:1; signed char v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1c_BFs1i { signed char v1:1; signed int v2:1; };
struct BFs1c_BFs1i_BFs1c { signed char v1:1; signed int v2:1; signed char v3:1; };
struct BFs1c_BFs1i_BFs1c_BFs1c { signed char v1:1; signed int v2:1; signed char v3:1; signed char v4:1; };
struct BFs1c_BFs1i_BFs1c_BFs1i { signed char v1:1; signed int v2:1; signed char v3:1; signed int v4:1; };
struct BFs1c_BFs1i_BFs1c_BFs1ll { signed char v1:1; signed int v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1c_BFs1i_BFs1c_BFs1s { signed char v1:1; signed int v2:1; signed char v3:1; signed short v4:1; };
struct BFs1c_BFs1i_BFs1c_BFu1c { signed char v1:1; signed int v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1c_BFs1i_BFs1c_BFu1i { signed char v1:1; signed int v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1c_BFs1i_BFs1c_BFu1ll { signed char v1:1; signed int v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1i_BFs1c_BFu1s { signed char v1:1; signed int v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1c_BFs1i_BFs1i { signed char v1:1; signed int v2:1; signed int v3:1; };
struct BFs1c_BFs1i_BFs1i_BFs1c { signed char v1:1; signed int v2:1; signed int v3:1; signed char v4:1; };
struct BFs1c_BFs1i_BFs1i_BFs1i { signed char v1:1; signed int v2:1; signed int v3:1; signed int v4:1; };
struct BFs1c_BFs1i_BFs1i_BFs1ll { signed char v1:1; signed int v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1c_BFs1i_BFs1i_BFs1s { signed char v1:1; signed int v2:1; signed int v3:1; signed short v4:1; };
struct BFs1c_BFs1i_BFs1i_BFu1c { signed char v1:1; signed int v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1c_BFs1i_BFs1i_BFu1i { signed char v1:1; signed int v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1c_BFs1i_BFs1i_BFu1ll { signed char v1:1; signed int v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1i_BFs1i_BFu1s { signed char v1:1; signed int v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1c_BFs1i_BFs1ll { signed char v1:1; signed int v2:1; signed long long v3:1; };
struct BFs1c_BFs1i_BFs1ll_BFs1c { signed char v1:1; signed int v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1c_BFs1i_BFs1ll_BFs1i { signed char v1:1; signed int v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1c_BFs1i_BFs1ll_BFs1ll { signed char v1:1; signed int v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1c_BFs1i_BFs1ll_BFs1s { signed char v1:1; signed int v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1c_BFs1i_BFs1ll_BFu1c { signed char v1:1; signed int v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1c_BFs1i_BFs1ll_BFu1i { signed char v1:1; signed int v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1c_BFs1i_BFs1ll_BFu1ll { signed char v1:1; signed int v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1i_BFs1ll_BFu1s { signed char v1:1; signed int v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1c_BFs1i_BFs1s { signed char v1:1; signed int v2:1; signed short v3:1; };
struct BFs1c_BFs1i_BFs1s_BFs1c { signed char v1:1; signed int v2:1; signed short v3:1; signed char v4:1; };
struct BFs1c_BFs1i_BFs1s_BFs1i { signed char v1:1; signed int v2:1; signed short v3:1; signed int v4:1; };
struct BFs1c_BFs1i_BFs1s_BFs1ll { signed char v1:1; signed int v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1c_BFs1i_BFs1s_BFs1s { signed char v1:1; signed int v2:1; signed short v3:1; signed short v4:1; };
struct BFs1c_BFs1i_BFs1s_BFu1c { signed char v1:1; signed int v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1c_BFs1i_BFs1s_BFu1i { signed char v1:1; signed int v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1c_BFs1i_BFs1s_BFu1ll { signed char v1:1; signed int v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1i_BFs1s_BFu1s { signed char v1:1; signed int v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1c_BFs1i_BFu1c { signed char v1:1; signed int v2:1; unsigned char v3:1; };
struct BFs1c_BFs1i_BFu1c_BFs1c { signed char v1:1; signed int v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1c_BFs1i_BFu1c_BFs1i { signed char v1:1; signed int v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1c_BFs1i_BFu1c_BFs1ll { signed char v1:1; signed int v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1c_BFs1i_BFu1c_BFs1s { signed char v1:1; signed int v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1c_BFs1i_BFu1c_BFu1c { signed char v1:1; signed int v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1c_BFs1i_BFu1c_BFu1i { signed char v1:1; signed int v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1c_BFs1i_BFu1c_BFu1ll { signed char v1:1; signed int v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1i_BFu1c_BFu1s { signed char v1:1; signed int v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1c_BFs1i_BFu1i { signed char v1:1; signed int v2:1; unsigned int v3:1; };
struct BFs1c_BFs1i_BFu1i_BFs1c { signed char v1:1; signed int v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1c_BFs1i_BFu1i_BFs1i { signed char v1:1; signed int v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1c_BFs1i_BFu1i_BFs1ll { signed char v1:1; signed int v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1c_BFs1i_BFu1i_BFs1s { signed char v1:1; signed int v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1c_BFs1i_BFu1i_BFu1c { signed char v1:1; signed int v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1c_BFs1i_BFu1i_BFu1i { signed char v1:1; signed int v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1c_BFs1i_BFu1i_BFu1ll { signed char v1:1; signed int v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1i_BFu1i_BFu1s { signed char v1:1; signed int v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1c_BFs1i_BFu1ll { signed char v1:1; signed int v2:1; unsigned long long v3:1; };
struct BFs1c_BFs1i_BFu1ll_BFs1c { signed char v1:1; signed int v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1c_BFs1i_BFu1ll_BFs1i { signed char v1:1; signed int v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1c_BFs1i_BFu1ll_BFs1ll { signed char v1:1; signed int v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1c_BFs1i_BFu1ll_BFs1s { signed char v1:1; signed int v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1c_BFs1i_BFu1ll_BFu1c { signed char v1:1; signed int v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1c_BFs1i_BFu1ll_BFu1i { signed char v1:1; signed int v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1c_BFs1i_BFu1ll_BFu1ll { signed char v1:1; signed int v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1i_BFu1ll_BFu1s { signed char v1:1; signed int v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1c_BFs1i_BFu1s { signed char v1:1; signed int v2:1; unsigned short v3:1; };
struct BFs1c_BFs1i_BFu1s_BFs1c { signed char v1:1; signed int v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1c_BFs1i_BFu1s_BFs1i { signed char v1:1; signed int v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1c_BFs1i_BFu1s_BFs1ll { signed char v1:1; signed int v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1c_BFs1i_BFu1s_BFs1s { signed char v1:1; signed int v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1c_BFs1i_BFu1s_BFu1c { signed char v1:1; signed int v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1c_BFs1i_BFu1s_BFu1i { signed char v1:1; signed int v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1c_BFs1i_BFu1s_BFu1ll { signed char v1:1; signed int v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1i_BFu1s_BFu1s { signed char v1:1; signed int v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1c_BFs1ll { signed char v1:1; signed long long v2:1; };
struct BFs1c_BFs1ll_BFs1c { signed char v1:1; signed long long v2:1; signed char v3:1; };
struct BFs1c_BFs1ll_BFs1c_BFs1c { signed char v1:1; signed long long v2:1; signed char v3:1; signed char v4:1; };
struct BFs1c_BFs1ll_BFs1c_BFs1i { signed char v1:1; signed long long v2:1; signed char v3:1; signed int v4:1; };
struct BFs1c_BFs1ll_BFs1c_BFs1ll { signed char v1:1; signed long long v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1c_BFs1ll_BFs1c_BFs1s { signed char v1:1; signed long long v2:1; signed char v3:1; signed short v4:1; };
struct BFs1c_BFs1ll_BFs1c_BFu1c { signed char v1:1; signed long long v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1c_BFs1ll_BFs1c_BFu1i { signed char v1:1; signed long long v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1c_BFs1ll_BFs1c_BFu1ll { signed char v1:1; signed long long v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1ll_BFs1c_BFu1s { signed char v1:1; signed long long v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1c_BFs1ll_BFs1i { signed char v1:1; signed long long v2:1; signed int v3:1; };
struct BFs1c_BFs1ll_BFs1i_BFs1c { signed char v1:1; signed long long v2:1; signed int v3:1; signed char v4:1; };
struct BFs1c_BFs1ll_BFs1i_BFs1i { signed char v1:1; signed long long v2:1; signed int v3:1; signed int v4:1; };
struct BFs1c_BFs1ll_BFs1i_BFs1ll { signed char v1:1; signed long long v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1c_BFs1ll_BFs1i_BFs1s { signed char v1:1; signed long long v2:1; signed int v3:1; signed short v4:1; };
struct BFs1c_BFs1ll_BFs1i_BFu1c { signed char v1:1; signed long long v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1c_BFs1ll_BFs1i_BFu1i { signed char v1:1; signed long long v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1c_BFs1ll_BFs1i_BFu1ll { signed char v1:1; signed long long v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1ll_BFs1i_BFu1s { signed char v1:1; signed long long v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1c_BFs1ll_BFs1ll { signed char v1:1; signed long long v2:1; signed long long v3:1; };
struct BFs1c_BFs1ll_BFs1ll_BFs1c { signed char v1:1; signed long long v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1c_BFs1ll_BFs1ll_BFs1i { signed char v1:1; signed long long v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1c_BFs1ll_BFs1ll_BFs1ll { signed char v1:1; signed long long v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1c_BFs1ll_BFs1ll_BFs1s { signed char v1:1; signed long long v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1c_BFs1ll_BFs1ll_BFu1c { signed char v1:1; signed long long v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1c_BFs1ll_BFs1ll_BFu1i { signed char v1:1; signed long long v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1c_BFs1ll_BFs1ll_BFu1ll { signed char v1:1; signed long long v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1ll_BFs1ll_BFu1s { signed char v1:1; signed long long v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1c_BFs1ll_BFs1s { signed char v1:1; signed long long v2:1; signed short v3:1; };
struct BFs1c_BFs1ll_BFs1s_BFs1c { signed char v1:1; signed long long v2:1; signed short v3:1; signed char v4:1; };
struct BFs1c_BFs1ll_BFs1s_BFs1i { signed char v1:1; signed long long v2:1; signed short v3:1; signed int v4:1; };
struct BFs1c_BFs1ll_BFs1s_BFs1ll { signed char v1:1; signed long long v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1c_BFs1ll_BFs1s_BFs1s { signed char v1:1; signed long long v2:1; signed short v3:1; signed short v4:1; };
struct BFs1c_BFs1ll_BFs1s_BFu1c { signed char v1:1; signed long long v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1c_BFs1ll_BFs1s_BFu1i { signed char v1:1; signed long long v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1c_BFs1ll_BFs1s_BFu1ll { signed char v1:1; signed long long v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1ll_BFs1s_BFu1s { signed char v1:1; signed long long v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1c_BFs1ll_BFu1c { signed char v1:1; signed long long v2:1; unsigned char v3:1; };
struct BFs1c_BFs1ll_BFu1c_BFs1c { signed char v1:1; signed long long v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1c_BFs1ll_BFu1c_BFs1i { signed char v1:1; signed long long v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1c_BFs1ll_BFu1c_BFs1ll { signed char v1:1; signed long long v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1c_BFs1ll_BFu1c_BFs1s { signed char v1:1; signed long long v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1c_BFs1ll_BFu1c_BFu1c { signed char v1:1; signed long long v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1c_BFs1ll_BFu1c_BFu1i { signed char v1:1; signed long long v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1c_BFs1ll_BFu1c_BFu1ll { signed char v1:1; signed long long v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1ll_BFu1c_BFu1s { signed char v1:1; signed long long v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1c_BFs1ll_BFu1i { signed char v1:1; signed long long v2:1; unsigned int v3:1; };
struct BFs1c_BFs1ll_BFu1i_BFs1c { signed char v1:1; signed long long v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1c_BFs1ll_BFu1i_BFs1i { signed char v1:1; signed long long v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1c_BFs1ll_BFu1i_BFs1ll { signed char v1:1; signed long long v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1c_BFs1ll_BFu1i_BFs1s { signed char v1:1; signed long long v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1c_BFs1ll_BFu1i_BFu1c { signed char v1:1; signed long long v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1c_BFs1ll_BFu1i_BFu1i { signed char v1:1; signed long long v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1c_BFs1ll_BFu1i_BFu1ll { signed char v1:1; signed long long v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1ll_BFu1i_BFu1s { signed char v1:1; signed long long v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1c_BFs1ll_BFu1ll { signed char v1:1; signed long long v2:1; unsigned long long v3:1; };
struct BFs1c_BFs1ll_BFu1ll_BFs1c { signed char v1:1; signed long long v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1c_BFs1ll_BFu1ll_BFs1i { signed char v1:1; signed long long v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1c_BFs1ll_BFu1ll_BFs1ll { signed char v1:1; signed long long v2:1; unsigned long long v3:1; signed long long v4:1; };
struct BFs1c_BFs1ll_BFu1ll_BFs1s { signed char v1:1; signed long long v2:1; unsigned long long v3:1; signed short v4:1; };
struct BFs1c_BFs1ll_BFu1ll_BFu1c { signed char v1:1; signed long long v2:1; unsigned long long v3:1; unsigned char v4:1; };
struct BFs1c_BFs1ll_BFu1ll_BFu1i { signed char v1:1; signed long long v2:1; unsigned long long v3:1; unsigned int v4:1; };
struct BFs1c_BFs1ll_BFu1ll_BFu1ll { signed char v1:1; signed long long v2:1; unsigned long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1ll_BFu1ll_BFu1s { signed char v1:1; signed long long v2:1; unsigned long long v3:1; unsigned short v4:1; };
struct BFs1c_BFs1ll_BFu1s { signed char v1:1; signed long long v2:1; unsigned short v3:1; };
struct BFs1c_BFs1ll_BFu1s_BFs1c { signed char v1:1; signed long long v2:1; unsigned short v3:1; signed char v4:1; };
struct BFs1c_BFs1ll_BFu1s_BFs1i { signed char v1:1; signed long long v2:1; unsigned short v3:1; signed int v4:1; };
struct BFs1c_BFs1ll_BFu1s_BFs1ll { signed char v1:1; signed long long v2:1; unsigned short v3:1; signed long long v4:1; };
struct BFs1c_BFs1ll_BFu1s_BFs1s { signed char v1:1; signed long long v2:1; unsigned short v3:1; signed short v4:1; };
struct BFs1c_BFs1ll_BFu1s_BFu1c { signed char v1:1; signed long long v2:1; unsigned short v3:1; unsigned char v4:1; };
struct BFs1c_BFs1ll_BFu1s_BFu1i { signed char v1:1; signed long long v2:1; unsigned short v3:1; unsigned int v4:1; };
struct BFs1c_BFs1ll_BFu1s_BFu1ll { signed char v1:1; signed long long v2:1; unsigned short v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1ll_BFu1s_BFu1s { signed char v1:1; signed long long v2:1; unsigned short v3:1; unsigned short v4:1; };
struct BFs1c_BFs1s { signed char v1:1; signed short v2:1; };
struct BFs1c_BFs1s_BFs1c { signed char v1:1; signed short v2:1; signed char v3:1; };
struct BFs1c_BFs1s_BFs1c_BFs1c { signed char v1:1; signed short v2:1; signed char v3:1; signed char v4:1; };
struct BFs1c_BFs1s_BFs1c_BFs1i { signed char v1:1; signed short v2:1; signed char v3:1; signed int v4:1; };
struct BFs1c_BFs1s_BFs1c_BFs1ll { signed char v1:1; signed short v2:1; signed char v3:1; signed long long v4:1; };
struct BFs1c_BFs1s_BFs1c_BFs1s { signed char v1:1; signed short v2:1; signed char v3:1; signed short v4:1; };
struct BFs1c_BFs1s_BFs1c_BFu1c { signed char v1:1; signed short v2:1; signed char v3:1; unsigned char v4:1; };
struct BFs1c_BFs1s_BFs1c_BFu1i { signed char v1:1; signed short v2:1; signed char v3:1; unsigned int v4:1; };
struct BFs1c_BFs1s_BFs1c_BFu1ll { signed char v1:1; signed short v2:1; signed char v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1s_BFs1c_BFu1s { signed char v1:1; signed short v2:1; signed char v3:1; unsigned short v4:1; };
struct BFs1c_BFs1s_BFs1i { signed char v1:1; signed short v2:1; signed int v3:1; };
struct BFs1c_BFs1s_BFs1i_BFs1c { signed char v1:1; signed short v2:1; signed int v3:1; signed char v4:1; };
struct BFs1c_BFs1s_BFs1i_BFs1i { signed char v1:1; signed short v2:1; signed int v3:1; signed int v4:1; };
struct BFs1c_BFs1s_BFs1i_BFs1ll { signed char v1:1; signed short v2:1; signed int v3:1; signed long long v4:1; };
struct BFs1c_BFs1s_BFs1i_BFs1s { signed char v1:1; signed short v2:1; signed int v3:1; signed short v4:1; };
struct BFs1c_BFs1s_BFs1i_BFu1c { signed char v1:1; signed short v2:1; signed int v3:1; unsigned char v4:1; };
struct BFs1c_BFs1s_BFs1i_BFu1i { signed char v1:1; signed short v2:1; signed int v3:1; unsigned int v4:1; };
struct BFs1c_BFs1s_BFs1i_BFu1ll { signed char v1:1; signed short v2:1; signed int v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1s_BFs1i_BFu1s { signed char v1:1; signed short v2:1; signed int v3:1; unsigned short v4:1; };
struct BFs1c_BFs1s_BFs1ll { signed char v1:1; signed short v2:1; signed long long v3:1; };
struct BFs1c_BFs1s_BFs1ll_BFs1c { signed char v1:1; signed short v2:1; signed long long v3:1; signed char v4:1; };
struct BFs1c_BFs1s_BFs1ll_BFs1i { signed char v1:1; signed short v2:1; signed long long v3:1; signed int v4:1; };
struct BFs1c_BFs1s_BFs1ll_BFs1ll { signed char v1:1; signed short v2:1; signed long long v3:1; signed long long v4:1; };
struct BFs1c_BFs1s_BFs1ll_BFs1s { signed char v1:1; signed short v2:1; signed long long v3:1; signed short v4:1; };
struct BFs1c_BFs1s_BFs1ll_BFu1c { signed char v1:1; signed short v2:1; signed long long v3:1; unsigned char v4:1; };
struct BFs1c_BFs1s_BFs1ll_BFu1i { signed char v1:1; signed short v2:1; signed long long v3:1; unsigned int v4:1; };
struct BFs1c_BFs1s_BFs1ll_BFu1ll { signed char v1:1; signed short v2:1; signed long long v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1s_BFs1ll_BFu1s { signed char v1:1; signed short v2:1; signed long long v3:1; unsigned short v4:1; };
struct BFs1c_BFs1s_BFs1s { signed char v1:1; signed short v2:1; signed short v3:1; };
struct BFs1c_BFs1s_BFs1s_BFs1c { signed char v1:1; signed short v2:1; signed short v3:1; signed char v4:1; };
struct BFs1c_BFs1s_BFs1s_BFs1i { signed char v1:1; signed short v2:1; signed short v3:1; signed int v4:1; };
struct BFs1c_BFs1s_BFs1s_BFs1ll { signed char v1:1; signed short v2:1; signed short v3:1; signed long long v4:1; };
struct BFs1c_BFs1s_BFs1s_BFs1s { signed char v1:1; signed short v2:1; signed short v3:1; signed short v4:1; };
struct BFs1c_BFs1s_BFs1s_BFu1c { signed char v1:1; signed short v2:1; signed short v3:1; unsigned char v4:1; };
struct BFs1c_BFs1s_BFs1s_BFu1i { signed char v1:1; signed short v2:1; signed short v3:1; unsigned int v4:1; };
struct BFs1c_BFs1s_BFs1s_BFu1ll { signed char v1:1; signed short v2:1; signed short v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1s_BFs1s_BFu1s { signed char v1:1; signed short v2:1; signed short v3:1; unsigned short v4:1; };
struct BFs1c_BFs1s_BFu1c { signed char v1:1; signed short v2:1; unsigned char v3:1; };
struct BFs1c_BFs1s_BFu1c_BFs1c { signed char v1:1; signed short v2:1; unsigned char v3:1; signed char v4:1; };
struct BFs1c_BFs1s_BFu1c_BFs1i { signed char v1:1; signed short v2:1; unsigned char v3:1; signed int v4:1; };
struct BFs1c_BFs1s_BFu1c_BFs1ll { signed char v1:1; signed short v2:1; unsigned char v3:1; signed long long v4:1; };
struct BFs1c_BFs1s_BFu1c_BFs1s { signed char v1:1; signed short v2:1; unsigned char v3:1; signed short v4:1; };
struct BFs1c_BFs1s_BFu1c_BFu1c { signed char v1:1; signed short v2:1; unsigned char v3:1; unsigned char v4:1; };
struct BFs1c_BFs1s_BFu1c_BFu1i { signed char v1:1; signed short v2:1; unsigned char v3:1; unsigned int v4:1; };
struct BFs1c_BFs1s_BFu1c_BFu1ll { signed char v1:1; signed short v2:1; unsigned char v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1s_BFu1c_BFu1s { signed char v1:1; signed short v2:1; unsigned char v3:1; unsigned short v4:1; };
struct BFs1c_BFs1s_BFu1i { signed char v1:1; signed short v2:1; unsigned int v3:1; };
struct BFs1c_BFs1s_BFu1i_BFs1c { signed char v1:1; signed short v2:1; unsigned int v3:1; signed char v4:1; };
struct BFs1c_BFs1s_BFu1i_BFs1i { signed char v1:1; signed short v2:1; unsigned int v3:1; signed int v4:1; };
struct BFs1c_BFs1s_BFu1i_BFs1ll { signed char v1:1; signed short v2:1; unsigned int v3:1; signed long long v4:1; };
struct BFs1c_BFs1s_BFu1i_BFs1s { signed char v1:1; signed short v2:1; unsigned int v3:1; signed short v4:1; };
struct BFs1c_BFs1s_BFu1i_BFu1c { signed char v1:1; signed short v2:1; unsigned int v3:1; unsigned char v4:1; };
struct BFs1c_BFs1s_BFu1i_BFu1i { signed char v1:1; signed short v2:1; unsigned int v3:1; unsigned int v4:1; };
struct BFs1c_BFs1s_BFu1i_BFu1ll { signed char v1:1; signed short v2:1; unsigned int v3:1; unsigned long long v4:1; };
struct BFs1c_BFs1s_BFu1i_BFu1s { signed char v1:1; signed short v2:1; unsigned int v3:1; unsigned short v4:1; };
struct BFs1c_BFs1s_BFu1ll { signed char v1:1; signed short v2:1; unsigned long long v3:1; };
struct BFs1c_BFs1s_BFu1ll_BFs1c { signed char v1:1; signed short v2:1; unsigned long long v3:1; signed char v4:1; };
struct BFs1c_BFs1s_BFu1ll_BFs1i { signed char v1:1; signed short v2:1; unsigned long long v3:1; signed int v4:1; };
struct BFs1c_BFs1s_BFu1ll_BFs1ll { signed char v1:1; signed short v2:1; unsigned long long v3:1; signed long long v4:1; };


static void Test_aVp_BFu32ll_BFu7i()
{
  {
    init_simple_test("aVp_BFu32ll_BFu7i");
    static STRUCT_IF_C aVp_BFu32ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu32ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_BFu7i, aVp_BFu32ll_BFu7i)
//============================================================================



static void Test_aVp_BFu32ll_BFu7ll()
{
  {
    init_simple_test("aVp_BFu32ll_BFu7ll");
    static STRUCT_IF_C aVp_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_BFu7ll, aVp_BFu32ll_BFu7ll)
//============================================================================



static void Test_aVp_BFu32ll_BFu7s()
{
  {
    init_simple_test("aVp_BFu32ll_BFu7s");
    static STRUCT_IF_C aVp_BFu32ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu32ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_BFu7s, aVp_BFu32ll_BFu7s)
//============================================================================



static void Test_aVp_BFu32ll_BFu8c()
{
  {
    init_simple_test("aVp_BFu32ll_BFu8c");
    static STRUCT_IF_C aVp_BFu32ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu32ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_BFu8c, aVp_BFu32ll_BFu8c)
//============================================================================



static void Test_aVp_BFu32ll_BFu8i()
{
  {
    init_simple_test("aVp_BFu32ll_BFu8i");
    static STRUCT_IF_C aVp_BFu32ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu32ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_BFu8i, aVp_BFu32ll_BFu8i)
//============================================================================



static void Test_aVp_BFu32ll_BFu8ll()
{
  {
    init_simple_test("aVp_BFu32ll_BFu8ll");
    static STRUCT_IF_C aVp_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_BFu8ll, aVp_BFu32ll_BFu8ll)
//============================================================================



static void Test_aVp_BFu32ll_BFu8s()
{
  {
    init_simple_test("aVp_BFu32ll_BFu8s");
    static STRUCT_IF_C aVp_BFu32ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu32ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_BFu8s, aVp_BFu32ll_BFu8s)
//============================================================================



static void Test_aVp_BFu32ll_BFu9i()
{
  {
    init_simple_test("aVp_BFu32ll_BFu9i");
    static STRUCT_IF_C aVp_BFu32ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu32ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aVp_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aVp_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_BFu9i, aVp_BFu32ll_BFu9i)
//============================================================================



static void Test_aVp_BFu32ll_BFu9ll()
{
  {
    init_simple_test("aVp_BFu32ll_BFu9ll");
    static STRUCT_IF_C aVp_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aVp_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aVp_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_BFu9ll, aVp_BFu32ll_BFu9ll)
//============================================================================



static void Test_aVp_BFu32ll_BFu9s()
{
  {
    init_simple_test("aVp_BFu32ll_BFu9s");
    static STRUCT_IF_C aVp_BFu32ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu32ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aVp_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aVp_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_BFu9s, aVp_BFu32ll_BFu9s)
//============================================================================



static void Test_aVp_BFu32ll_C()
{
  {
    init_simple_test("aVp_BFu32ll_C");
    static STRUCT_IF_C aVp_BFu32ll_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu32ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_C");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_C, aVp_BFu32ll_C)
//============================================================================



static void Test_aVp_BFu32ll_D()
{
  {
    init_simple_test("aVp_BFu32ll_D");
    static STRUCT_IF_C aVp_BFu32ll_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_BFu32ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_D");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_D, aVp_BFu32ll_D)
//============================================================================



static void Test_aVp_BFu32ll_F()
{
  {
    init_simple_test("aVp_BFu32ll_F");
    static STRUCT_IF_C aVp_BFu32ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_BFu32ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_F, aVp_BFu32ll_F)
//============================================================================



static void Test_aVp_BFu32ll_I()
{
  {
    init_simple_test("aVp_BFu32ll_I");
    static STRUCT_IF_C aVp_BFu32ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_BFu32ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_I, aVp_BFu32ll_I)
//============================================================================



static void Test_aVp_BFu32ll_Ip()
{
  {
    init_simple_test("aVp_BFu32ll_Ip");
    static STRUCT_IF_C aVp_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_BFu32ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_Ip");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_Ip, aVp_BFu32ll_Ip)
//============================================================================



static void Test_aVp_BFu32ll_L()
{
  {
    init_simple_test("aVp_BFu32ll_L");
    static STRUCT_IF_C aVp_BFu32ll_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_BFu32ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_L");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_L, aVp_BFu32ll_L)
//============================================================================



static void Test_aVp_BFu32ll_S()
{
  {
    init_simple_test("aVp_BFu32ll_S");
    static STRUCT_IF_C aVp_BFu32ll_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu32ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_S, aVp_BFu32ll_S)
//============================================================================



static void Test_aVp_BFu32ll_Uc()
{
  {
    init_simple_test("aVp_BFu32ll_Uc");
    static STRUCT_IF_C aVp_BFu32ll_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu32ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_Uc");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_Uc, aVp_BFu32ll_Uc)
//============================================================================



static void Test_aVp_BFu32ll_Ui()
{
  {
    init_simple_test("aVp_BFu32ll_Ui");
    static STRUCT_IF_C aVp_BFu32ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_BFu32ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_Ui, aVp_BFu32ll_Ui)
//============================================================================



static void Test_aVp_BFu32ll_Ul()
{
  {
    init_simple_test("aVp_BFu32ll_Ul");
    static STRUCT_IF_C aVp_BFu32ll_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_BFu32ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_Ul");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_Ul, aVp_BFu32ll_Ul)
//============================================================================



static void Test_aVp_BFu32ll_Us()
{
  {
    init_simple_test("aVp_BFu32ll_Us");
    static STRUCT_IF_C aVp_BFu32ll_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu32ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_Us, aVp_BFu32ll_Us)
//============================================================================



static void Test_aVp_BFu32ll_Vp()
{
  {
    init_simple_test("aVp_BFu32ll_Vp");
    static STRUCT_IF_C aVp_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_BFu32ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "aVp_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aVp_BFu32ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aVp_BFu32ll_Vp");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu32ll_Vp, aVp_BFu32ll_Vp)
//============================================================================



static void Test_aVp_BFu33()
{
  {
    init_simple_test("aVp_BFu33");
    static STRUCT_IF_C aVp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33, aVp_BFu33)
//============================================================================



static void Test_aVp_BFu33_BFu15i()
{
  {
    init_simple_test("aVp_BFu33_BFu15i");
    static STRUCT_IF_C aVp_BFu33_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu33_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "aVp_BFu33_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "aVp_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu15i, aVp_BFu33_BFu15i)
//============================================================================



static void Test_aVp_BFu33_BFu15ll()
{
  {
    init_simple_test("aVp_BFu33_BFu15ll");
    static STRUCT_IF_C aVp_BFu33_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu33_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "aVp_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "aVp_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu15ll, aVp_BFu33_BFu15ll)
//============================================================================



static void Test_aVp_BFu33_BFu15s()
{
  {
    init_simple_test("aVp_BFu33_BFu15s");
    static STRUCT_IF_C aVp_BFu33_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu33_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "aVp_BFu33_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "aVp_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu15s, aVp_BFu33_BFu15s)
//============================================================================



static void Test_aVp_BFu33_BFu16i()
{
  {
    init_simple_test("aVp_BFu33_BFu16i");
    static STRUCT_IF_C aVp_BFu33_BFu16i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_BFu33_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "aVp_BFu33_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "aVp_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu16i, aVp_BFu33_BFu16i)
//============================================================================



static void Test_aVp_BFu33_BFu16ll()
{
  {
    init_simple_test("aVp_BFu33_BFu16ll");
    static STRUCT_IF_C aVp_BFu33_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_BFu33_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "aVp_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "aVp_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu16ll, aVp_BFu33_BFu16ll)
//============================================================================



static void Test_aVp_BFu33_BFu16s()
{
  {
    init_simple_test("aVp_BFu33_BFu16s");
    static STRUCT_IF_C aVp_BFu33_BFu16s lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_BFu33_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "aVp_BFu33_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "aVp_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu16s, aVp_BFu33_BFu16s)
//============================================================================



static void Test_aVp_BFu33_BFu17i()
{
  {
    init_simple_test("aVp_BFu33_BFu17i");
    static STRUCT_IF_C aVp_BFu33_BFu17i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_BFu33_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, 1, "aVp_BFu33_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, hide_ull(1LL<<16), "aVp_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu17i, aVp_BFu33_BFu17i)
//============================================================================



static void Test_aVp_BFu33_BFu17ll()
{
  {
    init_simple_test("aVp_BFu33_BFu17ll");
    static STRUCT_IF_C aVp_BFu33_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_BFu33_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, 1, "aVp_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, hide_ull(1LL<<16), "aVp_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu17ll, aVp_BFu33_BFu17ll)
//============================================================================



static void Test_aVp_BFu33_BFu1c()
{
  {
    init_simple_test("aVp_BFu33_BFu1c");
    static STRUCT_IF_C aVp_BFu33_BFu1c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu33_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "aVp_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu1c, aVp_BFu33_BFu1c)
//============================================================================



static void Test_aVp_BFu33_BFu1i()
{
  {
    init_simple_test("aVp_BFu33_BFu1i");
    static STRUCT_IF_C aVp_BFu33_BFu1i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu33_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "aVp_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu1i, aVp_BFu33_BFu1i)
//============================================================================



static void Test_aVp_BFu33_BFu1ll()
{
  {
    init_simple_test("aVp_BFu33_BFu1ll");
    static STRUCT_IF_C aVp_BFu33_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu33_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "aVp_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu1ll, aVp_BFu33_BFu1ll)
//============================================================================



static void Test_aVp_BFu33_BFu1s()
{
  {
    init_simple_test("aVp_BFu33_BFu1s");
    static STRUCT_IF_C aVp_BFu33_BFu1s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu33_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "aVp_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu1s, aVp_BFu33_BFu1s)
//============================================================================



static void Test_aVp_BFu33_BFu31i()
{
  {
    init_simple_test("aVp_BFu33_BFu31i");
    static STRUCT_IF_C aVp_BFu33_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_BFu33_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, 1, "aVp_BFu33_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, hide_ull(1LL<<30), "aVp_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu31i, aVp_BFu33_BFu31i)
//============================================================================



static void Test_aVp_BFu33_BFu31ll()
{
  {
    init_simple_test("aVp_BFu33_BFu31ll");
    static STRUCT_IF_C aVp_BFu33_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_BFu33_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, 1, "aVp_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, hide_ull(1LL<<30), "aVp_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu31ll, aVp_BFu33_BFu31ll)
//============================================================================



static void Test_aVp_BFu33_BFu32i()
{
  {
    init_simple_test("aVp_BFu33_BFu32i");
    static STRUCT_IF_C aVp_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu33_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 32, 1, "aVp_BFu33_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 32, hide_ull(1LL<<31), "aVp_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu32i, aVp_BFu33_BFu32i)
//============================================================================



static void Test_aVp_BFu33_BFu32ll()
{
  {
    init_simple_test("aVp_BFu33_BFu32ll");
    static STRUCT_IF_C aVp_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu33_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 32, 1, "aVp_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 32, hide_ull(1LL<<31), "aVp_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu32ll, aVp_BFu33_BFu32ll)
//============================================================================



static void Test_aVp_BFu33_BFu33()
{
  {
    init_simple_test("aVp_BFu33_BFu33");
    static STRUCT_IF_C aVp_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu33_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 33, 1, "aVp_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu33, aVp_BFu33_BFu33)
//============================================================================



static void Test_aVp_BFu33_BFu7c()
{
  {
    init_simple_test("aVp_BFu33_BFu7c");
    static STRUCT_IF_C aVp_BFu33_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu33_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "aVp_BFu33_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "aVp_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu7c, aVp_BFu33_BFu7c)
//============================================================================



static void Test_aVp_BFu33_BFu7i()
{
  {
    init_simple_test("aVp_BFu33_BFu7i");
    static STRUCT_IF_C aVp_BFu33_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu33_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "aVp_BFu33_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "aVp_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu7i, aVp_BFu33_BFu7i)
//============================================================================



static void Test_aVp_BFu33_BFu7ll()
{
  {
    init_simple_test("aVp_BFu33_BFu7ll");
    static STRUCT_IF_C aVp_BFu33_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu33_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "aVp_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "aVp_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu7ll, aVp_BFu33_BFu7ll)
//============================================================================



static void Test_aVp_BFu33_BFu7s()
{
  {
    init_simple_test("aVp_BFu33_BFu7s");
    static STRUCT_IF_C aVp_BFu33_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu33_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "aVp_BFu33_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "aVp_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu7s, aVp_BFu33_BFu7s)
//============================================================================



static void Test_aVp_BFu33_BFu8c()
{
  {
    init_simple_test("aVp_BFu33_BFu8c");
    static STRUCT_IF_C aVp_BFu33_BFu8c lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu33_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "aVp_BFu33_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "aVp_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu8c, aVp_BFu33_BFu8c)
//============================================================================



static void Test_aVp_BFu33_BFu8i()
{
  {
    init_simple_test("aVp_BFu33_BFu8i");
    static STRUCT_IF_C aVp_BFu33_BFu8i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu33_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "aVp_BFu33_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "aVp_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu8i, aVp_BFu33_BFu8i)
//============================================================================



static void Test_aVp_BFu33_BFu8ll()
{
  {
    init_simple_test("aVp_BFu33_BFu8ll");
    static STRUCT_IF_C aVp_BFu33_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu33_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "aVp_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "aVp_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu8ll, aVp_BFu33_BFu8ll)
//============================================================================



static void Test_aVp_BFu33_BFu8s()
{
  {
    init_simple_test("aVp_BFu33_BFu8s");
    static STRUCT_IF_C aVp_BFu33_BFu8s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu33_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "aVp_BFu33_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "aVp_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu8s, aVp_BFu33_BFu8s)
//============================================================================



static void Test_aVp_BFu33_BFu9i()
{
  {
    init_simple_test("aVp_BFu33_BFu9i");
    static STRUCT_IF_C aVp_BFu33_BFu9i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu33_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "aVp_BFu33_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "aVp_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu9i, aVp_BFu33_BFu9i)
//============================================================================



static void Test_aVp_BFu33_BFu9ll()
{
  {
    init_simple_test("aVp_BFu33_BFu9ll");
    static STRUCT_IF_C aVp_BFu33_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu33_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "aVp_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "aVp_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu9ll, aVp_BFu33_BFu9ll)
//============================================================================



static void Test_aVp_BFu33_BFu9s()
{
  {
    init_simple_test("aVp_BFu33_BFu9s");
    static STRUCT_IF_C aVp_BFu33_BFu9s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu33_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "aVp_BFu33_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "aVp_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_BFu9s, aVp_BFu33_BFu9s)
//============================================================================



static void Test_aVp_BFu33_C()
{
  {
    init_simple_test("aVp_BFu33_C");
    static STRUCT_IF_C aVp_BFu33_C lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu33_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_C)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_C");
    check_field_offset(lv, v3, ABISELECT(13,9), "aVp_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_C, aVp_BFu33_C)
//============================================================================



static void Test_aVp_BFu33_D()
{
  {
    init_simple_test("aVp_BFu33_D");
    static STRUCT_IF_C aVp_BFu33_D lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(aVp_BFu33_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_D)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_D");
    check_field_offset(lv, v3, ABISELECT(13,9), "aVp_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_D, aVp_BFu33_D)
//============================================================================



static void Test_aVp_BFu33_F()
{
  {
    init_simple_test("aVp_BFu33_F");
    static STRUCT_IF_C aVp_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu33_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_F)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_F");
    check_field_offset(lv, v3, ABISELECT(13,9), "aVp_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_F, aVp_BFu33_F)
//============================================================================



static void Test_aVp_BFu33_I()
{
  {
    init_simple_test("aVp_BFu33_I");
    static STRUCT_IF_C aVp_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu33_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_I)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_I");
    check_field_offset(lv, v3, ABISELECT(13,9), "aVp_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_I, aVp_BFu33_I)
//============================================================================



static void Test_aVp_BFu33_Ip()
{
  {
    init_simple_test("aVp_BFu33_Ip");
    static STRUCT_IF_C aVp_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(21,13), "sizeof(aVp_BFu33_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_Ip");
    check_field_offset(lv, v3, ABISELECT(13,9), "aVp_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_Ip, aVp_BFu33_Ip)
//============================================================================



static void Test_aVp_BFu33_L()
{
  {
    init_simple_test("aVp_BFu33_L");
    static STRUCT_IF_C aVp_BFu33_L lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(aVp_BFu33_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_L)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_L");
    check_field_offset(lv, v3, ABISELECT(13,9), "aVp_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_L, aVp_BFu33_L)
//============================================================================



static void Test_aVp_BFu33_S()
{
  {
    init_simple_test("aVp_BFu33_S");
    static STRUCT_IF_C aVp_BFu33_S lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_BFu33_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_S)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_S");
    check_field_offset(lv, v3, ABISELECT(13,9), "aVp_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_S, aVp_BFu33_S)
//============================================================================



static void Test_aVp_BFu33_Uc()
{
  {
    init_simple_test("aVp_BFu33_Uc");
    static STRUCT_IF_C aVp_BFu33_Uc lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu33_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_Uc");
    check_field_offset(lv, v3, ABISELECT(13,9), "aVp_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_Uc, aVp_BFu33_Uc)
//============================================================================



static void Test_aVp_BFu33_Ui()
{
  {
    init_simple_test("aVp_BFu33_Ui");
    static STRUCT_IF_C aVp_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu33_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_Ui");
    check_field_offset(lv, v3, ABISELECT(13,9), "aVp_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_Ui, aVp_BFu33_Ui)
//============================================================================



static void Test_aVp_BFu33_Ul()
{
  {
    init_simple_test("aVp_BFu33_Ul");
    static STRUCT_IF_C aVp_BFu33_Ul lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(aVp_BFu33_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_Ul");
    check_field_offset(lv, v3, ABISELECT(13,9), "aVp_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_Ul, aVp_BFu33_Ul)
//============================================================================



static void Test_aVp_BFu33_Us()
{
  {
    init_simple_test("aVp_BFu33_Us");
    static STRUCT_IF_C aVp_BFu33_Us lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_BFu33_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_Us)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_Us");
    check_field_offset(lv, v3, ABISELECT(13,9), "aVp_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_Us, aVp_BFu33_Us)
//============================================================================



static void Test_aVp_BFu33_Vp()
{
  {
    init_simple_test("aVp_BFu33_Vp");
    static STRUCT_IF_C aVp_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(21,13), "sizeof(aVp_BFu33_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "aVp_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aVp_BFu33_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aVp_BFu33_Vp");
    check_field_offset(lv, v3, ABISELECT(13,9), "aVp_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu33_Vp, aVp_BFu33_Vp)
//============================================================================



static void Test_aVp_BFu7c()
{
  {
    init_simple_test("aVp_BFu7c");
    static STRUCT_IF_C aVp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c, aVp_BFu7c)
//============================================================================



static void Test_aVp_BFu7c_BFu15i()
{
  {
    init_simple_test("aVp_BFu7c_BFu15i");
    static STRUCT_IF_C aVp_BFu7c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aVp_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aVp_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu15i, aVp_BFu7c_BFu15i)
//============================================================================



static void Test_aVp_BFu7c_BFu15ll()
{
  {
    init_simple_test("aVp_BFu7c_BFu15ll");
    static STRUCT_IF_C aVp_BFu7c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aVp_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aVp_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu15ll, aVp_BFu7c_BFu15ll)
//============================================================================



static void Test_aVp_BFu7c_BFu15s()
{
  {
    init_simple_test("aVp_BFu7c_BFu15s");
    static STRUCT_IF_C aVp_BFu7c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aVp_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aVp_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu15s, aVp_BFu7c_BFu15s)
//============================================================================



static void Test_aVp_BFu7c_BFu16i()
{
  {
    init_simple_test("aVp_BFu7c_BFu16i");
    static STRUCT_IF_C aVp_BFu7c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aVp_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aVp_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu16i, aVp_BFu7c_BFu16i)
//============================================================================



static void Test_aVp_BFu7c_BFu16ll()
{
  {
    init_simple_test("aVp_BFu7c_BFu16ll");
    static STRUCT_IF_C aVp_BFu7c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aVp_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aVp_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu16ll, aVp_BFu7c_BFu16ll)
//============================================================================



static void Test_aVp_BFu7c_BFu16s()
{
  {
    init_simple_test("aVp_BFu7c_BFu16s");
    static STRUCT_IF_C aVp_BFu7c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aVp_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aVp_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu16s, aVp_BFu7c_BFu16s)
//============================================================================



static void Test_aVp_BFu7c_BFu17i()
{
  {
    init_simple_test("aVp_BFu7c_BFu17i");
    static STRUCT_IF_C aVp_BFu7c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aVp_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aVp_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu17i, aVp_BFu7c_BFu17i)
//============================================================================



static void Test_aVp_BFu7c_BFu17ll()
{
  {
    init_simple_test("aVp_BFu7c_BFu17ll");
    static STRUCT_IF_C aVp_BFu7c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aVp_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aVp_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu17ll, aVp_BFu7c_BFu17ll)
//============================================================================



static void Test_aVp_BFu7c_BFu1c()
{
  {
    init_simple_test("aVp_BFu7c_BFu1c");
    static STRUCT_IF_C aVp_BFu7c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu1c, aVp_BFu7c_BFu1c)
//============================================================================



static void Test_aVp_BFu7c_BFu1i()
{
  {
    init_simple_test("aVp_BFu7c_BFu1i");
    static STRUCT_IF_C aVp_BFu7c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu1i, aVp_BFu7c_BFu1i)
//============================================================================



static void Test_aVp_BFu7c_BFu1ll()
{
  {
    init_simple_test("aVp_BFu7c_BFu1ll");
    static STRUCT_IF_C aVp_BFu7c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu1ll, aVp_BFu7c_BFu1ll)
//============================================================================



static void Test_aVp_BFu7c_BFu1s()
{
  {
    init_simple_test("aVp_BFu7c_BFu1s");
    static STRUCT_IF_C aVp_BFu7c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu1s, aVp_BFu7c_BFu1s)
//============================================================================



static void Test_aVp_BFu7c_BFu31i()
{
  {
    init_simple_test("aVp_BFu7c_BFu31i");
    static STRUCT_IF_C aVp_BFu7c_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aVp_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aVp_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu31i, aVp_BFu7c_BFu31i)
//============================================================================



static void Test_aVp_BFu7c_BFu31ll()
{
  {
    init_simple_test("aVp_BFu7c_BFu31ll");
    static STRUCT_IF_C aVp_BFu7c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aVp_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aVp_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu31ll, aVp_BFu7c_BFu31ll)
//============================================================================



static void Test_aVp_BFu7c_BFu32i()
{
  {
    init_simple_test("aVp_BFu7c_BFu32i");
    static STRUCT_IF_C aVp_BFu7c_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aVp_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aVp_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu32i, aVp_BFu7c_BFu32i)
//============================================================================



static void Test_aVp_BFu7c_BFu32ll()
{
  {
    init_simple_test("aVp_BFu7c_BFu32ll");
    static STRUCT_IF_C aVp_BFu7c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aVp_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aVp_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu32ll, aVp_BFu7c_BFu32ll)
//============================================================================



static void Test_aVp_BFu7c_BFu33()
{
  {
    init_simple_test("aVp_BFu7c_BFu33");
    static STRUCT_IF_C aVp_BFu7c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, 1, "aVp_BFu7c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, hide_ull(1LL<<32), "aVp_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu33, aVp_BFu7c_BFu33)
//============================================================================



static void Test_aVp_BFu7c_BFu7c()
{
  {
    init_simple_test("aVp_BFu7c_BFu7c");
    static STRUCT_IF_C aVp_BFu7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu7c, aVp_BFu7c_BFu7c)
//============================================================================



static void Test_aVp_BFu7c_BFu7i()
{
  {
    init_simple_test("aVp_BFu7c_BFu7i");
    static STRUCT_IF_C aVp_BFu7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu7i, aVp_BFu7c_BFu7i)
//============================================================================



static void Test_aVp_BFu7c_BFu7ll()
{
  {
    init_simple_test("aVp_BFu7c_BFu7ll");
    static STRUCT_IF_C aVp_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu7ll, aVp_BFu7c_BFu7ll)
//============================================================================



static void Test_aVp_BFu7c_BFu7s()
{
  {
    init_simple_test("aVp_BFu7c_BFu7s");
    static STRUCT_IF_C aVp_BFu7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu7s, aVp_BFu7c_BFu7s)
//============================================================================



static void Test_aVp_BFu7c_BFu8c()
{
  {
    init_simple_test("aVp_BFu7c_BFu8c");
    static STRUCT_IF_C aVp_BFu7c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu8c, aVp_BFu7c_BFu8c)
//============================================================================



static void Test_aVp_BFu7c_BFu8i()
{
  {
    init_simple_test("aVp_BFu7c_BFu8i");
    static STRUCT_IF_C aVp_BFu7c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu8i, aVp_BFu7c_BFu8i)
//============================================================================



static void Test_aVp_BFu7c_BFu8ll()
{
  {
    init_simple_test("aVp_BFu7c_BFu8ll");
    static STRUCT_IF_C aVp_BFu7c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu8ll, aVp_BFu7c_BFu8ll)
//============================================================================



static void Test_aVp_BFu7c_BFu8s()
{
  {
    init_simple_test("aVp_BFu7c_BFu8s");
    static STRUCT_IF_C aVp_BFu7c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu8s, aVp_BFu7c_BFu8s)
//============================================================================



static void Test_aVp_BFu7c_BFu9i()
{
  {
    init_simple_test("aVp_BFu7c_BFu9i");
    static STRUCT_IF_C aVp_BFu7c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aVp_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aVp_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu9i, aVp_BFu7c_BFu9i)
//============================================================================



static void Test_aVp_BFu7c_BFu9ll()
{
  {
    init_simple_test("aVp_BFu7c_BFu9ll");
    static STRUCT_IF_C aVp_BFu7c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aVp_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aVp_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu9ll, aVp_BFu7c_BFu9ll)
//============================================================================



static void Test_aVp_BFu7c_BFu9s()
{
  {
    init_simple_test("aVp_BFu7c_BFu9s");
    static STRUCT_IF_C aVp_BFu7c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aVp_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aVp_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_BFu9s, aVp_BFu7c_BFu9s)
//============================================================================



static void Test_aVp_BFu7c_C()
{
  {
    init_simple_test("aVp_BFu7c_C");
    static STRUCT_IF_C aVp_BFu7c_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_C)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_C, aVp_BFu7c_C)
//============================================================================



static void Test_aVp_BFu7c_D()
{
  {
    init_simple_test("aVp_BFu7c_D");
    static STRUCT_IF_C aVp_BFu7c_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu7c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_D)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_D, aVp_BFu7c_D)
//============================================================================



static void Test_aVp_BFu7c_F()
{
  {
    init_simple_test("aVp_BFu7c_F");
    static STRUCT_IF_C aVp_BFu7c_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_F)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_F, aVp_BFu7c_F)
//============================================================================



static void Test_aVp_BFu7c_I()
{
  {
    init_simple_test("aVp_BFu7c_I");
    static STRUCT_IF_C aVp_BFu7c_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_I)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_I, aVp_BFu7c_I)
//============================================================================



static void Test_aVp_BFu7c_Ip()
{
  {
    init_simple_test("aVp_BFu7c_Ip");
    static STRUCT_IF_C aVp_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu7c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_Ip, aVp_BFu7c_Ip)
//============================================================================



static void Test_aVp_BFu7c_L()
{
  {
    init_simple_test("aVp_BFu7c_L");
    static STRUCT_IF_C aVp_BFu7c_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_L)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_L, aVp_BFu7c_L)
//============================================================================



static void Test_aVp_BFu7c_S()
{
  {
    init_simple_test("aVp_BFu7c_S");
    static STRUCT_IF_C aVp_BFu7c_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_S)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_S, aVp_BFu7c_S)
//============================================================================



static void Test_aVp_BFu7c_Uc()
{
  {
    init_simple_test("aVp_BFu7c_Uc");
    static STRUCT_IF_C aVp_BFu7c_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_Uc, aVp_BFu7c_Uc)
//============================================================================



static void Test_aVp_BFu7c_Ui()
{
  {
    init_simple_test("aVp_BFu7c_Ui");
    static STRUCT_IF_C aVp_BFu7c_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_Ui, aVp_BFu7c_Ui)
//============================================================================



static void Test_aVp_BFu7c_Ul()
{
  {
    init_simple_test("aVp_BFu7c_Ul");
    static STRUCT_IF_C aVp_BFu7c_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_Ul, aVp_BFu7c_Ul)
//============================================================================



static void Test_aVp_BFu7c_Us()
{
  {
    init_simple_test("aVp_BFu7c_Us");
    static STRUCT_IF_C aVp_BFu7c_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_Us, aVp_BFu7c_Us)
//============================================================================



static void Test_aVp_BFu7c_Vp()
{
  {
    init_simple_test("aVp_BFu7c_Vp");
    static STRUCT_IF_C aVp_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "aVp_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7c_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7c_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7c_Vp, aVp_BFu7c_Vp)
//============================================================================



static void Test_aVp_BFu7i()
{
  {
    init_simple_test("aVp_BFu7i");
    static STRUCT_IF_C aVp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i, aVp_BFu7i)
//============================================================================



static void Test_aVp_BFu7i_BFu15i()
{
  {
    init_simple_test("aVp_BFu7i_BFu15i");
    static STRUCT_IF_C aVp_BFu7i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aVp_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aVp_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu15i, aVp_BFu7i_BFu15i)
//============================================================================



static void Test_aVp_BFu7i_BFu15ll()
{
  {
    init_simple_test("aVp_BFu7i_BFu15ll");
    static STRUCT_IF_C aVp_BFu7i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aVp_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aVp_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu15ll, aVp_BFu7i_BFu15ll)
//============================================================================



static void Test_aVp_BFu7i_BFu15s()
{
  {
    init_simple_test("aVp_BFu7i_BFu15s");
    static STRUCT_IF_C aVp_BFu7i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aVp_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aVp_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu15s, aVp_BFu7i_BFu15s)
//============================================================================



static void Test_aVp_BFu7i_BFu16i()
{
  {
    init_simple_test("aVp_BFu7i_BFu16i");
    static STRUCT_IF_C aVp_BFu7i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aVp_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aVp_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu16i, aVp_BFu7i_BFu16i)
//============================================================================



static void Test_aVp_BFu7i_BFu16ll()
{
  {
    init_simple_test("aVp_BFu7i_BFu16ll");
    static STRUCT_IF_C aVp_BFu7i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aVp_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aVp_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu16ll, aVp_BFu7i_BFu16ll)
//============================================================================



static void Test_aVp_BFu7i_BFu16s()
{
  {
    init_simple_test("aVp_BFu7i_BFu16s");
    static STRUCT_IF_C aVp_BFu7i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aVp_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aVp_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu16s, aVp_BFu7i_BFu16s)
//============================================================================



static void Test_aVp_BFu7i_BFu17i()
{
  {
    init_simple_test("aVp_BFu7i_BFu17i");
    static STRUCT_IF_C aVp_BFu7i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aVp_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aVp_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu17i, aVp_BFu7i_BFu17i)
//============================================================================



static void Test_aVp_BFu7i_BFu17ll()
{
  {
    init_simple_test("aVp_BFu7i_BFu17ll");
    static STRUCT_IF_C aVp_BFu7i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aVp_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aVp_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu17ll, aVp_BFu7i_BFu17ll)
//============================================================================



static void Test_aVp_BFu7i_BFu1c()
{
  {
    init_simple_test("aVp_BFu7i_BFu1c");
    static STRUCT_IF_C aVp_BFu7i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu1c, aVp_BFu7i_BFu1c)
//============================================================================



static void Test_aVp_BFu7i_BFu1i()
{
  {
    init_simple_test("aVp_BFu7i_BFu1i");
    static STRUCT_IF_C aVp_BFu7i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu1i, aVp_BFu7i_BFu1i)
//============================================================================



static void Test_aVp_BFu7i_BFu1ll()
{
  {
    init_simple_test("aVp_BFu7i_BFu1ll");
    static STRUCT_IF_C aVp_BFu7i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu1ll, aVp_BFu7i_BFu1ll)
//============================================================================



static void Test_aVp_BFu7i_BFu1s()
{
  {
    init_simple_test("aVp_BFu7i_BFu1s");
    static STRUCT_IF_C aVp_BFu7i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu1s, aVp_BFu7i_BFu1s)
//============================================================================



static void Test_aVp_BFu7i_BFu31i()
{
  {
    init_simple_test("aVp_BFu7i_BFu31i");
    static STRUCT_IF_C aVp_BFu7i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aVp_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aVp_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu31i, aVp_BFu7i_BFu31i)
//============================================================================



static void Test_aVp_BFu7i_BFu31ll()
{
  {
    init_simple_test("aVp_BFu7i_BFu31ll");
    static STRUCT_IF_C aVp_BFu7i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aVp_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aVp_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu31ll, aVp_BFu7i_BFu31ll)
//============================================================================



static void Test_aVp_BFu7i_BFu32i()
{
  {
    init_simple_test("aVp_BFu7i_BFu32i");
    static STRUCT_IF_C aVp_BFu7i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aVp_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aVp_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu32i, aVp_BFu7i_BFu32i)
//============================================================================



static void Test_aVp_BFu7i_BFu32ll()
{
  {
    init_simple_test("aVp_BFu7i_BFu32ll");
    static STRUCT_IF_C aVp_BFu7i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aVp_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aVp_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu32ll, aVp_BFu7i_BFu32ll)
//============================================================================



static void Test_aVp_BFu7i_BFu33()
{
  {
    init_simple_test("aVp_BFu7i_BFu33");
    static STRUCT_IF_C aVp_BFu7i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, 1, "aVp_BFu7i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, hide_ull(1LL<<32), "aVp_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu33, aVp_BFu7i_BFu33)
//============================================================================



static void Test_aVp_BFu7i_BFu7c()
{
  {
    init_simple_test("aVp_BFu7i_BFu7c");
    static STRUCT_IF_C aVp_BFu7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu7c, aVp_BFu7i_BFu7c)
//============================================================================



static void Test_aVp_BFu7i_BFu7i()
{
  {
    init_simple_test("aVp_BFu7i_BFu7i");
    static STRUCT_IF_C aVp_BFu7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu7i, aVp_BFu7i_BFu7i)
//============================================================================



static void Test_aVp_BFu7i_BFu7ll()
{
  {
    init_simple_test("aVp_BFu7i_BFu7ll");
    static STRUCT_IF_C aVp_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu7ll, aVp_BFu7i_BFu7ll)
//============================================================================



static void Test_aVp_BFu7i_BFu7s()
{
  {
    init_simple_test("aVp_BFu7i_BFu7s");
    static STRUCT_IF_C aVp_BFu7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu7s, aVp_BFu7i_BFu7s)
//============================================================================



static void Test_aVp_BFu7i_BFu8c()
{
  {
    init_simple_test("aVp_BFu7i_BFu8c");
    static STRUCT_IF_C aVp_BFu7i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu8c, aVp_BFu7i_BFu8c)
//============================================================================



static void Test_aVp_BFu7i_BFu8i()
{
  {
    init_simple_test("aVp_BFu7i_BFu8i");
    static STRUCT_IF_C aVp_BFu7i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu8i, aVp_BFu7i_BFu8i)
//============================================================================



static void Test_aVp_BFu7i_BFu8ll()
{
  {
    init_simple_test("aVp_BFu7i_BFu8ll");
    static STRUCT_IF_C aVp_BFu7i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu8ll, aVp_BFu7i_BFu8ll)
//============================================================================



static void Test_aVp_BFu7i_BFu8s()
{
  {
    init_simple_test("aVp_BFu7i_BFu8s");
    static STRUCT_IF_C aVp_BFu7i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu8s, aVp_BFu7i_BFu8s)
//============================================================================



static void Test_aVp_BFu7i_BFu9i()
{
  {
    init_simple_test("aVp_BFu7i_BFu9i");
    static STRUCT_IF_C aVp_BFu7i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aVp_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aVp_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu9i, aVp_BFu7i_BFu9i)
//============================================================================



static void Test_aVp_BFu7i_BFu9ll()
{
  {
    init_simple_test("aVp_BFu7i_BFu9ll");
    static STRUCT_IF_C aVp_BFu7i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aVp_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aVp_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu9ll, aVp_BFu7i_BFu9ll)
//============================================================================



static void Test_aVp_BFu7i_BFu9s()
{
  {
    init_simple_test("aVp_BFu7i_BFu9s");
    static STRUCT_IF_C aVp_BFu7i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aVp_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aVp_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_BFu9s, aVp_BFu7i_BFu9s)
//============================================================================



static void Test_aVp_BFu7i_C()
{
  {
    init_simple_test("aVp_BFu7i_C");
    static STRUCT_IF_C aVp_BFu7i_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_C)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_C, aVp_BFu7i_C)
//============================================================================



static void Test_aVp_BFu7i_D()
{
  {
    init_simple_test("aVp_BFu7i_D");
    static STRUCT_IF_C aVp_BFu7i_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_D)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_D, aVp_BFu7i_D)
//============================================================================



static void Test_aVp_BFu7i_F()
{
  {
    init_simple_test("aVp_BFu7i_F");
    static STRUCT_IF_C aVp_BFu7i_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_F)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_F, aVp_BFu7i_F)
//============================================================================



static void Test_aVp_BFu7i_I()
{
  {
    init_simple_test("aVp_BFu7i_I");
    static STRUCT_IF_C aVp_BFu7i_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_I)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_I, aVp_BFu7i_I)
//============================================================================



static void Test_aVp_BFu7i_Ip()
{
  {
    init_simple_test("aVp_BFu7i_Ip");
    static STRUCT_IF_C aVp_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_Ip, aVp_BFu7i_Ip)
//============================================================================



static void Test_aVp_BFu7i_L()
{
  {
    init_simple_test("aVp_BFu7i_L");
    static STRUCT_IF_C aVp_BFu7i_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_L)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_L, aVp_BFu7i_L)
//============================================================================



static void Test_aVp_BFu7i_S()
{
  {
    init_simple_test("aVp_BFu7i_S");
    static STRUCT_IF_C aVp_BFu7i_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_S)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_S, aVp_BFu7i_S)
//============================================================================



static void Test_aVp_BFu7i_Uc()
{
  {
    init_simple_test("aVp_BFu7i_Uc");
    static STRUCT_IF_C aVp_BFu7i_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_Uc, aVp_BFu7i_Uc)
//============================================================================



static void Test_aVp_BFu7i_Ui()
{
  {
    init_simple_test("aVp_BFu7i_Ui");
    static STRUCT_IF_C aVp_BFu7i_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_Ui, aVp_BFu7i_Ui)
//============================================================================



static void Test_aVp_BFu7i_Ul()
{
  {
    init_simple_test("aVp_BFu7i_Ul");
    static STRUCT_IF_C aVp_BFu7i_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_Ul, aVp_BFu7i_Ul)
//============================================================================



static void Test_aVp_BFu7i_Us()
{
  {
    init_simple_test("aVp_BFu7i_Us");
    static STRUCT_IF_C aVp_BFu7i_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_Us, aVp_BFu7i_Us)
//============================================================================



static void Test_aVp_BFu7i_Vp()
{
  {
    init_simple_test("aVp_BFu7i_Vp");
    static STRUCT_IF_C aVp_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "aVp_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7i_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7i_Vp, aVp_BFu7i_Vp)
//============================================================================



static void Test_aVp_BFu7ll()
{
  {
    init_simple_test("aVp_BFu7ll");
    static STRUCT_IF_C aVp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll, aVp_BFu7ll)
//============================================================================



static void Test_aVp_BFu7ll_BFu15i()
{
  {
    init_simple_test("aVp_BFu7ll_BFu15i");
    static STRUCT_IF_C aVp_BFu7ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aVp_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aVp_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu15i, aVp_BFu7ll_BFu15i)
//============================================================================



static void Test_aVp_BFu7ll_BFu15ll()
{
  {
    init_simple_test("aVp_BFu7ll_BFu15ll");
    static STRUCT_IF_C aVp_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aVp_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aVp_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu15ll, aVp_BFu7ll_BFu15ll)
//============================================================================



static void Test_aVp_BFu7ll_BFu15s()
{
  {
    init_simple_test("aVp_BFu7ll_BFu15s");
    static STRUCT_IF_C aVp_BFu7ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aVp_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aVp_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu15s, aVp_BFu7ll_BFu15s)
//============================================================================



static void Test_aVp_BFu7ll_BFu16i()
{
  {
    init_simple_test("aVp_BFu7ll_BFu16i");
    static STRUCT_IF_C aVp_BFu7ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aVp_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aVp_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu16i, aVp_BFu7ll_BFu16i)
//============================================================================



static void Test_aVp_BFu7ll_BFu16ll()
{
  {
    init_simple_test("aVp_BFu7ll_BFu16ll");
    static STRUCT_IF_C aVp_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aVp_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aVp_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu16ll, aVp_BFu7ll_BFu16ll)
//============================================================================



static void Test_aVp_BFu7ll_BFu16s()
{
  {
    init_simple_test("aVp_BFu7ll_BFu16s");
    static STRUCT_IF_C aVp_BFu7ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aVp_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aVp_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu16s, aVp_BFu7ll_BFu16s)
//============================================================================



static void Test_aVp_BFu7ll_BFu17i()
{
  {
    init_simple_test("aVp_BFu7ll_BFu17i");
    static STRUCT_IF_C aVp_BFu7ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aVp_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aVp_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu17i, aVp_BFu7ll_BFu17i)
//============================================================================



static void Test_aVp_BFu7ll_BFu17ll()
{
  {
    init_simple_test("aVp_BFu7ll_BFu17ll");
    static STRUCT_IF_C aVp_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aVp_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aVp_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu17ll, aVp_BFu7ll_BFu17ll)
//============================================================================



static void Test_aVp_BFu7ll_BFu1c()
{
  {
    init_simple_test("aVp_BFu7ll_BFu1c");
    static STRUCT_IF_C aVp_BFu7ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu1c, aVp_BFu7ll_BFu1c)
//============================================================================



static void Test_aVp_BFu7ll_BFu1i()
{
  {
    init_simple_test("aVp_BFu7ll_BFu1i");
    static STRUCT_IF_C aVp_BFu7ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu1i, aVp_BFu7ll_BFu1i)
//============================================================================



static void Test_aVp_BFu7ll_BFu1ll()
{
  {
    init_simple_test("aVp_BFu7ll_BFu1ll");
    static STRUCT_IF_C aVp_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu1ll, aVp_BFu7ll_BFu1ll)
//============================================================================



static void Test_aVp_BFu7ll_BFu1s()
{
  {
    init_simple_test("aVp_BFu7ll_BFu1s");
    static STRUCT_IF_C aVp_BFu7ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu1s, aVp_BFu7ll_BFu1s)
//============================================================================



static void Test_aVp_BFu7ll_BFu31i()
{
  {
    init_simple_test("aVp_BFu7ll_BFu31i");
    static STRUCT_IF_C aVp_BFu7ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aVp_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aVp_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu31i, aVp_BFu7ll_BFu31i)
//============================================================================



static void Test_aVp_BFu7ll_BFu31ll()
{
  {
    init_simple_test("aVp_BFu7ll_BFu31ll");
    static STRUCT_IF_C aVp_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aVp_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aVp_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu31ll, aVp_BFu7ll_BFu31ll)
//============================================================================



static void Test_aVp_BFu7ll_BFu32i()
{
  {
    init_simple_test("aVp_BFu7ll_BFu32i");
    static STRUCT_IF_C aVp_BFu7ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aVp_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aVp_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu32i, aVp_BFu7ll_BFu32i)
//============================================================================



static void Test_aVp_BFu7ll_BFu32ll()
{
  {
    init_simple_test("aVp_BFu7ll_BFu32ll");
    static STRUCT_IF_C aVp_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aVp_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aVp_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu32ll, aVp_BFu7ll_BFu32ll)
//============================================================================



static void Test_aVp_BFu7ll_BFu33()
{
  {
    init_simple_test("aVp_BFu7ll_BFu33");
    static STRUCT_IF_C aVp_BFu7ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, 1, "aVp_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, hide_ull(1LL<<32), "aVp_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu33, aVp_BFu7ll_BFu33)
//============================================================================



static void Test_aVp_BFu7ll_BFu7c()
{
  {
    init_simple_test("aVp_BFu7ll_BFu7c");
    static STRUCT_IF_C aVp_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu7c, aVp_BFu7ll_BFu7c)
//============================================================================



static void Test_aVp_BFu7ll_BFu7i()
{
  {
    init_simple_test("aVp_BFu7ll_BFu7i");
    static STRUCT_IF_C aVp_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu7i, aVp_BFu7ll_BFu7i)
//============================================================================



static void Test_aVp_BFu7ll_BFu7ll()
{
  {
    init_simple_test("aVp_BFu7ll_BFu7ll");
    static STRUCT_IF_C aVp_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu7ll, aVp_BFu7ll_BFu7ll)
//============================================================================



static void Test_aVp_BFu7ll_BFu7s()
{
  {
    init_simple_test("aVp_BFu7ll_BFu7s");
    static STRUCT_IF_C aVp_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu7s, aVp_BFu7ll_BFu7s)
//============================================================================



static void Test_aVp_BFu7ll_BFu8c()
{
  {
    init_simple_test("aVp_BFu7ll_BFu8c");
    static STRUCT_IF_C aVp_BFu7ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu8c, aVp_BFu7ll_BFu8c)
//============================================================================



static void Test_aVp_BFu7ll_BFu8i()
{
  {
    init_simple_test("aVp_BFu7ll_BFu8i");
    static STRUCT_IF_C aVp_BFu7ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu8i, aVp_BFu7ll_BFu8i)
//============================================================================



static void Test_aVp_BFu7ll_BFu8ll()
{
  {
    init_simple_test("aVp_BFu7ll_BFu8ll");
    static STRUCT_IF_C aVp_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu8ll, aVp_BFu7ll_BFu8ll)
//============================================================================



static void Test_aVp_BFu7ll_BFu8s()
{
  {
    init_simple_test("aVp_BFu7ll_BFu8s");
    static STRUCT_IF_C aVp_BFu7ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu8s, aVp_BFu7ll_BFu8s)
//============================================================================



static void Test_aVp_BFu7ll_BFu9i()
{
  {
    init_simple_test("aVp_BFu7ll_BFu9i");
    static STRUCT_IF_C aVp_BFu7ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aVp_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aVp_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu9i, aVp_BFu7ll_BFu9i)
//============================================================================



static void Test_aVp_BFu7ll_BFu9ll()
{
  {
    init_simple_test("aVp_BFu7ll_BFu9ll");
    static STRUCT_IF_C aVp_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aVp_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aVp_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu9ll, aVp_BFu7ll_BFu9ll)
//============================================================================



static void Test_aVp_BFu7ll_BFu9s()
{
  {
    init_simple_test("aVp_BFu7ll_BFu9s");
    static STRUCT_IF_C aVp_BFu7ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aVp_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aVp_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_BFu9s, aVp_BFu7ll_BFu9s)
//============================================================================



static void Test_aVp_BFu7ll_C()
{
  {
    init_simple_test("aVp_BFu7ll_C");
    static STRUCT_IF_C aVp_BFu7ll_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_C, aVp_BFu7ll_C)
//============================================================================



static void Test_aVp_BFu7ll_D()
{
  {
    init_simple_test("aVp_BFu7ll_D");
    static STRUCT_IF_C aVp_BFu7ll_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_D, aVp_BFu7ll_D)
//============================================================================



static void Test_aVp_BFu7ll_F()
{
  {
    init_simple_test("aVp_BFu7ll_F");
    static STRUCT_IF_C aVp_BFu7ll_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_F, aVp_BFu7ll_F)
//============================================================================



static void Test_aVp_BFu7ll_I()
{
  {
    init_simple_test("aVp_BFu7ll_I");
    static STRUCT_IF_C aVp_BFu7ll_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_I, aVp_BFu7ll_I)
//============================================================================



static void Test_aVp_BFu7ll_Ip()
{
  {
    init_simple_test("aVp_BFu7ll_Ip");
    static STRUCT_IF_C aVp_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_Ip, aVp_BFu7ll_Ip)
//============================================================================



static void Test_aVp_BFu7ll_L()
{
  {
    init_simple_test("aVp_BFu7ll_L");
    static STRUCT_IF_C aVp_BFu7ll_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_L, aVp_BFu7ll_L)
//============================================================================



static void Test_aVp_BFu7ll_S()
{
  {
    init_simple_test("aVp_BFu7ll_S");
    static STRUCT_IF_C aVp_BFu7ll_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_S, aVp_BFu7ll_S)
//============================================================================



static void Test_aVp_BFu7ll_Uc()
{
  {
    init_simple_test("aVp_BFu7ll_Uc");
    static STRUCT_IF_C aVp_BFu7ll_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_Uc, aVp_BFu7ll_Uc)
//============================================================================



static void Test_aVp_BFu7ll_Ui()
{
  {
    init_simple_test("aVp_BFu7ll_Ui");
    static STRUCT_IF_C aVp_BFu7ll_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_Ui, aVp_BFu7ll_Ui)
//============================================================================



static void Test_aVp_BFu7ll_Ul()
{
  {
    init_simple_test("aVp_BFu7ll_Ul");
    static STRUCT_IF_C aVp_BFu7ll_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_Ul, aVp_BFu7ll_Ul)
//============================================================================



static void Test_aVp_BFu7ll_Us()
{
  {
    init_simple_test("aVp_BFu7ll_Us");
    static STRUCT_IF_C aVp_BFu7ll_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_Us, aVp_BFu7ll_Us)
//============================================================================



static void Test_aVp_BFu7ll_Vp()
{
  {
    init_simple_test("aVp_BFu7ll_Vp");
    static STRUCT_IF_C aVp_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "aVp_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7ll_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7ll_Vp, aVp_BFu7ll_Vp)
//============================================================================



static void Test_aVp_BFu7s()
{
  {
    init_simple_test("aVp_BFu7s");
    static STRUCT_IF_C aVp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s, aVp_BFu7s)
//============================================================================



static void Test_aVp_BFu7s_BFu15i()
{
  {
    init_simple_test("aVp_BFu7s_BFu15i");
    static STRUCT_IF_C aVp_BFu7s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aVp_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aVp_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu15i, aVp_BFu7s_BFu15i)
//============================================================================



static void Test_aVp_BFu7s_BFu15ll()
{
  {
    init_simple_test("aVp_BFu7s_BFu15ll");
    static STRUCT_IF_C aVp_BFu7s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aVp_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aVp_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu15ll, aVp_BFu7s_BFu15ll)
//============================================================================



static void Test_aVp_BFu7s_BFu15s()
{
  {
    init_simple_test("aVp_BFu7s_BFu15s");
    static STRUCT_IF_C aVp_BFu7s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aVp_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aVp_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu15s, aVp_BFu7s_BFu15s)
//============================================================================



static void Test_aVp_BFu7s_BFu16i()
{
  {
    init_simple_test("aVp_BFu7s_BFu16i");
    static STRUCT_IF_C aVp_BFu7s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aVp_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aVp_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu16i, aVp_BFu7s_BFu16i)
//============================================================================



static void Test_aVp_BFu7s_BFu16ll()
{
  {
    init_simple_test("aVp_BFu7s_BFu16ll");
    static STRUCT_IF_C aVp_BFu7s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aVp_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aVp_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu16ll, aVp_BFu7s_BFu16ll)
//============================================================================



static void Test_aVp_BFu7s_BFu16s()
{
  {
    init_simple_test("aVp_BFu7s_BFu16s");
    static STRUCT_IF_C aVp_BFu7s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aVp_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aVp_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu16s, aVp_BFu7s_BFu16s)
//============================================================================



static void Test_aVp_BFu7s_BFu17i()
{
  {
    init_simple_test("aVp_BFu7s_BFu17i");
    static STRUCT_IF_C aVp_BFu7s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aVp_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aVp_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu17i, aVp_BFu7s_BFu17i)
//============================================================================



static void Test_aVp_BFu7s_BFu17ll()
{
  {
    init_simple_test("aVp_BFu7s_BFu17ll");
    static STRUCT_IF_C aVp_BFu7s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aVp_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aVp_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu17ll, aVp_BFu7s_BFu17ll)
//============================================================================



static void Test_aVp_BFu7s_BFu1c()
{
  {
    init_simple_test("aVp_BFu7s_BFu1c");
    static STRUCT_IF_C aVp_BFu7s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu1c, aVp_BFu7s_BFu1c)
//============================================================================



static void Test_aVp_BFu7s_BFu1i()
{
  {
    init_simple_test("aVp_BFu7s_BFu1i");
    static STRUCT_IF_C aVp_BFu7s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu1i, aVp_BFu7s_BFu1i)
//============================================================================



static void Test_aVp_BFu7s_BFu1ll()
{
  {
    init_simple_test("aVp_BFu7s_BFu1ll");
    static STRUCT_IF_C aVp_BFu7s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu1ll, aVp_BFu7s_BFu1ll)
//============================================================================



static void Test_aVp_BFu7s_BFu1s()
{
  {
    init_simple_test("aVp_BFu7s_BFu1s");
    static STRUCT_IF_C aVp_BFu7s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aVp_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu1s, aVp_BFu7s_BFu1s)
//============================================================================



static void Test_aVp_BFu7s_BFu31i()
{
  {
    init_simple_test("aVp_BFu7s_BFu31i");
    static STRUCT_IF_C aVp_BFu7s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aVp_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aVp_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu31i, aVp_BFu7s_BFu31i)
//============================================================================



static void Test_aVp_BFu7s_BFu31ll()
{
  {
    init_simple_test("aVp_BFu7s_BFu31ll");
    static STRUCT_IF_C aVp_BFu7s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aVp_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aVp_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu31ll, aVp_BFu7s_BFu31ll)
//============================================================================



static void Test_aVp_BFu7s_BFu32i()
{
  {
    init_simple_test("aVp_BFu7s_BFu32i");
    static STRUCT_IF_C aVp_BFu7s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aVp_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aVp_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu32i, aVp_BFu7s_BFu32i)
//============================================================================



static void Test_aVp_BFu7s_BFu32ll()
{
  {
    init_simple_test("aVp_BFu7s_BFu32ll");
    static STRUCT_IF_C aVp_BFu7s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aVp_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aVp_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu32ll, aVp_BFu7s_BFu32ll)
//============================================================================



static void Test_aVp_BFu7s_BFu33()
{
  {
    init_simple_test("aVp_BFu7s_BFu33");
    static STRUCT_IF_C aVp_BFu7s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, 1, "aVp_BFu7s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, hide_ull(1LL<<32), "aVp_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu33, aVp_BFu7s_BFu33)
//============================================================================



static void Test_aVp_BFu7s_BFu7c()
{
  {
    init_simple_test("aVp_BFu7s_BFu7c");
    static STRUCT_IF_C aVp_BFu7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu7c, aVp_BFu7s_BFu7c)
//============================================================================



static void Test_aVp_BFu7s_BFu7i()
{
  {
    init_simple_test("aVp_BFu7s_BFu7i");
    static STRUCT_IF_C aVp_BFu7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu7i, aVp_BFu7s_BFu7i)
//============================================================================



static void Test_aVp_BFu7s_BFu7ll()
{
  {
    init_simple_test("aVp_BFu7s_BFu7ll");
    static STRUCT_IF_C aVp_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu7ll, aVp_BFu7s_BFu7ll)
//============================================================================



static void Test_aVp_BFu7s_BFu7s()
{
  {
    init_simple_test("aVp_BFu7s_BFu7s");
    static STRUCT_IF_C aVp_BFu7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aVp_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu7s, aVp_BFu7s_BFu7s)
//============================================================================



static void Test_aVp_BFu7s_BFu8c()
{
  {
    init_simple_test("aVp_BFu7s_BFu8c");
    static STRUCT_IF_C aVp_BFu7s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu8c, aVp_BFu7s_BFu8c)
//============================================================================



static void Test_aVp_BFu7s_BFu8i()
{
  {
    init_simple_test("aVp_BFu7s_BFu8i");
    static STRUCT_IF_C aVp_BFu7s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu8i, aVp_BFu7s_BFu8i)
//============================================================================



static void Test_aVp_BFu7s_BFu8ll()
{
  {
    init_simple_test("aVp_BFu7s_BFu8ll");
    static STRUCT_IF_C aVp_BFu7s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu8ll, aVp_BFu7s_BFu8ll)
//============================================================================



static void Test_aVp_BFu7s_BFu8s()
{
  {
    init_simple_test("aVp_BFu7s_BFu8s");
    static STRUCT_IF_C aVp_BFu7s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aVp_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aVp_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu8s, aVp_BFu7s_BFu8s)
//============================================================================



static void Test_aVp_BFu7s_BFu9i()
{
  {
    init_simple_test("aVp_BFu7s_BFu9i");
    static STRUCT_IF_C aVp_BFu7s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aVp_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aVp_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu9i, aVp_BFu7s_BFu9i)
//============================================================================



static void Test_aVp_BFu7s_BFu9ll()
{
  {
    init_simple_test("aVp_BFu7s_BFu9ll");
    static STRUCT_IF_C aVp_BFu7s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aVp_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aVp_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu9ll, aVp_BFu7s_BFu9ll)
//============================================================================



static void Test_aVp_BFu7s_BFu9s()
{
  {
    init_simple_test("aVp_BFu7s_BFu9s");
    static STRUCT_IF_C aVp_BFu7s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aVp_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aVp_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_BFu9s, aVp_BFu7s_BFu9s)
//============================================================================



static void Test_aVp_BFu7s_C()
{
  {
    init_simple_test("aVp_BFu7s_C");
    static STRUCT_IF_C aVp_BFu7s_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_C)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_C, aVp_BFu7s_C)
//============================================================================



static void Test_aVp_BFu7s_D()
{
  {
    init_simple_test("aVp_BFu7s_D");
    static STRUCT_IF_C aVp_BFu7s_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_D)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_D, aVp_BFu7s_D)
//============================================================================



static void Test_aVp_BFu7s_F()
{
  {
    init_simple_test("aVp_BFu7s_F");
    static STRUCT_IF_C aVp_BFu7s_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_F)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_F, aVp_BFu7s_F)
//============================================================================



static void Test_aVp_BFu7s_I()
{
  {
    init_simple_test("aVp_BFu7s_I");
    static STRUCT_IF_C aVp_BFu7s_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_I)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_I, aVp_BFu7s_I)
//============================================================================



static void Test_aVp_BFu7s_Ip()
{
  {
    init_simple_test("aVp_BFu7s_Ip");
    static STRUCT_IF_C aVp_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_Ip, aVp_BFu7s_Ip)
//============================================================================



static void Test_aVp_BFu7s_L()
{
  {
    init_simple_test("aVp_BFu7s_L");
    static STRUCT_IF_C aVp_BFu7s_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu7s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_L)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_L, aVp_BFu7s_L)
//============================================================================



static void Test_aVp_BFu7s_S()
{
  {
    init_simple_test("aVp_BFu7s_S");
    static STRUCT_IF_C aVp_BFu7s_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_S)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_S, aVp_BFu7s_S)
//============================================================================



static void Test_aVp_BFu7s_Uc()
{
  {
    init_simple_test("aVp_BFu7s_Uc");
    static STRUCT_IF_C aVp_BFu7s_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu7s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_Uc, aVp_BFu7s_Uc)
//============================================================================



static void Test_aVp_BFu7s_Ui()
{
  {
    init_simple_test("aVp_BFu7s_Ui");
    static STRUCT_IF_C aVp_BFu7s_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu7s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_Ui, aVp_BFu7s_Ui)
//============================================================================



static void Test_aVp_BFu7s_Ul()
{
  {
    init_simple_test("aVp_BFu7s_Ul");
    static STRUCT_IF_C aVp_BFu7s_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu7s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_Ul, aVp_BFu7s_Ul)
//============================================================================



static void Test_aVp_BFu7s_Us()
{
  {
    init_simple_test("aVp_BFu7s_Us");
    static STRUCT_IF_C aVp_BFu7s_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu7s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_Us, aVp_BFu7s_Us)
//============================================================================



static void Test_aVp_BFu7s_Vp()
{
  {
    init_simple_test("aVp_BFu7s_Vp");
    static STRUCT_IF_C aVp_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu7s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "aVp_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aVp_BFu7s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aVp_BFu7s_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu7s_Vp, aVp_BFu7s_Vp)
//============================================================================



static void Test_aVp_BFu8c()
{
  {
    init_simple_test("aVp_BFu8c");
    static STRUCT_IF_C aVp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c, aVp_BFu8c)
//============================================================================



static void Test_aVp_BFu8c_BFu15i()
{
  {
    init_simple_test("aVp_BFu8c_BFu15i");
    static STRUCT_IF_C aVp_BFu8c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu15i, aVp_BFu8c_BFu15i)
//============================================================================



static void Test_aVp_BFu8c_BFu15ll()
{
  {
    init_simple_test("aVp_BFu8c_BFu15ll");
    static STRUCT_IF_C aVp_BFu8c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu15ll, aVp_BFu8c_BFu15ll)
//============================================================================



static void Test_aVp_BFu8c_BFu15s()
{
  {
    init_simple_test("aVp_BFu8c_BFu15s");
    static STRUCT_IF_C aVp_BFu8c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu15s, aVp_BFu8c_BFu15s)
//============================================================================



static void Test_aVp_BFu8c_BFu16i()
{
  {
    init_simple_test("aVp_BFu8c_BFu16i");
    static STRUCT_IF_C aVp_BFu8c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu16i, aVp_BFu8c_BFu16i)
//============================================================================



static void Test_aVp_BFu8c_BFu16ll()
{
  {
    init_simple_test("aVp_BFu8c_BFu16ll");
    static STRUCT_IF_C aVp_BFu8c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu16ll, aVp_BFu8c_BFu16ll)
//============================================================================



static void Test_aVp_BFu8c_BFu16s()
{
  {
    init_simple_test("aVp_BFu8c_BFu16s");
    static STRUCT_IF_C aVp_BFu8c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu16s, aVp_BFu8c_BFu16s)
//============================================================================



static void Test_aVp_BFu8c_BFu17i()
{
  {
    init_simple_test("aVp_BFu8c_BFu17i");
    static STRUCT_IF_C aVp_BFu8c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu8c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aVp_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aVp_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu17i, aVp_BFu8c_BFu17i)
//============================================================================



static void Test_aVp_BFu8c_BFu17ll()
{
  {
    init_simple_test("aVp_BFu8c_BFu17ll");
    static STRUCT_IF_C aVp_BFu8c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu8c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aVp_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aVp_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu17ll, aVp_BFu8c_BFu17ll)
//============================================================================



static void Test_aVp_BFu8c_BFu1c()
{
  {
    init_simple_test("aVp_BFu8c_BFu1c");
    static STRUCT_IF_C aVp_BFu8c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu1c, aVp_BFu8c_BFu1c)
//============================================================================



static void Test_aVp_BFu8c_BFu1i()
{
  {
    init_simple_test("aVp_BFu8c_BFu1i");
    static STRUCT_IF_C aVp_BFu8c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu1i, aVp_BFu8c_BFu1i)
//============================================================================



static void Test_aVp_BFu8c_BFu1ll()
{
  {
    init_simple_test("aVp_BFu8c_BFu1ll");
    static STRUCT_IF_C aVp_BFu8c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu1ll, aVp_BFu8c_BFu1ll)
//============================================================================



static void Test_aVp_BFu8c_BFu1s()
{
  {
    init_simple_test("aVp_BFu8c_BFu1s");
    static STRUCT_IF_C aVp_BFu8c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu1s, aVp_BFu8c_BFu1s)
//============================================================================



static void Test_aVp_BFu8c_BFu31i()
{
  {
    init_simple_test("aVp_BFu8c_BFu31i");
    static STRUCT_IF_C aVp_BFu8c_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aVp_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aVp_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu31i, aVp_BFu8c_BFu31i)
//============================================================================



static void Test_aVp_BFu8c_BFu31ll()
{
  {
    init_simple_test("aVp_BFu8c_BFu31ll");
    static STRUCT_IF_C aVp_BFu8c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aVp_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aVp_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu31ll, aVp_BFu8c_BFu31ll)
//============================================================================



static void Test_aVp_BFu8c_BFu32i()
{
  {
    init_simple_test("aVp_BFu8c_BFu32i");
    static STRUCT_IF_C aVp_BFu8c_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aVp_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aVp_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu32i, aVp_BFu8c_BFu32i)
//============================================================================



static void Test_aVp_BFu8c_BFu32ll()
{
  {
    init_simple_test("aVp_BFu8c_BFu32ll");
    static STRUCT_IF_C aVp_BFu8c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aVp_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aVp_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu32ll, aVp_BFu8c_BFu32ll)
//============================================================================



static void Test_aVp_BFu8c_BFu33()
{
  {
    init_simple_test("aVp_BFu8c_BFu33");
    static STRUCT_IF_C aVp_BFu8c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aVp_BFu8c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aVp_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu33, aVp_BFu8c_BFu33)
//============================================================================



static void Test_aVp_BFu8c_BFu7c()
{
  {
    init_simple_test("aVp_BFu8c_BFu7c");
    static STRUCT_IF_C aVp_BFu8c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu7c, aVp_BFu8c_BFu7c)
//============================================================================



static void Test_aVp_BFu8c_BFu7i()
{
  {
    init_simple_test("aVp_BFu8c_BFu7i");
    static STRUCT_IF_C aVp_BFu8c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu7i, aVp_BFu8c_BFu7i)
//============================================================================



static void Test_aVp_BFu8c_BFu7ll()
{
  {
    init_simple_test("aVp_BFu8c_BFu7ll");
    static STRUCT_IF_C aVp_BFu8c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu7ll, aVp_BFu8c_BFu7ll)
//============================================================================



static void Test_aVp_BFu8c_BFu7s()
{
  {
    init_simple_test("aVp_BFu8c_BFu7s");
    static STRUCT_IF_C aVp_BFu8c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu7s, aVp_BFu8c_BFu7s)
//============================================================================



static void Test_aVp_BFu8c_BFu8c()
{
  {
    init_simple_test("aVp_BFu8c_BFu8c");
    static STRUCT_IF_C aVp_BFu8c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu8c, aVp_BFu8c_BFu8c)
//============================================================================



static void Test_aVp_BFu8c_BFu8i()
{
  {
    init_simple_test("aVp_BFu8c_BFu8i");
    static STRUCT_IF_C aVp_BFu8c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu8i, aVp_BFu8c_BFu8i)
//============================================================================



static void Test_aVp_BFu8c_BFu8ll()
{
  {
    init_simple_test("aVp_BFu8c_BFu8ll");
    static STRUCT_IF_C aVp_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu8ll, aVp_BFu8c_BFu8ll)
//============================================================================



static void Test_aVp_BFu8c_BFu8s()
{
  {
    init_simple_test("aVp_BFu8c_BFu8s");
    static STRUCT_IF_C aVp_BFu8c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu8s, aVp_BFu8c_BFu8s)
//============================================================================



static void Test_aVp_BFu8c_BFu9i()
{
  {
    init_simple_test("aVp_BFu8c_BFu9i");
    static STRUCT_IF_C aVp_BFu8c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu9i, aVp_BFu8c_BFu9i)
//============================================================================



static void Test_aVp_BFu8c_BFu9ll()
{
  {
    init_simple_test("aVp_BFu8c_BFu9ll");
    static STRUCT_IF_C aVp_BFu8c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu9ll, aVp_BFu8c_BFu9ll)
//============================================================================



static void Test_aVp_BFu8c_BFu9s()
{
  {
    init_simple_test("aVp_BFu8c_BFu9s");
    static STRUCT_IF_C aVp_BFu8c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_BFu9s, aVp_BFu8c_BFu9s)
//============================================================================



static void Test_aVp_BFu8c_C()
{
  {
    init_simple_test("aVp_BFu8c_C");
    static STRUCT_IF_C aVp_BFu8c_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_C)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_C, aVp_BFu8c_C)
//============================================================================



static void Test_aVp_BFu8c_D()
{
  {
    init_simple_test("aVp_BFu8c_D");
    static STRUCT_IF_C aVp_BFu8c_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu8c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_D)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_D, aVp_BFu8c_D)
//============================================================================



static void Test_aVp_BFu8c_F()
{
  {
    init_simple_test("aVp_BFu8c_F");
    static STRUCT_IF_C aVp_BFu8c_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_F)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_F, aVp_BFu8c_F)
//============================================================================



static void Test_aVp_BFu8c_I()
{
  {
    init_simple_test("aVp_BFu8c_I");
    static STRUCT_IF_C aVp_BFu8c_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_I)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_I, aVp_BFu8c_I)
//============================================================================



static void Test_aVp_BFu8c_Ip()
{
  {
    init_simple_test("aVp_BFu8c_Ip");
    static STRUCT_IF_C aVp_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu8c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_Ip, aVp_BFu8c_Ip)
//============================================================================



static void Test_aVp_BFu8c_L()
{
  {
    init_simple_test("aVp_BFu8c_L");
    static STRUCT_IF_C aVp_BFu8c_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu8c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_L)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_L, aVp_BFu8c_L)
//============================================================================



static void Test_aVp_BFu8c_S()
{
  {
    init_simple_test("aVp_BFu8c_S");
    static STRUCT_IF_C aVp_BFu8c_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_S)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_S, aVp_BFu8c_S)
//============================================================================



static void Test_aVp_BFu8c_Uc()
{
  {
    init_simple_test("aVp_BFu8c_Uc");
    static STRUCT_IF_C aVp_BFu8c_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_Uc, aVp_BFu8c_Uc)
//============================================================================



static void Test_aVp_BFu8c_Ui()
{
  {
    init_simple_test("aVp_BFu8c_Ui");
    static STRUCT_IF_C aVp_BFu8c_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_Ui, aVp_BFu8c_Ui)
//============================================================================



static void Test_aVp_BFu8c_Ul()
{
  {
    init_simple_test("aVp_BFu8c_Ul");
    static STRUCT_IF_C aVp_BFu8c_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu8c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_Ul, aVp_BFu8c_Ul)
//============================================================================



static void Test_aVp_BFu8c_Us()
{
  {
    init_simple_test("aVp_BFu8c_Us");
    static STRUCT_IF_C aVp_BFu8c_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_Us, aVp_BFu8c_Us)
//============================================================================



static void Test_aVp_BFu8c_Vp()
{
  {
    init_simple_test("aVp_BFu8c_Vp");
    static STRUCT_IF_C aVp_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu8c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "aVp_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8c_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8c_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8c_Vp, aVp_BFu8c_Vp)
//============================================================================



static void Test_aVp_BFu8i()
{
  {
    init_simple_test("aVp_BFu8i");
    static STRUCT_IF_C aVp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i, aVp_BFu8i)
//============================================================================



static void Test_aVp_BFu8i_BFu15i()
{
  {
    init_simple_test("aVp_BFu8i_BFu15i");
    static STRUCT_IF_C aVp_BFu8i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu15i, aVp_BFu8i_BFu15i)
//============================================================================



static void Test_aVp_BFu8i_BFu15ll()
{
  {
    init_simple_test("aVp_BFu8i_BFu15ll");
    static STRUCT_IF_C aVp_BFu8i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu15ll, aVp_BFu8i_BFu15ll)
//============================================================================



static void Test_aVp_BFu8i_BFu15s()
{
  {
    init_simple_test("aVp_BFu8i_BFu15s");
    static STRUCT_IF_C aVp_BFu8i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu15s, aVp_BFu8i_BFu15s)
//============================================================================



static void Test_aVp_BFu8i_BFu16i()
{
  {
    init_simple_test("aVp_BFu8i_BFu16i");
    static STRUCT_IF_C aVp_BFu8i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu16i, aVp_BFu8i_BFu16i)
//============================================================================



static void Test_aVp_BFu8i_BFu16ll()
{
  {
    init_simple_test("aVp_BFu8i_BFu16ll");
    static STRUCT_IF_C aVp_BFu8i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu16ll, aVp_BFu8i_BFu16ll)
//============================================================================



static void Test_aVp_BFu8i_BFu16s()
{
  {
    init_simple_test("aVp_BFu8i_BFu16s");
    static STRUCT_IF_C aVp_BFu8i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu16s, aVp_BFu8i_BFu16s)
//============================================================================



static void Test_aVp_BFu8i_BFu17i()
{
  {
    init_simple_test("aVp_BFu8i_BFu17i");
    static STRUCT_IF_C aVp_BFu8i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu8i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aVp_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aVp_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu17i, aVp_BFu8i_BFu17i)
//============================================================================



static void Test_aVp_BFu8i_BFu17ll()
{
  {
    init_simple_test("aVp_BFu8i_BFu17ll");
    static STRUCT_IF_C aVp_BFu8i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu8i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aVp_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aVp_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu17ll, aVp_BFu8i_BFu17ll)
//============================================================================



static void Test_aVp_BFu8i_BFu1c()
{
  {
    init_simple_test("aVp_BFu8i_BFu1c");
    static STRUCT_IF_C aVp_BFu8i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu1c, aVp_BFu8i_BFu1c)
//============================================================================



static void Test_aVp_BFu8i_BFu1i()
{
  {
    init_simple_test("aVp_BFu8i_BFu1i");
    static STRUCT_IF_C aVp_BFu8i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu1i, aVp_BFu8i_BFu1i)
//============================================================================



static void Test_aVp_BFu8i_BFu1ll()
{
  {
    init_simple_test("aVp_BFu8i_BFu1ll");
    static STRUCT_IF_C aVp_BFu8i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu1ll, aVp_BFu8i_BFu1ll)
//============================================================================



static void Test_aVp_BFu8i_BFu1s()
{
  {
    init_simple_test("aVp_BFu8i_BFu1s");
    static STRUCT_IF_C aVp_BFu8i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu1s, aVp_BFu8i_BFu1s)
//============================================================================



static void Test_aVp_BFu8i_BFu31i()
{
  {
    init_simple_test("aVp_BFu8i_BFu31i");
    static STRUCT_IF_C aVp_BFu8i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aVp_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aVp_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu31i, aVp_BFu8i_BFu31i)
//============================================================================



static void Test_aVp_BFu8i_BFu31ll()
{
  {
    init_simple_test("aVp_BFu8i_BFu31ll");
    static STRUCT_IF_C aVp_BFu8i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aVp_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aVp_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu31ll, aVp_BFu8i_BFu31ll)
//============================================================================



static void Test_aVp_BFu8i_BFu32i()
{
  {
    init_simple_test("aVp_BFu8i_BFu32i");
    static STRUCT_IF_C aVp_BFu8i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aVp_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aVp_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu32i, aVp_BFu8i_BFu32i)
//============================================================================



static void Test_aVp_BFu8i_BFu32ll()
{
  {
    init_simple_test("aVp_BFu8i_BFu32ll");
    static STRUCT_IF_C aVp_BFu8i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aVp_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aVp_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu32ll, aVp_BFu8i_BFu32ll)
//============================================================================



static void Test_aVp_BFu8i_BFu33()
{
  {
    init_simple_test("aVp_BFu8i_BFu33");
    static STRUCT_IF_C aVp_BFu8i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu8i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aVp_BFu8i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aVp_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu33, aVp_BFu8i_BFu33)
//============================================================================



static void Test_aVp_BFu8i_BFu7c()
{
  {
    init_simple_test("aVp_BFu8i_BFu7c");
    static STRUCT_IF_C aVp_BFu8i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu7c, aVp_BFu8i_BFu7c)
//============================================================================



static void Test_aVp_BFu8i_BFu7i()
{
  {
    init_simple_test("aVp_BFu8i_BFu7i");
    static STRUCT_IF_C aVp_BFu8i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu7i, aVp_BFu8i_BFu7i)
//============================================================================



static void Test_aVp_BFu8i_BFu7ll()
{
  {
    init_simple_test("aVp_BFu8i_BFu7ll");
    static STRUCT_IF_C aVp_BFu8i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu7ll, aVp_BFu8i_BFu7ll)
//============================================================================



static void Test_aVp_BFu8i_BFu7s()
{
  {
    init_simple_test("aVp_BFu8i_BFu7s");
    static STRUCT_IF_C aVp_BFu8i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu7s, aVp_BFu8i_BFu7s)
//============================================================================



static void Test_aVp_BFu8i_BFu8c()
{
  {
    init_simple_test("aVp_BFu8i_BFu8c");
    static STRUCT_IF_C aVp_BFu8i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu8c, aVp_BFu8i_BFu8c)
//============================================================================



static void Test_aVp_BFu8i_BFu8i()
{
  {
    init_simple_test("aVp_BFu8i_BFu8i");
    static STRUCT_IF_C aVp_BFu8i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu8i, aVp_BFu8i_BFu8i)
//============================================================================



static void Test_aVp_BFu8i_BFu8ll()
{
  {
    init_simple_test("aVp_BFu8i_BFu8ll");
    static STRUCT_IF_C aVp_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu8ll, aVp_BFu8i_BFu8ll)
//============================================================================



static void Test_aVp_BFu8i_BFu8s()
{
  {
    init_simple_test("aVp_BFu8i_BFu8s");
    static STRUCT_IF_C aVp_BFu8i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu8s, aVp_BFu8i_BFu8s)
//============================================================================



static void Test_aVp_BFu8i_BFu9i()
{
  {
    init_simple_test("aVp_BFu8i_BFu9i");
    static STRUCT_IF_C aVp_BFu8i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu9i, aVp_BFu8i_BFu9i)
//============================================================================



static void Test_aVp_BFu8i_BFu9ll()
{
  {
    init_simple_test("aVp_BFu8i_BFu9ll");
    static STRUCT_IF_C aVp_BFu8i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu9ll, aVp_BFu8i_BFu9ll)
//============================================================================



static void Test_aVp_BFu8i_BFu9s()
{
  {
    init_simple_test("aVp_BFu8i_BFu9s");
    static STRUCT_IF_C aVp_BFu8i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_BFu9s, aVp_BFu8i_BFu9s)
//============================================================================



static void Test_aVp_BFu8i_C()
{
  {
    init_simple_test("aVp_BFu8i_C");
    static STRUCT_IF_C aVp_BFu8i_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_C)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_C, aVp_BFu8i_C)
//============================================================================



static void Test_aVp_BFu8i_D()
{
  {
    init_simple_test("aVp_BFu8i_D");
    static STRUCT_IF_C aVp_BFu8i_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu8i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_D)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_D, aVp_BFu8i_D)
//============================================================================



static void Test_aVp_BFu8i_F()
{
  {
    init_simple_test("aVp_BFu8i_F");
    static STRUCT_IF_C aVp_BFu8i_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_F)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_F, aVp_BFu8i_F)
//============================================================================



static void Test_aVp_BFu8i_I()
{
  {
    init_simple_test("aVp_BFu8i_I");
    static STRUCT_IF_C aVp_BFu8i_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_I)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_I, aVp_BFu8i_I)
//============================================================================



static void Test_aVp_BFu8i_Ip()
{
  {
    init_simple_test("aVp_BFu8i_Ip");
    static STRUCT_IF_C aVp_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu8i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_Ip, aVp_BFu8i_Ip)
//============================================================================



static void Test_aVp_BFu8i_L()
{
  {
    init_simple_test("aVp_BFu8i_L");
    static STRUCT_IF_C aVp_BFu8i_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu8i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_L)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_L, aVp_BFu8i_L)
//============================================================================



static void Test_aVp_BFu8i_S()
{
  {
    init_simple_test("aVp_BFu8i_S");
    static STRUCT_IF_C aVp_BFu8i_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_S)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_S, aVp_BFu8i_S)
//============================================================================



static void Test_aVp_BFu8i_Uc()
{
  {
    init_simple_test("aVp_BFu8i_Uc");
    static STRUCT_IF_C aVp_BFu8i_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_Uc, aVp_BFu8i_Uc)
//============================================================================



static void Test_aVp_BFu8i_Ui()
{
  {
    init_simple_test("aVp_BFu8i_Ui");
    static STRUCT_IF_C aVp_BFu8i_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_Ui, aVp_BFu8i_Ui)
//============================================================================



static void Test_aVp_BFu8i_Ul()
{
  {
    init_simple_test("aVp_BFu8i_Ul");
    static STRUCT_IF_C aVp_BFu8i_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu8i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_Ul, aVp_BFu8i_Ul)
//============================================================================



static void Test_aVp_BFu8i_Us()
{
  {
    init_simple_test("aVp_BFu8i_Us");
    static STRUCT_IF_C aVp_BFu8i_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_Us, aVp_BFu8i_Us)
//============================================================================



static void Test_aVp_BFu8i_Vp()
{
  {
    init_simple_test("aVp_BFu8i_Vp");
    static STRUCT_IF_C aVp_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu8i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "aVp_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8i_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8i_Vp, aVp_BFu8i_Vp)
//============================================================================



static void Test_aVp_BFu8ll()
{
  {
    init_simple_test("aVp_BFu8ll");
    static STRUCT_IF_C aVp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll, aVp_BFu8ll)
//============================================================================



static void Test_aVp_BFu8ll_BFu15i()
{
  {
    init_simple_test("aVp_BFu8ll_BFu15i");
    static STRUCT_IF_C aVp_BFu8ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu15i, aVp_BFu8ll_BFu15i)
//============================================================================



static void Test_aVp_BFu8ll_BFu15ll()
{
  {
    init_simple_test("aVp_BFu8ll_BFu15ll");
    static STRUCT_IF_C aVp_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu15ll, aVp_BFu8ll_BFu15ll)
//============================================================================



static void Test_aVp_BFu8ll_BFu15s()
{
  {
    init_simple_test("aVp_BFu8ll_BFu15s");
    static STRUCT_IF_C aVp_BFu8ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu15s, aVp_BFu8ll_BFu15s)
//============================================================================



static void Test_aVp_BFu8ll_BFu16i()
{
  {
    init_simple_test("aVp_BFu8ll_BFu16i");
    static STRUCT_IF_C aVp_BFu8ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu16i, aVp_BFu8ll_BFu16i)
//============================================================================



static void Test_aVp_BFu8ll_BFu16ll()
{
  {
    init_simple_test("aVp_BFu8ll_BFu16ll");
    static STRUCT_IF_C aVp_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu16ll, aVp_BFu8ll_BFu16ll)
//============================================================================



static void Test_aVp_BFu8ll_BFu16s()
{
  {
    init_simple_test("aVp_BFu8ll_BFu16s");
    static STRUCT_IF_C aVp_BFu8ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu16s, aVp_BFu8ll_BFu16s)
//============================================================================



static void Test_aVp_BFu8ll_BFu17i()
{
  {
    init_simple_test("aVp_BFu8ll_BFu17i");
    static STRUCT_IF_C aVp_BFu8ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu8ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aVp_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aVp_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu17i, aVp_BFu8ll_BFu17i)
//============================================================================



static void Test_aVp_BFu8ll_BFu17ll()
{
  {
    init_simple_test("aVp_BFu8ll_BFu17ll");
    static STRUCT_IF_C aVp_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aVp_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aVp_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu17ll, aVp_BFu8ll_BFu17ll)
//============================================================================



static void Test_aVp_BFu8ll_BFu1c()
{
  {
    init_simple_test("aVp_BFu8ll_BFu1c");
    static STRUCT_IF_C aVp_BFu8ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu1c, aVp_BFu8ll_BFu1c)
//============================================================================



static void Test_aVp_BFu8ll_BFu1i()
{
  {
    init_simple_test("aVp_BFu8ll_BFu1i");
    static STRUCT_IF_C aVp_BFu8ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu1i, aVp_BFu8ll_BFu1i)
//============================================================================



static void Test_aVp_BFu8ll_BFu1ll()
{
  {
    init_simple_test("aVp_BFu8ll_BFu1ll");
    static STRUCT_IF_C aVp_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu1ll, aVp_BFu8ll_BFu1ll)
//============================================================================



static void Test_aVp_BFu8ll_BFu1s()
{
  {
    init_simple_test("aVp_BFu8ll_BFu1s");
    static STRUCT_IF_C aVp_BFu8ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu1s, aVp_BFu8ll_BFu1s)
//============================================================================



static void Test_aVp_BFu8ll_BFu31i()
{
  {
    init_simple_test("aVp_BFu8ll_BFu31i");
    static STRUCT_IF_C aVp_BFu8ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aVp_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aVp_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu31i, aVp_BFu8ll_BFu31i)
//============================================================================



static void Test_aVp_BFu8ll_BFu31ll()
{
  {
    init_simple_test("aVp_BFu8ll_BFu31ll");
    static STRUCT_IF_C aVp_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aVp_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aVp_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu31ll, aVp_BFu8ll_BFu31ll)
//============================================================================



static void Test_aVp_BFu8ll_BFu32i()
{
  {
    init_simple_test("aVp_BFu8ll_BFu32i");
    static STRUCT_IF_C aVp_BFu8ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aVp_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aVp_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu32i, aVp_BFu8ll_BFu32i)
//============================================================================



static void Test_aVp_BFu8ll_BFu32ll()
{
  {
    init_simple_test("aVp_BFu8ll_BFu32ll");
    static STRUCT_IF_C aVp_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aVp_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aVp_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu32ll, aVp_BFu8ll_BFu32ll)
//============================================================================



static void Test_aVp_BFu8ll_BFu33()
{
  {
    init_simple_test("aVp_BFu8ll_BFu33");
    static STRUCT_IF_C aVp_BFu8ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu8ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aVp_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aVp_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu33, aVp_BFu8ll_BFu33)
//============================================================================



static void Test_aVp_BFu8ll_BFu7c()
{
  {
    init_simple_test("aVp_BFu8ll_BFu7c");
    static STRUCT_IF_C aVp_BFu8ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu7c, aVp_BFu8ll_BFu7c)
//============================================================================



static void Test_aVp_BFu8ll_BFu7i()
{
  {
    init_simple_test("aVp_BFu8ll_BFu7i");
    static STRUCT_IF_C aVp_BFu8ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu7i, aVp_BFu8ll_BFu7i)
//============================================================================



static void Test_aVp_BFu8ll_BFu7ll()
{
  {
    init_simple_test("aVp_BFu8ll_BFu7ll");
    static STRUCT_IF_C aVp_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu7ll, aVp_BFu8ll_BFu7ll)
//============================================================================



static void Test_aVp_BFu8ll_BFu7s()
{
  {
    init_simple_test("aVp_BFu8ll_BFu7s");
    static STRUCT_IF_C aVp_BFu8ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu7s, aVp_BFu8ll_BFu7s)
//============================================================================



static void Test_aVp_BFu8ll_BFu8c()
{
  {
    init_simple_test("aVp_BFu8ll_BFu8c");
    static STRUCT_IF_C aVp_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu8c, aVp_BFu8ll_BFu8c)
//============================================================================



static void Test_aVp_BFu8ll_BFu8i()
{
  {
    init_simple_test("aVp_BFu8ll_BFu8i");
    static STRUCT_IF_C aVp_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu8i, aVp_BFu8ll_BFu8i)
//============================================================================



static void Test_aVp_BFu8ll_BFu8ll()
{
  {
    init_simple_test("aVp_BFu8ll_BFu8ll");
    static STRUCT_IF_C aVp_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu8ll, aVp_BFu8ll_BFu8ll)
//============================================================================



static void Test_aVp_BFu8ll_BFu8s()
{
  {
    init_simple_test("aVp_BFu8ll_BFu8s");
    static STRUCT_IF_C aVp_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu8s, aVp_BFu8ll_BFu8s)
//============================================================================



static void Test_aVp_BFu8ll_BFu9i()
{
  {
    init_simple_test("aVp_BFu8ll_BFu9i");
    static STRUCT_IF_C aVp_BFu8ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu9i, aVp_BFu8ll_BFu9i)
//============================================================================



static void Test_aVp_BFu8ll_BFu9ll()
{
  {
    init_simple_test("aVp_BFu8ll_BFu9ll");
    static STRUCT_IF_C aVp_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu9ll, aVp_BFu8ll_BFu9ll)
//============================================================================



static void Test_aVp_BFu8ll_BFu9s()
{
  {
    init_simple_test("aVp_BFu8ll_BFu9s");
    static STRUCT_IF_C aVp_BFu8ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_BFu9s, aVp_BFu8ll_BFu9s)
//============================================================================



static void Test_aVp_BFu8ll_C()
{
  {
    init_simple_test("aVp_BFu8ll_C");
    static STRUCT_IF_C aVp_BFu8ll_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_C, aVp_BFu8ll_C)
//============================================================================



static void Test_aVp_BFu8ll_D()
{
  {
    init_simple_test("aVp_BFu8ll_D");
    static STRUCT_IF_C aVp_BFu8ll_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu8ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_D, aVp_BFu8ll_D)
//============================================================================



static void Test_aVp_BFu8ll_F()
{
  {
    init_simple_test("aVp_BFu8ll_F");
    static STRUCT_IF_C aVp_BFu8ll_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_F, aVp_BFu8ll_F)
//============================================================================



static void Test_aVp_BFu8ll_I()
{
  {
    init_simple_test("aVp_BFu8ll_I");
    static STRUCT_IF_C aVp_BFu8ll_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_I, aVp_BFu8ll_I)
//============================================================================



static void Test_aVp_BFu8ll_Ip()
{
  {
    init_simple_test("aVp_BFu8ll_Ip");
    static STRUCT_IF_C aVp_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_Ip, aVp_BFu8ll_Ip)
//============================================================================



static void Test_aVp_BFu8ll_L()
{
  {
    init_simple_test("aVp_BFu8ll_L");
    static STRUCT_IF_C aVp_BFu8ll_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_L, aVp_BFu8ll_L)
//============================================================================



static void Test_aVp_BFu8ll_S()
{
  {
    init_simple_test("aVp_BFu8ll_S");
    static STRUCT_IF_C aVp_BFu8ll_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_S, aVp_BFu8ll_S)
//============================================================================



static void Test_aVp_BFu8ll_Uc()
{
  {
    init_simple_test("aVp_BFu8ll_Uc");
    static STRUCT_IF_C aVp_BFu8ll_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_Uc, aVp_BFu8ll_Uc)
//============================================================================



static void Test_aVp_BFu8ll_Ui()
{
  {
    init_simple_test("aVp_BFu8ll_Ui");
    static STRUCT_IF_C aVp_BFu8ll_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_Ui, aVp_BFu8ll_Ui)
//============================================================================



static void Test_aVp_BFu8ll_Ul()
{
  {
    init_simple_test("aVp_BFu8ll_Ul");
    static STRUCT_IF_C aVp_BFu8ll_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_Ul, aVp_BFu8ll_Ul)
//============================================================================



static void Test_aVp_BFu8ll_Us()
{
  {
    init_simple_test("aVp_BFu8ll_Us");
    static STRUCT_IF_C aVp_BFu8ll_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_Us, aVp_BFu8ll_Us)
//============================================================================



static void Test_aVp_BFu8ll_Vp()
{
  {
    init_simple_test("aVp_BFu8ll_Vp");
    static STRUCT_IF_C aVp_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "aVp_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8ll_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8ll_Vp, aVp_BFu8ll_Vp)
//============================================================================



static void Test_aVp_BFu8s()
{
  {
    init_simple_test("aVp_BFu8s");
    static STRUCT_IF_C aVp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s, aVp_BFu8s)
//============================================================================



static void Test_aVp_BFu8s_BFu15i()
{
  {
    init_simple_test("aVp_BFu8s_BFu15i");
    static STRUCT_IF_C aVp_BFu8s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu15i, aVp_BFu8s_BFu15i)
//============================================================================



static void Test_aVp_BFu8s_BFu15ll()
{
  {
    init_simple_test("aVp_BFu8s_BFu15ll");
    static STRUCT_IF_C aVp_BFu8s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu15ll, aVp_BFu8s_BFu15ll)
//============================================================================



static void Test_aVp_BFu8s_BFu15s()
{
  {
    init_simple_test("aVp_BFu8s_BFu15s");
    static STRUCT_IF_C aVp_BFu8s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu15s, aVp_BFu8s_BFu15s)
//============================================================================



static void Test_aVp_BFu8s_BFu16i()
{
  {
    init_simple_test("aVp_BFu8s_BFu16i");
    static STRUCT_IF_C aVp_BFu8s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu16i, aVp_BFu8s_BFu16i)
//============================================================================



static void Test_aVp_BFu8s_BFu16ll()
{
  {
    init_simple_test("aVp_BFu8s_BFu16ll");
    static STRUCT_IF_C aVp_BFu8s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu16ll, aVp_BFu8s_BFu16ll)
//============================================================================



static void Test_aVp_BFu8s_BFu16s()
{
  {
    init_simple_test("aVp_BFu8s_BFu16s");
    static STRUCT_IF_C aVp_BFu8s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu16s, aVp_BFu8s_BFu16s)
//============================================================================



static void Test_aVp_BFu8s_BFu17i()
{
  {
    init_simple_test("aVp_BFu8s_BFu17i");
    static STRUCT_IF_C aVp_BFu8s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu8s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aVp_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aVp_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu17i, aVp_BFu8s_BFu17i)
//============================================================================



static void Test_aVp_BFu8s_BFu17ll()
{
  {
    init_simple_test("aVp_BFu8s_BFu17ll");
    static STRUCT_IF_C aVp_BFu8s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu8s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aVp_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aVp_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu17ll, aVp_BFu8s_BFu17ll)
//============================================================================



static void Test_aVp_BFu8s_BFu1c()
{
  {
    init_simple_test("aVp_BFu8s_BFu1c");
    static STRUCT_IF_C aVp_BFu8s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu1c, aVp_BFu8s_BFu1c)
//============================================================================



static void Test_aVp_BFu8s_BFu1i()
{
  {
    init_simple_test("aVp_BFu8s_BFu1i");
    static STRUCT_IF_C aVp_BFu8s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu1i, aVp_BFu8s_BFu1i)
//============================================================================



static void Test_aVp_BFu8s_BFu1ll()
{
  {
    init_simple_test("aVp_BFu8s_BFu1ll");
    static STRUCT_IF_C aVp_BFu8s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu1ll, aVp_BFu8s_BFu1ll)
//============================================================================



static void Test_aVp_BFu8s_BFu1s()
{
  {
    init_simple_test("aVp_BFu8s_BFu1s");
    static STRUCT_IF_C aVp_BFu8s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu1s, aVp_BFu8s_BFu1s)
//============================================================================



static void Test_aVp_BFu8s_BFu31i()
{
  {
    init_simple_test("aVp_BFu8s_BFu31i");
    static STRUCT_IF_C aVp_BFu8s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aVp_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aVp_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu31i, aVp_BFu8s_BFu31i)
//============================================================================



static void Test_aVp_BFu8s_BFu31ll()
{
  {
    init_simple_test("aVp_BFu8s_BFu31ll");
    static STRUCT_IF_C aVp_BFu8s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aVp_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aVp_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu31ll, aVp_BFu8s_BFu31ll)
//============================================================================



static void Test_aVp_BFu8s_BFu32i()
{
  {
    init_simple_test("aVp_BFu8s_BFu32i");
    static STRUCT_IF_C aVp_BFu8s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aVp_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aVp_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu32i, aVp_BFu8s_BFu32i)
//============================================================================



static void Test_aVp_BFu8s_BFu32ll()
{
  {
    init_simple_test("aVp_BFu8s_BFu32ll");
    static STRUCT_IF_C aVp_BFu8s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aVp_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aVp_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu32ll, aVp_BFu8s_BFu32ll)
//============================================================================



static void Test_aVp_BFu8s_BFu33()
{
  {
    init_simple_test("aVp_BFu8s_BFu33");
    static STRUCT_IF_C aVp_BFu8s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu8s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aVp_BFu8s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aVp_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu33, aVp_BFu8s_BFu33)
//============================================================================



static void Test_aVp_BFu8s_BFu7c()
{
  {
    init_simple_test("aVp_BFu8s_BFu7c");
    static STRUCT_IF_C aVp_BFu8s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu7c, aVp_BFu8s_BFu7c)
//============================================================================



static void Test_aVp_BFu8s_BFu7i()
{
  {
    init_simple_test("aVp_BFu8s_BFu7i");
    static STRUCT_IF_C aVp_BFu8s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu7i, aVp_BFu8s_BFu7i)
//============================================================================



static void Test_aVp_BFu8s_BFu7ll()
{
  {
    init_simple_test("aVp_BFu8s_BFu7ll");
    static STRUCT_IF_C aVp_BFu8s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu7ll, aVp_BFu8s_BFu7ll)
//============================================================================



static void Test_aVp_BFu8s_BFu7s()
{
  {
    init_simple_test("aVp_BFu8s_BFu7s");
    static STRUCT_IF_C aVp_BFu8s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu7s, aVp_BFu8s_BFu7s)
//============================================================================



static void Test_aVp_BFu8s_BFu8c()
{
  {
    init_simple_test("aVp_BFu8s_BFu8c");
    static STRUCT_IF_C aVp_BFu8s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu8c, aVp_BFu8s_BFu8c)
//============================================================================



static void Test_aVp_BFu8s_BFu8i()
{
  {
    init_simple_test("aVp_BFu8s_BFu8i");
    static STRUCT_IF_C aVp_BFu8s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu8i, aVp_BFu8s_BFu8i)
//============================================================================



static void Test_aVp_BFu8s_BFu8ll()
{
  {
    init_simple_test("aVp_BFu8s_BFu8ll");
    static STRUCT_IF_C aVp_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu8ll, aVp_BFu8s_BFu8ll)
//============================================================================



static void Test_aVp_BFu8s_BFu8s()
{
  {
    init_simple_test("aVp_BFu8s_BFu8s");
    static STRUCT_IF_C aVp_BFu8s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu8s, aVp_BFu8s_BFu8s)
//============================================================================



static void Test_aVp_BFu8s_BFu9i()
{
  {
    init_simple_test("aVp_BFu8s_BFu9i");
    static STRUCT_IF_C aVp_BFu8s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu9i, aVp_BFu8s_BFu9i)
//============================================================================



static void Test_aVp_BFu8s_BFu9ll()
{
  {
    init_simple_test("aVp_BFu8s_BFu9ll");
    static STRUCT_IF_C aVp_BFu8s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu9ll, aVp_BFu8s_BFu9ll)
//============================================================================



static void Test_aVp_BFu8s_BFu9s()
{
  {
    init_simple_test("aVp_BFu8s_BFu9s");
    static STRUCT_IF_C aVp_BFu8s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_BFu9s, aVp_BFu8s_BFu9s)
//============================================================================



static void Test_aVp_BFu8s_C()
{
  {
    init_simple_test("aVp_BFu8s_C");
    static STRUCT_IF_C aVp_BFu8s_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_C)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_C, aVp_BFu8s_C)
//============================================================================



static void Test_aVp_BFu8s_D()
{
  {
    init_simple_test("aVp_BFu8s_D");
    static STRUCT_IF_C aVp_BFu8s_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu8s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_D)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_D, aVp_BFu8s_D)
//============================================================================



static void Test_aVp_BFu8s_F()
{
  {
    init_simple_test("aVp_BFu8s_F");
    static STRUCT_IF_C aVp_BFu8s_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_F)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_F, aVp_BFu8s_F)
//============================================================================



static void Test_aVp_BFu8s_I()
{
  {
    init_simple_test("aVp_BFu8s_I");
    static STRUCT_IF_C aVp_BFu8s_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_I)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_I, aVp_BFu8s_I)
//============================================================================



static void Test_aVp_BFu8s_Ip()
{
  {
    init_simple_test("aVp_BFu8s_Ip");
    static STRUCT_IF_C aVp_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu8s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_Ip, aVp_BFu8s_Ip)
//============================================================================



static void Test_aVp_BFu8s_L()
{
  {
    init_simple_test("aVp_BFu8s_L");
    static STRUCT_IF_C aVp_BFu8s_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu8s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_L)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_L, aVp_BFu8s_L)
//============================================================================



static void Test_aVp_BFu8s_S()
{
  {
    init_simple_test("aVp_BFu8s_S");
    static STRUCT_IF_C aVp_BFu8s_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_S)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_S, aVp_BFu8s_S)
//============================================================================



static void Test_aVp_BFu8s_Uc()
{
  {
    init_simple_test("aVp_BFu8s_Uc");
    static STRUCT_IF_C aVp_BFu8s_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu8s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_Uc, aVp_BFu8s_Uc)
//============================================================================



static void Test_aVp_BFu8s_Ui()
{
  {
    init_simple_test("aVp_BFu8s_Ui");
    static STRUCT_IF_C aVp_BFu8s_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu8s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_Ui, aVp_BFu8s_Ui)
//============================================================================



static void Test_aVp_BFu8s_Ul()
{
  {
    init_simple_test("aVp_BFu8s_Ul");
    static STRUCT_IF_C aVp_BFu8s_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_BFu8s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_Ul, aVp_BFu8s_Ul)
//============================================================================



static void Test_aVp_BFu8s_Us()
{
  {
    init_simple_test("aVp_BFu8s_Us");
    static STRUCT_IF_C aVp_BFu8s_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu8s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_Us, aVp_BFu8s_Us)
//============================================================================



static void Test_aVp_BFu8s_Vp()
{
  {
    init_simple_test("aVp_BFu8s_Vp");
    static STRUCT_IF_C aVp_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_BFu8s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "aVp_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aVp_BFu8s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aVp_BFu8s_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu8s_Vp, aVp_BFu8s_Vp)
//============================================================================



static void Test_aVp_BFu9i()
{
  {
    init_simple_test("aVp_BFu9i");
    static STRUCT_IF_C aVp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i, aVp_BFu9i)
//============================================================================



static void Test_aVp_BFu9i_BFu15i()
{
  {
    init_simple_test("aVp_BFu9i_BFu15i");
    static STRUCT_IF_C aVp_BFu9i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aVp_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aVp_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu15i, aVp_BFu9i_BFu15i)
//============================================================================



static void Test_aVp_BFu9i_BFu15ll()
{
  {
    init_simple_test("aVp_BFu9i_BFu15ll");
    static STRUCT_IF_C aVp_BFu9i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aVp_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aVp_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu15ll, aVp_BFu9i_BFu15ll)
//============================================================================



static void Test_aVp_BFu9i_BFu15s()
{
  {
    init_simple_test("aVp_BFu9i_BFu15s");
    static STRUCT_IF_C aVp_BFu9i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aVp_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aVp_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu15s, aVp_BFu9i_BFu15s)
//============================================================================



static void Test_aVp_BFu9i_BFu16i()
{
  {
    init_simple_test("aVp_BFu9i_BFu16i");
    static STRUCT_IF_C aVp_BFu9i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aVp_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aVp_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu16i, aVp_BFu9i_BFu16i)
//============================================================================



static void Test_aVp_BFu9i_BFu16ll()
{
  {
    init_simple_test("aVp_BFu9i_BFu16ll");
    static STRUCT_IF_C aVp_BFu9i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aVp_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aVp_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu16ll, aVp_BFu9i_BFu16ll)
//============================================================================



static void Test_aVp_BFu9i_BFu16s()
{
  {
    init_simple_test("aVp_BFu9i_BFu16s");
    static STRUCT_IF_C aVp_BFu9i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aVp_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aVp_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu16s, aVp_BFu9i_BFu16s)
//============================================================================



static void Test_aVp_BFu9i_BFu17i()
{
  {
    init_simple_test("aVp_BFu9i_BFu17i");
    static STRUCT_IF_C aVp_BFu9i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "aVp_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "aVp_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu17i, aVp_BFu9i_BFu17i)
//============================================================================



static void Test_aVp_BFu9i_BFu17ll()
{
  {
    init_simple_test("aVp_BFu9i_BFu17ll");
    static STRUCT_IF_C aVp_BFu9i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "aVp_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "aVp_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu17ll, aVp_BFu9i_BFu17ll)
//============================================================================



static void Test_aVp_BFu9i_BFu1c()
{
  {
    init_simple_test("aVp_BFu9i_BFu1c");
    static STRUCT_IF_C aVp_BFu9i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aVp_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu1c, aVp_BFu9i_BFu1c)
//============================================================================



static void Test_aVp_BFu9i_BFu1i()
{
  {
    init_simple_test("aVp_BFu9i_BFu1i");
    static STRUCT_IF_C aVp_BFu9i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aVp_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu1i, aVp_BFu9i_BFu1i)
//============================================================================



static void Test_aVp_BFu9i_BFu1ll()
{
  {
    init_simple_test("aVp_BFu9i_BFu1ll");
    static STRUCT_IF_C aVp_BFu9i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aVp_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu1ll, aVp_BFu9i_BFu1ll)
//============================================================================



static void Test_aVp_BFu9i_BFu1s()
{
  {
    init_simple_test("aVp_BFu9i_BFu1s");
    static STRUCT_IF_C aVp_BFu9i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aVp_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu1s, aVp_BFu9i_BFu1s)
//============================================================================



static void Test_aVp_BFu9i_BFu31i()
{
  {
    init_simple_test("aVp_BFu9i_BFu31i");
    static STRUCT_IF_C aVp_BFu9i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu9i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, 1, "aVp_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, hide_ull(1LL<<30), "aVp_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu31i, aVp_BFu9i_BFu31i)
//============================================================================



static void Test_aVp_BFu9i_BFu31ll()
{
  {
    init_simple_test("aVp_BFu9i_BFu31ll");
    static STRUCT_IF_C aVp_BFu9i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu9i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, 1, "aVp_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, hide_ull(1LL<<30), "aVp_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu31ll, aVp_BFu9i_BFu31ll)
//============================================================================



static void Test_aVp_BFu9i_BFu32i()
{
  {
    init_simple_test("aVp_BFu9i_BFu32i");
    static STRUCT_IF_C aVp_BFu9i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, 1, "aVp_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, hide_ull(1LL<<31), "aVp_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu32i, aVp_BFu9i_BFu32i)
//============================================================================



static void Test_aVp_BFu9i_BFu32ll()
{
  {
    init_simple_test("aVp_BFu9i_BFu32ll");
    static STRUCT_IF_C aVp_BFu9i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, 1, "aVp_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, hide_ull(1LL<<31), "aVp_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu32ll, aVp_BFu9i_BFu32ll)
//============================================================================



static void Test_aVp_BFu9i_BFu33()
{
  {
    init_simple_test("aVp_BFu9i_BFu33");
    static STRUCT_IF_C aVp_BFu9i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 33, 1, "aVp_BFu9i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 33, hide_ull(1LL<<32), "aVp_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu33, aVp_BFu9i_BFu33)
//============================================================================



static void Test_aVp_BFu9i_BFu7c()
{
  {
    init_simple_test("aVp_BFu9i_BFu7c");
    static STRUCT_IF_C aVp_BFu9i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aVp_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aVp_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu7c, aVp_BFu9i_BFu7c)
//============================================================================



static void Test_aVp_BFu9i_BFu7i()
{
  {
    init_simple_test("aVp_BFu9i_BFu7i");
    static STRUCT_IF_C aVp_BFu9i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aVp_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aVp_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu7i, aVp_BFu9i_BFu7i)
//============================================================================



static void Test_aVp_BFu9i_BFu7ll()
{
  {
    init_simple_test("aVp_BFu9i_BFu7ll");
    static STRUCT_IF_C aVp_BFu9i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aVp_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aVp_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu7ll, aVp_BFu9i_BFu7ll)
//============================================================================



static void Test_aVp_BFu9i_BFu7s()
{
  {
    init_simple_test("aVp_BFu9i_BFu7s");
    static STRUCT_IF_C aVp_BFu9i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aVp_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aVp_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu7s, aVp_BFu9i_BFu7s)
//============================================================================



static void Test_aVp_BFu9i_BFu8c()
{
  {
    init_simple_test("aVp_BFu9i_BFu8c");
    static STRUCT_IF_C aVp_BFu9i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aVp_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aVp_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu8c, aVp_BFu9i_BFu8c)
//============================================================================



static void Test_aVp_BFu9i_BFu8i()
{
  {
    init_simple_test("aVp_BFu9i_BFu8i");
    static STRUCT_IF_C aVp_BFu9i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aVp_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aVp_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu8i, aVp_BFu9i_BFu8i)
//============================================================================



static void Test_aVp_BFu9i_BFu8ll()
{
  {
    init_simple_test("aVp_BFu9i_BFu8ll");
    static STRUCT_IF_C aVp_BFu9i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aVp_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aVp_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu8ll, aVp_BFu9i_BFu8ll)
//============================================================================



static void Test_aVp_BFu9i_BFu8s()
{
  {
    init_simple_test("aVp_BFu9i_BFu8s");
    static STRUCT_IF_C aVp_BFu9i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aVp_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aVp_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu8s, aVp_BFu9i_BFu8s)
//============================================================================



static void Test_aVp_BFu9i_BFu9i()
{
  {
    init_simple_test("aVp_BFu9i_BFu9i");
    static STRUCT_IF_C aVp_BFu9i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "aVp_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu9i, aVp_BFu9i_BFu9i)
//============================================================================



static void Test_aVp_BFu9i_BFu9ll()
{
  {
    init_simple_test("aVp_BFu9i_BFu9ll");
    static STRUCT_IF_C aVp_BFu9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "aVp_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu9ll, aVp_BFu9i_BFu9ll)
//============================================================================



static void Test_aVp_BFu9i_BFu9s()
{
  {
    init_simple_test("aVp_BFu9i_BFu9s");
    static STRUCT_IF_C aVp_BFu9i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "aVp_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "aVp_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_BFu9s, aVp_BFu9i_BFu9s)
//============================================================================



static void Test_aVp_BFu9i_C()
{
  {
    init_simple_test("aVp_BFu9i_C");
    static STRUCT_IF_C aVp_BFu9i_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_C)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_C, aVp_BFu9i_C)
//============================================================================



static void Test_aVp_BFu9i_D()
{
  {
    init_simple_test("aVp_BFu9i_D");
    static STRUCT_IF_C aVp_BFu9i_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_BFu9i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_D)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_D");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_D, aVp_BFu9i_D)
//============================================================================



static void Test_aVp_BFu9i_F()
{
  {
    init_simple_test("aVp_BFu9i_F");
    static STRUCT_IF_C aVp_BFu9i_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_F)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_F");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_F, aVp_BFu9i_F)
//============================================================================



static void Test_aVp_BFu9i_I()
{
  {
    init_simple_test("aVp_BFu9i_I");
    static STRUCT_IF_C aVp_BFu9i_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_I)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_I");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_I, aVp_BFu9i_I)
//============================================================================



static void Test_aVp_BFu9i_Ip()
{
  {
    init_simple_test("aVp_BFu9i_Ip");
    static STRUCT_IF_C aVp_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_BFu9i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_Ip");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_Ip, aVp_BFu9i_Ip)
//============================================================================



static void Test_aVp_BFu9i_L()
{
  {
    init_simple_test("aVp_BFu9i_L");
    static STRUCT_IF_C aVp_BFu9i_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_BFu9i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_L)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_L");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_L, aVp_BFu9i_L)
//============================================================================



static void Test_aVp_BFu9i_S()
{
  {
    init_simple_test("aVp_BFu9i_S");
    static STRUCT_IF_C aVp_BFu9i_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_S)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_S, aVp_BFu9i_S)
//============================================================================



static void Test_aVp_BFu9i_Uc()
{
  {
    init_simple_test("aVp_BFu9i_Uc");
    static STRUCT_IF_C aVp_BFu9i_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_Uc, aVp_BFu9i_Uc)
//============================================================================



static void Test_aVp_BFu9i_Ui()
{
  {
    init_simple_test("aVp_BFu9i_Ui");
    static STRUCT_IF_C aVp_BFu9i_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_Ui");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_Ui, aVp_BFu9i_Ui)
//============================================================================



static void Test_aVp_BFu9i_Ul()
{
  {
    init_simple_test("aVp_BFu9i_Ul");
    static STRUCT_IF_C aVp_BFu9i_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_BFu9i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_Ul");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_Ul, aVp_BFu9i_Ul)
//============================================================================



static void Test_aVp_BFu9i_Us()
{
  {
    init_simple_test("aVp_BFu9i_Us");
    static STRUCT_IF_C aVp_BFu9i_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_Us, aVp_BFu9i_Us)
//============================================================================



static void Test_aVp_BFu9i_Vp()
{
  {
    init_simple_test("aVp_BFu9i_Vp");
    static STRUCT_IF_C aVp_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_BFu9i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "aVp_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9i_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9i_Vp, aVp_BFu9i_Vp)
//============================================================================



static void Test_aVp_BFu9ll()
{
  {
    init_simple_test("aVp_BFu9ll");
    static STRUCT_IF_C aVp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll, aVp_BFu9ll)
//============================================================================



static void Test_aVp_BFu9ll_BFu15i()
{
  {
    init_simple_test("aVp_BFu9ll_BFu15i");
    static STRUCT_IF_C aVp_BFu9ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aVp_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aVp_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu15i, aVp_BFu9ll_BFu15i)
//============================================================================



static void Test_aVp_BFu9ll_BFu15ll()
{
  {
    init_simple_test("aVp_BFu9ll_BFu15ll");
    static STRUCT_IF_C aVp_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aVp_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aVp_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu15ll, aVp_BFu9ll_BFu15ll)
//============================================================================



static void Test_aVp_BFu9ll_BFu15s()
{
  {
    init_simple_test("aVp_BFu9ll_BFu15s");
    static STRUCT_IF_C aVp_BFu9ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aVp_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aVp_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu15s, aVp_BFu9ll_BFu15s)
//============================================================================



static void Test_aVp_BFu9ll_BFu16i()
{
  {
    init_simple_test("aVp_BFu9ll_BFu16i");
    static STRUCT_IF_C aVp_BFu9ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aVp_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aVp_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu16i, aVp_BFu9ll_BFu16i)
//============================================================================



static void Test_aVp_BFu9ll_BFu16ll()
{
  {
    init_simple_test("aVp_BFu9ll_BFu16ll");
    static STRUCT_IF_C aVp_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aVp_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aVp_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu16ll, aVp_BFu9ll_BFu16ll)
//============================================================================



static void Test_aVp_BFu9ll_BFu16s()
{
  {
    init_simple_test("aVp_BFu9ll_BFu16s");
    static STRUCT_IF_C aVp_BFu9ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aVp_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aVp_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu16s, aVp_BFu9ll_BFu16s)
//============================================================================



static void Test_aVp_BFu9ll_BFu17i()
{
  {
    init_simple_test("aVp_BFu9ll_BFu17i");
    static STRUCT_IF_C aVp_BFu9ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "aVp_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "aVp_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu17i, aVp_BFu9ll_BFu17i)
//============================================================================



static void Test_aVp_BFu9ll_BFu17ll()
{
  {
    init_simple_test("aVp_BFu9ll_BFu17ll");
    static STRUCT_IF_C aVp_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "aVp_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "aVp_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu17ll, aVp_BFu9ll_BFu17ll)
//============================================================================



static void Test_aVp_BFu9ll_BFu1c()
{
  {
    init_simple_test("aVp_BFu9ll_BFu1c");
    static STRUCT_IF_C aVp_BFu9ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aVp_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu1c, aVp_BFu9ll_BFu1c)
//============================================================================



static void Test_aVp_BFu9ll_BFu1i()
{
  {
    init_simple_test("aVp_BFu9ll_BFu1i");
    static STRUCT_IF_C aVp_BFu9ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aVp_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu1i, aVp_BFu9ll_BFu1i)
//============================================================================



static void Test_aVp_BFu9ll_BFu1ll()
{
  {
    init_simple_test("aVp_BFu9ll_BFu1ll");
    static STRUCT_IF_C aVp_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aVp_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu1ll, aVp_BFu9ll_BFu1ll)
//============================================================================



static void Test_aVp_BFu9ll_BFu1s()
{
  {
    init_simple_test("aVp_BFu9ll_BFu1s");
    static STRUCT_IF_C aVp_BFu9ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aVp_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu1s, aVp_BFu9ll_BFu1s)
//============================================================================



static void Test_aVp_BFu9ll_BFu31i()
{
  {
    init_simple_test("aVp_BFu9ll_BFu31i");
    static STRUCT_IF_C aVp_BFu9ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu9ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, 1, "aVp_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, hide_ull(1LL<<30), "aVp_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu31i, aVp_BFu9ll_BFu31i)
//============================================================================



static void Test_aVp_BFu9ll_BFu31ll()
{
  {
    init_simple_test("aVp_BFu9ll_BFu31ll");
    static STRUCT_IF_C aVp_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, 1, "aVp_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, hide_ull(1LL<<30), "aVp_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu31ll, aVp_BFu9ll_BFu31ll)
//============================================================================



static void Test_aVp_BFu9ll_BFu32i()
{
  {
    init_simple_test("aVp_BFu9ll_BFu32i");
    static STRUCT_IF_C aVp_BFu9ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, 1, "aVp_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, hide_ull(1LL<<31), "aVp_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu32i, aVp_BFu9ll_BFu32i)
//============================================================================



static void Test_aVp_BFu9ll_BFu32ll()
{
  {
    init_simple_test("aVp_BFu9ll_BFu32ll");
    static STRUCT_IF_C aVp_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, 1, "aVp_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, hide_ull(1LL<<31), "aVp_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu32ll, aVp_BFu9ll_BFu32ll)
//============================================================================



static void Test_aVp_BFu9ll_BFu33()
{
  {
    init_simple_test("aVp_BFu9ll_BFu33");
    static STRUCT_IF_C aVp_BFu9ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 33, 1, "aVp_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 33, hide_ull(1LL<<32), "aVp_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu33, aVp_BFu9ll_BFu33)
//============================================================================



static void Test_aVp_BFu9ll_BFu7c()
{
  {
    init_simple_test("aVp_BFu9ll_BFu7c");
    static STRUCT_IF_C aVp_BFu9ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aVp_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aVp_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu7c, aVp_BFu9ll_BFu7c)
//============================================================================



static void Test_aVp_BFu9ll_BFu7i()
{
  {
    init_simple_test("aVp_BFu9ll_BFu7i");
    static STRUCT_IF_C aVp_BFu9ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aVp_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aVp_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu7i, aVp_BFu9ll_BFu7i)
//============================================================================



static void Test_aVp_BFu9ll_BFu7ll()
{
  {
    init_simple_test("aVp_BFu9ll_BFu7ll");
    static STRUCT_IF_C aVp_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aVp_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aVp_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu7ll, aVp_BFu9ll_BFu7ll)
//============================================================================



static void Test_aVp_BFu9ll_BFu7s()
{
  {
    init_simple_test("aVp_BFu9ll_BFu7s");
    static STRUCT_IF_C aVp_BFu9ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aVp_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aVp_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu7s, aVp_BFu9ll_BFu7s)
//============================================================================



static void Test_aVp_BFu9ll_BFu8c()
{
  {
    init_simple_test("aVp_BFu9ll_BFu8c");
    static STRUCT_IF_C aVp_BFu9ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aVp_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aVp_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu8c, aVp_BFu9ll_BFu8c)
//============================================================================



static void Test_aVp_BFu9ll_BFu8i()
{
  {
    init_simple_test("aVp_BFu9ll_BFu8i");
    static STRUCT_IF_C aVp_BFu9ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aVp_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aVp_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu8i, aVp_BFu9ll_BFu8i)
//============================================================================



static void Test_aVp_BFu9ll_BFu8ll()
{
  {
    init_simple_test("aVp_BFu9ll_BFu8ll");
    static STRUCT_IF_C aVp_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aVp_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aVp_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu8ll, aVp_BFu9ll_BFu8ll)
//============================================================================



static void Test_aVp_BFu9ll_BFu8s()
{
  {
    init_simple_test("aVp_BFu9ll_BFu8s");
    static STRUCT_IF_C aVp_BFu9ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aVp_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aVp_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu8s, aVp_BFu9ll_BFu8s)
//============================================================================



static void Test_aVp_BFu9ll_BFu9i()
{
  {
    init_simple_test("aVp_BFu9ll_BFu9i");
    static STRUCT_IF_C aVp_BFu9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "aVp_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu9i, aVp_BFu9ll_BFu9i)
//============================================================================



static void Test_aVp_BFu9ll_BFu9ll()
{
  {
    init_simple_test("aVp_BFu9ll_BFu9ll");
    static STRUCT_IF_C aVp_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "aVp_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu9ll, aVp_BFu9ll_BFu9ll)
//============================================================================



static void Test_aVp_BFu9ll_BFu9s()
{
  {
    init_simple_test("aVp_BFu9ll_BFu9s");
    static STRUCT_IF_C aVp_BFu9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "aVp_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "aVp_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_BFu9s, aVp_BFu9ll_BFu9s)
//============================================================================



static void Test_aVp_BFu9ll_C()
{
  {
    init_simple_test("aVp_BFu9ll_C");
    static STRUCT_IF_C aVp_BFu9ll_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_C, aVp_BFu9ll_C)
//============================================================================



static void Test_aVp_BFu9ll_D()
{
  {
    init_simple_test("aVp_BFu9ll_D");
    static STRUCT_IF_C aVp_BFu9ll_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_BFu9ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_D");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_D, aVp_BFu9ll_D)
//============================================================================



static void Test_aVp_BFu9ll_F()
{
  {
    init_simple_test("aVp_BFu9ll_F");
    static STRUCT_IF_C aVp_BFu9ll_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_F");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_F, aVp_BFu9ll_F)
//============================================================================



static void Test_aVp_BFu9ll_I()
{
  {
    init_simple_test("aVp_BFu9ll_I");
    static STRUCT_IF_C aVp_BFu9ll_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_I");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_I, aVp_BFu9ll_I)
//============================================================================



static void Test_aVp_BFu9ll_Ip()
{
  {
    init_simple_test("aVp_BFu9ll_Ip");
    static STRUCT_IF_C aVp_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_BFu9ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_Ip");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_Ip, aVp_BFu9ll_Ip)
//============================================================================



static void Test_aVp_BFu9ll_L()
{
  {
    init_simple_test("aVp_BFu9ll_L");
    static STRUCT_IF_C aVp_BFu9ll_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_BFu9ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_L");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_L, aVp_BFu9ll_L)
//============================================================================



static void Test_aVp_BFu9ll_S()
{
  {
    init_simple_test("aVp_BFu9ll_S");
    static STRUCT_IF_C aVp_BFu9ll_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_S, aVp_BFu9ll_S)
//============================================================================



static void Test_aVp_BFu9ll_Uc()
{
  {
    init_simple_test("aVp_BFu9ll_Uc");
    static STRUCT_IF_C aVp_BFu9ll_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_Uc, aVp_BFu9ll_Uc)
//============================================================================



static void Test_aVp_BFu9ll_Ui()
{
  {
    init_simple_test("aVp_BFu9ll_Ui");
    static STRUCT_IF_C aVp_BFu9ll_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_Ui");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_Ui, aVp_BFu9ll_Ui)
//============================================================================



static void Test_aVp_BFu9ll_Ul()
{
  {
    init_simple_test("aVp_BFu9ll_Ul");
    static STRUCT_IF_C aVp_BFu9ll_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_BFu9ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_Ul");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_Ul, aVp_BFu9ll_Ul)
//============================================================================



static void Test_aVp_BFu9ll_Us()
{
  {
    init_simple_test("aVp_BFu9ll_Us");
    static STRUCT_IF_C aVp_BFu9ll_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_Us, aVp_BFu9ll_Us)
//============================================================================



static void Test_aVp_BFu9ll_Vp()
{
  {
    init_simple_test("aVp_BFu9ll_Vp");
    static STRUCT_IF_C aVp_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_BFu9ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "aVp_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9ll_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9ll_Vp, aVp_BFu9ll_Vp)
//============================================================================



static void Test_aVp_BFu9s()
{
  {
    init_simple_test("aVp_BFu9s");
    static STRUCT_IF_C aVp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s, aVp_BFu9s)
//============================================================================



static void Test_aVp_BFu9s_BFu15i()
{
  {
    init_simple_test("aVp_BFu9s_BFu15i");
    static STRUCT_IF_C aVp_BFu9s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aVp_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aVp_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu15i, aVp_BFu9s_BFu15i)
//============================================================================



static void Test_aVp_BFu9s_BFu15ll()
{
  {
    init_simple_test("aVp_BFu9s_BFu15ll");
    static STRUCT_IF_C aVp_BFu9s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aVp_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aVp_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu15ll, aVp_BFu9s_BFu15ll)
//============================================================================



static void Test_aVp_BFu9s_BFu15s()
{
  {
    init_simple_test("aVp_BFu9s_BFu15s");
    static STRUCT_IF_C aVp_BFu9s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aVp_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aVp_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu15s, aVp_BFu9s_BFu15s)
//============================================================================



static void Test_aVp_BFu9s_BFu16i()
{
  {
    init_simple_test("aVp_BFu9s_BFu16i");
    static STRUCT_IF_C aVp_BFu9s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aVp_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aVp_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu16i, aVp_BFu9s_BFu16i)
//============================================================================



static void Test_aVp_BFu9s_BFu16ll()
{
  {
    init_simple_test("aVp_BFu9s_BFu16ll");
    static STRUCT_IF_C aVp_BFu9s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aVp_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aVp_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu16ll, aVp_BFu9s_BFu16ll)
//============================================================================



static void Test_aVp_BFu9s_BFu16s()
{
  {
    init_simple_test("aVp_BFu9s_BFu16s");
    static STRUCT_IF_C aVp_BFu9s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aVp_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aVp_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu16s, aVp_BFu9s_BFu16s)
//============================================================================



static void Test_aVp_BFu9s_BFu17i()
{
  {
    init_simple_test("aVp_BFu9s_BFu17i");
    static STRUCT_IF_C aVp_BFu9s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "aVp_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "aVp_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu17i, aVp_BFu9s_BFu17i)
//============================================================================



static void Test_aVp_BFu9s_BFu17ll()
{
  {
    init_simple_test("aVp_BFu9s_BFu17ll");
    static STRUCT_IF_C aVp_BFu9s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "aVp_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "aVp_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu17ll, aVp_BFu9s_BFu17ll)
//============================================================================



static void Test_aVp_BFu9s_BFu1c()
{
  {
    init_simple_test("aVp_BFu9s_BFu1c");
    static STRUCT_IF_C aVp_BFu9s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aVp_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu1c, aVp_BFu9s_BFu1c)
//============================================================================



static void Test_aVp_BFu9s_BFu1i()
{
  {
    init_simple_test("aVp_BFu9s_BFu1i");
    static STRUCT_IF_C aVp_BFu9s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aVp_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu1i, aVp_BFu9s_BFu1i)
//============================================================================



static void Test_aVp_BFu9s_BFu1ll()
{
  {
    init_simple_test("aVp_BFu9s_BFu1ll");
    static STRUCT_IF_C aVp_BFu9s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aVp_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu1ll, aVp_BFu9s_BFu1ll)
//============================================================================



static void Test_aVp_BFu9s_BFu1s()
{
  {
    init_simple_test("aVp_BFu9s_BFu1s");
    static STRUCT_IF_C aVp_BFu9s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aVp_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu1s, aVp_BFu9s_BFu1s)
//============================================================================



static void Test_aVp_BFu9s_BFu31i()
{
  {
    init_simple_test("aVp_BFu9s_BFu31i");
    static STRUCT_IF_C aVp_BFu9s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu9s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, 1, "aVp_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, hide_ull(1LL<<30), "aVp_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu31i, aVp_BFu9s_BFu31i)
//============================================================================



static void Test_aVp_BFu9s_BFu31ll()
{
  {
    init_simple_test("aVp_BFu9s_BFu31ll");
    static STRUCT_IF_C aVp_BFu9s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_BFu9s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, 1, "aVp_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, hide_ull(1LL<<30), "aVp_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu31ll, aVp_BFu9s_BFu31ll)
//============================================================================



static void Test_aVp_BFu9s_BFu32i()
{
  {
    init_simple_test("aVp_BFu9s_BFu32i");
    static STRUCT_IF_C aVp_BFu9s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, 1, "aVp_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, hide_ull(1LL<<31), "aVp_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu32i, aVp_BFu9s_BFu32i)
//============================================================================



static void Test_aVp_BFu9s_BFu32ll()
{
  {
    init_simple_test("aVp_BFu9s_BFu32ll");
    static STRUCT_IF_C aVp_BFu9s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, 1, "aVp_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, hide_ull(1LL<<31), "aVp_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu32ll, aVp_BFu9s_BFu32ll)
//============================================================================



static void Test_aVp_BFu9s_BFu33()
{
  {
    init_simple_test("aVp_BFu9s_BFu33");
    static STRUCT_IF_C aVp_BFu9s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 33, 1, "aVp_BFu9s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 33, hide_ull(1LL<<32), "aVp_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu33, aVp_BFu9s_BFu33)
//============================================================================



static void Test_aVp_BFu9s_BFu7c()
{
  {
    init_simple_test("aVp_BFu9s_BFu7c");
    static STRUCT_IF_C aVp_BFu9s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aVp_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aVp_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu7c, aVp_BFu9s_BFu7c)
//============================================================================



static void Test_aVp_BFu9s_BFu7i()
{
  {
    init_simple_test("aVp_BFu9s_BFu7i");
    static STRUCT_IF_C aVp_BFu9s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aVp_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aVp_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu7i, aVp_BFu9s_BFu7i)
//============================================================================



static void Test_aVp_BFu9s_BFu7ll()
{
  {
    init_simple_test("aVp_BFu9s_BFu7ll");
    static STRUCT_IF_C aVp_BFu9s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aVp_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aVp_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu7ll, aVp_BFu9s_BFu7ll)
//============================================================================



static void Test_aVp_BFu9s_BFu7s()
{
  {
    init_simple_test("aVp_BFu9s_BFu7s");
    static STRUCT_IF_C aVp_BFu9s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_BFu9s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aVp_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aVp_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu7s, aVp_BFu9s_BFu7s)
//============================================================================



static void Test_aVp_BFu9s_BFu8c()
{
  {
    init_simple_test("aVp_BFu9s_BFu8c");
    static STRUCT_IF_C aVp_BFu9s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aVp_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aVp_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu8c, aVp_BFu9s_BFu8c)
//============================================================================



static void Test_aVp_BFu9s_BFu8i()
{
  {
    init_simple_test("aVp_BFu9s_BFu8i");
    static STRUCT_IF_C aVp_BFu9s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aVp_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aVp_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu8i, aVp_BFu9s_BFu8i)
//============================================================================



static void Test_aVp_BFu9s_BFu8ll()
{
  {
    init_simple_test("aVp_BFu9s_BFu8ll");
    static STRUCT_IF_C aVp_BFu9s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aVp_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aVp_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu8ll, aVp_BFu9s_BFu8ll)
//============================================================================



static void Test_aVp_BFu9s_BFu8s()
{
  {
    init_simple_test("aVp_BFu9s_BFu8s");
    static STRUCT_IF_C aVp_BFu9s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aVp_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aVp_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu8s, aVp_BFu9s_BFu8s)
//============================================================================



static void Test_aVp_BFu9s_BFu9i()
{
  {
    init_simple_test("aVp_BFu9s_BFu9i");
    static STRUCT_IF_C aVp_BFu9s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "aVp_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu9i, aVp_BFu9s_BFu9i)
//============================================================================



static void Test_aVp_BFu9s_BFu9ll()
{
  {
    init_simple_test("aVp_BFu9s_BFu9ll");
    static STRUCT_IF_C aVp_BFu9s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "aVp_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu9ll, aVp_BFu9s_BFu9ll)
//============================================================================



static void Test_aVp_BFu9s_BFu9s()
{
  {
    init_simple_test("aVp_BFu9s_BFu9s");
    static STRUCT_IF_C aVp_BFu9s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "aVp_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "aVp_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_BFu9s, aVp_BFu9s_BFu9s)
//============================================================================



static void Test_aVp_BFu9s_C()
{
  {
    init_simple_test("aVp_BFu9s_C");
    static STRUCT_IF_C aVp_BFu9s_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_C)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_C, aVp_BFu9s_C)
//============================================================================



static void Test_aVp_BFu9s_D()
{
  {
    init_simple_test("aVp_BFu9s_D");
    static STRUCT_IF_C aVp_BFu9s_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_BFu9s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_D)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_D");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_D, aVp_BFu9s_D)
//============================================================================



static void Test_aVp_BFu9s_F()
{
  {
    init_simple_test("aVp_BFu9s_F");
    static STRUCT_IF_C aVp_BFu9s_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_F)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_F");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_F, aVp_BFu9s_F)
//============================================================================



static void Test_aVp_BFu9s_I()
{
  {
    init_simple_test("aVp_BFu9s_I");
    static STRUCT_IF_C aVp_BFu9s_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_I)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_I");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_I, aVp_BFu9s_I)
//============================================================================



static void Test_aVp_BFu9s_Ip()
{
  {
    init_simple_test("aVp_BFu9s_Ip");
    static STRUCT_IF_C aVp_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_BFu9s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_Ip)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_Ip");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_Ip, aVp_BFu9s_Ip)
//============================================================================



static void Test_aVp_BFu9s_L()
{
  {
    init_simple_test("aVp_BFu9s_L");
    static STRUCT_IF_C aVp_BFu9s_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_BFu9s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_L)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_L");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_L, aVp_BFu9s_L)
//============================================================================



static void Test_aVp_BFu9s_S()
{
  {
    init_simple_test("aVp_BFu9s_S");
    static STRUCT_IF_C aVp_BFu9s_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_S)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_S, aVp_BFu9s_S)
//============================================================================



static void Test_aVp_BFu9s_Uc()
{
  {
    init_simple_test("aVp_BFu9s_Uc");
    static STRUCT_IF_C aVp_BFu9s_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_BFu9s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_Uc)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_Uc, aVp_BFu9s_Uc)
//============================================================================



static void Test_aVp_BFu9s_Ui()
{
  {
    init_simple_test("aVp_BFu9s_Ui");
    static STRUCT_IF_C aVp_BFu9s_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_BFu9s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_Ui)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_Ui");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_Ui, aVp_BFu9s_Ui)
//============================================================================



static void Test_aVp_BFu9s_Ul()
{
  {
    init_simple_test("aVp_BFu9s_Ul");
    static STRUCT_IF_C aVp_BFu9s_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_BFu9s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_Ul)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_Ul");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_Ul, aVp_BFu9s_Ul)
//============================================================================



static void Test_aVp_BFu9s_Us()
{
  {
    init_simple_test("aVp_BFu9s_Us");
    static STRUCT_IF_C aVp_BFu9s_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_BFu9s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_Us)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_Us, aVp_BFu9s_Us)
//============================================================================



static void Test_aVp_BFu9s_Vp()
{
  {
    init_simple_test("aVp_BFu9s_Vp");
    static STRUCT_IF_C aVp_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_BFu9s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_BFu9s_Vp)");
    check_field_offset(lv, v1, 0, "aVp_BFu9s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aVp_BFu9s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aVp_BFu9s_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_BFu9s_Vp, aVp_BFu9s_Vp)
//============================================================================



static void Test_aVp_C()
{
  {
    init_simple_test("aVp_C");
    STRUCT_IF_C aVp_C lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C)");
    check_field_offset(lv, v1, 0, "aVp_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C, aVp_C)
//============================================================================



static void Test_aVp_C_BFu15i()
{
  {
    init_simple_test("aVp_C_BFu15i");
    static STRUCT_IF_C aVp_C_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_C_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_C_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu15i, aVp_C_BFu15i)
//============================================================================



static void Test_aVp_C_BFu15ll()
{
  {
    init_simple_test("aVp_C_BFu15ll");
    static STRUCT_IF_C aVp_C_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_C_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_C_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu15ll, aVp_C_BFu15ll)
//============================================================================



static void Test_aVp_C_BFu15s()
{
  {
    init_simple_test("aVp_C_BFu15s");
    static STRUCT_IF_C aVp_C_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_C_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_C_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu15s, aVp_C_BFu15s)
//============================================================================



static void Test_aVp_C_BFu16i()
{
  {
    init_simple_test("aVp_C_BFu16i");
    static STRUCT_IF_C aVp_C_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_C_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_C_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu16i, aVp_C_BFu16i)
//============================================================================



static void Test_aVp_C_BFu16ll()
{
  {
    init_simple_test("aVp_C_BFu16ll");
    static STRUCT_IF_C aVp_C_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_C_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_C_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu16ll, aVp_C_BFu16ll)
//============================================================================



static void Test_aVp_C_BFu16s()
{
  {
    init_simple_test("aVp_C_BFu16s");
    static STRUCT_IF_C aVp_C_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_C_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_C_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu16s, aVp_C_BFu16s)
//============================================================================



static void Test_aVp_C_BFu17i()
{
  {
    init_simple_test("aVp_C_BFu17i");
    static STRUCT_IF_C aVp_C_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_C_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aVp_C_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aVp_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu17i, aVp_C_BFu17i)
//============================================================================



static void Test_aVp_C_BFu17ll()
{
  {
    init_simple_test("aVp_C_BFu17ll");
    static STRUCT_IF_C aVp_C_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_C_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aVp_C_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aVp_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu17ll, aVp_C_BFu17ll)
//============================================================================



static void Test_aVp_C_BFu1c()
{
  {
    init_simple_test("aVp_C_BFu1c");
    static STRUCT_IF_C aVp_C_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu1c, aVp_C_BFu1c)
//============================================================================



static void Test_aVp_C_BFu1i()
{
  {
    init_simple_test("aVp_C_BFu1i");
    static STRUCT_IF_C aVp_C_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu1i, aVp_C_BFu1i)
//============================================================================



static void Test_aVp_C_BFu1ll()
{
  {
    init_simple_test("aVp_C_BFu1ll");
    static STRUCT_IF_C aVp_C_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu1ll, aVp_C_BFu1ll)
//============================================================================



static void Test_aVp_C_BFu1s()
{
  {
    init_simple_test("aVp_C_BFu1s");
    static STRUCT_IF_C aVp_C_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu1s, aVp_C_BFu1s)
//============================================================================



static void Test_aVp_C_BFu31i()
{
  {
    init_simple_test("aVp_C_BFu31i");
    static STRUCT_IF_C aVp_C_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_C_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aVp_C_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aVp_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu31i, aVp_C_BFu31i)
//============================================================================



static void Test_aVp_C_BFu31ll()
{
  {
    init_simple_test("aVp_C_BFu31ll");
    static STRUCT_IF_C aVp_C_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_C_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aVp_C_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aVp_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu31ll, aVp_C_BFu31ll)
//============================================================================



static void Test_aVp_C_BFu32i()
{
  {
    init_simple_test("aVp_C_BFu32i");
    static STRUCT_IF_C aVp_C_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_C_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aVp_C_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aVp_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu32i, aVp_C_BFu32i)
//============================================================================



static void Test_aVp_C_BFu32ll()
{
  {
    init_simple_test("aVp_C_BFu32ll");
    static STRUCT_IF_C aVp_C_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_C_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aVp_C_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aVp_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu32ll, aVp_C_BFu32ll)
//============================================================================



static void Test_aVp_C_BFu33()
{
  {
    init_simple_test("aVp_C_BFu33");
    static STRUCT_IF_C aVp_C_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_C_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aVp_C_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aVp_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu33, aVp_C_BFu33)
//============================================================================



static void Test_aVp_C_BFu7c()
{
  {
    init_simple_test("aVp_C_BFu7c");
    static STRUCT_IF_C aVp_C_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_C_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu7c, aVp_C_BFu7c)
//============================================================================



static void Test_aVp_C_BFu7i()
{
  {
    init_simple_test("aVp_C_BFu7i");
    static STRUCT_IF_C aVp_C_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_C_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu7i, aVp_C_BFu7i)
//============================================================================



static void Test_aVp_C_BFu7ll()
{
  {
    init_simple_test("aVp_C_BFu7ll");
    static STRUCT_IF_C aVp_C_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_C_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu7ll, aVp_C_BFu7ll)
//============================================================================



static void Test_aVp_C_BFu7s()
{
  {
    init_simple_test("aVp_C_BFu7s");
    static STRUCT_IF_C aVp_C_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_C_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu7s, aVp_C_BFu7s)
//============================================================================



static void Test_aVp_C_BFu8c()
{
  {
    init_simple_test("aVp_C_BFu8c");
    static STRUCT_IF_C aVp_C_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_C_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu8c, aVp_C_BFu8c)
//============================================================================



static void Test_aVp_C_BFu8i()
{
  {
    init_simple_test("aVp_C_BFu8i");
    static STRUCT_IF_C aVp_C_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_C_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu8i, aVp_C_BFu8i)
//============================================================================



static void Test_aVp_C_BFu8ll()
{
  {
    init_simple_test("aVp_C_BFu8ll");
    static STRUCT_IF_C aVp_C_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_C_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu8ll, aVp_C_BFu8ll)
//============================================================================



static void Test_aVp_C_BFu8s()
{
  {
    init_simple_test("aVp_C_BFu8s");
    static STRUCT_IF_C aVp_C_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_C_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu8s, aVp_C_BFu8s)
//============================================================================



static void Test_aVp_C_BFu9i()
{
  {
    init_simple_test("aVp_C_BFu9i");
    static STRUCT_IF_C aVp_C_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_C_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_C_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu9i, aVp_C_BFu9i)
//============================================================================



static void Test_aVp_C_BFu9ll()
{
  {
    init_simple_test("aVp_C_BFu9ll");
    static STRUCT_IF_C aVp_C_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_C_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_C_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu9ll, aVp_C_BFu9ll)
//============================================================================



static void Test_aVp_C_BFu9s()
{
  {
    init_simple_test("aVp_C_BFu9s");
    static STRUCT_IF_C aVp_C_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_C_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_C_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_C_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_BFu9s, aVp_C_BFu9s)
//============================================================================



static void Test_aVp_C_C()
{
  {
    init_simple_test("aVp_C_C");
    STRUCT_IF_C aVp_C_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_C)");
    check_field_offset(lv, v1, 0, "aVp_C_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_C.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_C, aVp_C_C)
//============================================================================



static void Test_aVp_C_D()
{
  {
    init_simple_test("aVp_C_D");
    STRUCT_IF_C aVp_C_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_C_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_D)");
    check_field_offset(lv, v1, 0, "aVp_C_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_D.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_D, aVp_C_D)
//============================================================================



static void Test_aVp_C_F()
{
  {
    init_simple_test("aVp_C_F");
    STRUCT_IF_C aVp_C_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_C_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_F)");
    check_field_offset(lv, v1, 0, "aVp_C_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_F.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_F, aVp_C_F)
//============================================================================



static void Test_aVp_C_I()
{
  {
    init_simple_test("aVp_C_I");
    STRUCT_IF_C aVp_C_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_C_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_I)");
    check_field_offset(lv, v1, 0, "aVp_C_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_I.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_I, aVp_C_I)
//============================================================================



static void Test_aVp_C_Ip()
{
  {
    init_simple_test("aVp_C_Ip");
    STRUCT_IF_C aVp_C_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_C_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_Ip)");
    check_field_offset(lv, v1, 0, "aVp_C_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_Ip, aVp_C_Ip)
//============================================================================



static void Test_aVp_C_L()
{
  {
    init_simple_test("aVp_C_L");
    STRUCT_IF_C aVp_C_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_C_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_L)");
    check_field_offset(lv, v1, 0, "aVp_C_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_L.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_L, aVp_C_L)
//============================================================================



static void Test_aVp_C_S()
{
  {
    init_simple_test("aVp_C_S");
    STRUCT_IF_C aVp_C_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_C_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_S)");
    check_field_offset(lv, v1, 0, "aVp_C_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_S.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_S, aVp_C_S)
//============================================================================



static void Test_aVp_C_Uc()
{
  {
    init_simple_test("aVp_C_Uc");
    STRUCT_IF_C aVp_C_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_Uc)");
    check_field_offset(lv, v1, 0, "aVp_C_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_Uc, aVp_C_Uc)
//============================================================================



static void Test_aVp_C_Ui()
{
  {
    init_simple_test("aVp_C_Ui");
    STRUCT_IF_C aVp_C_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_C_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_Ui)");
    check_field_offset(lv, v1, 0, "aVp_C_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_Ui, aVp_C_Ui)
//============================================================================



static void Test_aVp_C_Ul()
{
  {
    init_simple_test("aVp_C_Ul");
    STRUCT_IF_C aVp_C_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_C_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_Ul)");
    check_field_offset(lv, v1, 0, "aVp_C_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_Ul, aVp_C_Ul)
//============================================================================



static void Test_aVp_C_Us()
{
  {
    init_simple_test("aVp_C_Us");
    STRUCT_IF_C aVp_C_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_C_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_Us)");
    check_field_offset(lv, v1, 0, "aVp_C_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_Us.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_Us, aVp_C_Us)
//============================================================================



static void Test_aVp_C_Vp()
{
  {
    init_simple_test("aVp_C_Vp");
    STRUCT_IF_C aVp_C_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_C_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_C_Vp)");
    check_field_offset(lv, v1, 0, "aVp_C_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_C_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_C_Vp, aVp_C_Vp)
//============================================================================



static void Test_aVp_D()
{
  {
    init_simple_test("aVp_D");
    STRUCT_IF_C aVp_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D)");
    check_field_offset(lv, v1, 0, "aVp_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D, aVp_D)
//============================================================================



static void Test_aVp_D_BFu15i()
{
  {
    init_simple_test("aVp_D_BFu15i");
    static STRUCT_IF_C aVp_D_BFu15i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_D_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aVp_D_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aVp_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu15i, aVp_D_BFu15i)
//============================================================================



static void Test_aVp_D_BFu15ll()
{
  {
    init_simple_test("aVp_D_BFu15ll");
    static STRUCT_IF_C aVp_D_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_D_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aVp_D_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aVp_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu15ll, aVp_D_BFu15ll)
//============================================================================



static void Test_aVp_D_BFu15s()
{
  {
    init_simple_test("aVp_D_BFu15s");
    static STRUCT_IF_C aVp_D_BFu15s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_D_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aVp_D_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aVp_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu15s, aVp_D_BFu15s)
//============================================================================



static void Test_aVp_D_BFu16i()
{
  {
    init_simple_test("aVp_D_BFu16i");
    static STRUCT_IF_C aVp_D_BFu16i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_D_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aVp_D_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aVp_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu16i, aVp_D_BFu16i)
//============================================================================



static void Test_aVp_D_BFu16ll()
{
  {
    init_simple_test("aVp_D_BFu16ll");
    static STRUCT_IF_C aVp_D_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_D_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aVp_D_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aVp_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu16ll, aVp_D_BFu16ll)
//============================================================================



static void Test_aVp_D_BFu16s()
{
  {
    init_simple_test("aVp_D_BFu16s");
    static STRUCT_IF_C aVp_D_BFu16s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_D_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aVp_D_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aVp_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu16s, aVp_D_BFu16s)
//============================================================================



static void Test_aVp_D_BFu17i()
{
  {
    init_simple_test("aVp_D_BFu17i");
    static STRUCT_IF_C aVp_D_BFu17i lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aVp_D_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "aVp_D_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "aVp_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu17i, aVp_D_BFu17i)
//============================================================================



static void Test_aVp_D_BFu17ll()
{
  {
    init_simple_test("aVp_D_BFu17ll");
    static STRUCT_IF_C aVp_D_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aVp_D_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "aVp_D_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "aVp_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu17ll, aVp_D_BFu17ll)
//============================================================================



static void Test_aVp_D_BFu1c()
{
  {
    init_simple_test("aVp_D_BFu1c");
    static STRUCT_IF_C aVp_D_BFu1c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aVp_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu1c, aVp_D_BFu1c)
//============================================================================



static void Test_aVp_D_BFu1i()
{
  {
    init_simple_test("aVp_D_BFu1i");
    static STRUCT_IF_C aVp_D_BFu1i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aVp_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu1i, aVp_D_BFu1i)
//============================================================================



static void Test_aVp_D_BFu1ll()
{
  {
    init_simple_test("aVp_D_BFu1ll");
    static STRUCT_IF_C aVp_D_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aVp_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu1ll, aVp_D_BFu1ll)
//============================================================================



static void Test_aVp_D_BFu1s()
{
  {
    init_simple_test("aVp_D_BFu1s");
    static STRUCT_IF_C aVp_D_BFu1s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aVp_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu1s, aVp_D_BFu1s)
//============================================================================



static void Test_aVp_D_BFu31i()
{
  {
    init_simple_test("aVp_D_BFu31i");
    static STRUCT_IF_C aVp_D_BFu31i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_D_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "aVp_D_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "aVp_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu31i, aVp_D_BFu31i)
//============================================================================



static void Test_aVp_D_BFu31ll()
{
  {
    init_simple_test("aVp_D_BFu31ll");
    static STRUCT_IF_C aVp_D_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_D_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "aVp_D_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "aVp_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu31ll, aVp_D_BFu31ll)
//============================================================================



static void Test_aVp_D_BFu32i()
{
  {
    init_simple_test("aVp_D_BFu32i");
    static STRUCT_IF_C aVp_D_BFu32i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_D_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "aVp_D_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "aVp_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu32i, aVp_D_BFu32i)
//============================================================================



static void Test_aVp_D_BFu32ll()
{
  {
    init_simple_test("aVp_D_BFu32ll");
    static STRUCT_IF_C aVp_D_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_D_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "aVp_D_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "aVp_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu32ll, aVp_D_BFu32ll)
//============================================================================



static void Test_aVp_D_BFu33()
{
  {
    init_simple_test("aVp_D_BFu33");
    static STRUCT_IF_C aVp_D_BFu33 lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(aVp_D_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "aVp_D_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "aVp_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu33, aVp_D_BFu33)
//============================================================================



static void Test_aVp_D_BFu7c()
{
  {
    init_simple_test("aVp_D_BFu7c");
    static STRUCT_IF_C aVp_D_BFu7c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aVp_D_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aVp_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu7c, aVp_D_BFu7c)
//============================================================================



static void Test_aVp_D_BFu7i()
{
  {
    init_simple_test("aVp_D_BFu7i");
    static STRUCT_IF_C aVp_D_BFu7i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aVp_D_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aVp_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu7i, aVp_D_BFu7i)
//============================================================================



static void Test_aVp_D_BFu7ll()
{
  {
    init_simple_test("aVp_D_BFu7ll");
    static STRUCT_IF_C aVp_D_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aVp_D_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aVp_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu7ll, aVp_D_BFu7ll)
//============================================================================



static void Test_aVp_D_BFu7s()
{
  {
    init_simple_test("aVp_D_BFu7s");
    static STRUCT_IF_C aVp_D_BFu7s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aVp_D_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aVp_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu7s, aVp_D_BFu7s)
//============================================================================



static void Test_aVp_D_BFu8c()
{
  {
    init_simple_test("aVp_D_BFu8c");
    static STRUCT_IF_C aVp_D_BFu8c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aVp_D_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aVp_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu8c, aVp_D_BFu8c)
//============================================================================



static void Test_aVp_D_BFu8i()
{
  {
    init_simple_test("aVp_D_BFu8i");
    static STRUCT_IF_C aVp_D_BFu8i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aVp_D_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aVp_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu8i, aVp_D_BFu8i)
//============================================================================



static void Test_aVp_D_BFu8ll()
{
  {
    init_simple_test("aVp_D_BFu8ll");
    static STRUCT_IF_C aVp_D_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aVp_D_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aVp_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu8ll, aVp_D_BFu8ll)
//============================================================================



static void Test_aVp_D_BFu8s()
{
  {
    init_simple_test("aVp_D_BFu8s");
    static STRUCT_IF_C aVp_D_BFu8s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aVp_D_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aVp_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu8s, aVp_D_BFu8s)
//============================================================================



static void Test_aVp_D_BFu9i()
{
  {
    init_simple_test("aVp_D_BFu9i");
    static STRUCT_IF_C aVp_D_BFu9i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_D_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aVp_D_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aVp_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu9i, aVp_D_BFu9i)
//============================================================================



static void Test_aVp_D_BFu9ll()
{
  {
    init_simple_test("aVp_D_BFu9ll");
    static STRUCT_IF_C aVp_D_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aVp_D_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aVp_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu9ll, aVp_D_BFu9ll)
//============================================================================



static void Test_aVp_D_BFu9s()
{
  {
    init_simple_test("aVp_D_BFu9s");
    static STRUCT_IF_C aVp_D_BFu9s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_D_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aVp_D_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aVp_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_BFu9s, aVp_D_BFu9s)
//============================================================================



static void Test_aVp_D_C()
{
  {
    init_simple_test("aVp_D_C");
    STRUCT_IF_C aVp_D_C lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_C)");
    check_field_offset(lv, v1, 0, "aVp_D_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_C, aVp_D_C)
//============================================================================



static void Test_aVp_D_D()
{
  {
    init_simple_test("aVp_D_D");
    STRUCT_IF_C aVp_D_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aVp_D_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_D)");
    check_field_offset(lv, v1, 0, "aVp_D_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_D, aVp_D_D)
//============================================================================



static void Test_aVp_D_F()
{
  {
    init_simple_test("aVp_D_F");
    STRUCT_IF_C aVp_D_F lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_D_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_F)");
    check_field_offset(lv, v1, 0, "aVp_D_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_F, aVp_D_F)
//============================================================================



static void Test_aVp_D_I()
{
  {
    init_simple_test("aVp_D_I");
    STRUCT_IF_C aVp_D_I lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_D_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_I)");
    check_field_offset(lv, v1, 0, "aVp_D_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_I, aVp_D_I)
//============================================================================



static void Test_aVp_D_Ip()
{
  {
    init_simple_test("aVp_D_Ip");
    STRUCT_IF_C aVp_D_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aVp_D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_Ip)");
    check_field_offset(lv, v1, 0, "aVp_D_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_Ip, aVp_D_Ip)
//============================================================================



static void Test_aVp_D_L()
{
  {
    init_simple_test("aVp_D_L");
    STRUCT_IF_C aVp_D_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aVp_D_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_L)");
    check_field_offset(lv, v1, 0, "aVp_D_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_L, aVp_D_L)
//============================================================================



static void Test_aVp_D_S()
{
  {
    init_simple_test("aVp_D_S");
    STRUCT_IF_C aVp_D_S lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_D_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_S)");
    check_field_offset(lv, v1, 0, "aVp_D_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_S, aVp_D_S)
//============================================================================



static void Test_aVp_D_Uc()
{
  {
    init_simple_test("aVp_D_Uc");
    STRUCT_IF_C aVp_D_Uc lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_Uc)");
    check_field_offset(lv, v1, 0, "aVp_D_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_Uc, aVp_D_Uc)
//============================================================================



static void Test_aVp_D_Ui()
{
  {
    init_simple_test("aVp_D_Ui");
    STRUCT_IF_C aVp_D_Ui lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_Ui)");
    check_field_offset(lv, v1, 0, "aVp_D_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_Ui, aVp_D_Ui)
//============================================================================



static void Test_aVp_D_Ul()
{
  {
    init_simple_test("aVp_D_Ul");
    STRUCT_IF_C aVp_D_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aVp_D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_Ul)");
    check_field_offset(lv, v1, 0, "aVp_D_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_Ul, aVp_D_Ul)
//============================================================================



static void Test_aVp_D_Us()
{
  {
    init_simple_test("aVp_D_Us");
    STRUCT_IF_C aVp_D_Us lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_Us)");
    check_field_offset(lv, v1, 0, "aVp_D_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_Us, aVp_D_Us)
//============================================================================



static void Test_aVp_D_Vp()
{
  {
    init_simple_test("aVp_D_Vp");
    STRUCT_IF_C aVp_D_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aVp_D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_D_Vp)");
    check_field_offset(lv, v1, 0, "aVp_D_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_D_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_D_Vp, aVp_D_Vp)
//============================================================================



static void Test_aVp_F()
{
  {
    init_simple_test("aVp_F");
    STRUCT_IF_C aVp_F lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F)");
    check_field_offset(lv, v1, 0, "aVp_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F, aVp_F)
//============================================================================



static void Test_aVp_F_BFu15i()
{
  {
    init_simple_test("aVp_F_BFu15i");
    static STRUCT_IF_C aVp_F_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aVp_F_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aVp_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu15i, aVp_F_BFu15i)
//============================================================================



static void Test_aVp_F_BFu15ll()
{
  {
    init_simple_test("aVp_F_BFu15ll");
    static STRUCT_IF_C aVp_F_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aVp_F_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aVp_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu15ll, aVp_F_BFu15ll)
//============================================================================



static void Test_aVp_F_BFu15s()
{
  {
    init_simple_test("aVp_F_BFu15s");
    static STRUCT_IF_C aVp_F_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aVp_F_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aVp_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu15s, aVp_F_BFu15s)
//============================================================================



static void Test_aVp_F_BFu16i()
{
  {
    init_simple_test("aVp_F_BFu16i");
    static STRUCT_IF_C aVp_F_BFu16i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aVp_F_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aVp_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu16i, aVp_F_BFu16i)
//============================================================================



static void Test_aVp_F_BFu16ll()
{
  {
    init_simple_test("aVp_F_BFu16ll");
    static STRUCT_IF_C aVp_F_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aVp_F_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aVp_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu16ll, aVp_F_BFu16ll)
//============================================================================



static void Test_aVp_F_BFu16s()
{
  {
    init_simple_test("aVp_F_BFu16s");
    static STRUCT_IF_C aVp_F_BFu16s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aVp_F_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aVp_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu16s, aVp_F_BFu16s)
//============================================================================



static void Test_aVp_F_BFu17i()
{
  {
    init_simple_test("aVp_F_BFu17i");
    static STRUCT_IF_C aVp_F_BFu17i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "aVp_F_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "aVp_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu17i, aVp_F_BFu17i)
//============================================================================



static void Test_aVp_F_BFu17ll()
{
  {
    init_simple_test("aVp_F_BFu17ll");
    static STRUCT_IF_C aVp_F_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "aVp_F_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "aVp_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu17ll, aVp_F_BFu17ll)
//============================================================================



static void Test_aVp_F_BFu1c()
{
  {
    init_simple_test("aVp_F_BFu1c");
    static STRUCT_IF_C aVp_F_BFu1c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aVp_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu1c, aVp_F_BFu1c)
//============================================================================



static void Test_aVp_F_BFu1i()
{
  {
    init_simple_test("aVp_F_BFu1i");
    static STRUCT_IF_C aVp_F_BFu1i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aVp_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu1i, aVp_F_BFu1i)
//============================================================================



static void Test_aVp_F_BFu1ll()
{
  {
    init_simple_test("aVp_F_BFu1ll");
    static STRUCT_IF_C aVp_F_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aVp_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu1ll, aVp_F_BFu1ll)
//============================================================================



static void Test_aVp_F_BFu1s()
{
  {
    init_simple_test("aVp_F_BFu1s");
    static STRUCT_IF_C aVp_F_BFu1s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aVp_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu1s, aVp_F_BFu1s)
//============================================================================



static void Test_aVp_F_BFu31i()
{
  {
    init_simple_test("aVp_F_BFu31i");
    static STRUCT_IF_C aVp_F_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "aVp_F_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "aVp_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu31i, aVp_F_BFu31i)
//============================================================================



static void Test_aVp_F_BFu31ll()
{
  {
    init_simple_test("aVp_F_BFu31ll");
    static STRUCT_IF_C aVp_F_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "aVp_F_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "aVp_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu31ll, aVp_F_BFu31ll)
//============================================================================



static void Test_aVp_F_BFu32i()
{
  {
    init_simple_test("aVp_F_BFu32i");
    static STRUCT_IF_C aVp_F_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "aVp_F_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "aVp_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu32i, aVp_F_BFu32i)
//============================================================================



static void Test_aVp_F_BFu32ll()
{
  {
    init_simple_test("aVp_F_BFu32ll");
    static STRUCT_IF_C aVp_F_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "aVp_F_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "aVp_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu32ll, aVp_F_BFu32ll)
//============================================================================



static void Test_aVp_F_BFu33()
{
  {
    init_simple_test("aVp_F_BFu33");
    static STRUCT_IF_C aVp_F_BFu33 lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, 1, "aVp_F_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, hide_ull(1LL<<32), "aVp_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu33, aVp_F_BFu33)
//============================================================================



static void Test_aVp_F_BFu7c()
{
  {
    init_simple_test("aVp_F_BFu7c");
    static STRUCT_IF_C aVp_F_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_F_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu7c, aVp_F_BFu7c)
//============================================================================



static void Test_aVp_F_BFu7i()
{
  {
    init_simple_test("aVp_F_BFu7i");
    static STRUCT_IF_C aVp_F_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_F_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu7i, aVp_F_BFu7i)
//============================================================================



static void Test_aVp_F_BFu7ll()
{
  {
    init_simple_test("aVp_F_BFu7ll");
    static STRUCT_IF_C aVp_F_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_F_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu7ll, aVp_F_BFu7ll)
//============================================================================



static void Test_aVp_F_BFu7s()
{
  {
    init_simple_test("aVp_F_BFu7s");
    static STRUCT_IF_C aVp_F_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_F_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu7s, aVp_F_BFu7s)
//============================================================================



static void Test_aVp_F_BFu8c()
{
  {
    init_simple_test("aVp_F_BFu8c");
    static STRUCT_IF_C aVp_F_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_F_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu8c, aVp_F_BFu8c)
//============================================================================



static void Test_aVp_F_BFu8i()
{
  {
    init_simple_test("aVp_F_BFu8i");
    static STRUCT_IF_C aVp_F_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_F_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu8i, aVp_F_BFu8i)
//============================================================================



static void Test_aVp_F_BFu8ll()
{
  {
    init_simple_test("aVp_F_BFu8ll");
    static STRUCT_IF_C aVp_F_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_F_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu8ll, aVp_F_BFu8ll)
//============================================================================



static void Test_aVp_F_BFu8s()
{
  {
    init_simple_test("aVp_F_BFu8s");
    static STRUCT_IF_C aVp_F_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_F_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu8s, aVp_F_BFu8s)
//============================================================================



static void Test_aVp_F_BFu9i()
{
  {
    init_simple_test("aVp_F_BFu9i");
    static STRUCT_IF_C aVp_F_BFu9i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_F_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aVp_F_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aVp_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu9i, aVp_F_BFu9i)
//============================================================================



static void Test_aVp_F_BFu9ll()
{
  {
    init_simple_test("aVp_F_BFu9ll");
    static STRUCT_IF_C aVp_F_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_F_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aVp_F_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aVp_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu9ll, aVp_F_BFu9ll)
//============================================================================



static void Test_aVp_F_BFu9s()
{
  {
    init_simple_test("aVp_F_BFu9s");
    static STRUCT_IF_C aVp_F_BFu9s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_F_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_F_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aVp_F_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aVp_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_BFu9s, aVp_F_BFu9s)
//============================================================================



static void Test_aVp_F_C()
{
  {
    init_simple_test("aVp_F_C");
    STRUCT_IF_C aVp_F_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_C)");
    check_field_offset(lv, v1, 0, "aVp_F_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_C.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_C, aVp_F_C)
//============================================================================



static void Test_aVp_F_D()
{
  {
    init_simple_test("aVp_F_D");
    STRUCT_IF_C aVp_F_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_F_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_D)");
    check_field_offset(lv, v1, 0, "aVp_F_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_D.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_D, aVp_F_D)
//============================================================================



static void Test_aVp_F_F()
{
  {
    init_simple_test("aVp_F_F");
    STRUCT_IF_C aVp_F_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_F_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_F)");
    check_field_offset(lv, v1, 0, "aVp_F_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_F.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_F, aVp_F_F)
//============================================================================



static void Test_aVp_F_I()
{
  {
    init_simple_test("aVp_F_I");
    STRUCT_IF_C aVp_F_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_F_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_I)");
    check_field_offset(lv, v1, 0, "aVp_F_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_I.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_I, aVp_F_I)
//============================================================================



static void Test_aVp_F_Ip()
{
  {
    init_simple_test("aVp_F_Ip");
    STRUCT_IF_C aVp_F_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_F_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_Ip)");
    check_field_offset(lv, v1, 0, "aVp_F_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_Ip, aVp_F_Ip)
//============================================================================



static void Test_aVp_F_L()
{
  {
    init_simple_test("aVp_F_L");
    STRUCT_IF_C aVp_F_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_F_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_L)");
    check_field_offset(lv, v1, 0, "aVp_F_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_L.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_L, aVp_F_L)
//============================================================================



static void Test_aVp_F_S()
{
  {
    init_simple_test("aVp_F_S");
    STRUCT_IF_C aVp_F_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_F_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_S)");
    check_field_offset(lv, v1, 0, "aVp_F_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_S.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_S, aVp_F_S)
//============================================================================



static void Test_aVp_F_Uc()
{
  {
    init_simple_test("aVp_F_Uc");
    STRUCT_IF_C aVp_F_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_F_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_Uc)");
    check_field_offset(lv, v1, 0, "aVp_F_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_Uc, aVp_F_Uc)
//============================================================================



static void Test_aVp_F_Ui()
{
  {
    init_simple_test("aVp_F_Ui");
    STRUCT_IF_C aVp_F_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_F_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_Ui)");
    check_field_offset(lv, v1, 0, "aVp_F_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_Ui, aVp_F_Ui)
//============================================================================



static void Test_aVp_F_Ul()
{
  {
    init_simple_test("aVp_F_Ul");
    STRUCT_IF_C aVp_F_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_F_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_Ul)");
    check_field_offset(lv, v1, 0, "aVp_F_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_Ul, aVp_F_Ul)
//============================================================================



static void Test_aVp_F_Us()
{
  {
    init_simple_test("aVp_F_Us");
    STRUCT_IF_C aVp_F_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_Us)");
    check_field_offset(lv, v1, 0, "aVp_F_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_Us.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_Us, aVp_F_Us)
//============================================================================



static void Test_aVp_F_Vp()
{
  {
    init_simple_test("aVp_F_Vp");
    STRUCT_IF_C aVp_F_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_F_Vp)");
    check_field_offset(lv, v1, 0, "aVp_F_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_F_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_F_Vp, aVp_F_Vp)
//============================================================================



static void Test_aVp_I()
{
  {
    init_simple_test("aVp_I");
    STRUCT_IF_C aVp_I lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I)");
    check_field_offset(lv, v1, 0, "aVp_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I, aVp_I)
//============================================================================



static void Test_aVp_I_BFu15i()
{
  {
    init_simple_test("aVp_I_BFu15i");
    static STRUCT_IF_C aVp_I_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aVp_I_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aVp_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu15i, aVp_I_BFu15i)
//============================================================================



static void Test_aVp_I_BFu15ll()
{
  {
    init_simple_test("aVp_I_BFu15ll");
    static STRUCT_IF_C aVp_I_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aVp_I_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aVp_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu15ll, aVp_I_BFu15ll)
//============================================================================



static void Test_aVp_I_BFu15s()
{
  {
    init_simple_test("aVp_I_BFu15s");
    static STRUCT_IF_C aVp_I_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aVp_I_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aVp_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu15s, aVp_I_BFu15s)
//============================================================================



static void Test_aVp_I_BFu16i()
{
  {
    init_simple_test("aVp_I_BFu16i");
    static STRUCT_IF_C aVp_I_BFu16i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aVp_I_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aVp_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu16i, aVp_I_BFu16i)
//============================================================================



static void Test_aVp_I_BFu16ll()
{
  {
    init_simple_test("aVp_I_BFu16ll");
    static STRUCT_IF_C aVp_I_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aVp_I_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aVp_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu16ll, aVp_I_BFu16ll)
//============================================================================



static void Test_aVp_I_BFu16s()
{
  {
    init_simple_test("aVp_I_BFu16s");
    static STRUCT_IF_C aVp_I_BFu16s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aVp_I_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aVp_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu16s, aVp_I_BFu16s)
//============================================================================



static void Test_aVp_I_BFu17i()
{
  {
    init_simple_test("aVp_I_BFu17i");
    static STRUCT_IF_C aVp_I_BFu17i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "aVp_I_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "aVp_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu17i, aVp_I_BFu17i)
//============================================================================



static void Test_aVp_I_BFu17ll()
{
  {
    init_simple_test("aVp_I_BFu17ll");
    static STRUCT_IF_C aVp_I_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "aVp_I_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "aVp_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu17ll, aVp_I_BFu17ll)
//============================================================================



static void Test_aVp_I_BFu1c()
{
  {
    init_simple_test("aVp_I_BFu1c");
    static STRUCT_IF_C aVp_I_BFu1c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aVp_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu1c, aVp_I_BFu1c)
//============================================================================



static void Test_aVp_I_BFu1i()
{
  {
    init_simple_test("aVp_I_BFu1i");
    static STRUCT_IF_C aVp_I_BFu1i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aVp_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu1i, aVp_I_BFu1i)
//============================================================================



static void Test_aVp_I_BFu1ll()
{
  {
    init_simple_test("aVp_I_BFu1ll");
    static STRUCT_IF_C aVp_I_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aVp_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu1ll, aVp_I_BFu1ll)
//============================================================================



static void Test_aVp_I_BFu1s()
{
  {
    init_simple_test("aVp_I_BFu1s");
    static STRUCT_IF_C aVp_I_BFu1s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aVp_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu1s, aVp_I_BFu1s)
//============================================================================



static void Test_aVp_I_BFu31i()
{
  {
    init_simple_test("aVp_I_BFu31i");
    static STRUCT_IF_C aVp_I_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "aVp_I_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "aVp_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu31i, aVp_I_BFu31i)
//============================================================================



static void Test_aVp_I_BFu31ll()
{
  {
    init_simple_test("aVp_I_BFu31ll");
    static STRUCT_IF_C aVp_I_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "aVp_I_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "aVp_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu31ll, aVp_I_BFu31ll)
//============================================================================



static void Test_aVp_I_BFu32i()
{
  {
    init_simple_test("aVp_I_BFu32i");
    static STRUCT_IF_C aVp_I_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "aVp_I_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "aVp_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu32i, aVp_I_BFu32i)
//============================================================================



static void Test_aVp_I_BFu32ll()
{
  {
    init_simple_test("aVp_I_BFu32ll");
    static STRUCT_IF_C aVp_I_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "aVp_I_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "aVp_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu32ll, aVp_I_BFu32ll)
//============================================================================



static void Test_aVp_I_BFu33()
{
  {
    init_simple_test("aVp_I_BFu33");
    static STRUCT_IF_C aVp_I_BFu33 lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, 1, "aVp_I_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, hide_ull(1LL<<32), "aVp_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu33, aVp_I_BFu33)
//============================================================================



static void Test_aVp_I_BFu7c()
{
  {
    init_simple_test("aVp_I_BFu7c");
    static STRUCT_IF_C aVp_I_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_I_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu7c, aVp_I_BFu7c)
//============================================================================



static void Test_aVp_I_BFu7i()
{
  {
    init_simple_test("aVp_I_BFu7i");
    static STRUCT_IF_C aVp_I_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_I_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu7i, aVp_I_BFu7i)
//============================================================================



static void Test_aVp_I_BFu7ll()
{
  {
    init_simple_test("aVp_I_BFu7ll");
    static STRUCT_IF_C aVp_I_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_I_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu7ll, aVp_I_BFu7ll)
//============================================================================



static void Test_aVp_I_BFu7s()
{
  {
    init_simple_test("aVp_I_BFu7s");
    static STRUCT_IF_C aVp_I_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_I_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu7s, aVp_I_BFu7s)
//============================================================================



static void Test_aVp_I_BFu8c()
{
  {
    init_simple_test("aVp_I_BFu8c");
    static STRUCT_IF_C aVp_I_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_I_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu8c, aVp_I_BFu8c)
//============================================================================



static void Test_aVp_I_BFu8i()
{
  {
    init_simple_test("aVp_I_BFu8i");
    static STRUCT_IF_C aVp_I_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_I_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu8i, aVp_I_BFu8i)
//============================================================================



static void Test_aVp_I_BFu8ll()
{
  {
    init_simple_test("aVp_I_BFu8ll");
    static STRUCT_IF_C aVp_I_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_I_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu8ll, aVp_I_BFu8ll)
//============================================================================



static void Test_aVp_I_BFu8s()
{
  {
    init_simple_test("aVp_I_BFu8s");
    static STRUCT_IF_C aVp_I_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_I_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu8s, aVp_I_BFu8s)
//============================================================================



static void Test_aVp_I_BFu9i()
{
  {
    init_simple_test("aVp_I_BFu9i");
    static STRUCT_IF_C aVp_I_BFu9i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aVp_I_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aVp_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu9i, aVp_I_BFu9i)
//============================================================================



static void Test_aVp_I_BFu9ll()
{
  {
    init_simple_test("aVp_I_BFu9ll");
    static STRUCT_IF_C aVp_I_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aVp_I_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aVp_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu9ll, aVp_I_BFu9ll)
//============================================================================



static void Test_aVp_I_BFu9s()
{
  {
    init_simple_test("aVp_I_BFu9s");
    static STRUCT_IF_C aVp_I_BFu9s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_I_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aVp_I_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aVp_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_BFu9s, aVp_I_BFu9s)
//============================================================================



static void Test_aVp_I_C()
{
  {
    init_simple_test("aVp_I_C");
    STRUCT_IF_C aVp_I_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_C)");
    check_field_offset(lv, v1, 0, "aVp_I_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_C.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_C, aVp_I_C)
//============================================================================



static void Test_aVp_I_D()
{
  {
    init_simple_test("aVp_I_D");
    STRUCT_IF_C aVp_I_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_D)");
    check_field_offset(lv, v1, 0, "aVp_I_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_D.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_D, aVp_I_D)
//============================================================================



static void Test_aVp_I_F()
{
  {
    init_simple_test("aVp_I_F");
    STRUCT_IF_C aVp_I_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_F)");
    check_field_offset(lv, v1, 0, "aVp_I_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_F.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_F, aVp_I_F)
//============================================================================



static void Test_aVp_I_I()
{
  {
    init_simple_test("aVp_I_I");
    STRUCT_IF_C aVp_I_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_I)");
    check_field_offset(lv, v1, 0, "aVp_I_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_I.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_I, aVp_I_I)
//============================================================================



static void Test_aVp_I_Ip()
{
  {
    init_simple_test("aVp_I_Ip");
    STRUCT_IF_C aVp_I_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_Ip)");
    check_field_offset(lv, v1, 0, "aVp_I_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_Ip, aVp_I_Ip)
//============================================================================



static void Test_aVp_I_L()
{
  {
    init_simple_test("aVp_I_L");
    STRUCT_IF_C aVp_I_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_L)");
    check_field_offset(lv, v1, 0, "aVp_I_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_L.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_L, aVp_I_L)
//============================================================================



static void Test_aVp_I_S()
{
  {
    init_simple_test("aVp_I_S");
    STRUCT_IF_C aVp_I_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_S)");
    check_field_offset(lv, v1, 0, "aVp_I_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_S.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_S, aVp_I_S)
//============================================================================



static void Test_aVp_I_Uc()
{
  {
    init_simple_test("aVp_I_Uc");
    STRUCT_IF_C aVp_I_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_Uc)");
    check_field_offset(lv, v1, 0, "aVp_I_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_Uc, aVp_I_Uc)
//============================================================================



static void Test_aVp_I_Ui()
{
  {
    init_simple_test("aVp_I_Ui");
    STRUCT_IF_C aVp_I_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_Ui)");
    check_field_offset(lv, v1, 0, "aVp_I_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_Ui, aVp_I_Ui)
//============================================================================



static void Test_aVp_I_Ul()
{
  {
    init_simple_test("aVp_I_Ul");
    STRUCT_IF_C aVp_I_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_Ul)");
    check_field_offset(lv, v1, 0, "aVp_I_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_Ul, aVp_I_Ul)
//============================================================================



static void Test_aVp_I_Us()
{
  {
    init_simple_test("aVp_I_Us");
    STRUCT_IF_C aVp_I_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_Us)");
    check_field_offset(lv, v1, 0, "aVp_I_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_Us.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_Us, aVp_I_Us)
//============================================================================



static void Test_aVp_I_Vp()
{
  {
    init_simple_test("aVp_I_Vp");
    STRUCT_IF_C aVp_I_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_I_Vp)");
    check_field_offset(lv, v1, 0, "aVp_I_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_I_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_I_Vp, aVp_I_Vp)
//============================================================================



static void Test_aVp_Ip()
{
  {
    init_simple_test("aVp_Ip");
    STRUCT_IF_C aVp_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aVp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip)");
    check_field_offset(lv, v1, 0, "aVp_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip, aVp_Ip)
//============================================================================



static void Test_aVp_Ip_BFu15i()
{
  {
    init_simple_test("aVp_Ip_BFu15i");
    static STRUCT_IF_C aVp_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "aVp_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "aVp_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu15i, aVp_Ip_BFu15i)
//============================================================================



static void Test_aVp_Ip_BFu15ll()
{
  {
    init_simple_test("aVp_Ip_BFu15ll");
    static STRUCT_IF_C aVp_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "aVp_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "aVp_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu15ll, aVp_Ip_BFu15ll)
//============================================================================



static void Test_aVp_Ip_BFu15s()
{
  {
    init_simple_test("aVp_Ip_BFu15s");
    static STRUCT_IF_C aVp_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "aVp_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "aVp_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu15s, aVp_Ip_BFu15s)
//============================================================================



static void Test_aVp_Ip_BFu16i()
{
  {
    init_simple_test("aVp_Ip_BFu16i");
    static STRUCT_IF_C aVp_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "aVp_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "aVp_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu16i, aVp_Ip_BFu16i)
//============================================================================



static void Test_aVp_Ip_BFu16ll()
{
  {
    init_simple_test("aVp_Ip_BFu16ll");
    static STRUCT_IF_C aVp_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "aVp_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "aVp_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu16ll, aVp_Ip_BFu16ll)
//============================================================================



static void Test_aVp_Ip_BFu16s()
{
  {
    init_simple_test("aVp_Ip_BFu16s");
    static STRUCT_IF_C aVp_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "aVp_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "aVp_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu16s, aVp_Ip_BFu16s)
//============================================================================



static void Test_aVp_Ip_BFu17i()
{
  {
    init_simple_test("aVp_Ip_BFu17i");
    static STRUCT_IF_C aVp_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(19,11), "sizeof(aVp_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "aVp_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "aVp_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu17i, aVp_Ip_BFu17i)
//============================================================================



static void Test_aVp_Ip_BFu17ll()
{
  {
    init_simple_test("aVp_Ip_BFu17ll");
    static STRUCT_IF_C aVp_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(19,11), "sizeof(aVp_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "aVp_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "aVp_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu17ll, aVp_Ip_BFu17ll)
//============================================================================



static void Test_aVp_Ip_BFu1c()
{
  {
    init_simple_test("aVp_Ip_BFu1c");
    static STRUCT_IF_C aVp_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "aVp_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu1c, aVp_Ip_BFu1c)
//============================================================================



static void Test_aVp_Ip_BFu1i()
{
  {
    init_simple_test("aVp_Ip_BFu1i");
    static STRUCT_IF_C aVp_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "aVp_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu1i, aVp_Ip_BFu1i)
//============================================================================



static void Test_aVp_Ip_BFu1ll()
{
  {
    init_simple_test("aVp_Ip_BFu1ll");
    static STRUCT_IF_C aVp_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "aVp_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu1ll, aVp_Ip_BFu1ll)
//============================================================================



static void Test_aVp_Ip_BFu1s()
{
  {
    init_simple_test("aVp_Ip_BFu1s");
    static STRUCT_IF_C aVp_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "aVp_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu1s, aVp_Ip_BFu1s)
//============================================================================



static void Test_aVp_Ip_BFu31i()
{
  {
    init_simple_test("aVp_Ip_BFu31i");
    static STRUCT_IF_C aVp_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "aVp_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "aVp_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu31i, aVp_Ip_BFu31i)
//============================================================================



static void Test_aVp_Ip_BFu31ll()
{
  {
    init_simple_test("aVp_Ip_BFu31ll");
    static STRUCT_IF_C aVp_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, 1, "aVp_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 31, hide_ull(1LL<<30), "aVp_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu31ll, aVp_Ip_BFu31ll)
//============================================================================



static void Test_aVp_Ip_BFu32i()
{
  {
    init_simple_test("aVp_Ip_BFu32i");
    static STRUCT_IF_C aVp_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "aVp_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "aVp_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu32i, aVp_Ip_BFu32i)
//============================================================================



static void Test_aVp_Ip_BFu32ll()
{
  {
    init_simple_test("aVp_Ip_BFu32ll");
    static STRUCT_IF_C aVp_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, 1, "aVp_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 32, hide_ull(1LL<<31), "aVp_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu32ll, aVp_Ip_BFu32ll)
//============================================================================



static void Test_aVp_Ip_BFu33()
{
  {
    init_simple_test("aVp_Ip_BFu33");
    static STRUCT_IF_C aVp_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(21,13), "sizeof(aVp_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, 1, "aVp_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 33, hide_ull(1LL<<32), "aVp_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu33, aVp_Ip_BFu33)
//============================================================================



static void Test_aVp_Ip_BFu7c()
{
  {
    init_simple_test("aVp_Ip_BFu7c");
    static STRUCT_IF_C aVp_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "aVp_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "aVp_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu7c, aVp_Ip_BFu7c)
//============================================================================



static void Test_aVp_Ip_BFu7i()
{
  {
    init_simple_test("aVp_Ip_BFu7i");
    static STRUCT_IF_C aVp_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "aVp_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "aVp_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu7i, aVp_Ip_BFu7i)
//============================================================================



static void Test_aVp_Ip_BFu7ll()
{
  {
    init_simple_test("aVp_Ip_BFu7ll");
    static STRUCT_IF_C aVp_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "aVp_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "aVp_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu7ll, aVp_Ip_BFu7ll)
//============================================================================



static void Test_aVp_Ip_BFu7s()
{
  {
    init_simple_test("aVp_Ip_BFu7s");
    static STRUCT_IF_C aVp_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, 1, "aVp_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 7, hide_ull(1LL<<6), "aVp_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu7s, aVp_Ip_BFu7s)
//============================================================================



static void Test_aVp_Ip_BFu8c()
{
  {
    init_simple_test("aVp_Ip_BFu8c");
    static STRUCT_IF_C aVp_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "aVp_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "aVp_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu8c, aVp_Ip_BFu8c)
//============================================================================



static void Test_aVp_Ip_BFu8i()
{
  {
    init_simple_test("aVp_Ip_BFu8i");
    static STRUCT_IF_C aVp_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "aVp_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "aVp_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu8i, aVp_Ip_BFu8i)
//============================================================================



static void Test_aVp_Ip_BFu8ll()
{
  {
    init_simple_test("aVp_Ip_BFu8ll");
    static STRUCT_IF_C aVp_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "aVp_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "aVp_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu8ll, aVp_Ip_BFu8ll)
//============================================================================



static void Test_aVp_Ip_BFu8s()
{
  {
    init_simple_test("aVp_Ip_BFu8s");
    static STRUCT_IF_C aVp_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, 1, "aVp_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 8, hide_ull(1LL<<7), "aVp_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu8s, aVp_Ip_BFu8s)
//============================================================================



static void Test_aVp_Ip_BFu9i()
{
  {
    init_simple_test("aVp_Ip_BFu9i");
    static STRUCT_IF_C aVp_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "aVp_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "aVp_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu9i, aVp_Ip_BFu9i)
//============================================================================



static void Test_aVp_Ip_BFu9ll()
{
  {
    init_simple_test("aVp_Ip_BFu9ll");
    static STRUCT_IF_C aVp_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "aVp_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "aVp_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu9ll, aVp_Ip_BFu9ll)
//============================================================================



static void Test_aVp_Ip_BFu9s()
{
  {
    init_simple_test("aVp_Ip_BFu9s");
    static STRUCT_IF_C aVp_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_Ip_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, 1, "aVp_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 9, hide_ull(1LL<<8), "aVp_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_BFu9s, aVp_Ip_BFu9s)
//============================================================================



static void Test_aVp_Ip_C()
{
  {
    init_simple_test("aVp_Ip_C");
    STRUCT_IF_C aVp_Ip_C lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_C)");
    check_field_offset(lv, v1, 0, "aVp_Ip_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "aVp_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_C, aVp_Ip_C)
//============================================================================



static void Test_aVp_Ip_D()
{
  {
    init_simple_test("aVp_Ip_D");
    STRUCT_IF_C aVp_Ip_D lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aVp_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_D)");
    check_field_offset(lv, v1, 0, "aVp_Ip_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "aVp_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_D, aVp_Ip_D)
//============================================================================



static void Test_aVp_Ip_F()
{
  {
    init_simple_test("aVp_Ip_F");
    STRUCT_IF_C aVp_Ip_F lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_F)");
    check_field_offset(lv, v1, 0, "aVp_Ip_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "aVp_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_F, aVp_Ip_F)
//============================================================================



static void Test_aVp_Ip_I()
{
  {
    init_simple_test("aVp_Ip_I");
    STRUCT_IF_C aVp_Ip_I lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_I)");
    check_field_offset(lv, v1, 0, "aVp_Ip_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "aVp_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_I, aVp_Ip_I)
//============================================================================



static void Test_aVp_Ip_Ip()
{
  {
    init_simple_test("aVp_Ip_Ip");
    STRUCT_IF_C aVp_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(aVp_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_Ip)");
    check_field_offset(lv, v1, 0, "aVp_Ip_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "aVp_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_Ip, aVp_Ip_Ip)
//============================================================================



static void Test_aVp_Ip_L()
{
  {
    init_simple_test("aVp_Ip_L");
    STRUCT_IF_C aVp_Ip_L lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aVp_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_L)");
    check_field_offset(lv, v1, 0, "aVp_Ip_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "aVp_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_L, aVp_Ip_L)
//============================================================================



static void Test_aVp_Ip_S()
{
  {
    init_simple_test("aVp_Ip_S");
    STRUCT_IF_C aVp_Ip_S lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_S)");
    check_field_offset(lv, v1, 0, "aVp_Ip_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "aVp_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_S, aVp_Ip_S)
//============================================================================



static void Test_aVp_Ip_Uc()
{
  {
    init_simple_test("aVp_Ip_Uc");
    STRUCT_IF_C aVp_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_Uc)");
    check_field_offset(lv, v1, 0, "aVp_Ip_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "aVp_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_Uc, aVp_Ip_Uc)
//============================================================================



static void Test_aVp_Ip_Ui()
{
  {
    init_simple_test("aVp_Ip_Ui");
    STRUCT_IF_C aVp_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_Ui)");
    check_field_offset(lv, v1, 0, "aVp_Ip_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "aVp_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_Ui, aVp_Ip_Ui)
//============================================================================



static void Test_aVp_Ip_Ul()
{
  {
    init_simple_test("aVp_Ip_Ul");
    STRUCT_IF_C aVp_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aVp_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_Ul)");
    check_field_offset(lv, v1, 0, "aVp_Ip_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "aVp_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_Ul, aVp_Ip_Ul)
//============================================================================



static void Test_aVp_Ip_Us()
{
  {
    init_simple_test("aVp_Ip_Us");
    STRUCT_IF_C aVp_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_Us)");
    check_field_offset(lv, v1, 0, "aVp_Ip_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "aVp_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_Us, aVp_Ip_Us)
//============================================================================



static void Test_aVp_Ip_Vp()
{
  {
    init_simple_test("aVp_Ip_Vp");
    STRUCT_IF_C aVp_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(aVp_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ip_Vp)");
    check_field_offset(lv, v1, 0, "aVp_Ip_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,8), "aVp_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ip_Vp, aVp_Ip_Vp)
//============================================================================



static void Test_aVp_L()
{
  {
    init_simple_test("aVp_L");
    STRUCT_IF_C aVp_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L)");
    check_field_offset(lv, v1, 0, "aVp_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L, aVp_L)
//============================================================================



static void Test_aVp_L_BFu15i()
{
  {
    init_simple_test("aVp_L_BFu15i");
    static STRUCT_IF_C aVp_L_BFu15i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aVp_L_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aVp_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu15i, aVp_L_BFu15i)
//============================================================================



static void Test_aVp_L_BFu15ll()
{
  {
    init_simple_test("aVp_L_BFu15ll");
    static STRUCT_IF_C aVp_L_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aVp_L_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aVp_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu15ll, aVp_L_BFu15ll)
//============================================================================



static void Test_aVp_L_BFu15s()
{
  {
    init_simple_test("aVp_L_BFu15s");
    static STRUCT_IF_C aVp_L_BFu15s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aVp_L_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aVp_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu15s, aVp_L_BFu15s)
//============================================================================



static void Test_aVp_L_BFu16i()
{
  {
    init_simple_test("aVp_L_BFu16i");
    static STRUCT_IF_C aVp_L_BFu16i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aVp_L_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aVp_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu16i, aVp_L_BFu16i)
//============================================================================



static void Test_aVp_L_BFu16ll()
{
  {
    init_simple_test("aVp_L_BFu16ll");
    static STRUCT_IF_C aVp_L_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aVp_L_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aVp_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu16ll, aVp_L_BFu16ll)
//============================================================================



static void Test_aVp_L_BFu16s()
{
  {
    init_simple_test("aVp_L_BFu16s");
    static STRUCT_IF_C aVp_L_BFu16s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aVp_L_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aVp_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu16s, aVp_L_BFu16s)
//============================================================================



static void Test_aVp_L_BFu17i()
{
  {
    init_simple_test("aVp_L_BFu17i");
    static STRUCT_IF_C aVp_L_BFu17i lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aVp_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "aVp_L_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "aVp_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu17i, aVp_L_BFu17i)
//============================================================================



static void Test_aVp_L_BFu17ll()
{
  {
    init_simple_test("aVp_L_BFu17ll");
    static STRUCT_IF_C aVp_L_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aVp_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "aVp_L_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "aVp_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu17ll, aVp_L_BFu17ll)
//============================================================================



static void Test_aVp_L_BFu1c()
{
  {
    init_simple_test("aVp_L_BFu1c");
    static STRUCT_IF_C aVp_L_BFu1c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aVp_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu1c, aVp_L_BFu1c)
//============================================================================



static void Test_aVp_L_BFu1i()
{
  {
    init_simple_test("aVp_L_BFu1i");
    static STRUCT_IF_C aVp_L_BFu1i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aVp_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu1i, aVp_L_BFu1i)
//============================================================================



static void Test_aVp_L_BFu1ll()
{
  {
    init_simple_test("aVp_L_BFu1ll");
    static STRUCT_IF_C aVp_L_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aVp_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu1ll, aVp_L_BFu1ll)
//============================================================================



static void Test_aVp_L_BFu1s()
{
  {
    init_simple_test("aVp_L_BFu1s");
    static STRUCT_IF_C aVp_L_BFu1s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aVp_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu1s, aVp_L_BFu1s)
//============================================================================



static void Test_aVp_L_BFu31i()
{
  {
    init_simple_test("aVp_L_BFu31i");
    static STRUCT_IF_C aVp_L_BFu31i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "aVp_L_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "aVp_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu31i, aVp_L_BFu31i)
//============================================================================



static void Test_aVp_L_BFu31ll()
{
  {
    init_simple_test("aVp_L_BFu31ll");
    static STRUCT_IF_C aVp_L_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "aVp_L_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "aVp_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu31ll, aVp_L_BFu31ll)
//============================================================================



static void Test_aVp_L_BFu32i()
{
  {
    init_simple_test("aVp_L_BFu32i");
    static STRUCT_IF_C aVp_L_BFu32i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "aVp_L_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "aVp_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu32i, aVp_L_BFu32i)
//============================================================================



static void Test_aVp_L_BFu32ll()
{
  {
    init_simple_test("aVp_L_BFu32ll");
    static STRUCT_IF_C aVp_L_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "aVp_L_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "aVp_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu32ll, aVp_L_BFu32ll)
//============================================================================



static void Test_aVp_L_BFu33()
{
  {
    init_simple_test("aVp_L_BFu33");
    static STRUCT_IF_C aVp_L_BFu33 lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(aVp_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "aVp_L_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "aVp_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu33, aVp_L_BFu33)
//============================================================================



static void Test_aVp_L_BFu7c()
{
  {
    init_simple_test("aVp_L_BFu7c");
    static STRUCT_IF_C aVp_L_BFu7c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aVp_L_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aVp_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu7c, aVp_L_BFu7c)
//============================================================================



static void Test_aVp_L_BFu7i()
{
  {
    init_simple_test("aVp_L_BFu7i");
    static STRUCT_IF_C aVp_L_BFu7i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aVp_L_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aVp_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu7i, aVp_L_BFu7i)
//============================================================================



static void Test_aVp_L_BFu7ll()
{
  {
    init_simple_test("aVp_L_BFu7ll");
    static STRUCT_IF_C aVp_L_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aVp_L_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aVp_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu7ll, aVp_L_BFu7ll)
//============================================================================



static void Test_aVp_L_BFu7s()
{
  {
    init_simple_test("aVp_L_BFu7s");
    static STRUCT_IF_C aVp_L_BFu7s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aVp_L_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aVp_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu7s, aVp_L_BFu7s)
//============================================================================



static void Test_aVp_L_BFu8c()
{
  {
    init_simple_test("aVp_L_BFu8c");
    static STRUCT_IF_C aVp_L_BFu8c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aVp_L_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aVp_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu8c, aVp_L_BFu8c)
//============================================================================



static void Test_aVp_L_BFu8i()
{
  {
    init_simple_test("aVp_L_BFu8i");
    static STRUCT_IF_C aVp_L_BFu8i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aVp_L_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aVp_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu8i, aVp_L_BFu8i)
//============================================================================



static void Test_aVp_L_BFu8ll()
{
  {
    init_simple_test("aVp_L_BFu8ll");
    static STRUCT_IF_C aVp_L_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aVp_L_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aVp_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu8ll, aVp_L_BFu8ll)
//============================================================================



static void Test_aVp_L_BFu8s()
{
  {
    init_simple_test("aVp_L_BFu8s");
    static STRUCT_IF_C aVp_L_BFu8s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aVp_L_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aVp_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu8s, aVp_L_BFu8s)
//============================================================================



static void Test_aVp_L_BFu9i()
{
  {
    init_simple_test("aVp_L_BFu9i");
    static STRUCT_IF_C aVp_L_BFu9i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aVp_L_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aVp_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu9i, aVp_L_BFu9i)
//============================================================================



static void Test_aVp_L_BFu9ll()
{
  {
    init_simple_test("aVp_L_BFu9ll");
    static STRUCT_IF_C aVp_L_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aVp_L_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aVp_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu9ll, aVp_L_BFu9ll)
//============================================================================



static void Test_aVp_L_BFu9s()
{
  {
    init_simple_test("aVp_L_BFu9s");
    static STRUCT_IF_C aVp_L_BFu9s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_L_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aVp_L_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aVp_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_BFu9s, aVp_L_BFu9s)
//============================================================================



static void Test_aVp_L_C()
{
  {
    init_simple_test("aVp_L_C");
    STRUCT_IF_C aVp_L_C lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_C)");
    check_field_offset(lv, v1, 0, "aVp_L_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_C, aVp_L_C)
//============================================================================



static void Test_aVp_L_D()
{
  {
    init_simple_test("aVp_L_D");
    STRUCT_IF_C aVp_L_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aVp_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_D)");
    check_field_offset(lv, v1, 0, "aVp_L_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_D, aVp_L_D)
//============================================================================



static void Test_aVp_L_F()
{
  {
    init_simple_test("aVp_L_F");
    STRUCT_IF_C aVp_L_F lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_F)");
    check_field_offset(lv, v1, 0, "aVp_L_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_F, aVp_L_F)
//============================================================================



static void Test_aVp_L_I()
{
  {
    init_simple_test("aVp_L_I");
    STRUCT_IF_C aVp_L_I lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_I)");
    check_field_offset(lv, v1, 0, "aVp_L_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_I, aVp_L_I)
//============================================================================



static void Test_aVp_L_Ip()
{
  {
    init_simple_test("aVp_L_Ip");
    STRUCT_IF_C aVp_L_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aVp_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_Ip)");
    check_field_offset(lv, v1, 0, "aVp_L_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_Ip, aVp_L_Ip)
//============================================================================



static void Test_aVp_L_L()
{
  {
    init_simple_test("aVp_L_L");
    STRUCT_IF_C aVp_L_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aVp_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_L)");
    check_field_offset(lv, v1, 0, "aVp_L_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_L, aVp_L_L)
//============================================================================



static void Test_aVp_L_S()
{
  {
    init_simple_test("aVp_L_S");
    STRUCT_IF_C aVp_L_S lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_S)");
    check_field_offset(lv, v1, 0, "aVp_L_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_S, aVp_L_S)
//============================================================================



static void Test_aVp_L_Uc()
{
  {
    init_simple_test("aVp_L_Uc");
    STRUCT_IF_C aVp_L_Uc lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_Uc)");
    check_field_offset(lv, v1, 0, "aVp_L_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_Uc, aVp_L_Uc)
//============================================================================



static void Test_aVp_L_Ui()
{
  {
    init_simple_test("aVp_L_Ui");
    STRUCT_IF_C aVp_L_Ui lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_Ui)");
    check_field_offset(lv, v1, 0, "aVp_L_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_Ui, aVp_L_Ui)
//============================================================================



static void Test_aVp_L_Ul()
{
  {
    init_simple_test("aVp_L_Ul");
    STRUCT_IF_C aVp_L_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aVp_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_Ul)");
    check_field_offset(lv, v1, 0, "aVp_L_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_Ul, aVp_L_Ul)
//============================================================================



static void Test_aVp_L_Us()
{
  {
    init_simple_test("aVp_L_Us");
    STRUCT_IF_C aVp_L_Us lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_Us)");
    check_field_offset(lv, v1, 0, "aVp_L_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_Us, aVp_L_Us)
//============================================================================



static void Test_aVp_L_Vp()
{
  {
    init_simple_test("aVp_L_Vp");
    STRUCT_IF_C aVp_L_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aVp_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_L_Vp)");
    check_field_offset(lv, v1, 0, "aVp_L_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_L_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_L_Vp, aVp_L_Vp)
//============================================================================



static void Test_aVp_S()
{
  {
    init_simple_test("aVp_S");
    STRUCT_IF_C aVp_S lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S)");
    check_field_offset(lv, v1, 0, "aVp_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S, aVp_S)
//============================================================================



static void Test_aVp_S_BFu15i()
{
  {
    init_simple_test("aVp_S_BFu15i");
    static STRUCT_IF_C aVp_S_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aVp_S_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aVp_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu15i, aVp_S_BFu15i)
//============================================================================



static void Test_aVp_S_BFu15ll()
{
  {
    init_simple_test("aVp_S_BFu15ll");
    static STRUCT_IF_C aVp_S_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aVp_S_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aVp_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu15ll, aVp_S_BFu15ll)
//============================================================================



static void Test_aVp_S_BFu15s()
{
  {
    init_simple_test("aVp_S_BFu15s");
    static STRUCT_IF_C aVp_S_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aVp_S_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aVp_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu15s, aVp_S_BFu15s)
//============================================================================



static void Test_aVp_S_BFu16i()
{
  {
    init_simple_test("aVp_S_BFu16i");
    static STRUCT_IF_C aVp_S_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aVp_S_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aVp_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu16i, aVp_S_BFu16i)
//============================================================================



static void Test_aVp_S_BFu16ll()
{
  {
    init_simple_test("aVp_S_BFu16ll");
    static STRUCT_IF_C aVp_S_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aVp_S_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aVp_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu16ll, aVp_S_BFu16ll)
//============================================================================



static void Test_aVp_S_BFu16s()
{
  {
    init_simple_test("aVp_S_BFu16s");
    static STRUCT_IF_C aVp_S_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aVp_S_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aVp_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu16s, aVp_S_BFu16s)
//============================================================================



static void Test_aVp_S_BFu17i()
{
  {
    init_simple_test("aVp_S_BFu17i");
    static STRUCT_IF_C aVp_S_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "aVp_S_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "aVp_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu17i, aVp_S_BFu17i)
//============================================================================



static void Test_aVp_S_BFu17ll()
{
  {
    init_simple_test("aVp_S_BFu17ll");
    static STRUCT_IF_C aVp_S_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "aVp_S_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "aVp_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu17ll, aVp_S_BFu17ll)
//============================================================================



static void Test_aVp_S_BFu1c()
{
  {
    init_simple_test("aVp_S_BFu1c");
    static STRUCT_IF_C aVp_S_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aVp_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu1c, aVp_S_BFu1c)
//============================================================================



static void Test_aVp_S_BFu1i()
{
  {
    init_simple_test("aVp_S_BFu1i");
    static STRUCT_IF_C aVp_S_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aVp_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu1i, aVp_S_BFu1i)
//============================================================================



static void Test_aVp_S_BFu1ll()
{
  {
    init_simple_test("aVp_S_BFu1ll");
    static STRUCT_IF_C aVp_S_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aVp_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu1ll, aVp_S_BFu1ll)
//============================================================================



static void Test_aVp_S_BFu1s()
{
  {
    init_simple_test("aVp_S_BFu1s");
    static STRUCT_IF_C aVp_S_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aVp_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu1s, aVp_S_BFu1s)
//============================================================================



static void Test_aVp_S_BFu31i()
{
  {
    init_simple_test("aVp_S_BFu31i");
    static STRUCT_IF_C aVp_S_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "aVp_S_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "aVp_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu31i, aVp_S_BFu31i)
//============================================================================



static void Test_aVp_S_BFu31ll()
{
  {
    init_simple_test("aVp_S_BFu31ll");
    static STRUCT_IF_C aVp_S_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "aVp_S_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "aVp_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu31ll, aVp_S_BFu31ll)
//============================================================================



static void Test_aVp_S_BFu32i()
{
  {
    init_simple_test("aVp_S_BFu32i");
    static STRUCT_IF_C aVp_S_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "aVp_S_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "aVp_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu32i, aVp_S_BFu32i)
//============================================================================



static void Test_aVp_S_BFu32ll()
{
  {
    init_simple_test("aVp_S_BFu32ll");
    static STRUCT_IF_C aVp_S_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "aVp_S_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "aVp_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu32ll, aVp_S_BFu32ll)
//============================================================================



static void Test_aVp_S_BFu33()
{
  {
    init_simple_test("aVp_S_BFu33");
    static STRUCT_IF_C aVp_S_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "aVp_S_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "aVp_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu33, aVp_S_BFu33)
//============================================================================



static void Test_aVp_S_BFu7c()
{
  {
    init_simple_test("aVp_S_BFu7c");
    static STRUCT_IF_C aVp_S_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aVp_S_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aVp_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu7c, aVp_S_BFu7c)
//============================================================================



static void Test_aVp_S_BFu7i()
{
  {
    init_simple_test("aVp_S_BFu7i");
    static STRUCT_IF_C aVp_S_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aVp_S_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aVp_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu7i, aVp_S_BFu7i)
//============================================================================



static void Test_aVp_S_BFu7ll()
{
  {
    init_simple_test("aVp_S_BFu7ll");
    static STRUCT_IF_C aVp_S_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aVp_S_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aVp_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu7ll, aVp_S_BFu7ll)
//============================================================================



static void Test_aVp_S_BFu7s()
{
  {
    init_simple_test("aVp_S_BFu7s");
    static STRUCT_IF_C aVp_S_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aVp_S_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aVp_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu7s, aVp_S_BFu7s)
//============================================================================



static void Test_aVp_S_BFu8c()
{
  {
    init_simple_test("aVp_S_BFu8c");
    static STRUCT_IF_C aVp_S_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aVp_S_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aVp_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu8c, aVp_S_BFu8c)
//============================================================================



static void Test_aVp_S_BFu8i()
{
  {
    init_simple_test("aVp_S_BFu8i");
    static STRUCT_IF_C aVp_S_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aVp_S_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aVp_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu8i, aVp_S_BFu8i)
//============================================================================



static void Test_aVp_S_BFu8ll()
{
  {
    init_simple_test("aVp_S_BFu8ll");
    static STRUCT_IF_C aVp_S_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aVp_S_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aVp_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu8ll, aVp_S_BFu8ll)
//============================================================================



static void Test_aVp_S_BFu8s()
{
  {
    init_simple_test("aVp_S_BFu8s");
    static STRUCT_IF_C aVp_S_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aVp_S_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aVp_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu8s, aVp_S_BFu8s)
//============================================================================



static void Test_aVp_S_BFu9i()
{
  {
    init_simple_test("aVp_S_BFu9i");
    static STRUCT_IF_C aVp_S_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aVp_S_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aVp_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu9i, aVp_S_BFu9i)
//============================================================================



static void Test_aVp_S_BFu9ll()
{
  {
    init_simple_test("aVp_S_BFu9ll");
    static STRUCT_IF_C aVp_S_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aVp_S_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aVp_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu9ll, aVp_S_BFu9ll)
//============================================================================



static void Test_aVp_S_BFu9s()
{
  {
    init_simple_test("aVp_S_BFu9s");
    static STRUCT_IF_C aVp_S_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_S_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aVp_S_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aVp_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_BFu9s, aVp_S_BFu9s)
//============================================================================



static void Test_aVp_S_C()
{
  {
    init_simple_test("aVp_S_C");
    STRUCT_IF_C aVp_S_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_C)");
    check_field_offset(lv, v1, 0, "aVp_S_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_C.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_C, aVp_S_C)
//============================================================================



static void Test_aVp_S_D()
{
  {
    init_simple_test("aVp_S_D");
    STRUCT_IF_C aVp_S_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_D)");
    check_field_offset(lv, v1, 0, "aVp_S_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_D.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_D, aVp_S_D)
//============================================================================



static void Test_aVp_S_F()
{
  {
    init_simple_test("aVp_S_F");
    STRUCT_IF_C aVp_S_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_F)");
    check_field_offset(lv, v1, 0, "aVp_S_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_F.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_F, aVp_S_F)
//============================================================================



static void Test_aVp_S_I()
{
  {
    init_simple_test("aVp_S_I");
    STRUCT_IF_C aVp_S_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_I)");
    check_field_offset(lv, v1, 0, "aVp_S_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_I.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_I, aVp_S_I)
//============================================================================



static void Test_aVp_S_Ip()
{
  {
    init_simple_test("aVp_S_Ip");
    STRUCT_IF_C aVp_S_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_Ip)");
    check_field_offset(lv, v1, 0, "aVp_S_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_Ip, aVp_S_Ip)
//============================================================================



static void Test_aVp_S_L()
{
  {
    init_simple_test("aVp_S_L");
    STRUCT_IF_C aVp_S_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_L)");
    check_field_offset(lv, v1, 0, "aVp_S_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_L.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_L, aVp_S_L)
//============================================================================



static void Test_aVp_S_S()
{
  {
    init_simple_test("aVp_S_S");
    STRUCT_IF_C aVp_S_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_S)");
    check_field_offset(lv, v1, 0, "aVp_S_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_S.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_S, aVp_S_S)
//============================================================================



static void Test_aVp_S_Uc()
{
  {
    init_simple_test("aVp_S_Uc");
    STRUCT_IF_C aVp_S_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_Uc)");
    check_field_offset(lv, v1, 0, "aVp_S_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_Uc, aVp_S_Uc)
//============================================================================



static void Test_aVp_S_Ui()
{
  {
    init_simple_test("aVp_S_Ui");
    STRUCT_IF_C aVp_S_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_Ui)");
    check_field_offset(lv, v1, 0, "aVp_S_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_Ui, aVp_S_Ui)
//============================================================================



static void Test_aVp_S_Ul()
{
  {
    init_simple_test("aVp_S_Ul");
    STRUCT_IF_C aVp_S_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_Ul)");
    check_field_offset(lv, v1, 0, "aVp_S_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_Ul, aVp_S_Ul)
//============================================================================



static void Test_aVp_S_Us()
{
  {
    init_simple_test("aVp_S_Us");
    STRUCT_IF_C aVp_S_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_Us)");
    check_field_offset(lv, v1, 0, "aVp_S_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_Us.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_Us, aVp_S_Us)
//============================================================================



static void Test_aVp_S_Vp()
{
  {
    init_simple_test("aVp_S_Vp");
    STRUCT_IF_C aVp_S_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_S_Vp)");
    check_field_offset(lv, v1, 0, "aVp_S_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_S_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_S_Vp, aVp_S_Vp)
//============================================================================



static void Test_aVp_Uc()
{
  {
    init_simple_test("aVp_Uc");
    STRUCT_IF_C aVp_Uc lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aVp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc)");
    check_field_offset(lv, v1, 0, "aVp_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc, aVp_Uc)
//============================================================================



static void Test_aVp_Uc_BFu15i()
{
  {
    init_simple_test("aVp_Uc_BFu15i");
    static STRUCT_IF_C aVp_Uc_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_Uc_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu15i, aVp_Uc_BFu15i)
//============================================================================



static void Test_aVp_Uc_BFu15ll()
{
  {
    init_simple_test("aVp_Uc_BFu15ll");
    static STRUCT_IF_C aVp_Uc_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_Uc_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu15ll, aVp_Uc_BFu15ll)
//============================================================================



static void Test_aVp_Uc_BFu15s()
{
  {
    init_simple_test("aVp_Uc_BFu15s");
    static STRUCT_IF_C aVp_Uc_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aVp_Uc_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aVp_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu15s, aVp_Uc_BFu15s)
//============================================================================



static void Test_aVp_Uc_BFu16i()
{
  {
    init_simple_test("aVp_Uc_BFu16i");
    static STRUCT_IF_C aVp_Uc_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_Uc_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu16i, aVp_Uc_BFu16i)
//============================================================================



static void Test_aVp_Uc_BFu16ll()
{
  {
    init_simple_test("aVp_Uc_BFu16ll");
    static STRUCT_IF_C aVp_Uc_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_Uc_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu16ll, aVp_Uc_BFu16ll)
//============================================================================



static void Test_aVp_Uc_BFu16s()
{
  {
    init_simple_test("aVp_Uc_BFu16s");
    static STRUCT_IF_C aVp_Uc_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aVp_Uc_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aVp_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu16s, aVp_Uc_BFu16s)
//============================================================================



static void Test_aVp_Uc_BFu17i()
{
  {
    init_simple_test("aVp_Uc_BFu17i");
    static STRUCT_IF_C aVp_Uc_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aVp_Uc_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aVp_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu17i, aVp_Uc_BFu17i)
//============================================================================



static void Test_aVp_Uc_BFu17ll()
{
  {
    init_simple_test("aVp_Uc_BFu17ll");
    static STRUCT_IF_C aVp_Uc_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aVp_Uc_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aVp_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu17ll, aVp_Uc_BFu17ll)
//============================================================================



static void Test_aVp_Uc_BFu1c()
{
  {
    init_simple_test("aVp_Uc_BFu1c");
    static STRUCT_IF_C aVp_Uc_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu1c, aVp_Uc_BFu1c)
//============================================================================



static void Test_aVp_Uc_BFu1i()
{
  {
    init_simple_test("aVp_Uc_BFu1i");
    static STRUCT_IF_C aVp_Uc_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu1i, aVp_Uc_BFu1i)
//============================================================================



static void Test_aVp_Uc_BFu1ll()
{
  {
    init_simple_test("aVp_Uc_BFu1ll");
    static STRUCT_IF_C aVp_Uc_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu1ll, aVp_Uc_BFu1ll)
//============================================================================



static void Test_aVp_Uc_BFu1s()
{
  {
    init_simple_test("aVp_Uc_BFu1s");
    static STRUCT_IF_C aVp_Uc_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aVp_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu1s, aVp_Uc_BFu1s)
//============================================================================



static void Test_aVp_Uc_BFu31i()
{
  {
    init_simple_test("aVp_Uc_BFu31i");
    static STRUCT_IF_C aVp_Uc_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aVp_Uc_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aVp_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu31i, aVp_Uc_BFu31i)
//============================================================================



static void Test_aVp_Uc_BFu31ll()
{
  {
    init_simple_test("aVp_Uc_BFu31ll");
    static STRUCT_IF_C aVp_Uc_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aVp_Uc_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aVp_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu31ll, aVp_Uc_BFu31ll)
//============================================================================



static void Test_aVp_Uc_BFu32i()
{
  {
    init_simple_test("aVp_Uc_BFu32i");
    static STRUCT_IF_C aVp_Uc_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aVp_Uc_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aVp_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu32i, aVp_Uc_BFu32i)
//============================================================================



static void Test_aVp_Uc_BFu32ll()
{
  {
    init_simple_test("aVp_Uc_BFu32ll");
    static STRUCT_IF_C aVp_Uc_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aVp_Uc_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aVp_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu32ll, aVp_Uc_BFu32ll)
//============================================================================



static void Test_aVp_Uc_BFu33()
{
  {
    init_simple_test("aVp_Uc_BFu33");
    static STRUCT_IF_C aVp_Uc_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aVp_Uc_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aVp_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu33, aVp_Uc_BFu33)
//============================================================================



static void Test_aVp_Uc_BFu7c()
{
  {
    init_simple_test("aVp_Uc_BFu7c");
    static STRUCT_IF_C aVp_Uc_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_Uc_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu7c, aVp_Uc_BFu7c)
//============================================================================



static void Test_aVp_Uc_BFu7i()
{
  {
    init_simple_test("aVp_Uc_BFu7i");
    static STRUCT_IF_C aVp_Uc_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_Uc_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu7i, aVp_Uc_BFu7i)
//============================================================================



static void Test_aVp_Uc_BFu7ll()
{
  {
    init_simple_test("aVp_Uc_BFu7ll");
    static STRUCT_IF_C aVp_Uc_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_Uc_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu7ll, aVp_Uc_BFu7ll)
//============================================================================



static void Test_aVp_Uc_BFu7s()
{
  {
    init_simple_test("aVp_Uc_BFu7s");
    static STRUCT_IF_C aVp_Uc_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aVp_Uc_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aVp_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu7s, aVp_Uc_BFu7s)
//============================================================================



static void Test_aVp_Uc_BFu8c()
{
  {
    init_simple_test("aVp_Uc_BFu8c");
    static STRUCT_IF_C aVp_Uc_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_Uc_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu8c, aVp_Uc_BFu8c)
//============================================================================



static void Test_aVp_Uc_BFu8i()
{
  {
    init_simple_test("aVp_Uc_BFu8i");
    static STRUCT_IF_C aVp_Uc_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_Uc_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu8i, aVp_Uc_BFu8i)
//============================================================================



static void Test_aVp_Uc_BFu8ll()
{
  {
    init_simple_test("aVp_Uc_BFu8ll");
    static STRUCT_IF_C aVp_Uc_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_Uc_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu8ll, aVp_Uc_BFu8ll)
//============================================================================



static void Test_aVp_Uc_BFu8s()
{
  {
    init_simple_test("aVp_Uc_BFu8s");
    static STRUCT_IF_C aVp_Uc_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aVp_Uc_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aVp_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu8s, aVp_Uc_BFu8s)
//============================================================================



static void Test_aVp_Uc_BFu9i()
{
  {
    init_simple_test("aVp_Uc_BFu9i");
    static STRUCT_IF_C aVp_Uc_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_Uc_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu9i, aVp_Uc_BFu9i)
//============================================================================



static void Test_aVp_Uc_BFu9ll()
{
  {
    init_simple_test("aVp_Uc_BFu9ll");
    static STRUCT_IF_C aVp_Uc_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_Uc_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu9ll, aVp_Uc_BFu9ll)
//============================================================================



static void Test_aVp_Uc_BFu9s()
{
  {
    init_simple_test("aVp_Uc_BFu9s");
    static STRUCT_IF_C aVp_Uc_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_Uc_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aVp_Uc_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aVp_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_BFu9s, aVp_Uc_BFu9s)
//============================================================================



static void Test_aVp_Uc_C()
{
  {
    init_simple_test("aVp_Uc_C");
    STRUCT_IF_C aVp_Uc_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_C)");
    check_field_offset(lv, v1, 0, "aVp_Uc_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_C.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_C, aVp_Uc_C)
//============================================================================



static void Test_aVp_Uc_D()
{
  {
    init_simple_test("aVp_Uc_D");
    STRUCT_IF_C aVp_Uc_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_D)");
    check_field_offset(lv, v1, 0, "aVp_Uc_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_D.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_D, aVp_Uc_D)
//============================================================================



static void Test_aVp_Uc_F()
{
  {
    init_simple_test("aVp_Uc_F");
    STRUCT_IF_C aVp_Uc_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_F)");
    check_field_offset(lv, v1, 0, "aVp_Uc_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_F.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_F, aVp_Uc_F)
//============================================================================



static void Test_aVp_Uc_I()
{
  {
    init_simple_test("aVp_Uc_I");
    STRUCT_IF_C aVp_Uc_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_I)");
    check_field_offset(lv, v1, 0, "aVp_Uc_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_I.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_I, aVp_Uc_I)
//============================================================================



static void Test_aVp_Uc_Ip()
{
  {
    init_simple_test("aVp_Uc_Ip");
    STRUCT_IF_C aVp_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_Ip)");
    check_field_offset(lv, v1, 0, "aVp_Uc_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_Ip, aVp_Uc_Ip)
//============================================================================



static void Test_aVp_Uc_L()
{
  {
    init_simple_test("aVp_Uc_L");
    STRUCT_IF_C aVp_Uc_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_L)");
    check_field_offset(lv, v1, 0, "aVp_Uc_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_L.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_L, aVp_Uc_L)
//============================================================================



static void Test_aVp_Uc_S()
{
  {
    init_simple_test("aVp_Uc_S");
    STRUCT_IF_C aVp_Uc_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_S)");
    check_field_offset(lv, v1, 0, "aVp_Uc_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_S.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_S, aVp_Uc_S)
//============================================================================



static void Test_aVp_Uc_Uc()
{
  {
    init_simple_test("aVp_Uc_Uc");
    STRUCT_IF_C aVp_Uc_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_Uc)");
    check_field_offset(lv, v1, 0, "aVp_Uc_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_Uc, aVp_Uc_Uc)
//============================================================================



static void Test_aVp_Uc_Ui()
{
  {
    init_simple_test("aVp_Uc_Ui");
    STRUCT_IF_C aVp_Uc_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_Ui)");
    check_field_offset(lv, v1, 0, "aVp_Uc_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_Ui, aVp_Uc_Ui)
//============================================================================



static void Test_aVp_Uc_Ul()
{
  {
    init_simple_test("aVp_Uc_Ul");
    STRUCT_IF_C aVp_Uc_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_Ul)");
    check_field_offset(lv, v1, 0, "aVp_Uc_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_Ul, aVp_Uc_Ul)
//============================================================================



static void Test_aVp_Uc_Us()
{
  {
    init_simple_test("aVp_Uc_Us");
    STRUCT_IF_C aVp_Uc_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_Us)");
    check_field_offset(lv, v1, 0, "aVp_Uc_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_Us.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_Us, aVp_Uc_Us)
//============================================================================



static void Test_aVp_Uc_Vp()
{
  {
    init_simple_test("aVp_Uc_Vp");
    STRUCT_IF_C aVp_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Uc_Vp)");
    check_field_offset(lv, v1, 0, "aVp_Uc_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Uc_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aVp_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Uc_Vp, aVp_Uc_Vp)
//============================================================================



static void Test_aVp_Ui()
{
  {
    init_simple_test("aVp_Ui");
    STRUCT_IF_C aVp_Ui lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui)");
    check_field_offset(lv, v1, 0, "aVp_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui, aVp_Ui)
//============================================================================



static void Test_aVp_Ui_BFu15i()
{
  {
    init_simple_test("aVp_Ui_BFu15i");
    static STRUCT_IF_C aVp_Ui_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aVp_Ui_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aVp_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu15i, aVp_Ui_BFu15i)
//============================================================================



static void Test_aVp_Ui_BFu15ll()
{
  {
    init_simple_test("aVp_Ui_BFu15ll");
    static STRUCT_IF_C aVp_Ui_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aVp_Ui_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aVp_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu15ll, aVp_Ui_BFu15ll)
//============================================================================



static void Test_aVp_Ui_BFu15s()
{
  {
    init_simple_test("aVp_Ui_BFu15s");
    static STRUCT_IF_C aVp_Ui_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aVp_Ui_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aVp_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu15s, aVp_Ui_BFu15s)
//============================================================================



static void Test_aVp_Ui_BFu16i()
{
  {
    init_simple_test("aVp_Ui_BFu16i");
    static STRUCT_IF_C aVp_Ui_BFu16i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aVp_Ui_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aVp_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu16i, aVp_Ui_BFu16i)
//============================================================================



static void Test_aVp_Ui_BFu16ll()
{
  {
    init_simple_test("aVp_Ui_BFu16ll");
    static STRUCT_IF_C aVp_Ui_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aVp_Ui_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aVp_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu16ll, aVp_Ui_BFu16ll)
//============================================================================



static void Test_aVp_Ui_BFu16s()
{
  {
    init_simple_test("aVp_Ui_BFu16s");
    static STRUCT_IF_C aVp_Ui_BFu16s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aVp_Ui_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aVp_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu16s, aVp_Ui_BFu16s)
//============================================================================



static void Test_aVp_Ui_BFu17i()
{
  {
    init_simple_test("aVp_Ui_BFu17i");
    static STRUCT_IF_C aVp_Ui_BFu17i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "aVp_Ui_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "aVp_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu17i, aVp_Ui_BFu17i)
//============================================================================



static void Test_aVp_Ui_BFu17ll()
{
  {
    init_simple_test("aVp_Ui_BFu17ll");
    static STRUCT_IF_C aVp_Ui_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "aVp_Ui_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "aVp_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu17ll, aVp_Ui_BFu17ll)
//============================================================================



static void Test_aVp_Ui_BFu1c()
{
  {
    init_simple_test("aVp_Ui_BFu1c");
    static STRUCT_IF_C aVp_Ui_BFu1c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aVp_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu1c, aVp_Ui_BFu1c)
//============================================================================



static void Test_aVp_Ui_BFu1i()
{
  {
    init_simple_test("aVp_Ui_BFu1i");
    static STRUCT_IF_C aVp_Ui_BFu1i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aVp_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu1i, aVp_Ui_BFu1i)
//============================================================================



static void Test_aVp_Ui_BFu1ll()
{
  {
    init_simple_test("aVp_Ui_BFu1ll");
    static STRUCT_IF_C aVp_Ui_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aVp_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu1ll, aVp_Ui_BFu1ll)
//============================================================================



static void Test_aVp_Ui_BFu1s()
{
  {
    init_simple_test("aVp_Ui_BFu1s");
    static STRUCT_IF_C aVp_Ui_BFu1s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aVp_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu1s, aVp_Ui_BFu1s)
//============================================================================



static void Test_aVp_Ui_BFu31i()
{
  {
    init_simple_test("aVp_Ui_BFu31i");
    static STRUCT_IF_C aVp_Ui_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "aVp_Ui_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "aVp_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu31i, aVp_Ui_BFu31i)
//============================================================================



static void Test_aVp_Ui_BFu31ll()
{
  {
    init_simple_test("aVp_Ui_BFu31ll");
    static STRUCT_IF_C aVp_Ui_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "aVp_Ui_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "aVp_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu31ll, aVp_Ui_BFu31ll)
//============================================================================



static void Test_aVp_Ui_BFu32i()
{
  {
    init_simple_test("aVp_Ui_BFu32i");
    static STRUCT_IF_C aVp_Ui_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "aVp_Ui_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "aVp_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu32i, aVp_Ui_BFu32i)
//============================================================================



static void Test_aVp_Ui_BFu32ll()
{
  {
    init_simple_test("aVp_Ui_BFu32ll");
    static STRUCT_IF_C aVp_Ui_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "aVp_Ui_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "aVp_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu32ll, aVp_Ui_BFu32ll)
//============================================================================



static void Test_aVp_Ui_BFu33()
{
  {
    init_simple_test("aVp_Ui_BFu33");
    static STRUCT_IF_C aVp_Ui_BFu33 lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, 1, "aVp_Ui_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, hide_ull(1LL<<32), "aVp_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu33, aVp_Ui_BFu33)
//============================================================================



static void Test_aVp_Ui_BFu7c()
{
  {
    init_simple_test("aVp_Ui_BFu7c");
    static STRUCT_IF_C aVp_Ui_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_Ui_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu7c, aVp_Ui_BFu7c)
//============================================================================



static void Test_aVp_Ui_BFu7i()
{
  {
    init_simple_test("aVp_Ui_BFu7i");
    static STRUCT_IF_C aVp_Ui_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_Ui_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu7i, aVp_Ui_BFu7i)
//============================================================================



static void Test_aVp_Ui_BFu7ll()
{
  {
    init_simple_test("aVp_Ui_BFu7ll");
    static STRUCT_IF_C aVp_Ui_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_Ui_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu7ll, aVp_Ui_BFu7ll)
//============================================================================



static void Test_aVp_Ui_BFu7s()
{
  {
    init_simple_test("aVp_Ui_BFu7s");
    static STRUCT_IF_C aVp_Ui_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aVp_Ui_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aVp_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu7s, aVp_Ui_BFu7s)
//============================================================================



static void Test_aVp_Ui_BFu8c()
{
  {
    init_simple_test("aVp_Ui_BFu8c");
    static STRUCT_IF_C aVp_Ui_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_Ui_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu8c, aVp_Ui_BFu8c)
//============================================================================



static void Test_aVp_Ui_BFu8i()
{
  {
    init_simple_test("aVp_Ui_BFu8i");
    static STRUCT_IF_C aVp_Ui_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_Ui_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu8i, aVp_Ui_BFu8i)
//============================================================================



static void Test_aVp_Ui_BFu8ll()
{
  {
    init_simple_test("aVp_Ui_BFu8ll");
    static STRUCT_IF_C aVp_Ui_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_Ui_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu8ll, aVp_Ui_BFu8ll)
//============================================================================



static void Test_aVp_Ui_BFu8s()
{
  {
    init_simple_test("aVp_Ui_BFu8s");
    static STRUCT_IF_C aVp_Ui_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aVp_Ui_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aVp_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu8s, aVp_Ui_BFu8s)
//============================================================================



static void Test_aVp_Ui_BFu9i()
{
  {
    init_simple_test("aVp_Ui_BFu9i");
    static STRUCT_IF_C aVp_Ui_BFu9i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aVp_Ui_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aVp_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu9i, aVp_Ui_BFu9i)
//============================================================================



static void Test_aVp_Ui_BFu9ll()
{
  {
    init_simple_test("aVp_Ui_BFu9ll");
    static STRUCT_IF_C aVp_Ui_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aVp_Ui_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aVp_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu9ll, aVp_Ui_BFu9ll)
//============================================================================



static void Test_aVp_Ui_BFu9s()
{
  {
    init_simple_test("aVp_Ui_BFu9s");
    static STRUCT_IF_C aVp_Ui_BFu9s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_Ui_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aVp_Ui_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aVp_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_BFu9s, aVp_Ui_BFu9s)
//============================================================================



static void Test_aVp_Ui_C()
{
  {
    init_simple_test("aVp_Ui_C");
    STRUCT_IF_C aVp_Ui_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_C)");
    check_field_offset(lv, v1, 0, "aVp_Ui_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_C.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_C, aVp_Ui_C)
//============================================================================



static void Test_aVp_Ui_D()
{
  {
    init_simple_test("aVp_Ui_D");
    STRUCT_IF_C aVp_Ui_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_D)");
    check_field_offset(lv, v1, 0, "aVp_Ui_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_D.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_D, aVp_Ui_D)
//============================================================================



static void Test_aVp_Ui_F()
{
  {
    init_simple_test("aVp_Ui_F");
    STRUCT_IF_C aVp_Ui_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_F)");
    check_field_offset(lv, v1, 0, "aVp_Ui_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_F.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_F, aVp_Ui_F)
//============================================================================



static void Test_aVp_Ui_I()
{
  {
    init_simple_test("aVp_Ui_I");
    STRUCT_IF_C aVp_Ui_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_I)");
    check_field_offset(lv, v1, 0, "aVp_Ui_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_I.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_I, aVp_Ui_I)
//============================================================================



static void Test_aVp_Ui_Ip()
{
  {
    init_simple_test("aVp_Ui_Ip");
    STRUCT_IF_C aVp_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_Ip)");
    check_field_offset(lv, v1, 0, "aVp_Ui_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_Ip, aVp_Ui_Ip)
//============================================================================



static void Test_aVp_Ui_L()
{
  {
    init_simple_test("aVp_Ui_L");
    STRUCT_IF_C aVp_Ui_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_L)");
    check_field_offset(lv, v1, 0, "aVp_Ui_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_L.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_L, aVp_Ui_L)
//============================================================================



static void Test_aVp_Ui_S()
{
  {
    init_simple_test("aVp_Ui_S");
    STRUCT_IF_C aVp_Ui_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_S)");
    check_field_offset(lv, v1, 0, "aVp_Ui_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_S.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_S, aVp_Ui_S)
//============================================================================



static void Test_aVp_Ui_Uc()
{
  {
    init_simple_test("aVp_Ui_Uc");
    STRUCT_IF_C aVp_Ui_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_Uc)");
    check_field_offset(lv, v1, 0, "aVp_Ui_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_Uc, aVp_Ui_Uc)
//============================================================================



static void Test_aVp_Ui_Ui()
{
  {
    init_simple_test("aVp_Ui_Ui");
    STRUCT_IF_C aVp_Ui_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_Ui)");
    check_field_offset(lv, v1, 0, "aVp_Ui_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_Ui, aVp_Ui_Ui)
//============================================================================



static void Test_aVp_Ui_Ul()
{
  {
    init_simple_test("aVp_Ui_Ul");
    STRUCT_IF_C aVp_Ui_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_Ul)");
    check_field_offset(lv, v1, 0, "aVp_Ui_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_Ul, aVp_Ui_Ul)
//============================================================================



static void Test_aVp_Ui_Us()
{
  {
    init_simple_test("aVp_Ui_Us");
    STRUCT_IF_C aVp_Ui_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_Us)");
    check_field_offset(lv, v1, 0, "aVp_Ui_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_Us.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_Us, aVp_Ui_Us)
//============================================================================



static void Test_aVp_Ui_Vp()
{
  {
    init_simple_test("aVp_Ui_Vp");
    STRUCT_IF_C aVp_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aVp_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ui_Vp)");
    check_field_offset(lv, v1, 0, "aVp_Ui_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ui_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aVp_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ui_Vp, aVp_Ui_Vp)
//============================================================================



static void Test_aVp_Ul()
{
  {
    init_simple_test("aVp_Ul");
    STRUCT_IF_C aVp_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aVp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul)");
    check_field_offset(lv, v1, 0, "aVp_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul, aVp_Ul)
//============================================================================



static void Test_aVp_Ul_BFu15i()
{
  {
    init_simple_test("aVp_Ul_BFu15i");
    static STRUCT_IF_C aVp_Ul_BFu15i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aVp_Ul_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aVp_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu15i, aVp_Ul_BFu15i)
//============================================================================



static void Test_aVp_Ul_BFu15ll()
{
  {
    init_simple_test("aVp_Ul_BFu15ll");
    static STRUCT_IF_C aVp_Ul_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aVp_Ul_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aVp_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu15ll, aVp_Ul_BFu15ll)
//============================================================================



static void Test_aVp_Ul_BFu15s()
{
  {
    init_simple_test("aVp_Ul_BFu15s");
    static STRUCT_IF_C aVp_Ul_BFu15s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aVp_Ul_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aVp_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu15s, aVp_Ul_BFu15s)
//============================================================================



static void Test_aVp_Ul_BFu16i()
{
  {
    init_simple_test("aVp_Ul_BFu16i");
    static STRUCT_IF_C aVp_Ul_BFu16i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aVp_Ul_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aVp_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu16i, aVp_Ul_BFu16i)
//============================================================================



static void Test_aVp_Ul_BFu16ll()
{
  {
    init_simple_test("aVp_Ul_BFu16ll");
    static STRUCT_IF_C aVp_Ul_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aVp_Ul_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aVp_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu16ll, aVp_Ul_BFu16ll)
//============================================================================



static void Test_aVp_Ul_BFu16s()
{
  {
    init_simple_test("aVp_Ul_BFu16s");
    static STRUCT_IF_C aVp_Ul_BFu16s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aVp_Ul_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aVp_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu16s, aVp_Ul_BFu16s)
//============================================================================



static void Test_aVp_Ul_BFu17i()
{
  {
    init_simple_test("aVp_Ul_BFu17i");
    static STRUCT_IF_C aVp_Ul_BFu17i lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aVp_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "aVp_Ul_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "aVp_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu17i, aVp_Ul_BFu17i)
//============================================================================



static void Test_aVp_Ul_BFu17ll()
{
  {
    init_simple_test("aVp_Ul_BFu17ll");
    static STRUCT_IF_C aVp_Ul_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aVp_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "aVp_Ul_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "aVp_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu17ll, aVp_Ul_BFu17ll)
//============================================================================



static void Test_aVp_Ul_BFu1c()
{
  {
    init_simple_test("aVp_Ul_BFu1c");
    static STRUCT_IF_C aVp_Ul_BFu1c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aVp_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu1c, aVp_Ul_BFu1c)
//============================================================================



static void Test_aVp_Ul_BFu1i()
{
  {
    init_simple_test("aVp_Ul_BFu1i");
    static STRUCT_IF_C aVp_Ul_BFu1i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aVp_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu1i, aVp_Ul_BFu1i)
//============================================================================



static void Test_aVp_Ul_BFu1ll()
{
  {
    init_simple_test("aVp_Ul_BFu1ll");
    static STRUCT_IF_C aVp_Ul_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aVp_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu1ll, aVp_Ul_BFu1ll)
//============================================================================



static void Test_aVp_Ul_BFu1s()
{
  {
    init_simple_test("aVp_Ul_BFu1s");
    static STRUCT_IF_C aVp_Ul_BFu1s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aVp_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu1s, aVp_Ul_BFu1s)
//============================================================================



static void Test_aVp_Ul_BFu31i()
{
  {
    init_simple_test("aVp_Ul_BFu31i");
    static STRUCT_IF_C aVp_Ul_BFu31i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "aVp_Ul_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "aVp_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu31i, aVp_Ul_BFu31i)
//============================================================================



static void Test_aVp_Ul_BFu31ll()
{
  {
    init_simple_test("aVp_Ul_BFu31ll");
    static STRUCT_IF_C aVp_Ul_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "aVp_Ul_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "aVp_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu31ll, aVp_Ul_BFu31ll)
//============================================================================



static void Test_aVp_Ul_BFu32i()
{
  {
    init_simple_test("aVp_Ul_BFu32i");
    static STRUCT_IF_C aVp_Ul_BFu32i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "aVp_Ul_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "aVp_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu32i, aVp_Ul_BFu32i)
//============================================================================



static void Test_aVp_Ul_BFu32ll()
{
  {
    init_simple_test("aVp_Ul_BFu32ll");
    static STRUCT_IF_C aVp_Ul_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "aVp_Ul_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "aVp_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu32ll, aVp_Ul_BFu32ll)
//============================================================================



static void Test_aVp_Ul_BFu33()
{
  {
    init_simple_test("aVp_Ul_BFu33");
    static STRUCT_IF_C aVp_Ul_BFu33 lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(aVp_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "aVp_Ul_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "aVp_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu33, aVp_Ul_BFu33)
//============================================================================



static void Test_aVp_Ul_BFu7c()
{
  {
    init_simple_test("aVp_Ul_BFu7c");
    static STRUCT_IF_C aVp_Ul_BFu7c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aVp_Ul_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aVp_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu7c, aVp_Ul_BFu7c)
//============================================================================



static void Test_aVp_Ul_BFu7i()
{
  {
    init_simple_test("aVp_Ul_BFu7i");
    static STRUCT_IF_C aVp_Ul_BFu7i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aVp_Ul_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aVp_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu7i, aVp_Ul_BFu7i)
//============================================================================



static void Test_aVp_Ul_BFu7ll()
{
  {
    init_simple_test("aVp_Ul_BFu7ll");
    static STRUCT_IF_C aVp_Ul_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aVp_Ul_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aVp_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu7ll, aVp_Ul_BFu7ll)
//============================================================================



static void Test_aVp_Ul_BFu7s()
{
  {
    init_simple_test("aVp_Ul_BFu7s");
    static STRUCT_IF_C aVp_Ul_BFu7s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aVp_Ul_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aVp_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu7s, aVp_Ul_BFu7s)
//============================================================================



static void Test_aVp_Ul_BFu8c()
{
  {
    init_simple_test("aVp_Ul_BFu8c");
    static STRUCT_IF_C aVp_Ul_BFu8c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aVp_Ul_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aVp_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu8c, aVp_Ul_BFu8c)
//============================================================================



static void Test_aVp_Ul_BFu8i()
{
  {
    init_simple_test("aVp_Ul_BFu8i");
    static STRUCT_IF_C aVp_Ul_BFu8i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aVp_Ul_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aVp_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu8i, aVp_Ul_BFu8i)
//============================================================================



static void Test_aVp_Ul_BFu8ll()
{
  {
    init_simple_test("aVp_Ul_BFu8ll");
    static STRUCT_IF_C aVp_Ul_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aVp_Ul_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aVp_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu8ll, aVp_Ul_BFu8ll)
//============================================================================



static void Test_aVp_Ul_BFu8s()
{
  {
    init_simple_test("aVp_Ul_BFu8s");
    static STRUCT_IF_C aVp_Ul_BFu8s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aVp_Ul_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aVp_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu8s, aVp_Ul_BFu8s)
//============================================================================



static void Test_aVp_Ul_BFu9i()
{
  {
    init_simple_test("aVp_Ul_BFu9i");
    static STRUCT_IF_C aVp_Ul_BFu9i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aVp_Ul_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aVp_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu9i, aVp_Ul_BFu9i)
//============================================================================



static void Test_aVp_Ul_BFu9ll()
{
  {
    init_simple_test("aVp_Ul_BFu9ll");
    static STRUCT_IF_C aVp_Ul_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aVp_Ul_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aVp_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu9ll, aVp_Ul_BFu9ll)
//============================================================================



static void Test_aVp_Ul_BFu9s()
{
  {
    init_simple_test("aVp_Ul_BFu9s");
    static STRUCT_IF_C aVp_Ul_BFu9s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_Ul_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aVp_Ul_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aVp_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_BFu9s, aVp_Ul_BFu9s)
//============================================================================



static void Test_aVp_Ul_C()
{
  {
    init_simple_test("aVp_Ul_C");
    STRUCT_IF_C aVp_Ul_C lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_C)");
    check_field_offset(lv, v1, 0, "aVp_Ul_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_C, aVp_Ul_C)
//============================================================================



static void Test_aVp_Ul_D()
{
  {
    init_simple_test("aVp_Ul_D");
    STRUCT_IF_C aVp_Ul_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aVp_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_D)");
    check_field_offset(lv, v1, 0, "aVp_Ul_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_D, aVp_Ul_D)
//============================================================================



static void Test_aVp_Ul_F()
{
  {
    init_simple_test("aVp_Ul_F");
    STRUCT_IF_C aVp_Ul_F lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_F)");
    check_field_offset(lv, v1, 0, "aVp_Ul_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_F, aVp_Ul_F)
//============================================================================



static void Test_aVp_Ul_I()
{
  {
    init_simple_test("aVp_Ul_I");
    STRUCT_IF_C aVp_Ul_I lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_I)");
    check_field_offset(lv, v1, 0, "aVp_Ul_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_I, aVp_Ul_I)
//============================================================================



static void Test_aVp_Ul_Ip()
{
  {
    init_simple_test("aVp_Ul_Ip");
    STRUCT_IF_C aVp_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aVp_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_Ip)");
    check_field_offset(lv, v1, 0, "aVp_Ul_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_Ip, aVp_Ul_Ip)
//============================================================================



static void Test_aVp_Ul_L()
{
  {
    init_simple_test("aVp_Ul_L");
    STRUCT_IF_C aVp_Ul_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aVp_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_L)");
    check_field_offset(lv, v1, 0, "aVp_Ul_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_L, aVp_Ul_L)
//============================================================================



static void Test_aVp_Ul_S()
{
  {
    init_simple_test("aVp_Ul_S");
    STRUCT_IF_C aVp_Ul_S lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_S)");
    check_field_offset(lv, v1, 0, "aVp_Ul_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_S, aVp_Ul_S)
//============================================================================



static void Test_aVp_Ul_Uc()
{
  {
    init_simple_test("aVp_Ul_Uc");
    STRUCT_IF_C aVp_Ul_Uc lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aVp_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_Uc)");
    check_field_offset(lv, v1, 0, "aVp_Ul_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_Uc, aVp_Ul_Uc)
//============================================================================



static void Test_aVp_Ul_Ui()
{
  {
    init_simple_test("aVp_Ul_Ui");
    STRUCT_IF_C aVp_Ul_Ui lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aVp_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_Ui)");
    check_field_offset(lv, v1, 0, "aVp_Ul_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_Ui, aVp_Ul_Ui)
//============================================================================



static void Test_aVp_Ul_Ul()
{
  {
    init_simple_test("aVp_Ul_Ul");
    STRUCT_IF_C aVp_Ul_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aVp_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_Ul)");
    check_field_offset(lv, v1, 0, "aVp_Ul_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_Ul, aVp_Ul_Ul)
//============================================================================



static void Test_aVp_Ul_Us()
{
  {
    init_simple_test("aVp_Ul_Us");
    STRUCT_IF_C aVp_Ul_Us lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_Us)");
    check_field_offset(lv, v1, 0, "aVp_Ul_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_Us, aVp_Ul_Us)
//============================================================================



static void Test_aVp_Ul_Vp()
{
  {
    init_simple_test("aVp_Ul_Vp");
    STRUCT_IF_C aVp_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aVp_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Ul_Vp)");
    check_field_offset(lv, v1, 0, "aVp_Ul_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Ul_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aVp_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Ul_Vp, aVp_Ul_Vp)
//============================================================================



static void Test_aVp_Us()
{
  {
    init_simple_test("aVp_Us");
    STRUCT_IF_C aVp_Us lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aVp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us)");
    check_field_offset(lv, v1, 0, "aVp_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us, aVp_Us)
//============================================================================



static void Test_aVp_Us_BFu15i()
{
  {
    init_simple_test("aVp_Us_BFu15i");
    static STRUCT_IF_C aVp_Us_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aVp_Us_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aVp_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu15i, aVp_Us_BFu15i)
//============================================================================



static void Test_aVp_Us_BFu15ll()
{
  {
    init_simple_test("aVp_Us_BFu15ll");
    static STRUCT_IF_C aVp_Us_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aVp_Us_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aVp_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu15ll, aVp_Us_BFu15ll)
//============================================================================



static void Test_aVp_Us_BFu15s()
{
  {
    init_simple_test("aVp_Us_BFu15s");
    static STRUCT_IF_C aVp_Us_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aVp_Us_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aVp_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu15s, aVp_Us_BFu15s)
//============================================================================



static void Test_aVp_Us_BFu16i()
{
  {
    init_simple_test("aVp_Us_BFu16i");
    static STRUCT_IF_C aVp_Us_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aVp_Us_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aVp_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu16i, aVp_Us_BFu16i)
//============================================================================



static void Test_aVp_Us_BFu16ll()
{
  {
    init_simple_test("aVp_Us_BFu16ll");
    static STRUCT_IF_C aVp_Us_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aVp_Us_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aVp_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu16ll, aVp_Us_BFu16ll)
//============================================================================



static void Test_aVp_Us_BFu16s()
{
  {
    init_simple_test("aVp_Us_BFu16s");
    static STRUCT_IF_C aVp_Us_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aVp_Us_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aVp_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu16s, aVp_Us_BFu16s)
//============================================================================



static void Test_aVp_Us_BFu17i()
{
  {
    init_simple_test("aVp_Us_BFu17i");
    static STRUCT_IF_C aVp_Us_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "aVp_Us_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "aVp_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu17i, aVp_Us_BFu17i)
//============================================================================



static void Test_aVp_Us_BFu17ll()
{
  {
    init_simple_test("aVp_Us_BFu17ll");
    static STRUCT_IF_C aVp_Us_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aVp_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "aVp_Us_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "aVp_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu17ll, aVp_Us_BFu17ll)
//============================================================================



static void Test_aVp_Us_BFu1c()
{
  {
    init_simple_test("aVp_Us_BFu1c");
    static STRUCT_IF_C aVp_Us_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aVp_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu1c, aVp_Us_BFu1c)
//============================================================================



static void Test_aVp_Us_BFu1i()
{
  {
    init_simple_test("aVp_Us_BFu1i");
    static STRUCT_IF_C aVp_Us_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu1i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aVp_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu1i, aVp_Us_BFu1i)
//============================================================================



static void Test_aVp_Us_BFu1ll()
{
  {
    init_simple_test("aVp_Us_BFu1ll");
    static STRUCT_IF_C aVp_Us_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu1ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aVp_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu1ll, aVp_Us_BFu1ll)
//============================================================================



static void Test_aVp_Us_BFu1s()
{
  {
    init_simple_test("aVp_Us_BFu1s");
    static STRUCT_IF_C aVp_Us_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu1s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aVp_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu1s, aVp_Us_BFu1s)
//============================================================================



static void Test_aVp_Us_BFu31i()
{
  {
    init_simple_test("aVp_Us_BFu31i");
    static STRUCT_IF_C aVp_Us_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu31i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "aVp_Us_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "aVp_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu31i, aVp_Us_BFu31i)
//============================================================================



static void Test_aVp_Us_BFu31ll()
{
  {
    init_simple_test("aVp_Us_BFu31ll");
    static STRUCT_IF_C aVp_Us_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu31ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "aVp_Us_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "aVp_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu31ll, aVp_Us_BFu31ll)
//============================================================================



static void Test_aVp_Us_BFu32i()
{
  {
    init_simple_test("aVp_Us_BFu32i");
    static STRUCT_IF_C aVp_Us_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu32i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "aVp_Us_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "aVp_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu32i, aVp_Us_BFu32i)
//============================================================================



static void Test_aVp_Us_BFu32ll()
{
  {
    init_simple_test("aVp_Us_BFu32ll");
    static STRUCT_IF_C aVp_Us_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu32ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "aVp_Us_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "aVp_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu32ll, aVp_Us_BFu32ll)
//============================================================================



static void Test_aVp_Us_BFu33()
{
  {
    init_simple_test("aVp_Us_BFu33");
    static STRUCT_IF_C aVp_Us_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aVp_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu33)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu33.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "aVp_Us_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "aVp_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu33, aVp_Us_BFu33)
//============================================================================



static void Test_aVp_Us_BFu7c()
{
  {
    init_simple_test("aVp_Us_BFu7c");
    static STRUCT_IF_C aVp_Us_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu7c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aVp_Us_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aVp_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu7c, aVp_Us_BFu7c)
//============================================================================



static void Test_aVp_Us_BFu7i()
{
  {
    init_simple_test("aVp_Us_BFu7i");
    static STRUCT_IF_C aVp_Us_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu7i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aVp_Us_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aVp_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu7i, aVp_Us_BFu7i)
//============================================================================



static void Test_aVp_Us_BFu7ll()
{
  {
    init_simple_test("aVp_Us_BFu7ll");
    static STRUCT_IF_C aVp_Us_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu7ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aVp_Us_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aVp_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu7ll, aVp_Us_BFu7ll)
//============================================================================



static void Test_aVp_Us_BFu7s()
{
  {
    init_simple_test("aVp_Us_BFu7s");
    static STRUCT_IF_C aVp_Us_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu7s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aVp_Us_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aVp_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu7s, aVp_Us_BFu7s)
//============================================================================



static void Test_aVp_Us_BFu8c()
{
  {
    init_simple_test("aVp_Us_BFu8c");
    static STRUCT_IF_C aVp_Us_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu8c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aVp_Us_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aVp_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu8c, aVp_Us_BFu8c)
//============================================================================



static void Test_aVp_Us_BFu8i()
{
  {
    init_simple_test("aVp_Us_BFu8i");
    static STRUCT_IF_C aVp_Us_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu8i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aVp_Us_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aVp_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu8i, aVp_Us_BFu8i)
//============================================================================



static void Test_aVp_Us_BFu8ll()
{
  {
    init_simple_test("aVp_Us_BFu8ll");
    static STRUCT_IF_C aVp_Us_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu8ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aVp_Us_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aVp_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu8ll, aVp_Us_BFu8ll)
//============================================================================



static void Test_aVp_Us_BFu8s()
{
  {
    init_simple_test("aVp_Us_BFu8s");
    static STRUCT_IF_C aVp_Us_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu8s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aVp_Us_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aVp_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu8s, aVp_Us_BFu8s)
//============================================================================



static void Test_aVp_Us_BFu9i()
{
  {
    init_simple_test("aVp_Us_BFu9i");
    static STRUCT_IF_C aVp_Us_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu9i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aVp_Us_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aVp_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu9i, aVp_Us_BFu9i)
//============================================================================



static void Test_aVp_Us_BFu9ll()
{
  {
    init_simple_test("aVp_Us_BFu9ll");
    static STRUCT_IF_C aVp_Us_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu9ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aVp_Us_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aVp_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu9ll, aVp_Us_BFu9ll)
//============================================================================



static void Test_aVp_Us_BFu9s()
{
  {
    init_simple_test("aVp_Us_BFu9s");
    static STRUCT_IF_C aVp_Us_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "aVp_Us_BFu9s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aVp_Us_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aVp_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_BFu9s, aVp_Us_BFu9s)
//============================================================================



static void Test_aVp_Us_C()
{
  {
    init_simple_test("aVp_Us_C");
    STRUCT_IF_C aVp_Us_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_C)");
    check_field_offset(lv, v1, 0, "aVp_Us_C.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_C.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_C, aVp_Us_C)
//============================================================================



static void Test_aVp_Us_D()
{
  {
    init_simple_test("aVp_Us_D");
    STRUCT_IF_C aVp_Us_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_D)");
    check_field_offset(lv, v1, 0, "aVp_Us_D.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_D.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_D, aVp_Us_D)
//============================================================================



static void Test_aVp_Us_F()
{
  {
    init_simple_test("aVp_Us_F");
    STRUCT_IF_C aVp_Us_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_F)");
    check_field_offset(lv, v1, 0, "aVp_Us_F.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_F.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_F, aVp_Us_F)
//============================================================================



static void Test_aVp_Us_I()
{
  {
    init_simple_test("aVp_Us_I");
    STRUCT_IF_C aVp_Us_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_I)");
    check_field_offset(lv, v1, 0, "aVp_Us_I.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_I.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_I, aVp_Us_I)
//============================================================================



static void Test_aVp_Us_Ip()
{
  {
    init_simple_test("aVp_Us_Ip");
    STRUCT_IF_C aVp_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_Ip)");
    check_field_offset(lv, v1, 0, "aVp_Us_Ip.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_Ip, aVp_Us_Ip)
//============================================================================



static void Test_aVp_Us_L()
{
  {
    init_simple_test("aVp_Us_L");
    STRUCT_IF_C aVp_Us_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_L)");
    check_field_offset(lv, v1, 0, "aVp_Us_L.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_L.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_L, aVp_Us_L)
//============================================================================



static void Test_aVp_Us_S()
{
  {
    init_simple_test("aVp_Us_S");
    STRUCT_IF_C aVp_Us_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_S)");
    check_field_offset(lv, v1, 0, "aVp_Us_S.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_S.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_S, aVp_Us_S)
//============================================================================



static void Test_aVp_Us_Uc()
{
  {
    init_simple_test("aVp_Us_Uc");
    STRUCT_IF_C aVp_Us_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aVp_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_Uc)");
    check_field_offset(lv, v1, 0, "aVp_Us_Uc.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_Uc, aVp_Us_Uc)
//============================================================================



static void Test_aVp_Us_Ui()
{
  {
    init_simple_test("aVp_Us_Ui");
    STRUCT_IF_C aVp_Us_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aVp_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_Ui)");
    check_field_offset(lv, v1, 0, "aVp_Us_Ui.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_Ui, aVp_Us_Ui)
//============================================================================



static void Test_aVp_Us_Ul()
{
  {
    init_simple_test("aVp_Us_Ul");
    STRUCT_IF_C aVp_Us_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aVp_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_Ul)");
    check_field_offset(lv, v1, 0, "aVp_Us_Ul.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_Ul, aVp_Us_Ul)
//============================================================================



static void Test_aVp_Us_Us()
{
  {
    init_simple_test("aVp_Us_Us");
    STRUCT_IF_C aVp_Us_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aVp_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_Us)");
    check_field_offset(lv, v1, 0, "aVp_Us_Us.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_Us.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_Us, aVp_Us_Us)
//============================================================================



static void Test_aVp_Us_Vp()
{
  {
    init_simple_test("aVp_Us_Vp");
    STRUCT_IF_C aVp_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Us_Vp)");
    check_field_offset(lv, v1, 0, "aVp_Us_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Us_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(10,6), "aVp_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Us_Vp, aVp_Us_Vp)
//============================================================================



static void Test_aVp_Vp()
{
  {
    init_simple_test("aVp_Vp");
    STRUCT_IF_C aVp_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aVp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Vp)");
    check_field_offset(lv, v1, 0, "aVp_Vp.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Vp, aVp_Vp)
//============================================================================



static void Test_aVp_Vp_BFu15i()
{
  {
    init_simple_test("aVp_Vp_BFu15i");
    static STRUCT_IF_C aVp_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "aVp_Vp_BFu15i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "aVp_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "aVp_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Vp_BFu15i, aVp_Vp_BFu15i)
//============================================================================



static void Test_aVp_Vp_BFu15ll()
{
  {
    init_simple_test("aVp_Vp_BFu15ll");
    static STRUCT_IF_C aVp_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "aVp_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "aVp_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "aVp_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Vp_BFu15ll, aVp_Vp_BFu15ll)
//============================================================================



static void Test_aVp_Vp_BFu15s()
{
  {
    init_simple_test("aVp_Vp_BFu15s");
    static STRUCT_IF_C aVp_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "aVp_Vp_BFu15s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, 1, "aVp_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 15, hide_ull(1LL<<14), "aVp_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Vp_BFu15s, aVp_Vp_BFu15s)
//============================================================================



static void Test_aVp_Vp_BFu16i()
{
  {
    init_simple_test("aVp_Vp_BFu16i");
    static STRUCT_IF_C aVp_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "aVp_Vp_BFu16i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "aVp_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "aVp_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Vp_BFu16i, aVp_Vp_BFu16i)
//============================================================================



static void Test_aVp_Vp_BFu16ll()
{
  {
    init_simple_test("aVp_Vp_BFu16ll");
    static STRUCT_IF_C aVp_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "aVp_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "aVp_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "aVp_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Vp_BFu16ll, aVp_Vp_BFu16ll)
//============================================================================



static void Test_aVp_Vp_BFu16s()
{
  {
    init_simple_test("aVp_Vp_BFu16s");
    static STRUCT_IF_C aVp_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aVp_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "aVp_Vp_BFu16s.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, 1, "aVp_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 16, hide_ull(1LL<<15), "aVp_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Vp_BFu16s, aVp_Vp_BFu16s)
//============================================================================



static void Test_aVp_Vp_BFu17i()
{
  {
    init_simple_test("aVp_Vp_BFu17i");
    static STRUCT_IF_C aVp_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(19,11), "sizeof(aVp_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "aVp_Vp_BFu17i.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "aVp_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "aVp_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Vp_BFu17i, aVp_Vp_BFu17i)
//============================================================================



static void Test_aVp_Vp_BFu17ll()
{
  {
    init_simple_test("aVp_Vp_BFu17ll");
    static STRUCT_IF_C aVp_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(19,11), "sizeof(aVp_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "aVp_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, 1, "aVp_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 17, hide_ull(1LL<<16), "aVp_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Vp_BFu17ll, aVp_Vp_BFu17ll)
//============================================================================



static void Test_aVp_Vp_BFu1c()
{
  {
    init_simple_test("aVp_Vp_BFu1c");
    static STRUCT_IF_C aVp_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aVp_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aVp_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "aVp_Vp_BFu1c.v1");
    check_field_offset(lv, v2, ABISELECT(8,4), "aVp_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,8), 0, 1, 1, "aVp_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aVp_Vp_BFu1c, aVp_Vp_BFu1c)
//============================================================================



static void Test_aVp_Vp_BFu1i()
{
  {