// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
struct __attribute__((packed)) aUl_BFu8i_BFu31ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu8i_BFu32i { unsigned long long v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu8i_BFu32ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu8i_BFu33 { unsigned long long v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu8i_BFu7c { unsigned long long v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu8i_BFu7i { unsigned long long v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu8i_BFu7ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu8i_BFu7s { unsigned long long v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu8i_BFu8c { unsigned long long v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu8i_BFu8i { unsigned long long v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu8i_BFu8ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu8i_BFu8s { unsigned long long v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu8i_BFu9i { unsigned long long v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu8i_BFu9ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu8i_BFu9s { unsigned long long v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu8i_C { unsigned long long v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aUl_BFu8i_D { unsigned long long v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aUl_BFu8i_F { unsigned long long v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aUl_BFu8i_I { unsigned long long v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aUl_BFu8i_Ip { unsigned long long v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aUl_BFu8i_L { unsigned long long v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aUl_BFu8i_S { unsigned long long v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aUl_BFu8i_Uc { unsigned long long v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu8i_Ui { unsigned long long v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu8i_Ul { unsigned long long v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu8i_Us { unsigned long long v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu8i_Vp { unsigned long long v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aUl_BFu8ll { unsigned long long v1; unsigned long long v2:8; };
struct __attribute__((packed)) aUl_BFu8ll_BFu15i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu8ll_BFu15ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu8ll_BFu15s { unsigned long long v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu8ll_BFu16i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu8ll_BFu16ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu8ll_BFu16s { unsigned long long v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu8ll_BFu17i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu8ll_BFu17ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu8ll_BFu1c { unsigned long long v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu8ll_BFu1i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu8ll_BFu1ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu8ll_BFu1s { unsigned long long v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu8ll_BFu31i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu8ll_BFu31ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu8ll_BFu32i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu8ll_BFu32ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu8ll_BFu33 { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu8ll_BFu7c { unsigned long long v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu8ll_BFu7i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu8ll_BFu7ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu8ll_BFu7s { unsigned long long v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu8ll_BFu8c { unsigned long long v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu8ll_BFu8i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu8ll_BFu8ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu8ll_BFu8s { unsigned long long v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu8ll_BFu9i { unsigned long long v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu8ll_BFu9ll { unsigned long long v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu8ll_BFu9s { unsigned long long v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu8ll_C { unsigned long long v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aUl_BFu8ll_D { unsigned long long v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aUl_BFu8ll_F { unsigned long long v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aUl_BFu8ll_I { unsigned long long v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aUl_BFu8ll_Ip { unsigned long long v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aUl_BFu8ll_L { unsigned long long v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aUl_BFu8ll_S { unsigned long long v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aUl_BFu8ll_Uc { unsigned long long v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu8ll_Ui { unsigned long long v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu8ll_Ul { unsigned long long v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu8ll_Us { unsigned long long v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu8ll_Vp { unsigned long long v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aUl_BFu8s { unsigned long long v1; unsigned short v2:8; };
struct __attribute__((packed)) aUl_BFu8s_BFu15i { unsigned long long v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu8s_BFu15ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu8s_BFu15s { unsigned long long v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu8s_BFu16i { unsigned long long v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu8s_BFu16ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu8s_BFu16s { unsigned long long v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu8s_BFu17i { unsigned long long v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu8s_BFu17ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu8s_BFu1c { unsigned long long v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu8s_BFu1i { unsigned long long v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu8s_BFu1ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu8s_BFu1s { unsigned long long v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu8s_BFu31i { unsigned long long v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu8s_BFu31ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu8s_BFu32i { unsigned long long v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu8s_BFu32ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu8s_BFu33 { unsigned long long v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu8s_BFu7c { unsigned long long v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu8s_BFu7i { unsigned long long v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu8s_BFu7ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu8s_BFu7s { unsigned long long v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu8s_BFu8c { unsigned long long v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu8s_BFu8i { unsigned long long v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu8s_BFu8ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu8s_BFu8s { unsigned long long v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu8s_BFu9i { unsigned long long v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu8s_BFu9ll { unsigned long long v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu8s_BFu9s { unsigned long long v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu8s_C { unsigned long long v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aUl_BFu8s_D { unsigned long long v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aUl_BFu8s_F { unsigned long long v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aUl_BFu8s_I { unsigned long long v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aUl_BFu8s_Ip { unsigned long long v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aUl_BFu8s_L { unsigned long long v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aUl_BFu8s_S { unsigned long long v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aUl_BFu8s_Uc { unsigned long long v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu8s_Ui { unsigned long long v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu8s_Ul { unsigned long long v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu8s_Us { unsigned long long v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu8s_Vp { unsigned long long v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aUl_BFu9i { unsigned long long v1; unsigned int v2:9; };
struct __attribute__((packed)) aUl_BFu9i_BFu15i { unsigned long long v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu9i_BFu15ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu9i_BFu15s { unsigned long long v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu9i_BFu16i { unsigned long long v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu9i_BFu16ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu9i_BFu16s { unsigned long long v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu9i_BFu17i { unsigned long long v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu9i_BFu17ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu9i_BFu1c { unsigned long long v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu9i_BFu1i { unsigned long long v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu9i_BFu1ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu9i_BFu1s { unsigned long long v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu9i_BFu31i { unsigned long long v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu9i_BFu31ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu9i_BFu32i { unsigned long long v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu9i_BFu32ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu9i_BFu33 { unsigned long long v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu9i_BFu7c { unsigned long long v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu9i_BFu7i { unsigned long long v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu9i_BFu7ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu9i_BFu7s { unsigned long long v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu9i_BFu8c { unsigned long long v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu9i_BFu8i { unsigned long long v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu9i_BFu8ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu9i_BFu8s { unsigned long long v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu9i_BFu9i { unsigned long long v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu9i_BFu9ll { unsigned long long v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu9i_BFu9s { unsigned long long v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu9i_C { unsigned long long v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aUl_BFu9i_D { unsigned long long v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aUl_BFu9i_F { unsigned long long v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aUl_BFu9i_I { unsigned long long v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aUl_BFu9i_Ip { unsigned long long v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aUl_BFu9i_L { unsigned long long v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aUl_BFu9i_S { unsigned long long v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aUl_BFu9i_Uc { unsigned long long v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu9i_Ui { unsigned long long v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu9i_Ul { unsigned long long v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu9i_Us { unsigned long long v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu9i_Vp { unsigned long long v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aUl_BFu9ll { unsigned long long v1; unsigned long long v2:9; };
struct __attribute__((packed)) aUl_BFu9ll_BFu15i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu9ll_BFu15ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu9ll_BFu15s { unsigned long long v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu9ll_BFu16i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu9ll_BFu16ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu9ll_BFu16s { unsigned long long v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu9ll_BFu17i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu9ll_BFu17ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu9ll_BFu1c { unsigned long long v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu9ll_BFu1i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu9ll_BFu1ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu9ll_BFu1s { unsigned long long v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu9ll_BFu31i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu9ll_BFu31ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu9ll_BFu32i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu9ll_BFu32ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu9ll_BFu33 { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu9ll_BFu7c { unsigned long long v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu9ll_BFu7i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu9ll_BFu7ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu9ll_BFu7s { unsigned long long v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu9ll_BFu8c { unsigned long long v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu9ll_BFu8i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu9ll_BFu8ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu9ll_BFu8s { unsigned long long v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu9ll_BFu9i { unsigned long long v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu9ll_BFu9ll { unsigned long long v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu9ll_BFu9s { unsigned long long v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu9ll_C { unsigned long long v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aUl_BFu9ll_D { unsigned long long v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aUl_BFu9ll_F { unsigned long long v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aUl_BFu9ll_I { unsigned long long v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aUl_BFu9ll_Ip { unsigned long long v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aUl_BFu9ll_L { unsigned long long v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aUl_BFu9ll_S { unsigned long long v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aUl_BFu9ll_Uc { unsigned long long v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu9ll_Ui { unsigned long long v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu9ll_Ul { unsigned long long v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu9ll_Us { unsigned long long v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu9ll_Vp { unsigned long long v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aUl_BFu9s { unsigned long long v1; unsigned short v2:9; };
struct __attribute__((packed)) aUl_BFu9s_BFu15i { unsigned long long v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu9s_BFu15ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu9s_BFu15s { unsigned long long v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu9s_BFu16i { unsigned long long v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu9s_BFu16ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu9s_BFu16s { unsigned long long v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu9s_BFu17i { unsigned long long v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu9s_BFu17ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu9s_BFu1c { unsigned long long v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu9s_BFu1i { unsigned long long v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu9s_BFu1ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu9s_BFu1s { unsigned long long v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu9s_BFu31i { unsigned long long v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu9s_BFu31ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu9s_BFu32i { unsigned long long v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu9s_BFu32ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu9s_BFu33 { unsigned long long v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu9s_BFu7c { unsigned long long v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu9s_BFu7i { unsigned long long v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu9s_BFu7ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu9s_BFu7s { unsigned long long v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu9s_BFu8c { unsigned long long v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu9s_BFu8i { unsigned long long v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu9s_BFu8ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu9s_BFu8s { unsigned long long v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu9s_BFu9i { unsigned long long v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu9s_BFu9ll { unsigned long long v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu9s_BFu9s { unsigned long long v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu9s_C { unsigned long long v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aUl_BFu9s_D { unsigned long long v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aUl_BFu9s_F { unsigned long long v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aUl_BFu9s_I { unsigned long long v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aUl_BFu9s_Ip { unsigned long long v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aUl_BFu9s_L { unsigned long long v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aUl_BFu9s_S { unsigned long long v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aUl_BFu9s_Uc { unsigned long long v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu9s_Ui { unsigned long long v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu9s_Ul { unsigned long long v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu9s_Us { unsigned long long v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu9s_Vp { unsigned long long v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aUl_C { unsigned long long v1; char v2; };
struct __attribute__((packed)) aUl_C_BFu15i { unsigned long long v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_C_BFu15ll { unsigned long long v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_C_BFu15s { unsigned long long v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_C_BFu16i { unsigned long long v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_C_BFu16ll { unsigned long long v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_C_BFu16s { unsigned long long v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_C_BFu17i { unsigned long long v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_C_BFu17ll { unsigned long long v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_C_BFu1c { unsigned long long v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_C_BFu1i { unsigned long long v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_C_BFu1ll { unsigned long long v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_C_BFu1s { unsigned long long v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_C_BFu31i { unsigned long long v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_C_BFu31ll { unsigned long long v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_C_BFu32i { unsigned long long v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_C_BFu32ll { unsigned long long v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_C_BFu33 { unsigned long long v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_C_BFu7c { unsigned long long v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_C_BFu7i { unsigned long long v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_C_BFu7ll { unsigned long long v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_C_BFu7s { unsigned long long v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_C_BFu8c { unsigned long long v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_C_BFu8i { unsigned long long v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_C_BFu8ll { unsigned long long v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_C_BFu8s { unsigned long long v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_C_BFu9i { unsigned long long v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_C_BFu9ll { unsigned long long v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_C_BFu9s { unsigned long long v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_C_C { unsigned long long v1; char v2; char v3; };
struct __attribute__((packed)) aUl_C_D { unsigned long long v1; char v2; double v3; };
struct __attribute__((packed)) aUl_C_F { unsigned long long v1; char v2; float v3; };
struct __attribute__((packed)) aUl_C_I { unsigned long long v1; char v2; int v3; };
struct __attribute__((packed)) aUl_C_Ip { unsigned long long v1; char v2; int * v3; };
struct __attribute__((packed)) aUl_C_L { unsigned long long v1; char v2; long long v3; };
struct __attribute__((packed)) aUl_C_S { unsigned long long v1; char v2; short v3; };
struct __attribute__((packed)) aUl_C_Uc { unsigned long long v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aUl_C_Ui { unsigned long long v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aUl_C_Ul { unsigned long long v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_C_Us { unsigned long long v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aUl_C_Vp { unsigned long long v1; char v2; void * v3; };
struct __attribute__((packed)) aUl_D { unsigned long long v1; double v2; };
struct __attribute__((packed)) aUl_D_BFu15i { unsigned long long v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_D_BFu15ll { unsigned long long v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_D_BFu15s { unsigned long long v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_D_BFu16i { unsigned long long v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_D_BFu16ll { unsigned long long v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_D_BFu16s { unsigned long long v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_D_BFu17i { unsigned long long v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_D_BFu17ll { unsigned long long v1; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_D_BFu1c { unsigned long long v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_D_BFu1i { unsigned long long v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_D_BFu1ll { unsigned long long v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_D_BFu1s { unsigned long long v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_D_BFu31i { unsigned long long v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_D_BFu31ll { unsigned long long v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_D_BFu32i { unsigned long long v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_D_BFu32ll { unsigned long long v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_D_BFu33 { unsigned long long v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_D_BFu7c { unsigned long long v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_D_BFu7i { unsigned long long v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_D_BFu7ll { unsigned long long v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_D_BFu7s { unsigned long long v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_D_BFu8c { unsigned long long v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_D_BFu8i { unsigned long long v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_D_BFu8ll { unsigned long long v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_D_BFu8s { unsigned long long v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_D_BFu9i { unsigned long long v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_D_BFu9ll { unsigned long long v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_D_BFu9s { unsigned long long v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_D_C { unsigned long long v1; double v2; char v3; };
struct __attribute__((packed)) aUl_D_D { unsigned long long v1; double v2; double v3; };
struct __attribute__((packed)) aUl_D_F { unsigned long long v1; double v2; float v3; };
struct __attribute__((packed)) aUl_D_I { unsigned long long v1; double v2; int v3; };
struct __attribute__((packed)) aUl_D_Ip { unsigned long long v1; double v2; int * v3; };
struct __attribute__((packed)) aUl_D_L { unsigned long long v1; double v2; long long v3; };
struct __attribute__((packed)) aUl_D_S { unsigned long long v1; double v2; short v3; };
struct __attribute__((packed)) aUl_D_Uc { unsigned long long v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aUl_D_Ui { unsigned long long v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aUl_D_Ul { unsigned long long v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_D_Us { unsigned long long v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aUl_D_Vp { unsigned long long v1; double v2; void * v3; };
struct __attribute__((packed)) aUl_F { unsigned long long v1; float v2; };
struct __attribute__((packed)) aUl_F_BFu15i { unsigned long long v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_F_BFu15ll { unsigned long long v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_F_BFu15s { unsigned long long v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_F_BFu16i { unsigned long long v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_F_BFu16ll { unsigned long long v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_F_BFu16s { unsigned long long v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_F_BFu17i { unsigned long long v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_F_BFu17ll { unsigned long long v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_F_BFu1c { unsigned long long v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_F_BFu1i { unsigned long long v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_F_BFu1ll { unsigned long long v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_F_BFu1s { unsigned long long v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_F_BFu31i { unsigned long long v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_F_BFu31ll { unsigned long long v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_F_BFu32i { unsigned long long v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_F_BFu32ll { unsigned long long v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_F_BFu33 { unsigned long long v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_F_BFu7c { unsigned long long v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_F_BFu7i { unsigned long long v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_F_BFu7ll { unsigned long long v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_F_BFu7s { unsigned long long v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_F_BFu8c { unsigned long long v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_F_BFu8i { unsigned long long v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_F_BFu8ll { unsigned long long v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_F_BFu8s { unsigned long long v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_F_BFu9i { unsigned long long v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_F_BFu9ll { unsigned long long v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_F_BFu9s { unsigned long long v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_F_C { unsigned long long v1; float v2; char v3; };
struct __attribute__((packed)) aUl_F_D { unsigned long long v1; float v2; double v3; };
struct __attribute__((packed)) aUl_F_F { unsigned long long v1; float v2; float v3; };
struct __attribute__((packed)) aUl_F_I { unsigned long long v1; float v2; int v3; };
struct __attribute__((packed)) aUl_F_Ip { unsigned long long v1; float v2; int * v3; };
struct __attribute__((packed)) aUl_F_L { unsigned long long v1; float v2; long long v3; };
struct __attribute__((packed)) aUl_F_S { unsigned long long v1; float v2; short v3; };
struct __attribute__((packed)) aUl_F_Uc { unsigned long long v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aUl_F_Ui { unsigned long long v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aUl_F_Ul { unsigned long long v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_F_Us { unsigned long long v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aUl_F_Vp { unsigned long long v1; float v2; void * v3; };
struct __attribute__((packed)) aUl_I { unsigned long long v1; int v2; };
struct __attribute__((packed)) aUl_I_BFu15i { unsigned long long v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_I_BFu15ll { unsigned long long v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_I_BFu15s { unsigned long long v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_I_BFu16i { unsigned long long v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_I_BFu16ll { unsigned long long v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_I_BFu16s { unsigned long long v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_I_BFu17i { unsigned long long v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_I_BFu17ll { unsigned long long v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_I_BFu1c { unsigned long long v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_I_BFu1i { unsigned long long v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_I_BFu1ll { unsigned long long v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_I_BFu1s { unsigned long long v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_I_BFu31i { unsigned long long v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_I_BFu31ll { unsigned long long v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_I_BFu32i { unsigned long long v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_I_BFu32ll { unsigned long long v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_I_BFu33 { unsigned long long v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_I_BFu7c { unsigned long long v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_I_BFu7i { unsigned long long v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_I_BFu7ll { unsigned long long v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_I_BFu7s { unsigned long long v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_I_BFu8c { unsigned long long v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_I_BFu8i { unsigned long long v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_I_BFu8ll { unsigned long long v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_I_BFu8s { unsigned long long v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_I_BFu9i { unsigned long long v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_I_BFu9ll { unsigned long long v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_I_BFu9s { unsigned long long v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_I_C { unsigned long long v1; int v2; char v3; };
struct __attribute__((packed)) aUl_I_D { unsigned long long v1; int v2; double v3; };
struct __attribute__((packed)) aUl_I_F { unsigned long long v1; int v2; float v3; };
struct __attribute__((packed)) aUl_I_I { unsigned long long v1; int v2; int v3; };
struct __attribute__((packed)) aUl_I_Ip { unsigned long long v1; int v2; int * v3; };
struct __attribute__((packed)) aUl_I_L { unsigned long long v1; int v2; long long v3; };
struct __attribute__((packed)) aUl_I_S { unsigned long long v1; int v2; short v3; };
struct __attribute__((packed)) aUl_I_Uc { unsigned long long v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aUl_I_Ui { unsigned long long v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aUl_I_Ul { unsigned long long v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_I_Us { unsigned long long v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aUl_I_Vp { unsigned long long v1; int v2; void * v3; };
struct __attribute__((packed)) aUl_Ip { unsigned long long v1; int * v2; };
struct __attribute__((packed)) aUl_Ip_BFu15i { unsigned long long v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_Ip_BFu15ll { unsigned long long v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_Ip_BFu15s { unsigned long long v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_Ip_BFu16i { unsigned long long v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_Ip_BFu16ll { unsigned long long v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_Ip_BFu16s { unsigned long long v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_Ip_BFu17i { unsigned long long v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_Ip_BFu17ll { unsigned long long v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_Ip_BFu1c { unsigned long long v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_Ip_BFu1i { unsigned long long v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_Ip_BFu1ll { unsigned long long v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_Ip_BFu1s { unsigned long long v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_Ip_BFu31i { unsigned long long v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_Ip_BFu31ll { unsigned long long v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_Ip_BFu32i { unsigned long long v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_Ip_BFu32ll { unsigned long long v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_Ip_BFu33 { unsigned long long v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_Ip_BFu7c { unsigned long long v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_Ip_BFu7i { unsigned long long v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_Ip_BFu7ll { unsigned long long v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_Ip_BFu7s { unsigned long long v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_Ip_BFu8c { unsigned long long v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_Ip_BFu8i { unsigned long long v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_Ip_BFu8ll { unsigned long long v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_Ip_BFu8s { unsigned long long v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_Ip_BFu9i { unsigned long long v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_Ip_BFu9ll { unsigned long long v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_Ip_BFu9s { unsigned long long v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_Ip_C { unsigned long long v1; int * v2; char v3; };
struct __attribute__((packed)) aUl_Ip_D { unsigned long long v1; int * v2; double v3; };
struct __attribute__((packed)) aUl_Ip_F { unsigned long long v1; int * v2; float v3; };
struct __attribute__((packed)) aUl_Ip_I { unsigned long long v1; int * v2; int v3; };
struct __attribute__((packed)) aUl_Ip_Ip { unsigned long long v1; int * v2; int * v3; };
struct __attribute__((packed)) aUl_Ip_L { unsigned long long v1; int * v2; long long v3; };
struct __attribute__((packed)) aUl_Ip_S { unsigned long long v1; int * v2; short v3; };
struct __attribute__((packed)) aUl_Ip_Uc { unsigned long long v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aUl_Ip_Ui { unsigned long long v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aUl_Ip_Ul { unsigned long long v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_Ip_Us { unsigned long long v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aUl_Ip_Vp { unsigned long long v1; int * v2; void * v3; };
struct __attribute__((packed)) aUl_L { unsigned long long v1; long long v2; };
struct __attribute__((packed)) aUl_L_BFu15i { unsigned long long v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_L_BFu15ll { unsigned long long v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_L_BFu15s { unsigned long long v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_L_BFu16i { unsigned long long v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_L_BFu16ll { unsigned long long v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_L_BFu16s { unsigned long long v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_L_BFu17i { unsigned long long v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_L_BFu17ll { unsigned long long v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_L_BFu1c { unsigned long long v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_L_BFu1i { unsigned long long v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_L_BFu1ll { unsigned long long v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_L_BFu1s { unsigned long long v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_L_BFu31i { unsigned long long v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_L_BFu31ll { unsigned long long v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_L_BFu32i { unsigned long long v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_L_BFu32ll { unsigned long long v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_L_BFu33 { unsigned long long v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_L_BFu7c { unsigned long long v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_L_BFu7i { unsigned long long v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_L_BFu7ll { unsigned long long v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_L_BFu7s { unsigned long long v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_L_BFu8c { unsigned long long v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_L_BFu8i { unsigned long long v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_L_BFu8ll { unsigned long long v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_L_BFu8s { unsigned long long v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_L_BFu9i { unsigned long long v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_L_BFu9ll { unsigned long long v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_L_BFu9s { unsigned long long v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_L_C { unsigned long long v1; long long v2; char v3; };
struct __attribute__((packed)) aUl_L_D { unsigned long long v1; long long v2; double v3; };
struct __attribute__((packed)) aUl_L_F { unsigned long long v1; long long v2; float v3; };
struct __attribute__((packed)) aUl_L_I { unsigned long long v1; long long v2; int v3; };
struct __attribute__((packed)) aUl_L_Ip { unsigned long long v1; long long v2; int * v3; };
struct __attribute__((packed)) aUl_L_L { unsigned long long v1; long long v2; long long v3; };
struct __attribute__((packed)) aUl_L_S { unsigned long long v1; long long v2; short v3; };
struct __attribute__((packed)) aUl_L_Uc { unsigned long long v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aUl_L_Ui { unsigned long long v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aUl_L_Ul { unsigned long long v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_L_Us { unsigned long long v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aUl_L_Vp { unsigned long long v1; long long v2; void * v3; };
struct __attribute__((packed)) aUl_S { unsigned long long v1; short v2; };
struct __attribute__((packed)) aUl_S_BFu15i { unsigned long long v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_S_BFu15ll { unsigned long long v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_S_BFu15s { unsigned long long v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_S_BFu16i { unsigned long long v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_S_BFu16ll { unsigned long long v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_S_BFu16s { unsigned long long v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_S_BFu17i { unsigned long long v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_S_BFu17ll { unsigned long long v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_S_BFu1c { unsigned long long v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_S_BFu1i { unsigned long long v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_S_BFu1ll { unsigned long long v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_S_BFu1s { unsigned long long v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_S_BFu31i { unsigned long long v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_S_BFu31ll { unsigned long long v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_S_BFu32i { unsigned long long v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_S_BFu32ll { unsigned long long v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_S_BFu33 { unsigned long long v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_S_BFu7c { unsigned long long v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_S_BFu7i { unsigned long long v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_S_BFu7ll { unsigned long long v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_S_BFu7s { unsigned long long v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_S_BFu8c { unsigned long long v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_S_BFu8i { unsigned long long v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_S_BFu8ll { unsigned long long v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_S_BFu8s { unsigned long long v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_S_BFu9i { unsigned long long v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_S_BFu9ll { unsigned long long v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_S_BFu9s { unsigned long long v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_S_C { unsigned long long v1; short v2; char v3; };
struct __attribute__((packed)) aUl_S_D { unsigned long long v1; short v2; double v3; };
struct __attribute__((packed)) aUl_S_F { unsigned long long v1; short v2; float v3; };
struct __attribute__((packed)) aUl_S_I { unsigned long long v1; short v2; int v3; };
struct __attribute__((packed)) aUl_S_Ip { unsigned long long v1; short v2; int * v3; };
struct __attribute__((packed)) aUl_S_L { unsigned long long v1; short v2; long long v3; };
struct __attribute__((packed)) aUl_S_S { unsigned long long v1; short v2; short v3; };
struct __attribute__((packed)) aUl_S_Uc { unsigned long long v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aUl_S_Ui { unsigned long long v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aUl_S_Ul { unsigned long long v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_S_Us { unsigned long long v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aUl_S_Vp { unsigned long long v1; short v2; void * v3; };
struct __attribute__((packed)) aUl_Uc { unsigned long long v1; unsigned char v2; };
struct __attribute__((packed)) aUl_Uc_BFu15i { unsigned long long v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_Uc_BFu15ll { unsigned long long v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_Uc_BFu15s { unsigned long long v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_Uc_BFu16i { unsigned long long v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_Uc_BFu16ll { unsigned long long v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_Uc_BFu16s { unsigned long long v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_Uc_BFu17i { unsigned long long v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_Uc_BFu17ll { unsigned long long v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_Uc_BFu1c { unsigned long long v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_Uc_BFu1i { unsigned long long v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_Uc_BFu1ll { unsigned long long v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_Uc_BFu1s { unsigned long long v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_Uc_BFu31i { unsigned long long v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_Uc_BFu31ll { unsigned long long v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_Uc_BFu32i { unsigned long long v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_Uc_BFu32ll { unsigned long long v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_Uc_BFu33 { unsigned long long v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_Uc_BFu7c { unsigned long long v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_Uc_BFu7i { unsigned long long v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_Uc_BFu7ll { unsigned long long v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_Uc_BFu7s { unsigned long long v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_Uc_BFu8c { unsigned long long v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_Uc_BFu8i { unsigned long long v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_Uc_BFu8ll { unsigned long long v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_Uc_BFu8s { unsigned long long v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_Uc_BFu9i { unsigned long long v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_Uc_BFu9ll { unsigned long long v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_Uc_BFu9s { unsigned long long v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_Uc_C { unsigned long long v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aUl_Uc_D { unsigned long long v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aUl_Uc_F { unsigned long long v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aUl_Uc_I { unsigned long long v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aUl_Uc_Ip { unsigned long long v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aUl_Uc_L { unsigned long long v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aUl_Uc_S { unsigned long long v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aUl_Uc_Uc { unsigned long long v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aUl_Uc_Ui { unsigned long long v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aUl_Uc_Ul { unsigned long long v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_Uc_Us { unsigned long long v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aUl_Uc_Vp { unsigned long long v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aUl_Ui { unsigned long long v1; unsigned int v2; };
struct __attribute__((packed)) aUl_Ui_BFu15i { unsigned long long v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_Ui_BFu15ll { unsigned long long v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_Ui_BFu15s { unsigned long long v1; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_Ui_BFu16i { unsigned long long v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_Ui_BFu16ll { unsigned long long v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_Ui_BFu16s { unsigned long long v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_Ui_BFu17i { unsigned long long v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_Ui_BFu17ll { unsigned long long v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_Ui_BFu1c { unsigned long long v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_Ui_BFu1i { unsigned long long v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_Ui_BFu1ll { unsigned long long v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_Ui_BFu1s { unsigned long long v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_Ui_BFu31i { unsigned long long v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_Ui_BFu31ll { unsigned long long v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_Ui_BFu32i { unsigned long long v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_Ui_BFu32ll { unsigned long long v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_Ui_BFu33 { unsigned long long v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_Ui_BFu7c { unsigned long long v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_Ui_BFu7i { unsigned long long v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_Ui_BFu7ll { unsigned long long v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_Ui_BFu7s { unsigned long long v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_Ui_BFu8c { unsigned long long v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_Ui_BFu8i { unsigned long long v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_Ui_BFu8ll { unsigned long long v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_Ui_BFu8s { unsigned long long v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_Ui_BFu9i { unsigned long long v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_Ui_BFu9ll { unsigned long long v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_Ui_BFu9s { unsigned long long v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_Ui_C { unsigned long long v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aUl_Ui_D { unsigned long long v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aUl_Ui_F { unsigned long long v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aUl_Ui_I { unsigned long long v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aUl_Ui_Ip { unsigned long long v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aUl_Ui_L { unsigned long long v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aUl_Ui_S { unsigned long long v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aUl_Ui_Uc { unsigned long long v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aUl_Ui_Ui { unsigned long long v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aUl_Ui_Ul { unsigned long long v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_Ui_Us { unsigned long long v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aUl_Ui_Vp { unsigned long long v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aUl_Ul { unsigned long long v1; unsigned long long v2; };
struct __attribute__((packed)) aUl_Ul_BFu15i { unsigned long long v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_Ul_BFu15ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_Ul_BFu15s { unsigned long long v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_Ul_BFu16i { unsigned long long v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_Ul_BFu16ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_Ul_BFu16s { unsigned long long v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_Ul_BFu17i { unsigned long long v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_Ul_BFu17ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_Ul_BFu1c { unsigned long long v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_Ul_BFu1i { unsigned long long v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_Ul_BFu1ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_Ul_BFu1s { unsigned long long v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_Ul_BFu31i { unsigned long long v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_Ul_BFu31ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_Ul_BFu32i { unsigned long long v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_Ul_BFu32ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_Ul_BFu33 { unsigned long long v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_Ul_BFu7c { unsigned long long v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_Ul_BFu7i { unsigned long long v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_Ul_BFu7ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_Ul_BFu7s { unsigned long long v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_Ul_BFu8c { unsigned long long v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_Ul_BFu8i { unsigned long long v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_Ul_BFu8ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_Ul_BFu8s { unsigned long long v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_Ul_BFu9i { unsigned long long v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_Ul_BFu9ll { unsigned long long v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_Ul_BFu9s { unsigned long long v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_Ul_C { unsigned long long v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aUl_Ul_D { unsigned long long v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aUl_Ul_F { unsigned long long v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aUl_Ul_I { unsigned long long v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aUl_Ul_Ip { unsigned long long v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aUl_Ul_L { unsigned long long v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aUl_Ul_S { unsigned long long v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aUl_Ul_Uc { unsigned long long v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aUl_Ul_Ui { unsigned long long v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aUl_Ul_Ul { unsigned long long v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_Ul_Us { unsigned long long v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aUl_Ul_Vp { unsigned long long v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aUl_Us { unsigned long long v1; unsigned short v2; };
struct __attribute__((packed)) aUl_Us_BFu15i { unsigned long long v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_Us_BFu15ll { unsigned long long v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_Us_BFu15s { unsigned long long v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_Us_BFu16i { unsigned long long v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_Us_BFu16ll { unsigned long long v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_Us_BFu16s { unsigned long long v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_Us_BFu17i { unsigned long long v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_Us_BFu17ll { unsigned long long v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_Us_BFu1c { unsigned long long v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_Us_BFu1i { unsigned long long v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_Us_BFu1ll { unsigned long long v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_Us_BFu1s { unsigned long long v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_Us_BFu31i { unsigned long long v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_Us_BFu31ll { unsigned long long v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_Us_BFu32i { unsigned long long v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_Us_BFu32ll { unsigned long long v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_Us_BFu33 { unsigned long long v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_Us_BFu7c { unsigned long long v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_Us_BFu7i { unsigned long long v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_Us_BFu7ll { unsigned long long v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_Us_BFu7s { unsigned long long v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_Us_BFu8c { unsigned long long v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_Us_BFu8i { unsigned long long v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_Us_BFu8ll { unsigned long long v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_Us_BFu8s { unsigned long long v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_Us_BFu9i { unsigned long long v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_Us_BFu9ll { unsigned long long v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_Us_BFu9s { unsigned long long v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_Us_C { unsigned long long v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aUl_Us_D { unsigned long long v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aUl_Us_F { unsigned long long v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aUl_Us_I { unsigned long long v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aUl_Us_Ip { unsigned long long v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aUl_Us_L { unsigned long long v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aUl_Us_S { unsigned long long v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aUl_Us_Uc { unsigned long long v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aUl_Us_Ui { unsigned long long v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aUl_Us_Ul { unsigned long long v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_Us_Us { unsigned long long v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aUl_Us_Vp { unsigned long long v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aUl_Vp { unsigned long long v1; void * v2; };
struct __attribute__((packed)) aUl_Vp_BFu15i { unsigned long long v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aUl_Vp_BFu15ll { unsigned long long v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_Vp_BFu15s { unsigned long long v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aUl_Vp_BFu16i { unsigned long long v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aUl_Vp_BFu16ll { unsigned long long v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_Vp_BFu16s { unsigned long long v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aUl_Vp_BFu17i { unsigned long long v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aUl_Vp_BFu17ll { unsigned long long v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_Vp_BFu1c { unsigned long long v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aUl_Vp_BFu1i { unsigned long long v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aUl_Vp_BFu1ll { unsigned long long v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_Vp_BFu1s { unsigned long long v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aUl_Vp_BFu31i { unsigned long long v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aUl_Vp_BFu31ll { unsigned long long v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_Vp_BFu32i { unsigned long long v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aUl_Vp_BFu32ll { unsigned long long v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_Vp_BFu33 { unsigned long long v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_Vp_BFu7c { unsigned long long v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aUl_Vp_BFu7i { unsigned long long v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aUl_Vp_BFu7ll { unsigned long long v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_Vp_BFu7s { unsigned long long v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aUl_Vp_BFu8c { unsigned long long v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aUl_Vp_BFu8i { unsigned long long v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aUl_Vp_BFu8ll { unsigned long long v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_Vp_BFu8s { unsigned long long v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aUl_Vp_BFu9i { unsigned long long v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aUl_Vp_BFu9ll { unsigned long long v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_Vp_BFu9s { unsigned long long v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aUl_Vp_C { unsigned long long v1; void * v2; char v3; };
struct __attribute__((packed)) aUl_Vp_D { unsigned long long v1; void * v2; double v3; };
struct __attribute__((packed)) aUl_Vp_F { unsigned long long v1; void * v2; float v3; };
struct __attribute__((packed)) aUl_Vp_I { unsigned long long v1; void * v2; int v3; };
struct __attribute__((packed)) aUl_Vp_Ip { unsigned long long v1; void * v2; int * v3; };
struct __attribute__((packed)) aUl_Vp_L { unsigned long long v1; void * v2; long long v3; };
struct __attribute__((packed)) aUl_Vp_S { unsigned long long v1; void * v2; short v3; };
struct __attribute__((packed)) aUl_Vp_Uc { unsigned long long v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aUl_Vp_Ui { unsigned long long v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aUl_Vp_Ul { unsigned long long v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aUl_Vp_Us { unsigned long long v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aUl_Vp_Vp { unsigned long long v1; void * v2; void * v3; };
struct __attribute__((packed)) aUs { unsigned short v1; };
struct __attribute__((packed)) aUs_BFu15i { unsigned short v1; unsigned int v2:15; };
struct __attribute__((packed)) aUs_BFu15i_BFu15i { unsigned short v1; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu15i_BFu15ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu15i_BFu15s { unsigned short v1; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu15i_BFu16i { unsigned short v1; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu15i_BFu16ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu15i_BFu16s { unsigned short v1; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu15i_BFu17i { unsigned short v1; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu15i_BFu17ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu15i_BFu1c { unsigned short v1; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu15i_BFu1i { unsigned short v1; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu15i_BFu1ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu15i_BFu1s { unsigned short v1; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu15i_BFu31i { unsigned short v1; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu15i_BFu31ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu15i_BFu32i { unsigned short v1; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu15i_BFu32ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu15i_BFu33 { unsigned short v1; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu15i_BFu7c { unsigned short v1; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu15i_BFu7i { unsigned short v1; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu15i_BFu7ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu15i_BFu7s { unsigned short v1; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu15i_BFu8c { unsigned short v1; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu15i_BFu8i { unsigned short v1; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu15i_BFu8ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu15i_BFu8s { unsigned short v1; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu15i_BFu9i { unsigned short v1; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu15i_BFu9ll { unsigned short v1; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu15i_BFu9s { unsigned short v1; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu15i_C { unsigned short v1; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aUs_BFu15i_D { unsigned short v1; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aUs_BFu15i_F { unsigned short v1; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aUs_BFu15i_I { unsigned short v1; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aUs_BFu15i_Ip { unsigned short v1; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aUs_BFu15i_L { unsigned short v1; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aUs_BFu15i_S { unsigned short v1; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aUs_BFu15i_Uc { unsigned short v1; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu15i_Ui { unsigned short v1; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu15i_Ul { unsigned short v1; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu15i_Us { unsigned short v1; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu15i_Vp { unsigned short v1; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aUs_BFu15ll { unsigned short v1; unsigned long long v2:15; };
struct __attribute__((packed)) aUs_BFu15ll_BFu15i { unsigned short v1; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu15ll_BFu15ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu15ll_BFu15s { unsigned short v1; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu15ll_BFu16i { unsigned short v1; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu15ll_BFu16ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu15ll_BFu16s { unsigned short v1; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu15ll_BFu17i { unsigned short v1; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu15ll_BFu17ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu15ll_BFu1c { unsigned short v1; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu15ll_BFu1i { unsigned short v1; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu15ll_BFu1ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu15ll_BFu1s { unsigned short v1; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu15ll_BFu31i { unsigned short v1; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu15ll_BFu31ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu15ll_BFu32i { unsigned short v1; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu15ll_BFu32ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu15ll_BFu33 { unsigned short v1; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu15ll_BFu7c { unsigned short v1; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu15ll_BFu7i { unsigned short v1; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu15ll_BFu7ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu15ll_BFu7s { unsigned short v1; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu15ll_BFu8c { unsigned short v1; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu15ll_BFu8i { unsigned short v1; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu15ll_BFu8ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu15ll_BFu8s { unsigned short v1; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu15ll_BFu9i { unsigned short v1; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu15ll_BFu9ll { unsigned short v1; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu15ll_BFu9s { unsigned short v1; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu15ll_C { unsigned short v1; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aUs_BFu15ll_D { unsigned short v1; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aUs_BFu15ll_F { unsigned short v1; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aUs_BFu15ll_I { unsigned short v1; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aUs_BFu15ll_Ip { unsigned short v1; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aUs_BFu15ll_L { unsigned short v1; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aUs_BFu15ll_S { unsigned short v1; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aUs_BFu15ll_Uc { unsigned short v1; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu15ll_Ui { unsigned short v1; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu15ll_Ul { unsigned short v1; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu15ll_Us { unsigned short v1; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu15ll_Vp { unsigned short v1; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aUs_BFu15s { unsigned short v1; unsigned short v2:15; };
struct __attribute__((packed)) aUs_BFu15s_BFu15i { unsigned short v1; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu15s_BFu15ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu15s_BFu15s { unsigned short v1; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu15s_BFu16i { unsigned short v1; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu15s_BFu16ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu15s_BFu16s { unsigned short v1; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu15s_BFu17i { unsigned short v1; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu15s_BFu17ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu15s_BFu1c { unsigned short v1; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu15s_BFu1i { unsigned short v1; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu15s_BFu1ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu15s_BFu1s { unsigned short v1; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu15s_BFu31i { unsigned short v1; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu15s_BFu31ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu15s_BFu32i { unsigned short v1; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu15s_BFu32ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu15s_BFu33 { unsigned short v1; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu15s_BFu7c { unsigned short v1; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu15s_BFu7i { unsigned short v1; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu15s_BFu7ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu15s_BFu7s { unsigned short v1; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu15s_BFu8c { unsigned short v1; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu15s_BFu8i { unsigned short v1; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu15s_BFu8ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu15s_BFu8s { unsigned short v1; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu15s_BFu9i { unsigned short v1; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu15s_BFu9ll { unsigned short v1; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu15s_BFu9s { unsigned short v1; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu15s_C { unsigned short v1; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aUs_BFu15s_D { unsigned short v1; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aUs_BFu15s_F { unsigned short v1; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aUs_BFu15s_I { unsigned short v1; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aUs_BFu15s_Ip { unsigned short v1; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aUs_BFu15s_L { unsigned short v1; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aUs_BFu15s_S { unsigned short v1; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aUs_BFu15s_Uc { unsigned short v1; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu15s_Ui { unsigned short v1; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu15s_Ul { unsigned short v1; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu15s_Us { unsigned short v1; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu15s_Vp { unsigned short v1; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aUs_BFu16i { unsigned short v1; unsigned int v2:16; };
struct __attribute__((packed)) aUs_BFu16i_BFu15i { unsigned short v1; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu16i_BFu15ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu16i_BFu15s { unsigned short v1; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu16i_BFu16i { unsigned short v1; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu16i_BFu16ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu16i_BFu16s { unsigned short v1; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu16i_BFu17i { unsigned short v1; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu16i_BFu17ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu16i_BFu1c { unsigned short v1; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu16i_BFu1i { unsigned short v1; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu16i_BFu1ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu16i_BFu1s { unsigned short v1; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu16i_BFu31i { unsigned short v1; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu16i_BFu31ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu16i_BFu32i { unsigned short v1; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu16i_BFu32ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu16i_BFu33 { unsigned short v1; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu16i_BFu7c { unsigned short v1; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu16i_BFu7i { unsigned short v1; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu16i_BFu7ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu16i_BFu7s { unsigned short v1; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu16i_BFu8c { unsigned short v1; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu16i_BFu8i { unsigned short v1; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu16i_BFu8ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu16i_BFu8s { unsigned short v1; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu16i_BFu9i { unsigned short v1; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu16i_BFu9ll { unsigned short v1; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu16i_BFu9s { unsigned short v1; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu16i_C { unsigned short v1; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aUs_BFu16i_D { unsigned short v1; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aUs_BFu16i_F { unsigned short v1; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aUs_BFu16i_I { unsigned short v1; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aUs_BFu16i_Ip { unsigned short v1; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aUs_BFu16i_L { unsigned short v1; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aUs_BFu16i_S { unsigned short v1; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aUs_BFu16i_Uc { unsigned short v1; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu16i_Ui { unsigned short v1; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu16i_Ul { unsigned short v1; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu16i_Us { unsigned short v1; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu16i_Vp { unsigned short v1; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aUs_BFu16ll { unsigned short v1; unsigned long long v2:16; };
struct __attribute__((packed)) aUs_BFu16ll_BFu15i { unsigned short v1; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu16ll_BFu15ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu16ll_BFu15s { unsigned short v1; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu16ll_BFu16i { unsigned short v1; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu16ll_BFu16ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu16ll_BFu16s { unsigned short v1; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu16ll_BFu17i { unsigned short v1; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu16ll_BFu17ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu16ll_BFu1c { unsigned short v1; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu16ll_BFu1i { unsigned short v1; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu16ll_BFu1ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu16ll_BFu1s { unsigned short v1; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu16ll_BFu31i { unsigned short v1; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu16ll_BFu31ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu16ll_BFu32i { unsigned short v1; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu16ll_BFu32ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu16ll_BFu33 { unsigned short v1; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu16ll_BFu7c { unsigned short v1; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu16ll_BFu7i { unsigned short v1; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu16ll_BFu7ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu16ll_BFu7s { unsigned short v1; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu16ll_BFu8c { unsigned short v1; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu16ll_BFu8i { unsigned short v1; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu16ll_BFu8ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu16ll_BFu8s { unsigned short v1; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu16ll_BFu9i { unsigned short v1; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu16ll_BFu9ll { unsigned short v1; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu16ll_BFu9s { unsigned short v1; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu16ll_C { unsigned short v1; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aUs_BFu16ll_D { unsigned short v1; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aUs_BFu16ll_F { unsigned short v1; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aUs_BFu16ll_I { unsigned short v1; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aUs_BFu16ll_Ip { unsigned short v1; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aUs_BFu16ll_L { unsigned short v1; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aUs_BFu16ll_S { unsigned short v1; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aUs_BFu16ll_Uc { unsigned short v1; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu16ll_Ui { unsigned short v1; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu16ll_Ul { unsigned short v1; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu16ll_Us { unsigned short v1; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu16ll_Vp { unsigned short v1; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aUs_BFu16s { unsigned short v1; unsigned short v2:16; };
struct __attribute__((packed)) aUs_BFu16s_BFu15i { unsigned short v1; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu16s_BFu15ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu16s_BFu15s { unsigned short v1; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu16s_BFu16i { unsigned short v1; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu16s_BFu16ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu16s_BFu16s { unsigned short v1; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu16s_BFu17i { unsigned short v1; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu16s_BFu17ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu16s_BFu1c { unsigned short v1; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu16s_BFu1i { unsigned short v1; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu16s_BFu1ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu16s_BFu1s { unsigned short v1; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu16s_BFu31i { unsigned short v1; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu16s_BFu31ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu16s_BFu32i { unsigned short v1; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu16s_BFu32ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu16s_BFu33 { unsigned short v1; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu16s_BFu7c { unsigned short v1; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu16s_BFu7i { unsigned short v1; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu16s_BFu7ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu16s_BFu7s { unsigned short v1; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu16s_BFu8c { unsigned short v1; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu16s_BFu8i { unsigned short v1; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu16s_BFu8ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu16s_BFu8s { unsigned short v1; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu16s_BFu9i { unsigned short v1; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu16s_BFu9ll { unsigned short v1; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu16s_BFu9s { unsigned short v1; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu16s_C { unsigned short v1; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aUs_BFu16s_D { unsigned short v1; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aUs_BFu16s_F { unsigned short v1; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aUs_BFu16s_I { unsigned short v1; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aUs_BFu16s_Ip { unsigned short v1; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aUs_BFu16s_L { unsigned short v1; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aUs_BFu16s_S { unsigned short v1; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aUs_BFu16s_Uc { unsigned short v1; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu16s_Ui { unsigned short v1; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu16s_Ul { unsigned short v1; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu16s_Us { unsigned short v1; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu16s_Vp { unsigned short v1; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aUs_BFu17i { unsigned short v1; unsigned int v2:17; };
struct __attribute__((packed)) aUs_BFu17i_BFu15i { unsigned short v1; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu17i_BFu15ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu17i_BFu15s { unsigned short v1; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu17i_BFu16i { unsigned short v1; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu17i_BFu16ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu17i_BFu16s { unsigned short v1; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu17i_BFu17i { unsigned short v1; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu17i_BFu17ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu17i_BFu1c { unsigned short v1; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu17i_BFu1i { unsigned short v1; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu17i_BFu1ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu17i_BFu1s { unsigned short v1; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu17i_BFu31i { unsigned short v1; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu17i_BFu31ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu17i_BFu32i { unsigned short v1; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu17i_BFu32ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu17i_BFu33 { unsigned short v1; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu17i_BFu7c { unsigned short v1; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu17i_BFu7i { unsigned short v1; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu17i_BFu7ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu17i_BFu7s { unsigned short v1; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu17i_BFu8c { unsigned short v1; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu17i_BFu8i { unsigned short v1; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu17i_BFu8ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu17i_BFu8s { unsigned short v1; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu17i_BFu9i { unsigned short v1; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu17i_BFu9ll { unsigned short v1; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu17i_BFu9s { unsigned short v1; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu17i_C { unsigned short v1; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aUs_BFu17i_D { unsigned short v1; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aUs_BFu17i_F { unsigned short v1; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aUs_BFu17i_I { unsigned short v1; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aUs_BFu17i_Ip { unsigned short v1; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aUs_BFu17i_L { unsigned short v1; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aUs_BFu17i_S { unsigned short v1; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aUs_BFu17i_Uc { unsigned short v1; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu17i_Ui { unsigned short v1; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu17i_Ul { unsigned short v1; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu17i_Us { unsigned short v1; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu17i_Vp { unsigned short v1; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aUs_BFu17ll { unsigned short v1; unsigned long long v2:17; };
struct __attribute__((packed)) aUs_BFu17ll_BFu15i { unsigned short v1; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu17ll_BFu15ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu17ll_BFu15s { unsigned short v1; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu17ll_BFu16i { unsigned short v1; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu17ll_BFu16ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu17ll_BFu16s { unsigned short v1; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu17ll_BFu17i { unsigned short v1; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu17ll_BFu17ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu17ll_BFu1c { unsigned short v1; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu17ll_BFu1i { unsigned short v1; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu17ll_BFu1ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu17ll_BFu1s { unsigned short v1; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu17ll_BFu31i { unsigned short v1; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu17ll_BFu31ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu17ll_BFu32i { unsigned short v1; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu17ll_BFu32ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu17ll_BFu33 { unsigned short v1; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu17ll_BFu7c { unsigned short v1; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu17ll_BFu7i { unsigned short v1; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu17ll_BFu7ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu17ll_BFu7s { unsigned short v1; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu17ll_BFu8c { unsigned short v1; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu17ll_BFu8i { unsigned short v1; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu17ll_BFu8ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu17ll_BFu8s { unsigned short v1; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu17ll_BFu9i { unsigned short v1; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu17ll_BFu9ll { unsigned short v1; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu17ll_BFu9s { unsigned short v1; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu17ll_C { unsigned short v1; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aUs_BFu17ll_D { unsigned short v1; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aUs_BFu17ll_F { unsigned short v1; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aUs_BFu17ll_I { unsigned short v1; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aUs_BFu17ll_Ip { unsigned short v1; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aUs_BFu17ll_L { unsigned short v1; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aUs_BFu17ll_S { unsigned short v1; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aUs_BFu17ll_Uc { unsigned short v1; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu17ll_Ui { unsigned short v1; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu17ll_Ul { unsigned short v1; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu17ll_Us { unsigned short v1; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu17ll_Vp { unsigned short v1; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aUs_BFu1c { unsigned short v1; unsigned char v2:1; };
struct __attribute__((packed)) aUs_BFu1c_BFu15i { unsigned short v1; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu1c_BFu15ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu1c_BFu15s { unsigned short v1; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu1c_BFu16i { unsigned short v1; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu1c_BFu16ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu1c_BFu16s { unsigned short v1; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu1c_BFu17i { unsigned short v1; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu1c_BFu17ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu1c_BFu1c { unsigned short v1; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu1c_BFu1i { unsigned short v1; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu1c_BFu1ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu1c_BFu1s { unsigned short v1; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu1c_BFu31i { unsigned short v1; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu1c_BFu31ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu1c_BFu32i { unsigned short v1; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu1c_BFu32ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu1c_BFu33 { unsigned short v1; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu1c_BFu7c { unsigned short v1; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu1c_BFu7i { unsigned short v1; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu1c_BFu7ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu1c_BFu7s { unsigned short v1; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu1c_BFu8c { unsigned short v1; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu1c_BFu8i { unsigned short v1; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu1c_BFu8ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu1c_BFu8s { unsigned short v1; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu1c_BFu9i { unsigned short v1; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu1c_BFu9ll { unsigned short v1; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu1c_BFu9s { unsigned short v1; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu1c_C { unsigned short v1; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aUs_BFu1c_D { unsigned short v1; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aUs_BFu1c_F { unsigned short v1; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aUs_BFu1c_I { unsigned short v1; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aUs_BFu1c_Ip { unsigned short v1; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aUs_BFu1c_L { unsigned short v1; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aUs_BFu1c_S { unsigned short v1; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aUs_BFu1c_Uc { unsigned short v1; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu1c_Ui { unsigned short v1; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu1c_Ul { unsigned short v1; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu1c_Us { unsigned short v1; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu1c_Vp { unsigned short v1; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aUs_BFu1i { unsigned short v1; unsigned int v2:1; };
struct __attribute__((packed)) aUs_BFu1i_BFu15i { unsigned short v1; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu1i_BFu15ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu1i_BFu15s { unsigned short v1; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu1i_BFu16i { unsigned short v1; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu1i_BFu16ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu1i_BFu16s { unsigned short v1; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu1i_BFu17i { unsigned short v1; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu1i_BFu17ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu1i_BFu1c { unsigned short v1; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu1i_BFu1i { unsigned short v1; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu1i_BFu1ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu1i_BFu1s { unsigned short v1; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu1i_BFu31i { unsigned short v1; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu1i_BFu31ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu1i_BFu32i { unsigned short v1; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu1i_BFu32ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu1i_BFu33 { unsigned short v1; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu1i_BFu7c { unsigned short v1; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu1i_BFu7i { unsigned short v1; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu1i_BFu7ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu1i_BFu7s { unsigned short v1; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu1i_BFu8c { unsigned short v1; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu1i_BFu8i { unsigned short v1; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu1i_BFu8ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu1i_BFu8s { unsigned short v1; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu1i_BFu9i { unsigned short v1; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu1i_BFu9ll { unsigned short v1; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu1i_BFu9s { unsigned short v1; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu1i_C { unsigned short v1; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aUs_BFu1i_D { unsigned short v1; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aUs_BFu1i_F { unsigned short v1; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aUs_BFu1i_I { unsigned short v1; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aUs_BFu1i_Ip { unsigned short v1; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aUs_BFu1i_L { unsigned short v1; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aUs_BFu1i_S { unsigned short v1; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aUs_BFu1i_Uc { unsigned short v1; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu1i_Ui { unsigned short v1; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu1i_Ul { unsigned short v1; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu1i_Us { unsigned short v1; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu1i_Vp { unsigned short v1; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aUs_BFu1ll { unsigned short v1; unsigned long long v2:1; };
struct __attribute__((packed)) aUs_BFu1ll_BFu15i { unsigned short v1; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu1ll_BFu15ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu1ll_BFu15s { unsigned short v1; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu1ll_BFu16i { unsigned short v1; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu1ll_BFu16ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu1ll_BFu16s { unsigned short v1; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu1ll_BFu17i { unsigned short v1; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu1ll_BFu17ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu1ll_BFu1c { unsigned short v1; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu1ll_BFu1i { unsigned short v1; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu1ll_BFu1ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu1ll_BFu1s { unsigned short v1; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu1ll_BFu31i { unsigned short v1; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu1ll_BFu31ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu1ll_BFu32i { unsigned short v1; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu1ll_BFu32ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu1ll_BFu33 { unsigned short v1; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu1ll_BFu7c { unsigned short v1; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu1ll_BFu7i { unsigned short v1; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu1ll_BFu7ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu1ll_BFu7s { unsigned short v1; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu1ll_BFu8c { unsigned short v1; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu1ll_BFu8i { unsigned short v1; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu1ll_BFu8ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu1ll_BFu8s { unsigned short v1; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu1ll_BFu9i { unsigned short v1; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu1ll_BFu9ll { unsigned short v1; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu1ll_BFu9s { unsigned short v1; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu1ll_C { unsigned short v1; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aUs_BFu1ll_D { unsigned short v1; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aUs_BFu1ll_F { unsigned short v1; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aUs_BFu1ll_I { unsigned short v1; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aUs_BFu1ll_Ip { unsigned short v1; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aUs_BFu1ll_L { unsigned short v1; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aUs_BFu1ll_S { unsigned short v1; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aUs_BFu1ll_Uc { unsigned short v1; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu1ll_Ui { unsigned short v1; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu1ll_Ul { unsigned short v1; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu1ll_Us { unsigned short v1; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu1ll_Vp { unsigned short v1; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aUs_BFu1s { unsigned short v1; unsigned short v2:1; };
struct __attribute__((packed)) aUs_BFu1s_BFu15i { unsigned short v1; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu1s_BFu15ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu1s_BFu15s { unsigned short v1; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu1s_BFu16i { unsigned short v1; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu1s_BFu16ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu1s_BFu16s { unsigned short v1; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu1s_BFu17i { unsigned short v1; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu1s_BFu17ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu1s_BFu1c { unsigned short v1; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu1s_BFu1i { unsigned short v1; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu1s_BFu1ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu1s_BFu1s { unsigned short v1; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu1s_BFu31i { unsigned short v1; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu1s_BFu31ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu1s_BFu32i { unsigned short v1; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu1s_BFu32ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu1s_BFu33 { unsigned short v1; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu1s_BFu7c { unsigned short v1; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu1s_BFu7i { unsigned short v1; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu1s_BFu7ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu1s_BFu7s { unsigned short v1; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu1s_BFu8c { unsigned short v1; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu1s_BFu8i { unsigned short v1; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu1s_BFu8ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu1s_BFu8s { unsigned short v1; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu1s_BFu9i { unsigned short v1; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu1s_BFu9ll { unsigned short v1; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu1s_BFu9s { unsigned short v1; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu1s_C { unsigned short v1; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aUs_BFu1s_D { unsigned short v1; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aUs_BFu1s_F { unsigned short v1; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aUs_BFu1s_I { unsigned short v1; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aUs_BFu1s_Ip { unsigned short v1; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aUs_BFu1s_L { unsigned short v1; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aUs_BFu1s_S { unsigned short v1; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aUs_BFu1s_Uc { unsigned short v1; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu1s_Ui { unsigned short v1; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu1s_Ul { unsigned short v1; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu1s_Us { unsigned short v1; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu1s_Vp { unsigned short v1; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aUs_BFu31i { unsigned short v1; unsigned int v2:31; };
struct __attribute__((packed)) aUs_BFu31i_BFu15i { unsigned short v1; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu31i_BFu15ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu31i_BFu15s { unsigned short v1; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu31i_BFu16i { unsigned short v1; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu31i_BFu16ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu31i_BFu16s { unsigned short v1; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu31i_BFu17i { unsigned short v1; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu31i_BFu17ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu31i_BFu1c { unsigned short v1; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu31i_BFu1i { unsigned short v1; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu31i_BFu1ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu31i_BFu1s { unsigned short v1; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu31i_BFu31i { unsigned short v1; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu31i_BFu31ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu31i_BFu32i { unsigned short v1; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu31i_BFu32ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu31i_BFu33 { unsigned short v1; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu31i_BFu7c { unsigned short v1; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu31i_BFu7i { unsigned short v1; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu31i_BFu7ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu31i_BFu7s { unsigned short v1; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu31i_BFu8c { unsigned short v1; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu31i_BFu8i { unsigned short v1; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu31i_BFu8ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu31i_BFu8s { unsigned short v1; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu31i_BFu9i { unsigned short v1; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu31i_BFu9ll { unsigned short v1; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu31i_BFu9s { unsigned short v1; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu31i_C { unsigned short v1; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aUs_BFu31i_D { unsigned short v1; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aUs_BFu31i_F { unsigned short v1; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aUs_BFu31i_I { unsigned short v1; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aUs_BFu31i_Ip { unsigned short v1; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aUs_BFu31i_L { unsigned short v1; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aUs_BFu31i_S { unsigned short v1; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aUs_BFu31i_Uc { unsigned short v1; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu31i_Ui { unsigned short v1; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu31i_Ul { unsigned short v1; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu31i_Us { unsigned short v1; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu31i_Vp { unsigned short v1; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aUs_BFu31ll { unsigned short v1; unsigned long long v2:31; };
struct __attribute__((packed)) aUs_BFu31ll_BFu15i { unsigned short v1; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu31ll_BFu15ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu31ll_BFu15s { unsigned short v1; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu31ll_BFu16i { unsigned short v1; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu31ll_BFu16ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu31ll_BFu16s { unsigned short v1; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu31ll_BFu17i { unsigned short v1; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu31ll_BFu17ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu31ll_BFu1c { unsigned short v1; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu31ll_BFu1i { unsigned short v1; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu31ll_BFu1ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu31ll_BFu1s { unsigned short v1; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu31ll_BFu31i { unsigned short v1; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu31ll_BFu31ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu31ll_BFu32i { unsigned short v1; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu31ll_BFu32ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu31ll_BFu33 { unsigned short v1; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu31ll_BFu7c { unsigned short v1; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu31ll_BFu7i { unsigned short v1; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu31ll_BFu7ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu31ll_BFu7s { unsigned short v1; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu31ll_BFu8c { unsigned short v1; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu31ll_BFu8i { unsigned short v1; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu31ll_BFu8ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu31ll_BFu8s { unsigned short v1; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu31ll_BFu9i { unsigned short v1; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu31ll_BFu9ll { unsigned short v1; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu31ll_BFu9s { unsigned short v1; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu31ll_C { unsigned short v1; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aUs_BFu31ll_D { unsigned short v1; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aUs_BFu31ll_F { unsigned short v1; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aUs_BFu31ll_I { unsigned short v1; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aUs_BFu31ll_Ip { unsigned short v1; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aUs_BFu31ll_L { unsigned short v1; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aUs_BFu31ll_S { unsigned short v1; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aUs_BFu31ll_Uc { unsigned short v1; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu31ll_Ui { unsigned short v1; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu31ll_Ul { unsigned short v1; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu31ll_Us { unsigned short v1; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu31ll_Vp { unsigned short v1; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aUs_BFu32i { unsigned short v1; unsigned int v2:32; };
struct __attribute__((packed)) aUs_BFu32i_BFu15i { unsigned short v1; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu32i_BFu15ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu32i_BFu15s { unsigned short v1; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu32i_BFu16i { unsigned short v1; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu32i_BFu16ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu32i_BFu16s { unsigned short v1; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu32i_BFu17i { unsigned short v1; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu32i_BFu17ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu32i_BFu1c { unsigned short v1; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu32i_BFu1i { unsigned short v1; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu32i_BFu1ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu32i_BFu1s { unsigned short v1; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu32i_BFu31i { unsigned short v1; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu32i_BFu31ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu32i_BFu32i { unsigned short v1; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu32i_BFu32ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu32i_BFu33 { unsigned short v1; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu32i_BFu7c { unsigned short v1; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu32i_BFu7i { unsigned short v1; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu32i_BFu7ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu32i_BFu7s { unsigned short v1; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu32i_BFu8c { unsigned short v1; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu32i_BFu8i { unsigned short v1; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu32i_BFu8ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu32i_BFu8s { unsigned short v1; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu32i_BFu9i { unsigned short v1; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu32i_BFu9ll { unsigned short v1; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu32i_BFu9s { unsigned short v1; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu32i_C { unsigned short v1; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aUs_BFu32i_D { unsigned short v1; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aUs_BFu32i_F { unsigned short v1; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aUs_BFu32i_I { unsigned short v1; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aUs_BFu32i_Ip { unsigned short v1; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aUs_BFu32i_L { unsigned short v1; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aUs_BFu32i_S { unsigned short v1; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aUs_BFu32i_Uc { unsigned short v1; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu32i_Ui { unsigned short v1; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu32i_Ul { unsigned short v1; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu32i_Us { unsigned short v1; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu32i_Vp { unsigned short v1; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aUs_BFu32ll { unsigned short v1; unsigned long long v2:32; };
struct __attribute__((packed)) aUs_BFu32ll_BFu15i { unsigned short v1; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu32ll_BFu15ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu32ll_BFu15s { unsigned short v1; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu32ll_BFu16i { unsigned short v1; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu32ll_BFu16ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu32ll_BFu16s { unsigned short v1; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu32ll_BFu17i { unsigned short v1; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu32ll_BFu17ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu32ll_BFu1c { unsigned short v1; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu32ll_BFu1i { unsigned short v1; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu32ll_BFu1ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu32ll_BFu1s { unsigned short v1; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu32ll_BFu31i { unsigned short v1; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu32ll_BFu31ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu32ll_BFu32i { unsigned short v1; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu32ll_BFu32ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu32ll_BFu33 { unsigned short v1; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu32ll_BFu7c { unsigned short v1; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu32ll_BFu7i { unsigned short v1; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu32ll_BFu7ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu32ll_BFu7s { unsigned short v1; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu32ll_BFu8c { unsigned short v1; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu32ll_BFu8i { unsigned short v1; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu32ll_BFu8ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu32ll_BFu8s { unsigned short v1; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu32ll_BFu9i { unsigned short v1; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu32ll_BFu9ll { unsigned short v1; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu32ll_BFu9s { unsigned short v1; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu32ll_C { unsigned short v1; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aUs_BFu32ll_D { unsigned short v1; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aUs_BFu32ll_F { unsigned short v1; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aUs_BFu32ll_I { unsigned short v1; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aUs_BFu32ll_Ip { unsigned short v1; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aUs_BFu32ll_L { unsigned short v1; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aUs_BFu32ll_S { unsigned short v1; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aUs_BFu32ll_Uc { unsigned short v1; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu32ll_Ui { unsigned short v1; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu32ll_Ul { unsigned short v1; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu32ll_Us { unsigned short v1; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu32ll_Vp { unsigned short v1; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aUs_BFu33 { unsigned short v1; unsigned long long v2:33; };
struct __attribute__((packed)) aUs_BFu33_BFu15i { unsigned short v1; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu33_BFu15ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu33_BFu15s { unsigned short v1; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu33_BFu16i { unsigned short v1; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu33_BFu16ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu33_BFu16s { unsigned short v1; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu33_BFu17i { unsigned short v1; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu33_BFu17ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu33_BFu1c { unsigned short v1; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu33_BFu1i { unsigned short v1; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu33_BFu1ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu33_BFu1s { unsigned short v1; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu33_BFu31i { unsigned short v1; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu33_BFu31ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu33_BFu32i { unsigned short v1; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu33_BFu32ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu33_BFu33 { unsigned short v1; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu33_BFu7c { unsigned short v1; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu33_BFu7i { unsigned short v1; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu33_BFu7ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu33_BFu7s { unsigned short v1; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu33_BFu8c { unsigned short v1; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu33_BFu8i { unsigned short v1; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu33_BFu8ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu33_BFu8s { unsigned short v1; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu33_BFu9i { unsigned short v1; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu33_BFu9ll { unsigned short v1; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu33_BFu9s { unsigned short v1; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu33_C { unsigned short v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aUs_BFu33_D { unsigned short v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aUs_BFu33_F { unsigned short v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aUs_BFu33_I { unsigned short v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aUs_BFu33_Ip { unsigned short v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aUs_BFu33_L { unsigned short v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aUs_BFu33_S { unsigned short v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aUs_BFu33_Uc { unsigned short v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu33_Ui { unsigned short v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu33_Ul { unsigned short v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu33_Us { unsigned short v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu33_Vp { unsigned short v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aUs_BFu7c { unsigned short v1; unsigned char v2:7; };
struct __attribute__((packed)) aUs_BFu7c_BFu15i { unsigned short v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu7c_BFu15ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu7c_BFu15s { unsigned short v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu7c_BFu16i { unsigned short v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu7c_BFu16ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu7c_BFu16s { unsigned short v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu7c_BFu17i { unsigned short v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu7c_BFu17ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu7c_BFu1c { unsigned short v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu7c_BFu1i { unsigned short v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu7c_BFu1ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu7c_BFu1s { unsigned short v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu7c_BFu31i { unsigned short v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu7c_BFu31ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu7c_BFu32i { unsigned short v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu7c_BFu32ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu7c_BFu33 { unsigned short v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu7c_BFu7c { unsigned short v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu7c_BFu7i { unsigned short v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu7c_BFu7ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu7c_BFu7s { unsigned short v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu7c_BFu8c { unsigned short v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu7c_BFu8i { unsigned short v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu7c_BFu8ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu7c_BFu8s { unsigned short v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu7c_BFu9i { unsigned short v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu7c_BFu9ll { unsigned short v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu7c_BFu9s { unsigned short v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu7c_C { unsigned short v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aUs_BFu7c_D { unsigned short v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aUs_BFu7c_F { unsigned short v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aUs_BFu7c_I { unsigned short v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aUs_BFu7c_Ip { unsigned short v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aUs_BFu7c_L { unsigned short v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aUs_BFu7c_S { unsigned short v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aUs_BFu7c_Uc { unsigned short v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu7c_Ui { unsigned short v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu7c_Ul { unsigned short v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu7c_Us { unsigned short v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu7c_Vp { unsigned short v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aUs_BFu7i { unsigned short v1; unsigned int v2:7; };
struct __attribute__((packed)) aUs_BFu7i_BFu15i { unsigned short v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu7i_BFu15ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu7i_BFu15s { unsigned short v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu7i_BFu16i { unsigned short v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu7i_BFu16ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu7i_BFu16s { unsigned short v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu7i_BFu17i { unsigned short v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu7i_BFu17ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu7i_BFu1c { unsigned short v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu7i_BFu1i { unsigned short v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu7i_BFu1ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu7i_BFu1s { unsigned short v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu7i_BFu31i { unsigned short v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu7i_BFu31ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu7i_BFu32i { unsigned short v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu7i_BFu32ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu7i_BFu33 { unsigned short v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu7i_BFu7c { unsigned short v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu7i_BFu7i { unsigned short v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu7i_BFu7ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu7i_BFu7s { unsigned short v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu7i_BFu8c { unsigned short v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu7i_BFu8i { unsigned short v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu7i_BFu8ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu7i_BFu8s { unsigned short v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu7i_BFu9i { unsigned short v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu7i_BFu9ll { unsigned short v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu7i_BFu9s { unsigned short v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu7i_C { unsigned short v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aUs_BFu7i_D { unsigned short v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aUs_BFu7i_F { unsigned short v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aUs_BFu7i_I { unsigned short v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aUs_BFu7i_Ip { unsigned short v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aUs_BFu7i_L { unsigned short v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aUs_BFu7i_S { unsigned short v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aUs_BFu7i_Uc { unsigned short v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu7i_Ui { unsigned short v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu7i_Ul { unsigned short v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu7i_Us { unsigned short v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu7i_Vp { unsigned short v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aUs_BFu7ll { unsigned short v1; unsigned long long v2:7; };
struct __attribute__((packed)) aUs_BFu7ll_BFu15i { unsigned short v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu7ll_BFu15ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu7ll_BFu15s { unsigned short v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu7ll_BFu16i { unsigned short v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu7ll_BFu16ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu7ll_BFu16s { unsigned short v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu7ll_BFu17i { unsigned short v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu7ll_BFu17ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu7ll_BFu1c { unsigned short v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu7ll_BFu1i { unsigned short v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu7ll_BFu1ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu7ll_BFu1s { unsigned short v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu7ll_BFu31i { unsigned short v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu7ll_BFu31ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu7ll_BFu32i { unsigned short v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu7ll_BFu32ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu7ll_BFu33 { unsigned short v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu7ll_BFu7c { unsigned short v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu7ll_BFu7i { unsigned short v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu7ll_BFu7ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu7ll_BFu7s { unsigned short v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu7ll_BFu8c { unsigned short v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu7ll_BFu8i { unsigned short v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu7ll_BFu8ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu7ll_BFu8s { unsigned short v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu7ll_BFu9i { unsigned short v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu7ll_BFu9ll { unsigned short v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu7ll_BFu9s { unsigned short v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu7ll_C { unsigned short v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aUs_BFu7ll_D { unsigned short v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aUs_BFu7ll_F { unsigned short v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aUs_BFu7ll_I { unsigned short v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aUs_BFu7ll_Ip { unsigned short v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aUs_BFu7ll_L { unsigned short v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aUs_BFu7ll_S { unsigned short v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aUs_BFu7ll_Uc { unsigned short v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu7ll_Ui { unsigned short v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu7ll_Ul { unsigned short v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu7ll_Us { unsigned short v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu7ll_Vp { unsigned short v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aUs_BFu7s { unsigned short v1; unsigned short v2:7; };
struct __attribute__((packed)) aUs_BFu7s_BFu15i { unsigned short v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu7s_BFu15ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu7s_BFu15s { unsigned short v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu7s_BFu16i { unsigned short v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu7s_BFu16ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu7s_BFu16s { unsigned short v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu7s_BFu17i { unsigned short v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu7s_BFu17ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu7s_BFu1c { unsigned short v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu7s_BFu1i { unsigned short v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu7s_BFu1ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu7s_BFu1s { unsigned short v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu7s_BFu31i { unsigned short v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu7s_BFu31ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu7s_BFu32i { unsigned short v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu7s_BFu32ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu7s_BFu33 { unsigned short v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu7s_BFu7c { unsigned short v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu7s_BFu7i { unsigned short v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu7s_BFu7ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu7s_BFu7s { unsigned short v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu7s_BFu8c { unsigned short v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu7s_BFu8i { unsigned short v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu7s_BFu8ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu7s_BFu8s { unsigned short v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu7s_BFu9i { unsigned short v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu7s_BFu9ll { unsigned short v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu7s_BFu9s { unsigned short v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu7s_C { unsigned short v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aUs_BFu7s_D { unsigned short v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aUs_BFu7s_F { unsigned short v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aUs_BFu7s_I { unsigned short v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aUs_BFu7s_Ip { unsigned short v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aUs_BFu7s_L { unsigned short v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aUs_BFu7s_S { unsigned short v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aUs_BFu7s_Uc { unsigned short v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu7s_Ui { unsigned short v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu7s_Ul { unsigned short v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu7s_Us { unsigned short v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu7s_Vp { unsigned short v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aUs_BFu8c { unsigned short v1; unsigned char v2:8; };
struct __attribute__((packed)) aUs_BFu8c_BFu15i { unsigned short v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu8c_BFu15ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu8c_BFu15s { unsigned short v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu8c_BFu16i { unsigned short v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu8c_BFu16ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu8c_BFu16s { unsigned short v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu8c_BFu17i { unsigned short v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu8c_BFu17ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu8c_BFu1c { unsigned short v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu8c_BFu1i { unsigned short v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu8c_BFu1ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu8c_BFu1s { unsigned short v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu8c_BFu31i { unsigned short v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu8c_BFu31ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu8c_BFu32i { unsigned short v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu8c_BFu32ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu8c_BFu33 { unsigned short v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu8c_BFu7c { unsigned short v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu8c_BFu7i { unsigned short v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu8c_BFu7ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu8c_BFu7s { unsigned short v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu8c_BFu8c { unsigned short v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu8c_BFu8i { unsigned short v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu8c_BFu8ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu8c_BFu8s { unsigned short v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu8c_BFu9i { unsigned short v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu8c_BFu9ll { unsigned short v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu8c_BFu9s { unsigned short v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu8c_C { unsigned short v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aUs_BFu8c_D { unsigned short v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aUs_BFu8c_F { unsigned short v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aUs_BFu8c_I { unsigned short v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aUs_BFu8c_Ip { unsigned short v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aUs_BFu8c_L { unsigned short v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aUs_BFu8c_S { unsigned short v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aUs_BFu8c_Uc { unsigned short v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu8c_Ui { unsigned short v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu8c_Ul { unsigned short v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu8c_Us { unsigned short v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu8c_Vp { unsigned short v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aUs_BFu8i { unsigned short v1; unsigned int v2:8; };
struct __attribute__((packed)) aUs_BFu8i_BFu15i { unsigned short v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu8i_BFu15ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu8i_BFu15s { unsigned short v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu8i_BFu16i { unsigned short v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu8i_BFu16ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu8i_BFu16s { unsigned short v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu8i_BFu17i { unsigned short v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu8i_BFu17ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu8i_BFu1c { unsigned short v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu8i_BFu1i { unsigned short v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu8i_BFu1ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu8i_BFu1s { unsigned short v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu8i_BFu31i { unsigned short v1; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu8i_BFu31ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu8i_BFu32i { unsigned short v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu8i_BFu32ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu8i_BFu33 { unsigned short v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu8i_BFu7c { unsigned short v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu8i_BFu7i { unsigned short v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu8i_BFu7ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu8i_BFu7s { unsigned short v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu8i_BFu8c { unsigned short v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu8i_BFu8i { unsigned short v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu8i_BFu8ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu8i_BFu8s { unsigned short v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu8i_BFu9i { unsigned short v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu8i_BFu9ll { unsigned short v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu8i_BFu9s { unsigned short v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu8i_C { unsigned short v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aUs_BFu8i_D { unsigned short v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aUs_BFu8i_F { unsigned short v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aUs_BFu8i_I { unsigned short v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aUs_BFu8i_Ip { unsigned short v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aUs_BFu8i_L { unsigned short v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aUs_BFu8i_S { unsigned short v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aUs_BFu8i_Uc { unsigned short v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu8i_Ui { unsigned short v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu8i_Ul { unsigned short v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu8i_Us { unsigned short v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu8i_Vp { unsigned short v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aUs_BFu8ll { unsigned short v1; unsigned long long v2:8; };
struct __attribute__((packed)) aUs_BFu8ll_BFu15i { unsigned short v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu8ll_BFu15ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu8ll_BFu15s { unsigned short v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu8ll_BFu16i { unsigned short v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu8ll_BFu16ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu8ll_BFu16s { unsigned short v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu8ll_BFu17i { unsigned short v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu8ll_BFu17ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu8ll_BFu1c { unsigned short v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu8ll_BFu1i { unsigned short v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu8ll_BFu1ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu8ll_BFu1s { unsigned short v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu8ll_BFu31i { unsigned short v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu8ll_BFu31ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu8ll_BFu32i { unsigned short v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu8ll_BFu32ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu8ll_BFu33 { unsigned short v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu8ll_BFu7c { unsigned short v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu8ll_BFu7i { unsigned short v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu8ll_BFu7ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu8ll_BFu7s { unsigned short v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu8ll_BFu8c { unsigned short v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu8ll_BFu8i { unsigned short v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu8ll_BFu8ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu8ll_BFu8s { unsigned short v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu8ll_BFu9i { unsigned short v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu8ll_BFu9ll { unsigned short v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu8ll_BFu9s { unsigned short v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu8ll_C { unsigned short v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aUs_BFu8ll_D { unsigned short v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aUs_BFu8ll_F { unsigned short v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aUs_BFu8ll_I { unsigned short v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aUs_BFu8ll_Ip { unsigned short v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aUs_BFu8ll_L { unsigned short v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aUs_BFu8ll_S { unsigned short v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aUs_BFu8ll_Uc { unsigned short v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu8ll_Ui { unsigned short v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu8ll_Ul { unsigned short v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu8ll_Us { unsigned short v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu8ll_Vp { unsigned short v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aUs_BFu8s { unsigned short v1; unsigned short v2:8; };
struct __attribute__((packed)) aUs_BFu8s_BFu15i { unsigned short v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu8s_BFu15ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu8s_BFu15s { unsigned short v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu8s_BFu16i { unsigned short v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu8s_BFu16ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu8s_BFu16s { unsigned short v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu8s_BFu17i { unsigned short v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu8s_BFu17ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu8s_BFu1c { unsigned short v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu8s_BFu1i { unsigned short v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu8s_BFu1ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu8s_BFu1s { unsigned short v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu8s_BFu31i { unsigned short v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu8s_BFu31ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu8s_BFu32i { unsigned short v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu8s_BFu32ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu8s_BFu33 { unsigned short v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu8s_BFu7c { unsigned short v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu8s_BFu7i { unsigned short v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu8s_BFu7ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu8s_BFu7s { unsigned short v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu8s_BFu8c { unsigned short v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu8s_BFu8i { unsigned short v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu8s_BFu8ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu8s_BFu8s { unsigned short v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu8s_BFu9i { unsigned short v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu8s_BFu9ll { unsigned short v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu8s_BFu9s { unsigned short v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu8s_C { unsigned short v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aUs_BFu8s_D { unsigned short v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aUs_BFu8s_F { unsigned short v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aUs_BFu8s_I { unsigned short v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aUs_BFu8s_Ip { unsigned short v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aUs_BFu8s_L { unsigned short v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aUs_BFu8s_S { unsigned short v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aUs_BFu8s_Uc { unsigned short v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu8s_Ui { unsigned short v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu8s_Ul { unsigned short v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu8s_Us { unsigned short v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu8s_Vp { unsigned short v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aUs_BFu9i { unsigned short v1; unsigned int v2:9; };
struct __attribute__((packed)) aUs_BFu9i_BFu15i { unsigned short v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu9i_BFu15ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu9i_BFu15s { unsigned short v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu9i_BFu16i { unsigned short v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu9i_BFu16ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu9i_BFu16s { unsigned short v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu9i_BFu17i { unsigned short v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu9i_BFu17ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu9i_BFu1c { unsigned short v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu9i_BFu1i { unsigned short v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu9i_BFu1ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu9i_BFu1s { unsigned short v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu9i_BFu31i { unsigned short v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu9i_BFu31ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu9i_BFu32i { unsigned short v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu9i_BFu32ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu9i_BFu33 { unsigned short v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu9i_BFu7c { unsigned short v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu9i_BFu7i { unsigned short v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu9i_BFu7ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu9i_BFu7s { unsigned short v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu9i_BFu8c { unsigned short v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu9i_BFu8i { unsigned short v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu9i_BFu8ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu9i_BFu8s { unsigned short v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu9i_BFu9i { unsigned short v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu9i_BFu9ll { unsigned short v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu9i_BFu9s { unsigned short v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu9i_C { unsigned short v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aUs_BFu9i_D { unsigned short v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aUs_BFu9i_F { unsigned short v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aUs_BFu9i_I { unsigned short v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aUs_BFu9i_Ip { unsigned short v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aUs_BFu9i_L { unsigned short v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aUs_BFu9i_S { unsigned short v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aUs_BFu9i_Uc { unsigned short v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu9i_Ui { unsigned short v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu9i_Ul { unsigned short v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu9i_Us { unsigned short v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu9i_Vp { unsigned short v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aUs_BFu9ll { unsigned short v1; unsigned long long v2:9; };
struct __attribute__((packed)) aUs_BFu9ll_BFu15i { unsigned short v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu9ll_BFu15ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu9ll_BFu15s { unsigned short v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu9ll_BFu16i { unsigned short v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu9ll_BFu16ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu9ll_BFu16s { unsigned short v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu9ll_BFu17i { unsigned short v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu9ll_BFu17ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu9ll_BFu1c { unsigned short v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu9ll_BFu1i { unsigned short v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu9ll_BFu1ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu9ll_BFu1s { unsigned short v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu9ll_BFu31i { unsigned short v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu9ll_BFu31ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu9ll_BFu32i { unsigned short v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu9ll_BFu32ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu9ll_BFu33 { unsigned short v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu9ll_BFu7c { unsigned short v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu9ll_BFu7i { unsigned short v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu9ll_BFu7ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu9ll_BFu7s { unsigned short v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu9ll_BFu8c { unsigned short v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu9ll_BFu8i { unsigned short v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu9ll_BFu8ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu9ll_BFu8s { unsigned short v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu9ll_BFu9i { unsigned short v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu9ll_BFu9ll { unsigned short v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu9ll_BFu9s { unsigned short v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu9ll_C { unsigned short v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aUs_BFu9ll_D { unsigned short v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aUs_BFu9ll_F { unsigned short v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aUs_BFu9ll_I { unsigned short v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aUs_BFu9ll_Ip { unsigned short v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aUs_BFu9ll_L { unsigned short v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aUs_BFu9ll_S { unsigned short v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aUs_BFu9ll_Uc { unsigned short v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu9ll_Ui { unsigned short v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu9ll_Ul { unsigned short v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu9ll_Us { unsigned short v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu9ll_Vp { unsigned short v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aUs_BFu9s { unsigned short v1; unsigned short v2:9; };
struct __attribute__((packed)) aUs_BFu9s_BFu15i { unsigned short v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aUs_BFu9s_BFu15ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_BFu9s_BFu15s { unsigned short v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aUs_BFu9s_BFu16i { unsigned short v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aUs_BFu9s_BFu16ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_BFu9s_BFu16s { unsigned short v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aUs_BFu9s_BFu17i { unsigned short v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aUs_BFu9s_BFu17ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_BFu9s_BFu1c { unsigned short v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aUs_BFu9s_BFu1i { unsigned short v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aUs_BFu9s_BFu1ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_BFu9s_BFu1s { unsigned short v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aUs_BFu9s_BFu31i { unsigned short v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aUs_BFu9s_BFu31ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_BFu9s_BFu32i { unsigned short v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aUs_BFu9s_BFu32ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_BFu9s_BFu33 { unsigned short v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_BFu9s_BFu7c { unsigned short v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aUs_BFu9s_BFu7i { unsigned short v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aUs_BFu9s_BFu7ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_BFu9s_BFu7s { unsigned short v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aUs_BFu9s_BFu8c { unsigned short v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aUs_BFu9s_BFu8i { unsigned short v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aUs_BFu9s_BFu8ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_BFu9s_BFu8s { unsigned short v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aUs_BFu9s_BFu9i { unsigned short v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aUs_BFu9s_BFu9ll { unsigned short v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_BFu9s_BFu9s { unsigned short v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aUs_BFu9s_C { unsigned short v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aUs_BFu9s_D { unsigned short v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aUs_BFu9s_F { unsigned short v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aUs_BFu9s_I { unsigned short v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aUs_BFu9s_Ip { unsigned short v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aUs_BFu9s_L { unsigned short v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aUs_BFu9s_S { unsigned short v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aUs_BFu9s_Uc { unsigned short v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aUs_BFu9s_Ui { unsigned short v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aUs_BFu9s_Ul { unsigned short v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aUs_BFu9s_Us { unsigned short v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aUs_BFu9s_Vp { unsigned short v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aUs_C { unsigned short v1; char v2; };
struct __attribute__((packed)) aUs_C_BFu15i { unsigned short v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_C_BFu15ll { unsigned short v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_C_BFu15s { unsigned short v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_C_BFu16i { unsigned short v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_C_BFu16ll { unsigned short v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_C_BFu16s { unsigned short v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_C_BFu17i { unsigned short v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_C_BFu17ll { unsigned short v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_C_BFu1c { unsigned short v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_C_BFu1i { unsigned short v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_C_BFu1ll { unsigned short v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_C_BFu1s { unsigned short v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_C_BFu31i { unsigned short v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_C_BFu31ll { unsigned short v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_C_BFu32i { unsigned short v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_C_BFu32ll { unsigned short v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_C_BFu33 { unsigned short v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_C_BFu7c { unsigned short v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_C_BFu7i { unsigned short v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_C_BFu7ll { unsigned short v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_C_BFu7s { unsigned short v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_C_BFu8c { unsigned short v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_C_BFu8i { unsigned short v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_C_BFu8ll { unsigned short v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_C_BFu8s { unsigned short v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_C_BFu9i { unsigned short v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_C_BFu9ll { unsigned short v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_C_BFu9s { unsigned short v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_C_C { unsigned short v1; char v2; char v3; };
struct __attribute__((packed)) aUs_C_D { unsigned short v1; char v2; double v3; };
struct __attribute__((packed)) aUs_C_F { unsigned short v1; char v2; float v3; };
struct __attribute__((packed)) aUs_C_I { unsigned short v1; char v2; int v3; };
struct __attribute__((packed)) aUs_C_Ip { unsigned short v1; char v2; int * v3; };
struct __attribute__((packed)) aUs_C_L { unsigned short v1; char v2; long long v3; };
struct __attribute__((packed)) aUs_C_S { unsigned short v1; char v2; short v3; };
struct __attribute__((packed)) aUs_C_Uc { unsigned short v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aUs_C_Ui { unsigned short v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aUs_C_Ul { unsigned short v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_C_Us { unsigned short v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aUs_C_Vp { unsigned short v1; char v2; void * v3; };
struct __attribute__((packed)) aUs_D { unsigned short v1; double v2; };
struct __attribute__((packed)) aUs_D_BFu15i { unsigned short v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_D_BFu15ll { unsigned short v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_D_BFu15s { unsigned short v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_D_BFu16i { unsigned short v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_D_BFu16ll { unsigned short v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_D_BFu16s { unsigned short v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_D_BFu17i { unsigned short v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_D_BFu17ll { unsigned short v1; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_D_BFu1c { unsigned short v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_D_BFu1i { unsigned short v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_D_BFu1ll { unsigned short v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_D_BFu1s { unsigned short v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_D_BFu31i { unsigned short v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_D_BFu31ll { unsigned short v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_D_BFu32i { unsigned short v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_D_BFu32ll { unsigned short v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_D_BFu33 { unsigned short v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_D_BFu7c { unsigned short v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_D_BFu7i { unsigned short v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_D_BFu7ll { unsigned short v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_D_BFu7s { unsigned short v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_D_BFu8c { unsigned short v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_D_BFu8i { unsigned short v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_D_BFu8ll { unsigned short v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_D_BFu8s { unsigned short v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_D_BFu9i { unsigned short v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_D_BFu9ll { unsigned short v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_D_BFu9s { unsigned short v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_D_C { unsigned short v1; double v2; char v3; };
struct __attribute__((packed)) aUs_D_D { unsigned short v1; double v2; double v3; };
struct __attribute__((packed)) aUs_D_F { unsigned short v1; double v2; float v3; };
struct __attribute__((packed)) aUs_D_I { unsigned short v1; double v2; int v3; };
struct __attribute__((packed)) aUs_D_Ip { unsigned short v1; double v2; int * v3; };
struct __attribute__((packed)) aUs_D_L { unsigned short v1; double v2; long long v3; };
struct __attribute__((packed)) aUs_D_S { unsigned short v1; double v2; short v3; };
struct __attribute__((packed)) aUs_D_Uc { unsigned short v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aUs_D_Ui { unsigned short v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aUs_D_Ul { unsigned short v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_D_Us { unsigned short v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aUs_D_Vp { unsigned short v1; double v2; void * v3; };
struct __attribute__((packed)) aUs_F { unsigned short v1; float v2; };
struct __attribute__((packed)) aUs_F_BFu15i { unsigned short v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_F_BFu15ll { unsigned short v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_F_BFu15s { unsigned short v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_F_BFu16i { unsigned short v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_F_BFu16ll { unsigned short v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_F_BFu16s { unsigned short v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_F_BFu17i { unsigned short v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_F_BFu17ll { unsigned short v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_F_BFu1c { unsigned short v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_F_BFu1i { unsigned short v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_F_BFu1ll { unsigned short v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_F_BFu1s { unsigned short v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_F_BFu31i { unsigned short v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_F_BFu31ll { unsigned short v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_F_BFu32i { unsigned short v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_F_BFu32ll { unsigned short v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_F_BFu33 { unsigned short v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_F_BFu7c { unsigned short v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_F_BFu7i { unsigned short v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_F_BFu7ll { unsigned short v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_F_BFu7s { unsigned short v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_F_BFu8c { unsigned short v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_F_BFu8i { unsigned short v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_F_BFu8ll { unsigned short v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_F_BFu8s { unsigned short v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_F_BFu9i { unsigned short v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_F_BFu9ll { unsigned short v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_F_BFu9s { unsigned short v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_F_C { unsigned short v1; float v2; char v3; };
struct __attribute__((packed)) aUs_F_D { unsigned short v1; float v2; double v3; };
struct __attribute__((packed)) aUs_F_F { unsigned short v1; float v2; float v3; };
struct __attribute__((packed)) aUs_F_I { unsigned short v1; float v2; int v3; };
struct __attribute__((packed)) aUs_F_Ip { unsigned short v1; float v2; int * v3; };
struct __attribute__((packed)) aUs_F_L { unsigned short v1; float v2; long long v3; };
struct __attribute__((packed)) aUs_F_S { unsigned short v1; float v2; short v3; };
struct __attribute__((packed)) aUs_F_Uc { unsigned short v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aUs_F_Ui { unsigned short v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aUs_F_Ul { unsigned short v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_F_Us { unsigned short v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aUs_F_Vp { unsigned short v1; float v2; void * v3; };
struct __attribute__((packed)) aUs_I { unsigned short v1; int v2; };
struct __attribute__((packed)) aUs_I_BFu15i { unsigned short v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_I_BFu15ll { unsigned short v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_I_BFu15s { unsigned short v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_I_BFu16i { unsigned short v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_I_BFu16ll { unsigned short v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_I_BFu16s { unsigned short v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_I_BFu17i { unsigned short v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_I_BFu17ll { unsigned short v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_I_BFu1c { unsigned short v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_I_BFu1i { unsigned short v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_I_BFu1ll { unsigned short v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_I_BFu1s { unsigned short v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_I_BFu31i { unsigned short v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_I_BFu31ll { unsigned short v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_I_BFu32i { unsigned short v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_I_BFu32ll { unsigned short v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_I_BFu33 { unsigned short v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_I_BFu7c { unsigned short v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_I_BFu7i { unsigned short v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_I_BFu7ll { unsigned short v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_I_BFu7s { unsigned short v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_I_BFu8c { unsigned short v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_I_BFu8i { unsigned short v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_I_BFu8ll { unsigned short v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_I_BFu8s { unsigned short v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_I_BFu9i { unsigned short v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_I_BFu9ll { unsigned short v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_I_BFu9s { unsigned short v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_I_C { unsigned short v1; int v2; char v3; };
struct __attribute__((packed)) aUs_I_D { unsigned short v1; int v2; double v3; };
struct __attribute__((packed)) aUs_I_F { unsigned short v1; int v2; float v3; };
struct __attribute__((packed)) aUs_I_I { unsigned short v1; int v2; int v3; };
struct __attribute__((packed)) aUs_I_Ip { unsigned short v1; int v2; int * v3; };
struct __attribute__((packed)) aUs_I_L { unsigned short v1; int v2; long long v3; };
struct __attribute__((packed)) aUs_I_S { unsigned short v1; int v2; short v3; };
struct __attribute__((packed)) aUs_I_Uc { unsigned short v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aUs_I_Ui { unsigned short v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aUs_I_Ul { unsigned short v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_I_Us { unsigned short v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aUs_I_Vp { unsigned short v1; int v2; void * v3; };
struct __attribute__((packed)) aUs_Ip { unsigned short v1; int * v2; };
struct __attribute__((packed)) aUs_Ip_BFu15i { unsigned short v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_Ip_BFu15ll { unsigned short v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_Ip_BFu15s { unsigned short v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_Ip_BFu16i { unsigned short v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_Ip_BFu16ll { unsigned short v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_Ip_BFu16s { unsigned short v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_Ip_BFu17i { unsigned short v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_Ip_BFu17ll { unsigned short v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_Ip_BFu1c { unsigned short v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_Ip_BFu1i { unsigned short v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_Ip_BFu1ll { unsigned short v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_Ip_BFu1s { unsigned short v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_Ip_BFu31i { unsigned short v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_Ip_BFu31ll { unsigned short v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_Ip_BFu32i { unsigned short v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_Ip_BFu32ll { unsigned short v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_Ip_BFu33 { unsigned short v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_Ip_BFu7c { unsigned short v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_Ip_BFu7i { unsigned short v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_Ip_BFu7ll { unsigned short v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_Ip_BFu7s { unsigned short v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_Ip_BFu8c { unsigned short v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_Ip_BFu8i { unsigned short v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_Ip_BFu8ll { unsigned short v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_Ip_BFu8s { unsigned short v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_Ip_BFu9i { unsigned short v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_Ip_BFu9ll { unsigned short v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_Ip_BFu9s { unsigned short v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_Ip_C { unsigned short v1; int * v2; char v3; };
struct __attribute__((packed)) aUs_Ip_D { unsigned short v1; int * v2; double v3; };
struct __attribute__((packed)) aUs_Ip_F { unsigned short v1; int * v2; float v3; };
struct __attribute__((packed)) aUs_Ip_I { unsigned short v1; int * v2; int v3; };
struct __attribute__((packed)) aUs_Ip_Ip { unsigned short v1; int * v2; int * v3; };
struct __attribute__((packed)) aUs_Ip_L { unsigned short v1; int * v2; long long v3; };
struct __attribute__((packed)) aUs_Ip_S { unsigned short v1; int * v2; short v3; };
struct __attribute__((packed)) aUs_Ip_Uc { unsigned short v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aUs_Ip_Ui { unsigned short v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aUs_Ip_Ul { unsigned short v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_Ip_Us { unsigned short v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aUs_Ip_Vp { unsigned short v1; int * v2; void * v3; };
struct __attribute__((packed)) aUs_L { unsigned short v1; long long v2; };
struct __attribute__((packed)) aUs_L_BFu15i { unsigned short v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_L_BFu15ll { unsigned short v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_L_BFu15s { unsigned short v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_L_BFu16i { unsigned short v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_L_BFu16ll { unsigned short v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_L_BFu16s { unsigned short v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_L_BFu17i { unsigned short v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_L_BFu17ll { unsigned short v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_L_BFu1c { unsigned short v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_L_BFu1i { unsigned short v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_L_BFu1ll { unsigned short v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_L_BFu1s { unsigned short v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_L_BFu31i { unsigned short v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_L_BFu31ll { unsigned short v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_L_BFu32i { unsigned short v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_L_BFu32ll { unsigned short v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_L_BFu33 { unsigned short v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_L_BFu7c { unsigned short v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_L_BFu7i { unsigned short v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_L_BFu7ll { unsigned short v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_L_BFu7s { unsigned short v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_L_BFu8c { unsigned short v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_L_BFu8i { unsigned short v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_L_BFu8ll { unsigned short v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_L_BFu8s { unsigned short v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_L_BFu9i { unsigned short v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_L_BFu9ll { unsigned short v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_L_BFu9s { unsigned short v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_L_C { unsigned short v1; long long v2; char v3; };
struct __attribute__((packed)) aUs_L_D { unsigned short v1; long long v2; double v3; };
struct __attribute__((packed)) aUs_L_F { unsigned short v1; long long v2; float v3; };
struct __attribute__((packed)) aUs_L_I { unsigned short v1; long long v2; int v3; };
struct __attribute__((packed)) aUs_L_Ip { unsigned short v1; long long v2; int * v3; };
struct __attribute__((packed)) aUs_L_L { unsigned short v1; long long v2; long long v3; };
struct __attribute__((packed)) aUs_L_S { unsigned short v1; long long v2; short v3; };
struct __attribute__((packed)) aUs_L_Uc { unsigned short v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aUs_L_Ui { unsigned short v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aUs_L_Ul { unsigned short v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_L_Us { unsigned short v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aUs_L_Vp { unsigned short v1; long long v2; void * v3; };
struct __attribute__((packed)) aUs_S { unsigned short v1; short v2; };
struct __attribute__((packed)) aUs_S_BFu15i { unsigned short v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_S_BFu15ll { unsigned short v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_S_BFu15s { unsigned short v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_S_BFu16i { unsigned short v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_S_BFu16ll { unsigned short v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_S_BFu16s { unsigned short v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_S_BFu17i { unsigned short v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_S_BFu17ll { unsigned short v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_S_BFu1c { unsigned short v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_S_BFu1i { unsigned short v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_S_BFu1ll { unsigned short v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_S_BFu1s { unsigned short v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_S_BFu31i { unsigned short v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_S_BFu31ll { unsigned short v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_S_BFu32i { unsigned short v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_S_BFu32ll { unsigned short v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_S_BFu33 { unsigned short v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_S_BFu7c { unsigned short v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_S_BFu7i { unsigned short v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_S_BFu7ll { unsigned short v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_S_BFu7s { unsigned short v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_S_BFu8c { unsigned short v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_S_BFu8i { unsigned short v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_S_BFu8ll { unsigned short v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_S_BFu8s { unsigned short v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_S_BFu9i { unsigned short v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_S_BFu9ll { unsigned short v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_S_BFu9s { unsigned short v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_S_C { unsigned short v1; short v2; char v3; };
struct __attribute__((packed)) aUs_S_D { unsigned short v1; short v2; double v3; };
struct __attribute__((packed)) aUs_S_F { unsigned short v1; short v2; float v3; };
struct __attribute__((packed)) aUs_S_I { unsigned short v1; short v2; int v3; };
struct __attribute__((packed)) aUs_S_Ip { unsigned short v1; short v2; int * v3; };
struct __attribute__((packed)) aUs_S_L { unsigned short v1; short v2; long long v3; };
struct __attribute__((packed)) aUs_S_S { unsigned short v1; short v2; short v3; };
struct __attribute__((packed)) aUs_S_Uc { unsigned short v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aUs_S_Ui { unsigned short v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aUs_S_Ul { unsigned short v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_S_Us { unsigned short v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aUs_S_Vp { unsigned short v1; short v2; void * v3; };
struct __attribute__((packed)) aUs_Uc { unsigned short v1; unsigned char v2; };
struct __attribute__((packed)) aUs_Uc_BFu15i { unsigned short v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_Uc_BFu15ll { unsigned short v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_Uc_BFu15s { unsigned short v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_Uc_BFu16i { unsigned short v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_Uc_BFu16ll { unsigned short v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_Uc_BFu16s { unsigned short v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_Uc_BFu17i { unsigned short v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_Uc_BFu17ll { unsigned short v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_Uc_BFu1c { unsigned short v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_Uc_BFu1i { unsigned short v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_Uc_BFu1ll { unsigned short v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_Uc_BFu1s { unsigned short v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_Uc_BFu31i { unsigned short v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_Uc_BFu31ll { unsigned short v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_Uc_BFu32i { unsigned short v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_Uc_BFu32ll { unsigned short v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_Uc_BFu33 { unsigned short v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_Uc_BFu7c { unsigned short v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_Uc_BFu7i { unsigned short v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_Uc_BFu7ll { unsigned short v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_Uc_BFu7s { unsigned short v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_Uc_BFu8c { unsigned short v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_Uc_BFu8i { unsigned short v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_Uc_BFu8ll { unsigned short v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_Uc_BFu8s { unsigned short v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_Uc_BFu9i { unsigned short v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_Uc_BFu9ll { unsigned short v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_Uc_BFu9s { unsigned short v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_Uc_C { unsigned short v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aUs_Uc_D { unsigned short v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aUs_Uc_F { unsigned short v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aUs_Uc_I { unsigned short v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aUs_Uc_Ip { unsigned short v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aUs_Uc_L { unsigned short v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aUs_Uc_S { unsigned short v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aUs_Uc_Uc { unsigned short v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aUs_Uc_Ui { unsigned short v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aUs_Uc_Ul { unsigned short v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_Uc_Us { unsigned short v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aUs_Uc_Vp { unsigned short v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aUs_Ui { unsigned short v1; unsigned int v2; };
struct __attribute__((packed)) aUs_Ui_BFu15i { unsigned short v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_Ui_BFu15ll { unsigned short v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_Ui_BFu15s { unsigned short v1; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_Ui_BFu16i { unsigned short v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_Ui_BFu16ll { unsigned short v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_Ui_BFu16s { unsigned short v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_Ui_BFu17i { unsigned short v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_Ui_BFu17ll { unsigned short v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_Ui_BFu1c { unsigned short v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_Ui_BFu1i { unsigned short v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_Ui_BFu1ll { unsigned short v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_Ui_BFu1s { unsigned short v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_Ui_BFu31i { unsigned short v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_Ui_BFu31ll { unsigned short v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_Ui_BFu32i { unsigned short v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_Ui_BFu32ll { unsigned short v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_Ui_BFu33 { unsigned short v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_Ui_BFu7c { unsigned short v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_Ui_BFu7i { unsigned short v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_Ui_BFu7ll { unsigned short v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_Ui_BFu7s { unsigned short v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_Ui_BFu8c { unsigned short v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_Ui_BFu8i { unsigned short v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_Ui_BFu8ll { unsigned short v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_Ui_BFu8s { unsigned short v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_Ui_BFu9i { unsigned short v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_Ui_BFu9ll { unsigned short v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_Ui_BFu9s { unsigned short v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_Ui_C { unsigned short v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aUs_Ui_D { unsigned short v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aUs_Ui_F { unsigned short v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aUs_Ui_I { unsigned short v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aUs_Ui_Ip { unsigned short v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aUs_Ui_L { unsigned short v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aUs_Ui_S { unsigned short v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aUs_Ui_Uc { unsigned short v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aUs_Ui_Ui { unsigned short v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aUs_Ui_Ul { unsigned short v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_Ui_Us { unsigned short v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aUs_Ui_Vp { unsigned short v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aUs_Ul { unsigned short v1; unsigned long long v2; };
struct __attribute__((packed)) aUs_Ul_BFu15i { unsigned short v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_Ul_BFu15ll { unsigned short v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_Ul_BFu15s { unsigned short v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_Ul_BFu16i { unsigned short v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_Ul_BFu16ll { unsigned short v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_Ul_BFu16s { unsigned short v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_Ul_BFu17i { unsigned short v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_Ul_BFu17ll { unsigned short v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_Ul_BFu1c { unsigned short v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_Ul_BFu1i { unsigned short v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_Ul_BFu1ll { unsigned short v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_Ul_BFu1s { unsigned short v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_Ul_BFu31i { unsigned short v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_Ul_BFu31ll { unsigned short v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_Ul_BFu32i { unsigned short v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_Ul_BFu32ll { unsigned short v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_Ul_BFu33 { unsigned short v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_Ul_BFu7c { unsigned short v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_Ul_BFu7i { unsigned short v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_Ul_BFu7ll { unsigned short v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_Ul_BFu7s { unsigned short v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_Ul_BFu8c { unsigned short v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_Ul_BFu8i { unsigned short v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_Ul_BFu8ll { unsigned short v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_Ul_BFu8s { unsigned short v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_Ul_BFu9i { unsigned short v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_Ul_BFu9ll { unsigned short v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_Ul_BFu9s { unsigned short v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_Ul_C { unsigned short v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aUs_Ul_D { unsigned short v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aUs_Ul_F { unsigned short v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aUs_Ul_I { unsigned short v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aUs_Ul_Ip { unsigned short v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aUs_Ul_L { unsigned short v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aUs_Ul_S { unsigned short v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aUs_Ul_Uc { unsigned short v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aUs_Ul_Ui { unsigned short v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aUs_Ul_Ul { unsigned short v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_Ul_Us { unsigned short v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aUs_Ul_Vp { unsigned short v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aUs_Us { unsigned short v1; unsigned short v2; };
struct __attribute__((packed)) aUs_Us_BFu15i { unsigned short v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_Us_BFu15ll { unsigned short v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_Us_BFu15s { unsigned short v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_Us_BFu16i { unsigned short v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_Us_BFu16ll { unsigned short v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_Us_BFu16s { unsigned short v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_Us_BFu17i { unsigned short v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_Us_BFu17ll { unsigned short v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_Us_BFu1c { unsigned short v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_Us_BFu1i { unsigned short v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_Us_BFu1ll { unsigned short v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_Us_BFu1s { unsigned short v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_Us_BFu31i { unsigned short v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_Us_BFu31ll { unsigned short v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_Us_BFu32i { unsigned short v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_Us_BFu32ll { unsigned short v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_Us_BFu33 { unsigned short v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_Us_BFu7c { unsigned short v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_Us_BFu7i { unsigned short v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_Us_BFu7ll { unsigned short v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_Us_BFu7s { unsigned short v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_Us_BFu8c { unsigned short v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_Us_BFu8i { unsigned short v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_Us_BFu8ll { unsigned short v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_Us_BFu8s { unsigned short v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_Us_BFu9i { unsigned short v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_Us_BFu9ll { unsigned short v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_Us_BFu9s { unsigned short v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_Us_C { unsigned short v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aUs_Us_D { unsigned short v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aUs_Us_F { unsigned short v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aUs_Us_I { unsigned short v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aUs_Us_Ip { unsigned short v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aUs_Us_L { unsigned short v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aUs_Us_S { unsigned short v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aUs_Us_Uc { unsigned short v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aUs_Us_Ui { unsigned short v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aUs_Us_Ul { unsigned short v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_Us_Us { unsigned short v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aUs_Us_Vp { unsigned short v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aUs_Vp { unsigned short v1; void * v2; };
struct __attribute__((packed)) aUs_Vp_BFu15i { unsigned short v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aUs_Vp_BFu15ll { unsigned short v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUs_Vp_BFu15s { unsigned short v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aUs_Vp_BFu16i { unsigned short v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aUs_Vp_BFu16ll { unsigned short v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUs_Vp_BFu16s { unsigned short v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aUs_Vp_BFu17i { unsigned short v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aUs_Vp_BFu17ll { unsigned short v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUs_Vp_BFu1c { unsigned short v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aUs_Vp_BFu1i { unsigned short v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aUs_Vp_BFu1ll { unsigned short v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUs_Vp_BFu1s { unsigned short v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aUs_Vp_BFu31i { unsigned short v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aUs_Vp_BFu31ll { unsigned short v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUs_Vp_BFu32i { unsigned short v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aUs_Vp_BFu32ll { unsigned short v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUs_Vp_BFu33 { unsigned short v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUs_Vp_BFu7c { unsigned short v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aUs_Vp_BFu7i { unsigned short v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aUs_Vp_BFu7ll { unsigned short v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUs_Vp_BFu7s { unsigned short v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aUs_Vp_BFu8c { unsigned short v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aUs_Vp_BFu8i { unsigned short v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aUs_Vp_BFu8ll { unsigned short v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUs_Vp_BFu8s { unsigned short v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aUs_Vp_BFu9i { unsigned short v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aUs_Vp_BFu9ll { unsigned short v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUs_Vp_BFu9s { unsigned short v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aUs_Vp_C { unsigned short v1; void * v2; char v3; };
struct __attribute__((packed)) aUs_Vp_D { unsigned short v1; void * v2; double v3; };
struct __attribute__((packed)) aUs_Vp_F { unsigned short v1; void * v2; float v3; };
struct __attribute__((packed)) aUs_Vp_I { unsigned short v1; void * v2; int v3; };
struct __attribute__((packed)) aUs_Vp_Ip { unsigned short v1; void * v2; int * v3; };
struct __attribute__((packed)) aUs_Vp_L { unsigned short v1; void * v2; long long v3; };
struct __attribute__((packed)) aUs_Vp_S { unsigned short v1; void * v2; short v3; };
struct __attribute__((packed)) aUs_Vp_Uc { unsigned short v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aUs_Vp_Ui { unsigned short v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aUs_Vp_Ul { unsigned short v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aUs_Vp_Us { unsigned short v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aUs_Vp_Vp { unsigned short v1; void * v2; void * v3; };
struct __attribute__((packed)) aVp { void * v1; };
struct __attribute__((packed)) aVp_BFu15i { void * v1; unsigned int v2:15; };
struct __attribute__((packed)) aVp_BFu15i_BFu15i { void * v1; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu15i_BFu15ll { void * v1; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu15i_BFu15s { void * v1; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu15i_BFu16i { void * v1; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu15i_BFu16ll { void * v1; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu15i_BFu16s { void * v1; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu15i_BFu17i { void * v1; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu15i_BFu17ll { void * v1; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu15i_BFu1c { void * v1; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu15i_BFu1i { void * v1; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu15i_BFu1ll { void * v1; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu15i_BFu1s { void * v1; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu15i_BFu31i { void * v1; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu15i_BFu31ll { void * v1; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu15i_BFu32i { void * v1; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu15i_BFu32ll { void * v1; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu15i_BFu33 { void * v1; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu15i_BFu7c { void * v1; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu15i_BFu7i { void * v1; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu15i_BFu7ll { void * v1; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu15i_BFu7s { void * v1; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu15i_BFu8c { void * v1; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu15i_BFu8i { void * v1; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu15i_BFu8ll { void * v1; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu15i_BFu8s { void * v1; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu15i_BFu9i { void * v1; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu15i_BFu9ll { void * v1; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu15i_BFu9s { void * v1; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu15i_C { void * v1; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aVp_BFu15i_D { void * v1; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aVp_BFu15i_F { void * v1; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aVp_BFu15i_I { void * v1; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aVp_BFu15i_Ip { void * v1; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aVp_BFu15i_L { void * v1; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aVp_BFu15i_S { void * v1; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aVp_BFu15i_Uc { void * v1; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu15i_Ui { void * v1; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu15i_Ul { void * v1; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu15i_Us { void * v1; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu15i_Vp { void * v1; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aVp_BFu15ll { void * v1; unsigned long long v2:15; };
struct __attribute__((packed)) aVp_BFu15ll_BFu15i { void * v1; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu15ll_BFu15ll { void * v1; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu15ll_BFu15s { void * v1; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu15ll_BFu16i { void * v1; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu15ll_BFu16ll { void * v1; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu15ll_BFu16s { void * v1; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu15ll_BFu17i { void * v1; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu15ll_BFu17ll { void * v1; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu15ll_BFu1c { void * v1; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu15ll_BFu1i { void * v1; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu15ll_BFu1ll { void * v1; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu15ll_BFu1s { void * v1; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu15ll_BFu31i { void * v1; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu15ll_BFu31ll { void * v1; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu15ll_BFu32i { void * v1; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu15ll_BFu32ll { void * v1; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu15ll_BFu33 { void * v1; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu15ll_BFu7c { void * v1; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu15ll_BFu7i { void * v1; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu15ll_BFu7ll { void * v1; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu15ll_BFu7s { void * v1; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu15ll_BFu8c { void * v1; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu15ll_BFu8i { void * v1; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu15ll_BFu8ll { void * v1; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu15ll_BFu8s { void * v1; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu15ll_BFu9i { void * v1; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu15ll_BFu9ll { void * v1; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu15ll_BFu9s { void * v1; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu15ll_C { void * v1; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aVp_BFu15ll_D { void * v1; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aVp_BFu15ll_F { void * v1; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aVp_BFu15ll_I { void * v1; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aVp_BFu15ll_Ip { void * v1; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aVp_BFu15ll_L { void * v1; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aVp_BFu15ll_S { void * v1; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aVp_BFu15ll_Uc { void * v1; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu15ll_Ui { void * v1; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu15ll_Ul { void * v1; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu15ll_Us { void * v1; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu15ll_Vp { void * v1; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aVp_BFu15s { void * v1; unsigned short v2:15; };
struct __attribute__((packed)) aVp_BFu15s_BFu15i { void * v1; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu15s_BFu15ll { void * v1; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu15s_BFu15s { void * v1; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu15s_BFu16i { void * v1; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu15s_BFu16ll { void * v1; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu15s_BFu16s { void * v1; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu15s_BFu17i { void * v1; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu15s_BFu17ll { void * v1; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu15s_BFu1c { void * v1; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu15s_BFu1i { void * v1; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu15s_BFu1ll { void * v1; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu15s_BFu1s { void * v1; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu15s_BFu31i { void * v1; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu15s_BFu31ll { void * v1; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu15s_BFu32i { void * v1; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu15s_BFu32ll { void * v1; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu15s_BFu33 { void * v1; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu15s_BFu7c { void * v1; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu15s_BFu7i { void * v1; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu15s_BFu7ll { void * v1; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu15s_BFu7s { void * v1; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu15s_BFu8c { void * v1; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu15s_BFu8i { void * v1; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu15s_BFu8ll { void * v1; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu15s_BFu8s { void * v1; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu15s_BFu9i { void * v1; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu15s_BFu9ll { void * v1; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu15s_BFu9s { void * v1; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu15s_C { void * v1; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aVp_BFu15s_D { void * v1; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aVp_BFu15s_F { void * v1; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aVp_BFu15s_I { void * v1; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aVp_BFu15s_Ip { void * v1; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aVp_BFu15s_L { void * v1; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aVp_BFu15s_S { void * v1; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aVp_BFu15s_Uc { void * v1; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu15s_Ui { void * v1; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu15s_Ul { void * v1; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu15s_Us { void * v1; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu15s_Vp { void * v1; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aVp_BFu16i { void * v1; unsigned int v2:16; };
struct __attribute__((packed)) aVp_BFu16i_BFu15i { void * v1; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu16i_BFu15ll { void * v1; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu16i_BFu15s { void * v1; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu16i_BFu16i { void * v1; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu16i_BFu16ll { void * v1; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu16i_BFu16s { void * v1; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu16i_BFu17i { void * v1; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu16i_BFu17ll { void * v1; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu16i_BFu1c { void * v1; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu16i_BFu1i { void * v1; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu16i_BFu1ll { void * v1; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu16i_BFu1s { void * v1; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu16i_BFu31i { void * v1; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu16i_BFu31ll { void * v1; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu16i_BFu32i { void * v1; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu16i_BFu32ll { void * v1; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu16i_BFu33 { void * v1; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu16i_BFu7c { void * v1; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu16i_BFu7i { void * v1; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu16i_BFu7ll { void * v1; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu16i_BFu7s { void * v1; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu16i_BFu8c { void * v1; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu16i_BFu8i { void * v1; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu16i_BFu8ll { void * v1; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu16i_BFu8s { void * v1; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu16i_BFu9i { void * v1; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu16i_BFu9ll { void * v1; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu16i_BFu9s { void * v1; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu16i_C { void * v1; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aVp_BFu16i_D { void * v1; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aVp_BFu16i_F { void * v1; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aVp_BFu16i_I { void * v1; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aVp_BFu16i_Ip { void * v1; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aVp_BFu16i_L { void * v1; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aVp_BFu16i_S { void * v1; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aVp_BFu16i_Uc { void * v1; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu16i_Ui { void * v1; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu16i_Ul { void * v1; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu16i_Us { void * v1; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu16i_Vp { void * v1; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aVp_BFu16ll { void * v1; unsigned long long v2:16; };
struct __attribute__((packed)) aVp_BFu16ll_BFu15i { void * v1; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu16ll_BFu15ll { void * v1; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu16ll_BFu15s { void * v1; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu16ll_BFu16i { void * v1; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu16ll_BFu16ll { void * v1; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu16ll_BFu16s { void * v1; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu16ll_BFu17i { void * v1; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu16ll_BFu17ll { void * v1; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu16ll_BFu1c { void * v1; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu16ll_BFu1i { void * v1; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu16ll_BFu1ll { void * v1; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu16ll_BFu1s { void * v1; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu16ll_BFu31i { void * v1; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu16ll_BFu31ll { void * v1; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu16ll_BFu32i { void * v1; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu16ll_BFu32ll { void * v1; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu16ll_BFu33 { void * v1; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu16ll_BFu7c { void * v1; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu16ll_BFu7i { void * v1; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu16ll_BFu7ll { void * v1; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu16ll_BFu7s { void * v1; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu16ll_BFu8c { void * v1; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu16ll_BFu8i { void * v1; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu16ll_BFu8ll { void * v1; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu16ll_BFu8s { void * v1; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu16ll_BFu9i { void * v1; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu16ll_BFu9ll { void * v1; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu16ll_BFu9s { void * v1; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu16ll_C { void * v1; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aVp_BFu16ll_D { void * v1; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aVp_BFu16ll_F { void * v1; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aVp_BFu16ll_I { void * v1; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aVp_BFu16ll_Ip { void * v1; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aVp_BFu16ll_L { void * v1; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aVp_BFu16ll_S { void * v1; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aVp_BFu16ll_Uc { void * v1; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu16ll_Ui { void * v1; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu16ll_Ul { void * v1; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu16ll_Us { void * v1; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu16ll_Vp { void * v1; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aVp_BFu16s { void * v1; unsigned short v2:16; };
struct __attribute__((packed)) aVp_BFu16s_BFu15i { void * v1; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu16s_BFu15ll { void * v1; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu16s_BFu15s { void * v1; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu16s_BFu16i { void * v1; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu16s_BFu16ll { void * v1; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu16s_BFu16s { void * v1; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu16s_BFu17i { void * v1; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu16s_BFu17ll { void * v1; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu16s_BFu1c { void * v1; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu16s_BFu1i { void * v1; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu16s_BFu1ll { void * v1; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu16s_BFu1s { void * v1; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu16s_BFu31i { void * v1; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu16s_BFu31ll { void * v1; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu16s_BFu32i { void * v1; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu16s_BFu32ll { void * v1; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu16s_BFu33 { void * v1; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu16s_BFu7c { void * v1; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu16s_BFu7i { void * v1; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu16s_BFu7ll { void * v1; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu16s_BFu7s { void * v1; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu16s_BFu8c { void * v1; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu16s_BFu8i { void * v1; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu16s_BFu8ll { void * v1; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu16s_BFu8s { void * v1; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu16s_BFu9i { void * v1; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu16s_BFu9ll { void * v1; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu16s_BFu9s { void * v1; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu16s_C { void * v1; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aVp_BFu16s_D { void * v1; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aVp_BFu16s_F { void * v1; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aVp_BFu16s_I { void * v1; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aVp_BFu16s_Ip { void * v1; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aVp_BFu16s_L { void * v1; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aVp_BFu16s_S { void * v1; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aVp_BFu16s_Uc { void * v1; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu16s_Ui { void * v1; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu16s_Ul { void * v1; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu16s_Us { void * v1; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu16s_Vp { void * v1; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aVp_BFu17i { void * v1; unsigned int v2:17; };
struct __attribute__((packed)) aVp_BFu17i_BFu15i { void * v1; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu17i_BFu15ll { void * v1; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu17i_BFu15s { void * v1; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu17i_BFu16i { void * v1; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu17i_BFu16ll { void * v1; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu17i_BFu16s { void * v1; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu17i_BFu17i { void * v1; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu17i_BFu17ll { void * v1; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu17i_BFu1c { void * v1; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu17i_BFu1i { void * v1; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu17i_BFu1ll { void * v1; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu17i_BFu1s { void * v1; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu17i_BFu31i { void * v1; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu17i_BFu31ll { void * v1; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu17i_BFu32i { void * v1; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu17i_BFu32ll { void * v1; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu17i_BFu33 { void * v1; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu17i_BFu7c { void * v1; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu17i_BFu7i { void * v1; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu17i_BFu7ll { void * v1; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu17i_BFu7s { void * v1; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu17i_BFu8c { void * v1; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu17i_BFu8i { void * v1; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu17i_BFu8ll { void * v1; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu17i_BFu8s { void * v1; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu17i_BFu9i { void * v1; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu17i_BFu9ll { void * v1; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu17i_BFu9s { void * v1; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu17i_C { void * v1; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aVp_BFu17i_D { void * v1; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aVp_BFu17i_F { void * v1; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aVp_BFu17i_I { void * v1; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aVp_BFu17i_Ip { void * v1; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aVp_BFu17i_L { void * v1; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aVp_BFu17i_S { void * v1; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aVp_BFu17i_Uc { void * v1; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu17i_Ui { void * v1; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu17i_Ul { void * v1; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu17i_Us { void * v1; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu17i_Vp { void * v1; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aVp_BFu17ll { void * v1; unsigned long long v2:17; };
struct __attribute__((packed)) aVp_BFu17ll_BFu15i { void * v1; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu17ll_BFu15ll { void * v1; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu17ll_BFu15s { void * v1; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu17ll_BFu16i { void * v1; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu17ll_BFu16ll { void * v1; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu17ll_BFu16s { void * v1; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu17ll_BFu17i { void * v1; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu17ll_BFu17ll { void * v1; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu17ll_BFu1c { void * v1; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu17ll_BFu1i { void * v1; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu17ll_BFu1ll { void * v1; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu17ll_BFu1s { void * v1; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu17ll_BFu31i { void * v1; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu17ll_BFu31ll { void * v1; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu17ll_BFu32i { void * v1; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu17ll_BFu32ll { void * v1; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu17ll_BFu33 { void * v1; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu17ll_BFu7c { void * v1; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu17ll_BFu7i { void * v1; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu17ll_BFu7ll { void * v1; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu17ll_BFu7s { void * v1; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu17ll_BFu8c { void * v1; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu17ll_BFu8i { void * v1; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu17ll_BFu8ll { void * v1; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu17ll_BFu8s { void * v1; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu17ll_BFu9i { void * v1; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu17ll_BFu9ll { void * v1; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu17ll_BFu9s { void * v1; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu17ll_C { void * v1; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aVp_BFu17ll_D { void * v1; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aVp_BFu17ll_F { void * v1; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aVp_BFu17ll_I { void * v1; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aVp_BFu17ll_Ip { void * v1; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aVp_BFu17ll_L { void * v1; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aVp_BFu17ll_S { void * v1; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aVp_BFu17ll_Uc { void * v1; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu17ll_Ui { void * v1; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu17ll_Ul { void * v1; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu17ll_Us { void * v1; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu17ll_Vp { void * v1; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aVp_BFu1c { void * v1; unsigned char v2:1; };
struct __attribute__((packed)) aVp_BFu1c_BFu15i { void * v1; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu1c_BFu15ll { void * v1; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu1c_BFu15s { void * v1; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu1c_BFu16i { void * v1; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu1c_BFu16ll { void * v1; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu1c_BFu16s { void * v1; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu1c_BFu17i { void * v1; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu1c_BFu17ll { void * v1; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu1c_BFu1c { void * v1; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu1c_BFu1i { void * v1; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu1c_BFu1ll { void * v1; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu1c_BFu1s { void * v1; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu1c_BFu31i { void * v1; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu1c_BFu31ll { void * v1; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu1c_BFu32i { void * v1; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu1c_BFu32ll { void * v1; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu1c_BFu33 { void * v1; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu1c_BFu7c { void * v1; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu1c_BFu7i { void * v1; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu1c_BFu7ll { void * v1; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu1c_BFu7s { void * v1; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu1c_BFu8c { void * v1; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu1c_BFu8i { void * v1; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu1c_BFu8ll { void * v1; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu1c_BFu8s { void * v1; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu1c_BFu9i { void * v1; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu1c_BFu9ll { void * v1; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu1c_BFu9s { void * v1; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu1c_C { void * v1; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aVp_BFu1c_D { void * v1; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aVp_BFu1c_F { void * v1; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aVp_BFu1c_I { void * v1; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aVp_BFu1c_Ip { void * v1; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aVp_BFu1c_L { void * v1; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aVp_BFu1c_S { void * v1; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aVp_BFu1c_Uc { void * v1; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu1c_Ui { void * v1; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu1c_Ul { void * v1; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu1c_Us { void * v1; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu1c_Vp { void * v1; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aVp_BFu1i { void * v1; unsigned int v2:1; };
struct __attribute__((packed)) aVp_BFu1i_BFu15i { void * v1; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu1i_BFu15ll { void * v1; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu1i_BFu15s { void * v1; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu1i_BFu16i { void * v1; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu1i_BFu16ll { void * v1; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu1i_BFu16s { void * v1; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu1i_BFu17i { void * v1; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu1i_BFu17ll { void * v1; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu1i_BFu1c { void * v1; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu1i_BFu1i { void * v1; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu1i_BFu1ll { void * v1; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu1i_BFu1s { void * v1; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu1i_BFu31i { void * v1; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu1i_BFu31ll { void * v1; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu1i_BFu32i { void * v1; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu1i_BFu32ll { void * v1; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu1i_BFu33 { void * v1; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu1i_BFu7c { void * v1; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu1i_BFu7i { void * v1; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu1i_BFu7ll { void * v1; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu1i_BFu7s { void * v1; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu1i_BFu8c { void * v1; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu1i_BFu8i { void * v1; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu1i_BFu8ll { void * v1; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu1i_BFu8s { void * v1; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu1i_BFu9i { void * v1; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu1i_BFu9ll { void * v1; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu1i_BFu9s { void * v1; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu1i_C { void * v1; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aVp_BFu1i_D { void * v1; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aVp_BFu1i_F { void * v1; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aVp_BFu1i_I { void * v1; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aVp_BFu1i_Ip { void * v1; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aVp_BFu1i_L { void * v1; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aVp_BFu1i_S { void * v1; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aVp_BFu1i_Uc { void * v1; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu1i_Ui { void * v1; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu1i_Ul { void * v1; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu1i_Us { void * v1; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu1i_Vp { void * v1; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aVp_BFu1ll { void * v1; unsigned long long v2:1; };
struct __attribute__((packed)) aVp_BFu1ll_BFu15i { void * v1; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu1ll_BFu15ll { void * v1; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu1ll_BFu15s { void * v1; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu1ll_BFu16i { void * v1; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu1ll_BFu16ll { void * v1; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu1ll_BFu16s { void * v1; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu1ll_BFu17i { void * v1; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu1ll_BFu17ll { void * v1; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu1ll_BFu1c { void * v1; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu1ll_BFu1i { void * v1; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu1ll_BFu1ll { void * v1; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu1ll_BFu1s { void * v1; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu1ll_BFu31i { void * v1; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu1ll_BFu31ll { void * v1; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu1ll_BFu32i { void * v1; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu1ll_BFu32ll { void * v1; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu1ll_BFu33 { void * v1; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu1ll_BFu7c { void * v1; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu1ll_BFu7i { void * v1; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu1ll_BFu7ll { void * v1; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu1ll_BFu7s { void * v1; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu1ll_BFu8c { void * v1; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu1ll_BFu8i { void * v1; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu1ll_BFu8ll { void * v1; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu1ll_BFu8s { void * v1; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu1ll_BFu9i { void * v1; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu1ll_BFu9ll { void * v1; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu1ll_BFu9s { void * v1; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu1ll_C { void * v1; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aVp_BFu1ll_D { void * v1; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aVp_BFu1ll_F { void * v1; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aVp_BFu1ll_I { void * v1; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aVp_BFu1ll_Ip { void * v1; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aVp_BFu1ll_L { void * v1; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aVp_BFu1ll_S { void * v1; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aVp_BFu1ll_Uc { void * v1; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu1ll_Ui { void * v1; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu1ll_Ul { void * v1; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu1ll_Us { void * v1; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu1ll_Vp { void * v1; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aVp_BFu1s { void * v1; unsigned short v2:1; };
struct __attribute__((packed)) aVp_BFu1s_BFu15i { void * v1; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu1s_BFu15ll { void * v1; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu1s_BFu15s { void * v1; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu1s_BFu16i { void * v1; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu1s_BFu16ll { void * v1; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu1s_BFu16s { void * v1; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu1s_BFu17i { void * v1; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu1s_BFu17ll { void * v1; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu1s_BFu1c { void * v1; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu1s_BFu1i { void * v1; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu1s_BFu1ll { void * v1; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu1s_BFu1s { void * v1; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu1s_BFu31i { void * v1; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu1s_BFu31ll { void * v1; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu1s_BFu32i { void * v1; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu1s_BFu32ll { void * v1; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu1s_BFu33 { void * v1; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu1s_BFu7c { void * v1; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu1s_BFu7i { void * v1; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu1s_BFu7ll { void * v1; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu1s_BFu7s { void * v1; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu1s_BFu8c { void * v1; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu1s_BFu8i { void * v1; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu1s_BFu8ll { void * v1; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu1s_BFu8s { void * v1; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu1s_BFu9i { void * v1; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu1s_BFu9ll { void * v1; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu1s_BFu9s { void * v1; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu1s_C { void * v1; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aVp_BFu1s_D { void * v1; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aVp_BFu1s_F { void * v1; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aVp_BFu1s_I { void * v1; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aVp_BFu1s_Ip { void * v1; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aVp_BFu1s_L { void * v1; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aVp_BFu1s_S { void * v1; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aVp_BFu1s_Uc { void * v1; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu1s_Ui { void * v1; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu1s_Ul { void * v1; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu1s_Us { void * v1; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu1s_Vp { void * v1; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aVp_BFu31i { void * v1; unsigned int v2:31; };
struct __attribute__((packed)) aVp_BFu31i_BFu15i { void * v1; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu31i_BFu15ll { void * v1; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu31i_BFu15s { void * v1; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu31i_BFu16i { void * v1; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu31i_BFu16ll { void * v1; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu31i_BFu16s { void * v1; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu31i_BFu17i { void * v1; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu31i_BFu17ll { void * v1; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu31i_BFu1c { void * v1; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu31i_BFu1i { void * v1; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu31i_BFu1ll { void * v1; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu31i_BFu1s { void * v1; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu31i_BFu31i { void * v1; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu31i_BFu31ll { void * v1; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu31i_BFu32i { void * v1; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu31i_BFu32ll { void * v1; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu31i_BFu33 { void * v1; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu31i_BFu7c { void * v1; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu31i_BFu7i { void * v1; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu31i_BFu7ll { void * v1; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu31i_BFu7s { void * v1; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu31i_BFu8c { void * v1; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu31i_BFu8i { void * v1; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu31i_BFu8ll { void * v1; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu31i_BFu8s { void * v1; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu31i_BFu9i { void * v1; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu31i_BFu9ll { void * v1; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu31i_BFu9s { void * v1; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu31i_C { void * v1; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aVp_BFu31i_D { void * v1; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aVp_BFu31i_F { void * v1; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aVp_BFu31i_I { void * v1; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aVp_BFu31i_Ip { void * v1; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aVp_BFu31i_L { void * v1; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aVp_BFu31i_S { void * v1; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aVp_BFu31i_Uc { void * v1; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu31i_Ui { void * v1; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu31i_Ul { void * v1; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu31i_Us { void * v1; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu31i_Vp { void * v1; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aVp_BFu31ll { void * v1; unsigned long long v2:31; };
struct __attribute__((packed)) aVp_BFu31ll_BFu15i { void * v1; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu31ll_BFu15ll { void * v1; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu31ll_BFu15s { void * v1; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu31ll_BFu16i { void * v1; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu31ll_BFu16ll { void * v1; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu31ll_BFu16s { void * v1; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu31ll_BFu17i { void * v1; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu31ll_BFu17ll { void * v1; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu31ll_BFu1c { void * v1; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu31ll_BFu1i { void * v1; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu31ll_BFu1ll { void * v1; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu31ll_BFu1s { void * v1; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu31ll_BFu31i { void * v1; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu31ll_BFu31ll { void * v1; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu31ll_BFu32i { void * v1; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu31ll_BFu32ll { void * v1; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu31ll_BFu33 { void * v1; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu31ll_BFu7c { void * v1; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu31ll_BFu7i { void * v1; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu31ll_BFu7ll { void * v1; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu31ll_BFu7s { void * v1; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu31ll_BFu8c { void * v1; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu31ll_BFu8i { void * v1; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu31ll_BFu8ll { void * v1; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu31ll_BFu8s { void * v1; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu31ll_BFu9i { void * v1; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu31ll_BFu9ll { void * v1; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu31ll_BFu9s { void * v1; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu31ll_C { void * v1; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aVp_BFu31ll_D { void * v1; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aVp_BFu31ll_F { void * v1; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aVp_BFu31ll_I { void * v1; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aVp_BFu31ll_Ip { void * v1; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aVp_BFu31ll_L { void * v1; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aVp_BFu31ll_S { void * v1; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aVp_BFu31ll_Uc { void * v1; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu31ll_Ui { void * v1; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu31ll_Ul { void * v1; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu31ll_Us { void * v1; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu31ll_Vp { void * v1; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aVp_BFu32i { void * v1; unsigned int v2:32; };
struct __attribute__((packed)) aVp_BFu32i_BFu15i { void * v1; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu32i_BFu15ll { void * v1; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu32i_BFu15s { void * v1; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu32i_BFu16i { void * v1; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu32i_BFu16ll { void * v1; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu32i_BFu16s { void * v1; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu32i_BFu17i { void * v1; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu32i_BFu17ll { void * v1; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu32i_BFu1c { void * v1; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu32i_BFu1i { void * v1; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu32i_BFu1ll { void * v1; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu32i_BFu1s { void * v1; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu32i_BFu31i { void * v1; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu32i_BFu31ll { void * v1; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu32i_BFu32i { void * v1; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu32i_BFu32ll { void * v1; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu32i_BFu33 { void * v1; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu32i_BFu7c { void * v1; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aVp_BFu32i_BFu7i { void * v1; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aVp_BFu32i_BFu7ll { void * v1; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aVp_BFu32i_BFu7s { void * v1; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aVp_BFu32i_BFu8c { void * v1; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aVp_BFu32i_BFu8i { void * v1; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aVp_BFu32i_BFu8ll { void * v1; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aVp_BFu32i_BFu8s { void * v1; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aVp_BFu32i_BFu9i { void * v1; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aVp_BFu32i_BFu9ll { void * v1; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aVp_BFu32i_BFu9s { void * v1; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aVp_BFu32i_C { void * v1; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aVp_BFu32i_D { void * v1; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aVp_BFu32i_F { void * v1; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aVp_BFu32i_I { void * v1; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aVp_BFu32i_Ip { void * v1; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aVp_BFu32i_L { void * v1; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aVp_BFu32i_S { void * v1; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aVp_BFu32i_Uc { void * v1; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aVp_BFu32i_Ui { void * v1; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aVp_BFu32i_Ul { void * v1; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aVp_BFu32i_Us { void * v1; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aVp_BFu32i_Vp { void * v1; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aVp_BFu32ll { void * v1; unsigned long long v2:32; };
struct __attribute__((packed)) aVp_BFu32ll_BFu15i { void * v1; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aVp_BFu32ll_BFu15ll { void * v1; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aVp_BFu32ll_BFu15s { void * v1; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aVp_BFu32ll_BFu16i { void * v1; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aVp_BFu32ll_BFu16ll { void * v1; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aVp_BFu32ll_BFu16s { void * v1; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aVp_BFu32ll_BFu17i { void * v1; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aVp_BFu32ll_BFu17ll { void * v1; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aVp_BFu32ll_BFu1c { void * v1; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aVp_BFu32ll_BFu1i { void * v1; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aVp_BFu32ll_BFu1ll { void * v1; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aVp_BFu32ll_BFu1s { void * v1; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aVp_BFu32ll_BFu31i { void * v1; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aVp_BFu32ll_BFu31ll { void * v1; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aVp_BFu32ll_BFu32i { void * v1; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aVp_BFu32ll_BFu32ll { void * v1; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aVp_BFu32ll_BFu33 { void * v1; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aVp_BFu32ll_BFu7c { void * v1; unsigned long long v2:32; unsigned char v3:7; };


static void Test_aUl_BFu8i_BFu31ll()
{
  {
    init_simple_test("aUl_BFu8i_BFu31ll");
    static STRUCT_IF_C aUl_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUl_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUl_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu31ll, aUl_BFu8i_BFu31ll)
//============================================================================



static void Test_aUl_BFu8i_BFu32i()
{
  {
    init_simple_test("aUl_BFu8i_BFu32i");
    static STRUCT_IF_C aUl_BFu8i_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUl_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUl_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu32i, aUl_BFu8i_BFu32i)
//============================================================================



static void Test_aUl_BFu8i_BFu32ll()
{
  {
    init_simple_test("aUl_BFu8i_BFu32ll");
    static STRUCT_IF_C aUl_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUl_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUl_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu32ll, aUl_BFu8i_BFu32ll)
//============================================================================



static void Test_aUl_BFu8i_BFu33()
{
  {
    init_simple_test("aUl_BFu8i_BFu33");
    static STRUCT_IF_C aUl_BFu8i_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu8i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aUl_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aUl_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu33, aUl_BFu8i_BFu33)
//============================================================================



static void Test_aUl_BFu8i_BFu7c()
{
  {
    init_simple_test("aUl_BFu8i_BFu7c");
    static STRUCT_IF_C aUl_BFu8i_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu7c, aUl_BFu8i_BFu7c)
//============================================================================



static void Test_aUl_BFu8i_BFu7i()
{
  {
    init_simple_test("aUl_BFu8i_BFu7i");
    static STRUCT_IF_C aUl_BFu8i_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu7i, aUl_BFu8i_BFu7i)
//============================================================================



static void Test_aUl_BFu8i_BFu7ll()
{
  {
    init_simple_test("aUl_BFu8i_BFu7ll");
    static STRUCT_IF_C aUl_BFu8i_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu7ll, aUl_BFu8i_BFu7ll)
//============================================================================



static void Test_aUl_BFu8i_BFu7s()
{
  {
    init_simple_test("aUl_BFu8i_BFu7s");
    static STRUCT_IF_C aUl_BFu8i_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu7s, aUl_BFu8i_BFu7s)
//============================================================================



static void Test_aUl_BFu8i_BFu8c()
{
  {
    init_simple_test("aUl_BFu8i_BFu8c");
    static STRUCT_IF_C aUl_BFu8i_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu8c, aUl_BFu8i_BFu8c)
//============================================================================



static void Test_aUl_BFu8i_BFu8i()
{
  {
    init_simple_test("aUl_BFu8i_BFu8i");
    static STRUCT_IF_C aUl_BFu8i_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu8i, aUl_BFu8i_BFu8i)
//============================================================================



static void Test_aUl_BFu8i_BFu8ll()
{
  {
    init_simple_test("aUl_BFu8i_BFu8ll");
    static STRUCT_IF_C aUl_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu8ll, aUl_BFu8i_BFu8ll)
//============================================================================



static void Test_aUl_BFu8i_BFu8s()
{
  {
    init_simple_test("aUl_BFu8i_BFu8s");
    static STRUCT_IF_C aUl_BFu8i_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu8s, aUl_BFu8i_BFu8s)
//============================================================================



static void Test_aUl_BFu8i_BFu9i()
{
  {
    init_simple_test("aUl_BFu8i_BFu9i");
    static STRUCT_IF_C aUl_BFu8i_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu9i, aUl_BFu8i_BFu9i)
//============================================================================



static void Test_aUl_BFu8i_BFu9ll()
{
  {
    init_simple_test("aUl_BFu8i_BFu9ll");
    static STRUCT_IF_C aUl_BFu8i_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu9ll, aUl_BFu8i_BFu9ll)
//============================================================================



static void Test_aUl_BFu8i_BFu9s()
{
  {
    init_simple_test("aUl_BFu8i_BFu9s");
    static STRUCT_IF_C aUl_BFu8i_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_BFu9s, aUl_BFu8i_BFu9s)
//============================================================================



static void Test_aUl_BFu8i_C()
{
  {
    init_simple_test("aUl_BFu8i_C");
    static STRUCT_IF_C aUl_BFu8i_C lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_C)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_C");
    check_field_offset(lv, v3, 9, "aUl_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_C, aUl_BFu8i_C)
//============================================================================



static void Test_aUl_BFu8i_D()
{
  {
    init_simple_test("aUl_BFu8i_D");
    static STRUCT_IF_C aUl_BFu8i_D lv;
    check2(sizeof(lv), 17, "sizeof(aUl_BFu8i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_D)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_D");
    check_field_offset(lv, v3, 9, "aUl_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_D, aUl_BFu8i_D)
//============================================================================



static void Test_aUl_BFu8i_F()
{
  {
    init_simple_test("aUl_BFu8i_F");
    static STRUCT_IF_C aUl_BFu8i_F lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_F)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_F");
    check_field_offset(lv, v3, 9, "aUl_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_F, aUl_BFu8i_F)
//============================================================================



static void Test_aUl_BFu8i_I()
{
  {
    init_simple_test("aUl_BFu8i_I");
    static STRUCT_IF_C aUl_BFu8i_I lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_I)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_I");
    check_field_offset(lv, v3, 9, "aUl_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_I, aUl_BFu8i_I)
//============================================================================



static void Test_aUl_BFu8i_Ip()
{
  {
    init_simple_test("aUl_BFu8i_Ip");
    static STRUCT_IF_C aUl_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_BFu8i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_Ip");
    check_field_offset(lv, v3, 9, "aUl_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_Ip, aUl_BFu8i_Ip)
//============================================================================



static void Test_aUl_BFu8i_L()
{
  {
    init_simple_test("aUl_BFu8i_L");
    static STRUCT_IF_C aUl_BFu8i_L lv;
    check2(sizeof(lv), 17, "sizeof(aUl_BFu8i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_L)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_L");
    check_field_offset(lv, v3, 9, "aUl_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_L, aUl_BFu8i_L)
//============================================================================



static void Test_aUl_BFu8i_S()
{
  {
    init_simple_test("aUl_BFu8i_S");
    static STRUCT_IF_C aUl_BFu8i_S lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_S)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_S");
    check_field_offset(lv, v3, 9, "aUl_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_S, aUl_BFu8i_S)
//============================================================================



static void Test_aUl_BFu8i_Uc()
{
  {
    init_simple_test("aUl_BFu8i_Uc");
    static STRUCT_IF_C aUl_BFu8i_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_Uc");
    check_field_offset(lv, v3, 9, "aUl_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_Uc, aUl_BFu8i_Uc)
//============================================================================



static void Test_aUl_BFu8i_Ui()
{
  {
    init_simple_test("aUl_BFu8i_Ui");
    static STRUCT_IF_C aUl_BFu8i_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_Ui");
    check_field_offset(lv, v3, 9, "aUl_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_Ui, aUl_BFu8i_Ui)
//============================================================================



static void Test_aUl_BFu8i_Ul()
{
  {
    init_simple_test("aUl_BFu8i_Ul");
    static STRUCT_IF_C aUl_BFu8i_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aUl_BFu8i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_Ul");
    check_field_offset(lv, v3, 9, "aUl_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_Ul, aUl_BFu8i_Ul)
//============================================================================



static void Test_aUl_BFu8i_Us()
{
  {
    init_simple_test("aUl_BFu8i_Us");
    static STRUCT_IF_C aUl_BFu8i_Us lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_Us");
    check_field_offset(lv, v3, 9, "aUl_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_Us, aUl_BFu8i_Us)
//============================================================================



static void Test_aUl_BFu8i_Vp()
{
  {
    init_simple_test("aUl_BFu8i_Vp");
    static STRUCT_IF_C aUl_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_BFu8i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "aUl_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8i_Vp");
    check_field_offset(lv, v3, 9, "aUl_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8i_Vp, aUl_BFu8i_Vp)
//============================================================================



static void Test_aUl_BFu8ll()
{
  {
    init_simple_test("aUl_BFu8ll");
    static STRUCT_IF_C aUl_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aUl_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll, aUl_BFu8ll)
//============================================================================



static void Test_aUl_BFu8ll_BFu15i()
{
  {
    init_simple_test("aUl_BFu8ll_BFu15i");
    static STRUCT_IF_C aUl_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUl_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUl_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu15i, aUl_BFu8ll_BFu15i)
//============================================================================



static void Test_aUl_BFu8ll_BFu15ll()
{
  {
    init_simple_test("aUl_BFu8ll_BFu15ll");
    static STRUCT_IF_C aUl_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUl_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUl_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu15ll, aUl_BFu8ll_BFu15ll)
//============================================================================



static void Test_aUl_BFu8ll_BFu15s()
{
  {
    init_simple_test("aUl_BFu8ll_BFu15s");
    static STRUCT_IF_C aUl_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUl_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUl_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu15s, aUl_BFu8ll_BFu15s)
//============================================================================



static void Test_aUl_BFu8ll_BFu16i()
{
  {
    init_simple_test("aUl_BFu8ll_BFu16i");
    static STRUCT_IF_C aUl_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUl_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUl_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu16i, aUl_BFu8ll_BFu16i)
//============================================================================



static void Test_aUl_BFu8ll_BFu16ll()
{
  {
    init_simple_test("aUl_BFu8ll_BFu16ll");
    static STRUCT_IF_C aUl_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUl_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUl_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu16ll, aUl_BFu8ll_BFu16ll)
//============================================================================



static void Test_aUl_BFu8ll_BFu16s()
{
  {
    init_simple_test("aUl_BFu8ll_BFu16s");
    static STRUCT_IF_C aUl_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUl_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUl_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu16s, aUl_BFu8ll_BFu16s)
//============================================================================



static void Test_aUl_BFu8ll_BFu17i()
{
  {
    init_simple_test("aUl_BFu8ll_BFu17i");
    static STRUCT_IF_C aUl_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu8ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aUl_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aUl_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu17i, aUl_BFu8ll_BFu17i)
//============================================================================



static void Test_aUl_BFu8ll_BFu17ll()
{
  {
    init_simple_test("aUl_BFu8ll_BFu17ll");
    static STRUCT_IF_C aUl_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aUl_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aUl_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu17ll, aUl_BFu8ll_BFu17ll)
//============================================================================



static void Test_aUl_BFu8ll_BFu1c()
{
  {
    init_simple_test("aUl_BFu8ll_BFu1c");
    static STRUCT_IF_C aUl_BFu8ll_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu1c, aUl_BFu8ll_BFu1c)
//============================================================================



static void Test_aUl_BFu8ll_BFu1i()
{
  {
    init_simple_test("aUl_BFu8ll_BFu1i");
    static STRUCT_IF_C aUl_BFu8ll_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu1i, aUl_BFu8ll_BFu1i)
//============================================================================



static void Test_aUl_BFu8ll_BFu1ll()
{
  {
    init_simple_test("aUl_BFu8ll_BFu1ll");
    static STRUCT_IF_C aUl_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu1ll, aUl_BFu8ll_BFu1ll)
//============================================================================



static void Test_aUl_BFu8ll_BFu1s()
{
  {
    init_simple_test("aUl_BFu8ll_BFu1s");
    static STRUCT_IF_C aUl_BFu8ll_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu1s, aUl_BFu8ll_BFu1s)
//============================================================================



static void Test_aUl_BFu8ll_BFu31i()
{
  {
    init_simple_test("aUl_BFu8ll_BFu31i");
    static STRUCT_IF_C aUl_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUl_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUl_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu31i, aUl_BFu8ll_BFu31i)
//============================================================================



static void Test_aUl_BFu8ll_BFu31ll()
{
  {
    init_simple_test("aUl_BFu8ll_BFu31ll");
    static STRUCT_IF_C aUl_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUl_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUl_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu31ll, aUl_BFu8ll_BFu31ll)
//============================================================================



static void Test_aUl_BFu8ll_BFu32i()
{
  {
    init_simple_test("aUl_BFu8ll_BFu32i");
    static STRUCT_IF_C aUl_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUl_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUl_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu32i, aUl_BFu8ll_BFu32i)
//============================================================================



static void Test_aUl_BFu8ll_BFu32ll()
{
  {
    init_simple_test("aUl_BFu8ll_BFu32ll");
    static STRUCT_IF_C aUl_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUl_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUl_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu32ll, aUl_BFu8ll_BFu32ll)
//============================================================================



static void Test_aUl_BFu8ll_BFu33()
{
  {
    init_simple_test("aUl_BFu8ll_BFu33");
    static STRUCT_IF_C aUl_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu8ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aUl_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aUl_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu33, aUl_BFu8ll_BFu33)
//============================================================================



static void Test_aUl_BFu8ll_BFu7c()
{
  {
    init_simple_test("aUl_BFu8ll_BFu7c");
    static STRUCT_IF_C aUl_BFu8ll_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu7c, aUl_BFu8ll_BFu7c)
//============================================================================



static void Test_aUl_BFu8ll_BFu7i()
{
  {
    init_simple_test("aUl_BFu8ll_BFu7i");
    static STRUCT_IF_C aUl_BFu8ll_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu7i, aUl_BFu8ll_BFu7i)
//============================================================================



static void Test_aUl_BFu8ll_BFu7ll()
{
  {
    init_simple_test("aUl_BFu8ll_BFu7ll");
    static STRUCT_IF_C aUl_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu7ll, aUl_BFu8ll_BFu7ll)
//============================================================================



static void Test_aUl_BFu8ll_BFu7s()
{
  {
    init_simple_test("aUl_BFu8ll_BFu7s");
    static STRUCT_IF_C aUl_BFu8ll_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu7s, aUl_BFu8ll_BFu7s)
//============================================================================



static void Test_aUl_BFu8ll_BFu8c()
{
  {
    init_simple_test("aUl_BFu8ll_BFu8c");
    static STRUCT_IF_C aUl_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu8c, aUl_BFu8ll_BFu8c)
//============================================================================



static void Test_aUl_BFu8ll_BFu8i()
{
  {
    init_simple_test("aUl_BFu8ll_BFu8i");
    static STRUCT_IF_C aUl_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu8i, aUl_BFu8ll_BFu8i)
//============================================================================



static void Test_aUl_BFu8ll_BFu8ll()
{
  {
    init_simple_test("aUl_BFu8ll_BFu8ll");
    static STRUCT_IF_C aUl_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu8ll, aUl_BFu8ll_BFu8ll)
//============================================================================



static void Test_aUl_BFu8ll_BFu8s()
{
  {
    init_simple_test("aUl_BFu8ll_BFu8s");
    static STRUCT_IF_C aUl_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu8s, aUl_BFu8ll_BFu8s)
//============================================================================



static void Test_aUl_BFu8ll_BFu9i()
{
  {
    init_simple_test("aUl_BFu8ll_BFu9i");
    static STRUCT_IF_C aUl_BFu8ll_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu9i, aUl_BFu8ll_BFu9i)
//============================================================================



static void Test_aUl_BFu8ll_BFu9ll()
{
  {
    init_simple_test("aUl_BFu8ll_BFu9ll");
    static STRUCT_IF_C aUl_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu9ll, aUl_BFu8ll_BFu9ll)
//============================================================================



static void Test_aUl_BFu8ll_BFu9s()
{
  {
    init_simple_test("aUl_BFu8ll_BFu9s");
    static STRUCT_IF_C aUl_BFu8ll_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_BFu9s, aUl_BFu8ll_BFu9s)
//============================================================================



static void Test_aUl_BFu8ll_C()
{
  {
    init_simple_test("aUl_BFu8ll_C");
    static STRUCT_IF_C aUl_BFu8ll_C lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_C");
    check_field_offset(lv, v3, 9, "aUl_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_C, aUl_BFu8ll_C)
//============================================================================



static void Test_aUl_BFu8ll_D()
{
  {
    init_simple_test("aUl_BFu8ll_D");
    static STRUCT_IF_C aUl_BFu8ll_D lv;
    check2(sizeof(lv), 17, "sizeof(aUl_BFu8ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_D");
    check_field_offset(lv, v3, 9, "aUl_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_D, aUl_BFu8ll_D)
//============================================================================



static void Test_aUl_BFu8ll_F()
{
  {
    init_simple_test("aUl_BFu8ll_F");
    static STRUCT_IF_C aUl_BFu8ll_F lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_F");
    check_field_offset(lv, v3, 9, "aUl_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_F, aUl_BFu8ll_F)
//============================================================================



static void Test_aUl_BFu8ll_I()
{
  {
    init_simple_test("aUl_BFu8ll_I");
    static STRUCT_IF_C aUl_BFu8ll_I lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_I");
    check_field_offset(lv, v3, 9, "aUl_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_I, aUl_BFu8ll_I)
//============================================================================



static void Test_aUl_BFu8ll_Ip()
{
  {
    init_simple_test("aUl_BFu8ll_Ip");
    static STRUCT_IF_C aUl_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_BFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_Ip");
    check_field_offset(lv, v3, 9, "aUl_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_Ip, aUl_BFu8ll_Ip)
//============================================================================



static void Test_aUl_BFu8ll_L()
{
  {
    init_simple_test("aUl_BFu8ll_L");
    static STRUCT_IF_C aUl_BFu8ll_L lv;
    check2(sizeof(lv), 17, "sizeof(aUl_BFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_L");
    check_field_offset(lv, v3, 9, "aUl_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_L, aUl_BFu8ll_L)
//============================================================================



static void Test_aUl_BFu8ll_S()
{
  {
    init_simple_test("aUl_BFu8ll_S");
    static STRUCT_IF_C aUl_BFu8ll_S lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_S");
    check_field_offset(lv, v3, 9, "aUl_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_S, aUl_BFu8ll_S)
//============================================================================



static void Test_aUl_BFu8ll_Uc()
{
  {
    init_simple_test("aUl_BFu8ll_Uc");
    static STRUCT_IF_C aUl_BFu8ll_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_Uc");
    check_field_offset(lv, v3, 9, "aUl_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_Uc, aUl_BFu8ll_Uc)
//============================================================================



static void Test_aUl_BFu8ll_Ui()
{
  {
    init_simple_test("aUl_BFu8ll_Ui");
    static STRUCT_IF_C aUl_BFu8ll_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_Ui");
    check_field_offset(lv, v3, 9, "aUl_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_Ui, aUl_BFu8ll_Ui)
//============================================================================



static void Test_aUl_BFu8ll_Ul()
{
  {
    init_simple_test("aUl_BFu8ll_Ul");
    static STRUCT_IF_C aUl_BFu8ll_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aUl_BFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_Ul");
    check_field_offset(lv, v3, 9, "aUl_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_Ul, aUl_BFu8ll_Ul)
//============================================================================



static void Test_aUl_BFu8ll_Us()
{
  {
    init_simple_test("aUl_BFu8ll_Us");
    static STRUCT_IF_C aUl_BFu8ll_Us lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_Us");
    check_field_offset(lv, v3, 9, "aUl_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_Us, aUl_BFu8ll_Us)
//============================================================================



static void Test_aUl_BFu8ll_Vp()
{
  {
    init_simple_test("aUl_BFu8ll_Vp");
    static STRUCT_IF_C aUl_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_BFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "aUl_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8ll_Vp");
    check_field_offset(lv, v3, 9, "aUl_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8ll_Vp, aUl_BFu8ll_Vp)
//============================================================================



static void Test_aUl_BFu8s()
{
  {
    init_simple_test("aUl_BFu8s");
    static STRUCT_IF_C aUl_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aUl_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s, aUl_BFu8s)
//============================================================================



static void Test_aUl_BFu8s_BFu15i()
{
  {
    init_simple_test("aUl_BFu8s_BFu15i");
    static STRUCT_IF_C aUl_BFu8s_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUl_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUl_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu15i, aUl_BFu8s_BFu15i)
//============================================================================



static void Test_aUl_BFu8s_BFu15ll()
{
  {
    init_simple_test("aUl_BFu8s_BFu15ll");
    static STRUCT_IF_C aUl_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUl_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUl_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu15ll, aUl_BFu8s_BFu15ll)
//============================================================================



static void Test_aUl_BFu8s_BFu15s()
{
  {
    init_simple_test("aUl_BFu8s_BFu15s");
    static STRUCT_IF_C aUl_BFu8s_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUl_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUl_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu15s, aUl_BFu8s_BFu15s)
//============================================================================



static void Test_aUl_BFu8s_BFu16i()
{
  {
    init_simple_test("aUl_BFu8s_BFu16i");
    static STRUCT_IF_C aUl_BFu8s_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUl_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUl_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu16i, aUl_BFu8s_BFu16i)
//============================================================================



static void Test_aUl_BFu8s_BFu16ll()
{
  {
    init_simple_test("aUl_BFu8s_BFu16ll");
    static STRUCT_IF_C aUl_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUl_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUl_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu16ll, aUl_BFu8s_BFu16ll)
//============================================================================



static void Test_aUl_BFu8s_BFu16s()
{
  {
    init_simple_test("aUl_BFu8s_BFu16s");
    static STRUCT_IF_C aUl_BFu8s_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUl_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUl_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu16s, aUl_BFu8s_BFu16s)
//============================================================================



static void Test_aUl_BFu8s_BFu17i()
{
  {
    init_simple_test("aUl_BFu8s_BFu17i");
    static STRUCT_IF_C aUl_BFu8s_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu8s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aUl_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aUl_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu17i, aUl_BFu8s_BFu17i)
//============================================================================



static void Test_aUl_BFu8s_BFu17ll()
{
  {
    init_simple_test("aUl_BFu8s_BFu17ll");
    static STRUCT_IF_C aUl_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu8s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aUl_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aUl_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu17ll, aUl_BFu8s_BFu17ll)
//============================================================================



static void Test_aUl_BFu8s_BFu1c()
{
  {
    init_simple_test("aUl_BFu8s_BFu1c");
    static STRUCT_IF_C aUl_BFu8s_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu1c, aUl_BFu8s_BFu1c)
//============================================================================



static void Test_aUl_BFu8s_BFu1i()
{
  {
    init_simple_test("aUl_BFu8s_BFu1i");
    static STRUCT_IF_C aUl_BFu8s_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu1i, aUl_BFu8s_BFu1i)
//============================================================================



static void Test_aUl_BFu8s_BFu1ll()
{
  {
    init_simple_test("aUl_BFu8s_BFu1ll");
    static STRUCT_IF_C aUl_BFu8s_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu1ll, aUl_BFu8s_BFu1ll)
//============================================================================



static void Test_aUl_BFu8s_BFu1s()
{
  {
    init_simple_test("aUl_BFu8s_BFu1s");
    static STRUCT_IF_C aUl_BFu8s_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu1s, aUl_BFu8s_BFu1s)
//============================================================================



static void Test_aUl_BFu8s_BFu31i()
{
  {
    init_simple_test("aUl_BFu8s_BFu31i");
    static STRUCT_IF_C aUl_BFu8s_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUl_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUl_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu31i, aUl_BFu8s_BFu31i)
//============================================================================



static void Test_aUl_BFu8s_BFu31ll()
{
  {
    init_simple_test("aUl_BFu8s_BFu31ll");
    static STRUCT_IF_C aUl_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUl_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUl_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu31ll, aUl_BFu8s_BFu31ll)
//============================================================================



static void Test_aUl_BFu8s_BFu32i()
{
  {
    init_simple_test("aUl_BFu8s_BFu32i");
    static STRUCT_IF_C aUl_BFu8s_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUl_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUl_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu32i, aUl_BFu8s_BFu32i)
//============================================================================



static void Test_aUl_BFu8s_BFu32ll()
{
  {
    init_simple_test("aUl_BFu8s_BFu32ll");
    static STRUCT_IF_C aUl_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUl_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUl_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu32ll, aUl_BFu8s_BFu32ll)
//============================================================================



static void Test_aUl_BFu8s_BFu33()
{
  {
    init_simple_test("aUl_BFu8s_BFu33");
    static STRUCT_IF_C aUl_BFu8s_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu8s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aUl_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aUl_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu33, aUl_BFu8s_BFu33)
//============================================================================



static void Test_aUl_BFu8s_BFu7c()
{
  {
    init_simple_test("aUl_BFu8s_BFu7c");
    static STRUCT_IF_C aUl_BFu8s_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu7c, aUl_BFu8s_BFu7c)
//============================================================================



static void Test_aUl_BFu8s_BFu7i()
{
  {
    init_simple_test("aUl_BFu8s_BFu7i");
    static STRUCT_IF_C aUl_BFu8s_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu7i, aUl_BFu8s_BFu7i)
//============================================================================



static void Test_aUl_BFu8s_BFu7ll()
{
  {
    init_simple_test("aUl_BFu8s_BFu7ll");
    static STRUCT_IF_C aUl_BFu8s_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu7ll, aUl_BFu8s_BFu7ll)
//============================================================================



static void Test_aUl_BFu8s_BFu7s()
{
  {
    init_simple_test("aUl_BFu8s_BFu7s");
    static STRUCT_IF_C aUl_BFu8s_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu7s, aUl_BFu8s_BFu7s)
//============================================================================



static void Test_aUl_BFu8s_BFu8c()
{
  {
    init_simple_test("aUl_BFu8s_BFu8c");
    static STRUCT_IF_C aUl_BFu8s_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu8c, aUl_BFu8s_BFu8c)
//============================================================================



static void Test_aUl_BFu8s_BFu8i()
{
  {
    init_simple_test("aUl_BFu8s_BFu8i");
    static STRUCT_IF_C aUl_BFu8s_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu8i, aUl_BFu8s_BFu8i)
//============================================================================



static void Test_aUl_BFu8s_BFu8ll()
{
  {
    init_simple_test("aUl_BFu8s_BFu8ll");
    static STRUCT_IF_C aUl_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu8ll, aUl_BFu8s_BFu8ll)
//============================================================================



static void Test_aUl_BFu8s_BFu8s()
{
  {
    init_simple_test("aUl_BFu8s_BFu8s");
    static STRUCT_IF_C aUl_BFu8s_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu8s, aUl_BFu8s_BFu8s)
//============================================================================



static void Test_aUl_BFu8s_BFu9i()
{
  {
    init_simple_test("aUl_BFu8s_BFu9i");
    static STRUCT_IF_C aUl_BFu8s_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu9i, aUl_BFu8s_BFu9i)
//============================================================================



static void Test_aUl_BFu8s_BFu9ll()
{
  {
    init_simple_test("aUl_BFu8s_BFu9ll");
    static STRUCT_IF_C aUl_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu9ll, aUl_BFu8s_BFu9ll)
//============================================================================



static void Test_aUl_BFu8s_BFu9s()
{
  {
    init_simple_test("aUl_BFu8s_BFu9s");
    static STRUCT_IF_C aUl_BFu8s_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_BFu9s, aUl_BFu8s_BFu9s)
//============================================================================



static void Test_aUl_BFu8s_C()
{
  {
    init_simple_test("aUl_BFu8s_C");
    static STRUCT_IF_C aUl_BFu8s_C lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_C)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_C");
    check_field_offset(lv, v3, 9, "aUl_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_C, aUl_BFu8s_C)
//============================================================================



static void Test_aUl_BFu8s_D()
{
  {
    init_simple_test("aUl_BFu8s_D");
    static STRUCT_IF_C aUl_BFu8s_D lv;
    check2(sizeof(lv), 17, "sizeof(aUl_BFu8s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_D)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_D");
    check_field_offset(lv, v3, 9, "aUl_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_D, aUl_BFu8s_D)
//============================================================================



static void Test_aUl_BFu8s_F()
{
  {
    init_simple_test("aUl_BFu8s_F");
    static STRUCT_IF_C aUl_BFu8s_F lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_F)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_F");
    check_field_offset(lv, v3, 9, "aUl_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_F, aUl_BFu8s_F)
//============================================================================



static void Test_aUl_BFu8s_I()
{
  {
    init_simple_test("aUl_BFu8s_I");
    static STRUCT_IF_C aUl_BFu8s_I lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_I)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_I");
    check_field_offset(lv, v3, 9, "aUl_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_I, aUl_BFu8s_I)
//============================================================================



static void Test_aUl_BFu8s_Ip()
{
  {
    init_simple_test("aUl_BFu8s_Ip");
    static STRUCT_IF_C aUl_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_BFu8s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_Ip");
    check_field_offset(lv, v3, 9, "aUl_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_Ip, aUl_BFu8s_Ip)
//============================================================================



static void Test_aUl_BFu8s_L()
{
  {
    init_simple_test("aUl_BFu8s_L");
    static STRUCT_IF_C aUl_BFu8s_L lv;
    check2(sizeof(lv), 17, "sizeof(aUl_BFu8s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_L)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_L");
    check_field_offset(lv, v3, 9, "aUl_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_L, aUl_BFu8s_L)
//============================================================================



static void Test_aUl_BFu8s_S()
{
  {
    init_simple_test("aUl_BFu8s_S");
    static STRUCT_IF_C aUl_BFu8s_S lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_S)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_S");
    check_field_offset(lv, v3, 9, "aUl_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_S, aUl_BFu8s_S)
//============================================================================



static void Test_aUl_BFu8s_Uc()
{
  {
    init_simple_test("aUl_BFu8s_Uc");
    static STRUCT_IF_C aUl_BFu8s_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu8s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_Uc");
    check_field_offset(lv, v3, 9, "aUl_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_Uc, aUl_BFu8s_Uc)
//============================================================================



static void Test_aUl_BFu8s_Ui()
{
  {
    init_simple_test("aUl_BFu8s_Ui");
    static STRUCT_IF_C aUl_BFu8s_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu8s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_Ui");
    check_field_offset(lv, v3, 9, "aUl_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_Ui, aUl_BFu8s_Ui)
//============================================================================



static void Test_aUl_BFu8s_Ul()
{
  {
    init_simple_test("aUl_BFu8s_Ul");
    static STRUCT_IF_C aUl_BFu8s_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aUl_BFu8s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_Ul");
    check_field_offset(lv, v3, 9, "aUl_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_Ul, aUl_BFu8s_Ul)
//============================================================================



static void Test_aUl_BFu8s_Us()
{
  {
    init_simple_test("aUl_BFu8s_Us");
    static STRUCT_IF_C aUl_BFu8s_Us lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu8s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_Us");
    check_field_offset(lv, v3, 9, "aUl_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_Us, aUl_BFu8s_Us)
//============================================================================



static void Test_aUl_BFu8s_Vp()
{
  {
    init_simple_test("aUl_BFu8s_Vp");
    static STRUCT_IF_C aUl_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_BFu8s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "aUl_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "aUl_BFu8s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "aUl_BFu8s_Vp");
    check_field_offset(lv, v3, 9, "aUl_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu8s_Vp, aUl_BFu8s_Vp)
//============================================================================



static void Test_aUl_BFu9i()
{
  {
    init_simple_test("aUl_BFu9i");
    static STRUCT_IF_C aUl_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i, aUl_BFu9i)
//============================================================================



static void Test_aUl_BFu9i_BFu15i()
{
  {
    init_simple_test("aUl_BFu9i_BFu15i");
    static STRUCT_IF_C aUl_BFu9i_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "aUl_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "aUl_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu15i, aUl_BFu9i_BFu15i)
//============================================================================



static void Test_aUl_BFu9i_BFu15ll()
{
  {
    init_simple_test("aUl_BFu9i_BFu15ll");
    static STRUCT_IF_C aUl_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "aUl_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "aUl_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu15ll, aUl_BFu9i_BFu15ll)
//============================================================================



static void Test_aUl_BFu9i_BFu15s()
{
  {
    init_simple_test("aUl_BFu9i_BFu15s");
    static STRUCT_IF_C aUl_BFu9i_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "aUl_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "aUl_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu15s, aUl_BFu9i_BFu15s)
//============================================================================



static void Test_aUl_BFu9i_BFu16i()
{
  {
    init_simple_test("aUl_BFu9i_BFu16i");
    static STRUCT_IF_C aUl_BFu9i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "aUl_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "aUl_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu16i, aUl_BFu9i_BFu16i)
//============================================================================



static void Test_aUl_BFu9i_BFu16ll()
{
  {
    init_simple_test("aUl_BFu9i_BFu16ll");
    static STRUCT_IF_C aUl_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "aUl_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "aUl_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu16ll, aUl_BFu9i_BFu16ll)
//============================================================================



static void Test_aUl_BFu9i_BFu16s()
{
  {
    init_simple_test("aUl_BFu9i_BFu16s");
    static STRUCT_IF_C aUl_BFu9i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "aUl_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "aUl_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu16s, aUl_BFu9i_BFu16s)
//============================================================================



static void Test_aUl_BFu9i_BFu17i()
{
  {
    init_simple_test("aUl_BFu9i_BFu17i");
    static STRUCT_IF_C aUl_BFu9i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "aUl_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "aUl_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu17i, aUl_BFu9i_BFu17i)
//============================================================================



static void Test_aUl_BFu9i_BFu17ll()
{
  {
    init_simple_test("aUl_BFu9i_BFu17ll");
    static STRUCT_IF_C aUl_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "aUl_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "aUl_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu17ll, aUl_BFu9i_BFu17ll)
//============================================================================



static void Test_aUl_BFu9i_BFu1c()
{
  {
    init_simple_test("aUl_BFu9i_BFu1c");
    static STRUCT_IF_C aUl_BFu9i_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "aUl_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu1c, aUl_BFu9i_BFu1c)
//============================================================================



static void Test_aUl_BFu9i_BFu1i()
{
  {
    init_simple_test("aUl_BFu9i_BFu1i");
    static STRUCT_IF_C aUl_BFu9i_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "aUl_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu1i, aUl_BFu9i_BFu1i)
//============================================================================



static void Test_aUl_BFu9i_BFu1ll()
{
  {
    init_simple_test("aUl_BFu9i_BFu1ll");
    static STRUCT_IF_C aUl_BFu9i_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "aUl_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu1ll, aUl_BFu9i_BFu1ll)
//============================================================================



static void Test_aUl_BFu9i_BFu1s()
{
  {
    init_simple_test("aUl_BFu9i_BFu1s");
    static STRUCT_IF_C aUl_BFu9i_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "aUl_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu1s, aUl_BFu9i_BFu1s)
//============================================================================



static void Test_aUl_BFu9i_BFu31i()
{
  {
    init_simple_test("aUl_BFu9i_BFu31i");
    static STRUCT_IF_C aUl_BFu9i_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu9i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "aUl_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "aUl_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu31i, aUl_BFu9i_BFu31i)
//============================================================================



static void Test_aUl_BFu9i_BFu31ll()
{
  {
    init_simple_test("aUl_BFu9i_BFu31ll");
    static STRUCT_IF_C aUl_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu9i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "aUl_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "aUl_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu31ll, aUl_BFu9i_BFu31ll)
//============================================================================



static void Test_aUl_BFu9i_BFu32i()
{
  {
    init_simple_test("aUl_BFu9i_BFu32i");
    static STRUCT_IF_C aUl_BFu9i_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "aUl_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "aUl_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu32i, aUl_BFu9i_BFu32i)
//============================================================================



static void Test_aUl_BFu9i_BFu32ll()
{
  {
    init_simple_test("aUl_BFu9i_BFu32ll");
    static STRUCT_IF_C aUl_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "aUl_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "aUl_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu32ll, aUl_BFu9i_BFu32ll)
//============================================================================



static void Test_aUl_BFu9i_BFu33()
{
  {
    init_simple_test("aUl_BFu9i_BFu33");
    static STRUCT_IF_C aUl_BFu9i_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, 1, "aUl_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, hide_ull(1LL<<32), "aUl_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu33, aUl_BFu9i_BFu33)
//============================================================================



static void Test_aUl_BFu9i_BFu7c()
{
  {
    init_simple_test("aUl_BFu9i_BFu7c");
    static STRUCT_IF_C aUl_BFu9i_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "aUl_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "aUl_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu7c, aUl_BFu9i_BFu7c)
//============================================================================



static void Test_aUl_BFu9i_BFu7i()
{
  {
    init_simple_test("aUl_BFu9i_BFu7i");
    static STRUCT_IF_C aUl_BFu9i_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "aUl_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "aUl_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu7i, aUl_BFu9i_BFu7i)
//============================================================================



static void Test_aUl_BFu9i_BFu7ll()
{
  {
    init_simple_test("aUl_BFu9i_BFu7ll");
    static STRUCT_IF_C aUl_BFu9i_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "aUl_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "aUl_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu7ll, aUl_BFu9i_BFu7ll)
//============================================================================



static void Test_aUl_BFu9i_BFu7s()
{
  {
    init_simple_test("aUl_BFu9i_BFu7s");
    static STRUCT_IF_C aUl_BFu9i_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "aUl_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "aUl_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu7s, aUl_BFu9i_BFu7s)
//============================================================================



static void Test_aUl_BFu9i_BFu8c()
{
  {
    init_simple_test("aUl_BFu9i_BFu8c");
    static STRUCT_IF_C aUl_BFu9i_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "aUl_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "aUl_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu8c, aUl_BFu9i_BFu8c)
//============================================================================



static void Test_aUl_BFu9i_BFu8i()
{
  {
    init_simple_test("aUl_BFu9i_BFu8i");
    static STRUCT_IF_C aUl_BFu9i_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "aUl_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "aUl_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu8i, aUl_BFu9i_BFu8i)
//============================================================================



static void Test_aUl_BFu9i_BFu8ll()
{
  {
    init_simple_test("aUl_BFu9i_BFu8ll");
    static STRUCT_IF_C aUl_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "aUl_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "aUl_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu8ll, aUl_BFu9i_BFu8ll)
//============================================================================



static void Test_aUl_BFu9i_BFu8s()
{
  {
    init_simple_test("aUl_BFu9i_BFu8s");
    static STRUCT_IF_C aUl_BFu9i_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "aUl_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "aUl_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu8s, aUl_BFu9i_BFu8s)
//============================================================================



static void Test_aUl_BFu9i_BFu9i()
{
  {
    init_simple_test("aUl_BFu9i_BFu9i");
    static STRUCT_IF_C aUl_BFu9i_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "aUl_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu9i, aUl_BFu9i_BFu9i)
//============================================================================



static void Test_aUl_BFu9i_BFu9ll()
{
  {
    init_simple_test("aUl_BFu9i_BFu9ll");
    static STRUCT_IF_C aUl_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "aUl_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu9ll, aUl_BFu9i_BFu9ll)
//============================================================================



static void Test_aUl_BFu9i_BFu9s()
{
  {
    init_simple_test("aUl_BFu9i_BFu9s");
    static STRUCT_IF_C aUl_BFu9i_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "aUl_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "aUl_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_BFu9s, aUl_BFu9i_BFu9s)
//============================================================================



static void Test_aUl_BFu9i_C()
{
  {
    init_simple_test("aUl_BFu9i_C");
    static STRUCT_IF_C aUl_BFu9i_C lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_C)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_C");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_C");
    check_field_offset(lv, v3, 10, "aUl_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_C, aUl_BFu9i_C)
//============================================================================



static void Test_aUl_BFu9i_D()
{
  {
    init_simple_test("aUl_BFu9i_D");
    static STRUCT_IF_C aUl_BFu9i_D lv;
    check2(sizeof(lv), 18, "sizeof(aUl_BFu9i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_D)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_D");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_D");
    check_field_offset(lv, v3, 10, "aUl_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_D, aUl_BFu9i_D)
//============================================================================



static void Test_aUl_BFu9i_F()
{
  {
    init_simple_test("aUl_BFu9i_F");
    static STRUCT_IF_C aUl_BFu9i_F lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_F)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_F");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_F");
    check_field_offset(lv, v3, 10, "aUl_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_F, aUl_BFu9i_F)
//============================================================================



static void Test_aUl_BFu9i_I()
{
  {
    init_simple_test("aUl_BFu9i_I");
    static STRUCT_IF_C aUl_BFu9i_I lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_I)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_I");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_I");
    check_field_offset(lv, v3, 10, "aUl_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_I, aUl_BFu9i_I)
//============================================================================



static void Test_aUl_BFu9i_Ip()
{
  {
    init_simple_test("aUl_BFu9i_Ip");
    static STRUCT_IF_C aUl_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_BFu9i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_Ip");
    check_field_offset(lv, v3, 10, "aUl_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_Ip, aUl_BFu9i_Ip)
//============================================================================



static void Test_aUl_BFu9i_L()
{
  {
    init_simple_test("aUl_BFu9i_L");
    static STRUCT_IF_C aUl_BFu9i_L lv;
    check2(sizeof(lv), 18, "sizeof(aUl_BFu9i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_L)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_L");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_L");
    check_field_offset(lv, v3, 10, "aUl_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_L, aUl_BFu9i_L)
//============================================================================



static void Test_aUl_BFu9i_S()
{
  {
    init_simple_test("aUl_BFu9i_S");
    static STRUCT_IF_C aUl_BFu9i_S lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_S)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_S");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_S");
    check_field_offset(lv, v3, 10, "aUl_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_S, aUl_BFu9i_S)
//============================================================================



static void Test_aUl_BFu9i_Uc()
{
  {
    init_simple_test("aUl_BFu9i_Uc");
    static STRUCT_IF_C aUl_BFu9i_Uc lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_Uc");
    check_field_offset(lv, v3, 10, "aUl_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_Uc, aUl_BFu9i_Uc)
//============================================================================



static void Test_aUl_BFu9i_Ui()
{
  {
    init_simple_test("aUl_BFu9i_Ui");
    static STRUCT_IF_C aUl_BFu9i_Ui lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_Ui");
    check_field_offset(lv, v3, 10, "aUl_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_Ui, aUl_BFu9i_Ui)
//============================================================================



static void Test_aUl_BFu9i_Ul()
{
  {
    init_simple_test("aUl_BFu9i_Ul");
    static STRUCT_IF_C aUl_BFu9i_Ul lv;
    check2(sizeof(lv), 18, "sizeof(aUl_BFu9i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_Ul");
    check_field_offset(lv, v3, 10, "aUl_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_Ul, aUl_BFu9i_Ul)
//============================================================================



static void Test_aUl_BFu9i_Us()
{
  {
    init_simple_test("aUl_BFu9i_Us");
    static STRUCT_IF_C aUl_BFu9i_Us lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_Us");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_Us");
    check_field_offset(lv, v3, 10, "aUl_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_Us, aUl_BFu9i_Us)
//============================================================================



static void Test_aUl_BFu9i_Vp()
{
  {
    init_simple_test("aUl_BFu9i_Vp");
    static STRUCT_IF_C aUl_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_BFu9i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "aUl_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9i_Vp");
    check_field_offset(lv, v3, 10, "aUl_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9i_Vp, aUl_BFu9i_Vp)
//============================================================================



static void Test_aUl_BFu9ll()
{
  {
    init_simple_test("aUl_BFu9ll");
    static STRUCT_IF_C aUl_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll, aUl_BFu9ll)
//============================================================================



static void Test_aUl_BFu9ll_BFu15i()
{
  {
    init_simple_test("aUl_BFu9ll_BFu15i");
    static STRUCT_IF_C aUl_BFu9ll_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "aUl_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "aUl_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu15i, aUl_BFu9ll_BFu15i)
//============================================================================



static void Test_aUl_BFu9ll_BFu15ll()
{
  {
    init_simple_test("aUl_BFu9ll_BFu15ll");
    static STRUCT_IF_C aUl_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "aUl_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "aUl_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu15ll, aUl_BFu9ll_BFu15ll)
//============================================================================



static void Test_aUl_BFu9ll_BFu15s()
{
  {
    init_simple_test("aUl_BFu9ll_BFu15s");
    static STRUCT_IF_C aUl_BFu9ll_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "aUl_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "aUl_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu15s, aUl_BFu9ll_BFu15s)
//============================================================================



static void Test_aUl_BFu9ll_BFu16i()
{
  {
    init_simple_test("aUl_BFu9ll_BFu16i");
    static STRUCT_IF_C aUl_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "aUl_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "aUl_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu16i, aUl_BFu9ll_BFu16i)
//============================================================================



static void Test_aUl_BFu9ll_BFu16ll()
{
  {
    init_simple_test("aUl_BFu9ll_BFu16ll");
    static STRUCT_IF_C aUl_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "aUl_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "aUl_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu16ll, aUl_BFu9ll_BFu16ll)
//============================================================================



static void Test_aUl_BFu9ll_BFu16s()
{
  {
    init_simple_test("aUl_BFu9ll_BFu16s");
    static STRUCT_IF_C aUl_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "aUl_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "aUl_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu16s, aUl_BFu9ll_BFu16s)
//============================================================================



static void Test_aUl_BFu9ll_BFu17i()
{
  {
    init_simple_test("aUl_BFu9ll_BFu17i");
    static STRUCT_IF_C aUl_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "aUl_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "aUl_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu17i, aUl_BFu9ll_BFu17i)
//============================================================================



static void Test_aUl_BFu9ll_BFu17ll()
{
  {
    init_simple_test("aUl_BFu9ll_BFu17ll");
    static STRUCT_IF_C aUl_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "aUl_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "aUl_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu17ll, aUl_BFu9ll_BFu17ll)
//============================================================================



static void Test_aUl_BFu9ll_BFu1c()
{
  {
    init_simple_test("aUl_BFu9ll_BFu1c");
    static STRUCT_IF_C aUl_BFu9ll_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "aUl_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu1c, aUl_BFu9ll_BFu1c)
//============================================================================



static void Test_aUl_BFu9ll_BFu1i()
{
  {
    init_simple_test("aUl_BFu9ll_BFu1i");
    static STRUCT_IF_C aUl_BFu9ll_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "aUl_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu1i, aUl_BFu9ll_BFu1i)
//============================================================================



static void Test_aUl_BFu9ll_BFu1ll()
{
  {
    init_simple_test("aUl_BFu9ll_BFu1ll");
    static STRUCT_IF_C aUl_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "aUl_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu1ll, aUl_BFu9ll_BFu1ll)
//============================================================================



static void Test_aUl_BFu9ll_BFu1s()
{
  {
    init_simple_test("aUl_BFu9ll_BFu1s");
    static STRUCT_IF_C aUl_BFu9ll_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "aUl_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu1s, aUl_BFu9ll_BFu1s)
//============================================================================



static void Test_aUl_BFu9ll_BFu31i()
{
  {
    init_simple_test("aUl_BFu9ll_BFu31i");
    static STRUCT_IF_C aUl_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu9ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "aUl_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "aUl_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu31i, aUl_BFu9ll_BFu31i)
//============================================================================



static void Test_aUl_BFu9ll_BFu31ll()
{
  {
    init_simple_test("aUl_BFu9ll_BFu31ll");
    static STRUCT_IF_C aUl_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "aUl_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "aUl_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu31ll, aUl_BFu9ll_BFu31ll)
//============================================================================



static void Test_aUl_BFu9ll_BFu32i()
{
  {
    init_simple_test("aUl_BFu9ll_BFu32i");
    static STRUCT_IF_C aUl_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "aUl_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "aUl_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu32i, aUl_BFu9ll_BFu32i)
//============================================================================



static void Test_aUl_BFu9ll_BFu32ll()
{
  {
    init_simple_test("aUl_BFu9ll_BFu32ll");
    static STRUCT_IF_C aUl_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "aUl_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "aUl_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu32ll, aUl_BFu9ll_BFu32ll)
//============================================================================



static void Test_aUl_BFu9ll_BFu33()
{
  {
    init_simple_test("aUl_BFu9ll_BFu33");
    static STRUCT_IF_C aUl_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, 1, "aUl_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, hide_ull(1LL<<32), "aUl_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu33, aUl_BFu9ll_BFu33)
//============================================================================



static void Test_aUl_BFu9ll_BFu7c()
{
  {
    init_simple_test("aUl_BFu9ll_BFu7c");
    static STRUCT_IF_C aUl_BFu9ll_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "aUl_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "aUl_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu7c, aUl_BFu9ll_BFu7c)
//============================================================================



static void Test_aUl_BFu9ll_BFu7i()
{
  {
    init_simple_test("aUl_BFu9ll_BFu7i");
    static STRUCT_IF_C aUl_BFu9ll_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "aUl_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "aUl_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu7i, aUl_BFu9ll_BFu7i)
//============================================================================



static void Test_aUl_BFu9ll_BFu7ll()
{
  {
    init_simple_test("aUl_BFu9ll_BFu7ll");
    static STRUCT_IF_C aUl_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "aUl_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "aUl_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu7ll, aUl_BFu9ll_BFu7ll)
//============================================================================



static void Test_aUl_BFu9ll_BFu7s()
{
  {
    init_simple_test("aUl_BFu9ll_BFu7s");
    static STRUCT_IF_C aUl_BFu9ll_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "aUl_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "aUl_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu7s, aUl_BFu9ll_BFu7s)
//============================================================================



static void Test_aUl_BFu9ll_BFu8c()
{
  {
    init_simple_test("aUl_BFu9ll_BFu8c");
    static STRUCT_IF_C aUl_BFu9ll_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "aUl_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "aUl_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu8c, aUl_BFu9ll_BFu8c)
//============================================================================



static void Test_aUl_BFu9ll_BFu8i()
{
  {
    init_simple_test("aUl_BFu9ll_BFu8i");
    static STRUCT_IF_C aUl_BFu9ll_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "aUl_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "aUl_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu8i, aUl_BFu9ll_BFu8i)
//============================================================================



static void Test_aUl_BFu9ll_BFu8ll()
{
  {
    init_simple_test("aUl_BFu9ll_BFu8ll");
    static STRUCT_IF_C aUl_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "aUl_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "aUl_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu8ll, aUl_BFu9ll_BFu8ll)
//============================================================================



static void Test_aUl_BFu9ll_BFu8s()
{
  {
    init_simple_test("aUl_BFu9ll_BFu8s");
    static STRUCT_IF_C aUl_BFu9ll_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "aUl_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "aUl_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu8s, aUl_BFu9ll_BFu8s)
//============================================================================



static void Test_aUl_BFu9ll_BFu9i()
{
  {
    init_simple_test("aUl_BFu9ll_BFu9i");
    static STRUCT_IF_C aUl_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "aUl_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu9i, aUl_BFu9ll_BFu9i)
//============================================================================



static void Test_aUl_BFu9ll_BFu9ll()
{
  {
    init_simple_test("aUl_BFu9ll_BFu9ll");
    static STRUCT_IF_C aUl_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "aUl_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu9ll, aUl_BFu9ll_BFu9ll)
//============================================================================



static void Test_aUl_BFu9ll_BFu9s()
{
  {
    init_simple_test("aUl_BFu9ll_BFu9s");
    static STRUCT_IF_C aUl_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "aUl_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "aUl_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_BFu9s, aUl_BFu9ll_BFu9s)
//============================================================================



static void Test_aUl_BFu9ll_C()
{
  {
    init_simple_test("aUl_BFu9ll_C");
    static STRUCT_IF_C aUl_BFu9ll_C lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_C");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_C");
    check_field_offset(lv, v3, 10, "aUl_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_C, aUl_BFu9ll_C)
//============================================================================



static void Test_aUl_BFu9ll_D()
{
  {
    init_simple_test("aUl_BFu9ll_D");
    static STRUCT_IF_C aUl_BFu9ll_D lv;
    check2(sizeof(lv), 18, "sizeof(aUl_BFu9ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_D");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_D");
    check_field_offset(lv, v3, 10, "aUl_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_D, aUl_BFu9ll_D)
//============================================================================



static void Test_aUl_BFu9ll_F()
{
  {
    init_simple_test("aUl_BFu9ll_F");
    static STRUCT_IF_C aUl_BFu9ll_F lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_F");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_F");
    check_field_offset(lv, v3, 10, "aUl_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_F, aUl_BFu9ll_F)
//============================================================================



static void Test_aUl_BFu9ll_I()
{
  {
    init_simple_test("aUl_BFu9ll_I");
    static STRUCT_IF_C aUl_BFu9ll_I lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_I");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_I");
    check_field_offset(lv, v3, 10, "aUl_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_I, aUl_BFu9ll_I)
//============================================================================



static void Test_aUl_BFu9ll_Ip()
{
  {
    init_simple_test("aUl_BFu9ll_Ip");
    static STRUCT_IF_C aUl_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_BFu9ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_Ip");
    check_field_offset(lv, v3, 10, "aUl_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_Ip, aUl_BFu9ll_Ip)
//============================================================================



static void Test_aUl_BFu9ll_L()
{
  {
    init_simple_test("aUl_BFu9ll_L");
    static STRUCT_IF_C aUl_BFu9ll_L lv;
    check2(sizeof(lv), 18, "sizeof(aUl_BFu9ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_L");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_L");
    check_field_offset(lv, v3, 10, "aUl_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_L, aUl_BFu9ll_L)
//============================================================================



static void Test_aUl_BFu9ll_S()
{
  {
    init_simple_test("aUl_BFu9ll_S");
    static STRUCT_IF_C aUl_BFu9ll_S lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_S");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_S");
    check_field_offset(lv, v3, 10, "aUl_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_S, aUl_BFu9ll_S)
//============================================================================



static void Test_aUl_BFu9ll_Uc()
{
  {
    init_simple_test("aUl_BFu9ll_Uc");
    static STRUCT_IF_C aUl_BFu9ll_Uc lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_Uc");
    check_field_offset(lv, v3, 10, "aUl_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_Uc, aUl_BFu9ll_Uc)
//============================================================================



static void Test_aUl_BFu9ll_Ui()
{
  {
    init_simple_test("aUl_BFu9ll_Ui");
    static STRUCT_IF_C aUl_BFu9ll_Ui lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_Ui");
    check_field_offset(lv, v3, 10, "aUl_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_Ui, aUl_BFu9ll_Ui)
//============================================================================



static void Test_aUl_BFu9ll_Ul()
{
  {
    init_simple_test("aUl_BFu9ll_Ul");
    static STRUCT_IF_C aUl_BFu9ll_Ul lv;
    check2(sizeof(lv), 18, "sizeof(aUl_BFu9ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_Ul");
    check_field_offset(lv, v3, 10, "aUl_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_Ul, aUl_BFu9ll_Ul)
//============================================================================



static void Test_aUl_BFu9ll_Us()
{
  {
    init_simple_test("aUl_BFu9ll_Us");
    static STRUCT_IF_C aUl_BFu9ll_Us lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_Us");
    check_field_offset(lv, v3, 10, "aUl_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_Us, aUl_BFu9ll_Us)
//============================================================================



static void Test_aUl_BFu9ll_Vp()
{
  {
    init_simple_test("aUl_BFu9ll_Vp");
    static STRUCT_IF_C aUl_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_BFu9ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "aUl_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9ll_Vp");
    check_field_offset(lv, v3, 10, "aUl_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9ll_Vp, aUl_BFu9ll_Vp)
//============================================================================



static void Test_aUl_BFu9s()
{
  {
    init_simple_test("aUl_BFu9s");
    static STRUCT_IF_C aUl_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s, aUl_BFu9s)
//============================================================================



static void Test_aUl_BFu9s_BFu15i()
{
  {
    init_simple_test("aUl_BFu9s_BFu15i");
    static STRUCT_IF_C aUl_BFu9s_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "aUl_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "aUl_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu15i, aUl_BFu9s_BFu15i)
//============================================================================



static void Test_aUl_BFu9s_BFu15ll()
{
  {
    init_simple_test("aUl_BFu9s_BFu15ll");
    static STRUCT_IF_C aUl_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "aUl_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "aUl_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu15ll, aUl_BFu9s_BFu15ll)
//============================================================================



static void Test_aUl_BFu9s_BFu15s()
{
  {
    init_simple_test("aUl_BFu9s_BFu15s");
    static STRUCT_IF_C aUl_BFu9s_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "aUl_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "aUl_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu15s, aUl_BFu9s_BFu15s)
//============================================================================



static void Test_aUl_BFu9s_BFu16i()
{
  {
    init_simple_test("aUl_BFu9s_BFu16i");
    static STRUCT_IF_C aUl_BFu9s_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "aUl_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "aUl_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu16i, aUl_BFu9s_BFu16i)
//============================================================================



static void Test_aUl_BFu9s_BFu16ll()
{
  {
    init_simple_test("aUl_BFu9s_BFu16ll");
    static STRUCT_IF_C aUl_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "aUl_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "aUl_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu16ll, aUl_BFu9s_BFu16ll)
//============================================================================



static void Test_aUl_BFu9s_BFu16s()
{
  {
    init_simple_test("aUl_BFu9s_BFu16s");
    static STRUCT_IF_C aUl_BFu9s_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "aUl_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "aUl_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu16s, aUl_BFu9s_BFu16s)
//============================================================================



static void Test_aUl_BFu9s_BFu17i()
{
  {
    init_simple_test("aUl_BFu9s_BFu17i");
    static STRUCT_IF_C aUl_BFu9s_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "aUl_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "aUl_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu17i, aUl_BFu9s_BFu17i)
//============================================================================



static void Test_aUl_BFu9s_BFu17ll()
{
  {
    init_simple_test("aUl_BFu9s_BFu17ll");
    static STRUCT_IF_C aUl_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "aUl_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "aUl_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu17ll, aUl_BFu9s_BFu17ll)
//============================================================================



static void Test_aUl_BFu9s_BFu1c()
{
  {
    init_simple_test("aUl_BFu9s_BFu1c");
    static STRUCT_IF_C aUl_BFu9s_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "aUl_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu1c, aUl_BFu9s_BFu1c)
//============================================================================



static void Test_aUl_BFu9s_BFu1i()
{
  {
    init_simple_test("aUl_BFu9s_BFu1i");
    static STRUCT_IF_C aUl_BFu9s_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "aUl_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu1i, aUl_BFu9s_BFu1i)
//============================================================================



static void Test_aUl_BFu9s_BFu1ll()
{
  {
    init_simple_test("aUl_BFu9s_BFu1ll");
    static STRUCT_IF_C aUl_BFu9s_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "aUl_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu1ll, aUl_BFu9s_BFu1ll)
//============================================================================



static void Test_aUl_BFu9s_BFu1s()
{
  {
    init_simple_test("aUl_BFu9s_BFu1s");
    static STRUCT_IF_C aUl_BFu9s_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "aUl_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu1s, aUl_BFu9s_BFu1s)
//============================================================================



static void Test_aUl_BFu9s_BFu31i()
{
  {
    init_simple_test("aUl_BFu9s_BFu31i");
    static STRUCT_IF_C aUl_BFu9s_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu9s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "aUl_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "aUl_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu31i, aUl_BFu9s_BFu31i)
//============================================================================



static void Test_aUl_BFu9s_BFu31ll()
{
  {
    init_simple_test("aUl_BFu9s_BFu31ll");
    static STRUCT_IF_C aUl_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_BFu9s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "aUl_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "aUl_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu31ll, aUl_BFu9s_BFu31ll)
//============================================================================



static void Test_aUl_BFu9s_BFu32i()
{
  {
    init_simple_test("aUl_BFu9s_BFu32i");
    static STRUCT_IF_C aUl_BFu9s_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "aUl_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "aUl_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu32i, aUl_BFu9s_BFu32i)
//============================================================================



static void Test_aUl_BFu9s_BFu32ll()
{
  {
    init_simple_test("aUl_BFu9s_BFu32ll");
    static STRUCT_IF_C aUl_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "aUl_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "aUl_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu32ll, aUl_BFu9s_BFu32ll)
//============================================================================



static void Test_aUl_BFu9s_BFu33()
{
  {
    init_simple_test("aUl_BFu9s_BFu33");
    static STRUCT_IF_C aUl_BFu9s_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, 1, "aUl_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, hide_ull(1LL<<32), "aUl_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu33, aUl_BFu9s_BFu33)
//============================================================================



static void Test_aUl_BFu9s_BFu7c()
{
  {
    init_simple_test("aUl_BFu9s_BFu7c");
    static STRUCT_IF_C aUl_BFu9s_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "aUl_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "aUl_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu7c, aUl_BFu9s_BFu7c)
//============================================================================



static void Test_aUl_BFu9s_BFu7i()
{
  {
    init_simple_test("aUl_BFu9s_BFu7i");
    static STRUCT_IF_C aUl_BFu9s_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "aUl_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "aUl_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu7i, aUl_BFu9s_BFu7i)
//============================================================================



static void Test_aUl_BFu9s_BFu7ll()
{
  {
    init_simple_test("aUl_BFu9s_BFu7ll");
    static STRUCT_IF_C aUl_BFu9s_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "aUl_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "aUl_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu7ll, aUl_BFu9s_BFu7ll)
//============================================================================



static void Test_aUl_BFu9s_BFu7s()
{
  {
    init_simple_test("aUl_BFu9s_BFu7s");
    static STRUCT_IF_C aUl_BFu9s_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_BFu9s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "aUl_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "aUl_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu7s, aUl_BFu9s_BFu7s)
//============================================================================



static void Test_aUl_BFu9s_BFu8c()
{
  {
    init_simple_test("aUl_BFu9s_BFu8c");
    static STRUCT_IF_C aUl_BFu9s_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "aUl_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "aUl_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu8c, aUl_BFu9s_BFu8c)
//============================================================================



static void Test_aUl_BFu9s_BFu8i()
{
  {
    init_simple_test("aUl_BFu9s_BFu8i");
    static STRUCT_IF_C aUl_BFu9s_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "aUl_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "aUl_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu8i, aUl_BFu9s_BFu8i)
//============================================================================



static void Test_aUl_BFu9s_BFu8ll()
{
  {
    init_simple_test("aUl_BFu9s_BFu8ll");
    static STRUCT_IF_C aUl_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "aUl_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "aUl_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu8ll, aUl_BFu9s_BFu8ll)
//============================================================================



static void Test_aUl_BFu9s_BFu8s()
{
  {
    init_simple_test("aUl_BFu9s_BFu8s");
    static STRUCT_IF_C aUl_BFu9s_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "aUl_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "aUl_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu8s, aUl_BFu9s_BFu8s)
//============================================================================



static void Test_aUl_BFu9s_BFu9i()
{
  {
    init_simple_test("aUl_BFu9s_BFu9i");
    static STRUCT_IF_C aUl_BFu9s_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "aUl_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu9i, aUl_BFu9s_BFu9i)
//============================================================================



static void Test_aUl_BFu9s_BFu9ll()
{
  {
    init_simple_test("aUl_BFu9s_BFu9ll");
    static STRUCT_IF_C aUl_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "aUl_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu9ll, aUl_BFu9s_BFu9ll)
//============================================================================



static void Test_aUl_BFu9s_BFu9s()
{
  {
    init_simple_test("aUl_BFu9s_BFu9s");
    static STRUCT_IF_C aUl_BFu9s_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "aUl_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "aUl_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_BFu9s, aUl_BFu9s_BFu9s)
//============================================================================



static void Test_aUl_BFu9s_C()
{
  {
    init_simple_test("aUl_BFu9s_C");
    static STRUCT_IF_C aUl_BFu9s_C lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_C)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_C");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_C");
    check_field_offset(lv, v3, 10, "aUl_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_C, aUl_BFu9s_C)
//============================================================================



static void Test_aUl_BFu9s_D()
{
  {
    init_simple_test("aUl_BFu9s_D");
    static STRUCT_IF_C aUl_BFu9s_D lv;
    check2(sizeof(lv), 18, "sizeof(aUl_BFu9s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_D)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_D");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_D");
    check_field_offset(lv, v3, 10, "aUl_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_D, aUl_BFu9s_D)
//============================================================================



static void Test_aUl_BFu9s_F()
{
  {
    init_simple_test("aUl_BFu9s_F");
    static STRUCT_IF_C aUl_BFu9s_F lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_F)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_F");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_F");
    check_field_offset(lv, v3, 10, "aUl_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_F, aUl_BFu9s_F)
//============================================================================



static void Test_aUl_BFu9s_I()
{
  {
    init_simple_test("aUl_BFu9s_I");
    static STRUCT_IF_C aUl_BFu9s_I lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_I)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_I");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_I");
    check_field_offset(lv, v3, 10, "aUl_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_I, aUl_BFu9s_I)
//============================================================================



static void Test_aUl_BFu9s_Ip()
{
  {
    init_simple_test("aUl_BFu9s_Ip");
    static STRUCT_IF_C aUl_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_BFu9s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_Ip)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_Ip");
    check_field_offset(lv, v3, 10, "aUl_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_Ip, aUl_BFu9s_Ip)
//============================================================================



static void Test_aUl_BFu9s_L()
{
  {
    init_simple_test("aUl_BFu9s_L");
    static STRUCT_IF_C aUl_BFu9s_L lv;
    check2(sizeof(lv), 18, "sizeof(aUl_BFu9s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_L)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_L");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_L");
    check_field_offset(lv, v3, 10, "aUl_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_L, aUl_BFu9s_L)
//============================================================================



static void Test_aUl_BFu9s_S()
{
  {
    init_simple_test("aUl_BFu9s_S");
    static STRUCT_IF_C aUl_BFu9s_S lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_S)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_S");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_S");
    check_field_offset(lv, v3, 10, "aUl_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_S, aUl_BFu9s_S)
//============================================================================



static void Test_aUl_BFu9s_Uc()
{
  {
    init_simple_test("aUl_BFu9s_Uc");
    static STRUCT_IF_C aUl_BFu9s_Uc lv;
    check2(sizeof(lv), 11, "sizeof(aUl_BFu9s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_Uc)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_Uc");
    check_field_offset(lv, v3, 10, "aUl_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_Uc, aUl_BFu9s_Uc)
//============================================================================



static void Test_aUl_BFu9s_Ui()
{
  {
    init_simple_test("aUl_BFu9s_Ui");
    static STRUCT_IF_C aUl_BFu9s_Ui lv;
    check2(sizeof(lv), 14, "sizeof(aUl_BFu9s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_Ui)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_Ui");
    check_field_offset(lv, v3, 10, "aUl_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_Ui, aUl_BFu9s_Ui)
//============================================================================



static void Test_aUl_BFu9s_Ul()
{
  {
    init_simple_test("aUl_BFu9s_Ul");
    static STRUCT_IF_C aUl_BFu9s_Ul lv;
    check2(sizeof(lv), 18, "sizeof(aUl_BFu9s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_Ul)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_Ul");
    check_field_offset(lv, v3, 10, "aUl_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_Ul, aUl_BFu9s_Ul)
//============================================================================



static void Test_aUl_BFu9s_Us()
{
  {
    init_simple_test("aUl_BFu9s_Us");
    static STRUCT_IF_C aUl_BFu9s_Us lv;
    check2(sizeof(lv), 12, "sizeof(aUl_BFu9s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_Us)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_Us");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_Us");
    check_field_offset(lv, v3, 10, "aUl_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_Us, aUl_BFu9s_Us)
//============================================================================



static void Test_aUl_BFu9s_Vp()
{
  {
    init_simple_test("aUl_BFu9s_Vp");
    static STRUCT_IF_C aUl_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_BFu9s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_BFu9s_Vp)");
    check_field_offset(lv, v1, 0, "aUl_BFu9s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "aUl_BFu9s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "aUl_BFu9s_Vp");
    check_field_offset(lv, v3, 10, "aUl_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_BFu9s_Vp, aUl_BFu9s_Vp)
//============================================================================



static void Test_aUl_C()
{
  {
    init_simple_test("aUl_C");
    STRUCT_IF_C aUl_C lv;
    check2(sizeof(lv), 9, "sizeof(aUl_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C)");
    check_field_offset(lv, v1, 0, "aUl_C.v1");
    check_field_offset(lv, v2, 8, "aUl_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C, aUl_C)
//============================================================================



static void Test_aUl_C_BFu15i()
{
  {
    init_simple_test("aUl_C_BFu15i");
    static STRUCT_IF_C aUl_C_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_C_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUl_C_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUl_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu15i, aUl_C_BFu15i)
//============================================================================



static void Test_aUl_C_BFu15ll()
{
  {
    init_simple_test("aUl_C_BFu15ll");
    static STRUCT_IF_C aUl_C_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_C_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUl_C_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUl_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu15ll, aUl_C_BFu15ll)
//============================================================================



static void Test_aUl_C_BFu15s()
{
  {
    init_simple_test("aUl_C_BFu15s");
    static STRUCT_IF_C aUl_C_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_C_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUl_C_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUl_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu15s, aUl_C_BFu15s)
//============================================================================



static void Test_aUl_C_BFu16i()
{
  {
    init_simple_test("aUl_C_BFu16i");
    static STRUCT_IF_C aUl_C_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_C_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUl_C_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUl_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu16i, aUl_C_BFu16i)
//============================================================================



static void Test_aUl_C_BFu16ll()
{
  {
    init_simple_test("aUl_C_BFu16ll");
    static STRUCT_IF_C aUl_C_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_C_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUl_C_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUl_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu16ll, aUl_C_BFu16ll)
//============================================================================



static void Test_aUl_C_BFu16s()
{
  {
    init_simple_test("aUl_C_BFu16s");
    static STRUCT_IF_C aUl_C_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_C_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUl_C_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUl_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu16s, aUl_C_BFu16s)
//============================================================================



static void Test_aUl_C_BFu17i()
{
  {
    init_simple_test("aUl_C_BFu17i");
    static STRUCT_IF_C aUl_C_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_C_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aUl_C_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aUl_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu17i, aUl_C_BFu17i)
//============================================================================



static void Test_aUl_C_BFu17ll()
{
  {
    init_simple_test("aUl_C_BFu17ll");
    static STRUCT_IF_C aUl_C_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_C_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aUl_C_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aUl_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu17ll, aUl_C_BFu17ll)
//============================================================================



static void Test_aUl_C_BFu1c()
{
  {
    init_simple_test("aUl_C_BFu1c");
    static STRUCT_IF_C aUl_C_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu1c, aUl_C_BFu1c)
//============================================================================



static void Test_aUl_C_BFu1i()
{
  {
    init_simple_test("aUl_C_BFu1i");
    static STRUCT_IF_C aUl_C_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu1i, aUl_C_BFu1i)
//============================================================================



static void Test_aUl_C_BFu1ll()
{
  {
    init_simple_test("aUl_C_BFu1ll");
    static STRUCT_IF_C aUl_C_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu1ll, aUl_C_BFu1ll)
//============================================================================



static void Test_aUl_C_BFu1s()
{
  {
    init_simple_test("aUl_C_BFu1s");
    static STRUCT_IF_C aUl_C_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu1s, aUl_C_BFu1s)
//============================================================================



static void Test_aUl_C_BFu31i()
{
  {
    init_simple_test("aUl_C_BFu31i");
    static STRUCT_IF_C aUl_C_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_C_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUl_C_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUl_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu31i, aUl_C_BFu31i)
//============================================================================



static void Test_aUl_C_BFu31ll()
{
  {
    init_simple_test("aUl_C_BFu31ll");
    static STRUCT_IF_C aUl_C_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_C_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUl_C_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUl_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu31ll, aUl_C_BFu31ll)
//============================================================================



static void Test_aUl_C_BFu32i()
{
  {
    init_simple_test("aUl_C_BFu32i");
    static STRUCT_IF_C aUl_C_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_C_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUl_C_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUl_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu32i, aUl_C_BFu32i)
//============================================================================



static void Test_aUl_C_BFu32ll()
{
  {
    init_simple_test("aUl_C_BFu32ll");
    static STRUCT_IF_C aUl_C_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_C_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUl_C_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUl_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu32ll, aUl_C_BFu32ll)
//============================================================================



static void Test_aUl_C_BFu33()
{
  {
    init_simple_test("aUl_C_BFu33");
    static STRUCT_IF_C aUl_C_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aUl_C_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu33.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aUl_C_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aUl_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu33, aUl_C_BFu33)
//============================================================================



static void Test_aUl_C_BFu7c()
{
  {
    init_simple_test("aUl_C_BFu7c");
    static STRUCT_IF_C aUl_C_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_C_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu7c, aUl_C_BFu7c)
//============================================================================



static void Test_aUl_C_BFu7i()
{
  {
    init_simple_test("aUl_C_BFu7i");
    static STRUCT_IF_C aUl_C_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_C_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu7i, aUl_C_BFu7i)
//============================================================================



static void Test_aUl_C_BFu7ll()
{
  {
    init_simple_test("aUl_C_BFu7ll");
    static STRUCT_IF_C aUl_C_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_C_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu7ll, aUl_C_BFu7ll)
//============================================================================



static void Test_aUl_C_BFu7s()
{
  {
    init_simple_test("aUl_C_BFu7s");
    static STRUCT_IF_C aUl_C_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_C_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu7s, aUl_C_BFu7s)
//============================================================================



static void Test_aUl_C_BFu8c()
{
  {
    init_simple_test("aUl_C_BFu8c");
    static STRUCT_IF_C aUl_C_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_C_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu8c, aUl_C_BFu8c)
//============================================================================



static void Test_aUl_C_BFu8i()
{
  {
    init_simple_test("aUl_C_BFu8i");
    static STRUCT_IF_C aUl_C_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_C_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu8i, aUl_C_BFu8i)
//============================================================================



static void Test_aUl_C_BFu8ll()
{
  {
    init_simple_test("aUl_C_BFu8ll");
    static STRUCT_IF_C aUl_C_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_C_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu8ll, aUl_C_BFu8ll)
//============================================================================



static void Test_aUl_C_BFu8s()
{
  {
    init_simple_test("aUl_C_BFu8s");
    static STRUCT_IF_C aUl_C_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_C_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu8s, aUl_C_BFu8s)
//============================================================================



static void Test_aUl_C_BFu9i()
{
  {
    init_simple_test("aUl_C_BFu9i");
    static STRUCT_IF_C aUl_C_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_C_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_C_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu9i, aUl_C_BFu9i)
//============================================================================



static void Test_aUl_C_BFu9ll()
{
  {
    init_simple_test("aUl_C_BFu9ll");
    static STRUCT_IF_C aUl_C_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_C_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_C_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu9ll, aUl_C_BFu9ll)
//============================================================================



static void Test_aUl_C_BFu9s()
{
  {
    init_simple_test("aUl_C_BFu9s");
    static STRUCT_IF_C aUl_C_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_C_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_C_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aUl_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_C_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_BFu9s, aUl_C_BFu9s)
//============================================================================



static void Test_aUl_C_C()
{
  {
    init_simple_test("aUl_C_C");
    STRUCT_IF_C aUl_C_C lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_C)");
    check_field_offset(lv, v1, 0, "aUl_C_C.v1");
    check_field_offset(lv, v2, 8, "aUl_C_C.v2");
    check_field_offset(lv, v3, 9, "aUl_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_C, aUl_C_C)
//============================================================================



static void Test_aUl_C_D()
{
  {
    init_simple_test("aUl_C_D");
    STRUCT_IF_C aUl_C_D lv;
    check2(sizeof(lv), 17, "sizeof(aUl_C_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_D)");
    check_field_offset(lv, v1, 0, "aUl_C_D.v1");
    check_field_offset(lv, v2, 8, "aUl_C_D.v2");
    check_field_offset(lv, v3, 9, "aUl_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_D, aUl_C_D)
//============================================================================



static void Test_aUl_C_F()
{
  {
    init_simple_test("aUl_C_F");
    STRUCT_IF_C aUl_C_F lv;
    check2(sizeof(lv), 13, "sizeof(aUl_C_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_F)");
    check_field_offset(lv, v1, 0, "aUl_C_F.v1");
    check_field_offset(lv, v2, 8, "aUl_C_F.v2");
    check_field_offset(lv, v3, 9, "aUl_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_F, aUl_C_F)
//============================================================================



static void Test_aUl_C_I()
{
  {
    init_simple_test("aUl_C_I");
    STRUCT_IF_C aUl_C_I lv;
    check2(sizeof(lv), 13, "sizeof(aUl_C_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_I)");
    check_field_offset(lv, v1, 0, "aUl_C_I.v1");
    check_field_offset(lv, v2, 8, "aUl_C_I.v2");
    check_field_offset(lv, v3, 9, "aUl_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_I, aUl_C_I)
//============================================================================



static void Test_aUl_C_Ip()
{
  {
    init_simple_test("aUl_C_Ip");
    STRUCT_IF_C aUl_C_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_C_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_Ip)");
    check_field_offset(lv, v1, 0, "aUl_C_Ip.v1");
    check_field_offset(lv, v2, 8, "aUl_C_Ip.v2");
    check_field_offset(lv, v3, 9, "aUl_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_Ip, aUl_C_Ip)
//============================================================================



static void Test_aUl_C_L()
{
  {
    init_simple_test("aUl_C_L");
    STRUCT_IF_C aUl_C_L lv;
    check2(sizeof(lv), 17, "sizeof(aUl_C_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_L)");
    check_field_offset(lv, v1, 0, "aUl_C_L.v1");
    check_field_offset(lv, v2, 8, "aUl_C_L.v2");
    check_field_offset(lv, v3, 9, "aUl_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_L, aUl_C_L)
//============================================================================



static void Test_aUl_C_S()
{
  {
    init_simple_test("aUl_C_S");
    STRUCT_IF_C aUl_C_S lv;
    check2(sizeof(lv), 11, "sizeof(aUl_C_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_S)");
    check_field_offset(lv, v1, 0, "aUl_C_S.v1");
    check_field_offset(lv, v2, 8, "aUl_C_S.v2");
    check_field_offset(lv, v3, 9, "aUl_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_S, aUl_C_S)
//============================================================================



static void Test_aUl_C_Uc()
{
  {
    init_simple_test("aUl_C_Uc");
    STRUCT_IF_C aUl_C_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aUl_C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_Uc)");
    check_field_offset(lv, v1, 0, "aUl_C_Uc.v1");
    check_field_offset(lv, v2, 8, "aUl_C_Uc.v2");
    check_field_offset(lv, v3, 9, "aUl_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_Uc, aUl_C_Uc)
//============================================================================



static void Test_aUl_C_Ui()
{
  {
    init_simple_test("aUl_C_Ui");
    STRUCT_IF_C aUl_C_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aUl_C_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_Ui)");
    check_field_offset(lv, v1, 0, "aUl_C_Ui.v1");
    check_field_offset(lv, v2, 8, "aUl_C_Ui.v2");
    check_field_offset(lv, v3, 9, "aUl_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_Ui, aUl_C_Ui)
//============================================================================



static void Test_aUl_C_Ul()
{
  {
    init_simple_test("aUl_C_Ul");
    STRUCT_IF_C aUl_C_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aUl_C_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_Ul)");
    check_field_offset(lv, v1, 0, "aUl_C_Ul.v1");
    check_field_offset(lv, v2, 8, "aUl_C_Ul.v2");
    check_field_offset(lv, v3, 9, "aUl_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_Ul, aUl_C_Ul)
//============================================================================



static void Test_aUl_C_Us()
{
  {
    init_simple_test("aUl_C_Us");
    STRUCT_IF_C aUl_C_Us lv;
    check2(sizeof(lv), 11, "sizeof(aUl_C_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_Us)");
    check_field_offset(lv, v1, 0, "aUl_C_Us.v1");
    check_field_offset(lv, v2, 8, "aUl_C_Us.v2");
    check_field_offset(lv, v3, 9, "aUl_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_Us, aUl_C_Us)
//============================================================================



static void Test_aUl_C_Vp()
{
  {
    init_simple_test("aUl_C_Vp");
    STRUCT_IF_C aUl_C_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_C_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_C_Vp)");
    check_field_offset(lv, v1, 0, "aUl_C_Vp.v1");
    check_field_offset(lv, v2, 8, "aUl_C_Vp.v2");
    check_field_offset(lv, v3, 9, "aUl_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_C_Vp, aUl_C_Vp)
//============================================================================



static void Test_aUl_D()
{
  {
    init_simple_test("aUl_D");
    STRUCT_IF_C aUl_D lv;
    check2(sizeof(lv), 16, "sizeof(aUl_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D)");
    check_field_offset(lv, v1, 0, "aUl_D.v1");
    check_field_offset(lv, v2, 8, "aUl_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D, aUl_D)
//============================================================================



static void Test_aUl_D_BFu15i()
{
  {
    init_simple_test("aUl_D_BFu15i");
    static STRUCT_IF_C aUl_D_BFu15i lv;
    check2(sizeof(lv), 18, "sizeof(aUl_D_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "aUl_D_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "aUl_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu15i, aUl_D_BFu15i)
//============================================================================



static void Test_aUl_D_BFu15ll()
{
  {
    init_simple_test("aUl_D_BFu15ll");
    static STRUCT_IF_C aUl_D_BFu15ll lv;
    check2(sizeof(lv), 18, "sizeof(aUl_D_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "aUl_D_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "aUl_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu15ll, aUl_D_BFu15ll)
//============================================================================



static void Test_aUl_D_BFu15s()
{
  {
    init_simple_test("aUl_D_BFu15s");
    static STRUCT_IF_C aUl_D_BFu15s lv;
    check2(sizeof(lv), 18, "sizeof(aUl_D_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "aUl_D_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "aUl_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu15s, aUl_D_BFu15s)
//============================================================================



static void Test_aUl_D_BFu16i()
{
  {
    init_simple_test("aUl_D_BFu16i");
    static STRUCT_IF_C aUl_D_BFu16i lv;
    check2(sizeof(lv), 18, "sizeof(aUl_D_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "aUl_D_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "aUl_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu16i, aUl_D_BFu16i)
//============================================================================



static void Test_aUl_D_BFu16ll()
{
  {
    init_simple_test("aUl_D_BFu16ll");
    static STRUCT_IF_C aUl_D_BFu16ll lv;
    check2(sizeof(lv), 18, "sizeof(aUl_D_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "aUl_D_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "aUl_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu16ll, aUl_D_BFu16ll)
//============================================================================



static void Test_aUl_D_BFu16s()
{
  {
    init_simple_test("aUl_D_BFu16s");
    static STRUCT_IF_C aUl_D_BFu16s lv;
    check2(sizeof(lv), 18, "sizeof(aUl_D_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "aUl_D_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "aUl_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu16s, aUl_D_BFu16s)
//============================================================================



static void Test_aUl_D_BFu17i()
{
  {
    init_simple_test("aUl_D_BFu17i");
    static STRUCT_IF_C aUl_D_BFu17i lv;
    check2(sizeof(lv), 19, "sizeof(aUl_D_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "aUl_D_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "aUl_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu17i, aUl_D_BFu17i)
//============================================================================



static void Test_aUl_D_BFu17ll()
{
  {
    init_simple_test("aUl_D_BFu17ll");
    static STRUCT_IF_C aUl_D_BFu17ll lv;
    check2(sizeof(lv), 19, "sizeof(aUl_D_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "aUl_D_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "aUl_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu17ll, aUl_D_BFu17ll)
//============================================================================



static void Test_aUl_D_BFu1c()
{
  {
    init_simple_test("aUl_D_BFu1c");
    static STRUCT_IF_C aUl_D_BFu1c lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aUl_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu1c, aUl_D_BFu1c)
//============================================================================



static void Test_aUl_D_BFu1i()
{
  {
    init_simple_test("aUl_D_BFu1i");
    static STRUCT_IF_C aUl_D_BFu1i lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aUl_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu1i, aUl_D_BFu1i)
//============================================================================



static void Test_aUl_D_BFu1ll()
{
  {
    init_simple_test("aUl_D_BFu1ll");
    static STRUCT_IF_C aUl_D_BFu1ll lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aUl_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu1ll, aUl_D_BFu1ll)
//============================================================================



static void Test_aUl_D_BFu1s()
{
  {
    init_simple_test("aUl_D_BFu1s");
    static STRUCT_IF_C aUl_D_BFu1s lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aUl_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu1s, aUl_D_BFu1s)
//============================================================================



static void Test_aUl_D_BFu31i()
{
  {
    init_simple_test("aUl_D_BFu31i");
    static STRUCT_IF_C aUl_D_BFu31i lv;
    check2(sizeof(lv), 20, "sizeof(aUl_D_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "aUl_D_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "aUl_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu31i, aUl_D_BFu31i)
//============================================================================



static void Test_aUl_D_BFu31ll()
{
  {
    init_simple_test("aUl_D_BFu31ll");
    static STRUCT_IF_C aUl_D_BFu31ll lv;
    check2(sizeof(lv), 20, "sizeof(aUl_D_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "aUl_D_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "aUl_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu31ll, aUl_D_BFu31ll)
//============================================================================



static void Test_aUl_D_BFu32i()
{
  {
    init_simple_test("aUl_D_BFu32i");
    static STRUCT_IF_C aUl_D_BFu32i lv;
    check2(sizeof(lv), 20, "sizeof(aUl_D_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "aUl_D_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "aUl_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu32i, aUl_D_BFu32i)
//============================================================================



static void Test_aUl_D_BFu32ll()
{
  {
    init_simple_test("aUl_D_BFu32ll");
    static STRUCT_IF_C aUl_D_BFu32ll lv;
    check2(sizeof(lv), 20, "sizeof(aUl_D_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "aUl_D_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "aUl_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu32ll, aUl_D_BFu32ll)
//============================================================================



static void Test_aUl_D_BFu33()
{
  {
    init_simple_test("aUl_D_BFu33");
    static STRUCT_IF_C aUl_D_BFu33 lv;
    check2(sizeof(lv), 21, "sizeof(aUl_D_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu33.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "aUl_D_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "aUl_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu33, aUl_D_BFu33)
//============================================================================



static void Test_aUl_D_BFu7c()
{
  {
    init_simple_test("aUl_D_BFu7c");
    static STRUCT_IF_C aUl_D_BFu7c lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aUl_D_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aUl_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu7c, aUl_D_BFu7c)
//============================================================================



static void Test_aUl_D_BFu7i()
{
  {
    init_simple_test("aUl_D_BFu7i");
    static STRUCT_IF_C aUl_D_BFu7i lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aUl_D_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aUl_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu7i, aUl_D_BFu7i)
//============================================================================



static void Test_aUl_D_BFu7ll()
{
  {
    init_simple_test("aUl_D_BFu7ll");
    static STRUCT_IF_C aUl_D_BFu7ll lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aUl_D_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aUl_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu7ll, aUl_D_BFu7ll)
//============================================================================



static void Test_aUl_D_BFu7s()
{
  {
    init_simple_test("aUl_D_BFu7s");
    static STRUCT_IF_C aUl_D_BFu7s lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aUl_D_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aUl_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu7s, aUl_D_BFu7s)
//============================================================================



static void Test_aUl_D_BFu8c()
{
  {
    init_simple_test("aUl_D_BFu8c");
    static STRUCT_IF_C aUl_D_BFu8c lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aUl_D_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aUl_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu8c, aUl_D_BFu8c)
//============================================================================



static void Test_aUl_D_BFu8i()
{
  {
    init_simple_test("aUl_D_BFu8i");
    static STRUCT_IF_C aUl_D_BFu8i lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aUl_D_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aUl_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu8i, aUl_D_BFu8i)
//============================================================================



static void Test_aUl_D_BFu8ll()
{
  {
    init_simple_test("aUl_D_BFu8ll");
    static STRUCT_IF_C aUl_D_BFu8ll lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aUl_D_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aUl_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu8ll, aUl_D_BFu8ll)
//============================================================================



static void Test_aUl_D_BFu8s()
{
  {
    init_simple_test("aUl_D_BFu8s");
    static STRUCT_IF_C aUl_D_BFu8s lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aUl_D_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aUl_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu8s, aUl_D_BFu8s)
//============================================================================



static void Test_aUl_D_BFu9i()
{
  {
    init_simple_test("aUl_D_BFu9i");
    static STRUCT_IF_C aUl_D_BFu9i lv;
    check2(sizeof(lv), 18, "sizeof(aUl_D_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "aUl_D_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "aUl_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu9i, aUl_D_BFu9i)
//============================================================================



static void Test_aUl_D_BFu9ll()
{
  {
    init_simple_test("aUl_D_BFu9ll");
    static STRUCT_IF_C aUl_D_BFu9ll lv;
    check2(sizeof(lv), 18, "sizeof(aUl_D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "aUl_D_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "aUl_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu9ll, aUl_D_BFu9ll)
//============================================================================



static void Test_aUl_D_BFu9s()
{
  {
    init_simple_test("aUl_D_BFu9s");
    static STRUCT_IF_C aUl_D_BFu9s lv;
    check2(sizeof(lv), 18, "sizeof(aUl_D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_D_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aUl_D_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "aUl_D_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "aUl_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_BFu9s, aUl_D_BFu9s)
//============================================================================



static void Test_aUl_D_C()
{
  {
    init_simple_test("aUl_D_C");
    STRUCT_IF_C aUl_D_C lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_C)");
    check_field_offset(lv, v1, 0, "aUl_D_C.v1");
    check_field_offset(lv, v2, 8, "aUl_D_C.v2");
    check_field_offset(lv, v3, 16, "aUl_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_C, aUl_D_C)
//============================================================================



static void Test_aUl_D_D()
{
  {
    init_simple_test("aUl_D_D");
    STRUCT_IF_C aUl_D_D lv;
    check2(sizeof(lv), 24, "sizeof(aUl_D_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_D)");
    check_field_offset(lv, v1, 0, "aUl_D_D.v1");
    check_field_offset(lv, v2, 8, "aUl_D_D.v2");
    check_field_offset(lv, v3, 16, "aUl_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_D, aUl_D_D)
//============================================================================



static void Test_aUl_D_F()
{
  {
    init_simple_test("aUl_D_F");
    STRUCT_IF_C aUl_D_F lv;
    check2(sizeof(lv), 20, "sizeof(aUl_D_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_F)");
    check_field_offset(lv, v1, 0, "aUl_D_F.v1");
    check_field_offset(lv, v2, 8, "aUl_D_F.v2");
    check_field_offset(lv, v3, 16, "aUl_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_F, aUl_D_F)
//============================================================================



static void Test_aUl_D_I()
{
  {
    init_simple_test("aUl_D_I");
    STRUCT_IF_C aUl_D_I lv;
    check2(sizeof(lv), 20, "sizeof(aUl_D_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_I)");
    check_field_offset(lv, v1, 0, "aUl_D_I.v1");
    check_field_offset(lv, v2, 8, "aUl_D_I.v2");
    check_field_offset(lv, v3, 16, "aUl_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_I, aUl_D_I)
//============================================================================



static void Test_aUl_D_Ip()
{
  {
    init_simple_test("aUl_D_Ip");
    STRUCT_IF_C aUl_D_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aUl_D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_Ip)");
    check_field_offset(lv, v1, 0, "aUl_D_Ip.v1");
    check_field_offset(lv, v2, 8, "aUl_D_Ip.v2");
    check_field_offset(lv, v3, 16, "aUl_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_Ip, aUl_D_Ip)
//============================================================================



static void Test_aUl_D_L()
{
  {
    init_simple_test("aUl_D_L");
    STRUCT_IF_C aUl_D_L lv;
    check2(sizeof(lv), 24, "sizeof(aUl_D_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_L)");
    check_field_offset(lv, v1, 0, "aUl_D_L.v1");
    check_field_offset(lv, v2, 8, "aUl_D_L.v2");
    check_field_offset(lv, v3, 16, "aUl_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_L, aUl_D_L)
//============================================================================



static void Test_aUl_D_S()
{
  {
    init_simple_test("aUl_D_S");
    STRUCT_IF_C aUl_D_S lv;
    check2(sizeof(lv), 18, "sizeof(aUl_D_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_S)");
    check_field_offset(lv, v1, 0, "aUl_D_S.v1");
    check_field_offset(lv, v2, 8, "aUl_D_S.v2");
    check_field_offset(lv, v3, 16, "aUl_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_S, aUl_D_S)
//============================================================================



static void Test_aUl_D_Uc()
{
  {
    init_simple_test("aUl_D_Uc");
    STRUCT_IF_C aUl_D_Uc lv;
    check2(sizeof(lv), 17, "sizeof(aUl_D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_Uc)");
    check_field_offset(lv, v1, 0, "aUl_D_Uc.v1");
    check_field_offset(lv, v2, 8, "aUl_D_Uc.v2");
    check_field_offset(lv, v3, 16, "aUl_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_Uc, aUl_D_Uc)
//============================================================================



static void Test_aUl_D_Ui()
{
  {
    init_simple_test("aUl_D_Ui");
    STRUCT_IF_C aUl_D_Ui lv;
    check2(sizeof(lv), 20, "sizeof(aUl_D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_Ui)");
    check_field_offset(lv, v1, 0, "aUl_D_Ui.v1");
    check_field_offset(lv, v2, 8, "aUl_D_Ui.v2");
    check_field_offset(lv, v3, 16, "aUl_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_Ui, aUl_D_Ui)
//============================================================================



static void Test_aUl_D_Ul()
{
  {
    init_simple_test("aUl_D_Ul");
    STRUCT_IF_C aUl_D_Ul lv;
    check2(sizeof(lv), 24, "sizeof(aUl_D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_Ul)");
    check_field_offset(lv, v1, 0, "aUl_D_Ul.v1");
    check_field_offset(lv, v2, 8, "aUl_D_Ul.v2");
    check_field_offset(lv, v3, 16, "aUl_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_Ul, aUl_D_Ul)
//============================================================================



static void Test_aUl_D_Us()
{
  {
    init_simple_test("aUl_D_Us");
    STRUCT_IF_C aUl_D_Us lv;
    check2(sizeof(lv), 18, "sizeof(aUl_D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_Us)");
    check_field_offset(lv, v1, 0, "aUl_D_Us.v1");
    check_field_offset(lv, v2, 8, "aUl_D_Us.v2");
    check_field_offset(lv, v3, 16, "aUl_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_Us, aUl_D_Us)
//============================================================================



static void Test_aUl_D_Vp()
{
  {
    init_simple_test("aUl_D_Vp");
    STRUCT_IF_C aUl_D_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aUl_D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_D_Vp)");
    check_field_offset(lv, v1, 0, "aUl_D_Vp.v1");
    check_field_offset(lv, v2, 8, "aUl_D_Vp.v2");
    check_field_offset(lv, v3, 16, "aUl_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_D_Vp, aUl_D_Vp)
//============================================================================



static void Test_aUl_F()
{
  {
    init_simple_test("aUl_F");
    STRUCT_IF_C aUl_F lv;
    check2(sizeof(lv), 12, "sizeof(aUl_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F)");
    check_field_offset(lv, v1, 0, "aUl_F.v1");
    check_field_offset(lv, v2, 8, "aUl_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F, aUl_F)
//============================================================================



static void Test_aUl_F_BFu15i()
{
  {
    init_simple_test("aUl_F_BFu15i");
    static STRUCT_IF_C aUl_F_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aUl_F_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aUl_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu15i, aUl_F_BFu15i)
//============================================================================



static void Test_aUl_F_BFu15ll()
{
  {
    init_simple_test("aUl_F_BFu15ll");
    static STRUCT_IF_C aUl_F_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aUl_F_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aUl_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu15ll, aUl_F_BFu15ll)
//============================================================================



static void Test_aUl_F_BFu15s()
{
  {
    init_simple_test("aUl_F_BFu15s");
    static STRUCT_IF_C aUl_F_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(aUl_F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aUl_F_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aUl_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu15s, aUl_F_BFu15s)
//============================================================================



static void Test_aUl_F_BFu16i()
{
  {
    init_simple_test("aUl_F_BFu16i");
    static STRUCT_IF_C aUl_F_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aUl_F_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aUl_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu16i, aUl_F_BFu16i)
//============================================================================



static void Test_aUl_F_BFu16ll()
{
  {
    init_simple_test("aUl_F_BFu16ll");
    static STRUCT_IF_C aUl_F_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aUl_F_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aUl_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu16ll, aUl_F_BFu16ll)
//============================================================================



static void Test_aUl_F_BFu16s()
{
  {
    init_simple_test("aUl_F_BFu16s");
    static STRUCT_IF_C aUl_F_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(aUl_F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aUl_F_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aUl_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu16s, aUl_F_BFu16s)
//============================================================================



static void Test_aUl_F_BFu17i()
{
  {
    init_simple_test("aUl_F_BFu17i");
    static STRUCT_IF_C aUl_F_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(aUl_F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aUl_F_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aUl_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu17i, aUl_F_BFu17i)
//============================================================================



static void Test_aUl_F_BFu17ll()
{
  {
    init_simple_test("aUl_F_BFu17ll");
    static STRUCT_IF_C aUl_F_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(aUl_F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aUl_F_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aUl_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu17ll, aUl_F_BFu17ll)
//============================================================================



static void Test_aUl_F_BFu1c()
{
  {
    init_simple_test("aUl_F_BFu1c");
    static STRUCT_IF_C aUl_F_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aUl_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu1c, aUl_F_BFu1c)
//============================================================================



static void Test_aUl_F_BFu1i()
{
  {
    init_simple_test("aUl_F_BFu1i");
    static STRUCT_IF_C aUl_F_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aUl_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu1i, aUl_F_BFu1i)
//============================================================================



static void Test_aUl_F_BFu1ll()
{
  {
    init_simple_test("aUl_F_BFu1ll");
    static STRUCT_IF_C aUl_F_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aUl_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu1ll, aUl_F_BFu1ll)
//============================================================================



static void Test_aUl_F_BFu1s()
{
  {
    init_simple_test("aUl_F_BFu1s");
    static STRUCT_IF_C aUl_F_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aUl_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu1s, aUl_F_BFu1s)
//============================================================================



static void Test_aUl_F_BFu31i()
{
  {
    init_simple_test("aUl_F_BFu31i");
    static STRUCT_IF_C aUl_F_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(aUl_F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aUl_F_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aUl_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu31i, aUl_F_BFu31i)
//============================================================================



static void Test_aUl_F_BFu31ll()
{
  {
    init_simple_test("aUl_F_BFu31ll");
    static STRUCT_IF_C aUl_F_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(aUl_F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aUl_F_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aUl_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu31ll, aUl_F_BFu31ll)
//============================================================================



static void Test_aUl_F_BFu32i()
{
  {
    init_simple_test("aUl_F_BFu32i");
    static STRUCT_IF_C aUl_F_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(aUl_F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aUl_F_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aUl_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu32i, aUl_F_BFu32i)
//============================================================================



static void Test_aUl_F_BFu32ll()
{
  {
    init_simple_test("aUl_F_BFu32ll");
    static STRUCT_IF_C aUl_F_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(aUl_F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aUl_F_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aUl_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu32ll, aUl_F_BFu32ll)
//============================================================================



static void Test_aUl_F_BFu33()
{
  {
    init_simple_test("aUl_F_BFu33");
    static STRUCT_IF_C aUl_F_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(aUl_F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu33.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu33.v2");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "aUl_F_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "aUl_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu33, aUl_F_BFu33)
//============================================================================



static void Test_aUl_F_BFu7c()
{
  {
    init_simple_test("aUl_F_BFu7c");
    static STRUCT_IF_C aUl_F_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aUl_F_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aUl_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu7c, aUl_F_BFu7c)
//============================================================================



static void Test_aUl_F_BFu7i()
{
  {
    init_simple_test("aUl_F_BFu7i");
    static STRUCT_IF_C aUl_F_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aUl_F_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aUl_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu7i, aUl_F_BFu7i)
//============================================================================



static void Test_aUl_F_BFu7ll()
{
  {
    init_simple_test("aUl_F_BFu7ll");
    static STRUCT_IF_C aUl_F_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aUl_F_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aUl_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu7ll, aUl_F_BFu7ll)
//============================================================================



static void Test_aUl_F_BFu7s()
{
  {
    init_simple_test("aUl_F_BFu7s");
    static STRUCT_IF_C aUl_F_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aUl_F_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aUl_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu7s, aUl_F_BFu7s)
//============================================================================



static void Test_aUl_F_BFu8c()
{
  {
    init_simple_test("aUl_F_BFu8c");
    static STRUCT_IF_C aUl_F_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aUl_F_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aUl_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu8c, aUl_F_BFu8c)
//============================================================================



static void Test_aUl_F_BFu8i()
{
  {
    init_simple_test("aUl_F_BFu8i");
    static STRUCT_IF_C aUl_F_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aUl_F_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aUl_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu8i, aUl_F_BFu8i)
//============================================================================



static void Test_aUl_F_BFu8ll()
{
  {
    init_simple_test("aUl_F_BFu8ll");
    static STRUCT_IF_C aUl_F_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aUl_F_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aUl_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu8ll, aUl_F_BFu8ll)
//============================================================================



static void Test_aUl_F_BFu8s()
{
  {
    init_simple_test("aUl_F_BFu8s");
    static STRUCT_IF_C aUl_F_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aUl_F_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aUl_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu8s, aUl_F_BFu8s)
//============================================================================



static void Test_aUl_F_BFu9i()
{
  {
    init_simple_test("aUl_F_BFu9i");
    static STRUCT_IF_C aUl_F_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_F_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aUl_F_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aUl_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu9i, aUl_F_BFu9i)
//============================================================================



static void Test_aUl_F_BFu9ll()
{
  {
    init_simple_test("aUl_F_BFu9ll");
    static STRUCT_IF_C aUl_F_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_F_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aUl_F_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aUl_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu9ll, aUl_F_BFu9ll)
//============================================================================



static void Test_aUl_F_BFu9s()
{
  {
    init_simple_test("aUl_F_BFu9s");
    static STRUCT_IF_C aUl_F_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(aUl_F_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_F_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aUl_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aUl_F_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aUl_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_BFu9s, aUl_F_BFu9s)
//============================================================================



static void Test_aUl_F_C()
{
  {
    init_simple_test("aUl_F_C");
    STRUCT_IF_C aUl_F_C lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_C)");
    check_field_offset(lv, v1, 0, "aUl_F_C.v1");
    check_field_offset(lv, v2, 8, "aUl_F_C.v2");
    check_field_offset(lv, v3, 12, "aUl_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_C, aUl_F_C)
//============================================================================



static void Test_aUl_F_D()
{
  {
    init_simple_test("aUl_F_D");
    STRUCT_IF_C aUl_F_D lv;
    check2(sizeof(lv), 20, "sizeof(aUl_F_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_D)");
    check_field_offset(lv, v1, 0, "aUl_F_D.v1");
    check_field_offset(lv, v2, 8, "aUl_F_D.v2");
    check_field_offset(lv, v3, 12, "aUl_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_D, aUl_F_D)
//============================================================================



static void Test_aUl_F_F()
{
  {
    init_simple_test("aUl_F_F");
    STRUCT_IF_C aUl_F_F lv;
    check2(sizeof(lv), 16, "sizeof(aUl_F_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_F)");
    check_field_offset(lv, v1, 0, "aUl_F_F.v1");
    check_field_offset(lv, v2, 8, "aUl_F_F.v2");
    check_field_offset(lv, v3, 12, "aUl_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_F, aUl_F_F)
//============================================================================



static void Test_aUl_F_I()
{
  {
    init_simple_test("aUl_F_I");
    STRUCT_IF_C aUl_F_I lv;
    check2(sizeof(lv), 16, "sizeof(aUl_F_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_I)");
    check_field_offset(lv, v1, 0, "aUl_F_I.v1");
    check_field_offset(lv, v2, 8, "aUl_F_I.v2");
    check_field_offset(lv, v3, 12, "aUl_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_I, aUl_F_I)
//============================================================================



static void Test_aUl_F_Ip()
{
  {
    init_simple_test("aUl_F_Ip");
    STRUCT_IF_C aUl_F_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_F_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_Ip)");
    check_field_offset(lv, v1, 0, "aUl_F_Ip.v1");
    check_field_offset(lv, v2, 8, "aUl_F_Ip.v2");
    check_field_offset(lv, v3, 12, "aUl_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_Ip, aUl_F_Ip)
//============================================================================



static void Test_aUl_F_L()
{
  {
    init_simple_test("aUl_F_L");
    STRUCT_IF_C aUl_F_L lv;
    check2(sizeof(lv), 20, "sizeof(aUl_F_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_L)");
    check_field_offset(lv, v1, 0, "aUl_F_L.v1");
    check_field_offset(lv, v2, 8, "aUl_F_L.v2");
    check_field_offset(lv, v3, 12, "aUl_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_L, aUl_F_L)
//============================================================================



static void Test_aUl_F_S()
{
  {
    init_simple_test("aUl_F_S");
    STRUCT_IF_C aUl_F_S lv;
    check2(sizeof(lv), 14, "sizeof(aUl_F_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_S)");
    check_field_offset(lv, v1, 0, "aUl_F_S.v1");
    check_field_offset(lv, v2, 8, "aUl_F_S.v2");
    check_field_offset(lv, v3, 12, "aUl_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_S, aUl_F_S)
//============================================================================



static void Test_aUl_F_Uc()
{
  {
    init_simple_test("aUl_F_Uc");
    STRUCT_IF_C aUl_F_Uc lv;
    check2(sizeof(lv), 13, "sizeof(aUl_F_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_Uc)");
    check_field_offset(lv, v1, 0, "aUl_F_Uc.v1");
    check_field_offset(lv, v2, 8, "aUl_F_Uc.v2");
    check_field_offset(lv, v3, 12, "aUl_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_Uc, aUl_F_Uc)
//============================================================================



static void Test_aUl_F_Ui()
{
  {
    init_simple_test("aUl_F_Ui");
    STRUCT_IF_C aUl_F_Ui lv;
    check2(sizeof(lv), 16, "sizeof(aUl_F_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_Ui)");
    check_field_offset(lv, v1, 0, "aUl_F_Ui.v1");
    check_field_offset(lv, v2, 8, "aUl_F_Ui.v2");
    check_field_offset(lv, v3, 12, "aUl_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_Ui, aUl_F_Ui)
//============================================================================



static void Test_aUl_F_Ul()
{
  {
    init_simple_test("aUl_F_Ul");
    STRUCT_IF_C aUl_F_Ul lv;
    check2(sizeof(lv), 20, "sizeof(aUl_F_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_Ul)");
    check_field_offset(lv, v1, 0, "aUl_F_Ul.v1");
    check_field_offset(lv, v2, 8, "aUl_F_Ul.v2");
    check_field_offset(lv, v3, 12, "aUl_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_Ul, aUl_F_Ul)
//============================================================================



static void Test_aUl_F_Us()
{
  {
    init_simple_test("aUl_F_Us");
    STRUCT_IF_C aUl_F_Us lv;
    check2(sizeof(lv), 14, "sizeof(aUl_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_Us)");
    check_field_offset(lv, v1, 0, "aUl_F_Us.v1");
    check_field_offset(lv, v2, 8, "aUl_F_Us.v2");
    check_field_offset(lv, v3, 12, "aUl_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_Us, aUl_F_Us)
//============================================================================



static void Test_aUl_F_Vp()
{
  {
    init_simple_test("aUl_F_Vp");
    STRUCT_IF_C aUl_F_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_F_Vp)");
    check_field_offset(lv, v1, 0, "aUl_F_Vp.v1");
    check_field_offset(lv, v2, 8, "aUl_F_Vp.v2");
    check_field_offset(lv, v3, 12, "aUl_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_F_Vp, aUl_F_Vp)
//============================================================================



static void Test_aUl_I()
{
  {
    init_simple_test("aUl_I");
    STRUCT_IF_C aUl_I lv;
    check2(sizeof(lv), 12, "sizeof(aUl_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I)");
    check_field_offset(lv, v1, 0, "aUl_I.v1");
    check_field_offset(lv, v2, 8, "aUl_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I, aUl_I)
//============================================================================



static void Test_aUl_I_BFu15i()
{
  {
    init_simple_test("aUl_I_BFu15i");
    static STRUCT_IF_C aUl_I_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aUl_I_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aUl_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu15i, aUl_I_BFu15i)
//============================================================================



static void Test_aUl_I_BFu15ll()
{
  {
    init_simple_test("aUl_I_BFu15ll");
    static STRUCT_IF_C aUl_I_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aUl_I_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aUl_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu15ll, aUl_I_BFu15ll)
//============================================================================



static void Test_aUl_I_BFu15s()
{
  {
    init_simple_test("aUl_I_BFu15s");
    static STRUCT_IF_C aUl_I_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(aUl_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aUl_I_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aUl_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu15s, aUl_I_BFu15s)
//============================================================================



static void Test_aUl_I_BFu16i()
{
  {
    init_simple_test("aUl_I_BFu16i");
    static STRUCT_IF_C aUl_I_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aUl_I_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aUl_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu16i, aUl_I_BFu16i)
//============================================================================



static void Test_aUl_I_BFu16ll()
{
  {
    init_simple_test("aUl_I_BFu16ll");
    static STRUCT_IF_C aUl_I_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aUl_I_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aUl_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu16ll, aUl_I_BFu16ll)
//============================================================================



static void Test_aUl_I_BFu16s()
{
  {
    init_simple_test("aUl_I_BFu16s");
    static STRUCT_IF_C aUl_I_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(aUl_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aUl_I_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aUl_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu16s, aUl_I_BFu16s)
//============================================================================



static void Test_aUl_I_BFu17i()
{
  {
    init_simple_test("aUl_I_BFu17i");
    static STRUCT_IF_C aUl_I_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(aUl_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aUl_I_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aUl_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu17i, aUl_I_BFu17i)
//============================================================================



static void Test_aUl_I_BFu17ll()
{
  {
    init_simple_test("aUl_I_BFu17ll");
    static STRUCT_IF_C aUl_I_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(aUl_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aUl_I_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aUl_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu17ll, aUl_I_BFu17ll)
//============================================================================



static void Test_aUl_I_BFu1c()
{
  {
    init_simple_test("aUl_I_BFu1c");
    static STRUCT_IF_C aUl_I_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aUl_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu1c, aUl_I_BFu1c)
//============================================================================



static void Test_aUl_I_BFu1i()
{
  {
    init_simple_test("aUl_I_BFu1i");
    static STRUCT_IF_C aUl_I_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aUl_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu1i, aUl_I_BFu1i)
//============================================================================



static void Test_aUl_I_BFu1ll()
{
  {
    init_simple_test("aUl_I_BFu1ll");
    static STRUCT_IF_C aUl_I_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aUl_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu1ll, aUl_I_BFu1ll)
//============================================================================



static void Test_aUl_I_BFu1s()
{
  {
    init_simple_test("aUl_I_BFu1s");
    static STRUCT_IF_C aUl_I_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aUl_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu1s, aUl_I_BFu1s)
//============================================================================



static void Test_aUl_I_BFu31i()
{
  {
    init_simple_test("aUl_I_BFu31i");
    static STRUCT_IF_C aUl_I_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(aUl_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aUl_I_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aUl_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu31i, aUl_I_BFu31i)
//============================================================================



static void Test_aUl_I_BFu31ll()
{
  {
    init_simple_test("aUl_I_BFu31ll");
    static STRUCT_IF_C aUl_I_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(aUl_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aUl_I_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aUl_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu31ll, aUl_I_BFu31ll)
//============================================================================



static void Test_aUl_I_BFu32i()
{
  {
    init_simple_test("aUl_I_BFu32i");
    static STRUCT_IF_C aUl_I_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(aUl_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aUl_I_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aUl_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu32i, aUl_I_BFu32i)
//============================================================================



static void Test_aUl_I_BFu32ll()
{
  {
    init_simple_test("aUl_I_BFu32ll");
    static STRUCT_IF_C aUl_I_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(aUl_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aUl_I_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aUl_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu32ll, aUl_I_BFu32ll)
//============================================================================



static void Test_aUl_I_BFu33()
{
  {
    init_simple_test("aUl_I_BFu33");
    static STRUCT_IF_C aUl_I_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(aUl_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu33.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu33.v2");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "aUl_I_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "aUl_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu33, aUl_I_BFu33)
//============================================================================



static void Test_aUl_I_BFu7c()
{
  {
    init_simple_test("aUl_I_BFu7c");
    static STRUCT_IF_C aUl_I_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aUl_I_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aUl_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu7c, aUl_I_BFu7c)
//============================================================================



static void Test_aUl_I_BFu7i()
{
  {
    init_simple_test("aUl_I_BFu7i");
    static STRUCT_IF_C aUl_I_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aUl_I_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aUl_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu7i, aUl_I_BFu7i)
//============================================================================



static void Test_aUl_I_BFu7ll()
{
  {
    init_simple_test("aUl_I_BFu7ll");
    static STRUCT_IF_C aUl_I_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aUl_I_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aUl_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu7ll, aUl_I_BFu7ll)
//============================================================================



static void Test_aUl_I_BFu7s()
{
  {
    init_simple_test("aUl_I_BFu7s");
    static STRUCT_IF_C aUl_I_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aUl_I_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aUl_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu7s, aUl_I_BFu7s)
//============================================================================



static void Test_aUl_I_BFu8c()
{
  {
    init_simple_test("aUl_I_BFu8c");
    static STRUCT_IF_C aUl_I_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aUl_I_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aUl_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu8c, aUl_I_BFu8c)
//============================================================================



static void Test_aUl_I_BFu8i()
{
  {
    init_simple_test("aUl_I_BFu8i");
    static STRUCT_IF_C aUl_I_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aUl_I_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aUl_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu8i, aUl_I_BFu8i)
//============================================================================



static void Test_aUl_I_BFu8ll()
{
  {
    init_simple_test("aUl_I_BFu8ll");
    static STRUCT_IF_C aUl_I_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aUl_I_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aUl_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu8ll, aUl_I_BFu8ll)
//============================================================================



static void Test_aUl_I_BFu8s()
{
  {
    init_simple_test("aUl_I_BFu8s");
    static STRUCT_IF_C aUl_I_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aUl_I_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aUl_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu8s, aUl_I_BFu8s)
//============================================================================



static void Test_aUl_I_BFu9i()
{
  {
    init_simple_test("aUl_I_BFu9i");
    static STRUCT_IF_C aUl_I_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aUl_I_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aUl_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu9i, aUl_I_BFu9i)
//============================================================================



static void Test_aUl_I_BFu9ll()
{
  {
    init_simple_test("aUl_I_BFu9ll");
    static STRUCT_IF_C aUl_I_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aUl_I_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aUl_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu9ll, aUl_I_BFu9ll)
//============================================================================



static void Test_aUl_I_BFu9s()
{
  {
    init_simple_test("aUl_I_BFu9s");
    static STRUCT_IF_C aUl_I_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(aUl_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_I_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aUl_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aUl_I_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aUl_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_BFu9s, aUl_I_BFu9s)
//============================================================================



static void Test_aUl_I_C()
{
  {
    init_simple_test("aUl_I_C");
    STRUCT_IF_C aUl_I_C lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_C)");
    check_field_offset(lv, v1, 0, "aUl_I_C.v1");
    check_field_offset(lv, v2, 8, "aUl_I_C.v2");
    check_field_offset(lv, v3, 12, "aUl_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_C, aUl_I_C)
//============================================================================



static void Test_aUl_I_D()
{
  {
    init_simple_test("aUl_I_D");
    STRUCT_IF_C aUl_I_D lv;
    check2(sizeof(lv), 20, "sizeof(aUl_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_D)");
    check_field_offset(lv, v1, 0, "aUl_I_D.v1");
    check_field_offset(lv, v2, 8, "aUl_I_D.v2");
    check_field_offset(lv, v3, 12, "aUl_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_D, aUl_I_D)
//============================================================================



static void Test_aUl_I_F()
{
  {
    init_simple_test("aUl_I_F");
    STRUCT_IF_C aUl_I_F lv;
    check2(sizeof(lv), 16, "sizeof(aUl_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_F)");
    check_field_offset(lv, v1, 0, "aUl_I_F.v1");
    check_field_offset(lv, v2, 8, "aUl_I_F.v2");
    check_field_offset(lv, v3, 12, "aUl_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_F, aUl_I_F)
//============================================================================



static void Test_aUl_I_I()
{
  {
    init_simple_test("aUl_I_I");
    STRUCT_IF_C aUl_I_I lv;
    check2(sizeof(lv), 16, "sizeof(aUl_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_I)");
    check_field_offset(lv, v1, 0, "aUl_I_I.v1");
    check_field_offset(lv, v2, 8, "aUl_I_I.v2");
    check_field_offset(lv, v3, 12, "aUl_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_I, aUl_I_I)
//============================================================================



static void Test_aUl_I_Ip()
{
  {
    init_simple_test("aUl_I_Ip");
    STRUCT_IF_C aUl_I_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_Ip)");
    check_field_offset(lv, v1, 0, "aUl_I_Ip.v1");
    check_field_offset(lv, v2, 8, "aUl_I_Ip.v2");
    check_field_offset(lv, v3, 12, "aUl_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_Ip, aUl_I_Ip)
//============================================================================



static void Test_aUl_I_L()
{
  {
    init_simple_test("aUl_I_L");
    STRUCT_IF_C aUl_I_L lv;
    check2(sizeof(lv), 20, "sizeof(aUl_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_L)");
    check_field_offset(lv, v1, 0, "aUl_I_L.v1");
    check_field_offset(lv, v2, 8, "aUl_I_L.v2");
    check_field_offset(lv, v3, 12, "aUl_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_L, aUl_I_L)
//============================================================================



static void Test_aUl_I_S()
{
  {
    init_simple_test("aUl_I_S");
    STRUCT_IF_C aUl_I_S lv;
    check2(sizeof(lv), 14, "sizeof(aUl_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_S)");
    check_field_offset(lv, v1, 0, "aUl_I_S.v1");
    check_field_offset(lv, v2, 8, "aUl_I_S.v2");
    check_field_offset(lv, v3, 12, "aUl_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_S, aUl_I_S)
//============================================================================



static void Test_aUl_I_Uc()
{
  {
    init_simple_test("aUl_I_Uc");
    STRUCT_IF_C aUl_I_Uc lv;
    check2(sizeof(lv), 13, "sizeof(aUl_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_Uc)");
    check_field_offset(lv, v1, 0, "aUl_I_Uc.v1");
    check_field_offset(lv, v2, 8, "aUl_I_Uc.v2");
    check_field_offset(lv, v3, 12, "aUl_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_Uc, aUl_I_Uc)
//============================================================================



static void Test_aUl_I_Ui()
{
  {
    init_simple_test("aUl_I_Ui");
    STRUCT_IF_C aUl_I_Ui lv;
    check2(sizeof(lv), 16, "sizeof(aUl_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_Ui)");
    check_field_offset(lv, v1, 0, "aUl_I_Ui.v1");
    check_field_offset(lv, v2, 8, "aUl_I_Ui.v2");
    check_field_offset(lv, v3, 12, "aUl_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_Ui, aUl_I_Ui)
//============================================================================



static void Test_aUl_I_Ul()
{
  {
    init_simple_test("aUl_I_Ul");
    STRUCT_IF_C aUl_I_Ul lv;
    check2(sizeof(lv), 20, "sizeof(aUl_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_Ul)");
    check_field_offset(lv, v1, 0, "aUl_I_Ul.v1");
    check_field_offset(lv, v2, 8, "aUl_I_Ul.v2");
    check_field_offset(lv, v3, 12, "aUl_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_Ul, aUl_I_Ul)
//============================================================================



static void Test_aUl_I_Us()
{
  {
    init_simple_test("aUl_I_Us");
    STRUCT_IF_C aUl_I_Us lv;
    check2(sizeof(lv), 14, "sizeof(aUl_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_Us)");
    check_field_offset(lv, v1, 0, "aUl_I_Us.v1");
    check_field_offset(lv, v2, 8, "aUl_I_Us.v2");
    check_field_offset(lv, v3, 12, "aUl_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_Us, aUl_I_Us)
//============================================================================



static void Test_aUl_I_Vp()
{
  {
    init_simple_test("aUl_I_Vp");
    STRUCT_IF_C aUl_I_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_I_Vp)");
    check_field_offset(lv, v1, 0, "aUl_I_Vp.v1");
    check_field_offset(lv, v2, 8, "aUl_I_Vp.v2");
    check_field_offset(lv, v3, 12, "aUl_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_I_Vp, aUl_I_Vp)
//============================================================================



static void Test_aUl_Ip()
{
  {
    init_simple_test("aUl_Ip");
    STRUCT_IF_C aUl_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUl_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip)");
    check_field_offset(lv, v1, 0, "aUl_Ip.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip, aUl_Ip)
//============================================================================



static void Test_aUl_Ip_BFu15i()
{
  {
    init_simple_test("aUl_Ip_BFu15i");
    static STRUCT_IF_C aUl_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aUl_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aUl_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu15i, aUl_Ip_BFu15i)
//============================================================================



static void Test_aUl_Ip_BFu15ll()
{
  {
    init_simple_test("aUl_Ip_BFu15ll");
    static STRUCT_IF_C aUl_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aUl_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aUl_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu15ll, aUl_Ip_BFu15ll)
//============================================================================



static void Test_aUl_Ip_BFu15s()
{
  {
    init_simple_test("aUl_Ip_BFu15s");
    static STRUCT_IF_C aUl_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aUl_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aUl_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu15s, aUl_Ip_BFu15s)
//============================================================================



static void Test_aUl_Ip_BFu16i()
{
  {
    init_simple_test("aUl_Ip_BFu16i");
    static STRUCT_IF_C aUl_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aUl_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aUl_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu16i, aUl_Ip_BFu16i)
//============================================================================



static void Test_aUl_Ip_BFu16ll()
{
  {
    init_simple_test("aUl_Ip_BFu16ll");
    static STRUCT_IF_C aUl_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aUl_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aUl_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu16ll, aUl_Ip_BFu16ll)
//============================================================================



static void Test_aUl_Ip_BFu16s()
{
  {
    init_simple_test("aUl_Ip_BFu16s");
    static STRUCT_IF_C aUl_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aUl_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aUl_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu16s, aUl_Ip_BFu16s)
//============================================================================



static void Test_aUl_Ip_BFu17i()
{
  {
    init_simple_test("aUl_Ip_BFu17i");
    static STRUCT_IF_C aUl_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aUl_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "aUl_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "aUl_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu17i, aUl_Ip_BFu17i)
//============================================================================



static void Test_aUl_Ip_BFu17ll()
{
  {
    init_simple_test("aUl_Ip_BFu17ll");
    static STRUCT_IF_C aUl_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aUl_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "aUl_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "aUl_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu17ll, aUl_Ip_BFu17ll)
//============================================================================



static void Test_aUl_Ip_BFu1c()
{
  {
    init_simple_test("aUl_Ip_BFu1c");
    static STRUCT_IF_C aUl_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aUl_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu1c, aUl_Ip_BFu1c)
//============================================================================



static void Test_aUl_Ip_BFu1i()
{
  {
    init_simple_test("aUl_Ip_BFu1i");
    static STRUCT_IF_C aUl_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aUl_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu1i, aUl_Ip_BFu1i)
//============================================================================



static void Test_aUl_Ip_BFu1ll()
{
  {
    init_simple_test("aUl_Ip_BFu1ll");
    static STRUCT_IF_C aUl_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aUl_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu1ll, aUl_Ip_BFu1ll)
//============================================================================



static void Test_aUl_Ip_BFu1s()
{
  {
    init_simple_test("aUl_Ip_BFu1s");
    static STRUCT_IF_C aUl_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aUl_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu1s, aUl_Ip_BFu1s)
//============================================================================



static void Test_aUl_Ip_BFu31i()
{
  {
    init_simple_test("aUl_Ip_BFu31i");
    static STRUCT_IF_C aUl_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "aUl_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "aUl_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu31i, aUl_Ip_BFu31i)
//============================================================================



static void Test_aUl_Ip_BFu31ll()
{
  {
    init_simple_test("aUl_Ip_BFu31ll");
    static STRUCT_IF_C aUl_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "aUl_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "aUl_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu31ll, aUl_Ip_BFu31ll)
//============================================================================



static void Test_aUl_Ip_BFu32i()
{
  {
    init_simple_test("aUl_Ip_BFu32i");
    static STRUCT_IF_C aUl_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "aUl_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "aUl_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu32i, aUl_Ip_BFu32i)
//============================================================================



static void Test_aUl_Ip_BFu32ll()
{
  {
    init_simple_test("aUl_Ip_BFu32ll");
    static STRUCT_IF_C aUl_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "aUl_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "aUl_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu32ll, aUl_Ip_BFu32ll)
//============================================================================



static void Test_aUl_Ip_BFu33()
{
  {
    init_simple_test("aUl_Ip_BFu33");
    static STRUCT_IF_C aUl_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(aUl_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu33.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "aUl_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "aUl_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu33, aUl_Ip_BFu33)
//============================================================================



static void Test_aUl_Ip_BFu7c()
{
  {
    init_simple_test("aUl_Ip_BFu7c");
    static STRUCT_IF_C aUl_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aUl_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aUl_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu7c, aUl_Ip_BFu7c)
//============================================================================



static void Test_aUl_Ip_BFu7i()
{
  {
    init_simple_test("aUl_Ip_BFu7i");
    static STRUCT_IF_C aUl_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aUl_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aUl_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu7i, aUl_Ip_BFu7i)
//============================================================================



static void Test_aUl_Ip_BFu7ll()
{
  {
    init_simple_test("aUl_Ip_BFu7ll");
    static STRUCT_IF_C aUl_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aUl_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aUl_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu7ll, aUl_Ip_BFu7ll)
//============================================================================



static void Test_aUl_Ip_BFu7s()
{
  {
    init_simple_test("aUl_Ip_BFu7s");
    static STRUCT_IF_C aUl_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aUl_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aUl_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu7s, aUl_Ip_BFu7s)
//============================================================================



static void Test_aUl_Ip_BFu8c()
{
  {
    init_simple_test("aUl_Ip_BFu8c");
    static STRUCT_IF_C aUl_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aUl_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aUl_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu8c, aUl_Ip_BFu8c)
//============================================================================



static void Test_aUl_Ip_BFu8i()
{
  {
    init_simple_test("aUl_Ip_BFu8i");
    static STRUCT_IF_C aUl_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aUl_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aUl_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu8i, aUl_Ip_BFu8i)
//============================================================================



static void Test_aUl_Ip_BFu8ll()
{
  {
    init_simple_test("aUl_Ip_BFu8ll");
    static STRUCT_IF_C aUl_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aUl_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aUl_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu8ll, aUl_Ip_BFu8ll)
//============================================================================



static void Test_aUl_Ip_BFu8s()
{
  {
    init_simple_test("aUl_Ip_BFu8s");
    static STRUCT_IF_C aUl_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aUl_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aUl_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu8s, aUl_Ip_BFu8s)
//============================================================================



static void Test_aUl_Ip_BFu9i()
{
  {
    init_simple_test("aUl_Ip_BFu9i");
    static STRUCT_IF_C aUl_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aUl_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aUl_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu9i, aUl_Ip_BFu9i)
//============================================================================



static void Test_aUl_Ip_BFu9ll()
{
  {
    init_simple_test("aUl_Ip_BFu9ll");
    static STRUCT_IF_C aUl_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aUl_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aUl_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu9ll, aUl_Ip_BFu9ll)
//============================================================================



static void Test_aUl_Ip_BFu9s()
{
  {
    init_simple_test("aUl_Ip_BFu9s");
    static STRUCT_IF_C aUl_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_Ip_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aUl_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aUl_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_BFu9s, aUl_Ip_BFu9s)
//============================================================================



static void Test_aUl_Ip_C()
{
  {
    init_simple_test("aUl_Ip_C");
    STRUCT_IF_C aUl_Ip_C lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_C)");
    check_field_offset(lv, v1, 0, "aUl_Ip_C.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_C, aUl_Ip_C)
//============================================================================



static void Test_aUl_Ip_D()
{
  {
    init_simple_test("aUl_Ip_D");
    STRUCT_IF_C aUl_Ip_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aUl_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_D)");
    check_field_offset(lv, v1, 0, "aUl_Ip_D.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_D, aUl_Ip_D)
//============================================================================



static void Test_aUl_Ip_F()
{
  {
    init_simple_test("aUl_Ip_F");
    STRUCT_IF_C aUl_Ip_F lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_F)");
    check_field_offset(lv, v1, 0, "aUl_Ip_F.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_F, aUl_Ip_F)
//============================================================================



static void Test_aUl_Ip_I()
{
  {
    init_simple_test("aUl_Ip_I");
    STRUCT_IF_C aUl_Ip_I lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_I)");
    check_field_offset(lv, v1, 0, "aUl_Ip_I.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_I, aUl_Ip_I)
//============================================================================



static void Test_aUl_Ip_Ip()
{
  {
    init_simple_test("aUl_Ip_Ip");
    STRUCT_IF_C aUl_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aUl_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_Ip)");
    check_field_offset(lv, v1, 0, "aUl_Ip_Ip.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_Ip, aUl_Ip_Ip)
//============================================================================



static void Test_aUl_Ip_L()
{
  {
    init_simple_test("aUl_Ip_L");
    STRUCT_IF_C aUl_Ip_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aUl_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_L)");
    check_field_offset(lv, v1, 0, "aUl_Ip_L.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_L, aUl_Ip_L)
//============================================================================



static void Test_aUl_Ip_S()
{
  {
    init_simple_test("aUl_Ip_S");
    STRUCT_IF_C aUl_Ip_S lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_S)");
    check_field_offset(lv, v1, 0, "aUl_Ip_S.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_S, aUl_Ip_S)
//============================================================================



static void Test_aUl_Ip_Uc()
{
  {
    init_simple_test("aUl_Ip_Uc");
    STRUCT_IF_C aUl_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_Uc)");
    check_field_offset(lv, v1, 0, "aUl_Ip_Uc.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_Uc, aUl_Ip_Uc)
//============================================================================



static void Test_aUl_Ip_Ui()
{
  {
    init_simple_test("aUl_Ip_Ui");
    STRUCT_IF_C aUl_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_Ui)");
    check_field_offset(lv, v1, 0, "aUl_Ip_Ui.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_Ui, aUl_Ip_Ui)
//============================================================================



static void Test_aUl_Ip_Ul()
{
  {
    init_simple_test("aUl_Ip_Ul");
    STRUCT_IF_C aUl_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aUl_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_Ul)");
    check_field_offset(lv, v1, 0, "aUl_Ip_Ul.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_Ul, aUl_Ip_Ul)
//============================================================================



static void Test_aUl_Ip_Us()
{
  {
    init_simple_test("aUl_Ip_Us");
    STRUCT_IF_C aUl_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_Us)");
    check_field_offset(lv, v1, 0, "aUl_Ip_Us.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_Us, aUl_Ip_Us)
//============================================================================



static void Test_aUl_Ip_Vp()
{
  {
    init_simple_test("aUl_Ip_Vp");
    STRUCT_IF_C aUl_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aUl_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ip_Vp)");
    check_field_offset(lv, v1, 0, "aUl_Ip_Vp.v1");
    check_field_offset(lv, v2, 8, "aUl_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ip_Vp, aUl_Ip_Vp)
//============================================================================



static void Test_aUl_L()
{
  {
    init_simple_test("aUl_L");
    STRUCT_IF_C aUl_L lv;
    check2(sizeof(lv), 16, "sizeof(aUl_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L)");
    check_field_offset(lv, v1, 0, "aUl_L.v1");
    check_field_offset(lv, v2, 8, "aUl_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L, aUl_L)
//============================================================================



static void Test_aUl_L_BFu15i()
{
  {
    init_simple_test("aUl_L_BFu15i");
    static STRUCT_IF_C aUl_L_BFu15i lv;
    check2(sizeof(lv), 18, "sizeof(aUl_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "aUl_L_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "aUl_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu15i, aUl_L_BFu15i)
//============================================================================



static void Test_aUl_L_BFu15ll()
{
  {
    init_simple_test("aUl_L_BFu15ll");
    static STRUCT_IF_C aUl_L_BFu15ll lv;
    check2(sizeof(lv), 18, "sizeof(aUl_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "aUl_L_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "aUl_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu15ll, aUl_L_BFu15ll)
//============================================================================



static void Test_aUl_L_BFu15s()
{
  {
    init_simple_test("aUl_L_BFu15s");
    static STRUCT_IF_C aUl_L_BFu15s lv;
    check2(sizeof(lv), 18, "sizeof(aUl_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "aUl_L_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "aUl_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu15s, aUl_L_BFu15s)
//============================================================================



static void Test_aUl_L_BFu16i()
{
  {
    init_simple_test("aUl_L_BFu16i");
    static STRUCT_IF_C aUl_L_BFu16i lv;
    check2(sizeof(lv), 18, "sizeof(aUl_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "aUl_L_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "aUl_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu16i, aUl_L_BFu16i)
//============================================================================



static void Test_aUl_L_BFu16ll()
{
  {
    init_simple_test("aUl_L_BFu16ll");
    static STRUCT_IF_C aUl_L_BFu16ll lv;
    check2(sizeof(lv), 18, "sizeof(aUl_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "aUl_L_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "aUl_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu16ll, aUl_L_BFu16ll)
//============================================================================



static void Test_aUl_L_BFu16s()
{
  {
    init_simple_test("aUl_L_BFu16s");
    static STRUCT_IF_C aUl_L_BFu16s lv;
    check2(sizeof(lv), 18, "sizeof(aUl_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "aUl_L_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "aUl_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu16s, aUl_L_BFu16s)
//============================================================================



static void Test_aUl_L_BFu17i()
{
  {
    init_simple_test("aUl_L_BFu17i");
    static STRUCT_IF_C aUl_L_BFu17i lv;
    check2(sizeof(lv), 19, "sizeof(aUl_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "aUl_L_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "aUl_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu17i, aUl_L_BFu17i)
//============================================================================



static void Test_aUl_L_BFu17ll()
{
  {
    init_simple_test("aUl_L_BFu17ll");
    static STRUCT_IF_C aUl_L_BFu17ll lv;
    check2(sizeof(lv), 19, "sizeof(aUl_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "aUl_L_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "aUl_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu17ll, aUl_L_BFu17ll)
//============================================================================



static void Test_aUl_L_BFu1c()
{
  {
    init_simple_test("aUl_L_BFu1c");
    static STRUCT_IF_C aUl_L_BFu1c lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aUl_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu1c, aUl_L_BFu1c)
//============================================================================



static void Test_aUl_L_BFu1i()
{
  {
    init_simple_test("aUl_L_BFu1i");
    static STRUCT_IF_C aUl_L_BFu1i lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aUl_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu1i, aUl_L_BFu1i)
//============================================================================



static void Test_aUl_L_BFu1ll()
{
  {
    init_simple_test("aUl_L_BFu1ll");
    static STRUCT_IF_C aUl_L_BFu1ll lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aUl_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu1ll, aUl_L_BFu1ll)
//============================================================================



static void Test_aUl_L_BFu1s()
{
  {
    init_simple_test("aUl_L_BFu1s");
    static STRUCT_IF_C aUl_L_BFu1s lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aUl_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu1s, aUl_L_BFu1s)
//============================================================================



static void Test_aUl_L_BFu31i()
{
  {
    init_simple_test("aUl_L_BFu31i");
    static STRUCT_IF_C aUl_L_BFu31i lv;
    check2(sizeof(lv), 20, "sizeof(aUl_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "aUl_L_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "aUl_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu31i, aUl_L_BFu31i)
//============================================================================



static void Test_aUl_L_BFu31ll()
{
  {
    init_simple_test("aUl_L_BFu31ll");
    static STRUCT_IF_C aUl_L_BFu31ll lv;
    check2(sizeof(lv), 20, "sizeof(aUl_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "aUl_L_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "aUl_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu31ll, aUl_L_BFu31ll)
//============================================================================



static void Test_aUl_L_BFu32i()
{
  {
    init_simple_test("aUl_L_BFu32i");
    static STRUCT_IF_C aUl_L_BFu32i lv;
    check2(sizeof(lv), 20, "sizeof(aUl_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "aUl_L_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "aUl_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu32i, aUl_L_BFu32i)
//============================================================================



static void Test_aUl_L_BFu32ll()
{
  {
    init_simple_test("aUl_L_BFu32ll");
    static STRUCT_IF_C aUl_L_BFu32ll lv;
    check2(sizeof(lv), 20, "sizeof(aUl_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "aUl_L_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "aUl_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu32ll, aUl_L_BFu32ll)
//============================================================================



static void Test_aUl_L_BFu33()
{
  {
    init_simple_test("aUl_L_BFu33");
    static STRUCT_IF_C aUl_L_BFu33 lv;
    check2(sizeof(lv), 21, "sizeof(aUl_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu33.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "aUl_L_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "aUl_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu33, aUl_L_BFu33)
//============================================================================



static void Test_aUl_L_BFu7c()
{
  {
    init_simple_test("aUl_L_BFu7c");
    static STRUCT_IF_C aUl_L_BFu7c lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aUl_L_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aUl_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu7c, aUl_L_BFu7c)
//============================================================================



static void Test_aUl_L_BFu7i()
{
  {
    init_simple_test("aUl_L_BFu7i");
    static STRUCT_IF_C aUl_L_BFu7i lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aUl_L_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aUl_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu7i, aUl_L_BFu7i)
//============================================================================



static void Test_aUl_L_BFu7ll()
{
  {
    init_simple_test("aUl_L_BFu7ll");
    static STRUCT_IF_C aUl_L_BFu7ll lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aUl_L_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aUl_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu7ll, aUl_L_BFu7ll)
//============================================================================



static void Test_aUl_L_BFu7s()
{
  {
    init_simple_test("aUl_L_BFu7s");
    static STRUCT_IF_C aUl_L_BFu7s lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aUl_L_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aUl_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu7s, aUl_L_BFu7s)
//============================================================================



static void Test_aUl_L_BFu8c()
{
  {
    init_simple_test("aUl_L_BFu8c");
    static STRUCT_IF_C aUl_L_BFu8c lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aUl_L_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aUl_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu8c, aUl_L_BFu8c)
//============================================================================



static void Test_aUl_L_BFu8i()
{
  {
    init_simple_test("aUl_L_BFu8i");
    static STRUCT_IF_C aUl_L_BFu8i lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aUl_L_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aUl_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu8i, aUl_L_BFu8i)
//============================================================================



static void Test_aUl_L_BFu8ll()
{
  {
    init_simple_test("aUl_L_BFu8ll");
    static STRUCT_IF_C aUl_L_BFu8ll lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aUl_L_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aUl_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu8ll, aUl_L_BFu8ll)
//============================================================================



static void Test_aUl_L_BFu8s()
{
  {
    init_simple_test("aUl_L_BFu8s");
    static STRUCT_IF_C aUl_L_BFu8s lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aUl_L_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aUl_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu8s, aUl_L_BFu8s)
//============================================================================



static void Test_aUl_L_BFu9i()
{
  {
    init_simple_test("aUl_L_BFu9i");
    static STRUCT_IF_C aUl_L_BFu9i lv;
    check2(sizeof(lv), 18, "sizeof(aUl_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "aUl_L_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "aUl_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu9i, aUl_L_BFu9i)
//============================================================================



static void Test_aUl_L_BFu9ll()
{
  {
    init_simple_test("aUl_L_BFu9ll");
    static STRUCT_IF_C aUl_L_BFu9ll lv;
    check2(sizeof(lv), 18, "sizeof(aUl_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "aUl_L_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "aUl_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu9ll, aUl_L_BFu9ll)
//============================================================================



static void Test_aUl_L_BFu9s()
{
  {
    init_simple_test("aUl_L_BFu9s");
    static STRUCT_IF_C aUl_L_BFu9s lv;
    check2(sizeof(lv), 18, "sizeof(aUl_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_L_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aUl_L_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "aUl_L_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "aUl_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_BFu9s, aUl_L_BFu9s)
//============================================================================



static void Test_aUl_L_C()
{
  {
    init_simple_test("aUl_L_C");
    STRUCT_IF_C aUl_L_C lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_C)");
    check_field_offset(lv, v1, 0, "aUl_L_C.v1");
    check_field_offset(lv, v2, 8, "aUl_L_C.v2");
    check_field_offset(lv, v3, 16, "aUl_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_C, aUl_L_C)
//============================================================================



static void Test_aUl_L_D()
{
  {
    init_simple_test("aUl_L_D");
    STRUCT_IF_C aUl_L_D lv;
    check2(sizeof(lv), 24, "sizeof(aUl_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_D)");
    check_field_offset(lv, v1, 0, "aUl_L_D.v1");
    check_field_offset(lv, v2, 8, "aUl_L_D.v2");
    check_field_offset(lv, v3, 16, "aUl_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_D, aUl_L_D)
//============================================================================



static void Test_aUl_L_F()
{
  {
    init_simple_test("aUl_L_F");
    STRUCT_IF_C aUl_L_F lv;
    check2(sizeof(lv), 20, "sizeof(aUl_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_F)");
    check_field_offset(lv, v1, 0, "aUl_L_F.v1");
    check_field_offset(lv, v2, 8, "aUl_L_F.v2");
    check_field_offset(lv, v3, 16, "aUl_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_F, aUl_L_F)
//============================================================================



static void Test_aUl_L_I()
{
  {
    init_simple_test("aUl_L_I");
    STRUCT_IF_C aUl_L_I lv;
    check2(sizeof(lv), 20, "sizeof(aUl_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_I)");
    check_field_offset(lv, v1, 0, "aUl_L_I.v1");
    check_field_offset(lv, v2, 8, "aUl_L_I.v2");
    check_field_offset(lv, v3, 16, "aUl_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_I, aUl_L_I)
//============================================================================



static void Test_aUl_L_Ip()
{
  {
    init_simple_test("aUl_L_Ip");
    STRUCT_IF_C aUl_L_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aUl_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_Ip)");
    check_field_offset(lv, v1, 0, "aUl_L_Ip.v1");
    check_field_offset(lv, v2, 8, "aUl_L_Ip.v2");
    check_field_offset(lv, v3, 16, "aUl_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_Ip, aUl_L_Ip)
//============================================================================



static void Test_aUl_L_L()
{
  {
    init_simple_test("aUl_L_L");
    STRUCT_IF_C aUl_L_L lv;
    check2(sizeof(lv), 24, "sizeof(aUl_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_L)");
    check_field_offset(lv, v1, 0, "aUl_L_L.v1");
    check_field_offset(lv, v2, 8, "aUl_L_L.v2");
    check_field_offset(lv, v3, 16, "aUl_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_L, aUl_L_L)
//============================================================================



static void Test_aUl_L_S()
{
  {
    init_simple_test("aUl_L_S");
    STRUCT_IF_C aUl_L_S lv;
    check2(sizeof(lv), 18, "sizeof(aUl_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_S)");
    check_field_offset(lv, v1, 0, "aUl_L_S.v1");
    check_field_offset(lv, v2, 8, "aUl_L_S.v2");
    check_field_offset(lv, v3, 16, "aUl_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_S, aUl_L_S)
//============================================================================



static void Test_aUl_L_Uc()
{
  {
    init_simple_test("aUl_L_Uc");
    STRUCT_IF_C aUl_L_Uc lv;
    check2(sizeof(lv), 17, "sizeof(aUl_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_Uc)");
    check_field_offset(lv, v1, 0, "aUl_L_Uc.v1");
    check_field_offset(lv, v2, 8, "aUl_L_Uc.v2");
    check_field_offset(lv, v3, 16, "aUl_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_Uc, aUl_L_Uc)
//============================================================================



static void Test_aUl_L_Ui()
{
  {
    init_simple_test("aUl_L_Ui");
    STRUCT_IF_C aUl_L_Ui lv;
    check2(sizeof(lv), 20, "sizeof(aUl_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_Ui)");
    check_field_offset(lv, v1, 0, "aUl_L_Ui.v1");
    check_field_offset(lv, v2, 8, "aUl_L_Ui.v2");
    check_field_offset(lv, v3, 16, "aUl_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_Ui, aUl_L_Ui)
//============================================================================



static void Test_aUl_L_Ul()
{
  {
    init_simple_test("aUl_L_Ul");
    STRUCT_IF_C aUl_L_Ul lv;
    check2(sizeof(lv), 24, "sizeof(aUl_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_Ul)");
    check_field_offset(lv, v1, 0, "aUl_L_Ul.v1");
    check_field_offset(lv, v2, 8, "aUl_L_Ul.v2");
    check_field_offset(lv, v3, 16, "aUl_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_Ul, aUl_L_Ul)
//============================================================================



static void Test_aUl_L_Us()
{
  {
    init_simple_test("aUl_L_Us");
    STRUCT_IF_C aUl_L_Us lv;
    check2(sizeof(lv), 18, "sizeof(aUl_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_Us)");
    check_field_offset(lv, v1, 0, "aUl_L_Us.v1");
    check_field_offset(lv, v2, 8, "aUl_L_Us.v2");
    check_field_offset(lv, v3, 16, "aUl_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_Us, aUl_L_Us)
//============================================================================



static void Test_aUl_L_Vp()
{
  {
    init_simple_test("aUl_L_Vp");
    STRUCT_IF_C aUl_L_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aUl_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_L_Vp)");
    check_field_offset(lv, v1, 0, "aUl_L_Vp.v1");
    check_field_offset(lv, v2, 8, "aUl_L_Vp.v2");
    check_field_offset(lv, v3, 16, "aUl_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_L_Vp, aUl_L_Vp)
//============================================================================



static void Test_aUl_S()
{
  {
    init_simple_test("aUl_S");
    STRUCT_IF_C aUl_S lv;
    check2(sizeof(lv), 10, "sizeof(aUl_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S)");
    check_field_offset(lv, v1, 0, "aUl_S.v1");
    check_field_offset(lv, v2, 8, "aUl_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S, aUl_S)
//============================================================================



static void Test_aUl_S_BFu15i()
{
  {
    init_simple_test("aUl_S_BFu15i");
    static STRUCT_IF_C aUl_S_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aUl_S_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aUl_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu15i, aUl_S_BFu15i)
//============================================================================



static void Test_aUl_S_BFu15ll()
{
  {
    init_simple_test("aUl_S_BFu15ll");
    static STRUCT_IF_C aUl_S_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aUl_S_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aUl_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu15ll, aUl_S_BFu15ll)
//============================================================================



static void Test_aUl_S_BFu15s()
{
  {
    init_simple_test("aUl_S_BFu15s");
    static STRUCT_IF_C aUl_S_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(aUl_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aUl_S_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aUl_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu15s, aUl_S_BFu15s)
//============================================================================



static void Test_aUl_S_BFu16i()
{
  {
    init_simple_test("aUl_S_BFu16i");
    static STRUCT_IF_C aUl_S_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aUl_S_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aUl_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu16i, aUl_S_BFu16i)
//============================================================================



static void Test_aUl_S_BFu16ll()
{
  {
    init_simple_test("aUl_S_BFu16ll");
    static STRUCT_IF_C aUl_S_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aUl_S_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aUl_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu16ll, aUl_S_BFu16ll)
//============================================================================



static void Test_aUl_S_BFu16s()
{
  {
    init_simple_test("aUl_S_BFu16s");
    static STRUCT_IF_C aUl_S_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(aUl_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aUl_S_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aUl_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu16s, aUl_S_BFu16s)
//============================================================================



static void Test_aUl_S_BFu17i()
{
  {
    init_simple_test("aUl_S_BFu17i");
    static STRUCT_IF_C aUl_S_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "aUl_S_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "aUl_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu17i, aUl_S_BFu17i)
//============================================================================



static void Test_aUl_S_BFu17ll()
{
  {
    init_simple_test("aUl_S_BFu17ll");
    static STRUCT_IF_C aUl_S_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "aUl_S_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "aUl_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu17ll, aUl_S_BFu17ll)
//============================================================================



static void Test_aUl_S_BFu1c()
{
  {
    init_simple_test("aUl_S_BFu1c");
    static STRUCT_IF_C aUl_S_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aUl_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu1c, aUl_S_BFu1c)
//============================================================================



static void Test_aUl_S_BFu1i()
{
  {
    init_simple_test("aUl_S_BFu1i");
    static STRUCT_IF_C aUl_S_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aUl_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu1i, aUl_S_BFu1i)
//============================================================================



static void Test_aUl_S_BFu1ll()
{
  {
    init_simple_test("aUl_S_BFu1ll");
    static STRUCT_IF_C aUl_S_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aUl_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu1ll, aUl_S_BFu1ll)
//============================================================================



static void Test_aUl_S_BFu1s()
{
  {
    init_simple_test("aUl_S_BFu1s");
    static STRUCT_IF_C aUl_S_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aUl_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu1s, aUl_S_BFu1s)
//============================================================================



static void Test_aUl_S_BFu31i()
{
  {
    init_simple_test("aUl_S_BFu31i");
    static STRUCT_IF_C aUl_S_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "aUl_S_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "aUl_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu31i, aUl_S_BFu31i)
//============================================================================



static void Test_aUl_S_BFu31ll()
{
  {
    init_simple_test("aUl_S_BFu31ll");
    static STRUCT_IF_C aUl_S_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "aUl_S_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "aUl_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu31ll, aUl_S_BFu31ll)
//============================================================================



static void Test_aUl_S_BFu32i()
{
  {
    init_simple_test("aUl_S_BFu32i");
    static STRUCT_IF_C aUl_S_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "aUl_S_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "aUl_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu32i, aUl_S_BFu32i)
//============================================================================



static void Test_aUl_S_BFu32ll()
{
  {
    init_simple_test("aUl_S_BFu32ll");
    static STRUCT_IF_C aUl_S_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "aUl_S_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "aUl_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu32ll, aUl_S_BFu32ll)
//============================================================================



static void Test_aUl_S_BFu33()
{
  {
    init_simple_test("aUl_S_BFu33");
    static STRUCT_IF_C aUl_S_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(aUl_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu33.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "aUl_S_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "aUl_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu33, aUl_S_BFu33)
//============================================================================



static void Test_aUl_S_BFu7c()
{
  {
    init_simple_test("aUl_S_BFu7c");
    static STRUCT_IF_C aUl_S_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aUl_S_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aUl_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu7c, aUl_S_BFu7c)
//============================================================================



static void Test_aUl_S_BFu7i()
{
  {
    init_simple_test("aUl_S_BFu7i");
    static STRUCT_IF_C aUl_S_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aUl_S_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aUl_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu7i, aUl_S_BFu7i)
//============================================================================



static void Test_aUl_S_BFu7ll()
{
  {
    init_simple_test("aUl_S_BFu7ll");
    static STRUCT_IF_C aUl_S_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aUl_S_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aUl_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu7ll, aUl_S_BFu7ll)
//============================================================================



static void Test_aUl_S_BFu7s()
{
  {
    init_simple_test("aUl_S_BFu7s");
    static STRUCT_IF_C aUl_S_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aUl_S_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aUl_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu7s, aUl_S_BFu7s)
//============================================================================



static void Test_aUl_S_BFu8c()
{
  {
    init_simple_test("aUl_S_BFu8c");
    static STRUCT_IF_C aUl_S_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aUl_S_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aUl_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu8c, aUl_S_BFu8c)
//============================================================================



static void Test_aUl_S_BFu8i()
{
  {
    init_simple_test("aUl_S_BFu8i");
    static STRUCT_IF_C aUl_S_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aUl_S_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aUl_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu8i, aUl_S_BFu8i)
//============================================================================



static void Test_aUl_S_BFu8ll()
{
  {
    init_simple_test("aUl_S_BFu8ll");
    static STRUCT_IF_C aUl_S_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aUl_S_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aUl_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu8ll, aUl_S_BFu8ll)
//============================================================================



static void Test_aUl_S_BFu8s()
{
  {
    init_simple_test("aUl_S_BFu8s");
    static STRUCT_IF_C aUl_S_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aUl_S_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aUl_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu8s, aUl_S_BFu8s)
//============================================================================



static void Test_aUl_S_BFu9i()
{
  {
    init_simple_test("aUl_S_BFu9i");
    static STRUCT_IF_C aUl_S_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "aUl_S_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "aUl_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu9i, aUl_S_BFu9i)
//============================================================================



static void Test_aUl_S_BFu9ll()
{
  {
    init_simple_test("aUl_S_BFu9ll");
    static STRUCT_IF_C aUl_S_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "aUl_S_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "aUl_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu9ll, aUl_S_BFu9ll)
//============================================================================



static void Test_aUl_S_BFu9s()
{
  {
    init_simple_test("aUl_S_BFu9s");
    static STRUCT_IF_C aUl_S_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(aUl_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_S_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aUl_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "aUl_S_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "aUl_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_BFu9s, aUl_S_BFu9s)
//============================================================================



static void Test_aUl_S_C()
{
  {
    init_simple_test("aUl_S_C");
    STRUCT_IF_C aUl_S_C lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_C)");
    check_field_offset(lv, v1, 0, "aUl_S_C.v1");
    check_field_offset(lv, v2, 8, "aUl_S_C.v2");
    check_field_offset(lv, v3, 10, "aUl_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_C, aUl_S_C)
//============================================================================



static void Test_aUl_S_D()
{
  {
    init_simple_test("aUl_S_D");
    STRUCT_IF_C aUl_S_D lv;
    check2(sizeof(lv), 18, "sizeof(aUl_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_D)");
    check_field_offset(lv, v1, 0, "aUl_S_D.v1");
    check_field_offset(lv, v2, 8, "aUl_S_D.v2");
    check_field_offset(lv, v3, 10, "aUl_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_D, aUl_S_D)
//============================================================================



static void Test_aUl_S_F()
{
  {
    init_simple_test("aUl_S_F");
    STRUCT_IF_C aUl_S_F lv;
    check2(sizeof(lv), 14, "sizeof(aUl_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_F)");
    check_field_offset(lv, v1, 0, "aUl_S_F.v1");
    check_field_offset(lv, v2, 8, "aUl_S_F.v2");
    check_field_offset(lv, v3, 10, "aUl_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_F, aUl_S_F)
//============================================================================



static void Test_aUl_S_I()
{
  {
    init_simple_test("aUl_S_I");
    STRUCT_IF_C aUl_S_I lv;
    check2(sizeof(lv), 14, "sizeof(aUl_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_I)");
    check_field_offset(lv, v1, 0, "aUl_S_I.v1");
    check_field_offset(lv, v2, 8, "aUl_S_I.v2");
    check_field_offset(lv, v3, 10, "aUl_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_I, aUl_S_I)
//============================================================================



static void Test_aUl_S_Ip()
{
  {
    init_simple_test("aUl_S_Ip");
    STRUCT_IF_C aUl_S_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_Ip)");
    check_field_offset(lv, v1, 0, "aUl_S_Ip.v1");
    check_field_offset(lv, v2, 8, "aUl_S_Ip.v2");
    check_field_offset(lv, v3, 10, "aUl_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_Ip, aUl_S_Ip)
//============================================================================



static void Test_aUl_S_L()
{
  {
    init_simple_test("aUl_S_L");
    STRUCT_IF_C aUl_S_L lv;
    check2(sizeof(lv), 18, "sizeof(aUl_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_L)");
    check_field_offset(lv, v1, 0, "aUl_S_L.v1");
    check_field_offset(lv, v2, 8, "aUl_S_L.v2");
    check_field_offset(lv, v3, 10, "aUl_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_L, aUl_S_L)
//============================================================================



static void Test_aUl_S_S()
{
  {
    init_simple_test("aUl_S_S");
    STRUCT_IF_C aUl_S_S lv;
    check2(sizeof(lv), 12, "sizeof(aUl_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_S)");
    check_field_offset(lv, v1, 0, "aUl_S_S.v1");
    check_field_offset(lv, v2, 8, "aUl_S_S.v2");
    check_field_offset(lv, v3, 10, "aUl_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_S, aUl_S_S)
//============================================================================



static void Test_aUl_S_Uc()
{
  {
    init_simple_test("aUl_S_Uc");
    STRUCT_IF_C aUl_S_Uc lv;
    check2(sizeof(lv), 11, "sizeof(aUl_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_Uc)");
    check_field_offset(lv, v1, 0, "aUl_S_Uc.v1");
    check_field_offset(lv, v2, 8, "aUl_S_Uc.v2");
    check_field_offset(lv, v3, 10, "aUl_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_Uc, aUl_S_Uc)
//============================================================================



static void Test_aUl_S_Ui()
{
  {
    init_simple_test("aUl_S_Ui");
    STRUCT_IF_C aUl_S_Ui lv;
    check2(sizeof(lv), 14, "sizeof(aUl_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_Ui)");
    check_field_offset(lv, v1, 0, "aUl_S_Ui.v1");
    check_field_offset(lv, v2, 8, "aUl_S_Ui.v2");
    check_field_offset(lv, v3, 10, "aUl_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_Ui, aUl_S_Ui)
//============================================================================



static void Test_aUl_S_Ul()
{
  {
    init_simple_test("aUl_S_Ul");
    STRUCT_IF_C aUl_S_Ul lv;
    check2(sizeof(lv), 18, "sizeof(aUl_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_Ul)");
    check_field_offset(lv, v1, 0, "aUl_S_Ul.v1");
    check_field_offset(lv, v2, 8, "aUl_S_Ul.v2");
    check_field_offset(lv, v3, 10, "aUl_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_Ul, aUl_S_Ul)
//============================================================================



static void Test_aUl_S_Us()
{
  {
    init_simple_test("aUl_S_Us");
    STRUCT_IF_C aUl_S_Us lv;
    check2(sizeof(lv), 12, "sizeof(aUl_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_Us)");
    check_field_offset(lv, v1, 0, "aUl_S_Us.v1");
    check_field_offset(lv, v2, 8, "aUl_S_Us.v2");
    check_field_offset(lv, v3, 10, "aUl_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_Us, aUl_S_Us)
//============================================================================



static void Test_aUl_S_Vp()
{
  {
    init_simple_test("aUl_S_Vp");
    STRUCT_IF_C aUl_S_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_S_Vp)");
    check_field_offset(lv, v1, 0, "aUl_S_Vp.v1");
    check_field_offset(lv, v2, 8, "aUl_S_Vp.v2");
    check_field_offset(lv, v3, 10, "aUl_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_S_Vp, aUl_S_Vp)
//============================================================================



static void Test_aUl_Uc()
{
  {
    init_simple_test("aUl_Uc");
    STRUCT_IF_C aUl_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aUl_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc)");
    check_field_offset(lv, v1, 0, "aUl_Uc.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc, aUl_Uc)
//============================================================================



static void Test_aUl_Uc_BFu15i()
{
  {
    init_simple_test("aUl_Uc_BFu15i");
    static STRUCT_IF_C aUl_Uc_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUl_Uc_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUl_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu15i, aUl_Uc_BFu15i)
//============================================================================



static void Test_aUl_Uc_BFu15ll()
{
  {
    init_simple_test("aUl_Uc_BFu15ll");
    static STRUCT_IF_C aUl_Uc_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUl_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUl_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu15ll, aUl_Uc_BFu15ll)
//============================================================================



static void Test_aUl_Uc_BFu15s()
{
  {
    init_simple_test("aUl_Uc_BFu15s");
    static STRUCT_IF_C aUl_Uc_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUl_Uc_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUl_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu15s, aUl_Uc_BFu15s)
//============================================================================



static void Test_aUl_Uc_BFu16i()
{
  {
    init_simple_test("aUl_Uc_BFu16i");
    static STRUCT_IF_C aUl_Uc_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUl_Uc_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUl_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu16i, aUl_Uc_BFu16i)
//============================================================================



static void Test_aUl_Uc_BFu16ll()
{
  {
    init_simple_test("aUl_Uc_BFu16ll");
    static STRUCT_IF_C aUl_Uc_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUl_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUl_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu16ll, aUl_Uc_BFu16ll)
//============================================================================



static void Test_aUl_Uc_BFu16s()
{
  {
    init_simple_test("aUl_Uc_BFu16s");
    static STRUCT_IF_C aUl_Uc_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUl_Uc_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUl_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu16s, aUl_Uc_BFu16s)
//============================================================================



static void Test_aUl_Uc_BFu17i()
{
  {
    init_simple_test("aUl_Uc_BFu17i");
    static STRUCT_IF_C aUl_Uc_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aUl_Uc_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aUl_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu17i, aUl_Uc_BFu17i)
//============================================================================



static void Test_aUl_Uc_BFu17ll()
{
  {
    init_simple_test("aUl_Uc_BFu17ll");
    static STRUCT_IF_C aUl_Uc_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aUl_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aUl_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu17ll, aUl_Uc_BFu17ll)
//============================================================================



static void Test_aUl_Uc_BFu1c()
{
  {
    init_simple_test("aUl_Uc_BFu1c");
    static STRUCT_IF_C aUl_Uc_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu1c, aUl_Uc_BFu1c)
//============================================================================



static void Test_aUl_Uc_BFu1i()
{
  {
    init_simple_test("aUl_Uc_BFu1i");
    static STRUCT_IF_C aUl_Uc_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu1i, aUl_Uc_BFu1i)
//============================================================================



static void Test_aUl_Uc_BFu1ll()
{
  {
    init_simple_test("aUl_Uc_BFu1ll");
    static STRUCT_IF_C aUl_Uc_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu1ll, aUl_Uc_BFu1ll)
//============================================================================



static void Test_aUl_Uc_BFu1s()
{
  {
    init_simple_test("aUl_Uc_BFu1s");
    static STRUCT_IF_C aUl_Uc_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUl_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu1s, aUl_Uc_BFu1s)
//============================================================================



static void Test_aUl_Uc_BFu31i()
{
  {
    init_simple_test("aUl_Uc_BFu31i");
    static STRUCT_IF_C aUl_Uc_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUl_Uc_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUl_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu31i, aUl_Uc_BFu31i)
//============================================================================



static void Test_aUl_Uc_BFu31ll()
{
  {
    init_simple_test("aUl_Uc_BFu31ll");
    static STRUCT_IF_C aUl_Uc_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUl_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUl_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu31ll, aUl_Uc_BFu31ll)
//============================================================================



static void Test_aUl_Uc_BFu32i()
{
  {
    init_simple_test("aUl_Uc_BFu32i");
    static STRUCT_IF_C aUl_Uc_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUl_Uc_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUl_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu32i, aUl_Uc_BFu32i)
//============================================================================



static void Test_aUl_Uc_BFu32ll()
{
  {
    init_simple_test("aUl_Uc_BFu32ll");
    static STRUCT_IF_C aUl_Uc_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUl_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUl_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu32ll, aUl_Uc_BFu32ll)
//============================================================================



static void Test_aUl_Uc_BFu33()
{
  {
    init_simple_test("aUl_Uc_BFu33");
    static STRUCT_IF_C aUl_Uc_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu33.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aUl_Uc_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aUl_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu33, aUl_Uc_BFu33)
//============================================================================



static void Test_aUl_Uc_BFu7c()
{
  {
    init_simple_test("aUl_Uc_BFu7c");
    static STRUCT_IF_C aUl_Uc_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_Uc_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu7c, aUl_Uc_BFu7c)
//============================================================================



static void Test_aUl_Uc_BFu7i()
{
  {
    init_simple_test("aUl_Uc_BFu7i");
    static STRUCT_IF_C aUl_Uc_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_Uc_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu7i, aUl_Uc_BFu7i)
//============================================================================



static void Test_aUl_Uc_BFu7ll()
{
  {
    init_simple_test("aUl_Uc_BFu7ll");
    static STRUCT_IF_C aUl_Uc_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu7ll, aUl_Uc_BFu7ll)
//============================================================================



static void Test_aUl_Uc_BFu7s()
{
  {
    init_simple_test("aUl_Uc_BFu7s");
    static STRUCT_IF_C aUl_Uc_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUl_Uc_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUl_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu7s, aUl_Uc_BFu7s)
//============================================================================



static void Test_aUl_Uc_BFu8c()
{
  {
    init_simple_test("aUl_Uc_BFu8c");
    static STRUCT_IF_C aUl_Uc_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_Uc_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu8c, aUl_Uc_BFu8c)
//============================================================================



static void Test_aUl_Uc_BFu8i()
{
  {
    init_simple_test("aUl_Uc_BFu8i");
    static STRUCT_IF_C aUl_Uc_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_Uc_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu8i, aUl_Uc_BFu8i)
//============================================================================



static void Test_aUl_Uc_BFu8ll()
{
  {
    init_simple_test("aUl_Uc_BFu8ll");
    static STRUCT_IF_C aUl_Uc_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu8ll, aUl_Uc_BFu8ll)
//============================================================================



static void Test_aUl_Uc_BFu8s()
{
  {
    init_simple_test("aUl_Uc_BFu8s");
    static STRUCT_IF_C aUl_Uc_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUl_Uc_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUl_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu8s, aUl_Uc_BFu8s)
//============================================================================



static void Test_aUl_Uc_BFu9i()
{
  {
    init_simple_test("aUl_Uc_BFu9i");
    static STRUCT_IF_C aUl_Uc_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_Uc_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu9i, aUl_Uc_BFu9i)
//============================================================================



static void Test_aUl_Uc_BFu9ll()
{
  {
    init_simple_test("aUl_Uc_BFu9ll");
    static STRUCT_IF_C aUl_Uc_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu9ll, aUl_Uc_BFu9ll)
//============================================================================



static void Test_aUl_Uc_BFu9s()
{
  {
    init_simple_test("aUl_Uc_BFu9s");
    static STRUCT_IF_C aUl_Uc_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_Uc_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUl_Uc_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUl_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_BFu9s, aUl_Uc_BFu9s)
//============================================================================



static void Test_aUl_Uc_C()
{
  {
    init_simple_test("aUl_Uc_C");
    STRUCT_IF_C aUl_Uc_C lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_C)");
    check_field_offset(lv, v1, 0, "aUl_Uc_C.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_C.v2");
    check_field_offset(lv, v3, 9, "aUl_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_C, aUl_Uc_C)
//============================================================================



static void Test_aUl_Uc_D()
{
  {
    init_simple_test("aUl_Uc_D");
    STRUCT_IF_C aUl_Uc_D lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_D)");
    check_field_offset(lv, v1, 0, "aUl_Uc_D.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_D.v2");
    check_field_offset(lv, v3, 9, "aUl_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_D, aUl_Uc_D)
//============================================================================



static void Test_aUl_Uc_F()
{
  {
    init_simple_test("aUl_Uc_F");
    STRUCT_IF_C aUl_Uc_F lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_F)");
    check_field_offset(lv, v1, 0, "aUl_Uc_F.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_F.v2");
    check_field_offset(lv, v3, 9, "aUl_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_F, aUl_Uc_F)
//============================================================================



static void Test_aUl_Uc_I()
{
  {
    init_simple_test("aUl_Uc_I");
    STRUCT_IF_C aUl_Uc_I lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_I)");
    check_field_offset(lv, v1, 0, "aUl_Uc_I.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_I.v2");
    check_field_offset(lv, v3, 9, "aUl_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_I, aUl_Uc_I)
//============================================================================



static void Test_aUl_Uc_Ip()
{
  {
    init_simple_test("aUl_Uc_Ip");
    STRUCT_IF_C aUl_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_Ip)");
    check_field_offset(lv, v1, 0, "aUl_Uc_Ip.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_Ip.v2");
    check_field_offset(lv, v3, 9, "aUl_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_Ip, aUl_Uc_Ip)
//============================================================================



static void Test_aUl_Uc_L()
{
  {
    init_simple_test("aUl_Uc_L");
    STRUCT_IF_C aUl_Uc_L lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_L)");
    check_field_offset(lv, v1, 0, "aUl_Uc_L.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_L.v2");
    check_field_offset(lv, v3, 9, "aUl_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_L, aUl_Uc_L)
//============================================================================



static void Test_aUl_Uc_S()
{
  {
    init_simple_test("aUl_Uc_S");
    STRUCT_IF_C aUl_Uc_S lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_S)");
    check_field_offset(lv, v1, 0, "aUl_Uc_S.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_S.v2");
    check_field_offset(lv, v3, 9, "aUl_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_S, aUl_Uc_S)
//============================================================================



static void Test_aUl_Uc_Uc()
{
  {
    init_simple_test("aUl_Uc_Uc");
    STRUCT_IF_C aUl_Uc_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_Uc)");
    check_field_offset(lv, v1, 0, "aUl_Uc_Uc.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_Uc.v2");
    check_field_offset(lv, v3, 9, "aUl_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_Uc, aUl_Uc_Uc)
//============================================================================



static void Test_aUl_Uc_Ui()
{
  {
    init_simple_test("aUl_Uc_Ui");
    STRUCT_IF_C aUl_Uc_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_Ui)");
    check_field_offset(lv, v1, 0, "aUl_Uc_Ui.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_Ui.v2");
    check_field_offset(lv, v3, 9, "aUl_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_Ui, aUl_Uc_Ui)
//============================================================================



static void Test_aUl_Uc_Ul()
{
  {
    init_simple_test("aUl_Uc_Ul");
    STRUCT_IF_C aUl_Uc_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_Ul)");
    check_field_offset(lv, v1, 0, "aUl_Uc_Ul.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_Ul.v2");
    check_field_offset(lv, v3, 9, "aUl_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_Ul, aUl_Uc_Ul)
//============================================================================



static void Test_aUl_Uc_Us()
{
  {
    init_simple_test("aUl_Uc_Us");
    STRUCT_IF_C aUl_Uc_Us lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_Us)");
    check_field_offset(lv, v1, 0, "aUl_Uc_Us.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_Us.v2");
    check_field_offset(lv, v3, 9, "aUl_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_Us, aUl_Uc_Us)
//============================================================================



static void Test_aUl_Uc_Vp()
{
  {
    init_simple_test("aUl_Uc_Vp");
    STRUCT_IF_C aUl_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Uc_Vp)");
    check_field_offset(lv, v1, 0, "aUl_Uc_Vp.v1");
    check_field_offset(lv, v2, 8, "aUl_Uc_Vp.v2");
    check_field_offset(lv, v3, 9, "aUl_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Uc_Vp, aUl_Uc_Vp)
//============================================================================



static void Test_aUl_Ui()
{
  {
    init_simple_test("aUl_Ui");
    STRUCT_IF_C aUl_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui)");
    check_field_offset(lv, v1, 0, "aUl_Ui.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui, aUl_Ui)
//============================================================================



static void Test_aUl_Ui_BFu15i()
{
  {
    init_simple_test("aUl_Ui_BFu15i");
    static STRUCT_IF_C aUl_Ui_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aUl_Ui_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aUl_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu15i, aUl_Ui_BFu15i)
//============================================================================



static void Test_aUl_Ui_BFu15ll()
{
  {
    init_simple_test("aUl_Ui_BFu15ll");
    static STRUCT_IF_C aUl_Ui_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aUl_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aUl_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu15ll, aUl_Ui_BFu15ll)
//============================================================================



static void Test_aUl_Ui_BFu15s()
{
  {
    init_simple_test("aUl_Ui_BFu15s");
    static STRUCT_IF_C aUl_Ui_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aUl_Ui_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aUl_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu15s, aUl_Ui_BFu15s)
//============================================================================



static void Test_aUl_Ui_BFu16i()
{
  {
    init_simple_test("aUl_Ui_BFu16i");
    static STRUCT_IF_C aUl_Ui_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aUl_Ui_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aUl_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu16i, aUl_Ui_BFu16i)
//============================================================================



static void Test_aUl_Ui_BFu16ll()
{
  {
    init_simple_test("aUl_Ui_BFu16ll");
    static STRUCT_IF_C aUl_Ui_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aUl_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aUl_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu16ll, aUl_Ui_BFu16ll)
//============================================================================



static void Test_aUl_Ui_BFu16s()
{
  {
    init_simple_test("aUl_Ui_BFu16s");
    static STRUCT_IF_C aUl_Ui_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aUl_Ui_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aUl_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu16s, aUl_Ui_BFu16s)
//============================================================================



static void Test_aUl_Ui_BFu17i()
{
  {
    init_simple_test("aUl_Ui_BFu17i");
    static STRUCT_IF_C aUl_Ui_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(aUl_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aUl_Ui_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aUl_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu17i, aUl_Ui_BFu17i)
//============================================================================



static void Test_aUl_Ui_BFu17ll()
{
  {
    init_simple_test("aUl_Ui_BFu17ll");
    static STRUCT_IF_C aUl_Ui_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(aUl_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aUl_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aUl_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu17ll, aUl_Ui_BFu17ll)
//============================================================================



static void Test_aUl_Ui_BFu1c()
{
  {
    init_simple_test("aUl_Ui_BFu1c");
    static STRUCT_IF_C aUl_Ui_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aUl_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu1c, aUl_Ui_BFu1c)
//============================================================================



static void Test_aUl_Ui_BFu1i()
{
  {
    init_simple_test("aUl_Ui_BFu1i");
    static STRUCT_IF_C aUl_Ui_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aUl_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu1i, aUl_Ui_BFu1i)
//============================================================================



static void Test_aUl_Ui_BFu1ll()
{
  {
    init_simple_test("aUl_Ui_BFu1ll");
    static STRUCT_IF_C aUl_Ui_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aUl_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu1ll, aUl_Ui_BFu1ll)
//============================================================================



static void Test_aUl_Ui_BFu1s()
{
  {
    init_simple_test("aUl_Ui_BFu1s");
    static STRUCT_IF_C aUl_Ui_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aUl_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu1s, aUl_Ui_BFu1s)
//============================================================================



static void Test_aUl_Ui_BFu31i()
{
  {
    init_simple_test("aUl_Ui_BFu31i");
    static STRUCT_IF_C aUl_Ui_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(aUl_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aUl_Ui_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aUl_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu31i, aUl_Ui_BFu31i)
//============================================================================



static void Test_aUl_Ui_BFu31ll()
{
  {
    init_simple_test("aUl_Ui_BFu31ll");
    static STRUCT_IF_C aUl_Ui_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(aUl_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aUl_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aUl_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu31ll, aUl_Ui_BFu31ll)
//============================================================================



static void Test_aUl_Ui_BFu32i()
{
  {
    init_simple_test("aUl_Ui_BFu32i");
    static STRUCT_IF_C aUl_Ui_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(aUl_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aUl_Ui_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aUl_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu32i, aUl_Ui_BFu32i)
//============================================================================



static void Test_aUl_Ui_BFu32ll()
{
  {
    init_simple_test("aUl_Ui_BFu32ll");
    static STRUCT_IF_C aUl_Ui_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(aUl_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aUl_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aUl_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu32ll, aUl_Ui_BFu32ll)
//============================================================================



static void Test_aUl_Ui_BFu33()
{
  {
    init_simple_test("aUl_Ui_BFu33");
    static STRUCT_IF_C aUl_Ui_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu33.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "aUl_Ui_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "aUl_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu33, aUl_Ui_BFu33)
//============================================================================



static void Test_aUl_Ui_BFu7c()
{
  {
    init_simple_test("aUl_Ui_BFu7c");
    static STRUCT_IF_C aUl_Ui_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aUl_Ui_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aUl_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu7c, aUl_Ui_BFu7c)
//============================================================================



static void Test_aUl_Ui_BFu7i()
{
  {
    init_simple_test("aUl_Ui_BFu7i");
    static STRUCT_IF_C aUl_Ui_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aUl_Ui_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aUl_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu7i, aUl_Ui_BFu7i)
//============================================================================



static void Test_aUl_Ui_BFu7ll()
{
  {
    init_simple_test("aUl_Ui_BFu7ll");
    static STRUCT_IF_C aUl_Ui_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aUl_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aUl_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu7ll, aUl_Ui_BFu7ll)
//============================================================================



static void Test_aUl_Ui_BFu7s()
{
  {
    init_simple_test("aUl_Ui_BFu7s");
    static STRUCT_IF_C aUl_Ui_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aUl_Ui_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aUl_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu7s, aUl_Ui_BFu7s)
//============================================================================



static void Test_aUl_Ui_BFu8c()
{
  {
    init_simple_test("aUl_Ui_BFu8c");
    static STRUCT_IF_C aUl_Ui_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aUl_Ui_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aUl_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu8c, aUl_Ui_BFu8c)
//============================================================================



static void Test_aUl_Ui_BFu8i()
{
  {
    init_simple_test("aUl_Ui_BFu8i");
    static STRUCT_IF_C aUl_Ui_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aUl_Ui_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aUl_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu8i, aUl_Ui_BFu8i)
//============================================================================



static void Test_aUl_Ui_BFu8ll()
{
  {
    init_simple_test("aUl_Ui_BFu8ll");
    static STRUCT_IF_C aUl_Ui_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aUl_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aUl_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu8ll, aUl_Ui_BFu8ll)
//============================================================================



static void Test_aUl_Ui_BFu8s()
{
  {
    init_simple_test("aUl_Ui_BFu8s");
    static STRUCT_IF_C aUl_Ui_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aUl_Ui_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aUl_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu8s, aUl_Ui_BFu8s)
//============================================================================



static void Test_aUl_Ui_BFu9i()
{
  {
    init_simple_test("aUl_Ui_BFu9i");
    static STRUCT_IF_C aUl_Ui_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aUl_Ui_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aUl_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu9i, aUl_Ui_BFu9i)
//============================================================================



static void Test_aUl_Ui_BFu9ll()
{
  {
    init_simple_test("aUl_Ui_BFu9ll");
    static STRUCT_IF_C aUl_Ui_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aUl_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aUl_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu9ll, aUl_Ui_BFu9ll)
//============================================================================



static void Test_aUl_Ui_BFu9s()
{
  {
    init_simple_test("aUl_Ui_BFu9s");
    static STRUCT_IF_C aUl_Ui_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aUl_Ui_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aUl_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_BFu9s, aUl_Ui_BFu9s)
//============================================================================



static void Test_aUl_Ui_C()
{
  {
    init_simple_test("aUl_Ui_C");
    STRUCT_IF_C aUl_Ui_C lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_C)");
    check_field_offset(lv, v1, 0, "aUl_Ui_C.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_C.v2");
    check_field_offset(lv, v3, 12, "aUl_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_C, aUl_Ui_C)
//============================================================================



static void Test_aUl_Ui_D()
{
  {
    init_simple_test("aUl_Ui_D");
    STRUCT_IF_C aUl_Ui_D lv;
    check2(sizeof(lv), 20, "sizeof(aUl_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_D)");
    check_field_offset(lv, v1, 0, "aUl_Ui_D.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_D.v2");
    check_field_offset(lv, v3, 12, "aUl_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_D, aUl_Ui_D)
//============================================================================



static void Test_aUl_Ui_F()
{
  {
    init_simple_test("aUl_Ui_F");
    STRUCT_IF_C aUl_Ui_F lv;
    check2(sizeof(lv), 16, "sizeof(aUl_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_F)");
    check_field_offset(lv, v1, 0, "aUl_Ui_F.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_F.v2");
    check_field_offset(lv, v3, 12, "aUl_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_F, aUl_Ui_F)
//============================================================================



static void Test_aUl_Ui_I()
{
  {
    init_simple_test("aUl_Ui_I");
    STRUCT_IF_C aUl_Ui_I lv;
    check2(sizeof(lv), 16, "sizeof(aUl_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_I)");
    check_field_offset(lv, v1, 0, "aUl_Ui_I.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_I.v2");
    check_field_offset(lv, v3, 12, "aUl_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_I, aUl_Ui_I)
//============================================================================



static void Test_aUl_Ui_Ip()
{
  {
    init_simple_test("aUl_Ui_Ip");
    STRUCT_IF_C aUl_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_Ip)");
    check_field_offset(lv, v1, 0, "aUl_Ui_Ip.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_Ip.v2");
    check_field_offset(lv, v3, 12, "aUl_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_Ip, aUl_Ui_Ip)
//============================================================================



static void Test_aUl_Ui_L()
{
  {
    init_simple_test("aUl_Ui_L");
    STRUCT_IF_C aUl_Ui_L lv;
    check2(sizeof(lv), 20, "sizeof(aUl_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_L)");
    check_field_offset(lv, v1, 0, "aUl_Ui_L.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_L.v2");
    check_field_offset(lv, v3, 12, "aUl_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_L, aUl_Ui_L)
//============================================================================



static void Test_aUl_Ui_S()
{
  {
    init_simple_test("aUl_Ui_S");
    STRUCT_IF_C aUl_Ui_S lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_S)");
    check_field_offset(lv, v1, 0, "aUl_Ui_S.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_S.v2");
    check_field_offset(lv, v3, 12, "aUl_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_S, aUl_Ui_S)
//============================================================================



static void Test_aUl_Ui_Uc()
{
  {
    init_simple_test("aUl_Ui_Uc");
    STRUCT_IF_C aUl_Ui_Uc lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_Uc)");
    check_field_offset(lv, v1, 0, "aUl_Ui_Uc.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_Uc.v2");
    check_field_offset(lv, v3, 12, "aUl_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_Uc, aUl_Ui_Uc)
//============================================================================



static void Test_aUl_Ui_Ui()
{
  {
    init_simple_test("aUl_Ui_Ui");
    STRUCT_IF_C aUl_Ui_Ui lv;
    check2(sizeof(lv), 16, "sizeof(aUl_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_Ui)");
    check_field_offset(lv, v1, 0, "aUl_Ui_Ui.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_Ui.v2");
    check_field_offset(lv, v3, 12, "aUl_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_Ui, aUl_Ui_Ui)
//============================================================================



static void Test_aUl_Ui_Ul()
{
  {
    init_simple_test("aUl_Ui_Ul");
    STRUCT_IF_C aUl_Ui_Ul lv;
    check2(sizeof(lv), 20, "sizeof(aUl_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_Ul)");
    check_field_offset(lv, v1, 0, "aUl_Ui_Ul.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_Ul.v2");
    check_field_offset(lv, v3, 12, "aUl_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_Ul, aUl_Ui_Ul)
//============================================================================



static void Test_aUl_Ui_Us()
{
  {
    init_simple_test("aUl_Ui_Us");
    STRUCT_IF_C aUl_Ui_Us lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_Us)");
    check_field_offset(lv, v1, 0, "aUl_Ui_Us.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_Us.v2");
    check_field_offset(lv, v3, 12, "aUl_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_Us, aUl_Ui_Us)
//============================================================================



static void Test_aUl_Ui_Vp()
{
  {
    init_simple_test("aUl_Ui_Vp");
    STRUCT_IF_C aUl_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ui_Vp)");
    check_field_offset(lv, v1, 0, "aUl_Ui_Vp.v1");
    check_field_offset(lv, v2, 8, "aUl_Ui_Vp.v2");
    check_field_offset(lv, v3, 12, "aUl_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ui_Vp, aUl_Ui_Vp)
//============================================================================



static void Test_aUl_Ul()
{
  {
    init_simple_test("aUl_Ul");
    STRUCT_IF_C aUl_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aUl_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul)");
    check_field_offset(lv, v1, 0, "aUl_Ul.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul, aUl_Ul)
//============================================================================



static void Test_aUl_Ul_BFu15i()
{
  {
    init_simple_test("aUl_Ul_BFu15i");
    static STRUCT_IF_C aUl_Ul_BFu15i lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "aUl_Ul_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "aUl_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu15i, aUl_Ul_BFu15i)
//============================================================================



static void Test_aUl_Ul_BFu15ll()
{
  {
    init_simple_test("aUl_Ul_BFu15ll");
    static STRUCT_IF_C aUl_Ul_BFu15ll lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "aUl_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "aUl_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu15ll, aUl_Ul_BFu15ll)
//============================================================================



static void Test_aUl_Ul_BFu15s()
{
  {
    init_simple_test("aUl_Ul_BFu15s");
    static STRUCT_IF_C aUl_Ul_BFu15s lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "aUl_Ul_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "aUl_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu15s, aUl_Ul_BFu15s)
//============================================================================



static void Test_aUl_Ul_BFu16i()
{
  {
    init_simple_test("aUl_Ul_BFu16i");
    static STRUCT_IF_C aUl_Ul_BFu16i lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "aUl_Ul_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "aUl_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu16i, aUl_Ul_BFu16i)
//============================================================================



static void Test_aUl_Ul_BFu16ll()
{
  {
    init_simple_test("aUl_Ul_BFu16ll");
    static STRUCT_IF_C aUl_Ul_BFu16ll lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "aUl_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "aUl_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu16ll, aUl_Ul_BFu16ll)
//============================================================================



static void Test_aUl_Ul_BFu16s()
{
  {
    init_simple_test("aUl_Ul_BFu16s");
    static STRUCT_IF_C aUl_Ul_BFu16s lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "aUl_Ul_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "aUl_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu16s, aUl_Ul_BFu16s)
//============================================================================



static void Test_aUl_Ul_BFu17i()
{
  {
    init_simple_test("aUl_Ul_BFu17i");
    static STRUCT_IF_C aUl_Ul_BFu17i lv;
    check2(sizeof(lv), 19, "sizeof(aUl_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "aUl_Ul_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "aUl_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu17i, aUl_Ul_BFu17i)
//============================================================================



static void Test_aUl_Ul_BFu17ll()
{
  {
    init_simple_test("aUl_Ul_BFu17ll");
    static STRUCT_IF_C aUl_Ul_BFu17ll lv;
    check2(sizeof(lv), 19, "sizeof(aUl_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "aUl_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "aUl_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu17ll, aUl_Ul_BFu17ll)
//============================================================================



static void Test_aUl_Ul_BFu1c()
{
  {
    init_simple_test("aUl_Ul_BFu1c");
    static STRUCT_IF_C aUl_Ul_BFu1c lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aUl_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu1c, aUl_Ul_BFu1c)
//============================================================================



static void Test_aUl_Ul_BFu1i()
{
  {
    init_simple_test("aUl_Ul_BFu1i");
    static STRUCT_IF_C aUl_Ul_BFu1i lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aUl_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu1i, aUl_Ul_BFu1i)
//============================================================================



static void Test_aUl_Ul_BFu1ll()
{
  {
    init_simple_test("aUl_Ul_BFu1ll");
    static STRUCT_IF_C aUl_Ul_BFu1ll lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aUl_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu1ll, aUl_Ul_BFu1ll)
//============================================================================



static void Test_aUl_Ul_BFu1s()
{
  {
    init_simple_test("aUl_Ul_BFu1s");
    static STRUCT_IF_C aUl_Ul_BFu1s lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aUl_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu1s, aUl_Ul_BFu1s)
//============================================================================



static void Test_aUl_Ul_BFu31i()
{
  {
    init_simple_test("aUl_Ul_BFu31i");
    static STRUCT_IF_C aUl_Ul_BFu31i lv;
    check2(sizeof(lv), 20, "sizeof(aUl_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "aUl_Ul_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "aUl_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu31i, aUl_Ul_BFu31i)
//============================================================================



static void Test_aUl_Ul_BFu31ll()
{
  {
    init_simple_test("aUl_Ul_BFu31ll");
    static STRUCT_IF_C aUl_Ul_BFu31ll lv;
    check2(sizeof(lv), 20, "sizeof(aUl_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "aUl_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "aUl_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu31ll, aUl_Ul_BFu31ll)
//============================================================================



static void Test_aUl_Ul_BFu32i()
{
  {
    init_simple_test("aUl_Ul_BFu32i");
    static STRUCT_IF_C aUl_Ul_BFu32i lv;
    check2(sizeof(lv), 20, "sizeof(aUl_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "aUl_Ul_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "aUl_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu32i, aUl_Ul_BFu32i)
//============================================================================



static void Test_aUl_Ul_BFu32ll()
{
  {
    init_simple_test("aUl_Ul_BFu32ll");
    static STRUCT_IF_C aUl_Ul_BFu32ll lv;
    check2(sizeof(lv), 20, "sizeof(aUl_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "aUl_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "aUl_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu32ll, aUl_Ul_BFu32ll)
//============================================================================



static void Test_aUl_Ul_BFu33()
{
  {
    init_simple_test("aUl_Ul_BFu33");
    static STRUCT_IF_C aUl_Ul_BFu33 lv;
    check2(sizeof(lv), 21, "sizeof(aUl_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu33.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "aUl_Ul_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "aUl_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu33, aUl_Ul_BFu33)
//============================================================================



static void Test_aUl_Ul_BFu7c()
{
  {
    init_simple_test("aUl_Ul_BFu7c");
    static STRUCT_IF_C aUl_Ul_BFu7c lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aUl_Ul_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aUl_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu7c, aUl_Ul_BFu7c)
//============================================================================



static void Test_aUl_Ul_BFu7i()
{
  {
    init_simple_test("aUl_Ul_BFu7i");
    static STRUCT_IF_C aUl_Ul_BFu7i lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aUl_Ul_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aUl_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu7i, aUl_Ul_BFu7i)
//============================================================================



static void Test_aUl_Ul_BFu7ll()
{
  {
    init_simple_test("aUl_Ul_BFu7ll");
    static STRUCT_IF_C aUl_Ul_BFu7ll lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aUl_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aUl_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu7ll, aUl_Ul_BFu7ll)
//============================================================================



static void Test_aUl_Ul_BFu7s()
{
  {
    init_simple_test("aUl_Ul_BFu7s");
    static STRUCT_IF_C aUl_Ul_BFu7s lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aUl_Ul_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aUl_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu7s, aUl_Ul_BFu7s)
//============================================================================



static void Test_aUl_Ul_BFu8c()
{
  {
    init_simple_test("aUl_Ul_BFu8c");
    static STRUCT_IF_C aUl_Ul_BFu8c lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aUl_Ul_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aUl_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu8c, aUl_Ul_BFu8c)
//============================================================================



static void Test_aUl_Ul_BFu8i()
{
  {
    init_simple_test("aUl_Ul_BFu8i");
    static STRUCT_IF_C aUl_Ul_BFu8i lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aUl_Ul_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aUl_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu8i, aUl_Ul_BFu8i)
//============================================================================



static void Test_aUl_Ul_BFu8ll()
{
  {
    init_simple_test("aUl_Ul_BFu8ll");
    static STRUCT_IF_C aUl_Ul_BFu8ll lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aUl_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aUl_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu8ll, aUl_Ul_BFu8ll)
//============================================================================



static void Test_aUl_Ul_BFu8s()
{
  {
    init_simple_test("aUl_Ul_BFu8s");
    static STRUCT_IF_C aUl_Ul_BFu8s lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aUl_Ul_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aUl_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu8s, aUl_Ul_BFu8s)
//============================================================================



static void Test_aUl_Ul_BFu9i()
{
  {
    init_simple_test("aUl_Ul_BFu9i");
    static STRUCT_IF_C aUl_Ul_BFu9i lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "aUl_Ul_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "aUl_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu9i, aUl_Ul_BFu9i)
//============================================================================



static void Test_aUl_Ul_BFu9ll()
{
  {
    init_simple_test("aUl_Ul_BFu9ll");
    static STRUCT_IF_C aUl_Ul_BFu9ll lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "aUl_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "aUl_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu9ll, aUl_Ul_BFu9ll)
//============================================================================



static void Test_aUl_Ul_BFu9s()
{
  {
    init_simple_test("aUl_Ul_BFu9s");
    static STRUCT_IF_C aUl_Ul_BFu9s lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_Ul_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "aUl_Ul_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "aUl_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_BFu9s, aUl_Ul_BFu9s)
//============================================================================



static void Test_aUl_Ul_C()
{
  {
    init_simple_test("aUl_Ul_C");
    STRUCT_IF_C aUl_Ul_C lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_C)");
    check_field_offset(lv, v1, 0, "aUl_Ul_C.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_C.v2");
    check_field_offset(lv, v3, 16, "aUl_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_C, aUl_Ul_C)
//============================================================================



static void Test_aUl_Ul_D()
{
  {
    init_simple_test("aUl_Ul_D");
    STRUCT_IF_C aUl_Ul_D lv;
    check2(sizeof(lv), 24, "sizeof(aUl_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_D)");
    check_field_offset(lv, v1, 0, "aUl_Ul_D.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_D.v2");
    check_field_offset(lv, v3, 16, "aUl_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_D, aUl_Ul_D)
//============================================================================



static void Test_aUl_Ul_F()
{
  {
    init_simple_test("aUl_Ul_F");
    STRUCT_IF_C aUl_Ul_F lv;
    check2(sizeof(lv), 20, "sizeof(aUl_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_F)");
    check_field_offset(lv, v1, 0, "aUl_Ul_F.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_F.v2");
    check_field_offset(lv, v3, 16, "aUl_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_F, aUl_Ul_F)
//============================================================================



static void Test_aUl_Ul_I()
{
  {
    init_simple_test("aUl_Ul_I");
    STRUCT_IF_C aUl_Ul_I lv;
    check2(sizeof(lv), 20, "sizeof(aUl_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_I)");
    check_field_offset(lv, v1, 0, "aUl_Ul_I.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_I.v2");
    check_field_offset(lv, v3, 16, "aUl_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_I, aUl_Ul_I)
//============================================================================



static void Test_aUl_Ul_Ip()
{
  {
    init_simple_test("aUl_Ul_Ip");
    STRUCT_IF_C aUl_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aUl_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_Ip)");
    check_field_offset(lv, v1, 0, "aUl_Ul_Ip.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_Ip.v2");
    check_field_offset(lv, v3, 16, "aUl_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_Ip, aUl_Ul_Ip)
//============================================================================



static void Test_aUl_Ul_L()
{
  {
    init_simple_test("aUl_Ul_L");
    STRUCT_IF_C aUl_Ul_L lv;
    check2(sizeof(lv), 24, "sizeof(aUl_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_L)");
    check_field_offset(lv, v1, 0, "aUl_Ul_L.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_L.v2");
    check_field_offset(lv, v3, 16, "aUl_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_L, aUl_Ul_L)
//============================================================================



static void Test_aUl_Ul_S()
{
  {
    init_simple_test("aUl_Ul_S");
    STRUCT_IF_C aUl_Ul_S lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_S)");
    check_field_offset(lv, v1, 0, "aUl_Ul_S.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_S.v2");
    check_field_offset(lv, v3, 16, "aUl_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_S, aUl_Ul_S)
//============================================================================



static void Test_aUl_Ul_Uc()
{
  {
    init_simple_test("aUl_Ul_Uc");
    STRUCT_IF_C aUl_Ul_Uc lv;
    check2(sizeof(lv), 17, "sizeof(aUl_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_Uc)");
    check_field_offset(lv, v1, 0, "aUl_Ul_Uc.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_Uc.v2");
    check_field_offset(lv, v3, 16, "aUl_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_Uc, aUl_Ul_Uc)
//============================================================================



static void Test_aUl_Ul_Ui()
{
  {
    init_simple_test("aUl_Ul_Ui");
    STRUCT_IF_C aUl_Ul_Ui lv;
    check2(sizeof(lv), 20, "sizeof(aUl_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_Ui)");
    check_field_offset(lv, v1, 0, "aUl_Ul_Ui.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_Ui.v2");
    check_field_offset(lv, v3, 16, "aUl_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_Ui, aUl_Ul_Ui)
//============================================================================



static void Test_aUl_Ul_Ul()
{
  {
    init_simple_test("aUl_Ul_Ul");
    STRUCT_IF_C aUl_Ul_Ul lv;
    check2(sizeof(lv), 24, "sizeof(aUl_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_Ul)");
    check_field_offset(lv, v1, 0, "aUl_Ul_Ul.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_Ul.v2");
    check_field_offset(lv, v3, 16, "aUl_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_Ul, aUl_Ul_Ul)
//============================================================================



static void Test_aUl_Ul_Us()
{
  {
    init_simple_test("aUl_Ul_Us");
    STRUCT_IF_C aUl_Ul_Us lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_Us)");
    check_field_offset(lv, v1, 0, "aUl_Ul_Us.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_Us.v2");
    check_field_offset(lv, v3, 16, "aUl_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_Us, aUl_Ul_Us)
//============================================================================



static void Test_aUl_Ul_Vp()
{
  {
    init_simple_test("aUl_Ul_Vp");
    STRUCT_IF_C aUl_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aUl_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Ul_Vp)");
    check_field_offset(lv, v1, 0, "aUl_Ul_Vp.v1");
    check_field_offset(lv, v2, 8, "aUl_Ul_Vp.v2");
    check_field_offset(lv, v3, 16, "aUl_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Ul_Vp, aUl_Ul_Vp)
//============================================================================



static void Test_aUl_Us()
{
  {
    init_simple_test("aUl_Us");
    STRUCT_IF_C aUl_Us lv;
    check2(sizeof(lv), 10, "sizeof(aUl_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us)");
    check_field_offset(lv, v1, 0, "aUl_Us.v1");
    check_field_offset(lv, v2, 8, "aUl_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us, aUl_Us)
//============================================================================



static void Test_aUl_Us_BFu15i()
{
  {
    init_simple_test("aUl_Us_BFu15i");
    static STRUCT_IF_C aUl_Us_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aUl_Us_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aUl_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu15i, aUl_Us_BFu15i)
//============================================================================



static void Test_aUl_Us_BFu15ll()
{
  {
    init_simple_test("aUl_Us_BFu15ll");
    static STRUCT_IF_C aUl_Us_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aUl_Us_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aUl_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu15ll, aUl_Us_BFu15ll)
//============================================================================



static void Test_aUl_Us_BFu15s()
{
  {
    init_simple_test("aUl_Us_BFu15s");
    static STRUCT_IF_C aUl_Us_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aUl_Us_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aUl_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu15s, aUl_Us_BFu15s)
//============================================================================



static void Test_aUl_Us_BFu16i()
{
  {
    init_simple_test("aUl_Us_BFu16i");
    static STRUCT_IF_C aUl_Us_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aUl_Us_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aUl_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu16i, aUl_Us_BFu16i)
//============================================================================



static void Test_aUl_Us_BFu16ll()
{
  {
    init_simple_test("aUl_Us_BFu16ll");
    static STRUCT_IF_C aUl_Us_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aUl_Us_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aUl_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu16ll, aUl_Us_BFu16ll)
//============================================================================



static void Test_aUl_Us_BFu16s()
{
  {
    init_simple_test("aUl_Us_BFu16s");
    static STRUCT_IF_C aUl_Us_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aUl_Us_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aUl_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu16s, aUl_Us_BFu16s)
//============================================================================



static void Test_aUl_Us_BFu17i()
{
  {
    init_simple_test("aUl_Us_BFu17i");
    static STRUCT_IF_C aUl_Us_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "aUl_Us_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "aUl_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu17i, aUl_Us_BFu17i)
//============================================================================



static void Test_aUl_Us_BFu17ll()
{
  {
    init_simple_test("aUl_Us_BFu17ll");
    static STRUCT_IF_C aUl_Us_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(aUl_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "aUl_Us_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "aUl_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu17ll, aUl_Us_BFu17ll)
//============================================================================



static void Test_aUl_Us_BFu1c()
{
  {
    init_simple_test("aUl_Us_BFu1c");
    static STRUCT_IF_C aUl_Us_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aUl_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu1c, aUl_Us_BFu1c)
//============================================================================



static void Test_aUl_Us_BFu1i()
{
  {
    init_simple_test("aUl_Us_BFu1i");
    static STRUCT_IF_C aUl_Us_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aUl_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu1i, aUl_Us_BFu1i)
//============================================================================



static void Test_aUl_Us_BFu1ll()
{
  {
    init_simple_test("aUl_Us_BFu1ll");
    static STRUCT_IF_C aUl_Us_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aUl_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu1ll, aUl_Us_BFu1ll)
//============================================================================



static void Test_aUl_Us_BFu1s()
{
  {
    init_simple_test("aUl_Us_BFu1s");
    static STRUCT_IF_C aUl_Us_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aUl_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu1s, aUl_Us_BFu1s)
//============================================================================



static void Test_aUl_Us_BFu31i()
{
  {
    init_simple_test("aUl_Us_BFu31i");
    static STRUCT_IF_C aUl_Us_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "aUl_Us_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "aUl_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu31i, aUl_Us_BFu31i)
//============================================================================



static void Test_aUl_Us_BFu31ll()
{
  {
    init_simple_test("aUl_Us_BFu31ll");
    static STRUCT_IF_C aUl_Us_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "aUl_Us_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "aUl_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu31ll, aUl_Us_BFu31ll)
//============================================================================



static void Test_aUl_Us_BFu32i()
{
  {
    init_simple_test("aUl_Us_BFu32i");
    static STRUCT_IF_C aUl_Us_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "aUl_Us_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "aUl_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu32i, aUl_Us_BFu32i)
//============================================================================



static void Test_aUl_Us_BFu32ll()
{
  {
    init_simple_test("aUl_Us_BFu32ll");
    static STRUCT_IF_C aUl_Us_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "aUl_Us_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "aUl_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu32ll, aUl_Us_BFu32ll)
//============================================================================



static void Test_aUl_Us_BFu33()
{
  {
    init_simple_test("aUl_Us_BFu33");
    static STRUCT_IF_C aUl_Us_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(aUl_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu33.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "aUl_Us_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "aUl_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu33, aUl_Us_BFu33)
//============================================================================



static void Test_aUl_Us_BFu7c()
{
  {
    init_simple_test("aUl_Us_BFu7c");
    static STRUCT_IF_C aUl_Us_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aUl_Us_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aUl_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu7c, aUl_Us_BFu7c)
//============================================================================



static void Test_aUl_Us_BFu7i()
{
  {
    init_simple_test("aUl_Us_BFu7i");
    static STRUCT_IF_C aUl_Us_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aUl_Us_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aUl_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu7i, aUl_Us_BFu7i)
//============================================================================



static void Test_aUl_Us_BFu7ll()
{
  {
    init_simple_test("aUl_Us_BFu7ll");
    static STRUCT_IF_C aUl_Us_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aUl_Us_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aUl_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu7ll, aUl_Us_BFu7ll)
//============================================================================



static void Test_aUl_Us_BFu7s()
{
  {
    init_simple_test("aUl_Us_BFu7s");
    static STRUCT_IF_C aUl_Us_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aUl_Us_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aUl_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu7s, aUl_Us_BFu7s)
//============================================================================



static void Test_aUl_Us_BFu8c()
{
  {
    init_simple_test("aUl_Us_BFu8c");
    static STRUCT_IF_C aUl_Us_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aUl_Us_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aUl_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu8c, aUl_Us_BFu8c)
//============================================================================



static void Test_aUl_Us_BFu8i()
{
  {
    init_simple_test("aUl_Us_BFu8i");
    static STRUCT_IF_C aUl_Us_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aUl_Us_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aUl_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu8i, aUl_Us_BFu8i)
//============================================================================



static void Test_aUl_Us_BFu8ll()
{
  {
    init_simple_test("aUl_Us_BFu8ll");
    static STRUCT_IF_C aUl_Us_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aUl_Us_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aUl_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu8ll, aUl_Us_BFu8ll)
//============================================================================



static void Test_aUl_Us_BFu8s()
{
  {
    init_simple_test("aUl_Us_BFu8s");
    static STRUCT_IF_C aUl_Us_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aUl_Us_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aUl_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu8s, aUl_Us_BFu8s)
//============================================================================



static void Test_aUl_Us_BFu9i()
{
  {
    init_simple_test("aUl_Us_BFu9i");
    static STRUCT_IF_C aUl_Us_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "aUl_Us_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "aUl_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu9i, aUl_Us_BFu9i)
//============================================================================



static void Test_aUl_Us_BFu9ll()
{
  {
    init_simple_test("aUl_Us_BFu9ll");
    static STRUCT_IF_C aUl_Us_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "aUl_Us_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "aUl_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu9ll, aUl_Us_BFu9ll)
//============================================================================



static void Test_aUl_Us_BFu9s()
{
  {
    init_simple_test("aUl_Us_BFu9s");
    static STRUCT_IF_C aUl_Us_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_Us_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "aUl_Us_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "aUl_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_BFu9s, aUl_Us_BFu9s)
//============================================================================



static void Test_aUl_Us_C()
{
  {
    init_simple_test("aUl_Us_C");
    STRUCT_IF_C aUl_Us_C lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_C)");
    check_field_offset(lv, v1, 0, "aUl_Us_C.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_C.v2");
    check_field_offset(lv, v3, 10, "aUl_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_C, aUl_Us_C)
//============================================================================



static void Test_aUl_Us_D()
{
  {
    init_simple_test("aUl_Us_D");
    STRUCT_IF_C aUl_Us_D lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_D)");
    check_field_offset(lv, v1, 0, "aUl_Us_D.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_D.v2");
    check_field_offset(lv, v3, 10, "aUl_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_D, aUl_Us_D)
//============================================================================



static void Test_aUl_Us_F()
{
  {
    init_simple_test("aUl_Us_F");
    STRUCT_IF_C aUl_Us_F lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_F)");
    check_field_offset(lv, v1, 0, "aUl_Us_F.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_F.v2");
    check_field_offset(lv, v3, 10, "aUl_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_F, aUl_Us_F)
//============================================================================



static void Test_aUl_Us_I()
{
  {
    init_simple_test("aUl_Us_I");
    STRUCT_IF_C aUl_Us_I lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_I)");
    check_field_offset(lv, v1, 0, "aUl_Us_I.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_I.v2");
    check_field_offset(lv, v3, 10, "aUl_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_I, aUl_Us_I)
//============================================================================



static void Test_aUl_Us_Ip()
{
  {
    init_simple_test("aUl_Us_Ip");
    STRUCT_IF_C aUl_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_Ip)");
    check_field_offset(lv, v1, 0, "aUl_Us_Ip.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_Ip.v2");
    check_field_offset(lv, v3, 10, "aUl_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_Ip, aUl_Us_Ip)
//============================================================================



static void Test_aUl_Us_L()
{
  {
    init_simple_test("aUl_Us_L");
    STRUCT_IF_C aUl_Us_L lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_L)");
    check_field_offset(lv, v1, 0, "aUl_Us_L.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_L.v2");
    check_field_offset(lv, v3, 10, "aUl_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_L, aUl_Us_L)
//============================================================================



static void Test_aUl_Us_S()
{
  {
    init_simple_test("aUl_Us_S");
    STRUCT_IF_C aUl_Us_S lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_S)");
    check_field_offset(lv, v1, 0, "aUl_Us_S.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_S.v2");
    check_field_offset(lv, v3, 10, "aUl_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_S, aUl_Us_S)
//============================================================================



static void Test_aUl_Us_Uc()
{
  {
    init_simple_test("aUl_Us_Uc");
    STRUCT_IF_C aUl_Us_Uc lv;
    check2(sizeof(lv), 11, "sizeof(aUl_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_Uc)");
    check_field_offset(lv, v1, 0, "aUl_Us_Uc.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_Uc.v2");
    check_field_offset(lv, v3, 10, "aUl_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_Uc, aUl_Us_Uc)
//============================================================================



static void Test_aUl_Us_Ui()
{
  {
    init_simple_test("aUl_Us_Ui");
    STRUCT_IF_C aUl_Us_Ui lv;
    check2(sizeof(lv), 14, "sizeof(aUl_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_Ui)");
    check_field_offset(lv, v1, 0, "aUl_Us_Ui.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_Ui.v2");
    check_field_offset(lv, v3, 10, "aUl_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_Ui, aUl_Us_Ui)
//============================================================================



static void Test_aUl_Us_Ul()
{
  {
    init_simple_test("aUl_Us_Ul");
    STRUCT_IF_C aUl_Us_Ul lv;
    check2(sizeof(lv), 18, "sizeof(aUl_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_Ul)");
    check_field_offset(lv, v1, 0, "aUl_Us_Ul.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_Ul.v2");
    check_field_offset(lv, v3, 10, "aUl_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_Ul, aUl_Us_Ul)
//============================================================================



static void Test_aUl_Us_Us()
{
  {
    init_simple_test("aUl_Us_Us");
    STRUCT_IF_C aUl_Us_Us lv;
    check2(sizeof(lv), 12, "sizeof(aUl_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_Us)");
    check_field_offset(lv, v1, 0, "aUl_Us_Us.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_Us.v2");
    check_field_offset(lv, v3, 10, "aUl_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_Us, aUl_Us_Us)
//============================================================================



static void Test_aUl_Us_Vp()
{
  {
    init_simple_test("aUl_Us_Vp");
    STRUCT_IF_C aUl_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Us_Vp)");
    check_field_offset(lv, v1, 0, "aUl_Us_Vp.v1");
    check_field_offset(lv, v2, 8, "aUl_Us_Vp.v2");
    check_field_offset(lv, v3, 10, "aUl_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Us_Vp, aUl_Us_Vp)
//============================================================================



static void Test_aUl_Vp()
{
  {
    init_simple_test("aUl_Vp");
    STRUCT_IF_C aUl_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUl_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp)");
    check_field_offset(lv, v1, 0, "aUl_Vp.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp, aUl_Vp)
//============================================================================



static void Test_aUl_Vp_BFu15i()
{
  {
    init_simple_test("aUl_Vp_BFu15i");
    static STRUCT_IF_C aUl_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aUl_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aUl_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu15i, aUl_Vp_BFu15i)
//============================================================================



static void Test_aUl_Vp_BFu15ll()
{
  {
    init_simple_test("aUl_Vp_BFu15ll");
    static STRUCT_IF_C aUl_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aUl_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aUl_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu15ll, aUl_Vp_BFu15ll)
//============================================================================



static void Test_aUl_Vp_BFu15s()
{
  {
    init_simple_test("aUl_Vp_BFu15s");
    static STRUCT_IF_C aUl_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aUl_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aUl_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu15s, aUl_Vp_BFu15s)
//============================================================================



static void Test_aUl_Vp_BFu16i()
{
  {
    init_simple_test("aUl_Vp_BFu16i");
    static STRUCT_IF_C aUl_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aUl_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aUl_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu16i, aUl_Vp_BFu16i)
//============================================================================



static void Test_aUl_Vp_BFu16ll()
{
  {
    init_simple_test("aUl_Vp_BFu16ll");
    static STRUCT_IF_C aUl_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aUl_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aUl_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu16ll, aUl_Vp_BFu16ll)
//============================================================================



static void Test_aUl_Vp_BFu16s()
{
  {
    init_simple_test("aUl_Vp_BFu16s");
    static STRUCT_IF_C aUl_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aUl_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aUl_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu16s, aUl_Vp_BFu16s)
//============================================================================



static void Test_aUl_Vp_BFu17i()
{
  {
    init_simple_test("aUl_Vp_BFu17i");
    static STRUCT_IF_C aUl_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aUl_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "aUl_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "aUl_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu17i, aUl_Vp_BFu17i)
//============================================================================



static void Test_aUl_Vp_BFu17ll()
{
  {
    init_simple_test("aUl_Vp_BFu17ll");
    static STRUCT_IF_C aUl_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aUl_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "aUl_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "aUl_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu17ll, aUl_Vp_BFu17ll)
//============================================================================



static void Test_aUl_Vp_BFu1c()
{
  {
    init_simple_test("aUl_Vp_BFu1c");
    static STRUCT_IF_C aUl_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aUl_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu1c, aUl_Vp_BFu1c)
//============================================================================



static void Test_aUl_Vp_BFu1i()
{
  {
    init_simple_test("aUl_Vp_BFu1i");
    static STRUCT_IF_C aUl_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aUl_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu1i, aUl_Vp_BFu1i)
//============================================================================



static void Test_aUl_Vp_BFu1ll()
{
  {
    init_simple_test("aUl_Vp_BFu1ll");
    static STRUCT_IF_C aUl_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aUl_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu1ll, aUl_Vp_BFu1ll)
//============================================================================



static void Test_aUl_Vp_BFu1s()
{
  {
    init_simple_test("aUl_Vp_BFu1s");
    static STRUCT_IF_C aUl_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aUl_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu1s, aUl_Vp_BFu1s)
//============================================================================



static void Test_aUl_Vp_BFu31i()
{
  {
    init_simple_test("aUl_Vp_BFu31i");
    static STRUCT_IF_C aUl_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "aUl_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "aUl_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu31i, aUl_Vp_BFu31i)
//============================================================================



static void Test_aUl_Vp_BFu31ll()
{
  {
    init_simple_test("aUl_Vp_BFu31ll");
    static STRUCT_IF_C aUl_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "aUl_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "aUl_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu31ll, aUl_Vp_BFu31ll)
//============================================================================



static void Test_aUl_Vp_BFu32i()
{
  {
    init_simple_test("aUl_Vp_BFu32i");
    static STRUCT_IF_C aUl_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "aUl_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "aUl_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu32i, aUl_Vp_BFu32i)
//============================================================================



static void Test_aUl_Vp_BFu32ll()
{
  {
    init_simple_test("aUl_Vp_BFu32ll");
    static STRUCT_IF_C aUl_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "aUl_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "aUl_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu32ll, aUl_Vp_BFu32ll)
//============================================================================



static void Test_aUl_Vp_BFu33()
{
  {
    init_simple_test("aUl_Vp_BFu33");
    static STRUCT_IF_C aUl_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(aUl_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu33.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "aUl_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "aUl_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu33, aUl_Vp_BFu33)
//============================================================================



static void Test_aUl_Vp_BFu7c()
{
  {
    init_simple_test("aUl_Vp_BFu7c");
    static STRUCT_IF_C aUl_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aUl_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aUl_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu7c, aUl_Vp_BFu7c)
//============================================================================



static void Test_aUl_Vp_BFu7i()
{
  {
    init_simple_test("aUl_Vp_BFu7i");
    static STRUCT_IF_C aUl_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aUl_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aUl_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu7i, aUl_Vp_BFu7i)
//============================================================================



static void Test_aUl_Vp_BFu7ll()
{
  {
    init_simple_test("aUl_Vp_BFu7ll");
    static STRUCT_IF_C aUl_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aUl_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aUl_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu7ll, aUl_Vp_BFu7ll)
//============================================================================



static void Test_aUl_Vp_BFu7s()
{
  {
    init_simple_test("aUl_Vp_BFu7s");
    static STRUCT_IF_C aUl_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aUl_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aUl_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu7s, aUl_Vp_BFu7s)
//============================================================================



static void Test_aUl_Vp_BFu8c()
{
  {
    init_simple_test("aUl_Vp_BFu8c");
    static STRUCT_IF_C aUl_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aUl_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aUl_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu8c, aUl_Vp_BFu8c)
//============================================================================



static void Test_aUl_Vp_BFu8i()
{
  {
    init_simple_test("aUl_Vp_BFu8i");
    static STRUCT_IF_C aUl_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aUl_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aUl_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu8i, aUl_Vp_BFu8i)
//============================================================================



static void Test_aUl_Vp_BFu8ll()
{
  {
    init_simple_test("aUl_Vp_BFu8ll");
    static STRUCT_IF_C aUl_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aUl_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aUl_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu8ll, aUl_Vp_BFu8ll)
//============================================================================



static void Test_aUl_Vp_BFu8s()
{
  {
    init_simple_test("aUl_Vp_BFu8s");
    static STRUCT_IF_C aUl_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aUl_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aUl_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu8s, aUl_Vp_BFu8s)
//============================================================================



static void Test_aUl_Vp_BFu9i()
{
  {
    init_simple_test("aUl_Vp_BFu9i");
    static STRUCT_IF_C aUl_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aUl_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aUl_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu9i, aUl_Vp_BFu9i)
//============================================================================



static void Test_aUl_Vp_BFu9ll()
{
  {
    init_simple_test("aUl_Vp_BFu9ll");
    static STRUCT_IF_C aUl_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aUl_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aUl_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu9ll, aUl_Vp_BFu9ll)
//============================================================================



static void Test_aUl_Vp_BFu9s()
{
  {
    init_simple_test("aUl_Vp_BFu9s");
    static STRUCT_IF_C aUl_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "aUl_Vp_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aUl_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aUl_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_BFu9s, aUl_Vp_BFu9s)
//============================================================================



static void Test_aUl_Vp_C()
{
  {
    init_simple_test("aUl_Vp_C");
    STRUCT_IF_C aUl_Vp_C lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_C)");
    check_field_offset(lv, v1, 0, "aUl_Vp_C.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_C, aUl_Vp_C)
//============================================================================



static void Test_aUl_Vp_D()
{
  {
    init_simple_test("aUl_Vp_D");
    STRUCT_IF_C aUl_Vp_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aUl_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_D)");
    check_field_offset(lv, v1, 0, "aUl_Vp_D.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_D, aUl_Vp_D)
//============================================================================



static void Test_aUl_Vp_F()
{
  {
    init_simple_test("aUl_Vp_F");
    STRUCT_IF_C aUl_Vp_F lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_F)");
    check_field_offset(lv, v1, 0, "aUl_Vp_F.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_F, aUl_Vp_F)
//============================================================================



static void Test_aUl_Vp_I()
{
  {
    init_simple_test("aUl_Vp_I");
    STRUCT_IF_C aUl_Vp_I lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_I)");
    check_field_offset(lv, v1, 0, "aUl_Vp_I.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_I, aUl_Vp_I)
//============================================================================



static void Test_aUl_Vp_Ip()
{
  {
    init_simple_test("aUl_Vp_Ip");
    STRUCT_IF_C aUl_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aUl_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_Ip)");
    check_field_offset(lv, v1, 0, "aUl_Vp_Ip.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_Ip, aUl_Vp_Ip)
//============================================================================



static void Test_aUl_Vp_L()
{
  {
    init_simple_test("aUl_Vp_L");
    STRUCT_IF_C aUl_Vp_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aUl_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_L)");
    check_field_offset(lv, v1, 0, "aUl_Vp_L.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_L, aUl_Vp_L)
//============================================================================



static void Test_aUl_Vp_S()
{
  {
    init_simple_test("aUl_Vp_S");
    STRUCT_IF_C aUl_Vp_S lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_S)");
    check_field_offset(lv, v1, 0, "aUl_Vp_S.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_S, aUl_Vp_S)
//============================================================================



static void Test_aUl_Vp_Uc()
{
  {
    init_simple_test("aUl_Vp_Uc");
    STRUCT_IF_C aUl_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUl_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_Uc)");
    check_field_offset(lv, v1, 0, "aUl_Vp_Uc.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_Uc, aUl_Vp_Uc)
//============================================================================



static void Test_aUl_Vp_Ui()
{
  {
    init_simple_test("aUl_Vp_Ui");
    STRUCT_IF_C aUl_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aUl_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_Ui)");
    check_field_offset(lv, v1, 0, "aUl_Vp_Ui.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_Ui, aUl_Vp_Ui)
//============================================================================



static void Test_aUl_Vp_Ul()
{
  {
    init_simple_test("aUl_Vp_Ul");
    STRUCT_IF_C aUl_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aUl_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_Ul)");
    check_field_offset(lv, v1, 0, "aUl_Vp_Ul.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_Ul, aUl_Vp_Ul)
//============================================================================



static void Test_aUl_Vp_Us()
{
  {
    init_simple_test("aUl_Vp_Us");
    STRUCT_IF_C aUl_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aUl_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_Us)");
    check_field_offset(lv, v1, 0, "aUl_Vp_Us.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_Us, aUl_Vp_Us)
//============================================================================



static void Test_aUl_Vp_Vp()
{
  {
    init_simple_test("aUl_Vp_Vp");
    STRUCT_IF_C aUl_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aUl_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUl_Vp_Vp)");
    check_field_offset(lv, v1, 0, "aUl_Vp_Vp.v1");
    check_field_offset(lv, v2, 8, "aUl_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aUl_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUl_Vp_Vp, aUl_Vp_Vp)
//============================================================================



static void Test_aUs()
{
  {
    init_simple_test("aUs");
    STRUCT_IF_C aUs lv;
    check2(sizeof(lv), 2, "sizeof(aUs)");
    check2(__alignof__(lv), 1, "__alignof__(aUs)");
    check_field_offset(lv, v1, 0, "aUs.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs, aUs)
//============================================================================



static void Test_aUs_BFu15i()
{
  {
    init_simple_test("aUs_BFu15i");
    static STRUCT_IF_C aUs_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i, aUs_BFu15i)
//============================================================================



static void Test_aUs_BFu15i_BFu15i()
{
  {
    init_simple_test("aUs_BFu15i_BFu15i");
    static STRUCT_IF_C aUs_BFu15i_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aUs_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu15i, aUs_BFu15i_BFu15i)
//============================================================================



static void Test_aUs_BFu15i_BFu15ll()
{
  {
    init_simple_test("aUs_BFu15i_BFu15ll");
    static STRUCT_IF_C aUs_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aUs_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu15ll, aUs_BFu15i_BFu15ll)
//============================================================================



static void Test_aUs_BFu15i_BFu15s()
{
  {
    init_simple_test("aUs_BFu15i_BFu15s");
    static STRUCT_IF_C aUs_BFu15i_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aUs_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu15s, aUs_BFu15i_BFu15s)
//============================================================================



static void Test_aUs_BFu15i_BFu16i()
{
  {
    init_simple_test("aUs_BFu15i_BFu16i");
    static STRUCT_IF_C aUs_BFu15i_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aUs_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aUs_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu16i, aUs_BFu15i_BFu16i)
//============================================================================



static void Test_aUs_BFu15i_BFu16ll()
{
  {
    init_simple_test("aUs_BFu15i_BFu16ll");
    static STRUCT_IF_C aUs_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aUs_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aUs_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu16ll, aUs_BFu15i_BFu16ll)
//============================================================================



static void Test_aUs_BFu15i_BFu16s()
{
  {
    init_simple_test("aUs_BFu15i_BFu16s");
    static STRUCT_IF_C aUs_BFu15i_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aUs_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aUs_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu16s, aUs_BFu15i_BFu16s)
//============================================================================



static void Test_aUs_BFu15i_BFu17i()
{
  {
    init_simple_test("aUs_BFu15i_BFu17i");
    static STRUCT_IF_C aUs_BFu15i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "aUs_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "aUs_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu17i, aUs_BFu15i_BFu17i)
//============================================================================



static void Test_aUs_BFu15i_BFu17ll()
{
  {
    init_simple_test("aUs_BFu15i_BFu17ll");
    static STRUCT_IF_C aUs_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "aUs_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "aUs_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu17ll, aUs_BFu15i_BFu17ll)
//============================================================================



static void Test_aUs_BFu15i_BFu1c()
{
  {
    init_simple_test("aUs_BFu15i_BFu1c");
    static STRUCT_IF_C aUs_BFu15i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aUs_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu1c, aUs_BFu15i_BFu1c)
//============================================================================



static void Test_aUs_BFu15i_BFu1i()
{
  {
    init_simple_test("aUs_BFu15i_BFu1i");
    static STRUCT_IF_C aUs_BFu15i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aUs_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu1i, aUs_BFu15i_BFu1i)
//============================================================================



static void Test_aUs_BFu15i_BFu1ll()
{
  {
    init_simple_test("aUs_BFu15i_BFu1ll");
    static STRUCT_IF_C aUs_BFu15i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aUs_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu1ll, aUs_BFu15i_BFu1ll)
//============================================================================



static void Test_aUs_BFu15i_BFu1s()
{
  {
    init_simple_test("aUs_BFu15i_BFu1s");
    static STRUCT_IF_C aUs_BFu15i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aUs_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu1s, aUs_BFu15i_BFu1s)
//============================================================================



static void Test_aUs_BFu15i_BFu31i()
{
  {
    init_simple_test("aUs_BFu15i_BFu31i");
    static STRUCT_IF_C aUs_BFu15i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "aUs_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "aUs_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu31i, aUs_BFu15i_BFu31i)
//============================================================================



static void Test_aUs_BFu15i_BFu31ll()
{
  {
    init_simple_test("aUs_BFu15i_BFu31ll");
    static STRUCT_IF_C aUs_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "aUs_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "aUs_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu31ll, aUs_BFu15i_BFu31ll)
//============================================================================



static void Test_aUs_BFu15i_BFu32i()
{
  {
    init_simple_test("aUs_BFu15i_BFu32i");
    static STRUCT_IF_C aUs_BFu15i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "aUs_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "aUs_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu32i, aUs_BFu15i_BFu32i)
//============================================================================



static void Test_aUs_BFu15i_BFu32ll()
{
  {
    init_simple_test("aUs_BFu15i_BFu32ll");
    static STRUCT_IF_C aUs_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "aUs_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "aUs_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu32ll, aUs_BFu15i_BFu32ll)
//============================================================================



static void Test_aUs_BFu15i_BFu33()
{
  {
    init_simple_test("aUs_BFu15i_BFu33");
    static STRUCT_IF_C aUs_BFu15i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "aUs_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "aUs_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu33, aUs_BFu15i_BFu33)
//============================================================================



static void Test_aUs_BFu15i_BFu7c()
{
  {
    init_simple_test("aUs_BFu15i_BFu7c");
    static STRUCT_IF_C aUs_BFu15i_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aUs_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aUs_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu7c, aUs_BFu15i_BFu7c)
//============================================================================



static void Test_aUs_BFu15i_BFu7i()
{
  {
    init_simple_test("aUs_BFu15i_BFu7i");
    static STRUCT_IF_C aUs_BFu15i_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aUs_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aUs_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu7i, aUs_BFu15i_BFu7i)
//============================================================================



static void Test_aUs_BFu15i_BFu7ll()
{
  {
    init_simple_test("aUs_BFu15i_BFu7ll");
    static STRUCT_IF_C aUs_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aUs_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aUs_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu7ll, aUs_BFu15i_BFu7ll)
//============================================================================



static void Test_aUs_BFu15i_BFu7s()
{
  {
    init_simple_test("aUs_BFu15i_BFu7s");
    static STRUCT_IF_C aUs_BFu15i_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aUs_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aUs_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu7s, aUs_BFu15i_BFu7s)
//============================================================================



static void Test_aUs_BFu15i_BFu8c()
{
  {
    init_simple_test("aUs_BFu15i_BFu8c");
    static STRUCT_IF_C aUs_BFu15i_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aUs_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aUs_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu8c, aUs_BFu15i_BFu8c)
//============================================================================



static void Test_aUs_BFu15i_BFu8i()
{
  {
    init_simple_test("aUs_BFu15i_BFu8i");
    static STRUCT_IF_C aUs_BFu15i_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aUs_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aUs_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu8i, aUs_BFu15i_BFu8i)
//============================================================================



static void Test_aUs_BFu15i_BFu8ll()
{
  {
    init_simple_test("aUs_BFu15i_BFu8ll");
    static STRUCT_IF_C aUs_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aUs_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aUs_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu8ll, aUs_BFu15i_BFu8ll)
//============================================================================



static void Test_aUs_BFu15i_BFu8s()
{
  {
    init_simple_test("aUs_BFu15i_BFu8s");
    static STRUCT_IF_C aUs_BFu15i_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aUs_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aUs_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu8s, aUs_BFu15i_BFu8s)
//============================================================================



static void Test_aUs_BFu15i_BFu9i()
{
  {
    init_simple_test("aUs_BFu15i_BFu9i");
    static STRUCT_IF_C aUs_BFu15i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aUs_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aUs_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu9i, aUs_BFu15i_BFu9i)
//============================================================================



static void Test_aUs_BFu15i_BFu9ll()
{
  {
    init_simple_test("aUs_BFu15i_BFu9ll");
    static STRUCT_IF_C aUs_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aUs_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aUs_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu9ll, aUs_BFu15i_BFu9ll)
//============================================================================



static void Test_aUs_BFu15i_BFu9s()
{
  {
    init_simple_test("aUs_BFu15i_BFu9s");
    static STRUCT_IF_C aUs_BFu15i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aUs_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aUs_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_BFu9s, aUs_BFu15i_BFu9s)
//============================================================================



static void Test_aUs_BFu15i_C()
{
  {
    init_simple_test("aUs_BFu15i_C");
    static STRUCT_IF_C aUs_BFu15i_C lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_C)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_C");
    check_field_offset(lv, v3, 4, "aUs_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_C, aUs_BFu15i_C)
//============================================================================



static void Test_aUs_BFu15i_D()
{
  {
    init_simple_test("aUs_BFu15i_D");
    static STRUCT_IF_C aUs_BFu15i_D lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu15i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_D)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_D");
    check_field_offset(lv, v3, 4, "aUs_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_D, aUs_BFu15i_D)
//============================================================================



static void Test_aUs_BFu15i_F()
{
  {
    init_simple_test("aUs_BFu15i_F");
    static STRUCT_IF_C aUs_BFu15i_F lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_F)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_F");
    check_field_offset(lv, v3, 4, "aUs_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_F, aUs_BFu15i_F)
//============================================================================



static void Test_aUs_BFu15i_I()
{
  {
    init_simple_test("aUs_BFu15i_I");
    static STRUCT_IF_C aUs_BFu15i_I lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_I)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_I");
    check_field_offset(lv, v3, 4, "aUs_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_I, aUs_BFu15i_I)
//============================================================================



static void Test_aUs_BFu15i_Ip()
{
  {
    init_simple_test("aUs_BFu15i_Ip");
    static STRUCT_IF_C aUs_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUs_BFu15i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_Ip");
    check_field_offset(lv, v3, 4, "aUs_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_Ip, aUs_BFu15i_Ip)
//============================================================================



static void Test_aUs_BFu15i_L()
{
  {
    init_simple_test("aUs_BFu15i_L");
    static STRUCT_IF_C aUs_BFu15i_L lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu15i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_L)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_L");
    check_field_offset(lv, v3, 4, "aUs_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_L, aUs_BFu15i_L)
//============================================================================



static void Test_aUs_BFu15i_S()
{
  {
    init_simple_test("aUs_BFu15i_S");
    static STRUCT_IF_C aUs_BFu15i_S lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_S)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_S");
    check_field_offset(lv, v3, 4, "aUs_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_S, aUs_BFu15i_S)
//============================================================================



static void Test_aUs_BFu15i_Uc()
{
  {
    init_simple_test("aUs_BFu15i_Uc");
    static STRUCT_IF_C aUs_BFu15i_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_Uc");
    check_field_offset(lv, v3, 4, "aUs_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_Uc, aUs_BFu15i_Uc)
//============================================================================



static void Test_aUs_BFu15i_Ui()
{
  {
    init_simple_test("aUs_BFu15i_Ui");
    static STRUCT_IF_C aUs_BFu15i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_Ui");
    check_field_offset(lv, v3, 4, "aUs_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_Ui, aUs_BFu15i_Ui)
//============================================================================



static void Test_aUs_BFu15i_Ul()
{
  {
    init_simple_test("aUs_BFu15i_Ul");
    static STRUCT_IF_C aUs_BFu15i_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu15i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_Ul");
    check_field_offset(lv, v3, 4, "aUs_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_Ul, aUs_BFu15i_Ul)
//============================================================================



static void Test_aUs_BFu15i_Us()
{
  {
    init_simple_test("aUs_BFu15i_Us");
    static STRUCT_IF_C aUs_BFu15i_Us lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_Us");
    check_field_offset(lv, v3, 4, "aUs_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_Us, aUs_BFu15i_Us)
//============================================================================



static void Test_aUs_BFu15i_Vp()
{
  {
    init_simple_test("aUs_BFu15i_Vp");
    static STRUCT_IF_C aUs_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUs_BFu15i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "aUs_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15i_Vp");
    check_field_offset(lv, v3, 4, "aUs_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15i_Vp, aUs_BFu15i_Vp)
//============================================================================



static void Test_aUs_BFu15ll()
{
  {
    init_simple_test("aUs_BFu15ll");
    static STRUCT_IF_C aUs_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll, aUs_BFu15ll)
//============================================================================



static void Test_aUs_BFu15ll_BFu15i()
{
  {
    init_simple_test("aUs_BFu15ll_BFu15i");
    static STRUCT_IF_C aUs_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aUs_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu15i, aUs_BFu15ll_BFu15i)
//============================================================================



static void Test_aUs_BFu15ll_BFu15ll()
{
  {
    init_simple_test("aUs_BFu15ll_BFu15ll");
    static STRUCT_IF_C aUs_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aUs_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu15ll, aUs_BFu15ll_BFu15ll)
//============================================================================



static void Test_aUs_BFu15ll_BFu15s()
{
  {
    init_simple_test("aUs_BFu15ll_BFu15s");
    static STRUCT_IF_C aUs_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aUs_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu15s, aUs_BFu15ll_BFu15s)
//============================================================================



static void Test_aUs_BFu15ll_BFu16i()
{
  {
    init_simple_test("aUs_BFu15ll_BFu16i");
    static STRUCT_IF_C aUs_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aUs_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aUs_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu16i, aUs_BFu15ll_BFu16i)
//============================================================================



static void Test_aUs_BFu15ll_BFu16ll()
{
  {
    init_simple_test("aUs_BFu15ll_BFu16ll");
    static STRUCT_IF_C aUs_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aUs_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aUs_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu16ll, aUs_BFu15ll_BFu16ll)
//============================================================================



static void Test_aUs_BFu15ll_BFu16s()
{
  {
    init_simple_test("aUs_BFu15ll_BFu16s");
    static STRUCT_IF_C aUs_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aUs_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aUs_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu16s, aUs_BFu15ll_BFu16s)
//============================================================================



static void Test_aUs_BFu15ll_BFu17i()
{
  {
    init_simple_test("aUs_BFu15ll_BFu17i");
    static STRUCT_IF_C aUs_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "aUs_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "aUs_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu17i, aUs_BFu15ll_BFu17i)
//============================================================================



static void Test_aUs_BFu15ll_BFu17ll()
{
  {
    init_simple_test("aUs_BFu15ll_BFu17ll");
    static STRUCT_IF_C aUs_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "aUs_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "aUs_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu17ll, aUs_BFu15ll_BFu17ll)
//============================================================================



static void Test_aUs_BFu15ll_BFu1c()
{
  {
    init_simple_test("aUs_BFu15ll_BFu1c");
    static STRUCT_IF_C aUs_BFu15ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aUs_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu1c, aUs_BFu15ll_BFu1c)
//============================================================================



static void Test_aUs_BFu15ll_BFu1i()
{
  {
    init_simple_test("aUs_BFu15ll_BFu1i");
    static STRUCT_IF_C aUs_BFu15ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aUs_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu1i, aUs_BFu15ll_BFu1i)
//============================================================================



static void Test_aUs_BFu15ll_BFu1ll()
{
  {
    init_simple_test("aUs_BFu15ll_BFu1ll");
    static STRUCT_IF_C aUs_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aUs_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu1ll, aUs_BFu15ll_BFu1ll)
//============================================================================



static void Test_aUs_BFu15ll_BFu1s()
{
  {
    init_simple_test("aUs_BFu15ll_BFu1s");
    static STRUCT_IF_C aUs_BFu15ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aUs_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu1s, aUs_BFu15ll_BFu1s)
//============================================================================



static void Test_aUs_BFu15ll_BFu31i()
{
  {
    init_simple_test("aUs_BFu15ll_BFu31i");
    static STRUCT_IF_C aUs_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "aUs_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "aUs_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu31i, aUs_BFu15ll_BFu31i)
//============================================================================



static void Test_aUs_BFu15ll_BFu31ll()
{
  {
    init_simple_test("aUs_BFu15ll_BFu31ll");
    static STRUCT_IF_C aUs_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "aUs_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "aUs_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu31ll, aUs_BFu15ll_BFu31ll)
//============================================================================



static void Test_aUs_BFu15ll_BFu32i()
{
  {
    init_simple_test("aUs_BFu15ll_BFu32i");
    static STRUCT_IF_C aUs_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "aUs_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "aUs_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu32i, aUs_BFu15ll_BFu32i)
//============================================================================



static void Test_aUs_BFu15ll_BFu32ll()
{
  {
    init_simple_test("aUs_BFu15ll_BFu32ll");
    static STRUCT_IF_C aUs_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "aUs_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "aUs_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu32ll, aUs_BFu15ll_BFu32ll)
//============================================================================



static void Test_aUs_BFu15ll_BFu33()
{
  {
    init_simple_test("aUs_BFu15ll_BFu33");
    static STRUCT_IF_C aUs_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "aUs_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "aUs_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu33, aUs_BFu15ll_BFu33)
//============================================================================



static void Test_aUs_BFu15ll_BFu7c()
{
  {
    init_simple_test("aUs_BFu15ll_BFu7c");
    static STRUCT_IF_C aUs_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aUs_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aUs_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu7c, aUs_BFu15ll_BFu7c)
//============================================================================



static void Test_aUs_BFu15ll_BFu7i()
{
  {
    init_simple_test("aUs_BFu15ll_BFu7i");
    static STRUCT_IF_C aUs_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aUs_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aUs_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu7i, aUs_BFu15ll_BFu7i)
//============================================================================



static void Test_aUs_BFu15ll_BFu7ll()
{
  {
    init_simple_test("aUs_BFu15ll_BFu7ll");
    static STRUCT_IF_C aUs_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aUs_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aUs_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu7ll, aUs_BFu15ll_BFu7ll)
//============================================================================



static void Test_aUs_BFu15ll_BFu7s()
{
  {
    init_simple_test("aUs_BFu15ll_BFu7s");
    static STRUCT_IF_C aUs_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aUs_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aUs_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu7s, aUs_BFu15ll_BFu7s)
//============================================================================



static void Test_aUs_BFu15ll_BFu8c()
{
  {
    init_simple_test("aUs_BFu15ll_BFu8c");
    static STRUCT_IF_C aUs_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aUs_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aUs_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu8c, aUs_BFu15ll_BFu8c)
//============================================================================



static void Test_aUs_BFu15ll_BFu8i()
{
  {
    init_simple_test("aUs_BFu15ll_BFu8i");
    static STRUCT_IF_C aUs_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aUs_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aUs_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu8i, aUs_BFu15ll_BFu8i)
//============================================================================



static void Test_aUs_BFu15ll_BFu8ll()
{
  {
    init_simple_test("aUs_BFu15ll_BFu8ll");
    static STRUCT_IF_C aUs_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aUs_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aUs_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu8ll, aUs_BFu15ll_BFu8ll)
//============================================================================



static void Test_aUs_BFu15ll_BFu8s()
{
  {
    init_simple_test("aUs_BFu15ll_BFu8s");
    static STRUCT_IF_C aUs_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aUs_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aUs_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu8s, aUs_BFu15ll_BFu8s)
//============================================================================



static void Test_aUs_BFu15ll_BFu9i()
{
  {
    init_simple_test("aUs_BFu15ll_BFu9i");
    static STRUCT_IF_C aUs_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aUs_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aUs_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu9i, aUs_BFu15ll_BFu9i)
//============================================================================



static void Test_aUs_BFu15ll_BFu9ll()
{
  {
    init_simple_test("aUs_BFu15ll_BFu9ll");
    static STRUCT_IF_C aUs_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aUs_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aUs_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu9ll, aUs_BFu15ll_BFu9ll)
//============================================================================



static void Test_aUs_BFu15ll_BFu9s()
{
  {
    init_simple_test("aUs_BFu15ll_BFu9s");
    static STRUCT_IF_C aUs_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aUs_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aUs_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_BFu9s, aUs_BFu15ll_BFu9s)
//============================================================================



static void Test_aUs_BFu15ll_C()
{
  {
    init_simple_test("aUs_BFu15ll_C");
    static STRUCT_IF_C aUs_BFu15ll_C lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_C");
    check_field_offset(lv, v3, 4, "aUs_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_C, aUs_BFu15ll_C)
//============================================================================



static void Test_aUs_BFu15ll_D()
{
  {
    init_simple_test("aUs_BFu15ll_D");
    static STRUCT_IF_C aUs_BFu15ll_D lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu15ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_D");
    check_field_offset(lv, v3, 4, "aUs_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_D, aUs_BFu15ll_D)
//============================================================================



static void Test_aUs_BFu15ll_F()
{
  {
    init_simple_test("aUs_BFu15ll_F");
    static STRUCT_IF_C aUs_BFu15ll_F lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_F");
    check_field_offset(lv, v3, 4, "aUs_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_F, aUs_BFu15ll_F)
//============================================================================



static void Test_aUs_BFu15ll_I()
{
  {
    init_simple_test("aUs_BFu15ll_I");
    static STRUCT_IF_C aUs_BFu15ll_I lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_I");
    check_field_offset(lv, v3, 4, "aUs_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_I, aUs_BFu15ll_I)
//============================================================================



static void Test_aUs_BFu15ll_Ip()
{
  {
    init_simple_test("aUs_BFu15ll_Ip");
    static STRUCT_IF_C aUs_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUs_BFu15ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_Ip");
    check_field_offset(lv, v3, 4, "aUs_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_Ip, aUs_BFu15ll_Ip)
//============================================================================



static void Test_aUs_BFu15ll_L()
{
  {
    init_simple_test("aUs_BFu15ll_L");
    static STRUCT_IF_C aUs_BFu15ll_L lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu15ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_L");
    check_field_offset(lv, v3, 4, "aUs_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_L, aUs_BFu15ll_L)
//============================================================================



static void Test_aUs_BFu15ll_S()
{
  {
    init_simple_test("aUs_BFu15ll_S");
    static STRUCT_IF_C aUs_BFu15ll_S lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_S");
    check_field_offset(lv, v3, 4, "aUs_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_S, aUs_BFu15ll_S)
//============================================================================



static void Test_aUs_BFu15ll_Uc()
{
  {
    init_simple_test("aUs_BFu15ll_Uc");
    static STRUCT_IF_C aUs_BFu15ll_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_Uc");
    check_field_offset(lv, v3, 4, "aUs_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_Uc, aUs_BFu15ll_Uc)
//============================================================================



static void Test_aUs_BFu15ll_Ui()
{
  {
    init_simple_test("aUs_BFu15ll_Ui");
    static STRUCT_IF_C aUs_BFu15ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_Ui");
    check_field_offset(lv, v3, 4, "aUs_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_Ui, aUs_BFu15ll_Ui)
//============================================================================



static void Test_aUs_BFu15ll_Ul()
{
  {
    init_simple_test("aUs_BFu15ll_Ul");
    static STRUCT_IF_C aUs_BFu15ll_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu15ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_Ul");
    check_field_offset(lv, v3, 4, "aUs_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_Ul, aUs_BFu15ll_Ul)
//============================================================================



static void Test_aUs_BFu15ll_Us()
{
  {
    init_simple_test("aUs_BFu15ll_Us");
    static STRUCT_IF_C aUs_BFu15ll_Us lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_Us");
    check_field_offset(lv, v3, 4, "aUs_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_Us, aUs_BFu15ll_Us)
//============================================================================



static void Test_aUs_BFu15ll_Vp()
{
  {
    init_simple_test("aUs_BFu15ll_Vp");
    static STRUCT_IF_C aUs_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUs_BFu15ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "aUs_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15ll_Vp");
    check_field_offset(lv, v3, 4, "aUs_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15ll_Vp, aUs_BFu15ll_Vp)
//============================================================================



static void Test_aUs_BFu15s()
{
  {
    init_simple_test("aUs_BFu15s");
    static STRUCT_IF_C aUs_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s, aUs_BFu15s)
//============================================================================



static void Test_aUs_BFu15s_BFu15i()
{
  {
    init_simple_test("aUs_BFu15s_BFu15i");
    static STRUCT_IF_C aUs_BFu15s_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aUs_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu15i, aUs_BFu15s_BFu15i)
//============================================================================



static void Test_aUs_BFu15s_BFu15ll()
{
  {
    init_simple_test("aUs_BFu15s_BFu15ll");
    static STRUCT_IF_C aUs_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aUs_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu15ll, aUs_BFu15s_BFu15ll)
//============================================================================



static void Test_aUs_BFu15s_BFu15s()
{
  {
    init_simple_test("aUs_BFu15s_BFu15s");
    static STRUCT_IF_C aUs_BFu15s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aUs_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu15s, aUs_BFu15s_BFu15s)
//============================================================================



static void Test_aUs_BFu15s_BFu16i()
{
  {
    init_simple_test("aUs_BFu15s_BFu16i");
    static STRUCT_IF_C aUs_BFu15s_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aUs_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aUs_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu16i, aUs_BFu15s_BFu16i)
//============================================================================



static void Test_aUs_BFu15s_BFu16ll()
{
  {
    init_simple_test("aUs_BFu15s_BFu16ll");
    static STRUCT_IF_C aUs_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aUs_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aUs_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu16ll, aUs_BFu15s_BFu16ll)
//============================================================================



static void Test_aUs_BFu15s_BFu16s()
{
  {
    init_simple_test("aUs_BFu15s_BFu16s");
    static STRUCT_IF_C aUs_BFu15s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aUs_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aUs_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu16s, aUs_BFu15s_BFu16s)
//============================================================================



static void Test_aUs_BFu15s_BFu17i()
{
  {
    init_simple_test("aUs_BFu15s_BFu17i");
    static STRUCT_IF_C aUs_BFu15s_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "aUs_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "aUs_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu17i, aUs_BFu15s_BFu17i)
//============================================================================



static void Test_aUs_BFu15s_BFu17ll()
{
  {
    init_simple_test("aUs_BFu15s_BFu17ll");
    static STRUCT_IF_C aUs_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "aUs_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "aUs_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu17ll, aUs_BFu15s_BFu17ll)
//============================================================================



static void Test_aUs_BFu15s_BFu1c()
{
  {
    init_simple_test("aUs_BFu15s_BFu1c");
    static STRUCT_IF_C aUs_BFu15s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aUs_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu1c, aUs_BFu15s_BFu1c)
//============================================================================



static void Test_aUs_BFu15s_BFu1i()
{
  {
    init_simple_test("aUs_BFu15s_BFu1i");
    static STRUCT_IF_C aUs_BFu15s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aUs_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu1i, aUs_BFu15s_BFu1i)
//============================================================================



static void Test_aUs_BFu15s_BFu1ll()
{
  {
    init_simple_test("aUs_BFu15s_BFu1ll");
    static STRUCT_IF_C aUs_BFu15s_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aUs_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu1ll, aUs_BFu15s_BFu1ll)
//============================================================================



static void Test_aUs_BFu15s_BFu1s()
{
  {
    init_simple_test("aUs_BFu15s_BFu1s");
    static STRUCT_IF_C aUs_BFu15s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu15s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aUs_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu1s, aUs_BFu15s_BFu1s)
//============================================================================



static void Test_aUs_BFu15s_BFu31i()
{
  {
    init_simple_test("aUs_BFu15s_BFu31i");
    static STRUCT_IF_C aUs_BFu15s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "aUs_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "aUs_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu31i, aUs_BFu15s_BFu31i)
//============================================================================



static void Test_aUs_BFu15s_BFu31ll()
{
  {
    init_simple_test("aUs_BFu15s_BFu31ll");
    static STRUCT_IF_C aUs_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "aUs_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "aUs_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu31ll, aUs_BFu15s_BFu31ll)
//============================================================================



static void Test_aUs_BFu15s_BFu32i()
{
  {
    init_simple_test("aUs_BFu15s_BFu32i");
    static STRUCT_IF_C aUs_BFu15s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "aUs_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "aUs_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu32i, aUs_BFu15s_BFu32i)
//============================================================================



static void Test_aUs_BFu15s_BFu32ll()
{
  {
    init_simple_test("aUs_BFu15s_BFu32ll");
    static STRUCT_IF_C aUs_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "aUs_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "aUs_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu32ll, aUs_BFu15s_BFu32ll)
//============================================================================



static void Test_aUs_BFu15s_BFu33()
{
  {
    init_simple_test("aUs_BFu15s_BFu33");
    static STRUCT_IF_C aUs_BFu15s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "aUs_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "aUs_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu33, aUs_BFu15s_BFu33)
//============================================================================



static void Test_aUs_BFu15s_BFu7c()
{
  {
    init_simple_test("aUs_BFu15s_BFu7c");
    static STRUCT_IF_C aUs_BFu15s_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aUs_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aUs_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu7c, aUs_BFu15s_BFu7c)
//============================================================================



static void Test_aUs_BFu15s_BFu7i()
{
  {
    init_simple_test("aUs_BFu15s_BFu7i");
    static STRUCT_IF_C aUs_BFu15s_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aUs_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aUs_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu7i, aUs_BFu15s_BFu7i)
//============================================================================



static void Test_aUs_BFu15s_BFu7ll()
{
  {
    init_simple_test("aUs_BFu15s_BFu7ll");
    static STRUCT_IF_C aUs_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aUs_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aUs_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu7ll, aUs_BFu15s_BFu7ll)
//============================================================================



static void Test_aUs_BFu15s_BFu7s()
{
  {
    init_simple_test("aUs_BFu15s_BFu7s");
    static STRUCT_IF_C aUs_BFu15s_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aUs_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aUs_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu7s, aUs_BFu15s_BFu7s)
//============================================================================



static void Test_aUs_BFu15s_BFu8c()
{
  {
    init_simple_test("aUs_BFu15s_BFu8c");
    static STRUCT_IF_C aUs_BFu15s_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aUs_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aUs_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu8c, aUs_BFu15s_BFu8c)
//============================================================================



static void Test_aUs_BFu15s_BFu8i()
{
  {
    init_simple_test("aUs_BFu15s_BFu8i");
    static STRUCT_IF_C aUs_BFu15s_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aUs_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aUs_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu8i, aUs_BFu15s_BFu8i)
//============================================================================



static void Test_aUs_BFu15s_BFu8ll()
{
  {
    init_simple_test("aUs_BFu15s_BFu8ll");
    static STRUCT_IF_C aUs_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aUs_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aUs_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu8ll, aUs_BFu15s_BFu8ll)
//============================================================================



static void Test_aUs_BFu15s_BFu8s()
{
  {
    init_simple_test("aUs_BFu15s_BFu8s");
    static STRUCT_IF_C aUs_BFu15s_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aUs_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aUs_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu8s, aUs_BFu15s_BFu8s)
//============================================================================



static void Test_aUs_BFu15s_BFu9i()
{
  {
    init_simple_test("aUs_BFu15s_BFu9i");
    static STRUCT_IF_C aUs_BFu15s_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aUs_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aUs_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu9i, aUs_BFu15s_BFu9i)
//============================================================================



static void Test_aUs_BFu15s_BFu9ll()
{
  {
    init_simple_test("aUs_BFu15s_BFu9ll");
    static STRUCT_IF_C aUs_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aUs_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aUs_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu9ll, aUs_BFu15s_BFu9ll)
//============================================================================



static void Test_aUs_BFu15s_BFu9s()
{
  {
    init_simple_test("aUs_BFu15s_BFu9s");
    static STRUCT_IF_C aUs_BFu15s_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aUs_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aUs_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_BFu9s, aUs_BFu15s_BFu9s)
//============================================================================



static void Test_aUs_BFu15s_C()
{
  {
    init_simple_test("aUs_BFu15s_C");
    static STRUCT_IF_C aUs_BFu15s_C lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_C)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_C");
    check_field_offset(lv, v3, 4, "aUs_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_C, aUs_BFu15s_C)
//============================================================================



static void Test_aUs_BFu15s_D()
{
  {
    init_simple_test("aUs_BFu15s_D");
    static STRUCT_IF_C aUs_BFu15s_D lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu15s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_D)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_D");
    check_field_offset(lv, v3, 4, "aUs_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_D, aUs_BFu15s_D)
//============================================================================



static void Test_aUs_BFu15s_F()
{
  {
    init_simple_test("aUs_BFu15s_F");
    static STRUCT_IF_C aUs_BFu15s_F lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_F)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_F");
    check_field_offset(lv, v3, 4, "aUs_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_F, aUs_BFu15s_F)
//============================================================================



static void Test_aUs_BFu15s_I()
{
  {
    init_simple_test("aUs_BFu15s_I");
    static STRUCT_IF_C aUs_BFu15s_I lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_I)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_I");
    check_field_offset(lv, v3, 4, "aUs_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_I, aUs_BFu15s_I)
//============================================================================



static void Test_aUs_BFu15s_Ip()
{
  {
    init_simple_test("aUs_BFu15s_Ip");
    static STRUCT_IF_C aUs_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUs_BFu15s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_Ip");
    check_field_offset(lv, v3, 4, "aUs_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_Ip, aUs_BFu15s_Ip)
//============================================================================



static void Test_aUs_BFu15s_L()
{
  {
    init_simple_test("aUs_BFu15s_L");
    static STRUCT_IF_C aUs_BFu15s_L lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu15s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_L)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_L");
    check_field_offset(lv, v3, 4, "aUs_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_L, aUs_BFu15s_L)
//============================================================================



static void Test_aUs_BFu15s_S()
{
  {
    init_simple_test("aUs_BFu15s_S");
    static STRUCT_IF_C aUs_BFu15s_S lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_S)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_S");
    check_field_offset(lv, v3, 4, "aUs_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_S, aUs_BFu15s_S)
//============================================================================



static void Test_aUs_BFu15s_Uc()
{
  {
    init_simple_test("aUs_BFu15s_Uc");
    static STRUCT_IF_C aUs_BFu15s_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu15s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_Uc");
    check_field_offset(lv, v3, 4, "aUs_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_Uc, aUs_BFu15s_Uc)
//============================================================================



static void Test_aUs_BFu15s_Ui()
{
  {
    init_simple_test("aUs_BFu15s_Ui");
    static STRUCT_IF_C aUs_BFu15s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu15s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_Ui");
    check_field_offset(lv, v3, 4, "aUs_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_Ui, aUs_BFu15s_Ui)
//============================================================================



static void Test_aUs_BFu15s_Ul()
{
  {
    init_simple_test("aUs_BFu15s_Ul");
    static STRUCT_IF_C aUs_BFu15s_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu15s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_Ul");
    check_field_offset(lv, v3, 4, "aUs_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_Ul, aUs_BFu15s_Ul)
//============================================================================



static void Test_aUs_BFu15s_Us()
{
  {
    init_simple_test("aUs_BFu15s_Us");
    static STRUCT_IF_C aUs_BFu15s_Us lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu15s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_Us");
    check_field_offset(lv, v3, 4, "aUs_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_Us, aUs_BFu15s_Us)
//============================================================================



static void Test_aUs_BFu15s_Vp()
{
  {
    init_simple_test("aUs_BFu15s_Vp");
    static STRUCT_IF_C aUs_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUs_BFu15s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "aUs_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aUs_BFu15s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aUs_BFu15s_Vp");
    check_field_offset(lv, v3, 4, "aUs_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu15s_Vp, aUs_BFu15s_Vp)
//============================================================================



static void Test_aUs_BFu16i()
{
  {
    init_simple_test("aUs_BFu16i");
    static STRUCT_IF_C aUs_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i, aUs_BFu16i)
//============================================================================



static void Test_aUs_BFu16i_BFu15i()
{
  {
    init_simple_test("aUs_BFu16i_BFu15i");
    static STRUCT_IF_C aUs_BFu16i_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aUs_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aUs_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu15i, aUs_BFu16i_BFu15i)
//============================================================================



static void Test_aUs_BFu16i_BFu15ll()
{
  {
    init_simple_test("aUs_BFu16i_BFu15ll");
    static STRUCT_IF_C aUs_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aUs_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aUs_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu15ll, aUs_BFu16i_BFu15ll)
//============================================================================



static void Test_aUs_BFu16i_BFu15s()
{
  {
    init_simple_test("aUs_BFu16i_BFu15s");
    static STRUCT_IF_C aUs_BFu16i_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aUs_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aUs_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu15s, aUs_BFu16i_BFu15s)
//============================================================================



static void Test_aUs_BFu16i_BFu16i()
{
  {
    init_simple_test("aUs_BFu16i_BFu16i");
    static STRUCT_IF_C aUs_BFu16i_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aUs_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu16i, aUs_BFu16i_BFu16i)
//============================================================================



static void Test_aUs_BFu16i_BFu16ll()
{
  {
    init_simple_test("aUs_BFu16i_BFu16ll");
    static STRUCT_IF_C aUs_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aUs_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu16ll, aUs_BFu16i_BFu16ll)
//============================================================================



static void Test_aUs_BFu16i_BFu16s()
{
  {
    init_simple_test("aUs_BFu16i_BFu16s");
    static STRUCT_IF_C aUs_BFu16i_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aUs_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu16s, aUs_BFu16i_BFu16s)
//============================================================================



static void Test_aUs_BFu16i_BFu17i()
{
  {
    init_simple_test("aUs_BFu16i_BFu17i");
    static STRUCT_IF_C aUs_BFu16i_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu16i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aUs_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aUs_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu17i, aUs_BFu16i_BFu17i)
//============================================================================



static void Test_aUs_BFu16i_BFu17ll()
{
  {
    init_simple_test("aUs_BFu16i_BFu17ll");
    static STRUCT_IF_C aUs_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu16i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aUs_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aUs_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu17ll, aUs_BFu16i_BFu17ll)
//============================================================================



static void Test_aUs_BFu16i_BFu1c()
{
  {
    init_simple_test("aUs_BFu16i_BFu1c");
    static STRUCT_IF_C aUs_BFu16i_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aUs_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu1c, aUs_BFu16i_BFu1c)
//============================================================================



static void Test_aUs_BFu16i_BFu1i()
{
  {
    init_simple_test("aUs_BFu16i_BFu1i");
    static STRUCT_IF_C aUs_BFu16i_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aUs_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu1i, aUs_BFu16i_BFu1i)
//============================================================================



static void Test_aUs_BFu16i_BFu1ll()
{
  {
    init_simple_test("aUs_BFu16i_BFu1ll");
    static STRUCT_IF_C aUs_BFu16i_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aUs_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu1ll, aUs_BFu16i_BFu1ll)
//============================================================================



static void Test_aUs_BFu16i_BFu1s()
{
  {
    init_simple_test("aUs_BFu16i_BFu1s");
    static STRUCT_IF_C aUs_BFu16i_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aUs_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu1s, aUs_BFu16i_BFu1s)
//============================================================================



static void Test_aUs_BFu16i_BFu31i()
{
  {
    init_simple_test("aUs_BFu16i_BFu31i");
    static STRUCT_IF_C aUs_BFu16i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aUs_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aUs_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu31i, aUs_BFu16i_BFu31i)
//============================================================================



static void Test_aUs_BFu16i_BFu31ll()
{
  {
    init_simple_test("aUs_BFu16i_BFu31ll");
    static STRUCT_IF_C aUs_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aUs_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aUs_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu31ll, aUs_BFu16i_BFu31ll)
//============================================================================



static void Test_aUs_BFu16i_BFu32i()
{
  {
    init_simple_test("aUs_BFu16i_BFu32i");
    static STRUCT_IF_C aUs_BFu16i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aUs_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aUs_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu32i, aUs_BFu16i_BFu32i)
//============================================================================



static void Test_aUs_BFu16i_BFu32ll()
{
  {
    init_simple_test("aUs_BFu16i_BFu32ll");
    static STRUCT_IF_C aUs_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aUs_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aUs_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu32ll, aUs_BFu16i_BFu32ll)
//============================================================================



static void Test_aUs_BFu16i_BFu33()
{
  {
    init_simple_test("aUs_BFu16i_BFu33");
    static STRUCT_IF_C aUs_BFu16i_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu16i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "aUs_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "aUs_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu33, aUs_BFu16i_BFu33)
//============================================================================



static void Test_aUs_BFu16i_BFu7c()
{
  {
    init_simple_test("aUs_BFu16i_BFu7c");
    static STRUCT_IF_C aUs_BFu16i_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aUs_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aUs_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu7c, aUs_BFu16i_BFu7c)
//============================================================================



static void Test_aUs_BFu16i_BFu7i()
{
  {
    init_simple_test("aUs_BFu16i_BFu7i");
    static STRUCT_IF_C aUs_BFu16i_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aUs_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aUs_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu7i, aUs_BFu16i_BFu7i)
//============================================================================



static void Test_aUs_BFu16i_BFu7ll()
{
  {
    init_simple_test("aUs_BFu16i_BFu7ll");
    static STRUCT_IF_C aUs_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aUs_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aUs_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu7ll, aUs_BFu16i_BFu7ll)
//============================================================================



static void Test_aUs_BFu16i_BFu7s()
{
  {
    init_simple_test("aUs_BFu16i_BFu7s");
    static STRUCT_IF_C aUs_BFu16i_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aUs_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aUs_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu7s, aUs_BFu16i_BFu7s)
//============================================================================



static void Test_aUs_BFu16i_BFu8c()
{
  {
    init_simple_test("aUs_BFu16i_BFu8c");
    static STRUCT_IF_C aUs_BFu16i_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aUs_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aUs_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu8c, aUs_BFu16i_BFu8c)
//============================================================================



static void Test_aUs_BFu16i_BFu8i()
{
  {
    init_simple_test("aUs_BFu16i_BFu8i");
    static STRUCT_IF_C aUs_BFu16i_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aUs_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aUs_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu8i, aUs_BFu16i_BFu8i)
//============================================================================



static void Test_aUs_BFu16i_BFu8ll()
{
  {
    init_simple_test("aUs_BFu16i_BFu8ll");
    static STRUCT_IF_C aUs_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aUs_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aUs_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu8ll, aUs_BFu16i_BFu8ll)
//============================================================================



static void Test_aUs_BFu16i_BFu8s()
{
  {
    init_simple_test("aUs_BFu16i_BFu8s");
    static STRUCT_IF_C aUs_BFu16i_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aUs_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aUs_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu8s, aUs_BFu16i_BFu8s)
//============================================================================



static void Test_aUs_BFu16i_BFu9i()
{
  {
    init_simple_test("aUs_BFu16i_BFu9i");
    static STRUCT_IF_C aUs_BFu16i_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aUs_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aUs_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu9i, aUs_BFu16i_BFu9i)
//============================================================================



static void Test_aUs_BFu16i_BFu9ll()
{
  {
    init_simple_test("aUs_BFu16i_BFu9ll");
    static STRUCT_IF_C aUs_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aUs_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aUs_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu9ll, aUs_BFu16i_BFu9ll)
//============================================================================



static void Test_aUs_BFu16i_BFu9s()
{
  {
    init_simple_test("aUs_BFu16i_BFu9s");
    static STRUCT_IF_C aUs_BFu16i_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aUs_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aUs_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_BFu9s, aUs_BFu16i_BFu9s)
//============================================================================



static void Test_aUs_BFu16i_C()
{
  {
    init_simple_test("aUs_BFu16i_C");
    static STRUCT_IF_C aUs_BFu16i_C lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_C)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_C");
    check_field_offset(lv, v3, 4, "aUs_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_C, aUs_BFu16i_C)
//============================================================================



static void Test_aUs_BFu16i_D()
{
  {
    init_simple_test("aUs_BFu16i_D");
    static STRUCT_IF_C aUs_BFu16i_D lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu16i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_D)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_D");
    check_field_offset(lv, v3, 4, "aUs_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_D, aUs_BFu16i_D)
//============================================================================



static void Test_aUs_BFu16i_F()
{
  {
    init_simple_test("aUs_BFu16i_F");
    static STRUCT_IF_C aUs_BFu16i_F lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_F)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_F");
    check_field_offset(lv, v3, 4, "aUs_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_F, aUs_BFu16i_F)
//============================================================================



static void Test_aUs_BFu16i_I()
{
  {
    init_simple_test("aUs_BFu16i_I");
    static STRUCT_IF_C aUs_BFu16i_I lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_I)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_I");
    check_field_offset(lv, v3, 4, "aUs_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_I, aUs_BFu16i_I)
//============================================================================



static void Test_aUs_BFu16i_Ip()
{
  {
    init_simple_test("aUs_BFu16i_Ip");
    static STRUCT_IF_C aUs_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUs_BFu16i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_Ip");
    check_field_offset(lv, v3, 4, "aUs_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_Ip, aUs_BFu16i_Ip)
//============================================================================



static void Test_aUs_BFu16i_L()
{
  {
    init_simple_test("aUs_BFu16i_L");
    static STRUCT_IF_C aUs_BFu16i_L lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu16i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_L)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_L");
    check_field_offset(lv, v3, 4, "aUs_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_L, aUs_BFu16i_L)
//============================================================================



static void Test_aUs_BFu16i_S()
{
  {
    init_simple_test("aUs_BFu16i_S");
    static STRUCT_IF_C aUs_BFu16i_S lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_S)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_S");
    check_field_offset(lv, v3, 4, "aUs_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_S, aUs_BFu16i_S)
//============================================================================



static void Test_aUs_BFu16i_Uc()
{
  {
    init_simple_test("aUs_BFu16i_Uc");
    static STRUCT_IF_C aUs_BFu16i_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_Uc");
    check_field_offset(lv, v3, 4, "aUs_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_Uc, aUs_BFu16i_Uc)
//============================================================================



static void Test_aUs_BFu16i_Ui()
{
  {
    init_simple_test("aUs_BFu16i_Ui");
    static STRUCT_IF_C aUs_BFu16i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_Ui");
    check_field_offset(lv, v3, 4, "aUs_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_Ui, aUs_BFu16i_Ui)
//============================================================================



static void Test_aUs_BFu16i_Ul()
{
  {
    init_simple_test("aUs_BFu16i_Ul");
    static STRUCT_IF_C aUs_BFu16i_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu16i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_Ul");
    check_field_offset(lv, v3, 4, "aUs_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_Ul, aUs_BFu16i_Ul)
//============================================================================



static void Test_aUs_BFu16i_Us()
{
  {
    init_simple_test("aUs_BFu16i_Us");
    static STRUCT_IF_C aUs_BFu16i_Us lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_Us");
    check_field_offset(lv, v3, 4, "aUs_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_Us, aUs_BFu16i_Us)
//============================================================================



static void Test_aUs_BFu16i_Vp()
{
  {
    init_simple_test("aUs_BFu16i_Vp");
    static STRUCT_IF_C aUs_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUs_BFu16i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "aUs_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16i_Vp");
    check_field_offset(lv, v3, 4, "aUs_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16i_Vp, aUs_BFu16i_Vp)
//============================================================================



static void Test_aUs_BFu16ll()
{
  {
    init_simple_test("aUs_BFu16ll");
    static STRUCT_IF_C aUs_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll, aUs_BFu16ll)
//============================================================================



static void Test_aUs_BFu16ll_BFu15i()
{
  {
    init_simple_test("aUs_BFu16ll_BFu15i");
    static STRUCT_IF_C aUs_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aUs_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aUs_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu15i, aUs_BFu16ll_BFu15i)
//============================================================================



static void Test_aUs_BFu16ll_BFu15ll()
{
  {
    init_simple_test("aUs_BFu16ll_BFu15ll");
    static STRUCT_IF_C aUs_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aUs_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aUs_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu15ll, aUs_BFu16ll_BFu15ll)
//============================================================================



static void Test_aUs_BFu16ll_BFu15s()
{
  {
    init_simple_test("aUs_BFu16ll_BFu15s");
    static STRUCT_IF_C aUs_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aUs_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aUs_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu15s, aUs_BFu16ll_BFu15s)
//============================================================================



static void Test_aUs_BFu16ll_BFu16i()
{
  {
    init_simple_test("aUs_BFu16ll_BFu16i");
    static STRUCT_IF_C aUs_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aUs_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu16i, aUs_BFu16ll_BFu16i)
//============================================================================



static void Test_aUs_BFu16ll_BFu16ll()
{
  {
    init_simple_test("aUs_BFu16ll_BFu16ll");
    static STRUCT_IF_C aUs_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aUs_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu16ll, aUs_BFu16ll_BFu16ll)
//============================================================================



static void Test_aUs_BFu16ll_BFu16s()
{
  {
    init_simple_test("aUs_BFu16ll_BFu16s");
    static STRUCT_IF_C aUs_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aUs_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu16s, aUs_BFu16ll_BFu16s)
//============================================================================



static void Test_aUs_BFu16ll_BFu17i()
{
  {
    init_simple_test("aUs_BFu16ll_BFu17i");
    static STRUCT_IF_C aUs_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu16ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aUs_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aUs_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu17i, aUs_BFu16ll_BFu17i)
//============================================================================



static void Test_aUs_BFu16ll_BFu17ll()
{
  {
    init_simple_test("aUs_BFu16ll_BFu17ll");
    static STRUCT_IF_C aUs_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aUs_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aUs_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu17ll, aUs_BFu16ll_BFu17ll)
//============================================================================



static void Test_aUs_BFu16ll_BFu1c()
{
  {
    init_simple_test("aUs_BFu16ll_BFu1c");
    static STRUCT_IF_C aUs_BFu16ll_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aUs_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu1c, aUs_BFu16ll_BFu1c)
//============================================================================



static void Test_aUs_BFu16ll_BFu1i()
{
  {
    init_simple_test("aUs_BFu16ll_BFu1i");
    static STRUCT_IF_C aUs_BFu16ll_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aUs_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu1i, aUs_BFu16ll_BFu1i)
//============================================================================



static void Test_aUs_BFu16ll_BFu1ll()
{
  {
    init_simple_test("aUs_BFu16ll_BFu1ll");
    static STRUCT_IF_C aUs_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aUs_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu1ll, aUs_BFu16ll_BFu1ll)
//============================================================================



static void Test_aUs_BFu16ll_BFu1s()
{
  {
    init_simple_test("aUs_BFu16ll_BFu1s");
    static STRUCT_IF_C aUs_BFu16ll_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aUs_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu1s, aUs_BFu16ll_BFu1s)
//============================================================================



static void Test_aUs_BFu16ll_BFu31i()
{
  {
    init_simple_test("aUs_BFu16ll_BFu31i");
    static STRUCT_IF_C aUs_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aUs_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aUs_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu31i, aUs_BFu16ll_BFu31i)
//============================================================================



static void Test_aUs_BFu16ll_BFu31ll()
{
  {
    init_simple_test("aUs_BFu16ll_BFu31ll");
    static STRUCT_IF_C aUs_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aUs_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aUs_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu31ll, aUs_BFu16ll_BFu31ll)
//============================================================================



static void Test_aUs_BFu16ll_BFu32i()
{
  {
    init_simple_test("aUs_BFu16ll_BFu32i");
    static STRUCT_IF_C aUs_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aUs_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aUs_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu32i, aUs_BFu16ll_BFu32i)
//============================================================================



static void Test_aUs_BFu16ll_BFu32ll()
{
  {
    init_simple_test("aUs_BFu16ll_BFu32ll");
    static STRUCT_IF_C aUs_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aUs_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aUs_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu32ll, aUs_BFu16ll_BFu32ll)
//============================================================================



static void Test_aUs_BFu16ll_BFu33()
{
  {
    init_simple_test("aUs_BFu16ll_BFu33");
    static STRUCT_IF_C aUs_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu16ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "aUs_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "aUs_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu33, aUs_BFu16ll_BFu33)
//============================================================================



static void Test_aUs_BFu16ll_BFu7c()
{
  {
    init_simple_test("aUs_BFu16ll_BFu7c");
    static STRUCT_IF_C aUs_BFu16ll_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aUs_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aUs_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu7c, aUs_BFu16ll_BFu7c)
//============================================================================



static void Test_aUs_BFu16ll_BFu7i()
{
  {
    init_simple_test("aUs_BFu16ll_BFu7i");
    static STRUCT_IF_C aUs_BFu16ll_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aUs_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aUs_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu7i, aUs_BFu16ll_BFu7i)
//============================================================================



static void Test_aUs_BFu16ll_BFu7ll()
{
  {
    init_simple_test("aUs_BFu16ll_BFu7ll");
    static STRUCT_IF_C aUs_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aUs_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aUs_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu7ll, aUs_BFu16ll_BFu7ll)
//============================================================================



static void Test_aUs_BFu16ll_BFu7s()
{
  {
    init_simple_test("aUs_BFu16ll_BFu7s");
    static STRUCT_IF_C aUs_BFu16ll_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aUs_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aUs_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu7s, aUs_BFu16ll_BFu7s)
//============================================================================



static void Test_aUs_BFu16ll_BFu8c()
{
  {
    init_simple_test("aUs_BFu16ll_BFu8c");
    static STRUCT_IF_C aUs_BFu16ll_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aUs_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aUs_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu8c, aUs_BFu16ll_BFu8c)
//============================================================================



static void Test_aUs_BFu16ll_BFu8i()
{
  {
    init_simple_test("aUs_BFu16ll_BFu8i");
    static STRUCT_IF_C aUs_BFu16ll_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aUs_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aUs_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu8i, aUs_BFu16ll_BFu8i)
//============================================================================



static void Test_aUs_BFu16ll_BFu8ll()
{
  {
    init_simple_test("aUs_BFu16ll_BFu8ll");
    static STRUCT_IF_C aUs_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aUs_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aUs_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu8ll, aUs_BFu16ll_BFu8ll)
//============================================================================



static void Test_aUs_BFu16ll_BFu8s()
{
  {
    init_simple_test("aUs_BFu16ll_BFu8s");
    static STRUCT_IF_C aUs_BFu16ll_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aUs_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aUs_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu8s, aUs_BFu16ll_BFu8s)
//============================================================================



static void Test_aUs_BFu16ll_BFu9i()
{
  {
    init_simple_test("aUs_BFu16ll_BFu9i");
    static STRUCT_IF_C aUs_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aUs_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aUs_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu9i, aUs_BFu16ll_BFu9i)
//============================================================================



static void Test_aUs_BFu16ll_BFu9ll()
{
  {
    init_simple_test("aUs_BFu16ll_BFu9ll");
    static STRUCT_IF_C aUs_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aUs_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aUs_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu9ll, aUs_BFu16ll_BFu9ll)
//============================================================================



static void Test_aUs_BFu16ll_BFu9s()
{
  {
    init_simple_test("aUs_BFu16ll_BFu9s");
    static STRUCT_IF_C aUs_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aUs_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aUs_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_BFu9s, aUs_BFu16ll_BFu9s)
//============================================================================



static void Test_aUs_BFu16ll_C()
{
  {
    init_simple_test("aUs_BFu16ll_C");
    static STRUCT_IF_C aUs_BFu16ll_C lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_C");
    check_field_offset(lv, v3, 4, "aUs_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_C, aUs_BFu16ll_C)
//============================================================================



static void Test_aUs_BFu16ll_D()
{
  {
    init_simple_test("aUs_BFu16ll_D");
    static STRUCT_IF_C aUs_BFu16ll_D lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu16ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_D");
    check_field_offset(lv, v3, 4, "aUs_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_D, aUs_BFu16ll_D)
//============================================================================



static void Test_aUs_BFu16ll_F()
{
  {
    init_simple_test("aUs_BFu16ll_F");
    static STRUCT_IF_C aUs_BFu16ll_F lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_F");
    check_field_offset(lv, v3, 4, "aUs_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_F, aUs_BFu16ll_F)
//============================================================================



static void Test_aUs_BFu16ll_I()
{
  {
    init_simple_test("aUs_BFu16ll_I");
    static STRUCT_IF_C aUs_BFu16ll_I lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_I");
    check_field_offset(lv, v3, 4, "aUs_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_I, aUs_BFu16ll_I)
//============================================================================



static void Test_aUs_BFu16ll_Ip()
{
  {
    init_simple_test("aUs_BFu16ll_Ip");
    static STRUCT_IF_C aUs_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUs_BFu16ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_Ip");
    check_field_offset(lv, v3, 4, "aUs_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_Ip, aUs_BFu16ll_Ip)
//============================================================================



static void Test_aUs_BFu16ll_L()
{
  {
    init_simple_test("aUs_BFu16ll_L");
    static STRUCT_IF_C aUs_BFu16ll_L lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu16ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_L");
    check_field_offset(lv, v3, 4, "aUs_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_L, aUs_BFu16ll_L)
//============================================================================



static void Test_aUs_BFu16ll_S()
{
  {
    init_simple_test("aUs_BFu16ll_S");
    static STRUCT_IF_C aUs_BFu16ll_S lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_S");
    check_field_offset(lv, v3, 4, "aUs_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_S, aUs_BFu16ll_S)
//============================================================================



static void Test_aUs_BFu16ll_Uc()
{
  {
    init_simple_test("aUs_BFu16ll_Uc");
    static STRUCT_IF_C aUs_BFu16ll_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_Uc");
    check_field_offset(lv, v3, 4, "aUs_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_Uc, aUs_BFu16ll_Uc)
//============================================================================



static void Test_aUs_BFu16ll_Ui()
{
  {
    init_simple_test("aUs_BFu16ll_Ui");
    static STRUCT_IF_C aUs_BFu16ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_Ui");
    check_field_offset(lv, v3, 4, "aUs_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_Ui, aUs_BFu16ll_Ui)
//============================================================================



static void Test_aUs_BFu16ll_Ul()
{
  {
    init_simple_test("aUs_BFu16ll_Ul");
    static STRUCT_IF_C aUs_BFu16ll_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu16ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_Ul");
    check_field_offset(lv, v3, 4, "aUs_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_Ul, aUs_BFu16ll_Ul)
//============================================================================



static void Test_aUs_BFu16ll_Us()
{
  {
    init_simple_test("aUs_BFu16ll_Us");
    static STRUCT_IF_C aUs_BFu16ll_Us lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_Us");
    check_field_offset(lv, v3, 4, "aUs_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_Us, aUs_BFu16ll_Us)
//============================================================================



static void Test_aUs_BFu16ll_Vp()
{
  {
    init_simple_test("aUs_BFu16ll_Vp");
    static STRUCT_IF_C aUs_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUs_BFu16ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "aUs_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16ll_Vp");
    check_field_offset(lv, v3, 4, "aUs_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16ll_Vp, aUs_BFu16ll_Vp)
//============================================================================



static void Test_aUs_BFu16s()
{
  {
    init_simple_test("aUs_BFu16s");
    static STRUCT_IF_C aUs_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s, aUs_BFu16s)
//============================================================================



static void Test_aUs_BFu16s_BFu15i()
{
  {
    init_simple_test("aUs_BFu16s_BFu15i");
    static STRUCT_IF_C aUs_BFu16s_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aUs_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aUs_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu15i, aUs_BFu16s_BFu15i)
//============================================================================



static void Test_aUs_BFu16s_BFu15ll()
{
  {
    init_simple_test("aUs_BFu16s_BFu15ll");
    static STRUCT_IF_C aUs_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aUs_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aUs_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu15ll, aUs_BFu16s_BFu15ll)
//============================================================================



static void Test_aUs_BFu16s_BFu15s()
{
  {
    init_simple_test("aUs_BFu16s_BFu15s");
    static STRUCT_IF_C aUs_BFu16s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aUs_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aUs_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu15s, aUs_BFu16s_BFu15s)
//============================================================================



static void Test_aUs_BFu16s_BFu16i()
{
  {
    init_simple_test("aUs_BFu16s_BFu16i");
    static STRUCT_IF_C aUs_BFu16s_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aUs_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu16i, aUs_BFu16s_BFu16i)
//============================================================================



static void Test_aUs_BFu16s_BFu16ll()
{
  {
    init_simple_test("aUs_BFu16s_BFu16ll");
    static STRUCT_IF_C aUs_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aUs_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu16ll, aUs_BFu16s_BFu16ll)
//============================================================================



static void Test_aUs_BFu16s_BFu16s()
{
  {
    init_simple_test("aUs_BFu16s_BFu16s");
    static STRUCT_IF_C aUs_BFu16s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aUs_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu16s, aUs_BFu16s_BFu16s)
//============================================================================



static void Test_aUs_BFu16s_BFu17i()
{
  {
    init_simple_test("aUs_BFu16s_BFu17i");
    static STRUCT_IF_C aUs_BFu16s_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu16s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aUs_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aUs_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu17i, aUs_BFu16s_BFu17i)
//============================================================================



static void Test_aUs_BFu16s_BFu17ll()
{
  {
    init_simple_test("aUs_BFu16s_BFu17ll");
    static STRUCT_IF_C aUs_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu16s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aUs_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aUs_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu17ll, aUs_BFu16s_BFu17ll)
//============================================================================



static void Test_aUs_BFu16s_BFu1c()
{
  {
    init_simple_test("aUs_BFu16s_BFu1c");
    static STRUCT_IF_C aUs_BFu16s_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aUs_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu1c, aUs_BFu16s_BFu1c)
//============================================================================



static void Test_aUs_BFu16s_BFu1i()
{
  {
    init_simple_test("aUs_BFu16s_BFu1i");
    static STRUCT_IF_C aUs_BFu16s_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aUs_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu1i, aUs_BFu16s_BFu1i)
//============================================================================



static void Test_aUs_BFu16s_BFu1ll()
{
  {
    init_simple_test("aUs_BFu16s_BFu1ll");
    static STRUCT_IF_C aUs_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aUs_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu1ll, aUs_BFu16s_BFu1ll)
//============================================================================



static void Test_aUs_BFu16s_BFu1s()
{
  {
    init_simple_test("aUs_BFu16s_BFu1s");
    static STRUCT_IF_C aUs_BFu16s_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aUs_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu1s, aUs_BFu16s_BFu1s)
//============================================================================



static void Test_aUs_BFu16s_BFu31i()
{
  {
    init_simple_test("aUs_BFu16s_BFu31i");
    static STRUCT_IF_C aUs_BFu16s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aUs_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aUs_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu31i, aUs_BFu16s_BFu31i)
//============================================================================



static void Test_aUs_BFu16s_BFu31ll()
{
  {
    init_simple_test("aUs_BFu16s_BFu31ll");
    static STRUCT_IF_C aUs_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aUs_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aUs_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu31ll, aUs_BFu16s_BFu31ll)
//============================================================================



static void Test_aUs_BFu16s_BFu32i()
{
  {
    init_simple_test("aUs_BFu16s_BFu32i");
    static STRUCT_IF_C aUs_BFu16s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aUs_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aUs_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu32i, aUs_BFu16s_BFu32i)
//============================================================================



static void Test_aUs_BFu16s_BFu32ll()
{
  {
    init_simple_test("aUs_BFu16s_BFu32ll");
    static STRUCT_IF_C aUs_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aUs_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aUs_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu32ll, aUs_BFu16s_BFu32ll)
//============================================================================



static void Test_aUs_BFu16s_BFu33()
{
  {
    init_simple_test("aUs_BFu16s_BFu33");
    static STRUCT_IF_C aUs_BFu16s_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu16s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "aUs_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "aUs_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu33, aUs_BFu16s_BFu33)
//============================================================================



static void Test_aUs_BFu16s_BFu7c()
{
  {
    init_simple_test("aUs_BFu16s_BFu7c");
    static STRUCT_IF_C aUs_BFu16s_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aUs_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aUs_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu7c, aUs_BFu16s_BFu7c)
//============================================================================



static void Test_aUs_BFu16s_BFu7i()
{
  {
    init_simple_test("aUs_BFu16s_BFu7i");
    static STRUCT_IF_C aUs_BFu16s_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aUs_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aUs_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu7i, aUs_BFu16s_BFu7i)
//============================================================================



static void Test_aUs_BFu16s_BFu7ll()
{
  {
    init_simple_test("aUs_BFu16s_BFu7ll");
    static STRUCT_IF_C aUs_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aUs_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aUs_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu7ll, aUs_BFu16s_BFu7ll)
//============================================================================



static void Test_aUs_BFu16s_BFu7s()
{
  {
    init_simple_test("aUs_BFu16s_BFu7s");
    static STRUCT_IF_C aUs_BFu16s_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aUs_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aUs_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu7s, aUs_BFu16s_BFu7s)
//============================================================================



static void Test_aUs_BFu16s_BFu8c()
{
  {
    init_simple_test("aUs_BFu16s_BFu8c");
    static STRUCT_IF_C aUs_BFu16s_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aUs_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aUs_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu8c, aUs_BFu16s_BFu8c)
//============================================================================



static void Test_aUs_BFu16s_BFu8i()
{
  {
    init_simple_test("aUs_BFu16s_BFu8i");
    static STRUCT_IF_C aUs_BFu16s_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aUs_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aUs_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu8i, aUs_BFu16s_BFu8i)
//============================================================================



static void Test_aUs_BFu16s_BFu8ll()
{
  {
    init_simple_test("aUs_BFu16s_BFu8ll");
    static STRUCT_IF_C aUs_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aUs_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aUs_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu8ll, aUs_BFu16s_BFu8ll)
//============================================================================



static void Test_aUs_BFu16s_BFu8s()
{
  {
    init_simple_test("aUs_BFu16s_BFu8s");
    static STRUCT_IF_C aUs_BFu16s_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aUs_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aUs_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu8s, aUs_BFu16s_BFu8s)
//============================================================================



static void Test_aUs_BFu16s_BFu9i()
{
  {
    init_simple_test("aUs_BFu16s_BFu9i");
    static STRUCT_IF_C aUs_BFu16s_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aUs_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aUs_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu9i, aUs_BFu16s_BFu9i)
//============================================================================



static void Test_aUs_BFu16s_BFu9ll()
{
  {
    init_simple_test("aUs_BFu16s_BFu9ll");
    static STRUCT_IF_C aUs_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aUs_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aUs_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu9ll, aUs_BFu16s_BFu9ll)
//============================================================================



static void Test_aUs_BFu16s_BFu9s()
{
  {
    init_simple_test("aUs_BFu16s_BFu9s");
    static STRUCT_IF_C aUs_BFu16s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aUs_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aUs_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_BFu9s, aUs_BFu16s_BFu9s)
//============================================================================



static void Test_aUs_BFu16s_C()
{
  {
    init_simple_test("aUs_BFu16s_C");
    static STRUCT_IF_C aUs_BFu16s_C lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_C)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_C");
    check_field_offset(lv, v3, 4, "aUs_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_C, aUs_BFu16s_C)
//============================================================================



static void Test_aUs_BFu16s_D()
{
  {
    init_simple_test("aUs_BFu16s_D");
    static STRUCT_IF_C aUs_BFu16s_D lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu16s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_D)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_D");
    check_field_offset(lv, v3, 4, "aUs_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_D, aUs_BFu16s_D)
//============================================================================



static void Test_aUs_BFu16s_F()
{
  {
    init_simple_test("aUs_BFu16s_F");
    static STRUCT_IF_C aUs_BFu16s_F lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_F)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_F");
    check_field_offset(lv, v3, 4, "aUs_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_F, aUs_BFu16s_F)
//============================================================================



static void Test_aUs_BFu16s_I()
{
  {
    init_simple_test("aUs_BFu16s_I");
    static STRUCT_IF_C aUs_BFu16s_I lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_I)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_I");
    check_field_offset(lv, v3, 4, "aUs_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_I, aUs_BFu16s_I)
//============================================================================



static void Test_aUs_BFu16s_Ip()
{
  {
    init_simple_test("aUs_BFu16s_Ip");
    static STRUCT_IF_C aUs_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUs_BFu16s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_Ip");
    check_field_offset(lv, v3, 4, "aUs_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_Ip, aUs_BFu16s_Ip)
//============================================================================



static void Test_aUs_BFu16s_L()
{
  {
    init_simple_test("aUs_BFu16s_L");
    static STRUCT_IF_C aUs_BFu16s_L lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu16s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_L)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_L");
    check_field_offset(lv, v3, 4, "aUs_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_L, aUs_BFu16s_L)
//============================================================================



static void Test_aUs_BFu16s_S()
{
  {
    init_simple_test("aUs_BFu16s_S");
    static STRUCT_IF_C aUs_BFu16s_S lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_S)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_S");
    check_field_offset(lv, v3, 4, "aUs_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_S, aUs_BFu16s_S)
//============================================================================



static void Test_aUs_BFu16s_Uc()
{
  {
    init_simple_test("aUs_BFu16s_Uc");
    static STRUCT_IF_C aUs_BFu16s_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu16s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_Uc");
    check_field_offset(lv, v3, 4, "aUs_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_Uc, aUs_BFu16s_Uc)
//============================================================================



static void Test_aUs_BFu16s_Ui()
{
  {
    init_simple_test("aUs_BFu16s_Ui");
    static STRUCT_IF_C aUs_BFu16s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu16s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_Ui");
    check_field_offset(lv, v3, 4, "aUs_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_Ui, aUs_BFu16s_Ui)
//============================================================================



static void Test_aUs_BFu16s_Ul()
{
  {
    init_simple_test("aUs_BFu16s_Ul");
    static STRUCT_IF_C aUs_BFu16s_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aUs_BFu16s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_Ul");
    check_field_offset(lv, v3, 4, "aUs_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_Ul, aUs_BFu16s_Ul)
//============================================================================



static void Test_aUs_BFu16s_Us()
{
  {
    init_simple_test("aUs_BFu16s_Us");
    static STRUCT_IF_C aUs_BFu16s_Us lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu16s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_Us");
    check_field_offset(lv, v3, 4, "aUs_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_Us, aUs_BFu16s_Us)
//============================================================================



static void Test_aUs_BFu16s_Vp()
{
  {
    init_simple_test("aUs_BFu16s_Vp");
    static STRUCT_IF_C aUs_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUs_BFu16s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "aUs_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aUs_BFu16s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aUs_BFu16s_Vp");
    check_field_offset(lv, v3, 4, "aUs_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu16s_Vp, aUs_BFu16s_Vp)
//============================================================================



static void Test_aUs_BFu17i()
{
  {
    init_simple_test("aUs_BFu17i");
    static STRUCT_IF_C aUs_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i, aUs_BFu17i)
//============================================================================



static void Test_aUs_BFu17i_BFu15i()
{
  {
    init_simple_test("aUs_BFu17i_BFu15i");
    static STRUCT_IF_C aUs_BFu17i_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUs_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUs_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu15i, aUs_BFu17i_BFu15i)
//============================================================================



static void Test_aUs_BFu17i_BFu15ll()
{
  {
    init_simple_test("aUs_BFu17i_BFu15ll");
    static STRUCT_IF_C aUs_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUs_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUs_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu15ll, aUs_BFu17i_BFu15ll)
//============================================================================



static void Test_aUs_BFu17i_BFu15s()
{
  {
    init_simple_test("aUs_BFu17i_BFu15s");
    static STRUCT_IF_C aUs_BFu17i_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUs_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUs_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu15s, aUs_BFu17i_BFu15s)
//============================================================================



static void Test_aUs_BFu17i_BFu16i()
{
  {
    init_simple_test("aUs_BFu17i_BFu16i");
    static STRUCT_IF_C aUs_BFu17i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUs_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUs_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu16i, aUs_BFu17i_BFu16i)
//============================================================================



static void Test_aUs_BFu17i_BFu16ll()
{
  {
    init_simple_test("aUs_BFu17i_BFu16ll");
    static STRUCT_IF_C aUs_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUs_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUs_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu16ll, aUs_BFu17i_BFu16ll)
//============================================================================



static void Test_aUs_BFu17i_BFu16s()
{
  {
    init_simple_test("aUs_BFu17i_BFu16s");
    static STRUCT_IF_C aUs_BFu17i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUs_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUs_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu16s, aUs_BFu17i_BFu16s)
//============================================================================



static void Test_aUs_BFu17i_BFu17i()
{
  {
    init_simple_test("aUs_BFu17i_BFu17i");
    static STRUCT_IF_C aUs_BFu17i_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aUs_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu17i, aUs_BFu17i_BFu17i)
//============================================================================



static void Test_aUs_BFu17i_BFu17ll()
{
  {
    init_simple_test("aUs_BFu17i_BFu17ll");
    static STRUCT_IF_C aUs_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aUs_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu17ll, aUs_BFu17i_BFu17ll)
//============================================================================



static void Test_aUs_BFu17i_BFu1c()
{
  {
    init_simple_test("aUs_BFu17i_BFu1c");
    static STRUCT_IF_C aUs_BFu17i_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUs_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu1c, aUs_BFu17i_BFu1c)
//============================================================================



static void Test_aUs_BFu17i_BFu1i()
{
  {
    init_simple_test("aUs_BFu17i_BFu1i");
    static STRUCT_IF_C aUs_BFu17i_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUs_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu1i, aUs_BFu17i_BFu1i)
//============================================================================



static void Test_aUs_BFu17i_BFu1ll()
{
  {
    init_simple_test("aUs_BFu17i_BFu1ll");
    static STRUCT_IF_C aUs_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUs_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu1ll, aUs_BFu17i_BFu1ll)
//============================================================================



static void Test_aUs_BFu17i_BFu1s()
{
  {
    init_simple_test("aUs_BFu17i_BFu1s");
    static STRUCT_IF_C aUs_BFu17i_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUs_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu1s, aUs_BFu17i_BFu1s)
//============================================================================



static void Test_aUs_BFu17i_BFu31i()
{
  {
    init_simple_test("aUs_BFu17i_BFu31i");
    static STRUCT_IF_C aUs_BFu17i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu17i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aUs_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aUs_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu31i, aUs_BFu17i_BFu31i)
//============================================================================



static void Test_aUs_BFu17i_BFu31ll()
{
  {
    init_simple_test("aUs_BFu17i_BFu31ll");
    static STRUCT_IF_C aUs_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu17i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aUs_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aUs_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu31ll, aUs_BFu17i_BFu31ll)
//============================================================================



static void Test_aUs_BFu17i_BFu32i()
{
  {
    init_simple_test("aUs_BFu17i_BFu32i");
    static STRUCT_IF_C aUs_BFu17i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu17i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aUs_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aUs_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu32i, aUs_BFu17i_BFu32i)
//============================================================================



static void Test_aUs_BFu17i_BFu32ll()
{
  {
    init_simple_test("aUs_BFu17i_BFu32ll");
    static STRUCT_IF_C aUs_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu17i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aUs_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aUs_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu32ll, aUs_BFu17i_BFu32ll)
//============================================================================



static void Test_aUs_BFu17i_BFu33()
{
  {
    init_simple_test("aUs_BFu17i_BFu33");
    static STRUCT_IF_C aUs_BFu17i_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu17i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "aUs_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "aUs_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu33, aUs_BFu17i_BFu33)
//============================================================================



static void Test_aUs_BFu17i_BFu7c()
{
  {
    init_simple_test("aUs_BFu17i_BFu7c");
    static STRUCT_IF_C aUs_BFu17i_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUs_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUs_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu7c, aUs_BFu17i_BFu7c)
//============================================================================



static void Test_aUs_BFu17i_BFu7i()
{
  {
    init_simple_test("aUs_BFu17i_BFu7i");
    static STRUCT_IF_C aUs_BFu17i_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUs_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUs_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu7i, aUs_BFu17i_BFu7i)
//============================================================================



static void Test_aUs_BFu17i_BFu7ll()
{
  {
    init_simple_test("aUs_BFu17i_BFu7ll");
    static STRUCT_IF_C aUs_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUs_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUs_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu7ll, aUs_BFu17i_BFu7ll)
//============================================================================



static void Test_aUs_BFu17i_BFu7s()
{
  {
    init_simple_test("aUs_BFu17i_BFu7s");
    static STRUCT_IF_C aUs_BFu17i_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUs_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUs_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu7s, aUs_BFu17i_BFu7s)
//============================================================================



static void Test_aUs_BFu17i_BFu8c()
{
  {
    init_simple_test("aUs_BFu17i_BFu8c");
    static STRUCT_IF_C aUs_BFu17i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUs_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUs_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu8c, aUs_BFu17i_BFu8c)
//============================================================================



static void Test_aUs_BFu17i_BFu8i()
{
  {
    init_simple_test("aUs_BFu17i_BFu8i");
    static STRUCT_IF_C aUs_BFu17i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUs_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUs_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu8i, aUs_BFu17i_BFu8i)
//============================================================================



static void Test_aUs_BFu17i_BFu8ll()
{
  {
    init_simple_test("aUs_BFu17i_BFu8ll");
    static STRUCT_IF_C aUs_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUs_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUs_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu8ll, aUs_BFu17i_BFu8ll)
//============================================================================



static void Test_aUs_BFu17i_BFu8s()
{
  {
    init_simple_test("aUs_BFu17i_BFu8s");
    static STRUCT_IF_C aUs_BFu17i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUs_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUs_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu8s, aUs_BFu17i_BFu8s)
//============================================================================



static void Test_aUs_BFu17i_BFu9i()
{
  {
    init_simple_test("aUs_BFu17i_BFu9i");
    static STRUCT_IF_C aUs_BFu17i_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUs_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUs_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu9i, aUs_BFu17i_BFu9i)
//============================================================================



static void Test_aUs_BFu17i_BFu9ll()
{
  {
    init_simple_test("aUs_BFu17i_BFu9ll");
    static STRUCT_IF_C aUs_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUs_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUs_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu9ll, aUs_BFu17i_BFu9ll)
//============================================================================



static void Test_aUs_BFu17i_BFu9s()
{
  {
    init_simple_test("aUs_BFu17i_BFu9s");
    static STRUCT_IF_C aUs_BFu17i_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUs_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUs_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_BFu9s, aUs_BFu17i_BFu9s)
//============================================================================



static void Test_aUs_BFu17i_C()
{
  {
    init_simple_test("aUs_BFu17i_C");
    static STRUCT_IF_C aUs_BFu17i_C lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_C)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_C");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_C");
    check_field_offset(lv, v3, 5, "aUs_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_C, aUs_BFu17i_C)
//============================================================================



static void Test_aUs_BFu17i_D()
{
  {
    init_simple_test("aUs_BFu17i_D");
    static STRUCT_IF_C aUs_BFu17i_D lv;
    check2(sizeof(lv), 13, "sizeof(aUs_BFu17i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_D)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_D");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_D");
    check_field_offset(lv, v3, 5, "aUs_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_D, aUs_BFu17i_D)
//============================================================================



static void Test_aUs_BFu17i_F()
{
  {
    init_simple_test("aUs_BFu17i_F");
    static STRUCT_IF_C aUs_BFu17i_F lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu17i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_F)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_F");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_F");
    check_field_offset(lv, v3, 5, "aUs_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_F, aUs_BFu17i_F)
//============================================================================



static void Test_aUs_BFu17i_I()
{
  {
    init_simple_test("aUs_BFu17i_I");
    static STRUCT_IF_C aUs_BFu17i_I lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu17i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_I)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_I");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_I");
    check_field_offset(lv, v3, 5, "aUs_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_I, aUs_BFu17i_I)
//============================================================================



static void Test_aUs_BFu17i_Ip()
{
  {
    init_simple_test("aUs_BFu17i_Ip");
    static STRUCT_IF_C aUs_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUs_BFu17i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_Ip");
    check_field_offset(lv, v3, 5, "aUs_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_Ip, aUs_BFu17i_Ip)
//============================================================================



static void Test_aUs_BFu17i_L()
{
  {
    init_simple_test("aUs_BFu17i_L");
    static STRUCT_IF_C aUs_BFu17i_L lv;
    check2(sizeof(lv), 13, "sizeof(aUs_BFu17i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_L)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_L");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_L");
    check_field_offset(lv, v3, 5, "aUs_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_L, aUs_BFu17i_L)
//============================================================================



static void Test_aUs_BFu17i_S()
{
  {
    init_simple_test("aUs_BFu17i_S");
    static STRUCT_IF_C aUs_BFu17i_S lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_S)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_S");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_S");
    check_field_offset(lv, v3, 5, "aUs_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_S, aUs_BFu17i_S)
//============================================================================



static void Test_aUs_BFu17i_Uc()
{
  {
    init_simple_test("aUs_BFu17i_Uc");
    static STRUCT_IF_C aUs_BFu17i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_Uc");
    check_field_offset(lv, v3, 5, "aUs_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_Uc, aUs_BFu17i_Uc)
//============================================================================



static void Test_aUs_BFu17i_Ui()
{
  {
    init_simple_test("aUs_BFu17i_Ui");
    static STRUCT_IF_C aUs_BFu17i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu17i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_Ui");
    check_field_offset(lv, v3, 5, "aUs_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_Ui, aUs_BFu17i_Ui)
//============================================================================



static void Test_aUs_BFu17i_Ul()
{
  {
    init_simple_test("aUs_BFu17i_Ul");
    static STRUCT_IF_C aUs_BFu17i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aUs_BFu17i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_Ul");
    check_field_offset(lv, v3, 5, "aUs_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_Ul, aUs_BFu17i_Ul)
//============================================================================



static void Test_aUs_BFu17i_Us()
{
  {
    init_simple_test("aUs_BFu17i_Us");
    static STRUCT_IF_C aUs_BFu17i_Us lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_Us");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_Us");
    check_field_offset(lv, v3, 5, "aUs_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_Us, aUs_BFu17i_Us)
//============================================================================



static void Test_aUs_BFu17i_Vp()
{
  {
    init_simple_test("aUs_BFu17i_Vp");
    static STRUCT_IF_C aUs_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUs_BFu17i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "aUs_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17i_Vp");
    check_field_offset(lv, v3, 5, "aUs_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17i_Vp, aUs_BFu17i_Vp)
//============================================================================



static void Test_aUs_BFu17ll()
{
  {
    init_simple_test("aUs_BFu17ll");
    static STRUCT_IF_C aUs_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll, aUs_BFu17ll)
//============================================================================



static void Test_aUs_BFu17ll_BFu15i()
{
  {
    init_simple_test("aUs_BFu17ll_BFu15i");
    static STRUCT_IF_C aUs_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUs_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUs_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu15i, aUs_BFu17ll_BFu15i)
//============================================================================



static void Test_aUs_BFu17ll_BFu15ll()
{
  {
    init_simple_test("aUs_BFu17ll_BFu15ll");
    static STRUCT_IF_C aUs_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUs_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUs_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu15ll, aUs_BFu17ll_BFu15ll)
//============================================================================



static void Test_aUs_BFu17ll_BFu15s()
{
  {
    init_simple_test("aUs_BFu17ll_BFu15s");
    static STRUCT_IF_C aUs_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUs_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUs_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu15s, aUs_BFu17ll_BFu15s)
//============================================================================



static void Test_aUs_BFu17ll_BFu16i()
{
  {
    init_simple_test("aUs_BFu17ll_BFu16i");
    static STRUCT_IF_C aUs_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUs_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUs_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu16i, aUs_BFu17ll_BFu16i)
//============================================================================



static void Test_aUs_BFu17ll_BFu16ll()
{
  {
    init_simple_test("aUs_BFu17ll_BFu16ll");
    static STRUCT_IF_C aUs_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUs_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUs_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu16ll, aUs_BFu17ll_BFu16ll)
//============================================================================



static void Test_aUs_BFu17ll_BFu16s()
{
  {
    init_simple_test("aUs_BFu17ll_BFu16s");
    static STRUCT_IF_C aUs_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUs_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUs_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu16s, aUs_BFu17ll_BFu16s)
//============================================================================



static void Test_aUs_BFu17ll_BFu17i()
{
  {
    init_simple_test("aUs_BFu17ll_BFu17i");
    static STRUCT_IF_C aUs_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aUs_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu17i, aUs_BFu17ll_BFu17i)
//============================================================================



static void Test_aUs_BFu17ll_BFu17ll()
{
  {
    init_simple_test("aUs_BFu17ll_BFu17ll");
    static STRUCT_IF_C aUs_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aUs_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu17ll, aUs_BFu17ll_BFu17ll)
//============================================================================



static void Test_aUs_BFu17ll_BFu1c()
{
  {
    init_simple_test("aUs_BFu17ll_BFu1c");
    static STRUCT_IF_C aUs_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUs_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu1c, aUs_BFu17ll_BFu1c)
//============================================================================



static void Test_aUs_BFu17ll_BFu1i()
{
  {
    init_simple_test("aUs_BFu17ll_BFu1i");
    static STRUCT_IF_C aUs_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUs_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu1i, aUs_BFu17ll_BFu1i)
//============================================================================



static void Test_aUs_BFu17ll_BFu1ll()
{
  {
    init_simple_test("aUs_BFu17ll_BFu1ll");
    static STRUCT_IF_C aUs_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUs_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu1ll, aUs_BFu17ll_BFu1ll)
//============================================================================



static void Test_aUs_BFu17ll_BFu1s()
{
  {
    init_simple_test("aUs_BFu17ll_BFu1s");
    static STRUCT_IF_C aUs_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUs_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu1s, aUs_BFu17ll_BFu1s)
//============================================================================



static void Test_aUs_BFu17ll_BFu31i()
{
  {
    init_simple_test("aUs_BFu17ll_BFu31i");
    static STRUCT_IF_C aUs_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu17ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aUs_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aUs_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu31i, aUs_BFu17ll_BFu31i)
//============================================================================



static void Test_aUs_BFu17ll_BFu31ll()
{
  {
    init_simple_test("aUs_BFu17ll_BFu31ll");
    static STRUCT_IF_C aUs_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUs_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aUs_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aUs_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu31ll, aUs_BFu17ll_BFu31ll)
//============================================================================



static void Test_aUs_BFu17ll_BFu32i()
{
  {
    init_simple_test("aUs_BFu17ll_BFu32i");
    static STRUCT_IF_C aUs_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu17ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aUs_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aUs_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu32i, aUs_BFu17ll_BFu32i)
//============================================================================



static void Test_aUs_BFu17ll_BFu32ll()
{
  {
    init_simple_test("aUs_BFu17ll_BFu32ll");
    static STRUCT_IF_C aUs_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aUs_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aUs_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu32ll, aUs_BFu17ll_BFu32ll)
//============================================================================



static void Test_aUs_BFu17ll_BFu33()
{
  {
    init_simple_test("aUs_BFu17ll_BFu33");
    static STRUCT_IF_C aUs_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu17ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "aUs_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "aUs_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu33, aUs_BFu17ll_BFu33)
//============================================================================



static void Test_aUs_BFu17ll_BFu7c()
{
  {
    init_simple_test("aUs_BFu17ll_BFu7c");
    static STRUCT_IF_C aUs_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUs_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUs_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu7c, aUs_BFu17ll_BFu7c)
//============================================================================



static void Test_aUs_BFu17ll_BFu7i()
{
  {
    init_simple_test("aUs_BFu17ll_BFu7i");
    static STRUCT_IF_C aUs_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUs_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUs_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu7i, aUs_BFu17ll_BFu7i)
//============================================================================



static void Test_aUs_BFu17ll_BFu7ll()
{
  {
    init_simple_test("aUs_BFu17ll_BFu7ll");
    static STRUCT_IF_C aUs_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUs_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUs_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu7ll, aUs_BFu17ll_BFu7ll)
//============================================================================



static void Test_aUs_BFu17ll_BFu7s()
{
  {
    init_simple_test("aUs_BFu17ll_BFu7s");
    static STRUCT_IF_C aUs_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu17ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUs_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUs_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu7s, aUs_BFu17ll_BFu7s)
//============================================================================



static void Test_aUs_BFu17ll_BFu8c()
{
  {
    init_simple_test("aUs_BFu17ll_BFu8c");
    static STRUCT_IF_C aUs_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUs_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUs_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu8c, aUs_BFu17ll_BFu8c)
//============================================================================



static void Test_aUs_BFu17ll_BFu8i()
{
  {
    init_simple_test("aUs_BFu17ll_BFu8i");
    static STRUCT_IF_C aUs_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUs_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUs_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu8i, aUs_BFu17ll_BFu8i)
//============================================================================



static void Test_aUs_BFu17ll_BFu8ll()
{
  {
    init_simple_test("aUs_BFu17ll_BFu8ll");
    static STRUCT_IF_C aUs_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUs_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUs_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu8ll, aUs_BFu17ll_BFu8ll)
//============================================================================



static void Test_aUs_BFu17ll_BFu8s()
{
  {
    init_simple_test("aUs_BFu17ll_BFu8s");
    static STRUCT_IF_C aUs_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUs_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUs_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu8s, aUs_BFu17ll_BFu8s)
//============================================================================



static void Test_aUs_BFu17ll_BFu9i()
{
  {
    init_simple_test("aUs_BFu17ll_BFu9i");
    static STRUCT_IF_C aUs_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUs_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUs_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu9i, aUs_BFu17ll_BFu9i)
//============================================================================



static void Test_aUs_BFu17ll_BFu9ll()
{
  {
    init_simple_test("aUs_BFu17ll_BFu9ll");
    static STRUCT_IF_C aUs_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUs_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUs_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu9ll, aUs_BFu17ll_BFu9ll)
//============================================================================



static void Test_aUs_BFu17ll_BFu9s()
{
  {
    init_simple_test("aUs_BFu17ll_BFu9s");
    static STRUCT_IF_C aUs_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUs_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUs_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_BFu9s, aUs_BFu17ll_BFu9s)
//============================================================================



static void Test_aUs_BFu17ll_C()
{
  {
    init_simple_test("aUs_BFu17ll_C");
    static STRUCT_IF_C aUs_BFu17ll_C lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_C");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_C");
    check_field_offset(lv, v3, 5, "aUs_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_C, aUs_BFu17ll_C)
//============================================================================



static void Test_aUs_BFu17ll_D()
{
  {
    init_simple_test("aUs_BFu17ll_D");
    static STRUCT_IF_C aUs_BFu17ll_D lv;
    check2(sizeof(lv), 13, "sizeof(aUs_BFu17ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_D");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_D");
    check_field_offset(lv, v3, 5, "aUs_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_D, aUs_BFu17ll_D)
//============================================================================



static void Test_aUs_BFu17ll_F()
{
  {
    init_simple_test("aUs_BFu17ll_F");
    static STRUCT_IF_C aUs_BFu17ll_F lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu17ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_F");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_F");
    check_field_offset(lv, v3, 5, "aUs_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_F, aUs_BFu17ll_F)
//============================================================================



static void Test_aUs_BFu17ll_I()
{
  {
    init_simple_test("aUs_BFu17ll_I");
    static STRUCT_IF_C aUs_BFu17ll_I lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu17ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_I");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_I");
    check_field_offset(lv, v3, 5, "aUs_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_I, aUs_BFu17ll_I)
//============================================================================



static void Test_aUs_BFu17ll_Ip()
{
  {
    init_simple_test("aUs_BFu17ll_Ip");
    static STRUCT_IF_C aUs_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUs_BFu17ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_Ip");
    check_field_offset(lv, v3, 5, "aUs_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_Ip, aUs_BFu17ll_Ip)
//============================================================================



static void Test_aUs_BFu17ll_L()
{
  {
    init_simple_test("aUs_BFu17ll_L");
    static STRUCT_IF_C aUs_BFu17ll_L lv;
    check2(sizeof(lv), 13, "sizeof(aUs_BFu17ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_L");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_L");
    check_field_offset(lv, v3, 5, "aUs_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_L, aUs_BFu17ll_L)
//============================================================================



static void Test_aUs_BFu17ll_S()
{
  {
    init_simple_test("aUs_BFu17ll_S");
    static STRUCT_IF_C aUs_BFu17ll_S lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_S");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_S");
    check_field_offset(lv, v3, 5, "aUs_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_S, aUs_BFu17ll_S)
//============================================================================



static void Test_aUs_BFu17ll_Uc()
{
  {
    init_simple_test("aUs_BFu17ll_Uc");
    static STRUCT_IF_C aUs_BFu17ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu17ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_Uc");
    check_field_offset(lv, v3, 5, "aUs_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_Uc, aUs_BFu17ll_Uc)
//============================================================================



static void Test_aUs_BFu17ll_Ui()
{
  {
    init_simple_test("aUs_BFu17ll_Ui");
    static STRUCT_IF_C aUs_BFu17ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aUs_BFu17ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_Ui");
    check_field_offset(lv, v3, 5, "aUs_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_Ui, aUs_BFu17ll_Ui)
//============================================================================



static void Test_aUs_BFu17ll_Ul()
{
  {
    init_simple_test("aUs_BFu17ll_Ul");
    static STRUCT_IF_C aUs_BFu17ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aUs_BFu17ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_Ul");
    check_field_offset(lv, v3, 5, "aUs_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_Ul, aUs_BFu17ll_Ul)
//============================================================================



static void Test_aUs_BFu17ll_Us()
{
  {
    init_simple_test("aUs_BFu17ll_Us");
    static STRUCT_IF_C aUs_BFu17ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu17ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_Us");
    check_field_offset(lv, v3, 5, "aUs_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_Us, aUs_BFu17ll_Us)
//============================================================================



static void Test_aUs_BFu17ll_Vp()
{
  {
    init_simple_test("aUs_BFu17ll_Vp");
    static STRUCT_IF_C aUs_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUs_BFu17ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "aUs_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aUs_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aUs_BFu17ll_Vp");
    check_field_offset(lv, v3, 5, "aUs_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu17ll_Vp, aUs_BFu17ll_Vp)
//============================================================================



static void Test_aUs_BFu1c()
{
  {
    init_simple_test("aUs_BFu1c");
    static STRUCT_IF_C aUs_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aUs_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c, aUs_BFu1c)
//============================================================================



static void Test_aUs_BFu1c_BFu15i()
{
  {
    init_simple_test("aUs_BFu1c_BFu15i");
    static STRUCT_IF_C aUs_BFu1c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu1c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aUs_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aUs_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu15i, aUs_BFu1c_BFu15i)
//============================================================================



static void Test_aUs_BFu1c_BFu15ll()
{
  {
    init_simple_test("aUs_BFu1c_BFu15ll");
    static STRUCT_IF_C aUs_BFu1c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu1c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aUs_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aUs_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu15ll, aUs_BFu1c_BFu15ll)
//============================================================================



static void Test_aUs_BFu1c_BFu15s()
{
  {
    init_simple_test("aUs_BFu1c_BFu15s");
    static STRUCT_IF_C aUs_BFu1c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aUs_BFu1c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aUs_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aUs_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu15s, aUs_BFu1c_BFu15s)
//============================================================================



static void Test_aUs_BFu1c_BFu16i()
{
  {
    init_simple_test("aUs_BFu1c_BFu16i");
    static STRUCT_IF_C aUs_BFu1c_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu1c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aUs_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aUs_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu16i, aUs_BFu1c_BFu16i)
//============================================================================



static void Test_aUs_BFu1c_BFu16ll()
{
  {
    init_simple_test("aUs_BFu1c_BFu16ll");
    static STRUCT_IF_C aUs_BFu1c_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu1c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aUs_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aUs_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu16ll, aUs_BFu1c_BFu16ll)
//============================================================================



static void Test_aUs_BFu1c_BFu16s()
{
  {
    init_simple_test("aUs_BFu1c_BFu16s");
    static STRUCT_IF_C aUs_BFu1c_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu1c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aUs_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aUs_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu16s, aUs_BFu1c_BFu16s)
//============================================================================



static void Test_aUs_BFu1c_BFu17i()
{
  {
    init_simple_test("aUs_BFu1c_BFu17i");
    static STRUCT_IF_C aUs_BFu1c_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu1c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aUs_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aUs_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu17i, aUs_BFu1c_BFu17i)
//============================================================================



static void Test_aUs_BFu1c_BFu17ll()
{
  {
    init_simple_test("aUs_BFu1c_BFu17ll");
    static STRUCT_IF_C aUs_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aUs_BFu1c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aUs_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aUs_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu17ll, aUs_BFu1c_BFu17ll)
//============================================================================



static void Test_aUs_BFu1c_BFu1c()
{
  {
    init_simple_test("aUs_BFu1c_BFu1c");
    static STRUCT_IF_C aUs_BFu1c_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aUs_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aUs_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu1c, aUs_BFu1c_BFu1c)
//============================================================================



static void Test_aUs_BFu1c_BFu1i()
{
  {
    init_simple_test("aUs_BFu1c_BFu1i");
    static STRUCT_IF_C aUs_BFu1c_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aUs_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aUs_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu1i, aUs_BFu1c_BFu1i)
//============================================================================



static void Test_aUs_BFu1c_BFu1ll()
{
  {
    init_simple_test("aUs_BFu1c_BFu1ll");
    static STRUCT_IF_C aUs_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aUs_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aUs_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu1ll, aUs_BFu1c_BFu1ll)
//============================================================================



static void Test_aUs_BFu1c_BFu1s()
{
  {
    init_simple_test("aUs_BFu1c_BFu1s");
    static STRUCT_IF_C aUs_BFu1c_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aUs_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aUs_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu1s, aUs_BFu1c_BFu1s)
//============================================================================



static void Test_aUs_BFu1c_BFu31i()
{
  {
    init_simple_test("aUs_BFu1c_BFu31i");
    static STRUCT_IF_C aUs_BFu1c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu1c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aUs_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aUs_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu31i, aUs_BFu1c_BFu31i)
//============================================================================



static void Test_aUs_BFu1c_BFu31ll()
{
  {
    init_simple_test("aUs_BFu1c_BFu31ll");
    static STRUCT_IF_C aUs_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aUs_BFu1c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aUs_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aUs_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu31ll, aUs_BFu1c_BFu31ll)
//============================================================================



static void Test_aUs_BFu1c_BFu32i()
{
  {
    init_simple_test("aUs_BFu1c_BFu32i");
    static STRUCT_IF_C aUs_BFu1c_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu1c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aUs_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aUs_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu32i, aUs_BFu1c_BFu32i)
//============================================================================



static void Test_aUs_BFu1c_BFu32ll()
{
  {
    init_simple_test("aUs_BFu1c_BFu32ll");
    static STRUCT_IF_C aUs_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aUs_BFu1c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUs_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUs_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aUs_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aUs_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aUs_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUs_BFu1c_BFu3