// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
struct __attribute__((packed)) aUc_D_BFu1c { unsigned char v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_D_BFu1i { unsigned char v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_D_BFu1ll { unsigned char v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_D_BFu1s { unsigned char v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_D_BFu31i { unsigned char v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_D_BFu31ll { unsigned char v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_D_BFu32i { unsigned char v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_D_BFu32ll { unsigned char v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_D_BFu33 { unsigned char v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_D_BFu7c { unsigned char v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_D_BFu7i { unsigned char v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_D_BFu7ll { unsigned char v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_D_BFu7s { unsigned char v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_D_BFu8c { unsigned char v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_D_BFu8i { unsigned char v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_D_BFu8ll { unsigned char v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_D_BFu8s { unsigned char v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_D_BFu9i { unsigned char v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_D_BFu9ll { unsigned char v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_D_BFu9s { unsigned char v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_D_C { unsigned char v1; double v2; char v3; };
struct __attribute__((packed)) aUc_D_D { unsigned char v1; double v2; double v3; };
struct __attribute__((packed)) aUc_D_F { unsigned char v1; double v2; float v3; };
struct __attribute__((packed)) aUc_D_I { unsigned char v1; double v2; int v3; };
struct __attribute__((packed)) aUc_D_Ip { unsigned char v1; double v2; int * v3; };
struct __attribute__((packed)) aUc_D_L { unsigned char v1; double v2; long long v3; };
struct __attribute__((packed)) aUc_D_S { unsigned char v1; double v2; short v3; };
struct __attribute__((packed)) aUc_D_Uc { unsigned char v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aUc_D_Ui { unsigned char v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aUc_D_Ul { unsigned char v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_D_Us { unsigned char v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aUc_D_Vp { unsigned char v1; double v2; void * v3; };
struct __attribute__((packed)) aUc_F { unsigned char v1; float v2; };
struct __attribute__((packed)) aUc_F_BFu15i { unsigned char v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_F_BFu15ll { unsigned char v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_F_BFu15s { unsigned char v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_F_BFu16i { unsigned char v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_F_BFu16ll { unsigned char v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_F_BFu16s { unsigned char v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_F_BFu17i { unsigned char v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_F_BFu17ll { unsigned char v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_F_BFu1c { unsigned char v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_F_BFu1i { unsigned char v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_F_BFu1ll { unsigned char v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_F_BFu1s { unsigned char v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_F_BFu31i { unsigned char v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_F_BFu31ll { unsigned char v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_F_BFu32i { unsigned char v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_F_BFu32ll { unsigned char v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_F_BFu33 { unsigned char v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_F_BFu7c { unsigned char v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_F_BFu7i { unsigned char v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_F_BFu7ll { unsigned char v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_F_BFu7s { unsigned char v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_F_BFu8c { unsigned char v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_F_BFu8i { unsigned char v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_F_BFu8ll { unsigned char v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_F_BFu8s { unsigned char v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_F_BFu9i { unsigned char v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_F_BFu9ll { unsigned char v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_F_BFu9s { unsigned char v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_F_C { unsigned char v1; float v2; char v3; };
struct __attribute__((packed)) aUc_F_D { unsigned char v1; float v2; double v3; };
struct __attribute__((packed)) aUc_F_F { unsigned char v1; float v2; float v3; };
struct __attribute__((packed)) aUc_F_I { unsigned char v1; float v2; int v3; };
struct __attribute__((packed)) aUc_F_Ip { unsigned char v1; float v2; int * v3; };
struct __attribute__((packed)) aUc_F_L { unsigned char v1; float v2; long long v3; };
struct __attribute__((packed)) aUc_F_S { unsigned char v1; float v2; short v3; };
struct __attribute__((packed)) aUc_F_Uc { unsigned char v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aUc_F_Ui { unsigned char v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aUc_F_Ul { unsigned char v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_F_Us { unsigned char v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aUc_F_Vp { unsigned char v1; float v2; void * v3; };
struct __attribute__((packed)) aUc_I { unsigned char v1; int v2; };
struct __attribute__((packed)) aUc_I_BFu15i { unsigned char v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_I_BFu15ll { unsigned char v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_I_BFu15s { unsigned char v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_I_BFu16i { unsigned char v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_I_BFu16ll { unsigned char v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_I_BFu16s { unsigned char v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_I_BFu17i { unsigned char v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_I_BFu17ll { unsigned char v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_I_BFu1c { unsigned char v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_I_BFu1i { unsigned char v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_I_BFu1ll { unsigned char v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_I_BFu1s { unsigned char v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_I_BFu31i { unsigned char v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_I_BFu31ll { unsigned char v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_I_BFu32i { unsigned char v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_I_BFu32ll { unsigned char v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_I_BFu33 { unsigned char v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_I_BFu7c { unsigned char v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_I_BFu7i { unsigned char v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_I_BFu7ll { unsigned char v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_I_BFu7s { unsigned char v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_I_BFu8c { unsigned char v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_I_BFu8i { unsigned char v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_I_BFu8ll { unsigned char v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_I_BFu8s { unsigned char v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_I_BFu9i { unsigned char v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_I_BFu9ll { unsigned char v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_I_BFu9s { unsigned char v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_I_C { unsigned char v1; int v2; char v3; };
struct __attribute__((packed)) aUc_I_D { unsigned char v1; int v2; double v3; };
struct __attribute__((packed)) aUc_I_F { unsigned char v1; int v2; float v3; };
struct __attribute__((packed)) aUc_I_I { unsigned char v1; int v2; int v3; };
struct __attribute__((packed)) aUc_I_Ip { unsigned char v1; int v2; int * v3; };
struct __attribute__((packed)) aUc_I_L { unsigned char v1; int v2; long long v3; };
struct __attribute__((packed)) aUc_I_S { unsigned char v1; int v2; short v3; };
struct __attribute__((packed)) aUc_I_Uc { unsigned char v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aUc_I_Ui { unsigned char v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aUc_I_Ul { unsigned char v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_I_Us { unsigned char v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aUc_I_Vp { unsigned char v1; int v2; void * v3; };
struct __attribute__((packed)) aUc_Ip { unsigned char v1; int * v2; };
struct __attribute__((packed)) aUc_Ip_BFu15i { unsigned char v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_Ip_BFu15ll { unsigned char v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_Ip_BFu15s { unsigned char v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_Ip_BFu16i { unsigned char v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_Ip_BFu16ll { unsigned char v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_Ip_BFu16s { unsigned char v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_Ip_BFu17i { unsigned char v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_Ip_BFu17ll { unsigned char v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_Ip_BFu1c { unsigned char v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_Ip_BFu1i { unsigned char v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_Ip_BFu1ll { unsigned char v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_Ip_BFu1s { unsigned char v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_Ip_BFu31i { unsigned char v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_Ip_BFu31ll { unsigned char v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_Ip_BFu32i { unsigned char v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_Ip_BFu32ll { unsigned char v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_Ip_BFu33 { unsigned char v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_Ip_BFu7c { unsigned char v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_Ip_BFu7i { unsigned char v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_Ip_BFu7ll { unsigned char v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_Ip_BFu7s { unsigned char v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_Ip_BFu8c { unsigned char v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_Ip_BFu8i { unsigned char v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_Ip_BFu8ll { unsigned char v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_Ip_BFu8s { unsigned char v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_Ip_BFu9i { unsigned char v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_Ip_BFu9ll { unsigned char v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_Ip_BFu9s { unsigned char v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_Ip_C { unsigned char v1; int * v2; char v3; };
struct __attribute__((packed)) aUc_Ip_D { unsigned char v1; int * v2; double v3; };
struct __attribute__((packed)) aUc_Ip_F { unsigned char v1; int * v2; float v3; };
struct __attribute__((packed)) aUc_Ip_I { unsigned char v1; int * v2; int v3; };
struct __attribute__((packed)) aUc_Ip_Ip { unsigned char v1; int * v2; int * v3; };
struct __attribute__((packed)) aUc_Ip_L { unsigned char v1; int * v2; long long v3; };
struct __attribute__((packed)) aUc_Ip_S { unsigned char v1; int * v2; short v3; };
struct __attribute__((packed)) aUc_Ip_Uc { unsigned char v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aUc_Ip_Ui { unsigned char v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aUc_Ip_Ul { unsigned char v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_Ip_Us { unsigned char v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aUc_Ip_Vp { unsigned char v1; int * v2; void * v3; };
struct __attribute__((packed)) aUc_L { unsigned char v1; long long v2; };
struct __attribute__((packed)) aUc_L_BFu15i { unsigned char v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_L_BFu15ll { unsigned char v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_L_BFu15s { unsigned char v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_L_BFu16i { unsigned char v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_L_BFu16ll { unsigned char v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_L_BFu16s { unsigned char v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_L_BFu17i { unsigned char v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_L_BFu17ll { unsigned char v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_L_BFu1c { unsigned char v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_L_BFu1i { unsigned char v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_L_BFu1ll { unsigned char v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_L_BFu1s { unsigned char v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_L_BFu31i { unsigned char v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_L_BFu31ll { unsigned char v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_L_BFu32i { unsigned char v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_L_BFu32ll { unsigned char v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_L_BFu33 { unsigned char v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_L_BFu7c { unsigned char v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_L_BFu7i { unsigned char v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_L_BFu7ll { unsigned char v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_L_BFu7s { unsigned char v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_L_BFu8c { unsigned char v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_L_BFu8i { unsigned char v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_L_BFu8ll { unsigned char v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_L_BFu8s { unsigned char v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_L_BFu9i { unsigned char v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_L_BFu9ll { unsigned char v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_L_BFu9s { unsigned char v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_L_C { unsigned char v1; long long v2; char v3; };
struct __attribute__((packed)) aUc_L_D { unsigned char v1; long long v2; double v3; };
struct __attribute__((packed)) aUc_L_F { unsigned char v1; long long v2; float v3; };
struct __attribute__((packed)) aUc_L_I { unsigned char v1; long long v2; int v3; };
struct __attribute__((packed)) aUc_L_Ip { unsigned char v1; long long v2; int * v3; };
struct __attribute__((packed)) aUc_L_L { unsigned char v1; long long v2; long long v3; };
struct __attribute__((packed)) aUc_L_S { unsigned char v1; long long v2; short v3; };
struct __attribute__((packed)) aUc_L_Uc { unsigned char v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aUc_L_Ui { unsigned char v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aUc_L_Ul { unsigned char v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_L_Us { unsigned char v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aUc_L_Vp { unsigned char v1; long long v2; void * v3; };
struct __attribute__((packed)) aUc_S { unsigned char v1; short v2; };
struct __attribute__((packed)) aUc_S_BFu15i { unsigned char v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_S_BFu15ll { unsigned char v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_S_BFu15s { unsigned char v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_S_BFu16i { unsigned char v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_S_BFu16ll { unsigned char v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_S_BFu16s { unsigned char v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_S_BFu17i { unsigned char v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_S_BFu17ll { unsigned char v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_S_BFu1c { unsigned char v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_S_BFu1i { unsigned char v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_S_BFu1ll { unsigned char v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_S_BFu1s { unsigned char v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_S_BFu31i { unsigned char v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_S_BFu31ll { unsigned char v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_S_BFu32i { unsigned char v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_S_BFu32ll { unsigned char v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_S_BFu33 { unsigned char v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_S_BFu7c { unsigned char v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_S_BFu7i { unsigned char v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_S_BFu7ll { unsigned char v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_S_BFu7s { unsigned char v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_S_BFu8c { unsigned char v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_S_BFu8i { unsigned char v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_S_BFu8ll { unsigned char v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_S_BFu8s { unsigned char v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_S_BFu9i { unsigned char v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_S_BFu9ll { unsigned char v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_S_BFu9s { unsigned char v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_S_C { unsigned char v1; short v2; char v3; };
struct __attribute__((packed)) aUc_S_D { unsigned char v1; short v2; double v3; };
struct __attribute__((packed)) aUc_S_F { unsigned char v1; short v2; float v3; };
struct __attribute__((packed)) aUc_S_I { unsigned char v1; short v2; int v3; };
struct __attribute__((packed)) aUc_S_Ip { unsigned char v1; short v2; int * v3; };
struct __attribute__((packed)) aUc_S_L { unsigned char v1; short v2; long long v3; };
struct __attribute__((packed)) aUc_S_S { unsigned char v1; short v2; short v3; };
struct __attribute__((packed)) aUc_S_Uc { unsigned char v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aUc_S_Ui { unsigned char v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aUc_S_Ul { unsigned char v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_S_Us { unsigned char v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aUc_S_Vp { unsigned char v1; short v2; void * v3; };
struct __attribute__((packed)) aUc_Uc { unsigned char v1; unsigned char v2; };
struct __attribute__((packed)) aUc_Uc_BFu15i { unsigned char v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_Uc_BFu15ll { unsigned char v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_Uc_BFu15s { unsigned char v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_Uc_BFu16i { unsigned char v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_Uc_BFu16ll { unsigned char v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_Uc_BFu16s { unsigned char v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_Uc_BFu17i { unsigned char v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_Uc_BFu17ll { unsigned char v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_Uc_BFu1c { unsigned char v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_Uc_BFu1i { unsigned char v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_Uc_BFu1ll { unsigned char v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_Uc_BFu1s { unsigned char v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_Uc_BFu31i { unsigned char v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_Uc_BFu31ll { unsigned char v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_Uc_BFu32i { unsigned char v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_Uc_BFu32ll { unsigned char v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_Uc_BFu33 { unsigned char v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_Uc_BFu7c { unsigned char v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_Uc_BFu7i { unsigned char v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_Uc_BFu7ll { unsigned char v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_Uc_BFu7s { unsigned char v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_Uc_BFu8c { unsigned char v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_Uc_BFu8i { unsigned char v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_Uc_BFu8ll { unsigned char v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_Uc_BFu8s { unsigned char v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_Uc_BFu9i { unsigned char v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_Uc_BFu9ll { unsigned char v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_Uc_BFu9s { unsigned char v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_Uc_C { unsigned char v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aUc_Uc_D { unsigned char v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aUc_Uc_F { unsigned char v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aUc_Uc_I { unsigned char v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aUc_Uc_Ip { unsigned char v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aUc_Uc_L { unsigned char v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aUc_Uc_S { unsigned char v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aUc_Uc_Uc { unsigned char v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aUc_Uc_Ui { unsigned char v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aUc_Uc_Ul { unsigned char v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_Uc_Us { unsigned char v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aUc_Uc_Vp { unsigned char v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aUc_Ui { unsigned char v1; unsigned int v2; };
struct __attribute__((packed)) aUc_Ui_BFu15i { unsigned char v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_Ui_BFu15ll { unsigned char v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_Ui_BFu15s { unsigned char v1; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_Ui_BFu16i { unsigned char v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_Ui_BFu16ll { unsigned char v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_Ui_BFu16s { unsigned char v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_Ui_BFu17i { unsigned char v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_Ui_BFu17ll { unsigned char v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_Ui_BFu1c { unsigned char v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_Ui_BFu1i { unsigned char v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_Ui_BFu1ll { unsigned char v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_Ui_BFu1s { unsigned char v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_Ui_BFu31i { unsigned char v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_Ui_BFu31ll { unsigned char v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_Ui_BFu32i { unsigned char v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_Ui_BFu32ll { unsigned char v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_Ui_BFu33 { unsigned char v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_Ui_BFu7c { unsigned char v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_Ui_BFu7i { unsigned char v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_Ui_BFu7ll { unsigned char v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_Ui_BFu7s { unsigned char v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_Ui_BFu8c { unsigned char v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_Ui_BFu8i { unsigned char v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_Ui_BFu8ll { unsigned char v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_Ui_BFu8s { unsigned char v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_Ui_BFu9i { unsigned char v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_Ui_BFu9ll { unsigned char v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_Ui_BFu9s { unsigned char v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_Ui_C { unsigned char v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aUc_Ui_D { unsigned char v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aUc_Ui_F { unsigned char v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aUc_Ui_I { unsigned char v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aUc_Ui_Ip { unsigned char v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aUc_Ui_L { unsigned char v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aUc_Ui_S { unsigned char v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aUc_Ui_Uc { unsigned char v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aUc_Ui_Ui { unsigned char v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aUc_Ui_Ul { unsigned char v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_Ui_Us { unsigned char v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aUc_Ui_Vp { unsigned char v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aUc_Ul { unsigned char v1; unsigned long long v2; };
struct __attribute__((packed)) aUc_Ul_BFu15i { unsigned char v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_Ul_BFu15ll { unsigned char v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_Ul_BFu15s { unsigned char v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_Ul_BFu16i { unsigned char v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_Ul_BFu16ll { unsigned char v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_Ul_BFu16s { unsigned char v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_Ul_BFu17i { unsigned char v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_Ul_BFu17ll { unsigned char v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_Ul_BFu1c { unsigned char v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_Ul_BFu1i { unsigned char v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_Ul_BFu1ll { unsigned char v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_Ul_BFu1s { unsigned char v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_Ul_BFu31i { unsigned char v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_Ul_BFu31ll { unsigned char v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_Ul_BFu32i { unsigned char v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_Ul_BFu32ll { unsigned char v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_Ul_BFu33 { unsigned char v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_Ul_BFu7c { unsigned char v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_Ul_BFu7i { unsigned char v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_Ul_BFu7ll { unsigned char v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_Ul_BFu7s { unsigned char v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_Ul_BFu8c { unsigned char v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_Ul_BFu8i { unsigned char v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_Ul_BFu8ll { unsigned char v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_Ul_BFu8s { unsigned char v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_Ul_BFu9i { unsigned char v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_Ul_BFu9ll { unsigned char v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_Ul_BFu9s { unsigned char v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_Ul_C { unsigned char v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aUc_Ul_D { unsigned char v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aUc_Ul_F { unsigned char v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aUc_Ul_I { unsigned char v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aUc_Ul_Ip { unsigned char v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aUc_Ul_L { unsigned char v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aUc_Ul_S { unsigned char v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aUc_Ul_Uc { unsigned char v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aUc_Ul_Ui { unsigned char v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aUc_Ul_Ul { unsigned char v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_Ul_Us { unsigned char v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aUc_Ul_Vp { unsigned char v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aUc_Us { unsigned char v1; unsigned short v2; };
struct __attribute__((packed)) aUc_Us_BFu15i { unsigned char v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_Us_BFu15ll { unsigned char v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_Us_BFu15s { unsigned char v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_Us_BFu16i { unsigned char v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_Us_BFu16ll { unsigned char v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_Us_BFu16s { unsigned char v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_Us_BFu17i { unsigned char v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_Us_BFu17ll { unsigned char v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_Us_BFu1c { unsigned char v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_Us_BFu1i { unsigned char v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_Us_BFu1ll { unsigned char v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_Us_BFu1s { unsigned char v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_Us_BFu31i { unsigned char v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_Us_BFu31ll { unsigned char v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_Us_BFu32i { unsigned char v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_Us_BFu32ll { unsigned char v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_Us_BFu33 { unsigned char v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_Us_BFu7c { unsigned char v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_Us_BFu7i { unsigned char v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_Us_BFu7ll { unsigned char v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_Us_BFu7s { unsigned char v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_Us_BFu8c { unsigned char v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_Us_BFu8i { unsigned char v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_Us_BFu8ll { unsigned char v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_Us_BFu8s { unsigned char v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_Us_BFu9i { unsigned char v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_Us_BFu9ll { unsigned char v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_Us_BFu9s { unsigned char v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_Us_C { unsigned char v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aUc_Us_D { unsigned char v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aUc_Us_F { unsigned char v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aUc_Us_I { unsigned char v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aUc_Us_Ip { unsigned char v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aUc_Us_L { unsigned char v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aUc_Us_S { unsigned char v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aUc_Us_Uc { unsigned char v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aUc_Us_Ui { unsigned char v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aUc_Us_Ul { unsigned char v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_Us_Us { unsigned char v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aUc_Us_Vp { unsigned char v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aUc_Vp { unsigned char v1; void * v2; };
struct __attribute__((packed)) aUc_Vp_BFu15i { unsigned char v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_Vp_BFu15ll { unsigned char v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_Vp_BFu15s { unsigned char v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_Vp_BFu16i { unsigned char v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_Vp_BFu16ll { unsigned char v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_Vp_BFu16s { unsigned char v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_Vp_BFu17i { unsigned char v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_Vp_BFu17ll { unsigned char v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_Vp_BFu1c { unsigned char v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_Vp_BFu1i { unsigned char v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_Vp_BFu1ll { unsigned char v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_Vp_BFu1s { unsigned char v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_Vp_BFu31i { unsigned char v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_Vp_BFu31ll { unsigned char v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_Vp_BFu32i { unsigned char v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_Vp_BFu32ll { unsigned char v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_Vp_BFu33 { unsigned char v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_Vp_BFu7c { unsigned char v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_Vp_BFu7i { unsigned char v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_Vp_BFu7ll { unsigned char v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_Vp_BFu7s { unsigned char v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_Vp_BFu8c { unsigned char v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_Vp_BFu8i { unsigned char v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_Vp_BFu8ll { unsigned char v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_Vp_BFu8s { unsigned char v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_Vp_BFu9i { unsigned char v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_Vp_BFu9ll { unsigned char v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_Vp_BFu9s { unsigned char v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_Vp_C { unsigned char v1; void * v2; char v3; };
struct __attribute__((packed)) aUc_Vp_D { unsigned char v1; void * v2; double v3; };
struct __attribute__((packed)) aUc_Vp_F { unsigned char v1; void * v2; float v3; };
struct __attribute__((packed)) aUc_Vp_I { unsigned char v1; void * v2; int v3; };
struct __attribute__((packed)) aUc_Vp_Ip { unsigned char v1; void * v2; int * v3; };
struct __attribute__((packed)) aUc_Vp_L { unsigned char v1; void * v2; long long v3; };
struct __attribute__((packed)) aUc_Vp_S { unsigned char v1; void * v2; short v3; };
struct __attribute__((packed)) aUc_Vp_Uc { unsigned char v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aUc_Vp_Ui { unsigned char v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aUc_Vp_Ul { unsigned char v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_Vp_Us { unsigned char v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aUc_Vp_Vp { unsigned char v1; void * v2; void * v3; };
struct __attribute__((packed)) aUi { unsigned int v1; };
struct __attribute__((packed)) aUi_BFu15i { unsigned int v1; unsigned int v2:15; };
struct __attribute__((packed)) aUi_BFu15i_BFu15i { unsigned int v1; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu15i_BFu15ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu15i_BFu15s { unsigned int v1; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu15i_BFu16i { unsigned int v1; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu15i_BFu16ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu15i_BFu16s { unsigned int v1; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu15i_BFu17i { unsigned int v1; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu15i_BFu17ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu15i_BFu1c { unsigned int v1; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu15i_BFu1i { unsigned int v1; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu15i_BFu1ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu15i_BFu1s { unsigned int v1; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu15i_BFu31i { unsigned int v1; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu15i_BFu31ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu15i_BFu32i { unsigned int v1; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu15i_BFu32ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu15i_BFu33 { unsigned int v1; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu15i_BFu7c { unsigned int v1; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu15i_BFu7i { unsigned int v1; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu15i_BFu7ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu15i_BFu7s { unsigned int v1; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu15i_BFu8c { unsigned int v1; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu15i_BFu8i { unsigned int v1; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu15i_BFu8ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu15i_BFu8s { unsigned int v1; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu15i_BFu9i { unsigned int v1; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu15i_BFu9ll { unsigned int v1; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu15i_BFu9s { unsigned int v1; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu15i_C { unsigned int v1; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aUi_BFu15i_D { unsigned int v1; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aUi_BFu15i_F { unsigned int v1; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aUi_BFu15i_I { unsigned int v1; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aUi_BFu15i_Ip { unsigned int v1; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aUi_BFu15i_L { unsigned int v1; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aUi_BFu15i_S { unsigned int v1; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aUi_BFu15i_Uc { unsigned int v1; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu15i_Ui { unsigned int v1; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu15i_Ul { unsigned int v1; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu15i_Us { unsigned int v1; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu15i_Vp { unsigned int v1; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aUi_BFu15ll { unsigned int v1; unsigned long long v2:15; };
struct __attribute__((packed)) aUi_BFu15ll_BFu15i { unsigned int v1; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu15ll_BFu15ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu15ll_BFu15s { unsigned int v1; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu15ll_BFu16i { unsigned int v1; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu15ll_BFu16ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu15ll_BFu16s { unsigned int v1; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu15ll_BFu17i { unsigned int v1; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu15ll_BFu17ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu15ll_BFu1c { unsigned int v1; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu15ll_BFu1i { unsigned int v1; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu15ll_BFu1ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu15ll_BFu1s { unsigned int v1; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu15ll_BFu31i { unsigned int v1; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu15ll_BFu31ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu15ll_BFu32i { unsigned int v1; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu15ll_BFu32ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu15ll_BFu33 { unsigned int v1; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu15ll_BFu7c { unsigned int v1; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu15ll_BFu7i { unsigned int v1; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu15ll_BFu7ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu15ll_BFu7s { unsigned int v1; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu15ll_BFu8c { unsigned int v1; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu15ll_BFu8i { unsigned int v1; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu15ll_BFu8ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu15ll_BFu8s { unsigned int v1; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu15ll_BFu9i { unsigned int v1; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu15ll_BFu9ll { unsigned int v1; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu15ll_BFu9s { unsigned int v1; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu15ll_C { unsigned int v1; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aUi_BFu15ll_D { unsigned int v1; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aUi_BFu15ll_F { unsigned int v1; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aUi_BFu15ll_I { unsigned int v1; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aUi_BFu15ll_Ip { unsigned int v1; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aUi_BFu15ll_L { unsigned int v1; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aUi_BFu15ll_S { unsigned int v1; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aUi_BFu15ll_Uc { unsigned int v1; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu15ll_Ui { unsigned int v1; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu15ll_Ul { unsigned int v1; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu15ll_Us { unsigned int v1; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu15ll_Vp { unsigned int v1; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aUi_BFu15s { unsigned int v1; unsigned short v2:15; };
struct __attribute__((packed)) aUi_BFu15s_BFu15i { unsigned int v1; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu15s_BFu15ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu15s_BFu15s { unsigned int v1; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu15s_BFu16i { unsigned int v1; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu15s_BFu16ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu15s_BFu16s { unsigned int v1; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu15s_BFu17i { unsigned int v1; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu15s_BFu17ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu15s_BFu1c { unsigned int v1; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu15s_BFu1i { unsigned int v1; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu15s_BFu1ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu15s_BFu1s { unsigned int v1; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu15s_BFu31i { unsigned int v1; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu15s_BFu31ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu15s_BFu32i { unsigned int v1; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu15s_BFu32ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu15s_BFu33 { unsigned int v1; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu15s_BFu7c { unsigned int v1; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu15s_BFu7i { unsigned int v1; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu15s_BFu7ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu15s_BFu7s { unsigned int v1; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu15s_BFu8c { unsigned int v1; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu15s_BFu8i { unsigned int v1; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu15s_BFu8ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu15s_BFu8s { unsigned int v1; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu15s_BFu9i { unsigned int v1; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu15s_BFu9ll { unsigned int v1; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu15s_BFu9s { unsigned int v1; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu15s_C { unsigned int v1; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aUi_BFu15s_D { unsigned int v1; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aUi_BFu15s_F { unsigned int v1; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aUi_BFu15s_I { unsigned int v1; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aUi_BFu15s_Ip { unsigned int v1; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aUi_BFu15s_L { unsigned int v1; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aUi_BFu15s_S { unsigned int v1; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aUi_BFu15s_Uc { unsigned int v1; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu15s_Ui { unsigned int v1; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu15s_Ul { unsigned int v1; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu15s_Us { unsigned int v1; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu15s_Vp { unsigned int v1; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aUi_BFu16i { unsigned int v1; unsigned int v2:16; };
struct __attribute__((packed)) aUi_BFu16i_BFu15i { unsigned int v1; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu16i_BFu15ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu16i_BFu15s { unsigned int v1; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu16i_BFu16i { unsigned int v1; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu16i_BFu16ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu16i_BFu16s { unsigned int v1; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu16i_BFu17i { unsigned int v1; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu16i_BFu17ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu16i_BFu1c { unsigned int v1; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu16i_BFu1i { unsigned int v1; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu16i_BFu1ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu16i_BFu1s { unsigned int v1; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu16i_BFu31i { unsigned int v1; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu16i_BFu31ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu16i_BFu32i { unsigned int v1; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu16i_BFu32ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu16i_BFu33 { unsigned int v1; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu16i_BFu7c { unsigned int v1; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu16i_BFu7i { unsigned int v1; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu16i_BFu7ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu16i_BFu7s { unsigned int v1; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu16i_BFu8c { unsigned int v1; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu16i_BFu8i { unsigned int v1; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu16i_BFu8ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu16i_BFu8s { unsigned int v1; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu16i_BFu9i { unsigned int v1; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu16i_BFu9ll { unsigned int v1; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu16i_BFu9s { unsigned int v1; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu16i_C { unsigned int v1; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aUi_BFu16i_D { unsigned int v1; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aUi_BFu16i_F { unsigned int v1; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aUi_BFu16i_I { unsigned int v1; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aUi_BFu16i_Ip { unsigned int v1; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aUi_BFu16i_L { unsigned int v1; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aUi_BFu16i_S { unsigned int v1; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aUi_BFu16i_Uc { unsigned int v1; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu16i_Ui { unsigned int v1; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu16i_Ul { unsigned int v1; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu16i_Us { unsigned int v1; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu16i_Vp { unsigned int v1; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aUi_BFu16ll { unsigned int v1; unsigned long long v2:16; };
struct __attribute__((packed)) aUi_BFu16ll_BFu15i { unsigned int v1; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu16ll_BFu15ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu16ll_BFu15s { unsigned int v1; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu16ll_BFu16i { unsigned int v1; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu16ll_BFu16ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu16ll_BFu16s { unsigned int v1; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu16ll_BFu17i { unsigned int v1; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu16ll_BFu17ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu16ll_BFu1c { unsigned int v1; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu16ll_BFu1i { unsigned int v1; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu16ll_BFu1ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu16ll_BFu1s { unsigned int v1; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu16ll_BFu31i { unsigned int v1; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu16ll_BFu31ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu16ll_BFu32i { unsigned int v1; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu16ll_BFu32ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu16ll_BFu33 { unsigned int v1; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu16ll_BFu7c { unsigned int v1; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu16ll_BFu7i { unsigned int v1; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu16ll_BFu7ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu16ll_BFu7s { unsigned int v1; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu16ll_BFu8c { unsigned int v1; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu16ll_BFu8i { unsigned int v1; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu16ll_BFu8ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu16ll_BFu8s { unsigned int v1; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu16ll_BFu9i { unsigned int v1; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu16ll_BFu9ll { unsigned int v1; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu16ll_BFu9s { unsigned int v1; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu16ll_C { unsigned int v1; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aUi_BFu16ll_D { unsigned int v1; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aUi_BFu16ll_F { unsigned int v1; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aUi_BFu16ll_I { unsigned int v1; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aUi_BFu16ll_Ip { unsigned int v1; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aUi_BFu16ll_L { unsigned int v1; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aUi_BFu16ll_S { unsigned int v1; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aUi_BFu16ll_Uc { unsigned int v1; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu16ll_Ui { unsigned int v1; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu16ll_Ul { unsigned int v1; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu16ll_Us { unsigned int v1; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu16ll_Vp { unsigned int v1; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aUi_BFu16s { unsigned int v1; unsigned short v2:16; };
struct __attribute__((packed)) aUi_BFu16s_BFu15i { unsigned int v1; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu16s_BFu15ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu16s_BFu15s { unsigned int v1; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu16s_BFu16i { unsigned int v1; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu16s_BFu16ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu16s_BFu16s { unsigned int v1; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu16s_BFu17i { unsigned int v1; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu16s_BFu17ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu16s_BFu1c { unsigned int v1; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu16s_BFu1i { unsigned int v1; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu16s_BFu1ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu16s_BFu1s { unsigned int v1; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu16s_BFu31i { unsigned int v1; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu16s_BFu31ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu16s_BFu32i { unsigned int v1; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu16s_BFu32ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu16s_BFu33 { unsigned int v1; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu16s_BFu7c { unsigned int v1; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu16s_BFu7i { unsigned int v1; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu16s_BFu7ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu16s_BFu7s { unsigned int v1; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu16s_BFu8c { unsigned int v1; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu16s_BFu8i { unsigned int v1; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu16s_BFu8ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu16s_BFu8s { unsigned int v1; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu16s_BFu9i { unsigned int v1; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu16s_BFu9ll { unsigned int v1; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu16s_BFu9s { unsigned int v1; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu16s_C { unsigned int v1; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aUi_BFu16s_D { unsigned int v1; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aUi_BFu16s_F { unsigned int v1; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aUi_BFu16s_I { unsigned int v1; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aUi_BFu16s_Ip { unsigned int v1; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aUi_BFu16s_L { unsigned int v1; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aUi_BFu16s_S { unsigned int v1; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aUi_BFu16s_Uc { unsigned int v1; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu16s_Ui { unsigned int v1; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu16s_Ul { unsigned int v1; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu16s_Us { unsigned int v1; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu16s_Vp { unsigned int v1; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aUi_BFu17i { unsigned int v1; unsigned int v2:17; };
struct __attribute__((packed)) aUi_BFu17i_BFu15i { unsigned int v1; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu17i_BFu15ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu17i_BFu15s { unsigned int v1; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu17i_BFu16i { unsigned int v1; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu17i_BFu16ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu17i_BFu16s { unsigned int v1; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu17i_BFu17i { unsigned int v1; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu17i_BFu17ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu17i_BFu1c { unsigned int v1; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu17i_BFu1i { unsigned int v1; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu17i_BFu1ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu17i_BFu1s { unsigned int v1; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu17i_BFu31i { unsigned int v1; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu17i_BFu31ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu17i_BFu32i { unsigned int v1; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu17i_BFu32ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu17i_BFu33 { unsigned int v1; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu17i_BFu7c { unsigned int v1; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu17i_BFu7i { unsigned int v1; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu17i_BFu7ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu17i_BFu7s { unsigned int v1; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu17i_BFu8c { unsigned int v1; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu17i_BFu8i { unsigned int v1; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu17i_BFu8ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu17i_BFu8s { unsigned int v1; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu17i_BFu9i { unsigned int v1; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu17i_BFu9ll { unsigned int v1; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu17i_BFu9s { unsigned int v1; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu17i_C { unsigned int v1; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aUi_BFu17i_D { unsigned int v1; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aUi_BFu17i_F { unsigned int v1; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aUi_BFu17i_I { unsigned int v1; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aUi_BFu17i_Ip { unsigned int v1; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aUi_BFu17i_L { unsigned int v1; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aUi_BFu17i_S { unsigned int v1; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aUi_BFu17i_Uc { unsigned int v1; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu17i_Ui { unsigned int v1; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu17i_Ul { unsigned int v1; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu17i_Us { unsigned int v1; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu17i_Vp { unsigned int v1; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aUi_BFu17ll { unsigned int v1; unsigned long long v2:17; };
struct __attribute__((packed)) aUi_BFu17ll_BFu15i { unsigned int v1; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu17ll_BFu15ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu17ll_BFu15s { unsigned int v1; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu17ll_BFu16i { unsigned int v1; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu17ll_BFu16ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu17ll_BFu16s { unsigned int v1; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu17ll_BFu17i { unsigned int v1; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu17ll_BFu17ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu17ll_BFu1c { unsigned int v1; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu17ll_BFu1i { unsigned int v1; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu17ll_BFu1ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu17ll_BFu1s { unsigned int v1; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu17ll_BFu31i { unsigned int v1; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu17ll_BFu31ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu17ll_BFu32i { unsigned int v1; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu17ll_BFu32ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu17ll_BFu33 { unsigned int v1; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu17ll_BFu7c { unsigned int v1; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu17ll_BFu7i { unsigned int v1; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu17ll_BFu7ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu17ll_BFu7s { unsigned int v1; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu17ll_BFu8c { unsigned int v1; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu17ll_BFu8i { unsigned int v1; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu17ll_BFu8ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu17ll_BFu8s { unsigned int v1; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu17ll_BFu9i { unsigned int v1; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu17ll_BFu9ll { unsigned int v1; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu17ll_BFu9s { unsigned int v1; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu17ll_C { unsigned int v1; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aUi_BFu17ll_D { unsigned int v1; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aUi_BFu17ll_F { unsigned int v1; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aUi_BFu17ll_I { unsigned int v1; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aUi_BFu17ll_Ip { unsigned int v1; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aUi_BFu17ll_L { unsigned int v1; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aUi_BFu17ll_S { unsigned int v1; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aUi_BFu17ll_Uc { unsigned int v1; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu17ll_Ui { unsigned int v1; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu17ll_Ul { unsigned int v1; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu17ll_Us { unsigned int v1; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu17ll_Vp { unsigned int v1; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aUi_BFu1c { unsigned int v1; unsigned char v2:1; };
struct __attribute__((packed)) aUi_BFu1c_BFu15i { unsigned int v1; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu1c_BFu15ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu1c_BFu15s { unsigned int v1; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu1c_BFu16i { unsigned int v1; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu1c_BFu16ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu1c_BFu16s { unsigned int v1; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu1c_BFu17i { unsigned int v1; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu1c_BFu17ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu1c_BFu1c { unsigned int v1; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu1c_BFu1i { unsigned int v1; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu1c_BFu1ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu1c_BFu1s { unsigned int v1; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu1c_BFu31i { unsigned int v1; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu1c_BFu31ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu1c_BFu32i { unsigned int v1; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu1c_BFu32ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu1c_BFu33 { unsigned int v1; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu1c_BFu7c { unsigned int v1; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu1c_BFu7i { unsigned int v1; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu1c_BFu7ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu1c_BFu7s { unsigned int v1; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu1c_BFu8c { unsigned int v1; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu1c_BFu8i { unsigned int v1; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu1c_BFu8ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu1c_BFu8s { unsigned int v1; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu1c_BFu9i { unsigned int v1; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu1c_BFu9ll { unsigned int v1; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu1c_BFu9s { unsigned int v1; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu1c_C { unsigned int v1; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aUi_BFu1c_D { unsigned int v1; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aUi_BFu1c_F { unsigned int v1; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aUi_BFu1c_I { unsigned int v1; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aUi_BFu1c_Ip { unsigned int v1; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aUi_BFu1c_L { unsigned int v1; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aUi_BFu1c_S { unsigned int v1; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aUi_BFu1c_Uc { unsigned int v1; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu1c_Ui { unsigned int v1; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu1c_Ul { unsigned int v1; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu1c_Us { unsigned int v1; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu1c_Vp { unsigned int v1; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aUi_BFu1i { unsigned int v1; unsigned int v2:1; };
struct __attribute__((packed)) aUi_BFu1i_BFu15i { unsigned int v1; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu1i_BFu15ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu1i_BFu15s { unsigned int v1; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu1i_BFu16i { unsigned int v1; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu1i_BFu16ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu1i_BFu16s { unsigned int v1; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu1i_BFu17i { unsigned int v1; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu1i_BFu17ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu1i_BFu1c { unsigned int v1; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu1i_BFu1i { unsigned int v1; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu1i_BFu1ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu1i_BFu1s { unsigned int v1; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu1i_BFu31i { unsigned int v1; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu1i_BFu31ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu1i_BFu32i { unsigned int v1; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu1i_BFu32ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu1i_BFu33 { unsigned int v1; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu1i_BFu7c { unsigned int v1; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu1i_BFu7i { unsigned int v1; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu1i_BFu7ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu1i_BFu7s { unsigned int v1; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu1i_BFu8c { unsigned int v1; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu1i_BFu8i { unsigned int v1; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu1i_BFu8ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu1i_BFu8s { unsigned int v1; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu1i_BFu9i { unsigned int v1; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu1i_BFu9ll { unsigned int v1; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu1i_BFu9s { unsigned int v1; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu1i_C { unsigned int v1; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aUi_BFu1i_D { unsigned int v1; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aUi_BFu1i_F { unsigned int v1; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aUi_BFu1i_I { unsigned int v1; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aUi_BFu1i_Ip { unsigned int v1; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aUi_BFu1i_L { unsigned int v1; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aUi_BFu1i_S { unsigned int v1; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aUi_BFu1i_Uc { unsigned int v1; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu1i_Ui { unsigned int v1; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu1i_Ul { unsigned int v1; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu1i_Us { unsigned int v1; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu1i_Vp { unsigned int v1; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aUi_BFu1ll { unsigned int v1; unsigned long long v2:1; };
struct __attribute__((packed)) aUi_BFu1ll_BFu15i { unsigned int v1; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu1ll_BFu15ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu1ll_BFu15s { unsigned int v1; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu1ll_BFu16i { unsigned int v1; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu1ll_BFu16ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu1ll_BFu16s { unsigned int v1; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu1ll_BFu17i { unsigned int v1; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu1ll_BFu17ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu1ll_BFu1c { unsigned int v1; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu1ll_BFu1i { unsigned int v1; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu1ll_BFu1ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu1ll_BFu1s { unsigned int v1; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu1ll_BFu31i { unsigned int v1; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu1ll_BFu31ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu1ll_BFu32i { unsigned int v1; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu1ll_BFu32ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu1ll_BFu33 { unsigned int v1; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu1ll_BFu7c { unsigned int v1; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu1ll_BFu7i { unsigned int v1; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu1ll_BFu7ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu1ll_BFu7s { unsigned int v1; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu1ll_BFu8c { unsigned int v1; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu1ll_BFu8i { unsigned int v1; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu1ll_BFu8ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu1ll_BFu8s { unsigned int v1; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu1ll_BFu9i { unsigned int v1; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu1ll_BFu9ll { unsigned int v1; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu1ll_BFu9s { unsigned int v1; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu1ll_C { unsigned int v1; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aUi_BFu1ll_D { unsigned int v1; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aUi_BFu1ll_F { unsigned int v1; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aUi_BFu1ll_I { unsigned int v1; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aUi_BFu1ll_Ip { unsigned int v1; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aUi_BFu1ll_L { unsigned int v1; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aUi_BFu1ll_S { unsigned int v1; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aUi_BFu1ll_Uc { unsigned int v1; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu1ll_Ui { unsigned int v1; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu1ll_Ul { unsigned int v1; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu1ll_Us { unsigned int v1; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu1ll_Vp { unsigned int v1; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aUi_BFu1s { unsigned int v1; unsigned short v2:1; };
struct __attribute__((packed)) aUi_BFu1s_BFu15i { unsigned int v1; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu1s_BFu15ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu1s_BFu15s { unsigned int v1; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu1s_BFu16i { unsigned int v1; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu1s_BFu16ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu1s_BFu16s { unsigned int v1; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu1s_BFu17i { unsigned int v1; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu1s_BFu17ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu1s_BFu1c { unsigned int v1; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu1s_BFu1i { unsigned int v1; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu1s_BFu1ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu1s_BFu1s { unsigned int v1; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu1s_BFu31i { unsigned int v1; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu1s_BFu31ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu1s_BFu32i { unsigned int v1; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu1s_BFu32ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu1s_BFu33 { unsigned int v1; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu1s_BFu7c { unsigned int v1; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu1s_BFu7i { unsigned int v1; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu1s_BFu7ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu1s_BFu7s { unsigned int v1; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu1s_BFu8c { unsigned int v1; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu1s_BFu8i { unsigned int v1; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu1s_BFu8ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu1s_BFu8s { unsigned int v1; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu1s_BFu9i { unsigned int v1; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu1s_BFu9ll { unsigned int v1; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu1s_BFu9s { unsigned int v1; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu1s_C { unsigned int v1; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aUi_BFu1s_D { unsigned int v1; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aUi_BFu1s_F { unsigned int v1; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aUi_BFu1s_I { unsigned int v1; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aUi_BFu1s_Ip { unsigned int v1; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aUi_BFu1s_L { unsigned int v1; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aUi_BFu1s_S { unsigned int v1; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aUi_BFu1s_Uc { unsigned int v1; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu1s_Ui { unsigned int v1; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu1s_Ul { unsigned int v1; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu1s_Us { unsigned int v1; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu1s_Vp { unsigned int v1; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aUi_BFu31i { unsigned int v1; unsigned int v2:31; };
struct __attribute__((packed)) aUi_BFu31i_BFu15i { unsigned int v1; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu31i_BFu15ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu31i_BFu15s { unsigned int v1; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu31i_BFu16i { unsigned int v1; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu31i_BFu16ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu31i_BFu16s { unsigned int v1; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu31i_BFu17i { unsigned int v1; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu31i_BFu17ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu31i_BFu1c { unsigned int v1; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu31i_BFu1i { unsigned int v1; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu31i_BFu1ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu31i_BFu1s { unsigned int v1; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu31i_BFu31i { unsigned int v1; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu31i_BFu31ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu31i_BFu32i { unsigned int v1; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu31i_BFu32ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu31i_BFu33 { unsigned int v1; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu31i_BFu7c { unsigned int v1; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu31i_BFu7i { unsigned int v1; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu31i_BFu7ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu31i_BFu7s { unsigned int v1; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu31i_BFu8c { unsigned int v1; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu31i_BFu8i { unsigned int v1; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu31i_BFu8ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu31i_BFu8s { unsigned int v1; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu31i_BFu9i { unsigned int v1; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu31i_BFu9ll { unsigned int v1; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu31i_BFu9s { unsigned int v1; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu31i_C { unsigned int v1; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aUi_BFu31i_D { unsigned int v1; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aUi_BFu31i_F { unsigned int v1; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aUi_BFu31i_I { unsigned int v1; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aUi_BFu31i_Ip { unsigned int v1; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aUi_BFu31i_L { unsigned int v1; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aUi_BFu31i_S { unsigned int v1; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aUi_BFu31i_Uc { unsigned int v1; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu31i_Ui { unsigned int v1; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu31i_Ul { unsigned int v1; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu31i_Us { unsigned int v1; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu31i_Vp { unsigned int v1; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aUi_BFu31ll { unsigned int v1; unsigned long long v2:31; };
struct __attribute__((packed)) aUi_BFu31ll_BFu15i { unsigned int v1; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu31ll_BFu15ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu31ll_BFu15s { unsigned int v1; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu31ll_BFu16i { unsigned int v1; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu31ll_BFu16ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu31ll_BFu16s { unsigned int v1; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu31ll_BFu17i { unsigned int v1; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu31ll_BFu17ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu31ll_BFu1c { unsigned int v1; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu31ll_BFu1i { unsigned int v1; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu31ll_BFu1ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu31ll_BFu1s { unsigned int v1; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu31ll_BFu31i { unsigned int v1; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu31ll_BFu31ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu31ll_BFu32i { unsigned int v1; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu31ll_BFu32ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu31ll_BFu33 { unsigned int v1; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu31ll_BFu7c { unsigned int v1; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu31ll_BFu7i { unsigned int v1; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu31ll_BFu7ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu31ll_BFu7s { unsigned int v1; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu31ll_BFu8c { unsigned int v1; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu31ll_BFu8i { unsigned int v1; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu31ll_BFu8ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu31ll_BFu8s { unsigned int v1; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu31ll_BFu9i { unsigned int v1; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu31ll_BFu9ll { unsigned int v1; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu31ll_BFu9s { unsigned int v1; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu31ll_C { unsigned int v1; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aUi_BFu31ll_D { unsigned int v1; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aUi_BFu31ll_F { unsigned int v1; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aUi_BFu31ll_I { unsigned int v1; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aUi_BFu31ll_Ip { unsigned int v1; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aUi_BFu31ll_L { unsigned int v1; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aUi_BFu31ll_S { unsigned int v1; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aUi_BFu31ll_Uc { unsigned int v1; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu31ll_Ui { unsigned int v1; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu31ll_Ul { unsigned int v1; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu31ll_Us { unsigned int v1; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu31ll_Vp { unsigned int v1; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aUi_BFu32i { unsigned int v1; unsigned int v2:32; };
struct __attribute__((packed)) aUi_BFu32i_BFu15i { unsigned int v1; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu32i_BFu15ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu32i_BFu15s { unsigned int v1; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu32i_BFu16i { unsigned int v1; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu32i_BFu16ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu32i_BFu16s { unsigned int v1; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu32i_BFu17i { unsigned int v1; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu32i_BFu17ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu32i_BFu1c { unsigned int v1; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu32i_BFu1i { unsigned int v1; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu32i_BFu1ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu32i_BFu1s { unsigned int v1; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu32i_BFu31i { unsigned int v1; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu32i_BFu31ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu32i_BFu32i { unsigned int v1; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu32i_BFu32ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu32i_BFu33 { unsigned int v1; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu32i_BFu7c { unsigned int v1; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu32i_BFu7i { unsigned int v1; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu32i_BFu7ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu32i_BFu7s { unsigned int v1; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu32i_BFu8c { unsigned int v1; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu32i_BFu8i { unsigned int v1; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu32i_BFu8ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu32i_BFu8s { unsigned int v1; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu32i_BFu9i { unsigned int v1; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu32i_BFu9ll { unsigned int v1; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu32i_BFu9s { unsigned int v1; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu32i_C { unsigned int v1; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aUi_BFu32i_D { unsigned int v1; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aUi_BFu32i_F { unsigned int v1; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aUi_BFu32i_I { unsigned int v1; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aUi_BFu32i_Ip { unsigned int v1; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aUi_BFu32i_L { unsigned int v1; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aUi_BFu32i_S { unsigned int v1; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aUi_BFu32i_Uc { unsigned int v1; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu32i_Ui { unsigned int v1; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu32i_Ul { unsigned int v1; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu32i_Us { unsigned int v1; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu32i_Vp { unsigned int v1; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aUi_BFu32ll { unsigned int v1; unsigned long long v2:32; };
struct __attribute__((packed)) aUi_BFu32ll_BFu15i { unsigned int v1; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu32ll_BFu15ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu32ll_BFu15s { unsigned int v1; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu32ll_BFu16i { unsigned int v1; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu32ll_BFu16ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu32ll_BFu16s { unsigned int v1; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu32ll_BFu17i { unsigned int v1; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu32ll_BFu17ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu32ll_BFu1c { unsigned int v1; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu32ll_BFu1i { unsigned int v1; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu32ll_BFu1ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu32ll_BFu1s { unsigned int v1; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu32ll_BFu31i { unsigned int v1; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu32ll_BFu31ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu32ll_BFu32i { unsigned int v1; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu32ll_BFu32ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu32ll_BFu33 { unsigned int v1; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu32ll_BFu7c { unsigned int v1; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu32ll_BFu7i { unsigned int v1; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu32ll_BFu7ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu32ll_BFu7s { unsigned int v1; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu32ll_BFu8c { unsigned int v1; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu32ll_BFu8i { unsigned int v1; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu32ll_BFu8ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu32ll_BFu8s { unsigned int v1; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu32ll_BFu9i { unsigned int v1; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu32ll_BFu9ll { unsigned int v1; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu32ll_BFu9s { unsigned int v1; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu32ll_C { unsigned int v1; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aUi_BFu32ll_D { unsigned int v1; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aUi_BFu32ll_F { unsigned int v1; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aUi_BFu32ll_I { unsigned int v1; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aUi_BFu32ll_Ip { unsigned int v1; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aUi_BFu32ll_L { unsigned int v1; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aUi_BFu32ll_S { unsigned int v1; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aUi_BFu32ll_Uc { unsigned int v1; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu32ll_Ui { unsigned int v1; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu32ll_Ul { unsigned int v1; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu32ll_Us { unsigned int v1; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu32ll_Vp { unsigned int v1; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aUi_BFu33 { unsigned int v1; unsigned long long v2:33; };
struct __attribute__((packed)) aUi_BFu33_BFu15i { unsigned int v1; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu33_BFu15ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu33_BFu15s { unsigned int v1; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu33_BFu16i { unsigned int v1; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu33_BFu16ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu33_BFu16s { unsigned int v1; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu33_BFu17i { unsigned int v1; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu33_BFu17ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu33_BFu1c { unsigned int v1; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu33_BFu1i { unsigned int v1; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu33_BFu1ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu33_BFu1s { unsigned int v1; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu33_BFu31i { unsigned int v1; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu33_BFu31ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu33_BFu32i { unsigned int v1; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu33_BFu32ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu33_BFu33 { unsigned int v1; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu33_BFu7c { unsigned int v1; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu33_BFu7i { unsigned int v1; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu33_BFu7ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu33_BFu7s { unsigned int v1; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu33_BFu8c { unsigned int v1; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu33_BFu8i { unsigned int v1; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu33_BFu8ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu33_BFu8s { unsigned int v1; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu33_BFu9i { unsigned int v1; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu33_BFu9ll { unsigned int v1; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu33_BFu9s { unsigned int v1; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu33_C { unsigned int v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aUi_BFu33_D { unsigned int v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aUi_BFu33_F { unsigned int v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aUi_BFu33_I { unsigned int v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aUi_BFu33_Ip { unsigned int v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aUi_BFu33_L { unsigned int v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aUi_BFu33_S { unsigned int v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aUi_BFu33_Uc { unsigned int v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu33_Ui { unsigned int v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu33_Ul { unsigned int v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu33_Us { unsigned int v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu33_Vp { unsigned int v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aUi_BFu7c { unsigned int v1; unsigned char v2:7; };
struct __attribute__((packed)) aUi_BFu7c_BFu15i { unsigned int v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu7c_BFu15ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu7c_BFu15s { unsigned int v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu7c_BFu16i { unsigned int v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu7c_BFu16ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu7c_BFu16s { unsigned int v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu7c_BFu17i { unsigned int v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu7c_BFu17ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu7c_BFu1c { unsigned int v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu7c_BFu1i { unsigned int v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu7c_BFu1ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu7c_BFu1s { unsigned int v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu7c_BFu31i { unsigned int v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu7c_BFu31ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu7c_BFu32i { unsigned int v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu7c_BFu32ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu7c_BFu33 { unsigned int v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu7c_BFu7c { unsigned int v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu7c_BFu7i { unsigned int v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu7c_BFu7ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu7c_BFu7s { unsigned int v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu7c_BFu8c { unsigned int v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu7c_BFu8i { unsigned int v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu7c_BFu8ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu7c_BFu8s { unsigned int v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu7c_BFu9i { unsigned int v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu7c_BFu9ll { unsigned int v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu7c_BFu9s { unsigned int v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu7c_C { unsigned int v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aUi_BFu7c_D { unsigned int v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aUi_BFu7c_F { unsigned int v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aUi_BFu7c_I { unsigned int v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aUi_BFu7c_Ip { unsigned int v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aUi_BFu7c_L { unsigned int v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aUi_BFu7c_S { unsigned int v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aUi_BFu7c_Uc { unsigned int v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu7c_Ui { unsigned int v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu7c_Ul { unsigned int v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu7c_Us { unsigned int v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu7c_Vp { unsigned int v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aUi_BFu7i { unsigned int v1; unsigned int v2:7; };
struct __attribute__((packed)) aUi_BFu7i_BFu15i { unsigned int v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu7i_BFu15ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu7i_BFu15s { unsigned int v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu7i_BFu16i { unsigned int v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu7i_BFu16ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu7i_BFu16s { unsigned int v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu7i_BFu17i { unsigned int v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu7i_BFu17ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu7i_BFu1c { unsigned int v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu7i_BFu1i { unsigned int v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu7i_BFu1ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu7i_BFu1s { unsigned int v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu7i_BFu31i { unsigned int v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu7i_BFu31ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu7i_BFu32i { unsigned int v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu7i_BFu32ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu7i_BFu33 { unsigned int v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu7i_BFu7c { unsigned int v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu7i_BFu7i { unsigned int v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu7i_BFu7ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu7i_BFu7s { unsigned int v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu7i_BFu8c { unsigned int v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu7i_BFu8i { unsigned int v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu7i_BFu8ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu7i_BFu8s { unsigned int v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu7i_BFu9i { unsigned int v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu7i_BFu9ll { unsigned int v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu7i_BFu9s { unsigned int v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu7i_C { unsigned int v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aUi_BFu7i_D { unsigned int v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aUi_BFu7i_F { unsigned int v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aUi_BFu7i_I { unsigned int v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aUi_BFu7i_Ip { unsigned int v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aUi_BFu7i_L { unsigned int v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aUi_BFu7i_S { unsigned int v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aUi_BFu7i_Uc { unsigned int v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu7i_Ui { unsigned int v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu7i_Ul { unsigned int v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu7i_Us { unsigned int v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu7i_Vp { unsigned int v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aUi_BFu7ll { unsigned int v1; unsigned long long v2:7; };
struct __attribute__((packed)) aUi_BFu7ll_BFu15i { unsigned int v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu7ll_BFu15ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu7ll_BFu15s { unsigned int v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu7ll_BFu16i { unsigned int v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu7ll_BFu16ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu7ll_BFu16s { unsigned int v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu7ll_BFu17i { unsigned int v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu7ll_BFu17ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu7ll_BFu1c { unsigned int v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu7ll_BFu1i { unsigned int v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu7ll_BFu1ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu7ll_BFu1s { unsigned int v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu7ll_BFu31i { unsigned int v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu7ll_BFu31ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu7ll_BFu32i { unsigned int v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu7ll_BFu32ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu7ll_BFu33 { unsigned int v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu7ll_BFu7c { unsigned int v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu7ll_BFu7i { unsigned int v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu7ll_BFu7ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu7ll_BFu7s { unsigned int v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu7ll_BFu8c { unsigned int v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu7ll_BFu8i { unsigned int v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu7ll_BFu8ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu7ll_BFu8s { unsigned int v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu7ll_BFu9i { unsigned int v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu7ll_BFu9ll { unsigned int v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu7ll_BFu9s { unsigned int v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu7ll_C { unsigned int v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aUi_BFu7ll_D { unsigned int v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aUi_BFu7ll_F { unsigned int v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aUi_BFu7ll_I { unsigned int v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aUi_BFu7ll_Ip { unsigned int v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aUi_BFu7ll_L { unsigned int v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aUi_BFu7ll_S { unsigned int v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aUi_BFu7ll_Uc { unsigned int v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu7ll_Ui { unsigned int v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu7ll_Ul { unsigned int v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu7ll_Us { unsigned int v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu7ll_Vp { unsigned int v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aUi_BFu7s { unsigned int v1; unsigned short v2:7; };
struct __attribute__((packed)) aUi_BFu7s_BFu15i { unsigned int v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu7s_BFu15ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu7s_BFu15s { unsigned int v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu7s_BFu16i { unsigned int v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu7s_BFu16ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu7s_BFu16s { unsigned int v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu7s_BFu17i { unsigned int v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu7s_BFu17ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu7s_BFu1c { unsigned int v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu7s_BFu1i { unsigned int v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu7s_BFu1ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu7s_BFu1s { unsigned int v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu7s_BFu31i { unsigned int v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu7s_BFu31ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu7s_BFu32i { unsigned int v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu7s_BFu32ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu7s_BFu33 { unsigned int v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu7s_BFu7c { unsigned int v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu7s_BFu7i { unsigned int v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu7s_BFu7ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu7s_BFu7s { unsigned int v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu7s_BFu8c { unsigned int v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu7s_BFu8i { unsigned int v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu7s_BFu8ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu7s_BFu8s { unsigned int v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu7s_BFu9i { unsigned int v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu7s_BFu9ll { unsigned int v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu7s_BFu9s { unsigned int v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu7s_C { unsigned int v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aUi_BFu7s_D { unsigned int v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aUi_BFu7s_F { unsigned int v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aUi_BFu7s_I { unsigned int v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aUi_BFu7s_Ip { unsigned int v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aUi_BFu7s_L { unsigned int v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aUi_BFu7s_S { unsigned int v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aUi_BFu7s_Uc { unsigned int v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu7s_Ui { unsigned int v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu7s_Ul { unsigned int v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu7s_Us { unsigned int v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu7s_Vp { unsigned int v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aUi_BFu8c { unsigned int v1; unsigned char v2:8; };
struct __attribute__((packed)) aUi_BFu8c_BFu15i { unsigned int v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu8c_BFu15ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu8c_BFu15s { unsigned int v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu8c_BFu16i { unsigned int v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu8c_BFu16ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu8c_BFu16s { unsigned int v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu8c_BFu17i { unsigned int v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu8c_BFu17ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu8c_BFu1c { unsigned int v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu8c_BFu1i { unsigned int v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu8c_BFu1ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu8c_BFu1s { unsigned int v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu8c_BFu31i { unsigned int v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu8c_BFu31ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu8c_BFu32i { unsigned int v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu8c_BFu32ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu8c_BFu33 { unsigned int v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu8c_BFu7c { unsigned int v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu8c_BFu7i { unsigned int v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu8c_BFu7ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu8c_BFu7s { unsigned int v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu8c_BFu8c { unsigned int v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu8c_BFu8i { unsigned int v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu8c_BFu8ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu8c_BFu8s { unsigned int v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu8c_BFu9i { unsigned int v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu8c_BFu9ll { unsigned int v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu8c_BFu9s { unsigned int v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu8c_C { unsigned int v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aUi_BFu8c_D { unsigned int v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aUi_BFu8c_F { unsigned int v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aUi_BFu8c_I { unsigned int v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aUi_BFu8c_Ip { unsigned int v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aUi_BFu8c_L { unsigned int v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aUi_BFu8c_S { unsigned int v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aUi_BFu8c_Uc { unsigned int v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu8c_Ui { unsigned int v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu8c_Ul { unsigned int v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu8c_Us { unsigned int v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu8c_Vp { unsigned int v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aUi_BFu8i { unsigned int v1; unsigned int v2:8; };
struct __attribute__((packed)) aUi_BFu8i_BFu15i { unsigned int v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu8i_BFu15ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu8i_BFu15s { unsigned int v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu8i_BFu16i { unsigned int v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu8i_BFu16ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu8i_BFu16s { unsigned int v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu8i_BFu17i { unsigned int v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu8i_BFu17ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu8i_BFu1c { unsigned int v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu8i_BFu1i { unsigned int v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu8i_BFu1ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu8i_BFu1s { unsigned int v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu8i_BFu31i { unsigned int v1; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu8i_BFu31ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu8i_BFu32i { unsigned int v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu8i_BFu32ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu8i_BFu33 { unsigned int v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu8i_BFu7c { unsigned int v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu8i_BFu7i { unsigned int v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu8i_BFu7ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu8i_BFu7s { unsigned int v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu8i_BFu8c { unsigned int v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu8i_BFu8i { unsigned int v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu8i_BFu8ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu8i_BFu8s { unsigned int v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu8i_BFu9i { unsigned int v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu8i_BFu9ll { unsigned int v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu8i_BFu9s { unsigned int v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu8i_C { unsigned int v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aUi_BFu8i_D { unsigned int v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aUi_BFu8i_F { unsigned int v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aUi_BFu8i_I { unsigned int v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aUi_BFu8i_Ip { unsigned int v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aUi_BFu8i_L { unsigned int v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aUi_BFu8i_S { unsigned int v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aUi_BFu8i_Uc { unsigned int v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu8i_Ui { unsigned int v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu8i_Ul { unsigned int v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu8i_Us { unsigned int v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu8i_Vp { unsigned int v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aUi_BFu8ll { unsigned int v1; unsigned long long v2:8; };
struct __attribute__((packed)) aUi_BFu8ll_BFu15i { unsigned int v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu8ll_BFu15ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu8ll_BFu15s { unsigned int v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu8ll_BFu16i { unsigned int v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu8ll_BFu16ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu8ll_BFu16s { unsigned int v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu8ll_BFu17i { unsigned int v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu8ll_BFu17ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu8ll_BFu1c { unsigned int v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu8ll_BFu1i { unsigned int v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu8ll_BFu1ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu8ll_BFu1s { unsigned int v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu8ll_BFu31i { unsigned int v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu8ll_BFu31ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu8ll_BFu32i { unsigned int v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu8ll_BFu32ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu8ll_BFu33 { unsigned int v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu8ll_BFu7c { unsigned int v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu8ll_BFu7i { unsigned int v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu8ll_BFu7ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu8ll_BFu7s { unsigned int v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu8ll_BFu8c { unsigned int v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu8ll_BFu8i { unsigned int v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu8ll_BFu8ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu8ll_BFu8s { unsigned int v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu8ll_BFu9i { unsigned int v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu8ll_BFu9ll { unsigned int v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu8ll_BFu9s { unsigned int v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu8ll_C { unsigned int v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aUi_BFu8ll_D { unsigned int v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aUi_BFu8ll_F { unsigned int v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aUi_BFu8ll_I { unsigned int v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aUi_BFu8ll_Ip { unsigned int v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aUi_BFu8ll_L { unsigned int v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aUi_BFu8ll_S { unsigned int v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aUi_BFu8ll_Uc { unsigned int v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu8ll_Ui { unsigned int v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu8ll_Ul { unsigned int v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu8ll_Us { unsigned int v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu8ll_Vp { unsigned int v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aUi_BFu8s { unsigned int v1; unsigned short v2:8; };
struct __attribute__((packed)) aUi_BFu8s_BFu15i { unsigned int v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu8s_BFu15ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu8s_BFu15s { unsigned int v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu8s_BFu16i { unsigned int v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu8s_BFu16ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu8s_BFu16s { unsigned int v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu8s_BFu17i { unsigned int v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu8s_BFu17ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu8s_BFu1c { unsigned int v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu8s_BFu1i { unsigned int v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu8s_BFu1ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu8s_BFu1s { unsigned int v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu8s_BFu31i { unsigned int v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu8s_BFu31ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu8s_BFu32i { unsigned int v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu8s_BFu32ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu8s_BFu33 { unsigned int v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu8s_BFu7c { unsigned int v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu8s_BFu7i { unsigned int v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu8s_BFu7ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu8s_BFu7s { unsigned int v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu8s_BFu8c { unsigned int v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu8s_BFu8i { unsigned int v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu8s_BFu8ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu8s_BFu8s { unsigned int v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu8s_BFu9i { unsigned int v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu8s_BFu9ll { unsigned int v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu8s_BFu9s { unsigned int v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu8s_C { unsigned int v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aUi_BFu8s_D { unsigned int v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aUi_BFu8s_F { unsigned int v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aUi_BFu8s_I { unsigned int v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aUi_BFu8s_Ip { unsigned int v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aUi_BFu8s_L { unsigned int v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aUi_BFu8s_S { unsigned int v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aUi_BFu8s_Uc { unsigned int v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu8s_Ui { unsigned int v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu8s_Ul { unsigned int v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu8s_Us { unsigned int v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu8s_Vp { unsigned int v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aUi_BFu9i { unsigned int v1; unsigned int v2:9; };
struct __attribute__((packed)) aUi_BFu9i_BFu15i { unsigned int v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu9i_BFu15ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu9i_BFu15s { unsigned int v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu9i_BFu16i { unsigned int v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu9i_BFu16ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu9i_BFu16s { unsigned int v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu9i_BFu17i { unsigned int v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu9i_BFu17ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu9i_BFu1c { unsigned int v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu9i_BFu1i { unsigned int v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu9i_BFu1ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu9i_BFu1s { unsigned int v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu9i_BFu31i { unsigned int v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu9i_BFu31ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu9i_BFu32i { unsigned int v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu9i_BFu32ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu9i_BFu33 { unsigned int v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu9i_BFu7c { unsigned int v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu9i_BFu7i { unsigned int v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu9i_BFu7ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu9i_BFu7s { unsigned int v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu9i_BFu8c { unsigned int v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu9i_BFu8i { unsigned int v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu9i_BFu8ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu9i_BFu8s { unsigned int v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu9i_BFu9i { unsigned int v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu9i_BFu9ll { unsigned int v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu9i_BFu9s { unsigned int v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu9i_C { unsigned int v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aUi_BFu9i_D { unsigned int v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aUi_BFu9i_F { unsigned int v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aUi_BFu9i_I { unsigned int v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aUi_BFu9i_Ip { unsigned int v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aUi_BFu9i_L { unsigned int v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aUi_BFu9i_S { unsigned int v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aUi_BFu9i_Uc { unsigned int v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu9i_Ui { unsigned int v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu9i_Ul { unsigned int v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu9i_Us { unsigned int v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu9i_Vp { unsigned int v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aUi_BFu9ll { unsigned int v1; unsigned long long v2:9; };
struct __attribute__((packed)) aUi_BFu9ll_BFu15i { unsigned int v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu9ll_BFu15ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu9ll_BFu15s { unsigned int v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu9ll_BFu16i { unsigned int v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu9ll_BFu16ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu9ll_BFu16s { unsigned int v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu9ll_BFu17i { unsigned int v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu9ll_BFu17ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu9ll_BFu1c { unsigned int v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu9ll_BFu1i { unsigned int v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu9ll_BFu1ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu9ll_BFu1s { unsigned int v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu9ll_BFu31i { unsigned int v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu9ll_BFu31ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu9ll_BFu32i { unsigned int v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu9ll_BFu32ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu9ll_BFu33 { unsigned int v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu9ll_BFu7c { unsigned int v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu9ll_BFu7i { unsigned int v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu9ll_BFu7ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu9ll_BFu7s { unsigned int v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu9ll_BFu8c { unsigned int v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu9ll_BFu8i { unsigned int v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu9ll_BFu8ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu9ll_BFu8s { unsigned int v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu9ll_BFu9i { unsigned int v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu9ll_BFu9ll { unsigned int v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu9ll_BFu9s { unsigned int v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu9ll_C { unsigned int v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aUi_BFu9ll_D { unsigned int v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aUi_BFu9ll_F { unsigned int v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aUi_BFu9ll_I { unsigned int v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aUi_BFu9ll_Ip { unsigned int v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aUi_BFu9ll_L { unsigned int v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aUi_BFu9ll_S { unsigned int v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aUi_BFu9ll_Uc { unsigned int v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu9ll_Ui { unsigned int v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu9ll_Ul { unsigned int v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu9ll_Us { unsigned int v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu9ll_Vp { unsigned int v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aUi_BFu9s { unsigned int v1; unsigned short v2:9; };
struct __attribute__((packed)) aUi_BFu9s_BFu15i { unsigned int v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aUi_BFu9s_BFu15ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_BFu9s_BFu15s { unsigned int v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aUi_BFu9s_BFu16i { unsigned int v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aUi_BFu9s_BFu16ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_BFu9s_BFu16s { unsigned int v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aUi_BFu9s_BFu17i { unsigned int v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aUi_BFu9s_BFu17ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_BFu9s_BFu1c { unsigned int v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aUi_BFu9s_BFu1i { unsigned int v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aUi_BFu9s_BFu1ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_BFu9s_BFu1s { unsigned int v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aUi_BFu9s_BFu31i { unsigned int v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aUi_BFu9s_BFu31ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_BFu9s_BFu32i { unsigned int v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aUi_BFu9s_BFu32ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_BFu9s_BFu33 { unsigned int v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_BFu9s_BFu7c { unsigned int v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aUi_BFu9s_BFu7i { unsigned int v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aUi_BFu9s_BFu7ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_BFu9s_BFu7s { unsigned int v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aUi_BFu9s_BFu8c { unsigned int v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aUi_BFu9s_BFu8i { unsigned int v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aUi_BFu9s_BFu8ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_BFu9s_BFu8s { unsigned int v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aUi_BFu9s_BFu9i { unsigned int v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aUi_BFu9s_BFu9ll { unsigned int v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_BFu9s_BFu9s { unsigned int v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aUi_BFu9s_C { unsigned int v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aUi_BFu9s_D { unsigned int v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aUi_BFu9s_F { unsigned int v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aUi_BFu9s_I { unsigned int v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aUi_BFu9s_Ip { unsigned int v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aUi_BFu9s_L { unsigned int v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aUi_BFu9s_S { unsigned int v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aUi_BFu9s_Uc { unsigned int v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aUi_BFu9s_Ui { unsigned int v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aUi_BFu9s_Ul { unsigned int v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aUi_BFu9s_Us { unsigned int v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aUi_BFu9s_Vp { unsigned int v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aUi_C { unsigned int v1; char v2; };
struct __attribute__((packed)) aUi_C_BFu15i { unsigned int v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_C_BFu15ll { unsigned int v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_C_BFu15s { unsigned int v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_C_BFu16i { unsigned int v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_C_BFu16ll { unsigned int v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_C_BFu16s { unsigned int v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_C_BFu17i { unsigned int v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_C_BFu17ll { unsigned int v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_C_BFu1c { unsigned int v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_C_BFu1i { unsigned int v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_C_BFu1ll { unsigned int v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_C_BFu1s { unsigned int v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_C_BFu31i { unsigned int v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_C_BFu31ll { unsigned int v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_C_BFu32i { unsigned int v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_C_BFu32ll { unsigned int v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_C_BFu33 { unsigned int v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_C_BFu7c { unsigned int v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_C_BFu7i { unsigned int v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_C_BFu7ll { unsigned int v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_C_BFu7s { unsigned int v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_C_BFu8c { unsigned int v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_C_BFu8i { unsigned int v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_C_BFu8ll { unsigned int v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_C_BFu8s { unsigned int v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_C_BFu9i { unsigned int v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_C_BFu9ll { unsigned int v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_C_BFu9s { unsigned int v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_C_C { unsigned int v1; char v2; char v3; };
struct __attribute__((packed)) aUi_C_D { unsigned int v1; char v2; double v3; };
struct __attribute__((packed)) aUi_C_F { unsigned int v1; char v2; float v3; };
struct __attribute__((packed)) aUi_C_I { unsigned int v1; char v2; int v3; };
struct __attribute__((packed)) aUi_C_Ip { unsigned int v1; char v2; int * v3; };
struct __attribute__((packed)) aUi_C_L { unsigned int v1; char v2; long long v3; };
struct __attribute__((packed)) aUi_C_S { unsigned int v1; char v2; short v3; };
struct __attribute__((packed)) aUi_C_Uc { unsigned int v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aUi_C_Ui { unsigned int v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aUi_C_Ul { unsigned int v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_C_Us { unsigned int v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aUi_C_Vp { unsigned int v1; char v2; void * v3; };
struct __attribute__((packed)) aUi_D { unsigned int v1; double v2; };
struct __attribute__((packed)) aUi_D_BFu15i { unsigned int v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_D_BFu15ll { unsigned int v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_D_BFu15s { unsigned int v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_D_BFu16i { unsigned int v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_D_BFu16ll { unsigned int v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_D_BFu16s { unsigned int v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_D_BFu17i { unsigned int v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_D_BFu17ll { unsigned int v1; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_D_BFu1c { unsigned int v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_D_BFu1i { unsigned int v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_D_BFu1ll { unsigned int v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_D_BFu1s { unsigned int v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_D_BFu31i { unsigned int v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_D_BFu31ll { unsigned int v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_D_BFu32i { unsigned int v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_D_BFu32ll { unsigned int v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_D_BFu33 { unsigned int v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_D_BFu7c { unsigned int v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_D_BFu7i { unsigned int v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_D_BFu7ll { unsigned int v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_D_BFu7s { unsigned int v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_D_BFu8c { unsigned int v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_D_BFu8i { unsigned int v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_D_BFu8ll { unsigned int v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_D_BFu8s { unsigned int v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_D_BFu9i { unsigned int v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_D_BFu9ll { unsigned int v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_D_BFu9s { unsigned int v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_D_C { unsigned int v1; double v2; char v3; };
struct __attribute__((packed)) aUi_D_D { unsigned int v1; double v2; double v3; };
struct __attribute__((packed)) aUi_D_F { unsigned int v1; double v2; float v3; };
struct __attribute__((packed)) aUi_D_I { unsigned int v1; double v2; int v3; };
struct __attribute__((packed)) aUi_D_Ip { unsigned int v1; double v2; int * v3; };
struct __attribute__((packed)) aUi_D_L { unsigned int v1; double v2; long long v3; };
struct __attribute__((packed)) aUi_D_S { unsigned int v1; double v2; short v3; };
struct __attribute__((packed)) aUi_D_Uc { unsigned int v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aUi_D_Ui { unsigned int v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aUi_D_Ul { unsigned int v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_D_Us { unsigned int v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aUi_D_Vp { unsigned int v1; double v2; void * v3; };
struct __attribute__((packed)) aUi_F { unsigned int v1; float v2; };
struct __attribute__((packed)) aUi_F_BFu15i { unsigned int v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_F_BFu15ll { unsigned int v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_F_BFu15s { unsigned int v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_F_BFu16i { unsigned int v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_F_BFu16ll { unsigned int v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_F_BFu16s { unsigned int v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_F_BFu17i { unsigned int v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_F_BFu17ll { unsigned int v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_F_BFu1c { unsigned int v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_F_BFu1i { unsigned int v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_F_BFu1ll { unsigned int v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_F_BFu1s { unsigned int v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_F_BFu31i { unsigned int v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_F_BFu31ll { unsigned int v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_F_BFu32i { unsigned int v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_F_BFu32ll { unsigned int v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_F_BFu33 { unsigned int v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_F_BFu7c { unsigned int v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_F_BFu7i { unsigned int v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_F_BFu7ll { unsigned int v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_F_BFu7s { unsigned int v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_F_BFu8c { unsigned int v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_F_BFu8i { unsigned int v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_F_BFu8ll { unsigned int v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_F_BFu8s { unsigned int v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_F_BFu9i { unsigned int v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_F_BFu9ll { unsigned int v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_F_BFu9s { unsigned int v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_F_C { unsigned int v1; float v2; char v3; };
struct __attribute__((packed)) aUi_F_D { unsigned int v1; float v2; double v3; };
struct __attribute__((packed)) aUi_F_F { unsigned int v1; float v2; float v3; };
struct __attribute__((packed)) aUi_F_I { unsigned int v1; float v2; int v3; };
struct __attribute__((packed)) aUi_F_Ip { unsigned int v1; float v2; int * v3; };
struct __attribute__((packed)) aUi_F_L { unsigned int v1; float v2; long long v3; };
struct __attribute__((packed)) aUi_F_S { unsigned int v1; float v2; short v3; };
struct __attribute__((packed)) aUi_F_Uc { unsigned int v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aUi_F_Ui { unsigned int v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aUi_F_Ul { unsigned int v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_F_Us { unsigned int v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aUi_F_Vp { unsigned int v1; float v2; void * v3; };
struct __attribute__((packed)) aUi_I { unsigned int v1; int v2; };
struct __attribute__((packed)) aUi_I_BFu15i { unsigned int v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_I_BFu15ll { unsigned int v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_I_BFu15s { unsigned int v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_I_BFu16i { unsigned int v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_I_BFu16ll { unsigned int v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_I_BFu16s { unsigned int v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_I_BFu17i { unsigned int v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_I_BFu17ll { unsigned int v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_I_BFu1c { unsigned int v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_I_BFu1i { unsigned int v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_I_BFu1ll { unsigned int v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_I_BFu1s { unsigned int v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_I_BFu31i { unsigned int v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_I_BFu31ll { unsigned int v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_I_BFu32i { unsigned int v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_I_BFu32ll { unsigned int v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_I_BFu33 { unsigned int v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_I_BFu7c { unsigned int v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_I_BFu7i { unsigned int v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_I_BFu7ll { unsigned int v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_I_BFu7s { unsigned int v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_I_BFu8c { unsigned int v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_I_BFu8i { unsigned int v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_I_BFu8ll { unsigned int v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_I_BFu8s { unsigned int v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_I_BFu9i { unsigned int v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_I_BFu9ll { unsigned int v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_I_BFu9s { unsigned int v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_I_C { unsigned int v1; int v2; char v3; };
struct __attribute__((packed)) aUi_I_D { unsigned int v1; int v2; double v3; };
struct __attribute__((packed)) aUi_I_F { unsigned int v1; int v2; float v3; };
struct __attribute__((packed)) aUi_I_I { unsigned int v1; int v2; int v3; };
struct __attribute__((packed)) aUi_I_Ip { unsigned int v1; int v2; int * v3; };
struct __attribute__((packed)) aUi_I_L { unsigned int v1; int v2; long long v3; };
struct __attribute__((packed)) aUi_I_S { unsigned int v1; int v2; short v3; };
struct __attribute__((packed)) aUi_I_Uc { unsigned int v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aUi_I_Ui { unsigned int v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aUi_I_Ul { unsigned int v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_I_Us { unsigned int v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aUi_I_Vp { unsigned int v1; int v2; void * v3; };
struct __attribute__((packed)) aUi_Ip { unsigned int v1; int * v2; };
struct __attribute__((packed)) aUi_Ip_BFu15i { unsigned int v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_Ip_BFu15ll { unsigned int v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_Ip_BFu15s { unsigned int v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_Ip_BFu16i { unsigned int v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_Ip_BFu16ll { unsigned int v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_Ip_BFu16s { unsigned int v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_Ip_BFu17i { unsigned int v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_Ip_BFu17ll { unsigned int v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_Ip_BFu1c { unsigned int v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_Ip_BFu1i { unsigned int v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_Ip_BFu1ll { unsigned int v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_Ip_BFu1s { unsigned int v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_Ip_BFu31i { unsigned int v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_Ip_BFu31ll { unsigned int v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_Ip_BFu32i { unsigned int v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_Ip_BFu32ll { unsigned int v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_Ip_BFu33 { unsigned int v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_Ip_BFu7c { unsigned int v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_Ip_BFu7i { unsigned int v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_Ip_BFu7ll { unsigned int v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_Ip_BFu7s { unsigned int v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_Ip_BFu8c { unsigned int v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_Ip_BFu8i { unsigned int v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_Ip_BFu8ll { unsigned int v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_Ip_BFu8s { unsigned int v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_Ip_BFu9i { unsigned int v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_Ip_BFu9ll { unsigned int v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_Ip_BFu9s { unsigned int v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_Ip_C { unsigned int v1; int * v2; char v3; };
struct __attribute__((packed)) aUi_Ip_D { unsigned int v1; int * v2; double v3; };
struct __attribute__((packed)) aUi_Ip_F { unsigned int v1; int * v2; float v3; };
struct __attribute__((packed)) aUi_Ip_I { unsigned int v1; int * v2; int v3; };
struct __attribute__((packed)) aUi_Ip_Ip { unsigned int v1; int * v2; int * v3; };
struct __attribute__((packed)) aUi_Ip_L { unsigned int v1; int * v2; long long v3; };
struct __attribute__((packed)) aUi_Ip_S { unsigned int v1; int * v2; short v3; };
struct __attribute__((packed)) aUi_Ip_Uc { unsigned int v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aUi_Ip_Ui { unsigned int v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aUi_Ip_Ul { unsigned int v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_Ip_Us { unsigned int v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aUi_Ip_Vp { unsigned int v1; int * v2; void * v3; };
struct __attribute__((packed)) aUi_L { unsigned int v1; long long v2; };
struct __attribute__((packed)) aUi_L_BFu15i { unsigned int v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_L_BFu15ll { unsigned int v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_L_BFu15s { unsigned int v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_L_BFu16i { unsigned int v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_L_BFu16ll { unsigned int v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_L_BFu16s { unsigned int v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_L_BFu17i { unsigned int v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_L_BFu17ll { unsigned int v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_L_BFu1c { unsigned int v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_L_BFu1i { unsigned int v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_L_BFu1ll { unsigned int v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_L_BFu1s { unsigned int v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_L_BFu31i { unsigned int v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_L_BFu31ll { unsigned int v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_L_BFu32i { unsigned int v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_L_BFu32ll { unsigned int v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_L_BFu33 { unsigned int v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_L_BFu7c { unsigned int v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_L_BFu7i { unsigned int v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_L_BFu7ll { unsigned int v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_L_BFu7s { unsigned int v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_L_BFu8c { unsigned int v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_L_BFu8i { unsigned int v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_L_BFu8ll { unsigned int v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_L_BFu8s { unsigned int v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_L_BFu9i { unsigned int v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_L_BFu9ll { unsigned int v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_L_BFu9s { unsigned int v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_L_C { unsigned int v1; long long v2; char v3; };
struct __attribute__((packed)) aUi_L_D { unsigned int v1; long long v2; double v3; };
struct __attribute__((packed)) aUi_L_F { unsigned int v1; long long v2; float v3; };
struct __attribute__((packed)) aUi_L_I { unsigned int v1; long long v2; int v3; };
struct __attribute__((packed)) aUi_L_Ip { unsigned int v1; long long v2; int * v3; };
struct __attribute__((packed)) aUi_L_L { unsigned int v1; long long v2; long long v3; };
struct __attribute__((packed)) aUi_L_S { unsigned int v1; long long v2; short v3; };
struct __attribute__((packed)) aUi_L_Uc { unsigned int v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aUi_L_Ui { unsigned int v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aUi_L_Ul { unsigned int v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_L_Us { unsigned int v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aUi_L_Vp { unsigned int v1; long long v2; void * v3; };
struct __attribute__((packed)) aUi_S { unsigned int v1; short v2; };
struct __attribute__((packed)) aUi_S_BFu15i { unsigned int v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_S_BFu15ll { unsigned int v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_S_BFu15s { unsigned int v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_S_BFu16i { unsigned int v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_S_BFu16ll { unsigned int v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_S_BFu16s { unsigned int v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_S_BFu17i { unsigned int v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_S_BFu17ll { unsigned int v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_S_BFu1c { unsigned int v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_S_BFu1i { unsigned int v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_S_BFu1ll { unsigned int v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_S_BFu1s { unsigned int v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_S_BFu31i { unsigned int v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_S_BFu31ll { unsigned int v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_S_BFu32i { unsigned int v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_S_BFu32ll { unsigned int v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_S_BFu33 { unsigned int v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_S_BFu7c { unsigned int v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_S_BFu7i { unsigned int v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_S_BFu7ll { unsigned int v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_S_BFu7s { unsigned int v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_S_BFu8c { unsigned int v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_S_BFu8i { unsigned int v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_S_BFu8ll { unsigned int v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_S_BFu8s { unsigned int v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_S_BFu9i { unsigned int v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_S_BFu9ll { unsigned int v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_S_BFu9s { unsigned int v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_S_C { unsigned int v1; short v2; char v3; };
struct __attribute__((packed)) aUi_S_D { unsigned int v1; short v2; double v3; };
struct __attribute__((packed)) aUi_S_F { unsigned int v1; short v2; float v3; };
struct __attribute__((packed)) aUi_S_I { unsigned int v1; short v2; int v3; };
struct __attribute__((packed)) aUi_S_Ip { unsigned int v1; short v2; int * v3; };
struct __attribute__((packed)) aUi_S_L { unsigned int v1; short v2; long long v3; };
struct __attribute__((packed)) aUi_S_S { unsigned int v1; short v2; short v3; };
struct __attribute__((packed)) aUi_S_Uc { unsigned int v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aUi_S_Ui { unsigned int v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aUi_S_Ul { unsigned int v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_S_Us { unsigned int v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aUi_S_Vp { unsigned int v1; short v2; void * v3; };
struct __attribute__((packed)) aUi_Uc { unsigned int v1; unsigned char v2; };
struct __attribute__((packed)) aUi_Uc_BFu15i { unsigned int v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_Uc_BFu15ll { unsigned int v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_Uc_BFu15s { unsigned int v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_Uc_BFu16i { unsigned int v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_Uc_BFu16ll { unsigned int v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_Uc_BFu16s { unsigned int v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_Uc_BFu17i { unsigned int v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_Uc_BFu17ll { unsigned int v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_Uc_BFu1c { unsigned int v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_Uc_BFu1i { unsigned int v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_Uc_BFu1ll { unsigned int v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_Uc_BFu1s { unsigned int v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_Uc_BFu31i { unsigned int v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_Uc_BFu31ll { unsigned int v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_Uc_BFu32i { unsigned int v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_Uc_BFu32ll { unsigned int v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_Uc_BFu33 { unsigned int v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_Uc_BFu7c { unsigned int v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_Uc_BFu7i { unsigned int v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_Uc_BFu7ll { unsigned int v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_Uc_BFu7s { unsigned int v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_Uc_BFu8c { unsigned int v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_Uc_BFu8i { unsigned int v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_Uc_BFu8ll { unsigned int v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_Uc_BFu8s { unsigned int v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_Uc_BFu9i { unsigned int v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_Uc_BFu9ll { unsigned int v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_Uc_BFu9s { unsigned int v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_Uc_C { unsigned int v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aUi_Uc_D { unsigned int v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aUi_Uc_F { unsigned int v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aUi_Uc_I { unsigned int v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aUi_Uc_Ip { unsigned int v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aUi_Uc_L { unsigned int v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aUi_Uc_S { unsigned int v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aUi_Uc_Uc { unsigned int v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aUi_Uc_Ui { unsigned int v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aUi_Uc_Ul { unsigned int v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_Uc_Us { unsigned int v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aUi_Uc_Vp { unsigned int v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aUi_Ui { unsigned int v1; unsigned int v2; };
struct __attribute__((packed)) aUi_Ui_BFu15i { unsigned int v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_Ui_BFu15ll { unsigned int v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_Ui_BFu15s { unsigned int v1; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_Ui_BFu16i { unsigned int v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_Ui_BFu16ll { unsigned int v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_Ui_BFu16s { unsigned int v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_Ui_BFu17i { unsigned int v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_Ui_BFu17ll { unsigned int v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_Ui_BFu1c { unsigned int v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_Ui_BFu1i { unsigned int v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_Ui_BFu1ll { unsigned int v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_Ui_BFu1s { unsigned int v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_Ui_BFu31i { unsigned int v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_Ui_BFu31ll { unsigned int v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_Ui_BFu32i { unsigned int v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_Ui_BFu32ll { unsigned int v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_Ui_BFu33 { unsigned int v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_Ui_BFu7c { unsigned int v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_Ui_BFu7i { unsigned int v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_Ui_BFu7ll { unsigned int v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_Ui_BFu7s { unsigned int v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_Ui_BFu8c { unsigned int v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_Ui_BFu8i { unsigned int v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_Ui_BFu8ll { unsigned int v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_Ui_BFu8s { unsigned int v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_Ui_BFu9i { unsigned int v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_Ui_BFu9ll { unsigned int v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_Ui_BFu9s { unsigned int v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_Ui_C { unsigned int v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aUi_Ui_D { unsigned int v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aUi_Ui_F { unsigned int v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aUi_Ui_I { unsigned int v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aUi_Ui_Ip { unsigned int v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aUi_Ui_L { unsigned int v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aUi_Ui_S { unsigned int v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aUi_Ui_Uc { unsigned int v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aUi_Ui_Ui { unsigned int v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aUi_Ui_Ul { unsigned int v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_Ui_Us { unsigned int v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aUi_Ui_Vp { unsigned int v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aUi_Ul { unsigned int v1; unsigned long long v2; };
struct __attribute__((packed)) aUi_Ul_BFu15i { unsigned int v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_Ul_BFu15ll { unsigned int v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_Ul_BFu15s { unsigned int v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_Ul_BFu16i { unsigned int v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_Ul_BFu16ll { unsigned int v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_Ul_BFu16s { unsigned int v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_Ul_BFu17i { unsigned int v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_Ul_BFu17ll { unsigned int v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_Ul_BFu1c { unsigned int v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_Ul_BFu1i { unsigned int v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_Ul_BFu1ll { unsigned int v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_Ul_BFu1s { unsigned int v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_Ul_BFu31i { unsigned int v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_Ul_BFu31ll { unsigned int v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_Ul_BFu32i { unsigned int v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_Ul_BFu32ll { unsigned int v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_Ul_BFu33 { unsigned int v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_Ul_BFu7c { unsigned int v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_Ul_BFu7i { unsigned int v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_Ul_BFu7ll { unsigned int v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_Ul_BFu7s { unsigned int v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_Ul_BFu8c { unsigned int v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_Ul_BFu8i { unsigned int v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_Ul_BFu8ll { unsigned int v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_Ul_BFu8s { unsigned int v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_Ul_BFu9i { unsigned int v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_Ul_BFu9ll { unsigned int v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_Ul_BFu9s { unsigned int v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_Ul_C { unsigned int v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aUi_Ul_D { unsigned int v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aUi_Ul_F { unsigned int v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aUi_Ul_I { unsigned int v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aUi_Ul_Ip { unsigned int v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aUi_Ul_L { unsigned int v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aUi_Ul_S { unsigned int v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aUi_Ul_Uc { unsigned int v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aUi_Ul_Ui { unsigned int v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aUi_Ul_Ul { unsigned int v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_Ul_Us { unsigned int v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aUi_Ul_Vp { unsigned int v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aUi_Us { unsigned int v1; unsigned short v2; };
struct __attribute__((packed)) aUi_Us_BFu15i { unsigned int v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_Us_BFu15ll { unsigned int v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_Us_BFu15s { unsigned int v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_Us_BFu16i { unsigned int v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_Us_BFu16ll { unsigned int v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_Us_BFu16s { unsigned int v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_Us_BFu17i { unsigned int v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_Us_BFu17ll { unsigned int v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_Us_BFu1c { unsigned int v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_Us_BFu1i { unsigned int v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_Us_BFu1ll { unsigned int v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_Us_BFu1s { unsigned int v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_Us_BFu31i { unsigned int v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_Us_BFu31ll { unsigned int v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_Us_BFu32i { unsigned int v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_Us_BFu32ll { unsigned int v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_Us_BFu33 { unsigned int v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_Us_BFu7c { unsigned int v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_Us_BFu7i { unsigned int v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_Us_BFu7ll { unsigned int v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_Us_BFu7s { unsigned int v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_Us_BFu8c { unsigned int v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_Us_BFu8i { unsigned int v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_Us_BFu8ll { unsigned int v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_Us_BFu8s { unsigned int v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_Us_BFu9i { unsigned int v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_Us_BFu9ll { unsigned int v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_Us_BFu9s { unsigned int v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_Us_C { unsigned int v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aUi_Us_D { unsigned int v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aUi_Us_F { unsigned int v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aUi_Us_I { unsigned int v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aUi_Us_Ip { unsigned int v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aUi_Us_L { unsigned int v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aUi_Us_S { unsigned int v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aUi_Us_Uc { unsigned int v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aUi_Us_Ui { unsigned int v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aUi_Us_Ul { unsigned int v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_Us_Us { unsigned int v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aUi_Us_Vp { unsigned int v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aUi_Vp { unsigned int v1; void * v2; };
struct __attribute__((packed)) aUi_Vp_BFu15i { unsigned int v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aUi_Vp_BFu15ll { unsigned int v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUi_Vp_BFu15s { unsigned int v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aUi_Vp_BFu16i { unsigned int v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aUi_Vp_BFu16ll { unsigned int v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUi_Vp_BFu16s { unsigned int v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aUi_Vp_BFu17i { unsigned int v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aUi_Vp_BFu17ll { unsigned int v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUi_Vp_BFu1c { unsigned int v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aUi_Vp_BFu1i { unsigned int v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aUi_Vp_BFu1ll { unsigned int v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUi_Vp_BFu1s { unsigned int v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aUi_Vp_BFu31i { unsigned int v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aUi_Vp_BFu31ll { unsigned int v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUi_Vp_BFu32i { unsigned int v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aUi_Vp_BFu32ll { unsigned int v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUi_Vp_BFu33 { unsigned int v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUi_Vp_BFu7c { unsigned int v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aUi_Vp_BFu7i { unsigned int v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aUi_Vp_BFu7ll { unsigned int v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUi_Vp_BFu7s { unsigned int v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aUi_Vp_BFu8c { unsigned int v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aUi_Vp_BFu8i { unsigned int v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aUi_Vp_BFu8ll { unsigned int v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUi_Vp_BFu8s { unsigned int v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aUi_Vp_BFu9i { unsigned int v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aUi_Vp_BFu9ll { unsigned int v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUi_Vp_BFu9s { unsigned int v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aUi_Vp_C { unsigned int v1; void * v2; char v3; };
struct __attribute__((packed)) aUi_Vp_D { unsigned int v1; void * v2; double v3; };
struct __attribute__((packed)) aUi_Vp_F { unsigned int v1; void * v2; float v3; };
struct __attribute__((packed)) aUi_Vp_I { unsigned int v1; void * v2; int v3; };
struct __attribute__((packed)) aUi_Vp_Ip { unsigned int v1; void * v2; int * v3; };
struct __attribute__((packed)) aUi_Vp_L { unsigned int v1; void * v2; long long v3; };
struct __attribute__((packed)) aUi_Vp_S { unsigned int v1; void * v2; short v3; };
struct __attribute__((packed)) aUi_Vp_Uc { unsigned int v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aUi_Vp_Ui { unsigned int v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aUi_Vp_Ul { unsigned int v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aUi_Vp_Us { unsigned int v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aUi_Vp_Vp { unsigned int v1; void * v2; void * v3; };
struct __attribute__((packed)) aUl { unsigned long long v1; };
struct __attribute__((packed)) aUl_BFu15i { unsigned long long v1; unsigned int v2:15; };
struct __attribute__((packed)) aUl_BFu15i_BFu15i { unsigned long long v1; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu15i_BFu15ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu15i_BFu15s { unsigned long long v1; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu15i_BFu16i { unsigned long long v1; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu15i_BFu16ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu15i_BFu16s { unsigned long long v1; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu15i_BFu17i { unsigned long long v1; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu15i_BFu17ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu15i_BFu1c { unsigned long long v1; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu15i_BFu1i { unsigned long long v1; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu15i_BFu1ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu15i_BFu1s { unsigned long long v1; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu15i_BFu31i { unsigned long long v1; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu15i_BFu31ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu15i_BFu32i { unsigned long long v1; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu15i_BFu32ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu15i_BFu33 { unsigned long long v1; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu15i_BFu7c { unsigned long long v1; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu15i_BFu7i { unsigned long long v1; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu15i_BFu7ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu15i_BFu7s { unsigned long long v1; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu15i_BFu8c { unsigned long long v1; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu15i_BFu8i { unsigned long long v1; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu15i_BFu8ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu15i_BFu8s { unsigned long long v1; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu15i_BFu9i { unsigned long long v1; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu15i_BFu9ll { unsigned long long v1; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu15i_BFu9s { unsigned long long v1; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu15i_C { unsigned long long v1; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aUl_BFu15i_D { unsigned long long v1; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aUl_BFu15i_F { unsigned long long v1; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aUl_BFu15i_I { unsigned long long v1; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aUl_BFu15i_Ip { unsigned long long v1; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aUl_BFu15i_L { unsigned long long v1; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aUl_BFu15i_S { unsigned long long v1; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aUl_BFu15i_Uc { unsigned long long v1; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu15i_Ui { unsigned long long v1; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu15i_Ul { unsigned long long v1; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu15i_Us { unsigned long long v1; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu15i_Vp { unsigned long long v1; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aUl_BFu15ll { unsigned long long v1; unsigned long long v2:15; };
struct __attribute__((packed)) aUl_BFu15ll_BFu15i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu15ll_BFu15ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu15ll_BFu15s { unsigned long long v1; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu15ll_BFu16i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu15ll_BFu16ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu15ll_BFu16s { unsigned long long v1; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu15ll_BFu17i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu15ll_BFu17ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu15ll_BFu1c { unsigned long long v1; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu15ll_BFu1i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu15ll_BFu1ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu15ll_BFu1s { unsigned long long v1; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu15ll_BFu31i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu15ll_BFu31ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu15ll_BFu32i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu15ll_BFu32ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu15ll_BFu33 { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu15ll_BFu7c { unsigned long long v1; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu15ll_BFu7i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu15ll_BFu7ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu15ll_BFu7s { unsigned long long v1; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu15ll_BFu8c { unsigned long long v1; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu15ll_BFu8i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu15ll_BFu8ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu15ll_BFu8s { unsigned long long v1; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu15ll_BFu9i { unsigned long long v1; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu15ll_BFu9ll { unsigned long long v1; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu15ll_BFu9s { unsigned long long v1; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu15ll_C { unsigned long long v1; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aUl_BFu15ll_D { unsigned long long v1; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aUl_BFu15ll_F { unsigned long long v1; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aUl_BFu15ll_I { unsigned long long v1; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aUl_BFu15ll_Ip { unsigned long long v1; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aUl_BFu15ll_L { unsigned long long v1; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aUl_BFu15ll_S { unsigned long long v1; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aUl_BFu15ll_Uc { unsigned long long v1; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu15ll_Ui { unsigned long long v1; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu15ll_Ul { unsigned long long v1; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu15ll_Us { unsigned long long v1; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu15ll_Vp { unsigned long long v1; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aUl_BFu15s { unsigned long long v1; unsigned short v2:15; };
struct __attribute__((packed)) aUl_BFu15s_BFu15i { unsigned long long v1; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu15s_BFu15ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu15s_BFu15s { unsigned long long v1; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu15s_BFu16i { unsigned long long v1; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu15s_BFu16ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu15s_BFu16s { unsigned long long v1; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu15s_BFu17i { unsigned long long v1; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu15s_BFu17ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu15s_BFu1c { unsigned long long v1; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu15s_BFu1i { unsigned long long v1; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu15s_BFu1ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu15s_BFu1s { unsigned long long v1; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu15s_BFu31i { unsigned long long v1; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu15s_BFu31ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu15s_BFu32i { unsigned long long v1; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu15s_BFu32ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu15s_BFu33 { unsigned long long v1; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu15s_BFu7c { unsigned long long v1; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu15s_BFu7i { unsigned long long v1; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu15s_BFu7ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu15s_BFu7s { unsigned long long v1; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu15s_BFu8c { unsigned long long v1; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu15s_BFu8i { unsigned long long v1; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu15s_BFu8ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu15s_BFu8s { unsigned long long v1; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu15s_BFu9i { unsigned long long v1; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu15s_BFu9ll { unsigned long long v1; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu15s_BFu9s { unsigned long long v1; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu15s_C { unsigned long long v1; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aUl_BFu15s_D { unsigned long long v1; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aUl_BFu15s_F { unsigned long long v1; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aUl_BFu15s_I { unsigned long long v1; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aUl_BFu15s_Ip { unsigned long long v1; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aUl_BFu15s_L { unsigned long long v1; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aUl_BFu15s_S { unsigned long long v1; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aUl_BFu15s_Uc { unsigned long long v1; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu15s_Ui { unsigned long long v1; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu15s_Ul { unsigned long long v1; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu15s_Us { unsigned long long v1; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu15s_Vp { unsigned long long v1; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aUl_BFu16i { unsigned long long v1; unsigned int v2:16; };
struct __attribute__((packed)) aUl_BFu16i_BFu15i { unsigned long long v1; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu16i_BFu15ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu16i_BFu15s { unsigned long long v1; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu16i_BFu16i { unsigned long long v1; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu16i_BFu16ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu16i_BFu16s { unsigned long long v1; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu16i_BFu17i { unsigned long long v1; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu16i_BFu17ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu16i_BFu1c { unsigned long long v1; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu16i_BFu1i { unsigned long long v1; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu16i_BFu1ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu16i_BFu1s { unsigned long long v1; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu16i_BFu31i { unsigned long long v1; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu16i_BFu31ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu16i_BFu32i { unsigned long long v1; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu16i_BFu32ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu16i_BFu33 { unsigned long long v1; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu16i_BFu7c { unsigned long long v1; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu16i_BFu7i { unsigned long long v1; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu16i_BFu7ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu16i_BFu7s { unsigned long long v1; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu16i_BFu8c { unsigned long long v1; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu16i_BFu8i { unsigned long long v1; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu16i_BFu8ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu16i_BFu8s { unsigned long long v1; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu16i_BFu9i { unsigned long long v1; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu16i_BFu9ll { unsigned long long v1; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu16i_BFu9s { unsigned long long v1; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu16i_C { unsigned long long v1; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aUl_BFu16i_D { unsigned long long v1; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aUl_BFu16i_F { unsigned long long v1; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aUl_BFu16i_I { unsigned long long v1; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aUl_BFu16i_Ip { unsigned long long v1; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aUl_BFu16i_L { unsigned long long v1; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aUl_BFu16i_S { unsigned long long v1; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aUl_BFu16i_Uc { unsigned long long v1; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu16i_Ui { unsigned long long v1; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu16i_Ul { unsigned long long v1; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu16i_Us { unsigned long long v1; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu16i_Vp { unsigned long long v1; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aUl_BFu16ll { unsigned long long v1; unsigned long long v2:16; };
struct __attribute__((packed)) aUl_BFu16ll_BFu15i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu16ll_BFu15ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu16ll_BFu15s { unsigned long long v1; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu16ll_BFu16i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu16ll_BFu16ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu16ll_BFu16s { unsigned long long v1; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu16ll_BFu17i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu16ll_BFu17ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu16ll_BFu1c { unsigned long long v1; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu16ll_BFu1i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu16ll_BFu1ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu16ll_BFu1s { unsigned long long v1; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu16ll_BFu31i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu16ll_BFu31ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu16ll_BFu32i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu16ll_BFu32ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu16ll_BFu33 { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu16ll_BFu7c { unsigned long long v1; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu16ll_BFu7i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu16ll_BFu7ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu16ll_BFu7s { unsigned long long v1; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu16ll_BFu8c { unsigned long long v1; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu16ll_BFu8i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu16ll_BFu8ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu16ll_BFu8s { unsigned long long v1; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu16ll_BFu9i { unsigned long long v1; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu16ll_BFu9ll { unsigned long long v1; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu16ll_BFu9s { unsigned long long v1; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu16ll_C { unsigned long long v1; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aUl_BFu16ll_D { unsigned long long v1; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aUl_BFu16ll_F { unsigned long long v1; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aUl_BFu16ll_I { unsigned long long v1; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aUl_BFu16ll_Ip { unsigned long long v1; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aUl_BFu16ll_L { unsigned long long v1; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aUl_BFu16ll_S { unsigned long long v1; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aUl_BFu16ll_Uc { unsigned long long v1; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu16ll_Ui { unsigned long long v1; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu16ll_Ul { unsigned long long v1; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu16ll_Us { unsigned long long v1; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu16ll_Vp { unsigned long long v1; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aUl_BFu16s { unsigned long long v1; unsigned short v2:16; };
struct __attribute__((packed)) aUl_BFu16s_BFu15i { unsigned long long v1; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu16s_BFu15ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu16s_BFu15s { unsigned long long v1; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu16s_BFu16i { unsigned long long v1; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu16s_BFu16ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu16s_BFu16s { unsigned long long v1; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu16s_BFu17i { unsigned long long v1; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu16s_BFu17ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu16s_BFu1c { unsigned long long v1; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu16s_BFu1i { unsigned long long v1; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu16s_BFu1ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu16s_BFu1s { unsigned long long v1; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu16s_BFu31i { unsigned long long v1; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu16s_BFu31ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu16s_BFu32i { unsigned long long v1; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu16s_BFu32ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu16s_BFu33 { unsigned long long v1; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu16s_BFu7c { unsigned long long v1; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu16s_BFu7i { unsigned long long v1; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu16s_BFu7ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu16s_BFu7s { unsigned long long v1; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu16s_BFu8c { unsigned long long v1; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu16s_BFu8i { unsigned long long v1; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu16s_BFu8ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu16s_BFu8s { unsigned long long v1; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu16s_BFu9i { unsigned long long v1; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu16s_BFu9ll { unsigned long long v1; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu16s_BFu9s { unsigned long long v1; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu16s_C { unsigned long long v1; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aUl_BFu16s_D { unsigned long long v1; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aUl_BFu16s_F { unsigned long long v1; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aUl_BFu16s_I { unsigned long long v1; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aUl_BFu16s_Ip { unsigned long long v1; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aUl_BFu16s_L { unsigned long long v1; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aUl_BFu16s_S { unsigned long long v1; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aUl_BFu16s_Uc { unsigned long long v1; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu16s_Ui { unsigned long long v1; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu16s_Ul { unsigned long long v1; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu16s_Us { unsigned long long v1; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu16s_Vp { unsigned long long v1; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aUl_BFu17i { unsigned long long v1; unsigned int v2:17; };
struct __attribute__((packed)) aUl_BFu17i_BFu15i { unsigned long long v1; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu17i_BFu15ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu17i_BFu15s { unsigned long long v1; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu17i_BFu16i { unsigned long long v1; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu17i_BFu16ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu17i_BFu16s { unsigned long long v1; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu17i_BFu17i { unsigned long long v1; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu17i_BFu17ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu17i_BFu1c { unsigned long long v1; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu17i_BFu1i { unsigned long long v1; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu17i_BFu1ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu17i_BFu1s { unsigned long long v1; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu17i_BFu31i { unsigned long long v1; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu17i_BFu31ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu17i_BFu32i { unsigned long long v1; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu17i_BFu32ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu17i_BFu33 { unsigned long long v1; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu17i_BFu7c { unsigned long long v1; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu17i_BFu7i { unsigned long long v1; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu17i_BFu7ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu17i_BFu7s { unsigned long long v1; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu17i_BFu8c { unsigned long long v1; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu17i_BFu8i { unsigned long long v1; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu17i_BFu8ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu17i_BFu8s { unsigned long long v1; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu17i_BFu9i { unsigned long long v1; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu17i_BFu9ll { unsigned long long v1; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu17i_BFu9s { unsigned long long v1; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu17i_C { unsigned long long v1; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aUl_BFu17i_D { unsigned long long v1; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aUl_BFu17i_F { unsigned long long v1; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aUl_BFu17i_I { unsigned long long v1; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aUl_BFu17i_Ip { unsigned long long v1; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aUl_BFu17i_L { unsigned long long v1; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aUl_BFu17i_S { unsigned long long v1; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aUl_BFu17i_Uc { unsigned long long v1; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu17i_Ui { unsigned long long v1; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu17i_Ul { unsigned long long v1; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu17i_Us { unsigned long long v1; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu17i_Vp { unsigned long long v1; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aUl_BFu17ll { unsigned long long v1; unsigned long long v2:17; };
struct __attribute__((packed)) aUl_BFu17ll_BFu15i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu17ll_BFu15ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu17ll_BFu15s { unsigned long long v1; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu17ll_BFu16i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu17ll_BFu16ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu17ll_BFu16s { unsigned long long v1; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu17ll_BFu17i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu17ll_BFu17ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu17ll_BFu1c { unsigned long long v1; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu17ll_BFu1i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu17ll_BFu1ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu17ll_BFu1s { unsigned long long v1; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu17ll_BFu31i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu17ll_BFu31ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu17ll_BFu32i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu17ll_BFu32ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu17ll_BFu33 { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu17ll_BFu7c { unsigned long long v1; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu17ll_BFu7i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu17ll_BFu7ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu17ll_BFu7s { unsigned long long v1; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu17ll_BFu8c { unsigned long long v1; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu17ll_BFu8i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu17ll_BFu8ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu17ll_BFu8s { unsigned long long v1; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu17ll_BFu9i { unsigned long long v1; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu17ll_BFu9ll { unsigned long long v1; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu17ll_BFu9s { unsigned long long v1; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu17ll_C { unsigned long long v1; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aUl_BFu17ll_D { unsigned long long v1; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aUl_BFu17ll_F { unsigned long long v1; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aUl_BFu17ll_I { unsigned long long v1; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aUl_BFu17ll_Ip { unsigned long long v1; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aUl_BFu17ll_L { unsigned long long v1; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aUl_BFu17ll_S { unsigned long long v1; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aUl_BFu17ll_Uc { unsigned long long v1; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu17ll_Ui { unsigned long long v1; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu17ll_Ul { unsigned long long v1; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu17ll_Us { unsigned long long v1; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu17ll_Vp { unsigned long long v1; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aUl_BFu1c { unsigned long long v1; unsigned char v2:1; };
struct __attribute__((packed)) aUl_BFu1c_BFu15i { unsigned long long v1; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu1c_BFu15ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu1c_BFu15s { unsigned long long v1; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu1c_BFu16i { unsigned long long v1; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu1c_BFu16ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu1c_BFu16s { unsigned long long v1; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu1c_BFu17i { unsigned long long v1; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu1c_BFu17ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu1c_BFu1c { unsigned long long v1; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu1c_BFu1i { unsigned long long v1; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu1c_BFu1ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu1c_BFu1s { unsigned long long v1; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu1c_BFu31i { unsigned long long v1; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu1c_BFu31ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu1c_BFu32i { unsigned long long v1; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu1c_BFu32ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu1c_BFu33 { unsigned long long v1; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu1c_BFu7c { unsigned long long v1; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu1c_BFu7i { unsigned long long v1; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu1c_BFu7ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu1c_BFu7s { unsigned long long v1; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu1c_BFu8c { unsigned long long v1; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu1c_BFu8i { unsigned long long v1; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu1c_BFu8ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu1c_BFu8s { unsigned long long v1; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu1c_BFu9i { unsigned long long v1; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu1c_BFu9ll { unsigned long long v1; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu1c_BFu9s { unsigned long long v1; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu1c_C { unsigned long long v1; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aUl_BFu1c_D { unsigned long long v1; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aUl_BFu1c_F { unsigned long long v1; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aUl_BFu1c_I { unsigned long long v1; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aUl_BFu1c_Ip { unsigned long long v1; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aUl_BFu1c_L { unsigned long long v1; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aUl_BFu1c_S { unsigned long long v1; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aUl_BFu1c_Uc { unsigned long long v1; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu1c_Ui { unsigned long long v1; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu1c_Ul { unsigned long long v1; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu1c_Us { unsigned long long v1; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu1c_Vp { unsigned long long v1; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aUl_BFu1i { unsigned long long v1; unsigned int v2:1; };
struct __attribute__((packed)) aUl_BFu1i_BFu15i { unsigned long long v1; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu1i_BFu15ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu1i_BFu15s { unsigned long long v1; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu1i_BFu16i { unsigned long long v1; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu1i_BFu16ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu1i_BFu16s { unsigned long long v1; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu1i_BFu17i { unsigned long long v1; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu1i_BFu17ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu1i_BFu1c { unsigned long long v1; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu1i_BFu1i { unsigned long long v1; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu1i_BFu1ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu1i_BFu1s { unsigned long long v1; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu1i_BFu31i { unsigned long long v1; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu1i_BFu31ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu1i_BFu32i { unsigned long long v1; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu1i_BFu32ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu1i_BFu33 { unsigned long long v1; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu1i_BFu7c { unsigned long long v1; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu1i_BFu7i { unsigned long long v1; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu1i_BFu7ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu1i_BFu7s { unsigned long long v1; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu1i_BFu8c { unsigned long long v1; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu1i_BFu8i { unsigned long long v1; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu1i_BFu8ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu1i_BFu8s { unsigned long long v1; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu1i_BFu9i { unsigned long long v1; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu1i_BFu9ll { unsigned long long v1; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu1i_BFu9s { unsigned long long v1; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu1i_C { unsigned long long v1; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aUl_BFu1i_D { unsigned long long v1; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aUl_BFu1i_F { unsigned long long v1; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aUl_BFu1i_I { unsigned long long v1; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aUl_BFu1i_Ip { unsigned long long v1; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aUl_BFu1i_L { unsigned long long v1; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aUl_BFu1i_S { unsigned long long v1; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aUl_BFu1i_Uc { unsigned long long v1; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu1i_Ui { unsigned long long v1; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu1i_Ul { unsigned long long v1; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu1i_Us { unsigned long long v1; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu1i_Vp { unsigned long long v1; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aUl_BFu1ll { unsigned long long v1; unsigned long long v2:1; };
struct __attribute__((packed)) aUl_BFu1ll_BFu15i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu1ll_BFu15ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu1ll_BFu15s { unsigned long long v1; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu1ll_BFu16i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu1ll_BFu16ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu1ll_BFu16s { unsigned long long v1; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu1ll_BFu17i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu1ll_BFu17ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu1ll_BFu1c { unsigned long long v1; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu1ll_BFu1i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu1ll_BFu1ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu1ll_BFu1s { unsigned long long v1; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu1ll_BFu31i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu1ll_BFu31ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu1ll_BFu32i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu1ll_BFu32ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu1ll_BFu33 { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu1ll_BFu7c { unsigned long long v1; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu1ll_BFu7i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu1ll_BFu7ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu1ll_BFu7s { unsigned long long v1; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu1ll_BFu8c { unsigned long long v1; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu1ll_BFu8i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu1ll_BFu8ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu1ll_BFu8s { unsigned long long v1; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu1ll_BFu9i { unsigned long long v1; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu1ll_BFu9ll { unsigned long long v1; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu1ll_BFu9s { unsigned long long v1; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu1ll_C { unsigned long long v1; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aUl_BFu1ll_D { unsigned long long v1; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aUl_BFu1ll_F { unsigned long long v1; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aUl_BFu1ll_I { unsigned long long v1; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aUl_BFu1ll_Ip { unsigned long long v1; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aUl_BFu1ll_L { unsigned long long v1; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aUl_BFu1ll_S { unsigned long long v1; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aUl_BFu1ll_Uc { unsigned long long v1; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu1ll_Ui { unsigned long long v1; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu1ll_Ul { unsigned long long v1; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu1ll_Us { unsigned long long v1; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu1ll_Vp { unsigned long long v1; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aUl_BFu1s { unsigned long long v1; unsigned short v2:1; };
struct __attribute__((packed)) aUl_BFu1s_BFu15i { unsigned long long v1; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu1s_BFu15ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu1s_BFu15s { unsigned long long v1; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu1s_BFu16i { unsigned long long v1; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu1s_BFu16ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu1s_BFu16s { unsigned long long v1; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu1s_BFu17i { unsigned long long v1; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu1s_BFu17ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu1s_BFu1c { unsigned long long v1; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu1s_BFu1i { unsigned long long v1; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu1s_BFu1ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu1s_BFu1s { unsigned long long v1; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu1s_BFu31i { unsigned long long v1; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu1s_BFu31ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu1s_BFu32i { unsigned long long v1; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu1s_BFu32ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu1s_BFu33 { unsigned long long v1; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu1s_BFu7c { unsigned long long v1; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu1s_BFu7i { unsigned long long v1; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu1s_BFu7ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu1s_BFu7s { unsigned long long v1; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu1s_BFu8c { unsigned long long v1; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu1s_BFu8i { unsigned long long v1; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu1s_BFu8ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu1s_BFu8s { unsigned long long v1; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu1s_BFu9i { unsigned long long v1; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu1s_BFu9ll { unsigned long long v1; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu1s_BFu9s { unsigned long long v1; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu1s_C { unsigned long long v1; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aUl_BFu1s_D { unsigned long long v1; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aUl_BFu1s_F { unsigned long long v1; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aUl_BFu1s_I { unsigned long long v1; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aUl_BFu1s_Ip { unsigned long long v1; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aUl_BFu1s_L { unsigned long long v1; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aUl_BFu1s_S { unsigned long long v1; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aUl_BFu1s_Uc { unsigned long long v1; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu1s_Ui { unsigned long long v1; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu1s_Ul { unsigned long long v1; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu1s_Us { unsigned long long v1; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu1s_Vp { unsigned long long v1; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aUl_BFu31i { unsigned long long v1; unsigned int v2:31; };
struct __attribute__((packed)) aUl_BFu31i_BFu15i { unsigned long long v1; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu31i_BFu15ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu31i_BFu15s { unsigned long long v1; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu31i_BFu16i { unsigned long long v1; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu31i_BFu16ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu31i_BFu16s { unsigned long long v1; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu31i_BFu17i { unsigned long long v1; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu31i_BFu17ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu31i_BFu1c { unsigned long long v1; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu31i_BFu1i { unsigned long long v1; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu31i_BFu1ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu31i_BFu1s { unsigned long long v1; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu31i_BFu31i { unsigned long long v1; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu31i_BFu31ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu31i_BFu32i { unsigned long long v1; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu31i_BFu32ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu31i_BFu33 { unsigned long long v1; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu31i_BFu7c { unsigned long long v1; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu31i_BFu7i { unsigned long long v1; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu31i_BFu7ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu31i_BFu7s { unsigned long long v1; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu31i_BFu8c { unsigned long long v1; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu31i_BFu8i { unsigned long long v1; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu31i_BFu8ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu31i_BFu8s { unsigned long long v1; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu31i_BFu9i { unsigned long long v1; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu31i_BFu9ll { unsigned long long v1; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu31i_BFu9s { unsigned long long v1; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu31i_C { unsigned long long v1; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aUl_BFu31i_D { unsigned long long v1; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aUl_BFu31i_F { unsigned long long v1; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aUl_BFu31i_I { unsigned long long v1; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aUl_BFu31i_Ip { unsigned long long v1; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aUl_BFu31i_L { unsigned long long v1; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aUl_BFu31i_S { unsigned long long v1; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aUl_BFu31i_Uc { unsigned long long v1; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu31i_Ui { unsigned long long v1; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu31i_Ul { unsigned long long v1; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu31i_Us { unsigned long long v1; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu31i_Vp { unsigned long long v1; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aUl_BFu31ll { unsigned long long v1; unsigned long long v2:31; };
struct __attribute__((packed)) aUl_BFu31ll_BFu15i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu31ll_BFu15ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu31ll_BFu15s { unsigned long long v1; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu31ll_BFu16i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu31ll_BFu16ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu31ll_BFu16s { unsigned long long v1; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu31ll_BFu17i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu31ll_BFu17ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu31ll_BFu1c { unsigned long long v1; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu31ll_BFu1i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu31ll_BFu1ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu31ll_BFu1s { unsigned long long v1; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu31ll_BFu31i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu31ll_BFu31ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu31ll_BFu32i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu31ll_BFu32ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu31ll_BFu33 { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu31ll_BFu7c { unsigned long long v1; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu31ll_BFu7i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu31ll_BFu7ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu31ll_BFu7s { unsigned long long v1; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu31ll_BFu8c { unsigned long long v1; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu31ll_BFu8i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu31ll_BFu8ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu31ll_BFu8s { unsigned long long v1; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu31ll_BFu9i { unsigned long long v1; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu31ll_BFu9ll { unsigned long long v1; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu31ll_BFu9s { unsigned long long v1; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu31ll_C { unsigned long long v1; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aUl_BFu31ll_D { unsigned long long v1; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aUl_BFu31ll_F { unsigned long long v1; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aUl_BFu31ll_I { unsigned long long v1; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aUl_BFu31ll_Ip { unsigned long long v1; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aUl_BFu31ll_L { unsigned long long v1; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aUl_BFu31ll_S { unsigned long long v1; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aUl_BFu31ll_Uc { unsigned long long v1; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu31ll_Ui { unsigned long long v1; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu31ll_Ul { unsigned long long v1; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu31ll_Us { unsigned long long v1; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu31ll_Vp { unsigned long long v1; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aUl_BFu32i { unsigned long long v1; unsigned int v2:32; };
struct __attribute__((packed)) aUl_BFu32i_BFu15i { unsigned long long v1; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu32i_BFu15ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu32i_BFu15s { unsigned long long v1; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu32i_BFu16i { unsigned long long v1; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu32i_BFu16ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu32i_BFu16s { unsigned long long v1; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu32i_BFu17i { unsigned long long v1; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu32i_BFu17ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu32i_BFu1c { unsigned long long v1; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu32i_BFu1i { unsigned long long v1; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu32i_BFu1ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu32i_BFu1s { unsigned long long v1; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu32i_BFu31i { unsigned long long v1; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu32i_BFu31ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu32i_BFu32i { unsigned long long v1; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu32i_BFu32ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu32i_BFu33 { unsigned long long v1; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu32i_BFu7c { unsigned long long v1; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu32i_BFu7i { unsigned long long v1; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu32i_BFu7ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu32i_BFu7s { unsigned long long v1; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu32i_BFu8c { unsigned long long v1; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu32i_BFu8i { unsigned long long v1; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu32i_BFu8ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu32i_BFu8s { unsigned long long v1; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu32i_BFu9i { unsigned long long v1; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu32i_BFu9ll { unsigned long long v1; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu32i_BFu9s { unsigned long long v1; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu32i_C { unsigned long long v1; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aUl_BFu32i_D { unsigned long long v1; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aUl_BFu32i_F { unsigned long long v1; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aUl_BFu32i_I { unsigned long long v1; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aUl_BFu32i_Ip { unsigned long long v1; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aUl_BFu32i_L { unsigned long long v1; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aUl_BFu32i_S { unsigned long long v1; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aUl_BFu32i_Uc { unsigned long long v1; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu32i_Ui { unsigned long long v1; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu32i_Ul { unsigned long long v1; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu32i_Us { unsigned long long v1; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu32i_Vp { unsigned long long v1; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aUl_BFu32ll { unsigned long long v1; unsigned long long v2:32; };
struct __attribute__((packed)) aUl_BFu32ll_BFu15i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu32ll_BFu15ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu32ll_BFu15s { unsigned long long v1; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu32ll_BFu16i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu32ll_BFu16ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu32ll_BFu16s { unsigned long long v1; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu32ll_BFu17i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu32ll_BFu17ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu32ll_BFu1c { unsigned long long v1; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu32ll_BFu1i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu32ll_BFu1ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu32ll_BFu1s { unsigned long long v1; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu32ll_BFu31i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu32ll_BFu31ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu32ll_BFu32i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu32ll_BFu32ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu32ll_BFu33 { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu32ll_BFu7c { unsigned long long v1; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu32ll_BFu7i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu32ll_BFu7ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu32ll_BFu7s { unsigned long long v1; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu32ll_BFu8c { unsigned long long v1; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu32ll_BFu8i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu32ll_BFu8ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu32ll_BFu8s { unsigned long long v1; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu32ll_BFu9i { unsigned long long v1; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu32ll_BFu9ll { unsigned long long v1; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu32ll_BFu9s { unsigned long long v1; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu32ll_C { unsigned long long v1; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aUl_BFu32ll_D { unsigned long long v1; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aUl_BFu32ll_F { unsigned long long v1; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aUl_BFu32ll_I { unsigned long long v1; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aUl_BFu32ll_Ip { unsigned long long v1; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aUl_BFu32ll_L { unsigned long long v1; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aUl_BFu32ll_S { unsigned long long v1; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aUl_BFu32ll_Uc { unsigned long long v1; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu32ll_Ui { unsigned long long v1; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu32ll_Ul { unsigned long long v1; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu32ll_Us { unsigned long long v1; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu32ll_Vp { unsigned long long v1; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aUl_BFu33 { unsigned long long v1; unsigned long long v2:33; };
struct __attribute__((packed)) aUl_BFu33_BFu15i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu33_BFu15ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu33_BFu15s { unsigned long long v1; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu33_BFu16i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu33_BFu16ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu33_BFu16s { unsigned long long v1; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu33_BFu17i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu33_BFu17ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu33_BFu1c { unsigned long long v1; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu33_BFu1i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu33_BFu1ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu33_BFu1s { unsigned long long v1; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu33_BFu31i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu33_BFu31ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu33_BFu32i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu33_BFu32ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu33_BFu33 { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu33_BFu7c { unsigned long long v1; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu33_BFu7i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu33_BFu7ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu33_BFu7s { unsigned long long v1; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu33_BFu8c { unsigned long long v1; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu33_BFu8i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu33_BFu8ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu33_BFu8s { unsigned long long v1; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu33_BFu9i { unsigned long long v1; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu33_BFu9ll { unsigned long long v1; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu33_BFu9s { unsigned long long v1; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu33_C { unsigned long long v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aUl_BFu33_D { unsigned long long v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aUl_BFu33_F { unsigned long long v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aUl_BFu33_I { unsigned long long v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aUl_BFu33_Ip { unsigned long long v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aUl_BFu33_L { unsigned long long v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aUl_BFu33_S { unsigned long long v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aUl_BFu33_Uc { unsigned long long v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu33_Ui { unsigned long long v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu33_Ul { unsigned long long v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu33_Us { unsigned long long v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu33_Vp { unsigned long long v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aUl_BFu7c { unsigned long long v1; unsigned char v2:7; };
struct __attribute__((packed)) aUl_BFu7c_BFu15i { unsigned long long v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu7c_BFu15ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu7c_BFu15s { unsigned long long v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu7c_BFu16i { unsigned long long v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu7c_BFu16ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu7c_BFu16s { unsigned long long v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu7c_BFu17i { unsigned long long v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu7c_BFu17ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu7c_BFu1c { unsigned long long v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu7c_BFu1i { unsigned long long v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu7c_BFu1ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu7c_BFu1s { unsigned long long v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu7c_BFu31i { unsigned long long v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu7c_BFu31ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu7c_BFu32i { unsigned long long v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu7c_BFu32ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu7c_BFu33 { unsigned long long v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu7c_BFu7c { unsigned long long v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu7c_BFu7i { unsigned long long v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu7c_BFu7ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu7c_BFu7s { unsigned long long v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu7c_BFu8c { unsigned long long v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu7c_BFu8i { unsigned long long v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu7c_BFu8ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu7c_BFu8s { unsigned long long v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu7c_BFu9i { unsigned long long v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu7c_BFu9ll { unsigned long long v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu7c_BFu9s { unsigned long long v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu7c_C { unsigned long long v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aUl_BFu7c_D { unsigned long long v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aUl_BFu7c_F { unsigned long long v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aUl_BFu7c_I { unsigned long long v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aUl_BFu7c_Ip { unsigned long long v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aUl_BFu7c_L { unsigned long long v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aUl_BFu7c_S { unsigned long long v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aUl_BFu7c_Uc { unsigned long long v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu7c_Ui { unsigned long long v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu7c_Ul { unsigned long long v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu7c_Us { unsigned long long v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu7c_Vp { unsigned long long v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aUl_BFu7i { unsigned long long v1; unsigned int v2:7; };
struct __attribute__((packed)) aUl_BFu7i_BFu15i { unsigned long long v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu7i_BFu15ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu7i_BFu15s { unsigned long long v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu7i_BFu16i { unsigned long long v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu7i_BFu16ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu7i_BFu16s { unsigned long long v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu7i_BFu17i { unsigned long long v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu7i_BFu17ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu7i_BFu1c { unsigned long long v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu7i_BFu1i { unsigned long long v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu7i_BFu1ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu7i_BFu1s { unsigned long long v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu7i_BFu31i { unsigned long long v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu7i_BFu31ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu7i_BFu32i { unsigned long long v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu7i_BFu32ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu7i_BFu33 { unsigned long long v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu7i_BFu7c { unsigned long long v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu7i_BFu7i { unsigned long long v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu7i_BFu7ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu7i_BFu7s { unsigned long long v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu7i_BFu8c { unsigned long long v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu7i_BFu8i { unsigned long long v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu7i_BFu8ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu7i_BFu8s { unsigned long long v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu7i_BFu9i { unsigned long long v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu7i_BFu9ll { unsigned long long v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu7i_BFu9s { unsigned long long v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu7i_C { unsigned long long v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aUl_BFu7i_D { unsigned long long v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aUl_BFu7i_F { unsigned long long v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aUl_BFu7i_I { unsigned long long v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aUl_BFu7i_Ip { unsigned long long v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aUl_BFu7i_L { unsigned long long v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aUl_BFu7i_S { unsigned long long v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aUl_BFu7i_Uc { unsigned long long v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu7i_Ui { unsigned long long v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu7i_Ul { unsigned long long v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu7i_Us { unsigned long long v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu7i_Vp { unsigned long long v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aUl_BFu7ll { unsigned long long v1; unsigned long long v2:7; };
struct __attribute__((packed)) aUl_BFu7ll_BFu15i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu7ll_BFu15ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu7ll_BFu15s { unsigned long long v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu7ll_BFu16i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu7ll_BFu16ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu7ll_BFu16s { unsigned long long v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu7ll_BFu17i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu7ll_BFu17ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu7ll_BFu1c { unsigned long long v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu7ll_BFu1i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu7ll_BFu1ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu7ll_BFu1s { unsigned long long v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu7ll_BFu31i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu7ll_BFu31ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu7ll_BFu32i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu7ll_BFu32ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu7ll_BFu33 { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu7ll_BFu7c { unsigned long long v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu7ll_BFu7i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu7ll_BFu7ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu7ll_BFu7s { unsigned long long v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu7ll_BFu8c { unsigned long long v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu7ll_BFu8i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu7ll_BFu8ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu7ll_BFu8s { unsigned long long v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu7ll_BFu9i { unsigned long long v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu7ll_BFu9ll { unsigned long long v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu7ll_BFu9s { unsigned long long v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu7ll_C { unsigned long long v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aUl_BFu7ll_D { unsigned long long v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aUl_BFu7ll_F { unsigned long long v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aUl_BFu7ll_I { unsigned long long v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aUl_BFu7ll_Ip { unsigned long long v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aUl_BFu7ll_L { unsigned long long v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aUl_BFu7ll_S { unsigned long long v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aUl_BFu7ll_Uc { unsigned long long v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu7ll_Ui { unsigned long long v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu7ll_Ul { unsigned long long v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu7ll_Us { unsigned long long v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu7ll_Vp { unsigned long long v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aUl_BFu7s { unsigned long long v1; unsigned short v2:7; };
struct __attribute__((packed)) aUl_BFu7s_BFu15i { unsigned long long v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu7s_BFu15ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu7s_BFu15s { unsigned long long v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu7s_BFu16i { unsigned long long v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu7s_BFu16ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu7s_BFu16s { unsigned long long v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu7s_BFu17i { unsigned long long v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu7s_BFu17ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu7s_BFu1c { unsigned long long v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu7s_BFu1i { unsigned long long v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu7s_BFu1ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu7s_BFu1s { unsigned long long v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu7s_BFu31i { unsigned long long v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu7s_BFu31ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu7s_BFu32i { unsigned long long v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu7s_BFu32ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu7s_BFu33 { unsigned long long v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu7s_BFu7c { unsigned long long v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu7s_BFu7i { unsigned long long v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu7s_BFu7ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu7s_BFu7s { unsigned long long v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu7s_BFu8c { unsigned long long v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu7s_BFu8i { unsigned long long v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu7s_BFu8ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu7s_BFu8s { unsigned long long v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu7s_BFu9i { unsigned long long v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu7s_BFu9ll { unsigned long long v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu7s_BFu9s { unsigned long long v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu7s_C { unsigned long long v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aUl_BFu7s_D { unsigned long long v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aUl_BFu7s_F { unsigned long long v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aUl_BFu7s_I { unsigned long long v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aUl_BFu7s_Ip { unsigned long long v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aUl_BFu7s_L { unsigned long long v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aUl_BFu7s_S { unsigned long long v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aUl_BFu7s_Uc { unsigned long long v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu7s_Ui { unsigned long long v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu7s_Ul { unsigned long long v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu7s_Us { unsigned long long v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu7s_Vp { unsigned long long v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aUl_BFu8c { unsigned long long v1; unsigned char v2:8; };
struct __attribute__((packed)) aUl_BFu8c_BFu15i { unsigned long long v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu8c_BFu15ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu8c_BFu15s { unsigned long long v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu8c_BFu16i { unsigned long long v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu8c_BFu16ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu8c_BFu16s { unsigned long long v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu8c_BFu17i { unsigned long long v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu8c_BFu17ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu8c_BFu1c { unsigned long long v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu8c_BFu1i { unsigned long long v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu8c_BFu1ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu8c_BFu1s { unsigned long long v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu8c_BFu31i { unsigned long long v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUl_BFu8c_BFu31ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUl_BFu8c_BFu32i { unsigned long long v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUl_BFu8c_BFu32ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUl_BFu8c_BFu33 { unsigned long long v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUl_BFu8c_BFu7c { unsigned long long v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUl_BFu8c_BFu7i { unsigned long long v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUl_BFu8c_BFu7ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUl_BFu8c_BFu7s { unsigned long long v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUl_BFu8c_BFu8c { unsigned long long v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUl_BFu8c_BFu8i { unsigned long long v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUl_BFu8c_BFu8ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUl_BFu8c_BFu8s { unsigned long long v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUl_BFu8c_BFu9i { unsigned long long v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUl_BFu8c_BFu9ll { unsigned long long v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUl_BFu8c_BFu9s { unsigned long long v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUl_BFu8c_C { unsigned long long v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aUl_BFu8c_D { unsigned long long v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aUl_BFu8c_F { unsigned long long v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aUl_BFu8c_I { unsigned long long v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aUl_BFu8c_Ip { unsigned long long v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aUl_BFu8c_L { unsigned long long v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aUl_BFu8c_S { unsigned long long v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aUl_BFu8c_Uc { unsigned long long v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aUl_BFu8c_Ui { unsigned long long v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aUl_BFu8c_Ul { unsigned long long v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUl_BFu8c_Us { unsigned long long v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aUl_BFu8c_Vp { unsigned long long v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aUl_BFu8i { unsigned long long v1; unsigned int v2:8; };
struct __attribute__((packed)) aUl_BFu8i_BFu15i { unsigned long long v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUl_BFu8i_BFu15ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUl_BFu8i_BFu15s { unsigned long long v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUl_BFu8i_BFu16i { unsigned long long v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUl_BFu8i_BFu16ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUl_BFu8i_BFu16s { unsigned long long v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUl_BFu8i_BFu17i { unsigned long long v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUl_BFu8i_BFu17ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUl_BFu8i_BFu1c { unsigned long long v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUl_BFu8i_BFu1i { unsigned long long v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUl_BFu8i_BFu1ll { unsigned long long v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUl_BFu8i_BFu1s { unsigned long long v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUl_BFu8i_BFu31i { unsigned long long v1; unsigned int v2:8; unsigned int v3:31; };


static void Test_aUc_D_BFu1c()
{
  {
    init_simple_test("aUc_D_BFu1c");
    static STRUCT_IF_C aUc_D_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUc_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu1c, aUc_D_BFu1c)
//============================================================================



static void Test_aUc_D_BFu1i()
{
  {
    init_simple_test("aUc_D_BFu1i");
    static STRUCT_IF_C aUc_D_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUc_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu1i, aUc_D_BFu1i)
//============================================================================



static void Test_aUc_D_BFu1ll()
{
  {
    init_simple_test("aUc_D_BFu1ll");
    static STRUCT_IF_C aUc_D_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUc_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu1ll, aUc_D_BFu1ll)
//============================================================================



static void Test_aUc_D_BFu1s()
{
  {
    init_simple_test("aUc_D_BFu1s");
    static STRUCT_IF_C aUc_D_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUc_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu1s, aUc_D_BFu1s)
//============================================================================



static void Test_aUc_D_BFu31i()
{
  {
    init_simple_test("aUc_D_BFu31i");
    static STRUCT_IF_C aUc_D_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aUc_D_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUc_D_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUc_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu31i, aUc_D_BFu31i)
//============================================================================



static void Test_aUc_D_BFu31ll()
{
  {
    init_simple_test("aUc_D_BFu31ll");
    static STRUCT_IF_C aUc_D_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aUc_D_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUc_D_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUc_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu31ll, aUc_D_BFu31ll)
//============================================================================



static void Test_aUc_D_BFu32i()
{
  {
    init_simple_test("aUc_D_BFu32i");
    static STRUCT_IF_C aUc_D_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aUc_D_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUc_D_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUc_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu32i, aUc_D_BFu32i)
//============================================================================



static void Test_aUc_D_BFu32ll()
{
  {
    init_simple_test("aUc_D_BFu32ll");
    static STRUCT_IF_C aUc_D_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aUc_D_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUc_D_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUc_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu32ll, aUc_D_BFu32ll)
//============================================================================



static void Test_aUc_D_BFu33()
{
  {
    init_simple_test("aUc_D_BFu33");
    static STRUCT_IF_C aUc_D_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aUc_D_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu33.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aUc_D_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aUc_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu33, aUc_D_BFu33)
//============================================================================



static void Test_aUc_D_BFu7c()
{
  {
    init_simple_test("aUc_D_BFu7c");
    static STRUCT_IF_C aUc_D_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUc_D_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUc_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu7c, aUc_D_BFu7c)
//============================================================================



static void Test_aUc_D_BFu7i()
{
  {
    init_simple_test("aUc_D_BFu7i");
    static STRUCT_IF_C aUc_D_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUc_D_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUc_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu7i, aUc_D_BFu7i)
//============================================================================



static void Test_aUc_D_BFu7ll()
{
  {
    init_simple_test("aUc_D_BFu7ll");
    static STRUCT_IF_C aUc_D_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUc_D_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUc_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu7ll, aUc_D_BFu7ll)
//============================================================================



static void Test_aUc_D_BFu7s()
{
  {
    init_simple_test("aUc_D_BFu7s");
    static STRUCT_IF_C aUc_D_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUc_D_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUc_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu7s, aUc_D_BFu7s)
//============================================================================



static void Test_aUc_D_BFu8c()
{
  {
    init_simple_test("aUc_D_BFu8c");
    static STRUCT_IF_C aUc_D_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUc_D_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUc_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu8c, aUc_D_BFu8c)
//============================================================================



static void Test_aUc_D_BFu8i()
{
  {
    init_simple_test("aUc_D_BFu8i");
    static STRUCT_IF_C aUc_D_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUc_D_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUc_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu8i, aUc_D_BFu8i)
//============================================================================



static void Test_aUc_D_BFu8ll()
{
  {
    init_simple_test("aUc_D_BFu8ll");
    static STRUCT_IF_C aUc_D_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUc_D_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUc_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu8ll, aUc_D_BFu8ll)
//============================================================================



static void Test_aUc_D_BFu8s()
{
  {
    init_simple_test("aUc_D_BFu8s");
    static STRUCT_IF_C aUc_D_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUc_D_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUc_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu8s, aUc_D_BFu8s)
//============================================================================



static void Test_aUc_D_BFu9i()
{
  {
    init_simple_test("aUc_D_BFu9i");
    static STRUCT_IF_C aUc_D_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aUc_D_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUc_D_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUc_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu9i, aUc_D_BFu9i)
//============================================================================



static void Test_aUc_D_BFu9ll()
{
  {
    init_simple_test("aUc_D_BFu9ll");
    static STRUCT_IF_C aUc_D_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aUc_D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUc_D_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUc_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu9ll, aUc_D_BFu9ll)
//============================================================================



static void Test_aUc_D_BFu9s()
{
  {
    init_simple_test("aUc_D_BFu9s");
    static STRUCT_IF_C aUc_D_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aUc_D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_D_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aUc_D_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUc_D_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUc_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_BFu9s, aUc_D_BFu9s)
//============================================================================



static void Test_aUc_D_C()
{
  {
    init_simple_test("aUc_D_C");
    STRUCT_IF_C aUc_D_C lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_C)");
    check_field_offset(lv, v1, 0, "aUc_D_C.v1");
    check_field_offset(lv, v2, 1, "aUc_D_C.v2");
    check_field_offset(lv, v3, 9, "aUc_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_C, aUc_D_C)
//============================================================================



static void Test_aUc_D_D()
{
  {
    init_simple_test("aUc_D_D");
    STRUCT_IF_C aUc_D_D lv;
    check2(sizeof(lv), 17, "sizeof(aUc_D_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_D)");
    check_field_offset(lv, v1, 0, "aUc_D_D.v1");
    check_field_offset(lv, v2, 1, "aUc_D_D.v2");
    check_field_offset(lv, v3, 9, "aUc_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_D, aUc_D_D)
//============================================================================



static void Test_aUc_D_F()
{
  {
    init_simple_test("aUc_D_F");
    STRUCT_IF_C aUc_D_F lv;
    check2(sizeof(lv), 13, "sizeof(aUc_D_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_F)");
    check_field_offset(lv, v1, 0, "aUc_D_F.v1");
    check_field_offset(lv, v2, 1, "aUc_D_F.v2");
    check_field_offset(lv, v3, 9, "aUc_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_F, aUc_D_F)
//============================================================================



static void Test_aUc_D_I()
{
  {
    init_simple_test("aUc_D_I");
    STRUCT_IF_C aUc_D_I lv;
    check2(sizeof(lv), 13, "sizeof(aUc_D_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_I)");
    check_field_offset(lv, v1, 0, "aUc_D_I.v1");
    check_field_offset(lv, v2, 1, "aUc_D_I.v2");
    check_field_offset(lv, v3, 9, "aUc_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_I, aUc_D_I)
//============================================================================



static void Test_aUc_D_Ip()
{
  {
    init_simple_test("aUc_D_Ip");
    STRUCT_IF_C aUc_D_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUc_D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_Ip)");
    check_field_offset(lv, v1, 0, "aUc_D_Ip.v1");
    check_field_offset(lv, v2, 1, "aUc_D_Ip.v2");
    check_field_offset(lv, v3, 9, "aUc_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_Ip, aUc_D_Ip)
//============================================================================



static void Test_aUc_D_L()
{
  {
    init_simple_test("aUc_D_L");
    STRUCT_IF_C aUc_D_L lv;
    check2(sizeof(lv), 17, "sizeof(aUc_D_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_L)");
    check_field_offset(lv, v1, 0, "aUc_D_L.v1");
    check_field_offset(lv, v2, 1, "aUc_D_L.v2");
    check_field_offset(lv, v3, 9, "aUc_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_L, aUc_D_L)
//============================================================================



static void Test_aUc_D_S()
{
  {
    init_simple_test("aUc_D_S");
    STRUCT_IF_C aUc_D_S lv;
    check2(sizeof(lv), 11, "sizeof(aUc_D_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_S)");
    check_field_offset(lv, v1, 0, "aUc_D_S.v1");
    check_field_offset(lv, v2, 1, "aUc_D_S.v2");
    check_field_offset(lv, v3, 9, "aUc_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_S, aUc_D_S)
//============================================================================



static void Test_aUc_D_Uc()
{
  {
    init_simple_test("aUc_D_Uc");
    STRUCT_IF_C aUc_D_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aUc_D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_Uc)");
    check_field_offset(lv, v1, 0, "aUc_D_Uc.v1");
    check_field_offset(lv, v2, 1, "aUc_D_Uc.v2");
    check_field_offset(lv, v3, 9, "aUc_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_Uc, aUc_D_Uc)
//============================================================================



static void Test_aUc_D_Ui()
{
  {
    init_simple_test("aUc_D_Ui");
    STRUCT_IF_C aUc_D_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aUc_D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_Ui)");
    check_field_offset(lv, v1, 0, "aUc_D_Ui.v1");
    check_field_offset(lv, v2, 1, "aUc_D_Ui.v2");
    check_field_offset(lv, v3, 9, "aUc_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_Ui, aUc_D_Ui)
//============================================================================



static void Test_aUc_D_Ul()
{
  {
    init_simple_test("aUc_D_Ul");
    STRUCT_IF_C aUc_D_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aUc_D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_Ul)");
    check_field_offset(lv, v1, 0, "aUc_D_Ul.v1");
    check_field_offset(lv, v2, 1, "aUc_D_Ul.v2");
    check_field_offset(lv, v3, 9, "aUc_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_Ul, aUc_D_Ul)
//============================================================================



static void Test_aUc_D_Us()
{
  {
    init_simple_test("aUc_D_Us");
    STRUCT_IF_C aUc_D_Us lv;
    check2(sizeof(lv), 11, "sizeof(aUc_D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_Us)");
    check_field_offset(lv, v1, 0, "aUc_D_Us.v1");
    check_field_offset(lv, v2, 1, "aUc_D_Us.v2");
    check_field_offset(lv, v3, 9, "aUc_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_Us, aUc_D_Us)
//============================================================================



static void Test_aUc_D_Vp()
{
  {
    init_simple_test("aUc_D_Vp");
    STRUCT_IF_C aUc_D_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUc_D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_D_Vp)");
    check_field_offset(lv, v1, 0, "aUc_D_Vp.v1");
    check_field_offset(lv, v2, 1, "aUc_D_Vp.v2");
    check_field_offset(lv, v3, 9, "aUc_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_D_Vp, aUc_D_Vp)
//============================================================================



static void Test_aUc_F()
{
  {
    init_simple_test("aUc_F");
    STRUCT_IF_C aUc_F lv;
    check2(sizeof(lv), 5, "sizeof(aUc_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F)");
    check_field_offset(lv, v1, 0, "aUc_F.v1");
    check_field_offset(lv, v2, 1, "aUc_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F, aUc_F)
//============================================================================



static void Test_aUc_F_BFu15i()
{
  {
    init_simple_test("aUc_F_BFu15i");
    static STRUCT_IF_C aUc_F_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aUc_F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aUc_F_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aUc_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu15i, aUc_F_BFu15i)
//============================================================================



static void Test_aUc_F_BFu15ll()
{
  {
    init_simple_test("aUc_F_BFu15ll");
    static STRUCT_IF_C aUc_F_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aUc_F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aUc_F_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aUc_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu15ll, aUc_F_BFu15ll)
//============================================================================



static void Test_aUc_F_BFu15s()
{
  {
    init_simple_test("aUc_F_BFu15s");
    static STRUCT_IF_C aUc_F_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aUc_F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aUc_F_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aUc_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu15s, aUc_F_BFu15s)
//============================================================================



static void Test_aUc_F_BFu16i()
{
  {
    init_simple_test("aUc_F_BFu16i");
    static STRUCT_IF_C aUc_F_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aUc_F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aUc_F_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aUc_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu16i, aUc_F_BFu16i)
//============================================================================



static void Test_aUc_F_BFu16ll()
{
  {
    init_simple_test("aUc_F_BFu16ll");
    static STRUCT_IF_C aUc_F_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aUc_F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aUc_F_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aUc_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu16ll, aUc_F_BFu16ll)
//============================================================================



static void Test_aUc_F_BFu16s()
{
  {
    init_simple_test("aUc_F_BFu16s");
    static STRUCT_IF_C aUc_F_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aUc_F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aUc_F_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aUc_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu16s, aUc_F_BFu16s)
//============================================================================



static void Test_aUc_F_BFu17i()
{
  {
    init_simple_test("aUc_F_BFu17i");
    static STRUCT_IF_C aUc_F_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aUc_F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aUc_F_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aUc_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu17i, aUc_F_BFu17i)
//============================================================================



static void Test_aUc_F_BFu17ll()
{
  {
    init_simple_test("aUc_F_BFu17ll");
    static STRUCT_IF_C aUc_F_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aUc_F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aUc_F_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aUc_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu17ll, aUc_F_BFu17ll)
//============================================================================



static void Test_aUc_F_BFu1c()
{
  {
    init_simple_test("aUc_F_BFu1c");
    static STRUCT_IF_C aUc_F_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aUc_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu1c, aUc_F_BFu1c)
//============================================================================



static void Test_aUc_F_BFu1i()
{
  {
    init_simple_test("aUc_F_BFu1i");
    static STRUCT_IF_C aUc_F_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aUc_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu1i, aUc_F_BFu1i)
//============================================================================



static void Test_aUc_F_BFu1ll()
{
  {
    init_simple_test("aUc_F_BFu1ll");
    static STRUCT_IF_C aUc_F_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aUc_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu1ll, aUc_F_BFu1ll)
//============================================================================



static void Test_aUc_F_BFu1s()
{
  {
    init_simple_test("aUc_F_BFu1s");
    static STRUCT_IF_C aUc_F_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aUc_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu1s, aUc_F_BFu1s)
//============================================================================



static void Test_aUc_F_BFu31i()
{
  {
    init_simple_test("aUc_F_BFu31i");
    static STRUCT_IF_C aUc_F_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aUc_F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aUc_F_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aUc_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu31i, aUc_F_BFu31i)
//============================================================================



static void Test_aUc_F_BFu31ll()
{
  {
    init_simple_test("aUc_F_BFu31ll");
    static STRUCT_IF_C aUc_F_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aUc_F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aUc_F_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aUc_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu31ll, aUc_F_BFu31ll)
//============================================================================



static void Test_aUc_F_BFu32i()
{
  {
    init_simple_test("aUc_F_BFu32i");
    static STRUCT_IF_C aUc_F_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aUc_F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aUc_F_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aUc_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu32i, aUc_F_BFu32i)
//============================================================================



static void Test_aUc_F_BFu32ll()
{
  {
    init_simple_test("aUc_F_BFu32ll");
    static STRUCT_IF_C aUc_F_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aUc_F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aUc_F_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aUc_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu32ll, aUc_F_BFu32ll)
//============================================================================



static void Test_aUc_F_BFu33()
{
  {
    init_simple_test("aUc_F_BFu33");
    static STRUCT_IF_C aUc_F_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aUc_F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu33.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aUc_F_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aUc_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu33, aUc_F_BFu33)
//============================================================================



static void Test_aUc_F_BFu7c()
{
  {
    init_simple_test("aUc_F_BFu7c");
    static STRUCT_IF_C aUc_F_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aUc_F_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aUc_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu7c, aUc_F_BFu7c)
//============================================================================



static void Test_aUc_F_BFu7i()
{
  {
    init_simple_test("aUc_F_BFu7i");
    static STRUCT_IF_C aUc_F_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aUc_F_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aUc_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu7i, aUc_F_BFu7i)
//============================================================================



static void Test_aUc_F_BFu7ll()
{
  {
    init_simple_test("aUc_F_BFu7ll");
    static STRUCT_IF_C aUc_F_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aUc_F_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aUc_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu7ll, aUc_F_BFu7ll)
//============================================================================



static void Test_aUc_F_BFu7s()
{
  {
    init_simple_test("aUc_F_BFu7s");
    static STRUCT_IF_C aUc_F_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aUc_F_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aUc_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu7s, aUc_F_BFu7s)
//============================================================================



static void Test_aUc_F_BFu8c()
{
  {
    init_simple_test("aUc_F_BFu8c");
    static STRUCT_IF_C aUc_F_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aUc_F_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aUc_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu8c, aUc_F_BFu8c)
//============================================================================



static void Test_aUc_F_BFu8i()
{
  {
    init_simple_test("aUc_F_BFu8i");
    static STRUCT_IF_C aUc_F_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aUc_F_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aUc_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu8i, aUc_F_BFu8i)
//============================================================================



static void Test_aUc_F_BFu8ll()
{
  {
    init_simple_test("aUc_F_BFu8ll");
    static STRUCT_IF_C aUc_F_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aUc_F_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aUc_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu8ll, aUc_F_BFu8ll)
//============================================================================



static void Test_aUc_F_BFu8s()
{
  {
    init_simple_test("aUc_F_BFu8s");
    static STRUCT_IF_C aUc_F_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aUc_F_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aUc_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu8s, aUc_F_BFu8s)
//============================================================================



static void Test_aUc_F_BFu9i()
{
  {
    init_simple_test("aUc_F_BFu9i");
    static STRUCT_IF_C aUc_F_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aUc_F_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aUc_F_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aUc_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu9i, aUc_F_BFu9i)
//============================================================================



static void Test_aUc_F_BFu9ll()
{
  {
    init_simple_test("aUc_F_BFu9ll");
    static STRUCT_IF_C aUc_F_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aUc_F_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aUc_F_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aUc_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu9ll, aUc_F_BFu9ll)
//============================================================================



static void Test_aUc_F_BFu9s()
{
  {
    init_simple_test("aUc_F_BFu9s");
    static STRUCT_IF_C aUc_F_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aUc_F_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_F_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aUc_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aUc_F_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aUc_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_BFu9s, aUc_F_BFu9s)
//============================================================================



static void Test_aUc_F_C()
{
  {
    init_simple_test("aUc_F_C");
    STRUCT_IF_C aUc_F_C lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_C)");
    check_field_offset(lv, v1, 0, "aUc_F_C.v1");
    check_field_offset(lv, v2, 1, "aUc_F_C.v2");
    check_field_offset(lv, v3, 5, "aUc_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_C, aUc_F_C)
//============================================================================



static void Test_aUc_F_D()
{
  {
    init_simple_test("aUc_F_D");
    STRUCT_IF_C aUc_F_D lv;
    check2(sizeof(lv), 13, "sizeof(aUc_F_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_D)");
    check_field_offset(lv, v1, 0, "aUc_F_D.v1");
    check_field_offset(lv, v2, 1, "aUc_F_D.v2");
    check_field_offset(lv, v3, 5, "aUc_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_D, aUc_F_D)
//============================================================================



static void Test_aUc_F_F()
{
  {
    init_simple_test("aUc_F_F");
    STRUCT_IF_C aUc_F_F lv;
    check2(sizeof(lv), 9, "sizeof(aUc_F_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_F)");
    check_field_offset(lv, v1, 0, "aUc_F_F.v1");
    check_field_offset(lv, v2, 1, "aUc_F_F.v2");
    check_field_offset(lv, v3, 5, "aUc_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_F, aUc_F_F)
//============================================================================



static void Test_aUc_F_I()
{
  {
    init_simple_test("aUc_F_I");
    STRUCT_IF_C aUc_F_I lv;
    check2(sizeof(lv), 9, "sizeof(aUc_F_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_I)");
    check_field_offset(lv, v1, 0, "aUc_F_I.v1");
    check_field_offset(lv, v2, 1, "aUc_F_I.v2");
    check_field_offset(lv, v3, 5, "aUc_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_I, aUc_F_I)
//============================================================================



static void Test_aUc_F_Ip()
{
  {
    init_simple_test("aUc_F_Ip");
    STRUCT_IF_C aUc_F_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_F_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_Ip)");
    check_field_offset(lv, v1, 0, "aUc_F_Ip.v1");
    check_field_offset(lv, v2, 1, "aUc_F_Ip.v2");
    check_field_offset(lv, v3, 5, "aUc_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_Ip, aUc_F_Ip)
//============================================================================



static void Test_aUc_F_L()
{
  {
    init_simple_test("aUc_F_L");
    STRUCT_IF_C aUc_F_L lv;
    check2(sizeof(lv), 13, "sizeof(aUc_F_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_L)");
    check_field_offset(lv, v1, 0, "aUc_F_L.v1");
    check_field_offset(lv, v2, 1, "aUc_F_L.v2");
    check_field_offset(lv, v3, 5, "aUc_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_L, aUc_F_L)
//============================================================================



static void Test_aUc_F_S()
{
  {
    init_simple_test("aUc_F_S");
    STRUCT_IF_C aUc_F_S lv;
    check2(sizeof(lv), 7, "sizeof(aUc_F_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_S)");
    check_field_offset(lv, v1, 0, "aUc_F_S.v1");
    check_field_offset(lv, v2, 1, "aUc_F_S.v2");
    check_field_offset(lv, v3, 5, "aUc_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_S, aUc_F_S)
//============================================================================



static void Test_aUc_F_Uc()
{
  {
    init_simple_test("aUc_F_Uc");
    STRUCT_IF_C aUc_F_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aUc_F_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_Uc)");
    check_field_offset(lv, v1, 0, "aUc_F_Uc.v1");
    check_field_offset(lv, v2, 1, "aUc_F_Uc.v2");
    check_field_offset(lv, v3, 5, "aUc_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_Uc, aUc_F_Uc)
//============================================================================



static void Test_aUc_F_Ui()
{
  {
    init_simple_test("aUc_F_Ui");
    STRUCT_IF_C aUc_F_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aUc_F_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_Ui)");
    check_field_offset(lv, v1, 0, "aUc_F_Ui.v1");
    check_field_offset(lv, v2, 1, "aUc_F_Ui.v2");
    check_field_offset(lv, v3, 5, "aUc_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_Ui, aUc_F_Ui)
//============================================================================



static void Test_aUc_F_Ul()
{
  {
    init_simple_test("aUc_F_Ul");
    STRUCT_IF_C aUc_F_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aUc_F_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_Ul)");
    check_field_offset(lv, v1, 0, "aUc_F_Ul.v1");
    check_field_offset(lv, v2, 1, "aUc_F_Ul.v2");
    check_field_offset(lv, v3, 5, "aUc_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_Ul, aUc_F_Ul)
//============================================================================



static void Test_aUc_F_Us()
{
  {
    init_simple_test("aUc_F_Us");
    STRUCT_IF_C aUc_F_Us lv;
    check2(sizeof(lv), 7, "sizeof(aUc_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_Us)");
    check_field_offset(lv, v1, 0, "aUc_F_Us.v1");
    check_field_offset(lv, v2, 1, "aUc_F_Us.v2");
    check_field_offset(lv, v3, 5, "aUc_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_Us, aUc_F_Us)
//============================================================================



static void Test_aUc_F_Vp()
{
  {
    init_simple_test("aUc_F_Vp");
    STRUCT_IF_C aUc_F_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_F_Vp)");
    check_field_offset(lv, v1, 0, "aUc_F_Vp.v1");
    check_field_offset(lv, v2, 1, "aUc_F_Vp.v2");
    check_field_offset(lv, v3, 5, "aUc_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_F_Vp, aUc_F_Vp)
//============================================================================



static void Test_aUc_I()
{
  {
    init_simple_test("aUc_I");
    STRUCT_IF_C aUc_I lv;
    check2(sizeof(lv), 5, "sizeof(aUc_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I)");
    check_field_offset(lv, v1, 0, "aUc_I.v1");
    check_field_offset(lv, v2, 1, "aUc_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I, aUc_I)
//============================================================================



static void Test_aUc_I_BFu15i()
{
  {
    init_simple_test("aUc_I_BFu15i");
    static STRUCT_IF_C aUc_I_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aUc_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aUc_I_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aUc_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu15i, aUc_I_BFu15i)
//============================================================================



static void Test_aUc_I_BFu15ll()
{
  {
    init_simple_test("aUc_I_BFu15ll");
    static STRUCT_IF_C aUc_I_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aUc_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aUc_I_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aUc_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu15ll, aUc_I_BFu15ll)
//============================================================================



static void Test_aUc_I_BFu15s()
{
  {
    init_simple_test("aUc_I_BFu15s");
    static STRUCT_IF_C aUc_I_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aUc_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aUc_I_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aUc_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu15s, aUc_I_BFu15s)
//============================================================================



static void Test_aUc_I_BFu16i()
{
  {
    init_simple_test("aUc_I_BFu16i");
    static STRUCT_IF_C aUc_I_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aUc_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aUc_I_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aUc_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu16i, aUc_I_BFu16i)
//============================================================================



static void Test_aUc_I_BFu16ll()
{
  {
    init_simple_test("aUc_I_BFu16ll");
    static STRUCT_IF_C aUc_I_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aUc_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aUc_I_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aUc_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu16ll, aUc_I_BFu16ll)
//============================================================================



static void Test_aUc_I_BFu16s()
{
  {
    init_simple_test("aUc_I_BFu16s");
    static STRUCT_IF_C aUc_I_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aUc_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aUc_I_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aUc_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu16s, aUc_I_BFu16s)
//============================================================================



static void Test_aUc_I_BFu17i()
{
  {
    init_simple_test("aUc_I_BFu17i");
    static STRUCT_IF_C aUc_I_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aUc_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aUc_I_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aUc_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu17i, aUc_I_BFu17i)
//============================================================================



static void Test_aUc_I_BFu17ll()
{
  {
    init_simple_test("aUc_I_BFu17ll");
    static STRUCT_IF_C aUc_I_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aUc_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aUc_I_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aUc_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu17ll, aUc_I_BFu17ll)
//============================================================================



static void Test_aUc_I_BFu1c()
{
  {
    init_simple_test("aUc_I_BFu1c");
    static STRUCT_IF_C aUc_I_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aUc_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu1c, aUc_I_BFu1c)
//============================================================================



static void Test_aUc_I_BFu1i()
{
  {
    init_simple_test("aUc_I_BFu1i");
    static STRUCT_IF_C aUc_I_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aUc_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu1i, aUc_I_BFu1i)
//============================================================================



static void Test_aUc_I_BFu1ll()
{
  {
    init_simple_test("aUc_I_BFu1ll");
    static STRUCT_IF_C aUc_I_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aUc_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu1ll, aUc_I_BFu1ll)
//============================================================================



static void Test_aUc_I_BFu1s()
{
  {
    init_simple_test("aUc_I_BFu1s");
    static STRUCT_IF_C aUc_I_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aUc_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu1s, aUc_I_BFu1s)
//============================================================================



static void Test_aUc_I_BFu31i()
{
  {
    init_simple_test("aUc_I_BFu31i");
    static STRUCT_IF_C aUc_I_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aUc_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aUc_I_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aUc_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu31i, aUc_I_BFu31i)
//============================================================================



static void Test_aUc_I_BFu31ll()
{
  {
    init_simple_test("aUc_I_BFu31ll");
    static STRUCT_IF_C aUc_I_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aUc_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aUc_I_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aUc_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu31ll, aUc_I_BFu31ll)
//============================================================================



static void Test_aUc_I_BFu32i()
{
  {
    init_simple_test("aUc_I_BFu32i");
    static STRUCT_IF_C aUc_I_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aUc_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aUc_I_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aUc_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu32i, aUc_I_BFu32i)
//============================================================================



static void Test_aUc_I_BFu32ll()
{
  {
    init_simple_test("aUc_I_BFu32ll");
    static STRUCT_IF_C aUc_I_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aUc_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aUc_I_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aUc_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu32ll, aUc_I_BFu32ll)
//============================================================================



static void Test_aUc_I_BFu33()
{
  {
    init_simple_test("aUc_I_BFu33");
    static STRUCT_IF_C aUc_I_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aUc_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu33.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aUc_I_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aUc_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu33, aUc_I_BFu33)
//============================================================================



static void Test_aUc_I_BFu7c()
{
  {
    init_simple_test("aUc_I_BFu7c");
    static STRUCT_IF_C aUc_I_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aUc_I_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aUc_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu7c, aUc_I_BFu7c)
//============================================================================



static void Test_aUc_I_BFu7i()
{
  {
    init_simple_test("aUc_I_BFu7i");
    static STRUCT_IF_C aUc_I_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aUc_I_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aUc_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu7i, aUc_I_BFu7i)
//============================================================================



static void Test_aUc_I_BFu7ll()
{
  {
    init_simple_test("aUc_I_BFu7ll");
    static STRUCT_IF_C aUc_I_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aUc_I_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aUc_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu7ll, aUc_I_BFu7ll)
//============================================================================



static void Test_aUc_I_BFu7s()
{
  {
    init_simple_test("aUc_I_BFu7s");
    static STRUCT_IF_C aUc_I_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aUc_I_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aUc_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu7s, aUc_I_BFu7s)
//============================================================================



static void Test_aUc_I_BFu8c()
{
  {
    init_simple_test("aUc_I_BFu8c");
    static STRUCT_IF_C aUc_I_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aUc_I_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aUc_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu8c, aUc_I_BFu8c)
//============================================================================



static void Test_aUc_I_BFu8i()
{
  {
    init_simple_test("aUc_I_BFu8i");
    static STRUCT_IF_C aUc_I_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aUc_I_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aUc_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu8i, aUc_I_BFu8i)
//============================================================================



static void Test_aUc_I_BFu8ll()
{
  {
    init_simple_test("aUc_I_BFu8ll");
    static STRUCT_IF_C aUc_I_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aUc_I_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aUc_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu8ll, aUc_I_BFu8ll)
//============================================================================



static void Test_aUc_I_BFu8s()
{
  {
    init_simple_test("aUc_I_BFu8s");
    static STRUCT_IF_C aUc_I_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aUc_I_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aUc_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu8s, aUc_I_BFu8s)
//============================================================================



static void Test_aUc_I_BFu9i()
{
  {
    init_simple_test("aUc_I_BFu9i");
    static STRUCT_IF_C aUc_I_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aUc_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aUc_I_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aUc_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu9i, aUc_I_BFu9i)
//============================================================================



static void Test_aUc_I_BFu9ll()
{
  {
    init_simple_test("aUc_I_BFu9ll");
    static STRUCT_IF_C aUc_I_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aUc_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aUc_I_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aUc_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu9ll, aUc_I_BFu9ll)
//============================================================================



static void Test_aUc_I_BFu9s()
{
  {
    init_simple_test("aUc_I_BFu9s");
    static STRUCT_IF_C aUc_I_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aUc_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_I_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aUc_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aUc_I_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aUc_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_BFu9s, aUc_I_BFu9s)
//============================================================================



static void Test_aUc_I_C()
{
  {
    init_simple_test("aUc_I_C");
    STRUCT_IF_C aUc_I_C lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_C)");
    check_field_offset(lv, v1, 0, "aUc_I_C.v1");
    check_field_offset(lv, v2, 1, "aUc_I_C.v2");
    check_field_offset(lv, v3, 5, "aUc_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_C, aUc_I_C)
//============================================================================



static void Test_aUc_I_D()
{
  {
    init_simple_test("aUc_I_D");
    STRUCT_IF_C aUc_I_D lv;
    check2(sizeof(lv), 13, "sizeof(aUc_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_D)");
    check_field_offset(lv, v1, 0, "aUc_I_D.v1");
    check_field_offset(lv, v2, 1, "aUc_I_D.v2");
    check_field_offset(lv, v3, 5, "aUc_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_D, aUc_I_D)
//============================================================================



static void Test_aUc_I_F()
{
  {
    init_simple_test("aUc_I_F");
    STRUCT_IF_C aUc_I_F lv;
    check2(sizeof(lv), 9, "sizeof(aUc_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_F)");
    check_field_offset(lv, v1, 0, "aUc_I_F.v1");
    check_field_offset(lv, v2, 1, "aUc_I_F.v2");
    check_field_offset(lv, v3, 5, "aUc_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_F, aUc_I_F)
//============================================================================



static void Test_aUc_I_I()
{
  {
    init_simple_test("aUc_I_I");
    STRUCT_IF_C aUc_I_I lv;
    check2(sizeof(lv), 9, "sizeof(aUc_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_I)");
    check_field_offset(lv, v1, 0, "aUc_I_I.v1");
    check_field_offset(lv, v2, 1, "aUc_I_I.v2");
    check_field_offset(lv, v3, 5, "aUc_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_I, aUc_I_I)
//============================================================================



static void Test_aUc_I_Ip()
{
  {
    init_simple_test("aUc_I_Ip");
    STRUCT_IF_C aUc_I_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_Ip)");
    check_field_offset(lv, v1, 0, "aUc_I_Ip.v1");
    check_field_offset(lv, v2, 1, "aUc_I_Ip.v2");
    check_field_offset(lv, v3, 5, "aUc_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_Ip, aUc_I_Ip)
//============================================================================



static void Test_aUc_I_L()
{
  {
    init_simple_test("aUc_I_L");
    STRUCT_IF_C aUc_I_L lv;
    check2(sizeof(lv), 13, "sizeof(aUc_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_L)");
    check_field_offset(lv, v1, 0, "aUc_I_L.v1");
    check_field_offset(lv, v2, 1, "aUc_I_L.v2");
    check_field_offset(lv, v3, 5, "aUc_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_L, aUc_I_L)
//============================================================================



static void Test_aUc_I_S()
{
  {
    init_simple_test("aUc_I_S");
    STRUCT_IF_C aUc_I_S lv;
    check2(sizeof(lv), 7, "sizeof(aUc_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_S)");
    check_field_offset(lv, v1, 0, "aUc_I_S.v1");
    check_field_offset(lv, v2, 1, "aUc_I_S.v2");
    check_field_offset(lv, v3, 5, "aUc_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_S, aUc_I_S)
//============================================================================



static void Test_aUc_I_Uc()
{
  {
    init_simple_test("aUc_I_Uc");
    STRUCT_IF_C aUc_I_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aUc_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_Uc)");
    check_field_offset(lv, v1, 0, "aUc_I_Uc.v1");
    check_field_offset(lv, v2, 1, "aUc_I_Uc.v2");
    check_field_offset(lv, v3, 5, "aUc_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_Uc, aUc_I_Uc)
//============================================================================



static void Test_aUc_I_Ui()
{
  {
    init_simple_test("aUc_I_Ui");
    STRUCT_IF_C aUc_I_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aUc_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_Ui)");
    check_field_offset(lv, v1, 0, "aUc_I_Ui.v1");
    check_field_offset(lv, v2, 1, "aUc_I_Ui.v2");
    check_field_offset(lv, v3, 5, "aUc_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_Ui, aUc_I_Ui)
//============================================================================



static void Test_aUc_I_Ul()
{
  {
    init_simple_test("aUc_I_Ul");
    STRUCT_IF_C aUc_I_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aUc_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_Ul)");
    check_field_offset(lv, v1, 0, "aUc_I_Ul.v1");
    check_field_offset(lv, v2, 1, "aUc_I_Ul.v2");
    check_field_offset(lv, v3, 5, "aUc_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_Ul, aUc_I_Ul)
//============================================================================



static void Test_aUc_I_Us()
{
  {
    init_simple_test("aUc_I_Us");
    STRUCT_IF_C aUc_I_Us lv;
    check2(sizeof(lv), 7, "sizeof(aUc_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_Us)");
    check_field_offset(lv, v1, 0, "aUc_I_Us.v1");
    check_field_offset(lv, v2, 1, "aUc_I_Us.v2");
    check_field_offset(lv, v3, 5, "aUc_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_Us, aUc_I_Us)
//============================================================================



static void Test_aUc_I_Vp()
{
  {
    init_simple_test("aUc_I_Vp");
    STRUCT_IF_C aUc_I_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_I_Vp)");
    check_field_offset(lv, v1, 0, "aUc_I_Vp.v1");
    check_field_offset(lv, v2, 1, "aUc_I_Vp.v2");
    check_field_offset(lv, v3, 5, "aUc_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_I_Vp, aUc_I_Vp)
//============================================================================



static void Test_aUc_Ip()
{
  {
    init_simple_test("aUc_Ip");
    STRUCT_IF_C aUc_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip)");
    check_field_offset(lv, v1, 0, "aUc_Ip.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip, aUc_Ip)
//============================================================================



static void Test_aUc_Ip_BFu15i()
{
  {
    init_simple_test("aUc_Ip_BFu15i");
    static STRUCT_IF_C aUc_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aUc_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aUc_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu15i, aUc_Ip_BFu15i)
//============================================================================



static void Test_aUc_Ip_BFu15ll()
{
  {
    init_simple_test("aUc_Ip_BFu15ll");
    static STRUCT_IF_C aUc_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aUc_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aUc_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu15ll, aUc_Ip_BFu15ll)
//============================================================================



static void Test_aUc_Ip_BFu15s()
{
  {
    init_simple_test("aUc_Ip_BFu15s");
    static STRUCT_IF_C aUc_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aUc_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aUc_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu15s, aUc_Ip_BFu15s)
//============================================================================



static void Test_aUc_Ip_BFu16i()
{
  {
    init_simple_test("aUc_Ip_BFu16i");
    static STRUCT_IF_C aUc_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aUc_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aUc_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu16i, aUc_Ip_BFu16i)
//============================================================================



static void Test_aUc_Ip_BFu16ll()
{
  {
    init_simple_test("aUc_Ip_BFu16ll");
    static STRUCT_IF_C aUc_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aUc_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aUc_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu16ll, aUc_Ip_BFu16ll)
//============================================================================



static void Test_aUc_Ip_BFu16s()
{
  {
    init_simple_test("aUc_Ip_BFu16s");
    static STRUCT_IF_C aUc_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aUc_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aUc_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu16s, aUc_Ip_BFu16s)
//============================================================================



static void Test_aUc_Ip_BFu17i()
{
  {
    init_simple_test("aUc_Ip_BFu17i");
    static STRUCT_IF_C aUc_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aUc_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aUc_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu17i, aUc_Ip_BFu17i)
//============================================================================



static void Test_aUc_Ip_BFu17ll()
{
  {
    init_simple_test("aUc_Ip_BFu17ll");
    static STRUCT_IF_C aUc_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aUc_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aUc_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu17ll, aUc_Ip_BFu17ll)
//============================================================================



static void Test_aUc_Ip_BFu1c()
{
  {
    init_simple_test("aUc_Ip_BFu1c");
    static STRUCT_IF_C aUc_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aUc_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu1c, aUc_Ip_BFu1c)
//============================================================================



static void Test_aUc_Ip_BFu1i()
{
  {
    init_simple_test("aUc_Ip_BFu1i");
    static STRUCT_IF_C aUc_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aUc_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu1i, aUc_Ip_BFu1i)
//============================================================================



static void Test_aUc_Ip_BFu1ll()
{
  {
    init_simple_test("aUc_Ip_BFu1ll");
    static STRUCT_IF_C aUc_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aUc_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu1ll, aUc_Ip_BFu1ll)
//============================================================================



static void Test_aUc_Ip_BFu1s()
{
  {
    init_simple_test("aUc_Ip_BFu1s");
    static STRUCT_IF_C aUc_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aUc_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu1s, aUc_Ip_BFu1s)
//============================================================================



static void Test_aUc_Ip_BFu31i()
{
  {
    init_simple_test("aUc_Ip_BFu31i");
    static STRUCT_IF_C aUc_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aUc_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aUc_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu31i, aUc_Ip_BFu31i)
//============================================================================



static void Test_aUc_Ip_BFu31ll()
{
  {
    init_simple_test("aUc_Ip_BFu31ll");
    static STRUCT_IF_C aUc_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aUc_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aUc_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu31ll, aUc_Ip_BFu31ll)
//============================================================================



static void Test_aUc_Ip_BFu32i()
{
  {
    init_simple_test("aUc_Ip_BFu32i");
    static STRUCT_IF_C aUc_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aUc_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aUc_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu32i, aUc_Ip_BFu32i)
//============================================================================



static void Test_aUc_Ip_BFu32ll()
{
  {
    init_simple_test("aUc_Ip_BFu32ll");
    static STRUCT_IF_C aUc_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aUc_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aUc_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu32ll, aUc_Ip_BFu32ll)
//============================================================================



static void Test_aUc_Ip_BFu33()
{
  {
    init_simple_test("aUc_Ip_BFu33");
    static STRUCT_IF_C aUc_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUc_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu33.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aUc_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aUc_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu33, aUc_Ip_BFu33)
//============================================================================



static void Test_aUc_Ip_BFu7c()
{
  {
    init_simple_test("aUc_Ip_BFu7c");
    static STRUCT_IF_C aUc_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aUc_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aUc_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu7c, aUc_Ip_BFu7c)
//============================================================================



static void Test_aUc_Ip_BFu7i()
{
  {
    init_simple_test("aUc_Ip_BFu7i");
    static STRUCT_IF_C aUc_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aUc_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aUc_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu7i, aUc_Ip_BFu7i)
//============================================================================



static void Test_aUc_Ip_BFu7ll()
{
  {
    init_simple_test("aUc_Ip_BFu7ll");
    static STRUCT_IF_C aUc_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aUc_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aUc_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu7ll, aUc_Ip_BFu7ll)
//============================================================================



static void Test_aUc_Ip_BFu7s()
{
  {
    init_simple_test("aUc_Ip_BFu7s");
    static STRUCT_IF_C aUc_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aUc_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aUc_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu7s, aUc_Ip_BFu7s)
//============================================================================



static void Test_aUc_Ip_BFu8c()
{
  {
    init_simple_test("aUc_Ip_BFu8c");
    static STRUCT_IF_C aUc_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aUc_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aUc_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu8c, aUc_Ip_BFu8c)
//============================================================================



static void Test_aUc_Ip_BFu8i()
{
  {
    init_simple_test("aUc_Ip_BFu8i");
    static STRUCT_IF_C aUc_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aUc_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aUc_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu8i, aUc_Ip_BFu8i)
//============================================================================



static void Test_aUc_Ip_BFu8ll()
{
  {
    init_simple_test("aUc_Ip_BFu8ll");
    static STRUCT_IF_C aUc_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aUc_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aUc_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu8ll, aUc_Ip_BFu8ll)
//============================================================================



static void Test_aUc_Ip_BFu8s()
{
  {
    init_simple_test("aUc_Ip_BFu8s");
    static STRUCT_IF_C aUc_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aUc_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aUc_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu8s, aUc_Ip_BFu8s)
//============================================================================



static void Test_aUc_Ip_BFu9i()
{
  {
    init_simple_test("aUc_Ip_BFu9i");
    static STRUCT_IF_C aUc_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aUc_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aUc_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu9i, aUc_Ip_BFu9i)
//============================================================================



static void Test_aUc_Ip_BFu9ll()
{
  {
    init_simple_test("aUc_Ip_BFu9ll");
    static STRUCT_IF_C aUc_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aUc_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aUc_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu9ll, aUc_Ip_BFu9ll)
//============================================================================



static void Test_aUc_Ip_BFu9s()
{
  {
    init_simple_test("aUc_Ip_BFu9s");
    static STRUCT_IF_C aUc_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_Ip_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aUc_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aUc_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_BFu9s, aUc_Ip_BFu9s)
//============================================================================



static void Test_aUc_Ip_C()
{
  {
    init_simple_test("aUc_Ip_C");
    STRUCT_IF_C aUc_Ip_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_C)");
    check_field_offset(lv, v1, 0, "aUc_Ip_C.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_C, aUc_Ip_C)
//============================================================================



static void Test_aUc_Ip_D()
{
  {
    init_simple_test("aUc_Ip_D");
    STRUCT_IF_C aUc_Ip_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUc_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_D)");
    check_field_offset(lv, v1, 0, "aUc_Ip_D.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_D, aUc_Ip_D)
//============================================================================



static void Test_aUc_Ip_F()
{
  {
    init_simple_test("aUc_Ip_F");
    STRUCT_IF_C aUc_Ip_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_F)");
    check_field_offset(lv, v1, 0, "aUc_Ip_F.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_F, aUc_Ip_F)
//============================================================================



static void Test_aUc_Ip_I()
{
  {
    init_simple_test("aUc_Ip_I");
    STRUCT_IF_C aUc_Ip_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_I)");
    check_field_offset(lv, v1, 0, "aUc_Ip_I.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_I, aUc_Ip_I)
//============================================================================



static void Test_aUc_Ip_Ip()
{
  {
    init_simple_test("aUc_Ip_Ip");
    STRUCT_IF_C aUc_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aUc_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_Ip)");
    check_field_offset(lv, v1, 0, "aUc_Ip_Ip.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_Ip, aUc_Ip_Ip)
//============================================================================



static void Test_aUc_Ip_L()
{
  {
    init_simple_test("aUc_Ip_L");
    STRUCT_IF_C aUc_Ip_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUc_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_L)");
    check_field_offset(lv, v1, 0, "aUc_Ip_L.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_L, aUc_Ip_L)
//============================================================================



static void Test_aUc_Ip_S()
{
  {
    init_simple_test("aUc_Ip_S");
    STRUCT_IF_C aUc_Ip_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_S)");
    check_field_offset(lv, v1, 0, "aUc_Ip_S.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_S, aUc_Ip_S)
//============================================================================



static void Test_aUc_Ip_Uc()
{
  {
    init_simple_test("aUc_Ip_Uc");
    STRUCT_IF_C aUc_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_Uc)");
    check_field_offset(lv, v1, 0, "aUc_Ip_Uc.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_Uc, aUc_Ip_Uc)
//============================================================================



static void Test_aUc_Ip_Ui()
{
  {
    init_simple_test("aUc_Ip_Ui");
    STRUCT_IF_C aUc_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_Ui)");
    check_field_offset(lv, v1, 0, "aUc_Ip_Ui.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_Ui, aUc_Ip_Ui)
//============================================================================



static void Test_aUc_Ip_Ul()
{
  {
    init_simple_test("aUc_Ip_Ul");
    STRUCT_IF_C aUc_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUc_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_Ul)");
    check_field_offset(lv, v1, 0, "aUc_Ip_Ul.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_Ul, aUc_Ip_Ul)
//============================================================================



static void Test_aUc_Ip_Us()
{
  {
    init_simple_test("aUc_Ip_Us");
    STRUCT_IF_C aUc_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_Us)");
    check_field_offset(lv, v1, 0, "aUc_Ip_Us.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_Us, aUc_Ip_Us)
//============================================================================



static void Test_aUc_Ip_Vp()
{
  {
    init_simple_test("aUc_Ip_Vp");
    STRUCT_IF_C aUc_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aUc_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ip_Vp)");
    check_field_offset(lv, v1, 0, "aUc_Ip_Vp.v1");
    check_field_offset(lv, v2, 1, "aUc_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ip_Vp, aUc_Ip_Vp)
//============================================================================



static void Test_aUc_L()
{
  {
    init_simple_test("aUc_L");
    STRUCT_IF_C aUc_L lv;
    check2(sizeof(lv), 9, "sizeof(aUc_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L)");
    check_field_offset(lv, v1, 0, "aUc_L.v1");
    check_field_offset(lv, v2, 1, "aUc_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L, aUc_L)
//============================================================================



static void Test_aUc_L_BFu15i()
{
  {
    init_simple_test("aUc_L_BFu15i");
    static STRUCT_IF_C aUc_L_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aUc_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUc_L_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUc_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu15i, aUc_L_BFu15i)
//============================================================================



static void Test_aUc_L_BFu15ll()
{
  {
    init_simple_test("aUc_L_BFu15ll");
    static STRUCT_IF_C aUc_L_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aUc_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUc_L_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUc_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu15ll, aUc_L_BFu15ll)
//============================================================================



static void Test_aUc_L_BFu15s()
{
  {
    init_simple_test("aUc_L_BFu15s");
    static STRUCT_IF_C aUc_L_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aUc_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUc_L_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUc_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu15s, aUc_L_BFu15s)
//============================================================================



static void Test_aUc_L_BFu16i()
{
  {
    init_simple_test("aUc_L_BFu16i");
    static STRUCT_IF_C aUc_L_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(aUc_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUc_L_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUc_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu16i, aUc_L_BFu16i)
//============================================================================



static void Test_aUc_L_BFu16ll()
{
  {
    init_simple_test("aUc_L_BFu16ll");
    static STRUCT_IF_C aUc_L_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(aUc_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUc_L_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUc_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu16ll, aUc_L_BFu16ll)
//============================================================================



static void Test_aUc_L_BFu16s()
{
  {
    init_simple_test("aUc_L_BFu16s");
    static STRUCT_IF_C aUc_L_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(aUc_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUc_L_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUc_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu16s, aUc_L_BFu16s)
//============================================================================



static void Test_aUc_L_BFu17i()
{
  {
    init_simple_test("aUc_L_BFu17i");
    static STRUCT_IF_C aUc_L_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aUc_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aUc_L_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aUc_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu17i, aUc_L_BFu17i)
//============================================================================



static void Test_aUc_L_BFu17ll()
{
  {
    init_simple_test("aUc_L_BFu17ll");
    static STRUCT_IF_C aUc_L_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aUc_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aUc_L_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aUc_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu17ll, aUc_L_BFu17ll)
//============================================================================



static void Test_aUc_L_BFu1c()
{
  {
    init_simple_test("aUc_L_BFu1c");
    static STRUCT_IF_C aUc_L_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUc_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu1c, aUc_L_BFu1c)
//============================================================================



static void Test_aUc_L_BFu1i()
{
  {
    init_simple_test("aUc_L_BFu1i");
    static STRUCT_IF_C aUc_L_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUc_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu1i, aUc_L_BFu1i)
//============================================================================



static void Test_aUc_L_BFu1ll()
{
  {
    init_simple_test("aUc_L_BFu1ll");
    static STRUCT_IF_C aUc_L_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUc_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu1ll, aUc_L_BFu1ll)
//============================================================================



static void Test_aUc_L_BFu1s()
{
  {
    init_simple_test("aUc_L_BFu1s");
    static STRUCT_IF_C aUc_L_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUc_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu1s, aUc_L_BFu1s)
//============================================================================



static void Test_aUc_L_BFu31i()
{
  {
    init_simple_test("aUc_L_BFu31i");
    static STRUCT_IF_C aUc_L_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aUc_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUc_L_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUc_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu31i, aUc_L_BFu31i)
//============================================================================



static void Test_aUc_L_BFu31ll()
{
  {
    init_simple_test("aUc_L_BFu31ll");
    static STRUCT_IF_C aUc_L_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aUc_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUc_L_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUc_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu31ll, aUc_L_BFu31ll)
//============================================================================



static void Test_aUc_L_BFu32i()
{
  {
    init_simple_test("aUc_L_BFu32i");
    static STRUCT_IF_C aUc_L_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aUc_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUc_L_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUc_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu32i, aUc_L_BFu32i)
//============================================================================



static void Test_aUc_L_BFu32ll()
{
  {
    init_simple_test("aUc_L_BFu32ll");
    static STRUCT_IF_C aUc_L_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aUc_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUc_L_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUc_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu32ll, aUc_L_BFu32ll)
//============================================================================



static void Test_aUc_L_BFu33()
{
  {
    init_simple_test("aUc_L_BFu33");
    static STRUCT_IF_C aUc_L_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aUc_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu33.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aUc_L_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aUc_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu33, aUc_L_BFu33)
//============================================================================



static void Test_aUc_L_BFu7c()
{
  {
    init_simple_test("aUc_L_BFu7c");
    static STRUCT_IF_C aUc_L_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUc_L_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUc_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu7c, aUc_L_BFu7c)
//============================================================================



static void Test_aUc_L_BFu7i()
{
  {
    init_simple_test("aUc_L_BFu7i");
    static STRUCT_IF_C aUc_L_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUc_L_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUc_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu7i, aUc_L_BFu7i)
//============================================================================



static void Test_aUc_L_BFu7ll()
{
  {
    init_simple_test("aUc_L_BFu7ll");
    static STRUCT_IF_C aUc_L_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUc_L_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUc_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu7ll, aUc_L_BFu7ll)
//============================================================================



static void Test_aUc_L_BFu7s()
{
  {
    init_simple_test("aUc_L_BFu7s");
    static STRUCT_IF_C aUc_L_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUc_L_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUc_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu7s, aUc_L_BFu7s)
//============================================================================



static void Test_aUc_L_BFu8c()
{
  {
    init_simple_test("aUc_L_BFu8c");
    static STRUCT_IF_C aUc_L_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUc_L_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUc_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu8c, aUc_L_BFu8c)
//============================================================================



static void Test_aUc_L_BFu8i()
{
  {
    init_simple_test("aUc_L_BFu8i");
    static STRUCT_IF_C aUc_L_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUc_L_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUc_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu8i, aUc_L_BFu8i)
//============================================================================



static void Test_aUc_L_BFu8ll()
{
  {
    init_simple_test("aUc_L_BFu8ll");
    static STRUCT_IF_C aUc_L_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUc_L_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUc_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu8ll, aUc_L_BFu8ll)
//============================================================================



static void Test_aUc_L_BFu8s()
{
  {
    init_simple_test("aUc_L_BFu8s");
    static STRUCT_IF_C aUc_L_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUc_L_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUc_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu8s, aUc_L_BFu8s)
//============================================================================



static void Test_aUc_L_BFu9i()
{
  {
    init_simple_test("aUc_L_BFu9i");
    static STRUCT_IF_C aUc_L_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aUc_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUc_L_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUc_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu9i, aUc_L_BFu9i)
//============================================================================



static void Test_aUc_L_BFu9ll()
{
  {
    init_simple_test("aUc_L_BFu9ll");
    static STRUCT_IF_C aUc_L_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aUc_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUc_L_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUc_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu9ll, aUc_L_BFu9ll)
//============================================================================



static void Test_aUc_L_BFu9s()
{
  {
    init_simple_test("aUc_L_BFu9s");
    static STRUCT_IF_C aUc_L_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aUc_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_L_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aUc_L_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUc_L_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUc_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_BFu9s, aUc_L_BFu9s)
//============================================================================



static void Test_aUc_L_C()
{
  {
    init_simple_test("aUc_L_C");
    STRUCT_IF_C aUc_L_C lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_C)");
    check_field_offset(lv, v1, 0, "aUc_L_C.v1");
    check_field_offset(lv, v2, 1, "aUc_L_C.v2");
    check_field_offset(lv, v3, 9, "aUc_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_C, aUc_L_C)
//============================================================================



static void Test_aUc_L_D()
{
  {
    init_simple_test("aUc_L_D");
    STRUCT_IF_C aUc_L_D lv;
    check2(sizeof(lv), 17, "sizeof(aUc_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_D)");
    check_field_offset(lv, v1, 0, "aUc_L_D.v1");
    check_field_offset(lv, v2, 1, "aUc_L_D.v2");
    check_field_offset(lv, v3, 9, "aUc_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_D, aUc_L_D)
//============================================================================



static void Test_aUc_L_F()
{
  {
    init_simple_test("aUc_L_F");
    STRUCT_IF_C aUc_L_F lv;
    check2(sizeof(lv), 13, "sizeof(aUc_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_F)");
    check_field_offset(lv, v1, 0, "aUc_L_F.v1");
    check_field_offset(lv, v2, 1, "aUc_L_F.v2");
    check_field_offset(lv, v3, 9, "aUc_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_F, aUc_L_F)
//============================================================================



static void Test_aUc_L_I()
{
  {
    init_simple_test("aUc_L_I");
    STRUCT_IF_C aUc_L_I lv;
    check2(sizeof(lv), 13, "sizeof(aUc_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_I)");
    check_field_offset(lv, v1, 0, "aUc_L_I.v1");
    check_field_offset(lv, v2, 1, "aUc_L_I.v2");
    check_field_offset(lv, v3, 9, "aUc_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_I, aUc_L_I)
//============================================================================



static void Test_aUc_L_Ip()
{
  {
    init_simple_test("aUc_L_Ip");
    STRUCT_IF_C aUc_L_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUc_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_Ip)");
    check_field_offset(lv, v1, 0, "aUc_L_Ip.v1");
    check_field_offset(lv, v2, 1, "aUc_L_Ip.v2");
    check_field_offset(lv, v3, 9, "aUc_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_Ip, aUc_L_Ip)
//============================================================================



static void Test_aUc_L_L()
{
  {
    init_simple_test("aUc_L_L");
    STRUCT_IF_C aUc_L_L lv;
    check2(sizeof(lv), 17, "sizeof(aUc_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_L)");
    check_field_offset(lv, v1, 0, "aUc_L_L.v1");
    check_field_offset(lv, v2, 1, "aUc_L_L.v2");
    check_field_offset(lv, v3, 9, "aUc_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_L, aUc_L_L)
//============================================================================



static void Test_aUc_L_S()
{
  {
    init_simple_test("aUc_L_S");
    STRUCT_IF_C aUc_L_S lv;
    check2(sizeof(lv), 11, "sizeof(aUc_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_S)");
    check_field_offset(lv, v1, 0, "aUc_L_S.v1");
    check_field_offset(lv, v2, 1, "aUc_L_S.v2");
    check_field_offset(lv, v3, 9, "aUc_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_S, aUc_L_S)
//============================================================================



static void Test_aUc_L_Uc()
{
  {
    init_simple_test("aUc_L_Uc");
    STRUCT_IF_C aUc_L_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aUc_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_Uc)");
    check_field_offset(lv, v1, 0, "aUc_L_Uc.v1");
    check_field_offset(lv, v2, 1, "aUc_L_Uc.v2");
    check_field_offset(lv, v3, 9, "aUc_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_Uc, aUc_L_Uc)
//============================================================================



static void Test_aUc_L_Ui()
{
  {
    init_simple_test("aUc_L_Ui");
    STRUCT_IF_C aUc_L_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aUc_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_Ui)");
    check_field_offset(lv, v1, 0, "aUc_L_Ui.v1");
    check_field_offset(lv, v2, 1, "aUc_L_Ui.v2");
    check_field_offset(lv, v3, 9, "aUc_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_Ui, aUc_L_Ui)
//============================================================================



static void Test_aUc_L_Ul()
{
  {
    init_simple_test("aUc_L_Ul");
    STRUCT_IF_C aUc_L_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aUc_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_Ul)");
    check_field_offset(lv, v1, 0, "aUc_L_Ul.v1");
    check_field_offset(lv, v2, 1, "aUc_L_Ul.v2");
    check_field_offset(lv, v3, 9, "aUc_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_Ul, aUc_L_Ul)
//============================================================================



static void Test_aUc_L_Us()
{
  {
    init_simple_test("aUc_L_Us");
    STRUCT_IF_C aUc_L_Us lv;
    check2(sizeof(lv), 11, "sizeof(aUc_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_Us)");
    check_field_offset(lv, v1, 0, "aUc_L_Us.v1");
    check_field_offset(lv, v2, 1, "aUc_L_Us.v2");
    check_field_offset(lv, v3, 9, "aUc_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_Us, aUc_L_Us)
//============================================================================



static void Test_aUc_L_Vp()
{
  {
    init_simple_test("aUc_L_Vp");
    STRUCT_IF_C aUc_L_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUc_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_L_Vp)");
    check_field_offset(lv, v1, 0, "aUc_L_Vp.v1");
    check_field_offset(lv, v2, 1, "aUc_L_Vp.v2");
    check_field_offset(lv, v3, 9, "aUc_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_L_Vp, aUc_L_Vp)
//============================================================================



static void Test_aUc_S()
{
  {
    init_simple_test("aUc_S");
    STRUCT_IF_C aUc_S lv;
    check2(sizeof(lv), 3, "sizeof(aUc_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S)");
    check_field_offset(lv, v1, 0, "aUc_S.v1");
    check_field_offset(lv, v2, 1, "aUc_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S, aUc_S)
//============================================================================



static void Test_aUc_S_BFu15i()
{
  {
    init_simple_test("aUc_S_BFu15i");
    static STRUCT_IF_C aUc_S_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aUc_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aUc_S_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aUc_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu15i, aUc_S_BFu15i)
//============================================================================



static void Test_aUc_S_BFu15ll()
{
  {
    init_simple_test("aUc_S_BFu15ll");
    static STRUCT_IF_C aUc_S_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aUc_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aUc_S_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aUc_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu15ll, aUc_S_BFu15ll)
//============================================================================



static void Test_aUc_S_BFu15s()
{
  {
    init_simple_test("aUc_S_BFu15s");
    static STRUCT_IF_C aUc_S_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aUc_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aUc_S_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aUc_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu15s, aUc_S_BFu15s)
//============================================================================



static void Test_aUc_S_BFu16i()
{
  {
    init_simple_test("aUc_S_BFu16i");
    static STRUCT_IF_C aUc_S_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aUc_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aUc_S_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aUc_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu16i, aUc_S_BFu16i)
//============================================================================



static void Test_aUc_S_BFu16ll()
{
  {
    init_simple_test("aUc_S_BFu16ll");
    static STRUCT_IF_C aUc_S_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aUc_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aUc_S_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aUc_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu16ll, aUc_S_BFu16ll)
//============================================================================



static void Test_aUc_S_BFu16s()
{
  {
    init_simple_test("aUc_S_BFu16s");
    static STRUCT_IF_C aUc_S_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aUc_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aUc_S_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aUc_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu16s, aUc_S_BFu16s)
//============================================================================



static void Test_aUc_S_BFu17i()
{
  {
    init_simple_test("aUc_S_BFu17i");
    static STRUCT_IF_C aUc_S_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aUc_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aUc_S_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aUc_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu17i, aUc_S_BFu17i)
//============================================================================



static void Test_aUc_S_BFu17ll()
{
  {
    init_simple_test("aUc_S_BFu17ll");
    static STRUCT_IF_C aUc_S_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aUc_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aUc_S_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aUc_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu17ll, aUc_S_BFu17ll)
//============================================================================



static void Test_aUc_S_BFu1c()
{
  {
    init_simple_test("aUc_S_BFu1c");
    static STRUCT_IF_C aUc_S_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aUc_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu1c, aUc_S_BFu1c)
//============================================================================



static void Test_aUc_S_BFu1i()
{
  {
    init_simple_test("aUc_S_BFu1i");
    static STRUCT_IF_C aUc_S_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aUc_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu1i, aUc_S_BFu1i)
//============================================================================



static void Test_aUc_S_BFu1ll()
{
  {
    init_simple_test("aUc_S_BFu1ll");
    static STRUCT_IF_C aUc_S_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aUc_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu1ll, aUc_S_BFu1ll)
//============================================================================



static void Test_aUc_S_BFu1s()
{
  {
    init_simple_test("aUc_S_BFu1s");
    static STRUCT_IF_C aUc_S_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aUc_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu1s, aUc_S_BFu1s)
//============================================================================



static void Test_aUc_S_BFu31i()
{
  {
    init_simple_test("aUc_S_BFu31i");
    static STRUCT_IF_C aUc_S_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aUc_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aUc_S_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aUc_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu31i, aUc_S_BFu31i)
//============================================================================



static void Test_aUc_S_BFu31ll()
{
  {
    init_simple_test("aUc_S_BFu31ll");
    static STRUCT_IF_C aUc_S_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aUc_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aUc_S_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aUc_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu31ll, aUc_S_BFu31ll)
//============================================================================



static void Test_aUc_S_BFu32i()
{
  {
    init_simple_test("aUc_S_BFu32i");
    static STRUCT_IF_C aUc_S_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aUc_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aUc_S_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aUc_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu32i, aUc_S_BFu32i)
//============================================================================



static void Test_aUc_S_BFu32ll()
{
  {
    init_simple_test("aUc_S_BFu32ll");
    static STRUCT_IF_C aUc_S_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aUc_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aUc_S_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aUc_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu32ll, aUc_S_BFu32ll)
//============================================================================



static void Test_aUc_S_BFu33()
{
  {
    init_simple_test("aUc_S_BFu33");
    static STRUCT_IF_C aUc_S_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aUc_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu33.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aUc_S_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aUc_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu33, aUc_S_BFu33)
//============================================================================



static void Test_aUc_S_BFu7c()
{
  {
    init_simple_test("aUc_S_BFu7c");
    static STRUCT_IF_C aUc_S_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aUc_S_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aUc_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu7c, aUc_S_BFu7c)
//============================================================================



static void Test_aUc_S_BFu7i()
{
  {
    init_simple_test("aUc_S_BFu7i");
    static STRUCT_IF_C aUc_S_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aUc_S_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aUc_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu7i, aUc_S_BFu7i)
//============================================================================



static void Test_aUc_S_BFu7ll()
{
  {
    init_simple_test("aUc_S_BFu7ll");
    static STRUCT_IF_C aUc_S_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aUc_S_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aUc_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu7ll, aUc_S_BFu7ll)
//============================================================================



static void Test_aUc_S_BFu7s()
{
  {
    init_simple_test("aUc_S_BFu7s");
    static STRUCT_IF_C aUc_S_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aUc_S_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aUc_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu7s, aUc_S_BFu7s)
//============================================================================



static void Test_aUc_S_BFu8c()
{
  {
    init_simple_test("aUc_S_BFu8c");
    static STRUCT_IF_C aUc_S_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aUc_S_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aUc_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu8c, aUc_S_BFu8c)
//============================================================================



static void Test_aUc_S_BFu8i()
{
  {
    init_simple_test("aUc_S_BFu8i");
    static STRUCT_IF_C aUc_S_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aUc_S_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aUc_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu8i, aUc_S_BFu8i)
//============================================================================



static void Test_aUc_S_BFu8ll()
{
  {
    init_simple_test("aUc_S_BFu8ll");
    static STRUCT_IF_C aUc_S_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aUc_S_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aUc_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu8ll, aUc_S_BFu8ll)
//============================================================================



static void Test_aUc_S_BFu8s()
{
  {
    init_simple_test("aUc_S_BFu8s");
    static STRUCT_IF_C aUc_S_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aUc_S_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aUc_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu8s, aUc_S_BFu8s)
//============================================================================



static void Test_aUc_S_BFu9i()
{
  {
    init_simple_test("aUc_S_BFu9i");
    static STRUCT_IF_C aUc_S_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aUc_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aUc_S_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aUc_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu9i, aUc_S_BFu9i)
//============================================================================



static void Test_aUc_S_BFu9ll()
{
  {
    init_simple_test("aUc_S_BFu9ll");
    static STRUCT_IF_C aUc_S_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aUc_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aUc_S_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aUc_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu9ll, aUc_S_BFu9ll)
//============================================================================



static void Test_aUc_S_BFu9s()
{
  {
    init_simple_test("aUc_S_BFu9s");
    static STRUCT_IF_C aUc_S_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aUc_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_S_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aUc_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aUc_S_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aUc_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_BFu9s, aUc_S_BFu9s)
//============================================================================



static void Test_aUc_S_C()
{
  {
    init_simple_test("aUc_S_C");
    STRUCT_IF_C aUc_S_C lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_C)");
    check_field_offset(lv, v1, 0, "aUc_S_C.v1");
    check_field_offset(lv, v2, 1, "aUc_S_C.v2");
    check_field_offset(lv, v3, 3, "aUc_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_C, aUc_S_C)
//============================================================================



static void Test_aUc_S_D()
{
  {
    init_simple_test("aUc_S_D");
    STRUCT_IF_C aUc_S_D lv;
    check2(sizeof(lv), 11, "sizeof(aUc_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_D)");
    check_field_offset(lv, v1, 0, "aUc_S_D.v1");
    check_field_offset(lv, v2, 1, "aUc_S_D.v2");
    check_field_offset(lv, v3, 3, "aUc_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_D, aUc_S_D)
//============================================================================



static void Test_aUc_S_F()
{
  {
    init_simple_test("aUc_S_F");
    STRUCT_IF_C aUc_S_F lv;
    check2(sizeof(lv), 7, "sizeof(aUc_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_F)");
    check_field_offset(lv, v1, 0, "aUc_S_F.v1");
    check_field_offset(lv, v2, 1, "aUc_S_F.v2");
    check_field_offset(lv, v3, 3, "aUc_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_F, aUc_S_F)
//============================================================================



static void Test_aUc_S_I()
{
  {
    init_simple_test("aUc_S_I");
    STRUCT_IF_C aUc_S_I lv;
    check2(sizeof(lv), 7, "sizeof(aUc_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_I)");
    check_field_offset(lv, v1, 0, "aUc_S_I.v1");
    check_field_offset(lv, v2, 1, "aUc_S_I.v2");
    check_field_offset(lv, v3, 3, "aUc_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_I, aUc_S_I)
//============================================================================



static void Test_aUc_S_Ip()
{
  {
    init_simple_test("aUc_S_Ip");
    STRUCT_IF_C aUc_S_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_Ip)");
    check_field_offset(lv, v1, 0, "aUc_S_Ip.v1");
    check_field_offset(lv, v2, 1, "aUc_S_Ip.v2");
    check_field_offset(lv, v3, 3, "aUc_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_Ip, aUc_S_Ip)
//============================================================================



static void Test_aUc_S_L()
{
  {
    init_simple_test("aUc_S_L");
    STRUCT_IF_C aUc_S_L lv;
    check2(sizeof(lv), 11, "sizeof(aUc_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_L)");
    check_field_offset(lv, v1, 0, "aUc_S_L.v1");
    check_field_offset(lv, v2, 1, "aUc_S_L.v2");
    check_field_offset(lv, v3, 3, "aUc_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_L, aUc_S_L)
//============================================================================



static void Test_aUc_S_S()
{
  {
    init_simple_test("aUc_S_S");
    STRUCT_IF_C aUc_S_S lv;
    check2(sizeof(lv), 5, "sizeof(aUc_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_S)");
    check_field_offset(lv, v1, 0, "aUc_S_S.v1");
    check_field_offset(lv, v2, 1, "aUc_S_S.v2");
    check_field_offset(lv, v3, 3, "aUc_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_S, aUc_S_S)
//============================================================================



static void Test_aUc_S_Uc()
{
  {
    init_simple_test("aUc_S_Uc");
    STRUCT_IF_C aUc_S_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aUc_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_Uc)");
    check_field_offset(lv, v1, 0, "aUc_S_Uc.v1");
    check_field_offset(lv, v2, 1, "aUc_S_Uc.v2");
    check_field_offset(lv, v3, 3, "aUc_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_Uc, aUc_S_Uc)
//============================================================================



static void Test_aUc_S_Ui()
{
  {
    init_simple_test("aUc_S_Ui");
    STRUCT_IF_C aUc_S_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aUc_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_Ui)");
    check_field_offset(lv, v1, 0, "aUc_S_Ui.v1");
    check_field_offset(lv, v2, 1, "aUc_S_Ui.v2");
    check_field_offset(lv, v3, 3, "aUc_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_Ui, aUc_S_Ui)
//============================================================================



static void Test_aUc_S_Ul()
{
  {
    init_simple_test("aUc_S_Ul");
    STRUCT_IF_C aUc_S_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aUc_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_Ul)");
    check_field_offset(lv, v1, 0, "aUc_S_Ul.v1");
    check_field_offset(lv, v2, 1, "aUc_S_Ul.v2");
    check_field_offset(lv, v3, 3, "aUc_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_Ul, aUc_S_Ul)
//============================================================================



static void Test_aUc_S_Us()
{
  {
    init_simple_test("aUc_S_Us");
    STRUCT_IF_C aUc_S_Us lv;
    check2(sizeof(lv), 5, "sizeof(aUc_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_Us)");
    check_field_offset(lv, v1, 0, "aUc_S_Us.v1");
    check_field_offset(lv, v2, 1, "aUc_S_Us.v2");
    check_field_offset(lv, v3, 3, "aUc_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_Us, aUc_S_Us)
//============================================================================



static void Test_aUc_S_Vp()
{
  {
    init_simple_test("aUc_S_Vp");
    STRUCT_IF_C aUc_S_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_S_Vp)");
    check_field_offset(lv, v1, 0, "aUc_S_Vp.v1");
    check_field_offset(lv, v2, 1, "aUc_S_Vp.v2");
    check_field_offset(lv, v3, 3, "aUc_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_S_Vp, aUc_S_Vp)
//============================================================================



static void Test_aUc_Uc()
{
  {
    init_simple_test("aUc_Uc");
    STRUCT_IF_C aUc_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aUc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc)");
    check_field_offset(lv, v1, 0, "aUc_Uc.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc, aUc_Uc)
//============================================================================



static void Test_aUc_Uc_BFu15i()
{
  {
    init_simple_test("aUc_Uc_BFu15i");
    static STRUCT_IF_C aUc_Uc_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aUc_Uc_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aUc_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu15i, aUc_Uc_BFu15i)
//============================================================================



static void Test_aUc_Uc_BFu15ll()
{
  {
    init_simple_test("aUc_Uc_BFu15ll");
    static STRUCT_IF_C aUc_Uc_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aUc_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aUc_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu15ll, aUc_Uc_BFu15ll)
//============================================================================



static void Test_aUc_Uc_BFu15s()
{
  {
    init_simple_test("aUc_Uc_BFu15s");
    static STRUCT_IF_C aUc_Uc_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aUc_Uc_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aUc_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu15s, aUc_Uc_BFu15s)
//============================================================================



static void Test_aUc_Uc_BFu16i()
{
  {
    init_simple_test("aUc_Uc_BFu16i");
    static STRUCT_IF_C aUc_Uc_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aUc_Uc_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aUc_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu16i, aUc_Uc_BFu16i)
//============================================================================



static void Test_aUc_Uc_BFu16ll()
{
  {
    init_simple_test("aUc_Uc_BFu16ll");
    static STRUCT_IF_C aUc_Uc_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aUc_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aUc_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu16ll, aUc_Uc_BFu16ll)
//============================================================================



static void Test_aUc_Uc_BFu16s()
{
  {
    init_simple_test("aUc_Uc_BFu16s");
    static STRUCT_IF_C aUc_Uc_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aUc_Uc_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aUc_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu16s, aUc_Uc_BFu16s)
//============================================================================



static void Test_aUc_Uc_BFu17i()
{
  {
    init_simple_test("aUc_Uc_BFu17i");
    static STRUCT_IF_C aUc_Uc_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aUc_Uc_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aUc_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu17i, aUc_Uc_BFu17i)
//============================================================================



static void Test_aUc_Uc_BFu17ll()
{
  {
    init_simple_test("aUc_Uc_BFu17ll");
    static STRUCT_IF_C aUc_Uc_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aUc_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aUc_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu17ll, aUc_Uc_BFu17ll)
//============================================================================



static void Test_aUc_Uc_BFu1c()
{
  {
    init_simple_test("aUc_Uc_BFu1c");
    static STRUCT_IF_C aUc_Uc_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aUc_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu1c, aUc_Uc_BFu1c)
//============================================================================



static void Test_aUc_Uc_BFu1i()
{
  {
    init_simple_test("aUc_Uc_BFu1i");
    static STRUCT_IF_C aUc_Uc_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aUc_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu1i, aUc_Uc_BFu1i)
//============================================================================



static void Test_aUc_Uc_BFu1ll()
{
  {
    init_simple_test("aUc_Uc_BFu1ll");
    static STRUCT_IF_C aUc_Uc_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aUc_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu1ll, aUc_Uc_BFu1ll)
//============================================================================



static void Test_aUc_Uc_BFu1s()
{
  {
    init_simple_test("aUc_Uc_BFu1s");
    static STRUCT_IF_C aUc_Uc_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aUc_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu1s, aUc_Uc_BFu1s)
//============================================================================



static void Test_aUc_Uc_BFu31i()
{
  {
    init_simple_test("aUc_Uc_BFu31i");
    static STRUCT_IF_C aUc_Uc_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aUc_Uc_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aUc_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu31i, aUc_Uc_BFu31i)
//============================================================================



static void Test_aUc_Uc_BFu31ll()
{
  {
    init_simple_test("aUc_Uc_BFu31ll");
    static STRUCT_IF_C aUc_Uc_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aUc_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aUc_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu31ll, aUc_Uc_BFu31ll)
//============================================================================



static void Test_aUc_Uc_BFu32i()
{
  {
    init_simple_test("aUc_Uc_BFu32i");
    static STRUCT_IF_C aUc_Uc_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aUc_Uc_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aUc_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu32i, aUc_Uc_BFu32i)
//============================================================================



static void Test_aUc_Uc_BFu32ll()
{
  {
    init_simple_test("aUc_Uc_BFu32ll");
    static STRUCT_IF_C aUc_Uc_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aUc_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aUc_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu32ll, aUc_Uc_BFu32ll)
//============================================================================



static void Test_aUc_Uc_BFu33()
{
  {
    init_simple_test("aUc_Uc_BFu33");
    static STRUCT_IF_C aUc_Uc_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu33.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aUc_Uc_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aUc_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu33, aUc_Uc_BFu33)
//============================================================================



static void Test_aUc_Uc_BFu7c()
{
  {
    init_simple_test("aUc_Uc_BFu7c");
    static STRUCT_IF_C aUc_Uc_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aUc_Uc_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aUc_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu7c, aUc_Uc_BFu7c)
//============================================================================



static void Test_aUc_Uc_BFu7i()
{
  {
    init_simple_test("aUc_Uc_BFu7i");
    static STRUCT_IF_C aUc_Uc_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aUc_Uc_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aUc_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu7i, aUc_Uc_BFu7i)
//============================================================================



static void Test_aUc_Uc_BFu7ll()
{
  {
    init_simple_test("aUc_Uc_BFu7ll");
    static STRUCT_IF_C aUc_Uc_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aUc_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aUc_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu7ll, aUc_Uc_BFu7ll)
//============================================================================



static void Test_aUc_Uc_BFu7s()
{
  {
    init_simple_test("aUc_Uc_BFu7s");
    static STRUCT_IF_C aUc_Uc_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aUc_Uc_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aUc_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu7s, aUc_Uc_BFu7s)
//============================================================================



static void Test_aUc_Uc_BFu8c()
{
  {
    init_simple_test("aUc_Uc_BFu8c");
    static STRUCT_IF_C aUc_Uc_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aUc_Uc_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aUc_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu8c, aUc_Uc_BFu8c)
//============================================================================



static void Test_aUc_Uc_BFu8i()
{
  {
    init_simple_test("aUc_Uc_BFu8i");
    static STRUCT_IF_C aUc_Uc_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aUc_Uc_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aUc_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu8i, aUc_Uc_BFu8i)
//============================================================================



static void Test_aUc_Uc_BFu8ll()
{
  {
    init_simple_test("aUc_Uc_BFu8ll");
    static STRUCT_IF_C aUc_Uc_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aUc_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aUc_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu8ll, aUc_Uc_BFu8ll)
//============================================================================



static void Test_aUc_Uc_BFu8s()
{
  {
    init_simple_test("aUc_Uc_BFu8s");
    static STRUCT_IF_C aUc_Uc_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aUc_Uc_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aUc_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu8s, aUc_Uc_BFu8s)
//============================================================================



static void Test_aUc_Uc_BFu9i()
{
  {
    init_simple_test("aUc_Uc_BFu9i");
    static STRUCT_IF_C aUc_Uc_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aUc_Uc_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aUc_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu9i, aUc_Uc_BFu9i)
//============================================================================



static void Test_aUc_Uc_BFu9ll()
{
  {
    init_simple_test("aUc_Uc_BFu9ll");
    static STRUCT_IF_C aUc_Uc_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aUc_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aUc_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu9ll, aUc_Uc_BFu9ll)
//============================================================================



static void Test_aUc_Uc_BFu9s()
{
  {
    init_simple_test("aUc_Uc_BFu9s");
    static STRUCT_IF_C aUc_Uc_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_Uc_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aUc_Uc_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aUc_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_BFu9s, aUc_Uc_BFu9s)
//============================================================================



static void Test_aUc_Uc_C()
{
  {
    init_simple_test("aUc_Uc_C");
    STRUCT_IF_C aUc_Uc_C lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_C)");
    check_field_offset(lv, v1, 0, "aUc_Uc_C.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_C.v2");
    check_field_offset(lv, v3, 2, "aUc_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_C, aUc_Uc_C)
//============================================================================



static void Test_aUc_Uc_D()
{
  {
    init_simple_test("aUc_Uc_D");
    STRUCT_IF_C aUc_Uc_D lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_D)");
    check_field_offset(lv, v1, 0, "aUc_Uc_D.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_D.v2");
    check_field_offset(lv, v3, 2, "aUc_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_D, aUc_Uc_D)
//============================================================================



static void Test_aUc_Uc_F()
{
  {
    init_simple_test("aUc_Uc_F");
    STRUCT_IF_C aUc_Uc_F lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_F)");
    check_field_offset(lv, v1, 0, "aUc_Uc_F.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_F.v2");
    check_field_offset(lv, v3, 2, "aUc_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_F, aUc_Uc_F)
//============================================================================



static void Test_aUc_Uc_I()
{
  {
    init_simple_test("aUc_Uc_I");
    STRUCT_IF_C aUc_Uc_I lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_I)");
    check_field_offset(lv, v1, 0, "aUc_Uc_I.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_I.v2");
    check_field_offset(lv, v3, 2, "aUc_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_I, aUc_Uc_I)
//============================================================================



static void Test_aUc_Uc_Ip()
{
  {
    init_simple_test("aUc_Uc_Ip");
    STRUCT_IF_C aUc_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_Ip)");
    check_field_offset(lv, v1, 0, "aUc_Uc_Ip.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_Ip.v2");
    check_field_offset(lv, v3, 2, "aUc_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_Ip, aUc_Uc_Ip)
//============================================================================



static void Test_aUc_Uc_L()
{
  {
    init_simple_test("aUc_Uc_L");
    STRUCT_IF_C aUc_Uc_L lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_L)");
    check_field_offset(lv, v1, 0, "aUc_Uc_L.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_L.v2");
    check_field_offset(lv, v3, 2, "aUc_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_L, aUc_Uc_L)
//============================================================================



static void Test_aUc_Uc_S()
{
  {
    init_simple_test("aUc_Uc_S");
    STRUCT_IF_C aUc_Uc_S lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_S)");
    check_field_offset(lv, v1, 0, "aUc_Uc_S.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_S.v2");
    check_field_offset(lv, v3, 2, "aUc_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_S, aUc_Uc_S)
//============================================================================



static void Test_aUc_Uc_Uc()
{
  {
    init_simple_test("aUc_Uc_Uc");
    STRUCT_IF_C aUc_Uc_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_Uc)");
    check_field_offset(lv, v1, 0, "aUc_Uc_Uc.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_Uc.v2");
    check_field_offset(lv, v3, 2, "aUc_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_Uc, aUc_Uc_Uc)
//============================================================================



static void Test_aUc_Uc_Ui()
{
  {
    init_simple_test("aUc_Uc_Ui");
    STRUCT_IF_C aUc_Uc_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_Ui)");
    check_field_offset(lv, v1, 0, "aUc_Uc_Ui.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_Ui.v2");
    check_field_offset(lv, v3, 2, "aUc_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_Ui, aUc_Uc_Ui)
//============================================================================



static void Test_aUc_Uc_Ul()
{
  {
    init_simple_test("aUc_Uc_Ul");
    STRUCT_IF_C aUc_Uc_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_Ul)");
    check_field_offset(lv, v1, 0, "aUc_Uc_Ul.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_Ul.v2");
    check_field_offset(lv, v3, 2, "aUc_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_Ul, aUc_Uc_Ul)
//============================================================================



static void Test_aUc_Uc_Us()
{
  {
    init_simple_test("aUc_Uc_Us");
    STRUCT_IF_C aUc_Uc_Us lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_Us)");
    check_field_offset(lv, v1, 0, "aUc_Uc_Us.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_Us.v2");
    check_field_offset(lv, v3, 2, "aUc_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_Us, aUc_Uc_Us)
//============================================================================



static void Test_aUc_Uc_Vp()
{
  {
    init_simple_test("aUc_Uc_Vp");
    STRUCT_IF_C aUc_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Uc_Vp)");
    check_field_offset(lv, v1, 0, "aUc_Uc_Vp.v1");
    check_field_offset(lv, v2, 1, "aUc_Uc_Vp.v2");
    check_field_offset(lv, v3, 2, "aUc_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Uc_Vp, aUc_Uc_Vp)
//============================================================================



static void Test_aUc_Ui()
{
  {
    init_simple_test("aUc_Ui");
    STRUCT_IF_C aUc_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui)");
    check_field_offset(lv, v1, 0, "aUc_Ui.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui, aUc_Ui)
//============================================================================



static void Test_aUc_Ui_BFu15i()
{
  {
    init_simple_test("aUc_Ui_BFu15i");
    static STRUCT_IF_C aUc_Ui_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aUc_Ui_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aUc_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu15i, aUc_Ui_BFu15i)
//============================================================================



static void Test_aUc_Ui_BFu15ll()
{
  {
    init_simple_test("aUc_Ui_BFu15ll");
    static STRUCT_IF_C aUc_Ui_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aUc_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aUc_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu15ll, aUc_Ui_BFu15ll)
//============================================================================



static void Test_aUc_Ui_BFu15s()
{
  {
    init_simple_test("aUc_Ui_BFu15s");
    static STRUCT_IF_C aUc_Ui_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aUc_Ui_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aUc_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu15s, aUc_Ui_BFu15s)
//============================================================================



static void Test_aUc_Ui_BFu16i()
{
  {
    init_simple_test("aUc_Ui_BFu16i");
    static STRUCT_IF_C aUc_Ui_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aUc_Ui_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aUc_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu16i, aUc_Ui_BFu16i)
//============================================================================



static void Test_aUc_Ui_BFu16ll()
{
  {
    init_simple_test("aUc_Ui_BFu16ll");
    static STRUCT_IF_C aUc_Ui_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aUc_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aUc_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu16ll, aUc_Ui_BFu16ll)
//============================================================================



static void Test_aUc_Ui_BFu16s()
{
  {
    init_simple_test("aUc_Ui_BFu16s");
    static STRUCT_IF_C aUc_Ui_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aUc_Ui_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aUc_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu16s, aUc_Ui_BFu16s)
//============================================================================



static void Test_aUc_Ui_BFu17i()
{
  {
    init_simple_test("aUc_Ui_BFu17i");
    static STRUCT_IF_C aUc_Ui_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aUc_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aUc_Ui_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aUc_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu17i, aUc_Ui_BFu17i)
//============================================================================



static void Test_aUc_Ui_BFu17ll()
{
  {
    init_simple_test("aUc_Ui_BFu17ll");
    static STRUCT_IF_C aUc_Ui_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aUc_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aUc_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aUc_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu17ll, aUc_Ui_BFu17ll)
//============================================================================



static void Test_aUc_Ui_BFu1c()
{
  {
    init_simple_test("aUc_Ui_BFu1c");
    static STRUCT_IF_C aUc_Ui_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aUc_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu1c, aUc_Ui_BFu1c)
//============================================================================



static void Test_aUc_Ui_BFu1i()
{
  {
    init_simple_test("aUc_Ui_BFu1i");
    static STRUCT_IF_C aUc_Ui_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aUc_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu1i, aUc_Ui_BFu1i)
//============================================================================



static void Test_aUc_Ui_BFu1ll()
{
  {
    init_simple_test("aUc_Ui_BFu1ll");
    static STRUCT_IF_C aUc_Ui_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aUc_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu1ll, aUc_Ui_BFu1ll)
//============================================================================



static void Test_aUc_Ui_BFu1s()
{
  {
    init_simple_test("aUc_Ui_BFu1s");
    static STRUCT_IF_C aUc_Ui_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aUc_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu1s, aUc_Ui_BFu1s)
//============================================================================



static void Test_aUc_Ui_BFu31i()
{
  {
    init_simple_test("aUc_Ui_BFu31i");
    static STRUCT_IF_C aUc_Ui_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aUc_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aUc_Ui_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aUc_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu31i, aUc_Ui_BFu31i)
//============================================================================



static void Test_aUc_Ui_BFu31ll()
{
  {
    init_simple_test("aUc_Ui_BFu31ll");
    static STRUCT_IF_C aUc_Ui_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aUc_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aUc_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aUc_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu31ll, aUc_Ui_BFu31ll)
//============================================================================



static void Test_aUc_Ui_BFu32i()
{
  {
    init_simple_test("aUc_Ui_BFu32i");
    static STRUCT_IF_C aUc_Ui_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aUc_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aUc_Ui_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aUc_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu32i, aUc_Ui_BFu32i)
//============================================================================



static void Test_aUc_Ui_BFu32ll()
{
  {
    init_simple_test("aUc_Ui_BFu32ll");
    static STRUCT_IF_C aUc_Ui_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aUc_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aUc_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aUc_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu32ll, aUc_Ui_BFu32ll)
//============================================================================



static void Test_aUc_Ui_BFu33()
{
  {
    init_simple_test("aUc_Ui_BFu33");
    static STRUCT_IF_C aUc_Ui_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu33.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aUc_Ui_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aUc_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu33, aUc_Ui_BFu33)
//============================================================================



static void Test_aUc_Ui_BFu7c()
{
  {
    init_simple_test("aUc_Ui_BFu7c");
    static STRUCT_IF_C aUc_Ui_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aUc_Ui_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aUc_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu7c, aUc_Ui_BFu7c)
//============================================================================



static void Test_aUc_Ui_BFu7i()
{
  {
    init_simple_test("aUc_Ui_BFu7i");
    static STRUCT_IF_C aUc_Ui_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aUc_Ui_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aUc_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu7i, aUc_Ui_BFu7i)
//============================================================================



static void Test_aUc_Ui_BFu7ll()
{
  {
    init_simple_test("aUc_Ui_BFu7ll");
    static STRUCT_IF_C aUc_Ui_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aUc_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aUc_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu7ll, aUc_Ui_BFu7ll)
//============================================================================



static void Test_aUc_Ui_BFu7s()
{
  {
    init_simple_test("aUc_Ui_BFu7s");
    static STRUCT_IF_C aUc_Ui_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aUc_Ui_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aUc_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu7s, aUc_Ui_BFu7s)
//============================================================================



static void Test_aUc_Ui_BFu8c()
{
  {
    init_simple_test("aUc_Ui_BFu8c");
    static STRUCT_IF_C aUc_Ui_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aUc_Ui_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aUc_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu8c, aUc_Ui_BFu8c)
//============================================================================



static void Test_aUc_Ui_BFu8i()
{
  {
    init_simple_test("aUc_Ui_BFu8i");
    static STRUCT_IF_C aUc_Ui_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aUc_Ui_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aUc_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu8i, aUc_Ui_BFu8i)
//============================================================================



static void Test_aUc_Ui_BFu8ll()
{
  {
    init_simple_test("aUc_Ui_BFu8ll");
    static STRUCT_IF_C aUc_Ui_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aUc_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aUc_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu8ll, aUc_Ui_BFu8ll)
//============================================================================



static void Test_aUc_Ui_BFu8s()
{
  {
    init_simple_test("aUc_Ui_BFu8s");
    static STRUCT_IF_C aUc_Ui_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aUc_Ui_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aUc_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu8s, aUc_Ui_BFu8s)
//============================================================================



static void Test_aUc_Ui_BFu9i()
{
  {
    init_simple_test("aUc_Ui_BFu9i");
    static STRUCT_IF_C aUc_Ui_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aUc_Ui_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aUc_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu9i, aUc_Ui_BFu9i)
//============================================================================



static void Test_aUc_Ui_BFu9ll()
{
  {
    init_simple_test("aUc_Ui_BFu9ll");
    static STRUCT_IF_C aUc_Ui_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aUc_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aUc_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu9ll, aUc_Ui_BFu9ll)
//============================================================================



static void Test_aUc_Ui_BFu9s()
{
  {
    init_simple_test("aUc_Ui_BFu9s");
    static STRUCT_IF_C aUc_Ui_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aUc_Ui_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aUc_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_BFu9s, aUc_Ui_BFu9s)
//============================================================================



static void Test_aUc_Ui_C()
{
  {
    init_simple_test("aUc_Ui_C");
    STRUCT_IF_C aUc_Ui_C lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_C)");
    check_field_offset(lv, v1, 0, "aUc_Ui_C.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_C.v2");
    check_field_offset(lv, v3, 5, "aUc_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_C, aUc_Ui_C)
//============================================================================



static void Test_aUc_Ui_D()
{
  {
    init_simple_test("aUc_Ui_D");
    STRUCT_IF_C aUc_Ui_D lv;
    check2(sizeof(lv), 13, "sizeof(aUc_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_D)");
    check_field_offset(lv, v1, 0, "aUc_Ui_D.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_D.v2");
    check_field_offset(lv, v3, 5, "aUc_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_D, aUc_Ui_D)
//============================================================================



static void Test_aUc_Ui_F()
{
  {
    init_simple_test("aUc_Ui_F");
    STRUCT_IF_C aUc_Ui_F lv;
    check2(sizeof(lv), 9, "sizeof(aUc_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_F)");
    check_field_offset(lv, v1, 0, "aUc_Ui_F.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_F.v2");
    check_field_offset(lv, v3, 5, "aUc_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_F, aUc_Ui_F)
//============================================================================



static void Test_aUc_Ui_I()
{
  {
    init_simple_test("aUc_Ui_I");
    STRUCT_IF_C aUc_Ui_I lv;
    check2(sizeof(lv), 9, "sizeof(aUc_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_I)");
    check_field_offset(lv, v1, 0, "aUc_Ui_I.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_I.v2");
    check_field_offset(lv, v3, 5, "aUc_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_I, aUc_Ui_I)
//============================================================================



static void Test_aUc_Ui_Ip()
{
  {
    init_simple_test("aUc_Ui_Ip");
    STRUCT_IF_C aUc_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_Ip)");
    check_field_offset(lv, v1, 0, "aUc_Ui_Ip.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_Ip.v2");
    check_field_offset(lv, v3, 5, "aUc_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_Ip, aUc_Ui_Ip)
//============================================================================



static void Test_aUc_Ui_L()
{
  {
    init_simple_test("aUc_Ui_L");
    STRUCT_IF_C aUc_Ui_L lv;
    check2(sizeof(lv), 13, "sizeof(aUc_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_L)");
    check_field_offset(lv, v1, 0, "aUc_Ui_L.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_L.v2");
    check_field_offset(lv, v3, 5, "aUc_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_L, aUc_Ui_L)
//============================================================================



static void Test_aUc_Ui_S()
{
  {
    init_simple_test("aUc_Ui_S");
    STRUCT_IF_C aUc_Ui_S lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_S)");
    check_field_offset(lv, v1, 0, "aUc_Ui_S.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_S.v2");
    check_field_offset(lv, v3, 5, "aUc_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_S, aUc_Ui_S)
//============================================================================



static void Test_aUc_Ui_Uc()
{
  {
    init_simple_test("aUc_Ui_Uc");
    STRUCT_IF_C aUc_Ui_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_Uc)");
    check_field_offset(lv, v1, 0, "aUc_Ui_Uc.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_Uc.v2");
    check_field_offset(lv, v3, 5, "aUc_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_Uc, aUc_Ui_Uc)
//============================================================================



static void Test_aUc_Ui_Ui()
{
  {
    init_simple_test("aUc_Ui_Ui");
    STRUCT_IF_C aUc_Ui_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aUc_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_Ui)");
    check_field_offset(lv, v1, 0, "aUc_Ui_Ui.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_Ui.v2");
    check_field_offset(lv, v3, 5, "aUc_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_Ui, aUc_Ui_Ui)
//============================================================================



static void Test_aUc_Ui_Ul()
{
  {
    init_simple_test("aUc_Ui_Ul");
    STRUCT_IF_C aUc_Ui_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aUc_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_Ul)");
    check_field_offset(lv, v1, 0, "aUc_Ui_Ul.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_Ul.v2");
    check_field_offset(lv, v3, 5, "aUc_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_Ul, aUc_Ui_Ul)
//============================================================================



static void Test_aUc_Ui_Us()
{
  {
    init_simple_test("aUc_Ui_Us");
    STRUCT_IF_C aUc_Ui_Us lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_Us)");
    check_field_offset(lv, v1, 0, "aUc_Ui_Us.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_Us.v2");
    check_field_offset(lv, v3, 5, "aUc_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_Us, aUc_Ui_Us)
//============================================================================



static void Test_aUc_Ui_Vp()
{
  {
    init_simple_test("aUc_Ui_Vp");
    STRUCT_IF_C aUc_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ui_Vp)");
    check_field_offset(lv, v1, 0, "aUc_Ui_Vp.v1");
    check_field_offset(lv, v2, 1, "aUc_Ui_Vp.v2");
    check_field_offset(lv, v3, 5, "aUc_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ui_Vp, aUc_Ui_Vp)
//============================================================================



static void Test_aUc_Ul()
{
  {
    init_simple_test("aUc_Ul");
    STRUCT_IF_C aUc_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aUc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul)");
    check_field_offset(lv, v1, 0, "aUc_Ul.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul, aUc_Ul)
//============================================================================



static void Test_aUc_Ul_BFu15i()
{
  {
    init_simple_test("aUc_Ul_BFu15i");
    static STRUCT_IF_C aUc_Ul_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUc_Ul_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUc_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu15i, aUc_Ul_BFu15i)
//============================================================================



static void Test_aUc_Ul_BFu15ll()
{
  {
    init_simple_test("aUc_Ul_BFu15ll");
    static STRUCT_IF_C aUc_Ul_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUc_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUc_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu15ll, aUc_Ul_BFu15ll)
//============================================================================



static void Test_aUc_Ul_BFu15s()
{
  {
    init_simple_test("aUc_Ul_BFu15s");
    static STRUCT_IF_C aUc_Ul_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aUc_Ul_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aUc_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu15s, aUc_Ul_BFu15s)
//============================================================================



static void Test_aUc_Ul_BFu16i()
{
  {
    init_simple_test("aUc_Ul_BFu16i");
    static STRUCT_IF_C aUc_Ul_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUc_Ul_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUc_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu16i, aUc_Ul_BFu16i)
//============================================================================



static void Test_aUc_Ul_BFu16ll()
{
  {
    init_simple_test("aUc_Ul_BFu16ll");
    static STRUCT_IF_C aUc_Ul_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUc_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUc_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu16ll, aUc_Ul_BFu16ll)
//============================================================================



static void Test_aUc_Ul_BFu16s()
{
  {
    init_simple_test("aUc_Ul_BFu16s");
    static STRUCT_IF_C aUc_Ul_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aUc_Ul_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aUc_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu16s, aUc_Ul_BFu16s)
//============================================================================



static void Test_aUc_Ul_BFu17i()
{
  {
    init_simple_test("aUc_Ul_BFu17i");
    static STRUCT_IF_C aUc_Ul_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aUc_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aUc_Ul_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aUc_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu17i, aUc_Ul_BFu17i)
//============================================================================



static void Test_aUc_Ul_BFu17ll()
{
  {
    init_simple_test("aUc_Ul_BFu17ll");
    static STRUCT_IF_C aUc_Ul_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aUc_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aUc_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aUc_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu17ll, aUc_Ul_BFu17ll)
//============================================================================



static void Test_aUc_Ul_BFu1c()
{
  {
    init_simple_test("aUc_Ul_BFu1c");
    static STRUCT_IF_C aUc_Ul_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUc_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu1c, aUc_Ul_BFu1c)
//============================================================================



static void Test_aUc_Ul_BFu1i()
{
  {
    init_simple_test("aUc_Ul_BFu1i");
    static STRUCT_IF_C aUc_Ul_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUc_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu1i, aUc_Ul_BFu1i)
//============================================================================



static void Test_aUc_Ul_BFu1ll()
{
  {
    init_simple_test("aUc_Ul_BFu1ll");
    static STRUCT_IF_C aUc_Ul_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUc_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu1ll, aUc_Ul_BFu1ll)
//============================================================================



static void Test_aUc_Ul_BFu1s()
{
  {
    init_simple_test("aUc_Ul_BFu1s");
    static STRUCT_IF_C aUc_Ul_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aUc_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu1s, aUc_Ul_BFu1s)
//============================================================================



static void Test_aUc_Ul_BFu31i()
{
  {
    init_simple_test("aUc_Ul_BFu31i");
    static STRUCT_IF_C aUc_Ul_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aUc_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUc_Ul_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUc_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu31i, aUc_Ul_BFu31i)
//============================================================================



static void Test_aUc_Ul_BFu31ll()
{
  {
    init_simple_test("aUc_Ul_BFu31ll");
    static STRUCT_IF_C aUc_Ul_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aUc_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aUc_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aUc_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu31ll, aUc_Ul_BFu31ll)
//============================================================================



static void Test_aUc_Ul_BFu32i()
{
  {
    init_simple_test("aUc_Ul_BFu32i");
    static STRUCT_IF_C aUc_Ul_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aUc_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUc_Ul_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUc_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu32i, aUc_Ul_BFu32i)
//============================================================================



static void Test_aUc_Ul_BFu32ll()
{
  {
    init_simple_test("aUc_Ul_BFu32ll");
    static STRUCT_IF_C aUc_Ul_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aUc_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aUc_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aUc_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu32ll, aUc_Ul_BFu32ll)
//============================================================================



static void Test_aUc_Ul_BFu33()
{
  {
    init_simple_test("aUc_Ul_BFu33");
    static STRUCT_IF_C aUc_Ul_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aUc_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu33.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aUc_Ul_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aUc_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu33, aUc_Ul_BFu33)
//============================================================================



static void Test_aUc_Ul_BFu7c()
{
  {
    init_simple_test("aUc_Ul_BFu7c");
    static STRUCT_IF_C aUc_Ul_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUc_Ul_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUc_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu7c, aUc_Ul_BFu7c)
//============================================================================



static void Test_aUc_Ul_BFu7i()
{
  {
    init_simple_test("aUc_Ul_BFu7i");
    static STRUCT_IF_C aUc_Ul_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUc_Ul_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUc_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu7i, aUc_Ul_BFu7i)
//============================================================================



static void Test_aUc_Ul_BFu7ll()
{
  {
    init_simple_test("aUc_Ul_BFu7ll");
    static STRUCT_IF_C aUc_Ul_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUc_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUc_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu7ll, aUc_Ul_BFu7ll)
//============================================================================



static void Test_aUc_Ul_BFu7s()
{
  {
    init_simple_test("aUc_Ul_BFu7s");
    static STRUCT_IF_C aUc_Ul_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aUc_Ul_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aUc_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu7s, aUc_Ul_BFu7s)
//============================================================================



static void Test_aUc_Ul_BFu8c()
{
  {
    init_simple_test("aUc_Ul_BFu8c");
    static STRUCT_IF_C aUc_Ul_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUc_Ul_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUc_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu8c, aUc_Ul_BFu8c)
//============================================================================



static void Test_aUc_Ul_BFu8i()
{
  {
    init_simple_test("aUc_Ul_BFu8i");
    static STRUCT_IF_C aUc_Ul_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUc_Ul_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUc_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu8i, aUc_Ul_BFu8i)
//============================================================================



static void Test_aUc_Ul_BFu8ll()
{
  {
    init_simple_test("aUc_Ul_BFu8ll");
    static STRUCT_IF_C aUc_Ul_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUc_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUc_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu8ll, aUc_Ul_BFu8ll)
//============================================================================



static void Test_aUc_Ul_BFu8s()
{
  {
    init_simple_test("aUc_Ul_BFu8s");
    static STRUCT_IF_C aUc_Ul_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aUc_Ul_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aUc_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu8s, aUc_Ul_BFu8s)
//============================================================================



static void Test_aUc_Ul_BFu9i()
{
  {
    init_simple_test("aUc_Ul_BFu9i");
    static STRUCT_IF_C aUc_Ul_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUc_Ul_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUc_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu9i, aUc_Ul_BFu9i)
//============================================================================



static void Test_aUc_Ul_BFu9ll()
{
  {
    init_simple_test("aUc_Ul_BFu9ll");
    static STRUCT_IF_C aUc_Ul_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUc_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUc_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu9ll, aUc_Ul_BFu9ll)
//============================================================================



static void Test_aUc_Ul_BFu9s()
{
  {
    init_simple_test("aUc_Ul_BFu9s");
    static STRUCT_IF_C aUc_Ul_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_Ul_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aUc_Ul_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aUc_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_BFu9s, aUc_Ul_BFu9s)
//============================================================================



static void Test_aUc_Ul_C()
{
  {
    init_simple_test("aUc_Ul_C");
    STRUCT_IF_C aUc_Ul_C lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_C)");
    check_field_offset(lv, v1, 0, "aUc_Ul_C.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_C.v2");
    check_field_offset(lv, v3, 9, "aUc_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_C, aUc_Ul_C)
//============================================================================



static void Test_aUc_Ul_D()
{
  {
    init_simple_test("aUc_Ul_D");
    STRUCT_IF_C aUc_Ul_D lv;
    check2(sizeof(lv), 17, "sizeof(aUc_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_D)");
    check_field_offset(lv, v1, 0, "aUc_Ul_D.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_D.v2");
    check_field_offset(lv, v3, 9, "aUc_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_D, aUc_Ul_D)
//============================================================================



static void Test_aUc_Ul_F()
{
  {
    init_simple_test("aUc_Ul_F");
    STRUCT_IF_C aUc_Ul_F lv;
    check2(sizeof(lv), 13, "sizeof(aUc_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_F)");
    check_field_offset(lv, v1, 0, "aUc_Ul_F.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_F.v2");
    check_field_offset(lv, v3, 9, "aUc_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_F, aUc_Ul_F)
//============================================================================



static void Test_aUc_Ul_I()
{
  {
    init_simple_test("aUc_Ul_I");
    STRUCT_IF_C aUc_Ul_I lv;
    check2(sizeof(lv), 13, "sizeof(aUc_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_I)");
    check_field_offset(lv, v1, 0, "aUc_Ul_I.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_I.v2");
    check_field_offset(lv, v3, 9, "aUc_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_I, aUc_Ul_I)
//============================================================================



static void Test_aUc_Ul_Ip()
{
  {
    init_simple_test("aUc_Ul_Ip");
    STRUCT_IF_C aUc_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUc_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_Ip)");
    check_field_offset(lv, v1, 0, "aUc_Ul_Ip.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_Ip.v2");
    check_field_offset(lv, v3, 9, "aUc_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_Ip, aUc_Ul_Ip)
//============================================================================



static void Test_aUc_Ul_L()
{
  {
    init_simple_test("aUc_Ul_L");
    STRUCT_IF_C aUc_Ul_L lv;
    check2(sizeof(lv), 17, "sizeof(aUc_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_L)");
    check_field_offset(lv, v1, 0, "aUc_Ul_L.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_L.v2");
    check_field_offset(lv, v3, 9, "aUc_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_L, aUc_Ul_L)
//============================================================================



static void Test_aUc_Ul_S()
{
  {
    init_simple_test("aUc_Ul_S");
    STRUCT_IF_C aUc_Ul_S lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_S)");
    check_field_offset(lv, v1, 0, "aUc_Ul_S.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_S.v2");
    check_field_offset(lv, v3, 9, "aUc_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_S, aUc_Ul_S)
//============================================================================



static void Test_aUc_Ul_Uc()
{
  {
    init_simple_test("aUc_Ul_Uc");
    STRUCT_IF_C aUc_Ul_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aUc_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_Uc)");
    check_field_offset(lv, v1, 0, "aUc_Ul_Uc.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_Uc.v2");
    check_field_offset(lv, v3, 9, "aUc_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_Uc, aUc_Ul_Uc)
//============================================================================



static void Test_aUc_Ul_Ui()
{
  {
    init_simple_test("aUc_Ul_Ui");
    STRUCT_IF_C aUc_Ul_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aUc_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_Ui)");
    check_field_offset(lv, v1, 0, "aUc_Ul_Ui.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_Ui.v2");
    check_field_offset(lv, v3, 9, "aUc_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_Ui, aUc_Ul_Ui)
//============================================================================



static void Test_aUc_Ul_Ul()
{
  {
    init_simple_test("aUc_Ul_Ul");
    STRUCT_IF_C aUc_Ul_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aUc_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_Ul)");
    check_field_offset(lv, v1, 0, "aUc_Ul_Ul.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_Ul.v2");
    check_field_offset(lv, v3, 9, "aUc_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_Ul, aUc_Ul_Ul)
//============================================================================



static void Test_aUc_Ul_Us()
{
  {
    init_simple_test("aUc_Ul_Us");
    STRUCT_IF_C aUc_Ul_Us lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_Us)");
    check_field_offset(lv, v1, 0, "aUc_Ul_Us.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_Us.v2");
    check_field_offset(lv, v3, 9, "aUc_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_Us, aUc_Ul_Us)
//============================================================================



static void Test_aUc_Ul_Vp()
{
  {
    init_simple_test("aUc_Ul_Vp");
    STRUCT_IF_C aUc_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUc_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Ul_Vp)");
    check_field_offset(lv, v1, 0, "aUc_Ul_Vp.v1");
    check_field_offset(lv, v2, 1, "aUc_Ul_Vp.v2");
    check_field_offset(lv, v3, 9, "aUc_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Ul_Vp, aUc_Ul_Vp)
//============================================================================



static void Test_aUc_Us()
{
  {
    init_simple_test("aUc_Us");
    STRUCT_IF_C aUc_Us lv;
    check2(sizeof(lv), 3, "sizeof(aUc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us)");
    check_field_offset(lv, v1, 0, "aUc_Us.v1");
    check_field_offset(lv, v2, 1, "aUc_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us, aUc_Us)
//============================================================================



static void Test_aUc_Us_BFu15i()
{
  {
    init_simple_test("aUc_Us_BFu15i");
    static STRUCT_IF_C aUc_Us_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aUc_Us_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aUc_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu15i, aUc_Us_BFu15i)
//============================================================================



static void Test_aUc_Us_BFu15ll()
{
  {
    init_simple_test("aUc_Us_BFu15ll");
    static STRUCT_IF_C aUc_Us_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aUc_Us_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aUc_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu15ll, aUc_Us_BFu15ll)
//============================================================================



static void Test_aUc_Us_BFu15s()
{
  {
    init_simple_test("aUc_Us_BFu15s");
    static STRUCT_IF_C aUc_Us_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aUc_Us_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aUc_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu15s, aUc_Us_BFu15s)
//============================================================================



static void Test_aUc_Us_BFu16i()
{
  {
    init_simple_test("aUc_Us_BFu16i");
    static STRUCT_IF_C aUc_Us_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aUc_Us_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aUc_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu16i, aUc_Us_BFu16i)
//============================================================================



static void Test_aUc_Us_BFu16ll()
{
  {
    init_simple_test("aUc_Us_BFu16ll");
    static STRUCT_IF_C aUc_Us_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aUc_Us_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aUc_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu16ll, aUc_Us_BFu16ll)
//============================================================================



static void Test_aUc_Us_BFu16s()
{
  {
    init_simple_test("aUc_Us_BFu16s");
    static STRUCT_IF_C aUc_Us_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aUc_Us_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aUc_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu16s, aUc_Us_BFu16s)
//============================================================================



static void Test_aUc_Us_BFu17i()
{
  {
    init_simple_test("aUc_Us_BFu17i");
    static STRUCT_IF_C aUc_Us_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aUc_Us_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aUc_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu17i, aUc_Us_BFu17i)
//============================================================================



static void Test_aUc_Us_BFu17ll()
{
  {
    init_simple_test("aUc_Us_BFu17ll");
    static STRUCT_IF_C aUc_Us_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aUc_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aUc_Us_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aUc_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu17ll, aUc_Us_BFu17ll)
//============================================================================



static void Test_aUc_Us_BFu1c()
{
  {
    init_simple_test("aUc_Us_BFu1c");
    static STRUCT_IF_C aUc_Us_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aUc_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu1c, aUc_Us_BFu1c)
//============================================================================



static void Test_aUc_Us_BFu1i()
{
  {
    init_simple_test("aUc_Us_BFu1i");
    static STRUCT_IF_C aUc_Us_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aUc_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu1i, aUc_Us_BFu1i)
//============================================================================



static void Test_aUc_Us_BFu1ll()
{
  {
    init_simple_test("aUc_Us_BFu1ll");
    static STRUCT_IF_C aUc_Us_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aUc_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu1ll, aUc_Us_BFu1ll)
//============================================================================



static void Test_aUc_Us_BFu1s()
{
  {
    init_simple_test("aUc_Us_BFu1s");
    static STRUCT_IF_C aUc_Us_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aUc_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu1s, aUc_Us_BFu1s)
//============================================================================



static void Test_aUc_Us_BFu31i()
{
  {
    init_simple_test("aUc_Us_BFu31i");
    static STRUCT_IF_C aUc_Us_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aUc_Us_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aUc_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu31i, aUc_Us_BFu31i)
//============================================================================



static void Test_aUc_Us_BFu31ll()
{
  {
    init_simple_test("aUc_Us_BFu31ll");
    static STRUCT_IF_C aUc_Us_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aUc_Us_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aUc_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu31ll, aUc_Us_BFu31ll)
//============================================================================



static void Test_aUc_Us_BFu32i()
{
  {
    init_simple_test("aUc_Us_BFu32i");
    static STRUCT_IF_C aUc_Us_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aUc_Us_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aUc_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu32i, aUc_Us_BFu32i)
//============================================================================



static void Test_aUc_Us_BFu32ll()
{
  {
    init_simple_test("aUc_Us_BFu32ll");
    static STRUCT_IF_C aUc_Us_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aUc_Us_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aUc_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu32ll, aUc_Us_BFu32ll)
//============================================================================



static void Test_aUc_Us_BFu33()
{
  {
    init_simple_test("aUc_Us_BFu33");
    static STRUCT_IF_C aUc_Us_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aUc_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu33.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aUc_Us_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aUc_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu33, aUc_Us_BFu33)
//============================================================================



static void Test_aUc_Us_BFu7c()
{
  {
    init_simple_test("aUc_Us_BFu7c");
    static STRUCT_IF_C aUc_Us_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aUc_Us_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aUc_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu7c, aUc_Us_BFu7c)
//============================================================================



static void Test_aUc_Us_BFu7i()
{
  {
    init_simple_test("aUc_Us_BFu7i");
    static STRUCT_IF_C aUc_Us_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aUc_Us_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aUc_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu7i, aUc_Us_BFu7i)
//============================================================================



static void Test_aUc_Us_BFu7ll()
{
  {
    init_simple_test("aUc_Us_BFu7ll");
    static STRUCT_IF_C aUc_Us_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aUc_Us_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aUc_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu7ll, aUc_Us_BFu7ll)
//============================================================================



static void Test_aUc_Us_BFu7s()
{
  {
    init_simple_test("aUc_Us_BFu7s");
    static STRUCT_IF_C aUc_Us_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aUc_Us_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aUc_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu7s, aUc_Us_BFu7s)
//============================================================================



static void Test_aUc_Us_BFu8c()
{
  {
    init_simple_test("aUc_Us_BFu8c");
    static STRUCT_IF_C aUc_Us_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aUc_Us_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aUc_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu8c, aUc_Us_BFu8c)
//============================================================================



static void Test_aUc_Us_BFu8i()
{
  {
    init_simple_test("aUc_Us_BFu8i");
    static STRUCT_IF_C aUc_Us_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aUc_Us_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aUc_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu8i, aUc_Us_BFu8i)
//============================================================================



static void Test_aUc_Us_BFu8ll()
{
  {
    init_simple_test("aUc_Us_BFu8ll");
    static STRUCT_IF_C aUc_Us_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aUc_Us_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aUc_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu8ll, aUc_Us_BFu8ll)
//============================================================================



static void Test_aUc_Us_BFu8s()
{
  {
    init_simple_test("aUc_Us_BFu8s");
    static STRUCT_IF_C aUc_Us_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aUc_Us_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aUc_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu8s, aUc_Us_BFu8s)
//============================================================================



static void Test_aUc_Us_BFu9i()
{
  {
    init_simple_test("aUc_Us_BFu9i");
    static STRUCT_IF_C aUc_Us_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aUc_Us_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aUc_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu9i, aUc_Us_BFu9i)
//============================================================================



static void Test_aUc_Us_BFu9ll()
{
  {
    init_simple_test("aUc_Us_BFu9ll");
    static STRUCT_IF_C aUc_Us_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aUc_Us_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aUc_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu9ll, aUc_Us_BFu9ll)
//============================================================================



static void Test_aUc_Us_BFu9s()
{
  {
    init_simple_test("aUc_Us_BFu9s");
    static STRUCT_IF_C aUc_Us_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_Us_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aUc_Us_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aUc_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_BFu9s, aUc_Us_BFu9s)
//============================================================================



static void Test_aUc_Us_C()
{
  {
    init_simple_test("aUc_Us_C");
    STRUCT_IF_C aUc_Us_C lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_C)");
    check_field_offset(lv, v1, 0, "aUc_Us_C.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_C.v2");
    check_field_offset(lv, v3, 3, "aUc_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_C, aUc_Us_C)
//============================================================================



static void Test_aUc_Us_D()
{
  {
    init_simple_test("aUc_Us_D");
    STRUCT_IF_C aUc_Us_D lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_D)");
    check_field_offset(lv, v1, 0, "aUc_Us_D.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_D.v2");
    check_field_offset(lv, v3, 3, "aUc_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_D, aUc_Us_D)
//============================================================================



static void Test_aUc_Us_F()
{
  {
    init_simple_test("aUc_Us_F");
    STRUCT_IF_C aUc_Us_F lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_F)");
    check_field_offset(lv, v1, 0, "aUc_Us_F.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_F.v2");
    check_field_offset(lv, v3, 3, "aUc_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_F, aUc_Us_F)
//============================================================================



static void Test_aUc_Us_I()
{
  {
    init_simple_test("aUc_Us_I");
    STRUCT_IF_C aUc_Us_I lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_I)");
    check_field_offset(lv, v1, 0, "aUc_Us_I.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_I.v2");
    check_field_offset(lv, v3, 3, "aUc_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_I, aUc_Us_I)
//============================================================================



static void Test_aUc_Us_Ip()
{
  {
    init_simple_test("aUc_Us_Ip");
    STRUCT_IF_C aUc_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_Ip)");
    check_field_offset(lv, v1, 0, "aUc_Us_Ip.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_Ip.v2");
    check_field_offset(lv, v3, 3, "aUc_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_Ip, aUc_Us_Ip)
//============================================================================



static void Test_aUc_Us_L()
{
  {
    init_simple_test("aUc_Us_L");
    STRUCT_IF_C aUc_Us_L lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_L)");
    check_field_offset(lv, v1, 0, "aUc_Us_L.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_L.v2");
    check_field_offset(lv, v3, 3, "aUc_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_L, aUc_Us_L)
//============================================================================



static void Test_aUc_Us_S()
{
  {
    init_simple_test("aUc_Us_S");
    STRUCT_IF_C aUc_Us_S lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_S)");
    check_field_offset(lv, v1, 0, "aUc_Us_S.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_S.v2");
    check_field_offset(lv, v3, 3, "aUc_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_S, aUc_Us_S)
//============================================================================



static void Test_aUc_Us_Uc()
{
  {
    init_simple_test("aUc_Us_Uc");
    STRUCT_IF_C aUc_Us_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aUc_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_Uc)");
    check_field_offset(lv, v1, 0, "aUc_Us_Uc.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_Uc.v2");
    check_field_offset(lv, v3, 3, "aUc_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_Uc, aUc_Us_Uc)
//============================================================================



static void Test_aUc_Us_Ui()
{
  {
    init_simple_test("aUc_Us_Ui");
    STRUCT_IF_C aUc_Us_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aUc_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_Ui)");
    check_field_offset(lv, v1, 0, "aUc_Us_Ui.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_Ui.v2");
    check_field_offset(lv, v3, 3, "aUc_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_Ui, aUc_Us_Ui)
//============================================================================



static void Test_aUc_Us_Ul()
{
  {
    init_simple_test("aUc_Us_Ul");
    STRUCT_IF_C aUc_Us_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aUc_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_Ul)");
    check_field_offset(lv, v1, 0, "aUc_Us_Ul.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_Ul.v2");
    check_field_offset(lv, v3, 3, "aUc_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_Ul, aUc_Us_Ul)
//============================================================================



static void Test_aUc_Us_Us()
{
  {
    init_simple_test("aUc_Us_Us");
    STRUCT_IF_C aUc_Us_Us lv;
    check2(sizeof(lv), 5, "sizeof(aUc_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_Us)");
    check_field_offset(lv, v1, 0, "aUc_Us_Us.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_Us.v2");
    check_field_offset(lv, v3, 3, "aUc_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_Us, aUc_Us_Us)
//============================================================================



static void Test_aUc_Us_Vp()
{
  {
    init_simple_test("aUc_Us_Vp");
    STRUCT_IF_C aUc_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Us_Vp)");
    check_field_offset(lv, v1, 0, "aUc_Us_Vp.v1");
    check_field_offset(lv, v2, 1, "aUc_Us_Vp.v2");
    check_field_offset(lv, v3, 3, "aUc_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Us_Vp, aUc_Us_Vp)
//============================================================================



static void Test_aUc_Vp()
{
  {
    init_simple_test("aUc_Vp");
    STRUCT_IF_C aUc_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aUc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp)");
    check_field_offset(lv, v1, 0, "aUc_Vp.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp, aUc_Vp)
//============================================================================



static void Test_aUc_Vp_BFu15i()
{
  {
    init_simple_test("aUc_Vp_BFu15i");
    static STRUCT_IF_C aUc_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aUc_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aUc_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu15i, aUc_Vp_BFu15i)
//============================================================================



static void Test_aUc_Vp_BFu15ll()
{
  {
    init_simple_test("aUc_Vp_BFu15ll");
    static STRUCT_IF_C aUc_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aUc_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aUc_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu15ll, aUc_Vp_BFu15ll)
//============================================================================



static void Test_aUc_Vp_BFu15s()
{
  {
    init_simple_test("aUc_Vp_BFu15s");
    static STRUCT_IF_C aUc_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aUc_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aUc_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu15s, aUc_Vp_BFu15s)
//============================================================================



static void Test_aUc_Vp_BFu16i()
{
  {
    init_simple_test("aUc_Vp_BFu16i");
    static STRUCT_IF_C aUc_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aUc_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aUc_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu16i, aUc_Vp_BFu16i)
//============================================================================



static void Test_aUc_Vp_BFu16ll()
{
  {
    init_simple_test("aUc_Vp_BFu16ll");
    static STRUCT_IF_C aUc_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aUc_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aUc_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu16ll, aUc_Vp_BFu16ll)
//============================================================================



static void Test_aUc_Vp_BFu16s()
{
  {
    init_simple_test("aUc_Vp_BFu16s");
    static STRUCT_IF_C aUc_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aUc_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aUc_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu16s, aUc_Vp_BFu16s)
//============================================================================



static void Test_aUc_Vp_BFu17i()
{
  {
    init_simple_test("aUc_Vp_BFu17i");
    static STRUCT_IF_C aUc_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aUc_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aUc_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu17i, aUc_Vp_BFu17i)
//============================================================================



static void Test_aUc_Vp_BFu17ll()
{
  {
    init_simple_test("aUc_Vp_BFu17ll");
    static STRUCT_IF_C aUc_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aUc_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aUc_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aUc_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu17ll, aUc_Vp_BFu17ll)
//============================================================================



static void Test_aUc_Vp_BFu1c()
{
  {
    init_simple_test("aUc_Vp_BFu1c");
    static STRUCT_IF_C aUc_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aUc_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu1c, aUc_Vp_BFu1c)
//============================================================================



static void Test_aUc_Vp_BFu1i()
{
  {
    init_simple_test("aUc_Vp_BFu1i");
    static STRUCT_IF_C aUc_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aUc_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu1i, aUc_Vp_BFu1i)
//============================================================================



static void Test_aUc_Vp_BFu1ll()
{
  {
    init_simple_test("aUc_Vp_BFu1ll");
    static STRUCT_IF_C aUc_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aUc_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu1ll, aUc_Vp_BFu1ll)
//============================================================================



static void Test_aUc_Vp_BFu1s()
{
  {
    init_simple_test("aUc_Vp_BFu1s");
    static STRUCT_IF_C aUc_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aUc_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu1s, aUc_Vp_BFu1s)
//============================================================================



static void Test_aUc_Vp_BFu31i()
{
  {
    init_simple_test("aUc_Vp_BFu31i");
    static STRUCT_IF_C aUc_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aUc_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aUc_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu31i, aUc_Vp_BFu31i)
//============================================================================



static void Test_aUc_Vp_BFu31ll()
{
  {
    init_simple_test("aUc_Vp_BFu31ll");
    static STRUCT_IF_C aUc_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aUc_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aUc_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu31ll, aUc_Vp_BFu31ll)
//============================================================================



static void Test_aUc_Vp_BFu32i()
{
  {
    init_simple_test("aUc_Vp_BFu32i");
    static STRUCT_IF_C aUc_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aUc_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aUc_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu32i, aUc_Vp_BFu32i)
//============================================================================



static void Test_aUc_Vp_BFu32ll()
{
  {
    init_simple_test("aUc_Vp_BFu32ll");
    static STRUCT_IF_C aUc_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aUc_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aUc_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu32ll, aUc_Vp_BFu32ll)
//============================================================================



static void Test_aUc_Vp_BFu33()
{
  {
    init_simple_test("aUc_Vp_BFu33");
    static STRUCT_IF_C aUc_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUc_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu33.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aUc_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aUc_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu33, aUc_Vp_BFu33)
//============================================================================



static void Test_aUc_Vp_BFu7c()
{
  {
    init_simple_test("aUc_Vp_BFu7c");
    static STRUCT_IF_C aUc_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aUc_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aUc_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu7c, aUc_Vp_BFu7c)
//============================================================================



static void Test_aUc_Vp_BFu7i()
{
  {
    init_simple_test("aUc_Vp_BFu7i");
    static STRUCT_IF_C aUc_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aUc_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aUc_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu7i, aUc_Vp_BFu7i)
//============================================================================



static void Test_aUc_Vp_BFu7ll()
{
  {
    init_simple_test("aUc_Vp_BFu7ll");
    static STRUCT_IF_C aUc_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aUc_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aUc_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu7ll, aUc_Vp_BFu7ll)
//============================================================================



static void Test_aUc_Vp_BFu7s()
{
  {
    init_simple_test("aUc_Vp_BFu7s");
    static STRUCT_IF_C aUc_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aUc_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aUc_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu7s, aUc_Vp_BFu7s)
//============================================================================



static void Test_aUc_Vp_BFu8c()
{
  {
    init_simple_test("aUc_Vp_BFu8c");
    static STRUCT_IF_C aUc_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aUc_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aUc_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu8c, aUc_Vp_BFu8c)
//============================================================================



static void Test_aUc_Vp_BFu8i()
{
  {
    init_simple_test("aUc_Vp_BFu8i");
    static STRUCT_IF_C aUc_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aUc_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aUc_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu8i, aUc_Vp_BFu8i)
//============================================================================



static void Test_aUc_Vp_BFu8ll()
{
  {
    init_simple_test("aUc_Vp_BFu8ll");
    static STRUCT_IF_C aUc_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aUc_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aUc_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu8ll, aUc_Vp_BFu8ll)
//============================================================================



static void Test_aUc_Vp_BFu8s()
{
  {
    init_simple_test("aUc_Vp_BFu8s");
    static STRUCT_IF_C aUc_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aUc_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aUc_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu8s, aUc_Vp_BFu8s)
//============================================================================



static void Test_aUc_Vp_BFu9i()
{
  {
    init_simple_test("aUc_Vp_BFu9i");
    static STRUCT_IF_C aUc_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aUc_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aUc_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu9i, aUc_Vp_BFu9i)
//============================================================================



static void Test_aUc_Vp_BFu9ll()
{
  {
    init_simple_test("aUc_Vp_BFu9ll");
    static STRUCT_IF_C aUc_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aUc_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aUc_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu9ll, aUc_Vp_BFu9ll)
//============================================================================



static void Test_aUc_Vp_BFu9s()
{
  {
    init_simple_test("aUc_Vp_BFu9s");
    static STRUCT_IF_C aUc_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "aUc_Vp_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aUc_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aUc_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_BFu9s, aUc_Vp_BFu9s)
//============================================================================



static void Test_aUc_Vp_C()
{
  {
    init_simple_test("aUc_Vp_C");
    STRUCT_IF_C aUc_Vp_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_C)");
    check_field_offset(lv, v1, 0, "aUc_Vp_C.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_C, aUc_Vp_C)
//============================================================================



static void Test_aUc_Vp_D()
{
  {
    init_simple_test("aUc_Vp_D");
    STRUCT_IF_C aUc_Vp_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUc_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_D)");
    check_field_offset(lv, v1, 0, "aUc_Vp_D.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_D, aUc_Vp_D)
//============================================================================



static void Test_aUc_Vp_F()
{
  {
    init_simple_test("aUc_Vp_F");
    STRUCT_IF_C aUc_Vp_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_F)");
    check_field_offset(lv, v1, 0, "aUc_Vp_F.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_F, aUc_Vp_F)
//============================================================================



static void Test_aUc_Vp_I()
{
  {
    init_simple_test("aUc_Vp_I");
    STRUCT_IF_C aUc_Vp_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_I)");
    check_field_offset(lv, v1, 0, "aUc_Vp_I.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_I, aUc_Vp_I)
//============================================================================



static void Test_aUc_Vp_Ip()
{
  {
    init_simple_test("aUc_Vp_Ip");
    STRUCT_IF_C aUc_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aUc_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_Ip)");
    check_field_offset(lv, v1, 0, "aUc_Vp_Ip.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_Ip, aUc_Vp_Ip)
//============================================================================



static void Test_aUc_Vp_L()
{
  {
    init_simple_test("aUc_Vp_L");
    STRUCT_IF_C aUc_Vp_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUc_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_L)");
    check_field_offset(lv, v1, 0, "aUc_Vp_L.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_L, aUc_Vp_L)
//============================================================================



static void Test_aUc_Vp_S()
{
  {
    init_simple_test("aUc_Vp_S");
    STRUCT_IF_C aUc_Vp_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_S)");
    check_field_offset(lv, v1, 0, "aUc_Vp_S.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_S, aUc_Vp_S)
//============================================================================



static void Test_aUc_Vp_Uc()
{
  {
    init_simple_test("aUc_Vp_Uc");
    STRUCT_IF_C aUc_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aUc_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_Uc)");
    check_field_offset(lv, v1, 0, "aUc_Vp_Uc.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_Uc, aUc_Vp_Uc)
//============================================================================



static void Test_aUc_Vp_Ui()
{
  {
    init_simple_test("aUc_Vp_Ui");
    STRUCT_IF_C aUc_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUc_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_Ui)");
    check_field_offset(lv, v1, 0, "aUc_Vp_Ui.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_Ui, aUc_Vp_Ui)
//============================================================================



static void Test_aUc_Vp_Ul()
{
  {
    init_simple_test("aUc_Vp_Ul");
    STRUCT_IF_C aUc_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aUc_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_Ul)");
    check_field_offset(lv, v1, 0, "aUc_Vp_Ul.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_Ul, aUc_Vp_Ul)
//============================================================================



static void Test_aUc_Vp_Us()
{
  {
    init_simple_test("aUc_Vp_Us");
    STRUCT_IF_C aUc_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aUc_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_Us)");
    check_field_offset(lv, v1, 0, "aUc_Vp_Us.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_Us, aUc_Vp_Us)
//============================================================================



static void Test_aUc_Vp_Vp()
{
  {
    init_simple_test("aUc_Vp_Vp");
    STRUCT_IF_C aUc_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aUc_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUc_Vp_Vp)");
    check_field_offset(lv, v1, 0, "aUc_Vp_Vp.v1");
    check_field_offset(lv, v2, 1, "aUc_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aUc_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUc_Vp_Vp, aUc_Vp_Vp)
//============================================================================



static void Test_aUi()
{
  {
    init_simple_test("aUi");
    STRUCT_IF_C aUi lv;
    check2(sizeof(lv), 4, "sizeof(aUi)");
    check2(__alignof__(lv), 1, "__alignof__(aUi)");
    check_field_offset(lv, v1, 0, "aUi.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi, aUi)
//============================================================================



static void Test_aUi_BFu15i()
{
  {
    init_simple_test("aUi_BFu15i");
    static STRUCT_IF_C aUi_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i, aUi_BFu15i)
//============================================================================



static void Test_aUi_BFu15i_BFu15i()
{
  {
    init_simple_test("aUi_BFu15i_BFu15i");
    static STRUCT_IF_C aUi_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aUi_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu15i, aUi_BFu15i_BFu15i)
//============================================================================



static void Test_aUi_BFu15i_BFu15ll()
{
  {
    init_simple_test("aUi_BFu15i_BFu15ll");
    static STRUCT_IF_C aUi_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aUi_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu15ll, aUi_BFu15i_BFu15ll)
//============================================================================



static void Test_aUi_BFu15i_BFu15s()
{
  {
    init_simple_test("aUi_BFu15i_BFu15s");
    static STRUCT_IF_C aUi_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aUi_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu15s, aUi_BFu15i_BFu15s)
//============================================================================



static void Test_aUi_BFu15i_BFu16i()
{
  {
    init_simple_test("aUi_BFu15i_BFu16i");
    static STRUCT_IF_C aUi_BFu15i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aUi_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aUi_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu16i, aUi_BFu15i_BFu16i)
//============================================================================



static void Test_aUi_BFu15i_BFu16ll()
{
  {
    init_simple_test("aUi_BFu15i_BFu16ll");
    static STRUCT_IF_C aUi_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aUi_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aUi_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu16ll, aUi_BFu15i_BFu16ll)
//============================================================================



static void Test_aUi_BFu15i_BFu16s()
{
  {
    init_simple_test("aUi_BFu15i_BFu16s");
    static STRUCT_IF_C aUi_BFu15i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aUi_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aUi_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu16s, aUi_BFu15i_BFu16s)
//============================================================================



static void Test_aUi_BFu15i_BFu17i()
{
  {
    init_simple_test("aUi_BFu15i_BFu17i");
    static STRUCT_IF_C aUi_BFu15i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aUi_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aUi_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu17i, aUi_BFu15i_BFu17i)
//============================================================================



static void Test_aUi_BFu15i_BFu17ll()
{
  {
    init_simple_test("aUi_BFu15i_BFu17ll");
    static STRUCT_IF_C aUi_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aUi_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aUi_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu17ll, aUi_BFu15i_BFu17ll)
//============================================================================



static void Test_aUi_BFu15i_BFu1c()
{
  {
    init_simple_test("aUi_BFu15i_BFu1c");
    static STRUCT_IF_C aUi_BFu15i_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aUi_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu1c, aUi_BFu15i_BFu1c)
//============================================================================



static void Test_aUi_BFu15i_BFu1i()
{
  {
    init_simple_test("aUi_BFu15i_BFu1i");
    static STRUCT_IF_C aUi_BFu15i_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aUi_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu1i, aUi_BFu15i_BFu1i)
//============================================================================



static void Test_aUi_BFu15i_BFu1ll()
{
  {
    init_simple_test("aUi_BFu15i_BFu1ll");
    static STRUCT_IF_C aUi_BFu15i_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aUi_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu1ll, aUi_BFu15i_BFu1ll)
//============================================================================



static void Test_aUi_BFu15i_BFu1s()
{
  {
    init_simple_test("aUi_BFu15i_BFu1s");
    static STRUCT_IF_C aUi_BFu15i_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aUi_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu1s, aUi_BFu15i_BFu1s)
//============================================================================



static void Test_aUi_BFu15i_BFu31i()
{
  {
    init_simple_test("aUi_BFu15i_BFu31i");
    static STRUCT_IF_C aUi_BFu15i_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aUi_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aUi_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu31i, aUi_BFu15i_BFu31i)
//============================================================================



static void Test_aUi_BFu15i_BFu31ll()
{
  {
    init_simple_test("aUi_BFu15i_BFu31ll");
    static STRUCT_IF_C aUi_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aUi_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aUi_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu31ll, aUi_BFu15i_BFu31ll)
//============================================================================



static void Test_aUi_BFu15i_BFu32i()
{
  {
    init_simple_test("aUi_BFu15i_BFu32i");
    static STRUCT_IF_C aUi_BFu15i_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aUi_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aUi_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu32i, aUi_BFu15i_BFu32i)
//============================================================================



static void Test_aUi_BFu15i_BFu32ll()
{
  {
    init_simple_test("aUi_BFu15i_BFu32ll");
    static STRUCT_IF_C aUi_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aUi_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aUi_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu32ll, aUi_BFu15i_BFu32ll)
//============================================================================



static void Test_aUi_BFu15i_BFu33()
{
  {
    init_simple_test("aUi_BFu15i_BFu33");
    static STRUCT_IF_C aUi_BFu15i_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, 1, "aUi_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, hide_ull(1LL<<32), "aUi_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu33, aUi_BFu15i_BFu33)
//============================================================================



static void Test_aUi_BFu15i_BFu7c()
{
  {
    init_simple_test("aUi_BFu15i_BFu7c");
    static STRUCT_IF_C aUi_BFu15i_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aUi_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aUi_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu7c, aUi_BFu15i_BFu7c)
//============================================================================



static void Test_aUi_BFu15i_BFu7i()
{
  {
    init_simple_test("aUi_BFu15i_BFu7i");
    static STRUCT_IF_C aUi_BFu15i_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aUi_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aUi_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu7i, aUi_BFu15i_BFu7i)
//============================================================================



static void Test_aUi_BFu15i_BFu7ll()
{
  {
    init_simple_test("aUi_BFu15i_BFu7ll");
    static STRUCT_IF_C aUi_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aUi_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aUi_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu7ll, aUi_BFu15i_BFu7ll)
//============================================================================



static void Test_aUi_BFu15i_BFu7s()
{
  {
    init_simple_test("aUi_BFu15i_BFu7s");
    static STRUCT_IF_C aUi_BFu15i_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aUi_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aUi_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu7s, aUi_BFu15i_BFu7s)
//============================================================================



static void Test_aUi_BFu15i_BFu8c()
{
  {
    init_simple_test("aUi_BFu15i_BFu8c");
    static STRUCT_IF_C aUi_BFu15i_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aUi_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aUi_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu8c, aUi_BFu15i_BFu8c)
//============================================================================



static void Test_aUi_BFu15i_BFu8i()
{
  {
    init_simple_test("aUi_BFu15i_BFu8i");
    static STRUCT_IF_C aUi_BFu15i_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aUi_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aUi_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu8i, aUi_BFu15i_BFu8i)
//============================================================================



static void Test_aUi_BFu15i_BFu8ll()
{
  {
    init_simple_test("aUi_BFu15i_BFu8ll");
    static STRUCT_IF_C aUi_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aUi_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aUi_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu8ll, aUi_BFu15i_BFu8ll)
//============================================================================



static void Test_aUi_BFu15i_BFu8s()
{
  {
    init_simple_test("aUi_BFu15i_BFu8s");
    static STRUCT_IF_C aUi_BFu15i_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aUi_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aUi_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu8s, aUi_BFu15i_BFu8s)
//============================================================================



static void Test_aUi_BFu15i_BFu9i()
{
  {
    init_simple_test("aUi_BFu15i_BFu9i");
    static STRUCT_IF_C aUi_BFu15i_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aUi_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aUi_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu9i, aUi_BFu15i_BFu9i)
//============================================================================



static void Test_aUi_BFu15i_BFu9ll()
{
  {
    init_simple_test("aUi_BFu15i_BFu9ll");
    static STRUCT_IF_C aUi_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aUi_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aUi_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu9ll, aUi_BFu15i_BFu9ll)
//============================================================================



static void Test_aUi_BFu15i_BFu9s()
{
  {
    init_simple_test("aUi_BFu15i_BFu9s");
    static STRUCT_IF_C aUi_BFu15i_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aUi_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aUi_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_BFu9s, aUi_BFu15i_BFu9s)
//============================================================================



static void Test_aUi_BFu15i_C()
{
  {
    init_simple_test("aUi_BFu15i_C");
    static STRUCT_IF_C aUi_BFu15i_C lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_C");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_C");
    check_field_offset(lv, v3, 6, "aUi_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_C, aUi_BFu15i_C)
//============================================================================



static void Test_aUi_BFu15i_D()
{
  {
    init_simple_test("aUi_BFu15i_D");
    static STRUCT_IF_C aUi_BFu15i_D lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu15i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_D");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_D");
    check_field_offset(lv, v3, 6, "aUi_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_D, aUi_BFu15i_D)
//============================================================================



static void Test_aUi_BFu15i_F()
{
  {
    init_simple_test("aUi_BFu15i_F");
    static STRUCT_IF_C aUi_BFu15i_F lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_F");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_F");
    check_field_offset(lv, v3, 6, "aUi_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_F, aUi_BFu15i_F)
//============================================================================



static void Test_aUi_BFu15i_I()
{
  {
    init_simple_test("aUi_BFu15i_I");
    static STRUCT_IF_C aUi_BFu15i_I lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_I");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_I");
    check_field_offset(lv, v3, 6, "aUi_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_I, aUi_BFu15i_I)
//============================================================================



static void Test_aUi_BFu15i_Ip()
{
  {
    init_simple_test("aUi_BFu15i_Ip");
    static STRUCT_IF_C aUi_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUi_BFu15i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_Ip");
    check_field_offset(lv, v3, 6, "aUi_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_Ip, aUi_BFu15i_Ip)
//============================================================================



static void Test_aUi_BFu15i_L()
{
  {
    init_simple_test("aUi_BFu15i_L");
    static STRUCT_IF_C aUi_BFu15i_L lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu15i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_L");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_L");
    check_field_offset(lv, v3, 6, "aUi_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_L, aUi_BFu15i_L)
//============================================================================



static void Test_aUi_BFu15i_S()
{
  {
    init_simple_test("aUi_BFu15i_S");
    static STRUCT_IF_C aUi_BFu15i_S lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_S");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_S");
    check_field_offset(lv, v3, 6, "aUi_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_S, aUi_BFu15i_S)
//============================================================================



static void Test_aUi_BFu15i_Uc()
{
  {
    init_simple_test("aUi_BFu15i_Uc");
    static STRUCT_IF_C aUi_BFu15i_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_Uc");
    check_field_offset(lv, v3, 6, "aUi_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_Uc, aUi_BFu15i_Uc)
//============================================================================



static void Test_aUi_BFu15i_Ui()
{
  {
    init_simple_test("aUi_BFu15i_Ui");
    static STRUCT_IF_C aUi_BFu15i_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_Ui");
    check_field_offset(lv, v3, 6, "aUi_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_Ui, aUi_BFu15i_Ui)
//============================================================================



static void Test_aUi_BFu15i_Ul()
{
  {
    init_simple_test("aUi_BFu15i_Ul");
    static STRUCT_IF_C aUi_BFu15i_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu15i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_Ul");
    check_field_offset(lv, v3, 6, "aUi_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_Ul, aUi_BFu15i_Ul)
//============================================================================



static void Test_aUi_BFu15i_Us()
{
  {
    init_simple_test("aUi_BFu15i_Us");
    static STRUCT_IF_C aUi_BFu15i_Us lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_Us");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_Us");
    check_field_offset(lv, v3, 6, "aUi_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_Us, aUi_BFu15i_Us)
//============================================================================



static void Test_aUi_BFu15i_Vp()
{
  {
    init_simple_test("aUi_BFu15i_Vp");
    static STRUCT_IF_C aUi_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUi_BFu15i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15i_Vp");
    check_field_offset(lv, v3, 6, "aUi_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15i_Vp, aUi_BFu15i_Vp)
//============================================================================



static void Test_aUi_BFu15ll()
{
  {
    init_simple_test("aUi_BFu15ll");
    static STRUCT_IF_C aUi_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll, aUi_BFu15ll)
//============================================================================



static void Test_aUi_BFu15ll_BFu15i()
{
  {
    init_simple_test("aUi_BFu15ll_BFu15i");
    static STRUCT_IF_C aUi_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aUi_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu15i, aUi_BFu15ll_BFu15i)
//============================================================================



static void Test_aUi_BFu15ll_BFu15ll()
{
  {
    init_simple_test("aUi_BFu15ll_BFu15ll");
    static STRUCT_IF_C aUi_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aUi_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu15ll, aUi_BFu15ll_BFu15ll)
//============================================================================



static void Test_aUi_BFu15ll_BFu15s()
{
  {
    init_simple_test("aUi_BFu15ll_BFu15s");
    static STRUCT_IF_C aUi_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aUi_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu15s, aUi_BFu15ll_BFu15s)
//============================================================================



static void Test_aUi_BFu15ll_BFu16i()
{
  {
    init_simple_test("aUi_BFu15ll_BFu16i");
    static STRUCT_IF_C aUi_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aUi_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aUi_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu16i, aUi_BFu15ll_BFu16i)
//============================================================================



static void Test_aUi_BFu15ll_BFu16ll()
{
  {
    init_simple_test("aUi_BFu15ll_BFu16ll");
    static STRUCT_IF_C aUi_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aUi_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aUi_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu16ll, aUi_BFu15ll_BFu16ll)
//============================================================================



static void Test_aUi_BFu15ll_BFu16s()
{
  {
    init_simple_test("aUi_BFu15ll_BFu16s");
    static STRUCT_IF_C aUi_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aUi_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aUi_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu16s, aUi_BFu15ll_BFu16s)
//============================================================================



static void Test_aUi_BFu15ll_BFu17i()
{
  {
    init_simple_test("aUi_BFu15ll_BFu17i");
    static STRUCT_IF_C aUi_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aUi_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aUi_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu17i, aUi_BFu15ll_BFu17i)
//============================================================================



static void Test_aUi_BFu15ll_BFu17ll()
{
  {
    init_simple_test("aUi_BFu15ll_BFu17ll");
    static STRUCT_IF_C aUi_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aUi_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aUi_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu17ll, aUi_BFu15ll_BFu17ll)
//============================================================================



static void Test_aUi_BFu15ll_BFu1c()
{
  {
    init_simple_test("aUi_BFu15ll_BFu1c");
    static STRUCT_IF_C aUi_BFu15ll_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aUi_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu1c, aUi_BFu15ll_BFu1c)
//============================================================================



static void Test_aUi_BFu15ll_BFu1i()
{
  {
    init_simple_test("aUi_BFu15ll_BFu1i");
    static STRUCT_IF_C aUi_BFu15ll_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aUi_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu1i, aUi_BFu15ll_BFu1i)
//============================================================================



static void Test_aUi_BFu15ll_BFu1ll()
{
  {
    init_simple_test("aUi_BFu15ll_BFu1ll");
    static STRUCT_IF_C aUi_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aUi_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu1ll, aUi_BFu15ll_BFu1ll)
//============================================================================



static void Test_aUi_BFu15ll_BFu1s()
{
  {
    init_simple_test("aUi_BFu15ll_BFu1s");
    static STRUCT_IF_C aUi_BFu15ll_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aUi_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu1s, aUi_BFu15ll_BFu1s)
//============================================================================



static void Test_aUi_BFu15ll_BFu31i()
{
  {
    init_simple_test("aUi_BFu15ll_BFu31i");
    static STRUCT_IF_C aUi_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aUi_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aUi_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu31i, aUi_BFu15ll_BFu31i)
//============================================================================



static void Test_aUi_BFu15ll_BFu31ll()
{
  {
    init_simple_test("aUi_BFu15ll_BFu31ll");
    static STRUCT_IF_C aUi_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aUi_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aUi_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu31ll, aUi_BFu15ll_BFu31ll)
//============================================================================



static void Test_aUi_BFu15ll_BFu32i()
{
  {
    init_simple_test("aUi_BFu15ll_BFu32i");
    static STRUCT_IF_C aUi_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aUi_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aUi_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu32i, aUi_BFu15ll_BFu32i)
//============================================================================



static void Test_aUi_BFu15ll_BFu32ll()
{
  {
    init_simple_test("aUi_BFu15ll_BFu32ll");
    static STRUCT_IF_C aUi_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aUi_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aUi_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu32ll, aUi_BFu15ll_BFu32ll)
//============================================================================



static void Test_aUi_BFu15ll_BFu33()
{
  {
    init_simple_test("aUi_BFu15ll_BFu33");
    static STRUCT_IF_C aUi_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, 1, "aUi_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, hide_ull(1LL<<32), "aUi_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu33, aUi_BFu15ll_BFu33)
//============================================================================



static void Test_aUi_BFu15ll_BFu7c()
{
  {
    init_simple_test("aUi_BFu15ll_BFu7c");
    static STRUCT_IF_C aUi_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aUi_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aUi_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu7c, aUi_BFu15ll_BFu7c)
//============================================================================



static void Test_aUi_BFu15ll_BFu7i()
{
  {
    init_simple_test("aUi_BFu15ll_BFu7i");
    static STRUCT_IF_C aUi_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aUi_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aUi_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu7i, aUi_BFu15ll_BFu7i)
//============================================================================



static void Test_aUi_BFu15ll_BFu7ll()
{
  {
    init_simple_test("aUi_BFu15ll_BFu7ll");
    static STRUCT_IF_C aUi_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aUi_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aUi_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu7ll, aUi_BFu15ll_BFu7ll)
//============================================================================



static void Test_aUi_BFu15ll_BFu7s()
{
  {
    init_simple_test("aUi_BFu15ll_BFu7s");
    static STRUCT_IF_C aUi_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aUi_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aUi_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu7s, aUi_BFu15ll_BFu7s)
//============================================================================



static void Test_aUi_BFu15ll_BFu8c()
{
  {
    init_simple_test("aUi_BFu15ll_BFu8c");
    static STRUCT_IF_C aUi_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aUi_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aUi_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu8c, aUi_BFu15ll_BFu8c)
//============================================================================



static void Test_aUi_BFu15ll_BFu8i()
{
  {
    init_simple_test("aUi_BFu15ll_BFu8i");
    static STRUCT_IF_C aUi_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aUi_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aUi_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu8i, aUi_BFu15ll_BFu8i)
//============================================================================



static void Test_aUi_BFu15ll_BFu8ll()
{
  {
    init_simple_test("aUi_BFu15ll_BFu8ll");
    static STRUCT_IF_C aUi_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aUi_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aUi_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu8ll, aUi_BFu15ll_BFu8ll)
//============================================================================



static void Test_aUi_BFu15ll_BFu8s()
{
  {
    init_simple_test("aUi_BFu15ll_BFu8s");
    static STRUCT_IF_C aUi_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aUi_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aUi_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu8s, aUi_BFu15ll_BFu8s)
//============================================================================



static void Test_aUi_BFu15ll_BFu9i()
{
  {
    init_simple_test("aUi_BFu15ll_BFu9i");
    static STRUCT_IF_C aUi_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aUi_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aUi_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu9i, aUi_BFu15ll_BFu9i)
//============================================================================



static void Test_aUi_BFu15ll_BFu9ll()
{
  {
    init_simple_test("aUi_BFu15ll_BFu9ll");
    static STRUCT_IF_C aUi_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aUi_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aUi_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu9ll, aUi_BFu15ll_BFu9ll)
//============================================================================



static void Test_aUi_BFu15ll_BFu9s()
{
  {
    init_simple_test("aUi_BFu15ll_BFu9s");
    static STRUCT_IF_C aUi_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aUi_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aUi_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_BFu9s, aUi_BFu15ll_BFu9s)
//============================================================================



static void Test_aUi_BFu15ll_C()
{
  {
    init_simple_test("aUi_BFu15ll_C");
    static STRUCT_IF_C aUi_BFu15ll_C lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_C");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_C");
    check_field_offset(lv, v3, 6, "aUi_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_C, aUi_BFu15ll_C)
//============================================================================



static void Test_aUi_BFu15ll_D()
{
  {
    init_simple_test("aUi_BFu15ll_D");
    static STRUCT_IF_C aUi_BFu15ll_D lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu15ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_D");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_D");
    check_field_offset(lv, v3, 6, "aUi_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_D, aUi_BFu15ll_D)
//============================================================================



static void Test_aUi_BFu15ll_F()
{
  {
    init_simple_test("aUi_BFu15ll_F");
    static STRUCT_IF_C aUi_BFu15ll_F lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_F");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_F");
    check_field_offset(lv, v3, 6, "aUi_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_F, aUi_BFu15ll_F)
//============================================================================



static void Test_aUi_BFu15ll_I()
{
  {
    init_simple_test("aUi_BFu15ll_I");
    static STRUCT_IF_C aUi_BFu15ll_I lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_I");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_I");
    check_field_offset(lv, v3, 6, "aUi_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_I, aUi_BFu15ll_I)
//============================================================================



static void Test_aUi_BFu15ll_Ip()
{
  {
    init_simple_test("aUi_BFu15ll_Ip");
    static STRUCT_IF_C aUi_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUi_BFu15ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_Ip");
    check_field_offset(lv, v3, 6, "aUi_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_Ip, aUi_BFu15ll_Ip)
//============================================================================



static void Test_aUi_BFu15ll_L()
{
  {
    init_simple_test("aUi_BFu15ll_L");
    static STRUCT_IF_C aUi_BFu15ll_L lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu15ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_L");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_L");
    check_field_offset(lv, v3, 6, "aUi_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_L, aUi_BFu15ll_L)
//============================================================================



static void Test_aUi_BFu15ll_S()
{
  {
    init_simple_test("aUi_BFu15ll_S");
    static STRUCT_IF_C aUi_BFu15ll_S lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_S");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_S");
    check_field_offset(lv, v3, 6, "aUi_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_S, aUi_BFu15ll_S)
//============================================================================



static void Test_aUi_BFu15ll_Uc()
{
  {
    init_simple_test("aUi_BFu15ll_Uc");
    static STRUCT_IF_C aUi_BFu15ll_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_Uc");
    check_field_offset(lv, v3, 6, "aUi_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_Uc, aUi_BFu15ll_Uc)
//============================================================================



static void Test_aUi_BFu15ll_Ui()
{
  {
    init_simple_test("aUi_BFu15ll_Ui");
    static STRUCT_IF_C aUi_BFu15ll_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_Ui");
    check_field_offset(lv, v3, 6, "aUi_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_Ui, aUi_BFu15ll_Ui)
//============================================================================



static void Test_aUi_BFu15ll_Ul()
{
  {
    init_simple_test("aUi_BFu15ll_Ul");
    static STRUCT_IF_C aUi_BFu15ll_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu15ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_Ul");
    check_field_offset(lv, v3, 6, "aUi_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_Ul, aUi_BFu15ll_Ul)
//============================================================================



static void Test_aUi_BFu15ll_Us()
{
  {
    init_simple_test("aUi_BFu15ll_Us");
    static STRUCT_IF_C aUi_BFu15ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_Us");
    check_field_offset(lv, v3, 6, "aUi_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_Us, aUi_BFu15ll_Us)
//============================================================================



static void Test_aUi_BFu15ll_Vp()
{
  {
    init_simple_test("aUi_BFu15ll_Vp");
    static STRUCT_IF_C aUi_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUi_BFu15ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15ll_Vp");
    check_field_offset(lv, v3, 6, "aUi_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15ll_Vp, aUi_BFu15ll_Vp)
//============================================================================



static void Test_aUi_BFu15s()
{
  {
    init_simple_test("aUi_BFu15s");
    static STRUCT_IF_C aUi_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s, aUi_BFu15s)
//============================================================================



static void Test_aUi_BFu15s_BFu15i()
{
  {
    init_simple_test("aUi_BFu15s_BFu15i");
    static STRUCT_IF_C aUi_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aUi_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu15i, aUi_BFu15s_BFu15i)
//============================================================================



static void Test_aUi_BFu15s_BFu15ll()
{
  {
    init_simple_test("aUi_BFu15s_BFu15ll");
    static STRUCT_IF_C aUi_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aUi_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu15ll, aUi_BFu15s_BFu15ll)
//============================================================================



static void Test_aUi_BFu15s_BFu15s()
{
  {
    init_simple_test("aUi_BFu15s_BFu15s");
    static STRUCT_IF_C aUi_BFu15s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aUi_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu15s, aUi_BFu15s_BFu15s)
//============================================================================



static void Test_aUi_BFu15s_BFu16i()
{
  {
    init_simple_test("aUi_BFu15s_BFu16i");
    static STRUCT_IF_C aUi_BFu15s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aUi_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aUi_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu16i, aUi_BFu15s_BFu16i)
//============================================================================



static void Test_aUi_BFu15s_BFu16ll()
{
  {
    init_simple_test("aUi_BFu15s_BFu16ll");
    static STRUCT_IF_C aUi_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aUi_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aUi_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu16ll, aUi_BFu15s_BFu16ll)
//============================================================================



static void Test_aUi_BFu15s_BFu16s()
{
  {
    init_simple_test("aUi_BFu15s_BFu16s");
    static STRUCT_IF_C aUi_BFu15s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aUi_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aUi_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu16s, aUi_BFu15s_BFu16s)
//============================================================================



static void Test_aUi_BFu15s_BFu17i()
{
  {
    init_simple_test("aUi_BFu15s_BFu17i");
    static STRUCT_IF_C aUi_BFu15s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aUi_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aUi_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu17i, aUi_BFu15s_BFu17i)
//============================================================================



static void Test_aUi_BFu15s_BFu17ll()
{
  {
    init_simple_test("aUi_BFu15s_BFu17ll");
    static STRUCT_IF_C aUi_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aUi_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aUi_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu17ll, aUi_BFu15s_BFu17ll)
//============================================================================



static void Test_aUi_BFu15s_BFu1c()
{
  {
    init_simple_test("aUi_BFu15s_BFu1c");
    static STRUCT_IF_C aUi_BFu15s_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aUi_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu1c, aUi_BFu15s_BFu1c)
//============================================================================



static void Test_aUi_BFu15s_BFu1i()
{
  {
    init_simple_test("aUi_BFu15s_BFu1i");
    static STRUCT_IF_C aUi_BFu15s_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aUi_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu1i, aUi_BFu15s_BFu1i)
//============================================================================



static void Test_aUi_BFu15s_BFu1ll()
{
  {
    init_simple_test("aUi_BFu15s_BFu1ll");
    static STRUCT_IF_C aUi_BFu15s_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aUi_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu1ll, aUi_BFu15s_BFu1ll)
//============================================================================



static void Test_aUi_BFu15s_BFu1s()
{
  {
    init_simple_test("aUi_BFu15s_BFu1s");
    static STRUCT_IF_C aUi_BFu15s_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu15s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aUi_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu1s, aUi_BFu15s_BFu1s)
//============================================================================



static void Test_aUi_BFu15s_BFu31i()
{
  {
    init_simple_test("aUi_BFu15s_BFu31i");
    static STRUCT_IF_C aUi_BFu15s_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aUi_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aUi_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu31i, aUi_BFu15s_BFu31i)
//============================================================================



static void Test_aUi_BFu15s_BFu31ll()
{
  {
    init_simple_test("aUi_BFu15s_BFu31ll");
    static STRUCT_IF_C aUi_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aUi_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aUi_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu31ll, aUi_BFu15s_BFu31ll)
//============================================================================



static void Test_aUi_BFu15s_BFu32i()
{
  {
    init_simple_test("aUi_BFu15s_BFu32i");
    static STRUCT_IF_C aUi_BFu15s_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aUi_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aUi_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu32i, aUi_BFu15s_BFu32i)
//============================================================================



static void Test_aUi_BFu15s_BFu32ll()
{
  {
    init_simple_test("aUi_BFu15s_BFu32ll");
    static STRUCT_IF_C aUi_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aUi_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aUi_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu32ll, aUi_BFu15s_BFu32ll)
//============================================================================



static void Test_aUi_BFu15s_BFu33()
{
  {
    init_simple_test("aUi_BFu15s_BFu33");
    static STRUCT_IF_C aUi_BFu15s_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, 1, "aUi_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, hide_ull(1LL<<32), "aUi_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu33, aUi_BFu15s_BFu33)
//============================================================================



static void Test_aUi_BFu15s_BFu7c()
{
  {
    init_simple_test("aUi_BFu15s_BFu7c");
    static STRUCT_IF_C aUi_BFu15s_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aUi_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aUi_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu7c, aUi_BFu15s_BFu7c)
//============================================================================



static void Test_aUi_BFu15s_BFu7i()
{
  {
    init_simple_test("aUi_BFu15s_BFu7i");
    static STRUCT_IF_C aUi_BFu15s_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aUi_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aUi_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu7i, aUi_BFu15s_BFu7i)
//============================================================================



static void Test_aUi_BFu15s_BFu7ll()
{
  {
    init_simple_test("aUi_BFu15s_BFu7ll");
    static STRUCT_IF_C aUi_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aUi_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aUi_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu7ll, aUi_BFu15s_BFu7ll)
//============================================================================



static void Test_aUi_BFu15s_BFu7s()
{
  {
    init_simple_test("aUi_BFu15s_BFu7s");
    static STRUCT_IF_C aUi_BFu15s_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aUi_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aUi_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu7s, aUi_BFu15s_BFu7s)
//============================================================================



static void Test_aUi_BFu15s_BFu8c()
{
  {
    init_simple_test("aUi_BFu15s_BFu8c");
    static STRUCT_IF_C aUi_BFu15s_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aUi_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aUi_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu8c, aUi_BFu15s_BFu8c)
//============================================================================



static void Test_aUi_BFu15s_BFu8i()
{
  {
    init_simple_test("aUi_BFu15s_BFu8i");
    static STRUCT_IF_C aUi_BFu15s_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aUi_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aUi_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu8i, aUi_BFu15s_BFu8i)
//============================================================================



static void Test_aUi_BFu15s_BFu8ll()
{
  {
    init_simple_test("aUi_BFu15s_BFu8ll");
    static STRUCT_IF_C aUi_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aUi_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aUi_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu8ll, aUi_BFu15s_BFu8ll)
//============================================================================



static void Test_aUi_BFu15s_BFu8s()
{
  {
    init_simple_test("aUi_BFu15s_BFu8s");
    static STRUCT_IF_C aUi_BFu15s_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aUi_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aUi_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu8s, aUi_BFu15s_BFu8s)
//============================================================================



static void Test_aUi_BFu15s_BFu9i()
{
  {
    init_simple_test("aUi_BFu15s_BFu9i");
    static STRUCT_IF_C aUi_BFu15s_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aUi_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aUi_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu9i, aUi_BFu15s_BFu9i)
//============================================================================



static void Test_aUi_BFu15s_BFu9ll()
{
  {
    init_simple_test("aUi_BFu15s_BFu9ll");
    static STRUCT_IF_C aUi_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aUi_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aUi_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu9ll, aUi_BFu15s_BFu9ll)
//============================================================================



static void Test_aUi_BFu15s_BFu9s()
{
  {
    init_simple_test("aUi_BFu15s_BFu9s");
    static STRUCT_IF_C aUi_BFu15s_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aUi_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aUi_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_BFu9s, aUi_BFu15s_BFu9s)
//============================================================================



static void Test_aUi_BFu15s_C()
{
  {
    init_simple_test("aUi_BFu15s_C");
    static STRUCT_IF_C aUi_BFu15s_C lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_C");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_C");
    check_field_offset(lv, v3, 6, "aUi_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_C, aUi_BFu15s_C)
//============================================================================



static void Test_aUi_BFu15s_D()
{
  {
    init_simple_test("aUi_BFu15s_D");
    static STRUCT_IF_C aUi_BFu15s_D lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu15s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_D");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_D");
    check_field_offset(lv, v3, 6, "aUi_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_D, aUi_BFu15s_D)
//============================================================================



static void Test_aUi_BFu15s_F()
{
  {
    init_simple_test("aUi_BFu15s_F");
    static STRUCT_IF_C aUi_BFu15s_F lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_F");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_F");
    check_field_offset(lv, v3, 6, "aUi_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_F, aUi_BFu15s_F)
//============================================================================



static void Test_aUi_BFu15s_I()
{
  {
    init_simple_test("aUi_BFu15s_I");
    static STRUCT_IF_C aUi_BFu15s_I lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_I");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_I");
    check_field_offset(lv, v3, 6, "aUi_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_I, aUi_BFu15s_I)
//============================================================================



static void Test_aUi_BFu15s_Ip()
{
  {
    init_simple_test("aUi_BFu15s_Ip");
    static STRUCT_IF_C aUi_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUi_BFu15s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_Ip");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_Ip");
    check_field_offset(lv, v3, 6, "aUi_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_Ip, aUi_BFu15s_Ip)
//============================================================================



static void Test_aUi_BFu15s_L()
{
  {
    init_simple_test("aUi_BFu15s_L");
    static STRUCT_IF_C aUi_BFu15s_L lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu15s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_L");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_L");
    check_field_offset(lv, v3, 6, "aUi_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_L, aUi_BFu15s_L)
//============================================================================



static void Test_aUi_BFu15s_S()
{
  {
    init_simple_test("aUi_BFu15s_S");
    static STRUCT_IF_C aUi_BFu15s_S lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_S");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_S");
    check_field_offset(lv, v3, 6, "aUi_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_S, aUi_BFu15s_S)
//============================================================================



static void Test_aUi_BFu15s_Uc()
{
  {
    init_simple_test("aUi_BFu15s_Uc");
    static STRUCT_IF_C aUi_BFu15s_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu15s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_Uc");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_Uc");
    check_field_offset(lv, v3, 6, "aUi_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_Uc, aUi_BFu15s_Uc)
//============================================================================



static void Test_aUi_BFu15s_Ui()
{
  {
    init_simple_test("aUi_BFu15s_Ui");
    static STRUCT_IF_C aUi_BFu15s_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu15s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_Ui");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_Ui");
    check_field_offset(lv, v3, 6, "aUi_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_Ui, aUi_BFu15s_Ui)
//============================================================================



static void Test_aUi_BFu15s_Ul()
{
  {
    init_simple_test("aUi_BFu15s_Ul");
    static STRUCT_IF_C aUi_BFu15s_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu15s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_Ul");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_Ul");
    check_field_offset(lv, v3, 6, "aUi_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_Ul, aUi_BFu15s_Ul)
//============================================================================



static void Test_aUi_BFu15s_Us()
{
  {
    init_simple_test("aUi_BFu15s_Us");
    static STRUCT_IF_C aUi_BFu15s_Us lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu15s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_Us");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_Us");
    check_field_offset(lv, v3, 6, "aUi_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_Us, aUi_BFu15s_Us)
//============================================================================



static void Test_aUi_BFu15s_Vp()
{
  {
    init_simple_test("aUi_BFu15s_Vp");
    static STRUCT_IF_C aUi_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUi_BFu15s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 15, 1, "aUi_BFu15s_Vp");
    set_bf_and_test(lv, v2, 4, 0, 15, hide_ull(1LL<<14), "aUi_BFu15s_Vp");
    check_field_offset(lv, v3, 6, "aUi_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu15s_Vp, aUi_BFu15s_Vp)
//============================================================================



static void Test_aUi_BFu16i()
{
  {
    init_simple_test("aUi_BFu16i");
    static STRUCT_IF_C aUi_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i, aUi_BFu16i)
//============================================================================



static void Test_aUi_BFu16i_BFu15i()
{
  {
    init_simple_test("aUi_BFu16i_BFu15i");
    static STRUCT_IF_C aUi_BFu16i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aUi_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aUi_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu15i, aUi_BFu16i_BFu15i)
//============================================================================



static void Test_aUi_BFu16i_BFu15ll()
{
  {
    init_simple_test("aUi_BFu16i_BFu15ll");
    static STRUCT_IF_C aUi_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aUi_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aUi_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu15ll, aUi_BFu16i_BFu15ll)
//============================================================================



static void Test_aUi_BFu16i_BFu15s()
{
  {
    init_simple_test("aUi_BFu16i_BFu15s");
    static STRUCT_IF_C aUi_BFu16i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aUi_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aUi_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu15s, aUi_BFu16i_BFu15s)
//============================================================================



static void Test_aUi_BFu16i_BFu16i()
{
  {
    init_simple_test("aUi_BFu16i_BFu16i");
    static STRUCT_IF_C aUi_BFu16i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aUi_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu16i, aUi_BFu16i_BFu16i)
//============================================================================



static void Test_aUi_BFu16i_BFu16ll()
{
  {
    init_simple_test("aUi_BFu16i_BFu16ll");
    static STRUCT_IF_C aUi_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aUi_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu16ll, aUi_BFu16i_BFu16ll)
//============================================================================



static void Test_aUi_BFu16i_BFu16s()
{
  {
    init_simple_test("aUi_BFu16i_BFu16s");
    static STRUCT_IF_C aUi_BFu16i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aUi_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu16s, aUi_BFu16i_BFu16s)
//============================================================================



static void Test_aUi_BFu16i_BFu17i()
{
  {
    init_simple_test("aUi_BFu16i_BFu17i");
    static STRUCT_IF_C aUi_BFu16i_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu16i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aUi_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aUi_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu17i, aUi_BFu16i_BFu17i)
//============================================================================



static void Test_aUi_BFu16i_BFu17ll()
{
  {
    init_simple_test("aUi_BFu16i_BFu17ll");
    static STRUCT_IF_C aUi_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu16i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aUi_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aUi_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu17ll, aUi_BFu16i_BFu17ll)
//============================================================================



static void Test_aUi_BFu16i_BFu1c()
{
  {
    init_simple_test("aUi_BFu16i_BFu1c");
    static STRUCT_IF_C aUi_BFu16i_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aUi_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu1c, aUi_BFu16i_BFu1c)
//============================================================================



static void Test_aUi_BFu16i_BFu1i()
{
  {
    init_simple_test("aUi_BFu16i_BFu1i");
    static STRUCT_IF_C aUi_BFu16i_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aUi_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu1i, aUi_BFu16i_BFu1i)
//============================================================================



static void Test_aUi_BFu16i_BFu1ll()
{
  {
    init_simple_test("aUi_BFu16i_BFu1ll");
    static STRUCT_IF_C aUi_BFu16i_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aUi_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu1ll, aUi_BFu16i_BFu1ll)
//============================================================================



static void Test_aUi_BFu16i_BFu1s()
{
  {
    init_simple_test("aUi_BFu16i_BFu1s");
    static STRUCT_IF_C aUi_BFu16i_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aUi_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu1s, aUi_BFu16i_BFu1s)
//============================================================================



static void Test_aUi_BFu16i_BFu31i()
{
  {
    init_simple_test("aUi_BFu16i_BFu31i");
    static STRUCT_IF_C aUi_BFu16i_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aUi_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aUi_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu31i, aUi_BFu16i_BFu31i)
//============================================================================



static void Test_aUi_BFu16i_BFu31ll()
{
  {
    init_simple_test("aUi_BFu16i_BFu31ll");
    static STRUCT_IF_C aUi_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aUi_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aUi_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu31ll, aUi_BFu16i_BFu31ll)
//============================================================================



static void Test_aUi_BFu16i_BFu32i()
{
  {
    init_simple_test("aUi_BFu16i_BFu32i");
    static STRUCT_IF_C aUi_BFu16i_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aUi_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aUi_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu32i, aUi_BFu16i_BFu32i)
//============================================================================



static void Test_aUi_BFu16i_BFu32ll()
{
  {
    init_simple_test("aUi_BFu16i_BFu32ll");
    static STRUCT_IF_C aUi_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aUi_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aUi_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu32ll, aUi_BFu16i_BFu32ll)
//============================================================================



static void Test_aUi_BFu16i_BFu33()
{
  {
    init_simple_test("aUi_BFu16i_BFu33");
    static STRUCT_IF_C aUi_BFu16i_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu16i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "aUi_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "aUi_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu33, aUi_BFu16i_BFu33)
//============================================================================



static void Test_aUi_BFu16i_BFu7c()
{
  {
    init_simple_test("aUi_BFu16i_BFu7c");
    static STRUCT_IF_C aUi_BFu16i_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aUi_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aUi_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu7c, aUi_BFu16i_BFu7c)
//============================================================================



static void Test_aUi_BFu16i_BFu7i()
{
  {
    init_simple_test("aUi_BFu16i_BFu7i");
    static STRUCT_IF_C aUi_BFu16i_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aUi_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aUi_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu7i, aUi_BFu16i_BFu7i)
//============================================================================



static void Test_aUi_BFu16i_BFu7ll()
{
  {
    init_simple_test("aUi_BFu16i_BFu7ll");
    static STRUCT_IF_C aUi_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aUi_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aUi_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu7ll, aUi_BFu16i_BFu7ll)
//============================================================================



static void Test_aUi_BFu16i_BFu7s()
{
  {
    init_simple_test("aUi_BFu16i_BFu7s");
    static STRUCT_IF_C aUi_BFu16i_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aUi_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aUi_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu7s, aUi_BFu16i_BFu7s)
//============================================================================



static void Test_aUi_BFu16i_BFu8c()
{
  {
    init_simple_test("aUi_BFu16i_BFu8c");
    static STRUCT_IF_C aUi_BFu16i_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aUi_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aUi_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu8c, aUi_BFu16i_BFu8c)
//============================================================================



static void Test_aUi_BFu16i_BFu8i()
{
  {
    init_simple_test("aUi_BFu16i_BFu8i");
    static STRUCT_IF_C aUi_BFu16i_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aUi_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aUi_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu8i, aUi_BFu16i_BFu8i)
//============================================================================



static void Test_aUi_BFu16i_BFu8ll()
{
  {
    init_simple_test("aUi_BFu16i_BFu8ll");
    static STRUCT_IF_C aUi_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aUi_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aUi_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu8ll, aUi_BFu16i_BFu8ll)
//============================================================================



static void Test_aUi_BFu16i_BFu8s()
{
  {
    init_simple_test("aUi_BFu16i_BFu8s");
    static STRUCT_IF_C aUi_BFu16i_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aUi_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aUi_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu8s, aUi_BFu16i_BFu8s)
//============================================================================



static void Test_aUi_BFu16i_BFu9i()
{
  {
    init_simple_test("aUi_BFu16i_BFu9i");
    static STRUCT_IF_C aUi_BFu16i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aUi_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aUi_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu9i, aUi_BFu16i_BFu9i)
//============================================================================



static void Test_aUi_BFu16i_BFu9ll()
{
  {
    init_simple_test("aUi_BFu16i_BFu9ll");
    static STRUCT_IF_C aUi_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aUi_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aUi_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu9ll, aUi_BFu16i_BFu9ll)
//============================================================================



static void Test_aUi_BFu16i_BFu9s()
{
  {
    init_simple_test("aUi_BFu16i_BFu9s");
    static STRUCT_IF_C aUi_BFu16i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aUi_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aUi_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_BFu9s, aUi_BFu16i_BFu9s)
//============================================================================



static void Test_aUi_BFu16i_C()
{
  {
    init_simple_test("aUi_BFu16i_C");
    static STRUCT_IF_C aUi_BFu16i_C lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_C");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_C");
    check_field_offset(lv, v3, 6, "aUi_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_C, aUi_BFu16i_C)
//============================================================================



static void Test_aUi_BFu16i_D()
{
  {
    init_simple_test("aUi_BFu16i_D");
    static STRUCT_IF_C aUi_BFu16i_D lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu16i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_D");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_D");
    check_field_offset(lv, v3, 6, "aUi_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_D, aUi_BFu16i_D)
//============================================================================



static void Test_aUi_BFu16i_F()
{
  {
    init_simple_test("aUi_BFu16i_F");
    static STRUCT_IF_C aUi_BFu16i_F lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_F");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_F");
    check_field_offset(lv, v3, 6, "aUi_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_F, aUi_BFu16i_F)
//============================================================================



static void Test_aUi_BFu16i_I()
{
  {
    init_simple_test("aUi_BFu16i_I");
    static STRUCT_IF_C aUi_BFu16i_I lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_I");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_I");
    check_field_offset(lv, v3, 6, "aUi_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_I, aUi_BFu16i_I)
//============================================================================



static void Test_aUi_BFu16i_Ip()
{
  {
    init_simple_test("aUi_BFu16i_Ip");
    static STRUCT_IF_C aUi_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUi_BFu16i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_Ip");
    check_field_offset(lv, v3, 6, "aUi_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_Ip, aUi_BFu16i_Ip)
//============================================================================



static void Test_aUi_BFu16i_L()
{
  {
    init_simple_test("aUi_BFu16i_L");
    static STRUCT_IF_C aUi_BFu16i_L lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu16i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_L");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_L");
    check_field_offset(lv, v3, 6, "aUi_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_L, aUi_BFu16i_L)
//============================================================================



static void Test_aUi_BFu16i_S()
{
  {
    init_simple_test("aUi_BFu16i_S");
    static STRUCT_IF_C aUi_BFu16i_S lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_S");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_S");
    check_field_offset(lv, v3, 6, "aUi_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_S, aUi_BFu16i_S)
//============================================================================



static void Test_aUi_BFu16i_Uc()
{
  {
    init_simple_test("aUi_BFu16i_Uc");
    static STRUCT_IF_C aUi_BFu16i_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_Uc");
    check_field_offset(lv, v3, 6, "aUi_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_Uc, aUi_BFu16i_Uc)
//============================================================================



static void Test_aUi_BFu16i_Ui()
{
  {
    init_simple_test("aUi_BFu16i_Ui");
    static STRUCT_IF_C aUi_BFu16i_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_Ui");
    check_field_offset(lv, v3, 6, "aUi_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_Ui, aUi_BFu16i_Ui)
//============================================================================



static void Test_aUi_BFu16i_Ul()
{
  {
    init_simple_test("aUi_BFu16i_Ul");
    static STRUCT_IF_C aUi_BFu16i_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu16i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_Ul");
    check_field_offset(lv, v3, 6, "aUi_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_Ul, aUi_BFu16i_Ul)
//============================================================================



static void Test_aUi_BFu16i_Us()
{
  {
    init_simple_test("aUi_BFu16i_Us");
    static STRUCT_IF_C aUi_BFu16i_Us lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_Us");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_Us");
    check_field_offset(lv, v3, 6, "aUi_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_Us, aUi_BFu16i_Us)
//============================================================================



static void Test_aUi_BFu16i_Vp()
{
  {
    init_simple_test("aUi_BFu16i_Vp");
    static STRUCT_IF_C aUi_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUi_BFu16i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16i_Vp");
    check_field_offset(lv, v3, 6, "aUi_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16i_Vp, aUi_BFu16i_Vp)
//============================================================================



static void Test_aUi_BFu16ll()
{
  {
    init_simple_test("aUi_BFu16ll");
    static STRUCT_IF_C aUi_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll, aUi_BFu16ll)
//============================================================================



static void Test_aUi_BFu16ll_BFu15i()
{
  {
    init_simple_test("aUi_BFu16ll_BFu15i");
    static STRUCT_IF_C aUi_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aUi_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aUi_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu15i, aUi_BFu16ll_BFu15i)
//============================================================================



static void Test_aUi_BFu16ll_BFu15ll()
{
  {
    init_simple_test("aUi_BFu16ll_BFu15ll");
    static STRUCT_IF_C aUi_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aUi_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aUi_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu15ll, aUi_BFu16ll_BFu15ll)
//============================================================================



static void Test_aUi_BFu16ll_BFu15s()
{
  {
    init_simple_test("aUi_BFu16ll_BFu15s");
    static STRUCT_IF_C aUi_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aUi_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aUi_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu15s, aUi_BFu16ll_BFu15s)
//============================================================================



static void Test_aUi_BFu16ll_BFu16i()
{
  {
    init_simple_test("aUi_BFu16ll_BFu16i");
    static STRUCT_IF_C aUi_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aUi_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu16i, aUi_BFu16ll_BFu16i)
//============================================================================



static void Test_aUi_BFu16ll_BFu16ll()
{
  {
    init_simple_test("aUi_BFu16ll_BFu16ll");
    static STRUCT_IF_C aUi_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aUi_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu16ll, aUi_BFu16ll_BFu16ll)
//============================================================================



static void Test_aUi_BFu16ll_BFu16s()
{
  {
    init_simple_test("aUi_BFu16ll_BFu16s");
    static STRUCT_IF_C aUi_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aUi_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu16s, aUi_BFu16ll_BFu16s)
//============================================================================



static void Test_aUi_BFu16ll_BFu17i()
{
  {
    init_simple_test("aUi_BFu16ll_BFu17i");
    static STRUCT_IF_C aUi_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu16ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aUi_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aUi_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu17i, aUi_BFu16ll_BFu17i)
//============================================================================



static void Test_aUi_BFu16ll_BFu17ll()
{
  {
    init_simple_test("aUi_BFu16ll_BFu17ll");
    static STRUCT_IF_C aUi_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aUi_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aUi_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu17ll, aUi_BFu16ll_BFu17ll)
//============================================================================



static void Test_aUi_BFu16ll_BFu1c()
{
  {
    init_simple_test("aUi_BFu16ll_BFu1c");
    static STRUCT_IF_C aUi_BFu16ll_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aUi_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu1c, aUi_BFu16ll_BFu1c)
//============================================================================



static void Test_aUi_BFu16ll_BFu1i()
{
  {
    init_simple_test("aUi_BFu16ll_BFu1i");
    static STRUCT_IF_C aUi_BFu16ll_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aUi_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu1i, aUi_BFu16ll_BFu1i)
//============================================================================



static void Test_aUi_BFu16ll_BFu1ll()
{
  {
    init_simple_test("aUi_BFu16ll_BFu1ll");
    static STRUCT_IF_C aUi_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aUi_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu1ll, aUi_BFu16ll_BFu1ll)
//============================================================================



static void Test_aUi_BFu16ll_BFu1s()
{
  {
    init_simple_test("aUi_BFu16ll_BFu1s");
    static STRUCT_IF_C aUi_BFu16ll_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aUi_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu1s, aUi_BFu16ll_BFu1s)
//============================================================================



static void Test_aUi_BFu16ll_BFu31i()
{
  {
    init_simple_test("aUi_BFu16ll_BFu31i");
    static STRUCT_IF_C aUi_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aUi_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aUi_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu31i, aUi_BFu16ll_BFu31i)
//============================================================================



static void Test_aUi_BFu16ll_BFu31ll()
{
  {
    init_simple_test("aUi_BFu16ll_BFu31ll");
    static STRUCT_IF_C aUi_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aUi_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aUi_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu31ll, aUi_BFu16ll_BFu31ll)
//============================================================================



static void Test_aUi_BFu16ll_BFu32i()
{
  {
    init_simple_test("aUi_BFu16ll_BFu32i");
    static STRUCT_IF_C aUi_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aUi_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aUi_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu32i, aUi_BFu16ll_BFu32i)
//============================================================================



static void Test_aUi_BFu16ll_BFu32ll()
{
  {
    init_simple_test("aUi_BFu16ll_BFu32ll");
    static STRUCT_IF_C aUi_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aUi_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aUi_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu32ll, aUi_BFu16ll_BFu32ll)
//============================================================================



static void Test_aUi_BFu16ll_BFu33()
{
  {
    init_simple_test("aUi_BFu16ll_BFu33");
    static STRUCT_IF_C aUi_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu16ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "aUi_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "aUi_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu33, aUi_BFu16ll_BFu33)
//============================================================================



static void Test_aUi_BFu16ll_BFu7c()
{
  {
    init_simple_test("aUi_BFu16ll_BFu7c");
    static STRUCT_IF_C aUi_BFu16ll_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aUi_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aUi_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu7c, aUi_BFu16ll_BFu7c)
//============================================================================



static void Test_aUi_BFu16ll_BFu7i()
{
  {
    init_simple_test("aUi_BFu16ll_BFu7i");
    static STRUCT_IF_C aUi_BFu16ll_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aUi_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aUi_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu7i, aUi_BFu16ll_BFu7i)
//============================================================================



static void Test_aUi_BFu16ll_BFu7ll()
{
  {
    init_simple_test("aUi_BFu16ll_BFu7ll");
    static STRUCT_IF_C aUi_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aUi_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aUi_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu7ll, aUi_BFu16ll_BFu7ll)
//============================================================================



static void Test_aUi_BFu16ll_BFu7s()
{
  {
    init_simple_test("aUi_BFu16ll_BFu7s");
    static STRUCT_IF_C aUi_BFu16ll_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aUi_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aUi_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu7s, aUi_BFu16ll_BFu7s)
//============================================================================



static void Test_aUi_BFu16ll_BFu8c()
{
  {
    init_simple_test("aUi_BFu16ll_BFu8c");
    static STRUCT_IF_C aUi_BFu16ll_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aUi_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aUi_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu8c, aUi_BFu16ll_BFu8c)
//============================================================================



static void Test_aUi_BFu16ll_BFu8i()
{
  {
    init_simple_test("aUi_BFu16ll_BFu8i");
    static STRUCT_IF_C aUi_BFu16ll_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aUi_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aUi_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu8i, aUi_BFu16ll_BFu8i)
//============================================================================



static void Test_aUi_BFu16ll_BFu8ll()
{
  {
    init_simple_test("aUi_BFu16ll_BFu8ll");
    static STRUCT_IF_C aUi_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aUi_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aUi_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu8ll, aUi_BFu16ll_BFu8ll)
//============================================================================



static void Test_aUi_BFu16ll_BFu8s()
{
  {
    init_simple_test("aUi_BFu16ll_BFu8s");
    static STRUCT_IF_C aUi_BFu16ll_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aUi_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aUi_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu8s, aUi_BFu16ll_BFu8s)
//============================================================================



static void Test_aUi_BFu16ll_BFu9i()
{
  {
    init_simple_test("aUi_BFu16ll_BFu9i");
    static STRUCT_IF_C aUi_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aUi_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aUi_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu9i, aUi_BFu16ll_BFu9i)
//============================================================================



static void Test_aUi_BFu16ll_BFu9ll()
{
  {
    init_simple_test("aUi_BFu16ll_BFu9ll");
    static STRUCT_IF_C aUi_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aUi_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aUi_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu9ll, aUi_BFu16ll_BFu9ll)
//============================================================================



static void Test_aUi_BFu16ll_BFu9s()
{
  {
    init_simple_test("aUi_BFu16ll_BFu9s");
    static STRUCT_IF_C aUi_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aUi_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aUi_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_BFu9s, aUi_BFu16ll_BFu9s)
//============================================================================



static void Test_aUi_BFu16ll_C()
{
  {
    init_simple_test("aUi_BFu16ll_C");
    static STRUCT_IF_C aUi_BFu16ll_C lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_C");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_C");
    check_field_offset(lv, v3, 6, "aUi_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_C, aUi_BFu16ll_C)
//============================================================================



static void Test_aUi_BFu16ll_D()
{
  {
    init_simple_test("aUi_BFu16ll_D");
    static STRUCT_IF_C aUi_BFu16ll_D lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu16ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_D");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_D");
    check_field_offset(lv, v3, 6, "aUi_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_D, aUi_BFu16ll_D)
//============================================================================



static void Test_aUi_BFu16ll_F()
{
  {
    init_simple_test("aUi_BFu16ll_F");
    static STRUCT_IF_C aUi_BFu16ll_F lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_F");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_F");
    check_field_offset(lv, v3, 6, "aUi_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_F, aUi_BFu16ll_F)
//============================================================================



static void Test_aUi_BFu16ll_I()
{
  {
    init_simple_test("aUi_BFu16ll_I");
    static STRUCT_IF_C aUi_BFu16ll_I lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_I");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_I");
    check_field_offset(lv, v3, 6, "aUi_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_I, aUi_BFu16ll_I)
//============================================================================



static void Test_aUi_BFu16ll_Ip()
{
  {
    init_simple_test("aUi_BFu16ll_Ip");
    static STRUCT_IF_C aUi_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUi_BFu16ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_Ip");
    check_field_offset(lv, v3, 6, "aUi_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_Ip, aUi_BFu16ll_Ip)
//============================================================================



static void Test_aUi_BFu16ll_L()
{
  {
    init_simple_test("aUi_BFu16ll_L");
    static STRUCT_IF_C aUi_BFu16ll_L lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu16ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_L");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_L");
    check_field_offset(lv, v3, 6, "aUi_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_L, aUi_BFu16ll_L)
//============================================================================



static void Test_aUi_BFu16ll_S()
{
  {
    init_simple_test("aUi_BFu16ll_S");
    static STRUCT_IF_C aUi_BFu16ll_S lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_S");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_S");
    check_field_offset(lv, v3, 6, "aUi_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_S, aUi_BFu16ll_S)
//============================================================================



static void Test_aUi_BFu16ll_Uc()
{
  {
    init_simple_test("aUi_BFu16ll_Uc");
    static STRUCT_IF_C aUi_BFu16ll_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_Uc");
    check_field_offset(lv, v3, 6, "aUi_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_Uc, aUi_BFu16ll_Uc)
//============================================================================



static void Test_aUi_BFu16ll_Ui()
{
  {
    init_simple_test("aUi_BFu16ll_Ui");
    static STRUCT_IF_C aUi_BFu16ll_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_Ui");
    check_field_offset(lv, v3, 6, "aUi_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_Ui, aUi_BFu16ll_Ui)
//============================================================================



static void Test_aUi_BFu16ll_Ul()
{
  {
    init_simple_test("aUi_BFu16ll_Ul");
    static STRUCT_IF_C aUi_BFu16ll_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu16ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_Ul");
    check_field_offset(lv, v3, 6, "aUi_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_Ul, aUi_BFu16ll_Ul)
//============================================================================



static void Test_aUi_BFu16ll_Us()
{
  {
    init_simple_test("aUi_BFu16ll_Us");
    static STRUCT_IF_C aUi_BFu16ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_Us");
    check_field_offset(lv, v3, 6, "aUi_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_Us, aUi_BFu16ll_Us)
//============================================================================



static void Test_aUi_BFu16ll_Vp()
{
  {
    init_simple_test("aUi_BFu16ll_Vp");
    static STRUCT_IF_C aUi_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUi_BFu16ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16ll_Vp");
    check_field_offset(lv, v3, 6, "aUi_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16ll_Vp, aUi_BFu16ll_Vp)
//============================================================================



static void Test_aUi_BFu16s()
{
  {
    init_simple_test("aUi_BFu16s");
    static STRUCT_IF_C aUi_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s, aUi_BFu16s)
//============================================================================



static void Test_aUi_BFu16s_BFu15i()
{
  {
    init_simple_test("aUi_BFu16s_BFu15i");
    static STRUCT_IF_C aUi_BFu16s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aUi_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aUi_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu15i, aUi_BFu16s_BFu15i)
//============================================================================



static void Test_aUi_BFu16s_BFu15ll()
{
  {
    init_simple_test("aUi_BFu16s_BFu15ll");
    static STRUCT_IF_C aUi_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aUi_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aUi_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu15ll, aUi_BFu16s_BFu15ll)
//============================================================================



static void Test_aUi_BFu16s_BFu15s()
{
  {
    init_simple_test("aUi_BFu16s_BFu15s");
    static STRUCT_IF_C aUi_BFu16s_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aUi_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aUi_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu15s, aUi_BFu16s_BFu15s)
//============================================================================



static void Test_aUi_BFu16s_BFu16i()
{
  {
    init_simple_test("aUi_BFu16s_BFu16i");
    static STRUCT_IF_C aUi_BFu16s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aUi_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu16i, aUi_BFu16s_BFu16i)
//============================================================================



static void Test_aUi_BFu16s_BFu16ll()
{
  {
    init_simple_test("aUi_BFu16s_BFu16ll");
    static STRUCT_IF_C aUi_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aUi_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu16ll, aUi_BFu16s_BFu16ll)
//============================================================================



static void Test_aUi_BFu16s_BFu16s()
{
  {
    init_simple_test("aUi_BFu16s_BFu16s");
    static STRUCT_IF_C aUi_BFu16s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aUi_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu16s, aUi_BFu16s_BFu16s)
//============================================================================



static void Test_aUi_BFu16s_BFu17i()
{
  {
    init_simple_test("aUi_BFu16s_BFu17i");
    static STRUCT_IF_C aUi_BFu16s_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu16s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aUi_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aUi_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu17i, aUi_BFu16s_BFu17i)
//============================================================================



static void Test_aUi_BFu16s_BFu17ll()
{
  {
    init_simple_test("aUi_BFu16s_BFu17ll");
    static STRUCT_IF_C aUi_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu16s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aUi_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aUi_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu17ll, aUi_BFu16s_BFu17ll)
//============================================================================



static void Test_aUi_BFu16s_BFu1c()
{
  {
    init_simple_test("aUi_BFu16s_BFu1c");
    static STRUCT_IF_C aUi_BFu16s_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aUi_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu1c, aUi_BFu16s_BFu1c)
//============================================================================



static void Test_aUi_BFu16s_BFu1i()
{
  {
    init_simple_test("aUi_BFu16s_BFu1i");
    static STRUCT_IF_C aUi_BFu16s_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aUi_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu1i, aUi_BFu16s_BFu1i)
//============================================================================



static void Test_aUi_BFu16s_BFu1ll()
{
  {
    init_simple_test("aUi_BFu16s_BFu1ll");
    static STRUCT_IF_C aUi_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aUi_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu1ll, aUi_BFu16s_BFu1ll)
//============================================================================



static void Test_aUi_BFu16s_BFu1s()
{
  {
    init_simple_test("aUi_BFu16s_BFu1s");
    static STRUCT_IF_C aUi_BFu16s_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aUi_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu1s, aUi_BFu16s_BFu1s)
//============================================================================



static void Test_aUi_BFu16s_BFu31i()
{
  {
    init_simple_test("aUi_BFu16s_BFu31i");
    static STRUCT_IF_C aUi_BFu16s_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aUi_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aUi_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu31i, aUi_BFu16s_BFu31i)
//============================================================================



static void Test_aUi_BFu16s_BFu31ll()
{
  {
    init_simple_test("aUi_BFu16s_BFu31ll");
    static STRUCT_IF_C aUi_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aUi_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aUi_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu31ll, aUi_BFu16s_BFu31ll)
//============================================================================



static void Test_aUi_BFu16s_BFu32i()
{
  {
    init_simple_test("aUi_BFu16s_BFu32i");
    static STRUCT_IF_C aUi_BFu16s_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aUi_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aUi_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu32i, aUi_BFu16s_BFu32i)
//============================================================================



static void Test_aUi_BFu16s_BFu32ll()
{
  {
    init_simple_test("aUi_BFu16s_BFu32ll");
    static STRUCT_IF_C aUi_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aUi_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aUi_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu32ll, aUi_BFu16s_BFu32ll)
//============================================================================



static void Test_aUi_BFu16s_BFu33()
{
  {
    init_simple_test("aUi_BFu16s_BFu33");
    static STRUCT_IF_C aUi_BFu16s_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu16s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "aUi_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "aUi_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu33, aUi_BFu16s_BFu33)
//============================================================================



static void Test_aUi_BFu16s_BFu7c()
{
  {
    init_simple_test("aUi_BFu16s_BFu7c");
    static STRUCT_IF_C aUi_BFu16s_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aUi_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aUi_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu7c, aUi_BFu16s_BFu7c)
//============================================================================



static void Test_aUi_BFu16s_BFu7i()
{
  {
    init_simple_test("aUi_BFu16s_BFu7i");
    static STRUCT_IF_C aUi_BFu16s_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aUi_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aUi_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu7i, aUi_BFu16s_BFu7i)
//============================================================================



static void Test_aUi_BFu16s_BFu7ll()
{
  {
    init_simple_test("aUi_BFu16s_BFu7ll");
    static STRUCT_IF_C aUi_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aUi_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aUi_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu7ll, aUi_BFu16s_BFu7ll)
//============================================================================



static void Test_aUi_BFu16s_BFu7s()
{
  {
    init_simple_test("aUi_BFu16s_BFu7s");
    static STRUCT_IF_C aUi_BFu16s_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aUi_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aUi_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu7s, aUi_BFu16s_BFu7s)
//============================================================================



static void Test_aUi_BFu16s_BFu8c()
{
  {
    init_simple_test("aUi_BFu16s_BFu8c");
    static STRUCT_IF_C aUi_BFu16s_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aUi_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aUi_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu8c, aUi_BFu16s_BFu8c)
//============================================================================



static void Test_aUi_BFu16s_BFu8i()
{
  {
    init_simple_test("aUi_BFu16s_BFu8i");
    static STRUCT_IF_C aUi_BFu16s_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aUi_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aUi_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu8i, aUi_BFu16s_BFu8i)
//============================================================================



static void Test_aUi_BFu16s_BFu8ll()
{
  {
    init_simple_test("aUi_BFu16s_BFu8ll");
    static STRUCT_IF_C aUi_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aUi_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aUi_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu8ll, aUi_BFu16s_BFu8ll)
//============================================================================



static void Test_aUi_BFu16s_BFu8s()
{
  {
    init_simple_test("aUi_BFu16s_BFu8s");
    static STRUCT_IF_C aUi_BFu16s_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aUi_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aUi_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu8s, aUi_BFu16s_BFu8s)
//============================================================================



static void Test_aUi_BFu16s_BFu9i()
{
  {
    init_simple_test("aUi_BFu16s_BFu9i");
    static STRUCT_IF_C aUi_BFu16s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aUi_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aUi_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu9i, aUi_BFu16s_BFu9i)
//============================================================================



static void Test_aUi_BFu16s_BFu9ll()
{
  {
    init_simple_test("aUi_BFu16s_BFu9ll");
    static STRUCT_IF_C aUi_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aUi_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aUi_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu9ll, aUi_BFu16s_BFu9ll)
//============================================================================



static void Test_aUi_BFu16s_BFu9s()
{
  {
    init_simple_test("aUi_BFu16s_BFu9s");
    static STRUCT_IF_C aUi_BFu16s_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aUi_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aUi_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_BFu9s, aUi_BFu16s_BFu9s)
//============================================================================



static void Test_aUi_BFu16s_C()
{
  {
    init_simple_test("aUi_BFu16s_C");
    static STRUCT_IF_C aUi_BFu16s_C lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_C");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_C");
    check_field_offset(lv, v3, 6, "aUi_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_C, aUi_BFu16s_C)
//============================================================================



static void Test_aUi_BFu16s_D()
{
  {
    init_simple_test("aUi_BFu16s_D");
    static STRUCT_IF_C aUi_BFu16s_D lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu16s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_D");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_D");
    check_field_offset(lv, v3, 6, "aUi_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_D, aUi_BFu16s_D)
//============================================================================



static void Test_aUi_BFu16s_F()
{
  {
    init_simple_test("aUi_BFu16s_F");
    static STRUCT_IF_C aUi_BFu16s_F lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_F");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_F");
    check_field_offset(lv, v3, 6, "aUi_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_F, aUi_BFu16s_F)
//============================================================================



static void Test_aUi_BFu16s_I()
{
  {
    init_simple_test("aUi_BFu16s_I");
    static STRUCT_IF_C aUi_BFu16s_I lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_I");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_I");
    check_field_offset(lv, v3, 6, "aUi_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_I, aUi_BFu16s_I)
//============================================================================



static void Test_aUi_BFu16s_Ip()
{
  {
    init_simple_test("aUi_BFu16s_Ip");
    static STRUCT_IF_C aUi_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUi_BFu16s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_Ip");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_Ip");
    check_field_offset(lv, v3, 6, "aUi_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_Ip, aUi_BFu16s_Ip)
//============================================================================



static void Test_aUi_BFu16s_L()
{
  {
    init_simple_test("aUi_BFu16s_L");
    static STRUCT_IF_C aUi_BFu16s_L lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu16s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_L");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_L");
    check_field_offset(lv, v3, 6, "aUi_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_L, aUi_BFu16s_L)
//============================================================================



static void Test_aUi_BFu16s_S()
{
  {
    init_simple_test("aUi_BFu16s_S");
    static STRUCT_IF_C aUi_BFu16s_S lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_S");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_S");
    check_field_offset(lv, v3, 6, "aUi_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_S, aUi_BFu16s_S)
//============================================================================



static void Test_aUi_BFu16s_Uc()
{
  {
    init_simple_test("aUi_BFu16s_Uc");
    static STRUCT_IF_C aUi_BFu16s_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu16s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_Uc");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_Uc");
    check_field_offset(lv, v3, 6, "aUi_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_Uc, aUi_BFu16s_Uc)
//============================================================================



static void Test_aUi_BFu16s_Ui()
{
  {
    init_simple_test("aUi_BFu16s_Ui");
    static STRUCT_IF_C aUi_BFu16s_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu16s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_Ui");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_Ui");
    check_field_offset(lv, v3, 6, "aUi_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_Ui, aUi_BFu16s_Ui)
//============================================================================



static void Test_aUi_BFu16s_Ul()
{
  {
    init_simple_test("aUi_BFu16s_Ul");
    static STRUCT_IF_C aUi_BFu16s_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aUi_BFu16s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_Ul");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_Ul");
    check_field_offset(lv, v3, 6, "aUi_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_Ul, aUi_BFu16s_Ul)
//============================================================================



static void Test_aUi_BFu16s_Us()
{
  {
    init_simple_test("aUi_BFu16s_Us");
    static STRUCT_IF_C aUi_BFu16s_Us lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu16s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_Us");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_Us");
    check_field_offset(lv, v3, 6, "aUi_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_Us, aUi_BFu16s_Us)
//============================================================================



static void Test_aUi_BFu16s_Vp()
{
  {
    init_simple_test("aUi_BFu16s_Vp");
    static STRUCT_IF_C aUi_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aUi_BFu16s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 16, 1, "aUi_BFu16s_Vp");
    set_bf_and_test(lv, v2, 4, 0, 16, hide_ull(1LL<<15), "aUi_BFu16s_Vp");
    check_field_offset(lv, v3, 6, "aUi_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu16s_Vp, aUi_BFu16s_Vp)
//============================================================================



static void Test_aUi_BFu17i()
{
  {
    init_simple_test("aUi_BFu17i");
    static STRUCT_IF_C aUi_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i, aUi_BFu17i)
//============================================================================



static void Test_aUi_BFu17i_BFu15i()
{
  {
    init_simple_test("aUi_BFu17i_BFu15i");
    static STRUCT_IF_C aUi_BFu17i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "aUi_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "aUi_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu15i, aUi_BFu17i_BFu15i)
//============================================================================



static void Test_aUi_BFu17i_BFu15ll()
{
  {
    init_simple_test("aUi_BFu17i_BFu15ll");
    static STRUCT_IF_C aUi_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "aUi_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "aUi_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu15ll, aUi_BFu17i_BFu15ll)
//============================================================================



static void Test_aUi_BFu17i_BFu15s()
{
  {
    init_simple_test("aUi_BFu17i_BFu15s");
    static STRUCT_IF_C aUi_BFu17i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "aUi_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "aUi_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu15s, aUi_BFu17i_BFu15s)
//============================================================================



static void Test_aUi_BFu17i_BFu16i()
{
  {
    init_simple_test("aUi_BFu17i_BFu16i");
    static STRUCT_IF_C aUi_BFu17i_BFu16i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "aUi_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "aUi_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu16i, aUi_BFu17i_BFu16i)
//============================================================================



static void Test_aUi_BFu17i_BFu16ll()
{
  {
    init_simple_test("aUi_BFu17i_BFu16ll");
    static STRUCT_IF_C aUi_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "aUi_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "aUi_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu16ll, aUi_BFu17i_BFu16ll)
//============================================================================



static void Test_aUi_BFu17i_BFu16s()
{
  {
    init_simple_test("aUi_BFu17i_BFu16s");
    static STRUCT_IF_C aUi_BFu17i_BFu16s lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "aUi_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "aUi_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu16s, aUi_BFu17i_BFu16s)
//============================================================================



static void Test_aUi_BFu17i_BFu17i()
{
  {
    init_simple_test("aUi_BFu17i_BFu17i");
    static STRUCT_IF_C aUi_BFu17i_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 6, 1, 17, 1, "aUi_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 6, 1, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu17i, aUi_BFu17i_BFu17i)
//============================================================================



static void Test_aUi_BFu17i_BFu17ll()
{
  {
    init_simple_test("aUi_BFu17i_BFu17ll");
    static STRUCT_IF_C aUi_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 6, 1, 17, 1, "aUi_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 6, 1, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu17ll, aUi_BFu17i_BFu17ll)
//============================================================================



static void Test_aUi_BFu17i_BFu1c()
{
  {
    init_simple_test("aUi_BFu17i_BFu1c");
    static STRUCT_IF_C aUi_BFu17i_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aUi_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu1c, aUi_BFu17i_BFu1c)
//============================================================================



static void Test_aUi_BFu17i_BFu1i()
{
  {
    init_simple_test("aUi_BFu17i_BFu1i");
    static STRUCT_IF_C aUi_BFu17i_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aUi_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu1i, aUi_BFu17i_BFu1i)
//============================================================================



static void Test_aUi_BFu17i_BFu1ll()
{
  {
    init_simple_test("aUi_BFu17i_BFu1ll");
    static STRUCT_IF_C aUi_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aUi_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu1ll, aUi_BFu17i_BFu1ll)
//============================================================================



static void Test_aUi_BFu17i_BFu1s()
{
  {
    init_simple_test("aUi_BFu17i_BFu1s");
    static STRUCT_IF_C aUi_BFu17i_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aUi_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu1s, aUi_BFu17i_BFu1s)
//============================================================================



static void Test_aUi_BFu17i_BFu31i()
{
  {
    init_simple_test("aUi_BFu17i_BFu31i");
    static STRUCT_IF_C aUi_BFu17i_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu17i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 6, 1, 31, 1, "aUi_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 6, 1, 31, hide_ull(1LL<<30), "aUi_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu31i, aUi_BFu17i_BFu31i)
//============================================================================



static void Test_aUi_BFu17i_BFu31ll()
{
  {
    init_simple_test("aUi_BFu17i_BFu31ll");
    static STRUCT_IF_C aUi_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu17i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 6, 1, 31, 1, "aUi_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 6, 1, 31, hide_ull(1LL<<30), "aUi_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu31ll, aUi_BFu17i_BFu31ll)
//============================================================================



static void Test_aUi_BFu17i_BFu32i()
{
  {
    init_simple_test("aUi_BFu17i_BFu32i");
    static STRUCT_IF_C aUi_BFu17i_BFu32i lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu17i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 6, 1, 32, 1, "aUi_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 6, 1, 32, hide_ull(1LL<<31), "aUi_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu32i, aUi_BFu17i_BFu32i)
//============================================================================



static void Test_aUi_BFu17i_BFu32ll()
{
  {
    init_simple_test("aUi_BFu17i_BFu32ll");
    static STRUCT_IF_C aUi_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu17i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 6, 1, 32, 1, "aUi_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 6, 1, 32, hide_ull(1LL<<31), "aUi_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu32ll, aUi_BFu17i_BFu32ll)
//============================================================================



static void Test_aUi_BFu17i_BFu33()
{
  {
    init_simple_test("aUi_BFu17i_BFu33");
    static STRUCT_IF_C aUi_BFu17i_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu17i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 6, 1, 33, 1, "aUi_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 6, 1, 33, hide_ull(1LL<<32), "aUi_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu33, aUi_BFu17i_BFu33)
//============================================================================



static void Test_aUi_BFu17i_BFu7c()
{
  {
    init_simple_test("aUi_BFu17i_BFu7c");
    static STRUCT_IF_C aUi_BFu17i_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aUi_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aUi_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu7c, aUi_BFu17i_BFu7c)
//============================================================================



static void Test_aUi_BFu17i_BFu7i()
{
  {
    init_simple_test("aUi_BFu17i_BFu7i");
    static STRUCT_IF_C aUi_BFu17i_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aUi_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aUi_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu7i, aUi_BFu17i_BFu7i)
//============================================================================



static void Test_aUi_BFu17i_BFu7ll()
{
  {
    init_simple_test("aUi_BFu17i_BFu7ll");
    static STRUCT_IF_C aUi_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aUi_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aUi_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu7ll, aUi_BFu17i_BFu7ll)
//============================================================================



static void Test_aUi_BFu17i_BFu7s()
{
  {
    init_simple_test("aUi_BFu17i_BFu7s");
    static STRUCT_IF_C aUi_BFu17i_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aUi_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aUi_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu7s, aUi_BFu17i_BFu7s)
//============================================================================



static void Test_aUi_BFu17i_BFu8c()
{
  {
    init_simple_test("aUi_BFu17i_BFu8c");
    static STRUCT_IF_C aUi_BFu17i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aUi_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aUi_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu8c, aUi_BFu17i_BFu8c)
//============================================================================



static void Test_aUi_BFu17i_BFu8i()
{
  {
    init_simple_test("aUi_BFu17i_BFu8i");
    static STRUCT_IF_C aUi_BFu17i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aUi_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aUi_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu8i, aUi_BFu17i_BFu8i)
//============================================================================



static void Test_aUi_BFu17i_BFu8ll()
{
  {
    init_simple_test("aUi_BFu17i_BFu8ll");
    static STRUCT_IF_C aUi_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aUi_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aUi_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu8ll, aUi_BFu17i_BFu8ll)
//============================================================================



static void Test_aUi_BFu17i_BFu8s()
{
  {
    init_simple_test("aUi_BFu17i_BFu8s");
    static STRUCT_IF_C aUi_BFu17i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aUi_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aUi_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu8s, aUi_BFu17i_BFu8s)
//============================================================================



static void Test_aUi_BFu17i_BFu9i()
{
  {
    init_simple_test("aUi_BFu17i_BFu9i");
    static STRUCT_IF_C aUi_BFu17i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "aUi_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "aUi_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu9i, aUi_BFu17i_BFu9i)
//============================================================================



static void Test_aUi_BFu17i_BFu9ll()
{
  {
    init_simple_test("aUi_BFu17i_BFu9ll");
    static STRUCT_IF_C aUi_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "aUi_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "aUi_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu9ll, aUi_BFu17i_BFu9ll)
//============================================================================



static void Test_aUi_BFu17i_BFu9s()
{
  {
    init_simple_test("aUi_BFu17i_BFu9s");
    static STRUCT_IF_C aUi_BFu17i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "aUi_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "aUi_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_BFu9s, aUi_BFu17i_BFu9s)
//============================================================================



static void Test_aUi_BFu17i_C()
{
  {
    init_simple_test("aUi_BFu17i_C");
    static STRUCT_IF_C aUi_BFu17i_C lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_C");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_C");
    check_field_offset(lv, v3, 7, "aUi_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_C, aUi_BFu17i_C)
//============================================================================



static void Test_aUi_BFu17i_D()
{
  {
    init_simple_test("aUi_BFu17i_D");
    static STRUCT_IF_C aUi_BFu17i_D lv;
    check2(sizeof(lv), 15, "sizeof(aUi_BFu17i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_D");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_D");
    check_field_offset(lv, v3, 7, "aUi_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_D, aUi_BFu17i_D)
//============================================================================



static void Test_aUi_BFu17i_F()
{
  {
    init_simple_test("aUi_BFu17i_F");
    static STRUCT_IF_C aUi_BFu17i_F lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu17i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_F");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_F");
    check_field_offset(lv, v3, 7, "aUi_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_F, aUi_BFu17i_F)
//============================================================================



static void Test_aUi_BFu17i_I()
{
  {
    init_simple_test("aUi_BFu17i_I");
    static STRUCT_IF_C aUi_BFu17i_I lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu17i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_I");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_I");
    check_field_offset(lv, v3, 7, "aUi_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_I, aUi_BFu17i_I)
//============================================================================



static void Test_aUi_BFu17i_Ip()
{
  {
    init_simple_test("aUi_BFu17i_Ip");
    static STRUCT_IF_C aUi_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aUi_BFu17i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_Ip");
    check_field_offset(lv, v3, 7, "aUi_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_Ip, aUi_BFu17i_Ip)
//============================================================================



static void Test_aUi_BFu17i_L()
{
  {
    init_simple_test("aUi_BFu17i_L");
    static STRUCT_IF_C aUi_BFu17i_L lv;
    check2(sizeof(lv), 15, "sizeof(aUi_BFu17i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_L");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_L");
    check_field_offset(lv, v3, 7, "aUi_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_L, aUi_BFu17i_L)
//============================================================================



static void Test_aUi_BFu17i_S()
{
  {
    init_simple_test("aUi_BFu17i_S");
    static STRUCT_IF_C aUi_BFu17i_S lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_S");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_S");
    check_field_offset(lv, v3, 7, "aUi_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_S, aUi_BFu17i_S)
//============================================================================



static void Test_aUi_BFu17i_Uc()
{
  {
    init_simple_test("aUi_BFu17i_Uc");
    static STRUCT_IF_C aUi_BFu17i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_Uc");
    check_field_offset(lv, v3, 7, "aUi_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_Uc, aUi_BFu17i_Uc)
//============================================================================



static void Test_aUi_BFu17i_Ui()
{
  {
    init_simple_test("aUi_BFu17i_Ui");
    static STRUCT_IF_C aUi_BFu17i_Ui lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu17i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_Ui");
    check_field_offset(lv, v3, 7, "aUi_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_Ui, aUi_BFu17i_Ui)
//============================================================================



static void Test_aUi_BFu17i_Ul()
{
  {
    init_simple_test("aUi_BFu17i_Ul");
    static STRUCT_IF_C aUi_BFu17i_Ul lv;
    check2(sizeof(lv), 15, "sizeof(aUi_BFu17i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_Ul");
    check_field_offset(lv, v3, 7, "aUi_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_Ul, aUi_BFu17i_Ul)
//============================================================================



static void Test_aUi_BFu17i_Us()
{
  {
    init_simple_test("aUi_BFu17i_Us");
    static STRUCT_IF_C aUi_BFu17i_Us lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_Us");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_Us");
    check_field_offset(lv, v3, 7, "aUi_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_Us, aUi_BFu17i_Us)
//============================================================================



static void Test_aUi_BFu17i_Vp()
{
  {
    init_simple_test("aUi_BFu17i_Vp");
    static STRUCT_IF_C aUi_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aUi_BFu17i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17i_Vp");
    check_field_offset(lv, v3, 7, "aUi_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17i_Vp, aUi_BFu17i_Vp)
//============================================================================



static void Test_aUi_BFu17ll()
{
  {
    init_simple_test("aUi_BFu17ll");
    static STRUCT_IF_C aUi_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll, aUi_BFu17ll)
//============================================================================



static void Test_aUi_BFu17ll_BFu15i()
{
  {
    init_simple_test("aUi_BFu17ll_BFu15i");
    static STRUCT_IF_C aUi_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "aUi_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "aUi_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu15i, aUi_BFu17ll_BFu15i)
//============================================================================



static void Test_aUi_BFu17ll_BFu15ll()
{
  {
    init_simple_test("aUi_BFu17ll_BFu15ll");
    static STRUCT_IF_C aUi_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "aUi_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "aUi_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu15ll, aUi_BFu17ll_BFu15ll)
//============================================================================



static void Test_aUi_BFu17ll_BFu15s()
{
  {
    init_simple_test("aUi_BFu17ll_BFu15s");
    static STRUCT_IF_C aUi_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "aUi_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "aUi_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu15s, aUi_BFu17ll_BFu15s)
//============================================================================



static void Test_aUi_BFu17ll_BFu16i()
{
  {
    init_simple_test("aUi_BFu17ll_BFu16i");
    static STRUCT_IF_C aUi_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "aUi_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "aUi_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu16i, aUi_BFu17ll_BFu16i)
//============================================================================



static void Test_aUi_BFu17ll_BFu16ll()
{
  {
    init_simple_test("aUi_BFu17ll_BFu16ll");
    static STRUCT_IF_C aUi_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "aUi_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "aUi_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu16ll, aUi_BFu17ll_BFu16ll)
//============================================================================



static void Test_aUi_BFu17ll_BFu16s()
{
  {
    init_simple_test("aUi_BFu17ll_BFu16s");
    static STRUCT_IF_C aUi_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "aUi_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "aUi_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu16s, aUi_BFu17ll_BFu16s)
//============================================================================



static void Test_aUi_BFu17ll_BFu17i()
{
  {
    init_simple_test("aUi_BFu17ll_BFu17i");
    static STRUCT_IF_C aUi_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 6, 1, 17, 1, "aUi_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 6, 1, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu17i, aUi_BFu17ll_BFu17i)
//============================================================================



static void Test_aUi_BFu17ll_BFu17ll()
{
  {
    init_simple_test("aUi_BFu17ll_BFu17ll");
    static STRUCT_IF_C aUi_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 6, 1, 17, 1, "aUi_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 6, 1, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu17ll, aUi_BFu17ll_BFu17ll)
//============================================================================



static void Test_aUi_BFu17ll_BFu1c()
{
  {
    init_simple_test("aUi_BFu17ll_BFu1c");
    static STRUCT_IF_C aUi_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aUi_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu1c, aUi_BFu17ll_BFu1c)
//============================================================================



static void Test_aUi_BFu17ll_BFu1i()
{
  {
    init_simple_test("aUi_BFu17ll_BFu1i");
    static STRUCT_IF_C aUi_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aUi_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu1i, aUi_BFu17ll_BFu1i)
//============================================================================



static void Test_aUi_BFu17ll_BFu1ll()
{
  {
    init_simple_test("aUi_BFu17ll_BFu1ll");
    static STRUCT_IF_C aUi_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aUi_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu1ll, aUi_BFu17ll_BFu1ll)
//============================================================================



static void Test_aUi_BFu17ll_BFu1s()
{
  {
    init_simple_test("aUi_BFu17ll_BFu1s");
    static STRUCT_IF_C aUi_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aUi_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu1s, aUi_BFu17ll_BFu1s)
//============================================================================



static void Test_aUi_BFu17ll_BFu31i()
{
  {
    init_simple_test("aUi_BFu17ll_BFu31i");
    static STRUCT_IF_C aUi_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu17ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 6, 1, 31, 1, "aUi_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 6, 1, 31, hide_ull(1LL<<30), "aUi_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu31i, aUi_BFu17ll_BFu31i)
//============================================================================



static void Test_aUi_BFu17ll_BFu31ll()
{
  {
    init_simple_test("aUi_BFu17ll_BFu31ll");
    static STRUCT_IF_C aUi_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 6, 1, 31, 1, "aUi_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 6, 1, 31, hide_ull(1LL<<30), "aUi_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu31ll, aUi_BFu17ll_BFu31ll)
//============================================================================



static void Test_aUi_BFu17ll_BFu32i()
{
  {
    init_simple_test("aUi_BFu17ll_BFu32i");
    static STRUCT_IF_C aUi_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu17ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 6, 1, 32, 1, "aUi_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 6, 1, 32, hide_ull(1LL<<31), "aUi_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu32i, aUi_BFu17ll_BFu32i)
//============================================================================



static void Test_aUi_BFu17ll_BFu32ll()
{
  {
    init_simple_test("aUi_BFu17ll_BFu32ll");
    static STRUCT_IF_C aUi_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 6, 1, 32, 1, "aUi_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 6, 1, 32, hide_ull(1LL<<31), "aUi_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu32ll, aUi_BFu17ll_BFu32ll)
//============================================================================



static void Test_aUi_BFu17ll_BFu33()
{
  {
    init_simple_test("aUi_BFu17ll_BFu33");
    static STRUCT_IF_C aUi_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu17ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 6, 1, 33, 1, "aUi_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 6, 1, 33, hide_ull(1LL<<32), "aUi_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu33, aUi_BFu17ll_BFu33)
//============================================================================



static void Test_aUi_BFu17ll_BFu7c()
{
  {
    init_simple_test("aUi_BFu17ll_BFu7c");
    static STRUCT_IF_C aUi_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aUi_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aUi_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu7c, aUi_BFu17ll_BFu7c)
//============================================================================



static void Test_aUi_BFu17ll_BFu7i()
{
  {
    init_simple_test("aUi_BFu17ll_BFu7i");
    static STRUCT_IF_C aUi_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aUi_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aUi_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu7i, aUi_BFu17ll_BFu7i)
//============================================================================



static void Test_aUi_BFu17ll_BFu7ll()
{
  {
    init_simple_test("aUi_BFu17ll_BFu7ll");
    static STRUCT_IF_C aUi_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aUi_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aUi_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu7ll, aUi_BFu17ll_BFu7ll)
//============================================================================



static void Test_aUi_BFu17ll_BFu7s()
{
  {
    init_simple_test("aUi_BFu17ll_BFu7s");
    static STRUCT_IF_C aUi_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu17ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aUi_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aUi_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu7s, aUi_BFu17ll_BFu7s)
//============================================================================



static void Test_aUi_BFu17ll_BFu8c()
{
  {
    init_simple_test("aUi_BFu17ll_BFu8c");
    static STRUCT_IF_C aUi_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aUi_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aUi_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu8c, aUi_BFu17ll_BFu8c)
//============================================================================



static void Test_aUi_BFu17ll_BFu8i()
{
  {
    init_simple_test("aUi_BFu17ll_BFu8i");
    static STRUCT_IF_C aUi_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aUi_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aUi_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu8i, aUi_BFu17ll_BFu8i)
//============================================================================



static void Test_aUi_BFu17ll_BFu8ll()
{
  {
    init_simple_test("aUi_BFu17ll_BFu8ll");
    static STRUCT_IF_C aUi_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aUi_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aUi_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu8ll, aUi_BFu17ll_BFu8ll)
//============================================================================



static void Test_aUi_BFu17ll_BFu8s()
{
  {
    init_simple_test("aUi_BFu17ll_BFu8s");
    static STRUCT_IF_C aUi_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aUi_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aUi_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu8s, aUi_BFu17ll_BFu8s)
//============================================================================



static void Test_aUi_BFu17ll_BFu9i()
{
  {
    init_simple_test("aUi_BFu17ll_BFu9i");
    static STRUCT_IF_C aUi_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "aUi_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "aUi_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu9i, aUi_BFu17ll_BFu9i)
//============================================================================



static void Test_aUi_BFu17ll_BFu9ll()
{
  {
    init_simple_test("aUi_BFu17ll_BFu9ll");
    static STRUCT_IF_C aUi_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "aUi_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "aUi_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu9ll, aUi_BFu17ll_BFu9ll)
//============================================================================



static void Test_aUi_BFu17ll_BFu9s()
{
  {
    init_simple_test("aUi_BFu17ll_BFu9s");
    static STRUCT_IF_C aUi_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "aUi_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "aUi_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_BFu9s, aUi_BFu17ll_BFu9s)
//============================================================================



static void Test_aUi_BFu17ll_C()
{
  {
    init_simple_test("aUi_BFu17ll_C");
    static STRUCT_IF_C aUi_BFu17ll_C lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_C");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_C");
    check_field_offset(lv, v3, 7, "aUi_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_C, aUi_BFu17ll_C)
//============================================================================



static void Test_aUi_BFu17ll_D()
{
  {
    init_simple_test("aUi_BFu17ll_D");
    static STRUCT_IF_C aUi_BFu17ll_D lv;
    check2(sizeof(lv), 15, "sizeof(aUi_BFu17ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_D");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_D");
    check_field_offset(lv, v3, 7, "aUi_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_D, aUi_BFu17ll_D)
//============================================================================



static void Test_aUi_BFu17ll_F()
{
  {
    init_simple_test("aUi_BFu17ll_F");
    static STRUCT_IF_C aUi_BFu17ll_F lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu17ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_F");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_F");
    check_field_offset(lv, v3, 7, "aUi_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_F, aUi_BFu17ll_F)
//============================================================================



static void Test_aUi_BFu17ll_I()
{
  {
    init_simple_test("aUi_BFu17ll_I");
    static STRUCT_IF_C aUi_BFu17ll_I lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu17ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_I");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_I");
    check_field_offset(lv, v3, 7, "aUi_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_I, aUi_BFu17ll_I)
//============================================================================



static void Test_aUi_BFu17ll_Ip()
{
  {
    init_simple_test("aUi_BFu17ll_Ip");
    static STRUCT_IF_C aUi_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aUi_BFu17ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_Ip");
    check_field_offset(lv, v3, 7, "aUi_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_Ip, aUi_BFu17ll_Ip)
//============================================================================



static void Test_aUi_BFu17ll_L()
{
  {
    init_simple_test("aUi_BFu17ll_L");
    static STRUCT_IF_C aUi_BFu17ll_L lv;
    check2(sizeof(lv), 15, "sizeof(aUi_BFu17ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_L");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_L");
    check_field_offset(lv, v3, 7, "aUi_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_L, aUi_BFu17ll_L)
//============================================================================



static void Test_aUi_BFu17ll_S()
{
  {
    init_simple_test("aUi_BFu17ll_S");
    static STRUCT_IF_C aUi_BFu17ll_S lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_S");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_S");
    check_field_offset(lv, v3, 7, "aUi_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_S, aUi_BFu17ll_S)
//============================================================================



static void Test_aUi_BFu17ll_Uc()
{
  {
    init_simple_test("aUi_BFu17ll_Uc");
    static STRUCT_IF_C aUi_BFu17ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu17ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_Uc");
    check_field_offset(lv, v3, 7, "aUi_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_Uc, aUi_BFu17ll_Uc)
//============================================================================



static void Test_aUi_BFu17ll_Ui()
{
  {
    init_simple_test("aUi_BFu17ll_Ui");
    static STRUCT_IF_C aUi_BFu17ll_Ui lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu17ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_Ui");
    check_field_offset(lv, v3, 7, "aUi_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_Ui, aUi_BFu17ll_Ui)
//============================================================================



static void Test_aUi_BFu17ll_Ul()
{
  {
    init_simple_test("aUi_BFu17ll_Ul");
    static STRUCT_IF_C aUi_BFu17ll_Ul lv;
    check2(sizeof(lv), 15, "sizeof(aUi_BFu17ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_Ul");
    check_field_offset(lv, v3, 7, "aUi_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_Ul, aUi_BFu17ll_Ul)
//============================================================================



static void Test_aUi_BFu17ll_Us()
{
  {
    init_simple_test("aUi_BFu17ll_Us");
    static STRUCT_IF_C aUi_BFu17ll_Us lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu17ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_Us");
    check_field_offset(lv, v3, 7, "aUi_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_Us, aUi_BFu17ll_Us)
//============================================================================



static void Test_aUi_BFu17ll_Vp()
{
  {
    init_simple_test("aUi_BFu17ll_Vp");
    static STRUCT_IF_C aUi_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aUi_BFu17ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "aUi_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "aUi_BFu17ll_Vp");
    check_field_offset(lv, v3, 7, "aUi_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu17ll_Vp, aUi_BFu17ll_Vp)
//============================================================================



static void Test_aUi_BFu1c()
{
  {
    init_simple_test("aUi_BFu1c");
    static STRUCT_IF_C aUi_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c, aUi_BFu1c)
//============================================================================



static void Test_aUi_BFu1c_BFu15i()
{
  {
    init_simple_test("aUi_BFu1c_BFu15i");
    static STRUCT_IF_C aUi_BFu1c_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUi_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUi_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu15i, aUi_BFu1c_BFu15i)
//============================================================================



static void Test_aUi_BFu1c_BFu15ll()
{
  {
    init_simple_test("aUi_BFu1c_BFu15ll");
    static STRUCT_IF_C aUi_BFu1c_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUi_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUi_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu15ll, aUi_BFu1c_BFu15ll)
//============================================================================



static void Test_aUi_BFu1c_BFu15s()
{
  {
    init_simple_test("aUi_BFu1c_BFu15s");
    static STRUCT_IF_C aUi_BFu1c_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUi_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUi_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu15s, aUi_BFu1c_BFu15s)
//============================================================================



static void Test_aUi_BFu1c_BFu16i()
{
  {
    init_simple_test("aUi_BFu1c_BFu16i");
    static STRUCT_IF_C aUi_BFu1c_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUi_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUi_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu16i, aUi_BFu1c_BFu16i)
//============================================================================



static void Test_aUi_BFu1c_BFu16ll()
{
  {
    init_simple_test("aUi_BFu1c_BFu16ll");
    static STRUCT_IF_C aUi_BFu1c_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUi_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUi_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu16ll, aUi_BFu1c_BFu16ll)
//============================================================================



static void Test_aUi_BFu1c_BFu16s()
{
  {
    init_simple_test("aUi_BFu1c_BFu16s");
    static STRUCT_IF_C aUi_BFu1c_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUi_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUi_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu16s, aUi_BFu1c_BFu16s)
//============================================================================



static void Test_aUi_BFu1c_BFu17i()
{
  {
    init_simple_test("aUi_BFu1c_BFu17i");
    static STRUCT_IF_C aUi_BFu1c_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aUi_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aUi_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu17i, aUi_BFu1c_BFu17i)
//============================================================================



static void Test_aUi_BFu1c_BFu17ll()
{
  {
    init_simple_test("aUi_BFu1c_BFu17ll");
    static STRUCT_IF_C aUi_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aUi_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aUi_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu17ll, aUi_BFu1c_BFu17ll)
//============================================================================



static void Test_aUi_BFu1c_BFu1c()
{
  {
    init_simple_test("aUi_BFu1c_BFu1c");
    static STRUCT_IF_C aUi_BFu1c_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu1c, aUi_BFu1c_BFu1c)
//============================================================================



static void Test_aUi_BFu1c_BFu1i()
{
  {
    init_simple_test("aUi_BFu1c_BFu1i");
    static STRUCT_IF_C aUi_BFu1c_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu1i, aUi_BFu1c_BFu1i)
//============================================================================



static void Test_aUi_BFu1c_BFu1ll()
{
  {
    init_simple_test("aUi_BFu1c_BFu1ll");
    static STRUCT_IF_C aUi_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu1ll, aUi_BFu1c_BFu1ll)
//============================================================================



static void Test_aUi_BFu1c_BFu1s()
{
  {
    init_simple_test("aUi_BFu1c_BFu1s");
    static STRUCT_IF_C aUi_BFu1c_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu1s, aUi_BFu1c_BFu1s)
//============================================================================



static void Test_aUi_BFu1c_BFu31i()
{
  {
    init_simple_test("aUi_BFu1c_BFu31i");
    static STRUCT_IF_C aUi_BFu1c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu1c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aUi_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aUi_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu31i, aUi_BFu1c_BFu31i)
//============================================================================



static void Test_aUi_BFu1c_BFu31ll()
{
  {
    init_simple_test("aUi_BFu1c_BFu31ll");
    static STRUCT_IF_C aUi_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu1c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aUi_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aUi_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu31ll, aUi_BFu1c_BFu31ll)
//============================================================================



static void Test_aUi_BFu1c_BFu32i()
{
  {
    init_simple_test("aUi_BFu1c_BFu32i");
    static STRUCT_IF_C aUi_BFu1c_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aUi_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aUi_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu32i, aUi_BFu1c_BFu32i)
//============================================================================



static void Test_aUi_BFu1c_BFu32ll()
{
  {
    init_simple_test("aUi_BFu1c_BFu32ll");
    static STRUCT_IF_C aUi_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aUi_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aUi_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu32ll, aUi_BFu1c_BFu32ll)
//============================================================================



static void Test_aUi_BFu1c_BFu33()
{
  {
    init_simple_test("aUi_BFu1c_BFu33");
    static STRUCT_IF_C aUi_BFu1c_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "aUi_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "aUi_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu33, aUi_BFu1c_BFu33)
//============================================================================



static void Test_aUi_BFu1c_BFu7c()
{
  {
    init_simple_test("aUi_BFu1c_BFu7c");
    static STRUCT_IF_C aUi_BFu1c_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu7c, aUi_BFu1c_BFu7c)
//============================================================================



static void Test_aUi_BFu1c_BFu7i()
{
  {
    init_simple_test("aUi_BFu1c_BFu7i");
    static STRUCT_IF_C aUi_BFu1c_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu7i, aUi_BFu1c_BFu7i)
//============================================================================



static void Test_aUi_BFu1c_BFu7ll()
{
  {
    init_simple_test("aUi_BFu1c_BFu7ll");
    static STRUCT_IF_C aUi_BFu1c_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu7ll, aUi_BFu1c_BFu7ll)
//============================================================================



static void Test_aUi_BFu1c_BFu7s()
{
  {
    init_simple_test("aUi_BFu1c_BFu7s");
    static STRUCT_IF_C aUi_BFu1c_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu7s, aUi_BFu1c_BFu7s)
//============================================================================



static void Test_aUi_BFu1c_BFu8c()
{
  {
    init_simple_test("aUi_BFu1c_BFu8c");
    static STRUCT_IF_C aUi_BFu1c_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu8c, aUi_BFu1c_BFu8c)
//============================================================================



static void Test_aUi_BFu1c_BFu8i()
{
  {
    init_simple_test("aUi_BFu1c_BFu8i");
    static STRUCT_IF_C aUi_BFu1c_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu8i, aUi_BFu1c_BFu8i)
//============================================================================



static void Test_aUi_BFu1c_BFu8ll()
{
  {
    init_simple_test("aUi_BFu1c_BFu8ll");
    static STRUCT_IF_C aUi_BFu1c_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu8ll, aUi_BFu1c_BFu8ll)
//============================================================================



static void Test_aUi_BFu1c_BFu8s()
{
  {
    init_simple_test("aUi_BFu1c_BFu8s");
    static STRUCT_IF_C aUi_BFu1c_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu8s, aUi_BFu1c_BFu8s)
//============================================================================



static void Test_aUi_BFu1c_BFu9i()
{
  {
    init_simple_test("aUi_BFu1c_BFu9i");
    static STRUCT_IF_C aUi_BFu1c_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUi_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUi_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu9i, aUi_BFu1c_BFu9i)
//============================================================================



static void Test_aUi_BFu1c_BFu9ll()
{
  {
    init_simple_test("aUi_BFu1c_BFu9ll");
    static STRUCT_IF_C aUi_BFu1c_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUi_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUi_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu9ll, aUi_BFu1c_BFu9ll)
//============================================================================



static void Test_aUi_BFu1c_BFu9s()
{
  {
    init_simple_test("aUi_BFu1c_BFu9s");
    static STRUCT_IF_C aUi_BFu1c_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUi_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUi_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_BFu9s, aUi_BFu1c_BFu9s)
//============================================================================



static void Test_aUi_BFu1c_C()
{
  {
    init_simple_test("aUi_BFu1c_C");
    static STRUCT_IF_C aUi_BFu1c_C lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_C");
    check_field_offset(lv, v3, 5, "aUi_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_C, aUi_BFu1c_C)
//============================================================================



static void Test_aUi_BFu1c_D()
{
  {
    init_simple_test("aUi_BFu1c_D");
    static STRUCT_IF_C aUi_BFu1c_D lv;
    check2(sizeof(lv), 13, "sizeof(aUi_BFu1c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_D");
    check_field_offset(lv, v3, 5, "aUi_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_D, aUi_BFu1c_D)
//============================================================================



static void Test_aUi_BFu1c_F()
{
  {
    init_simple_test("aUi_BFu1c_F");
    static STRUCT_IF_C aUi_BFu1c_F lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_F");
    check_field_offset(lv, v3, 5, "aUi_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_F, aUi_BFu1c_F)
//============================================================================



static void Test_aUi_BFu1c_I()
{
  {
    init_simple_test("aUi_BFu1c_I");
    static STRUCT_IF_C aUi_BFu1c_I lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_I");
    check_field_offset(lv, v3, 5, "aUi_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_I, aUi_BFu1c_I)
//============================================================================



static void Test_aUi_BFu1c_Ip()
{
  {
    init_simple_test("aUi_BFu1c_Ip");
    static STRUCT_IF_C aUi_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUi_BFu1c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_Ip");
    check_field_offset(lv, v3, 5, "aUi_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_Ip, aUi_BFu1c_Ip)
//============================================================================



static void Test_aUi_BFu1c_L()
{
  {
    init_simple_test("aUi_BFu1c_L");
    static STRUCT_IF_C aUi_BFu1c_L lv;
    check2(sizeof(lv), 13, "sizeof(aUi_BFu1c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_L");
    check_field_offset(lv, v3, 5, "aUi_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_L, aUi_BFu1c_L)
//============================================================================



static void Test_aUi_BFu1c_S()
{
  {
    init_simple_test("aUi_BFu1c_S");
    static STRUCT_IF_C aUi_BFu1c_S lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_S");
    check_field_offset(lv, v3, 5, "aUi_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_S, aUi_BFu1c_S)
//============================================================================



static void Test_aUi_BFu1c_Uc()
{
  {
    init_simple_test("aUi_BFu1c_Uc");
    static STRUCT_IF_C aUi_BFu1c_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_Uc");
    check_field_offset(lv, v3, 5, "aUi_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_Uc, aUi_BFu1c_Uc)
//============================================================================



static void Test_aUi_BFu1c_Ui()
{
  {
    init_simple_test("aUi_BFu1c_Ui");
    static STRUCT_IF_C aUi_BFu1c_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_Ui");
    check_field_offset(lv, v3, 5, "aUi_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_Ui, aUi_BFu1c_Ui)
//============================================================================



static void Test_aUi_BFu1c_Ul()
{
  {
    init_simple_test("aUi_BFu1c_Ul");
    static STRUCT_IF_C aUi_BFu1c_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aUi_BFu1c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_Ul");
    check_field_offset(lv, v3, 5, "aUi_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_Ul, aUi_BFu1c_Ul)
//============================================================================



static void Test_aUi_BFu1c_Us()
{
  {
    init_simple_test("aUi_BFu1c_Us");
    static STRUCT_IF_C aUi_BFu1c_Us lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_Us");
    check_field_offset(lv, v3, 5, "aUi_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_Us, aUi_BFu1c_Us)
//============================================================================



static void Test_aUi_BFu1c_Vp()
{
  {
    init_simple_test("aUi_BFu1c_Vp");
    static STRUCT_IF_C aUi_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUi_BFu1c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1c_Vp");
    check_field_offset(lv, v3, 5, "aUi_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1c_Vp, aUi_BFu1c_Vp)
//============================================================================



static void Test_aUi_BFu1i()
{
  {
    init_simple_test("aUi_BFu1i");
    static STRUCT_IF_C aUi_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i, aUi_BFu1i)
//============================================================================



static void Test_aUi_BFu1i_BFu15i()
{
  {
    init_simple_test("aUi_BFu1i_BFu15i");
    static STRUCT_IF_C aUi_BFu1i_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUi_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUi_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu15i, aUi_BFu1i_BFu15i)
//============================================================================



static void Test_aUi_BFu1i_BFu15ll()
{
  {
    init_simple_test("aUi_BFu1i_BFu15ll");
    static STRUCT_IF_C aUi_BFu1i_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUi_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUi_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu15ll, aUi_BFu1i_BFu15ll)
//============================================================================



static void Test_aUi_BFu1i_BFu15s()
{
  {
    init_simple_test("aUi_BFu1i_BFu15s");
    static STRUCT_IF_C aUi_BFu1i_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUi_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUi_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu15s, aUi_BFu1i_BFu15s)
//============================================================================



static void Test_aUi_BFu1i_BFu16i()
{
  {
    init_simple_test("aUi_BFu1i_BFu16i");
    static STRUCT_IF_C aUi_BFu1i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUi_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUi_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu16i, aUi_BFu1i_BFu16i)
//============================================================================



static void Test_aUi_BFu1i_BFu16ll()
{
  {
    init_simple_test("aUi_BFu1i_BFu16ll");
    static STRUCT_IF_C aUi_BFu1i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUi_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUi_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu16ll, aUi_BFu1i_BFu16ll)
//============================================================================



static void Test_aUi_BFu1i_BFu16s()
{
  {
    init_simple_test("aUi_BFu1i_BFu16s");
    static STRUCT_IF_C aUi_BFu1i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUi_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUi_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu16s, aUi_BFu1i_BFu16s)
//============================================================================



static void Test_aUi_BFu1i_BFu17i()
{
  {
    init_simple_test("aUi_BFu1i_BFu17i");
    static STRUCT_IF_C aUi_BFu1i_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aUi_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aUi_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu17i, aUi_BFu1i_BFu17i)
//============================================================================



static void Test_aUi_BFu1i_BFu17ll()
{
  {
    init_simple_test("aUi_BFu1i_BFu17ll");
    static STRUCT_IF_C aUi_BFu1i_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aUi_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aUi_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu17ll, aUi_BFu1i_BFu17ll)
//============================================================================



static void Test_aUi_BFu1i_BFu1c()
{
  {
    init_simple_test("aUi_BFu1i_BFu1c");
    static STRUCT_IF_C aUi_BFu1i_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu1c, aUi_BFu1i_BFu1c)
//============================================================================



static void Test_aUi_BFu1i_BFu1i()
{
  {
    init_simple_test("aUi_BFu1i_BFu1i");
    static STRUCT_IF_C aUi_BFu1i_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu1i, aUi_BFu1i_BFu1i)
//============================================================================



static void Test_aUi_BFu1i_BFu1ll()
{
  {
    init_simple_test("aUi_BFu1i_BFu1ll");
    static STRUCT_IF_C aUi_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu1ll, aUi_BFu1i_BFu1ll)
//============================================================================



static void Test_aUi_BFu1i_BFu1s()
{
  {
    init_simple_test("aUi_BFu1i_BFu1s");
    static STRUCT_IF_C aUi_BFu1i_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu1s, aUi_BFu1i_BFu1s)
//============================================================================



static void Test_aUi_BFu1i_BFu31i()
{
  {
    init_simple_test("aUi_BFu1i_BFu31i");
    static STRUCT_IF_C aUi_BFu1i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu1i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aUi_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aUi_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu31i, aUi_BFu1i_BFu31i)
//============================================================================



static void Test_aUi_BFu1i_BFu31ll()
{
  {
    init_simple_test("aUi_BFu1i_BFu31ll");
    static STRUCT_IF_C aUi_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu1i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aUi_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aUi_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu31ll, aUi_BFu1i_BFu31ll)
//============================================================================



static void Test_aUi_BFu1i_BFu32i()
{
  {
    init_simple_test("aUi_BFu1i_BFu32i");
    static STRUCT_IF_C aUi_BFu1i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aUi_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aUi_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu32i, aUi_BFu1i_BFu32i)
//============================================================================



static void Test_aUi_BFu1i_BFu32ll()
{
  {
    init_simple_test("aUi_BFu1i_BFu32ll");
    static STRUCT_IF_C aUi_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aUi_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aUi_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu32ll, aUi_BFu1i_BFu32ll)
//============================================================================



static void Test_aUi_BFu1i_BFu33()
{
  {
    init_simple_test("aUi_BFu1i_BFu33");
    static STRUCT_IF_C aUi_BFu1i_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "aUi_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "aUi_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu33, aUi_BFu1i_BFu33)
//============================================================================



static void Test_aUi_BFu1i_BFu7c()
{
  {
    init_simple_test("aUi_BFu1i_BFu7c");
    static STRUCT_IF_C aUi_BFu1i_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu7c, aUi_BFu1i_BFu7c)
//============================================================================



static void Test_aUi_BFu1i_BFu7i()
{
  {
    init_simple_test("aUi_BFu1i_BFu7i");
    static STRUCT_IF_C aUi_BFu1i_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu7i, aUi_BFu1i_BFu7i)
//============================================================================



static void Test_aUi_BFu1i_BFu7ll()
{
  {
    init_simple_test("aUi_BFu1i_BFu7ll");
    static STRUCT_IF_C aUi_BFu1i_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu7ll, aUi_BFu1i_BFu7ll)
//============================================================================



static void Test_aUi_BFu1i_BFu7s()
{
  {
    init_simple_test("aUi_BFu1i_BFu7s");
    static STRUCT_IF_C aUi_BFu1i_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu7s, aUi_BFu1i_BFu7s)
//============================================================================



static void Test_aUi_BFu1i_BFu8c()
{
  {
    init_simple_test("aUi_BFu1i_BFu8c");
    static STRUCT_IF_C aUi_BFu1i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu8c, aUi_BFu1i_BFu8c)
//============================================================================



static void Test_aUi_BFu1i_BFu8i()
{
  {
    init_simple_test("aUi_BFu1i_BFu8i");
    static STRUCT_IF_C aUi_BFu1i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu8i, aUi_BFu1i_BFu8i)
//============================================================================



static void Test_aUi_BFu1i_BFu8ll()
{
  {
    init_simple_test("aUi_BFu1i_BFu8ll");
    static STRUCT_IF_C aUi_BFu1i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu8ll, aUi_BFu1i_BFu8ll)
//============================================================================



static void Test_aUi_BFu1i_BFu8s()
{
  {
    init_simple_test("aUi_BFu1i_BFu8s");
    static STRUCT_IF_C aUi_BFu1i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu8s, aUi_BFu1i_BFu8s)
//============================================================================



static void Test_aUi_BFu1i_BFu9i()
{
  {
    init_simple_test("aUi_BFu1i_BFu9i");
    static STRUCT_IF_C aUi_BFu1i_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUi_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUi_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu9i, aUi_BFu1i_BFu9i)
//============================================================================



static void Test_aUi_BFu1i_BFu9ll()
{
  {
    init_simple_test("aUi_BFu1i_BFu9ll");
    static STRUCT_IF_C aUi_BFu1i_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUi_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUi_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu9ll, aUi_BFu1i_BFu9ll)
//============================================================================



static void Test_aUi_BFu1i_BFu9s()
{
  {
    init_simple_test("aUi_BFu1i_BFu9s");
    static STRUCT_IF_C aUi_BFu1i_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUi_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUi_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_BFu9s, aUi_BFu1i_BFu9s)
//============================================================================



static void Test_aUi_BFu1i_C()
{
  {
    init_simple_test("aUi_BFu1i_C");
    static STRUCT_IF_C aUi_BFu1i_C lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_C");
    check_field_offset(lv, v3, 5, "aUi_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_C, aUi_BFu1i_C)
//============================================================================



static void Test_aUi_BFu1i_D()
{
  {
    init_simple_test("aUi_BFu1i_D");
    static STRUCT_IF_C aUi_BFu1i_D lv;
    check2(sizeof(lv), 13, "sizeof(aUi_BFu1i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_D");
    check_field_offset(lv, v3, 5, "aUi_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_D, aUi_BFu1i_D)
//============================================================================



static void Test_aUi_BFu1i_F()
{
  {
    init_simple_test("aUi_BFu1i_F");
    static STRUCT_IF_C aUi_BFu1i_F lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_F");
    check_field_offset(lv, v3, 5, "aUi_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_F, aUi_BFu1i_F)
//============================================================================



static void Test_aUi_BFu1i_I()
{
  {
    init_simple_test("aUi_BFu1i_I");
    static STRUCT_IF_C aUi_BFu1i_I lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_I");
    check_field_offset(lv, v3, 5, "aUi_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_I, aUi_BFu1i_I)
//============================================================================



static void Test_aUi_BFu1i_Ip()
{
  {
    init_simple_test("aUi_BFu1i_Ip");
    static STRUCT_IF_C aUi_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUi_BFu1i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_Ip");
    check_field_offset(lv, v3, 5, "aUi_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_Ip, aUi_BFu1i_Ip)
//============================================================================



static void Test_aUi_BFu1i_L()
{
  {
    init_simple_test("aUi_BFu1i_L");
    static STRUCT_IF_C aUi_BFu1i_L lv;
    check2(sizeof(lv), 13, "sizeof(aUi_BFu1i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_L");
    check_field_offset(lv, v3, 5, "aUi_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_L, aUi_BFu1i_L)
//============================================================================



static void Test_aUi_BFu1i_S()
{
  {
    init_simple_test("aUi_BFu1i_S");
    static STRUCT_IF_C aUi_BFu1i_S lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_S");
    check_field_offset(lv, v3, 5, "aUi_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_S, aUi_BFu1i_S)
//============================================================================



static void Test_aUi_BFu1i_Uc()
{
  {
    init_simple_test("aUi_BFu1i_Uc");
    static STRUCT_IF_C aUi_BFu1i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_Uc");
    check_field_offset(lv, v3, 5, "aUi_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_Uc, aUi_BFu1i_Uc)
//============================================================================



static void Test_aUi_BFu1i_Ui()
{
  {
    init_simple_test("aUi_BFu1i_Ui");
    static STRUCT_IF_C aUi_BFu1i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_Ui");
    check_field_offset(lv, v3, 5, "aUi_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_Ui, aUi_BFu1i_Ui)
//============================================================================



static void Test_aUi_BFu1i_Ul()
{
  {
    init_simple_test("aUi_BFu1i_Ul");
    static STRUCT_IF_C aUi_BFu1i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aUi_BFu1i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_Ul");
    check_field_offset(lv, v3, 5, "aUi_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_Ul, aUi_BFu1i_Ul)
//============================================================================



static void Test_aUi_BFu1i_Us()
{
  {
    init_simple_test("aUi_BFu1i_Us");
    static STRUCT_IF_C aUi_BFu1i_Us lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_Us");
    check_field_offset(lv, v3, 5, "aUi_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_Us, aUi_BFu1i_Us)
//============================================================================



static void Test_aUi_BFu1i_Vp()
{
  {
    init_simple_test("aUi_BFu1i_Vp");
    static STRUCT_IF_C aUi_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUi_BFu1i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1i_Vp");
    check_field_offset(lv, v3, 5, "aUi_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1i_Vp, aUi_BFu1i_Vp)
//============================================================================



static void Test_aUi_BFu1ll()
{
  {
    init_simple_test("aUi_BFu1ll");
    static STRUCT_IF_C aUi_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll, aUi_BFu1ll)
//============================================================================



static void Test_aUi_BFu1ll_BFu15i()
{
  {
    init_simple_test("aUi_BFu1ll_BFu15i");
    static STRUCT_IF_C aUi_BFu1ll_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUi_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUi_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu15i, aUi_BFu1ll_BFu15i)
//============================================================================



static void Test_aUi_BFu1ll_BFu15ll()
{
  {
    init_simple_test("aUi_BFu1ll_BFu15ll");
    static STRUCT_IF_C aUi_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUi_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUi_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu15ll, aUi_BFu1ll_BFu15ll)
//============================================================================



static void Test_aUi_BFu1ll_BFu15s()
{
  {
    init_simple_test("aUi_BFu1ll_BFu15s");
    static STRUCT_IF_C aUi_BFu1ll_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUi_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUi_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu15s, aUi_BFu1ll_BFu15s)
//============================================================================



static void Test_aUi_BFu1ll_BFu16i()
{
  {
    init_simple_test("aUi_BFu1ll_BFu16i");
    static STRUCT_IF_C aUi_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUi_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUi_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu16i, aUi_BFu1ll_BFu16i)
//============================================================================



static void Test_aUi_BFu1ll_BFu16ll()
{
  {
    init_simple_test("aUi_BFu1ll_BFu16ll");
    static STRUCT_IF_C aUi_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUi_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUi_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu16ll, aUi_BFu1ll_BFu16ll)
//============================================================================



static void Test_aUi_BFu1ll_BFu16s()
{
  {
    init_simple_test("aUi_BFu1ll_BFu16s");
    static STRUCT_IF_C aUi_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUi_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUi_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu16s, aUi_BFu1ll_BFu16s)
//============================================================================



static void Test_aUi_BFu1ll_BFu17i()
{
  {
    init_simple_test("aUi_BFu1ll_BFu17i");
    static STRUCT_IF_C aUi_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aUi_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aUi_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu17i, aUi_BFu1ll_BFu17i)
//============================================================================



static void Test_aUi_BFu1ll_BFu17ll()
{
  {
    init_simple_test("aUi_BFu1ll_BFu17ll");
    static STRUCT_IF_C aUi_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aUi_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aUi_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu17ll, aUi_BFu1ll_BFu17ll)
//============================================================================



static void Test_aUi_BFu1ll_BFu1c()
{
  {
    init_simple_test("aUi_BFu1ll_BFu1c");
    static STRUCT_IF_C aUi_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu1c, aUi_BFu1ll_BFu1c)
//============================================================================



static void Test_aUi_BFu1ll_BFu1i()
{
  {
    init_simple_test("aUi_BFu1ll_BFu1i");
    static STRUCT_IF_C aUi_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu1i, aUi_BFu1ll_BFu1i)
//============================================================================



static void Test_aUi_BFu1ll_BFu1ll()
{
  {
    init_simple_test("aUi_BFu1ll_BFu1ll");
    static STRUCT_IF_C aUi_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu1ll, aUi_BFu1ll_BFu1ll)
//============================================================================



static void Test_aUi_BFu1ll_BFu1s()
{
  {
    init_simple_test("aUi_BFu1ll_BFu1s");
    static STRUCT_IF_C aUi_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu1s, aUi_BFu1ll_BFu1s)
//============================================================================



static void Test_aUi_BFu1ll_BFu31i()
{
  {
    init_simple_test("aUi_BFu1ll_BFu31i");
    static STRUCT_IF_C aUi_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu1ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aUi_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aUi_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu31i, aUi_BFu1ll_BFu31i)
//============================================================================



static void Test_aUi_BFu1ll_BFu31ll()
{
  {
    init_simple_test("aUi_BFu1ll_BFu31ll");
    static STRUCT_IF_C aUi_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aUi_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aUi_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu31ll, aUi_BFu1ll_BFu31ll)
//============================================================================



static void Test_aUi_BFu1ll_BFu32i()
{
  {
    init_simple_test("aUi_BFu1ll_BFu32i");
    static STRUCT_IF_C aUi_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aUi_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aUi_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu32i, aUi_BFu1ll_BFu32i)
//============================================================================



static void Test_aUi_BFu1ll_BFu32ll()
{
  {
    init_simple_test("aUi_BFu1ll_BFu32ll");
    static STRUCT_IF_C aUi_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aUi_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aUi_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu32ll, aUi_BFu1ll_BFu32ll)
//============================================================================



static void Test_aUi_BFu1ll_BFu33()
{
  {
    init_simple_test("aUi_BFu1ll_BFu33");
    static STRUCT_IF_C aUi_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "aUi_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "aUi_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu33, aUi_BFu1ll_BFu33)
//============================================================================



static void Test_aUi_BFu1ll_BFu7c()
{
  {
    init_simple_test("aUi_BFu1ll_BFu7c");
    static STRUCT_IF_C aUi_BFu1ll_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu7c, aUi_BFu1ll_BFu7c)
//============================================================================



static void Test_aUi_BFu1ll_BFu7i()
{
  {
    init_simple_test("aUi_BFu1ll_BFu7i");
    static STRUCT_IF_C aUi_BFu1ll_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu7i, aUi_BFu1ll_BFu7i)
//============================================================================



static void Test_aUi_BFu1ll_BFu7ll()
{
  {
    init_simple_test("aUi_BFu1ll_BFu7ll");
    static STRUCT_IF_C aUi_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu7ll, aUi_BFu1ll_BFu7ll)
//============================================================================



static void Test_aUi_BFu1ll_BFu7s()
{
  {
    init_simple_test("aUi_BFu1ll_BFu7s");
    static STRUCT_IF_C aUi_BFu1ll_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu7s, aUi_BFu1ll_BFu7s)
//============================================================================



static void Test_aUi_BFu1ll_BFu8c()
{
  {
    init_simple_test("aUi_BFu1ll_BFu8c");
    static STRUCT_IF_C aUi_BFu1ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu8c, aUi_BFu1ll_BFu8c)
//============================================================================



static void Test_aUi_BFu1ll_BFu8i()
{
  {
    init_simple_test("aUi_BFu1ll_BFu8i");
    static STRUCT_IF_C aUi_BFu1ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu8i, aUi_BFu1ll_BFu8i)
//============================================================================



static void Test_aUi_BFu1ll_BFu8ll()
{
  {
    init_simple_test("aUi_BFu1ll_BFu8ll");
    static STRUCT_IF_C aUi_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu8ll, aUi_BFu1ll_BFu8ll)
//============================================================================



static void Test_aUi_BFu1ll_BFu8s()
{
  {
    init_simple_test("aUi_BFu1ll_BFu8s");
    static STRUCT_IF_C aUi_BFu1ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu8s, aUi_BFu1ll_BFu8s)
//============================================================================



static void Test_aUi_BFu1ll_BFu9i()
{
  {
    init_simple_test("aUi_BFu1ll_BFu9i");
    static STRUCT_IF_C aUi_BFu1ll_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUi_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUi_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu9i, aUi_BFu1ll_BFu9i)
//============================================================================



static void Test_aUi_BFu1ll_BFu9ll()
{
  {
    init_simple_test("aUi_BFu1ll_BFu9ll");
    static STRUCT_IF_C aUi_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUi_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUi_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu9ll, aUi_BFu1ll_BFu9ll)
//============================================================================



static void Test_aUi_BFu1ll_BFu9s()
{
  {
    init_simple_test("aUi_BFu1ll_BFu9s");
    static STRUCT_IF_C aUi_BFu1ll_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUi_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUi_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_BFu9s, aUi_BFu1ll_BFu9s)
//============================================================================



static void Test_aUi_BFu1ll_C()
{
  {
    init_simple_test("aUi_BFu1ll_C");
    static STRUCT_IF_C aUi_BFu1ll_C lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_C");
    check_field_offset(lv, v3, 5, "aUi_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_C, aUi_BFu1ll_C)
//============================================================================



static void Test_aUi_BFu1ll_D()
{
  {
    init_simple_test("aUi_BFu1ll_D");
    static STRUCT_IF_C aUi_BFu1ll_D lv;
    check2(sizeof(lv), 13, "sizeof(aUi_BFu1ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_D");
    check_field_offset(lv, v3, 5, "aUi_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_D, aUi_BFu1ll_D)
//============================================================================



static void Test_aUi_BFu1ll_F()
{
  {
    init_simple_test("aUi_BFu1ll_F");
    static STRUCT_IF_C aUi_BFu1ll_F lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_F");
    check_field_offset(lv, v3, 5, "aUi_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_F, aUi_BFu1ll_F)
//============================================================================



static void Test_aUi_BFu1ll_I()
{
  {
    init_simple_test("aUi_BFu1ll_I");
    static STRUCT_IF_C aUi_BFu1ll_I lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_I");
    check_field_offset(lv, v3, 5, "aUi_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_I, aUi_BFu1ll_I)
//============================================================================



static void Test_aUi_BFu1ll_Ip()
{
  {
    init_simple_test("aUi_BFu1ll_Ip");
    static STRUCT_IF_C aUi_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUi_BFu1ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_Ip");
    check_field_offset(lv, v3, 5, "aUi_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_Ip, aUi_BFu1ll_Ip)
//============================================================================



static void Test_aUi_BFu1ll_L()
{
  {
    init_simple_test("aUi_BFu1ll_L");
    static STRUCT_IF_C aUi_BFu1ll_L lv;
    check2(sizeof(lv), 13, "sizeof(aUi_BFu1ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_L");
    check_field_offset(lv, v3, 5, "aUi_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_L, aUi_BFu1ll_L)
//============================================================================



static void Test_aUi_BFu1ll_S()
{
  {
    init_simple_test("aUi_BFu1ll_S");
    static STRUCT_IF_C aUi_BFu1ll_S lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_S");
    check_field_offset(lv, v3, 5, "aUi_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_S, aUi_BFu1ll_S)
//============================================================================



static void Test_aUi_BFu1ll_Uc()
{
  {
    init_simple_test("aUi_BFu1ll_Uc");
    static STRUCT_IF_C aUi_BFu1ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_Uc");
    check_field_offset(lv, v3, 5, "aUi_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_Uc, aUi_BFu1ll_Uc)
//============================================================================



static void Test_aUi_BFu1ll_Ui()
{
  {
    init_simple_test("aUi_BFu1ll_Ui");
    static STRUCT_IF_C aUi_BFu1ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_Ui");
    check_field_offset(lv, v3, 5, "aUi_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_Ui, aUi_BFu1ll_Ui)
//============================================================================



static void Test_aUi_BFu1ll_Ul()
{
  {
    init_simple_test("aUi_BFu1ll_Ul");
    static STRUCT_IF_C aUi_BFu1ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aUi_BFu1ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_Ul");
    check_field_offset(lv, v3, 5, "aUi_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_Ul, aUi_BFu1ll_Ul)
//============================================================================



static void Test_aUi_BFu1ll_Us()
{
  {
    init_simple_test("aUi_BFu1ll_Us");
    static STRUCT_IF_C aUi_BFu1ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_Us");
    check_field_offset(lv, v3, 5, "aUi_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_Us, aUi_BFu1ll_Us)
//============================================================================



static void Test_aUi_BFu1ll_Vp()
{
  {
    init_simple_test("aUi_BFu1ll_Vp");
    static STRUCT_IF_C aUi_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUi_BFu1ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1ll_Vp");
    check_field_offset(lv, v3, 5, "aUi_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1ll_Vp, aUi_BFu1ll_Vp)
//============================================================================



static void Test_aUi_BFu1s()
{
  {
    init_simple_test("aUi_BFu1s");
    static STRUCT_IF_C aUi_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s, aUi_BFu1s)
//============================================================================



static void Test_aUi_BFu1s_BFu15i()
{
  {
    init_simple_test("aUi_BFu1s_BFu15i");
    static STRUCT_IF_C aUi_BFu1s_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUi_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUi_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu15i, aUi_BFu1s_BFu15i)
//============================================================================



static void Test_aUi_BFu1s_BFu15ll()
{
  {
    init_simple_test("aUi_BFu1s_BFu15ll");
    static STRUCT_IF_C aUi_BFu1s_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUi_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUi_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu15ll, aUi_BFu1s_BFu15ll)
//============================================================================



static void Test_aUi_BFu1s_BFu15s()
{
  {
    init_simple_test("aUi_BFu1s_BFu15s");
    static STRUCT_IF_C aUi_BFu1s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aUi_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aUi_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu15s, aUi_BFu1s_BFu15s)
//============================================================================



static void Test_aUi_BFu1s_BFu16i()
{
  {
    init_simple_test("aUi_BFu1s_BFu16i");
    static STRUCT_IF_C aUi_BFu1s_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUi_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUi_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu16i, aUi_BFu1s_BFu16i)
//============================================================================



static void Test_aUi_BFu1s_BFu16ll()
{
  {
    init_simple_test("aUi_BFu1s_BFu16ll");
    static STRUCT_IF_C aUi_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUi_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUi_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu16ll, aUi_BFu1s_BFu16ll)
//============================================================================



static void Test_aUi_BFu1s_BFu16s()
{
  {
    init_simple_test("aUi_BFu1s_BFu16s");
    static STRUCT_IF_C aUi_BFu1s_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aUi_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aUi_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu16s, aUi_BFu1s_BFu16s)
//============================================================================



static void Test_aUi_BFu1s_BFu17i()
{
  {
    init_simple_test("aUi_BFu1s_BFu17i");
    static STRUCT_IF_C aUi_BFu1s_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aUi_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aUi_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu17i, aUi_BFu1s_BFu17i)
//============================================================================



static void Test_aUi_BFu1s_BFu17ll()
{
  {
    init_simple_test("aUi_BFu1s_BFu17ll");
    static STRUCT_IF_C aUi_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aUi_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aUi_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu17ll, aUi_BFu1s_BFu17ll)
//============================================================================



static void Test_aUi_BFu1s_BFu1c()
{
  {
    init_simple_test("aUi_BFu1s_BFu1c");
    static STRUCT_IF_C aUi_BFu1s_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu1c, aUi_BFu1s_BFu1c)
//============================================================================



static void Test_aUi_BFu1s_BFu1i()
{
  {
    init_simple_test("aUi_BFu1s_BFu1i");
    static STRUCT_IF_C aUi_BFu1s_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu1i, aUi_BFu1s_BFu1i)
//============================================================================



static void Test_aUi_BFu1s_BFu1ll()
{
  {
    init_simple_test("aUi_BFu1s_BFu1ll");
    static STRUCT_IF_C aUi_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu1ll, aUi_BFu1s_BFu1ll)
//============================================================================



static void Test_aUi_BFu1s_BFu1s()
{
  {
    init_simple_test("aUi_BFu1s_BFu1s");
    static STRUCT_IF_C aUi_BFu1s_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aUi_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu1s, aUi_BFu1s_BFu1s)
//============================================================================



static void Test_aUi_BFu1s_BFu31i()
{
  {
    init_simple_test("aUi_BFu1s_BFu31i");
    static STRUCT_IF_C aUi_BFu1s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu1s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aUi_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aUi_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu31i, aUi_BFu1s_BFu31i)
//============================================================================



static void Test_aUi_BFu1s_BFu31ll()
{
  {
    init_simple_test("aUi_BFu1s_BFu31ll");
    static STRUCT_IF_C aUi_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu1s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aUi_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aUi_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu31ll, aUi_BFu1s_BFu31ll)
//============================================================================



static void Test_aUi_BFu1s_BFu32i()
{
  {
    init_simple_test("aUi_BFu1s_BFu32i");
    static STRUCT_IF_C aUi_BFu1s_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aUi_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aUi_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu32i, aUi_BFu1s_BFu32i)
//============================================================================



static void Test_aUi_BFu1s_BFu32ll()
{
  {
    init_simple_test("aUi_BFu1s_BFu32ll");
    static STRUCT_IF_C aUi_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aUi_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aUi_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu32ll, aUi_BFu1s_BFu32ll)
//============================================================================



static void Test_aUi_BFu1s_BFu33()
{
  {
    init_simple_test("aUi_BFu1s_BFu33");
    static STRUCT_IF_C aUi_BFu1s_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "aUi_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "aUi_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu33, aUi_BFu1s_BFu33)
//============================================================================



static void Test_aUi_BFu1s_BFu7c()
{
  {
    init_simple_test("aUi_BFu1s_BFu7c");
    static STRUCT_IF_C aUi_BFu1s_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu7c, aUi_BFu1s_BFu7c)
//============================================================================



static void Test_aUi_BFu1s_BFu7i()
{
  {
    init_simple_test("aUi_BFu1s_BFu7i");
    static STRUCT_IF_C aUi_BFu1s_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu7i, aUi_BFu1s_BFu7i)
//============================================================================



static void Test_aUi_BFu1s_BFu7ll()
{
  {
    init_simple_test("aUi_BFu1s_BFu7ll");
    static STRUCT_IF_C aUi_BFu1s_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu7ll, aUi_BFu1s_BFu7ll)
//============================================================================



static void Test_aUi_BFu1s_BFu7s()
{
  {
    init_simple_test("aUi_BFu1s_BFu7s");
    static STRUCT_IF_C aUi_BFu1s_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aUi_BFu1s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aUi_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aUi_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu7s, aUi_BFu1s_BFu7s)
//============================================================================



static void Test_aUi_BFu1s_BFu8c()
{
  {
    init_simple_test("aUi_BFu1s_BFu8c");
    static STRUCT_IF_C aUi_BFu1s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu8c, aUi_BFu1s_BFu8c)
//============================================================================



static void Test_aUi_BFu1s_BFu8i()
{
  {
    init_simple_test("aUi_BFu1s_BFu8i");
    static STRUCT_IF_C aUi_BFu1s_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu8i, aUi_BFu1s_BFu8i)
//============================================================================



static void Test_aUi_BFu1s_BFu8ll()
{
  {
    init_simple_test("aUi_BFu1s_BFu8ll");
    static STRUCT_IF_C aUi_BFu1s_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu8ll, aUi_BFu1s_BFu8ll)
//============================================================================



static void Test_aUi_BFu1s_BFu8s()
{
  {
    init_simple_test("aUi_BFu1s_BFu8s");
    static STRUCT_IF_C aUi_BFu1s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aUi_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aUi_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu8s, aUi_BFu1s_BFu8s)
//============================================================================



static void Test_aUi_BFu1s_BFu9i()
{
  {
    init_simple_test("aUi_BFu1s_BFu9i");
    static STRUCT_IF_C aUi_BFu1s_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUi_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUi_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu9i, aUi_BFu1s_BFu9i)
//============================================================================



static void Test_aUi_BFu1s_BFu9ll()
{
  {
    init_simple_test("aUi_BFu1s_BFu9ll");
    static STRUCT_IF_C aUi_BFu1s_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUi_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUi_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu9ll, aUi_BFu1s_BFu9ll)
//============================================================================



static void Test_aUi_BFu1s_BFu9s()
{
  {
    init_simple_test("aUi_BFu1s_BFu9s");
    static STRUCT_IF_C aUi_BFu1s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aUi_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aUi_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_BFu9s, aUi_BFu1s_BFu9s)
//============================================================================



static void Test_aUi_BFu1s_C()
{
  {
    init_simple_test("aUi_BFu1s_C");
    static STRUCT_IF_C aUi_BFu1s_C lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_C");
    check_field_offset(lv, v3, 5, "aUi_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_C, aUi_BFu1s_C)
//============================================================================



static void Test_aUi_BFu1s_D()
{
  {
    init_simple_test("aUi_BFu1s_D");
    static STRUCT_IF_C aUi_BFu1s_D lv;
    check2(sizeof(lv), 13, "sizeof(aUi_BFu1s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_D");
    check_field_offset(lv, v3, 5, "aUi_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_D, aUi_BFu1s_D)
//============================================================================



static void Test_aUi_BFu1s_F()
{
  {
    init_simple_test("aUi_BFu1s_F");
    static STRUCT_IF_C aUi_BFu1s_F lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_F");
    check_field_offset(lv, v3, 5, "aUi_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_F, aUi_BFu1s_F)
//============================================================================



static void Test_aUi_BFu1s_I()
{
  {
    init_simple_test("aUi_BFu1s_I");
    static STRUCT_IF_C aUi_BFu1s_I lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_I");
    check_field_offset(lv, v3, 5, "aUi_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_I, aUi_BFu1s_I)
//============================================================================



static void Test_aUi_BFu1s_Ip()
{
  {
    init_simple_test("aUi_BFu1s_Ip");
    static STRUCT_IF_C aUi_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUi_BFu1s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_Ip");
    check_field_offset(lv, v3, 5, "aUi_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_Ip, aUi_BFu1s_Ip)
//============================================================================



static void Test_aUi_BFu1s_L()
{
  {
    init_simple_test("aUi_BFu1s_L");
    static STRUCT_IF_C aUi_BFu1s_L lv;
    check2(sizeof(lv), 13, "sizeof(aUi_BFu1s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_L");
    check_field_offset(lv, v3, 5, "aUi_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_L, aUi_BFu1s_L)
//============================================================================



static void Test_aUi_BFu1s_S()
{
  {
    init_simple_test("aUi_BFu1s_S");
    static STRUCT_IF_C aUi_BFu1s_S lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_S");
    check_field_offset(lv, v3, 5, "aUi_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_S, aUi_BFu1s_S)
//============================================================================



static void Test_aUi_BFu1s_Uc()
{
  {
    init_simple_test("aUi_BFu1s_Uc");
    static STRUCT_IF_C aUi_BFu1s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aUi_BFu1s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_Uc");
    check_field_offset(lv, v3, 5, "aUi_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_Uc, aUi_BFu1s_Uc)
//============================================================================



static void Test_aUi_BFu1s_Ui()
{
  {
    init_simple_test("aUi_BFu1s_Ui");
    static STRUCT_IF_C aUi_BFu1s_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu1s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_Ui");
    check_field_offset(lv, v3, 5, "aUi_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_Ui, aUi_BFu1s_Ui)
//============================================================================



static void Test_aUi_BFu1s_Ul()
{
  {
    init_simple_test("aUi_BFu1s_Ul");
    static STRUCT_IF_C aUi_BFu1s_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aUi_BFu1s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_Ul");
    check_field_offset(lv, v3, 5, "aUi_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_Ul, aUi_BFu1s_Ul)
//============================================================================



static void Test_aUi_BFu1s_Us()
{
  {
    init_simple_test("aUi_BFu1s_Us");
    static STRUCT_IF_C aUi_BFu1s_Us lv;
    check2(sizeof(lv), 7, "sizeof(aUi_BFu1s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_Us");
    check_field_offset(lv, v3, 5, "aUi_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_Us, aUi_BFu1s_Us)
//============================================================================



static void Test_aUi_BFu1s_Vp()
{
  {
    init_simple_test("aUi_BFu1s_Vp");
    static STRUCT_IF_C aUi_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aUi_BFu1s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aUi_BFu1s_Vp");
    check_field_offset(lv, v3, 5, "aUi_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu1s_Vp, aUi_BFu1s_Vp)
//============================================================================



static void Test_aUi_BFu31i()
{
  {
    init_simple_test("aUi_BFu31i");
    static STRUCT_IF_C aUi_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i, aUi_BFu31i)
//============================================================================



static void Test_aUi_BFu31i_BFu15i()
{
  {
    init_simple_test("aUi_BFu31i_BFu15i");
    static STRUCT_IF_C aUi_BFu31i_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "aUi_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "aUi_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu15i, aUi_BFu31i_BFu15i)
//============================================================================



static void Test_aUi_BFu31i_BFu15ll()
{
  {
    init_simple_test("aUi_BFu31i_BFu15ll");
    static STRUCT_IF_C aUi_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "aUi_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "aUi_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu15ll, aUi_BFu31i_BFu15ll)
//============================================================================



static void Test_aUi_BFu31i_BFu15s()
{
  {
    init_simple_test("aUi_BFu31i_BFu15s");
    static STRUCT_IF_C aUi_BFu31i_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "aUi_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "aUi_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu15s, aUi_BFu31i_BFu15s)
//============================================================================



static void Test_aUi_BFu31i_BFu16i()
{
  {
    init_simple_test("aUi_BFu31i_BFu16i");
    static STRUCT_IF_C aUi_BFu31i_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "aUi_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "aUi_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu16i, aUi_BFu31i_BFu16i)
//============================================================================



static void Test_aUi_BFu31i_BFu16ll()
{
  {
    init_simple_test("aUi_BFu31i_BFu16ll");
    static STRUCT_IF_C aUi_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "aUi_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "aUi_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu16ll, aUi_BFu31i_BFu16ll)
//============================================================================



static void Test_aUi_BFu31i_BFu16s()
{
  {
    init_simple_test("aUi_BFu31i_BFu16s");
    static STRUCT_IF_C aUi_BFu31i_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "aUi_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "aUi_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu16s, aUi_BFu31i_BFu16s)
//============================================================================



static void Test_aUi_BFu31i_BFu17i()
{
  {
    init_simple_test("aUi_BFu31i_BFu17i");
    static STRUCT_IF_C aUi_BFu31i_BFu17i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 7, 7, 17, 1, "aUi_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 7, 7, 17, hide_ull(1LL<<16), "aUi_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu17i, aUi_BFu31i_BFu17i)
//============================================================================



static void Test_aUi_BFu31i_BFu17ll()
{
  {
    init_simple_test("aUi_BFu31i_BFu17ll");
    static STRUCT_IF_C aUi_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 7, 7, 17, 1, "aUi_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 7, 7, 17, hide_ull(1LL<<16), "aUi_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu17ll, aUi_BFu31i_BFu17ll)
//============================================================================



static void Test_aUi_BFu31i_BFu1c()
{
  {
    init_simple_test("aUi_BFu31i_BFu1c");
    static STRUCT_IF_C aUi_BFu31i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aUi_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu1c, aUi_BFu31i_BFu1c)
//============================================================================



static void Test_aUi_BFu31i_BFu1i()
{
  {
    init_simple_test("aUi_BFu31i_BFu1i");
    static STRUCT_IF_C aUi_BFu31i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aUi_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu1i, aUi_BFu31i_BFu1i)
//============================================================================



static void Test_aUi_BFu31i_BFu1ll()
{
  {
    init_simple_test("aUi_BFu31i_BFu1ll");
    static STRUCT_IF_C aUi_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aUi_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu1ll, aUi_BFu31i_BFu1ll)
//============================================================================



static void Test_aUi_BFu31i_BFu1s()
{
  {
    init_simple_test("aUi_BFu31i_BFu1s");
    static STRUCT_IF_C aUi_BFu31i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aUi_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu1s, aUi_BFu31i_BFu1s)
//============================================================================



static void Test_aUi_BFu31i_BFu31i()
{
  {
    init_simple_test("aUi_BFu31i_BFu31i");
    static STRUCT_IF_C aUi_BFu31i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 7, 7, 31, 1, "aUi_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 7, 7, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu31i, aUi_BFu31i_BFu31i)
//============================================================================



static void Test_aUi_BFu31i_BFu31ll()
{
  {
    init_simple_test("aUi_BFu31i_BFu31ll");
    static STRUCT_IF_C aUi_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 7, 7, 31, 1, "aUi_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 7, 7, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu31ll, aUi_BFu31i_BFu31ll)
//============================================================================



static void Test_aUi_BFu31i_BFu32i()
{
  {
    init_simple_test("aUi_BFu31i_BFu32i");
    static STRUCT_IF_C aUi_BFu31i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 7, 7, 32, 1, "aUi_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 7, 7, 32, hide_ull(1LL<<31), "aUi_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu32i, aUi_BFu31i_BFu32i)
//============================================================================



static void Test_aUi_BFu31i_BFu32ll()
{
  {
    init_simple_test("aUi_BFu31i_BFu32ll");
    static STRUCT_IF_C aUi_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 7, 7, 32, 1, "aUi_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 7, 7, 32, hide_ull(1LL<<31), "aUi_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu32ll, aUi_BFu31i_BFu32ll)
//============================================================================



static void Test_aUi_BFu31i_BFu33()
{
  {
    init_simple_test("aUi_BFu31i_BFu33");
    static STRUCT_IF_C aUi_BFu31i_BFu33 lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 7, 7, 33, 1, "aUi_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 7, 7, 33, hide_ull(1LL<<32), "aUi_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu33, aUi_BFu31i_BFu33)
//============================================================================



static void Test_aUi_BFu31i_BFu7c()
{
  {
    init_simple_test("aUi_BFu31i_BFu7c");
    static STRUCT_IF_C aUi_BFu31i_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aUi_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aUi_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu7c, aUi_BFu31i_BFu7c)
//============================================================================



static void Test_aUi_BFu31i_BFu7i()
{
  {
    init_simple_test("aUi_BFu31i_BFu7i");
    static STRUCT_IF_C aUi_BFu31i_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aUi_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aUi_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu7i, aUi_BFu31i_BFu7i)
//============================================================================



static void Test_aUi_BFu31i_BFu7ll()
{
  {
    init_simple_test("aUi_BFu31i_BFu7ll");
    static STRUCT_IF_C aUi_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aUi_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aUi_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu7ll, aUi_BFu31i_BFu7ll)
//============================================================================



static void Test_aUi_BFu31i_BFu7s()
{
  {
    init_simple_test("aUi_BFu31i_BFu7s");
    static STRUCT_IF_C aUi_BFu31i_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aUi_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aUi_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu7s, aUi_BFu31i_BFu7s)
//============================================================================



static void Test_aUi_BFu31i_BFu8c()
{
  {
    init_simple_test("aUi_BFu31i_BFu8c");
    static STRUCT_IF_C aUi_BFu31i_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aUi_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aUi_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu8c, aUi_BFu31i_BFu8c)
//============================================================================



static void Test_aUi_BFu31i_BFu8i()
{
  {
    init_simple_test("aUi_BFu31i_BFu8i");
    static STRUCT_IF_C aUi_BFu31i_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aUi_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aUi_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu8i, aUi_BFu31i_BFu8i)
//============================================================================



static void Test_aUi_BFu31i_BFu8ll()
{
  {
    init_simple_test("aUi_BFu31i_BFu8ll");
    static STRUCT_IF_C aUi_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aUi_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aUi_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu8ll, aUi_BFu31i_BFu8ll)
//============================================================================



static void Test_aUi_BFu31i_BFu8s()
{
  {
    init_simple_test("aUi_BFu31i_BFu8s");
    static STRUCT_IF_C aUi_BFu31i_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aUi_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aUi_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu8s, aUi_BFu31i_BFu8s)
//============================================================================



static void Test_aUi_BFu31i_BFu9i()
{
  {
    init_simple_test("aUi_BFu31i_BFu9i");
    static STRUCT_IF_C aUi_BFu31i_BFu9i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "aUi_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "aUi_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu9i, aUi_BFu31i_BFu9i)
//============================================================================



static void Test_aUi_BFu31i_BFu9ll()
{
  {
    init_simple_test("aUi_BFu31i_BFu9ll");
    static STRUCT_IF_C aUi_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "aUi_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "aUi_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu9ll, aUi_BFu31i_BFu9ll)
//============================================================================



static void Test_aUi_BFu31i_BFu9s()
{
  {
    init_simple_test("aUi_BFu31i_BFu9s");
    static STRUCT_IF_C aUi_BFu31i_BFu9s lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "aUi_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "aUi_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_BFu9s, aUi_BFu31i_BFu9s)
//============================================================================



static void Test_aUi_BFu31i_C()
{
  {
    init_simple_test("aUi_BFu31i_C");
    static STRUCT_IF_C aUi_BFu31i_C lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_C");
    check_field_offset(lv, v3, 8, "aUi_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_C, aUi_BFu31i_C)
//============================================================================



static void Test_aUi_BFu31i_D()
{
  {
    init_simple_test("aUi_BFu31i_D");
    static STRUCT_IF_C aUi_BFu31i_D lv;
    check2(sizeof(lv), 16, "sizeof(aUi_BFu31i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_D");
    check_field_offset(lv, v3, 8, "aUi_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_D, aUi_BFu31i_D)
//============================================================================



static void Test_aUi_BFu31i_F()
{
  {
    init_simple_test("aUi_BFu31i_F");
    static STRUCT_IF_C aUi_BFu31i_F lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_F");
    check_field_offset(lv, v3, 8, "aUi_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_F, aUi_BFu31i_F)
//============================================================================



static void Test_aUi_BFu31i_I()
{
  {
    init_simple_test("aUi_BFu31i_I");
    static STRUCT_IF_C aUi_BFu31i_I lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_I");
    check_field_offset(lv, v3, 8, "aUi_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_I, aUi_BFu31i_I)
//============================================================================



static void Test_aUi_BFu31i_Ip()
{
  {
    init_simple_test("aUi_BFu31i_Ip");
    static STRUCT_IF_C aUi_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUi_BFu31i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_Ip");
    check_field_offset(lv, v3, 8, "aUi_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_Ip, aUi_BFu31i_Ip)
//============================================================================



static void Test_aUi_BFu31i_L()
{
  {
    init_simple_test("aUi_BFu31i_L");
    static STRUCT_IF_C aUi_BFu31i_L lv;
    check2(sizeof(lv), 16, "sizeof(aUi_BFu31i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_L");
    check_field_offset(lv, v3, 8, "aUi_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_L, aUi_BFu31i_L)
//============================================================================



static void Test_aUi_BFu31i_S()
{
  {
    init_simple_test("aUi_BFu31i_S");
    static STRUCT_IF_C aUi_BFu31i_S lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_S");
    check_field_offset(lv, v3, 8, "aUi_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_S, aUi_BFu31i_S)
//============================================================================



static void Test_aUi_BFu31i_Uc()
{
  {
    init_simple_test("aUi_BFu31i_Uc");
    static STRUCT_IF_C aUi_BFu31i_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_Uc");
    check_field_offset(lv, v3, 8, "aUi_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_Uc, aUi_BFu31i_Uc)
//============================================================================



static void Test_aUi_BFu31i_Ui()
{
  {
    init_simple_test("aUi_BFu31i_Ui");
    static STRUCT_IF_C aUi_BFu31i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_Ui");
    check_field_offset(lv, v3, 8, "aUi_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_Ui, aUi_BFu31i_Ui)
//============================================================================



static void Test_aUi_BFu31i_Ul()
{
  {
    init_simple_test("aUi_BFu31i_Ul");
    static STRUCT_IF_C aUi_BFu31i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aUi_BFu31i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_Ul");
    check_field_offset(lv, v3, 8, "aUi_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_Ul, aUi_BFu31i_Ul)
//============================================================================



static void Test_aUi_BFu31i_Us()
{
  {
    init_simple_test("aUi_BFu31i_Us");
    static STRUCT_IF_C aUi_BFu31i_Us lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_Us");
    check_field_offset(lv, v3, 8, "aUi_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_Us, aUi_BFu31i_Us)
//============================================================================



static void Test_aUi_BFu31i_Vp()
{
  {
    init_simple_test("aUi_BFu31i_Vp");
    static STRUCT_IF_C aUi_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUi_BFu31i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31i_Vp");
    check_field_offset(lv, v3, 8, "aUi_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31i_Vp, aUi_BFu31i_Vp)
//============================================================================



static void Test_aUi_BFu31ll()
{
  {
    init_simple_test("aUi_BFu31ll");
    static STRUCT_IF_C aUi_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll, aUi_BFu31ll)
//============================================================================



static void Test_aUi_BFu31ll_BFu15i()
{
  {
    init_simple_test("aUi_BFu31ll_BFu15i");
    static STRUCT_IF_C aUi_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "aUi_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "aUi_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu15i, aUi_BFu31ll_BFu15i)
//============================================================================



static void Test_aUi_BFu31ll_BFu15ll()
{
  {
    init_simple_test("aUi_BFu31ll_BFu15ll");
    static STRUCT_IF_C aUi_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "aUi_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "aUi_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu15ll, aUi_BFu31ll_BFu15ll)
//============================================================================



static void Test_aUi_BFu31ll_BFu15s()
{
  {
    init_simple_test("aUi_BFu31ll_BFu15s");
    static STRUCT_IF_C aUi_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "aUi_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "aUi_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu15s, aUi_BFu31ll_BFu15s)
//============================================================================



static void Test_aUi_BFu31ll_BFu16i()
{
  {
    init_simple_test("aUi_BFu31ll_BFu16i");
    static STRUCT_IF_C aUi_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "aUi_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "aUi_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu16i, aUi_BFu31ll_BFu16i)
//============================================================================



static void Test_aUi_BFu31ll_BFu16ll()
{
  {
    init_simple_test("aUi_BFu31ll_BFu16ll");
    static STRUCT_IF_C aUi_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "aUi_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "aUi_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu16ll, aUi_BFu31ll_BFu16ll)
//============================================================================



static void Test_aUi_BFu31ll_BFu16s()
{
  {
    init_simple_test("aUi_BFu31ll_BFu16s");
    static STRUCT_IF_C aUi_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "aUi_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "aUi_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu16s, aUi_BFu31ll_BFu16s)
//============================================================================



static void Test_aUi_BFu31ll_BFu17i()
{
  {
    init_simple_test("aUi_BFu31ll_BFu17i");
    static STRUCT_IF_C aUi_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 7, 7, 17, 1, "aUi_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 7, 7, 17, hide_ull(1LL<<16), "aUi_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu17i, aUi_BFu31ll_BFu17i)
//============================================================================



static void Test_aUi_BFu31ll_BFu17ll()
{
  {
    init_simple_test("aUi_BFu31ll_BFu17ll");
    static STRUCT_IF_C aUi_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 7, 7, 17, 1, "aUi_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 7, 7, 17, hide_ull(1LL<<16), "aUi_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu17ll, aUi_BFu31ll_BFu17ll)
//============================================================================



static void Test_aUi_BFu31ll_BFu1c()
{
  {
    init_simple_test("aUi_BFu31ll_BFu1c");
    static STRUCT_IF_C aUi_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aUi_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu1c, aUi_BFu31ll_BFu1c)
//============================================================================



static void Test_aUi_BFu31ll_BFu1i()
{
  {
    init_simple_test("aUi_BFu31ll_BFu1i");
    static STRUCT_IF_C aUi_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aUi_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu1i, aUi_BFu31ll_BFu1i)
//============================================================================



static void Test_aUi_BFu31ll_BFu1ll()
{
  {
    init_simple_test("aUi_BFu31ll_BFu1ll");
    static STRUCT_IF_C aUi_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aUi_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu1ll, aUi_BFu31ll_BFu1ll)
//============================================================================



static void Test_aUi_BFu31ll_BFu1s()
{
  {
    init_simple_test("aUi_BFu31ll_BFu1s");
    static STRUCT_IF_C aUi_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu31ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aUi_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu1s, aUi_BFu31ll_BFu1s)
//============================================================================



static void Test_aUi_BFu31ll_BFu31i()
{
  {
    init_simple_test("aUi_BFu31ll_BFu31i");
    static STRUCT_IF_C aUi_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 7, 7, 31, 1, "aUi_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 7, 7, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu31i, aUi_BFu31ll_BFu31i)
//============================================================================



static void Test_aUi_BFu31ll_BFu31ll()
{
  {
    init_simple_test("aUi_BFu31ll_BFu31ll");
    static STRUCT_IF_C aUi_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 7, 7, 31, 1, "aUi_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 7, 7, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu31ll, aUi_BFu31ll_BFu31ll)
//============================================================================



static void Test_aUi_BFu31ll_BFu32i()
{
  {
    init_simple_test("aUi_BFu31ll_BFu32i");
    static STRUCT_IF_C aUi_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 7, 7, 32, 1, "aUi_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 7, 7, 32, hide_ull(1LL<<31), "aUi_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu32i, aUi_BFu31ll_BFu32i)
//============================================================================



static void Test_aUi_BFu31ll_BFu32ll()
{
  {
    init_simple_test("aUi_BFu31ll_BFu32ll");
    static STRUCT_IF_C aUi_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 7, 7, 32, 1, "aUi_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 7, 7, 32, hide_ull(1LL<<31), "aUi_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu32ll, aUi_BFu31ll_BFu32ll)
//============================================================================



static void Test_aUi_BFu31ll_BFu33()
{
  {
    init_simple_test("aUi_BFu31ll_BFu33");
    static STRUCT_IF_C aUi_BFu31ll_BFu33 lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 7, 7, 33, 1, "aUi_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 7, 7, 33, hide_ull(1LL<<32), "aUi_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu33, aUi_BFu31ll_BFu33)
//============================================================================



static void Test_aUi_BFu31ll_BFu7c()
{
  {
    init_simple_test("aUi_BFu31ll_BFu7c");
    static STRUCT_IF_C aUi_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aUi_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aUi_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu7c, aUi_BFu31ll_BFu7c)
//============================================================================



static void Test_aUi_BFu31ll_BFu7i()
{
  {
    init_simple_test("aUi_BFu31ll_BFu7i");
    static STRUCT_IF_C aUi_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aUi_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aUi_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu7i, aUi_BFu31ll_BFu7i)
//============================================================================



static void Test_aUi_BFu31ll_BFu7ll()
{
  {
    init_simple_test("aUi_BFu31ll_BFu7ll");
    static STRUCT_IF_C aUi_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aUi_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aUi_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu7ll, aUi_BFu31ll_BFu7ll)
//============================================================================



static void Test_aUi_BFu31ll_BFu7s()
{
  {
    init_simple_test("aUi_BFu31ll_BFu7s");
    static STRUCT_IF_C aUi_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aUi_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aUi_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu7s, aUi_BFu31ll_BFu7s)
//============================================================================



static void Test_aUi_BFu31ll_BFu8c()
{
  {
    init_simple_test("aUi_BFu31ll_BFu8c");
    static STRUCT_IF_C aUi_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aUi_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aUi_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu8c, aUi_BFu31ll_BFu8c)
//============================================================================



static void Test_aUi_BFu31ll_BFu8i()
{
  {
    init_simple_test("aUi_BFu31ll_BFu8i");
    static STRUCT_IF_C aUi_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aUi_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aUi_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu8i, aUi_BFu31ll_BFu8i)
//============================================================================



static void Test_aUi_BFu31ll_BFu8ll()
{
  {
    init_simple_test("aUi_BFu31ll_BFu8ll");
    static STRUCT_IF_C aUi_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aUi_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aUi_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu8ll, aUi_BFu31ll_BFu8ll)
//============================================================================



static void Test_aUi_BFu31ll_BFu8s()
{
  {
    init_simple_test("aUi_BFu31ll_BFu8s");
    static STRUCT_IF_C aUi_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aUi_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aUi_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu8s, aUi_BFu31ll_BFu8s)
//============================================================================



static void Test_aUi_BFu31ll_BFu9i()
{
  {
    init_simple_test("aUi_BFu31ll_BFu9i");
    static STRUCT_IF_C aUi_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "aUi_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "aUi_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu9i, aUi_BFu31ll_BFu9i)
//============================================================================



static void Test_aUi_BFu31ll_BFu9ll()
{
  {
    init_simple_test("aUi_BFu31ll_BFu9ll");
    static STRUCT_IF_C aUi_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "aUi_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "aUi_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu9ll, aUi_BFu31ll_BFu9ll)
//============================================================================



static void Test_aUi_BFu31ll_BFu9s()
{
  {
    init_simple_test("aUi_BFu31ll_BFu9s");
    static STRUCT_IF_C aUi_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "aUi_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "aUi_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_BFu9s, aUi_BFu31ll_BFu9s)
//============================================================================



static void Test_aUi_BFu31ll_C()
{
  {
    init_simple_test("aUi_BFu31ll_C");
    static STRUCT_IF_C aUi_BFu31ll_C lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_C");
    check_field_offset(lv, v3, 8, "aUi_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_C, aUi_BFu31ll_C)
//============================================================================



static void Test_aUi_BFu31ll_D()
{
  {
    init_simple_test("aUi_BFu31ll_D");
    static STRUCT_IF_C aUi_BFu31ll_D lv;
    check2(sizeof(lv), 16, "sizeof(aUi_BFu31ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_D");
    check_field_offset(lv, v3, 8, "aUi_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_D, aUi_BFu31ll_D)
//============================================================================



static void Test_aUi_BFu31ll_F()
{
  {
    init_simple_test("aUi_BFu31ll_F");
    static STRUCT_IF_C aUi_BFu31ll_F lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_F");
    check_field_offset(lv, v3, 8, "aUi_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_F, aUi_BFu31ll_F)
//============================================================================



static void Test_aUi_BFu31ll_I()
{
  {
    init_simple_test("aUi_BFu31ll_I");
    static STRUCT_IF_C aUi_BFu31ll_I lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_I");
    check_field_offset(lv, v3, 8, "aUi_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_I, aUi_BFu31ll_I)
//============================================================================



static void Test_aUi_BFu31ll_Ip()
{
  {
    init_simple_test("aUi_BFu31ll_Ip");
    static STRUCT_IF_C aUi_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUi_BFu31ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_Ip");
    check_field_offset(lv, v3, 8, "aUi_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_Ip, aUi_BFu31ll_Ip)
//============================================================================



static void Test_aUi_BFu31ll_L()
{
  {
    init_simple_test("aUi_BFu31ll_L");
    static STRUCT_IF_C aUi_BFu31ll_L lv;
    check2(sizeof(lv), 16, "sizeof(aUi_BFu31ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_L");
    check_field_offset(lv, v3, 8, "aUi_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_L, aUi_BFu31ll_L)
//============================================================================



static void Test_aUi_BFu31ll_S()
{
  {
    init_simple_test("aUi_BFu31ll_S");
    static STRUCT_IF_C aUi_BFu31ll_S lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_S");
    check_field_offset(lv, v3, 8, "aUi_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_S, aUi_BFu31ll_S)
//============================================================================



static void Test_aUi_BFu31ll_Uc()
{
  {
    init_simple_test("aUi_BFu31ll_Uc");
    static STRUCT_IF_C aUi_BFu31ll_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu31ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_Uc");
    check_field_offset(lv, v3, 8, "aUi_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_Uc, aUi_BFu31ll_Uc)
//============================================================================



static void Test_aUi_BFu31ll_Ui()
{
  {
    init_simple_test("aUi_BFu31ll_Ui");
    static STRUCT_IF_C aUi_BFu31ll_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu31ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_Ui");
    check_field_offset(lv, v3, 8, "aUi_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_Ui, aUi_BFu31ll_Ui)
//============================================================================



static void Test_aUi_BFu31ll_Ul()
{
  {
    init_simple_test("aUi_BFu31ll_Ul");
    static STRUCT_IF_C aUi_BFu31ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aUi_BFu31ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_Ul");
    check_field_offset(lv, v3, 8, "aUi_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_Ul, aUi_BFu31ll_Ul)
//============================================================================



static void Test_aUi_BFu31ll_Us()
{
  {
    init_simple_test("aUi_BFu31ll_Us");
    static STRUCT_IF_C aUi_BFu31ll_Us lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu31ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_Us");
    check_field_offset(lv, v3, 8, "aUi_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_Us, aUi_BFu31ll_Us)
//============================================================================



static void Test_aUi_BFu31ll_Vp()
{
  {
    init_simple_test("aUi_BFu31ll_Vp");
    static STRUCT_IF_C aUi_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUi_BFu31ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aUi_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aUi_BFu31ll_Vp");
    check_field_offset(lv, v3, 8, "aUi_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu31ll_Vp, aUi_BFu31ll_Vp)
//============================================================================



static void Test_aUi_BFu32i()
{
  {
    init_simple_test("aUi_BFu32i");
    static STRUCT_IF_C aUi_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i, aUi_BFu32i)
//============================================================================



static void Test_aUi_BFu32i_BFu15i()
{
  {
    init_simple_test("aUi_BFu32i_BFu15i");
    static STRUCT_IF_C aUi_BFu32i_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aUi_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aUi_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu15i, aUi_BFu32i_BFu15i)
//============================================================================



static void Test_aUi_BFu32i_BFu15ll()
{
  {
    init_simple_test("aUi_BFu32i_BFu15ll");
    static STRUCT_IF_C aUi_BFu32i_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aUi_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aUi_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu15ll, aUi_BFu32i_BFu15ll)
//============================================================================



static void Test_aUi_BFu32i_BFu15s()
{
  {
    init_simple_test("aUi_BFu32i_BFu15s");
    static STRUCT_IF_C aUi_BFu32i_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aUi_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aUi_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu15s, aUi_BFu32i_BFu15s)
//============================================================================



static void Test_aUi_BFu32i_BFu16i()
{
  {
    init_simple_test("aUi_BFu32i_BFu16i");
    static STRUCT_IF_C aUi_BFu32i_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aUi_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aUi_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu16i, aUi_BFu32i_BFu16i)
//============================================================================



static void Test_aUi_BFu32i_BFu16ll()
{
  {
    init_simple_test("aUi_BFu32i_BFu16ll");
    static STRUCT_IF_C aUi_BFu32i_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aUi_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aUi_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu16ll, aUi_BFu32i_BFu16ll)
//============================================================================



static void Test_aUi_BFu32i_BFu16s()
{
  {
    init_simple_test("aUi_BFu32i_BFu16s");
    static STRUCT_IF_C aUi_BFu32i_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aUi_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aUi_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu16s, aUi_BFu32i_BFu16s)
//============================================================================



static void Test_aUi_BFu32i_BFu17i()
{
  {
    init_simple_test("aUi_BFu32i_BFu17i");
    static STRUCT_IF_C aUi_BFu32i_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu32i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aUi_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aUi_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu17i, aUi_BFu32i_BFu17i)
//============================================================================



static void Test_aUi_BFu32i_BFu17ll()
{
  {
    init_simple_test("aUi_BFu32i_BFu17ll");
    static STRUCT_IF_C aUi_BFu32i_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu32i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aUi_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aUi_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu17ll, aUi_BFu32i_BFu17ll)
//============================================================================



static void Test_aUi_BFu32i_BFu1c()
{
  {
    init_simple_test("aUi_BFu32i_BFu1c");
    static STRUCT_IF_C aUi_BFu32i_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aUi_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu1c, aUi_BFu32i_BFu1c)
//============================================================================



static void Test_aUi_BFu32i_BFu1i()
{
  {
    init_simple_test("aUi_BFu32i_BFu1i");
    static STRUCT_IF_C aUi_BFu32i_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aUi_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu1i, aUi_BFu32i_BFu1i)
//============================================================================



static void Test_aUi_BFu32i_BFu1ll()
{
  {
    init_simple_test("aUi_BFu32i_BFu1ll");
    static STRUCT_IF_C aUi_BFu32i_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aUi_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu1ll, aUi_BFu32i_BFu1ll)
//============================================================================



static void Test_aUi_BFu32i_BFu1s()
{
  {
    init_simple_test("aUi_BFu32i_BFu1s");
    static STRUCT_IF_C aUi_BFu32i_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aUi_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu1s, aUi_BFu32i_BFu1s)
//============================================================================



static void Test_aUi_BFu32i_BFu31i()
{
  {
    init_simple_test("aUi_BFu32i_BFu31i");
    static STRUCT_IF_C aUi_BFu32i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu32i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "aUi_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "aUi_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu31i, aUi_BFu32i_BFu31i)
//============================================================================



static void Test_aUi_BFu32i_BFu31ll()
{
  {
    init_simple_test("aUi_BFu32i_BFu31ll");
    static STRUCT_IF_C aUi_BFu32i_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu32i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "aUi_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "aUi_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu31ll, aUi_BFu32i_BFu31ll)
//============================================================================



static void Test_aUi_BFu32i_BFu32i()
{
  {
    init_simple_test("aUi_BFu32i_BFu32i");
    static STRUCT_IF_C aUi_BFu32i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu32i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "aUi_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu32i, aUi_BFu32i_BFu32i)
//============================================================================



static void Test_aUi_BFu32i_BFu32ll()
{
  {
    init_simple_test("aUi_BFu32i_BFu32ll");
    static STRUCT_IF_C aUi_BFu32i_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu32i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "aUi_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu32ll, aUi_BFu32i_BFu32ll)
//============================================================================



static void Test_aUi_BFu32i_BFu33()
{
  {
    init_simple_test("aUi_BFu32i_BFu33");
    static STRUCT_IF_C aUi_BFu32i_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(aUi_BFu32i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "aUi_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "aUi_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu33, aUi_BFu32i_BFu33)
//============================================================================



static void Test_aUi_BFu32i_BFu7c()
{
  {
    init_simple_test("aUi_BFu32i_BFu7c");
    static STRUCT_IF_C aUi_BFu32i_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aUi_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aUi_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu7c, aUi_BFu32i_BFu7c)
//============================================================================



static void Test_aUi_BFu32i_BFu7i()
{
  {
    init_simple_test("aUi_BFu32i_BFu7i");
    static STRUCT_IF_C aUi_BFu32i_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aUi_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aUi_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu7i, aUi_BFu32i_BFu7i)
//============================================================================



static void Test_aUi_BFu32i_BFu7ll()
{
  {
    init_simple_test("aUi_BFu32i_BFu7ll");
    static STRUCT_IF_C aUi_BFu32i_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aUi_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aUi_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu7ll, aUi_BFu32i_BFu7ll)
//============================================================================



static void Test_aUi_BFu32i_BFu7s()
{
  {
    init_simple_test("aUi_BFu32i_BFu7s");
    static STRUCT_IF_C aUi_BFu32i_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aUi_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aUi_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu7s, aUi_BFu32i_BFu7s)
//============================================================================



static void Test_aUi_BFu32i_BFu8c()
{
  {
    init_simple_test("aUi_BFu32i_BFu8c");
    static STRUCT_IF_C aUi_BFu32i_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aUi_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aUi_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu8c, aUi_BFu32i_BFu8c)
//============================================================================



static void Test_aUi_BFu32i_BFu8i()
{
  {
    init_simple_test("aUi_BFu32i_BFu8i");
    static STRUCT_IF_C aUi_BFu32i_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aUi_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aUi_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu8i, aUi_BFu32i_BFu8i)
//============================================================================



static void Test_aUi_BFu32i_BFu8ll()
{
  {
    init_simple_test("aUi_BFu32i_BFu8ll");
    static STRUCT_IF_C aUi_BFu32i_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aUi_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aUi_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu8ll, aUi_BFu32i_BFu8ll)
//============================================================================



static void Test_aUi_BFu32i_BFu8s()
{
  {
    init_simple_test("aUi_BFu32i_BFu8s");
    static STRUCT_IF_C aUi_BFu32i_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aUi_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aUi_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu8s, aUi_BFu32i_BFu8s)
//============================================================================



static void Test_aUi_BFu32i_BFu9i()
{
  {
    init_simple_test("aUi_BFu32i_BFu9i");
    static STRUCT_IF_C aUi_BFu32i_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aUi_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aUi_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu9i, aUi_BFu32i_BFu9i)
//============================================================================



static void Test_aUi_BFu32i_BFu9ll()
{
  {
    init_simple_test("aUi_BFu32i_BFu9ll");
    static STRUCT_IF_C aUi_BFu32i_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aUi_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aUi_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu9ll, aUi_BFu32i_BFu9ll)
//============================================================================



static void Test_aUi_BFu32i_BFu9s()
{
  {
    init_simple_test("aUi_BFu32i_BFu9s");
    static STRUCT_IF_C aUi_BFu32i_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aUi_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aUi_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_BFu9s, aUi_BFu32i_BFu9s)
//============================================================================



static void Test_aUi_BFu32i_C()
{
  {
    init_simple_test("aUi_BFu32i_C");
    static STRUCT_IF_C aUi_BFu32i_C lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_C)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_C");
    check_field_offset(lv, v3, 8, "aUi_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_C, aUi_BFu32i_C)
//============================================================================



static void Test_aUi_BFu32i_D()
{
  {
    init_simple_test("aUi_BFu32i_D");
    static STRUCT_IF_C aUi_BFu32i_D lv;
    check2(sizeof(lv), 16, "sizeof(aUi_BFu32i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_D)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_D");
    check_field_offset(lv, v3, 8, "aUi_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_D, aUi_BFu32i_D)
//============================================================================



static void Test_aUi_BFu32i_F()
{
  {
    init_simple_test("aUi_BFu32i_F");
    static STRUCT_IF_C aUi_BFu32i_F lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu32i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_F)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_F");
    check_field_offset(lv, v3, 8, "aUi_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_F, aUi_BFu32i_F)
//============================================================================



static void Test_aUi_BFu32i_I()
{
  {
    init_simple_test("aUi_BFu32i_I");
    static STRUCT_IF_C aUi_BFu32i_I lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu32i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_I)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_I");
    check_field_offset(lv, v3, 8, "aUi_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_I, aUi_BFu32i_I)
//============================================================================



static void Test_aUi_BFu32i_Ip()
{
  {
    init_simple_test("aUi_BFu32i_Ip");
    static STRUCT_IF_C aUi_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUi_BFu32i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_Ip");
    check_field_offset(lv, v3, 8, "aUi_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_Ip, aUi_BFu32i_Ip)
//============================================================================



static void Test_aUi_BFu32i_L()
{
  {
    init_simple_test("aUi_BFu32i_L");
    static STRUCT_IF_C aUi_BFu32i_L lv;
    check2(sizeof(lv), 16, "sizeof(aUi_BFu32i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_L)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_L");
    check_field_offset(lv, v3, 8, "aUi_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_L, aUi_BFu32i_L)
//============================================================================



static void Test_aUi_BFu32i_S()
{
  {
    init_simple_test("aUi_BFu32i_S");
    static STRUCT_IF_C aUi_BFu32i_S lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_S)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_S");
    check_field_offset(lv, v3, 8, "aUi_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_S, aUi_BFu32i_S)
//============================================================================



static void Test_aUi_BFu32i_Uc()
{
  {
    init_simple_test("aUi_BFu32i_Uc");
    static STRUCT_IF_C aUi_BFu32i_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_Uc");
    check_field_offset(lv, v3, 8, "aUi_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_Uc, aUi_BFu32i_Uc)
//============================================================================



static void Test_aUi_BFu32i_Ui()
{
  {
    init_simple_test("aUi_BFu32i_Ui");
    static STRUCT_IF_C aUi_BFu32i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu32i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_Ui");
    check_field_offset(lv, v3, 8, "aUi_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_Ui, aUi_BFu32i_Ui)
//============================================================================



static void Test_aUi_BFu32i_Ul()
{
  {
    init_simple_test("aUi_BFu32i_Ul");
    static STRUCT_IF_C aUi_BFu32i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aUi_BFu32i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_Ul");
    check_field_offset(lv, v3, 8, "aUi_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_Ul, aUi_BFu32i_Ul)
//============================================================================



static void Test_aUi_BFu32i_Us()
{
  {
    init_simple_test("aUi_BFu32i_Us");
    static STRUCT_IF_C aUi_BFu32i_Us lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_Us");
    check_field_offset(lv, v3, 8, "aUi_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_Us, aUi_BFu32i_Us)
//============================================================================



static void Test_aUi_BFu32i_Vp()
{
  {
    init_simple_test("aUi_BFu32i_Vp");
    static STRUCT_IF_C aUi_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aUi_BFu32i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "aUi_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32i_Vp");
    check_field_offset(lv, v3, 8, "aUi_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32i_Vp, aUi_BFu32i_Vp)
//============================================================================



static void Test_aUi_BFu32ll()
{
  {
    init_simple_test("aUi_BFu32ll");
    static STRUCT_IF_C aUi_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aUi_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32ll, aUi_BFu32ll)
//============================================================================



static void Test_aUi_BFu32ll_BFu15i()
{
  {
    init_simple_test("aUi_BFu32ll_BFu15i");
    static STRUCT_IF_C aUi_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aUi_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aUi_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32ll_BFu15i, aUi_BFu32ll_BFu15i)
//============================================================================



static void Test_aUi_BFu32ll_BFu15ll()
{
  {
    init_simple_test("aUi_BFu32ll_BFu15ll");
    static STRUCT_IF_C aUi_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aUi_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aUi_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32ll_BFu15ll, aUi_BFu32ll_BFu15ll)
//============================================================================



static void Test_aUi_BFu32ll_BFu15s()
{
  {
    init_simple_test("aUi_BFu32ll_BFu15s");
    static STRUCT_IF_C aUi_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aUi_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aUi_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32ll_BFu15s, aUi_BFu32ll_BFu15s)
//============================================================================



static void Test_aUi_BFu32ll_BFu16i()
{
  {
    init_simple_test("aUi_BFu32ll_BFu16i");
    static STRUCT_IF_C aUi_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aUi_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aUi_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32ll_BFu16i, aUi_BFu32ll_BFu16i)
//============================================================================



static void Test_aUi_BFu32ll_BFu16ll()
{
  {
    init_simple_test("aUi_BFu32ll_BFu16ll");
    static STRUCT_IF_C aUi_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aUi_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aUi_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32ll_BFu16ll, aUi_BFu32ll_BFu16ll)
//============================================================================



static void Test_aUi_BFu32ll_BFu16s()
{
  {
    init_simple_test("aUi_BFu32ll_BFu16s");
    static STRUCT_IF_C aUi_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aUi_BFu32ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aUi_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aUi_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32ll_BFu16s, aUi_BFu32ll_BFu16s)
//============================================================================



static void Test_aUi_BFu32ll_BFu17i()
{
  {
    init_simple_test("aUi_BFu32ll_BFu17i");
    static STRUCT_IF_C aUi_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu32ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aUi_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aUi_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32ll_BFu17i, aUi_BFu32ll_BFu17i)
//============================================================================



static void Test_aUi_BFu32ll_BFu17ll()
{
  {
    init_simple_test("aUi_BFu32ll_BFu17ll");
    static STRUCT_IF_C aUi_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(aUi_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aUi_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aUi_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32ll_BFu17ll, aUi_BFu32ll_BFu17ll)
//============================================================================



static void Test_aUi_BFu32ll_BFu1c()
{
  {
    init_simple_test("aUi_BFu32ll_BFu1c");
    static STRUCT_IF_C aUi_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aUi_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32ll_BFu1c, aUi_BFu32ll_BFu1c)
//============================================================================



static void Test_aUi_BFu32ll_BFu1i()
{
  {
    init_simple_test("aUi_BFu32ll_BFu1i");
    static STRUCT_IF_C aUi_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aUi_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32ll_BFu1i, aUi_BFu32ll_BFu1i)
//============================================================================



static void Test_aUi_BFu32ll_BFu1ll()
{
  {
    init_simple_test("aUi_BFu32ll_BFu1ll");
    static STRUCT_IF_C aUi_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aUi_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32ll_BFu1ll, aUi_BFu32ll_BFu1ll)
//============================================================================



static void Test_aUi_BFu32ll_BFu1s()
{
  {
    init_simple_test("aUi_BFu32ll_BFu1s");
    static STRUCT_IF_C aUi_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(aUi_BFu32ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aUi_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aUi_BFu32ll_BFu1s, aUi_BFu32ll_BFu1s)
//============================================================================



static void Test_aUi_BFu32ll_BFu31i()
{
  {
    init_simple_test("aUi_BFu32ll_BFu31i");
    static STRUCT_IF_C aUi_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aUi_BFu32ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aUi_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aUi_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aUi_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aUi_BFu32ll_BFu31i");
    set_bf_and