// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
struct __attribute__((packed)) aL_Ui_BFu16i { long long v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_Ui_BFu16ll { long long v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_Ui_BFu16s { long long v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_Ui_BFu17i { long long v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_Ui_BFu17ll { long long v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_Ui_BFu1c { long long v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_Ui_BFu1i { long long v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_Ui_BFu1ll { long long v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_Ui_BFu1s { long long v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_Ui_BFu31i { long long v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_Ui_BFu31ll { long long v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_Ui_BFu32i { long long v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_Ui_BFu32ll { long long v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_Ui_BFu33 { long long v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_Ui_BFu7c { long long v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_Ui_BFu7i { long long v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_Ui_BFu7ll { long long v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_Ui_BFu7s { long long v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_Ui_BFu8c { long long v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_Ui_BFu8i { long long v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_Ui_BFu8ll { long long v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_Ui_BFu8s { long long v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_Ui_BFu9i { long long v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_Ui_BFu9ll { long long v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_Ui_BFu9s { long long v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_Ui_C { long long v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aL_Ui_D { long long v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aL_Ui_F { long long v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aL_Ui_I { long long v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aL_Ui_Ip { long long v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aL_Ui_L { long long v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aL_Ui_S { long long v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aL_Ui_Uc { long long v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aL_Ui_Ui { long long v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aL_Ui_Ul { long long v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aL_Ui_Us { long long v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aL_Ui_Vp { long long v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aL_Ul { long long v1; unsigned long long v2; };
struct __attribute__((packed)) aL_Ul_BFu15i { long long v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_Ul_BFu15ll { long long v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_Ul_BFu15s { long long v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aL_Ul_BFu16i { long long v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_Ul_BFu16ll { long long v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_Ul_BFu16s { long long v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_Ul_BFu17i { long long v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_Ul_BFu17ll { long long v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_Ul_BFu1c { long long v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_Ul_BFu1i { long long v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_Ul_BFu1ll { long long v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_Ul_BFu1s { long long v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_Ul_BFu31i { long long v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_Ul_BFu31ll { long long v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_Ul_BFu32i { long long v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_Ul_BFu32ll { long long v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_Ul_BFu33 { long long v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_Ul_BFu7c { long long v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_Ul_BFu7i { long long v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_Ul_BFu7ll { long long v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_Ul_BFu7s { long long v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_Ul_BFu8c { long long v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_Ul_BFu8i { long long v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_Ul_BFu8ll { long long v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_Ul_BFu8s { long long v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_Ul_BFu9i { long long v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_Ul_BFu9ll { long long v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_Ul_BFu9s { long long v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_Ul_C { long long v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aL_Ul_D { long long v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aL_Ul_F { long long v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aL_Ul_I { long long v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aL_Ul_Ip { long long v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aL_Ul_L { long long v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aL_Ul_S { long long v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aL_Ul_Uc { long long v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aL_Ul_Ui { long long v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aL_Ul_Ul { long long v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aL_Ul_Us { long long v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aL_Ul_Vp { long long v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aL_Us { long long v1; unsigned short v2; };
struct __attribute__((packed)) aL_Us_BFu15i { long long v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_Us_BFu15ll { long long v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_Us_BFu15s { long long v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aL_Us_BFu16i { long long v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_Us_BFu16ll { long long v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_Us_BFu16s { long long v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_Us_BFu17i { long long v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_Us_BFu17ll { long long v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_Us_BFu1c { long long v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_Us_BFu1i { long long v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_Us_BFu1ll { long long v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_Us_BFu1s { long long v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_Us_BFu31i { long long v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_Us_BFu31ll { long long v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_Us_BFu32i { long long v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_Us_BFu32ll { long long v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_Us_BFu33 { long long v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_Us_BFu7c { long long v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_Us_BFu7i { long long v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_Us_BFu7ll { long long v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_Us_BFu7s { long long v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_Us_BFu8c { long long v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_Us_BFu8i { long long v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_Us_BFu8ll { long long v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_Us_BFu8s { long long v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_Us_BFu9i { long long v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_Us_BFu9ll { long long v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_Us_BFu9s { long long v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_Us_C { long long v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aL_Us_D { long long v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aL_Us_F { long long v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aL_Us_I { long long v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aL_Us_Ip { long long v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aL_Us_L { long long v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aL_Us_S { long long v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aL_Us_Uc { long long v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aL_Us_Ui { long long v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aL_Us_Ul { long long v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aL_Us_Us { long long v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aL_Us_Vp { long long v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aL_Vp { long long v1; void * v2; };
struct __attribute__((packed)) aL_Vp_BFu15i { long long v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_Vp_BFu15ll { long long v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_Vp_BFu15s { long long v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aL_Vp_BFu16i { long long v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_Vp_BFu16ll { long long v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_Vp_BFu16s { long long v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_Vp_BFu17i { long long v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_Vp_BFu17ll { long long v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_Vp_BFu1c { long long v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_Vp_BFu1i { long long v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_Vp_BFu1ll { long long v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_Vp_BFu1s { long long v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_Vp_BFu31i { long long v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_Vp_BFu31ll { long long v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_Vp_BFu32i { long long v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_Vp_BFu32ll { long long v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_Vp_BFu33 { long long v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_Vp_BFu7c { long long v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_Vp_BFu7i { long long v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_Vp_BFu7ll { long long v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_Vp_BFu7s { long long v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_Vp_BFu8c { long long v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_Vp_BFu8i { long long v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_Vp_BFu8ll { long long v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_Vp_BFu8s { long long v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_Vp_BFu9i { long long v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_Vp_BFu9ll { long long v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_Vp_BFu9s { long long v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_Vp_C { long long v1; void * v2; char v3; };
struct __attribute__((packed)) aL_Vp_D { long long v1; void * v2; double v3; };
struct __attribute__((packed)) aL_Vp_F { long long v1; void * v2; float v3; };
struct __attribute__((packed)) aL_Vp_I { long long v1; void * v2; int v3; };
struct __attribute__((packed)) aL_Vp_Ip { long long v1; void * v2; int * v3; };
struct __attribute__((packed)) aL_Vp_L { long long v1; void * v2; long long v3; };
struct __attribute__((packed)) aL_Vp_S { long long v1; void * v2; short v3; };
struct __attribute__((packed)) aL_Vp_Uc { long long v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aL_Vp_Ui { long long v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aL_Vp_Ul { long long v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aL_Vp_Us { long long v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aL_Vp_Vp { long long v1; void * v2; void * v3; };
struct __attribute__((packed)) aS { short v1; };
struct __attribute__((packed)) aS_BFu15i { short v1; unsigned int v2:15; };
struct __attribute__((packed)) aS_BFu15i_BFu15i { short v1; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu15i_BFu15ll { short v1; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu15i_BFu15s { short v1; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu15i_BFu16i { short v1; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu15i_BFu16ll { short v1; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu15i_BFu16s { short v1; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu15i_BFu17i { short v1; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu15i_BFu17ll { short v1; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu15i_BFu1c { short v1; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu15i_BFu1i { short v1; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu15i_BFu1ll { short v1; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu15i_BFu1s { short v1; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu15i_BFu31i { short v1; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu15i_BFu31ll { short v1; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu15i_BFu32i { short v1; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu15i_BFu32ll { short v1; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu15i_BFu33 { short v1; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu15i_BFu7c { short v1; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu15i_BFu7i { short v1; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu15i_BFu7ll { short v1; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu15i_BFu7s { short v1; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu15i_BFu8c { short v1; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu15i_BFu8i { short v1; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu15i_BFu8ll { short v1; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu15i_BFu8s { short v1; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu15i_BFu9i { short v1; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu15i_BFu9ll { short v1; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu15i_BFu9s { short v1; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu15i_C { short v1; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aS_BFu15i_D { short v1; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aS_BFu15i_F { short v1; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aS_BFu15i_I { short v1; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aS_BFu15i_Ip { short v1; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aS_BFu15i_L { short v1; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aS_BFu15i_S { short v1; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aS_BFu15i_Uc { short v1; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aS_BFu15i_Ui { short v1; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aS_BFu15i_Ul { short v1; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu15i_Us { short v1; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aS_BFu15i_Vp { short v1; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aS_BFu15ll { short v1; unsigned long long v2:15; };
struct __attribute__((packed)) aS_BFu15ll_BFu15i { short v1; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu15ll_BFu15ll { short v1; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu15ll_BFu15s { short v1; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu15ll_BFu16i { short v1; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu15ll_BFu16ll { short v1; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu15ll_BFu16s { short v1; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu15ll_BFu17i { short v1; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu15ll_BFu17ll { short v1; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu15ll_BFu1c { short v1; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu15ll_BFu1i { short v1; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu15ll_BFu1ll { short v1; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu15ll_BFu1s { short v1; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu15ll_BFu31i { short v1; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu15ll_BFu31ll { short v1; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu15ll_BFu32i { short v1; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu15ll_BFu32ll { short v1; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu15ll_BFu33 { short v1; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu15ll_BFu7c { short v1; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu15ll_BFu7i { short v1; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu15ll_BFu7ll { short v1; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu15ll_BFu7s { short v1; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu15ll_BFu8c { short v1; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu15ll_BFu8i { short v1; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu15ll_BFu8ll { short v1; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu15ll_BFu8s { short v1; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu15ll_BFu9i { short v1; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu15ll_BFu9ll { short v1; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu15ll_BFu9s { short v1; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu15ll_C { short v1; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aS_BFu15ll_D { short v1; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aS_BFu15ll_F { short v1; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aS_BFu15ll_I { short v1; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aS_BFu15ll_Ip { short v1; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aS_BFu15ll_L { short v1; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aS_BFu15ll_S { short v1; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aS_BFu15ll_Uc { short v1; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aS_BFu15ll_Ui { short v1; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aS_BFu15ll_Ul { short v1; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu15ll_Us { short v1; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aS_BFu15ll_Vp { short v1; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aS_BFu15s { short v1; unsigned short v2:15; };
struct __attribute__((packed)) aS_BFu15s_BFu15i { short v1; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu15s_BFu15ll { short v1; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu15s_BFu15s { short v1; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu15s_BFu16i { short v1; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu15s_BFu16ll { short v1; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu15s_BFu16s { short v1; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu15s_BFu17i { short v1; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu15s_BFu17ll { short v1; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu15s_BFu1c { short v1; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu15s_BFu1i { short v1; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu15s_BFu1ll { short v1; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu15s_BFu1s { short v1; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu15s_BFu31i { short v1; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu15s_BFu31ll { short v1; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu15s_BFu32i { short v1; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu15s_BFu32ll { short v1; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu15s_BFu33 { short v1; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu15s_BFu7c { short v1; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu15s_BFu7i { short v1; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu15s_BFu7ll { short v1; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu15s_BFu7s { short v1; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu15s_BFu8c { short v1; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu15s_BFu8i { short v1; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu15s_BFu8ll { short v1; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu15s_BFu8s { short v1; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu15s_BFu9i { short v1; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu15s_BFu9ll { short v1; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu15s_BFu9s { short v1; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu15s_C { short v1; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aS_BFu15s_D { short v1; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aS_BFu15s_F { short v1; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aS_BFu15s_I { short v1; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aS_BFu15s_Ip { short v1; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aS_BFu15s_L { short v1; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aS_BFu15s_S { short v1; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aS_BFu15s_Uc { short v1; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aS_BFu15s_Ui { short v1; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aS_BFu15s_Ul { short v1; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu15s_Us { short v1; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aS_BFu15s_Vp { short v1; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aS_BFu16i { short v1; unsigned int v2:16; };
struct __attribute__((packed)) aS_BFu16i_BFu15i { short v1; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu16i_BFu15ll { short v1; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu16i_BFu15s { short v1; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu16i_BFu16i { short v1; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu16i_BFu16ll { short v1; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu16i_BFu16s { short v1; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu16i_BFu17i { short v1; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu16i_BFu17ll { short v1; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu16i_BFu1c { short v1; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu16i_BFu1i { short v1; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu16i_BFu1ll { short v1; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu16i_BFu1s { short v1; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu16i_BFu31i { short v1; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu16i_BFu31ll { short v1; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu16i_BFu32i { short v1; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu16i_BFu32ll { short v1; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu16i_BFu33 { short v1; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu16i_BFu7c { short v1; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu16i_BFu7i { short v1; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu16i_BFu7ll { short v1; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu16i_BFu7s { short v1; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu16i_BFu8c { short v1; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu16i_BFu8i { short v1; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu16i_BFu8ll { short v1; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu16i_BFu8s { short v1; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu16i_BFu9i { short v1; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu16i_BFu9ll { short v1; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu16i_BFu9s { short v1; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu16i_C { short v1; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aS_BFu16i_D { short v1; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aS_BFu16i_F { short v1; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aS_BFu16i_I { short v1; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aS_BFu16i_Ip { short v1; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aS_BFu16i_L { short v1; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aS_BFu16i_S { short v1; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aS_BFu16i_Uc { short v1; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aS_BFu16i_Ui { short v1; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aS_BFu16i_Ul { short v1; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu16i_Us { short v1; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aS_BFu16i_Vp { short v1; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aS_BFu16ll { short v1; unsigned long long v2:16; };
struct __attribute__((packed)) aS_BFu16ll_BFu15i { short v1; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu16ll_BFu15ll { short v1; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu16ll_BFu15s { short v1; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu16ll_BFu16i { short v1; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu16ll_BFu16ll { short v1; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu16ll_BFu16s { short v1; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu16ll_BFu17i { short v1; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu16ll_BFu17ll { short v1; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu16ll_BFu1c { short v1; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu16ll_BFu1i { short v1; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu16ll_BFu1ll { short v1; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu16ll_BFu1s { short v1; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu16ll_BFu31i { short v1; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu16ll_BFu31ll { short v1; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu16ll_BFu32i { short v1; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu16ll_BFu32ll { short v1; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu16ll_BFu33 { short v1; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu16ll_BFu7c { short v1; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu16ll_BFu7i { short v1; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu16ll_BFu7ll { short v1; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu16ll_BFu7s { short v1; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu16ll_BFu8c { short v1; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu16ll_BFu8i { short v1; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu16ll_BFu8ll { short v1; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu16ll_BFu8s { short v1; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu16ll_BFu9i { short v1; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu16ll_BFu9ll { short v1; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu16ll_BFu9s { short v1; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu16ll_C { short v1; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aS_BFu16ll_D { short v1; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aS_BFu16ll_F { short v1; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aS_BFu16ll_I { short v1; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aS_BFu16ll_Ip { short v1; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aS_BFu16ll_L { short v1; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aS_BFu16ll_S { short v1; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aS_BFu16ll_Uc { short v1; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aS_BFu16ll_Ui { short v1; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aS_BFu16ll_Ul { short v1; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu16ll_Us { short v1; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aS_BFu16ll_Vp { short v1; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aS_BFu16s { short v1; unsigned short v2:16; };
struct __attribute__((packed)) aS_BFu16s_BFu15i { short v1; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu16s_BFu15ll { short v1; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu16s_BFu15s { short v1; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu16s_BFu16i { short v1; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu16s_BFu16ll { short v1; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu16s_BFu16s { short v1; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu16s_BFu17i { short v1; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu16s_BFu17ll { short v1; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu16s_BFu1c { short v1; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu16s_BFu1i { short v1; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu16s_BFu1ll { short v1; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu16s_BFu1s { short v1; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu16s_BFu31i { short v1; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu16s_BFu31ll { short v1; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu16s_BFu32i { short v1; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu16s_BFu32ll { short v1; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu16s_BFu33 { short v1; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu16s_BFu7c { short v1; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu16s_BFu7i { short v1; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu16s_BFu7ll { short v1; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu16s_BFu7s { short v1; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu16s_BFu8c { short v1; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu16s_BFu8i { short v1; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu16s_BFu8ll { short v1; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu16s_BFu8s { short v1; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu16s_BFu9i { short v1; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu16s_BFu9ll { short v1; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu16s_BFu9s { short v1; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu16s_C { short v1; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aS_BFu16s_D { short v1; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aS_BFu16s_F { short v1; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aS_BFu16s_I { short v1; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aS_BFu16s_Ip { short v1; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aS_BFu16s_L { short v1; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aS_BFu16s_S { short v1; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aS_BFu16s_Uc { short v1; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aS_BFu16s_Ui { short v1; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aS_BFu16s_Ul { short v1; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu16s_Us { short v1; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aS_BFu16s_Vp { short v1; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aS_BFu17i { short v1; unsigned int v2:17; };
struct __attribute__((packed)) aS_BFu17i_BFu15i { short v1; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu17i_BFu15ll { short v1; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu17i_BFu15s { short v1; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu17i_BFu16i { short v1; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu17i_BFu16ll { short v1; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu17i_BFu16s { short v1; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu17i_BFu17i { short v1; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu17i_BFu17ll { short v1; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu17i_BFu1c { short v1; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu17i_BFu1i { short v1; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu17i_BFu1ll { short v1; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu17i_BFu1s { short v1; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu17i_BFu31i { short v1; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu17i_BFu31ll { short v1; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu17i_BFu32i { short v1; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu17i_BFu32ll { short v1; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu17i_BFu33 { short v1; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu17i_BFu7c { short v1; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu17i_BFu7i { short v1; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu17i_BFu7ll { short v1; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu17i_BFu7s { short v1; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu17i_BFu8c { short v1; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu17i_BFu8i { short v1; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu17i_BFu8ll { short v1; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu17i_BFu8s { short v1; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu17i_BFu9i { short v1; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu17i_BFu9ll { short v1; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu17i_BFu9s { short v1; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu17i_C { short v1; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aS_BFu17i_D { short v1; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aS_BFu17i_F { short v1; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aS_BFu17i_I { short v1; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aS_BFu17i_Ip { short v1; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aS_BFu17i_L { short v1; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aS_BFu17i_S { short v1; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aS_BFu17i_Uc { short v1; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aS_BFu17i_Ui { short v1; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aS_BFu17i_Ul { short v1; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu17i_Us { short v1; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aS_BFu17i_Vp { short v1; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aS_BFu17ll { short v1; unsigned long long v2:17; };
struct __attribute__((packed)) aS_BFu17ll_BFu15i { short v1; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu17ll_BFu15ll { short v1; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu17ll_BFu15s { short v1; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu17ll_BFu16i { short v1; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu17ll_BFu16ll { short v1; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu17ll_BFu16s { short v1; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu17ll_BFu17i { short v1; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu17ll_BFu17ll { short v1; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu17ll_BFu1c { short v1; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu17ll_BFu1i { short v1; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu17ll_BFu1ll { short v1; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu17ll_BFu1s { short v1; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu17ll_BFu31i { short v1; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu17ll_BFu31ll { short v1; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu17ll_BFu32i { short v1; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu17ll_BFu32ll { short v1; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu17ll_BFu33 { short v1; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu17ll_BFu7c { short v1; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu17ll_BFu7i { short v1; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu17ll_BFu7ll { short v1; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu17ll_BFu7s { short v1; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu17ll_BFu8c { short v1; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu17ll_BFu8i { short v1; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu17ll_BFu8ll { short v1; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu17ll_BFu8s { short v1; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu17ll_BFu9i { short v1; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu17ll_BFu9ll { short v1; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu17ll_BFu9s { short v1; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu17ll_C { short v1; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aS_BFu17ll_D { short v1; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aS_BFu17ll_F { short v1; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aS_BFu17ll_I { short v1; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aS_BFu17ll_Ip { short v1; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aS_BFu17ll_L { short v1; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aS_BFu17ll_S { short v1; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aS_BFu17ll_Uc { short v1; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aS_BFu17ll_Ui { short v1; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aS_BFu17ll_Ul { short v1; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu17ll_Us { short v1; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aS_BFu17ll_Vp { short v1; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aS_BFu1c { short v1; unsigned char v2:1; };
struct __attribute__((packed)) aS_BFu1c_BFu15i { short v1; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu1c_BFu15ll { short v1; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu1c_BFu15s { short v1; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu1c_BFu16i { short v1; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu1c_BFu16ll { short v1; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu1c_BFu16s { short v1; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu1c_BFu17i { short v1; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu1c_BFu17ll { short v1; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu1c_BFu1c { short v1; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu1c_BFu1i { short v1; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu1c_BFu1ll { short v1; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu1c_BFu1s { short v1; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu1c_BFu31i { short v1; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu1c_BFu31ll { short v1; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu1c_BFu32i { short v1; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu1c_BFu32ll { short v1; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu1c_BFu33 { short v1; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu1c_BFu7c { short v1; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu1c_BFu7i { short v1; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu1c_BFu7ll { short v1; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu1c_BFu7s { short v1; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu1c_BFu8c { short v1; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu1c_BFu8i { short v1; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu1c_BFu8ll { short v1; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu1c_BFu8s { short v1; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu1c_BFu9i { short v1; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu1c_BFu9ll { short v1; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu1c_BFu9s { short v1; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu1c_C { short v1; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aS_BFu1c_D { short v1; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aS_BFu1c_F { short v1; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aS_BFu1c_I { short v1; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aS_BFu1c_Ip { short v1; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aS_BFu1c_L { short v1; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aS_BFu1c_S { short v1; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aS_BFu1c_Uc { short v1; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aS_BFu1c_Ui { short v1; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aS_BFu1c_Ul { short v1; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu1c_Us { short v1; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aS_BFu1c_Vp { short v1; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aS_BFu1i { short v1; unsigned int v2:1; };
struct __attribute__((packed)) aS_BFu1i_BFu15i { short v1; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu1i_BFu15ll { short v1; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu1i_BFu15s { short v1; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu1i_BFu16i { short v1; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu1i_BFu16ll { short v1; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu1i_BFu16s { short v1; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu1i_BFu17i { short v1; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu1i_BFu17ll { short v1; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu1i_BFu1c { short v1; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu1i_BFu1i { short v1; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu1i_BFu1ll { short v1; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu1i_BFu1s { short v1; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu1i_BFu31i { short v1; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu1i_BFu31ll { short v1; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu1i_BFu32i { short v1; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu1i_BFu32ll { short v1; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu1i_BFu33 { short v1; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu1i_BFu7c { short v1; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu1i_BFu7i { short v1; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu1i_BFu7ll { short v1; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu1i_BFu7s { short v1; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu1i_BFu8c { short v1; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu1i_BFu8i { short v1; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu1i_BFu8ll { short v1; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu1i_BFu8s { short v1; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu1i_BFu9i { short v1; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu1i_BFu9ll { short v1; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu1i_BFu9s { short v1; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu1i_C { short v1; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aS_BFu1i_D { short v1; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aS_BFu1i_F { short v1; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aS_BFu1i_I { short v1; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aS_BFu1i_Ip { short v1; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aS_BFu1i_L { short v1; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aS_BFu1i_S { short v1; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aS_BFu1i_Uc { short v1; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aS_BFu1i_Ui { short v1; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aS_BFu1i_Ul { short v1; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu1i_Us { short v1; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aS_BFu1i_Vp { short v1; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aS_BFu1ll { short v1; unsigned long long v2:1; };
struct __attribute__((packed)) aS_BFu1ll_BFu15i { short v1; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu1ll_BFu15ll { short v1; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu1ll_BFu15s { short v1; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu1ll_BFu16i { short v1; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu1ll_BFu16ll { short v1; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu1ll_BFu16s { short v1; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu1ll_BFu17i { short v1; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu1ll_BFu17ll { short v1; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu1ll_BFu1c { short v1; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu1ll_BFu1i { short v1; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu1ll_BFu1ll { short v1; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu1ll_BFu1s { short v1; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu1ll_BFu31i { short v1; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu1ll_BFu31ll { short v1; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu1ll_BFu32i { short v1; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu1ll_BFu32ll { short v1; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu1ll_BFu33 { short v1; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu1ll_BFu7c { short v1; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu1ll_BFu7i { short v1; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu1ll_BFu7ll { short v1; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu1ll_BFu7s { short v1; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu1ll_BFu8c { short v1; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu1ll_BFu8i { short v1; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu1ll_BFu8ll { short v1; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu1ll_BFu8s { short v1; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu1ll_BFu9i { short v1; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu1ll_BFu9ll { short v1; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu1ll_BFu9s { short v1; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu1ll_C { short v1; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aS_BFu1ll_D { short v1; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aS_BFu1ll_F { short v1; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aS_BFu1ll_I { short v1; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aS_BFu1ll_Ip { short v1; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aS_BFu1ll_L { short v1; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aS_BFu1ll_S { short v1; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aS_BFu1ll_Uc { short v1; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aS_BFu1ll_Ui { short v1; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aS_BFu1ll_Ul { short v1; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu1ll_Us { short v1; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aS_BFu1ll_Vp { short v1; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aS_BFu1s { short v1; unsigned short v2:1; };
struct __attribute__((packed)) aS_BFu1s_BFu15i { short v1; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu1s_BFu15ll { short v1; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu1s_BFu15s { short v1; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu1s_BFu16i { short v1; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu1s_BFu16ll { short v1; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu1s_BFu16s { short v1; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu1s_BFu17i { short v1; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu1s_BFu17ll { short v1; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu1s_BFu1c { short v1; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu1s_BFu1i { short v1; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu1s_BFu1ll { short v1; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu1s_BFu1s { short v1; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu1s_BFu31i { short v1; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu1s_BFu31ll { short v1; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu1s_BFu32i { short v1; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu1s_BFu32ll { short v1; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu1s_BFu33 { short v1; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu1s_BFu7c { short v1; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu1s_BFu7i { short v1; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu1s_BFu7ll { short v1; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu1s_BFu7s { short v1; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu1s_BFu8c { short v1; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu1s_BFu8i { short v1; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu1s_BFu8ll { short v1; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu1s_BFu8s { short v1; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu1s_BFu9i { short v1; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu1s_BFu9ll { short v1; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu1s_BFu9s { short v1; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu1s_C { short v1; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aS_BFu1s_D { short v1; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aS_BFu1s_F { short v1; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aS_BFu1s_I { short v1; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aS_BFu1s_Ip { short v1; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aS_BFu1s_L { short v1; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aS_BFu1s_S { short v1; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aS_BFu1s_Uc { short v1; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aS_BFu1s_Ui { short v1; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aS_BFu1s_Ul { short v1; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu1s_Us { short v1; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aS_BFu1s_Vp { short v1; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aS_BFu31i { short v1; unsigned int v2:31; };
struct __attribute__((packed)) aS_BFu31i_BFu15i { short v1; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu31i_BFu15ll { short v1; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu31i_BFu15s { short v1; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu31i_BFu16i { short v1; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu31i_BFu16ll { short v1; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu31i_BFu16s { short v1; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu31i_BFu17i { short v1; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu31i_BFu17ll { short v1; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu31i_BFu1c { short v1; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu31i_BFu1i { short v1; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu31i_BFu1ll { short v1; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu31i_BFu1s { short v1; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu31i_BFu31i { short v1; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu31i_BFu31ll { short v1; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu31i_BFu32i { short v1; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu31i_BFu32ll { short v1; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu31i_BFu33 { short v1; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu31i_BFu7c { short v1; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu31i_BFu7i { short v1; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu31i_BFu7ll { short v1; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu31i_BFu7s { short v1; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu31i_BFu8c { short v1; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu31i_BFu8i { short v1; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu31i_BFu8ll { short v1; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu31i_BFu8s { short v1; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu31i_BFu9i { short v1; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu31i_BFu9ll { short v1; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu31i_BFu9s { short v1; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu31i_C { short v1; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aS_BFu31i_D { short v1; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aS_BFu31i_F { short v1; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aS_BFu31i_I { short v1; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aS_BFu31i_Ip { short v1; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aS_BFu31i_L { short v1; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aS_BFu31i_S { short v1; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aS_BFu31i_Uc { short v1; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aS_BFu31i_Ui { short v1; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aS_BFu31i_Ul { short v1; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu31i_Us { short v1; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aS_BFu31i_Vp { short v1; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aS_BFu31ll { short v1; unsigned long long v2:31; };
struct __attribute__((packed)) aS_BFu31ll_BFu15i { short v1; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu31ll_BFu15ll { short v1; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu31ll_BFu15s { short v1; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu31ll_BFu16i { short v1; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu31ll_BFu16ll { short v1; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu31ll_BFu16s { short v1; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu31ll_BFu17i { short v1; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu31ll_BFu17ll { short v1; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu31ll_BFu1c { short v1; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu31ll_BFu1i { short v1; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu31ll_BFu1ll { short v1; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu31ll_BFu1s { short v1; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu31ll_BFu31i { short v1; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu31ll_BFu31ll { short v1; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu31ll_BFu32i { short v1; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu31ll_BFu32ll { short v1; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu31ll_BFu33 { short v1; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu31ll_BFu7c { short v1; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu31ll_BFu7i { short v1; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu31ll_BFu7ll { short v1; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu31ll_BFu7s { short v1; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu31ll_BFu8c { short v1; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu31ll_BFu8i { short v1; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu31ll_BFu8ll { short v1; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu31ll_BFu8s { short v1; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu31ll_BFu9i { short v1; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu31ll_BFu9ll { short v1; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu31ll_BFu9s { short v1; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu31ll_C { short v1; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aS_BFu31ll_D { short v1; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aS_BFu31ll_F { short v1; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aS_BFu31ll_I { short v1; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aS_BFu31ll_Ip { short v1; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aS_BFu31ll_L { short v1; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aS_BFu31ll_S { short v1; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aS_BFu31ll_Uc { short v1; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aS_BFu31ll_Ui { short v1; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aS_BFu31ll_Ul { short v1; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu31ll_Us { short v1; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aS_BFu31ll_Vp { short v1; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aS_BFu32i { short v1; unsigned int v2:32; };
struct __attribute__((packed)) aS_BFu32i_BFu15i { short v1; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu32i_BFu15ll { short v1; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu32i_BFu15s { short v1; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu32i_BFu16i { short v1; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu32i_BFu16ll { short v1; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu32i_BFu16s { short v1; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu32i_BFu17i { short v1; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu32i_BFu17ll { short v1; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu32i_BFu1c { short v1; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu32i_BFu1i { short v1; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu32i_BFu1ll { short v1; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu32i_BFu1s { short v1; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu32i_BFu31i { short v1; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu32i_BFu31ll { short v1; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu32i_BFu32i { short v1; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu32i_BFu32ll { short v1; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu32i_BFu33 { short v1; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu32i_BFu7c { short v1; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu32i_BFu7i { short v1; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu32i_BFu7ll { short v1; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu32i_BFu7s { short v1; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu32i_BFu8c { short v1; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu32i_BFu8i { short v1; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu32i_BFu8ll { short v1; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu32i_BFu8s { short v1; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu32i_BFu9i { short v1; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu32i_BFu9ll { short v1; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu32i_BFu9s { short v1; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu32i_C { short v1; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aS_BFu32i_D { short v1; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aS_BFu32i_F { short v1; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aS_BFu32i_I { short v1; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aS_BFu32i_Ip { short v1; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aS_BFu32i_L { short v1; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aS_BFu32i_S { short v1; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aS_BFu32i_Uc { short v1; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aS_BFu32i_Ui { short v1; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aS_BFu32i_Ul { short v1; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu32i_Us { short v1; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aS_BFu32i_Vp { short v1; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aS_BFu32ll { short v1; unsigned long long v2:32; };
struct __attribute__((packed)) aS_BFu32ll_BFu15i { short v1; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu32ll_BFu15ll { short v1; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu32ll_BFu15s { short v1; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu32ll_BFu16i { short v1; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu32ll_BFu16ll { short v1; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu32ll_BFu16s { short v1; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu32ll_BFu17i { short v1; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu32ll_BFu17ll { short v1; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu32ll_BFu1c { short v1; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu32ll_BFu1i { short v1; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu32ll_BFu1ll { short v1; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu32ll_BFu1s { short v1; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu32ll_BFu31i { short v1; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu32ll_BFu31ll { short v1; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu32ll_BFu32i { short v1; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu32ll_BFu32ll { short v1; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu32ll_BFu33 { short v1; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu32ll_BFu7c { short v1; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu32ll_BFu7i { short v1; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu32ll_BFu7ll { short v1; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu32ll_BFu7s { short v1; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu32ll_BFu8c { short v1; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu32ll_BFu8i { short v1; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu32ll_BFu8ll { short v1; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu32ll_BFu8s { short v1; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu32ll_BFu9i { short v1; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu32ll_BFu9ll { short v1; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu32ll_BFu9s { short v1; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu32ll_C { short v1; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aS_BFu32ll_D { short v1; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aS_BFu32ll_F { short v1; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aS_BFu32ll_I { short v1; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aS_BFu32ll_Ip { short v1; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aS_BFu32ll_L { short v1; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aS_BFu32ll_S { short v1; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aS_BFu32ll_Uc { short v1; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aS_BFu32ll_Ui { short v1; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aS_BFu32ll_Ul { short v1; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu32ll_Us { short v1; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aS_BFu32ll_Vp { short v1; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aS_BFu33 { short v1; unsigned long long v2:33; };
struct __attribute__((packed)) aS_BFu33_BFu15i { short v1; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu33_BFu15ll { short v1; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu33_BFu15s { short v1; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu33_BFu16i { short v1; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu33_BFu16ll { short v1; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu33_BFu16s { short v1; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu33_BFu17i { short v1; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu33_BFu17ll { short v1; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu33_BFu1c { short v1; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu33_BFu1i { short v1; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu33_BFu1ll { short v1; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu33_BFu1s { short v1; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu33_BFu31i { short v1; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu33_BFu31ll { short v1; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu33_BFu32i { short v1; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu33_BFu32ll { short v1; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu33_BFu33 { short v1; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu33_BFu7c { short v1; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu33_BFu7i { short v1; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu33_BFu7ll { short v1; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu33_BFu7s { short v1; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu33_BFu8c { short v1; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu33_BFu8i { short v1; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu33_BFu8ll { short v1; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu33_BFu8s { short v1; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu33_BFu9i { short v1; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu33_BFu9ll { short v1; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu33_BFu9s { short v1; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu33_C { short v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aS_BFu33_D { short v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aS_BFu33_F { short v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aS_BFu33_I { short v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aS_BFu33_Ip { short v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aS_BFu33_L { short v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aS_BFu33_S { short v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aS_BFu33_Uc { short v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aS_BFu33_Ui { short v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aS_BFu33_Ul { short v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu33_Us { short v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aS_BFu33_Vp { short v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aS_BFu7c { short v1; unsigned char v2:7; };
struct __attribute__((packed)) aS_BFu7c_BFu15i { short v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu7c_BFu15ll { short v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu7c_BFu15s { short v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu7c_BFu16i { short v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu7c_BFu16ll { short v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu7c_BFu16s { short v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu7c_BFu17i { short v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu7c_BFu17ll { short v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu7c_BFu1c { short v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu7c_BFu1i { short v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu7c_BFu1ll { short v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu7c_BFu1s { short v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu7c_BFu31i { short v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu7c_BFu31ll { short v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu7c_BFu32i { short v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu7c_BFu32ll { short v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu7c_BFu33 { short v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu7c_BFu7c { short v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu7c_BFu7i { short v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu7c_BFu7ll { short v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu7c_BFu7s { short v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu7c_BFu8c { short v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu7c_BFu8i { short v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu7c_BFu8ll { short v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu7c_BFu8s { short v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu7c_BFu9i { short v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu7c_BFu9ll { short v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu7c_BFu9s { short v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu7c_C { short v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aS_BFu7c_D { short v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aS_BFu7c_F { short v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aS_BFu7c_I { short v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aS_BFu7c_Ip { short v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aS_BFu7c_L { short v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aS_BFu7c_S { short v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aS_BFu7c_Uc { short v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aS_BFu7c_Ui { short v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aS_BFu7c_Ul { short v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu7c_Us { short v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aS_BFu7c_Vp { short v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aS_BFu7i { short v1; unsigned int v2:7; };
struct __attribute__((packed)) aS_BFu7i_BFu15i { short v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu7i_BFu15ll { short v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu7i_BFu15s { short v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu7i_BFu16i { short v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu7i_BFu16ll { short v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu7i_BFu16s { short v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu7i_BFu17i { short v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu7i_BFu17ll { short v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu7i_BFu1c { short v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu7i_BFu1i { short v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu7i_BFu1ll { short v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu7i_BFu1s { short v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu7i_BFu31i { short v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu7i_BFu31ll { short v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu7i_BFu32i { short v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu7i_BFu32ll { short v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu7i_BFu33 { short v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu7i_BFu7c { short v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu7i_BFu7i { short v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu7i_BFu7ll { short v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu7i_BFu7s { short v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu7i_BFu8c { short v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu7i_BFu8i { short v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu7i_BFu8ll { short v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu7i_BFu8s { short v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu7i_BFu9i { short v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu7i_BFu9ll { short v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu7i_BFu9s { short v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu7i_C { short v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aS_BFu7i_D { short v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aS_BFu7i_F { short v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aS_BFu7i_I { short v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aS_BFu7i_Ip { short v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aS_BFu7i_L { short v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aS_BFu7i_S { short v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aS_BFu7i_Uc { short v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aS_BFu7i_Ui { short v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aS_BFu7i_Ul { short v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu7i_Us { short v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aS_BFu7i_Vp { short v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aS_BFu7ll { short v1; unsigned long long v2:7; };
struct __attribute__((packed)) aS_BFu7ll_BFu15i { short v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu7ll_BFu15ll { short v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu7ll_BFu15s { short v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu7ll_BFu16i { short v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu7ll_BFu16ll { short v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu7ll_BFu16s { short v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu7ll_BFu17i { short v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu7ll_BFu17ll { short v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu7ll_BFu1c { short v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu7ll_BFu1i { short v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu7ll_BFu1ll { short v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu7ll_BFu1s { short v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu7ll_BFu31i { short v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu7ll_BFu31ll { short v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu7ll_BFu32i { short v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu7ll_BFu32ll { short v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu7ll_BFu33 { short v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu7ll_BFu7c { short v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu7ll_BFu7i { short v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu7ll_BFu7ll { short v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu7ll_BFu7s { short v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu7ll_BFu8c { short v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu7ll_BFu8i { short v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu7ll_BFu8ll { short v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu7ll_BFu8s { short v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu7ll_BFu9i { short v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu7ll_BFu9ll { short v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu7ll_BFu9s { short v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu7ll_C { short v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aS_BFu7ll_D { short v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aS_BFu7ll_F { short v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aS_BFu7ll_I { short v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aS_BFu7ll_Ip { short v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aS_BFu7ll_L { short v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aS_BFu7ll_S { short v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aS_BFu7ll_Uc { short v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aS_BFu7ll_Ui { short v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aS_BFu7ll_Ul { short v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu7ll_Us { short v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aS_BFu7ll_Vp { short v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aS_BFu7s { short v1; unsigned short v2:7; };
struct __attribute__((packed)) aS_BFu7s_BFu15i { short v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu7s_BFu15ll { short v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu7s_BFu15s { short v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu7s_BFu16i { short v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu7s_BFu16ll { short v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu7s_BFu16s { short v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu7s_BFu17i { short v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu7s_BFu17ll { short v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu7s_BFu1c { short v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu7s_BFu1i { short v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu7s_BFu1ll { short v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu7s_BFu1s { short v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu7s_BFu31i { short v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu7s_BFu31ll { short v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu7s_BFu32i { short v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu7s_BFu32ll { short v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu7s_BFu33 { short v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu7s_BFu7c { short v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu7s_BFu7i { short v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu7s_BFu7ll { short v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu7s_BFu7s { short v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu7s_BFu8c { short v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu7s_BFu8i { short v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu7s_BFu8ll { short v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu7s_BFu8s { short v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu7s_BFu9i { short v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu7s_BFu9ll { short v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu7s_BFu9s { short v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu7s_C { short v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aS_BFu7s_D { short v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aS_BFu7s_F { short v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aS_BFu7s_I { short v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aS_BFu7s_Ip { short v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aS_BFu7s_L { short v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aS_BFu7s_S { short v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aS_BFu7s_Uc { short v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aS_BFu7s_Ui { short v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aS_BFu7s_Ul { short v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu7s_Us { short v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aS_BFu7s_Vp { short v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aS_BFu8c { short v1; unsigned char v2:8; };
struct __attribute__((packed)) aS_BFu8c_BFu15i { short v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu8c_BFu15ll { short v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu8c_BFu15s { short v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu8c_BFu16i { short v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu8c_BFu16ll { short v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu8c_BFu16s { short v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu8c_BFu17i { short v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu8c_BFu17ll { short v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu8c_BFu1c { short v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu8c_BFu1i { short v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu8c_BFu1ll { short v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu8c_BFu1s { short v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu8c_BFu31i { short v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu8c_BFu31ll { short v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu8c_BFu32i { short v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu8c_BFu32ll { short v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu8c_BFu33 { short v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu8c_BFu7c { short v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu8c_BFu7i { short v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu8c_BFu7ll { short v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu8c_BFu7s { short v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu8c_BFu8c { short v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu8c_BFu8i { short v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu8c_BFu8ll { short v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu8c_BFu8s { short v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu8c_BFu9i { short v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu8c_BFu9ll { short v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu8c_BFu9s { short v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu8c_C { short v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aS_BFu8c_D { short v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aS_BFu8c_F { short v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aS_BFu8c_I { short v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aS_BFu8c_Ip { short v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aS_BFu8c_L { short v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aS_BFu8c_S { short v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aS_BFu8c_Uc { short v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aS_BFu8c_Ui { short v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aS_BFu8c_Ul { short v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu8c_Us { short v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aS_BFu8c_Vp { short v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aS_BFu8i { short v1; unsigned int v2:8; };
struct __attribute__((packed)) aS_BFu8i_BFu15i { short v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu8i_BFu15ll { short v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu8i_BFu15s { short v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu8i_BFu16i { short v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu8i_BFu16ll { short v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu8i_BFu16s { short v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu8i_BFu17i { short v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu8i_BFu17ll { short v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu8i_BFu1c { short v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu8i_BFu1i { short v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu8i_BFu1ll { short v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu8i_BFu1s { short v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu8i_BFu31i { short v1; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu8i_BFu31ll { short v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu8i_BFu32i { short v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu8i_BFu32ll { short v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu8i_BFu33 { short v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu8i_BFu7c { short v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu8i_BFu7i { short v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu8i_BFu7ll { short v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu8i_BFu7s { short v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu8i_BFu8c { short v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu8i_BFu8i { short v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu8i_BFu8ll { short v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu8i_BFu8s { short v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu8i_BFu9i { short v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu8i_BFu9ll { short v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu8i_BFu9s { short v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu8i_C { short v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aS_BFu8i_D { short v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aS_BFu8i_F { short v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aS_BFu8i_I { short v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aS_BFu8i_Ip { short v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aS_BFu8i_L { short v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aS_BFu8i_S { short v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aS_BFu8i_Uc { short v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aS_BFu8i_Ui { short v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aS_BFu8i_Ul { short v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu8i_Us { short v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aS_BFu8i_Vp { short v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aS_BFu8ll { short v1; unsigned long long v2:8; };
struct __attribute__((packed)) aS_BFu8ll_BFu15i { short v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu8ll_BFu15ll { short v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu8ll_BFu15s { short v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu8ll_BFu16i { short v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu8ll_BFu16ll { short v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu8ll_BFu16s { short v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu8ll_BFu17i { short v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu8ll_BFu17ll { short v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu8ll_BFu1c { short v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu8ll_BFu1i { short v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu8ll_BFu1ll { short v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu8ll_BFu1s { short v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu8ll_BFu31i { short v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu8ll_BFu31ll { short v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu8ll_BFu32i { short v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu8ll_BFu32ll { short v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu8ll_BFu33 { short v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu8ll_BFu7c { short v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu8ll_BFu7i { short v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu8ll_BFu7ll { short v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu8ll_BFu7s { short v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu8ll_BFu8c { short v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu8ll_BFu8i { short v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu8ll_BFu8ll { short v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu8ll_BFu8s { short v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu8ll_BFu9i { short v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu8ll_BFu9ll { short v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu8ll_BFu9s { short v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu8ll_C { short v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aS_BFu8ll_D { short v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aS_BFu8ll_F { short v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aS_BFu8ll_I { short v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aS_BFu8ll_Ip { short v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aS_BFu8ll_L { short v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aS_BFu8ll_S { short v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aS_BFu8ll_Uc { short v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aS_BFu8ll_Ui { short v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aS_BFu8ll_Ul { short v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu8ll_Us { short v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aS_BFu8ll_Vp { short v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aS_BFu8s { short v1; unsigned short v2:8; };
struct __attribute__((packed)) aS_BFu8s_BFu15i { short v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu8s_BFu15ll { short v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu8s_BFu15s { short v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu8s_BFu16i { short v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu8s_BFu16ll { short v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu8s_BFu16s { short v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu8s_BFu17i { short v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu8s_BFu17ll { short v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu8s_BFu1c { short v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu8s_BFu1i { short v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu8s_BFu1ll { short v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu8s_BFu1s { short v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu8s_BFu31i { short v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu8s_BFu31ll { short v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu8s_BFu32i { short v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu8s_BFu32ll { short v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu8s_BFu33 { short v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu8s_BFu7c { short v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu8s_BFu7i { short v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu8s_BFu7ll { short v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu8s_BFu7s { short v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu8s_BFu8c { short v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu8s_BFu8i { short v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu8s_BFu8ll { short v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu8s_BFu8s { short v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu8s_BFu9i { short v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu8s_BFu9ll { short v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu8s_BFu9s { short v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu8s_C { short v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aS_BFu8s_D { short v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aS_BFu8s_F { short v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aS_BFu8s_I { short v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aS_BFu8s_Ip { short v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aS_BFu8s_L { short v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aS_BFu8s_S { short v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aS_BFu8s_Uc { short v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aS_BFu8s_Ui { short v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aS_BFu8s_Ul { short v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu8s_Us { short v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aS_BFu8s_Vp { short v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aS_BFu9i { short v1; unsigned int v2:9; };
struct __attribute__((packed)) aS_BFu9i_BFu15i { short v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu9i_BFu15ll { short v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu9i_BFu15s { short v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu9i_BFu16i { short v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu9i_BFu16ll { short v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu9i_BFu16s { short v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu9i_BFu17i { short v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu9i_BFu17ll { short v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu9i_BFu1c { short v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu9i_BFu1i { short v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu9i_BFu1ll { short v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu9i_BFu1s { short v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu9i_BFu31i { short v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu9i_BFu31ll { short v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu9i_BFu32i { short v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu9i_BFu32ll { short v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu9i_BFu33 { short v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu9i_BFu7c { short v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu9i_BFu7i { short v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu9i_BFu7ll { short v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu9i_BFu7s { short v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu9i_BFu8c { short v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu9i_BFu8i { short v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu9i_BFu8ll { short v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu9i_BFu8s { short v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu9i_BFu9i { short v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu9i_BFu9ll { short v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu9i_BFu9s { short v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu9i_C { short v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aS_BFu9i_D { short v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aS_BFu9i_F { short v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aS_BFu9i_I { short v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aS_BFu9i_Ip { short v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aS_BFu9i_L { short v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aS_BFu9i_S { short v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aS_BFu9i_Uc { short v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aS_BFu9i_Ui { short v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aS_BFu9i_Ul { short v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu9i_Us { short v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aS_BFu9i_Vp { short v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aS_BFu9ll { short v1; unsigned long long v2:9; };
struct __attribute__((packed)) aS_BFu9ll_BFu15i { short v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu9ll_BFu15ll { short v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu9ll_BFu15s { short v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu9ll_BFu16i { short v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu9ll_BFu16ll { short v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu9ll_BFu16s { short v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu9ll_BFu17i { short v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu9ll_BFu17ll { short v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu9ll_BFu1c { short v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu9ll_BFu1i { short v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu9ll_BFu1ll { short v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu9ll_BFu1s { short v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu9ll_BFu31i { short v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu9ll_BFu31ll { short v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu9ll_BFu32i { short v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu9ll_BFu32ll { short v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu9ll_BFu33 { short v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu9ll_BFu7c { short v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu9ll_BFu7i { short v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu9ll_BFu7ll { short v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu9ll_BFu7s { short v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu9ll_BFu8c { short v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu9ll_BFu8i { short v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu9ll_BFu8ll { short v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu9ll_BFu8s { short v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu9ll_BFu9i { short v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu9ll_BFu9ll { short v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu9ll_BFu9s { short v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu9ll_C { short v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aS_BFu9ll_D { short v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aS_BFu9ll_F { short v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aS_BFu9ll_I { short v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aS_BFu9ll_Ip { short v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aS_BFu9ll_L { short v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aS_BFu9ll_S { short v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aS_BFu9ll_Uc { short v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aS_BFu9ll_Ui { short v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aS_BFu9ll_Ul { short v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu9ll_Us { short v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aS_BFu9ll_Vp { short v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aS_BFu9s { short v1; unsigned short v2:9; };
struct __attribute__((packed)) aS_BFu9s_BFu15i { short v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aS_BFu9s_BFu15ll { short v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aS_BFu9s_BFu15s { short v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aS_BFu9s_BFu16i { short v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aS_BFu9s_BFu16ll { short v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aS_BFu9s_BFu16s { short v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aS_BFu9s_BFu17i { short v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aS_BFu9s_BFu17ll { short v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aS_BFu9s_BFu1c { short v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aS_BFu9s_BFu1i { short v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aS_BFu9s_BFu1ll { short v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aS_BFu9s_BFu1s { short v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aS_BFu9s_BFu31i { short v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aS_BFu9s_BFu31ll { short v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aS_BFu9s_BFu32i { short v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aS_BFu9s_BFu32ll { short v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aS_BFu9s_BFu33 { short v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aS_BFu9s_BFu7c { short v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aS_BFu9s_BFu7i { short v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aS_BFu9s_BFu7ll { short v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aS_BFu9s_BFu7s { short v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aS_BFu9s_BFu8c { short v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aS_BFu9s_BFu8i { short v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aS_BFu9s_BFu8ll { short v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aS_BFu9s_BFu8s { short v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aS_BFu9s_BFu9i { short v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aS_BFu9s_BFu9ll { short v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aS_BFu9s_BFu9s { short v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aS_BFu9s_C { short v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aS_BFu9s_D { short v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aS_BFu9s_F { short v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aS_BFu9s_I { short v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aS_BFu9s_Ip { short v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aS_BFu9s_L { short v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aS_BFu9s_S { short v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aS_BFu9s_Uc { short v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aS_BFu9s_Ui { short v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aS_BFu9s_Ul { short v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aS_BFu9s_Us { short v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aS_BFu9s_Vp { short v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aS_C { short v1; char v2; };
struct __attribute__((packed)) aS_C_BFu15i { short v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_C_BFu15ll { short v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_C_BFu15s { short v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_C_BFu16i { short v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_C_BFu16ll { short v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_C_BFu16s { short v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_C_BFu17i { short v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_C_BFu17ll { short v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_C_BFu1c { short v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_C_BFu1i { short v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_C_BFu1ll { short v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_C_BFu1s { short v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_C_BFu31i { short v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_C_BFu31ll { short v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_C_BFu32i { short v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_C_BFu32ll { short v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_C_BFu33 { short v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_C_BFu7c { short v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_C_BFu7i { short v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_C_BFu7ll { short v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_C_BFu7s { short v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_C_BFu8c { short v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_C_BFu8i { short v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_C_BFu8ll { short v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_C_BFu8s { short v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_C_BFu9i { short v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_C_BFu9ll { short v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_C_BFu9s { short v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_C_C { short v1; char v2; char v3; };
struct __attribute__((packed)) aS_C_D { short v1; char v2; double v3; };
struct __attribute__((packed)) aS_C_F { short v1; char v2; float v3; };
struct __attribute__((packed)) aS_C_I { short v1; char v2; int v3; };
struct __attribute__((packed)) aS_C_Ip { short v1; char v2; int * v3; };
struct __attribute__((packed)) aS_C_L { short v1; char v2; long long v3; };
struct __attribute__((packed)) aS_C_S { short v1; char v2; short v3; };
struct __attribute__((packed)) aS_C_Uc { short v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aS_C_Ui { short v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aS_C_Ul { short v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aS_C_Us { short v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aS_C_Vp { short v1; char v2; void * v3; };
struct __attribute__((packed)) aS_D { short v1; double v2; };
struct __attribute__((packed)) aS_D_BFu15i { short v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_D_BFu15ll { short v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_D_BFu15s { short v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_D_BFu16i { short v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_D_BFu16ll { short v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_D_BFu16s { short v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_D_BFu17i { short v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_D_BFu17ll { short v1; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_D_BFu1c { short v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_D_BFu1i { short v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_D_BFu1ll { short v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_D_BFu1s { short v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_D_BFu31i { short v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_D_BFu31ll { short v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_D_BFu32i { short v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_D_BFu32ll { short v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_D_BFu33 { short v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_D_BFu7c { short v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_D_BFu7i { short v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_D_BFu7ll { short v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_D_BFu7s { short v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_D_BFu8c { short v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_D_BFu8i { short v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_D_BFu8ll { short v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_D_BFu8s { short v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_D_BFu9i { short v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_D_BFu9ll { short v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_D_BFu9s { short v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_D_C { short v1; double v2; char v3; };
struct __attribute__((packed)) aS_D_D { short v1; double v2; double v3; };
struct __attribute__((packed)) aS_D_F { short v1; double v2; float v3; };
struct __attribute__((packed)) aS_D_I { short v1; double v2; int v3; };
struct __attribute__((packed)) aS_D_Ip { short v1; double v2; int * v3; };
struct __attribute__((packed)) aS_D_L { short v1; double v2; long long v3; };
struct __attribute__((packed)) aS_D_S { short v1; double v2; short v3; };
struct __attribute__((packed)) aS_D_Uc { short v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aS_D_Ui { short v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aS_D_Ul { short v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aS_D_Us { short v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aS_D_Vp { short v1; double v2; void * v3; };
struct __attribute__((packed)) aS_F { short v1; float v2; };
struct __attribute__((packed)) aS_F_BFu15i { short v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_F_BFu15ll { short v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_F_BFu15s { short v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_F_BFu16i { short v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_F_BFu16ll { short v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_F_BFu16s { short v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_F_BFu17i { short v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_F_BFu17ll { short v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_F_BFu1c { short v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_F_BFu1i { short v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_F_BFu1ll { short v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_F_BFu1s { short v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_F_BFu31i { short v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_F_BFu31ll { short v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_F_BFu32i { short v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_F_BFu32ll { short v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_F_BFu33 { short v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_F_BFu7c { short v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_F_BFu7i { short v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_F_BFu7ll { short v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_F_BFu7s { short v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_F_BFu8c { short v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_F_BFu8i { short v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_F_BFu8ll { short v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_F_BFu8s { short v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_F_BFu9i { short v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_F_BFu9ll { short v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_F_BFu9s { short v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_F_C { short v1; float v2; char v3; };
struct __attribute__((packed)) aS_F_D { short v1; float v2; double v3; };
struct __attribute__((packed)) aS_F_F { short v1; float v2; float v3; };
struct __attribute__((packed)) aS_F_I { short v1; float v2; int v3; };
struct __attribute__((packed)) aS_F_Ip { short v1; float v2; int * v3; };
struct __attribute__((packed)) aS_F_L { short v1; float v2; long long v3; };
struct __attribute__((packed)) aS_F_S { short v1; float v2; short v3; };
struct __attribute__((packed)) aS_F_Uc { short v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aS_F_Ui { short v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aS_F_Ul { short v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aS_F_Us { short v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aS_F_Vp { short v1; float v2; void * v3; };
struct __attribute__((packed)) aS_I { short v1; int v2; };
struct __attribute__((packed)) aS_I_BFu15i { short v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_I_BFu15ll { short v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_I_BFu15s { short v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_I_BFu16i { short v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_I_BFu16ll { short v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_I_BFu16s { short v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_I_BFu17i { short v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_I_BFu17ll { short v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_I_BFu1c { short v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_I_BFu1i { short v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_I_BFu1ll { short v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_I_BFu1s { short v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_I_BFu31i { short v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_I_BFu31ll { short v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_I_BFu32i { short v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_I_BFu32ll { short v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_I_BFu33 { short v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_I_BFu7c { short v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_I_BFu7i { short v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_I_BFu7ll { short v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_I_BFu7s { short v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_I_BFu8c { short v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_I_BFu8i { short v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_I_BFu8ll { short v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_I_BFu8s { short v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_I_BFu9i { short v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_I_BFu9ll { short v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_I_BFu9s { short v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_I_C { short v1; int v2; char v3; };
struct __attribute__((packed)) aS_I_D { short v1; int v2; double v3; };
struct __attribute__((packed)) aS_I_F { short v1; int v2; float v3; };
struct __attribute__((packed)) aS_I_I { short v1; int v2; int v3; };
struct __attribute__((packed)) aS_I_Ip { short v1; int v2; int * v3; };
struct __attribute__((packed)) aS_I_L { short v1; int v2; long long v3; };
struct __attribute__((packed)) aS_I_S { short v1; int v2; short v3; };
struct __attribute__((packed)) aS_I_Uc { short v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aS_I_Ui { short v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aS_I_Ul { short v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aS_I_Us { short v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aS_I_Vp { short v1; int v2; void * v3; };
struct __attribute__((packed)) aS_Ip { short v1; int * v2; };
struct __attribute__((packed)) aS_Ip_BFu15i { short v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_Ip_BFu15ll { short v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_Ip_BFu15s { short v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_Ip_BFu16i { short v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_Ip_BFu16ll { short v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_Ip_BFu16s { short v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_Ip_BFu17i { short v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_Ip_BFu17ll { short v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_Ip_BFu1c { short v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_Ip_BFu1i { short v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_Ip_BFu1ll { short v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_Ip_BFu1s { short v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_Ip_BFu31i { short v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_Ip_BFu31ll { short v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_Ip_BFu32i { short v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_Ip_BFu32ll { short v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_Ip_BFu33 { short v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_Ip_BFu7c { short v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_Ip_BFu7i { short v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_Ip_BFu7ll { short v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_Ip_BFu7s { short v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_Ip_BFu8c { short v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_Ip_BFu8i { short v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_Ip_BFu8ll { short v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_Ip_BFu8s { short v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_Ip_BFu9i { short v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_Ip_BFu9ll { short v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_Ip_BFu9s { short v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_Ip_C { short v1; int * v2; char v3; };
struct __attribute__((packed)) aS_Ip_D { short v1; int * v2; double v3; };
struct __attribute__((packed)) aS_Ip_F { short v1; int * v2; float v3; };
struct __attribute__((packed)) aS_Ip_I { short v1; int * v2; int v3; };
struct __attribute__((packed)) aS_Ip_Ip { short v1; int * v2; int * v3; };
struct __attribute__((packed)) aS_Ip_L { short v1; int * v2; long long v3; };
struct __attribute__((packed)) aS_Ip_S { short v1; int * v2; short v3; };
struct __attribute__((packed)) aS_Ip_Uc { short v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aS_Ip_Ui { short v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aS_Ip_Ul { short v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aS_Ip_Us { short v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aS_Ip_Vp { short v1; int * v2; void * v3; };
struct __attribute__((packed)) aS_L { short v1; long long v2; };
struct __attribute__((packed)) aS_L_BFu15i { short v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_L_BFu15ll { short v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_L_BFu15s { short v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_L_BFu16i { short v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_L_BFu16ll { short v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_L_BFu16s { short v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_L_BFu17i { short v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_L_BFu17ll { short v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_L_BFu1c { short v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_L_BFu1i { short v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_L_BFu1ll { short v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_L_BFu1s { short v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_L_BFu31i { short v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_L_BFu31ll { short v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_L_BFu32i { short v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_L_BFu32ll { short v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_L_BFu33 { short v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_L_BFu7c { short v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_L_BFu7i { short v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_L_BFu7ll { short v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_L_BFu7s { short v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_L_BFu8c { short v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_L_BFu8i { short v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_L_BFu8ll { short v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_L_BFu8s { short v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_L_BFu9i { short v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_L_BFu9ll { short v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_L_BFu9s { short v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_L_C { short v1; long long v2; char v3; };
struct __attribute__((packed)) aS_L_D { short v1; long long v2; double v3; };
struct __attribute__((packed)) aS_L_F { short v1; long long v2; float v3; };
struct __attribute__((packed)) aS_L_I { short v1; long long v2; int v3; };
struct __attribute__((packed)) aS_L_Ip { short v1; long long v2; int * v3; };
struct __attribute__((packed)) aS_L_L { short v1; long long v2; long long v3; };
struct __attribute__((packed)) aS_L_S { short v1; long long v2; short v3; };
struct __attribute__((packed)) aS_L_Uc { short v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aS_L_Ui { short v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aS_L_Ul { short v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aS_L_Us { short v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aS_L_Vp { short v1; long long v2; void * v3; };
struct __attribute__((packed)) aS_S { short v1; short v2; };
struct __attribute__((packed)) aS_S_BFu15i { short v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_S_BFu15ll { short v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_S_BFu15s { short v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_S_BFu16i { short v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_S_BFu16ll { short v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_S_BFu16s { short v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_S_BFu17i { short v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_S_BFu17ll { short v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_S_BFu1c { short v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_S_BFu1i { short v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_S_BFu1ll { short v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_S_BFu1s { short v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_S_BFu31i { short v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_S_BFu31ll { short v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_S_BFu32i { short v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_S_BFu32ll { short v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_S_BFu33 { short v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_S_BFu7c { short v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_S_BFu7i { short v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_S_BFu7ll { short v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_S_BFu7s { short v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_S_BFu8c { short v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_S_BFu8i { short v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_S_BFu8ll { short v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_S_BFu8s { short v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_S_BFu9i { short v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_S_BFu9ll { short v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_S_BFu9s { short v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_S_C { short v1; short v2; char v3; };
struct __attribute__((packed)) aS_S_D { short v1; short v2; double v3; };
struct __attribute__((packed)) aS_S_F { short v1; short v2; float v3; };
struct __attribute__((packed)) aS_S_I { short v1; short v2; int v3; };
struct __attribute__((packed)) aS_S_Ip { short v1; short v2; int * v3; };
struct __attribute__((packed)) aS_S_L { short v1; short v2; long long v3; };
struct __attribute__((packed)) aS_S_S { short v1; short v2; short v3; };
struct __attribute__((packed)) aS_S_Uc { short v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aS_S_Ui { short v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aS_S_Ul { short v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aS_S_Us { short v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aS_S_Vp { short v1; short v2; void * v3; };
struct __attribute__((packed)) aS_Uc { short v1; unsigned char v2; };
struct __attribute__((packed)) aS_Uc_BFu15i { short v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_Uc_BFu15ll { short v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_Uc_BFu15s { short v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_Uc_BFu16i { short v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_Uc_BFu16ll { short v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_Uc_BFu16s { short v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_Uc_BFu17i { short v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_Uc_BFu17ll { short v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_Uc_BFu1c { short v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_Uc_BFu1i { short v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_Uc_BFu1ll { short v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_Uc_BFu1s { short v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_Uc_BFu31i { short v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_Uc_BFu31ll { short v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_Uc_BFu32i { short v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_Uc_BFu32ll { short v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_Uc_BFu33 { short v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_Uc_BFu7c { short v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_Uc_BFu7i { short v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_Uc_BFu7ll { short v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_Uc_BFu7s { short v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_Uc_BFu8c { short v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_Uc_BFu8i { short v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_Uc_BFu8ll { short v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_Uc_BFu8s { short v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_Uc_BFu9i { short v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_Uc_BFu9ll { short v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_Uc_BFu9s { short v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_Uc_C { short v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aS_Uc_D { short v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aS_Uc_F { short v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aS_Uc_I { short v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aS_Uc_Ip { short v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aS_Uc_L { short v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aS_Uc_S { short v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aS_Uc_Uc { short v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aS_Uc_Ui { short v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aS_Uc_Ul { short v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aS_Uc_Us { short v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aS_Uc_Vp { short v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aS_Ui { short v1; unsigned int v2; };
struct __attribute__((packed)) aS_Ui_BFu15i { short v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_Ui_BFu15ll { short v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_Ui_BFu15s { short v1; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_Ui_BFu16i { short v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_Ui_BFu16ll { short v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_Ui_BFu16s { short v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_Ui_BFu17i { short v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_Ui_BFu17ll { short v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_Ui_BFu1c { short v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_Ui_BFu1i { short v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_Ui_BFu1ll { short v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_Ui_BFu1s { short v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_Ui_BFu31i { short v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_Ui_BFu31ll { short v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_Ui_BFu32i { short v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_Ui_BFu32ll { short v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_Ui_BFu33 { short v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_Ui_BFu7c { short v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_Ui_BFu7i { short v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_Ui_BFu7ll { short v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_Ui_BFu7s { short v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_Ui_BFu8c { short v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_Ui_BFu8i { short v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_Ui_BFu8ll { short v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_Ui_BFu8s { short v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_Ui_BFu9i { short v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_Ui_BFu9ll { short v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_Ui_BFu9s { short v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_Ui_C { short v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aS_Ui_D { short v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aS_Ui_F { short v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aS_Ui_I { short v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aS_Ui_Ip { short v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aS_Ui_L { short v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aS_Ui_S { short v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aS_Ui_Uc { short v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aS_Ui_Ui { short v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aS_Ui_Ul { short v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aS_Ui_Us { short v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aS_Ui_Vp { short v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aS_Ul { short v1; unsigned long long v2; };
struct __attribute__((packed)) aS_Ul_BFu15i { short v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_Ul_BFu15ll { short v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_Ul_BFu15s { short v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_Ul_BFu16i { short v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_Ul_BFu16ll { short v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_Ul_BFu16s { short v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_Ul_BFu17i { short v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_Ul_BFu17ll { short v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_Ul_BFu1c { short v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_Ul_BFu1i { short v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_Ul_BFu1ll { short v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_Ul_BFu1s { short v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_Ul_BFu31i { short v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_Ul_BFu31ll { short v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_Ul_BFu32i { short v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_Ul_BFu32ll { short v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_Ul_BFu33 { short v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_Ul_BFu7c { short v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_Ul_BFu7i { short v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_Ul_BFu7ll { short v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_Ul_BFu7s { short v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_Ul_BFu8c { short v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_Ul_BFu8i { short v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_Ul_BFu8ll { short v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_Ul_BFu8s { short v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_Ul_BFu9i { short v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_Ul_BFu9ll { short v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_Ul_BFu9s { short v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_Ul_C { short v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aS_Ul_D { short v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aS_Ul_F { short v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aS_Ul_I { short v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aS_Ul_Ip { short v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aS_Ul_L { short v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aS_Ul_S { short v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aS_Ul_Uc { short v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aS_Ul_Ui { short v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aS_Ul_Ul { short v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aS_Ul_Us { short v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aS_Ul_Vp { short v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aS_Us { short v1; unsigned short v2; };
struct __attribute__((packed)) aS_Us_BFu15i { short v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_Us_BFu15ll { short v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_Us_BFu15s { short v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_Us_BFu16i { short v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_Us_BFu16ll { short v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_Us_BFu16s { short v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_Us_BFu17i { short v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_Us_BFu17ll { short v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_Us_BFu1c { short v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_Us_BFu1i { short v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_Us_BFu1ll { short v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_Us_BFu1s { short v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_Us_BFu31i { short v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_Us_BFu31ll { short v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_Us_BFu32i { short v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_Us_BFu32ll { short v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_Us_BFu33 { short v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_Us_BFu7c { short v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_Us_BFu7i { short v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_Us_BFu7ll { short v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_Us_BFu7s { short v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_Us_BFu8c { short v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_Us_BFu8i { short v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_Us_BFu8ll { short v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_Us_BFu8s { short v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_Us_BFu9i { short v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_Us_BFu9ll { short v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_Us_BFu9s { short v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_Us_C { short v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aS_Us_D { short v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aS_Us_F { short v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aS_Us_I { short v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aS_Us_Ip { short v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aS_Us_L { short v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aS_Us_S { short v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aS_Us_Uc { short v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aS_Us_Ui { short v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aS_Us_Ul { short v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aS_Us_Us { short v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aS_Us_Vp { short v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aS_Vp { short v1; void * v2; };
struct __attribute__((packed)) aS_Vp_BFu15i { short v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aS_Vp_BFu15ll { short v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aS_Vp_BFu15s { short v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aS_Vp_BFu16i { short v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aS_Vp_BFu16ll { short v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aS_Vp_BFu16s { short v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aS_Vp_BFu17i { short v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aS_Vp_BFu17ll { short v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aS_Vp_BFu1c { short v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aS_Vp_BFu1i { short v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aS_Vp_BFu1ll { short v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aS_Vp_BFu1s { short v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aS_Vp_BFu31i { short v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aS_Vp_BFu31ll { short v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aS_Vp_BFu32i { short v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aS_Vp_BFu32ll { short v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aS_Vp_BFu33 { short v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aS_Vp_BFu7c { short v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aS_Vp_BFu7i { short v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aS_Vp_BFu7ll { short v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aS_Vp_BFu7s { short v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aS_Vp_BFu8c { short v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aS_Vp_BFu8i { short v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aS_Vp_BFu8ll { short v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aS_Vp_BFu8s { short v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aS_Vp_BFu9i { short v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aS_Vp_BFu9ll { short v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aS_Vp_BFu9s { short v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aS_Vp_C { short v1; void * v2; char v3; };
struct __attribute__((packed)) aS_Vp_D { short v1; void * v2; double v3; };
struct __attribute__((packed)) aS_Vp_F { short v1; void * v2; float v3; };
struct __attribute__((packed)) aS_Vp_I { short v1; void * v2; int v3; };
struct __attribute__((packed)) aS_Vp_Ip { short v1; void * v2; int * v3; };
struct __attribute__((packed)) aS_Vp_L { short v1; void * v2; long long v3; };
struct __attribute__((packed)) aS_Vp_S { short v1; void * v2; short v3; };
struct __attribute__((packed)) aS_Vp_Uc { short v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aS_Vp_Ui { short v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aS_Vp_Ul { short v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aS_Vp_Us { short v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aS_Vp_Vp { short v1; void * v2; void * v3; };
struct __attribute__((packed)) aUc { unsigned char v1; };
struct __attribute__((packed)) aUc_BFu15i { unsigned char v1; unsigned int v2:15; };
struct __attribute__((packed)) aUc_BFu15i_BFu15i { unsigned char v1; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu15i_BFu15ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu15i_BFu15s { unsigned char v1; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu15i_BFu16i { unsigned char v1; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu15i_BFu16ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu15i_BFu16s { unsigned char v1; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu15i_BFu17i { unsigned char v1; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu15i_BFu17ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu15i_BFu1c { unsigned char v1; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu15i_BFu1i { unsigned char v1; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu15i_BFu1ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu15i_BFu1s { unsigned char v1; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu15i_BFu31i { unsigned char v1; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu15i_BFu31ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu15i_BFu32i { unsigned char v1; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu15i_BFu32ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu15i_BFu33 { unsigned char v1; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu15i_BFu7c { unsigned char v1; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu15i_BFu7i { unsigned char v1; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu15i_BFu7ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu15i_BFu7s { unsigned char v1; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu15i_BFu8c { unsigned char v1; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu15i_BFu8i { unsigned char v1; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu15i_BFu8ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu15i_BFu8s { unsigned char v1; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu15i_BFu9i { unsigned char v1; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu15i_BFu9ll { unsigned char v1; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu15i_BFu9s { unsigned char v1; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu15i_C { unsigned char v1; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aUc_BFu15i_D { unsigned char v1; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aUc_BFu15i_F { unsigned char v1; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aUc_BFu15i_I { unsigned char v1; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aUc_BFu15i_Ip { unsigned char v1; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aUc_BFu15i_L { unsigned char v1; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aUc_BFu15i_S { unsigned char v1; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aUc_BFu15i_Uc { unsigned char v1; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu15i_Ui { unsigned char v1; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu15i_Ul { unsigned char v1; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu15i_Us { unsigned char v1; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu15i_Vp { unsigned char v1; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aUc_BFu15ll { unsigned char v1; unsigned long long v2:15; };
struct __attribute__((packed)) aUc_BFu15ll_BFu15i { unsigned char v1; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu15ll_BFu15ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu15ll_BFu15s { unsigned char v1; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu15ll_BFu16i { unsigned char v1; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu15ll_BFu16ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu15ll_BFu16s { unsigned char v1; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu15ll_BFu17i { unsigned char v1; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu15ll_BFu17ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu15ll_BFu1c { unsigned char v1; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu15ll_BFu1i { unsigned char v1; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu15ll_BFu1ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu15ll_BFu1s { unsigned char v1; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu15ll_BFu31i { unsigned char v1; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu15ll_BFu31ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu15ll_BFu32i { unsigned char v1; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu15ll_BFu32ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu15ll_BFu33 { unsigned char v1; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu15ll_BFu7c { unsigned char v1; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu15ll_BFu7i { unsigned char v1; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu15ll_BFu7ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu15ll_BFu7s { unsigned char v1; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu15ll_BFu8c { unsigned char v1; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu15ll_BFu8i { unsigned char v1; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu15ll_BFu8ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu15ll_BFu8s { unsigned char v1; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu15ll_BFu9i { unsigned char v1; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu15ll_BFu9ll { unsigned char v1; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu15ll_BFu9s { unsigned char v1; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu15ll_C { unsigned char v1; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aUc_BFu15ll_D { unsigned char v1; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aUc_BFu15ll_F { unsigned char v1; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aUc_BFu15ll_I { unsigned char v1; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aUc_BFu15ll_Ip { unsigned char v1; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aUc_BFu15ll_L { unsigned char v1; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aUc_BFu15ll_S { unsigned char v1; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aUc_BFu15ll_Uc { unsigned char v1; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu15ll_Ui { unsigned char v1; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu15ll_Ul { unsigned char v1; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu15ll_Us { unsigned char v1; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu15ll_Vp { unsigned char v1; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aUc_BFu15s { unsigned char v1; unsigned short v2:15; };
struct __attribute__((packed)) aUc_BFu15s_BFu15i { unsigned char v1; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu15s_BFu15ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu15s_BFu15s { unsigned char v1; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu15s_BFu16i { unsigned char v1; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu15s_BFu16ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu15s_BFu16s { unsigned char v1; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu15s_BFu17i { unsigned char v1; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu15s_BFu17ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu15s_BFu1c { unsigned char v1; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu15s_BFu1i { unsigned char v1; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu15s_BFu1ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu15s_BFu1s { unsigned char v1; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu15s_BFu31i { unsigned char v1; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu15s_BFu31ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu15s_BFu32i { unsigned char v1; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu15s_BFu32ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu15s_BFu33 { unsigned char v1; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu15s_BFu7c { unsigned char v1; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu15s_BFu7i { unsigned char v1; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu15s_BFu7ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu15s_BFu7s { unsigned char v1; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu15s_BFu8c { unsigned char v1; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu15s_BFu8i { unsigned char v1; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu15s_BFu8ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu15s_BFu8s { unsigned char v1; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu15s_BFu9i { unsigned char v1; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu15s_BFu9ll { unsigned char v1; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu15s_BFu9s { unsigned char v1; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu15s_C { unsigned char v1; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aUc_BFu15s_D { unsigned char v1; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aUc_BFu15s_F { unsigned char v1; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aUc_BFu15s_I { unsigned char v1; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aUc_BFu15s_Ip { unsigned char v1; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aUc_BFu15s_L { unsigned char v1; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aUc_BFu15s_S { unsigned char v1; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aUc_BFu15s_Uc { unsigned char v1; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu15s_Ui { unsigned char v1; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu15s_Ul { unsigned char v1; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu15s_Us { unsigned char v1; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu15s_Vp { unsigned char v1; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aUc_BFu16i { unsigned char v1; unsigned int v2:16; };
struct __attribute__((packed)) aUc_BFu16i_BFu15i { unsigned char v1; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu16i_BFu15ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu16i_BFu15s { unsigned char v1; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu16i_BFu16i { unsigned char v1; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu16i_BFu16ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu16i_BFu16s { unsigned char v1; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu16i_BFu17i { unsigned char v1; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu16i_BFu17ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu16i_BFu1c { unsigned char v1; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu16i_BFu1i { unsigned char v1; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu16i_BFu1ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu16i_BFu1s { unsigned char v1; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu16i_BFu31i { unsigned char v1; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu16i_BFu31ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu16i_BFu32i { unsigned char v1; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu16i_BFu32ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu16i_BFu33 { unsigned char v1; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu16i_BFu7c { unsigned char v1; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu16i_BFu7i { unsigned char v1; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu16i_BFu7ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu16i_BFu7s { unsigned char v1; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu16i_BFu8c { unsigned char v1; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu16i_BFu8i { unsigned char v1; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu16i_BFu8ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu16i_BFu8s { unsigned char v1; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu16i_BFu9i { unsigned char v1; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu16i_BFu9ll { unsigned char v1; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu16i_BFu9s { unsigned char v1; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu16i_C { unsigned char v1; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aUc_BFu16i_D { unsigned char v1; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aUc_BFu16i_F { unsigned char v1; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aUc_BFu16i_I { unsigned char v1; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aUc_BFu16i_Ip { unsigned char v1; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aUc_BFu16i_L { unsigned char v1; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aUc_BFu16i_S { unsigned char v1; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aUc_BFu16i_Uc { unsigned char v1; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu16i_Ui { unsigned char v1; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu16i_Ul { unsigned char v1; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu16i_Us { unsigned char v1; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu16i_Vp { unsigned char v1; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aUc_BFu16ll { unsigned char v1; unsigned long long v2:16; };
struct __attribute__((packed)) aUc_BFu16ll_BFu15i { unsigned char v1; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu16ll_BFu15ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu16ll_BFu15s { unsigned char v1; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu16ll_BFu16i { unsigned char v1; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu16ll_BFu16ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu16ll_BFu16s { unsigned char v1; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu16ll_BFu17i { unsigned char v1; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu16ll_BFu17ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu16ll_BFu1c { unsigned char v1; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu16ll_BFu1i { unsigned char v1; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu16ll_BFu1ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu16ll_BFu1s { unsigned char v1; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu16ll_BFu31i { unsigned char v1; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu16ll_BFu31ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu16ll_BFu32i { unsigned char v1; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu16ll_BFu32ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu16ll_BFu33 { unsigned char v1; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu16ll_BFu7c { unsigned char v1; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu16ll_BFu7i { unsigned char v1; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu16ll_BFu7ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu16ll_BFu7s { unsigned char v1; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu16ll_BFu8c { unsigned char v1; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu16ll_BFu8i { unsigned char v1; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu16ll_BFu8ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu16ll_BFu8s { unsigned char v1; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu16ll_BFu9i { unsigned char v1; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu16ll_BFu9ll { unsigned char v1; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu16ll_BFu9s { unsigned char v1; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu16ll_C { unsigned char v1; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aUc_BFu16ll_D { unsigned char v1; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aUc_BFu16ll_F { unsigned char v1; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aUc_BFu16ll_I { unsigned char v1; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aUc_BFu16ll_Ip { unsigned char v1; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aUc_BFu16ll_L { unsigned char v1; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aUc_BFu16ll_S { unsigned char v1; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aUc_BFu16ll_Uc { unsigned char v1; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu16ll_Ui { unsigned char v1; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu16ll_Ul { unsigned char v1; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu16ll_Us { unsigned char v1; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu16ll_Vp { unsigned char v1; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aUc_BFu16s { unsigned char v1; unsigned short v2:16; };
struct __attribute__((packed)) aUc_BFu16s_BFu15i { unsigned char v1; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu16s_BFu15ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu16s_BFu15s { unsigned char v1; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu16s_BFu16i { unsigned char v1; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu16s_BFu16ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu16s_BFu16s { unsigned char v1; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu16s_BFu17i { unsigned char v1; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu16s_BFu17ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu16s_BFu1c { unsigned char v1; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu16s_BFu1i { unsigned char v1; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu16s_BFu1ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu16s_BFu1s { unsigned char v1; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu16s_BFu31i { unsigned char v1; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu16s_BFu31ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu16s_BFu32i { unsigned char v1; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu16s_BFu32ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu16s_BFu33 { unsigned char v1; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu16s_BFu7c { unsigned char v1; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu16s_BFu7i { unsigned char v1; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu16s_BFu7ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu16s_BFu7s { unsigned char v1; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu16s_BFu8c { unsigned char v1; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu16s_BFu8i { unsigned char v1; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu16s_BFu8ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu16s_BFu8s { unsigned char v1; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu16s_BFu9i { unsigned char v1; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu16s_BFu9ll { unsigned char v1; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu16s_BFu9s { unsigned char v1; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu16s_C { unsigned char v1; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aUc_BFu16s_D { unsigned char v1; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aUc_BFu16s_F { unsigned char v1; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aUc_BFu16s_I { unsigned char v1; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aUc_BFu16s_Ip { unsigned char v1; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aUc_BFu16s_L { unsigned char v1; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aUc_BFu16s_S { unsigned char v1; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aUc_BFu16s_Uc { unsigned char v1; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu16s_Ui { unsigned char v1; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu16s_Ul { unsigned char v1; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu16s_Us { unsigned char v1; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu16s_Vp { unsigned char v1; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aUc_BFu17i { unsigned char v1; unsigned int v2:17; };
struct __attribute__((packed)) aUc_BFu17i_BFu15i { unsigned char v1; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu17i_BFu15ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu17i_BFu15s { unsigned char v1; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu17i_BFu16i { unsigned char v1; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu17i_BFu16ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu17i_BFu16s { unsigned char v1; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu17i_BFu17i { unsigned char v1; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu17i_BFu17ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu17i_BFu1c { unsigned char v1; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu17i_BFu1i { unsigned char v1; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu17i_BFu1ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu17i_BFu1s { unsigned char v1; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu17i_BFu31i { unsigned char v1; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu17i_BFu31ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu17i_BFu32i { unsigned char v1; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu17i_BFu32ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu17i_BFu33 { unsigned char v1; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu17i_BFu7c { unsigned char v1; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu17i_BFu7i { unsigned char v1; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu17i_BFu7ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu17i_BFu7s { unsigned char v1; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu17i_BFu8c { unsigned char v1; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu17i_BFu8i { unsigned char v1; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu17i_BFu8ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu17i_BFu8s { unsigned char v1; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu17i_BFu9i { unsigned char v1; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu17i_BFu9ll { unsigned char v1; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu17i_BFu9s { unsigned char v1; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu17i_C { unsigned char v1; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aUc_BFu17i_D { unsigned char v1; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aUc_BFu17i_F { unsigned char v1; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aUc_BFu17i_I { unsigned char v1; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aUc_BFu17i_Ip { unsigned char v1; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aUc_BFu17i_L { unsigned char v1; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aUc_BFu17i_S { unsigned char v1; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aUc_BFu17i_Uc { unsigned char v1; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu17i_Ui { unsigned char v1; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu17i_Ul { unsigned char v1; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu17i_Us { unsigned char v1; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu17i_Vp { unsigned char v1; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aUc_BFu17ll { unsigned char v1; unsigned long long v2:17; };
struct __attribute__((packed)) aUc_BFu17ll_BFu15i { unsigned char v1; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu17ll_BFu15ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu17ll_BFu15s { unsigned char v1; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu17ll_BFu16i { unsigned char v1; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu17ll_BFu16ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu17ll_BFu16s { unsigned char v1; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu17ll_BFu17i { unsigned char v1; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu17ll_BFu17ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu17ll_BFu1c { unsigned char v1; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu17ll_BFu1i { unsigned char v1; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu17ll_BFu1ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu17ll_BFu1s { unsigned char v1; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu17ll_BFu31i { unsigned char v1; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu17ll_BFu31ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu17ll_BFu32i { unsigned char v1; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu17ll_BFu32ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu17ll_BFu33 { unsigned char v1; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu17ll_BFu7c { unsigned char v1; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu17ll_BFu7i { unsigned char v1; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu17ll_BFu7ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu17ll_BFu7s { unsigned char v1; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu17ll_BFu8c { unsigned char v1; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu17ll_BFu8i { unsigned char v1; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu17ll_BFu8ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu17ll_BFu8s { unsigned char v1; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu17ll_BFu9i { unsigned char v1; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu17ll_BFu9ll { unsigned char v1; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu17ll_BFu9s { unsigned char v1; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu17ll_C { unsigned char v1; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aUc_BFu17ll_D { unsigned char v1; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aUc_BFu17ll_F { unsigned char v1; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aUc_BFu17ll_I { unsigned char v1; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aUc_BFu17ll_Ip { unsigned char v1; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aUc_BFu17ll_L { unsigned char v1; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aUc_BFu17ll_S { unsigned char v1; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aUc_BFu17ll_Uc { unsigned char v1; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu17ll_Ui { unsigned char v1; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu17ll_Ul { unsigned char v1; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu17ll_Us { unsigned char v1; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu17ll_Vp { unsigned char v1; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aUc_BFu1c { unsigned char v1; unsigned char v2:1; };
struct __attribute__((packed)) aUc_BFu1c_BFu15i { unsigned char v1; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu1c_BFu15ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu1c_BFu15s { unsigned char v1; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu1c_BFu16i { unsigned char v1; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu1c_BFu16ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu1c_BFu16s { unsigned char v1; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu1c_BFu17i { unsigned char v1; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu1c_BFu17ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu1c_BFu1c { unsigned char v1; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu1c_BFu1i { unsigned char v1; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu1c_BFu1ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu1c_BFu1s { unsigned char v1; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu1c_BFu31i { unsigned char v1; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu1c_BFu31ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu1c_BFu32i { unsigned char v1; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu1c_BFu32ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu1c_BFu33 { unsigned char v1; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu1c_BFu7c { unsigned char v1; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu1c_BFu7i { unsigned char v1; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu1c_BFu7ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu1c_BFu7s { unsigned char v1; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu1c_BFu8c { unsigned char v1; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu1c_BFu8i { unsigned char v1; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu1c_BFu8ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu1c_BFu8s { unsigned char v1; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu1c_BFu9i { unsigned char v1; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu1c_BFu9ll { unsigned char v1; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu1c_BFu9s { unsigned char v1; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu1c_C { unsigned char v1; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aUc_BFu1c_D { unsigned char v1; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aUc_BFu1c_F { unsigned char v1; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aUc_BFu1c_I { unsigned char v1; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aUc_BFu1c_Ip { unsigned char v1; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aUc_BFu1c_L { unsigned char v1; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aUc_BFu1c_S { unsigned char v1; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aUc_BFu1c_Uc { unsigned char v1; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu1c_Ui { unsigned char v1; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu1c_Ul { unsigned char v1; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu1c_Us { unsigned char v1; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu1c_Vp { unsigned char v1; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aUc_BFu1i { unsigned char v1; unsigned int v2:1; };
struct __attribute__((packed)) aUc_BFu1i_BFu15i { unsigned char v1; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu1i_BFu15ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu1i_BFu15s { unsigned char v1; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu1i_BFu16i { unsigned char v1; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu1i_BFu16ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu1i_BFu16s { unsigned char v1; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu1i_BFu17i { unsigned char v1; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu1i_BFu17ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu1i_BFu1c { unsigned char v1; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu1i_BFu1i { unsigned char v1; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu1i_BFu1ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu1i_BFu1s { unsigned char v1; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu1i_BFu31i { unsigned char v1; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu1i_BFu31ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu1i_BFu32i { unsigned char v1; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu1i_BFu32ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu1i_BFu33 { unsigned char v1; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu1i_BFu7c { unsigned char v1; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu1i_BFu7i { unsigned char v1; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu1i_BFu7ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu1i_BFu7s { unsigned char v1; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu1i_BFu8c { unsigned char v1; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu1i_BFu8i { unsigned char v1; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu1i_BFu8ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu1i_BFu8s { unsigned char v1; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu1i_BFu9i { unsigned char v1; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu1i_BFu9ll { unsigned char v1; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu1i_BFu9s { unsigned char v1; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu1i_C { unsigned char v1; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aUc_BFu1i_D { unsigned char v1; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aUc_BFu1i_F { unsigned char v1; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aUc_BFu1i_I { unsigned char v1; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aUc_BFu1i_Ip { unsigned char v1; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aUc_BFu1i_L { unsigned char v1; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aUc_BFu1i_S { unsigned char v1; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aUc_BFu1i_Uc { unsigned char v1; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu1i_Ui { unsigned char v1; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu1i_Ul { unsigned char v1; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu1i_Us { unsigned char v1; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu1i_Vp { unsigned char v1; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aUc_BFu1ll { unsigned char v1; unsigned long long v2:1; };
struct __attribute__((packed)) aUc_BFu1ll_BFu15i { unsigned char v1; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu1ll_BFu15ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu1ll_BFu15s { unsigned char v1; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu1ll_BFu16i { unsigned char v1; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu1ll_BFu16ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu1ll_BFu16s { unsigned char v1; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu1ll_BFu17i { unsigned char v1; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu1ll_BFu17ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu1ll_BFu1c { unsigned char v1; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu1ll_BFu1i { unsigned char v1; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu1ll_BFu1ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu1ll_BFu1s { unsigned char v1; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu1ll_BFu31i { unsigned char v1; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu1ll_BFu31ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu1ll_BFu32i { unsigned char v1; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu1ll_BFu32ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu1ll_BFu33 { unsigned char v1; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu1ll_BFu7c { unsigned char v1; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu1ll_BFu7i { unsigned char v1; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu1ll_BFu7ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu1ll_BFu7s { unsigned char v1; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu1ll_BFu8c { unsigned char v1; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu1ll_BFu8i { unsigned char v1; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu1ll_BFu8ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu1ll_BFu8s { unsigned char v1; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu1ll_BFu9i { unsigned char v1; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu1ll_BFu9ll { unsigned char v1; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu1ll_BFu9s { unsigned char v1; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu1ll_C { unsigned char v1; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aUc_BFu1ll_D { unsigned char v1; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aUc_BFu1ll_F { unsigned char v1; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aUc_BFu1ll_I { unsigned char v1; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aUc_BFu1ll_Ip { unsigned char v1; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aUc_BFu1ll_L { unsigned char v1; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aUc_BFu1ll_S { unsigned char v1; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aUc_BFu1ll_Uc { unsigned char v1; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu1ll_Ui { unsigned char v1; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu1ll_Ul { unsigned char v1; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu1ll_Us { unsigned char v1; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu1ll_Vp { unsigned char v1; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aUc_BFu1s { unsigned char v1; unsigned short v2:1; };
struct __attribute__((packed)) aUc_BFu1s_BFu15i { unsigned char v1; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu1s_BFu15ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu1s_BFu15s { unsigned char v1; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu1s_BFu16i { unsigned char v1; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu1s_BFu16ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu1s_BFu16s { unsigned char v1; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu1s_BFu17i { unsigned char v1; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu1s_BFu17ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu1s_BFu1c { unsigned char v1; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu1s_BFu1i { unsigned char v1; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu1s_BFu1ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu1s_BFu1s { unsigned char v1; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu1s_BFu31i { unsigned char v1; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu1s_BFu31ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu1s_BFu32i { unsigned char v1; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu1s_BFu32ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu1s_BFu33 { unsigned char v1; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu1s_BFu7c { unsigned char v1; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu1s_BFu7i { unsigned char v1; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu1s_BFu7ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu1s_BFu7s { unsigned char v1; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu1s_BFu8c { unsigned char v1; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu1s_BFu8i { unsigned char v1; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu1s_BFu8ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu1s_BFu8s { unsigned char v1; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu1s_BFu9i { unsigned char v1; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu1s_BFu9ll { unsigned char v1; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu1s_BFu9s { unsigned char v1; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu1s_C { unsigned char v1; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aUc_BFu1s_D { unsigned char v1; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aUc_BFu1s_F { unsigned char v1; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aUc_BFu1s_I { unsigned char v1; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aUc_BFu1s_Ip { unsigned char v1; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aUc_BFu1s_L { unsigned char v1; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aUc_BFu1s_S { unsigned char v1; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aUc_BFu1s_Uc { unsigned char v1; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu1s_Ui { unsigned char v1; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu1s_Ul { unsigned char v1; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu1s_Us { unsigned char v1; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu1s_Vp { unsigned char v1; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aUc_BFu31i { unsigned char v1; unsigned int v2:31; };
struct __attribute__((packed)) aUc_BFu31i_BFu15i { unsigned char v1; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu31i_BFu15ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu31i_BFu15s { unsigned char v1; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu31i_BFu16i { unsigned char v1; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu31i_BFu16ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu31i_BFu16s { unsigned char v1; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu31i_BFu17i { unsigned char v1; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu31i_BFu17ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu31i_BFu1c { unsigned char v1; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu31i_BFu1i { unsigned char v1; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu31i_BFu1ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu31i_BFu1s { unsigned char v1; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu31i_BFu31i { unsigned char v1; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu31i_BFu31ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu31i_BFu32i { unsigned char v1; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu31i_BFu32ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu31i_BFu33 { unsigned char v1; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu31i_BFu7c { unsigned char v1; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu31i_BFu7i { unsigned char v1; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu31i_BFu7ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu31i_BFu7s { unsigned char v1; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu31i_BFu8c { unsigned char v1; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu31i_BFu8i { unsigned char v1; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu31i_BFu8ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu31i_BFu8s { unsigned char v1; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu31i_BFu9i { unsigned char v1; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu31i_BFu9ll { unsigned char v1; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu31i_BFu9s { unsigned char v1; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu31i_C { unsigned char v1; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aUc_BFu31i_D { unsigned char v1; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aUc_BFu31i_F { unsigned char v1; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aUc_BFu31i_I { unsigned char v1; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aUc_BFu31i_Ip { unsigned char v1; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aUc_BFu31i_L { unsigned char v1; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aUc_BFu31i_S { unsigned char v1; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aUc_BFu31i_Uc { unsigned char v1; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu31i_Ui { unsigned char v1; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu31i_Ul { unsigned char v1; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu31i_Us { unsigned char v1; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu31i_Vp { unsigned char v1; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aUc_BFu31ll { unsigned char v1; unsigned long long v2:31; };
struct __attribute__((packed)) aUc_BFu31ll_BFu15i { unsigned char v1; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu31ll_BFu15ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu31ll_BFu15s { unsigned char v1; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu31ll_BFu16i { unsigned char v1; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu31ll_BFu16ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu31ll_BFu16s { unsigned char v1; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu31ll_BFu17i { unsigned char v1; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu31ll_BFu17ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu31ll_BFu1c { unsigned char v1; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu31ll_BFu1i { unsigned char v1; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu31ll_BFu1ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu31ll_BFu1s { unsigned char v1; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu31ll_BFu31i { unsigned char v1; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu31ll_BFu31ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu31ll_BFu32i { unsigned char v1; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu31ll_BFu32ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu31ll_BFu33 { unsigned char v1; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu31ll_BFu7c { unsigned char v1; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu31ll_BFu7i { unsigned char v1; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu31ll_BFu7ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu31ll_BFu7s { unsigned char v1; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu31ll_BFu8c { unsigned char v1; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu31ll_BFu8i { unsigned char v1; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu31ll_BFu8ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu31ll_BFu8s { unsigned char v1; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu31ll_BFu9i { unsigned char v1; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu31ll_BFu9ll { unsigned char v1; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu31ll_BFu9s { unsigned char v1; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu31ll_C { unsigned char v1; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aUc_BFu31ll_D { unsigned char v1; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aUc_BFu31ll_F { unsigned char v1; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aUc_BFu31ll_I { unsigned char v1; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aUc_BFu31ll_Ip { unsigned char v1; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aUc_BFu31ll_L { unsigned char v1; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aUc_BFu31ll_S { unsigned char v1; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aUc_BFu31ll_Uc { unsigned char v1; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu31ll_Ui { unsigned char v1; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu31ll_Ul { unsigned char v1; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu31ll_Us { unsigned char v1; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu31ll_Vp { unsigned char v1; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aUc_BFu32i { unsigned char v1; unsigned int v2:32; };
struct __attribute__((packed)) aUc_BFu32i_BFu15i { unsigned char v1; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu32i_BFu15ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu32i_BFu15s { unsigned char v1; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu32i_BFu16i { unsigned char v1; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu32i_BFu16ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu32i_BFu16s { unsigned char v1; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu32i_BFu17i { unsigned char v1; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu32i_BFu17ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu32i_BFu1c { unsigned char v1; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu32i_BFu1i { unsigned char v1; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu32i_BFu1ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu32i_BFu1s { unsigned char v1; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu32i_BFu31i { unsigned char v1; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu32i_BFu31ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu32i_BFu32i { unsigned char v1; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu32i_BFu32ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu32i_BFu33 { unsigned char v1; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu32i_BFu7c { unsigned char v1; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu32i_BFu7i { unsigned char v1; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu32i_BFu7ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu32i_BFu7s { unsigned char v1; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu32i_BFu8c { unsigned char v1; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu32i_BFu8i { unsigned char v1; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu32i_BFu8ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu32i_BFu8s { unsigned char v1; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu32i_BFu9i { unsigned char v1; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu32i_BFu9ll { unsigned char v1; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu32i_BFu9s { unsigned char v1; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu32i_C { unsigned char v1; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aUc_BFu32i_D { unsigned char v1; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aUc_BFu32i_F { unsigned char v1; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aUc_BFu32i_I { unsigned char v1; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aUc_BFu32i_Ip { unsigned char v1; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aUc_BFu32i_L { unsigned char v1; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aUc_BFu32i_S { unsigned char v1; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aUc_BFu32i_Uc { unsigned char v1; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu32i_Ui { unsigned char v1; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu32i_Ul { unsigned char v1; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu32i_Us { unsigned char v1; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu32i_Vp { unsigned char v1; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aUc_BFu32ll { unsigned char v1; unsigned long long v2:32; };
struct __attribute__((packed)) aUc_BFu32ll_BFu15i { unsigned char v1; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu32ll_BFu15ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu32ll_BFu15s { unsigned char v1; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu32ll_BFu16i { unsigned char v1; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu32ll_BFu16ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu32ll_BFu16s { unsigned char v1; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu32ll_BFu17i { unsigned char v1; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu32ll_BFu17ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu32ll_BFu1c { unsigned char v1; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu32ll_BFu1i { unsigned char v1; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu32ll_BFu1ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu32ll_BFu1s { unsigned char v1; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu32ll_BFu31i { unsigned char v1; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu32ll_BFu31ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu32ll_BFu32i { unsigned char v1; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu32ll_BFu32ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu32ll_BFu33 { unsigned char v1; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu32ll_BFu7c { unsigned char v1; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu32ll_BFu7i { unsigned char v1; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu32ll_BFu7ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu32ll_BFu7s { unsigned char v1; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu32ll_BFu8c { unsigned char v1; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu32ll_BFu8i { unsigned char v1; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu32ll_BFu8ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu32ll_BFu8s { unsigned char v1; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu32ll_BFu9i { unsigned char v1; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu32ll_BFu9ll { unsigned char v1; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu32ll_BFu9s { unsigned char v1; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu32ll_C { unsigned char v1; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aUc_BFu32ll_D { unsigned char v1; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aUc_BFu32ll_F { unsigned char v1; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aUc_BFu32ll_I { unsigned char v1; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aUc_BFu32ll_Ip { unsigned char v1; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aUc_BFu32ll_L { unsigned char v1; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aUc_BFu32ll_S { unsigned char v1; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aUc_BFu32ll_Uc { unsigned char v1; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu32ll_Ui { unsigned char v1; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu32ll_Ul { unsigned char v1; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu32ll_Us { unsigned char v1; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu32ll_Vp { unsigned char v1; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aUc_BFu33 { unsigned char v1; unsigned long long v2:33; };
struct __attribute__((packed)) aUc_BFu33_BFu15i { unsigned char v1; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu33_BFu15ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu33_BFu15s { unsigned char v1; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu33_BFu16i { unsigned char v1; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu33_BFu16ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu33_BFu16s { unsigned char v1; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu33_BFu17i { unsigned char v1; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu33_BFu17ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu33_BFu1c { unsigned char v1; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu33_BFu1i { unsigned char v1; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu33_BFu1ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu33_BFu1s { unsigned char v1; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu33_BFu31i { unsigned char v1; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu33_BFu31ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu33_BFu32i { unsigned char v1; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu33_BFu32ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu33_BFu33 { unsigned char v1; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu33_BFu7c { unsigned char v1; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu33_BFu7i { unsigned char v1; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu33_BFu7ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu33_BFu7s { unsigned char v1; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu33_BFu8c { unsigned char v1; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu33_BFu8i { unsigned char v1; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu33_BFu8ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu33_BFu8s { unsigned char v1; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu33_BFu9i { unsigned char v1; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu33_BFu9ll { unsigned char v1; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu33_BFu9s { unsigned char v1; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu33_C { unsigned char v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aUc_BFu33_D { unsigned char v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aUc_BFu33_F { unsigned char v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aUc_BFu33_I { unsigned char v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aUc_BFu33_Ip { unsigned char v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aUc_BFu33_L { unsigned char v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aUc_BFu33_S { unsigned char v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aUc_BFu33_Uc { unsigned char v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu33_Ui { unsigned char v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu33_Ul { unsigned char v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu33_Us { unsigned char v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu33_Vp { unsigned char v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aUc_BFu7c { unsigned char v1; unsigned char v2:7; };
struct __attribute__((packed)) aUc_BFu7c_BFu15i { unsigned char v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu7c_BFu15ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu7c_BFu15s { unsigned char v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu7c_BFu16i { unsigned char v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu7c_BFu16ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu7c_BFu16s { unsigned char v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu7c_BFu17i { unsigned char v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu7c_BFu17ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu7c_BFu1c { unsigned char v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu7c_BFu1i { unsigned char v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu7c_BFu1ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu7c_BFu1s { unsigned char v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu7c_BFu31i { unsigned char v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu7c_BFu31ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu7c_BFu32i { unsigned char v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu7c_BFu32ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu7c_BFu33 { unsigned char v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu7c_BFu7c { unsigned char v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu7c_BFu7i { unsigned char v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu7c_BFu7ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu7c_BFu7s { unsigned char v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu7c_BFu8c { unsigned char v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu7c_BFu8i { unsigned char v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu7c_BFu8ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu7c_BFu8s { unsigned char v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu7c_BFu9i { unsigned char v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu7c_BFu9ll { unsigned char v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu7c_BFu9s { unsigned char v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu7c_C { unsigned char v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aUc_BFu7c_D { unsigned char v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aUc_BFu7c_F { unsigned char v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aUc_BFu7c_I { unsigned char v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aUc_BFu7c_Ip { unsigned char v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aUc_BFu7c_L { unsigned char v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aUc_BFu7c_S { unsigned char v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aUc_BFu7c_Uc { unsigned char v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu7c_Ui { unsigned char v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu7c_Ul { unsigned char v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu7c_Us { unsigned char v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu7c_Vp { unsigned char v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aUc_BFu7i { unsigned char v1; unsigned int v2:7; };
struct __attribute__((packed)) aUc_BFu7i_BFu15i { unsigned char v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu7i_BFu15ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu7i_BFu15s { unsigned char v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu7i_BFu16i { unsigned char v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu7i_BFu16ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu7i_BFu16s { unsigned char v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu7i_BFu17i { unsigned char v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu7i_BFu17ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu7i_BFu1c { unsigned char v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu7i_BFu1i { unsigned char v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu7i_BFu1ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu7i_BFu1s { unsigned char v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu7i_BFu31i { unsigned char v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu7i_BFu31ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu7i_BFu32i { unsigned char v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu7i_BFu32ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu7i_BFu33 { unsigned char v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu7i_BFu7c { unsigned char v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu7i_BFu7i { unsigned char v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu7i_BFu7ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu7i_BFu7s { unsigned char v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu7i_BFu8c { unsigned char v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu7i_BFu8i { unsigned char v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu7i_BFu8ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu7i_BFu8s { unsigned char v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu7i_BFu9i { unsigned char v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu7i_BFu9ll { unsigned char v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu7i_BFu9s { unsigned char v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu7i_C { unsigned char v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aUc_BFu7i_D { unsigned char v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aUc_BFu7i_F { unsigned char v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aUc_BFu7i_I { unsigned char v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aUc_BFu7i_Ip { unsigned char v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aUc_BFu7i_L { unsigned char v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aUc_BFu7i_S { unsigned char v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aUc_BFu7i_Uc { unsigned char v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu7i_Ui { unsigned char v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu7i_Ul { unsigned char v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu7i_Us { unsigned char v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu7i_Vp { unsigned char v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aUc_BFu7ll { unsigned char v1; unsigned long long v2:7; };
struct __attribute__((packed)) aUc_BFu7ll_BFu15i { unsigned char v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu7ll_BFu15ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu7ll_BFu15s { unsigned char v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu7ll_BFu16i { unsigned char v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu7ll_BFu16ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu7ll_BFu16s { unsigned char v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu7ll_BFu17i { unsigned char v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu7ll_BFu17ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu7ll_BFu1c { unsigned char v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu7ll_BFu1i { unsigned char v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu7ll_BFu1ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu7ll_BFu1s { unsigned char v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu7ll_BFu31i { unsigned char v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu7ll_BFu31ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu7ll_BFu32i { unsigned char v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu7ll_BFu32ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu7ll_BFu33 { unsigned char v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu7ll_BFu7c { unsigned char v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu7ll_BFu7i { unsigned char v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu7ll_BFu7ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu7ll_BFu7s { unsigned char v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu7ll_BFu8c { unsigned char v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu7ll_BFu8i { unsigned char v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu7ll_BFu8ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu7ll_BFu8s { unsigned char v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu7ll_BFu9i { unsigned char v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu7ll_BFu9ll { unsigned char v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu7ll_BFu9s { unsigned char v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu7ll_C { unsigned char v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aUc_BFu7ll_D { unsigned char v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aUc_BFu7ll_F { unsigned char v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aUc_BFu7ll_I { unsigned char v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aUc_BFu7ll_Ip { unsigned char v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aUc_BFu7ll_L { unsigned char v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aUc_BFu7ll_S { unsigned char v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aUc_BFu7ll_Uc { unsigned char v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu7ll_Ui { unsigned char v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu7ll_Ul { unsigned char v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu7ll_Us { unsigned char v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu7ll_Vp { unsigned char v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aUc_BFu7s { unsigned char v1; unsigned short v2:7; };
struct __attribute__((packed)) aUc_BFu7s_BFu15i { unsigned char v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu7s_BFu15ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu7s_BFu15s { unsigned char v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu7s_BFu16i { unsigned char v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu7s_BFu16ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu7s_BFu16s { unsigned char v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu7s_BFu17i { unsigned char v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu7s_BFu17ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu7s_BFu1c { unsigned char v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu7s_BFu1i { unsigned char v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu7s_BFu1ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu7s_BFu1s { unsigned char v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu7s_BFu31i { unsigned char v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu7s_BFu31ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu7s_BFu32i { unsigned char v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu7s_BFu32ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu7s_BFu33 { unsigned char v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu7s_BFu7c { unsigned char v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu7s_BFu7i { unsigned char v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu7s_BFu7ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu7s_BFu7s { unsigned char v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu7s_BFu8c { unsigned char v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu7s_BFu8i { unsigned char v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu7s_BFu8ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu7s_BFu8s { unsigned char v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu7s_BFu9i { unsigned char v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu7s_BFu9ll { unsigned char v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu7s_BFu9s { unsigned char v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu7s_C { unsigned char v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aUc_BFu7s_D { unsigned char v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aUc_BFu7s_F { unsigned char v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aUc_BFu7s_I { unsigned char v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aUc_BFu7s_Ip { unsigned char v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aUc_BFu7s_L { unsigned char v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aUc_BFu7s_S { unsigned char v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aUc_BFu7s_Uc { unsigned char v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu7s_Ui { unsigned char v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu7s_Ul { unsigned char v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu7s_Us { unsigned char v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu7s_Vp { unsigned char v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aUc_BFu8c { unsigned char v1; unsigned char v2:8; };
struct __attribute__((packed)) aUc_BFu8c_BFu15i { unsigned char v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu8c_BFu15ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu8c_BFu15s { unsigned char v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu8c_BFu16i { unsigned char v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu8c_BFu16ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu8c_BFu16s { unsigned char v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu8c_BFu17i { unsigned char v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu8c_BFu17ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu8c_BFu1c { unsigned char v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu8c_BFu1i { unsigned char v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu8c_BFu1ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu8c_BFu1s { unsigned char v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu8c_BFu31i { unsigned char v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu8c_BFu31ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu8c_BFu32i { unsigned char v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu8c_BFu32ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu8c_BFu33 { unsigned char v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu8c_BFu7c { unsigned char v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu8c_BFu7i { unsigned char v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu8c_BFu7ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu8c_BFu7s { unsigned char v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu8c_BFu8c { unsigned char v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu8c_BFu8i { unsigned char v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu8c_BFu8ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu8c_BFu8s { unsigned char v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu8c_BFu9i { unsigned char v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu8c_BFu9ll { unsigned char v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu8c_BFu9s { unsigned char v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu8c_C { unsigned char v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aUc_BFu8c_D { unsigned char v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aUc_BFu8c_F { unsigned char v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aUc_BFu8c_I { unsigned char v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aUc_BFu8c_Ip { unsigned char v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aUc_BFu8c_L { unsigned char v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aUc_BFu8c_S { unsigned char v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aUc_BFu8c_Uc { unsigned char v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu8c_Ui { unsigned char v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu8c_Ul { unsigned char v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu8c_Us { unsigned char v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu8c_Vp { unsigned char v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aUc_BFu8i { unsigned char v1; unsigned int v2:8; };
struct __attribute__((packed)) aUc_BFu8i_BFu15i { unsigned char v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu8i_BFu15ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu8i_BFu15s { unsigned char v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu8i_BFu16i { unsigned char v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu8i_BFu16ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu8i_BFu16s { unsigned char v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu8i_BFu17i { unsigned char v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu8i_BFu17ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu8i_BFu1c { unsigned char v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu8i_BFu1i { unsigned char v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu8i_BFu1ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu8i_BFu1s { unsigned char v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu8i_BFu31i { unsigned char v1; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu8i_BFu31ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu8i_BFu32i { unsigned char v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu8i_BFu32ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu8i_BFu33 { unsigned char v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu8i_BFu7c { unsigned char v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu8i_BFu7i { unsigned char v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu8i_BFu7ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu8i_BFu7s { unsigned char v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu8i_BFu8c { unsigned char v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu8i_BFu8i { unsigned char v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu8i_BFu8ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu8i_BFu8s { unsigned char v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu8i_BFu9i { unsigned char v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu8i_BFu9ll { unsigned char v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu8i_BFu9s { unsigned char v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu8i_C { unsigned char v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aUc_BFu8i_D { unsigned char v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aUc_BFu8i_F { unsigned char v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aUc_BFu8i_I { unsigned char v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aUc_BFu8i_Ip { unsigned char v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aUc_BFu8i_L { unsigned char v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aUc_BFu8i_S { unsigned char v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aUc_BFu8i_Uc { unsigned char v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu8i_Ui { unsigned char v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu8i_Ul { unsigned char v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu8i_Us { unsigned char v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu8i_Vp { unsigned char v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aUc_BFu8ll { unsigned char v1; unsigned long long v2:8; };
struct __attribute__((packed)) aUc_BFu8ll_BFu15i { unsigned char v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu8ll_BFu15ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu8ll_BFu15s { unsigned char v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu8ll_BFu16i { unsigned char v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu8ll_BFu16ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu8ll_BFu16s { unsigned char v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu8ll_BFu17i { unsigned char v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu8ll_BFu17ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu8ll_BFu1c { unsigned char v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu8ll_BFu1i { unsigned char v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu8ll_BFu1ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu8ll_BFu1s { unsigned char v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu8ll_BFu31i { unsigned char v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu8ll_BFu31ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu8ll_BFu32i { unsigned char v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu8ll_BFu32ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu8ll_BFu33 { unsigned char v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu8ll_BFu7c { unsigned char v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu8ll_BFu7i { unsigned char v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu8ll_BFu7ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu8ll_BFu7s { unsigned char v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu8ll_BFu8c { unsigned char v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu8ll_BFu8i { unsigned char v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu8ll_BFu8ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu8ll_BFu8s { unsigned char v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu8ll_BFu9i { unsigned char v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu8ll_BFu9ll { unsigned char v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu8ll_BFu9s { unsigned char v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu8ll_C { unsigned char v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aUc_BFu8ll_D { unsigned char v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aUc_BFu8ll_F { unsigned char v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aUc_BFu8ll_I { unsigned char v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aUc_BFu8ll_Ip { unsigned char v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aUc_BFu8ll_L { unsigned char v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aUc_BFu8ll_S { unsigned char v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aUc_BFu8ll_Uc { unsigned char v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu8ll_Ui { unsigned char v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu8ll_Ul { unsigned char v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu8ll_Us { unsigned char v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu8ll_Vp { unsigned char v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aUc_BFu8s { unsigned char v1; unsigned short v2:8; };
struct __attribute__((packed)) aUc_BFu8s_BFu15i { unsigned char v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu8s_BFu15ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu8s_BFu15s { unsigned char v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu8s_BFu16i { unsigned char v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu8s_BFu16ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu8s_BFu16s { unsigned char v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu8s_BFu17i { unsigned char v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu8s_BFu17ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu8s_BFu1c { unsigned char v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu8s_BFu1i { unsigned char v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu8s_BFu1ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu8s_BFu1s { unsigned char v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu8s_BFu31i { unsigned char v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu8s_BFu31ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu8s_BFu32i { unsigned char v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu8s_BFu32ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu8s_BFu33 { unsigned char v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu8s_BFu7c { unsigned char v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu8s_BFu7i { unsigned char v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu8s_BFu7ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu8s_BFu7s { unsigned char v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu8s_BFu8c { unsigned char v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu8s_BFu8i { unsigned char v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu8s_BFu8ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu8s_BFu8s { unsigned char v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu8s_BFu9i { unsigned char v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu8s_BFu9ll { unsigned char v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu8s_BFu9s { unsigned char v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu8s_C { unsigned char v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aUc_BFu8s_D { unsigned char v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aUc_BFu8s_F { unsigned char v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aUc_BFu8s_I { unsigned char v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aUc_BFu8s_Ip { unsigned char v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aUc_BFu8s_L { unsigned char v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aUc_BFu8s_S { unsigned char v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aUc_BFu8s_Uc { unsigned char v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu8s_Ui { unsigned char v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu8s_Ul { unsigned char v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu8s_Us { unsigned char v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu8s_Vp { unsigned char v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aUc_BFu9i { unsigned char v1; unsigned int v2:9; };
struct __attribute__((packed)) aUc_BFu9i_BFu15i { unsigned char v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu9i_BFu15ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu9i_BFu15s { unsigned char v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu9i_BFu16i { unsigned char v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu9i_BFu16ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu9i_BFu16s { unsigned char v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu9i_BFu17i { unsigned char v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu9i_BFu17ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu9i_BFu1c { unsigned char v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu9i_BFu1i { unsigned char v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu9i_BFu1ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu9i_BFu1s { unsigned char v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu9i_BFu31i { unsigned char v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu9i_BFu31ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu9i_BFu32i { unsigned char v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu9i_BFu32ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu9i_BFu33 { unsigned char v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu9i_BFu7c { unsigned char v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu9i_BFu7i { unsigned char v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu9i_BFu7ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu9i_BFu7s { unsigned char v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu9i_BFu8c { unsigned char v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu9i_BFu8i { unsigned char v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu9i_BFu8ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu9i_BFu8s { unsigned char v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu9i_BFu9i { unsigned char v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu9i_BFu9ll { unsigned char v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu9i_BFu9s { unsigned char v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu9i_C { unsigned char v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aUc_BFu9i_D { unsigned char v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aUc_BFu9i_F { unsigned char v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aUc_BFu9i_I { unsigned char v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aUc_BFu9i_Ip { unsigned char v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aUc_BFu9i_L { unsigned char v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aUc_BFu9i_S { unsigned char v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aUc_BFu9i_Uc { unsigned char v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu9i_Ui { unsigned char v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu9i_Ul { unsigned char v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu9i_Us { unsigned char v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu9i_Vp { unsigned char v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aUc_BFu9ll { unsigned char v1; unsigned long long v2:9; };
struct __attribute__((packed)) aUc_BFu9ll_BFu15i { unsigned char v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu9ll_BFu15ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu9ll_BFu15s { unsigned char v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu9ll_BFu16i { unsigned char v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu9ll_BFu16ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu9ll_BFu16s { unsigned char v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu9ll_BFu17i { unsigned char v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu9ll_BFu17ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu9ll_BFu1c { unsigned char v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu9ll_BFu1i { unsigned char v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu9ll_BFu1ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu9ll_BFu1s { unsigned char v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu9ll_BFu31i { unsigned char v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu9ll_BFu31ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu9ll_BFu32i { unsigned char v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu9ll_BFu32ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu9ll_BFu33 { unsigned char v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu9ll_BFu7c { unsigned char v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu9ll_BFu7i { unsigned char v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu9ll_BFu7ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu9ll_BFu7s { unsigned char v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu9ll_BFu8c { unsigned char v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu9ll_BFu8i { unsigned char v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu9ll_BFu8ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu9ll_BFu8s { unsigned char v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu9ll_BFu9i { unsigned char v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu9ll_BFu9ll { unsigned char v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu9ll_BFu9s { unsigned char v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu9ll_C { unsigned char v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aUc_BFu9ll_D { unsigned char v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aUc_BFu9ll_F { unsigned char v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aUc_BFu9ll_I { unsigned char v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aUc_BFu9ll_Ip { unsigned char v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aUc_BFu9ll_L { unsigned char v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aUc_BFu9ll_S { unsigned char v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aUc_BFu9ll_Uc { unsigned char v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu9ll_Ui { unsigned char v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu9ll_Ul { unsigned char v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu9ll_Us { unsigned char v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu9ll_Vp { unsigned char v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aUc_BFu9s { unsigned char v1; unsigned short v2:9; };
struct __attribute__((packed)) aUc_BFu9s_BFu15i { unsigned char v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aUc_BFu9s_BFu15ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_BFu9s_BFu15s { unsigned char v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aUc_BFu9s_BFu16i { unsigned char v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aUc_BFu9s_BFu16ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_BFu9s_BFu16s { unsigned char v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aUc_BFu9s_BFu17i { unsigned char v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aUc_BFu9s_BFu17ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_BFu9s_BFu1c { unsigned char v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aUc_BFu9s_BFu1i { unsigned char v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aUc_BFu9s_BFu1ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_BFu9s_BFu1s { unsigned char v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aUc_BFu9s_BFu31i { unsigned char v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aUc_BFu9s_BFu31ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_BFu9s_BFu32i { unsigned char v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aUc_BFu9s_BFu32ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_BFu9s_BFu33 { unsigned char v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_BFu9s_BFu7c { unsigned char v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aUc_BFu9s_BFu7i { unsigned char v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aUc_BFu9s_BFu7ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_BFu9s_BFu7s { unsigned char v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aUc_BFu9s_BFu8c { unsigned char v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aUc_BFu9s_BFu8i { unsigned char v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aUc_BFu9s_BFu8ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_BFu9s_BFu8s { unsigned char v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aUc_BFu9s_BFu9i { unsigned char v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aUc_BFu9s_BFu9ll { unsigned char v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_BFu9s_BFu9s { unsigned char v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aUc_BFu9s_C { unsigned char v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aUc_BFu9s_D { unsigned char v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aUc_BFu9s_F { unsigned char v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aUc_BFu9s_I { unsigned char v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aUc_BFu9s_Ip { unsigned char v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aUc_BFu9s_L { unsigned char v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aUc_BFu9s_S { unsigned char v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aUc_BFu9s_Uc { unsigned char v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aUc_BFu9s_Ui { unsigned char v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aUc_BFu9s_Ul { unsigned char v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aUc_BFu9s_Us { unsigned char v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aUc_BFu9s_Vp { unsigned char v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aUc_C { unsigned char v1; char v2; };
struct __attribute__((packed)) aUc_C_BFu15i { unsigned char v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_C_BFu15ll { unsigned char v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_C_BFu15s { unsigned char v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_C_BFu16i { unsigned char v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_C_BFu16ll { unsigned char v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_C_BFu16s { unsigned char v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_C_BFu17i { unsigned char v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_C_BFu17ll { unsigned char v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aUc_C_BFu1c { unsigned char v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aUc_C_BFu1i { unsigned char v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aUc_C_BFu1ll { unsigned char v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aUc_C_BFu1s { unsigned char v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aUc_C_BFu31i { unsigned char v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aUc_C_BFu31ll { unsigned char v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aUc_C_BFu32i { unsigned char v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aUc_C_BFu32ll { unsigned char v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aUc_C_BFu33 { unsigned char v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aUc_C_BFu7c { unsigned char v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aUc_C_BFu7i { unsigned char v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aUc_C_BFu7ll { unsigned char v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aUc_C_BFu7s { unsigned char v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aUc_C_BFu8c { unsigned char v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aUc_C_BFu8i { unsigned char v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aUc_C_BFu8ll { unsigned char v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aUc_C_BFu8s { unsigned char v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aUc_C_BFu9i { unsigned char v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aUc_C_BFu9ll { unsigned char v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aUc_C_BFu9s { unsigned char v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aUc_C_C { unsigned char v1; char v2; char v3; };
struct __attribute__((packed)) aUc_C_D { unsigned char v1; char v2; double v3; };
struct __attribute__((packed)) aUc_C_F { unsigned char v1; char v2; float v3; };
struct __attribute__((packed)) aUc_C_I { unsigned char v1; char v2; int v3; };
struct __attribute__((packed)) aUc_C_Ip { unsigned char v1; char v2; int * v3; };
struct __attribute__((packed)) aUc_C_L { unsigned char v1; char v2; long long v3; };
struct __attribute__((packed)) aUc_C_S { unsigned char v1; char v2; short v3; };
struct __attribute__((packed)) aUc_C_Uc { unsigned char v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aUc_C_Ui { unsigned char v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aUc_C_Ul { unsigned char v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aUc_C_Us { unsigned char v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aUc_C_Vp { unsigned char v1; char v2; void * v3; };
struct __attribute__((packed)) aUc_D { unsigned char v1; double v2; };
struct __attribute__((packed)) aUc_D_BFu15i { unsigned char v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aUc_D_BFu15ll { unsigned char v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aUc_D_BFu15s { unsigned char v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aUc_D_BFu16i { unsigned char v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aUc_D_BFu16ll { unsigned char v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aUc_D_BFu16s { unsigned char v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aUc_D_BFu17i { unsigned char v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aUc_D_BFu17ll { unsigned char v1; double v2; unsigned long long v3:17; };


static void Test_aL_Ui_BFu16i()
{
  {
    init_simple_test("aL_Ui_BFu16i");
    static STRUCT_IF_C aL_Ui_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(aL_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aL_Ui_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aL_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu16i, aL_Ui_BFu16i)
//============================================================================



static void Test_aL_Ui_BFu16ll()
{
  {
    init_simple_test("aL_Ui_BFu16ll");
    static STRUCT_IF_C aL_Ui_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(aL_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aL_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aL_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu16ll, aL_Ui_BFu16ll)
//============================================================================



static void Test_aL_Ui_BFu16s()
{
  {
    init_simple_test("aL_Ui_BFu16s");
    static STRUCT_IF_C aL_Ui_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(aL_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aL_Ui_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aL_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu16s, aL_Ui_BFu16s)
//============================================================================



static void Test_aL_Ui_BFu17i()
{
  {
    init_simple_test("aL_Ui_BFu17i");
    static STRUCT_IF_C aL_Ui_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(aL_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aL_Ui_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aL_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu17i, aL_Ui_BFu17i)
//============================================================================



static void Test_aL_Ui_BFu17ll()
{
  {
    init_simple_test("aL_Ui_BFu17ll");
    static STRUCT_IF_C aL_Ui_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(aL_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aL_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aL_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu17ll, aL_Ui_BFu17ll)
//============================================================================



static void Test_aL_Ui_BFu1c()
{
  {
    init_simple_test("aL_Ui_BFu1c");
    static STRUCT_IF_C aL_Ui_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aL_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu1c, aL_Ui_BFu1c)
//============================================================================



static void Test_aL_Ui_BFu1i()
{
  {
    init_simple_test("aL_Ui_BFu1i");
    static STRUCT_IF_C aL_Ui_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aL_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu1i, aL_Ui_BFu1i)
//============================================================================



static void Test_aL_Ui_BFu1ll()
{
  {
    init_simple_test("aL_Ui_BFu1ll");
    static STRUCT_IF_C aL_Ui_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aL_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu1ll, aL_Ui_BFu1ll)
//============================================================================



static void Test_aL_Ui_BFu1s()
{
  {
    init_simple_test("aL_Ui_BFu1s");
    static STRUCT_IF_C aL_Ui_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aL_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu1s, aL_Ui_BFu1s)
//============================================================================



static void Test_aL_Ui_BFu31i()
{
  {
    init_simple_test("aL_Ui_BFu31i");
    static STRUCT_IF_C aL_Ui_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(aL_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aL_Ui_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aL_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu31i, aL_Ui_BFu31i)
//============================================================================



static void Test_aL_Ui_BFu31ll()
{
  {
    init_simple_test("aL_Ui_BFu31ll");
    static STRUCT_IF_C aL_Ui_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(aL_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aL_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aL_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu31ll, aL_Ui_BFu31ll)
//============================================================================



static void Test_aL_Ui_BFu32i()
{
  {
    init_simple_test("aL_Ui_BFu32i");
    static STRUCT_IF_C aL_Ui_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(aL_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aL_Ui_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aL_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu32i, aL_Ui_BFu32i)
//============================================================================



static void Test_aL_Ui_BFu32ll()
{
  {
    init_simple_test("aL_Ui_BFu32ll");
    static STRUCT_IF_C aL_Ui_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(aL_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aL_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aL_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu32ll, aL_Ui_BFu32ll)
//============================================================================



static void Test_aL_Ui_BFu33()
{
  {
    init_simple_test("aL_Ui_BFu33");
    static STRUCT_IF_C aL_Ui_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu33.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "aL_Ui_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "aL_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu33, aL_Ui_BFu33)
//============================================================================



static void Test_aL_Ui_BFu7c()
{
  {
    init_simple_test("aL_Ui_BFu7c");
    static STRUCT_IF_C aL_Ui_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aL_Ui_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aL_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu7c, aL_Ui_BFu7c)
//============================================================================



static void Test_aL_Ui_BFu7i()
{
  {
    init_simple_test("aL_Ui_BFu7i");
    static STRUCT_IF_C aL_Ui_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aL_Ui_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aL_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu7i, aL_Ui_BFu7i)
//============================================================================



static void Test_aL_Ui_BFu7ll()
{
  {
    init_simple_test("aL_Ui_BFu7ll");
    static STRUCT_IF_C aL_Ui_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aL_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aL_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu7ll, aL_Ui_BFu7ll)
//============================================================================



static void Test_aL_Ui_BFu7s()
{
  {
    init_simple_test("aL_Ui_BFu7s");
    static STRUCT_IF_C aL_Ui_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aL_Ui_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aL_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu7s, aL_Ui_BFu7s)
//============================================================================



static void Test_aL_Ui_BFu8c()
{
  {
    init_simple_test("aL_Ui_BFu8c");
    static STRUCT_IF_C aL_Ui_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aL_Ui_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aL_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu8c, aL_Ui_BFu8c)
//============================================================================



static void Test_aL_Ui_BFu8i()
{
  {
    init_simple_test("aL_Ui_BFu8i");
    static STRUCT_IF_C aL_Ui_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aL_Ui_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aL_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu8i, aL_Ui_BFu8i)
//============================================================================



static void Test_aL_Ui_BFu8ll()
{
  {
    init_simple_test("aL_Ui_BFu8ll");
    static STRUCT_IF_C aL_Ui_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aL_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aL_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu8ll, aL_Ui_BFu8ll)
//============================================================================



static void Test_aL_Ui_BFu8s()
{
  {
    init_simple_test("aL_Ui_BFu8s");
    static STRUCT_IF_C aL_Ui_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aL_Ui_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aL_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu8s, aL_Ui_BFu8s)
//============================================================================



static void Test_aL_Ui_BFu9i()
{
  {
    init_simple_test("aL_Ui_BFu9i");
    static STRUCT_IF_C aL_Ui_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(aL_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aL_Ui_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aL_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu9i, aL_Ui_BFu9i)
//============================================================================



static void Test_aL_Ui_BFu9ll()
{
  {
    init_simple_test("aL_Ui_BFu9ll");
    static STRUCT_IF_C aL_Ui_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(aL_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aL_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aL_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu9ll, aL_Ui_BFu9ll)
//============================================================================



static void Test_aL_Ui_BFu9s()
{
  {
    init_simple_test("aL_Ui_BFu9s");
    static STRUCT_IF_C aL_Ui_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(aL_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "aL_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aL_Ui_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aL_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_BFu9s, aL_Ui_BFu9s)
//============================================================================



static void Test_aL_Ui_C()
{
  {
    init_simple_test("aL_Ui_C");
    STRUCT_IF_C aL_Ui_C lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_C)");
    check_field_offset(lv, v1, 0, "aL_Ui_C.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_C.v2");
    check_field_offset(lv, v3, 12, "aL_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_C, aL_Ui_C)
//============================================================================



static void Test_aL_Ui_D()
{
  {
    init_simple_test("aL_Ui_D");
    STRUCT_IF_C aL_Ui_D lv;
    check2(sizeof(lv), 20, "sizeof(aL_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_D)");
    check_field_offset(lv, v1, 0, "aL_Ui_D.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_D.v2");
    check_field_offset(lv, v3, 12, "aL_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_D, aL_Ui_D)
//============================================================================



static void Test_aL_Ui_F()
{
  {
    init_simple_test("aL_Ui_F");
    STRUCT_IF_C aL_Ui_F lv;
    check2(sizeof(lv), 16, "sizeof(aL_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_F)");
    check_field_offset(lv, v1, 0, "aL_Ui_F.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_F.v2");
    check_field_offset(lv, v3, 12, "aL_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_F, aL_Ui_F)
//============================================================================



static void Test_aL_Ui_I()
{
  {
    init_simple_test("aL_Ui_I");
    STRUCT_IF_C aL_Ui_I lv;
    check2(sizeof(lv), 16, "sizeof(aL_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_I)");
    check_field_offset(lv, v1, 0, "aL_Ui_I.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_I.v2");
    check_field_offset(lv, v3, 12, "aL_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_I, aL_Ui_I)
//============================================================================



static void Test_aL_Ui_Ip()
{
  {
    init_simple_test("aL_Ui_Ip");
    STRUCT_IF_C aL_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aL_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_Ip)");
    check_field_offset(lv, v1, 0, "aL_Ui_Ip.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_Ip.v2");
    check_field_offset(lv, v3, 12, "aL_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_Ip, aL_Ui_Ip)
//============================================================================



static void Test_aL_Ui_L()
{
  {
    init_simple_test("aL_Ui_L");
    STRUCT_IF_C aL_Ui_L lv;
    check2(sizeof(lv), 20, "sizeof(aL_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_L)");
    check_field_offset(lv, v1, 0, "aL_Ui_L.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_L.v2");
    check_field_offset(lv, v3, 12, "aL_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_L, aL_Ui_L)
//============================================================================



static void Test_aL_Ui_S()
{
  {
    init_simple_test("aL_Ui_S");
    STRUCT_IF_C aL_Ui_S lv;
    check2(sizeof(lv), 14, "sizeof(aL_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_S)");
    check_field_offset(lv, v1, 0, "aL_Ui_S.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_S.v2");
    check_field_offset(lv, v3, 12, "aL_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_S, aL_Ui_S)
//============================================================================



static void Test_aL_Ui_Uc()
{
  {
    init_simple_test("aL_Ui_Uc");
    STRUCT_IF_C aL_Ui_Uc lv;
    check2(sizeof(lv), 13, "sizeof(aL_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_Uc)");
    check_field_offset(lv, v1, 0, "aL_Ui_Uc.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_Uc.v2");
    check_field_offset(lv, v3, 12, "aL_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_Uc, aL_Ui_Uc)
//============================================================================



static void Test_aL_Ui_Ui()
{
  {
    init_simple_test("aL_Ui_Ui");
    STRUCT_IF_C aL_Ui_Ui lv;
    check2(sizeof(lv), 16, "sizeof(aL_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_Ui)");
    check_field_offset(lv, v1, 0, "aL_Ui_Ui.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_Ui.v2");
    check_field_offset(lv, v3, 12, "aL_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_Ui, aL_Ui_Ui)
//============================================================================



static void Test_aL_Ui_Ul()
{
  {
    init_simple_test("aL_Ui_Ul");
    STRUCT_IF_C aL_Ui_Ul lv;
    check2(sizeof(lv), 20, "sizeof(aL_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_Ul)");
    check_field_offset(lv, v1, 0, "aL_Ui_Ul.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_Ul.v2");
    check_field_offset(lv, v3, 12, "aL_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_Ul, aL_Ui_Ul)
//============================================================================



static void Test_aL_Ui_Us()
{
  {
    init_simple_test("aL_Ui_Us");
    STRUCT_IF_C aL_Ui_Us lv;
    check2(sizeof(lv), 14, "sizeof(aL_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_Us)");
    check_field_offset(lv, v1, 0, "aL_Ui_Us.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_Us.v2");
    check_field_offset(lv, v3, 12, "aL_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_Us, aL_Ui_Us)
//============================================================================



static void Test_aL_Ui_Vp()
{
  {
    init_simple_test("aL_Ui_Vp");
    STRUCT_IF_C aL_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aL_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ui_Vp)");
    check_field_offset(lv, v1, 0, "aL_Ui_Vp.v1");
    check_field_offset(lv, v2, 8, "aL_Ui_Vp.v2");
    check_field_offset(lv, v3, 12, "aL_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ui_Vp, aL_Ui_Vp)
//============================================================================



static void Test_aL_Ul()
{
  {
    init_simple_test("aL_Ul");
    STRUCT_IF_C aL_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aL_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul)");
    check_field_offset(lv, v1, 0, "aL_Ul.v1");
    check_field_offset(lv, v2, 8, "aL_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul, aL_Ul)
//============================================================================



static void Test_aL_Ul_BFu15i()
{
  {
    init_simple_test("aL_Ul_BFu15i");
    static STRUCT_IF_C aL_Ul_BFu15i lv;
    check2(sizeof(lv), 18, "sizeof(aL_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "aL_Ul_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "aL_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu15i, aL_Ul_BFu15i)
//============================================================================



static void Test_aL_Ul_BFu15ll()
{
  {
    init_simple_test("aL_Ul_BFu15ll");
    static STRUCT_IF_C aL_Ul_BFu15ll lv;
    check2(sizeof(lv), 18, "sizeof(aL_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "aL_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "aL_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu15ll, aL_Ul_BFu15ll)
//============================================================================



static void Test_aL_Ul_BFu15s()
{
  {
    init_simple_test("aL_Ul_BFu15s");
    static STRUCT_IF_C aL_Ul_BFu15s lv;
    check2(sizeof(lv), 18, "sizeof(aL_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "aL_Ul_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "aL_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu15s, aL_Ul_BFu15s)
//============================================================================



static void Test_aL_Ul_BFu16i()
{
  {
    init_simple_test("aL_Ul_BFu16i");
    static STRUCT_IF_C aL_Ul_BFu16i lv;
    check2(sizeof(lv), 18, "sizeof(aL_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "aL_Ul_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "aL_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu16i, aL_Ul_BFu16i)
//============================================================================



static void Test_aL_Ul_BFu16ll()
{
  {
    init_simple_test("aL_Ul_BFu16ll");
    static STRUCT_IF_C aL_Ul_BFu16ll lv;
    check2(sizeof(lv), 18, "sizeof(aL_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "aL_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "aL_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu16ll, aL_Ul_BFu16ll)
//============================================================================



static void Test_aL_Ul_BFu16s()
{
  {
    init_simple_test("aL_Ul_BFu16s");
    static STRUCT_IF_C aL_Ul_BFu16s lv;
    check2(sizeof(lv), 18, "sizeof(aL_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "aL_Ul_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "aL_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu16s, aL_Ul_BFu16s)
//============================================================================



static void Test_aL_Ul_BFu17i()
{
  {
    init_simple_test("aL_Ul_BFu17i");
    static STRUCT_IF_C aL_Ul_BFu17i lv;
    check2(sizeof(lv), 19, "sizeof(aL_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "aL_Ul_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "aL_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu17i, aL_Ul_BFu17i)
//============================================================================



static void Test_aL_Ul_BFu17ll()
{
  {
    init_simple_test("aL_Ul_BFu17ll");
    static STRUCT_IF_C aL_Ul_BFu17ll lv;
    check2(sizeof(lv), 19, "sizeof(aL_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "aL_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "aL_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu17ll, aL_Ul_BFu17ll)
//============================================================================



static void Test_aL_Ul_BFu1c()
{
  {
    init_simple_test("aL_Ul_BFu1c");
    static STRUCT_IF_C aL_Ul_BFu1c lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aL_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu1c, aL_Ul_BFu1c)
//============================================================================



static void Test_aL_Ul_BFu1i()
{
  {
    init_simple_test("aL_Ul_BFu1i");
    static STRUCT_IF_C aL_Ul_BFu1i lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aL_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu1i, aL_Ul_BFu1i)
//============================================================================



static void Test_aL_Ul_BFu1ll()
{
  {
    init_simple_test("aL_Ul_BFu1ll");
    static STRUCT_IF_C aL_Ul_BFu1ll lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aL_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu1ll, aL_Ul_BFu1ll)
//============================================================================



static void Test_aL_Ul_BFu1s()
{
  {
    init_simple_test("aL_Ul_BFu1s");
    static STRUCT_IF_C aL_Ul_BFu1s lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "aL_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu1s, aL_Ul_BFu1s)
//============================================================================



static void Test_aL_Ul_BFu31i()
{
  {
    init_simple_test("aL_Ul_BFu31i");
    static STRUCT_IF_C aL_Ul_BFu31i lv;
    check2(sizeof(lv), 20, "sizeof(aL_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "aL_Ul_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "aL_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu31i, aL_Ul_BFu31i)
//============================================================================



static void Test_aL_Ul_BFu31ll()
{
  {
    init_simple_test("aL_Ul_BFu31ll");
    static STRUCT_IF_C aL_Ul_BFu31ll lv;
    check2(sizeof(lv), 20, "sizeof(aL_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "aL_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "aL_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu31ll, aL_Ul_BFu31ll)
//============================================================================



static void Test_aL_Ul_BFu32i()
{
  {
    init_simple_test("aL_Ul_BFu32i");
    static STRUCT_IF_C aL_Ul_BFu32i lv;
    check2(sizeof(lv), 20, "sizeof(aL_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "aL_Ul_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "aL_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu32i, aL_Ul_BFu32i)
//============================================================================



static void Test_aL_Ul_BFu32ll()
{
  {
    init_simple_test("aL_Ul_BFu32ll");
    static STRUCT_IF_C aL_Ul_BFu32ll lv;
    check2(sizeof(lv), 20, "sizeof(aL_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "aL_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "aL_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu32ll, aL_Ul_BFu32ll)
//============================================================================



static void Test_aL_Ul_BFu33()
{
  {
    init_simple_test("aL_Ul_BFu33");
    static STRUCT_IF_C aL_Ul_BFu33 lv;
    check2(sizeof(lv), 21, "sizeof(aL_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu33.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "aL_Ul_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "aL_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu33, aL_Ul_BFu33)
//============================================================================



static void Test_aL_Ul_BFu7c()
{
  {
    init_simple_test("aL_Ul_BFu7c");
    static STRUCT_IF_C aL_Ul_BFu7c lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aL_Ul_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aL_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu7c, aL_Ul_BFu7c)
//============================================================================



static void Test_aL_Ul_BFu7i()
{
  {
    init_simple_test("aL_Ul_BFu7i");
    static STRUCT_IF_C aL_Ul_BFu7i lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aL_Ul_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aL_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu7i, aL_Ul_BFu7i)
//============================================================================



static void Test_aL_Ul_BFu7ll()
{
  {
    init_simple_test("aL_Ul_BFu7ll");
    static STRUCT_IF_C aL_Ul_BFu7ll lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aL_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aL_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu7ll, aL_Ul_BFu7ll)
//============================================================================



static void Test_aL_Ul_BFu7s()
{
  {
    init_simple_test("aL_Ul_BFu7s");
    static STRUCT_IF_C aL_Ul_BFu7s lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "aL_Ul_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "aL_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu7s, aL_Ul_BFu7s)
//============================================================================



static void Test_aL_Ul_BFu8c()
{
  {
    init_simple_test("aL_Ul_BFu8c");
    static STRUCT_IF_C aL_Ul_BFu8c lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aL_Ul_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aL_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu8c, aL_Ul_BFu8c)
//============================================================================



static void Test_aL_Ul_BFu8i()
{
  {
    init_simple_test("aL_Ul_BFu8i");
    static STRUCT_IF_C aL_Ul_BFu8i lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aL_Ul_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aL_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu8i, aL_Ul_BFu8i)
//============================================================================



static void Test_aL_Ul_BFu8ll()
{
  {
    init_simple_test("aL_Ul_BFu8ll");
    static STRUCT_IF_C aL_Ul_BFu8ll lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aL_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aL_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu8ll, aL_Ul_BFu8ll)
//============================================================================



static void Test_aL_Ul_BFu8s()
{
  {
    init_simple_test("aL_Ul_BFu8s");
    static STRUCT_IF_C aL_Ul_BFu8s lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "aL_Ul_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "aL_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu8s, aL_Ul_BFu8s)
//============================================================================



static void Test_aL_Ul_BFu9i()
{
  {
    init_simple_test("aL_Ul_BFu9i");
    static STRUCT_IF_C aL_Ul_BFu9i lv;
    check2(sizeof(lv), 18, "sizeof(aL_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "aL_Ul_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "aL_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu9i, aL_Ul_BFu9i)
//============================================================================



static void Test_aL_Ul_BFu9ll()
{
  {
    init_simple_test("aL_Ul_BFu9ll");
    static STRUCT_IF_C aL_Ul_BFu9ll lv;
    check2(sizeof(lv), 18, "sizeof(aL_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "aL_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "aL_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu9ll, aL_Ul_BFu9ll)
//============================================================================



static void Test_aL_Ul_BFu9s()
{
  {
    init_simple_test("aL_Ul_BFu9s");
    static STRUCT_IF_C aL_Ul_BFu9s lv;
    check2(sizeof(lv), 18, "sizeof(aL_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "aL_Ul_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "aL_Ul_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "aL_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_BFu9s, aL_Ul_BFu9s)
//============================================================================



static void Test_aL_Ul_C()
{
  {
    init_simple_test("aL_Ul_C");
    STRUCT_IF_C aL_Ul_C lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_C)");
    check_field_offset(lv, v1, 0, "aL_Ul_C.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_C.v2");
    check_field_offset(lv, v3, 16, "aL_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_C, aL_Ul_C)
//============================================================================



static void Test_aL_Ul_D()
{
  {
    init_simple_test("aL_Ul_D");
    STRUCT_IF_C aL_Ul_D lv;
    check2(sizeof(lv), 24, "sizeof(aL_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_D)");
    check_field_offset(lv, v1, 0, "aL_Ul_D.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_D.v2");
    check_field_offset(lv, v3, 16, "aL_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_D, aL_Ul_D)
//============================================================================



static void Test_aL_Ul_F()
{
  {
    init_simple_test("aL_Ul_F");
    STRUCT_IF_C aL_Ul_F lv;
    check2(sizeof(lv), 20, "sizeof(aL_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_F)");
    check_field_offset(lv, v1, 0, "aL_Ul_F.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_F.v2");
    check_field_offset(lv, v3, 16, "aL_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_F, aL_Ul_F)
//============================================================================



static void Test_aL_Ul_I()
{
  {
    init_simple_test("aL_Ul_I");
    STRUCT_IF_C aL_Ul_I lv;
    check2(sizeof(lv), 20, "sizeof(aL_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_I)");
    check_field_offset(lv, v1, 0, "aL_Ul_I.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_I.v2");
    check_field_offset(lv, v3, 16, "aL_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_I, aL_Ul_I)
//============================================================================



static void Test_aL_Ul_Ip()
{
  {
    init_simple_test("aL_Ul_Ip");
    STRUCT_IF_C aL_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aL_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_Ip)");
    check_field_offset(lv, v1, 0, "aL_Ul_Ip.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_Ip.v2");
    check_field_offset(lv, v3, 16, "aL_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_Ip, aL_Ul_Ip)
//============================================================================



static void Test_aL_Ul_L()
{
  {
    init_simple_test("aL_Ul_L");
    STRUCT_IF_C aL_Ul_L lv;
    check2(sizeof(lv), 24, "sizeof(aL_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_L)");
    check_field_offset(lv, v1, 0, "aL_Ul_L.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_L.v2");
    check_field_offset(lv, v3, 16, "aL_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_L, aL_Ul_L)
//============================================================================



static void Test_aL_Ul_S()
{
  {
    init_simple_test("aL_Ul_S");
    STRUCT_IF_C aL_Ul_S lv;
    check2(sizeof(lv), 18, "sizeof(aL_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_S)");
    check_field_offset(lv, v1, 0, "aL_Ul_S.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_S.v2");
    check_field_offset(lv, v3, 16, "aL_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_S, aL_Ul_S)
//============================================================================



static void Test_aL_Ul_Uc()
{
  {
    init_simple_test("aL_Ul_Uc");
    STRUCT_IF_C aL_Ul_Uc lv;
    check2(sizeof(lv), 17, "sizeof(aL_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_Uc)");
    check_field_offset(lv, v1, 0, "aL_Ul_Uc.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_Uc.v2");
    check_field_offset(lv, v3, 16, "aL_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_Uc, aL_Ul_Uc)
//============================================================================



static void Test_aL_Ul_Ui()
{
  {
    init_simple_test("aL_Ul_Ui");
    STRUCT_IF_C aL_Ul_Ui lv;
    check2(sizeof(lv), 20, "sizeof(aL_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_Ui)");
    check_field_offset(lv, v1, 0, "aL_Ul_Ui.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_Ui.v2");
    check_field_offset(lv, v3, 16, "aL_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_Ui, aL_Ul_Ui)
//============================================================================



static void Test_aL_Ul_Ul()
{
  {
    init_simple_test("aL_Ul_Ul");
    STRUCT_IF_C aL_Ul_Ul lv;
    check2(sizeof(lv), 24, "sizeof(aL_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_Ul)");
    check_field_offset(lv, v1, 0, "aL_Ul_Ul.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_Ul.v2");
    check_field_offset(lv, v3, 16, "aL_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_Ul, aL_Ul_Ul)
//============================================================================



static void Test_aL_Ul_Us()
{
  {
    init_simple_test("aL_Ul_Us");
    STRUCT_IF_C aL_Ul_Us lv;
    check2(sizeof(lv), 18, "sizeof(aL_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_Us)");
    check_field_offset(lv, v1, 0, "aL_Ul_Us.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_Us.v2");
    check_field_offset(lv, v3, 16, "aL_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_Us, aL_Ul_Us)
//============================================================================



static void Test_aL_Ul_Vp()
{
  {
    init_simple_test("aL_Ul_Vp");
    STRUCT_IF_C aL_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aL_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Ul_Vp)");
    check_field_offset(lv, v1, 0, "aL_Ul_Vp.v1");
    check_field_offset(lv, v2, 8, "aL_Ul_Vp.v2");
    check_field_offset(lv, v3, 16, "aL_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Ul_Vp, aL_Ul_Vp)
//============================================================================



static void Test_aL_Us()
{
  {
    init_simple_test("aL_Us");
    STRUCT_IF_C aL_Us lv;
    check2(sizeof(lv), 10, "sizeof(aL_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us)");
    check_field_offset(lv, v1, 0, "aL_Us.v1");
    check_field_offset(lv, v2, 8, "aL_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us, aL_Us)
//============================================================================



static void Test_aL_Us_BFu15i()
{
  {
    init_simple_test("aL_Us_BFu15i");
    static STRUCT_IF_C aL_Us_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(aL_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aL_Us_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aL_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu15i, aL_Us_BFu15i)
//============================================================================



static void Test_aL_Us_BFu15ll()
{
  {
    init_simple_test("aL_Us_BFu15ll");
    static STRUCT_IF_C aL_Us_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(aL_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aL_Us_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aL_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu15ll, aL_Us_BFu15ll)
//============================================================================



static void Test_aL_Us_BFu15s()
{
  {
    init_simple_test("aL_Us_BFu15s");
    static STRUCT_IF_C aL_Us_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(aL_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aL_Us_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aL_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu15s, aL_Us_BFu15s)
//============================================================================



static void Test_aL_Us_BFu16i()
{
  {
    init_simple_test("aL_Us_BFu16i");
    static STRUCT_IF_C aL_Us_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(aL_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aL_Us_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aL_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu16i, aL_Us_BFu16i)
//============================================================================



static void Test_aL_Us_BFu16ll()
{
  {
    init_simple_test("aL_Us_BFu16ll");
    static STRUCT_IF_C aL_Us_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(aL_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aL_Us_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aL_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu16ll, aL_Us_BFu16ll)
//============================================================================



static void Test_aL_Us_BFu16s()
{
  {
    init_simple_test("aL_Us_BFu16s");
    static STRUCT_IF_C aL_Us_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(aL_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aL_Us_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aL_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu16s, aL_Us_BFu16s)
//============================================================================



static void Test_aL_Us_BFu17i()
{
  {
    init_simple_test("aL_Us_BFu17i");
    static STRUCT_IF_C aL_Us_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(aL_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "aL_Us_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "aL_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu17i, aL_Us_BFu17i)
//============================================================================



static void Test_aL_Us_BFu17ll()
{
  {
    init_simple_test("aL_Us_BFu17ll");
    static STRUCT_IF_C aL_Us_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(aL_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "aL_Us_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "aL_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu17ll, aL_Us_BFu17ll)
//============================================================================



static void Test_aL_Us_BFu1c()
{
  {
    init_simple_test("aL_Us_BFu1c");
    static STRUCT_IF_C aL_Us_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aL_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu1c, aL_Us_BFu1c)
//============================================================================



static void Test_aL_Us_BFu1i()
{
  {
    init_simple_test("aL_Us_BFu1i");
    static STRUCT_IF_C aL_Us_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aL_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu1i, aL_Us_BFu1i)
//============================================================================



static void Test_aL_Us_BFu1ll()
{
  {
    init_simple_test("aL_Us_BFu1ll");
    static STRUCT_IF_C aL_Us_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aL_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu1ll, aL_Us_BFu1ll)
//============================================================================



static void Test_aL_Us_BFu1s()
{
  {
    init_simple_test("aL_Us_BFu1s");
    static STRUCT_IF_C aL_Us_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aL_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu1s, aL_Us_BFu1s)
//============================================================================



static void Test_aL_Us_BFu31i()
{
  {
    init_simple_test("aL_Us_BFu31i");
    static STRUCT_IF_C aL_Us_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(aL_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "aL_Us_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "aL_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu31i, aL_Us_BFu31i)
//============================================================================



static void Test_aL_Us_BFu31ll()
{
  {
    init_simple_test("aL_Us_BFu31ll");
    static STRUCT_IF_C aL_Us_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(aL_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "aL_Us_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "aL_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu31ll, aL_Us_BFu31ll)
//============================================================================



static void Test_aL_Us_BFu32i()
{
  {
    init_simple_test("aL_Us_BFu32i");
    static STRUCT_IF_C aL_Us_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(aL_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "aL_Us_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "aL_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu32i, aL_Us_BFu32i)
//============================================================================



static void Test_aL_Us_BFu32ll()
{
  {
    init_simple_test("aL_Us_BFu32ll");
    static STRUCT_IF_C aL_Us_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(aL_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "aL_Us_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "aL_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu32ll, aL_Us_BFu32ll)
//============================================================================



static void Test_aL_Us_BFu33()
{
  {
    init_simple_test("aL_Us_BFu33");
    static STRUCT_IF_C aL_Us_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(aL_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu33)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu33.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "aL_Us_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "aL_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu33, aL_Us_BFu33)
//============================================================================



static void Test_aL_Us_BFu7c()
{
  {
    init_simple_test("aL_Us_BFu7c");
    static STRUCT_IF_C aL_Us_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aL_Us_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aL_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu7c, aL_Us_BFu7c)
//============================================================================



static void Test_aL_Us_BFu7i()
{
  {
    init_simple_test("aL_Us_BFu7i");
    static STRUCT_IF_C aL_Us_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aL_Us_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aL_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu7i, aL_Us_BFu7i)
//============================================================================



static void Test_aL_Us_BFu7ll()
{
  {
    init_simple_test("aL_Us_BFu7ll");
    static STRUCT_IF_C aL_Us_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aL_Us_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aL_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu7ll, aL_Us_BFu7ll)
//============================================================================



static void Test_aL_Us_BFu7s()
{
  {
    init_simple_test("aL_Us_BFu7s");
    static STRUCT_IF_C aL_Us_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aL_Us_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aL_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu7s, aL_Us_BFu7s)
//============================================================================



static void Test_aL_Us_BFu8c()
{
  {
    init_simple_test("aL_Us_BFu8c");
    static STRUCT_IF_C aL_Us_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aL_Us_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aL_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu8c, aL_Us_BFu8c)
//============================================================================



static void Test_aL_Us_BFu8i()
{
  {
    init_simple_test("aL_Us_BFu8i");
    static STRUCT_IF_C aL_Us_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aL_Us_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aL_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu8i, aL_Us_BFu8i)
//============================================================================



static void Test_aL_Us_BFu8ll()
{
  {
    init_simple_test("aL_Us_BFu8ll");
    static STRUCT_IF_C aL_Us_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aL_Us_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aL_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu8ll, aL_Us_BFu8ll)
//============================================================================



static void Test_aL_Us_BFu8s()
{
  {
    init_simple_test("aL_Us_BFu8s");
    static STRUCT_IF_C aL_Us_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aL_Us_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aL_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu8s, aL_Us_BFu8s)
//============================================================================



static void Test_aL_Us_BFu9i()
{
  {
    init_simple_test("aL_Us_BFu9i");
    static STRUCT_IF_C aL_Us_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(aL_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "aL_Us_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "aL_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu9i, aL_Us_BFu9i)
//============================================================================



static void Test_aL_Us_BFu9ll()
{
  {
    init_simple_test("aL_Us_BFu9ll");
    static STRUCT_IF_C aL_Us_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(aL_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "aL_Us_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "aL_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu9ll, aL_Us_BFu9ll)
//============================================================================



static void Test_aL_Us_BFu9s()
{
  {
    init_simple_test("aL_Us_BFu9s");
    static STRUCT_IF_C aL_Us_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(aL_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "aL_Us_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aL_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "aL_Us_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "aL_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_BFu9s, aL_Us_BFu9s)
//============================================================================



static void Test_aL_Us_C()
{
  {
    init_simple_test("aL_Us_C");
    STRUCT_IF_C aL_Us_C lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_C)");
    check_field_offset(lv, v1, 0, "aL_Us_C.v1");
    check_field_offset(lv, v2, 8, "aL_Us_C.v2");
    check_field_offset(lv, v3, 10, "aL_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_C, aL_Us_C)
//============================================================================



static void Test_aL_Us_D()
{
  {
    init_simple_test("aL_Us_D");
    STRUCT_IF_C aL_Us_D lv;
    check2(sizeof(lv), 18, "sizeof(aL_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_D)");
    check_field_offset(lv, v1, 0, "aL_Us_D.v1");
    check_field_offset(lv, v2, 8, "aL_Us_D.v2");
    check_field_offset(lv, v3, 10, "aL_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_D, aL_Us_D)
//============================================================================



static void Test_aL_Us_F()
{
  {
    init_simple_test("aL_Us_F");
    STRUCT_IF_C aL_Us_F lv;
    check2(sizeof(lv), 14, "sizeof(aL_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_F)");
    check_field_offset(lv, v1, 0, "aL_Us_F.v1");
    check_field_offset(lv, v2, 8, "aL_Us_F.v2");
    check_field_offset(lv, v3, 10, "aL_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_F, aL_Us_F)
//============================================================================



static void Test_aL_Us_I()
{
  {
    init_simple_test("aL_Us_I");
    STRUCT_IF_C aL_Us_I lv;
    check2(sizeof(lv), 14, "sizeof(aL_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_I)");
    check_field_offset(lv, v1, 0, "aL_Us_I.v1");
    check_field_offset(lv, v2, 8, "aL_Us_I.v2");
    check_field_offset(lv, v3, 10, "aL_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_I, aL_Us_I)
//============================================================================



static void Test_aL_Us_Ip()
{
  {
    init_simple_test("aL_Us_Ip");
    STRUCT_IF_C aL_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aL_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_Ip)");
    check_field_offset(lv, v1, 0, "aL_Us_Ip.v1");
    check_field_offset(lv, v2, 8, "aL_Us_Ip.v2");
    check_field_offset(lv, v3, 10, "aL_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_Ip, aL_Us_Ip)
//============================================================================



static void Test_aL_Us_L()
{
  {
    init_simple_test("aL_Us_L");
    STRUCT_IF_C aL_Us_L lv;
    check2(sizeof(lv), 18, "sizeof(aL_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_L)");
    check_field_offset(lv, v1, 0, "aL_Us_L.v1");
    check_field_offset(lv, v2, 8, "aL_Us_L.v2");
    check_field_offset(lv, v3, 10, "aL_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_L, aL_Us_L)
//============================================================================



static void Test_aL_Us_S()
{
  {
    init_simple_test("aL_Us_S");
    STRUCT_IF_C aL_Us_S lv;
    check2(sizeof(lv), 12, "sizeof(aL_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_S)");
    check_field_offset(lv, v1, 0, "aL_Us_S.v1");
    check_field_offset(lv, v2, 8, "aL_Us_S.v2");
    check_field_offset(lv, v3, 10, "aL_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_S, aL_Us_S)
//============================================================================



static void Test_aL_Us_Uc()
{
  {
    init_simple_test("aL_Us_Uc");
    STRUCT_IF_C aL_Us_Uc lv;
    check2(sizeof(lv), 11, "sizeof(aL_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_Uc)");
    check_field_offset(lv, v1, 0, "aL_Us_Uc.v1");
    check_field_offset(lv, v2, 8, "aL_Us_Uc.v2");
    check_field_offset(lv, v3, 10, "aL_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_Uc, aL_Us_Uc)
//============================================================================



static void Test_aL_Us_Ui()
{
  {
    init_simple_test("aL_Us_Ui");
    STRUCT_IF_C aL_Us_Ui lv;
    check2(sizeof(lv), 14, "sizeof(aL_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_Ui)");
    check_field_offset(lv, v1, 0, "aL_Us_Ui.v1");
    check_field_offset(lv, v2, 8, "aL_Us_Ui.v2");
    check_field_offset(lv, v3, 10, "aL_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_Ui, aL_Us_Ui)
//============================================================================



static void Test_aL_Us_Ul()
{
  {
    init_simple_test("aL_Us_Ul");
    STRUCT_IF_C aL_Us_Ul lv;
    check2(sizeof(lv), 18, "sizeof(aL_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_Ul)");
    check_field_offset(lv, v1, 0, "aL_Us_Ul.v1");
    check_field_offset(lv, v2, 8, "aL_Us_Ul.v2");
    check_field_offset(lv, v3, 10, "aL_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_Ul, aL_Us_Ul)
//============================================================================



static void Test_aL_Us_Us()
{
  {
    init_simple_test("aL_Us_Us");
    STRUCT_IF_C aL_Us_Us lv;
    check2(sizeof(lv), 12, "sizeof(aL_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_Us)");
    check_field_offset(lv, v1, 0, "aL_Us_Us.v1");
    check_field_offset(lv, v2, 8, "aL_Us_Us.v2");
    check_field_offset(lv, v3, 10, "aL_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_Us, aL_Us_Us)
//============================================================================



static void Test_aL_Us_Vp()
{
  {
    init_simple_test("aL_Us_Vp");
    STRUCT_IF_C aL_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aL_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Us_Vp)");
    check_field_offset(lv, v1, 0, "aL_Us_Vp.v1");
    check_field_offset(lv, v2, 8, "aL_Us_Vp.v2");
    check_field_offset(lv, v3, 10, "aL_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Us_Vp, aL_Us_Vp)
//============================================================================



static void Test_aL_Vp()
{
  {
    init_simple_test("aL_Vp");
    STRUCT_IF_C aL_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aL_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp)");
    check_field_offset(lv, v1, 0, "aL_Vp.v1");
    check_field_offset(lv, v2, 8, "aL_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp, aL_Vp)
//============================================================================



static void Test_aL_Vp_BFu15i()
{
  {
    init_simple_test("aL_Vp_BFu15i");
    static STRUCT_IF_C aL_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aL_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu15i.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aL_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aL_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu15i, aL_Vp_BFu15i)
//============================================================================



static void Test_aL_Vp_BFu15ll()
{
  {
    init_simple_test("aL_Vp_BFu15ll");
    static STRUCT_IF_C aL_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aL_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aL_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aL_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu15ll, aL_Vp_BFu15ll)
//============================================================================



static void Test_aL_Vp_BFu15s()
{
  {
    init_simple_test("aL_Vp_BFu15s");
    static STRUCT_IF_C aL_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aL_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu15s.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "aL_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "aL_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu15s, aL_Vp_BFu15s)
//============================================================================



static void Test_aL_Vp_BFu16i()
{
  {
    init_simple_test("aL_Vp_BFu16i");
    static STRUCT_IF_C aL_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aL_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu16i.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aL_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aL_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu16i, aL_Vp_BFu16i)
//============================================================================



static void Test_aL_Vp_BFu16ll()
{
  {
    init_simple_test("aL_Vp_BFu16ll");
    static STRUCT_IF_C aL_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aL_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aL_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aL_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu16ll, aL_Vp_BFu16ll)
//============================================================================



static void Test_aL_Vp_BFu16s()
{
  {
    init_simple_test("aL_Vp_BFu16s");
    static STRUCT_IF_C aL_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aL_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu16s.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "aL_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "aL_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu16s, aL_Vp_BFu16s)
//============================================================================



static void Test_aL_Vp_BFu17i()
{
  {
    init_simple_test("aL_Vp_BFu17i");
    static STRUCT_IF_C aL_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aL_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu17i.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "aL_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "aL_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu17i, aL_Vp_BFu17i)
//============================================================================



static void Test_aL_Vp_BFu17ll()
{
  {
    init_simple_test("aL_Vp_BFu17ll");
    static STRUCT_IF_C aL_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aL_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "aL_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "aL_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu17ll, aL_Vp_BFu17ll)
//============================================================================



static void Test_aL_Vp_BFu1c()
{
  {
    init_simple_test("aL_Vp_BFu1c");
    static STRUCT_IF_C aL_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu1c.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aL_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu1c, aL_Vp_BFu1c)
//============================================================================



static void Test_aL_Vp_BFu1i()
{
  {
    init_simple_test("aL_Vp_BFu1i");
    static STRUCT_IF_C aL_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu1i.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aL_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu1i, aL_Vp_BFu1i)
//============================================================================



static void Test_aL_Vp_BFu1ll()
{
  {
    init_simple_test("aL_Vp_BFu1ll");
    static STRUCT_IF_C aL_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aL_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu1ll, aL_Vp_BFu1ll)
//============================================================================



static void Test_aL_Vp_BFu1s()
{
  {
    init_simple_test("aL_Vp_BFu1s");
    static STRUCT_IF_C aL_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu1s.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "aL_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu1s, aL_Vp_BFu1s)
//============================================================================



static void Test_aL_Vp_BFu31i()
{
  {
    init_simple_test("aL_Vp_BFu31i");
    static STRUCT_IF_C aL_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aL_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu31i.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "aL_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "aL_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu31i, aL_Vp_BFu31i)
//============================================================================



static void Test_aL_Vp_BFu31ll()
{
  {
    init_simple_test("aL_Vp_BFu31ll");
    static STRUCT_IF_C aL_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aL_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "aL_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "aL_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu31ll, aL_Vp_BFu31ll)
//============================================================================



static void Test_aL_Vp_BFu32i()
{
  {
    init_simple_test("aL_Vp_BFu32i");
    static STRUCT_IF_C aL_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aL_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu32i.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "aL_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "aL_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu32i, aL_Vp_BFu32i)
//============================================================================



static void Test_aL_Vp_BFu32ll()
{
  {
    init_simple_test("aL_Vp_BFu32ll");
    static STRUCT_IF_C aL_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aL_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "aL_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "aL_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu32ll, aL_Vp_BFu32ll)
//============================================================================



static void Test_aL_Vp_BFu33()
{
  {
    init_simple_test("aL_Vp_BFu33");
    static STRUCT_IF_C aL_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(aL_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu33.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "aL_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "aL_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu33, aL_Vp_BFu33)
//============================================================================



static void Test_aL_Vp_BFu7c()
{
  {
    init_simple_test("aL_Vp_BFu7c");
    static STRUCT_IF_C aL_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu7c.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aL_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aL_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu7c, aL_Vp_BFu7c)
//============================================================================



static void Test_aL_Vp_BFu7i()
{
  {
    init_simple_test("aL_Vp_BFu7i");
    static STRUCT_IF_C aL_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu7i.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aL_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aL_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu7i, aL_Vp_BFu7i)
//============================================================================



static void Test_aL_Vp_BFu7ll()
{
  {
    init_simple_test("aL_Vp_BFu7ll");
    static STRUCT_IF_C aL_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aL_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aL_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu7ll, aL_Vp_BFu7ll)
//============================================================================



static void Test_aL_Vp_BFu7s()
{
  {
    init_simple_test("aL_Vp_BFu7s");
    static STRUCT_IF_C aL_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu7s.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "aL_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "aL_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu7s, aL_Vp_BFu7s)
//============================================================================



static void Test_aL_Vp_BFu8c()
{
  {
    init_simple_test("aL_Vp_BFu8c");
    static STRUCT_IF_C aL_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu8c.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aL_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aL_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu8c, aL_Vp_BFu8c)
//============================================================================



static void Test_aL_Vp_BFu8i()
{
  {
    init_simple_test("aL_Vp_BFu8i");
    static STRUCT_IF_C aL_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu8i.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aL_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aL_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu8i, aL_Vp_BFu8i)
//============================================================================



static void Test_aL_Vp_BFu8ll()
{
  {
    init_simple_test("aL_Vp_BFu8ll");
    static STRUCT_IF_C aL_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aL_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aL_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu8ll, aL_Vp_BFu8ll)
//============================================================================



static void Test_aL_Vp_BFu8s()
{
  {
    init_simple_test("aL_Vp_BFu8s");
    static STRUCT_IF_C aL_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu8s.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "aL_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "aL_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu8s, aL_Vp_BFu8s)
//============================================================================



static void Test_aL_Vp_BFu9i()
{
  {
    init_simple_test("aL_Vp_BFu9i");
    static STRUCT_IF_C aL_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aL_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu9i.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aL_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aL_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu9i, aL_Vp_BFu9i)
//============================================================================



static void Test_aL_Vp_BFu9ll()
{
  {
    init_simple_test("aL_Vp_BFu9ll");
    static STRUCT_IF_C aL_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aL_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aL_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aL_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu9ll, aL_Vp_BFu9ll)
//============================================================================



static void Test_aL_Vp_BFu9s()
{
  {
    init_simple_test("aL_Vp_BFu9s");
    static STRUCT_IF_C aL_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aL_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "aL_Vp_BFu9s.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "aL_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "aL_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_BFu9s, aL_Vp_BFu9s)
//============================================================================



static void Test_aL_Vp_C()
{
  {
    init_simple_test("aL_Vp_C");
    STRUCT_IF_C aL_Vp_C lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_C)");
    check_field_offset(lv, v1, 0, "aL_Vp_C.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aL_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_C, aL_Vp_C)
//============================================================================



static void Test_aL_Vp_D()
{
  {
    init_simple_test("aL_Vp_D");
    STRUCT_IF_C aL_Vp_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aL_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_D)");
    check_field_offset(lv, v1, 0, "aL_Vp_D.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aL_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_D, aL_Vp_D)
//============================================================================



static void Test_aL_Vp_F()
{
  {
    init_simple_test("aL_Vp_F");
    STRUCT_IF_C aL_Vp_F lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aL_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_F)");
    check_field_offset(lv, v1, 0, "aL_Vp_F.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aL_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_F, aL_Vp_F)
//============================================================================



static void Test_aL_Vp_I()
{
  {
    init_simple_test("aL_Vp_I");
    STRUCT_IF_C aL_Vp_I lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aL_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_I)");
    check_field_offset(lv, v1, 0, "aL_Vp_I.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aL_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_I, aL_Vp_I)
//============================================================================



static void Test_aL_Vp_Ip()
{
  {
    init_simple_test("aL_Vp_Ip");
    STRUCT_IF_C aL_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aL_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_Ip)");
    check_field_offset(lv, v1, 0, "aL_Vp_Ip.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aL_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_Ip, aL_Vp_Ip)
//============================================================================



static void Test_aL_Vp_L()
{
  {
    init_simple_test("aL_Vp_L");
    STRUCT_IF_C aL_Vp_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aL_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_L)");
    check_field_offset(lv, v1, 0, "aL_Vp_L.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aL_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_L, aL_Vp_L)
//============================================================================



static void Test_aL_Vp_S()
{
  {
    init_simple_test("aL_Vp_S");
    STRUCT_IF_C aL_Vp_S lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aL_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_S)");
    check_field_offset(lv, v1, 0, "aL_Vp_S.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aL_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_S, aL_Vp_S)
//============================================================================



static void Test_aL_Vp_Uc()
{
  {
    init_simple_test("aL_Vp_Uc");
    STRUCT_IF_C aL_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aL_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_Uc)");
    check_field_offset(lv, v1, 0, "aL_Vp_Uc.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aL_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_Uc, aL_Vp_Uc)
//============================================================================



static void Test_aL_Vp_Ui()
{
  {
    init_simple_test("aL_Vp_Ui");
    STRUCT_IF_C aL_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aL_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_Ui)");
    check_field_offset(lv, v1, 0, "aL_Vp_Ui.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aL_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_Ui, aL_Vp_Ui)
//============================================================================



static void Test_aL_Vp_Ul()
{
  {
    init_simple_test("aL_Vp_Ul");
    STRUCT_IF_C aL_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(aL_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_Ul)");
    check_field_offset(lv, v1, 0, "aL_Vp_Ul.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aL_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_Ul, aL_Vp_Ul)
//============================================================================



static void Test_aL_Vp_Us()
{
  {
    init_simple_test("aL_Vp_Us");
    STRUCT_IF_C aL_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aL_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_Us)");
    check_field_offset(lv, v1, 0, "aL_Vp_Us.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aL_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_Us, aL_Vp_Us)
//============================================================================



static void Test_aL_Vp_Vp()
{
  {
    init_simple_test("aL_Vp_Vp");
    STRUCT_IF_C aL_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(aL_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aL_Vp_Vp)");
    check_field_offset(lv, v1, 0, "aL_Vp_Vp.v1");
    check_field_offset(lv, v2, 8, "aL_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "aL_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aL_Vp_Vp, aL_Vp_Vp)
//============================================================================



static void Test_aS()
{
  {
    init_simple_test("aS");
    STRUCT_IF_C aS lv;
    check2(sizeof(lv), 2, "sizeof(aS)");
    check2(__alignof__(lv), 1, "__alignof__(aS)");
    check_field_offset(lv, v1, 0, "aS.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aS, aS)
//============================================================================



static void Test_aS_BFu15i()
{
  {
    init_simple_test("aS_BFu15i");
    static STRUCT_IF_C aS_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i, aS_BFu15i)
//============================================================================



static void Test_aS_BFu15i_BFu15i()
{
  {
    init_simple_test("aS_BFu15i_BFu15i");
    static STRUCT_IF_C aS_BFu15i_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aS_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu15i, aS_BFu15i_BFu15i)
//============================================================================



static void Test_aS_BFu15i_BFu15ll()
{
  {
    init_simple_test("aS_BFu15i_BFu15ll");
    static STRUCT_IF_C aS_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aS_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu15ll, aS_BFu15i_BFu15ll)
//============================================================================



static void Test_aS_BFu15i_BFu15s()
{
  {
    init_simple_test("aS_BFu15i_BFu15s");
    static STRUCT_IF_C aS_BFu15i_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aS_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu15s, aS_BFu15i_BFu15s)
//============================================================================



static void Test_aS_BFu15i_BFu16i()
{
  {
    init_simple_test("aS_BFu15i_BFu16i");
    static STRUCT_IF_C aS_BFu15i_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aS_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aS_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu16i, aS_BFu15i_BFu16i)
//============================================================================



static void Test_aS_BFu15i_BFu16ll()
{
  {
    init_simple_test("aS_BFu15i_BFu16ll");
    static STRUCT_IF_C aS_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aS_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aS_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu16ll, aS_BFu15i_BFu16ll)
//============================================================================



static void Test_aS_BFu15i_BFu16s()
{
  {
    init_simple_test("aS_BFu15i_BFu16s");
    static STRUCT_IF_C aS_BFu15i_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aS_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aS_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu16s, aS_BFu15i_BFu16s)
//============================================================================



static void Test_aS_BFu15i_BFu17i()
{
  {
    init_simple_test("aS_BFu15i_BFu17i");
    static STRUCT_IF_C aS_BFu15i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "aS_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "aS_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu17i, aS_BFu15i_BFu17i)
//============================================================================



static void Test_aS_BFu15i_BFu17ll()
{
  {
    init_simple_test("aS_BFu15i_BFu17ll");
    static STRUCT_IF_C aS_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "aS_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "aS_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu17ll, aS_BFu15i_BFu17ll)
//============================================================================



static void Test_aS_BFu15i_BFu1c()
{
  {
    init_simple_test("aS_BFu15i_BFu1c");
    static STRUCT_IF_C aS_BFu15i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aS_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu1c, aS_BFu15i_BFu1c)
//============================================================================



static void Test_aS_BFu15i_BFu1i()
{
  {
    init_simple_test("aS_BFu15i_BFu1i");
    static STRUCT_IF_C aS_BFu15i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aS_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu1i, aS_BFu15i_BFu1i)
//============================================================================



static void Test_aS_BFu15i_BFu1ll()
{
  {
    init_simple_test("aS_BFu15i_BFu1ll");
    static STRUCT_IF_C aS_BFu15i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aS_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu1ll, aS_BFu15i_BFu1ll)
//============================================================================



static void Test_aS_BFu15i_BFu1s()
{
  {
    init_simple_test("aS_BFu15i_BFu1s");
    static STRUCT_IF_C aS_BFu15i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aS_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu1s, aS_BFu15i_BFu1s)
//============================================================================



static void Test_aS_BFu15i_BFu31i()
{
  {
    init_simple_test("aS_BFu15i_BFu31i");
    static STRUCT_IF_C aS_BFu15i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "aS_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "aS_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu31i, aS_BFu15i_BFu31i)
//============================================================================



static void Test_aS_BFu15i_BFu31ll()
{
  {
    init_simple_test("aS_BFu15i_BFu31ll");
    static STRUCT_IF_C aS_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "aS_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "aS_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu31ll, aS_BFu15i_BFu31ll)
//============================================================================



static void Test_aS_BFu15i_BFu32i()
{
  {
    init_simple_test("aS_BFu15i_BFu32i");
    static STRUCT_IF_C aS_BFu15i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "aS_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "aS_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu32i, aS_BFu15i_BFu32i)
//============================================================================



static void Test_aS_BFu15i_BFu32ll()
{
  {
    init_simple_test("aS_BFu15i_BFu32ll");
    static STRUCT_IF_C aS_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "aS_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "aS_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu32ll, aS_BFu15i_BFu32ll)
//============================================================================



static void Test_aS_BFu15i_BFu33()
{
  {
    init_simple_test("aS_BFu15i_BFu33");
    static STRUCT_IF_C aS_BFu15i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "aS_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "aS_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu33, aS_BFu15i_BFu33)
//============================================================================



static void Test_aS_BFu15i_BFu7c()
{
  {
    init_simple_test("aS_BFu15i_BFu7c");
    static STRUCT_IF_C aS_BFu15i_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aS_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aS_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu7c, aS_BFu15i_BFu7c)
//============================================================================



static void Test_aS_BFu15i_BFu7i()
{
  {
    init_simple_test("aS_BFu15i_BFu7i");
    static STRUCT_IF_C aS_BFu15i_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aS_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aS_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu7i, aS_BFu15i_BFu7i)
//============================================================================



static void Test_aS_BFu15i_BFu7ll()
{
  {
    init_simple_test("aS_BFu15i_BFu7ll");
    static STRUCT_IF_C aS_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aS_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aS_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu7ll, aS_BFu15i_BFu7ll)
//============================================================================



static void Test_aS_BFu15i_BFu7s()
{
  {
    init_simple_test("aS_BFu15i_BFu7s");
    static STRUCT_IF_C aS_BFu15i_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aS_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aS_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu7s, aS_BFu15i_BFu7s)
//============================================================================



static void Test_aS_BFu15i_BFu8c()
{
  {
    init_simple_test("aS_BFu15i_BFu8c");
    static STRUCT_IF_C aS_BFu15i_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aS_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aS_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu8c, aS_BFu15i_BFu8c)
//============================================================================



static void Test_aS_BFu15i_BFu8i()
{
  {
    init_simple_test("aS_BFu15i_BFu8i");
    static STRUCT_IF_C aS_BFu15i_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aS_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aS_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu8i, aS_BFu15i_BFu8i)
//============================================================================



static void Test_aS_BFu15i_BFu8ll()
{
  {
    init_simple_test("aS_BFu15i_BFu8ll");
    static STRUCT_IF_C aS_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aS_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aS_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu8ll, aS_BFu15i_BFu8ll)
//============================================================================



static void Test_aS_BFu15i_BFu8s()
{
  {
    init_simple_test("aS_BFu15i_BFu8s");
    static STRUCT_IF_C aS_BFu15i_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aS_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aS_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu8s, aS_BFu15i_BFu8s)
//============================================================================



static void Test_aS_BFu15i_BFu9i()
{
  {
    init_simple_test("aS_BFu15i_BFu9i");
    static STRUCT_IF_C aS_BFu15i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aS_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aS_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu9i, aS_BFu15i_BFu9i)
//============================================================================



static void Test_aS_BFu15i_BFu9ll()
{
  {
    init_simple_test("aS_BFu15i_BFu9ll");
    static STRUCT_IF_C aS_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aS_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aS_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu9ll, aS_BFu15i_BFu9ll)
//============================================================================



static void Test_aS_BFu15i_BFu9s()
{
  {
    init_simple_test("aS_BFu15i_BFu9s");
    static STRUCT_IF_C aS_BFu15i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aS_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aS_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_BFu9s, aS_BFu15i_BFu9s)
//============================================================================



static void Test_aS_BFu15i_C()
{
  {
    init_simple_test("aS_BFu15i_C");
    static STRUCT_IF_C aS_BFu15i_C lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_C)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_C");
    check_field_offset(lv, v3, 4, "aS_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_C, aS_BFu15i_C)
//============================================================================



static void Test_aS_BFu15i_D()
{
  {
    init_simple_test("aS_BFu15i_D");
    static STRUCT_IF_C aS_BFu15i_D lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu15i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_D)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_D");
    check_field_offset(lv, v3, 4, "aS_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_D, aS_BFu15i_D)
//============================================================================



static void Test_aS_BFu15i_F()
{
  {
    init_simple_test("aS_BFu15i_F");
    static STRUCT_IF_C aS_BFu15i_F lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_F)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_F");
    check_field_offset(lv, v3, 4, "aS_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_F, aS_BFu15i_F)
//============================================================================



static void Test_aS_BFu15i_I()
{
  {
    init_simple_test("aS_BFu15i_I");
    static STRUCT_IF_C aS_BFu15i_I lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_I)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_I");
    check_field_offset(lv, v3, 4, "aS_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_I, aS_BFu15i_I)
//============================================================================



static void Test_aS_BFu15i_Ip()
{
  {
    init_simple_test("aS_BFu15i_Ip");
    static STRUCT_IF_C aS_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu15i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_Ip");
    check_field_offset(lv, v3, 4, "aS_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_Ip, aS_BFu15i_Ip)
//============================================================================



static void Test_aS_BFu15i_L()
{
  {
    init_simple_test("aS_BFu15i_L");
    static STRUCT_IF_C aS_BFu15i_L lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu15i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_L)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_L");
    check_field_offset(lv, v3, 4, "aS_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_L, aS_BFu15i_L)
//============================================================================



static void Test_aS_BFu15i_S()
{
  {
    init_simple_test("aS_BFu15i_S");
    static STRUCT_IF_C aS_BFu15i_S lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_S)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_S");
    check_field_offset(lv, v3, 4, "aS_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_S, aS_BFu15i_S)
//============================================================================



static void Test_aS_BFu15i_Uc()
{
  {
    init_simple_test("aS_BFu15i_Uc");
    static STRUCT_IF_C aS_BFu15i_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_Uc");
    check_field_offset(lv, v3, 4, "aS_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_Uc, aS_BFu15i_Uc)
//============================================================================



static void Test_aS_BFu15i_Ui()
{
  {
    init_simple_test("aS_BFu15i_Ui");
    static STRUCT_IF_C aS_BFu15i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_Ui");
    check_field_offset(lv, v3, 4, "aS_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_Ui, aS_BFu15i_Ui)
//============================================================================



static void Test_aS_BFu15i_Ul()
{
  {
    init_simple_test("aS_BFu15i_Ul");
    static STRUCT_IF_C aS_BFu15i_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu15i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_Ul");
    check_field_offset(lv, v3, 4, "aS_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_Ul, aS_BFu15i_Ul)
//============================================================================



static void Test_aS_BFu15i_Us()
{
  {
    init_simple_test("aS_BFu15i_Us");
    static STRUCT_IF_C aS_BFu15i_Us lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_Us");
    check_field_offset(lv, v3, 4, "aS_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_Us, aS_BFu15i_Us)
//============================================================================



static void Test_aS_BFu15i_Vp()
{
  {
    init_simple_test("aS_BFu15i_Vp");
    static STRUCT_IF_C aS_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu15i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15i_Vp");
    check_field_offset(lv, v3, 4, "aS_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15i_Vp, aS_BFu15i_Vp)
//============================================================================



static void Test_aS_BFu15ll()
{
  {
    init_simple_test("aS_BFu15ll");
    static STRUCT_IF_C aS_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll, aS_BFu15ll)
//============================================================================



static void Test_aS_BFu15ll_BFu15i()
{
  {
    init_simple_test("aS_BFu15ll_BFu15i");
    static STRUCT_IF_C aS_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aS_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu15i, aS_BFu15ll_BFu15i)
//============================================================================



static void Test_aS_BFu15ll_BFu15ll()
{
  {
    init_simple_test("aS_BFu15ll_BFu15ll");
    static STRUCT_IF_C aS_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aS_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu15ll, aS_BFu15ll_BFu15ll)
//============================================================================



static void Test_aS_BFu15ll_BFu15s()
{
  {
    init_simple_test("aS_BFu15ll_BFu15s");
    static STRUCT_IF_C aS_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aS_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu15s, aS_BFu15ll_BFu15s)
//============================================================================



static void Test_aS_BFu15ll_BFu16i()
{
  {
    init_simple_test("aS_BFu15ll_BFu16i");
    static STRUCT_IF_C aS_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aS_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aS_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu16i, aS_BFu15ll_BFu16i)
//============================================================================



static void Test_aS_BFu15ll_BFu16ll()
{
  {
    init_simple_test("aS_BFu15ll_BFu16ll");
    static STRUCT_IF_C aS_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aS_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aS_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu16ll, aS_BFu15ll_BFu16ll)
//============================================================================



static void Test_aS_BFu15ll_BFu16s()
{
  {
    init_simple_test("aS_BFu15ll_BFu16s");
    static STRUCT_IF_C aS_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aS_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aS_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu16s, aS_BFu15ll_BFu16s)
//============================================================================



static void Test_aS_BFu15ll_BFu17i()
{
  {
    init_simple_test("aS_BFu15ll_BFu17i");
    static STRUCT_IF_C aS_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "aS_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "aS_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu17i, aS_BFu15ll_BFu17i)
//============================================================================



static void Test_aS_BFu15ll_BFu17ll()
{
  {
    init_simple_test("aS_BFu15ll_BFu17ll");
    static STRUCT_IF_C aS_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "aS_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "aS_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu17ll, aS_BFu15ll_BFu17ll)
//============================================================================



static void Test_aS_BFu15ll_BFu1c()
{
  {
    init_simple_test("aS_BFu15ll_BFu1c");
    static STRUCT_IF_C aS_BFu15ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aS_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu1c, aS_BFu15ll_BFu1c)
//============================================================================



static void Test_aS_BFu15ll_BFu1i()
{
  {
    init_simple_test("aS_BFu15ll_BFu1i");
    static STRUCT_IF_C aS_BFu15ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aS_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu1i, aS_BFu15ll_BFu1i)
//============================================================================



static void Test_aS_BFu15ll_BFu1ll()
{
  {
    init_simple_test("aS_BFu15ll_BFu1ll");
    static STRUCT_IF_C aS_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aS_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu1ll, aS_BFu15ll_BFu1ll)
//============================================================================



static void Test_aS_BFu15ll_BFu1s()
{
  {
    init_simple_test("aS_BFu15ll_BFu1s");
    static STRUCT_IF_C aS_BFu15ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aS_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu1s, aS_BFu15ll_BFu1s)
//============================================================================



static void Test_aS_BFu15ll_BFu31i()
{
  {
    init_simple_test("aS_BFu15ll_BFu31i");
    static STRUCT_IF_C aS_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "aS_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "aS_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu31i, aS_BFu15ll_BFu31i)
//============================================================================



static void Test_aS_BFu15ll_BFu31ll()
{
  {
    init_simple_test("aS_BFu15ll_BFu31ll");
    static STRUCT_IF_C aS_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "aS_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "aS_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu31ll, aS_BFu15ll_BFu31ll)
//============================================================================



static void Test_aS_BFu15ll_BFu32i()
{
  {
    init_simple_test("aS_BFu15ll_BFu32i");
    static STRUCT_IF_C aS_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "aS_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "aS_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu32i, aS_BFu15ll_BFu32i)
//============================================================================



static void Test_aS_BFu15ll_BFu32ll()
{
  {
    init_simple_test("aS_BFu15ll_BFu32ll");
    static STRUCT_IF_C aS_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "aS_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "aS_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu32ll, aS_BFu15ll_BFu32ll)
//============================================================================



static void Test_aS_BFu15ll_BFu33()
{
  {
    init_simple_test("aS_BFu15ll_BFu33");
    static STRUCT_IF_C aS_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "aS_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "aS_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu33, aS_BFu15ll_BFu33)
//============================================================================



static void Test_aS_BFu15ll_BFu7c()
{
  {
    init_simple_test("aS_BFu15ll_BFu7c");
    static STRUCT_IF_C aS_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aS_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aS_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu7c, aS_BFu15ll_BFu7c)
//============================================================================



static void Test_aS_BFu15ll_BFu7i()
{
  {
    init_simple_test("aS_BFu15ll_BFu7i");
    static STRUCT_IF_C aS_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aS_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aS_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu7i, aS_BFu15ll_BFu7i)
//============================================================================



static void Test_aS_BFu15ll_BFu7ll()
{
  {
    init_simple_test("aS_BFu15ll_BFu7ll");
    static STRUCT_IF_C aS_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aS_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aS_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu7ll, aS_BFu15ll_BFu7ll)
//============================================================================



static void Test_aS_BFu15ll_BFu7s()
{
  {
    init_simple_test("aS_BFu15ll_BFu7s");
    static STRUCT_IF_C aS_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aS_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aS_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu7s, aS_BFu15ll_BFu7s)
//============================================================================



static void Test_aS_BFu15ll_BFu8c()
{
  {
    init_simple_test("aS_BFu15ll_BFu8c");
    static STRUCT_IF_C aS_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aS_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aS_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu8c, aS_BFu15ll_BFu8c)
//============================================================================



static void Test_aS_BFu15ll_BFu8i()
{
  {
    init_simple_test("aS_BFu15ll_BFu8i");
    static STRUCT_IF_C aS_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aS_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aS_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu8i, aS_BFu15ll_BFu8i)
//============================================================================



static void Test_aS_BFu15ll_BFu8ll()
{
  {
    init_simple_test("aS_BFu15ll_BFu8ll");
    static STRUCT_IF_C aS_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aS_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aS_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu8ll, aS_BFu15ll_BFu8ll)
//============================================================================



static void Test_aS_BFu15ll_BFu8s()
{
  {
    init_simple_test("aS_BFu15ll_BFu8s");
    static STRUCT_IF_C aS_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aS_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aS_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu8s, aS_BFu15ll_BFu8s)
//============================================================================



static void Test_aS_BFu15ll_BFu9i()
{
  {
    init_simple_test("aS_BFu15ll_BFu9i");
    static STRUCT_IF_C aS_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aS_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aS_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu9i, aS_BFu15ll_BFu9i)
//============================================================================



static void Test_aS_BFu15ll_BFu9ll()
{
  {
    init_simple_test("aS_BFu15ll_BFu9ll");
    static STRUCT_IF_C aS_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aS_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aS_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu9ll, aS_BFu15ll_BFu9ll)
//============================================================================



static void Test_aS_BFu15ll_BFu9s()
{
  {
    init_simple_test("aS_BFu15ll_BFu9s");
    static STRUCT_IF_C aS_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aS_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aS_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_BFu9s, aS_BFu15ll_BFu9s)
//============================================================================



static void Test_aS_BFu15ll_C()
{
  {
    init_simple_test("aS_BFu15ll_C");
    static STRUCT_IF_C aS_BFu15ll_C lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_C");
    check_field_offset(lv, v3, 4, "aS_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_C, aS_BFu15ll_C)
//============================================================================



static void Test_aS_BFu15ll_D()
{
  {
    init_simple_test("aS_BFu15ll_D");
    static STRUCT_IF_C aS_BFu15ll_D lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu15ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_D");
    check_field_offset(lv, v3, 4, "aS_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_D, aS_BFu15ll_D)
//============================================================================



static void Test_aS_BFu15ll_F()
{
  {
    init_simple_test("aS_BFu15ll_F");
    static STRUCT_IF_C aS_BFu15ll_F lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_F");
    check_field_offset(lv, v3, 4, "aS_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_F, aS_BFu15ll_F)
//============================================================================



static void Test_aS_BFu15ll_I()
{
  {
    init_simple_test("aS_BFu15ll_I");
    static STRUCT_IF_C aS_BFu15ll_I lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_I");
    check_field_offset(lv, v3, 4, "aS_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_I, aS_BFu15ll_I)
//============================================================================



static void Test_aS_BFu15ll_Ip()
{
  {
    init_simple_test("aS_BFu15ll_Ip");
    static STRUCT_IF_C aS_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu15ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_Ip");
    check_field_offset(lv, v3, 4, "aS_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_Ip, aS_BFu15ll_Ip)
//============================================================================



static void Test_aS_BFu15ll_L()
{
  {
    init_simple_test("aS_BFu15ll_L");
    static STRUCT_IF_C aS_BFu15ll_L lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu15ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_L");
    check_field_offset(lv, v3, 4, "aS_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_L, aS_BFu15ll_L)
//============================================================================



static void Test_aS_BFu15ll_S()
{
  {
    init_simple_test("aS_BFu15ll_S");
    static STRUCT_IF_C aS_BFu15ll_S lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_S");
    check_field_offset(lv, v3, 4, "aS_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_S, aS_BFu15ll_S)
//============================================================================



static void Test_aS_BFu15ll_Uc()
{
  {
    init_simple_test("aS_BFu15ll_Uc");
    static STRUCT_IF_C aS_BFu15ll_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_Uc");
    check_field_offset(lv, v3, 4, "aS_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_Uc, aS_BFu15ll_Uc)
//============================================================================



static void Test_aS_BFu15ll_Ui()
{
  {
    init_simple_test("aS_BFu15ll_Ui");
    static STRUCT_IF_C aS_BFu15ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_Ui");
    check_field_offset(lv, v3, 4, "aS_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_Ui, aS_BFu15ll_Ui)
//============================================================================



static void Test_aS_BFu15ll_Ul()
{
  {
    init_simple_test("aS_BFu15ll_Ul");
    static STRUCT_IF_C aS_BFu15ll_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu15ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_Ul");
    check_field_offset(lv, v3, 4, "aS_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_Ul, aS_BFu15ll_Ul)
//============================================================================



static void Test_aS_BFu15ll_Us()
{
  {
    init_simple_test("aS_BFu15ll_Us");
    static STRUCT_IF_C aS_BFu15ll_Us lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_Us");
    check_field_offset(lv, v3, 4, "aS_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_Us, aS_BFu15ll_Us)
//============================================================================



static void Test_aS_BFu15ll_Vp()
{
  {
    init_simple_test("aS_BFu15ll_Vp");
    static STRUCT_IF_C aS_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu15ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15ll_Vp");
    check_field_offset(lv, v3, 4, "aS_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15ll_Vp, aS_BFu15ll_Vp)
//============================================================================



static void Test_aS_BFu15s()
{
  {
    init_simple_test("aS_BFu15s");
    static STRUCT_IF_C aS_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s, aS_BFu15s)
//============================================================================



static void Test_aS_BFu15s_BFu15i()
{
  {
    init_simple_test("aS_BFu15s_BFu15i");
    static STRUCT_IF_C aS_BFu15s_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aS_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu15i, aS_BFu15s_BFu15i)
//============================================================================



static void Test_aS_BFu15s_BFu15ll()
{
  {
    init_simple_test("aS_BFu15s_BFu15ll");
    static STRUCT_IF_C aS_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aS_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu15ll, aS_BFu15s_BFu15ll)
//============================================================================



static void Test_aS_BFu15s_BFu15s()
{
  {
    init_simple_test("aS_BFu15s_BFu15s");
    static STRUCT_IF_C aS_BFu15s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "aS_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu15s, aS_BFu15s_BFu15s)
//============================================================================



static void Test_aS_BFu15s_BFu16i()
{
  {
    init_simple_test("aS_BFu15s_BFu16i");
    static STRUCT_IF_C aS_BFu15s_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aS_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aS_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu16i, aS_BFu15s_BFu16i)
//============================================================================



static void Test_aS_BFu15s_BFu16ll()
{
  {
    init_simple_test("aS_BFu15s_BFu16ll");
    static STRUCT_IF_C aS_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aS_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aS_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu16ll, aS_BFu15s_BFu16ll)
//============================================================================



static void Test_aS_BFu15s_BFu16s()
{
  {
    init_simple_test("aS_BFu15s_BFu16s");
    static STRUCT_IF_C aS_BFu15s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "aS_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "aS_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu16s, aS_BFu15s_BFu16s)
//============================================================================



static void Test_aS_BFu15s_BFu17i()
{
  {
    init_simple_test("aS_BFu15s_BFu17i");
    static STRUCT_IF_C aS_BFu15s_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "aS_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "aS_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu17i, aS_BFu15s_BFu17i)
//============================================================================



static void Test_aS_BFu15s_BFu17ll()
{
  {
    init_simple_test("aS_BFu15s_BFu17ll");
    static STRUCT_IF_C aS_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "aS_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "aS_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu17ll, aS_BFu15s_BFu17ll)
//============================================================================



static void Test_aS_BFu15s_BFu1c()
{
  {
    init_simple_test("aS_BFu15s_BFu1c");
    static STRUCT_IF_C aS_BFu15s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aS_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu1c, aS_BFu15s_BFu1c)
//============================================================================



static void Test_aS_BFu15s_BFu1i()
{
  {
    init_simple_test("aS_BFu15s_BFu1i");
    static STRUCT_IF_C aS_BFu15s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aS_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu1i, aS_BFu15s_BFu1i)
//============================================================================



static void Test_aS_BFu15s_BFu1ll()
{
  {
    init_simple_test("aS_BFu15s_BFu1ll");
    static STRUCT_IF_C aS_BFu15s_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aS_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu1ll, aS_BFu15s_BFu1ll)
//============================================================================



static void Test_aS_BFu15s_BFu1s()
{
  {
    init_simple_test("aS_BFu15s_BFu1s");
    static STRUCT_IF_C aS_BFu15s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu15s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "aS_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu1s, aS_BFu15s_BFu1s)
//============================================================================



static void Test_aS_BFu15s_BFu31i()
{
  {
    init_simple_test("aS_BFu15s_BFu31i");
    static STRUCT_IF_C aS_BFu15s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "aS_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "aS_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu31i, aS_BFu15s_BFu31i)
//============================================================================



static void Test_aS_BFu15s_BFu31ll()
{
  {
    init_simple_test("aS_BFu15s_BFu31ll");
    static STRUCT_IF_C aS_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "aS_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "aS_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu31ll, aS_BFu15s_BFu31ll)
//============================================================================



static void Test_aS_BFu15s_BFu32i()
{
  {
    init_simple_test("aS_BFu15s_BFu32i");
    static STRUCT_IF_C aS_BFu15s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "aS_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "aS_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu32i, aS_BFu15s_BFu32i)
//============================================================================



static void Test_aS_BFu15s_BFu32ll()
{
  {
    init_simple_test("aS_BFu15s_BFu32ll");
    static STRUCT_IF_C aS_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "aS_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "aS_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu32ll, aS_BFu15s_BFu32ll)
//============================================================================



static void Test_aS_BFu15s_BFu33()
{
  {
    init_simple_test("aS_BFu15s_BFu33");
    static STRUCT_IF_C aS_BFu15s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "aS_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "aS_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu33, aS_BFu15s_BFu33)
//============================================================================



static void Test_aS_BFu15s_BFu7c()
{
  {
    init_simple_test("aS_BFu15s_BFu7c");
    static STRUCT_IF_C aS_BFu15s_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aS_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aS_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu7c, aS_BFu15s_BFu7c)
//============================================================================



static void Test_aS_BFu15s_BFu7i()
{
  {
    init_simple_test("aS_BFu15s_BFu7i");
    static STRUCT_IF_C aS_BFu15s_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aS_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aS_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu7i, aS_BFu15s_BFu7i)
//============================================================================



static void Test_aS_BFu15s_BFu7ll()
{
  {
    init_simple_test("aS_BFu15s_BFu7ll");
    static STRUCT_IF_C aS_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aS_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aS_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu7ll, aS_BFu15s_BFu7ll)
//============================================================================



static void Test_aS_BFu15s_BFu7s()
{
  {
    init_simple_test("aS_BFu15s_BFu7s");
    static STRUCT_IF_C aS_BFu15s_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "aS_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "aS_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu7s, aS_BFu15s_BFu7s)
//============================================================================



static void Test_aS_BFu15s_BFu8c()
{
  {
    init_simple_test("aS_BFu15s_BFu8c");
    static STRUCT_IF_C aS_BFu15s_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aS_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aS_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu8c, aS_BFu15s_BFu8c)
//============================================================================



static void Test_aS_BFu15s_BFu8i()
{
  {
    init_simple_test("aS_BFu15s_BFu8i");
    static STRUCT_IF_C aS_BFu15s_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aS_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aS_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu8i, aS_BFu15s_BFu8i)
//============================================================================



static void Test_aS_BFu15s_BFu8ll()
{
  {
    init_simple_test("aS_BFu15s_BFu8ll");
    static STRUCT_IF_C aS_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aS_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aS_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu8ll, aS_BFu15s_BFu8ll)
//============================================================================



static void Test_aS_BFu15s_BFu8s()
{
  {
    init_simple_test("aS_BFu15s_BFu8s");
    static STRUCT_IF_C aS_BFu15s_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "aS_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "aS_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu8s, aS_BFu15s_BFu8s)
//============================================================================



static void Test_aS_BFu15s_BFu9i()
{
  {
    init_simple_test("aS_BFu15s_BFu9i");
    static STRUCT_IF_C aS_BFu15s_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aS_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aS_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu9i, aS_BFu15s_BFu9i)
//============================================================================



static void Test_aS_BFu15s_BFu9ll()
{
  {
    init_simple_test("aS_BFu15s_BFu9ll");
    static STRUCT_IF_C aS_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aS_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aS_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu9ll, aS_BFu15s_BFu9ll)
//============================================================================



static void Test_aS_BFu15s_BFu9s()
{
  {
    init_simple_test("aS_BFu15s_BFu9s");
    static STRUCT_IF_C aS_BFu15s_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "aS_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "aS_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_BFu9s, aS_BFu15s_BFu9s)
//============================================================================



static void Test_aS_BFu15s_C()
{
  {
    init_simple_test("aS_BFu15s_C");
    static STRUCT_IF_C aS_BFu15s_C lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_C)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_C");
    check_field_offset(lv, v3, 4, "aS_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_C, aS_BFu15s_C)
//============================================================================



static void Test_aS_BFu15s_D()
{
  {
    init_simple_test("aS_BFu15s_D");
    static STRUCT_IF_C aS_BFu15s_D lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu15s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_D)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_D");
    check_field_offset(lv, v3, 4, "aS_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_D, aS_BFu15s_D)
//============================================================================



static void Test_aS_BFu15s_F()
{
  {
    init_simple_test("aS_BFu15s_F");
    static STRUCT_IF_C aS_BFu15s_F lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_F)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_F");
    check_field_offset(lv, v3, 4, "aS_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_F, aS_BFu15s_F)
//============================================================================



static void Test_aS_BFu15s_I()
{
  {
    init_simple_test("aS_BFu15s_I");
    static STRUCT_IF_C aS_BFu15s_I lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_I)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_I");
    check_field_offset(lv, v3, 4, "aS_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_I, aS_BFu15s_I)
//============================================================================



static void Test_aS_BFu15s_Ip()
{
  {
    init_simple_test("aS_BFu15s_Ip");
    static STRUCT_IF_C aS_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu15s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_Ip");
    check_field_offset(lv, v3, 4, "aS_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_Ip, aS_BFu15s_Ip)
//============================================================================



static void Test_aS_BFu15s_L()
{
  {
    init_simple_test("aS_BFu15s_L");
    static STRUCT_IF_C aS_BFu15s_L lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu15s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_L)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_L");
    check_field_offset(lv, v3, 4, "aS_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_L, aS_BFu15s_L)
//============================================================================



static void Test_aS_BFu15s_S()
{
  {
    init_simple_test("aS_BFu15s_S");
    static STRUCT_IF_C aS_BFu15s_S lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_S)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_S");
    check_field_offset(lv, v3, 4, "aS_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_S, aS_BFu15s_S)
//============================================================================



static void Test_aS_BFu15s_Uc()
{
  {
    init_simple_test("aS_BFu15s_Uc");
    static STRUCT_IF_C aS_BFu15s_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu15s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_Uc");
    check_field_offset(lv, v3, 4, "aS_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_Uc, aS_BFu15s_Uc)
//============================================================================



static void Test_aS_BFu15s_Ui()
{
  {
    init_simple_test("aS_BFu15s_Ui");
    static STRUCT_IF_C aS_BFu15s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu15s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_Ui");
    check_field_offset(lv, v3, 4, "aS_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_Ui, aS_BFu15s_Ui)
//============================================================================



static void Test_aS_BFu15s_Ul()
{
  {
    init_simple_test("aS_BFu15s_Ul");
    static STRUCT_IF_C aS_BFu15s_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu15s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_Ul");
    check_field_offset(lv, v3, 4, "aS_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_Ul, aS_BFu15s_Ul)
//============================================================================



static void Test_aS_BFu15s_Us()
{
  {
    init_simple_test("aS_BFu15s_Us");
    static STRUCT_IF_C aS_BFu15s_Us lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu15s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_Us");
    check_field_offset(lv, v3, 4, "aS_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_Us, aS_BFu15s_Us)
//============================================================================



static void Test_aS_BFu15s_Vp()
{
  {
    init_simple_test("aS_BFu15s_Vp");
    static STRUCT_IF_C aS_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu15s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "aS_BFu15s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "aS_BFu15s_Vp");
    check_field_offset(lv, v3, 4, "aS_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu15s_Vp, aS_BFu15s_Vp)
//============================================================================



static void Test_aS_BFu16i()
{
  {
    init_simple_test("aS_BFu16i");
    static STRUCT_IF_C aS_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i, aS_BFu16i)
//============================================================================



static void Test_aS_BFu16i_BFu15i()
{
  {
    init_simple_test("aS_BFu16i_BFu15i");
    static STRUCT_IF_C aS_BFu16i_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aS_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aS_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu15i, aS_BFu16i_BFu15i)
//============================================================================



static void Test_aS_BFu16i_BFu15ll()
{
  {
    init_simple_test("aS_BFu16i_BFu15ll");
    static STRUCT_IF_C aS_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aS_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aS_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu15ll, aS_BFu16i_BFu15ll)
//============================================================================



static void Test_aS_BFu16i_BFu15s()
{
  {
    init_simple_test("aS_BFu16i_BFu15s");
    static STRUCT_IF_C aS_BFu16i_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aS_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aS_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu15s, aS_BFu16i_BFu15s)
//============================================================================



static void Test_aS_BFu16i_BFu16i()
{
  {
    init_simple_test("aS_BFu16i_BFu16i");
    static STRUCT_IF_C aS_BFu16i_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aS_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu16i, aS_BFu16i_BFu16i)
//============================================================================



static void Test_aS_BFu16i_BFu16ll()
{
  {
    init_simple_test("aS_BFu16i_BFu16ll");
    static STRUCT_IF_C aS_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aS_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu16ll, aS_BFu16i_BFu16ll)
//============================================================================



static void Test_aS_BFu16i_BFu16s()
{
  {
    init_simple_test("aS_BFu16i_BFu16s");
    static STRUCT_IF_C aS_BFu16i_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aS_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu16s, aS_BFu16i_BFu16s)
//============================================================================



static void Test_aS_BFu16i_BFu17i()
{
  {
    init_simple_test("aS_BFu16i_BFu17i");
    static STRUCT_IF_C aS_BFu16i_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu16i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aS_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aS_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu17i, aS_BFu16i_BFu17i)
//============================================================================



static void Test_aS_BFu16i_BFu17ll()
{
  {
    init_simple_test("aS_BFu16i_BFu17ll");
    static STRUCT_IF_C aS_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu16i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aS_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aS_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu17ll, aS_BFu16i_BFu17ll)
//============================================================================



static void Test_aS_BFu16i_BFu1c()
{
  {
    init_simple_test("aS_BFu16i_BFu1c");
    static STRUCT_IF_C aS_BFu16i_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aS_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu1c, aS_BFu16i_BFu1c)
//============================================================================



static void Test_aS_BFu16i_BFu1i()
{
  {
    init_simple_test("aS_BFu16i_BFu1i");
    static STRUCT_IF_C aS_BFu16i_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aS_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu1i, aS_BFu16i_BFu1i)
//============================================================================



static void Test_aS_BFu16i_BFu1ll()
{
  {
    init_simple_test("aS_BFu16i_BFu1ll");
    static STRUCT_IF_C aS_BFu16i_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aS_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu1ll, aS_BFu16i_BFu1ll)
//============================================================================



static void Test_aS_BFu16i_BFu1s()
{
  {
    init_simple_test("aS_BFu16i_BFu1s");
    static STRUCT_IF_C aS_BFu16i_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aS_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu1s, aS_BFu16i_BFu1s)
//============================================================================



static void Test_aS_BFu16i_BFu31i()
{
  {
    init_simple_test("aS_BFu16i_BFu31i");
    static STRUCT_IF_C aS_BFu16i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aS_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aS_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu31i, aS_BFu16i_BFu31i)
//============================================================================



static void Test_aS_BFu16i_BFu31ll()
{
  {
    init_simple_test("aS_BFu16i_BFu31ll");
    static STRUCT_IF_C aS_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aS_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aS_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu31ll, aS_BFu16i_BFu31ll)
//============================================================================



static void Test_aS_BFu16i_BFu32i()
{
  {
    init_simple_test("aS_BFu16i_BFu32i");
    static STRUCT_IF_C aS_BFu16i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aS_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aS_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu32i, aS_BFu16i_BFu32i)
//============================================================================



static void Test_aS_BFu16i_BFu32ll()
{
  {
    init_simple_test("aS_BFu16i_BFu32ll");
    static STRUCT_IF_C aS_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aS_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aS_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu32ll, aS_BFu16i_BFu32ll)
//============================================================================



static void Test_aS_BFu16i_BFu33()
{
  {
    init_simple_test("aS_BFu16i_BFu33");
    static STRUCT_IF_C aS_BFu16i_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu16i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "aS_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "aS_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu33, aS_BFu16i_BFu33)
//============================================================================



static void Test_aS_BFu16i_BFu7c()
{
  {
    init_simple_test("aS_BFu16i_BFu7c");
    static STRUCT_IF_C aS_BFu16i_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aS_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aS_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu7c, aS_BFu16i_BFu7c)
//============================================================================



static void Test_aS_BFu16i_BFu7i()
{
  {
    init_simple_test("aS_BFu16i_BFu7i");
    static STRUCT_IF_C aS_BFu16i_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aS_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aS_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu7i, aS_BFu16i_BFu7i)
//============================================================================



static void Test_aS_BFu16i_BFu7ll()
{
  {
    init_simple_test("aS_BFu16i_BFu7ll");
    static STRUCT_IF_C aS_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aS_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aS_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu7ll, aS_BFu16i_BFu7ll)
//============================================================================



static void Test_aS_BFu16i_BFu7s()
{
  {
    init_simple_test("aS_BFu16i_BFu7s");
    static STRUCT_IF_C aS_BFu16i_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aS_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aS_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu7s, aS_BFu16i_BFu7s)
//============================================================================



static void Test_aS_BFu16i_BFu8c()
{
  {
    init_simple_test("aS_BFu16i_BFu8c");
    static STRUCT_IF_C aS_BFu16i_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aS_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aS_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu8c, aS_BFu16i_BFu8c)
//============================================================================



static void Test_aS_BFu16i_BFu8i()
{
  {
    init_simple_test("aS_BFu16i_BFu8i");
    static STRUCT_IF_C aS_BFu16i_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aS_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aS_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu8i, aS_BFu16i_BFu8i)
//============================================================================



static void Test_aS_BFu16i_BFu8ll()
{
  {
    init_simple_test("aS_BFu16i_BFu8ll");
    static STRUCT_IF_C aS_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aS_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aS_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu8ll, aS_BFu16i_BFu8ll)
//============================================================================



static void Test_aS_BFu16i_BFu8s()
{
  {
    init_simple_test("aS_BFu16i_BFu8s");
    static STRUCT_IF_C aS_BFu16i_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aS_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aS_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu8s, aS_BFu16i_BFu8s)
//============================================================================



static void Test_aS_BFu16i_BFu9i()
{
  {
    init_simple_test("aS_BFu16i_BFu9i");
    static STRUCT_IF_C aS_BFu16i_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aS_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aS_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu9i, aS_BFu16i_BFu9i)
//============================================================================



static void Test_aS_BFu16i_BFu9ll()
{
  {
    init_simple_test("aS_BFu16i_BFu9ll");
    static STRUCT_IF_C aS_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aS_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aS_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu9ll, aS_BFu16i_BFu9ll)
//============================================================================



static void Test_aS_BFu16i_BFu9s()
{
  {
    init_simple_test("aS_BFu16i_BFu9s");
    static STRUCT_IF_C aS_BFu16i_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aS_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aS_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_BFu9s, aS_BFu16i_BFu9s)
//============================================================================



static void Test_aS_BFu16i_C()
{
  {
    init_simple_test("aS_BFu16i_C");
    static STRUCT_IF_C aS_BFu16i_C lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_C)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_C");
    check_field_offset(lv, v3, 4, "aS_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_C, aS_BFu16i_C)
//============================================================================



static void Test_aS_BFu16i_D()
{
  {
    init_simple_test("aS_BFu16i_D");
    static STRUCT_IF_C aS_BFu16i_D lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu16i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_D)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_D");
    check_field_offset(lv, v3, 4, "aS_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_D, aS_BFu16i_D)
//============================================================================



static void Test_aS_BFu16i_F()
{
  {
    init_simple_test("aS_BFu16i_F");
    static STRUCT_IF_C aS_BFu16i_F lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_F)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_F");
    check_field_offset(lv, v3, 4, "aS_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_F, aS_BFu16i_F)
//============================================================================



static void Test_aS_BFu16i_I()
{
  {
    init_simple_test("aS_BFu16i_I");
    static STRUCT_IF_C aS_BFu16i_I lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_I)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_I");
    check_field_offset(lv, v3, 4, "aS_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_I, aS_BFu16i_I)
//============================================================================



static void Test_aS_BFu16i_Ip()
{
  {
    init_simple_test("aS_BFu16i_Ip");
    static STRUCT_IF_C aS_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu16i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_Ip");
    check_field_offset(lv, v3, 4, "aS_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_Ip, aS_BFu16i_Ip)
//============================================================================



static void Test_aS_BFu16i_L()
{
  {
    init_simple_test("aS_BFu16i_L");
    static STRUCT_IF_C aS_BFu16i_L lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu16i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_L)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_L");
    check_field_offset(lv, v3, 4, "aS_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_L, aS_BFu16i_L)
//============================================================================



static void Test_aS_BFu16i_S()
{
  {
    init_simple_test("aS_BFu16i_S");
    static STRUCT_IF_C aS_BFu16i_S lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_S)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_S");
    check_field_offset(lv, v3, 4, "aS_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_S, aS_BFu16i_S)
//============================================================================



static void Test_aS_BFu16i_Uc()
{
  {
    init_simple_test("aS_BFu16i_Uc");
    static STRUCT_IF_C aS_BFu16i_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_Uc");
    check_field_offset(lv, v3, 4, "aS_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_Uc, aS_BFu16i_Uc)
//============================================================================



static void Test_aS_BFu16i_Ui()
{
  {
    init_simple_test("aS_BFu16i_Ui");
    static STRUCT_IF_C aS_BFu16i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_Ui");
    check_field_offset(lv, v3, 4, "aS_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_Ui, aS_BFu16i_Ui)
//============================================================================



static void Test_aS_BFu16i_Ul()
{
  {
    init_simple_test("aS_BFu16i_Ul");
    static STRUCT_IF_C aS_BFu16i_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu16i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_Ul");
    check_field_offset(lv, v3, 4, "aS_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_Ul, aS_BFu16i_Ul)
//============================================================================



static void Test_aS_BFu16i_Us()
{
  {
    init_simple_test("aS_BFu16i_Us");
    static STRUCT_IF_C aS_BFu16i_Us lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_Us");
    check_field_offset(lv, v3, 4, "aS_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_Us, aS_BFu16i_Us)
//============================================================================



static void Test_aS_BFu16i_Vp()
{
  {
    init_simple_test("aS_BFu16i_Vp");
    static STRUCT_IF_C aS_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu16i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16i_Vp");
    check_field_offset(lv, v3, 4, "aS_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16i_Vp, aS_BFu16i_Vp)
//============================================================================



static void Test_aS_BFu16ll()
{
  {
    init_simple_test("aS_BFu16ll");
    static STRUCT_IF_C aS_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll, aS_BFu16ll)
//============================================================================



static void Test_aS_BFu16ll_BFu15i()
{
  {
    init_simple_test("aS_BFu16ll_BFu15i");
    static STRUCT_IF_C aS_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aS_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aS_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu15i, aS_BFu16ll_BFu15i)
//============================================================================



static void Test_aS_BFu16ll_BFu15ll()
{
  {
    init_simple_test("aS_BFu16ll_BFu15ll");
    static STRUCT_IF_C aS_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aS_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aS_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu15ll, aS_BFu16ll_BFu15ll)
//============================================================================



static void Test_aS_BFu16ll_BFu15s()
{
  {
    init_simple_test("aS_BFu16ll_BFu15s");
    static STRUCT_IF_C aS_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aS_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aS_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu15s, aS_BFu16ll_BFu15s)
//============================================================================



static void Test_aS_BFu16ll_BFu16i()
{
  {
    init_simple_test("aS_BFu16ll_BFu16i");
    static STRUCT_IF_C aS_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aS_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu16i, aS_BFu16ll_BFu16i)
//============================================================================



static void Test_aS_BFu16ll_BFu16ll()
{
  {
    init_simple_test("aS_BFu16ll_BFu16ll");
    static STRUCT_IF_C aS_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aS_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu16ll, aS_BFu16ll_BFu16ll)
//============================================================================



static void Test_aS_BFu16ll_BFu16s()
{
  {
    init_simple_test("aS_BFu16ll_BFu16s");
    static STRUCT_IF_C aS_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aS_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu16s, aS_BFu16ll_BFu16s)
//============================================================================



static void Test_aS_BFu16ll_BFu17i()
{
  {
    init_simple_test("aS_BFu16ll_BFu17i");
    static STRUCT_IF_C aS_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu16ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aS_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aS_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu17i, aS_BFu16ll_BFu17i)
//============================================================================



static void Test_aS_BFu16ll_BFu17ll()
{
  {
    init_simple_test("aS_BFu16ll_BFu17ll");
    static STRUCT_IF_C aS_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aS_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aS_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu17ll, aS_BFu16ll_BFu17ll)
//============================================================================



static void Test_aS_BFu16ll_BFu1c()
{
  {
    init_simple_test("aS_BFu16ll_BFu1c");
    static STRUCT_IF_C aS_BFu16ll_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aS_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu1c, aS_BFu16ll_BFu1c)
//============================================================================



static void Test_aS_BFu16ll_BFu1i()
{
  {
    init_simple_test("aS_BFu16ll_BFu1i");
    static STRUCT_IF_C aS_BFu16ll_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aS_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu1i, aS_BFu16ll_BFu1i)
//============================================================================



static void Test_aS_BFu16ll_BFu1ll()
{
  {
    init_simple_test("aS_BFu16ll_BFu1ll");
    static STRUCT_IF_C aS_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aS_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu1ll, aS_BFu16ll_BFu1ll)
//============================================================================



static void Test_aS_BFu16ll_BFu1s()
{
  {
    init_simple_test("aS_BFu16ll_BFu1s");
    static STRUCT_IF_C aS_BFu16ll_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aS_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu1s, aS_BFu16ll_BFu1s)
//============================================================================



static void Test_aS_BFu16ll_BFu31i()
{
  {
    init_simple_test("aS_BFu16ll_BFu31i");
    static STRUCT_IF_C aS_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aS_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aS_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu31i, aS_BFu16ll_BFu31i)
//============================================================================



static void Test_aS_BFu16ll_BFu31ll()
{
  {
    init_simple_test("aS_BFu16ll_BFu31ll");
    static STRUCT_IF_C aS_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aS_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aS_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu31ll, aS_BFu16ll_BFu31ll)
//============================================================================



static void Test_aS_BFu16ll_BFu32i()
{
  {
    init_simple_test("aS_BFu16ll_BFu32i");
    static STRUCT_IF_C aS_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aS_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aS_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu32i, aS_BFu16ll_BFu32i)
//============================================================================



static void Test_aS_BFu16ll_BFu32ll()
{
  {
    init_simple_test("aS_BFu16ll_BFu32ll");
    static STRUCT_IF_C aS_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aS_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aS_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu32ll, aS_BFu16ll_BFu32ll)
//============================================================================



static void Test_aS_BFu16ll_BFu33()
{
  {
    init_simple_test("aS_BFu16ll_BFu33");
    static STRUCT_IF_C aS_BFu16ll_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu16ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "aS_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "aS_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu33, aS_BFu16ll_BFu33)
//============================================================================



static void Test_aS_BFu16ll_BFu7c()
{
  {
    init_simple_test("aS_BFu16ll_BFu7c");
    static STRUCT_IF_C aS_BFu16ll_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aS_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aS_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu7c, aS_BFu16ll_BFu7c)
//============================================================================



static void Test_aS_BFu16ll_BFu7i()
{
  {
    init_simple_test("aS_BFu16ll_BFu7i");
    static STRUCT_IF_C aS_BFu16ll_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aS_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aS_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu7i, aS_BFu16ll_BFu7i)
//============================================================================



static void Test_aS_BFu16ll_BFu7ll()
{
  {
    init_simple_test("aS_BFu16ll_BFu7ll");
    static STRUCT_IF_C aS_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aS_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aS_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu7ll, aS_BFu16ll_BFu7ll)
//============================================================================



static void Test_aS_BFu16ll_BFu7s()
{
  {
    init_simple_test("aS_BFu16ll_BFu7s");
    static STRUCT_IF_C aS_BFu16ll_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aS_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aS_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu7s, aS_BFu16ll_BFu7s)
//============================================================================



static void Test_aS_BFu16ll_BFu8c()
{
  {
    init_simple_test("aS_BFu16ll_BFu8c");
    static STRUCT_IF_C aS_BFu16ll_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aS_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aS_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu8c, aS_BFu16ll_BFu8c)
//============================================================================



static void Test_aS_BFu16ll_BFu8i()
{
  {
    init_simple_test("aS_BFu16ll_BFu8i");
    static STRUCT_IF_C aS_BFu16ll_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aS_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aS_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu8i, aS_BFu16ll_BFu8i)
//============================================================================



static void Test_aS_BFu16ll_BFu8ll()
{
  {
    init_simple_test("aS_BFu16ll_BFu8ll");
    static STRUCT_IF_C aS_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aS_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aS_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu8ll, aS_BFu16ll_BFu8ll)
//============================================================================



static void Test_aS_BFu16ll_BFu8s()
{
  {
    init_simple_test("aS_BFu16ll_BFu8s");
    static STRUCT_IF_C aS_BFu16ll_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aS_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aS_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu8s, aS_BFu16ll_BFu8s)
//============================================================================



static void Test_aS_BFu16ll_BFu9i()
{
  {
    init_simple_test("aS_BFu16ll_BFu9i");
    static STRUCT_IF_C aS_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aS_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aS_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu9i, aS_BFu16ll_BFu9i)
//============================================================================



static void Test_aS_BFu16ll_BFu9ll()
{
  {
    init_simple_test("aS_BFu16ll_BFu9ll");
    static STRUCT_IF_C aS_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aS_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aS_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu9ll, aS_BFu16ll_BFu9ll)
//============================================================================



static void Test_aS_BFu16ll_BFu9s()
{
  {
    init_simple_test("aS_BFu16ll_BFu9s");
    static STRUCT_IF_C aS_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aS_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aS_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_BFu9s, aS_BFu16ll_BFu9s)
//============================================================================



static void Test_aS_BFu16ll_C()
{
  {
    init_simple_test("aS_BFu16ll_C");
    static STRUCT_IF_C aS_BFu16ll_C lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_C");
    check_field_offset(lv, v3, 4, "aS_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_C, aS_BFu16ll_C)
//============================================================================



static void Test_aS_BFu16ll_D()
{
  {
    init_simple_test("aS_BFu16ll_D");
    static STRUCT_IF_C aS_BFu16ll_D lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu16ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_D");
    check_field_offset(lv, v3, 4, "aS_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_D, aS_BFu16ll_D)
//============================================================================



static void Test_aS_BFu16ll_F()
{
  {
    init_simple_test("aS_BFu16ll_F");
    static STRUCT_IF_C aS_BFu16ll_F lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_F");
    check_field_offset(lv, v3, 4, "aS_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_F, aS_BFu16ll_F)
//============================================================================



static void Test_aS_BFu16ll_I()
{
  {
    init_simple_test("aS_BFu16ll_I");
    static STRUCT_IF_C aS_BFu16ll_I lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_I");
    check_field_offset(lv, v3, 4, "aS_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_I, aS_BFu16ll_I)
//============================================================================



static void Test_aS_BFu16ll_Ip()
{
  {
    init_simple_test("aS_BFu16ll_Ip");
    static STRUCT_IF_C aS_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu16ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_Ip");
    check_field_offset(lv, v3, 4, "aS_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_Ip, aS_BFu16ll_Ip)
//============================================================================



static void Test_aS_BFu16ll_L()
{
  {
    init_simple_test("aS_BFu16ll_L");
    static STRUCT_IF_C aS_BFu16ll_L lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu16ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_L");
    check_field_offset(lv, v3, 4, "aS_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_L, aS_BFu16ll_L)
//============================================================================



static void Test_aS_BFu16ll_S()
{
  {
    init_simple_test("aS_BFu16ll_S");
    static STRUCT_IF_C aS_BFu16ll_S lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_S");
    check_field_offset(lv, v3, 4, "aS_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_S, aS_BFu16ll_S)
//============================================================================



static void Test_aS_BFu16ll_Uc()
{
  {
    init_simple_test("aS_BFu16ll_Uc");
    static STRUCT_IF_C aS_BFu16ll_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_Uc");
    check_field_offset(lv, v3, 4, "aS_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_Uc, aS_BFu16ll_Uc)
//============================================================================



static void Test_aS_BFu16ll_Ui()
{
  {
    init_simple_test("aS_BFu16ll_Ui");
    static STRUCT_IF_C aS_BFu16ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_Ui");
    check_field_offset(lv, v3, 4, "aS_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_Ui, aS_BFu16ll_Ui)
//============================================================================



static void Test_aS_BFu16ll_Ul()
{
  {
    init_simple_test("aS_BFu16ll_Ul");
    static STRUCT_IF_C aS_BFu16ll_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu16ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_Ul");
    check_field_offset(lv, v3, 4, "aS_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_Ul, aS_BFu16ll_Ul)
//============================================================================



static void Test_aS_BFu16ll_Us()
{
  {
    init_simple_test("aS_BFu16ll_Us");
    static STRUCT_IF_C aS_BFu16ll_Us lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_Us");
    check_field_offset(lv, v3, 4, "aS_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_Us, aS_BFu16ll_Us)
//============================================================================



static void Test_aS_BFu16ll_Vp()
{
  {
    init_simple_test("aS_BFu16ll_Vp");
    static STRUCT_IF_C aS_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu16ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16ll_Vp");
    check_field_offset(lv, v3, 4, "aS_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16ll_Vp, aS_BFu16ll_Vp)
//============================================================================



static void Test_aS_BFu16s()
{
  {
    init_simple_test("aS_BFu16s");
    static STRUCT_IF_C aS_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s, aS_BFu16s)
//============================================================================



static void Test_aS_BFu16s_BFu15i()
{
  {
    init_simple_test("aS_BFu16s_BFu15i");
    static STRUCT_IF_C aS_BFu16s_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aS_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aS_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu15i, aS_BFu16s_BFu15i)
//============================================================================



static void Test_aS_BFu16s_BFu15ll()
{
  {
    init_simple_test("aS_BFu16s_BFu15ll");
    static STRUCT_IF_C aS_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aS_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aS_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu15ll, aS_BFu16s_BFu15ll)
//============================================================================



static void Test_aS_BFu16s_BFu15s()
{
  {
    init_simple_test("aS_BFu16s_BFu15s");
    static STRUCT_IF_C aS_BFu16s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "aS_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "aS_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu15s, aS_BFu16s_BFu15s)
//============================================================================



static void Test_aS_BFu16s_BFu16i()
{
  {
    init_simple_test("aS_BFu16s_BFu16i");
    static STRUCT_IF_C aS_BFu16s_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aS_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu16i, aS_BFu16s_BFu16i)
//============================================================================



static void Test_aS_BFu16s_BFu16ll()
{
  {
    init_simple_test("aS_BFu16s_BFu16ll");
    static STRUCT_IF_C aS_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aS_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu16ll, aS_BFu16s_BFu16ll)
//============================================================================



static void Test_aS_BFu16s_BFu16s()
{
  {
    init_simple_test("aS_BFu16s_BFu16s");
    static STRUCT_IF_C aS_BFu16s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "aS_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu16s, aS_BFu16s_BFu16s)
//============================================================================



static void Test_aS_BFu16s_BFu17i()
{
  {
    init_simple_test("aS_BFu16s_BFu17i");
    static STRUCT_IF_C aS_BFu16s_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu16s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aS_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aS_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu17i, aS_BFu16s_BFu17i)
//============================================================================



static void Test_aS_BFu16s_BFu17ll()
{
  {
    init_simple_test("aS_BFu16s_BFu17ll");
    static STRUCT_IF_C aS_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu16s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "aS_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "aS_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu17ll, aS_BFu16s_BFu17ll)
//============================================================================



static void Test_aS_BFu16s_BFu1c()
{
  {
    init_simple_test("aS_BFu16s_BFu1c");
    static STRUCT_IF_C aS_BFu16s_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aS_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu1c, aS_BFu16s_BFu1c)
//============================================================================



static void Test_aS_BFu16s_BFu1i()
{
  {
    init_simple_test("aS_BFu16s_BFu1i");
    static STRUCT_IF_C aS_BFu16s_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aS_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu1i, aS_BFu16s_BFu1i)
//============================================================================



static void Test_aS_BFu16s_BFu1ll()
{
  {
    init_simple_test("aS_BFu16s_BFu1ll");
    static STRUCT_IF_C aS_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aS_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu1ll, aS_BFu16s_BFu1ll)
//============================================================================



static void Test_aS_BFu16s_BFu1s()
{
  {
    init_simple_test("aS_BFu16s_BFu1s");
    static STRUCT_IF_C aS_BFu16s_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "aS_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu1s, aS_BFu16s_BFu1s)
//============================================================================



static void Test_aS_BFu16s_BFu31i()
{
  {
    init_simple_test("aS_BFu16s_BFu31i");
    static STRUCT_IF_C aS_BFu16s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aS_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aS_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu31i, aS_BFu16s_BFu31i)
//============================================================================



static void Test_aS_BFu16s_BFu31ll()
{
  {
    init_simple_test("aS_BFu16s_BFu31ll");
    static STRUCT_IF_C aS_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "aS_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "aS_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu31ll, aS_BFu16s_BFu31ll)
//============================================================================



static void Test_aS_BFu16s_BFu32i()
{
  {
    init_simple_test("aS_BFu16s_BFu32i");
    static STRUCT_IF_C aS_BFu16s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aS_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aS_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu32i, aS_BFu16s_BFu32i)
//============================================================================



static void Test_aS_BFu16s_BFu32ll()
{
  {
    init_simple_test("aS_BFu16s_BFu32ll");
    static STRUCT_IF_C aS_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "aS_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "aS_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu32ll, aS_BFu16s_BFu32ll)
//============================================================================



static void Test_aS_BFu16s_BFu33()
{
  {
    init_simple_test("aS_BFu16s_BFu33");
    static STRUCT_IF_C aS_BFu16s_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu16s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, 1, "aS_BFu16s_BFu33");
    set_bf_and_test(lv, v3, 4, 0, 33, hide_ull(1LL<<32), "aS_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu33, aS_BFu16s_BFu33)
//============================================================================



static void Test_aS_BFu16s_BFu7c()
{
  {
    init_simple_test("aS_BFu16s_BFu7c");
    static STRUCT_IF_C aS_BFu16s_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aS_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aS_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu7c, aS_BFu16s_BFu7c)
//============================================================================



static void Test_aS_BFu16s_BFu7i()
{
  {
    init_simple_test("aS_BFu16s_BFu7i");
    static STRUCT_IF_C aS_BFu16s_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aS_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aS_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu7i, aS_BFu16s_BFu7i)
//============================================================================



static void Test_aS_BFu16s_BFu7ll()
{
  {
    init_simple_test("aS_BFu16s_BFu7ll");
    static STRUCT_IF_C aS_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aS_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aS_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu7ll, aS_BFu16s_BFu7ll)
//============================================================================



static void Test_aS_BFu16s_BFu7s()
{
  {
    init_simple_test("aS_BFu16s_BFu7s");
    static STRUCT_IF_C aS_BFu16s_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "aS_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "aS_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu7s, aS_BFu16s_BFu7s)
//============================================================================



static void Test_aS_BFu16s_BFu8c()
{
  {
    init_simple_test("aS_BFu16s_BFu8c");
    static STRUCT_IF_C aS_BFu16s_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aS_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aS_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu8c, aS_BFu16s_BFu8c)
//============================================================================



static void Test_aS_BFu16s_BFu8i()
{
  {
    init_simple_test("aS_BFu16s_BFu8i");
    static STRUCT_IF_C aS_BFu16s_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aS_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aS_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu8i, aS_BFu16s_BFu8i)
//============================================================================



static void Test_aS_BFu16s_BFu8ll()
{
  {
    init_simple_test("aS_BFu16s_BFu8ll");
    static STRUCT_IF_C aS_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aS_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aS_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu8ll, aS_BFu16s_BFu8ll)
//============================================================================



static void Test_aS_BFu16s_BFu8s()
{
  {
    init_simple_test("aS_BFu16s_BFu8s");
    static STRUCT_IF_C aS_BFu16s_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "aS_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "aS_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu8s, aS_BFu16s_BFu8s)
//============================================================================



static void Test_aS_BFu16s_BFu9i()
{
  {
    init_simple_test("aS_BFu16s_BFu9i");
    static STRUCT_IF_C aS_BFu16s_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aS_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aS_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu9i, aS_BFu16s_BFu9i)
//============================================================================



static void Test_aS_BFu16s_BFu9ll()
{
  {
    init_simple_test("aS_BFu16s_BFu9ll");
    static STRUCT_IF_C aS_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aS_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aS_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu9ll, aS_BFu16s_BFu9ll)
//============================================================================



static void Test_aS_BFu16s_BFu9s()
{
  {
    init_simple_test("aS_BFu16s_BFu9s");
    static STRUCT_IF_C aS_BFu16s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "aS_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "aS_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_BFu9s, aS_BFu16s_BFu9s)
//============================================================================



static void Test_aS_BFu16s_C()
{
  {
    init_simple_test("aS_BFu16s_C");
    static STRUCT_IF_C aS_BFu16s_C lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_C)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_C");
    check_field_offset(lv, v3, 4, "aS_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_C, aS_BFu16s_C)
//============================================================================



static void Test_aS_BFu16s_D()
{
  {
    init_simple_test("aS_BFu16s_D");
    static STRUCT_IF_C aS_BFu16s_D lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu16s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_D)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_D");
    check_field_offset(lv, v3, 4, "aS_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_D, aS_BFu16s_D)
//============================================================================



static void Test_aS_BFu16s_F()
{
  {
    init_simple_test("aS_BFu16s_F");
    static STRUCT_IF_C aS_BFu16s_F lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_F)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_F");
    check_field_offset(lv, v3, 4, "aS_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_F, aS_BFu16s_F)
//============================================================================



static void Test_aS_BFu16s_I()
{
  {
    init_simple_test("aS_BFu16s_I");
    static STRUCT_IF_C aS_BFu16s_I lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_I)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_I");
    check_field_offset(lv, v3, 4, "aS_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_I, aS_BFu16s_I)
//============================================================================



static void Test_aS_BFu16s_Ip()
{
  {
    init_simple_test("aS_BFu16s_Ip");
    static STRUCT_IF_C aS_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu16s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_Ip");
    check_field_offset(lv, v3, 4, "aS_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_Ip, aS_BFu16s_Ip)
//============================================================================



static void Test_aS_BFu16s_L()
{
  {
    init_simple_test("aS_BFu16s_L");
    static STRUCT_IF_C aS_BFu16s_L lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu16s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_L)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_L");
    check_field_offset(lv, v3, 4, "aS_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_L, aS_BFu16s_L)
//============================================================================



static void Test_aS_BFu16s_S()
{
  {
    init_simple_test("aS_BFu16s_S");
    static STRUCT_IF_C aS_BFu16s_S lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_S)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_S");
    check_field_offset(lv, v3, 4, "aS_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_S, aS_BFu16s_S)
//============================================================================



static void Test_aS_BFu16s_Uc()
{
  {
    init_simple_test("aS_BFu16s_Uc");
    static STRUCT_IF_C aS_BFu16s_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu16s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_Uc");
    check_field_offset(lv, v3, 4, "aS_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_Uc, aS_BFu16s_Uc)
//============================================================================



static void Test_aS_BFu16s_Ui()
{
  {
    init_simple_test("aS_BFu16s_Ui");
    static STRUCT_IF_C aS_BFu16s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu16s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_Ui");
    check_field_offset(lv, v3, 4, "aS_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_Ui, aS_BFu16s_Ui)
//============================================================================



static void Test_aS_BFu16s_Ul()
{
  {
    init_simple_test("aS_BFu16s_Ul");
    static STRUCT_IF_C aS_BFu16s_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aS_BFu16s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_Ul");
    check_field_offset(lv, v3, 4, "aS_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_Ul, aS_BFu16s_Ul)
//============================================================================



static void Test_aS_BFu16s_Us()
{
  {
    init_simple_test("aS_BFu16s_Us");
    static STRUCT_IF_C aS_BFu16s_Us lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu16s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_Us");
    check_field_offset(lv, v3, 4, "aS_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_Us, aS_BFu16s_Us)
//============================================================================



static void Test_aS_BFu16s_Vp()
{
  {
    init_simple_test("aS_BFu16s_Vp");
    static STRUCT_IF_C aS_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aS_BFu16s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "aS_BFu16s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "aS_BFu16s_Vp");
    check_field_offset(lv, v3, 4, "aS_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu16s_Vp, aS_BFu16s_Vp)
//============================================================================



static void Test_aS_BFu17i()
{
  {
    init_simple_test("aS_BFu17i");
    static STRUCT_IF_C aS_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i, aS_BFu17i)
//============================================================================



static void Test_aS_BFu17i_BFu15i()
{
  {
    init_simple_test("aS_BFu17i_BFu15i");
    static STRUCT_IF_C aS_BFu17i_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aS_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aS_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu15i, aS_BFu17i_BFu15i)
//============================================================================



static void Test_aS_BFu17i_BFu15ll()
{
  {
    init_simple_test("aS_BFu17i_BFu15ll");
    static STRUCT_IF_C aS_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aS_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aS_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu15ll, aS_BFu17i_BFu15ll)
//============================================================================



static void Test_aS_BFu17i_BFu15s()
{
  {
    init_simple_test("aS_BFu17i_BFu15s");
    static STRUCT_IF_C aS_BFu17i_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aS_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aS_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu15s, aS_BFu17i_BFu15s)
//============================================================================



static void Test_aS_BFu17i_BFu16i()
{
  {
    init_simple_test("aS_BFu17i_BFu16i");
    static STRUCT_IF_C aS_BFu17i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aS_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aS_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu16i, aS_BFu17i_BFu16i)
//============================================================================



static void Test_aS_BFu17i_BFu16ll()
{
  {
    init_simple_test("aS_BFu17i_BFu16ll");
    static STRUCT_IF_C aS_BFu17i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aS_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aS_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu16ll, aS_BFu17i_BFu16ll)
//============================================================================



static void Test_aS_BFu17i_BFu16s()
{
  {
    init_simple_test("aS_BFu17i_BFu16s");
    static STRUCT_IF_C aS_BFu17i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aS_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aS_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu16s, aS_BFu17i_BFu16s)
//============================================================================



static void Test_aS_BFu17i_BFu17i()
{
  {
    init_simple_test("aS_BFu17i_BFu17i");
    static STRUCT_IF_C aS_BFu17i_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aS_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu17i, aS_BFu17i_BFu17i)
//============================================================================



static void Test_aS_BFu17i_BFu17ll()
{
  {
    init_simple_test("aS_BFu17i_BFu17ll");
    static STRUCT_IF_C aS_BFu17i_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aS_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu17ll, aS_BFu17i_BFu17ll)
//============================================================================



static void Test_aS_BFu17i_BFu1c()
{
  {
    init_simple_test("aS_BFu17i_BFu1c");
    static STRUCT_IF_C aS_BFu17i_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aS_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu1c, aS_BFu17i_BFu1c)
//============================================================================



static void Test_aS_BFu17i_BFu1i()
{
  {
    init_simple_test("aS_BFu17i_BFu1i");
    static STRUCT_IF_C aS_BFu17i_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aS_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu1i, aS_BFu17i_BFu1i)
//============================================================================



static void Test_aS_BFu17i_BFu1ll()
{
  {
    init_simple_test("aS_BFu17i_BFu1ll");
    static STRUCT_IF_C aS_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aS_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu1ll, aS_BFu17i_BFu1ll)
//============================================================================



static void Test_aS_BFu17i_BFu1s()
{
  {
    init_simple_test("aS_BFu17i_BFu1s");
    static STRUCT_IF_C aS_BFu17i_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aS_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu1s, aS_BFu17i_BFu1s)
//============================================================================



static void Test_aS_BFu17i_BFu31i()
{
  {
    init_simple_test("aS_BFu17i_BFu31i");
    static STRUCT_IF_C aS_BFu17i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu17i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aS_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aS_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu31i, aS_BFu17i_BFu31i)
//============================================================================



static void Test_aS_BFu17i_BFu31ll()
{
  {
    init_simple_test("aS_BFu17i_BFu31ll");
    static STRUCT_IF_C aS_BFu17i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu17i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aS_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aS_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu31ll, aS_BFu17i_BFu31ll)
//============================================================================



static void Test_aS_BFu17i_BFu32i()
{
  {
    init_simple_test("aS_BFu17i_BFu32i");
    static STRUCT_IF_C aS_BFu17i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu17i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aS_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aS_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu32i, aS_BFu17i_BFu32i)
//============================================================================



static void Test_aS_BFu17i_BFu32ll()
{
  {
    init_simple_test("aS_BFu17i_BFu32ll");
    static STRUCT_IF_C aS_BFu17i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu17i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aS_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aS_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu32ll, aS_BFu17i_BFu32ll)
//============================================================================



static void Test_aS_BFu17i_BFu33()
{
  {
    init_simple_test("aS_BFu17i_BFu33");
    static STRUCT_IF_C aS_BFu17i_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu17i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "aS_BFu17i_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "aS_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu33, aS_BFu17i_BFu33)
//============================================================================



static void Test_aS_BFu17i_BFu7c()
{
  {
    init_simple_test("aS_BFu17i_BFu7c");
    static STRUCT_IF_C aS_BFu17i_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aS_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aS_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu7c, aS_BFu17i_BFu7c)
//============================================================================



static void Test_aS_BFu17i_BFu7i()
{
  {
    init_simple_test("aS_BFu17i_BFu7i");
    static STRUCT_IF_C aS_BFu17i_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aS_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aS_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu7i, aS_BFu17i_BFu7i)
//============================================================================



static void Test_aS_BFu17i_BFu7ll()
{
  {
    init_simple_test("aS_BFu17i_BFu7ll");
    static STRUCT_IF_C aS_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aS_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aS_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu7ll, aS_BFu17i_BFu7ll)
//============================================================================



static void Test_aS_BFu17i_BFu7s()
{
  {
    init_simple_test("aS_BFu17i_BFu7s");
    static STRUCT_IF_C aS_BFu17i_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aS_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aS_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu7s, aS_BFu17i_BFu7s)
//============================================================================



static void Test_aS_BFu17i_BFu8c()
{
  {
    init_simple_test("aS_BFu17i_BFu8c");
    static STRUCT_IF_C aS_BFu17i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aS_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aS_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu8c, aS_BFu17i_BFu8c)
//============================================================================



static void Test_aS_BFu17i_BFu8i()
{
  {
    init_simple_test("aS_BFu17i_BFu8i");
    static STRUCT_IF_C aS_BFu17i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aS_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aS_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu8i, aS_BFu17i_BFu8i)
//============================================================================



static void Test_aS_BFu17i_BFu8ll()
{
  {
    init_simple_test("aS_BFu17i_BFu8ll");
    static STRUCT_IF_C aS_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aS_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aS_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu8ll, aS_BFu17i_BFu8ll)
//============================================================================



static void Test_aS_BFu17i_BFu8s()
{
  {
    init_simple_test("aS_BFu17i_BFu8s");
    static STRUCT_IF_C aS_BFu17i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aS_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aS_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu8s, aS_BFu17i_BFu8s)
//============================================================================



static void Test_aS_BFu17i_BFu9i()
{
  {
    init_simple_test("aS_BFu17i_BFu9i");
    static STRUCT_IF_C aS_BFu17i_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aS_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aS_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu9i, aS_BFu17i_BFu9i)
//============================================================================



static void Test_aS_BFu17i_BFu9ll()
{
  {
    init_simple_test("aS_BFu17i_BFu9ll");
    static STRUCT_IF_C aS_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aS_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aS_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu9ll, aS_BFu17i_BFu9ll)
//============================================================================



static void Test_aS_BFu17i_BFu9s()
{
  {
    init_simple_test("aS_BFu17i_BFu9s");
    static STRUCT_IF_C aS_BFu17i_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aS_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aS_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_BFu9s, aS_BFu17i_BFu9s)
//============================================================================



static void Test_aS_BFu17i_C()
{
  {
    init_simple_test("aS_BFu17i_C");
    static STRUCT_IF_C aS_BFu17i_C lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_C)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_C");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_C");
    check_field_offset(lv, v3, 5, "aS_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_C, aS_BFu17i_C)
//============================================================================



static void Test_aS_BFu17i_D()
{
  {
    init_simple_test("aS_BFu17i_D");
    static STRUCT_IF_C aS_BFu17i_D lv;
    check2(sizeof(lv), 13, "sizeof(aS_BFu17i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_D)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_D");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_D");
    check_field_offset(lv, v3, 5, "aS_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_D, aS_BFu17i_D)
//============================================================================



static void Test_aS_BFu17i_F()
{
  {
    init_simple_test("aS_BFu17i_F");
    static STRUCT_IF_C aS_BFu17i_F lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu17i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_F)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_F");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_F");
    check_field_offset(lv, v3, 5, "aS_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_F, aS_BFu17i_F)
//============================================================================



static void Test_aS_BFu17i_I()
{
  {
    init_simple_test("aS_BFu17i_I");
    static STRUCT_IF_C aS_BFu17i_I lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu17i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_I)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_I");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_I");
    check_field_offset(lv, v3, 5, "aS_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_I, aS_BFu17i_I)
//============================================================================



static void Test_aS_BFu17i_Ip()
{
  {
    init_simple_test("aS_BFu17i_Ip");
    static STRUCT_IF_C aS_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aS_BFu17i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_Ip");
    check_field_offset(lv, v3, 5, "aS_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_Ip, aS_BFu17i_Ip)
//============================================================================



static void Test_aS_BFu17i_L()
{
  {
    init_simple_test("aS_BFu17i_L");
    static STRUCT_IF_C aS_BFu17i_L lv;
    check2(sizeof(lv), 13, "sizeof(aS_BFu17i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_L)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_L");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_L");
    check_field_offset(lv, v3, 5, "aS_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_L, aS_BFu17i_L)
//============================================================================



static void Test_aS_BFu17i_S()
{
  {
    init_simple_test("aS_BFu17i_S");
    static STRUCT_IF_C aS_BFu17i_S lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_S)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_S");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_S");
    check_field_offset(lv, v3, 5, "aS_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_S, aS_BFu17i_S)
//============================================================================



static void Test_aS_BFu17i_Uc()
{
  {
    init_simple_test("aS_BFu17i_Uc");
    static STRUCT_IF_C aS_BFu17i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_Uc");
    check_field_offset(lv, v3, 5, "aS_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_Uc, aS_BFu17i_Uc)
//============================================================================



static void Test_aS_BFu17i_Ui()
{
  {
    init_simple_test("aS_BFu17i_Ui");
    static STRUCT_IF_C aS_BFu17i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu17i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_Ui");
    check_field_offset(lv, v3, 5, "aS_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_Ui, aS_BFu17i_Ui)
//============================================================================



static void Test_aS_BFu17i_Ul()
{
  {
    init_simple_test("aS_BFu17i_Ul");
    static STRUCT_IF_C aS_BFu17i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aS_BFu17i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_Ul");
    check_field_offset(lv, v3, 5, "aS_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_Ul, aS_BFu17i_Ul)
//============================================================================



static void Test_aS_BFu17i_Us()
{
  {
    init_simple_test("aS_BFu17i_Us");
    static STRUCT_IF_C aS_BFu17i_Us lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_Us");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_Us");
    check_field_offset(lv, v3, 5, "aS_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_Us, aS_BFu17i_Us)
//============================================================================



static void Test_aS_BFu17i_Vp()
{
  {
    init_simple_test("aS_BFu17i_Vp");
    static STRUCT_IF_C aS_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aS_BFu17i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17i_Vp");
    check_field_offset(lv, v3, 5, "aS_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17i_Vp, aS_BFu17i_Vp)
//============================================================================



static void Test_aS_BFu17ll()
{
  {
    init_simple_test("aS_BFu17ll");
    static STRUCT_IF_C aS_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll, aS_BFu17ll)
//============================================================================



static void Test_aS_BFu17ll_BFu15i()
{
  {
    init_simple_test("aS_BFu17ll_BFu15i");
    static STRUCT_IF_C aS_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aS_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aS_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu15i, aS_BFu17ll_BFu15i)
//============================================================================



static void Test_aS_BFu17ll_BFu15ll()
{
  {
    init_simple_test("aS_BFu17ll_BFu15ll");
    static STRUCT_IF_C aS_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aS_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aS_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu15ll, aS_BFu17ll_BFu15ll)
//============================================================================



static void Test_aS_BFu17ll_BFu15s()
{
  {
    init_simple_test("aS_BFu17ll_BFu15s");
    static STRUCT_IF_C aS_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aS_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aS_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu15s, aS_BFu17ll_BFu15s)
//============================================================================



static void Test_aS_BFu17ll_BFu16i()
{
  {
    init_simple_test("aS_BFu17ll_BFu16i");
    static STRUCT_IF_C aS_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aS_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aS_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu16i, aS_BFu17ll_BFu16i)
//============================================================================



static void Test_aS_BFu17ll_BFu16ll()
{
  {
    init_simple_test("aS_BFu17ll_BFu16ll");
    static STRUCT_IF_C aS_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aS_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aS_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu16ll, aS_BFu17ll_BFu16ll)
//============================================================================



static void Test_aS_BFu17ll_BFu16s()
{
  {
    init_simple_test("aS_BFu17ll_BFu16s");
    static STRUCT_IF_C aS_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aS_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aS_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu16s, aS_BFu17ll_BFu16s)
//============================================================================



static void Test_aS_BFu17ll_BFu17i()
{
  {
    init_simple_test("aS_BFu17ll_BFu17i");
    static STRUCT_IF_C aS_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aS_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu17i, aS_BFu17ll_BFu17i)
//============================================================================



static void Test_aS_BFu17ll_BFu17ll()
{
  {
    init_simple_test("aS_BFu17ll_BFu17ll");
    static STRUCT_IF_C aS_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aS_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu17ll, aS_BFu17ll_BFu17ll)
//============================================================================



static void Test_aS_BFu17ll_BFu1c()
{
  {
    init_simple_test("aS_BFu17ll_BFu1c");
    static STRUCT_IF_C aS_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aS_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu1c, aS_BFu17ll_BFu1c)
//============================================================================



static void Test_aS_BFu17ll_BFu1i()
{
  {
    init_simple_test("aS_BFu17ll_BFu1i");
    static STRUCT_IF_C aS_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aS_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu1i, aS_BFu17ll_BFu1i)
//============================================================================



static void Test_aS_BFu17ll_BFu1ll()
{
  {
    init_simple_test("aS_BFu17ll_BFu1ll");
    static STRUCT_IF_C aS_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aS_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu1ll, aS_BFu17ll_BFu1ll)
//============================================================================



static void Test_aS_BFu17ll_BFu1s()
{
  {
    init_simple_test("aS_BFu17ll_BFu1s");
    static STRUCT_IF_C aS_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aS_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu1s, aS_BFu17ll_BFu1s)
//============================================================================



static void Test_aS_BFu17ll_BFu31i()
{
  {
    init_simple_test("aS_BFu17ll_BFu31i");
    static STRUCT_IF_C aS_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu17ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aS_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aS_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu31i, aS_BFu17ll_BFu31i)
//============================================================================



static void Test_aS_BFu17ll_BFu31ll()
{
  {
    init_simple_test("aS_BFu17ll_BFu31ll");
    static STRUCT_IF_C aS_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aS_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aS_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu31ll, aS_BFu17ll_BFu31ll)
//============================================================================



static void Test_aS_BFu17ll_BFu32i()
{
  {
    init_simple_test("aS_BFu17ll_BFu32i");
    static STRUCT_IF_C aS_BFu17ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu17ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aS_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aS_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu32i, aS_BFu17ll_BFu32i)
//============================================================================



static void Test_aS_BFu17ll_BFu32ll()
{
  {
    init_simple_test("aS_BFu17ll_BFu32ll");
    static STRUCT_IF_C aS_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aS_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aS_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu32ll, aS_BFu17ll_BFu32ll)
//============================================================================



static void Test_aS_BFu17ll_BFu33()
{
  {
    init_simple_test("aS_BFu17ll_BFu33");
    static STRUCT_IF_C aS_BFu17ll_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu17ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "aS_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "aS_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu33, aS_BFu17ll_BFu33)
//============================================================================



static void Test_aS_BFu17ll_BFu7c()
{
  {
    init_simple_test("aS_BFu17ll_BFu7c");
    static STRUCT_IF_C aS_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aS_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aS_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu7c, aS_BFu17ll_BFu7c)
//============================================================================



static void Test_aS_BFu17ll_BFu7i()
{
  {
    init_simple_test("aS_BFu17ll_BFu7i");
    static STRUCT_IF_C aS_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aS_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aS_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu7i, aS_BFu17ll_BFu7i)
//============================================================================



static void Test_aS_BFu17ll_BFu7ll()
{
  {
    init_simple_test("aS_BFu17ll_BFu7ll");
    static STRUCT_IF_C aS_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aS_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aS_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu7ll, aS_BFu17ll_BFu7ll)
//============================================================================



static void Test_aS_BFu17ll_BFu7s()
{
  {
    init_simple_test("aS_BFu17ll_BFu7s");
    static STRUCT_IF_C aS_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu17ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aS_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aS_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu7s, aS_BFu17ll_BFu7s)
//============================================================================



static void Test_aS_BFu17ll_BFu8c()
{
  {
    init_simple_test("aS_BFu17ll_BFu8c");
    static STRUCT_IF_C aS_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aS_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aS_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu8c, aS_BFu17ll_BFu8c)
//============================================================================



static void Test_aS_BFu17ll_BFu8i()
{
  {
    init_simple_test("aS_BFu17ll_BFu8i");
    static STRUCT_IF_C aS_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aS_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aS_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu8i, aS_BFu17ll_BFu8i)
//============================================================================



static void Test_aS_BFu17ll_BFu8ll()
{
  {
    init_simple_test("aS_BFu17ll_BFu8ll");
    static STRUCT_IF_C aS_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aS_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aS_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu8ll, aS_BFu17ll_BFu8ll)
//============================================================================



static void Test_aS_BFu17ll_BFu8s()
{
  {
    init_simple_test("aS_BFu17ll_BFu8s");
    static STRUCT_IF_C aS_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aS_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aS_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu8s, aS_BFu17ll_BFu8s)
//============================================================================



static void Test_aS_BFu17ll_BFu9i()
{
  {
    init_simple_test("aS_BFu17ll_BFu9i");
    static STRUCT_IF_C aS_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aS_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aS_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu9i, aS_BFu17ll_BFu9i)
//============================================================================



static void Test_aS_BFu17ll_BFu9ll()
{
  {
    init_simple_test("aS_BFu17ll_BFu9ll");
    static STRUCT_IF_C aS_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aS_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aS_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu9ll, aS_BFu17ll_BFu9ll)
//============================================================================



static void Test_aS_BFu17ll_BFu9s()
{
  {
    init_simple_test("aS_BFu17ll_BFu9s");
    static STRUCT_IF_C aS_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aS_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aS_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_BFu9s, aS_BFu17ll_BFu9s)
//============================================================================



static void Test_aS_BFu17ll_C()
{
  {
    init_simple_test("aS_BFu17ll_C");
    static STRUCT_IF_C aS_BFu17ll_C lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_C");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_C");
    check_field_offset(lv, v3, 5, "aS_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_C, aS_BFu17ll_C)
//============================================================================



static void Test_aS_BFu17ll_D()
{
  {
    init_simple_test("aS_BFu17ll_D");
    static STRUCT_IF_C aS_BFu17ll_D lv;
    check2(sizeof(lv), 13, "sizeof(aS_BFu17ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_D");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_D");
    check_field_offset(lv, v3, 5, "aS_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_D, aS_BFu17ll_D)
//============================================================================



static void Test_aS_BFu17ll_F()
{
  {
    init_simple_test("aS_BFu17ll_F");
    static STRUCT_IF_C aS_BFu17ll_F lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu17ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_F");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_F");
    check_field_offset(lv, v3, 5, "aS_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_F, aS_BFu17ll_F)
//============================================================================



static void Test_aS_BFu17ll_I()
{
  {
    init_simple_test("aS_BFu17ll_I");
    static STRUCT_IF_C aS_BFu17ll_I lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu17ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_I");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_I");
    check_field_offset(lv, v3, 5, "aS_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_I, aS_BFu17ll_I)
//============================================================================



static void Test_aS_BFu17ll_Ip()
{
  {
    init_simple_test("aS_BFu17ll_Ip");
    static STRUCT_IF_C aS_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aS_BFu17ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_Ip");
    check_field_offset(lv, v3, 5, "aS_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_Ip, aS_BFu17ll_Ip)
//============================================================================



static void Test_aS_BFu17ll_L()
{
  {
    init_simple_test("aS_BFu17ll_L");
    static STRUCT_IF_C aS_BFu17ll_L lv;
    check2(sizeof(lv), 13, "sizeof(aS_BFu17ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_L");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_L");
    check_field_offset(lv, v3, 5, "aS_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_L, aS_BFu17ll_L)
//============================================================================



static void Test_aS_BFu17ll_S()
{
  {
    init_simple_test("aS_BFu17ll_S");
    static STRUCT_IF_C aS_BFu17ll_S lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_S");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_S");
    check_field_offset(lv, v3, 5, "aS_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_S, aS_BFu17ll_S)
//============================================================================



static void Test_aS_BFu17ll_Uc()
{
  {
    init_simple_test("aS_BFu17ll_Uc");
    static STRUCT_IF_C aS_BFu17ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu17ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_Uc");
    check_field_offset(lv, v3, 5, "aS_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_Uc, aS_BFu17ll_Uc)
//============================================================================



static void Test_aS_BFu17ll_Ui()
{
  {
    init_simple_test("aS_BFu17ll_Ui");
    static STRUCT_IF_C aS_BFu17ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu17ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_Ui");
    check_field_offset(lv, v3, 5, "aS_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_Ui, aS_BFu17ll_Ui)
//============================================================================



static void Test_aS_BFu17ll_Ul()
{
  {
    init_simple_test("aS_BFu17ll_Ul");
    static STRUCT_IF_C aS_BFu17ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aS_BFu17ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_Ul");
    check_field_offset(lv, v3, 5, "aS_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_Ul, aS_BFu17ll_Ul)
//============================================================================



static void Test_aS_BFu17ll_Us()
{
  {
    init_simple_test("aS_BFu17ll_Us");
    static STRUCT_IF_C aS_BFu17ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu17ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_Us");
    check_field_offset(lv, v3, 5, "aS_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_Us, aS_BFu17ll_Us)
//============================================================================



static void Test_aS_BFu17ll_Vp()
{
  {
    init_simple_test("aS_BFu17ll_Vp");
    static STRUCT_IF_C aS_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aS_BFu17ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "aS_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "aS_BFu17ll_Vp");
    check_field_offset(lv, v3, 5, "aS_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu17ll_Vp, aS_BFu17ll_Vp)
//============================================================================



static void Test_aS_BFu1c()
{
  {
    init_simple_test("aS_BFu1c");
    static STRUCT_IF_C aS_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c, aS_BFu1c)
//============================================================================



static void Test_aS_BFu1c_BFu15i()
{
  {
    init_simple_test("aS_BFu1c_BFu15i");
    static STRUCT_IF_C aS_BFu1c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aS_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aS_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu15i, aS_BFu1c_BFu15i)
//============================================================================



static void Test_aS_BFu1c_BFu15ll()
{
  {
    init_simple_test("aS_BFu1c_BFu15ll");
    static STRUCT_IF_C aS_BFu1c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aS_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aS_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu15ll, aS_BFu1c_BFu15ll)
//============================================================================



static void Test_aS_BFu1c_BFu15s()
{
  {
    init_simple_test("aS_BFu1c_BFu15s");
    static STRUCT_IF_C aS_BFu1c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aS_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aS_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu15s, aS_BFu1c_BFu15s)
//============================================================================



static void Test_aS_BFu1c_BFu16i()
{
  {
    init_simple_test("aS_BFu1c_BFu16i");
    static STRUCT_IF_C aS_BFu1c_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aS_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aS_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu16i, aS_BFu1c_BFu16i)
//============================================================================



static void Test_aS_BFu1c_BFu16ll()
{
  {
    init_simple_test("aS_BFu1c_BFu16ll");
    static STRUCT_IF_C aS_BFu1c_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aS_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aS_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu16ll, aS_BFu1c_BFu16ll)
//============================================================================



static void Test_aS_BFu1c_BFu16s()
{
  {
    init_simple_test("aS_BFu1c_BFu16s");
    static STRUCT_IF_C aS_BFu1c_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aS_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aS_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu16s, aS_BFu1c_BFu16s)
//============================================================================



static void Test_aS_BFu1c_BFu17i()
{
  {
    init_simple_test("aS_BFu1c_BFu17i");
    static STRUCT_IF_C aS_BFu1c_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aS_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aS_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu17i, aS_BFu1c_BFu17i)
//============================================================================



static void Test_aS_BFu1c_BFu17ll()
{
  {
    init_simple_test("aS_BFu1c_BFu17ll");
    static STRUCT_IF_C aS_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aS_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aS_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu17ll, aS_BFu1c_BFu17ll)
//============================================================================



static void Test_aS_BFu1c_BFu1c()
{
  {
    init_simple_test("aS_BFu1c_BFu1c");
    static STRUCT_IF_C aS_BFu1c_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu1c, aS_BFu1c_BFu1c)
//============================================================================



static void Test_aS_BFu1c_BFu1i()
{
  {
    init_simple_test("aS_BFu1c_BFu1i");
    static STRUCT_IF_C aS_BFu1c_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu1i, aS_BFu1c_BFu1i)
//============================================================================



static void Test_aS_BFu1c_BFu1ll()
{
  {
    init_simple_test("aS_BFu1c_BFu1ll");
    static STRUCT_IF_C aS_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu1ll, aS_BFu1c_BFu1ll)
//============================================================================



static void Test_aS_BFu1c_BFu1s()
{
  {
    init_simple_test("aS_BFu1c_BFu1s");
    static STRUCT_IF_C aS_BFu1c_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu1s, aS_BFu1c_BFu1s)
//============================================================================



static void Test_aS_BFu1c_BFu31i()
{
  {
    init_simple_test("aS_BFu1c_BFu31i");
    static STRUCT_IF_C aS_BFu1c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu1c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aS_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aS_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu31i, aS_BFu1c_BFu31i)
//============================================================================



static void Test_aS_BFu1c_BFu31ll()
{
  {
    init_simple_test("aS_BFu1c_BFu31ll");
    static STRUCT_IF_C aS_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu1c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aS_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aS_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu31ll, aS_BFu1c_BFu31ll)
//============================================================================



static void Test_aS_BFu1c_BFu32i()
{
  {
    init_simple_test("aS_BFu1c_BFu32i");
    static STRUCT_IF_C aS_BFu1c_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aS_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aS_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu32i, aS_BFu1c_BFu32i)
//============================================================================



static void Test_aS_BFu1c_BFu32ll()
{
  {
    init_simple_test("aS_BFu1c_BFu32ll");
    static STRUCT_IF_C aS_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aS_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aS_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu32ll, aS_BFu1c_BFu32ll)
//============================================================================



static void Test_aS_BFu1c_BFu33()
{
  {
    init_simple_test("aS_BFu1c_BFu33");
    static STRUCT_IF_C aS_BFu1c_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "aS_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "aS_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu33, aS_BFu1c_BFu33)
//============================================================================



static void Test_aS_BFu1c_BFu7c()
{
  {
    init_simple_test("aS_BFu1c_BFu7c");
    static STRUCT_IF_C aS_BFu1c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu7c, aS_BFu1c_BFu7c)
//============================================================================



static void Test_aS_BFu1c_BFu7i()
{
  {
    init_simple_test("aS_BFu1c_BFu7i");
    static STRUCT_IF_C aS_BFu1c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu7i, aS_BFu1c_BFu7i)
//============================================================================



static void Test_aS_BFu1c_BFu7ll()
{
  {
    init_simple_test("aS_BFu1c_BFu7ll");
    static STRUCT_IF_C aS_BFu1c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu7ll, aS_BFu1c_BFu7ll)
//============================================================================



static void Test_aS_BFu1c_BFu7s()
{
  {
    init_simple_test("aS_BFu1c_BFu7s");
    static STRUCT_IF_C aS_BFu1c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu7s, aS_BFu1c_BFu7s)
//============================================================================



static void Test_aS_BFu1c_BFu8c()
{
  {
    init_simple_test("aS_BFu1c_BFu8c");
    static STRUCT_IF_C aS_BFu1c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu8c, aS_BFu1c_BFu8c)
//============================================================================



static void Test_aS_BFu1c_BFu8i()
{
  {
    init_simple_test("aS_BFu1c_BFu8i");
    static STRUCT_IF_C aS_BFu1c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu8i, aS_BFu1c_BFu8i)
//============================================================================



static void Test_aS_BFu1c_BFu8ll()
{
  {
    init_simple_test("aS_BFu1c_BFu8ll");
    static STRUCT_IF_C aS_BFu1c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu8ll, aS_BFu1c_BFu8ll)
//============================================================================



static void Test_aS_BFu1c_BFu8s()
{
  {
    init_simple_test("aS_BFu1c_BFu8s");
    static STRUCT_IF_C aS_BFu1c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu8s, aS_BFu1c_BFu8s)
//============================================================================



static void Test_aS_BFu1c_BFu9i()
{
  {
    init_simple_test("aS_BFu1c_BFu9i");
    static STRUCT_IF_C aS_BFu1c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aS_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aS_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu9i, aS_BFu1c_BFu9i)
//============================================================================



static void Test_aS_BFu1c_BFu9ll()
{
  {
    init_simple_test("aS_BFu1c_BFu9ll");
    static STRUCT_IF_C aS_BFu1c_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aS_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aS_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu9ll, aS_BFu1c_BFu9ll)
//============================================================================



static void Test_aS_BFu1c_BFu9s()
{
  {
    init_simple_test("aS_BFu1c_BFu9s");
    static STRUCT_IF_C aS_BFu1c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aS_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aS_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_BFu9s, aS_BFu1c_BFu9s)
//============================================================================



static void Test_aS_BFu1c_C()
{
  {
    init_simple_test("aS_BFu1c_C");
    static STRUCT_IF_C aS_BFu1c_C lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_C)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_C");
    check_field_offset(lv, v3, 3, "aS_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_C, aS_BFu1c_C)
//============================================================================



static void Test_aS_BFu1c_D()
{
  {
    init_simple_test("aS_BFu1c_D");
    static STRUCT_IF_C aS_BFu1c_D lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu1c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_D)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_D");
    check_field_offset(lv, v3, 3, "aS_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_D, aS_BFu1c_D)
//============================================================================



static void Test_aS_BFu1c_F()
{
  {
    init_simple_test("aS_BFu1c_F");
    static STRUCT_IF_C aS_BFu1c_F lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_F)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_F");
    check_field_offset(lv, v3, 3, "aS_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_F, aS_BFu1c_F)
//============================================================================



static void Test_aS_BFu1c_I()
{
  {
    init_simple_test("aS_BFu1c_I");
    static STRUCT_IF_C aS_BFu1c_I lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_I)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_I");
    check_field_offset(lv, v3, 3, "aS_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_I, aS_BFu1c_I)
//============================================================================



static void Test_aS_BFu1c_Ip()
{
  {
    init_simple_test("aS_BFu1c_Ip");
    static STRUCT_IF_C aS_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu1c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_Ip");
    check_field_offset(lv, v3, 3, "aS_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_Ip, aS_BFu1c_Ip)
//============================================================================



static void Test_aS_BFu1c_L()
{
  {
    init_simple_test("aS_BFu1c_L");
    static STRUCT_IF_C aS_BFu1c_L lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu1c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_L)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_L");
    check_field_offset(lv, v3, 3, "aS_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_L, aS_BFu1c_L)
//============================================================================



static void Test_aS_BFu1c_S()
{
  {
    init_simple_test("aS_BFu1c_S");
    static STRUCT_IF_C aS_BFu1c_S lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_S)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_S");
    check_field_offset(lv, v3, 3, "aS_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_S, aS_BFu1c_S)
//============================================================================



static void Test_aS_BFu1c_Uc()
{
  {
    init_simple_test("aS_BFu1c_Uc");
    static STRUCT_IF_C aS_BFu1c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_Uc");
    check_field_offset(lv, v3, 3, "aS_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_Uc, aS_BFu1c_Uc)
//============================================================================



static void Test_aS_BFu1c_Ui()
{
  {
    init_simple_test("aS_BFu1c_Ui");
    static STRUCT_IF_C aS_BFu1c_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_Ui");
    check_field_offset(lv, v3, 3, "aS_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_Ui, aS_BFu1c_Ui)
//============================================================================



static void Test_aS_BFu1c_Ul()
{
  {
    init_simple_test("aS_BFu1c_Ul");
    static STRUCT_IF_C aS_BFu1c_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu1c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_Ul");
    check_field_offset(lv, v3, 3, "aS_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_Ul, aS_BFu1c_Ul)
//============================================================================



static void Test_aS_BFu1c_Us()
{
  {
    init_simple_test("aS_BFu1c_Us");
    static STRUCT_IF_C aS_BFu1c_Us lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_Us");
    check_field_offset(lv, v3, 3, "aS_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_Us, aS_BFu1c_Us)
//============================================================================



static void Test_aS_BFu1c_Vp()
{
  {
    init_simple_test("aS_BFu1c_Vp");
    static STRUCT_IF_C aS_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu1c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1c_Vp");
    check_field_offset(lv, v3, 3, "aS_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1c_Vp, aS_BFu1c_Vp)
//============================================================================



static void Test_aS_BFu1i()
{
  {
    init_simple_test("aS_BFu1i");
    static STRUCT_IF_C aS_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i, aS_BFu1i)
//============================================================================



static void Test_aS_BFu1i_BFu15i()
{
  {
    init_simple_test("aS_BFu1i_BFu15i");
    static STRUCT_IF_C aS_BFu1i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aS_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aS_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu15i, aS_BFu1i_BFu15i)
//============================================================================



static void Test_aS_BFu1i_BFu15ll()
{
  {
    init_simple_test("aS_BFu1i_BFu15ll");
    static STRUCT_IF_C aS_BFu1i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aS_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aS_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu15ll, aS_BFu1i_BFu15ll)
//============================================================================



static void Test_aS_BFu1i_BFu15s()
{
  {
    init_simple_test("aS_BFu1i_BFu15s");
    static STRUCT_IF_C aS_BFu1i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aS_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aS_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu15s, aS_BFu1i_BFu15s)
//============================================================================



static void Test_aS_BFu1i_BFu16i()
{
  {
    init_simple_test("aS_BFu1i_BFu16i");
    static STRUCT_IF_C aS_BFu1i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aS_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aS_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu16i, aS_BFu1i_BFu16i)
//============================================================================



static void Test_aS_BFu1i_BFu16ll()
{
  {
    init_simple_test("aS_BFu1i_BFu16ll");
    static STRUCT_IF_C aS_BFu1i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aS_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aS_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu16ll, aS_BFu1i_BFu16ll)
//============================================================================



static void Test_aS_BFu1i_BFu16s()
{
  {
    init_simple_test("aS_BFu1i_BFu16s");
    static STRUCT_IF_C aS_BFu1i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aS_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aS_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu16s, aS_BFu1i_BFu16s)
//============================================================================



static void Test_aS_BFu1i_BFu17i()
{
  {
    init_simple_test("aS_BFu1i_BFu17i");
    static STRUCT_IF_C aS_BFu1i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aS_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aS_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu17i, aS_BFu1i_BFu17i)
//============================================================================



static void Test_aS_BFu1i_BFu17ll()
{
  {
    init_simple_test("aS_BFu1i_BFu17ll");
    static STRUCT_IF_C aS_BFu1i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aS_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aS_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu17ll, aS_BFu1i_BFu17ll)
//============================================================================



static void Test_aS_BFu1i_BFu1c()
{
  {
    init_simple_test("aS_BFu1i_BFu1c");
    static STRUCT_IF_C aS_BFu1i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu1c, aS_BFu1i_BFu1c)
//============================================================================



static void Test_aS_BFu1i_BFu1i()
{
  {
    init_simple_test("aS_BFu1i_BFu1i");
    static STRUCT_IF_C aS_BFu1i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu1i, aS_BFu1i_BFu1i)
//============================================================================



static void Test_aS_BFu1i_BFu1ll()
{
  {
    init_simple_test("aS_BFu1i_BFu1ll");
    static STRUCT_IF_C aS_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu1ll, aS_BFu1i_BFu1ll)
//============================================================================



static void Test_aS_BFu1i_BFu1s()
{
  {
    init_simple_test("aS_BFu1i_BFu1s");
    static STRUCT_IF_C aS_BFu1i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu1s, aS_BFu1i_BFu1s)
//============================================================================



static void Test_aS_BFu1i_BFu31i()
{
  {
    init_simple_test("aS_BFu1i_BFu31i");
    static STRUCT_IF_C aS_BFu1i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu1i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aS_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aS_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu31i, aS_BFu1i_BFu31i)
//============================================================================



static void Test_aS_BFu1i_BFu31ll()
{
  {
    init_simple_test("aS_BFu1i_BFu31ll");
    static STRUCT_IF_C aS_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu1i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aS_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aS_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu31ll, aS_BFu1i_BFu31ll)
//============================================================================



static void Test_aS_BFu1i_BFu32i()
{
  {
    init_simple_test("aS_BFu1i_BFu32i");
    static STRUCT_IF_C aS_BFu1i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aS_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aS_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu32i, aS_BFu1i_BFu32i)
//============================================================================



static void Test_aS_BFu1i_BFu32ll()
{
  {
    init_simple_test("aS_BFu1i_BFu32ll");
    static STRUCT_IF_C aS_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aS_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aS_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu32ll, aS_BFu1i_BFu32ll)
//============================================================================



static void Test_aS_BFu1i_BFu33()
{
  {
    init_simple_test("aS_BFu1i_BFu33");
    static STRUCT_IF_C aS_BFu1i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "aS_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "aS_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu33, aS_BFu1i_BFu33)
//============================================================================



static void Test_aS_BFu1i_BFu7c()
{
  {
    init_simple_test("aS_BFu1i_BFu7c");
    static STRUCT_IF_C aS_BFu1i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu7c, aS_BFu1i_BFu7c)
//============================================================================



static void Test_aS_BFu1i_BFu7i()
{
  {
    init_simple_test("aS_BFu1i_BFu7i");
    static STRUCT_IF_C aS_BFu1i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu7i, aS_BFu1i_BFu7i)
//============================================================================



static void Test_aS_BFu1i_BFu7ll()
{
  {
    init_simple_test("aS_BFu1i_BFu7ll");
    static STRUCT_IF_C aS_BFu1i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu7ll, aS_BFu1i_BFu7ll)
//============================================================================



static void Test_aS_BFu1i_BFu7s()
{
  {
    init_simple_test("aS_BFu1i_BFu7s");
    static STRUCT_IF_C aS_BFu1i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu7s, aS_BFu1i_BFu7s)
//============================================================================



static void Test_aS_BFu1i_BFu8c()
{
  {
    init_simple_test("aS_BFu1i_BFu8c");
    static STRUCT_IF_C aS_BFu1i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu8c, aS_BFu1i_BFu8c)
//============================================================================



static void Test_aS_BFu1i_BFu8i()
{
  {
    init_simple_test("aS_BFu1i_BFu8i");
    static STRUCT_IF_C aS_BFu1i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu8i, aS_BFu1i_BFu8i)
//============================================================================



static void Test_aS_BFu1i_BFu8ll()
{
  {
    init_simple_test("aS_BFu1i_BFu8ll");
    static STRUCT_IF_C aS_BFu1i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu8ll, aS_BFu1i_BFu8ll)
//============================================================================



static void Test_aS_BFu1i_BFu8s()
{
  {
    init_simple_test("aS_BFu1i_BFu8s");
    static STRUCT_IF_C aS_BFu1i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu8s, aS_BFu1i_BFu8s)
//============================================================================



static void Test_aS_BFu1i_BFu9i()
{
  {
    init_simple_test("aS_BFu1i_BFu9i");
    static STRUCT_IF_C aS_BFu1i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aS_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aS_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu9i, aS_BFu1i_BFu9i)
//============================================================================



static void Test_aS_BFu1i_BFu9ll()
{
  {
    init_simple_test("aS_BFu1i_BFu9ll");
    static STRUCT_IF_C aS_BFu1i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aS_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aS_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu9ll, aS_BFu1i_BFu9ll)
//============================================================================



static void Test_aS_BFu1i_BFu9s()
{
  {
    init_simple_test("aS_BFu1i_BFu9s");
    static STRUCT_IF_C aS_BFu1i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aS_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aS_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_BFu9s, aS_BFu1i_BFu9s)
//============================================================================



static void Test_aS_BFu1i_C()
{
  {
    init_simple_test("aS_BFu1i_C");
    static STRUCT_IF_C aS_BFu1i_C lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_C)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_C");
    check_field_offset(lv, v3, 3, "aS_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_C, aS_BFu1i_C)
//============================================================================



static void Test_aS_BFu1i_D()
{
  {
    init_simple_test("aS_BFu1i_D");
    static STRUCT_IF_C aS_BFu1i_D lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu1i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_D)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_D");
    check_field_offset(lv, v3, 3, "aS_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_D, aS_BFu1i_D)
//============================================================================



static void Test_aS_BFu1i_F()
{
  {
    init_simple_test("aS_BFu1i_F");
    static STRUCT_IF_C aS_BFu1i_F lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_F)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_F");
    check_field_offset(lv, v3, 3, "aS_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_F, aS_BFu1i_F)
//============================================================================



static void Test_aS_BFu1i_I()
{
  {
    init_simple_test("aS_BFu1i_I");
    static STRUCT_IF_C aS_BFu1i_I lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_I)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_I");
    check_field_offset(lv, v3, 3, "aS_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_I, aS_BFu1i_I)
//============================================================================



static void Test_aS_BFu1i_Ip()
{
  {
    init_simple_test("aS_BFu1i_Ip");
    static STRUCT_IF_C aS_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu1i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_Ip");
    check_field_offset(lv, v3, 3, "aS_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_Ip, aS_BFu1i_Ip)
//============================================================================



static void Test_aS_BFu1i_L()
{
  {
    init_simple_test("aS_BFu1i_L");
    static STRUCT_IF_C aS_BFu1i_L lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu1i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_L)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_L");
    check_field_offset(lv, v3, 3, "aS_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_L, aS_BFu1i_L)
//============================================================================



static void Test_aS_BFu1i_S()
{
  {
    init_simple_test("aS_BFu1i_S");
    static STRUCT_IF_C aS_BFu1i_S lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_S)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_S");
    check_field_offset(lv, v3, 3, "aS_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_S, aS_BFu1i_S)
//============================================================================



static void Test_aS_BFu1i_Uc()
{
  {
    init_simple_test("aS_BFu1i_Uc");
    static STRUCT_IF_C aS_BFu1i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_Uc");
    check_field_offset(lv, v3, 3, "aS_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_Uc, aS_BFu1i_Uc)
//============================================================================



static void Test_aS_BFu1i_Ui()
{
  {
    init_simple_test("aS_BFu1i_Ui");
    static STRUCT_IF_C aS_BFu1i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_Ui");
    check_field_offset(lv, v3, 3, "aS_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_Ui, aS_BFu1i_Ui)
//============================================================================



static void Test_aS_BFu1i_Ul()
{
  {
    init_simple_test("aS_BFu1i_Ul");
    static STRUCT_IF_C aS_BFu1i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu1i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_Ul");
    check_field_offset(lv, v3, 3, "aS_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_Ul, aS_BFu1i_Ul)
//============================================================================



static void Test_aS_BFu1i_Us()
{
  {
    init_simple_test("aS_BFu1i_Us");
    static STRUCT_IF_C aS_BFu1i_Us lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_Us");
    check_field_offset(lv, v3, 3, "aS_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_Us, aS_BFu1i_Us)
//============================================================================



static void Test_aS_BFu1i_Vp()
{
  {
    init_simple_test("aS_BFu1i_Vp");
    static STRUCT_IF_C aS_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu1i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1i_Vp");
    check_field_offset(lv, v3, 3, "aS_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1i_Vp, aS_BFu1i_Vp)
//============================================================================



static void Test_aS_BFu1ll()
{
  {
    init_simple_test("aS_BFu1ll");
    static STRUCT_IF_C aS_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll, aS_BFu1ll)
//============================================================================



static void Test_aS_BFu1ll_BFu15i()
{
  {
    init_simple_test("aS_BFu1ll_BFu15i");
    static STRUCT_IF_C aS_BFu1ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aS_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aS_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu15i, aS_BFu1ll_BFu15i)
//============================================================================



static void Test_aS_BFu1ll_BFu15ll()
{
  {
    init_simple_test("aS_BFu1ll_BFu15ll");
    static STRUCT_IF_C aS_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aS_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aS_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu15ll, aS_BFu1ll_BFu15ll)
//============================================================================



static void Test_aS_BFu1ll_BFu15s()
{
  {
    init_simple_test("aS_BFu1ll_BFu15s");
    static STRUCT_IF_C aS_BFu1ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aS_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aS_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu15s, aS_BFu1ll_BFu15s)
//============================================================================



static void Test_aS_BFu1ll_BFu16i()
{
  {
    init_simple_test("aS_BFu1ll_BFu16i");
    static STRUCT_IF_C aS_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aS_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aS_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu16i, aS_BFu1ll_BFu16i)
//============================================================================



static void Test_aS_BFu1ll_BFu16ll()
{
  {
    init_simple_test("aS_BFu1ll_BFu16ll");
    static STRUCT_IF_C aS_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aS_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aS_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu16ll, aS_BFu1ll_BFu16ll)
//============================================================================



static void Test_aS_BFu1ll_BFu16s()
{
  {
    init_simple_test("aS_BFu1ll_BFu16s");
    static STRUCT_IF_C aS_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aS_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aS_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu16s, aS_BFu1ll_BFu16s)
//============================================================================



static void Test_aS_BFu1ll_BFu17i()
{
  {
    init_simple_test("aS_BFu1ll_BFu17i");
    static STRUCT_IF_C aS_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aS_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aS_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu17i, aS_BFu1ll_BFu17i)
//============================================================================



static void Test_aS_BFu1ll_BFu17ll()
{
  {
    init_simple_test("aS_BFu1ll_BFu17ll");
    static STRUCT_IF_C aS_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aS_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aS_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu17ll, aS_BFu1ll_BFu17ll)
//============================================================================



static void Test_aS_BFu1ll_BFu1c()
{
  {
    init_simple_test("aS_BFu1ll_BFu1c");
    static STRUCT_IF_C aS_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu1c, aS_BFu1ll_BFu1c)
//============================================================================



static void Test_aS_BFu1ll_BFu1i()
{
  {
    init_simple_test("aS_BFu1ll_BFu1i");
    static STRUCT_IF_C aS_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu1i, aS_BFu1ll_BFu1i)
//============================================================================



static void Test_aS_BFu1ll_BFu1ll()
{
  {
    init_simple_test("aS_BFu1ll_BFu1ll");
    static STRUCT_IF_C aS_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu1ll, aS_BFu1ll_BFu1ll)
//============================================================================



static void Test_aS_BFu1ll_BFu1s()
{
  {
    init_simple_test("aS_BFu1ll_BFu1s");
    static STRUCT_IF_C aS_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu1s, aS_BFu1ll_BFu1s)
//============================================================================



static void Test_aS_BFu1ll_BFu31i()
{
  {
    init_simple_test("aS_BFu1ll_BFu31i");
    static STRUCT_IF_C aS_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu1ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aS_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aS_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu31i, aS_BFu1ll_BFu31i)
//============================================================================



static void Test_aS_BFu1ll_BFu31ll()
{
  {
    init_simple_test("aS_BFu1ll_BFu31ll");
    static STRUCT_IF_C aS_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aS_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aS_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu31ll, aS_BFu1ll_BFu31ll)
//============================================================================



static void Test_aS_BFu1ll_BFu32i()
{
  {
    init_simple_test("aS_BFu1ll_BFu32i");
    static STRUCT_IF_C aS_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aS_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aS_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu32i, aS_BFu1ll_BFu32i)
//============================================================================



static void Test_aS_BFu1ll_BFu32ll()
{
  {
    init_simple_test("aS_BFu1ll_BFu32ll");
    static STRUCT_IF_C aS_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aS_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aS_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu32ll, aS_BFu1ll_BFu32ll)
//============================================================================



static void Test_aS_BFu1ll_BFu33()
{
  {
    init_simple_test("aS_BFu1ll_BFu33");
    static STRUCT_IF_C aS_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "aS_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "aS_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu33, aS_BFu1ll_BFu33)
//============================================================================



static void Test_aS_BFu1ll_BFu7c()
{
  {
    init_simple_test("aS_BFu1ll_BFu7c");
    static STRUCT_IF_C aS_BFu1ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu7c, aS_BFu1ll_BFu7c)
//============================================================================



static void Test_aS_BFu1ll_BFu7i()
{
  {
    init_simple_test("aS_BFu1ll_BFu7i");
    static STRUCT_IF_C aS_BFu1ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu7i, aS_BFu1ll_BFu7i)
//============================================================================



static void Test_aS_BFu1ll_BFu7ll()
{
  {
    init_simple_test("aS_BFu1ll_BFu7ll");
    static STRUCT_IF_C aS_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu7ll, aS_BFu1ll_BFu7ll)
//============================================================================



static void Test_aS_BFu1ll_BFu7s()
{
  {
    init_simple_test("aS_BFu1ll_BFu7s");
    static STRUCT_IF_C aS_BFu1ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu7s, aS_BFu1ll_BFu7s)
//============================================================================



static void Test_aS_BFu1ll_BFu8c()
{
  {
    init_simple_test("aS_BFu1ll_BFu8c");
    static STRUCT_IF_C aS_BFu1ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu8c, aS_BFu1ll_BFu8c)
//============================================================================



static void Test_aS_BFu1ll_BFu8i()
{
  {
    init_simple_test("aS_BFu1ll_BFu8i");
    static STRUCT_IF_C aS_BFu1ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu8i, aS_BFu1ll_BFu8i)
//============================================================================



static void Test_aS_BFu1ll_BFu8ll()
{
  {
    init_simple_test("aS_BFu1ll_BFu8ll");
    static STRUCT_IF_C aS_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu8ll, aS_BFu1ll_BFu8ll)
//============================================================================



static void Test_aS_BFu1ll_BFu8s()
{
  {
    init_simple_test("aS_BFu1ll_BFu8s");
    static STRUCT_IF_C aS_BFu1ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu8s, aS_BFu1ll_BFu8s)
//============================================================================



static void Test_aS_BFu1ll_BFu9i()
{
  {
    init_simple_test("aS_BFu1ll_BFu9i");
    static STRUCT_IF_C aS_BFu1ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aS_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aS_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu9i, aS_BFu1ll_BFu9i)
//============================================================================



static void Test_aS_BFu1ll_BFu9ll()
{
  {
    init_simple_test("aS_BFu1ll_BFu9ll");
    static STRUCT_IF_C aS_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aS_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aS_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu9ll, aS_BFu1ll_BFu9ll)
//============================================================================



static void Test_aS_BFu1ll_BFu9s()
{
  {
    init_simple_test("aS_BFu1ll_BFu9s");
    static STRUCT_IF_C aS_BFu1ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aS_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aS_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_BFu9s, aS_BFu1ll_BFu9s)
//============================================================================



static void Test_aS_BFu1ll_C()
{
  {
    init_simple_test("aS_BFu1ll_C");
    static STRUCT_IF_C aS_BFu1ll_C lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_C");
    check_field_offset(lv, v3, 3, "aS_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_C, aS_BFu1ll_C)
//============================================================================



static void Test_aS_BFu1ll_D()
{
  {
    init_simple_test("aS_BFu1ll_D");
    static STRUCT_IF_C aS_BFu1ll_D lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu1ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_D");
    check_field_offset(lv, v3, 3, "aS_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_D, aS_BFu1ll_D)
//============================================================================



static void Test_aS_BFu1ll_F()
{
  {
    init_simple_test("aS_BFu1ll_F");
    static STRUCT_IF_C aS_BFu1ll_F lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_F");
    check_field_offset(lv, v3, 3, "aS_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_F, aS_BFu1ll_F)
//============================================================================



static void Test_aS_BFu1ll_I()
{
  {
    init_simple_test("aS_BFu1ll_I");
    static STRUCT_IF_C aS_BFu1ll_I lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_I");
    check_field_offset(lv, v3, 3, "aS_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_I, aS_BFu1ll_I)
//============================================================================



static void Test_aS_BFu1ll_Ip()
{
  {
    init_simple_test("aS_BFu1ll_Ip");
    static STRUCT_IF_C aS_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu1ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_Ip");
    check_field_offset(lv, v3, 3, "aS_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_Ip, aS_BFu1ll_Ip)
//============================================================================



static void Test_aS_BFu1ll_L()
{
  {
    init_simple_test("aS_BFu1ll_L");
    static STRUCT_IF_C aS_BFu1ll_L lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu1ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_L");
    check_field_offset(lv, v3, 3, "aS_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_L, aS_BFu1ll_L)
//============================================================================



static void Test_aS_BFu1ll_S()
{
  {
    init_simple_test("aS_BFu1ll_S");
    static STRUCT_IF_C aS_BFu1ll_S lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_S");
    check_field_offset(lv, v3, 3, "aS_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_S, aS_BFu1ll_S)
//============================================================================



static void Test_aS_BFu1ll_Uc()
{
  {
    init_simple_test("aS_BFu1ll_Uc");
    static STRUCT_IF_C aS_BFu1ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_Uc");
    check_field_offset(lv, v3, 3, "aS_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_Uc, aS_BFu1ll_Uc)
//============================================================================



static void Test_aS_BFu1ll_Ui()
{
  {
    init_simple_test("aS_BFu1ll_Ui");
    static STRUCT_IF_C aS_BFu1ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_Ui");
    check_field_offset(lv, v3, 3, "aS_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_Ui, aS_BFu1ll_Ui)
//============================================================================



static void Test_aS_BFu1ll_Ul()
{
  {
    init_simple_test("aS_BFu1ll_Ul");
    static STRUCT_IF_C aS_BFu1ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu1ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_Ul");
    check_field_offset(lv, v3, 3, "aS_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_Ul, aS_BFu1ll_Ul)
//============================================================================



static void Test_aS_BFu1ll_Us()
{
  {
    init_simple_test("aS_BFu1ll_Us");
    static STRUCT_IF_C aS_BFu1ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_Us");
    check_field_offset(lv, v3, 3, "aS_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_Us, aS_BFu1ll_Us)
//============================================================================



static void Test_aS_BFu1ll_Vp()
{
  {
    init_simple_test("aS_BFu1ll_Vp");
    static STRUCT_IF_C aS_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu1ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1ll_Vp");
    check_field_offset(lv, v3, 3, "aS_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1ll_Vp, aS_BFu1ll_Vp)
//============================================================================



static void Test_aS_BFu1s()
{
  {
    init_simple_test("aS_BFu1s");
    static STRUCT_IF_C aS_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s, aS_BFu1s)
//============================================================================



static void Test_aS_BFu1s_BFu15i()
{
  {
    init_simple_test("aS_BFu1s_BFu15i");
    static STRUCT_IF_C aS_BFu1s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aS_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aS_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu15i, aS_BFu1s_BFu15i)
//============================================================================



static void Test_aS_BFu1s_BFu15ll()
{
  {
    init_simple_test("aS_BFu1s_BFu15ll");
    static STRUCT_IF_C aS_BFu1s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aS_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aS_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu15ll, aS_BFu1s_BFu15ll)
//============================================================================



static void Test_aS_BFu1s_BFu15s()
{
  {
    init_simple_test("aS_BFu1s_BFu15s");
    static STRUCT_IF_C aS_BFu1s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aS_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aS_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu15s, aS_BFu1s_BFu15s)
//============================================================================



static void Test_aS_BFu1s_BFu16i()
{
  {
    init_simple_test("aS_BFu1s_BFu16i");
    static STRUCT_IF_C aS_BFu1s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aS_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aS_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu16i, aS_BFu1s_BFu16i)
//============================================================================



static void Test_aS_BFu1s_BFu16ll()
{
  {
    init_simple_test("aS_BFu1s_BFu16ll");
    static STRUCT_IF_C aS_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aS_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aS_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu16ll, aS_BFu1s_BFu16ll)
//============================================================================



static void Test_aS_BFu1s_BFu16s()
{
  {
    init_simple_test("aS_BFu1s_BFu16s");
    static STRUCT_IF_C aS_BFu1s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aS_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aS_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu16s, aS_BFu1s_BFu16s)
//============================================================================



static void Test_aS_BFu1s_BFu17i()
{
  {
    init_simple_test("aS_BFu1s_BFu17i");
    static STRUCT_IF_C aS_BFu1s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aS_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aS_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu17i, aS_BFu1s_BFu17i)
//============================================================================



static void Test_aS_BFu1s_BFu17ll()
{
  {
    init_simple_test("aS_BFu1s_BFu17ll");
    static STRUCT_IF_C aS_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aS_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aS_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu17ll, aS_BFu1s_BFu17ll)
//============================================================================



static void Test_aS_BFu1s_BFu1c()
{
  {
    init_simple_test("aS_BFu1s_BFu1c");
    static STRUCT_IF_C aS_BFu1s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu1c, aS_BFu1s_BFu1c)
//============================================================================



static void Test_aS_BFu1s_BFu1i()
{
  {
    init_simple_test("aS_BFu1s_BFu1i");
    static STRUCT_IF_C aS_BFu1s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu1i, aS_BFu1s_BFu1i)
//============================================================================



static void Test_aS_BFu1s_BFu1ll()
{
  {
    init_simple_test("aS_BFu1s_BFu1ll");
    static STRUCT_IF_C aS_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu1ll, aS_BFu1s_BFu1ll)
//============================================================================



static void Test_aS_BFu1s_BFu1s()
{
  {
    init_simple_test("aS_BFu1s_BFu1s");
    static STRUCT_IF_C aS_BFu1s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aS_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu1s, aS_BFu1s_BFu1s)
//============================================================================



static void Test_aS_BFu1s_BFu31i()
{
  {
    init_simple_test("aS_BFu1s_BFu31i");
    static STRUCT_IF_C aS_BFu1s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu1s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aS_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aS_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu31i, aS_BFu1s_BFu31i)
//============================================================================



static void Test_aS_BFu1s_BFu31ll()
{
  {
    init_simple_test("aS_BFu1s_BFu31ll");
    static STRUCT_IF_C aS_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu1s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aS_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aS_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu31ll, aS_BFu1s_BFu31ll)
//============================================================================



static void Test_aS_BFu1s_BFu32i()
{
  {
    init_simple_test("aS_BFu1s_BFu32i");
    static STRUCT_IF_C aS_BFu1s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aS_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aS_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu32i, aS_BFu1s_BFu32i)
//============================================================================



static void Test_aS_BFu1s_BFu32ll()
{
  {
    init_simple_test("aS_BFu1s_BFu32ll");
    static STRUCT_IF_C aS_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aS_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aS_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu32ll, aS_BFu1s_BFu32ll)
//============================================================================



static void Test_aS_BFu1s_BFu33()
{
  {
    init_simple_test("aS_BFu1s_BFu33");
    static STRUCT_IF_C aS_BFu1s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "aS_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "aS_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu33, aS_BFu1s_BFu33)
//============================================================================



static void Test_aS_BFu1s_BFu7c()
{
  {
    init_simple_test("aS_BFu1s_BFu7c");
    static STRUCT_IF_C aS_BFu1s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu7c, aS_BFu1s_BFu7c)
//============================================================================



static void Test_aS_BFu1s_BFu7i()
{
  {
    init_simple_test("aS_BFu1s_BFu7i");
    static STRUCT_IF_C aS_BFu1s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu7i, aS_BFu1s_BFu7i)
//============================================================================



static void Test_aS_BFu1s_BFu7ll()
{
  {
    init_simple_test("aS_BFu1s_BFu7ll");
    static STRUCT_IF_C aS_BFu1s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu7ll, aS_BFu1s_BFu7ll)
//============================================================================



static void Test_aS_BFu1s_BFu7s()
{
  {
    init_simple_test("aS_BFu1s_BFu7s");
    static STRUCT_IF_C aS_BFu1s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu1s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aS_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aS_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu7s, aS_BFu1s_BFu7s)
//============================================================================



static void Test_aS_BFu1s_BFu8c()
{
  {
    init_simple_test("aS_BFu1s_BFu8c");
    static STRUCT_IF_C aS_BFu1s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu8c, aS_BFu1s_BFu8c)
//============================================================================



static void Test_aS_BFu1s_BFu8i()
{
  {
    init_simple_test("aS_BFu1s_BFu8i");
    static STRUCT_IF_C aS_BFu1s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu8i, aS_BFu1s_BFu8i)
//============================================================================



static void Test_aS_BFu1s_BFu8ll()
{
  {
    init_simple_test("aS_BFu1s_BFu8ll");
    static STRUCT_IF_C aS_BFu1s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu8ll, aS_BFu1s_BFu8ll)
//============================================================================



static void Test_aS_BFu1s_BFu8s()
{
  {
    init_simple_test("aS_BFu1s_BFu8s");
    static STRUCT_IF_C aS_BFu1s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aS_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aS_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu8s, aS_BFu1s_BFu8s)
//============================================================================



static void Test_aS_BFu1s_BFu9i()
{
  {
    init_simple_test("aS_BFu1s_BFu9i");
    static STRUCT_IF_C aS_BFu1s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aS_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aS_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu9i, aS_BFu1s_BFu9i)
//============================================================================



static void Test_aS_BFu1s_BFu9ll()
{
  {
    init_simple_test("aS_BFu1s_BFu9ll");
    static STRUCT_IF_C aS_BFu1s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aS_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aS_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu9ll, aS_BFu1s_BFu9ll)
//============================================================================



static void Test_aS_BFu1s_BFu9s()
{
  {
    init_simple_test("aS_BFu1s_BFu9s");
    static STRUCT_IF_C aS_BFu1s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aS_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aS_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_BFu9s, aS_BFu1s_BFu9s)
//============================================================================



static void Test_aS_BFu1s_C()
{
  {
    init_simple_test("aS_BFu1s_C");
    static STRUCT_IF_C aS_BFu1s_C lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_C)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_C");
    check_field_offset(lv, v3, 3, "aS_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_C, aS_BFu1s_C)
//============================================================================



static void Test_aS_BFu1s_D()
{
  {
    init_simple_test("aS_BFu1s_D");
    static STRUCT_IF_C aS_BFu1s_D lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu1s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_D)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_D");
    check_field_offset(lv, v3, 3, "aS_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_D, aS_BFu1s_D)
//============================================================================



static void Test_aS_BFu1s_F()
{
  {
    init_simple_test("aS_BFu1s_F");
    static STRUCT_IF_C aS_BFu1s_F lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_F)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_F");
    check_field_offset(lv, v3, 3, "aS_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_F, aS_BFu1s_F)
//============================================================================



static void Test_aS_BFu1s_I()
{
  {
    init_simple_test("aS_BFu1s_I");
    static STRUCT_IF_C aS_BFu1s_I lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_I)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_I");
    check_field_offset(lv, v3, 3, "aS_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_I, aS_BFu1s_I)
//============================================================================



static void Test_aS_BFu1s_Ip()
{
  {
    init_simple_test("aS_BFu1s_Ip");
    static STRUCT_IF_C aS_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu1s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_Ip");
    check_field_offset(lv, v3, 3, "aS_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_Ip, aS_BFu1s_Ip)
//============================================================================



static void Test_aS_BFu1s_L()
{
  {
    init_simple_test("aS_BFu1s_L");
    static STRUCT_IF_C aS_BFu1s_L lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu1s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_L)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_L");
    check_field_offset(lv, v3, 3, "aS_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_L, aS_BFu1s_L)
//============================================================================



static void Test_aS_BFu1s_S()
{
  {
    init_simple_test("aS_BFu1s_S");
    static STRUCT_IF_C aS_BFu1s_S lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_S)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_S");
    check_field_offset(lv, v3, 3, "aS_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_S, aS_BFu1s_S)
//============================================================================



static void Test_aS_BFu1s_Uc()
{
  {
    init_simple_test("aS_BFu1s_Uc");
    static STRUCT_IF_C aS_BFu1s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu1s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_Uc");
    check_field_offset(lv, v3, 3, "aS_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_Uc, aS_BFu1s_Uc)
//============================================================================



static void Test_aS_BFu1s_Ui()
{
  {
    init_simple_test("aS_BFu1s_Ui");
    static STRUCT_IF_C aS_BFu1s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu1s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_Ui");
    check_field_offset(lv, v3, 3, "aS_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_Ui, aS_BFu1s_Ui)
//============================================================================



static void Test_aS_BFu1s_Ul()
{
  {
    init_simple_test("aS_BFu1s_Ul");
    static STRUCT_IF_C aS_BFu1s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu1s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_Ul");
    check_field_offset(lv, v3, 3, "aS_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_Ul, aS_BFu1s_Ul)
//============================================================================



static void Test_aS_BFu1s_Us()
{
  {
    init_simple_test("aS_BFu1s_Us");
    static STRUCT_IF_C aS_BFu1s_Us lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu1s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_Us");
    check_field_offset(lv, v3, 3, "aS_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_Us, aS_BFu1s_Us)
//============================================================================



static void Test_aS_BFu1s_Vp()
{
  {
    init_simple_test("aS_BFu1s_Vp");
    static STRUCT_IF_C aS_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu1s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aS_BFu1s_Vp");
    check_field_offset(lv, v3, 3, "aS_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu1s_Vp, aS_BFu1s_Vp)
//============================================================================



static void Test_aS_BFu31i()
{
  {
    init_simple_test("aS_BFu31i");
    static STRUCT_IF_C aS_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i, aS_BFu31i)
//============================================================================



static void Test_aS_BFu31i_BFu15i()
{
  {
    init_simple_test("aS_BFu31i_BFu15i");
    static STRUCT_IF_C aS_BFu31i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aS_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aS_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu15i, aS_BFu31i_BFu15i)
//============================================================================



static void Test_aS_BFu31i_BFu15ll()
{
  {
    init_simple_test("aS_BFu31i_BFu15ll");
    static STRUCT_IF_C aS_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aS_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aS_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu15ll, aS_BFu31i_BFu15ll)
//============================================================================



static void Test_aS_BFu31i_BFu15s()
{
  {
    init_simple_test("aS_BFu31i_BFu15s");
    static STRUCT_IF_C aS_BFu31i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aS_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aS_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu15s, aS_BFu31i_BFu15s)
//============================================================================



static void Test_aS_BFu31i_BFu16i()
{
  {
    init_simple_test("aS_BFu31i_BFu16i");
    static STRUCT_IF_C aS_BFu31i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aS_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aS_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu16i, aS_BFu31i_BFu16i)
//============================================================================



static void Test_aS_BFu31i_BFu16ll()
{
  {
    init_simple_test("aS_BFu31i_BFu16ll");
    static STRUCT_IF_C aS_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aS_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aS_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu16ll, aS_BFu31i_BFu16ll)
//============================================================================



static void Test_aS_BFu31i_BFu16s()
{
  {
    init_simple_test("aS_BFu31i_BFu16s");
    static STRUCT_IF_C aS_BFu31i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aS_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aS_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu16s, aS_BFu31i_BFu16s)
//============================================================================



static void Test_aS_BFu31i_BFu17i()
{
  {
    init_simple_test("aS_BFu31i_BFu17i");
    static STRUCT_IF_C aS_BFu31i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aS_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aS_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu17i, aS_BFu31i_BFu17i)
//============================================================================



static void Test_aS_BFu31i_BFu17ll()
{
  {
    init_simple_test("aS_BFu31i_BFu17ll");
    static STRUCT_IF_C aS_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aS_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aS_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu17ll, aS_BFu31i_BFu17ll)
//============================================================================



static void Test_aS_BFu31i_BFu1c()
{
  {
    init_simple_test("aS_BFu31i_BFu1c");
    static STRUCT_IF_C aS_BFu31i_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aS_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu1c, aS_BFu31i_BFu1c)
//============================================================================



static void Test_aS_BFu31i_BFu1i()
{
  {
    init_simple_test("aS_BFu31i_BFu1i");
    static STRUCT_IF_C aS_BFu31i_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aS_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu1i, aS_BFu31i_BFu1i)
//============================================================================



static void Test_aS_BFu31i_BFu1ll()
{
  {
    init_simple_test("aS_BFu31i_BFu1ll");
    static STRUCT_IF_C aS_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aS_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu1ll, aS_BFu31i_BFu1ll)
//============================================================================



static void Test_aS_BFu31i_BFu1s()
{
  {
    init_simple_test("aS_BFu31i_BFu1s");
    static STRUCT_IF_C aS_BFu31i_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aS_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu1s, aS_BFu31i_BFu1s)
//============================================================================



static void Test_aS_BFu31i_BFu31i()
{
  {
    init_simple_test("aS_BFu31i_BFu31i");
    static STRUCT_IF_C aS_BFu31i_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aS_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu31i, aS_BFu31i_BFu31i)
//============================================================================



static void Test_aS_BFu31i_BFu31ll()
{
  {
    init_simple_test("aS_BFu31i_BFu31ll");
    static STRUCT_IF_C aS_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aS_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu31ll, aS_BFu31i_BFu31ll)
//============================================================================



static void Test_aS_BFu31i_BFu32i()
{
  {
    init_simple_test("aS_BFu31i_BFu32i");
    static STRUCT_IF_C aS_BFu31i_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aS_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aS_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu32i, aS_BFu31i_BFu32i)
//============================================================================



static void Test_aS_BFu31i_BFu32ll()
{
  {
    init_simple_test("aS_BFu31i_BFu32ll");
    static STRUCT_IF_C aS_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aS_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aS_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu32ll, aS_BFu31i_BFu32ll)
//============================================================================



static void Test_aS_BFu31i_BFu33()
{
  {
    init_simple_test("aS_BFu31i_BFu33");
    static STRUCT_IF_C aS_BFu31i_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, 1, "aS_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, hide_ull(1LL<<32), "aS_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu33, aS_BFu31i_BFu33)
//============================================================================



static void Test_aS_BFu31i_BFu7c()
{
  {
    init_simple_test("aS_BFu31i_BFu7c");
    static STRUCT_IF_C aS_BFu31i_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aS_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aS_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu7c, aS_BFu31i_BFu7c)
//============================================================================



static void Test_aS_BFu31i_BFu7i()
{
  {
    init_simple_test("aS_BFu31i_BFu7i");
    static STRUCT_IF_C aS_BFu31i_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aS_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aS_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu7i, aS_BFu31i_BFu7i)
//============================================================================



static void Test_aS_BFu31i_BFu7ll()
{
  {
    init_simple_test("aS_BFu31i_BFu7ll");
    static STRUCT_IF_C aS_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aS_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aS_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu7ll, aS_BFu31i_BFu7ll)
//============================================================================



static void Test_aS_BFu31i_BFu7s()
{
  {
    init_simple_test("aS_BFu31i_BFu7s");
    static STRUCT_IF_C aS_BFu31i_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aS_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aS_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu7s, aS_BFu31i_BFu7s)
//============================================================================



static void Test_aS_BFu31i_BFu8c()
{
  {
    init_simple_test("aS_BFu31i_BFu8c");
    static STRUCT_IF_C aS_BFu31i_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aS_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aS_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu8c, aS_BFu31i_BFu8c)
//============================================================================



static void Test_aS_BFu31i_BFu8i()
{
  {
    init_simple_test("aS_BFu31i_BFu8i");
    static STRUCT_IF_C aS_BFu31i_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aS_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aS_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu8i, aS_BFu31i_BFu8i)
//============================================================================



static void Test_aS_BFu31i_BFu8ll()
{
  {
    init_simple_test("aS_BFu31i_BFu8ll");
    static STRUCT_IF_C aS_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aS_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aS_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu8ll, aS_BFu31i_BFu8ll)
//============================================================================



static void Test_aS_BFu31i_BFu8s()
{
  {
    init_simple_test("aS_BFu31i_BFu8s");
    static STRUCT_IF_C aS_BFu31i_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aS_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aS_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu8s, aS_BFu31i_BFu8s)
//============================================================================



static void Test_aS_BFu31i_BFu9i()
{
  {
    init_simple_test("aS_BFu31i_BFu9i");
    static STRUCT_IF_C aS_BFu31i_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aS_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aS_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu9i, aS_BFu31i_BFu9i)
//============================================================================



static void Test_aS_BFu31i_BFu9ll()
{
  {
    init_simple_test("aS_BFu31i_BFu9ll");
    static STRUCT_IF_C aS_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aS_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aS_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu9ll, aS_BFu31i_BFu9ll)
//============================================================================



static void Test_aS_BFu31i_BFu9s()
{
  {
    init_simple_test("aS_BFu31i_BFu9s");
    static STRUCT_IF_C aS_BFu31i_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aS_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aS_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_BFu9s, aS_BFu31i_BFu9s)
//============================================================================



static void Test_aS_BFu31i_C()
{
  {
    init_simple_test("aS_BFu31i_C");
    static STRUCT_IF_C aS_BFu31i_C lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_C)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_C");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_C");
    check_field_offset(lv, v3, 6, "aS_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_C, aS_BFu31i_C)
//============================================================================



static void Test_aS_BFu31i_D()
{
  {
    init_simple_test("aS_BFu31i_D");
    static STRUCT_IF_C aS_BFu31i_D lv;
    check2(sizeof(lv), 14, "sizeof(aS_BFu31i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_D)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_D");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_D");
    check_field_offset(lv, v3, 6, "aS_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_D, aS_BFu31i_D)
//============================================================================



static void Test_aS_BFu31i_F()
{
  {
    init_simple_test("aS_BFu31i_F");
    static STRUCT_IF_C aS_BFu31i_F lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_F)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_F");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_F");
    check_field_offset(lv, v3, 6, "aS_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_F, aS_BFu31i_F)
//============================================================================



static void Test_aS_BFu31i_I()
{
  {
    init_simple_test("aS_BFu31i_I");
    static STRUCT_IF_C aS_BFu31i_I lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_I)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_I");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_I");
    check_field_offset(lv, v3, 6, "aS_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_I, aS_BFu31i_I)
//============================================================================



static void Test_aS_BFu31i_Ip()
{
  {
    init_simple_test("aS_BFu31i_Ip");
    static STRUCT_IF_C aS_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aS_BFu31i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_Ip");
    check_field_offset(lv, v3, 6, "aS_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_Ip, aS_BFu31i_Ip)
//============================================================================



static void Test_aS_BFu31i_L()
{
  {
    init_simple_test("aS_BFu31i_L");
    static STRUCT_IF_C aS_BFu31i_L lv;
    check2(sizeof(lv), 14, "sizeof(aS_BFu31i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_L)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_L");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_L");
    check_field_offset(lv, v3, 6, "aS_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_L, aS_BFu31i_L)
//============================================================================



static void Test_aS_BFu31i_S()
{
  {
    init_simple_test("aS_BFu31i_S");
    static STRUCT_IF_C aS_BFu31i_S lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_S)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_S");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_S");
    check_field_offset(lv, v3, 6, "aS_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_S, aS_BFu31i_S)
//============================================================================



static void Test_aS_BFu31i_Uc()
{
  {
    init_simple_test("aS_BFu31i_Uc");
    static STRUCT_IF_C aS_BFu31i_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_Uc");
    check_field_offset(lv, v3, 6, "aS_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_Uc, aS_BFu31i_Uc)
//============================================================================



static void Test_aS_BFu31i_Ui()
{
  {
    init_simple_test("aS_BFu31i_Ui");
    static STRUCT_IF_C aS_BFu31i_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_Ui");
    check_field_offset(lv, v3, 6, "aS_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_Ui, aS_BFu31i_Ui)
//============================================================================



static void Test_aS_BFu31i_Ul()
{
  {
    init_simple_test("aS_BFu31i_Ul");
    static STRUCT_IF_C aS_BFu31i_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aS_BFu31i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_Ul");
    check_field_offset(lv, v3, 6, "aS_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_Ul, aS_BFu31i_Ul)
//============================================================================



static void Test_aS_BFu31i_Us()
{
  {
    init_simple_test("aS_BFu31i_Us");
    static STRUCT_IF_C aS_BFu31i_Us lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_Us");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_Us");
    check_field_offset(lv, v3, 6, "aS_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_Us, aS_BFu31i_Us)
//============================================================================



static void Test_aS_BFu31i_Vp()
{
  {
    init_simple_test("aS_BFu31i_Vp");
    static STRUCT_IF_C aS_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aS_BFu31i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31i_Vp");
    check_field_offset(lv, v3, 6, "aS_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31i_Vp, aS_BFu31i_Vp)
//============================================================================



static void Test_aS_BFu31ll()
{
  {
    init_simple_test("aS_BFu31ll");
    static STRUCT_IF_C aS_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll, aS_BFu31ll)
//============================================================================



static void Test_aS_BFu31ll_BFu15i()
{
  {
    init_simple_test("aS_BFu31ll_BFu15i");
    static STRUCT_IF_C aS_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aS_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aS_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu15i, aS_BFu31ll_BFu15i)
//============================================================================



static void Test_aS_BFu31ll_BFu15ll()
{
  {
    init_simple_test("aS_BFu31ll_BFu15ll");
    static STRUCT_IF_C aS_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aS_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aS_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu15ll, aS_BFu31ll_BFu15ll)
//============================================================================



static void Test_aS_BFu31ll_BFu15s()
{
  {
    init_simple_test("aS_BFu31ll_BFu15s");
    static STRUCT_IF_C aS_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aS_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aS_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu15s, aS_BFu31ll_BFu15s)
//============================================================================



static void Test_aS_BFu31ll_BFu16i()
{
  {
    init_simple_test("aS_BFu31ll_BFu16i");
    static STRUCT_IF_C aS_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aS_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aS_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu16i, aS_BFu31ll_BFu16i)
//============================================================================



static void Test_aS_BFu31ll_BFu16ll()
{
  {
    init_simple_test("aS_BFu31ll_BFu16ll");
    static STRUCT_IF_C aS_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aS_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aS_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu16ll, aS_BFu31ll_BFu16ll)
//============================================================================



static void Test_aS_BFu31ll_BFu16s()
{
  {
    init_simple_test("aS_BFu31ll_BFu16s");
    static STRUCT_IF_C aS_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aS_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aS_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu16s, aS_BFu31ll_BFu16s)
//============================================================================



static void Test_aS_BFu31ll_BFu17i()
{
  {
    init_simple_test("aS_BFu31ll_BFu17i");
    static STRUCT_IF_C aS_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aS_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aS_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu17i, aS_BFu31ll_BFu17i)
//============================================================================



static void Test_aS_BFu31ll_BFu17ll()
{
  {
    init_simple_test("aS_BFu31ll_BFu17ll");
    static STRUCT_IF_C aS_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aS_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aS_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu17ll, aS_BFu31ll_BFu17ll)
//============================================================================



static void Test_aS_BFu31ll_BFu1c()
{
  {
    init_simple_test("aS_BFu31ll_BFu1c");
    static STRUCT_IF_C aS_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aS_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu1c, aS_BFu31ll_BFu1c)
//============================================================================



static void Test_aS_BFu31ll_BFu1i()
{
  {
    init_simple_test("aS_BFu31ll_BFu1i");
    static STRUCT_IF_C aS_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aS_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu1i, aS_BFu31ll_BFu1i)
//============================================================================



static void Test_aS_BFu31ll_BFu1ll()
{
  {
    init_simple_test("aS_BFu31ll_BFu1ll");
    static STRUCT_IF_C aS_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aS_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu1ll, aS_BFu31ll_BFu1ll)
//============================================================================



static void Test_aS_BFu31ll_BFu1s()
{
  {
    init_simple_test("aS_BFu31ll_BFu1s");
    static STRUCT_IF_C aS_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu31ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aS_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu1s, aS_BFu31ll_BFu1s)
//============================================================================



static void Test_aS_BFu31ll_BFu31i()
{
  {
    init_simple_test("aS_BFu31ll_BFu31i");
    static STRUCT_IF_C aS_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aS_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu31i, aS_BFu31ll_BFu31i)
//============================================================================



static void Test_aS_BFu31ll_BFu31ll()
{
  {
    init_simple_test("aS_BFu31ll_BFu31ll");
    static STRUCT_IF_C aS_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aS_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu31ll, aS_BFu31ll_BFu31ll)
//============================================================================



static void Test_aS_BFu31ll_BFu32i()
{
  {
    init_simple_test("aS_BFu31ll_BFu32i");
    static STRUCT_IF_C aS_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aS_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aS_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu32i, aS_BFu31ll_BFu32i)
//============================================================================



static void Test_aS_BFu31ll_BFu32ll()
{
  {
    init_simple_test("aS_BFu31ll_BFu32ll");
    static STRUCT_IF_C aS_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aS_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aS_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu32ll, aS_BFu31ll_BFu32ll)
//============================================================================



static void Test_aS_BFu31ll_BFu33()
{
  {
    init_simple_test("aS_BFu31ll_BFu33");
    static STRUCT_IF_C aS_BFu31ll_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, 1, "aS_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, hide_ull(1LL<<32), "aS_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu33, aS_BFu31ll_BFu33)
//============================================================================



static void Test_aS_BFu31ll_BFu7c()
{
  {
    init_simple_test("aS_BFu31ll_BFu7c");
    static STRUCT_IF_C aS_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aS_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aS_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu7c, aS_BFu31ll_BFu7c)
//============================================================================



static void Test_aS_BFu31ll_BFu7i()
{
  {
    init_simple_test("aS_BFu31ll_BFu7i");
    static STRUCT_IF_C aS_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aS_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aS_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu7i, aS_BFu31ll_BFu7i)
//============================================================================



static void Test_aS_BFu31ll_BFu7ll()
{
  {
    init_simple_test("aS_BFu31ll_BFu7ll");
    static STRUCT_IF_C aS_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aS_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aS_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu7ll, aS_BFu31ll_BFu7ll)
//============================================================================



static void Test_aS_BFu31ll_BFu7s()
{
  {
    init_simple_test("aS_BFu31ll_BFu7s");
    static STRUCT_IF_C aS_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aS_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aS_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu7s, aS_BFu31ll_BFu7s)
//============================================================================



static void Test_aS_BFu31ll_BFu8c()
{
  {
    init_simple_test("aS_BFu31ll_BFu8c");
    static STRUCT_IF_C aS_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aS_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aS_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu8c, aS_BFu31ll_BFu8c)
//============================================================================



static void Test_aS_BFu31ll_BFu8i()
{
  {
    init_simple_test("aS_BFu31ll_BFu8i");
    static STRUCT_IF_C aS_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aS_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aS_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu8i, aS_BFu31ll_BFu8i)
//============================================================================



static void Test_aS_BFu31ll_BFu8ll()
{
  {
    init_simple_test("aS_BFu31ll_BFu8ll");
    static STRUCT_IF_C aS_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aS_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aS_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu8ll, aS_BFu31ll_BFu8ll)
//============================================================================



static void Test_aS_BFu31ll_BFu8s()
{
  {
    init_simple_test("aS_BFu31ll_BFu8s");
    static STRUCT_IF_C aS_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aS_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aS_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu8s, aS_BFu31ll_BFu8s)
//============================================================================



static void Test_aS_BFu31ll_BFu9i()
{
  {
    init_simple_test("aS_BFu31ll_BFu9i");
    static STRUCT_IF_C aS_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aS_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aS_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu9i, aS_BFu31ll_BFu9i)
//============================================================================



static void Test_aS_BFu31ll_BFu9ll()
{
  {
    init_simple_test("aS_BFu31ll_BFu9ll");
    static STRUCT_IF_C aS_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aS_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aS_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu9ll, aS_BFu31ll_BFu9ll)
//============================================================================



static void Test_aS_BFu31ll_BFu9s()
{
  {
    init_simple_test("aS_BFu31ll_BFu9s");
    static STRUCT_IF_C aS_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aS_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aS_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_BFu9s, aS_BFu31ll_BFu9s)
//============================================================================



static void Test_aS_BFu31ll_C()
{
  {
    init_simple_test("aS_BFu31ll_C");
    static STRUCT_IF_C aS_BFu31ll_C lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_C");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_C");
    check_field_offset(lv, v3, 6, "aS_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_C, aS_BFu31ll_C)
//============================================================================



static void Test_aS_BFu31ll_D()
{
  {
    init_simple_test("aS_BFu31ll_D");
    static STRUCT_IF_C aS_BFu31ll_D lv;
    check2(sizeof(lv), 14, "sizeof(aS_BFu31ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_D");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_D");
    check_field_offset(lv, v3, 6, "aS_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_D, aS_BFu31ll_D)
//============================================================================



static void Test_aS_BFu31ll_F()
{
  {
    init_simple_test("aS_BFu31ll_F");
    static STRUCT_IF_C aS_BFu31ll_F lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_F");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_F");
    check_field_offset(lv, v3, 6, "aS_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_F, aS_BFu31ll_F)
//============================================================================



static void Test_aS_BFu31ll_I()
{
  {
    init_simple_test("aS_BFu31ll_I");
    static STRUCT_IF_C aS_BFu31ll_I lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_I");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_I");
    check_field_offset(lv, v3, 6, "aS_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_I, aS_BFu31ll_I)
//============================================================================



static void Test_aS_BFu31ll_Ip()
{
  {
    init_simple_test("aS_BFu31ll_Ip");
    static STRUCT_IF_C aS_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aS_BFu31ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_Ip");
    check_field_offset(lv, v3, 6, "aS_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_Ip, aS_BFu31ll_Ip)
//============================================================================



static void Test_aS_BFu31ll_L()
{
  {
    init_simple_test("aS_BFu31ll_L");
    static STRUCT_IF_C aS_BFu31ll_L lv;
    check2(sizeof(lv), 14, "sizeof(aS_BFu31ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_L");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_L");
    check_field_offset(lv, v3, 6, "aS_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_L, aS_BFu31ll_L)
//============================================================================



static void Test_aS_BFu31ll_S()
{
  {
    init_simple_test("aS_BFu31ll_S");
    static STRUCT_IF_C aS_BFu31ll_S lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_S");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_S");
    check_field_offset(lv, v3, 6, "aS_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_S, aS_BFu31ll_S)
//============================================================================



static void Test_aS_BFu31ll_Uc()
{
  {
    init_simple_test("aS_BFu31ll_Uc");
    static STRUCT_IF_C aS_BFu31ll_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu31ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_Uc");
    check_field_offset(lv, v3, 6, "aS_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_Uc, aS_BFu31ll_Uc)
//============================================================================



static void Test_aS_BFu31ll_Ui()
{
  {
    init_simple_test("aS_BFu31ll_Ui");
    static STRUCT_IF_C aS_BFu31ll_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu31ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_Ui");
    check_field_offset(lv, v3, 6, "aS_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_Ui, aS_BFu31ll_Ui)
//============================================================================



static void Test_aS_BFu31ll_Ul()
{
  {
    init_simple_test("aS_BFu31ll_Ul");
    static STRUCT_IF_C aS_BFu31ll_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aS_BFu31ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_Ul");
    check_field_offset(lv, v3, 6, "aS_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_Ul, aS_BFu31ll_Ul)
//============================================================================



static void Test_aS_BFu31ll_Us()
{
  {
    init_simple_test("aS_BFu31ll_Us");
    static STRUCT_IF_C aS_BFu31ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu31ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_Us");
    check_field_offset(lv, v3, 6, "aS_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_Us, aS_BFu31ll_Us)
//============================================================================



static void Test_aS_BFu31ll_Vp()
{
  {
    init_simple_test("aS_BFu31ll_Vp");
    static STRUCT_IF_C aS_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aS_BFu31ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aS_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aS_BFu31ll_Vp");
    check_field_offset(lv, v3, 6, "aS_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu31ll_Vp, aS_BFu31ll_Vp)
//============================================================================



static void Test_aS_BFu32i()
{
  {
    init_simple_test("aS_BFu32i");
    static STRUCT_IF_C aS_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i, aS_BFu32i)
//============================================================================



static void Test_aS_BFu32i_BFu15i()
{
  {
    init_simple_test("aS_BFu32i_BFu15i");
    static STRUCT_IF_C aS_BFu32i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aS_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aS_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu15i, aS_BFu32i_BFu15i)
//============================================================================



static void Test_aS_BFu32i_BFu15ll()
{
  {
    init_simple_test("aS_BFu32i_BFu15ll");
    static STRUCT_IF_C aS_BFu32i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aS_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aS_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu15ll, aS_BFu32i_BFu15ll)
//============================================================================



static void Test_aS_BFu32i_BFu15s()
{
  {
    init_simple_test("aS_BFu32i_BFu15s");
    static STRUCT_IF_C aS_BFu32i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aS_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aS_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu15s, aS_BFu32i_BFu15s)
//============================================================================



static void Test_aS_BFu32i_BFu16i()
{
  {
    init_simple_test("aS_BFu32i_BFu16i");
    static STRUCT_IF_C aS_BFu32i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aS_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aS_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu16i, aS_BFu32i_BFu16i)
//============================================================================



static void Test_aS_BFu32i_BFu16ll()
{
  {
    init_simple_test("aS_BFu32i_BFu16ll");
    static STRUCT_IF_C aS_BFu32i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aS_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aS_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu16ll, aS_BFu32i_BFu16ll)
//============================================================================



static void Test_aS_BFu32i_BFu16s()
{
  {
    init_simple_test("aS_BFu32i_BFu16s");
    static STRUCT_IF_C aS_BFu32i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aS_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aS_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu16s, aS_BFu32i_BFu16s)
//============================================================================



static void Test_aS_BFu32i_BFu17i()
{
  {
    init_simple_test("aS_BFu32i_BFu17i");
    static STRUCT_IF_C aS_BFu32i_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu32i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aS_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aS_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu17i, aS_BFu32i_BFu17i)
//============================================================================



static void Test_aS_BFu32i_BFu17ll()
{
  {
    init_simple_test("aS_BFu32i_BFu17ll");
    static STRUCT_IF_C aS_BFu32i_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu32i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aS_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aS_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu17ll, aS_BFu32i_BFu17ll)
//============================================================================



static void Test_aS_BFu32i_BFu1c()
{
  {
    init_simple_test("aS_BFu32i_BFu1c");
    static STRUCT_IF_C aS_BFu32i_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aS_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu1c, aS_BFu32i_BFu1c)
//============================================================================



static void Test_aS_BFu32i_BFu1i()
{
  {
    init_simple_test("aS_BFu32i_BFu1i");
    static STRUCT_IF_C aS_BFu32i_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aS_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu1i, aS_BFu32i_BFu1i)
//============================================================================



static void Test_aS_BFu32i_BFu1ll()
{
  {
    init_simple_test("aS_BFu32i_BFu1ll");
    static STRUCT_IF_C aS_BFu32i_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aS_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu1ll, aS_BFu32i_BFu1ll)
//============================================================================



static void Test_aS_BFu32i_BFu1s()
{
  {
    init_simple_test("aS_BFu32i_BFu1s");
    static STRUCT_IF_C aS_BFu32i_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aS_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu1s, aS_BFu32i_BFu1s)
//============================================================================



static void Test_aS_BFu32i_BFu31i()
{
  {
    init_simple_test("aS_BFu32i_BFu31i");
    static STRUCT_IF_C aS_BFu32i_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aS_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aS_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu31i, aS_BFu32i_BFu31i)
//============================================================================



static void Test_aS_BFu32i_BFu31ll()
{
  {
    init_simple_test("aS_BFu32i_BFu31ll");
    static STRUCT_IF_C aS_BFu32i_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aS_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aS_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu31ll, aS_BFu32i_BFu31ll)
//============================================================================



static void Test_aS_BFu32i_BFu32i()
{
  {
    init_simple_test("aS_BFu32i_BFu32i");
    static STRUCT_IF_C aS_BFu32i_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aS_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu32i, aS_BFu32i_BFu32i)
//============================================================================



static void Test_aS_BFu32i_BFu32ll()
{
  {
    init_simple_test("aS_BFu32i_BFu32ll");
    static STRUCT_IF_C aS_BFu32i_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aS_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu32ll, aS_BFu32i_BFu32ll)
//============================================================================



static void Test_aS_BFu32i_BFu33()
{
  {
    init_simple_test("aS_BFu32i_BFu33");
    static STRUCT_IF_C aS_BFu32i_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu32i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "aS_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "aS_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu33, aS_BFu32i_BFu33)
//============================================================================



static void Test_aS_BFu32i_BFu7c()
{
  {
    init_simple_test("aS_BFu32i_BFu7c");
    static STRUCT_IF_C aS_BFu32i_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aS_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aS_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu7c, aS_BFu32i_BFu7c)
//============================================================================



static void Test_aS_BFu32i_BFu7i()
{
  {
    init_simple_test("aS_BFu32i_BFu7i");
    static STRUCT_IF_C aS_BFu32i_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aS_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aS_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu7i, aS_BFu32i_BFu7i)
//============================================================================



static void Test_aS_BFu32i_BFu7ll()
{
  {
    init_simple_test("aS_BFu32i_BFu7ll");
    static STRUCT_IF_C aS_BFu32i_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aS_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aS_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu7ll, aS_BFu32i_BFu7ll)
//============================================================================



static void Test_aS_BFu32i_BFu7s()
{
  {
    init_simple_test("aS_BFu32i_BFu7s");
    static STRUCT_IF_C aS_BFu32i_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aS_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aS_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu7s, aS_BFu32i_BFu7s)
//============================================================================



static void Test_aS_BFu32i_BFu8c()
{
  {
    init_simple_test("aS_BFu32i_BFu8c");
    static STRUCT_IF_C aS_BFu32i_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aS_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aS_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu8c, aS_BFu32i_BFu8c)
//============================================================================



static void Test_aS_BFu32i_BFu8i()
{
  {
    init_simple_test("aS_BFu32i_BFu8i");
    static STRUCT_IF_C aS_BFu32i_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aS_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aS_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu8i, aS_BFu32i_BFu8i)
//============================================================================



static void Test_aS_BFu32i_BFu8ll()
{
  {
    init_simple_test("aS_BFu32i_BFu8ll");
    static STRUCT_IF_C aS_BFu32i_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aS_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aS_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu8ll, aS_BFu32i_BFu8ll)
//============================================================================



static void Test_aS_BFu32i_BFu8s()
{
  {
    init_simple_test("aS_BFu32i_BFu8s");
    static STRUCT_IF_C aS_BFu32i_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aS_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aS_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu8s, aS_BFu32i_BFu8s)
//============================================================================



static void Test_aS_BFu32i_BFu9i()
{
  {
    init_simple_test("aS_BFu32i_BFu9i");
    static STRUCT_IF_C aS_BFu32i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aS_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aS_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu9i, aS_BFu32i_BFu9i)
//============================================================================



static void Test_aS_BFu32i_BFu9ll()
{
  {
    init_simple_test("aS_BFu32i_BFu9ll");
    static STRUCT_IF_C aS_BFu32i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aS_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aS_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu9ll, aS_BFu32i_BFu9ll)
//============================================================================



static void Test_aS_BFu32i_BFu9s()
{
  {
    init_simple_test("aS_BFu32i_BFu9s");
    static STRUCT_IF_C aS_BFu32i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aS_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aS_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_BFu9s, aS_BFu32i_BFu9s)
//============================================================================



static void Test_aS_BFu32i_C()
{
  {
    init_simple_test("aS_BFu32i_C");
    static STRUCT_IF_C aS_BFu32i_C lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_C)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_C");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_C");
    check_field_offset(lv, v3, 6, "aS_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_C, aS_BFu32i_C)
//============================================================================



static void Test_aS_BFu32i_D()
{
  {
    init_simple_test("aS_BFu32i_D");
    static STRUCT_IF_C aS_BFu32i_D lv;
    check2(sizeof(lv), 14, "sizeof(aS_BFu32i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_D)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_D");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_D");
    check_field_offset(lv, v3, 6, "aS_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_D, aS_BFu32i_D)
//============================================================================



static void Test_aS_BFu32i_F()
{
  {
    init_simple_test("aS_BFu32i_F");
    static STRUCT_IF_C aS_BFu32i_F lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_F)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_F");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_F");
    check_field_offset(lv, v3, 6, "aS_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_F, aS_BFu32i_F)
//============================================================================



static void Test_aS_BFu32i_I()
{
  {
    init_simple_test("aS_BFu32i_I");
    static STRUCT_IF_C aS_BFu32i_I lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_I)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_I");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_I");
    check_field_offset(lv, v3, 6, "aS_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_I, aS_BFu32i_I)
//============================================================================



static void Test_aS_BFu32i_Ip()
{
  {
    init_simple_test("aS_BFu32i_Ip");
    static STRUCT_IF_C aS_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aS_BFu32i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_Ip");
    check_field_offset(lv, v3, 6, "aS_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_Ip, aS_BFu32i_Ip)
//============================================================================



static void Test_aS_BFu32i_L()
{
  {
    init_simple_test("aS_BFu32i_L");
    static STRUCT_IF_C aS_BFu32i_L lv;
    check2(sizeof(lv), 14, "sizeof(aS_BFu32i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_L)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_L");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_L");
    check_field_offset(lv, v3, 6, "aS_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_L, aS_BFu32i_L)
//============================================================================



static void Test_aS_BFu32i_S()
{
  {
    init_simple_test("aS_BFu32i_S");
    static STRUCT_IF_C aS_BFu32i_S lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_S)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_S");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_S");
    check_field_offset(lv, v3, 6, "aS_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_S, aS_BFu32i_S)
//============================================================================



static void Test_aS_BFu32i_Uc()
{
  {
    init_simple_test("aS_BFu32i_Uc");
    static STRUCT_IF_C aS_BFu32i_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_Uc");
    check_field_offset(lv, v3, 6, "aS_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_Uc, aS_BFu32i_Uc)
//============================================================================



static void Test_aS_BFu32i_Ui()
{
  {
    init_simple_test("aS_BFu32i_Ui");
    static STRUCT_IF_C aS_BFu32i_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_Ui");
    check_field_offset(lv, v3, 6, "aS_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_Ui, aS_BFu32i_Ui)
//============================================================================



static void Test_aS_BFu32i_Ul()
{
  {
    init_simple_test("aS_BFu32i_Ul");
    static STRUCT_IF_C aS_BFu32i_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aS_BFu32i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_Ul");
    check_field_offset(lv, v3, 6, "aS_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_Ul, aS_BFu32i_Ul)
//============================================================================



static void Test_aS_BFu32i_Us()
{
  {
    init_simple_test("aS_BFu32i_Us");
    static STRUCT_IF_C aS_BFu32i_Us lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_Us");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_Us");
    check_field_offset(lv, v3, 6, "aS_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_Us, aS_BFu32i_Us)
//============================================================================



static void Test_aS_BFu32i_Vp()
{
  {
    init_simple_test("aS_BFu32i_Vp");
    static STRUCT_IF_C aS_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aS_BFu32i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32i_Vp");
    check_field_offset(lv, v3, 6, "aS_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32i_Vp, aS_BFu32i_Vp)
//============================================================================



static void Test_aS_BFu32ll()
{
  {
    init_simple_test("aS_BFu32ll");
    static STRUCT_IF_C aS_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll, aS_BFu32ll)
//============================================================================



static void Test_aS_BFu32ll_BFu15i()
{
  {
    init_simple_test("aS_BFu32ll_BFu15i");
    static STRUCT_IF_C aS_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aS_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aS_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu15i, aS_BFu32ll_BFu15i)
//============================================================================



static void Test_aS_BFu32ll_BFu15ll()
{
  {
    init_simple_test("aS_BFu32ll_BFu15ll");
    static STRUCT_IF_C aS_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aS_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aS_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu15ll, aS_BFu32ll_BFu15ll)
//============================================================================



static void Test_aS_BFu32ll_BFu15s()
{
  {
    init_simple_test("aS_BFu32ll_BFu15s");
    static STRUCT_IF_C aS_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aS_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aS_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu15s, aS_BFu32ll_BFu15s)
//============================================================================



static void Test_aS_BFu32ll_BFu16i()
{
  {
    init_simple_test("aS_BFu32ll_BFu16i");
    static STRUCT_IF_C aS_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aS_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aS_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu16i, aS_BFu32ll_BFu16i)
//============================================================================



static void Test_aS_BFu32ll_BFu16ll()
{
  {
    init_simple_test("aS_BFu32ll_BFu16ll");
    static STRUCT_IF_C aS_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aS_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aS_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu16ll, aS_BFu32ll_BFu16ll)
//============================================================================



static void Test_aS_BFu32ll_BFu16s()
{
  {
    init_simple_test("aS_BFu32ll_BFu16s");
    static STRUCT_IF_C aS_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aS_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aS_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu16s, aS_BFu32ll_BFu16s)
//============================================================================



static void Test_aS_BFu32ll_BFu17i()
{
  {
    init_simple_test("aS_BFu32ll_BFu17i");
    static STRUCT_IF_C aS_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu32ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aS_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aS_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu17i, aS_BFu32ll_BFu17i)
//============================================================================



static void Test_aS_BFu32ll_BFu17ll()
{
  {
    init_simple_test("aS_BFu32ll_BFu17ll");
    static STRUCT_IF_C aS_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aS_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aS_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu17ll, aS_BFu32ll_BFu17ll)
//============================================================================



static void Test_aS_BFu32ll_BFu1c()
{
  {
    init_simple_test("aS_BFu32ll_BFu1c");
    static STRUCT_IF_C aS_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aS_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu1c, aS_BFu32ll_BFu1c)
//============================================================================



static void Test_aS_BFu32ll_BFu1i()
{
  {
    init_simple_test("aS_BFu32ll_BFu1i");
    static STRUCT_IF_C aS_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aS_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu1i, aS_BFu32ll_BFu1i)
//============================================================================



static void Test_aS_BFu32ll_BFu1ll()
{
  {
    init_simple_test("aS_BFu32ll_BFu1ll");
    static STRUCT_IF_C aS_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aS_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu1ll, aS_BFu32ll_BFu1ll)
//============================================================================



static void Test_aS_BFu32ll_BFu1s()
{
  {
    init_simple_test("aS_BFu32ll_BFu1s");
    static STRUCT_IF_C aS_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aS_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu1s, aS_BFu32ll_BFu1s)
//============================================================================



static void Test_aS_BFu32ll_BFu31i()
{
  {
    init_simple_test("aS_BFu32ll_BFu31i");
    static STRUCT_IF_C aS_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aS_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aS_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu31i, aS_BFu32ll_BFu31i)
//============================================================================



static void Test_aS_BFu32ll_BFu31ll()
{
  {
    init_simple_test("aS_BFu32ll_BFu31ll");
    static STRUCT_IF_C aS_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aS_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aS_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu31ll, aS_BFu32ll_BFu31ll)
//============================================================================



static void Test_aS_BFu32ll_BFu32i()
{
  {
    init_simple_test("aS_BFu32ll_BFu32i");
    static STRUCT_IF_C aS_BFu32ll_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aS_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu32i, aS_BFu32ll_BFu32i)
//============================================================================



static void Test_aS_BFu32ll_BFu32ll()
{
  {
    init_simple_test("aS_BFu32ll_BFu32ll");
    static STRUCT_IF_C aS_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aS_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu32ll, aS_BFu32ll_BFu32ll)
//============================================================================



static void Test_aS_BFu32ll_BFu33()
{
  {
    init_simple_test("aS_BFu32ll_BFu33");
    static STRUCT_IF_C aS_BFu32ll_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu32ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "aS_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "aS_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu33, aS_BFu32ll_BFu33)
//============================================================================



static void Test_aS_BFu32ll_BFu7c()
{
  {
    init_simple_test("aS_BFu32ll_BFu7c");
    static STRUCT_IF_C aS_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aS_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aS_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu7c, aS_BFu32ll_BFu7c)
//============================================================================



static void Test_aS_BFu32ll_BFu7i()
{
  {
    init_simple_test("aS_BFu32ll_BFu7i");
    static STRUCT_IF_C aS_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aS_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aS_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu7i, aS_BFu32ll_BFu7i)
//============================================================================



static void Test_aS_BFu32ll_BFu7ll()
{
  {
    init_simple_test("aS_BFu32ll_BFu7ll");
    static STRUCT_IF_C aS_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aS_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aS_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu7ll, aS_BFu32ll_BFu7ll)
//============================================================================



static void Test_aS_BFu32ll_BFu7s()
{
  {
    init_simple_test("aS_BFu32ll_BFu7s");
    static STRUCT_IF_C aS_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aS_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aS_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu7s, aS_BFu32ll_BFu7s)
//============================================================================



static void Test_aS_BFu32ll_BFu8c()
{
  {
    init_simple_test("aS_BFu32ll_BFu8c");
    static STRUCT_IF_C aS_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aS_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aS_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu8c, aS_BFu32ll_BFu8c)
//============================================================================



static void Test_aS_BFu32ll_BFu8i()
{
  {
    init_simple_test("aS_BFu32ll_BFu8i");
    static STRUCT_IF_C aS_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aS_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aS_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu8i, aS_BFu32ll_BFu8i)
//============================================================================



static void Test_aS_BFu32ll_BFu8ll()
{
  {
    init_simple_test("aS_BFu32ll_BFu8ll");
    static STRUCT_IF_C aS_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aS_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aS_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu8ll, aS_BFu32ll_BFu8ll)
//============================================================================



static void Test_aS_BFu32ll_BFu8s()
{
  {
    init_simple_test("aS_BFu32ll_BFu8s");
    static STRUCT_IF_C aS_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aS_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aS_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu8s, aS_BFu32ll_BFu8s)
//============================================================================



static void Test_aS_BFu32ll_BFu9i()
{
  {
    init_simple_test("aS_BFu32ll_BFu9i");
    static STRUCT_IF_C aS_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aS_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aS_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu9i, aS_BFu32ll_BFu9i)
//============================================================================



static void Test_aS_BFu32ll_BFu9ll()
{
  {
    init_simple_test("aS_BFu32ll_BFu9ll");
    static STRUCT_IF_C aS_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aS_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aS_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu9ll, aS_BFu32ll_BFu9ll)
//============================================================================



static void Test_aS_BFu32ll_BFu9s()
{
  {
    init_simple_test("aS_BFu32ll_BFu9s");
    static STRUCT_IF_C aS_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aS_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aS_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_BFu9s, aS_BFu32ll_BFu9s)
//============================================================================



static void Test_aS_BFu32ll_C()
{
  {
    init_simple_test("aS_BFu32ll_C");
    static STRUCT_IF_C aS_BFu32ll_C lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_C");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_C");
    check_field_offset(lv, v3, 6, "aS_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_C, aS_BFu32ll_C)
//============================================================================



static void Test_aS_BFu32ll_D()
{
  {
    init_simple_test("aS_BFu32ll_D");
    static STRUCT_IF_C aS_BFu32ll_D lv;
    check2(sizeof(lv), 14, "sizeof(aS_BFu32ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_D");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_D");
    check_field_offset(lv, v3, 6, "aS_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_D, aS_BFu32ll_D)
//============================================================================



static void Test_aS_BFu32ll_F()
{
  {
    init_simple_test("aS_BFu32ll_F");
    static STRUCT_IF_C aS_BFu32ll_F lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_F");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_F");
    check_field_offset(lv, v3, 6, "aS_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_F, aS_BFu32ll_F)
//============================================================================



static void Test_aS_BFu32ll_I()
{
  {
    init_simple_test("aS_BFu32ll_I");
    static STRUCT_IF_C aS_BFu32ll_I lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_I");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_I");
    check_field_offset(lv, v3, 6, "aS_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_I, aS_BFu32ll_I)
//============================================================================



static void Test_aS_BFu32ll_Ip()
{
  {
    init_simple_test("aS_BFu32ll_Ip");
    static STRUCT_IF_C aS_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aS_BFu32ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_Ip");
    check_field_offset(lv, v3, 6, "aS_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_Ip, aS_BFu32ll_Ip)
//============================================================================



static void Test_aS_BFu32ll_L()
{
  {
    init_simple_test("aS_BFu32ll_L");
    static STRUCT_IF_C aS_BFu32ll_L lv;
    check2(sizeof(lv), 14, "sizeof(aS_BFu32ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_L");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_L");
    check_field_offset(lv, v3, 6, "aS_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_L, aS_BFu32ll_L)
//============================================================================



static void Test_aS_BFu32ll_S()
{
  {
    init_simple_test("aS_BFu32ll_S");
    static STRUCT_IF_C aS_BFu32ll_S lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_S");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_S");
    check_field_offset(lv, v3, 6, "aS_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_S, aS_BFu32ll_S)
//============================================================================



static void Test_aS_BFu32ll_Uc()
{
  {
    init_simple_test("aS_BFu32ll_Uc");
    static STRUCT_IF_C aS_BFu32ll_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu32ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_Uc");
    check_field_offset(lv, v3, 6, "aS_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_Uc, aS_BFu32ll_Uc)
//============================================================================



static void Test_aS_BFu32ll_Ui()
{
  {
    init_simple_test("aS_BFu32ll_Ui");
    static STRUCT_IF_C aS_BFu32ll_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu32ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_Ui");
    check_field_offset(lv, v3, 6, "aS_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_Ui, aS_BFu32ll_Ui)
//============================================================================



static void Test_aS_BFu32ll_Ul()
{
  {
    init_simple_test("aS_BFu32ll_Ul");
    static STRUCT_IF_C aS_BFu32ll_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aS_BFu32ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_Ul");
    check_field_offset(lv, v3, 6, "aS_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_Ul, aS_BFu32ll_Ul)
//============================================================================



static void Test_aS_BFu32ll_Us()
{
  {
    init_simple_test("aS_BFu32ll_Us");
    static STRUCT_IF_C aS_BFu32ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu32ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_Us");
    check_field_offset(lv, v3, 6, "aS_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_Us, aS_BFu32ll_Us)
//============================================================================



static void Test_aS_BFu32ll_Vp()
{
  {
    init_simple_test("aS_BFu32ll_Vp");
    static STRUCT_IF_C aS_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aS_BFu32ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aS_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aS_BFu32ll_Vp");
    check_field_offset(lv, v3, 6, "aS_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu32ll_Vp, aS_BFu32ll_Vp)
//============================================================================



static void Test_aS_BFu33()
{
  {
    init_simple_test("aS_BFu33");
    static STRUCT_IF_C aS_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33, aS_BFu33)
//============================================================================



static void Test_aS_BFu33_BFu15i()
{
  {
    init_simple_test("aS_BFu33_BFu15i");
    static STRUCT_IF_C aS_BFu33_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu33_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "aS_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "aS_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu15i, aS_BFu33_BFu15i)
//============================================================================



static void Test_aS_BFu33_BFu15ll()
{
  {
    init_simple_test("aS_BFu33_BFu15ll");
    static STRUCT_IF_C aS_BFu33_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu33_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "aS_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "aS_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu15ll, aS_BFu33_BFu15ll)
//============================================================================



static void Test_aS_BFu33_BFu15s()
{
  {
    init_simple_test("aS_BFu33_BFu15s");
    static STRUCT_IF_C aS_BFu33_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu33_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "aS_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "aS_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu15s, aS_BFu33_BFu15s)
//============================================================================



static void Test_aS_BFu33_BFu16i()
{
  {
    init_simple_test("aS_BFu33_BFu16i");
    static STRUCT_IF_C aS_BFu33_BFu16i lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu33_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "aS_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "aS_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu16i, aS_BFu33_BFu16i)
//============================================================================



static void Test_aS_BFu33_BFu16ll()
{
  {
    init_simple_test("aS_BFu33_BFu16ll");
    static STRUCT_IF_C aS_BFu33_BFu16ll lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu33_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "aS_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "aS_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu16ll, aS_BFu33_BFu16ll)
//============================================================================



static void Test_aS_BFu33_BFu16s()
{
  {
    init_simple_test("aS_BFu33_BFu16s");
    static STRUCT_IF_C aS_BFu33_BFu16s lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu33_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "aS_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "aS_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu16s, aS_BFu33_BFu16s)
//============================================================================



static void Test_aS_BFu33_BFu17i()
{
  {
    init_simple_test("aS_BFu33_BFu17i");
    static STRUCT_IF_C aS_BFu33_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu33_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 6, 1, 17, 1, "aS_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 6, 1, 17, hide_ull(1LL<<16), "aS_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu17i, aS_BFu33_BFu17i)
//============================================================================



static void Test_aS_BFu33_BFu17ll()
{
  {
    init_simple_test("aS_BFu33_BFu17ll");
    static STRUCT_IF_C aS_BFu33_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu33_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 6, 1, 17, 1, "aS_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 6, 1, 17, hide_ull(1LL<<16), "aS_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu17ll, aS_BFu33_BFu17ll)
//============================================================================



static void Test_aS_BFu33_BFu1c()
{
  {
    init_simple_test("aS_BFu33_BFu1c");
    static STRUCT_IF_C aS_BFu33_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu33_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aS_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu1c, aS_BFu33_BFu1c)
//============================================================================



static void Test_aS_BFu33_BFu1i()
{
  {
    init_simple_test("aS_BFu33_BFu1i");
    static STRUCT_IF_C aS_BFu33_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu33_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aS_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu1i, aS_BFu33_BFu1i)
//============================================================================



static void Test_aS_BFu33_BFu1ll()
{
  {
    init_simple_test("aS_BFu33_BFu1ll");
    static STRUCT_IF_C aS_BFu33_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu33_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aS_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu1ll, aS_BFu33_BFu1ll)
//============================================================================



static void Test_aS_BFu33_BFu1s()
{
  {
    init_simple_test("aS_BFu33_BFu1s");
    static STRUCT_IF_C aS_BFu33_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu33_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aS_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu1s, aS_BFu33_BFu1s)
//============================================================================



static void Test_aS_BFu33_BFu31i()
{
  {
    init_simple_test("aS_BFu33_BFu31i");
    static STRUCT_IF_C aS_BFu33_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu33_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 6, 1, 31, 1, "aS_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 6, 1, 31, hide_ull(1LL<<30), "aS_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu31i, aS_BFu33_BFu31i)
//============================================================================



static void Test_aS_BFu33_BFu31ll()
{
  {
    init_simple_test("aS_BFu33_BFu31ll");
    static STRUCT_IF_C aS_BFu33_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aS_BFu33_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 6, 1, 31, 1, "aS_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 6, 1, 31, hide_ull(1LL<<30), "aS_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu31ll, aS_BFu33_BFu31ll)
//============================================================================



static void Test_aS_BFu33_BFu32i()
{
  {
    init_simple_test("aS_BFu33_BFu32i");
    static STRUCT_IF_C aS_BFu33_BFu32i lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu33_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 6, 1, 32, 1, "aS_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 6, 1, 32, hide_ull(1LL<<31), "aS_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu32i, aS_BFu33_BFu32i)
//============================================================================



static void Test_aS_BFu33_BFu32ll()
{
  {
    init_simple_test("aS_BFu33_BFu32ll");
    static STRUCT_IF_C aS_BFu33_BFu32ll lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu33_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 6, 1, 32, 1, "aS_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 6, 1, 32, hide_ull(1LL<<31), "aS_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu32ll, aS_BFu33_BFu32ll)
//============================================================================



static void Test_aS_BFu33_BFu33()
{
  {
    init_simple_test("aS_BFu33_BFu33");
    static STRUCT_IF_C aS_BFu33_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu33_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu33");
    set_bf_and_test(lv, v3, 6, 1, 33, 1, "aS_BFu33_BFu33");
    set_bf_and_test(lv, v3, 6, 1, 33, hide_ull(1LL<<32), "aS_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu33, aS_BFu33_BFu33)
//============================================================================



static void Test_aS_BFu33_BFu7c()
{
  {
    init_simple_test("aS_BFu33_BFu7c");
    static STRUCT_IF_C aS_BFu33_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu33_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aS_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aS_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu7c, aS_BFu33_BFu7c)
//============================================================================



static void Test_aS_BFu33_BFu7i()
{
  {
    init_simple_test("aS_BFu33_BFu7i");
    static STRUCT_IF_C aS_BFu33_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu33_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aS_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aS_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu7i, aS_BFu33_BFu7i)
//============================================================================



static void Test_aS_BFu33_BFu7ll()
{
  {
    init_simple_test("aS_BFu33_BFu7ll");
    static STRUCT_IF_C aS_BFu33_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu33_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aS_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aS_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu7ll, aS_BFu33_BFu7ll)
//============================================================================



static void Test_aS_BFu33_BFu7s()
{
  {
    init_simple_test("aS_BFu33_BFu7s");
    static STRUCT_IF_C aS_BFu33_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu33_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aS_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aS_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu7s, aS_BFu33_BFu7s)
//============================================================================



static void Test_aS_BFu33_BFu8c()
{
  {
    init_simple_test("aS_BFu33_BFu8c");
    static STRUCT_IF_C aS_BFu33_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu33_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aS_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aS_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu8c, aS_BFu33_BFu8c)
//============================================================================



static void Test_aS_BFu33_BFu8i()
{
  {
    init_simple_test("aS_BFu33_BFu8i");
    static STRUCT_IF_C aS_BFu33_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu33_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aS_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aS_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu8i, aS_BFu33_BFu8i)
//============================================================================



static void Test_aS_BFu33_BFu8ll()
{
  {
    init_simple_test("aS_BFu33_BFu8ll");
    static STRUCT_IF_C aS_BFu33_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu33_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aS_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aS_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu8ll, aS_BFu33_BFu8ll)
//============================================================================



static void Test_aS_BFu33_BFu8s()
{
  {
    init_simple_test("aS_BFu33_BFu8s");
    static STRUCT_IF_C aS_BFu33_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu33_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aS_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aS_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu8s, aS_BFu33_BFu8s)
//============================================================================



static void Test_aS_BFu33_BFu9i()
{
  {
    init_simple_test("aS_BFu33_BFu9i");
    static STRUCT_IF_C aS_BFu33_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu33_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "aS_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "aS_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu9i, aS_BFu33_BFu9i)
//============================================================================



static void Test_aS_BFu33_BFu9ll()
{
  {
    init_simple_test("aS_BFu33_BFu9ll");
    static STRUCT_IF_C aS_BFu33_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu33_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "aS_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "aS_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu9ll, aS_BFu33_BFu9ll)
//============================================================================



static void Test_aS_BFu33_BFu9s()
{
  {
    init_simple_test("aS_BFu33_BFu9s");
    static STRUCT_IF_C aS_BFu33_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu33_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "aS_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "aS_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_BFu9s, aS_BFu33_BFu9s)
//============================================================================



static void Test_aS_BFu33_C()
{
  {
    init_simple_test("aS_BFu33_C");
    static STRUCT_IF_C aS_BFu33_C lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu33_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_C)");
    check_field_offset(lv, v1, 0, "aS_BFu33_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_C");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_C");
    check_field_offset(lv, v3, 7, "aS_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_C, aS_BFu33_C)
//============================================================================



static void Test_aS_BFu33_D()
{
  {
    init_simple_test("aS_BFu33_D");
    static STRUCT_IF_C aS_BFu33_D lv;
    check2(sizeof(lv), 15, "sizeof(aS_BFu33_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_D)");
    check_field_offset(lv, v1, 0, "aS_BFu33_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_D");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_D");
    check_field_offset(lv, v3, 7, "aS_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_D, aS_BFu33_D)
//============================================================================



static void Test_aS_BFu33_F()
{
  {
    init_simple_test("aS_BFu33_F");
    static STRUCT_IF_C aS_BFu33_F lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu33_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_F)");
    check_field_offset(lv, v1, 0, "aS_BFu33_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_F");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_F");
    check_field_offset(lv, v3, 7, "aS_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_F, aS_BFu33_F)
//============================================================================



static void Test_aS_BFu33_I()
{
  {
    init_simple_test("aS_BFu33_I");
    static STRUCT_IF_C aS_BFu33_I lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu33_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_I)");
    check_field_offset(lv, v1, 0, "aS_BFu33_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_I");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_I");
    check_field_offset(lv, v3, 7, "aS_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_I, aS_BFu33_I)
//============================================================================



static void Test_aS_BFu33_Ip()
{
  {
    init_simple_test("aS_BFu33_Ip");
    static STRUCT_IF_C aS_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aS_BFu33_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_Ip");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_Ip");
    check_field_offset(lv, v3, 7, "aS_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_Ip, aS_BFu33_Ip)
//============================================================================



static void Test_aS_BFu33_L()
{
  {
    init_simple_test("aS_BFu33_L");
    static STRUCT_IF_C aS_BFu33_L lv;
    check2(sizeof(lv), 15, "sizeof(aS_BFu33_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_L)");
    check_field_offset(lv, v1, 0, "aS_BFu33_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_L");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_L");
    check_field_offset(lv, v3, 7, "aS_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_L, aS_BFu33_L)
//============================================================================



static void Test_aS_BFu33_S()
{
  {
    init_simple_test("aS_BFu33_S");
    static STRUCT_IF_C aS_BFu33_S lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu33_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_S)");
    check_field_offset(lv, v1, 0, "aS_BFu33_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_S");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_S");
    check_field_offset(lv, v3, 7, "aS_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_S, aS_BFu33_S)
//============================================================================



static void Test_aS_BFu33_Uc()
{
  {
    init_simple_test("aS_BFu33_Uc");
    static STRUCT_IF_C aS_BFu33_Uc lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu33_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_Uc");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_Uc");
    check_field_offset(lv, v3, 7, "aS_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_Uc, aS_BFu33_Uc)
//============================================================================



static void Test_aS_BFu33_Ui()
{
  {
    init_simple_test("aS_BFu33_Ui");
    static STRUCT_IF_C aS_BFu33_Ui lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu33_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_Ui");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_Ui");
    check_field_offset(lv, v3, 7, "aS_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_Ui, aS_BFu33_Ui)
//============================================================================



static void Test_aS_BFu33_Ul()
{
  {
    init_simple_test("aS_BFu33_Ul");
    static STRUCT_IF_C aS_BFu33_Ul lv;
    check2(sizeof(lv), 15, "sizeof(aS_BFu33_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_Ul");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_Ul");
    check_field_offset(lv, v3, 7, "aS_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_Ul, aS_BFu33_Ul)
//============================================================================



static void Test_aS_BFu33_Us()
{
  {
    init_simple_test("aS_BFu33_Us");
    static STRUCT_IF_C aS_BFu33_Us lv;
    check2(sizeof(lv), 9, "sizeof(aS_BFu33_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu33_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_Us");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_Us");
    check_field_offset(lv, v3, 7, "aS_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_Us, aS_BFu33_Us)
//============================================================================



static void Test_aS_BFu33_Vp()
{
  {
    init_simple_test("aS_BFu33_Vp");
    static STRUCT_IF_C aS_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aS_BFu33_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aS_BFu33_Vp");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aS_BFu33_Vp");
    check_field_offset(lv, v3, 7, "aS_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu33_Vp, aS_BFu33_Vp)
//============================================================================



static void Test_aS_BFu7c()
{
  {
    init_simple_test("aS_BFu7c");
    static STRUCT_IF_C aS_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c, aS_BFu7c)
//============================================================================



static void Test_aS_BFu7c_BFu15i()
{
  {
    init_simple_test("aS_BFu7c_BFu15i");
    static STRUCT_IF_C aS_BFu7c_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aS_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aS_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu15i, aS_BFu7c_BFu15i)
//============================================================================



static void Test_aS_BFu7c_BFu15ll()
{
  {
    init_simple_test("aS_BFu7c_BFu15ll");
    static STRUCT_IF_C aS_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aS_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aS_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu15ll, aS_BFu7c_BFu15ll)
//============================================================================



static void Test_aS_BFu7c_BFu15s()
{
  {
    init_simple_test("aS_BFu7c_BFu15s");
    static STRUCT_IF_C aS_BFu7c_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aS_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aS_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu15s, aS_BFu7c_BFu15s)
//============================================================================



static void Test_aS_BFu7c_BFu16i()
{
  {
    init_simple_test("aS_BFu7c_BFu16i");
    static STRUCT_IF_C aS_BFu7c_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aS_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aS_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu16i, aS_BFu7c_BFu16i)
//============================================================================



static void Test_aS_BFu7c_BFu16ll()
{
  {
    init_simple_test("aS_BFu7c_BFu16ll");
    static STRUCT_IF_C aS_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aS_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aS_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu16ll, aS_BFu7c_BFu16ll)
//============================================================================



static void Test_aS_BFu7c_BFu16s()
{
  {
    init_simple_test("aS_BFu7c_BFu16s");
    static STRUCT_IF_C aS_BFu7c_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aS_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aS_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu16s, aS_BFu7c_BFu16s)
//============================================================================



static void Test_aS_BFu7c_BFu17i()
{
  {
    init_simple_test("aS_BFu7c_BFu17i");
    static STRUCT_IF_C aS_BFu7c_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aS_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aS_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu17i, aS_BFu7c_BFu17i)
//============================================================================



static void Test_aS_BFu7c_BFu17ll()
{
  {
    init_simple_test("aS_BFu7c_BFu17ll");
    static STRUCT_IF_C aS_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aS_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aS_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu17ll, aS_BFu7c_BFu17ll)
//============================================================================



static void Test_aS_BFu7c_BFu1c()
{
  {
    init_simple_test("aS_BFu7c_BFu1c");
    static STRUCT_IF_C aS_BFu7c_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu1c, aS_BFu7c_BFu1c)
//============================================================================



static void Test_aS_BFu7c_BFu1i()
{
  {
    init_simple_test("aS_BFu7c_BFu1i");
    static STRUCT_IF_C aS_BFu7c_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu1i, aS_BFu7c_BFu1i)
//============================================================================



static void Test_aS_BFu7c_BFu1ll()
{
  {
    init_simple_test("aS_BFu7c_BFu1ll");
    static STRUCT_IF_C aS_BFu7c_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu1ll, aS_BFu7c_BFu1ll)
//============================================================================



static void Test_aS_BFu7c_BFu1s()
{
  {
    init_simple_test("aS_BFu7c_BFu1s");
    static STRUCT_IF_C aS_BFu7c_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu1s, aS_BFu7c_BFu1s)
//============================================================================



static void Test_aS_BFu7c_BFu31i()
{
  {
    init_simple_test("aS_BFu7c_BFu31i");
    static STRUCT_IF_C aS_BFu7c_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aS_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aS_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu31i, aS_BFu7c_BFu31i)
//============================================================================



static void Test_aS_BFu7c_BFu31ll()
{
  {
    init_simple_test("aS_BFu7c_BFu31ll");
    static STRUCT_IF_C aS_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aS_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aS_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu31ll, aS_BFu7c_BFu31ll)
//============================================================================



static void Test_aS_BFu7c_BFu32i()
{
  {
    init_simple_test("aS_BFu7c_BFu32i");
    static STRUCT_IF_C aS_BFu7c_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aS_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aS_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu32i, aS_BFu7c_BFu32i)
//============================================================================



static void Test_aS_BFu7c_BFu32ll()
{
  {
    init_simple_test("aS_BFu7c_BFu32ll");
    static STRUCT_IF_C aS_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aS_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aS_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu32ll, aS_BFu7c_BFu32ll)
//============================================================================



static void Test_aS_BFu7c_BFu33()
{
  {
    init_simple_test("aS_BFu7c_BFu33");
    static STRUCT_IF_C aS_BFu7c_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "aS_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "aS_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu33, aS_BFu7c_BFu33)
//============================================================================



static void Test_aS_BFu7c_BFu7c()
{
  {
    init_simple_test("aS_BFu7c_BFu7c");
    static STRUCT_IF_C aS_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu7c, aS_BFu7c_BFu7c)
//============================================================================



static void Test_aS_BFu7c_BFu7i()
{
  {
    init_simple_test("aS_BFu7c_BFu7i");
    static STRUCT_IF_C aS_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu7i, aS_BFu7c_BFu7i)
//============================================================================



static void Test_aS_BFu7c_BFu7ll()
{
  {
    init_simple_test("aS_BFu7c_BFu7ll");
    static STRUCT_IF_C aS_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu7ll, aS_BFu7c_BFu7ll)
//============================================================================



static void Test_aS_BFu7c_BFu7s()
{
  {
    init_simple_test("aS_BFu7c_BFu7s");
    static STRUCT_IF_C aS_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu7s, aS_BFu7c_BFu7s)
//============================================================================



static void Test_aS_BFu7c_BFu8c()
{
  {
    init_simple_test("aS_BFu7c_BFu8c");
    static STRUCT_IF_C aS_BFu7c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu8c, aS_BFu7c_BFu8c)
//============================================================================



static void Test_aS_BFu7c_BFu8i()
{
  {
    init_simple_test("aS_BFu7c_BFu8i");
    static STRUCT_IF_C aS_BFu7c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu8i, aS_BFu7c_BFu8i)
//============================================================================



static void Test_aS_BFu7c_BFu8ll()
{
  {
    init_simple_test("aS_BFu7c_BFu8ll");
    static STRUCT_IF_C aS_BFu7c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu8ll, aS_BFu7c_BFu8ll)
//============================================================================



static void Test_aS_BFu7c_BFu8s()
{
  {
    init_simple_test("aS_BFu7c_BFu8s");
    static STRUCT_IF_C aS_BFu7c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu8s, aS_BFu7c_BFu8s)
//============================================================================



static void Test_aS_BFu7c_BFu9i()
{
  {
    init_simple_test("aS_BFu7c_BFu9i");
    static STRUCT_IF_C aS_BFu7c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aS_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aS_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu9i, aS_BFu7c_BFu9i)
//============================================================================



static void Test_aS_BFu7c_BFu9ll()
{
  {
    init_simple_test("aS_BFu7c_BFu9ll");
    static STRUCT_IF_C aS_BFu7c_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aS_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aS_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu9ll, aS_BFu7c_BFu9ll)
//============================================================================



static void Test_aS_BFu7c_BFu9s()
{
  {
    init_simple_test("aS_BFu7c_BFu9s");
    static STRUCT_IF_C aS_BFu7c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aS_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aS_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_BFu9s, aS_BFu7c_BFu9s)
//============================================================================



static void Test_aS_BFu7c_C()
{
  {
    init_simple_test("aS_BFu7c_C");
    static STRUCT_IF_C aS_BFu7c_C lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_C)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_C");
    check_field_offset(lv, v3, 3, "aS_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_C, aS_BFu7c_C)
//============================================================================



static void Test_aS_BFu7c_D()
{
  {
    init_simple_test("aS_BFu7c_D");
    static STRUCT_IF_C aS_BFu7c_D lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu7c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_D)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_D");
    check_field_offset(lv, v3, 3, "aS_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_D, aS_BFu7c_D)
//============================================================================



static void Test_aS_BFu7c_F()
{
  {
    init_simple_test("aS_BFu7c_F");
    static STRUCT_IF_C aS_BFu7c_F lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_F)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_F");
    check_field_offset(lv, v3, 3, "aS_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_F, aS_BFu7c_F)
//============================================================================



static void Test_aS_BFu7c_I()
{
  {
    init_simple_test("aS_BFu7c_I");
    static STRUCT_IF_C aS_BFu7c_I lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_I)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_I");
    check_field_offset(lv, v3, 3, "aS_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_I, aS_BFu7c_I)
//============================================================================



static void Test_aS_BFu7c_Ip()
{
  {
    init_simple_test("aS_BFu7c_Ip");
    static STRUCT_IF_C aS_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu7c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_Ip");
    check_field_offset(lv, v3, 3, "aS_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_Ip, aS_BFu7c_Ip)
//============================================================================



static void Test_aS_BFu7c_L()
{
  {
    init_simple_test("aS_BFu7c_L");
    static STRUCT_IF_C aS_BFu7c_L lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_L)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_L");
    check_field_offset(lv, v3, 3, "aS_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_L, aS_BFu7c_L)
//============================================================================



static void Test_aS_BFu7c_S()
{
  {
    init_simple_test("aS_BFu7c_S");
    static STRUCT_IF_C aS_BFu7c_S lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_S)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_S");
    check_field_offset(lv, v3, 3, "aS_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_S, aS_BFu7c_S)
//============================================================================



static void Test_aS_BFu7c_Uc()
{
  {
    init_simple_test("aS_BFu7c_Uc");
    static STRUCT_IF_C aS_BFu7c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_Uc");
    check_field_offset(lv, v3, 3, "aS_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_Uc, aS_BFu7c_Uc)
//============================================================================



static void Test_aS_BFu7c_Ui()
{
  {
    init_simple_test("aS_BFu7c_Ui");
    static STRUCT_IF_C aS_BFu7c_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_Ui");
    check_field_offset(lv, v3, 3, "aS_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_Ui, aS_BFu7c_Ui)
//============================================================================



static void Test_aS_BFu7c_Ul()
{
  {
    init_simple_test("aS_BFu7c_Ul");
    static STRUCT_IF_C aS_BFu7c_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_Ul");
    check_field_offset(lv, v3, 3, "aS_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_Ul, aS_BFu7c_Ul)
//============================================================================



static void Test_aS_BFu7c_Us()
{
  {
    init_simple_test("aS_BFu7c_Us");
    static STRUCT_IF_C aS_BFu7c_Us lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_Us");
    check_field_offset(lv, v3, 3, "aS_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_Us, aS_BFu7c_Us)
//============================================================================



static void Test_aS_BFu7c_Vp()
{
  {
    init_simple_test("aS_BFu7c_Vp");
    static STRUCT_IF_C aS_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7c_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7c_Vp");
    check_field_offset(lv, v3, 3, "aS_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7c_Vp, aS_BFu7c_Vp)
//============================================================================



static void Test_aS_BFu7i()
{
  {
    init_simple_test("aS_BFu7i");
    static STRUCT_IF_C aS_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i, aS_BFu7i)
//============================================================================



static void Test_aS_BFu7i_BFu15i()
{
  {
    init_simple_test("aS_BFu7i_BFu15i");
    static STRUCT_IF_C aS_BFu7i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aS_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aS_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu15i, aS_BFu7i_BFu15i)
//============================================================================



static void Test_aS_BFu7i_BFu15ll()
{
  {
    init_simple_test("aS_BFu7i_BFu15ll");
    static STRUCT_IF_C aS_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aS_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aS_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu15ll, aS_BFu7i_BFu15ll)
//============================================================================



static void Test_aS_BFu7i_BFu15s()
{
  {
    init_simple_test("aS_BFu7i_BFu15s");
    static STRUCT_IF_C aS_BFu7i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aS_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aS_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu15s, aS_BFu7i_BFu15s)
//============================================================================



static void Test_aS_BFu7i_BFu16i()
{
  {
    init_simple_test("aS_BFu7i_BFu16i");
    static STRUCT_IF_C aS_BFu7i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aS_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aS_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu16i, aS_BFu7i_BFu16i)
//============================================================================



static void Test_aS_BFu7i_BFu16ll()
{
  {
    init_simple_test("aS_BFu7i_BFu16ll");
    static STRUCT_IF_C aS_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aS_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aS_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu16ll, aS_BFu7i_BFu16ll)
//============================================================================



static void Test_aS_BFu7i_BFu16s()
{
  {
    init_simple_test("aS_BFu7i_BFu16s");
    static STRUCT_IF_C aS_BFu7i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aS_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aS_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu16s, aS_BFu7i_BFu16s)
//============================================================================



static void Test_aS_BFu7i_BFu17i()
{
  {
    init_simple_test("aS_BFu7i_BFu17i");
    static STRUCT_IF_C aS_BFu7i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aS_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aS_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu17i, aS_BFu7i_BFu17i)
//============================================================================



static void Test_aS_BFu7i_BFu17ll()
{
  {
    init_simple_test("aS_BFu7i_BFu17ll");
    static STRUCT_IF_C aS_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aS_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aS_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu17ll, aS_BFu7i_BFu17ll)
//============================================================================



static void Test_aS_BFu7i_BFu1c()
{
  {
    init_simple_test("aS_BFu7i_BFu1c");
    static STRUCT_IF_C aS_BFu7i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu1c, aS_BFu7i_BFu1c)
//============================================================================



static void Test_aS_BFu7i_BFu1i()
{
  {
    init_simple_test("aS_BFu7i_BFu1i");
    static STRUCT_IF_C aS_BFu7i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu1i, aS_BFu7i_BFu1i)
//============================================================================



static void Test_aS_BFu7i_BFu1ll()
{
  {
    init_simple_test("aS_BFu7i_BFu1ll");
    static STRUCT_IF_C aS_BFu7i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu1ll, aS_BFu7i_BFu1ll)
//============================================================================



static void Test_aS_BFu7i_BFu1s()
{
  {
    init_simple_test("aS_BFu7i_BFu1s");
    static STRUCT_IF_C aS_BFu7i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu1s, aS_BFu7i_BFu1s)
//============================================================================



static void Test_aS_BFu7i_BFu31i()
{
  {
    init_simple_test("aS_BFu7i_BFu31i");
    static STRUCT_IF_C aS_BFu7i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aS_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aS_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu31i, aS_BFu7i_BFu31i)
//============================================================================



static void Test_aS_BFu7i_BFu31ll()
{
  {
    init_simple_test("aS_BFu7i_BFu31ll");
    static STRUCT_IF_C aS_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aS_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aS_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu31ll, aS_BFu7i_BFu31ll)
//============================================================================



static void Test_aS_BFu7i_BFu32i()
{
  {
    init_simple_test("aS_BFu7i_BFu32i");
    static STRUCT_IF_C aS_BFu7i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aS_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aS_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu32i, aS_BFu7i_BFu32i)
//============================================================================



static void Test_aS_BFu7i_BFu32ll()
{
  {
    init_simple_test("aS_BFu7i_BFu32ll");
    static STRUCT_IF_C aS_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aS_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aS_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu32ll, aS_BFu7i_BFu32ll)
//============================================================================



static void Test_aS_BFu7i_BFu33()
{
  {
    init_simple_test("aS_BFu7i_BFu33");
    static STRUCT_IF_C aS_BFu7i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "aS_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "aS_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu33, aS_BFu7i_BFu33)
//============================================================================



static void Test_aS_BFu7i_BFu7c()
{
  {
    init_simple_test("aS_BFu7i_BFu7c");
    static STRUCT_IF_C aS_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu7c, aS_BFu7i_BFu7c)
//============================================================================



static void Test_aS_BFu7i_BFu7i()
{
  {
    init_simple_test("aS_BFu7i_BFu7i");
    static STRUCT_IF_C aS_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu7i, aS_BFu7i_BFu7i)
//============================================================================



static void Test_aS_BFu7i_BFu7ll()
{
  {
    init_simple_test("aS_BFu7i_BFu7ll");
    static STRUCT_IF_C aS_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu7ll, aS_BFu7i_BFu7ll)
//============================================================================



static void Test_aS_BFu7i_BFu7s()
{
  {
    init_simple_test("aS_BFu7i_BFu7s");
    static STRUCT_IF_C aS_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu7s, aS_BFu7i_BFu7s)
//============================================================================



static void Test_aS_BFu7i_BFu8c()
{
  {
    init_simple_test("aS_BFu7i_BFu8c");
    static STRUCT_IF_C aS_BFu7i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu8c, aS_BFu7i_BFu8c)
//============================================================================



static void Test_aS_BFu7i_BFu8i()
{
  {
    init_simple_test("aS_BFu7i_BFu8i");
    static STRUCT_IF_C aS_BFu7i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu8i, aS_BFu7i_BFu8i)
//============================================================================



static void Test_aS_BFu7i_BFu8ll()
{
  {
    init_simple_test("aS_BFu7i_BFu8ll");
    static STRUCT_IF_C aS_BFu7i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu8ll, aS_BFu7i_BFu8ll)
//============================================================================



static void Test_aS_BFu7i_BFu8s()
{
  {
    init_simple_test("aS_BFu7i_BFu8s");
    static STRUCT_IF_C aS_BFu7i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu8s, aS_BFu7i_BFu8s)
//============================================================================



static void Test_aS_BFu7i_BFu9i()
{
  {
    init_simple_test("aS_BFu7i_BFu9i");
    static STRUCT_IF_C aS_BFu7i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aS_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aS_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu9i, aS_BFu7i_BFu9i)
//============================================================================



static void Test_aS_BFu7i_BFu9ll()
{
  {
    init_simple_test("aS_BFu7i_BFu9ll");
    static STRUCT_IF_C aS_BFu7i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aS_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aS_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu9ll, aS_BFu7i_BFu9ll)
//============================================================================



static void Test_aS_BFu7i_BFu9s()
{
  {
    init_simple_test("aS_BFu7i_BFu9s");
    static STRUCT_IF_C aS_BFu7i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aS_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aS_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_BFu9s, aS_BFu7i_BFu9s)
//============================================================================



static void Test_aS_BFu7i_C()
{
  {
    init_simple_test("aS_BFu7i_C");
    static STRUCT_IF_C aS_BFu7i_C lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_C)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_C");
    check_field_offset(lv, v3, 3, "aS_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_C, aS_BFu7i_C)
//============================================================================



static void Test_aS_BFu7i_D()
{
  {
    init_simple_test("aS_BFu7i_D");
    static STRUCT_IF_C aS_BFu7i_D lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_D)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_D");
    check_field_offset(lv, v3, 3, "aS_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_D, aS_BFu7i_D)
//============================================================================



static void Test_aS_BFu7i_F()
{
  {
    init_simple_test("aS_BFu7i_F");
    static STRUCT_IF_C aS_BFu7i_F lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_F)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_F");
    check_field_offset(lv, v3, 3, "aS_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_F, aS_BFu7i_F)
//============================================================================



static void Test_aS_BFu7i_I()
{
  {
    init_simple_test("aS_BFu7i_I");
    static STRUCT_IF_C aS_BFu7i_I lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_I)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_I");
    check_field_offset(lv, v3, 3, "aS_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_I, aS_BFu7i_I)
//============================================================================



static void Test_aS_BFu7i_Ip()
{
  {
    init_simple_test("aS_BFu7i_Ip");
    static STRUCT_IF_C aS_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_Ip");
    check_field_offset(lv, v3, 3, "aS_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_Ip, aS_BFu7i_Ip)
//============================================================================



static void Test_aS_BFu7i_L()
{
  {
    init_simple_test("aS_BFu7i_L");
    static STRUCT_IF_C aS_BFu7i_L lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_L)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_L");
    check_field_offset(lv, v3, 3, "aS_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_L, aS_BFu7i_L)
//============================================================================



static void Test_aS_BFu7i_S()
{
  {
    init_simple_test("aS_BFu7i_S");
    static STRUCT_IF_C aS_BFu7i_S lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_S)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_S");
    check_field_offset(lv, v3, 3, "aS_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_S, aS_BFu7i_S)
//============================================================================



static void Test_aS_BFu7i_Uc()
{
  {
    init_simple_test("aS_BFu7i_Uc");
    static STRUCT_IF_C aS_BFu7i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_Uc");
    check_field_offset(lv, v3, 3, "aS_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_Uc, aS_BFu7i_Uc)
//============================================================================



static void Test_aS_BFu7i_Ui()
{
  {
    init_simple_test("aS_BFu7i_Ui");
    static STRUCT_IF_C aS_BFu7i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_Ui");
    check_field_offset(lv, v3, 3, "aS_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_Ui, aS_BFu7i_Ui)
//============================================================================



static void Test_aS_BFu7i_Ul()
{
  {
    init_simple_test("aS_BFu7i_Ul");
    static STRUCT_IF_C aS_BFu7i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_Ul");
    check_field_offset(lv, v3, 3, "aS_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_Ul, aS_BFu7i_Ul)
//============================================================================



static void Test_aS_BFu7i_Us()
{
  {
    init_simple_test("aS_BFu7i_Us");
    static STRUCT_IF_C aS_BFu7i_Us lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_Us");
    check_field_offset(lv, v3, 3, "aS_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_Us, aS_BFu7i_Us)
//============================================================================



static void Test_aS_BFu7i_Vp()
{
  {
    init_simple_test("aS_BFu7i_Vp");
    static STRUCT_IF_C aS_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7i_Vp");
    check_field_offset(lv, v3, 3, "aS_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7i_Vp, aS_BFu7i_Vp)
//============================================================================



static void Test_aS_BFu7ll()
{
  {
    init_simple_test("aS_BFu7ll");
    static STRUCT_IF_C aS_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll, aS_BFu7ll)
//============================================================================



static void Test_aS_BFu7ll_BFu15i()
{
  {
    init_simple_test("aS_BFu7ll_BFu15i");
    static STRUCT_IF_C aS_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aS_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aS_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu15i, aS_BFu7ll_BFu15i)
//============================================================================



static void Test_aS_BFu7ll_BFu15ll()
{
  {
    init_simple_test("aS_BFu7ll_BFu15ll");
    static STRUCT_IF_C aS_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aS_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aS_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu15ll, aS_BFu7ll_BFu15ll)
//============================================================================



static void Test_aS_BFu7ll_BFu15s()
{
  {
    init_simple_test("aS_BFu7ll_BFu15s");
    static STRUCT_IF_C aS_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aS_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aS_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu15s, aS_BFu7ll_BFu15s)
//============================================================================



static void Test_aS_BFu7ll_BFu16i()
{
  {
    init_simple_test("aS_BFu7ll_BFu16i");
    static STRUCT_IF_C aS_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aS_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aS_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu16i, aS_BFu7ll_BFu16i)
//============================================================================



static void Test_aS_BFu7ll_BFu16ll()
{
  {
    init_simple_test("aS_BFu7ll_BFu16ll");
    static STRUCT_IF_C aS_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aS_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aS_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu16ll, aS_BFu7ll_BFu16ll)
//============================================================================



static void Test_aS_BFu7ll_BFu16s()
{
  {
    init_simple_test("aS_BFu7ll_BFu16s");
    static STRUCT_IF_C aS_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aS_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aS_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu16s, aS_BFu7ll_BFu16s)
//============================================================================



static void Test_aS_BFu7ll_BFu17i()
{
  {
    init_simple_test("aS_BFu7ll_BFu17i");
    static STRUCT_IF_C aS_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aS_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aS_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu17i, aS_BFu7ll_BFu17i)
//============================================================================



static void Test_aS_BFu7ll_BFu17ll()
{
  {
    init_simple_test("aS_BFu7ll_BFu17ll");
    static STRUCT_IF_C aS_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aS_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aS_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu17ll, aS_BFu7ll_BFu17ll)
//============================================================================



static void Test_aS_BFu7ll_BFu1c()
{
  {
    init_simple_test("aS_BFu7ll_BFu1c");
    static STRUCT_IF_C aS_BFu7ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu1c, aS_BFu7ll_BFu1c)
//============================================================================



static void Test_aS_BFu7ll_BFu1i()
{
  {
    init_simple_test("aS_BFu7ll_BFu1i");
    static STRUCT_IF_C aS_BFu7ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu1i, aS_BFu7ll_BFu1i)
//============================================================================



static void Test_aS_BFu7ll_BFu1ll()
{
  {
    init_simple_test("aS_BFu7ll_BFu1ll");
    static STRUCT_IF_C aS_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu1ll, aS_BFu7ll_BFu1ll)
//============================================================================



static void Test_aS_BFu7ll_BFu1s()
{
  {
    init_simple_test("aS_BFu7ll_BFu1s");
    static STRUCT_IF_C aS_BFu7ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu1s, aS_BFu7ll_BFu1s)
//============================================================================



static void Test_aS_BFu7ll_BFu31i()
{
  {
    init_simple_test("aS_BFu7ll_BFu31i");
    static STRUCT_IF_C aS_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aS_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aS_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu31i, aS_BFu7ll_BFu31i)
//============================================================================



static void Test_aS_BFu7ll_BFu31ll()
{
  {
    init_simple_test("aS_BFu7ll_BFu31ll");
    static STRUCT_IF_C aS_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aS_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aS_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu31ll, aS_BFu7ll_BFu31ll)
//============================================================================



static void Test_aS_BFu7ll_BFu32i()
{
  {
    init_simple_test("aS_BFu7ll_BFu32i");
    static STRUCT_IF_C aS_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aS_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aS_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu32i, aS_BFu7ll_BFu32i)
//============================================================================



static void Test_aS_BFu7ll_BFu32ll()
{
  {
    init_simple_test("aS_BFu7ll_BFu32ll");
    static STRUCT_IF_C aS_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aS_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aS_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu32ll, aS_BFu7ll_BFu32ll)
//============================================================================



static void Test_aS_BFu7ll_BFu33()
{
  {
    init_simple_test("aS_BFu7ll_BFu33");
    static STRUCT_IF_C aS_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "aS_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "aS_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu33, aS_BFu7ll_BFu33)
//============================================================================



static void Test_aS_BFu7ll_BFu7c()
{
  {
    init_simple_test("aS_BFu7ll_BFu7c");
    static STRUCT_IF_C aS_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu7c, aS_BFu7ll_BFu7c)
//============================================================================



static void Test_aS_BFu7ll_BFu7i()
{
  {
    init_simple_test("aS_BFu7ll_BFu7i");
    static STRUCT_IF_C aS_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu7i, aS_BFu7ll_BFu7i)
//============================================================================



static void Test_aS_BFu7ll_BFu7ll()
{
  {
    init_simple_test("aS_BFu7ll_BFu7ll");
    static STRUCT_IF_C aS_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu7ll, aS_BFu7ll_BFu7ll)
//============================================================================



static void Test_aS_BFu7ll_BFu7s()
{
  {
    init_simple_test("aS_BFu7ll_BFu7s");
    static STRUCT_IF_C aS_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu7s, aS_BFu7ll_BFu7s)
//============================================================================



static void Test_aS_BFu7ll_BFu8c()
{
  {
    init_simple_test("aS_BFu7ll_BFu8c");
    static STRUCT_IF_C aS_BFu7ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu8c, aS_BFu7ll_BFu8c)
//============================================================================



static void Test_aS_BFu7ll_BFu8i()
{
  {
    init_simple_test("aS_BFu7ll_BFu8i");
    static STRUCT_IF_C aS_BFu7ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu8i, aS_BFu7ll_BFu8i)
//============================================================================



static void Test_aS_BFu7ll_BFu8ll()
{
  {
    init_simple_test("aS_BFu7ll_BFu8ll");
    static STRUCT_IF_C aS_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu8ll, aS_BFu7ll_BFu8ll)
//============================================================================



static void Test_aS_BFu7ll_BFu8s()
{
  {
    init_simple_test("aS_BFu7ll_BFu8s");
    static STRUCT_IF_C aS_BFu7ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu8s, aS_BFu7ll_BFu8s)
//============================================================================



static void Test_aS_BFu7ll_BFu9i()
{
  {
    init_simple_test("aS_BFu7ll_BFu9i");
    static STRUCT_IF_C aS_BFu7ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aS_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aS_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu9i, aS_BFu7ll_BFu9i)
//============================================================================



static void Test_aS_BFu7ll_BFu9ll()
{
  {
    init_simple_test("aS_BFu7ll_BFu9ll");
    static STRUCT_IF_C aS_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aS_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aS_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu9ll, aS_BFu7ll_BFu9ll)
//============================================================================



static void Test_aS_BFu7ll_BFu9s()
{
  {
    init_simple_test("aS_BFu7ll_BFu9s");
    static STRUCT_IF_C aS_BFu7ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aS_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aS_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_BFu9s, aS_BFu7ll_BFu9s)
//============================================================================



static void Test_aS_BFu7ll_C()
{
  {
    init_simple_test("aS_BFu7ll_C");
    static STRUCT_IF_C aS_BFu7ll_C lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_C");
    check_field_offset(lv, v3, 3, "aS_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_C, aS_BFu7ll_C)
//============================================================================



static void Test_aS_BFu7ll_D()
{
  {
    init_simple_test("aS_BFu7ll_D");
    static STRUCT_IF_C aS_BFu7ll_D lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_D");
    check_field_offset(lv, v3, 3, "aS_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_D, aS_BFu7ll_D)
//============================================================================



static void Test_aS_BFu7ll_F()
{
  {
    init_simple_test("aS_BFu7ll_F");
    static STRUCT_IF_C aS_BFu7ll_F lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_F");
    check_field_offset(lv, v3, 3, "aS_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_F, aS_BFu7ll_F)
//============================================================================



static void Test_aS_BFu7ll_I()
{
  {
    init_simple_test("aS_BFu7ll_I");
    static STRUCT_IF_C aS_BFu7ll_I lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_I");
    check_field_offset(lv, v3, 3, "aS_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_I, aS_BFu7ll_I)
//============================================================================



static void Test_aS_BFu7ll_Ip()
{
  {
    init_simple_test("aS_BFu7ll_Ip");
    static STRUCT_IF_C aS_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_Ip");
    check_field_offset(lv, v3, 3, "aS_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_Ip, aS_BFu7ll_Ip)
//============================================================================



static void Test_aS_BFu7ll_L()
{
  {
    init_simple_test("aS_BFu7ll_L");
    static STRUCT_IF_C aS_BFu7ll_L lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_L");
    check_field_offset(lv, v3, 3, "aS_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_L, aS_BFu7ll_L)
//============================================================================



static void Test_aS_BFu7ll_S()
{
  {
    init_simple_test("aS_BFu7ll_S");
    static STRUCT_IF_C aS_BFu7ll_S lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_S");
    check_field_offset(lv, v3, 3, "aS_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_S, aS_BFu7ll_S)
//============================================================================



static void Test_aS_BFu7ll_Uc()
{
  {
    init_simple_test("aS_BFu7ll_Uc");
    static STRUCT_IF_C aS_BFu7ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_Uc");
    check_field_offset(lv, v3, 3, "aS_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_Uc, aS_BFu7ll_Uc)
//============================================================================



static void Test_aS_BFu7ll_Ui()
{
  {
    init_simple_test("aS_BFu7ll_Ui");
    static STRUCT_IF_C aS_BFu7ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_Ui");
    check_field_offset(lv, v3, 3, "aS_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_Ui, aS_BFu7ll_Ui)
//============================================================================



static void Test_aS_BFu7ll_Ul()
{
  {
    init_simple_test("aS_BFu7ll_Ul");
    static STRUCT_IF_C aS_BFu7ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_Ul");
    check_field_offset(lv, v3, 3, "aS_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_Ul, aS_BFu7ll_Ul)
//============================================================================



static void Test_aS_BFu7ll_Us()
{
  {
    init_simple_test("aS_BFu7ll_Us");
    static STRUCT_IF_C aS_BFu7ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_Us");
    check_field_offset(lv, v3, 3, "aS_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_Us, aS_BFu7ll_Us)
//============================================================================



static void Test_aS_BFu7ll_Vp()
{
  {
    init_simple_test("aS_BFu7ll_Vp");
    static STRUCT_IF_C aS_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7ll_Vp");
    check_field_offset(lv, v3, 3, "aS_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7ll_Vp, aS_BFu7ll_Vp)
//============================================================================



static void Test_aS_BFu7s()
{
  {
    init_simple_test("aS_BFu7s");
    static STRUCT_IF_C aS_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s, aS_BFu7s)
//============================================================================



static void Test_aS_BFu7s_BFu15i()
{
  {
    init_simple_test("aS_BFu7s_BFu15i");
    static STRUCT_IF_C aS_BFu7s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aS_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aS_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu15i, aS_BFu7s_BFu15i)
//============================================================================



static void Test_aS_BFu7s_BFu15ll()
{
  {
    init_simple_test("aS_BFu7s_BFu15ll");
    static STRUCT_IF_C aS_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aS_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aS_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu15ll, aS_BFu7s_BFu15ll)
//============================================================================



static void Test_aS_BFu7s_BFu15s()
{
  {
    init_simple_test("aS_BFu7s_BFu15s");
    static STRUCT_IF_C aS_BFu7s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aS_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aS_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu15s, aS_BFu7s_BFu15s)
//============================================================================



static void Test_aS_BFu7s_BFu16i()
{
  {
    init_simple_test("aS_BFu7s_BFu16i");
    static STRUCT_IF_C aS_BFu7s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aS_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aS_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu16i, aS_BFu7s_BFu16i)
//============================================================================



static void Test_aS_BFu7s_BFu16ll()
{
  {
    init_simple_test("aS_BFu7s_BFu16ll");
    static STRUCT_IF_C aS_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aS_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aS_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu16ll, aS_BFu7s_BFu16ll)
//============================================================================



static void Test_aS_BFu7s_BFu16s()
{
  {
    init_simple_test("aS_BFu7s_BFu16s");
    static STRUCT_IF_C aS_BFu7s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aS_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aS_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu16s, aS_BFu7s_BFu16s)
//============================================================================



static void Test_aS_BFu7s_BFu17i()
{
  {
    init_simple_test("aS_BFu7s_BFu17i");
    static STRUCT_IF_C aS_BFu7s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aS_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aS_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu17i, aS_BFu7s_BFu17i)
//============================================================================



static void Test_aS_BFu7s_BFu17ll()
{
  {
    init_simple_test("aS_BFu7s_BFu17ll");
    static STRUCT_IF_C aS_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aS_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aS_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu17ll, aS_BFu7s_BFu17ll)
//============================================================================



static void Test_aS_BFu7s_BFu1c()
{
  {
    init_simple_test("aS_BFu7s_BFu1c");
    static STRUCT_IF_C aS_BFu7s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu1c, aS_BFu7s_BFu1c)
//============================================================================



static void Test_aS_BFu7s_BFu1i()
{
  {
    init_simple_test("aS_BFu7s_BFu1i");
    static STRUCT_IF_C aS_BFu7s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu1i, aS_BFu7s_BFu1i)
//============================================================================



static void Test_aS_BFu7s_BFu1ll()
{
  {
    init_simple_test("aS_BFu7s_BFu1ll");
    static STRUCT_IF_C aS_BFu7s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu1ll, aS_BFu7s_BFu1ll)
//============================================================================



static void Test_aS_BFu7s_BFu1s()
{
  {
    init_simple_test("aS_BFu7s_BFu1s");
    static STRUCT_IF_C aS_BFu7s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aS_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu1s, aS_BFu7s_BFu1s)
//============================================================================



static void Test_aS_BFu7s_BFu31i()
{
  {
    init_simple_test("aS_BFu7s_BFu31i");
    static STRUCT_IF_C aS_BFu7s_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aS_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aS_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu31i, aS_BFu7s_BFu31i)
//============================================================================



static void Test_aS_BFu7s_BFu31ll()
{
  {
    init_simple_test("aS_BFu7s_BFu31ll");
    static STRUCT_IF_C aS_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aS_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aS_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu31ll, aS_BFu7s_BFu31ll)
//============================================================================



static void Test_aS_BFu7s_BFu32i()
{
  {
    init_simple_test("aS_BFu7s_BFu32i");
    static STRUCT_IF_C aS_BFu7s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aS_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aS_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu32i, aS_BFu7s_BFu32i)
//============================================================================



static void Test_aS_BFu7s_BFu32ll()
{
  {
    init_simple_test("aS_BFu7s_BFu32ll");
    static STRUCT_IF_C aS_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aS_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aS_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu32ll, aS_BFu7s_BFu32ll)
//============================================================================



static void Test_aS_BFu7s_BFu33()
{
  {
    init_simple_test("aS_BFu7s_BFu33");
    static STRUCT_IF_C aS_BFu7s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "aS_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "aS_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu33, aS_BFu7s_BFu33)
//============================================================================



static void Test_aS_BFu7s_BFu7c()
{
  {
    init_simple_test("aS_BFu7s_BFu7c");
    static STRUCT_IF_C aS_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu7c, aS_BFu7s_BFu7c)
//============================================================================



static void Test_aS_BFu7s_BFu7i()
{
  {
    init_simple_test("aS_BFu7s_BFu7i");
    static STRUCT_IF_C aS_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu7i, aS_BFu7s_BFu7i)
//============================================================================



static void Test_aS_BFu7s_BFu7ll()
{
  {
    init_simple_test("aS_BFu7s_BFu7ll");
    static STRUCT_IF_C aS_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu7ll, aS_BFu7s_BFu7ll)
//============================================================================



static void Test_aS_BFu7s_BFu7s()
{
  {
    init_simple_test("aS_BFu7s_BFu7s");
    static STRUCT_IF_C aS_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aS_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu7s, aS_BFu7s_BFu7s)
//============================================================================



static void Test_aS_BFu7s_BFu8c()
{
  {
    init_simple_test("aS_BFu7s_BFu8c");
    static STRUCT_IF_C aS_BFu7s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu8c, aS_BFu7s_BFu8c)
//============================================================================



static void Test_aS_BFu7s_BFu8i()
{
  {
    init_simple_test("aS_BFu7s_BFu8i");
    static STRUCT_IF_C aS_BFu7s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu8i, aS_BFu7s_BFu8i)
//============================================================================



static void Test_aS_BFu7s_BFu8ll()
{
  {
    init_simple_test("aS_BFu7s_BFu8ll");
    static STRUCT_IF_C aS_BFu7s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu8ll, aS_BFu7s_BFu8ll)
//============================================================================



static void Test_aS_BFu7s_BFu8s()
{
  {
    init_simple_test("aS_BFu7s_BFu8s");
    static STRUCT_IF_C aS_BFu7s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aS_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aS_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu8s, aS_BFu7s_BFu8s)
//============================================================================



static void Test_aS_BFu7s_BFu9i()
{
  {
    init_simple_test("aS_BFu7s_BFu9i");
    static STRUCT_IF_C aS_BFu7s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aS_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aS_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu9i, aS_BFu7s_BFu9i)
//============================================================================



static void Test_aS_BFu7s_BFu9ll()
{
  {
    init_simple_test("aS_BFu7s_BFu9ll");
    static STRUCT_IF_C aS_BFu7s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aS_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aS_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu9ll, aS_BFu7s_BFu9ll)
//============================================================================



static void Test_aS_BFu7s_BFu9s()
{
  {
    init_simple_test("aS_BFu7s_BFu9s");
    static STRUCT_IF_C aS_BFu7s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aS_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aS_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_BFu9s, aS_BFu7s_BFu9s)
//============================================================================



static void Test_aS_BFu7s_C()
{
  {
    init_simple_test("aS_BFu7s_C");
    static STRUCT_IF_C aS_BFu7s_C lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_C)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_C");
    check_field_offset(lv, v3, 3, "aS_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_C, aS_BFu7s_C)
//============================================================================



static void Test_aS_BFu7s_D()
{
  {
    init_simple_test("aS_BFu7s_D");
    static STRUCT_IF_C aS_BFu7s_D lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_D)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_D");
    check_field_offset(lv, v3, 3, "aS_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_D, aS_BFu7s_D)
//============================================================================



static void Test_aS_BFu7s_F()
{
  {
    init_simple_test("aS_BFu7s_F");
    static STRUCT_IF_C aS_BFu7s_F lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_F)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_F");
    check_field_offset(lv, v3, 3, "aS_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_F, aS_BFu7s_F)
//============================================================================



static void Test_aS_BFu7s_I()
{
  {
    init_simple_test("aS_BFu7s_I");
    static STRUCT_IF_C aS_BFu7s_I lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_I)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_I");
    check_field_offset(lv, v3, 3, "aS_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_I, aS_BFu7s_I)
//============================================================================



static void Test_aS_BFu7s_Ip()
{
  {
    init_simple_test("aS_BFu7s_Ip");
    static STRUCT_IF_C aS_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_Ip");
    check_field_offset(lv, v3, 3, "aS_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_Ip, aS_BFu7s_Ip)
//============================================================================



static void Test_aS_BFu7s_L()
{
  {
    init_simple_test("aS_BFu7s_L");
    static STRUCT_IF_C aS_BFu7s_L lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu7s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_L)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_L");
    check_field_offset(lv, v3, 3, "aS_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_L, aS_BFu7s_L)
//============================================================================



static void Test_aS_BFu7s_S()
{
  {
    init_simple_test("aS_BFu7s_S");
    static STRUCT_IF_C aS_BFu7s_S lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_S)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_S");
    check_field_offset(lv, v3, 3, "aS_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_S, aS_BFu7s_S)
//============================================================================



static void Test_aS_BFu7s_Uc()
{
  {
    init_simple_test("aS_BFu7s_Uc");
    static STRUCT_IF_C aS_BFu7s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu7s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_Uc");
    check_field_offset(lv, v3, 3, "aS_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_Uc, aS_BFu7s_Uc)
//============================================================================



static void Test_aS_BFu7s_Ui()
{
  {
    init_simple_test("aS_BFu7s_Ui");
    static STRUCT_IF_C aS_BFu7s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu7s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_Ui");
    check_field_offset(lv, v3, 3, "aS_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_Ui, aS_BFu7s_Ui)
//============================================================================



static void Test_aS_BFu7s_Ul()
{
  {
    init_simple_test("aS_BFu7s_Ul");
    static STRUCT_IF_C aS_BFu7s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu7s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_Ul");
    check_field_offset(lv, v3, 3, "aS_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_Ul, aS_BFu7s_Ul)
//============================================================================



static void Test_aS_BFu7s_Us()
{
  {
    init_simple_test("aS_BFu7s_Us");
    static STRUCT_IF_C aS_BFu7s_Us lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu7s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_Us");
    check_field_offset(lv, v3, 3, "aS_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_Us, aS_BFu7s_Us)
//============================================================================



static void Test_aS_BFu7s_Vp()
{
  {
    init_simple_test("aS_BFu7s_Vp");
    static STRUCT_IF_C aS_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu7s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "aS_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aS_BFu7s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aS_BFu7s_Vp");
    check_field_offset(lv, v3, 3, "aS_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu7s_Vp, aS_BFu7s_Vp)
//============================================================================



static void Test_aS_BFu8c()
{
  {
    init_simple_test("aS_BFu8c");
    static STRUCT_IF_C aS_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aS_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c, aS_BFu8c)
//============================================================================



static void Test_aS_BFu8c_BFu15i()
{
  {
    init_simple_test("aS_BFu8c_BFu15i");
    static STRUCT_IF_C aS_BFu8c_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu8c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aS_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aS_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu15i, aS_BFu8c_BFu15i)
//============================================================================



static void Test_aS_BFu8c_BFu15ll()
{
  {
    init_simple_test("aS_BFu8c_BFu15ll");
    static STRUCT_IF_C aS_BFu8c_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu8c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aS_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aS_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu15ll, aS_BFu8c_BFu15ll)
//============================================================================



static void Test_aS_BFu8c_BFu15s()
{
  {
    init_simple_test("aS_BFu8c_BFu15s");
    static STRUCT_IF_C aS_BFu8c_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu8c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aS_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aS_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu15s, aS_BFu8c_BFu15s)
//============================================================================



static void Test_aS_BFu8c_BFu16i()
{
  {
    init_simple_test("aS_BFu8c_BFu16i");
    static STRUCT_IF_C aS_BFu8c_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu8c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aS_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aS_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu16i, aS_BFu8c_BFu16i)
//============================================================================



static void Test_aS_BFu8c_BFu16ll()
{
  {
    init_simple_test("aS_BFu8c_BFu16ll");
    static STRUCT_IF_C aS_BFu8c_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu8c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aS_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aS_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu16ll, aS_BFu8c_BFu16ll)
//============================================================================



static void Test_aS_BFu8c_BFu16s()
{
  {
    init_simple_test("aS_BFu8c_BFu16s");
    static STRUCT_IF_C aS_BFu8c_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu8c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aS_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aS_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu16s, aS_BFu8c_BFu16s)
//============================================================================



static void Test_aS_BFu8c_BFu17i()
{
  {
    init_simple_test("aS_BFu8c_BFu17i");
    static STRUCT_IF_C aS_BFu8c_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu8c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aS_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aS_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu17i, aS_BFu8c_BFu17i)
//============================================================================



static void Test_aS_BFu8c_BFu17ll()
{
  {
    init_simple_test("aS_BFu8c_BFu17ll");
    static STRUCT_IF_C aS_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aS_BFu8c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aS_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aS_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu17ll, aS_BFu8c_BFu17ll)
//============================================================================



static void Test_aS_BFu8c_BFu1c()
{
  {
    init_simple_test("aS_BFu8c_BFu1c");
    static STRUCT_IF_C aS_BFu8c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aS_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu1c, aS_BFu8c_BFu1c)
//============================================================================



static void Test_aS_BFu8c_BFu1i()
{
  {
    init_simple_test("aS_BFu8c_BFu1i");
    static STRUCT_IF_C aS_BFu8c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aS_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu1i, aS_BFu8c_BFu1i)
//============================================================================



static void Test_aS_BFu8c_BFu1ll()
{
  {
    init_simple_test("aS_BFu8c_BFu1ll");
    static STRUCT_IF_C aS_BFu8c_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aS_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu1ll, aS_BFu8c_BFu1ll)
//============================================================================



static void Test_aS_BFu8c_BFu1s()
{
  {
    init_simple_test("aS_BFu8c_BFu1s");
    static STRUCT_IF_C aS_BFu8c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aS_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu1s, aS_BFu8c_BFu1s)
//============================================================================



static void Test_aS_BFu8c_BFu31i()
{
  {
    init_simple_test("aS_BFu8c_BFu31i");
    static STRUCT_IF_C aS_BFu8c_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aS_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aS_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu31i, aS_BFu8c_BFu31i)
//============================================================================



static void Test_aS_BFu8c_BFu31ll()
{
  {
    init_simple_test("aS_BFu8c_BFu31ll");
    static STRUCT_IF_C aS_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aS_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aS_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu31ll, aS_BFu8c_BFu31ll)
//============================================================================



static void Test_aS_BFu8c_BFu32i()
{
  {
    init_simple_test("aS_BFu8c_BFu32i");
    static STRUCT_IF_C aS_BFu8c_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aS_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aS_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu32i, aS_BFu8c_BFu32i)
//============================================================================



static void Test_aS_BFu8c_BFu32ll()
{
  {
    init_simple_test("aS_BFu8c_BFu32ll");
    static STRUCT_IF_C aS_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aS_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aS_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu32ll, aS_BFu8c_BFu32ll)
//============================================================================



static void Test_aS_BFu8c_BFu33()
{
  {
    init_simple_test("aS_BFu8c_BFu33");
    static STRUCT_IF_C aS_BFu8c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aS_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aS_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aS_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu33, aS_BFu8c_BFu33)
//============================================================================



static void Test_aS_BFu8c_BFu7c()
{
  {
    init_simple_test("aS_BFu8c_BFu7c");
    static STRUCT_IF_C aS_BFu8c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aS_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aS_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu7c, aS_BFu8c_BFu7c)
//============================================================================



static void Test_aS_BFu8c_BFu7i()
{
  {
    init_simple_test("aS_BFu8c_BFu7i");
    static STRUCT_IF_C aS_BFu8c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aS_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aS_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu7i, aS_BFu8c_BFu7i)
//============================================================================



static void Test_aS_BFu8c_BFu7ll()
{
  {
    init_simple_test("aS_BFu8c_BFu7ll");
    static STRUCT_IF_C aS_BFu8c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aS_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aS_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu7ll, aS_BFu8c_BFu7ll)
//============================================================================



static void Test_aS_BFu8c_BFu7s()
{
  {
    init_simple_test("aS_BFu8c_BFu7s");
    static STRUCT_IF_C aS_BFu8c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aS_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aS_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu7s, aS_BFu8c_BFu7s)
//============================================================================



static void Test_aS_BFu8c_BFu8c()
{
  {
    init_simple_test("aS_BFu8c_BFu8c");
    static STRUCT_IF_C aS_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aS_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu8c, aS_BFu8c_BFu8c)
//============================================================================



static void Test_aS_BFu8c_BFu8i()
{
  {
    init_simple_test("aS_BFu8c_BFu8i");
    static STRUCT_IF_C aS_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aS_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu8i, aS_BFu8c_BFu8i)
//============================================================================



static void Test_aS_BFu8c_BFu8ll()
{
  {
    init_simple_test("aS_BFu8c_BFu8ll");
    static STRUCT_IF_C aS_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aS_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu8ll, aS_BFu8c_BFu8ll)
//============================================================================



static void Test_aS_BFu8c_BFu8s()
{
  {
    init_simple_test("aS_BFu8c_BFu8s");
    static STRUCT_IF_C aS_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aS_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu8s, aS_BFu8c_BFu8s)
//============================================================================



static void Test_aS_BFu8c_BFu9i()
{
  {
    init_simple_test("aS_BFu8c_BFu9i");
    static STRUCT_IF_C aS_BFu8c_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu8c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aS_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aS_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu9i, aS_BFu8c_BFu9i)
//============================================================================



static void Test_aS_BFu8c_BFu9ll()
{
  {
    init_simple_test("aS_BFu8c_BFu9ll");
    static STRUCT_IF_C aS_BFu8c_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu8c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aS_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aS_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu9ll, aS_BFu8c_BFu9ll)
//============================================================================



static void Test_aS_BFu8c_BFu9s()
{
  {
    init_simple_test("aS_BFu8c_BFu9s");
    static STRUCT_IF_C aS_BFu8c_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu8c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aS_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aS_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_BFu9s, aS_BFu8c_BFu9s)
//============================================================================



static void Test_aS_BFu8c_C()
{
  {
    init_simple_test("aS_BFu8c_C");
    static STRUCT_IF_C aS_BFu8c_C lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_C)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_C");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_C");
    check_field_offset(lv, v3, 3, "aS_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_C, aS_BFu8c_C)
//============================================================================



static void Test_aS_BFu8c_D()
{
  {
    init_simple_test("aS_BFu8c_D");
    static STRUCT_IF_C aS_BFu8c_D lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu8c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_D)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_D");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_D");
    check_field_offset(lv, v3, 3, "aS_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_D, aS_BFu8c_D)
//============================================================================



static void Test_aS_BFu8c_F()
{
  {
    init_simple_test("aS_BFu8c_F");
    static STRUCT_IF_C aS_BFu8c_F lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu8c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_F)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_F");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_F");
    check_field_offset(lv, v3, 3, "aS_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_F, aS_BFu8c_F)
//============================================================================



static void Test_aS_BFu8c_I()
{
  {
    init_simple_test("aS_BFu8c_I");
    static STRUCT_IF_C aS_BFu8c_I lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu8c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_I)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_I");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_I");
    check_field_offset(lv, v3, 3, "aS_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_I, aS_BFu8c_I)
//============================================================================



static void Test_aS_BFu8c_Ip()
{
  {
    init_simple_test("aS_BFu8c_Ip");
    static STRUCT_IF_C aS_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aS_BFu8c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_Ip");
    check_field_offset(lv, v3, 3, "aS_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_Ip, aS_BFu8c_Ip)
//============================================================================



static void Test_aS_BFu8c_L()
{
  {
    init_simple_test("aS_BFu8c_L");
    static STRUCT_IF_C aS_BFu8c_L lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu8c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_L)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_L");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_L");
    check_field_offset(lv, v3, 3, "aS_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_L, aS_BFu8c_L)
//============================================================================



static void Test_aS_BFu8c_S()
{
  {
    init_simple_test("aS_BFu8c_S");
    static STRUCT_IF_C aS_BFu8c_S lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu8c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_S)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_S");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_S");
    check_field_offset(lv, v3, 3, "aS_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_S, aS_BFu8c_S)
//============================================================================



static void Test_aS_BFu8c_Uc()
{
  {
    init_simple_test("aS_BFu8c_Uc");
    static STRUCT_IF_C aS_BFu8c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aS_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_Uc");
    check_field_offset(lv, v3, 3, "aS_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_Uc, aS_BFu8c_Uc)
//============================================================================



static void Test_aS_BFu8c_Ui()
{
  {
    init_simple_test("aS_BFu8c_Ui");
    static STRUCT_IF_C aS_BFu8c_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aS_BFu8c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_Ui");
    check_field_offset(lv, v3, 3, "aS_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_Ui, aS_BFu8c_Ui)
//============================================================================



static void Test_aS_BFu8c_Ul()
{
  {
    init_simple_test("aS_BFu8c_Ul");
    static STRUCT_IF_C aS_BFu8c_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aS_BFu8c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_Ul");
    check_field_offset(lv, v3, 3, "aS_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_Ul, aS_BFu8c_Ul)
//============================================================================



static void Test_aS_BFu8c_Us()
{
  {
    init_simple_test("aS_BFu8c_Us");
    static STRUCT_IF_C aS_BFu8c_Us lv;
    check2(sizeof(lv), 5, "sizeof(aS_BFu8c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aS_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "aS_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aS_BFu8c_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aS_BFu8c_Us");
    check_field_offset(lv, v3, 3, "aS_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aS_BFu8c_Us, aS_BFu8c_Us)
//============================================================================



static void Test_aS_BFu8c_Vp()
{
  {
    i