// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
struct __attribute__((packed)) aIp_BFu15s_Us { int * v1; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu15s_Vp { int * v1; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aIp_BFu16i { int * v1; unsigned int v2:16; };
struct __attribute__((packed)) aIp_BFu16i_BFu15i { int * v1; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu16i_BFu15ll { int * v1; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu16i_BFu15s { int * v1; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu16i_BFu16i { int * v1; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu16i_BFu16ll { int * v1; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu16i_BFu16s { int * v1; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu16i_BFu17i { int * v1; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu16i_BFu17ll { int * v1; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu16i_BFu1c { int * v1; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu16i_BFu1i { int * v1; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu16i_BFu1ll { int * v1; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu16i_BFu1s { int * v1; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu16i_BFu31i { int * v1; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu16i_BFu31ll { int * v1; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu16i_BFu32i { int * v1; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu16i_BFu32ll { int * v1; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu16i_BFu33 { int * v1; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu16i_BFu7c { int * v1; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu16i_BFu7i { int * v1; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu16i_BFu7ll { int * v1; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu16i_BFu7s { int * v1; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu16i_BFu8c { int * v1; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu16i_BFu8i { int * v1; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu16i_BFu8ll { int * v1; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu16i_BFu8s { int * v1; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu16i_BFu9i { int * v1; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu16i_BFu9ll { int * v1; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu16i_BFu9s { int * v1; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu16i_C { int * v1; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aIp_BFu16i_D { int * v1; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aIp_BFu16i_F { int * v1; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aIp_BFu16i_I { int * v1; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aIp_BFu16i_Ip { int * v1; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aIp_BFu16i_L { int * v1; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aIp_BFu16i_S { int * v1; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aIp_BFu16i_Uc { int * v1; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu16i_Ui { int * v1; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu16i_Ul { int * v1; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu16i_Us { int * v1; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu16i_Vp { int * v1; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aIp_BFu16ll { int * v1; unsigned long long v2:16; };
struct __attribute__((packed)) aIp_BFu16ll_BFu15i { int * v1; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu16ll_BFu15ll { int * v1; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu16ll_BFu15s { int * v1; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu16ll_BFu16i { int * v1; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu16ll_BFu16ll { int * v1; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu16ll_BFu16s { int * v1; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu16ll_BFu17i { int * v1; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu16ll_BFu17ll { int * v1; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu16ll_BFu1c { int * v1; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu16ll_BFu1i { int * v1; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu16ll_BFu1ll { int * v1; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu16ll_BFu1s { int * v1; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu16ll_BFu31i { int * v1; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu16ll_BFu31ll { int * v1; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu16ll_BFu32i { int * v1; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu16ll_BFu32ll { int * v1; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu16ll_BFu33 { int * v1; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu16ll_BFu7c { int * v1; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu16ll_BFu7i { int * v1; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu16ll_BFu7ll { int * v1; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu16ll_BFu7s { int * v1; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu16ll_BFu8c { int * v1; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu16ll_BFu8i { int * v1; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu16ll_BFu8ll { int * v1; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu16ll_BFu8s { int * v1; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu16ll_BFu9i { int * v1; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu16ll_BFu9ll { int * v1; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu16ll_BFu9s { int * v1; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu16ll_C { int * v1; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aIp_BFu16ll_D { int * v1; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aIp_BFu16ll_F { int * v1; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aIp_BFu16ll_I { int * v1; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aIp_BFu16ll_Ip { int * v1; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aIp_BFu16ll_L { int * v1; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aIp_BFu16ll_S { int * v1; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aIp_BFu16ll_Uc { int * v1; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu16ll_Ui { int * v1; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu16ll_Ul { int * v1; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu16ll_Us { int * v1; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu16ll_Vp { int * v1; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aIp_BFu16s { int * v1; unsigned short v2:16; };
struct __attribute__((packed)) aIp_BFu16s_BFu15i { int * v1; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu16s_BFu15ll { int * v1; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu16s_BFu15s { int * v1; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu16s_BFu16i { int * v1; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu16s_BFu16ll { int * v1; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu16s_BFu16s { int * v1; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu16s_BFu17i { int * v1; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu16s_BFu17ll { int * v1; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu16s_BFu1c { int * v1; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu16s_BFu1i { int * v1; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu16s_BFu1ll { int * v1; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu16s_BFu1s { int * v1; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu16s_BFu31i { int * v1; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu16s_BFu31ll { int * v1; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu16s_BFu32i { int * v1; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu16s_BFu32ll { int * v1; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu16s_BFu33 { int * v1; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu16s_BFu7c { int * v1; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu16s_BFu7i { int * v1; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu16s_BFu7ll { int * v1; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu16s_BFu7s { int * v1; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu16s_BFu8c { int * v1; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu16s_BFu8i { int * v1; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu16s_BFu8ll { int * v1; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu16s_BFu8s { int * v1; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu16s_BFu9i { int * v1; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu16s_BFu9ll { int * v1; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu16s_BFu9s { int * v1; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu16s_C { int * v1; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aIp_BFu16s_D { int * v1; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aIp_BFu16s_F { int * v1; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aIp_BFu16s_I { int * v1; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aIp_BFu16s_Ip { int * v1; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aIp_BFu16s_L { int * v1; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aIp_BFu16s_S { int * v1; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aIp_BFu16s_Uc { int * v1; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu16s_Ui { int * v1; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu16s_Ul { int * v1; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu16s_Us { int * v1; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu16s_Vp { int * v1; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aIp_BFu17i { int * v1; unsigned int v2:17; };
struct __attribute__((packed)) aIp_BFu17i_BFu15i { int * v1; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu17i_BFu15ll { int * v1; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu17i_BFu15s { int * v1; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu17i_BFu16i { int * v1; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu17i_BFu16ll { int * v1; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu17i_BFu16s { int * v1; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu17i_BFu17i { int * v1; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu17i_BFu17ll { int * v1; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu17i_BFu1c { int * v1; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu17i_BFu1i { int * v1; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu17i_BFu1ll { int * v1; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu17i_BFu1s { int * v1; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu17i_BFu31i { int * v1; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu17i_BFu31ll { int * v1; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu17i_BFu32i { int * v1; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu17i_BFu32ll { int * v1; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu17i_BFu33 { int * v1; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu17i_BFu7c { int * v1; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu17i_BFu7i { int * v1; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu17i_BFu7ll { int * v1; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu17i_BFu7s { int * v1; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu17i_BFu8c { int * v1; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu17i_BFu8i { int * v1; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu17i_BFu8ll { int * v1; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu17i_BFu8s { int * v1; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu17i_BFu9i { int * v1; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu17i_BFu9ll { int * v1; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu17i_BFu9s { int * v1; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu17i_C { int * v1; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aIp_BFu17i_D { int * v1; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aIp_BFu17i_F { int * v1; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aIp_BFu17i_I { int * v1; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aIp_BFu17i_Ip { int * v1; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aIp_BFu17i_L { int * v1; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aIp_BFu17i_S { int * v1; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aIp_BFu17i_Uc { int * v1; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu17i_Ui { int * v1; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu17i_Ul { int * v1; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu17i_Us { int * v1; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu17i_Vp { int * v1; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aIp_BFu17ll { int * v1; unsigned long long v2:17; };
struct __attribute__((packed)) aIp_BFu17ll_BFu15i { int * v1; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu17ll_BFu15ll { int * v1; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu17ll_BFu15s { int * v1; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu17ll_BFu16i { int * v1; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu17ll_BFu16ll { int * v1; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu17ll_BFu16s { int * v1; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu17ll_BFu17i { int * v1; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu17ll_BFu17ll { int * v1; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu17ll_BFu1c { int * v1; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu17ll_BFu1i { int * v1; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu17ll_BFu1ll { int * v1; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu17ll_BFu1s { int * v1; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu17ll_BFu31i { int * v1; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu17ll_BFu31ll { int * v1; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu17ll_BFu32i { int * v1; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu17ll_BFu32ll { int * v1; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu17ll_BFu33 { int * v1; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu17ll_BFu7c { int * v1; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu17ll_BFu7i { int * v1; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu17ll_BFu7ll { int * v1; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu17ll_BFu7s { int * v1; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu17ll_BFu8c { int * v1; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu17ll_BFu8i { int * v1; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu17ll_BFu8ll { int * v1; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu17ll_BFu8s { int * v1; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu17ll_BFu9i { int * v1; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu17ll_BFu9ll { int * v1; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu17ll_BFu9s { int * v1; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu17ll_C { int * v1; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aIp_BFu17ll_D { int * v1; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aIp_BFu17ll_F { int * v1; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aIp_BFu17ll_I { int * v1; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aIp_BFu17ll_Ip { int * v1; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aIp_BFu17ll_L { int * v1; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aIp_BFu17ll_S { int * v1; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aIp_BFu17ll_Uc { int * v1; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu17ll_Ui { int * v1; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu17ll_Ul { int * v1; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu17ll_Us { int * v1; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu17ll_Vp { int * v1; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aIp_BFu1c { int * v1; unsigned char v2:1; };
struct __attribute__((packed)) aIp_BFu1c_BFu15i { int * v1; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu1c_BFu15ll { int * v1; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu1c_BFu15s { int * v1; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu1c_BFu16i { int * v1; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu1c_BFu16ll { int * v1; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu1c_BFu16s { int * v1; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu1c_BFu17i { int * v1; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu1c_BFu17ll { int * v1; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu1c_BFu1c { int * v1; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu1c_BFu1i { int * v1; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu1c_BFu1ll { int * v1; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu1c_BFu1s { int * v1; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu1c_BFu31i { int * v1; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu1c_BFu31ll { int * v1; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu1c_BFu32i { int * v1; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu1c_BFu32ll { int * v1; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu1c_BFu33 { int * v1; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu1c_BFu7c { int * v1; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu1c_BFu7i { int * v1; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu1c_BFu7ll { int * v1; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu1c_BFu7s { int * v1; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu1c_BFu8c { int * v1; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu1c_BFu8i { int * v1; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu1c_BFu8ll { int * v1; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu1c_BFu8s { int * v1; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu1c_BFu9i { int * v1; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu1c_BFu9ll { int * v1; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu1c_BFu9s { int * v1; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu1c_C { int * v1; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aIp_BFu1c_D { int * v1; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aIp_BFu1c_F { int * v1; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aIp_BFu1c_I { int * v1; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aIp_BFu1c_Ip { int * v1; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aIp_BFu1c_L { int * v1; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aIp_BFu1c_S { int * v1; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aIp_BFu1c_Uc { int * v1; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu1c_Ui { int * v1; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu1c_Ul { int * v1; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu1c_Us { int * v1; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu1c_Vp { int * v1; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aIp_BFu1i { int * v1; unsigned int v2:1; };
struct __attribute__((packed)) aIp_BFu1i_BFu15i { int * v1; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu1i_BFu15ll { int * v1; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu1i_BFu15s { int * v1; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu1i_BFu16i { int * v1; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu1i_BFu16ll { int * v1; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu1i_BFu16s { int * v1; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu1i_BFu17i { int * v1; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu1i_BFu17ll { int * v1; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu1i_BFu1c { int * v1; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu1i_BFu1i { int * v1; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu1i_BFu1ll { int * v1; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu1i_BFu1s { int * v1; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu1i_BFu31i { int * v1; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu1i_BFu31ll { int * v1; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu1i_BFu32i { int * v1; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu1i_BFu32ll { int * v1; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu1i_BFu33 { int * v1; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu1i_BFu7c { int * v1; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu1i_BFu7i { int * v1; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu1i_BFu7ll { int * v1; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu1i_BFu7s { int * v1; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu1i_BFu8c { int * v1; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu1i_BFu8i { int * v1; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu1i_BFu8ll { int * v1; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu1i_BFu8s { int * v1; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu1i_BFu9i { int * v1; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu1i_BFu9ll { int * v1; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu1i_BFu9s { int * v1; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu1i_C { int * v1; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aIp_BFu1i_D { int * v1; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aIp_BFu1i_F { int * v1; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aIp_BFu1i_I { int * v1; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aIp_BFu1i_Ip { int * v1; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aIp_BFu1i_L { int * v1; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aIp_BFu1i_S { int * v1; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aIp_BFu1i_Uc { int * v1; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu1i_Ui { int * v1; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu1i_Ul { int * v1; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu1i_Us { int * v1; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu1i_Vp { int * v1; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aIp_BFu1ll { int * v1; unsigned long long v2:1; };
struct __attribute__((packed)) aIp_BFu1ll_BFu15i { int * v1; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu1ll_BFu15ll { int * v1; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu1ll_BFu15s { int * v1; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu1ll_BFu16i { int * v1; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu1ll_BFu16ll { int * v1; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu1ll_BFu16s { int * v1; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu1ll_BFu17i { int * v1; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu1ll_BFu17ll { int * v1; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu1ll_BFu1c { int * v1; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu1ll_BFu1i { int * v1; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu1ll_BFu1ll { int * v1; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu1ll_BFu1s { int * v1; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu1ll_BFu31i { int * v1; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu1ll_BFu31ll { int * v1; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu1ll_BFu32i { int * v1; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu1ll_BFu32ll { int * v1; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu1ll_BFu33 { int * v1; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu1ll_BFu7c { int * v1; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu1ll_BFu7i { int * v1; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu1ll_BFu7ll { int * v1; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu1ll_BFu7s { int * v1; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu1ll_BFu8c { int * v1; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu1ll_BFu8i { int * v1; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu1ll_BFu8ll { int * v1; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu1ll_BFu8s { int * v1; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu1ll_BFu9i { int * v1; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu1ll_BFu9ll { int * v1; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu1ll_BFu9s { int * v1; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu1ll_C { int * v1; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aIp_BFu1ll_D { int * v1; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aIp_BFu1ll_F { int * v1; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aIp_BFu1ll_I { int * v1; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aIp_BFu1ll_Ip { int * v1; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aIp_BFu1ll_L { int * v1; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aIp_BFu1ll_S { int * v1; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aIp_BFu1ll_Uc { int * v1; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu1ll_Ui { int * v1; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu1ll_Ul { int * v1; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu1ll_Us { int * v1; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu1ll_Vp { int * v1; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aIp_BFu1s { int * v1; unsigned short v2:1; };
struct __attribute__((packed)) aIp_BFu1s_BFu15i { int * v1; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu1s_BFu15ll { int * v1; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu1s_BFu15s { int * v1; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu1s_BFu16i { int * v1; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu1s_BFu16ll { int * v1; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu1s_BFu16s { int * v1; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu1s_BFu17i { int * v1; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu1s_BFu17ll { int * v1; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu1s_BFu1c { int * v1; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu1s_BFu1i { int * v1; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu1s_BFu1ll { int * v1; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu1s_BFu1s { int * v1; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu1s_BFu31i { int * v1; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu1s_BFu31ll { int * v1; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu1s_BFu32i { int * v1; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu1s_BFu32ll { int * v1; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu1s_BFu33 { int * v1; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu1s_BFu7c { int * v1; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu1s_BFu7i { int * v1; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu1s_BFu7ll { int * v1; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu1s_BFu7s { int * v1; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu1s_BFu8c { int * v1; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu1s_BFu8i { int * v1; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu1s_BFu8ll { int * v1; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu1s_BFu8s { int * v1; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu1s_BFu9i { int * v1; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu1s_BFu9ll { int * v1; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu1s_BFu9s { int * v1; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu1s_C { int * v1; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aIp_BFu1s_D { int * v1; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aIp_BFu1s_F { int * v1; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aIp_BFu1s_I { int * v1; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aIp_BFu1s_Ip { int * v1; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aIp_BFu1s_L { int * v1; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aIp_BFu1s_S { int * v1; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aIp_BFu1s_Uc { int * v1; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu1s_Ui { int * v1; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu1s_Ul { int * v1; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu1s_Us { int * v1; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu1s_Vp { int * v1; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aIp_BFu31i { int * v1; unsigned int v2:31; };
struct __attribute__((packed)) aIp_BFu31i_BFu15i { int * v1; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu31i_BFu15ll { int * v1; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu31i_BFu15s { int * v1; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu31i_BFu16i { int * v1; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu31i_BFu16ll { int * v1; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu31i_BFu16s { int * v1; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu31i_BFu17i { int * v1; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu31i_BFu17ll { int * v1; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu31i_BFu1c { int * v1; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu31i_BFu1i { int * v1; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu31i_BFu1ll { int * v1; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu31i_BFu1s { int * v1; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu31i_BFu31i { int * v1; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu31i_BFu31ll { int * v1; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu31i_BFu32i { int * v1; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu31i_BFu32ll { int * v1; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu31i_BFu33 { int * v1; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu31i_BFu7c { int * v1; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu31i_BFu7i { int * v1; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu31i_BFu7ll { int * v1; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu31i_BFu7s { int * v1; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu31i_BFu8c { int * v1; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu31i_BFu8i { int * v1; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu31i_BFu8ll { int * v1; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu31i_BFu8s { int * v1; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu31i_BFu9i { int * v1; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu31i_BFu9ll { int * v1; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu31i_BFu9s { int * v1; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu31i_C { int * v1; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aIp_BFu31i_D { int * v1; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aIp_BFu31i_F { int * v1; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aIp_BFu31i_I { int * v1; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aIp_BFu31i_Ip { int * v1; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aIp_BFu31i_L { int * v1; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aIp_BFu31i_S { int * v1; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aIp_BFu31i_Uc { int * v1; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu31i_Ui { int * v1; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu31i_Ul { int * v1; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu31i_Us { int * v1; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu31i_Vp { int * v1; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aIp_BFu31ll { int * v1; unsigned long long v2:31; };
struct __attribute__((packed)) aIp_BFu31ll_BFu15i { int * v1; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu31ll_BFu15ll { int * v1; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu31ll_BFu15s { int * v1; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu31ll_BFu16i { int * v1; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu31ll_BFu16ll { int * v1; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu31ll_BFu16s { int * v1; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu31ll_BFu17i { int * v1; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu31ll_BFu17ll { int * v1; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu31ll_BFu1c { int * v1; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu31ll_BFu1i { int * v1; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu31ll_BFu1ll { int * v1; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu31ll_BFu1s { int * v1; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu31ll_BFu31i { int * v1; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu31ll_BFu31ll { int * v1; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu31ll_BFu32i { int * v1; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu31ll_BFu32ll { int * v1; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu31ll_BFu33 { int * v1; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu31ll_BFu7c { int * v1; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu31ll_BFu7i { int * v1; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu31ll_BFu7ll { int * v1; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu31ll_BFu7s { int * v1; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu31ll_BFu8c { int * v1; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu31ll_BFu8i { int * v1; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu31ll_BFu8ll { int * v1; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu31ll_BFu8s { int * v1; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu31ll_BFu9i { int * v1; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu31ll_BFu9ll { int * v1; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu31ll_BFu9s { int * v1; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu31ll_C { int * v1; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aIp_BFu31ll_D { int * v1; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aIp_BFu31ll_F { int * v1; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aIp_BFu31ll_I { int * v1; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aIp_BFu31ll_Ip { int * v1; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aIp_BFu31ll_L { int * v1; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aIp_BFu31ll_S { int * v1; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aIp_BFu31ll_Uc { int * v1; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu31ll_Ui { int * v1; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu31ll_Ul { int * v1; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu31ll_Us { int * v1; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu31ll_Vp { int * v1; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aIp_BFu32i { int * v1; unsigned int v2:32; };
struct __attribute__((packed)) aIp_BFu32i_BFu15i { int * v1; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu32i_BFu15ll { int * v1; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu32i_BFu15s { int * v1; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu32i_BFu16i { int * v1; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu32i_BFu16ll { int * v1; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu32i_BFu16s { int * v1; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu32i_BFu17i { int * v1; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu32i_BFu17ll { int * v1; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu32i_BFu1c { int * v1; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu32i_BFu1i { int * v1; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu32i_BFu1ll { int * v1; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu32i_BFu1s { int * v1; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu32i_BFu31i { int * v1; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu32i_BFu31ll { int * v1; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu32i_BFu32i { int * v1; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu32i_BFu32ll { int * v1; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu32i_BFu33 { int * v1; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu32i_BFu7c { int * v1; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu32i_BFu7i { int * v1; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu32i_BFu7ll { int * v1; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu32i_BFu7s { int * v1; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu32i_BFu8c { int * v1; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu32i_BFu8i { int * v1; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu32i_BFu8ll { int * v1; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu32i_BFu8s { int * v1; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu32i_BFu9i { int * v1; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu32i_BFu9ll { int * v1; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu32i_BFu9s { int * v1; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu32i_C { int * v1; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aIp_BFu32i_D { int * v1; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aIp_BFu32i_F { int * v1; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aIp_BFu32i_I { int * v1; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aIp_BFu32i_Ip { int * v1; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aIp_BFu32i_L { int * v1; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aIp_BFu32i_S { int * v1; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aIp_BFu32i_Uc { int * v1; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu32i_Ui { int * v1; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu32i_Ul { int * v1; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu32i_Us { int * v1; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu32i_Vp { int * v1; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aIp_BFu32ll { int * v1; unsigned long long v2:32; };
struct __attribute__((packed)) aIp_BFu32ll_BFu15i { int * v1; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu32ll_BFu15ll { int * v1; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu32ll_BFu15s { int * v1; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu32ll_BFu16i { int * v1; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu32ll_BFu16ll { int * v1; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu32ll_BFu16s { int * v1; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu32ll_BFu17i { int * v1; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu32ll_BFu17ll { int * v1; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu32ll_BFu1c { int * v1; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu32ll_BFu1i { int * v1; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu32ll_BFu1ll { int * v1; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu32ll_BFu1s { int * v1; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu32ll_BFu31i { int * v1; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu32ll_BFu31ll { int * v1; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu32ll_BFu32i { int * v1; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu32ll_BFu32ll { int * v1; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu32ll_BFu33 { int * v1; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu32ll_BFu7c { int * v1; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu32ll_BFu7i { int * v1; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu32ll_BFu7ll { int * v1; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu32ll_BFu7s { int * v1; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu32ll_BFu8c { int * v1; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu32ll_BFu8i { int * v1; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu32ll_BFu8ll { int * v1; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu32ll_BFu8s { int * v1; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu32ll_BFu9i { int * v1; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu32ll_BFu9ll { int * v1; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu32ll_BFu9s { int * v1; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu32ll_C { int * v1; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aIp_BFu32ll_D { int * v1; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aIp_BFu32ll_F { int * v1; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aIp_BFu32ll_I { int * v1; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aIp_BFu32ll_Ip { int * v1; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aIp_BFu32ll_L { int * v1; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aIp_BFu32ll_S { int * v1; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aIp_BFu32ll_Uc { int * v1; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu32ll_Ui { int * v1; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu32ll_Ul { int * v1; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu32ll_Us { int * v1; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu32ll_Vp { int * v1; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aIp_BFu33 { int * v1; unsigned long long v2:33; };
struct __attribute__((packed)) aIp_BFu33_BFu15i { int * v1; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu33_BFu15ll { int * v1; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu33_BFu15s { int * v1; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu33_BFu16i { int * v1; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu33_BFu16ll { int * v1; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu33_BFu16s { int * v1; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu33_BFu17i { int * v1; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu33_BFu17ll { int * v1; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu33_BFu1c { int * v1; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu33_BFu1i { int * v1; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu33_BFu1ll { int * v1; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu33_BFu1s { int * v1; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu33_BFu31i { int * v1; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu33_BFu31ll { int * v1; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu33_BFu32i { int * v1; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu33_BFu32ll { int * v1; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu33_BFu33 { int * v1; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu33_BFu7c { int * v1; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu33_BFu7i { int * v1; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu33_BFu7ll { int * v1; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu33_BFu7s { int * v1; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu33_BFu8c { int * v1; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu33_BFu8i { int * v1; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu33_BFu8ll { int * v1; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu33_BFu8s { int * v1; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu33_BFu9i { int * v1; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu33_BFu9ll { int * v1; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu33_BFu9s { int * v1; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu33_C { int * v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aIp_BFu33_D { int * v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aIp_BFu33_F { int * v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aIp_BFu33_I { int * v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aIp_BFu33_Ip { int * v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aIp_BFu33_L { int * v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aIp_BFu33_S { int * v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aIp_BFu33_Uc { int * v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu33_Ui { int * v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu33_Ul { int * v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu33_Us { int * v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu33_Vp { int * v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aIp_BFu7c { int * v1; unsigned char v2:7; };
struct __attribute__((packed)) aIp_BFu7c_BFu15i { int * v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu7c_BFu15ll { int * v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu7c_BFu15s { int * v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu7c_BFu16i { int * v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu7c_BFu16ll { int * v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu7c_BFu16s { int * v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu7c_BFu17i { int * v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu7c_BFu17ll { int * v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu7c_BFu1c { int * v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu7c_BFu1i { int * v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu7c_BFu1ll { int * v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu7c_BFu1s { int * v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu7c_BFu31i { int * v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu7c_BFu31ll { int * v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu7c_BFu32i { int * v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu7c_BFu32ll { int * v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu7c_BFu33 { int * v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu7c_BFu7c { int * v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu7c_BFu7i { int * v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu7c_BFu7ll { int * v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu7c_BFu7s { int * v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu7c_BFu8c { int * v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu7c_BFu8i { int * v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu7c_BFu8ll { int * v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu7c_BFu8s { int * v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu7c_BFu9i { int * v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu7c_BFu9ll { int * v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu7c_BFu9s { int * v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu7c_C { int * v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aIp_BFu7c_D { int * v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aIp_BFu7c_F { int * v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aIp_BFu7c_I { int * v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aIp_BFu7c_Ip { int * v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aIp_BFu7c_L { int * v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aIp_BFu7c_S { int * v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aIp_BFu7c_Uc { int * v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu7c_Ui { int * v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu7c_Ul { int * v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu7c_Us { int * v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu7c_Vp { int * v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aIp_BFu7i { int * v1; unsigned int v2:7; };
struct __attribute__((packed)) aIp_BFu7i_BFu15i { int * v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu7i_BFu15ll { int * v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu7i_BFu15s { int * v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu7i_BFu16i { int * v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu7i_BFu16ll { int * v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu7i_BFu16s { int * v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu7i_BFu17i { int * v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu7i_BFu17ll { int * v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu7i_BFu1c { int * v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu7i_BFu1i { int * v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu7i_BFu1ll { int * v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu7i_BFu1s { int * v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu7i_BFu31i { int * v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu7i_BFu31ll { int * v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu7i_BFu32i { int * v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu7i_BFu32ll { int * v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu7i_BFu33 { int * v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu7i_BFu7c { int * v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu7i_BFu7i { int * v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu7i_BFu7ll { int * v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu7i_BFu7s { int * v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu7i_BFu8c { int * v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu7i_BFu8i { int * v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu7i_BFu8ll { int * v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu7i_BFu8s { int * v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu7i_BFu9i { int * v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu7i_BFu9ll { int * v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu7i_BFu9s { int * v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu7i_C { int * v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aIp_BFu7i_D { int * v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aIp_BFu7i_F { int * v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aIp_BFu7i_I { int * v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aIp_BFu7i_Ip { int * v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aIp_BFu7i_L { int * v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aIp_BFu7i_S { int * v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aIp_BFu7i_Uc { int * v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu7i_Ui { int * v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu7i_Ul { int * v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu7i_Us { int * v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu7i_Vp { int * v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aIp_BFu7ll { int * v1; unsigned long long v2:7; };
struct __attribute__((packed)) aIp_BFu7ll_BFu15i { int * v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu7ll_BFu15ll { int * v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu7ll_BFu15s { int * v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu7ll_BFu16i { int * v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu7ll_BFu16ll { int * v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu7ll_BFu16s { int * v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu7ll_BFu17i { int * v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu7ll_BFu17ll { int * v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu7ll_BFu1c { int * v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu7ll_BFu1i { int * v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu7ll_BFu1ll { int * v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu7ll_BFu1s { int * v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu7ll_BFu31i { int * v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu7ll_BFu31ll { int * v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu7ll_BFu32i { int * v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu7ll_BFu32ll { int * v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu7ll_BFu33 { int * v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu7ll_BFu7c { int * v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu7ll_BFu7i { int * v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu7ll_BFu7ll { int * v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu7ll_BFu7s { int * v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu7ll_BFu8c { int * v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu7ll_BFu8i { int * v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu7ll_BFu8ll { int * v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu7ll_BFu8s { int * v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu7ll_BFu9i { int * v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu7ll_BFu9ll { int * v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu7ll_BFu9s { int * v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu7ll_C { int * v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aIp_BFu7ll_D { int * v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aIp_BFu7ll_F { int * v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aIp_BFu7ll_I { int * v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aIp_BFu7ll_Ip { int * v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aIp_BFu7ll_L { int * v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aIp_BFu7ll_S { int * v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aIp_BFu7ll_Uc { int * v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu7ll_Ui { int * v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu7ll_Ul { int * v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu7ll_Us { int * v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu7ll_Vp { int * v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aIp_BFu7s { int * v1; unsigned short v2:7; };
struct __attribute__((packed)) aIp_BFu7s_BFu15i { int * v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu7s_BFu15ll { int * v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu7s_BFu15s { int * v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu7s_BFu16i { int * v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu7s_BFu16ll { int * v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu7s_BFu16s { int * v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu7s_BFu17i { int * v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu7s_BFu17ll { int * v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu7s_BFu1c { int * v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu7s_BFu1i { int * v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu7s_BFu1ll { int * v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu7s_BFu1s { int * v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu7s_BFu31i { int * v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu7s_BFu31ll { int * v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu7s_BFu32i { int * v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu7s_BFu32ll { int * v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu7s_BFu33 { int * v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu7s_BFu7c { int * v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu7s_BFu7i { int * v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu7s_BFu7ll { int * v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu7s_BFu7s { int * v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu7s_BFu8c { int * v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu7s_BFu8i { int * v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu7s_BFu8ll { int * v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu7s_BFu8s { int * v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu7s_BFu9i { int * v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu7s_BFu9ll { int * v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu7s_BFu9s { int * v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu7s_C { int * v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aIp_BFu7s_D { int * v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aIp_BFu7s_F { int * v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aIp_BFu7s_I { int * v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aIp_BFu7s_Ip { int * v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aIp_BFu7s_L { int * v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aIp_BFu7s_S { int * v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aIp_BFu7s_Uc { int * v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu7s_Ui { int * v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu7s_Ul { int * v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu7s_Us { int * v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu7s_Vp { int * v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aIp_BFu8c { int * v1; unsigned char v2:8; };
struct __attribute__((packed)) aIp_BFu8c_BFu15i { int * v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu8c_BFu15ll { int * v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu8c_BFu15s { int * v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu8c_BFu16i { int * v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu8c_BFu16ll { int * v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu8c_BFu16s { int * v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu8c_BFu17i { int * v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu8c_BFu17ll { int * v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu8c_BFu1c { int * v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu8c_BFu1i { int * v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu8c_BFu1ll { int * v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu8c_BFu1s { int * v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu8c_BFu31i { int * v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu8c_BFu31ll { int * v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu8c_BFu32i { int * v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu8c_BFu32ll { int * v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu8c_BFu33 { int * v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu8c_BFu7c { int * v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu8c_BFu7i { int * v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu8c_BFu7ll { int * v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu8c_BFu7s { int * v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu8c_BFu8c { int * v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu8c_BFu8i { int * v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu8c_BFu8ll { int * v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu8c_BFu8s { int * v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu8c_BFu9i { int * v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu8c_BFu9ll { int * v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu8c_BFu9s { int * v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu8c_C { int * v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aIp_BFu8c_D { int * v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aIp_BFu8c_F { int * v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aIp_BFu8c_I { int * v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aIp_BFu8c_Ip { int * v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aIp_BFu8c_L { int * v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aIp_BFu8c_S { int * v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aIp_BFu8c_Uc { int * v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu8c_Ui { int * v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu8c_Ul { int * v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu8c_Us { int * v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu8c_Vp { int * v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aIp_BFu8i { int * v1; unsigned int v2:8; };
struct __attribute__((packed)) aIp_BFu8i_BFu15i { int * v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu8i_BFu15ll { int * v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu8i_BFu15s { int * v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu8i_BFu16i { int * v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu8i_BFu16ll { int * v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu8i_BFu16s { int * v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu8i_BFu17i { int * v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu8i_BFu17ll { int * v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu8i_BFu1c { int * v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu8i_BFu1i { int * v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu8i_BFu1ll { int * v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu8i_BFu1s { int * v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu8i_BFu31i { int * v1; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu8i_BFu31ll { int * v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu8i_BFu32i { int * v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu8i_BFu32ll { int * v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu8i_BFu33 { int * v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu8i_BFu7c { int * v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu8i_BFu7i { int * v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu8i_BFu7ll { int * v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu8i_BFu7s { int * v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu8i_BFu8c { int * v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu8i_BFu8i { int * v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu8i_BFu8ll { int * v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu8i_BFu8s { int * v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu8i_BFu9i { int * v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu8i_BFu9ll { int * v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu8i_BFu9s { int * v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu8i_C { int * v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aIp_BFu8i_D { int * v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aIp_BFu8i_F { int * v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aIp_BFu8i_I { int * v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aIp_BFu8i_Ip { int * v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aIp_BFu8i_L { int * v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aIp_BFu8i_S { int * v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aIp_BFu8i_Uc { int * v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu8i_Ui { int * v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu8i_Ul { int * v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu8i_Us { int * v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu8i_Vp { int * v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aIp_BFu8ll { int * v1; unsigned long long v2:8; };
struct __attribute__((packed)) aIp_BFu8ll_BFu15i { int * v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu8ll_BFu15ll { int * v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu8ll_BFu15s { int * v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu8ll_BFu16i { int * v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu8ll_BFu16ll { int * v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu8ll_BFu16s { int * v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu8ll_BFu17i { int * v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu8ll_BFu17ll { int * v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu8ll_BFu1c { int * v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu8ll_BFu1i { int * v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu8ll_BFu1ll { int * v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu8ll_BFu1s { int * v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu8ll_BFu31i { int * v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu8ll_BFu31ll { int * v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu8ll_BFu32i { int * v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu8ll_BFu32ll { int * v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu8ll_BFu33 { int * v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu8ll_BFu7c { int * v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu8ll_BFu7i { int * v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu8ll_BFu7ll { int * v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu8ll_BFu7s { int * v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu8ll_BFu8c { int * v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu8ll_BFu8i { int * v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu8ll_BFu8ll { int * v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu8ll_BFu8s { int * v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu8ll_BFu9i { int * v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu8ll_BFu9ll { int * v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu8ll_BFu9s { int * v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu8ll_C { int * v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aIp_BFu8ll_D { int * v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aIp_BFu8ll_F { int * v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aIp_BFu8ll_I { int * v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aIp_BFu8ll_Ip { int * v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aIp_BFu8ll_L { int * v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aIp_BFu8ll_S { int * v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aIp_BFu8ll_Uc { int * v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu8ll_Ui { int * v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu8ll_Ul { int * v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu8ll_Us { int * v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu8ll_Vp { int * v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aIp_BFu8s { int * v1; unsigned short v2:8; };
struct __attribute__((packed)) aIp_BFu8s_BFu15i { int * v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu8s_BFu15ll { int * v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu8s_BFu15s { int * v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu8s_BFu16i { int * v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu8s_BFu16ll { int * v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu8s_BFu16s { int * v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu8s_BFu17i { int * v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu8s_BFu17ll { int * v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu8s_BFu1c { int * v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu8s_BFu1i { int * v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu8s_BFu1ll { int * v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu8s_BFu1s { int * v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu8s_BFu31i { int * v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu8s_BFu31ll { int * v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu8s_BFu32i { int * v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu8s_BFu32ll { int * v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu8s_BFu33 { int * v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu8s_BFu7c { int * v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu8s_BFu7i { int * v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu8s_BFu7ll { int * v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu8s_BFu7s { int * v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu8s_BFu8c { int * v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu8s_BFu8i { int * v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu8s_BFu8ll { int * v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu8s_BFu8s { int * v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu8s_BFu9i { int * v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu8s_BFu9ll { int * v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu8s_BFu9s { int * v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu8s_C { int * v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aIp_BFu8s_D { int * v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aIp_BFu8s_F { int * v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aIp_BFu8s_I { int * v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aIp_BFu8s_Ip { int * v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aIp_BFu8s_L { int * v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aIp_BFu8s_S { int * v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aIp_BFu8s_Uc { int * v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu8s_Ui { int * v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu8s_Ul { int * v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu8s_Us { int * v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu8s_Vp { int * v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aIp_BFu9i { int * v1; unsigned int v2:9; };
struct __attribute__((packed)) aIp_BFu9i_BFu15i { int * v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu9i_BFu15ll { int * v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu9i_BFu15s { int * v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu9i_BFu16i { int * v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu9i_BFu16ll { int * v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu9i_BFu16s { int * v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu9i_BFu17i { int * v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu9i_BFu17ll { int * v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu9i_BFu1c { int * v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu9i_BFu1i { int * v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu9i_BFu1ll { int * v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu9i_BFu1s { int * v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu9i_BFu31i { int * v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu9i_BFu31ll { int * v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu9i_BFu32i { int * v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu9i_BFu32ll { int * v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu9i_BFu33 { int * v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu9i_BFu7c { int * v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu9i_BFu7i { int * v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu9i_BFu7ll { int * v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu9i_BFu7s { int * v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu9i_BFu8c { int * v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu9i_BFu8i { int * v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu9i_BFu8ll { int * v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu9i_BFu8s { int * v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu9i_BFu9i { int * v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu9i_BFu9ll { int * v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu9i_BFu9s { int * v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu9i_C { int * v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aIp_BFu9i_D { int * v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aIp_BFu9i_F { int * v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aIp_BFu9i_I { int * v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aIp_BFu9i_Ip { int * v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aIp_BFu9i_L { int * v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aIp_BFu9i_S { int * v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aIp_BFu9i_Uc { int * v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu9i_Ui { int * v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu9i_Ul { int * v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu9i_Us { int * v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu9i_Vp { int * v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aIp_BFu9ll { int * v1; unsigned long long v2:9; };
struct __attribute__((packed)) aIp_BFu9ll_BFu15i { int * v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu9ll_BFu15ll { int * v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu9ll_BFu15s { int * v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu9ll_BFu16i { int * v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu9ll_BFu16ll { int * v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu9ll_BFu16s { int * v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu9ll_BFu17i { int * v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu9ll_BFu17ll { int * v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu9ll_BFu1c { int * v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu9ll_BFu1i { int * v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu9ll_BFu1ll { int * v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu9ll_BFu1s { int * v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu9ll_BFu31i { int * v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu9ll_BFu31ll { int * v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu9ll_BFu32i { int * v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu9ll_BFu32ll { int * v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu9ll_BFu33 { int * v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu9ll_BFu7c { int * v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu9ll_BFu7i { int * v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu9ll_BFu7ll { int * v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu9ll_BFu7s { int * v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu9ll_BFu8c { int * v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu9ll_BFu8i { int * v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu9ll_BFu8ll { int * v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu9ll_BFu8s { int * v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu9ll_BFu9i { int * v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu9ll_BFu9ll { int * v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu9ll_BFu9s { int * v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu9ll_C { int * v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aIp_BFu9ll_D { int * v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aIp_BFu9ll_F { int * v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aIp_BFu9ll_I { int * v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aIp_BFu9ll_Ip { int * v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aIp_BFu9ll_L { int * v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aIp_BFu9ll_S { int * v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aIp_BFu9ll_Uc { int * v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu9ll_Ui { int * v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu9ll_Ul { int * v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu9ll_Us { int * v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu9ll_Vp { int * v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aIp_BFu9s { int * v1; unsigned short v2:9; };
struct __attribute__((packed)) aIp_BFu9s_BFu15i { int * v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu9s_BFu15ll { int * v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu9s_BFu15s { int * v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu9s_BFu16i { int * v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu9s_BFu16ll { int * v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu9s_BFu16s { int * v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu9s_BFu17i { int * v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu9s_BFu17ll { int * v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu9s_BFu1c { int * v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu9s_BFu1i { int * v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu9s_BFu1ll { int * v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu9s_BFu1s { int * v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu9s_BFu31i { int * v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu9s_BFu31ll { int * v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu9s_BFu32i { int * v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu9s_BFu32ll { int * v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu9s_BFu33 { int * v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu9s_BFu7c { int * v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu9s_BFu7i { int * v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu9s_BFu7ll { int * v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu9s_BFu7s { int * v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu9s_BFu8c { int * v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu9s_BFu8i { int * v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu9s_BFu8ll { int * v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu9s_BFu8s { int * v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu9s_BFu9i { int * v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu9s_BFu9ll { int * v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu9s_BFu9s { int * v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu9s_C { int * v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aIp_BFu9s_D { int * v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aIp_BFu9s_F { int * v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aIp_BFu9s_I { int * v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aIp_BFu9s_Ip { int * v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aIp_BFu9s_L { int * v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aIp_BFu9s_S { int * v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aIp_BFu9s_Uc { int * v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu9s_Ui { int * v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu9s_Ul { int * v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu9s_Us { int * v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu9s_Vp { int * v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aIp_C { int * v1; char v2; };
struct __attribute__((packed)) aIp_C_BFu15i { int * v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_C_BFu15ll { int * v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_C_BFu15s { int * v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_C_BFu16i { int * v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_C_BFu16ll { int * v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_C_BFu16s { int * v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_C_BFu17i { int * v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_C_BFu17ll { int * v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_C_BFu1c { int * v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_C_BFu1i { int * v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_C_BFu1ll { int * v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_C_BFu1s { int * v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_C_BFu31i { int * v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_C_BFu31ll { int * v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_C_BFu32i { int * v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_C_BFu32ll { int * v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_C_BFu33 { int * v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_C_BFu7c { int * v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_C_BFu7i { int * v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_C_BFu7ll { int * v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_C_BFu7s { int * v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_C_BFu8c { int * v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_C_BFu8i { int * v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_C_BFu8ll { int * v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_C_BFu8s { int * v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_C_BFu9i { int * v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_C_BFu9ll { int * v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_C_BFu9s { int * v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_C_C { int * v1; char v2; char v3; };
struct __attribute__((packed)) aIp_C_D { int * v1; char v2; double v3; };
struct __attribute__((packed)) aIp_C_F { int * v1; char v2; float v3; };
struct __attribute__((packed)) aIp_C_I { int * v1; char v2; int v3; };
struct __attribute__((packed)) aIp_C_Ip { int * v1; char v2; int * v3; };
struct __attribute__((packed)) aIp_C_L { int * v1; char v2; long long v3; };
struct __attribute__((packed)) aIp_C_S { int * v1; char v2; short v3; };
struct __attribute__((packed)) aIp_C_Uc { int * v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aIp_C_Ui { int * v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aIp_C_Ul { int * v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_C_Us { int * v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aIp_C_Vp { int * v1; char v2; void * v3; };
struct __attribute__((packed)) aIp_D { int * v1; double v2; };
struct __attribute__((packed)) aIp_D_BFu15i { int * v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_D_BFu15ll { int * v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_D_BFu15s { int * v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_D_BFu16i { int * v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_D_BFu16ll { int * v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_D_BFu16s { int * v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_D_BFu17i { int * v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_D_BFu17ll { int * v1; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_D_BFu1c { int * v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_D_BFu1i { int * v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_D_BFu1ll { int * v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_D_BFu1s { int * v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_D_BFu31i { int * v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_D_BFu31ll { int * v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_D_BFu32i { int * v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_D_BFu32ll { int * v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_D_BFu33 { int * v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_D_BFu7c { int * v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_D_BFu7i { int * v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_D_BFu7ll { int * v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_D_BFu7s { int * v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_D_BFu8c { int * v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_D_BFu8i { int * v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_D_BFu8ll { int * v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_D_BFu8s { int * v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_D_BFu9i { int * v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_D_BFu9ll { int * v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_D_BFu9s { int * v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_D_C { int * v1; double v2; char v3; };
struct __attribute__((packed)) aIp_D_D { int * v1; double v2; double v3; };
struct __attribute__((packed)) aIp_D_F { int * v1; double v2; float v3; };
struct __attribute__((packed)) aIp_D_I { int * v1; double v2; int v3; };
struct __attribute__((packed)) aIp_D_Ip { int * v1; double v2; int * v3; };
struct __attribute__((packed)) aIp_D_L { int * v1; double v2; long long v3; };
struct __attribute__((packed)) aIp_D_S { int * v1; double v2; short v3; };
struct __attribute__((packed)) aIp_D_Uc { int * v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aIp_D_Ui { int * v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aIp_D_Ul { int * v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_D_Us { int * v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aIp_D_Vp { int * v1; double v2; void * v3; };
struct __attribute__((packed)) aIp_F { int * v1; float v2; };
struct __attribute__((packed)) aIp_F_BFu15i { int * v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_F_BFu15ll { int * v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_F_BFu15s { int * v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_F_BFu16i { int * v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_F_BFu16ll { int * v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_F_BFu16s { int * v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_F_BFu17i { int * v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_F_BFu17ll { int * v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_F_BFu1c { int * v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_F_BFu1i { int * v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_F_BFu1ll { int * v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_F_BFu1s { int * v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_F_BFu31i { int * v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_F_BFu31ll { int * v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_F_BFu32i { int * v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_F_BFu32ll { int * v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_F_BFu33 { int * v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_F_BFu7c { int * v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_F_BFu7i { int * v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_F_BFu7ll { int * v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_F_BFu7s { int * v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_F_BFu8c { int * v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_F_BFu8i { int * v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_F_BFu8ll { int * v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_F_BFu8s { int * v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_F_BFu9i { int * v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_F_BFu9ll { int * v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_F_BFu9s { int * v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_F_C { int * v1; float v2; char v3; };
struct __attribute__((packed)) aIp_F_D { int * v1; float v2; double v3; };
struct __attribute__((packed)) aIp_F_F { int * v1; float v2; float v3; };
struct __attribute__((packed)) aIp_F_I { int * v1; float v2; int v3; };
struct __attribute__((packed)) aIp_F_Ip { int * v1; float v2; int * v3; };
struct __attribute__((packed)) aIp_F_L { int * v1; float v2; long long v3; };
struct __attribute__((packed)) aIp_F_S { int * v1; float v2; short v3; };
struct __attribute__((packed)) aIp_F_Uc { int * v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aIp_F_Ui { int * v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aIp_F_Ul { int * v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_F_Us { int * v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aIp_F_Vp { int * v1; float v2; void * v3; };
struct __attribute__((packed)) aIp_I { int * v1; int v2; };
struct __attribute__((packed)) aIp_I_BFu15i { int * v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_I_BFu15ll { int * v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_I_BFu15s { int * v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_I_BFu16i { int * v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_I_BFu16ll { int * v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_I_BFu16s { int * v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_I_BFu17i { int * v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_I_BFu17ll { int * v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_I_BFu1c { int * v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_I_BFu1i { int * v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_I_BFu1ll { int * v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_I_BFu1s { int * v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_I_BFu31i { int * v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_I_BFu31ll { int * v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_I_BFu32i { int * v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_I_BFu32ll { int * v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_I_BFu33 { int * v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_I_BFu7c { int * v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_I_BFu7i { int * v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_I_BFu7ll { int * v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_I_BFu7s { int * v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_I_BFu8c { int * v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_I_BFu8i { int * v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_I_BFu8ll { int * v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_I_BFu8s { int * v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_I_BFu9i { int * v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_I_BFu9ll { int * v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_I_BFu9s { int * v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_I_C { int * v1; int v2; char v3; };
struct __attribute__((packed)) aIp_I_D { int * v1; int v2; double v3; };
struct __attribute__((packed)) aIp_I_F { int * v1; int v2; float v3; };
struct __attribute__((packed)) aIp_I_I { int * v1; int v2; int v3; };
struct __attribute__((packed)) aIp_I_Ip { int * v1; int v2; int * v3; };
struct __attribute__((packed)) aIp_I_L { int * v1; int v2; long long v3; };
struct __attribute__((packed)) aIp_I_S { int * v1; int v2; short v3; };
struct __attribute__((packed)) aIp_I_Uc { int * v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aIp_I_Ui { int * v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aIp_I_Ul { int * v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_I_Us { int * v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aIp_I_Vp { int * v1; int v2; void * v3; };
struct __attribute__((packed)) aIp_Ip { int * v1; int * v2; };
struct __attribute__((packed)) aIp_Ip_BFu15i { int * v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_Ip_BFu15ll { int * v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_Ip_BFu15s { int * v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_Ip_BFu16i { int * v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_Ip_BFu16ll { int * v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_Ip_BFu16s { int * v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_Ip_BFu17i { int * v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_Ip_BFu17ll { int * v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_Ip_BFu1c { int * v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_Ip_BFu1i { int * v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_Ip_BFu1ll { int * v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_Ip_BFu1s { int * v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_Ip_BFu31i { int * v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_Ip_BFu31ll { int * v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_Ip_BFu32i { int * v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_Ip_BFu32ll { int * v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_Ip_BFu33 { int * v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_Ip_BFu7c { int * v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_Ip_BFu7i { int * v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_Ip_BFu7ll { int * v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_Ip_BFu7s { int * v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_Ip_BFu8c { int * v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_Ip_BFu8i { int * v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_Ip_BFu8ll { int * v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_Ip_BFu8s { int * v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_Ip_BFu9i { int * v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_Ip_BFu9ll { int * v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_Ip_BFu9s { int * v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_Ip_C { int * v1; int * v2; char v3; };
struct __attribute__((packed)) aIp_Ip_D { int * v1; int * v2; double v3; };
struct __attribute__((packed)) aIp_Ip_F { int * v1; int * v2; float v3; };
struct __attribute__((packed)) aIp_Ip_I { int * v1; int * v2; int v3; };
struct __attribute__((packed)) aIp_Ip_Ip { int * v1; int * v2; int * v3; };
struct __attribute__((packed)) aIp_Ip_L { int * v1; int * v2; long long v3; };
struct __attribute__((packed)) aIp_Ip_S { int * v1; int * v2; short v3; };
struct __attribute__((packed)) aIp_Ip_Uc { int * v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aIp_Ip_Ui { int * v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aIp_Ip_Ul { int * v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_Ip_Us { int * v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aIp_Ip_Vp { int * v1; int * v2; void * v3; };
struct __attribute__((packed)) aIp_L { int * v1; long long v2; };
struct __attribute__((packed)) aIp_L_BFu15i { int * v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_L_BFu15ll { int * v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_L_BFu15s { int * v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_L_BFu16i { int * v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_L_BFu16ll { int * v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_L_BFu16s { int * v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_L_BFu17i { int * v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_L_BFu17ll { int * v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_L_BFu1c { int * v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_L_BFu1i { int * v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_L_BFu1ll { int * v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_L_BFu1s { int * v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_L_BFu31i { int * v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_L_BFu31ll { int * v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_L_BFu32i { int * v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_L_BFu32ll { int * v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_L_BFu33 { int * v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_L_BFu7c { int * v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_L_BFu7i { int * v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_L_BFu7ll { int * v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_L_BFu7s { int * v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_L_BFu8c { int * v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_L_BFu8i { int * v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_L_BFu8ll { int * v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_L_BFu8s { int * v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_L_BFu9i { int * v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_L_BFu9ll { int * v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_L_BFu9s { int * v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_L_C { int * v1; long long v2; char v3; };
struct __attribute__((packed)) aIp_L_D { int * v1; long long v2; double v3; };
struct __attribute__((packed)) aIp_L_F { int * v1; long long v2; float v3; };
struct __attribute__((packed)) aIp_L_I { int * v1; long long v2; int v3; };
struct __attribute__((packed)) aIp_L_Ip { int * v1; long long v2; int * v3; };
struct __attribute__((packed)) aIp_L_L { int * v1; long long v2; long long v3; };
struct __attribute__((packed)) aIp_L_S { int * v1; long long v2; short v3; };
struct __attribute__((packed)) aIp_L_Uc { int * v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aIp_L_Ui { int * v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aIp_L_Ul { int * v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_L_Us { int * v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aIp_L_Vp { int * v1; long long v2; void * v3; };
struct __attribute__((packed)) aIp_S { int * v1; short v2; };
struct __attribute__((packed)) aIp_S_BFu15i { int * v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_S_BFu15ll { int * v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_S_BFu15s { int * v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_S_BFu16i { int * v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_S_BFu16ll { int * v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_S_BFu16s { int * v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_S_BFu17i { int * v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_S_BFu17ll { int * v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_S_BFu1c { int * v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_S_BFu1i { int * v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_S_BFu1ll { int * v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_S_BFu1s { int * v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_S_BFu31i { int * v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_S_BFu31ll { int * v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_S_BFu32i { int * v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_S_BFu32ll { int * v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_S_BFu33 { int * v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_S_BFu7c { int * v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_S_BFu7i { int * v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_S_BFu7ll { int * v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_S_BFu7s { int * v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_S_BFu8c { int * v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_S_BFu8i { int * v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_S_BFu8ll { int * v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_S_BFu8s { int * v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_S_BFu9i { int * v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_S_BFu9ll { int * v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_S_BFu9s { int * v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_S_C { int * v1; short v2; char v3; };
struct __attribute__((packed)) aIp_S_D { int * v1; short v2; double v3; };
struct __attribute__((packed)) aIp_S_F { int * v1; short v2; float v3; };
struct __attribute__((packed)) aIp_S_I { int * v1; short v2; int v3; };
struct __attribute__((packed)) aIp_S_Ip { int * v1; short v2; int * v3; };
struct __attribute__((packed)) aIp_S_L { int * v1; short v2; long long v3; };
struct __attribute__((packed)) aIp_S_S { int * v1; short v2; short v3; };
struct __attribute__((packed)) aIp_S_Uc { int * v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aIp_S_Ui { int * v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aIp_S_Ul { int * v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_S_Us { int * v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aIp_S_Vp { int * v1; short v2; void * v3; };
struct __attribute__((packed)) aIp_Uc { int * v1; unsigned char v2; };
struct __attribute__((packed)) aIp_Uc_BFu15i { int * v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_Uc_BFu15ll { int * v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_Uc_BFu15s { int * v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_Uc_BFu16i { int * v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_Uc_BFu16ll { int * v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_Uc_BFu16s { int * v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_Uc_BFu17i { int * v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_Uc_BFu17ll { int * v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_Uc_BFu1c { int * v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_Uc_BFu1i { int * v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_Uc_BFu1ll { int * v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_Uc_BFu1s { int * v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_Uc_BFu31i { int * v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_Uc_BFu31ll { int * v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_Uc_BFu32i { int * v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_Uc_BFu32ll { int * v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_Uc_BFu33 { int * v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_Uc_BFu7c { int * v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_Uc_BFu7i { int * v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_Uc_BFu7ll { int * v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_Uc_BFu7s { int * v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_Uc_BFu8c { int * v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_Uc_BFu8i { int * v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_Uc_BFu8ll { int * v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_Uc_BFu8s { int * v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_Uc_BFu9i { int * v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_Uc_BFu9ll { int * v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_Uc_BFu9s { int * v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_Uc_C { int * v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aIp_Uc_D { int * v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aIp_Uc_F { int * v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aIp_Uc_I { int * v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aIp_Uc_Ip { int * v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aIp_Uc_L { int * v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aIp_Uc_S { int * v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aIp_Uc_Uc { int * v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aIp_Uc_Ui { int * v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aIp_Uc_Ul { int * v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_Uc_Us { int * v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aIp_Uc_Vp { int * v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aIp_Ui { int * v1; unsigned int v2; };
struct __attribute__((packed)) aIp_Ui_BFu15i { int * v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_Ui_BFu15ll { int * v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_Ui_BFu15s { int * v1; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_Ui_BFu16i { int * v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_Ui_BFu16ll { int * v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_Ui_BFu16s { int * v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_Ui_BFu17i { int * v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_Ui_BFu17ll { int * v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_Ui_BFu1c { int * v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_Ui_BFu1i { int * v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_Ui_BFu1ll { int * v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_Ui_BFu1s { int * v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_Ui_BFu31i { int * v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_Ui_BFu31ll { int * v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_Ui_BFu32i { int * v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_Ui_BFu32ll { int * v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_Ui_BFu33 { int * v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_Ui_BFu7c { int * v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_Ui_BFu7i { int * v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_Ui_BFu7ll { int * v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_Ui_BFu7s { int * v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_Ui_BFu8c { int * v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_Ui_BFu8i { int * v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_Ui_BFu8ll { int * v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_Ui_BFu8s { int * v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_Ui_BFu9i { int * v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_Ui_BFu9ll { int * v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_Ui_BFu9s { int * v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_Ui_C { int * v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aIp_Ui_D { int * v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aIp_Ui_F { int * v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aIp_Ui_I { int * v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aIp_Ui_Ip { int * v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aIp_Ui_L { int * v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aIp_Ui_S { int * v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aIp_Ui_Uc { int * v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aIp_Ui_Ui { int * v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aIp_Ui_Ul { int * v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_Ui_Us { int * v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aIp_Ui_Vp { int * v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aIp_Ul { int * v1; unsigned long long v2; };
struct __attribute__((packed)) aIp_Ul_BFu15i { int * v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_Ul_BFu15ll { int * v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_Ul_BFu15s { int * v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_Ul_BFu16i { int * v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_Ul_BFu16ll { int * v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_Ul_BFu16s { int * v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_Ul_BFu17i { int * v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_Ul_BFu17ll { int * v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_Ul_BFu1c { int * v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_Ul_BFu1i { int * v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_Ul_BFu1ll { int * v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_Ul_BFu1s { int * v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_Ul_BFu31i { int * v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_Ul_BFu31ll { int * v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_Ul_BFu32i { int * v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_Ul_BFu32ll { int * v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_Ul_BFu33 { int * v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_Ul_BFu7c { int * v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_Ul_BFu7i { int * v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_Ul_BFu7ll { int * v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_Ul_BFu7s { int * v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_Ul_BFu8c { int * v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_Ul_BFu8i { int * v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_Ul_BFu8ll { int * v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_Ul_BFu8s { int * v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_Ul_BFu9i { int * v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_Ul_BFu9ll { int * v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_Ul_BFu9s { int * v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_Ul_C { int * v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aIp_Ul_D { int * v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aIp_Ul_F { int * v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aIp_Ul_I { int * v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aIp_Ul_Ip { int * v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aIp_Ul_L { int * v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aIp_Ul_S { int * v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aIp_Ul_Uc { int * v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aIp_Ul_Ui { int * v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aIp_Ul_Ul { int * v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_Ul_Us { int * v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aIp_Ul_Vp { int * v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aIp_Us { int * v1; unsigned short v2; };
struct __attribute__((packed)) aIp_Us_BFu15i { int * v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_Us_BFu15ll { int * v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_Us_BFu15s { int * v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_Us_BFu16i { int * v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_Us_BFu16ll { int * v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_Us_BFu16s { int * v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_Us_BFu17i { int * v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_Us_BFu17ll { int * v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_Us_BFu1c { int * v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_Us_BFu1i { int * v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_Us_BFu1ll { int * v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_Us_BFu1s { int * v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_Us_BFu31i { int * v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_Us_BFu31ll { int * v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_Us_BFu32i { int * v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_Us_BFu32ll { int * v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_Us_BFu33 { int * v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_Us_BFu7c { int * v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_Us_BFu7i { int * v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_Us_BFu7ll { int * v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_Us_BFu7s { int * v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_Us_BFu8c { int * v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_Us_BFu8i { int * v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_Us_BFu8ll { int * v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_Us_BFu8s { int * v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_Us_BFu9i { int * v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_Us_BFu9ll { int * v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_Us_BFu9s { int * v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_Us_C { int * v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aIp_Us_D { int * v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aIp_Us_F { int * v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aIp_Us_I { int * v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aIp_Us_Ip { int * v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aIp_Us_L { int * v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aIp_Us_S { int * v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aIp_Us_Uc { int * v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aIp_Us_Ui { int * v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aIp_Us_Ul { int * v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_Us_Us { int * v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aIp_Us_Vp { int * v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aIp_Vp { int * v1; void * v2; };
struct __attribute__((packed)) aIp_Vp_BFu15i { int * v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aIp_Vp_BFu15ll { int * v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_Vp_BFu15s { int * v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aIp_Vp_BFu16i { int * v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aIp_Vp_BFu16ll { int * v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_Vp_BFu16s { int * v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aIp_Vp_BFu17i { int * v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aIp_Vp_BFu17ll { int * v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_Vp_BFu1c { int * v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aIp_Vp_BFu1i { int * v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aIp_Vp_BFu1ll { int * v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_Vp_BFu1s { int * v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aIp_Vp_BFu31i { int * v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aIp_Vp_BFu31ll { int * v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_Vp_BFu32i { int * v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aIp_Vp_BFu32ll { int * v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_Vp_BFu33 { int * v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_Vp_BFu7c { int * v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aIp_Vp_BFu7i { int * v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aIp_Vp_BFu7ll { int * v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_Vp_BFu7s { int * v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aIp_Vp_BFu8c { int * v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aIp_Vp_BFu8i { int * v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aIp_Vp_BFu8ll { int * v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_Vp_BFu8s { int * v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aIp_Vp_BFu9i { int * v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aIp_Vp_BFu9ll { int * v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_Vp_BFu9s { int * v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aIp_Vp_C { int * v1; void * v2; char v3; };
struct __attribute__((packed)) aIp_Vp_D { int * v1; void * v2; double v3; };
struct __attribute__((packed)) aIp_Vp_F { int * v1; void * v2; float v3; };
struct __attribute__((packed)) aIp_Vp_I { int * v1; void * v2; int v3; };
struct __attribute__((packed)) aIp_Vp_Ip { int * v1; void * v2; int * v3; };
struct __attribute__((packed)) aIp_Vp_L { int * v1; void * v2; long long v3; };
struct __attribute__((packed)) aIp_Vp_S { int * v1; void * v2; short v3; };
struct __attribute__((packed)) aIp_Vp_Uc { int * v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aIp_Vp_Ui { int * v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aIp_Vp_Ul { int * v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aIp_Vp_Us { int * v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aIp_Vp_Vp { int * v1; void * v2; void * v3; };
struct __attribute__((packed)) aL { long long v1; };
struct __attribute__((packed)) aL_BFu15i { long long v1; unsigned int v2:15; };
struct __attribute__((packed)) aL_BFu15i_BFu15i { long long v1; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu15i_BFu15ll { long long v1; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu15i_BFu15s { long long v1; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu15i_BFu16i { long long v1; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu15i_BFu16ll { long long v1; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu15i_BFu16s { long long v1; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu15i_BFu17i { long long v1; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu15i_BFu17ll { long long v1; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu15i_BFu1c { long long v1; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu15i_BFu1i { long long v1; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu15i_BFu1ll { long long v1; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu15i_BFu1s { long long v1; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu15i_BFu31i { long long v1; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu15i_BFu31ll { long long v1; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu15i_BFu32i { long long v1; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu15i_BFu32ll { long long v1; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu15i_BFu33 { long long v1; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu15i_BFu7c { long long v1; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu15i_BFu7i { long long v1; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu15i_BFu7ll { long long v1; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu15i_BFu7s { long long v1; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu15i_BFu8c { long long v1; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu15i_BFu8i { long long v1; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu15i_BFu8ll { long long v1; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu15i_BFu8s { long long v1; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu15i_BFu9i { long long v1; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu15i_BFu9ll { long long v1; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu15i_BFu9s { long long v1; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu15i_C { long long v1; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aL_BFu15i_D { long long v1; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aL_BFu15i_F { long long v1; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aL_BFu15i_I { long long v1; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aL_BFu15i_Ip { long long v1; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aL_BFu15i_L { long long v1; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aL_BFu15i_S { long long v1; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aL_BFu15i_Uc { long long v1; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aL_BFu15i_Ui { long long v1; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aL_BFu15i_Ul { long long v1; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu15i_Us { long long v1; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aL_BFu15i_Vp { long long v1; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aL_BFu15ll { long long v1; unsigned long long v2:15; };
struct __attribute__((packed)) aL_BFu15ll_BFu15i { long long v1; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu15ll_BFu15ll { long long v1; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu15ll_BFu15s { long long v1; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu15ll_BFu16i { long long v1; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu15ll_BFu16ll { long long v1; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu15ll_BFu16s { long long v1; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu15ll_BFu17i { long long v1; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu15ll_BFu17ll { long long v1; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu15ll_BFu1c { long long v1; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu15ll_BFu1i { long long v1; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu15ll_BFu1ll { long long v1; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu15ll_BFu1s { long long v1; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu15ll_BFu31i { long long v1; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu15ll_BFu31ll { long long v1; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu15ll_BFu32i { long long v1; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu15ll_BFu32ll { long long v1; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu15ll_BFu33 { long long v1; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu15ll_BFu7c { long long v1; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu15ll_BFu7i { long long v1; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu15ll_BFu7ll { long long v1; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu15ll_BFu7s { long long v1; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu15ll_BFu8c { long long v1; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu15ll_BFu8i { long long v1; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu15ll_BFu8ll { long long v1; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu15ll_BFu8s { long long v1; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu15ll_BFu9i { long long v1; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu15ll_BFu9ll { long long v1; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu15ll_BFu9s { long long v1; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu15ll_C { long long v1; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aL_BFu15ll_D { long long v1; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aL_BFu15ll_F { long long v1; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aL_BFu15ll_I { long long v1; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aL_BFu15ll_Ip { long long v1; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aL_BFu15ll_L { long long v1; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aL_BFu15ll_S { long long v1; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aL_BFu15ll_Uc { long long v1; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aL_BFu15ll_Ui { long long v1; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aL_BFu15ll_Ul { long long v1; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu15ll_Us { long long v1; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aL_BFu15ll_Vp { long long v1; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aL_BFu15s { long long v1; unsigned short v2:15; };
struct __attribute__((packed)) aL_BFu15s_BFu15i { long long v1; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu15s_BFu15ll { long long v1; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu15s_BFu15s { long long v1; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu15s_BFu16i { long long v1; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu15s_BFu16ll { long long v1; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu15s_BFu16s { long long v1; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu15s_BFu17i { long long v1; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu15s_BFu17ll { long long v1; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu15s_BFu1c { long long v1; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu15s_BFu1i { long long v1; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu15s_BFu1ll { long long v1; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu15s_BFu1s { long long v1; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu15s_BFu31i { long long v1; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu15s_BFu31ll { long long v1; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu15s_BFu32i { long long v1; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu15s_BFu32ll { long long v1; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu15s_BFu33 { long long v1; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu15s_BFu7c { long long v1; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu15s_BFu7i { long long v1; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu15s_BFu7ll { long long v1; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu15s_BFu7s { long long v1; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu15s_BFu8c { long long v1; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu15s_BFu8i { long long v1; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu15s_BFu8ll { long long v1; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu15s_BFu8s { long long v1; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu15s_BFu9i { long long v1; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu15s_BFu9ll { long long v1; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu15s_BFu9s { long long v1; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu15s_C { long long v1; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aL_BFu15s_D { long long v1; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aL_BFu15s_F { long long v1; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aL_BFu15s_I { long long v1; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aL_BFu15s_Ip { long long v1; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aL_BFu15s_L { long long v1; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aL_BFu15s_S { long long v1; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aL_BFu15s_Uc { long long v1; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aL_BFu15s_Ui { long long v1; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aL_BFu15s_Ul { long long v1; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu15s_Us { long long v1; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aL_BFu15s_Vp { long long v1; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aL_BFu16i { long long v1; unsigned int v2:16; };
struct __attribute__((packed)) aL_BFu16i_BFu15i { long long v1; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu16i_BFu15ll { long long v1; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu16i_BFu15s { long long v1; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu16i_BFu16i { long long v1; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu16i_BFu16ll { long long v1; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu16i_BFu16s { long long v1; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu16i_BFu17i { long long v1; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu16i_BFu17ll { long long v1; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu16i_BFu1c { long long v1; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu16i_BFu1i { long long v1; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu16i_BFu1ll { long long v1; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu16i_BFu1s { long long v1; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu16i_BFu31i { long long v1; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu16i_BFu31ll { long long v1; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu16i_BFu32i { long long v1; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu16i_BFu32ll { long long v1; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu16i_BFu33 { long long v1; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu16i_BFu7c { long long v1; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu16i_BFu7i { long long v1; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu16i_BFu7ll { long long v1; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu16i_BFu7s { long long v1; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu16i_BFu8c { long long v1; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu16i_BFu8i { long long v1; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu16i_BFu8ll { long long v1; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu16i_BFu8s { long long v1; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu16i_BFu9i { long long v1; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu16i_BFu9ll { long long v1; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu16i_BFu9s { long long v1; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu16i_C { long long v1; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aL_BFu16i_D { long long v1; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aL_BFu16i_F { long long v1; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aL_BFu16i_I { long long v1; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aL_BFu16i_Ip { long long v1; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aL_BFu16i_L { long long v1; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aL_BFu16i_S { long long v1; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aL_BFu16i_Uc { long long v1; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aL_BFu16i_Ui { long long v1; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aL_BFu16i_Ul { long long v1; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu16i_Us { long long v1; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aL_BFu16i_Vp { long long v1; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aL_BFu16ll { long long v1; unsigned long long v2:16; };
struct __attribute__((packed)) aL_BFu16ll_BFu15i { long long v1; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu16ll_BFu15ll { long long v1; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu16ll_BFu15s { long long v1; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu16ll_BFu16i { long long v1; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu16ll_BFu16ll { long long v1; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu16ll_BFu16s { long long v1; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu16ll_BFu17i { long long v1; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu16ll_BFu17ll { long long v1; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu16ll_BFu1c { long long v1; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu16ll_BFu1i { long long v1; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu16ll_BFu1ll { long long v1; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu16ll_BFu1s { long long v1; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu16ll_BFu31i { long long v1; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu16ll_BFu31ll { long long v1; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu16ll_BFu32i { long long v1; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu16ll_BFu32ll { long long v1; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu16ll_BFu33 { long long v1; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu16ll_BFu7c { long long v1; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu16ll_BFu7i { long long v1; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu16ll_BFu7ll { long long v1; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu16ll_BFu7s { long long v1; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu16ll_BFu8c { long long v1; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu16ll_BFu8i { long long v1; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu16ll_BFu8ll { long long v1; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu16ll_BFu8s { long long v1; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu16ll_BFu9i { long long v1; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu16ll_BFu9ll { long long v1; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu16ll_BFu9s { long long v1; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu16ll_C { long long v1; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aL_BFu16ll_D { long long v1; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aL_BFu16ll_F { long long v1; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aL_BFu16ll_I { long long v1; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aL_BFu16ll_Ip { long long v1; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aL_BFu16ll_L { long long v1; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aL_BFu16ll_S { long long v1; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aL_BFu16ll_Uc { long long v1; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aL_BFu16ll_Ui { long long v1; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aL_BFu16ll_Ul { long long v1; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu16ll_Us { long long v1; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aL_BFu16ll_Vp { long long v1; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aL_BFu16s { long long v1; unsigned short v2:16; };
struct __attribute__((packed)) aL_BFu16s_BFu15i { long long v1; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu16s_BFu15ll { long long v1; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu16s_BFu15s { long long v1; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu16s_BFu16i { long long v1; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu16s_BFu16ll { long long v1; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu16s_BFu16s { long long v1; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu16s_BFu17i { long long v1; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu16s_BFu17ll { long long v1; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu16s_BFu1c { long long v1; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu16s_BFu1i { long long v1; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu16s_BFu1ll { long long v1; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu16s_BFu1s { long long v1; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu16s_BFu31i { long long v1; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu16s_BFu31ll { long long v1; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu16s_BFu32i { long long v1; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu16s_BFu32ll { long long v1; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu16s_BFu33 { long long v1; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu16s_BFu7c { long long v1; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu16s_BFu7i { long long v1; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu16s_BFu7ll { long long v1; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu16s_BFu7s { long long v1; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu16s_BFu8c { long long v1; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu16s_BFu8i { long long v1; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu16s_BFu8ll { long long v1; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu16s_BFu8s { long long v1; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu16s_BFu9i { long long v1; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu16s_BFu9ll { long long v1; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu16s_BFu9s { long long v1; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu16s_C { long long v1; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aL_BFu16s_D { long long v1; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aL_BFu16s_F { long long v1; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aL_BFu16s_I { long long v1; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aL_BFu16s_Ip { long long v1; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aL_BFu16s_L { long long v1; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aL_BFu16s_S { long long v1; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aL_BFu16s_Uc { long long v1; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aL_BFu16s_Ui { long long v1; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aL_BFu16s_Ul { long long v1; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu16s_Us { long long v1; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aL_BFu16s_Vp { long long v1; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aL_BFu17i { long long v1; unsigned int v2:17; };
struct __attribute__((packed)) aL_BFu17i_BFu15i { long long v1; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu17i_BFu15ll { long long v1; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu17i_BFu15s { long long v1; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu17i_BFu16i { long long v1; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu17i_BFu16ll { long long v1; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu17i_BFu16s { long long v1; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu17i_BFu17i { long long v1; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu17i_BFu17ll { long long v1; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu17i_BFu1c { long long v1; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu17i_BFu1i { long long v1; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu17i_BFu1ll { long long v1; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu17i_BFu1s { long long v1; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu17i_BFu31i { long long v1; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu17i_BFu31ll { long long v1; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu17i_BFu32i { long long v1; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu17i_BFu32ll { long long v1; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu17i_BFu33 { long long v1; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu17i_BFu7c { long long v1; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu17i_BFu7i { long long v1; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu17i_BFu7ll { long long v1; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu17i_BFu7s { long long v1; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu17i_BFu8c { long long v1; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu17i_BFu8i { long long v1; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu17i_BFu8ll { long long v1; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu17i_BFu8s { long long v1; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu17i_BFu9i { long long v1; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu17i_BFu9ll { long long v1; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu17i_BFu9s { long long v1; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu17i_C { long long v1; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aL_BFu17i_D { long long v1; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aL_BFu17i_F { long long v1; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aL_BFu17i_I { long long v1; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aL_BFu17i_Ip { long long v1; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aL_BFu17i_L { long long v1; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aL_BFu17i_S { long long v1; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aL_BFu17i_Uc { long long v1; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aL_BFu17i_Ui { long long v1; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aL_BFu17i_Ul { long long v1; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu17i_Us { long long v1; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aL_BFu17i_Vp { long long v1; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aL_BFu17ll { long long v1; unsigned long long v2:17; };
struct __attribute__((packed)) aL_BFu17ll_BFu15i { long long v1; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu17ll_BFu15ll { long long v1; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu17ll_BFu15s { long long v1; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu17ll_BFu16i { long long v1; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu17ll_BFu16ll { long long v1; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu17ll_BFu16s { long long v1; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu17ll_BFu17i { long long v1; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu17ll_BFu17ll { long long v1; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu17ll_BFu1c { long long v1; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu17ll_BFu1i { long long v1; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu17ll_BFu1ll { long long v1; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu17ll_BFu1s { long long v1; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu17ll_BFu31i { long long v1; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu17ll_BFu31ll { long long v1; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu17ll_BFu32i { long long v1; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu17ll_BFu32ll { long long v1; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu17ll_BFu33 { long long v1; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu17ll_BFu7c { long long v1; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu17ll_BFu7i { long long v1; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu17ll_BFu7ll { long long v1; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu17ll_BFu7s { long long v1; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu17ll_BFu8c { long long v1; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu17ll_BFu8i { long long v1; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu17ll_BFu8ll { long long v1; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu17ll_BFu8s { long long v1; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu17ll_BFu9i { long long v1; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu17ll_BFu9ll { long long v1; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu17ll_BFu9s { long long v1; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu17ll_C { long long v1; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aL_BFu17ll_D { long long v1; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aL_BFu17ll_F { long long v1; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aL_BFu17ll_I { long long v1; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aL_BFu17ll_Ip { long long v1; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aL_BFu17ll_L { long long v1; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aL_BFu17ll_S { long long v1; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aL_BFu17ll_Uc { long long v1; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aL_BFu17ll_Ui { long long v1; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aL_BFu17ll_Ul { long long v1; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu17ll_Us { long long v1; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aL_BFu17ll_Vp { long long v1; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aL_BFu1c { long long v1; unsigned char v2:1; };
struct __attribute__((packed)) aL_BFu1c_BFu15i { long long v1; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu1c_BFu15ll { long long v1; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu1c_BFu15s { long long v1; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu1c_BFu16i { long long v1; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu1c_BFu16ll { long long v1; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu1c_BFu16s { long long v1; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu1c_BFu17i { long long v1; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu1c_BFu17ll { long long v1; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu1c_BFu1c { long long v1; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu1c_BFu1i { long long v1; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu1c_BFu1ll { long long v1; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu1c_BFu1s { long long v1; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu1c_BFu31i { long long v1; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu1c_BFu31ll { long long v1; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu1c_BFu32i { long long v1; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu1c_BFu32ll { long long v1; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu1c_BFu33 { long long v1; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu1c_BFu7c { long long v1; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu1c_BFu7i { long long v1; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu1c_BFu7ll { long long v1; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu1c_BFu7s { long long v1; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu1c_BFu8c { long long v1; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu1c_BFu8i { long long v1; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu1c_BFu8ll { long long v1; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu1c_BFu8s { long long v1; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu1c_BFu9i { long long v1; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu1c_BFu9ll { long long v1; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu1c_BFu9s { long long v1; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu1c_C { long long v1; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aL_BFu1c_D { long long v1; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aL_BFu1c_F { long long v1; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aL_BFu1c_I { long long v1; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aL_BFu1c_Ip { long long v1; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aL_BFu1c_L { long long v1; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aL_BFu1c_S { long long v1; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aL_BFu1c_Uc { long long v1; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aL_BFu1c_Ui { long long v1; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aL_BFu1c_Ul { long long v1; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu1c_Us { long long v1; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aL_BFu1c_Vp { long long v1; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aL_BFu1i { long long v1; unsigned int v2:1; };
struct __attribute__((packed)) aL_BFu1i_BFu15i { long long v1; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu1i_BFu15ll { long long v1; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu1i_BFu15s { long long v1; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu1i_BFu16i { long long v1; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu1i_BFu16ll { long long v1; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu1i_BFu16s { long long v1; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu1i_BFu17i { long long v1; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu1i_BFu17ll { long long v1; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu1i_BFu1c { long long v1; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu1i_BFu1i { long long v1; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu1i_BFu1ll { long long v1; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu1i_BFu1s { long long v1; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu1i_BFu31i { long long v1; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu1i_BFu31ll { long long v1; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu1i_BFu32i { long long v1; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu1i_BFu32ll { long long v1; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu1i_BFu33 { long long v1; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu1i_BFu7c { long long v1; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu1i_BFu7i { long long v1; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu1i_BFu7ll { long long v1; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu1i_BFu7s { long long v1; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu1i_BFu8c { long long v1; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu1i_BFu8i { long long v1; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu1i_BFu8ll { long long v1; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu1i_BFu8s { long long v1; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu1i_BFu9i { long long v1; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu1i_BFu9ll { long long v1; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu1i_BFu9s { long long v1; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu1i_C { long long v1; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aL_BFu1i_D { long long v1; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aL_BFu1i_F { long long v1; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aL_BFu1i_I { long long v1; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aL_BFu1i_Ip { long long v1; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aL_BFu1i_L { long long v1; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aL_BFu1i_S { long long v1; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aL_BFu1i_Uc { long long v1; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aL_BFu1i_Ui { long long v1; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aL_BFu1i_Ul { long long v1; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu1i_Us { long long v1; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aL_BFu1i_Vp { long long v1; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aL_BFu1ll { long long v1; unsigned long long v2:1; };
struct __attribute__((packed)) aL_BFu1ll_BFu15i { long long v1; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu1ll_BFu15ll { long long v1; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu1ll_BFu15s { long long v1; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu1ll_BFu16i { long long v1; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu1ll_BFu16ll { long long v1; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu1ll_BFu16s { long long v1; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu1ll_BFu17i { long long v1; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu1ll_BFu17ll { long long v1; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu1ll_BFu1c { long long v1; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu1ll_BFu1i { long long v1; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu1ll_BFu1ll { long long v1; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu1ll_BFu1s { long long v1; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu1ll_BFu31i { long long v1; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu1ll_BFu31ll { long long v1; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu1ll_BFu32i { long long v1; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu1ll_BFu32ll { long long v1; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu1ll_BFu33 { long long v1; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu1ll_BFu7c { long long v1; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu1ll_BFu7i { long long v1; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu1ll_BFu7ll { long long v1; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu1ll_BFu7s { long long v1; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu1ll_BFu8c { long long v1; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu1ll_BFu8i { long long v1; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu1ll_BFu8ll { long long v1; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu1ll_BFu8s { long long v1; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu1ll_BFu9i { long long v1; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu1ll_BFu9ll { long long v1; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu1ll_BFu9s { long long v1; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu1ll_C { long long v1; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aL_BFu1ll_D { long long v1; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aL_BFu1ll_F { long long v1; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aL_BFu1ll_I { long long v1; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aL_BFu1ll_Ip { long long v1; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aL_BFu1ll_L { long long v1; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aL_BFu1ll_S { long long v1; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aL_BFu1ll_Uc { long long v1; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aL_BFu1ll_Ui { long long v1; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aL_BFu1ll_Ul { long long v1; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu1ll_Us { long long v1; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aL_BFu1ll_Vp { long long v1; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aL_BFu1s { long long v1; unsigned short v2:1; };
struct __attribute__((packed)) aL_BFu1s_BFu15i { long long v1; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu1s_BFu15ll { long long v1; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu1s_BFu15s { long long v1; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu1s_BFu16i { long long v1; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu1s_BFu16ll { long long v1; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu1s_BFu16s { long long v1; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu1s_BFu17i { long long v1; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu1s_BFu17ll { long long v1; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu1s_BFu1c { long long v1; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu1s_BFu1i { long long v1; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu1s_BFu1ll { long long v1; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu1s_BFu1s { long long v1; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu1s_BFu31i { long long v1; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu1s_BFu31ll { long long v1; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu1s_BFu32i { long long v1; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu1s_BFu32ll { long long v1; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu1s_BFu33 { long long v1; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu1s_BFu7c { long long v1; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu1s_BFu7i { long long v1; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu1s_BFu7ll { long long v1; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu1s_BFu7s { long long v1; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu1s_BFu8c { long long v1; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu1s_BFu8i { long long v1; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu1s_BFu8ll { long long v1; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu1s_BFu8s { long long v1; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu1s_BFu9i { long long v1; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu1s_BFu9ll { long long v1; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu1s_BFu9s { long long v1; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu1s_C { long long v1; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aL_BFu1s_D { long long v1; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aL_BFu1s_F { long long v1; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aL_BFu1s_I { long long v1; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aL_BFu1s_Ip { long long v1; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aL_BFu1s_L { long long v1; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aL_BFu1s_S { long long v1; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aL_BFu1s_Uc { long long v1; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aL_BFu1s_Ui { long long v1; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aL_BFu1s_Ul { long long v1; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu1s_Us { long long v1; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aL_BFu1s_Vp { long long v1; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aL_BFu31i { long long v1; unsigned int v2:31; };
struct __attribute__((packed)) aL_BFu31i_BFu15i { long long v1; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu31i_BFu15ll { long long v1; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu31i_BFu15s { long long v1; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu31i_BFu16i { long long v1; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu31i_BFu16ll { long long v1; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu31i_BFu16s { long long v1; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu31i_BFu17i { long long v1; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu31i_BFu17ll { long long v1; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu31i_BFu1c { long long v1; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu31i_BFu1i { long long v1; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu31i_BFu1ll { long long v1; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu31i_BFu1s { long long v1; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu31i_BFu31i { long long v1; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu31i_BFu31ll { long long v1; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu31i_BFu32i { long long v1; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu31i_BFu32ll { long long v1; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu31i_BFu33 { long long v1; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu31i_BFu7c { long long v1; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu31i_BFu7i { long long v1; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu31i_BFu7ll { long long v1; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu31i_BFu7s { long long v1; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu31i_BFu8c { long long v1; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu31i_BFu8i { long long v1; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu31i_BFu8ll { long long v1; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu31i_BFu8s { long long v1; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu31i_BFu9i { long long v1; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu31i_BFu9ll { long long v1; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu31i_BFu9s { long long v1; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu31i_C { long long v1; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aL_BFu31i_D { long long v1; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aL_BFu31i_F { long long v1; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aL_BFu31i_I { long long v1; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aL_BFu31i_Ip { long long v1; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aL_BFu31i_L { long long v1; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aL_BFu31i_S { long long v1; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aL_BFu31i_Uc { long long v1; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aL_BFu31i_Ui { long long v1; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aL_BFu31i_Ul { long long v1; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu31i_Us { long long v1; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aL_BFu31i_Vp { long long v1; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aL_BFu31ll { long long v1; unsigned long long v2:31; };
struct __attribute__((packed)) aL_BFu31ll_BFu15i { long long v1; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu31ll_BFu15ll { long long v1; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu31ll_BFu15s { long long v1; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu31ll_BFu16i { long long v1; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu31ll_BFu16ll { long long v1; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu31ll_BFu16s { long long v1; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu31ll_BFu17i { long long v1; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu31ll_BFu17ll { long long v1; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu31ll_BFu1c { long long v1; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu31ll_BFu1i { long long v1; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu31ll_BFu1ll { long long v1; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu31ll_BFu1s { long long v1; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu31ll_BFu31i { long long v1; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu31ll_BFu31ll { long long v1; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu31ll_BFu32i { long long v1; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu31ll_BFu32ll { long long v1; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu31ll_BFu33 { long long v1; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu31ll_BFu7c { long long v1; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu31ll_BFu7i { long long v1; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu31ll_BFu7ll { long long v1; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu31ll_BFu7s { long long v1; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu31ll_BFu8c { long long v1; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu31ll_BFu8i { long long v1; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu31ll_BFu8ll { long long v1; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu31ll_BFu8s { long long v1; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu31ll_BFu9i { long long v1; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu31ll_BFu9ll { long long v1; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu31ll_BFu9s { long long v1; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu31ll_C { long long v1; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aL_BFu31ll_D { long long v1; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aL_BFu31ll_F { long long v1; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aL_BFu31ll_I { long long v1; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aL_BFu31ll_Ip { long long v1; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aL_BFu31ll_L { long long v1; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aL_BFu31ll_S { long long v1; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aL_BFu31ll_Uc { long long v1; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aL_BFu31ll_Ui { long long v1; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aL_BFu31ll_Ul { long long v1; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu31ll_Us { long long v1; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aL_BFu31ll_Vp { long long v1; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aL_BFu32i { long long v1; unsigned int v2:32; };
struct __attribute__((packed)) aL_BFu32i_BFu15i { long long v1; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu32i_BFu15ll { long long v1; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu32i_BFu15s { long long v1; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu32i_BFu16i { long long v1; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu32i_BFu16ll { long long v1; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu32i_BFu16s { long long v1; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu32i_BFu17i { long long v1; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu32i_BFu17ll { long long v1; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu32i_BFu1c { long long v1; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu32i_BFu1i { long long v1; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu32i_BFu1ll { long long v1; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu32i_BFu1s { long long v1; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu32i_BFu31i { long long v1; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu32i_BFu31ll { long long v1; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu32i_BFu32i { long long v1; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu32i_BFu32ll { long long v1; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu32i_BFu33 { long long v1; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu32i_BFu7c { long long v1; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu32i_BFu7i { long long v1; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu32i_BFu7ll { long long v1; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu32i_BFu7s { long long v1; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu32i_BFu8c { long long v1; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu32i_BFu8i { long long v1; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu32i_BFu8ll { long long v1; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu32i_BFu8s { long long v1; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu32i_BFu9i { long long v1; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu32i_BFu9ll { long long v1; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu32i_BFu9s { long long v1; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu32i_C { long long v1; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aL_BFu32i_D { long long v1; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aL_BFu32i_F { long long v1; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aL_BFu32i_I { long long v1; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aL_BFu32i_Ip { long long v1; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aL_BFu32i_L { long long v1; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aL_BFu32i_S { long long v1; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aL_BFu32i_Uc { long long v1; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aL_BFu32i_Ui { long long v1; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aL_BFu32i_Ul { long long v1; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu32i_Us { long long v1; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aL_BFu32i_Vp { long long v1; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aL_BFu32ll { long long v1; unsigned long long v2:32; };
struct __attribute__((packed)) aL_BFu32ll_BFu15i { long long v1; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu32ll_BFu15ll { long long v1; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu32ll_BFu15s { long long v1; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu32ll_BFu16i { long long v1; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu32ll_BFu16ll { long long v1; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu32ll_BFu16s { long long v1; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu32ll_BFu17i { long long v1; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu32ll_BFu17ll { long long v1; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu32ll_BFu1c { long long v1; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu32ll_BFu1i { long long v1; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu32ll_BFu1ll { long long v1; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu32ll_BFu1s { long long v1; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu32ll_BFu31i { long long v1; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu32ll_BFu31ll { long long v1; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu32ll_BFu32i { long long v1; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu32ll_BFu32ll { long long v1; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu32ll_BFu33 { long long v1; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu32ll_BFu7c { long long v1; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu32ll_BFu7i { long long v1; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu32ll_BFu7ll { long long v1; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu32ll_BFu7s { long long v1; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu32ll_BFu8c { long long v1; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu32ll_BFu8i { long long v1; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu32ll_BFu8ll { long long v1; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu32ll_BFu8s { long long v1; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu32ll_BFu9i { long long v1; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu32ll_BFu9ll { long long v1; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu32ll_BFu9s { long long v1; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu32ll_C { long long v1; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aL_BFu32ll_D { long long v1; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aL_BFu32ll_F { long long v1; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aL_BFu32ll_I { long long v1; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aL_BFu32ll_Ip { long long v1; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aL_BFu32ll_L { long long v1; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aL_BFu32ll_S { long long v1; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aL_BFu32ll_Uc { long long v1; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aL_BFu32ll_Ui { long long v1; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aL_BFu32ll_Ul { long long v1; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu32ll_Us { long long v1; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aL_BFu32ll_Vp { long long v1; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aL_BFu33 { long long v1; unsigned long long v2:33; };
struct __attribute__((packed)) aL_BFu33_BFu15i { long long v1; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu33_BFu15ll { long long v1; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu33_BFu15s { long long v1; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu33_BFu16i { long long v1; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu33_BFu16ll { long long v1; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu33_BFu16s { long long v1; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu33_BFu17i { long long v1; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu33_BFu17ll { long long v1; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu33_BFu1c { long long v1; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu33_BFu1i { long long v1; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu33_BFu1ll { long long v1; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu33_BFu1s { long long v1; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu33_BFu31i { long long v1; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu33_BFu31ll { long long v1; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu33_BFu32i { long long v1; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu33_BFu32ll { long long v1; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu33_BFu33 { long long v1; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu33_BFu7c { long long v1; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu33_BFu7i { long long v1; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu33_BFu7ll { long long v1; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu33_BFu7s { long long v1; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu33_BFu8c { long long v1; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu33_BFu8i { long long v1; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu33_BFu8ll { long long v1; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu33_BFu8s { long long v1; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu33_BFu9i { long long v1; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu33_BFu9ll { long long v1; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu33_BFu9s { long long v1; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu33_C { long long v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aL_BFu33_D { long long v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aL_BFu33_F { long long v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aL_BFu33_I { long long v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aL_BFu33_Ip { long long v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aL_BFu33_L { long long v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aL_BFu33_S { long long v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aL_BFu33_Uc { long long v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aL_BFu33_Ui { long long v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aL_BFu33_Ul { long long v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu33_Us { long long v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aL_BFu33_Vp { long long v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aL_BFu7c { long long v1; unsigned char v2:7; };
struct __attribute__((packed)) aL_BFu7c_BFu15i { long long v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu7c_BFu15ll { long long v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu7c_BFu15s { long long v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu7c_BFu16i { long long v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu7c_BFu16ll { long long v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu7c_BFu16s { long long v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu7c_BFu17i { long long v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu7c_BFu17ll { long long v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu7c_BFu1c { long long v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu7c_BFu1i { long long v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu7c_BFu1ll { long long v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu7c_BFu1s { long long v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu7c_BFu31i { long long v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu7c_BFu31ll { long long v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu7c_BFu32i { long long v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu7c_BFu32ll { long long v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu7c_BFu33 { long long v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu7c_BFu7c { long long v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu7c_BFu7i { long long v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu7c_BFu7ll { long long v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu7c_BFu7s { long long v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu7c_BFu8c { long long v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu7c_BFu8i { long long v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu7c_BFu8ll { long long v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu7c_BFu8s { long long v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu7c_BFu9i { long long v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu7c_BFu9ll { long long v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu7c_BFu9s { long long v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu7c_C { long long v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aL_BFu7c_D { long long v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aL_BFu7c_F { long long v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aL_BFu7c_I { long long v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aL_BFu7c_Ip { long long v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aL_BFu7c_L { long long v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aL_BFu7c_S { long long v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aL_BFu7c_Uc { long long v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aL_BFu7c_Ui { long long v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aL_BFu7c_Ul { long long v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu7c_Us { long long v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aL_BFu7c_Vp { long long v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aL_BFu7i { long long v1; unsigned int v2:7; };
struct __attribute__((packed)) aL_BFu7i_BFu15i { long long v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu7i_BFu15ll { long long v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu7i_BFu15s { long long v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu7i_BFu16i { long long v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu7i_BFu16ll { long long v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu7i_BFu16s { long long v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu7i_BFu17i { long long v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu7i_BFu17ll { long long v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu7i_BFu1c { long long v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu7i_BFu1i { long long v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu7i_BFu1ll { long long v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu7i_BFu1s { long long v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu7i_BFu31i { long long v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu7i_BFu31ll { long long v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu7i_BFu32i { long long v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu7i_BFu32ll { long long v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu7i_BFu33 { long long v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu7i_BFu7c { long long v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu7i_BFu7i { long long v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu7i_BFu7ll { long long v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu7i_BFu7s { long long v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu7i_BFu8c { long long v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu7i_BFu8i { long long v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu7i_BFu8ll { long long v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu7i_BFu8s { long long v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu7i_BFu9i { long long v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu7i_BFu9ll { long long v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu7i_BFu9s { long long v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu7i_C { long long v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aL_BFu7i_D { long long v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aL_BFu7i_F { long long v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aL_BFu7i_I { long long v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aL_BFu7i_Ip { long long v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aL_BFu7i_L { long long v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aL_BFu7i_S { long long v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aL_BFu7i_Uc { long long v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aL_BFu7i_Ui { long long v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aL_BFu7i_Ul { long long v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu7i_Us { long long v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aL_BFu7i_Vp { long long v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aL_BFu7ll { long long v1; unsigned long long v2:7; };
struct __attribute__((packed)) aL_BFu7ll_BFu15i { long long v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu7ll_BFu15ll { long long v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu7ll_BFu15s { long long v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu7ll_BFu16i { long long v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu7ll_BFu16ll { long long v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu7ll_BFu16s { long long v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu7ll_BFu17i { long long v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu7ll_BFu17ll { long long v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu7ll_BFu1c { long long v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu7ll_BFu1i { long long v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu7ll_BFu1ll { long long v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu7ll_BFu1s { long long v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu7ll_BFu31i { long long v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu7ll_BFu31ll { long long v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu7ll_BFu32i { long long v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu7ll_BFu32ll { long long v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu7ll_BFu33 { long long v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu7ll_BFu7c { long long v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu7ll_BFu7i { long long v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu7ll_BFu7ll { long long v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu7ll_BFu7s { long long v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu7ll_BFu8c { long long v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu7ll_BFu8i { long long v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu7ll_BFu8ll { long long v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu7ll_BFu8s { long long v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu7ll_BFu9i { long long v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu7ll_BFu9ll { long long v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu7ll_BFu9s { long long v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu7ll_C { long long v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aL_BFu7ll_D { long long v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aL_BFu7ll_F { long long v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aL_BFu7ll_I { long long v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aL_BFu7ll_Ip { long long v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aL_BFu7ll_L { long long v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aL_BFu7ll_S { long long v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aL_BFu7ll_Uc { long long v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aL_BFu7ll_Ui { long long v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aL_BFu7ll_Ul { long long v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu7ll_Us { long long v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aL_BFu7ll_Vp { long long v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aL_BFu7s { long long v1; unsigned short v2:7; };
struct __attribute__((packed)) aL_BFu7s_BFu15i { long long v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu7s_BFu15ll { long long v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu7s_BFu15s { long long v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu7s_BFu16i { long long v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu7s_BFu16ll { long long v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu7s_BFu16s { long long v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu7s_BFu17i { long long v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu7s_BFu17ll { long long v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu7s_BFu1c { long long v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu7s_BFu1i { long long v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu7s_BFu1ll { long long v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu7s_BFu1s { long long v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu7s_BFu31i { long long v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu7s_BFu31ll { long long v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu7s_BFu32i { long long v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu7s_BFu32ll { long long v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu7s_BFu33 { long long v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu7s_BFu7c { long long v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu7s_BFu7i { long long v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu7s_BFu7ll { long long v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu7s_BFu7s { long long v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu7s_BFu8c { long long v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu7s_BFu8i { long long v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu7s_BFu8ll { long long v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu7s_BFu8s { long long v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu7s_BFu9i { long long v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu7s_BFu9ll { long long v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu7s_BFu9s { long long v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu7s_C { long long v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aL_BFu7s_D { long long v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aL_BFu7s_F { long long v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aL_BFu7s_I { long long v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aL_BFu7s_Ip { long long v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aL_BFu7s_L { long long v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aL_BFu7s_S { long long v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aL_BFu7s_Uc { long long v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aL_BFu7s_Ui { long long v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aL_BFu7s_Ul { long long v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu7s_Us { long long v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aL_BFu7s_Vp { long long v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aL_BFu8c { long long v1; unsigned char v2:8; };
struct __attribute__((packed)) aL_BFu8c_BFu15i { long long v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu8c_BFu15ll { long long v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu8c_BFu15s { long long v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu8c_BFu16i { long long v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu8c_BFu16ll { long long v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu8c_BFu16s { long long v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu8c_BFu17i { long long v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu8c_BFu17ll { long long v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu8c_BFu1c { long long v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu8c_BFu1i { long long v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu8c_BFu1ll { long long v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu8c_BFu1s { long long v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu8c_BFu31i { long long v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu8c_BFu31ll { long long v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu8c_BFu32i { long long v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu8c_BFu32ll { long long v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu8c_BFu33 { long long v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu8c_BFu7c { long long v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu8c_BFu7i { long long v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu8c_BFu7ll { long long v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu8c_BFu7s { long long v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu8c_BFu8c { long long v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu8c_BFu8i { long long v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu8c_BFu8ll { long long v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu8c_BFu8s { long long v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu8c_BFu9i { long long v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu8c_BFu9ll { long long v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu8c_BFu9s { long long v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu8c_C { long long v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aL_BFu8c_D { long long v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aL_BFu8c_F { long long v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aL_BFu8c_I { long long v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aL_BFu8c_Ip { long long v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aL_BFu8c_L { long long v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aL_BFu8c_S { long long v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aL_BFu8c_Uc { long long v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aL_BFu8c_Ui { long long v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aL_BFu8c_Ul { long long v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu8c_Us { long long v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aL_BFu8c_Vp { long long v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aL_BFu8i { long long v1; unsigned int v2:8; };
struct __attribute__((packed)) aL_BFu8i_BFu15i { long long v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu8i_BFu15ll { long long v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu8i_BFu15s { long long v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu8i_BFu16i { long long v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu8i_BFu16ll { long long v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu8i_BFu16s { long long v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu8i_BFu17i { long long v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu8i_BFu17ll { long long v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu8i_BFu1c { long long v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu8i_BFu1i { long long v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu8i_BFu1ll { long long v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu8i_BFu1s { long long v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu8i_BFu31i { long long v1; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu8i_BFu31ll { long long v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu8i_BFu32i { long long v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu8i_BFu32ll { long long v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu8i_BFu33 { long long v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu8i_BFu7c { long long v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu8i_BFu7i { long long v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu8i_BFu7ll { long long v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu8i_BFu7s { long long v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu8i_BFu8c { long long v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu8i_BFu8i { long long v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu8i_BFu8ll { long long v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu8i_BFu8s { long long v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu8i_BFu9i { long long v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu8i_BFu9ll { long long v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu8i_BFu9s { long long v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu8i_C { long long v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aL_BFu8i_D { long long v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aL_BFu8i_F { long long v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aL_BFu8i_I { long long v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aL_BFu8i_Ip { long long v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aL_BFu8i_L { long long v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aL_BFu8i_S { long long v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aL_BFu8i_Uc { long long v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aL_BFu8i_Ui { long long v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aL_BFu8i_Ul { long long v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu8i_Us { long long v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aL_BFu8i_Vp { long long v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aL_BFu8ll { long long v1; unsigned long long v2:8; };
struct __attribute__((packed)) aL_BFu8ll_BFu15i { long long v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu8ll_BFu15ll { long long v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu8ll_BFu15s { long long v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu8ll_BFu16i { long long v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu8ll_BFu16ll { long long v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu8ll_BFu16s { long long v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu8ll_BFu17i { long long v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu8ll_BFu17ll { long long v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu8ll_BFu1c { long long v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu8ll_BFu1i { long long v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu8ll_BFu1ll { long long v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu8ll_BFu1s { long long v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu8ll_BFu31i { long long v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu8ll_BFu31ll { long long v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu8ll_BFu32i { long long v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu8ll_BFu32ll { long long v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu8ll_BFu33 { long long v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu8ll_BFu7c { long long v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu8ll_BFu7i { long long v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu8ll_BFu7ll { long long v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu8ll_BFu7s { long long v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu8ll_BFu8c { long long v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu8ll_BFu8i { long long v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu8ll_BFu8ll { long long v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu8ll_BFu8s { long long v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu8ll_BFu9i { long long v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu8ll_BFu9ll { long long v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu8ll_BFu9s { long long v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu8ll_C { long long v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aL_BFu8ll_D { long long v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aL_BFu8ll_F { long long v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aL_BFu8ll_I { long long v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aL_BFu8ll_Ip { long long v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aL_BFu8ll_L { long long v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aL_BFu8ll_S { long long v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aL_BFu8ll_Uc { long long v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aL_BFu8ll_Ui { long long v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aL_BFu8ll_Ul { long long v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu8ll_Us { long long v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aL_BFu8ll_Vp { long long v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aL_BFu8s { long long v1; unsigned short v2:8; };
struct __attribute__((packed)) aL_BFu8s_BFu15i { long long v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu8s_BFu15ll { long long v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu8s_BFu15s { long long v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu8s_BFu16i { long long v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu8s_BFu16ll { long long v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu8s_BFu16s { long long v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu8s_BFu17i { long long v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu8s_BFu17ll { long long v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu8s_BFu1c { long long v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu8s_BFu1i { long long v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu8s_BFu1ll { long long v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu8s_BFu1s { long long v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu8s_BFu31i { long long v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu8s_BFu31ll { long long v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu8s_BFu32i { long long v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu8s_BFu32ll { long long v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu8s_BFu33 { long long v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu8s_BFu7c { long long v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu8s_BFu7i { long long v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu8s_BFu7ll { long long v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu8s_BFu7s { long long v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu8s_BFu8c { long long v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu8s_BFu8i { long long v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu8s_BFu8ll { long long v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu8s_BFu8s { long long v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu8s_BFu9i { long long v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu8s_BFu9ll { long long v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu8s_BFu9s { long long v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu8s_C { long long v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aL_BFu8s_D { long long v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aL_BFu8s_F { long long v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aL_BFu8s_I { long long v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aL_BFu8s_Ip { long long v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aL_BFu8s_L { long long v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aL_BFu8s_S { long long v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aL_BFu8s_Uc { long long v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aL_BFu8s_Ui { long long v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aL_BFu8s_Ul { long long v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu8s_Us { long long v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aL_BFu8s_Vp { long long v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aL_BFu9i { long long v1; unsigned int v2:9; };
struct __attribute__((packed)) aL_BFu9i_BFu15i { long long v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu9i_BFu15ll { long long v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu9i_BFu15s { long long v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu9i_BFu16i { long long v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu9i_BFu16ll { long long v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu9i_BFu16s { long long v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu9i_BFu17i { long long v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu9i_BFu17ll { long long v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu9i_BFu1c { long long v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu9i_BFu1i { long long v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu9i_BFu1ll { long long v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu9i_BFu1s { long long v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu9i_BFu31i { long long v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu9i_BFu31ll { long long v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu9i_BFu32i { long long v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu9i_BFu32ll { long long v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu9i_BFu33 { long long v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu9i_BFu7c { long long v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu9i_BFu7i { long long v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu9i_BFu7ll { long long v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu9i_BFu7s { long long v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu9i_BFu8c { long long v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu9i_BFu8i { long long v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu9i_BFu8ll { long long v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu9i_BFu8s { long long v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu9i_BFu9i { long long v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu9i_BFu9ll { long long v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu9i_BFu9s { long long v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu9i_C { long long v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aL_BFu9i_D { long long v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aL_BFu9i_F { long long v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aL_BFu9i_I { long long v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aL_BFu9i_Ip { long long v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aL_BFu9i_L { long long v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aL_BFu9i_S { long long v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aL_BFu9i_Uc { long long v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aL_BFu9i_Ui { long long v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aL_BFu9i_Ul { long long v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu9i_Us { long long v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aL_BFu9i_Vp { long long v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aL_BFu9ll { long long v1; unsigned long long v2:9; };
struct __attribute__((packed)) aL_BFu9ll_BFu15i { long long v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu9ll_BFu15ll { long long v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu9ll_BFu15s { long long v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu9ll_BFu16i { long long v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu9ll_BFu16ll { long long v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu9ll_BFu16s { long long v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu9ll_BFu17i { long long v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu9ll_BFu17ll { long long v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu9ll_BFu1c { long long v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu9ll_BFu1i { long long v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu9ll_BFu1ll { long long v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu9ll_BFu1s { long long v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu9ll_BFu31i { long long v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu9ll_BFu31ll { long long v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu9ll_BFu32i { long long v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu9ll_BFu32ll { long long v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu9ll_BFu33 { long long v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu9ll_BFu7c { long long v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu9ll_BFu7i { long long v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu9ll_BFu7ll { long long v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu9ll_BFu7s { long long v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu9ll_BFu8c { long long v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu9ll_BFu8i { long long v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu9ll_BFu8ll { long long v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu9ll_BFu8s { long long v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu9ll_BFu9i { long long v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu9ll_BFu9ll { long long v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu9ll_BFu9s { long long v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu9ll_C { long long v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aL_BFu9ll_D { long long v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aL_BFu9ll_F { long long v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aL_BFu9ll_I { long long v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aL_BFu9ll_Ip { long long v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aL_BFu9ll_L { long long v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aL_BFu9ll_S { long long v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aL_BFu9ll_Uc { long long v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aL_BFu9ll_Ui { long long v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aL_BFu9ll_Ul { long long v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu9ll_Us { long long v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aL_BFu9ll_Vp { long long v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aL_BFu9s { long long v1; unsigned short v2:9; };
struct __attribute__((packed)) aL_BFu9s_BFu15i { long long v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aL_BFu9s_BFu15ll { long long v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aL_BFu9s_BFu15s { long long v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aL_BFu9s_BFu16i { long long v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aL_BFu9s_BFu16ll { long long v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aL_BFu9s_BFu16s { long long v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aL_BFu9s_BFu17i { long long v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aL_BFu9s_BFu17ll { long long v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aL_BFu9s_BFu1c { long long v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aL_BFu9s_BFu1i { long long v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aL_BFu9s_BFu1ll { long long v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aL_BFu9s_BFu1s { long long v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aL_BFu9s_BFu31i { long long v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aL_BFu9s_BFu31ll { long long v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aL_BFu9s_BFu32i { long long v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aL_BFu9s_BFu32ll { long long v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aL_BFu9s_BFu33 { long long v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aL_BFu9s_BFu7c { long long v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aL_BFu9s_BFu7i { long long v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aL_BFu9s_BFu7ll { long long v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aL_BFu9s_BFu7s { long long v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aL_BFu9s_BFu8c { long long v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aL_BFu9s_BFu8i { long long v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aL_BFu9s_BFu8ll { long long v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aL_BFu9s_BFu8s { long long v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aL_BFu9s_BFu9i { long long v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aL_BFu9s_BFu9ll { long long v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aL_BFu9s_BFu9s { long long v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aL_BFu9s_C { long long v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aL_BFu9s_D { long long v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aL_BFu9s_F { long long v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aL_BFu9s_I { long long v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aL_BFu9s_Ip { long long v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aL_BFu9s_L { long long v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aL_BFu9s_S { long long v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aL_BFu9s_Uc { long long v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aL_BFu9s_Ui { long long v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aL_BFu9s_Ul { long long v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aL_BFu9s_Us { long long v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aL_BFu9s_Vp { long long v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aL_C { long long v1; char v2; };
struct __attribute__((packed)) aL_C_BFu15i { long long v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_C_BFu15ll { long long v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_C_BFu15s { long long v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aL_C_BFu16i { long long v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_C_BFu16ll { long long v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_C_BFu16s { long long v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_C_BFu17i { long long v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_C_BFu17ll { long long v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_C_BFu1c { long long v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_C_BFu1i { long long v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_C_BFu1ll { long long v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_C_BFu1s { long long v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_C_BFu31i { long long v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_C_BFu31ll { long long v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_C_BFu32i { long long v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_C_BFu32ll { long long v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_C_BFu33 { long long v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_C_BFu7c { long long v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_C_BFu7i { long long v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_C_BFu7ll { long long v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_C_BFu7s { long long v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_C_BFu8c { long long v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_C_BFu8i { long long v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_C_BFu8ll { long long v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_C_BFu8s { long long v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_C_BFu9i { long long v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_C_BFu9ll { long long v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_C_BFu9s { long long v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_C_C { long long v1; char v2; char v3; };
struct __attribute__((packed)) aL_C_D { long long v1; char v2; double v3; };
struct __attribute__((packed)) aL_C_F { long long v1; char v2; float v3; };
struct __attribute__((packed)) aL_C_I { long long v1; char v2; int v3; };
struct __attribute__((packed)) aL_C_Ip { long long v1; char v2; int * v3; };
struct __attribute__((packed)) aL_C_L { long long v1; char v2; long long v3; };
struct __attribute__((packed)) aL_C_S { long long v1; char v2; short v3; };
struct __attribute__((packed)) aL_C_Uc { long long v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aL_C_Ui { long long v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aL_C_Ul { long long v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aL_C_Us { long long v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aL_C_Vp { long long v1; char v2; void * v3; };
struct __attribute__((packed)) aL_D { long long v1; double v2; };
struct __attribute__((packed)) aL_D_BFu15i { long long v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_D_BFu15ll { long long v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_D_BFu15s { long long v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aL_D_BFu16i { long long v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_D_BFu16ll { long long v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_D_BFu16s { long long v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_D_BFu17i { long long v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_D_BFu17ll { long long v1; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_D_BFu1c { long long v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_D_BFu1i { long long v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_D_BFu1ll { long long v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_D_BFu1s { long long v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_D_BFu31i { long long v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_D_BFu31ll { long long v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_D_BFu32i { long long v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_D_BFu32ll { long long v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_D_BFu33 { long long v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_D_BFu7c { long long v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_D_BFu7i { long long v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_D_BFu7ll { long long v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_D_BFu7s { long long v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_D_BFu8c { long long v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_D_BFu8i { long long v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_D_BFu8ll { long long v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_D_BFu8s { long long v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_D_BFu9i { long long v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_D_BFu9ll { long long v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_D_BFu9s { long long v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_D_C { long long v1; double v2; char v3; };
struct __attribute__((packed)) aL_D_D { long long v1; double v2; double v3; };
struct __attribute__((packed)) aL_D_F { long long v1; double v2; float v3; };
struct __attribute__((packed)) aL_D_I { long long v1; double v2; int v3; };
struct __attribute__((packed)) aL_D_Ip { long long v1; double v2; int * v3; };
struct __attribute__((packed)) aL_D_L { long long v1; double v2; long long v3; };
struct __attribute__((packed)) aL_D_S { long long v1; double v2; short v3; };
struct __attribute__((packed)) aL_D_Uc { long long v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aL_D_Ui { long long v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aL_D_Ul { long long v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aL_D_Us { long long v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aL_D_Vp { long long v1; double v2; void * v3; };
struct __attribute__((packed)) aL_F { long long v1; float v2; };
struct __attribute__((packed)) aL_F_BFu15i { long long v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_F_BFu15ll { long long v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_F_BFu15s { long long v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aL_F_BFu16i { long long v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_F_BFu16ll { long long v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_F_BFu16s { long long v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_F_BFu17i { long long v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_F_BFu17ll { long long v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_F_BFu1c { long long v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_F_BFu1i { long long v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_F_BFu1ll { long long v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_F_BFu1s { long long v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_F_BFu31i { long long v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_F_BFu31ll { long long v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_F_BFu32i { long long v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_F_BFu32ll { long long v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_F_BFu33 { long long v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_F_BFu7c { long long v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_F_BFu7i { long long v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_F_BFu7ll { long long v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_F_BFu7s { long long v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_F_BFu8c { long long v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_F_BFu8i { long long v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_F_BFu8ll { long long v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_F_BFu8s { long long v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_F_BFu9i { long long v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_F_BFu9ll { long long v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_F_BFu9s { long long v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_F_C { long long v1; float v2; char v3; };
struct __attribute__((packed)) aL_F_D { long long v1; float v2; double v3; };
struct __attribute__((packed)) aL_F_F { long long v1; float v2; float v3; };
struct __attribute__((packed)) aL_F_I { long long v1; float v2; int v3; };
struct __attribute__((packed)) aL_F_Ip { long long v1; float v2; int * v3; };
struct __attribute__((packed)) aL_F_L { long long v1; float v2; long long v3; };
struct __attribute__((packed)) aL_F_S { long long v1; float v2; short v3; };
struct __attribute__((packed)) aL_F_Uc { long long v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aL_F_Ui { long long v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aL_F_Ul { long long v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aL_F_Us { long long v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aL_F_Vp { long long v1; float v2; void * v3; };
struct __attribute__((packed)) aL_I { long long v1; int v2; };
struct __attribute__((packed)) aL_I_BFu15i { long long v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_I_BFu15ll { long long v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_I_BFu15s { long long v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aL_I_BFu16i { long long v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_I_BFu16ll { long long v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_I_BFu16s { long long v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_I_BFu17i { long long v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_I_BFu17ll { long long v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_I_BFu1c { long long v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_I_BFu1i { long long v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_I_BFu1ll { long long v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_I_BFu1s { long long v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_I_BFu31i { long long v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_I_BFu31ll { long long v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_I_BFu32i { long long v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_I_BFu32ll { long long v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_I_BFu33 { long long v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_I_BFu7c { long long v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_I_BFu7i { long long v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_I_BFu7ll { long long v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_I_BFu7s { long long v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_I_BFu8c { long long v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_I_BFu8i { long long v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_I_BFu8ll { long long v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_I_BFu8s { long long v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_I_BFu9i { long long v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_I_BFu9ll { long long v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_I_BFu9s { long long v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_I_C { long long v1; int v2; char v3; };
struct __attribute__((packed)) aL_I_D { long long v1; int v2; double v3; };
struct __attribute__((packed)) aL_I_F { long long v1; int v2; float v3; };
struct __attribute__((packed)) aL_I_I { long long v1; int v2; int v3; };
struct __attribute__((packed)) aL_I_Ip { long long v1; int v2; int * v3; };
struct __attribute__((packed)) aL_I_L { long long v1; int v2; long long v3; };
struct __attribute__((packed)) aL_I_S { long long v1; int v2; short v3; };
struct __attribute__((packed)) aL_I_Uc { long long v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aL_I_Ui { long long v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aL_I_Ul { long long v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aL_I_Us { long long v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aL_I_Vp { long long v1; int v2; void * v3; };
struct __attribute__((packed)) aL_Ip { long long v1; int * v2; };
struct __attribute__((packed)) aL_Ip_BFu15i { long long v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_Ip_BFu15ll { long long v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_Ip_BFu15s { long long v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aL_Ip_BFu16i { long long v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_Ip_BFu16ll { long long v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_Ip_BFu16s { long long v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_Ip_BFu17i { long long v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_Ip_BFu17ll { long long v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_Ip_BFu1c { long long v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_Ip_BFu1i { long long v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_Ip_BFu1ll { long long v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_Ip_BFu1s { long long v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_Ip_BFu31i { long long v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_Ip_BFu31ll { long long v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_Ip_BFu32i { long long v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_Ip_BFu32ll { long long v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_Ip_BFu33 { long long v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_Ip_BFu7c { long long v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_Ip_BFu7i { long long v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_Ip_BFu7ll { long long v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_Ip_BFu7s { long long v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_Ip_BFu8c { long long v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_Ip_BFu8i { long long v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_Ip_BFu8ll { long long v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_Ip_BFu8s { long long v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_Ip_BFu9i { long long v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_Ip_BFu9ll { long long v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_Ip_BFu9s { long long v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_Ip_C { long long v1; int * v2; char v3; };
struct __attribute__((packed)) aL_Ip_D { long long v1; int * v2; double v3; };
struct __attribute__((packed)) aL_Ip_F { long long v1; int * v2; float v3; };
struct __attribute__((packed)) aL_Ip_I { long long v1; int * v2; int v3; };
struct __attribute__((packed)) aL_Ip_Ip { long long v1; int * v2; int * v3; };
struct __attribute__((packed)) aL_Ip_L { long long v1; int * v2; long long v3; };
struct __attribute__((packed)) aL_Ip_S { long long v1; int * v2; short v3; };
struct __attribute__((packed)) aL_Ip_Uc { long long v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aL_Ip_Ui { long long v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aL_Ip_Ul { long long v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aL_Ip_Us { long long v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aL_Ip_Vp { long long v1; int * v2; void * v3; };
struct __attribute__((packed)) aL_L { long long v1; long long v2; };
struct __attribute__((packed)) aL_L_BFu15i { long long v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_L_BFu15ll { long long v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_L_BFu15s { long long v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aL_L_BFu16i { long long v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_L_BFu16ll { long long v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_L_BFu16s { long long v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_L_BFu17i { long long v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_L_BFu17ll { long long v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_L_BFu1c { long long v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_L_BFu1i { long long v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_L_BFu1ll { long long v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_L_BFu1s { long long v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_L_BFu31i { long long v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_L_BFu31ll { long long v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_L_BFu32i { long long v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_L_BFu32ll { long long v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_L_BFu33 { long long v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_L_BFu7c { long long v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_L_BFu7i { long long v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_L_BFu7ll { long long v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_L_BFu7s { long long v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_L_BFu8c { long long v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_L_BFu8i { long long v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_L_BFu8ll { long long v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_L_BFu8s { long long v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_L_BFu9i { long long v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_L_BFu9ll { long long v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_L_BFu9s { long long v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_L_C { long long v1; long long v2; char v3; };
struct __attribute__((packed)) aL_L_D { long long v1; long long v2; double v3; };
struct __attribute__((packed)) aL_L_F { long long v1; long long v2; float v3; };
struct __attribute__((packed)) aL_L_I { long long v1; long long v2; int v3; };
struct __attribute__((packed)) aL_L_Ip { long long v1; long long v2; int * v3; };
struct __attribute__((packed)) aL_L_L { long long v1; long long v2; long long v3; };
struct __attribute__((packed)) aL_L_S { long long v1; long long v2; short v3; };
struct __attribute__((packed)) aL_L_Uc { long long v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aL_L_Ui { long long v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aL_L_Ul { long long v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aL_L_Us { long long v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aL_L_Vp { long long v1; long long v2; void * v3; };
struct __attribute__((packed)) aL_S { long long v1; short v2; };
struct __attribute__((packed)) aL_S_BFu15i { long long v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_S_BFu15ll { long long v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_S_BFu15s { long long v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aL_S_BFu16i { long long v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_S_BFu16ll { long long v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_S_BFu16s { long long v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_S_BFu17i { long long v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_S_BFu17ll { long long v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_S_BFu1c { long long v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_S_BFu1i { long long v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_S_BFu1ll { long long v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_S_BFu1s { long long v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_S_BFu31i { long long v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_S_BFu31ll { long long v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_S_BFu32i { long long v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_S_BFu32ll { long long v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_S_BFu33 { long long v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_S_BFu7c { long long v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_S_BFu7i { long long v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_S_BFu7ll { long long v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_S_BFu7s { long long v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_S_BFu8c { long long v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_S_BFu8i { long long v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_S_BFu8ll { long long v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_S_BFu8s { long long v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_S_BFu9i { long long v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_S_BFu9ll { long long v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_S_BFu9s { long long v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_S_C { long long v1; short v2; char v3; };
struct __attribute__((packed)) aL_S_D { long long v1; short v2; double v3; };
struct __attribute__((packed)) aL_S_F { long long v1; short v2; float v3; };
struct __attribute__((packed)) aL_S_I { long long v1; short v2; int v3; };
struct __attribute__((packed)) aL_S_Ip { long long v1; short v2; int * v3; };
struct __attribute__((packed)) aL_S_L { long long v1; short v2; long long v3; };
struct __attribute__((packed)) aL_S_S { long long v1; short v2; short v3; };
struct __attribute__((packed)) aL_S_Uc { long long v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aL_S_Ui { long long v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aL_S_Ul { long long v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aL_S_Us { long long v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aL_S_Vp { long long v1; short v2; void * v3; };
struct __attribute__((packed)) aL_Uc { long long v1; unsigned char v2; };
struct __attribute__((packed)) aL_Uc_BFu15i { long long v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_Uc_BFu15ll { long long v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_Uc_BFu15s { long long v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aL_Uc_BFu16i { long long v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aL_Uc_BFu16ll { long long v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aL_Uc_BFu16s { long long v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aL_Uc_BFu17i { long long v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aL_Uc_BFu17ll { long long v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aL_Uc_BFu1c { long long v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aL_Uc_BFu1i { long long v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aL_Uc_BFu1ll { long long v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aL_Uc_BFu1s { long long v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aL_Uc_BFu31i { long long v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aL_Uc_BFu31ll { long long v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aL_Uc_BFu32i { long long v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aL_Uc_BFu32ll { long long v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aL_Uc_BFu33 { long long v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aL_Uc_BFu7c { long long v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aL_Uc_BFu7i { long long v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aL_Uc_BFu7ll { long long v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aL_Uc_BFu7s { long long v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aL_Uc_BFu8c { long long v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aL_Uc_BFu8i { long long v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aL_Uc_BFu8ll { long long v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aL_Uc_BFu8s { long long v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aL_Uc_BFu9i { long long v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aL_Uc_BFu9ll { long long v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aL_Uc_BFu9s { long long v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aL_Uc_C { long long v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aL_Uc_D { long long v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aL_Uc_F { long long v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aL_Uc_I { long long v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aL_Uc_Ip { long long v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aL_Uc_L { long long v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aL_Uc_S { long long v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aL_Uc_Uc { long long v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aL_Uc_Ui { long long v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aL_Uc_Ul { long long v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aL_Uc_Us { long long v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aL_Uc_Vp { long long v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aL_Ui { long long v1; unsigned int v2; };
struct __attribute__((packed)) aL_Ui_BFu15i { long long v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aL_Ui_BFu15ll { long long v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aL_Ui_BFu15s { long long v1; unsigned int v2; unsigned short v3:15; };


static void Test_aIp_BFu15s_Us()
{
  {
    init_simple_test("aIp_BFu15s_Us");
    static STRUCT_IF_C aIp_BFu15s_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu15s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aIp_BFu15s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aIp_BFu15s_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu15s_Us, aIp_BFu15s_Us)
//============================================================================



static void Test_aIp_BFu15s_Vp()
{
  {
    init_simple_test("aIp_BFu15s_Vp");
    static STRUCT_IF_C aIp_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aIp_BFu15s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, 1, "aIp_BFu15s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 15, hide_ull(1LL<<14), "aIp_BFu15s_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu15s_Vp, aIp_BFu15s_Vp)
//============================================================================



static void Test_aIp_BFu16i()
{
  {
    init_simple_test("aIp_BFu16i");
    static STRUCT_IF_C aIp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i, aIp_BFu16i)
//============================================================================



static void Test_aIp_BFu16i_BFu15i()
{
  {
    init_simple_test("aIp_BFu16i_BFu15i");
    static STRUCT_IF_C aIp_BFu16i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aIp_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aIp_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu15i, aIp_BFu16i_BFu15i)
//============================================================================



static void Test_aIp_BFu16i_BFu15ll()
{
  {
    init_simple_test("aIp_BFu16i_BFu15ll");
    static STRUCT_IF_C aIp_BFu16i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aIp_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aIp_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu15ll, aIp_BFu16i_BFu15ll)
//============================================================================



static void Test_aIp_BFu16i_BFu15s()
{
  {
    init_simple_test("aIp_BFu16i_BFu15s");
    static STRUCT_IF_C aIp_BFu16i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aIp_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aIp_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu15s, aIp_BFu16i_BFu15s)
//============================================================================



static void Test_aIp_BFu16i_BFu16i()
{
  {
    init_simple_test("aIp_BFu16i_BFu16i");
    static STRUCT_IF_C aIp_BFu16i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aIp_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu16i, aIp_BFu16i_BFu16i)
//============================================================================



static void Test_aIp_BFu16i_BFu16ll()
{
  {
    init_simple_test("aIp_BFu16i_BFu16ll");
    static STRUCT_IF_C aIp_BFu16i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aIp_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu16ll, aIp_BFu16i_BFu16ll)
//============================================================================



static void Test_aIp_BFu16i_BFu16s()
{
  {
    init_simple_test("aIp_BFu16i_BFu16s");
    static STRUCT_IF_C aIp_BFu16i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aIp_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu16s, aIp_BFu16i_BFu16s)
//============================================================================



static void Test_aIp_BFu16i_BFu17i()
{
  {
    init_simple_test("aIp_BFu16i_BFu17i");
    static STRUCT_IF_C aIp_BFu16i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu16i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "aIp_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "aIp_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu17i, aIp_BFu16i_BFu17i)
//============================================================================



static void Test_aIp_BFu16i_BFu17ll()
{
  {
    init_simple_test("aIp_BFu16i_BFu17ll");
    static STRUCT_IF_C aIp_BFu16i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu16i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "aIp_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "aIp_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu17ll, aIp_BFu16i_BFu17ll)
//============================================================================



static void Test_aIp_BFu16i_BFu1c()
{
  {
    init_simple_test("aIp_BFu16i_BFu1c");
    static STRUCT_IF_C aIp_BFu16i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aIp_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu1c, aIp_BFu16i_BFu1c)
//============================================================================



static void Test_aIp_BFu16i_BFu1i()
{
  {
    init_simple_test("aIp_BFu16i_BFu1i");
    static STRUCT_IF_C aIp_BFu16i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aIp_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu1i, aIp_BFu16i_BFu1i)
//============================================================================



static void Test_aIp_BFu16i_BFu1ll()
{
  {
    init_simple_test("aIp_BFu16i_BFu1ll");
    static STRUCT_IF_C aIp_BFu16i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aIp_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu1ll, aIp_BFu16i_BFu1ll)
//============================================================================



static void Test_aIp_BFu16i_BFu1s()
{
  {
    init_simple_test("aIp_BFu16i_BFu1s");
    static STRUCT_IF_C aIp_BFu16i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aIp_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu1s, aIp_BFu16i_BFu1s)
//============================================================================



static void Test_aIp_BFu16i_BFu31i()
{
  {
    init_simple_test("aIp_BFu16i_BFu31i");
    static STRUCT_IF_C aIp_BFu16i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "aIp_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "aIp_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu31i, aIp_BFu16i_BFu31i)
//============================================================================



static void Test_aIp_BFu16i_BFu31ll()
{
  {
    init_simple_test("aIp_BFu16i_BFu31ll");
    static STRUCT_IF_C aIp_BFu16i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "aIp_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "aIp_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu31ll, aIp_BFu16i_BFu31ll)
//============================================================================



static void Test_aIp_BFu16i_BFu32i()
{
  {
    init_simple_test("aIp_BFu16i_BFu32i");
    static STRUCT_IF_C aIp_BFu16i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "aIp_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "aIp_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu32i, aIp_BFu16i_BFu32i)
//============================================================================



static void Test_aIp_BFu16i_BFu32ll()
{
  {
    init_simple_test("aIp_BFu16i_BFu32ll");
    static STRUCT_IF_C aIp_BFu16i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "aIp_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "aIp_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu32ll, aIp_BFu16i_BFu32ll)
//============================================================================



static void Test_aIp_BFu16i_BFu33()
{
  {
    init_simple_test("aIp_BFu16i_BFu33");
    static STRUCT_IF_C aIp_BFu16i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu16i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "aIp_BFu16i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "aIp_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu33, aIp_BFu16i_BFu33)
//============================================================================



static void Test_aIp_BFu16i_BFu7c()
{
  {
    init_simple_test("aIp_BFu16i_BFu7c");
    static STRUCT_IF_C aIp_BFu16i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aIp_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aIp_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu7c, aIp_BFu16i_BFu7c)
//============================================================================



static void Test_aIp_BFu16i_BFu7i()
{
  {
    init_simple_test("aIp_BFu16i_BFu7i");
    static STRUCT_IF_C aIp_BFu16i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aIp_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aIp_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu7i, aIp_BFu16i_BFu7i)
//============================================================================



static void Test_aIp_BFu16i_BFu7ll()
{
  {
    init_simple_test("aIp_BFu16i_BFu7ll");
    static STRUCT_IF_C aIp_BFu16i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aIp_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aIp_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu7ll, aIp_BFu16i_BFu7ll)
//============================================================================



static void Test_aIp_BFu16i_BFu7s()
{
  {
    init_simple_test("aIp_BFu16i_BFu7s");
    static STRUCT_IF_C aIp_BFu16i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aIp_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aIp_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu7s, aIp_BFu16i_BFu7s)
//============================================================================



static void Test_aIp_BFu16i_BFu8c()
{
  {
    init_simple_test("aIp_BFu16i_BFu8c");
    static STRUCT_IF_C aIp_BFu16i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aIp_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aIp_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu8c, aIp_BFu16i_BFu8c)
//============================================================================



static void Test_aIp_BFu16i_BFu8i()
{
  {
    init_simple_test("aIp_BFu16i_BFu8i");
    static STRUCT_IF_C aIp_BFu16i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aIp_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aIp_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu8i, aIp_BFu16i_BFu8i)
//============================================================================



static void Test_aIp_BFu16i_BFu8ll()
{
  {
    init_simple_test("aIp_BFu16i_BFu8ll");
    static STRUCT_IF_C aIp_BFu16i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aIp_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aIp_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu8ll, aIp_BFu16i_BFu8ll)
//============================================================================



static void Test_aIp_BFu16i_BFu8s()
{
  {
    init_simple_test("aIp_BFu16i_BFu8s");
    static STRUCT_IF_C aIp_BFu16i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aIp_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aIp_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu8s, aIp_BFu16i_BFu8s)
//============================================================================



static void Test_aIp_BFu16i_BFu9i()
{
  {
    init_simple_test("aIp_BFu16i_BFu9i");
    static STRUCT_IF_C aIp_BFu16i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aIp_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aIp_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu9i, aIp_BFu16i_BFu9i)
//============================================================================



static void Test_aIp_BFu16i_BFu9ll()
{
  {
    init_simple_test("aIp_BFu16i_BFu9ll");
    static STRUCT_IF_C aIp_BFu16i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aIp_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aIp_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu9ll, aIp_BFu16i_BFu9ll)
//============================================================================



static void Test_aIp_BFu16i_BFu9s()
{
  {
    init_simple_test("aIp_BFu16i_BFu9s");
    static STRUCT_IF_C aIp_BFu16i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aIp_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aIp_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_BFu9s, aIp_BFu16i_BFu9s)
//============================================================================



static void Test_aIp_BFu16i_C()
{
  {
    init_simple_test("aIp_BFu16i_C");
    static STRUCT_IF_C aIp_BFu16i_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_C, aIp_BFu16i_C)
//============================================================================



static void Test_aIp_BFu16i_D()
{
  {
    init_simple_test("aIp_BFu16i_D");
    static STRUCT_IF_C aIp_BFu16i_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aIp_BFu16i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_D");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_D, aIp_BFu16i_D)
//============================================================================



static void Test_aIp_BFu16i_F()
{
  {
    init_simple_test("aIp_BFu16i_F");
    static STRUCT_IF_C aIp_BFu16i_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_F");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_F, aIp_BFu16i_F)
//============================================================================



static void Test_aIp_BFu16i_I()
{
  {
    init_simple_test("aIp_BFu16i_I");
    static STRUCT_IF_C aIp_BFu16i_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_I");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_I, aIp_BFu16i_I)
//============================================================================



static void Test_aIp_BFu16i_Ip()
{
  {
    init_simple_test("aIp_BFu16i_Ip");
    static STRUCT_IF_C aIp_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aIp_BFu16i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_Ip");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_Ip, aIp_BFu16i_Ip)
//============================================================================



static void Test_aIp_BFu16i_L()
{
  {
    init_simple_test("aIp_BFu16i_L");
    static STRUCT_IF_C aIp_BFu16i_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aIp_BFu16i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_L");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_L, aIp_BFu16i_L)
//============================================================================



static void Test_aIp_BFu16i_S()
{
  {
    init_simple_test("aIp_BFu16i_S");
    static STRUCT_IF_C aIp_BFu16i_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_S, aIp_BFu16i_S)
//============================================================================



static void Test_aIp_BFu16i_Uc()
{
  {
    init_simple_test("aIp_BFu16i_Uc");
    static STRUCT_IF_C aIp_BFu16i_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_Uc, aIp_BFu16i_Uc)
//============================================================================



static void Test_aIp_BFu16i_Ui()
{
  {
    init_simple_test("aIp_BFu16i_Ui");
    static STRUCT_IF_C aIp_BFu16i_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_Ui");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_Ui, aIp_BFu16i_Ui)
//============================================================================



static void Test_aIp_BFu16i_Ul()
{
  {
    init_simple_test("aIp_BFu16i_Ul");
    static STRUCT_IF_C aIp_BFu16i_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aIp_BFu16i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_Ul");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_Ul, aIp_BFu16i_Ul)
//============================================================================



static void Test_aIp_BFu16i_Us()
{
  {
    init_simple_test("aIp_BFu16i_Us");
    static STRUCT_IF_C aIp_BFu16i_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_Us, aIp_BFu16i_Us)
//============================================================================



static void Test_aIp_BFu16i_Vp()
{
  {
    init_simple_test("aIp_BFu16i_Vp");
    static STRUCT_IF_C aIp_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aIp_BFu16i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16i_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16i_Vp, aIp_BFu16i_Vp)
//============================================================================



static void Test_aIp_BFu16ll()
{
  {
    init_simple_test("aIp_BFu16ll");
    static STRUCT_IF_C aIp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll, aIp_BFu16ll)
//============================================================================



static void Test_aIp_BFu16ll_BFu15i()
{
  {
    init_simple_test("aIp_BFu16ll_BFu15i");
    static STRUCT_IF_C aIp_BFu16ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aIp_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aIp_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu15i, aIp_BFu16ll_BFu15i)
//============================================================================



static void Test_aIp_BFu16ll_BFu15ll()
{
  {
    init_simple_test("aIp_BFu16ll_BFu15ll");
    static STRUCT_IF_C aIp_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aIp_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aIp_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu15ll, aIp_BFu16ll_BFu15ll)
//============================================================================



static void Test_aIp_BFu16ll_BFu15s()
{
  {
    init_simple_test("aIp_BFu16ll_BFu15s");
    static STRUCT_IF_C aIp_BFu16ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aIp_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aIp_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu15s, aIp_BFu16ll_BFu15s)
//============================================================================



static void Test_aIp_BFu16ll_BFu16i()
{
  {
    init_simple_test("aIp_BFu16ll_BFu16i");
    static STRUCT_IF_C aIp_BFu16ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aIp_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu16i, aIp_BFu16ll_BFu16i)
//============================================================================



static void Test_aIp_BFu16ll_BFu16ll()
{
  {
    init_simple_test("aIp_BFu16ll_BFu16ll");
    static STRUCT_IF_C aIp_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aIp_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu16ll, aIp_BFu16ll_BFu16ll)
//============================================================================



static void Test_aIp_BFu16ll_BFu16s()
{
  {
    init_simple_test("aIp_BFu16ll_BFu16s");
    static STRUCT_IF_C aIp_BFu16ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aIp_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu16s, aIp_BFu16ll_BFu16s)
//============================================================================



static void Test_aIp_BFu16ll_BFu17i()
{
  {
    init_simple_test("aIp_BFu16ll_BFu17i");
    static STRUCT_IF_C aIp_BFu16ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu16ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "aIp_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "aIp_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu17i, aIp_BFu16ll_BFu17i)
//============================================================================



static void Test_aIp_BFu16ll_BFu17ll()
{
  {
    init_simple_test("aIp_BFu16ll_BFu17ll");
    static STRUCT_IF_C aIp_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "aIp_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "aIp_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu17ll, aIp_BFu16ll_BFu17ll)
//============================================================================



static void Test_aIp_BFu16ll_BFu1c()
{
  {
    init_simple_test("aIp_BFu16ll_BFu1c");
    static STRUCT_IF_C aIp_BFu16ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aIp_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu1c, aIp_BFu16ll_BFu1c)
//============================================================================



static void Test_aIp_BFu16ll_BFu1i()
{
  {
    init_simple_test("aIp_BFu16ll_BFu1i");
    static STRUCT_IF_C aIp_BFu16ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aIp_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu1i, aIp_BFu16ll_BFu1i)
//============================================================================



static void Test_aIp_BFu16ll_BFu1ll()
{
  {
    init_simple_test("aIp_BFu16ll_BFu1ll");
    static STRUCT_IF_C aIp_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aIp_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu1ll, aIp_BFu16ll_BFu1ll)
//============================================================================



static void Test_aIp_BFu16ll_BFu1s()
{
  {
    init_simple_test("aIp_BFu16ll_BFu1s");
    static STRUCT_IF_C aIp_BFu16ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aIp_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu1s, aIp_BFu16ll_BFu1s)
//============================================================================



static void Test_aIp_BFu16ll_BFu31i()
{
  {
    init_simple_test("aIp_BFu16ll_BFu31i");
    static STRUCT_IF_C aIp_BFu16ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "aIp_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "aIp_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu31i, aIp_BFu16ll_BFu31i)
//============================================================================



static void Test_aIp_BFu16ll_BFu31ll()
{
  {
    init_simple_test("aIp_BFu16ll_BFu31ll");
    static STRUCT_IF_C aIp_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "aIp_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "aIp_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu31ll, aIp_BFu16ll_BFu31ll)
//============================================================================



static void Test_aIp_BFu16ll_BFu32i()
{
  {
    init_simple_test("aIp_BFu16ll_BFu32i");
    static STRUCT_IF_C aIp_BFu16ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "aIp_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "aIp_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu32i, aIp_BFu16ll_BFu32i)
//============================================================================



static void Test_aIp_BFu16ll_BFu32ll()
{
  {
    init_simple_test("aIp_BFu16ll_BFu32ll");
    static STRUCT_IF_C aIp_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "aIp_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "aIp_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu32ll, aIp_BFu16ll_BFu32ll)
//============================================================================



static void Test_aIp_BFu16ll_BFu33()
{
  {
    init_simple_test("aIp_BFu16ll_BFu33");
    static STRUCT_IF_C aIp_BFu16ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu16ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "aIp_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "aIp_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu33, aIp_BFu16ll_BFu33)
//============================================================================



static void Test_aIp_BFu16ll_BFu7c()
{
  {
    init_simple_test("aIp_BFu16ll_BFu7c");
    static STRUCT_IF_C aIp_BFu16ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aIp_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aIp_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu7c, aIp_BFu16ll_BFu7c)
//============================================================================



static void Test_aIp_BFu16ll_BFu7i()
{
  {
    init_simple_test("aIp_BFu16ll_BFu7i");
    static STRUCT_IF_C aIp_BFu16ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aIp_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aIp_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu7i, aIp_BFu16ll_BFu7i)
//============================================================================



static void Test_aIp_BFu16ll_BFu7ll()
{
  {
    init_simple_test("aIp_BFu16ll_BFu7ll");
    static STRUCT_IF_C aIp_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aIp_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aIp_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu7ll, aIp_BFu16ll_BFu7ll)
//============================================================================



static void Test_aIp_BFu16ll_BFu7s()
{
  {
    init_simple_test("aIp_BFu16ll_BFu7s");
    static STRUCT_IF_C aIp_BFu16ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aIp_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aIp_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu7s, aIp_BFu16ll_BFu7s)
//============================================================================



static void Test_aIp_BFu16ll_BFu8c()
{
  {
    init_simple_test("aIp_BFu16ll_BFu8c");
    static STRUCT_IF_C aIp_BFu16ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aIp_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aIp_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu8c, aIp_BFu16ll_BFu8c)
//============================================================================



static void Test_aIp_BFu16ll_BFu8i()
{
  {
    init_simple_test("aIp_BFu16ll_BFu8i");
    static STRUCT_IF_C aIp_BFu16ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aIp_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aIp_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu8i, aIp_BFu16ll_BFu8i)
//============================================================================



static void Test_aIp_BFu16ll_BFu8ll()
{
  {
    init_simple_test("aIp_BFu16ll_BFu8ll");
    static STRUCT_IF_C aIp_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aIp_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aIp_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu8ll, aIp_BFu16ll_BFu8ll)
//============================================================================



static void Test_aIp_BFu16ll_BFu8s()
{
  {
    init_simple_test("aIp_BFu16ll_BFu8s");
    static STRUCT_IF_C aIp_BFu16ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aIp_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aIp_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu8s, aIp_BFu16ll_BFu8s)
//============================================================================



static void Test_aIp_BFu16ll_BFu9i()
{
  {
    init_simple_test("aIp_BFu16ll_BFu9i");
    static STRUCT_IF_C aIp_BFu16ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aIp_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aIp_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu9i, aIp_BFu16ll_BFu9i)
//============================================================================



static void Test_aIp_BFu16ll_BFu9ll()
{
  {
    init_simple_test("aIp_BFu16ll_BFu9ll");
    static STRUCT_IF_C aIp_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aIp_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aIp_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu9ll, aIp_BFu16ll_BFu9ll)
//============================================================================



static void Test_aIp_BFu16ll_BFu9s()
{
  {
    init_simple_test("aIp_BFu16ll_BFu9s");
    static STRUCT_IF_C aIp_BFu16ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aIp_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aIp_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_BFu9s, aIp_BFu16ll_BFu9s)
//============================================================================



static void Test_aIp_BFu16ll_C()
{
  {
    init_simple_test("aIp_BFu16ll_C");
    static STRUCT_IF_C aIp_BFu16ll_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_C, aIp_BFu16ll_C)
//============================================================================



static void Test_aIp_BFu16ll_D()
{
  {
    init_simple_test("aIp_BFu16ll_D");
    static STRUCT_IF_C aIp_BFu16ll_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aIp_BFu16ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_D");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_D, aIp_BFu16ll_D)
//============================================================================



static void Test_aIp_BFu16ll_F()
{
  {
    init_simple_test("aIp_BFu16ll_F");
    static STRUCT_IF_C aIp_BFu16ll_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_F");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_F, aIp_BFu16ll_F)
//============================================================================



static void Test_aIp_BFu16ll_I()
{
  {
    init_simple_test("aIp_BFu16ll_I");
    static STRUCT_IF_C aIp_BFu16ll_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_I");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_I, aIp_BFu16ll_I)
//============================================================================



static void Test_aIp_BFu16ll_Ip()
{
  {
    init_simple_test("aIp_BFu16ll_Ip");
    static STRUCT_IF_C aIp_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aIp_BFu16ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_Ip");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_Ip, aIp_BFu16ll_Ip)
//============================================================================



static void Test_aIp_BFu16ll_L()
{
  {
    init_simple_test("aIp_BFu16ll_L");
    static STRUCT_IF_C aIp_BFu16ll_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aIp_BFu16ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_L");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_L, aIp_BFu16ll_L)
//============================================================================



static void Test_aIp_BFu16ll_S()
{
  {
    init_simple_test("aIp_BFu16ll_S");
    static STRUCT_IF_C aIp_BFu16ll_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_S, aIp_BFu16ll_S)
//============================================================================



static void Test_aIp_BFu16ll_Uc()
{
  {
    init_simple_test("aIp_BFu16ll_Uc");
    static STRUCT_IF_C aIp_BFu16ll_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_Uc, aIp_BFu16ll_Uc)
//============================================================================



static void Test_aIp_BFu16ll_Ui()
{
  {
    init_simple_test("aIp_BFu16ll_Ui");
    static STRUCT_IF_C aIp_BFu16ll_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_Ui");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_Ui, aIp_BFu16ll_Ui)
//============================================================================



static void Test_aIp_BFu16ll_Ul()
{
  {
    init_simple_test("aIp_BFu16ll_Ul");
    static STRUCT_IF_C aIp_BFu16ll_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aIp_BFu16ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_Ul");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_Ul, aIp_BFu16ll_Ul)
//============================================================================



static void Test_aIp_BFu16ll_Us()
{
  {
    init_simple_test("aIp_BFu16ll_Us");
    static STRUCT_IF_C aIp_BFu16ll_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_Us, aIp_BFu16ll_Us)
//============================================================================



static void Test_aIp_BFu16ll_Vp()
{
  {
    init_simple_test("aIp_BFu16ll_Vp");
    static STRUCT_IF_C aIp_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aIp_BFu16ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16ll_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16ll_Vp, aIp_BFu16ll_Vp)
//============================================================================



static void Test_aIp_BFu16s()
{
  {
    init_simple_test("aIp_BFu16s");
    static STRUCT_IF_C aIp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s, aIp_BFu16s)
//============================================================================



static void Test_aIp_BFu16s_BFu15i()
{
  {
    init_simple_test("aIp_BFu16s_BFu15i");
    static STRUCT_IF_C aIp_BFu16s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aIp_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aIp_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu15i, aIp_BFu16s_BFu15i)
//============================================================================



static void Test_aIp_BFu16s_BFu15ll()
{
  {
    init_simple_test("aIp_BFu16s_BFu15ll");
    static STRUCT_IF_C aIp_BFu16s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aIp_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aIp_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu15ll, aIp_BFu16s_BFu15ll)
//============================================================================



static void Test_aIp_BFu16s_BFu15s()
{
  {
    init_simple_test("aIp_BFu16s_BFu15s");
    static STRUCT_IF_C aIp_BFu16s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, 1, "aIp_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 15, hide_ull(1LL<<14), "aIp_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu15s, aIp_BFu16s_BFu15s)
//============================================================================



static void Test_aIp_BFu16s_BFu16i()
{
  {
    init_simple_test("aIp_BFu16s_BFu16i");
    static STRUCT_IF_C aIp_BFu16s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aIp_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu16i, aIp_BFu16s_BFu16i)
//============================================================================



static void Test_aIp_BFu16s_BFu16ll()
{
  {
    init_simple_test("aIp_BFu16s_BFu16ll");
    static STRUCT_IF_C aIp_BFu16s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aIp_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu16ll, aIp_BFu16s_BFu16ll)
//============================================================================



static void Test_aIp_BFu16s_BFu16s()
{
  {
    init_simple_test("aIp_BFu16s_BFu16s");
    static STRUCT_IF_C aIp_BFu16s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, 1, "aIp_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu16s, aIp_BFu16s_BFu16s)
//============================================================================



static void Test_aIp_BFu16s_BFu17i()
{
  {
    init_simple_test("aIp_BFu16s_BFu17i");
    static STRUCT_IF_C aIp_BFu16s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu16s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "aIp_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "aIp_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu17i, aIp_BFu16s_BFu17i)
//============================================================================



static void Test_aIp_BFu16s_BFu17ll()
{
  {
    init_simple_test("aIp_BFu16s_BFu17ll");
    static STRUCT_IF_C aIp_BFu16s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu16s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, 1, "aIp_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 17, hide_ull(1LL<<16), "aIp_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu17ll, aIp_BFu16s_BFu17ll)
//============================================================================



static void Test_aIp_BFu16s_BFu1c()
{
  {
    init_simple_test("aIp_BFu16s_BFu1c");
    static STRUCT_IF_C aIp_BFu16s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aIp_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu1c, aIp_BFu16s_BFu1c)
//============================================================================



static void Test_aIp_BFu16s_BFu1i()
{
  {
    init_simple_test("aIp_BFu16s_BFu1i");
    static STRUCT_IF_C aIp_BFu16s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aIp_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu1i, aIp_BFu16s_BFu1i)
//============================================================================



static void Test_aIp_BFu16s_BFu1ll()
{
  {
    init_simple_test("aIp_BFu16s_BFu1ll");
    static STRUCT_IF_C aIp_BFu16s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aIp_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu1ll, aIp_BFu16s_BFu1ll)
//============================================================================



static void Test_aIp_BFu16s_BFu1s()
{
  {
    init_simple_test("aIp_BFu16s_BFu1s");
    static STRUCT_IF_C aIp_BFu16s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 1, 1, "aIp_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu1s, aIp_BFu16s_BFu1s)
//============================================================================



static void Test_aIp_BFu16s_BFu31i()
{
  {
    init_simple_test("aIp_BFu16s_BFu31i");
    static STRUCT_IF_C aIp_BFu16s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "aIp_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "aIp_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu31i, aIp_BFu16s_BFu31i)
//============================================================================



static void Test_aIp_BFu16s_BFu31ll()
{
  {
    init_simple_test("aIp_BFu16s_BFu31ll");
    static STRUCT_IF_C aIp_BFu16s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, 1, "aIp_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 31, hide_ull(1LL<<30), "aIp_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu31ll, aIp_BFu16s_BFu31ll)
//============================================================================



static void Test_aIp_BFu16s_BFu32i()
{
  {
    init_simple_test("aIp_BFu16s_BFu32i");
    static STRUCT_IF_C aIp_BFu16s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "aIp_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "aIp_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu32i, aIp_BFu16s_BFu32i)
//============================================================================



static void Test_aIp_BFu16s_BFu32ll()
{
  {
    init_simple_test("aIp_BFu16s_BFu32ll");
    static STRUCT_IF_C aIp_BFu16s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, 1, "aIp_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 32, hide_ull(1LL<<31), "aIp_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu32ll, aIp_BFu16s_BFu32ll)
//============================================================================



static void Test_aIp_BFu16s_BFu33()
{
  {
    init_simple_test("aIp_BFu16s_BFu33");
    static STRUCT_IF_C aIp_BFu16s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu16s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, 1, "aIp_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 33, hide_ull(1LL<<32), "aIp_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu33, aIp_BFu16s_BFu33)
//============================================================================



static void Test_aIp_BFu16s_BFu7c()
{
  {
    init_simple_test("aIp_BFu16s_BFu7c");
    static STRUCT_IF_C aIp_BFu16s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aIp_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aIp_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu7c, aIp_BFu16s_BFu7c)
//============================================================================



static void Test_aIp_BFu16s_BFu7i()
{
  {
    init_simple_test("aIp_BFu16s_BFu7i");
    static STRUCT_IF_C aIp_BFu16s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aIp_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aIp_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu7i, aIp_BFu16s_BFu7i)
//============================================================================



static void Test_aIp_BFu16s_BFu7ll()
{
  {
    init_simple_test("aIp_BFu16s_BFu7ll");
    static STRUCT_IF_C aIp_BFu16s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aIp_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aIp_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu7ll, aIp_BFu16s_BFu7ll)
//============================================================================



static void Test_aIp_BFu16s_BFu7s()
{
  {
    init_simple_test("aIp_BFu16s_BFu7s");
    static STRUCT_IF_C aIp_BFu16s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, 1, "aIp_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 7, hide_ull(1LL<<6), "aIp_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu7s, aIp_BFu16s_BFu7s)
//============================================================================



static void Test_aIp_BFu16s_BFu8c()
{
  {
    init_simple_test("aIp_BFu16s_BFu8c");
    static STRUCT_IF_C aIp_BFu16s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aIp_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aIp_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu8c, aIp_BFu16s_BFu8c)
//============================================================================



static void Test_aIp_BFu16s_BFu8i()
{
  {
    init_simple_test("aIp_BFu16s_BFu8i");
    static STRUCT_IF_C aIp_BFu16s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aIp_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aIp_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu8i, aIp_BFu16s_BFu8i)
//============================================================================



static void Test_aIp_BFu16s_BFu8ll()
{
  {
    init_simple_test("aIp_BFu16s_BFu8ll");
    static STRUCT_IF_C aIp_BFu16s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aIp_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aIp_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu8ll, aIp_BFu16s_BFu8ll)
//============================================================================



static void Test_aIp_BFu16s_BFu8s()
{
  {
    init_simple_test("aIp_BFu16s_BFu8s");
    static STRUCT_IF_C aIp_BFu16s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, 1, "aIp_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 8, hide_ull(1LL<<7), "aIp_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu8s, aIp_BFu16s_BFu8s)
//============================================================================



static void Test_aIp_BFu16s_BFu9i()
{
  {
    init_simple_test("aIp_BFu16s_BFu9i");
    static STRUCT_IF_C aIp_BFu16s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aIp_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aIp_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu9i, aIp_BFu16s_BFu9i)
//============================================================================



static void Test_aIp_BFu16s_BFu9ll()
{
  {
    init_simple_test("aIp_BFu16s_BFu9ll");
    static STRUCT_IF_C aIp_BFu16s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aIp_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aIp_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu9ll, aIp_BFu16s_BFu9ll)
//============================================================================



static void Test_aIp_BFu16s_BFu9s()
{
  {
    init_simple_test("aIp_BFu16s_BFu9s");
    static STRUCT_IF_C aIp_BFu16s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, 1, "aIp_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 0, 9, hide_ull(1LL<<8), "aIp_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_BFu9s, aIp_BFu16s_BFu9s)
//============================================================================



static void Test_aIp_BFu16s_C()
{
  {
    init_simple_test("aIp_BFu16s_C");
    static STRUCT_IF_C aIp_BFu16s_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_C, aIp_BFu16s_C)
//============================================================================



static void Test_aIp_BFu16s_D()
{
  {
    init_simple_test("aIp_BFu16s_D");
    static STRUCT_IF_C aIp_BFu16s_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aIp_BFu16s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_D");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_D, aIp_BFu16s_D)
//============================================================================



static void Test_aIp_BFu16s_F()
{
  {
    init_simple_test("aIp_BFu16s_F");
    static STRUCT_IF_C aIp_BFu16s_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_F");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_F, aIp_BFu16s_F)
//============================================================================



static void Test_aIp_BFu16s_I()
{
  {
    init_simple_test("aIp_BFu16s_I");
    static STRUCT_IF_C aIp_BFu16s_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_I");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_I, aIp_BFu16s_I)
//============================================================================



static void Test_aIp_BFu16s_Ip()
{
  {
    init_simple_test("aIp_BFu16s_Ip");
    static STRUCT_IF_C aIp_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aIp_BFu16s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_Ip");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_Ip, aIp_BFu16s_Ip)
//============================================================================



static void Test_aIp_BFu16s_L()
{
  {
    init_simple_test("aIp_BFu16s_L");
    static STRUCT_IF_C aIp_BFu16s_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aIp_BFu16s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_L");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_L, aIp_BFu16s_L)
//============================================================================



static void Test_aIp_BFu16s_S()
{
  {
    init_simple_test("aIp_BFu16s_S");
    static STRUCT_IF_C aIp_BFu16s_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_S, aIp_BFu16s_S)
//============================================================================



static void Test_aIp_BFu16s_Uc()
{
  {
    init_simple_test("aIp_BFu16s_Uc");
    static STRUCT_IF_C aIp_BFu16s_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu16s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_Uc, aIp_BFu16s_Uc)
//============================================================================



static void Test_aIp_BFu16s_Ui()
{
  {
    init_simple_test("aIp_BFu16s_Ui");
    static STRUCT_IF_C aIp_BFu16s_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu16s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_Ui");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_Ui, aIp_BFu16s_Ui)
//============================================================================



static void Test_aIp_BFu16s_Ul()
{
  {
    init_simple_test("aIp_BFu16s_Ul");
    static STRUCT_IF_C aIp_BFu16s_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aIp_BFu16s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_Ul");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_Ul, aIp_BFu16s_Ul)
//============================================================================



static void Test_aIp_BFu16s_Us()
{
  {
    init_simple_test("aIp_BFu16s_Us");
    static STRUCT_IF_C aIp_BFu16s_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu16s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_Us, aIp_BFu16s_Us)
//============================================================================



static void Test_aIp_BFu16s_Vp()
{
  {
    init_simple_test("aIp_BFu16s_Vp");
    static STRUCT_IF_C aIp_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aIp_BFu16s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, 1, "aIp_BFu16s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 16, hide_ull(1LL<<15), "aIp_BFu16s_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu16s_Vp, aIp_BFu16s_Vp)
//============================================================================



static void Test_aIp_BFu17i()
{
  {
    init_simple_test("aIp_BFu17i");
    static STRUCT_IF_C aIp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i, aIp_BFu17i)
//============================================================================



static void Test_aIp_BFu17i_BFu15i()
{
  {
    init_simple_test("aIp_BFu17i_BFu15i");
    static STRUCT_IF_C aIp_BFu17i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "aIp_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "aIp_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu15i, aIp_BFu17i_BFu15i)
//============================================================================



static void Test_aIp_BFu17i_BFu15ll()
{
  {
    init_simple_test("aIp_BFu17i_BFu15ll");
    static STRUCT_IF_C aIp_BFu17i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "aIp_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "aIp_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu15ll, aIp_BFu17i_BFu15ll)
//============================================================================



static void Test_aIp_BFu17i_BFu15s()
{
  {
    init_simple_test("aIp_BFu17i_BFu15s");
    static STRUCT_IF_C aIp_BFu17i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "aIp_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "aIp_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu15s, aIp_BFu17i_BFu15s)
//============================================================================



static void Test_aIp_BFu17i_BFu16i()
{
  {
    init_simple_test("aIp_BFu17i_BFu16i");
    static STRUCT_IF_C aIp_BFu17i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, 1, "aIp_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, hide_ull(1LL<<15), "aIp_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu16i, aIp_BFu17i_BFu16i)
//============================================================================



static void Test_aIp_BFu17i_BFu16ll()
{
  {
    init_simple_test("aIp_BFu17i_BFu16ll");
    static STRUCT_IF_C aIp_BFu17i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, 1, "aIp_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, hide_ull(1LL<<15), "aIp_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu16ll, aIp_BFu17i_BFu16ll)
//============================================================================



static void Test_aIp_BFu17i_BFu16s()
{
  {
    init_simple_test("aIp_BFu17i_BFu16s");
    static STRUCT_IF_C aIp_BFu17i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, 1, "aIp_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, hide_ull(1LL<<15), "aIp_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu16s, aIp_BFu17i_BFu16s)
//============================================================================



static void Test_aIp_BFu17i_BFu17i()
{
  {
    init_simple_test("aIp_BFu17i_BFu17i");
    static STRUCT_IF_C aIp_BFu17i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, 1, "aIp_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu17i, aIp_BFu17i_BFu17i)
//============================================================================



static void Test_aIp_BFu17i_BFu17ll()
{
  {
    init_simple_test("aIp_BFu17i_BFu17ll");
    static STRUCT_IF_C aIp_BFu17i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, 1, "aIp_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu17ll, aIp_BFu17i_BFu17ll)
//============================================================================



static void Test_aIp_BFu17i_BFu1c()
{
  {
    init_simple_test("aIp_BFu17i_BFu1c");
    static STRUCT_IF_C aIp_BFu17i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "aIp_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu1c, aIp_BFu17i_BFu1c)
//============================================================================



static void Test_aIp_BFu17i_BFu1i()
{
  {
    init_simple_test("aIp_BFu17i_BFu1i");
    static STRUCT_IF_C aIp_BFu17i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "aIp_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu1i, aIp_BFu17i_BFu1i)
//============================================================================



static void Test_aIp_BFu17i_BFu1ll()
{
  {
    init_simple_test("aIp_BFu17i_BFu1ll");
    static STRUCT_IF_C aIp_BFu17i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "aIp_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu1ll, aIp_BFu17i_BFu1ll)
//============================================================================



static void Test_aIp_BFu17i_BFu1s()
{
  {
    init_simple_test("aIp_BFu17i_BFu1s");
    static STRUCT_IF_C aIp_BFu17i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "aIp_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu1s, aIp_BFu17i_BFu1s)
//============================================================================



static void Test_aIp_BFu17i_BFu31i()
{
  {
    init_simple_test("aIp_BFu17i_BFu31i");
    static STRUCT_IF_C aIp_BFu17i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu17i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, 1, "aIp_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, hide_ull(1LL<<30), "aIp_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu31i, aIp_BFu17i_BFu31i)
//============================================================================



static void Test_aIp_BFu17i_BFu31ll()
{
  {
    init_simple_test("aIp_BFu17i_BFu31ll");
    static STRUCT_IF_C aIp_BFu17i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu17i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, 1, "aIp_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, hide_ull(1LL<<30), "aIp_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu31ll, aIp_BFu17i_BFu31ll)
//============================================================================



static void Test_aIp_BFu17i_BFu32i()
{
  {
    init_simple_test("aIp_BFu17i_BFu32i");
    static STRUCT_IF_C aIp_BFu17i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu17i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, 1, "aIp_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, hide_ull(1LL<<31), "aIp_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu32i, aIp_BFu17i_BFu32i)
//============================================================================



static void Test_aIp_BFu17i_BFu32ll()
{
  {
    init_simple_test("aIp_BFu17i_BFu32ll");
    static STRUCT_IF_C aIp_BFu17i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu17i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, 1, "aIp_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, hide_ull(1LL<<31), "aIp_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu32ll, aIp_BFu17i_BFu32ll)
//============================================================================



static void Test_aIp_BFu17i_BFu33()
{
  {
    init_simple_test("aIp_BFu17i_BFu33");
    static STRUCT_IF_C aIp_BFu17i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu17i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 33, 1, "aIp_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 33, hide_ull(1LL<<32), "aIp_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu33, aIp_BFu17i_BFu33)
//============================================================================



static void Test_aIp_BFu17i_BFu7c()
{
  {
    init_simple_test("aIp_BFu17i_BFu7c");
    static STRUCT_IF_C aIp_BFu17i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "aIp_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "aIp_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu7c, aIp_BFu17i_BFu7c)
//============================================================================



static void Test_aIp_BFu17i_BFu7i()
{
  {
    init_simple_test("aIp_BFu17i_BFu7i");
    static STRUCT_IF_C aIp_BFu17i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "aIp_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "aIp_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu7i, aIp_BFu17i_BFu7i)
//============================================================================



static void Test_aIp_BFu17i_BFu7ll()
{
  {
    init_simple_test("aIp_BFu17i_BFu7ll");
    static STRUCT_IF_C aIp_BFu17i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "aIp_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "aIp_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu7ll, aIp_BFu17i_BFu7ll)
//============================================================================



static void Test_aIp_BFu17i_BFu7s()
{
  {
    init_simple_test("aIp_BFu17i_BFu7s");
    static STRUCT_IF_C aIp_BFu17i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "aIp_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "aIp_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu7s, aIp_BFu17i_BFu7s)
//============================================================================



static void Test_aIp_BFu17i_BFu8c()
{
  {
    init_simple_test("aIp_BFu17i_BFu8c");
    static STRUCT_IF_C aIp_BFu17i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "aIp_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "aIp_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu8c, aIp_BFu17i_BFu8c)
//============================================================================



static void Test_aIp_BFu17i_BFu8i()
{
  {
    init_simple_test("aIp_BFu17i_BFu8i");
    static STRUCT_IF_C aIp_BFu17i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "aIp_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "aIp_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu8i, aIp_BFu17i_BFu8i)
//============================================================================



static void Test_aIp_BFu17i_BFu8ll()
{
  {
    init_simple_test("aIp_BFu17i_BFu8ll");
    static STRUCT_IF_C aIp_BFu17i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "aIp_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "aIp_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu8ll, aIp_BFu17i_BFu8ll)
//============================================================================



static void Test_aIp_BFu17i_BFu8s()
{
  {
    init_simple_test("aIp_BFu17i_BFu8s");
    static STRUCT_IF_C aIp_BFu17i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "aIp_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "aIp_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu8s, aIp_BFu17i_BFu8s)
//============================================================================



static void Test_aIp_BFu17i_BFu9i()
{
  {
    init_simple_test("aIp_BFu17i_BFu9i");
    static STRUCT_IF_C aIp_BFu17i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "aIp_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "aIp_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu9i, aIp_BFu17i_BFu9i)
//============================================================================



static void Test_aIp_BFu17i_BFu9ll()
{
  {
    init_simple_test("aIp_BFu17i_BFu9ll");
    static STRUCT_IF_C aIp_BFu17i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "aIp_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "aIp_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu9ll, aIp_BFu17i_BFu9ll)
//============================================================================



static void Test_aIp_BFu17i_BFu9s()
{
  {
    init_simple_test("aIp_BFu17i_BFu9s");
    static STRUCT_IF_C aIp_BFu17i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "aIp_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "aIp_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_BFu9s, aIp_BFu17i_BFu9s)
//============================================================================



static void Test_aIp_BFu17i_C()
{
  {
    init_simple_test("aIp_BFu17i_C");
    static STRUCT_IF_C aIp_BFu17i_C lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_C");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_C, aIp_BFu17i_C)
//============================================================================



static void Test_aIp_BFu17i_D()
{
  {
    init_simple_test("aIp_BFu17i_D");
    static STRUCT_IF_C aIp_BFu17i_D lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aIp_BFu17i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_D");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_D, aIp_BFu17i_D)
//============================================================================



static void Test_aIp_BFu17i_F()
{
  {
    init_simple_test("aIp_BFu17i_F");
    static STRUCT_IF_C aIp_BFu17i_F lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu17i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_F");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_F, aIp_BFu17i_F)
//============================================================================



static void Test_aIp_BFu17i_I()
{
  {
    init_simple_test("aIp_BFu17i_I");
    static STRUCT_IF_C aIp_BFu17i_I lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu17i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_I");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_I, aIp_BFu17i_I)
//============================================================================



static void Test_aIp_BFu17i_Ip()
{
  {
    init_simple_test("aIp_BFu17i_Ip");
    static STRUCT_IF_C aIp_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(19,11), "sizeof(aIp_BFu17i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_Ip");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_Ip, aIp_BFu17i_Ip)
//============================================================================



static void Test_aIp_BFu17i_L()
{
  {
    init_simple_test("aIp_BFu17i_L");
    static STRUCT_IF_C aIp_BFu17i_L lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aIp_BFu17i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_L");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_L, aIp_BFu17i_L)
//============================================================================



static void Test_aIp_BFu17i_S()
{
  {
    init_simple_test("aIp_BFu17i_S");
    static STRUCT_IF_C aIp_BFu17i_S lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_S");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_S, aIp_BFu17i_S)
//============================================================================



static void Test_aIp_BFu17i_Uc()
{
  {
    init_simple_test("aIp_BFu17i_Uc");
    static STRUCT_IF_C aIp_BFu17i_Uc lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_Uc");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_Uc, aIp_BFu17i_Uc)
//============================================================================



static void Test_aIp_BFu17i_Ui()
{
  {
    init_simple_test("aIp_BFu17i_Ui");
    static STRUCT_IF_C aIp_BFu17i_Ui lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu17i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_Ui");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_Ui, aIp_BFu17i_Ui)
//============================================================================



static void Test_aIp_BFu17i_Ul()
{
  {
    init_simple_test("aIp_BFu17i_Ul");
    static STRUCT_IF_C aIp_BFu17i_Ul lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aIp_BFu17i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_Ul");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_Ul, aIp_BFu17i_Ul)
//============================================================================



static void Test_aIp_BFu17i_Us()
{
  {
    init_simple_test("aIp_BFu17i_Us");
    static STRUCT_IF_C aIp_BFu17i_Us lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_Us");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_Us, aIp_BFu17i_Us)
//============================================================================



static void Test_aIp_BFu17i_Vp()
{
  {
    init_simple_test("aIp_BFu17i_Vp");
    static STRUCT_IF_C aIp_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(19,11), "sizeof(aIp_BFu17i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17i_Vp");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17i_Vp, aIp_BFu17i_Vp)
//============================================================================



static void Test_aIp_BFu17ll()
{
  {
    init_simple_test("aIp_BFu17ll");
    static STRUCT_IF_C aIp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll, aIp_BFu17ll)
//============================================================================



static void Test_aIp_BFu17ll_BFu15i()
{
  {
    init_simple_test("aIp_BFu17ll_BFu15i");
    static STRUCT_IF_C aIp_BFu17ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "aIp_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "aIp_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu15i, aIp_BFu17ll_BFu15i)
//============================================================================



static void Test_aIp_BFu17ll_BFu15ll()
{
  {
    init_simple_test("aIp_BFu17ll_BFu15ll");
    static STRUCT_IF_C aIp_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "aIp_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "aIp_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu15ll, aIp_BFu17ll_BFu15ll)
//============================================================================



static void Test_aIp_BFu17ll_BFu15s()
{
  {
    init_simple_test("aIp_BFu17ll_BFu15s");
    static STRUCT_IF_C aIp_BFu17ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, 1, "aIp_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 15, hide_ull(1LL<<14), "aIp_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu15s, aIp_BFu17ll_BFu15s)
//============================================================================



static void Test_aIp_BFu17ll_BFu16i()
{
  {
    init_simple_test("aIp_BFu17ll_BFu16i");
    static STRUCT_IF_C aIp_BFu17ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, 1, "aIp_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, hide_ull(1LL<<15), "aIp_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu16i, aIp_BFu17ll_BFu16i)
//============================================================================



static void Test_aIp_BFu17ll_BFu16ll()
{
  {
    init_simple_test("aIp_BFu17ll_BFu16ll");
    static STRUCT_IF_C aIp_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, 1, "aIp_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, hide_ull(1LL<<15), "aIp_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu16ll, aIp_BFu17ll_BFu16ll)
//============================================================================



static void Test_aIp_BFu17ll_BFu16s()
{
  {
    init_simple_test("aIp_BFu17ll_BFu16s");
    static STRUCT_IF_C aIp_BFu17ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, 1, "aIp_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 16, hide_ull(1LL<<15), "aIp_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu16s, aIp_BFu17ll_BFu16s)
//============================================================================



static void Test_aIp_BFu17ll_BFu17i()
{
  {
    init_simple_test("aIp_BFu17ll_BFu17i");
    static STRUCT_IF_C aIp_BFu17ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, 1, "aIp_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu17i, aIp_BFu17ll_BFu17i)
//============================================================================



static void Test_aIp_BFu17ll_BFu17ll()
{
  {
    init_simple_test("aIp_BFu17ll_BFu17ll");
    static STRUCT_IF_C aIp_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, 1, "aIp_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu17ll, aIp_BFu17ll_BFu17ll)
//============================================================================



static void Test_aIp_BFu17ll_BFu1c()
{
  {
    init_simple_test("aIp_BFu17ll_BFu1c");
    static STRUCT_IF_C aIp_BFu17ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "aIp_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu1c, aIp_BFu17ll_BFu1c)
//============================================================================



static void Test_aIp_BFu17ll_BFu1i()
{
  {
    init_simple_test("aIp_BFu17ll_BFu1i");
    static STRUCT_IF_C aIp_BFu17ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "aIp_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu1i, aIp_BFu17ll_BFu1i)
//============================================================================



static void Test_aIp_BFu17ll_BFu1ll()
{
  {
    init_simple_test("aIp_BFu17ll_BFu1ll");
    static STRUCT_IF_C aIp_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "aIp_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu1ll, aIp_BFu17ll_BFu1ll)
//============================================================================



static void Test_aIp_BFu17ll_BFu1s()
{
  {
    init_simple_test("aIp_BFu17ll_BFu1s");
    static STRUCT_IF_C aIp_BFu17ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 1, 1, "aIp_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu1s, aIp_BFu17ll_BFu1s)
//============================================================================



static void Test_aIp_BFu17ll_BFu31i()
{
  {
    init_simple_test("aIp_BFu17ll_BFu31i");
    static STRUCT_IF_C aIp_BFu17ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu17ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, 1, "aIp_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, hide_ull(1LL<<30), "aIp_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu31i, aIp_BFu17ll_BFu31i)
//============================================================================



static void Test_aIp_BFu17ll_BFu31ll()
{
  {
    init_simple_test("aIp_BFu17ll_BFu31ll");
    static STRUCT_IF_C aIp_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, 1, "aIp_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 31, hide_ull(1LL<<30), "aIp_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu31ll, aIp_BFu17ll_BFu31ll)
//============================================================================



static void Test_aIp_BFu17ll_BFu32i()
{
  {
    init_simple_test("aIp_BFu17ll_BFu32i");
    static STRUCT_IF_C aIp_BFu17ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu17ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, 1, "aIp_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, hide_ull(1LL<<31), "aIp_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu32i, aIp_BFu17ll_BFu32i)
//============================================================================



static void Test_aIp_BFu17ll_BFu32ll()
{
  {
    init_simple_test("aIp_BFu17ll_BFu32ll");
    static STRUCT_IF_C aIp_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, 1, "aIp_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 32, hide_ull(1LL<<31), "aIp_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu32ll, aIp_BFu17ll_BFu32ll)
//============================================================================



static void Test_aIp_BFu17ll_BFu33()
{
  {
    init_simple_test("aIp_BFu17ll_BFu33");
    static STRUCT_IF_C aIp_BFu17ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu17ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 33, 1, "aIp_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 33, hide_ull(1LL<<32), "aIp_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu33, aIp_BFu17ll_BFu33)
//============================================================================



static void Test_aIp_BFu17ll_BFu7c()
{
  {
    init_simple_test("aIp_BFu17ll_BFu7c");
    static STRUCT_IF_C aIp_BFu17ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "aIp_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "aIp_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu7c, aIp_BFu17ll_BFu7c)
//============================================================================



static void Test_aIp_BFu17ll_BFu7i()
{
  {
    init_simple_test("aIp_BFu17ll_BFu7i");
    static STRUCT_IF_C aIp_BFu17ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "aIp_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "aIp_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu7i, aIp_BFu17ll_BFu7i)
//============================================================================



static void Test_aIp_BFu17ll_BFu7ll()
{
  {
    init_simple_test("aIp_BFu17ll_BFu7ll");
    static STRUCT_IF_C aIp_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "aIp_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "aIp_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu7ll, aIp_BFu17ll_BFu7ll)
//============================================================================



static void Test_aIp_BFu17ll_BFu7s()
{
  {
    init_simple_test("aIp_BFu17ll_BFu7s");
    static STRUCT_IF_C aIp_BFu17ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu17ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, 1, "aIp_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 7, hide_ull(1LL<<6), "aIp_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu7s, aIp_BFu17ll_BFu7s)
//============================================================================



static void Test_aIp_BFu17ll_BFu8c()
{
  {
    init_simple_test("aIp_BFu17ll_BFu8c");
    static STRUCT_IF_C aIp_BFu17ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "aIp_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "aIp_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu8c, aIp_BFu17ll_BFu8c)
//============================================================================



static void Test_aIp_BFu17ll_BFu8i()
{
  {
    init_simple_test("aIp_BFu17ll_BFu8i");
    static STRUCT_IF_C aIp_BFu17ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "aIp_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "aIp_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu8i, aIp_BFu17ll_BFu8i)
//============================================================================



static void Test_aIp_BFu17ll_BFu8ll()
{
  {
    init_simple_test("aIp_BFu17ll_BFu8ll");
    static STRUCT_IF_C aIp_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "aIp_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "aIp_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu8ll, aIp_BFu17ll_BFu8ll)
//============================================================================



static void Test_aIp_BFu17ll_BFu8s()
{
  {
    init_simple_test("aIp_BFu17ll_BFu8s");
    static STRUCT_IF_C aIp_BFu17ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, 1, "aIp_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 8, hide_ull(1LL<<7), "aIp_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu8s, aIp_BFu17ll_BFu8s)
//============================================================================



static void Test_aIp_BFu17ll_BFu9i()
{
  {
    init_simple_test("aIp_BFu17ll_BFu9i");
    static STRUCT_IF_C aIp_BFu17ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "aIp_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "aIp_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu9i, aIp_BFu17ll_BFu9i)
//============================================================================



static void Test_aIp_BFu17ll_BFu9ll()
{
  {
    init_simple_test("aIp_BFu17ll_BFu9ll");
    static STRUCT_IF_C aIp_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "aIp_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "aIp_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu9ll, aIp_BFu17ll_BFu9ll)
//============================================================================



static void Test_aIp_BFu17ll_BFu9s()
{
  {
    init_simple_test("aIp_BFu17ll_BFu9s");
    static STRUCT_IF_C aIp_BFu17ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, 1, "aIp_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(10,6), 1, 9, hide_ull(1LL<<8), "aIp_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_BFu9s, aIp_BFu17ll_BFu9s)
//============================================================================



static void Test_aIp_BFu17ll_C()
{
  {
    init_simple_test("aIp_BFu17ll_C");
    static STRUCT_IF_C aIp_BFu17ll_C lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_C");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_C, aIp_BFu17ll_C)
//============================================================================



static void Test_aIp_BFu17ll_D()
{
  {
    init_simple_test("aIp_BFu17ll_D");
    static STRUCT_IF_C aIp_BFu17ll_D lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aIp_BFu17ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_D");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_D, aIp_BFu17ll_D)
//============================================================================



static void Test_aIp_BFu17ll_F()
{
  {
    init_simple_test("aIp_BFu17ll_F");
    static STRUCT_IF_C aIp_BFu17ll_F lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu17ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_F");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_F, aIp_BFu17ll_F)
//============================================================================



static void Test_aIp_BFu17ll_I()
{
  {
    init_simple_test("aIp_BFu17ll_I");
    static STRUCT_IF_C aIp_BFu17ll_I lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu17ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_I");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_I, aIp_BFu17ll_I)
//============================================================================



static void Test_aIp_BFu17ll_Ip()
{
  {
    init_simple_test("aIp_BFu17ll_Ip");
    static STRUCT_IF_C aIp_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(19,11), "sizeof(aIp_BFu17ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_Ip");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_Ip, aIp_BFu17ll_Ip)
//============================================================================



static void Test_aIp_BFu17ll_L()
{
  {
    init_simple_test("aIp_BFu17ll_L");
    static STRUCT_IF_C aIp_BFu17ll_L lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aIp_BFu17ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_L");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_L, aIp_BFu17ll_L)
//============================================================================



static void Test_aIp_BFu17ll_S()
{
  {
    init_simple_test("aIp_BFu17ll_S");
    static STRUCT_IF_C aIp_BFu17ll_S lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_S");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_S, aIp_BFu17ll_S)
//============================================================================



static void Test_aIp_BFu17ll_Uc()
{
  {
    init_simple_test("aIp_BFu17ll_Uc");
    static STRUCT_IF_C aIp_BFu17ll_Uc lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu17ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_Uc");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_Uc, aIp_BFu17ll_Uc)
//============================================================================



static void Test_aIp_BFu17ll_Ui()
{
  {
    init_simple_test("aIp_BFu17ll_Ui");
    static STRUCT_IF_C aIp_BFu17ll_Ui lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu17ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_Ui");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_Ui, aIp_BFu17ll_Ui)
//============================================================================



static void Test_aIp_BFu17ll_Ul()
{
  {
    init_simple_test("aIp_BFu17ll_Ul");
    static STRUCT_IF_C aIp_BFu17ll_Ul lv;
    check2(sizeof(lv), ABISELECT(19,15), "sizeof(aIp_BFu17ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_Ul");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_Ul, aIp_BFu17ll_Ul)
//============================================================================



static void Test_aIp_BFu17ll_Us()
{
  {
    init_simple_test("aIp_BFu17ll_Us");
    static STRUCT_IF_C aIp_BFu17ll_Us lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu17ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_Us");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_Us, aIp_BFu17ll_Us)
//============================================================================



static void Test_aIp_BFu17ll_Vp()
{
  {
    init_simple_test("aIp_BFu17ll_Vp");
    static STRUCT_IF_C aIp_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(19,11), "sizeof(aIp_BFu17ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, 1, "aIp_BFu17ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 17, hide_ull(1LL<<16), "aIp_BFu17ll_Vp");
    check_field_offset(lv, v3, ABISELECT(11,7), "aIp_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu17ll_Vp, aIp_BFu17ll_Vp)
//============================================================================



static void Test_aIp_BFu1c()
{
  {
    init_simple_test("aIp_BFu1c");
    static STRUCT_IF_C aIp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c, aIp_BFu1c)
//============================================================================



static void Test_aIp_BFu1c_BFu15i()
{
  {
    init_simple_test("aIp_BFu1c_BFu15i");
    static STRUCT_IF_C aIp_BFu1c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "aIp_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "aIp_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu15i, aIp_BFu1c_BFu15i)
//============================================================================



static void Test_aIp_BFu1c_BFu15ll()
{
  {
    init_simple_test("aIp_BFu1c_BFu15ll");
    static STRUCT_IF_C aIp_BFu1c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "aIp_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "aIp_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu15ll, aIp_BFu1c_BFu15ll)
//============================================================================



static void Test_aIp_BFu1c_BFu15s()
{
  {
    init_simple_test("aIp_BFu1c_BFu15s");
    static STRUCT_IF_C aIp_BFu1c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "aIp_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "aIp_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu15s, aIp_BFu1c_BFu15s)
//============================================================================



static void Test_aIp_BFu1c_BFu16i()
{
  {
    init_simple_test("aIp_BFu1c_BFu16i");
    static STRUCT_IF_C aIp_BFu1c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "aIp_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "aIp_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu16i, aIp_BFu1c_BFu16i)
//============================================================================



static void Test_aIp_BFu1c_BFu16ll()
{
  {
    init_simple_test("aIp_BFu1c_BFu16ll");
    static STRUCT_IF_C aIp_BFu1c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "aIp_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "aIp_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu16ll, aIp_BFu1c_BFu16ll)
//============================================================================



static void Test_aIp_BFu1c_BFu16s()
{
  {
    init_simple_test("aIp_BFu1c_BFu16s");
    static STRUCT_IF_C aIp_BFu1c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "aIp_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "aIp_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu16s, aIp_BFu1c_BFu16s)
//============================================================================



static void Test_aIp_BFu1c_BFu17i()
{
  {
    init_simple_test("aIp_BFu1c_BFu17i");
    static STRUCT_IF_C aIp_BFu1c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "aIp_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "aIp_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu17i, aIp_BFu1c_BFu17i)
//============================================================================



static void Test_aIp_BFu1c_BFu17ll()
{
  {
    init_simple_test("aIp_BFu1c_BFu17ll");
    static STRUCT_IF_C aIp_BFu1c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "aIp_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "aIp_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu17ll, aIp_BFu1c_BFu17ll)
//============================================================================



static void Test_aIp_BFu1c_BFu1c()
{
  {
    init_simple_test("aIp_BFu1c_BFu1c");
    static STRUCT_IF_C aIp_BFu1c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu1c, aIp_BFu1c_BFu1c)
//============================================================================



static void Test_aIp_BFu1c_BFu1i()
{
  {
    init_simple_test("aIp_BFu1c_BFu1i");
    static STRUCT_IF_C aIp_BFu1c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu1i, aIp_BFu1c_BFu1i)
//============================================================================



static void Test_aIp_BFu1c_BFu1ll()
{
  {
    init_simple_test("aIp_BFu1c_BFu1ll");
    static STRUCT_IF_C aIp_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu1ll, aIp_BFu1c_BFu1ll)
//============================================================================



static void Test_aIp_BFu1c_BFu1s()
{
  {
    init_simple_test("aIp_BFu1c_BFu1s");
    static STRUCT_IF_C aIp_BFu1c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu1s, aIp_BFu1c_BFu1s)
//============================================================================



static void Test_aIp_BFu1c_BFu31i()
{
  {
    init_simple_test("aIp_BFu1c_BFu31i");
    static STRUCT_IF_C aIp_BFu1c_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu1c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "aIp_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "aIp_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu31i, aIp_BFu1c_BFu31i)
//============================================================================



static void Test_aIp_BFu1c_BFu31ll()
{
  {
    init_simple_test("aIp_BFu1c_BFu31ll");
    static STRUCT_IF_C aIp_BFu1c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu1c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "aIp_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "aIp_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu31ll, aIp_BFu1c_BFu31ll)
//============================================================================



static void Test_aIp_BFu1c_BFu32i()
{
  {
    init_simple_test("aIp_BFu1c_BFu32i");
    static STRUCT_IF_C aIp_BFu1c_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "aIp_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "aIp_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu32i, aIp_BFu1c_BFu32i)
//============================================================================



static void Test_aIp_BFu1c_BFu32ll()
{
  {
    init_simple_test("aIp_BFu1c_BFu32ll");
    static STRUCT_IF_C aIp_BFu1c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "aIp_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "aIp_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu32ll, aIp_BFu1c_BFu32ll)
//============================================================================



static void Test_aIp_BFu1c_BFu33()
{
  {
    init_simple_test("aIp_BFu1c_BFu33");
    static STRUCT_IF_C aIp_BFu1c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, 1, "aIp_BFu1c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, hide_ull(1LL<<32), "aIp_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu33, aIp_BFu1c_BFu33)
//============================================================================



static void Test_aIp_BFu1c_BFu7c()
{
  {
    init_simple_test("aIp_BFu1c_BFu7c");
    static STRUCT_IF_C aIp_BFu1c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu7c, aIp_BFu1c_BFu7c)
//============================================================================



static void Test_aIp_BFu1c_BFu7i()
{
  {
    init_simple_test("aIp_BFu1c_BFu7i");
    static STRUCT_IF_C aIp_BFu1c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu7i, aIp_BFu1c_BFu7i)
//============================================================================



static void Test_aIp_BFu1c_BFu7ll()
{
  {
    init_simple_test("aIp_BFu1c_BFu7ll");
    static STRUCT_IF_C aIp_BFu1c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu7ll, aIp_BFu1c_BFu7ll)
//============================================================================



static void Test_aIp_BFu1c_BFu7s()
{
  {
    init_simple_test("aIp_BFu1c_BFu7s");
    static STRUCT_IF_C aIp_BFu1c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu7s, aIp_BFu1c_BFu7s)
//============================================================================



static void Test_aIp_BFu1c_BFu8c()
{
  {
    init_simple_test("aIp_BFu1c_BFu8c");
    static STRUCT_IF_C aIp_BFu1c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu8c, aIp_BFu1c_BFu8c)
//============================================================================



static void Test_aIp_BFu1c_BFu8i()
{
  {
    init_simple_test("aIp_BFu1c_BFu8i");
    static STRUCT_IF_C aIp_BFu1c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu8i, aIp_BFu1c_BFu8i)
//============================================================================



static void Test_aIp_BFu1c_BFu8ll()
{
  {
    init_simple_test("aIp_BFu1c_BFu8ll");
    static STRUCT_IF_C aIp_BFu1c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu8ll, aIp_BFu1c_BFu8ll)
//============================================================================



static void Test_aIp_BFu1c_BFu8s()
{
  {
    init_simple_test("aIp_BFu1c_BFu8s");
    static STRUCT_IF_C aIp_BFu1c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu8s, aIp_BFu1c_BFu8s)
//============================================================================



static void Test_aIp_BFu1c_BFu9i()
{
  {
    init_simple_test("aIp_BFu1c_BFu9i");
    static STRUCT_IF_C aIp_BFu1c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "aIp_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "aIp_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu9i, aIp_BFu1c_BFu9i)
//============================================================================



static void Test_aIp_BFu1c_BFu9ll()
{
  {
    init_simple_test("aIp_BFu1c_BFu9ll");
    static STRUCT_IF_C aIp_BFu1c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "aIp_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "aIp_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu9ll, aIp_BFu1c_BFu9ll)
//============================================================================



static void Test_aIp_BFu1c_BFu9s()
{
  {
    init_simple_test("aIp_BFu1c_BFu9s");
    static STRUCT_IF_C aIp_BFu1c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "aIp_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "aIp_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_BFu9s, aIp_BFu1c_BFu9s)
//============================================================================



static void Test_aIp_BFu1c_C()
{
  {
    init_simple_test("aIp_BFu1c_C");
    static STRUCT_IF_C aIp_BFu1c_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_C, aIp_BFu1c_C)
//============================================================================



static void Test_aIp_BFu1c_D()
{
  {
    init_simple_test("aIp_BFu1c_D");
    static STRUCT_IF_C aIp_BFu1c_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu1c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_D, aIp_BFu1c_D)
//============================================================================



static void Test_aIp_BFu1c_F()
{
  {
    init_simple_test("aIp_BFu1c_F");
    static STRUCT_IF_C aIp_BFu1c_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_F, aIp_BFu1c_F)
//============================================================================



static void Test_aIp_BFu1c_I()
{
  {
    init_simple_test("aIp_BFu1c_I");
    static STRUCT_IF_C aIp_BFu1c_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_I, aIp_BFu1c_I)
//============================================================================



static void Test_aIp_BFu1c_Ip()
{
  {
    init_simple_test("aIp_BFu1c_Ip");
    static STRUCT_IF_C aIp_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu1c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_Ip, aIp_BFu1c_Ip)
//============================================================================



static void Test_aIp_BFu1c_L()
{
  {
    init_simple_test("aIp_BFu1c_L");
    static STRUCT_IF_C aIp_BFu1c_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu1c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_L, aIp_BFu1c_L)
//============================================================================



static void Test_aIp_BFu1c_S()
{
  {
    init_simple_test("aIp_BFu1c_S");
    static STRUCT_IF_C aIp_BFu1c_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_S, aIp_BFu1c_S)
//============================================================================



static void Test_aIp_BFu1c_Uc()
{
  {
    init_simple_test("aIp_BFu1c_Uc");
    static STRUCT_IF_C aIp_BFu1c_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_Uc, aIp_BFu1c_Uc)
//============================================================================



static void Test_aIp_BFu1c_Ui()
{
  {
    init_simple_test("aIp_BFu1c_Ui");
    static STRUCT_IF_C aIp_BFu1c_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_Ui, aIp_BFu1c_Ui)
//============================================================================



static void Test_aIp_BFu1c_Ul()
{
  {
    init_simple_test("aIp_BFu1c_Ul");
    static STRUCT_IF_C aIp_BFu1c_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu1c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_Ul, aIp_BFu1c_Ul)
//============================================================================



static void Test_aIp_BFu1c_Us()
{
  {
    init_simple_test("aIp_BFu1c_Us");
    static STRUCT_IF_C aIp_BFu1c_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_Us, aIp_BFu1c_Us)
//============================================================================



static void Test_aIp_BFu1c_Vp()
{
  {
    init_simple_test("aIp_BFu1c_Vp");
    static STRUCT_IF_C aIp_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu1c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1c_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1c_Vp, aIp_BFu1c_Vp)
//============================================================================



static void Test_aIp_BFu1i()
{
  {
    init_simple_test("aIp_BFu1i");
    static STRUCT_IF_C aIp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i, aIp_BFu1i)
//============================================================================



static void Test_aIp_BFu1i_BFu15i()
{
  {
    init_simple_test("aIp_BFu1i_BFu15i");
    static STRUCT_IF_C aIp_BFu1i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "aIp_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "aIp_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu15i, aIp_BFu1i_BFu15i)
//============================================================================



static void Test_aIp_BFu1i_BFu15ll()
{
  {
    init_simple_test("aIp_BFu1i_BFu15ll");
    static STRUCT_IF_C aIp_BFu1i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "aIp_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "aIp_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu15ll, aIp_BFu1i_BFu15ll)
//============================================================================



static void Test_aIp_BFu1i_BFu15s()
{
  {
    init_simple_test("aIp_BFu1i_BFu15s");
    static STRUCT_IF_C aIp_BFu1i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "aIp_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "aIp_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu15s, aIp_BFu1i_BFu15s)
//============================================================================



static void Test_aIp_BFu1i_BFu16i()
{
  {
    init_simple_test("aIp_BFu1i_BFu16i");
    static STRUCT_IF_C aIp_BFu1i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "aIp_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "aIp_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu16i, aIp_BFu1i_BFu16i)
//============================================================================



static void Test_aIp_BFu1i_BFu16ll()
{
  {
    init_simple_test("aIp_BFu1i_BFu16ll");
    static STRUCT_IF_C aIp_BFu1i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "aIp_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "aIp_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu16ll, aIp_BFu1i_BFu16ll)
//============================================================================



static void Test_aIp_BFu1i_BFu16s()
{
  {
    init_simple_test("aIp_BFu1i_BFu16s");
    static STRUCT_IF_C aIp_BFu1i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "aIp_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "aIp_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu16s, aIp_BFu1i_BFu16s)
//============================================================================



static void Test_aIp_BFu1i_BFu17i()
{
  {
    init_simple_test("aIp_BFu1i_BFu17i");
    static STRUCT_IF_C aIp_BFu1i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "aIp_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "aIp_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu17i, aIp_BFu1i_BFu17i)
//============================================================================



static void Test_aIp_BFu1i_BFu17ll()
{
  {
    init_simple_test("aIp_BFu1i_BFu17ll");
    static STRUCT_IF_C aIp_BFu1i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "aIp_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "aIp_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu17ll, aIp_BFu1i_BFu17ll)
//============================================================================



static void Test_aIp_BFu1i_BFu1c()
{
  {
    init_simple_test("aIp_BFu1i_BFu1c");
    static STRUCT_IF_C aIp_BFu1i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu1c, aIp_BFu1i_BFu1c)
//============================================================================



static void Test_aIp_BFu1i_BFu1i()
{
  {
    init_simple_test("aIp_BFu1i_BFu1i");
    static STRUCT_IF_C aIp_BFu1i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu1i, aIp_BFu1i_BFu1i)
//============================================================================



static void Test_aIp_BFu1i_BFu1ll()
{
  {
    init_simple_test("aIp_BFu1i_BFu1ll");
    static STRUCT_IF_C aIp_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu1ll, aIp_BFu1i_BFu1ll)
//============================================================================



static void Test_aIp_BFu1i_BFu1s()
{
  {
    init_simple_test("aIp_BFu1i_BFu1s");
    static STRUCT_IF_C aIp_BFu1i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu1s, aIp_BFu1i_BFu1s)
//============================================================================



static void Test_aIp_BFu1i_BFu31i()
{
  {
    init_simple_test("aIp_BFu1i_BFu31i");
    static STRUCT_IF_C aIp_BFu1i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu1i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "aIp_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "aIp_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu31i, aIp_BFu1i_BFu31i)
//============================================================================



static void Test_aIp_BFu1i_BFu31ll()
{
  {
    init_simple_test("aIp_BFu1i_BFu31ll");
    static STRUCT_IF_C aIp_BFu1i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu1i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "aIp_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "aIp_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu31ll, aIp_BFu1i_BFu31ll)
//============================================================================



static void Test_aIp_BFu1i_BFu32i()
{
  {
    init_simple_test("aIp_BFu1i_BFu32i");
    static STRUCT_IF_C aIp_BFu1i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "aIp_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "aIp_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu32i, aIp_BFu1i_BFu32i)
//============================================================================



static void Test_aIp_BFu1i_BFu32ll()
{
  {
    init_simple_test("aIp_BFu1i_BFu32ll");
    static STRUCT_IF_C aIp_BFu1i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "aIp_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "aIp_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu32ll, aIp_BFu1i_BFu32ll)
//============================================================================



static void Test_aIp_BFu1i_BFu33()
{
  {
    init_simple_test("aIp_BFu1i_BFu33");
    static STRUCT_IF_C aIp_BFu1i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, 1, "aIp_BFu1i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, hide_ull(1LL<<32), "aIp_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu33, aIp_BFu1i_BFu33)
//============================================================================



static void Test_aIp_BFu1i_BFu7c()
{
  {
    init_simple_test("aIp_BFu1i_BFu7c");
    static STRUCT_IF_C aIp_BFu1i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu7c, aIp_BFu1i_BFu7c)
//============================================================================



static void Test_aIp_BFu1i_BFu7i()
{
  {
    init_simple_test("aIp_BFu1i_BFu7i");
    static STRUCT_IF_C aIp_BFu1i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu7i, aIp_BFu1i_BFu7i)
//============================================================================



static void Test_aIp_BFu1i_BFu7ll()
{
  {
    init_simple_test("aIp_BFu1i_BFu7ll");
    static STRUCT_IF_C aIp_BFu1i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu7ll, aIp_BFu1i_BFu7ll)
//============================================================================



static void Test_aIp_BFu1i_BFu7s()
{
  {
    init_simple_test("aIp_BFu1i_BFu7s");
    static STRUCT_IF_C aIp_BFu1i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu7s, aIp_BFu1i_BFu7s)
//============================================================================



static void Test_aIp_BFu1i_BFu8c()
{
  {
    init_simple_test("aIp_BFu1i_BFu8c");
    static STRUCT_IF_C aIp_BFu1i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu8c, aIp_BFu1i_BFu8c)
//============================================================================



static void Test_aIp_BFu1i_BFu8i()
{
  {
    init_simple_test("aIp_BFu1i_BFu8i");
    static STRUCT_IF_C aIp_BFu1i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu8i, aIp_BFu1i_BFu8i)
//============================================================================



static void Test_aIp_BFu1i_BFu8ll()
{
  {
    init_simple_test("aIp_BFu1i_BFu8ll");
    static STRUCT_IF_C aIp_BFu1i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu8ll, aIp_BFu1i_BFu8ll)
//============================================================================



static void Test_aIp_BFu1i_BFu8s()
{
  {
    init_simple_test("aIp_BFu1i_BFu8s");
    static STRUCT_IF_C aIp_BFu1i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu8s, aIp_BFu1i_BFu8s)
//============================================================================



static void Test_aIp_BFu1i_BFu9i()
{
  {
    init_simple_test("aIp_BFu1i_BFu9i");
    static STRUCT_IF_C aIp_BFu1i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "aIp_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "aIp_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu9i, aIp_BFu1i_BFu9i)
//============================================================================



static void Test_aIp_BFu1i_BFu9ll()
{
  {
    init_simple_test("aIp_BFu1i_BFu9ll");
    static STRUCT_IF_C aIp_BFu1i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "aIp_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "aIp_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu9ll, aIp_BFu1i_BFu9ll)
//============================================================================



static void Test_aIp_BFu1i_BFu9s()
{
  {
    init_simple_test("aIp_BFu1i_BFu9s");
    static STRUCT_IF_C aIp_BFu1i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "aIp_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "aIp_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_BFu9s, aIp_BFu1i_BFu9s)
//============================================================================



static void Test_aIp_BFu1i_C()
{
  {
    init_simple_test("aIp_BFu1i_C");
    static STRUCT_IF_C aIp_BFu1i_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_C, aIp_BFu1i_C)
//============================================================================



static void Test_aIp_BFu1i_D()
{
  {
    init_simple_test("aIp_BFu1i_D");
    static STRUCT_IF_C aIp_BFu1i_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu1i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_D, aIp_BFu1i_D)
//============================================================================



static void Test_aIp_BFu1i_F()
{
  {
    init_simple_test("aIp_BFu1i_F");
    static STRUCT_IF_C aIp_BFu1i_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_F, aIp_BFu1i_F)
//============================================================================



static void Test_aIp_BFu1i_I()
{
  {
    init_simple_test("aIp_BFu1i_I");
    static STRUCT_IF_C aIp_BFu1i_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_I, aIp_BFu1i_I)
//============================================================================



static void Test_aIp_BFu1i_Ip()
{
  {
    init_simple_test("aIp_BFu1i_Ip");
    static STRUCT_IF_C aIp_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu1i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_Ip, aIp_BFu1i_Ip)
//============================================================================



static void Test_aIp_BFu1i_L()
{
  {
    init_simple_test("aIp_BFu1i_L");
    static STRUCT_IF_C aIp_BFu1i_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu1i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_L, aIp_BFu1i_L)
//============================================================================



static void Test_aIp_BFu1i_S()
{
  {
    init_simple_test("aIp_BFu1i_S");
    static STRUCT_IF_C aIp_BFu1i_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_S, aIp_BFu1i_S)
//============================================================================



static void Test_aIp_BFu1i_Uc()
{
  {
    init_simple_test("aIp_BFu1i_Uc");
    static STRUCT_IF_C aIp_BFu1i_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_Uc, aIp_BFu1i_Uc)
//============================================================================



static void Test_aIp_BFu1i_Ui()
{
  {
    init_simple_test("aIp_BFu1i_Ui");
    static STRUCT_IF_C aIp_BFu1i_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_Ui, aIp_BFu1i_Ui)
//============================================================================



static void Test_aIp_BFu1i_Ul()
{
  {
    init_simple_test("aIp_BFu1i_Ul");
    static STRUCT_IF_C aIp_BFu1i_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu1i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_Ul, aIp_BFu1i_Ul)
//============================================================================



static void Test_aIp_BFu1i_Us()
{
  {
    init_simple_test("aIp_BFu1i_Us");
    static STRUCT_IF_C aIp_BFu1i_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_Us, aIp_BFu1i_Us)
//============================================================================



static void Test_aIp_BFu1i_Vp()
{
  {
    init_simple_test("aIp_BFu1i_Vp");
    static STRUCT_IF_C aIp_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu1i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1i_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1i_Vp, aIp_BFu1i_Vp)
//============================================================================



static void Test_aIp_BFu1ll()
{
  {
    init_simple_test("aIp_BFu1ll");
    static STRUCT_IF_C aIp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll, aIp_BFu1ll)
//============================================================================



static void Test_aIp_BFu1ll_BFu15i()
{
  {
    init_simple_test("aIp_BFu1ll_BFu15i");
    static STRUCT_IF_C aIp_BFu1ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "aIp_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "aIp_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu15i, aIp_BFu1ll_BFu15i)
//============================================================================



static void Test_aIp_BFu1ll_BFu15ll()
{
  {
    init_simple_test("aIp_BFu1ll_BFu15ll");
    static STRUCT_IF_C aIp_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "aIp_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "aIp_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu15ll, aIp_BFu1ll_BFu15ll)
//============================================================================



static void Test_aIp_BFu1ll_BFu15s()
{
  {
    init_simple_test("aIp_BFu1ll_BFu15s");
    static STRUCT_IF_C aIp_BFu1ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "aIp_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "aIp_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu15s, aIp_BFu1ll_BFu15s)
//============================================================================



static void Test_aIp_BFu1ll_BFu16i()
{
  {
    init_simple_test("aIp_BFu1ll_BFu16i");
    static STRUCT_IF_C aIp_BFu1ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "aIp_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "aIp_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu16i, aIp_BFu1ll_BFu16i)
//============================================================================



static void Test_aIp_BFu1ll_BFu16ll()
{
  {
    init_simple_test("aIp_BFu1ll_BFu16ll");
    static STRUCT_IF_C aIp_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "aIp_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "aIp_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu16ll, aIp_BFu1ll_BFu16ll)
//============================================================================



static void Test_aIp_BFu1ll_BFu16s()
{
  {
    init_simple_test("aIp_BFu1ll_BFu16s");
    static STRUCT_IF_C aIp_BFu1ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "aIp_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "aIp_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu16s, aIp_BFu1ll_BFu16s)
//============================================================================



static void Test_aIp_BFu1ll_BFu17i()
{
  {
    init_simple_test("aIp_BFu1ll_BFu17i");
    static STRUCT_IF_C aIp_BFu1ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "aIp_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "aIp_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu17i, aIp_BFu1ll_BFu17i)
//============================================================================



static void Test_aIp_BFu1ll_BFu17ll()
{
  {
    init_simple_test("aIp_BFu1ll_BFu17ll");
    static STRUCT_IF_C aIp_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "aIp_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "aIp_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu17ll, aIp_BFu1ll_BFu17ll)
//============================================================================



static void Test_aIp_BFu1ll_BFu1c()
{
  {
    init_simple_test("aIp_BFu1ll_BFu1c");
    static STRUCT_IF_C aIp_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu1c, aIp_BFu1ll_BFu1c)
//============================================================================



static void Test_aIp_BFu1ll_BFu1i()
{
  {
    init_simple_test("aIp_BFu1ll_BFu1i");
    static STRUCT_IF_C aIp_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu1i, aIp_BFu1ll_BFu1i)
//============================================================================



static void Test_aIp_BFu1ll_BFu1ll()
{
  {
    init_simple_test("aIp_BFu1ll_BFu1ll");
    static STRUCT_IF_C aIp_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu1ll, aIp_BFu1ll_BFu1ll)
//============================================================================



static void Test_aIp_BFu1ll_BFu1s()
{
  {
    init_simple_test("aIp_BFu1ll_BFu1s");
    static STRUCT_IF_C aIp_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu1s, aIp_BFu1ll_BFu1s)
//============================================================================



static void Test_aIp_BFu1ll_BFu31i()
{
  {
    init_simple_test("aIp_BFu1ll_BFu31i");
    static STRUCT_IF_C aIp_BFu1ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu1ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "aIp_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "aIp_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu31i, aIp_BFu1ll_BFu31i)
//============================================================================



static void Test_aIp_BFu1ll_BFu31ll()
{
  {
    init_simple_test("aIp_BFu1ll_BFu31ll");
    static STRUCT_IF_C aIp_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "aIp_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "aIp_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu31ll, aIp_BFu1ll_BFu31ll)
//============================================================================



static void Test_aIp_BFu1ll_BFu32i()
{
  {
    init_simple_test("aIp_BFu1ll_BFu32i");
    static STRUCT_IF_C aIp_BFu1ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "aIp_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "aIp_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu32i, aIp_BFu1ll_BFu32i)
//============================================================================



static void Test_aIp_BFu1ll_BFu32ll()
{
  {
    init_simple_test("aIp_BFu1ll_BFu32ll");
    static STRUCT_IF_C aIp_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "aIp_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "aIp_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu32ll, aIp_BFu1ll_BFu32ll)
//============================================================================



static void Test_aIp_BFu1ll_BFu33()
{
  {
    init_simple_test("aIp_BFu1ll_BFu33");
    static STRUCT_IF_C aIp_BFu1ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, 1, "aIp_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, hide_ull(1LL<<32), "aIp_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu33, aIp_BFu1ll_BFu33)
//============================================================================



static void Test_aIp_BFu1ll_BFu7c()
{
  {
    init_simple_test("aIp_BFu1ll_BFu7c");
    static STRUCT_IF_C aIp_BFu1ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu7c, aIp_BFu1ll_BFu7c)
//============================================================================



static void Test_aIp_BFu1ll_BFu7i()
{
  {
    init_simple_test("aIp_BFu1ll_BFu7i");
    static STRUCT_IF_C aIp_BFu1ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu7i, aIp_BFu1ll_BFu7i)
//============================================================================



static void Test_aIp_BFu1ll_BFu7ll()
{
  {
    init_simple_test("aIp_BFu1ll_BFu7ll");
    static STRUCT_IF_C aIp_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu7ll, aIp_BFu1ll_BFu7ll)
//============================================================================



static void Test_aIp_BFu1ll_BFu7s()
{
  {
    init_simple_test("aIp_BFu1ll_BFu7s");
    static STRUCT_IF_C aIp_BFu1ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu7s, aIp_BFu1ll_BFu7s)
//============================================================================



static void Test_aIp_BFu1ll_BFu8c()
{
  {
    init_simple_test("aIp_BFu1ll_BFu8c");
    static STRUCT_IF_C aIp_BFu1ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu8c, aIp_BFu1ll_BFu8c)
//============================================================================



static void Test_aIp_BFu1ll_BFu8i()
{
  {
    init_simple_test("aIp_BFu1ll_BFu8i");
    static STRUCT_IF_C aIp_BFu1ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu8i, aIp_BFu1ll_BFu8i)
//============================================================================



static void Test_aIp_BFu1ll_BFu8ll()
{
  {
    init_simple_test("aIp_BFu1ll_BFu8ll");
    static STRUCT_IF_C aIp_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu8ll, aIp_BFu1ll_BFu8ll)
//============================================================================



static void Test_aIp_BFu1ll_BFu8s()
{
  {
    init_simple_test("aIp_BFu1ll_BFu8s");
    static STRUCT_IF_C aIp_BFu1ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu8s, aIp_BFu1ll_BFu8s)
//============================================================================



static void Test_aIp_BFu1ll_BFu9i()
{
  {
    init_simple_test("aIp_BFu1ll_BFu9i");
    static STRUCT_IF_C aIp_BFu1ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "aIp_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "aIp_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu9i, aIp_BFu1ll_BFu9i)
//============================================================================



static void Test_aIp_BFu1ll_BFu9ll()
{
  {
    init_simple_test("aIp_BFu1ll_BFu9ll");
    static STRUCT_IF_C aIp_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "aIp_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "aIp_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu9ll, aIp_BFu1ll_BFu9ll)
//============================================================================



static void Test_aIp_BFu1ll_BFu9s()
{
  {
    init_simple_test("aIp_BFu1ll_BFu9s");
    static STRUCT_IF_C aIp_BFu1ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "aIp_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "aIp_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_BFu9s, aIp_BFu1ll_BFu9s)
//============================================================================



static void Test_aIp_BFu1ll_C()
{
  {
    init_simple_test("aIp_BFu1ll_C");
    static STRUCT_IF_C aIp_BFu1ll_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_C, aIp_BFu1ll_C)
//============================================================================



static void Test_aIp_BFu1ll_D()
{
  {
    init_simple_test("aIp_BFu1ll_D");
    static STRUCT_IF_C aIp_BFu1ll_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu1ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_D, aIp_BFu1ll_D)
//============================================================================



static void Test_aIp_BFu1ll_F()
{
  {
    init_simple_test("aIp_BFu1ll_F");
    static STRUCT_IF_C aIp_BFu1ll_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_F, aIp_BFu1ll_F)
//============================================================================



static void Test_aIp_BFu1ll_I()
{
  {
    init_simple_test("aIp_BFu1ll_I");
    static STRUCT_IF_C aIp_BFu1ll_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_I, aIp_BFu1ll_I)
//============================================================================



static void Test_aIp_BFu1ll_Ip()
{
  {
    init_simple_test("aIp_BFu1ll_Ip");
    static STRUCT_IF_C aIp_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu1ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_Ip, aIp_BFu1ll_Ip)
//============================================================================



static void Test_aIp_BFu1ll_L()
{
  {
    init_simple_test("aIp_BFu1ll_L");
    static STRUCT_IF_C aIp_BFu1ll_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu1ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_L, aIp_BFu1ll_L)
//============================================================================



static void Test_aIp_BFu1ll_S()
{
  {
    init_simple_test("aIp_BFu1ll_S");
    static STRUCT_IF_C aIp_BFu1ll_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_S, aIp_BFu1ll_S)
//============================================================================



static void Test_aIp_BFu1ll_Uc()
{
  {
    init_simple_test("aIp_BFu1ll_Uc");
    static STRUCT_IF_C aIp_BFu1ll_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_Uc, aIp_BFu1ll_Uc)
//============================================================================



static void Test_aIp_BFu1ll_Ui()
{
  {
    init_simple_test("aIp_BFu1ll_Ui");
    static STRUCT_IF_C aIp_BFu1ll_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_Ui, aIp_BFu1ll_Ui)
//============================================================================



static void Test_aIp_BFu1ll_Ul()
{
  {
    init_simple_test("aIp_BFu1ll_Ul");
    static STRUCT_IF_C aIp_BFu1ll_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu1ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_Ul, aIp_BFu1ll_Ul)
//============================================================================



static void Test_aIp_BFu1ll_Us()
{
  {
    init_simple_test("aIp_BFu1ll_Us");
    static STRUCT_IF_C aIp_BFu1ll_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_Us, aIp_BFu1ll_Us)
//============================================================================



static void Test_aIp_BFu1ll_Vp()
{
  {
    init_simple_test("aIp_BFu1ll_Vp");
    static STRUCT_IF_C aIp_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu1ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1ll_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1ll_Vp, aIp_BFu1ll_Vp)
//============================================================================



static void Test_aIp_BFu1s()
{
  {
    init_simple_test("aIp_BFu1s");
    static STRUCT_IF_C aIp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s, aIp_BFu1s)
//============================================================================



static void Test_aIp_BFu1s_BFu15i()
{
  {
    init_simple_test("aIp_BFu1s_BFu15i");
    static STRUCT_IF_C aIp_BFu1s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "aIp_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "aIp_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu15i, aIp_BFu1s_BFu15i)
//============================================================================



static void Test_aIp_BFu1s_BFu15ll()
{
  {
    init_simple_test("aIp_BFu1s_BFu15ll");
    static STRUCT_IF_C aIp_BFu1s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "aIp_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "aIp_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu15ll, aIp_BFu1s_BFu15ll)
//============================================================================



static void Test_aIp_BFu1s_BFu15s()
{
  {
    init_simple_test("aIp_BFu1s_BFu15s");
    static STRUCT_IF_C aIp_BFu1s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, 1, "aIp_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 15, hide_ull(1LL<<14), "aIp_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu15s, aIp_BFu1s_BFu15s)
//============================================================================



static void Test_aIp_BFu1s_BFu16i()
{
  {
    init_simple_test("aIp_BFu1s_BFu16i");
    static STRUCT_IF_C aIp_BFu1s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "aIp_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "aIp_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu16i, aIp_BFu1s_BFu16i)
//============================================================================



static void Test_aIp_BFu1s_BFu16ll()
{
  {
    init_simple_test("aIp_BFu1s_BFu16ll");
    static STRUCT_IF_C aIp_BFu1s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "aIp_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "aIp_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu16ll, aIp_BFu1s_BFu16ll)
//============================================================================



static void Test_aIp_BFu1s_BFu16s()
{
  {
    init_simple_test("aIp_BFu1s_BFu16s");
    static STRUCT_IF_C aIp_BFu1s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, 1, "aIp_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 16, hide_ull(1LL<<15), "aIp_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu16s, aIp_BFu1s_BFu16s)
//============================================================================



static void Test_aIp_BFu1s_BFu17i()
{
  {
    init_simple_test("aIp_BFu1s_BFu17i");
    static STRUCT_IF_C aIp_BFu1s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "aIp_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "aIp_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu17i, aIp_BFu1s_BFu17i)
//============================================================================



static void Test_aIp_BFu1s_BFu17ll()
{
  {
    init_simple_test("aIp_BFu1s_BFu17ll");
    static STRUCT_IF_C aIp_BFu1s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, 1, "aIp_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 17, hide_ull(1LL<<16), "aIp_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu17ll, aIp_BFu1s_BFu17ll)
//============================================================================



static void Test_aIp_BFu1s_BFu1c()
{
  {
    init_simple_test("aIp_BFu1s_BFu1c");
    static STRUCT_IF_C aIp_BFu1s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu1c, aIp_BFu1s_BFu1c)
//============================================================================



static void Test_aIp_BFu1s_BFu1i()
{
  {
    init_simple_test("aIp_BFu1s_BFu1i");
    static STRUCT_IF_C aIp_BFu1s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu1i, aIp_BFu1s_BFu1i)
//============================================================================



static void Test_aIp_BFu1s_BFu1ll()
{
  {
    init_simple_test("aIp_BFu1s_BFu1ll");
    static STRUCT_IF_C aIp_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu1ll, aIp_BFu1s_BFu1ll)
//============================================================================



static void Test_aIp_BFu1s_BFu1s()
{
  {
    init_simple_test("aIp_BFu1s_BFu1s");
    static STRUCT_IF_C aIp_BFu1s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 1, 1, "aIp_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu1s, aIp_BFu1s_BFu1s)
//============================================================================



static void Test_aIp_BFu1s_BFu31i()
{
  {
    init_simple_test("aIp_BFu1s_BFu31i");
    static STRUCT_IF_C aIp_BFu1s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu1s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "aIp_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "aIp_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu31i, aIp_BFu1s_BFu31i)
//============================================================================



static void Test_aIp_BFu1s_BFu31ll()
{
  {
    init_simple_test("aIp_BFu1s_BFu31ll");
    static STRUCT_IF_C aIp_BFu1s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu1s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, 1, "aIp_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 31, hide_ull(1LL<<30), "aIp_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu31ll, aIp_BFu1s_BFu31ll)
//============================================================================



static void Test_aIp_BFu1s_BFu32i()
{
  {
    init_simple_test("aIp_BFu1s_BFu32i");
    static STRUCT_IF_C aIp_BFu1s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "aIp_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "aIp_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu32i, aIp_BFu1s_BFu32i)
//============================================================================



static void Test_aIp_BFu1s_BFu32ll()
{
  {
    init_simple_test("aIp_BFu1s_BFu32ll");
    static STRUCT_IF_C aIp_BFu1s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, 1, "aIp_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 32, hide_ull(1LL<<31), "aIp_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu32ll, aIp_BFu1s_BFu32ll)
//============================================================================



static void Test_aIp_BFu1s_BFu33()
{
  {
    init_simple_test("aIp_BFu1s_BFu33");
    static STRUCT_IF_C aIp_BFu1s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, 1, "aIp_BFu1s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 33, hide_ull(1LL<<32), "aIp_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu33, aIp_BFu1s_BFu33)
//============================================================================



static void Test_aIp_BFu1s_BFu7c()
{
  {
    init_simple_test("aIp_BFu1s_BFu7c");
    static STRUCT_IF_C aIp_BFu1s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu7c, aIp_BFu1s_BFu7c)
//============================================================================



static void Test_aIp_BFu1s_BFu7i()
{
  {
    init_simple_test("aIp_BFu1s_BFu7i");
    static STRUCT_IF_C aIp_BFu1s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu7i, aIp_BFu1s_BFu7i)
//============================================================================



static void Test_aIp_BFu1s_BFu7ll()
{
  {
    init_simple_test("aIp_BFu1s_BFu7ll");
    static STRUCT_IF_C aIp_BFu1s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu7ll, aIp_BFu1s_BFu7ll)
//============================================================================



static void Test_aIp_BFu1s_BFu7s()
{
  {
    init_simple_test("aIp_BFu1s_BFu7s");
    static STRUCT_IF_C aIp_BFu1s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu1s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, 1, "aIp_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 7, hide_ull(1LL<<6), "aIp_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu7s, aIp_BFu1s_BFu7s)
//============================================================================



static void Test_aIp_BFu1s_BFu8c()
{
  {
    init_simple_test("aIp_BFu1s_BFu8c");
    static STRUCT_IF_C aIp_BFu1s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu8c, aIp_BFu1s_BFu8c)
//============================================================================



static void Test_aIp_BFu1s_BFu8i()
{
  {
    init_simple_test("aIp_BFu1s_BFu8i");
    static STRUCT_IF_C aIp_BFu1s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu8i, aIp_BFu1s_BFu8i)
//============================================================================



static void Test_aIp_BFu1s_BFu8ll()
{
  {
    init_simple_test("aIp_BFu1s_BFu8ll");
    static STRUCT_IF_C aIp_BFu1s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu8ll, aIp_BFu1s_BFu8ll)
//============================================================================



static void Test_aIp_BFu1s_BFu8s()
{
  {
    init_simple_test("aIp_BFu1s_BFu8s");
    static STRUCT_IF_C aIp_BFu1s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, 1, "aIp_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 8, hide_ull(1LL<<7), "aIp_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu8s, aIp_BFu1s_BFu8s)
//============================================================================



static void Test_aIp_BFu1s_BFu9i()
{
  {
    init_simple_test("aIp_BFu1s_BFu9i");
    static STRUCT_IF_C aIp_BFu1s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "aIp_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "aIp_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu9i, aIp_BFu1s_BFu9i)
//============================================================================



static void Test_aIp_BFu1s_BFu9ll()
{
  {
    init_simple_test("aIp_BFu1s_BFu9ll");
    static STRUCT_IF_C aIp_BFu1s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "aIp_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "aIp_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu9ll, aIp_BFu1s_BFu9ll)
//============================================================================



static void Test_aIp_BFu1s_BFu9s()
{
  {
    init_simple_test("aIp_BFu1s_BFu9s");
    static STRUCT_IF_C aIp_BFu1s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, 1, "aIp_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 1, 9, hide_ull(1LL<<8), "aIp_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_BFu9s, aIp_BFu1s_BFu9s)
//============================================================================



static void Test_aIp_BFu1s_C()
{
  {
    init_simple_test("aIp_BFu1s_C");
    static STRUCT_IF_C aIp_BFu1s_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_C, aIp_BFu1s_C)
//============================================================================



static void Test_aIp_BFu1s_D()
{
  {
    init_simple_test("aIp_BFu1s_D");
    static STRUCT_IF_C aIp_BFu1s_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu1s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_D, aIp_BFu1s_D)
//============================================================================



static void Test_aIp_BFu1s_F()
{
  {
    init_simple_test("aIp_BFu1s_F");
    static STRUCT_IF_C aIp_BFu1s_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_F, aIp_BFu1s_F)
//============================================================================



static void Test_aIp_BFu1s_I()
{
  {
    init_simple_test("aIp_BFu1s_I");
    static STRUCT_IF_C aIp_BFu1s_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_I, aIp_BFu1s_I)
//============================================================================



static void Test_aIp_BFu1s_Ip()
{
  {
    init_simple_test("aIp_BFu1s_Ip");
    static STRUCT_IF_C aIp_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu1s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_Ip, aIp_BFu1s_Ip)
//============================================================================



static void Test_aIp_BFu1s_L()
{
  {
    init_simple_test("aIp_BFu1s_L");
    static STRUCT_IF_C aIp_BFu1s_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu1s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_L, aIp_BFu1s_L)
//============================================================================



static void Test_aIp_BFu1s_S()
{
  {
    init_simple_test("aIp_BFu1s_S");
    static STRUCT_IF_C aIp_BFu1s_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_S, aIp_BFu1s_S)
//============================================================================



static void Test_aIp_BFu1s_Uc()
{
  {
    init_simple_test("aIp_BFu1s_Uc");
    static STRUCT_IF_C aIp_BFu1s_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu1s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_Uc, aIp_BFu1s_Uc)
//============================================================================



static void Test_aIp_BFu1s_Ui()
{
  {
    init_simple_test("aIp_BFu1s_Ui");
    static STRUCT_IF_C aIp_BFu1s_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu1s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_Ui, aIp_BFu1s_Ui)
//============================================================================



static void Test_aIp_BFu1s_Ul()
{
  {
    init_simple_test("aIp_BFu1s_Ul");
    static STRUCT_IF_C aIp_BFu1s_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu1s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_Ul, aIp_BFu1s_Ul)
//============================================================================



static void Test_aIp_BFu1s_Us()
{
  {
    init_simple_test("aIp_BFu1s_Us");
    static STRUCT_IF_C aIp_BFu1s_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu1s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_Us, aIp_BFu1s_Us)
//============================================================================



static void Test_aIp_BFu1s_Vp()
{
  {
    init_simple_test("aIp_BFu1s_Vp");
    static STRUCT_IF_C aIp_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu1s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 1, 1, "aIp_BFu1s_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu1s_Vp, aIp_BFu1s_Vp)
//============================================================================



static void Test_aIp_BFu31i()
{
  {
    init_simple_test("aIp_BFu31i");
    static STRUCT_IF_C aIp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i, aIp_BFu31i)
//============================================================================



static void Test_aIp_BFu31i_BFu15i()
{
  {
    init_simple_test("aIp_BFu31i_BFu15i");
    static STRUCT_IF_C aIp_BFu31i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, 1, "aIp_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, hide_ull(1LL<<14), "aIp_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu15i, aIp_BFu31i_BFu15i)
//============================================================================



static void Test_aIp_BFu31i_BFu15ll()
{
  {
    init_simple_test("aIp_BFu31i_BFu15ll");
    static STRUCT_IF_C aIp_BFu31i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, 1, "aIp_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, hide_ull(1LL<<14), "aIp_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu15ll, aIp_BFu31i_BFu15ll)
//============================================================================



static void Test_aIp_BFu31i_BFu15s()
{
  {
    init_simple_test("aIp_BFu31i_BFu15s");
    static STRUCT_IF_C aIp_BFu31i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, 1, "aIp_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, hide_ull(1LL<<14), "aIp_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu15s, aIp_BFu31i_BFu15s)
//============================================================================



static void Test_aIp_BFu31i_BFu16i()
{
  {
    init_simple_test("aIp_BFu31i_BFu16i");
    static STRUCT_IF_C aIp_BFu31i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, 1, "aIp_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, hide_ull(1LL<<15), "aIp_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu16i, aIp_BFu31i_BFu16i)
//============================================================================



static void Test_aIp_BFu31i_BFu16ll()
{
  {
    init_simple_test("aIp_BFu31i_BFu16ll");
    static STRUCT_IF_C aIp_BFu31i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, 1, "aIp_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, hide_ull(1LL<<15), "aIp_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu16ll, aIp_BFu31i_BFu16ll)
//============================================================================



static void Test_aIp_BFu31i_BFu16s()
{
  {
    init_simple_test("aIp_BFu31i_BFu16s");
    static STRUCT_IF_C aIp_BFu31i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, 1, "aIp_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, hide_ull(1LL<<15), "aIp_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu16s, aIp_BFu31i_BFu16s)
//============================================================================



static void Test_aIp_BFu31i_BFu17i()
{
  {
    init_simple_test("aIp_BFu31i_BFu17i");
    static STRUCT_IF_C aIp_BFu31i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, 1, "aIp_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, hide_ull(1LL<<16), "aIp_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu17i, aIp_BFu31i_BFu17i)
//============================================================================



static void Test_aIp_BFu31i_BFu17ll()
{
  {
    init_simple_test("aIp_BFu31i_BFu17ll");
    static STRUCT_IF_C aIp_BFu31i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, 1, "aIp_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, hide_ull(1LL<<16), "aIp_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu17ll, aIp_BFu31i_BFu17ll)
//============================================================================



static void Test_aIp_BFu31i_BFu1c()
{
  {
    init_simple_test("aIp_BFu31i_BFu1c");
    static STRUCT_IF_C aIp_BFu31i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu31i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "aIp_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu1c, aIp_BFu31i_BFu1c)
//============================================================================



static void Test_aIp_BFu31i_BFu1i()
{
  {
    init_simple_test("aIp_BFu31i_BFu1i");
    static STRUCT_IF_C aIp_BFu31i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu31i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "aIp_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu1i, aIp_BFu31i_BFu1i)
//============================================================================



static void Test_aIp_BFu31i_BFu1ll()
{
  {
    init_simple_test("aIp_BFu31i_BFu1ll");
    static STRUCT_IF_C aIp_BFu31i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu31i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "aIp_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu1ll, aIp_BFu31i_BFu1ll)
//============================================================================



static void Test_aIp_BFu31i_BFu1s()
{
  {
    init_simple_test("aIp_BFu31i_BFu1s");
    static STRUCT_IF_C aIp_BFu31i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu31i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "aIp_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu1s, aIp_BFu31i_BFu1s)
//============================================================================



static void Test_aIp_BFu31i_BFu31i()
{
  {
    init_simple_test("aIp_BFu31i_BFu31i");
    static STRUCT_IF_C aIp_BFu31i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, 1, "aIp_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu31i, aIp_BFu31i_BFu31i)
//============================================================================



static void Test_aIp_BFu31i_BFu31ll()
{
  {
    init_simple_test("aIp_BFu31i_BFu31ll");
    static STRUCT_IF_C aIp_BFu31i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, 1, "aIp_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu31ll, aIp_BFu31i_BFu31ll)
//============================================================================



static void Test_aIp_BFu31i_BFu32i()
{
  {
    init_simple_test("aIp_BFu31i_BFu32i");
    static STRUCT_IF_C aIp_BFu31i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, 1, "aIp_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, hide_ull(1LL<<31), "aIp_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu32i, aIp_BFu31i_BFu32i)
//============================================================================



static void Test_aIp_BFu31i_BFu32ll()
{
  {
    init_simple_test("aIp_BFu31i_BFu32ll");
    static STRUCT_IF_C aIp_BFu31i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, 1, "aIp_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, hide_ull(1LL<<31), "aIp_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu32ll, aIp_BFu31i_BFu32ll)
//============================================================================



static void Test_aIp_BFu31i_BFu33()
{
  {
    init_simple_test("aIp_BFu31i_BFu33");
    static STRUCT_IF_C aIp_BFu31i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 33, 1, "aIp_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 33, hide_ull(1LL<<32), "aIp_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu33, aIp_BFu31i_BFu33)
//============================================================================



static void Test_aIp_BFu31i_BFu7c()
{
  {
    init_simple_test("aIp_BFu31i_BFu7c");
    static STRUCT_IF_C aIp_BFu31i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "aIp_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "aIp_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu7c, aIp_BFu31i_BFu7c)
//============================================================================



static void Test_aIp_BFu31i_BFu7i()
{
  {
    init_simple_test("aIp_BFu31i_BFu7i");
    static STRUCT_IF_C aIp_BFu31i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "aIp_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "aIp_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu7i, aIp_BFu31i_BFu7i)
//============================================================================



static void Test_aIp_BFu31i_BFu7ll()
{
  {
    init_simple_test("aIp_BFu31i_BFu7ll");
    static STRUCT_IF_C aIp_BFu31i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "aIp_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "aIp_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu7ll, aIp_BFu31i_BFu7ll)
//============================================================================



static void Test_aIp_BFu31i_BFu7s()
{
  {
    init_simple_test("aIp_BFu31i_BFu7s");
    static STRUCT_IF_C aIp_BFu31i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "aIp_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "aIp_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu7s, aIp_BFu31i_BFu7s)
//============================================================================



static void Test_aIp_BFu31i_BFu8c()
{
  {
    init_simple_test("aIp_BFu31i_BFu8c");
    static STRUCT_IF_C aIp_BFu31i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "aIp_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "aIp_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu8c, aIp_BFu31i_BFu8c)
//============================================================================



static void Test_aIp_BFu31i_BFu8i()
{
  {
    init_simple_test("aIp_BFu31i_BFu8i");
    static STRUCT_IF_C aIp_BFu31i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "aIp_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "aIp_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu8i, aIp_BFu31i_BFu8i)
//============================================================================



static void Test_aIp_BFu31i_BFu8ll()
{
  {
    init_simple_test("aIp_BFu31i_BFu8ll");
    static STRUCT_IF_C aIp_BFu31i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "aIp_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "aIp_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu8ll, aIp_BFu31i_BFu8ll)
//============================================================================



static void Test_aIp_BFu31i_BFu8s()
{
  {
    init_simple_test("aIp_BFu31i_BFu8s");
    static STRUCT_IF_C aIp_BFu31i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "aIp_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "aIp_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu8s, aIp_BFu31i_BFu8s)
//============================================================================



static void Test_aIp_BFu31i_BFu9i()
{
  {
    init_simple_test("aIp_BFu31i_BFu9i");
    static STRUCT_IF_C aIp_BFu31i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, 1, "aIp_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, hide_ull(1LL<<8), "aIp_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu9i, aIp_BFu31i_BFu9i)
//============================================================================



static void Test_aIp_BFu31i_BFu9ll()
{
  {
    init_simple_test("aIp_BFu31i_BFu9ll");
    static STRUCT_IF_C aIp_BFu31i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, 1, "aIp_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, hide_ull(1LL<<8), "aIp_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu9ll, aIp_BFu31i_BFu9ll)
//============================================================================



static void Test_aIp_BFu31i_BFu9s()
{
  {
    init_simple_test("aIp_BFu31i_BFu9s");
    static STRUCT_IF_C aIp_BFu31i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, 1, "aIp_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, hide_ull(1LL<<8), "aIp_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_BFu9s, aIp_BFu31i_BFu9s)
//============================================================================



static void Test_aIp_BFu31i_C()
{
  {
    init_simple_test("aIp_BFu31i_C");
    static STRUCT_IF_C aIp_BFu31i_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_C");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_C, aIp_BFu31i_C)
//============================================================================



static void Test_aIp_BFu31i_D()
{
  {
    init_simple_test("aIp_BFu31i_D");
    static STRUCT_IF_C aIp_BFu31i_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aIp_BFu31i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_D");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_D, aIp_BFu31i_D)
//============================================================================



static void Test_aIp_BFu31i_F()
{
  {
    init_simple_test("aIp_BFu31i_F");
    static STRUCT_IF_C aIp_BFu31i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_F, aIp_BFu31i_F)
//============================================================================



static void Test_aIp_BFu31i_I()
{
  {
    init_simple_test("aIp_BFu31i_I");
    static STRUCT_IF_C aIp_BFu31i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_I, aIp_BFu31i_I)
//============================================================================



static void Test_aIp_BFu31i_Ip()
{
  {
    init_simple_test("aIp_BFu31i_Ip");
    static STRUCT_IF_C aIp_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aIp_BFu31i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_Ip");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_Ip, aIp_BFu31i_Ip)
//============================================================================



static void Test_aIp_BFu31i_L()
{
  {
    init_simple_test("aIp_BFu31i_L");
    static STRUCT_IF_C aIp_BFu31i_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aIp_BFu31i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_L");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_L, aIp_BFu31i_L)
//============================================================================



static void Test_aIp_BFu31i_S()
{
  {
    init_simple_test("aIp_BFu31i_S");
    static STRUCT_IF_C aIp_BFu31i_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_S, aIp_BFu31i_S)
//============================================================================



static void Test_aIp_BFu31i_Uc()
{
  {
    init_simple_test("aIp_BFu31i_Uc");
    static STRUCT_IF_C aIp_BFu31i_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_Uc");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_Uc, aIp_BFu31i_Uc)
//============================================================================



static void Test_aIp_BFu31i_Ui()
{
  {
    init_simple_test("aIp_BFu31i_Ui");
    static STRUCT_IF_C aIp_BFu31i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_Ui, aIp_BFu31i_Ui)
//============================================================================



static void Test_aIp_BFu31i_Ul()
{
  {
    init_simple_test("aIp_BFu31i_Ul");
    static STRUCT_IF_C aIp_BFu31i_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aIp_BFu31i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_Ul");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_Ul, aIp_BFu31i_Ul)
//============================================================================



static void Test_aIp_BFu31i_Us()
{
  {
    init_simple_test("aIp_BFu31i_Us");
    static STRUCT_IF_C aIp_BFu31i_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_Us, aIp_BFu31i_Us)
//============================================================================



static void Test_aIp_BFu31i_Vp()
{
  {
    init_simple_test("aIp_BFu31i_Vp");
    static STRUCT_IF_C aIp_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aIp_BFu31i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31i_Vp");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31i_Vp, aIp_BFu31i_Vp)
//============================================================================



static void Test_aIp_BFu31ll()
{
  {
    init_simple_test("aIp_BFu31ll");
    static STRUCT_IF_C aIp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll, aIp_BFu31ll)
//============================================================================



static void Test_aIp_BFu31ll_BFu15i()
{
  {
    init_simple_test("aIp_BFu31ll_BFu15i");
    static STRUCT_IF_C aIp_BFu31ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, 1, "aIp_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, hide_ull(1LL<<14), "aIp_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu15i, aIp_BFu31ll_BFu15i)
//============================================================================



static void Test_aIp_BFu31ll_BFu15ll()
{
  {
    init_simple_test("aIp_BFu31ll_BFu15ll");
    static STRUCT_IF_C aIp_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, 1, "aIp_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, hide_ull(1LL<<14), "aIp_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu15ll, aIp_BFu31ll_BFu15ll)
//============================================================================



static void Test_aIp_BFu31ll_BFu15s()
{
  {
    init_simple_test("aIp_BFu31ll_BFu15s");
    static STRUCT_IF_C aIp_BFu31ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, 1, "aIp_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 15, hide_ull(1LL<<14), "aIp_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu15s, aIp_BFu31ll_BFu15s)
//============================================================================



static void Test_aIp_BFu31ll_BFu16i()
{
  {
    init_simple_test("aIp_BFu31ll_BFu16i");
    static STRUCT_IF_C aIp_BFu31ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, 1, "aIp_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, hide_ull(1LL<<15), "aIp_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu16i, aIp_BFu31ll_BFu16i)
//============================================================================



static void Test_aIp_BFu31ll_BFu16ll()
{
  {
    init_simple_test("aIp_BFu31ll_BFu16ll");
    static STRUCT_IF_C aIp_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, 1, "aIp_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, hide_ull(1LL<<15), "aIp_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu16ll, aIp_BFu31ll_BFu16ll)
//============================================================================



static void Test_aIp_BFu31ll_BFu16s()
{
  {
    init_simple_test("aIp_BFu31ll_BFu16s");
    static STRUCT_IF_C aIp_BFu31ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, 1, "aIp_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 16, hide_ull(1LL<<15), "aIp_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu16s, aIp_BFu31ll_BFu16s)
//============================================================================



static void Test_aIp_BFu31ll_BFu17i()
{
  {
    init_simple_test("aIp_BFu31ll_BFu17i");
    static STRUCT_IF_C aIp_BFu31ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, 1, "aIp_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, hide_ull(1LL<<16), "aIp_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu17i, aIp_BFu31ll_BFu17i)
//============================================================================



static void Test_aIp_BFu31ll_BFu17ll()
{
  {
    init_simple_test("aIp_BFu31ll_BFu17ll");
    static STRUCT_IF_C aIp_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, 1, "aIp_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 17, hide_ull(1LL<<16), "aIp_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu17ll, aIp_BFu31ll_BFu17ll)
//============================================================================



static void Test_aIp_BFu31ll_BFu1c()
{
  {
    init_simple_test("aIp_BFu31ll_BFu1c");
    static STRUCT_IF_C aIp_BFu31ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu31ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "aIp_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu1c, aIp_BFu31ll_BFu1c)
//============================================================================



static void Test_aIp_BFu31ll_BFu1i()
{
  {
    init_simple_test("aIp_BFu31ll_BFu1i");
    static STRUCT_IF_C aIp_BFu31ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu31ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "aIp_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu1i, aIp_BFu31ll_BFu1i)
//============================================================================



static void Test_aIp_BFu31ll_BFu1ll()
{
  {
    init_simple_test("aIp_BFu31ll_BFu1ll");
    static STRUCT_IF_C aIp_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "aIp_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu1ll, aIp_BFu31ll_BFu1ll)
//============================================================================



static void Test_aIp_BFu31ll_BFu1s()
{
  {
    init_simple_test("aIp_BFu31ll_BFu1s");
    static STRUCT_IF_C aIp_BFu31ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu31ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 1, 1, "aIp_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu1s, aIp_BFu31ll_BFu1s)
//============================================================================



static void Test_aIp_BFu31ll_BFu31i()
{
  {
    init_simple_test("aIp_BFu31ll_BFu31i");
    static STRUCT_IF_C aIp_BFu31ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, 1, "aIp_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu31i, aIp_BFu31ll_BFu31i)
//============================================================================



static void Test_aIp_BFu31ll_BFu31ll()
{
  {
    init_simple_test("aIp_BFu31ll_BFu31ll");
    static STRUCT_IF_C aIp_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, 1, "aIp_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu31ll, aIp_BFu31ll_BFu31ll)
//============================================================================



static void Test_aIp_BFu31ll_BFu32i()
{
  {
    init_simple_test("aIp_BFu31ll_BFu32i");
    static STRUCT_IF_C aIp_BFu31ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, 1, "aIp_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, hide_ull(1LL<<31), "aIp_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu32i, aIp_BFu31ll_BFu32i)
//============================================================================



static void Test_aIp_BFu31ll_BFu32ll()
{
  {
    init_simple_test("aIp_BFu31ll_BFu32ll");
    static STRUCT_IF_C aIp_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, 1, "aIp_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 32, hide_ull(1LL<<31), "aIp_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu32ll, aIp_BFu31ll_BFu32ll)
//============================================================================



static void Test_aIp_BFu31ll_BFu33()
{
  {
    init_simple_test("aIp_BFu31ll_BFu33");
    static STRUCT_IF_C aIp_BFu31ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 33, 1, "aIp_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 33, hide_ull(1LL<<32), "aIp_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu33, aIp_BFu31ll_BFu33)
//============================================================================



static void Test_aIp_BFu31ll_BFu7c()
{
  {
    init_simple_test("aIp_BFu31ll_BFu7c");
    static STRUCT_IF_C aIp_BFu31ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "aIp_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "aIp_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu7c, aIp_BFu31ll_BFu7c)
//============================================================================



static void Test_aIp_BFu31ll_BFu7i()
{
  {
    init_simple_test("aIp_BFu31ll_BFu7i");
    static STRUCT_IF_C aIp_BFu31ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "aIp_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "aIp_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu7i, aIp_BFu31ll_BFu7i)
//============================================================================



static void Test_aIp_BFu31ll_BFu7ll()
{
  {
    init_simple_test("aIp_BFu31ll_BFu7ll");
    static STRUCT_IF_C aIp_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "aIp_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "aIp_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu7ll, aIp_BFu31ll_BFu7ll)
//============================================================================



static void Test_aIp_BFu31ll_BFu7s()
{
  {
    init_simple_test("aIp_BFu31ll_BFu7s");
    static STRUCT_IF_C aIp_BFu31ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, 1, "aIp_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 7, hide_ull(1LL<<6), "aIp_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu7s, aIp_BFu31ll_BFu7s)
//============================================================================



static void Test_aIp_BFu31ll_BFu8c()
{
  {
    init_simple_test("aIp_BFu31ll_BFu8c");
    static STRUCT_IF_C aIp_BFu31ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "aIp_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "aIp_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu8c, aIp_BFu31ll_BFu8c)
//============================================================================



static void Test_aIp_BFu31ll_BFu8i()
{
  {
    init_simple_test("aIp_BFu31ll_BFu8i");
    static STRUCT_IF_C aIp_BFu31ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "aIp_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "aIp_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu8i, aIp_BFu31ll_BFu8i)
//============================================================================



static void Test_aIp_BFu31ll_BFu8ll()
{
  {
    init_simple_test("aIp_BFu31ll_BFu8ll");
    static STRUCT_IF_C aIp_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "aIp_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "aIp_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu8ll, aIp_BFu31ll_BFu8ll)
//============================================================================



static void Test_aIp_BFu31ll_BFu8s()
{
  {
    init_simple_test("aIp_BFu31ll_BFu8s");
    static STRUCT_IF_C aIp_BFu31ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, 1, "aIp_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 8, hide_ull(1LL<<7), "aIp_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu8s, aIp_BFu31ll_BFu8s)
//============================================================================



static void Test_aIp_BFu31ll_BFu9i()
{
  {
    init_simple_test("aIp_BFu31ll_BFu9i");
    static STRUCT_IF_C aIp_BFu31ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, 1, "aIp_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, hide_ull(1LL<<8), "aIp_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu9i, aIp_BFu31ll_BFu9i)
//============================================================================



static void Test_aIp_BFu31ll_BFu9ll()
{
  {
    init_simple_test("aIp_BFu31ll_BFu9ll");
    static STRUCT_IF_C aIp_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, 1, "aIp_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, hide_ull(1LL<<8), "aIp_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu9ll, aIp_BFu31ll_BFu9ll)
//============================================================================



static void Test_aIp_BFu31ll_BFu9s()
{
  {
    init_simple_test("aIp_BFu31ll_BFu9s");
    static STRUCT_IF_C aIp_BFu31ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, 1, "aIp_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(11,7), 7, 9, hide_ull(1LL<<8), "aIp_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_BFu9s, aIp_BFu31ll_BFu9s)
//============================================================================



static void Test_aIp_BFu31ll_C()
{
  {
    init_simple_test("aIp_BFu31ll_C");
    static STRUCT_IF_C aIp_BFu31ll_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_C");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_C, aIp_BFu31ll_C)
//============================================================================



static void Test_aIp_BFu31ll_D()
{
  {
    init_simple_test("aIp_BFu31ll_D");
    static STRUCT_IF_C aIp_BFu31ll_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aIp_BFu31ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_D");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_D, aIp_BFu31ll_D)
//============================================================================



static void Test_aIp_BFu31ll_F()
{
  {
    init_simple_test("aIp_BFu31ll_F");
    static STRUCT_IF_C aIp_BFu31ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_F, aIp_BFu31ll_F)
//============================================================================



static void Test_aIp_BFu31ll_I()
{
  {
    init_simple_test("aIp_BFu31ll_I");
    static STRUCT_IF_C aIp_BFu31ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_I, aIp_BFu31ll_I)
//============================================================================



static void Test_aIp_BFu31ll_Ip()
{
  {
    init_simple_test("aIp_BFu31ll_Ip");
    static STRUCT_IF_C aIp_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aIp_BFu31ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_Ip");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_Ip, aIp_BFu31ll_Ip)
//============================================================================



static void Test_aIp_BFu31ll_L()
{
  {
    init_simple_test("aIp_BFu31ll_L");
    static STRUCT_IF_C aIp_BFu31ll_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aIp_BFu31ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_L");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_L, aIp_BFu31ll_L)
//============================================================================



static void Test_aIp_BFu31ll_S()
{
  {
    init_simple_test("aIp_BFu31ll_S");
    static STRUCT_IF_C aIp_BFu31ll_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_S, aIp_BFu31ll_S)
//============================================================================



static void Test_aIp_BFu31ll_Uc()
{
  {
    init_simple_test("aIp_BFu31ll_Uc");
    static STRUCT_IF_C aIp_BFu31ll_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu31ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_Uc");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_Uc, aIp_BFu31ll_Uc)
//============================================================================



static void Test_aIp_BFu31ll_Ui()
{
  {
    init_simple_test("aIp_BFu31ll_Ui");
    static STRUCT_IF_C aIp_BFu31ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu31ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_Ui, aIp_BFu31ll_Ui)
//============================================================================



static void Test_aIp_BFu31ll_Ul()
{
  {
    init_simple_test("aIp_BFu31ll_Ul");
    static STRUCT_IF_C aIp_BFu31ll_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aIp_BFu31ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_Ul");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_Ul, aIp_BFu31ll_Ul)
//============================================================================



static void Test_aIp_BFu31ll_Us()
{
  {
    init_simple_test("aIp_BFu31ll_Us");
    static STRUCT_IF_C aIp_BFu31ll_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu31ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_Us, aIp_BFu31ll_Us)
//============================================================================



static void Test_aIp_BFu31ll_Vp()
{
  {
    init_simple_test("aIp_BFu31ll_Vp");
    static STRUCT_IF_C aIp_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aIp_BFu31ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, 1, "aIp_BFu31ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 31, hide_ull(1LL<<30), "aIp_BFu31ll_Vp");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu31ll_Vp, aIp_BFu31ll_Vp)
//============================================================================



static void Test_aIp_BFu32i()
{
  {
    init_simple_test("aIp_BFu32i");
    static STRUCT_IF_C aIp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i, aIp_BFu32i)
//============================================================================



static void Test_aIp_BFu32i_BFu15i()
{
  {
    init_simple_test("aIp_BFu32i_BFu15i");
    static STRUCT_IF_C aIp_BFu32i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aIp_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aIp_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu15i, aIp_BFu32i_BFu15i)
//============================================================================



static void Test_aIp_BFu32i_BFu15ll()
{
  {
    init_simple_test("aIp_BFu32i_BFu15ll");
    static STRUCT_IF_C aIp_BFu32i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aIp_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aIp_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu15ll, aIp_BFu32i_BFu15ll)
//============================================================================



static void Test_aIp_BFu32i_BFu15s()
{
  {
    init_simple_test("aIp_BFu32i_BFu15s");
    static STRUCT_IF_C aIp_BFu32i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aIp_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aIp_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu15s, aIp_BFu32i_BFu15s)
//============================================================================



static void Test_aIp_BFu32i_BFu16i()
{
  {
    init_simple_test("aIp_BFu32i_BFu16i");
    static STRUCT_IF_C aIp_BFu32i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aIp_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aIp_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu16i, aIp_BFu32i_BFu16i)
//============================================================================



static void Test_aIp_BFu32i_BFu16ll()
{
  {
    init_simple_test("aIp_BFu32i_BFu16ll");
    static STRUCT_IF_C aIp_BFu32i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aIp_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aIp_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu16ll, aIp_BFu32i_BFu16ll)
//============================================================================



static void Test_aIp_BFu32i_BFu16s()
{
  {
    init_simple_test("aIp_BFu32i_BFu16s");
    static STRUCT_IF_C aIp_BFu32i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aIp_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aIp_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu16s, aIp_BFu32i_BFu16s)
//============================================================================



static void Test_aIp_BFu32i_BFu17i()
{
  {
    init_simple_test("aIp_BFu32i_BFu17i");
    static STRUCT_IF_C aIp_BFu32i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu32i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "aIp_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "aIp_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu17i, aIp_BFu32i_BFu17i)
//============================================================================



static void Test_aIp_BFu32i_BFu17ll()
{
  {
    init_simple_test("aIp_BFu32i_BFu17ll");
    static STRUCT_IF_C aIp_BFu32i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu32i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "aIp_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "aIp_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu17ll, aIp_BFu32i_BFu17ll)
//============================================================================



static void Test_aIp_BFu32i_BFu1c()
{
  {
    init_simple_test("aIp_BFu32i_BFu1c");
    static STRUCT_IF_C aIp_BFu32i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aIp_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu1c, aIp_BFu32i_BFu1c)
//============================================================================



static void Test_aIp_BFu32i_BFu1i()
{
  {
    init_simple_test("aIp_BFu32i_BFu1i");
    static STRUCT_IF_C aIp_BFu32i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aIp_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu1i, aIp_BFu32i_BFu1i)
//============================================================================



static void Test_aIp_BFu32i_BFu1ll()
{
  {
    init_simple_test("aIp_BFu32i_BFu1ll");
    static STRUCT_IF_C aIp_BFu32i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aIp_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu1ll, aIp_BFu32i_BFu1ll)
//============================================================================



static void Test_aIp_BFu32i_BFu1s()
{
  {
    init_simple_test("aIp_BFu32i_BFu1s");
    static STRUCT_IF_C aIp_BFu32i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aIp_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu1s, aIp_BFu32i_BFu1s)
//============================================================================



static void Test_aIp_BFu32i_BFu31i()
{
  {
    init_simple_test("aIp_BFu32i_BFu31i");
    static STRUCT_IF_C aIp_BFu32i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "aIp_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "aIp_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu31i, aIp_BFu32i_BFu31i)
//============================================================================



static void Test_aIp_BFu32i_BFu31ll()
{
  {
    init_simple_test("aIp_BFu32i_BFu31ll");
    static STRUCT_IF_C aIp_BFu32i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "aIp_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "aIp_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu31ll, aIp_BFu32i_BFu31ll)
//============================================================================



static void Test_aIp_BFu32i_BFu32i()
{
  {
    init_simple_test("aIp_BFu32i_BFu32i");
    static STRUCT_IF_C aIp_BFu32i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "aIp_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu32i, aIp_BFu32i_BFu32i)
//============================================================================



static void Test_aIp_BFu32i_BFu32ll()
{
  {
    init_simple_test("aIp_BFu32i_BFu32ll");
    static STRUCT_IF_C aIp_BFu32i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "aIp_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu32ll, aIp_BFu32i_BFu32ll)
//============================================================================



static void Test_aIp_BFu32i_BFu33()
{
  {
    init_simple_test("aIp_BFu32i_BFu33");
    static STRUCT_IF_C aIp_BFu32i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu32i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, 1, "aIp_BFu32i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, hide_ull(1LL<<32), "aIp_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu33, aIp_BFu32i_BFu33)
//============================================================================



static void Test_aIp_BFu32i_BFu7c()
{
  {
    init_simple_test("aIp_BFu32i_BFu7c");
    static STRUCT_IF_C aIp_BFu32i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aIp_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aIp_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu7c, aIp_BFu32i_BFu7c)
//============================================================================



static void Test_aIp_BFu32i_BFu7i()
{
  {
    init_simple_test("aIp_BFu32i_BFu7i");
    static STRUCT_IF_C aIp_BFu32i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aIp_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aIp_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu7i, aIp_BFu32i_BFu7i)
//============================================================================



static void Test_aIp_BFu32i_BFu7ll()
{
  {
    init_simple_test("aIp_BFu32i_BFu7ll");
    static STRUCT_IF_C aIp_BFu32i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aIp_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aIp_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu7ll, aIp_BFu32i_BFu7ll)
//============================================================================



static void Test_aIp_BFu32i_BFu7s()
{
  {
    init_simple_test("aIp_BFu32i_BFu7s");
    static STRUCT_IF_C aIp_BFu32i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aIp_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aIp_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu7s, aIp_BFu32i_BFu7s)
//============================================================================



static void Test_aIp_BFu32i_BFu8c()
{
  {
    init_simple_test("aIp_BFu32i_BFu8c");
    static STRUCT_IF_C aIp_BFu32i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aIp_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aIp_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu8c, aIp_BFu32i_BFu8c)
//============================================================================



static void Test_aIp_BFu32i_BFu8i()
{
  {
    init_simple_test("aIp_BFu32i_BFu8i");
    static STRUCT_IF_C aIp_BFu32i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aIp_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aIp_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu8i, aIp_BFu32i_BFu8i)
//============================================================================



static void Test_aIp_BFu32i_BFu8ll()
{
  {
    init_simple_test("aIp_BFu32i_BFu8ll");
    static STRUCT_IF_C aIp_BFu32i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aIp_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aIp_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu8ll, aIp_BFu32i_BFu8ll)
//============================================================================



static void Test_aIp_BFu32i_BFu8s()
{
  {
    init_simple_test("aIp_BFu32i_BFu8s");
    static STRUCT_IF_C aIp_BFu32i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aIp_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aIp_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu8s, aIp_BFu32i_BFu8s)
//============================================================================



static void Test_aIp_BFu32i_BFu9i()
{
  {
    init_simple_test("aIp_BFu32i_BFu9i");
    static STRUCT_IF_C aIp_BFu32i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aIp_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aIp_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu9i, aIp_BFu32i_BFu9i)
//============================================================================



static void Test_aIp_BFu32i_BFu9ll()
{
  {
    init_simple_test("aIp_BFu32i_BFu9ll");
    static STRUCT_IF_C aIp_BFu32i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aIp_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aIp_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu9ll, aIp_BFu32i_BFu9ll)
//============================================================================



static void Test_aIp_BFu32i_BFu9s()
{
  {
    init_simple_test("aIp_BFu32i_BFu9s");
    static STRUCT_IF_C aIp_BFu32i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aIp_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aIp_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_BFu9s, aIp_BFu32i_BFu9s)
//============================================================================



static void Test_aIp_BFu32i_C()
{
  {
    init_simple_test("aIp_BFu32i_C");
    static STRUCT_IF_C aIp_BFu32i_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_C");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_C, aIp_BFu32i_C)
//============================================================================



static void Test_aIp_BFu32i_D()
{
  {
    init_simple_test("aIp_BFu32i_D");
    static STRUCT_IF_C aIp_BFu32i_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aIp_BFu32i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_D");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_D, aIp_BFu32i_D)
//============================================================================



static void Test_aIp_BFu32i_F()
{
  {
    init_simple_test("aIp_BFu32i_F");
    static STRUCT_IF_C aIp_BFu32i_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_F, aIp_BFu32i_F)
//============================================================================



static void Test_aIp_BFu32i_I()
{
  {
    init_simple_test("aIp_BFu32i_I");
    static STRUCT_IF_C aIp_BFu32i_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_I, aIp_BFu32i_I)
//============================================================================



static void Test_aIp_BFu32i_Ip()
{
  {
    init_simple_test("aIp_BFu32i_Ip");
    static STRUCT_IF_C aIp_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aIp_BFu32i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_Ip");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_Ip, aIp_BFu32i_Ip)
//============================================================================



static void Test_aIp_BFu32i_L()
{
  {
    init_simple_test("aIp_BFu32i_L");
    static STRUCT_IF_C aIp_BFu32i_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aIp_BFu32i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_L");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_L, aIp_BFu32i_L)
//============================================================================



static void Test_aIp_BFu32i_S()
{
  {
    init_simple_test("aIp_BFu32i_S");
    static STRUCT_IF_C aIp_BFu32i_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_S, aIp_BFu32i_S)
//============================================================================



static void Test_aIp_BFu32i_Uc()
{
  {
    init_simple_test("aIp_BFu32i_Uc");
    static STRUCT_IF_C aIp_BFu32i_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_Uc");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_Uc, aIp_BFu32i_Uc)
//============================================================================



static void Test_aIp_BFu32i_Ui()
{
  {
    init_simple_test("aIp_BFu32i_Ui");
    static STRUCT_IF_C aIp_BFu32i_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_Ui, aIp_BFu32i_Ui)
//============================================================================



static void Test_aIp_BFu32i_Ul()
{
  {
    init_simple_test("aIp_BFu32i_Ul");
    static STRUCT_IF_C aIp_BFu32i_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aIp_BFu32i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_Ul");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_Ul, aIp_BFu32i_Ul)
//============================================================================



static void Test_aIp_BFu32i_Us()
{
  {
    init_simple_test("aIp_BFu32i_Us");
    static STRUCT_IF_C aIp_BFu32i_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_Us, aIp_BFu32i_Us)
//============================================================================



static void Test_aIp_BFu32i_Vp()
{
  {
    init_simple_test("aIp_BFu32i_Vp");
    static STRUCT_IF_C aIp_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aIp_BFu32i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32i_Vp");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32i_Vp, aIp_BFu32i_Vp)
//============================================================================



static void Test_aIp_BFu32ll()
{
  {
    init_simple_test("aIp_BFu32ll");
    static STRUCT_IF_C aIp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll, aIp_BFu32ll)
//============================================================================



static void Test_aIp_BFu32ll_BFu15i()
{
  {
    init_simple_test("aIp_BFu32ll_BFu15i");
    static STRUCT_IF_C aIp_BFu32ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aIp_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aIp_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu15i, aIp_BFu32ll_BFu15i)
//============================================================================



static void Test_aIp_BFu32ll_BFu15ll()
{
  {
    init_simple_test("aIp_BFu32ll_BFu15ll");
    static STRUCT_IF_C aIp_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aIp_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aIp_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu15ll, aIp_BFu32ll_BFu15ll)
//============================================================================



static void Test_aIp_BFu32ll_BFu15s()
{
  {
    init_simple_test("aIp_BFu32ll_BFu15s");
    static STRUCT_IF_C aIp_BFu32ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aIp_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aIp_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu15s, aIp_BFu32ll_BFu15s)
//============================================================================



static void Test_aIp_BFu32ll_BFu16i()
{
  {
    init_simple_test("aIp_BFu32ll_BFu16i");
    static STRUCT_IF_C aIp_BFu32ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aIp_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aIp_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu16i, aIp_BFu32ll_BFu16i)
//============================================================================



static void Test_aIp_BFu32ll_BFu16ll()
{
  {
    init_simple_test("aIp_BFu32ll_BFu16ll");
    static STRUCT_IF_C aIp_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aIp_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aIp_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu16ll, aIp_BFu32ll_BFu16ll)
//============================================================================



static void Test_aIp_BFu32ll_BFu16s()
{
  {
    init_simple_test("aIp_BFu32ll_BFu16s");
    static STRUCT_IF_C aIp_BFu32ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aIp_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aIp_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu16s, aIp_BFu32ll_BFu16s)
//============================================================================



static void Test_aIp_BFu32ll_BFu17i()
{
  {
    init_simple_test("aIp_BFu32ll_BFu17i");
    static STRUCT_IF_C aIp_BFu32ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu32ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "aIp_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "aIp_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu17i, aIp_BFu32ll_BFu17i)
//============================================================================



static void Test_aIp_BFu32ll_BFu17ll()
{
  {
    init_simple_test("aIp_BFu32ll_BFu17ll");
    static STRUCT_IF_C aIp_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "aIp_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "aIp_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu17ll, aIp_BFu32ll_BFu17ll)
//============================================================================



static void Test_aIp_BFu32ll_BFu1c()
{
  {
    init_simple_test("aIp_BFu32ll_BFu1c");
    static STRUCT_IF_C aIp_BFu32ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aIp_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu1c, aIp_BFu32ll_BFu1c)
//============================================================================



static void Test_aIp_BFu32ll_BFu1i()
{
  {
    init_simple_test("aIp_BFu32ll_BFu1i");
    static STRUCT_IF_C aIp_BFu32ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aIp_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu1i, aIp_BFu32ll_BFu1i)
//============================================================================



static void Test_aIp_BFu32ll_BFu1ll()
{
  {
    init_simple_test("aIp_BFu32ll_BFu1ll");
    static STRUCT_IF_C aIp_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aIp_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu1ll, aIp_BFu32ll_BFu1ll)
//============================================================================



static void Test_aIp_BFu32ll_BFu1s()
{
  {
    init_simple_test("aIp_BFu32ll_BFu1s");
    static STRUCT_IF_C aIp_BFu32ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aIp_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu1s, aIp_BFu32ll_BFu1s)
//============================================================================



static void Test_aIp_BFu32ll_BFu31i()
{
  {
    init_simple_test("aIp_BFu32ll_BFu31i");
    static STRUCT_IF_C aIp_BFu32ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "aIp_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "aIp_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu31i, aIp_BFu32ll_BFu31i)
//============================================================================



static void Test_aIp_BFu32ll_BFu31ll()
{
  {
    init_simple_test("aIp_BFu32ll_BFu31ll");
    static STRUCT_IF_C aIp_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "aIp_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "aIp_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu31ll, aIp_BFu32ll_BFu31ll)
//============================================================================



static void Test_aIp_BFu32ll_BFu32i()
{
  {
    init_simple_test("aIp_BFu32ll_BFu32i");
    static STRUCT_IF_C aIp_BFu32ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "aIp_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu32i, aIp_BFu32ll_BFu32i)
//============================================================================



static void Test_aIp_BFu32ll_BFu32ll()
{
  {
    init_simple_test("aIp_BFu32ll_BFu32ll");
    static STRUCT_IF_C aIp_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "aIp_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu32ll, aIp_BFu32ll_BFu32ll)
//============================================================================



static void Test_aIp_BFu32ll_BFu33()
{
  {
    init_simple_test("aIp_BFu32ll_BFu33");
    static STRUCT_IF_C aIp_BFu32ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu32ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, 1, "aIp_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, hide_ull(1LL<<32), "aIp_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu33, aIp_BFu32ll_BFu33)
//============================================================================



static void Test_aIp_BFu32ll_BFu7c()
{
  {
    init_simple_test("aIp_BFu32ll_BFu7c");
    static STRUCT_IF_C aIp_BFu32ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aIp_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aIp_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu7c, aIp_BFu32ll_BFu7c)
//============================================================================



static void Test_aIp_BFu32ll_BFu7i()
{
  {
    init_simple_test("aIp_BFu32ll_BFu7i");
    static STRUCT_IF_C aIp_BFu32ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aIp_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aIp_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu7i, aIp_BFu32ll_BFu7i)
//============================================================================



static void Test_aIp_BFu32ll_BFu7ll()
{
  {
    init_simple_test("aIp_BFu32ll_BFu7ll");
    static STRUCT_IF_C aIp_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aIp_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aIp_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu7ll, aIp_BFu32ll_BFu7ll)
//============================================================================



static void Test_aIp_BFu32ll_BFu7s()
{
  {
    init_simple_test("aIp_BFu32ll_BFu7s");
    static STRUCT_IF_C aIp_BFu32ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aIp_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aIp_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu7s, aIp_BFu32ll_BFu7s)
//============================================================================



static void Test_aIp_BFu32ll_BFu8c()
{
  {
    init_simple_test("aIp_BFu32ll_BFu8c");
    static STRUCT_IF_C aIp_BFu32ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aIp_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aIp_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu8c, aIp_BFu32ll_BFu8c)
//============================================================================



static void Test_aIp_BFu32ll_BFu8i()
{
  {
    init_simple_test("aIp_BFu32ll_BFu8i");
    static STRUCT_IF_C aIp_BFu32ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aIp_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aIp_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu8i, aIp_BFu32ll_BFu8i)
//============================================================================



static void Test_aIp_BFu32ll_BFu8ll()
{
  {
    init_simple_test("aIp_BFu32ll_BFu8ll");
    static STRUCT_IF_C aIp_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aIp_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aIp_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu8ll, aIp_BFu32ll_BFu8ll)
//============================================================================



static void Test_aIp_BFu32ll_BFu8s()
{
  {
    init_simple_test("aIp_BFu32ll_BFu8s");
    static STRUCT_IF_C aIp_BFu32ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aIp_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aIp_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu8s, aIp_BFu32ll_BFu8s)
//============================================================================



static void Test_aIp_BFu32ll_BFu9i()
{
  {
    init_simple_test("aIp_BFu32ll_BFu9i");
    static STRUCT_IF_C aIp_BFu32ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aIp_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aIp_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu9i, aIp_BFu32ll_BFu9i)
//============================================================================



static void Test_aIp_BFu32ll_BFu9ll()
{
  {
    init_simple_test("aIp_BFu32ll_BFu9ll");
    static STRUCT_IF_C aIp_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aIp_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aIp_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu9ll, aIp_BFu32ll_BFu9ll)
//============================================================================



static void Test_aIp_BFu32ll_BFu9s()
{
  {
    init_simple_test("aIp_BFu32ll_BFu9s");
    static STRUCT_IF_C aIp_BFu32ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aIp_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aIp_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_BFu9s, aIp_BFu32ll_BFu9s)
//============================================================================



static void Test_aIp_BFu32ll_C()
{
  {
    init_simple_test("aIp_BFu32ll_C");
    static STRUCT_IF_C aIp_BFu32ll_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_C");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_C, aIp_BFu32ll_C)
//============================================================================



static void Test_aIp_BFu32ll_D()
{
  {
    init_simple_test("aIp_BFu32ll_D");
    static STRUCT_IF_C aIp_BFu32ll_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aIp_BFu32ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_D");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_D, aIp_BFu32ll_D)
//============================================================================



static void Test_aIp_BFu32ll_F()
{
  {
    init_simple_test("aIp_BFu32ll_F");
    static STRUCT_IF_C aIp_BFu32ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_F");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_F, aIp_BFu32ll_F)
//============================================================================



static void Test_aIp_BFu32ll_I()
{
  {
    init_simple_test("aIp_BFu32ll_I");
    static STRUCT_IF_C aIp_BFu32ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_I");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_I, aIp_BFu32ll_I)
//============================================================================



static void Test_aIp_BFu32ll_Ip()
{
  {
    init_simple_test("aIp_BFu32ll_Ip");
    static STRUCT_IF_C aIp_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aIp_BFu32ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_Ip");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_Ip, aIp_BFu32ll_Ip)
//============================================================================



static void Test_aIp_BFu32ll_L()
{
  {
    init_simple_test("aIp_BFu32ll_L");
    static STRUCT_IF_C aIp_BFu32ll_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aIp_BFu32ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_L");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_L, aIp_BFu32ll_L)
//============================================================================



static void Test_aIp_BFu32ll_S()
{
  {
    init_simple_test("aIp_BFu32ll_S");
    static STRUCT_IF_C aIp_BFu32ll_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_S");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_S, aIp_BFu32ll_S)
//============================================================================



static void Test_aIp_BFu32ll_Uc()
{
  {
    init_simple_test("aIp_BFu32ll_Uc");
    static STRUCT_IF_C aIp_BFu32ll_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu32ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_Uc");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_Uc, aIp_BFu32ll_Uc)
//============================================================================



static void Test_aIp_BFu32ll_Ui()
{
  {
    init_simple_test("aIp_BFu32ll_Ui");
    static STRUCT_IF_C aIp_BFu32ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu32ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_Ui");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_Ui, aIp_BFu32ll_Ui)
//============================================================================



static void Test_aIp_BFu32ll_Ul()
{
  {
    init_simple_test("aIp_BFu32ll_Ul");
    static STRUCT_IF_C aIp_BFu32ll_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aIp_BFu32ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_Ul");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_Ul, aIp_BFu32ll_Ul)
//============================================================================



static void Test_aIp_BFu32ll_Us()
{
  {
    init_simple_test("aIp_BFu32ll_Us");
    static STRUCT_IF_C aIp_BFu32ll_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu32ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_Us");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_Us, aIp_BFu32ll_Us)
//============================================================================



static void Test_aIp_BFu32ll_Vp()
{
  {
    init_simple_test("aIp_BFu32ll_Vp");
    static STRUCT_IF_C aIp_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aIp_BFu32ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, 1, "aIp_BFu32ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 32, hide_ull(1LL<<31), "aIp_BFu32ll_Vp");
    check_field_offset(lv, v3, ABISELECT(12,8), "aIp_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu32ll_Vp, aIp_BFu32ll_Vp)
//============================================================================



static void Test_aIp_BFu33()
{
  {
    init_simple_test("aIp_BFu33");
    static STRUCT_IF_C aIp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33, aIp_BFu33)
//============================================================================



static void Test_aIp_BFu33_BFu15i()
{
  {
    init_simple_test("aIp_BFu33_BFu15i");
    static STRUCT_IF_C aIp_BFu33_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu33_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "aIp_BFu33_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "aIp_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu15i, aIp_BFu33_BFu15i)
//============================================================================



static void Test_aIp_BFu33_BFu15ll()
{
  {
    init_simple_test("aIp_BFu33_BFu15ll");
    static STRUCT_IF_C aIp_BFu33_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu33_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "aIp_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "aIp_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu15ll, aIp_BFu33_BFu15ll)
//============================================================================



static void Test_aIp_BFu33_BFu15s()
{
  {
    init_simple_test("aIp_BFu33_BFu15s");
    static STRUCT_IF_C aIp_BFu33_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu33_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, 1, "aIp_BFu33_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 15, hide_ull(1LL<<14), "aIp_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu15s, aIp_BFu33_BFu15s)
//============================================================================



static void Test_aIp_BFu33_BFu16i()
{
  {
    init_simple_test("aIp_BFu33_BFu16i");
    static STRUCT_IF_C aIp_BFu33_BFu16i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu33_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "aIp_BFu33_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "aIp_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu16i, aIp_BFu33_BFu16i)
//============================================================================



static void Test_aIp_BFu33_BFu16ll()
{
  {
    init_simple_test("aIp_BFu33_BFu16ll");
    static STRUCT_IF_C aIp_BFu33_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu33_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "aIp_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "aIp_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu16ll, aIp_BFu33_BFu16ll)
//============================================================================



static void Test_aIp_BFu33_BFu16s()
{
  {
    init_simple_test("aIp_BFu33_BFu16s");
    static STRUCT_IF_C aIp_BFu33_BFu16s lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu33_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, 1, "aIp_BFu33_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 16, hide_ull(1LL<<15), "aIp_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu16s, aIp_BFu33_BFu16s)
//============================================================================



static void Test_aIp_BFu33_BFu17i()
{
  {
    init_simple_test("aIp_BFu33_BFu17i");
    static STRUCT_IF_C aIp_BFu33_BFu17i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu33_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, 1, "aIp_BFu33_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, hide_ull(1LL<<16), "aIp_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu17i, aIp_BFu33_BFu17i)
//============================================================================



static void Test_aIp_BFu33_BFu17ll()
{
  {
    init_simple_test("aIp_BFu33_BFu17ll");
    static STRUCT_IF_C aIp_BFu33_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu33_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, 1, "aIp_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 17, hide_ull(1LL<<16), "aIp_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu17ll, aIp_BFu33_BFu17ll)
//============================================================================



static void Test_aIp_BFu33_BFu1c()
{
  {
    init_simple_test("aIp_BFu33_BFu1c");
    static STRUCT_IF_C aIp_BFu33_BFu1c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu33_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "aIp_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu1c, aIp_BFu33_BFu1c)
//============================================================================



static void Test_aIp_BFu33_BFu1i()
{
  {
    init_simple_test("aIp_BFu33_BFu1i");
    static STRUCT_IF_C aIp_BFu33_BFu1i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu33_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "aIp_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu1i, aIp_BFu33_BFu1i)
//============================================================================



static void Test_aIp_BFu33_BFu1ll()
{
  {
    init_simple_test("aIp_BFu33_BFu1ll");
    static STRUCT_IF_C aIp_BFu33_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu33_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "aIp_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu1ll, aIp_BFu33_BFu1ll)
//============================================================================



static void Test_aIp_BFu33_BFu1s()
{
  {
    init_simple_test("aIp_BFu33_BFu1s");
    static STRUCT_IF_C aIp_BFu33_BFu1s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu33_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 1, 1, "aIp_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu1s, aIp_BFu33_BFu1s)
//============================================================================



static void Test_aIp_BFu33_BFu31i()
{
  {
    init_simple_test("aIp_BFu33_BFu31i");
    static STRUCT_IF_C aIp_BFu33_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu33_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, 1, "aIp_BFu33_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, hide_ull(1LL<<30), "aIp_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu31i, aIp_BFu33_BFu31i)
//============================================================================



static void Test_aIp_BFu33_BFu31ll()
{
  {
    init_simple_test("aIp_BFu33_BFu31ll");
    static STRUCT_IF_C aIp_BFu33_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aIp_BFu33_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, 1, "aIp_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 31, hide_ull(1LL<<30), "aIp_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu31ll, aIp_BFu33_BFu31ll)
//============================================================================



static void Test_aIp_BFu33_BFu32i()
{
  {
    init_simple_test("aIp_BFu33_BFu32i");
    static STRUCT_IF_C aIp_BFu33_BFu32i lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu33_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 32, 1, "aIp_BFu33_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 32, hide_ull(1LL<<31), "aIp_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu32i, aIp_BFu33_BFu32i)
//============================================================================



static void Test_aIp_BFu33_BFu32ll()
{
  {
    init_simple_test("aIp_BFu33_BFu32ll");
    static STRUCT_IF_C aIp_BFu33_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu33_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 32, 1, "aIp_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 32, hide_ull(1LL<<31), "aIp_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu32ll, aIp_BFu33_BFu32ll)
//============================================================================



static void Test_aIp_BFu33_BFu33()
{
  {
    init_simple_test("aIp_BFu33_BFu33");
    static STRUCT_IF_C aIp_BFu33_BFu33 lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu33_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 33, 1, "aIp_BFu33_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu33, aIp_BFu33_BFu33)
//============================================================================



static void Test_aIp_BFu33_BFu7c()
{
  {
    init_simple_test("aIp_BFu33_BFu7c");
    static STRUCT_IF_C aIp_BFu33_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu33_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "aIp_BFu33_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "aIp_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu7c, aIp_BFu33_BFu7c)
//============================================================================



static void Test_aIp_BFu33_BFu7i()
{
  {
    init_simple_test("aIp_BFu33_BFu7i");
    static STRUCT_IF_C aIp_BFu33_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu33_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "aIp_BFu33_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "aIp_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu7i, aIp_BFu33_BFu7i)
//============================================================================



static void Test_aIp_BFu33_BFu7ll()
{
  {
    init_simple_test("aIp_BFu33_BFu7ll");
    static STRUCT_IF_C aIp_BFu33_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu33_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "aIp_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "aIp_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu7ll, aIp_BFu33_BFu7ll)
//============================================================================



static void Test_aIp_BFu33_BFu7s()
{
  {
    init_simple_test("aIp_BFu33_BFu7s");
    static STRUCT_IF_C aIp_BFu33_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu33_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, 1, "aIp_BFu33_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 7, hide_ull(1LL<<6), "aIp_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu7s, aIp_BFu33_BFu7s)
//============================================================================



static void Test_aIp_BFu33_BFu8c()
{
  {
    init_simple_test("aIp_BFu33_BFu8c");
    static STRUCT_IF_C aIp_BFu33_BFu8c lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu33_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "aIp_BFu33_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "aIp_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu8c, aIp_BFu33_BFu8c)
//============================================================================



static void Test_aIp_BFu33_BFu8i()
{
  {
    init_simple_test("aIp_BFu33_BFu8i");
    static STRUCT_IF_C aIp_BFu33_BFu8i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu33_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "aIp_BFu33_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "aIp_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu8i, aIp_BFu33_BFu8i)
//============================================================================



static void Test_aIp_BFu33_BFu8ll()
{
  {
    init_simple_test("aIp_BFu33_BFu8ll");
    static STRUCT_IF_C aIp_BFu33_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu33_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "aIp_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "aIp_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu8ll, aIp_BFu33_BFu8ll)
//============================================================================



static void Test_aIp_BFu33_BFu8s()
{
  {
    init_simple_test("aIp_BFu33_BFu8s");
    static STRUCT_IF_C aIp_BFu33_BFu8s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu33_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, 1, "aIp_BFu33_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 8, hide_ull(1LL<<7), "aIp_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu8s, aIp_BFu33_BFu8s)
//============================================================================



static void Test_aIp_BFu33_BFu9i()
{
  {
    init_simple_test("aIp_BFu33_BFu9i");
    static STRUCT_IF_C aIp_BFu33_BFu9i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu33_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "aIp_BFu33_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "aIp_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu9i, aIp_BFu33_BFu9i)
//============================================================================



static void Test_aIp_BFu33_BFu9ll()
{
  {
    init_simple_test("aIp_BFu33_BFu9ll");
    static STRUCT_IF_C aIp_BFu33_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu33_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "aIp_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "aIp_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu9ll, aIp_BFu33_BFu9ll)
//============================================================================



static void Test_aIp_BFu33_BFu9s()
{
  {
    init_simple_test("aIp_BFu33_BFu9s");
    static STRUCT_IF_C aIp_BFu33_BFu9s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu33_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, 1, "aIp_BFu33_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 1, 9, hide_ull(1LL<<8), "aIp_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_BFu9s, aIp_BFu33_BFu9s)
//============================================================================



static void Test_aIp_BFu33_C()
{
  {
    init_simple_test("aIp_BFu33_C");
    static STRUCT_IF_C aIp_BFu33_C lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu33_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_C");
    check_field_offset(lv, v3, ABISELECT(13,9), "aIp_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_C, aIp_BFu33_C)
//============================================================================



static void Test_aIp_BFu33_D()
{
  {
    init_simple_test("aIp_BFu33_D");
    static STRUCT_IF_C aIp_BFu33_D lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(aIp_BFu33_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_D");
    check_field_offset(lv, v3, ABISELECT(13,9), "aIp_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_D, aIp_BFu33_D)
//============================================================================



static void Test_aIp_BFu33_F()
{
  {
    init_simple_test("aIp_BFu33_F");
    static STRUCT_IF_C aIp_BFu33_F lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu33_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_F");
    check_field_offset(lv, v3, ABISELECT(13,9), "aIp_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_F, aIp_BFu33_F)
//============================================================================



static void Test_aIp_BFu33_I()
{
  {
    init_simple_test("aIp_BFu33_I");
    static STRUCT_IF_C aIp_BFu33_I lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu33_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_I");
    check_field_offset(lv, v3, ABISELECT(13,9), "aIp_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_I, aIp_BFu33_I)
//============================================================================



static void Test_aIp_BFu33_Ip()
{
  {
    init_simple_test("aIp_BFu33_Ip");
    static STRUCT_IF_C aIp_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(21,13), "sizeof(aIp_BFu33_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_Ip");
    check_field_offset(lv, v3, ABISELECT(13,9), "aIp_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_Ip, aIp_BFu33_Ip)
//============================================================================



static void Test_aIp_BFu33_L()
{
  {
    init_simple_test("aIp_BFu33_L");
    static STRUCT_IF_C aIp_BFu33_L lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(aIp_BFu33_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_L");
    check_field_offset(lv, v3, ABISELECT(13,9), "aIp_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_L, aIp_BFu33_L)
//============================================================================



static void Test_aIp_BFu33_S()
{
  {
    init_simple_test("aIp_BFu33_S");
    static STRUCT_IF_C aIp_BFu33_S lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu33_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_S");
    check_field_offset(lv, v3, ABISELECT(13,9), "aIp_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_S, aIp_BFu33_S)
//============================================================================



static void Test_aIp_BFu33_Uc()
{
  {
    init_simple_test("aIp_BFu33_Uc");
    static STRUCT_IF_C aIp_BFu33_Uc lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu33_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_Uc");
    check_field_offset(lv, v3, ABISELECT(13,9), "aIp_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_Uc, aIp_BFu33_Uc)
//============================================================================



static void Test_aIp_BFu33_Ui()
{
  {
    init_simple_test("aIp_BFu33_Ui");
    static STRUCT_IF_C aIp_BFu33_Ui lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu33_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_Ui");
    check_field_offset(lv, v3, ABISELECT(13,9), "aIp_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_Ui, aIp_BFu33_Ui)
//============================================================================



static void Test_aIp_BFu33_Ul()
{
  {
    init_simple_test("aIp_BFu33_Ul");
    static STRUCT_IF_C aIp_BFu33_Ul lv;
    check2(sizeof(lv), ABISELECT(21,17), "sizeof(aIp_BFu33_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_Ul");
    check_field_offset(lv, v3, ABISELECT(13,9), "aIp_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_Ul, aIp_BFu33_Ul)
//============================================================================



static void Test_aIp_BFu33_Us()
{
  {
    init_simple_test("aIp_BFu33_Us");
    static STRUCT_IF_C aIp_BFu33_Us lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aIp_BFu33_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_Us");
    check_field_offset(lv, v3, ABISELECT(13,9), "aIp_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_Us, aIp_BFu33_Us)
//============================================================================



static void Test_aIp_BFu33_Vp()
{
  {
    init_simple_test("aIp_BFu33_Vp");
    static STRUCT_IF_C aIp_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(21,13), "sizeof(aIp_BFu33_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, 1, "aIp_BFu33_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "aIp_BFu33_Vp");
    check_field_offset(lv, v3, ABISELECT(13,9), "aIp_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu33_Vp, aIp_BFu33_Vp)
//============================================================================



static void Test_aIp_BFu7c()
{
  {
    init_simple_test("aIp_BFu7c");
    static STRUCT_IF_C aIp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c, aIp_BFu7c)
//============================================================================



static void Test_aIp_BFu7c_BFu15i()
{
  {
    init_simple_test("aIp_BFu7c_BFu15i");
    static STRUCT_IF_C aIp_BFu7c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aIp_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aIp_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu15i, aIp_BFu7c_BFu15i)
//============================================================================



static void Test_aIp_BFu7c_BFu15ll()
{
  {
    init_simple_test("aIp_BFu7c_BFu15ll");
    static STRUCT_IF_C aIp_BFu7c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aIp_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aIp_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu15ll, aIp_BFu7c_BFu15ll)
//============================================================================



static void Test_aIp_BFu7c_BFu15s()
{
  {
    init_simple_test("aIp_BFu7c_BFu15s");
    static STRUCT_IF_C aIp_BFu7c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aIp_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aIp_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu15s, aIp_BFu7c_BFu15s)
//============================================================================



static void Test_aIp_BFu7c_BFu16i()
{
  {
    init_simple_test("aIp_BFu7c_BFu16i");
    static STRUCT_IF_C aIp_BFu7c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aIp_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aIp_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu16i, aIp_BFu7c_BFu16i)
//============================================================================



static void Test_aIp_BFu7c_BFu16ll()
{
  {
    init_simple_test("aIp_BFu7c_BFu16ll");
    static STRUCT_IF_C aIp_BFu7c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aIp_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aIp_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu16ll, aIp_BFu7c_BFu16ll)
//============================================================================



static void Test_aIp_BFu7c_BFu16s()
{
  {
    init_simple_test("aIp_BFu7c_BFu16s");
    static STRUCT_IF_C aIp_BFu7c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aIp_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aIp_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu16s, aIp_BFu7c_BFu16s)
//============================================================================



static void Test_aIp_BFu7c_BFu17i()
{
  {
    init_simple_test("aIp_BFu7c_BFu17i");
    static STRUCT_IF_C aIp_BFu7c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aIp_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aIp_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu17i, aIp_BFu7c_BFu17i)
//============================================================================



static void Test_aIp_BFu7c_BFu17ll()
{
  {
    init_simple_test("aIp_BFu7c_BFu17ll");
    static STRUCT_IF_C aIp_BFu7c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aIp_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aIp_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu17ll, aIp_BFu7c_BFu17ll)
//============================================================================



static void Test_aIp_BFu7c_BFu1c()
{
  {
    init_simple_test("aIp_BFu7c_BFu1c");
    static STRUCT_IF_C aIp_BFu7c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu1c, aIp_BFu7c_BFu1c)
//============================================================================



static void Test_aIp_BFu7c_BFu1i()
{
  {
    init_simple_test("aIp_BFu7c_BFu1i");
    static STRUCT_IF_C aIp_BFu7c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu1i, aIp_BFu7c_BFu1i)
//============================================================================



static void Test_aIp_BFu7c_BFu1ll()
{
  {
    init_simple_test("aIp_BFu7c_BFu1ll");
    static STRUCT_IF_C aIp_BFu7c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu1ll, aIp_BFu7c_BFu1ll)
//============================================================================



static void Test_aIp_BFu7c_BFu1s()
{
  {
    init_simple_test("aIp_BFu7c_BFu1s");
    static STRUCT_IF_C aIp_BFu7c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu1s, aIp_BFu7c_BFu1s)
//============================================================================



static void Test_aIp_BFu7c_BFu31i()
{
  {
    init_simple_test("aIp_BFu7c_BFu31i");
    static STRUCT_IF_C aIp_BFu7c_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aIp_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aIp_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu31i, aIp_BFu7c_BFu31i)
//============================================================================



static void Test_aIp_BFu7c_BFu31ll()
{
  {
    init_simple_test("aIp_BFu7c_BFu31ll");
    static STRUCT_IF_C aIp_BFu7c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aIp_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aIp_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu31ll, aIp_BFu7c_BFu31ll)
//============================================================================



static void Test_aIp_BFu7c_BFu32i()
{
  {
    init_simple_test("aIp_BFu7c_BFu32i");
    static STRUCT_IF_C aIp_BFu7c_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aIp_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aIp_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu32i, aIp_BFu7c_BFu32i)
//============================================================================



static void Test_aIp_BFu7c_BFu32ll()
{
  {
    init_simple_test("aIp_BFu7c_BFu32ll");
    static STRUCT_IF_C aIp_BFu7c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aIp_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aIp_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu32ll, aIp_BFu7c_BFu32ll)
//============================================================================



static void Test_aIp_BFu7c_BFu33()
{
  {
    init_simple_test("aIp_BFu7c_BFu33");
    static STRUCT_IF_C aIp_BFu7c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, 1, "aIp_BFu7c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, hide_ull(1LL<<32), "aIp_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu33, aIp_BFu7c_BFu33)
//============================================================================



static void Test_aIp_BFu7c_BFu7c()
{
  {
    init_simple_test("aIp_BFu7c_BFu7c");
    static STRUCT_IF_C aIp_BFu7c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu7c, aIp_BFu7c_BFu7c)
//============================================================================



static void Test_aIp_BFu7c_BFu7i()
{
  {
    init_simple_test("aIp_BFu7c_BFu7i");
    static STRUCT_IF_C aIp_BFu7c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu7i, aIp_BFu7c_BFu7i)
//============================================================================



static void Test_aIp_BFu7c_BFu7ll()
{
  {
    init_simple_test("aIp_BFu7c_BFu7ll");
    static STRUCT_IF_C aIp_BFu7c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu7ll, aIp_BFu7c_BFu7ll)
//============================================================================



static void Test_aIp_BFu7c_BFu7s()
{
  {
    init_simple_test("aIp_BFu7c_BFu7s");
    static STRUCT_IF_C aIp_BFu7c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu7s, aIp_BFu7c_BFu7s)
//============================================================================



static void Test_aIp_BFu7c_BFu8c()
{
  {
    init_simple_test("aIp_BFu7c_BFu8c");
    static STRUCT_IF_C aIp_BFu7c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu8c, aIp_BFu7c_BFu8c)
//============================================================================



static void Test_aIp_BFu7c_BFu8i()
{
  {
    init_simple_test("aIp_BFu7c_BFu8i");
    static STRUCT_IF_C aIp_BFu7c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu8i, aIp_BFu7c_BFu8i)
//============================================================================



static void Test_aIp_BFu7c_BFu8ll()
{
  {
    init_simple_test("aIp_BFu7c_BFu8ll");
    static STRUCT_IF_C aIp_BFu7c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu8ll, aIp_BFu7c_BFu8ll)
//============================================================================



static void Test_aIp_BFu7c_BFu8s()
{
  {
    init_simple_test("aIp_BFu7c_BFu8s");
    static STRUCT_IF_C aIp_BFu7c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu8s, aIp_BFu7c_BFu8s)
//============================================================================



static void Test_aIp_BFu7c_BFu9i()
{
  {
    init_simple_test("aIp_BFu7c_BFu9i");
    static STRUCT_IF_C aIp_BFu7c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aIp_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aIp_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu9i, aIp_BFu7c_BFu9i)
//============================================================================



static void Test_aIp_BFu7c_BFu9ll()
{
  {
    init_simple_test("aIp_BFu7c_BFu9ll");
    static STRUCT_IF_C aIp_BFu7c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aIp_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aIp_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu9ll, aIp_BFu7c_BFu9ll)
//============================================================================



static void Test_aIp_BFu7c_BFu9s()
{
  {
    init_simple_test("aIp_BFu7c_BFu9s");
    static STRUCT_IF_C aIp_BFu7c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aIp_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aIp_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_BFu9s, aIp_BFu7c_BFu9s)
//============================================================================



static void Test_aIp_BFu7c_C()
{
  {
    init_simple_test("aIp_BFu7c_C");
    static STRUCT_IF_C aIp_BFu7c_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_C, aIp_BFu7c_C)
//============================================================================



static void Test_aIp_BFu7c_D()
{
  {
    init_simple_test("aIp_BFu7c_D");
    static STRUCT_IF_C aIp_BFu7c_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu7c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_D, aIp_BFu7c_D)
//============================================================================



static void Test_aIp_BFu7c_F()
{
  {
    init_simple_test("aIp_BFu7c_F");
    static STRUCT_IF_C aIp_BFu7c_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_F, aIp_BFu7c_F)
//============================================================================



static void Test_aIp_BFu7c_I()
{
  {
    init_simple_test("aIp_BFu7c_I");
    static STRUCT_IF_C aIp_BFu7c_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_I, aIp_BFu7c_I)
//============================================================================



static void Test_aIp_BFu7c_Ip()
{
  {
    init_simple_test("aIp_BFu7c_Ip");
    static STRUCT_IF_C aIp_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu7c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_Ip, aIp_BFu7c_Ip)
//============================================================================



static void Test_aIp_BFu7c_L()
{
  {
    init_simple_test("aIp_BFu7c_L");
    static STRUCT_IF_C aIp_BFu7c_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_L, aIp_BFu7c_L)
//============================================================================



static void Test_aIp_BFu7c_S()
{
  {
    init_simple_test("aIp_BFu7c_S");
    static STRUCT_IF_C aIp_BFu7c_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_S, aIp_BFu7c_S)
//============================================================================



static void Test_aIp_BFu7c_Uc()
{
  {
    init_simple_test("aIp_BFu7c_Uc");
    static STRUCT_IF_C aIp_BFu7c_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_Uc, aIp_BFu7c_Uc)
//============================================================================



static void Test_aIp_BFu7c_Ui()
{
  {
    init_simple_test("aIp_BFu7c_Ui");
    static STRUCT_IF_C aIp_BFu7c_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_Ui, aIp_BFu7c_Ui)
//============================================================================



static void Test_aIp_BFu7c_Ul()
{
  {
    init_simple_test("aIp_BFu7c_Ul");
    static STRUCT_IF_C aIp_BFu7c_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_Ul, aIp_BFu7c_Ul)
//============================================================================



static void Test_aIp_BFu7c_Us()
{
  {
    init_simple_test("aIp_BFu7c_Us");
    static STRUCT_IF_C aIp_BFu7c_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_Us, aIp_BFu7c_Us)
//============================================================================



static void Test_aIp_BFu7c_Vp()
{
  {
    init_simple_test("aIp_BFu7c_Vp");
    static STRUCT_IF_C aIp_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7c_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7c_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7c_Vp, aIp_BFu7c_Vp)
//============================================================================



static void Test_aIp_BFu7i()
{
  {
    init_simple_test("aIp_BFu7i");
    static STRUCT_IF_C aIp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i, aIp_BFu7i)
//============================================================================



static void Test_aIp_BFu7i_BFu15i()
{
  {
    init_simple_test("aIp_BFu7i_BFu15i");
    static STRUCT_IF_C aIp_BFu7i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aIp_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aIp_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu15i, aIp_BFu7i_BFu15i)
//============================================================================



static void Test_aIp_BFu7i_BFu15ll()
{
  {
    init_simple_test("aIp_BFu7i_BFu15ll");
    static STRUCT_IF_C aIp_BFu7i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aIp_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aIp_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu15ll, aIp_BFu7i_BFu15ll)
//============================================================================



static void Test_aIp_BFu7i_BFu15s()
{
  {
    init_simple_test("aIp_BFu7i_BFu15s");
    static STRUCT_IF_C aIp_BFu7i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aIp_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aIp_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu15s, aIp_BFu7i_BFu15s)
//============================================================================



static void Test_aIp_BFu7i_BFu16i()
{
  {
    init_simple_test("aIp_BFu7i_BFu16i");
    static STRUCT_IF_C aIp_BFu7i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aIp_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aIp_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu16i, aIp_BFu7i_BFu16i)
//============================================================================



static void Test_aIp_BFu7i_BFu16ll()
{
  {
    init_simple_test("aIp_BFu7i_BFu16ll");
    static STRUCT_IF_C aIp_BFu7i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aIp_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aIp_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu16ll, aIp_BFu7i_BFu16ll)
//============================================================================



static void Test_aIp_BFu7i_BFu16s()
{
  {
    init_simple_test("aIp_BFu7i_BFu16s");
    static STRUCT_IF_C aIp_BFu7i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aIp_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aIp_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu16s, aIp_BFu7i_BFu16s)
//============================================================================



static void Test_aIp_BFu7i_BFu17i()
{
  {
    init_simple_test("aIp_BFu7i_BFu17i");
    static STRUCT_IF_C aIp_BFu7i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aIp_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aIp_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu17i, aIp_BFu7i_BFu17i)
//============================================================================



static void Test_aIp_BFu7i_BFu17ll()
{
  {
    init_simple_test("aIp_BFu7i_BFu17ll");
    static STRUCT_IF_C aIp_BFu7i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aIp_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aIp_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu17ll, aIp_BFu7i_BFu17ll)
//============================================================================



static void Test_aIp_BFu7i_BFu1c()
{
  {
    init_simple_test("aIp_BFu7i_BFu1c");
    static STRUCT_IF_C aIp_BFu7i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu1c, aIp_BFu7i_BFu1c)
//============================================================================



static void Test_aIp_BFu7i_BFu1i()
{
  {
    init_simple_test("aIp_BFu7i_BFu1i");
    static STRUCT_IF_C aIp_BFu7i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu1i, aIp_BFu7i_BFu1i)
//============================================================================



static void Test_aIp_BFu7i_BFu1ll()
{
  {
    init_simple_test("aIp_BFu7i_BFu1ll");
    static STRUCT_IF_C aIp_BFu7i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu1ll, aIp_BFu7i_BFu1ll)
//============================================================================



static void Test_aIp_BFu7i_BFu1s()
{
  {
    init_simple_test("aIp_BFu7i_BFu1s");
    static STRUCT_IF_C aIp_BFu7i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu1s, aIp_BFu7i_BFu1s)
//============================================================================



static void Test_aIp_BFu7i_BFu31i()
{
  {
    init_simple_test("aIp_BFu7i_BFu31i");
    static STRUCT_IF_C aIp_BFu7i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aIp_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aIp_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu31i, aIp_BFu7i_BFu31i)
//============================================================================



static void Test_aIp_BFu7i_BFu31ll()
{
  {
    init_simple_test("aIp_BFu7i_BFu31ll");
    static STRUCT_IF_C aIp_BFu7i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aIp_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aIp_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu31ll, aIp_BFu7i_BFu31ll)
//============================================================================



static void Test_aIp_BFu7i_BFu32i()
{
  {
    init_simple_test("aIp_BFu7i_BFu32i");
    static STRUCT_IF_C aIp_BFu7i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aIp_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aIp_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu32i, aIp_BFu7i_BFu32i)
//============================================================================



static void Test_aIp_BFu7i_BFu32ll()
{
  {
    init_simple_test("aIp_BFu7i_BFu32ll");
    static STRUCT_IF_C aIp_BFu7i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aIp_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aIp_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu32ll, aIp_BFu7i_BFu32ll)
//============================================================================



static void Test_aIp_BFu7i_BFu33()
{
  {
    init_simple_test("aIp_BFu7i_BFu33");
    static STRUCT_IF_C aIp_BFu7i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, 1, "aIp_BFu7i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, hide_ull(1LL<<32), "aIp_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu33, aIp_BFu7i_BFu33)
//============================================================================



static void Test_aIp_BFu7i_BFu7c()
{
  {
    init_simple_test("aIp_BFu7i_BFu7c");
    static STRUCT_IF_C aIp_BFu7i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu7c, aIp_BFu7i_BFu7c)
//============================================================================



static void Test_aIp_BFu7i_BFu7i()
{
  {
    init_simple_test("aIp_BFu7i_BFu7i");
    static STRUCT_IF_C aIp_BFu7i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu7i, aIp_BFu7i_BFu7i)
//============================================================================



static void Test_aIp_BFu7i_BFu7ll()
{
  {
    init_simple_test("aIp_BFu7i_BFu7ll");
    static STRUCT_IF_C aIp_BFu7i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu7ll, aIp_BFu7i_BFu7ll)
//============================================================================



static void Test_aIp_BFu7i_BFu7s()
{
  {
    init_simple_test("aIp_BFu7i_BFu7s");
    static STRUCT_IF_C aIp_BFu7i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu7s, aIp_BFu7i_BFu7s)
//============================================================================



static void Test_aIp_BFu7i_BFu8c()
{
  {
    init_simple_test("aIp_BFu7i_BFu8c");
    static STRUCT_IF_C aIp_BFu7i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu8c, aIp_BFu7i_BFu8c)
//============================================================================



static void Test_aIp_BFu7i_BFu8i()
{
  {
    init_simple_test("aIp_BFu7i_BFu8i");
    static STRUCT_IF_C aIp_BFu7i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu8i, aIp_BFu7i_BFu8i)
//============================================================================



static void Test_aIp_BFu7i_BFu8ll()
{
  {
    init_simple_test("aIp_BFu7i_BFu8ll");
    static STRUCT_IF_C aIp_BFu7i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu8ll, aIp_BFu7i_BFu8ll)
//============================================================================



static void Test_aIp_BFu7i_BFu8s()
{
  {
    init_simple_test("aIp_BFu7i_BFu8s");
    static STRUCT_IF_C aIp_BFu7i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu8s, aIp_BFu7i_BFu8s)
//============================================================================



static void Test_aIp_BFu7i_BFu9i()
{
  {
    init_simple_test("aIp_BFu7i_BFu9i");
    static STRUCT_IF_C aIp_BFu7i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aIp_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aIp_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu9i, aIp_BFu7i_BFu9i)
//============================================================================



static void Test_aIp_BFu7i_BFu9ll()
{
  {
    init_simple_test("aIp_BFu7i_BFu9ll");
    static STRUCT_IF_C aIp_BFu7i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aIp_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aIp_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu9ll, aIp_BFu7i_BFu9ll)
//============================================================================



static void Test_aIp_BFu7i_BFu9s()
{
  {
    init_simple_test("aIp_BFu7i_BFu9s");
    static STRUCT_IF_C aIp_BFu7i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aIp_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aIp_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_BFu9s, aIp_BFu7i_BFu9s)
//============================================================================



static void Test_aIp_BFu7i_C()
{
  {
    init_simple_test("aIp_BFu7i_C");
    static STRUCT_IF_C aIp_BFu7i_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_C, aIp_BFu7i_C)
//============================================================================



static void Test_aIp_BFu7i_D()
{
  {
    init_simple_test("aIp_BFu7i_D");
    static STRUCT_IF_C aIp_BFu7i_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_D, aIp_BFu7i_D)
//============================================================================



static void Test_aIp_BFu7i_F()
{
  {
    init_simple_test("aIp_BFu7i_F");
    static STRUCT_IF_C aIp_BFu7i_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_F, aIp_BFu7i_F)
//============================================================================



static void Test_aIp_BFu7i_I()
{
  {
    init_simple_test("aIp_BFu7i_I");
    static STRUCT_IF_C aIp_BFu7i_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_I, aIp_BFu7i_I)
//============================================================================



static void Test_aIp_BFu7i_Ip()
{
  {
    init_simple_test("aIp_BFu7i_Ip");
    static STRUCT_IF_C aIp_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_Ip, aIp_BFu7i_Ip)
//============================================================================



static void Test_aIp_BFu7i_L()
{
  {
    init_simple_test("aIp_BFu7i_L");
    static STRUCT_IF_C aIp_BFu7i_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_L, aIp_BFu7i_L)
//============================================================================



static void Test_aIp_BFu7i_S()
{
  {
    init_simple_test("aIp_BFu7i_S");
    static STRUCT_IF_C aIp_BFu7i_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_S, aIp_BFu7i_S)
//============================================================================



static void Test_aIp_BFu7i_Uc()
{
  {
    init_simple_test("aIp_BFu7i_Uc");
    static STRUCT_IF_C aIp_BFu7i_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_Uc, aIp_BFu7i_Uc)
//============================================================================



static void Test_aIp_BFu7i_Ui()
{
  {
    init_simple_test("aIp_BFu7i_Ui");
    static STRUCT_IF_C aIp_BFu7i_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_Ui, aIp_BFu7i_Ui)
//============================================================================



static void Test_aIp_BFu7i_Ul()
{
  {
    init_simple_test("aIp_BFu7i_Ul");
    static STRUCT_IF_C aIp_BFu7i_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_Ul, aIp_BFu7i_Ul)
//============================================================================



static void Test_aIp_BFu7i_Us()
{
  {
    init_simple_test("aIp_BFu7i_Us");
    static STRUCT_IF_C aIp_BFu7i_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_Us, aIp_BFu7i_Us)
//============================================================================



static void Test_aIp_BFu7i_Vp()
{
  {
    init_simple_test("aIp_BFu7i_Vp");
    static STRUCT_IF_C aIp_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7i_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7i_Vp, aIp_BFu7i_Vp)
//============================================================================



static void Test_aIp_BFu7ll()
{
  {
    init_simple_test("aIp_BFu7ll");
    static STRUCT_IF_C aIp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll, aIp_BFu7ll)
//============================================================================



static void Test_aIp_BFu7ll_BFu15i()
{
  {
    init_simple_test("aIp_BFu7ll_BFu15i");
    static STRUCT_IF_C aIp_BFu7ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aIp_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aIp_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu15i, aIp_BFu7ll_BFu15i)
//============================================================================



static void Test_aIp_BFu7ll_BFu15ll()
{
  {
    init_simple_test("aIp_BFu7ll_BFu15ll");
    static STRUCT_IF_C aIp_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aIp_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aIp_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu15ll, aIp_BFu7ll_BFu15ll)
//============================================================================



static void Test_aIp_BFu7ll_BFu15s()
{
  {
    init_simple_test("aIp_BFu7ll_BFu15s");
    static STRUCT_IF_C aIp_BFu7ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aIp_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aIp_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu15s, aIp_BFu7ll_BFu15s)
//============================================================================



static void Test_aIp_BFu7ll_BFu16i()
{
  {
    init_simple_test("aIp_BFu7ll_BFu16i");
    static STRUCT_IF_C aIp_BFu7ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aIp_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aIp_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu16i, aIp_BFu7ll_BFu16i)
//============================================================================



static void Test_aIp_BFu7ll_BFu16ll()
{
  {
    init_simple_test("aIp_BFu7ll_BFu16ll");
    static STRUCT_IF_C aIp_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aIp_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aIp_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu16ll, aIp_BFu7ll_BFu16ll)
//============================================================================



static void Test_aIp_BFu7ll_BFu16s()
{
  {
    init_simple_test("aIp_BFu7ll_BFu16s");
    static STRUCT_IF_C aIp_BFu7ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aIp_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aIp_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu16s, aIp_BFu7ll_BFu16s)
//============================================================================



static void Test_aIp_BFu7ll_BFu17i()
{
  {
    init_simple_test("aIp_BFu7ll_BFu17i");
    static STRUCT_IF_C aIp_BFu7ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aIp_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aIp_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu17i, aIp_BFu7ll_BFu17i)
//============================================================================



static void Test_aIp_BFu7ll_BFu17ll()
{
  {
    init_simple_test("aIp_BFu7ll_BFu17ll");
    static STRUCT_IF_C aIp_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aIp_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aIp_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu17ll, aIp_BFu7ll_BFu17ll)
//============================================================================



static void Test_aIp_BFu7ll_BFu1c()
{
  {
    init_simple_test("aIp_BFu7ll_BFu1c");
    static STRUCT_IF_C aIp_BFu7ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu1c, aIp_BFu7ll_BFu1c)
//============================================================================



static void Test_aIp_BFu7ll_BFu1i()
{
  {
    init_simple_test("aIp_BFu7ll_BFu1i");
    static STRUCT_IF_C aIp_BFu7ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu1i, aIp_BFu7ll_BFu1i)
//============================================================================



static void Test_aIp_BFu7ll_BFu1ll()
{
  {
    init_simple_test("aIp_BFu7ll_BFu1ll");
    static STRUCT_IF_C aIp_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu1ll, aIp_BFu7ll_BFu1ll)
//============================================================================



static void Test_aIp_BFu7ll_BFu1s()
{
  {
    init_simple_test("aIp_BFu7ll_BFu1s");
    static STRUCT_IF_C aIp_BFu7ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu1s, aIp_BFu7ll_BFu1s)
//============================================================================



static void Test_aIp_BFu7ll_BFu31i()
{
  {
    init_simple_test("aIp_BFu7ll_BFu31i");
    static STRUCT_IF_C aIp_BFu7ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aIp_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aIp_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu31i, aIp_BFu7ll_BFu31i)
//============================================================================



static void Test_aIp_BFu7ll_BFu31ll()
{
  {
    init_simple_test("aIp_BFu7ll_BFu31ll");
    static STRUCT_IF_C aIp_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aIp_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aIp_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu31ll, aIp_BFu7ll_BFu31ll)
//============================================================================



static void Test_aIp_BFu7ll_BFu32i()
{
  {
    init_simple_test("aIp_BFu7ll_BFu32i");
    static STRUCT_IF_C aIp_BFu7ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aIp_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aIp_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu32i, aIp_BFu7ll_BFu32i)
//============================================================================



static void Test_aIp_BFu7ll_BFu32ll()
{
  {
    init_simple_test("aIp_BFu7ll_BFu32ll");
    static STRUCT_IF_C aIp_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aIp_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aIp_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu32ll, aIp_BFu7ll_BFu32ll)
//============================================================================



static void Test_aIp_BFu7ll_BFu33()
{
  {
    init_simple_test("aIp_BFu7ll_BFu33");
    static STRUCT_IF_C aIp_BFu7ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, 1, "aIp_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, hide_ull(1LL<<32), "aIp_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu33, aIp_BFu7ll_BFu33)
//============================================================================



static void Test_aIp_BFu7ll_BFu7c()
{
  {
    init_simple_test("aIp_BFu7ll_BFu7c");
    static STRUCT_IF_C aIp_BFu7ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu7c, aIp_BFu7ll_BFu7c)
//============================================================================



static void Test_aIp_BFu7ll_BFu7i()
{
  {
    init_simple_test("aIp_BFu7ll_BFu7i");
    static STRUCT_IF_C aIp_BFu7ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu7i, aIp_BFu7ll_BFu7i)
//============================================================================



static void Test_aIp_BFu7ll_BFu7ll()
{
  {
    init_simple_test("aIp_BFu7ll_BFu7ll");
    static STRUCT_IF_C aIp_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu7ll, aIp_BFu7ll_BFu7ll)
//============================================================================



static void Test_aIp_BFu7ll_BFu7s()
{
  {
    init_simple_test("aIp_BFu7ll_BFu7s");
    static STRUCT_IF_C aIp_BFu7ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu7s, aIp_BFu7ll_BFu7s)
//============================================================================



static void Test_aIp_BFu7ll_BFu8c()
{
  {
    init_simple_test("aIp_BFu7ll_BFu8c");
    static STRUCT_IF_C aIp_BFu7ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu8c, aIp_BFu7ll_BFu8c)
//============================================================================



static void Test_aIp_BFu7ll_BFu8i()
{
  {
    init_simple_test("aIp_BFu7ll_BFu8i");
    static STRUCT_IF_C aIp_BFu7ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu8i, aIp_BFu7ll_BFu8i)
//============================================================================



static void Test_aIp_BFu7ll_BFu8ll()
{
  {
    init_simple_test("aIp_BFu7ll_BFu8ll");
    static STRUCT_IF_C aIp_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu8ll, aIp_BFu7ll_BFu8ll)
//============================================================================



static void Test_aIp_BFu7ll_BFu8s()
{
  {
    init_simple_test("aIp_BFu7ll_BFu8s");
    static STRUCT_IF_C aIp_BFu7ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu8s, aIp_BFu7ll_BFu8s)
//============================================================================



static void Test_aIp_BFu7ll_BFu9i()
{
  {
    init_simple_test("aIp_BFu7ll_BFu9i");
    static STRUCT_IF_C aIp_BFu7ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aIp_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aIp_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu9i, aIp_BFu7ll_BFu9i)
//============================================================================



static void Test_aIp_BFu7ll_BFu9ll()
{
  {
    init_simple_test("aIp_BFu7ll_BFu9ll");
    static STRUCT_IF_C aIp_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aIp_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aIp_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu9ll, aIp_BFu7ll_BFu9ll)
//============================================================================



static void Test_aIp_BFu7ll_BFu9s()
{
  {
    init_simple_test("aIp_BFu7ll_BFu9s");
    static STRUCT_IF_C aIp_BFu7ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aIp_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aIp_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_BFu9s, aIp_BFu7ll_BFu9s)
//============================================================================



static void Test_aIp_BFu7ll_C()
{
  {
    init_simple_test("aIp_BFu7ll_C");
    static STRUCT_IF_C aIp_BFu7ll_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_C, aIp_BFu7ll_C)
//============================================================================



static void Test_aIp_BFu7ll_D()
{
  {
    init_simple_test("aIp_BFu7ll_D");
    static STRUCT_IF_C aIp_BFu7ll_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_D, aIp_BFu7ll_D)
//============================================================================



static void Test_aIp_BFu7ll_F()
{
  {
    init_simple_test("aIp_BFu7ll_F");
    static STRUCT_IF_C aIp_BFu7ll_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_F, aIp_BFu7ll_F)
//============================================================================



static void Test_aIp_BFu7ll_I()
{
  {
    init_simple_test("aIp_BFu7ll_I");
    static STRUCT_IF_C aIp_BFu7ll_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_I, aIp_BFu7ll_I)
//============================================================================



static void Test_aIp_BFu7ll_Ip()
{
  {
    init_simple_test("aIp_BFu7ll_Ip");
    static STRUCT_IF_C aIp_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_Ip, aIp_BFu7ll_Ip)
//============================================================================



static void Test_aIp_BFu7ll_L()
{
  {
    init_simple_test("aIp_BFu7ll_L");
    static STRUCT_IF_C aIp_BFu7ll_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_L, aIp_BFu7ll_L)
//============================================================================



static void Test_aIp_BFu7ll_S()
{
  {
    init_simple_test("aIp_BFu7ll_S");
    static STRUCT_IF_C aIp_BFu7ll_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_S, aIp_BFu7ll_S)
//============================================================================



static void Test_aIp_BFu7ll_Uc()
{
  {
    init_simple_test("aIp_BFu7ll_Uc");
    static STRUCT_IF_C aIp_BFu7ll_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_Uc, aIp_BFu7ll_Uc)
//============================================================================



static void Test_aIp_BFu7ll_Ui()
{
  {
    init_simple_test("aIp_BFu7ll_Ui");
    static STRUCT_IF_C aIp_BFu7ll_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_Ui, aIp_BFu7ll_Ui)
//============================================================================



static void Test_aIp_BFu7ll_Ul()
{
  {
    init_simple_test("aIp_BFu7ll_Ul");
    static STRUCT_IF_C aIp_BFu7ll_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_Ul, aIp_BFu7ll_Ul)
//============================================================================



static void Test_aIp_BFu7ll_Us()
{
  {
    init_simple_test("aIp_BFu7ll_Us");
    static STRUCT_IF_C aIp_BFu7ll_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_Us, aIp_BFu7ll_Us)
//============================================================================



static void Test_aIp_BFu7ll_Vp()
{
  {
    init_simple_test("aIp_BFu7ll_Vp");
    static STRUCT_IF_C aIp_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7ll_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7ll_Vp, aIp_BFu7ll_Vp)
//============================================================================



static void Test_aIp_BFu7s()
{
  {
    init_simple_test("aIp_BFu7s");
    static STRUCT_IF_C aIp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s, aIp_BFu7s)
//============================================================================



static void Test_aIp_BFu7s_BFu15i()
{
  {
    init_simple_test("aIp_BFu7s_BFu15i");
    static STRUCT_IF_C aIp_BFu7s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aIp_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aIp_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu15i, aIp_BFu7s_BFu15i)
//============================================================================



static void Test_aIp_BFu7s_BFu15ll()
{
  {
    init_simple_test("aIp_BFu7s_BFu15ll");
    static STRUCT_IF_C aIp_BFu7s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aIp_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aIp_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu15ll, aIp_BFu7s_BFu15ll)
//============================================================================



static void Test_aIp_BFu7s_BFu15s()
{
  {
    init_simple_test("aIp_BFu7s_BFu15s");
    static STRUCT_IF_C aIp_BFu7s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, 1, "aIp_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 15, hide_ull(1LL<<14), "aIp_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu15s, aIp_BFu7s_BFu15s)
//============================================================================



static void Test_aIp_BFu7s_BFu16i()
{
  {
    init_simple_test("aIp_BFu7s_BFu16i");
    static STRUCT_IF_C aIp_BFu7s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aIp_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aIp_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu16i, aIp_BFu7s_BFu16i)
//============================================================================



static void Test_aIp_BFu7s_BFu16ll()
{
  {
    init_simple_test("aIp_BFu7s_BFu16ll");
    static STRUCT_IF_C aIp_BFu7s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aIp_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aIp_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu16ll, aIp_BFu7s_BFu16ll)
//============================================================================



static void Test_aIp_BFu7s_BFu16s()
{
  {
    init_simple_test("aIp_BFu7s_BFu16s");
    static STRUCT_IF_C aIp_BFu7s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, 1, "aIp_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 16, hide_ull(1LL<<15), "aIp_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu16s, aIp_BFu7s_BFu16s)
//============================================================================



static void Test_aIp_BFu7s_BFu17i()
{
  {
    init_simple_test("aIp_BFu7s_BFu17i");
    static STRUCT_IF_C aIp_BFu7s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aIp_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aIp_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu17i, aIp_BFu7s_BFu17i)
//============================================================================



static void Test_aIp_BFu7s_BFu17ll()
{
  {
    init_simple_test("aIp_BFu7s_BFu17ll");
    static STRUCT_IF_C aIp_BFu7s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, 1, "aIp_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 17, hide_ull(1LL<<16), "aIp_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu17ll, aIp_BFu7s_BFu17ll)
//============================================================================



static void Test_aIp_BFu7s_BFu1c()
{
  {
    init_simple_test("aIp_BFu7s_BFu1c");
    static STRUCT_IF_C aIp_BFu7s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu1c, aIp_BFu7s_BFu1c)
//============================================================================



static void Test_aIp_BFu7s_BFu1i()
{
  {
    init_simple_test("aIp_BFu7s_BFu1i");
    static STRUCT_IF_C aIp_BFu7s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu1i, aIp_BFu7s_BFu1i)
//============================================================================



static void Test_aIp_BFu7s_BFu1ll()
{
  {
    init_simple_test("aIp_BFu7s_BFu1ll");
    static STRUCT_IF_C aIp_BFu7s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu1ll, aIp_BFu7s_BFu1ll)
//============================================================================



static void Test_aIp_BFu7s_BFu1s()
{
  {
    init_simple_test("aIp_BFu7s_BFu1s");
    static STRUCT_IF_C aIp_BFu7s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 1, 1, "aIp_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu1s, aIp_BFu7s_BFu1s)
//============================================================================



static void Test_aIp_BFu7s_BFu31i()
{
  {
    init_simple_test("aIp_BFu7s_BFu31i");
    static STRUCT_IF_C aIp_BFu7s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aIp_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aIp_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu31i, aIp_BFu7s_BFu31i)
//============================================================================



static void Test_aIp_BFu7s_BFu31ll()
{
  {
    init_simple_test("aIp_BFu7s_BFu31ll");
    static STRUCT_IF_C aIp_BFu7s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, 1, "aIp_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 31, hide_ull(1LL<<30), "aIp_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu31ll, aIp_BFu7s_BFu31ll)
//============================================================================



static void Test_aIp_BFu7s_BFu32i()
{
  {
    init_simple_test("aIp_BFu7s_BFu32i");
    static STRUCT_IF_C aIp_BFu7s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aIp_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aIp_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu32i, aIp_BFu7s_BFu32i)
//============================================================================



static void Test_aIp_BFu7s_BFu32ll()
{
  {
    init_simple_test("aIp_BFu7s_BFu32ll");
    static STRUCT_IF_C aIp_BFu7s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, 1, "aIp_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 32, hide_ull(1LL<<31), "aIp_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu32ll, aIp_BFu7s_BFu32ll)
//============================================================================



static void Test_aIp_BFu7s_BFu33()
{
  {
    init_simple_test("aIp_BFu7s_BFu33");
    static STRUCT_IF_C aIp_BFu7s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, 1, "aIp_BFu7s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 33, hide_ull(1LL<<32), "aIp_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu33, aIp_BFu7s_BFu33)
//============================================================================



static void Test_aIp_BFu7s_BFu7c()
{
  {
    init_simple_test("aIp_BFu7s_BFu7c");
    static STRUCT_IF_C aIp_BFu7s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu7c, aIp_BFu7s_BFu7c)
//============================================================================



static void Test_aIp_BFu7s_BFu7i()
{
  {
    init_simple_test("aIp_BFu7s_BFu7i");
    static STRUCT_IF_C aIp_BFu7s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu7i, aIp_BFu7s_BFu7i)
//============================================================================



static void Test_aIp_BFu7s_BFu7ll()
{
  {
    init_simple_test("aIp_BFu7s_BFu7ll");
    static STRUCT_IF_C aIp_BFu7s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu7ll, aIp_BFu7s_BFu7ll)
//============================================================================



static void Test_aIp_BFu7s_BFu7s()
{
  {
    init_simple_test("aIp_BFu7s_BFu7s");
    static STRUCT_IF_C aIp_BFu7s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, 1, "aIp_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu7s, aIp_BFu7s_BFu7s)
//============================================================================



static void Test_aIp_BFu7s_BFu8c()
{
  {
    init_simple_test("aIp_BFu7s_BFu8c");
    static STRUCT_IF_C aIp_BFu7s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu8c, aIp_BFu7s_BFu8c)
//============================================================================



static void Test_aIp_BFu7s_BFu8i()
{
  {
    init_simple_test("aIp_BFu7s_BFu8i");
    static STRUCT_IF_C aIp_BFu7s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu8i, aIp_BFu7s_BFu8i)
//============================================================================



static void Test_aIp_BFu7s_BFu8ll()
{
  {
    init_simple_test("aIp_BFu7s_BFu8ll");
    static STRUCT_IF_C aIp_BFu7s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu8ll, aIp_BFu7s_BFu8ll)
//============================================================================



static void Test_aIp_BFu7s_BFu8s()
{
  {
    init_simple_test("aIp_BFu7s_BFu8s");
    static STRUCT_IF_C aIp_BFu7s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, 1, "aIp_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 8, hide_ull(1LL<<7), "aIp_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu8s, aIp_BFu7s_BFu8s)
//============================================================================



static void Test_aIp_BFu7s_BFu9i()
{
  {
    init_simple_test("aIp_BFu7s_BFu9i");
    static STRUCT_IF_C aIp_BFu7s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aIp_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aIp_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu9i, aIp_BFu7s_BFu9i)
//============================================================================



static void Test_aIp_BFu7s_BFu9ll()
{
  {
    init_simple_test("aIp_BFu7s_BFu9ll");
    static STRUCT_IF_C aIp_BFu7s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aIp_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aIp_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu9ll, aIp_BFu7s_BFu9ll)
//============================================================================



static void Test_aIp_BFu7s_BFu9s()
{
  {
    init_simple_test("aIp_BFu7s_BFu9s");
    static STRUCT_IF_C aIp_BFu7s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, 1, "aIp_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 7, 9, hide_ull(1LL<<8), "aIp_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_BFu9s, aIp_BFu7s_BFu9s)
//============================================================================



static void Test_aIp_BFu7s_C()
{
  {
    init_simple_test("aIp_BFu7s_C");
    static STRUCT_IF_C aIp_BFu7s_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_C, aIp_BFu7s_C)
//============================================================================



static void Test_aIp_BFu7s_D()
{
  {
    init_simple_test("aIp_BFu7s_D");
    static STRUCT_IF_C aIp_BFu7s_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_D, aIp_BFu7s_D)
//============================================================================



static void Test_aIp_BFu7s_F()
{
  {
    init_simple_test("aIp_BFu7s_F");
    static STRUCT_IF_C aIp_BFu7s_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_F, aIp_BFu7s_F)
//============================================================================



static void Test_aIp_BFu7s_I()
{
  {
    init_simple_test("aIp_BFu7s_I");
    static STRUCT_IF_C aIp_BFu7s_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_I, aIp_BFu7s_I)
//============================================================================



static void Test_aIp_BFu7s_Ip()
{
  {
    init_simple_test("aIp_BFu7s_Ip");
    static STRUCT_IF_C aIp_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_Ip, aIp_BFu7s_Ip)
//============================================================================



static void Test_aIp_BFu7s_L()
{
  {
    init_simple_test("aIp_BFu7s_L");
    static STRUCT_IF_C aIp_BFu7s_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu7s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_L, aIp_BFu7s_L)
//============================================================================



static void Test_aIp_BFu7s_S()
{
  {
    init_simple_test("aIp_BFu7s_S");
    static STRUCT_IF_C aIp_BFu7s_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_S, aIp_BFu7s_S)
//============================================================================



static void Test_aIp_BFu7s_Uc()
{
  {
    init_simple_test("aIp_BFu7s_Uc");
    static STRUCT_IF_C aIp_BFu7s_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu7s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_Uc, aIp_BFu7s_Uc)
//============================================================================



static void Test_aIp_BFu7s_Ui()
{
  {
    init_simple_test("aIp_BFu7s_Ui");
    static STRUCT_IF_C aIp_BFu7s_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu7s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_Ui, aIp_BFu7s_Ui)
//============================================================================



static void Test_aIp_BFu7s_Ul()
{
  {
    init_simple_test("aIp_BFu7s_Ul");
    static STRUCT_IF_C aIp_BFu7s_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu7s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_Ul, aIp_BFu7s_Ul)
//============================================================================



static void Test_aIp_BFu7s_Us()
{
  {
    init_simple_test("aIp_BFu7s_Us");
    static STRUCT_IF_C aIp_BFu7s_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu7s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_Us, aIp_BFu7s_Us)
//============================================================================



static void Test_aIp_BFu7s_Vp()
{
  {
    init_simple_test("aIp_BFu7s_Vp");
    static STRUCT_IF_C aIp_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu7s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, 1, "aIp_BFu7s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 7, hide_ull(1LL<<6), "aIp_BFu7s_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu7s_Vp, aIp_BFu7s_Vp)
//============================================================================



static void Test_aIp_BFu8c()
{
  {
    init_simple_test("aIp_BFu8c");
    static STRUCT_IF_C aIp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c, aIp_BFu8c)
//============================================================================



static void Test_aIp_BFu8c_BFu15i()
{
  {
    init_simple_test("aIp_BFu8c_BFu15i");
    static STRUCT_IF_C aIp_BFu8c_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aIp_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aIp_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu15i, aIp_BFu8c_BFu15i)
//============================================================================



static void Test_aIp_BFu8c_BFu15ll()
{
  {
    init_simple_test("aIp_BFu8c_BFu15ll");
    static STRUCT_IF_C aIp_BFu8c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aIp_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aIp_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu15ll, aIp_BFu8c_BFu15ll)
//============================================================================



static void Test_aIp_BFu8c_BFu15s()
{
  {
    init_simple_test("aIp_BFu8c_BFu15s");
    static STRUCT_IF_C aIp_BFu8c_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aIp_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aIp_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu15s, aIp_BFu8c_BFu15s)
//============================================================================



static void Test_aIp_BFu8c_BFu16i()
{
  {
    init_simple_test("aIp_BFu8c_BFu16i");
    static STRUCT_IF_C aIp_BFu8c_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aIp_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aIp_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu16i, aIp_BFu8c_BFu16i)
//============================================================================



static void Test_aIp_BFu8c_BFu16ll()
{
  {
    init_simple_test("aIp_BFu8c_BFu16ll");
    static STRUCT_IF_C aIp_BFu8c_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aIp_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aIp_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu16ll, aIp_BFu8c_BFu16ll)
//============================================================================



static void Test_aIp_BFu8c_BFu16s()
{
  {
    init_simple_test("aIp_BFu8c_BFu16s");
    static STRUCT_IF_C aIp_BFu8c_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aIp_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aIp_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu16s, aIp_BFu8c_BFu16s)
//============================================================================



static void Test_aIp_BFu8c_BFu17i()
{
  {
    init_simple_test("aIp_BFu8c_BFu17i");
    static STRUCT_IF_C aIp_BFu8c_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu8c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aIp_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aIp_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu17i, aIp_BFu8c_BFu17i)
//============================================================================



static void Test_aIp_BFu8c_BFu17ll()
{
  {
    init_simple_test("aIp_BFu8c_BFu17ll");
    static STRUCT_IF_C aIp_BFu8c_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu8c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aIp_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aIp_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu17ll, aIp_BFu8c_BFu17ll)
//============================================================================



static void Test_aIp_BFu8c_BFu1c()
{
  {
    init_simple_test("aIp_BFu8c_BFu1c");
    static STRUCT_IF_C aIp_BFu8c_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu1c, aIp_BFu8c_BFu1c)
//============================================================================



static void Test_aIp_BFu8c_BFu1i()
{
  {
    init_simple_test("aIp_BFu8c_BFu1i");
    static STRUCT_IF_C aIp_BFu8c_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu1i, aIp_BFu8c_BFu1i)
//============================================================================



static void Test_aIp_BFu8c_BFu1ll()
{
  {
    init_simple_test("aIp_BFu8c_BFu1ll");
    static STRUCT_IF_C aIp_BFu8c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu1ll, aIp_BFu8c_BFu1ll)
//============================================================================



static void Test_aIp_BFu8c_BFu1s()
{
  {
    init_simple_test("aIp_BFu8c_BFu1s");
    static STRUCT_IF_C aIp_BFu8c_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu1s, aIp_BFu8c_BFu1s)
//============================================================================



static void Test_aIp_BFu8c_BFu31i()
{
  {
    init_simple_test("aIp_BFu8c_BFu31i");
    static STRUCT_IF_C aIp_BFu8c_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aIp_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aIp_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu31i, aIp_BFu8c_BFu31i)
//============================================================================



static void Test_aIp_BFu8c_BFu31ll()
{
  {
    init_simple_test("aIp_BFu8c_BFu31ll");
    static STRUCT_IF_C aIp_BFu8c_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aIp_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aIp_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu31ll, aIp_BFu8c_BFu31ll)
//============================================================================



static void Test_aIp_BFu8c_BFu32i()
{
  {
    init_simple_test("aIp_BFu8c_BFu32i");
    static STRUCT_IF_C aIp_BFu8c_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aIp_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aIp_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu32i, aIp_BFu8c_BFu32i)
//============================================================================



static void Test_aIp_BFu8c_BFu32ll()
{
  {
    init_simple_test("aIp_BFu8c_BFu32ll");
    static STRUCT_IF_C aIp_BFu8c_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aIp_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aIp_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu32ll, aIp_BFu8c_BFu32ll)
//============================================================================



static void Test_aIp_BFu8c_BFu33()
{
  {
    init_simple_test("aIp_BFu8c_BFu33");
    static STRUCT_IF_C aIp_BFu8c_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aIp_BFu8c_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aIp_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu33, aIp_BFu8c_BFu33)
//============================================================================



static void Test_aIp_BFu8c_BFu7c()
{
  {
    init_simple_test("aIp_BFu8c_BFu7c");
    static STRUCT_IF_C aIp_BFu8c_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu7c, aIp_BFu8c_BFu7c)
//============================================================================



static void Test_aIp_BFu8c_BFu7i()
{
  {
    init_simple_test("aIp_BFu8c_BFu7i");
    static STRUCT_IF_C aIp_BFu8c_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu7i, aIp_BFu8c_BFu7i)
//============================================================================



static void Test_aIp_BFu8c_BFu7ll()
{
  {
    init_simple_test("aIp_BFu8c_BFu7ll");
    static STRUCT_IF_C aIp_BFu8c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu7ll, aIp_BFu8c_BFu7ll)
//============================================================================



static void Test_aIp_BFu8c_BFu7s()
{
  {
    init_simple_test("aIp_BFu8c_BFu7s");
    static STRUCT_IF_C aIp_BFu8c_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu7s, aIp_BFu8c_BFu7s)
//============================================================================



static void Test_aIp_BFu8c_BFu8c()
{
  {
    init_simple_test("aIp_BFu8c_BFu8c");
    static STRUCT_IF_C aIp_BFu8c_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu8c, aIp_BFu8c_BFu8c)
//============================================================================



static void Test_aIp_BFu8c_BFu8i()
{
  {
    init_simple_test("aIp_BFu8c_BFu8i");
    static STRUCT_IF_C aIp_BFu8c_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu8i, aIp_BFu8c_BFu8i)
//============================================================================



static void Test_aIp_BFu8c_BFu8ll()
{
  {
    init_simple_test("aIp_BFu8c_BFu8ll");
    static STRUCT_IF_C aIp_BFu8c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu8ll, aIp_BFu8c_BFu8ll)
//============================================================================



static void Test_aIp_BFu8c_BFu8s()
{
  {
    init_simple_test("aIp_BFu8c_BFu8s");
    static STRUCT_IF_C aIp_BFu8c_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu8s, aIp_BFu8c_BFu8s)
//============================================================================



static void Test_aIp_BFu8c_BFu9i()
{
  {
    init_simple_test("aIp_BFu8c_BFu9i");
    static STRUCT_IF_C aIp_BFu8c_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aIp_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aIp_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu9i, aIp_BFu8c_BFu9i)
//============================================================================



static void Test_aIp_BFu8c_BFu9ll()
{
  {
    init_simple_test("aIp_BFu8c_BFu9ll");
    static STRUCT_IF_C aIp_BFu8c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aIp_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aIp_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu9ll, aIp_BFu8c_BFu9ll)
//============================================================================



static void Test_aIp_BFu8c_BFu9s()
{
  {
    init_simple_test("aIp_BFu8c_BFu9s");
    static STRUCT_IF_C aIp_BFu8c_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aIp_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aIp_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_BFu9s, aIp_BFu8c_BFu9s)
//============================================================================



static void Test_aIp_BFu8c_C()
{
  {
    init_simple_test("aIp_BFu8c_C");
    static STRUCT_IF_C aIp_BFu8c_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_C, aIp_BFu8c_C)
//============================================================================



static void Test_aIp_BFu8c_D()
{
  {
    init_simple_test("aIp_BFu8c_D");
    static STRUCT_IF_C aIp_BFu8c_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu8c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_D, aIp_BFu8c_D)
//============================================================================



static void Test_aIp_BFu8c_F()
{
  {
    init_simple_test("aIp_BFu8c_F");
    static STRUCT_IF_C aIp_BFu8c_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_F, aIp_BFu8c_F)
//============================================================================



static void Test_aIp_BFu8c_I()
{
  {
    init_simple_test("aIp_BFu8c_I");
    static STRUCT_IF_C aIp_BFu8c_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_I, aIp_BFu8c_I)
//============================================================================



static void Test_aIp_BFu8c_Ip()
{
  {
    init_simple_test("aIp_BFu8c_Ip");
    static STRUCT_IF_C aIp_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu8c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_Ip, aIp_BFu8c_Ip)
//============================================================================



static void Test_aIp_BFu8c_L()
{
  {
    init_simple_test("aIp_BFu8c_L");
    static STRUCT_IF_C aIp_BFu8c_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu8c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_L, aIp_BFu8c_L)
//============================================================================



static void Test_aIp_BFu8c_S()
{
  {
    init_simple_test("aIp_BFu8c_S");
    static STRUCT_IF_C aIp_BFu8c_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_S, aIp_BFu8c_S)
//============================================================================



static void Test_aIp_BFu8c_Uc()
{
  {
    init_simple_test("aIp_BFu8c_Uc");
    static STRUCT_IF_C aIp_BFu8c_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_Uc, aIp_BFu8c_Uc)
//============================================================================



static void Test_aIp_BFu8c_Ui()
{
  {
    init_simple_test("aIp_BFu8c_Ui");
    static STRUCT_IF_C aIp_BFu8c_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_Ui, aIp_BFu8c_Ui)
//============================================================================



static void Test_aIp_BFu8c_Ul()
{
  {
    init_simple_test("aIp_BFu8c_Ul");
    static STRUCT_IF_C aIp_BFu8c_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu8c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_Ul, aIp_BFu8c_Ul)
//============================================================================



static void Test_aIp_BFu8c_Us()
{
  {
    init_simple_test("aIp_BFu8c_Us");
    static STRUCT_IF_C aIp_BFu8c_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_Us, aIp_BFu8c_Us)
//============================================================================



static void Test_aIp_BFu8c_Vp()
{
  {
    init_simple_test("aIp_BFu8c_Vp");
    static STRUCT_IF_C aIp_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu8c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8c_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8c_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8c_Vp, aIp_BFu8c_Vp)
//============================================================================



static void Test_aIp_BFu8i()
{
  {
    init_simple_test("aIp_BFu8i");
    static STRUCT_IF_C aIp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i, aIp_BFu8i)
//============================================================================



static void Test_aIp_BFu8i_BFu15i()
{
  {
    init_simple_test("aIp_BFu8i_BFu15i");
    static STRUCT_IF_C aIp_BFu8i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aIp_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aIp_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu15i, aIp_BFu8i_BFu15i)
//============================================================================



static void Test_aIp_BFu8i_BFu15ll()
{
  {
    init_simple_test("aIp_BFu8i_BFu15ll");
    static STRUCT_IF_C aIp_BFu8i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aIp_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aIp_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu15ll, aIp_BFu8i_BFu15ll)
//============================================================================



static void Test_aIp_BFu8i_BFu15s()
{
  {
    init_simple_test("aIp_BFu8i_BFu15s");
    static STRUCT_IF_C aIp_BFu8i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aIp_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aIp_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu15s, aIp_BFu8i_BFu15s)
//============================================================================



static void Test_aIp_BFu8i_BFu16i()
{
  {
    init_simple_test("aIp_BFu8i_BFu16i");
    static STRUCT_IF_C aIp_BFu8i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aIp_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aIp_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu16i, aIp_BFu8i_BFu16i)
//============================================================================



static void Test_aIp_BFu8i_BFu16ll()
{
  {
    init_simple_test("aIp_BFu8i_BFu16ll");
    static STRUCT_IF_C aIp_BFu8i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aIp_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aIp_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu16ll, aIp_BFu8i_BFu16ll)
//============================================================================



static void Test_aIp_BFu8i_BFu16s()
{
  {
    init_simple_test("aIp_BFu8i_BFu16s");
    static STRUCT_IF_C aIp_BFu8i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aIp_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aIp_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu16s, aIp_BFu8i_BFu16s)
//============================================================================



static void Test_aIp_BFu8i_BFu17i()
{
  {
    init_simple_test("aIp_BFu8i_BFu17i");
    static STRUCT_IF_C aIp_BFu8i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu8i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aIp_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aIp_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu17i, aIp_BFu8i_BFu17i)
//============================================================================



static void Test_aIp_BFu8i_BFu17ll()
{
  {
    init_simple_test("aIp_BFu8i_BFu17ll");
    static STRUCT_IF_C aIp_BFu8i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu8i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aIp_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aIp_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu17ll, aIp_BFu8i_BFu17ll)
//============================================================================



static void Test_aIp_BFu8i_BFu1c()
{
  {
    init_simple_test("aIp_BFu8i_BFu1c");
    static STRUCT_IF_C aIp_BFu8i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu1c, aIp_BFu8i_BFu1c)
//============================================================================



static void Test_aIp_BFu8i_BFu1i()
{
  {
    init_simple_test("aIp_BFu8i_BFu1i");
    static STRUCT_IF_C aIp_BFu8i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu1i, aIp_BFu8i_BFu1i)
//============================================================================



static void Test_aIp_BFu8i_BFu1ll()
{
  {
    init_simple_test("aIp_BFu8i_BFu1ll");
    static STRUCT_IF_C aIp_BFu8i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu1ll, aIp_BFu8i_BFu1ll)
//============================================================================



static void Test_aIp_BFu8i_BFu1s()
{
  {
    init_simple_test("aIp_BFu8i_BFu1s");
    static STRUCT_IF_C aIp_BFu8i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu1s, aIp_BFu8i_BFu1s)
//============================================================================



static void Test_aIp_BFu8i_BFu31i()
{
  {
    init_simple_test("aIp_BFu8i_BFu31i");
    static STRUCT_IF_C aIp_BFu8i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aIp_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aIp_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu31i, aIp_BFu8i_BFu31i)
//============================================================================



static void Test_aIp_BFu8i_BFu31ll()
{
  {
    init_simple_test("aIp_BFu8i_BFu31ll");
    static STRUCT_IF_C aIp_BFu8i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aIp_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aIp_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu31ll, aIp_BFu8i_BFu31ll)
//============================================================================



static void Test_aIp_BFu8i_BFu32i()
{
  {
    init_simple_test("aIp_BFu8i_BFu32i");
    static STRUCT_IF_C aIp_BFu8i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aIp_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aIp_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu32i, aIp_BFu8i_BFu32i)
//============================================================================



static void Test_aIp_BFu8i_BFu32ll()
{
  {
    init_simple_test("aIp_BFu8i_BFu32ll");
    static STRUCT_IF_C aIp_BFu8i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aIp_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aIp_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu32ll, aIp_BFu8i_BFu32ll)
//============================================================================



static void Test_aIp_BFu8i_BFu33()
{
  {
    init_simple_test("aIp_BFu8i_BFu33");
    static STRUCT_IF_C aIp_BFu8i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu8i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aIp_BFu8i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aIp_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu33, aIp_BFu8i_BFu33)
//============================================================================



static void Test_aIp_BFu8i_BFu7c()
{
  {
    init_simple_test("aIp_BFu8i_BFu7c");
    static STRUCT_IF_C aIp_BFu8i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu7c, aIp_BFu8i_BFu7c)
//============================================================================



static void Test_aIp_BFu8i_BFu7i()
{
  {
    init_simple_test("aIp_BFu8i_BFu7i");
    static STRUCT_IF_C aIp_BFu8i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu7i, aIp_BFu8i_BFu7i)
//============================================================================



static void Test_aIp_BFu8i_BFu7ll()
{
  {
    init_simple_test("aIp_BFu8i_BFu7ll");
    static STRUCT_IF_C aIp_BFu8i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu7ll, aIp_BFu8i_BFu7ll)
//============================================================================



static void Test_aIp_BFu8i_BFu7s()
{
  {
    init_simple_test("aIp_BFu8i_BFu7s");
    static STRUCT_IF_C aIp_BFu8i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu7s, aIp_BFu8i_BFu7s)
//============================================================================



static void Test_aIp_BFu8i_BFu8c()
{
  {
    init_simple_test("aIp_BFu8i_BFu8c");
    static STRUCT_IF_C aIp_BFu8i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu8c, aIp_BFu8i_BFu8c)
//============================================================================



static void Test_aIp_BFu8i_BFu8i()
{
  {
    init_simple_test("aIp_BFu8i_BFu8i");
    static STRUCT_IF_C aIp_BFu8i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu8i, aIp_BFu8i_BFu8i)
//============================================================================



static void Test_aIp_BFu8i_BFu8ll()
{
  {
    init_simple_test("aIp_BFu8i_BFu8ll");
    static STRUCT_IF_C aIp_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu8ll, aIp_BFu8i_BFu8ll)
//============================================================================



static void Test_aIp_BFu8i_BFu8s()
{
  {
    init_simple_test("aIp_BFu8i_BFu8s");
    static STRUCT_IF_C aIp_BFu8i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu8s, aIp_BFu8i_BFu8s)
//============================================================================



static void Test_aIp_BFu8i_BFu9i()
{
  {
    init_simple_test("aIp_BFu8i_BFu9i");
    static STRUCT_IF_C aIp_BFu8i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aIp_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aIp_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu9i, aIp_BFu8i_BFu9i)
//============================================================================



static void Test_aIp_BFu8i_BFu9ll()
{
  {
    init_simple_test("aIp_BFu8i_BFu9ll");
    static STRUCT_IF_C aIp_BFu8i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aIp_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aIp_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu9ll, aIp_BFu8i_BFu9ll)
//============================================================================



static void Test_aIp_BFu8i_BFu9s()
{
  {
    init_simple_test("aIp_BFu8i_BFu9s");
    static STRUCT_IF_C aIp_BFu8i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aIp_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aIp_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_BFu9s, aIp_BFu8i_BFu9s)
//============================================================================



static void Test_aIp_BFu8i_C()
{
  {
    init_simple_test("aIp_BFu8i_C");
    static STRUCT_IF_C aIp_BFu8i_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_C, aIp_BFu8i_C)
//============================================================================



static void Test_aIp_BFu8i_D()
{
  {
    init_simple_test("aIp_BFu8i_D");
    static STRUCT_IF_C aIp_BFu8i_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu8i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_D, aIp_BFu8i_D)
//============================================================================



static void Test_aIp_BFu8i_F()
{
  {
    init_simple_test("aIp_BFu8i_F");
    static STRUCT_IF_C aIp_BFu8i_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_F, aIp_BFu8i_F)
//============================================================================



static void Test_aIp_BFu8i_I()
{
  {
    init_simple_test("aIp_BFu8i_I");
    static STRUCT_IF_C aIp_BFu8i_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_I, aIp_BFu8i_I)
//============================================================================



static void Test_aIp_BFu8i_Ip()
{
  {
    init_simple_test("aIp_BFu8i_Ip");
    static STRUCT_IF_C aIp_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu8i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_Ip, aIp_BFu8i_Ip)
//============================================================================



static void Test_aIp_BFu8i_L()
{
  {
    init_simple_test("aIp_BFu8i_L");
    static STRUCT_IF_C aIp_BFu8i_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu8i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_L, aIp_BFu8i_L)
//============================================================================



static void Test_aIp_BFu8i_S()
{
  {
    init_simple_test("aIp_BFu8i_S");
    static STRUCT_IF_C aIp_BFu8i_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_S, aIp_BFu8i_S)
//============================================================================



static void Test_aIp_BFu8i_Uc()
{
  {
    init_simple_test("aIp_BFu8i_Uc");
    static STRUCT_IF_C aIp_BFu8i_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_Uc, aIp_BFu8i_Uc)
//============================================================================



static void Test_aIp_BFu8i_Ui()
{
  {
    init_simple_test("aIp_BFu8i_Ui");
    static STRUCT_IF_C aIp_BFu8i_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_Ui, aIp_BFu8i_Ui)
//============================================================================



static void Test_aIp_BFu8i_Ul()
{
  {
    init_simple_test("aIp_BFu8i_Ul");
    static STRUCT_IF_C aIp_BFu8i_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu8i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_Ul, aIp_BFu8i_Ul)
//============================================================================



static void Test_aIp_BFu8i_Us()
{
  {
    init_simple_test("aIp_BFu8i_Us");
    static STRUCT_IF_C aIp_BFu8i_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_Us, aIp_BFu8i_Us)
//============================================================================



static void Test_aIp_BFu8i_Vp()
{
  {
    init_simple_test("aIp_BFu8i_Vp");
    static STRUCT_IF_C aIp_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu8i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8i_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8i_Vp, aIp_BFu8i_Vp)
//============================================================================



static void Test_aIp_BFu8ll()
{
  {
    init_simple_test("aIp_BFu8ll");
    static STRUCT_IF_C aIp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll, aIp_BFu8ll)
//============================================================================



static void Test_aIp_BFu8ll_BFu15i()
{
  {
    init_simple_test("aIp_BFu8ll_BFu15i");
    static STRUCT_IF_C aIp_BFu8ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aIp_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aIp_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu15i, aIp_BFu8ll_BFu15i)
//============================================================================



static void Test_aIp_BFu8ll_BFu15ll()
{
  {
    init_simple_test("aIp_BFu8ll_BFu15ll");
    static STRUCT_IF_C aIp_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aIp_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aIp_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu15ll, aIp_BFu8ll_BFu15ll)
//============================================================================



static void Test_aIp_BFu8ll_BFu15s()
{
  {
    init_simple_test("aIp_BFu8ll_BFu15s");
    static STRUCT_IF_C aIp_BFu8ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aIp_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aIp_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu15s, aIp_BFu8ll_BFu15s)
//============================================================================



static void Test_aIp_BFu8ll_BFu16i()
{
  {
    init_simple_test("aIp_BFu8ll_BFu16i");
    static STRUCT_IF_C aIp_BFu8ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aIp_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aIp_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu16i, aIp_BFu8ll_BFu16i)
//============================================================================



static void Test_aIp_BFu8ll_BFu16ll()
{
  {
    init_simple_test("aIp_BFu8ll_BFu16ll");
    static STRUCT_IF_C aIp_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aIp_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aIp_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu16ll, aIp_BFu8ll_BFu16ll)
//============================================================================



static void Test_aIp_BFu8ll_BFu16s()
{
  {
    init_simple_test("aIp_BFu8ll_BFu16s");
    static STRUCT_IF_C aIp_BFu8ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aIp_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aIp_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu16s, aIp_BFu8ll_BFu16s)
//============================================================================



static void Test_aIp_BFu8ll_BFu17i()
{
  {
    init_simple_test("aIp_BFu8ll_BFu17i");
    static STRUCT_IF_C aIp_BFu8ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu8ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aIp_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aIp_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu17i, aIp_BFu8ll_BFu17i)
//============================================================================



static void Test_aIp_BFu8ll_BFu17ll()
{
  {
    init_simple_test("aIp_BFu8ll_BFu17ll");
    static STRUCT_IF_C aIp_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aIp_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aIp_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu17ll, aIp_BFu8ll_BFu17ll)
//============================================================================



static void Test_aIp_BFu8ll_BFu1c()
{
  {
    init_simple_test("aIp_BFu8ll_BFu1c");
    static STRUCT_IF_C aIp_BFu8ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu1c, aIp_BFu8ll_BFu1c)
//============================================================================



static void Test_aIp_BFu8ll_BFu1i()
{
  {
    init_simple_test("aIp_BFu8ll_BFu1i");
    static STRUCT_IF_C aIp_BFu8ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu1i, aIp_BFu8ll_BFu1i)
//============================================================================



static void Test_aIp_BFu8ll_BFu1ll()
{
  {
    init_simple_test("aIp_BFu8ll_BFu1ll");
    static STRUCT_IF_C aIp_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu1ll, aIp_BFu8ll_BFu1ll)
//============================================================================



static void Test_aIp_BFu8ll_BFu1s()
{
  {
    init_simple_test("aIp_BFu8ll_BFu1s");
    static STRUCT_IF_C aIp_BFu8ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu1s, aIp_BFu8ll_BFu1s)
//============================================================================



static void Test_aIp_BFu8ll_BFu31i()
{
  {
    init_simple_test("aIp_BFu8ll_BFu31i");
    static STRUCT_IF_C aIp_BFu8ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aIp_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aIp_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu31i, aIp_BFu8ll_BFu31i)
//============================================================================



static void Test_aIp_BFu8ll_BFu31ll()
{
  {
    init_simple_test("aIp_BFu8ll_BFu31ll");
    static STRUCT_IF_C aIp_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aIp_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aIp_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu31ll, aIp_BFu8ll_BFu31ll)
//============================================================================



static void Test_aIp_BFu8ll_BFu32i()
{
  {
    init_simple_test("aIp_BFu8ll_BFu32i");
    static STRUCT_IF_C aIp_BFu8ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aIp_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aIp_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu32i, aIp_BFu8ll_BFu32i)
//============================================================================



static void Test_aIp_BFu8ll_BFu32ll()
{
  {
    init_simple_test("aIp_BFu8ll_BFu32ll");
    static STRUCT_IF_C aIp_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aIp_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aIp_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu32ll, aIp_BFu8ll_BFu32ll)
//============================================================================



static void Test_aIp_BFu8ll_BFu33()
{
  {
    init_simple_test("aIp_BFu8ll_BFu33");
    static STRUCT_IF_C aIp_BFu8ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu8ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aIp_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aIp_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu33, aIp_BFu8ll_BFu33)
//============================================================================



static void Test_aIp_BFu8ll_BFu7c()
{
  {
    init_simple_test("aIp_BFu8ll_BFu7c");
    static STRUCT_IF_C aIp_BFu8ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu7c, aIp_BFu8ll_BFu7c)
//============================================================================



static void Test_aIp_BFu8ll_BFu7i()
{
  {
    init_simple_test("aIp_BFu8ll_BFu7i");
    static STRUCT_IF_C aIp_BFu8ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu7i, aIp_BFu8ll_BFu7i)
//============================================================================



static void Test_aIp_BFu8ll_BFu7ll()
{
  {
    init_simple_test("aIp_BFu8ll_BFu7ll");
    static STRUCT_IF_C aIp_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu7ll, aIp_BFu8ll_BFu7ll)
//============================================================================



static void Test_aIp_BFu8ll_BFu7s()
{
  {
    init_simple_test("aIp_BFu8ll_BFu7s");
    static STRUCT_IF_C aIp_BFu8ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu7s, aIp_BFu8ll_BFu7s)
//============================================================================



static void Test_aIp_BFu8ll_BFu8c()
{
  {
    init_simple_test("aIp_BFu8ll_BFu8c");
    static STRUCT_IF_C aIp_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu8c, aIp_BFu8ll_BFu8c)
//============================================================================



static void Test_aIp_BFu8ll_BFu8i()
{
  {
    init_simple_test("aIp_BFu8ll_BFu8i");
    static STRUCT_IF_C aIp_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu8i, aIp_BFu8ll_BFu8i)
//============================================================================



static void Test_aIp_BFu8ll_BFu8ll()
{
  {
    init_simple_test("aIp_BFu8ll_BFu8ll");
    static STRUCT_IF_C aIp_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu8ll, aIp_BFu8ll_BFu8ll)
//============================================================================



static void Test_aIp_BFu8ll_BFu8s()
{
  {
    init_simple_test("aIp_BFu8ll_BFu8s");
    static STRUCT_IF_C aIp_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu8s, aIp_BFu8ll_BFu8s)
//============================================================================



static void Test_aIp_BFu8ll_BFu9i()
{
  {
    init_simple_test("aIp_BFu8ll_BFu9i");
    static STRUCT_IF_C aIp_BFu8ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aIp_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aIp_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu9i, aIp_BFu8ll_BFu9i)
//============================================================================



static void Test_aIp_BFu8ll_BFu9ll()
{
  {
    init_simple_test("aIp_BFu8ll_BFu9ll");
    static STRUCT_IF_C aIp_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aIp_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aIp_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu9ll, aIp_BFu8ll_BFu9ll)
//============================================================================



static void Test_aIp_BFu8ll_BFu9s()
{
  {
    init_simple_test("aIp_BFu8ll_BFu9s");
    static STRUCT_IF_C aIp_BFu8ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aIp_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aIp_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_BFu9s, aIp_BFu8ll_BFu9s)
//============================================================================



static void Test_aIp_BFu8ll_C()
{
  {
    init_simple_test("aIp_BFu8ll_C");
    static STRUCT_IF_C aIp_BFu8ll_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_C, aIp_BFu8ll_C)
//============================================================================



static void Test_aIp_BFu8ll_D()
{
  {
    init_simple_test("aIp_BFu8ll_D");
    static STRUCT_IF_C aIp_BFu8ll_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu8ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_D, aIp_BFu8ll_D)
//============================================================================



static void Test_aIp_BFu8ll_F()
{
  {
    init_simple_test("aIp_BFu8ll_F");
    static STRUCT_IF_C aIp_BFu8ll_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_F, aIp_BFu8ll_F)
//============================================================================



static void Test_aIp_BFu8ll_I()
{
  {
    init_simple_test("aIp_BFu8ll_I");
    static STRUCT_IF_C aIp_BFu8ll_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_I, aIp_BFu8ll_I)
//============================================================================



static void Test_aIp_BFu8ll_Ip()
{
  {
    init_simple_test("aIp_BFu8ll_Ip");
    static STRUCT_IF_C aIp_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_Ip, aIp_BFu8ll_Ip)
//============================================================================



static void Test_aIp_BFu8ll_L()
{
  {
    init_simple_test("aIp_BFu8ll_L");
    static STRUCT_IF_C aIp_BFu8ll_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_L, aIp_BFu8ll_L)
//============================================================================



static void Test_aIp_BFu8ll_S()
{
  {
    init_simple_test("aIp_BFu8ll_S");
    static STRUCT_IF_C aIp_BFu8ll_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_S, aIp_BFu8ll_S)
//============================================================================



static void Test_aIp_BFu8ll_Uc()
{
  {
    init_simple_test("aIp_BFu8ll_Uc");
    static STRUCT_IF_C aIp_BFu8ll_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_Uc, aIp_BFu8ll_Uc)
//============================================================================



static void Test_aIp_BFu8ll_Ui()
{
  {
    init_simple_test("aIp_BFu8ll_Ui");
    static STRUCT_IF_C aIp_BFu8ll_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_Ui, aIp_BFu8ll_Ui)
//============================================================================



static void Test_aIp_BFu8ll_Ul()
{
  {
    init_simple_test("aIp_BFu8ll_Ul");
    static STRUCT_IF_C aIp_BFu8ll_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_Ul, aIp_BFu8ll_Ul)
//============================================================================



static void Test_aIp_BFu8ll_Us()
{
  {
    init_simple_test("aIp_BFu8ll_Us");
    static STRUCT_IF_C aIp_BFu8ll_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_Us, aIp_BFu8ll_Us)
//============================================================================



static void Test_aIp_BFu8ll_Vp()
{
  {
    init_simple_test("aIp_BFu8ll_Vp");
    static STRUCT_IF_C aIp_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8ll_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8ll_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8ll_Vp, aIp_BFu8ll_Vp)
//============================================================================



static void Test_aIp_BFu8s()
{
  {
    init_simple_test("aIp_BFu8s");
    static STRUCT_IF_C aIp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aIp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s, aIp_BFu8s)
//============================================================================



static void Test_aIp_BFu8s_BFu15i()
{
  {
    init_simple_test("aIp_BFu8s_BFu15i");
    static STRUCT_IF_C aIp_BFu8s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aIp_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aIp_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu15i, aIp_BFu8s_BFu15i)
//============================================================================



static void Test_aIp_BFu8s_BFu15ll()
{
  {
    init_simple_test("aIp_BFu8s_BFu15ll");
    static STRUCT_IF_C aIp_BFu8s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aIp_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aIp_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu15ll, aIp_BFu8s_BFu15ll)
//============================================================================



static void Test_aIp_BFu8s_BFu15s()
{
  {
    init_simple_test("aIp_BFu8s_BFu15s");
    static STRUCT_IF_C aIp_BFu8s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aIp_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aIp_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu15s, aIp_BFu8s_BFu15s)
//============================================================================



static void Test_aIp_BFu8s_BFu16i()
{
  {
    init_simple_test("aIp_BFu8s_BFu16i");
    static STRUCT_IF_C aIp_BFu8s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aIp_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aIp_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu16i, aIp_BFu8s_BFu16i)
//============================================================================



static void Test_aIp_BFu8s_BFu16ll()
{
  {
    init_simple_test("aIp_BFu8s_BFu16ll");
    static STRUCT_IF_C aIp_BFu8s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aIp_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aIp_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu16ll, aIp_BFu8s_BFu16ll)
//============================================================================



static void Test_aIp_BFu8s_BFu16s()
{
  {
    init_simple_test("aIp_BFu8s_BFu16s");
    static STRUCT_IF_C aIp_BFu8s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aIp_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aIp_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu16s, aIp_BFu8s_BFu16s)
//============================================================================



static void Test_aIp_BFu8s_BFu17i()
{
  {
    init_simple_test("aIp_BFu8s_BFu17i");
    static STRUCT_IF_C aIp_BFu8s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu8s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aIp_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aIp_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu17i, aIp_BFu8s_BFu17i)
//============================================================================



static void Test_aIp_BFu8s_BFu17ll()
{
  {
    init_simple_test("aIp_BFu8s_BFu17ll");
    static STRUCT_IF_C aIp_BFu8s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu8s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aIp_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aIp_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu17ll, aIp_BFu8s_BFu17ll)
//============================================================================



static void Test_aIp_BFu8s_BFu1c()
{
  {
    init_simple_test("aIp_BFu8s_BFu1c");
    static STRUCT_IF_C aIp_BFu8s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu1c, aIp_BFu8s_BFu1c)
//============================================================================



static void Test_aIp_BFu8s_BFu1i()
{
  {
    init_simple_test("aIp_BFu8s_BFu1i");
    static STRUCT_IF_C aIp_BFu8s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu1i, aIp_BFu8s_BFu1i)
//============================================================================



static void Test_aIp_BFu8s_BFu1ll()
{
  {
    init_simple_test("aIp_BFu8s_BFu1ll");
    static STRUCT_IF_C aIp_BFu8s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu1ll, aIp_BFu8s_BFu1ll)
//============================================================================



static void Test_aIp_BFu8s_BFu1s()
{
  {
    init_simple_test("aIp_BFu8s_BFu1s");
    static STRUCT_IF_C aIp_BFu8s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aIp_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu1s, aIp_BFu8s_BFu1s)
//============================================================================



static void Test_aIp_BFu8s_BFu31i()
{
  {
    init_simple_test("aIp_BFu8s_BFu31i");
    static STRUCT_IF_C aIp_BFu8s_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aIp_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aIp_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu31i, aIp_BFu8s_BFu31i)
//============================================================================



static void Test_aIp_BFu8s_BFu31ll()
{
  {
    init_simple_test("aIp_BFu8s_BFu31ll");
    static STRUCT_IF_C aIp_BFu8s_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aIp_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aIp_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu31ll, aIp_BFu8s_BFu31ll)
//============================================================================



static void Test_aIp_BFu8s_BFu32i()
{
  {
    init_simple_test("aIp_BFu8s_BFu32i");
    static STRUCT_IF_C aIp_BFu8s_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aIp_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aIp_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu32i, aIp_BFu8s_BFu32i)
//============================================================================



static void Test_aIp_BFu8s_BFu32ll()
{
  {
    init_simple_test("aIp_BFu8s_BFu32ll");
    static STRUCT_IF_C aIp_BFu8s_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aIp_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aIp_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu32ll, aIp_BFu8s_BFu32ll)
//============================================================================



static void Test_aIp_BFu8s_BFu33()
{
  {
    init_simple_test("aIp_BFu8s_BFu33");
    static STRUCT_IF_C aIp_BFu8s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu8s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aIp_BFu8s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aIp_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu33, aIp_BFu8s_BFu33)
//============================================================================



static void Test_aIp_BFu8s_BFu7c()
{
  {
    init_simple_test("aIp_BFu8s_BFu7c");
    static STRUCT_IF_C aIp_BFu8s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu7c, aIp_BFu8s_BFu7c)
//============================================================================



static void Test_aIp_BFu8s_BFu7i()
{
  {
    init_simple_test("aIp_BFu8s_BFu7i");
    static STRUCT_IF_C aIp_BFu8s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu7i, aIp_BFu8s_BFu7i)
//============================================================================



static void Test_aIp_BFu8s_BFu7ll()
{
  {
    init_simple_test("aIp_BFu8s_BFu7ll");
    static STRUCT_IF_C aIp_BFu8s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu7ll, aIp_BFu8s_BFu7ll)
//============================================================================



static void Test_aIp_BFu8s_BFu7s()
{
  {
    init_simple_test("aIp_BFu8s_BFu7s");
    static STRUCT_IF_C aIp_BFu8s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aIp_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aIp_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu7s, aIp_BFu8s_BFu7s)
//============================================================================



static void Test_aIp_BFu8s_BFu8c()
{
  {
    init_simple_test("aIp_BFu8s_BFu8c");
    static STRUCT_IF_C aIp_BFu8s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu8c, aIp_BFu8s_BFu8c)
//============================================================================



static void Test_aIp_BFu8s_BFu8i()
{
  {
    init_simple_test("aIp_BFu8s_BFu8i");
    static STRUCT_IF_C aIp_BFu8s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu8i, aIp_BFu8s_BFu8i)
//============================================================================



static void Test_aIp_BFu8s_BFu8ll()
{
  {
    init_simple_test("aIp_BFu8s_BFu8ll");
    static STRUCT_IF_C aIp_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu8ll, aIp_BFu8s_BFu8ll)
//============================================================================



static void Test_aIp_BFu8s_BFu8s()
{
  {
    init_simple_test("aIp_BFu8s_BFu8s");
    static STRUCT_IF_C aIp_BFu8s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aIp_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu8s, aIp_BFu8s_BFu8s)
//============================================================================



static void Test_aIp_BFu8s_BFu9i()
{
  {
    init_simple_test("aIp_BFu8s_BFu9i");
    static STRUCT_IF_C aIp_BFu8s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aIp_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aIp_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu9i, aIp_BFu8s_BFu9i)
//============================================================================



static void Test_aIp_BFu8s_BFu9ll()
{
  {
    init_simple_test("aIp_BFu8s_BFu9ll");
    static STRUCT_IF_C aIp_BFu8s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aIp_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aIp_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu9ll, aIp_BFu8s_BFu9ll)
//============================================================================



static void Test_aIp_BFu8s_BFu9s()
{
  {
    init_simple_test("aIp_BFu8s_BFu9s");
    static STRUCT_IF_C aIp_BFu8s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aIp_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aIp_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_BFu9s, aIp_BFu8s_BFu9s)
//============================================================================



static void Test_aIp_BFu8s_C()
{
  {
    init_simple_test("aIp_BFu8s_C");
    static STRUCT_IF_C aIp_BFu8s_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_C");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_C, aIp_BFu8s_C)
//============================================================================



static void Test_aIp_BFu8s_D()
{
  {
    init_simple_test("aIp_BFu8s_D");
    static STRUCT_IF_C aIp_BFu8s_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu8s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_D");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_D, aIp_BFu8s_D)
//============================================================================



static void Test_aIp_BFu8s_F()
{
  {
    init_simple_test("aIp_BFu8s_F");
    static STRUCT_IF_C aIp_BFu8s_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_F");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_F, aIp_BFu8s_F)
//============================================================================



static void Test_aIp_BFu8s_I()
{
  {
    init_simple_test("aIp_BFu8s_I");
    static STRUCT_IF_C aIp_BFu8s_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_I");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_I, aIp_BFu8s_I)
//============================================================================



static void Test_aIp_BFu8s_Ip()
{
  {
    init_simple_test("aIp_BFu8s_Ip");
    static STRUCT_IF_C aIp_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu8s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_Ip");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_Ip, aIp_BFu8s_Ip)
//============================================================================



static void Test_aIp_BFu8s_L()
{
  {
    init_simple_test("aIp_BFu8s_L");
    static STRUCT_IF_C aIp_BFu8s_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu8s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_L");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_L, aIp_BFu8s_L)
//============================================================================



static void Test_aIp_BFu8s_S()
{
  {
    init_simple_test("aIp_BFu8s_S");
    static STRUCT_IF_C aIp_BFu8s_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_S");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_S, aIp_BFu8s_S)
//============================================================================



static void Test_aIp_BFu8s_Uc()
{
  {
    init_simple_test("aIp_BFu8s_Uc");
    static STRUCT_IF_C aIp_BFu8s_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu8s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_Uc");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_Uc, aIp_BFu8s_Uc)
//============================================================================



static void Test_aIp_BFu8s_Ui()
{
  {
    init_simple_test("aIp_BFu8s_Ui");
    static STRUCT_IF_C aIp_BFu8s_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu8s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_Ui");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_Ui, aIp_BFu8s_Ui)
//============================================================================



static void Test_aIp_BFu8s_Ul()
{
  {
    init_simple_test("aIp_BFu8s_Ul");
    static STRUCT_IF_C aIp_BFu8s_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aIp_BFu8s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_Ul");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_Ul, aIp_BFu8s_Ul)
//============================================================================



static void Test_aIp_BFu8s_Us()
{
  {
    init_simple_test("aIp_BFu8s_Us");
    static STRUCT_IF_C aIp_BFu8s_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu8s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_Us");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_Us, aIp_BFu8s_Us)
//============================================================================



static void Test_aIp_BFu8s_Vp()
{
  {
    init_simple_test("aIp_BFu8s_Vp");
    static STRUCT_IF_C aIp_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aIp_BFu8s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, 1, "aIp_BFu8s_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 8, hide_ull(1LL<<7), "aIp_BFu8s_Vp");
    check_field_offset(lv, v3, ABISELECT(9,5), "aIp_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu8s_Vp, aIp_BFu8s_Vp)
//============================================================================



static void Test_aIp_BFu9i()
{
  {
    init_simple_test("aIp_BFu9i");
    static STRUCT_IF_C aIp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i, aIp_BFu9i)
//============================================================================



static void Test_aIp_BFu9i_BFu15i()
{
  {
    init_simple_test("aIp_BFu9i_BFu15i");
    static STRUCT_IF_C aIp_BFu9i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aIp_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aIp_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu15i, aIp_BFu9i_BFu15i)
//============================================================================



static void Test_aIp_BFu9i_BFu15ll()
{
  {
    init_simple_test("aIp_BFu9i_BFu15ll");
    static STRUCT_IF_C aIp_BFu9i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aIp_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aIp_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu15ll, aIp_BFu9i_BFu15ll)
//============================================================================



static void Test_aIp_BFu9i_BFu15s()
{
  {
    init_simple_test("aIp_BFu9i_BFu15s");
    static STRUCT_IF_C aIp_BFu9i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aIp_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aIp_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu15s, aIp_BFu9i_BFu15s)
//============================================================================



static void Test_aIp_BFu9i_BFu16i()
{
  {
    init_simple_test("aIp_BFu9i_BFu16i");
    static STRUCT_IF_C aIp_BFu9i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu9i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aIp_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aIp_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu16i, aIp_BFu9i_BFu16i)
//============================================================================



static void Test_aIp_BFu9i_BFu16ll()
{
  {
    init_simple_test("aIp_BFu9i_BFu16ll");
    static STRUCT_IF_C aIp_BFu9i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu9i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aIp_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aIp_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu16ll, aIp_BFu9i_BFu16ll)
//============================================================================



static void Test_aIp_BFu9i_BFu16s()
{
  {
    init_simple_test("aIp_BFu9i_BFu16s");
    static STRUCT_IF_C aIp_BFu9i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu9i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aIp_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aIp_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu16s, aIp_BFu9i_BFu16s)
//============================================================================



static void Test_aIp_BFu9i_BFu17i()
{
  {
    init_simple_test("aIp_BFu9i_BFu17i");
    static STRUCT_IF_C aIp_BFu9i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu9i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "aIp_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "aIp_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu17i, aIp_BFu9i_BFu17i)
//============================================================================



static void Test_aIp_BFu9i_BFu17ll()
{
  {
    init_simple_test("aIp_BFu9i_BFu17ll");
    static STRUCT_IF_C aIp_BFu9i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu9i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, 1, "aIp_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 17, hide_ull(1LL<<16), "aIp_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu17ll, aIp_BFu9i_BFu17ll)
//============================================================================



static void Test_aIp_BFu9i_BFu1c()
{
  {
    init_simple_test("aIp_BFu9i_BFu1c");
    static STRUCT_IF_C aIp_BFu9i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu9i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aIp_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu1c, aIp_BFu9i_BFu1c)
//============================================================================



static void Test_aIp_BFu9i_BFu1i()
{
  {
    init_simple_test("aIp_BFu9i_BFu1i");
    static STRUCT_IF_C aIp_BFu9i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu9i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aIp_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu1i, aIp_BFu9i_BFu1i)
//============================================================================



static void Test_aIp_BFu9i_BFu1ll()
{
  {
    init_simple_test("aIp_BFu9i_BFu1ll");
    static STRUCT_IF_C aIp_BFu9i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu9i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aIp_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu1ll, aIp_BFu9i_BFu1ll)
//============================================================================



static void Test_aIp_BFu9i_BFu1s()
{
  {
    init_simple_test("aIp_BFu9i_BFu1s");
    static STRUCT_IF_C aIp_BFu9i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu9i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 1, 1, "aIp_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu1s, aIp_BFu9i_BFu1s)
//============================================================================



static void Test_aIp_BFu9i_BFu31i()
{
  {
    init_simple_test("aIp_BFu9i_BFu31i");
    static STRUCT_IF_C aIp_BFu9i_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu9i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, 1, "aIp_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, hide_ull(1LL<<30), "aIp_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu31i, aIp_BFu9i_BFu31i)
//============================================================================



static void Test_aIp_BFu9i_BFu31ll()
{
  {
    init_simple_test("aIp_BFu9i_BFu31ll");
    static STRUCT_IF_C aIp_BFu9i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aIp_BFu9i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, 1, "aIp_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 31, hide_ull(1LL<<30), "aIp_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu31ll, aIp_BFu9i_BFu31ll)
//============================================================================



static void Test_aIp_BFu9i_BFu32i()
{
  {
    init_simple_test("aIp_BFu9i_BFu32i");
    static STRUCT_IF_C aIp_BFu9i_BFu32i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu9i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, 1, "aIp_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, hide_ull(1LL<<31), "aIp_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu32i, aIp_BFu9i_BFu32i)
//============================================================================



static void Test_aIp_BFu9i_BFu32ll()
{
  {
    init_simple_test("aIp_BFu9i_BFu32ll");
    static STRUCT_IF_C aIp_BFu9i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu9i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, 1, "aIp_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 32, hide_ull(1LL<<31), "aIp_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu32ll, aIp_BFu9i_BFu32ll)
//============================================================================



static void Test_aIp_BFu9i_BFu33()
{
  {
    init_simple_test("aIp_BFu9i_BFu33");
    static STRUCT_IF_C aIp_BFu9i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu9i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu33");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 33, 1, "aIp_BFu9i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 33, hide_ull(1LL<<32), "aIp_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu33, aIp_BFu9i_BFu33)
//============================================================================



static void Test_aIp_BFu9i_BFu7c()
{
  {
    init_simple_test("aIp_BFu9i_BFu7c");
    static STRUCT_IF_C aIp_BFu9i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu9i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aIp_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aIp_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu7c, aIp_BFu9i_BFu7c)
//============================================================================



static void Test_aIp_BFu9i_BFu7i()
{
  {
    init_simple_test("aIp_BFu9i_BFu7i");
    static STRUCT_IF_C aIp_BFu9i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu9i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aIp_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aIp_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu7i, aIp_BFu9i_BFu7i)
//============================================================================



static void Test_aIp_BFu9i_BFu7ll()
{
  {
    init_simple_test("aIp_BFu9i_BFu7ll");
    static STRUCT_IF_C aIp_BFu9i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu9i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aIp_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aIp_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu7ll, aIp_BFu9i_BFu7ll)
//============================================================================



static void Test_aIp_BFu9i_BFu7s()
{
  {
    init_simple_test("aIp_BFu9i_BFu7s");
    static STRUCT_IF_C aIp_BFu9i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu9i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, 1, "aIp_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 7, hide_ull(1LL<<6), "aIp_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu7s, aIp_BFu9i_BFu7s)
//============================================================================



static void Test_aIp_BFu9i_BFu8c()
{
  {
    init_simple_test("aIp_BFu9i_BFu8c");
    static STRUCT_IF_C aIp_BFu9i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aIp_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aIp_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu8c, aIp_BFu9i_BFu8c)
//============================================================================



static void Test_aIp_BFu9i_BFu8i()
{
  {
    init_simple_test("aIp_BFu9i_BFu8i");
    static STRUCT_IF_C aIp_BFu9i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aIp_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aIp_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu8i, aIp_BFu9i_BFu8i)
//============================================================================



static void Test_aIp_BFu9i_BFu8ll()
{
  {
    init_simple_test("aIp_BFu9i_BFu8ll");
    static STRUCT_IF_C aIp_BFu9i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aIp_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aIp_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu8ll, aIp_BFu9i_BFu8ll)
//============================================================================



static void Test_aIp_BFu9i_BFu8s()
{
  {
    init_simple_test("aIp_BFu9i_BFu8s");
    static STRUCT_IF_C aIp_BFu9i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, 1, "aIp_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 8, hide_ull(1LL<<7), "aIp_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu8s, aIp_BFu9i_BFu8s)
//============================================================================



static void Test_aIp_BFu9i_BFu9i()
{
  {
    init_simple_test("aIp_BFu9i_BFu9i");
    static STRUCT_IF_C aIp_BFu9i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "aIp_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu9i, aIp_BFu9i_BFu9i)
//============================================================================



static void Test_aIp_BFu9i_BFu9ll()
{
  {
    init_simple_test("aIp_BFu9i_BFu9ll");
    static STRUCT_IF_C aIp_BFu9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "aIp_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu9ll, aIp_BFu9i_BFu9ll)
//============================================================================



static void Test_aIp_BFu9i_BFu9s()
{
  {
    init_simple_test("aIp_BFu9i_BFu9s");
    static STRUCT_IF_C aIp_BFu9i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, 1, "aIp_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 9, hide_ull(1LL<<8), "aIp_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_BFu9s, aIp_BFu9i_BFu9s)
//============================================================================



static void Test_aIp_BFu9i_C()
{
  {
    init_simple_test("aIp_BFu9i_C");
    static STRUCT_IF_C aIp_BFu9i_C lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_C)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_C.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_C");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_C");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_C, aIp_BFu9i_C)
//============================================================================



static void Test_aIp_BFu9i_D()
{
  {
    init_simple_test("aIp_BFu9i_D");
    static STRUCT_IF_C aIp_BFu9i_D lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aIp_BFu9i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_D)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_D.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_D");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_D");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_D, aIp_BFu9i_D)
//============================================================================



static void Test_aIp_BFu9i_F()
{
  {
    init_simple_test("aIp_BFu9i_F");
    static STRUCT_IF_C aIp_BFu9i_F lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu9i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_F)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_F.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_F");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_F");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_F, aIp_BFu9i_F)
//============================================================================



static void Test_aIp_BFu9i_I()
{
  {
    init_simple_test("aIp_BFu9i_I");
    static STRUCT_IF_C aIp_BFu9i_I lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu9i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_I)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_I.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_I");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_I");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_I, aIp_BFu9i_I)
//============================================================================



static void Test_aIp_BFu9i_Ip()
{
  {
    init_simple_test("aIp_BFu9i_Ip");
    static STRUCT_IF_C aIp_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aIp_BFu9i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_Ip");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_Ip");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_Ip, aIp_BFu9i_Ip)
//============================================================================



static void Test_aIp_BFu9i_L()
{
  {
    init_simple_test("aIp_BFu9i_L");
    static STRUCT_IF_C aIp_BFu9i_L lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aIp_BFu9i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_L)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_L.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_L");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_L");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_L, aIp_BFu9i_L)
//============================================================================



static void Test_aIp_BFu9i_S()
{
  {
    init_simple_test("aIp_BFu9i_S");
    static STRUCT_IF_C aIp_BFu9i_S lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu9i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_S)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_S.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_S");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_S");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_S, aIp_BFu9i_S)
//============================================================================



static void Test_aIp_BFu9i_Uc()
{
  {
    init_simple_test("aIp_BFu9i_Uc");
    static STRUCT_IF_C aIp_BFu9i_Uc lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_Uc");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_Uc");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_Uc, aIp_BFu9i_Uc)
//============================================================================



static void Test_aIp_BFu9i_Ui()
{
  {
    init_simple_test("aIp_BFu9i_Ui");
    static STRUCT_IF_C aIp_BFu9i_Ui lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aIp_BFu9i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_Ui");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_Ui");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_Ui, aIp_BFu9i_Ui)
//============================================================================



static void Test_aIp_BFu9i_Ul()
{
  {
    init_simple_test("aIp_BFu9i_Ul");
    static STRUCT_IF_C aIp_BFu9i_Ul lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aIp_BFu9i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_Ul");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_Ul");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_Ul, aIp_BFu9i_Ul)
//============================================================================



static void Test_aIp_BFu9i_Us()
{
  {
    init_simple_test("aIp_BFu9i_Us");
    static STRUCT_IF_C aIp_BFu9i_Us lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu9i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_Us");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_Us");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_Us, aIp_BFu9i_Us)
//============================================================================



static void Test_aIp_BFu9i_Vp()
{
  {
    init_simple_test("aIp_BFu9i_Vp");
    static STRUCT_IF_C aIp_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(18,10), "sizeof(aIp_BFu9i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "aIp_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9i_Vp");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9i_Vp");
    check_field_offset(lv, v3, ABISELECT(10,6), "aIp_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9i_Vp, aIp_BFu9i_Vp)
//============================================================================



static void Test_aIp_BFu9ll()
{
  {
    init_simple_test("aIp_BFu9ll");
    static STRUCT_IF_C aIp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aIp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu9ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9ll, aIp_BFu9ll)
//============================================================================



static void Test_aIp_BFu9ll_BFu15i()
{
  {
    init_simple_test("aIp_BFu9ll_BFu15i");
    static STRUCT_IF_C aIp_BFu9ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aIp_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aIp_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aIp_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9ll_BFu15i, aIp_BFu9ll_BFu15i)
//============================================================================



static void Test_aIp_BFu9ll_BFu15ll()
{
  {
    init_simple_test("aIp_BFu9ll_BFu15ll");
    static STRUCT_IF_C aIp_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aIp_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aIp_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9ll_BFu15ll, aIp_BFu9ll_BFu15ll)
//============================================================================



static void Test_aIp_BFu9ll_BFu15s()
{
  {
    init_simple_test("aIp_BFu9ll_BFu15s");
    static STRUCT_IF_C aIp_BFu9ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aIp_BFu9ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aIp_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, 1, "aIp_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 15, hide_ull(1LL<<14), "aIp_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9ll_BFu15s, aIp_BFu9ll_BFu15s)
//============================================================================



static void Test_aIp_BFu9ll_BFu16i()
{
  {
    init_simple_test("aIp_BFu9ll_BFu16i");
    static STRUCT_IF_C aIp_BFu9ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu9ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aIp_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aIp_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aIp_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9ll_BFu16i, aIp_BFu9ll_BFu16i)
//============================================================================



static void Test_aIp_BFu9ll_BFu16ll()
{
  {
    init_simple_test("aIp_BFu9ll_BFu16ll");
    static STRUCT_IF_C aIp_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aIp_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aIp_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, 1, "aIp_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 1, 16, hide_ull(1LL<<15), "aIp_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aIp_BFu9ll_BFu16ll, aIp_BFu9ll_BFu16ll)
//============================================================================



static void Test_aIp_BFu9ll_BFu16s()
{
  {
    init_simple_test("aIp_BFu9ll_BFu16s");
    static STRUCT_IF_C aIp_BFu9ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aIp_BFu9ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aIp_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aIp_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, 1, "aIp_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, ABISELECT(8,4), 0, 9, hide_ull(1LL<<8), "aI