// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
struct __attribute__((packed)) aF_BFu1i_L { float v1; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aF_BFu1i_S { float v1; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aF_BFu1i_Uc { float v1; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aF_BFu1i_Ui { float v1; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aF_BFu1i_Ul { float v1; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu1i_Us { float v1; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aF_BFu1i_Vp { float v1; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aF_BFu1ll { float v1; unsigned long long v2:1; };
struct __attribute__((packed)) aF_BFu1ll_BFu15i { float v1; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu1ll_BFu15ll { float v1; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu1ll_BFu15s { float v1; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu1ll_BFu16i { float v1; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu1ll_BFu16ll { float v1; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu1ll_BFu16s { float v1; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu1ll_BFu17i { float v1; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu1ll_BFu17ll { float v1; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu1ll_BFu1c { float v1; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu1ll_BFu1i { float v1; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu1ll_BFu1ll { float v1; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu1ll_BFu1s { float v1; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu1ll_BFu31i { float v1; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu1ll_BFu31ll { float v1; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu1ll_BFu32i { float v1; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu1ll_BFu32ll { float v1; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu1ll_BFu33 { float v1; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu1ll_BFu7c { float v1; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu1ll_BFu7i { float v1; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu1ll_BFu7ll { float v1; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu1ll_BFu7s { float v1; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu1ll_BFu8c { float v1; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu1ll_BFu8i { float v1; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu1ll_BFu8ll { float v1; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu1ll_BFu8s { float v1; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu1ll_BFu9i { float v1; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu1ll_BFu9ll { float v1; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu1ll_BFu9s { float v1; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu1ll_C { float v1; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aF_BFu1ll_D { float v1; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aF_BFu1ll_F { float v1; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aF_BFu1ll_I { float v1; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aF_BFu1ll_Ip { float v1; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aF_BFu1ll_L { float v1; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aF_BFu1ll_S { float v1; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aF_BFu1ll_Uc { float v1; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aF_BFu1ll_Ui { float v1; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aF_BFu1ll_Ul { float v1; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu1ll_Us { float v1; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aF_BFu1ll_Vp { float v1; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aF_BFu1s { float v1; unsigned short v2:1; };
struct __attribute__((packed)) aF_BFu1s_BFu15i { float v1; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu1s_BFu15ll { float v1; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu1s_BFu15s { float v1; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu1s_BFu16i { float v1; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu1s_BFu16ll { float v1; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu1s_BFu16s { float v1; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu1s_BFu17i { float v1; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu1s_BFu17ll { float v1; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu1s_BFu1c { float v1; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu1s_BFu1i { float v1; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu1s_BFu1ll { float v1; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu1s_BFu1s { float v1; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu1s_BFu31i { float v1; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu1s_BFu31ll { float v1; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu1s_BFu32i { float v1; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu1s_BFu32ll { float v1; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu1s_BFu33 { float v1; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu1s_BFu7c { float v1; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu1s_BFu7i { float v1; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu1s_BFu7ll { float v1; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu1s_BFu7s { float v1; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu1s_BFu8c { float v1; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu1s_BFu8i { float v1; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu1s_BFu8ll { float v1; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu1s_BFu8s { float v1; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu1s_BFu9i { float v1; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu1s_BFu9ll { float v1; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu1s_BFu9s { float v1; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu1s_C { float v1; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aF_BFu1s_D { float v1; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aF_BFu1s_F { float v1; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aF_BFu1s_I { float v1; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aF_BFu1s_Ip { float v1; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aF_BFu1s_L { float v1; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aF_BFu1s_S { float v1; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aF_BFu1s_Uc { float v1; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aF_BFu1s_Ui { float v1; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aF_BFu1s_Ul { float v1; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu1s_Us { float v1; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aF_BFu1s_Vp { float v1; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aF_BFu31i { float v1; unsigned int v2:31; };
struct __attribute__((packed)) aF_BFu31i_BFu15i { float v1; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu31i_BFu15ll { float v1; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu31i_BFu15s { float v1; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu31i_BFu16i { float v1; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu31i_BFu16ll { float v1; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu31i_BFu16s { float v1; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu31i_BFu17i { float v1; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu31i_BFu17ll { float v1; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu31i_BFu1c { float v1; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu31i_BFu1i { float v1; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu31i_BFu1ll { float v1; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu31i_BFu1s { float v1; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu31i_BFu31i { float v1; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu31i_BFu31ll { float v1; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu31i_BFu32i { float v1; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu31i_BFu32ll { float v1; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu31i_BFu33 { float v1; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu31i_BFu7c { float v1; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu31i_BFu7i { float v1; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu31i_BFu7ll { float v1; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu31i_BFu7s { float v1; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu31i_BFu8c { float v1; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu31i_BFu8i { float v1; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu31i_BFu8ll { float v1; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu31i_BFu8s { float v1; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu31i_BFu9i { float v1; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu31i_BFu9ll { float v1; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu31i_BFu9s { float v1; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu31i_C { float v1; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aF_BFu31i_D { float v1; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aF_BFu31i_F { float v1; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aF_BFu31i_I { float v1; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aF_BFu31i_Ip { float v1; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aF_BFu31i_L { float v1; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aF_BFu31i_S { float v1; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aF_BFu31i_Uc { float v1; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aF_BFu31i_Ui { float v1; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aF_BFu31i_Ul { float v1; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu31i_Us { float v1; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aF_BFu31i_Vp { float v1; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aF_BFu31ll { float v1; unsigned long long v2:31; };
struct __attribute__((packed)) aF_BFu31ll_BFu15i { float v1; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu31ll_BFu15ll { float v1; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu31ll_BFu15s { float v1; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu31ll_BFu16i { float v1; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu31ll_BFu16ll { float v1; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu31ll_BFu16s { float v1; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu31ll_BFu17i { float v1; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu31ll_BFu17ll { float v1; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu31ll_BFu1c { float v1; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu31ll_BFu1i { float v1; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu31ll_BFu1ll { float v1; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu31ll_BFu1s { float v1; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu31ll_BFu31i { float v1; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu31ll_BFu31ll { float v1; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu31ll_BFu32i { float v1; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu31ll_BFu32ll { float v1; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu31ll_BFu33 { float v1; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu31ll_BFu7c { float v1; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu31ll_BFu7i { float v1; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu31ll_BFu7ll { float v1; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu31ll_BFu7s { float v1; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu31ll_BFu8c { float v1; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu31ll_BFu8i { float v1; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu31ll_BFu8ll { float v1; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu31ll_BFu8s { float v1; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu31ll_BFu9i { float v1; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu31ll_BFu9ll { float v1; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu31ll_BFu9s { float v1; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu31ll_C { float v1; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aF_BFu31ll_D { float v1; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aF_BFu31ll_F { float v1; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aF_BFu31ll_I { float v1; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aF_BFu31ll_Ip { float v1; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aF_BFu31ll_L { float v1; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aF_BFu31ll_S { float v1; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aF_BFu31ll_Uc { float v1; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aF_BFu31ll_Ui { float v1; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aF_BFu31ll_Ul { float v1; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu31ll_Us { float v1; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aF_BFu31ll_Vp { float v1; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aF_BFu32i { float v1; unsigned int v2:32; };
struct __attribute__((packed)) aF_BFu32i_BFu15i { float v1; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu32i_BFu15ll { float v1; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu32i_BFu15s { float v1; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu32i_BFu16i { float v1; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu32i_BFu16ll { float v1; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu32i_BFu16s { float v1; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu32i_BFu17i { float v1; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu32i_BFu17ll { float v1; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu32i_BFu1c { float v1; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu32i_BFu1i { float v1; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu32i_BFu1ll { float v1; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu32i_BFu1s { float v1; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu32i_BFu31i { float v1; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu32i_BFu31ll { float v1; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu32i_BFu32i { float v1; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu32i_BFu32ll { float v1; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu32i_BFu33 { float v1; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu32i_BFu7c { float v1; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu32i_BFu7i { float v1; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu32i_BFu7ll { float v1; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu32i_BFu7s { float v1; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu32i_BFu8c { float v1; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu32i_BFu8i { float v1; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu32i_BFu8ll { float v1; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu32i_BFu8s { float v1; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu32i_BFu9i { float v1; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu32i_BFu9ll { float v1; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu32i_BFu9s { float v1; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu32i_C { float v1; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aF_BFu32i_D { float v1; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aF_BFu32i_F { float v1; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aF_BFu32i_I { float v1; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aF_BFu32i_Ip { float v1; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aF_BFu32i_L { float v1; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aF_BFu32i_S { float v1; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aF_BFu32i_Uc { float v1; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aF_BFu32i_Ui { float v1; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aF_BFu32i_Ul { float v1; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu32i_Us { float v1; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aF_BFu32i_Vp { float v1; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aF_BFu32ll { float v1; unsigned long long v2:32; };
struct __attribute__((packed)) aF_BFu32ll_BFu15i { float v1; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu32ll_BFu15ll { float v1; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu32ll_BFu15s { float v1; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu32ll_BFu16i { float v1; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu32ll_BFu16ll { float v1; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu32ll_BFu16s { float v1; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu32ll_BFu17i { float v1; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu32ll_BFu17ll { float v1; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu32ll_BFu1c { float v1; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu32ll_BFu1i { float v1; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu32ll_BFu1ll { float v1; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu32ll_BFu1s { float v1; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu32ll_BFu31i { float v1; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu32ll_BFu31ll { float v1; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu32ll_BFu32i { float v1; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu32ll_BFu32ll { float v1; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu32ll_BFu33 { float v1; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu32ll_BFu7c { float v1; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu32ll_BFu7i { float v1; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu32ll_BFu7ll { float v1; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu32ll_BFu7s { float v1; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu32ll_BFu8c { float v1; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu32ll_BFu8i { float v1; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu32ll_BFu8ll { float v1; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu32ll_BFu8s { float v1; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu32ll_BFu9i { float v1; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu32ll_BFu9ll { float v1; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu32ll_BFu9s { float v1; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu32ll_C { float v1; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aF_BFu32ll_D { float v1; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aF_BFu32ll_F { float v1; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aF_BFu32ll_I { float v1; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aF_BFu32ll_Ip { float v1; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aF_BFu32ll_L { float v1; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aF_BFu32ll_S { float v1; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aF_BFu32ll_Uc { float v1; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aF_BFu32ll_Ui { float v1; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aF_BFu32ll_Ul { float v1; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu32ll_Us { float v1; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aF_BFu32ll_Vp { float v1; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aF_BFu33 { float v1; unsigned long long v2:33; };
struct __attribute__((packed)) aF_BFu33_BFu15i { float v1; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu33_BFu15ll { float v1; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu33_BFu15s { float v1; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu33_BFu16i { float v1; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu33_BFu16ll { float v1; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu33_BFu16s { float v1; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu33_BFu17i { float v1; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu33_BFu17ll { float v1; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu33_BFu1c { float v1; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu33_BFu1i { float v1; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu33_BFu1ll { float v1; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu33_BFu1s { float v1; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu33_BFu31i { float v1; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu33_BFu31ll { float v1; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu33_BFu32i { float v1; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu33_BFu32ll { float v1; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu33_BFu33 { float v1; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu33_BFu7c { float v1; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu33_BFu7i { float v1; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu33_BFu7ll { float v1; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu33_BFu7s { float v1; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu33_BFu8c { float v1; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu33_BFu8i { float v1; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu33_BFu8ll { float v1; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu33_BFu8s { float v1; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu33_BFu9i { float v1; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu33_BFu9ll { float v1; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu33_BFu9s { float v1; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu33_C { float v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aF_BFu33_D { float v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aF_BFu33_F { float v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aF_BFu33_I { float v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aF_BFu33_Ip { float v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aF_BFu33_L { float v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aF_BFu33_S { float v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aF_BFu33_Uc { float v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aF_BFu33_Ui { float v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aF_BFu33_Ul { float v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu33_Us { float v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aF_BFu33_Vp { float v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aF_BFu7c { float v1; unsigned char v2:7; };
struct __attribute__((packed)) aF_BFu7c_BFu15i { float v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu7c_BFu15ll { float v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu7c_BFu15s { float v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu7c_BFu16i { float v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu7c_BFu16ll { float v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu7c_BFu16s { float v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu7c_BFu17i { float v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu7c_BFu17ll { float v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu7c_BFu1c { float v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu7c_BFu1i { float v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu7c_BFu1ll { float v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu7c_BFu1s { float v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu7c_BFu31i { float v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu7c_BFu31ll { float v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu7c_BFu32i { float v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu7c_BFu32ll { float v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu7c_BFu33 { float v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu7c_BFu7c { float v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu7c_BFu7i { float v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu7c_BFu7ll { float v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu7c_BFu7s { float v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu7c_BFu8c { float v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu7c_BFu8i { float v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu7c_BFu8ll { float v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu7c_BFu8s { float v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu7c_BFu9i { float v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu7c_BFu9ll { float v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu7c_BFu9s { float v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu7c_C { float v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aF_BFu7c_D { float v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aF_BFu7c_F { float v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aF_BFu7c_I { float v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aF_BFu7c_Ip { float v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aF_BFu7c_L { float v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aF_BFu7c_S { float v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aF_BFu7c_Uc { float v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aF_BFu7c_Ui { float v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aF_BFu7c_Ul { float v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu7c_Us { float v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aF_BFu7c_Vp { float v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aF_BFu7i { float v1; unsigned int v2:7; };
struct __attribute__((packed)) aF_BFu7i_BFu15i { float v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu7i_BFu15ll { float v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu7i_BFu15s { float v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu7i_BFu16i { float v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu7i_BFu16ll { float v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu7i_BFu16s { float v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu7i_BFu17i { float v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu7i_BFu17ll { float v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu7i_BFu1c { float v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu7i_BFu1i { float v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu7i_BFu1ll { float v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu7i_BFu1s { float v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu7i_BFu31i { float v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu7i_BFu31ll { float v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu7i_BFu32i { float v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu7i_BFu32ll { float v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu7i_BFu33 { float v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu7i_BFu7c { float v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu7i_BFu7i { float v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu7i_BFu7ll { float v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu7i_BFu7s { float v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu7i_BFu8c { float v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu7i_BFu8i { float v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu7i_BFu8ll { float v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu7i_BFu8s { float v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu7i_BFu9i { float v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu7i_BFu9ll { float v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu7i_BFu9s { float v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu7i_C { float v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aF_BFu7i_D { float v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aF_BFu7i_F { float v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aF_BFu7i_I { float v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aF_BFu7i_Ip { float v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aF_BFu7i_L { float v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aF_BFu7i_S { float v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aF_BFu7i_Uc { float v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aF_BFu7i_Ui { float v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aF_BFu7i_Ul { float v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu7i_Us { float v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aF_BFu7i_Vp { float v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aF_BFu7ll { float v1; unsigned long long v2:7; };
struct __attribute__((packed)) aF_BFu7ll_BFu15i { float v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu7ll_BFu15ll { float v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu7ll_BFu15s { float v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu7ll_BFu16i { float v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu7ll_BFu16ll { float v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu7ll_BFu16s { float v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu7ll_BFu17i { float v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu7ll_BFu17ll { float v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu7ll_BFu1c { float v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu7ll_BFu1i { float v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu7ll_BFu1ll { float v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu7ll_BFu1s { float v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu7ll_BFu31i { float v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu7ll_BFu31ll { float v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu7ll_BFu32i { float v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu7ll_BFu32ll { float v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu7ll_BFu33 { float v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu7ll_BFu7c { float v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu7ll_BFu7i { float v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu7ll_BFu7ll { float v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu7ll_BFu7s { float v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu7ll_BFu8c { float v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu7ll_BFu8i { float v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu7ll_BFu8ll { float v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu7ll_BFu8s { float v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu7ll_BFu9i { float v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu7ll_BFu9ll { float v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu7ll_BFu9s { float v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu7ll_C { float v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aF_BFu7ll_D { float v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aF_BFu7ll_F { float v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aF_BFu7ll_I { float v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aF_BFu7ll_Ip { float v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aF_BFu7ll_L { float v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aF_BFu7ll_S { float v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aF_BFu7ll_Uc { float v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aF_BFu7ll_Ui { float v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aF_BFu7ll_Ul { float v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu7ll_Us { float v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aF_BFu7ll_Vp { float v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aF_BFu7s { float v1; unsigned short v2:7; };
struct __attribute__((packed)) aF_BFu7s_BFu15i { float v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu7s_BFu15ll { float v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu7s_BFu15s { float v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu7s_BFu16i { float v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu7s_BFu16ll { float v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu7s_BFu16s { float v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu7s_BFu17i { float v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu7s_BFu17ll { float v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu7s_BFu1c { float v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu7s_BFu1i { float v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu7s_BFu1ll { float v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu7s_BFu1s { float v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu7s_BFu31i { float v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu7s_BFu31ll { float v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu7s_BFu32i { float v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu7s_BFu32ll { float v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu7s_BFu33 { float v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu7s_BFu7c { float v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu7s_BFu7i { float v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu7s_BFu7ll { float v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu7s_BFu7s { float v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu7s_BFu8c { float v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu7s_BFu8i { float v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu7s_BFu8ll { float v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu7s_BFu8s { float v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu7s_BFu9i { float v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu7s_BFu9ll { float v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu7s_BFu9s { float v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu7s_C { float v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aF_BFu7s_D { float v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aF_BFu7s_F { float v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aF_BFu7s_I { float v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aF_BFu7s_Ip { float v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aF_BFu7s_L { float v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aF_BFu7s_S { float v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aF_BFu7s_Uc { float v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aF_BFu7s_Ui { float v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aF_BFu7s_Ul { float v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu7s_Us { float v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aF_BFu7s_Vp { float v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aF_BFu8c { float v1; unsigned char v2:8; };
struct __attribute__((packed)) aF_BFu8c_BFu15i { float v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu8c_BFu15ll { float v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu8c_BFu15s { float v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu8c_BFu16i { float v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu8c_BFu16ll { float v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu8c_BFu16s { float v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu8c_BFu17i { float v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu8c_BFu17ll { float v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu8c_BFu1c { float v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu8c_BFu1i { float v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu8c_BFu1ll { float v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu8c_BFu1s { float v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu8c_BFu31i { float v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu8c_BFu31ll { float v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu8c_BFu32i { float v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu8c_BFu32ll { float v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu8c_BFu33 { float v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu8c_BFu7c { float v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu8c_BFu7i { float v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu8c_BFu7ll { float v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu8c_BFu7s { float v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu8c_BFu8c { float v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu8c_BFu8i { float v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu8c_BFu8ll { float v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu8c_BFu8s { float v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu8c_BFu9i { float v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu8c_BFu9ll { float v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu8c_BFu9s { float v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu8c_C { float v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aF_BFu8c_D { float v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aF_BFu8c_F { float v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aF_BFu8c_I { float v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aF_BFu8c_Ip { float v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aF_BFu8c_L { float v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aF_BFu8c_S { float v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aF_BFu8c_Uc { float v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aF_BFu8c_Ui { float v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aF_BFu8c_Ul { float v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu8c_Us { float v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aF_BFu8c_Vp { float v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aF_BFu8i { float v1; unsigned int v2:8; };
struct __attribute__((packed)) aF_BFu8i_BFu15i { float v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu8i_BFu15ll { float v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu8i_BFu15s { float v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu8i_BFu16i { float v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu8i_BFu16ll { float v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu8i_BFu16s { float v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu8i_BFu17i { float v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu8i_BFu17ll { float v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu8i_BFu1c { float v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu8i_BFu1i { float v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu8i_BFu1ll { float v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu8i_BFu1s { float v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu8i_BFu31i { float v1; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu8i_BFu31ll { float v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu8i_BFu32i { float v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu8i_BFu32ll { float v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu8i_BFu33 { float v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu8i_BFu7c { float v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu8i_BFu7i { float v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu8i_BFu7ll { float v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu8i_BFu7s { float v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu8i_BFu8c { float v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu8i_BFu8i { float v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu8i_BFu8ll { float v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu8i_BFu8s { float v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu8i_BFu9i { float v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu8i_BFu9ll { float v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu8i_BFu9s { float v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu8i_C { float v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aF_BFu8i_D { float v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aF_BFu8i_F { float v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aF_BFu8i_I { float v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aF_BFu8i_Ip { float v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aF_BFu8i_L { float v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aF_BFu8i_S { float v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aF_BFu8i_Uc { float v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aF_BFu8i_Ui { float v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aF_BFu8i_Ul { float v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu8i_Us { float v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aF_BFu8i_Vp { float v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aF_BFu8ll { float v1; unsigned long long v2:8; };
struct __attribute__((packed)) aF_BFu8ll_BFu15i { float v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu8ll_BFu15ll { float v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu8ll_BFu15s { float v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu8ll_BFu16i { float v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu8ll_BFu16ll { float v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu8ll_BFu16s { float v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu8ll_BFu17i { float v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu8ll_BFu17ll { float v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu8ll_BFu1c { float v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu8ll_BFu1i { float v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu8ll_BFu1ll { float v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu8ll_BFu1s { float v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu8ll_BFu31i { float v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu8ll_BFu31ll { float v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu8ll_BFu32i { float v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu8ll_BFu32ll { float v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu8ll_BFu33 { float v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu8ll_BFu7c { float v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu8ll_BFu7i { float v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu8ll_BFu7ll { float v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu8ll_BFu7s { float v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu8ll_BFu8c { float v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu8ll_BFu8i { float v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu8ll_BFu8ll { float v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu8ll_BFu8s { float v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu8ll_BFu9i { float v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu8ll_BFu9ll { float v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu8ll_BFu9s { float v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu8ll_C { float v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aF_BFu8ll_D { float v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aF_BFu8ll_F { float v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aF_BFu8ll_I { float v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aF_BFu8ll_Ip { float v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aF_BFu8ll_L { float v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aF_BFu8ll_S { float v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aF_BFu8ll_Uc { float v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aF_BFu8ll_Ui { float v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aF_BFu8ll_Ul { float v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu8ll_Us { float v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aF_BFu8ll_Vp { float v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aF_BFu8s { float v1; unsigned short v2:8; };
struct __attribute__((packed)) aF_BFu8s_BFu15i { float v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu8s_BFu15ll { float v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu8s_BFu15s { float v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu8s_BFu16i { float v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu8s_BFu16ll { float v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu8s_BFu16s { float v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu8s_BFu17i { float v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu8s_BFu17ll { float v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu8s_BFu1c { float v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu8s_BFu1i { float v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu8s_BFu1ll { float v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu8s_BFu1s { float v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu8s_BFu31i { float v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu8s_BFu31ll { float v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu8s_BFu32i { float v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu8s_BFu32ll { float v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu8s_BFu33 { float v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu8s_BFu7c { float v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu8s_BFu7i { float v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu8s_BFu7ll { float v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu8s_BFu7s { float v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu8s_BFu8c { float v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu8s_BFu8i { float v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu8s_BFu8ll { float v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu8s_BFu8s { float v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu8s_BFu9i { float v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu8s_BFu9ll { float v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu8s_BFu9s { float v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu8s_C { float v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aF_BFu8s_D { float v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aF_BFu8s_F { float v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aF_BFu8s_I { float v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aF_BFu8s_Ip { float v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aF_BFu8s_L { float v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aF_BFu8s_S { float v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aF_BFu8s_Uc { float v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aF_BFu8s_Ui { float v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aF_BFu8s_Ul { float v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu8s_Us { float v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aF_BFu8s_Vp { float v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aF_BFu9i { float v1; unsigned int v2:9; };
struct __attribute__((packed)) aF_BFu9i_BFu15i { float v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu9i_BFu15ll { float v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu9i_BFu15s { float v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu9i_BFu16i { float v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu9i_BFu16ll { float v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu9i_BFu16s { float v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu9i_BFu17i { float v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu9i_BFu17ll { float v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu9i_BFu1c { float v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu9i_BFu1i { float v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu9i_BFu1ll { float v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu9i_BFu1s { float v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu9i_BFu31i { float v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu9i_BFu31ll { float v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu9i_BFu32i { float v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu9i_BFu32ll { float v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu9i_BFu33 { float v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu9i_BFu7c { float v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu9i_BFu7i { float v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu9i_BFu7ll { float v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu9i_BFu7s { float v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu9i_BFu8c { float v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu9i_BFu8i { float v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu9i_BFu8ll { float v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu9i_BFu8s { float v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu9i_BFu9i { float v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu9i_BFu9ll { float v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu9i_BFu9s { float v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu9i_C { float v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aF_BFu9i_D { float v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aF_BFu9i_F { float v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aF_BFu9i_I { float v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aF_BFu9i_Ip { float v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aF_BFu9i_L { float v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aF_BFu9i_S { float v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aF_BFu9i_Uc { float v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aF_BFu9i_Ui { float v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aF_BFu9i_Ul { float v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu9i_Us { float v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aF_BFu9i_Vp { float v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aF_BFu9ll { float v1; unsigned long long v2:9; };
struct __attribute__((packed)) aF_BFu9ll_BFu15i { float v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu9ll_BFu15ll { float v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu9ll_BFu15s { float v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu9ll_BFu16i { float v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu9ll_BFu16ll { float v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu9ll_BFu16s { float v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu9ll_BFu17i { float v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu9ll_BFu17ll { float v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu9ll_BFu1c { float v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu9ll_BFu1i { float v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu9ll_BFu1ll { float v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu9ll_BFu1s { float v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu9ll_BFu31i { float v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu9ll_BFu31ll { float v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu9ll_BFu32i { float v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu9ll_BFu32ll { float v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu9ll_BFu33 { float v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu9ll_BFu7c { float v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu9ll_BFu7i { float v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu9ll_BFu7ll { float v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu9ll_BFu7s { float v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu9ll_BFu8c { float v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu9ll_BFu8i { float v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu9ll_BFu8ll { float v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu9ll_BFu8s { float v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu9ll_BFu9i { float v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu9ll_BFu9ll { float v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu9ll_BFu9s { float v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu9ll_C { float v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aF_BFu9ll_D { float v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aF_BFu9ll_F { float v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aF_BFu9ll_I { float v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aF_BFu9ll_Ip { float v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aF_BFu9ll_L { float v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aF_BFu9ll_S { float v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aF_BFu9ll_Uc { float v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aF_BFu9ll_Ui { float v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aF_BFu9ll_Ul { float v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu9ll_Us { float v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aF_BFu9ll_Vp { float v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aF_BFu9s { float v1; unsigned short v2:9; };
struct __attribute__((packed)) aF_BFu9s_BFu15i { float v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu9s_BFu15ll { float v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu9s_BFu15s { float v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu9s_BFu16i { float v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu9s_BFu16ll { float v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu9s_BFu16s { float v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu9s_BFu17i { float v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu9s_BFu17ll { float v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu9s_BFu1c { float v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu9s_BFu1i { float v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu9s_BFu1ll { float v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu9s_BFu1s { float v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu9s_BFu31i { float v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu9s_BFu31ll { float v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu9s_BFu32i { float v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu9s_BFu32ll { float v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu9s_BFu33 { float v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu9s_BFu7c { float v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu9s_BFu7i { float v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu9s_BFu7ll { float v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu9s_BFu7s { float v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu9s_BFu8c { float v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu9s_BFu8i { float v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu9s_BFu8ll { float v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu9s_BFu8s { float v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu9s_BFu9i { float v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu9s_BFu9ll { float v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu9s_BFu9s { float v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu9s_C { float v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aF_BFu9s_D { float v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aF_BFu9s_F { float v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aF_BFu9s_I { float v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aF_BFu9s_Ip { float v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aF_BFu9s_L { float v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aF_BFu9s_S { float v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aF_BFu9s_Uc { float v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aF_BFu9s_Ui { float v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aF_BFu9s_Ul { float v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu9s_Us { float v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aF_BFu9s_Vp { float v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aF_C { float v1; char v2; };
struct __attribute__((packed)) aF_C_BFu15i { float v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_C_BFu15ll { float v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_C_BFu15s { float v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_C_BFu16i { float v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_C_BFu16ll { float v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_C_BFu16s { float v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_C_BFu17i { float v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_C_BFu17ll { float v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_C_BFu1c { float v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_C_BFu1i { float v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_C_BFu1ll { float v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_C_BFu1s { float v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_C_BFu31i { float v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_C_BFu31ll { float v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_C_BFu32i { float v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_C_BFu32ll { float v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_C_BFu33 { float v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_C_BFu7c { float v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_C_BFu7i { float v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_C_BFu7ll { float v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_C_BFu7s { float v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_C_BFu8c { float v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_C_BFu8i { float v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_C_BFu8ll { float v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_C_BFu8s { float v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_C_BFu9i { float v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_C_BFu9ll { float v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_C_BFu9s { float v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_C_C { float v1; char v2; char v3; };
struct __attribute__((packed)) aF_C_D { float v1; char v2; double v3; };
struct __attribute__((packed)) aF_C_F { float v1; char v2; float v3; };
struct __attribute__((packed)) aF_C_I { float v1; char v2; int v3; };
struct __attribute__((packed)) aF_C_Ip { float v1; char v2; int * v3; };
struct __attribute__((packed)) aF_C_L { float v1; char v2; long long v3; };
struct __attribute__((packed)) aF_C_S { float v1; char v2; short v3; };
struct __attribute__((packed)) aF_C_Uc { float v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aF_C_Ui { float v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aF_C_Ul { float v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aF_C_Us { float v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aF_C_Vp { float v1; char v2; void * v3; };
struct __attribute__((packed)) aF_D { float v1; double v2; };
struct __attribute__((packed)) aF_D_BFu15i { float v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_D_BFu15ll { float v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_D_BFu15s { float v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_D_BFu16i { float v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_D_BFu16ll { float v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_D_BFu16s { float v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_D_BFu17i { float v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_D_BFu17ll { float v1; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_D_BFu1c { float v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_D_BFu1i { float v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_D_BFu1ll { float v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_D_BFu1s { float v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_D_BFu31i { float v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_D_BFu31ll { float v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_D_BFu32i { float v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_D_BFu32ll { float v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_D_BFu33 { float v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_D_BFu7c { float v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_D_BFu7i { float v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_D_BFu7ll { float v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_D_BFu7s { float v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_D_BFu8c { float v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_D_BFu8i { float v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_D_BFu8ll { float v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_D_BFu8s { float v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_D_BFu9i { float v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_D_BFu9ll { float v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_D_BFu9s { float v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_D_C { float v1; double v2; char v3; };
struct __attribute__((packed)) aF_D_D { float v1; double v2; double v3; };
struct __attribute__((packed)) aF_D_F { float v1; double v2; float v3; };
struct __attribute__((packed)) aF_D_I { float v1; double v2; int v3; };
struct __attribute__((packed)) aF_D_Ip { float v1; double v2; int * v3; };
struct __attribute__((packed)) aF_D_L { float v1; double v2; long long v3; };
struct __attribute__((packed)) aF_D_S { float v1; double v2; short v3; };
struct __attribute__((packed)) aF_D_Uc { float v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aF_D_Ui { float v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aF_D_Ul { float v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aF_D_Us { float v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aF_D_Vp { float v1; double v2; void * v3; };
struct __attribute__((packed)) aF_F { float v1; float v2; };
struct __attribute__((packed)) aF_F_BFu15i { float v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_F_BFu15ll { float v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_F_BFu15s { float v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_F_BFu16i { float v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_F_BFu16ll { float v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_F_BFu16s { float v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_F_BFu17i { float v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_F_BFu17ll { float v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_F_BFu1c { float v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_F_BFu1i { float v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_F_BFu1ll { float v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_F_BFu1s { float v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_F_BFu31i { float v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_F_BFu31ll { float v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_F_BFu32i { float v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_F_BFu32ll { float v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_F_BFu33 { float v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_F_BFu7c { float v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_F_BFu7i { float v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_F_BFu7ll { float v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_F_BFu7s { float v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_F_BFu8c { float v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_F_BFu8i { float v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_F_BFu8ll { float v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_F_BFu8s { float v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_F_BFu9i { float v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_F_BFu9ll { float v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_F_BFu9s { float v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_F_C { float v1; float v2; char v3; };
struct __attribute__((packed)) aF_F_D { float v1; float v2; double v3; };
struct __attribute__((packed)) aF_F_F { float v1; float v2; float v3; };
struct __attribute__((packed)) aF_F_I { float v1; float v2; int v3; };
struct __attribute__((packed)) aF_F_Ip { float v1; float v2; int * v3; };
struct __attribute__((packed)) aF_F_L { float v1; float v2; long long v3; };
struct __attribute__((packed)) aF_F_S { float v1; float v2; short v3; };
struct __attribute__((packed)) aF_F_Uc { float v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aF_F_Ui { float v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aF_F_Ul { float v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aF_F_Us { float v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aF_F_Vp { float v1; float v2; void * v3; };
struct __attribute__((packed)) aF_I { float v1; int v2; };
struct __attribute__((packed)) aF_I_BFu15i { float v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_I_BFu15ll { float v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_I_BFu15s { float v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_I_BFu16i { float v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_I_BFu16ll { float v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_I_BFu16s { float v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_I_BFu17i { float v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_I_BFu17ll { float v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_I_BFu1c { float v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_I_BFu1i { float v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_I_BFu1ll { float v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_I_BFu1s { float v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_I_BFu31i { float v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_I_BFu31ll { float v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_I_BFu32i { float v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_I_BFu32ll { float v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_I_BFu33 { float v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_I_BFu7c { float v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_I_BFu7i { float v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_I_BFu7ll { float v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_I_BFu7s { float v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_I_BFu8c { float v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_I_BFu8i { float v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_I_BFu8ll { float v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_I_BFu8s { float v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_I_BFu9i { float v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_I_BFu9ll { float v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_I_BFu9s { float v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_I_C { float v1; int v2; char v3; };
struct __attribute__((packed)) aF_I_D { float v1; int v2; double v3; };
struct __attribute__((packed)) aF_I_F { float v1; int v2; float v3; };
struct __attribute__((packed)) aF_I_I { float v1; int v2; int v3; };
struct __attribute__((packed)) aF_I_Ip { float v1; int v2; int * v3; };
struct __attribute__((packed)) aF_I_L { float v1; int v2; long long v3; };
struct __attribute__((packed)) aF_I_S { float v1; int v2; short v3; };
struct __attribute__((packed)) aF_I_Uc { float v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aF_I_Ui { float v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aF_I_Ul { float v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aF_I_Us { float v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aF_I_Vp { float v1; int v2; void * v3; };
struct __attribute__((packed)) aF_Ip { float v1; int * v2; };
struct __attribute__((packed)) aF_Ip_BFu15i { float v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_Ip_BFu15ll { float v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_Ip_BFu15s { float v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_Ip_BFu16i { float v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_Ip_BFu16ll { float v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_Ip_BFu16s { float v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_Ip_BFu17i { float v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_Ip_BFu17ll { float v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_Ip_BFu1c { float v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_Ip_BFu1i { float v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_Ip_BFu1ll { float v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_Ip_BFu1s { float v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_Ip_BFu31i { float v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_Ip_BFu31ll { float v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_Ip_BFu32i { float v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_Ip_BFu32ll { float v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_Ip_BFu33 { float v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_Ip_BFu7c { float v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_Ip_BFu7i { float v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_Ip_BFu7ll { float v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_Ip_BFu7s { float v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_Ip_BFu8c { float v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_Ip_BFu8i { float v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_Ip_BFu8ll { float v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_Ip_BFu8s { float v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_Ip_BFu9i { float v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_Ip_BFu9ll { float v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_Ip_BFu9s { float v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_Ip_C { float v1; int * v2; char v3; };
struct __attribute__((packed)) aF_Ip_D { float v1; int * v2; double v3; };
struct __attribute__((packed)) aF_Ip_F { float v1; int * v2; float v3; };
struct __attribute__((packed)) aF_Ip_I { float v1; int * v2; int v3; };
struct __attribute__((packed)) aF_Ip_Ip { float v1; int * v2; int * v3; };
struct __attribute__((packed)) aF_Ip_L { float v1; int * v2; long long v3; };
struct __attribute__((packed)) aF_Ip_S { float v1; int * v2; short v3; };
struct __attribute__((packed)) aF_Ip_Uc { float v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aF_Ip_Ui { float v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aF_Ip_Ul { float v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aF_Ip_Us { float v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aF_Ip_Vp { float v1; int * v2; void * v3; };
struct __attribute__((packed)) aF_L { float v1; long long v2; };
struct __attribute__((packed)) aF_L_BFu15i { float v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_L_BFu15ll { float v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_L_BFu15s { float v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_L_BFu16i { float v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_L_BFu16ll { float v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_L_BFu16s { float v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_L_BFu17i { float v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_L_BFu17ll { float v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_L_BFu1c { float v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_L_BFu1i { float v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_L_BFu1ll { float v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_L_BFu1s { float v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_L_BFu31i { float v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_L_BFu31ll { float v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_L_BFu32i { float v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_L_BFu32ll { float v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_L_BFu33 { float v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_L_BFu7c { float v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_L_BFu7i { float v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_L_BFu7ll { float v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_L_BFu7s { float v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_L_BFu8c { float v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_L_BFu8i { float v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_L_BFu8ll { float v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_L_BFu8s { float v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_L_BFu9i { float v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_L_BFu9ll { float v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_L_BFu9s { float v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_L_C { float v1; long long v2; char v3; };
struct __attribute__((packed)) aF_L_D { float v1; long long v2; double v3; };
struct __attribute__((packed)) aF_L_F { float v1; long long v2; float v3; };
struct __attribute__((packed)) aF_L_I { float v1; long long v2; int v3; };
struct __attribute__((packed)) aF_L_Ip { float v1; long long v2; int * v3; };
struct __attribute__((packed)) aF_L_L { float v1; long long v2; long long v3; };
struct __attribute__((packed)) aF_L_S { float v1; long long v2; short v3; };
struct __attribute__((packed)) aF_L_Uc { float v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aF_L_Ui { float v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aF_L_Ul { float v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aF_L_Us { float v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aF_L_Vp { float v1; long long v2; void * v3; };
struct __attribute__((packed)) aF_S { float v1; short v2; };
struct __attribute__((packed)) aF_S_BFu15i { float v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_S_BFu15ll { float v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_S_BFu15s { float v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_S_BFu16i { float v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_S_BFu16ll { float v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_S_BFu16s { float v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_S_BFu17i { float v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_S_BFu17ll { float v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_S_BFu1c { float v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_S_BFu1i { float v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_S_BFu1ll { float v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_S_BFu1s { float v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_S_BFu31i { float v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_S_BFu31ll { float v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_S_BFu32i { float v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_S_BFu32ll { float v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_S_BFu33 { float v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_S_BFu7c { float v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_S_BFu7i { float v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_S_BFu7ll { float v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_S_BFu7s { float v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_S_BFu8c { float v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_S_BFu8i { float v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_S_BFu8ll { float v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_S_BFu8s { float v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_S_BFu9i { float v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_S_BFu9ll { float v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_S_BFu9s { float v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_S_C { float v1; short v2; char v3; };
struct __attribute__((packed)) aF_S_D { float v1; short v2; double v3; };
struct __attribute__((packed)) aF_S_F { float v1; short v2; float v3; };
struct __attribute__((packed)) aF_S_I { float v1; short v2; int v3; };
struct __attribute__((packed)) aF_S_Ip { float v1; short v2; int * v3; };
struct __attribute__((packed)) aF_S_L { float v1; short v2; long long v3; };
struct __attribute__((packed)) aF_S_S { float v1; short v2; short v3; };
struct __attribute__((packed)) aF_S_Uc { float v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aF_S_Ui { float v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aF_S_Ul { float v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aF_S_Us { float v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aF_S_Vp { float v1; short v2; void * v3; };
struct __attribute__((packed)) aF_Uc { float v1; unsigned char v2; };
struct __attribute__((packed)) aF_Uc_BFu15i { float v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_Uc_BFu15ll { float v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_Uc_BFu15s { float v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_Uc_BFu16i { float v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_Uc_BFu16ll { float v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_Uc_BFu16s { float v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_Uc_BFu17i { float v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_Uc_BFu17ll { float v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_Uc_BFu1c { float v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_Uc_BFu1i { float v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_Uc_BFu1ll { float v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_Uc_BFu1s { float v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_Uc_BFu31i { float v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_Uc_BFu31ll { float v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_Uc_BFu32i { float v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_Uc_BFu32ll { float v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_Uc_BFu33 { float v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_Uc_BFu7c { float v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_Uc_BFu7i { float v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_Uc_BFu7ll { float v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_Uc_BFu7s { float v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_Uc_BFu8c { float v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_Uc_BFu8i { float v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_Uc_BFu8ll { float v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_Uc_BFu8s { float v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_Uc_BFu9i { float v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_Uc_BFu9ll { float v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_Uc_BFu9s { float v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_Uc_C { float v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aF_Uc_D { float v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aF_Uc_F { float v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aF_Uc_I { float v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aF_Uc_Ip { float v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aF_Uc_L { float v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aF_Uc_S { float v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aF_Uc_Uc { float v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aF_Uc_Ui { float v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aF_Uc_Ul { float v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aF_Uc_Us { float v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aF_Uc_Vp { float v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aF_Ui { float v1; unsigned int v2; };
struct __attribute__((packed)) aF_Ui_BFu15i { float v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_Ui_BFu15ll { float v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_Ui_BFu15s { float v1; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_Ui_BFu16i { float v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_Ui_BFu16ll { float v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_Ui_BFu16s { float v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_Ui_BFu17i { float v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_Ui_BFu17ll { float v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_Ui_BFu1c { float v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_Ui_BFu1i { float v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_Ui_BFu1ll { float v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_Ui_BFu1s { float v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_Ui_BFu31i { float v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_Ui_BFu31ll { float v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_Ui_BFu32i { float v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_Ui_BFu32ll { float v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_Ui_BFu33 { float v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_Ui_BFu7c { float v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_Ui_BFu7i { float v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_Ui_BFu7ll { float v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_Ui_BFu7s { float v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_Ui_BFu8c { float v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_Ui_BFu8i { float v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_Ui_BFu8ll { float v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_Ui_BFu8s { float v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_Ui_BFu9i { float v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_Ui_BFu9ll { float v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_Ui_BFu9s { float v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_Ui_C { float v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aF_Ui_D { float v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aF_Ui_F { float v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aF_Ui_I { float v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aF_Ui_Ip { float v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aF_Ui_L { float v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aF_Ui_S { float v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aF_Ui_Uc { float v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aF_Ui_Ui { float v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aF_Ui_Ul { float v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aF_Ui_Us { float v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aF_Ui_Vp { float v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aF_Ul { float v1; unsigned long long v2; };
struct __attribute__((packed)) aF_Ul_BFu15i { float v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_Ul_BFu15ll { float v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_Ul_BFu15s { float v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_Ul_BFu16i { float v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_Ul_BFu16ll { float v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_Ul_BFu16s { float v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_Ul_BFu17i { float v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_Ul_BFu17ll { float v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_Ul_BFu1c { float v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_Ul_BFu1i { float v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_Ul_BFu1ll { float v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_Ul_BFu1s { float v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_Ul_BFu31i { float v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_Ul_BFu31ll { float v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_Ul_BFu32i { float v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_Ul_BFu32ll { float v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_Ul_BFu33 { float v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_Ul_BFu7c { float v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_Ul_BFu7i { float v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_Ul_BFu7ll { float v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_Ul_BFu7s { float v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_Ul_BFu8c { float v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_Ul_BFu8i { float v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_Ul_BFu8ll { float v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_Ul_BFu8s { float v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_Ul_BFu9i { float v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_Ul_BFu9ll { float v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_Ul_BFu9s { float v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_Ul_C { float v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aF_Ul_D { float v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aF_Ul_F { float v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aF_Ul_I { float v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aF_Ul_Ip { float v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aF_Ul_L { float v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aF_Ul_S { float v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aF_Ul_Uc { float v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aF_Ul_Ui { float v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aF_Ul_Ul { float v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aF_Ul_Us { float v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aF_Ul_Vp { float v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aF_Us { float v1; unsigned short v2; };
struct __attribute__((packed)) aF_Us_BFu15i { float v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_Us_BFu15ll { float v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_Us_BFu15s { float v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_Us_BFu16i { float v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_Us_BFu16ll { float v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_Us_BFu16s { float v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_Us_BFu17i { float v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_Us_BFu17ll { float v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_Us_BFu1c { float v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_Us_BFu1i { float v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_Us_BFu1ll { float v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_Us_BFu1s { float v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_Us_BFu31i { float v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_Us_BFu31ll { float v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_Us_BFu32i { float v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_Us_BFu32ll { float v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_Us_BFu33 { float v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_Us_BFu7c { float v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_Us_BFu7i { float v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_Us_BFu7ll { float v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_Us_BFu7s { float v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_Us_BFu8c { float v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_Us_BFu8i { float v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_Us_BFu8ll { float v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_Us_BFu8s { float v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_Us_BFu9i { float v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_Us_BFu9ll { float v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_Us_BFu9s { float v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_Us_C { float v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aF_Us_D { float v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aF_Us_F { float v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aF_Us_I { float v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aF_Us_Ip { float v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aF_Us_L { float v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aF_Us_S { float v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aF_Us_Uc { float v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aF_Us_Ui { float v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aF_Us_Ul { float v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aF_Us_Us { float v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aF_Us_Vp { float v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aF_Vp { float v1; void * v2; };
struct __attribute__((packed)) aF_Vp_BFu15i { float v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aF_Vp_BFu15ll { float v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aF_Vp_BFu15s { float v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aF_Vp_BFu16i { float v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aF_Vp_BFu16ll { float v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aF_Vp_BFu16s { float v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aF_Vp_BFu17i { float v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aF_Vp_BFu17ll { float v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aF_Vp_BFu1c { float v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aF_Vp_BFu1i { float v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aF_Vp_BFu1ll { float v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aF_Vp_BFu1s { float v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aF_Vp_BFu31i { float v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aF_Vp_BFu31ll { float v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aF_Vp_BFu32i { float v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aF_Vp_BFu32ll { float v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aF_Vp_BFu33 { float v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aF_Vp_BFu7c { float v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aF_Vp_BFu7i { float v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aF_Vp_BFu7ll { float v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aF_Vp_BFu7s { float v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aF_Vp_BFu8c { float v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aF_Vp_BFu8i { float v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aF_Vp_BFu8ll { float v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aF_Vp_BFu8s { float v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aF_Vp_BFu9i { float v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aF_Vp_BFu9ll { float v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aF_Vp_BFu9s { float v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aF_Vp_C { float v1; void * v2; char v3; };
struct __attribute__((packed)) aF_Vp_D { float v1; void * v2; double v3; };
struct __attribute__((packed)) aF_Vp_F { float v1; void * v2; float v3; };
struct __attribute__((packed)) aF_Vp_I { float v1; void * v2; int v3; };
struct __attribute__((packed)) aF_Vp_Ip { float v1; void * v2; int * v3; };
struct __attribute__((packed)) aF_Vp_L { float v1; void * v2; long long v3; };
struct __attribute__((packed)) aF_Vp_S { float v1; void * v2; short v3; };
struct __attribute__((packed)) aF_Vp_Uc { float v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aF_Vp_Ui { float v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aF_Vp_Ul { float v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aF_Vp_Us { float v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aF_Vp_Vp { float v1; void * v2; void * v3; };
struct __attribute__((packed)) aI { int v1; };
struct __attribute__((packed)) aI_BFu15i { int v1; unsigned int v2:15; };
struct __attribute__((packed)) aI_BFu15i_BFu15i { int v1; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu15i_BFu15ll { int v1; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu15i_BFu15s { int v1; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu15i_BFu16i { int v1; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu15i_BFu16ll { int v1; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu15i_BFu16s { int v1; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu15i_BFu17i { int v1; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu15i_BFu17ll { int v1; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu15i_BFu1c { int v1; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu15i_BFu1i { int v1; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu15i_BFu1ll { int v1; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu15i_BFu1s { int v1; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu15i_BFu31i { int v1; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu15i_BFu31ll { int v1; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu15i_BFu32i { int v1; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu15i_BFu32ll { int v1; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu15i_BFu33 { int v1; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu15i_BFu7c { int v1; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu15i_BFu7i { int v1; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu15i_BFu7ll { int v1; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu15i_BFu7s { int v1; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu15i_BFu8c { int v1; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu15i_BFu8i { int v1; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu15i_BFu8ll { int v1; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu15i_BFu8s { int v1; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu15i_BFu9i { int v1; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu15i_BFu9ll { int v1; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu15i_BFu9s { int v1; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu15i_C { int v1; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aI_BFu15i_D { int v1; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aI_BFu15i_F { int v1; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aI_BFu15i_I { int v1; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aI_BFu15i_Ip { int v1; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aI_BFu15i_L { int v1; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aI_BFu15i_S { int v1; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aI_BFu15i_Uc { int v1; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aI_BFu15i_Ui { int v1; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aI_BFu15i_Ul { int v1; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu15i_Us { int v1; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aI_BFu15i_Vp { int v1; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aI_BFu15ll { int v1; unsigned long long v2:15; };
struct __attribute__((packed)) aI_BFu15ll_BFu15i { int v1; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu15ll_BFu15ll { int v1; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu15ll_BFu15s { int v1; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu15ll_BFu16i { int v1; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu15ll_BFu16ll { int v1; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu15ll_BFu16s { int v1; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu15ll_BFu17i { int v1; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu15ll_BFu17ll { int v1; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu15ll_BFu1c { int v1; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu15ll_BFu1i { int v1; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu15ll_BFu1ll { int v1; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu15ll_BFu1s { int v1; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu15ll_BFu31i { int v1; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu15ll_BFu31ll { int v1; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu15ll_BFu32i { int v1; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu15ll_BFu32ll { int v1; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu15ll_BFu33 { int v1; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu15ll_BFu7c { int v1; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu15ll_BFu7i { int v1; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu15ll_BFu7ll { int v1; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu15ll_BFu7s { int v1; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu15ll_BFu8c { int v1; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu15ll_BFu8i { int v1; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu15ll_BFu8ll { int v1; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu15ll_BFu8s { int v1; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu15ll_BFu9i { int v1; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu15ll_BFu9ll { int v1; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu15ll_BFu9s { int v1; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu15ll_C { int v1; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aI_BFu15ll_D { int v1; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aI_BFu15ll_F { int v1; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aI_BFu15ll_I { int v1; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aI_BFu15ll_Ip { int v1; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aI_BFu15ll_L { int v1; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aI_BFu15ll_S { int v1; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aI_BFu15ll_Uc { int v1; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aI_BFu15ll_Ui { int v1; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aI_BFu15ll_Ul { int v1; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu15ll_Us { int v1; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aI_BFu15ll_Vp { int v1; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aI_BFu15s { int v1; unsigned short v2:15; };
struct __attribute__((packed)) aI_BFu15s_BFu15i { int v1; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu15s_BFu15ll { int v1; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu15s_BFu15s { int v1; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu15s_BFu16i { int v1; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu15s_BFu16ll { int v1; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu15s_BFu16s { int v1; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu15s_BFu17i { int v1; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu15s_BFu17ll { int v1; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu15s_BFu1c { int v1; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu15s_BFu1i { int v1; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu15s_BFu1ll { int v1; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu15s_BFu1s { int v1; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu15s_BFu31i { int v1; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu15s_BFu31ll { int v1; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu15s_BFu32i { int v1; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu15s_BFu32ll { int v1; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu15s_BFu33 { int v1; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu15s_BFu7c { int v1; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu15s_BFu7i { int v1; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu15s_BFu7ll { int v1; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu15s_BFu7s { int v1; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu15s_BFu8c { int v1; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu15s_BFu8i { int v1; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu15s_BFu8ll { int v1; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu15s_BFu8s { int v1; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu15s_BFu9i { int v1; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu15s_BFu9ll { int v1; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu15s_BFu9s { int v1; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu15s_C { int v1; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aI_BFu15s_D { int v1; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aI_BFu15s_F { int v1; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aI_BFu15s_I { int v1; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aI_BFu15s_Ip { int v1; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aI_BFu15s_L { int v1; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aI_BFu15s_S { int v1; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aI_BFu15s_Uc { int v1; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aI_BFu15s_Ui { int v1; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aI_BFu15s_Ul { int v1; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu15s_Us { int v1; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aI_BFu15s_Vp { int v1; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aI_BFu16i { int v1; unsigned int v2:16; };
struct __attribute__((packed)) aI_BFu16i_BFu15i { int v1; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu16i_BFu15ll { int v1; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu16i_BFu15s { int v1; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu16i_BFu16i { int v1; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu16i_BFu16ll { int v1; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu16i_BFu16s { int v1; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu16i_BFu17i { int v1; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu16i_BFu17ll { int v1; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu16i_BFu1c { int v1; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu16i_BFu1i { int v1; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu16i_BFu1ll { int v1; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu16i_BFu1s { int v1; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu16i_BFu31i { int v1; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu16i_BFu31ll { int v1; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu16i_BFu32i { int v1; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu16i_BFu32ll { int v1; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu16i_BFu33 { int v1; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu16i_BFu7c { int v1; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu16i_BFu7i { int v1; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu16i_BFu7ll { int v1; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu16i_BFu7s { int v1; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu16i_BFu8c { int v1; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu16i_BFu8i { int v1; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu16i_BFu8ll { int v1; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu16i_BFu8s { int v1; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu16i_BFu9i { int v1; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu16i_BFu9ll { int v1; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu16i_BFu9s { int v1; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu16i_C { int v1; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aI_BFu16i_D { int v1; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aI_BFu16i_F { int v1; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aI_BFu16i_I { int v1; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aI_BFu16i_Ip { int v1; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aI_BFu16i_L { int v1; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aI_BFu16i_S { int v1; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aI_BFu16i_Uc { int v1; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aI_BFu16i_Ui { int v1; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aI_BFu16i_Ul { int v1; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu16i_Us { int v1; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aI_BFu16i_Vp { int v1; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aI_BFu16ll { int v1; unsigned long long v2:16; };
struct __attribute__((packed)) aI_BFu16ll_BFu15i { int v1; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu16ll_BFu15ll { int v1; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu16ll_BFu15s { int v1; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu16ll_BFu16i { int v1; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu16ll_BFu16ll { int v1; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu16ll_BFu16s { int v1; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu16ll_BFu17i { int v1; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu16ll_BFu17ll { int v1; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu16ll_BFu1c { int v1; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu16ll_BFu1i { int v1; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu16ll_BFu1ll { int v1; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu16ll_BFu1s { int v1; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu16ll_BFu31i { int v1; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu16ll_BFu31ll { int v1; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu16ll_BFu32i { int v1; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu16ll_BFu32ll { int v1; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu16ll_BFu33 { int v1; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu16ll_BFu7c { int v1; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu16ll_BFu7i { int v1; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu16ll_BFu7ll { int v1; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu16ll_BFu7s { int v1; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu16ll_BFu8c { int v1; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu16ll_BFu8i { int v1; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu16ll_BFu8ll { int v1; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu16ll_BFu8s { int v1; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu16ll_BFu9i { int v1; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu16ll_BFu9ll { int v1; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu16ll_BFu9s { int v1; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu16ll_C { int v1; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aI_BFu16ll_D { int v1; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aI_BFu16ll_F { int v1; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aI_BFu16ll_I { int v1; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aI_BFu16ll_Ip { int v1; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aI_BFu16ll_L { int v1; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aI_BFu16ll_S { int v1; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aI_BFu16ll_Uc { int v1; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aI_BFu16ll_Ui { int v1; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aI_BFu16ll_Ul { int v1; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu16ll_Us { int v1; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aI_BFu16ll_Vp { int v1; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aI_BFu16s { int v1; unsigned short v2:16; };
struct __attribute__((packed)) aI_BFu16s_BFu15i { int v1; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu16s_BFu15ll { int v1; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu16s_BFu15s { int v1; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu16s_BFu16i { int v1; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu16s_BFu16ll { int v1; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu16s_BFu16s { int v1; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu16s_BFu17i { int v1; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu16s_BFu17ll { int v1; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu16s_BFu1c { int v1; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu16s_BFu1i { int v1; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu16s_BFu1ll { int v1; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu16s_BFu1s { int v1; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu16s_BFu31i { int v1; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu16s_BFu31ll { int v1; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu16s_BFu32i { int v1; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu16s_BFu32ll { int v1; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu16s_BFu33 { int v1; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu16s_BFu7c { int v1; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu16s_BFu7i { int v1; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu16s_BFu7ll { int v1; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu16s_BFu7s { int v1; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu16s_BFu8c { int v1; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu16s_BFu8i { int v1; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu16s_BFu8ll { int v1; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu16s_BFu8s { int v1; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu16s_BFu9i { int v1; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu16s_BFu9ll { int v1; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu16s_BFu9s { int v1; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu16s_C { int v1; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aI_BFu16s_D { int v1; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aI_BFu16s_F { int v1; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aI_BFu16s_I { int v1; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aI_BFu16s_Ip { int v1; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aI_BFu16s_L { int v1; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aI_BFu16s_S { int v1; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aI_BFu16s_Uc { int v1; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aI_BFu16s_Ui { int v1; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aI_BFu16s_Ul { int v1; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu16s_Us { int v1; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aI_BFu16s_Vp { int v1; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aI_BFu17i { int v1; unsigned int v2:17; };
struct __attribute__((packed)) aI_BFu17i_BFu15i { int v1; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu17i_BFu15ll { int v1; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu17i_BFu15s { int v1; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu17i_BFu16i { int v1; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu17i_BFu16ll { int v1; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu17i_BFu16s { int v1; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu17i_BFu17i { int v1; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu17i_BFu17ll { int v1; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu17i_BFu1c { int v1; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu17i_BFu1i { int v1; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu17i_BFu1ll { int v1; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu17i_BFu1s { int v1; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu17i_BFu31i { int v1; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu17i_BFu31ll { int v1; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu17i_BFu32i { int v1; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu17i_BFu32ll { int v1; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu17i_BFu33 { int v1; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu17i_BFu7c { int v1; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu17i_BFu7i { int v1; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu17i_BFu7ll { int v1; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu17i_BFu7s { int v1; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu17i_BFu8c { int v1; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu17i_BFu8i { int v1; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu17i_BFu8ll { int v1; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu17i_BFu8s { int v1; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu17i_BFu9i { int v1; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu17i_BFu9ll { int v1; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu17i_BFu9s { int v1; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu17i_C { int v1; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aI_BFu17i_D { int v1; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aI_BFu17i_F { int v1; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aI_BFu17i_I { int v1; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aI_BFu17i_Ip { int v1; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aI_BFu17i_L { int v1; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aI_BFu17i_S { int v1; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aI_BFu17i_Uc { int v1; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aI_BFu17i_Ui { int v1; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aI_BFu17i_Ul { int v1; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu17i_Us { int v1; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aI_BFu17i_Vp { int v1; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aI_BFu17ll { int v1; unsigned long long v2:17; };
struct __attribute__((packed)) aI_BFu17ll_BFu15i { int v1; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu17ll_BFu15ll { int v1; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu17ll_BFu15s { int v1; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu17ll_BFu16i { int v1; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu17ll_BFu16ll { int v1; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu17ll_BFu16s { int v1; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu17ll_BFu17i { int v1; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu17ll_BFu17ll { int v1; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu17ll_BFu1c { int v1; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu17ll_BFu1i { int v1; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu17ll_BFu1ll { int v1; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu17ll_BFu1s { int v1; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu17ll_BFu31i { int v1; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu17ll_BFu31ll { int v1; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu17ll_BFu32i { int v1; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu17ll_BFu32ll { int v1; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu17ll_BFu33 { int v1; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu17ll_BFu7c { int v1; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu17ll_BFu7i { int v1; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu17ll_BFu7ll { int v1; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu17ll_BFu7s { int v1; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu17ll_BFu8c { int v1; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu17ll_BFu8i { int v1; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu17ll_BFu8ll { int v1; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu17ll_BFu8s { int v1; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu17ll_BFu9i { int v1; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu17ll_BFu9ll { int v1; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu17ll_BFu9s { int v1; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu17ll_C { int v1; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aI_BFu17ll_D { int v1; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aI_BFu17ll_F { int v1; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aI_BFu17ll_I { int v1; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aI_BFu17ll_Ip { int v1; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aI_BFu17ll_L { int v1; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aI_BFu17ll_S { int v1; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aI_BFu17ll_Uc { int v1; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aI_BFu17ll_Ui { int v1; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aI_BFu17ll_Ul { int v1; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu17ll_Us { int v1; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aI_BFu17ll_Vp { int v1; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aI_BFu1c { int v1; unsigned char v2:1; };
struct __attribute__((packed)) aI_BFu1c_BFu15i { int v1; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu1c_BFu15ll { int v1; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu1c_BFu15s { int v1; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu1c_BFu16i { int v1; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu1c_BFu16ll { int v1; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu1c_BFu16s { int v1; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu1c_BFu17i { int v1; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu1c_BFu17ll { int v1; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu1c_BFu1c { int v1; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu1c_BFu1i { int v1; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu1c_BFu1ll { int v1; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu1c_BFu1s { int v1; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu1c_BFu31i { int v1; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu1c_BFu31ll { int v1; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu1c_BFu32i { int v1; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu1c_BFu32ll { int v1; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu1c_BFu33 { int v1; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu1c_BFu7c { int v1; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu1c_BFu7i { int v1; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu1c_BFu7ll { int v1; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu1c_BFu7s { int v1; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu1c_BFu8c { int v1; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu1c_BFu8i { int v1; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu1c_BFu8ll { int v1; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu1c_BFu8s { int v1; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu1c_BFu9i { int v1; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu1c_BFu9ll { int v1; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu1c_BFu9s { int v1; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu1c_C { int v1; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aI_BFu1c_D { int v1; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aI_BFu1c_F { int v1; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aI_BFu1c_I { int v1; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aI_BFu1c_Ip { int v1; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aI_BFu1c_L { int v1; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aI_BFu1c_S { int v1; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aI_BFu1c_Uc { int v1; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aI_BFu1c_Ui { int v1; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aI_BFu1c_Ul { int v1; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu1c_Us { int v1; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aI_BFu1c_Vp { int v1; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aI_BFu1i { int v1; unsigned int v2:1; };
struct __attribute__((packed)) aI_BFu1i_BFu15i { int v1; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu1i_BFu15ll { int v1; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu1i_BFu15s { int v1; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu1i_BFu16i { int v1; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu1i_BFu16ll { int v1; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu1i_BFu16s { int v1; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu1i_BFu17i { int v1; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu1i_BFu17ll { int v1; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu1i_BFu1c { int v1; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu1i_BFu1i { int v1; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu1i_BFu1ll { int v1; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu1i_BFu1s { int v1; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu1i_BFu31i { int v1; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu1i_BFu31ll { int v1; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu1i_BFu32i { int v1; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu1i_BFu32ll { int v1; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu1i_BFu33 { int v1; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu1i_BFu7c { int v1; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu1i_BFu7i { int v1; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu1i_BFu7ll { int v1; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu1i_BFu7s { int v1; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu1i_BFu8c { int v1; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu1i_BFu8i { int v1; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu1i_BFu8ll { int v1; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu1i_BFu8s { int v1; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu1i_BFu9i { int v1; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu1i_BFu9ll { int v1; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu1i_BFu9s { int v1; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu1i_C { int v1; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aI_BFu1i_D { int v1; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aI_BFu1i_F { int v1; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aI_BFu1i_I { int v1; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aI_BFu1i_Ip { int v1; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aI_BFu1i_L { int v1; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aI_BFu1i_S { int v1; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aI_BFu1i_Uc { int v1; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aI_BFu1i_Ui { int v1; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aI_BFu1i_Ul { int v1; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu1i_Us { int v1; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aI_BFu1i_Vp { int v1; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aI_BFu1ll { int v1; unsigned long long v2:1; };
struct __attribute__((packed)) aI_BFu1ll_BFu15i { int v1; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu1ll_BFu15ll { int v1; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu1ll_BFu15s { int v1; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu1ll_BFu16i { int v1; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu1ll_BFu16ll { int v1; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu1ll_BFu16s { int v1; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu1ll_BFu17i { int v1; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu1ll_BFu17ll { int v1; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu1ll_BFu1c { int v1; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu1ll_BFu1i { int v1; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu1ll_BFu1ll { int v1; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu1ll_BFu1s { int v1; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu1ll_BFu31i { int v1; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu1ll_BFu31ll { int v1; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu1ll_BFu32i { int v1; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu1ll_BFu32ll { int v1; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu1ll_BFu33 { int v1; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu1ll_BFu7c { int v1; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu1ll_BFu7i { int v1; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu1ll_BFu7ll { int v1; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu1ll_BFu7s { int v1; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu1ll_BFu8c { int v1; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu1ll_BFu8i { int v1; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu1ll_BFu8ll { int v1; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu1ll_BFu8s { int v1; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu1ll_BFu9i { int v1; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu1ll_BFu9ll { int v1; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu1ll_BFu9s { int v1; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu1ll_C { int v1; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aI_BFu1ll_D { int v1; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aI_BFu1ll_F { int v1; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aI_BFu1ll_I { int v1; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aI_BFu1ll_Ip { int v1; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aI_BFu1ll_L { int v1; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aI_BFu1ll_S { int v1; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aI_BFu1ll_Uc { int v1; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aI_BFu1ll_Ui { int v1; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aI_BFu1ll_Ul { int v1; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu1ll_Us { int v1; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aI_BFu1ll_Vp { int v1; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aI_BFu1s { int v1; unsigned short v2:1; };
struct __attribute__((packed)) aI_BFu1s_BFu15i { int v1; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu1s_BFu15ll { int v1; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu1s_BFu15s { int v1; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu1s_BFu16i { int v1; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu1s_BFu16ll { int v1; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu1s_BFu16s { int v1; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu1s_BFu17i { int v1; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu1s_BFu17ll { int v1; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu1s_BFu1c { int v1; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu1s_BFu1i { int v1; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu1s_BFu1ll { int v1; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu1s_BFu1s { int v1; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu1s_BFu31i { int v1; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu1s_BFu31ll { int v1; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu1s_BFu32i { int v1; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu1s_BFu32ll { int v1; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu1s_BFu33 { int v1; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu1s_BFu7c { int v1; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu1s_BFu7i { int v1; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu1s_BFu7ll { int v1; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu1s_BFu7s { int v1; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu1s_BFu8c { int v1; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu1s_BFu8i { int v1; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu1s_BFu8ll { int v1; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu1s_BFu8s { int v1; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu1s_BFu9i { int v1; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu1s_BFu9ll { int v1; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu1s_BFu9s { int v1; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu1s_C { int v1; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aI_BFu1s_D { int v1; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aI_BFu1s_F { int v1; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aI_BFu1s_I { int v1; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aI_BFu1s_Ip { int v1; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aI_BFu1s_L { int v1; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aI_BFu1s_S { int v1; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aI_BFu1s_Uc { int v1; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aI_BFu1s_Ui { int v1; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aI_BFu1s_Ul { int v1; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu1s_Us { int v1; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aI_BFu1s_Vp { int v1; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aI_BFu31i { int v1; unsigned int v2:31; };
struct __attribute__((packed)) aI_BFu31i_BFu15i { int v1; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu31i_BFu15ll { int v1; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu31i_BFu15s { int v1; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu31i_BFu16i { int v1; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu31i_BFu16ll { int v1; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu31i_BFu16s { int v1; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu31i_BFu17i { int v1; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu31i_BFu17ll { int v1; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu31i_BFu1c { int v1; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu31i_BFu1i { int v1; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu31i_BFu1ll { int v1; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu31i_BFu1s { int v1; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu31i_BFu31i { int v1; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu31i_BFu31ll { int v1; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu31i_BFu32i { int v1; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu31i_BFu32ll { int v1; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu31i_BFu33 { int v1; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu31i_BFu7c { int v1; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu31i_BFu7i { int v1; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu31i_BFu7ll { int v1; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu31i_BFu7s { int v1; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu31i_BFu8c { int v1; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu31i_BFu8i { int v1; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu31i_BFu8ll { int v1; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu31i_BFu8s { int v1; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu31i_BFu9i { int v1; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu31i_BFu9ll { int v1; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu31i_BFu9s { int v1; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu31i_C { int v1; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aI_BFu31i_D { int v1; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aI_BFu31i_F { int v1; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aI_BFu31i_I { int v1; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aI_BFu31i_Ip { int v1; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aI_BFu31i_L { int v1; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aI_BFu31i_S { int v1; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aI_BFu31i_Uc { int v1; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aI_BFu31i_Ui { int v1; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aI_BFu31i_Ul { int v1; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu31i_Us { int v1; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aI_BFu31i_Vp { int v1; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aI_BFu31ll { int v1; unsigned long long v2:31; };
struct __attribute__((packed)) aI_BFu31ll_BFu15i { int v1; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu31ll_BFu15ll { int v1; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu31ll_BFu15s { int v1; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu31ll_BFu16i { int v1; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu31ll_BFu16ll { int v1; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu31ll_BFu16s { int v1; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu31ll_BFu17i { int v1; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu31ll_BFu17ll { int v1; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu31ll_BFu1c { int v1; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu31ll_BFu1i { int v1; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu31ll_BFu1ll { int v1; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu31ll_BFu1s { int v1; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu31ll_BFu31i { int v1; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu31ll_BFu31ll { int v1; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu31ll_BFu32i { int v1; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu31ll_BFu32ll { int v1; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu31ll_BFu33 { int v1; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu31ll_BFu7c { int v1; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu31ll_BFu7i { int v1; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu31ll_BFu7ll { int v1; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu31ll_BFu7s { int v1; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu31ll_BFu8c { int v1; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu31ll_BFu8i { int v1; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu31ll_BFu8ll { int v1; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu31ll_BFu8s { int v1; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu31ll_BFu9i { int v1; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu31ll_BFu9ll { int v1; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu31ll_BFu9s { int v1; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu31ll_C { int v1; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aI_BFu31ll_D { int v1; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aI_BFu31ll_F { int v1; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aI_BFu31ll_I { int v1; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aI_BFu31ll_Ip { int v1; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aI_BFu31ll_L { int v1; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aI_BFu31ll_S { int v1; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aI_BFu31ll_Uc { int v1; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aI_BFu31ll_Ui { int v1; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aI_BFu31ll_Ul { int v1; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu31ll_Us { int v1; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aI_BFu31ll_Vp { int v1; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aI_BFu32i { int v1; unsigned int v2:32; };
struct __attribute__((packed)) aI_BFu32i_BFu15i { int v1; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu32i_BFu15ll { int v1; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu32i_BFu15s { int v1; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu32i_BFu16i { int v1; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu32i_BFu16ll { int v1; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu32i_BFu16s { int v1; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu32i_BFu17i { int v1; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu32i_BFu17ll { int v1; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu32i_BFu1c { int v1; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu32i_BFu1i { int v1; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu32i_BFu1ll { int v1; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu32i_BFu1s { int v1; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu32i_BFu31i { int v1; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu32i_BFu31ll { int v1; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu32i_BFu32i { int v1; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu32i_BFu32ll { int v1; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu32i_BFu33 { int v1; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu32i_BFu7c { int v1; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu32i_BFu7i { int v1; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu32i_BFu7ll { int v1; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu32i_BFu7s { int v1; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu32i_BFu8c { int v1; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu32i_BFu8i { int v1; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu32i_BFu8ll { int v1; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu32i_BFu8s { int v1; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu32i_BFu9i { int v1; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu32i_BFu9ll { int v1; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu32i_BFu9s { int v1; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu32i_C { int v1; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aI_BFu32i_D { int v1; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aI_BFu32i_F { int v1; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aI_BFu32i_I { int v1; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aI_BFu32i_Ip { int v1; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aI_BFu32i_L { int v1; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aI_BFu32i_S { int v1; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aI_BFu32i_Uc { int v1; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aI_BFu32i_Ui { int v1; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aI_BFu32i_Ul { int v1; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu32i_Us { int v1; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aI_BFu32i_Vp { int v1; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aI_BFu32ll { int v1; unsigned long long v2:32; };
struct __attribute__((packed)) aI_BFu32ll_BFu15i { int v1; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu32ll_BFu15ll { int v1; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu32ll_BFu15s { int v1; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu32ll_BFu16i { int v1; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu32ll_BFu16ll { int v1; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu32ll_BFu16s { int v1; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu32ll_BFu17i { int v1; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu32ll_BFu17ll { int v1; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu32ll_BFu1c { int v1; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu32ll_BFu1i { int v1; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu32ll_BFu1ll { int v1; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu32ll_BFu1s { int v1; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu32ll_BFu31i { int v1; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu32ll_BFu31ll { int v1; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu32ll_BFu32i { int v1; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu32ll_BFu32ll { int v1; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu32ll_BFu33 { int v1; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu32ll_BFu7c { int v1; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu32ll_BFu7i { int v1; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu32ll_BFu7ll { int v1; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu32ll_BFu7s { int v1; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu32ll_BFu8c { int v1; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu32ll_BFu8i { int v1; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu32ll_BFu8ll { int v1; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu32ll_BFu8s { int v1; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu32ll_BFu9i { int v1; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu32ll_BFu9ll { int v1; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu32ll_BFu9s { int v1; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu32ll_C { int v1; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aI_BFu32ll_D { int v1; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aI_BFu32ll_F { int v1; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aI_BFu32ll_I { int v1; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aI_BFu32ll_Ip { int v1; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aI_BFu32ll_L { int v1; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aI_BFu32ll_S { int v1; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aI_BFu32ll_Uc { int v1; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aI_BFu32ll_Ui { int v1; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aI_BFu32ll_Ul { int v1; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu32ll_Us { int v1; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aI_BFu32ll_Vp { int v1; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aI_BFu33 { int v1; unsigned long long v2:33; };
struct __attribute__((packed)) aI_BFu33_BFu15i { int v1; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu33_BFu15ll { int v1; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu33_BFu15s { int v1; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu33_BFu16i { int v1; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu33_BFu16ll { int v1; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu33_BFu16s { int v1; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu33_BFu17i { int v1; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu33_BFu17ll { int v1; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu33_BFu1c { int v1; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu33_BFu1i { int v1; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu33_BFu1ll { int v1; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu33_BFu1s { int v1; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu33_BFu31i { int v1; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu33_BFu31ll { int v1; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu33_BFu32i { int v1; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu33_BFu32ll { int v1; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu33_BFu33 { int v1; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu33_BFu7c { int v1; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu33_BFu7i { int v1; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu33_BFu7ll { int v1; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu33_BFu7s { int v1; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu33_BFu8c { int v1; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu33_BFu8i { int v1; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu33_BFu8ll { int v1; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu33_BFu8s { int v1; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu33_BFu9i { int v1; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu33_BFu9ll { int v1; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu33_BFu9s { int v1; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu33_C { int v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aI_BFu33_D { int v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aI_BFu33_F { int v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aI_BFu33_I { int v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aI_BFu33_Ip { int v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aI_BFu33_L { int v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aI_BFu33_S { int v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aI_BFu33_Uc { int v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aI_BFu33_Ui { int v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aI_BFu33_Ul { int v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu33_Us { int v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aI_BFu33_Vp { int v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aI_BFu7c { int v1; unsigned char v2:7; };
struct __attribute__((packed)) aI_BFu7c_BFu15i { int v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu7c_BFu15ll { int v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu7c_BFu15s { int v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu7c_BFu16i { int v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu7c_BFu16ll { int v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu7c_BFu16s { int v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu7c_BFu17i { int v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu7c_BFu17ll { int v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu7c_BFu1c { int v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu7c_BFu1i { int v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu7c_BFu1ll { int v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu7c_BFu1s { int v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu7c_BFu31i { int v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu7c_BFu31ll { int v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu7c_BFu32i { int v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu7c_BFu32ll { int v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu7c_BFu33 { int v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu7c_BFu7c { int v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu7c_BFu7i { int v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu7c_BFu7ll { int v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu7c_BFu7s { int v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu7c_BFu8c { int v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu7c_BFu8i { int v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu7c_BFu8ll { int v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu7c_BFu8s { int v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu7c_BFu9i { int v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu7c_BFu9ll { int v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu7c_BFu9s { int v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu7c_C { int v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aI_BFu7c_D { int v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aI_BFu7c_F { int v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aI_BFu7c_I { int v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aI_BFu7c_Ip { int v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aI_BFu7c_L { int v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aI_BFu7c_S { int v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aI_BFu7c_Uc { int v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aI_BFu7c_Ui { int v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aI_BFu7c_Ul { int v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu7c_Us { int v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aI_BFu7c_Vp { int v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aI_BFu7i { int v1; unsigned int v2:7; };
struct __attribute__((packed)) aI_BFu7i_BFu15i { int v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu7i_BFu15ll { int v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu7i_BFu15s { int v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu7i_BFu16i { int v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu7i_BFu16ll { int v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu7i_BFu16s { int v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu7i_BFu17i { int v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu7i_BFu17ll { int v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu7i_BFu1c { int v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu7i_BFu1i { int v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu7i_BFu1ll { int v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu7i_BFu1s { int v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu7i_BFu31i { int v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu7i_BFu31ll { int v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu7i_BFu32i { int v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu7i_BFu32ll { int v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu7i_BFu33 { int v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu7i_BFu7c { int v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu7i_BFu7i { int v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu7i_BFu7ll { int v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu7i_BFu7s { int v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu7i_BFu8c { int v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu7i_BFu8i { int v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu7i_BFu8ll { int v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu7i_BFu8s { int v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu7i_BFu9i { int v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu7i_BFu9ll { int v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu7i_BFu9s { int v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu7i_C { int v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aI_BFu7i_D { int v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aI_BFu7i_F { int v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aI_BFu7i_I { int v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aI_BFu7i_Ip { int v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aI_BFu7i_L { int v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aI_BFu7i_S { int v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aI_BFu7i_Uc { int v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aI_BFu7i_Ui { int v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aI_BFu7i_Ul { int v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu7i_Us { int v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aI_BFu7i_Vp { int v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aI_BFu7ll { int v1; unsigned long long v2:7; };
struct __attribute__((packed)) aI_BFu7ll_BFu15i { int v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu7ll_BFu15ll { int v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu7ll_BFu15s { int v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu7ll_BFu16i { int v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu7ll_BFu16ll { int v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu7ll_BFu16s { int v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu7ll_BFu17i { int v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu7ll_BFu17ll { int v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu7ll_BFu1c { int v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu7ll_BFu1i { int v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu7ll_BFu1ll { int v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu7ll_BFu1s { int v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu7ll_BFu31i { int v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu7ll_BFu31ll { int v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu7ll_BFu32i { int v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu7ll_BFu32ll { int v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu7ll_BFu33 { int v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu7ll_BFu7c { int v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu7ll_BFu7i { int v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu7ll_BFu7ll { int v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu7ll_BFu7s { int v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu7ll_BFu8c { int v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu7ll_BFu8i { int v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu7ll_BFu8ll { int v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu7ll_BFu8s { int v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu7ll_BFu9i { int v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu7ll_BFu9ll { int v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu7ll_BFu9s { int v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu7ll_C { int v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aI_BFu7ll_D { int v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aI_BFu7ll_F { int v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aI_BFu7ll_I { int v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aI_BFu7ll_Ip { int v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aI_BFu7ll_L { int v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aI_BFu7ll_S { int v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aI_BFu7ll_Uc { int v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aI_BFu7ll_Ui { int v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aI_BFu7ll_Ul { int v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu7ll_Us { int v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aI_BFu7ll_Vp { int v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aI_BFu7s { int v1; unsigned short v2:7; };
struct __attribute__((packed)) aI_BFu7s_BFu15i { int v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu7s_BFu15ll { int v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu7s_BFu15s { int v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu7s_BFu16i { int v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu7s_BFu16ll { int v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu7s_BFu16s { int v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu7s_BFu17i { int v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu7s_BFu17ll { int v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu7s_BFu1c { int v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu7s_BFu1i { int v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu7s_BFu1ll { int v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu7s_BFu1s { int v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu7s_BFu31i { int v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu7s_BFu31ll { int v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu7s_BFu32i { int v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu7s_BFu32ll { int v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu7s_BFu33 { int v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu7s_BFu7c { int v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu7s_BFu7i { int v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu7s_BFu7ll { int v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu7s_BFu7s { int v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu7s_BFu8c { int v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu7s_BFu8i { int v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu7s_BFu8ll { int v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu7s_BFu8s { int v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu7s_BFu9i { int v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu7s_BFu9ll { int v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu7s_BFu9s { int v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu7s_C { int v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aI_BFu7s_D { int v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aI_BFu7s_F { int v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aI_BFu7s_I { int v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aI_BFu7s_Ip { int v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aI_BFu7s_L { int v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aI_BFu7s_S { int v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aI_BFu7s_Uc { int v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aI_BFu7s_Ui { int v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aI_BFu7s_Ul { int v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu7s_Us { int v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aI_BFu7s_Vp { int v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aI_BFu8c { int v1; unsigned char v2:8; };
struct __attribute__((packed)) aI_BFu8c_BFu15i { int v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu8c_BFu15ll { int v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu8c_BFu15s { int v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu8c_BFu16i { int v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu8c_BFu16ll { int v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu8c_BFu16s { int v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu8c_BFu17i { int v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu8c_BFu17ll { int v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu8c_BFu1c { int v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu8c_BFu1i { int v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu8c_BFu1ll { int v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu8c_BFu1s { int v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu8c_BFu31i { int v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu8c_BFu31ll { int v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu8c_BFu32i { int v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu8c_BFu32ll { int v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu8c_BFu33 { int v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu8c_BFu7c { int v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu8c_BFu7i { int v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu8c_BFu7ll { int v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu8c_BFu7s { int v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu8c_BFu8c { int v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu8c_BFu8i { int v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu8c_BFu8ll { int v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu8c_BFu8s { int v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu8c_BFu9i { int v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu8c_BFu9ll { int v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu8c_BFu9s { int v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu8c_C { int v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aI_BFu8c_D { int v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aI_BFu8c_F { int v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aI_BFu8c_I { int v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aI_BFu8c_Ip { int v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aI_BFu8c_L { int v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aI_BFu8c_S { int v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aI_BFu8c_Uc { int v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aI_BFu8c_Ui { int v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aI_BFu8c_Ul { int v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu8c_Us { int v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aI_BFu8c_Vp { int v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aI_BFu8i { int v1; unsigned int v2:8; };
struct __attribute__((packed)) aI_BFu8i_BFu15i { int v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu8i_BFu15ll { int v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu8i_BFu15s { int v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu8i_BFu16i { int v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu8i_BFu16ll { int v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu8i_BFu16s { int v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu8i_BFu17i { int v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu8i_BFu17ll { int v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu8i_BFu1c { int v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu8i_BFu1i { int v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu8i_BFu1ll { int v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu8i_BFu1s { int v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu8i_BFu31i { int v1; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu8i_BFu31ll { int v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu8i_BFu32i { int v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu8i_BFu32ll { int v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu8i_BFu33 { int v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu8i_BFu7c { int v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu8i_BFu7i { int v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu8i_BFu7ll { int v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu8i_BFu7s { int v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu8i_BFu8c { int v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu8i_BFu8i { int v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu8i_BFu8ll { int v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu8i_BFu8s { int v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu8i_BFu9i { int v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu8i_BFu9ll { int v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu8i_BFu9s { int v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu8i_C { int v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aI_BFu8i_D { int v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aI_BFu8i_F { int v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aI_BFu8i_I { int v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aI_BFu8i_Ip { int v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aI_BFu8i_L { int v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aI_BFu8i_S { int v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aI_BFu8i_Uc { int v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aI_BFu8i_Ui { int v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aI_BFu8i_Ul { int v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu8i_Us { int v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aI_BFu8i_Vp { int v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aI_BFu8ll { int v1; unsigned long long v2:8; };
struct __attribute__((packed)) aI_BFu8ll_BFu15i { int v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu8ll_BFu15ll { int v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu8ll_BFu15s { int v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu8ll_BFu16i { int v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu8ll_BFu16ll { int v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu8ll_BFu16s { int v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu8ll_BFu17i { int v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu8ll_BFu17ll { int v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu8ll_BFu1c { int v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu8ll_BFu1i { int v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu8ll_BFu1ll { int v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu8ll_BFu1s { int v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu8ll_BFu31i { int v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu8ll_BFu31ll { int v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu8ll_BFu32i { int v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu8ll_BFu32ll { int v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu8ll_BFu33 { int v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu8ll_BFu7c { int v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu8ll_BFu7i { int v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu8ll_BFu7ll { int v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu8ll_BFu7s { int v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu8ll_BFu8c { int v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu8ll_BFu8i { int v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu8ll_BFu8ll { int v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu8ll_BFu8s { int v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu8ll_BFu9i { int v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu8ll_BFu9ll { int v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu8ll_BFu9s { int v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu8ll_C { int v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aI_BFu8ll_D { int v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aI_BFu8ll_F { int v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aI_BFu8ll_I { int v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aI_BFu8ll_Ip { int v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aI_BFu8ll_L { int v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aI_BFu8ll_S { int v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aI_BFu8ll_Uc { int v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aI_BFu8ll_Ui { int v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aI_BFu8ll_Ul { int v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu8ll_Us { int v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aI_BFu8ll_Vp { int v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aI_BFu8s { int v1; unsigned short v2:8; };
struct __attribute__((packed)) aI_BFu8s_BFu15i { int v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu8s_BFu15ll { int v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu8s_BFu15s { int v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu8s_BFu16i { int v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu8s_BFu16ll { int v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu8s_BFu16s { int v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu8s_BFu17i { int v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu8s_BFu17ll { int v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu8s_BFu1c { int v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu8s_BFu1i { int v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu8s_BFu1ll { int v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu8s_BFu1s { int v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu8s_BFu31i { int v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu8s_BFu31ll { int v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu8s_BFu32i { int v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu8s_BFu32ll { int v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu8s_BFu33 { int v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu8s_BFu7c { int v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu8s_BFu7i { int v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu8s_BFu7ll { int v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu8s_BFu7s { int v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu8s_BFu8c { int v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu8s_BFu8i { int v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu8s_BFu8ll { int v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu8s_BFu8s { int v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu8s_BFu9i { int v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu8s_BFu9ll { int v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu8s_BFu9s { int v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu8s_C { int v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aI_BFu8s_D { int v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aI_BFu8s_F { int v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aI_BFu8s_I { int v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aI_BFu8s_Ip { int v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aI_BFu8s_L { int v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aI_BFu8s_S { int v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aI_BFu8s_Uc { int v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aI_BFu8s_Ui { int v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aI_BFu8s_Ul { int v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu8s_Us { int v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aI_BFu8s_Vp { int v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aI_BFu9i { int v1; unsigned int v2:9; };
struct __attribute__((packed)) aI_BFu9i_BFu15i { int v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu9i_BFu15ll { int v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu9i_BFu15s { int v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu9i_BFu16i { int v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu9i_BFu16ll { int v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu9i_BFu16s { int v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu9i_BFu17i { int v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu9i_BFu17ll { int v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu9i_BFu1c { int v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu9i_BFu1i { int v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu9i_BFu1ll { int v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu9i_BFu1s { int v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu9i_BFu31i { int v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu9i_BFu31ll { int v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu9i_BFu32i { int v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu9i_BFu32ll { int v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu9i_BFu33 { int v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu9i_BFu7c { int v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu9i_BFu7i { int v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu9i_BFu7ll { int v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu9i_BFu7s { int v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu9i_BFu8c { int v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu9i_BFu8i { int v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu9i_BFu8ll { int v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu9i_BFu8s { int v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu9i_BFu9i { int v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu9i_BFu9ll { int v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu9i_BFu9s { int v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu9i_C { int v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aI_BFu9i_D { int v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aI_BFu9i_F { int v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aI_BFu9i_I { int v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aI_BFu9i_Ip { int v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aI_BFu9i_L { int v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aI_BFu9i_S { int v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aI_BFu9i_Uc { int v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aI_BFu9i_Ui { int v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aI_BFu9i_Ul { int v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu9i_Us { int v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aI_BFu9i_Vp { int v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aI_BFu9ll { int v1; unsigned long long v2:9; };
struct __attribute__((packed)) aI_BFu9ll_BFu15i { int v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu9ll_BFu15ll { int v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu9ll_BFu15s { int v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu9ll_BFu16i { int v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu9ll_BFu16ll { int v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu9ll_BFu16s { int v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu9ll_BFu17i { int v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu9ll_BFu17ll { int v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu9ll_BFu1c { int v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu9ll_BFu1i { int v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu9ll_BFu1ll { int v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu9ll_BFu1s { int v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu9ll_BFu31i { int v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu9ll_BFu31ll { int v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu9ll_BFu32i { int v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu9ll_BFu32ll { int v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu9ll_BFu33 { int v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu9ll_BFu7c { int v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu9ll_BFu7i { int v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu9ll_BFu7ll { int v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu9ll_BFu7s { int v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu9ll_BFu8c { int v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu9ll_BFu8i { int v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu9ll_BFu8ll { int v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu9ll_BFu8s { int v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu9ll_BFu9i { int v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu9ll_BFu9ll { int v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu9ll_BFu9s { int v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu9ll_C { int v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aI_BFu9ll_D { int v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aI_BFu9ll_F { int v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aI_BFu9ll_I { int v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aI_BFu9ll_Ip { int v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aI_BFu9ll_L { int v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aI_BFu9ll_S { int v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aI_BFu9ll_Uc { int v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aI_BFu9ll_Ui { int v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aI_BFu9ll_Ul { int v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu9ll_Us { int v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aI_BFu9ll_Vp { int v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aI_BFu9s { int v1; unsigned short v2:9; };
struct __attribute__((packed)) aI_BFu9s_BFu15i { int v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aI_BFu9s_BFu15ll { int v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aI_BFu9s_BFu15s { int v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aI_BFu9s_BFu16i { int v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aI_BFu9s_BFu16ll { int v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aI_BFu9s_BFu16s { int v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aI_BFu9s_BFu17i { int v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aI_BFu9s_BFu17ll { int v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aI_BFu9s_BFu1c { int v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aI_BFu9s_BFu1i { int v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aI_BFu9s_BFu1ll { int v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aI_BFu9s_BFu1s { int v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aI_BFu9s_BFu31i { int v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aI_BFu9s_BFu31ll { int v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aI_BFu9s_BFu32i { int v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aI_BFu9s_BFu32ll { int v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aI_BFu9s_BFu33 { int v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aI_BFu9s_BFu7c { int v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aI_BFu9s_BFu7i { int v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aI_BFu9s_BFu7ll { int v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aI_BFu9s_BFu7s { int v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aI_BFu9s_BFu8c { int v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aI_BFu9s_BFu8i { int v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aI_BFu9s_BFu8ll { int v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aI_BFu9s_BFu8s { int v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aI_BFu9s_BFu9i { int v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aI_BFu9s_BFu9ll { int v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aI_BFu9s_BFu9s { int v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aI_BFu9s_C { int v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aI_BFu9s_D { int v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aI_BFu9s_F { int v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aI_BFu9s_I { int v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aI_BFu9s_Ip { int v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aI_BFu9s_L { int v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aI_BFu9s_S { int v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aI_BFu9s_Uc { int v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aI_BFu9s_Ui { int v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aI_BFu9s_Ul { int v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aI_BFu9s_Us { int v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aI_BFu9s_Vp { int v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aI_C { int v1; char v2; };
struct __attribute__((packed)) aI_C_BFu15i { int v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_C_BFu15ll { int v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_C_BFu15s { int v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_C_BFu16i { int v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_C_BFu16ll { int v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_C_BFu16s { int v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_C_BFu17i { int v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_C_BFu17ll { int v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_C_BFu1c { int v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_C_BFu1i { int v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_C_BFu1ll { int v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_C_BFu1s { int v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_C_BFu31i { int v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_C_BFu31ll { int v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_C_BFu32i { int v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_C_BFu32ll { int v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_C_BFu33 { int v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_C_BFu7c { int v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_C_BFu7i { int v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_C_BFu7ll { int v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_C_BFu7s { int v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_C_BFu8c { int v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_C_BFu8i { int v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_C_BFu8ll { int v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_C_BFu8s { int v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_C_BFu9i { int v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_C_BFu9ll { int v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_C_BFu9s { int v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_C_C { int v1; char v2; char v3; };
struct __attribute__((packed)) aI_C_D { int v1; char v2; double v3; };
struct __attribute__((packed)) aI_C_F { int v1; char v2; float v3; };
struct __attribute__((packed)) aI_C_I { int v1; char v2; int v3; };
struct __attribute__((packed)) aI_C_Ip { int v1; char v2; int * v3; };
struct __attribute__((packed)) aI_C_L { int v1; char v2; long long v3; };
struct __attribute__((packed)) aI_C_S { int v1; char v2; short v3; };
struct __attribute__((packed)) aI_C_Uc { int v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aI_C_Ui { int v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aI_C_Ul { int v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aI_C_Us { int v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aI_C_Vp { int v1; char v2; void * v3; };
struct __attribute__((packed)) aI_D { int v1; double v2; };
struct __attribute__((packed)) aI_D_BFu15i { int v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_D_BFu15ll { int v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_D_BFu15s { int v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_D_BFu16i { int v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_D_BFu16ll { int v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_D_BFu16s { int v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_D_BFu17i { int v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_D_BFu17ll { int v1; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_D_BFu1c { int v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_D_BFu1i { int v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_D_BFu1ll { int v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_D_BFu1s { int v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_D_BFu31i { int v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_D_BFu31ll { int v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_D_BFu32i { int v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_D_BFu32ll { int v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_D_BFu33 { int v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_D_BFu7c { int v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_D_BFu7i { int v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_D_BFu7ll { int v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_D_BFu7s { int v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_D_BFu8c { int v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_D_BFu8i { int v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_D_BFu8ll { int v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_D_BFu8s { int v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_D_BFu9i { int v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_D_BFu9ll { int v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_D_BFu9s { int v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_D_C { int v1; double v2; char v3; };
struct __attribute__((packed)) aI_D_D { int v1; double v2; double v3; };
struct __attribute__((packed)) aI_D_F { int v1; double v2; float v3; };
struct __attribute__((packed)) aI_D_I { int v1; double v2; int v3; };
struct __attribute__((packed)) aI_D_Ip { int v1; double v2; int * v3; };
struct __attribute__((packed)) aI_D_L { int v1; double v2; long long v3; };
struct __attribute__((packed)) aI_D_S { int v1; double v2; short v3; };
struct __attribute__((packed)) aI_D_Uc { int v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aI_D_Ui { int v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aI_D_Ul { int v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aI_D_Us { int v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aI_D_Vp { int v1; double v2; void * v3; };
struct __attribute__((packed)) aI_F { int v1; float v2; };
struct __attribute__((packed)) aI_F_BFu15i { int v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_F_BFu15ll { int v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_F_BFu15s { int v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_F_BFu16i { int v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_F_BFu16ll { int v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_F_BFu16s { int v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_F_BFu17i { int v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_F_BFu17ll { int v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_F_BFu1c { int v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_F_BFu1i { int v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_F_BFu1ll { int v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_F_BFu1s { int v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_F_BFu31i { int v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_F_BFu31ll { int v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_F_BFu32i { int v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_F_BFu32ll { int v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_F_BFu33 { int v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_F_BFu7c { int v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_F_BFu7i { int v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_F_BFu7ll { int v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_F_BFu7s { int v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_F_BFu8c { int v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_F_BFu8i { int v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_F_BFu8ll { int v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_F_BFu8s { int v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_F_BFu9i { int v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_F_BFu9ll { int v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_F_BFu9s { int v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_F_C { int v1; float v2; char v3; };
struct __attribute__((packed)) aI_F_D { int v1; float v2; double v3; };
struct __attribute__((packed)) aI_F_F { int v1; float v2; float v3; };
struct __attribute__((packed)) aI_F_I { int v1; float v2; int v3; };
struct __attribute__((packed)) aI_F_Ip { int v1; float v2; int * v3; };
struct __attribute__((packed)) aI_F_L { int v1; float v2; long long v3; };
struct __attribute__((packed)) aI_F_S { int v1; float v2; short v3; };
struct __attribute__((packed)) aI_F_Uc { int v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aI_F_Ui { int v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aI_F_Ul { int v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aI_F_Us { int v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aI_F_Vp { int v1; float v2; void * v3; };
struct __attribute__((packed)) aI_I { int v1; int v2; };
struct __attribute__((packed)) aI_I_BFu15i { int v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_I_BFu15ll { int v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_I_BFu15s { int v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_I_BFu16i { int v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_I_BFu16ll { int v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_I_BFu16s { int v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_I_BFu17i { int v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_I_BFu17ll { int v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_I_BFu1c { int v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_I_BFu1i { int v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_I_BFu1ll { int v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_I_BFu1s { int v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_I_BFu31i { int v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_I_BFu31ll { int v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_I_BFu32i { int v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_I_BFu32ll { int v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_I_BFu33 { int v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_I_BFu7c { int v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_I_BFu7i { int v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_I_BFu7ll { int v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_I_BFu7s { int v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_I_BFu8c { int v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_I_BFu8i { int v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_I_BFu8ll { int v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_I_BFu8s { int v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_I_BFu9i { int v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_I_BFu9ll { int v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_I_BFu9s { int v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_I_C { int v1; int v2; char v3; };
struct __attribute__((packed)) aI_I_D { int v1; int v2; double v3; };
struct __attribute__((packed)) aI_I_F { int v1; int v2; float v3; };
struct __attribute__((packed)) aI_I_I { int v1; int v2; int v3; };
struct __attribute__((packed)) aI_I_Ip { int v1; int v2; int * v3; };
struct __attribute__((packed)) aI_I_L { int v1; int v2; long long v3; };
struct __attribute__((packed)) aI_I_S { int v1; int v2; short v3; };
struct __attribute__((packed)) aI_I_Uc { int v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aI_I_Ui { int v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aI_I_Ul { int v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aI_I_Us { int v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aI_I_Vp { int v1; int v2; void * v3; };
struct __attribute__((packed)) aI_Ip { int v1; int * v2; };
struct __attribute__((packed)) aI_Ip_BFu15i { int v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_Ip_BFu15ll { int v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_Ip_BFu15s { int v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_Ip_BFu16i { int v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_Ip_BFu16ll { int v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_Ip_BFu16s { int v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_Ip_BFu17i { int v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_Ip_BFu17ll { int v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_Ip_BFu1c { int v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_Ip_BFu1i { int v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_Ip_BFu1ll { int v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_Ip_BFu1s { int v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_Ip_BFu31i { int v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_Ip_BFu31ll { int v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_Ip_BFu32i { int v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_Ip_BFu32ll { int v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_Ip_BFu33 { int v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_Ip_BFu7c { int v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_Ip_BFu7i { int v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_Ip_BFu7ll { int v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_Ip_BFu7s { int v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_Ip_BFu8c { int v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_Ip_BFu8i { int v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_Ip_BFu8ll { int v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_Ip_BFu8s { int v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_Ip_BFu9i { int v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_Ip_BFu9ll { int v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_Ip_BFu9s { int v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_Ip_C { int v1; int * v2; char v3; };
struct __attribute__((packed)) aI_Ip_D { int v1; int * v2; double v3; };
struct __attribute__((packed)) aI_Ip_F { int v1; int * v2; float v3; };
struct __attribute__((packed)) aI_Ip_I { int v1; int * v2; int v3; };
struct __attribute__((packed)) aI_Ip_Ip { int v1; int * v2; int * v3; };
struct __attribute__((packed)) aI_Ip_L { int v1; int * v2; long long v3; };
struct __attribute__((packed)) aI_Ip_S { int v1; int * v2; short v3; };
struct __attribute__((packed)) aI_Ip_Uc { int v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aI_Ip_Ui { int v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aI_Ip_Ul { int v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aI_Ip_Us { int v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aI_Ip_Vp { int v1; int * v2; void * v3; };
struct __attribute__((packed)) aI_L { int v1; long long v2; };
struct __attribute__((packed)) aI_L_BFu15i { int v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_L_BFu15ll { int v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_L_BFu15s { int v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_L_BFu16i { int v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_L_BFu16ll { int v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_L_BFu16s { int v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_L_BFu17i { int v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_L_BFu17ll { int v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_L_BFu1c { int v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_L_BFu1i { int v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_L_BFu1ll { int v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_L_BFu1s { int v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_L_BFu31i { int v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_L_BFu31ll { int v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_L_BFu32i { int v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_L_BFu32ll { int v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_L_BFu33 { int v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_L_BFu7c { int v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_L_BFu7i { int v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_L_BFu7ll { int v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_L_BFu7s { int v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_L_BFu8c { int v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_L_BFu8i { int v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_L_BFu8ll { int v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_L_BFu8s { int v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_L_BFu9i { int v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_L_BFu9ll { int v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_L_BFu9s { int v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_L_C { int v1; long long v2; char v3; };
struct __attribute__((packed)) aI_L_D { int v1; long long v2; double v3; };
struct __attribute__((packed)) aI_L_F { int v1; long long v2; float v3; };
struct __attribute__((packed)) aI_L_I { int v1; long long v2; int v3; };
struct __attribute__((packed)) aI_L_Ip { int v1; long long v2; int * v3; };
struct __attribute__((packed)) aI_L_L { int v1; long long v2; long long v3; };
struct __attribute__((packed)) aI_L_S { int v1; long long v2; short v3; };
struct __attribute__((packed)) aI_L_Uc { int v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aI_L_Ui { int v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aI_L_Ul { int v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aI_L_Us { int v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aI_L_Vp { int v1; long long v2; void * v3; };
struct __attribute__((packed)) aI_S { int v1; short v2; };
struct __attribute__((packed)) aI_S_BFu15i { int v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_S_BFu15ll { int v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_S_BFu15s { int v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_S_BFu16i { int v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_S_BFu16ll { int v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_S_BFu16s { int v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_S_BFu17i { int v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_S_BFu17ll { int v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_S_BFu1c { int v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_S_BFu1i { int v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_S_BFu1ll { int v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_S_BFu1s { int v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_S_BFu31i { int v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_S_BFu31ll { int v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_S_BFu32i { int v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_S_BFu32ll { int v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_S_BFu33 { int v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_S_BFu7c { int v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_S_BFu7i { int v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_S_BFu7ll { int v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_S_BFu7s { int v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_S_BFu8c { int v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_S_BFu8i { int v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_S_BFu8ll { int v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_S_BFu8s { int v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_S_BFu9i { int v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_S_BFu9ll { int v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_S_BFu9s { int v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_S_C { int v1; short v2; char v3; };
struct __attribute__((packed)) aI_S_D { int v1; short v2; double v3; };
struct __attribute__((packed)) aI_S_F { int v1; short v2; float v3; };
struct __attribute__((packed)) aI_S_I { int v1; short v2; int v3; };
struct __attribute__((packed)) aI_S_Ip { int v1; short v2; int * v3; };
struct __attribute__((packed)) aI_S_L { int v1; short v2; long long v3; };
struct __attribute__((packed)) aI_S_S { int v1; short v2; short v3; };
struct __attribute__((packed)) aI_S_Uc { int v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aI_S_Ui { int v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aI_S_Ul { int v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aI_S_Us { int v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aI_S_Vp { int v1; short v2; void * v3; };
struct __attribute__((packed)) aI_Uc { int v1; unsigned char v2; };
struct __attribute__((packed)) aI_Uc_BFu15i { int v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_Uc_BFu15ll { int v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_Uc_BFu15s { int v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_Uc_BFu16i { int v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_Uc_BFu16ll { int v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_Uc_BFu16s { int v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_Uc_BFu17i { int v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_Uc_BFu17ll { int v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_Uc_BFu1c { int v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_Uc_BFu1i { int v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_Uc_BFu1ll { int v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_Uc_BFu1s { int v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_Uc_BFu31i { int v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_Uc_BFu31ll { int v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_Uc_BFu32i { int v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_Uc_BFu32ll { int v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_Uc_BFu33 { int v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_Uc_BFu7c { int v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_Uc_BFu7i { int v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_Uc_BFu7ll { int v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_Uc_BFu7s { int v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_Uc_BFu8c { int v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_Uc_BFu8i { int v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_Uc_BFu8ll { int v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_Uc_BFu8s { int v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_Uc_BFu9i { int v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_Uc_BFu9ll { int v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_Uc_BFu9s { int v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_Uc_C { int v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aI_Uc_D { int v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aI_Uc_F { int v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aI_Uc_I { int v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aI_Uc_Ip { int v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aI_Uc_L { int v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aI_Uc_S { int v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aI_Uc_Uc { int v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aI_Uc_Ui { int v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aI_Uc_Ul { int v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aI_Uc_Us { int v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aI_Uc_Vp { int v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aI_Ui { int v1; unsigned int v2; };
struct __attribute__((packed)) aI_Ui_BFu15i { int v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_Ui_BFu15ll { int v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_Ui_BFu15s { int v1; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_Ui_BFu16i { int v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_Ui_BFu16ll { int v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_Ui_BFu16s { int v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_Ui_BFu17i { int v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_Ui_BFu17ll { int v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_Ui_BFu1c { int v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_Ui_BFu1i { int v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_Ui_BFu1ll { int v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_Ui_BFu1s { int v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_Ui_BFu31i { int v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_Ui_BFu31ll { int v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_Ui_BFu32i { int v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_Ui_BFu32ll { int v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_Ui_BFu33 { int v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_Ui_BFu7c { int v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_Ui_BFu7i { int v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_Ui_BFu7ll { int v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_Ui_BFu7s { int v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_Ui_BFu8c { int v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_Ui_BFu8i { int v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_Ui_BFu8ll { int v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_Ui_BFu8s { int v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_Ui_BFu9i { int v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_Ui_BFu9ll { int v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_Ui_BFu9s { int v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_Ui_C { int v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aI_Ui_D { int v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aI_Ui_F { int v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aI_Ui_I { int v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aI_Ui_Ip { int v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aI_Ui_L { int v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aI_Ui_S { int v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aI_Ui_Uc { int v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aI_Ui_Ui { int v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aI_Ui_Ul { int v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aI_Ui_Us { int v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aI_Ui_Vp { int v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aI_Ul { int v1; unsigned long long v2; };
struct __attribute__((packed)) aI_Ul_BFu15i { int v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_Ul_BFu15ll { int v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_Ul_BFu15s { int v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_Ul_BFu16i { int v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_Ul_BFu16ll { int v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_Ul_BFu16s { int v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_Ul_BFu17i { int v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_Ul_BFu17ll { int v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_Ul_BFu1c { int v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_Ul_BFu1i { int v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_Ul_BFu1ll { int v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_Ul_BFu1s { int v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_Ul_BFu31i { int v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_Ul_BFu31ll { int v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_Ul_BFu32i { int v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_Ul_BFu32ll { int v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_Ul_BFu33 { int v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_Ul_BFu7c { int v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_Ul_BFu7i { int v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_Ul_BFu7ll { int v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_Ul_BFu7s { int v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_Ul_BFu8c { int v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_Ul_BFu8i { int v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_Ul_BFu8ll { int v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_Ul_BFu8s { int v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_Ul_BFu9i { int v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_Ul_BFu9ll { int v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_Ul_BFu9s { int v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_Ul_C { int v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aI_Ul_D { int v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aI_Ul_F { int v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aI_Ul_I { int v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aI_Ul_Ip { int v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aI_Ul_L { int v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aI_Ul_S { int v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aI_Ul_Uc { int v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aI_Ul_Ui { int v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aI_Ul_Ul { int v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aI_Ul_Us { int v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aI_Ul_Vp { int v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aI_Us { int v1; unsigned short v2; };
struct __attribute__((packed)) aI_Us_BFu15i { int v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_Us_BFu15ll { int v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_Us_BFu15s { int v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_Us_BFu16i { int v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_Us_BFu16ll { int v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_Us_BFu16s { int v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_Us_BFu17i { int v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_Us_BFu17ll { int v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_Us_BFu1c { int v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_Us_BFu1i { int v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_Us_BFu1ll { int v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_Us_BFu1s { int v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_Us_BFu31i { int v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_Us_BFu31ll { int v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_Us_BFu32i { int v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_Us_BFu32ll { int v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_Us_BFu33 { int v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_Us_BFu7c { int v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_Us_BFu7i { int v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_Us_BFu7ll { int v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_Us_BFu7s { int v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_Us_BFu8c { int v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_Us_BFu8i { int v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_Us_BFu8ll { int v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_Us_BFu8s { int v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_Us_BFu9i { int v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_Us_BFu9ll { int v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_Us_BFu9s { int v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_Us_C { int v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aI_Us_D { int v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aI_Us_F { int v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aI_Us_I { int v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aI_Us_Ip { int v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aI_Us_L { int v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aI_Us_S { int v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aI_Us_Uc { int v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aI_Us_Ui { int v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aI_Us_Ul { int v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aI_Us_Us { int v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aI_Us_Vp { int v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aI_Vp { int v1; void * v2; };
struct __attribute__((packed)) aI_Vp_BFu15i { int v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aI_Vp_BFu15ll { int v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aI_Vp_BFu15s { int v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aI_Vp_BFu16i { int v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aI_Vp_BFu16ll { int v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aI_Vp_BFu16s { int v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aI_Vp_BFu17i { int v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aI_Vp_BFu17ll { int v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aI_Vp_BFu1c { int v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aI_Vp_BFu1i { int v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aI_Vp_BFu1ll { int v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aI_Vp_BFu1s { int v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aI_Vp_BFu31i { int v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aI_Vp_BFu31ll { int v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aI_Vp_BFu32i { int v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aI_Vp_BFu32ll { int v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aI_Vp_BFu33 { int v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aI_Vp_BFu7c { int v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aI_Vp_BFu7i { int v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aI_Vp_BFu7ll { int v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aI_Vp_BFu7s { int v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aI_Vp_BFu8c { int v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aI_Vp_BFu8i { int v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aI_Vp_BFu8ll { int v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aI_Vp_BFu8s { int v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aI_Vp_BFu9i { int v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aI_Vp_BFu9ll { int v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aI_Vp_BFu9s { int v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aI_Vp_C { int v1; void * v2; char v3; };
struct __attribute__((packed)) aI_Vp_D { int v1; void * v2; double v3; };
struct __attribute__((packed)) aI_Vp_F { int v1; void * v2; float v3; };
struct __attribute__((packed)) aI_Vp_I { int v1; void * v2; int v3; };
struct __attribute__((packed)) aI_Vp_Ip { int v1; void * v2; int * v3; };
struct __attribute__((packed)) aI_Vp_L { int v1; void * v2; long long v3; };
struct __attribute__((packed)) aI_Vp_S { int v1; void * v2; short v3; };
struct __attribute__((packed)) aI_Vp_Uc { int v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aI_Vp_Ui { int v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aI_Vp_Ul { int v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aI_Vp_Us { int v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aI_Vp_Vp { int v1; void * v2; void * v3; };
struct __attribute__((packed)) aIp { int * v1; };
struct __attribute__((packed)) aIp_BFu15i { int * v1; unsigned int v2:15; };
struct __attribute__((packed)) aIp_BFu15i_BFu15i { int * v1; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu15i_BFu15ll { int * v1; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu15i_BFu15s { int * v1; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu15i_BFu16i { int * v1; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu15i_BFu16ll { int * v1; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu15i_BFu16s { int * v1; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu15i_BFu17i { int * v1; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu15i_BFu17ll { int * v1; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu15i_BFu1c { int * v1; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu15i_BFu1i { int * v1; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu15i_BFu1ll { int * v1; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu15i_BFu1s { int * v1; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu15i_BFu31i { int * v1; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu15i_BFu31ll { int * v1; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu15i_BFu32i { int * v1; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu15i_BFu32ll { int * v1; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu15i_BFu33 { int * v1; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu15i_BFu7c { int * v1; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu15i_BFu7i { int * v1; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu15i_BFu7ll { int * v1; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu15i_BFu7s { int * v1; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu15i_BFu8c { int * v1; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu15i_BFu8i { int * v1; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu15i_BFu8ll { int * v1; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu15i_BFu8s { int * v1; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu15i_BFu9i { int * v1; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu15i_BFu9ll { int * v1; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu15i_BFu9s { int * v1; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu15i_C { int * v1; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aIp_BFu15i_D { int * v1; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aIp_BFu15i_F { int * v1; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aIp_BFu15i_I { int * v1; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aIp_BFu15i_Ip { int * v1; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aIp_BFu15i_L { int * v1; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aIp_BFu15i_S { int * v1; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aIp_BFu15i_Uc { int * v1; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu15i_Ui { int * v1; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu15i_Ul { int * v1; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu15i_Us { int * v1; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu15i_Vp { int * v1; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aIp_BFu15ll { int * v1; unsigned long long v2:15; };
struct __attribute__((packed)) aIp_BFu15ll_BFu15i { int * v1; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu15ll_BFu15ll { int * v1; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu15ll_BFu15s { int * v1; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu15ll_BFu16i { int * v1; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu15ll_BFu16ll { int * v1; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu15ll_BFu16s { int * v1; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu15ll_BFu17i { int * v1; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu15ll_BFu17ll { int * v1; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu15ll_BFu1c { int * v1; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu15ll_BFu1i { int * v1; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu15ll_BFu1ll { int * v1; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu15ll_BFu1s { int * v1; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu15ll_BFu31i { int * v1; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu15ll_BFu31ll { int * v1; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu15ll_BFu32i { int * v1; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu15ll_BFu32ll { int * v1; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu15ll_BFu33 { int * v1; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu15ll_BFu7c { int * v1; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu15ll_BFu7i { int * v1; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu15ll_BFu7ll { int * v1; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu15ll_BFu7s { int * v1; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu15ll_BFu8c { int * v1; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu15ll_BFu8i { int * v1; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu15ll_BFu8ll { int * v1; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu15ll_BFu8s { int * v1; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu15ll_BFu9i { int * v1; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu15ll_BFu9ll { int * v1; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu15ll_BFu9s { int * v1; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu15ll_C { int * v1; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aIp_BFu15ll_D { int * v1; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aIp_BFu15ll_F { int * v1; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aIp_BFu15ll_I { int * v1; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aIp_BFu15ll_Ip { int * v1; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aIp_BFu15ll_L { int * v1; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aIp_BFu15ll_S { int * v1; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aIp_BFu15ll_Uc { int * v1; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu15ll_Ui { int * v1; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu15ll_Ul { int * v1; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aIp_BFu15ll_Us { int * v1; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aIp_BFu15ll_Vp { int * v1; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aIp_BFu15s { int * v1; unsigned short v2:15; };
struct __attribute__((packed)) aIp_BFu15s_BFu15i { int * v1; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aIp_BFu15s_BFu15ll { int * v1; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aIp_BFu15s_BFu15s { int * v1; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aIp_BFu15s_BFu16i { int * v1; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aIp_BFu15s_BFu16ll { int * v1; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aIp_BFu15s_BFu16s { int * v1; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aIp_BFu15s_BFu17i { int * v1; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aIp_BFu15s_BFu17ll { int * v1; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aIp_BFu15s_BFu1c { int * v1; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aIp_BFu15s_BFu1i { int * v1; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aIp_BFu15s_BFu1ll { int * v1; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aIp_BFu15s_BFu1s { int * v1; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aIp_BFu15s_BFu31i { int * v1; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aIp_BFu15s_BFu31ll { int * v1; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aIp_BFu15s_BFu32i { int * v1; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aIp_BFu15s_BFu32ll { int * v1; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aIp_BFu15s_BFu33 { int * v1; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aIp_BFu15s_BFu7c { int * v1; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aIp_BFu15s_BFu7i { int * v1; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aIp_BFu15s_BFu7ll { int * v1; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aIp_BFu15s_BFu7s { int * v1; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aIp_BFu15s_BFu8c { int * v1; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aIp_BFu15s_BFu8i { int * v1; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aIp_BFu15s_BFu8ll { int * v1; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aIp_BFu15s_BFu8s { int * v1; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aIp_BFu15s_BFu9i { int * v1; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aIp_BFu15s_BFu9ll { int * v1; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aIp_BFu15s_BFu9s { int * v1; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aIp_BFu15s_C { int * v1; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aIp_BFu15s_D { int * v1; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aIp_BFu15s_F { int * v1; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aIp_BFu15s_I { int * v1; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aIp_BFu15s_Ip { int * v1; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aIp_BFu15s_L { int * v1; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aIp_BFu15s_S { int * v1; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aIp_BFu15s_Uc { int * v1; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aIp_BFu15s_Ui { int * v1; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aIp_BFu15s_Ul { int * v1; unsigned short v2:15; unsigned long long v3; };


static void Test_aF_BFu1i_L()
{
  {
    init_simple_test("aF_BFu1i_L");
    static STRUCT_IF_C aF_BFu1i_L lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu1i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1i_L)");
    check_field_offset(lv, v1, 0, "aF_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1i_L");
    check_field_offset(lv, v3, 5, "aF_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1i_L, aF_BFu1i_L)
//============================================================================



static void Test_aF_BFu1i_S()
{
  {
    init_simple_test("aF_BFu1i_S");
    static STRUCT_IF_C aF_BFu1i_S lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1i_S)");
    check_field_offset(lv, v1, 0, "aF_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1i_S");
    check_field_offset(lv, v3, 5, "aF_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1i_S, aF_BFu1i_S)
//============================================================================



static void Test_aF_BFu1i_Uc()
{
  {
    init_simple_test("aF_BFu1i_Uc");
    static STRUCT_IF_C aF_BFu1i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1i_Uc");
    check_field_offset(lv, v3, 5, "aF_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1i_Uc, aF_BFu1i_Uc)
//============================================================================



static void Test_aF_BFu1i_Ui()
{
  {
    init_simple_test("aF_BFu1i_Ui");
    static STRUCT_IF_C aF_BFu1i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu1i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1i_Ui");
    check_field_offset(lv, v3, 5, "aF_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1i_Ui, aF_BFu1i_Ui)
//============================================================================



static void Test_aF_BFu1i_Ul()
{
  {
    init_simple_test("aF_BFu1i_Ul");
    static STRUCT_IF_C aF_BFu1i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu1i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1i_Ul");
    check_field_offset(lv, v3, 5, "aF_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1i_Ul, aF_BFu1i_Ul)
//============================================================================



static void Test_aF_BFu1i_Us()
{
  {
    init_simple_test("aF_BFu1i_Us");
    static STRUCT_IF_C aF_BFu1i_Us lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1i_Us");
    check_field_offset(lv, v3, 5, "aF_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1i_Us, aF_BFu1i_Us)
//============================================================================



static void Test_aF_BFu1i_Vp()
{
  {
    init_simple_test("aF_BFu1i_Vp");
    static STRUCT_IF_C aF_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu1i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1i_Vp");
    check_field_offset(lv, v3, 5, "aF_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1i_Vp, aF_BFu1i_Vp)
//============================================================================



static void Test_aF_BFu1ll()
{
  {
    init_simple_test("aF_BFu1ll");
    static STRUCT_IF_C aF_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll, aF_BFu1ll)
//============================================================================



static void Test_aF_BFu1ll_BFu15i()
{
  {
    init_simple_test("aF_BFu1ll_BFu15i");
    static STRUCT_IF_C aF_BFu1ll_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aF_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aF_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu15i, aF_BFu1ll_BFu15i)
//============================================================================



static void Test_aF_BFu1ll_BFu15ll()
{
  {
    init_simple_test("aF_BFu1ll_BFu15ll");
    static STRUCT_IF_C aF_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aF_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aF_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu15ll, aF_BFu1ll_BFu15ll)
//============================================================================



static void Test_aF_BFu1ll_BFu15s()
{
  {
    init_simple_test("aF_BFu1ll_BFu15s");
    static STRUCT_IF_C aF_BFu1ll_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aF_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aF_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu15s, aF_BFu1ll_BFu15s)
//============================================================================



static void Test_aF_BFu1ll_BFu16i()
{
  {
    init_simple_test("aF_BFu1ll_BFu16i");
    static STRUCT_IF_C aF_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aF_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aF_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu16i, aF_BFu1ll_BFu16i)
//============================================================================



static void Test_aF_BFu1ll_BFu16ll()
{
  {
    init_simple_test("aF_BFu1ll_BFu16ll");
    static STRUCT_IF_C aF_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aF_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aF_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu16ll, aF_BFu1ll_BFu16ll)
//============================================================================



static void Test_aF_BFu1ll_BFu16s()
{
  {
    init_simple_test("aF_BFu1ll_BFu16s");
    static STRUCT_IF_C aF_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aF_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aF_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu16s, aF_BFu1ll_BFu16s)
//============================================================================



static void Test_aF_BFu1ll_BFu17i()
{
  {
    init_simple_test("aF_BFu1ll_BFu17i");
    static STRUCT_IF_C aF_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aF_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aF_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu17i, aF_BFu1ll_BFu17i)
//============================================================================



static void Test_aF_BFu1ll_BFu17ll()
{
  {
    init_simple_test("aF_BFu1ll_BFu17ll");
    static STRUCT_IF_C aF_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aF_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aF_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu17ll, aF_BFu1ll_BFu17ll)
//============================================================================



static void Test_aF_BFu1ll_BFu1c()
{
  {
    init_simple_test("aF_BFu1ll_BFu1c");
    static STRUCT_IF_C aF_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aF_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu1c, aF_BFu1ll_BFu1c)
//============================================================================



static void Test_aF_BFu1ll_BFu1i()
{
  {
    init_simple_test("aF_BFu1ll_BFu1i");
    static STRUCT_IF_C aF_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aF_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu1i, aF_BFu1ll_BFu1i)
//============================================================================



static void Test_aF_BFu1ll_BFu1ll()
{
  {
    init_simple_test("aF_BFu1ll_BFu1ll");
    static STRUCT_IF_C aF_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aF_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu1ll, aF_BFu1ll_BFu1ll)
//============================================================================



static void Test_aF_BFu1ll_BFu1s()
{
  {
    init_simple_test("aF_BFu1ll_BFu1s");
    static STRUCT_IF_C aF_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aF_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu1s, aF_BFu1ll_BFu1s)
//============================================================================



static void Test_aF_BFu1ll_BFu31i()
{
  {
    init_simple_test("aF_BFu1ll_BFu31i");
    static STRUCT_IF_C aF_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu1ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aF_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aF_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu31i, aF_BFu1ll_BFu31i)
//============================================================================



static void Test_aF_BFu1ll_BFu31ll()
{
  {
    init_simple_test("aF_BFu1ll_BFu31ll");
    static STRUCT_IF_C aF_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aF_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aF_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu31ll, aF_BFu1ll_BFu31ll)
//============================================================================



static void Test_aF_BFu1ll_BFu32i()
{
  {
    init_simple_test("aF_BFu1ll_BFu32i");
    static STRUCT_IF_C aF_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu1ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aF_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aF_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu32i, aF_BFu1ll_BFu32i)
//============================================================================



static void Test_aF_BFu1ll_BFu32ll()
{
  {
    init_simple_test("aF_BFu1ll_BFu32ll");
    static STRUCT_IF_C aF_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aF_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aF_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu32ll, aF_BFu1ll_BFu32ll)
//============================================================================



static void Test_aF_BFu1ll_BFu33()
{
  {
    init_simple_test("aF_BFu1ll_BFu33");
    static STRUCT_IF_C aF_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu1ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "aF_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "aF_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu33, aF_BFu1ll_BFu33)
//============================================================================



static void Test_aF_BFu1ll_BFu7c()
{
  {
    init_simple_test("aF_BFu1ll_BFu7c");
    static STRUCT_IF_C aF_BFu1ll_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aF_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aF_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu7c, aF_BFu1ll_BFu7c)
//============================================================================



static void Test_aF_BFu1ll_BFu7i()
{
  {
    init_simple_test("aF_BFu1ll_BFu7i");
    static STRUCT_IF_C aF_BFu1ll_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aF_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aF_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu7i, aF_BFu1ll_BFu7i)
//============================================================================



static void Test_aF_BFu1ll_BFu7ll()
{
  {
    init_simple_test("aF_BFu1ll_BFu7ll");
    static STRUCT_IF_C aF_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aF_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aF_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu7ll, aF_BFu1ll_BFu7ll)
//============================================================================



static void Test_aF_BFu1ll_BFu7s()
{
  {
    init_simple_test("aF_BFu1ll_BFu7s");
    static STRUCT_IF_C aF_BFu1ll_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aF_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aF_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu7s, aF_BFu1ll_BFu7s)
//============================================================================



static void Test_aF_BFu1ll_BFu8c()
{
  {
    init_simple_test("aF_BFu1ll_BFu8c");
    static STRUCT_IF_C aF_BFu1ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aF_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aF_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu8c, aF_BFu1ll_BFu8c)
//============================================================================



static void Test_aF_BFu1ll_BFu8i()
{
  {
    init_simple_test("aF_BFu1ll_BFu8i");
    static STRUCT_IF_C aF_BFu1ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aF_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aF_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu8i, aF_BFu1ll_BFu8i)
//============================================================================



static void Test_aF_BFu1ll_BFu8ll()
{
  {
    init_simple_test("aF_BFu1ll_BFu8ll");
    static STRUCT_IF_C aF_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aF_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aF_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu8ll, aF_BFu1ll_BFu8ll)
//============================================================================



static void Test_aF_BFu1ll_BFu8s()
{
  {
    init_simple_test("aF_BFu1ll_BFu8s");
    static STRUCT_IF_C aF_BFu1ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aF_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aF_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu8s, aF_BFu1ll_BFu8s)
//============================================================================



static void Test_aF_BFu1ll_BFu9i()
{
  {
    init_simple_test("aF_BFu1ll_BFu9i");
    static STRUCT_IF_C aF_BFu1ll_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aF_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aF_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu9i, aF_BFu1ll_BFu9i)
//============================================================================



static void Test_aF_BFu1ll_BFu9ll()
{
  {
    init_simple_test("aF_BFu1ll_BFu9ll");
    static STRUCT_IF_C aF_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aF_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aF_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu9ll, aF_BFu1ll_BFu9ll)
//============================================================================



static void Test_aF_BFu1ll_BFu9s()
{
  {
    init_simple_test("aF_BFu1ll_BFu9s");
    static STRUCT_IF_C aF_BFu1ll_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aF_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aF_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_BFu9s, aF_BFu1ll_BFu9s)
//============================================================================



static void Test_aF_BFu1ll_C()
{
  {
    init_simple_test("aF_BFu1ll_C");
    static STRUCT_IF_C aF_BFu1ll_C lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_C");
    check_field_offset(lv, v3, 5, "aF_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_C, aF_BFu1ll_C)
//============================================================================



static void Test_aF_BFu1ll_D()
{
  {
    init_simple_test("aF_BFu1ll_D");
    static STRUCT_IF_C aF_BFu1ll_D lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu1ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_D");
    check_field_offset(lv, v3, 5, "aF_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_D, aF_BFu1ll_D)
//============================================================================



static void Test_aF_BFu1ll_F()
{
  {
    init_simple_test("aF_BFu1ll_F");
    static STRUCT_IF_C aF_BFu1ll_F lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu1ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_F");
    check_field_offset(lv, v3, 5, "aF_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_F, aF_BFu1ll_F)
//============================================================================



static void Test_aF_BFu1ll_I()
{
  {
    init_simple_test("aF_BFu1ll_I");
    static STRUCT_IF_C aF_BFu1ll_I lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu1ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_I");
    check_field_offset(lv, v3, 5, "aF_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_I, aF_BFu1ll_I)
//============================================================================



static void Test_aF_BFu1ll_Ip()
{
  {
    init_simple_test("aF_BFu1ll_Ip");
    static STRUCT_IF_C aF_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu1ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_Ip");
    check_field_offset(lv, v3, 5, "aF_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_Ip, aF_BFu1ll_Ip)
//============================================================================



static void Test_aF_BFu1ll_L()
{
  {
    init_simple_test("aF_BFu1ll_L");
    static STRUCT_IF_C aF_BFu1ll_L lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu1ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_L");
    check_field_offset(lv, v3, 5, "aF_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_L, aF_BFu1ll_L)
//============================================================================



static void Test_aF_BFu1ll_S()
{
  {
    init_simple_test("aF_BFu1ll_S");
    static STRUCT_IF_C aF_BFu1ll_S lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_S");
    check_field_offset(lv, v3, 5, "aF_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_S, aF_BFu1ll_S)
//============================================================================



static void Test_aF_BFu1ll_Uc()
{
  {
    init_simple_test("aF_BFu1ll_Uc");
    static STRUCT_IF_C aF_BFu1ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_Uc");
    check_field_offset(lv, v3, 5, "aF_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_Uc, aF_BFu1ll_Uc)
//============================================================================



static void Test_aF_BFu1ll_Ui()
{
  {
    init_simple_test("aF_BFu1ll_Ui");
    static STRUCT_IF_C aF_BFu1ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu1ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_Ui");
    check_field_offset(lv, v3, 5, "aF_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_Ui, aF_BFu1ll_Ui)
//============================================================================



static void Test_aF_BFu1ll_Ul()
{
  {
    init_simple_test("aF_BFu1ll_Ul");
    static STRUCT_IF_C aF_BFu1ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu1ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_Ul");
    check_field_offset(lv, v3, 5, "aF_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_Ul, aF_BFu1ll_Ul)
//============================================================================



static void Test_aF_BFu1ll_Us()
{
  {
    init_simple_test("aF_BFu1ll_Us");
    static STRUCT_IF_C aF_BFu1ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_Us");
    check_field_offset(lv, v3, 5, "aF_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_Us, aF_BFu1ll_Us)
//============================================================================



static void Test_aF_BFu1ll_Vp()
{
  {
    init_simple_test("aF_BFu1ll_Vp");
    static STRUCT_IF_C aF_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu1ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1ll_Vp");
    check_field_offset(lv, v3, 5, "aF_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1ll_Vp, aF_BFu1ll_Vp)
//============================================================================



static void Test_aF_BFu1s()
{
  {
    init_simple_test("aF_BFu1s");
    static STRUCT_IF_C aF_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s, aF_BFu1s)
//============================================================================



static void Test_aF_BFu1s_BFu15i()
{
  {
    init_simple_test("aF_BFu1s_BFu15i");
    static STRUCT_IF_C aF_BFu1s_BFu15i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aF_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aF_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu15i, aF_BFu1s_BFu15i)
//============================================================================



static void Test_aF_BFu1s_BFu15ll()
{
  {
    init_simple_test("aF_BFu1s_BFu15ll");
    static STRUCT_IF_C aF_BFu1s_BFu15ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aF_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aF_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu15ll, aF_BFu1s_BFu15ll)
//============================================================================



static void Test_aF_BFu1s_BFu15s()
{
  {
    init_simple_test("aF_BFu1s_BFu15s");
    static STRUCT_IF_C aF_BFu1s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "aF_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "aF_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu15s, aF_BFu1s_BFu15s)
//============================================================================



static void Test_aF_BFu1s_BFu16i()
{
  {
    init_simple_test("aF_BFu1s_BFu16i");
    static STRUCT_IF_C aF_BFu1s_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aF_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aF_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu16i, aF_BFu1s_BFu16i)
//============================================================================



static void Test_aF_BFu1s_BFu16ll()
{
  {
    init_simple_test("aF_BFu1s_BFu16ll");
    static STRUCT_IF_C aF_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aF_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aF_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu16ll, aF_BFu1s_BFu16ll)
//============================================================================



static void Test_aF_BFu1s_BFu16s()
{
  {
    init_simple_test("aF_BFu1s_BFu16s");
    static STRUCT_IF_C aF_BFu1s_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "aF_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "aF_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu16s, aF_BFu1s_BFu16s)
//============================================================================



static void Test_aF_BFu1s_BFu17i()
{
  {
    init_simple_test("aF_BFu1s_BFu17i");
    static STRUCT_IF_C aF_BFu1s_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aF_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aF_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu17i, aF_BFu1s_BFu17i)
//============================================================================



static void Test_aF_BFu1s_BFu17ll()
{
  {
    init_simple_test("aF_BFu1s_BFu17ll");
    static STRUCT_IF_C aF_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "aF_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "aF_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu17ll, aF_BFu1s_BFu17ll)
//============================================================================



static void Test_aF_BFu1s_BFu1c()
{
  {
    init_simple_test("aF_BFu1s_BFu1c");
    static STRUCT_IF_C aF_BFu1s_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aF_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu1c, aF_BFu1s_BFu1c)
//============================================================================



static void Test_aF_BFu1s_BFu1i()
{
  {
    init_simple_test("aF_BFu1s_BFu1i");
    static STRUCT_IF_C aF_BFu1s_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aF_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu1i, aF_BFu1s_BFu1i)
//============================================================================



static void Test_aF_BFu1s_BFu1ll()
{
  {
    init_simple_test("aF_BFu1s_BFu1ll");
    static STRUCT_IF_C aF_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aF_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu1ll, aF_BFu1s_BFu1ll)
//============================================================================



static void Test_aF_BFu1s_BFu1s()
{
  {
    init_simple_test("aF_BFu1s_BFu1s");
    static STRUCT_IF_C aF_BFu1s_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "aF_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu1s, aF_BFu1s_BFu1s)
//============================================================================



static void Test_aF_BFu1s_BFu31i()
{
  {
    init_simple_test("aF_BFu1s_BFu31i");
    static STRUCT_IF_C aF_BFu1s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu1s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aF_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aF_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu31i, aF_BFu1s_BFu31i)
//============================================================================



static void Test_aF_BFu1s_BFu31ll()
{
  {
    init_simple_test("aF_BFu1s_BFu31ll");
    static STRUCT_IF_C aF_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu1s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "aF_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "aF_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu31ll, aF_BFu1s_BFu31ll)
//============================================================================



static void Test_aF_BFu1s_BFu32i()
{
  {
    init_simple_test("aF_BFu1s_BFu32i");
    static STRUCT_IF_C aF_BFu1s_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu1s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aF_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aF_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu32i, aF_BFu1s_BFu32i)
//============================================================================



static void Test_aF_BFu1s_BFu32ll()
{
  {
    init_simple_test("aF_BFu1s_BFu32ll");
    static STRUCT_IF_C aF_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu1s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, 1, "aF_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 1, 32, hide_ull(1LL<<31), "aF_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu32ll, aF_BFu1s_BFu32ll)
//============================================================================



static void Test_aF_BFu1s_BFu33()
{
  {
    init_simple_test("aF_BFu1s_BFu33");
    static STRUCT_IF_C aF_BFu1s_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu1s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, 1, "aF_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 4, 1, 33, hide_ull(1LL<<32), "aF_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu33, aF_BFu1s_BFu33)
//============================================================================



static void Test_aF_BFu1s_BFu7c()
{
  {
    init_simple_test("aF_BFu1s_BFu7c");
    static STRUCT_IF_C aF_BFu1s_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aF_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aF_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu7c, aF_BFu1s_BFu7c)
//============================================================================



static void Test_aF_BFu1s_BFu7i()
{
  {
    init_simple_test("aF_BFu1s_BFu7i");
    static STRUCT_IF_C aF_BFu1s_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aF_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aF_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu7i, aF_BFu1s_BFu7i)
//============================================================================



static void Test_aF_BFu1s_BFu7ll()
{
  {
    init_simple_test("aF_BFu1s_BFu7ll");
    static STRUCT_IF_C aF_BFu1s_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aF_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aF_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu7ll, aF_BFu1s_BFu7ll)
//============================================================================



static void Test_aF_BFu1s_BFu7s()
{
  {
    init_simple_test("aF_BFu1s_BFu7s");
    static STRUCT_IF_C aF_BFu1s_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu1s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "aF_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "aF_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu7s, aF_BFu1s_BFu7s)
//============================================================================



static void Test_aF_BFu1s_BFu8c()
{
  {
    init_simple_test("aF_BFu1s_BFu8c");
    static STRUCT_IF_C aF_BFu1s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aF_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aF_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu8c, aF_BFu1s_BFu8c)
//============================================================================



static void Test_aF_BFu1s_BFu8i()
{
  {
    init_simple_test("aF_BFu1s_BFu8i");
    static STRUCT_IF_C aF_BFu1s_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aF_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aF_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu8i, aF_BFu1s_BFu8i)
//============================================================================



static void Test_aF_BFu1s_BFu8ll()
{
  {
    init_simple_test("aF_BFu1s_BFu8ll");
    static STRUCT_IF_C aF_BFu1s_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aF_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aF_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu8ll, aF_BFu1s_BFu8ll)
//============================================================================



static void Test_aF_BFu1s_BFu8s()
{
  {
    init_simple_test("aF_BFu1s_BFu8s");
    static STRUCT_IF_C aF_BFu1s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "aF_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "aF_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu8s, aF_BFu1s_BFu8s)
//============================================================================



static void Test_aF_BFu1s_BFu9i()
{
  {
    init_simple_test("aF_BFu1s_BFu9i");
    static STRUCT_IF_C aF_BFu1s_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aF_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aF_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu9i, aF_BFu1s_BFu9i)
//============================================================================



static void Test_aF_BFu1s_BFu9ll()
{
  {
    init_simple_test("aF_BFu1s_BFu9ll");
    static STRUCT_IF_C aF_BFu1s_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aF_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aF_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu9ll, aF_BFu1s_BFu9ll)
//============================================================================



static void Test_aF_BFu1s_BFu9s()
{
  {
    init_simple_test("aF_BFu1s_BFu9s");
    static STRUCT_IF_C aF_BFu1s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "aF_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "aF_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_BFu9s, aF_BFu1s_BFu9s)
//============================================================================



static void Test_aF_BFu1s_C()
{
  {
    init_simple_test("aF_BFu1s_C");
    static STRUCT_IF_C aF_BFu1s_C lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_C)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_C");
    check_field_offset(lv, v3, 5, "aF_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_C, aF_BFu1s_C)
//============================================================================



static void Test_aF_BFu1s_D()
{
  {
    init_simple_test("aF_BFu1s_D");
    static STRUCT_IF_C aF_BFu1s_D lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu1s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_D)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_D");
    check_field_offset(lv, v3, 5, "aF_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_D, aF_BFu1s_D)
//============================================================================



static void Test_aF_BFu1s_F()
{
  {
    init_simple_test("aF_BFu1s_F");
    static STRUCT_IF_C aF_BFu1s_F lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu1s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_F)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_F");
    check_field_offset(lv, v3, 5, "aF_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_F, aF_BFu1s_F)
//============================================================================



static void Test_aF_BFu1s_I()
{
  {
    init_simple_test("aF_BFu1s_I");
    static STRUCT_IF_C aF_BFu1s_I lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu1s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_I)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_I");
    check_field_offset(lv, v3, 5, "aF_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_I, aF_BFu1s_I)
//============================================================================



static void Test_aF_BFu1s_Ip()
{
  {
    init_simple_test("aF_BFu1s_Ip");
    static STRUCT_IF_C aF_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu1s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_Ip");
    check_field_offset(lv, v3, 5, "aF_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_Ip, aF_BFu1s_Ip)
//============================================================================



static void Test_aF_BFu1s_L()
{
  {
    init_simple_test("aF_BFu1s_L");
    static STRUCT_IF_C aF_BFu1s_L lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu1s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_L)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_L");
    check_field_offset(lv, v3, 5, "aF_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_L, aF_BFu1s_L)
//============================================================================



static void Test_aF_BFu1s_S()
{
  {
    init_simple_test("aF_BFu1s_S");
    static STRUCT_IF_C aF_BFu1s_S lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_S)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_S");
    check_field_offset(lv, v3, 5, "aF_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_S, aF_BFu1s_S)
//============================================================================



static void Test_aF_BFu1s_Uc()
{
  {
    init_simple_test("aF_BFu1s_Uc");
    static STRUCT_IF_C aF_BFu1s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu1s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_Uc");
    check_field_offset(lv, v3, 5, "aF_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_Uc, aF_BFu1s_Uc)
//============================================================================



static void Test_aF_BFu1s_Ui()
{
  {
    init_simple_test("aF_BFu1s_Ui");
    static STRUCT_IF_C aF_BFu1s_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu1s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_Ui");
    check_field_offset(lv, v3, 5, "aF_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_Ui, aF_BFu1s_Ui)
//============================================================================



static void Test_aF_BFu1s_Ul()
{
  {
    init_simple_test("aF_BFu1s_Ul");
    static STRUCT_IF_C aF_BFu1s_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu1s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_Ul");
    check_field_offset(lv, v3, 5, "aF_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_Ul, aF_BFu1s_Ul)
//============================================================================



static void Test_aF_BFu1s_Us()
{
  {
    init_simple_test("aF_BFu1s_Us");
    static STRUCT_IF_C aF_BFu1s_Us lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu1s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_Us");
    check_field_offset(lv, v3, 5, "aF_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_Us, aF_BFu1s_Us)
//============================================================================



static void Test_aF_BFu1s_Vp()
{
  {
    init_simple_test("aF_BFu1s_Vp");
    static STRUCT_IF_C aF_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu1s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 1, 1, "aF_BFu1s_Vp");
    check_field_offset(lv, v3, 5, "aF_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu1s_Vp, aF_BFu1s_Vp)
//============================================================================



static void Test_aF_BFu31i()
{
  {
    init_simple_test("aF_BFu31i");
    static STRUCT_IF_C aF_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i, aF_BFu31i)
//============================================================================



static void Test_aF_BFu31i_BFu15i()
{
  {
    init_simple_test("aF_BFu31i_BFu15i");
    static STRUCT_IF_C aF_BFu31i_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "aF_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "aF_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu15i, aF_BFu31i_BFu15i)
//============================================================================



static void Test_aF_BFu31i_BFu15ll()
{
  {
    init_simple_test("aF_BFu31i_BFu15ll");
    static STRUCT_IF_C aF_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "aF_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "aF_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu15ll, aF_BFu31i_BFu15ll)
//============================================================================



static void Test_aF_BFu31i_BFu15s()
{
  {
    init_simple_test("aF_BFu31i_BFu15s");
    static STRUCT_IF_C aF_BFu31i_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "aF_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "aF_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu15s, aF_BFu31i_BFu15s)
//============================================================================



static void Test_aF_BFu31i_BFu16i()
{
  {
    init_simple_test("aF_BFu31i_BFu16i");
    static STRUCT_IF_C aF_BFu31i_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "aF_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "aF_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu16i, aF_BFu31i_BFu16i)
//============================================================================



static void Test_aF_BFu31i_BFu16ll()
{
  {
    init_simple_test("aF_BFu31i_BFu16ll");
    static STRUCT_IF_C aF_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "aF_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "aF_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu16ll, aF_BFu31i_BFu16ll)
//============================================================================



static void Test_aF_BFu31i_BFu16s()
{
  {
    init_simple_test("aF_BFu31i_BFu16s");
    static STRUCT_IF_C aF_BFu31i_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "aF_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "aF_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu16s, aF_BFu31i_BFu16s)
//============================================================================



static void Test_aF_BFu31i_BFu17i()
{
  {
    init_simple_test("aF_BFu31i_BFu17i");
    static STRUCT_IF_C aF_BFu31i_BFu17i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 7, 7, 17, 1, "aF_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 7, 7, 17, hide_ull(1LL<<16), "aF_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu17i, aF_BFu31i_BFu17i)
//============================================================================



static void Test_aF_BFu31i_BFu17ll()
{
  {
    init_simple_test("aF_BFu31i_BFu17ll");
    static STRUCT_IF_C aF_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 7, 7, 17, 1, "aF_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 7, 7, 17, hide_ull(1LL<<16), "aF_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu17ll, aF_BFu31i_BFu17ll)
//============================================================================



static void Test_aF_BFu31i_BFu1c()
{
  {
    init_simple_test("aF_BFu31i_BFu1c");
    static STRUCT_IF_C aF_BFu31i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu31i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aF_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu1c, aF_BFu31i_BFu1c)
//============================================================================



static void Test_aF_BFu31i_BFu1i()
{
  {
    init_simple_test("aF_BFu31i_BFu1i");
    static STRUCT_IF_C aF_BFu31i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu31i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aF_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu1i, aF_BFu31i_BFu1i)
//============================================================================



static void Test_aF_BFu31i_BFu1ll()
{
  {
    init_simple_test("aF_BFu31i_BFu1ll");
    static STRUCT_IF_C aF_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu31i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aF_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu1ll, aF_BFu31i_BFu1ll)
//============================================================================



static void Test_aF_BFu31i_BFu1s()
{
  {
    init_simple_test("aF_BFu31i_BFu1s");
    static STRUCT_IF_C aF_BFu31i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu31i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aF_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu1s, aF_BFu31i_BFu1s)
//============================================================================



static void Test_aF_BFu31i_BFu31i()
{
  {
    init_simple_test("aF_BFu31i_BFu31i");
    static STRUCT_IF_C aF_BFu31i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 7, 7, 31, 1, "aF_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 7, 7, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu31i, aF_BFu31i_BFu31i)
//============================================================================



static void Test_aF_BFu31i_BFu31ll()
{
  {
    init_simple_test("aF_BFu31i_BFu31ll");
    static STRUCT_IF_C aF_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 7, 7, 31, 1, "aF_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 7, 7, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu31ll, aF_BFu31i_BFu31ll)
//============================================================================



static void Test_aF_BFu31i_BFu32i()
{
  {
    init_simple_test("aF_BFu31i_BFu32i");
    static STRUCT_IF_C aF_BFu31i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 7, 7, 32, 1, "aF_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 7, 7, 32, hide_ull(1LL<<31), "aF_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu32i, aF_BFu31i_BFu32i)
//============================================================================



static void Test_aF_BFu31i_BFu32ll()
{
  {
    init_simple_test("aF_BFu31i_BFu32ll");
    static STRUCT_IF_C aF_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 7, 7, 32, 1, "aF_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 7, 7, 32, hide_ull(1LL<<31), "aF_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu32ll, aF_BFu31i_BFu32ll)
//============================================================================



static void Test_aF_BFu31i_BFu33()
{
  {
    init_simple_test("aF_BFu31i_BFu33");
    static STRUCT_IF_C aF_BFu31i_BFu33 lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 7, 7, 33, 1, "aF_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 7, 7, 33, hide_ull(1LL<<32), "aF_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu33, aF_BFu31i_BFu33)
//============================================================================



static void Test_aF_BFu31i_BFu7c()
{
  {
    init_simple_test("aF_BFu31i_BFu7c");
    static STRUCT_IF_C aF_BFu31i_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aF_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aF_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu7c, aF_BFu31i_BFu7c)
//============================================================================



static void Test_aF_BFu31i_BFu7i()
{
  {
    init_simple_test("aF_BFu31i_BFu7i");
    static STRUCT_IF_C aF_BFu31i_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aF_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aF_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu7i, aF_BFu31i_BFu7i)
//============================================================================



static void Test_aF_BFu31i_BFu7ll()
{
  {
    init_simple_test("aF_BFu31i_BFu7ll");
    static STRUCT_IF_C aF_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aF_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aF_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu7ll, aF_BFu31i_BFu7ll)
//============================================================================



static void Test_aF_BFu31i_BFu7s()
{
  {
    init_simple_test("aF_BFu31i_BFu7s");
    static STRUCT_IF_C aF_BFu31i_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aF_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aF_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu7s, aF_BFu31i_BFu7s)
//============================================================================



static void Test_aF_BFu31i_BFu8c()
{
  {
    init_simple_test("aF_BFu31i_BFu8c");
    static STRUCT_IF_C aF_BFu31i_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aF_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aF_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu8c, aF_BFu31i_BFu8c)
//============================================================================



static void Test_aF_BFu31i_BFu8i()
{
  {
    init_simple_test("aF_BFu31i_BFu8i");
    static STRUCT_IF_C aF_BFu31i_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aF_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aF_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu8i, aF_BFu31i_BFu8i)
//============================================================================



static void Test_aF_BFu31i_BFu8ll()
{
  {
    init_simple_test("aF_BFu31i_BFu8ll");
    static STRUCT_IF_C aF_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aF_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aF_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu8ll, aF_BFu31i_BFu8ll)
//============================================================================



static void Test_aF_BFu31i_BFu8s()
{
  {
    init_simple_test("aF_BFu31i_BFu8s");
    static STRUCT_IF_C aF_BFu31i_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aF_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aF_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu8s, aF_BFu31i_BFu8s)
//============================================================================



static void Test_aF_BFu31i_BFu9i()
{
  {
    init_simple_test("aF_BFu31i_BFu9i");
    static STRUCT_IF_C aF_BFu31i_BFu9i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "aF_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "aF_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu9i, aF_BFu31i_BFu9i)
//============================================================================



static void Test_aF_BFu31i_BFu9ll()
{
  {
    init_simple_test("aF_BFu31i_BFu9ll");
    static STRUCT_IF_C aF_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "aF_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "aF_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu9ll, aF_BFu31i_BFu9ll)
//============================================================================



static void Test_aF_BFu31i_BFu9s()
{
  {
    init_simple_test("aF_BFu31i_BFu9s");
    static STRUCT_IF_C aF_BFu31i_BFu9s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "aF_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "aF_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_BFu9s, aF_BFu31i_BFu9s)
//============================================================================



static void Test_aF_BFu31i_C()
{
  {
    init_simple_test("aF_BFu31i_C");
    static STRUCT_IF_C aF_BFu31i_C lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_C)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_C");
    check_field_offset(lv, v3, 8, "aF_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_C, aF_BFu31i_C)
//============================================================================



static void Test_aF_BFu31i_D()
{
  {
    init_simple_test("aF_BFu31i_D");
    static STRUCT_IF_C aF_BFu31i_D lv;
    check2(sizeof(lv), 16, "sizeof(aF_BFu31i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_D)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_D");
    check_field_offset(lv, v3, 8, "aF_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_D, aF_BFu31i_D)
//============================================================================



static void Test_aF_BFu31i_F()
{
  {
    init_simple_test("aF_BFu31i_F");
    static STRUCT_IF_C aF_BFu31i_F lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_F)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_F");
    check_field_offset(lv, v3, 8, "aF_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_F, aF_BFu31i_F)
//============================================================================



static void Test_aF_BFu31i_I()
{
  {
    init_simple_test("aF_BFu31i_I");
    static STRUCT_IF_C aF_BFu31i_I lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_I)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_I");
    check_field_offset(lv, v3, 8, "aF_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_I, aF_BFu31i_I)
//============================================================================



static void Test_aF_BFu31i_Ip()
{
  {
    init_simple_test("aF_BFu31i_Ip");
    static STRUCT_IF_C aF_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_BFu31i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_Ip");
    check_field_offset(lv, v3, 8, "aF_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_Ip, aF_BFu31i_Ip)
//============================================================================



static void Test_aF_BFu31i_L()
{
  {
    init_simple_test("aF_BFu31i_L");
    static STRUCT_IF_C aF_BFu31i_L lv;
    check2(sizeof(lv), 16, "sizeof(aF_BFu31i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_L)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_L");
    check_field_offset(lv, v3, 8, "aF_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_L, aF_BFu31i_L)
//============================================================================



static void Test_aF_BFu31i_S()
{
  {
    init_simple_test("aF_BFu31i_S");
    static STRUCT_IF_C aF_BFu31i_S lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_S)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_S");
    check_field_offset(lv, v3, 8, "aF_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_S, aF_BFu31i_S)
//============================================================================



static void Test_aF_BFu31i_Uc()
{
  {
    init_simple_test("aF_BFu31i_Uc");
    static STRUCT_IF_C aF_BFu31i_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_Uc");
    check_field_offset(lv, v3, 8, "aF_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_Uc, aF_BFu31i_Uc)
//============================================================================



static void Test_aF_BFu31i_Ui()
{
  {
    init_simple_test("aF_BFu31i_Ui");
    static STRUCT_IF_C aF_BFu31i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_Ui");
    check_field_offset(lv, v3, 8, "aF_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_Ui, aF_BFu31i_Ui)
//============================================================================



static void Test_aF_BFu31i_Ul()
{
  {
    init_simple_test("aF_BFu31i_Ul");
    static STRUCT_IF_C aF_BFu31i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aF_BFu31i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_Ul");
    check_field_offset(lv, v3, 8, "aF_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_Ul, aF_BFu31i_Ul)
//============================================================================



static void Test_aF_BFu31i_Us()
{
  {
    init_simple_test("aF_BFu31i_Us");
    static STRUCT_IF_C aF_BFu31i_Us lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_Us");
    check_field_offset(lv, v3, 8, "aF_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_Us, aF_BFu31i_Us)
//============================================================================



static void Test_aF_BFu31i_Vp()
{
  {
    init_simple_test("aF_BFu31i_Vp");
    static STRUCT_IF_C aF_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_BFu31i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31i_Vp");
    check_field_offset(lv, v3, 8, "aF_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31i_Vp, aF_BFu31i_Vp)
//============================================================================



static void Test_aF_BFu31ll()
{
  {
    init_simple_test("aF_BFu31ll");
    static STRUCT_IF_C aF_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll, aF_BFu31ll)
//============================================================================



static void Test_aF_BFu31ll_BFu15i()
{
  {
    init_simple_test("aF_BFu31ll_BFu15i");
    static STRUCT_IF_C aF_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "aF_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "aF_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu15i, aF_BFu31ll_BFu15i)
//============================================================================



static void Test_aF_BFu31ll_BFu15ll()
{
  {
    init_simple_test("aF_BFu31ll_BFu15ll");
    static STRUCT_IF_C aF_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "aF_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "aF_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu15ll, aF_BFu31ll_BFu15ll)
//============================================================================



static void Test_aF_BFu31ll_BFu15s()
{
  {
    init_simple_test("aF_BFu31ll_BFu15s");
    static STRUCT_IF_C aF_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 7, 7, 15, 1, "aF_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 7, 7, 15, hide_ull(1LL<<14), "aF_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu15s, aF_BFu31ll_BFu15s)
//============================================================================



static void Test_aF_BFu31ll_BFu16i()
{
  {
    init_simple_test("aF_BFu31ll_BFu16i");
    static STRUCT_IF_C aF_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "aF_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "aF_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu16i, aF_BFu31ll_BFu16i)
//============================================================================



static void Test_aF_BFu31ll_BFu16ll()
{
  {
    init_simple_test("aF_BFu31ll_BFu16ll");
    static STRUCT_IF_C aF_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "aF_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "aF_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu16ll, aF_BFu31ll_BFu16ll)
//============================================================================



static void Test_aF_BFu31ll_BFu16s()
{
  {
    init_simple_test("aF_BFu31ll_BFu16s");
    static STRUCT_IF_C aF_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 7, 7, 16, 1, "aF_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 7, 7, 16, hide_ull(1LL<<15), "aF_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu16s, aF_BFu31ll_BFu16s)
//============================================================================



static void Test_aF_BFu31ll_BFu17i()
{
  {
    init_simple_test("aF_BFu31ll_BFu17i");
    static STRUCT_IF_C aF_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 7, 7, 17, 1, "aF_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 7, 7, 17, hide_ull(1LL<<16), "aF_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu17i, aF_BFu31ll_BFu17i)
//============================================================================



static void Test_aF_BFu31ll_BFu17ll()
{
  {
    init_simple_test("aF_BFu31ll_BFu17ll");
    static STRUCT_IF_C aF_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 7, 7, 17, 1, "aF_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 7, 7, 17, hide_ull(1LL<<16), "aF_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu17ll, aF_BFu31ll_BFu17ll)
//============================================================================



static void Test_aF_BFu31ll_BFu1c()
{
  {
    init_simple_test("aF_BFu31ll_BFu1c");
    static STRUCT_IF_C aF_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu31ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aF_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu1c, aF_BFu31ll_BFu1c)
//============================================================================



static void Test_aF_BFu31ll_BFu1i()
{
  {
    init_simple_test("aF_BFu31ll_BFu1i");
    static STRUCT_IF_C aF_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu31ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aF_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu1i, aF_BFu31ll_BFu1i)
//============================================================================



static void Test_aF_BFu31ll_BFu1ll()
{
  {
    init_simple_test("aF_BFu31ll_BFu1ll");
    static STRUCT_IF_C aF_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aF_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu1ll, aF_BFu31ll_BFu1ll)
//============================================================================



static void Test_aF_BFu31ll_BFu1s()
{
  {
    init_simple_test("aF_BFu31ll_BFu1s");
    static STRUCT_IF_C aF_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu31ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "aF_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu1s, aF_BFu31ll_BFu1s)
//============================================================================



static void Test_aF_BFu31ll_BFu31i()
{
  {
    init_simple_test("aF_BFu31ll_BFu31i");
    static STRUCT_IF_C aF_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 7, 7, 31, 1, "aF_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 7, 7, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu31i, aF_BFu31ll_BFu31i)
//============================================================================



static void Test_aF_BFu31ll_BFu31ll()
{
  {
    init_simple_test("aF_BFu31ll_BFu31ll");
    static STRUCT_IF_C aF_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 7, 7, 31, 1, "aF_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 7, 7, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu31ll, aF_BFu31ll_BFu31ll)
//============================================================================



static void Test_aF_BFu31ll_BFu32i()
{
  {
    init_simple_test("aF_BFu31ll_BFu32i");
    static STRUCT_IF_C aF_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 7, 7, 32, 1, "aF_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 7, 7, 32, hide_ull(1LL<<31), "aF_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu32i, aF_BFu31ll_BFu32i)
//============================================================================



static void Test_aF_BFu31ll_BFu32ll()
{
  {
    init_simple_test("aF_BFu31ll_BFu32ll");
    static STRUCT_IF_C aF_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 7, 7, 32, 1, "aF_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 7, 7, 32, hide_ull(1LL<<31), "aF_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu32ll, aF_BFu31ll_BFu32ll)
//============================================================================



static void Test_aF_BFu31ll_BFu33()
{
  {
    init_simple_test("aF_BFu31ll_BFu33");
    static STRUCT_IF_C aF_BFu31ll_BFu33 lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 7, 7, 33, 1, "aF_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 7, 7, 33, hide_ull(1LL<<32), "aF_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu33, aF_BFu31ll_BFu33)
//============================================================================



static void Test_aF_BFu31ll_BFu7c()
{
  {
    init_simple_test("aF_BFu31ll_BFu7c");
    static STRUCT_IF_C aF_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aF_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aF_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu7c, aF_BFu31ll_BFu7c)
//============================================================================



static void Test_aF_BFu31ll_BFu7i()
{
  {
    init_simple_test("aF_BFu31ll_BFu7i");
    static STRUCT_IF_C aF_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aF_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aF_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu7i, aF_BFu31ll_BFu7i)
//============================================================================



static void Test_aF_BFu31ll_BFu7ll()
{
  {
    init_simple_test("aF_BFu31ll_BFu7ll");
    static STRUCT_IF_C aF_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aF_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aF_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu7ll, aF_BFu31ll_BFu7ll)
//============================================================================



static void Test_aF_BFu31ll_BFu7s()
{
  {
    init_simple_test("aF_BFu31ll_BFu7s");
    static STRUCT_IF_C aF_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 7, 7, 7, 1, "aF_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 7, 7, 7, hide_ull(1LL<<6), "aF_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu7s, aF_BFu31ll_BFu7s)
//============================================================================



static void Test_aF_BFu31ll_BFu8c()
{
  {
    init_simple_test("aF_BFu31ll_BFu8c");
    static STRUCT_IF_C aF_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aF_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aF_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu8c, aF_BFu31ll_BFu8c)
//============================================================================



static void Test_aF_BFu31ll_BFu8i()
{
  {
    init_simple_test("aF_BFu31ll_BFu8i");
    static STRUCT_IF_C aF_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aF_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aF_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu8i, aF_BFu31ll_BFu8i)
//============================================================================



static void Test_aF_BFu31ll_BFu8ll()
{
  {
    init_simple_test("aF_BFu31ll_BFu8ll");
    static STRUCT_IF_C aF_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aF_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aF_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu8ll, aF_BFu31ll_BFu8ll)
//============================================================================



static void Test_aF_BFu31ll_BFu8s()
{
  {
    init_simple_test("aF_BFu31ll_BFu8s");
    static STRUCT_IF_C aF_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 7, 7, 8, 1, "aF_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 7, 7, 8, hide_ull(1LL<<7), "aF_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu8s, aF_BFu31ll_BFu8s)
//============================================================================



static void Test_aF_BFu31ll_BFu9i()
{
  {
    init_simple_test("aF_BFu31ll_BFu9i");
    static STRUCT_IF_C aF_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "aF_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "aF_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu9i, aF_BFu31ll_BFu9i)
//============================================================================



static void Test_aF_BFu31ll_BFu9ll()
{
  {
    init_simple_test("aF_BFu31ll_BFu9ll");
    static STRUCT_IF_C aF_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "aF_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "aF_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu9ll, aF_BFu31ll_BFu9ll)
//============================================================================



static void Test_aF_BFu31ll_BFu9s()
{
  {
    init_simple_test("aF_BFu31ll_BFu9s");
    static STRUCT_IF_C aF_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 7, 7, 9, 1, "aF_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 7, 7, 9, hide_ull(1LL<<8), "aF_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_BFu9s, aF_BFu31ll_BFu9s)
//============================================================================



static void Test_aF_BFu31ll_C()
{
  {
    init_simple_test("aF_BFu31ll_C");
    static STRUCT_IF_C aF_BFu31ll_C lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_C");
    check_field_offset(lv, v3, 8, "aF_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_C, aF_BFu31ll_C)
//============================================================================



static void Test_aF_BFu31ll_D()
{
  {
    init_simple_test("aF_BFu31ll_D");
    static STRUCT_IF_C aF_BFu31ll_D lv;
    check2(sizeof(lv), 16, "sizeof(aF_BFu31ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_D");
    check_field_offset(lv, v3, 8, "aF_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_D, aF_BFu31ll_D)
//============================================================================



static void Test_aF_BFu31ll_F()
{
  {
    init_simple_test("aF_BFu31ll_F");
    static STRUCT_IF_C aF_BFu31ll_F lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_F");
    check_field_offset(lv, v3, 8, "aF_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_F, aF_BFu31ll_F)
//============================================================================



static void Test_aF_BFu31ll_I()
{
  {
    init_simple_test("aF_BFu31ll_I");
    static STRUCT_IF_C aF_BFu31ll_I lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_I");
    check_field_offset(lv, v3, 8, "aF_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_I, aF_BFu31ll_I)
//============================================================================



static void Test_aF_BFu31ll_Ip()
{
  {
    init_simple_test("aF_BFu31ll_Ip");
    static STRUCT_IF_C aF_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_BFu31ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_Ip");
    check_field_offset(lv, v3, 8, "aF_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_Ip, aF_BFu31ll_Ip)
//============================================================================



static void Test_aF_BFu31ll_L()
{
  {
    init_simple_test("aF_BFu31ll_L");
    static STRUCT_IF_C aF_BFu31ll_L lv;
    check2(sizeof(lv), 16, "sizeof(aF_BFu31ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_L");
    check_field_offset(lv, v3, 8, "aF_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_L, aF_BFu31ll_L)
//============================================================================



static void Test_aF_BFu31ll_S()
{
  {
    init_simple_test("aF_BFu31ll_S");
    static STRUCT_IF_C aF_BFu31ll_S lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_S");
    check_field_offset(lv, v3, 8, "aF_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_S, aF_BFu31ll_S)
//============================================================================



static void Test_aF_BFu31ll_Uc()
{
  {
    init_simple_test("aF_BFu31ll_Uc");
    static STRUCT_IF_C aF_BFu31ll_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu31ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_Uc");
    check_field_offset(lv, v3, 8, "aF_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_Uc, aF_BFu31ll_Uc)
//============================================================================



static void Test_aF_BFu31ll_Ui()
{
  {
    init_simple_test("aF_BFu31ll_Ui");
    static STRUCT_IF_C aF_BFu31ll_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu31ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_Ui");
    check_field_offset(lv, v3, 8, "aF_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_Ui, aF_BFu31ll_Ui)
//============================================================================



static void Test_aF_BFu31ll_Ul()
{
  {
    init_simple_test("aF_BFu31ll_Ul");
    static STRUCT_IF_C aF_BFu31ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aF_BFu31ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_Ul");
    check_field_offset(lv, v3, 8, "aF_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_Ul, aF_BFu31ll_Ul)
//============================================================================



static void Test_aF_BFu31ll_Us()
{
  {
    init_simple_test("aF_BFu31ll_Us");
    static STRUCT_IF_C aF_BFu31ll_Us lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu31ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_Us");
    check_field_offset(lv, v3, 8, "aF_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_Us, aF_BFu31ll_Us)
//============================================================================



static void Test_aF_BFu31ll_Vp()
{
  {
    init_simple_test("aF_BFu31ll_Vp");
    static STRUCT_IF_C aF_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_BFu31ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "aF_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "aF_BFu31ll_Vp");
    check_field_offset(lv, v3, 8, "aF_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu31ll_Vp, aF_BFu31ll_Vp)
//============================================================================



static void Test_aF_BFu32i()
{
  {
    init_simple_test("aF_BFu32i");
    static STRUCT_IF_C aF_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i, aF_BFu32i)
//============================================================================



static void Test_aF_BFu32i_BFu15i()
{
  {
    init_simple_test("aF_BFu32i_BFu15i");
    static STRUCT_IF_C aF_BFu32i_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu15i, aF_BFu32i_BFu15i)
//============================================================================



static void Test_aF_BFu32i_BFu15ll()
{
  {
    init_simple_test("aF_BFu32i_BFu15ll");
    static STRUCT_IF_C aF_BFu32i_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu15ll, aF_BFu32i_BFu15ll)
//============================================================================



static void Test_aF_BFu32i_BFu15s()
{
  {
    init_simple_test("aF_BFu32i_BFu15s");
    static STRUCT_IF_C aF_BFu32i_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu15s, aF_BFu32i_BFu15s)
//============================================================================



static void Test_aF_BFu32i_BFu16i()
{
  {
    init_simple_test("aF_BFu32i_BFu16i");
    static STRUCT_IF_C aF_BFu32i_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu16i, aF_BFu32i_BFu16i)
//============================================================================



static void Test_aF_BFu32i_BFu16ll()
{
  {
    init_simple_test("aF_BFu32i_BFu16ll");
    static STRUCT_IF_C aF_BFu32i_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu16ll, aF_BFu32i_BFu16ll)
//============================================================================



static void Test_aF_BFu32i_BFu16s()
{
  {
    init_simple_test("aF_BFu32i_BFu16s");
    static STRUCT_IF_C aF_BFu32i_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu16s, aF_BFu32i_BFu16s)
//============================================================================



static void Test_aF_BFu32i_BFu17i()
{
  {
    init_simple_test("aF_BFu32i_BFu17i");
    static STRUCT_IF_C aF_BFu32i_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(aF_BFu32i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aF_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aF_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu17i, aF_BFu32i_BFu17i)
//============================================================================



static void Test_aF_BFu32i_BFu17ll()
{
  {
    init_simple_test("aF_BFu32i_BFu17ll");
    static STRUCT_IF_C aF_BFu32i_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(aF_BFu32i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aF_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aF_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu17ll, aF_BFu32i_BFu17ll)
//============================================================================



static void Test_aF_BFu32i_BFu1c()
{
  {
    init_simple_test("aF_BFu32i_BFu1c");
    static STRUCT_IF_C aF_BFu32i_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu1c, aF_BFu32i_BFu1c)
//============================================================================



static void Test_aF_BFu32i_BFu1i()
{
  {
    init_simple_test("aF_BFu32i_BFu1i");
    static STRUCT_IF_C aF_BFu32i_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu1i, aF_BFu32i_BFu1i)
//============================================================================



static void Test_aF_BFu32i_BFu1ll()
{
  {
    init_simple_test("aF_BFu32i_BFu1ll");
    static STRUCT_IF_C aF_BFu32i_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu1ll, aF_BFu32i_BFu1ll)
//============================================================================



static void Test_aF_BFu32i_BFu1s()
{
  {
    init_simple_test("aF_BFu32i_BFu1s");
    static STRUCT_IF_C aF_BFu32i_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu1s, aF_BFu32i_BFu1s)
//============================================================================



static void Test_aF_BFu32i_BFu31i()
{
  {
    init_simple_test("aF_BFu32i_BFu31i");
    static STRUCT_IF_C aF_BFu32i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "aF_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "aF_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu31i, aF_BFu32i_BFu31i)
//============================================================================



static void Test_aF_BFu32i_BFu31ll()
{
  {
    init_simple_test("aF_BFu32i_BFu31ll");
    static STRUCT_IF_C aF_BFu32i_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "aF_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "aF_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu31ll, aF_BFu32i_BFu31ll)
//============================================================================



static void Test_aF_BFu32i_BFu32i()
{
  {
    init_simple_test("aF_BFu32i_BFu32i");
    static STRUCT_IF_C aF_BFu32i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "aF_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu32i, aF_BFu32i_BFu32i)
//============================================================================



static void Test_aF_BFu32i_BFu32ll()
{
  {
    init_simple_test("aF_BFu32i_BFu32ll");
    static STRUCT_IF_C aF_BFu32i_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "aF_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu32ll, aF_BFu32i_BFu32ll)
//============================================================================



static void Test_aF_BFu32i_BFu33()
{
  {
    init_simple_test("aF_BFu32i_BFu33");
    static STRUCT_IF_C aF_BFu32i_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu32i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "aF_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "aF_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu33, aF_BFu32i_BFu33)
//============================================================================



static void Test_aF_BFu32i_BFu7c()
{
  {
    init_simple_test("aF_BFu32i_BFu7c");
    static STRUCT_IF_C aF_BFu32i_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu7c, aF_BFu32i_BFu7c)
//============================================================================



static void Test_aF_BFu32i_BFu7i()
{
  {
    init_simple_test("aF_BFu32i_BFu7i");
    static STRUCT_IF_C aF_BFu32i_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu7i, aF_BFu32i_BFu7i)
//============================================================================



static void Test_aF_BFu32i_BFu7ll()
{
  {
    init_simple_test("aF_BFu32i_BFu7ll");
    static STRUCT_IF_C aF_BFu32i_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu7ll, aF_BFu32i_BFu7ll)
//============================================================================



static void Test_aF_BFu32i_BFu7s()
{
  {
    init_simple_test("aF_BFu32i_BFu7s");
    static STRUCT_IF_C aF_BFu32i_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu7s, aF_BFu32i_BFu7s)
//============================================================================



static void Test_aF_BFu32i_BFu8c()
{
  {
    init_simple_test("aF_BFu32i_BFu8c");
    static STRUCT_IF_C aF_BFu32i_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu8c, aF_BFu32i_BFu8c)
//============================================================================



static void Test_aF_BFu32i_BFu8i()
{
  {
    init_simple_test("aF_BFu32i_BFu8i");
    static STRUCT_IF_C aF_BFu32i_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu8i, aF_BFu32i_BFu8i)
//============================================================================



static void Test_aF_BFu32i_BFu8ll()
{
  {
    init_simple_test("aF_BFu32i_BFu8ll");
    static STRUCT_IF_C aF_BFu32i_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu8ll, aF_BFu32i_BFu8ll)
//============================================================================



static void Test_aF_BFu32i_BFu8s()
{
  {
    init_simple_test("aF_BFu32i_BFu8s");
    static STRUCT_IF_C aF_BFu32i_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu8s, aF_BFu32i_BFu8s)
//============================================================================



static void Test_aF_BFu32i_BFu9i()
{
  {
    init_simple_test("aF_BFu32i_BFu9i");
    static STRUCT_IF_C aF_BFu32i_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu9i, aF_BFu32i_BFu9i)
//============================================================================



static void Test_aF_BFu32i_BFu9ll()
{
  {
    init_simple_test("aF_BFu32i_BFu9ll");
    static STRUCT_IF_C aF_BFu32i_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu9ll, aF_BFu32i_BFu9ll)
//============================================================================



static void Test_aF_BFu32i_BFu9s()
{
  {
    init_simple_test("aF_BFu32i_BFu9s");
    static STRUCT_IF_C aF_BFu32i_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_BFu9s, aF_BFu32i_BFu9s)
//============================================================================



static void Test_aF_BFu32i_C()
{
  {
    init_simple_test("aF_BFu32i_C");
    static STRUCT_IF_C aF_BFu32i_C lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_C)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_C");
    check_field_offset(lv, v3, 8, "aF_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_C, aF_BFu32i_C)
//============================================================================



static void Test_aF_BFu32i_D()
{
  {
    init_simple_test("aF_BFu32i_D");
    static STRUCT_IF_C aF_BFu32i_D lv;
    check2(sizeof(lv), 16, "sizeof(aF_BFu32i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_D)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_D");
    check_field_offset(lv, v3, 8, "aF_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_D, aF_BFu32i_D)
//============================================================================



static void Test_aF_BFu32i_F()
{
  {
    init_simple_test("aF_BFu32i_F");
    static STRUCT_IF_C aF_BFu32i_F lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_F)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_F");
    check_field_offset(lv, v3, 8, "aF_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_F, aF_BFu32i_F)
//============================================================================



static void Test_aF_BFu32i_I()
{
  {
    init_simple_test("aF_BFu32i_I");
    static STRUCT_IF_C aF_BFu32i_I lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_I)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_I");
    check_field_offset(lv, v3, 8, "aF_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_I, aF_BFu32i_I)
//============================================================================



static void Test_aF_BFu32i_Ip()
{
  {
    init_simple_test("aF_BFu32i_Ip");
    static STRUCT_IF_C aF_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_BFu32i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_Ip");
    check_field_offset(lv, v3, 8, "aF_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_Ip, aF_BFu32i_Ip)
//============================================================================



static void Test_aF_BFu32i_L()
{
  {
    init_simple_test("aF_BFu32i_L");
    static STRUCT_IF_C aF_BFu32i_L lv;
    check2(sizeof(lv), 16, "sizeof(aF_BFu32i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_L)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_L");
    check_field_offset(lv, v3, 8, "aF_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_L, aF_BFu32i_L)
//============================================================================



static void Test_aF_BFu32i_S()
{
  {
    init_simple_test("aF_BFu32i_S");
    static STRUCT_IF_C aF_BFu32i_S lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_S)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_S");
    check_field_offset(lv, v3, 8, "aF_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_S, aF_BFu32i_S)
//============================================================================



static void Test_aF_BFu32i_Uc()
{
  {
    init_simple_test("aF_BFu32i_Uc");
    static STRUCT_IF_C aF_BFu32i_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_Uc");
    check_field_offset(lv, v3, 8, "aF_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_Uc, aF_BFu32i_Uc)
//============================================================================



static void Test_aF_BFu32i_Ui()
{
  {
    init_simple_test("aF_BFu32i_Ui");
    static STRUCT_IF_C aF_BFu32i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_Ui");
    check_field_offset(lv, v3, 8, "aF_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_Ui, aF_BFu32i_Ui)
//============================================================================



static void Test_aF_BFu32i_Ul()
{
  {
    init_simple_test("aF_BFu32i_Ul");
    static STRUCT_IF_C aF_BFu32i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aF_BFu32i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_Ul");
    check_field_offset(lv, v3, 8, "aF_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_Ul, aF_BFu32i_Ul)
//============================================================================



static void Test_aF_BFu32i_Us()
{
  {
    init_simple_test("aF_BFu32i_Us");
    static STRUCT_IF_C aF_BFu32i_Us lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_Us");
    check_field_offset(lv, v3, 8, "aF_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_Us, aF_BFu32i_Us)
//============================================================================



static void Test_aF_BFu32i_Vp()
{
  {
    init_simple_test("aF_BFu32i_Vp");
    static STRUCT_IF_C aF_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_BFu32i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32i_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu32i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32i_Vp");
    check_field_offset(lv, v3, 8, "aF_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32i_Vp, aF_BFu32i_Vp)
//============================================================================



static void Test_aF_BFu32ll()
{
  {
    init_simple_test("aF_BFu32ll");
    static STRUCT_IF_C aF_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll, aF_BFu32ll)
//============================================================================



static void Test_aF_BFu32ll_BFu15i()
{
  {
    init_simple_test("aF_BFu32ll_BFu15i");
    static STRUCT_IF_C aF_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu15i, aF_BFu32ll_BFu15i)
//============================================================================



static void Test_aF_BFu32ll_BFu15ll()
{
  {
    init_simple_test("aF_BFu32ll_BFu15ll");
    static STRUCT_IF_C aF_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu15ll, aF_BFu32ll_BFu15ll)
//============================================================================



static void Test_aF_BFu32ll_BFu15s()
{
  {
    init_simple_test("aF_BFu32ll_BFu15s");
    static STRUCT_IF_C aF_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu15s, aF_BFu32ll_BFu15s)
//============================================================================



static void Test_aF_BFu32ll_BFu16i()
{
  {
    init_simple_test("aF_BFu32ll_BFu16i");
    static STRUCT_IF_C aF_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu16i, aF_BFu32ll_BFu16i)
//============================================================================



static void Test_aF_BFu32ll_BFu16ll()
{
  {
    init_simple_test("aF_BFu32ll_BFu16ll");
    static STRUCT_IF_C aF_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu16ll, aF_BFu32ll_BFu16ll)
//============================================================================



static void Test_aF_BFu32ll_BFu16s()
{
  {
    init_simple_test("aF_BFu32ll_BFu16s");
    static STRUCT_IF_C aF_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu16s, aF_BFu32ll_BFu16s)
//============================================================================



static void Test_aF_BFu32ll_BFu17i()
{
  {
    init_simple_test("aF_BFu32ll_BFu17i");
    static STRUCT_IF_C aF_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(aF_BFu32ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aF_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aF_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu17i, aF_BFu32ll_BFu17i)
//============================================================================



static void Test_aF_BFu32ll_BFu17ll()
{
  {
    init_simple_test("aF_BFu32ll_BFu17ll");
    static STRUCT_IF_C aF_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(aF_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aF_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aF_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu17ll, aF_BFu32ll_BFu17ll)
//============================================================================



static void Test_aF_BFu32ll_BFu1c()
{
  {
    init_simple_test("aF_BFu32ll_BFu1c");
    static STRUCT_IF_C aF_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu1c, aF_BFu32ll_BFu1c)
//============================================================================



static void Test_aF_BFu32ll_BFu1i()
{
  {
    init_simple_test("aF_BFu32ll_BFu1i");
    static STRUCT_IF_C aF_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu1i, aF_BFu32ll_BFu1i)
//============================================================================



static void Test_aF_BFu32ll_BFu1ll()
{
  {
    init_simple_test("aF_BFu32ll_BFu1ll");
    static STRUCT_IF_C aF_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu1ll, aF_BFu32ll_BFu1ll)
//============================================================================



static void Test_aF_BFu32ll_BFu1s()
{
  {
    init_simple_test("aF_BFu32ll_BFu1s");
    static STRUCT_IF_C aF_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu1s, aF_BFu32ll_BFu1s)
//============================================================================



static void Test_aF_BFu32ll_BFu31i()
{
  {
    init_simple_test("aF_BFu32ll_BFu31i");
    static STRUCT_IF_C aF_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "aF_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "aF_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu31i, aF_BFu32ll_BFu31i)
//============================================================================



static void Test_aF_BFu32ll_BFu31ll()
{
  {
    init_simple_test("aF_BFu32ll_BFu31ll");
    static STRUCT_IF_C aF_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "aF_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "aF_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu31ll, aF_BFu32ll_BFu31ll)
//============================================================================



static void Test_aF_BFu32ll_BFu32i()
{
  {
    init_simple_test("aF_BFu32ll_BFu32i");
    static STRUCT_IF_C aF_BFu32ll_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "aF_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu32i, aF_BFu32ll_BFu32i)
//============================================================================



static void Test_aF_BFu32ll_BFu32ll()
{
  {
    init_simple_test("aF_BFu32ll_BFu32ll");
    static STRUCT_IF_C aF_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "aF_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu32ll, aF_BFu32ll_BFu32ll)
//============================================================================



static void Test_aF_BFu32ll_BFu33()
{
  {
    init_simple_test("aF_BFu32ll_BFu33");
    static STRUCT_IF_C aF_BFu32ll_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu32ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "aF_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "aF_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu33, aF_BFu32ll_BFu33)
//============================================================================



static void Test_aF_BFu32ll_BFu7c()
{
  {
    init_simple_test("aF_BFu32ll_BFu7c");
    static STRUCT_IF_C aF_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu7c, aF_BFu32ll_BFu7c)
//============================================================================



static void Test_aF_BFu32ll_BFu7i()
{
  {
    init_simple_test("aF_BFu32ll_BFu7i");
    static STRUCT_IF_C aF_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu7i, aF_BFu32ll_BFu7i)
//============================================================================



static void Test_aF_BFu32ll_BFu7ll()
{
  {
    init_simple_test("aF_BFu32ll_BFu7ll");
    static STRUCT_IF_C aF_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu7ll, aF_BFu32ll_BFu7ll)
//============================================================================



static void Test_aF_BFu32ll_BFu7s()
{
  {
    init_simple_test("aF_BFu32ll_BFu7s");
    static STRUCT_IF_C aF_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu7s, aF_BFu32ll_BFu7s)
//============================================================================



static void Test_aF_BFu32ll_BFu8c()
{
  {
    init_simple_test("aF_BFu32ll_BFu8c");
    static STRUCT_IF_C aF_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu8c, aF_BFu32ll_BFu8c)
//============================================================================



static void Test_aF_BFu32ll_BFu8i()
{
  {
    init_simple_test("aF_BFu32ll_BFu8i");
    static STRUCT_IF_C aF_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu8i, aF_BFu32ll_BFu8i)
//============================================================================



static void Test_aF_BFu32ll_BFu8ll()
{
  {
    init_simple_test("aF_BFu32ll_BFu8ll");
    static STRUCT_IF_C aF_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu8ll, aF_BFu32ll_BFu8ll)
//============================================================================



static void Test_aF_BFu32ll_BFu8s()
{
  {
    init_simple_test("aF_BFu32ll_BFu8s");
    static STRUCT_IF_C aF_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu8s, aF_BFu32ll_BFu8s)
//============================================================================



static void Test_aF_BFu32ll_BFu9i()
{
  {
    init_simple_test("aF_BFu32ll_BFu9i");
    static STRUCT_IF_C aF_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu9i, aF_BFu32ll_BFu9i)
//============================================================================



static void Test_aF_BFu32ll_BFu9ll()
{
  {
    init_simple_test("aF_BFu32ll_BFu9ll");
    static STRUCT_IF_C aF_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu9ll, aF_BFu32ll_BFu9ll)
//============================================================================



static void Test_aF_BFu32ll_BFu9s()
{
  {
    init_simple_test("aF_BFu32ll_BFu9s");
    static STRUCT_IF_C aF_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_BFu9s, aF_BFu32ll_BFu9s)
//============================================================================



static void Test_aF_BFu32ll_C()
{
  {
    init_simple_test("aF_BFu32ll_C");
    static STRUCT_IF_C aF_BFu32ll_C lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_C)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_C");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_C");
    check_field_offset(lv, v3, 8, "aF_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_C, aF_BFu32ll_C)
//============================================================================



static void Test_aF_BFu32ll_D()
{
  {
    init_simple_test("aF_BFu32ll_D");
    static STRUCT_IF_C aF_BFu32ll_D lv;
    check2(sizeof(lv), 16, "sizeof(aF_BFu32ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_D)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_D");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_D");
    check_field_offset(lv, v3, 8, "aF_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_D, aF_BFu32ll_D)
//============================================================================



static void Test_aF_BFu32ll_F()
{
  {
    init_simple_test("aF_BFu32ll_F");
    static STRUCT_IF_C aF_BFu32ll_F lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_F)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_F");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_F");
    check_field_offset(lv, v3, 8, "aF_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_F, aF_BFu32ll_F)
//============================================================================



static void Test_aF_BFu32ll_I()
{
  {
    init_simple_test("aF_BFu32ll_I");
    static STRUCT_IF_C aF_BFu32ll_I lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_I)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_I");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_I");
    check_field_offset(lv, v3, 8, "aF_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_I, aF_BFu32ll_I)
//============================================================================



static void Test_aF_BFu32ll_Ip()
{
  {
    init_simple_test("aF_BFu32ll_Ip");
    static STRUCT_IF_C aF_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_BFu32ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_Ip");
    check_field_offset(lv, v3, 8, "aF_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_Ip, aF_BFu32ll_Ip)
//============================================================================



static void Test_aF_BFu32ll_L()
{
  {
    init_simple_test("aF_BFu32ll_L");
    static STRUCT_IF_C aF_BFu32ll_L lv;
    check2(sizeof(lv), 16, "sizeof(aF_BFu32ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_L)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_L");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_L");
    check_field_offset(lv, v3, 8, "aF_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_L, aF_BFu32ll_L)
//============================================================================



static void Test_aF_BFu32ll_S()
{
  {
    init_simple_test("aF_BFu32ll_S");
    static STRUCT_IF_C aF_BFu32ll_S lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_S)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_S");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_S");
    check_field_offset(lv, v3, 8, "aF_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_S, aF_BFu32ll_S)
//============================================================================



static void Test_aF_BFu32ll_Uc()
{
  {
    init_simple_test("aF_BFu32ll_Uc");
    static STRUCT_IF_C aF_BFu32ll_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu32ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_Uc");
    check_field_offset(lv, v3, 8, "aF_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_Uc, aF_BFu32ll_Uc)
//============================================================================



static void Test_aF_BFu32ll_Ui()
{
  {
    init_simple_test("aF_BFu32ll_Ui");
    static STRUCT_IF_C aF_BFu32ll_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu32ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_Ui");
    check_field_offset(lv, v3, 8, "aF_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_Ui, aF_BFu32ll_Ui)
//============================================================================



static void Test_aF_BFu32ll_Ul()
{
  {
    init_simple_test("aF_BFu32ll_Ul");
    static STRUCT_IF_C aF_BFu32ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aF_BFu32ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_Ul");
    check_field_offset(lv, v3, 8, "aF_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_Ul, aF_BFu32ll_Ul)
//============================================================================



static void Test_aF_BFu32ll_Us()
{
  {
    init_simple_test("aF_BFu32ll_Us");
    static STRUCT_IF_C aF_BFu32ll_Us lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu32ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_Us");
    check_field_offset(lv, v3, 8, "aF_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_Us, aF_BFu32ll_Us)
//============================================================================



static void Test_aF_BFu32ll_Vp()
{
  {
    init_simple_test("aF_BFu32ll_Vp");
    static STRUCT_IF_C aF_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_BFu32ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu32ll_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu32ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "aF_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "aF_BFu32ll_Vp");
    check_field_offset(lv, v3, 8, "aF_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu32ll_Vp, aF_BFu32ll_Vp)
//============================================================================



static void Test_aF_BFu33()
{
  {
    init_simple_test("aF_BFu33");
    static STRUCT_IF_C aF_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33, aF_BFu33)
//============================================================================



static void Test_aF_BFu33_BFu15i()
{
  {
    init_simple_test("aF_BFu33_BFu15i");
    static STRUCT_IF_C aF_BFu33_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu33_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "aF_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "aF_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu15i, aF_BFu33_BFu15i)
//============================================================================



static void Test_aF_BFu33_BFu15ll()
{
  {
    init_simple_test("aF_BFu33_BFu15ll");
    static STRUCT_IF_C aF_BFu33_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu33_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "aF_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "aF_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu15ll, aF_BFu33_BFu15ll)
//============================================================================



static void Test_aF_BFu33_BFu15s()
{
  {
    init_simple_test("aF_BFu33_BFu15s");
    static STRUCT_IF_C aF_BFu33_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu33_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, 1, "aF_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 8, 1, 15, hide_ull(1LL<<14), "aF_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu15s, aF_BFu33_BFu15s)
//============================================================================



static void Test_aF_BFu33_BFu16i()
{
  {
    init_simple_test("aF_BFu33_BFu16i");
    static STRUCT_IF_C aF_BFu33_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(aF_BFu33_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "aF_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "aF_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu16i, aF_BFu33_BFu16i)
//============================================================================



static void Test_aF_BFu33_BFu16ll()
{
  {
    init_simple_test("aF_BFu33_BFu16ll");
    static STRUCT_IF_C aF_BFu33_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(aF_BFu33_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "aF_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "aF_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu16ll, aF_BFu33_BFu16ll)
//============================================================================



static void Test_aF_BFu33_BFu16s()
{
  {
    init_simple_test("aF_BFu33_BFu16s");
    static STRUCT_IF_C aF_BFu33_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(aF_BFu33_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 8, 1, 16, 1, "aF_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 8, 1, 16, hide_ull(1LL<<15), "aF_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu16s, aF_BFu33_BFu16s)
//============================================================================



static void Test_aF_BFu33_BFu17i()
{
  {
    init_simple_test("aF_BFu33_BFu17i");
    static STRUCT_IF_C aF_BFu33_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(aF_BFu33_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "aF_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "aF_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu17i, aF_BFu33_BFu17i)
//============================================================================



static void Test_aF_BFu33_BFu17ll()
{
  {
    init_simple_test("aF_BFu33_BFu17ll");
    static STRUCT_IF_C aF_BFu33_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(aF_BFu33_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, 1, "aF_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 8, 1, 17, hide_ull(1LL<<16), "aF_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu17ll, aF_BFu33_BFu17ll)
//============================================================================



static void Test_aF_BFu33_BFu1c()
{
  {
    init_simple_test("aF_BFu33_BFu1c");
    static STRUCT_IF_C aF_BFu33_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu33_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "aF_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu1c, aF_BFu33_BFu1c)
//============================================================================



static void Test_aF_BFu33_BFu1i()
{
  {
    init_simple_test("aF_BFu33_BFu1i");
    static STRUCT_IF_C aF_BFu33_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu33_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "aF_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu1i, aF_BFu33_BFu1i)
//============================================================================



static void Test_aF_BFu33_BFu1ll()
{
  {
    init_simple_test("aF_BFu33_BFu1ll");
    static STRUCT_IF_C aF_BFu33_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu33_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "aF_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu1ll, aF_BFu33_BFu1ll)
//============================================================================



static void Test_aF_BFu33_BFu1s()
{
  {
    init_simple_test("aF_BFu33_BFu1s");
    static STRUCT_IF_C aF_BFu33_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu33_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 8, 1, 1, 1, "aF_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu1s, aF_BFu33_BFu1s)
//============================================================================



static void Test_aF_BFu33_BFu31i()
{
  {
    init_simple_test("aF_BFu33_BFu31i");
    static STRUCT_IF_C aF_BFu33_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu33_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "aF_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "aF_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu31i, aF_BFu33_BFu31i)
//============================================================================



static void Test_aF_BFu33_BFu31ll()
{
  {
    init_simple_test("aF_BFu33_BFu31ll");
    static STRUCT_IF_C aF_BFu33_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_BFu33_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, 1, "aF_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 8, 1, 31, hide_ull(1LL<<30), "aF_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu31ll, aF_BFu33_BFu31ll)
//============================================================================



static void Test_aF_BFu33_BFu32i()
{
  {
    init_simple_test("aF_BFu33_BFu32i");
    static STRUCT_IF_C aF_BFu33_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu33_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 1, 32, 1, "aF_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 8, 1, 32, hide_ull(1LL<<31), "aF_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu32i, aF_BFu33_BFu32i)
//============================================================================



static void Test_aF_BFu33_BFu32ll()
{
  {
    init_simple_test("aF_BFu33_BFu32ll");
    static STRUCT_IF_C aF_BFu33_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu33_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 8, 1, 32, 1, "aF_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 8, 1, 32, hide_ull(1LL<<31), "aF_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu32ll, aF_BFu33_BFu32ll)
//============================================================================



static void Test_aF_BFu33_BFu33()
{
  {
    init_simple_test("aF_BFu33_BFu33");
    static STRUCT_IF_C aF_BFu33_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu33_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu33");
    set_bf_and_test(lv, v3, 8, 1, 33, 1, "aF_BFu33_BFu33");
    set_bf_and_test(lv, v3, 8, 1, 33, hide_ull(1LL<<32), "aF_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu33, aF_BFu33_BFu33)
//============================================================================



static void Test_aF_BFu33_BFu7c()
{
  {
    init_simple_test("aF_BFu33_BFu7c");
    static STRUCT_IF_C aF_BFu33_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu33_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "aF_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "aF_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu7c, aF_BFu33_BFu7c)
//============================================================================



static void Test_aF_BFu33_BFu7i()
{
  {
    init_simple_test("aF_BFu33_BFu7i");
    static STRUCT_IF_C aF_BFu33_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu33_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "aF_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "aF_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu7i, aF_BFu33_BFu7i)
//============================================================================



static void Test_aF_BFu33_BFu7ll()
{
  {
    init_simple_test("aF_BFu33_BFu7ll");
    static STRUCT_IF_C aF_BFu33_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu33_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "aF_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "aF_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu7ll, aF_BFu33_BFu7ll)
//============================================================================



static void Test_aF_BFu33_BFu7s()
{
  {
    init_simple_test("aF_BFu33_BFu7s");
    static STRUCT_IF_C aF_BFu33_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu33_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 8, 1, 7, 1, "aF_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 8, 1, 7, hide_ull(1LL<<6), "aF_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu7s, aF_BFu33_BFu7s)
//============================================================================



static void Test_aF_BFu33_BFu8c()
{
  {
    init_simple_test("aF_BFu33_BFu8c");
    static STRUCT_IF_C aF_BFu33_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu33_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "aF_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "aF_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu8c, aF_BFu33_BFu8c)
//============================================================================



static void Test_aF_BFu33_BFu8i()
{
  {
    init_simple_test("aF_BFu33_BFu8i");
    static STRUCT_IF_C aF_BFu33_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu33_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "aF_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "aF_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu8i, aF_BFu33_BFu8i)
//============================================================================



static void Test_aF_BFu33_BFu8ll()
{
  {
    init_simple_test("aF_BFu33_BFu8ll");
    static STRUCT_IF_C aF_BFu33_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu33_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "aF_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "aF_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu8ll, aF_BFu33_BFu8ll)
//============================================================================



static void Test_aF_BFu33_BFu8s()
{
  {
    init_simple_test("aF_BFu33_BFu8s");
    static STRUCT_IF_C aF_BFu33_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu33_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, 1, "aF_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 8, 1, 8, hide_ull(1LL<<7), "aF_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu8s, aF_BFu33_BFu8s)
//============================================================================



static void Test_aF_BFu33_BFu9i()
{
  {
    init_simple_test("aF_BFu33_BFu9i");
    static STRUCT_IF_C aF_BFu33_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu33_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "aF_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "aF_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu9i, aF_BFu33_BFu9i)
//============================================================================



static void Test_aF_BFu33_BFu9ll()
{
  {
    init_simple_test("aF_BFu33_BFu9ll");
    static STRUCT_IF_C aF_BFu33_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu33_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "aF_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "aF_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu9ll, aF_BFu33_BFu9ll)
//============================================================================



static void Test_aF_BFu33_BFu9s()
{
  {
    init_simple_test("aF_BFu33_BFu9s");
    static STRUCT_IF_C aF_BFu33_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu33_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu33_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, 1, "aF_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 8, 1, 9, hide_ull(1LL<<8), "aF_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_BFu9s, aF_BFu33_BFu9s)
//============================================================================



static void Test_aF_BFu33_C()
{
  {
    init_simple_test("aF_BFu33_C");
    static STRUCT_IF_C aF_BFu33_C lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu33_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_C)");
    check_field_offset(lv, v1, 0, "aF_BFu33_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_C");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_C");
    check_field_offset(lv, v3, 9, "aF_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_C, aF_BFu33_C)
//============================================================================



static void Test_aF_BFu33_D()
{
  {
    init_simple_test("aF_BFu33_D");
    static STRUCT_IF_C aF_BFu33_D lv;
    check2(sizeof(lv), 17, "sizeof(aF_BFu33_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_D)");
    check_field_offset(lv, v1, 0, "aF_BFu33_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_D");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_D");
    check_field_offset(lv, v3, 9, "aF_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_D, aF_BFu33_D)
//============================================================================



static void Test_aF_BFu33_F()
{
  {
    init_simple_test("aF_BFu33_F");
    static STRUCT_IF_C aF_BFu33_F lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu33_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_F)");
    check_field_offset(lv, v1, 0, "aF_BFu33_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_F");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_F");
    check_field_offset(lv, v3, 9, "aF_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_F, aF_BFu33_F)
//============================================================================



static void Test_aF_BFu33_I()
{
  {
    init_simple_test("aF_BFu33_I");
    static STRUCT_IF_C aF_BFu33_I lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu33_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_I)");
    check_field_offset(lv, v1, 0, "aF_BFu33_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_I");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_I");
    check_field_offset(lv, v3, 9, "aF_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_I, aF_BFu33_I)
//============================================================================



static void Test_aF_BFu33_Ip()
{
  {
    init_simple_test("aF_BFu33_Ip");
    static STRUCT_IF_C aF_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aF_BFu33_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_Ip");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_Ip");
    check_field_offset(lv, v3, 9, "aF_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_Ip, aF_BFu33_Ip)
//============================================================================



static void Test_aF_BFu33_L()
{
  {
    init_simple_test("aF_BFu33_L");
    static STRUCT_IF_C aF_BFu33_L lv;
    check2(sizeof(lv), 17, "sizeof(aF_BFu33_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_L)");
    check_field_offset(lv, v1, 0, "aF_BFu33_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_L");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_L");
    check_field_offset(lv, v3, 9, "aF_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_L, aF_BFu33_L)
//============================================================================



static void Test_aF_BFu33_S()
{
  {
    init_simple_test("aF_BFu33_S");
    static STRUCT_IF_C aF_BFu33_S lv;
    check2(sizeof(lv), 11, "sizeof(aF_BFu33_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_S)");
    check_field_offset(lv, v1, 0, "aF_BFu33_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_S");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_S");
    check_field_offset(lv, v3, 9, "aF_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_S, aF_BFu33_S)
//============================================================================



static void Test_aF_BFu33_Uc()
{
  {
    init_simple_test("aF_BFu33_Uc");
    static STRUCT_IF_C aF_BFu33_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu33_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_Uc");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_Uc");
    check_field_offset(lv, v3, 9, "aF_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_Uc, aF_BFu33_Uc)
//============================================================================



static void Test_aF_BFu33_Ui()
{
  {
    init_simple_test("aF_BFu33_Ui");
    static STRUCT_IF_C aF_BFu33_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu33_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_Ui");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_Ui");
    check_field_offset(lv, v3, 9, "aF_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_Ui, aF_BFu33_Ui)
//============================================================================



static void Test_aF_BFu33_Ul()
{
  {
    init_simple_test("aF_BFu33_Ul");
    static STRUCT_IF_C aF_BFu33_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aF_BFu33_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_Ul");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_Ul");
    check_field_offset(lv, v3, 9, "aF_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_Ul, aF_BFu33_Ul)
//============================================================================



static void Test_aF_BFu33_Us()
{
  {
    init_simple_test("aF_BFu33_Us");
    static STRUCT_IF_C aF_BFu33_Us lv;
    check2(sizeof(lv), 11, "sizeof(aF_BFu33_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu33_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_Us");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_Us");
    check_field_offset(lv, v3, 9, "aF_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_Us, aF_BFu33_Us)
//============================================================================



static void Test_aF_BFu33_Vp()
{
  {
    init_simple_test("aF_BFu33_Vp");
    static STRUCT_IF_C aF_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aF_BFu33_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 33, 1, "aF_BFu33_Vp");
    set_bf_and_test(lv, v2, 4, 0, 33, hide_ull(1LL<<32), "aF_BFu33_Vp");
    check_field_offset(lv, v3, 9, "aF_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu33_Vp, aF_BFu33_Vp)
//============================================================================



static void Test_aF_BFu7c()
{
  {
    init_simple_test("aF_BFu7c");
    static STRUCT_IF_C aF_BFu7c lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c, aF_BFu7c)
//============================================================================



static void Test_aF_BFu7c_BFu15i()
{
  {
    init_simple_test("aF_BFu7c_BFu15i");
    static STRUCT_IF_C aF_BFu7c_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aF_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aF_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu15i, aF_BFu7c_BFu15i)
//============================================================================



static void Test_aF_BFu7c_BFu15ll()
{
  {
    init_simple_test("aF_BFu7c_BFu15ll");
    static STRUCT_IF_C aF_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aF_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aF_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu15ll, aF_BFu7c_BFu15ll)
//============================================================================



static void Test_aF_BFu7c_BFu15s()
{
  {
    init_simple_test("aF_BFu7c_BFu15s");
    static STRUCT_IF_C aF_BFu7c_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aF_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aF_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu15s, aF_BFu7c_BFu15s)
//============================================================================



static void Test_aF_BFu7c_BFu16i()
{
  {
    init_simple_test("aF_BFu7c_BFu16i");
    static STRUCT_IF_C aF_BFu7c_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aF_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aF_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu16i, aF_BFu7c_BFu16i)
//============================================================================



static void Test_aF_BFu7c_BFu16ll()
{
  {
    init_simple_test("aF_BFu7c_BFu16ll");
    static STRUCT_IF_C aF_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aF_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aF_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu16ll, aF_BFu7c_BFu16ll)
//============================================================================



static void Test_aF_BFu7c_BFu16s()
{
  {
    init_simple_test("aF_BFu7c_BFu16s");
    static STRUCT_IF_C aF_BFu7c_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aF_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aF_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu16s, aF_BFu7c_BFu16s)
//============================================================================



static void Test_aF_BFu7c_BFu17i()
{
  {
    init_simple_test("aF_BFu7c_BFu17i");
    static STRUCT_IF_C aF_BFu7c_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aF_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aF_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu17i, aF_BFu7c_BFu17i)
//============================================================================



static void Test_aF_BFu7c_BFu17ll()
{
  {
    init_simple_test("aF_BFu7c_BFu17ll");
    static STRUCT_IF_C aF_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aF_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aF_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu17ll, aF_BFu7c_BFu17ll)
//============================================================================



static void Test_aF_BFu7c_BFu1c()
{
  {
    init_simple_test("aF_BFu7c_BFu1c");
    static STRUCT_IF_C aF_BFu7c_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu1c, aF_BFu7c_BFu1c)
//============================================================================



static void Test_aF_BFu7c_BFu1i()
{
  {
    init_simple_test("aF_BFu7c_BFu1i");
    static STRUCT_IF_C aF_BFu7c_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu1i, aF_BFu7c_BFu1i)
//============================================================================



static void Test_aF_BFu7c_BFu1ll()
{
  {
    init_simple_test("aF_BFu7c_BFu1ll");
    static STRUCT_IF_C aF_BFu7c_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu1ll, aF_BFu7c_BFu1ll)
//============================================================================



static void Test_aF_BFu7c_BFu1s()
{
  {
    init_simple_test("aF_BFu7c_BFu1s");
    static STRUCT_IF_C aF_BFu7c_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu1s, aF_BFu7c_BFu1s)
//============================================================================



static void Test_aF_BFu7c_BFu31i()
{
  {
    init_simple_test("aF_BFu7c_BFu31i");
    static STRUCT_IF_C aF_BFu7c_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aF_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aF_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu31i, aF_BFu7c_BFu31i)
//============================================================================



static void Test_aF_BFu7c_BFu31ll()
{
  {
    init_simple_test("aF_BFu7c_BFu31ll");
    static STRUCT_IF_C aF_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aF_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aF_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu31ll, aF_BFu7c_BFu31ll)
//============================================================================



static void Test_aF_BFu7c_BFu32i()
{
  {
    init_simple_test("aF_BFu7c_BFu32i");
    static STRUCT_IF_C aF_BFu7c_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aF_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aF_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu32i, aF_BFu7c_BFu32i)
//============================================================================



static void Test_aF_BFu7c_BFu32ll()
{
  {
    init_simple_test("aF_BFu7c_BFu32ll");
    static STRUCT_IF_C aF_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aF_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aF_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu32ll, aF_BFu7c_BFu32ll)
//============================================================================



static void Test_aF_BFu7c_BFu33()
{
  {
    init_simple_test("aF_BFu7c_BFu33");
    static STRUCT_IF_C aF_BFu7c_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, 1, "aF_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, hide_ull(1LL<<32), "aF_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu33, aF_BFu7c_BFu33)
//============================================================================



static void Test_aF_BFu7c_BFu7c()
{
  {
    init_simple_test("aF_BFu7c_BFu7c");
    static STRUCT_IF_C aF_BFu7c_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu7c, aF_BFu7c_BFu7c)
//============================================================================



static void Test_aF_BFu7c_BFu7i()
{
  {
    init_simple_test("aF_BFu7c_BFu7i");
    static STRUCT_IF_C aF_BFu7c_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu7i, aF_BFu7c_BFu7i)
//============================================================================



static void Test_aF_BFu7c_BFu7ll()
{
  {
    init_simple_test("aF_BFu7c_BFu7ll");
    static STRUCT_IF_C aF_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu7ll, aF_BFu7c_BFu7ll)
//============================================================================



static void Test_aF_BFu7c_BFu7s()
{
  {
    init_simple_test("aF_BFu7c_BFu7s");
    static STRUCT_IF_C aF_BFu7c_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu7s, aF_BFu7c_BFu7s)
//============================================================================



static void Test_aF_BFu7c_BFu8c()
{
  {
    init_simple_test("aF_BFu7c_BFu8c");
    static STRUCT_IF_C aF_BFu7c_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu8c, aF_BFu7c_BFu8c)
//============================================================================



static void Test_aF_BFu7c_BFu8i()
{
  {
    init_simple_test("aF_BFu7c_BFu8i");
    static STRUCT_IF_C aF_BFu7c_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu8i, aF_BFu7c_BFu8i)
//============================================================================



static void Test_aF_BFu7c_BFu8ll()
{
  {
    init_simple_test("aF_BFu7c_BFu8ll");
    static STRUCT_IF_C aF_BFu7c_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu8ll, aF_BFu7c_BFu8ll)
//============================================================================



static void Test_aF_BFu7c_BFu8s()
{
  {
    init_simple_test("aF_BFu7c_BFu8s");
    static STRUCT_IF_C aF_BFu7c_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu8s, aF_BFu7c_BFu8s)
//============================================================================



static void Test_aF_BFu7c_BFu9i()
{
  {
    init_simple_test("aF_BFu7c_BFu9i");
    static STRUCT_IF_C aF_BFu7c_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aF_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aF_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu9i, aF_BFu7c_BFu9i)
//============================================================================



static void Test_aF_BFu7c_BFu9ll()
{
  {
    init_simple_test("aF_BFu7c_BFu9ll");
    static STRUCT_IF_C aF_BFu7c_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aF_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aF_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu9ll, aF_BFu7c_BFu9ll)
//============================================================================



static void Test_aF_BFu7c_BFu9s()
{
  {
    init_simple_test("aF_BFu7c_BFu9s");
    static STRUCT_IF_C aF_BFu7c_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aF_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aF_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_BFu9s, aF_BFu7c_BFu9s)
//============================================================================



static void Test_aF_BFu7c_C()
{
  {
    init_simple_test("aF_BFu7c_C");
    static STRUCT_IF_C aF_BFu7c_C lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_C)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_C");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_C");
    check_field_offset(lv, v3, 5, "aF_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_C, aF_BFu7c_C)
//============================================================================



static void Test_aF_BFu7c_D()
{
  {
    init_simple_test("aF_BFu7c_D");
    static STRUCT_IF_C aF_BFu7c_D lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu7c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_D)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_D");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_D");
    check_field_offset(lv, v3, 5, "aF_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_D, aF_BFu7c_D)
//============================================================================



static void Test_aF_BFu7c_F()
{
  {
    init_simple_test("aF_BFu7c_F");
    static STRUCT_IF_C aF_BFu7c_F lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_F)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_F");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_F");
    check_field_offset(lv, v3, 5, "aF_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_F, aF_BFu7c_F)
//============================================================================



static void Test_aF_BFu7c_I()
{
  {
    init_simple_test("aF_BFu7c_I");
    static STRUCT_IF_C aF_BFu7c_I lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_I)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_I");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_I");
    check_field_offset(lv, v3, 5, "aF_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_I, aF_BFu7c_I)
//============================================================================



static void Test_aF_BFu7c_Ip()
{
  {
    init_simple_test("aF_BFu7c_Ip");
    static STRUCT_IF_C aF_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu7c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_Ip");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_Ip");
    check_field_offset(lv, v3, 5, "aF_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_Ip, aF_BFu7c_Ip)
//============================================================================



static void Test_aF_BFu7c_L()
{
  {
    init_simple_test("aF_BFu7c_L");
    static STRUCT_IF_C aF_BFu7c_L lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_L)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_L");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_L");
    check_field_offset(lv, v3, 5, "aF_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_L, aF_BFu7c_L)
//============================================================================



static void Test_aF_BFu7c_S()
{
  {
    init_simple_test("aF_BFu7c_S");
    static STRUCT_IF_C aF_BFu7c_S lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_S)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_S");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_S");
    check_field_offset(lv, v3, 5, "aF_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_S, aF_BFu7c_S)
//============================================================================



static void Test_aF_BFu7c_Uc()
{
  {
    init_simple_test("aF_BFu7c_Uc");
    static STRUCT_IF_C aF_BFu7c_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_Uc");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_Uc");
    check_field_offset(lv, v3, 5, "aF_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_Uc, aF_BFu7c_Uc)
//============================================================================



static void Test_aF_BFu7c_Ui()
{
  {
    init_simple_test("aF_BFu7c_Ui");
    static STRUCT_IF_C aF_BFu7c_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_Ui");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_Ui");
    check_field_offset(lv, v3, 5, "aF_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_Ui, aF_BFu7c_Ui)
//============================================================================



static void Test_aF_BFu7c_Ul()
{
  {
    init_simple_test("aF_BFu7c_Ul");
    static STRUCT_IF_C aF_BFu7c_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_Ul");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_Ul");
    check_field_offset(lv, v3, 5, "aF_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_Ul, aF_BFu7c_Ul)
//============================================================================



static void Test_aF_BFu7c_Us()
{
  {
    init_simple_test("aF_BFu7c_Us");
    static STRUCT_IF_C aF_BFu7c_Us lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_Us");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_Us");
    check_field_offset(lv, v3, 5, "aF_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_Us, aF_BFu7c_Us)
//============================================================================



static void Test_aF_BFu7c_Vp()
{
  {
    init_simple_test("aF_BFu7c_Vp");
    static STRUCT_IF_C aF_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7c_Vp");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7c_Vp");
    check_field_offset(lv, v3, 5, "aF_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7c_Vp, aF_BFu7c_Vp)
//============================================================================



static void Test_aF_BFu7i()
{
  {
    init_simple_test("aF_BFu7i");
    static STRUCT_IF_C aF_BFu7i lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i, aF_BFu7i)
//============================================================================



static void Test_aF_BFu7i_BFu15i()
{
  {
    init_simple_test("aF_BFu7i_BFu15i");
    static STRUCT_IF_C aF_BFu7i_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aF_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aF_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu15i, aF_BFu7i_BFu15i)
//============================================================================



static void Test_aF_BFu7i_BFu15ll()
{
  {
    init_simple_test("aF_BFu7i_BFu15ll");
    static STRUCT_IF_C aF_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aF_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aF_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu15ll, aF_BFu7i_BFu15ll)
//============================================================================



static void Test_aF_BFu7i_BFu15s()
{
  {
    init_simple_test("aF_BFu7i_BFu15s");
    static STRUCT_IF_C aF_BFu7i_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aF_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aF_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu15s, aF_BFu7i_BFu15s)
//============================================================================



static void Test_aF_BFu7i_BFu16i()
{
  {
    init_simple_test("aF_BFu7i_BFu16i");
    static STRUCT_IF_C aF_BFu7i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aF_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aF_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu16i, aF_BFu7i_BFu16i)
//============================================================================



static void Test_aF_BFu7i_BFu16ll()
{
  {
    init_simple_test("aF_BFu7i_BFu16ll");
    static STRUCT_IF_C aF_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aF_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aF_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu16ll, aF_BFu7i_BFu16ll)
//============================================================================



static void Test_aF_BFu7i_BFu16s()
{
  {
    init_simple_test("aF_BFu7i_BFu16s");
    static STRUCT_IF_C aF_BFu7i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aF_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aF_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu16s, aF_BFu7i_BFu16s)
//============================================================================



static void Test_aF_BFu7i_BFu17i()
{
  {
    init_simple_test("aF_BFu7i_BFu17i");
    static STRUCT_IF_C aF_BFu7i_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aF_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aF_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu17i, aF_BFu7i_BFu17i)
//============================================================================



static void Test_aF_BFu7i_BFu17ll()
{
  {
    init_simple_test("aF_BFu7i_BFu17ll");
    static STRUCT_IF_C aF_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aF_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aF_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu17ll, aF_BFu7i_BFu17ll)
//============================================================================



static void Test_aF_BFu7i_BFu1c()
{
  {
    init_simple_test("aF_BFu7i_BFu1c");
    static STRUCT_IF_C aF_BFu7i_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu1c, aF_BFu7i_BFu1c)
//============================================================================



static void Test_aF_BFu7i_BFu1i()
{
  {
    init_simple_test("aF_BFu7i_BFu1i");
    static STRUCT_IF_C aF_BFu7i_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu1i, aF_BFu7i_BFu1i)
//============================================================================



static void Test_aF_BFu7i_BFu1ll()
{
  {
    init_simple_test("aF_BFu7i_BFu1ll");
    static STRUCT_IF_C aF_BFu7i_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu1ll, aF_BFu7i_BFu1ll)
//============================================================================



static void Test_aF_BFu7i_BFu1s()
{
  {
    init_simple_test("aF_BFu7i_BFu1s");
    static STRUCT_IF_C aF_BFu7i_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu1s, aF_BFu7i_BFu1s)
//============================================================================



static void Test_aF_BFu7i_BFu31i()
{
  {
    init_simple_test("aF_BFu7i_BFu31i");
    static STRUCT_IF_C aF_BFu7i_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aF_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aF_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu31i, aF_BFu7i_BFu31i)
//============================================================================



static void Test_aF_BFu7i_BFu31ll()
{
  {
    init_simple_test("aF_BFu7i_BFu31ll");
    static STRUCT_IF_C aF_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aF_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aF_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu31ll, aF_BFu7i_BFu31ll)
//============================================================================



static void Test_aF_BFu7i_BFu32i()
{
  {
    init_simple_test("aF_BFu7i_BFu32i");
    static STRUCT_IF_C aF_BFu7i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aF_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aF_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu32i, aF_BFu7i_BFu32i)
//============================================================================



static void Test_aF_BFu7i_BFu32ll()
{
  {
    init_simple_test("aF_BFu7i_BFu32ll");
    static STRUCT_IF_C aF_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aF_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aF_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu32ll, aF_BFu7i_BFu32ll)
//============================================================================



static void Test_aF_BFu7i_BFu33()
{
  {
    init_simple_test("aF_BFu7i_BFu33");
    static STRUCT_IF_C aF_BFu7i_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, 1, "aF_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, hide_ull(1LL<<32), "aF_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu33, aF_BFu7i_BFu33)
//============================================================================



static void Test_aF_BFu7i_BFu7c()
{
  {
    init_simple_test("aF_BFu7i_BFu7c");
    static STRUCT_IF_C aF_BFu7i_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu7c, aF_BFu7i_BFu7c)
//============================================================================



static void Test_aF_BFu7i_BFu7i()
{
  {
    init_simple_test("aF_BFu7i_BFu7i");
    static STRUCT_IF_C aF_BFu7i_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu7i, aF_BFu7i_BFu7i)
//============================================================================



static void Test_aF_BFu7i_BFu7ll()
{
  {
    init_simple_test("aF_BFu7i_BFu7ll");
    static STRUCT_IF_C aF_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu7ll, aF_BFu7i_BFu7ll)
//============================================================================



static void Test_aF_BFu7i_BFu7s()
{
  {
    init_simple_test("aF_BFu7i_BFu7s");
    static STRUCT_IF_C aF_BFu7i_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu7s, aF_BFu7i_BFu7s)
//============================================================================



static void Test_aF_BFu7i_BFu8c()
{
  {
    init_simple_test("aF_BFu7i_BFu8c");
    static STRUCT_IF_C aF_BFu7i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu8c, aF_BFu7i_BFu8c)
//============================================================================



static void Test_aF_BFu7i_BFu8i()
{
  {
    init_simple_test("aF_BFu7i_BFu8i");
    static STRUCT_IF_C aF_BFu7i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu8i, aF_BFu7i_BFu8i)
//============================================================================



static void Test_aF_BFu7i_BFu8ll()
{
  {
    init_simple_test("aF_BFu7i_BFu8ll");
    static STRUCT_IF_C aF_BFu7i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu8ll, aF_BFu7i_BFu8ll)
//============================================================================



static void Test_aF_BFu7i_BFu8s()
{
  {
    init_simple_test("aF_BFu7i_BFu8s");
    static STRUCT_IF_C aF_BFu7i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu8s, aF_BFu7i_BFu8s)
//============================================================================



static void Test_aF_BFu7i_BFu9i()
{
  {
    init_simple_test("aF_BFu7i_BFu9i");
    static STRUCT_IF_C aF_BFu7i_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aF_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aF_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu9i, aF_BFu7i_BFu9i)
//============================================================================



static void Test_aF_BFu7i_BFu9ll()
{
  {
    init_simple_test("aF_BFu7i_BFu9ll");
    static STRUCT_IF_C aF_BFu7i_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aF_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aF_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu9ll, aF_BFu7i_BFu9ll)
//============================================================================



static void Test_aF_BFu7i_BFu9s()
{
  {
    init_simple_test("aF_BFu7i_BFu9s");
    static STRUCT_IF_C aF_BFu7i_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aF_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aF_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_BFu9s, aF_BFu7i_BFu9s)
//============================================================================



static void Test_aF_BFu7i_C()
{
  {
    init_simple_test("aF_BFu7i_C");
    static STRUCT_IF_C aF_BFu7i_C lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_C)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_C");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_C");
    check_field_offset(lv, v3, 5, "aF_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_C, aF_BFu7i_C)
//============================================================================



static void Test_aF_BFu7i_D()
{
  {
    init_simple_test("aF_BFu7i_D");
    static STRUCT_IF_C aF_BFu7i_D lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_D)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_D");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_D");
    check_field_offset(lv, v3, 5, "aF_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_D, aF_BFu7i_D)
//============================================================================



static void Test_aF_BFu7i_F()
{
  {
    init_simple_test("aF_BFu7i_F");
    static STRUCT_IF_C aF_BFu7i_F lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_F)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_F");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_F");
    check_field_offset(lv, v3, 5, "aF_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_F, aF_BFu7i_F)
//============================================================================



static void Test_aF_BFu7i_I()
{
  {
    init_simple_test("aF_BFu7i_I");
    static STRUCT_IF_C aF_BFu7i_I lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_I)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_I");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_I");
    check_field_offset(lv, v3, 5, "aF_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_I, aF_BFu7i_I)
//============================================================================



static void Test_aF_BFu7i_Ip()
{
  {
    init_simple_test("aF_BFu7i_Ip");
    static STRUCT_IF_C aF_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_Ip");
    check_field_offset(lv, v3, 5, "aF_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_Ip, aF_BFu7i_Ip)
//============================================================================



static void Test_aF_BFu7i_L()
{
  {
    init_simple_test("aF_BFu7i_L");
    static STRUCT_IF_C aF_BFu7i_L lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_L)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_L");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_L");
    check_field_offset(lv, v3, 5, "aF_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_L, aF_BFu7i_L)
//============================================================================



static void Test_aF_BFu7i_S()
{
  {
    init_simple_test("aF_BFu7i_S");
    static STRUCT_IF_C aF_BFu7i_S lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_S)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_S");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_S");
    check_field_offset(lv, v3, 5, "aF_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_S, aF_BFu7i_S)
//============================================================================



static void Test_aF_BFu7i_Uc()
{
  {
    init_simple_test("aF_BFu7i_Uc");
    static STRUCT_IF_C aF_BFu7i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_Uc");
    check_field_offset(lv, v3, 5, "aF_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_Uc, aF_BFu7i_Uc)
//============================================================================



static void Test_aF_BFu7i_Ui()
{
  {
    init_simple_test("aF_BFu7i_Ui");
    static STRUCT_IF_C aF_BFu7i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_Ui");
    check_field_offset(lv, v3, 5, "aF_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_Ui, aF_BFu7i_Ui)
//============================================================================



static void Test_aF_BFu7i_Ul()
{
  {
    init_simple_test("aF_BFu7i_Ul");
    static STRUCT_IF_C aF_BFu7i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_Ul");
    check_field_offset(lv, v3, 5, "aF_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_Ul, aF_BFu7i_Ul)
//============================================================================



static void Test_aF_BFu7i_Us()
{
  {
    init_simple_test("aF_BFu7i_Us");
    static STRUCT_IF_C aF_BFu7i_Us lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_Us");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_Us");
    check_field_offset(lv, v3, 5, "aF_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_Us, aF_BFu7i_Us)
//============================================================================



static void Test_aF_BFu7i_Vp()
{
  {
    init_simple_test("aF_BFu7i_Vp");
    static STRUCT_IF_C aF_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7i_Vp");
    check_field_offset(lv, v3, 5, "aF_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7i_Vp, aF_BFu7i_Vp)
//============================================================================



static void Test_aF_BFu7ll()
{
  {
    init_simple_test("aF_BFu7ll");
    static STRUCT_IF_C aF_BFu7ll lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll, aF_BFu7ll)
//============================================================================



static void Test_aF_BFu7ll_BFu15i()
{
  {
    init_simple_test("aF_BFu7ll_BFu15i");
    static STRUCT_IF_C aF_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aF_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aF_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu15i, aF_BFu7ll_BFu15i)
//============================================================================



static void Test_aF_BFu7ll_BFu15ll()
{
  {
    init_simple_test("aF_BFu7ll_BFu15ll");
    static STRUCT_IF_C aF_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aF_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aF_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu15ll, aF_BFu7ll_BFu15ll)
//============================================================================



static void Test_aF_BFu7ll_BFu15s()
{
  {
    init_simple_test("aF_BFu7ll_BFu15s");
    static STRUCT_IF_C aF_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aF_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aF_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu15s, aF_BFu7ll_BFu15s)
//============================================================================



static void Test_aF_BFu7ll_BFu16i()
{
  {
    init_simple_test("aF_BFu7ll_BFu16i");
    static STRUCT_IF_C aF_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aF_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aF_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu16i, aF_BFu7ll_BFu16i)
//============================================================================



static void Test_aF_BFu7ll_BFu16ll()
{
  {
    init_simple_test("aF_BFu7ll_BFu16ll");
    static STRUCT_IF_C aF_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aF_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aF_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu16ll, aF_BFu7ll_BFu16ll)
//============================================================================



static void Test_aF_BFu7ll_BFu16s()
{
  {
    init_simple_test("aF_BFu7ll_BFu16s");
    static STRUCT_IF_C aF_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aF_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aF_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu16s, aF_BFu7ll_BFu16s)
//============================================================================



static void Test_aF_BFu7ll_BFu17i()
{
  {
    init_simple_test("aF_BFu7ll_BFu17i");
    static STRUCT_IF_C aF_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aF_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aF_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu17i, aF_BFu7ll_BFu17i)
//============================================================================



static void Test_aF_BFu7ll_BFu17ll()
{
  {
    init_simple_test("aF_BFu7ll_BFu17ll");
    static STRUCT_IF_C aF_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aF_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aF_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu17ll, aF_BFu7ll_BFu17ll)
//============================================================================



static void Test_aF_BFu7ll_BFu1c()
{
  {
    init_simple_test("aF_BFu7ll_BFu1c");
    static STRUCT_IF_C aF_BFu7ll_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu1c, aF_BFu7ll_BFu1c)
//============================================================================



static void Test_aF_BFu7ll_BFu1i()
{
  {
    init_simple_test("aF_BFu7ll_BFu1i");
    static STRUCT_IF_C aF_BFu7ll_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu1i, aF_BFu7ll_BFu1i)
//============================================================================



static void Test_aF_BFu7ll_BFu1ll()
{
  {
    init_simple_test("aF_BFu7ll_BFu1ll");
    static STRUCT_IF_C aF_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu1ll, aF_BFu7ll_BFu1ll)
//============================================================================



static void Test_aF_BFu7ll_BFu1s()
{
  {
    init_simple_test("aF_BFu7ll_BFu1s");
    static STRUCT_IF_C aF_BFu7ll_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu1s, aF_BFu7ll_BFu1s)
//============================================================================



static void Test_aF_BFu7ll_BFu31i()
{
  {
    init_simple_test("aF_BFu7ll_BFu31i");
    static STRUCT_IF_C aF_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aF_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aF_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu31i, aF_BFu7ll_BFu31i)
//============================================================================



static void Test_aF_BFu7ll_BFu31ll()
{
  {
    init_simple_test("aF_BFu7ll_BFu31ll");
    static STRUCT_IF_C aF_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aF_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aF_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu31ll, aF_BFu7ll_BFu31ll)
//============================================================================



static void Test_aF_BFu7ll_BFu32i()
{
  {
    init_simple_test("aF_BFu7ll_BFu32i");
    static STRUCT_IF_C aF_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aF_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aF_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu32i, aF_BFu7ll_BFu32i)
//============================================================================



static void Test_aF_BFu7ll_BFu32ll()
{
  {
    init_simple_test("aF_BFu7ll_BFu32ll");
    static STRUCT_IF_C aF_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aF_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aF_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu32ll, aF_BFu7ll_BFu32ll)
//============================================================================



static void Test_aF_BFu7ll_BFu33()
{
  {
    init_simple_test("aF_BFu7ll_BFu33");
    static STRUCT_IF_C aF_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, 1, "aF_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, hide_ull(1LL<<32), "aF_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu33, aF_BFu7ll_BFu33)
//============================================================================



static void Test_aF_BFu7ll_BFu7c()
{
  {
    init_simple_test("aF_BFu7ll_BFu7c");
    static STRUCT_IF_C aF_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu7c, aF_BFu7ll_BFu7c)
//============================================================================



static void Test_aF_BFu7ll_BFu7i()
{
  {
    init_simple_test("aF_BFu7ll_BFu7i");
    static STRUCT_IF_C aF_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu7i, aF_BFu7ll_BFu7i)
//============================================================================



static void Test_aF_BFu7ll_BFu7ll()
{
  {
    init_simple_test("aF_BFu7ll_BFu7ll");
    static STRUCT_IF_C aF_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu7ll, aF_BFu7ll_BFu7ll)
//============================================================================



static void Test_aF_BFu7ll_BFu7s()
{
  {
    init_simple_test("aF_BFu7ll_BFu7s");
    static STRUCT_IF_C aF_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu7s, aF_BFu7ll_BFu7s)
//============================================================================



static void Test_aF_BFu7ll_BFu8c()
{
  {
    init_simple_test("aF_BFu7ll_BFu8c");
    static STRUCT_IF_C aF_BFu7ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu8c, aF_BFu7ll_BFu8c)
//============================================================================



static void Test_aF_BFu7ll_BFu8i()
{
  {
    init_simple_test("aF_BFu7ll_BFu8i");
    static STRUCT_IF_C aF_BFu7ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu8i, aF_BFu7ll_BFu8i)
//============================================================================



static void Test_aF_BFu7ll_BFu8ll()
{
  {
    init_simple_test("aF_BFu7ll_BFu8ll");
    static STRUCT_IF_C aF_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu8ll, aF_BFu7ll_BFu8ll)
//============================================================================



static void Test_aF_BFu7ll_BFu8s()
{
  {
    init_simple_test("aF_BFu7ll_BFu8s");
    static STRUCT_IF_C aF_BFu7ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu8s, aF_BFu7ll_BFu8s)
//============================================================================



static void Test_aF_BFu7ll_BFu9i()
{
  {
    init_simple_test("aF_BFu7ll_BFu9i");
    static STRUCT_IF_C aF_BFu7ll_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aF_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aF_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu9i, aF_BFu7ll_BFu9i)
//============================================================================



static void Test_aF_BFu7ll_BFu9ll()
{
  {
    init_simple_test("aF_BFu7ll_BFu9ll");
    static STRUCT_IF_C aF_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aF_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aF_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu9ll, aF_BFu7ll_BFu9ll)
//============================================================================



static void Test_aF_BFu7ll_BFu9s()
{
  {
    init_simple_test("aF_BFu7ll_BFu9s");
    static STRUCT_IF_C aF_BFu7ll_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aF_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aF_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_BFu9s, aF_BFu7ll_BFu9s)
//============================================================================



static void Test_aF_BFu7ll_C()
{
  {
    init_simple_test("aF_BFu7ll_C");
    static STRUCT_IF_C aF_BFu7ll_C lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_C");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_C");
    check_field_offset(lv, v3, 5, "aF_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_C, aF_BFu7ll_C)
//============================================================================



static void Test_aF_BFu7ll_D()
{
  {
    init_simple_test("aF_BFu7ll_D");
    static STRUCT_IF_C aF_BFu7ll_D lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_D");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_D");
    check_field_offset(lv, v3, 5, "aF_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_D, aF_BFu7ll_D)
//============================================================================



static void Test_aF_BFu7ll_F()
{
  {
    init_simple_test("aF_BFu7ll_F");
    static STRUCT_IF_C aF_BFu7ll_F lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_F");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_F");
    check_field_offset(lv, v3, 5, "aF_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_F, aF_BFu7ll_F)
//============================================================================



static void Test_aF_BFu7ll_I()
{
  {
    init_simple_test("aF_BFu7ll_I");
    static STRUCT_IF_C aF_BFu7ll_I lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_I");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_I");
    check_field_offset(lv, v3, 5, "aF_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_I, aF_BFu7ll_I)
//============================================================================



static void Test_aF_BFu7ll_Ip()
{
  {
    init_simple_test("aF_BFu7ll_Ip");
    static STRUCT_IF_C aF_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_Ip");
    check_field_offset(lv, v3, 5, "aF_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_Ip, aF_BFu7ll_Ip)
//============================================================================



static void Test_aF_BFu7ll_L()
{
  {
    init_simple_test("aF_BFu7ll_L");
    static STRUCT_IF_C aF_BFu7ll_L lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_L");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_L");
    check_field_offset(lv, v3, 5, "aF_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_L, aF_BFu7ll_L)
//============================================================================



static void Test_aF_BFu7ll_S()
{
  {
    init_simple_test("aF_BFu7ll_S");
    static STRUCT_IF_C aF_BFu7ll_S lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_S");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_S");
    check_field_offset(lv, v3, 5, "aF_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_S, aF_BFu7ll_S)
//============================================================================



static void Test_aF_BFu7ll_Uc()
{
  {
    init_simple_test("aF_BFu7ll_Uc");
    static STRUCT_IF_C aF_BFu7ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_Uc");
    check_field_offset(lv, v3, 5, "aF_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_Uc, aF_BFu7ll_Uc)
//============================================================================



static void Test_aF_BFu7ll_Ui()
{
  {
    init_simple_test("aF_BFu7ll_Ui");
    static STRUCT_IF_C aF_BFu7ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_Ui");
    check_field_offset(lv, v3, 5, "aF_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_Ui, aF_BFu7ll_Ui)
//============================================================================



static void Test_aF_BFu7ll_Ul()
{
  {
    init_simple_test("aF_BFu7ll_Ul");
    static STRUCT_IF_C aF_BFu7ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_Ul");
    check_field_offset(lv, v3, 5, "aF_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_Ul, aF_BFu7ll_Ul)
//============================================================================



static void Test_aF_BFu7ll_Us()
{
  {
    init_simple_test("aF_BFu7ll_Us");
    static STRUCT_IF_C aF_BFu7ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_Us");
    check_field_offset(lv, v3, 5, "aF_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_Us, aF_BFu7ll_Us)
//============================================================================



static void Test_aF_BFu7ll_Vp()
{
  {
    init_simple_test("aF_BFu7ll_Vp");
    static STRUCT_IF_C aF_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7ll_Vp");
    check_field_offset(lv, v3, 5, "aF_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7ll_Vp, aF_BFu7ll_Vp)
//============================================================================



static void Test_aF_BFu7s()
{
  {
    init_simple_test("aF_BFu7s");
    static STRUCT_IF_C aF_BFu7s lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s, aF_BFu7s)
//============================================================================



static void Test_aF_BFu7s_BFu15i()
{
  {
    init_simple_test("aF_BFu7s_BFu15i");
    static STRUCT_IF_C aF_BFu7s_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aF_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aF_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu15i, aF_BFu7s_BFu15i)
//============================================================================



static void Test_aF_BFu7s_BFu15ll()
{
  {
    init_simple_test("aF_BFu7s_BFu15ll");
    static STRUCT_IF_C aF_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aF_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aF_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu15ll, aF_BFu7s_BFu15ll)
//============================================================================



static void Test_aF_BFu7s_BFu15s()
{
  {
    init_simple_test("aF_BFu7s_BFu15s");
    static STRUCT_IF_C aF_BFu7s_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, 1, "aF_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 4, 7, 15, hide_ull(1LL<<14), "aF_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu15s, aF_BFu7s_BFu15s)
//============================================================================



static void Test_aF_BFu7s_BFu16i()
{
  {
    init_simple_test("aF_BFu7s_BFu16i");
    static STRUCT_IF_C aF_BFu7s_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aF_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aF_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu16i, aF_BFu7s_BFu16i)
//============================================================================



static void Test_aF_BFu7s_BFu16ll()
{
  {
    init_simple_test("aF_BFu7s_BFu16ll");
    static STRUCT_IF_C aF_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aF_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aF_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu16ll, aF_BFu7s_BFu16ll)
//============================================================================



static void Test_aF_BFu7s_BFu16s()
{
  {
    init_simple_test("aF_BFu7s_BFu16s");
    static STRUCT_IF_C aF_BFu7s_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, 1, "aF_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 4, 7, 16, hide_ull(1LL<<15), "aF_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu16s, aF_BFu7s_BFu16s)
//============================================================================



static void Test_aF_BFu7s_BFu17i()
{
  {
    init_simple_test("aF_BFu7s_BFu17i");
    static STRUCT_IF_C aF_BFu7s_BFu17i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aF_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aF_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu17i, aF_BFu7s_BFu17i)
//============================================================================



static void Test_aF_BFu7s_BFu17ll()
{
  {
    init_simple_test("aF_BFu7s_BFu17ll");
    static STRUCT_IF_C aF_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, 1, "aF_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 7, 17, hide_ull(1LL<<16), "aF_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu17ll, aF_BFu7s_BFu17ll)
//============================================================================



static void Test_aF_BFu7s_BFu1c()
{
  {
    init_simple_test("aF_BFu7s_BFu1c");
    static STRUCT_IF_C aF_BFu7s_BFu1c lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu1c, aF_BFu7s_BFu1c)
//============================================================================



static void Test_aF_BFu7s_BFu1i()
{
  {
    init_simple_test("aF_BFu7s_BFu1i");
    static STRUCT_IF_C aF_BFu7s_BFu1i lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu1i, aF_BFu7s_BFu1i)
//============================================================================



static void Test_aF_BFu7s_BFu1ll()
{
  {
    init_simple_test("aF_BFu7s_BFu1ll");
    static STRUCT_IF_C aF_BFu7s_BFu1ll lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu1ll, aF_BFu7s_BFu1ll)
//============================================================================



static void Test_aF_BFu7s_BFu1s()
{
  {
    init_simple_test("aF_BFu7s_BFu1s");
    static STRUCT_IF_C aF_BFu7s_BFu1s lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 4, 7, 1, 1, "aF_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu1s, aF_BFu7s_BFu1s)
//============================================================================



static void Test_aF_BFu7s_BFu31i()
{
  {
    init_simple_test("aF_BFu7s_BFu31i");
    static STRUCT_IF_C aF_BFu7s_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aF_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aF_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu31i, aF_BFu7s_BFu31i)
//============================================================================



static void Test_aF_BFu7s_BFu31ll()
{
  {
    init_simple_test("aF_BFu7s_BFu31ll");
    static STRUCT_IF_C aF_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, 1, "aF_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 7, 31, hide_ull(1LL<<30), "aF_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu31ll, aF_BFu7s_BFu31ll)
//============================================================================



static void Test_aF_BFu7s_BFu32i()
{
  {
    init_simple_test("aF_BFu7s_BFu32i");
    static STRUCT_IF_C aF_BFu7s_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aF_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aF_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu32i, aF_BFu7s_BFu32i)
//============================================================================



static void Test_aF_BFu7s_BFu32ll()
{
  {
    init_simple_test("aF_BFu7s_BFu32ll");
    static STRUCT_IF_C aF_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, 1, "aF_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 7, 32, hide_ull(1LL<<31), "aF_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu32ll, aF_BFu7s_BFu32ll)
//============================================================================



static void Test_aF_BFu7s_BFu33()
{
  {
    init_simple_test("aF_BFu7s_BFu33");
    static STRUCT_IF_C aF_BFu7s_BFu33 lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, 1, "aF_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 4, 7, 33, hide_ull(1LL<<32), "aF_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu33, aF_BFu7s_BFu33)
//============================================================================



static void Test_aF_BFu7s_BFu7c()
{
  {
    init_simple_test("aF_BFu7s_BFu7c");
    static STRUCT_IF_C aF_BFu7s_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu7c, aF_BFu7s_BFu7c)
//============================================================================



static void Test_aF_BFu7s_BFu7i()
{
  {
    init_simple_test("aF_BFu7s_BFu7i");
    static STRUCT_IF_C aF_BFu7s_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu7i, aF_BFu7s_BFu7i)
//============================================================================



static void Test_aF_BFu7s_BFu7ll()
{
  {
    init_simple_test("aF_BFu7s_BFu7ll");
    static STRUCT_IF_C aF_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu7ll, aF_BFu7s_BFu7ll)
//============================================================================



static void Test_aF_BFu7s_BFu7s()
{
  {
    init_simple_test("aF_BFu7s_BFu7s");
    static STRUCT_IF_C aF_BFu7s_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, 1, "aF_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 4, 7, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu7s, aF_BFu7s_BFu7s)
//============================================================================



static void Test_aF_BFu7s_BFu8c()
{
  {
    init_simple_test("aF_BFu7s_BFu8c");
    static STRUCT_IF_C aF_BFu7s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu8c, aF_BFu7s_BFu8c)
//============================================================================



static void Test_aF_BFu7s_BFu8i()
{
  {
    init_simple_test("aF_BFu7s_BFu8i");
    static STRUCT_IF_C aF_BFu7s_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu8i, aF_BFu7s_BFu8i)
//============================================================================



static void Test_aF_BFu7s_BFu8ll()
{
  {
    init_simple_test("aF_BFu7s_BFu8ll");
    static STRUCT_IF_C aF_BFu7s_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu8ll, aF_BFu7s_BFu8ll)
//============================================================================



static void Test_aF_BFu7s_BFu8s()
{
  {
    init_simple_test("aF_BFu7s_BFu8s");
    static STRUCT_IF_C aF_BFu7s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, 1, "aF_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 4, 7, 8, hide_ull(1LL<<7), "aF_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu8s, aF_BFu7s_BFu8s)
//============================================================================



static void Test_aF_BFu7s_BFu9i()
{
  {
    init_simple_test("aF_BFu7s_BFu9i");
    static STRUCT_IF_C aF_BFu7s_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aF_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aF_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu9i, aF_BFu7s_BFu9i)
//============================================================================



static void Test_aF_BFu7s_BFu9ll()
{
  {
    init_simple_test("aF_BFu7s_BFu9ll");
    static STRUCT_IF_C aF_BFu7s_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aF_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aF_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu9ll, aF_BFu7s_BFu9ll)
//============================================================================



static void Test_aF_BFu7s_BFu9s()
{
  {
    init_simple_test("aF_BFu7s_BFu9s");
    static STRUCT_IF_C aF_BFu7s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, 1, "aF_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 4, 7, 9, hide_ull(1LL<<8), "aF_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_BFu9s, aF_BFu7s_BFu9s)
//============================================================================



static void Test_aF_BFu7s_C()
{
  {
    init_simple_test("aF_BFu7s_C");
    static STRUCT_IF_C aF_BFu7s_C lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_C)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_C");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_C");
    check_field_offset(lv, v3, 5, "aF_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_C, aF_BFu7s_C)
//============================================================================



static void Test_aF_BFu7s_D()
{
  {
    init_simple_test("aF_BFu7s_D");
    static STRUCT_IF_C aF_BFu7s_D lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_D)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_D");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_D");
    check_field_offset(lv, v3, 5, "aF_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_D, aF_BFu7s_D)
//============================================================================



static void Test_aF_BFu7s_F()
{
  {
    init_simple_test("aF_BFu7s_F");
    static STRUCT_IF_C aF_BFu7s_F lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_F)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_F");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_F");
    check_field_offset(lv, v3, 5, "aF_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_F, aF_BFu7s_F)
//============================================================================



static void Test_aF_BFu7s_I()
{
  {
    init_simple_test("aF_BFu7s_I");
    static STRUCT_IF_C aF_BFu7s_I lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_I)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_I");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_I");
    check_field_offset(lv, v3, 5, "aF_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_I, aF_BFu7s_I)
//============================================================================



static void Test_aF_BFu7s_Ip()
{
  {
    init_simple_test("aF_BFu7s_Ip");
    static STRUCT_IF_C aF_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_Ip");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_Ip");
    check_field_offset(lv, v3, 5, "aF_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_Ip, aF_BFu7s_Ip)
//============================================================================



static void Test_aF_BFu7s_L()
{
  {
    init_simple_test("aF_BFu7s_L");
    static STRUCT_IF_C aF_BFu7s_L lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu7s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_L)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_L");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_L");
    check_field_offset(lv, v3, 5, "aF_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_L, aF_BFu7s_L)
//============================================================================



static void Test_aF_BFu7s_S()
{
  {
    init_simple_test("aF_BFu7s_S");
    static STRUCT_IF_C aF_BFu7s_S lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_S)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_S");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_S");
    check_field_offset(lv, v3, 5, "aF_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_S, aF_BFu7s_S)
//============================================================================



static void Test_aF_BFu7s_Uc()
{
  {
    init_simple_test("aF_BFu7s_Uc");
    static STRUCT_IF_C aF_BFu7s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu7s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_Uc");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_Uc");
    check_field_offset(lv, v3, 5, "aF_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_Uc, aF_BFu7s_Uc)
//============================================================================



static void Test_aF_BFu7s_Ui()
{
  {
    init_simple_test("aF_BFu7s_Ui");
    static STRUCT_IF_C aF_BFu7s_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu7s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_Ui");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_Ui");
    check_field_offset(lv, v3, 5, "aF_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_Ui, aF_BFu7s_Ui)
//============================================================================



static void Test_aF_BFu7s_Ul()
{
  {
    init_simple_test("aF_BFu7s_Ul");
    static STRUCT_IF_C aF_BFu7s_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu7s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_Ul");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_Ul");
    check_field_offset(lv, v3, 5, "aF_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_Ul, aF_BFu7s_Ul)
//============================================================================



static void Test_aF_BFu7s_Us()
{
  {
    init_simple_test("aF_BFu7s_Us");
    static STRUCT_IF_C aF_BFu7s_Us lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu7s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_Us");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_Us");
    check_field_offset(lv, v3, 5, "aF_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_Us, aF_BFu7s_Us)
//============================================================================



static void Test_aF_BFu7s_Vp()
{
  {
    init_simple_test("aF_BFu7s_Vp");
    static STRUCT_IF_C aF_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu7s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 7, 1, "aF_BFu7s_Vp");
    set_bf_and_test(lv, v2, 4, 0, 7, hide_ull(1LL<<6), "aF_BFu7s_Vp");
    check_field_offset(lv, v3, 5, "aF_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu7s_Vp, aF_BFu7s_Vp)
//============================================================================



static void Test_aF_BFu8c()
{
  {
    init_simple_test("aF_BFu8c");
    static STRUCT_IF_C aF_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c, aF_BFu8c)
//============================================================================



static void Test_aF_BFu8c_BFu15i()
{
  {
    init_simple_test("aF_BFu8c_BFu15i");
    static STRUCT_IF_C aF_BFu8c_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu15i, aF_BFu8c_BFu15i)
//============================================================================



static void Test_aF_BFu8c_BFu15ll()
{
  {
    init_simple_test("aF_BFu8c_BFu15ll");
    static STRUCT_IF_C aF_BFu8c_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu15ll, aF_BFu8c_BFu15ll)
//============================================================================



static void Test_aF_BFu8c_BFu15s()
{
  {
    init_simple_test("aF_BFu8c_BFu15s");
    static STRUCT_IF_C aF_BFu8c_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu15s, aF_BFu8c_BFu15s)
//============================================================================



static void Test_aF_BFu8c_BFu16i()
{
  {
    init_simple_test("aF_BFu8c_BFu16i");
    static STRUCT_IF_C aF_BFu8c_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu16i, aF_BFu8c_BFu16i)
//============================================================================



static void Test_aF_BFu8c_BFu16ll()
{
  {
    init_simple_test("aF_BFu8c_BFu16ll");
    static STRUCT_IF_C aF_BFu8c_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu16ll, aF_BFu8c_BFu16ll)
//============================================================================



static void Test_aF_BFu8c_BFu16s()
{
  {
    init_simple_test("aF_BFu8c_BFu16s");
    static STRUCT_IF_C aF_BFu8c_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu16s, aF_BFu8c_BFu16s)
//============================================================================



static void Test_aF_BFu8c_BFu17i()
{
  {
    init_simple_test("aF_BFu8c_BFu17i");
    static STRUCT_IF_C aF_BFu8c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu8c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aF_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aF_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu17i, aF_BFu8c_BFu17i)
//============================================================================



static void Test_aF_BFu8c_BFu17ll()
{
  {
    init_simple_test("aF_BFu8c_BFu17ll");
    static STRUCT_IF_C aF_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu8c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aF_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aF_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu17ll, aF_BFu8c_BFu17ll)
//============================================================================



static void Test_aF_BFu8c_BFu1c()
{
  {
    init_simple_test("aF_BFu8c_BFu1c");
    static STRUCT_IF_C aF_BFu8c_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu1c, aF_BFu8c_BFu1c)
//============================================================================



static void Test_aF_BFu8c_BFu1i()
{
  {
    init_simple_test("aF_BFu8c_BFu1i");
    static STRUCT_IF_C aF_BFu8c_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu1i, aF_BFu8c_BFu1i)
//============================================================================



static void Test_aF_BFu8c_BFu1ll()
{
  {
    init_simple_test("aF_BFu8c_BFu1ll");
    static STRUCT_IF_C aF_BFu8c_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu1ll, aF_BFu8c_BFu1ll)
//============================================================================



static void Test_aF_BFu8c_BFu1s()
{
  {
    init_simple_test("aF_BFu8c_BFu1s");
    static STRUCT_IF_C aF_BFu8c_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu1s, aF_BFu8c_BFu1s)
//============================================================================



static void Test_aF_BFu8c_BFu31i()
{
  {
    init_simple_test("aF_BFu8c_BFu31i");
    static STRUCT_IF_C aF_BFu8c_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aF_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aF_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu31i, aF_BFu8c_BFu31i)
//============================================================================



static void Test_aF_BFu8c_BFu31ll()
{
  {
    init_simple_test("aF_BFu8c_BFu31ll");
    static STRUCT_IF_C aF_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aF_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aF_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu31ll, aF_BFu8c_BFu31ll)
//============================================================================



static void Test_aF_BFu8c_BFu32i()
{
  {
    init_simple_test("aF_BFu8c_BFu32i");
    static STRUCT_IF_C aF_BFu8c_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aF_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aF_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu32i, aF_BFu8c_BFu32i)
//============================================================================



static void Test_aF_BFu8c_BFu32ll()
{
  {
    init_simple_test("aF_BFu8c_BFu32ll");
    static STRUCT_IF_C aF_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aF_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aF_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu32ll, aF_BFu8c_BFu32ll)
//============================================================================



static void Test_aF_BFu8c_BFu33()
{
  {
    init_simple_test("aF_BFu8c_BFu33");
    static STRUCT_IF_C aF_BFu8c_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aF_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aF_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu33, aF_BFu8c_BFu33)
//============================================================================



static void Test_aF_BFu8c_BFu7c()
{
  {
    init_simple_test("aF_BFu8c_BFu7c");
    static STRUCT_IF_C aF_BFu8c_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu7c, aF_BFu8c_BFu7c)
//============================================================================



static void Test_aF_BFu8c_BFu7i()
{
  {
    init_simple_test("aF_BFu8c_BFu7i");
    static STRUCT_IF_C aF_BFu8c_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu7i, aF_BFu8c_BFu7i)
//============================================================================



static void Test_aF_BFu8c_BFu7ll()
{
  {
    init_simple_test("aF_BFu8c_BFu7ll");
    static STRUCT_IF_C aF_BFu8c_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu7ll, aF_BFu8c_BFu7ll)
//============================================================================



static void Test_aF_BFu8c_BFu7s()
{
  {
    init_simple_test("aF_BFu8c_BFu7s");
    static STRUCT_IF_C aF_BFu8c_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu7s, aF_BFu8c_BFu7s)
//============================================================================



static void Test_aF_BFu8c_BFu8c()
{
  {
    init_simple_test("aF_BFu8c_BFu8c");
    static STRUCT_IF_C aF_BFu8c_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu8c, aF_BFu8c_BFu8c)
//============================================================================



static void Test_aF_BFu8c_BFu8i()
{
  {
    init_simple_test("aF_BFu8c_BFu8i");
    static STRUCT_IF_C aF_BFu8c_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu8i, aF_BFu8c_BFu8i)
//============================================================================



static void Test_aF_BFu8c_BFu8ll()
{
  {
    init_simple_test("aF_BFu8c_BFu8ll");
    static STRUCT_IF_C aF_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu8ll, aF_BFu8c_BFu8ll)
//============================================================================



static void Test_aF_BFu8c_BFu8s()
{
  {
    init_simple_test("aF_BFu8c_BFu8s");
    static STRUCT_IF_C aF_BFu8c_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu8s, aF_BFu8c_BFu8s)
//============================================================================



static void Test_aF_BFu8c_BFu9i()
{
  {
    init_simple_test("aF_BFu8c_BFu9i");
    static STRUCT_IF_C aF_BFu8c_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu9i, aF_BFu8c_BFu9i)
//============================================================================



static void Test_aF_BFu8c_BFu9ll()
{
  {
    init_simple_test("aF_BFu8c_BFu9ll");
    static STRUCT_IF_C aF_BFu8c_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu9ll, aF_BFu8c_BFu9ll)
//============================================================================



static void Test_aF_BFu8c_BFu9s()
{
  {
    init_simple_test("aF_BFu8c_BFu9s");
    static STRUCT_IF_C aF_BFu8c_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_BFu9s, aF_BFu8c_BFu9s)
//============================================================================



static void Test_aF_BFu8c_C()
{
  {
    init_simple_test("aF_BFu8c_C");
    static STRUCT_IF_C aF_BFu8c_C lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_C)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_C");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_C");
    check_field_offset(lv, v3, 5, "aF_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_C, aF_BFu8c_C)
//============================================================================



static void Test_aF_BFu8c_D()
{
  {
    init_simple_test("aF_BFu8c_D");
    static STRUCT_IF_C aF_BFu8c_D lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu8c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_D)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_D");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_D");
    check_field_offset(lv, v3, 5, "aF_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_D, aF_BFu8c_D)
//============================================================================



static void Test_aF_BFu8c_F()
{
  {
    init_simple_test("aF_BFu8c_F");
    static STRUCT_IF_C aF_BFu8c_F lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_F)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_F");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_F");
    check_field_offset(lv, v3, 5, "aF_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_F, aF_BFu8c_F)
//============================================================================



static void Test_aF_BFu8c_I()
{
  {
    init_simple_test("aF_BFu8c_I");
    static STRUCT_IF_C aF_BFu8c_I lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_I)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_I");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_I");
    check_field_offset(lv, v3, 5, "aF_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_I, aF_BFu8c_I)
//============================================================================



static void Test_aF_BFu8c_Ip()
{
  {
    init_simple_test("aF_BFu8c_Ip");
    static STRUCT_IF_C aF_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu8c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_Ip");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_Ip");
    check_field_offset(lv, v3, 5, "aF_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_Ip, aF_BFu8c_Ip)
//============================================================================



static void Test_aF_BFu8c_L()
{
  {
    init_simple_test("aF_BFu8c_L");
    static STRUCT_IF_C aF_BFu8c_L lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu8c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_L)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_L");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_L");
    check_field_offset(lv, v3, 5, "aF_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_L, aF_BFu8c_L)
//============================================================================



static void Test_aF_BFu8c_S()
{
  {
    init_simple_test("aF_BFu8c_S");
    static STRUCT_IF_C aF_BFu8c_S lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_S)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_S");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_S");
    check_field_offset(lv, v3, 5, "aF_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_S, aF_BFu8c_S)
//============================================================================



static void Test_aF_BFu8c_Uc()
{
  {
    init_simple_test("aF_BFu8c_Uc");
    static STRUCT_IF_C aF_BFu8c_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_Uc");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_Uc");
    check_field_offset(lv, v3, 5, "aF_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_Uc, aF_BFu8c_Uc)
//============================================================================



static void Test_aF_BFu8c_Ui()
{
  {
    init_simple_test("aF_BFu8c_Ui");
    static STRUCT_IF_C aF_BFu8c_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_Ui");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_Ui");
    check_field_offset(lv, v3, 5, "aF_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_Ui, aF_BFu8c_Ui)
//============================================================================



static void Test_aF_BFu8c_Ul()
{
  {
    init_simple_test("aF_BFu8c_Ul");
    static STRUCT_IF_C aF_BFu8c_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu8c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_Ul");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_Ul");
    check_field_offset(lv, v3, 5, "aF_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_Ul, aF_BFu8c_Ul)
//============================================================================



static void Test_aF_BFu8c_Us()
{
  {
    init_simple_test("aF_BFu8c_Us");
    static STRUCT_IF_C aF_BFu8c_Us lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_Us");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_Us");
    check_field_offset(lv, v3, 5, "aF_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_Us, aF_BFu8c_Us)
//============================================================================



static void Test_aF_BFu8c_Vp()
{
  {
    init_simple_test("aF_BFu8c_Vp");
    static STRUCT_IF_C aF_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu8c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8c_Vp");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8c_Vp");
    check_field_offset(lv, v3, 5, "aF_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8c_Vp, aF_BFu8c_Vp)
//============================================================================



static void Test_aF_BFu8i()
{
  {
    init_simple_test("aF_BFu8i");
    static STRUCT_IF_C aF_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i, aF_BFu8i)
//============================================================================



static void Test_aF_BFu8i_BFu15i()
{
  {
    init_simple_test("aF_BFu8i_BFu15i");
    static STRUCT_IF_C aF_BFu8i_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu15i, aF_BFu8i_BFu15i)
//============================================================================



static void Test_aF_BFu8i_BFu15ll()
{
  {
    init_simple_test("aF_BFu8i_BFu15ll");
    static STRUCT_IF_C aF_BFu8i_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu15ll, aF_BFu8i_BFu15ll)
//============================================================================



static void Test_aF_BFu8i_BFu15s()
{
  {
    init_simple_test("aF_BFu8i_BFu15s");
    static STRUCT_IF_C aF_BFu8i_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu15s, aF_BFu8i_BFu15s)
//============================================================================



static void Test_aF_BFu8i_BFu16i()
{
  {
    init_simple_test("aF_BFu8i_BFu16i");
    static STRUCT_IF_C aF_BFu8i_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu16i, aF_BFu8i_BFu16i)
//============================================================================



static void Test_aF_BFu8i_BFu16ll()
{
  {
    init_simple_test("aF_BFu8i_BFu16ll");
    static STRUCT_IF_C aF_BFu8i_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu16ll, aF_BFu8i_BFu16ll)
//============================================================================



static void Test_aF_BFu8i_BFu16s()
{
  {
    init_simple_test("aF_BFu8i_BFu16s");
    static STRUCT_IF_C aF_BFu8i_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu16s, aF_BFu8i_BFu16s)
//============================================================================



static void Test_aF_BFu8i_BFu17i()
{
  {
    init_simple_test("aF_BFu8i_BFu17i");
    static STRUCT_IF_C aF_BFu8i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu8i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aF_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aF_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu17i, aF_BFu8i_BFu17i)
//============================================================================



static void Test_aF_BFu8i_BFu17ll()
{
  {
    init_simple_test("aF_BFu8i_BFu17ll");
    static STRUCT_IF_C aF_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu8i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aF_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aF_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu17ll, aF_BFu8i_BFu17ll)
//============================================================================



static void Test_aF_BFu8i_BFu1c()
{
  {
    init_simple_test("aF_BFu8i_BFu1c");
    static STRUCT_IF_C aF_BFu8i_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu1c, aF_BFu8i_BFu1c)
//============================================================================



static void Test_aF_BFu8i_BFu1i()
{
  {
    init_simple_test("aF_BFu8i_BFu1i");
    static STRUCT_IF_C aF_BFu8i_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu1i, aF_BFu8i_BFu1i)
//============================================================================



static void Test_aF_BFu8i_BFu1ll()
{
  {
    init_simple_test("aF_BFu8i_BFu1ll");
    static STRUCT_IF_C aF_BFu8i_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu1ll, aF_BFu8i_BFu1ll)
//============================================================================



static void Test_aF_BFu8i_BFu1s()
{
  {
    init_simple_test("aF_BFu8i_BFu1s");
    static STRUCT_IF_C aF_BFu8i_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu1s, aF_BFu8i_BFu1s)
//============================================================================



static void Test_aF_BFu8i_BFu31i()
{
  {
    init_simple_test("aF_BFu8i_BFu31i");
    static STRUCT_IF_C aF_BFu8i_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aF_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aF_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu31i, aF_BFu8i_BFu31i)
//============================================================================



static void Test_aF_BFu8i_BFu31ll()
{
  {
    init_simple_test("aF_BFu8i_BFu31ll");
    static STRUCT_IF_C aF_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aF_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aF_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu31ll, aF_BFu8i_BFu31ll)
//============================================================================



static void Test_aF_BFu8i_BFu32i()
{
  {
    init_simple_test("aF_BFu8i_BFu32i");
    static STRUCT_IF_C aF_BFu8i_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aF_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aF_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu32i, aF_BFu8i_BFu32i)
//============================================================================



static void Test_aF_BFu8i_BFu32ll()
{
  {
    init_simple_test("aF_BFu8i_BFu32ll");
    static STRUCT_IF_C aF_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aF_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aF_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu32ll, aF_BFu8i_BFu32ll)
//============================================================================



static void Test_aF_BFu8i_BFu33()
{
  {
    init_simple_test("aF_BFu8i_BFu33");
    static STRUCT_IF_C aF_BFu8i_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu8i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aF_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aF_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu33, aF_BFu8i_BFu33)
//============================================================================



static void Test_aF_BFu8i_BFu7c()
{
  {
    init_simple_test("aF_BFu8i_BFu7c");
    static STRUCT_IF_C aF_BFu8i_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu7c, aF_BFu8i_BFu7c)
//============================================================================



static void Test_aF_BFu8i_BFu7i()
{
  {
    init_simple_test("aF_BFu8i_BFu7i");
    static STRUCT_IF_C aF_BFu8i_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu7i, aF_BFu8i_BFu7i)
//============================================================================



static void Test_aF_BFu8i_BFu7ll()
{
  {
    init_simple_test("aF_BFu8i_BFu7ll");
    static STRUCT_IF_C aF_BFu8i_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu7ll, aF_BFu8i_BFu7ll)
//============================================================================



static void Test_aF_BFu8i_BFu7s()
{
  {
    init_simple_test("aF_BFu8i_BFu7s");
    static STRUCT_IF_C aF_BFu8i_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu7s, aF_BFu8i_BFu7s)
//============================================================================



static void Test_aF_BFu8i_BFu8c()
{
  {
    init_simple_test("aF_BFu8i_BFu8c");
    static STRUCT_IF_C aF_BFu8i_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu8c, aF_BFu8i_BFu8c)
//============================================================================



static void Test_aF_BFu8i_BFu8i()
{
  {
    init_simple_test("aF_BFu8i_BFu8i");
    static STRUCT_IF_C aF_BFu8i_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu8i, aF_BFu8i_BFu8i)
//============================================================================



static void Test_aF_BFu8i_BFu8ll()
{
  {
    init_simple_test("aF_BFu8i_BFu8ll");
    static STRUCT_IF_C aF_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu8ll, aF_BFu8i_BFu8ll)
//============================================================================



static void Test_aF_BFu8i_BFu8s()
{
  {
    init_simple_test("aF_BFu8i_BFu8s");
    static STRUCT_IF_C aF_BFu8i_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu8s, aF_BFu8i_BFu8s)
//============================================================================



static void Test_aF_BFu8i_BFu9i()
{
  {
    init_simple_test("aF_BFu8i_BFu9i");
    static STRUCT_IF_C aF_BFu8i_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu9i, aF_BFu8i_BFu9i)
//============================================================================



static void Test_aF_BFu8i_BFu9ll()
{
  {
    init_simple_test("aF_BFu8i_BFu9ll");
    static STRUCT_IF_C aF_BFu8i_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu9ll, aF_BFu8i_BFu9ll)
//============================================================================



static void Test_aF_BFu8i_BFu9s()
{
  {
    init_simple_test("aF_BFu8i_BFu9s");
    static STRUCT_IF_C aF_BFu8i_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_BFu9s, aF_BFu8i_BFu9s)
//============================================================================



static void Test_aF_BFu8i_C()
{
  {
    init_simple_test("aF_BFu8i_C");
    static STRUCT_IF_C aF_BFu8i_C lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_C)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_C");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_C");
    check_field_offset(lv, v3, 5, "aF_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_C, aF_BFu8i_C)
//============================================================================



static void Test_aF_BFu8i_D()
{
  {
    init_simple_test("aF_BFu8i_D");
    static STRUCT_IF_C aF_BFu8i_D lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu8i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_D)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_D");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_D");
    check_field_offset(lv, v3, 5, "aF_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_D, aF_BFu8i_D)
//============================================================================



static void Test_aF_BFu8i_F()
{
  {
    init_simple_test("aF_BFu8i_F");
    static STRUCT_IF_C aF_BFu8i_F lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_F)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_F");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_F");
    check_field_offset(lv, v3, 5, "aF_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_F, aF_BFu8i_F)
//============================================================================



static void Test_aF_BFu8i_I()
{
  {
    init_simple_test("aF_BFu8i_I");
    static STRUCT_IF_C aF_BFu8i_I lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_I)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_I");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_I");
    check_field_offset(lv, v3, 5, "aF_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_I, aF_BFu8i_I)
//============================================================================



static void Test_aF_BFu8i_Ip()
{
  {
    init_simple_test("aF_BFu8i_Ip");
    static STRUCT_IF_C aF_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu8i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_Ip");
    check_field_offset(lv, v3, 5, "aF_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_Ip, aF_BFu8i_Ip)
//============================================================================



static void Test_aF_BFu8i_L()
{
  {
    init_simple_test("aF_BFu8i_L");
    static STRUCT_IF_C aF_BFu8i_L lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu8i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_L)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_L");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_L");
    check_field_offset(lv, v3, 5, "aF_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_L, aF_BFu8i_L)
//============================================================================



static void Test_aF_BFu8i_S()
{
  {
    init_simple_test("aF_BFu8i_S");
    static STRUCT_IF_C aF_BFu8i_S lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_S)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_S");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_S");
    check_field_offset(lv, v3, 5, "aF_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_S, aF_BFu8i_S)
//============================================================================



static void Test_aF_BFu8i_Uc()
{
  {
    init_simple_test("aF_BFu8i_Uc");
    static STRUCT_IF_C aF_BFu8i_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_Uc");
    check_field_offset(lv, v3, 5, "aF_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_Uc, aF_BFu8i_Uc)
//============================================================================



static void Test_aF_BFu8i_Ui()
{
  {
    init_simple_test("aF_BFu8i_Ui");
    static STRUCT_IF_C aF_BFu8i_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_Ui");
    check_field_offset(lv, v3, 5, "aF_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_Ui, aF_BFu8i_Ui)
//============================================================================



static void Test_aF_BFu8i_Ul()
{
  {
    init_simple_test("aF_BFu8i_Ul");
    static STRUCT_IF_C aF_BFu8i_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu8i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_Ul");
    check_field_offset(lv, v3, 5, "aF_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_Ul, aF_BFu8i_Ul)
//============================================================================



static void Test_aF_BFu8i_Us()
{
  {
    init_simple_test("aF_BFu8i_Us");
    static STRUCT_IF_C aF_BFu8i_Us lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_Us");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_Us");
    check_field_offset(lv, v3, 5, "aF_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_Us, aF_BFu8i_Us)
//============================================================================



static void Test_aF_BFu8i_Vp()
{
  {
    init_simple_test("aF_BFu8i_Vp");
    static STRUCT_IF_C aF_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu8i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8i_Vp");
    check_field_offset(lv, v3, 5, "aF_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8i_Vp, aF_BFu8i_Vp)
//============================================================================



static void Test_aF_BFu8ll()
{
  {
    init_simple_test("aF_BFu8ll");
    static STRUCT_IF_C aF_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll, aF_BFu8ll)
//============================================================================



static void Test_aF_BFu8ll_BFu15i()
{
  {
    init_simple_test("aF_BFu8ll_BFu15i");
    static STRUCT_IF_C aF_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu15i, aF_BFu8ll_BFu15i)
//============================================================================



static void Test_aF_BFu8ll_BFu15ll()
{
  {
    init_simple_test("aF_BFu8ll_BFu15ll");
    static STRUCT_IF_C aF_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu15ll, aF_BFu8ll_BFu15ll)
//============================================================================



static void Test_aF_BFu8ll_BFu15s()
{
  {
    init_simple_test("aF_BFu8ll_BFu15s");
    static STRUCT_IF_C aF_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu15s, aF_BFu8ll_BFu15s)
//============================================================================



static void Test_aF_BFu8ll_BFu16i()
{
  {
    init_simple_test("aF_BFu8ll_BFu16i");
    static STRUCT_IF_C aF_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu16i, aF_BFu8ll_BFu16i)
//============================================================================



static void Test_aF_BFu8ll_BFu16ll()
{
  {
    init_simple_test("aF_BFu8ll_BFu16ll");
    static STRUCT_IF_C aF_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu16ll, aF_BFu8ll_BFu16ll)
//============================================================================



static void Test_aF_BFu8ll_BFu16s()
{
  {
    init_simple_test("aF_BFu8ll_BFu16s");
    static STRUCT_IF_C aF_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu16s, aF_BFu8ll_BFu16s)
//============================================================================



static void Test_aF_BFu8ll_BFu17i()
{
  {
    init_simple_test("aF_BFu8ll_BFu17i");
    static STRUCT_IF_C aF_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu8ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aF_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aF_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu17i, aF_BFu8ll_BFu17i)
//============================================================================



static void Test_aF_BFu8ll_BFu17ll()
{
  {
    init_simple_test("aF_BFu8ll_BFu17ll");
    static STRUCT_IF_C aF_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aF_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aF_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu17ll, aF_BFu8ll_BFu17ll)
//============================================================================



static void Test_aF_BFu8ll_BFu1c()
{
  {
    init_simple_test("aF_BFu8ll_BFu1c");
    static STRUCT_IF_C aF_BFu8ll_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu1c, aF_BFu8ll_BFu1c)
//============================================================================



static void Test_aF_BFu8ll_BFu1i()
{
  {
    init_simple_test("aF_BFu8ll_BFu1i");
    static STRUCT_IF_C aF_BFu8ll_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu1i, aF_BFu8ll_BFu1i)
//============================================================================



static void Test_aF_BFu8ll_BFu1ll()
{
  {
    init_simple_test("aF_BFu8ll_BFu1ll");
    static STRUCT_IF_C aF_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu1ll, aF_BFu8ll_BFu1ll)
//============================================================================



static void Test_aF_BFu8ll_BFu1s()
{
  {
    init_simple_test("aF_BFu8ll_BFu1s");
    static STRUCT_IF_C aF_BFu8ll_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu1s, aF_BFu8ll_BFu1s)
//============================================================================



static void Test_aF_BFu8ll_BFu31i()
{
  {
    init_simple_test("aF_BFu8ll_BFu31i");
    static STRUCT_IF_C aF_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aF_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aF_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu31i, aF_BFu8ll_BFu31i)
//============================================================================



static void Test_aF_BFu8ll_BFu31ll()
{
  {
    init_simple_test("aF_BFu8ll_BFu31ll");
    static STRUCT_IF_C aF_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aF_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aF_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu31ll, aF_BFu8ll_BFu31ll)
//============================================================================



static void Test_aF_BFu8ll_BFu32i()
{
  {
    init_simple_test("aF_BFu8ll_BFu32i");
    static STRUCT_IF_C aF_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aF_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aF_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu32i, aF_BFu8ll_BFu32i)
//============================================================================



static void Test_aF_BFu8ll_BFu32ll()
{
  {
    init_simple_test("aF_BFu8ll_BFu32ll");
    static STRUCT_IF_C aF_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aF_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aF_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu32ll, aF_BFu8ll_BFu32ll)
//============================================================================



static void Test_aF_BFu8ll_BFu33()
{
  {
    init_simple_test("aF_BFu8ll_BFu33");
    static STRUCT_IF_C aF_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu8ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aF_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aF_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu33, aF_BFu8ll_BFu33)
//============================================================================



static void Test_aF_BFu8ll_BFu7c()
{
  {
    init_simple_test("aF_BFu8ll_BFu7c");
    static STRUCT_IF_C aF_BFu8ll_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu7c, aF_BFu8ll_BFu7c)
//============================================================================



static void Test_aF_BFu8ll_BFu7i()
{
  {
    init_simple_test("aF_BFu8ll_BFu7i");
    static STRUCT_IF_C aF_BFu8ll_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu7i, aF_BFu8ll_BFu7i)
//============================================================================



static void Test_aF_BFu8ll_BFu7ll()
{
  {
    init_simple_test("aF_BFu8ll_BFu7ll");
    static STRUCT_IF_C aF_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu7ll, aF_BFu8ll_BFu7ll)
//============================================================================



static void Test_aF_BFu8ll_BFu7s()
{
  {
    init_simple_test("aF_BFu8ll_BFu7s");
    static STRUCT_IF_C aF_BFu8ll_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu7s, aF_BFu8ll_BFu7s)
//============================================================================



static void Test_aF_BFu8ll_BFu8c()
{
  {
    init_simple_test("aF_BFu8ll_BFu8c");
    static STRUCT_IF_C aF_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu8c, aF_BFu8ll_BFu8c)
//============================================================================



static void Test_aF_BFu8ll_BFu8i()
{
  {
    init_simple_test("aF_BFu8ll_BFu8i");
    static STRUCT_IF_C aF_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu8i, aF_BFu8ll_BFu8i)
//============================================================================



static void Test_aF_BFu8ll_BFu8ll()
{
  {
    init_simple_test("aF_BFu8ll_BFu8ll");
    static STRUCT_IF_C aF_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu8ll, aF_BFu8ll_BFu8ll)
//============================================================================



static void Test_aF_BFu8ll_BFu8s()
{
  {
    init_simple_test("aF_BFu8ll_BFu8s");
    static STRUCT_IF_C aF_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu8s, aF_BFu8ll_BFu8s)
//============================================================================



static void Test_aF_BFu8ll_BFu9i()
{
  {
    init_simple_test("aF_BFu8ll_BFu9i");
    static STRUCT_IF_C aF_BFu8ll_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu9i, aF_BFu8ll_BFu9i)
//============================================================================



static void Test_aF_BFu8ll_BFu9ll()
{
  {
    init_simple_test("aF_BFu8ll_BFu9ll");
    static STRUCT_IF_C aF_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu9ll, aF_BFu8ll_BFu9ll)
//============================================================================



static void Test_aF_BFu8ll_BFu9s()
{
  {
    init_simple_test("aF_BFu8ll_BFu9s");
    static STRUCT_IF_C aF_BFu8ll_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_BFu9s, aF_BFu8ll_BFu9s)
//============================================================================



static void Test_aF_BFu8ll_C()
{
  {
    init_simple_test("aF_BFu8ll_C");
    static STRUCT_IF_C aF_BFu8ll_C lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_C");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_C");
    check_field_offset(lv, v3, 5, "aF_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_C, aF_BFu8ll_C)
//============================================================================



static void Test_aF_BFu8ll_D()
{
  {
    init_simple_test("aF_BFu8ll_D");
    static STRUCT_IF_C aF_BFu8ll_D lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu8ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_D");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_D");
    check_field_offset(lv, v3, 5, "aF_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_D, aF_BFu8ll_D)
//============================================================================



static void Test_aF_BFu8ll_F()
{
  {
    init_simple_test("aF_BFu8ll_F");
    static STRUCT_IF_C aF_BFu8ll_F lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_F");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_F");
    check_field_offset(lv, v3, 5, "aF_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_F, aF_BFu8ll_F)
//============================================================================



static void Test_aF_BFu8ll_I()
{
  {
    init_simple_test("aF_BFu8ll_I");
    static STRUCT_IF_C aF_BFu8ll_I lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_I");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_I");
    check_field_offset(lv, v3, 5, "aF_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_I, aF_BFu8ll_I)
//============================================================================



static void Test_aF_BFu8ll_Ip()
{
  {
    init_simple_test("aF_BFu8ll_Ip");
    static STRUCT_IF_C aF_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_Ip");
    check_field_offset(lv, v3, 5, "aF_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_Ip, aF_BFu8ll_Ip)
//============================================================================



static void Test_aF_BFu8ll_L()
{
  {
    init_simple_test("aF_BFu8ll_L");
    static STRUCT_IF_C aF_BFu8ll_L lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_L");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_L");
    check_field_offset(lv, v3, 5, "aF_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_L, aF_BFu8ll_L)
//============================================================================



static void Test_aF_BFu8ll_S()
{
  {
    init_simple_test("aF_BFu8ll_S");
    static STRUCT_IF_C aF_BFu8ll_S lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_S");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_S");
    check_field_offset(lv, v3, 5, "aF_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_S, aF_BFu8ll_S)
//============================================================================



static void Test_aF_BFu8ll_Uc()
{
  {
    init_simple_test("aF_BFu8ll_Uc");
    static STRUCT_IF_C aF_BFu8ll_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_Uc");
    check_field_offset(lv, v3, 5, "aF_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_Uc, aF_BFu8ll_Uc)
//============================================================================



static void Test_aF_BFu8ll_Ui()
{
  {
    init_simple_test("aF_BFu8ll_Ui");
    static STRUCT_IF_C aF_BFu8ll_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_Ui");
    check_field_offset(lv, v3, 5, "aF_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_Ui, aF_BFu8ll_Ui)
//============================================================================



static void Test_aF_BFu8ll_Ul()
{
  {
    init_simple_test("aF_BFu8ll_Ul");
    static STRUCT_IF_C aF_BFu8ll_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_Ul");
    check_field_offset(lv, v3, 5, "aF_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_Ul, aF_BFu8ll_Ul)
//============================================================================



static void Test_aF_BFu8ll_Us()
{
  {
    init_simple_test("aF_BFu8ll_Us");
    static STRUCT_IF_C aF_BFu8ll_Us lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_Us");
    check_field_offset(lv, v3, 5, "aF_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_Us, aF_BFu8ll_Us)
//============================================================================



static void Test_aF_BFu8ll_Vp()
{
  {
    init_simple_test("aF_BFu8ll_Vp");
    static STRUCT_IF_C aF_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8ll_Vp");
    check_field_offset(lv, v3, 5, "aF_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8ll_Vp, aF_BFu8ll_Vp)
//============================================================================



static void Test_aF_BFu8s()
{
  {
    init_simple_test("aF_BFu8s");
    static STRUCT_IF_C aF_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aF_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s, aF_BFu8s)
//============================================================================



static void Test_aF_BFu8s_BFu15i()
{
  {
    init_simple_test("aF_BFu8s_BFu15i");
    static STRUCT_IF_C aF_BFu8s_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu15i, aF_BFu8s_BFu15i)
//============================================================================



static void Test_aF_BFu8s_BFu15ll()
{
  {
    init_simple_test("aF_BFu8s_BFu15ll");
    static STRUCT_IF_C aF_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu15ll, aF_BFu8s_BFu15ll)
//============================================================================



static void Test_aF_BFu8s_BFu15s()
{
  {
    init_simple_test("aF_BFu8s_BFu15s");
    static STRUCT_IF_C aF_BFu8s_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu15s, aF_BFu8s_BFu15s)
//============================================================================



static void Test_aF_BFu8s_BFu16i()
{
  {
    init_simple_test("aF_BFu8s_BFu16i");
    static STRUCT_IF_C aF_BFu8s_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu16i, aF_BFu8s_BFu16i)
//============================================================================



static void Test_aF_BFu8s_BFu16ll()
{
  {
    init_simple_test("aF_BFu8s_BFu16ll");
    static STRUCT_IF_C aF_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu16ll, aF_BFu8s_BFu16ll)
//============================================================================



static void Test_aF_BFu8s_BFu16s()
{
  {
    init_simple_test("aF_BFu8s_BFu16s");
    static STRUCT_IF_C aF_BFu8s_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu16s, aF_BFu8s_BFu16s)
//============================================================================



static void Test_aF_BFu8s_BFu17i()
{
  {
    init_simple_test("aF_BFu8s_BFu17i");
    static STRUCT_IF_C aF_BFu8s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu8s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aF_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aF_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu17i, aF_BFu8s_BFu17i)
//============================================================================



static void Test_aF_BFu8s_BFu17ll()
{
  {
    init_simple_test("aF_BFu8s_BFu17ll");
    static STRUCT_IF_C aF_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu8s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aF_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aF_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu17ll, aF_BFu8s_BFu17ll)
//============================================================================



static void Test_aF_BFu8s_BFu1c()
{
  {
    init_simple_test("aF_BFu8s_BFu1c");
    static STRUCT_IF_C aF_BFu8s_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu1c, aF_BFu8s_BFu1c)
//============================================================================



static void Test_aF_BFu8s_BFu1i()
{
  {
    init_simple_test("aF_BFu8s_BFu1i");
    static STRUCT_IF_C aF_BFu8s_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu1i, aF_BFu8s_BFu1i)
//============================================================================



static void Test_aF_BFu8s_BFu1ll()
{
  {
    init_simple_test("aF_BFu8s_BFu1ll");
    static STRUCT_IF_C aF_BFu8s_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu1ll, aF_BFu8s_BFu1ll)
//============================================================================



static void Test_aF_BFu8s_BFu1s()
{
  {
    init_simple_test("aF_BFu8s_BFu1s");
    static STRUCT_IF_C aF_BFu8s_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu1s, aF_BFu8s_BFu1s)
//============================================================================



static void Test_aF_BFu8s_BFu31i()
{
  {
    init_simple_test("aF_BFu8s_BFu31i");
    static STRUCT_IF_C aF_BFu8s_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aF_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aF_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu31i, aF_BFu8s_BFu31i)
//============================================================================



static void Test_aF_BFu8s_BFu31ll()
{
  {
    init_simple_test("aF_BFu8s_BFu31ll");
    static STRUCT_IF_C aF_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aF_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aF_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu31ll, aF_BFu8s_BFu31ll)
//============================================================================



static void Test_aF_BFu8s_BFu32i()
{
  {
    init_simple_test("aF_BFu8s_BFu32i");
    static STRUCT_IF_C aF_BFu8s_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aF_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aF_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu32i, aF_BFu8s_BFu32i)
//============================================================================



static void Test_aF_BFu8s_BFu32ll()
{
  {
    init_simple_test("aF_BFu8s_BFu32ll");
    static STRUCT_IF_C aF_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aF_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aF_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu32ll, aF_BFu8s_BFu32ll)
//============================================================================



static void Test_aF_BFu8s_BFu33()
{
  {
    init_simple_test("aF_BFu8s_BFu33");
    static STRUCT_IF_C aF_BFu8s_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu8s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aF_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aF_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu33, aF_BFu8s_BFu33)
//============================================================================



static void Test_aF_BFu8s_BFu7c()
{
  {
    init_simple_test("aF_BFu8s_BFu7c");
    static STRUCT_IF_C aF_BFu8s_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu7c, aF_BFu8s_BFu7c)
//============================================================================



static void Test_aF_BFu8s_BFu7i()
{
  {
    init_simple_test("aF_BFu8s_BFu7i");
    static STRUCT_IF_C aF_BFu8s_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu7i, aF_BFu8s_BFu7i)
//============================================================================



static void Test_aF_BFu8s_BFu7ll()
{
  {
    init_simple_test("aF_BFu8s_BFu7ll");
    static STRUCT_IF_C aF_BFu8s_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu7ll, aF_BFu8s_BFu7ll)
//============================================================================



static void Test_aF_BFu8s_BFu7s()
{
  {
    init_simple_test("aF_BFu8s_BFu7s");
    static STRUCT_IF_C aF_BFu8s_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu7s, aF_BFu8s_BFu7s)
//============================================================================



static void Test_aF_BFu8s_BFu8c()
{
  {
    init_simple_test("aF_BFu8s_BFu8c");
    static STRUCT_IF_C aF_BFu8s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu8c, aF_BFu8s_BFu8c)
//============================================================================



static void Test_aF_BFu8s_BFu8i()
{
  {
    init_simple_test("aF_BFu8s_BFu8i");
    static STRUCT_IF_C aF_BFu8s_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu8i, aF_BFu8s_BFu8i)
//============================================================================



static void Test_aF_BFu8s_BFu8ll()
{
  {
    init_simple_test("aF_BFu8s_BFu8ll");
    static STRUCT_IF_C aF_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu8ll, aF_BFu8s_BFu8ll)
//============================================================================



static void Test_aF_BFu8s_BFu8s()
{
  {
    init_simple_test("aF_BFu8s_BFu8s");
    static STRUCT_IF_C aF_BFu8s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu8s, aF_BFu8s_BFu8s)
//============================================================================



static void Test_aF_BFu8s_BFu9i()
{
  {
    init_simple_test("aF_BFu8s_BFu9i");
    static STRUCT_IF_C aF_BFu8s_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu9i, aF_BFu8s_BFu9i)
//============================================================================



static void Test_aF_BFu8s_BFu9ll()
{
  {
    init_simple_test("aF_BFu8s_BFu9ll");
    static STRUCT_IF_C aF_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu9ll, aF_BFu8s_BFu9ll)
//============================================================================



static void Test_aF_BFu8s_BFu9s()
{
  {
    init_simple_test("aF_BFu8s_BFu9s");
    static STRUCT_IF_C aF_BFu8s_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_BFu9s, aF_BFu8s_BFu9s)
//============================================================================



static void Test_aF_BFu8s_C()
{
  {
    init_simple_test("aF_BFu8s_C");
    static STRUCT_IF_C aF_BFu8s_C lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_C)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_C");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_C");
    check_field_offset(lv, v3, 5, "aF_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_C, aF_BFu8s_C)
//============================================================================



static void Test_aF_BFu8s_D()
{
  {
    init_simple_test("aF_BFu8s_D");
    static STRUCT_IF_C aF_BFu8s_D lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu8s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_D)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_D");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_D");
    check_field_offset(lv, v3, 5, "aF_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_D, aF_BFu8s_D)
//============================================================================



static void Test_aF_BFu8s_F()
{
  {
    init_simple_test("aF_BFu8s_F");
    static STRUCT_IF_C aF_BFu8s_F lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_F)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_F");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_F");
    check_field_offset(lv, v3, 5, "aF_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_F, aF_BFu8s_F)
//============================================================================



static void Test_aF_BFu8s_I()
{
  {
    init_simple_test("aF_BFu8s_I");
    static STRUCT_IF_C aF_BFu8s_I lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_I)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_I");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_I");
    check_field_offset(lv, v3, 5, "aF_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_I, aF_BFu8s_I)
//============================================================================



static void Test_aF_BFu8s_Ip()
{
  {
    init_simple_test("aF_BFu8s_Ip");
    static STRUCT_IF_C aF_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu8s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_Ip");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_Ip");
    check_field_offset(lv, v3, 5, "aF_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_Ip, aF_BFu8s_Ip)
//============================================================================



static void Test_aF_BFu8s_L()
{
  {
    init_simple_test("aF_BFu8s_L");
    static STRUCT_IF_C aF_BFu8s_L lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu8s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_L)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_L");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_L");
    check_field_offset(lv, v3, 5, "aF_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_L, aF_BFu8s_L)
//============================================================================



static void Test_aF_BFu8s_S()
{
  {
    init_simple_test("aF_BFu8s_S");
    static STRUCT_IF_C aF_BFu8s_S lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_S)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_S");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_S");
    check_field_offset(lv, v3, 5, "aF_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_S, aF_BFu8s_S)
//============================================================================



static void Test_aF_BFu8s_Uc()
{
  {
    init_simple_test("aF_BFu8s_Uc");
    static STRUCT_IF_C aF_BFu8s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu8s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_Uc");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_Uc");
    check_field_offset(lv, v3, 5, "aF_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_Uc, aF_BFu8s_Uc)
//============================================================================



static void Test_aF_BFu8s_Ui()
{
  {
    init_simple_test("aF_BFu8s_Ui");
    static STRUCT_IF_C aF_BFu8s_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu8s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_Ui");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_Ui");
    check_field_offset(lv, v3, 5, "aF_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_Ui, aF_BFu8s_Ui)
//============================================================================



static void Test_aF_BFu8s_Ul()
{
  {
    init_simple_test("aF_BFu8s_Ul");
    static STRUCT_IF_C aF_BFu8s_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aF_BFu8s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_Ul");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_Ul");
    check_field_offset(lv, v3, 5, "aF_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_Ul, aF_BFu8s_Ul)
//============================================================================



static void Test_aF_BFu8s_Us()
{
  {
    init_simple_test("aF_BFu8s_Us");
    static STRUCT_IF_C aF_BFu8s_Us lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu8s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_Us");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_Us");
    check_field_offset(lv, v3, 5, "aF_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_Us, aF_BFu8s_Us)
//============================================================================



static void Test_aF_BFu8s_Vp()
{
  {
    init_simple_test("aF_BFu8s_Vp");
    static STRUCT_IF_C aF_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_BFu8s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 8, 1, "aF_BFu8s_Vp");
    set_bf_and_test(lv, v2, 4, 0, 8, hide_ull(1LL<<7), "aF_BFu8s_Vp");
    check_field_offset(lv, v3, 5, "aF_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu8s_Vp, aF_BFu8s_Vp)
//============================================================================



static void Test_aF_BFu9i()
{
  {
    init_simple_test("aF_BFu9i");
    static STRUCT_IF_C aF_BFu9i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i, aF_BFu9i)
//============================================================================



static void Test_aF_BFu9i_BFu15i()
{
  {
    init_simple_test("aF_BFu9i_BFu15i");
    static STRUCT_IF_C aF_BFu9i_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aF_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aF_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu15i, aF_BFu9i_BFu15i)
//============================================================================



static void Test_aF_BFu9i_BFu15ll()
{
  {
    init_simple_test("aF_BFu9i_BFu15ll");
    static STRUCT_IF_C aF_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aF_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aF_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu15ll, aF_BFu9i_BFu15ll)
//============================================================================



static void Test_aF_BFu9i_BFu15s()
{
  {
    init_simple_test("aF_BFu9i_BFu15s");
    static STRUCT_IF_C aF_BFu9i_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aF_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aF_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu15s, aF_BFu9i_BFu15s)
//============================================================================



static void Test_aF_BFu9i_BFu16i()
{
  {
    init_simple_test("aF_BFu9i_BFu16i");
    static STRUCT_IF_C aF_BFu9i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aF_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aF_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu16i, aF_BFu9i_BFu16i)
//============================================================================



static void Test_aF_BFu9i_BFu16ll()
{
  {
    init_simple_test("aF_BFu9i_BFu16ll");
    static STRUCT_IF_C aF_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aF_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aF_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu16ll, aF_BFu9i_BFu16ll)
//============================================================================



static void Test_aF_BFu9i_BFu16s()
{
  {
    init_simple_test("aF_BFu9i_BFu16s");
    static STRUCT_IF_C aF_BFu9i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aF_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aF_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu16s, aF_BFu9i_BFu16s)
//============================================================================



static void Test_aF_BFu9i_BFu17i()
{
  {
    init_simple_test("aF_BFu9i_BFu17i");
    static STRUCT_IF_C aF_BFu9i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "aF_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "aF_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu17i, aF_BFu9i_BFu17i)
//============================================================================



static void Test_aF_BFu9i_BFu17ll()
{
  {
    init_simple_test("aF_BFu9i_BFu17ll");
    static STRUCT_IF_C aF_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "aF_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "aF_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu17ll, aF_BFu9i_BFu17ll)
//============================================================================



static void Test_aF_BFu9i_BFu1c()
{
  {
    init_simple_test("aF_BFu9i_BFu1c");
    static STRUCT_IF_C aF_BFu9i_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aF_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu1c, aF_BFu9i_BFu1c)
//============================================================================



static void Test_aF_BFu9i_BFu1i()
{
  {
    init_simple_test("aF_BFu9i_BFu1i");
    static STRUCT_IF_C aF_BFu9i_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aF_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu1i, aF_BFu9i_BFu1i)
//============================================================================



static void Test_aF_BFu9i_BFu1ll()
{
  {
    init_simple_test("aF_BFu9i_BFu1ll");
    static STRUCT_IF_C aF_BFu9i_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aF_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu1ll, aF_BFu9i_BFu1ll)
//============================================================================



static void Test_aF_BFu9i_BFu1s()
{
  {
    init_simple_test("aF_BFu9i_BFu1s");
    static STRUCT_IF_C aF_BFu9i_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aF_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu1s, aF_BFu9i_BFu1s)
//============================================================================



static void Test_aF_BFu9i_BFu31i()
{
  {
    init_simple_test("aF_BFu9i_BFu31i");
    static STRUCT_IF_C aF_BFu9i_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu9i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "aF_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "aF_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu31i, aF_BFu9i_BFu31i)
//============================================================================



static void Test_aF_BFu9i_BFu31ll()
{
  {
    init_simple_test("aF_BFu9i_BFu31ll");
    static STRUCT_IF_C aF_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu9i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "aF_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "aF_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu31ll, aF_BFu9i_BFu31ll)
//============================================================================



static void Test_aF_BFu9i_BFu32i()
{
  {
    init_simple_test("aF_BFu9i_BFu32i");
    static STRUCT_IF_C aF_BFu9i_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "aF_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "aF_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu32i, aF_BFu9i_BFu32i)
//============================================================================



static void Test_aF_BFu9i_BFu32ll()
{
  {
    init_simple_test("aF_BFu9i_BFu32ll");
    static STRUCT_IF_C aF_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "aF_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "aF_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu32ll, aF_BFu9i_BFu32ll)
//============================================================================



static void Test_aF_BFu9i_BFu33()
{
  {
    init_simple_test("aF_BFu9i_BFu33");
    static STRUCT_IF_C aF_BFu9i_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, 1, "aF_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, hide_ull(1LL<<32), "aF_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu33, aF_BFu9i_BFu33)
//============================================================================



static void Test_aF_BFu9i_BFu7c()
{
  {
    init_simple_test("aF_BFu9i_BFu7c");
    static STRUCT_IF_C aF_BFu9i_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aF_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aF_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu7c, aF_BFu9i_BFu7c)
//============================================================================



static void Test_aF_BFu9i_BFu7i()
{
  {
    init_simple_test("aF_BFu9i_BFu7i");
    static STRUCT_IF_C aF_BFu9i_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aF_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aF_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu7i, aF_BFu9i_BFu7i)
//============================================================================



static void Test_aF_BFu9i_BFu7ll()
{
  {
    init_simple_test("aF_BFu9i_BFu7ll");
    static STRUCT_IF_C aF_BFu9i_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aF_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aF_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu7ll, aF_BFu9i_BFu7ll)
//============================================================================



static void Test_aF_BFu9i_BFu7s()
{
  {
    init_simple_test("aF_BFu9i_BFu7s");
    static STRUCT_IF_C aF_BFu9i_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aF_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aF_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu7s, aF_BFu9i_BFu7s)
//============================================================================



static void Test_aF_BFu9i_BFu8c()
{
  {
    init_simple_test("aF_BFu9i_BFu8c");
    static STRUCT_IF_C aF_BFu9i_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aF_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aF_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu8c, aF_BFu9i_BFu8c)
//============================================================================



static void Test_aF_BFu9i_BFu8i()
{
  {
    init_simple_test("aF_BFu9i_BFu8i");
    static STRUCT_IF_C aF_BFu9i_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aF_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aF_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu8i, aF_BFu9i_BFu8i)
//============================================================================



static void Test_aF_BFu9i_BFu8ll()
{
  {
    init_simple_test("aF_BFu9i_BFu8ll");
    static STRUCT_IF_C aF_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aF_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aF_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu8ll, aF_BFu9i_BFu8ll)
//============================================================================



static void Test_aF_BFu9i_BFu8s()
{
  {
    init_simple_test("aF_BFu9i_BFu8s");
    static STRUCT_IF_C aF_BFu9i_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aF_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aF_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu8s, aF_BFu9i_BFu8s)
//============================================================================



static void Test_aF_BFu9i_BFu9i()
{
  {
    init_simple_test("aF_BFu9i_BFu9i");
    static STRUCT_IF_C aF_BFu9i_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aF_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu9i, aF_BFu9i_BFu9i)
//============================================================================



static void Test_aF_BFu9i_BFu9ll()
{
  {
    init_simple_test("aF_BFu9i_BFu9ll");
    static STRUCT_IF_C aF_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aF_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu9ll, aF_BFu9i_BFu9ll)
//============================================================================



static void Test_aF_BFu9i_BFu9s()
{
  {
    init_simple_test("aF_BFu9i_BFu9s");
    static STRUCT_IF_C aF_BFu9i_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aF_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aF_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_BFu9s, aF_BFu9i_BFu9s)
//============================================================================



static void Test_aF_BFu9i_C()
{
  {
    init_simple_test("aF_BFu9i_C");
    static STRUCT_IF_C aF_BFu9i_C lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_C)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_C");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_C");
    check_field_offset(lv, v3, 6, "aF_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_C, aF_BFu9i_C)
//============================================================================



static void Test_aF_BFu9i_D()
{
  {
    init_simple_test("aF_BFu9i_D");
    static STRUCT_IF_C aF_BFu9i_D lv;
    check2(sizeof(lv), 14, "sizeof(aF_BFu9i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_D)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_D");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_D");
    check_field_offset(lv, v3, 6, "aF_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_D, aF_BFu9i_D)
//============================================================================



static void Test_aF_BFu9i_F()
{
  {
    init_simple_test("aF_BFu9i_F");
    static STRUCT_IF_C aF_BFu9i_F lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_F)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_F");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_F");
    check_field_offset(lv, v3, 6, "aF_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_F, aF_BFu9i_F)
//============================================================================



static void Test_aF_BFu9i_I()
{
  {
    init_simple_test("aF_BFu9i_I");
    static STRUCT_IF_C aF_BFu9i_I lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_I)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_I");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_I");
    check_field_offset(lv, v3, 6, "aF_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_I, aF_BFu9i_I)
//============================================================================



static void Test_aF_BFu9i_Ip()
{
  {
    init_simple_test("aF_BFu9i_Ip");
    static STRUCT_IF_C aF_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_BFu9i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_Ip");
    check_field_offset(lv, v3, 6, "aF_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_Ip, aF_BFu9i_Ip)
//============================================================================



static void Test_aF_BFu9i_L()
{
  {
    init_simple_test("aF_BFu9i_L");
    static STRUCT_IF_C aF_BFu9i_L lv;
    check2(sizeof(lv), 14, "sizeof(aF_BFu9i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_L)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_L");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_L");
    check_field_offset(lv, v3, 6, "aF_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_L, aF_BFu9i_L)
//============================================================================



static void Test_aF_BFu9i_S()
{
  {
    init_simple_test("aF_BFu9i_S");
    static STRUCT_IF_C aF_BFu9i_S lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_S)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_S");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_S");
    check_field_offset(lv, v3, 6, "aF_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_S, aF_BFu9i_S)
//============================================================================



static void Test_aF_BFu9i_Uc()
{
  {
    init_simple_test("aF_BFu9i_Uc");
    static STRUCT_IF_C aF_BFu9i_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_Uc");
    check_field_offset(lv, v3, 6, "aF_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_Uc, aF_BFu9i_Uc)
//============================================================================



static void Test_aF_BFu9i_Ui()
{
  {
    init_simple_test("aF_BFu9i_Ui");
    static STRUCT_IF_C aF_BFu9i_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_Ui");
    check_field_offset(lv, v3, 6, "aF_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_Ui, aF_BFu9i_Ui)
//============================================================================



static void Test_aF_BFu9i_Ul()
{
  {
    init_simple_test("aF_BFu9i_Ul");
    static STRUCT_IF_C aF_BFu9i_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aF_BFu9i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_Ul");
    check_field_offset(lv, v3, 6, "aF_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_Ul, aF_BFu9i_Ul)
//============================================================================



static void Test_aF_BFu9i_Us()
{
  {
    init_simple_test("aF_BFu9i_Us");
    static STRUCT_IF_C aF_BFu9i_Us lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_Us");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_Us");
    check_field_offset(lv, v3, 6, "aF_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_Us, aF_BFu9i_Us)
//============================================================================



static void Test_aF_BFu9i_Vp()
{
  {
    init_simple_test("aF_BFu9i_Vp");
    static STRUCT_IF_C aF_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_BFu9i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9i_Vp");
    check_field_offset(lv, v3, 6, "aF_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9i_Vp, aF_BFu9i_Vp)
//============================================================================



static void Test_aF_BFu9ll()
{
  {
    init_simple_test("aF_BFu9ll");
    static STRUCT_IF_C aF_BFu9ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll, aF_BFu9ll)
//============================================================================



static void Test_aF_BFu9ll_BFu15i()
{
  {
    init_simple_test("aF_BFu9ll_BFu15i");
    static STRUCT_IF_C aF_BFu9ll_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aF_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aF_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu15i, aF_BFu9ll_BFu15i)
//============================================================================



static void Test_aF_BFu9ll_BFu15ll()
{
  {
    init_simple_test("aF_BFu9ll_BFu15ll");
    static STRUCT_IF_C aF_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aF_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aF_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu15ll, aF_BFu9ll_BFu15ll)
//============================================================================



static void Test_aF_BFu9ll_BFu15s()
{
  {
    init_simple_test("aF_BFu9ll_BFu15s");
    static STRUCT_IF_C aF_BFu9ll_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aF_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aF_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu15s, aF_BFu9ll_BFu15s)
//============================================================================



static void Test_aF_BFu9ll_BFu16i()
{
  {
    init_simple_test("aF_BFu9ll_BFu16i");
    static STRUCT_IF_C aF_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aF_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aF_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu16i, aF_BFu9ll_BFu16i)
//============================================================================



static void Test_aF_BFu9ll_BFu16ll()
{
  {
    init_simple_test("aF_BFu9ll_BFu16ll");
    static STRUCT_IF_C aF_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aF_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aF_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu16ll, aF_BFu9ll_BFu16ll)
//============================================================================



static void Test_aF_BFu9ll_BFu16s()
{
  {
    init_simple_test("aF_BFu9ll_BFu16s");
    static STRUCT_IF_C aF_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aF_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aF_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu16s, aF_BFu9ll_BFu16s)
//============================================================================



static void Test_aF_BFu9ll_BFu17i()
{
  {
    init_simple_test("aF_BFu9ll_BFu17i");
    static STRUCT_IF_C aF_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "aF_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "aF_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu17i, aF_BFu9ll_BFu17i)
//============================================================================



static void Test_aF_BFu9ll_BFu17ll()
{
  {
    init_simple_test("aF_BFu9ll_BFu17ll");
    static STRUCT_IF_C aF_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "aF_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "aF_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu17ll, aF_BFu9ll_BFu17ll)
//============================================================================



static void Test_aF_BFu9ll_BFu1c()
{
  {
    init_simple_test("aF_BFu9ll_BFu1c");
    static STRUCT_IF_C aF_BFu9ll_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aF_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu1c, aF_BFu9ll_BFu1c)
//============================================================================



static void Test_aF_BFu9ll_BFu1i()
{
  {
    init_simple_test("aF_BFu9ll_BFu1i");
    static STRUCT_IF_C aF_BFu9ll_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aF_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu1i, aF_BFu9ll_BFu1i)
//============================================================================



static void Test_aF_BFu9ll_BFu1ll()
{
  {
    init_simple_test("aF_BFu9ll_BFu1ll");
    static STRUCT_IF_C aF_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aF_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu1ll, aF_BFu9ll_BFu1ll)
//============================================================================



static void Test_aF_BFu9ll_BFu1s()
{
  {
    init_simple_test("aF_BFu9ll_BFu1s");
    static STRUCT_IF_C aF_BFu9ll_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aF_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu1s, aF_BFu9ll_BFu1s)
//============================================================================



static void Test_aF_BFu9ll_BFu31i()
{
  {
    init_simple_test("aF_BFu9ll_BFu31i");
    static STRUCT_IF_C aF_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu9ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "aF_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "aF_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu31i, aF_BFu9ll_BFu31i)
//============================================================================



static void Test_aF_BFu9ll_BFu31ll()
{
  {
    init_simple_test("aF_BFu9ll_BFu31ll");
    static STRUCT_IF_C aF_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "aF_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "aF_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu31ll, aF_BFu9ll_BFu31ll)
//============================================================================



static void Test_aF_BFu9ll_BFu32i()
{
  {
    init_simple_test("aF_BFu9ll_BFu32i");
    static STRUCT_IF_C aF_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "aF_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "aF_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu32i, aF_BFu9ll_BFu32i)
//============================================================================



static void Test_aF_BFu9ll_BFu32ll()
{
  {
    init_simple_test("aF_BFu9ll_BFu32ll");
    static STRUCT_IF_C aF_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "aF_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "aF_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu32ll, aF_BFu9ll_BFu32ll)
//============================================================================



static void Test_aF_BFu9ll_BFu33()
{
  {
    init_simple_test("aF_BFu9ll_BFu33");
    static STRUCT_IF_C aF_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, 1, "aF_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, hide_ull(1LL<<32), "aF_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu33, aF_BFu9ll_BFu33)
//============================================================================



static void Test_aF_BFu9ll_BFu7c()
{
  {
    init_simple_test("aF_BFu9ll_BFu7c");
    static STRUCT_IF_C aF_BFu9ll_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aF_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aF_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu7c, aF_BFu9ll_BFu7c)
//============================================================================



static void Test_aF_BFu9ll_BFu7i()
{
  {
    init_simple_test("aF_BFu9ll_BFu7i");
    static STRUCT_IF_C aF_BFu9ll_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aF_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aF_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu7i, aF_BFu9ll_BFu7i)
//============================================================================



static void Test_aF_BFu9ll_BFu7ll()
{
  {
    init_simple_test("aF_BFu9ll_BFu7ll");
    static STRUCT_IF_C aF_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aF_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aF_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu7ll, aF_BFu9ll_BFu7ll)
//============================================================================



static void Test_aF_BFu9ll_BFu7s()
{
  {
    init_simple_test("aF_BFu9ll_BFu7s");
    static STRUCT_IF_C aF_BFu9ll_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aF_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aF_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu7s, aF_BFu9ll_BFu7s)
//============================================================================



static void Test_aF_BFu9ll_BFu8c()
{
  {
    init_simple_test("aF_BFu9ll_BFu8c");
    static STRUCT_IF_C aF_BFu9ll_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aF_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aF_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu8c, aF_BFu9ll_BFu8c)
//============================================================================



static void Test_aF_BFu9ll_BFu8i()
{
  {
    init_simple_test("aF_BFu9ll_BFu8i");
    static STRUCT_IF_C aF_BFu9ll_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aF_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aF_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu8i, aF_BFu9ll_BFu8i)
//============================================================================



static void Test_aF_BFu9ll_BFu8ll()
{
  {
    init_simple_test("aF_BFu9ll_BFu8ll");
    static STRUCT_IF_C aF_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aF_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aF_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu8ll, aF_BFu9ll_BFu8ll)
//============================================================================



static void Test_aF_BFu9ll_BFu8s()
{
  {
    init_simple_test("aF_BFu9ll_BFu8s");
    static STRUCT_IF_C aF_BFu9ll_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aF_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aF_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu8s, aF_BFu9ll_BFu8s)
//============================================================================



static void Test_aF_BFu9ll_BFu9i()
{
  {
    init_simple_test("aF_BFu9ll_BFu9i");
    static STRUCT_IF_C aF_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aF_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu9i, aF_BFu9ll_BFu9i)
//============================================================================



static void Test_aF_BFu9ll_BFu9ll()
{
  {
    init_simple_test("aF_BFu9ll_BFu9ll");
    static STRUCT_IF_C aF_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aF_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu9ll, aF_BFu9ll_BFu9ll)
//============================================================================



static void Test_aF_BFu9ll_BFu9s()
{
  {
    init_simple_test("aF_BFu9ll_BFu9s");
    static STRUCT_IF_C aF_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aF_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aF_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_BFu9s, aF_BFu9ll_BFu9s)
//============================================================================



static void Test_aF_BFu9ll_C()
{
  {
    init_simple_test("aF_BFu9ll_C");
    static STRUCT_IF_C aF_BFu9ll_C lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_C");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_C");
    check_field_offset(lv, v3, 6, "aF_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_C, aF_BFu9ll_C)
//============================================================================



static void Test_aF_BFu9ll_D()
{
  {
    init_simple_test("aF_BFu9ll_D");
    static STRUCT_IF_C aF_BFu9ll_D lv;
    check2(sizeof(lv), 14, "sizeof(aF_BFu9ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_D");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_D");
    check_field_offset(lv, v3, 6, "aF_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_D, aF_BFu9ll_D)
//============================================================================



static void Test_aF_BFu9ll_F()
{
  {
    init_simple_test("aF_BFu9ll_F");
    static STRUCT_IF_C aF_BFu9ll_F lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_F");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_F");
    check_field_offset(lv, v3, 6, "aF_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_F, aF_BFu9ll_F)
//============================================================================



static void Test_aF_BFu9ll_I()
{
  {
    init_simple_test("aF_BFu9ll_I");
    static STRUCT_IF_C aF_BFu9ll_I lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_I");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_I");
    check_field_offset(lv, v3, 6, "aF_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_I, aF_BFu9ll_I)
//============================================================================



static void Test_aF_BFu9ll_Ip()
{
  {
    init_simple_test("aF_BFu9ll_Ip");
    static STRUCT_IF_C aF_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_BFu9ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_Ip");
    check_field_offset(lv, v3, 6, "aF_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_Ip, aF_BFu9ll_Ip)
//============================================================================



static void Test_aF_BFu9ll_L()
{
  {
    init_simple_test("aF_BFu9ll_L");
    static STRUCT_IF_C aF_BFu9ll_L lv;
    check2(sizeof(lv), 14, "sizeof(aF_BFu9ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_L");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_L");
    check_field_offset(lv, v3, 6, "aF_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_L, aF_BFu9ll_L)
//============================================================================



static void Test_aF_BFu9ll_S()
{
  {
    init_simple_test("aF_BFu9ll_S");
    static STRUCT_IF_C aF_BFu9ll_S lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_S");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_S");
    check_field_offset(lv, v3, 6, "aF_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_S, aF_BFu9ll_S)
//============================================================================



static void Test_aF_BFu9ll_Uc()
{
  {
    init_simple_test("aF_BFu9ll_Uc");
    static STRUCT_IF_C aF_BFu9ll_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_Uc");
    check_field_offset(lv, v3, 6, "aF_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_Uc, aF_BFu9ll_Uc)
//============================================================================



static void Test_aF_BFu9ll_Ui()
{
  {
    init_simple_test("aF_BFu9ll_Ui");
    static STRUCT_IF_C aF_BFu9ll_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_Ui");
    check_field_offset(lv, v3, 6, "aF_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_Ui, aF_BFu9ll_Ui)
//============================================================================



static void Test_aF_BFu9ll_Ul()
{
  {
    init_simple_test("aF_BFu9ll_Ul");
    static STRUCT_IF_C aF_BFu9ll_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aF_BFu9ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_Ul");
    check_field_offset(lv, v3, 6, "aF_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_Ul, aF_BFu9ll_Ul)
//============================================================================



static void Test_aF_BFu9ll_Us()
{
  {
    init_simple_test("aF_BFu9ll_Us");
    static STRUCT_IF_C aF_BFu9ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_Us");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_Us");
    check_field_offset(lv, v3, 6, "aF_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_Us, aF_BFu9ll_Us)
//============================================================================



static void Test_aF_BFu9ll_Vp()
{
  {
    init_simple_test("aF_BFu9ll_Vp");
    static STRUCT_IF_C aF_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_BFu9ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9ll_Vp");
    check_field_offset(lv, v3, 6, "aF_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9ll_Vp, aF_BFu9ll_Vp)
//============================================================================



static void Test_aF_BFu9s()
{
  {
    init_simple_test("aF_BFu9s");
    static STRUCT_IF_C aF_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s, aF_BFu9s)
//============================================================================



static void Test_aF_BFu9s_BFu15i()
{
  {
    init_simple_test("aF_BFu9s_BFu15i");
    static STRUCT_IF_C aF_BFu9s_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aF_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aF_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu15i, aF_BFu9s_BFu15i)
//============================================================================



static void Test_aF_BFu9s_BFu15ll()
{
  {
    init_simple_test("aF_BFu9s_BFu15ll");
    static STRUCT_IF_C aF_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aF_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aF_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu15ll, aF_BFu9s_BFu15ll)
//============================================================================



static void Test_aF_BFu9s_BFu15s()
{
  {
    init_simple_test("aF_BFu9s_BFu15s");
    static STRUCT_IF_C aF_BFu9s_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, 1, "aF_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 5, 1, 15, hide_ull(1LL<<14), "aF_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu15s, aF_BFu9s_BFu15s)
//============================================================================



static void Test_aF_BFu9s_BFu16i()
{
  {
    init_simple_test("aF_BFu9s_BFu16i");
    static STRUCT_IF_C aF_BFu9s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aF_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aF_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu16i, aF_BFu9s_BFu16i)
//============================================================================



static void Test_aF_BFu9s_BFu16ll()
{
  {
    init_simple_test("aF_BFu9s_BFu16ll");
    static STRUCT_IF_C aF_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aF_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aF_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu16ll, aF_BFu9s_BFu16ll)
//============================================================================



static void Test_aF_BFu9s_BFu16s()
{
  {
    init_simple_test("aF_BFu9s_BFu16s");
    static STRUCT_IF_C aF_BFu9s_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, 1, "aF_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 5, 1, 16, hide_ull(1LL<<15), "aF_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu16s, aF_BFu9s_BFu16s)
//============================================================================



static void Test_aF_BFu9s_BFu17i()
{
  {
    init_simple_test("aF_BFu9s_BFu17i");
    static STRUCT_IF_C aF_BFu9s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "aF_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "aF_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu17i, aF_BFu9s_BFu17i)
//============================================================================



static void Test_aF_BFu9s_BFu17ll()
{
  {
    init_simple_test("aF_BFu9s_BFu17ll");
    static STRUCT_IF_C aF_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, 1, "aF_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 5, 1, 17, hide_ull(1LL<<16), "aF_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu17ll, aF_BFu9s_BFu17ll)
//============================================================================



static void Test_aF_BFu9s_BFu1c()
{
  {
    init_simple_test("aF_BFu9s_BFu1c");
    static STRUCT_IF_C aF_BFu9s_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aF_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu1c, aF_BFu9s_BFu1c)
//============================================================================



static void Test_aF_BFu9s_BFu1i()
{
  {
    init_simple_test("aF_BFu9s_BFu1i");
    static STRUCT_IF_C aF_BFu9s_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aF_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu1i, aF_BFu9s_BFu1i)
//============================================================================



static void Test_aF_BFu9s_BFu1ll()
{
  {
    init_simple_test("aF_BFu9s_BFu1ll");
    static STRUCT_IF_C aF_BFu9s_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aF_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu1ll, aF_BFu9s_BFu1ll)
//============================================================================



static void Test_aF_BFu9s_BFu1s()
{
  {
    init_simple_test("aF_BFu9s_BFu1s");
    static STRUCT_IF_C aF_BFu9s_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 5, 1, 1, 1, "aF_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu1s, aF_BFu9s_BFu1s)
//============================================================================



static void Test_aF_BFu9s_BFu31i()
{
  {
    init_simple_test("aF_BFu9s_BFu31i");
    static STRUCT_IF_C aF_BFu9s_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu9s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "aF_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "aF_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu31i, aF_BFu9s_BFu31i)
//============================================================================



static void Test_aF_BFu9s_BFu31ll()
{
  {
    init_simple_test("aF_BFu9s_BFu31ll");
    static STRUCT_IF_C aF_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_BFu9s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, 1, "aF_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 5, 1, 31, hide_ull(1LL<<30), "aF_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu31ll, aF_BFu9s_BFu31ll)
//============================================================================



static void Test_aF_BFu9s_BFu32i()
{
  {
    init_simple_test("aF_BFu9s_BFu32i");
    static STRUCT_IF_C aF_BFu9s_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "aF_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "aF_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu32i, aF_BFu9s_BFu32i)
//============================================================================



static void Test_aF_BFu9s_BFu32ll()
{
  {
    init_simple_test("aF_BFu9s_BFu32ll");
    static STRUCT_IF_C aF_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, 1, "aF_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 5, 1, 32, hide_ull(1LL<<31), "aF_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu32ll, aF_BFu9s_BFu32ll)
//============================================================================



static void Test_aF_BFu9s_BFu33()
{
  {
    init_simple_test("aF_BFu9s_BFu33");
    static STRUCT_IF_C aF_BFu9s_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, 1, "aF_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 5, 1, 33, hide_ull(1LL<<32), "aF_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu33, aF_BFu9s_BFu33)
//============================================================================



static void Test_aF_BFu9s_BFu7c()
{
  {
    init_simple_test("aF_BFu9s_BFu7c");
    static STRUCT_IF_C aF_BFu9s_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aF_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aF_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu7c, aF_BFu9s_BFu7c)
//============================================================================



static void Test_aF_BFu9s_BFu7i()
{
  {
    init_simple_test("aF_BFu9s_BFu7i");
    static STRUCT_IF_C aF_BFu9s_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aF_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aF_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu7i, aF_BFu9s_BFu7i)
//============================================================================



static void Test_aF_BFu9s_BFu7ll()
{
  {
    init_simple_test("aF_BFu9s_BFu7ll");
    static STRUCT_IF_C aF_BFu9s_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aF_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aF_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu7ll, aF_BFu9s_BFu7ll)
//============================================================================



static void Test_aF_BFu9s_BFu7s()
{
  {
    init_simple_test("aF_BFu9s_BFu7s");
    static STRUCT_IF_C aF_BFu9s_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aF_BFu9s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, 1, "aF_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 5, 1, 7, hide_ull(1LL<<6), "aF_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu7s, aF_BFu9s_BFu7s)
//============================================================================



static void Test_aF_BFu9s_BFu8c()
{
  {
    init_simple_test("aF_BFu9s_BFu8c");
    static STRUCT_IF_C aF_BFu9s_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aF_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aF_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu8c, aF_BFu9s_BFu8c)
//============================================================================



static void Test_aF_BFu9s_BFu8i()
{
  {
    init_simple_test("aF_BFu9s_BFu8i");
    static STRUCT_IF_C aF_BFu9s_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aF_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aF_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu8i, aF_BFu9s_BFu8i)
//============================================================================



static void Test_aF_BFu9s_BFu8ll()
{
  {
    init_simple_test("aF_BFu9s_BFu8ll");
    static STRUCT_IF_C aF_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aF_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aF_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu8ll, aF_BFu9s_BFu8ll)
//============================================================================



static void Test_aF_BFu9s_BFu8s()
{
  {
    init_simple_test("aF_BFu9s_BFu8s");
    static STRUCT_IF_C aF_BFu9s_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, 1, "aF_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 5, 1, 8, hide_ull(1LL<<7), "aF_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu8s, aF_BFu9s_BFu8s)
//============================================================================



static void Test_aF_BFu9s_BFu9i()
{
  {
    init_simple_test("aF_BFu9s_BFu9i");
    static STRUCT_IF_C aF_BFu9s_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aF_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu9i, aF_BFu9s_BFu9i)
//============================================================================



static void Test_aF_BFu9s_BFu9ll()
{
  {
    init_simple_test("aF_BFu9s_BFu9ll");
    static STRUCT_IF_C aF_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aF_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu9ll, aF_BFu9s_BFu9ll)
//============================================================================



static void Test_aF_BFu9s_BFu9s()
{
  {
    init_simple_test("aF_BFu9s_BFu9s");
    static STRUCT_IF_C aF_BFu9s_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, 1, "aF_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 5, 1, 9, hide_ull(1LL<<8), "aF_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_BFu9s, aF_BFu9s_BFu9s)
//============================================================================



static void Test_aF_BFu9s_C()
{
  {
    init_simple_test("aF_BFu9s_C");
    static STRUCT_IF_C aF_BFu9s_C lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_C)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_C");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_C");
    check_field_offset(lv, v3, 6, "aF_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_C, aF_BFu9s_C)
//============================================================================



static void Test_aF_BFu9s_D()
{
  {
    init_simple_test("aF_BFu9s_D");
    static STRUCT_IF_C aF_BFu9s_D lv;
    check2(sizeof(lv), 14, "sizeof(aF_BFu9s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_D)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_D");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_D");
    check_field_offset(lv, v3, 6, "aF_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_D, aF_BFu9s_D)
//============================================================================



static void Test_aF_BFu9s_F()
{
  {
    init_simple_test("aF_BFu9s_F");
    static STRUCT_IF_C aF_BFu9s_F lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_F)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_F");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_F");
    check_field_offset(lv, v3, 6, "aF_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_F, aF_BFu9s_F)
//============================================================================



static void Test_aF_BFu9s_I()
{
  {
    init_simple_test("aF_BFu9s_I");
    static STRUCT_IF_C aF_BFu9s_I lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_I)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_I");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_I");
    check_field_offset(lv, v3, 6, "aF_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_I, aF_BFu9s_I)
//============================================================================



static void Test_aF_BFu9s_Ip()
{
  {
    init_simple_test("aF_BFu9s_Ip");
    static STRUCT_IF_C aF_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_BFu9s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_Ip)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_Ip");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_Ip");
    check_field_offset(lv, v3, 6, "aF_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_Ip, aF_BFu9s_Ip)
//============================================================================



static void Test_aF_BFu9s_L()
{
  {
    init_simple_test("aF_BFu9s_L");
    static STRUCT_IF_C aF_BFu9s_L lv;
    check2(sizeof(lv), 14, "sizeof(aF_BFu9s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_L)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_L");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_L");
    check_field_offset(lv, v3, 6, "aF_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_L, aF_BFu9s_L)
//============================================================================



static void Test_aF_BFu9s_S()
{
  {
    init_simple_test("aF_BFu9s_S");
    static STRUCT_IF_C aF_BFu9s_S lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_S)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_S");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_S");
    check_field_offset(lv, v3, 6, "aF_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_S, aF_BFu9s_S)
//============================================================================



static void Test_aF_BFu9s_Uc()
{
  {
    init_simple_test("aF_BFu9s_Uc");
    static STRUCT_IF_C aF_BFu9s_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aF_BFu9s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_Uc)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_Uc");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_Uc");
    check_field_offset(lv, v3, 6, "aF_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_Uc, aF_BFu9s_Uc)
//============================================================================



static void Test_aF_BFu9s_Ui()
{
  {
    init_simple_test("aF_BFu9s_Ui");
    static STRUCT_IF_C aF_BFu9s_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aF_BFu9s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_Ui)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_Ui");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_Ui");
    check_field_offset(lv, v3, 6, "aF_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_Ui, aF_BFu9s_Ui)
//============================================================================



static void Test_aF_BFu9s_Ul()
{
  {
    init_simple_test("aF_BFu9s_Ul");
    static STRUCT_IF_C aF_BFu9s_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aF_BFu9s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_Ul)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_Ul");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_Ul");
    check_field_offset(lv, v3, 6, "aF_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_Ul, aF_BFu9s_Ul)
//============================================================================



static void Test_aF_BFu9s_Us()
{
  {
    init_simple_test("aF_BFu9s_Us");
    static STRUCT_IF_C aF_BFu9s_Us lv;
    check2(sizeof(lv), 8, "sizeof(aF_BFu9s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_Us)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_Us");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_Us");
    check_field_offset(lv, v3, 6, "aF_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_Us, aF_BFu9s_Us)
//============================================================================



static void Test_aF_BFu9s_Vp()
{
  {
    init_simple_test("aF_BFu9s_Vp");
    static STRUCT_IF_C aF_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_BFu9s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_BFu9s_Vp)");
    check_field_offset(lv, v1, 0, "aF_BFu9s_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 9, 1, "aF_BFu9s_Vp");
    set_bf_and_test(lv, v2, 4, 0, 9, hide_ull(1LL<<8), "aF_BFu9s_Vp");
    check_field_offset(lv, v3, 6, "aF_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_BFu9s_Vp, aF_BFu9s_Vp)
//============================================================================



static void Test_aF_C()
{
  {
    init_simple_test("aF_C");
    STRUCT_IF_C aF_C lv;
    check2(sizeof(lv), 5, "sizeof(aF_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C)");
    check_field_offset(lv, v1, 0, "aF_C.v1");
    check_field_offset(lv, v2, 4, "aF_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C, aF_C)
//============================================================================



static void Test_aF_C_BFu15i()
{
  {
    init_simple_test("aF_C_BFu15i");
    static STRUCT_IF_C aF_C_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aF_C_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_C_BFu15i.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_C_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu15i, aF_C_BFu15i)
//============================================================================



static void Test_aF_C_BFu15ll()
{
  {
    init_simple_test("aF_C_BFu15ll");
    static STRUCT_IF_C aF_C_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_C_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_C_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_C_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu15ll, aF_C_BFu15ll)
//============================================================================



static void Test_aF_C_BFu15s()
{
  {
    init_simple_test("aF_C_BFu15s");
    static STRUCT_IF_C aF_C_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aF_C_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_C_BFu15s.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_C_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu15s, aF_C_BFu15s)
//============================================================================



static void Test_aF_C_BFu16i()
{
  {
    init_simple_test("aF_C_BFu16i");
    static STRUCT_IF_C aF_C_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aF_C_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_C_BFu16i.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_C_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu16i, aF_C_BFu16i)
//============================================================================



static void Test_aF_C_BFu16ll()
{
  {
    init_simple_test("aF_C_BFu16ll");
    static STRUCT_IF_C aF_C_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_C_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_C_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_C_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu16ll, aF_C_BFu16ll)
//============================================================================



static void Test_aF_C_BFu16s()
{
  {
    init_simple_test("aF_C_BFu16s");
    static STRUCT_IF_C aF_C_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aF_C_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_C_BFu16s.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_C_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu16s, aF_C_BFu16s)
//============================================================================



static void Test_aF_C_BFu17i()
{
  {
    init_simple_test("aF_C_BFu17i");
    static STRUCT_IF_C aF_C_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aF_C_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_C_BFu17i.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aF_C_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aF_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu17i, aF_C_BFu17i)
//============================================================================



static void Test_aF_C_BFu17ll()
{
  {
    init_simple_test("aF_C_BFu17ll");
    static STRUCT_IF_C aF_C_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_C_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_C_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aF_C_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aF_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu17ll, aF_C_BFu17ll)
//============================================================================



static void Test_aF_C_BFu1c()
{
  {
    init_simple_test("aF_C_BFu1c");
    static STRUCT_IF_C aF_C_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_C_BFu1c.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu1c, aF_C_BFu1c)
//============================================================================



static void Test_aF_C_BFu1i()
{
  {
    init_simple_test("aF_C_BFu1i");
    static STRUCT_IF_C aF_C_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_C_BFu1i.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu1i, aF_C_BFu1i)
//============================================================================



static void Test_aF_C_BFu1ll()
{
  {
    init_simple_test("aF_C_BFu1ll");
    static STRUCT_IF_C aF_C_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_C_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu1ll, aF_C_BFu1ll)
//============================================================================



static void Test_aF_C_BFu1s()
{
  {
    init_simple_test("aF_C_BFu1s");
    static STRUCT_IF_C aF_C_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_C_BFu1s.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu1s, aF_C_BFu1s)
//============================================================================



static void Test_aF_C_BFu31i()
{
  {
    init_simple_test("aF_C_BFu31i");
    static STRUCT_IF_C aF_C_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aF_C_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_C_BFu31i.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aF_C_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aF_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu31i, aF_C_BFu31i)
//============================================================================



static void Test_aF_C_BFu31ll()
{
  {
    init_simple_test("aF_C_BFu31ll");
    static STRUCT_IF_C aF_C_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_C_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_C_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aF_C_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aF_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu31ll, aF_C_BFu31ll)
//============================================================================



static void Test_aF_C_BFu32i()
{
  {
    init_simple_test("aF_C_BFu32i");
    static STRUCT_IF_C aF_C_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aF_C_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_C_BFu32i.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aF_C_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aF_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu32i, aF_C_BFu32i)
//============================================================================



static void Test_aF_C_BFu32ll()
{
  {
    init_simple_test("aF_C_BFu32ll");
    static STRUCT_IF_C aF_C_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_C_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_C_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aF_C_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aF_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu32ll, aF_C_BFu32ll)
//============================================================================



static void Test_aF_C_BFu33()
{
  {
    init_simple_test("aF_C_BFu33");
    static STRUCT_IF_C aF_C_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aF_C_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu33)");
    check_field_offset(lv, v1, 0, "aF_C_BFu33.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aF_C_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aF_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu33, aF_C_BFu33)
//============================================================================



static void Test_aF_C_BFu7c()
{
  {
    init_simple_test("aF_C_BFu7c");
    static STRUCT_IF_C aF_C_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_C_BFu7c.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_C_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu7c, aF_C_BFu7c)
//============================================================================



static void Test_aF_C_BFu7i()
{
  {
    init_simple_test("aF_C_BFu7i");
    static STRUCT_IF_C aF_C_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_C_BFu7i.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_C_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu7i, aF_C_BFu7i)
//============================================================================



static void Test_aF_C_BFu7ll()
{
  {
    init_simple_test("aF_C_BFu7ll");
    static STRUCT_IF_C aF_C_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_C_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_C_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu7ll, aF_C_BFu7ll)
//============================================================================



static void Test_aF_C_BFu7s()
{
  {
    init_simple_test("aF_C_BFu7s");
    static STRUCT_IF_C aF_C_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_C_BFu7s.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_C_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu7s, aF_C_BFu7s)
//============================================================================



static void Test_aF_C_BFu8c()
{
  {
    init_simple_test("aF_C_BFu8c");
    static STRUCT_IF_C aF_C_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_C_BFu8c.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_C_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu8c, aF_C_BFu8c)
//============================================================================



static void Test_aF_C_BFu8i()
{
  {
    init_simple_test("aF_C_BFu8i");
    static STRUCT_IF_C aF_C_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_C_BFu8i.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_C_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu8i, aF_C_BFu8i)
//============================================================================



static void Test_aF_C_BFu8ll()
{
  {
    init_simple_test("aF_C_BFu8ll");
    static STRUCT_IF_C aF_C_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_C_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_C_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu8ll, aF_C_BFu8ll)
//============================================================================



static void Test_aF_C_BFu8s()
{
  {
    init_simple_test("aF_C_BFu8s");
    static STRUCT_IF_C aF_C_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_C_BFu8s.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_C_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu8s, aF_C_BFu8s)
//============================================================================



static void Test_aF_C_BFu9i()
{
  {
    init_simple_test("aF_C_BFu9i");
    static STRUCT_IF_C aF_C_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aF_C_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_C_BFu9i.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_C_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu9i, aF_C_BFu9i)
//============================================================================



static void Test_aF_C_BFu9ll()
{
  {
    init_simple_test("aF_C_BFu9ll");
    static STRUCT_IF_C aF_C_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_C_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_C_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_C_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu9ll, aF_C_BFu9ll)
//============================================================================



static void Test_aF_C_BFu9s()
{
  {
    init_simple_test("aF_C_BFu9s");
    static STRUCT_IF_C aF_C_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aF_C_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_C_BFu9s.v1");
    check_field_offset(lv, v2, 4, "aF_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_C_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_BFu9s, aF_C_BFu9s)
//============================================================================



static void Test_aF_C_C()
{
  {
    init_simple_test("aF_C_C");
    STRUCT_IF_C aF_C_C lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_C)");
    check_field_offset(lv, v1, 0, "aF_C_C.v1");
    check_field_offset(lv, v2, 4, "aF_C_C.v2");
    check_field_offset(lv, v3, 5, "aF_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_C, aF_C_C)
//============================================================================



static void Test_aF_C_D()
{
  {
    init_simple_test("aF_C_D");
    STRUCT_IF_C aF_C_D lv;
    check2(sizeof(lv), 13, "sizeof(aF_C_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_D)");
    check_field_offset(lv, v1, 0, "aF_C_D.v1");
    check_field_offset(lv, v2, 4, "aF_C_D.v2");
    check_field_offset(lv, v3, 5, "aF_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_D, aF_C_D)
//============================================================================



static void Test_aF_C_F()
{
  {
    init_simple_test("aF_C_F");
    STRUCT_IF_C aF_C_F lv;
    check2(sizeof(lv), 9, "sizeof(aF_C_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_F)");
    check_field_offset(lv, v1, 0, "aF_C_F.v1");
    check_field_offset(lv, v2, 4, "aF_C_F.v2");
    check_field_offset(lv, v3, 5, "aF_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_F, aF_C_F)
//============================================================================



static void Test_aF_C_I()
{
  {
    init_simple_test("aF_C_I");
    STRUCT_IF_C aF_C_I lv;
    check2(sizeof(lv), 9, "sizeof(aF_C_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_I)");
    check_field_offset(lv, v1, 0, "aF_C_I.v1");
    check_field_offset(lv, v2, 4, "aF_C_I.v2");
    check_field_offset(lv, v3, 5, "aF_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_I, aF_C_I)
//============================================================================



static void Test_aF_C_Ip()
{
  {
    init_simple_test("aF_C_Ip");
    STRUCT_IF_C aF_C_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_C_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_Ip)");
    check_field_offset(lv, v1, 0, "aF_C_Ip.v1");
    check_field_offset(lv, v2, 4, "aF_C_Ip.v2");
    check_field_offset(lv, v3, 5, "aF_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_Ip, aF_C_Ip)
//============================================================================



static void Test_aF_C_L()
{
  {
    init_simple_test("aF_C_L");
    STRUCT_IF_C aF_C_L lv;
    check2(sizeof(lv), 13, "sizeof(aF_C_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_L)");
    check_field_offset(lv, v1, 0, "aF_C_L.v1");
    check_field_offset(lv, v2, 4, "aF_C_L.v2");
    check_field_offset(lv, v3, 5, "aF_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_L, aF_C_L)
//============================================================================



static void Test_aF_C_S()
{
  {
    init_simple_test("aF_C_S");
    STRUCT_IF_C aF_C_S lv;
    check2(sizeof(lv), 7, "sizeof(aF_C_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_S)");
    check_field_offset(lv, v1, 0, "aF_C_S.v1");
    check_field_offset(lv, v2, 4, "aF_C_S.v2");
    check_field_offset(lv, v3, 5, "aF_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_S, aF_C_S)
//============================================================================



static void Test_aF_C_Uc()
{
  {
    init_simple_test("aF_C_Uc");
    STRUCT_IF_C aF_C_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aF_C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_Uc)");
    check_field_offset(lv, v1, 0, "aF_C_Uc.v1");
    check_field_offset(lv, v2, 4, "aF_C_Uc.v2");
    check_field_offset(lv, v3, 5, "aF_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_Uc, aF_C_Uc)
//============================================================================



static void Test_aF_C_Ui()
{
  {
    init_simple_test("aF_C_Ui");
    STRUCT_IF_C aF_C_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aF_C_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_Ui)");
    check_field_offset(lv, v1, 0, "aF_C_Ui.v1");
    check_field_offset(lv, v2, 4, "aF_C_Ui.v2");
    check_field_offset(lv, v3, 5, "aF_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_Ui, aF_C_Ui)
//============================================================================



static void Test_aF_C_Ul()
{
  {
    init_simple_test("aF_C_Ul");
    STRUCT_IF_C aF_C_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aF_C_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_Ul)");
    check_field_offset(lv, v1, 0, "aF_C_Ul.v1");
    check_field_offset(lv, v2, 4, "aF_C_Ul.v2");
    check_field_offset(lv, v3, 5, "aF_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_Ul, aF_C_Ul)
//============================================================================



static void Test_aF_C_Us()
{
  {
    init_simple_test("aF_C_Us");
    STRUCT_IF_C aF_C_Us lv;
    check2(sizeof(lv), 7, "sizeof(aF_C_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_Us)");
    check_field_offset(lv, v1, 0, "aF_C_Us.v1");
    check_field_offset(lv, v2, 4, "aF_C_Us.v2");
    check_field_offset(lv, v3, 5, "aF_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_Us, aF_C_Us)
//============================================================================



static void Test_aF_C_Vp()
{
  {
    init_simple_test("aF_C_Vp");
    STRUCT_IF_C aF_C_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_C_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_C_Vp)");
    check_field_offset(lv, v1, 0, "aF_C_Vp.v1");
    check_field_offset(lv, v2, 4, "aF_C_Vp.v2");
    check_field_offset(lv, v3, 5, "aF_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_C_Vp, aF_C_Vp)
//============================================================================



static void Test_aF_D()
{
  {
    init_simple_test("aF_D");
    STRUCT_IF_C aF_D lv;
    check2(sizeof(lv), 12, "sizeof(aF_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D)");
    check_field_offset(lv, v1, 0, "aF_D.v1");
    check_field_offset(lv, v2, 4, "aF_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D, aF_D)
//============================================================================



static void Test_aF_D_BFu15i()
{
  {
    init_simple_test("aF_D_BFu15i");
    static STRUCT_IF_C aF_D_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(aF_D_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_D_BFu15i.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aF_D_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aF_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu15i, aF_D_BFu15i)
//============================================================================



static void Test_aF_D_BFu15ll()
{
  {
    init_simple_test("aF_D_BFu15ll");
    static STRUCT_IF_C aF_D_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(aF_D_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_D_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aF_D_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aF_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu15ll, aF_D_BFu15ll)
//============================================================================



static void Test_aF_D_BFu15s()
{
  {
    init_simple_test("aF_D_BFu15s");
    static STRUCT_IF_C aF_D_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(aF_D_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_D_BFu15s.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aF_D_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aF_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu15s, aF_D_BFu15s)
//============================================================================



static void Test_aF_D_BFu16i()
{
  {
    init_simple_test("aF_D_BFu16i");
    static STRUCT_IF_C aF_D_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(aF_D_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_D_BFu16i.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aF_D_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aF_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu16i, aF_D_BFu16i)
//============================================================================



static void Test_aF_D_BFu16ll()
{
  {
    init_simple_test("aF_D_BFu16ll");
    static STRUCT_IF_C aF_D_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(aF_D_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_D_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aF_D_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aF_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu16ll, aF_D_BFu16ll)
//============================================================================



static void Test_aF_D_BFu16s()
{
  {
    init_simple_test("aF_D_BFu16s");
    static STRUCT_IF_C aF_D_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(aF_D_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_D_BFu16s.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aF_D_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aF_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu16s, aF_D_BFu16s)
//============================================================================



static void Test_aF_D_BFu17i()
{
  {
    init_simple_test("aF_D_BFu17i");
    static STRUCT_IF_C aF_D_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(aF_D_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_D_BFu17i.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aF_D_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aF_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu17i, aF_D_BFu17i)
//============================================================================



static void Test_aF_D_BFu17ll()
{
  {
    init_simple_test("aF_D_BFu17ll");
    static STRUCT_IF_C aF_D_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(aF_D_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_D_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aF_D_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aF_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu17ll, aF_D_BFu17ll)
//============================================================================



static void Test_aF_D_BFu1c()
{
  {
    init_simple_test("aF_D_BFu1c");
    static STRUCT_IF_C aF_D_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_D_BFu1c.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aF_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu1c, aF_D_BFu1c)
//============================================================================



static void Test_aF_D_BFu1i()
{
  {
    init_simple_test("aF_D_BFu1i");
    static STRUCT_IF_C aF_D_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_D_BFu1i.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aF_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu1i, aF_D_BFu1i)
//============================================================================



static void Test_aF_D_BFu1ll()
{
  {
    init_simple_test("aF_D_BFu1ll");
    static STRUCT_IF_C aF_D_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_D_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aF_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu1ll, aF_D_BFu1ll)
//============================================================================



static void Test_aF_D_BFu1s()
{
  {
    init_simple_test("aF_D_BFu1s");
    static STRUCT_IF_C aF_D_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_D_BFu1s.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aF_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu1s, aF_D_BFu1s)
//============================================================================



static void Test_aF_D_BFu31i()
{
  {
    init_simple_test("aF_D_BFu31i");
    static STRUCT_IF_C aF_D_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(aF_D_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_D_BFu31i.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aF_D_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aF_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu31i, aF_D_BFu31i)
//============================================================================



static void Test_aF_D_BFu31ll()
{
  {
    init_simple_test("aF_D_BFu31ll");
    static STRUCT_IF_C aF_D_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(aF_D_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_D_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aF_D_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aF_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu31ll, aF_D_BFu31ll)
//============================================================================



static void Test_aF_D_BFu32i()
{
  {
    init_simple_test("aF_D_BFu32i");
    static STRUCT_IF_C aF_D_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(aF_D_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_D_BFu32i.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aF_D_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aF_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu32i, aF_D_BFu32i)
//============================================================================



static void Test_aF_D_BFu32ll()
{
  {
    init_simple_test("aF_D_BFu32ll");
    static STRUCT_IF_C aF_D_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(aF_D_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_D_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aF_D_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aF_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu32ll, aF_D_BFu32ll)
//============================================================================



static void Test_aF_D_BFu33()
{
  {
    init_simple_test("aF_D_BFu33");
    static STRUCT_IF_C aF_D_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(aF_D_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu33)");
    check_field_offset(lv, v1, 0, "aF_D_BFu33.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu33.v2");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "aF_D_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "aF_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu33, aF_D_BFu33)
//============================================================================



static void Test_aF_D_BFu7c()
{
  {
    init_simple_test("aF_D_BFu7c");
    static STRUCT_IF_C aF_D_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_D_BFu7c.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aF_D_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aF_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu7c, aF_D_BFu7c)
//============================================================================



static void Test_aF_D_BFu7i()
{
  {
    init_simple_test("aF_D_BFu7i");
    static STRUCT_IF_C aF_D_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_D_BFu7i.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aF_D_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aF_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu7i, aF_D_BFu7i)
//============================================================================



static void Test_aF_D_BFu7ll()
{
  {
    init_simple_test("aF_D_BFu7ll");
    static STRUCT_IF_C aF_D_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_D_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aF_D_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aF_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu7ll, aF_D_BFu7ll)
//============================================================================



static void Test_aF_D_BFu7s()
{
  {
    init_simple_test("aF_D_BFu7s");
    static STRUCT_IF_C aF_D_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_D_BFu7s.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aF_D_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aF_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu7s, aF_D_BFu7s)
//============================================================================



static void Test_aF_D_BFu8c()
{
  {
    init_simple_test("aF_D_BFu8c");
    static STRUCT_IF_C aF_D_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_D_BFu8c.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aF_D_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aF_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu8c, aF_D_BFu8c)
//============================================================================



static void Test_aF_D_BFu8i()
{
  {
    init_simple_test("aF_D_BFu8i");
    static STRUCT_IF_C aF_D_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_D_BFu8i.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aF_D_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aF_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu8i, aF_D_BFu8i)
//============================================================================



static void Test_aF_D_BFu8ll()
{
  {
    init_simple_test("aF_D_BFu8ll");
    static STRUCT_IF_C aF_D_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_D_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aF_D_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aF_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu8ll, aF_D_BFu8ll)
//============================================================================



static void Test_aF_D_BFu8s()
{
  {
    init_simple_test("aF_D_BFu8s");
    static STRUCT_IF_C aF_D_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_D_BFu8s.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aF_D_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aF_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu8s, aF_D_BFu8s)
//============================================================================



static void Test_aF_D_BFu9i()
{
  {
    init_simple_test("aF_D_BFu9i");
    static STRUCT_IF_C aF_D_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(aF_D_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_D_BFu9i.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aF_D_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aF_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu9i, aF_D_BFu9i)
//============================================================================



static void Test_aF_D_BFu9ll()
{
  {
    init_simple_test("aF_D_BFu9ll");
    static STRUCT_IF_C aF_D_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(aF_D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_D_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aF_D_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aF_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu9ll, aF_D_BFu9ll)
//============================================================================



static void Test_aF_D_BFu9s()
{
  {
    init_simple_test("aF_D_BFu9s");
    static STRUCT_IF_C aF_D_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(aF_D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_D_BFu9s.v1");
    check_field_offset(lv, v2, 4, "aF_D_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aF_D_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aF_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_BFu9s, aF_D_BFu9s)
//============================================================================



static void Test_aF_D_C()
{
  {
    init_simple_test("aF_D_C");
    STRUCT_IF_C aF_D_C lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_C)");
    check_field_offset(lv, v1, 0, "aF_D_C.v1");
    check_field_offset(lv, v2, 4, "aF_D_C.v2");
    check_field_offset(lv, v3, 12, "aF_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_C, aF_D_C)
//============================================================================



static void Test_aF_D_D()
{
  {
    init_simple_test("aF_D_D");
    STRUCT_IF_C aF_D_D lv;
    check2(sizeof(lv), 20, "sizeof(aF_D_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_D)");
    check_field_offset(lv, v1, 0, "aF_D_D.v1");
    check_field_offset(lv, v2, 4, "aF_D_D.v2");
    check_field_offset(lv, v3, 12, "aF_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_D, aF_D_D)
//============================================================================



static void Test_aF_D_F()
{
  {
    init_simple_test("aF_D_F");
    STRUCT_IF_C aF_D_F lv;
    check2(sizeof(lv), 16, "sizeof(aF_D_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_F)");
    check_field_offset(lv, v1, 0, "aF_D_F.v1");
    check_field_offset(lv, v2, 4, "aF_D_F.v2");
    check_field_offset(lv, v3, 12, "aF_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_F, aF_D_F)
//============================================================================



static void Test_aF_D_I()
{
  {
    init_simple_test("aF_D_I");
    STRUCT_IF_C aF_D_I lv;
    check2(sizeof(lv), 16, "sizeof(aF_D_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_I)");
    check_field_offset(lv, v1, 0, "aF_D_I.v1");
    check_field_offset(lv, v2, 4, "aF_D_I.v2");
    check_field_offset(lv, v3, 12, "aF_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_I, aF_D_I)
//============================================================================



static void Test_aF_D_Ip()
{
  {
    init_simple_test("aF_D_Ip");
    STRUCT_IF_C aF_D_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aF_D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_Ip)");
    check_field_offset(lv, v1, 0, "aF_D_Ip.v1");
    check_field_offset(lv, v2, 4, "aF_D_Ip.v2");
    check_field_offset(lv, v3, 12, "aF_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_Ip, aF_D_Ip)
//============================================================================



static void Test_aF_D_L()
{
  {
    init_simple_test("aF_D_L");
    STRUCT_IF_C aF_D_L lv;
    check2(sizeof(lv), 20, "sizeof(aF_D_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_L)");
    check_field_offset(lv, v1, 0, "aF_D_L.v1");
    check_field_offset(lv, v2, 4, "aF_D_L.v2");
    check_field_offset(lv, v3, 12, "aF_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_L, aF_D_L)
//============================================================================



static void Test_aF_D_S()
{
  {
    init_simple_test("aF_D_S");
    STRUCT_IF_C aF_D_S lv;
    check2(sizeof(lv), 14, "sizeof(aF_D_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_S)");
    check_field_offset(lv, v1, 0, "aF_D_S.v1");
    check_field_offset(lv, v2, 4, "aF_D_S.v2");
    check_field_offset(lv, v3, 12, "aF_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_S, aF_D_S)
//============================================================================



static void Test_aF_D_Uc()
{
  {
    init_simple_test("aF_D_Uc");
    STRUCT_IF_C aF_D_Uc lv;
    check2(sizeof(lv), 13, "sizeof(aF_D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_Uc)");
    check_field_offset(lv, v1, 0, "aF_D_Uc.v1");
    check_field_offset(lv, v2, 4, "aF_D_Uc.v2");
    check_field_offset(lv, v3, 12, "aF_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_Uc, aF_D_Uc)
//============================================================================



static void Test_aF_D_Ui()
{
  {
    init_simple_test("aF_D_Ui");
    STRUCT_IF_C aF_D_Ui lv;
    check2(sizeof(lv), 16, "sizeof(aF_D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_Ui)");
    check_field_offset(lv, v1, 0, "aF_D_Ui.v1");
    check_field_offset(lv, v2, 4, "aF_D_Ui.v2");
    check_field_offset(lv, v3, 12, "aF_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_Ui, aF_D_Ui)
//============================================================================



static void Test_aF_D_Ul()
{
  {
    init_simple_test("aF_D_Ul");
    STRUCT_IF_C aF_D_Ul lv;
    check2(sizeof(lv), 20, "sizeof(aF_D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_Ul)");
    check_field_offset(lv, v1, 0, "aF_D_Ul.v1");
    check_field_offset(lv, v2, 4, "aF_D_Ul.v2");
    check_field_offset(lv, v3, 12, "aF_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_Ul, aF_D_Ul)
//============================================================================



static void Test_aF_D_Us()
{
  {
    init_simple_test("aF_D_Us");
    STRUCT_IF_C aF_D_Us lv;
    check2(sizeof(lv), 14, "sizeof(aF_D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_Us)");
    check_field_offset(lv, v1, 0, "aF_D_Us.v1");
    check_field_offset(lv, v2, 4, "aF_D_Us.v2");
    check_field_offset(lv, v3, 12, "aF_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_Us, aF_D_Us)
//============================================================================



static void Test_aF_D_Vp()
{
  {
    init_simple_test("aF_D_Vp");
    STRUCT_IF_C aF_D_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aF_D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_D_Vp)");
    check_field_offset(lv, v1, 0, "aF_D_Vp.v1");
    check_field_offset(lv, v2, 4, "aF_D_Vp.v2");
    check_field_offset(lv, v3, 12, "aF_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_D_Vp, aF_D_Vp)
//============================================================================



static void Test_aF_F()
{
  {
    init_simple_test("aF_F");
    STRUCT_IF_C aF_F lv;
    check2(sizeof(lv), 8, "sizeof(aF_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F)");
    check_field_offset(lv, v1, 0, "aF_F.v1");
    check_field_offset(lv, v2, 4, "aF_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F, aF_F)
//============================================================================



static void Test_aF_F_BFu15i()
{
  {
    init_simple_test("aF_F_BFu15i");
    static STRUCT_IF_C aF_F_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aF_F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_F_BFu15i.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_F_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu15i, aF_F_BFu15i)
//============================================================================



static void Test_aF_F_BFu15ll()
{
  {
    init_simple_test("aF_F_BFu15ll");
    static STRUCT_IF_C aF_F_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_F_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_F_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu15ll, aF_F_BFu15ll)
//============================================================================



static void Test_aF_F_BFu15s()
{
  {
    init_simple_test("aF_F_BFu15s");
    static STRUCT_IF_C aF_F_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aF_F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_F_BFu15s.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_F_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu15s, aF_F_BFu15s)
//============================================================================



static void Test_aF_F_BFu16i()
{
  {
    init_simple_test("aF_F_BFu16i");
    static STRUCT_IF_C aF_F_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aF_F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_F_BFu16i.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_F_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu16i, aF_F_BFu16i)
//============================================================================



static void Test_aF_F_BFu16ll()
{
  {
    init_simple_test("aF_F_BFu16ll");
    static STRUCT_IF_C aF_F_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_F_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_F_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu16ll, aF_F_BFu16ll)
//============================================================================



static void Test_aF_F_BFu16s()
{
  {
    init_simple_test("aF_F_BFu16s");
    static STRUCT_IF_C aF_F_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aF_F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_F_BFu16s.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_F_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu16s, aF_F_BFu16s)
//============================================================================



static void Test_aF_F_BFu17i()
{
  {
    init_simple_test("aF_F_BFu17i");
    static STRUCT_IF_C aF_F_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(aF_F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_F_BFu17i.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aF_F_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aF_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu17i, aF_F_BFu17i)
//============================================================================



static void Test_aF_F_BFu17ll()
{
  {
    init_simple_test("aF_F_BFu17ll");
    static STRUCT_IF_C aF_F_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(aF_F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_F_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aF_F_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aF_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu17ll, aF_F_BFu17ll)
//============================================================================



static void Test_aF_F_BFu1c()
{
  {
    init_simple_test("aF_F_BFu1c");
    static STRUCT_IF_C aF_F_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_F_BFu1c.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu1c, aF_F_BFu1c)
//============================================================================



static void Test_aF_F_BFu1i()
{
  {
    init_simple_test("aF_F_BFu1i");
    static STRUCT_IF_C aF_F_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_F_BFu1i.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu1i, aF_F_BFu1i)
//============================================================================



static void Test_aF_F_BFu1ll()
{
  {
    init_simple_test("aF_F_BFu1ll");
    static STRUCT_IF_C aF_F_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_F_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu1ll, aF_F_BFu1ll)
//============================================================================



static void Test_aF_F_BFu1s()
{
  {
    init_simple_test("aF_F_BFu1s");
    static STRUCT_IF_C aF_F_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_F_BFu1s.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu1s, aF_F_BFu1s)
//============================================================================



static void Test_aF_F_BFu31i()
{
  {
    init_simple_test("aF_F_BFu31i");
    static STRUCT_IF_C aF_F_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aF_F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_F_BFu31i.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "aF_F_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "aF_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu31i, aF_F_BFu31i)
//============================================================================



static void Test_aF_F_BFu31ll()
{
  {
    init_simple_test("aF_F_BFu31ll");
    static STRUCT_IF_C aF_F_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_F_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "aF_F_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "aF_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu31ll, aF_F_BFu31ll)
//============================================================================



static void Test_aF_F_BFu32i()
{
  {
    init_simple_test("aF_F_BFu32i");
    static STRUCT_IF_C aF_F_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(aF_F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_F_BFu32i.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "aF_F_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "aF_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu32i, aF_F_BFu32i)
//============================================================================



static void Test_aF_F_BFu32ll()
{
  {
    init_simple_test("aF_F_BFu32ll");
    static STRUCT_IF_C aF_F_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_F_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "aF_F_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "aF_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu32ll, aF_F_BFu32ll)
//============================================================================



static void Test_aF_F_BFu33()
{
  {
    init_simple_test("aF_F_BFu33");
    static STRUCT_IF_C aF_F_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(aF_F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu33)");
    check_field_offset(lv, v1, 0, "aF_F_BFu33.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "aF_F_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "aF_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu33, aF_F_BFu33)
//============================================================================



static void Test_aF_F_BFu7c()
{
  {
    init_simple_test("aF_F_BFu7c");
    static STRUCT_IF_C aF_F_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_F_BFu7c.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_F_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu7c, aF_F_BFu7c)
//============================================================================



static void Test_aF_F_BFu7i()
{
  {
    init_simple_test("aF_F_BFu7i");
    static STRUCT_IF_C aF_F_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_F_BFu7i.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_F_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu7i, aF_F_BFu7i)
//============================================================================



static void Test_aF_F_BFu7ll()
{
  {
    init_simple_test("aF_F_BFu7ll");
    static STRUCT_IF_C aF_F_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_F_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_F_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu7ll, aF_F_BFu7ll)
//============================================================================



static void Test_aF_F_BFu7s()
{
  {
    init_simple_test("aF_F_BFu7s");
    static STRUCT_IF_C aF_F_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_F_BFu7s.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_F_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu7s, aF_F_BFu7s)
//============================================================================



static void Test_aF_F_BFu8c()
{
  {
    init_simple_test("aF_F_BFu8c");
    static STRUCT_IF_C aF_F_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_F_BFu8c.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_F_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu8c, aF_F_BFu8c)
//============================================================================



static void Test_aF_F_BFu8i()
{
  {
    init_simple_test("aF_F_BFu8i");
    static STRUCT_IF_C aF_F_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_F_BFu8i.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_F_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu8i, aF_F_BFu8i)
//============================================================================



static void Test_aF_F_BFu8ll()
{
  {
    init_simple_test("aF_F_BFu8ll");
    static STRUCT_IF_C aF_F_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_F_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_F_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu8ll, aF_F_BFu8ll)
//============================================================================



static void Test_aF_F_BFu8s()
{
  {
    init_simple_test("aF_F_BFu8s");
    static STRUCT_IF_C aF_F_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_F_BFu8s.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_F_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu8s, aF_F_BFu8s)
//============================================================================



static void Test_aF_F_BFu9i()
{
  {
    init_simple_test("aF_F_BFu9i");
    static STRUCT_IF_C aF_F_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(aF_F_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_F_BFu9i.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_F_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu9i, aF_F_BFu9i)
//============================================================================



static void Test_aF_F_BFu9ll()
{
  {
    init_simple_test("aF_F_BFu9ll");
    static STRUCT_IF_C aF_F_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_F_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_F_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_F_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu9ll, aF_F_BFu9ll)
//============================================================================



static void Test_aF_F_BFu9s()
{
  {
    init_simple_test("aF_F_BFu9s");
    static STRUCT_IF_C aF_F_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(aF_F_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_F_BFu9s.v1");
    check_field_offset(lv, v2, 4, "aF_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_F_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_BFu9s, aF_F_BFu9s)
//============================================================================



static void Test_aF_F_C()
{
  {
    init_simple_test("aF_F_C");
    STRUCT_IF_C aF_F_C lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_C)");
    check_field_offset(lv, v1, 0, "aF_F_C.v1");
    check_field_offset(lv, v2, 4, "aF_F_C.v2");
    check_field_offset(lv, v3, 8, "aF_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_C, aF_F_C)
//============================================================================



static void Test_aF_F_D()
{
  {
    init_simple_test("aF_F_D");
    STRUCT_IF_C aF_F_D lv;
    check2(sizeof(lv), 16, "sizeof(aF_F_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_D)");
    check_field_offset(lv, v1, 0, "aF_F_D.v1");
    check_field_offset(lv, v2, 4, "aF_F_D.v2");
    check_field_offset(lv, v3, 8, "aF_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_D, aF_F_D)
//============================================================================



static void Test_aF_F_F()
{
  {
    init_simple_test("aF_F_F");
    STRUCT_IF_C aF_F_F lv;
    check2(sizeof(lv), 12, "sizeof(aF_F_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_F)");
    check_field_offset(lv, v1, 0, "aF_F_F.v1");
    check_field_offset(lv, v2, 4, "aF_F_F.v2");
    check_field_offset(lv, v3, 8, "aF_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_F, aF_F_F)
//============================================================================



static void Test_aF_F_I()
{
  {
    init_simple_test("aF_F_I");
    STRUCT_IF_C aF_F_I lv;
    check2(sizeof(lv), 12, "sizeof(aF_F_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_I)");
    check_field_offset(lv, v1, 0, "aF_F_I.v1");
    check_field_offset(lv, v2, 4, "aF_F_I.v2");
    check_field_offset(lv, v3, 8, "aF_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_I, aF_F_I)
//============================================================================



static void Test_aF_F_Ip()
{
  {
    init_simple_test("aF_F_Ip");
    STRUCT_IF_C aF_F_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_F_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_Ip)");
    check_field_offset(lv, v1, 0, "aF_F_Ip.v1");
    check_field_offset(lv, v2, 4, "aF_F_Ip.v2");
    check_field_offset(lv, v3, 8, "aF_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_Ip, aF_F_Ip)
//============================================================================



static void Test_aF_F_L()
{
  {
    init_simple_test("aF_F_L");
    STRUCT_IF_C aF_F_L lv;
    check2(sizeof(lv), 16, "sizeof(aF_F_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_L)");
    check_field_offset(lv, v1, 0, "aF_F_L.v1");
    check_field_offset(lv, v2, 4, "aF_F_L.v2");
    check_field_offset(lv, v3, 8, "aF_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_L, aF_F_L)
//============================================================================



static void Test_aF_F_S()
{
  {
    init_simple_test("aF_F_S");
    STRUCT_IF_C aF_F_S lv;
    check2(sizeof(lv), 10, "sizeof(aF_F_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_S)");
    check_field_offset(lv, v1, 0, "aF_F_S.v1");
    check_field_offset(lv, v2, 4, "aF_F_S.v2");
    check_field_offset(lv, v3, 8, "aF_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_S, aF_F_S)
//============================================================================



static void Test_aF_F_Uc()
{
  {
    init_simple_test("aF_F_Uc");
    STRUCT_IF_C aF_F_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aF_F_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_Uc)");
    check_field_offset(lv, v1, 0, "aF_F_Uc.v1");
    check_field_offset(lv, v2, 4, "aF_F_Uc.v2");
    check_field_offset(lv, v3, 8, "aF_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_Uc, aF_F_Uc)
//============================================================================



static void Test_aF_F_Ui()
{
  {
    init_simple_test("aF_F_Ui");
    STRUCT_IF_C aF_F_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aF_F_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_Ui)");
    check_field_offset(lv, v1, 0, "aF_F_Ui.v1");
    check_field_offset(lv, v2, 4, "aF_F_Ui.v2");
    check_field_offset(lv, v3, 8, "aF_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_Ui, aF_F_Ui)
//============================================================================



static void Test_aF_F_Ul()
{
  {
    init_simple_test("aF_F_Ul");
    STRUCT_IF_C aF_F_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aF_F_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_Ul)");
    check_field_offset(lv, v1, 0, "aF_F_Ul.v1");
    check_field_offset(lv, v2, 4, "aF_F_Ul.v2");
    check_field_offset(lv, v3, 8, "aF_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_Ul, aF_F_Ul)
//============================================================================



static void Test_aF_F_Us()
{
  {
    init_simple_test("aF_F_Us");
    STRUCT_IF_C aF_F_Us lv;
    check2(sizeof(lv), 10, "sizeof(aF_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_Us)");
    check_field_offset(lv, v1, 0, "aF_F_Us.v1");
    check_field_offset(lv, v2, 4, "aF_F_Us.v2");
    check_field_offset(lv, v3, 8, "aF_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_Us, aF_F_Us)
//============================================================================



static void Test_aF_F_Vp()
{
  {
    init_simple_test("aF_F_Vp");
    STRUCT_IF_C aF_F_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_F_Vp)");
    check_field_offset(lv, v1, 0, "aF_F_Vp.v1");
    check_field_offset(lv, v2, 4, "aF_F_Vp.v2");
    check_field_offset(lv, v3, 8, "aF_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_F_Vp, aF_F_Vp)
//============================================================================



static void Test_aF_I()
{
  {
    init_simple_test("aF_I");
    STRUCT_IF_C aF_I lv;
    check2(sizeof(lv), 8, "sizeof(aF_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I)");
    check_field_offset(lv, v1, 0, "aF_I.v1");
    check_field_offset(lv, v2, 4, "aF_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I, aF_I)
//============================================================================



static void Test_aF_I_BFu15i()
{
  {
    init_simple_test("aF_I_BFu15i");
    static STRUCT_IF_C aF_I_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aF_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_I_BFu15i.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_I_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu15i, aF_I_BFu15i)
//============================================================================



static void Test_aF_I_BFu15ll()
{
  {
    init_simple_test("aF_I_BFu15ll");
    static STRUCT_IF_C aF_I_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_I_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_I_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu15ll, aF_I_BFu15ll)
//============================================================================



static void Test_aF_I_BFu15s()
{
  {
    init_simple_test("aF_I_BFu15s");
    static STRUCT_IF_C aF_I_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aF_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_I_BFu15s.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_I_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu15s, aF_I_BFu15s)
//============================================================================



static void Test_aF_I_BFu16i()
{
  {
    init_simple_test("aF_I_BFu16i");
    static STRUCT_IF_C aF_I_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aF_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_I_BFu16i.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_I_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu16i, aF_I_BFu16i)
//============================================================================



static void Test_aF_I_BFu16ll()
{
  {
    init_simple_test("aF_I_BFu16ll");
    static STRUCT_IF_C aF_I_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_I_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_I_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu16ll, aF_I_BFu16ll)
//============================================================================



static void Test_aF_I_BFu16s()
{
  {
    init_simple_test("aF_I_BFu16s");
    static STRUCT_IF_C aF_I_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aF_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_I_BFu16s.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_I_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu16s, aF_I_BFu16s)
//============================================================================



static void Test_aF_I_BFu17i()
{
  {
    init_simple_test("aF_I_BFu17i");
    static STRUCT_IF_C aF_I_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(aF_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_I_BFu17i.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aF_I_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aF_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu17i, aF_I_BFu17i)
//============================================================================



static void Test_aF_I_BFu17ll()
{
  {
    init_simple_test("aF_I_BFu17ll");
    static STRUCT_IF_C aF_I_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(aF_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_I_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aF_I_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aF_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu17ll, aF_I_BFu17ll)
//============================================================================



static void Test_aF_I_BFu1c()
{
  {
    init_simple_test("aF_I_BFu1c");
    static STRUCT_IF_C aF_I_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_I_BFu1c.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu1c, aF_I_BFu1c)
//============================================================================



static void Test_aF_I_BFu1i()
{
  {
    init_simple_test("aF_I_BFu1i");
    static STRUCT_IF_C aF_I_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_I_BFu1i.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu1i, aF_I_BFu1i)
//============================================================================



static void Test_aF_I_BFu1ll()
{
  {
    init_simple_test("aF_I_BFu1ll");
    static STRUCT_IF_C aF_I_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_I_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu1ll, aF_I_BFu1ll)
//============================================================================



static void Test_aF_I_BFu1s()
{
  {
    init_simple_test("aF_I_BFu1s");
    static STRUCT_IF_C aF_I_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_I_BFu1s.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu1s, aF_I_BFu1s)
//============================================================================



static void Test_aF_I_BFu31i()
{
  {
    init_simple_test("aF_I_BFu31i");
    static STRUCT_IF_C aF_I_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aF_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_I_BFu31i.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "aF_I_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "aF_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu31i, aF_I_BFu31i)
//============================================================================



static void Test_aF_I_BFu31ll()
{
  {
    init_simple_test("aF_I_BFu31ll");
    static STRUCT_IF_C aF_I_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_I_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "aF_I_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "aF_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu31ll, aF_I_BFu31ll)
//============================================================================



static void Test_aF_I_BFu32i()
{
  {
    init_simple_test("aF_I_BFu32i");
    static STRUCT_IF_C aF_I_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(aF_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_I_BFu32i.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "aF_I_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "aF_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu32i, aF_I_BFu32i)
//============================================================================



static void Test_aF_I_BFu32ll()
{
  {
    init_simple_test("aF_I_BFu32ll");
    static STRUCT_IF_C aF_I_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_I_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "aF_I_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "aF_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu32ll, aF_I_BFu32ll)
//============================================================================



static void Test_aF_I_BFu33()
{
  {
    init_simple_test("aF_I_BFu33");
    static STRUCT_IF_C aF_I_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(aF_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu33)");
    check_field_offset(lv, v1, 0, "aF_I_BFu33.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "aF_I_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "aF_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu33, aF_I_BFu33)
//============================================================================



static void Test_aF_I_BFu7c()
{
  {
    init_simple_test("aF_I_BFu7c");
    static STRUCT_IF_C aF_I_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_I_BFu7c.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_I_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu7c, aF_I_BFu7c)
//============================================================================



static void Test_aF_I_BFu7i()
{
  {
    init_simple_test("aF_I_BFu7i");
    static STRUCT_IF_C aF_I_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_I_BFu7i.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_I_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu7i, aF_I_BFu7i)
//============================================================================



static void Test_aF_I_BFu7ll()
{
  {
    init_simple_test("aF_I_BFu7ll");
    static STRUCT_IF_C aF_I_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_I_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_I_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu7ll, aF_I_BFu7ll)
//============================================================================



static void Test_aF_I_BFu7s()
{
  {
    init_simple_test("aF_I_BFu7s");
    static STRUCT_IF_C aF_I_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_I_BFu7s.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_I_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu7s, aF_I_BFu7s)
//============================================================================



static void Test_aF_I_BFu8c()
{
  {
    init_simple_test("aF_I_BFu8c");
    static STRUCT_IF_C aF_I_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_I_BFu8c.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_I_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu8c, aF_I_BFu8c)
//============================================================================



static void Test_aF_I_BFu8i()
{
  {
    init_simple_test("aF_I_BFu8i");
    static STRUCT_IF_C aF_I_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_I_BFu8i.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_I_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu8i, aF_I_BFu8i)
//============================================================================



static void Test_aF_I_BFu8ll()
{
  {
    init_simple_test("aF_I_BFu8ll");
    static STRUCT_IF_C aF_I_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_I_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_I_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu8ll, aF_I_BFu8ll)
//============================================================================



static void Test_aF_I_BFu8s()
{
  {
    init_simple_test("aF_I_BFu8s");
    static STRUCT_IF_C aF_I_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_I_BFu8s.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_I_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu8s, aF_I_BFu8s)
//============================================================================



static void Test_aF_I_BFu9i()
{
  {
    init_simple_test("aF_I_BFu9i");
    static STRUCT_IF_C aF_I_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(aF_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_I_BFu9i.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_I_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu9i, aF_I_BFu9i)
//============================================================================



static void Test_aF_I_BFu9ll()
{
  {
    init_simple_test("aF_I_BFu9ll");
    static STRUCT_IF_C aF_I_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_I_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_I_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu9ll, aF_I_BFu9ll)
//============================================================================



static void Test_aF_I_BFu9s()
{
  {
    init_simple_test("aF_I_BFu9s");
    static STRUCT_IF_C aF_I_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(aF_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_I_BFu9s.v1");
    check_field_offset(lv, v2, 4, "aF_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_I_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_BFu9s, aF_I_BFu9s)
//============================================================================



static void Test_aF_I_C()
{
  {
    init_simple_test("aF_I_C");
    STRUCT_IF_C aF_I_C lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_C)");
    check_field_offset(lv, v1, 0, "aF_I_C.v1");
    check_field_offset(lv, v2, 4, "aF_I_C.v2");
    check_field_offset(lv, v3, 8, "aF_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_C, aF_I_C)
//============================================================================



static void Test_aF_I_D()
{
  {
    init_simple_test("aF_I_D");
    STRUCT_IF_C aF_I_D lv;
    check2(sizeof(lv), 16, "sizeof(aF_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_D)");
    check_field_offset(lv, v1, 0, "aF_I_D.v1");
    check_field_offset(lv, v2, 4, "aF_I_D.v2");
    check_field_offset(lv, v3, 8, "aF_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_D, aF_I_D)
//============================================================================



static void Test_aF_I_F()
{
  {
    init_simple_test("aF_I_F");
    STRUCT_IF_C aF_I_F lv;
    check2(sizeof(lv), 12, "sizeof(aF_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_F)");
    check_field_offset(lv, v1, 0, "aF_I_F.v1");
    check_field_offset(lv, v2, 4, "aF_I_F.v2");
    check_field_offset(lv, v3, 8, "aF_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_F, aF_I_F)
//============================================================================



static void Test_aF_I_I()
{
  {
    init_simple_test("aF_I_I");
    STRUCT_IF_C aF_I_I lv;
    check2(sizeof(lv), 12, "sizeof(aF_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_I)");
    check_field_offset(lv, v1, 0, "aF_I_I.v1");
    check_field_offset(lv, v2, 4, "aF_I_I.v2");
    check_field_offset(lv, v3, 8, "aF_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_I, aF_I_I)
//============================================================================



static void Test_aF_I_Ip()
{
  {
    init_simple_test("aF_I_Ip");
    STRUCT_IF_C aF_I_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_Ip)");
    check_field_offset(lv, v1, 0, "aF_I_Ip.v1");
    check_field_offset(lv, v2, 4, "aF_I_Ip.v2");
    check_field_offset(lv, v3, 8, "aF_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_Ip, aF_I_Ip)
//============================================================================



static void Test_aF_I_L()
{
  {
    init_simple_test("aF_I_L");
    STRUCT_IF_C aF_I_L lv;
    check2(sizeof(lv), 16, "sizeof(aF_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_L)");
    check_field_offset(lv, v1, 0, "aF_I_L.v1");
    check_field_offset(lv, v2, 4, "aF_I_L.v2");
    check_field_offset(lv, v3, 8, "aF_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_L, aF_I_L)
//============================================================================



static void Test_aF_I_S()
{
  {
    init_simple_test("aF_I_S");
    STRUCT_IF_C aF_I_S lv;
    check2(sizeof(lv), 10, "sizeof(aF_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_S)");
    check_field_offset(lv, v1, 0, "aF_I_S.v1");
    check_field_offset(lv, v2, 4, "aF_I_S.v2");
    check_field_offset(lv, v3, 8, "aF_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_S, aF_I_S)
//============================================================================



static void Test_aF_I_Uc()
{
  {
    init_simple_test("aF_I_Uc");
    STRUCT_IF_C aF_I_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aF_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_Uc)");
    check_field_offset(lv, v1, 0, "aF_I_Uc.v1");
    check_field_offset(lv, v2, 4, "aF_I_Uc.v2");
    check_field_offset(lv, v3, 8, "aF_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_Uc, aF_I_Uc)
//============================================================================



static void Test_aF_I_Ui()
{
  {
    init_simple_test("aF_I_Ui");
    STRUCT_IF_C aF_I_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aF_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_Ui)");
    check_field_offset(lv, v1, 0, "aF_I_Ui.v1");
    check_field_offset(lv, v2, 4, "aF_I_Ui.v2");
    check_field_offset(lv, v3, 8, "aF_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_Ui, aF_I_Ui)
//============================================================================



static void Test_aF_I_Ul()
{
  {
    init_simple_test("aF_I_Ul");
    STRUCT_IF_C aF_I_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aF_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_Ul)");
    check_field_offset(lv, v1, 0, "aF_I_Ul.v1");
    check_field_offset(lv, v2, 4, "aF_I_Ul.v2");
    check_field_offset(lv, v3, 8, "aF_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_Ul, aF_I_Ul)
//============================================================================



static void Test_aF_I_Us()
{
  {
    init_simple_test("aF_I_Us");
    STRUCT_IF_C aF_I_Us lv;
    check2(sizeof(lv), 10, "sizeof(aF_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_Us)");
    check_field_offset(lv, v1, 0, "aF_I_Us.v1");
    check_field_offset(lv, v2, 4, "aF_I_Us.v2");
    check_field_offset(lv, v3, 8, "aF_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_Us, aF_I_Us)
//============================================================================



static void Test_aF_I_Vp()
{
  {
    init_simple_test("aF_I_Vp");
    STRUCT_IF_C aF_I_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_I_Vp)");
    check_field_offset(lv, v1, 0, "aF_I_Vp.v1");
    check_field_offset(lv, v2, 4, "aF_I_Vp.v2");
    check_field_offset(lv, v3, 8, "aF_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_I_Vp, aF_I_Vp)
//============================================================================



static void Test_aF_Ip()
{
  {
    init_simple_test("aF_Ip");
    STRUCT_IF_C aF_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aF_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip)");
    check_field_offset(lv, v1, 0, "aF_Ip.v1");
    check_field_offset(lv, v2, 4, "aF_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip, aF_Ip)
//============================================================================



static void Test_aF_Ip_BFu15i()
{
  {
    init_simple_test("aF_Ip_BFu15i");
    static STRUCT_IF_C aF_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu15i.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aF_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aF_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu15i, aF_Ip_BFu15i)
//============================================================================



static void Test_aF_Ip_BFu15ll()
{
  {
    init_simple_test("aF_Ip_BFu15ll");
    static STRUCT_IF_C aF_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aF_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aF_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu15ll, aF_Ip_BFu15ll)
//============================================================================



static void Test_aF_Ip_BFu15s()
{
  {
    init_simple_test("aF_Ip_BFu15s");
    static STRUCT_IF_C aF_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu15s.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, 1, "aF_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 15, hide_ull(1LL<<14), "aF_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu15s, aF_Ip_BFu15s)
//============================================================================



static void Test_aF_Ip_BFu16i()
{
  {
    init_simple_test("aF_Ip_BFu16i");
    static STRUCT_IF_C aF_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu16i.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aF_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aF_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu16i, aF_Ip_BFu16i)
//============================================================================



static void Test_aF_Ip_BFu16ll()
{
  {
    init_simple_test("aF_Ip_BFu16ll");
    static STRUCT_IF_C aF_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aF_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aF_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu16ll, aF_Ip_BFu16ll)
//============================================================================



static void Test_aF_Ip_BFu16s()
{
  {
    init_simple_test("aF_Ip_BFu16s");
    static STRUCT_IF_C aF_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu16s.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, 1, "aF_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 16, hide_ull(1LL<<15), "aF_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu16s, aF_Ip_BFu16s)
//============================================================================



static void Test_aF_Ip_BFu17i()
{
  {
    init_simple_test("aF_Ip_BFu17i");
    static STRUCT_IF_C aF_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aF_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu17i.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "aF_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "aF_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu17i, aF_Ip_BFu17i)
//============================================================================



static void Test_aF_Ip_BFu17ll()
{
  {
    init_simple_test("aF_Ip_BFu17ll");
    static STRUCT_IF_C aF_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aF_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, 1, "aF_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 17, hide_ull(1LL<<16), "aF_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu17ll, aF_Ip_BFu17ll)
//============================================================================



static void Test_aF_Ip_BFu1c()
{
  {
    init_simple_test("aF_Ip_BFu1c");
    static STRUCT_IF_C aF_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu1c.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aF_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu1c, aF_Ip_BFu1c)
//============================================================================



static void Test_aF_Ip_BFu1i()
{
  {
    init_simple_test("aF_Ip_BFu1i");
    static STRUCT_IF_C aF_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu1i.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aF_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu1i, aF_Ip_BFu1i)
//============================================================================



static void Test_aF_Ip_BFu1ll()
{
  {
    init_simple_test("aF_Ip_BFu1ll");
    static STRUCT_IF_C aF_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aF_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu1ll, aF_Ip_BFu1ll)
//============================================================================



static void Test_aF_Ip_BFu1s()
{
  {
    init_simple_test("aF_Ip_BFu1s");
    static STRUCT_IF_C aF_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu1s.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 1, 1, "aF_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu1s, aF_Ip_BFu1s)
//============================================================================



static void Test_aF_Ip_BFu31i()
{
  {
    init_simple_test("aF_Ip_BFu31i");
    static STRUCT_IF_C aF_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu31i.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "aF_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "aF_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu31i, aF_Ip_BFu31i)
//============================================================================



static void Test_aF_Ip_BFu31ll()
{
  {
    init_simple_test("aF_Ip_BFu31ll");
    static STRUCT_IF_C aF_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, 1, "aF_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 31, hide_ull(1LL<<30), "aF_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu31ll, aF_Ip_BFu31ll)
//============================================================================



static void Test_aF_Ip_BFu32i()
{
  {
    init_simple_test("aF_Ip_BFu32i");
    static STRUCT_IF_C aF_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu32i.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "aF_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "aF_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu32i, aF_Ip_BFu32i)
//============================================================================



static void Test_aF_Ip_BFu32ll()
{
  {
    init_simple_test("aF_Ip_BFu32ll");
    static STRUCT_IF_C aF_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, 1, "aF_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 32, hide_ull(1LL<<31), "aF_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu32ll, aF_Ip_BFu32ll)
//============================================================================



static void Test_aF_Ip_BFu33()
{
  {
    init_simple_test("aF_Ip_BFu33");
    static STRUCT_IF_C aF_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aF_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu33.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, 1, "aF_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 33, hide_ull(1LL<<32), "aF_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu33, aF_Ip_BFu33)
//============================================================================



static void Test_aF_Ip_BFu7c()
{
  {
    init_simple_test("aF_Ip_BFu7c");
    static STRUCT_IF_C aF_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu7c.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aF_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aF_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu7c, aF_Ip_BFu7c)
//============================================================================



static void Test_aF_Ip_BFu7i()
{
  {
    init_simple_test("aF_Ip_BFu7i");
    static STRUCT_IF_C aF_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu7i.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aF_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aF_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu7i, aF_Ip_BFu7i)
//============================================================================



static void Test_aF_Ip_BFu7ll()
{
  {
    init_simple_test("aF_Ip_BFu7ll");
    static STRUCT_IF_C aF_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aF_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aF_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu7ll, aF_Ip_BFu7ll)
//============================================================================



static void Test_aF_Ip_BFu7s()
{
  {
    init_simple_test("aF_Ip_BFu7s");
    static STRUCT_IF_C aF_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu7s.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, 1, "aF_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 7, hide_ull(1LL<<6), "aF_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu7s, aF_Ip_BFu7s)
//============================================================================



static void Test_aF_Ip_BFu8c()
{
  {
    init_simple_test("aF_Ip_BFu8c");
    static STRUCT_IF_C aF_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu8c.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aF_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aF_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu8c, aF_Ip_BFu8c)
//============================================================================



static void Test_aF_Ip_BFu8i()
{
  {
    init_simple_test("aF_Ip_BFu8i");
    static STRUCT_IF_C aF_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu8i.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aF_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aF_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu8i, aF_Ip_BFu8i)
//============================================================================



static void Test_aF_Ip_BFu8ll()
{
  {
    init_simple_test("aF_Ip_BFu8ll");
    static STRUCT_IF_C aF_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aF_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aF_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu8ll, aF_Ip_BFu8ll)
//============================================================================



static void Test_aF_Ip_BFu8s()
{
  {
    init_simple_test("aF_Ip_BFu8s");
    static STRUCT_IF_C aF_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu8s.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, 1, "aF_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 8, hide_ull(1LL<<7), "aF_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu8s, aF_Ip_BFu8s)
//============================================================================



static void Test_aF_Ip_BFu9i()
{
  {
    init_simple_test("aF_Ip_BFu9i");
    static STRUCT_IF_C aF_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu9i.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aF_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aF_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu9i, aF_Ip_BFu9i)
//============================================================================



static void Test_aF_Ip_BFu9ll()
{
  {
    init_simple_test("aF_Ip_BFu9ll");
    static STRUCT_IF_C aF_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aF_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aF_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu9ll, aF_Ip_BFu9ll)
//============================================================================



static void Test_aF_Ip_BFu9s()
{
  {
    init_simple_test("aF_Ip_BFu9s");
    static STRUCT_IF_C aF_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_Ip_BFu9s.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, 1, "aF_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(12,8), 0, 9, hide_ull(1LL<<8), "aF_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_BFu9s, aF_Ip_BFu9s)
//============================================================================



static void Test_aF_Ip_C()
{
  {
    init_simple_test("aF_Ip_C");
    STRUCT_IF_C aF_Ip_C lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_C)");
    check_field_offset(lv, v1, 0, "aF_Ip_C.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aF_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_C, aF_Ip_C)
//============================================================================



static void Test_aF_Ip_D()
{
  {
    init_simple_test("aF_Ip_D");
    STRUCT_IF_C aF_Ip_D lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aF_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_D)");
    check_field_offset(lv, v1, 0, "aF_Ip_D.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aF_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_D, aF_Ip_D)
//============================================================================



static void Test_aF_Ip_F()
{
  {
    init_simple_test("aF_Ip_F");
    STRUCT_IF_C aF_Ip_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_F)");
    check_field_offset(lv, v1, 0, "aF_Ip_F.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aF_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_F, aF_Ip_F)
//============================================================================



static void Test_aF_Ip_I()
{
  {
    init_simple_test("aF_Ip_I");
    STRUCT_IF_C aF_Ip_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_I)");
    check_field_offset(lv, v1, 0, "aF_Ip_I.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aF_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_I, aF_Ip_I)
//============================================================================



static void Test_aF_Ip_Ip()
{
  {
    init_simple_test("aF_Ip_Ip");
    STRUCT_IF_C aF_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aF_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_Ip)");
    check_field_offset(lv, v1, 0, "aF_Ip_Ip.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aF_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_Ip, aF_Ip_Ip)
//============================================================================



static void Test_aF_Ip_L()
{
  {
    init_simple_test("aF_Ip_L");
    STRUCT_IF_C aF_Ip_L lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aF_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_L)");
    check_field_offset(lv, v1, 0, "aF_Ip_L.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aF_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_L, aF_Ip_L)
//============================================================================



static void Test_aF_Ip_S()
{
  {
    init_simple_test("aF_Ip_S");
    STRUCT_IF_C aF_Ip_S lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_S)");
    check_field_offset(lv, v1, 0, "aF_Ip_S.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aF_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_S, aF_Ip_S)
//============================================================================



static void Test_aF_Ip_Uc()
{
  {
    init_simple_test("aF_Ip_Uc");
    STRUCT_IF_C aF_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_Uc)");
    check_field_offset(lv, v1, 0, "aF_Ip_Uc.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aF_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_Uc, aF_Ip_Uc)
//============================================================================



static void Test_aF_Ip_Ui()
{
  {
    init_simple_test("aF_Ip_Ui");
    STRUCT_IF_C aF_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_Ui)");
    check_field_offset(lv, v1, 0, "aF_Ip_Ui.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aF_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_Ui, aF_Ip_Ui)
//============================================================================



static void Test_aF_Ip_Ul()
{
  {
    init_simple_test("aF_Ip_Ul");
    STRUCT_IF_C aF_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aF_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_Ul)");
    check_field_offset(lv, v1, 0, "aF_Ip_Ul.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aF_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_Ul, aF_Ip_Ul)
//============================================================================



static void Test_aF_Ip_Us()
{
  {
    init_simple_test("aF_Ip_Us");
    STRUCT_IF_C aF_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_Us)");
    check_field_offset(lv, v1, 0, "aF_Ip_Us.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aF_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_Us, aF_Ip_Us)
//============================================================================



static void Test_aF_Ip_Vp()
{
  {
    init_simple_test("aF_Ip_Vp");
    STRUCT_IF_C aF_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(20,12), "sizeof(aF_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ip_Vp)");
    check_field_offset(lv, v1, 0, "aF_Ip_Vp.v1");
    check_field_offset(lv, v2, 4, "aF_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(12,8), "aF_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ip_Vp, aF_Ip_Vp)
//============================================================================



static void Test_aF_L()
{
  {
    init_simple_test("aF_L");
    STRUCT_IF_C aF_L lv;
    check2(sizeof(lv), 12, "sizeof(aF_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L)");
    check_field_offset(lv, v1, 0, "aF_L.v1");
    check_field_offset(lv, v2, 4, "aF_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L, aF_L)
//============================================================================



static void Test_aF_L_BFu15i()
{
  {
    init_simple_test("aF_L_BFu15i");
    static STRUCT_IF_C aF_L_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(aF_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_L_BFu15i.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aF_L_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aF_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu15i, aF_L_BFu15i)
//============================================================================



static void Test_aF_L_BFu15ll()
{
  {
    init_simple_test("aF_L_BFu15ll");
    static STRUCT_IF_C aF_L_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(aF_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_L_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aF_L_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aF_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu15ll, aF_L_BFu15ll)
//============================================================================



static void Test_aF_L_BFu15s()
{
  {
    init_simple_test("aF_L_BFu15s");
    static STRUCT_IF_C aF_L_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(aF_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_L_BFu15s.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aF_L_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aF_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu15s, aF_L_BFu15s)
//============================================================================



static void Test_aF_L_BFu16i()
{
  {
    init_simple_test("aF_L_BFu16i");
    static STRUCT_IF_C aF_L_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(aF_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_L_BFu16i.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aF_L_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aF_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu16i, aF_L_BFu16i)
//============================================================================



static void Test_aF_L_BFu16ll()
{
  {
    init_simple_test("aF_L_BFu16ll");
    static STRUCT_IF_C aF_L_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(aF_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_L_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aF_L_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aF_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu16ll, aF_L_BFu16ll)
//============================================================================



static void Test_aF_L_BFu16s()
{
  {
    init_simple_test("aF_L_BFu16s");
    static STRUCT_IF_C aF_L_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(aF_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_L_BFu16s.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aF_L_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aF_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu16s, aF_L_BFu16s)
//============================================================================



static void Test_aF_L_BFu17i()
{
  {
    init_simple_test("aF_L_BFu17i");
    static STRUCT_IF_C aF_L_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(aF_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_L_BFu17i.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aF_L_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aF_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu17i, aF_L_BFu17i)
//============================================================================



static void Test_aF_L_BFu17ll()
{
  {
    init_simple_test("aF_L_BFu17ll");
    static STRUCT_IF_C aF_L_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(aF_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_L_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aF_L_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aF_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu17ll, aF_L_BFu17ll)
//============================================================================



static void Test_aF_L_BFu1c()
{
  {
    init_simple_test("aF_L_BFu1c");
    static STRUCT_IF_C aF_L_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_L_BFu1c.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aF_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu1c, aF_L_BFu1c)
//============================================================================



static void Test_aF_L_BFu1i()
{
  {
    init_simple_test("aF_L_BFu1i");
    static STRUCT_IF_C aF_L_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_L_BFu1i.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aF_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu1i, aF_L_BFu1i)
//============================================================================



static void Test_aF_L_BFu1ll()
{
  {
    init_simple_test("aF_L_BFu1ll");
    static STRUCT_IF_C aF_L_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_L_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aF_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu1ll, aF_L_BFu1ll)
//============================================================================



static void Test_aF_L_BFu1s()
{
  {
    init_simple_test("aF_L_BFu1s");
    static STRUCT_IF_C aF_L_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_L_BFu1s.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aF_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu1s, aF_L_BFu1s)
//============================================================================



static void Test_aF_L_BFu31i()
{
  {
    init_simple_test("aF_L_BFu31i");
    static STRUCT_IF_C aF_L_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(aF_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_L_BFu31i.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aF_L_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aF_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu31i, aF_L_BFu31i)
//============================================================================



static void Test_aF_L_BFu31ll()
{
  {
    init_simple_test("aF_L_BFu31ll");
    static STRUCT_IF_C aF_L_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(aF_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_L_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aF_L_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aF_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu31ll, aF_L_BFu31ll)
//============================================================================



static void Test_aF_L_BFu32i()
{
  {
    init_simple_test("aF_L_BFu32i");
    static STRUCT_IF_C aF_L_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(aF_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_L_BFu32i.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aF_L_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aF_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu32i, aF_L_BFu32i)
//============================================================================



static void Test_aF_L_BFu32ll()
{
  {
    init_simple_test("aF_L_BFu32ll");
    static STRUCT_IF_C aF_L_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(aF_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_L_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aF_L_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aF_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu32ll, aF_L_BFu32ll)
//============================================================================



static void Test_aF_L_BFu33()
{
  {
    init_simple_test("aF_L_BFu33");
    static STRUCT_IF_C aF_L_BFu33 lv;
    check2(sizeof(lv), 17, "sizeof(aF_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu33)");
    check_field_offset(lv, v1, 0, "aF_L_BFu33.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu33.v2");
    set_bf_and_test(lv, v3, 12, 0, 33, 1, "aF_L_BFu33");
    set_bf_and_test(lv, v3, 12, 0, 33, hide_ull(1LL<<32), "aF_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu33, aF_L_BFu33)
//============================================================================



static void Test_aF_L_BFu7c()
{
  {
    init_simple_test("aF_L_BFu7c");
    static STRUCT_IF_C aF_L_BFu7c lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_L_BFu7c.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aF_L_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aF_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu7c, aF_L_BFu7c)
//============================================================================



static void Test_aF_L_BFu7i()
{
  {
    init_simple_test("aF_L_BFu7i");
    static STRUCT_IF_C aF_L_BFu7i lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_L_BFu7i.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aF_L_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aF_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu7i, aF_L_BFu7i)
//============================================================================



static void Test_aF_L_BFu7ll()
{
  {
    init_simple_test("aF_L_BFu7ll");
    static STRUCT_IF_C aF_L_BFu7ll lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_L_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aF_L_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aF_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu7ll, aF_L_BFu7ll)
//============================================================================



static void Test_aF_L_BFu7s()
{
  {
    init_simple_test("aF_L_BFu7s");
    static STRUCT_IF_C aF_L_BFu7s lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_L_BFu7s.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "aF_L_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "aF_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu7s, aF_L_BFu7s)
//============================================================================



static void Test_aF_L_BFu8c()
{
  {
    init_simple_test("aF_L_BFu8c");
    static STRUCT_IF_C aF_L_BFu8c lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_L_BFu8c.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aF_L_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aF_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu8c, aF_L_BFu8c)
//============================================================================



static void Test_aF_L_BFu8i()
{
  {
    init_simple_test("aF_L_BFu8i");
    static STRUCT_IF_C aF_L_BFu8i lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_L_BFu8i.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aF_L_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aF_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu8i, aF_L_BFu8i)
//============================================================================



static void Test_aF_L_BFu8ll()
{
  {
    init_simple_test("aF_L_BFu8ll");
    static STRUCT_IF_C aF_L_BFu8ll lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_L_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aF_L_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aF_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu8ll, aF_L_BFu8ll)
//============================================================================



static void Test_aF_L_BFu8s()
{
  {
    init_simple_test("aF_L_BFu8s");
    static STRUCT_IF_C aF_L_BFu8s lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_L_BFu8s.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "aF_L_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "aF_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu8s, aF_L_BFu8s)
//============================================================================



static void Test_aF_L_BFu9i()
{
  {
    init_simple_test("aF_L_BFu9i");
    static STRUCT_IF_C aF_L_BFu9i lv;
    check2(sizeof(lv), 14, "sizeof(aF_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_L_BFu9i.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aF_L_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aF_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu9i, aF_L_BFu9i)
//============================================================================



static void Test_aF_L_BFu9ll()
{
  {
    init_simple_test("aF_L_BFu9ll");
    static STRUCT_IF_C aF_L_BFu9ll lv;
    check2(sizeof(lv), 14, "sizeof(aF_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_L_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aF_L_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aF_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu9ll, aF_L_BFu9ll)
//============================================================================



static void Test_aF_L_BFu9s()
{
  {
    init_simple_test("aF_L_BFu9s");
    static STRUCT_IF_C aF_L_BFu9s lv;
    check2(sizeof(lv), 14, "sizeof(aF_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_L_BFu9s.v1");
    check_field_offset(lv, v2, 4, "aF_L_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "aF_L_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "aF_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_BFu9s, aF_L_BFu9s)
//============================================================================



static void Test_aF_L_C()
{
  {
    init_simple_test("aF_L_C");
    STRUCT_IF_C aF_L_C lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_C)");
    check_field_offset(lv, v1, 0, "aF_L_C.v1");
    check_field_offset(lv, v2, 4, "aF_L_C.v2");
    check_field_offset(lv, v3, 12, "aF_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_C, aF_L_C)
//============================================================================



static void Test_aF_L_D()
{
  {
    init_simple_test("aF_L_D");
    STRUCT_IF_C aF_L_D lv;
    check2(sizeof(lv), 20, "sizeof(aF_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_D)");
    check_field_offset(lv, v1, 0, "aF_L_D.v1");
    check_field_offset(lv, v2, 4, "aF_L_D.v2");
    check_field_offset(lv, v3, 12, "aF_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_D, aF_L_D)
//============================================================================



static void Test_aF_L_F()
{
  {
    init_simple_test("aF_L_F");
    STRUCT_IF_C aF_L_F lv;
    check2(sizeof(lv), 16, "sizeof(aF_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_F)");
    check_field_offset(lv, v1, 0, "aF_L_F.v1");
    check_field_offset(lv, v2, 4, "aF_L_F.v2");
    check_field_offset(lv, v3, 12, "aF_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_F, aF_L_F)
//============================================================================



static void Test_aF_L_I()
{
  {
    init_simple_test("aF_L_I");
    STRUCT_IF_C aF_L_I lv;
    check2(sizeof(lv), 16, "sizeof(aF_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_I)");
    check_field_offset(lv, v1, 0, "aF_L_I.v1");
    check_field_offset(lv, v2, 4, "aF_L_I.v2");
    check_field_offset(lv, v3, 12, "aF_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_I, aF_L_I)
//============================================================================



static void Test_aF_L_Ip()
{
  {
    init_simple_test("aF_L_Ip");
    STRUCT_IF_C aF_L_Ip lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aF_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_Ip)");
    check_field_offset(lv, v1, 0, "aF_L_Ip.v1");
    check_field_offset(lv, v2, 4, "aF_L_Ip.v2");
    check_field_offset(lv, v3, 12, "aF_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_Ip, aF_L_Ip)
//============================================================================



static void Test_aF_L_L()
{
  {
    init_simple_test("aF_L_L");
    STRUCT_IF_C aF_L_L lv;
    check2(sizeof(lv), 20, "sizeof(aF_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_L)");
    check_field_offset(lv, v1, 0, "aF_L_L.v1");
    check_field_offset(lv, v2, 4, "aF_L_L.v2");
    check_field_offset(lv, v3, 12, "aF_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_L, aF_L_L)
//============================================================================



static void Test_aF_L_S()
{
  {
    init_simple_test("aF_L_S");
    STRUCT_IF_C aF_L_S lv;
    check2(sizeof(lv), 14, "sizeof(aF_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_S)");
    check_field_offset(lv, v1, 0, "aF_L_S.v1");
    check_field_offset(lv, v2, 4, "aF_L_S.v2");
    check_field_offset(lv, v3, 12, "aF_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_S, aF_L_S)
//============================================================================



static void Test_aF_L_Uc()
{
  {
    init_simple_test("aF_L_Uc");
    STRUCT_IF_C aF_L_Uc lv;
    check2(sizeof(lv), 13, "sizeof(aF_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_Uc)");
    check_field_offset(lv, v1, 0, "aF_L_Uc.v1");
    check_field_offset(lv, v2, 4, "aF_L_Uc.v2");
    check_field_offset(lv, v3, 12, "aF_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_Uc, aF_L_Uc)
//============================================================================



static void Test_aF_L_Ui()
{
  {
    init_simple_test("aF_L_Ui");
    STRUCT_IF_C aF_L_Ui lv;
    check2(sizeof(lv), 16, "sizeof(aF_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_Ui)");
    check_field_offset(lv, v1, 0, "aF_L_Ui.v1");
    check_field_offset(lv, v2, 4, "aF_L_Ui.v2");
    check_field_offset(lv, v3, 12, "aF_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_Ui, aF_L_Ui)
//============================================================================



static void Test_aF_L_Ul()
{
  {
    init_simple_test("aF_L_Ul");
    STRUCT_IF_C aF_L_Ul lv;
    check2(sizeof(lv), 20, "sizeof(aF_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_Ul)");
    check_field_offset(lv, v1, 0, "aF_L_Ul.v1");
    check_field_offset(lv, v2, 4, "aF_L_Ul.v2");
    check_field_offset(lv, v3, 12, "aF_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_Ul, aF_L_Ul)
//============================================================================



static void Test_aF_L_Us()
{
  {
    init_simple_test("aF_L_Us");
    STRUCT_IF_C aF_L_Us lv;
    check2(sizeof(lv), 14, "sizeof(aF_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_Us)");
    check_field_offset(lv, v1, 0, "aF_L_Us.v1");
    check_field_offset(lv, v2, 4, "aF_L_Us.v2");
    check_field_offset(lv, v3, 12, "aF_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_Us, aF_L_Us)
//============================================================================



static void Test_aF_L_Vp()
{
  {
    init_simple_test("aF_L_Vp");
    STRUCT_IF_C aF_L_Vp lv;
    check2(sizeof(lv), ABISELECT(20,16), "sizeof(aF_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_L_Vp)");
    check_field_offset(lv, v1, 0, "aF_L_Vp.v1");
    check_field_offset(lv, v2, 4, "aF_L_Vp.v2");
    check_field_offset(lv, v3, 12, "aF_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_L_Vp, aF_L_Vp)
//============================================================================



static void Test_aF_S()
{
  {
    init_simple_test("aF_S");
    STRUCT_IF_C aF_S lv;
    check2(sizeof(lv), 6, "sizeof(aF_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S)");
    check_field_offset(lv, v1, 0, "aF_S.v1");
    check_field_offset(lv, v2, 4, "aF_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S, aF_S)
//============================================================================



static void Test_aF_S_BFu15i()
{
  {
    init_simple_test("aF_S_BFu15i");
    static STRUCT_IF_C aF_S_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aF_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_S_BFu15i.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aF_S_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aF_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu15i, aF_S_BFu15i)
//============================================================================



static void Test_aF_S_BFu15ll()
{
  {
    init_simple_test("aF_S_BFu15ll");
    static STRUCT_IF_C aF_S_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_S_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aF_S_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aF_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu15ll, aF_S_BFu15ll)
//============================================================================



static void Test_aF_S_BFu15s()
{
  {
    init_simple_test("aF_S_BFu15s");
    static STRUCT_IF_C aF_S_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aF_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_S_BFu15s.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aF_S_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aF_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu15s, aF_S_BFu15s)
//============================================================================



static void Test_aF_S_BFu16i()
{
  {
    init_simple_test("aF_S_BFu16i");
    static STRUCT_IF_C aF_S_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aF_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_S_BFu16i.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aF_S_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aF_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu16i, aF_S_BFu16i)
//============================================================================



static void Test_aF_S_BFu16ll()
{
  {
    init_simple_test("aF_S_BFu16ll");
    static STRUCT_IF_C aF_S_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_S_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aF_S_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aF_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu16ll, aF_S_BFu16ll)
//============================================================================



static void Test_aF_S_BFu16s()
{
  {
    init_simple_test("aF_S_BFu16s");
    static STRUCT_IF_C aF_S_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aF_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_S_BFu16s.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aF_S_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aF_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu16s, aF_S_BFu16s)
//============================================================================



static void Test_aF_S_BFu17i()
{
  {
    init_simple_test("aF_S_BFu17i");
    static STRUCT_IF_C aF_S_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(aF_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_S_BFu17i.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aF_S_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aF_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu17i, aF_S_BFu17i)
//============================================================================



static void Test_aF_S_BFu17ll()
{
  {
    init_simple_test("aF_S_BFu17ll");
    static STRUCT_IF_C aF_S_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_S_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aF_S_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aF_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu17ll, aF_S_BFu17ll)
//============================================================================



static void Test_aF_S_BFu1c()
{
  {
    init_simple_test("aF_S_BFu1c");
    static STRUCT_IF_C aF_S_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_S_BFu1c.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aF_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu1c, aF_S_BFu1c)
//============================================================================



static void Test_aF_S_BFu1i()
{
  {
    init_simple_test("aF_S_BFu1i");
    static STRUCT_IF_C aF_S_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_S_BFu1i.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aF_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu1i, aF_S_BFu1i)
//============================================================================



static void Test_aF_S_BFu1ll()
{
  {
    init_simple_test("aF_S_BFu1ll");
    static STRUCT_IF_C aF_S_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_S_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aF_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu1ll, aF_S_BFu1ll)
//============================================================================



static void Test_aF_S_BFu1s()
{
  {
    init_simple_test("aF_S_BFu1s");
    static STRUCT_IF_C aF_S_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_S_BFu1s.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aF_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu1s, aF_S_BFu1s)
//============================================================================



static void Test_aF_S_BFu31i()
{
  {
    init_simple_test("aF_S_BFu31i");
    static STRUCT_IF_C aF_S_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aF_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_S_BFu31i.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aF_S_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aF_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu31i, aF_S_BFu31i)
//============================================================================



static void Test_aF_S_BFu31ll()
{
  {
    init_simple_test("aF_S_BFu31ll");
    static STRUCT_IF_C aF_S_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_S_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aF_S_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aF_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu31ll, aF_S_BFu31ll)
//============================================================================



static void Test_aF_S_BFu32i()
{
  {
    init_simple_test("aF_S_BFu32i");
    static STRUCT_IF_C aF_S_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aF_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_S_BFu32i.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aF_S_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aF_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu32i, aF_S_BFu32i)
//============================================================================



static void Test_aF_S_BFu32ll()
{
  {
    init_simple_test("aF_S_BFu32ll");
    static STRUCT_IF_C aF_S_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_S_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aF_S_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aF_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu32ll, aF_S_BFu32ll)
//============================================================================



static void Test_aF_S_BFu33()
{
  {
    init_simple_test("aF_S_BFu33");
    static STRUCT_IF_C aF_S_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(aF_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu33)");
    check_field_offset(lv, v1, 0, "aF_S_BFu33.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu33.v2");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "aF_S_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "aF_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu33, aF_S_BFu33)
//============================================================================



static void Test_aF_S_BFu7c()
{
  {
    init_simple_test("aF_S_BFu7c");
    static STRUCT_IF_C aF_S_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_S_BFu7c.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aF_S_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aF_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu7c, aF_S_BFu7c)
//============================================================================



static void Test_aF_S_BFu7i()
{
  {
    init_simple_test("aF_S_BFu7i");
    static STRUCT_IF_C aF_S_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_S_BFu7i.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aF_S_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aF_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu7i, aF_S_BFu7i)
//============================================================================



static void Test_aF_S_BFu7ll()
{
  {
    init_simple_test("aF_S_BFu7ll");
    static STRUCT_IF_C aF_S_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_S_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aF_S_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aF_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu7ll, aF_S_BFu7ll)
//============================================================================



static void Test_aF_S_BFu7s()
{
  {
    init_simple_test("aF_S_BFu7s");
    static STRUCT_IF_C aF_S_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_S_BFu7s.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aF_S_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aF_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu7s, aF_S_BFu7s)
//============================================================================



static void Test_aF_S_BFu8c()
{
  {
    init_simple_test("aF_S_BFu8c");
    static STRUCT_IF_C aF_S_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_S_BFu8c.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aF_S_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aF_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu8c, aF_S_BFu8c)
//============================================================================



static void Test_aF_S_BFu8i()
{
  {
    init_simple_test("aF_S_BFu8i");
    static STRUCT_IF_C aF_S_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_S_BFu8i.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aF_S_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aF_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu8i, aF_S_BFu8i)
//============================================================================



static void Test_aF_S_BFu8ll()
{
  {
    init_simple_test("aF_S_BFu8ll");
    static STRUCT_IF_C aF_S_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_S_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aF_S_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aF_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu8ll, aF_S_BFu8ll)
//============================================================================



static void Test_aF_S_BFu8s()
{
  {
    init_simple_test("aF_S_BFu8s");
    static STRUCT_IF_C aF_S_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_S_BFu8s.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aF_S_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aF_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu8s, aF_S_BFu8s)
//============================================================================



static void Test_aF_S_BFu9i()
{
  {
    init_simple_test("aF_S_BFu9i");
    static STRUCT_IF_C aF_S_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(aF_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_S_BFu9i.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aF_S_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aF_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu9i, aF_S_BFu9i)
//============================================================================



static void Test_aF_S_BFu9ll()
{
  {
    init_simple_test("aF_S_BFu9ll");
    static STRUCT_IF_C aF_S_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_S_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aF_S_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aF_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu9ll, aF_S_BFu9ll)
//============================================================================



static void Test_aF_S_BFu9s()
{
  {
    init_simple_test("aF_S_BFu9s");
    static STRUCT_IF_C aF_S_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(aF_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_S_BFu9s.v1");
    check_field_offset(lv, v2, 4, "aF_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aF_S_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aF_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_BFu9s, aF_S_BFu9s)
//============================================================================



static void Test_aF_S_C()
{
  {
    init_simple_test("aF_S_C");
    STRUCT_IF_C aF_S_C lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_C)");
    check_field_offset(lv, v1, 0, "aF_S_C.v1");
    check_field_offset(lv, v2, 4, "aF_S_C.v2");
    check_field_offset(lv, v3, 6, "aF_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_C, aF_S_C)
//============================================================================



static void Test_aF_S_D()
{
  {
    init_simple_test("aF_S_D");
    STRUCT_IF_C aF_S_D lv;
    check2(sizeof(lv), 14, "sizeof(aF_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_D)");
    check_field_offset(lv, v1, 0, "aF_S_D.v1");
    check_field_offset(lv, v2, 4, "aF_S_D.v2");
    check_field_offset(lv, v3, 6, "aF_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_D, aF_S_D)
//============================================================================



static void Test_aF_S_F()
{
  {
    init_simple_test("aF_S_F");
    STRUCT_IF_C aF_S_F lv;
    check2(sizeof(lv), 10, "sizeof(aF_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_F)");
    check_field_offset(lv, v1, 0, "aF_S_F.v1");
    check_field_offset(lv, v2, 4, "aF_S_F.v2");
    check_field_offset(lv, v3, 6, "aF_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_F, aF_S_F)
//============================================================================



static void Test_aF_S_I()
{
  {
    init_simple_test("aF_S_I");
    STRUCT_IF_C aF_S_I lv;
    check2(sizeof(lv), 10, "sizeof(aF_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_I)");
    check_field_offset(lv, v1, 0, "aF_S_I.v1");
    check_field_offset(lv, v2, 4, "aF_S_I.v2");
    check_field_offset(lv, v3, 6, "aF_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_I, aF_S_I)
//============================================================================



static void Test_aF_S_Ip()
{
  {
    init_simple_test("aF_S_Ip");
    STRUCT_IF_C aF_S_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_Ip)");
    check_field_offset(lv, v1, 0, "aF_S_Ip.v1");
    check_field_offset(lv, v2, 4, "aF_S_Ip.v2");
    check_field_offset(lv, v3, 6, "aF_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_Ip, aF_S_Ip)
//============================================================================



static void Test_aF_S_L()
{
  {
    init_simple_test("aF_S_L");
    STRUCT_IF_C aF_S_L lv;
    check2(sizeof(lv), 14, "sizeof(aF_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_L)");
    check_field_offset(lv, v1, 0, "aF_S_L.v1");
    check_field_offset(lv, v2, 4, "aF_S_L.v2");
    check_field_offset(lv, v3, 6, "aF_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_L, aF_S_L)
//============================================================================



static void Test_aF_S_S()
{
  {
    init_simple_test("aF_S_S");
    STRUCT_IF_C aF_S_S lv;
    check2(sizeof(lv), 8, "sizeof(aF_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_S)");
    check_field_offset(lv, v1, 0, "aF_S_S.v1");
    check_field_offset(lv, v2, 4, "aF_S_S.v2");
    check_field_offset(lv, v3, 6, "aF_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_S, aF_S_S)
//============================================================================



static void Test_aF_S_Uc()
{
  {
    init_simple_test("aF_S_Uc");
    STRUCT_IF_C aF_S_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aF_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_Uc)");
    check_field_offset(lv, v1, 0, "aF_S_Uc.v1");
    check_field_offset(lv, v2, 4, "aF_S_Uc.v2");
    check_field_offset(lv, v3, 6, "aF_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_Uc, aF_S_Uc)
//============================================================================



static void Test_aF_S_Ui()
{
  {
    init_simple_test("aF_S_Ui");
    STRUCT_IF_C aF_S_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aF_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_Ui)");
    check_field_offset(lv, v1, 0, "aF_S_Ui.v1");
    check_field_offset(lv, v2, 4, "aF_S_Ui.v2");
    check_field_offset(lv, v3, 6, "aF_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_Ui, aF_S_Ui)
//============================================================================



static void Test_aF_S_Ul()
{
  {
    init_simple_test("aF_S_Ul");
    STRUCT_IF_C aF_S_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aF_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_Ul)");
    check_field_offset(lv, v1, 0, "aF_S_Ul.v1");
    check_field_offset(lv, v2, 4, "aF_S_Ul.v2");
    check_field_offset(lv, v3, 6, "aF_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_Ul, aF_S_Ul)
//============================================================================



static void Test_aF_S_Us()
{
  {
    init_simple_test("aF_S_Us");
    STRUCT_IF_C aF_S_Us lv;
    check2(sizeof(lv), 8, "sizeof(aF_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_Us)");
    check_field_offset(lv, v1, 0, "aF_S_Us.v1");
    check_field_offset(lv, v2, 4, "aF_S_Us.v2");
    check_field_offset(lv, v3, 6, "aF_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_Us, aF_S_Us)
//============================================================================



static void Test_aF_S_Vp()
{
  {
    init_simple_test("aF_S_Vp");
    STRUCT_IF_C aF_S_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aF_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_S_Vp)");
    check_field_offset(lv, v1, 0, "aF_S_Vp.v1");
    check_field_offset(lv, v2, 4, "aF_S_Vp.v2");
    check_field_offset(lv, v3, 6, "aF_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_S_Vp, aF_S_Vp)
//============================================================================



static void Test_aF_Uc()
{
  {
    init_simple_test("aF_Uc");
    STRUCT_IF_C aF_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aF_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc)");
    check_field_offset(lv, v1, 0, "aF_Uc.v1");
    check_field_offset(lv, v2, 4, "aF_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc, aF_Uc)
//============================================================================



static void Test_aF_Uc_BFu15i()
{
  {
    init_simple_test("aF_Uc_BFu15i");
    static STRUCT_IF_C aF_Uc_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aF_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu15i.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_Uc_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu15i, aF_Uc_BFu15i)
//============================================================================



static void Test_aF_Uc_BFu15ll()
{
  {
    init_simple_test("aF_Uc_BFu15ll");
    static STRUCT_IF_C aF_Uc_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu15ll, aF_Uc_BFu15ll)
//============================================================================



static void Test_aF_Uc_BFu15s()
{
  {
    init_simple_test("aF_Uc_BFu15s");
    static STRUCT_IF_C aF_Uc_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aF_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu15s.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aF_Uc_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aF_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu15s, aF_Uc_BFu15s)
//============================================================================



static void Test_aF_Uc_BFu16i()
{
  {
    init_simple_test("aF_Uc_BFu16i");
    static STRUCT_IF_C aF_Uc_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aF_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu16i.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_Uc_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu16i, aF_Uc_BFu16i)
//============================================================================



static void Test_aF_Uc_BFu16ll()
{
  {
    init_simple_test("aF_Uc_BFu16ll");
    static STRUCT_IF_C aF_Uc_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu16ll, aF_Uc_BFu16ll)
//============================================================================



static void Test_aF_Uc_BFu16s()
{
  {
    init_simple_test("aF_Uc_BFu16s");
    static STRUCT_IF_C aF_Uc_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aF_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu16s.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aF_Uc_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aF_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu16s, aF_Uc_BFu16s)
//============================================================================



static void Test_aF_Uc_BFu17i()
{
  {
    init_simple_test("aF_Uc_BFu17i");
    static STRUCT_IF_C aF_Uc_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aF_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu17i.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aF_Uc_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aF_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu17i, aF_Uc_BFu17i)
//============================================================================



static void Test_aF_Uc_BFu17ll()
{
  {
    init_simple_test("aF_Uc_BFu17ll");
    static STRUCT_IF_C aF_Uc_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aF_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aF_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aF_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu17ll, aF_Uc_BFu17ll)
//============================================================================



static void Test_aF_Uc_BFu1c()
{
  {
    init_simple_test("aF_Uc_BFu1c");
    static STRUCT_IF_C aF_Uc_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu1c.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu1c, aF_Uc_BFu1c)
//============================================================================



static void Test_aF_Uc_BFu1i()
{
  {
    init_simple_test("aF_Uc_BFu1i");
    static STRUCT_IF_C aF_Uc_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu1i.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu1i, aF_Uc_BFu1i)
//============================================================================



static void Test_aF_Uc_BFu1ll()
{
  {
    init_simple_test("aF_Uc_BFu1ll");
    static STRUCT_IF_C aF_Uc_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu1ll, aF_Uc_BFu1ll)
//============================================================================



static void Test_aF_Uc_BFu1s()
{
  {
    init_simple_test("aF_Uc_BFu1s");
    static STRUCT_IF_C aF_Uc_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu1s.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aF_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu1s, aF_Uc_BFu1s)
//============================================================================



static void Test_aF_Uc_BFu31i()
{
  {
    init_simple_test("aF_Uc_BFu31i");
    static STRUCT_IF_C aF_Uc_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aF_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu31i.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aF_Uc_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aF_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu31i, aF_Uc_BFu31i)
//============================================================================



static void Test_aF_Uc_BFu31ll()
{
  {
    init_simple_test("aF_Uc_BFu31ll");
    static STRUCT_IF_C aF_Uc_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aF_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aF_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu31ll, aF_Uc_BFu31ll)
//============================================================================



static void Test_aF_Uc_BFu32i()
{
  {
    init_simple_test("aF_Uc_BFu32i");
    static STRUCT_IF_C aF_Uc_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aF_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu32i.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aF_Uc_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aF_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu32i, aF_Uc_BFu32i)
//============================================================================



static void Test_aF_Uc_BFu32ll()
{
  {
    init_simple_test("aF_Uc_BFu32ll");
    static STRUCT_IF_C aF_Uc_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aF_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aF_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu32ll, aF_Uc_BFu32ll)
//============================================================================



static void Test_aF_Uc_BFu33()
{
  {
    init_simple_test("aF_Uc_BFu33");
    static STRUCT_IF_C aF_Uc_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aF_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu33.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aF_Uc_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aF_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu33, aF_Uc_BFu33)
//============================================================================



static void Test_aF_Uc_BFu7c()
{
  {
    init_simple_test("aF_Uc_BFu7c");
    static STRUCT_IF_C aF_Uc_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu7c.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_Uc_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu7c, aF_Uc_BFu7c)
//============================================================================



static void Test_aF_Uc_BFu7i()
{
  {
    init_simple_test("aF_Uc_BFu7i");
    static STRUCT_IF_C aF_Uc_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu7i.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_Uc_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu7i, aF_Uc_BFu7i)
//============================================================================



static void Test_aF_Uc_BFu7ll()
{
  {
    init_simple_test("aF_Uc_BFu7ll");
    static STRUCT_IF_C aF_Uc_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu7ll, aF_Uc_BFu7ll)
//============================================================================



static void Test_aF_Uc_BFu7s()
{
  {
    init_simple_test("aF_Uc_BFu7s");
    static STRUCT_IF_C aF_Uc_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu7s.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aF_Uc_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aF_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu7s, aF_Uc_BFu7s)
//============================================================================



static void Test_aF_Uc_BFu8c()
{
  {
    init_simple_test("aF_Uc_BFu8c");
    static STRUCT_IF_C aF_Uc_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu8c.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_Uc_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu8c, aF_Uc_BFu8c)
//============================================================================



static void Test_aF_Uc_BFu8i()
{
  {
    init_simple_test("aF_Uc_BFu8i");
    static STRUCT_IF_C aF_Uc_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu8i.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_Uc_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu8i, aF_Uc_BFu8i)
//============================================================================



static void Test_aF_Uc_BFu8ll()
{
  {
    init_simple_test("aF_Uc_BFu8ll");
    static STRUCT_IF_C aF_Uc_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu8ll, aF_Uc_BFu8ll)
//============================================================================



static void Test_aF_Uc_BFu8s()
{
  {
    init_simple_test("aF_Uc_BFu8s");
    static STRUCT_IF_C aF_Uc_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu8s.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aF_Uc_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aF_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu8s, aF_Uc_BFu8s)
//============================================================================



static void Test_aF_Uc_BFu9i()
{
  {
    init_simple_test("aF_Uc_BFu9i");
    static STRUCT_IF_C aF_Uc_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aF_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu9i.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_Uc_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu9i, aF_Uc_BFu9i)
//============================================================================



static void Test_aF_Uc_BFu9ll()
{
  {
    init_simple_test("aF_Uc_BFu9ll");
    static STRUCT_IF_C aF_Uc_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aF_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu9ll, aF_Uc_BFu9ll)
//============================================================================



static void Test_aF_Uc_BFu9s()
{
  {
    init_simple_test("aF_Uc_BFu9s");
    static STRUCT_IF_C aF_Uc_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aF_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_Uc_BFu9s.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aF_Uc_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aF_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_BFu9s, aF_Uc_BFu9s)
//============================================================================



static void Test_aF_Uc_C()
{
  {
    init_simple_test("aF_Uc_C");
    STRUCT_IF_C aF_Uc_C lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_C)");
    check_field_offset(lv, v1, 0, "aF_Uc_C.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_C.v2");
    check_field_offset(lv, v3, 5, "aF_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_C, aF_Uc_C)
//============================================================================



static void Test_aF_Uc_D()
{
  {
    init_simple_test("aF_Uc_D");
    STRUCT_IF_C aF_Uc_D lv;
    check2(sizeof(lv), 13, "sizeof(aF_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_D)");
    check_field_offset(lv, v1, 0, "aF_Uc_D.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_D.v2");
    check_field_offset(lv, v3, 5, "aF_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_D, aF_Uc_D)
//============================================================================



static void Test_aF_Uc_F()
{
  {
    init_simple_test("aF_Uc_F");
    STRUCT_IF_C aF_Uc_F lv;
    check2(sizeof(lv), 9, "sizeof(aF_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_F)");
    check_field_offset(lv, v1, 0, "aF_Uc_F.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_F.v2");
    check_field_offset(lv, v3, 5, "aF_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_F, aF_Uc_F)
//============================================================================



static void Test_aF_Uc_I()
{
  {
    init_simple_test("aF_Uc_I");
    STRUCT_IF_C aF_Uc_I lv;
    check2(sizeof(lv), 9, "sizeof(aF_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_I)");
    check_field_offset(lv, v1, 0, "aF_Uc_I.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_I.v2");
    check_field_offset(lv, v3, 5, "aF_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_I, aF_Uc_I)
//============================================================================



static void Test_aF_Uc_Ip()
{
  {
    init_simple_test("aF_Uc_Ip");
    STRUCT_IF_C aF_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_Ip)");
    check_field_offset(lv, v1, 0, "aF_Uc_Ip.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_Ip.v2");
    check_field_offset(lv, v3, 5, "aF_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_Ip, aF_Uc_Ip)
//============================================================================



static void Test_aF_Uc_L()
{
  {
    init_simple_test("aF_Uc_L");
    STRUCT_IF_C aF_Uc_L lv;
    check2(sizeof(lv), 13, "sizeof(aF_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_L)");
    check_field_offset(lv, v1, 0, "aF_Uc_L.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_L.v2");
    check_field_offset(lv, v3, 5, "aF_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_L, aF_Uc_L)
//============================================================================



static void Test_aF_Uc_S()
{
  {
    init_simple_test("aF_Uc_S");
    STRUCT_IF_C aF_Uc_S lv;
    check2(sizeof(lv), 7, "sizeof(aF_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_S)");
    check_field_offset(lv, v1, 0, "aF_Uc_S.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_S.v2");
    check_field_offset(lv, v3, 5, "aF_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_S, aF_Uc_S)
//============================================================================



static void Test_aF_Uc_Uc()
{
  {
    init_simple_test("aF_Uc_Uc");
    STRUCT_IF_C aF_Uc_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aF_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_Uc)");
    check_field_offset(lv, v1, 0, "aF_Uc_Uc.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_Uc.v2");
    check_field_offset(lv, v3, 5, "aF_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_Uc, aF_Uc_Uc)
//============================================================================



static void Test_aF_Uc_Ui()
{
  {
    init_simple_test("aF_Uc_Ui");
    STRUCT_IF_C aF_Uc_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aF_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_Ui)");
    check_field_offset(lv, v1, 0, "aF_Uc_Ui.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_Ui.v2");
    check_field_offset(lv, v3, 5, "aF_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_Ui, aF_Uc_Ui)
//============================================================================



static void Test_aF_Uc_Ul()
{
  {
    init_simple_test("aF_Uc_Ul");
    STRUCT_IF_C aF_Uc_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aF_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_Ul)");
    check_field_offset(lv, v1, 0, "aF_Uc_Ul.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_Ul.v2");
    check_field_offset(lv, v3, 5, "aF_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_Ul, aF_Uc_Ul)
//============================================================================



static void Test_aF_Uc_Us()
{
  {
    init_simple_test("aF_Uc_Us");
    STRUCT_IF_C aF_Uc_Us lv;
    check2(sizeof(lv), 7, "sizeof(aF_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_Us)");
    check_field_offset(lv, v1, 0, "aF_Uc_Us.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_Us.v2");
    check_field_offset(lv, v3, 5, "aF_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_Us, aF_Uc_Us)
//============================================================================



static void Test_aF_Uc_Vp()
{
  {
    init_simple_test("aF_Uc_Vp");
    STRUCT_IF_C aF_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aF_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Uc_Vp)");
    check_field_offset(lv, v1, 0, "aF_Uc_Vp.v1");
    check_field_offset(lv, v2, 4, "aF_Uc_Vp.v2");
    check_field_offset(lv, v3, 5, "aF_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Uc_Vp, aF_Uc_Vp)
//============================================================================



static void Test_aF_Ui()
{
  {
    init_simple_test("aF_Ui");
    STRUCT_IF_C aF_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aF_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui)");
    check_field_offset(lv, v1, 0, "aF_Ui.v1");
    check_field_offset(lv, v2, 4, "aF_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui, aF_Ui)
//============================================================================



static void Test_aF_Ui_BFu15i()
{
  {
    init_simple_test("aF_Ui_BFu15i");
    static STRUCT_IF_C aF_Ui_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aF_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu15i.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_Ui_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu15i, aF_Ui_BFu15i)
//============================================================================



static void Test_aF_Ui_BFu15ll()
{
  {
    init_simple_test("aF_Ui_BFu15ll");
    static STRUCT_IF_C aF_Ui_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu15ll, aF_Ui_BFu15ll)
//============================================================================



static void Test_aF_Ui_BFu15s()
{
  {
    init_simple_test("aF_Ui_BFu15s");
    static STRUCT_IF_C aF_Ui_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aF_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu15s.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "aF_Ui_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "aF_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu15s, aF_Ui_BFu15s)
//============================================================================



static void Test_aF_Ui_BFu16i()
{
  {
    init_simple_test("aF_Ui_BFu16i");
    static STRUCT_IF_C aF_Ui_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aF_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_Ui_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu16i, aF_Ui_BFu16i)
//============================================================================



static void Test_aF_Ui_BFu16ll()
{
  {
    init_simple_test("aF_Ui_BFu16ll");
    static STRUCT_IF_C aF_Ui_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu16ll, aF_Ui_BFu16ll)
//============================================================================



static void Test_aF_Ui_BFu16s()
{
  {
    init_simple_test("aF_Ui_BFu16s");
    static STRUCT_IF_C aF_Ui_BFu16s lv;
    check2(sizeof(lv), 10, "sizeof(aF_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "aF_Ui_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "aF_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu16s, aF_Ui_BFu16s)
//============================================================================



static void Test_aF_Ui_BFu17i()
{
  {
    init_simple_test("aF_Ui_BFu17i");
    static STRUCT_IF_C aF_Ui_BFu17i lv;
    check2(sizeof(lv), 11, "sizeof(aF_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aF_Ui_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aF_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu17i, aF_Ui_BFu17i)
//============================================================================



static void Test_aF_Ui_BFu17ll()
{
  {
    init_simple_test("aF_Ui_BFu17ll");
    static STRUCT_IF_C aF_Ui_BFu17ll lv;
    check2(sizeof(lv), 11, "sizeof(aF_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "aF_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "aF_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu17ll, aF_Ui_BFu17ll)
//============================================================================



static void Test_aF_Ui_BFu1c()
{
  {
    init_simple_test("aF_Ui_BFu1c");
    static STRUCT_IF_C aF_Ui_BFu1c lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu1c, aF_Ui_BFu1c)
//============================================================================



static void Test_aF_Ui_BFu1i()
{
  {
    init_simple_test("aF_Ui_BFu1i");
    static STRUCT_IF_C aF_Ui_BFu1i lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu1i, aF_Ui_BFu1i)
//============================================================================



static void Test_aF_Ui_BFu1ll()
{
  {
    init_simple_test("aF_Ui_BFu1ll");
    static STRUCT_IF_C aF_Ui_BFu1ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu1ll, aF_Ui_BFu1ll)
//============================================================================



static void Test_aF_Ui_BFu1s()
{
  {
    init_simple_test("aF_Ui_BFu1s");
    static STRUCT_IF_C aF_Ui_BFu1s lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 8, 0, 1, 1, "aF_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu1s, aF_Ui_BFu1s)
//============================================================================



static void Test_aF_Ui_BFu31i()
{
  {
    init_simple_test("aF_Ui_BFu31i");
    static STRUCT_IF_C aF_Ui_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(aF_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "aF_Ui_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "aF_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu31i, aF_Ui_BFu31i)
//============================================================================



static void Test_aF_Ui_BFu31ll()
{
  {
    init_simple_test("aF_Ui_BFu31ll");
    static STRUCT_IF_C aF_Ui_BFu31ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "aF_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "aF_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu31ll, aF_Ui_BFu31ll)
//============================================================================



static void Test_aF_Ui_BFu32i()
{
  {
    init_simple_test("aF_Ui_BFu32i");
    static STRUCT_IF_C aF_Ui_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(aF_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "aF_Ui_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "aF_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu32i, aF_Ui_BFu32i)
//============================================================================



static void Test_aF_Ui_BFu32ll()
{
  {
    init_simple_test("aF_Ui_BFu32ll");
    static STRUCT_IF_C aF_Ui_BFu32ll lv;
    check2(sizeof(lv), 12, "sizeof(aF_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "aF_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "aF_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu32ll, aF_Ui_BFu32ll)
//============================================================================



static void Test_aF_Ui_BFu33()
{
  {
    init_simple_test("aF_Ui_BFu33");
    static STRUCT_IF_C aF_Ui_BFu33 lv;
    check2(sizeof(lv), 13, "sizeof(aF_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu33.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 8, 0, 33, 1, "aF_Ui_BFu33");
    set_bf_and_test(lv, v3, 8, 0, 33, hide_ull(1LL<<32), "aF_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu33, aF_Ui_BFu33)
//============================================================================



static void Test_aF_Ui_BFu7c()
{
  {
    init_simple_test("aF_Ui_BFu7c");
    static STRUCT_IF_C aF_Ui_BFu7c lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_Ui_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu7c, aF_Ui_BFu7c)
//============================================================================



static void Test_aF_Ui_BFu7i()
{
  {
    init_simple_test("aF_Ui_BFu7i");
    static STRUCT_IF_C aF_Ui_BFu7i lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_Ui_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu7i, aF_Ui_BFu7i)
//============================================================================



static void Test_aF_Ui_BFu7ll()
{
  {
    init_simple_test("aF_Ui_BFu7ll");
    static STRUCT_IF_C aF_Ui_BFu7ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu7ll, aF_Ui_BFu7ll)
//============================================================================



static void Test_aF_Ui_BFu7s()
{
  {
    init_simple_test("aF_Ui_BFu7s");
    static STRUCT_IF_C aF_Ui_BFu7s lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "aF_Ui_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "aF_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu7s, aF_Ui_BFu7s)
//============================================================================



static void Test_aF_Ui_BFu8c()
{
  {
    init_simple_test("aF_Ui_BFu8c");
    static STRUCT_IF_C aF_Ui_BFu8c lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_Ui_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu8c, aF_Ui_BFu8c)
//============================================================================



static void Test_aF_Ui_BFu8i()
{
  {
    init_simple_test("aF_Ui_BFu8i");
    static STRUCT_IF_C aF_Ui_BFu8i lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_Ui_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu8i, aF_Ui_BFu8i)
//============================================================================



static void Test_aF_Ui_BFu8ll()
{
  {
    init_simple_test("aF_Ui_BFu8ll");
    static STRUCT_IF_C aF_Ui_BFu8ll lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu8ll, aF_Ui_BFu8ll)
//============================================================================



static void Test_aF_Ui_BFu8s()
{
  {
    init_simple_test("aF_Ui_BFu8s");
    static STRUCT_IF_C aF_Ui_BFu8s lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "aF_Ui_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "aF_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu8s, aF_Ui_BFu8s)
//============================================================================



static void Test_aF_Ui_BFu9i()
{
  {
    init_simple_test("aF_Ui_BFu9i");
    static STRUCT_IF_C aF_Ui_BFu9i lv;
    check2(sizeof(lv), 10, "sizeof(aF_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_Ui_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu9i, aF_Ui_BFu9i)
//============================================================================



static void Test_aF_Ui_BFu9ll()
{
  {
    init_simple_test("aF_Ui_BFu9ll");
    static STRUCT_IF_C aF_Ui_BFu9ll lv;
    check2(sizeof(lv), 10, "sizeof(aF_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu9ll, aF_Ui_BFu9ll)
//============================================================================



static void Test_aF_Ui_BFu9s()
{
  {
    init_simple_test("aF_Ui_BFu9s");
    static STRUCT_IF_C aF_Ui_BFu9s lv;
    check2(sizeof(lv), 10, "sizeof(aF_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "aF_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "aF_Ui_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "aF_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_BFu9s, aF_Ui_BFu9s)
//============================================================================



static void Test_aF_Ui_C()
{
  {
    init_simple_test("aF_Ui_C");
    STRUCT_IF_C aF_Ui_C lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_C)");
    check_field_offset(lv, v1, 0, "aF_Ui_C.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_C.v2");
    check_field_offset(lv, v3, 8, "aF_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_C, aF_Ui_C)
//============================================================================



static void Test_aF_Ui_D()
{
  {
    init_simple_test("aF_Ui_D");
    STRUCT_IF_C aF_Ui_D lv;
    check2(sizeof(lv), 16, "sizeof(aF_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_D)");
    check_field_offset(lv, v1, 0, "aF_Ui_D.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_D.v2");
    check_field_offset(lv, v3, 8, "aF_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_D, aF_Ui_D)
//============================================================================



static void Test_aF_Ui_F()
{
  {
    init_simple_test("aF_Ui_F");
    STRUCT_IF_C aF_Ui_F lv;
    check2(sizeof(lv), 12, "sizeof(aF_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_F)");
    check_field_offset(lv, v1, 0, "aF_Ui_F.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_F.v2");
    check_field_offset(lv, v3, 8, "aF_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_F, aF_Ui_F)
//============================================================================



static void Test_aF_Ui_I()
{
  {
    init_simple_test("aF_Ui_I");
    STRUCT_IF_C aF_Ui_I lv;
    check2(sizeof(lv), 12, "sizeof(aF_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_I)");
    check_field_offset(lv, v1, 0, "aF_Ui_I.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_I.v2");
    check_field_offset(lv, v3, 8, "aF_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_I, aF_Ui_I)
//============================================================================



static void Test_aF_Ui_Ip()
{
  {
    init_simple_test("aF_Ui_Ip");
    STRUCT_IF_C aF_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_Ip)");
    check_field_offset(lv, v1, 0, "aF_Ui_Ip.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_Ip.v2");
    check_field_offset(lv, v3, 8, "aF_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_Ip, aF_Ui_Ip)
//============================================================================



static void Test_aF_Ui_L()
{
  {
    init_simple_test("aF_Ui_L");
    STRUCT_IF_C aF_Ui_L lv;
    check2(sizeof(lv), 16, "sizeof(aF_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_L)");
    check_field_offset(lv, v1, 0, "aF_Ui_L.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_L.v2");
    check_field_offset(lv, v3, 8, "aF_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_L, aF_Ui_L)
//============================================================================



static void Test_aF_Ui_S()
{
  {
    init_simple_test("aF_Ui_S");
    STRUCT_IF_C aF_Ui_S lv;
    check2(sizeof(lv), 10, "sizeof(aF_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_S)");
    check_field_offset(lv, v1, 0, "aF_Ui_S.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_S.v2");
    check_field_offset(lv, v3, 8, "aF_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_S, aF_Ui_S)
//============================================================================



static void Test_aF_Ui_Uc()
{
  {
    init_simple_test("aF_Ui_Uc");
    STRUCT_IF_C aF_Ui_Uc lv;
    check2(sizeof(lv), 9, "sizeof(aF_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_Uc)");
    check_field_offset(lv, v1, 0, "aF_Ui_Uc.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_Uc.v2");
    check_field_offset(lv, v3, 8, "aF_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_Uc, aF_Ui_Uc)
//============================================================================



static void Test_aF_Ui_Ui()
{
  {
    init_simple_test("aF_Ui_Ui");
    STRUCT_IF_C aF_Ui_Ui lv;
    check2(sizeof(lv), 12, "sizeof(aF_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_Ui)");
    check_field_offset(lv, v1, 0, "aF_Ui_Ui.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_Ui.v2");
    check_field_offset(lv, v3, 8, "aF_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_Ui, aF_Ui_Ui)
//============================================================================



static void Test_aF_Ui_Ul()
{
  {
    init_simple_test("aF_Ui_Ul");
    STRUCT_IF_C aF_Ui_Ul lv;
    check2(sizeof(lv), 16, "sizeof(aF_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_Ul)");
    check_field_offset(lv, v1, 0, "aF_Ui_Ul.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_Ul.v2");
    check_field_offset(lv, v3, 8, "aF_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_Ul, aF_Ui_Ul)
//============================================================================



static void Test_aF_Ui_Us()
{
  {
    init_simple_test("aF_Ui_Us");
    STRUCT_IF_C aF_Ui_Us lv;
    check2(sizeof(lv), 10, "sizeof(aF_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_Us)");
    check_field_offset(lv, v1, 0, "aF_Ui_Us.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_Us.v2");
    check_field_offset(lv, v3, 8, "aF_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_Us, aF_Ui_Us)
//============================================================================



static void Test_aF_Ui_Vp()
{
  {
    init_simple_test("aF_Ui_Vp");
    STRUCT_IF_C aF_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(aF_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ui_Vp)");
    check_field_offset(lv, v1, 0, "aF_Ui_Vp.v1");
    check_field_offset(lv, v2, 4, "aF_Ui_Vp.v2");
    check_field_offset(lv, v3, 8, "aF_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ui_Vp, aF_Ui_Vp)
//============================================================================



static void Test_aF_Ul()
{
  {
    init_simple_test("aF_Ul");
    STRUCT_IF_C aF_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aF_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul)");
    check_field_offset(lv, v1, 0, "aF_Ul.v1");
    check_field_offset(lv, v2, 4, "aF_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul, aF_Ul)
//============================================================================



static void Test_aF_Ul_BFu15i()
{
  {
    init_simple_test("aF_Ul_BFu15i");
    static STRUCT_IF_C aF_Ul_BFu15i lv;
    check2(sizeof(lv), 14, "sizeof(aF_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu15i.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aF_Ul_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aF_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu15i, aF_Ul_BFu15i)
//============================================================================



static void Test_aF_Ul_BFu15ll()
{
  {
    init_simple_test("aF_Ul_BFu15ll");
    static STRUCT_IF_C aF_Ul_BFu15ll lv;
    check2(sizeof(lv), 14, "sizeof(aF_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aF_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aF_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu15ll, aF_Ul_BFu15ll)
//============================================================================



static void Test_aF_Ul_BFu15s()
{
  {
    init_simple_test("aF_Ul_BFu15s");
    static STRUCT_IF_C aF_Ul_BFu15s lv;
    check2(sizeof(lv), 14, "sizeof(aF_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu15s.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "aF_Ul_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "aF_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu15s, aF_Ul_BFu15s)
//============================================================================



static void Test_aF_Ul_BFu16i()
{
  {
    init_simple_test("aF_Ul_BFu16i");
    static STRUCT_IF_C aF_Ul_BFu16i lv;
    check2(sizeof(lv), 14, "sizeof(aF_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu16i.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aF_Ul_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aF_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu16i, aF_Ul_BFu16i)
//============================================================================



static void Test_aF_Ul_BFu16ll()
{
  {
    init_simple_test("aF_Ul_BFu16ll");
    static STRUCT_IF_C aF_Ul_BFu16ll lv;
    check2(sizeof(lv), 14, "sizeof(aF_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aF_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aF_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu16ll, aF_Ul_BFu16ll)
//============================================================================



static void Test_aF_Ul_BFu16s()
{
  {
    init_simple_test("aF_Ul_BFu16s");
    static STRUCT_IF_C aF_Ul_BFu16s lv;
    check2(sizeof(lv), 14, "sizeof(aF_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu16s.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "aF_Ul_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "aF_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu16s, aF_Ul_BFu16s)
//============================================================================



static void Test_aF_Ul_BFu17i()
{
  {
    init_simple_test("aF_Ul_BFu17i");
    static STRUCT_IF_C aF_Ul_BFu17i lv;
    check2(sizeof(lv), 15, "sizeof(aF_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu17i.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aF_Ul_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aF_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu17i, aF_Ul_BFu17i)
//============================================================================



static void Test_aF_Ul_BFu17ll()
{
  {
    init_simple_test("aF_Ul_BFu17ll");
    static STRUCT_IF_C aF_Ul_BFu17ll lv;
    check2(sizeof(lv), 15, "sizeof(aF_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "aF_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "aF_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu17ll, aF_Ul_BFu17ll)
//============================================================================



static void Test_aF_Ul_BFu1c()
{
  {
    init_simple_test("aF_Ul_BFu1c");
    static STRUCT_IF_C aF_Ul_BFu1c lv;
    check2(sizeof(lv), 13, "sizeof(aF_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu1c.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aF_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu1c, aF_Ul_BFu1c)
//============================================================================



static void Test_aF_Ul_BFu1i()
{
  {
    init_simple_test("aF_Ul_BFu1i");
    static STRUCT_IF_C aF_Ul_BFu1i lv;
    check2(sizeof(lv), 13, "sizeof(aF_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu1i.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aF_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu1i, aF_Ul_BFu1i)
//============================================================================



static void Test_aF_Ul_BFu1ll()
{
  {
    init_simple_test("aF_Ul_BFu1ll");
    static STRUCT_IF_C aF_Ul_BFu1ll lv;
    check2(sizeof(lv), 13, "sizeof(aF_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aF_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu1ll, aF_Ul_BFu1ll)
//============================================================================



static void Test_aF_Ul_BFu1s()
{
  {
    init_simple_test("aF_Ul_BFu1s");
    static STRUCT_IF_C aF_Ul_BFu1s lv;
    check2(sizeof(lv), 13, "sizeof(aF_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu1s.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "aF_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu1s, aF_Ul_BFu1s)
//============================================================================



static void Test_aF_Ul_BFu31i()
{
  {
    init_simple_test("aF_Ul_BFu31i");
    static STRUCT_IF_C aF_Ul_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(aF_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu31i.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aF_Ul_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aF_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu31i, aF_Ul_BFu31i)
//============================================================================



static void Test_aF_Ul_BFu31ll()
{
  {
    init_simple_test("aF_Ul_BFu31ll");
    static STRUCT_IF_C aF_Ul_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(aF_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "aF_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "aF_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu31ll, aF_Ul_BFu31ll)
//============================================================================



static void Test_aF_Ul_BFu32i()
{
  {
    init_simple_test("aF_Ul_BFu32i");
    static STRUCT_IF_C aF_Ul_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(aF_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu32i.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aF_Ul_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aF_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu32i, aF_Ul_BFu32i)
//============================================================================



static void Test_aF_Ul_BFu32ll()
{
  {
    init_simple_test("aF_Ul_BFu32ll");
    static STRUCT_IF_C aF_Ul_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(aF_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aF_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "aF_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, 4, "aF_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "aF_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "aF_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aF_Ul_BFu32ll, aF_Ul_BFu32ll)
//========================================