// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
struct __attribute__((packed)) aC_BFu33_C { char v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aC_BFu33_D { char v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aC_BFu33_F { char v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aC_BFu33_I { char v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aC_BFu33_Ip { char v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aC_BFu33_L { char v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aC_BFu33_S { char v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aC_BFu33_Uc { char v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aC_BFu33_Ui { char v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aC_BFu33_Ul { char v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aC_BFu33_Us { char v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aC_BFu33_Vp { char v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aC_BFu7c { char v1; unsigned char v2:7; };
struct __attribute__((packed)) aC_BFu7c_BFu15i { char v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aC_BFu7c_BFu15ll { char v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aC_BFu7c_BFu15s { char v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aC_BFu7c_BFu16i { char v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aC_BFu7c_BFu16ll { char v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aC_BFu7c_BFu16s { char v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aC_BFu7c_BFu17i { char v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aC_BFu7c_BFu17ll { char v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aC_BFu7c_BFu1c { char v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aC_BFu7c_BFu1i { char v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aC_BFu7c_BFu1ll { char v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aC_BFu7c_BFu1s { char v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aC_BFu7c_BFu31i { char v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aC_BFu7c_BFu31ll { char v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aC_BFu7c_BFu32i { char v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aC_BFu7c_BFu32ll { char v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aC_BFu7c_BFu33 { char v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aC_BFu7c_BFu7c { char v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aC_BFu7c_BFu7i { char v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aC_BFu7c_BFu7ll { char v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aC_BFu7c_BFu7s { char v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aC_BFu7c_BFu8c { char v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aC_BFu7c_BFu8i { char v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aC_BFu7c_BFu8ll { char v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aC_BFu7c_BFu8s { char v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aC_BFu7c_BFu9i { char v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aC_BFu7c_BFu9ll { char v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aC_BFu7c_BFu9s { char v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aC_BFu7c_C { char v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aC_BFu7c_D { char v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aC_BFu7c_F { char v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aC_BFu7c_I { char v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aC_BFu7c_Ip { char v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aC_BFu7c_L { char v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aC_BFu7c_S { char v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aC_BFu7c_Uc { char v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aC_BFu7c_Ui { char v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aC_BFu7c_Ul { char v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aC_BFu7c_Us { char v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aC_BFu7c_Vp { char v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aC_BFu7i { char v1; unsigned int v2:7; };
struct __attribute__((packed)) aC_BFu7i_BFu15i { char v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aC_BFu7i_BFu15ll { char v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aC_BFu7i_BFu15s { char v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aC_BFu7i_BFu16i { char v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aC_BFu7i_BFu16ll { char v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aC_BFu7i_BFu16s { char v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aC_BFu7i_BFu17i { char v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aC_BFu7i_BFu17ll { char v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aC_BFu7i_BFu1c { char v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aC_BFu7i_BFu1i { char v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aC_BFu7i_BFu1ll { char v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aC_BFu7i_BFu1s { char v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aC_BFu7i_BFu31i { char v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aC_BFu7i_BFu31ll { char v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aC_BFu7i_BFu32i { char v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aC_BFu7i_BFu32ll { char v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aC_BFu7i_BFu33 { char v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aC_BFu7i_BFu7c { char v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aC_BFu7i_BFu7i { char v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aC_BFu7i_BFu7ll { char v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aC_BFu7i_BFu7s { char v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aC_BFu7i_BFu8c { char v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aC_BFu7i_BFu8i { char v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aC_BFu7i_BFu8ll { char v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aC_BFu7i_BFu8s { char v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aC_BFu7i_BFu9i { char v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aC_BFu7i_BFu9ll { char v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aC_BFu7i_BFu9s { char v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aC_BFu7i_C { char v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aC_BFu7i_D { char v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aC_BFu7i_F { char v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aC_BFu7i_I { char v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aC_BFu7i_Ip { char v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aC_BFu7i_L { char v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aC_BFu7i_S { char v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aC_BFu7i_Uc { char v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aC_BFu7i_Ui { char v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aC_BFu7i_Ul { char v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aC_BFu7i_Us { char v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aC_BFu7i_Vp { char v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aC_BFu7ll { char v1; unsigned long long v2:7; };
struct __attribute__((packed)) aC_BFu7ll_BFu15i { char v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aC_BFu7ll_BFu15ll { char v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aC_BFu7ll_BFu15s { char v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aC_BFu7ll_BFu16i { char v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aC_BFu7ll_BFu16ll { char v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aC_BFu7ll_BFu16s { char v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aC_BFu7ll_BFu17i { char v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aC_BFu7ll_BFu17ll { char v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aC_BFu7ll_BFu1c { char v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aC_BFu7ll_BFu1i { char v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aC_BFu7ll_BFu1ll { char v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aC_BFu7ll_BFu1s { char v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aC_BFu7ll_BFu31i { char v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aC_BFu7ll_BFu31ll { char v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aC_BFu7ll_BFu32i { char v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aC_BFu7ll_BFu32ll { char v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aC_BFu7ll_BFu33 { char v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aC_BFu7ll_BFu7c { char v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aC_BFu7ll_BFu7i { char v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aC_BFu7ll_BFu7ll { char v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aC_BFu7ll_BFu7s { char v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aC_BFu7ll_BFu8c { char v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aC_BFu7ll_BFu8i { char v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aC_BFu7ll_BFu8ll { char v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aC_BFu7ll_BFu8s { char v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aC_BFu7ll_BFu9i { char v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aC_BFu7ll_BFu9ll { char v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aC_BFu7ll_BFu9s { char v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aC_BFu7ll_C { char v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aC_BFu7ll_D { char v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aC_BFu7ll_F { char v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aC_BFu7ll_I { char v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aC_BFu7ll_Ip { char v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aC_BFu7ll_L { char v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aC_BFu7ll_S { char v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aC_BFu7ll_Uc { char v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aC_BFu7ll_Ui { char v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aC_BFu7ll_Ul { char v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aC_BFu7ll_Us { char v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aC_BFu7ll_Vp { char v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aC_BFu7s { char v1; unsigned short v2:7; };
struct __attribute__((packed)) aC_BFu7s_BFu15i { char v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aC_BFu7s_BFu15ll { char v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aC_BFu7s_BFu15s { char v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aC_BFu7s_BFu16i { char v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aC_BFu7s_BFu16ll { char v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aC_BFu7s_BFu16s { char v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aC_BFu7s_BFu17i { char v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aC_BFu7s_BFu17ll { char v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aC_BFu7s_BFu1c { char v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aC_BFu7s_BFu1i { char v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aC_BFu7s_BFu1ll { char v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aC_BFu7s_BFu1s { char v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aC_BFu7s_BFu31i { char v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aC_BFu7s_BFu31ll { char v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aC_BFu7s_BFu32i { char v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aC_BFu7s_BFu32ll { char v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aC_BFu7s_BFu33 { char v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aC_BFu7s_BFu7c { char v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aC_BFu7s_BFu7i { char v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aC_BFu7s_BFu7ll { char v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aC_BFu7s_BFu7s { char v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aC_BFu7s_BFu8c { char v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aC_BFu7s_BFu8i { char v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aC_BFu7s_BFu8ll { char v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aC_BFu7s_BFu8s { char v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aC_BFu7s_BFu9i { char v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aC_BFu7s_BFu9ll { char v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aC_BFu7s_BFu9s { char v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aC_BFu7s_C { char v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aC_BFu7s_D { char v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aC_BFu7s_F { char v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aC_BFu7s_I { char v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aC_BFu7s_Ip { char v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aC_BFu7s_L { char v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aC_BFu7s_S { char v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aC_BFu7s_Uc { char v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aC_BFu7s_Ui { char v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aC_BFu7s_Ul { char v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aC_BFu7s_Us { char v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aC_BFu7s_Vp { char v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aC_BFu8c { char v1; unsigned char v2:8; };
struct __attribute__((packed)) aC_BFu8c_BFu15i { char v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aC_BFu8c_BFu15ll { char v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aC_BFu8c_BFu15s { char v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aC_BFu8c_BFu16i { char v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aC_BFu8c_BFu16ll { char v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aC_BFu8c_BFu16s { char v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aC_BFu8c_BFu17i { char v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aC_BFu8c_BFu17ll { char v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aC_BFu8c_BFu1c { char v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aC_BFu8c_BFu1i { char v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aC_BFu8c_BFu1ll { char v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aC_BFu8c_BFu1s { char v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aC_BFu8c_BFu31i { char v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aC_BFu8c_BFu31ll { char v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aC_BFu8c_BFu32i { char v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aC_BFu8c_BFu32ll { char v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aC_BFu8c_BFu33 { char v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aC_BFu8c_BFu7c { char v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aC_BFu8c_BFu7i { char v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aC_BFu8c_BFu7ll { char v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aC_BFu8c_BFu7s { char v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aC_BFu8c_BFu8c { char v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aC_BFu8c_BFu8i { char v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aC_BFu8c_BFu8ll { char v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aC_BFu8c_BFu8s { char v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aC_BFu8c_BFu9i { char v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aC_BFu8c_BFu9ll { char v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aC_BFu8c_BFu9s { char v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aC_BFu8c_C { char v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aC_BFu8c_D { char v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aC_BFu8c_F { char v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aC_BFu8c_I { char v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aC_BFu8c_Ip { char v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aC_BFu8c_L { char v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aC_BFu8c_S { char v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aC_BFu8c_Uc { char v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aC_BFu8c_Ui { char v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aC_BFu8c_Ul { char v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aC_BFu8c_Us { char v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aC_BFu8c_Vp { char v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aC_BFu8i { char v1; unsigned int v2:8; };
struct __attribute__((packed)) aC_BFu8i_BFu15i { char v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aC_BFu8i_BFu15ll { char v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aC_BFu8i_BFu15s { char v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aC_BFu8i_BFu16i { char v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aC_BFu8i_BFu16ll { char v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aC_BFu8i_BFu16s { char v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aC_BFu8i_BFu17i { char v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aC_BFu8i_BFu17ll { char v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aC_BFu8i_BFu1c { char v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aC_BFu8i_BFu1i { char v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aC_BFu8i_BFu1ll { char v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aC_BFu8i_BFu1s { char v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aC_BFu8i_BFu31i { char v1; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aC_BFu8i_BFu31ll { char v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aC_BFu8i_BFu32i { char v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aC_BFu8i_BFu32ll { char v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aC_BFu8i_BFu33 { char v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aC_BFu8i_BFu7c { char v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aC_BFu8i_BFu7i { char v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aC_BFu8i_BFu7ll { char v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aC_BFu8i_BFu7s { char v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aC_BFu8i_BFu8c { char v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aC_BFu8i_BFu8i { char v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aC_BFu8i_BFu8ll { char v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aC_BFu8i_BFu8s { char v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aC_BFu8i_BFu9i { char v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aC_BFu8i_BFu9ll { char v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aC_BFu8i_BFu9s { char v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aC_BFu8i_C { char v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aC_BFu8i_D { char v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aC_BFu8i_F { char v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aC_BFu8i_I { char v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aC_BFu8i_Ip { char v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aC_BFu8i_L { char v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aC_BFu8i_S { char v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aC_BFu8i_Uc { char v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aC_BFu8i_Ui { char v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aC_BFu8i_Ul { char v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aC_BFu8i_Us { char v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aC_BFu8i_Vp { char v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aC_BFu8ll { char v1; unsigned long long v2:8; };
struct __attribute__((packed)) aC_BFu8ll_BFu15i { char v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aC_BFu8ll_BFu15ll { char v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aC_BFu8ll_BFu15s { char v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aC_BFu8ll_BFu16i { char v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aC_BFu8ll_BFu16ll { char v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aC_BFu8ll_BFu16s { char v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aC_BFu8ll_BFu17i { char v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aC_BFu8ll_BFu17ll { char v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aC_BFu8ll_BFu1c { char v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aC_BFu8ll_BFu1i { char v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aC_BFu8ll_BFu1ll { char v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aC_BFu8ll_BFu1s { char v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aC_BFu8ll_BFu31i { char v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aC_BFu8ll_BFu31ll { char v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aC_BFu8ll_BFu32i { char v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aC_BFu8ll_BFu32ll { char v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aC_BFu8ll_BFu33 { char v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aC_BFu8ll_BFu7c { char v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aC_BFu8ll_BFu7i { char v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aC_BFu8ll_BFu7ll { char v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aC_BFu8ll_BFu7s { char v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aC_BFu8ll_BFu8c { char v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aC_BFu8ll_BFu8i { char v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aC_BFu8ll_BFu8ll { char v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aC_BFu8ll_BFu8s { char v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aC_BFu8ll_BFu9i { char v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aC_BFu8ll_BFu9ll { char v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aC_BFu8ll_BFu9s { char v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aC_BFu8ll_C { char v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aC_BFu8ll_D { char v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aC_BFu8ll_F { char v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aC_BFu8ll_I { char v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aC_BFu8ll_Ip { char v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aC_BFu8ll_L { char v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aC_BFu8ll_S { char v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aC_BFu8ll_Uc { char v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aC_BFu8ll_Ui { char v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aC_BFu8ll_Ul { char v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aC_BFu8ll_Us { char v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aC_BFu8ll_Vp { char v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aC_BFu8s { char v1; unsigned short v2:8; };
struct __attribute__((packed)) aC_BFu8s_BFu15i { char v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aC_BFu8s_BFu15ll { char v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aC_BFu8s_BFu15s { char v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aC_BFu8s_BFu16i { char v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aC_BFu8s_BFu16ll { char v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aC_BFu8s_BFu16s { char v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aC_BFu8s_BFu17i { char v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aC_BFu8s_BFu17ll { char v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aC_BFu8s_BFu1c { char v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aC_BFu8s_BFu1i { char v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aC_BFu8s_BFu1ll { char v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aC_BFu8s_BFu1s { char v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aC_BFu8s_BFu31i { char v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aC_BFu8s_BFu31ll { char v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aC_BFu8s_BFu32i { char v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aC_BFu8s_BFu32ll { char v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aC_BFu8s_BFu33 { char v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aC_BFu8s_BFu7c { char v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aC_BFu8s_BFu7i { char v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aC_BFu8s_BFu7ll { char v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aC_BFu8s_BFu7s { char v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aC_BFu8s_BFu8c { char v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aC_BFu8s_BFu8i { char v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aC_BFu8s_BFu8ll { char v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aC_BFu8s_BFu8s { char v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aC_BFu8s_BFu9i { char v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aC_BFu8s_BFu9ll { char v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aC_BFu8s_BFu9s { char v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aC_BFu8s_C { char v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aC_BFu8s_D { char v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aC_BFu8s_F { char v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aC_BFu8s_I { char v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aC_BFu8s_Ip { char v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aC_BFu8s_L { char v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aC_BFu8s_S { char v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aC_BFu8s_Uc { char v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aC_BFu8s_Ui { char v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aC_BFu8s_Ul { char v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aC_BFu8s_Us { char v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aC_BFu8s_Vp { char v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aC_BFu9i { char v1; unsigned int v2:9; };
struct __attribute__((packed)) aC_BFu9i_BFu15i { char v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aC_BFu9i_BFu15ll { char v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aC_BFu9i_BFu15s { char v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aC_BFu9i_BFu16i { char v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aC_BFu9i_BFu16ll { char v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aC_BFu9i_BFu16s { char v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aC_BFu9i_BFu17i { char v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aC_BFu9i_BFu17ll { char v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aC_BFu9i_BFu1c { char v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aC_BFu9i_BFu1i { char v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aC_BFu9i_BFu1ll { char v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aC_BFu9i_BFu1s { char v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aC_BFu9i_BFu31i { char v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aC_BFu9i_BFu31ll { char v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aC_BFu9i_BFu32i { char v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aC_BFu9i_BFu32ll { char v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aC_BFu9i_BFu33 { char v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aC_BFu9i_BFu7c { char v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aC_BFu9i_BFu7i { char v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aC_BFu9i_BFu7ll { char v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aC_BFu9i_BFu7s { char v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aC_BFu9i_BFu8c { char v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aC_BFu9i_BFu8i { char v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aC_BFu9i_BFu8ll { char v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aC_BFu9i_BFu8s { char v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aC_BFu9i_BFu9i { char v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aC_BFu9i_BFu9ll { char v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aC_BFu9i_BFu9s { char v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aC_BFu9i_C { char v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aC_BFu9i_D { char v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aC_BFu9i_F { char v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aC_BFu9i_I { char v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aC_BFu9i_Ip { char v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aC_BFu9i_L { char v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aC_BFu9i_S { char v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aC_BFu9i_Uc { char v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aC_BFu9i_Ui { char v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aC_BFu9i_Ul { char v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aC_BFu9i_Us { char v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aC_BFu9i_Vp { char v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aC_BFu9ll { char v1; unsigned long long v2:9; };
struct __attribute__((packed)) aC_BFu9ll_BFu15i { char v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aC_BFu9ll_BFu15ll { char v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aC_BFu9ll_BFu15s { char v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aC_BFu9ll_BFu16i { char v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aC_BFu9ll_BFu16ll { char v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aC_BFu9ll_BFu16s { char v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aC_BFu9ll_BFu17i { char v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aC_BFu9ll_BFu17ll { char v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aC_BFu9ll_BFu1c { char v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aC_BFu9ll_BFu1i { char v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aC_BFu9ll_BFu1ll { char v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aC_BFu9ll_BFu1s { char v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aC_BFu9ll_BFu31i { char v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aC_BFu9ll_BFu31ll { char v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aC_BFu9ll_BFu32i { char v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aC_BFu9ll_BFu32ll { char v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aC_BFu9ll_BFu33 { char v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aC_BFu9ll_BFu7c { char v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aC_BFu9ll_BFu7i { char v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aC_BFu9ll_BFu7ll { char v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aC_BFu9ll_BFu7s { char v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aC_BFu9ll_BFu8c { char v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aC_BFu9ll_BFu8i { char v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aC_BFu9ll_BFu8ll { char v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aC_BFu9ll_BFu8s { char v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aC_BFu9ll_BFu9i { char v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aC_BFu9ll_BFu9ll { char v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aC_BFu9ll_BFu9s { char v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aC_BFu9ll_C { char v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aC_BFu9ll_D { char v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aC_BFu9ll_F { char v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aC_BFu9ll_I { char v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aC_BFu9ll_Ip { char v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aC_BFu9ll_L { char v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aC_BFu9ll_S { char v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aC_BFu9ll_Uc { char v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aC_BFu9ll_Ui { char v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aC_BFu9ll_Ul { char v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aC_BFu9ll_Us { char v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aC_BFu9ll_Vp { char v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aC_BFu9s { char v1; unsigned short v2:9; };
struct __attribute__((packed)) aC_BFu9s_BFu15i { char v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aC_BFu9s_BFu15ll { char v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aC_BFu9s_BFu15s { char v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aC_BFu9s_BFu16i { char v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aC_BFu9s_BFu16ll { char v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aC_BFu9s_BFu16s { char v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aC_BFu9s_BFu17i { char v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aC_BFu9s_BFu17ll { char v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aC_BFu9s_BFu1c { char v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aC_BFu9s_BFu1i { char v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aC_BFu9s_BFu1ll { char v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aC_BFu9s_BFu1s { char v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aC_BFu9s_BFu31i { char v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aC_BFu9s_BFu31ll { char v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aC_BFu9s_BFu32i { char v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aC_BFu9s_BFu32ll { char v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aC_BFu9s_BFu33 { char v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aC_BFu9s_BFu7c { char v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aC_BFu9s_BFu7i { char v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aC_BFu9s_BFu7ll { char v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aC_BFu9s_BFu7s { char v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aC_BFu9s_BFu8c { char v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aC_BFu9s_BFu8i { char v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aC_BFu9s_BFu8ll { char v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aC_BFu9s_BFu8s { char v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aC_BFu9s_BFu9i { char v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aC_BFu9s_BFu9ll { char v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aC_BFu9s_BFu9s { char v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aC_BFu9s_C { char v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aC_BFu9s_D { char v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aC_BFu9s_F { char v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aC_BFu9s_I { char v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aC_BFu9s_Ip { char v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aC_BFu9s_L { char v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aC_BFu9s_S { char v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aC_BFu9s_Uc { char v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aC_BFu9s_Ui { char v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aC_BFu9s_Ul { char v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aC_BFu9s_Us { char v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aC_BFu9s_Vp { char v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aC_C { char v1; char v2; };
struct __attribute__((packed)) aC_C_BFu15i { char v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_C_BFu15ll { char v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_C_BFu15s { char v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_C_BFu16i { char v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_C_BFu16ll { char v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_C_BFu16s { char v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_C_BFu17i { char v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_C_BFu17ll { char v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_C_BFu1c { char v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_C_BFu1i { char v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_C_BFu1ll { char v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_C_BFu1s { char v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_C_BFu31i { char v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_C_BFu31ll { char v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_C_BFu32i { char v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_C_BFu32ll { char v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_C_BFu33 { char v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_C_BFu7c { char v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_C_BFu7i { char v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_C_BFu7ll { char v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_C_BFu7s { char v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_C_BFu8c { char v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_C_BFu8i { char v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_C_BFu8ll { char v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_C_BFu8s { char v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_C_BFu9i { char v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_C_BFu9ll { char v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_C_BFu9s { char v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_C_C { char v1; char v2; char v3; };
struct __attribute__((packed)) aC_C_D { char v1; char v2; double v3; };
struct __attribute__((packed)) aC_C_F { char v1; char v2; float v3; };
struct __attribute__((packed)) aC_C_I { char v1; char v2; int v3; };
struct __attribute__((packed)) aC_C_Ip { char v1; char v2; int * v3; };
struct __attribute__((packed)) aC_C_L { char v1; char v2; long long v3; };
struct __attribute__((packed)) aC_C_S { char v1; char v2; short v3; };
struct __attribute__((packed)) aC_C_Uc { char v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aC_C_Ui { char v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aC_C_Ul { char v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aC_C_Us { char v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aC_C_Vp { char v1; char v2; void * v3; };
struct __attribute__((packed)) aC_D { char v1; double v2; };
struct __attribute__((packed)) aC_D_BFu15i { char v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_D_BFu15ll { char v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_D_BFu15s { char v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_D_BFu16i { char v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_D_BFu16ll { char v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_D_BFu16s { char v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_D_BFu17i { char v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_D_BFu17ll { char v1; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_D_BFu1c { char v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_D_BFu1i { char v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_D_BFu1ll { char v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_D_BFu1s { char v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_D_BFu31i { char v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_D_BFu31ll { char v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_D_BFu32i { char v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_D_BFu32ll { char v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_D_BFu33 { char v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_D_BFu7c { char v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_D_BFu7i { char v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_D_BFu7ll { char v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_D_BFu7s { char v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_D_BFu8c { char v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_D_BFu8i { char v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_D_BFu8ll { char v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_D_BFu8s { char v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_D_BFu9i { char v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_D_BFu9ll { char v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_D_BFu9s { char v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_D_C { char v1; double v2; char v3; };
struct __attribute__((packed)) aC_D_D { char v1; double v2; double v3; };
struct __attribute__((packed)) aC_D_F { char v1; double v2; float v3; };
struct __attribute__((packed)) aC_D_I { char v1; double v2; int v3; };
struct __attribute__((packed)) aC_D_Ip { char v1; double v2; int * v3; };
struct __attribute__((packed)) aC_D_L { char v1; double v2; long long v3; };
struct __attribute__((packed)) aC_D_S { char v1; double v2; short v3; };
struct __attribute__((packed)) aC_D_Uc { char v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aC_D_Ui { char v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aC_D_Ul { char v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aC_D_Us { char v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aC_D_Vp { char v1; double v2; void * v3; };
struct __attribute__((packed)) aC_F { char v1; float v2; };
struct __attribute__((packed)) aC_F_BFu15i { char v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_F_BFu15ll { char v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_F_BFu15s { char v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_F_BFu16i { char v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_F_BFu16ll { char v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_F_BFu16s { char v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_F_BFu17i { char v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_F_BFu17ll { char v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_F_BFu1c { char v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_F_BFu1i { char v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_F_BFu1ll { char v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_F_BFu1s { char v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_F_BFu31i { char v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_F_BFu31ll { char v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_F_BFu32i { char v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_F_BFu32ll { char v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_F_BFu33 { char v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_F_BFu7c { char v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_F_BFu7i { char v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_F_BFu7ll { char v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_F_BFu7s { char v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_F_BFu8c { char v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_F_BFu8i { char v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_F_BFu8ll { char v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_F_BFu8s { char v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_F_BFu9i { char v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_F_BFu9ll { char v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_F_BFu9s { char v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_F_C { char v1; float v2; char v3; };
struct __attribute__((packed)) aC_F_D { char v1; float v2; double v3; };
struct __attribute__((packed)) aC_F_F { char v1; float v2; float v3; };
struct __attribute__((packed)) aC_F_I { char v1; float v2; int v3; };
struct __attribute__((packed)) aC_F_Ip { char v1; float v2; int * v3; };
struct __attribute__((packed)) aC_F_L { char v1; float v2; long long v3; };
struct __attribute__((packed)) aC_F_S { char v1; float v2; short v3; };
struct __attribute__((packed)) aC_F_Uc { char v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aC_F_Ui { char v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aC_F_Ul { char v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aC_F_Us { char v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aC_F_Vp { char v1; float v2; void * v3; };
struct __attribute__((packed)) aC_I { char v1; int v2; };
struct __attribute__((packed)) aC_I_BFu15i { char v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_I_BFu15ll { char v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_I_BFu15s { char v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_I_BFu16i { char v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_I_BFu16ll { char v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_I_BFu16s { char v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_I_BFu17i { char v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_I_BFu17ll { char v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_I_BFu1c { char v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_I_BFu1i { char v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_I_BFu1ll { char v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_I_BFu1s { char v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_I_BFu31i { char v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_I_BFu31ll { char v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_I_BFu32i { char v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_I_BFu32ll { char v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_I_BFu33 { char v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_I_BFu7c { char v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_I_BFu7i { char v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_I_BFu7ll { char v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_I_BFu7s { char v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_I_BFu8c { char v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_I_BFu8i { char v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_I_BFu8ll { char v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_I_BFu8s { char v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_I_BFu9i { char v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_I_BFu9ll { char v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_I_BFu9s { char v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_I_C { char v1; int v2; char v3; };
struct __attribute__((packed)) aC_I_D { char v1; int v2; double v3; };
struct __attribute__((packed)) aC_I_F { char v1; int v2; float v3; };
struct __attribute__((packed)) aC_I_I { char v1; int v2; int v3; };
struct __attribute__((packed)) aC_I_Ip { char v1; int v2; int * v3; };
struct __attribute__((packed)) aC_I_L { char v1; int v2; long long v3; };
struct __attribute__((packed)) aC_I_S { char v1; int v2; short v3; };
struct __attribute__((packed)) aC_I_Uc { char v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aC_I_Ui { char v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aC_I_Ul { char v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aC_I_Us { char v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aC_I_Vp { char v1; int v2; void * v3; };
struct __attribute__((packed)) aC_Ip { char v1; int * v2; };
struct __attribute__((packed)) aC_Ip_BFu15i { char v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_Ip_BFu15ll { char v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_Ip_BFu15s { char v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_Ip_BFu16i { char v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_Ip_BFu16ll { char v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_Ip_BFu16s { char v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_Ip_BFu17i { char v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_Ip_BFu17ll { char v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_Ip_BFu1c { char v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_Ip_BFu1i { char v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_Ip_BFu1ll { char v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_Ip_BFu1s { char v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_Ip_BFu31i { char v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_Ip_BFu31ll { char v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_Ip_BFu32i { char v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_Ip_BFu32ll { char v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_Ip_BFu33 { char v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_Ip_BFu7c { char v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_Ip_BFu7i { char v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_Ip_BFu7ll { char v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_Ip_BFu7s { char v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_Ip_BFu8c { char v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_Ip_BFu8i { char v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_Ip_BFu8ll { char v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_Ip_BFu8s { char v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_Ip_BFu9i { char v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_Ip_BFu9ll { char v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_Ip_BFu9s { char v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_Ip_C { char v1; int * v2; char v3; };
struct __attribute__((packed)) aC_Ip_D { char v1; int * v2; double v3; };
struct __attribute__((packed)) aC_Ip_F { char v1; int * v2; float v3; };
struct __attribute__((packed)) aC_Ip_I { char v1; int * v2; int v3; };
struct __attribute__((packed)) aC_Ip_Ip { char v1; int * v2; int * v3; };
struct __attribute__((packed)) aC_Ip_L { char v1; int * v2; long long v3; };
struct __attribute__((packed)) aC_Ip_S { char v1; int * v2; short v3; };
struct __attribute__((packed)) aC_Ip_Uc { char v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aC_Ip_Ui { char v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aC_Ip_Ul { char v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aC_Ip_Us { char v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aC_Ip_Vp { char v1; int * v2; void * v3; };
struct __attribute__((packed)) aC_L { char v1; long long v2; };
struct __attribute__((packed)) aC_L_BFu15i { char v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_L_BFu15ll { char v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_L_BFu15s { char v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_L_BFu16i { char v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_L_BFu16ll { char v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_L_BFu16s { char v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_L_BFu17i { char v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_L_BFu17ll { char v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_L_BFu1c { char v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_L_BFu1i { char v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_L_BFu1ll { char v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_L_BFu1s { char v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_L_BFu31i { char v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_L_BFu31ll { char v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_L_BFu32i { char v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_L_BFu32ll { char v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_L_BFu33 { char v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_L_BFu7c { char v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_L_BFu7i { char v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_L_BFu7ll { char v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_L_BFu7s { char v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_L_BFu8c { char v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_L_BFu8i { char v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_L_BFu8ll { char v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_L_BFu8s { char v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_L_BFu9i { char v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_L_BFu9ll { char v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_L_BFu9s { char v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_L_C { char v1; long long v2; char v3; };
struct __attribute__((packed)) aC_L_D { char v1; long long v2; double v3; };
struct __attribute__((packed)) aC_L_F { char v1; long long v2; float v3; };
struct __attribute__((packed)) aC_L_I { char v1; long long v2; int v3; };
struct __attribute__((packed)) aC_L_Ip { char v1; long long v2; int * v3; };
struct __attribute__((packed)) aC_L_L { char v1; long long v2; long long v3; };
struct __attribute__((packed)) aC_L_S { char v1; long long v2; short v3; };
struct __attribute__((packed)) aC_L_Uc { char v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aC_L_Ui { char v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aC_L_Ul { char v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aC_L_Us { char v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aC_L_Vp { char v1; long long v2; void * v3; };
struct __attribute__((packed)) aC_S { char v1; short v2; };
struct __attribute__((packed)) aC_S_BFu15i { char v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_S_BFu15ll { char v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_S_BFu15s { char v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_S_BFu16i { char v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_S_BFu16ll { char v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_S_BFu16s { char v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_S_BFu17i { char v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_S_BFu17ll { char v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_S_BFu1c { char v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_S_BFu1i { char v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_S_BFu1ll { char v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_S_BFu1s { char v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_S_BFu31i { char v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_S_BFu31ll { char v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_S_BFu32i { char v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_S_BFu32ll { char v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_S_BFu33 { char v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_S_BFu7c { char v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_S_BFu7i { char v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_S_BFu7ll { char v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_S_BFu7s { char v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_S_BFu8c { char v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_S_BFu8i { char v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_S_BFu8ll { char v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_S_BFu8s { char v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_S_BFu9i { char v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_S_BFu9ll { char v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_S_BFu9s { char v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_S_C { char v1; short v2; char v3; };
struct __attribute__((packed)) aC_S_D { char v1; short v2; double v3; };
struct __attribute__((packed)) aC_S_F { char v1; short v2; float v3; };
struct __attribute__((packed)) aC_S_I { char v1; short v2; int v3; };
struct __attribute__((packed)) aC_S_Ip { char v1; short v2; int * v3; };
struct __attribute__((packed)) aC_S_L { char v1; short v2; long long v3; };
struct __attribute__((packed)) aC_S_S { char v1; short v2; short v3; };
struct __attribute__((packed)) aC_S_Uc { char v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aC_S_Ui { char v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aC_S_Ul { char v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aC_S_Us { char v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aC_S_Vp { char v1; short v2; void * v3; };
struct __attribute__((packed)) aC_Uc { char v1; unsigned char v2; };
struct __attribute__((packed)) aC_Uc_BFu15i { char v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_Uc_BFu15ll { char v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_Uc_BFu15s { char v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_Uc_BFu16i { char v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_Uc_BFu16ll { char v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_Uc_BFu16s { char v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_Uc_BFu17i { char v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_Uc_BFu17ll { char v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_Uc_BFu1c { char v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_Uc_BFu1i { char v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_Uc_BFu1ll { char v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_Uc_BFu1s { char v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_Uc_BFu31i { char v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_Uc_BFu31ll { char v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_Uc_BFu32i { char v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_Uc_BFu32ll { char v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_Uc_BFu33 { char v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_Uc_BFu7c { char v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_Uc_BFu7i { char v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_Uc_BFu7ll { char v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_Uc_BFu7s { char v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_Uc_BFu8c { char v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_Uc_BFu8i { char v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_Uc_BFu8ll { char v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_Uc_BFu8s { char v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_Uc_BFu9i { char v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_Uc_BFu9ll { char v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_Uc_BFu9s { char v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_Uc_C { char v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aC_Uc_D { char v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aC_Uc_F { char v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aC_Uc_I { char v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aC_Uc_Ip { char v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aC_Uc_L { char v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aC_Uc_S { char v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aC_Uc_Uc { char v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aC_Uc_Ui { char v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aC_Uc_Ul { char v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aC_Uc_Us { char v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aC_Uc_Vp { char v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aC_Ui { char v1; unsigned int v2; };
struct __attribute__((packed)) aC_Ui_BFu15i { char v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_Ui_BFu15ll { char v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_Ui_BFu15s { char v1; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_Ui_BFu16i { char v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_Ui_BFu16ll { char v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_Ui_BFu16s { char v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_Ui_BFu17i { char v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_Ui_BFu17ll { char v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_Ui_BFu1c { char v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_Ui_BFu1i { char v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_Ui_BFu1ll { char v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_Ui_BFu1s { char v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_Ui_BFu31i { char v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_Ui_BFu31ll { char v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_Ui_BFu32i { char v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_Ui_BFu32ll { char v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_Ui_BFu33 { char v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_Ui_BFu7c { char v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_Ui_BFu7i { char v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_Ui_BFu7ll { char v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_Ui_BFu7s { char v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_Ui_BFu8c { char v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_Ui_BFu8i { char v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_Ui_BFu8ll { char v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_Ui_BFu8s { char v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_Ui_BFu9i { char v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_Ui_BFu9ll { char v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_Ui_BFu9s { char v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_Ui_C { char v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aC_Ui_D { char v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aC_Ui_F { char v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aC_Ui_I { char v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aC_Ui_Ip { char v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aC_Ui_L { char v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aC_Ui_S { char v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aC_Ui_Uc { char v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aC_Ui_Ui { char v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aC_Ui_Ul { char v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aC_Ui_Us { char v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aC_Ui_Vp { char v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aC_Ul { char v1; unsigned long long v2; };
struct __attribute__((packed)) aC_Ul_BFu15i { char v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_Ul_BFu15ll { char v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_Ul_BFu15s { char v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_Ul_BFu16i { char v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_Ul_BFu16ll { char v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_Ul_BFu16s { char v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_Ul_BFu17i { char v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_Ul_BFu17ll { char v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_Ul_BFu1c { char v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_Ul_BFu1i { char v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_Ul_BFu1ll { char v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_Ul_BFu1s { char v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_Ul_BFu31i { char v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_Ul_BFu31ll { char v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_Ul_BFu32i { char v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_Ul_BFu32ll { char v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_Ul_BFu33 { char v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_Ul_BFu7c { char v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_Ul_BFu7i { char v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_Ul_BFu7ll { char v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_Ul_BFu7s { char v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_Ul_BFu8c { char v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_Ul_BFu8i { char v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_Ul_BFu8ll { char v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_Ul_BFu8s { char v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_Ul_BFu9i { char v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_Ul_BFu9ll { char v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_Ul_BFu9s { char v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_Ul_C { char v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aC_Ul_D { char v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aC_Ul_F { char v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aC_Ul_I { char v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aC_Ul_Ip { char v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aC_Ul_L { char v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aC_Ul_S { char v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aC_Ul_Uc { char v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aC_Ul_Ui { char v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aC_Ul_Ul { char v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aC_Ul_Us { char v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aC_Ul_Vp { char v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aC_Us { char v1; unsigned short v2; };
struct __attribute__((packed)) aC_Us_BFu15i { char v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_Us_BFu15ll { char v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_Us_BFu15s { char v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_Us_BFu16i { char v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_Us_BFu16ll { char v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_Us_BFu16s { char v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_Us_BFu17i { char v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_Us_BFu17ll { char v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_Us_BFu1c { char v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_Us_BFu1i { char v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_Us_BFu1ll { char v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_Us_BFu1s { char v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_Us_BFu31i { char v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_Us_BFu31ll { char v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_Us_BFu32i { char v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_Us_BFu32ll { char v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_Us_BFu33 { char v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_Us_BFu7c { char v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_Us_BFu7i { char v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_Us_BFu7ll { char v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_Us_BFu7s { char v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_Us_BFu8c { char v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_Us_BFu8i { char v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_Us_BFu8ll { char v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_Us_BFu8s { char v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_Us_BFu9i { char v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_Us_BFu9ll { char v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_Us_BFu9s { char v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_Us_C { char v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aC_Us_D { char v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aC_Us_F { char v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aC_Us_I { char v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aC_Us_Ip { char v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aC_Us_L { char v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aC_Us_S { char v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aC_Us_Uc { char v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aC_Us_Ui { char v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aC_Us_Ul { char v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aC_Us_Us { char v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aC_Us_Vp { char v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aC_Vp { char v1; void * v2; };
struct __attribute__((packed)) aC_Vp_BFu15i { char v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aC_Vp_BFu15ll { char v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aC_Vp_BFu15s { char v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aC_Vp_BFu16i { char v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aC_Vp_BFu16ll { char v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aC_Vp_BFu16s { char v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aC_Vp_BFu17i { char v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aC_Vp_BFu17ll { char v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aC_Vp_BFu1c { char v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aC_Vp_BFu1i { char v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aC_Vp_BFu1ll { char v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aC_Vp_BFu1s { char v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aC_Vp_BFu31i { char v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aC_Vp_BFu31ll { char v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aC_Vp_BFu32i { char v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aC_Vp_BFu32ll { char v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aC_Vp_BFu33 { char v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aC_Vp_BFu7c { char v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aC_Vp_BFu7i { char v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aC_Vp_BFu7ll { char v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aC_Vp_BFu7s { char v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aC_Vp_BFu8c { char v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aC_Vp_BFu8i { char v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aC_Vp_BFu8ll { char v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aC_Vp_BFu8s { char v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aC_Vp_BFu9i { char v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aC_Vp_BFu9ll { char v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aC_Vp_BFu9s { char v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aC_Vp_C { char v1; void * v2; char v3; };
struct __attribute__((packed)) aC_Vp_D { char v1; void * v2; double v3; };
struct __attribute__((packed)) aC_Vp_F { char v1; void * v2; float v3; };
struct __attribute__((packed)) aC_Vp_I { char v1; void * v2; int v3; };
struct __attribute__((packed)) aC_Vp_Ip { char v1; void * v2; int * v3; };
struct __attribute__((packed)) aC_Vp_L { char v1; void * v2; long long v3; };
struct __attribute__((packed)) aC_Vp_S { char v1; void * v2; short v3; };
struct __attribute__((packed)) aC_Vp_Uc { char v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aC_Vp_Ui { char v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aC_Vp_Ul { char v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aC_Vp_Us { char v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aC_Vp_Vp { char v1; void * v2; void * v3; };
struct __attribute__((packed)) aD { double v1; };
struct __attribute__((packed)) aD_BFu15i { double v1; unsigned int v2:15; };
struct __attribute__((packed)) aD_BFu15i_BFu15i { double v1; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu15i_BFu15ll { double v1; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu15i_BFu15s { double v1; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu15i_BFu16i { double v1; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu15i_BFu16ll { double v1; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu15i_BFu16s { double v1; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu15i_BFu17i { double v1; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu15i_BFu17ll { double v1; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu15i_BFu1c { double v1; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu15i_BFu1i { double v1; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu15i_BFu1ll { double v1; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu15i_BFu1s { double v1; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu15i_BFu31i { double v1; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu15i_BFu31ll { double v1; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu15i_BFu32i { double v1; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu15i_BFu32ll { double v1; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu15i_BFu33 { double v1; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu15i_BFu7c { double v1; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu15i_BFu7i { double v1; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu15i_BFu7ll { double v1; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu15i_BFu7s { double v1; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu15i_BFu8c { double v1; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu15i_BFu8i { double v1; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu15i_BFu8ll { double v1; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu15i_BFu8s { double v1; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu15i_BFu9i { double v1; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu15i_BFu9ll { double v1; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu15i_BFu9s { double v1; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu15i_C { double v1; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aD_BFu15i_D { double v1; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aD_BFu15i_F { double v1; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aD_BFu15i_I { double v1; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aD_BFu15i_Ip { double v1; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aD_BFu15i_L { double v1; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aD_BFu15i_S { double v1; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aD_BFu15i_Uc { double v1; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aD_BFu15i_Ui { double v1; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aD_BFu15i_Ul { double v1; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu15i_Us { double v1; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aD_BFu15i_Vp { double v1; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aD_BFu15ll { double v1; unsigned long long v2:15; };
struct __attribute__((packed)) aD_BFu15ll_BFu15i { double v1; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu15ll_BFu15ll { double v1; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu15ll_BFu15s { double v1; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu15ll_BFu16i { double v1; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu15ll_BFu16ll { double v1; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu15ll_BFu16s { double v1; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu15ll_BFu17i { double v1; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu15ll_BFu17ll { double v1; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu15ll_BFu1c { double v1; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu15ll_BFu1i { double v1; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu15ll_BFu1ll { double v1; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu15ll_BFu1s { double v1; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu15ll_BFu31i { double v1; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu15ll_BFu31ll { double v1; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu15ll_BFu32i { double v1; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu15ll_BFu32ll { double v1; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu15ll_BFu33 { double v1; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu15ll_BFu7c { double v1; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu15ll_BFu7i { double v1; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu15ll_BFu7ll { double v1; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu15ll_BFu7s { double v1; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu15ll_BFu8c { double v1; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu15ll_BFu8i { double v1; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu15ll_BFu8ll { double v1; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu15ll_BFu8s { double v1; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu15ll_BFu9i { double v1; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu15ll_BFu9ll { double v1; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu15ll_BFu9s { double v1; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu15ll_C { double v1; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aD_BFu15ll_D { double v1; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aD_BFu15ll_F { double v1; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aD_BFu15ll_I { double v1; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aD_BFu15ll_Ip { double v1; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aD_BFu15ll_L { double v1; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aD_BFu15ll_S { double v1; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aD_BFu15ll_Uc { double v1; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aD_BFu15ll_Ui { double v1; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aD_BFu15ll_Ul { double v1; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu15ll_Us { double v1; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aD_BFu15ll_Vp { double v1; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aD_BFu15s { double v1; unsigned short v2:15; };
struct __attribute__((packed)) aD_BFu15s_BFu15i { double v1; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu15s_BFu15ll { double v1; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu15s_BFu15s { double v1; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu15s_BFu16i { double v1; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu15s_BFu16ll { double v1; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu15s_BFu16s { double v1; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu15s_BFu17i { double v1; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu15s_BFu17ll { double v1; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu15s_BFu1c { double v1; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu15s_BFu1i { double v1; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu15s_BFu1ll { double v1; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu15s_BFu1s { double v1; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu15s_BFu31i { double v1; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu15s_BFu31ll { double v1; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu15s_BFu32i { double v1; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu15s_BFu32ll { double v1; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu15s_BFu33 { double v1; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu15s_BFu7c { double v1; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu15s_BFu7i { double v1; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu15s_BFu7ll { double v1; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu15s_BFu7s { double v1; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu15s_BFu8c { double v1; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu15s_BFu8i { double v1; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu15s_BFu8ll { double v1; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu15s_BFu8s { double v1; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu15s_BFu9i { double v1; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu15s_BFu9ll { double v1; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu15s_BFu9s { double v1; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu15s_C { double v1; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aD_BFu15s_D { double v1; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aD_BFu15s_F { double v1; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aD_BFu15s_I { double v1; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aD_BFu15s_Ip { double v1; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aD_BFu15s_L { double v1; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aD_BFu15s_S { double v1; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aD_BFu15s_Uc { double v1; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aD_BFu15s_Ui { double v1; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aD_BFu15s_Ul { double v1; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu15s_Us { double v1; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aD_BFu15s_Vp { double v1; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aD_BFu16i { double v1; unsigned int v2:16; };
struct __attribute__((packed)) aD_BFu16i_BFu15i { double v1; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu16i_BFu15ll { double v1; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu16i_BFu15s { double v1; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu16i_BFu16i { double v1; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu16i_BFu16ll { double v1; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu16i_BFu16s { double v1; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu16i_BFu17i { double v1; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu16i_BFu17ll { double v1; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu16i_BFu1c { double v1; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu16i_BFu1i { double v1; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu16i_BFu1ll { double v1; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu16i_BFu1s { double v1; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu16i_BFu31i { double v1; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu16i_BFu31ll { double v1; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu16i_BFu32i { double v1; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu16i_BFu32ll { double v1; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu16i_BFu33 { double v1; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu16i_BFu7c { double v1; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu16i_BFu7i { double v1; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu16i_BFu7ll { double v1; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu16i_BFu7s { double v1; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu16i_BFu8c { double v1; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu16i_BFu8i { double v1; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu16i_BFu8ll { double v1; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu16i_BFu8s { double v1; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu16i_BFu9i { double v1; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu16i_BFu9ll { double v1; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu16i_BFu9s { double v1; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu16i_C { double v1; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aD_BFu16i_D { double v1; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aD_BFu16i_F { double v1; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aD_BFu16i_I { double v1; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aD_BFu16i_Ip { double v1; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aD_BFu16i_L { double v1; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aD_BFu16i_S { double v1; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aD_BFu16i_Uc { double v1; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aD_BFu16i_Ui { double v1; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aD_BFu16i_Ul { double v1; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu16i_Us { double v1; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aD_BFu16i_Vp { double v1; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aD_BFu16ll { double v1; unsigned long long v2:16; };
struct __attribute__((packed)) aD_BFu16ll_BFu15i { double v1; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu16ll_BFu15ll { double v1; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu16ll_BFu15s { double v1; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu16ll_BFu16i { double v1; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu16ll_BFu16ll { double v1; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu16ll_BFu16s { double v1; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu16ll_BFu17i { double v1; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu16ll_BFu17ll { double v1; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu16ll_BFu1c { double v1; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu16ll_BFu1i { double v1; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu16ll_BFu1ll { double v1; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu16ll_BFu1s { double v1; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu16ll_BFu31i { double v1; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu16ll_BFu31ll { double v1; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu16ll_BFu32i { double v1; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu16ll_BFu32ll { double v1; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu16ll_BFu33 { double v1; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu16ll_BFu7c { double v1; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu16ll_BFu7i { double v1; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu16ll_BFu7ll { double v1; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu16ll_BFu7s { double v1; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu16ll_BFu8c { double v1; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu16ll_BFu8i { double v1; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu16ll_BFu8ll { double v1; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu16ll_BFu8s { double v1; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu16ll_BFu9i { double v1; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu16ll_BFu9ll { double v1; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu16ll_BFu9s { double v1; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu16ll_C { double v1; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aD_BFu16ll_D { double v1; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aD_BFu16ll_F { double v1; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aD_BFu16ll_I { double v1; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aD_BFu16ll_Ip { double v1; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aD_BFu16ll_L { double v1; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aD_BFu16ll_S { double v1; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aD_BFu16ll_Uc { double v1; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aD_BFu16ll_Ui { double v1; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aD_BFu16ll_Ul { double v1; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu16ll_Us { double v1; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aD_BFu16ll_Vp { double v1; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aD_BFu16s { double v1; unsigned short v2:16; };
struct __attribute__((packed)) aD_BFu16s_BFu15i { double v1; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu16s_BFu15ll { double v1; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu16s_BFu15s { double v1; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu16s_BFu16i { double v1; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu16s_BFu16ll { double v1; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu16s_BFu16s { double v1; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu16s_BFu17i { double v1; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu16s_BFu17ll { double v1; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu16s_BFu1c { double v1; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu16s_BFu1i { double v1; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu16s_BFu1ll { double v1; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu16s_BFu1s { double v1; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu16s_BFu31i { double v1; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu16s_BFu31ll { double v1; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu16s_BFu32i { double v1; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu16s_BFu32ll { double v1; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu16s_BFu33 { double v1; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu16s_BFu7c { double v1; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu16s_BFu7i { double v1; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu16s_BFu7ll { double v1; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu16s_BFu7s { double v1; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu16s_BFu8c { double v1; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu16s_BFu8i { double v1; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu16s_BFu8ll { double v1; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu16s_BFu8s { double v1; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu16s_BFu9i { double v1; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu16s_BFu9ll { double v1; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu16s_BFu9s { double v1; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu16s_C { double v1; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aD_BFu16s_D { double v1; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aD_BFu16s_F { double v1; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aD_BFu16s_I { double v1; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aD_BFu16s_Ip { double v1; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aD_BFu16s_L { double v1; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aD_BFu16s_S { double v1; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aD_BFu16s_Uc { double v1; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aD_BFu16s_Ui { double v1; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aD_BFu16s_Ul { double v1; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu16s_Us { double v1; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aD_BFu16s_Vp { double v1; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aD_BFu17i { double v1; unsigned int v2:17; };
struct __attribute__((packed)) aD_BFu17i_BFu15i { double v1; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu17i_BFu15ll { double v1; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu17i_BFu15s { double v1; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu17i_BFu16i { double v1; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu17i_BFu16ll { double v1; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu17i_BFu16s { double v1; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu17i_BFu17i { double v1; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu17i_BFu17ll { double v1; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu17i_BFu1c { double v1; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu17i_BFu1i { double v1; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu17i_BFu1ll { double v1; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu17i_BFu1s { double v1; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu17i_BFu31i { double v1; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu17i_BFu31ll { double v1; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu17i_BFu32i { double v1; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu17i_BFu32ll { double v1; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu17i_BFu33 { double v1; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu17i_BFu7c { double v1; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu17i_BFu7i { double v1; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu17i_BFu7ll { double v1; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu17i_BFu7s { double v1; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu17i_BFu8c { double v1; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu17i_BFu8i { double v1; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu17i_BFu8ll { double v1; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu17i_BFu8s { double v1; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu17i_BFu9i { double v1; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu17i_BFu9ll { double v1; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu17i_BFu9s { double v1; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu17i_C { double v1; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aD_BFu17i_D { double v1; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aD_BFu17i_F { double v1; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aD_BFu17i_I { double v1; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aD_BFu17i_Ip { double v1; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aD_BFu17i_L { double v1; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aD_BFu17i_S { double v1; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aD_BFu17i_Uc { double v1; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aD_BFu17i_Ui { double v1; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aD_BFu17i_Ul { double v1; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu17i_Us { double v1; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aD_BFu17i_Vp { double v1; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aD_BFu17ll { double v1; unsigned long long v2:17; };
struct __attribute__((packed)) aD_BFu17ll_BFu15i { double v1; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu17ll_BFu15ll { double v1; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu17ll_BFu15s { double v1; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu17ll_BFu16i { double v1; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu17ll_BFu16ll { double v1; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu17ll_BFu16s { double v1; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu17ll_BFu17i { double v1; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu17ll_BFu17ll { double v1; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu17ll_BFu1c { double v1; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu17ll_BFu1i { double v1; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu17ll_BFu1ll { double v1; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu17ll_BFu1s { double v1; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu17ll_BFu31i { double v1; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu17ll_BFu31ll { double v1; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu17ll_BFu32i { double v1; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu17ll_BFu32ll { double v1; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu17ll_BFu33 { double v1; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu17ll_BFu7c { double v1; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu17ll_BFu7i { double v1; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu17ll_BFu7ll { double v1; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu17ll_BFu7s { double v1; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu17ll_BFu8c { double v1; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu17ll_BFu8i { double v1; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu17ll_BFu8ll { double v1; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu17ll_BFu8s { double v1; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu17ll_BFu9i { double v1; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu17ll_BFu9ll { double v1; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu17ll_BFu9s { double v1; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu17ll_C { double v1; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aD_BFu17ll_D { double v1; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aD_BFu17ll_F { double v1; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aD_BFu17ll_I { double v1; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aD_BFu17ll_Ip { double v1; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aD_BFu17ll_L { double v1; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aD_BFu17ll_S { double v1; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aD_BFu17ll_Uc { double v1; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aD_BFu17ll_Ui { double v1; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aD_BFu17ll_Ul { double v1; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu17ll_Us { double v1; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aD_BFu17ll_Vp { double v1; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aD_BFu1c { double v1; unsigned char v2:1; };
struct __attribute__((packed)) aD_BFu1c_BFu15i { double v1; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu1c_BFu15ll { double v1; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu1c_BFu15s { double v1; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu1c_BFu16i { double v1; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu1c_BFu16ll { double v1; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu1c_BFu16s { double v1; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu1c_BFu17i { double v1; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu1c_BFu17ll { double v1; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu1c_BFu1c { double v1; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu1c_BFu1i { double v1; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu1c_BFu1ll { double v1; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu1c_BFu1s { double v1; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu1c_BFu31i { double v1; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu1c_BFu31ll { double v1; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu1c_BFu32i { double v1; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu1c_BFu32ll { double v1; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu1c_BFu33 { double v1; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu1c_BFu7c { double v1; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu1c_BFu7i { double v1; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu1c_BFu7ll { double v1; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu1c_BFu7s { double v1; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu1c_BFu8c { double v1; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu1c_BFu8i { double v1; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu1c_BFu8ll { double v1; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu1c_BFu8s { double v1; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu1c_BFu9i { double v1; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu1c_BFu9ll { double v1; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu1c_BFu9s { double v1; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu1c_C { double v1; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aD_BFu1c_D { double v1; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aD_BFu1c_F { double v1; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aD_BFu1c_I { double v1; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aD_BFu1c_Ip { double v1; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aD_BFu1c_L { double v1; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aD_BFu1c_S { double v1; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aD_BFu1c_Uc { double v1; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aD_BFu1c_Ui { double v1; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aD_BFu1c_Ul { double v1; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu1c_Us { double v1; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aD_BFu1c_Vp { double v1; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aD_BFu1i { double v1; unsigned int v2:1; };
struct __attribute__((packed)) aD_BFu1i_BFu15i { double v1; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu1i_BFu15ll { double v1; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu1i_BFu15s { double v1; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu1i_BFu16i { double v1; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu1i_BFu16ll { double v1; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu1i_BFu16s { double v1; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu1i_BFu17i { double v1; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu1i_BFu17ll { double v1; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu1i_BFu1c { double v1; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu1i_BFu1i { double v1; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu1i_BFu1ll { double v1; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu1i_BFu1s { double v1; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu1i_BFu31i { double v1; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu1i_BFu31ll { double v1; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu1i_BFu32i { double v1; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu1i_BFu32ll { double v1; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu1i_BFu33 { double v1; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu1i_BFu7c { double v1; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu1i_BFu7i { double v1; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu1i_BFu7ll { double v1; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu1i_BFu7s { double v1; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu1i_BFu8c { double v1; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu1i_BFu8i { double v1; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu1i_BFu8ll { double v1; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu1i_BFu8s { double v1; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu1i_BFu9i { double v1; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu1i_BFu9ll { double v1; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu1i_BFu9s { double v1; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu1i_C { double v1; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aD_BFu1i_D { double v1; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aD_BFu1i_F { double v1; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aD_BFu1i_I { double v1; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aD_BFu1i_Ip { double v1; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aD_BFu1i_L { double v1; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aD_BFu1i_S { double v1; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aD_BFu1i_Uc { double v1; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aD_BFu1i_Ui { double v1; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aD_BFu1i_Ul { double v1; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu1i_Us { double v1; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aD_BFu1i_Vp { double v1; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aD_BFu1ll { double v1; unsigned long long v2:1; };
struct __attribute__((packed)) aD_BFu1ll_BFu15i { double v1; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu1ll_BFu15ll { double v1; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu1ll_BFu15s { double v1; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu1ll_BFu16i { double v1; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu1ll_BFu16ll { double v1; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu1ll_BFu16s { double v1; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu1ll_BFu17i { double v1; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu1ll_BFu17ll { double v1; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu1ll_BFu1c { double v1; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu1ll_BFu1i { double v1; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu1ll_BFu1ll { double v1; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu1ll_BFu1s { double v1; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu1ll_BFu31i { double v1; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu1ll_BFu31ll { double v1; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu1ll_BFu32i { double v1; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu1ll_BFu32ll { double v1; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu1ll_BFu33 { double v1; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu1ll_BFu7c { double v1; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu1ll_BFu7i { double v1; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu1ll_BFu7ll { double v1; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu1ll_BFu7s { double v1; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu1ll_BFu8c { double v1; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu1ll_BFu8i { double v1; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu1ll_BFu8ll { double v1; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu1ll_BFu8s { double v1; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu1ll_BFu9i { double v1; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu1ll_BFu9ll { double v1; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu1ll_BFu9s { double v1; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu1ll_C { double v1; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aD_BFu1ll_D { double v1; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aD_BFu1ll_F { double v1; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aD_BFu1ll_I { double v1; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aD_BFu1ll_Ip { double v1; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aD_BFu1ll_L { double v1; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aD_BFu1ll_S { double v1; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aD_BFu1ll_Uc { double v1; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aD_BFu1ll_Ui { double v1; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aD_BFu1ll_Ul { double v1; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu1ll_Us { double v1; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aD_BFu1ll_Vp { double v1; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aD_BFu1s { double v1; unsigned short v2:1; };
struct __attribute__((packed)) aD_BFu1s_BFu15i { double v1; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu1s_BFu15ll { double v1; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu1s_BFu15s { double v1; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu1s_BFu16i { double v1; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu1s_BFu16ll { double v1; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu1s_BFu16s { double v1; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu1s_BFu17i { double v1; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu1s_BFu17ll { double v1; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu1s_BFu1c { double v1; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu1s_BFu1i { double v1; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu1s_BFu1ll { double v1; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu1s_BFu1s { double v1; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu1s_BFu31i { double v1; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu1s_BFu31ll { double v1; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu1s_BFu32i { double v1; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu1s_BFu32ll { double v1; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu1s_BFu33 { double v1; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu1s_BFu7c { double v1; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu1s_BFu7i { double v1; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu1s_BFu7ll { double v1; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu1s_BFu7s { double v1; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu1s_BFu8c { double v1; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu1s_BFu8i { double v1; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu1s_BFu8ll { double v1; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu1s_BFu8s { double v1; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu1s_BFu9i { double v1; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu1s_BFu9ll { double v1; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu1s_BFu9s { double v1; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu1s_C { double v1; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aD_BFu1s_D { double v1; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aD_BFu1s_F { double v1; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aD_BFu1s_I { double v1; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aD_BFu1s_Ip { double v1; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aD_BFu1s_L { double v1; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aD_BFu1s_S { double v1; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aD_BFu1s_Uc { double v1; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aD_BFu1s_Ui { double v1; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aD_BFu1s_Ul { double v1; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu1s_Us { double v1; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aD_BFu1s_Vp { double v1; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aD_BFu31i { double v1; unsigned int v2:31; };
struct __attribute__((packed)) aD_BFu31i_BFu15i { double v1; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu31i_BFu15ll { double v1; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu31i_BFu15s { double v1; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu31i_BFu16i { double v1; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu31i_BFu16ll { double v1; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu31i_BFu16s { double v1; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu31i_BFu17i { double v1; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu31i_BFu17ll { double v1; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu31i_BFu1c { double v1; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu31i_BFu1i { double v1; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu31i_BFu1ll { double v1; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu31i_BFu1s { double v1; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu31i_BFu31i { double v1; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu31i_BFu31ll { double v1; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu31i_BFu32i { double v1; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu31i_BFu32ll { double v1; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu31i_BFu33 { double v1; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu31i_BFu7c { double v1; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu31i_BFu7i { double v1; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu31i_BFu7ll { double v1; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu31i_BFu7s { double v1; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu31i_BFu8c { double v1; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu31i_BFu8i { double v1; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu31i_BFu8ll { double v1; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu31i_BFu8s { double v1; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu31i_BFu9i { double v1; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu31i_BFu9ll { double v1; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu31i_BFu9s { double v1; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu31i_C { double v1; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aD_BFu31i_D { double v1; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aD_BFu31i_F { double v1; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aD_BFu31i_I { double v1; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aD_BFu31i_Ip { double v1; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aD_BFu31i_L { double v1; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aD_BFu31i_S { double v1; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aD_BFu31i_Uc { double v1; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aD_BFu31i_Ui { double v1; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aD_BFu31i_Ul { double v1; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu31i_Us { double v1; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aD_BFu31i_Vp { double v1; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aD_BFu31ll { double v1; unsigned long long v2:31; };
struct __attribute__((packed)) aD_BFu31ll_BFu15i { double v1; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu31ll_BFu15ll { double v1; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu31ll_BFu15s { double v1; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu31ll_BFu16i { double v1; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu31ll_BFu16ll { double v1; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu31ll_BFu16s { double v1; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu31ll_BFu17i { double v1; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu31ll_BFu17ll { double v1; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu31ll_BFu1c { double v1; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu31ll_BFu1i { double v1; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu31ll_BFu1ll { double v1; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu31ll_BFu1s { double v1; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu31ll_BFu31i { double v1; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu31ll_BFu31ll { double v1; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu31ll_BFu32i { double v1; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu31ll_BFu32ll { double v1; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu31ll_BFu33 { double v1; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu31ll_BFu7c { double v1; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu31ll_BFu7i { double v1; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu31ll_BFu7ll { double v1; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu31ll_BFu7s { double v1; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu31ll_BFu8c { double v1; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu31ll_BFu8i { double v1; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu31ll_BFu8ll { double v1; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu31ll_BFu8s { double v1; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu31ll_BFu9i { double v1; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu31ll_BFu9ll { double v1; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu31ll_BFu9s { double v1; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu31ll_C { double v1; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aD_BFu31ll_D { double v1; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aD_BFu31ll_F { double v1; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aD_BFu31ll_I { double v1; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aD_BFu31ll_Ip { double v1; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aD_BFu31ll_L { double v1; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aD_BFu31ll_S { double v1; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aD_BFu31ll_Uc { double v1; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aD_BFu31ll_Ui { double v1; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aD_BFu31ll_Ul { double v1; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu31ll_Us { double v1; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aD_BFu31ll_Vp { double v1; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aD_BFu32i { double v1; unsigned int v2:32; };
struct __attribute__((packed)) aD_BFu32i_BFu15i { double v1; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu32i_BFu15ll { double v1; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu32i_BFu15s { double v1; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu32i_BFu16i { double v1; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu32i_BFu16ll { double v1; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu32i_BFu16s { double v1; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu32i_BFu17i { double v1; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu32i_BFu17ll { double v1; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu32i_BFu1c { double v1; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu32i_BFu1i { double v1; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu32i_BFu1ll { double v1; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu32i_BFu1s { double v1; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu32i_BFu31i { double v1; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu32i_BFu31ll { double v1; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu32i_BFu32i { double v1; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu32i_BFu32ll { double v1; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu32i_BFu33 { double v1; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu32i_BFu7c { double v1; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu32i_BFu7i { double v1; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu32i_BFu7ll { double v1; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu32i_BFu7s { double v1; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu32i_BFu8c { double v1; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu32i_BFu8i { double v1; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu32i_BFu8ll { double v1; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu32i_BFu8s { double v1; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu32i_BFu9i { double v1; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu32i_BFu9ll { double v1; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu32i_BFu9s { double v1; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu32i_C { double v1; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aD_BFu32i_D { double v1; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aD_BFu32i_F { double v1; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aD_BFu32i_I { double v1; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aD_BFu32i_Ip { double v1; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aD_BFu32i_L { double v1; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aD_BFu32i_S { double v1; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aD_BFu32i_Uc { double v1; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aD_BFu32i_Ui { double v1; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aD_BFu32i_Ul { double v1; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu32i_Us { double v1; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aD_BFu32i_Vp { double v1; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aD_BFu32ll { double v1; unsigned long long v2:32; };
struct __attribute__((packed)) aD_BFu32ll_BFu15i { double v1; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu32ll_BFu15ll { double v1; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu32ll_BFu15s { double v1; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu32ll_BFu16i { double v1; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu32ll_BFu16ll { double v1; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu32ll_BFu16s { double v1; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu32ll_BFu17i { double v1; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu32ll_BFu17ll { double v1; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu32ll_BFu1c { double v1; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu32ll_BFu1i { double v1; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu32ll_BFu1ll { double v1; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu32ll_BFu1s { double v1; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu32ll_BFu31i { double v1; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu32ll_BFu31ll { double v1; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu32ll_BFu32i { double v1; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu32ll_BFu32ll { double v1; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu32ll_BFu33 { double v1; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu32ll_BFu7c { double v1; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu32ll_BFu7i { double v1; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu32ll_BFu7ll { double v1; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu32ll_BFu7s { double v1; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu32ll_BFu8c { double v1; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu32ll_BFu8i { double v1; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu32ll_BFu8ll { double v1; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu32ll_BFu8s { double v1; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu32ll_BFu9i { double v1; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu32ll_BFu9ll { double v1; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu32ll_BFu9s { double v1; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu32ll_C { double v1; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aD_BFu32ll_D { double v1; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aD_BFu32ll_F { double v1; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aD_BFu32ll_I { double v1; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aD_BFu32ll_Ip { double v1; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aD_BFu32ll_L { double v1; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aD_BFu32ll_S { double v1; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aD_BFu32ll_Uc { double v1; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aD_BFu32ll_Ui { double v1; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aD_BFu32ll_Ul { double v1; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu32ll_Us { double v1; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aD_BFu32ll_Vp { double v1; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aD_BFu33 { double v1; unsigned long long v2:33; };
struct __attribute__((packed)) aD_BFu33_BFu15i { double v1; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu33_BFu15ll { double v1; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu33_BFu15s { double v1; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu33_BFu16i { double v1; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu33_BFu16ll { double v1; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu33_BFu16s { double v1; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu33_BFu17i { double v1; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu33_BFu17ll { double v1; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu33_BFu1c { double v1; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu33_BFu1i { double v1; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu33_BFu1ll { double v1; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu33_BFu1s { double v1; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu33_BFu31i { double v1; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu33_BFu31ll { double v1; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu33_BFu32i { double v1; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu33_BFu32ll { double v1; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu33_BFu33 { double v1; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu33_BFu7c { double v1; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu33_BFu7i { double v1; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu33_BFu7ll { double v1; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu33_BFu7s { double v1; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu33_BFu8c { double v1; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu33_BFu8i { double v1; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu33_BFu8ll { double v1; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu33_BFu8s { double v1; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu33_BFu9i { double v1; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu33_BFu9ll { double v1; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu33_BFu9s { double v1; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu33_C { double v1; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aD_BFu33_D { double v1; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aD_BFu33_F { double v1; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aD_BFu33_I { double v1; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aD_BFu33_Ip { double v1; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aD_BFu33_L { double v1; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aD_BFu33_S { double v1; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aD_BFu33_Uc { double v1; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aD_BFu33_Ui { double v1; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aD_BFu33_Ul { double v1; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu33_Us { double v1; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aD_BFu33_Vp { double v1; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aD_BFu7c { double v1; unsigned char v2:7; };
struct __attribute__((packed)) aD_BFu7c_BFu15i { double v1; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu7c_BFu15ll { double v1; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu7c_BFu15s { double v1; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu7c_BFu16i { double v1; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu7c_BFu16ll { double v1; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu7c_BFu16s { double v1; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu7c_BFu17i { double v1; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu7c_BFu17ll { double v1; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu7c_BFu1c { double v1; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu7c_BFu1i { double v1; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu7c_BFu1ll { double v1; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu7c_BFu1s { double v1; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu7c_BFu31i { double v1; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu7c_BFu31ll { double v1; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu7c_BFu32i { double v1; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu7c_BFu32ll { double v1; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu7c_BFu33 { double v1; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu7c_BFu7c { double v1; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu7c_BFu7i { double v1; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu7c_BFu7ll { double v1; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu7c_BFu7s { double v1; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu7c_BFu8c { double v1; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu7c_BFu8i { double v1; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu7c_BFu8ll { double v1; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu7c_BFu8s { double v1; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu7c_BFu9i { double v1; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu7c_BFu9ll { double v1; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu7c_BFu9s { double v1; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu7c_C { double v1; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aD_BFu7c_D { double v1; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aD_BFu7c_F { double v1; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aD_BFu7c_I { double v1; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aD_BFu7c_Ip { double v1; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aD_BFu7c_L { double v1; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aD_BFu7c_S { double v1; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aD_BFu7c_Uc { double v1; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aD_BFu7c_Ui { double v1; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aD_BFu7c_Ul { double v1; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu7c_Us { double v1; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aD_BFu7c_Vp { double v1; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aD_BFu7i { double v1; unsigned int v2:7; };
struct __attribute__((packed)) aD_BFu7i_BFu15i { double v1; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu7i_BFu15ll { double v1; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu7i_BFu15s { double v1; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu7i_BFu16i { double v1; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu7i_BFu16ll { double v1; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu7i_BFu16s { double v1; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu7i_BFu17i { double v1; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu7i_BFu17ll { double v1; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu7i_BFu1c { double v1; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu7i_BFu1i { double v1; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu7i_BFu1ll { double v1; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu7i_BFu1s { double v1; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu7i_BFu31i { double v1; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu7i_BFu31ll { double v1; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu7i_BFu32i { double v1; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu7i_BFu32ll { double v1; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu7i_BFu33 { double v1; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu7i_BFu7c { double v1; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu7i_BFu7i { double v1; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu7i_BFu7ll { double v1; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu7i_BFu7s { double v1; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu7i_BFu8c { double v1; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu7i_BFu8i { double v1; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu7i_BFu8ll { double v1; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu7i_BFu8s { double v1; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu7i_BFu9i { double v1; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu7i_BFu9ll { double v1; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu7i_BFu9s { double v1; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu7i_C { double v1; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aD_BFu7i_D { double v1; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aD_BFu7i_F { double v1; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aD_BFu7i_I { double v1; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aD_BFu7i_Ip { double v1; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aD_BFu7i_L { double v1; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aD_BFu7i_S { double v1; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aD_BFu7i_Uc { double v1; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aD_BFu7i_Ui { double v1; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aD_BFu7i_Ul { double v1; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu7i_Us { double v1; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aD_BFu7i_Vp { double v1; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aD_BFu7ll { double v1; unsigned long long v2:7; };
struct __attribute__((packed)) aD_BFu7ll_BFu15i { double v1; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu7ll_BFu15ll { double v1; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu7ll_BFu15s { double v1; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu7ll_BFu16i { double v1; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu7ll_BFu16ll { double v1; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu7ll_BFu16s { double v1; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu7ll_BFu17i { double v1; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu7ll_BFu17ll { double v1; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu7ll_BFu1c { double v1; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu7ll_BFu1i { double v1; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu7ll_BFu1ll { double v1; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu7ll_BFu1s { double v1; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu7ll_BFu31i { double v1; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu7ll_BFu31ll { double v1; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu7ll_BFu32i { double v1; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu7ll_BFu32ll { double v1; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu7ll_BFu33 { double v1; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu7ll_BFu7c { double v1; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu7ll_BFu7i { double v1; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu7ll_BFu7ll { double v1; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu7ll_BFu7s { double v1; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu7ll_BFu8c { double v1; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu7ll_BFu8i { double v1; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu7ll_BFu8ll { double v1; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu7ll_BFu8s { double v1; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu7ll_BFu9i { double v1; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu7ll_BFu9ll { double v1; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu7ll_BFu9s { double v1; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu7ll_C { double v1; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aD_BFu7ll_D { double v1; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aD_BFu7ll_F { double v1; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aD_BFu7ll_I { double v1; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aD_BFu7ll_Ip { double v1; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aD_BFu7ll_L { double v1; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aD_BFu7ll_S { double v1; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aD_BFu7ll_Uc { double v1; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aD_BFu7ll_Ui { double v1; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aD_BFu7ll_Ul { double v1; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu7ll_Us { double v1; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aD_BFu7ll_Vp { double v1; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aD_BFu7s { double v1; unsigned short v2:7; };
struct __attribute__((packed)) aD_BFu7s_BFu15i { double v1; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu7s_BFu15ll { double v1; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu7s_BFu15s { double v1; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu7s_BFu16i { double v1; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu7s_BFu16ll { double v1; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu7s_BFu16s { double v1; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu7s_BFu17i { double v1; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu7s_BFu17ll { double v1; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu7s_BFu1c { double v1; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu7s_BFu1i { double v1; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu7s_BFu1ll { double v1; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu7s_BFu1s { double v1; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu7s_BFu31i { double v1; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu7s_BFu31ll { double v1; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu7s_BFu32i { double v1; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu7s_BFu32ll { double v1; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu7s_BFu33 { double v1; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu7s_BFu7c { double v1; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu7s_BFu7i { double v1; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu7s_BFu7ll { double v1; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu7s_BFu7s { double v1; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu7s_BFu8c { double v1; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu7s_BFu8i { double v1; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu7s_BFu8ll { double v1; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu7s_BFu8s { double v1; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu7s_BFu9i { double v1; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu7s_BFu9ll { double v1; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu7s_BFu9s { double v1; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu7s_C { double v1; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aD_BFu7s_D { double v1; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aD_BFu7s_F { double v1; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aD_BFu7s_I { double v1; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aD_BFu7s_Ip { double v1; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aD_BFu7s_L { double v1; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aD_BFu7s_S { double v1; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aD_BFu7s_Uc { double v1; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aD_BFu7s_Ui { double v1; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aD_BFu7s_Ul { double v1; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu7s_Us { double v1; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aD_BFu7s_Vp { double v1; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aD_BFu8c { double v1; unsigned char v2:8; };
struct __attribute__((packed)) aD_BFu8c_BFu15i { double v1; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu8c_BFu15ll { double v1; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu8c_BFu15s { double v1; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu8c_BFu16i { double v1; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu8c_BFu16ll { double v1; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu8c_BFu16s { double v1; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu8c_BFu17i { double v1; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu8c_BFu17ll { double v1; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu8c_BFu1c { double v1; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu8c_BFu1i { double v1; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu8c_BFu1ll { double v1; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu8c_BFu1s { double v1; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu8c_BFu31i { double v1; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu8c_BFu31ll { double v1; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu8c_BFu32i { double v1; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu8c_BFu32ll { double v1; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu8c_BFu33 { double v1; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu8c_BFu7c { double v1; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu8c_BFu7i { double v1; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu8c_BFu7ll { double v1; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu8c_BFu7s { double v1; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu8c_BFu8c { double v1; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu8c_BFu8i { double v1; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu8c_BFu8ll { double v1; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu8c_BFu8s { double v1; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu8c_BFu9i { double v1; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu8c_BFu9ll { double v1; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu8c_BFu9s { double v1; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu8c_C { double v1; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aD_BFu8c_D { double v1; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aD_BFu8c_F { double v1; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aD_BFu8c_I { double v1; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aD_BFu8c_Ip { double v1; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aD_BFu8c_L { double v1; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aD_BFu8c_S { double v1; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aD_BFu8c_Uc { double v1; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aD_BFu8c_Ui { double v1; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aD_BFu8c_Ul { double v1; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu8c_Us { double v1; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aD_BFu8c_Vp { double v1; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aD_BFu8i { double v1; unsigned int v2:8; };
struct __attribute__((packed)) aD_BFu8i_BFu15i { double v1; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu8i_BFu15ll { double v1; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu8i_BFu15s { double v1; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu8i_BFu16i { double v1; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu8i_BFu16ll { double v1; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu8i_BFu16s { double v1; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu8i_BFu17i { double v1; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu8i_BFu17ll { double v1; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu8i_BFu1c { double v1; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu8i_BFu1i { double v1; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu8i_BFu1ll { double v1; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu8i_BFu1s { double v1; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu8i_BFu31i { double v1; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu8i_BFu31ll { double v1; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu8i_BFu32i { double v1; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu8i_BFu32ll { double v1; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu8i_BFu33 { double v1; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu8i_BFu7c { double v1; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu8i_BFu7i { double v1; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu8i_BFu7ll { double v1; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu8i_BFu7s { double v1; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu8i_BFu8c { double v1; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu8i_BFu8i { double v1; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu8i_BFu8ll { double v1; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu8i_BFu8s { double v1; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu8i_BFu9i { double v1; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu8i_BFu9ll { double v1; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu8i_BFu9s { double v1; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu8i_C { double v1; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aD_BFu8i_D { double v1; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aD_BFu8i_F { double v1; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aD_BFu8i_I { double v1; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aD_BFu8i_Ip { double v1; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aD_BFu8i_L { double v1; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aD_BFu8i_S { double v1; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aD_BFu8i_Uc { double v1; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aD_BFu8i_Ui { double v1; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aD_BFu8i_Ul { double v1; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu8i_Us { double v1; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aD_BFu8i_Vp { double v1; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aD_BFu8ll { double v1; unsigned long long v2:8; };
struct __attribute__((packed)) aD_BFu8ll_BFu15i { double v1; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu8ll_BFu15ll { double v1; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu8ll_BFu15s { double v1; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu8ll_BFu16i { double v1; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu8ll_BFu16ll { double v1; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu8ll_BFu16s { double v1; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu8ll_BFu17i { double v1; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu8ll_BFu17ll { double v1; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu8ll_BFu1c { double v1; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu8ll_BFu1i { double v1; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu8ll_BFu1ll { double v1; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu8ll_BFu1s { double v1; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu8ll_BFu31i { double v1; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu8ll_BFu31ll { double v1; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu8ll_BFu32i { double v1; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu8ll_BFu32ll { double v1; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu8ll_BFu33 { double v1; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu8ll_BFu7c { double v1; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu8ll_BFu7i { double v1; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu8ll_BFu7ll { double v1; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu8ll_BFu7s { double v1; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu8ll_BFu8c { double v1; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu8ll_BFu8i { double v1; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu8ll_BFu8ll { double v1; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu8ll_BFu8s { double v1; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu8ll_BFu9i { double v1; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu8ll_BFu9ll { double v1; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu8ll_BFu9s { double v1; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu8ll_C { double v1; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aD_BFu8ll_D { double v1; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aD_BFu8ll_F { double v1; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aD_BFu8ll_I { double v1; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aD_BFu8ll_Ip { double v1; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aD_BFu8ll_L { double v1; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aD_BFu8ll_S { double v1; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aD_BFu8ll_Uc { double v1; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aD_BFu8ll_Ui { double v1; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aD_BFu8ll_Ul { double v1; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu8ll_Us { double v1; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aD_BFu8ll_Vp { double v1; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aD_BFu8s { double v1; unsigned short v2:8; };
struct __attribute__((packed)) aD_BFu8s_BFu15i { double v1; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu8s_BFu15ll { double v1; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu8s_BFu15s { double v1; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu8s_BFu16i { double v1; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu8s_BFu16ll { double v1; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu8s_BFu16s { double v1; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu8s_BFu17i { double v1; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu8s_BFu17ll { double v1; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu8s_BFu1c { double v1; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu8s_BFu1i { double v1; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu8s_BFu1ll { double v1; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu8s_BFu1s { double v1; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu8s_BFu31i { double v1; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu8s_BFu31ll { double v1; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu8s_BFu32i { double v1; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu8s_BFu32ll { double v1; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu8s_BFu33 { double v1; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu8s_BFu7c { double v1; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu8s_BFu7i { double v1; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu8s_BFu7ll { double v1; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu8s_BFu7s { double v1; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu8s_BFu8c { double v1; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu8s_BFu8i { double v1; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu8s_BFu8ll { double v1; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu8s_BFu8s { double v1; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu8s_BFu9i { double v1; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu8s_BFu9ll { double v1; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu8s_BFu9s { double v1; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu8s_C { double v1; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aD_BFu8s_D { double v1; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aD_BFu8s_F { double v1; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aD_BFu8s_I { double v1; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aD_BFu8s_Ip { double v1; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aD_BFu8s_L { double v1; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aD_BFu8s_S { double v1; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aD_BFu8s_Uc { double v1; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aD_BFu8s_Ui { double v1; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aD_BFu8s_Ul { double v1; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu8s_Us { double v1; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aD_BFu8s_Vp { double v1; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aD_BFu9i { double v1; unsigned int v2:9; };
struct __attribute__((packed)) aD_BFu9i_BFu15i { double v1; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu9i_BFu15ll { double v1; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu9i_BFu15s { double v1; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu9i_BFu16i { double v1; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu9i_BFu16ll { double v1; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu9i_BFu16s { double v1; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu9i_BFu17i { double v1; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu9i_BFu17ll { double v1; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu9i_BFu1c { double v1; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu9i_BFu1i { double v1; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu9i_BFu1ll { double v1; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu9i_BFu1s { double v1; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu9i_BFu31i { double v1; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu9i_BFu31ll { double v1; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu9i_BFu32i { double v1; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu9i_BFu32ll { double v1; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu9i_BFu33 { double v1; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu9i_BFu7c { double v1; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu9i_BFu7i { double v1; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu9i_BFu7ll { double v1; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu9i_BFu7s { double v1; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu9i_BFu8c { double v1; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu9i_BFu8i { double v1; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu9i_BFu8ll { double v1; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu9i_BFu8s { double v1; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu9i_BFu9i { double v1; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu9i_BFu9ll { double v1; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu9i_BFu9s { double v1; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu9i_C { double v1; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aD_BFu9i_D { double v1; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aD_BFu9i_F { double v1; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aD_BFu9i_I { double v1; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aD_BFu9i_Ip { double v1; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aD_BFu9i_L { double v1; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aD_BFu9i_S { double v1; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aD_BFu9i_Uc { double v1; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aD_BFu9i_Ui { double v1; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aD_BFu9i_Ul { double v1; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu9i_Us { double v1; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aD_BFu9i_Vp { double v1; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aD_BFu9ll { double v1; unsigned long long v2:9; };
struct __attribute__((packed)) aD_BFu9ll_BFu15i { double v1; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu9ll_BFu15ll { double v1; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu9ll_BFu15s { double v1; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu9ll_BFu16i { double v1; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu9ll_BFu16ll { double v1; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu9ll_BFu16s { double v1; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu9ll_BFu17i { double v1; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu9ll_BFu17ll { double v1; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu9ll_BFu1c { double v1; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu9ll_BFu1i { double v1; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu9ll_BFu1ll { double v1; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu9ll_BFu1s { double v1; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu9ll_BFu31i { double v1; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu9ll_BFu31ll { double v1; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu9ll_BFu32i { double v1; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu9ll_BFu32ll { double v1; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu9ll_BFu33 { double v1; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu9ll_BFu7c { double v1; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu9ll_BFu7i { double v1; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu9ll_BFu7ll { double v1; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu9ll_BFu7s { double v1; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu9ll_BFu8c { double v1; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu9ll_BFu8i { double v1; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu9ll_BFu8ll { double v1; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu9ll_BFu8s { double v1; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu9ll_BFu9i { double v1; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu9ll_BFu9ll { double v1; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu9ll_BFu9s { double v1; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu9ll_C { double v1; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aD_BFu9ll_D { double v1; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aD_BFu9ll_F { double v1; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aD_BFu9ll_I { double v1; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aD_BFu9ll_Ip { double v1; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aD_BFu9ll_L { double v1; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aD_BFu9ll_S { double v1; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aD_BFu9ll_Uc { double v1; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aD_BFu9ll_Ui { double v1; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aD_BFu9ll_Ul { double v1; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu9ll_Us { double v1; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aD_BFu9ll_Vp { double v1; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aD_BFu9s { double v1; unsigned short v2:9; };
struct __attribute__((packed)) aD_BFu9s_BFu15i { double v1; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aD_BFu9s_BFu15ll { double v1; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aD_BFu9s_BFu15s { double v1; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aD_BFu9s_BFu16i { double v1; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aD_BFu9s_BFu16ll { double v1; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aD_BFu9s_BFu16s { double v1; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aD_BFu9s_BFu17i { double v1; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aD_BFu9s_BFu17ll { double v1; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aD_BFu9s_BFu1c { double v1; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aD_BFu9s_BFu1i { double v1; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aD_BFu9s_BFu1ll { double v1; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aD_BFu9s_BFu1s { double v1; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aD_BFu9s_BFu31i { double v1; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aD_BFu9s_BFu31ll { double v1; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aD_BFu9s_BFu32i { double v1; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aD_BFu9s_BFu32ll { double v1; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aD_BFu9s_BFu33 { double v1; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aD_BFu9s_BFu7c { double v1; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aD_BFu9s_BFu7i { double v1; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aD_BFu9s_BFu7ll { double v1; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aD_BFu9s_BFu7s { double v1; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aD_BFu9s_BFu8c { double v1; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aD_BFu9s_BFu8i { double v1; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aD_BFu9s_BFu8ll { double v1; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aD_BFu9s_BFu8s { double v1; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aD_BFu9s_BFu9i { double v1; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aD_BFu9s_BFu9ll { double v1; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aD_BFu9s_BFu9s { double v1; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aD_BFu9s_C { double v1; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aD_BFu9s_D { double v1; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aD_BFu9s_F { double v1; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aD_BFu9s_I { double v1; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aD_BFu9s_Ip { double v1; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aD_BFu9s_L { double v1; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aD_BFu9s_S { double v1; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aD_BFu9s_Uc { double v1; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aD_BFu9s_Ui { double v1; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aD_BFu9s_Ul { double v1; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aD_BFu9s_Us { double v1; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aD_BFu9s_Vp { double v1; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aD_C { double v1; char v2; };
struct __attribute__((packed)) aD_C_BFu15i { double v1; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_C_BFu15ll { double v1; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_C_BFu15s { double v1; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_C_BFu16i { double v1; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_C_BFu16ll { double v1; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_C_BFu16s { double v1; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_C_BFu17i { double v1; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_C_BFu17ll { double v1; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_C_BFu1c { double v1; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_C_BFu1i { double v1; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_C_BFu1ll { double v1; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_C_BFu1s { double v1; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_C_BFu31i { double v1; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_C_BFu31ll { double v1; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_C_BFu32i { double v1; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_C_BFu32ll { double v1; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_C_BFu33 { double v1; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_C_BFu7c { double v1; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_C_BFu7i { double v1; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_C_BFu7ll { double v1; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_C_BFu7s { double v1; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_C_BFu8c { double v1; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_C_BFu8i { double v1; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_C_BFu8ll { double v1; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_C_BFu8s { double v1; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_C_BFu9i { double v1; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_C_BFu9ll { double v1; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_C_BFu9s { double v1; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_C_C { double v1; char v2; char v3; };
struct __attribute__((packed)) aD_C_D { double v1; char v2; double v3; };
struct __attribute__((packed)) aD_C_F { double v1; char v2; float v3; };
struct __attribute__((packed)) aD_C_I { double v1; char v2; int v3; };
struct __attribute__((packed)) aD_C_Ip { double v1; char v2; int * v3; };
struct __attribute__((packed)) aD_C_L { double v1; char v2; long long v3; };
struct __attribute__((packed)) aD_C_S { double v1; char v2; short v3; };
struct __attribute__((packed)) aD_C_Uc { double v1; char v2; unsigned char v3; };
struct __attribute__((packed)) aD_C_Ui { double v1; char v2; unsigned int v3; };
struct __attribute__((packed)) aD_C_Ul { double v1; char v2; unsigned long long v3; };
struct __attribute__((packed)) aD_C_Us { double v1; char v2; unsigned short v3; };
struct __attribute__((packed)) aD_C_Vp { double v1; char v2; void * v3; };
struct __attribute__((packed)) aD_D { double v1; double v2; };
struct __attribute__((packed)) aD_D_BFu15i { double v1; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_D_BFu15ll { double v1; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_D_BFu15s { double v1; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_D_BFu16i { double v1; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_D_BFu16ll { double v1; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_D_BFu16s { double v1; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_D_BFu17i { double v1; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_D_BFu17ll { double v1; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_D_BFu1c { double v1; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_D_BFu1i { double v1; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_D_BFu1ll { double v1; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_D_BFu1s { double v1; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_D_BFu31i { double v1; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_D_BFu31ll { double v1; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_D_BFu32i { double v1; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_D_BFu32ll { double v1; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_D_BFu33 { double v1; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_D_BFu7c { double v1; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_D_BFu7i { double v1; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_D_BFu7ll { double v1; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_D_BFu7s { double v1; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_D_BFu8c { double v1; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_D_BFu8i { double v1; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_D_BFu8ll { double v1; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_D_BFu8s { double v1; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_D_BFu9i { double v1; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_D_BFu9ll { double v1; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_D_BFu9s { double v1; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_D_C { double v1; double v2; char v3; };
struct __attribute__((packed)) aD_D_D { double v1; double v2; double v3; };
struct __attribute__((packed)) aD_D_F { double v1; double v2; float v3; };
struct __attribute__((packed)) aD_D_I { double v1; double v2; int v3; };
struct __attribute__((packed)) aD_D_Ip { double v1; double v2; int * v3; };
struct __attribute__((packed)) aD_D_L { double v1; double v2; long long v3; };
struct __attribute__((packed)) aD_D_S { double v1; double v2; short v3; };
struct __attribute__((packed)) aD_D_Uc { double v1; double v2; unsigned char v3; };
struct __attribute__((packed)) aD_D_Ui { double v1; double v2; unsigned int v3; };
struct __attribute__((packed)) aD_D_Ul { double v1; double v2; unsigned long long v3; };
struct __attribute__((packed)) aD_D_Us { double v1; double v2; unsigned short v3; };
struct __attribute__((packed)) aD_D_Vp { double v1; double v2; void * v3; };
struct __attribute__((packed)) aD_F { double v1; float v2; };
struct __attribute__((packed)) aD_F_BFu15i { double v1; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_F_BFu15ll { double v1; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_F_BFu15s { double v1; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_F_BFu16i { double v1; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_F_BFu16ll { double v1; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_F_BFu16s { double v1; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_F_BFu17i { double v1; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_F_BFu17ll { double v1; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_F_BFu1c { double v1; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_F_BFu1i { double v1; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_F_BFu1ll { double v1; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_F_BFu1s { double v1; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_F_BFu31i { double v1; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_F_BFu31ll { double v1; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_F_BFu32i { double v1; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_F_BFu32ll { double v1; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_F_BFu33 { double v1; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_F_BFu7c { double v1; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_F_BFu7i { double v1; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_F_BFu7ll { double v1; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_F_BFu7s { double v1; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_F_BFu8c { double v1; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_F_BFu8i { double v1; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_F_BFu8ll { double v1; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_F_BFu8s { double v1; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_F_BFu9i { double v1; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_F_BFu9ll { double v1; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_F_BFu9s { double v1; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_F_C { double v1; float v2; char v3; };
struct __attribute__((packed)) aD_F_D { double v1; float v2; double v3; };
struct __attribute__((packed)) aD_F_F { double v1; float v2; float v3; };
struct __attribute__((packed)) aD_F_I { double v1; float v2; int v3; };
struct __attribute__((packed)) aD_F_Ip { double v1; float v2; int * v3; };
struct __attribute__((packed)) aD_F_L { double v1; float v2; long long v3; };
struct __attribute__((packed)) aD_F_S { double v1; float v2; short v3; };
struct __attribute__((packed)) aD_F_Uc { double v1; float v2; unsigned char v3; };
struct __attribute__((packed)) aD_F_Ui { double v1; float v2; unsigned int v3; };
struct __attribute__((packed)) aD_F_Ul { double v1; float v2; unsigned long long v3; };
struct __attribute__((packed)) aD_F_Us { double v1; float v2; unsigned short v3; };
struct __attribute__((packed)) aD_F_Vp { double v1; float v2; void * v3; };
struct __attribute__((packed)) aD_I { double v1; int v2; };
struct __attribute__((packed)) aD_I_BFu15i { double v1; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_I_BFu15ll { double v1; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_I_BFu15s { double v1; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_I_BFu16i { double v1; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_I_BFu16ll { double v1; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_I_BFu16s { double v1; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_I_BFu17i { double v1; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_I_BFu17ll { double v1; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_I_BFu1c { double v1; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_I_BFu1i { double v1; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_I_BFu1ll { double v1; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_I_BFu1s { double v1; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_I_BFu31i { double v1; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_I_BFu31ll { double v1; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_I_BFu32i { double v1; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_I_BFu32ll { double v1; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_I_BFu33 { double v1; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_I_BFu7c { double v1; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_I_BFu7i { double v1; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_I_BFu7ll { double v1; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_I_BFu7s { double v1; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_I_BFu8c { double v1; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_I_BFu8i { double v1; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_I_BFu8ll { double v1; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_I_BFu8s { double v1; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_I_BFu9i { double v1; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_I_BFu9ll { double v1; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_I_BFu9s { double v1; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_I_C { double v1; int v2; char v3; };
struct __attribute__((packed)) aD_I_D { double v1; int v2; double v3; };
struct __attribute__((packed)) aD_I_F { double v1; int v2; float v3; };
struct __attribute__((packed)) aD_I_I { double v1; int v2; int v3; };
struct __attribute__((packed)) aD_I_Ip { double v1; int v2; int * v3; };
struct __attribute__((packed)) aD_I_L { double v1; int v2; long long v3; };
struct __attribute__((packed)) aD_I_S { double v1; int v2; short v3; };
struct __attribute__((packed)) aD_I_Uc { double v1; int v2; unsigned char v3; };
struct __attribute__((packed)) aD_I_Ui { double v1; int v2; unsigned int v3; };
struct __attribute__((packed)) aD_I_Ul { double v1; int v2; unsigned long long v3; };
struct __attribute__((packed)) aD_I_Us { double v1; int v2; unsigned short v3; };
struct __attribute__((packed)) aD_I_Vp { double v1; int v2; void * v3; };
struct __attribute__((packed)) aD_Ip { double v1; int * v2; };
struct __attribute__((packed)) aD_Ip_BFu15i { double v1; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_Ip_BFu15ll { double v1; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_Ip_BFu15s { double v1; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_Ip_BFu16i { double v1; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_Ip_BFu16ll { double v1; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_Ip_BFu16s { double v1; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_Ip_BFu17i { double v1; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_Ip_BFu17ll { double v1; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_Ip_BFu1c { double v1; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_Ip_BFu1i { double v1; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_Ip_BFu1ll { double v1; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_Ip_BFu1s { double v1; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_Ip_BFu31i { double v1; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_Ip_BFu31ll { double v1; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_Ip_BFu32i { double v1; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_Ip_BFu32ll { double v1; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_Ip_BFu33 { double v1; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_Ip_BFu7c { double v1; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_Ip_BFu7i { double v1; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_Ip_BFu7ll { double v1; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_Ip_BFu7s { double v1; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_Ip_BFu8c { double v1; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_Ip_BFu8i { double v1; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_Ip_BFu8ll { double v1; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_Ip_BFu8s { double v1; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_Ip_BFu9i { double v1; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_Ip_BFu9ll { double v1; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_Ip_BFu9s { double v1; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_Ip_C { double v1; int * v2; char v3; };
struct __attribute__((packed)) aD_Ip_D { double v1; int * v2; double v3; };
struct __attribute__((packed)) aD_Ip_F { double v1; int * v2; float v3; };
struct __attribute__((packed)) aD_Ip_I { double v1; int * v2; int v3; };
struct __attribute__((packed)) aD_Ip_Ip { double v1; int * v2; int * v3; };
struct __attribute__((packed)) aD_Ip_L { double v1; int * v2; long long v3; };
struct __attribute__((packed)) aD_Ip_S { double v1; int * v2; short v3; };
struct __attribute__((packed)) aD_Ip_Uc { double v1; int * v2; unsigned char v3; };
struct __attribute__((packed)) aD_Ip_Ui { double v1; int * v2; unsigned int v3; };
struct __attribute__((packed)) aD_Ip_Ul { double v1; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aD_Ip_Us { double v1; int * v2; unsigned short v3; };
struct __attribute__((packed)) aD_Ip_Vp { double v1; int * v2; void * v3; };
struct __attribute__((packed)) aD_L { double v1; long long v2; };
struct __attribute__((packed)) aD_L_BFu15i { double v1; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_L_BFu15ll { double v1; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_L_BFu15s { double v1; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_L_BFu16i { double v1; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_L_BFu16ll { double v1; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_L_BFu16s { double v1; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_L_BFu17i { double v1; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_L_BFu17ll { double v1; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_L_BFu1c { double v1; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_L_BFu1i { double v1; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_L_BFu1ll { double v1; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_L_BFu1s { double v1; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_L_BFu31i { double v1; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_L_BFu31ll { double v1; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_L_BFu32i { double v1; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_L_BFu32ll { double v1; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_L_BFu33 { double v1; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_L_BFu7c { double v1; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_L_BFu7i { double v1; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_L_BFu7ll { double v1; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_L_BFu7s { double v1; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_L_BFu8c { double v1; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_L_BFu8i { double v1; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_L_BFu8ll { double v1; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_L_BFu8s { double v1; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_L_BFu9i { double v1; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_L_BFu9ll { double v1; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_L_BFu9s { double v1; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_L_C { double v1; long long v2; char v3; };
struct __attribute__((packed)) aD_L_D { double v1; long long v2; double v3; };
struct __attribute__((packed)) aD_L_F { double v1; long long v2; float v3; };
struct __attribute__((packed)) aD_L_I { double v1; long long v2; int v3; };
struct __attribute__((packed)) aD_L_Ip { double v1; long long v2; int * v3; };
struct __attribute__((packed)) aD_L_L { double v1; long long v2; long long v3; };
struct __attribute__((packed)) aD_L_S { double v1; long long v2; short v3; };
struct __attribute__((packed)) aD_L_Uc { double v1; long long v2; unsigned char v3; };
struct __attribute__((packed)) aD_L_Ui { double v1; long long v2; unsigned int v3; };
struct __attribute__((packed)) aD_L_Ul { double v1; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aD_L_Us { double v1; long long v2; unsigned short v3; };
struct __attribute__((packed)) aD_L_Vp { double v1; long long v2; void * v3; };
struct __attribute__((packed)) aD_S { double v1; short v2; };
struct __attribute__((packed)) aD_S_BFu15i { double v1; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_S_BFu15ll { double v1; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_S_BFu15s { double v1; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_S_BFu16i { double v1; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_S_BFu16ll { double v1; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_S_BFu16s { double v1; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_S_BFu17i { double v1; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_S_BFu17ll { double v1; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_S_BFu1c { double v1; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_S_BFu1i { double v1; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_S_BFu1ll { double v1; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_S_BFu1s { double v1; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_S_BFu31i { double v1; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_S_BFu31ll { double v1; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_S_BFu32i { double v1; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_S_BFu32ll { double v1; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_S_BFu33 { double v1; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_S_BFu7c { double v1; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_S_BFu7i { double v1; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_S_BFu7ll { double v1; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_S_BFu7s { double v1; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_S_BFu8c { double v1; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_S_BFu8i { double v1; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_S_BFu8ll { double v1; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_S_BFu8s { double v1; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_S_BFu9i { double v1; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_S_BFu9ll { double v1; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_S_BFu9s { double v1; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_S_C { double v1; short v2; char v3; };
struct __attribute__((packed)) aD_S_D { double v1; short v2; double v3; };
struct __attribute__((packed)) aD_S_F { double v1; short v2; float v3; };
struct __attribute__((packed)) aD_S_I { double v1; short v2; int v3; };
struct __attribute__((packed)) aD_S_Ip { double v1; short v2; int * v3; };
struct __attribute__((packed)) aD_S_L { double v1; short v2; long long v3; };
struct __attribute__((packed)) aD_S_S { double v1; short v2; short v3; };
struct __attribute__((packed)) aD_S_Uc { double v1; short v2; unsigned char v3; };
struct __attribute__((packed)) aD_S_Ui { double v1; short v2; unsigned int v3; };
struct __attribute__((packed)) aD_S_Ul { double v1; short v2; unsigned long long v3; };
struct __attribute__((packed)) aD_S_Us { double v1; short v2; unsigned short v3; };
struct __attribute__((packed)) aD_S_Vp { double v1; short v2; void * v3; };
struct __attribute__((packed)) aD_Uc { double v1; unsigned char v2; };
struct __attribute__((packed)) aD_Uc_BFu15i { double v1; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_Uc_BFu15ll { double v1; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_Uc_BFu15s { double v1; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_Uc_BFu16i { double v1; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_Uc_BFu16ll { double v1; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_Uc_BFu16s { double v1; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_Uc_BFu17i { double v1; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_Uc_BFu17ll { double v1; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_Uc_BFu1c { double v1; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_Uc_BFu1i { double v1; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_Uc_BFu1ll { double v1; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_Uc_BFu1s { double v1; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_Uc_BFu31i { double v1; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_Uc_BFu31ll { double v1; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_Uc_BFu32i { double v1; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_Uc_BFu32ll { double v1; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_Uc_BFu33 { double v1; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_Uc_BFu7c { double v1; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_Uc_BFu7i { double v1; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_Uc_BFu7ll { double v1; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_Uc_BFu7s { double v1; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_Uc_BFu8c { double v1; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_Uc_BFu8i { double v1; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_Uc_BFu8ll { double v1; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_Uc_BFu8s { double v1; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_Uc_BFu9i { double v1; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_Uc_BFu9ll { double v1; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_Uc_BFu9s { double v1; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_Uc_C { double v1; unsigned char v2; char v3; };
struct __attribute__((packed)) aD_Uc_D { double v1; unsigned char v2; double v3; };
struct __attribute__((packed)) aD_Uc_F { double v1; unsigned char v2; float v3; };
struct __attribute__((packed)) aD_Uc_I { double v1; unsigned char v2; int v3; };
struct __attribute__((packed)) aD_Uc_Ip { double v1; unsigned char v2; int * v3; };
struct __attribute__((packed)) aD_Uc_L { double v1; unsigned char v2; long long v3; };
struct __attribute__((packed)) aD_Uc_S { double v1; unsigned char v2; short v3; };
struct __attribute__((packed)) aD_Uc_Uc { double v1; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aD_Uc_Ui { double v1; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aD_Uc_Ul { double v1; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aD_Uc_Us { double v1; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aD_Uc_Vp { double v1; unsigned char v2; void * v3; };
struct __attribute__((packed)) aD_Ui { double v1; unsigned int v2; };
struct __attribute__((packed)) aD_Ui_BFu15i { double v1; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_Ui_BFu15ll { double v1; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_Ui_BFu15s { double v1; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_Ui_BFu16i { double v1; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_Ui_BFu16ll { double v1; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_Ui_BFu16s { double v1; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_Ui_BFu17i { double v1; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_Ui_BFu17ll { double v1; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_Ui_BFu1c { double v1; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_Ui_BFu1i { double v1; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_Ui_BFu1ll { double v1; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_Ui_BFu1s { double v1; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_Ui_BFu31i { double v1; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_Ui_BFu31ll { double v1; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_Ui_BFu32i { double v1; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_Ui_BFu32ll { double v1; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_Ui_BFu33 { double v1; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_Ui_BFu7c { double v1; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_Ui_BFu7i { double v1; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_Ui_BFu7ll { double v1; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_Ui_BFu7s { double v1; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_Ui_BFu8c { double v1; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_Ui_BFu8i { double v1; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_Ui_BFu8ll { double v1; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_Ui_BFu8s { double v1; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_Ui_BFu9i { double v1; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_Ui_BFu9ll { double v1; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_Ui_BFu9s { double v1; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_Ui_C { double v1; unsigned int v2; char v3; };
struct __attribute__((packed)) aD_Ui_D { double v1; unsigned int v2; double v3; };
struct __attribute__((packed)) aD_Ui_F { double v1; unsigned int v2; float v3; };
struct __attribute__((packed)) aD_Ui_I { double v1; unsigned int v2; int v3; };
struct __attribute__((packed)) aD_Ui_Ip { double v1; unsigned int v2; int * v3; };
struct __attribute__((packed)) aD_Ui_L { double v1; unsigned int v2; long long v3; };
struct __attribute__((packed)) aD_Ui_S { double v1; unsigned int v2; short v3; };
struct __attribute__((packed)) aD_Ui_Uc { double v1; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aD_Ui_Ui { double v1; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aD_Ui_Ul { double v1; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aD_Ui_Us { double v1; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aD_Ui_Vp { double v1; unsigned int v2; void * v3; };
struct __attribute__((packed)) aD_Ul { double v1; unsigned long long v2; };
struct __attribute__((packed)) aD_Ul_BFu15i { double v1; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_Ul_BFu15ll { double v1; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_Ul_BFu15s { double v1; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_Ul_BFu16i { double v1; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_Ul_BFu16ll { double v1; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_Ul_BFu16s { double v1; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_Ul_BFu17i { double v1; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_Ul_BFu17ll { double v1; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_Ul_BFu1c { double v1; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_Ul_BFu1i { double v1; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_Ul_BFu1ll { double v1; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_Ul_BFu1s { double v1; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_Ul_BFu31i { double v1; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_Ul_BFu31ll { double v1; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_Ul_BFu32i { double v1; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_Ul_BFu32ll { double v1; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_Ul_BFu33 { double v1; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_Ul_BFu7c { double v1; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_Ul_BFu7i { double v1; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_Ul_BFu7ll { double v1; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_Ul_BFu7s { double v1; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_Ul_BFu8c { double v1; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_Ul_BFu8i { double v1; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_Ul_BFu8ll { double v1; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_Ul_BFu8s { double v1; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_Ul_BFu9i { double v1; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_Ul_BFu9ll { double v1; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_Ul_BFu9s { double v1; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_Ul_C { double v1; unsigned long long v2; char v3; };
struct __attribute__((packed)) aD_Ul_D { double v1; unsigned long long v2; double v3; };
struct __attribute__((packed)) aD_Ul_F { double v1; unsigned long long v2; float v3; };
struct __attribute__((packed)) aD_Ul_I { double v1; unsigned long long v2; int v3; };
struct __attribute__((packed)) aD_Ul_Ip { double v1; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aD_Ul_L { double v1; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aD_Ul_S { double v1; unsigned long long v2; short v3; };
struct __attribute__((packed)) aD_Ul_Uc { double v1; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aD_Ul_Ui { double v1; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aD_Ul_Ul { double v1; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aD_Ul_Us { double v1; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aD_Ul_Vp { double v1; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aD_Us { double v1; unsigned short v2; };
struct __attribute__((packed)) aD_Us_BFu15i { double v1; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_Us_BFu15ll { double v1; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_Us_BFu15s { double v1; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_Us_BFu16i { double v1; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_Us_BFu16ll { double v1; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_Us_BFu16s { double v1; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_Us_BFu17i { double v1; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_Us_BFu17ll { double v1; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_Us_BFu1c { double v1; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_Us_BFu1i { double v1; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_Us_BFu1ll { double v1; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_Us_BFu1s { double v1; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_Us_BFu31i { double v1; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_Us_BFu31ll { double v1; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_Us_BFu32i { double v1; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_Us_BFu32ll { double v1; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_Us_BFu33 { double v1; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_Us_BFu7c { double v1; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_Us_BFu7i { double v1; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_Us_BFu7ll { double v1; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_Us_BFu7s { double v1; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_Us_BFu8c { double v1; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_Us_BFu8i { double v1; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_Us_BFu8ll { double v1; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_Us_BFu8s { double v1; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_Us_BFu9i { double v1; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_Us_BFu9ll { double v1; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_Us_BFu9s { double v1; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_Us_C { double v1; unsigned short v2; char v3; };
struct __attribute__((packed)) aD_Us_D { double v1; unsigned short v2; double v3; };
struct __attribute__((packed)) aD_Us_F { double v1; unsigned short v2; float v3; };
struct __attribute__((packed)) aD_Us_I { double v1; unsigned short v2; int v3; };
struct __attribute__((packed)) aD_Us_Ip { double v1; unsigned short v2; int * v3; };
struct __attribute__((packed)) aD_Us_L { double v1; unsigned short v2; long long v3; };
struct __attribute__((packed)) aD_Us_S { double v1; unsigned short v2; short v3; };
struct __attribute__((packed)) aD_Us_Uc { double v1; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aD_Us_Ui { double v1; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aD_Us_Ul { double v1; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aD_Us_Us { double v1; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aD_Us_Vp { double v1; unsigned short v2; void * v3; };
struct __attribute__((packed)) aD_Vp { double v1; void * v2; };
struct __attribute__((packed)) aD_Vp_BFu15i { double v1; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aD_Vp_BFu15ll { double v1; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aD_Vp_BFu15s { double v1; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aD_Vp_BFu16i { double v1; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aD_Vp_BFu16ll { double v1; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aD_Vp_BFu16s { double v1; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aD_Vp_BFu17i { double v1; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aD_Vp_BFu17ll { double v1; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aD_Vp_BFu1c { double v1; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aD_Vp_BFu1i { double v1; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aD_Vp_BFu1ll { double v1; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aD_Vp_BFu1s { double v1; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aD_Vp_BFu31i { double v1; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aD_Vp_BFu31ll { double v1; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aD_Vp_BFu32i { double v1; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aD_Vp_BFu32ll { double v1; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aD_Vp_BFu33 { double v1; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aD_Vp_BFu7c { double v1; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aD_Vp_BFu7i { double v1; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aD_Vp_BFu7ll { double v1; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aD_Vp_BFu7s { double v1; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aD_Vp_BFu8c { double v1; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aD_Vp_BFu8i { double v1; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aD_Vp_BFu8ll { double v1; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aD_Vp_BFu8s { double v1; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aD_Vp_BFu9i { double v1; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aD_Vp_BFu9ll { double v1; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aD_Vp_BFu9s { double v1; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aD_Vp_C { double v1; void * v2; char v3; };
struct __attribute__((packed)) aD_Vp_D { double v1; void * v2; double v3; };
struct __attribute__((packed)) aD_Vp_F { double v1; void * v2; float v3; };
struct __attribute__((packed)) aD_Vp_I { double v1; void * v2; int v3; };
struct __attribute__((packed)) aD_Vp_Ip { double v1; void * v2; int * v3; };
struct __attribute__((packed)) aD_Vp_L { double v1; void * v2; long long v3; };
struct __attribute__((packed)) aD_Vp_S { double v1; void * v2; short v3; };
struct __attribute__((packed)) aD_Vp_Uc { double v1; void * v2; unsigned char v3; };
struct __attribute__((packed)) aD_Vp_Ui { double v1; void * v2; unsigned int v3; };
struct __attribute__((packed)) aD_Vp_Ul { double v1; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aD_Vp_Us { double v1; void * v2; unsigned short v3; };
struct __attribute__((packed)) aD_Vp_Vp { double v1; void * v2; void * v3; };
struct __attribute__((packed)) aF { float v1; };
struct __attribute__((packed)) aF_BFu15i { float v1; unsigned int v2:15; };
struct __attribute__((packed)) aF_BFu15i_BFu15i { float v1; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu15i_BFu15ll { float v1; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu15i_BFu15s { float v1; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu15i_BFu16i { float v1; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu15i_BFu16ll { float v1; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu15i_BFu16s { float v1; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu15i_BFu17i { float v1; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu15i_BFu17ll { float v1; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu15i_BFu1c { float v1; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu15i_BFu1i { float v1; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu15i_BFu1ll { float v1; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu15i_BFu1s { float v1; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu15i_BFu31i { float v1; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu15i_BFu31ll { float v1; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu15i_BFu32i { float v1; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu15i_BFu32ll { float v1; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu15i_BFu33 { float v1; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu15i_BFu7c { float v1; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu15i_BFu7i { float v1; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu15i_BFu7ll { float v1; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu15i_BFu7s { float v1; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu15i_BFu8c { float v1; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu15i_BFu8i { float v1; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu15i_BFu8ll { float v1; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu15i_BFu8s { float v1; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu15i_BFu9i { float v1; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu15i_BFu9ll { float v1; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu15i_BFu9s { float v1; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu15i_C { float v1; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aF_BFu15i_D { float v1; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aF_BFu15i_F { float v1; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aF_BFu15i_I { float v1; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aF_BFu15i_Ip { float v1; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aF_BFu15i_L { float v1; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aF_BFu15i_S { float v1; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aF_BFu15i_Uc { float v1; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aF_BFu15i_Ui { float v1; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aF_BFu15i_Ul { float v1; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu15i_Us { float v1; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aF_BFu15i_Vp { float v1; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aF_BFu15ll { float v1; unsigned long long v2:15; };
struct __attribute__((packed)) aF_BFu15ll_BFu15i { float v1; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu15ll_BFu15ll { float v1; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu15ll_BFu15s { float v1; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu15ll_BFu16i { float v1; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu15ll_BFu16ll { float v1; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu15ll_BFu16s { float v1; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu15ll_BFu17i { float v1; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu15ll_BFu17ll { float v1; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu15ll_BFu1c { float v1; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu15ll_BFu1i { float v1; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu15ll_BFu1ll { float v1; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu15ll_BFu1s { float v1; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu15ll_BFu31i { float v1; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu15ll_BFu31ll { float v1; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu15ll_BFu32i { float v1; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu15ll_BFu32ll { float v1; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu15ll_BFu33 { float v1; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu15ll_BFu7c { float v1; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu15ll_BFu7i { float v1; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu15ll_BFu7ll { float v1; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu15ll_BFu7s { float v1; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu15ll_BFu8c { float v1; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu15ll_BFu8i { float v1; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu15ll_BFu8ll { float v1; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu15ll_BFu8s { float v1; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu15ll_BFu9i { float v1; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu15ll_BFu9ll { float v1; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu15ll_BFu9s { float v1; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu15ll_C { float v1; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aF_BFu15ll_D { float v1; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aF_BFu15ll_F { float v1; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aF_BFu15ll_I { float v1; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aF_BFu15ll_Ip { float v1; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aF_BFu15ll_L { float v1; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aF_BFu15ll_S { float v1; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aF_BFu15ll_Uc { float v1; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aF_BFu15ll_Ui { float v1; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aF_BFu15ll_Ul { float v1; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu15ll_Us { float v1; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aF_BFu15ll_Vp { float v1; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aF_BFu15s { float v1; unsigned short v2:15; };
struct __attribute__((packed)) aF_BFu15s_BFu15i { float v1; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu15s_BFu15ll { float v1; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu15s_BFu15s { float v1; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu15s_BFu16i { float v1; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu15s_BFu16ll { float v1; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu15s_BFu16s { float v1; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu15s_BFu17i { float v1; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu15s_BFu17ll { float v1; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu15s_BFu1c { float v1; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu15s_BFu1i { float v1; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu15s_BFu1ll { float v1; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu15s_BFu1s { float v1; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu15s_BFu31i { float v1; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu15s_BFu31ll { float v1; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu15s_BFu32i { float v1; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu15s_BFu32ll { float v1; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu15s_BFu33 { float v1; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu15s_BFu7c { float v1; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu15s_BFu7i { float v1; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu15s_BFu7ll { float v1; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu15s_BFu7s { float v1; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu15s_BFu8c { float v1; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu15s_BFu8i { float v1; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu15s_BFu8ll { float v1; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu15s_BFu8s { float v1; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu15s_BFu9i { float v1; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu15s_BFu9ll { float v1; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu15s_BFu9s { float v1; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu15s_C { float v1; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aF_BFu15s_D { float v1; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aF_BFu15s_F { float v1; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aF_BFu15s_I { float v1; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aF_BFu15s_Ip { float v1; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aF_BFu15s_L { float v1; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aF_BFu15s_S { float v1; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aF_BFu15s_Uc { float v1; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aF_BFu15s_Ui { float v1; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aF_BFu15s_Ul { float v1; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu15s_Us { float v1; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aF_BFu15s_Vp { float v1; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aF_BFu16i { float v1; unsigned int v2:16; };
struct __attribute__((packed)) aF_BFu16i_BFu15i { float v1; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu16i_BFu15ll { float v1; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu16i_BFu15s { float v1; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu16i_BFu16i { float v1; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu16i_BFu16ll { float v1; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu16i_BFu16s { float v1; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu16i_BFu17i { float v1; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu16i_BFu17ll { float v1; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu16i_BFu1c { float v1; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu16i_BFu1i { float v1; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu16i_BFu1ll { float v1; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu16i_BFu1s { float v1; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu16i_BFu31i { float v1; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu16i_BFu31ll { float v1; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu16i_BFu32i { float v1; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu16i_BFu32ll { float v1; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu16i_BFu33 { float v1; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu16i_BFu7c { float v1; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu16i_BFu7i { float v1; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu16i_BFu7ll { float v1; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu16i_BFu7s { float v1; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu16i_BFu8c { float v1; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu16i_BFu8i { float v1; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu16i_BFu8ll { float v1; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu16i_BFu8s { float v1; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu16i_BFu9i { float v1; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu16i_BFu9ll { float v1; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu16i_BFu9s { float v1; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu16i_C { float v1; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aF_BFu16i_D { float v1; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aF_BFu16i_F { float v1; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aF_BFu16i_I { float v1; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aF_BFu16i_Ip { float v1; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aF_BFu16i_L { float v1; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aF_BFu16i_S { float v1; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aF_BFu16i_Uc { float v1; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aF_BFu16i_Ui { float v1; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aF_BFu16i_Ul { float v1; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu16i_Us { float v1; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aF_BFu16i_Vp { float v1; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aF_BFu16ll { float v1; unsigned long long v2:16; };
struct __attribute__((packed)) aF_BFu16ll_BFu15i { float v1; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu16ll_BFu15ll { float v1; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu16ll_BFu15s { float v1; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu16ll_BFu16i { float v1; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu16ll_BFu16ll { float v1; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu16ll_BFu16s { float v1; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu16ll_BFu17i { float v1; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu16ll_BFu17ll { float v1; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu16ll_BFu1c { float v1; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu16ll_BFu1i { float v1; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu16ll_BFu1ll { float v1; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu16ll_BFu1s { float v1; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu16ll_BFu31i { float v1; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu16ll_BFu31ll { float v1; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu16ll_BFu32i { float v1; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu16ll_BFu32ll { float v1; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu16ll_BFu33 { float v1; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu16ll_BFu7c { float v1; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu16ll_BFu7i { float v1; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu16ll_BFu7ll { float v1; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu16ll_BFu7s { float v1; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu16ll_BFu8c { float v1; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu16ll_BFu8i { float v1; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu16ll_BFu8ll { float v1; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu16ll_BFu8s { float v1; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu16ll_BFu9i { float v1; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu16ll_BFu9ll { float v1; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu16ll_BFu9s { float v1; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu16ll_C { float v1; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aF_BFu16ll_D { float v1; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aF_BFu16ll_F { float v1; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aF_BFu16ll_I { float v1; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aF_BFu16ll_Ip { float v1; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aF_BFu16ll_L { float v1; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aF_BFu16ll_S { float v1; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aF_BFu16ll_Uc { float v1; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aF_BFu16ll_Ui { float v1; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aF_BFu16ll_Ul { float v1; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu16ll_Us { float v1; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aF_BFu16ll_Vp { float v1; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aF_BFu16s { float v1; unsigned short v2:16; };
struct __attribute__((packed)) aF_BFu16s_BFu15i { float v1; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu16s_BFu15ll { float v1; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu16s_BFu15s { float v1; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu16s_BFu16i { float v1; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu16s_BFu16ll { float v1; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu16s_BFu16s { float v1; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu16s_BFu17i { float v1; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu16s_BFu17ll { float v1; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu16s_BFu1c { float v1; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu16s_BFu1i { float v1; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu16s_BFu1ll { float v1; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu16s_BFu1s { float v1; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu16s_BFu31i { float v1; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu16s_BFu31ll { float v1; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu16s_BFu32i { float v1; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu16s_BFu32ll { float v1; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu16s_BFu33 { float v1; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu16s_BFu7c { float v1; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu16s_BFu7i { float v1; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu16s_BFu7ll { float v1; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu16s_BFu7s { float v1; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu16s_BFu8c { float v1; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu16s_BFu8i { float v1; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu16s_BFu8ll { float v1; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu16s_BFu8s { float v1; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu16s_BFu9i { float v1; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu16s_BFu9ll { float v1; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu16s_BFu9s { float v1; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu16s_C { float v1; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aF_BFu16s_D { float v1; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aF_BFu16s_F { float v1; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aF_BFu16s_I { float v1; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aF_BFu16s_Ip { float v1; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aF_BFu16s_L { float v1; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aF_BFu16s_S { float v1; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aF_BFu16s_Uc { float v1; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aF_BFu16s_Ui { float v1; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aF_BFu16s_Ul { float v1; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu16s_Us { float v1; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aF_BFu16s_Vp { float v1; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aF_BFu17i { float v1; unsigned int v2:17; };
struct __attribute__((packed)) aF_BFu17i_BFu15i { float v1; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu17i_BFu15ll { float v1; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu17i_BFu15s { float v1; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu17i_BFu16i { float v1; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu17i_BFu16ll { float v1; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu17i_BFu16s { float v1; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu17i_BFu17i { float v1; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu17i_BFu17ll { float v1; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu17i_BFu1c { float v1; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu17i_BFu1i { float v1; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu17i_BFu1ll { float v1; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu17i_BFu1s { float v1; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu17i_BFu31i { float v1; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu17i_BFu31ll { float v1; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu17i_BFu32i { float v1; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu17i_BFu32ll { float v1; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu17i_BFu33 { float v1; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu17i_BFu7c { float v1; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu17i_BFu7i { float v1; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu17i_BFu7ll { float v1; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu17i_BFu7s { float v1; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu17i_BFu8c { float v1; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu17i_BFu8i { float v1; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu17i_BFu8ll { float v1; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu17i_BFu8s { float v1; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu17i_BFu9i { float v1; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu17i_BFu9ll { float v1; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu17i_BFu9s { float v1; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu17i_C { float v1; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aF_BFu17i_D { float v1; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aF_BFu17i_F { float v1; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aF_BFu17i_I { float v1; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aF_BFu17i_Ip { float v1; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aF_BFu17i_L { float v1; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aF_BFu17i_S { float v1; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aF_BFu17i_Uc { float v1; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aF_BFu17i_Ui { float v1; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aF_BFu17i_Ul { float v1; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu17i_Us { float v1; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aF_BFu17i_Vp { float v1; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aF_BFu17ll { float v1; unsigned long long v2:17; };
struct __attribute__((packed)) aF_BFu17ll_BFu15i { float v1; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu17ll_BFu15ll { float v1; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu17ll_BFu15s { float v1; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu17ll_BFu16i { float v1; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu17ll_BFu16ll { float v1; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu17ll_BFu16s { float v1; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu17ll_BFu17i { float v1; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu17ll_BFu17ll { float v1; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu17ll_BFu1c { float v1; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu17ll_BFu1i { float v1; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu17ll_BFu1ll { float v1; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu17ll_BFu1s { float v1; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu17ll_BFu31i { float v1; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu17ll_BFu31ll { float v1; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu17ll_BFu32i { float v1; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu17ll_BFu32ll { float v1; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu17ll_BFu33 { float v1; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu17ll_BFu7c { float v1; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu17ll_BFu7i { float v1; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu17ll_BFu7ll { float v1; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu17ll_BFu7s { float v1; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu17ll_BFu8c { float v1; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu17ll_BFu8i { float v1; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu17ll_BFu8ll { float v1; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu17ll_BFu8s { float v1; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu17ll_BFu9i { float v1; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu17ll_BFu9ll { float v1; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu17ll_BFu9s { float v1; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu17ll_C { float v1; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aF_BFu17ll_D { float v1; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aF_BFu17ll_F { float v1; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aF_BFu17ll_I { float v1; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aF_BFu17ll_Ip { float v1; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aF_BFu17ll_L { float v1; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aF_BFu17ll_S { float v1; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aF_BFu17ll_Uc { float v1; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aF_BFu17ll_Ui { float v1; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aF_BFu17ll_Ul { float v1; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu17ll_Us { float v1; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aF_BFu17ll_Vp { float v1; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aF_BFu1c { float v1; unsigned char v2:1; };
struct __attribute__((packed)) aF_BFu1c_BFu15i { float v1; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu1c_BFu15ll { float v1; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu1c_BFu15s { float v1; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu1c_BFu16i { float v1; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu1c_BFu16ll { float v1; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu1c_BFu16s { float v1; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu1c_BFu17i { float v1; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu1c_BFu17ll { float v1; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu1c_BFu1c { float v1; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu1c_BFu1i { float v1; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu1c_BFu1ll { float v1; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu1c_BFu1s { float v1; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu1c_BFu31i { float v1; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu1c_BFu31ll { float v1; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu1c_BFu32i { float v1; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu1c_BFu32ll { float v1; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu1c_BFu33 { float v1; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu1c_BFu7c { float v1; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu1c_BFu7i { float v1; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu1c_BFu7ll { float v1; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu1c_BFu7s { float v1; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu1c_BFu8c { float v1; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu1c_BFu8i { float v1; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu1c_BFu8ll { float v1; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu1c_BFu8s { float v1; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu1c_BFu9i { float v1; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu1c_BFu9ll { float v1; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu1c_BFu9s { float v1; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu1c_C { float v1; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aF_BFu1c_D { float v1; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aF_BFu1c_F { float v1; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aF_BFu1c_I { float v1; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aF_BFu1c_Ip { float v1; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aF_BFu1c_L { float v1; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aF_BFu1c_S { float v1; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aF_BFu1c_Uc { float v1; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aF_BFu1c_Ui { float v1; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aF_BFu1c_Ul { float v1; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aF_BFu1c_Us { float v1; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aF_BFu1c_Vp { float v1; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aF_BFu1i { float v1; unsigned int v2:1; };
struct __attribute__((packed)) aF_BFu1i_BFu15i { float v1; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aF_BFu1i_BFu15ll { float v1; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aF_BFu1i_BFu15s { float v1; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aF_BFu1i_BFu16i { float v1; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aF_BFu1i_BFu16ll { float v1; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aF_BFu1i_BFu16s { float v1; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aF_BFu1i_BFu17i { float v1; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aF_BFu1i_BFu17ll { float v1; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aF_BFu1i_BFu1c { float v1; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aF_BFu1i_BFu1i { float v1; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aF_BFu1i_BFu1ll { float v1; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aF_BFu1i_BFu1s { float v1; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aF_BFu1i_BFu31i { float v1; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aF_BFu1i_BFu31ll { float v1; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aF_BFu1i_BFu32i { float v1; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aF_BFu1i_BFu32ll { float v1; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aF_BFu1i_BFu33 { float v1; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aF_BFu1i_BFu7c { float v1; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aF_BFu1i_BFu7i { float v1; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aF_BFu1i_BFu7ll { float v1; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aF_BFu1i_BFu7s { float v1; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aF_BFu1i_BFu8c { float v1; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aF_BFu1i_BFu8i { float v1; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aF_BFu1i_BFu8ll { float v1; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aF_BFu1i_BFu8s { float v1; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aF_BFu1i_BFu9i { float v1; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aF_BFu1i_BFu9ll { float v1; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aF_BFu1i_BFu9s { float v1; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aF_BFu1i_C { float v1; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aF_BFu1i_D { float v1; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aF_BFu1i_F { float v1; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aF_BFu1i_I { float v1; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aF_BFu1i_Ip { float v1; unsigned int v2:1; int * v3; };


static void Test_aC_BFu33_C()
{
  {
    init_simple_test("aC_BFu33_C");
    static STRUCT_IF_C aC_BFu33_C lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu33_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu33_C)");
    check_field_offset(lv, v1, 0, "aC_BFu33_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aC_BFu33_C");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aC_BFu33_C");
    check_field_offset(lv, v3, 6, "aC_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu33_C, aC_BFu33_C)
//============================================================================



static void Test_aC_BFu33_D()
{
  {
    init_simple_test("aC_BFu33_D");
    static STRUCT_IF_C aC_BFu33_D lv;
    check2(sizeof(lv), 14, "sizeof(aC_BFu33_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu33_D)");
    check_field_offset(lv, v1, 0, "aC_BFu33_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aC_BFu33_D");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aC_BFu33_D");
    check_field_offset(lv, v3, 6, "aC_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu33_D, aC_BFu33_D)
//============================================================================



static void Test_aC_BFu33_F()
{
  {
    init_simple_test("aC_BFu33_F");
    static STRUCT_IF_C aC_BFu33_F lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu33_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu33_F)");
    check_field_offset(lv, v1, 0, "aC_BFu33_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aC_BFu33_F");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aC_BFu33_F");
    check_field_offset(lv, v3, 6, "aC_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu33_F, aC_BFu33_F)
//============================================================================



static void Test_aC_BFu33_I()
{
  {
    init_simple_test("aC_BFu33_I");
    static STRUCT_IF_C aC_BFu33_I lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu33_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu33_I)");
    check_field_offset(lv, v1, 0, "aC_BFu33_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aC_BFu33_I");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aC_BFu33_I");
    check_field_offset(lv, v3, 6, "aC_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu33_I, aC_BFu33_I)
//============================================================================



static void Test_aC_BFu33_Ip()
{
  {
    init_simple_test("aC_BFu33_Ip");
    static STRUCT_IF_C aC_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aC_BFu33_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu33_Ip)");
    check_field_offset(lv, v1, 0, "aC_BFu33_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aC_BFu33_Ip");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aC_BFu33_Ip");
    check_field_offset(lv, v3, 6, "aC_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu33_Ip, aC_BFu33_Ip)
//============================================================================



static void Test_aC_BFu33_L()
{
  {
    init_simple_test("aC_BFu33_L");
    static STRUCT_IF_C aC_BFu33_L lv;
    check2(sizeof(lv), 14, "sizeof(aC_BFu33_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu33_L)");
    check_field_offset(lv, v1, 0, "aC_BFu33_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aC_BFu33_L");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aC_BFu33_L");
    check_field_offset(lv, v3, 6, "aC_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu33_L, aC_BFu33_L)
//============================================================================



static void Test_aC_BFu33_S()
{
  {
    init_simple_test("aC_BFu33_S");
    static STRUCT_IF_C aC_BFu33_S lv;
    check2(sizeof(lv), 8, "sizeof(aC_BFu33_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu33_S)");
    check_field_offset(lv, v1, 0, "aC_BFu33_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aC_BFu33_S");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aC_BFu33_S");
    check_field_offset(lv, v3, 6, "aC_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu33_S, aC_BFu33_S)
//============================================================================



static void Test_aC_BFu33_Uc()
{
  {
    init_simple_test("aC_BFu33_Uc");
    static STRUCT_IF_C aC_BFu33_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu33_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu33_Uc)");
    check_field_offset(lv, v1, 0, "aC_BFu33_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aC_BFu33_Uc");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aC_BFu33_Uc");
    check_field_offset(lv, v3, 6, "aC_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu33_Uc, aC_BFu33_Uc)
//============================================================================



static void Test_aC_BFu33_Ui()
{
  {
    init_simple_test("aC_BFu33_Ui");
    static STRUCT_IF_C aC_BFu33_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu33_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu33_Ui)");
    check_field_offset(lv, v1, 0, "aC_BFu33_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aC_BFu33_Ui");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aC_BFu33_Ui");
    check_field_offset(lv, v3, 6, "aC_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu33_Ui, aC_BFu33_Ui)
//============================================================================



static void Test_aC_BFu33_Ul()
{
  {
    init_simple_test("aC_BFu33_Ul");
    static STRUCT_IF_C aC_BFu33_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aC_BFu33_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu33_Ul)");
    check_field_offset(lv, v1, 0, "aC_BFu33_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aC_BFu33_Ul");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aC_BFu33_Ul");
    check_field_offset(lv, v3, 6, "aC_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu33_Ul, aC_BFu33_Ul)
//============================================================================



static void Test_aC_BFu33_Us()
{
  {
    init_simple_test("aC_BFu33_Us");
    static STRUCT_IF_C aC_BFu33_Us lv;
    check2(sizeof(lv), 8, "sizeof(aC_BFu33_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu33_Us)");
    check_field_offset(lv, v1, 0, "aC_BFu33_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aC_BFu33_Us");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aC_BFu33_Us");
    check_field_offset(lv, v3, 6, "aC_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu33_Us, aC_BFu33_Us)
//============================================================================



static void Test_aC_BFu33_Vp()
{
  {
    init_simple_test("aC_BFu33_Vp");
    static STRUCT_IF_C aC_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aC_BFu33_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu33_Vp)");
    check_field_offset(lv, v1, 0, "aC_BFu33_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 33, 1, "aC_BFu33_Vp");
    set_bf_and_test(lv, v2, 1, 0, 33, hide_ull(1LL<<32), "aC_BFu33_Vp");
    check_field_offset(lv, v3, 6, "aC_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu33_Vp, aC_BFu33_Vp)
//============================================================================



static void Test_aC_BFu7c()
{
  {
    init_simple_test("aC_BFu7c");
    static STRUCT_IF_C aC_BFu7c lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c, aC_BFu7c)
//============================================================================



static void Test_aC_BFu7c_BFu15i()
{
  {
    init_simple_test("aC_BFu7c_BFu15i");
    static STRUCT_IF_C aC_BFu7c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aC_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aC_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu15i, aC_BFu7c_BFu15i)
//============================================================================



static void Test_aC_BFu7c_BFu15ll()
{
  {
    init_simple_test("aC_BFu7c_BFu15ll");
    static STRUCT_IF_C aC_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aC_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aC_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu15ll, aC_BFu7c_BFu15ll)
//============================================================================



static void Test_aC_BFu7c_BFu15s()
{
  {
    init_simple_test("aC_BFu7c_BFu15s");
    static STRUCT_IF_C aC_BFu7c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aC_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aC_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu15s, aC_BFu7c_BFu15s)
//============================================================================



static void Test_aC_BFu7c_BFu16i()
{
  {
    init_simple_test("aC_BFu7c_BFu16i");
    static STRUCT_IF_C aC_BFu7c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aC_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aC_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu16i, aC_BFu7c_BFu16i)
//============================================================================



static void Test_aC_BFu7c_BFu16ll()
{
  {
    init_simple_test("aC_BFu7c_BFu16ll");
    static STRUCT_IF_C aC_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aC_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aC_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu16ll, aC_BFu7c_BFu16ll)
//============================================================================



static void Test_aC_BFu7c_BFu16s()
{
  {
    init_simple_test("aC_BFu7c_BFu16s");
    static STRUCT_IF_C aC_BFu7c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aC_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aC_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu16s, aC_BFu7c_BFu16s)
//============================================================================



static void Test_aC_BFu7c_BFu17i()
{
  {
    init_simple_test("aC_BFu7c_BFu17i");
    static STRUCT_IF_C aC_BFu7c_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aC_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aC_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu17i, aC_BFu7c_BFu17i)
//============================================================================



static void Test_aC_BFu7c_BFu17ll()
{
  {
    init_simple_test("aC_BFu7c_BFu17ll");
    static STRUCT_IF_C aC_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aC_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aC_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu17ll, aC_BFu7c_BFu17ll)
//============================================================================



static void Test_aC_BFu7c_BFu1c()
{
  {
    init_simple_test("aC_BFu7c_BFu1c");
    static STRUCT_IF_C aC_BFu7c_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu1c, aC_BFu7c_BFu1c)
//============================================================================



static void Test_aC_BFu7c_BFu1i()
{
  {
    init_simple_test("aC_BFu7c_BFu1i");
    static STRUCT_IF_C aC_BFu7c_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu1i, aC_BFu7c_BFu1i)
//============================================================================



static void Test_aC_BFu7c_BFu1ll()
{
  {
    init_simple_test("aC_BFu7c_BFu1ll");
    static STRUCT_IF_C aC_BFu7c_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu1ll, aC_BFu7c_BFu1ll)
//============================================================================



static void Test_aC_BFu7c_BFu1s()
{
  {
    init_simple_test("aC_BFu7c_BFu1s");
    static STRUCT_IF_C aC_BFu7c_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu1s, aC_BFu7c_BFu1s)
//============================================================================



static void Test_aC_BFu7c_BFu31i()
{
  {
    init_simple_test("aC_BFu7c_BFu31i");
    static STRUCT_IF_C aC_BFu7c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aC_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aC_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu31i, aC_BFu7c_BFu31i)
//============================================================================



static void Test_aC_BFu7c_BFu31ll()
{
  {
    init_simple_test("aC_BFu7c_BFu31ll");
    static STRUCT_IF_C aC_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aC_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aC_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu31ll, aC_BFu7c_BFu31ll)
//============================================================================



static void Test_aC_BFu7c_BFu32i()
{
  {
    init_simple_test("aC_BFu7c_BFu32i");
    static STRUCT_IF_C aC_BFu7c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aC_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aC_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu32i, aC_BFu7c_BFu32i)
//============================================================================



static void Test_aC_BFu7c_BFu32ll()
{
  {
    init_simple_test("aC_BFu7c_BFu32ll");
    static STRUCT_IF_C aC_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aC_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aC_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu32ll, aC_BFu7c_BFu32ll)
//============================================================================



static void Test_aC_BFu7c_BFu33()
{
  {
    init_simple_test("aC_BFu7c_BFu33");
    static STRUCT_IF_C aC_BFu7c_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu33)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "aC_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "aC_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu33, aC_BFu7c_BFu33)
//============================================================================



static void Test_aC_BFu7c_BFu7c()
{
  {
    init_simple_test("aC_BFu7c_BFu7c");
    static STRUCT_IF_C aC_BFu7c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu7c, aC_BFu7c_BFu7c)
//============================================================================



static void Test_aC_BFu7c_BFu7i()
{
  {
    init_simple_test("aC_BFu7c_BFu7i");
    static STRUCT_IF_C aC_BFu7c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu7i, aC_BFu7c_BFu7i)
//============================================================================



static void Test_aC_BFu7c_BFu7ll()
{
  {
    init_simple_test("aC_BFu7c_BFu7ll");
    static STRUCT_IF_C aC_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu7ll, aC_BFu7c_BFu7ll)
//============================================================================



static void Test_aC_BFu7c_BFu7s()
{
  {
    init_simple_test("aC_BFu7c_BFu7s");
    static STRUCT_IF_C aC_BFu7c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu7s, aC_BFu7c_BFu7s)
//============================================================================



static void Test_aC_BFu7c_BFu8c()
{
  {
    init_simple_test("aC_BFu7c_BFu8c");
    static STRUCT_IF_C aC_BFu7c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu8c, aC_BFu7c_BFu8c)
//============================================================================



static void Test_aC_BFu7c_BFu8i()
{
  {
    init_simple_test("aC_BFu7c_BFu8i");
    static STRUCT_IF_C aC_BFu7c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu8i, aC_BFu7c_BFu8i)
//============================================================================



static void Test_aC_BFu7c_BFu8ll()
{
  {
    init_simple_test("aC_BFu7c_BFu8ll");
    static STRUCT_IF_C aC_BFu7c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu8ll, aC_BFu7c_BFu8ll)
//============================================================================



static void Test_aC_BFu7c_BFu8s()
{
  {
    init_simple_test("aC_BFu7c_BFu8s");
    static STRUCT_IF_C aC_BFu7c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu8s, aC_BFu7c_BFu8s)
//============================================================================



static void Test_aC_BFu7c_BFu9i()
{
  {
    init_simple_test("aC_BFu7c_BFu9i");
    static STRUCT_IF_C aC_BFu7c_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aC_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aC_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu9i, aC_BFu7c_BFu9i)
//============================================================================



static void Test_aC_BFu7c_BFu9ll()
{
  {
    init_simple_test("aC_BFu7c_BFu9ll");
    static STRUCT_IF_C aC_BFu7c_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aC_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aC_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu9ll, aC_BFu7c_BFu9ll)
//============================================================================



static void Test_aC_BFu7c_BFu9s()
{
  {
    init_simple_test("aC_BFu7c_BFu9s");
    static STRUCT_IF_C aC_BFu7c_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aC_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aC_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_BFu9s, aC_BFu7c_BFu9s)
//============================================================================



static void Test_aC_BFu7c_C()
{
  {
    init_simple_test("aC_BFu7c_C");
    static STRUCT_IF_C aC_BFu7c_C lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_C)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_C");
    check_field_offset(lv, v3, 2, "aC_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_C, aC_BFu7c_C)
//============================================================================



static void Test_aC_BFu7c_D()
{
  {
    init_simple_test("aC_BFu7c_D");
    static STRUCT_IF_C aC_BFu7c_D lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu7c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_D)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_D");
    check_field_offset(lv, v3, 2, "aC_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_D, aC_BFu7c_D)
//============================================================================



static void Test_aC_BFu7c_F()
{
  {
    init_simple_test("aC_BFu7c_F");
    static STRUCT_IF_C aC_BFu7c_F lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_F)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_F");
    check_field_offset(lv, v3, 2, "aC_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_F, aC_BFu7c_F)
//============================================================================



static void Test_aC_BFu7c_I()
{
  {
    init_simple_test("aC_BFu7c_I");
    static STRUCT_IF_C aC_BFu7c_I lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_I)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_I");
    check_field_offset(lv, v3, 2, "aC_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_I, aC_BFu7c_I)
//============================================================================



static void Test_aC_BFu7c_Ip()
{
  {
    init_simple_test("aC_BFu7c_Ip");
    static STRUCT_IF_C aC_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu7c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_Ip)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_Ip");
    check_field_offset(lv, v3, 2, "aC_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_Ip, aC_BFu7c_Ip)
//============================================================================



static void Test_aC_BFu7c_L()
{
  {
    init_simple_test("aC_BFu7c_L");
    static STRUCT_IF_C aC_BFu7c_L lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_L)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_L");
    check_field_offset(lv, v3, 2, "aC_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_L, aC_BFu7c_L)
//============================================================================



static void Test_aC_BFu7c_S()
{
  {
    init_simple_test("aC_BFu7c_S");
    static STRUCT_IF_C aC_BFu7c_S lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_S)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_S");
    check_field_offset(lv, v3, 2, "aC_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_S, aC_BFu7c_S)
//============================================================================



static void Test_aC_BFu7c_Uc()
{
  {
    init_simple_test("aC_BFu7c_Uc");
    static STRUCT_IF_C aC_BFu7c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_Uc)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_Uc");
    check_field_offset(lv, v3, 2, "aC_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_Uc, aC_BFu7c_Uc)
//============================================================================



static void Test_aC_BFu7c_Ui()
{
  {
    init_simple_test("aC_BFu7c_Ui");
    static STRUCT_IF_C aC_BFu7c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_Ui)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_Ui");
    check_field_offset(lv, v3, 2, "aC_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_Ui, aC_BFu7c_Ui)
//============================================================================



static void Test_aC_BFu7c_Ul()
{
  {
    init_simple_test("aC_BFu7c_Ul");
    static STRUCT_IF_C aC_BFu7c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_Ul)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_Ul");
    check_field_offset(lv, v3, 2, "aC_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_Ul, aC_BFu7c_Ul)
//============================================================================



static void Test_aC_BFu7c_Us()
{
  {
    init_simple_test("aC_BFu7c_Us");
    static STRUCT_IF_C aC_BFu7c_Us lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_Us)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_Us");
    check_field_offset(lv, v3, 2, "aC_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_Us, aC_BFu7c_Us)
//============================================================================



static void Test_aC_BFu7c_Vp()
{
  {
    init_simple_test("aC_BFu7c_Vp");
    static STRUCT_IF_C aC_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7c_Vp)");
    check_field_offset(lv, v1, 0, "aC_BFu7c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7c_Vp");
    check_field_offset(lv, v3, 2, "aC_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7c_Vp, aC_BFu7c_Vp)
//============================================================================



static void Test_aC_BFu7i()
{
  {
    init_simple_test("aC_BFu7i");
    static STRUCT_IF_C aC_BFu7i lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i, aC_BFu7i)
//============================================================================



static void Test_aC_BFu7i_BFu15i()
{
  {
    init_simple_test("aC_BFu7i_BFu15i");
    static STRUCT_IF_C aC_BFu7i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aC_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aC_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu15i, aC_BFu7i_BFu15i)
//============================================================================



static void Test_aC_BFu7i_BFu15ll()
{
  {
    init_simple_test("aC_BFu7i_BFu15ll");
    static STRUCT_IF_C aC_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aC_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aC_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu15ll, aC_BFu7i_BFu15ll)
//============================================================================



static void Test_aC_BFu7i_BFu15s()
{
  {
    init_simple_test("aC_BFu7i_BFu15s");
    static STRUCT_IF_C aC_BFu7i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aC_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aC_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu15s, aC_BFu7i_BFu15s)
//============================================================================



static void Test_aC_BFu7i_BFu16i()
{
  {
    init_simple_test("aC_BFu7i_BFu16i");
    static STRUCT_IF_C aC_BFu7i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aC_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aC_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu16i, aC_BFu7i_BFu16i)
//============================================================================



static void Test_aC_BFu7i_BFu16ll()
{
  {
    init_simple_test("aC_BFu7i_BFu16ll");
    static STRUCT_IF_C aC_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aC_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aC_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu16ll, aC_BFu7i_BFu16ll)
//============================================================================



static void Test_aC_BFu7i_BFu16s()
{
  {
    init_simple_test("aC_BFu7i_BFu16s");
    static STRUCT_IF_C aC_BFu7i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aC_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aC_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu16s, aC_BFu7i_BFu16s)
//============================================================================



static void Test_aC_BFu7i_BFu17i()
{
  {
    init_simple_test("aC_BFu7i_BFu17i");
    static STRUCT_IF_C aC_BFu7i_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aC_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aC_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu17i, aC_BFu7i_BFu17i)
//============================================================================



static void Test_aC_BFu7i_BFu17ll()
{
  {
    init_simple_test("aC_BFu7i_BFu17ll");
    static STRUCT_IF_C aC_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aC_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aC_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu17ll, aC_BFu7i_BFu17ll)
//============================================================================



static void Test_aC_BFu7i_BFu1c()
{
  {
    init_simple_test("aC_BFu7i_BFu1c");
    static STRUCT_IF_C aC_BFu7i_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu1c, aC_BFu7i_BFu1c)
//============================================================================



static void Test_aC_BFu7i_BFu1i()
{
  {
    init_simple_test("aC_BFu7i_BFu1i");
    static STRUCT_IF_C aC_BFu7i_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu1i, aC_BFu7i_BFu1i)
//============================================================================



static void Test_aC_BFu7i_BFu1ll()
{
  {
    init_simple_test("aC_BFu7i_BFu1ll");
    static STRUCT_IF_C aC_BFu7i_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu1ll, aC_BFu7i_BFu1ll)
//============================================================================



static void Test_aC_BFu7i_BFu1s()
{
  {
    init_simple_test("aC_BFu7i_BFu1s");
    static STRUCT_IF_C aC_BFu7i_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu1s, aC_BFu7i_BFu1s)
//============================================================================



static void Test_aC_BFu7i_BFu31i()
{
  {
    init_simple_test("aC_BFu7i_BFu31i");
    static STRUCT_IF_C aC_BFu7i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aC_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aC_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu31i, aC_BFu7i_BFu31i)
//============================================================================



static void Test_aC_BFu7i_BFu31ll()
{
  {
    init_simple_test("aC_BFu7i_BFu31ll");
    static STRUCT_IF_C aC_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aC_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aC_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu31ll, aC_BFu7i_BFu31ll)
//============================================================================



static void Test_aC_BFu7i_BFu32i()
{
  {
    init_simple_test("aC_BFu7i_BFu32i");
    static STRUCT_IF_C aC_BFu7i_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aC_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aC_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu32i, aC_BFu7i_BFu32i)
//============================================================================



static void Test_aC_BFu7i_BFu32ll()
{
  {
    init_simple_test("aC_BFu7i_BFu32ll");
    static STRUCT_IF_C aC_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aC_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aC_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu32ll, aC_BFu7i_BFu32ll)
//============================================================================



static void Test_aC_BFu7i_BFu33()
{
  {
    init_simple_test("aC_BFu7i_BFu33");
    static STRUCT_IF_C aC_BFu7i_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu33)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "aC_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "aC_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu33, aC_BFu7i_BFu33)
//============================================================================



static void Test_aC_BFu7i_BFu7c()
{
  {
    init_simple_test("aC_BFu7i_BFu7c");
    static STRUCT_IF_C aC_BFu7i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu7c, aC_BFu7i_BFu7c)
//============================================================================



static void Test_aC_BFu7i_BFu7i()
{
  {
    init_simple_test("aC_BFu7i_BFu7i");
    static STRUCT_IF_C aC_BFu7i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu7i, aC_BFu7i_BFu7i)
//============================================================================



static void Test_aC_BFu7i_BFu7ll()
{
  {
    init_simple_test("aC_BFu7i_BFu7ll");
    static STRUCT_IF_C aC_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu7ll, aC_BFu7i_BFu7ll)
//============================================================================



static void Test_aC_BFu7i_BFu7s()
{
  {
    init_simple_test("aC_BFu7i_BFu7s");
    static STRUCT_IF_C aC_BFu7i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu7s, aC_BFu7i_BFu7s)
//============================================================================



static void Test_aC_BFu7i_BFu8c()
{
  {
    init_simple_test("aC_BFu7i_BFu8c");
    static STRUCT_IF_C aC_BFu7i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu8c, aC_BFu7i_BFu8c)
//============================================================================



static void Test_aC_BFu7i_BFu8i()
{
  {
    init_simple_test("aC_BFu7i_BFu8i");
    static STRUCT_IF_C aC_BFu7i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu8i, aC_BFu7i_BFu8i)
//============================================================================



static void Test_aC_BFu7i_BFu8ll()
{
  {
    init_simple_test("aC_BFu7i_BFu8ll");
    static STRUCT_IF_C aC_BFu7i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu8ll, aC_BFu7i_BFu8ll)
//============================================================================



static void Test_aC_BFu7i_BFu8s()
{
  {
    init_simple_test("aC_BFu7i_BFu8s");
    static STRUCT_IF_C aC_BFu7i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu8s, aC_BFu7i_BFu8s)
//============================================================================



static void Test_aC_BFu7i_BFu9i()
{
  {
    init_simple_test("aC_BFu7i_BFu9i");
    static STRUCT_IF_C aC_BFu7i_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aC_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aC_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu9i, aC_BFu7i_BFu9i)
//============================================================================



static void Test_aC_BFu7i_BFu9ll()
{
  {
    init_simple_test("aC_BFu7i_BFu9ll");
    static STRUCT_IF_C aC_BFu7i_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aC_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aC_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu9ll, aC_BFu7i_BFu9ll)
//============================================================================



static void Test_aC_BFu7i_BFu9s()
{
  {
    init_simple_test("aC_BFu7i_BFu9s");
    static STRUCT_IF_C aC_BFu7i_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aC_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aC_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_BFu9s, aC_BFu7i_BFu9s)
//============================================================================



static void Test_aC_BFu7i_C()
{
  {
    init_simple_test("aC_BFu7i_C");
    static STRUCT_IF_C aC_BFu7i_C lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_C)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_C");
    check_field_offset(lv, v3, 2, "aC_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_C, aC_BFu7i_C)
//============================================================================



static void Test_aC_BFu7i_D()
{
  {
    init_simple_test("aC_BFu7i_D");
    static STRUCT_IF_C aC_BFu7i_D lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_D)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_D");
    check_field_offset(lv, v3, 2, "aC_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_D, aC_BFu7i_D)
//============================================================================



static void Test_aC_BFu7i_F()
{
  {
    init_simple_test("aC_BFu7i_F");
    static STRUCT_IF_C aC_BFu7i_F lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_F)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_F");
    check_field_offset(lv, v3, 2, "aC_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_F, aC_BFu7i_F)
//============================================================================



static void Test_aC_BFu7i_I()
{
  {
    init_simple_test("aC_BFu7i_I");
    static STRUCT_IF_C aC_BFu7i_I lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_I)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_I");
    check_field_offset(lv, v3, 2, "aC_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_I, aC_BFu7i_I)
//============================================================================



static void Test_aC_BFu7i_Ip()
{
  {
    init_simple_test("aC_BFu7i_Ip");
    static STRUCT_IF_C aC_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_Ip)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_Ip");
    check_field_offset(lv, v3, 2, "aC_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_Ip, aC_BFu7i_Ip)
//============================================================================



static void Test_aC_BFu7i_L()
{
  {
    init_simple_test("aC_BFu7i_L");
    static STRUCT_IF_C aC_BFu7i_L lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_L)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_L");
    check_field_offset(lv, v3, 2, "aC_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_L, aC_BFu7i_L)
//============================================================================



static void Test_aC_BFu7i_S()
{
  {
    init_simple_test("aC_BFu7i_S");
    static STRUCT_IF_C aC_BFu7i_S lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_S)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_S");
    check_field_offset(lv, v3, 2, "aC_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_S, aC_BFu7i_S)
//============================================================================



static void Test_aC_BFu7i_Uc()
{
  {
    init_simple_test("aC_BFu7i_Uc");
    static STRUCT_IF_C aC_BFu7i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_Uc)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_Uc");
    check_field_offset(lv, v3, 2, "aC_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_Uc, aC_BFu7i_Uc)
//============================================================================



static void Test_aC_BFu7i_Ui()
{
  {
    init_simple_test("aC_BFu7i_Ui");
    static STRUCT_IF_C aC_BFu7i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_Ui)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_Ui");
    check_field_offset(lv, v3, 2, "aC_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_Ui, aC_BFu7i_Ui)
//============================================================================



static void Test_aC_BFu7i_Ul()
{
  {
    init_simple_test("aC_BFu7i_Ul");
    static STRUCT_IF_C aC_BFu7i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_Ul)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_Ul");
    check_field_offset(lv, v3, 2, "aC_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_Ul, aC_BFu7i_Ul)
//============================================================================



static void Test_aC_BFu7i_Us()
{
  {
    init_simple_test("aC_BFu7i_Us");
    static STRUCT_IF_C aC_BFu7i_Us lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_Us)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_Us");
    check_field_offset(lv, v3, 2, "aC_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_Us, aC_BFu7i_Us)
//============================================================================



static void Test_aC_BFu7i_Vp()
{
  {
    init_simple_test("aC_BFu7i_Vp");
    static STRUCT_IF_C aC_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7i_Vp)");
    check_field_offset(lv, v1, 0, "aC_BFu7i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7i_Vp");
    check_field_offset(lv, v3, 2, "aC_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7i_Vp, aC_BFu7i_Vp)
//============================================================================



static void Test_aC_BFu7ll()
{
  {
    init_simple_test("aC_BFu7ll");
    static STRUCT_IF_C aC_BFu7ll lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll, aC_BFu7ll)
//============================================================================



static void Test_aC_BFu7ll_BFu15i()
{
  {
    init_simple_test("aC_BFu7ll_BFu15i");
    static STRUCT_IF_C aC_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aC_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aC_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu15i, aC_BFu7ll_BFu15i)
//============================================================================



static void Test_aC_BFu7ll_BFu15ll()
{
  {
    init_simple_test("aC_BFu7ll_BFu15ll");
    static STRUCT_IF_C aC_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aC_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aC_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu15ll, aC_BFu7ll_BFu15ll)
//============================================================================



static void Test_aC_BFu7ll_BFu15s()
{
  {
    init_simple_test("aC_BFu7ll_BFu15s");
    static STRUCT_IF_C aC_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aC_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aC_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu15s, aC_BFu7ll_BFu15s)
//============================================================================



static void Test_aC_BFu7ll_BFu16i()
{
  {
    init_simple_test("aC_BFu7ll_BFu16i");
    static STRUCT_IF_C aC_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aC_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aC_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu16i, aC_BFu7ll_BFu16i)
//============================================================================



static void Test_aC_BFu7ll_BFu16ll()
{
  {
    init_simple_test("aC_BFu7ll_BFu16ll");
    static STRUCT_IF_C aC_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aC_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aC_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu16ll, aC_BFu7ll_BFu16ll)
//============================================================================



static void Test_aC_BFu7ll_BFu16s()
{
  {
    init_simple_test("aC_BFu7ll_BFu16s");
    static STRUCT_IF_C aC_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aC_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aC_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu16s, aC_BFu7ll_BFu16s)
//============================================================================



static void Test_aC_BFu7ll_BFu17i()
{
  {
    init_simple_test("aC_BFu7ll_BFu17i");
    static STRUCT_IF_C aC_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aC_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aC_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu17i, aC_BFu7ll_BFu17i)
//============================================================================



static void Test_aC_BFu7ll_BFu17ll()
{
  {
    init_simple_test("aC_BFu7ll_BFu17ll");
    static STRUCT_IF_C aC_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aC_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aC_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu17ll, aC_BFu7ll_BFu17ll)
//============================================================================



static void Test_aC_BFu7ll_BFu1c()
{
  {
    init_simple_test("aC_BFu7ll_BFu1c");
    static STRUCT_IF_C aC_BFu7ll_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu1c, aC_BFu7ll_BFu1c)
//============================================================================



static void Test_aC_BFu7ll_BFu1i()
{
  {
    init_simple_test("aC_BFu7ll_BFu1i");
    static STRUCT_IF_C aC_BFu7ll_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu1i, aC_BFu7ll_BFu1i)
//============================================================================



static void Test_aC_BFu7ll_BFu1ll()
{
  {
    init_simple_test("aC_BFu7ll_BFu1ll");
    static STRUCT_IF_C aC_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu1ll, aC_BFu7ll_BFu1ll)
//============================================================================



static void Test_aC_BFu7ll_BFu1s()
{
  {
    init_simple_test("aC_BFu7ll_BFu1s");
    static STRUCT_IF_C aC_BFu7ll_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu1s, aC_BFu7ll_BFu1s)
//============================================================================



static void Test_aC_BFu7ll_BFu31i()
{
  {
    init_simple_test("aC_BFu7ll_BFu31i");
    static STRUCT_IF_C aC_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aC_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aC_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu31i, aC_BFu7ll_BFu31i)
//============================================================================



static void Test_aC_BFu7ll_BFu31ll()
{
  {
    init_simple_test("aC_BFu7ll_BFu31ll");
    static STRUCT_IF_C aC_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aC_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aC_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu31ll, aC_BFu7ll_BFu31ll)
//============================================================================



static void Test_aC_BFu7ll_BFu32i()
{
  {
    init_simple_test("aC_BFu7ll_BFu32i");
    static STRUCT_IF_C aC_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aC_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aC_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu32i, aC_BFu7ll_BFu32i)
//============================================================================



static void Test_aC_BFu7ll_BFu32ll()
{
  {
    init_simple_test("aC_BFu7ll_BFu32ll");
    static STRUCT_IF_C aC_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aC_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aC_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu32ll, aC_BFu7ll_BFu32ll)
//============================================================================



static void Test_aC_BFu7ll_BFu33()
{
  {
    init_simple_test("aC_BFu7ll_BFu33");
    static STRUCT_IF_C aC_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu33)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "aC_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "aC_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu33, aC_BFu7ll_BFu33)
//============================================================================



static void Test_aC_BFu7ll_BFu7c()
{
  {
    init_simple_test("aC_BFu7ll_BFu7c");
    static STRUCT_IF_C aC_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu7c, aC_BFu7ll_BFu7c)
//============================================================================



static void Test_aC_BFu7ll_BFu7i()
{
  {
    init_simple_test("aC_BFu7ll_BFu7i");
    static STRUCT_IF_C aC_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu7i, aC_BFu7ll_BFu7i)
//============================================================================



static void Test_aC_BFu7ll_BFu7ll()
{
  {
    init_simple_test("aC_BFu7ll_BFu7ll");
    static STRUCT_IF_C aC_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu7ll, aC_BFu7ll_BFu7ll)
//============================================================================



static void Test_aC_BFu7ll_BFu7s()
{
  {
    init_simple_test("aC_BFu7ll_BFu7s");
    static STRUCT_IF_C aC_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu7s, aC_BFu7ll_BFu7s)
//============================================================================



static void Test_aC_BFu7ll_BFu8c()
{
  {
    init_simple_test("aC_BFu7ll_BFu8c");
    static STRUCT_IF_C aC_BFu7ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu8c, aC_BFu7ll_BFu8c)
//============================================================================



static void Test_aC_BFu7ll_BFu8i()
{
  {
    init_simple_test("aC_BFu7ll_BFu8i");
    static STRUCT_IF_C aC_BFu7ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu8i, aC_BFu7ll_BFu8i)
//============================================================================



static void Test_aC_BFu7ll_BFu8ll()
{
  {
    init_simple_test("aC_BFu7ll_BFu8ll");
    static STRUCT_IF_C aC_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu8ll, aC_BFu7ll_BFu8ll)
//============================================================================



static void Test_aC_BFu7ll_BFu8s()
{
  {
    init_simple_test("aC_BFu7ll_BFu8s");
    static STRUCT_IF_C aC_BFu7ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu8s, aC_BFu7ll_BFu8s)
//============================================================================



static void Test_aC_BFu7ll_BFu9i()
{
  {
    init_simple_test("aC_BFu7ll_BFu9i");
    static STRUCT_IF_C aC_BFu7ll_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aC_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aC_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu9i, aC_BFu7ll_BFu9i)
//============================================================================



static void Test_aC_BFu7ll_BFu9ll()
{
  {
    init_simple_test("aC_BFu7ll_BFu9ll");
    static STRUCT_IF_C aC_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aC_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aC_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu9ll, aC_BFu7ll_BFu9ll)
//============================================================================



static void Test_aC_BFu7ll_BFu9s()
{
  {
    init_simple_test("aC_BFu7ll_BFu9s");
    static STRUCT_IF_C aC_BFu7ll_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aC_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aC_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_BFu9s, aC_BFu7ll_BFu9s)
//============================================================================



static void Test_aC_BFu7ll_C()
{
  {
    init_simple_test("aC_BFu7ll_C");
    static STRUCT_IF_C aC_BFu7ll_C lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_C)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_C");
    check_field_offset(lv, v3, 2, "aC_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_C, aC_BFu7ll_C)
//============================================================================



static void Test_aC_BFu7ll_D()
{
  {
    init_simple_test("aC_BFu7ll_D");
    static STRUCT_IF_C aC_BFu7ll_D lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_D)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_D");
    check_field_offset(lv, v3, 2, "aC_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_D, aC_BFu7ll_D)
//============================================================================



static void Test_aC_BFu7ll_F()
{
  {
    init_simple_test("aC_BFu7ll_F");
    static STRUCT_IF_C aC_BFu7ll_F lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_F)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_F");
    check_field_offset(lv, v3, 2, "aC_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_F, aC_BFu7ll_F)
//============================================================================



static void Test_aC_BFu7ll_I()
{
  {
    init_simple_test("aC_BFu7ll_I");
    static STRUCT_IF_C aC_BFu7ll_I lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_I)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_I");
    check_field_offset(lv, v3, 2, "aC_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_I, aC_BFu7ll_I)
//============================================================================



static void Test_aC_BFu7ll_Ip()
{
  {
    init_simple_test("aC_BFu7ll_Ip");
    static STRUCT_IF_C aC_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_Ip)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_Ip");
    check_field_offset(lv, v3, 2, "aC_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_Ip, aC_BFu7ll_Ip)
//============================================================================



static void Test_aC_BFu7ll_L()
{
  {
    init_simple_test("aC_BFu7ll_L");
    static STRUCT_IF_C aC_BFu7ll_L lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_L)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_L");
    check_field_offset(lv, v3, 2, "aC_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_L, aC_BFu7ll_L)
//============================================================================



static void Test_aC_BFu7ll_S()
{
  {
    init_simple_test("aC_BFu7ll_S");
    static STRUCT_IF_C aC_BFu7ll_S lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_S)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_S");
    check_field_offset(lv, v3, 2, "aC_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_S, aC_BFu7ll_S)
//============================================================================



static void Test_aC_BFu7ll_Uc()
{
  {
    init_simple_test("aC_BFu7ll_Uc");
    static STRUCT_IF_C aC_BFu7ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_Uc)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_Uc");
    check_field_offset(lv, v3, 2, "aC_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_Uc, aC_BFu7ll_Uc)
//============================================================================



static void Test_aC_BFu7ll_Ui()
{
  {
    init_simple_test("aC_BFu7ll_Ui");
    static STRUCT_IF_C aC_BFu7ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_Ui)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_Ui");
    check_field_offset(lv, v3, 2, "aC_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_Ui, aC_BFu7ll_Ui)
//============================================================================



static void Test_aC_BFu7ll_Ul()
{
  {
    init_simple_test("aC_BFu7ll_Ul");
    static STRUCT_IF_C aC_BFu7ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_Ul)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_Ul");
    check_field_offset(lv, v3, 2, "aC_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_Ul, aC_BFu7ll_Ul)
//============================================================================



static void Test_aC_BFu7ll_Us()
{
  {
    init_simple_test("aC_BFu7ll_Us");
    static STRUCT_IF_C aC_BFu7ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_Us)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_Us");
    check_field_offset(lv, v3, 2, "aC_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_Us, aC_BFu7ll_Us)
//============================================================================



static void Test_aC_BFu7ll_Vp()
{
  {
    init_simple_test("aC_BFu7ll_Vp");
    static STRUCT_IF_C aC_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7ll_Vp)");
    check_field_offset(lv, v1, 0, "aC_BFu7ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7ll_Vp");
    check_field_offset(lv, v3, 2, "aC_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7ll_Vp, aC_BFu7ll_Vp)
//============================================================================



static void Test_aC_BFu7s()
{
  {
    init_simple_test("aC_BFu7s");
    static STRUCT_IF_C aC_BFu7s lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s, aC_BFu7s)
//============================================================================



static void Test_aC_BFu7s_BFu15i()
{
  {
    init_simple_test("aC_BFu7s_BFu15i");
    static STRUCT_IF_C aC_BFu7s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aC_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aC_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu15i, aC_BFu7s_BFu15i)
//============================================================================



static void Test_aC_BFu7s_BFu15ll()
{
  {
    init_simple_test("aC_BFu7s_BFu15ll");
    static STRUCT_IF_C aC_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aC_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aC_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu15ll, aC_BFu7s_BFu15ll)
//============================================================================



static void Test_aC_BFu7s_BFu15s()
{
  {
    init_simple_test("aC_BFu7s_BFu15s");
    static STRUCT_IF_C aC_BFu7s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, 1, "aC_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 1, 7, 15, hide_ull(1LL<<14), "aC_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu15s, aC_BFu7s_BFu15s)
//============================================================================



static void Test_aC_BFu7s_BFu16i()
{
  {
    init_simple_test("aC_BFu7s_BFu16i");
    static STRUCT_IF_C aC_BFu7s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aC_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aC_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu16i, aC_BFu7s_BFu16i)
//============================================================================



static void Test_aC_BFu7s_BFu16ll()
{
  {
    init_simple_test("aC_BFu7s_BFu16ll");
    static STRUCT_IF_C aC_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aC_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aC_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu16ll, aC_BFu7s_BFu16ll)
//============================================================================



static void Test_aC_BFu7s_BFu16s()
{
  {
    init_simple_test("aC_BFu7s_BFu16s");
    static STRUCT_IF_C aC_BFu7s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, 1, "aC_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 1, 7, 16, hide_ull(1LL<<15), "aC_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu16s, aC_BFu7s_BFu16s)
//============================================================================



static void Test_aC_BFu7s_BFu17i()
{
  {
    init_simple_test("aC_BFu7s_BFu17i");
    static STRUCT_IF_C aC_BFu7s_BFu17i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aC_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aC_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu17i, aC_BFu7s_BFu17i)
//============================================================================



static void Test_aC_BFu7s_BFu17ll()
{
  {
    init_simple_test("aC_BFu7s_BFu17ll");
    static STRUCT_IF_C aC_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, 1, "aC_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 1, 7, 17, hide_ull(1LL<<16), "aC_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu17ll, aC_BFu7s_BFu17ll)
//============================================================================



static void Test_aC_BFu7s_BFu1c()
{
  {
    init_simple_test("aC_BFu7s_BFu1c");
    static STRUCT_IF_C aC_BFu7s_BFu1c lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu1c, aC_BFu7s_BFu1c)
//============================================================================



static void Test_aC_BFu7s_BFu1i()
{
  {
    init_simple_test("aC_BFu7s_BFu1i");
    static STRUCT_IF_C aC_BFu7s_BFu1i lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu1i, aC_BFu7s_BFu1i)
//============================================================================



static void Test_aC_BFu7s_BFu1ll()
{
  {
    init_simple_test("aC_BFu7s_BFu1ll");
    static STRUCT_IF_C aC_BFu7s_BFu1ll lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu1ll, aC_BFu7s_BFu1ll)
//============================================================================



static void Test_aC_BFu7s_BFu1s()
{
  {
    init_simple_test("aC_BFu7s_BFu1s");
    static STRUCT_IF_C aC_BFu7s_BFu1s lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 1, 7, 1, 1, "aC_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu1s, aC_BFu7s_BFu1s)
//============================================================================



static void Test_aC_BFu7s_BFu31i()
{
  {
    init_simple_test("aC_BFu7s_BFu31i");
    static STRUCT_IF_C aC_BFu7s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aC_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aC_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu31i, aC_BFu7s_BFu31i)
//============================================================================



static void Test_aC_BFu7s_BFu31ll()
{
  {
    init_simple_test("aC_BFu7s_BFu31ll");
    static STRUCT_IF_C aC_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, 1, "aC_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 1, 7, 31, hide_ull(1LL<<30), "aC_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu31ll, aC_BFu7s_BFu31ll)
//============================================================================



static void Test_aC_BFu7s_BFu32i()
{
  {
    init_simple_test("aC_BFu7s_BFu32i");
    static STRUCT_IF_C aC_BFu7s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aC_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aC_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu32i, aC_BFu7s_BFu32i)
//============================================================================



static void Test_aC_BFu7s_BFu32ll()
{
  {
    init_simple_test("aC_BFu7s_BFu32ll");
    static STRUCT_IF_C aC_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, 1, "aC_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 1, 7, 32, hide_ull(1LL<<31), "aC_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu32ll, aC_BFu7s_BFu32ll)
//============================================================================



static void Test_aC_BFu7s_BFu33()
{
  {
    init_simple_test("aC_BFu7s_BFu33");
    static STRUCT_IF_C aC_BFu7s_BFu33 lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu33)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, 1, "aC_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 1, 7, 33, hide_ull(1LL<<32), "aC_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu33, aC_BFu7s_BFu33)
//============================================================================



static void Test_aC_BFu7s_BFu7c()
{
  {
    init_simple_test("aC_BFu7s_BFu7c");
    static STRUCT_IF_C aC_BFu7s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu7c, aC_BFu7s_BFu7c)
//============================================================================



static void Test_aC_BFu7s_BFu7i()
{
  {
    init_simple_test("aC_BFu7s_BFu7i");
    static STRUCT_IF_C aC_BFu7s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu7i, aC_BFu7s_BFu7i)
//============================================================================



static void Test_aC_BFu7s_BFu7ll()
{
  {
    init_simple_test("aC_BFu7s_BFu7ll");
    static STRUCT_IF_C aC_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu7ll, aC_BFu7s_BFu7ll)
//============================================================================



static void Test_aC_BFu7s_BFu7s()
{
  {
    init_simple_test("aC_BFu7s_BFu7s");
    static STRUCT_IF_C aC_BFu7s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, 1, "aC_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 1, 7, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu7s, aC_BFu7s_BFu7s)
//============================================================================



static void Test_aC_BFu7s_BFu8c()
{
  {
    init_simple_test("aC_BFu7s_BFu8c");
    static STRUCT_IF_C aC_BFu7s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu8c, aC_BFu7s_BFu8c)
//============================================================================



static void Test_aC_BFu7s_BFu8i()
{
  {
    init_simple_test("aC_BFu7s_BFu8i");
    static STRUCT_IF_C aC_BFu7s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu8i, aC_BFu7s_BFu8i)
//============================================================================



static void Test_aC_BFu7s_BFu8ll()
{
  {
    init_simple_test("aC_BFu7s_BFu8ll");
    static STRUCT_IF_C aC_BFu7s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu8ll, aC_BFu7s_BFu8ll)
//============================================================================



static void Test_aC_BFu7s_BFu8s()
{
  {
    init_simple_test("aC_BFu7s_BFu8s");
    static STRUCT_IF_C aC_BFu7s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, 1, "aC_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 1, 7, 8, hide_ull(1LL<<7), "aC_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu8s, aC_BFu7s_BFu8s)
//============================================================================



static void Test_aC_BFu7s_BFu9i()
{
  {
    init_simple_test("aC_BFu7s_BFu9i");
    static STRUCT_IF_C aC_BFu7s_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aC_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aC_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu9i, aC_BFu7s_BFu9i)
//============================================================================



static void Test_aC_BFu7s_BFu9ll()
{
  {
    init_simple_test("aC_BFu7s_BFu9ll");
    static STRUCT_IF_C aC_BFu7s_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aC_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aC_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu9ll, aC_BFu7s_BFu9ll)
//============================================================================



static void Test_aC_BFu7s_BFu9s()
{
  {
    init_simple_test("aC_BFu7s_BFu9s");
    static STRUCT_IF_C aC_BFu7s_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, 1, "aC_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 1, 7, 9, hide_ull(1LL<<8), "aC_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_BFu9s, aC_BFu7s_BFu9s)
//============================================================================



static void Test_aC_BFu7s_C()
{
  {
    init_simple_test("aC_BFu7s_C");
    static STRUCT_IF_C aC_BFu7s_C lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_C)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_C");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_C");
    check_field_offset(lv, v3, 2, "aC_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_C, aC_BFu7s_C)
//============================================================================



static void Test_aC_BFu7s_D()
{
  {
    init_simple_test("aC_BFu7s_D");
    static STRUCT_IF_C aC_BFu7s_D lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_D)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_D");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_D");
    check_field_offset(lv, v3, 2, "aC_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_D, aC_BFu7s_D)
//============================================================================



static void Test_aC_BFu7s_F()
{
  {
    init_simple_test("aC_BFu7s_F");
    static STRUCT_IF_C aC_BFu7s_F lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_F)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_F");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_F");
    check_field_offset(lv, v3, 2, "aC_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_F, aC_BFu7s_F)
//============================================================================



static void Test_aC_BFu7s_I()
{
  {
    init_simple_test("aC_BFu7s_I");
    static STRUCT_IF_C aC_BFu7s_I lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_I)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_I");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_I");
    check_field_offset(lv, v3, 2, "aC_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_I, aC_BFu7s_I)
//============================================================================



static void Test_aC_BFu7s_Ip()
{
  {
    init_simple_test("aC_BFu7s_Ip");
    static STRUCT_IF_C aC_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_Ip)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_Ip");
    check_field_offset(lv, v3, 2, "aC_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_Ip, aC_BFu7s_Ip)
//============================================================================



static void Test_aC_BFu7s_L()
{
  {
    init_simple_test("aC_BFu7s_L");
    static STRUCT_IF_C aC_BFu7s_L lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu7s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_L)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_L");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_L");
    check_field_offset(lv, v3, 2, "aC_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_L, aC_BFu7s_L)
//============================================================================



static void Test_aC_BFu7s_S()
{
  {
    init_simple_test("aC_BFu7s_S");
    static STRUCT_IF_C aC_BFu7s_S lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_S)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_S");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_S");
    check_field_offset(lv, v3, 2, "aC_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_S, aC_BFu7s_S)
//============================================================================



static void Test_aC_BFu7s_Uc()
{
  {
    init_simple_test("aC_BFu7s_Uc");
    static STRUCT_IF_C aC_BFu7s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu7s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_Uc)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_Uc");
    check_field_offset(lv, v3, 2, "aC_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_Uc, aC_BFu7s_Uc)
//============================================================================



static void Test_aC_BFu7s_Ui()
{
  {
    init_simple_test("aC_BFu7s_Ui");
    static STRUCT_IF_C aC_BFu7s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu7s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_Ui)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_Ui");
    check_field_offset(lv, v3, 2, "aC_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_Ui, aC_BFu7s_Ui)
//============================================================================



static void Test_aC_BFu7s_Ul()
{
  {
    init_simple_test("aC_BFu7s_Ul");
    static STRUCT_IF_C aC_BFu7s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu7s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_Ul)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_Ul");
    check_field_offset(lv, v3, 2, "aC_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_Ul, aC_BFu7s_Ul)
//============================================================================



static void Test_aC_BFu7s_Us()
{
  {
    init_simple_test("aC_BFu7s_Us");
    static STRUCT_IF_C aC_BFu7s_Us lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu7s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_Us)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_Us");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_Us");
    check_field_offset(lv, v3, 2, "aC_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_Us, aC_BFu7s_Us)
//============================================================================



static void Test_aC_BFu7s_Vp()
{
  {
    init_simple_test("aC_BFu7s_Vp");
    static STRUCT_IF_C aC_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu7s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu7s_Vp)");
    check_field_offset(lv, v1, 0, "aC_BFu7s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 7, 1, "aC_BFu7s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 7, hide_ull(1LL<<6), "aC_BFu7s_Vp");
    check_field_offset(lv, v3, 2, "aC_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu7s_Vp, aC_BFu7s_Vp)
//============================================================================



static void Test_aC_BFu8c()
{
  {
    init_simple_test("aC_BFu8c");
    static STRUCT_IF_C aC_BFu8c lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c, aC_BFu8c)
//============================================================================



static void Test_aC_BFu8c_BFu15i()
{
  {
    init_simple_test("aC_BFu8c_BFu15i");
    static STRUCT_IF_C aC_BFu8c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu15i, aC_BFu8c_BFu15i)
//============================================================================



static void Test_aC_BFu8c_BFu15ll()
{
  {
    init_simple_test("aC_BFu8c_BFu15ll");
    static STRUCT_IF_C aC_BFu8c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu15ll, aC_BFu8c_BFu15ll)
//============================================================================



static void Test_aC_BFu8c_BFu15s()
{
  {
    init_simple_test("aC_BFu8c_BFu15s");
    static STRUCT_IF_C aC_BFu8c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu15s, aC_BFu8c_BFu15s)
//============================================================================



static void Test_aC_BFu8c_BFu16i()
{
  {
    init_simple_test("aC_BFu8c_BFu16i");
    static STRUCT_IF_C aC_BFu8c_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu16i, aC_BFu8c_BFu16i)
//============================================================================



static void Test_aC_BFu8c_BFu16ll()
{
  {
    init_simple_test("aC_BFu8c_BFu16ll");
    static STRUCT_IF_C aC_BFu8c_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu16ll, aC_BFu8c_BFu16ll)
//============================================================================



static void Test_aC_BFu8c_BFu16s()
{
  {
    init_simple_test("aC_BFu8c_BFu16s");
    static STRUCT_IF_C aC_BFu8c_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu16s, aC_BFu8c_BFu16s)
//============================================================================



static void Test_aC_BFu8c_BFu17i()
{
  {
    init_simple_test("aC_BFu8c_BFu17i");
    static STRUCT_IF_C aC_BFu8c_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu8c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aC_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aC_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu17i, aC_BFu8c_BFu17i)
//============================================================================



static void Test_aC_BFu8c_BFu17ll()
{
  {
    init_simple_test("aC_BFu8c_BFu17ll");
    static STRUCT_IF_C aC_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu8c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aC_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aC_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu17ll, aC_BFu8c_BFu17ll)
//============================================================================



static void Test_aC_BFu8c_BFu1c()
{
  {
    init_simple_test("aC_BFu8c_BFu1c");
    static STRUCT_IF_C aC_BFu8c_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu1c, aC_BFu8c_BFu1c)
//============================================================================



static void Test_aC_BFu8c_BFu1i()
{
  {
    init_simple_test("aC_BFu8c_BFu1i");
    static STRUCT_IF_C aC_BFu8c_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu1i, aC_BFu8c_BFu1i)
//============================================================================



static void Test_aC_BFu8c_BFu1ll()
{
  {
    init_simple_test("aC_BFu8c_BFu1ll");
    static STRUCT_IF_C aC_BFu8c_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu1ll, aC_BFu8c_BFu1ll)
//============================================================================



static void Test_aC_BFu8c_BFu1s()
{
  {
    init_simple_test("aC_BFu8c_BFu1s");
    static STRUCT_IF_C aC_BFu8c_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu1s, aC_BFu8c_BFu1s)
//============================================================================



static void Test_aC_BFu8c_BFu31i()
{
  {
    init_simple_test("aC_BFu8c_BFu31i");
    static STRUCT_IF_C aC_BFu8c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aC_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aC_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu31i, aC_BFu8c_BFu31i)
//============================================================================



static void Test_aC_BFu8c_BFu31ll()
{
  {
    init_simple_test("aC_BFu8c_BFu31ll");
    static STRUCT_IF_C aC_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aC_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aC_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu31ll, aC_BFu8c_BFu31ll)
//============================================================================



static void Test_aC_BFu8c_BFu32i()
{
  {
    init_simple_test("aC_BFu8c_BFu32i");
    static STRUCT_IF_C aC_BFu8c_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aC_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aC_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu32i, aC_BFu8c_BFu32i)
//============================================================================



static void Test_aC_BFu8c_BFu32ll()
{
  {
    init_simple_test("aC_BFu8c_BFu32ll");
    static STRUCT_IF_C aC_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aC_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aC_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu32ll, aC_BFu8c_BFu32ll)
//============================================================================



static void Test_aC_BFu8c_BFu33()
{
  {
    init_simple_test("aC_BFu8c_BFu33");
    static STRUCT_IF_C aC_BFu8c_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu33)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aC_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aC_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu33, aC_BFu8c_BFu33)
//============================================================================



static void Test_aC_BFu8c_BFu7c()
{
  {
    init_simple_test("aC_BFu8c_BFu7c");
    static STRUCT_IF_C aC_BFu8c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu7c, aC_BFu8c_BFu7c)
//============================================================================



static void Test_aC_BFu8c_BFu7i()
{
  {
    init_simple_test("aC_BFu8c_BFu7i");
    static STRUCT_IF_C aC_BFu8c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu7i, aC_BFu8c_BFu7i)
//============================================================================



static void Test_aC_BFu8c_BFu7ll()
{
  {
    init_simple_test("aC_BFu8c_BFu7ll");
    static STRUCT_IF_C aC_BFu8c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu7ll, aC_BFu8c_BFu7ll)
//============================================================================



static void Test_aC_BFu8c_BFu7s()
{
  {
    init_simple_test("aC_BFu8c_BFu7s");
    static STRUCT_IF_C aC_BFu8c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu7s, aC_BFu8c_BFu7s)
//============================================================================



static void Test_aC_BFu8c_BFu8c()
{
  {
    init_simple_test("aC_BFu8c_BFu8c");
    static STRUCT_IF_C aC_BFu8c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu8c, aC_BFu8c_BFu8c)
//============================================================================



static void Test_aC_BFu8c_BFu8i()
{
  {
    init_simple_test("aC_BFu8c_BFu8i");
    static STRUCT_IF_C aC_BFu8c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu8i, aC_BFu8c_BFu8i)
//============================================================================



static void Test_aC_BFu8c_BFu8ll()
{
  {
    init_simple_test("aC_BFu8c_BFu8ll");
    static STRUCT_IF_C aC_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu8ll, aC_BFu8c_BFu8ll)
//============================================================================



static void Test_aC_BFu8c_BFu8s()
{
  {
    init_simple_test("aC_BFu8c_BFu8s");
    static STRUCT_IF_C aC_BFu8c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu8s, aC_BFu8c_BFu8s)
//============================================================================



static void Test_aC_BFu8c_BFu9i()
{
  {
    init_simple_test("aC_BFu8c_BFu9i");
    static STRUCT_IF_C aC_BFu8c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu9i, aC_BFu8c_BFu9i)
//============================================================================



static void Test_aC_BFu8c_BFu9ll()
{
  {
    init_simple_test("aC_BFu8c_BFu9ll");
    static STRUCT_IF_C aC_BFu8c_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu9ll, aC_BFu8c_BFu9ll)
//============================================================================



static void Test_aC_BFu8c_BFu9s()
{
  {
    init_simple_test("aC_BFu8c_BFu9s");
    static STRUCT_IF_C aC_BFu8c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_BFu9s, aC_BFu8c_BFu9s)
//============================================================================



static void Test_aC_BFu8c_C()
{
  {
    init_simple_test("aC_BFu8c_C");
    static STRUCT_IF_C aC_BFu8c_C lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_C)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_C");
    check_field_offset(lv, v3, 2, "aC_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_C, aC_BFu8c_C)
//============================================================================



static void Test_aC_BFu8c_D()
{
  {
    init_simple_test("aC_BFu8c_D");
    static STRUCT_IF_C aC_BFu8c_D lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu8c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_D)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_D");
    check_field_offset(lv, v3, 2, "aC_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_D, aC_BFu8c_D)
//============================================================================



static void Test_aC_BFu8c_F()
{
  {
    init_simple_test("aC_BFu8c_F");
    static STRUCT_IF_C aC_BFu8c_F lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_F)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_F");
    check_field_offset(lv, v3, 2, "aC_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_F, aC_BFu8c_F)
//============================================================================



static void Test_aC_BFu8c_I()
{
  {
    init_simple_test("aC_BFu8c_I");
    static STRUCT_IF_C aC_BFu8c_I lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_I)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_I");
    check_field_offset(lv, v3, 2, "aC_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_I, aC_BFu8c_I)
//============================================================================



static void Test_aC_BFu8c_Ip()
{
  {
    init_simple_test("aC_BFu8c_Ip");
    static STRUCT_IF_C aC_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu8c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_Ip)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_Ip");
    check_field_offset(lv, v3, 2, "aC_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_Ip, aC_BFu8c_Ip)
//============================================================================



static void Test_aC_BFu8c_L()
{
  {
    init_simple_test("aC_BFu8c_L");
    static STRUCT_IF_C aC_BFu8c_L lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu8c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_L)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_L");
    check_field_offset(lv, v3, 2, "aC_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_L, aC_BFu8c_L)
//============================================================================



static void Test_aC_BFu8c_S()
{
  {
    init_simple_test("aC_BFu8c_S");
    static STRUCT_IF_C aC_BFu8c_S lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_S)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_S");
    check_field_offset(lv, v3, 2, "aC_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_S, aC_BFu8c_S)
//============================================================================



static void Test_aC_BFu8c_Uc()
{
  {
    init_simple_test("aC_BFu8c_Uc");
    static STRUCT_IF_C aC_BFu8c_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_Uc)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_Uc");
    check_field_offset(lv, v3, 2, "aC_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_Uc, aC_BFu8c_Uc)
//============================================================================



static void Test_aC_BFu8c_Ui()
{
  {
    init_simple_test("aC_BFu8c_Ui");
    static STRUCT_IF_C aC_BFu8c_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_Ui)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_Ui");
    check_field_offset(lv, v3, 2, "aC_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_Ui, aC_BFu8c_Ui)
//============================================================================



static void Test_aC_BFu8c_Ul()
{
  {
    init_simple_test("aC_BFu8c_Ul");
    static STRUCT_IF_C aC_BFu8c_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu8c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_Ul)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_Ul");
    check_field_offset(lv, v3, 2, "aC_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_Ul, aC_BFu8c_Ul)
//============================================================================



static void Test_aC_BFu8c_Us()
{
  {
    init_simple_test("aC_BFu8c_Us");
    static STRUCT_IF_C aC_BFu8c_Us lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_Us)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_Us");
    check_field_offset(lv, v3, 2, "aC_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_Us, aC_BFu8c_Us)
//============================================================================



static void Test_aC_BFu8c_Vp()
{
  {
    init_simple_test("aC_BFu8c_Vp");
    static STRUCT_IF_C aC_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu8c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8c_Vp)");
    check_field_offset(lv, v1, 0, "aC_BFu8c_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8c_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8c_Vp");
    check_field_offset(lv, v3, 2, "aC_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8c_Vp, aC_BFu8c_Vp)
//============================================================================



static void Test_aC_BFu8i()
{
  {
    init_simple_test("aC_BFu8i");
    static STRUCT_IF_C aC_BFu8i lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i, aC_BFu8i)
//============================================================================



static void Test_aC_BFu8i_BFu15i()
{
  {
    init_simple_test("aC_BFu8i_BFu15i");
    static STRUCT_IF_C aC_BFu8i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu15i, aC_BFu8i_BFu15i)
//============================================================================



static void Test_aC_BFu8i_BFu15ll()
{
  {
    init_simple_test("aC_BFu8i_BFu15ll");
    static STRUCT_IF_C aC_BFu8i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu15ll, aC_BFu8i_BFu15ll)
//============================================================================



static void Test_aC_BFu8i_BFu15s()
{
  {
    init_simple_test("aC_BFu8i_BFu15s");
    static STRUCT_IF_C aC_BFu8i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu15s, aC_BFu8i_BFu15s)
//============================================================================



static void Test_aC_BFu8i_BFu16i()
{
  {
    init_simple_test("aC_BFu8i_BFu16i");
    static STRUCT_IF_C aC_BFu8i_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu16i, aC_BFu8i_BFu16i)
//============================================================================



static void Test_aC_BFu8i_BFu16ll()
{
  {
    init_simple_test("aC_BFu8i_BFu16ll");
    static STRUCT_IF_C aC_BFu8i_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu16ll, aC_BFu8i_BFu16ll)
//============================================================================



static void Test_aC_BFu8i_BFu16s()
{
  {
    init_simple_test("aC_BFu8i_BFu16s");
    static STRUCT_IF_C aC_BFu8i_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu16s, aC_BFu8i_BFu16s)
//============================================================================



static void Test_aC_BFu8i_BFu17i()
{
  {
    init_simple_test("aC_BFu8i_BFu17i");
    static STRUCT_IF_C aC_BFu8i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu8i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aC_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aC_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu17i, aC_BFu8i_BFu17i)
//============================================================================



static void Test_aC_BFu8i_BFu17ll()
{
  {
    init_simple_test("aC_BFu8i_BFu17ll");
    static STRUCT_IF_C aC_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu8i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aC_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aC_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu17ll, aC_BFu8i_BFu17ll)
//============================================================================



static void Test_aC_BFu8i_BFu1c()
{
  {
    init_simple_test("aC_BFu8i_BFu1c");
    static STRUCT_IF_C aC_BFu8i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu1c, aC_BFu8i_BFu1c)
//============================================================================



static void Test_aC_BFu8i_BFu1i()
{
  {
    init_simple_test("aC_BFu8i_BFu1i");
    static STRUCT_IF_C aC_BFu8i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu1i, aC_BFu8i_BFu1i)
//============================================================================



static void Test_aC_BFu8i_BFu1ll()
{
  {
    init_simple_test("aC_BFu8i_BFu1ll");
    static STRUCT_IF_C aC_BFu8i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu1ll, aC_BFu8i_BFu1ll)
//============================================================================



static void Test_aC_BFu8i_BFu1s()
{
  {
    init_simple_test("aC_BFu8i_BFu1s");
    static STRUCT_IF_C aC_BFu8i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu1s, aC_BFu8i_BFu1s)
//============================================================================



static void Test_aC_BFu8i_BFu31i()
{
  {
    init_simple_test("aC_BFu8i_BFu31i");
    static STRUCT_IF_C aC_BFu8i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aC_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aC_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu31i, aC_BFu8i_BFu31i)
//============================================================================



static void Test_aC_BFu8i_BFu31ll()
{
  {
    init_simple_test("aC_BFu8i_BFu31ll");
    static STRUCT_IF_C aC_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aC_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aC_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu31ll, aC_BFu8i_BFu31ll)
//============================================================================



static void Test_aC_BFu8i_BFu32i()
{
  {
    init_simple_test("aC_BFu8i_BFu32i");
    static STRUCT_IF_C aC_BFu8i_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aC_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aC_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu32i, aC_BFu8i_BFu32i)
//============================================================================



static void Test_aC_BFu8i_BFu32ll()
{
  {
    init_simple_test("aC_BFu8i_BFu32ll");
    static STRUCT_IF_C aC_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aC_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aC_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu32ll, aC_BFu8i_BFu32ll)
//============================================================================



static void Test_aC_BFu8i_BFu33()
{
  {
    init_simple_test("aC_BFu8i_BFu33");
    static STRUCT_IF_C aC_BFu8i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu8i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aC_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aC_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu33, aC_BFu8i_BFu33)
//============================================================================



static void Test_aC_BFu8i_BFu7c()
{
  {
    init_simple_test("aC_BFu8i_BFu7c");
    static STRUCT_IF_C aC_BFu8i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu7c, aC_BFu8i_BFu7c)
//============================================================================



static void Test_aC_BFu8i_BFu7i()
{
  {
    init_simple_test("aC_BFu8i_BFu7i");
    static STRUCT_IF_C aC_BFu8i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu7i, aC_BFu8i_BFu7i)
//============================================================================



static void Test_aC_BFu8i_BFu7ll()
{
  {
    init_simple_test("aC_BFu8i_BFu7ll");
    static STRUCT_IF_C aC_BFu8i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu7ll, aC_BFu8i_BFu7ll)
//============================================================================



static void Test_aC_BFu8i_BFu7s()
{
  {
    init_simple_test("aC_BFu8i_BFu7s");
    static STRUCT_IF_C aC_BFu8i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu7s, aC_BFu8i_BFu7s)
//============================================================================



static void Test_aC_BFu8i_BFu8c()
{
  {
    init_simple_test("aC_BFu8i_BFu8c");
    static STRUCT_IF_C aC_BFu8i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu8c, aC_BFu8i_BFu8c)
//============================================================================



static void Test_aC_BFu8i_BFu8i()
{
  {
    init_simple_test("aC_BFu8i_BFu8i");
    static STRUCT_IF_C aC_BFu8i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu8i, aC_BFu8i_BFu8i)
//============================================================================



static void Test_aC_BFu8i_BFu8ll()
{
  {
    init_simple_test("aC_BFu8i_BFu8ll");
    static STRUCT_IF_C aC_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu8ll, aC_BFu8i_BFu8ll)
//============================================================================



static void Test_aC_BFu8i_BFu8s()
{
  {
    init_simple_test("aC_BFu8i_BFu8s");
    static STRUCT_IF_C aC_BFu8i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu8s, aC_BFu8i_BFu8s)
//============================================================================



static void Test_aC_BFu8i_BFu9i()
{
  {
    init_simple_test("aC_BFu8i_BFu9i");
    static STRUCT_IF_C aC_BFu8i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu9i, aC_BFu8i_BFu9i)
//============================================================================



static void Test_aC_BFu8i_BFu9ll()
{
  {
    init_simple_test("aC_BFu8i_BFu9ll");
    static STRUCT_IF_C aC_BFu8i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu9ll, aC_BFu8i_BFu9ll)
//============================================================================



static void Test_aC_BFu8i_BFu9s()
{
  {
    init_simple_test("aC_BFu8i_BFu9s");
    static STRUCT_IF_C aC_BFu8i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_BFu9s, aC_BFu8i_BFu9s)
//============================================================================



static void Test_aC_BFu8i_C()
{
  {
    init_simple_test("aC_BFu8i_C");
    static STRUCT_IF_C aC_BFu8i_C lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_C)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_C");
    check_field_offset(lv, v3, 2, "aC_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_C, aC_BFu8i_C)
//============================================================================



static void Test_aC_BFu8i_D()
{
  {
    init_simple_test("aC_BFu8i_D");
    static STRUCT_IF_C aC_BFu8i_D lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu8i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_D)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_D");
    check_field_offset(lv, v3, 2, "aC_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_D, aC_BFu8i_D)
//============================================================================



static void Test_aC_BFu8i_F()
{
  {
    init_simple_test("aC_BFu8i_F");
    static STRUCT_IF_C aC_BFu8i_F lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_F)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_F");
    check_field_offset(lv, v3, 2, "aC_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_F, aC_BFu8i_F)
//============================================================================



static void Test_aC_BFu8i_I()
{
  {
    init_simple_test("aC_BFu8i_I");
    static STRUCT_IF_C aC_BFu8i_I lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_I)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_I");
    check_field_offset(lv, v3, 2, "aC_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_I, aC_BFu8i_I)
//============================================================================



static void Test_aC_BFu8i_Ip()
{
  {
    init_simple_test("aC_BFu8i_Ip");
    static STRUCT_IF_C aC_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu8i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_Ip");
    check_field_offset(lv, v3, 2, "aC_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_Ip, aC_BFu8i_Ip)
//============================================================================



static void Test_aC_BFu8i_L()
{
  {
    init_simple_test("aC_BFu8i_L");
    static STRUCT_IF_C aC_BFu8i_L lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu8i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_L)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_L");
    check_field_offset(lv, v3, 2, "aC_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_L, aC_BFu8i_L)
//============================================================================



static void Test_aC_BFu8i_S()
{
  {
    init_simple_test("aC_BFu8i_S");
    static STRUCT_IF_C aC_BFu8i_S lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_S)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_S");
    check_field_offset(lv, v3, 2, "aC_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_S, aC_BFu8i_S)
//============================================================================



static void Test_aC_BFu8i_Uc()
{
  {
    init_simple_test("aC_BFu8i_Uc");
    static STRUCT_IF_C aC_BFu8i_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_Uc");
    check_field_offset(lv, v3, 2, "aC_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_Uc, aC_BFu8i_Uc)
//============================================================================



static void Test_aC_BFu8i_Ui()
{
  {
    init_simple_test("aC_BFu8i_Ui");
    static STRUCT_IF_C aC_BFu8i_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_Ui");
    check_field_offset(lv, v3, 2, "aC_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_Ui, aC_BFu8i_Ui)
//============================================================================



static void Test_aC_BFu8i_Ul()
{
  {
    init_simple_test("aC_BFu8i_Ul");
    static STRUCT_IF_C aC_BFu8i_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu8i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_Ul");
    check_field_offset(lv, v3, 2, "aC_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_Ul, aC_BFu8i_Ul)
//============================================================================



static void Test_aC_BFu8i_Us()
{
  {
    init_simple_test("aC_BFu8i_Us");
    static STRUCT_IF_C aC_BFu8i_Us lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_Us");
    check_field_offset(lv, v3, 2, "aC_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_Us, aC_BFu8i_Us)
//============================================================================



static void Test_aC_BFu8i_Vp()
{
  {
    init_simple_test("aC_BFu8i_Vp");
    static STRUCT_IF_C aC_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu8i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "aC_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8i_Vp");
    check_field_offset(lv, v3, 2, "aC_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8i_Vp, aC_BFu8i_Vp)
//============================================================================



static void Test_aC_BFu8ll()
{
  {
    init_simple_test("aC_BFu8ll");
    static STRUCT_IF_C aC_BFu8ll lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll, aC_BFu8ll)
//============================================================================



static void Test_aC_BFu8ll_BFu15i()
{
  {
    init_simple_test("aC_BFu8ll_BFu15i");
    static STRUCT_IF_C aC_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu15i, aC_BFu8ll_BFu15i)
//============================================================================



static void Test_aC_BFu8ll_BFu15ll()
{
  {
    init_simple_test("aC_BFu8ll_BFu15ll");
    static STRUCT_IF_C aC_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu15ll, aC_BFu8ll_BFu15ll)
//============================================================================



static void Test_aC_BFu8ll_BFu15s()
{
  {
    init_simple_test("aC_BFu8ll_BFu15s");
    static STRUCT_IF_C aC_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu15s, aC_BFu8ll_BFu15s)
//============================================================================



static void Test_aC_BFu8ll_BFu16i()
{
  {
    init_simple_test("aC_BFu8ll_BFu16i");
    static STRUCT_IF_C aC_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu16i, aC_BFu8ll_BFu16i)
//============================================================================



static void Test_aC_BFu8ll_BFu16ll()
{
  {
    init_simple_test("aC_BFu8ll_BFu16ll");
    static STRUCT_IF_C aC_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu16ll, aC_BFu8ll_BFu16ll)
//============================================================================



static void Test_aC_BFu8ll_BFu16s()
{
  {
    init_simple_test("aC_BFu8ll_BFu16s");
    static STRUCT_IF_C aC_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu16s, aC_BFu8ll_BFu16s)
//============================================================================



static void Test_aC_BFu8ll_BFu17i()
{
  {
    init_simple_test("aC_BFu8ll_BFu17i");
    static STRUCT_IF_C aC_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu8ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aC_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aC_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu17i, aC_BFu8ll_BFu17i)
//============================================================================



static void Test_aC_BFu8ll_BFu17ll()
{
  {
    init_simple_test("aC_BFu8ll_BFu17ll");
    static STRUCT_IF_C aC_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aC_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aC_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu17ll, aC_BFu8ll_BFu17ll)
//============================================================================



static void Test_aC_BFu8ll_BFu1c()
{
  {
    init_simple_test("aC_BFu8ll_BFu1c");
    static STRUCT_IF_C aC_BFu8ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu1c, aC_BFu8ll_BFu1c)
//============================================================================



static void Test_aC_BFu8ll_BFu1i()
{
  {
    init_simple_test("aC_BFu8ll_BFu1i");
    static STRUCT_IF_C aC_BFu8ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu1i, aC_BFu8ll_BFu1i)
//============================================================================



static void Test_aC_BFu8ll_BFu1ll()
{
  {
    init_simple_test("aC_BFu8ll_BFu1ll");
    static STRUCT_IF_C aC_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu1ll, aC_BFu8ll_BFu1ll)
//============================================================================



static void Test_aC_BFu8ll_BFu1s()
{
  {
    init_simple_test("aC_BFu8ll_BFu1s");
    static STRUCT_IF_C aC_BFu8ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu1s, aC_BFu8ll_BFu1s)
//============================================================================



static void Test_aC_BFu8ll_BFu31i()
{
  {
    init_simple_test("aC_BFu8ll_BFu31i");
    static STRUCT_IF_C aC_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aC_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aC_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu31i, aC_BFu8ll_BFu31i)
//============================================================================



static void Test_aC_BFu8ll_BFu31ll()
{
  {
    init_simple_test("aC_BFu8ll_BFu31ll");
    static STRUCT_IF_C aC_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aC_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aC_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu31ll, aC_BFu8ll_BFu31ll)
//============================================================================



static void Test_aC_BFu8ll_BFu32i()
{
  {
    init_simple_test("aC_BFu8ll_BFu32i");
    static STRUCT_IF_C aC_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aC_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aC_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu32i, aC_BFu8ll_BFu32i)
//============================================================================



static void Test_aC_BFu8ll_BFu32ll()
{
  {
    init_simple_test("aC_BFu8ll_BFu32ll");
    static STRUCT_IF_C aC_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aC_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aC_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu32ll, aC_BFu8ll_BFu32ll)
//============================================================================



static void Test_aC_BFu8ll_BFu33()
{
  {
    init_simple_test("aC_BFu8ll_BFu33");
    static STRUCT_IF_C aC_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu8ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aC_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aC_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu33, aC_BFu8ll_BFu33)
//============================================================================



static void Test_aC_BFu8ll_BFu7c()
{
  {
    init_simple_test("aC_BFu8ll_BFu7c");
    static STRUCT_IF_C aC_BFu8ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu7c, aC_BFu8ll_BFu7c)
//============================================================================



static void Test_aC_BFu8ll_BFu7i()
{
  {
    init_simple_test("aC_BFu8ll_BFu7i");
    static STRUCT_IF_C aC_BFu8ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu7i, aC_BFu8ll_BFu7i)
//============================================================================



static void Test_aC_BFu8ll_BFu7ll()
{
  {
    init_simple_test("aC_BFu8ll_BFu7ll");
    static STRUCT_IF_C aC_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu7ll, aC_BFu8ll_BFu7ll)
//============================================================================



static void Test_aC_BFu8ll_BFu7s()
{
  {
    init_simple_test("aC_BFu8ll_BFu7s");
    static STRUCT_IF_C aC_BFu8ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu7s, aC_BFu8ll_BFu7s)
//============================================================================



static void Test_aC_BFu8ll_BFu8c()
{
  {
    init_simple_test("aC_BFu8ll_BFu8c");
    static STRUCT_IF_C aC_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu8c, aC_BFu8ll_BFu8c)
//============================================================================



static void Test_aC_BFu8ll_BFu8i()
{
  {
    init_simple_test("aC_BFu8ll_BFu8i");
    static STRUCT_IF_C aC_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu8i, aC_BFu8ll_BFu8i)
//============================================================================



static void Test_aC_BFu8ll_BFu8ll()
{
  {
    init_simple_test("aC_BFu8ll_BFu8ll");
    static STRUCT_IF_C aC_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu8ll, aC_BFu8ll_BFu8ll)
//============================================================================



static void Test_aC_BFu8ll_BFu8s()
{
  {
    init_simple_test("aC_BFu8ll_BFu8s");
    static STRUCT_IF_C aC_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu8s, aC_BFu8ll_BFu8s)
//============================================================================



static void Test_aC_BFu8ll_BFu9i()
{
  {
    init_simple_test("aC_BFu8ll_BFu9i");
    static STRUCT_IF_C aC_BFu8ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu9i, aC_BFu8ll_BFu9i)
//============================================================================



static void Test_aC_BFu8ll_BFu9ll()
{
  {
    init_simple_test("aC_BFu8ll_BFu9ll");
    static STRUCT_IF_C aC_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu9ll, aC_BFu8ll_BFu9ll)
//============================================================================



static void Test_aC_BFu8ll_BFu9s()
{
  {
    init_simple_test("aC_BFu8ll_BFu9s");
    static STRUCT_IF_C aC_BFu8ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_BFu9s, aC_BFu8ll_BFu9s)
//============================================================================



static void Test_aC_BFu8ll_C()
{
  {
    init_simple_test("aC_BFu8ll_C");
    static STRUCT_IF_C aC_BFu8ll_C lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_C");
    check_field_offset(lv, v3, 2, "aC_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_C, aC_BFu8ll_C)
//============================================================================



static void Test_aC_BFu8ll_D()
{
  {
    init_simple_test("aC_BFu8ll_D");
    static STRUCT_IF_C aC_BFu8ll_D lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu8ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_D");
    check_field_offset(lv, v3, 2, "aC_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_D, aC_BFu8ll_D)
//============================================================================



static void Test_aC_BFu8ll_F()
{
  {
    init_simple_test("aC_BFu8ll_F");
    static STRUCT_IF_C aC_BFu8ll_F lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_F");
    check_field_offset(lv, v3, 2, "aC_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_F, aC_BFu8ll_F)
//============================================================================



static void Test_aC_BFu8ll_I()
{
  {
    init_simple_test("aC_BFu8ll_I");
    static STRUCT_IF_C aC_BFu8ll_I lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_I");
    check_field_offset(lv, v3, 2, "aC_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_I, aC_BFu8ll_I)
//============================================================================



static void Test_aC_BFu8ll_Ip()
{
  {
    init_simple_test("aC_BFu8ll_Ip");
    static STRUCT_IF_C aC_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_Ip");
    check_field_offset(lv, v3, 2, "aC_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_Ip, aC_BFu8ll_Ip)
//============================================================================



static void Test_aC_BFu8ll_L()
{
  {
    init_simple_test("aC_BFu8ll_L");
    static STRUCT_IF_C aC_BFu8ll_L lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_L");
    check_field_offset(lv, v3, 2, "aC_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_L, aC_BFu8ll_L)
//============================================================================



static void Test_aC_BFu8ll_S()
{
  {
    init_simple_test("aC_BFu8ll_S");
    static STRUCT_IF_C aC_BFu8ll_S lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_S");
    check_field_offset(lv, v3, 2, "aC_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_S, aC_BFu8ll_S)
//============================================================================



static void Test_aC_BFu8ll_Uc()
{
  {
    init_simple_test("aC_BFu8ll_Uc");
    static STRUCT_IF_C aC_BFu8ll_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_Uc");
    check_field_offset(lv, v3, 2, "aC_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_Uc, aC_BFu8ll_Uc)
//============================================================================



static void Test_aC_BFu8ll_Ui()
{
  {
    init_simple_test("aC_BFu8ll_Ui");
    static STRUCT_IF_C aC_BFu8ll_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_Ui");
    check_field_offset(lv, v3, 2, "aC_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_Ui, aC_BFu8ll_Ui)
//============================================================================



static void Test_aC_BFu8ll_Ul()
{
  {
    init_simple_test("aC_BFu8ll_Ul");
    static STRUCT_IF_C aC_BFu8ll_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_Ul");
    check_field_offset(lv, v3, 2, "aC_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_Ul, aC_BFu8ll_Ul)
//============================================================================



static void Test_aC_BFu8ll_Us()
{
  {
    init_simple_test("aC_BFu8ll_Us");
    static STRUCT_IF_C aC_BFu8ll_Us lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_Us");
    check_field_offset(lv, v3, 2, "aC_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_Us, aC_BFu8ll_Us)
//============================================================================



static void Test_aC_BFu8ll_Vp()
{
  {
    init_simple_test("aC_BFu8ll_Vp");
    static STRUCT_IF_C aC_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "aC_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8ll_Vp");
    check_field_offset(lv, v3, 2, "aC_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8ll_Vp, aC_BFu8ll_Vp)
//============================================================================



static void Test_aC_BFu8s()
{
  {
    init_simple_test("aC_BFu8s");
    static STRUCT_IF_C aC_BFu8s lv;
    check2(sizeof(lv), 2, "sizeof(aC_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s, aC_BFu8s)
//============================================================================



static void Test_aC_BFu8s_BFu15i()
{
  {
    init_simple_test("aC_BFu8s_BFu15i");
    static STRUCT_IF_C aC_BFu8s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu15i, aC_BFu8s_BFu15i)
//============================================================================



static void Test_aC_BFu8s_BFu15ll()
{
  {
    init_simple_test("aC_BFu8s_BFu15ll");
    static STRUCT_IF_C aC_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu15ll, aC_BFu8s_BFu15ll)
//============================================================================



static void Test_aC_BFu8s_BFu15s()
{
  {
    init_simple_test("aC_BFu8s_BFu15s");
    static STRUCT_IF_C aC_BFu8s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu15s, aC_BFu8s_BFu15s)
//============================================================================



static void Test_aC_BFu8s_BFu16i()
{
  {
    init_simple_test("aC_BFu8s_BFu16i");
    static STRUCT_IF_C aC_BFu8s_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu16i, aC_BFu8s_BFu16i)
//============================================================================



static void Test_aC_BFu8s_BFu16ll()
{
  {
    init_simple_test("aC_BFu8s_BFu16ll");
    static STRUCT_IF_C aC_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu16ll, aC_BFu8s_BFu16ll)
//============================================================================



static void Test_aC_BFu8s_BFu16s()
{
  {
    init_simple_test("aC_BFu8s_BFu16s");
    static STRUCT_IF_C aC_BFu8s_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu16s, aC_BFu8s_BFu16s)
//============================================================================



static void Test_aC_BFu8s_BFu17i()
{
  {
    init_simple_test("aC_BFu8s_BFu17i");
    static STRUCT_IF_C aC_BFu8s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu8s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aC_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aC_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu17i, aC_BFu8s_BFu17i)
//============================================================================



static void Test_aC_BFu8s_BFu17ll()
{
  {
    init_simple_test("aC_BFu8s_BFu17ll");
    static STRUCT_IF_C aC_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu8s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aC_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aC_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu17ll, aC_BFu8s_BFu17ll)
//============================================================================



static void Test_aC_BFu8s_BFu1c()
{
  {
    init_simple_test("aC_BFu8s_BFu1c");
    static STRUCT_IF_C aC_BFu8s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu1c, aC_BFu8s_BFu1c)
//============================================================================



static void Test_aC_BFu8s_BFu1i()
{
  {
    init_simple_test("aC_BFu8s_BFu1i");
    static STRUCT_IF_C aC_BFu8s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu1i, aC_BFu8s_BFu1i)
//============================================================================



static void Test_aC_BFu8s_BFu1ll()
{
  {
    init_simple_test("aC_BFu8s_BFu1ll");
    static STRUCT_IF_C aC_BFu8s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu1ll, aC_BFu8s_BFu1ll)
//============================================================================



static void Test_aC_BFu8s_BFu1s()
{
  {
    init_simple_test("aC_BFu8s_BFu1s");
    static STRUCT_IF_C aC_BFu8s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu1s, aC_BFu8s_BFu1s)
//============================================================================



static void Test_aC_BFu8s_BFu31i()
{
  {
    init_simple_test("aC_BFu8s_BFu31i");
    static STRUCT_IF_C aC_BFu8s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aC_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aC_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu31i, aC_BFu8s_BFu31i)
//============================================================================



static void Test_aC_BFu8s_BFu31ll()
{
  {
    init_simple_test("aC_BFu8s_BFu31ll");
    static STRUCT_IF_C aC_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aC_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aC_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu31ll, aC_BFu8s_BFu31ll)
//============================================================================



static void Test_aC_BFu8s_BFu32i()
{
  {
    init_simple_test("aC_BFu8s_BFu32i");
    static STRUCT_IF_C aC_BFu8s_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aC_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aC_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu32i, aC_BFu8s_BFu32i)
//============================================================================



static void Test_aC_BFu8s_BFu32ll()
{
  {
    init_simple_test("aC_BFu8s_BFu32ll");
    static STRUCT_IF_C aC_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aC_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aC_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu32ll, aC_BFu8s_BFu32ll)
//============================================================================



static void Test_aC_BFu8s_BFu33()
{
  {
    init_simple_test("aC_BFu8s_BFu33");
    static STRUCT_IF_C aC_BFu8s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu8s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aC_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aC_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu33, aC_BFu8s_BFu33)
//============================================================================



static void Test_aC_BFu8s_BFu7c()
{
  {
    init_simple_test("aC_BFu8s_BFu7c");
    static STRUCT_IF_C aC_BFu8s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu7c, aC_BFu8s_BFu7c)
//============================================================================



static void Test_aC_BFu8s_BFu7i()
{
  {
    init_simple_test("aC_BFu8s_BFu7i");
    static STRUCT_IF_C aC_BFu8s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu7i, aC_BFu8s_BFu7i)
//============================================================================



static void Test_aC_BFu8s_BFu7ll()
{
  {
    init_simple_test("aC_BFu8s_BFu7ll");
    static STRUCT_IF_C aC_BFu8s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu7ll, aC_BFu8s_BFu7ll)
//============================================================================



static void Test_aC_BFu8s_BFu7s()
{
  {
    init_simple_test("aC_BFu8s_BFu7s");
    static STRUCT_IF_C aC_BFu8s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu7s, aC_BFu8s_BFu7s)
//============================================================================



static void Test_aC_BFu8s_BFu8c()
{
  {
    init_simple_test("aC_BFu8s_BFu8c");
    static STRUCT_IF_C aC_BFu8s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu8c, aC_BFu8s_BFu8c)
//============================================================================



static void Test_aC_BFu8s_BFu8i()
{
  {
    init_simple_test("aC_BFu8s_BFu8i");
    static STRUCT_IF_C aC_BFu8s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu8i, aC_BFu8s_BFu8i)
//============================================================================



static void Test_aC_BFu8s_BFu8ll()
{
  {
    init_simple_test("aC_BFu8s_BFu8ll");
    static STRUCT_IF_C aC_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu8ll, aC_BFu8s_BFu8ll)
//============================================================================



static void Test_aC_BFu8s_BFu8s()
{
  {
    init_simple_test("aC_BFu8s_BFu8s");
    static STRUCT_IF_C aC_BFu8s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu8s, aC_BFu8s_BFu8s)
//============================================================================



static void Test_aC_BFu8s_BFu9i()
{
  {
    init_simple_test("aC_BFu8s_BFu9i");
    static STRUCT_IF_C aC_BFu8s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu9i, aC_BFu8s_BFu9i)
//============================================================================



static void Test_aC_BFu8s_BFu9ll()
{
  {
    init_simple_test("aC_BFu8s_BFu9ll");
    static STRUCT_IF_C aC_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu9ll, aC_BFu8s_BFu9ll)
//============================================================================



static void Test_aC_BFu8s_BFu9s()
{
  {
    init_simple_test("aC_BFu8s_BFu9s");
    static STRUCT_IF_C aC_BFu8s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_BFu9s, aC_BFu8s_BFu9s)
//============================================================================



static void Test_aC_BFu8s_C()
{
  {
    init_simple_test("aC_BFu8s_C");
    static STRUCT_IF_C aC_BFu8s_C lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_C)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_C");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_C");
    check_field_offset(lv, v3, 2, "aC_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_C, aC_BFu8s_C)
//============================================================================



static void Test_aC_BFu8s_D()
{
  {
    init_simple_test("aC_BFu8s_D");
    static STRUCT_IF_C aC_BFu8s_D lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu8s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_D)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_D");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_D");
    check_field_offset(lv, v3, 2, "aC_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_D, aC_BFu8s_D)
//============================================================================



static void Test_aC_BFu8s_F()
{
  {
    init_simple_test("aC_BFu8s_F");
    static STRUCT_IF_C aC_BFu8s_F lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_F)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_F");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_F");
    check_field_offset(lv, v3, 2, "aC_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_F, aC_BFu8s_F)
//============================================================================



static void Test_aC_BFu8s_I()
{
  {
    init_simple_test("aC_BFu8s_I");
    static STRUCT_IF_C aC_BFu8s_I lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_I)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_I");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_I");
    check_field_offset(lv, v3, 2, "aC_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_I, aC_BFu8s_I)
//============================================================================



static void Test_aC_BFu8s_Ip()
{
  {
    init_simple_test("aC_BFu8s_Ip");
    static STRUCT_IF_C aC_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu8s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_Ip");
    check_field_offset(lv, v3, 2, "aC_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_Ip, aC_BFu8s_Ip)
//============================================================================



static void Test_aC_BFu8s_L()
{
  {
    init_simple_test("aC_BFu8s_L");
    static STRUCT_IF_C aC_BFu8s_L lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu8s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_L)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_L");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_L");
    check_field_offset(lv, v3, 2, "aC_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_L, aC_BFu8s_L)
//============================================================================



static void Test_aC_BFu8s_S()
{
  {
    init_simple_test("aC_BFu8s_S");
    static STRUCT_IF_C aC_BFu8s_S lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_S)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_S");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_S");
    check_field_offset(lv, v3, 2, "aC_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_S, aC_BFu8s_S)
//============================================================================



static void Test_aC_BFu8s_Uc()
{
  {
    init_simple_test("aC_BFu8s_Uc");
    static STRUCT_IF_C aC_BFu8s_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu8s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_Uc");
    check_field_offset(lv, v3, 2, "aC_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_Uc, aC_BFu8s_Uc)
//============================================================================



static void Test_aC_BFu8s_Ui()
{
  {
    init_simple_test("aC_BFu8s_Ui");
    static STRUCT_IF_C aC_BFu8s_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu8s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_Ui");
    check_field_offset(lv, v3, 2, "aC_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_Ui, aC_BFu8s_Ui)
//============================================================================



static void Test_aC_BFu8s_Ul()
{
  {
    init_simple_test("aC_BFu8s_Ul");
    static STRUCT_IF_C aC_BFu8s_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aC_BFu8s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_Ul");
    check_field_offset(lv, v3, 2, "aC_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_Ul, aC_BFu8s_Ul)
//============================================================================



static void Test_aC_BFu8s_Us()
{
  {
    init_simple_test("aC_BFu8s_Us");
    static STRUCT_IF_C aC_BFu8s_Us lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu8s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_Us");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_Us");
    check_field_offset(lv, v3, 2, "aC_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_Us, aC_BFu8s_Us)
//============================================================================



static void Test_aC_BFu8s_Vp()
{
  {
    init_simple_test("aC_BFu8s_Vp");
    static STRUCT_IF_C aC_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_BFu8s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "aC_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aC_BFu8s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_ull(1LL<<7), "aC_BFu8s_Vp");
    check_field_offset(lv, v3, 2, "aC_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu8s_Vp, aC_BFu8s_Vp)
//============================================================================



static void Test_aC_BFu9i()
{
  {
    init_simple_test("aC_BFu9i");
    static STRUCT_IF_C aC_BFu9i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i, aC_BFu9i)
//============================================================================



static void Test_aC_BFu9i_BFu15i()
{
  {
    init_simple_test("aC_BFu9i_BFu15i");
    static STRUCT_IF_C aC_BFu9i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aC_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aC_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu15i, aC_BFu9i_BFu15i)
//============================================================================



static void Test_aC_BFu9i_BFu15ll()
{
  {
    init_simple_test("aC_BFu9i_BFu15ll");
    static STRUCT_IF_C aC_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aC_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aC_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu15ll, aC_BFu9i_BFu15ll)
//============================================================================



static void Test_aC_BFu9i_BFu15s()
{
  {
    init_simple_test("aC_BFu9i_BFu15s");
    static STRUCT_IF_C aC_BFu9i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aC_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aC_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu15s, aC_BFu9i_BFu15s)
//============================================================================



static void Test_aC_BFu9i_BFu16i()
{
  {
    init_simple_test("aC_BFu9i_BFu16i");
    static STRUCT_IF_C aC_BFu9i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aC_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aC_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu16i, aC_BFu9i_BFu16i)
//============================================================================



static void Test_aC_BFu9i_BFu16ll()
{
  {
    init_simple_test("aC_BFu9i_BFu16ll");
    static STRUCT_IF_C aC_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aC_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aC_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu16ll, aC_BFu9i_BFu16ll)
//============================================================================



static void Test_aC_BFu9i_BFu16s()
{
  {
    init_simple_test("aC_BFu9i_BFu16s");
    static STRUCT_IF_C aC_BFu9i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aC_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aC_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu16s, aC_BFu9i_BFu16s)
//============================================================================



static void Test_aC_BFu9i_BFu17i()
{
  {
    init_simple_test("aC_BFu9i_BFu17i");
    static STRUCT_IF_C aC_BFu9i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aC_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aC_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu17i, aC_BFu9i_BFu17i)
//============================================================================



static void Test_aC_BFu9i_BFu17ll()
{
  {
    init_simple_test("aC_BFu9i_BFu17ll");
    static STRUCT_IF_C aC_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aC_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aC_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu17ll, aC_BFu9i_BFu17ll)
//============================================================================



static void Test_aC_BFu9i_BFu1c()
{
  {
    init_simple_test("aC_BFu9i_BFu1c");
    static STRUCT_IF_C aC_BFu9i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aC_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu1c, aC_BFu9i_BFu1c)
//============================================================================



static void Test_aC_BFu9i_BFu1i()
{
  {
    init_simple_test("aC_BFu9i_BFu1i");
    static STRUCT_IF_C aC_BFu9i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aC_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu1i, aC_BFu9i_BFu1i)
//============================================================================



static void Test_aC_BFu9i_BFu1ll()
{
  {
    init_simple_test("aC_BFu9i_BFu1ll");
    static STRUCT_IF_C aC_BFu9i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aC_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu1ll, aC_BFu9i_BFu1ll)
//============================================================================



static void Test_aC_BFu9i_BFu1s()
{
  {
    init_simple_test("aC_BFu9i_BFu1s");
    static STRUCT_IF_C aC_BFu9i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aC_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu1s, aC_BFu9i_BFu1s)
//============================================================================



static void Test_aC_BFu9i_BFu31i()
{
  {
    init_simple_test("aC_BFu9i_BFu31i");
    static STRUCT_IF_C aC_BFu9i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu9i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aC_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aC_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu31i, aC_BFu9i_BFu31i)
//============================================================================



static void Test_aC_BFu9i_BFu31ll()
{
  {
    init_simple_test("aC_BFu9i_BFu31ll");
    static STRUCT_IF_C aC_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu9i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aC_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aC_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu31ll, aC_BFu9i_BFu31ll)
//============================================================================



static void Test_aC_BFu9i_BFu32i()
{
  {
    init_simple_test("aC_BFu9i_BFu32i");
    static STRUCT_IF_C aC_BFu9i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aC_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aC_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu32i, aC_BFu9i_BFu32i)
//============================================================================



static void Test_aC_BFu9i_BFu32ll()
{
  {
    init_simple_test("aC_BFu9i_BFu32ll");
    static STRUCT_IF_C aC_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aC_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aC_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu32ll, aC_BFu9i_BFu32ll)
//============================================================================



static void Test_aC_BFu9i_BFu33()
{
  {
    init_simple_test("aC_BFu9i_BFu33");
    static STRUCT_IF_C aC_BFu9i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "aC_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "aC_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu33, aC_BFu9i_BFu33)
//============================================================================



static void Test_aC_BFu9i_BFu7c()
{
  {
    init_simple_test("aC_BFu9i_BFu7c");
    static STRUCT_IF_C aC_BFu9i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aC_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aC_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu7c, aC_BFu9i_BFu7c)
//============================================================================



static void Test_aC_BFu9i_BFu7i()
{
  {
    init_simple_test("aC_BFu9i_BFu7i");
    static STRUCT_IF_C aC_BFu9i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aC_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aC_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu7i, aC_BFu9i_BFu7i)
//============================================================================



static void Test_aC_BFu9i_BFu7ll()
{
  {
    init_simple_test("aC_BFu9i_BFu7ll");
    static STRUCT_IF_C aC_BFu9i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aC_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aC_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu7ll, aC_BFu9i_BFu7ll)
//============================================================================



static void Test_aC_BFu9i_BFu7s()
{
  {
    init_simple_test("aC_BFu9i_BFu7s");
    static STRUCT_IF_C aC_BFu9i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aC_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aC_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu7s, aC_BFu9i_BFu7s)
//============================================================================



static void Test_aC_BFu9i_BFu8c()
{
  {
    init_simple_test("aC_BFu9i_BFu8c");
    static STRUCT_IF_C aC_BFu9i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aC_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aC_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu8c, aC_BFu9i_BFu8c)
//============================================================================



static void Test_aC_BFu9i_BFu8i()
{
  {
    init_simple_test("aC_BFu9i_BFu8i");
    static STRUCT_IF_C aC_BFu9i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aC_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aC_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu8i, aC_BFu9i_BFu8i)
//============================================================================



static void Test_aC_BFu9i_BFu8ll()
{
  {
    init_simple_test("aC_BFu9i_BFu8ll");
    static STRUCT_IF_C aC_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aC_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aC_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu8ll, aC_BFu9i_BFu8ll)
//============================================================================



static void Test_aC_BFu9i_BFu8s()
{
  {
    init_simple_test("aC_BFu9i_BFu8s");
    static STRUCT_IF_C aC_BFu9i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aC_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aC_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu8s, aC_BFu9i_BFu8s)
//============================================================================



static void Test_aC_BFu9i_BFu9i()
{
  {
    init_simple_test("aC_BFu9i_BFu9i");
    static STRUCT_IF_C aC_BFu9i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aC_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu9i, aC_BFu9i_BFu9i)
//============================================================================



static void Test_aC_BFu9i_BFu9ll()
{
  {
    init_simple_test("aC_BFu9i_BFu9ll");
    static STRUCT_IF_C aC_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aC_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu9ll, aC_BFu9i_BFu9ll)
//============================================================================



static void Test_aC_BFu9i_BFu9s()
{
  {
    init_simple_test("aC_BFu9i_BFu9s");
    static STRUCT_IF_C aC_BFu9i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aC_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aC_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_BFu9s, aC_BFu9i_BFu9s)
//============================================================================



static void Test_aC_BFu9i_C()
{
  {
    init_simple_test("aC_BFu9i_C");
    static STRUCT_IF_C aC_BFu9i_C lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_C)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_C");
    check_field_offset(lv, v3, 3, "aC_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_C, aC_BFu9i_C)
//============================================================================



static void Test_aC_BFu9i_D()
{
  {
    init_simple_test("aC_BFu9i_D");
    static STRUCT_IF_C aC_BFu9i_D lv;
    check2(sizeof(lv), 11, "sizeof(aC_BFu9i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_D)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_D");
    check_field_offset(lv, v3, 3, "aC_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_D, aC_BFu9i_D)
//============================================================================



static void Test_aC_BFu9i_F()
{
  {
    init_simple_test("aC_BFu9i_F");
    static STRUCT_IF_C aC_BFu9i_F lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_F)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_F");
    check_field_offset(lv, v3, 3, "aC_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_F, aC_BFu9i_F)
//============================================================================



static void Test_aC_BFu9i_I()
{
  {
    init_simple_test("aC_BFu9i_I");
    static STRUCT_IF_C aC_BFu9i_I lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_I)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_I");
    check_field_offset(lv, v3, 3, "aC_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_I, aC_BFu9i_I)
//============================================================================



static void Test_aC_BFu9i_Ip()
{
  {
    init_simple_test("aC_BFu9i_Ip");
    static STRUCT_IF_C aC_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_BFu9i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_Ip");
    check_field_offset(lv, v3, 3, "aC_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_Ip, aC_BFu9i_Ip)
//============================================================================



static void Test_aC_BFu9i_L()
{
  {
    init_simple_test("aC_BFu9i_L");
    static STRUCT_IF_C aC_BFu9i_L lv;
    check2(sizeof(lv), 11, "sizeof(aC_BFu9i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_L)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_L");
    check_field_offset(lv, v3, 3, "aC_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_L, aC_BFu9i_L)
//============================================================================



static void Test_aC_BFu9i_S()
{
  {
    init_simple_test("aC_BFu9i_S");
    static STRUCT_IF_C aC_BFu9i_S lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_S)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_S");
    check_field_offset(lv, v3, 3, "aC_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_S, aC_BFu9i_S)
//============================================================================



static void Test_aC_BFu9i_Uc()
{
  {
    init_simple_test("aC_BFu9i_Uc");
    static STRUCT_IF_C aC_BFu9i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_Uc");
    check_field_offset(lv, v3, 3, "aC_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_Uc, aC_BFu9i_Uc)
//============================================================================



static void Test_aC_BFu9i_Ui()
{
  {
    init_simple_test("aC_BFu9i_Ui");
    static STRUCT_IF_C aC_BFu9i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_Ui");
    check_field_offset(lv, v3, 3, "aC_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_Ui, aC_BFu9i_Ui)
//============================================================================



static void Test_aC_BFu9i_Ul()
{
  {
    init_simple_test("aC_BFu9i_Ul");
    static STRUCT_IF_C aC_BFu9i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aC_BFu9i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_Ul");
    check_field_offset(lv, v3, 3, "aC_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_Ul, aC_BFu9i_Ul)
//============================================================================



static void Test_aC_BFu9i_Us()
{
  {
    init_simple_test("aC_BFu9i_Us");
    static STRUCT_IF_C aC_BFu9i_Us lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_Us");
    check_field_offset(lv, v3, 3, "aC_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_Us, aC_BFu9i_Us)
//============================================================================



static void Test_aC_BFu9i_Vp()
{
  {
    init_simple_test("aC_BFu9i_Vp");
    static STRUCT_IF_C aC_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_BFu9i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "aC_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9i_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9i_Vp");
    check_field_offset(lv, v3, 3, "aC_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9i_Vp, aC_BFu9i_Vp)
//============================================================================



static void Test_aC_BFu9ll()
{
  {
    init_simple_test("aC_BFu9ll");
    static STRUCT_IF_C aC_BFu9ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll, aC_BFu9ll)
//============================================================================



static void Test_aC_BFu9ll_BFu15i()
{
  {
    init_simple_test("aC_BFu9ll_BFu15i");
    static STRUCT_IF_C aC_BFu9ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aC_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aC_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu15i, aC_BFu9ll_BFu15i)
//============================================================================



static void Test_aC_BFu9ll_BFu15ll()
{
  {
    init_simple_test("aC_BFu9ll_BFu15ll");
    static STRUCT_IF_C aC_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aC_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aC_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu15ll, aC_BFu9ll_BFu15ll)
//============================================================================



static void Test_aC_BFu9ll_BFu15s()
{
  {
    init_simple_test("aC_BFu9ll_BFu15s");
    static STRUCT_IF_C aC_BFu9ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aC_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aC_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu15s, aC_BFu9ll_BFu15s)
//============================================================================



static void Test_aC_BFu9ll_BFu16i()
{
  {
    init_simple_test("aC_BFu9ll_BFu16i");
    static STRUCT_IF_C aC_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aC_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aC_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu16i, aC_BFu9ll_BFu16i)
//============================================================================



static void Test_aC_BFu9ll_BFu16ll()
{
  {
    init_simple_test("aC_BFu9ll_BFu16ll");
    static STRUCT_IF_C aC_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aC_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aC_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu16ll, aC_BFu9ll_BFu16ll)
//============================================================================



static void Test_aC_BFu9ll_BFu16s()
{
  {
    init_simple_test("aC_BFu9ll_BFu16s");
    static STRUCT_IF_C aC_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aC_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aC_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu16s, aC_BFu9ll_BFu16s)
//============================================================================



static void Test_aC_BFu9ll_BFu17i()
{
  {
    init_simple_test("aC_BFu9ll_BFu17i");
    static STRUCT_IF_C aC_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aC_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aC_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu17i, aC_BFu9ll_BFu17i)
//============================================================================



static void Test_aC_BFu9ll_BFu17ll()
{
  {
    init_simple_test("aC_BFu9ll_BFu17ll");
    static STRUCT_IF_C aC_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aC_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aC_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu17ll, aC_BFu9ll_BFu17ll)
//============================================================================



static void Test_aC_BFu9ll_BFu1c()
{
  {
    init_simple_test("aC_BFu9ll_BFu1c");
    static STRUCT_IF_C aC_BFu9ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aC_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu1c, aC_BFu9ll_BFu1c)
//============================================================================



static void Test_aC_BFu9ll_BFu1i()
{
  {
    init_simple_test("aC_BFu9ll_BFu1i");
    static STRUCT_IF_C aC_BFu9ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aC_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu1i, aC_BFu9ll_BFu1i)
//============================================================================



static void Test_aC_BFu9ll_BFu1ll()
{
  {
    init_simple_test("aC_BFu9ll_BFu1ll");
    static STRUCT_IF_C aC_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aC_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu1ll, aC_BFu9ll_BFu1ll)
//============================================================================



static void Test_aC_BFu9ll_BFu1s()
{
  {
    init_simple_test("aC_BFu9ll_BFu1s");
    static STRUCT_IF_C aC_BFu9ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aC_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu1s, aC_BFu9ll_BFu1s)
//============================================================================



static void Test_aC_BFu9ll_BFu31i()
{
  {
    init_simple_test("aC_BFu9ll_BFu31i");
    static STRUCT_IF_C aC_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu9ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aC_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aC_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu31i, aC_BFu9ll_BFu31i)
//============================================================================



static void Test_aC_BFu9ll_BFu31ll()
{
  {
    init_simple_test("aC_BFu9ll_BFu31ll");
    static STRUCT_IF_C aC_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aC_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aC_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu31ll, aC_BFu9ll_BFu31ll)
//============================================================================



static void Test_aC_BFu9ll_BFu32i()
{
  {
    init_simple_test("aC_BFu9ll_BFu32i");
    static STRUCT_IF_C aC_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aC_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aC_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu32i, aC_BFu9ll_BFu32i)
//============================================================================



static void Test_aC_BFu9ll_BFu32ll()
{
  {
    init_simple_test("aC_BFu9ll_BFu32ll");
    static STRUCT_IF_C aC_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aC_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aC_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu32ll, aC_BFu9ll_BFu32ll)
//============================================================================



static void Test_aC_BFu9ll_BFu33()
{
  {
    init_simple_test("aC_BFu9ll_BFu33");
    static STRUCT_IF_C aC_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "aC_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "aC_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu33, aC_BFu9ll_BFu33)
//============================================================================



static void Test_aC_BFu9ll_BFu7c()
{
  {
    init_simple_test("aC_BFu9ll_BFu7c");
    static STRUCT_IF_C aC_BFu9ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aC_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aC_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu7c, aC_BFu9ll_BFu7c)
//============================================================================



static void Test_aC_BFu9ll_BFu7i()
{
  {
    init_simple_test("aC_BFu9ll_BFu7i");
    static STRUCT_IF_C aC_BFu9ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aC_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aC_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu7i, aC_BFu9ll_BFu7i)
//============================================================================



static void Test_aC_BFu9ll_BFu7ll()
{
  {
    init_simple_test("aC_BFu9ll_BFu7ll");
    static STRUCT_IF_C aC_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aC_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aC_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu7ll, aC_BFu9ll_BFu7ll)
//============================================================================



static void Test_aC_BFu9ll_BFu7s()
{
  {
    init_simple_test("aC_BFu9ll_BFu7s");
    static STRUCT_IF_C aC_BFu9ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aC_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aC_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu7s, aC_BFu9ll_BFu7s)
//============================================================================



static void Test_aC_BFu9ll_BFu8c()
{
  {
    init_simple_test("aC_BFu9ll_BFu8c");
    static STRUCT_IF_C aC_BFu9ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aC_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aC_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu8c, aC_BFu9ll_BFu8c)
//============================================================================



static void Test_aC_BFu9ll_BFu8i()
{
  {
    init_simple_test("aC_BFu9ll_BFu8i");
    static STRUCT_IF_C aC_BFu9ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aC_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aC_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu8i, aC_BFu9ll_BFu8i)
//============================================================================



static void Test_aC_BFu9ll_BFu8ll()
{
  {
    init_simple_test("aC_BFu9ll_BFu8ll");
    static STRUCT_IF_C aC_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aC_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aC_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu8ll, aC_BFu9ll_BFu8ll)
//============================================================================



static void Test_aC_BFu9ll_BFu8s()
{
  {
    init_simple_test("aC_BFu9ll_BFu8s");
    static STRUCT_IF_C aC_BFu9ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aC_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aC_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu8s, aC_BFu9ll_BFu8s)
//============================================================================



static void Test_aC_BFu9ll_BFu9i()
{
  {
    init_simple_test("aC_BFu9ll_BFu9i");
    static STRUCT_IF_C aC_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aC_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu9i, aC_BFu9ll_BFu9i)
//============================================================================



static void Test_aC_BFu9ll_BFu9ll()
{
  {
    init_simple_test("aC_BFu9ll_BFu9ll");
    static STRUCT_IF_C aC_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aC_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu9ll, aC_BFu9ll_BFu9ll)
//============================================================================



static void Test_aC_BFu9ll_BFu9s()
{
  {
    init_simple_test("aC_BFu9ll_BFu9s");
    static STRUCT_IF_C aC_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aC_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aC_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_BFu9s, aC_BFu9ll_BFu9s)
//============================================================================



static void Test_aC_BFu9ll_C()
{
  {
    init_simple_test("aC_BFu9ll_C");
    static STRUCT_IF_C aC_BFu9ll_C lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_C");
    check_field_offset(lv, v3, 3, "aC_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_C, aC_BFu9ll_C)
//============================================================================



static void Test_aC_BFu9ll_D()
{
  {
    init_simple_test("aC_BFu9ll_D");
    static STRUCT_IF_C aC_BFu9ll_D lv;
    check2(sizeof(lv), 11, "sizeof(aC_BFu9ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_D");
    check_field_offset(lv, v3, 3, "aC_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_D, aC_BFu9ll_D)
//============================================================================



static void Test_aC_BFu9ll_F()
{
  {
    init_simple_test("aC_BFu9ll_F");
    static STRUCT_IF_C aC_BFu9ll_F lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_F");
    check_field_offset(lv, v3, 3, "aC_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_F, aC_BFu9ll_F)
//============================================================================



static void Test_aC_BFu9ll_I()
{
  {
    init_simple_test("aC_BFu9ll_I");
    static STRUCT_IF_C aC_BFu9ll_I lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_I");
    check_field_offset(lv, v3, 3, "aC_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_I, aC_BFu9ll_I)
//============================================================================



static void Test_aC_BFu9ll_Ip()
{
  {
    init_simple_test("aC_BFu9ll_Ip");
    static STRUCT_IF_C aC_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_BFu9ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_Ip");
    check_field_offset(lv, v3, 3, "aC_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_Ip, aC_BFu9ll_Ip)
//============================================================================



static void Test_aC_BFu9ll_L()
{
  {
    init_simple_test("aC_BFu9ll_L");
    static STRUCT_IF_C aC_BFu9ll_L lv;
    check2(sizeof(lv), 11, "sizeof(aC_BFu9ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_L");
    check_field_offset(lv, v3, 3, "aC_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_L, aC_BFu9ll_L)
//============================================================================



static void Test_aC_BFu9ll_S()
{
  {
    init_simple_test("aC_BFu9ll_S");
    static STRUCT_IF_C aC_BFu9ll_S lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_S");
    check_field_offset(lv, v3, 3, "aC_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_S, aC_BFu9ll_S)
//============================================================================



static void Test_aC_BFu9ll_Uc()
{
  {
    init_simple_test("aC_BFu9ll_Uc");
    static STRUCT_IF_C aC_BFu9ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_Uc");
    check_field_offset(lv, v3, 3, "aC_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_Uc, aC_BFu9ll_Uc)
//============================================================================



static void Test_aC_BFu9ll_Ui()
{
  {
    init_simple_test("aC_BFu9ll_Ui");
    static STRUCT_IF_C aC_BFu9ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_Ui");
    check_field_offset(lv, v3, 3, "aC_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_Ui, aC_BFu9ll_Ui)
//============================================================================



static void Test_aC_BFu9ll_Ul()
{
  {
    init_simple_test("aC_BFu9ll_Ul");
    static STRUCT_IF_C aC_BFu9ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aC_BFu9ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_Ul");
    check_field_offset(lv, v3, 3, "aC_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_Ul, aC_BFu9ll_Ul)
//============================================================================



static void Test_aC_BFu9ll_Us()
{
  {
    init_simple_test("aC_BFu9ll_Us");
    static STRUCT_IF_C aC_BFu9ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_Us");
    check_field_offset(lv, v3, 3, "aC_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_Us, aC_BFu9ll_Us)
//============================================================================



static void Test_aC_BFu9ll_Vp()
{
  {
    init_simple_test("aC_BFu9ll_Vp");
    static STRUCT_IF_C aC_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_BFu9ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "aC_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9ll_Vp");
    check_field_offset(lv, v3, 3, "aC_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9ll_Vp, aC_BFu9ll_Vp)
//============================================================================



static void Test_aC_BFu9s()
{
  {
    init_simple_test("aC_BFu9s");
    static STRUCT_IF_C aC_BFu9s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s, aC_BFu9s)
//============================================================================



static void Test_aC_BFu9s_BFu15i()
{
  {
    init_simple_test("aC_BFu9s_BFu15i");
    static STRUCT_IF_C aC_BFu9s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aC_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aC_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu15i, aC_BFu9s_BFu15i)
//============================================================================



static void Test_aC_BFu9s_BFu15ll()
{
  {
    init_simple_test("aC_BFu9s_BFu15ll");
    static STRUCT_IF_C aC_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aC_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aC_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu15ll, aC_BFu9s_BFu15ll)
//============================================================================



static void Test_aC_BFu9s_BFu15s()
{
  {
    init_simple_test("aC_BFu9s_BFu15s");
    static STRUCT_IF_C aC_BFu9s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aC_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aC_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu15s, aC_BFu9s_BFu15s)
//============================================================================



static void Test_aC_BFu9s_BFu16i()
{
  {
    init_simple_test("aC_BFu9s_BFu16i");
    static STRUCT_IF_C aC_BFu9s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aC_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aC_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu16i, aC_BFu9s_BFu16i)
//============================================================================



static void Test_aC_BFu9s_BFu16ll()
{
  {
    init_simple_test("aC_BFu9s_BFu16ll");
    static STRUCT_IF_C aC_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aC_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aC_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu16ll, aC_BFu9s_BFu16ll)
//============================================================================



static void Test_aC_BFu9s_BFu16s()
{
  {
    init_simple_test("aC_BFu9s_BFu16s");
    static STRUCT_IF_C aC_BFu9s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aC_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aC_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu16s, aC_BFu9s_BFu16s)
//============================================================================



static void Test_aC_BFu9s_BFu17i()
{
  {
    init_simple_test("aC_BFu9s_BFu17i");
    static STRUCT_IF_C aC_BFu9s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aC_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aC_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu17i, aC_BFu9s_BFu17i)
//============================================================================



static void Test_aC_BFu9s_BFu17ll()
{
  {
    init_simple_test("aC_BFu9s_BFu17ll");
    static STRUCT_IF_C aC_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aC_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aC_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu17ll, aC_BFu9s_BFu17ll)
//============================================================================



static void Test_aC_BFu9s_BFu1c()
{
  {
    init_simple_test("aC_BFu9s_BFu1c");
    static STRUCT_IF_C aC_BFu9s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aC_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu1c, aC_BFu9s_BFu1c)
//============================================================================



static void Test_aC_BFu9s_BFu1i()
{
  {
    init_simple_test("aC_BFu9s_BFu1i");
    static STRUCT_IF_C aC_BFu9s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aC_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu1i, aC_BFu9s_BFu1i)
//============================================================================



static void Test_aC_BFu9s_BFu1ll()
{
  {
    init_simple_test("aC_BFu9s_BFu1ll");
    static STRUCT_IF_C aC_BFu9s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aC_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu1ll, aC_BFu9s_BFu1ll)
//============================================================================



static void Test_aC_BFu9s_BFu1s()
{
  {
    init_simple_test("aC_BFu9s_BFu1s");
    static STRUCT_IF_C aC_BFu9s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aC_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu1s, aC_BFu9s_BFu1s)
//============================================================================



static void Test_aC_BFu9s_BFu31i()
{
  {
    init_simple_test("aC_BFu9s_BFu31i");
    static STRUCT_IF_C aC_BFu9s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu9s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aC_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aC_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu31i, aC_BFu9s_BFu31i)
//============================================================================



static void Test_aC_BFu9s_BFu31ll()
{
  {
    init_simple_test("aC_BFu9s_BFu31ll");
    static STRUCT_IF_C aC_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_BFu9s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aC_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aC_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu31ll, aC_BFu9s_BFu31ll)
//============================================================================



static void Test_aC_BFu9s_BFu32i()
{
  {
    init_simple_test("aC_BFu9s_BFu32i");
    static STRUCT_IF_C aC_BFu9s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aC_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aC_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu32i, aC_BFu9s_BFu32i)
//============================================================================



static void Test_aC_BFu9s_BFu32ll()
{
  {
    init_simple_test("aC_BFu9s_BFu32ll");
    static STRUCT_IF_C aC_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aC_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aC_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu32ll, aC_BFu9s_BFu32ll)
//============================================================================



static void Test_aC_BFu9s_BFu33()
{
  {
    init_simple_test("aC_BFu9s_BFu33");
    static STRUCT_IF_C aC_BFu9s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "aC_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "aC_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu33, aC_BFu9s_BFu33)
//============================================================================



static void Test_aC_BFu9s_BFu7c()
{
  {
    init_simple_test("aC_BFu9s_BFu7c");
    static STRUCT_IF_C aC_BFu9s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aC_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aC_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu7c, aC_BFu9s_BFu7c)
//============================================================================



static void Test_aC_BFu9s_BFu7i()
{
  {
    init_simple_test("aC_BFu9s_BFu7i");
    static STRUCT_IF_C aC_BFu9s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aC_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aC_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu7i, aC_BFu9s_BFu7i)
//============================================================================



static void Test_aC_BFu9s_BFu7ll()
{
  {
    init_simple_test("aC_BFu9s_BFu7ll");
    static STRUCT_IF_C aC_BFu9s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aC_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aC_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu7ll, aC_BFu9s_BFu7ll)
//============================================================================



static void Test_aC_BFu9s_BFu7s()
{
  {
    init_simple_test("aC_BFu9s_BFu7s");
    static STRUCT_IF_C aC_BFu9s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aC_BFu9s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu7s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aC_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aC_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu7s, aC_BFu9s_BFu7s)
//============================================================================



static void Test_aC_BFu9s_BFu8c()
{
  {
    init_simple_test("aC_BFu9s_BFu8c");
    static STRUCT_IF_C aC_BFu9s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu8c.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aC_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aC_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu8c, aC_BFu9s_BFu8c)
//============================================================================



static void Test_aC_BFu9s_BFu8i()
{
  {
    init_simple_test("aC_BFu9s_BFu8i");
    static STRUCT_IF_C aC_BFu9s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu8i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aC_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aC_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu8i, aC_BFu9s_BFu8i)
//============================================================================



static void Test_aC_BFu9s_BFu8ll()
{
  {
    init_simple_test("aC_BFu9s_BFu8ll");
    static STRUCT_IF_C aC_BFu9s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aC_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aC_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu8ll, aC_BFu9s_BFu8ll)
//============================================================================



static void Test_aC_BFu9s_BFu8s()
{
  {
    init_simple_test("aC_BFu9s_BFu8s");
    static STRUCT_IF_C aC_BFu9s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu8s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aC_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aC_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu8s, aC_BFu9s_BFu8s)
//============================================================================



static void Test_aC_BFu9s_BFu9i()
{
  {
    init_simple_test("aC_BFu9s_BFu9i");
    static STRUCT_IF_C aC_BFu9s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu9i.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aC_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu9i, aC_BFu9s_BFu9i)
//============================================================================



static void Test_aC_BFu9s_BFu9ll()
{
  {
    init_simple_test("aC_BFu9s_BFu9ll");
    static STRUCT_IF_C aC_BFu9s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aC_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu9ll, aC_BFu9s_BFu9ll)
//============================================================================



static void Test_aC_BFu9s_BFu9s()
{
  {
    init_simple_test("aC_BFu9s_BFu9s");
    static STRUCT_IF_C aC_BFu9s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_BFu9s.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aC_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aC_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_BFu9s, aC_BFu9s_BFu9s)
//============================================================================



static void Test_aC_BFu9s_C()
{
  {
    init_simple_test("aC_BFu9s_C");
    static STRUCT_IF_C aC_BFu9s_C lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_C)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_C.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_C");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_C");
    check_field_offset(lv, v3, 3, "aC_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_C, aC_BFu9s_C)
//============================================================================



static void Test_aC_BFu9s_D()
{
  {
    init_simple_test("aC_BFu9s_D");
    static STRUCT_IF_C aC_BFu9s_D lv;
    check2(sizeof(lv), 11, "sizeof(aC_BFu9s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_D)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_D.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_D");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_D");
    check_field_offset(lv, v3, 3, "aC_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_D, aC_BFu9s_D)
//============================================================================



static void Test_aC_BFu9s_F()
{
  {
    init_simple_test("aC_BFu9s_F");
    static STRUCT_IF_C aC_BFu9s_F lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_F)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_F.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_F");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_F");
    check_field_offset(lv, v3, 3, "aC_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_F, aC_BFu9s_F)
//============================================================================



static void Test_aC_BFu9s_I()
{
  {
    init_simple_test("aC_BFu9s_I");
    static STRUCT_IF_C aC_BFu9s_I lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_I)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_I.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_I");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_I");
    check_field_offset(lv, v3, 3, "aC_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_I, aC_BFu9s_I)
//============================================================================



static void Test_aC_BFu9s_Ip()
{
  {
    init_simple_test("aC_BFu9s_Ip");
    static STRUCT_IF_C aC_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_BFu9s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_Ip)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_Ip.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_Ip");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_Ip");
    check_field_offset(lv, v3, 3, "aC_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_Ip, aC_BFu9s_Ip)
//============================================================================



static void Test_aC_BFu9s_L()
{
  {
    init_simple_test("aC_BFu9s_L");
    static STRUCT_IF_C aC_BFu9s_L lv;
    check2(sizeof(lv), 11, "sizeof(aC_BFu9s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_L)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_L.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_L");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_L");
    check_field_offset(lv, v3, 3, "aC_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_L, aC_BFu9s_L)
//============================================================================



static void Test_aC_BFu9s_S()
{
  {
    init_simple_test("aC_BFu9s_S");
    static STRUCT_IF_C aC_BFu9s_S lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_S)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_S.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_S");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_S");
    check_field_offset(lv, v3, 3, "aC_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_S, aC_BFu9s_S)
//============================================================================



static void Test_aC_BFu9s_Uc()
{
  {
    init_simple_test("aC_BFu9s_Uc");
    static STRUCT_IF_C aC_BFu9s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aC_BFu9s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_Uc)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_Uc.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_Uc");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_Uc");
    check_field_offset(lv, v3, 3, "aC_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_Uc, aC_BFu9s_Uc)
//============================================================================



static void Test_aC_BFu9s_Ui()
{
  {
    init_simple_test("aC_BFu9s_Ui");
    static STRUCT_IF_C aC_BFu9s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aC_BFu9s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_Ui)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_Ui.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_Ui");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_Ui");
    check_field_offset(lv, v3, 3, "aC_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_Ui, aC_BFu9s_Ui)
//============================================================================



static void Test_aC_BFu9s_Ul()
{
  {
    init_simple_test("aC_BFu9s_Ul");
    static STRUCT_IF_C aC_BFu9s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aC_BFu9s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_Ul)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_Ul.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_Ul");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_Ul");
    check_field_offset(lv, v3, 3, "aC_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_Ul, aC_BFu9s_Ul)
//============================================================================



static void Test_aC_BFu9s_Us()
{
  {
    init_simple_test("aC_BFu9s_Us");
    static STRUCT_IF_C aC_BFu9s_Us lv;
    check2(sizeof(lv), 5, "sizeof(aC_BFu9s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_Us)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_Us.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_Us");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_Us");
    check_field_offset(lv, v3, 3, "aC_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_Us, aC_BFu9s_Us)
//============================================================================



static void Test_aC_BFu9s_Vp()
{
  {
    init_simple_test("aC_BFu9s_Vp");
    static STRUCT_IF_C aC_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_BFu9s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_BFu9s_Vp)");
    check_field_offset(lv, v1, 0, "aC_BFu9s_Vp.v1");
    set_bf_and_test(lv, v2, 1, 0, 9, 1, "aC_BFu9s_Vp");
    set_bf_and_test(lv, v2, 1, 0, 9, hide_ull(1LL<<8), "aC_BFu9s_Vp");
    check_field_offset(lv, v3, 3, "aC_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_BFu9s_Vp, aC_BFu9s_Vp)
//============================================================================



static void Test_aC_C()
{
  {
    init_simple_test("aC_C");
    STRUCT_IF_C aC_C lv;
    check2(sizeof(lv), 2, "sizeof(aC_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C)");
    check_field_offset(lv, v1, 0, "aC_C.v1");
    check_field_offset(lv, v2, 1, "aC_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C, aC_C)
//============================================================================



static void Test_aC_C_BFu15i()
{
  {
    init_simple_test("aC_C_BFu15i");
    static STRUCT_IF_C aC_C_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aC_C_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_C_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_C_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu15i, aC_C_BFu15i)
//============================================================================



static void Test_aC_C_BFu15ll()
{
  {
    init_simple_test("aC_C_BFu15ll");
    static STRUCT_IF_C aC_C_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_C_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_C_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_C_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu15ll, aC_C_BFu15ll)
//============================================================================



static void Test_aC_C_BFu15s()
{
  {
    init_simple_test("aC_C_BFu15s");
    static STRUCT_IF_C aC_C_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aC_C_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_C_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_C_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu15s, aC_C_BFu15s)
//============================================================================



static void Test_aC_C_BFu16i()
{
  {
    init_simple_test("aC_C_BFu16i");
    static STRUCT_IF_C aC_C_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aC_C_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_C_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_C_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu16i, aC_C_BFu16i)
//============================================================================



static void Test_aC_C_BFu16ll()
{
  {
    init_simple_test("aC_C_BFu16ll");
    static STRUCT_IF_C aC_C_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_C_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_C_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_C_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu16ll, aC_C_BFu16ll)
//============================================================================



static void Test_aC_C_BFu16s()
{
  {
    init_simple_test("aC_C_BFu16s");
    static STRUCT_IF_C aC_C_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aC_C_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_C_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_C_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu16s, aC_C_BFu16s)
//============================================================================



static void Test_aC_C_BFu17i()
{
  {
    init_simple_test("aC_C_BFu17i");
    static STRUCT_IF_C aC_C_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aC_C_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_C_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aC_C_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aC_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu17i, aC_C_BFu17i)
//============================================================================



static void Test_aC_C_BFu17ll()
{
  {
    init_simple_test("aC_C_BFu17ll");
    static STRUCT_IF_C aC_C_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_C_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_C_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aC_C_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aC_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu17ll, aC_C_BFu17ll)
//============================================================================



static void Test_aC_C_BFu1c()
{
  {
    init_simple_test("aC_C_BFu1c");
    static STRUCT_IF_C aC_C_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_C_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu1c, aC_C_BFu1c)
//============================================================================



static void Test_aC_C_BFu1i()
{
  {
    init_simple_test("aC_C_BFu1i");
    static STRUCT_IF_C aC_C_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_C_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu1i, aC_C_BFu1i)
//============================================================================



static void Test_aC_C_BFu1ll()
{
  {
    init_simple_test("aC_C_BFu1ll");
    static STRUCT_IF_C aC_C_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_C_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu1ll, aC_C_BFu1ll)
//============================================================================



static void Test_aC_C_BFu1s()
{
  {
    init_simple_test("aC_C_BFu1s");
    static STRUCT_IF_C aC_C_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_C_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu1s, aC_C_BFu1s)
//============================================================================



static void Test_aC_C_BFu31i()
{
  {
    init_simple_test("aC_C_BFu31i");
    static STRUCT_IF_C aC_C_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aC_C_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_C_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aC_C_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aC_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu31i, aC_C_BFu31i)
//============================================================================



static void Test_aC_C_BFu31ll()
{
  {
    init_simple_test("aC_C_BFu31ll");
    static STRUCT_IF_C aC_C_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_C_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_C_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aC_C_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aC_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu31ll, aC_C_BFu31ll)
//============================================================================



static void Test_aC_C_BFu32i()
{
  {
    init_simple_test("aC_C_BFu32i");
    static STRUCT_IF_C aC_C_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aC_C_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_C_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aC_C_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aC_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu32i, aC_C_BFu32i)
//============================================================================



static void Test_aC_C_BFu32ll()
{
  {
    init_simple_test("aC_C_BFu32ll");
    static STRUCT_IF_C aC_C_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_C_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_C_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aC_C_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aC_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu32ll, aC_C_BFu32ll)
//============================================================================



static void Test_aC_C_BFu33()
{
  {
    init_simple_test("aC_C_BFu33");
    static STRUCT_IF_C aC_C_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aC_C_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu33)");
    check_field_offset(lv, v1, 0, "aC_C_BFu33.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aC_C_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aC_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu33, aC_C_BFu33)
//============================================================================



static void Test_aC_C_BFu7c()
{
  {
    init_simple_test("aC_C_BFu7c");
    static STRUCT_IF_C aC_C_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_C_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_C_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu7c, aC_C_BFu7c)
//============================================================================



static void Test_aC_C_BFu7i()
{
  {
    init_simple_test("aC_C_BFu7i");
    static STRUCT_IF_C aC_C_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_C_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_C_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu7i, aC_C_BFu7i)
//============================================================================



static void Test_aC_C_BFu7ll()
{
  {
    init_simple_test("aC_C_BFu7ll");
    static STRUCT_IF_C aC_C_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_C_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_C_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu7ll, aC_C_BFu7ll)
//============================================================================



static void Test_aC_C_BFu7s()
{
  {
    init_simple_test("aC_C_BFu7s");
    static STRUCT_IF_C aC_C_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_C_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_C_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu7s, aC_C_BFu7s)
//============================================================================



static void Test_aC_C_BFu8c()
{
  {
    init_simple_test("aC_C_BFu8c");
    static STRUCT_IF_C aC_C_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_C_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_C_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu8c, aC_C_BFu8c)
//============================================================================



static void Test_aC_C_BFu8i()
{
  {
    init_simple_test("aC_C_BFu8i");
    static STRUCT_IF_C aC_C_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_C_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_C_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu8i, aC_C_BFu8i)
//============================================================================



static void Test_aC_C_BFu8ll()
{
  {
    init_simple_test("aC_C_BFu8ll");
    static STRUCT_IF_C aC_C_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_C_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_C_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu8ll, aC_C_BFu8ll)
//============================================================================



static void Test_aC_C_BFu8s()
{
  {
    init_simple_test("aC_C_BFu8s");
    static STRUCT_IF_C aC_C_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_C_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_C_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu8s, aC_C_BFu8s)
//============================================================================



static void Test_aC_C_BFu9i()
{
  {
    init_simple_test("aC_C_BFu9i");
    static STRUCT_IF_C aC_C_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aC_C_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_C_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_C_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu9i, aC_C_BFu9i)
//============================================================================



static void Test_aC_C_BFu9ll()
{
  {
    init_simple_test("aC_C_BFu9ll");
    static STRUCT_IF_C aC_C_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_C_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_C_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_C_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu9ll, aC_C_BFu9ll)
//============================================================================



static void Test_aC_C_BFu9s()
{
  {
    init_simple_test("aC_C_BFu9s");
    static STRUCT_IF_C aC_C_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aC_C_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_C_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aC_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_C_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_BFu9s, aC_C_BFu9s)
//============================================================================



static void Test_aC_C_C()
{
  {
    init_simple_test("aC_C_C");
    STRUCT_IF_C aC_C_C lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_C)");
    check_field_offset(lv, v1, 0, "aC_C_C.v1");
    check_field_offset(lv, v2, 1, "aC_C_C.v2");
    check_field_offset(lv, v3, 2, "aC_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_C, aC_C_C)
//============================================================================



static void Test_aC_C_D()
{
  {
    init_simple_test("aC_C_D");
    STRUCT_IF_C aC_C_D lv;
    check2(sizeof(lv), 10, "sizeof(aC_C_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_D)");
    check_field_offset(lv, v1, 0, "aC_C_D.v1");
    check_field_offset(lv, v2, 1, "aC_C_D.v2");
    check_field_offset(lv, v3, 2, "aC_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_D, aC_C_D)
//============================================================================



static void Test_aC_C_F()
{
  {
    init_simple_test("aC_C_F");
    STRUCT_IF_C aC_C_F lv;
    check2(sizeof(lv), 6, "sizeof(aC_C_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_F)");
    check_field_offset(lv, v1, 0, "aC_C_F.v1");
    check_field_offset(lv, v2, 1, "aC_C_F.v2");
    check_field_offset(lv, v3, 2, "aC_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_F, aC_C_F)
//============================================================================



static void Test_aC_C_I()
{
  {
    init_simple_test("aC_C_I");
    STRUCT_IF_C aC_C_I lv;
    check2(sizeof(lv), 6, "sizeof(aC_C_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_I)");
    check_field_offset(lv, v1, 0, "aC_C_I.v1");
    check_field_offset(lv, v2, 1, "aC_C_I.v2");
    check_field_offset(lv, v3, 2, "aC_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_I, aC_C_I)
//============================================================================



static void Test_aC_C_Ip()
{
  {
    init_simple_test("aC_C_Ip");
    STRUCT_IF_C aC_C_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_C_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_Ip)");
    check_field_offset(lv, v1, 0, "aC_C_Ip.v1");
    check_field_offset(lv, v2, 1, "aC_C_Ip.v2");
    check_field_offset(lv, v3, 2, "aC_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_Ip, aC_C_Ip)
//============================================================================



static void Test_aC_C_L()
{
  {
    init_simple_test("aC_C_L");
    STRUCT_IF_C aC_C_L lv;
    check2(sizeof(lv), 10, "sizeof(aC_C_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_L)");
    check_field_offset(lv, v1, 0, "aC_C_L.v1");
    check_field_offset(lv, v2, 1, "aC_C_L.v2");
    check_field_offset(lv, v3, 2, "aC_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_L, aC_C_L)
//============================================================================



static void Test_aC_C_S()
{
  {
    init_simple_test("aC_C_S");
    STRUCT_IF_C aC_C_S lv;
    check2(sizeof(lv), 4, "sizeof(aC_C_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_S)");
    check_field_offset(lv, v1, 0, "aC_C_S.v1");
    check_field_offset(lv, v2, 1, "aC_C_S.v2");
    check_field_offset(lv, v3, 2, "aC_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_S, aC_C_S)
//============================================================================



static void Test_aC_C_Uc()
{
  {
    init_simple_test("aC_C_Uc");
    STRUCT_IF_C aC_C_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aC_C_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_Uc)");
    check_field_offset(lv, v1, 0, "aC_C_Uc.v1");
    check_field_offset(lv, v2, 1, "aC_C_Uc.v2");
    check_field_offset(lv, v3, 2, "aC_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_Uc, aC_C_Uc)
//============================================================================



static void Test_aC_C_Ui()
{
  {
    init_simple_test("aC_C_Ui");
    STRUCT_IF_C aC_C_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aC_C_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_Ui)");
    check_field_offset(lv, v1, 0, "aC_C_Ui.v1");
    check_field_offset(lv, v2, 1, "aC_C_Ui.v2");
    check_field_offset(lv, v3, 2, "aC_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_Ui, aC_C_Ui)
//============================================================================



static void Test_aC_C_Ul()
{
  {
    init_simple_test("aC_C_Ul");
    STRUCT_IF_C aC_C_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aC_C_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_Ul)");
    check_field_offset(lv, v1, 0, "aC_C_Ul.v1");
    check_field_offset(lv, v2, 1, "aC_C_Ul.v2");
    check_field_offset(lv, v3, 2, "aC_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_Ul, aC_C_Ul)
//============================================================================



static void Test_aC_C_Us()
{
  {
    init_simple_test("aC_C_Us");
    STRUCT_IF_C aC_C_Us lv;
    check2(sizeof(lv), 4, "sizeof(aC_C_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_Us)");
    check_field_offset(lv, v1, 0, "aC_C_Us.v1");
    check_field_offset(lv, v2, 1, "aC_C_Us.v2");
    check_field_offset(lv, v3, 2, "aC_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_Us, aC_C_Us)
//============================================================================



static void Test_aC_C_Vp()
{
  {
    init_simple_test("aC_C_Vp");
    STRUCT_IF_C aC_C_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_C_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_C_Vp)");
    check_field_offset(lv, v1, 0, "aC_C_Vp.v1");
    check_field_offset(lv, v2, 1, "aC_C_Vp.v2");
    check_field_offset(lv, v3, 2, "aC_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_C_Vp, aC_C_Vp)
//============================================================================



static void Test_aC_D()
{
  {
    init_simple_test("aC_D");
    STRUCT_IF_C aC_D lv;
    check2(sizeof(lv), 9, "sizeof(aC_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D)");
    check_field_offset(lv, v1, 0, "aC_D.v1");
    check_field_offset(lv, v2, 1, "aC_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D, aC_D)
//============================================================================



static void Test_aC_D_BFu15i()
{
  {
    init_simple_test("aC_D_BFu15i");
    static STRUCT_IF_C aC_D_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aC_D_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_D_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aC_D_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aC_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu15i, aC_D_BFu15i)
//============================================================================



static void Test_aC_D_BFu15ll()
{
  {
    init_simple_test("aC_D_BFu15ll");
    static STRUCT_IF_C aC_D_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aC_D_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_D_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aC_D_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aC_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu15ll, aC_D_BFu15ll)
//============================================================================



static void Test_aC_D_BFu15s()
{
  {
    init_simple_test("aC_D_BFu15s");
    static STRUCT_IF_C aC_D_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aC_D_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_D_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aC_D_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aC_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu15s, aC_D_BFu15s)
//============================================================================



static void Test_aC_D_BFu16i()
{
  {
    init_simple_test("aC_D_BFu16i");
    static STRUCT_IF_C aC_D_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(aC_D_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_D_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aC_D_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aC_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu16i, aC_D_BFu16i)
//============================================================================



static void Test_aC_D_BFu16ll()
{
  {
    init_simple_test("aC_D_BFu16ll");
    static STRUCT_IF_C aC_D_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(aC_D_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_D_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aC_D_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aC_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu16ll, aC_D_BFu16ll)
//============================================================================



static void Test_aC_D_BFu16s()
{
  {
    init_simple_test("aC_D_BFu16s");
    static STRUCT_IF_C aC_D_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(aC_D_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_D_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aC_D_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aC_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu16s, aC_D_BFu16s)
//============================================================================



static void Test_aC_D_BFu17i()
{
  {
    init_simple_test("aC_D_BFu17i");
    static STRUCT_IF_C aC_D_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aC_D_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_D_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aC_D_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aC_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu17i, aC_D_BFu17i)
//============================================================================



static void Test_aC_D_BFu17ll()
{
  {
    init_simple_test("aC_D_BFu17ll");
    static STRUCT_IF_C aC_D_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aC_D_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_D_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aC_D_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aC_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu17ll, aC_D_BFu17ll)
//============================================================================



static void Test_aC_D_BFu1c()
{
  {
    init_simple_test("aC_D_BFu1c");
    static STRUCT_IF_C aC_D_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_D_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aC_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu1c, aC_D_BFu1c)
//============================================================================



static void Test_aC_D_BFu1i()
{
  {
    init_simple_test("aC_D_BFu1i");
    static STRUCT_IF_C aC_D_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_D_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aC_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu1i, aC_D_BFu1i)
//============================================================================



static void Test_aC_D_BFu1ll()
{
  {
    init_simple_test("aC_D_BFu1ll");
    static STRUCT_IF_C aC_D_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_D_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aC_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu1ll, aC_D_BFu1ll)
//============================================================================



static void Test_aC_D_BFu1s()
{
  {
    init_simple_test("aC_D_BFu1s");
    static STRUCT_IF_C aC_D_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_D_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aC_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu1s, aC_D_BFu1s)
//============================================================================



static void Test_aC_D_BFu31i()
{
  {
    init_simple_test("aC_D_BFu31i");
    static STRUCT_IF_C aC_D_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aC_D_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_D_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aC_D_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aC_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu31i, aC_D_BFu31i)
//============================================================================



static void Test_aC_D_BFu31ll()
{
  {
    init_simple_test("aC_D_BFu31ll");
    static STRUCT_IF_C aC_D_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aC_D_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_D_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aC_D_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aC_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu31ll, aC_D_BFu31ll)
//============================================================================



static void Test_aC_D_BFu32i()
{
  {
    init_simple_test("aC_D_BFu32i");
    static STRUCT_IF_C aC_D_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aC_D_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_D_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aC_D_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aC_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu32i, aC_D_BFu32i)
//============================================================================



static void Test_aC_D_BFu32ll()
{
  {
    init_simple_test("aC_D_BFu32ll");
    static STRUCT_IF_C aC_D_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aC_D_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_D_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aC_D_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aC_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu32ll, aC_D_BFu32ll)
//============================================================================



static void Test_aC_D_BFu33()
{
  {
    init_simple_test("aC_D_BFu33");
    static STRUCT_IF_C aC_D_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aC_D_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu33)");
    check_field_offset(lv, v1, 0, "aC_D_BFu33.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aC_D_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aC_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu33, aC_D_BFu33)
//============================================================================



static void Test_aC_D_BFu7c()
{
  {
    init_simple_test("aC_D_BFu7c");
    static STRUCT_IF_C aC_D_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_D_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aC_D_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aC_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu7c, aC_D_BFu7c)
//============================================================================



static void Test_aC_D_BFu7i()
{
  {
    init_simple_test("aC_D_BFu7i");
    static STRUCT_IF_C aC_D_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_D_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aC_D_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aC_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu7i, aC_D_BFu7i)
//============================================================================



static void Test_aC_D_BFu7ll()
{
  {
    init_simple_test("aC_D_BFu7ll");
    static STRUCT_IF_C aC_D_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_D_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aC_D_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aC_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu7ll, aC_D_BFu7ll)
//============================================================================



static void Test_aC_D_BFu7s()
{
  {
    init_simple_test("aC_D_BFu7s");
    static STRUCT_IF_C aC_D_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_D_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aC_D_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aC_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu7s, aC_D_BFu7s)
//============================================================================



static void Test_aC_D_BFu8c()
{
  {
    init_simple_test("aC_D_BFu8c");
    static STRUCT_IF_C aC_D_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_D_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aC_D_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aC_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu8c, aC_D_BFu8c)
//============================================================================



static void Test_aC_D_BFu8i()
{
  {
    init_simple_test("aC_D_BFu8i");
    static STRUCT_IF_C aC_D_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_D_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aC_D_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aC_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu8i, aC_D_BFu8i)
//============================================================================



static void Test_aC_D_BFu8ll()
{
  {
    init_simple_test("aC_D_BFu8ll");
    static STRUCT_IF_C aC_D_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_D_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aC_D_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aC_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu8ll, aC_D_BFu8ll)
//============================================================================



static void Test_aC_D_BFu8s()
{
  {
    init_simple_test("aC_D_BFu8s");
    static STRUCT_IF_C aC_D_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_D_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aC_D_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aC_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu8s, aC_D_BFu8s)
//============================================================================



static void Test_aC_D_BFu9i()
{
  {
    init_simple_test("aC_D_BFu9i");
    static STRUCT_IF_C aC_D_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aC_D_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_D_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aC_D_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aC_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu9i, aC_D_BFu9i)
//============================================================================



static void Test_aC_D_BFu9ll()
{
  {
    init_simple_test("aC_D_BFu9ll");
    static STRUCT_IF_C aC_D_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aC_D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_D_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aC_D_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aC_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu9ll, aC_D_BFu9ll)
//============================================================================



static void Test_aC_D_BFu9s()
{
  {
    init_simple_test("aC_D_BFu9s");
    static STRUCT_IF_C aC_D_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aC_D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_D_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aC_D_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aC_D_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aC_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_BFu9s, aC_D_BFu9s)
//============================================================================



static void Test_aC_D_C()
{
  {
    init_simple_test("aC_D_C");
    STRUCT_IF_C aC_D_C lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_C)");
    check_field_offset(lv, v1, 0, "aC_D_C.v1");
    check_field_offset(lv, v2, 1, "aC_D_C.v2");
    check_field_offset(lv, v3, 9, "aC_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_C, aC_D_C)
//============================================================================



static void Test_aC_D_D()
{
  {
    init_simple_test("aC_D_D");
    STRUCT_IF_C aC_D_D lv;
    check2(sizeof(lv), 17, "sizeof(aC_D_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_D)");
    check_field_offset(lv, v1, 0, "aC_D_D.v1");
    check_field_offset(lv, v2, 1, "aC_D_D.v2");
    check_field_offset(lv, v3, 9, "aC_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_D, aC_D_D)
//============================================================================



static void Test_aC_D_F()
{
  {
    init_simple_test("aC_D_F");
    STRUCT_IF_C aC_D_F lv;
    check2(sizeof(lv), 13, "sizeof(aC_D_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_F)");
    check_field_offset(lv, v1, 0, "aC_D_F.v1");
    check_field_offset(lv, v2, 1, "aC_D_F.v2");
    check_field_offset(lv, v3, 9, "aC_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_F, aC_D_F)
//============================================================================



static void Test_aC_D_I()
{
  {
    init_simple_test("aC_D_I");
    STRUCT_IF_C aC_D_I lv;
    check2(sizeof(lv), 13, "sizeof(aC_D_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_I)");
    check_field_offset(lv, v1, 0, "aC_D_I.v1");
    check_field_offset(lv, v2, 1, "aC_D_I.v2");
    check_field_offset(lv, v3, 9, "aC_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_I, aC_D_I)
//============================================================================



static void Test_aC_D_Ip()
{
  {
    init_simple_test("aC_D_Ip");
    STRUCT_IF_C aC_D_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aC_D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_Ip)");
    check_field_offset(lv, v1, 0, "aC_D_Ip.v1");
    check_field_offset(lv, v2, 1, "aC_D_Ip.v2");
    check_field_offset(lv, v3, 9, "aC_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_Ip, aC_D_Ip)
//============================================================================



static void Test_aC_D_L()
{
  {
    init_simple_test("aC_D_L");
    STRUCT_IF_C aC_D_L lv;
    check2(sizeof(lv), 17, "sizeof(aC_D_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_L)");
    check_field_offset(lv, v1, 0, "aC_D_L.v1");
    check_field_offset(lv, v2, 1, "aC_D_L.v2");
    check_field_offset(lv, v3, 9, "aC_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_L, aC_D_L)
//============================================================================



static void Test_aC_D_S()
{
  {
    init_simple_test("aC_D_S");
    STRUCT_IF_C aC_D_S lv;
    check2(sizeof(lv), 11, "sizeof(aC_D_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_S)");
    check_field_offset(lv, v1, 0, "aC_D_S.v1");
    check_field_offset(lv, v2, 1, "aC_D_S.v2");
    check_field_offset(lv, v3, 9, "aC_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_S, aC_D_S)
//============================================================================



static void Test_aC_D_Uc()
{
  {
    init_simple_test("aC_D_Uc");
    STRUCT_IF_C aC_D_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aC_D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_Uc)");
    check_field_offset(lv, v1, 0, "aC_D_Uc.v1");
    check_field_offset(lv, v2, 1, "aC_D_Uc.v2");
    check_field_offset(lv, v3, 9, "aC_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_Uc, aC_D_Uc)
//============================================================================



static void Test_aC_D_Ui()
{
  {
    init_simple_test("aC_D_Ui");
    STRUCT_IF_C aC_D_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aC_D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_Ui)");
    check_field_offset(lv, v1, 0, "aC_D_Ui.v1");
    check_field_offset(lv, v2, 1, "aC_D_Ui.v2");
    check_field_offset(lv, v3, 9, "aC_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_Ui, aC_D_Ui)
//============================================================================



static void Test_aC_D_Ul()
{
  {
    init_simple_test("aC_D_Ul");
    STRUCT_IF_C aC_D_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aC_D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_Ul)");
    check_field_offset(lv, v1, 0, "aC_D_Ul.v1");
    check_field_offset(lv, v2, 1, "aC_D_Ul.v2");
    check_field_offset(lv, v3, 9, "aC_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_Ul, aC_D_Ul)
//============================================================================



static void Test_aC_D_Us()
{
  {
    init_simple_test("aC_D_Us");
    STRUCT_IF_C aC_D_Us lv;
    check2(sizeof(lv), 11, "sizeof(aC_D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_Us)");
    check_field_offset(lv, v1, 0, "aC_D_Us.v1");
    check_field_offset(lv, v2, 1, "aC_D_Us.v2");
    check_field_offset(lv, v3, 9, "aC_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_Us, aC_D_Us)
//============================================================================



static void Test_aC_D_Vp()
{
  {
    init_simple_test("aC_D_Vp");
    STRUCT_IF_C aC_D_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aC_D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_D_Vp)");
    check_field_offset(lv, v1, 0, "aC_D_Vp.v1");
    check_field_offset(lv, v2, 1, "aC_D_Vp.v2");
    check_field_offset(lv, v3, 9, "aC_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_D_Vp, aC_D_Vp)
//============================================================================



static void Test_aC_F()
{
  {
    init_simple_test("aC_F");
    STRUCT_IF_C aC_F lv;
    check2(sizeof(lv), 5, "sizeof(aC_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F)");
    check_field_offset(lv, v1, 0, "aC_F.v1");
    check_field_offset(lv, v2, 1, "aC_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F, aC_F)
//============================================================================



static void Test_aC_F_BFu15i()
{
  {
    init_simple_test("aC_F_BFu15i");
    static STRUCT_IF_C aC_F_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aC_F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_F_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aC_F_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aC_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu15i, aC_F_BFu15i)
//============================================================================



static void Test_aC_F_BFu15ll()
{
  {
    init_simple_test("aC_F_BFu15ll");
    static STRUCT_IF_C aC_F_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_F_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aC_F_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aC_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu15ll, aC_F_BFu15ll)
//============================================================================



static void Test_aC_F_BFu15s()
{
  {
    init_simple_test("aC_F_BFu15s");
    static STRUCT_IF_C aC_F_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aC_F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_F_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aC_F_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aC_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu15s, aC_F_BFu15s)
//============================================================================



static void Test_aC_F_BFu16i()
{
  {
    init_simple_test("aC_F_BFu16i");
    static STRUCT_IF_C aC_F_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aC_F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_F_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aC_F_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aC_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu16i, aC_F_BFu16i)
//============================================================================



static void Test_aC_F_BFu16ll()
{
  {
    init_simple_test("aC_F_BFu16ll");
    static STRUCT_IF_C aC_F_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_F_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aC_F_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aC_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu16ll, aC_F_BFu16ll)
//============================================================================



static void Test_aC_F_BFu16s()
{
  {
    init_simple_test("aC_F_BFu16s");
    static STRUCT_IF_C aC_F_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aC_F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_F_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aC_F_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aC_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu16s, aC_F_BFu16s)
//============================================================================



static void Test_aC_F_BFu17i()
{
  {
    init_simple_test("aC_F_BFu17i");
    static STRUCT_IF_C aC_F_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aC_F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_F_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aC_F_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aC_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu17i, aC_F_BFu17i)
//============================================================================



static void Test_aC_F_BFu17ll()
{
  {
    init_simple_test("aC_F_BFu17ll");
    static STRUCT_IF_C aC_F_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aC_F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_F_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aC_F_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aC_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu17ll, aC_F_BFu17ll)
//============================================================================



static void Test_aC_F_BFu1c()
{
  {
    init_simple_test("aC_F_BFu1c");
    static STRUCT_IF_C aC_F_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_F_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aC_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu1c, aC_F_BFu1c)
//============================================================================



static void Test_aC_F_BFu1i()
{
  {
    init_simple_test("aC_F_BFu1i");
    static STRUCT_IF_C aC_F_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_F_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aC_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu1i, aC_F_BFu1i)
//============================================================================



static void Test_aC_F_BFu1ll()
{
  {
    init_simple_test("aC_F_BFu1ll");
    static STRUCT_IF_C aC_F_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_F_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aC_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu1ll, aC_F_BFu1ll)
//============================================================================



static void Test_aC_F_BFu1s()
{
  {
    init_simple_test("aC_F_BFu1s");
    static STRUCT_IF_C aC_F_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_F_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aC_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu1s, aC_F_BFu1s)
//============================================================================



static void Test_aC_F_BFu31i()
{
  {
    init_simple_test("aC_F_BFu31i");
    static STRUCT_IF_C aC_F_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aC_F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_F_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aC_F_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aC_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu31i, aC_F_BFu31i)
//============================================================================



static void Test_aC_F_BFu31ll()
{
  {
    init_simple_test("aC_F_BFu31ll");
    static STRUCT_IF_C aC_F_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aC_F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_F_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aC_F_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aC_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu31ll, aC_F_BFu31ll)
//============================================================================



static void Test_aC_F_BFu32i()
{
  {
    init_simple_test("aC_F_BFu32i");
    static STRUCT_IF_C aC_F_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aC_F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_F_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aC_F_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aC_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu32i, aC_F_BFu32i)
//============================================================================



static void Test_aC_F_BFu32ll()
{
  {
    init_simple_test("aC_F_BFu32ll");
    static STRUCT_IF_C aC_F_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aC_F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_F_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aC_F_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aC_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu32ll, aC_F_BFu32ll)
//============================================================================



static void Test_aC_F_BFu33()
{
  {
    init_simple_test("aC_F_BFu33");
    static STRUCT_IF_C aC_F_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aC_F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu33)");
    check_field_offset(lv, v1, 0, "aC_F_BFu33.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aC_F_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aC_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu33, aC_F_BFu33)
//============================================================================



static void Test_aC_F_BFu7c()
{
  {
    init_simple_test("aC_F_BFu7c");
    static STRUCT_IF_C aC_F_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_F_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aC_F_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aC_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu7c, aC_F_BFu7c)
//============================================================================



static void Test_aC_F_BFu7i()
{
  {
    init_simple_test("aC_F_BFu7i");
    static STRUCT_IF_C aC_F_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_F_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aC_F_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aC_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu7i, aC_F_BFu7i)
//============================================================================



static void Test_aC_F_BFu7ll()
{
  {
    init_simple_test("aC_F_BFu7ll");
    static STRUCT_IF_C aC_F_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_F_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aC_F_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aC_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu7ll, aC_F_BFu7ll)
//============================================================================



static void Test_aC_F_BFu7s()
{
  {
    init_simple_test("aC_F_BFu7s");
    static STRUCT_IF_C aC_F_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_F_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aC_F_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aC_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu7s, aC_F_BFu7s)
//============================================================================



static void Test_aC_F_BFu8c()
{
  {
    init_simple_test("aC_F_BFu8c");
    static STRUCT_IF_C aC_F_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_F_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aC_F_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aC_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu8c, aC_F_BFu8c)
//============================================================================



static void Test_aC_F_BFu8i()
{
  {
    init_simple_test("aC_F_BFu8i");
    static STRUCT_IF_C aC_F_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_F_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aC_F_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aC_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu8i, aC_F_BFu8i)
//============================================================================



static void Test_aC_F_BFu8ll()
{
  {
    init_simple_test("aC_F_BFu8ll");
    static STRUCT_IF_C aC_F_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_F_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aC_F_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aC_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu8ll, aC_F_BFu8ll)
//============================================================================



static void Test_aC_F_BFu8s()
{
  {
    init_simple_test("aC_F_BFu8s");
    static STRUCT_IF_C aC_F_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_F_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aC_F_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aC_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu8s, aC_F_BFu8s)
//============================================================================



static void Test_aC_F_BFu9i()
{
  {
    init_simple_test("aC_F_BFu9i");
    static STRUCT_IF_C aC_F_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aC_F_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_F_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aC_F_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aC_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu9i, aC_F_BFu9i)
//============================================================================



static void Test_aC_F_BFu9ll()
{
  {
    init_simple_test("aC_F_BFu9ll");
    static STRUCT_IF_C aC_F_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_F_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_F_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aC_F_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aC_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu9ll, aC_F_BFu9ll)
//============================================================================



static void Test_aC_F_BFu9s()
{
  {
    init_simple_test("aC_F_BFu9s");
    static STRUCT_IF_C aC_F_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aC_F_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_F_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aC_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aC_F_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aC_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_BFu9s, aC_F_BFu9s)
//============================================================================



static void Test_aC_F_C()
{
  {
    init_simple_test("aC_F_C");
    STRUCT_IF_C aC_F_C lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_C)");
    check_field_offset(lv, v1, 0, "aC_F_C.v1");
    check_field_offset(lv, v2, 1, "aC_F_C.v2");
    check_field_offset(lv, v3, 5, "aC_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_C, aC_F_C)
//============================================================================



static void Test_aC_F_D()
{
  {
    init_simple_test("aC_F_D");
    STRUCT_IF_C aC_F_D lv;
    check2(sizeof(lv), 13, "sizeof(aC_F_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_D)");
    check_field_offset(lv, v1, 0, "aC_F_D.v1");
    check_field_offset(lv, v2, 1, "aC_F_D.v2");
    check_field_offset(lv, v3, 5, "aC_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_D, aC_F_D)
//============================================================================



static void Test_aC_F_F()
{
  {
    init_simple_test("aC_F_F");
    STRUCT_IF_C aC_F_F lv;
    check2(sizeof(lv), 9, "sizeof(aC_F_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_F)");
    check_field_offset(lv, v1, 0, "aC_F_F.v1");
    check_field_offset(lv, v2, 1, "aC_F_F.v2");
    check_field_offset(lv, v3, 5, "aC_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_F, aC_F_F)
//============================================================================



static void Test_aC_F_I()
{
  {
    init_simple_test("aC_F_I");
    STRUCT_IF_C aC_F_I lv;
    check2(sizeof(lv), 9, "sizeof(aC_F_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_I)");
    check_field_offset(lv, v1, 0, "aC_F_I.v1");
    check_field_offset(lv, v2, 1, "aC_F_I.v2");
    check_field_offset(lv, v3, 5, "aC_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_I, aC_F_I)
//============================================================================



static void Test_aC_F_Ip()
{
  {
    init_simple_test("aC_F_Ip");
    STRUCT_IF_C aC_F_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_F_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_Ip)");
    check_field_offset(lv, v1, 0, "aC_F_Ip.v1");
    check_field_offset(lv, v2, 1, "aC_F_Ip.v2");
    check_field_offset(lv, v3, 5, "aC_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_Ip, aC_F_Ip)
//============================================================================



static void Test_aC_F_L()
{
  {
    init_simple_test("aC_F_L");
    STRUCT_IF_C aC_F_L lv;
    check2(sizeof(lv), 13, "sizeof(aC_F_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_L)");
    check_field_offset(lv, v1, 0, "aC_F_L.v1");
    check_field_offset(lv, v2, 1, "aC_F_L.v2");
    check_field_offset(lv, v3, 5, "aC_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_L, aC_F_L)
//============================================================================



static void Test_aC_F_S()
{
  {
    init_simple_test("aC_F_S");
    STRUCT_IF_C aC_F_S lv;
    check2(sizeof(lv), 7, "sizeof(aC_F_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_S)");
    check_field_offset(lv, v1, 0, "aC_F_S.v1");
    check_field_offset(lv, v2, 1, "aC_F_S.v2");
    check_field_offset(lv, v3, 5, "aC_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_S, aC_F_S)
//============================================================================



static void Test_aC_F_Uc()
{
  {
    init_simple_test("aC_F_Uc");
    STRUCT_IF_C aC_F_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aC_F_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_Uc)");
    check_field_offset(lv, v1, 0, "aC_F_Uc.v1");
    check_field_offset(lv, v2, 1, "aC_F_Uc.v2");
    check_field_offset(lv, v3, 5, "aC_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_Uc, aC_F_Uc)
//============================================================================



static void Test_aC_F_Ui()
{
  {
    init_simple_test("aC_F_Ui");
    STRUCT_IF_C aC_F_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aC_F_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_Ui)");
    check_field_offset(lv, v1, 0, "aC_F_Ui.v1");
    check_field_offset(lv, v2, 1, "aC_F_Ui.v2");
    check_field_offset(lv, v3, 5, "aC_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_Ui, aC_F_Ui)
//============================================================================



static void Test_aC_F_Ul()
{
  {
    init_simple_test("aC_F_Ul");
    STRUCT_IF_C aC_F_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aC_F_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_Ul)");
    check_field_offset(lv, v1, 0, "aC_F_Ul.v1");
    check_field_offset(lv, v2, 1, "aC_F_Ul.v2");
    check_field_offset(lv, v3, 5, "aC_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_Ul, aC_F_Ul)
//============================================================================



static void Test_aC_F_Us()
{
  {
    init_simple_test("aC_F_Us");
    STRUCT_IF_C aC_F_Us lv;
    check2(sizeof(lv), 7, "sizeof(aC_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_Us)");
    check_field_offset(lv, v1, 0, "aC_F_Us.v1");
    check_field_offset(lv, v2, 1, "aC_F_Us.v2");
    check_field_offset(lv, v3, 5, "aC_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_Us, aC_F_Us)
//============================================================================



static void Test_aC_F_Vp()
{
  {
    init_simple_test("aC_F_Vp");
    STRUCT_IF_C aC_F_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_F_Vp)");
    check_field_offset(lv, v1, 0, "aC_F_Vp.v1");
    check_field_offset(lv, v2, 1, "aC_F_Vp.v2");
    check_field_offset(lv, v3, 5, "aC_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_F_Vp, aC_F_Vp)
//============================================================================



static void Test_aC_I()
{
  {
    init_simple_test("aC_I");
    STRUCT_IF_C aC_I lv;
    check2(sizeof(lv), 5, "sizeof(aC_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I)");
    check_field_offset(lv, v1, 0, "aC_I.v1");
    check_field_offset(lv, v2, 1, "aC_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I, aC_I)
//============================================================================



static void Test_aC_I_BFu15i()
{
  {
    init_simple_test("aC_I_BFu15i");
    static STRUCT_IF_C aC_I_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aC_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_I_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aC_I_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aC_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu15i, aC_I_BFu15i)
//============================================================================



static void Test_aC_I_BFu15ll()
{
  {
    init_simple_test("aC_I_BFu15ll");
    static STRUCT_IF_C aC_I_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_I_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aC_I_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aC_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu15ll, aC_I_BFu15ll)
//============================================================================



static void Test_aC_I_BFu15s()
{
  {
    init_simple_test("aC_I_BFu15s");
    static STRUCT_IF_C aC_I_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aC_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_I_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aC_I_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aC_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu15s, aC_I_BFu15s)
//============================================================================



static void Test_aC_I_BFu16i()
{
  {
    init_simple_test("aC_I_BFu16i");
    static STRUCT_IF_C aC_I_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aC_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_I_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aC_I_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aC_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu16i, aC_I_BFu16i)
//============================================================================



static void Test_aC_I_BFu16ll()
{
  {
    init_simple_test("aC_I_BFu16ll");
    static STRUCT_IF_C aC_I_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_I_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aC_I_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aC_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu16ll, aC_I_BFu16ll)
//============================================================================



static void Test_aC_I_BFu16s()
{
  {
    init_simple_test("aC_I_BFu16s");
    static STRUCT_IF_C aC_I_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aC_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_I_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aC_I_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aC_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu16s, aC_I_BFu16s)
//============================================================================



static void Test_aC_I_BFu17i()
{
  {
    init_simple_test("aC_I_BFu17i");
    static STRUCT_IF_C aC_I_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aC_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_I_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aC_I_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aC_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu17i, aC_I_BFu17i)
//============================================================================



static void Test_aC_I_BFu17ll()
{
  {
    init_simple_test("aC_I_BFu17ll");
    static STRUCT_IF_C aC_I_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aC_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_I_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aC_I_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aC_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu17ll, aC_I_BFu17ll)
//============================================================================



static void Test_aC_I_BFu1c()
{
  {
    init_simple_test("aC_I_BFu1c");
    static STRUCT_IF_C aC_I_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_I_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aC_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu1c, aC_I_BFu1c)
//============================================================================



static void Test_aC_I_BFu1i()
{
  {
    init_simple_test("aC_I_BFu1i");
    static STRUCT_IF_C aC_I_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_I_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aC_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu1i, aC_I_BFu1i)
//============================================================================



static void Test_aC_I_BFu1ll()
{
  {
    init_simple_test("aC_I_BFu1ll");
    static STRUCT_IF_C aC_I_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_I_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aC_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu1ll, aC_I_BFu1ll)
//============================================================================



static void Test_aC_I_BFu1s()
{
  {
    init_simple_test("aC_I_BFu1s");
    static STRUCT_IF_C aC_I_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_I_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aC_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu1s, aC_I_BFu1s)
//============================================================================



static void Test_aC_I_BFu31i()
{
  {
    init_simple_test("aC_I_BFu31i");
    static STRUCT_IF_C aC_I_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aC_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_I_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aC_I_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aC_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu31i, aC_I_BFu31i)
//============================================================================



static void Test_aC_I_BFu31ll()
{
  {
    init_simple_test("aC_I_BFu31ll");
    static STRUCT_IF_C aC_I_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aC_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_I_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aC_I_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aC_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu31ll, aC_I_BFu31ll)
//============================================================================



static void Test_aC_I_BFu32i()
{
  {
    init_simple_test("aC_I_BFu32i");
    static STRUCT_IF_C aC_I_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aC_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_I_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aC_I_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aC_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu32i, aC_I_BFu32i)
//============================================================================



static void Test_aC_I_BFu32ll()
{
  {
    init_simple_test("aC_I_BFu32ll");
    static STRUCT_IF_C aC_I_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aC_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_I_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aC_I_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aC_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu32ll, aC_I_BFu32ll)
//============================================================================



static void Test_aC_I_BFu33()
{
  {
    init_simple_test("aC_I_BFu33");
    static STRUCT_IF_C aC_I_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aC_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu33)");
    check_field_offset(lv, v1, 0, "aC_I_BFu33.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aC_I_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aC_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu33, aC_I_BFu33)
//============================================================================



static void Test_aC_I_BFu7c()
{
  {
    init_simple_test("aC_I_BFu7c");
    static STRUCT_IF_C aC_I_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_I_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aC_I_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aC_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu7c, aC_I_BFu7c)
//============================================================================



static void Test_aC_I_BFu7i()
{
  {
    init_simple_test("aC_I_BFu7i");
    static STRUCT_IF_C aC_I_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_I_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aC_I_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aC_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu7i, aC_I_BFu7i)
//============================================================================



static void Test_aC_I_BFu7ll()
{
  {
    init_simple_test("aC_I_BFu7ll");
    static STRUCT_IF_C aC_I_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_I_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aC_I_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aC_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu7ll, aC_I_BFu7ll)
//============================================================================



static void Test_aC_I_BFu7s()
{
  {
    init_simple_test("aC_I_BFu7s");
    static STRUCT_IF_C aC_I_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_I_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aC_I_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aC_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu7s, aC_I_BFu7s)
//============================================================================



static void Test_aC_I_BFu8c()
{
  {
    init_simple_test("aC_I_BFu8c");
    static STRUCT_IF_C aC_I_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_I_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aC_I_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aC_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu8c, aC_I_BFu8c)
//============================================================================



static void Test_aC_I_BFu8i()
{
  {
    init_simple_test("aC_I_BFu8i");
    static STRUCT_IF_C aC_I_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_I_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aC_I_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aC_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu8i, aC_I_BFu8i)
//============================================================================



static void Test_aC_I_BFu8ll()
{
  {
    init_simple_test("aC_I_BFu8ll");
    static STRUCT_IF_C aC_I_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_I_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aC_I_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aC_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu8ll, aC_I_BFu8ll)
//============================================================================



static void Test_aC_I_BFu8s()
{
  {
    init_simple_test("aC_I_BFu8s");
    static STRUCT_IF_C aC_I_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_I_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aC_I_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aC_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu8s, aC_I_BFu8s)
//============================================================================



static void Test_aC_I_BFu9i()
{
  {
    init_simple_test("aC_I_BFu9i");
    static STRUCT_IF_C aC_I_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aC_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_I_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aC_I_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aC_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu9i, aC_I_BFu9i)
//============================================================================



static void Test_aC_I_BFu9ll()
{
  {
    init_simple_test("aC_I_BFu9ll");
    static STRUCT_IF_C aC_I_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_I_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aC_I_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aC_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu9ll, aC_I_BFu9ll)
//============================================================================



static void Test_aC_I_BFu9s()
{
  {
    init_simple_test("aC_I_BFu9s");
    static STRUCT_IF_C aC_I_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aC_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_I_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aC_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aC_I_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aC_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_BFu9s, aC_I_BFu9s)
//============================================================================



static void Test_aC_I_C()
{
  {
    init_simple_test("aC_I_C");
    STRUCT_IF_C aC_I_C lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_C)");
    check_field_offset(lv, v1, 0, "aC_I_C.v1");
    check_field_offset(lv, v2, 1, "aC_I_C.v2");
    check_field_offset(lv, v3, 5, "aC_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_C, aC_I_C)
//============================================================================



static void Test_aC_I_D()
{
  {
    init_simple_test("aC_I_D");
    STRUCT_IF_C aC_I_D lv;
    check2(sizeof(lv), 13, "sizeof(aC_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_D)");
    check_field_offset(lv, v1, 0, "aC_I_D.v1");
    check_field_offset(lv, v2, 1, "aC_I_D.v2");
    check_field_offset(lv, v3, 5, "aC_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_D, aC_I_D)
//============================================================================



static void Test_aC_I_F()
{
  {
    init_simple_test("aC_I_F");
    STRUCT_IF_C aC_I_F lv;
    check2(sizeof(lv), 9, "sizeof(aC_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_F)");
    check_field_offset(lv, v1, 0, "aC_I_F.v1");
    check_field_offset(lv, v2, 1, "aC_I_F.v2");
    check_field_offset(lv, v3, 5, "aC_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_F, aC_I_F)
//============================================================================



static void Test_aC_I_I()
{
  {
    init_simple_test("aC_I_I");
    STRUCT_IF_C aC_I_I lv;
    check2(sizeof(lv), 9, "sizeof(aC_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_I)");
    check_field_offset(lv, v1, 0, "aC_I_I.v1");
    check_field_offset(lv, v2, 1, "aC_I_I.v2");
    check_field_offset(lv, v3, 5, "aC_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_I, aC_I_I)
//============================================================================



static void Test_aC_I_Ip()
{
  {
    init_simple_test("aC_I_Ip");
    STRUCT_IF_C aC_I_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_Ip)");
    check_field_offset(lv, v1, 0, "aC_I_Ip.v1");
    check_field_offset(lv, v2, 1, "aC_I_Ip.v2");
    check_field_offset(lv, v3, 5, "aC_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_Ip, aC_I_Ip)
//============================================================================



static void Test_aC_I_L()
{
  {
    init_simple_test("aC_I_L");
    STRUCT_IF_C aC_I_L lv;
    check2(sizeof(lv), 13, "sizeof(aC_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_L)");
    check_field_offset(lv, v1, 0, "aC_I_L.v1");
    check_field_offset(lv, v2, 1, "aC_I_L.v2");
    check_field_offset(lv, v3, 5, "aC_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_L, aC_I_L)
//============================================================================



static void Test_aC_I_S()
{
  {
    init_simple_test("aC_I_S");
    STRUCT_IF_C aC_I_S lv;
    check2(sizeof(lv), 7, "sizeof(aC_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_S)");
    check_field_offset(lv, v1, 0, "aC_I_S.v1");
    check_field_offset(lv, v2, 1, "aC_I_S.v2");
    check_field_offset(lv, v3, 5, "aC_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_S, aC_I_S)
//============================================================================



static void Test_aC_I_Uc()
{
  {
    init_simple_test("aC_I_Uc");
    STRUCT_IF_C aC_I_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aC_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_Uc)");
    check_field_offset(lv, v1, 0, "aC_I_Uc.v1");
    check_field_offset(lv, v2, 1, "aC_I_Uc.v2");
    check_field_offset(lv, v3, 5, "aC_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_Uc, aC_I_Uc)
//============================================================================



static void Test_aC_I_Ui()
{
  {
    init_simple_test("aC_I_Ui");
    STRUCT_IF_C aC_I_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aC_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_Ui)");
    check_field_offset(lv, v1, 0, "aC_I_Ui.v1");
    check_field_offset(lv, v2, 1, "aC_I_Ui.v2");
    check_field_offset(lv, v3, 5, "aC_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_Ui, aC_I_Ui)
//============================================================================



static void Test_aC_I_Ul()
{
  {
    init_simple_test("aC_I_Ul");
    STRUCT_IF_C aC_I_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aC_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_Ul)");
    check_field_offset(lv, v1, 0, "aC_I_Ul.v1");
    check_field_offset(lv, v2, 1, "aC_I_Ul.v2");
    check_field_offset(lv, v3, 5, "aC_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_Ul, aC_I_Ul)
//============================================================================



static void Test_aC_I_Us()
{
  {
    init_simple_test("aC_I_Us");
    STRUCT_IF_C aC_I_Us lv;
    check2(sizeof(lv), 7, "sizeof(aC_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_Us)");
    check_field_offset(lv, v1, 0, "aC_I_Us.v1");
    check_field_offset(lv, v2, 1, "aC_I_Us.v2");
    check_field_offset(lv, v3, 5, "aC_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_Us, aC_I_Us)
//============================================================================



static void Test_aC_I_Vp()
{
  {
    init_simple_test("aC_I_Vp");
    STRUCT_IF_C aC_I_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_I_Vp)");
    check_field_offset(lv, v1, 0, "aC_I_Vp.v1");
    check_field_offset(lv, v2, 1, "aC_I_Vp.v2");
    check_field_offset(lv, v3, 5, "aC_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_I_Vp, aC_I_Vp)
//============================================================================



static void Test_aC_Ip()
{
  {
    init_simple_test("aC_Ip");
    STRUCT_IF_C aC_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aC_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip)");
    check_field_offset(lv, v1, 0, "aC_Ip.v1");
    check_field_offset(lv, v2, 1, "aC_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip, aC_Ip)
//============================================================================



static void Test_aC_Ip_BFu15i()
{
  {
    init_simple_test("aC_Ip_BFu15i");
    static STRUCT_IF_C aC_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aC_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aC_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu15i, aC_Ip_BFu15i)
//============================================================================



static void Test_aC_Ip_BFu15ll()
{
  {
    init_simple_test("aC_Ip_BFu15ll");
    static STRUCT_IF_C aC_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aC_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aC_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu15ll, aC_Ip_BFu15ll)
//============================================================================



static void Test_aC_Ip_BFu15s()
{
  {
    init_simple_test("aC_Ip_BFu15s");
    static STRUCT_IF_C aC_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aC_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aC_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu15s, aC_Ip_BFu15s)
//============================================================================



static void Test_aC_Ip_BFu16i()
{
  {
    init_simple_test("aC_Ip_BFu16i");
    static STRUCT_IF_C aC_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aC_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aC_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu16i, aC_Ip_BFu16i)
//============================================================================



static void Test_aC_Ip_BFu16ll()
{
  {
    init_simple_test("aC_Ip_BFu16ll");
    static STRUCT_IF_C aC_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aC_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aC_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu16ll, aC_Ip_BFu16ll)
//============================================================================



static void Test_aC_Ip_BFu16s()
{
  {
    init_simple_test("aC_Ip_BFu16s");
    static STRUCT_IF_C aC_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aC_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aC_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu16s, aC_Ip_BFu16s)
//============================================================================



static void Test_aC_Ip_BFu17i()
{
  {
    init_simple_test("aC_Ip_BFu17i");
    static STRUCT_IF_C aC_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aC_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aC_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aC_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu17i, aC_Ip_BFu17i)
//============================================================================



static void Test_aC_Ip_BFu17ll()
{
  {
    init_simple_test("aC_Ip_BFu17ll");
    static STRUCT_IF_C aC_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aC_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aC_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aC_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu17ll, aC_Ip_BFu17ll)
//============================================================================



static void Test_aC_Ip_BFu1c()
{
  {
    init_simple_test("aC_Ip_BFu1c");
    static STRUCT_IF_C aC_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aC_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu1c, aC_Ip_BFu1c)
//============================================================================



static void Test_aC_Ip_BFu1i()
{
  {
    init_simple_test("aC_Ip_BFu1i");
    static STRUCT_IF_C aC_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aC_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu1i, aC_Ip_BFu1i)
//============================================================================



static void Test_aC_Ip_BFu1ll()
{
  {
    init_simple_test("aC_Ip_BFu1ll");
    static STRUCT_IF_C aC_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aC_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu1ll, aC_Ip_BFu1ll)
//============================================================================



static void Test_aC_Ip_BFu1s()
{
  {
    init_simple_test("aC_Ip_BFu1s");
    static STRUCT_IF_C aC_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aC_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu1s, aC_Ip_BFu1s)
//============================================================================



static void Test_aC_Ip_BFu31i()
{
  {
    init_simple_test("aC_Ip_BFu31i");
    static STRUCT_IF_C aC_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aC_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aC_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu31i, aC_Ip_BFu31i)
//============================================================================



static void Test_aC_Ip_BFu31ll()
{
  {
    init_simple_test("aC_Ip_BFu31ll");
    static STRUCT_IF_C aC_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aC_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aC_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu31ll, aC_Ip_BFu31ll)
//============================================================================



static void Test_aC_Ip_BFu32i()
{
  {
    init_simple_test("aC_Ip_BFu32i");
    static STRUCT_IF_C aC_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aC_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aC_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu32i, aC_Ip_BFu32i)
//============================================================================



static void Test_aC_Ip_BFu32ll()
{
  {
    init_simple_test("aC_Ip_BFu32ll");
    static STRUCT_IF_C aC_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aC_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aC_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu32ll, aC_Ip_BFu32ll)
//============================================================================



static void Test_aC_Ip_BFu33()
{
  {
    init_simple_test("aC_Ip_BFu33");
    static STRUCT_IF_C aC_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aC_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu33.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aC_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aC_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu33, aC_Ip_BFu33)
//============================================================================



static void Test_aC_Ip_BFu7c()
{
  {
    init_simple_test("aC_Ip_BFu7c");
    static STRUCT_IF_C aC_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aC_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aC_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu7c, aC_Ip_BFu7c)
//============================================================================



static void Test_aC_Ip_BFu7i()
{
  {
    init_simple_test("aC_Ip_BFu7i");
    static STRUCT_IF_C aC_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aC_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aC_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu7i, aC_Ip_BFu7i)
//============================================================================



static void Test_aC_Ip_BFu7ll()
{
  {
    init_simple_test("aC_Ip_BFu7ll");
    static STRUCT_IF_C aC_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aC_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aC_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu7ll, aC_Ip_BFu7ll)
//============================================================================



static void Test_aC_Ip_BFu7s()
{
  {
    init_simple_test("aC_Ip_BFu7s");
    static STRUCT_IF_C aC_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aC_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aC_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu7s, aC_Ip_BFu7s)
//============================================================================



static void Test_aC_Ip_BFu8c()
{
  {
    init_simple_test("aC_Ip_BFu8c");
    static STRUCT_IF_C aC_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aC_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aC_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu8c, aC_Ip_BFu8c)
//============================================================================



static void Test_aC_Ip_BFu8i()
{
  {
    init_simple_test("aC_Ip_BFu8i");
    static STRUCT_IF_C aC_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aC_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aC_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu8i, aC_Ip_BFu8i)
//============================================================================



static void Test_aC_Ip_BFu8ll()
{
  {
    init_simple_test("aC_Ip_BFu8ll");
    static STRUCT_IF_C aC_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aC_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aC_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu8ll, aC_Ip_BFu8ll)
//============================================================================



static void Test_aC_Ip_BFu8s()
{
  {
    init_simple_test("aC_Ip_BFu8s");
    static STRUCT_IF_C aC_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aC_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aC_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu8s, aC_Ip_BFu8s)
//============================================================================



static void Test_aC_Ip_BFu9i()
{
  {
    init_simple_test("aC_Ip_BFu9i");
    static STRUCT_IF_C aC_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aC_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aC_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu9i, aC_Ip_BFu9i)
//============================================================================



static void Test_aC_Ip_BFu9ll()
{
  {
    init_simple_test("aC_Ip_BFu9ll");
    static STRUCT_IF_C aC_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aC_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aC_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu9ll, aC_Ip_BFu9ll)
//============================================================================



static void Test_aC_Ip_BFu9s()
{
  {
    init_simple_test("aC_Ip_BFu9s");
    static STRUCT_IF_C aC_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_Ip_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aC_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aC_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_BFu9s, aC_Ip_BFu9s)
//============================================================================



static void Test_aC_Ip_C()
{
  {
    init_simple_test("aC_Ip_C");
    STRUCT_IF_C aC_Ip_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_C)");
    check_field_offset(lv, v1, 0, "aC_Ip_C.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_C, aC_Ip_C)
//============================================================================



static void Test_aC_Ip_D()
{
  {
    init_simple_test("aC_Ip_D");
    STRUCT_IF_C aC_Ip_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aC_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_D)");
    check_field_offset(lv, v1, 0, "aC_Ip_D.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_D, aC_Ip_D)
//============================================================================



static void Test_aC_Ip_F()
{
  {
    init_simple_test("aC_Ip_F");
    STRUCT_IF_C aC_Ip_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_F)");
    check_field_offset(lv, v1, 0, "aC_Ip_F.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_F, aC_Ip_F)
//============================================================================



static void Test_aC_Ip_I()
{
  {
    init_simple_test("aC_Ip_I");
    STRUCT_IF_C aC_Ip_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_I)");
    check_field_offset(lv, v1, 0, "aC_Ip_I.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_I, aC_Ip_I)
//============================================================================



static void Test_aC_Ip_Ip()
{
  {
    init_simple_test("aC_Ip_Ip");
    STRUCT_IF_C aC_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aC_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_Ip)");
    check_field_offset(lv, v1, 0, "aC_Ip_Ip.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_Ip, aC_Ip_Ip)
//============================================================================



static void Test_aC_Ip_L()
{
  {
    init_simple_test("aC_Ip_L");
    STRUCT_IF_C aC_Ip_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aC_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_L)");
    check_field_offset(lv, v1, 0, "aC_Ip_L.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_L, aC_Ip_L)
//============================================================================



static void Test_aC_Ip_S()
{
  {
    init_simple_test("aC_Ip_S");
    STRUCT_IF_C aC_Ip_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_S)");
    check_field_offset(lv, v1, 0, "aC_Ip_S.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_S, aC_Ip_S)
//============================================================================



static void Test_aC_Ip_Uc()
{
  {
    init_simple_test("aC_Ip_Uc");
    STRUCT_IF_C aC_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_Uc)");
    check_field_offset(lv, v1, 0, "aC_Ip_Uc.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_Uc, aC_Ip_Uc)
//============================================================================



static void Test_aC_Ip_Ui()
{
  {
    init_simple_test("aC_Ip_Ui");
    STRUCT_IF_C aC_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_Ui)");
    check_field_offset(lv, v1, 0, "aC_Ip_Ui.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_Ui, aC_Ip_Ui)
//============================================================================



static void Test_aC_Ip_Ul()
{
  {
    init_simple_test("aC_Ip_Ul");
    STRUCT_IF_C aC_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aC_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_Ul)");
    check_field_offset(lv, v1, 0, "aC_Ip_Ul.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_Ul, aC_Ip_Ul)
//============================================================================



static void Test_aC_Ip_Us()
{
  {
    init_simple_test("aC_Ip_Us");
    STRUCT_IF_C aC_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_Us)");
    check_field_offset(lv, v1, 0, "aC_Ip_Us.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_Us, aC_Ip_Us)
//============================================================================



static void Test_aC_Ip_Vp()
{
  {
    init_simple_test("aC_Ip_Vp");
    STRUCT_IF_C aC_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aC_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ip_Vp)");
    check_field_offset(lv, v1, 0, "aC_Ip_Vp.v1");
    check_field_offset(lv, v2, 1, "aC_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ip_Vp, aC_Ip_Vp)
//============================================================================



static void Test_aC_L()
{
  {
    init_simple_test("aC_L");
    STRUCT_IF_C aC_L lv;
    check2(sizeof(lv), 9, "sizeof(aC_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L)");
    check_field_offset(lv, v1, 0, "aC_L.v1");
    check_field_offset(lv, v2, 1, "aC_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L, aC_L)
//============================================================================



static void Test_aC_L_BFu15i()
{
  {
    init_simple_test("aC_L_BFu15i");
    static STRUCT_IF_C aC_L_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aC_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_L_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aC_L_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aC_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu15i, aC_L_BFu15i)
//============================================================================



static void Test_aC_L_BFu15ll()
{
  {
    init_simple_test("aC_L_BFu15ll");
    static STRUCT_IF_C aC_L_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aC_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_L_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aC_L_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aC_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu15ll, aC_L_BFu15ll)
//============================================================================



static void Test_aC_L_BFu15s()
{
  {
    init_simple_test("aC_L_BFu15s");
    static STRUCT_IF_C aC_L_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aC_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_L_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aC_L_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aC_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu15s, aC_L_BFu15s)
//============================================================================



static void Test_aC_L_BFu16i()
{
  {
    init_simple_test("aC_L_BFu16i");
    static STRUCT_IF_C aC_L_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(aC_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_L_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aC_L_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aC_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu16i, aC_L_BFu16i)
//============================================================================



static void Test_aC_L_BFu16ll()
{
  {
    init_simple_test("aC_L_BFu16ll");
    static STRUCT_IF_C aC_L_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(aC_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_L_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aC_L_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aC_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu16ll, aC_L_BFu16ll)
//============================================================================



static void Test_aC_L_BFu16s()
{
  {
    init_simple_test("aC_L_BFu16s");
    static STRUCT_IF_C aC_L_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(aC_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_L_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aC_L_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aC_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu16s, aC_L_BFu16s)
//============================================================================



static void Test_aC_L_BFu17i()
{
  {
    init_simple_test("aC_L_BFu17i");
    static STRUCT_IF_C aC_L_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aC_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_L_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aC_L_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aC_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu17i, aC_L_BFu17i)
//============================================================================



static void Test_aC_L_BFu17ll()
{
  {
    init_simple_test("aC_L_BFu17ll");
    static STRUCT_IF_C aC_L_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aC_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_L_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aC_L_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aC_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu17ll, aC_L_BFu17ll)
//============================================================================



static void Test_aC_L_BFu1c()
{
  {
    init_simple_test("aC_L_BFu1c");
    static STRUCT_IF_C aC_L_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_L_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aC_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu1c, aC_L_BFu1c)
//============================================================================



static void Test_aC_L_BFu1i()
{
  {
    init_simple_test("aC_L_BFu1i");
    static STRUCT_IF_C aC_L_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_L_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aC_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu1i, aC_L_BFu1i)
//============================================================================



static void Test_aC_L_BFu1ll()
{
  {
    init_simple_test("aC_L_BFu1ll");
    static STRUCT_IF_C aC_L_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_L_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aC_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu1ll, aC_L_BFu1ll)
//============================================================================



static void Test_aC_L_BFu1s()
{
  {
    init_simple_test("aC_L_BFu1s");
    static STRUCT_IF_C aC_L_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_L_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aC_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu1s, aC_L_BFu1s)
//============================================================================



static void Test_aC_L_BFu31i()
{
  {
    init_simple_test("aC_L_BFu31i");
    static STRUCT_IF_C aC_L_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aC_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_L_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aC_L_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aC_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu31i, aC_L_BFu31i)
//============================================================================



static void Test_aC_L_BFu31ll()
{
  {
    init_simple_test("aC_L_BFu31ll");
    static STRUCT_IF_C aC_L_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aC_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_L_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aC_L_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aC_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu31ll, aC_L_BFu31ll)
//============================================================================



static void Test_aC_L_BFu32i()
{
  {
    init_simple_test("aC_L_BFu32i");
    static STRUCT_IF_C aC_L_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aC_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_L_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aC_L_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aC_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu32i, aC_L_BFu32i)
//============================================================================



static void Test_aC_L_BFu32ll()
{
  {
    init_simple_test("aC_L_BFu32ll");
    static STRUCT_IF_C aC_L_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aC_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_L_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aC_L_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aC_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu32ll, aC_L_BFu32ll)
//============================================================================



static void Test_aC_L_BFu33()
{
  {
    init_simple_test("aC_L_BFu33");
    static STRUCT_IF_C aC_L_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aC_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu33)");
    check_field_offset(lv, v1, 0, "aC_L_BFu33.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aC_L_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aC_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu33, aC_L_BFu33)
//============================================================================



static void Test_aC_L_BFu7c()
{
  {
    init_simple_test("aC_L_BFu7c");
    static STRUCT_IF_C aC_L_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_L_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aC_L_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aC_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu7c, aC_L_BFu7c)
//============================================================================



static void Test_aC_L_BFu7i()
{
  {
    init_simple_test("aC_L_BFu7i");
    static STRUCT_IF_C aC_L_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_L_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aC_L_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aC_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu7i, aC_L_BFu7i)
//============================================================================



static void Test_aC_L_BFu7ll()
{
  {
    init_simple_test("aC_L_BFu7ll");
    static STRUCT_IF_C aC_L_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_L_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aC_L_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aC_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu7ll, aC_L_BFu7ll)
//============================================================================



static void Test_aC_L_BFu7s()
{
  {
    init_simple_test("aC_L_BFu7s");
    static STRUCT_IF_C aC_L_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_L_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aC_L_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aC_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu7s, aC_L_BFu7s)
//============================================================================



static void Test_aC_L_BFu8c()
{
  {
    init_simple_test("aC_L_BFu8c");
    static STRUCT_IF_C aC_L_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_L_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aC_L_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aC_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu8c, aC_L_BFu8c)
//============================================================================



static void Test_aC_L_BFu8i()
{
  {
    init_simple_test("aC_L_BFu8i");
    static STRUCT_IF_C aC_L_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_L_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aC_L_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aC_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu8i, aC_L_BFu8i)
//============================================================================



static void Test_aC_L_BFu8ll()
{
  {
    init_simple_test("aC_L_BFu8ll");
    static STRUCT_IF_C aC_L_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_L_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aC_L_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aC_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu8ll, aC_L_BFu8ll)
//============================================================================



static void Test_aC_L_BFu8s()
{
  {
    init_simple_test("aC_L_BFu8s");
    static STRUCT_IF_C aC_L_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_L_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aC_L_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aC_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu8s, aC_L_BFu8s)
//============================================================================



static void Test_aC_L_BFu9i()
{
  {
    init_simple_test("aC_L_BFu9i");
    static STRUCT_IF_C aC_L_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aC_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_L_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aC_L_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aC_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu9i, aC_L_BFu9i)
//============================================================================



static void Test_aC_L_BFu9ll()
{
  {
    init_simple_test("aC_L_BFu9ll");
    static STRUCT_IF_C aC_L_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aC_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_L_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aC_L_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aC_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu9ll, aC_L_BFu9ll)
//============================================================================



static void Test_aC_L_BFu9s()
{
  {
    init_simple_test("aC_L_BFu9s");
    static STRUCT_IF_C aC_L_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aC_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_L_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aC_L_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aC_L_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aC_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_BFu9s, aC_L_BFu9s)
//============================================================================



static void Test_aC_L_C()
{
  {
    init_simple_test("aC_L_C");
    STRUCT_IF_C aC_L_C lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_C)");
    check_field_offset(lv, v1, 0, "aC_L_C.v1");
    check_field_offset(lv, v2, 1, "aC_L_C.v2");
    check_field_offset(lv, v3, 9, "aC_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_C, aC_L_C)
//============================================================================



static void Test_aC_L_D()
{
  {
    init_simple_test("aC_L_D");
    STRUCT_IF_C aC_L_D lv;
    check2(sizeof(lv), 17, "sizeof(aC_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_D)");
    check_field_offset(lv, v1, 0, "aC_L_D.v1");
    check_field_offset(lv, v2, 1, "aC_L_D.v2");
    check_field_offset(lv, v3, 9, "aC_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_D, aC_L_D)
//============================================================================



static void Test_aC_L_F()
{
  {
    init_simple_test("aC_L_F");
    STRUCT_IF_C aC_L_F lv;
    check2(sizeof(lv), 13, "sizeof(aC_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_F)");
    check_field_offset(lv, v1, 0, "aC_L_F.v1");
    check_field_offset(lv, v2, 1, "aC_L_F.v2");
    check_field_offset(lv, v3, 9, "aC_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_F, aC_L_F)
//============================================================================



static void Test_aC_L_I()
{
  {
    init_simple_test("aC_L_I");
    STRUCT_IF_C aC_L_I lv;
    check2(sizeof(lv), 13, "sizeof(aC_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_I)");
    check_field_offset(lv, v1, 0, "aC_L_I.v1");
    check_field_offset(lv, v2, 1, "aC_L_I.v2");
    check_field_offset(lv, v3, 9, "aC_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_I, aC_L_I)
//============================================================================



static void Test_aC_L_Ip()
{
  {
    init_simple_test("aC_L_Ip");
    STRUCT_IF_C aC_L_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aC_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_Ip)");
    check_field_offset(lv, v1, 0, "aC_L_Ip.v1");
    check_field_offset(lv, v2, 1, "aC_L_Ip.v2");
    check_field_offset(lv, v3, 9, "aC_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_Ip, aC_L_Ip)
//============================================================================



static void Test_aC_L_L()
{
  {
    init_simple_test("aC_L_L");
    STRUCT_IF_C aC_L_L lv;
    check2(sizeof(lv), 17, "sizeof(aC_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_L)");
    check_field_offset(lv, v1, 0, "aC_L_L.v1");
    check_field_offset(lv, v2, 1, "aC_L_L.v2");
    check_field_offset(lv, v3, 9, "aC_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_L, aC_L_L)
//============================================================================



static void Test_aC_L_S()
{
  {
    init_simple_test("aC_L_S");
    STRUCT_IF_C aC_L_S lv;
    check2(sizeof(lv), 11, "sizeof(aC_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_S)");
    check_field_offset(lv, v1, 0, "aC_L_S.v1");
    check_field_offset(lv, v2, 1, "aC_L_S.v2");
    check_field_offset(lv, v3, 9, "aC_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_S, aC_L_S)
//============================================================================



static void Test_aC_L_Uc()
{
  {
    init_simple_test("aC_L_Uc");
    STRUCT_IF_C aC_L_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aC_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_Uc)");
    check_field_offset(lv, v1, 0, "aC_L_Uc.v1");
    check_field_offset(lv, v2, 1, "aC_L_Uc.v2");
    check_field_offset(lv, v3, 9, "aC_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_Uc, aC_L_Uc)
//============================================================================



static void Test_aC_L_Ui()
{
  {
    init_simple_test("aC_L_Ui");
    STRUCT_IF_C aC_L_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aC_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_Ui)");
    check_field_offset(lv, v1, 0, "aC_L_Ui.v1");
    check_field_offset(lv, v2, 1, "aC_L_Ui.v2");
    check_field_offset(lv, v3, 9, "aC_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_Ui, aC_L_Ui)
//============================================================================



static void Test_aC_L_Ul()
{
  {
    init_simple_test("aC_L_Ul");
    STRUCT_IF_C aC_L_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aC_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_Ul)");
    check_field_offset(lv, v1, 0, "aC_L_Ul.v1");
    check_field_offset(lv, v2, 1, "aC_L_Ul.v2");
    check_field_offset(lv, v3, 9, "aC_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_Ul, aC_L_Ul)
//============================================================================



static void Test_aC_L_Us()
{
  {
    init_simple_test("aC_L_Us");
    STRUCT_IF_C aC_L_Us lv;
    check2(sizeof(lv), 11, "sizeof(aC_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_Us)");
    check_field_offset(lv, v1, 0, "aC_L_Us.v1");
    check_field_offset(lv, v2, 1, "aC_L_Us.v2");
    check_field_offset(lv, v3, 9, "aC_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_Us, aC_L_Us)
//============================================================================



static void Test_aC_L_Vp()
{
  {
    init_simple_test("aC_L_Vp");
    STRUCT_IF_C aC_L_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aC_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_L_Vp)");
    check_field_offset(lv, v1, 0, "aC_L_Vp.v1");
    check_field_offset(lv, v2, 1, "aC_L_Vp.v2");
    check_field_offset(lv, v3, 9, "aC_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_L_Vp, aC_L_Vp)
//============================================================================



static void Test_aC_S()
{
  {
    init_simple_test("aC_S");
    STRUCT_IF_C aC_S lv;
    check2(sizeof(lv), 3, "sizeof(aC_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S)");
    check_field_offset(lv, v1, 0, "aC_S.v1");
    check_field_offset(lv, v2, 1, "aC_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S, aC_S)
//============================================================================



static void Test_aC_S_BFu15i()
{
  {
    init_simple_test("aC_S_BFu15i");
    static STRUCT_IF_C aC_S_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aC_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_S_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aC_S_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aC_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu15i, aC_S_BFu15i)
//============================================================================



static void Test_aC_S_BFu15ll()
{
  {
    init_simple_test("aC_S_BFu15ll");
    static STRUCT_IF_C aC_S_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_S_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aC_S_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aC_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu15ll, aC_S_BFu15ll)
//============================================================================



static void Test_aC_S_BFu15s()
{
  {
    init_simple_test("aC_S_BFu15s");
    static STRUCT_IF_C aC_S_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aC_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_S_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aC_S_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aC_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu15s, aC_S_BFu15s)
//============================================================================



static void Test_aC_S_BFu16i()
{
  {
    init_simple_test("aC_S_BFu16i");
    static STRUCT_IF_C aC_S_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aC_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_S_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aC_S_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aC_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu16i, aC_S_BFu16i)
//============================================================================



static void Test_aC_S_BFu16ll()
{
  {
    init_simple_test("aC_S_BFu16ll");
    static STRUCT_IF_C aC_S_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_S_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aC_S_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aC_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu16ll, aC_S_BFu16ll)
//============================================================================



static void Test_aC_S_BFu16s()
{
  {
    init_simple_test("aC_S_BFu16s");
    static STRUCT_IF_C aC_S_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aC_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_S_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aC_S_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aC_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu16s, aC_S_BFu16s)
//============================================================================



static void Test_aC_S_BFu17i()
{
  {
    init_simple_test("aC_S_BFu17i");
    static STRUCT_IF_C aC_S_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aC_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_S_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aC_S_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aC_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu17i, aC_S_BFu17i)
//============================================================================



static void Test_aC_S_BFu17ll()
{
  {
    init_simple_test("aC_S_BFu17ll");
    static STRUCT_IF_C aC_S_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_S_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aC_S_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aC_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu17ll, aC_S_BFu17ll)
//============================================================================



static void Test_aC_S_BFu1c()
{
  {
    init_simple_test("aC_S_BFu1c");
    static STRUCT_IF_C aC_S_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_S_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aC_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu1c, aC_S_BFu1c)
//============================================================================



static void Test_aC_S_BFu1i()
{
  {
    init_simple_test("aC_S_BFu1i");
    static STRUCT_IF_C aC_S_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_S_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aC_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu1i, aC_S_BFu1i)
//============================================================================



static void Test_aC_S_BFu1ll()
{
  {
    init_simple_test("aC_S_BFu1ll");
    static STRUCT_IF_C aC_S_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_S_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aC_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu1ll, aC_S_BFu1ll)
//============================================================================



static void Test_aC_S_BFu1s()
{
  {
    init_simple_test("aC_S_BFu1s");
    static STRUCT_IF_C aC_S_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_S_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aC_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu1s, aC_S_BFu1s)
//============================================================================



static void Test_aC_S_BFu31i()
{
  {
    init_simple_test("aC_S_BFu31i");
    static STRUCT_IF_C aC_S_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aC_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_S_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aC_S_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aC_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu31i, aC_S_BFu31i)
//============================================================================



static void Test_aC_S_BFu31ll()
{
  {
    init_simple_test("aC_S_BFu31ll");
    static STRUCT_IF_C aC_S_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_S_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aC_S_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aC_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu31ll, aC_S_BFu31ll)
//============================================================================



static void Test_aC_S_BFu32i()
{
  {
    init_simple_test("aC_S_BFu32i");
    static STRUCT_IF_C aC_S_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aC_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_S_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aC_S_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aC_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu32i, aC_S_BFu32i)
//============================================================================



static void Test_aC_S_BFu32ll()
{
  {
    init_simple_test("aC_S_BFu32ll");
    static STRUCT_IF_C aC_S_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_S_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aC_S_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aC_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu32ll, aC_S_BFu32ll)
//============================================================================



static void Test_aC_S_BFu33()
{
  {
    init_simple_test("aC_S_BFu33");
    static STRUCT_IF_C aC_S_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aC_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu33)");
    check_field_offset(lv, v1, 0, "aC_S_BFu33.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aC_S_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aC_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu33, aC_S_BFu33)
//============================================================================



static void Test_aC_S_BFu7c()
{
  {
    init_simple_test("aC_S_BFu7c");
    static STRUCT_IF_C aC_S_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_S_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aC_S_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aC_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu7c, aC_S_BFu7c)
//============================================================================



static void Test_aC_S_BFu7i()
{
  {
    init_simple_test("aC_S_BFu7i");
    static STRUCT_IF_C aC_S_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_S_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aC_S_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aC_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu7i, aC_S_BFu7i)
//============================================================================



static void Test_aC_S_BFu7ll()
{
  {
    init_simple_test("aC_S_BFu7ll");
    static STRUCT_IF_C aC_S_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_S_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aC_S_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aC_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu7ll, aC_S_BFu7ll)
//============================================================================



static void Test_aC_S_BFu7s()
{
  {
    init_simple_test("aC_S_BFu7s");
    static STRUCT_IF_C aC_S_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_S_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aC_S_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aC_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu7s, aC_S_BFu7s)
//============================================================================



static void Test_aC_S_BFu8c()
{
  {
    init_simple_test("aC_S_BFu8c");
    static STRUCT_IF_C aC_S_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_S_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aC_S_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aC_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu8c, aC_S_BFu8c)
//============================================================================



static void Test_aC_S_BFu8i()
{
  {
    init_simple_test("aC_S_BFu8i");
    static STRUCT_IF_C aC_S_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_S_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aC_S_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aC_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu8i, aC_S_BFu8i)
//============================================================================



static void Test_aC_S_BFu8ll()
{
  {
    init_simple_test("aC_S_BFu8ll");
    static STRUCT_IF_C aC_S_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_S_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aC_S_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aC_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu8ll, aC_S_BFu8ll)
//============================================================================



static void Test_aC_S_BFu8s()
{
  {
    init_simple_test("aC_S_BFu8s");
    static STRUCT_IF_C aC_S_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_S_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aC_S_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aC_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu8s, aC_S_BFu8s)
//============================================================================



static void Test_aC_S_BFu9i()
{
  {
    init_simple_test("aC_S_BFu9i");
    static STRUCT_IF_C aC_S_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aC_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_S_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aC_S_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aC_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu9i, aC_S_BFu9i)
//============================================================================



static void Test_aC_S_BFu9ll()
{
  {
    init_simple_test("aC_S_BFu9ll");
    static STRUCT_IF_C aC_S_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_S_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aC_S_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aC_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu9ll, aC_S_BFu9ll)
//============================================================================



static void Test_aC_S_BFu9s()
{
  {
    init_simple_test("aC_S_BFu9s");
    static STRUCT_IF_C aC_S_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aC_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_S_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aC_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aC_S_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aC_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_BFu9s, aC_S_BFu9s)
//============================================================================



static void Test_aC_S_C()
{
  {
    init_simple_test("aC_S_C");
    STRUCT_IF_C aC_S_C lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_C)");
    check_field_offset(lv, v1, 0, "aC_S_C.v1");
    check_field_offset(lv, v2, 1, "aC_S_C.v2");
    check_field_offset(lv, v3, 3, "aC_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_C, aC_S_C)
//============================================================================



static void Test_aC_S_D()
{
  {
    init_simple_test("aC_S_D");
    STRUCT_IF_C aC_S_D lv;
    check2(sizeof(lv), 11, "sizeof(aC_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_D)");
    check_field_offset(lv, v1, 0, "aC_S_D.v1");
    check_field_offset(lv, v2, 1, "aC_S_D.v2");
    check_field_offset(lv, v3, 3, "aC_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_D, aC_S_D)
//============================================================================



static void Test_aC_S_F()
{
  {
    init_simple_test("aC_S_F");
    STRUCT_IF_C aC_S_F lv;
    check2(sizeof(lv), 7, "sizeof(aC_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_F)");
    check_field_offset(lv, v1, 0, "aC_S_F.v1");
    check_field_offset(lv, v2, 1, "aC_S_F.v2");
    check_field_offset(lv, v3, 3, "aC_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_F, aC_S_F)
//============================================================================



static void Test_aC_S_I()
{
  {
    init_simple_test("aC_S_I");
    STRUCT_IF_C aC_S_I lv;
    check2(sizeof(lv), 7, "sizeof(aC_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_I)");
    check_field_offset(lv, v1, 0, "aC_S_I.v1");
    check_field_offset(lv, v2, 1, "aC_S_I.v2");
    check_field_offset(lv, v3, 3, "aC_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_I, aC_S_I)
//============================================================================



static void Test_aC_S_Ip()
{
  {
    init_simple_test("aC_S_Ip");
    STRUCT_IF_C aC_S_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_Ip)");
    check_field_offset(lv, v1, 0, "aC_S_Ip.v1");
    check_field_offset(lv, v2, 1, "aC_S_Ip.v2");
    check_field_offset(lv, v3, 3, "aC_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_Ip, aC_S_Ip)
//============================================================================



static void Test_aC_S_L()
{
  {
    init_simple_test("aC_S_L");
    STRUCT_IF_C aC_S_L lv;
    check2(sizeof(lv), 11, "sizeof(aC_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_L)");
    check_field_offset(lv, v1, 0, "aC_S_L.v1");
    check_field_offset(lv, v2, 1, "aC_S_L.v2");
    check_field_offset(lv, v3, 3, "aC_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_L, aC_S_L)
//============================================================================



static void Test_aC_S_S()
{
  {
    init_simple_test("aC_S_S");
    STRUCT_IF_C aC_S_S lv;
    check2(sizeof(lv), 5, "sizeof(aC_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_S)");
    check_field_offset(lv, v1, 0, "aC_S_S.v1");
    check_field_offset(lv, v2, 1, "aC_S_S.v2");
    check_field_offset(lv, v3, 3, "aC_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_S, aC_S_S)
//============================================================================



static void Test_aC_S_Uc()
{
  {
    init_simple_test("aC_S_Uc");
    STRUCT_IF_C aC_S_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aC_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_Uc)");
    check_field_offset(lv, v1, 0, "aC_S_Uc.v1");
    check_field_offset(lv, v2, 1, "aC_S_Uc.v2");
    check_field_offset(lv, v3, 3, "aC_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_Uc, aC_S_Uc)
//============================================================================



static void Test_aC_S_Ui()
{
  {
    init_simple_test("aC_S_Ui");
    STRUCT_IF_C aC_S_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aC_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_Ui)");
    check_field_offset(lv, v1, 0, "aC_S_Ui.v1");
    check_field_offset(lv, v2, 1, "aC_S_Ui.v2");
    check_field_offset(lv, v3, 3, "aC_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_Ui, aC_S_Ui)
//============================================================================



static void Test_aC_S_Ul()
{
  {
    init_simple_test("aC_S_Ul");
    STRUCT_IF_C aC_S_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aC_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_Ul)");
    check_field_offset(lv, v1, 0, "aC_S_Ul.v1");
    check_field_offset(lv, v2, 1, "aC_S_Ul.v2");
    check_field_offset(lv, v3, 3, "aC_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_Ul, aC_S_Ul)
//============================================================================



static void Test_aC_S_Us()
{
  {
    init_simple_test("aC_S_Us");
    STRUCT_IF_C aC_S_Us lv;
    check2(sizeof(lv), 5, "sizeof(aC_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_Us)");
    check_field_offset(lv, v1, 0, "aC_S_Us.v1");
    check_field_offset(lv, v2, 1, "aC_S_Us.v2");
    check_field_offset(lv, v3, 3, "aC_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_Us, aC_S_Us)
//============================================================================



static void Test_aC_S_Vp()
{
  {
    init_simple_test("aC_S_Vp");
    STRUCT_IF_C aC_S_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_S_Vp)");
    check_field_offset(lv, v1, 0, "aC_S_Vp.v1");
    check_field_offset(lv, v2, 1, "aC_S_Vp.v2");
    check_field_offset(lv, v3, 3, "aC_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_S_Vp, aC_S_Vp)
//============================================================================



static void Test_aC_Uc()
{
  {
    init_simple_test("aC_Uc");
    STRUCT_IF_C aC_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aC_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc)");
    check_field_offset(lv, v1, 0, "aC_Uc.v1");
    check_field_offset(lv, v2, 1, "aC_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc, aC_Uc)
//============================================================================



static void Test_aC_Uc_BFu15i()
{
  {
    init_simple_test("aC_Uc_BFu15i");
    static STRUCT_IF_C aC_Uc_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aC_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_Uc_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu15i, aC_Uc_BFu15i)
//============================================================================



static void Test_aC_Uc_BFu15ll()
{
  {
    init_simple_test("aC_Uc_BFu15ll");
    static STRUCT_IF_C aC_Uc_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu15ll, aC_Uc_BFu15ll)
//============================================================================



static void Test_aC_Uc_BFu15s()
{
  {
    init_simple_test("aC_Uc_BFu15s");
    static STRUCT_IF_C aC_Uc_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aC_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aC_Uc_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aC_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu15s, aC_Uc_BFu15s)
//============================================================================



static void Test_aC_Uc_BFu16i()
{
  {
    init_simple_test("aC_Uc_BFu16i");
    static STRUCT_IF_C aC_Uc_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aC_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_Uc_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu16i, aC_Uc_BFu16i)
//============================================================================



static void Test_aC_Uc_BFu16ll()
{
  {
    init_simple_test("aC_Uc_BFu16ll");
    static STRUCT_IF_C aC_Uc_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu16ll, aC_Uc_BFu16ll)
//============================================================================



static void Test_aC_Uc_BFu16s()
{
  {
    init_simple_test("aC_Uc_BFu16s");
    static STRUCT_IF_C aC_Uc_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aC_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aC_Uc_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aC_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu16s, aC_Uc_BFu16s)
//============================================================================



static void Test_aC_Uc_BFu17i()
{
  {
    init_simple_test("aC_Uc_BFu17i");
    static STRUCT_IF_C aC_Uc_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aC_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aC_Uc_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aC_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu17i, aC_Uc_BFu17i)
//============================================================================



static void Test_aC_Uc_BFu17ll()
{
  {
    init_simple_test("aC_Uc_BFu17ll");
    static STRUCT_IF_C aC_Uc_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aC_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aC_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu17ll, aC_Uc_BFu17ll)
//============================================================================



static void Test_aC_Uc_BFu1c()
{
  {
    init_simple_test("aC_Uc_BFu1c");
    static STRUCT_IF_C aC_Uc_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu1c, aC_Uc_BFu1c)
//============================================================================



static void Test_aC_Uc_BFu1i()
{
  {
    init_simple_test("aC_Uc_BFu1i");
    static STRUCT_IF_C aC_Uc_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu1i, aC_Uc_BFu1i)
//============================================================================



static void Test_aC_Uc_BFu1ll()
{
  {
    init_simple_test("aC_Uc_BFu1ll");
    static STRUCT_IF_C aC_Uc_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu1ll, aC_Uc_BFu1ll)
//============================================================================



static void Test_aC_Uc_BFu1s()
{
  {
    init_simple_test("aC_Uc_BFu1s");
    static STRUCT_IF_C aC_Uc_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aC_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu1s, aC_Uc_BFu1s)
//============================================================================



static void Test_aC_Uc_BFu31i()
{
  {
    init_simple_test("aC_Uc_BFu31i");
    static STRUCT_IF_C aC_Uc_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aC_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aC_Uc_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aC_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu31i, aC_Uc_BFu31i)
//============================================================================



static void Test_aC_Uc_BFu31ll()
{
  {
    init_simple_test("aC_Uc_BFu31ll");
    static STRUCT_IF_C aC_Uc_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aC_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aC_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu31ll, aC_Uc_BFu31ll)
//============================================================================



static void Test_aC_Uc_BFu32i()
{
  {
    init_simple_test("aC_Uc_BFu32i");
    static STRUCT_IF_C aC_Uc_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aC_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aC_Uc_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aC_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu32i, aC_Uc_BFu32i)
//============================================================================



static void Test_aC_Uc_BFu32ll()
{
  {
    init_simple_test("aC_Uc_BFu32ll");
    static STRUCT_IF_C aC_Uc_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aC_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aC_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu32ll, aC_Uc_BFu32ll)
//============================================================================



static void Test_aC_Uc_BFu33()
{
  {
    init_simple_test("aC_Uc_BFu33");
    static STRUCT_IF_C aC_Uc_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aC_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu33.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aC_Uc_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aC_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu33, aC_Uc_BFu33)
//============================================================================



static void Test_aC_Uc_BFu7c()
{
  {
    init_simple_test("aC_Uc_BFu7c");
    static STRUCT_IF_C aC_Uc_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_Uc_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu7c, aC_Uc_BFu7c)
//============================================================================



static void Test_aC_Uc_BFu7i()
{
  {
    init_simple_test("aC_Uc_BFu7i");
    static STRUCT_IF_C aC_Uc_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_Uc_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu7i, aC_Uc_BFu7i)
//============================================================================



static void Test_aC_Uc_BFu7ll()
{
  {
    init_simple_test("aC_Uc_BFu7ll");
    static STRUCT_IF_C aC_Uc_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu7ll, aC_Uc_BFu7ll)
//============================================================================



static void Test_aC_Uc_BFu7s()
{
  {
    init_simple_test("aC_Uc_BFu7s");
    static STRUCT_IF_C aC_Uc_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aC_Uc_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aC_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu7s, aC_Uc_BFu7s)
//============================================================================



static void Test_aC_Uc_BFu8c()
{
  {
    init_simple_test("aC_Uc_BFu8c");
    static STRUCT_IF_C aC_Uc_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_Uc_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu8c, aC_Uc_BFu8c)
//============================================================================



static void Test_aC_Uc_BFu8i()
{
  {
    init_simple_test("aC_Uc_BFu8i");
    static STRUCT_IF_C aC_Uc_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_Uc_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu8i, aC_Uc_BFu8i)
//============================================================================



static void Test_aC_Uc_BFu8ll()
{
  {
    init_simple_test("aC_Uc_BFu8ll");
    static STRUCT_IF_C aC_Uc_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu8ll, aC_Uc_BFu8ll)
//============================================================================



static void Test_aC_Uc_BFu8s()
{
  {
    init_simple_test("aC_Uc_BFu8s");
    static STRUCT_IF_C aC_Uc_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aC_Uc_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aC_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu8s, aC_Uc_BFu8s)
//============================================================================



static void Test_aC_Uc_BFu9i()
{
  {
    init_simple_test("aC_Uc_BFu9i");
    static STRUCT_IF_C aC_Uc_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aC_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_Uc_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu9i, aC_Uc_BFu9i)
//============================================================================



static void Test_aC_Uc_BFu9ll()
{
  {
    init_simple_test("aC_Uc_BFu9ll");
    static STRUCT_IF_C aC_Uc_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu9ll, aC_Uc_BFu9ll)
//============================================================================



static void Test_aC_Uc_BFu9s()
{
  {
    init_simple_test("aC_Uc_BFu9s");
    static STRUCT_IF_C aC_Uc_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aC_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_Uc_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aC_Uc_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aC_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_BFu9s, aC_Uc_BFu9s)
//============================================================================



static void Test_aC_Uc_C()
{
  {
    init_simple_test("aC_Uc_C");
    STRUCT_IF_C aC_Uc_C lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_C)");
    check_field_offset(lv, v1, 0, "aC_Uc_C.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_C.v2");
    check_field_offset(lv, v3, 2, "aC_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_C, aC_Uc_C)
//============================================================================



static void Test_aC_Uc_D()
{
  {
    init_simple_test("aC_Uc_D");
    STRUCT_IF_C aC_Uc_D lv;
    check2(sizeof(lv), 10, "sizeof(aC_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_D)");
    check_field_offset(lv, v1, 0, "aC_Uc_D.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_D.v2");
    check_field_offset(lv, v3, 2, "aC_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_D, aC_Uc_D)
//============================================================================



static void Test_aC_Uc_F()
{
  {
    init_simple_test("aC_Uc_F");
    STRUCT_IF_C aC_Uc_F lv;
    check2(sizeof(lv), 6, "sizeof(aC_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_F)");
    check_field_offset(lv, v1, 0, "aC_Uc_F.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_F.v2");
    check_field_offset(lv, v3, 2, "aC_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_F, aC_Uc_F)
//============================================================================



static void Test_aC_Uc_I()
{
  {
    init_simple_test("aC_Uc_I");
    STRUCT_IF_C aC_Uc_I lv;
    check2(sizeof(lv), 6, "sizeof(aC_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_I)");
    check_field_offset(lv, v1, 0, "aC_Uc_I.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_I.v2");
    check_field_offset(lv, v3, 2, "aC_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_I, aC_Uc_I)
//============================================================================



static void Test_aC_Uc_Ip()
{
  {
    init_simple_test("aC_Uc_Ip");
    STRUCT_IF_C aC_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_Ip)");
    check_field_offset(lv, v1, 0, "aC_Uc_Ip.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_Ip.v2");
    check_field_offset(lv, v3, 2, "aC_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_Ip, aC_Uc_Ip)
//============================================================================



static void Test_aC_Uc_L()
{
  {
    init_simple_test("aC_Uc_L");
    STRUCT_IF_C aC_Uc_L lv;
    check2(sizeof(lv), 10, "sizeof(aC_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_L)");
    check_field_offset(lv, v1, 0, "aC_Uc_L.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_L.v2");
    check_field_offset(lv, v3, 2, "aC_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_L, aC_Uc_L)
//============================================================================



static void Test_aC_Uc_S()
{
  {
    init_simple_test("aC_Uc_S");
    STRUCT_IF_C aC_Uc_S lv;
    check2(sizeof(lv), 4, "sizeof(aC_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_S)");
    check_field_offset(lv, v1, 0, "aC_Uc_S.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_S.v2");
    check_field_offset(lv, v3, 2, "aC_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_S, aC_Uc_S)
//============================================================================



static void Test_aC_Uc_Uc()
{
  {
    init_simple_test("aC_Uc_Uc");
    STRUCT_IF_C aC_Uc_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aC_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_Uc)");
    check_field_offset(lv, v1, 0, "aC_Uc_Uc.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_Uc.v2");
    check_field_offset(lv, v3, 2, "aC_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_Uc, aC_Uc_Uc)
//============================================================================



static void Test_aC_Uc_Ui()
{
  {
    init_simple_test("aC_Uc_Ui");
    STRUCT_IF_C aC_Uc_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aC_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_Ui)");
    check_field_offset(lv, v1, 0, "aC_Uc_Ui.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_Ui.v2");
    check_field_offset(lv, v3, 2, "aC_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_Ui, aC_Uc_Ui)
//============================================================================



static void Test_aC_Uc_Ul()
{
  {
    init_simple_test("aC_Uc_Ul");
    STRUCT_IF_C aC_Uc_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aC_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_Ul)");
    check_field_offset(lv, v1, 0, "aC_Uc_Ul.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_Ul.v2");
    check_field_offset(lv, v3, 2, "aC_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_Ul, aC_Uc_Ul)
//============================================================================



static void Test_aC_Uc_Us()
{
  {
    init_simple_test("aC_Uc_Us");
    STRUCT_IF_C aC_Uc_Us lv;
    check2(sizeof(lv), 4, "sizeof(aC_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_Us)");
    check_field_offset(lv, v1, 0, "aC_Uc_Us.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_Us.v2");
    check_field_offset(lv, v3, 2, "aC_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_Us, aC_Uc_Us)
//============================================================================



static void Test_aC_Uc_Vp()
{
  {
    init_simple_test("aC_Uc_Vp");
    STRUCT_IF_C aC_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Uc_Vp)");
    check_field_offset(lv, v1, 0, "aC_Uc_Vp.v1");
    check_field_offset(lv, v2, 1, "aC_Uc_Vp.v2");
    check_field_offset(lv, v3, 2, "aC_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Uc_Vp, aC_Uc_Vp)
//============================================================================



static void Test_aC_Ui()
{
  {
    init_simple_test("aC_Ui");
    STRUCT_IF_C aC_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aC_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui)");
    check_field_offset(lv, v1, 0, "aC_Ui.v1");
    check_field_offset(lv, v2, 1, "aC_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui, aC_Ui)
//============================================================================



static void Test_aC_Ui_BFu15i()
{
  {
    init_simple_test("aC_Ui_BFu15i");
    static STRUCT_IF_C aC_Ui_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aC_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aC_Ui_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aC_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu15i, aC_Ui_BFu15i)
//============================================================================



static void Test_aC_Ui_BFu15ll()
{
  {
    init_simple_test("aC_Ui_BFu15ll");
    static STRUCT_IF_C aC_Ui_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aC_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aC_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu15ll, aC_Ui_BFu15ll)
//============================================================================



static void Test_aC_Ui_BFu15s()
{
  {
    init_simple_test("aC_Ui_BFu15s");
    static STRUCT_IF_C aC_Ui_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aC_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aC_Ui_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aC_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu15s, aC_Ui_BFu15s)
//============================================================================



static void Test_aC_Ui_BFu16i()
{
  {
    init_simple_test("aC_Ui_BFu16i");
    static STRUCT_IF_C aC_Ui_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aC_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aC_Ui_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aC_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu16i, aC_Ui_BFu16i)
//============================================================================



static void Test_aC_Ui_BFu16ll()
{
  {
    init_simple_test("aC_Ui_BFu16ll");
    static STRUCT_IF_C aC_Ui_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aC_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aC_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu16ll, aC_Ui_BFu16ll)
//============================================================================



static void Test_aC_Ui_BFu16s()
{
  {
    init_simple_test("aC_Ui_BFu16s");
    static STRUCT_IF_C aC_Ui_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aC_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aC_Ui_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aC_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu16s, aC_Ui_BFu16s)
//============================================================================



static void Test_aC_Ui_BFu17i()
{
  {
    init_simple_test("aC_Ui_BFu17i");
    static STRUCT_IF_C aC_Ui_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aC_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aC_Ui_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aC_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu17i, aC_Ui_BFu17i)
//============================================================================



static void Test_aC_Ui_BFu17ll()
{
  {
    init_simple_test("aC_Ui_BFu17ll");
    static STRUCT_IF_C aC_Ui_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aC_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aC_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aC_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu17ll, aC_Ui_BFu17ll)
//============================================================================



static void Test_aC_Ui_BFu1c()
{
  {
    init_simple_test("aC_Ui_BFu1c");
    static STRUCT_IF_C aC_Ui_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aC_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu1c, aC_Ui_BFu1c)
//============================================================================



static void Test_aC_Ui_BFu1i()
{
  {
    init_simple_test("aC_Ui_BFu1i");
    static STRUCT_IF_C aC_Ui_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aC_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu1i, aC_Ui_BFu1i)
//============================================================================



static void Test_aC_Ui_BFu1ll()
{
  {
    init_simple_test("aC_Ui_BFu1ll");
    static STRUCT_IF_C aC_Ui_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aC_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu1ll, aC_Ui_BFu1ll)
//============================================================================



static void Test_aC_Ui_BFu1s()
{
  {
    init_simple_test("aC_Ui_BFu1s");
    static STRUCT_IF_C aC_Ui_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aC_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu1s, aC_Ui_BFu1s)
//============================================================================



static void Test_aC_Ui_BFu31i()
{
  {
    init_simple_test("aC_Ui_BFu31i");
    static STRUCT_IF_C aC_Ui_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aC_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aC_Ui_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aC_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu31i, aC_Ui_BFu31i)
//============================================================================



static void Test_aC_Ui_BFu31ll()
{
  {
    init_simple_test("aC_Ui_BFu31ll");
    static STRUCT_IF_C aC_Ui_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aC_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aC_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aC_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu31ll, aC_Ui_BFu31ll)
//============================================================================



static void Test_aC_Ui_BFu32i()
{
  {
    init_simple_test("aC_Ui_BFu32i");
    static STRUCT_IF_C aC_Ui_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aC_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aC_Ui_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aC_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu32i, aC_Ui_BFu32i)
//============================================================================



static void Test_aC_Ui_BFu32ll()
{
  {
    init_simple_test("aC_Ui_BFu32ll");
    static STRUCT_IF_C aC_Ui_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aC_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aC_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aC_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu32ll, aC_Ui_BFu32ll)
//============================================================================



static void Test_aC_Ui_BFu33()
{
  {
    init_simple_test("aC_Ui_BFu33");
    static STRUCT_IF_C aC_Ui_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu33.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aC_Ui_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aC_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu33, aC_Ui_BFu33)
//============================================================================



static void Test_aC_Ui_BFu7c()
{
  {
    init_simple_test("aC_Ui_BFu7c");
    static STRUCT_IF_C aC_Ui_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aC_Ui_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aC_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu7c, aC_Ui_BFu7c)
//============================================================================



static void Test_aC_Ui_BFu7i()
{
  {
    init_simple_test("aC_Ui_BFu7i");
    static STRUCT_IF_C aC_Ui_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aC_Ui_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aC_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu7i, aC_Ui_BFu7i)
//============================================================================



static void Test_aC_Ui_BFu7ll()
{
  {
    init_simple_test("aC_Ui_BFu7ll");
    static STRUCT_IF_C aC_Ui_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aC_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aC_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu7ll, aC_Ui_BFu7ll)
//============================================================================



static void Test_aC_Ui_BFu7s()
{
  {
    init_simple_test("aC_Ui_BFu7s");
    static STRUCT_IF_C aC_Ui_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aC_Ui_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aC_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu7s, aC_Ui_BFu7s)
//============================================================================



static void Test_aC_Ui_BFu8c()
{
  {
    init_simple_test("aC_Ui_BFu8c");
    static STRUCT_IF_C aC_Ui_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aC_Ui_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aC_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu8c, aC_Ui_BFu8c)
//============================================================================



static void Test_aC_Ui_BFu8i()
{
  {
    init_simple_test("aC_Ui_BFu8i");
    static STRUCT_IF_C aC_Ui_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aC_Ui_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aC_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu8i, aC_Ui_BFu8i)
//============================================================================



static void Test_aC_Ui_BFu8ll()
{
  {
    init_simple_test("aC_Ui_BFu8ll");
    static STRUCT_IF_C aC_Ui_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aC_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aC_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu8ll, aC_Ui_BFu8ll)
//============================================================================



static void Test_aC_Ui_BFu8s()
{
  {
    init_simple_test("aC_Ui_BFu8s");
    static STRUCT_IF_C aC_Ui_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aC_Ui_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aC_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu8s, aC_Ui_BFu8s)
//============================================================================



static void Test_aC_Ui_BFu9i()
{
  {
    init_simple_test("aC_Ui_BFu9i");
    static STRUCT_IF_C aC_Ui_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aC_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aC_Ui_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aC_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu9i, aC_Ui_BFu9i)
//============================================================================



static void Test_aC_Ui_BFu9ll()
{
  {
    init_simple_test("aC_Ui_BFu9ll");
    static STRUCT_IF_C aC_Ui_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aC_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aC_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu9ll, aC_Ui_BFu9ll)
//============================================================================



static void Test_aC_Ui_BFu9s()
{
  {
    init_simple_test("aC_Ui_BFu9s");
    static STRUCT_IF_C aC_Ui_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aC_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aC_Ui_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aC_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_BFu9s, aC_Ui_BFu9s)
//============================================================================



static void Test_aC_Ui_C()
{
  {
    init_simple_test("aC_Ui_C");
    STRUCT_IF_C aC_Ui_C lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_C)");
    check_field_offset(lv, v1, 0, "aC_Ui_C.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_C.v2");
    check_field_offset(lv, v3, 5, "aC_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_C, aC_Ui_C)
//============================================================================



static void Test_aC_Ui_D()
{
  {
    init_simple_test("aC_Ui_D");
    STRUCT_IF_C aC_Ui_D lv;
    check2(sizeof(lv), 13, "sizeof(aC_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_D)");
    check_field_offset(lv, v1, 0, "aC_Ui_D.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_D.v2");
    check_field_offset(lv, v3, 5, "aC_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_D, aC_Ui_D)
//============================================================================



static void Test_aC_Ui_F()
{
  {
    init_simple_test("aC_Ui_F");
    STRUCT_IF_C aC_Ui_F lv;
    check2(sizeof(lv), 9, "sizeof(aC_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_F)");
    check_field_offset(lv, v1, 0, "aC_Ui_F.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_F.v2");
    check_field_offset(lv, v3, 5, "aC_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_F, aC_Ui_F)
//============================================================================



static void Test_aC_Ui_I()
{
  {
    init_simple_test("aC_Ui_I");
    STRUCT_IF_C aC_Ui_I lv;
    check2(sizeof(lv), 9, "sizeof(aC_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_I)");
    check_field_offset(lv, v1, 0, "aC_Ui_I.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_I.v2");
    check_field_offset(lv, v3, 5, "aC_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_I, aC_Ui_I)
//============================================================================



static void Test_aC_Ui_Ip()
{
  {
    init_simple_test("aC_Ui_Ip");
    STRUCT_IF_C aC_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_Ip)");
    check_field_offset(lv, v1, 0, "aC_Ui_Ip.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_Ip.v2");
    check_field_offset(lv, v3, 5, "aC_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_Ip, aC_Ui_Ip)
//============================================================================



static void Test_aC_Ui_L()
{
  {
    init_simple_test("aC_Ui_L");
    STRUCT_IF_C aC_Ui_L lv;
    check2(sizeof(lv), 13, "sizeof(aC_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_L)");
    check_field_offset(lv, v1, 0, "aC_Ui_L.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_L.v2");
    check_field_offset(lv, v3, 5, "aC_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_L, aC_Ui_L)
//============================================================================



static void Test_aC_Ui_S()
{
  {
    init_simple_test("aC_Ui_S");
    STRUCT_IF_C aC_Ui_S lv;
    check2(sizeof(lv), 7, "sizeof(aC_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_S)");
    check_field_offset(lv, v1, 0, "aC_Ui_S.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_S.v2");
    check_field_offset(lv, v3, 5, "aC_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_S, aC_Ui_S)
//============================================================================



static void Test_aC_Ui_Uc()
{
  {
    init_simple_test("aC_Ui_Uc");
    STRUCT_IF_C aC_Ui_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aC_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_Uc)");
    check_field_offset(lv, v1, 0, "aC_Ui_Uc.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_Uc.v2");
    check_field_offset(lv, v3, 5, "aC_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_Uc, aC_Ui_Uc)
//============================================================================



static void Test_aC_Ui_Ui()
{
  {
    init_simple_test("aC_Ui_Ui");
    STRUCT_IF_C aC_Ui_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aC_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_Ui)");
    check_field_offset(lv, v1, 0, "aC_Ui_Ui.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_Ui.v2");
    check_field_offset(lv, v3, 5, "aC_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_Ui, aC_Ui_Ui)
//============================================================================



static void Test_aC_Ui_Ul()
{
  {
    init_simple_test("aC_Ui_Ul");
    STRUCT_IF_C aC_Ui_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aC_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_Ul)");
    check_field_offset(lv, v1, 0, "aC_Ui_Ul.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_Ul.v2");
    check_field_offset(lv, v3, 5, "aC_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_Ul, aC_Ui_Ul)
//============================================================================



static void Test_aC_Ui_Us()
{
  {
    init_simple_test("aC_Ui_Us");
    STRUCT_IF_C aC_Ui_Us lv;
    check2(sizeof(lv), 7, "sizeof(aC_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_Us)");
    check_field_offset(lv, v1, 0, "aC_Ui_Us.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_Us.v2");
    check_field_offset(lv, v3, 5, "aC_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_Us, aC_Ui_Us)
//============================================================================



static void Test_aC_Ui_Vp()
{
  {
    init_simple_test("aC_Ui_Vp");
    STRUCT_IF_C aC_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ui_Vp)");
    check_field_offset(lv, v1, 0, "aC_Ui_Vp.v1");
    check_field_offset(lv, v2, 1, "aC_Ui_Vp.v2");
    check_field_offset(lv, v3, 5, "aC_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ui_Vp, aC_Ui_Vp)
//============================================================================



static void Test_aC_Ul()
{
  {
    init_simple_test("aC_Ul");
    STRUCT_IF_C aC_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aC_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul)");
    check_field_offset(lv, v1, 0, "aC_Ul.v1");
    check_field_offset(lv, v2, 1, "aC_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul, aC_Ul)
//============================================================================



static void Test_aC_Ul_BFu15i()
{
  {
    init_simple_test("aC_Ul_BFu15i");
    static STRUCT_IF_C aC_Ul_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aC_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aC_Ul_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aC_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu15i, aC_Ul_BFu15i)
//============================================================================



static void Test_aC_Ul_BFu15ll()
{
  {
    init_simple_test("aC_Ul_BFu15ll");
    static STRUCT_IF_C aC_Ul_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aC_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aC_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aC_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu15ll, aC_Ul_BFu15ll)
//============================================================================



static void Test_aC_Ul_BFu15s()
{
  {
    init_simple_test("aC_Ul_BFu15s");
    static STRUCT_IF_C aC_Ul_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aC_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aC_Ul_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aC_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu15s, aC_Ul_BFu15s)
//============================================================================



static void Test_aC_Ul_BFu16i()
{
  {
    init_simple_test("aC_Ul_BFu16i");
    static STRUCT_IF_C aC_Ul_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(aC_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aC_Ul_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aC_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu16i, aC_Ul_BFu16i)
//============================================================================



static void Test_aC_Ul_BFu16ll()
{
  {
    init_simple_test("aC_Ul_BFu16ll");
    static STRUCT_IF_C aC_Ul_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(aC_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aC_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aC_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu16ll, aC_Ul_BFu16ll)
//============================================================================



static void Test_aC_Ul_BFu16s()
{
  {
    init_simple_test("aC_Ul_BFu16s");
    static STRUCT_IF_C aC_Ul_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(aC_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aC_Ul_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aC_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu16s, aC_Ul_BFu16s)
//============================================================================



static void Test_aC_Ul_BFu17i()
{
  {
    init_simple_test("aC_Ul_BFu17i");
    static STRUCT_IF_C aC_Ul_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aC_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aC_Ul_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aC_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu17i, aC_Ul_BFu17i)
//============================================================================



static void Test_aC_Ul_BFu17ll()
{
  {
    init_simple_test("aC_Ul_BFu17ll");
    static STRUCT_IF_C aC_Ul_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aC_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aC_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aC_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu17ll, aC_Ul_BFu17ll)
//============================================================================



static void Test_aC_Ul_BFu1c()
{
  {
    init_simple_test("aC_Ul_BFu1c");
    static STRUCT_IF_C aC_Ul_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aC_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu1c, aC_Ul_BFu1c)
//============================================================================



static void Test_aC_Ul_BFu1i()
{
  {
    init_simple_test("aC_Ul_BFu1i");
    static STRUCT_IF_C aC_Ul_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aC_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu1i, aC_Ul_BFu1i)
//============================================================================



static void Test_aC_Ul_BFu1ll()
{
  {
    init_simple_test("aC_Ul_BFu1ll");
    static STRUCT_IF_C aC_Ul_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aC_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu1ll, aC_Ul_BFu1ll)
//============================================================================



static void Test_aC_Ul_BFu1s()
{
  {
    init_simple_test("aC_Ul_BFu1s");
    static STRUCT_IF_C aC_Ul_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aC_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu1s, aC_Ul_BFu1s)
//============================================================================



static void Test_aC_Ul_BFu31i()
{
  {
    init_simple_test("aC_Ul_BFu31i");
    static STRUCT_IF_C aC_Ul_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aC_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aC_Ul_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aC_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu31i, aC_Ul_BFu31i)
//============================================================================



static void Test_aC_Ul_BFu31ll()
{
  {
    init_simple_test("aC_Ul_BFu31ll");
    static STRUCT_IF_C aC_Ul_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aC_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aC_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aC_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu31ll, aC_Ul_BFu31ll)
//============================================================================



static void Test_aC_Ul_BFu32i()
{
  {
    init_simple_test("aC_Ul_BFu32i");
    static STRUCT_IF_C aC_Ul_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aC_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aC_Ul_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aC_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu32i, aC_Ul_BFu32i)
//============================================================================



static void Test_aC_Ul_BFu32ll()
{
  {
    init_simple_test("aC_Ul_BFu32ll");
    static STRUCT_IF_C aC_Ul_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aC_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aC_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aC_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu32ll, aC_Ul_BFu32ll)
//============================================================================



static void Test_aC_Ul_BFu33()
{
  {
    init_simple_test("aC_Ul_BFu33");
    static STRUCT_IF_C aC_Ul_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aC_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu33.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aC_Ul_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aC_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu33, aC_Ul_BFu33)
//============================================================================



static void Test_aC_Ul_BFu7c()
{
  {
    init_simple_test("aC_Ul_BFu7c");
    static STRUCT_IF_C aC_Ul_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aC_Ul_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aC_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu7c, aC_Ul_BFu7c)
//============================================================================



static void Test_aC_Ul_BFu7i()
{
  {
    init_simple_test("aC_Ul_BFu7i");
    static STRUCT_IF_C aC_Ul_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aC_Ul_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aC_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu7i, aC_Ul_BFu7i)
//============================================================================



static void Test_aC_Ul_BFu7ll()
{
  {
    init_simple_test("aC_Ul_BFu7ll");
    static STRUCT_IF_C aC_Ul_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aC_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aC_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu7ll, aC_Ul_BFu7ll)
//============================================================================



static void Test_aC_Ul_BFu7s()
{
  {
    init_simple_test("aC_Ul_BFu7s");
    static STRUCT_IF_C aC_Ul_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aC_Ul_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aC_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu7s, aC_Ul_BFu7s)
//============================================================================



static void Test_aC_Ul_BFu8c()
{
  {
    init_simple_test("aC_Ul_BFu8c");
    static STRUCT_IF_C aC_Ul_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aC_Ul_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aC_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu8c, aC_Ul_BFu8c)
//============================================================================



static void Test_aC_Ul_BFu8i()
{
  {
    init_simple_test("aC_Ul_BFu8i");
    static STRUCT_IF_C aC_Ul_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aC_Ul_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aC_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu8i, aC_Ul_BFu8i)
//============================================================================



static void Test_aC_Ul_BFu8ll()
{
  {
    init_simple_test("aC_Ul_BFu8ll");
    static STRUCT_IF_C aC_Ul_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aC_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aC_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu8ll, aC_Ul_BFu8ll)
//============================================================================



static void Test_aC_Ul_BFu8s()
{
  {
    init_simple_test("aC_Ul_BFu8s");
    static STRUCT_IF_C aC_Ul_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aC_Ul_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aC_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu8s, aC_Ul_BFu8s)
//============================================================================



static void Test_aC_Ul_BFu9i()
{
  {
    init_simple_test("aC_Ul_BFu9i");
    static STRUCT_IF_C aC_Ul_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aC_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aC_Ul_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aC_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu9i, aC_Ul_BFu9i)
//============================================================================



static void Test_aC_Ul_BFu9ll()
{
  {
    init_simple_test("aC_Ul_BFu9ll");
    static STRUCT_IF_C aC_Ul_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aC_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aC_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aC_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu9ll, aC_Ul_BFu9ll)
//============================================================================



static void Test_aC_Ul_BFu9s()
{
  {
    init_simple_test("aC_Ul_BFu9s");
    static STRUCT_IF_C aC_Ul_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aC_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_Ul_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aC_Ul_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aC_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_BFu9s, aC_Ul_BFu9s)
//============================================================================



static void Test_aC_Ul_C()
{
  {
    init_simple_test("aC_Ul_C");
    STRUCT_IF_C aC_Ul_C lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_C)");
    check_field_offset(lv, v1, 0, "aC_Ul_C.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_C.v2");
    check_field_offset(lv, v3, 9, "aC_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_C, aC_Ul_C)
//============================================================================



static void Test_aC_Ul_D()
{
  {
    init_simple_test("aC_Ul_D");
    STRUCT_IF_C aC_Ul_D lv;
    check2(sizeof(lv), 17, "sizeof(aC_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_D)");
    check_field_offset(lv, v1, 0, "aC_Ul_D.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_D.v2");
    check_field_offset(lv, v3, 9, "aC_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_D, aC_Ul_D)
//============================================================================



static void Test_aC_Ul_F()
{
  {
    init_simple_test("aC_Ul_F");
    STRUCT_IF_C aC_Ul_F lv;
    check2(sizeof(lv), 13, "sizeof(aC_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_F)");
    check_field_offset(lv, v1, 0, "aC_Ul_F.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_F.v2");
    check_field_offset(lv, v3, 9, "aC_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_F, aC_Ul_F)
//============================================================================



static void Test_aC_Ul_I()
{
  {
    init_simple_test("aC_Ul_I");
    STRUCT_IF_C aC_Ul_I lv;
    check2(sizeof(lv), 13, "sizeof(aC_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_I)");
    check_field_offset(lv, v1, 0, "aC_Ul_I.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_I.v2");
    check_field_offset(lv, v3, 9, "aC_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_I, aC_Ul_I)
//============================================================================



static void Test_aC_Ul_Ip()
{
  {
    init_simple_test("aC_Ul_Ip");
    STRUCT_IF_C aC_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aC_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_Ip)");
    check_field_offset(lv, v1, 0, "aC_Ul_Ip.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_Ip.v2");
    check_field_offset(lv, v3, 9, "aC_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_Ip, aC_Ul_Ip)
//============================================================================



static void Test_aC_Ul_L()
{
  {
    init_simple_test("aC_Ul_L");
    STRUCT_IF_C aC_Ul_L lv;
    check2(sizeof(lv), 17, "sizeof(aC_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_L)");
    check_field_offset(lv, v1, 0, "aC_Ul_L.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_L.v2");
    check_field_offset(lv, v3, 9, "aC_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_L, aC_Ul_L)
//============================================================================



static void Test_aC_Ul_S()
{
  {
    init_simple_test("aC_Ul_S");
    STRUCT_IF_C aC_Ul_S lv;
    check2(sizeof(lv), 11, "sizeof(aC_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_S)");
    check_field_offset(lv, v1, 0, "aC_Ul_S.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_S.v2");
    check_field_offset(lv, v3, 9, "aC_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_S, aC_Ul_S)
//============================================================================



static void Test_aC_Ul_Uc()
{
  {
    init_simple_test("aC_Ul_Uc");
    STRUCT_IF_C aC_Ul_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aC_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_Uc)");
    check_field_offset(lv, v1, 0, "aC_Ul_Uc.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_Uc.v2");
    check_field_offset(lv, v3, 9, "aC_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_Uc, aC_Ul_Uc)
//============================================================================



static void Test_aC_Ul_Ui()
{
  {
    init_simple_test("aC_Ul_Ui");
    STRUCT_IF_C aC_Ul_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aC_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_Ui)");
    check_field_offset(lv, v1, 0, "aC_Ul_Ui.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_Ui.v2");
    check_field_offset(lv, v3, 9, "aC_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_Ui, aC_Ul_Ui)
//============================================================================



static void Test_aC_Ul_Ul()
{
  {
    init_simple_test("aC_Ul_Ul");
    STRUCT_IF_C aC_Ul_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aC_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_Ul)");
    check_field_offset(lv, v1, 0, "aC_Ul_Ul.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_Ul.v2");
    check_field_offset(lv, v3, 9, "aC_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_Ul, aC_Ul_Ul)
//============================================================================



static void Test_aC_Ul_Us()
{
  {
    init_simple_test("aC_Ul_Us");
    STRUCT_IF_C aC_Ul_Us lv;
    check2(sizeof(lv), 11, "sizeof(aC_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_Us)");
    check_field_offset(lv, v1, 0, "aC_Ul_Us.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_Us.v2");
    check_field_offset(lv, v3, 9, "aC_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_Us, aC_Ul_Us)
//============================================================================



static void Test_aC_Ul_Vp()
{
  {
    init_simple_test("aC_Ul_Vp");
    STRUCT_IF_C aC_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aC_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Ul_Vp)");
    check_field_offset(lv, v1, 0, "aC_Ul_Vp.v1");
    check_field_offset(lv, v2, 1, "aC_Ul_Vp.v2");
    check_field_offset(lv, v3, 9, "aC_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Ul_Vp, aC_Ul_Vp)
//============================================================================



static void Test_aC_Us()
{
  {
    init_simple_test("aC_Us");
    STRUCT_IF_C aC_Us lv;
    check2(sizeof(lv), 3, "sizeof(aC_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us)");
    check_field_offset(lv, v1, 0, "aC_Us.v1");
    check_field_offset(lv, v2, 1, "aC_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us, aC_Us)
//============================================================================



static void Test_aC_Us_BFu15i()
{
  {
    init_simple_test("aC_Us_BFu15i");
    static STRUCT_IF_C aC_Us_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aC_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aC_Us_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aC_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu15i, aC_Us_BFu15i)
//============================================================================



static void Test_aC_Us_BFu15ll()
{
  {
    init_simple_test("aC_Us_BFu15ll");
    static STRUCT_IF_C aC_Us_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aC_Us_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aC_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu15ll, aC_Us_BFu15ll)
//============================================================================



static void Test_aC_Us_BFu15s()
{
  {
    init_simple_test("aC_Us_BFu15s");
    static STRUCT_IF_C aC_Us_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aC_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aC_Us_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aC_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu15s, aC_Us_BFu15s)
//============================================================================



static void Test_aC_Us_BFu16i()
{
  {
    init_simple_test("aC_Us_BFu16i");
    static STRUCT_IF_C aC_Us_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aC_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aC_Us_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aC_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu16i, aC_Us_BFu16i)
//============================================================================



static void Test_aC_Us_BFu16ll()
{
  {
    init_simple_test("aC_Us_BFu16ll");
    static STRUCT_IF_C aC_Us_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aC_Us_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aC_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu16ll, aC_Us_BFu16ll)
//============================================================================



static void Test_aC_Us_BFu16s()
{
  {
    init_simple_test("aC_Us_BFu16s");
    static STRUCT_IF_C aC_Us_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aC_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aC_Us_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aC_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu16s, aC_Us_BFu16s)
//============================================================================



static void Test_aC_Us_BFu17i()
{
  {
    init_simple_test("aC_Us_BFu17i");
    static STRUCT_IF_C aC_Us_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aC_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aC_Us_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aC_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu17i, aC_Us_BFu17i)
//============================================================================



static void Test_aC_Us_BFu17ll()
{
  {
    init_simple_test("aC_Us_BFu17ll");
    static STRUCT_IF_C aC_Us_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aC_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aC_Us_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aC_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu17ll, aC_Us_BFu17ll)
//============================================================================



static void Test_aC_Us_BFu1c()
{
  {
    init_simple_test("aC_Us_BFu1c");
    static STRUCT_IF_C aC_Us_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aC_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu1c, aC_Us_BFu1c)
//============================================================================



static void Test_aC_Us_BFu1i()
{
  {
    init_simple_test("aC_Us_BFu1i");
    static STRUCT_IF_C aC_Us_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aC_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu1i, aC_Us_BFu1i)
//============================================================================



static void Test_aC_Us_BFu1ll()
{
  {
    init_simple_test("aC_Us_BFu1ll");
    static STRUCT_IF_C aC_Us_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aC_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu1ll, aC_Us_BFu1ll)
//============================================================================



static void Test_aC_Us_BFu1s()
{
  {
    init_simple_test("aC_Us_BFu1s");
    static STRUCT_IF_C aC_Us_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aC_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu1s, aC_Us_BFu1s)
//============================================================================



static void Test_aC_Us_BFu31i()
{
  {
    init_simple_test("aC_Us_BFu31i");
    static STRUCT_IF_C aC_Us_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aC_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aC_Us_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aC_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu31i, aC_Us_BFu31i)
//============================================================================



static void Test_aC_Us_BFu31ll()
{
  {
    init_simple_test("aC_Us_BFu31ll");
    static STRUCT_IF_C aC_Us_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aC_Us_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aC_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu31ll, aC_Us_BFu31ll)
//============================================================================



static void Test_aC_Us_BFu32i()
{
  {
    init_simple_test("aC_Us_BFu32i");
    static STRUCT_IF_C aC_Us_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aC_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aC_Us_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aC_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu32i, aC_Us_BFu32i)
//============================================================================



static void Test_aC_Us_BFu32ll()
{
  {
    init_simple_test("aC_Us_BFu32ll");
    static STRUCT_IF_C aC_Us_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aC_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aC_Us_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aC_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu32ll, aC_Us_BFu32ll)
//============================================================================



static void Test_aC_Us_BFu33()
{
  {
    init_simple_test("aC_Us_BFu33");
    static STRUCT_IF_C aC_Us_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aC_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu33)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu33.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aC_Us_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aC_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu33, aC_Us_BFu33)
//============================================================================



static void Test_aC_Us_BFu7c()
{
  {
    init_simple_test("aC_Us_BFu7c");
    static STRUCT_IF_C aC_Us_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aC_Us_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aC_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu7c, aC_Us_BFu7c)
//============================================================================



static void Test_aC_Us_BFu7i()
{
  {
    init_simple_test("aC_Us_BFu7i");
    static STRUCT_IF_C aC_Us_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aC_Us_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aC_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu7i, aC_Us_BFu7i)
//============================================================================



static void Test_aC_Us_BFu7ll()
{
  {
    init_simple_test("aC_Us_BFu7ll");
    static STRUCT_IF_C aC_Us_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aC_Us_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aC_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu7ll, aC_Us_BFu7ll)
//============================================================================



static void Test_aC_Us_BFu7s()
{
  {
    init_simple_test("aC_Us_BFu7s");
    static STRUCT_IF_C aC_Us_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aC_Us_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aC_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu7s, aC_Us_BFu7s)
//============================================================================



static void Test_aC_Us_BFu8c()
{
  {
    init_simple_test("aC_Us_BFu8c");
    static STRUCT_IF_C aC_Us_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aC_Us_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aC_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu8c, aC_Us_BFu8c)
//============================================================================



static void Test_aC_Us_BFu8i()
{
  {
    init_simple_test("aC_Us_BFu8i");
    static STRUCT_IF_C aC_Us_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aC_Us_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aC_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu8i, aC_Us_BFu8i)
//============================================================================



static void Test_aC_Us_BFu8ll()
{
  {
    init_simple_test("aC_Us_BFu8ll");
    static STRUCT_IF_C aC_Us_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aC_Us_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aC_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu8ll, aC_Us_BFu8ll)
//============================================================================



static void Test_aC_Us_BFu8s()
{
  {
    init_simple_test("aC_Us_BFu8s");
    static STRUCT_IF_C aC_Us_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aC_Us_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aC_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu8s, aC_Us_BFu8s)
//============================================================================



static void Test_aC_Us_BFu9i()
{
  {
    init_simple_test("aC_Us_BFu9i");
    static STRUCT_IF_C aC_Us_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aC_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aC_Us_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aC_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu9i, aC_Us_BFu9i)
//============================================================================



static void Test_aC_Us_BFu9ll()
{
  {
    init_simple_test("aC_Us_BFu9ll");
    static STRUCT_IF_C aC_Us_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aC_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aC_Us_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aC_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu9ll, aC_Us_BFu9ll)
//============================================================================



static void Test_aC_Us_BFu9s()
{
  {
    init_simple_test("aC_Us_BFu9s");
    static STRUCT_IF_C aC_Us_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aC_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_Us_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aC_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aC_Us_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aC_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_BFu9s, aC_Us_BFu9s)
//============================================================================



static void Test_aC_Us_C()
{
  {
    init_simple_test("aC_Us_C");
    STRUCT_IF_C aC_Us_C lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_C)");
    check_field_offset(lv, v1, 0, "aC_Us_C.v1");
    check_field_offset(lv, v2, 1, "aC_Us_C.v2");
    check_field_offset(lv, v3, 3, "aC_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_C, aC_Us_C)
//============================================================================



static void Test_aC_Us_D()
{
  {
    init_simple_test("aC_Us_D");
    STRUCT_IF_C aC_Us_D lv;
    check2(sizeof(lv), 11, "sizeof(aC_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_D)");
    check_field_offset(lv, v1, 0, "aC_Us_D.v1");
    check_field_offset(lv, v2, 1, "aC_Us_D.v2");
    check_field_offset(lv, v3, 3, "aC_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_D, aC_Us_D)
//============================================================================



static void Test_aC_Us_F()
{
  {
    init_simple_test("aC_Us_F");
    STRUCT_IF_C aC_Us_F lv;
    check2(sizeof(lv), 7, "sizeof(aC_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_F)");
    check_field_offset(lv, v1, 0, "aC_Us_F.v1");
    check_field_offset(lv, v2, 1, "aC_Us_F.v2");
    check_field_offset(lv, v3, 3, "aC_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_F, aC_Us_F)
//============================================================================



static void Test_aC_Us_I()
{
  {
    init_simple_test("aC_Us_I");
    STRUCT_IF_C aC_Us_I lv;
    check2(sizeof(lv), 7, "sizeof(aC_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_I)");
    check_field_offset(lv, v1, 0, "aC_Us_I.v1");
    check_field_offset(lv, v2, 1, "aC_Us_I.v2");
    check_field_offset(lv, v3, 3, "aC_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_I, aC_Us_I)
//============================================================================



static void Test_aC_Us_Ip()
{
  {
    init_simple_test("aC_Us_Ip");
    STRUCT_IF_C aC_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_Ip)");
    check_field_offset(lv, v1, 0, "aC_Us_Ip.v1");
    check_field_offset(lv, v2, 1, "aC_Us_Ip.v2");
    check_field_offset(lv, v3, 3, "aC_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_Ip, aC_Us_Ip)
//============================================================================



static void Test_aC_Us_L()
{
  {
    init_simple_test("aC_Us_L");
    STRUCT_IF_C aC_Us_L lv;
    check2(sizeof(lv), 11, "sizeof(aC_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_L)");
    check_field_offset(lv, v1, 0, "aC_Us_L.v1");
    check_field_offset(lv, v2, 1, "aC_Us_L.v2");
    check_field_offset(lv, v3, 3, "aC_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_L, aC_Us_L)
//============================================================================



static void Test_aC_Us_S()
{
  {
    init_simple_test("aC_Us_S");
    STRUCT_IF_C aC_Us_S lv;
    check2(sizeof(lv), 5, "sizeof(aC_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_S)");
    check_field_offset(lv, v1, 0, "aC_Us_S.v1");
    check_field_offset(lv, v2, 1, "aC_Us_S.v2");
    check_field_offset(lv, v3, 3, "aC_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_S, aC_Us_S)
//============================================================================



static void Test_aC_Us_Uc()
{
  {
    init_simple_test("aC_Us_Uc");
    STRUCT_IF_C aC_Us_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aC_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_Uc)");
    check_field_offset(lv, v1, 0, "aC_Us_Uc.v1");
    check_field_offset(lv, v2, 1, "aC_Us_Uc.v2");
    check_field_offset(lv, v3, 3, "aC_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_Uc, aC_Us_Uc)
//============================================================================



static void Test_aC_Us_Ui()
{
  {
    init_simple_test("aC_Us_Ui");
    STRUCT_IF_C aC_Us_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aC_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_Ui)");
    check_field_offset(lv, v1, 0, "aC_Us_Ui.v1");
    check_field_offset(lv, v2, 1, "aC_Us_Ui.v2");
    check_field_offset(lv, v3, 3, "aC_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_Ui, aC_Us_Ui)
//============================================================================



static void Test_aC_Us_Ul()
{
  {
    init_simple_test("aC_Us_Ul");
    STRUCT_IF_C aC_Us_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aC_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_Ul)");
    check_field_offset(lv, v1, 0, "aC_Us_Ul.v1");
    check_field_offset(lv, v2, 1, "aC_Us_Ul.v2");
    check_field_offset(lv, v3, 3, "aC_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_Ul, aC_Us_Ul)
//============================================================================



static void Test_aC_Us_Us()
{
  {
    init_simple_test("aC_Us_Us");
    STRUCT_IF_C aC_Us_Us lv;
    check2(sizeof(lv), 5, "sizeof(aC_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_Us)");
    check_field_offset(lv, v1, 0, "aC_Us_Us.v1");
    check_field_offset(lv, v2, 1, "aC_Us_Us.v2");
    check_field_offset(lv, v3, 3, "aC_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_Us, aC_Us_Us)
//============================================================================



static void Test_aC_Us_Vp()
{
  {
    init_simple_test("aC_Us_Vp");
    STRUCT_IF_C aC_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Us_Vp)");
    check_field_offset(lv, v1, 0, "aC_Us_Vp.v1");
    check_field_offset(lv, v2, 1, "aC_Us_Vp.v2");
    check_field_offset(lv, v3, 3, "aC_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Us_Vp, aC_Us_Vp)
//============================================================================



static void Test_aC_Vp()
{
  {
    init_simple_test("aC_Vp");
    STRUCT_IF_C aC_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aC_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp)");
    check_field_offset(lv, v1, 0, "aC_Vp.v1");
    check_field_offset(lv, v2, 1, "aC_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp, aC_Vp)
//============================================================================



static void Test_aC_Vp_BFu15i()
{
  {
    init_simple_test("aC_Vp_BFu15i");
    static STRUCT_IF_C aC_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu15i.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aC_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aC_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu15i, aC_Vp_BFu15i)
//============================================================================



static void Test_aC_Vp_BFu15ll()
{
  {
    init_simple_test("aC_Vp_BFu15ll");
    static STRUCT_IF_C aC_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aC_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aC_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu15ll, aC_Vp_BFu15ll)
//============================================================================



static void Test_aC_Vp_BFu15s()
{
  {
    init_simple_test("aC_Vp_BFu15s");
    static STRUCT_IF_C aC_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu15s.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aC_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aC_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu15s, aC_Vp_BFu15s)
//============================================================================



static void Test_aC_Vp_BFu16i()
{
  {
    init_simple_test("aC_Vp_BFu16i");
    static STRUCT_IF_C aC_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu16i.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aC_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aC_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu16i, aC_Vp_BFu16i)
//============================================================================



static void Test_aC_Vp_BFu16ll()
{
  {
    init_simple_test("aC_Vp_BFu16ll");
    static STRUCT_IF_C aC_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aC_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aC_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu16ll, aC_Vp_BFu16ll)
//============================================================================



static void Test_aC_Vp_BFu16s()
{
  {
    init_simple_test("aC_Vp_BFu16s");
    static STRUCT_IF_C aC_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu16s.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aC_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aC_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu16s, aC_Vp_BFu16s)
//============================================================================



static void Test_aC_Vp_BFu17i()
{
  {
    init_simple_test("aC_Vp_BFu17i");
    static STRUCT_IF_C aC_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aC_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu17i.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aC_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aC_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu17i, aC_Vp_BFu17i)
//============================================================================



static void Test_aC_Vp_BFu17ll()
{
  {
    init_simple_test("aC_Vp_BFu17ll");
    static STRUCT_IF_C aC_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aC_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aC_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aC_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu17ll, aC_Vp_BFu17ll)
//============================================================================



static void Test_aC_Vp_BFu1c()
{
  {
    init_simple_test("aC_Vp_BFu1c");
    static STRUCT_IF_C aC_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu1c.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aC_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu1c, aC_Vp_BFu1c)
//============================================================================



static void Test_aC_Vp_BFu1i()
{
  {
    init_simple_test("aC_Vp_BFu1i");
    static STRUCT_IF_C aC_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu1i.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aC_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu1i, aC_Vp_BFu1i)
//============================================================================



static void Test_aC_Vp_BFu1ll()
{
  {
    init_simple_test("aC_Vp_BFu1ll");
    static STRUCT_IF_C aC_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aC_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu1ll, aC_Vp_BFu1ll)
//============================================================================



static void Test_aC_Vp_BFu1s()
{
  {
    init_simple_test("aC_Vp_BFu1s");
    static STRUCT_IF_C aC_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu1s.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aC_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu1s, aC_Vp_BFu1s)
//============================================================================



static void Test_aC_Vp_BFu31i()
{
  {
    init_simple_test("aC_Vp_BFu31i");
    static STRUCT_IF_C aC_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu31i.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aC_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aC_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu31i, aC_Vp_BFu31i)
//============================================================================



static void Test_aC_Vp_BFu31ll()
{
  {
    init_simple_test("aC_Vp_BFu31ll");
    static STRUCT_IF_C aC_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aC_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aC_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu31ll, aC_Vp_BFu31ll)
//============================================================================



static void Test_aC_Vp_BFu32i()
{
  {
    init_simple_test("aC_Vp_BFu32i");
    static STRUCT_IF_C aC_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu32i.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aC_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aC_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu32i, aC_Vp_BFu32i)
//============================================================================



static void Test_aC_Vp_BFu32ll()
{
  {
    init_simple_test("aC_Vp_BFu32ll");
    static STRUCT_IF_C aC_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aC_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aC_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu32ll, aC_Vp_BFu32ll)
//============================================================================



static void Test_aC_Vp_BFu33()
{
  {
    init_simple_test("aC_Vp_BFu33");
    static STRUCT_IF_C aC_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aC_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu33.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aC_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aC_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu33, aC_Vp_BFu33)
//============================================================================



static void Test_aC_Vp_BFu7c()
{
  {
    init_simple_test("aC_Vp_BFu7c");
    static STRUCT_IF_C aC_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu7c.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aC_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aC_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu7c, aC_Vp_BFu7c)
//============================================================================



static void Test_aC_Vp_BFu7i()
{
  {
    init_simple_test("aC_Vp_BFu7i");
    static STRUCT_IF_C aC_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu7i.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aC_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aC_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu7i, aC_Vp_BFu7i)
//============================================================================



static void Test_aC_Vp_BFu7ll()
{
  {
    init_simple_test("aC_Vp_BFu7ll");
    static STRUCT_IF_C aC_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aC_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aC_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu7ll, aC_Vp_BFu7ll)
//============================================================================



static void Test_aC_Vp_BFu7s()
{
  {
    init_simple_test("aC_Vp_BFu7s");
    static STRUCT_IF_C aC_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu7s.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aC_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aC_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu7s, aC_Vp_BFu7s)
//============================================================================



static void Test_aC_Vp_BFu8c()
{
  {
    init_simple_test("aC_Vp_BFu8c");
    static STRUCT_IF_C aC_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu8c.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aC_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aC_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu8c, aC_Vp_BFu8c)
//============================================================================



static void Test_aC_Vp_BFu8i()
{
  {
    init_simple_test("aC_Vp_BFu8i");
    static STRUCT_IF_C aC_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu8i.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aC_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aC_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu8i, aC_Vp_BFu8i)
//============================================================================



static void Test_aC_Vp_BFu8ll()
{
  {
    init_simple_test("aC_Vp_BFu8ll");
    static STRUCT_IF_C aC_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aC_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aC_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu8ll, aC_Vp_BFu8ll)
//============================================================================



static void Test_aC_Vp_BFu8s()
{
  {
    init_simple_test("aC_Vp_BFu8s");
    static STRUCT_IF_C aC_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu8s.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aC_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aC_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu8s, aC_Vp_BFu8s)
//============================================================================



static void Test_aC_Vp_BFu9i()
{
  {
    init_simple_test("aC_Vp_BFu9i");
    static STRUCT_IF_C aC_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu9i.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aC_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aC_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu9i, aC_Vp_BFu9i)
//============================================================================



static void Test_aC_Vp_BFu9ll()
{
  {
    init_simple_test("aC_Vp_BFu9ll");
    static STRUCT_IF_C aC_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aC_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aC_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu9ll, aC_Vp_BFu9ll)
//============================================================================



static void Test_aC_Vp_BFu9s()
{
  {
    init_simple_test("aC_Vp_BFu9s");
    static STRUCT_IF_C aC_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "aC_Vp_BFu9s.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aC_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aC_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_BFu9s, aC_Vp_BFu9s)
//============================================================================



static void Test_aC_Vp_C()
{
  {
    init_simple_test("aC_Vp_C");
    STRUCT_IF_C aC_Vp_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_C)");
    check_field_offset(lv, v1, 0, "aC_Vp_C.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_C, aC_Vp_C)
//============================================================================



static void Test_aC_Vp_D()
{
  {
    init_simple_test("aC_Vp_D");
    STRUCT_IF_C aC_Vp_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aC_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_D)");
    check_field_offset(lv, v1, 0, "aC_Vp_D.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_D, aC_Vp_D)
//============================================================================



static void Test_aC_Vp_F()
{
  {
    init_simple_test("aC_Vp_F");
    STRUCT_IF_C aC_Vp_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_F)");
    check_field_offset(lv, v1, 0, "aC_Vp_F.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_F, aC_Vp_F)
//============================================================================



static void Test_aC_Vp_I()
{
  {
    init_simple_test("aC_Vp_I");
    STRUCT_IF_C aC_Vp_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_I)");
    check_field_offset(lv, v1, 0, "aC_Vp_I.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_I, aC_Vp_I)
//============================================================================



static void Test_aC_Vp_Ip()
{
  {
    init_simple_test("aC_Vp_Ip");
    STRUCT_IF_C aC_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aC_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_Ip)");
    check_field_offset(lv, v1, 0, "aC_Vp_Ip.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_Ip, aC_Vp_Ip)
//============================================================================



static void Test_aC_Vp_L()
{
  {
    init_simple_test("aC_Vp_L");
    STRUCT_IF_C aC_Vp_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aC_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_L)");
    check_field_offset(lv, v1, 0, "aC_Vp_L.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_L, aC_Vp_L)
//============================================================================



static void Test_aC_Vp_S()
{
  {
    init_simple_test("aC_Vp_S");
    STRUCT_IF_C aC_Vp_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_S)");
    check_field_offset(lv, v1, 0, "aC_Vp_S.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_S, aC_Vp_S)
//============================================================================



static void Test_aC_Vp_Uc()
{
  {
    init_simple_test("aC_Vp_Uc");
    STRUCT_IF_C aC_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aC_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_Uc)");
    check_field_offset(lv, v1, 0, "aC_Vp_Uc.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_Uc, aC_Vp_Uc)
//============================================================================



static void Test_aC_Vp_Ui()
{
  {
    init_simple_test("aC_Vp_Ui");
    STRUCT_IF_C aC_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aC_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_Ui)");
    check_field_offset(lv, v1, 0, "aC_Vp_Ui.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_Ui, aC_Vp_Ui)
//============================================================================



static void Test_aC_Vp_Ul()
{
  {
    init_simple_test("aC_Vp_Ul");
    STRUCT_IF_C aC_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aC_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_Ul)");
    check_field_offset(lv, v1, 0, "aC_Vp_Ul.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_Ul, aC_Vp_Ul)
//============================================================================



static void Test_aC_Vp_Us()
{
  {
    init_simple_test("aC_Vp_Us");
    STRUCT_IF_C aC_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aC_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_Us)");
    check_field_offset(lv, v1, 0, "aC_Vp_Us.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_Us, aC_Vp_Us)
//============================================================================



static void Test_aC_Vp_Vp()
{
  {
    init_simple_test("aC_Vp_Vp");
    STRUCT_IF_C aC_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aC_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aC_Vp_Vp)");
    check_field_offset(lv, v1, 0, "aC_Vp_Vp.v1");
    check_field_offset(lv, v2, 1, "aC_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aC_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aC_Vp_Vp, aC_Vp_Vp)
//============================================================================



static void Test_aD()
{
  {
    init_simple_test("aD");
    STRUCT_IF_C aD lv;
    check2(sizeof(lv), 8, "sizeof(aD)");
    check2(__alignof__(lv), 1, "__alignof__(aD)");
    check_field_offset(lv, v1, 0, "aD.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_aD, aD)
//============================================================================



static void Test_aD_BFu15i()
{
  {
    init_simple_test("aD_BFu15i");
    static STRUCT_IF_C aD_BFu15i lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i)");
    check_field_offset(lv, v1, 0, "aD_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i, aD_BFu15i)
//============================================================================



static void Test_aD_BFu15i_BFu15i()
{
  {
    init_simple_test("aD_BFu15i_BFu15i");
    static STRUCT_IF_C aD_BFu15i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "aD_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu15i, aD_BFu15i_BFu15i)
//============================================================================



static void Test_aD_BFu15i_BFu15ll()
{
  {
    init_simple_test("aD_BFu15i_BFu15ll");
    static STRUCT_IF_C aD_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "aD_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu15ll, aD_BFu15i_BFu15ll)
//============================================================================



static void Test_aD_BFu15i_BFu15s()
{
  {
    init_simple_test("aD_BFu15i_BFu15s");
    static STRUCT_IF_C aD_BFu15i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "aD_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu15s, aD_BFu15i_BFu15s)
//============================================================================



static void Test_aD_BFu15i_BFu16i()
{
  {
    init_simple_test("aD_BFu15i_BFu16i");
    static STRUCT_IF_C aD_BFu15i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "aD_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "aD_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu16i, aD_BFu15i_BFu16i)
//============================================================================



static void Test_aD_BFu15i_BFu16ll()
{
  {
    init_simple_test("aD_BFu15i_BFu16ll");
    static STRUCT_IF_C aD_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "aD_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "aD_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu16ll, aD_BFu15i_BFu16ll)
//============================================================================



static void Test_aD_BFu15i_BFu16s()
{
  {
    init_simple_test("aD_BFu15i_BFu16s");
    static STRUCT_IF_C aD_BFu15i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "aD_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "aD_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu16s, aD_BFu15i_BFu16s)
//============================================================================



static void Test_aD_BFu15i_BFu17i()
{
  {
    init_simple_test("aD_BFu15i_BFu17i");
    static STRUCT_IF_C aD_BFu15i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "aD_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "aD_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu17i, aD_BFu15i_BFu17i)
//============================================================================



static void Test_aD_BFu15i_BFu17ll()
{
  {
    init_simple_test("aD_BFu15i_BFu17ll");
    static STRUCT_IF_C aD_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "aD_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "aD_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu17ll, aD_BFu15i_BFu17ll)
//============================================================================



static void Test_aD_BFu15i_BFu1c()
{
  {
    init_simple_test("aD_BFu15i_BFu1c");
    static STRUCT_IF_C aD_BFu15i_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "aD_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu1c, aD_BFu15i_BFu1c)
//============================================================================



static void Test_aD_BFu15i_BFu1i()
{
  {
    init_simple_test("aD_BFu15i_BFu1i");
    static STRUCT_IF_C aD_BFu15i_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "aD_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu1i, aD_BFu15i_BFu1i)
//============================================================================



static void Test_aD_BFu15i_BFu1ll()
{
  {
    init_simple_test("aD_BFu15i_BFu1ll");
    static STRUCT_IF_C aD_BFu15i_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "aD_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu1ll, aD_BFu15i_BFu1ll)
//============================================================================



static void Test_aD_BFu15i_BFu1s()
{
  {
    init_simple_test("aD_BFu15i_BFu1s");
    static STRUCT_IF_C aD_BFu15i_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "aD_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu1s, aD_BFu15i_BFu1s)
//============================================================================



static void Test_aD_BFu15i_BFu31i()
{
  {
    init_simple_test("aD_BFu15i_BFu31i");
    static STRUCT_IF_C aD_BFu15i_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "aD_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "aD_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu31i, aD_BFu15i_BFu31i)
//============================================================================



static void Test_aD_BFu15i_BFu31ll()
{
  {
    init_simple_test("aD_BFu15i_BFu31ll");
    static STRUCT_IF_C aD_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "aD_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "aD_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu31ll, aD_BFu15i_BFu31ll)
//============================================================================



static void Test_aD_BFu15i_BFu32i()
{
  {
    init_simple_test("aD_BFu15i_BFu32i");
    static STRUCT_IF_C aD_BFu15i_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "aD_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "aD_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu32i, aD_BFu15i_BFu32i)
//============================================================================



static void Test_aD_BFu15i_BFu32ll()
{
  {
    init_simple_test("aD_BFu15i_BFu32ll");
    static STRUCT_IF_C aD_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "aD_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "aD_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu32ll, aD_BFu15i_BFu32ll)
//============================================================================



static void Test_aD_BFu15i_BFu33()
{
  {
    init_simple_test("aD_BFu15i_BFu33");
    static STRUCT_IF_C aD_BFu15i_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, 1, "aD_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, hide_ull(1LL<<32), "aD_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu33, aD_BFu15i_BFu33)
//============================================================================



static void Test_aD_BFu15i_BFu7c()
{
  {
    init_simple_test("aD_BFu15i_BFu7c");
    static STRUCT_IF_C aD_BFu15i_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "aD_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "aD_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu7c, aD_BFu15i_BFu7c)
//============================================================================



static void Test_aD_BFu15i_BFu7i()
{
  {
    init_simple_test("aD_BFu15i_BFu7i");
    static STRUCT_IF_C aD_BFu15i_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "aD_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "aD_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu7i, aD_BFu15i_BFu7i)
//============================================================================



static void Test_aD_BFu15i_BFu7ll()
{
  {
    init_simple_test("aD_BFu15i_BFu7ll");
    static STRUCT_IF_C aD_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "aD_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "aD_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu7ll, aD_BFu15i_BFu7ll)
//============================================================================



static void Test_aD_BFu15i_BFu7s()
{
  {
    init_simple_test("aD_BFu15i_BFu7s");
    static STRUCT_IF_C aD_BFu15i_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "aD_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "aD_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu7s, aD_BFu15i_BFu7s)
//============================================================================



static void Test_aD_BFu15i_BFu8c()
{
  {
    init_simple_test("aD_BFu15i_BFu8c");
    static STRUCT_IF_C aD_BFu15i_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "aD_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "aD_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu8c, aD_BFu15i_BFu8c)
//============================================================================



static void Test_aD_BFu15i_BFu8i()
{
  {
    init_simple_test("aD_BFu15i_BFu8i");
    static STRUCT_IF_C aD_BFu15i_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "aD_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "aD_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu8i, aD_BFu15i_BFu8i)
//============================================================================



static void Test_aD_BFu15i_BFu8ll()
{
  {
    init_simple_test("aD_BFu15i_BFu8ll");
    static STRUCT_IF_C aD_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "aD_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "aD_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu8ll, aD_BFu15i_BFu8ll)
//============================================================================



static void Test_aD_BFu15i_BFu8s()
{
  {
    init_simple_test("aD_BFu15i_BFu8s");
    static STRUCT_IF_C aD_BFu15i_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "aD_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "aD_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu8s, aD_BFu15i_BFu8s)
//============================================================================



static void Test_aD_BFu15i_BFu9i()
{
  {
    init_simple_test("aD_BFu15i_BFu9i");
    static STRUCT_IF_C aD_BFu15i_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "aD_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "aD_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu9i, aD_BFu15i_BFu9i)
//============================================================================



static void Test_aD_BFu15i_BFu9ll()
{
  {
    init_simple_test("aD_BFu15i_BFu9ll");
    static STRUCT_IF_C aD_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "aD_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "aD_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu9ll, aD_BFu15i_BFu9ll)
//============================================================================



static void Test_aD_BFu15i_BFu9s()
{
  {
    init_simple_test("aD_BFu15i_BFu9s");
    static STRUCT_IF_C aD_BFu15i_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "aD_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "aD_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_BFu9s, aD_BFu15i_BFu9s)
//============================================================================



static void Test_aD_BFu15i_C()
{
  {
    init_simple_test("aD_BFu15i_C");
    static STRUCT_IF_C aD_BFu15i_C lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_C)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_C");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_C");
    check_field_offset(lv, v3, 10, "aD_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_C, aD_BFu15i_C)
//============================================================================



static void Test_aD_BFu15i_D()
{
  {
    init_simple_test("aD_BFu15i_D");
    static STRUCT_IF_C aD_BFu15i_D lv;
    check2(sizeof(lv), 18, "sizeof(aD_BFu15i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_D)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_D");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_D");
    check_field_offset(lv, v3, 10, "aD_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_D, aD_BFu15i_D)
//============================================================================



static void Test_aD_BFu15i_F()
{
  {
    init_simple_test("aD_BFu15i_F");
    static STRUCT_IF_C aD_BFu15i_F lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_F)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_F");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_F");
    check_field_offset(lv, v3, 10, "aD_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_F, aD_BFu15i_F)
//============================================================================



static void Test_aD_BFu15i_I()
{
  {
    init_simple_test("aD_BFu15i_I");
    static STRUCT_IF_C aD_BFu15i_I lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_I)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_I");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_I");
    check_field_offset(lv, v3, 10, "aD_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_I, aD_BFu15i_I)
//============================================================================



static void Test_aD_BFu15i_Ip()
{
  {
    init_simple_test("aD_BFu15i_Ip");
    static STRUCT_IF_C aD_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aD_BFu15i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_Ip");
    check_field_offset(lv, v3, 10, "aD_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_Ip, aD_BFu15i_Ip)
//============================================================================



static void Test_aD_BFu15i_L()
{
  {
    init_simple_test("aD_BFu15i_L");
    static STRUCT_IF_C aD_BFu15i_L lv;
    check2(sizeof(lv), 18, "sizeof(aD_BFu15i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_L)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_L");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_L");
    check_field_offset(lv, v3, 10, "aD_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_L, aD_BFu15i_L)
//============================================================================



static void Test_aD_BFu15i_S()
{
  {
    init_simple_test("aD_BFu15i_S");
    static STRUCT_IF_C aD_BFu15i_S lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_S)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_S");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_S");
    check_field_offset(lv, v3, 10, "aD_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_S, aD_BFu15i_S)
//============================================================================



static void Test_aD_BFu15i_Uc()
{
  {
    init_simple_test("aD_BFu15i_Uc");
    static STRUCT_IF_C aD_BFu15i_Uc lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_Uc");
    check_field_offset(lv, v3, 10, "aD_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_Uc, aD_BFu15i_Uc)
//============================================================================



static void Test_aD_BFu15i_Ui()
{
  {
    init_simple_test("aD_BFu15i_Ui");
    static STRUCT_IF_C aD_BFu15i_Ui lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_Ui");
    check_field_offset(lv, v3, 10, "aD_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_Ui, aD_BFu15i_Ui)
//============================================================================



static void Test_aD_BFu15i_Ul()
{
  {
    init_simple_test("aD_BFu15i_Ul");
    static STRUCT_IF_C aD_BFu15i_Ul lv;
    check2(sizeof(lv), 18, "sizeof(aD_BFu15i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_Ul");
    check_field_offset(lv, v3, 10, "aD_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_Ul, aD_BFu15i_Ul)
//============================================================================



static void Test_aD_BFu15i_Us()
{
  {
    init_simple_test("aD_BFu15i_Us");
    static STRUCT_IF_C aD_BFu15i_Us lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_Us");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_Us");
    check_field_offset(lv, v3, 10, "aD_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_Us, aD_BFu15i_Us)
//============================================================================



static void Test_aD_BFu15i_Vp()
{
  {
    init_simple_test("aD_BFu15i_Vp");
    static STRUCT_IF_C aD_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aD_BFu15i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "aD_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15i_Vp");
    check_field_offset(lv, v3, 10, "aD_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15i_Vp, aD_BFu15i_Vp)
//============================================================================



static void Test_aD_BFu15ll()
{
  {
    init_simple_test("aD_BFu15ll");
    static STRUCT_IF_C aD_BFu15ll lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll, aD_BFu15ll)
//============================================================================



static void Test_aD_BFu15ll_BFu15i()
{
  {
    init_simple_test("aD_BFu15ll_BFu15i");
    static STRUCT_IF_C aD_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "aD_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu15i, aD_BFu15ll_BFu15i)
//============================================================================



static void Test_aD_BFu15ll_BFu15ll()
{
  {
    init_simple_test("aD_BFu15ll_BFu15ll");
    static STRUCT_IF_C aD_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "aD_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu15ll, aD_BFu15ll_BFu15ll)
//============================================================================



static void Test_aD_BFu15ll_BFu15s()
{
  {
    init_simple_test("aD_BFu15ll_BFu15s");
    static STRUCT_IF_C aD_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "aD_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu15s, aD_BFu15ll_BFu15s)
//============================================================================



static void Test_aD_BFu15ll_BFu16i()
{
  {
    init_simple_test("aD_BFu15ll_BFu16i");
    static STRUCT_IF_C aD_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "aD_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "aD_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu16i, aD_BFu15ll_BFu16i)
//============================================================================



static void Test_aD_BFu15ll_BFu16ll()
{
  {
    init_simple_test("aD_BFu15ll_BFu16ll");
    static STRUCT_IF_C aD_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "aD_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "aD_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu16ll, aD_BFu15ll_BFu16ll)
//============================================================================



static void Test_aD_BFu15ll_BFu16s()
{
  {
    init_simple_test("aD_BFu15ll_BFu16s");
    static STRUCT_IF_C aD_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "aD_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "aD_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu16s, aD_BFu15ll_BFu16s)
//============================================================================



static void Test_aD_BFu15ll_BFu17i()
{
  {
    init_simple_test("aD_BFu15ll_BFu17i");
    static STRUCT_IF_C aD_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "aD_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "aD_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu17i, aD_BFu15ll_BFu17i)
//============================================================================



static void Test_aD_BFu15ll_BFu17ll()
{
  {
    init_simple_test("aD_BFu15ll_BFu17ll");
    static STRUCT_IF_C aD_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "aD_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "aD_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu17ll, aD_BFu15ll_BFu17ll)
//============================================================================



static void Test_aD_BFu15ll_BFu1c()
{
  {
    init_simple_test("aD_BFu15ll_BFu1c");
    static STRUCT_IF_C aD_BFu15ll_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "aD_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu1c, aD_BFu15ll_BFu1c)
//============================================================================



static void Test_aD_BFu15ll_BFu1i()
{
  {
    init_simple_test("aD_BFu15ll_BFu1i");
    static STRUCT_IF_C aD_BFu15ll_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "aD_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu1i, aD_BFu15ll_BFu1i)
//============================================================================



static void Test_aD_BFu15ll_BFu1ll()
{
  {
    init_simple_test("aD_BFu15ll_BFu1ll");
    static STRUCT_IF_C aD_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "aD_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu1ll, aD_BFu15ll_BFu1ll)
//============================================================================



static void Test_aD_BFu15ll_BFu1s()
{
  {
    init_simple_test("aD_BFu15ll_BFu1s");
    static STRUCT_IF_C aD_BFu15ll_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "aD_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu1s, aD_BFu15ll_BFu1s)
//============================================================================



static void Test_aD_BFu15ll_BFu31i()
{
  {
    init_simple_test("aD_BFu15ll_BFu31i");
    static STRUCT_IF_C aD_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "aD_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "aD_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu31i, aD_BFu15ll_BFu31i)
//============================================================================



static void Test_aD_BFu15ll_BFu31ll()
{
  {
    init_simple_test("aD_BFu15ll_BFu31ll");
    static STRUCT_IF_C aD_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "aD_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "aD_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu31ll, aD_BFu15ll_BFu31ll)
//============================================================================



static void Test_aD_BFu15ll_BFu32i()
{
  {
    init_simple_test("aD_BFu15ll_BFu32i");
    static STRUCT_IF_C aD_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "aD_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "aD_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu32i, aD_BFu15ll_BFu32i)
//============================================================================



static void Test_aD_BFu15ll_BFu32ll()
{
  {
    init_simple_test("aD_BFu15ll_BFu32ll");
    static STRUCT_IF_C aD_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "aD_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "aD_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu32ll, aD_BFu15ll_BFu32ll)
//============================================================================



static void Test_aD_BFu15ll_BFu33()
{
  {
    init_simple_test("aD_BFu15ll_BFu33");
    static STRUCT_IF_C aD_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, 1, "aD_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, hide_ull(1LL<<32), "aD_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu33, aD_BFu15ll_BFu33)
//============================================================================



static void Test_aD_BFu15ll_BFu7c()
{
  {
    init_simple_test("aD_BFu15ll_BFu7c");
    static STRUCT_IF_C aD_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "aD_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "aD_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu7c, aD_BFu15ll_BFu7c)
//============================================================================



static void Test_aD_BFu15ll_BFu7i()
{
  {
    init_simple_test("aD_BFu15ll_BFu7i");
    static STRUCT_IF_C aD_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "aD_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "aD_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu7i, aD_BFu15ll_BFu7i)
//============================================================================



static void Test_aD_BFu15ll_BFu7ll()
{
  {
    init_simple_test("aD_BFu15ll_BFu7ll");
    static STRUCT_IF_C aD_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "aD_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "aD_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu7ll, aD_BFu15ll_BFu7ll)
//============================================================================



static void Test_aD_BFu15ll_BFu7s()
{
  {
    init_simple_test("aD_BFu15ll_BFu7s");
    static STRUCT_IF_C aD_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "aD_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "aD_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu7s, aD_BFu15ll_BFu7s)
//============================================================================



static void Test_aD_BFu15ll_BFu8c()
{
  {
    init_simple_test("aD_BFu15ll_BFu8c");
    static STRUCT_IF_C aD_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "aD_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "aD_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu8c, aD_BFu15ll_BFu8c)
//============================================================================



static void Test_aD_BFu15ll_BFu8i()
{
  {
    init_simple_test("aD_BFu15ll_BFu8i");
    static STRUCT_IF_C aD_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "aD_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "aD_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu8i, aD_BFu15ll_BFu8i)
//============================================================================



static void Test_aD_BFu15ll_BFu8ll()
{
  {
    init_simple_test("aD_BFu15ll_BFu8ll");
    static STRUCT_IF_C aD_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "aD_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "aD_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu8ll, aD_BFu15ll_BFu8ll)
//============================================================================



static void Test_aD_BFu15ll_BFu8s()
{
  {
    init_simple_test("aD_BFu15ll_BFu8s");
    static STRUCT_IF_C aD_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "aD_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "aD_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu8s, aD_BFu15ll_BFu8s)
//============================================================================



static void Test_aD_BFu15ll_BFu9i()
{
  {
    init_simple_test("aD_BFu15ll_BFu9i");
    static STRUCT_IF_C aD_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "aD_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "aD_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu9i, aD_BFu15ll_BFu9i)
//============================================================================



static void Test_aD_BFu15ll_BFu9ll()
{
  {
    init_simple_test("aD_BFu15ll_BFu9ll");
    static STRUCT_IF_C aD_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "aD_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "aD_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu9ll, aD_BFu15ll_BFu9ll)
//============================================================================



static void Test_aD_BFu15ll_BFu9s()
{
  {
    init_simple_test("aD_BFu15ll_BFu9s");
    static STRUCT_IF_C aD_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "aD_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "aD_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_BFu9s, aD_BFu15ll_BFu9s)
//============================================================================



static void Test_aD_BFu15ll_C()
{
  {
    init_simple_test("aD_BFu15ll_C");
    static STRUCT_IF_C aD_BFu15ll_C lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_C");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_C");
    check_field_offset(lv, v3, 10, "aD_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_C, aD_BFu15ll_C)
//============================================================================



static void Test_aD_BFu15ll_D()
{
  {
    init_simple_test("aD_BFu15ll_D");
    static STRUCT_IF_C aD_BFu15ll_D lv;
    check2(sizeof(lv), 18, "sizeof(aD_BFu15ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_D");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_D");
    check_field_offset(lv, v3, 10, "aD_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_D, aD_BFu15ll_D)
//============================================================================



static void Test_aD_BFu15ll_F()
{
  {
    init_simple_test("aD_BFu15ll_F");
    static STRUCT_IF_C aD_BFu15ll_F lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_F");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_F");
    check_field_offset(lv, v3, 10, "aD_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_F, aD_BFu15ll_F)
//============================================================================



static void Test_aD_BFu15ll_I()
{
  {
    init_simple_test("aD_BFu15ll_I");
    static STRUCT_IF_C aD_BFu15ll_I lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_I");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_I");
    check_field_offset(lv, v3, 10, "aD_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_I, aD_BFu15ll_I)
//============================================================================



static void Test_aD_BFu15ll_Ip()
{
  {
    init_simple_test("aD_BFu15ll_Ip");
    static STRUCT_IF_C aD_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aD_BFu15ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_Ip");
    check_field_offset(lv, v3, 10, "aD_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_Ip, aD_BFu15ll_Ip)
//============================================================================



static void Test_aD_BFu15ll_L()
{
  {
    init_simple_test("aD_BFu15ll_L");
    static STRUCT_IF_C aD_BFu15ll_L lv;
    check2(sizeof(lv), 18, "sizeof(aD_BFu15ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_L");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_L");
    check_field_offset(lv, v3, 10, "aD_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_L, aD_BFu15ll_L)
//============================================================================



static void Test_aD_BFu15ll_S()
{
  {
    init_simple_test("aD_BFu15ll_S");
    static STRUCT_IF_C aD_BFu15ll_S lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_S");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_S");
    check_field_offset(lv, v3, 10, "aD_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_S, aD_BFu15ll_S)
//============================================================================



static void Test_aD_BFu15ll_Uc()
{
  {
    init_simple_test("aD_BFu15ll_Uc");
    static STRUCT_IF_C aD_BFu15ll_Uc lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_Uc");
    check_field_offset(lv, v3, 10, "aD_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_Uc, aD_BFu15ll_Uc)
//============================================================================



static void Test_aD_BFu15ll_Ui()
{
  {
    init_simple_test("aD_BFu15ll_Ui");
    static STRUCT_IF_C aD_BFu15ll_Ui lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_Ui");
    check_field_offset(lv, v3, 10, "aD_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_Ui, aD_BFu15ll_Ui)
//============================================================================



static void Test_aD_BFu15ll_Ul()
{
  {
    init_simple_test("aD_BFu15ll_Ul");
    static STRUCT_IF_C aD_BFu15ll_Ul lv;
    check2(sizeof(lv), 18, "sizeof(aD_BFu15ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_Ul");
    check_field_offset(lv, v3, 10, "aD_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_Ul, aD_BFu15ll_Ul)
//============================================================================



static void Test_aD_BFu15ll_Us()
{
  {
    init_simple_test("aD_BFu15ll_Us");
    static STRUCT_IF_C aD_BFu15ll_Us lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_Us");
    check_field_offset(lv, v3, 10, "aD_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_Us, aD_BFu15ll_Us)
//============================================================================



static void Test_aD_BFu15ll_Vp()
{
  {
    init_simple_test("aD_BFu15ll_Vp");
    static STRUCT_IF_C aD_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aD_BFu15ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "aD_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15ll_Vp");
    check_field_offset(lv, v3, 10, "aD_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15ll_Vp, aD_BFu15ll_Vp)
//============================================================================



static void Test_aD_BFu15s()
{
  {
    init_simple_test("aD_BFu15s");
    static STRUCT_IF_C aD_BFu15s lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s)");
    check_field_offset(lv, v1, 0, "aD_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s, aD_BFu15s)
//============================================================================



static void Test_aD_BFu15s_BFu15i()
{
  {
    init_simple_test("aD_BFu15s_BFu15i");
    static STRUCT_IF_C aD_BFu15s_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "aD_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu15i, aD_BFu15s_BFu15i)
//============================================================================



static void Test_aD_BFu15s_BFu15ll()
{
  {
    init_simple_test("aD_BFu15s_BFu15ll");
    static STRUCT_IF_C aD_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "aD_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu15ll, aD_BFu15s_BFu15ll)
//============================================================================



static void Test_aD_BFu15s_BFu15s()
{
  {
    init_simple_test("aD_BFu15s_BFu15s");
    static STRUCT_IF_C aD_BFu15s_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 9, 7, 15, 1, "aD_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 9, 7, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu15s, aD_BFu15s_BFu15s)
//============================================================================



static void Test_aD_BFu15s_BFu16i()
{
  {
    init_simple_test("aD_BFu15s_BFu16i");
    static STRUCT_IF_C aD_BFu15s_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "aD_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "aD_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu16i, aD_BFu15s_BFu16i)
//============================================================================



static void Test_aD_BFu15s_BFu16ll()
{
  {
    init_simple_test("aD_BFu15s_BFu16ll");
    static STRUCT_IF_C aD_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "aD_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "aD_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu16ll, aD_BFu15s_BFu16ll)
//============================================================================



static void Test_aD_BFu15s_BFu16s()
{
  {
    init_simple_test("aD_BFu15s_BFu16s");
    static STRUCT_IF_C aD_BFu15s_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 9, 7, 16, 1, "aD_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 9, 7, 16, hide_ull(1LL<<15), "aD_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu16s, aD_BFu15s_BFu16s)
//============================================================================



static void Test_aD_BFu15s_BFu17i()
{
  {
    init_simple_test("aD_BFu15s_BFu17i");
    static STRUCT_IF_C aD_BFu15s_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "aD_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "aD_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu17i, aD_BFu15s_BFu17i)
//============================================================================



static void Test_aD_BFu15s_BFu17ll()
{
  {
    init_simple_test("aD_BFu15s_BFu17ll");
    static STRUCT_IF_C aD_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, 1, "aD_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 7, 17, hide_ull(1LL<<16), "aD_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu17ll, aD_BFu15s_BFu17ll)
//============================================================================



static void Test_aD_BFu15s_BFu1c()
{
  {
    init_simple_test("aD_BFu15s_BFu1c");
    static STRUCT_IF_C aD_BFu15s_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "aD_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu1c, aD_BFu15s_BFu1c)
//============================================================================



static void Test_aD_BFu15s_BFu1i()
{
  {
    init_simple_test("aD_BFu15s_BFu1i");
    static STRUCT_IF_C aD_BFu15s_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "aD_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu1i, aD_BFu15s_BFu1i)
//============================================================================



static void Test_aD_BFu15s_BFu1ll()
{
  {
    init_simple_test("aD_BFu15s_BFu1ll");
    static STRUCT_IF_C aD_BFu15s_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "aD_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu1ll, aD_BFu15s_BFu1ll)
//============================================================================



static void Test_aD_BFu15s_BFu1s()
{
  {
    init_simple_test("aD_BFu15s_BFu1s");
    static STRUCT_IF_C aD_BFu15s_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu15s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 9, 7, 1, 1, "aD_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu1s, aD_BFu15s_BFu1s)
//============================================================================



static void Test_aD_BFu15s_BFu31i()
{
  {
    init_simple_test("aD_BFu15s_BFu31i");
    static STRUCT_IF_C aD_BFu15s_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "aD_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "aD_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu31i, aD_BFu15s_BFu31i)
//============================================================================



static void Test_aD_BFu15s_BFu31ll()
{
  {
    init_simple_test("aD_BFu15s_BFu31ll");
    static STRUCT_IF_C aD_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, 1, "aD_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 7, 31, hide_ull(1LL<<30), "aD_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu31ll, aD_BFu15s_BFu31ll)
//============================================================================



static void Test_aD_BFu15s_BFu32i()
{
  {
    init_simple_test("aD_BFu15s_BFu32i");
    static STRUCT_IF_C aD_BFu15s_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "aD_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "aD_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu32i, aD_BFu15s_BFu32i)
//============================================================================



static void Test_aD_BFu15s_BFu32ll()
{
  {
    init_simple_test("aD_BFu15s_BFu32ll");
    static STRUCT_IF_C aD_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, 1, "aD_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 7, 32, hide_ull(1LL<<31), "aD_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu32ll, aD_BFu15s_BFu32ll)
//============================================================================



static void Test_aD_BFu15s_BFu33()
{
  {
    init_simple_test("aD_BFu15s_BFu33");
    static STRUCT_IF_C aD_BFu15s_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, 1, "aD_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 9, 7, 33, hide_ull(1LL<<32), "aD_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu33, aD_BFu15s_BFu33)
//============================================================================



static void Test_aD_BFu15s_BFu7c()
{
  {
    init_simple_test("aD_BFu15s_BFu7c");
    static STRUCT_IF_C aD_BFu15s_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "aD_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "aD_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu7c, aD_BFu15s_BFu7c)
//============================================================================



static void Test_aD_BFu15s_BFu7i()
{
  {
    init_simple_test("aD_BFu15s_BFu7i");
    static STRUCT_IF_C aD_BFu15s_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "aD_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "aD_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu7i, aD_BFu15s_BFu7i)
//============================================================================



static void Test_aD_BFu15s_BFu7ll()
{
  {
    init_simple_test("aD_BFu15s_BFu7ll");
    static STRUCT_IF_C aD_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "aD_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "aD_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu7ll, aD_BFu15s_BFu7ll)
//============================================================================



static void Test_aD_BFu15s_BFu7s()
{
  {
    init_simple_test("aD_BFu15s_BFu7s");
    static STRUCT_IF_C aD_BFu15s_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 9, 7, 7, 1, "aD_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 9, 7, 7, hide_ull(1LL<<6), "aD_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu7s, aD_BFu15s_BFu7s)
//============================================================================



static void Test_aD_BFu15s_BFu8c()
{
  {
    init_simple_test("aD_BFu15s_BFu8c");
    static STRUCT_IF_C aD_BFu15s_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "aD_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "aD_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu8c, aD_BFu15s_BFu8c)
//============================================================================



static void Test_aD_BFu15s_BFu8i()
{
  {
    init_simple_test("aD_BFu15s_BFu8i");
    static STRUCT_IF_C aD_BFu15s_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "aD_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "aD_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu8i, aD_BFu15s_BFu8i)
//============================================================================



static void Test_aD_BFu15s_BFu8ll()
{
  {
    init_simple_test("aD_BFu15s_BFu8ll");
    static STRUCT_IF_C aD_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "aD_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "aD_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu8ll, aD_BFu15s_BFu8ll)
//============================================================================



static void Test_aD_BFu15s_BFu8s()
{
  {
    init_simple_test("aD_BFu15s_BFu8s");
    static STRUCT_IF_C aD_BFu15s_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 9, 7, 8, 1, "aD_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 9, 7, 8, hide_ull(1LL<<7), "aD_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu8s, aD_BFu15s_BFu8s)
//============================================================================



static void Test_aD_BFu15s_BFu9i()
{
  {
    init_simple_test("aD_BFu15s_BFu9i");
    static STRUCT_IF_C aD_BFu15s_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "aD_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "aD_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu9i, aD_BFu15s_BFu9i)
//============================================================================



static void Test_aD_BFu15s_BFu9ll()
{
  {
    init_simple_test("aD_BFu15s_BFu9ll");
    static STRUCT_IF_C aD_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "aD_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "aD_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu9ll, aD_BFu15s_BFu9ll)
//============================================================================



static void Test_aD_BFu15s_BFu9s()
{
  {
    init_simple_test("aD_BFu15s_BFu9s");
    static STRUCT_IF_C aD_BFu15s_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 9, 7, 9, 1, "aD_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 9, 7, 9, hide_ull(1LL<<8), "aD_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_BFu9s, aD_BFu15s_BFu9s)
//============================================================================



static void Test_aD_BFu15s_C()
{
  {
    init_simple_test("aD_BFu15s_C");
    static STRUCT_IF_C aD_BFu15s_C lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_C)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_C");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_C");
    check_field_offset(lv, v3, 10, "aD_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_C, aD_BFu15s_C)
//============================================================================



static void Test_aD_BFu15s_D()
{
  {
    init_simple_test("aD_BFu15s_D");
    static STRUCT_IF_C aD_BFu15s_D lv;
    check2(sizeof(lv), 18, "sizeof(aD_BFu15s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_D)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_D");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_D");
    check_field_offset(lv, v3, 10, "aD_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_D, aD_BFu15s_D)
//============================================================================



static void Test_aD_BFu15s_F()
{
  {
    init_simple_test("aD_BFu15s_F");
    static STRUCT_IF_C aD_BFu15s_F lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_F)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_F");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_F");
    check_field_offset(lv, v3, 10, "aD_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_F, aD_BFu15s_F)
//============================================================================



static void Test_aD_BFu15s_I()
{
  {
    init_simple_test("aD_BFu15s_I");
    static STRUCT_IF_C aD_BFu15s_I lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_I)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_I");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_I");
    check_field_offset(lv, v3, 10, "aD_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_I, aD_BFu15s_I)
//============================================================================



static void Test_aD_BFu15s_Ip()
{
  {
    init_simple_test("aD_BFu15s_Ip");
    static STRUCT_IF_C aD_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aD_BFu15s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_Ip");
    check_field_offset(lv, v3, 10, "aD_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_Ip, aD_BFu15s_Ip)
//============================================================================



static void Test_aD_BFu15s_L()
{
  {
    init_simple_test("aD_BFu15s_L");
    static STRUCT_IF_C aD_BFu15s_L lv;
    check2(sizeof(lv), 18, "sizeof(aD_BFu15s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_L)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_L");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_L");
    check_field_offset(lv, v3, 10, "aD_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_L, aD_BFu15s_L)
//============================================================================



static void Test_aD_BFu15s_S()
{
  {
    init_simple_test("aD_BFu15s_S");
    static STRUCT_IF_C aD_BFu15s_S lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_S)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_S");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_S");
    check_field_offset(lv, v3, 10, "aD_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_S, aD_BFu15s_S)
//============================================================================



static void Test_aD_BFu15s_Uc()
{
  {
    init_simple_test("aD_BFu15s_Uc");
    static STRUCT_IF_C aD_BFu15s_Uc lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu15s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_Uc");
    check_field_offset(lv, v3, 10, "aD_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_Uc, aD_BFu15s_Uc)
//============================================================================



static void Test_aD_BFu15s_Ui()
{
  {
    init_simple_test("aD_BFu15s_Ui");
    static STRUCT_IF_C aD_BFu15s_Ui lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu15s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_Ui");
    check_field_offset(lv, v3, 10, "aD_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_Ui, aD_BFu15s_Ui)
//============================================================================



static void Test_aD_BFu15s_Ul()
{
  {
    init_simple_test("aD_BFu15s_Ul");
    static STRUCT_IF_C aD_BFu15s_Ul lv;
    check2(sizeof(lv), 18, "sizeof(aD_BFu15s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_Ul");
    check_field_offset(lv, v3, 10, "aD_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_Ul, aD_BFu15s_Ul)
//============================================================================



static void Test_aD_BFu15s_Us()
{
  {
    init_simple_test("aD_BFu15s_Us");
    static STRUCT_IF_C aD_BFu15s_Us lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu15s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_Us");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_Us");
    check_field_offset(lv, v3, 10, "aD_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_Us, aD_BFu15s_Us)
//============================================================================



static void Test_aD_BFu15s_Vp()
{
  {
    init_simple_test("aD_BFu15s_Vp");
    static STRUCT_IF_C aD_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aD_BFu15s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "aD_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 15, 1, "aD_BFu15s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 15, hide_ull(1LL<<14), "aD_BFu15s_Vp");
    check_field_offset(lv, v3, 10, "aD_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu15s_Vp, aD_BFu15s_Vp)
//============================================================================



static void Test_aD_BFu16i()
{
  {
    init_simple_test("aD_BFu16i");
    static STRUCT_IF_C aD_BFu16i lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i)");
    check_field_offset(lv, v1, 0, "aD_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i, aD_BFu16i)
//============================================================================



static void Test_aD_BFu16i_BFu15i()
{
  {
    init_simple_test("aD_BFu16i_BFu15i");
    static STRUCT_IF_C aD_BFu16i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aD_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aD_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu15i, aD_BFu16i_BFu15i)
//============================================================================



static void Test_aD_BFu16i_BFu15ll()
{
  {
    init_simple_test("aD_BFu16i_BFu15ll");
    static STRUCT_IF_C aD_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aD_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aD_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu15ll, aD_BFu16i_BFu15ll)
//============================================================================



static void Test_aD_BFu16i_BFu15s()
{
  {
    init_simple_test("aD_BFu16i_BFu15s");
    static STRUCT_IF_C aD_BFu16i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aD_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aD_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu15s, aD_BFu16i_BFu15s)
//============================================================================



static void Test_aD_BFu16i_BFu16i()
{
  {
    init_simple_test("aD_BFu16i_BFu16i");
    static STRUCT_IF_C aD_BFu16i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aD_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu16i, aD_BFu16i_BFu16i)
//============================================================================



static void Test_aD_BFu16i_BFu16ll()
{
  {
    init_simple_test("aD_BFu16i_BFu16ll");
    static STRUCT_IF_C aD_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aD_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu16ll, aD_BFu16i_BFu16ll)
//============================================================================



static void Test_aD_BFu16i_BFu16s()
{
  {
    init_simple_test("aD_BFu16i_BFu16s");
    static STRUCT_IF_C aD_BFu16i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aD_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu16s, aD_BFu16i_BFu16s)
//============================================================================



static void Test_aD_BFu16i_BFu17i()
{
  {
    init_simple_test("aD_BFu16i_BFu17i");
    static STRUCT_IF_C aD_BFu16i_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(aD_BFu16i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "aD_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "aD_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu17i, aD_BFu16i_BFu17i)
//============================================================================



static void Test_aD_BFu16i_BFu17ll()
{
  {
    init_simple_test("aD_BFu16i_BFu17ll");
    static STRUCT_IF_C aD_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(aD_BFu16i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "aD_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "aD_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu17ll, aD_BFu16i_BFu17ll)
//============================================================================



static void Test_aD_BFu16i_BFu1c()
{
  {
    init_simple_test("aD_BFu16i_BFu1c");
    static STRUCT_IF_C aD_BFu16i_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aD_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu1c, aD_BFu16i_BFu1c)
//============================================================================



static void Test_aD_BFu16i_BFu1i()
{
  {
    init_simple_test("aD_BFu16i_BFu1i");
    static STRUCT_IF_C aD_BFu16i_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aD_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu1i, aD_BFu16i_BFu1i)
//============================================================================



static void Test_aD_BFu16i_BFu1ll()
{
  {
    init_simple_test("aD_BFu16i_BFu1ll");
    static STRUCT_IF_C aD_BFu16i_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aD_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu1ll, aD_BFu16i_BFu1ll)
//============================================================================



static void Test_aD_BFu16i_BFu1s()
{
  {
    init_simple_test("aD_BFu16i_BFu1s");
    static STRUCT_IF_C aD_BFu16i_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aD_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu1s, aD_BFu16i_BFu1s)
//============================================================================



static void Test_aD_BFu16i_BFu31i()
{
  {
    init_simple_test("aD_BFu16i_BFu31i");
    static STRUCT_IF_C aD_BFu16i_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu16i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "aD_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "aD_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu31i, aD_BFu16i_BFu31i)
//============================================================================



static void Test_aD_BFu16i_BFu31ll()
{
  {
    init_simple_test("aD_BFu16i_BFu31ll");
    static STRUCT_IF_C aD_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu16i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "aD_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "aD_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu31ll, aD_BFu16i_BFu31ll)
//============================================================================



static void Test_aD_BFu16i_BFu32i()
{
  {
    init_simple_test("aD_BFu16i_BFu32i");
    static STRUCT_IF_C aD_BFu16i_BFu32i lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu16i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "aD_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "aD_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu32i, aD_BFu16i_BFu32i)
//============================================================================



static void Test_aD_BFu16i_BFu32ll()
{
  {
    init_simple_test("aD_BFu16i_BFu32ll");
    static STRUCT_IF_C aD_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu16i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "aD_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "aD_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu32ll, aD_BFu16i_BFu32ll)
//============================================================================



static void Test_aD_BFu16i_BFu33()
{
  {
    init_simple_test("aD_BFu16i_BFu33");
    static STRUCT_IF_C aD_BFu16i_BFu33 lv;
    check2(sizeof(lv), 15, "sizeof(aD_BFu16i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "aD_BFu16i_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "aD_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu33, aD_BFu16i_BFu33)
//============================================================================



static void Test_aD_BFu16i_BFu7c()
{
  {
    init_simple_test("aD_BFu16i_BFu7c");
    static STRUCT_IF_C aD_BFu16i_BFu7c lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aD_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aD_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu7c, aD_BFu16i_BFu7c)
//============================================================================



static void Test_aD_BFu16i_BFu7i()
{
  {
    init_simple_test("aD_BFu16i_BFu7i");
    static STRUCT_IF_C aD_BFu16i_BFu7i lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aD_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aD_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu7i, aD_BFu16i_BFu7i)
//============================================================================



static void Test_aD_BFu16i_BFu7ll()
{
  {
    init_simple_test("aD_BFu16i_BFu7ll");
    static STRUCT_IF_C aD_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aD_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aD_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu7ll, aD_BFu16i_BFu7ll)
//============================================================================



static void Test_aD_BFu16i_BFu7s()
{
  {
    init_simple_test("aD_BFu16i_BFu7s");
    static STRUCT_IF_C aD_BFu16i_BFu7s lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "aD_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "aD_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu7s, aD_BFu16i_BFu7s)
//============================================================================



static void Test_aD_BFu16i_BFu8c()
{
  {
    init_simple_test("aD_BFu16i_BFu8c");
    static STRUCT_IF_C aD_BFu16i_BFu8c lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aD_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aD_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu8c, aD_BFu16i_BFu8c)
//============================================================================



static void Test_aD_BFu16i_BFu8i()
{
  {
    init_simple_test("aD_BFu16i_BFu8i");
    static STRUCT_IF_C aD_BFu16i_BFu8i lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aD_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aD_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu8i, aD_BFu16i_BFu8i)
//============================================================================



static void Test_aD_BFu16i_BFu8ll()
{
  {
    init_simple_test("aD_BFu16i_BFu8ll");
    static STRUCT_IF_C aD_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aD_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aD_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu8ll, aD_BFu16i_BFu8ll)
//============================================================================



static void Test_aD_BFu16i_BFu8s()
{
  {
    init_simple_test("aD_BFu16i_BFu8s");
    static STRUCT_IF_C aD_BFu16i_BFu8s lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "aD_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "aD_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu8s, aD_BFu16i_BFu8s)
//============================================================================



static void Test_aD_BFu16i_BFu9i()
{
  {
    init_simple_test("aD_BFu16i_BFu9i");
    static STRUCT_IF_C aD_BFu16i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "aD_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "aD_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu9i, aD_BFu16i_BFu9i)
//============================================================================



static void Test_aD_BFu16i_BFu9ll()
{
  {
    init_simple_test("aD_BFu16i_BFu9ll");
    static STRUCT_IF_C aD_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "aD_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "aD_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu9ll, aD_BFu16i_BFu9ll)
//============================================================================



static void Test_aD_BFu16i_BFu9s()
{
  {
    init_simple_test("aD_BFu16i_BFu9s");
    static STRUCT_IF_C aD_BFu16i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "aD_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "aD_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_BFu9s, aD_BFu16i_BFu9s)
//============================================================================



static void Test_aD_BFu16i_C()
{
  {
    init_simple_test("aD_BFu16i_C");
    static STRUCT_IF_C aD_BFu16i_C lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_C)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_C");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_C");
    check_field_offset(lv, v3, 10, "aD_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_C, aD_BFu16i_C)
//============================================================================



static void Test_aD_BFu16i_D()
{
  {
    init_simple_test("aD_BFu16i_D");
    static STRUCT_IF_C aD_BFu16i_D lv;
    check2(sizeof(lv), 18, "sizeof(aD_BFu16i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_D)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_D");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_D");
    check_field_offset(lv, v3, 10, "aD_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_D, aD_BFu16i_D)
//============================================================================



static void Test_aD_BFu16i_F()
{
  {
    init_simple_test("aD_BFu16i_F");
    static STRUCT_IF_C aD_BFu16i_F lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu16i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_F)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_F");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_F");
    check_field_offset(lv, v3, 10, "aD_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_F, aD_BFu16i_F)
//============================================================================



static void Test_aD_BFu16i_I()
{
  {
    init_simple_test("aD_BFu16i_I");
    static STRUCT_IF_C aD_BFu16i_I lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu16i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_I)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_I");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_I");
    check_field_offset(lv, v3, 10, "aD_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_I, aD_BFu16i_I)
//============================================================================



static void Test_aD_BFu16i_Ip()
{
  {
    init_simple_test("aD_BFu16i_Ip");
    static STRUCT_IF_C aD_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aD_BFu16i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_Ip");
    check_field_offset(lv, v3, 10, "aD_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_Ip, aD_BFu16i_Ip)
//============================================================================



static void Test_aD_BFu16i_L()
{
  {
    init_simple_test("aD_BFu16i_L");
    static STRUCT_IF_C aD_BFu16i_L lv;
    check2(sizeof(lv), 18, "sizeof(aD_BFu16i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_L)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_L");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_L");
    check_field_offset(lv, v3, 10, "aD_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_L, aD_BFu16i_L)
//============================================================================



static void Test_aD_BFu16i_S()
{
  {
    init_simple_test("aD_BFu16i_S");
    static STRUCT_IF_C aD_BFu16i_S lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_S)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_S");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_S");
    check_field_offset(lv, v3, 10, "aD_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_S, aD_BFu16i_S)
//============================================================================



static void Test_aD_BFu16i_Uc()
{
  {
    init_simple_test("aD_BFu16i_Uc");
    static STRUCT_IF_C aD_BFu16i_Uc lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_Uc");
    check_field_offset(lv, v3, 10, "aD_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_Uc, aD_BFu16i_Uc)
//============================================================================



static void Test_aD_BFu16i_Ui()
{
  {
    init_simple_test("aD_BFu16i_Ui");
    static STRUCT_IF_C aD_BFu16i_Ui lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu16i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_Ui");
    check_field_offset(lv, v3, 10, "aD_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_Ui, aD_BFu16i_Ui)
//============================================================================



static void Test_aD_BFu16i_Ul()
{
  {
    init_simple_test("aD_BFu16i_Ul");
    static STRUCT_IF_C aD_BFu16i_Ul lv;
    check2(sizeof(lv), 18, "sizeof(aD_BFu16i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_Ul");
    check_field_offset(lv, v3, 10, "aD_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_Ul, aD_BFu16i_Ul)
//============================================================================



static void Test_aD_BFu16i_Us()
{
  {
    init_simple_test("aD_BFu16i_Us");
    static STRUCT_IF_C aD_BFu16i_Us lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_Us");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_Us");
    check_field_offset(lv, v3, 10, "aD_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_Us, aD_BFu16i_Us)
//============================================================================



static void Test_aD_BFu16i_Vp()
{
  {
    init_simple_test("aD_BFu16i_Vp");
    static STRUCT_IF_C aD_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(18,14), "sizeof(aD_BFu16i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "aD_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16i_Vp");
    check_field_offset(lv, v3, 10, "aD_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16i_Vp, aD_BFu16i_Vp)
//============================================================================



static void Test_aD_BFu16ll()
{
  {
    init_simple_test("aD_BFu16ll");
    static STRUCT_IF_C aD_BFu16ll lv;
    check2(sizeof(lv), 10, "sizeof(aD_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll, aD_BFu16ll)
//============================================================================



static void Test_aD_BFu16ll_BFu15i()
{
  {
    init_simple_test("aD_BFu16ll_BFu15i");
    static STRUCT_IF_C aD_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aD_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aD_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll_BFu15i, aD_BFu16ll_BFu15i)
//============================================================================



static void Test_aD_BFu16ll_BFu15ll()
{
  {
    init_simple_test("aD_BFu16ll_BFu15ll");
    static STRUCT_IF_C aD_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aD_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aD_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll_BFu15ll, aD_BFu16ll_BFu15ll)
//============================================================================



static void Test_aD_BFu16ll_BFu15s()
{
  {
    init_simple_test("aD_BFu16ll_BFu15s");
    static STRUCT_IF_C aD_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "aD_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "aD_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll_BFu15s, aD_BFu16ll_BFu15s)
//============================================================================



static void Test_aD_BFu16ll_BFu16i()
{
  {
    init_simple_test("aD_BFu16ll_BFu16i");
    static STRUCT_IF_C aD_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aD_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll_BFu16i, aD_BFu16ll_BFu16i)
//============================================================================



static void Test_aD_BFu16ll_BFu16ll()
{
  {
    init_simple_test("aD_BFu16ll_BFu16ll");
    static STRUCT_IF_C aD_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aD_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll_BFu16ll, aD_BFu16ll_BFu16ll)
//============================================================================



static void Test_aD_BFu16ll_BFu16s()
{
  {
    init_simple_test("aD_BFu16ll_BFu16s");
    static STRUCT_IF_C aD_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(aD_BFu16ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "aD_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll_BFu16s, aD_BFu16ll_BFu16s)
//============================================================================



static void Test_aD_BFu16ll_BFu17i()
{
  {
    init_simple_test("aD_BFu16ll_BFu17i");
    static STRUCT_IF_C aD_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 13, "sizeof(aD_BFu16ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "aD_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "aD_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll_BFu17i, aD_BFu16ll_BFu17i)
//============================================================================



static void Test_aD_BFu16ll_BFu17ll()
{
  {
    init_simple_test("aD_BFu16ll_BFu17ll");
    static STRUCT_IF_C aD_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 13, "sizeof(aD_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "aD_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "aD_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll_BFu17ll, aD_BFu16ll_BFu17ll)
//============================================================================



static void Test_aD_BFu16ll_BFu1c()
{
  {
    init_simple_test("aD_BFu16ll_BFu1c");
    static STRUCT_IF_C aD_BFu16ll_BFu1c lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aD_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll_BFu1c, aD_BFu16ll_BFu1c)
//============================================================================



static void Test_aD_BFu16ll_BFu1i()
{
  {
    init_simple_test("aD_BFu16ll_BFu1i");
    static STRUCT_IF_C aD_BFu16ll_BFu1i lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aD_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll_BFu1i, aD_BFu16ll_BFu1i)
//============================================================================



static void Test_aD_BFu16ll_BFu1ll()
{
  {
    init_simple_test("aD_BFu16ll_BFu1ll");
    static STRUCT_IF_C aD_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aD_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll_BFu1ll, aD_BFu16ll_BFu1ll)
//============================================================================



static void Test_aD_BFu16ll_BFu1s()
{
  {
    init_simple_test("aD_BFu16ll_BFu1s");
    static STRUCT_IF_C aD_BFu16ll_BFu1s lv;
    check2(sizeof(lv), 11, "sizeof(aD_BFu16ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "aD_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll_BFu1s, aD_BFu16ll_BFu1s)
//============================================================================



static void Test_aD_BFu16ll_BFu31i()
{
  {
    init_simple_test("aD_BFu16ll_BFu31i");
    static STRUCT_IF_C aD_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 14, "sizeof(aD_BFu16ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aD_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "aD_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 16, 1, "aD_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 16, hide_ull(1LL<<15), "aD_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "aD_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "aD_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aD_BFu16ll_BFu31i, aD_BFu16ll_BFu31i)
//============================================================================
