// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
struct __attribute__((packed)) aBFu8ll_D_BFu15s { unsigned long long v1:8; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8ll_D_BFu16i { unsigned long long v1:8; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8ll_D_BFu16ll { unsigned long long v1:8; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8ll_D_BFu16s { unsigned long long v1:8; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8ll_D_BFu17i { unsigned long long v1:8; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8ll_D_BFu17ll { unsigned long long v1:8; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8ll_D_BFu1c { unsigned long long v1:8; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8ll_D_BFu1i { unsigned long long v1:8; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8ll_D_BFu1ll { unsigned long long v1:8; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8ll_D_BFu1s { unsigned long long v1:8; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8ll_D_BFu31i { unsigned long long v1:8; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8ll_D_BFu31ll { unsigned long long v1:8; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8ll_D_BFu32i { unsigned long long v1:8; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8ll_D_BFu32ll { unsigned long long v1:8; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8ll_D_BFu33 { unsigned long long v1:8; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8ll_D_BFu7c { unsigned long long v1:8; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8ll_D_BFu7i { unsigned long long v1:8; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8ll_D_BFu7ll { unsigned long long v1:8; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8ll_D_BFu7s { unsigned long long v1:8; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8ll_D_BFu8c { unsigned long long v1:8; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8ll_D_BFu8i { unsigned long long v1:8; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8ll_D_BFu8ll { unsigned long long v1:8; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8ll_D_BFu8s { unsigned long long v1:8; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8ll_D_BFu9i { unsigned long long v1:8; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8ll_D_BFu9ll { unsigned long long v1:8; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8ll_D_BFu9s { unsigned long long v1:8; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8ll_D_C { unsigned long long v1:8; double v2; char v3; };
struct __attribute__((packed)) aBFu8ll_D_D { unsigned long long v1:8; double v2; double v3; };
struct __attribute__((packed)) aBFu8ll_D_F { unsigned long long v1:8; double v2; float v3; };
struct __attribute__((packed)) aBFu8ll_D_I { unsigned long long v1:8; double v2; int v3; };
struct __attribute__((packed)) aBFu8ll_D_Ip { unsigned long long v1:8; double v2; int * v3; };
struct __attribute__((packed)) aBFu8ll_D_L { unsigned long long v1:8; double v2; long long v3; };
struct __attribute__((packed)) aBFu8ll_D_S { unsigned long long v1:8; double v2; short v3; };
struct __attribute__((packed)) aBFu8ll_D_Uc { unsigned long long v1:8; double v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8ll_D_Ui { unsigned long long v1:8; double v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8ll_D_Ul { unsigned long long v1:8; double v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8ll_D_Us { unsigned long long v1:8; double v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8ll_D_Vp { unsigned long long v1:8; double v2; void * v3; };
struct __attribute__((packed)) aBFu8ll_F { unsigned long long v1:8; float v2; };
struct __attribute__((packed)) aBFu8ll_F_BFu15i { unsigned long long v1:8; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8ll_F_BFu15ll { unsigned long long v1:8; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8ll_F_BFu15s { unsigned long long v1:8; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8ll_F_BFu16i { unsigned long long v1:8; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8ll_F_BFu16ll { unsigned long long v1:8; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8ll_F_BFu16s { unsigned long long v1:8; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8ll_F_BFu17i { unsigned long long v1:8; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8ll_F_BFu17ll { unsigned long long v1:8; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8ll_F_BFu1c { unsigned long long v1:8; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8ll_F_BFu1i { unsigned long long v1:8; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8ll_F_BFu1ll { unsigned long long v1:8; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8ll_F_BFu1s { unsigned long long v1:8; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8ll_F_BFu31i { unsigned long long v1:8; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8ll_F_BFu31ll { unsigned long long v1:8; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8ll_F_BFu32i { unsigned long long v1:8; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8ll_F_BFu32ll { unsigned long long v1:8; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8ll_F_BFu33 { unsigned long long v1:8; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8ll_F_BFu7c { unsigned long long v1:8; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8ll_F_BFu7i { unsigned long long v1:8; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8ll_F_BFu7ll { unsigned long long v1:8; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8ll_F_BFu7s { unsigned long long v1:8; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8ll_F_BFu8c { unsigned long long v1:8; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8ll_F_BFu8i { unsigned long long v1:8; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8ll_F_BFu8ll { unsigned long long v1:8; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8ll_F_BFu8s { unsigned long long v1:8; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8ll_F_BFu9i { unsigned long long v1:8; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8ll_F_BFu9ll { unsigned long long v1:8; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8ll_F_BFu9s { unsigned long long v1:8; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8ll_F_C { unsigned long long v1:8; float v2; char v3; };
struct __attribute__((packed)) aBFu8ll_F_D { unsigned long long v1:8; float v2; double v3; };
struct __attribute__((packed)) aBFu8ll_F_F { unsigned long long v1:8; float v2; float v3; };
struct __attribute__((packed)) aBFu8ll_F_I { unsigned long long v1:8; float v2; int v3; };
struct __attribute__((packed)) aBFu8ll_F_Ip { unsigned long long v1:8; float v2; int * v3; };
struct __attribute__((packed)) aBFu8ll_F_L { unsigned long long v1:8; float v2; long long v3; };
struct __attribute__((packed)) aBFu8ll_F_S { unsigned long long v1:8; float v2; short v3; };
struct __attribute__((packed)) aBFu8ll_F_Uc { unsigned long long v1:8; float v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8ll_F_Ui { unsigned long long v1:8; float v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8ll_F_Ul { unsigned long long v1:8; float v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8ll_F_Us { unsigned long long v1:8; float v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8ll_F_Vp { unsigned long long v1:8; float v2; void * v3; };
struct __attribute__((packed)) aBFu8ll_I { unsigned long long v1:8; int v2; };
struct __attribute__((packed)) aBFu8ll_I_BFu15i { unsigned long long v1:8; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8ll_I_BFu15ll { unsigned long long v1:8; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8ll_I_BFu15s { unsigned long long v1:8; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8ll_I_BFu16i { unsigned long long v1:8; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8ll_I_BFu16ll { unsigned long long v1:8; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8ll_I_BFu16s { unsigned long long v1:8; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8ll_I_BFu17i { unsigned long long v1:8; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8ll_I_BFu17ll { unsigned long long v1:8; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8ll_I_BFu1c { unsigned long long v1:8; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8ll_I_BFu1i { unsigned long long v1:8; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8ll_I_BFu1ll { unsigned long long v1:8; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8ll_I_BFu1s { unsigned long long v1:8; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8ll_I_BFu31i { unsigned long long v1:8; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8ll_I_BFu31ll { unsigned long long v1:8; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8ll_I_BFu32i { unsigned long long v1:8; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8ll_I_BFu32ll { unsigned long long v1:8; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8ll_I_BFu33 { unsigned long long v1:8; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8ll_I_BFu7c { unsigned long long v1:8; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8ll_I_BFu7i { unsigned long long v1:8; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8ll_I_BFu7ll { unsigned long long v1:8; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8ll_I_BFu7s { unsigned long long v1:8; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8ll_I_BFu8c { unsigned long long v1:8; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8ll_I_BFu8i { unsigned long long v1:8; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8ll_I_BFu8ll { unsigned long long v1:8; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8ll_I_BFu8s { unsigned long long v1:8; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8ll_I_BFu9i { unsigned long long v1:8; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8ll_I_BFu9ll { unsigned long long v1:8; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8ll_I_BFu9s { unsigned long long v1:8; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8ll_I_C { unsigned long long v1:8; int v2; char v3; };
struct __attribute__((packed)) aBFu8ll_I_D { unsigned long long v1:8; int v2; double v3; };
struct __attribute__((packed)) aBFu8ll_I_F { unsigned long long v1:8; int v2; float v3; };
struct __attribute__((packed)) aBFu8ll_I_I { unsigned long long v1:8; int v2; int v3; };
struct __attribute__((packed)) aBFu8ll_I_Ip { unsigned long long v1:8; int v2; int * v3; };
struct __attribute__((packed)) aBFu8ll_I_L { unsigned long long v1:8; int v2; long long v3; };
struct __attribute__((packed)) aBFu8ll_I_S { unsigned long long v1:8; int v2; short v3; };
struct __attribute__((packed)) aBFu8ll_I_Uc { unsigned long long v1:8; int v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8ll_I_Ui { unsigned long long v1:8; int v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8ll_I_Ul { unsigned long long v1:8; int v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8ll_I_Us { unsigned long long v1:8; int v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8ll_I_Vp { unsigned long long v1:8; int v2; void * v3; };
struct __attribute__((packed)) aBFu8ll_Ip { unsigned long long v1:8; int * v2; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu15i { unsigned long long v1:8; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu15ll { unsigned long long v1:8; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu15s { unsigned long long v1:8; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu16i { unsigned long long v1:8; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu16ll { unsigned long long v1:8; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu16s { unsigned long long v1:8; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu17i { unsigned long long v1:8; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu17ll { unsigned long long v1:8; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu1c { unsigned long long v1:8; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu1i { unsigned long long v1:8; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu1ll { unsigned long long v1:8; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu1s { unsigned long long v1:8; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu31i { unsigned long long v1:8; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu31ll { unsigned long long v1:8; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu32i { unsigned long long v1:8; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu32ll { unsigned long long v1:8; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu33 { unsigned long long v1:8; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu7c { unsigned long long v1:8; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu7i { unsigned long long v1:8; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu7ll { unsigned long long v1:8; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu7s { unsigned long long v1:8; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu8c { unsigned long long v1:8; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu8i { unsigned long long v1:8; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu8ll { unsigned long long v1:8; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu8s { unsigned long long v1:8; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu9i { unsigned long long v1:8; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu9ll { unsigned long long v1:8; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8ll_Ip_BFu9s { unsigned long long v1:8; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8ll_Ip_C { unsigned long long v1:8; int * v2; char v3; };
struct __attribute__((packed)) aBFu8ll_Ip_D { unsigned long long v1:8; int * v2; double v3; };
struct __attribute__((packed)) aBFu8ll_Ip_F { unsigned long long v1:8; int * v2; float v3; };
struct __attribute__((packed)) aBFu8ll_Ip_I { unsigned long long v1:8; int * v2; int v3; };
struct __attribute__((packed)) aBFu8ll_Ip_Ip { unsigned long long v1:8; int * v2; int * v3; };
struct __attribute__((packed)) aBFu8ll_Ip_L { unsigned long long v1:8; int * v2; long long v3; };
struct __attribute__((packed)) aBFu8ll_Ip_S { unsigned long long v1:8; int * v2; short v3; };
struct __attribute__((packed)) aBFu8ll_Ip_Uc { unsigned long long v1:8; int * v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8ll_Ip_Ui { unsigned long long v1:8; int * v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8ll_Ip_Ul { unsigned long long v1:8; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8ll_Ip_Us { unsigned long long v1:8; int * v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8ll_Ip_Vp { unsigned long long v1:8; int * v2; void * v3; };
struct __attribute__((packed)) aBFu8ll_L { unsigned long long v1:8; long long v2; };
struct __attribute__((packed)) aBFu8ll_L_BFu15i { unsigned long long v1:8; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8ll_L_BFu15ll { unsigned long long v1:8; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8ll_L_BFu15s { unsigned long long v1:8; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8ll_L_BFu16i { unsigned long long v1:8; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8ll_L_BFu16ll { unsigned long long v1:8; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8ll_L_BFu16s { unsigned long long v1:8; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8ll_L_BFu17i { unsigned long long v1:8; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8ll_L_BFu17ll { unsigned long long v1:8; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8ll_L_BFu1c { unsigned long long v1:8; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8ll_L_BFu1i { unsigned long long v1:8; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8ll_L_BFu1ll { unsigned long long v1:8; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8ll_L_BFu1s { unsigned long long v1:8; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8ll_L_BFu31i { unsigned long long v1:8; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8ll_L_BFu31ll { unsigned long long v1:8; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8ll_L_BFu32i { unsigned long long v1:8; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8ll_L_BFu32ll { unsigned long long v1:8; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8ll_L_BFu33 { unsigned long long v1:8; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8ll_L_BFu7c { unsigned long long v1:8; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8ll_L_BFu7i { unsigned long long v1:8; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8ll_L_BFu7ll { unsigned long long v1:8; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8ll_L_BFu7s { unsigned long long v1:8; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8ll_L_BFu8c { unsigned long long v1:8; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8ll_L_BFu8i { unsigned long long v1:8; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8ll_L_BFu8ll { unsigned long long v1:8; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8ll_L_BFu8s { unsigned long long v1:8; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8ll_L_BFu9i { unsigned long long v1:8; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8ll_L_BFu9ll { unsigned long long v1:8; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8ll_L_BFu9s { unsigned long long v1:8; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8ll_L_C { unsigned long long v1:8; long long v2; char v3; };
struct __attribute__((packed)) aBFu8ll_L_D { unsigned long long v1:8; long long v2; double v3; };
struct __attribute__((packed)) aBFu8ll_L_F { unsigned long long v1:8; long long v2; float v3; };
struct __attribute__((packed)) aBFu8ll_L_I { unsigned long long v1:8; long long v2; int v3; };
struct __attribute__((packed)) aBFu8ll_L_Ip { unsigned long long v1:8; long long v2; int * v3; };
struct __attribute__((packed)) aBFu8ll_L_L { unsigned long long v1:8; long long v2; long long v3; };
struct __attribute__((packed)) aBFu8ll_L_S { unsigned long long v1:8; long long v2; short v3; };
struct __attribute__((packed)) aBFu8ll_L_Uc { unsigned long long v1:8; long long v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8ll_L_Ui { unsigned long long v1:8; long long v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8ll_L_Ul { unsigned long long v1:8; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8ll_L_Us { unsigned long long v1:8; long long v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8ll_L_Vp { unsigned long long v1:8; long long v2; void * v3; };
struct __attribute__((packed)) aBFu8ll_S { unsigned long long v1:8; short v2; };
struct __attribute__((packed)) aBFu8ll_S_BFu15i { unsigned long long v1:8; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8ll_S_BFu15ll { unsigned long long v1:8; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8ll_S_BFu15s { unsigned long long v1:8; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8ll_S_BFu16i { unsigned long long v1:8; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8ll_S_BFu16ll { unsigned long long v1:8; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8ll_S_BFu16s { unsigned long long v1:8; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8ll_S_BFu17i { unsigned long long v1:8; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8ll_S_BFu17ll { unsigned long long v1:8; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8ll_S_BFu1c { unsigned long long v1:8; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8ll_S_BFu1i { unsigned long long v1:8; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8ll_S_BFu1ll { unsigned long long v1:8; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8ll_S_BFu1s { unsigned long long v1:8; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8ll_S_BFu31i { unsigned long long v1:8; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8ll_S_BFu31ll { unsigned long long v1:8; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8ll_S_BFu32i { unsigned long long v1:8; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8ll_S_BFu32ll { unsigned long long v1:8; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8ll_S_BFu33 { unsigned long long v1:8; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8ll_S_BFu7c { unsigned long long v1:8; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8ll_S_BFu7i { unsigned long long v1:8; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8ll_S_BFu7ll { unsigned long long v1:8; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8ll_S_BFu7s { unsigned long long v1:8; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8ll_S_BFu8c { unsigned long long v1:8; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8ll_S_BFu8i { unsigned long long v1:8; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8ll_S_BFu8ll { unsigned long long v1:8; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8ll_S_BFu8s { unsigned long long v1:8; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8ll_S_BFu9i { unsigned long long v1:8; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8ll_S_BFu9ll { unsigned long long v1:8; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8ll_S_BFu9s { unsigned long long v1:8; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8ll_S_C { unsigned long long v1:8; short v2; char v3; };
struct __attribute__((packed)) aBFu8ll_S_D { unsigned long long v1:8; short v2; double v3; };
struct __attribute__((packed)) aBFu8ll_S_F { unsigned long long v1:8; short v2; float v3; };
struct __attribute__((packed)) aBFu8ll_S_I { unsigned long long v1:8; short v2; int v3; };
struct __attribute__((packed)) aBFu8ll_S_Ip { unsigned long long v1:8; short v2; int * v3; };
struct __attribute__((packed)) aBFu8ll_S_L { unsigned long long v1:8; short v2; long long v3; };
struct __attribute__((packed)) aBFu8ll_S_S { unsigned long long v1:8; short v2; short v3; };
struct __attribute__((packed)) aBFu8ll_S_Uc { unsigned long long v1:8; short v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8ll_S_Ui { unsigned long long v1:8; short v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8ll_S_Ul { unsigned long long v1:8; short v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8ll_S_Us { unsigned long long v1:8; short v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8ll_S_Vp { unsigned long long v1:8; short v2; void * v3; };
struct __attribute__((packed)) aBFu8ll_Uc { unsigned long long v1:8; unsigned char v2; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu15i { unsigned long long v1:8; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu15ll { unsigned long long v1:8; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu15s { unsigned long long v1:8; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu16i { unsigned long long v1:8; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu16ll { unsigned long long v1:8; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu16s { unsigned long long v1:8; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu17i { unsigned long long v1:8; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu17ll { unsigned long long v1:8; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu1c { unsigned long long v1:8; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu1i { unsigned long long v1:8; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu1ll { unsigned long long v1:8; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu1s { unsigned long long v1:8; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu31i { unsigned long long v1:8; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu31ll { unsigned long long v1:8; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu32i { unsigned long long v1:8; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu32ll { unsigned long long v1:8; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu33 { unsigned long long v1:8; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu7c { unsigned long long v1:8; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu7i { unsigned long long v1:8; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu7ll { unsigned long long v1:8; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu7s { unsigned long long v1:8; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu8c { unsigned long long v1:8; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu8i { unsigned long long v1:8; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu8ll { unsigned long long v1:8; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu8s { unsigned long long v1:8; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu9i { unsigned long long v1:8; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu9ll { unsigned long long v1:8; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8ll_Uc_BFu9s { unsigned long long v1:8; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8ll_Uc_C { unsigned long long v1:8; unsigned char v2; char v3; };
struct __attribute__((packed)) aBFu8ll_Uc_D { unsigned long long v1:8; unsigned char v2; double v3; };
struct __attribute__((packed)) aBFu8ll_Uc_F { unsigned long long v1:8; unsigned char v2; float v3; };
struct __attribute__((packed)) aBFu8ll_Uc_I { unsigned long long v1:8; unsigned char v2; int v3; };
struct __attribute__((packed)) aBFu8ll_Uc_Ip { unsigned long long v1:8; unsigned char v2; int * v3; };
struct __attribute__((packed)) aBFu8ll_Uc_L { unsigned long long v1:8; unsigned char v2; long long v3; };
struct __attribute__((packed)) aBFu8ll_Uc_S { unsigned long long v1:8; unsigned char v2; short v3; };
struct __attribute__((packed)) aBFu8ll_Uc_Uc { unsigned long long v1:8; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8ll_Uc_Ui { unsigned long long v1:8; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8ll_Uc_Ul { unsigned long long v1:8; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8ll_Uc_Us { unsigned long long v1:8; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8ll_Uc_Vp { unsigned long long v1:8; unsigned char v2; void * v3; };
struct __attribute__((packed)) aBFu8ll_Ui { unsigned long long v1:8; unsigned int v2; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu15i { unsigned long long v1:8; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu15ll { unsigned long long v1:8; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu15s { unsigned long long v1:8; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu16i { unsigned long long v1:8; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu16ll { unsigned long long v1:8; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu16s { unsigned long long v1:8; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu17i { unsigned long long v1:8; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu17ll { unsigned long long v1:8; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu1c { unsigned long long v1:8; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu1i { unsigned long long v1:8; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu1ll { unsigned long long v1:8; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu1s { unsigned long long v1:8; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu31i { unsigned long long v1:8; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu31ll { unsigned long long v1:8; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu32i { unsigned long long v1:8; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu32ll { unsigned long long v1:8; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu33 { unsigned long long v1:8; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu7c { unsigned long long v1:8; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu7i { unsigned long long v1:8; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu7ll { unsigned long long v1:8; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu7s { unsigned long long v1:8; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu8c { unsigned long long v1:8; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu8i { unsigned long long v1:8; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu8ll { unsigned long long v1:8; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu8s { unsigned long long v1:8; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu9i { unsigned long long v1:8; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu9ll { unsigned long long v1:8; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8ll_Ui_BFu9s { unsigned long long v1:8; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8ll_Ui_C { unsigned long long v1:8; unsigned int v2; char v3; };
struct __attribute__((packed)) aBFu8ll_Ui_D { unsigned long long v1:8; unsigned int v2; double v3; };
struct __attribute__((packed)) aBFu8ll_Ui_F { unsigned long long v1:8; unsigned int v2; float v3; };
struct __attribute__((packed)) aBFu8ll_Ui_I { unsigned long long v1:8; unsigned int v2; int v3; };
struct __attribute__((packed)) aBFu8ll_Ui_Ip { unsigned long long v1:8; unsigned int v2; int * v3; };
struct __attribute__((packed)) aBFu8ll_Ui_L { unsigned long long v1:8; unsigned int v2; long long v3; };
struct __attribute__((packed)) aBFu8ll_Ui_S { unsigned long long v1:8; unsigned int v2; short v3; };
struct __attribute__((packed)) aBFu8ll_Ui_Uc { unsigned long long v1:8; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8ll_Ui_Ui { unsigned long long v1:8; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8ll_Ui_Ul { unsigned long long v1:8; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8ll_Ui_Us { unsigned long long v1:8; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8ll_Ui_Vp { unsigned long long v1:8; unsigned int v2; void * v3; };
struct __attribute__((packed)) aBFu8ll_Ul { unsigned long long v1:8; unsigned long long v2; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu15i { unsigned long long v1:8; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu15ll { unsigned long long v1:8; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu15s { unsigned long long v1:8; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu16i { unsigned long long v1:8; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu16ll { unsigned long long v1:8; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu16s { unsigned long long v1:8; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu17i { unsigned long long v1:8; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu17ll { unsigned long long v1:8; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu1c { unsigned long long v1:8; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu1i { unsigned long long v1:8; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu1ll { unsigned long long v1:8; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu1s { unsigned long long v1:8; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu31i { unsigned long long v1:8; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu31ll { unsigned long long v1:8; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu32i { unsigned long long v1:8; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu32ll { unsigned long long v1:8; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu33 { unsigned long long v1:8; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu7c { unsigned long long v1:8; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu7i { unsigned long long v1:8; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu7ll { unsigned long long v1:8; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu7s { unsigned long long v1:8; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu8c { unsigned long long v1:8; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu8i { unsigned long long v1:8; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu8ll { unsigned long long v1:8; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu8s { unsigned long long v1:8; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu9i { unsigned long long v1:8; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu9ll { unsigned long long v1:8; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8ll_Ul_BFu9s { unsigned long long v1:8; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8ll_Ul_C { unsigned long long v1:8; unsigned long long v2; char v3; };
struct __attribute__((packed)) aBFu8ll_Ul_D { unsigned long long v1:8; unsigned long long v2; double v3; };
struct __attribute__((packed)) aBFu8ll_Ul_F { unsigned long long v1:8; unsigned long long v2; float v3; };
struct __attribute__((packed)) aBFu8ll_Ul_I { unsigned long long v1:8; unsigned long long v2; int v3; };
struct __attribute__((packed)) aBFu8ll_Ul_Ip { unsigned long long v1:8; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aBFu8ll_Ul_L { unsigned long long v1:8; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aBFu8ll_Ul_S { unsigned long long v1:8; unsigned long long v2; short v3; };
struct __attribute__((packed)) aBFu8ll_Ul_Uc { unsigned long long v1:8; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8ll_Ul_Ui { unsigned long long v1:8; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8ll_Ul_Ul { unsigned long long v1:8; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8ll_Ul_Us { unsigned long long v1:8; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8ll_Ul_Vp { unsigned long long v1:8; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aBFu8ll_Us { unsigned long long v1:8; unsigned short v2; };
struct __attribute__((packed)) aBFu8ll_Us_BFu15i { unsigned long long v1:8; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8ll_Us_BFu15ll { unsigned long long v1:8; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8ll_Us_BFu15s { unsigned long long v1:8; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8ll_Us_BFu16i { unsigned long long v1:8; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8ll_Us_BFu16ll { unsigned long long v1:8; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8ll_Us_BFu16s { unsigned long long v1:8; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8ll_Us_BFu17i { unsigned long long v1:8; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8ll_Us_BFu17ll { unsigned long long v1:8; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8ll_Us_BFu1c { unsigned long long v1:8; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8ll_Us_BFu1i { unsigned long long v1:8; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8ll_Us_BFu1ll { unsigned long long v1:8; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8ll_Us_BFu1s { unsigned long long v1:8; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8ll_Us_BFu31i { unsigned long long v1:8; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8ll_Us_BFu31ll { unsigned long long v1:8; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8ll_Us_BFu32i { unsigned long long v1:8; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8ll_Us_BFu32ll { unsigned long long v1:8; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8ll_Us_BFu33 { unsigned long long v1:8; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8ll_Us_BFu7c { unsigned long long v1:8; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8ll_Us_BFu7i { unsigned long long v1:8; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8ll_Us_BFu7ll { unsigned long long v1:8; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8ll_Us_BFu7s { unsigned long long v1:8; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8ll_Us_BFu8c { unsigned long long v1:8; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8ll_Us_BFu8i { unsigned long long v1:8; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8ll_Us_BFu8ll { unsigned long long v1:8; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8ll_Us_BFu8s { unsigned long long v1:8; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8ll_Us_BFu9i { unsigned long long v1:8; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8ll_Us_BFu9ll { unsigned long long v1:8; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8ll_Us_BFu9s { unsigned long long v1:8; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8ll_Us_C { unsigned long long v1:8; unsigned short v2; char v3; };
struct __attribute__((packed)) aBFu8ll_Us_D { unsigned long long v1:8; unsigned short v2; double v3; };
struct __attribute__((packed)) aBFu8ll_Us_F { unsigned long long v1:8; unsigned short v2; float v3; };
struct __attribute__((packed)) aBFu8ll_Us_I { unsigned long long v1:8; unsigned short v2; int v3; };
struct __attribute__((packed)) aBFu8ll_Us_Ip { unsigned long long v1:8; unsigned short v2; int * v3; };
struct __attribute__((packed)) aBFu8ll_Us_L { unsigned long long v1:8; unsigned short v2; long long v3; };
struct __attribute__((packed)) aBFu8ll_Us_S { unsigned long long v1:8; unsigned short v2; short v3; };
struct __attribute__((packed)) aBFu8ll_Us_Uc { unsigned long long v1:8; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8ll_Us_Ui { unsigned long long v1:8; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8ll_Us_Ul { unsigned long long v1:8; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8ll_Us_Us { unsigned long long v1:8; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8ll_Us_Vp { unsigned long long v1:8; unsigned short v2; void * v3; };
struct __attribute__((packed)) aBFu8ll_Vp { unsigned long long v1:8; void * v2; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu15i { unsigned long long v1:8; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu15ll { unsigned long long v1:8; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu15s { unsigned long long v1:8; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu16i { unsigned long long v1:8; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu16ll { unsigned long long v1:8; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu16s { unsigned long long v1:8; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu17i { unsigned long long v1:8; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu17ll { unsigned long long v1:8; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu1c { unsigned long long v1:8; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu1i { unsigned long long v1:8; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu1ll { unsigned long long v1:8; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu1s { unsigned long long v1:8; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu31i { unsigned long long v1:8; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu31ll { unsigned long long v1:8; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu32i { unsigned long long v1:8; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu32ll { unsigned long long v1:8; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu33 { unsigned long long v1:8; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu7c { unsigned long long v1:8; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu7i { unsigned long long v1:8; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu7ll { unsigned long long v1:8; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu7s { unsigned long long v1:8; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu8c { unsigned long long v1:8; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu8i { unsigned long long v1:8; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu8ll { unsigned long long v1:8; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu8s { unsigned long long v1:8; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu9i { unsigned long long v1:8; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu9ll { unsigned long long v1:8; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8ll_Vp_BFu9s { unsigned long long v1:8; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8ll_Vp_C { unsigned long long v1:8; void * v2; char v3; };
struct __attribute__((packed)) aBFu8ll_Vp_D { unsigned long long v1:8; void * v2; double v3; };
struct __attribute__((packed)) aBFu8ll_Vp_F { unsigned long long v1:8; void * v2; float v3; };
struct __attribute__((packed)) aBFu8ll_Vp_I { unsigned long long v1:8; void * v2; int v3; };
struct __attribute__((packed)) aBFu8ll_Vp_Ip { unsigned long long v1:8; void * v2; int * v3; };
struct __attribute__((packed)) aBFu8ll_Vp_L { unsigned long long v1:8; void * v2; long long v3; };
struct __attribute__((packed)) aBFu8ll_Vp_S { unsigned long long v1:8; void * v2; short v3; };
struct __attribute__((packed)) aBFu8ll_Vp_Uc { unsigned long long v1:8; void * v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8ll_Vp_Ui { unsigned long long v1:8; void * v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8ll_Vp_Ul { unsigned long long v1:8; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8ll_Vp_Us { unsigned long long v1:8; void * v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8ll_Vp_Vp { unsigned long long v1:8; void * v2; void * v3; };
struct __attribute__((packed)) aBFu8s { unsigned short v1:8; };
struct __attribute__((packed)) aBFu8s_BFs8c { unsigned short v1:8; signed char v2:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8c { unsigned short v1:8; signed char v2:8; signed char v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8c_BFs8c { unsigned short v1:8; signed char v2:8; signed char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8c_BFs8i { unsigned short v1:8; signed char v2:8; signed char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8c_BFs8ll { unsigned short v1:8; signed char v2:8; signed char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8c_BFs8s { unsigned short v1:8; signed char v2:8; signed char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8c_BFu8c { unsigned short v1:8; signed char v2:8; signed char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8c_BFu8i { unsigned short v1:8; signed char v2:8; signed char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8c_BFu8ll { unsigned short v1:8; signed char v2:8; signed char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8c_BFu8s { unsigned short v1:8; signed char v2:8; signed char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8i { unsigned short v1:8; signed char v2:8; signed int v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8i_BFs8c { unsigned short v1:8; signed char v2:8; signed int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8i_BFs8i { unsigned short v1:8; signed char v2:8; signed int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8i_BFs8ll { unsigned short v1:8; signed char v2:8; signed int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8i_BFs8s { unsigned short v1:8; signed char v2:8; signed int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8i_BFu8c { unsigned short v1:8; signed char v2:8; signed int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8i_BFu8i { unsigned short v1:8; signed char v2:8; signed int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8i_BFu8ll { unsigned short v1:8; signed char v2:8; signed int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8i_BFu8s { unsigned short v1:8; signed char v2:8; signed int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8ll { unsigned short v1:8; signed char v2:8; signed long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8ll_BFs8c { unsigned short v1:8; signed char v2:8; signed long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8ll_BFs8i { unsigned short v1:8; signed char v2:8; signed long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8ll_BFs8ll { unsigned short v1:8; signed char v2:8; signed long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8ll_BFs8s { unsigned short v1:8; signed char v2:8; signed long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8ll_BFu8c { unsigned short v1:8; signed char v2:8; signed long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8ll_BFu8i { unsigned short v1:8; signed char v2:8; signed long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8ll_BFu8ll { unsigned short v1:8; signed char v2:8; signed long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8ll_BFu8s { unsigned short v1:8; signed char v2:8; signed long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8s { unsigned short v1:8; signed char v2:8; signed short v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8s_BFs8c { unsigned short v1:8; signed char v2:8; signed short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8s_BFs8i { unsigned short v1:8; signed char v2:8; signed short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8s_BFs8ll { unsigned short v1:8; signed char v2:8; signed short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8s_BFs8s { unsigned short v1:8; signed char v2:8; signed short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8s_BFu8c { unsigned short v1:8; signed char v2:8; signed short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8s_BFu8i { unsigned short v1:8; signed char v2:8; signed short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8s_BFu8ll { unsigned short v1:8; signed char v2:8; signed short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFs8s_BFu8s { unsigned short v1:8; signed char v2:8; signed short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8c { unsigned short v1:8; signed char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8c_BFs8c { unsigned short v1:8; signed char v2:8; unsigned char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8c_BFs8i { unsigned short v1:8; signed char v2:8; unsigned char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8c_BFs8ll { unsigned short v1:8; signed char v2:8; unsigned char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8c_BFs8s { unsigned short v1:8; signed char v2:8; unsigned char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8c_BFu8c { unsigned short v1:8; signed char v2:8; unsigned char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8c_BFu8i { unsigned short v1:8; signed char v2:8; unsigned char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8c_BFu8ll { unsigned short v1:8; signed char v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8c_BFu8s { unsigned short v1:8; signed char v2:8; unsigned char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8i { unsigned short v1:8; signed char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8i_BFs8c { unsigned short v1:8; signed char v2:8; unsigned int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8i_BFs8i { unsigned short v1:8; signed char v2:8; unsigned int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8i_BFs8ll { unsigned short v1:8; signed char v2:8; unsigned int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8i_BFs8s { unsigned short v1:8; signed char v2:8; unsigned int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8i_BFu8c { unsigned short v1:8; signed char v2:8; unsigned int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8i_BFu8i { unsigned short v1:8; signed char v2:8; unsigned int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8i_BFu8ll { unsigned short v1:8; signed char v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8i_BFu8s { unsigned short v1:8; signed char v2:8; unsigned int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8ll { unsigned short v1:8; signed char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8ll_BFs8c { unsigned short v1:8; signed char v2:8; unsigned long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8ll_BFs8i { unsigned short v1:8; signed char v2:8; unsigned long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8ll_BFs8ll { unsigned short v1:8; signed char v2:8; unsigned long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8ll_BFs8s { unsigned short v1:8; signed char v2:8; unsigned long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8ll_BFu8c { unsigned short v1:8; signed char v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8ll_BFu8i { unsigned short v1:8; signed char v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8ll_BFu8ll { unsigned short v1:8; signed char v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8ll_BFu8s { unsigned short v1:8; signed char v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8s { unsigned short v1:8; signed char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8s_BFs8c { unsigned short v1:8; signed char v2:8; unsigned short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8s_BFs8i { unsigned short v1:8; signed char v2:8; unsigned short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8s_BFs8ll { unsigned short v1:8; signed char v2:8; unsigned short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8s_BFs8s { unsigned short v1:8; signed char v2:8; unsigned short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8s_BFu8c { unsigned short v1:8; signed char v2:8; unsigned short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8s_BFu8i { unsigned short v1:8; signed char v2:8; unsigned short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8s_BFu8ll { unsigned short v1:8; signed char v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8c_BFu8s_BFu8s { unsigned short v1:8; signed char v2:8; unsigned short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i { unsigned short v1:8; signed int v2:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8c { unsigned short v1:8; signed int v2:8; signed char v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8c_BFs8c { unsigned short v1:8; signed int v2:8; signed char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8c_BFs8i { unsigned short v1:8; signed int v2:8; signed char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8c_BFs8ll { unsigned short v1:8; signed int v2:8; signed char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8c_BFs8s { unsigned short v1:8; signed int v2:8; signed char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8c_BFu8c { unsigned short v1:8; signed int v2:8; signed char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8c_BFu8i { unsigned short v1:8; signed int v2:8; signed char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8c_BFu8ll { unsigned short v1:8; signed int v2:8; signed char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8c_BFu8s { unsigned short v1:8; signed int v2:8; signed char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8i { unsigned short v1:8; signed int v2:8; signed int v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8i_BFs8c { unsigned short v1:8; signed int v2:8; signed int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8i_BFs8i { unsigned short v1:8; signed int v2:8; signed int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8i_BFs8ll { unsigned short v1:8; signed int v2:8; signed int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8i_BFs8s { unsigned short v1:8; signed int v2:8; signed int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8i_BFu8c { unsigned short v1:8; signed int v2:8; signed int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8i_BFu8i { unsigned short v1:8; signed int v2:8; signed int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8i_BFu8ll { unsigned short v1:8; signed int v2:8; signed int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8i_BFu8s { unsigned short v1:8; signed int v2:8; signed int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8ll { unsigned short v1:8; signed int v2:8; signed long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8ll_BFs8c { unsigned short v1:8; signed int v2:8; signed long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8ll_BFs8i { unsigned short v1:8; signed int v2:8; signed long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8ll_BFs8ll { unsigned short v1:8; signed int v2:8; signed long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8ll_BFs8s { unsigned short v1:8; signed int v2:8; signed long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8ll_BFu8c { unsigned short v1:8; signed int v2:8; signed long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8ll_BFu8i { unsigned short v1:8; signed int v2:8; signed long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8ll_BFu8ll { unsigned short v1:8; signed int v2:8; signed long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8ll_BFu8s { unsigned short v1:8; signed int v2:8; signed long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8s { unsigned short v1:8; signed int v2:8; signed short v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8s_BFs8c { unsigned short v1:8; signed int v2:8; signed short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8s_BFs8i { unsigned short v1:8; signed int v2:8; signed short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8s_BFs8ll { unsigned short v1:8; signed int v2:8; signed short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8s_BFs8s { unsigned short v1:8; signed int v2:8; signed short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8s_BFu8c { unsigned short v1:8; signed int v2:8; signed short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8s_BFu8i { unsigned short v1:8; signed int v2:8; signed short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8s_BFu8ll { unsigned short v1:8; signed int v2:8; signed short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFs8s_BFu8s { unsigned short v1:8; signed int v2:8; signed short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8c { unsigned short v1:8; signed int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8c_BFs8c { unsigned short v1:8; signed int v2:8; unsigned char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8c_BFs8i { unsigned short v1:8; signed int v2:8; unsigned char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8c_BFs8ll { unsigned short v1:8; signed int v2:8; unsigned char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8c_BFs8s { unsigned short v1:8; signed int v2:8; unsigned char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8c_BFu8c { unsigned short v1:8; signed int v2:8; unsigned char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8c_BFu8i { unsigned short v1:8; signed int v2:8; unsigned char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8c_BFu8ll { unsigned short v1:8; signed int v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8c_BFu8s { unsigned short v1:8; signed int v2:8; unsigned char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8i { unsigned short v1:8; signed int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8i_BFs8c { unsigned short v1:8; signed int v2:8; unsigned int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8i_BFs8i { unsigned short v1:8; signed int v2:8; unsigned int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8i_BFs8ll { unsigned short v1:8; signed int v2:8; unsigned int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8i_BFs8s { unsigned short v1:8; signed int v2:8; unsigned int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8i_BFu8c { unsigned short v1:8; signed int v2:8; unsigned int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8i_BFu8i { unsigned short v1:8; signed int v2:8; unsigned int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8i_BFu8ll { unsigned short v1:8; signed int v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8i_BFu8s { unsigned short v1:8; signed int v2:8; unsigned int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8ll { unsigned short v1:8; signed int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8ll_BFs8c { unsigned short v1:8; signed int v2:8; unsigned long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8ll_BFs8i { unsigned short v1:8; signed int v2:8; unsigned long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8ll_BFs8ll { unsigned short v1:8; signed int v2:8; unsigned long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8ll_BFs8s { unsigned short v1:8; signed int v2:8; unsigned long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8ll_BFu8c { unsigned short v1:8; signed int v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8ll_BFu8i { unsigned short v1:8; signed int v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8ll_BFu8ll { unsigned short v1:8; signed int v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8ll_BFu8s { unsigned short v1:8; signed int v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8s { unsigned short v1:8; signed int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8s_BFs8c { unsigned short v1:8; signed int v2:8; unsigned short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8s_BFs8i { unsigned short v1:8; signed int v2:8; unsigned short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8s_BFs8ll { unsigned short v1:8; signed int v2:8; unsigned short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8s_BFs8s { unsigned short v1:8; signed int v2:8; unsigned short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8s_BFu8c { unsigned short v1:8; signed int v2:8; unsigned short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8s_BFu8i { unsigned short v1:8; signed int v2:8; unsigned short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8s_BFu8ll { unsigned short v1:8; signed int v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8i_BFu8s_BFu8s { unsigned short v1:8; signed int v2:8; unsigned short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll { unsigned short v1:8; signed long long v2:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8c { unsigned short v1:8; signed long long v2:8; signed char v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8c_BFs8c { unsigned short v1:8; signed long long v2:8; signed char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8c_BFs8i { unsigned short v1:8; signed long long v2:8; signed char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8c_BFs8ll { unsigned short v1:8; signed long long v2:8; signed char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8c_BFs8s { unsigned short v1:8; signed long long v2:8; signed char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8c_BFu8c { unsigned short v1:8; signed long long v2:8; signed char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8c_BFu8i { unsigned short v1:8; signed long long v2:8; signed char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8c_BFu8ll { unsigned short v1:8; signed long long v2:8; signed char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8c_BFu8s { unsigned short v1:8; signed long long v2:8; signed char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8i { unsigned short v1:8; signed long long v2:8; signed int v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8i_BFs8c { unsigned short v1:8; signed long long v2:8; signed int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8i_BFs8i { unsigned short v1:8; signed long long v2:8; signed int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8i_BFs8ll { unsigned short v1:8; signed long long v2:8; signed int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8i_BFs8s { unsigned short v1:8; signed long long v2:8; signed int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8i_BFu8c { unsigned short v1:8; signed long long v2:8; signed int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8i_BFu8i { unsigned short v1:8; signed long long v2:8; signed int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8i_BFu8ll { unsigned short v1:8; signed long long v2:8; signed int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8i_BFu8s { unsigned short v1:8; signed long long v2:8; signed int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8ll { unsigned short v1:8; signed long long v2:8; signed long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8ll_BFs8c { unsigned short v1:8; signed long long v2:8; signed long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8ll_BFs8i { unsigned short v1:8; signed long long v2:8; signed long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8ll_BFs8ll { unsigned short v1:8; signed long long v2:8; signed long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8ll_BFs8s { unsigned short v1:8; signed long long v2:8; signed long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8ll_BFu8c { unsigned short v1:8; signed long long v2:8; signed long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8ll_BFu8i { unsigned short v1:8; signed long long v2:8; signed long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8ll_BFu8ll { unsigned short v1:8; signed long long v2:8; signed long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8ll_BFu8s { unsigned short v1:8; signed long long v2:8; signed long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8s { unsigned short v1:8; signed long long v2:8; signed short v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8s_BFs8c { unsigned short v1:8; signed long long v2:8; signed short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8s_BFs8i { unsigned short v1:8; signed long long v2:8; signed short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8s_BFs8ll { unsigned short v1:8; signed long long v2:8; signed short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8s_BFs8s { unsigned short v1:8; signed long long v2:8; signed short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8s_BFu8c { unsigned short v1:8; signed long long v2:8; signed short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8s_BFu8i { unsigned short v1:8; signed long long v2:8; signed short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8s_BFu8ll { unsigned short v1:8; signed long long v2:8; signed short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFs8s_BFu8s { unsigned short v1:8; signed long long v2:8; signed short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8c { unsigned short v1:8; signed long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8c_BFs8c { unsigned short v1:8; signed long long v2:8; unsigned char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8c_BFs8i { unsigned short v1:8; signed long long v2:8; unsigned char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8c_BFs8ll { unsigned short v1:8; signed long long v2:8; unsigned char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8c_BFs8s { unsigned short v1:8; signed long long v2:8; unsigned char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8c_BFu8c { unsigned short v1:8; signed long long v2:8; unsigned char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8c_BFu8i { unsigned short v1:8; signed long long v2:8; unsigned char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8c_BFu8ll { unsigned short v1:8; signed long long v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8c_BFu8s { unsigned short v1:8; signed long long v2:8; unsigned char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8i { unsigned short v1:8; signed long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8i_BFs8c { unsigned short v1:8; signed long long v2:8; unsigned int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8i_BFs8i { unsigned short v1:8; signed long long v2:8; unsigned int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8i_BFs8ll { unsigned short v1:8; signed long long v2:8; unsigned int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8i_BFs8s { unsigned short v1:8; signed long long v2:8; unsigned int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8i_BFu8c { unsigned short v1:8; signed long long v2:8; unsigned int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8i_BFu8i { unsigned short v1:8; signed long long v2:8; unsigned int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8i_BFu8ll { unsigned short v1:8; signed long long v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8i_BFu8s { unsigned short v1:8; signed long long v2:8; unsigned int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8ll { unsigned short v1:8; signed long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8ll_BFs8c { unsigned short v1:8; signed long long v2:8; unsigned long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8ll_BFs8i { unsigned short v1:8; signed long long v2:8; unsigned long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8ll_BFs8ll { unsigned short v1:8; signed long long v2:8; unsigned long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8ll_BFs8s { unsigned short v1:8; signed long long v2:8; unsigned long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8ll_BFu8c { unsigned short v1:8; signed long long v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8ll_BFu8i { unsigned short v1:8; signed long long v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8ll_BFu8ll { unsigned short v1:8; signed long long v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8ll_BFu8s { unsigned short v1:8; signed long long v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8s { unsigned short v1:8; signed long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8s_BFs8c { unsigned short v1:8; signed long long v2:8; unsigned short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8s_BFs8i { unsigned short v1:8; signed long long v2:8; unsigned short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8s_BFs8ll { unsigned short v1:8; signed long long v2:8; unsigned short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8s_BFs8s { unsigned short v1:8; signed long long v2:8; unsigned short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8s_BFu8c { unsigned short v1:8; signed long long v2:8; unsigned short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8s_BFu8i { unsigned short v1:8; signed long long v2:8; unsigned short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8s_BFu8ll { unsigned short v1:8; signed long long v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8ll_BFu8s_BFu8s { unsigned short v1:8; signed long long v2:8; unsigned short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s { unsigned short v1:8; signed short v2:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8c { unsigned short v1:8; signed short v2:8; signed char v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8c_BFs8c { unsigned short v1:8; signed short v2:8; signed char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8c_BFs8i { unsigned short v1:8; signed short v2:8; signed char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8c_BFs8ll { unsigned short v1:8; signed short v2:8; signed char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8c_BFs8s { unsigned short v1:8; signed short v2:8; signed char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8c_BFu8c { unsigned short v1:8; signed short v2:8; signed char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8c_BFu8i { unsigned short v1:8; signed short v2:8; signed char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8c_BFu8ll { unsigned short v1:8; signed short v2:8; signed char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8c_BFu8s { unsigned short v1:8; signed short v2:8; signed char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8i { unsigned short v1:8; signed short v2:8; signed int v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8i_BFs8c { unsigned short v1:8; signed short v2:8; signed int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8i_BFs8i { unsigned short v1:8; signed short v2:8; signed int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8i_BFs8ll { unsigned short v1:8; signed short v2:8; signed int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8i_BFs8s { unsigned short v1:8; signed short v2:8; signed int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8i_BFu8c { unsigned short v1:8; signed short v2:8; signed int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8i_BFu8i { unsigned short v1:8; signed short v2:8; signed int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8i_BFu8ll { unsigned short v1:8; signed short v2:8; signed int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8i_BFu8s { unsigned short v1:8; signed short v2:8; signed int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8ll { unsigned short v1:8; signed short v2:8; signed long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8ll_BFs8c { unsigned short v1:8; signed short v2:8; signed long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8ll_BFs8i { unsigned short v1:8; signed short v2:8; signed long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8ll_BFs8ll { unsigned short v1:8; signed short v2:8; signed long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8ll_BFs8s { unsigned short v1:8; signed short v2:8; signed long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8ll_BFu8c { unsigned short v1:8; signed short v2:8; signed long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8ll_BFu8i { unsigned short v1:8; signed short v2:8; signed long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8ll_BFu8ll { unsigned short v1:8; signed short v2:8; signed long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8ll_BFu8s { unsigned short v1:8; signed short v2:8; signed long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8s { unsigned short v1:8; signed short v2:8; signed short v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8s_BFs8c { unsigned short v1:8; signed short v2:8; signed short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8s_BFs8i { unsigned short v1:8; signed short v2:8; signed short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8s_BFs8ll { unsigned short v1:8; signed short v2:8; signed short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8s_BFs8s { unsigned short v1:8; signed short v2:8; signed short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8s_BFu8c { unsigned short v1:8; signed short v2:8; signed short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8s_BFu8i { unsigned short v1:8; signed short v2:8; signed short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8s_BFu8ll { unsigned short v1:8; signed short v2:8; signed short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFs8s_BFu8s { unsigned short v1:8; signed short v2:8; signed short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8c { unsigned short v1:8; signed short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8c_BFs8c { unsigned short v1:8; signed short v2:8; unsigned char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8c_BFs8i { unsigned short v1:8; signed short v2:8; unsigned char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8c_BFs8ll { unsigned short v1:8; signed short v2:8; unsigned char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8c_BFs8s { unsigned short v1:8; signed short v2:8; unsigned char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8c_BFu8c { unsigned short v1:8; signed short v2:8; unsigned char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8c_BFu8i { unsigned short v1:8; signed short v2:8; unsigned char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8c_BFu8ll { unsigned short v1:8; signed short v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8c_BFu8s { unsigned short v1:8; signed short v2:8; unsigned char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8i { unsigned short v1:8; signed short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8i_BFs8c { unsigned short v1:8; signed short v2:8; unsigned int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8i_BFs8i { unsigned short v1:8; signed short v2:8; unsigned int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8i_BFs8ll { unsigned short v1:8; signed short v2:8; unsigned int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8i_BFs8s { unsigned short v1:8; signed short v2:8; unsigned int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8i_BFu8c { unsigned short v1:8; signed short v2:8; unsigned int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8i_BFu8i { unsigned short v1:8; signed short v2:8; unsigned int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8i_BFu8ll { unsigned short v1:8; signed short v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8i_BFu8s { unsigned short v1:8; signed short v2:8; unsigned int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8ll { unsigned short v1:8; signed short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8ll_BFs8c { unsigned short v1:8; signed short v2:8; unsigned long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8ll_BFs8i { unsigned short v1:8; signed short v2:8; unsigned long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8ll_BFs8ll { unsigned short v1:8; signed short v2:8; unsigned long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8ll_BFs8s { unsigned short v1:8; signed short v2:8; unsigned long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8ll_BFu8c { unsigned short v1:8; signed short v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8ll_BFu8i { unsigned short v1:8; signed short v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8ll_BFu8ll { unsigned short v1:8; signed short v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8ll_BFu8s { unsigned short v1:8; signed short v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8s { unsigned short v1:8; signed short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8s_BFs8c { unsigned short v1:8; signed short v2:8; unsigned short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8s_BFs8i { unsigned short v1:8; signed short v2:8; unsigned short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8s_BFs8ll { unsigned short v1:8; signed short v2:8; unsigned short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8s_BFs8s { unsigned short v1:8; signed short v2:8; unsigned short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8s_BFu8c { unsigned short v1:8; signed short v2:8; unsigned short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8s_BFu8i { unsigned short v1:8; signed short v2:8; unsigned short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8s_BFu8ll { unsigned short v1:8; signed short v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFs8s_BFu8s_BFu8s { unsigned short v1:8; signed short v2:8; unsigned short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu15i { unsigned short v1:8; unsigned int v2:15; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu15i { unsigned short v1:8; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu15ll { unsigned short v1:8; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu15s { unsigned short v1:8; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu16i { unsigned short v1:8; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu16ll { unsigned short v1:8; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu16s { unsigned short v1:8; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu17i { unsigned short v1:8; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu17ll { unsigned short v1:8; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu1c { unsigned short v1:8; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu1i { unsigned short v1:8; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu1ll { unsigned short v1:8; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu1s { unsigned short v1:8; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu31i { unsigned short v1:8; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu31ll { unsigned short v1:8; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu32i { unsigned short v1:8; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu32ll { unsigned short v1:8; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu33 { unsigned short v1:8; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu7c { unsigned short v1:8; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu7i { unsigned short v1:8; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu7ll { unsigned short v1:8; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu7s { unsigned short v1:8; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu8c { unsigned short v1:8; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu8i { unsigned short v1:8; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu8ll { unsigned short v1:8; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu8s { unsigned short v1:8; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu9i { unsigned short v1:8; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu9ll { unsigned short v1:8; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu15i_BFu9s { unsigned short v1:8; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu15i_C { unsigned short v1:8; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aBFu8s_BFu15i_D { unsigned short v1:8; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aBFu8s_BFu15i_F { unsigned short v1:8; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aBFu8s_BFu15i_I { unsigned short v1:8; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aBFu8s_BFu15i_Ip { unsigned short v1:8; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu15i_L { unsigned short v1:8; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu15i_S { unsigned short v1:8; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aBFu8s_BFu15i_Uc { unsigned short v1:8; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu15i_Ui { unsigned short v1:8; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu15i_Ul { unsigned short v1:8; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu15i_Us { unsigned short v1:8; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu15i_Vp { unsigned short v1:8; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll { unsigned short v1:8; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu15i { unsigned short v1:8; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu15ll { unsigned short v1:8; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu15s { unsigned short v1:8; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu16i { unsigned short v1:8; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu16ll { unsigned short v1:8; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu16s { unsigned short v1:8; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu17i { unsigned short v1:8; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu17ll { unsigned short v1:8; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu1c { unsigned short v1:8; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu1i { unsigned short v1:8; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu1ll { unsigned short v1:8; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu1s { unsigned short v1:8; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu31i { unsigned short v1:8; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu31ll { unsigned short v1:8; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu32i { unsigned short v1:8; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu32ll { unsigned short v1:8; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu33 { unsigned short v1:8; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu7c { unsigned short v1:8; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu7i { unsigned short v1:8; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu7ll { unsigned short v1:8; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu7s { unsigned short v1:8; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu8c { unsigned short v1:8; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu8i { unsigned short v1:8; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu8ll { unsigned short v1:8; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu8s { unsigned short v1:8; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu9i { unsigned short v1:8; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu9ll { unsigned short v1:8; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu15ll_BFu9s { unsigned short v1:8; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu15ll_C { unsigned short v1:8; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll_D { unsigned short v1:8; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll_F { unsigned short v1:8; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll_I { unsigned short v1:8; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll_Ip { unsigned short v1:8; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll_L { unsigned short v1:8; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll_S { unsigned short v1:8; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll_Uc { unsigned short v1:8; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll_Ui { unsigned short v1:8; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll_Ul { unsigned short v1:8; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll_Us { unsigned short v1:8; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu15ll_Vp { unsigned short v1:8; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu15s { unsigned short v1:8; unsigned short v2:15; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu15i { unsigned short v1:8; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu15ll { unsigned short v1:8; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu15s { unsigned short v1:8; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu16i { unsigned short v1:8; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu16ll { unsigned short v1:8; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu16s { unsigned short v1:8; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu17i { unsigned short v1:8; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu17ll { unsigned short v1:8; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu1c { unsigned short v1:8; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu1i { unsigned short v1:8; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu1ll { unsigned short v1:8; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu1s { unsigned short v1:8; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu31i { unsigned short v1:8; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu31ll { unsigned short v1:8; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu32i { unsigned short v1:8; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu32ll { unsigned short v1:8; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu33 { unsigned short v1:8; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu7c { unsigned short v1:8; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu7i { unsigned short v1:8; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu7ll { unsigned short v1:8; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu7s { unsigned short v1:8; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu8c { unsigned short v1:8; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu8i { unsigned short v1:8; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu8ll { unsigned short v1:8; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu8s { unsigned short v1:8; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu9i { unsigned short v1:8; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu9ll { unsigned short v1:8; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu15s_BFu9s { unsigned short v1:8; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu15s_C { unsigned short v1:8; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aBFu8s_BFu15s_D { unsigned short v1:8; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aBFu8s_BFu15s_F { unsigned short v1:8; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aBFu8s_BFu15s_I { unsigned short v1:8; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aBFu8s_BFu15s_Ip { unsigned short v1:8; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu15s_L { unsigned short v1:8; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu15s_S { unsigned short v1:8; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aBFu8s_BFu15s_Uc { unsigned short v1:8; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu15s_Ui { unsigned short v1:8; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu15s_Ul { unsigned short v1:8; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu15s_Us { unsigned short v1:8; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu15s_Vp { unsigned short v1:8; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu16i { unsigned short v1:8; unsigned int v2:16; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu15i { unsigned short v1:8; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu15ll { unsigned short v1:8; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu15s { unsigned short v1:8; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu16i { unsigned short v1:8; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu16ll { unsigned short v1:8; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu16s { unsigned short v1:8; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu17i { unsigned short v1:8; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu17ll { unsigned short v1:8; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu1c { unsigned short v1:8; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu1i { unsigned short v1:8; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu1ll { unsigned short v1:8; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu1s { unsigned short v1:8; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu31i { unsigned short v1:8; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu31ll { unsigned short v1:8; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu32i { unsigned short v1:8; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu32ll { unsigned short v1:8; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu33 { unsigned short v1:8; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu7c { unsigned short v1:8; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu7i { unsigned short v1:8; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu7ll { unsigned short v1:8; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu7s { unsigned short v1:8; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu8c { unsigned short v1:8; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu8i { unsigned short v1:8; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu8ll { unsigned short v1:8; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu8s { unsigned short v1:8; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu9i { unsigned short v1:8; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu9ll { unsigned short v1:8; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu16i_BFu9s { unsigned short v1:8; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu16i_C { unsigned short v1:8; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aBFu8s_BFu16i_D { unsigned short v1:8; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aBFu8s_BFu16i_F { unsigned short v1:8; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aBFu8s_BFu16i_I { unsigned short v1:8; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aBFu8s_BFu16i_Ip { unsigned short v1:8; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu16i_L { unsigned short v1:8; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu16i_S { unsigned short v1:8; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aBFu8s_BFu16i_Uc { unsigned short v1:8; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu16i_Ui { unsigned short v1:8; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu16i_Ul { unsigned short v1:8; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu16i_Us { unsigned short v1:8; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu16i_Vp { unsigned short v1:8; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll { unsigned short v1:8; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu15i { unsigned short v1:8; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu15ll { unsigned short v1:8; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu15s { unsigned short v1:8; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu16i { unsigned short v1:8; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu16ll { unsigned short v1:8; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu16s { unsigned short v1:8; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu17i { unsigned short v1:8; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu17ll { unsigned short v1:8; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu1c { unsigned short v1:8; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu1i { unsigned short v1:8; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu1ll { unsigned short v1:8; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu1s { unsigned short v1:8; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu31i { unsigned short v1:8; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu31ll { unsigned short v1:8; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu32i { unsigned short v1:8; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu32ll { unsigned short v1:8; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu33 { unsigned short v1:8; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu7c { unsigned short v1:8; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu7i { unsigned short v1:8; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu7ll { unsigned short v1:8; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu7s { unsigned short v1:8; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu8c { unsigned short v1:8; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu8i { unsigned short v1:8; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu8ll { unsigned short v1:8; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu8s { unsigned short v1:8; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu9i { unsigned short v1:8; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu9ll { unsigned short v1:8; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu16ll_BFu9s { unsigned short v1:8; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu16ll_C { unsigned short v1:8; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll_D { unsigned short v1:8; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll_F { unsigned short v1:8; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll_I { unsigned short v1:8; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll_Ip { unsigned short v1:8; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll_L { unsigned short v1:8; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll_S { unsigned short v1:8; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll_Uc { unsigned short v1:8; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll_Ui { unsigned short v1:8; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll_Ul { unsigned short v1:8; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll_Us { unsigned short v1:8; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu16ll_Vp { unsigned short v1:8; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu16s { unsigned short v1:8; unsigned short v2:16; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu15i { unsigned short v1:8; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu15ll { unsigned short v1:8; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu15s { unsigned short v1:8; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu16i { unsigned short v1:8; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu16ll { unsigned short v1:8; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu16s { unsigned short v1:8; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu17i { unsigned short v1:8; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu17ll { unsigned short v1:8; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu1c { unsigned short v1:8; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu1i { unsigned short v1:8; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu1ll { unsigned short v1:8; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu1s { unsigned short v1:8; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu31i { unsigned short v1:8; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu31ll { unsigned short v1:8; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu32i { unsigned short v1:8; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu32ll { unsigned short v1:8; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu33 { unsigned short v1:8; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu7c { unsigned short v1:8; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu7i { unsigned short v1:8; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu7ll { unsigned short v1:8; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu7s { unsigned short v1:8; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu8c { unsigned short v1:8; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu8i { unsigned short v1:8; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu8ll { unsigned short v1:8; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu8s { unsigned short v1:8; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu9i { unsigned short v1:8; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu9ll { unsigned short v1:8; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu16s_BFu9s { unsigned short v1:8; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu16s_C { unsigned short v1:8; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aBFu8s_BFu16s_D { unsigned short v1:8; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aBFu8s_BFu16s_F { unsigned short v1:8; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aBFu8s_BFu16s_I { unsigned short v1:8; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aBFu8s_BFu16s_Ip { unsigned short v1:8; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu16s_L { unsigned short v1:8; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu16s_S { unsigned short v1:8; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aBFu8s_BFu16s_Uc { unsigned short v1:8; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu16s_Ui { unsigned short v1:8; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu16s_Ul { unsigned short v1:8; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu16s_Us { unsigned short v1:8; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu16s_Vp { unsigned short v1:8; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu17i { unsigned short v1:8; unsigned int v2:17; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu15i { unsigned short v1:8; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu15ll { unsigned short v1:8; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu15s { unsigned short v1:8; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu16i { unsigned short v1:8; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu16ll { unsigned short v1:8; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu16s { unsigned short v1:8; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu17i { unsigned short v1:8; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu17ll { unsigned short v1:8; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu1c { unsigned short v1:8; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu1i { unsigned short v1:8; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu1ll { unsigned short v1:8; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu1s { unsigned short v1:8; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu31i { unsigned short v1:8; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu31ll { unsigned short v1:8; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu32i { unsigned short v1:8; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu32ll { unsigned short v1:8; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu33 { unsigned short v1:8; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu7c { unsigned short v1:8; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu7i { unsigned short v1:8; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu7ll { unsigned short v1:8; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu7s { unsigned short v1:8; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu8c { unsigned short v1:8; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu8i { unsigned short v1:8; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu8ll { unsigned short v1:8; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu8s { unsigned short v1:8; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu9i { unsigned short v1:8; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu9ll { unsigned short v1:8; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu17i_BFu9s { unsigned short v1:8; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu17i_C { unsigned short v1:8; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aBFu8s_BFu17i_D { unsigned short v1:8; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aBFu8s_BFu17i_F { unsigned short v1:8; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aBFu8s_BFu17i_I { unsigned short v1:8; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aBFu8s_BFu17i_Ip { unsigned short v1:8; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu17i_L { unsigned short v1:8; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu17i_S { unsigned short v1:8; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aBFu8s_BFu17i_Uc { unsigned short v1:8; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu17i_Ui { unsigned short v1:8; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu17i_Ul { unsigned short v1:8; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu17i_Us { unsigned short v1:8; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu17i_Vp { unsigned short v1:8; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll { unsigned short v1:8; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu15i { unsigned short v1:8; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu15ll { unsigned short v1:8; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu15s { unsigned short v1:8; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu16i { unsigned short v1:8; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu16ll { unsigned short v1:8; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu16s { unsigned short v1:8; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu17i { unsigned short v1:8; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu17ll { unsigned short v1:8; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu1c { unsigned short v1:8; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu1i { unsigned short v1:8; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu1ll { unsigned short v1:8; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu1s { unsigned short v1:8; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu31i { unsigned short v1:8; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu31ll { unsigned short v1:8; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu32i { unsigned short v1:8; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu32ll { unsigned short v1:8; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu33 { unsigned short v1:8; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu7c { unsigned short v1:8; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu7i { unsigned short v1:8; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu7ll { unsigned short v1:8; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu7s { unsigned short v1:8; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu8c { unsigned short v1:8; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu8i { unsigned short v1:8; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu8ll { unsigned short v1:8; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu8s { unsigned short v1:8; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu9i { unsigned short v1:8; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu9ll { unsigned short v1:8; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu17ll_BFu9s { unsigned short v1:8; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu17ll_C { unsigned short v1:8; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll_D { unsigned short v1:8; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll_F { unsigned short v1:8; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll_I { unsigned short v1:8; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll_Ip { unsigned short v1:8; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll_L { unsigned short v1:8; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll_S { unsigned short v1:8; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll_Uc { unsigned short v1:8; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll_Ui { unsigned short v1:8; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll_Ul { unsigned short v1:8; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll_Us { unsigned short v1:8; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu17ll_Vp { unsigned short v1:8; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu1c { unsigned short v1:8; unsigned char v2:1; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu15i { unsigned short v1:8; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu15ll { unsigned short v1:8; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu15s { unsigned short v1:8; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu16i { unsigned short v1:8; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu16ll { unsigned short v1:8; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu16s { unsigned short v1:8; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu17i { unsigned short v1:8; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu17ll { unsigned short v1:8; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu1c { unsigned short v1:8; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu1i { unsigned short v1:8; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu1ll { unsigned short v1:8; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu1s { unsigned short v1:8; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu31i { unsigned short v1:8; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu31ll { unsigned short v1:8; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu32i { unsigned short v1:8; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu32ll { unsigned short v1:8; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu33 { unsigned short v1:8; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu7c { unsigned short v1:8; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu7i { unsigned short v1:8; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu7ll { unsigned short v1:8; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu7s { unsigned short v1:8; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu8c { unsigned short v1:8; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu8i { unsigned short v1:8; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu8ll { unsigned short v1:8; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu8s { unsigned short v1:8; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu9i { unsigned short v1:8; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu9ll { unsigned short v1:8; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu1c_BFu9s { unsigned short v1:8; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu1c_C { unsigned short v1:8; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aBFu8s_BFu1c_D { unsigned short v1:8; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aBFu8s_BFu1c_F { unsigned short v1:8; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aBFu8s_BFu1c_I { unsigned short v1:8; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aBFu8s_BFu1c_Ip { unsigned short v1:8; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu1c_L { unsigned short v1:8; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu1c_S { unsigned short v1:8; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aBFu8s_BFu1c_Uc { unsigned short v1:8; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu1c_Ui { unsigned short v1:8; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu1c_Ul { unsigned short v1:8; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu1c_Us { unsigned short v1:8; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu1c_Vp { unsigned short v1:8; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu1i { unsigned short v1:8; unsigned int v2:1; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu15i { unsigned short v1:8; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu15ll { unsigned short v1:8; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu15s { unsigned short v1:8; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu16i { unsigned short v1:8; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu16ll { unsigned short v1:8; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu16s { unsigned short v1:8; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu17i { unsigned short v1:8; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu17ll { unsigned short v1:8; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu1c { unsigned short v1:8; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu1i { unsigned short v1:8; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu1ll { unsigned short v1:8; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu1s { unsigned short v1:8; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu31i { unsigned short v1:8; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu31ll { unsigned short v1:8; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu32i { unsigned short v1:8; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu32ll { unsigned short v1:8; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu33 { unsigned short v1:8; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu7c { unsigned short v1:8; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu7i { unsigned short v1:8; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu7ll { unsigned short v1:8; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu7s { unsigned short v1:8; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu8c { unsigned short v1:8; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu8i { unsigned short v1:8; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu8ll { unsigned short v1:8; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu8s { unsigned short v1:8; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu9i { unsigned short v1:8; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu9ll { unsigned short v1:8; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu1i_BFu9s { unsigned short v1:8; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu1i_C { unsigned short v1:8; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aBFu8s_BFu1i_D { unsigned short v1:8; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aBFu8s_BFu1i_F { unsigned short v1:8; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aBFu8s_BFu1i_I { unsigned short v1:8; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aBFu8s_BFu1i_Ip { unsigned short v1:8; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu1i_L { unsigned short v1:8; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu1i_S { unsigned short v1:8; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aBFu8s_BFu1i_Uc { unsigned short v1:8; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu1i_Ui { unsigned short v1:8; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu1i_Ul { unsigned short v1:8; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu1i_Us { unsigned short v1:8; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu1i_Vp { unsigned short v1:8; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll { unsigned short v1:8; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu15i { unsigned short v1:8; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu15ll { unsigned short v1:8; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu15s { unsigned short v1:8; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu16i { unsigned short v1:8; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu16ll { unsigned short v1:8; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu16s { unsigned short v1:8; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu17i { unsigned short v1:8; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu17ll { unsigned short v1:8; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu1c { unsigned short v1:8; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu1i { unsigned short v1:8; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu1ll { unsigned short v1:8; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu1s { unsigned short v1:8; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu31i { unsigned short v1:8; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu31ll { unsigned short v1:8; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu32i { unsigned short v1:8; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu32ll { unsigned short v1:8; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu33 { unsigned short v1:8; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu7c { unsigned short v1:8; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu7i { unsigned short v1:8; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu7ll { unsigned short v1:8; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu7s { unsigned short v1:8; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu8c { unsigned short v1:8; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu8i { unsigned short v1:8; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu8ll { unsigned short v1:8; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu8s { unsigned short v1:8; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu9i { unsigned short v1:8; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu9ll { unsigned short v1:8; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu1ll_BFu9s { unsigned short v1:8; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu1ll_C { unsigned short v1:8; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll_D { unsigned short v1:8; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll_F { unsigned short v1:8; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll_I { unsigned short v1:8; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll_Ip { unsigned short v1:8; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll_L { unsigned short v1:8; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll_S { unsigned short v1:8; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll_Uc { unsigned short v1:8; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll_Ui { unsigned short v1:8; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll_Ul { unsigned short v1:8; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll_Us { unsigned short v1:8; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu1ll_Vp { unsigned short v1:8; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu1s { unsigned short v1:8; unsigned short v2:1; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu15i { unsigned short v1:8; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu15ll { unsigned short v1:8; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu15s { unsigned short v1:8; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu16i { unsigned short v1:8; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu16ll { unsigned short v1:8; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu16s { unsigned short v1:8; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu17i { unsigned short v1:8; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu17ll { unsigned short v1:8; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu1c { unsigned short v1:8; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu1i { unsigned short v1:8; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu1ll { unsigned short v1:8; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu1s { unsigned short v1:8; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu31i { unsigned short v1:8; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu31ll { unsigned short v1:8; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu32i { unsigned short v1:8; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu32ll { unsigned short v1:8; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu33 { unsigned short v1:8; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu7c { unsigned short v1:8; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu7i { unsigned short v1:8; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu7ll { unsigned short v1:8; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu7s { unsigned short v1:8; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu8c { unsigned short v1:8; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu8i { unsigned short v1:8; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu8ll { unsigned short v1:8; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu8s { unsigned short v1:8; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu9i { unsigned short v1:8; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu9ll { unsigned short v1:8; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu1s_BFu9s { unsigned short v1:8; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu1s_C { unsigned short v1:8; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aBFu8s_BFu1s_D { unsigned short v1:8; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aBFu8s_BFu1s_F { unsigned short v1:8; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aBFu8s_BFu1s_I { unsigned short v1:8; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aBFu8s_BFu1s_Ip { unsigned short v1:8; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu1s_L { unsigned short v1:8; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu1s_S { unsigned short v1:8; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aBFu8s_BFu1s_Uc { unsigned short v1:8; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu1s_Ui { unsigned short v1:8; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu1s_Ul { unsigned short v1:8; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu1s_Us { unsigned short v1:8; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu1s_Vp { unsigned short v1:8; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu31i { unsigned short v1:8; unsigned int v2:31; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu15i { unsigned short v1:8; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu15ll { unsigned short v1:8; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu15s { unsigned short v1:8; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu16i { unsigned short v1:8; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu16ll { unsigned short v1:8; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu16s { unsigned short v1:8; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu17i { unsigned short v1:8; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu17ll { unsigned short v1:8; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu1c { unsigned short v1:8; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu1i { unsigned short v1:8; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu1ll { unsigned short v1:8; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu1s { unsigned short v1:8; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu31i { unsigned short v1:8; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu31ll { unsigned short v1:8; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu32i { unsigned short v1:8; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu32ll { unsigned short v1:8; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu33 { unsigned short v1:8; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu7c { unsigned short v1:8; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu7i { unsigned short v1:8; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu7ll { unsigned short v1:8; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu7s { unsigned short v1:8; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu8c { unsigned short v1:8; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu8i { unsigned short v1:8; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu8ll { unsigned short v1:8; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu8s { unsigned short v1:8; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu9i { unsigned short v1:8; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu9ll { unsigned short v1:8; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu31i_BFu9s { unsigned short v1:8; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu31i_C { unsigned short v1:8; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aBFu8s_BFu31i_D { unsigned short v1:8; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aBFu8s_BFu31i_F { unsigned short v1:8; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aBFu8s_BFu31i_I { unsigned short v1:8; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aBFu8s_BFu31i_Ip { unsigned short v1:8; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu31i_L { unsigned short v1:8; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu31i_S { unsigned short v1:8; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aBFu8s_BFu31i_Uc { unsigned short v1:8; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu31i_Ui { unsigned short v1:8; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu31i_Ul { unsigned short v1:8; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu31i_Us { unsigned short v1:8; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu31i_Vp { unsigned short v1:8; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll { unsigned short v1:8; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu15i { unsigned short v1:8; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu15ll { unsigned short v1:8; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu15s { unsigned short v1:8; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu16i { unsigned short v1:8; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu16ll { unsigned short v1:8; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu16s { unsigned short v1:8; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu17i { unsigned short v1:8; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu17ll { unsigned short v1:8; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu1c { unsigned short v1:8; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu1i { unsigned short v1:8; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu1ll { unsigned short v1:8; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu1s { unsigned short v1:8; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu31i { unsigned short v1:8; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu31ll { unsigned short v1:8; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu32i { unsigned short v1:8; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu32ll { unsigned short v1:8; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu33 { unsigned short v1:8; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu7c { unsigned short v1:8; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu7i { unsigned short v1:8; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu7ll { unsigned short v1:8; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu7s { unsigned short v1:8; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu8c { unsigned short v1:8; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu8i { unsigned short v1:8; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu8ll { unsigned short v1:8; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu8s { unsigned short v1:8; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu9i { unsigned short v1:8; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu9ll { unsigned short v1:8; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu31ll_BFu9s { unsigned short v1:8; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu31ll_C { unsigned short v1:8; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll_D { unsigned short v1:8; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll_F { unsigned short v1:8; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll_I { unsigned short v1:8; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll_Ip { unsigned short v1:8; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll_L { unsigned short v1:8; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll_S { unsigned short v1:8; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll_Uc { unsigned short v1:8; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll_Ui { unsigned short v1:8; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll_Ul { unsigned short v1:8; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll_Us { unsigned short v1:8; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu31ll_Vp { unsigned short v1:8; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu32i { unsigned short v1:8; unsigned int v2:32; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu15i { unsigned short v1:8; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu15ll { unsigned short v1:8; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu15s { unsigned short v1:8; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu16i { unsigned short v1:8; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu16ll { unsigned short v1:8; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu16s { unsigned short v1:8; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu17i { unsigned short v1:8; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu17ll { unsigned short v1:8; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu1c { unsigned short v1:8; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu1i { unsigned short v1:8; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu1ll { unsigned short v1:8; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu1s { unsigned short v1:8; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu31i { unsigned short v1:8; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu31ll { unsigned short v1:8; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu32i { unsigned short v1:8; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu32ll { unsigned short v1:8; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu33 { unsigned short v1:8; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu7c { unsigned short v1:8; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu7i { unsigned short v1:8; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu7ll { unsigned short v1:8; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu7s { unsigned short v1:8; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu8c { unsigned short v1:8; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu8i { unsigned short v1:8; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu8ll { unsigned short v1:8; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu8s { unsigned short v1:8; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu9i { unsigned short v1:8; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu9ll { unsigned short v1:8; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu32i_BFu9s { unsigned short v1:8; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu32i_C { unsigned short v1:8; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aBFu8s_BFu32i_D { unsigned short v1:8; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aBFu8s_BFu32i_F { unsigned short v1:8; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aBFu8s_BFu32i_I { unsigned short v1:8; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aBFu8s_BFu32i_Ip { unsigned short v1:8; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu32i_L { unsigned short v1:8; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu32i_S { unsigned short v1:8; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aBFu8s_BFu32i_Uc { unsigned short v1:8; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu32i_Ui { unsigned short v1:8; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu32i_Ul { unsigned short v1:8; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu32i_Us { unsigned short v1:8; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu32i_Vp { unsigned short v1:8; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll { unsigned short v1:8; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu15i { unsigned short v1:8; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu15ll { unsigned short v1:8; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu15s { unsigned short v1:8; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu16i { unsigned short v1:8; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu16ll { unsigned short v1:8; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu16s { unsigned short v1:8; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu17i { unsigned short v1:8; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu17ll { unsigned short v1:8; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu1c { unsigned short v1:8; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu1i { unsigned short v1:8; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu1ll { unsigned short v1:8; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu1s { unsigned short v1:8; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu31i { unsigned short v1:8; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu31ll { unsigned short v1:8; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu32i { unsigned short v1:8; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu32ll { unsigned short v1:8; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu33 { unsigned short v1:8; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu7c { unsigned short v1:8; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu7i { unsigned short v1:8; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu7ll { unsigned short v1:8; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu7s { unsigned short v1:8; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu8c { unsigned short v1:8; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu8i { unsigned short v1:8; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu8ll { unsigned short v1:8; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu8s { unsigned short v1:8; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu9i { unsigned short v1:8; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu9ll { unsigned short v1:8; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu32ll_BFu9s { unsigned short v1:8; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu32ll_C { unsigned short v1:8; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll_D { unsigned short v1:8; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll_F { unsigned short v1:8; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll_I { unsigned short v1:8; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll_Ip { unsigned short v1:8; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll_L { unsigned short v1:8; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll_S { unsigned short v1:8; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll_Uc { unsigned short v1:8; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll_Ui { unsigned short v1:8; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll_Ul { unsigned short v1:8; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll_Us { unsigned short v1:8; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu32ll_Vp { unsigned short v1:8; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu33 { unsigned short v1:8; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu15i { unsigned short v1:8; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu15ll { unsigned short v1:8; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu15s { unsigned short v1:8; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu16i { unsigned short v1:8; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu16ll { unsigned short v1:8; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu16s { unsigned short v1:8; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu17i { unsigned short v1:8; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu17ll { unsigned short v1:8; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu1c { unsigned short v1:8; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu1i { unsigned short v1:8; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu1ll { unsigned short v1:8; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu1s { unsigned short v1:8; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu31i { unsigned short v1:8; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu31ll { unsigned short v1:8; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu32i { unsigned short v1:8; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu32ll { unsigned short v1:8; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu33 { unsigned short v1:8; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu7c { unsigned short v1:8; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu7i { unsigned short v1:8; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu7ll { unsigned short v1:8; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu7s { unsigned short v1:8; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu8c { unsigned short v1:8; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu8i { unsigned short v1:8; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu8ll { unsigned short v1:8; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu8s { unsigned short v1:8; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu9i { unsigned short v1:8; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu9ll { unsigned short v1:8; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu33_BFu9s { unsigned short v1:8; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu33_C { unsigned short v1:8; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aBFu8s_BFu33_D { unsigned short v1:8; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aBFu8s_BFu33_F { unsigned short v1:8; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aBFu8s_BFu33_I { unsigned short v1:8; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aBFu8s_BFu33_Ip { unsigned short v1:8; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu33_L { unsigned short v1:8; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu33_S { unsigned short v1:8; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aBFu8s_BFu33_Uc { unsigned short v1:8; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu33_Ui { unsigned short v1:8; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu33_Ul { unsigned short v1:8; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu33_Us { unsigned short v1:8; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu33_Vp { unsigned short v1:8; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu7c { unsigned short v1:8; unsigned char v2:7; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu15i { unsigned short v1:8; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu15ll { unsigned short v1:8; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu15s { unsigned short v1:8; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu16i { unsigned short v1:8; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu16ll { unsigned short v1:8; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu16s { unsigned short v1:8; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu17i { unsigned short v1:8; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu17ll { unsigned short v1:8; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu1c { unsigned short v1:8; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu1i { unsigned short v1:8; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu1ll { unsigned short v1:8; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu1s { unsigned short v1:8; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu31i { unsigned short v1:8; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu31ll { unsigned short v1:8; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu32i { unsigned short v1:8; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu32ll { unsigned short v1:8; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu33 { unsigned short v1:8; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu7c { unsigned short v1:8; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu7i { unsigned short v1:8; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu7ll { unsigned short v1:8; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu7s { unsigned short v1:8; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu8c { unsigned short v1:8; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu8i { unsigned short v1:8; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu8ll { unsigned short v1:8; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu8s { unsigned short v1:8; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu9i { unsigned short v1:8; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu9ll { unsigned short v1:8; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu7c_BFu9s { unsigned short v1:8; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu7c_C { unsigned short v1:8; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aBFu8s_BFu7c_D { unsigned short v1:8; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aBFu8s_BFu7c_F { unsigned short v1:8; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aBFu8s_BFu7c_I { unsigned short v1:8; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aBFu8s_BFu7c_Ip { unsigned short v1:8; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu7c_L { unsigned short v1:8; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu7c_S { unsigned short v1:8; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aBFu8s_BFu7c_Uc { unsigned short v1:8; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu7c_Ui { unsigned short v1:8; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu7c_Ul { unsigned short v1:8; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu7c_Us { unsigned short v1:8; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu7c_Vp { unsigned short v1:8; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu7i { unsigned short v1:8; unsigned int v2:7; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu15i { unsigned short v1:8; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu15ll { unsigned short v1:8; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu15s { unsigned short v1:8; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu16i { unsigned short v1:8; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu16ll { unsigned short v1:8; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu16s { unsigned short v1:8; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu17i { unsigned short v1:8; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu17ll { unsigned short v1:8; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu1c { unsigned short v1:8; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu1i { unsigned short v1:8; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu1ll { unsigned short v1:8; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu1s { unsigned short v1:8; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu31i { unsigned short v1:8; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu31ll { unsigned short v1:8; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu32i { unsigned short v1:8; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu32ll { unsigned short v1:8; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu33 { unsigned short v1:8; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu7c { unsigned short v1:8; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu7i { unsigned short v1:8; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu7ll { unsigned short v1:8; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu7s { unsigned short v1:8; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu8c { unsigned short v1:8; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu8i { unsigned short v1:8; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu8ll { unsigned short v1:8; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu8s { unsigned short v1:8; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu9i { unsigned short v1:8; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu9ll { unsigned short v1:8; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu7i_BFu9s { unsigned short v1:8; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu7i_C { unsigned short v1:8; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aBFu8s_BFu7i_D { unsigned short v1:8; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aBFu8s_BFu7i_F { unsigned short v1:8; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aBFu8s_BFu7i_I { unsigned short v1:8; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aBFu8s_BFu7i_Ip { unsigned short v1:8; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu7i_L { unsigned short v1:8; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu7i_S { unsigned short v1:8; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aBFu8s_BFu7i_Uc { unsigned short v1:8; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu7i_Ui { unsigned short v1:8; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu7i_Ul { unsigned short v1:8; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu7i_Us { unsigned short v1:8; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu7i_Vp { unsigned short v1:8; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll { unsigned short v1:8; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu15i { unsigned short v1:8; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu15ll { unsigned short v1:8; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu15s { unsigned short v1:8; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu16i { unsigned short v1:8; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu16ll { unsigned short v1:8; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu16s { unsigned short v1:8; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu17i { unsigned short v1:8; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu17ll { unsigned short v1:8; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu1c { unsigned short v1:8; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu1i { unsigned short v1:8; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu1ll { unsigned short v1:8; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu1s { unsigned short v1:8; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu31i { unsigned short v1:8; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu31ll { unsigned short v1:8; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu32i { unsigned short v1:8; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu32ll { unsigned short v1:8; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu33 { unsigned short v1:8; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu7c { unsigned short v1:8; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu7i { unsigned short v1:8; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu7ll { unsigned short v1:8; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu7s { unsigned short v1:8; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu8c { unsigned short v1:8; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu8i { unsigned short v1:8; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu8ll { unsigned short v1:8; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu8s { unsigned short v1:8; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu9i { unsigned short v1:8; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu9ll { unsigned short v1:8; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu7ll_BFu9s { unsigned short v1:8; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu7ll_C { unsigned short v1:8; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll_D { unsigned short v1:8; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll_F { unsigned short v1:8; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll_I { unsigned short v1:8; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll_Ip { unsigned short v1:8; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll_L { unsigned short v1:8; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll_S { unsigned short v1:8; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll_Uc { unsigned short v1:8; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll_Ui { unsigned short v1:8; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll_Ul { unsigned short v1:8; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll_Us { unsigned short v1:8; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu7ll_Vp { unsigned short v1:8; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu7s { unsigned short v1:8; unsigned short v2:7; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu15i { unsigned short v1:8; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu15ll { unsigned short v1:8; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu15s { unsigned short v1:8; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu16i { unsigned short v1:8; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu16ll { unsigned short v1:8; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu16s { unsigned short v1:8; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu17i { unsigned short v1:8; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu17ll { unsigned short v1:8; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu1c { unsigned short v1:8; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu1i { unsigned short v1:8; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu1ll { unsigned short v1:8; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu1s { unsigned short v1:8; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu31i { unsigned short v1:8; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu31ll { unsigned short v1:8; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu32i { unsigned short v1:8; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu32ll { unsigned short v1:8; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu33 { unsigned short v1:8; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu7c { unsigned short v1:8; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu7i { unsigned short v1:8; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu7ll { unsigned short v1:8; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu7s { unsigned short v1:8; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu8c { unsigned short v1:8; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu8i { unsigned short v1:8; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu8ll { unsigned short v1:8; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu8s { unsigned short v1:8; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu9i { unsigned short v1:8; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu9ll { unsigned short v1:8; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu7s_BFu9s { unsigned short v1:8; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu7s_C { unsigned short v1:8; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aBFu8s_BFu7s_D { unsigned short v1:8; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aBFu8s_BFu7s_F { unsigned short v1:8; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aBFu8s_BFu7s_I { unsigned short v1:8; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aBFu8s_BFu7s_Ip { unsigned short v1:8; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu7s_L { unsigned short v1:8; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu7s_S { unsigned short v1:8; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aBFu8s_BFu7s_Uc { unsigned short v1:8; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu7s_Ui { unsigned short v1:8; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu7s_Ul { unsigned short v1:8; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu7s_Us { unsigned short v1:8; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu7s_Vp { unsigned short v1:8; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu8c { unsigned short v1:8; unsigned char v2:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8c { unsigned short v1:8; unsigned char v2:8; signed char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8c_BFs8c { unsigned short v1:8; unsigned char v2:8; signed char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8c_BFs8i { unsigned short v1:8; unsigned char v2:8; signed char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8c_BFs8ll { unsigned short v1:8; unsigned char v2:8; signed char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8c_BFs8s { unsigned short v1:8; unsigned char v2:8; signed char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8c_BFu8c { unsigned short v1:8; unsigned char v2:8; signed char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8c_BFu8i { unsigned short v1:8; unsigned char v2:8; signed char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8c_BFu8ll { unsigned short v1:8; unsigned char v2:8; signed char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8c_BFu8s { unsigned short v1:8; unsigned char v2:8; signed char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8i { unsigned short v1:8; unsigned char v2:8; signed int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8i_BFs8c { unsigned short v1:8; unsigned char v2:8; signed int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8i_BFs8i { unsigned short v1:8; unsigned char v2:8; signed int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8i_BFs8ll { unsigned short v1:8; unsigned char v2:8; signed int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8i_BFs8s { unsigned short v1:8; unsigned char v2:8; signed int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8i_BFu8c { unsigned short v1:8; unsigned char v2:8; signed int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8i_BFu8i { unsigned short v1:8; unsigned char v2:8; signed int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8i_BFu8ll { unsigned short v1:8; unsigned char v2:8; signed int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8i_BFu8s { unsigned short v1:8; unsigned char v2:8; signed int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8ll { unsigned short v1:8; unsigned char v2:8; signed long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8ll_BFs8c { unsigned short v1:8; unsigned char v2:8; signed long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8ll_BFs8i { unsigned short v1:8; unsigned char v2:8; signed long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8ll_BFs8ll { unsigned short v1:8; unsigned char v2:8; signed long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8ll_BFs8s { unsigned short v1:8; unsigned char v2:8; signed long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8ll_BFu8c { unsigned short v1:8; unsigned char v2:8; signed long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8ll_BFu8i { unsigned short v1:8; unsigned char v2:8; signed long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8ll_BFu8ll { unsigned short v1:8; unsigned char v2:8; signed long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8ll_BFu8s { unsigned short v1:8; unsigned char v2:8; signed long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8s { unsigned short v1:8; unsigned char v2:8; signed short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8s_BFs8c { unsigned short v1:8; unsigned char v2:8; signed short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8s_BFs8i { unsigned short v1:8; unsigned char v2:8; signed short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8s_BFs8ll { unsigned short v1:8; unsigned char v2:8; signed short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8s_BFs8s { unsigned short v1:8; unsigned char v2:8; signed short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8s_BFu8c { unsigned short v1:8; unsigned char v2:8; signed short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8s_BFu8i { unsigned short v1:8; unsigned char v2:8; signed short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8s_BFu8ll { unsigned short v1:8; unsigned char v2:8; signed short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFs8s_BFu8s { unsigned short v1:8; unsigned char v2:8; signed short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu15i { unsigned short v1:8; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu15ll { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu15s { unsigned short v1:8; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu16i { unsigned short v1:8; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu16ll { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu16s { unsigned short v1:8; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu17i { unsigned short v1:8; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu17ll { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu1c { unsigned short v1:8; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu1i { unsigned short v1:8; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu1ll { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu1s { unsigned short v1:8; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu31i { unsigned short v1:8; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu31ll { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu32i { unsigned short v1:8; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu32ll { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu33 { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu7c { unsigned short v1:8; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu7i { unsigned short v1:8; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu7ll { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu7s { unsigned short v1:8; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8c { unsigned short v1:8; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8c_BFs8c { unsigned short v1:8; unsigned char v2:8; unsigned char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8c_BFs8i { unsigned short v1:8; unsigned char v2:8; unsigned char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8c_BFs8ll { unsigned short v1:8; unsigned char v2:8; unsigned char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8c_BFs8s { unsigned short v1:8; unsigned char v2:8; unsigned char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8c_BFu8c { unsigned short v1:8; unsigned char v2:8; unsigned char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8c_BFu8i { unsigned short v1:8; unsigned char v2:8; unsigned char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8c_BFu8ll { unsigned short v1:8; unsigned char v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8c_BFu8s { unsigned short v1:8; unsigned char v2:8; unsigned char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8i { unsigned short v1:8; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8i_BFs8c { unsigned short v1:8; unsigned char v2:8; unsigned int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8i_BFs8i { unsigned short v1:8; unsigned char v2:8; unsigned int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8i_BFs8ll { unsigned short v1:8; unsigned char v2:8; unsigned int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8i_BFs8s { unsigned short v1:8; unsigned char v2:8; unsigned int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8i_BFu8c { unsigned short v1:8; unsigned char v2:8; unsigned int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8i_BFu8i { unsigned short v1:8; unsigned char v2:8; unsigned int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8i_BFu8ll { unsigned short v1:8; unsigned char v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8i_BFu8s { unsigned short v1:8; unsigned char v2:8; unsigned int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8ll { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8ll_BFs8c { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8ll_BFs8i { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8ll_BFs8ll { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8ll_BFs8s { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8ll_BFu8c { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8ll_BFu8i { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8ll_BFu8ll { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8ll_BFu8s { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8s { unsigned short v1:8; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8s_BFs8c { unsigned short v1:8; unsigned char v2:8; unsigned short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8s_BFs8i { unsigned short v1:8; unsigned char v2:8; unsigned short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8s_BFs8ll { unsigned short v1:8; unsigned char v2:8; unsigned short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8s_BFs8s { unsigned short v1:8; unsigned char v2:8; unsigned short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8s_BFu8c { unsigned short v1:8; unsigned char v2:8; unsigned short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8s_BFu8i { unsigned short v1:8; unsigned char v2:8; unsigned short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8s_BFu8ll { unsigned short v1:8; unsigned char v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu8s_BFu8s { unsigned short v1:8; unsigned char v2:8; unsigned short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu9i { unsigned short v1:8; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu9ll { unsigned short v1:8; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu8c_BFu9s { unsigned short v1:8; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu8c_C { unsigned short v1:8; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aBFu8s_BFu8c_D { unsigned short v1:8; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aBFu8s_BFu8c_F { unsigned short v1:8; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aBFu8s_BFu8c_I { unsigned short v1:8; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aBFu8s_BFu8c_Ip { unsigned short v1:8; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu8c_L { unsigned short v1:8; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu8c_S { unsigned short v1:8; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aBFu8s_BFu8c_Uc { unsigned short v1:8; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu8c_Ui { unsigned short v1:8; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu8c_Ul { unsigned short v1:8; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu8c_Us { unsigned short v1:8; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu8c_Vp { unsigned short v1:8; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu8i { unsigned short v1:8; unsigned int v2:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8c { unsigned short v1:8; unsigned int v2:8; signed char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8c_BFs8c { unsigned short v1:8; unsigned int v2:8; signed char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8c_BFs8i { unsigned short v1:8; unsigned int v2:8; signed char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8c_BFs8ll { unsigned short v1:8; unsigned int v2:8; signed char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8c_BFs8s { unsigned short v1:8; unsigned int v2:8; signed char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8c_BFu8c { unsigned short v1:8; unsigned int v2:8; signed char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8c_BFu8i { unsigned short v1:8; unsigned int v2:8; signed char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8c_BFu8ll { unsigned short v1:8; unsigned int v2:8; signed char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8c_BFu8s { unsigned short v1:8; unsigned int v2:8; signed char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8i { unsigned short v1:8; unsigned int v2:8; signed int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8i_BFs8c { unsigned short v1:8; unsigned int v2:8; signed int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8i_BFs8i { unsigned short v1:8; unsigned int v2:8; signed int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8i_BFs8ll { unsigned short v1:8; unsigned int v2:8; signed int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8i_BFs8s { unsigned short v1:8; unsigned int v2:8; signed int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8i_BFu8c { unsigned short v1:8; unsigned int v2:8; signed int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8i_BFu8i { unsigned short v1:8; unsigned int v2:8; signed int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8i_BFu8ll { unsigned short v1:8; unsigned int v2:8; signed int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8i_BFu8s { unsigned short v1:8; unsigned int v2:8; signed int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8ll { unsigned short v1:8; unsigned int v2:8; signed long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8ll_BFs8c { unsigned short v1:8; unsigned int v2:8; signed long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8ll_BFs8i { unsigned short v1:8; unsigned int v2:8; signed long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8ll_BFs8ll { unsigned short v1:8; unsigned int v2:8; signed long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8ll_BFs8s { unsigned short v1:8; unsigned int v2:8; signed long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8ll_BFu8c { unsigned short v1:8; unsigned int v2:8; signed long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8ll_BFu8i { unsigned short v1:8; unsigned int v2:8; signed long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8ll_BFu8ll { unsigned short v1:8; unsigned int v2:8; signed long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8ll_BFu8s { unsigned short v1:8; unsigned int v2:8; signed long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8s { unsigned short v1:8; unsigned int v2:8; signed short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8s_BFs8c { unsigned short v1:8; unsigned int v2:8; signed short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8s_BFs8i { unsigned short v1:8; unsigned int v2:8; signed short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8s_BFs8ll { unsigned short v1:8; unsigned int v2:8; signed short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8s_BFs8s { unsigned short v1:8; unsigned int v2:8; signed short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8s_BFu8c { unsigned short v1:8; unsigned int v2:8; signed short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8s_BFu8i { unsigned short v1:8; unsigned int v2:8; signed short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8s_BFu8ll { unsigned short v1:8; unsigned int v2:8; signed short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFs8s_BFu8s { unsigned short v1:8; unsigned int v2:8; signed short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu15i { unsigned short v1:8; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu15ll { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu15s { unsigned short v1:8; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu16i { unsigned short v1:8; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu16ll { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu16s { unsigned short v1:8; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu17i { unsigned short v1:8; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu17ll { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu1c { unsigned short v1:8; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu1i { unsigned short v1:8; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu1ll { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu1s { unsigned short v1:8; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu31i { unsigned short v1:8; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu31ll { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu32i { unsigned short v1:8; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu32ll { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu33 { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu7c { unsigned short v1:8; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu7i { unsigned short v1:8; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu7ll { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu7s { unsigned short v1:8; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8c { unsigned short v1:8; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8c_BFs8c { unsigned short v1:8; unsigned int v2:8; unsigned char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8c_BFs8i { unsigned short v1:8; unsigned int v2:8; unsigned char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8c_BFs8ll { unsigned short v1:8; unsigned int v2:8; unsigned char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8c_BFs8s { unsigned short v1:8; unsigned int v2:8; unsigned char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8c_BFu8c { unsigned short v1:8; unsigned int v2:8; unsigned char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8c_BFu8i { unsigned short v1:8; unsigned int v2:8; unsigned char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8c_BFu8ll { unsigned short v1:8; unsigned int v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8c_BFu8s { unsigned short v1:8; unsigned int v2:8; unsigned char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8i { unsigned short v1:8; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8i_BFs8c { unsigned short v1:8; unsigned int v2:8; unsigned int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8i_BFs8i { unsigned short v1:8; unsigned int v2:8; unsigned int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8i_BFs8ll { unsigned short v1:8; unsigned int v2:8; unsigned int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8i_BFs8s { unsigned short v1:8; unsigned int v2:8; unsigned int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8i_BFu8c { unsigned short v1:8; unsigned int v2:8; unsigned int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8i_BFu8i { unsigned short v1:8; unsigned int v2:8; unsigned int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8i_BFu8ll { unsigned short v1:8; unsigned int v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8i_BFu8s { unsigned short v1:8; unsigned int v2:8; unsigned int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8ll { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8ll_BFs8c { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8ll_BFs8i { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8ll_BFs8ll { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8ll_BFs8s { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8ll_BFu8c { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8ll_BFu8i { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8ll_BFu8ll { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8ll_BFu8s { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8s { unsigned short v1:8; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8s_BFs8c { unsigned short v1:8; unsigned int v2:8; unsigned short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8s_BFs8i { unsigned short v1:8; unsigned int v2:8; unsigned short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8s_BFs8ll { unsigned short v1:8; unsigned int v2:8; unsigned short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8s_BFs8s { unsigned short v1:8; unsigned int v2:8; unsigned short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8s_BFu8c { unsigned short v1:8; unsigned int v2:8; unsigned short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8s_BFu8i { unsigned short v1:8; unsigned int v2:8; unsigned short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8s_BFu8ll { unsigned short v1:8; unsigned int v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu8s_BFu8s { unsigned short v1:8; unsigned int v2:8; unsigned short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu9i { unsigned short v1:8; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu9ll { unsigned short v1:8; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu8i_BFu9s { unsigned short v1:8; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu8i_C { unsigned short v1:8; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aBFu8s_BFu8i_D { unsigned short v1:8; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aBFu8s_BFu8i_F { unsigned short v1:8; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aBFu8s_BFu8i_I { unsigned short v1:8; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aBFu8s_BFu8i_Ip { unsigned short v1:8; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu8i_L { unsigned short v1:8; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu8i_S { unsigned short v1:8; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aBFu8s_BFu8i_Uc { unsigned short v1:8; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu8i_Ui { unsigned short v1:8; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu8i_Ul { unsigned short v1:8; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu8i_Us { unsigned short v1:8; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu8i_Vp { unsigned short v1:8; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll { unsigned short v1:8; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8c { unsigned short v1:8; unsigned long long v2:8; signed char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8c_BFs8c { unsigned short v1:8; unsigned long long v2:8; signed char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8c_BFs8i { unsigned short v1:8; unsigned long long v2:8; signed char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8c_BFs8ll { unsigned short v1:8; unsigned long long v2:8; signed char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8c_BFs8s { unsigned short v1:8; unsigned long long v2:8; signed char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8c_BFu8c { unsigned short v1:8; unsigned long long v2:8; signed char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8c_BFu8i { unsigned short v1:8; unsigned long long v2:8; signed char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8c_BFu8ll { unsigned short v1:8; unsigned long long v2:8; signed char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8c_BFu8s { unsigned short v1:8; unsigned long long v2:8; signed char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8i { unsigned short v1:8; unsigned long long v2:8; signed int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8i_BFs8c { unsigned short v1:8; unsigned long long v2:8; signed int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8i_BFs8i { unsigned short v1:8; unsigned long long v2:8; signed int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8i_BFs8ll { unsigned short v1:8; unsigned long long v2:8; signed int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8i_BFs8s { unsigned short v1:8; unsigned long long v2:8; signed int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8i_BFu8c { unsigned short v1:8; unsigned long long v2:8; signed int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8i_BFu8i { unsigned short v1:8; unsigned long long v2:8; signed int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8i_BFu8ll { unsigned short v1:8; unsigned long long v2:8; signed int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8i_BFu8s { unsigned short v1:8; unsigned long long v2:8; signed int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8ll { unsigned short v1:8; unsigned long long v2:8; signed long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8ll_BFs8c { unsigned short v1:8; unsigned long long v2:8; signed long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8ll_BFs8i { unsigned short v1:8; unsigned long long v2:8; signed long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8ll_BFs8ll { unsigned short v1:8; unsigned long long v2:8; signed long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8ll_BFs8s { unsigned short v1:8; unsigned long long v2:8; signed long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8ll_BFu8c { unsigned short v1:8; unsigned long long v2:8; signed long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8ll_BFu8i { unsigned short v1:8; unsigned long long v2:8; signed long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8ll_BFu8ll { unsigned short v1:8; unsigned long long v2:8; signed long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8ll_BFu8s { unsigned short v1:8; unsigned long long v2:8; signed long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8s { unsigned short v1:8; unsigned long long v2:8; signed short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8s_BFs8c { unsigned short v1:8; unsigned long long v2:8; signed short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8s_BFs8i { unsigned short v1:8; unsigned long long v2:8; signed short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8s_BFs8ll { unsigned short v1:8; unsigned long long v2:8; signed short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8s_BFs8s { unsigned short v1:8; unsigned long long v2:8; signed short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8s_BFu8c { unsigned short v1:8; unsigned long long v2:8; signed short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8s_BFu8i { unsigned short v1:8; unsigned long long v2:8; signed short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8s_BFu8ll { unsigned short v1:8; unsigned long long v2:8; signed short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFs8s_BFu8s { unsigned short v1:8; unsigned long long v2:8; signed short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu15i { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu15ll { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu15s { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu16i { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu16ll { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu16s { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu17i { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu17ll { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu1c { unsigned short v1:8; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu1i { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu1ll { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu1s { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu31i { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu31ll { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu32i { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu32ll { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu33 { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu7c { unsigned short v1:8; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu7i { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu7ll { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu7s { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8c { unsigned short v1:8; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8c_BFs8c { unsigned short v1:8; unsigned long long v2:8; unsigned char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8c_BFs8i { unsigned short v1:8; unsigned long long v2:8; unsigned char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8c_BFs8ll { unsigned short v1:8; unsigned long long v2:8; unsigned char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8c_BFs8s { unsigned short v1:8; unsigned long long v2:8; unsigned char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8c_BFu8c { unsigned short v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8c_BFu8i { unsigned short v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8c_BFu8ll { unsigned short v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8c_BFu8s { unsigned short v1:8; unsigned long long v2:8; unsigned char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8i { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8i_BFs8c { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8i_BFs8i { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8i_BFs8ll { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8i_BFs8s { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8i_BFu8c { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8i_BFu8i { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8i_BFu8ll { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8i_BFu8s { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8ll { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8ll_BFs8c { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8ll_BFs8i { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8ll_BFs8ll { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8ll_BFs8s { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8ll_BFu8c { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8ll_BFu8i { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8ll_BFu8ll { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8ll_BFu8s { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8s { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8s_BFs8c { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8s_BFs8i { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8s_BFs8ll { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8s_BFs8s { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8s_BFu8c { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8s_BFu8i { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8s_BFu8ll { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu8s_BFu8s { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu9i { unsigned short v1:8; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu9ll { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu8ll_BFu9s { unsigned short v1:8; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu8ll_C { unsigned short v1:8; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll_D { unsigned short v1:8; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll_F { unsigned short v1:8; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll_I { unsigned short v1:8; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll_Ip { unsigned short v1:8; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll_L { unsigned short v1:8; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll_S { unsigned short v1:8; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll_Uc { unsigned short v1:8; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll_Ui { unsigned short v1:8; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll_Ul { unsigned short v1:8; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll_Us { unsigned short v1:8; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu8ll_Vp { unsigned short v1:8; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu8s { unsigned short v1:8; unsigned short v2:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8c { unsigned short v1:8; unsigned short v2:8; signed char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8c_BFs8c { unsigned short v1:8; unsigned short v2:8; signed char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8c_BFs8i { unsigned short v1:8; unsigned short v2:8; signed char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8c_BFs8ll { unsigned short v1:8; unsigned short v2:8; signed char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8c_BFs8s { unsigned short v1:8; unsigned short v2:8; signed char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8c_BFu8c { unsigned short v1:8; unsigned short v2:8; signed char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8c_BFu8i { unsigned short v1:8; unsigned short v2:8; signed char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8c_BFu8ll { unsigned short v1:8; unsigned short v2:8; signed char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8c_BFu8s { unsigned short v1:8; unsigned short v2:8; signed char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8i { unsigned short v1:8; unsigned short v2:8; signed int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8i_BFs8c { unsigned short v1:8; unsigned short v2:8; signed int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8i_BFs8i { unsigned short v1:8; unsigned short v2:8; signed int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8i_BFs8ll { unsigned short v1:8; unsigned short v2:8; signed int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8i_BFs8s { unsigned short v1:8; unsigned short v2:8; signed int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8i_BFu8c { unsigned short v1:8; unsigned short v2:8; signed int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8i_BFu8i { unsigned short v1:8; unsigned short v2:8; signed int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8i_BFu8ll { unsigned short v1:8; unsigned short v2:8; signed int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8i_BFu8s { unsigned short v1:8; unsigned short v2:8; signed int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8ll { unsigned short v1:8; unsigned short v2:8; signed long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8ll_BFs8c { unsigned short v1:8; unsigned short v2:8; signed long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8ll_BFs8i { unsigned short v1:8; unsigned short v2:8; signed long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8ll_BFs8ll { unsigned short v1:8; unsigned short v2:8; signed long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8ll_BFs8s { unsigned short v1:8; unsigned short v2:8; signed long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8ll_BFu8c { unsigned short v1:8; unsigned short v2:8; signed long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8ll_BFu8i { unsigned short v1:8; unsigned short v2:8; signed long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8ll_BFu8ll { unsigned short v1:8; unsigned short v2:8; signed long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8ll_BFu8s { unsigned short v1:8; unsigned short v2:8; signed long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8s { unsigned short v1:8; unsigned short v2:8; signed short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8s_BFs8c { unsigned short v1:8; unsigned short v2:8; signed short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8s_BFs8i { unsigned short v1:8; unsigned short v2:8; signed short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8s_BFs8ll { unsigned short v1:8; unsigned short v2:8; signed short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8s_BFs8s { unsigned short v1:8; unsigned short v2:8; signed short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8s_BFu8c { unsigned short v1:8; unsigned short v2:8; signed short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8s_BFu8i { unsigned short v1:8; unsigned short v2:8; signed short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8s_BFu8ll { unsigned short v1:8; unsigned short v2:8; signed short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFs8s_BFu8s { unsigned short v1:8; unsigned short v2:8; signed short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu15i { unsigned short v1:8; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu15ll { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu15s { unsigned short v1:8; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu16i { unsigned short v1:8; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu16ll { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu16s { unsigned short v1:8; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu17i { unsigned short v1:8; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu17ll { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu1c { unsigned short v1:8; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu1i { unsigned short v1:8; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu1ll { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu1s { unsigned short v1:8; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu31i { unsigned short v1:8; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu31ll { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu32i { unsigned short v1:8; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu32ll { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu33 { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu7c { unsigned short v1:8; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu7i { unsigned short v1:8; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu7ll { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu7s { unsigned short v1:8; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8c { unsigned short v1:8; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8c_BFs8c { unsigned short v1:8; unsigned short v2:8; unsigned char v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8c_BFs8i { unsigned short v1:8; unsigned short v2:8; unsigned char v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8c_BFs8ll { unsigned short v1:8; unsigned short v2:8; unsigned char v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8c_BFs8s { unsigned short v1:8; unsigned short v2:8; unsigned char v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8c_BFu8c { unsigned short v1:8; unsigned short v2:8; unsigned char v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8c_BFu8i { unsigned short v1:8; unsigned short v2:8; unsigned char v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8c_BFu8ll { unsigned short v1:8; unsigned short v2:8; unsigned char v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8c_BFu8s { unsigned short v1:8; unsigned short v2:8; unsigned char v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8i { unsigned short v1:8; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8i_BFs8c { unsigned short v1:8; unsigned short v2:8; unsigned int v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8i_BFs8i { unsigned short v1:8; unsigned short v2:8; unsigned int v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8i_BFs8ll { unsigned short v1:8; unsigned short v2:8; unsigned int v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8i_BFs8s { unsigned short v1:8; unsigned short v2:8; unsigned int v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8i_BFu8c { unsigned short v1:8; unsigned short v2:8; unsigned int v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8i_BFu8i { unsigned short v1:8; unsigned short v2:8; unsigned int v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8i_BFu8ll { unsigned short v1:8; unsigned short v2:8; unsigned int v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8i_BFu8s { unsigned short v1:8; unsigned short v2:8; unsigned int v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8ll { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8ll_BFs8c { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8ll_BFs8i { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8ll_BFs8ll { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8ll_BFs8s { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8ll_BFu8c { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8ll_BFu8i { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8ll_BFu8ll { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8ll_BFu8s { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8s { unsigned short v1:8; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8s_BFs8c { unsigned short v1:8; unsigned short v2:8; unsigned short v3:8; signed char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8s_BFs8i { unsigned short v1:8; unsigned short v2:8; unsigned short v3:8; signed int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8s_BFs8ll { unsigned short v1:8; unsigned short v2:8; unsigned short v3:8; signed long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8s_BFs8s { unsigned short v1:8; unsigned short v2:8; unsigned short v3:8; signed short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8s_BFu8c { unsigned short v1:8; unsigned short v2:8; unsigned short v3:8; unsigned char v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8s_BFu8i { unsigned short v1:8; unsigned short v2:8; unsigned short v3:8; unsigned int v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8s_BFu8ll { unsigned short v1:8; unsigned short v2:8; unsigned short v3:8; unsigned long long v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu8s_BFu8s { unsigned short v1:8; unsigned short v2:8; unsigned short v3:8; unsigned short v4:8; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu9i { unsigned short v1:8; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu9ll { unsigned short v1:8; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu8s_BFu9s { unsigned short v1:8; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu8s_C { unsigned short v1:8; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aBFu8s_BFu8s_D { unsigned short v1:8; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aBFu8s_BFu8s_F { unsigned short v1:8; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aBFu8s_BFu8s_I { unsigned short v1:8; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aBFu8s_BFu8s_Ip { unsigned short v1:8; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu8s_L { unsigned short v1:8; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu8s_S { unsigned short v1:8; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aBFu8s_BFu8s_Uc { unsigned short v1:8; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu8s_Ui { unsigned short v1:8; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu8s_Ul { unsigned short v1:8; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu8s_Us { unsigned short v1:8; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu8s_Vp { unsigned short v1:8; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu9i { unsigned short v1:8; unsigned int v2:9; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu15i { unsigned short v1:8; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu15ll { unsigned short v1:8; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu15s { unsigned short v1:8; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu16i { unsigned short v1:8; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu16ll { unsigned short v1:8; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu16s { unsigned short v1:8; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu17i { unsigned short v1:8; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu17ll { unsigned short v1:8; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu1c { unsigned short v1:8; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu1i { unsigned short v1:8; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu1ll { unsigned short v1:8; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu1s { unsigned short v1:8; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu31i { unsigned short v1:8; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu31ll { unsigned short v1:8; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu32i { unsigned short v1:8; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu32ll { unsigned short v1:8; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu33 { unsigned short v1:8; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu7c { unsigned short v1:8; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu7i { unsigned short v1:8; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu7ll { unsigned short v1:8; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu7s { unsigned short v1:8; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu8c { unsigned short v1:8; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu8i { unsigned short v1:8; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu8ll { unsigned short v1:8; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu8s { unsigned short v1:8; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu9i { unsigned short v1:8; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu9ll { unsigned short v1:8; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu9i_BFu9s { unsigned short v1:8; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu9i_C { unsigned short v1:8; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aBFu8s_BFu9i_D { unsigned short v1:8; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aBFu8s_BFu9i_F { unsigned short v1:8; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aBFu8s_BFu9i_I { unsigned short v1:8; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aBFu8s_BFu9i_Ip { unsigned short v1:8; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu9i_L { unsigned short v1:8; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu9i_S { unsigned short v1:8; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aBFu8s_BFu9i_Uc { unsigned short v1:8; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu9i_Ui { unsigned short v1:8; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu9i_Ul { unsigned short v1:8; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu9i_Us { unsigned short v1:8; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu9i_Vp { unsigned short v1:8; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll { unsigned short v1:8; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu15i { unsigned short v1:8; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu15ll { unsigned short v1:8; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu15s { unsigned short v1:8; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu16i { unsigned short v1:8; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu16ll { unsigned short v1:8; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu16s { unsigned short v1:8; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu17i { unsigned short v1:8; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu17ll { unsigned short v1:8; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu1c { unsigned short v1:8; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu1i { unsigned short v1:8; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu1ll { unsigned short v1:8; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu1s { unsigned short v1:8; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu31i { unsigned short v1:8; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu31ll { unsigned short v1:8; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu32i { unsigned short v1:8; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu32ll { unsigned short v1:8; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu33 { unsigned short v1:8; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu7c { unsigned short v1:8; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu7i { unsigned short v1:8; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu7ll { unsigned short v1:8; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu7s { unsigned short v1:8; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu8c { unsigned short v1:8; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu8i { unsigned short v1:8; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu8ll { unsigned short v1:8; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu8s { unsigned short v1:8; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu9i { unsigned short v1:8; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu9ll { unsigned short v1:8; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu9ll_BFu9s { unsigned short v1:8; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu9ll_C { unsigned short v1:8; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll_D { unsigned short v1:8; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll_F { unsigned short v1:8; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll_I { unsigned short v1:8; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll_Ip { unsigned short v1:8; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll_L { unsigned short v1:8; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll_S { unsigned short v1:8; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll_Uc { unsigned short v1:8; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll_Ui { unsigned short v1:8; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll_Ul { unsigned short v1:8; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll_Us { unsigned short v1:8; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu9ll_Vp { unsigned short v1:8; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aBFu8s_BFu9s { unsigned short v1:8; unsigned short v2:9; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu15i { unsigned short v1:8; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu15ll { unsigned short v1:8; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu15s { unsigned short v1:8; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu16i { unsigned short v1:8; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu16ll { unsigned short v1:8; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu16s { unsigned short v1:8; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu17i { unsigned short v1:8; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu17ll { unsigned short v1:8; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu1c { unsigned short v1:8; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu1i { unsigned short v1:8; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu1ll { unsigned short v1:8; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu1s { unsigned short v1:8; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu31i { unsigned short v1:8; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu31ll { unsigned short v1:8; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu32i { unsigned short v1:8; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu32ll { unsigned short v1:8; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu33 { unsigned short v1:8; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu7c { unsigned short v1:8; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu7i { unsigned short v1:8; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu7ll { unsigned short v1:8; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu7s { unsigned short v1:8; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu8c { unsigned short v1:8; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu8i { unsigned short v1:8; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu8ll { unsigned short v1:8; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu8s { unsigned short v1:8; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu9i { unsigned short v1:8; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu9ll { unsigned short v1:8; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_BFu9s_BFu9s { unsigned short v1:8; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_BFu9s_C { unsigned short v1:8; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aBFu8s_BFu9s_D { unsigned short v1:8; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aBFu8s_BFu9s_F { unsigned short v1:8; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aBFu8s_BFu9s_I { unsigned short v1:8; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aBFu8s_BFu9s_Ip { unsigned short v1:8; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aBFu8s_BFu9s_L { unsigned short v1:8; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aBFu8s_BFu9s_S { unsigned short v1:8; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aBFu8s_BFu9s_Uc { unsigned short v1:8; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_BFu9s_Ui { unsigned short v1:8; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_BFu9s_Ul { unsigned short v1:8; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_BFu9s_Us { unsigned short v1:8; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_BFu9s_Vp { unsigned short v1:8; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aBFu8s_C { unsigned short v1:8; char v2; };
struct __attribute__((packed)) aBFu8s_C_BFu15i { unsigned short v1:8; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_C_BFu15ll { unsigned short v1:8; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_C_BFu15s { unsigned short v1:8; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_C_BFu16i { unsigned short v1:8; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_C_BFu16ll { unsigned short v1:8; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_C_BFu16s { unsigned short v1:8; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_C_BFu17i { unsigned short v1:8; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_C_BFu17ll { unsigned short v1:8; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_C_BFu1c { unsigned short v1:8; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_C_BFu1i { unsigned short v1:8; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_C_BFu1ll { unsigned short v1:8; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_C_BFu1s { unsigned short v1:8; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_C_BFu31i { unsigned short v1:8; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_C_BFu31ll { unsigned short v1:8; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_C_BFu32i { unsigned short v1:8; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_C_BFu32ll { unsigned short v1:8; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_C_BFu33 { unsigned short v1:8; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_C_BFu7c { unsigned short v1:8; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_C_BFu7i { unsigned short v1:8; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_C_BFu7ll { unsigned short v1:8; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_C_BFu7s { unsigned short v1:8; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_C_BFu8c { unsigned short v1:8; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_C_BFu8i { unsigned short v1:8; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_C_BFu8ll { unsigned short v1:8; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_C_BFu8s { unsigned short v1:8; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_C_BFu9i { unsigned short v1:8; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_C_BFu9ll { unsigned short v1:8; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_C_BFu9s { unsigned short v1:8; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_C_C { unsigned short v1:8; char v2; char v3; };
struct __attribute__((packed)) aBFu8s_C_D { unsigned short v1:8; char v2; double v3; };
struct __attribute__((packed)) aBFu8s_C_F { unsigned short v1:8; char v2; float v3; };
struct __attribute__((packed)) aBFu8s_C_I { unsigned short v1:8; char v2; int v3; };
struct __attribute__((packed)) aBFu8s_C_Ip { unsigned short v1:8; char v2; int * v3; };
struct __attribute__((packed)) aBFu8s_C_L { unsigned short v1:8; char v2; long long v3; };
struct __attribute__((packed)) aBFu8s_C_S { unsigned short v1:8; char v2; short v3; };
struct __attribute__((packed)) aBFu8s_C_Uc { unsigned short v1:8; char v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_C_Ui { unsigned short v1:8; char v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_C_Ul { unsigned short v1:8; char v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_C_Us { unsigned short v1:8; char v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_C_Vp { unsigned short v1:8; char v2; void * v3; };
struct __attribute__((packed)) aBFu8s_D { unsigned short v1:8; double v2; };
struct __attribute__((packed)) aBFu8s_D_BFu15i { unsigned short v1:8; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_D_BFu15ll { unsigned short v1:8; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_D_BFu15s { unsigned short v1:8; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_D_BFu16i { unsigned short v1:8; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_D_BFu16ll { unsigned short v1:8; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_D_BFu16s { unsigned short v1:8; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_D_BFu17i { unsigned short v1:8; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_D_BFu17ll { unsigned short v1:8; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_D_BFu1c { unsigned short v1:8; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_D_BFu1i { unsigned short v1:8; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_D_BFu1ll { unsigned short v1:8; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_D_BFu1s { unsigned short v1:8; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_D_BFu31i { unsigned short v1:8; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_D_BFu31ll { unsigned short v1:8; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_D_BFu32i { unsigned short v1:8; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_D_BFu32ll { unsigned short v1:8; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_D_BFu33 { unsigned short v1:8; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_D_BFu7c { unsigned short v1:8; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_D_BFu7i { unsigned short v1:8; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_D_BFu7ll { unsigned short v1:8; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_D_BFu7s { unsigned short v1:8; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_D_BFu8c { unsigned short v1:8; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_D_BFu8i { unsigned short v1:8; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_D_BFu8ll { unsigned short v1:8; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_D_BFu8s { unsigned short v1:8; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_D_BFu9i { unsigned short v1:8; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_D_BFu9ll { unsigned short v1:8; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_D_BFu9s { unsigned short v1:8; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_D_C { unsigned short v1:8; double v2; char v3; };
struct __attribute__((packed)) aBFu8s_D_D { unsigned short v1:8; double v2; double v3; };
struct __attribute__((packed)) aBFu8s_D_F { unsigned short v1:8; double v2; float v3; };
struct __attribute__((packed)) aBFu8s_D_I { unsigned short v1:8; double v2; int v3; };
struct __attribute__((packed)) aBFu8s_D_Ip { unsigned short v1:8; double v2; int * v3; };
struct __attribute__((packed)) aBFu8s_D_L { unsigned short v1:8; double v2; long long v3; };
struct __attribute__((packed)) aBFu8s_D_S { unsigned short v1:8; double v2; short v3; };
struct __attribute__((packed)) aBFu8s_D_Uc { unsigned short v1:8; double v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_D_Ui { unsigned short v1:8; double v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_D_Ul { unsigned short v1:8; double v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_D_Us { unsigned short v1:8; double v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_D_Vp { unsigned short v1:8; double v2; void * v3; };
struct __attribute__((packed)) aBFu8s_F { unsigned short v1:8; float v2; };
struct __attribute__((packed)) aBFu8s_F_BFu15i { unsigned short v1:8; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_F_BFu15ll { unsigned short v1:8; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_F_BFu15s { unsigned short v1:8; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_F_BFu16i { unsigned short v1:8; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_F_BFu16ll { unsigned short v1:8; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_F_BFu16s { unsigned short v1:8; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_F_BFu17i { unsigned short v1:8; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_F_BFu17ll { unsigned short v1:8; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_F_BFu1c { unsigned short v1:8; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_F_BFu1i { unsigned short v1:8; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_F_BFu1ll { unsigned short v1:8; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_F_BFu1s { unsigned short v1:8; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_F_BFu31i { unsigned short v1:8; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_F_BFu31ll { unsigned short v1:8; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_F_BFu32i { unsigned short v1:8; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_F_BFu32ll { unsigned short v1:8; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_F_BFu33 { unsigned short v1:8; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_F_BFu7c { unsigned short v1:8; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_F_BFu7i { unsigned short v1:8; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_F_BFu7ll { unsigned short v1:8; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_F_BFu7s { unsigned short v1:8; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_F_BFu8c { unsigned short v1:8; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_F_BFu8i { unsigned short v1:8; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_F_BFu8ll { unsigned short v1:8; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_F_BFu8s { unsigned short v1:8; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_F_BFu9i { unsigned short v1:8; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_F_BFu9ll { unsigned short v1:8; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_F_BFu9s { unsigned short v1:8; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_F_C { unsigned short v1:8; float v2; char v3; };
struct __attribute__((packed)) aBFu8s_F_D { unsigned short v1:8; float v2; double v3; };
struct __attribute__((packed)) aBFu8s_F_F { unsigned short v1:8; float v2; float v3; };
struct __attribute__((packed)) aBFu8s_F_I { unsigned short v1:8; float v2; int v3; };
struct __attribute__((packed)) aBFu8s_F_Ip { unsigned short v1:8; float v2; int * v3; };
struct __attribute__((packed)) aBFu8s_F_L { unsigned short v1:8; float v2; long long v3; };
struct __attribute__((packed)) aBFu8s_F_S { unsigned short v1:8; float v2; short v3; };
struct __attribute__((packed)) aBFu8s_F_Uc { unsigned short v1:8; float v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_F_Ui { unsigned short v1:8; float v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_F_Ul { unsigned short v1:8; float v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_F_Us { unsigned short v1:8; float v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_F_Vp { unsigned short v1:8; float v2; void * v3; };
struct __attribute__((packed)) aBFu8s_I { unsigned short v1:8; int v2; };
struct __attribute__((packed)) aBFu8s_I_BFu15i { unsigned short v1:8; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_I_BFu15ll { unsigned short v1:8; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_I_BFu15s { unsigned short v1:8; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_I_BFu16i { unsigned short v1:8; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_I_BFu16ll { unsigned short v1:8; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_I_BFu16s { unsigned short v1:8; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_I_BFu17i { unsigned short v1:8; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_I_BFu17ll { unsigned short v1:8; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_I_BFu1c { unsigned short v1:8; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_I_BFu1i { unsigned short v1:8; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_I_BFu1ll { unsigned short v1:8; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_I_BFu1s { unsigned short v1:8; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_I_BFu31i { unsigned short v1:8; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_I_BFu31ll { unsigned short v1:8; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_I_BFu32i { unsigned short v1:8; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_I_BFu32ll { unsigned short v1:8; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_I_BFu33 { unsigned short v1:8; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_I_BFu7c { unsigned short v1:8; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_I_BFu7i { unsigned short v1:8; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_I_BFu7ll { unsigned short v1:8; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_I_BFu7s { unsigned short v1:8; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_I_BFu8c { unsigned short v1:8; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_I_BFu8i { unsigned short v1:8; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_I_BFu8ll { unsigned short v1:8; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_I_BFu8s { unsigned short v1:8; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_I_BFu9i { unsigned short v1:8; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_I_BFu9ll { unsigned short v1:8; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_I_BFu9s { unsigned short v1:8; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_I_C { unsigned short v1:8; int v2; char v3; };
struct __attribute__((packed)) aBFu8s_I_D { unsigned short v1:8; int v2; double v3; };
struct __attribute__((packed)) aBFu8s_I_F { unsigned short v1:8; int v2; float v3; };
struct __attribute__((packed)) aBFu8s_I_I { unsigned short v1:8; int v2; int v3; };
struct __attribute__((packed)) aBFu8s_I_Ip { unsigned short v1:8; int v2; int * v3; };
struct __attribute__((packed)) aBFu8s_I_L { unsigned short v1:8; int v2; long long v3; };
struct __attribute__((packed)) aBFu8s_I_S { unsigned short v1:8; int v2; short v3; };
struct __attribute__((packed)) aBFu8s_I_Uc { unsigned short v1:8; int v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_I_Ui { unsigned short v1:8; int v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_I_Ul { unsigned short v1:8; int v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_I_Us { unsigned short v1:8; int v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_I_Vp { unsigned short v1:8; int v2; void * v3; };
struct __attribute__((packed)) aBFu8s_Ip { unsigned short v1:8; int * v2; };
struct __attribute__((packed)) aBFu8s_Ip_BFu15i { unsigned short v1:8; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_Ip_BFu15ll { unsigned short v1:8; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_Ip_BFu15s { unsigned short v1:8; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_Ip_BFu16i { unsigned short v1:8; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_Ip_BFu16ll { unsigned short v1:8; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_Ip_BFu16s { unsigned short v1:8; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_Ip_BFu17i { unsigned short v1:8; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_Ip_BFu17ll { unsigned short v1:8; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_Ip_BFu1c { unsigned short v1:8; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_Ip_BFu1i { unsigned short v1:8; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_Ip_BFu1ll { unsigned short v1:8; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_Ip_BFu1s { unsigned short v1:8; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_Ip_BFu31i { unsigned short v1:8; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_Ip_BFu31ll { unsigned short v1:8; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_Ip_BFu32i { unsigned short v1:8; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_Ip_BFu32ll { unsigned short v1:8; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_Ip_BFu33 { unsigned short v1:8; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_Ip_BFu7c { unsigned short v1:8; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_Ip_BFu7i { unsigned short v1:8; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_Ip_BFu7ll { unsigned short v1:8; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_Ip_BFu7s { unsigned short v1:8; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_Ip_BFu8c { unsigned short v1:8; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_Ip_BFu8i { unsigned short v1:8; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_Ip_BFu8ll { unsigned short v1:8; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_Ip_BFu8s { unsigned short v1:8; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_Ip_BFu9i { unsigned short v1:8; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_Ip_BFu9ll { unsigned short v1:8; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_Ip_BFu9s { unsigned short v1:8; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_Ip_C { unsigned short v1:8; int * v2; char v3; };
struct __attribute__((packed)) aBFu8s_Ip_D { unsigned short v1:8; int * v2; double v3; };
struct __attribute__((packed)) aBFu8s_Ip_F { unsigned short v1:8; int * v2; float v3; };
struct __attribute__((packed)) aBFu8s_Ip_I { unsigned short v1:8; int * v2; int v3; };
struct __attribute__((packed)) aBFu8s_Ip_Ip { unsigned short v1:8; int * v2; int * v3; };
struct __attribute__((packed)) aBFu8s_Ip_L { unsigned short v1:8; int * v2; long long v3; };
struct __attribute__((packed)) aBFu8s_Ip_S { unsigned short v1:8; int * v2; short v3; };
struct __attribute__((packed)) aBFu8s_Ip_Uc { unsigned short v1:8; int * v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_Ip_Ui { unsigned short v1:8; int * v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_Ip_Ul { unsigned short v1:8; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_Ip_Us { unsigned short v1:8; int * v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_Ip_Vp { unsigned short v1:8; int * v2; void * v3; };
struct __attribute__((packed)) aBFu8s_L { unsigned short v1:8; long long v2; };
struct __attribute__((packed)) aBFu8s_L_BFu15i { unsigned short v1:8; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_L_BFu15ll { unsigned short v1:8; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_L_BFu15s { unsigned short v1:8; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_L_BFu16i { unsigned short v1:8; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_L_BFu16ll { unsigned short v1:8; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_L_BFu16s { unsigned short v1:8; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_L_BFu17i { unsigned short v1:8; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_L_BFu17ll { unsigned short v1:8; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_L_BFu1c { unsigned short v1:8; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_L_BFu1i { unsigned short v1:8; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_L_BFu1ll { unsigned short v1:8; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_L_BFu1s { unsigned short v1:8; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_L_BFu31i { unsigned short v1:8; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_L_BFu31ll { unsigned short v1:8; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_L_BFu32i { unsigned short v1:8; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_L_BFu32ll { unsigned short v1:8; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_L_BFu33 { unsigned short v1:8; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_L_BFu7c { unsigned short v1:8; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_L_BFu7i { unsigned short v1:8; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_L_BFu7ll { unsigned short v1:8; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_L_BFu7s { unsigned short v1:8; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_L_BFu8c { unsigned short v1:8; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_L_BFu8i { unsigned short v1:8; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_L_BFu8ll { unsigned short v1:8; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_L_BFu8s { unsigned short v1:8; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_L_BFu9i { unsigned short v1:8; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_L_BFu9ll { unsigned short v1:8; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_L_BFu9s { unsigned short v1:8; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_L_C { unsigned short v1:8; long long v2; char v3; };
struct __attribute__((packed)) aBFu8s_L_D { unsigned short v1:8; long long v2; double v3; };
struct __attribute__((packed)) aBFu8s_L_F { unsigned short v1:8; long long v2; float v3; };
struct __attribute__((packed)) aBFu8s_L_I { unsigned short v1:8; long long v2; int v3; };
struct __attribute__((packed)) aBFu8s_L_Ip { unsigned short v1:8; long long v2; int * v3; };
struct __attribute__((packed)) aBFu8s_L_L { unsigned short v1:8; long long v2; long long v3; };
struct __attribute__((packed)) aBFu8s_L_S { unsigned short v1:8; long long v2; short v3; };
struct __attribute__((packed)) aBFu8s_L_Uc { unsigned short v1:8; long long v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_L_Ui { unsigned short v1:8; long long v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_L_Ul { unsigned short v1:8; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_L_Us { unsigned short v1:8; long long v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_L_Vp { unsigned short v1:8; long long v2; void * v3; };
struct __attribute__((packed)) aBFu8s_S { unsigned short v1:8; short v2; };
struct __attribute__((packed)) aBFu8s_S_BFu15i { unsigned short v1:8; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_S_BFu15ll { unsigned short v1:8; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_S_BFu15s { unsigned short v1:8; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_S_BFu16i { unsigned short v1:8; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_S_BFu16ll { unsigned short v1:8; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_S_BFu16s { unsigned short v1:8; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_S_BFu17i { unsigned short v1:8; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_S_BFu17ll { unsigned short v1:8; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_S_BFu1c { unsigned short v1:8; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_S_BFu1i { unsigned short v1:8; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_S_BFu1ll { unsigned short v1:8; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_S_BFu1s { unsigned short v1:8; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_S_BFu31i { unsigned short v1:8; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_S_BFu31ll { unsigned short v1:8; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_S_BFu32i { unsigned short v1:8; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_S_BFu32ll { unsigned short v1:8; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_S_BFu33 { unsigned short v1:8; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_S_BFu7c { unsigned short v1:8; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_S_BFu7i { unsigned short v1:8; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_S_BFu7ll { unsigned short v1:8; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_S_BFu7s { unsigned short v1:8; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_S_BFu8c { unsigned short v1:8; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_S_BFu8i { unsigned short v1:8; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_S_BFu8ll { unsigned short v1:8; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_S_BFu8s { unsigned short v1:8; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_S_BFu9i { unsigned short v1:8; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_S_BFu9ll { unsigned short v1:8; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_S_BFu9s { unsigned short v1:8; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_S_C { unsigned short v1:8; short v2; char v3; };
struct __attribute__((packed)) aBFu8s_S_D { unsigned short v1:8; short v2; double v3; };
struct __attribute__((packed)) aBFu8s_S_F { unsigned short v1:8; short v2; float v3; };
struct __attribute__((packed)) aBFu8s_S_I { unsigned short v1:8; short v2; int v3; };
struct __attribute__((packed)) aBFu8s_S_Ip { unsigned short v1:8; short v2; int * v3; };
struct __attribute__((packed)) aBFu8s_S_L { unsigned short v1:8; short v2; long long v3; };
struct __attribute__((packed)) aBFu8s_S_S { unsigned short v1:8; short v2; short v3; };
struct __attribute__((packed)) aBFu8s_S_Uc { unsigned short v1:8; short v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_S_Ui { unsigned short v1:8; short v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_S_Ul { unsigned short v1:8; short v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_S_Us { unsigned short v1:8; short v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_S_Vp { unsigned short v1:8; short v2; void * v3; };
struct __attribute__((packed)) aBFu8s_Uc { unsigned short v1:8; unsigned char v2; };
struct __attribute__((packed)) aBFu8s_Uc_BFu15i { unsigned short v1:8; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_Uc_BFu15ll { unsigned short v1:8; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_Uc_BFu15s { unsigned short v1:8; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_Uc_BFu16i { unsigned short v1:8; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_Uc_BFu16ll { unsigned short v1:8; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_Uc_BFu16s { unsigned short v1:8; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_Uc_BFu17i { unsigned short v1:8; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_Uc_BFu17ll { unsigned short v1:8; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_Uc_BFu1c { unsigned short v1:8; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_Uc_BFu1i { unsigned short v1:8; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_Uc_BFu1ll { unsigned short v1:8; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_Uc_BFu1s { unsigned short v1:8; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_Uc_BFu31i { unsigned short v1:8; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_Uc_BFu31ll { unsigned short v1:8; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_Uc_BFu32i { unsigned short v1:8; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_Uc_BFu32ll { unsigned short v1:8; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_Uc_BFu33 { unsigned short v1:8; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_Uc_BFu7c { unsigned short v1:8; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_Uc_BFu7i { unsigned short v1:8; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_Uc_BFu7ll { unsigned short v1:8; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_Uc_BFu7s { unsigned short v1:8; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_Uc_BFu8c { unsigned short v1:8; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_Uc_BFu8i { unsigned short v1:8; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_Uc_BFu8ll { unsigned short v1:8; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_Uc_BFu8s { unsigned short v1:8; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_Uc_BFu9i { unsigned short v1:8; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_Uc_BFu9ll { unsigned short v1:8; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_Uc_BFu9s { unsigned short v1:8; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_Uc_C { unsigned short v1:8; unsigned char v2; char v3; };
struct __attribute__((packed)) aBFu8s_Uc_D { unsigned short v1:8; unsigned char v2; double v3; };
struct __attribute__((packed)) aBFu8s_Uc_F { unsigned short v1:8; unsigned char v2; float v3; };
struct __attribute__((packed)) aBFu8s_Uc_I { unsigned short v1:8; unsigned char v2; int v3; };
struct __attribute__((packed)) aBFu8s_Uc_Ip { unsigned short v1:8; unsigned char v2; int * v3; };
struct __attribute__((packed)) aBFu8s_Uc_L { unsigned short v1:8; unsigned char v2; long long v3; };
struct __attribute__((packed)) aBFu8s_Uc_S { unsigned short v1:8; unsigned char v2; short v3; };
struct __attribute__((packed)) aBFu8s_Uc_Uc { unsigned short v1:8; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_Uc_Ui { unsigned short v1:8; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_Uc_Ul { unsigned short v1:8; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_Uc_Us { unsigned short v1:8; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_Uc_Vp { unsigned short v1:8; unsigned char v2; void * v3; };
struct __attribute__((packed)) aBFu8s_Ui { unsigned short v1:8; unsigned int v2; };
struct __attribute__((packed)) aBFu8s_Ui_BFu15i { unsigned short v1:8; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_Ui_BFu15ll { unsigned short v1:8; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_Ui_BFu15s { unsigned short v1:8; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_Ui_BFu16i { unsigned short v1:8; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_Ui_BFu16ll { unsigned short v1:8; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_Ui_BFu16s { unsigned short v1:8; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_Ui_BFu17i { unsigned short v1:8; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_Ui_BFu17ll { unsigned short v1:8; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_Ui_BFu1c { unsigned short v1:8; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_Ui_BFu1i { unsigned short v1:8; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_Ui_BFu1ll { unsigned short v1:8; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_Ui_BFu1s { unsigned short v1:8; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_Ui_BFu31i { unsigned short v1:8; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_Ui_BFu31ll { unsigned short v1:8; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_Ui_BFu32i { unsigned short v1:8; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_Ui_BFu32ll { unsigned short v1:8; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_Ui_BFu33 { unsigned short v1:8; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_Ui_BFu7c { unsigned short v1:8; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_Ui_BFu7i { unsigned short v1:8; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_Ui_BFu7ll { unsigned short v1:8; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_Ui_BFu7s { unsigned short v1:8; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_Ui_BFu8c { unsigned short v1:8; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_Ui_BFu8i { unsigned short v1:8; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_Ui_BFu8ll { unsigned short v1:8; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_Ui_BFu8s { unsigned short v1:8; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_Ui_BFu9i { unsigned short v1:8; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_Ui_BFu9ll { unsigned short v1:8; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_Ui_BFu9s { unsigned short v1:8; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_Ui_C { unsigned short v1:8; unsigned int v2; char v3; };
struct __attribute__((packed)) aBFu8s_Ui_D { unsigned short v1:8; unsigned int v2; double v3; };
struct __attribute__((packed)) aBFu8s_Ui_F { unsigned short v1:8; unsigned int v2; float v3; };
struct __attribute__((packed)) aBFu8s_Ui_I { unsigned short v1:8; unsigned int v2; int v3; };
struct __attribute__((packed)) aBFu8s_Ui_Ip { unsigned short v1:8; unsigned int v2; int * v3; };
struct __attribute__((packed)) aBFu8s_Ui_L { unsigned short v1:8; unsigned int v2; long long v3; };
struct __attribute__((packed)) aBFu8s_Ui_S { unsigned short v1:8; unsigned int v2; short v3; };
struct __attribute__((packed)) aBFu8s_Ui_Uc { unsigned short v1:8; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_Ui_Ui { unsigned short v1:8; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_Ui_Ul { unsigned short v1:8; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_Ui_Us { unsigned short v1:8; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_Ui_Vp { unsigned short v1:8; unsigned int v2; void * v3; };
struct __attribute__((packed)) aBFu8s_Ul { unsigned short v1:8; unsigned long long v2; };
struct __attribute__((packed)) aBFu8s_Ul_BFu15i { unsigned short v1:8; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_Ul_BFu15ll { unsigned short v1:8; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_Ul_BFu15s { unsigned short v1:8; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_Ul_BFu16i { unsigned short v1:8; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_Ul_BFu16ll { unsigned short v1:8; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_Ul_BFu16s { unsigned short v1:8; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_Ul_BFu17i { unsigned short v1:8; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_Ul_BFu17ll { unsigned short v1:8; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_Ul_BFu1c { unsigned short v1:8; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_Ul_BFu1i { unsigned short v1:8; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_Ul_BFu1ll { unsigned short v1:8; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_Ul_BFu1s { unsigned short v1:8; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_Ul_BFu31i { unsigned short v1:8; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_Ul_BFu31ll { unsigned short v1:8; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_Ul_BFu32i { unsigned short v1:8; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_Ul_BFu32ll { unsigned short v1:8; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_Ul_BFu33 { unsigned short v1:8; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_Ul_BFu7c { unsigned short v1:8; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_Ul_BFu7i { unsigned short v1:8; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_Ul_BFu7ll { unsigned short v1:8; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_Ul_BFu7s { unsigned short v1:8; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_Ul_BFu8c { unsigned short v1:8; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_Ul_BFu8i { unsigned short v1:8; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_Ul_BFu8ll { unsigned short v1:8; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_Ul_BFu8s { unsigned short v1:8; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_Ul_BFu9i { unsigned short v1:8; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_Ul_BFu9ll { unsigned short v1:8; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_Ul_BFu9s { unsigned short v1:8; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_Ul_C { unsigned short v1:8; unsigned long long v2; char v3; };
struct __attribute__((packed)) aBFu8s_Ul_D { unsigned short v1:8; unsigned long long v2; double v3; };
struct __attribute__((packed)) aBFu8s_Ul_F { unsigned short v1:8; unsigned long long v2; float v3; };
struct __attribute__((packed)) aBFu8s_Ul_I { unsigned short v1:8; unsigned long long v2; int v3; };
struct __attribute__((packed)) aBFu8s_Ul_Ip { unsigned short v1:8; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aBFu8s_Ul_L { unsigned short v1:8; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aBFu8s_Ul_S { unsigned short v1:8; unsigned long long v2; short v3; };
struct __attribute__((packed)) aBFu8s_Ul_Uc { unsigned short v1:8; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_Ul_Ui { unsigned short v1:8; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_Ul_Ul { unsigned short v1:8; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_Ul_Us { unsigned short v1:8; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_Ul_Vp { unsigned short v1:8; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aBFu8s_Us { unsigned short v1:8; unsigned short v2; };
struct __attribute__((packed)) aBFu8s_Us_BFu15i { unsigned short v1:8; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_Us_BFu15ll { unsigned short v1:8; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_Us_BFu15s { unsigned short v1:8; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_Us_BFu16i { unsigned short v1:8; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_Us_BFu16ll { unsigned short v1:8; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_Us_BFu16s { unsigned short v1:8; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_Us_BFu17i { unsigned short v1:8; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_Us_BFu17ll { unsigned short v1:8; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_Us_BFu1c { unsigned short v1:8; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_Us_BFu1i { unsigned short v1:8; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_Us_BFu1ll { unsigned short v1:8; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_Us_BFu1s { unsigned short v1:8; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_Us_BFu31i { unsigned short v1:8; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_Us_BFu31ll { unsigned short v1:8; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_Us_BFu32i { unsigned short v1:8; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_Us_BFu32ll { unsigned short v1:8; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_Us_BFu33 { unsigned short v1:8; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_Us_BFu7c { unsigned short v1:8; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_Us_BFu7i { unsigned short v1:8; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_Us_BFu7ll { unsigned short v1:8; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_Us_BFu7s { unsigned short v1:8; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_Us_BFu8c { unsigned short v1:8; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_Us_BFu8i { unsigned short v1:8; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_Us_BFu8ll { unsigned short v1:8; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_Us_BFu8s { unsigned short v1:8; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_Us_BFu9i { unsigned short v1:8; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_Us_BFu9ll { unsigned short v1:8; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_Us_BFu9s { unsigned short v1:8; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_Us_C { unsigned short v1:8; unsigned short v2; char v3; };
struct __attribute__((packed)) aBFu8s_Us_D { unsigned short v1:8; unsigned short v2; double v3; };
struct __attribute__((packed)) aBFu8s_Us_F { unsigned short v1:8; unsigned short v2; float v3; };
struct __attribute__((packed)) aBFu8s_Us_I { unsigned short v1:8; unsigned short v2; int v3; };
struct __attribute__((packed)) aBFu8s_Us_Ip { unsigned short v1:8; unsigned short v2; int * v3; };
struct __attribute__((packed)) aBFu8s_Us_L { unsigned short v1:8; unsigned short v2; long long v3; };
struct __attribute__((packed)) aBFu8s_Us_S { unsigned short v1:8; unsigned short v2; short v3; };
struct __attribute__((packed)) aBFu8s_Us_Uc { unsigned short v1:8; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_Us_Ui { unsigned short v1:8; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_Us_Ul { unsigned short v1:8; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_Us_Us { unsigned short v1:8; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_Us_Vp { unsigned short v1:8; unsigned short v2; void * v3; };
struct __attribute__((packed)) aBFu8s_Vp { unsigned short v1:8; void * v2; };
struct __attribute__((packed)) aBFu8s_Vp_BFu15i { unsigned short v1:8; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu8s_Vp_BFu15ll { unsigned short v1:8; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu8s_Vp_BFu15s { unsigned short v1:8; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu8s_Vp_BFu16i { unsigned short v1:8; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu8s_Vp_BFu16ll { unsigned short v1:8; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu8s_Vp_BFu16s { unsigned short v1:8; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu8s_Vp_BFu17i { unsigned short v1:8; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu8s_Vp_BFu17ll { unsigned short v1:8; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu8s_Vp_BFu1c { unsigned short v1:8; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu8s_Vp_BFu1i { unsigned short v1:8; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu8s_Vp_BFu1ll { unsigned short v1:8; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu8s_Vp_BFu1s { unsigned short v1:8; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu8s_Vp_BFu31i { unsigned short v1:8; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu8s_Vp_BFu31ll { unsigned short v1:8; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu8s_Vp_BFu32i { unsigned short v1:8; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu8s_Vp_BFu32ll { unsigned short v1:8; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu8s_Vp_BFu33 { unsigned short v1:8; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu8s_Vp_BFu7c { unsigned short v1:8; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu8s_Vp_BFu7i { unsigned short v1:8; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu8s_Vp_BFu7ll { unsigned short v1:8; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu8s_Vp_BFu7s { unsigned short v1:8; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu8s_Vp_BFu8c { unsigned short v1:8; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu8s_Vp_BFu8i { unsigned short v1:8; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu8s_Vp_BFu8ll { unsigned short v1:8; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu8s_Vp_BFu8s { unsigned short v1:8; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu8s_Vp_BFu9i { unsigned short v1:8; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu8s_Vp_BFu9ll { unsigned short v1:8; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu8s_Vp_BFu9s { unsigned short v1:8; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu8s_Vp_C { unsigned short v1:8; void * v2; char v3; };
struct __attribute__((packed)) aBFu8s_Vp_D { unsigned short v1:8; void * v2; double v3; };
struct __attribute__((packed)) aBFu8s_Vp_F { unsigned short v1:8; void * v2; float v3; };
struct __attribute__((packed)) aBFu8s_Vp_I { unsigned short v1:8; void * v2; int v3; };
struct __attribute__((packed)) aBFu8s_Vp_Ip { unsigned short v1:8; void * v2; int * v3; };
struct __attribute__((packed)) aBFu8s_Vp_L { unsigned short v1:8; void * v2; long long v3; };
struct __attribute__((packed)) aBFu8s_Vp_S { unsigned short v1:8; void * v2; short v3; };
struct __attribute__((packed)) aBFu8s_Vp_Uc { unsigned short v1:8; void * v2; unsigned char v3; };
struct __attribute__((packed)) aBFu8s_Vp_Ui { unsigned short v1:8; void * v2; unsigned int v3; };
struct __attribute__((packed)) aBFu8s_Vp_Ul { unsigned short v1:8; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu8s_Vp_Us { unsigned short v1:8; void * v2; unsigned short v3; };
struct __attribute__((packed)) aBFu8s_Vp_Vp { unsigned short v1:8; void * v2; void * v3; };
struct __attribute__((packed)) aBFu9i { unsigned int v1:9; };
struct __attribute__((packed)) aBFu9i_BFs9i { unsigned int v1:9; signed int v2:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9i { unsigned int v1:9; signed int v2:9; signed int v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9i_BFs9i { unsigned int v1:9; signed int v2:9; signed int v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9i_BFs9ll { unsigned int v1:9; signed int v2:9; signed int v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9i_BFs9s { unsigned int v1:9; signed int v2:9; signed int v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9i_BFu9i { unsigned int v1:9; signed int v2:9; signed int v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9i_BFu9ll { unsigned int v1:9; signed int v2:9; signed int v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9i_BFu9s { unsigned int v1:9; signed int v2:9; signed int v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9ll { unsigned int v1:9; signed int v2:9; signed long long v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9ll_BFs9i { unsigned int v1:9; signed int v2:9; signed long long v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9ll_BFs9ll { unsigned int v1:9; signed int v2:9; signed long long v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9ll_BFs9s { unsigned int v1:9; signed int v2:9; signed long long v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9ll_BFu9i { unsigned int v1:9; signed int v2:9; signed long long v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9ll_BFu9ll { unsigned int v1:9; signed int v2:9; signed long long v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9ll_BFu9s { unsigned int v1:9; signed int v2:9; signed long long v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9s { unsigned int v1:9; signed int v2:9; signed short v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9s_BFs9i { unsigned int v1:9; signed int v2:9; signed short v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9s_BFs9ll { unsigned int v1:9; signed int v2:9; signed short v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9s_BFs9s { unsigned int v1:9; signed int v2:9; signed short v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9s_BFu9i { unsigned int v1:9; signed int v2:9; signed short v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9s_BFu9ll { unsigned int v1:9; signed int v2:9; signed short v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFs9s_BFu9s { unsigned int v1:9; signed int v2:9; signed short v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9i { unsigned int v1:9; signed int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9i_BFs9i { unsigned int v1:9; signed int v2:9; unsigned int v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9i_BFs9ll { unsigned int v1:9; signed int v2:9; unsigned int v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9i_BFs9s { unsigned int v1:9; signed int v2:9; unsigned int v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9i_BFu9i { unsigned int v1:9; signed int v2:9; unsigned int v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9i_BFu9ll { unsigned int v1:9; signed int v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9i_BFu9s { unsigned int v1:9; signed int v2:9; unsigned int v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9ll { unsigned int v1:9; signed int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9ll_BFs9i { unsigned int v1:9; signed int v2:9; unsigned long long v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9ll_BFs9ll { unsigned int v1:9; signed int v2:9; unsigned long long v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9ll_BFs9s { unsigned int v1:9; signed int v2:9; unsigned long long v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9ll_BFu9i { unsigned int v1:9; signed int v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9ll_BFu9ll { unsigned int v1:9; signed int v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9ll_BFu9s { unsigned int v1:9; signed int v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9s { unsigned int v1:9; signed int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9s_BFs9i { unsigned int v1:9; signed int v2:9; unsigned short v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9s_BFs9ll { unsigned int v1:9; signed int v2:9; unsigned short v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9s_BFs9s { unsigned int v1:9; signed int v2:9; unsigned short v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9s_BFu9i { unsigned int v1:9; signed int v2:9; unsigned short v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9s_BFu9ll { unsigned int v1:9; signed int v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9i_BFu9s_BFu9s { unsigned int v1:9; signed int v2:9; unsigned short v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll { unsigned int v1:9; signed long long v2:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9i { unsigned int v1:9; signed long long v2:9; signed int v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9i_BFs9i { unsigned int v1:9; signed long long v2:9; signed int v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9i_BFs9ll { unsigned int v1:9; signed long long v2:9; signed int v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9i_BFs9s { unsigned int v1:9; signed long long v2:9; signed int v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9i_BFu9i { unsigned int v1:9; signed long long v2:9; signed int v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9i_BFu9ll { unsigned int v1:9; signed long long v2:9; signed int v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9i_BFu9s { unsigned int v1:9; signed long long v2:9; signed int v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9ll { unsigned int v1:9; signed long long v2:9; signed long long v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9ll_BFs9i { unsigned int v1:9; signed long long v2:9; signed long long v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9ll_BFs9ll { unsigned int v1:9; signed long long v2:9; signed long long v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9ll_BFs9s { unsigned int v1:9; signed long long v2:9; signed long long v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9ll_BFu9i { unsigned int v1:9; signed long long v2:9; signed long long v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9ll_BFu9ll { unsigned int v1:9; signed long long v2:9; signed long long v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9ll_BFu9s { unsigned int v1:9; signed long long v2:9; signed long long v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9s { unsigned int v1:9; signed long long v2:9; signed short v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9s_BFs9i { unsigned int v1:9; signed long long v2:9; signed short v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9s_BFs9ll { unsigned int v1:9; signed long long v2:9; signed short v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9s_BFs9s { unsigned int v1:9; signed long long v2:9; signed short v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9s_BFu9i { unsigned int v1:9; signed long long v2:9; signed short v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9s_BFu9ll { unsigned int v1:9; signed long long v2:9; signed short v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFs9s_BFu9s { unsigned int v1:9; signed long long v2:9; signed short v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9i { unsigned int v1:9; signed long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9i_BFs9i { unsigned int v1:9; signed long long v2:9; unsigned int v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9i_BFs9ll { unsigned int v1:9; signed long long v2:9; unsigned int v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9i_BFs9s { unsigned int v1:9; signed long long v2:9; unsigned int v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9i_BFu9i { unsigned int v1:9; signed long long v2:9; unsigned int v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9i_BFu9ll { unsigned int v1:9; signed long long v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9i_BFu9s { unsigned int v1:9; signed long long v2:9; unsigned int v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9ll { unsigned int v1:9; signed long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9ll_BFs9i { unsigned int v1:9; signed long long v2:9; unsigned long long v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9ll_BFs9ll { unsigned int v1:9; signed long long v2:9; unsigned long long v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9ll_BFs9s { unsigned int v1:9; signed long long v2:9; unsigned long long v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9ll_BFu9i { unsigned int v1:9; signed long long v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9ll_BFu9ll { unsigned int v1:9; signed long long v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9ll_BFu9s { unsigned int v1:9; signed long long v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9s { unsigned int v1:9; signed long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9s_BFs9i { unsigned int v1:9; signed long long v2:9; unsigned short v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9s_BFs9ll { unsigned int v1:9; signed long long v2:9; unsigned short v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9s_BFs9s { unsigned int v1:9; signed long long v2:9; unsigned short v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9s_BFu9i { unsigned int v1:9; signed long long v2:9; unsigned short v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9s_BFu9ll { unsigned int v1:9; signed long long v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9ll_BFu9s_BFu9s { unsigned int v1:9; signed long long v2:9; unsigned short v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s { unsigned int v1:9; signed short v2:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9i { unsigned int v1:9; signed short v2:9; signed int v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9i_BFs9i { unsigned int v1:9; signed short v2:9; signed int v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9i_BFs9ll { unsigned int v1:9; signed short v2:9; signed int v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9i_BFs9s { unsigned int v1:9; signed short v2:9; signed int v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9i_BFu9i { unsigned int v1:9; signed short v2:9; signed int v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9i_BFu9ll { unsigned int v1:9; signed short v2:9; signed int v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9i_BFu9s { unsigned int v1:9; signed short v2:9; signed int v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9ll { unsigned int v1:9; signed short v2:9; signed long long v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9ll_BFs9i { unsigned int v1:9; signed short v2:9; signed long long v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9ll_BFs9ll { unsigned int v1:9; signed short v2:9; signed long long v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9ll_BFs9s { unsigned int v1:9; signed short v2:9; signed long long v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9ll_BFu9i { unsigned int v1:9; signed short v2:9; signed long long v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9ll_BFu9ll { unsigned int v1:9; signed short v2:9; signed long long v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9ll_BFu9s { unsigned int v1:9; signed short v2:9; signed long long v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9s { unsigned int v1:9; signed short v2:9; signed short v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9s_BFs9i { unsigned int v1:9; signed short v2:9; signed short v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9s_BFs9ll { unsigned int v1:9; signed short v2:9; signed short v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9s_BFs9s { unsigned int v1:9; signed short v2:9; signed short v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9s_BFu9i { unsigned int v1:9; signed short v2:9; signed short v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9s_BFu9ll { unsigned int v1:9; signed short v2:9; signed short v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFs9s_BFu9s { unsigned int v1:9; signed short v2:9; signed short v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9i { unsigned int v1:9; signed short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9i_BFs9i { unsigned int v1:9; signed short v2:9; unsigned int v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9i_BFs9ll { unsigned int v1:9; signed short v2:9; unsigned int v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9i_BFs9s { unsigned int v1:9; signed short v2:9; unsigned int v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9i_BFu9i { unsigned int v1:9; signed short v2:9; unsigned int v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9i_BFu9ll { unsigned int v1:9; signed short v2:9; unsigned int v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9i_BFu9s { unsigned int v1:9; signed short v2:9; unsigned int v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9ll { unsigned int v1:9; signed short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9ll_BFs9i { unsigned int v1:9; signed short v2:9; unsigned long long v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9ll_BFs9ll { unsigned int v1:9; signed short v2:9; unsigned long long v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9ll_BFs9s { unsigned int v1:9; signed short v2:9; unsigned long long v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9ll_BFu9i { unsigned int v1:9; signed short v2:9; unsigned long long v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9ll_BFu9ll { unsigned int v1:9; signed short v2:9; unsigned long long v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9ll_BFu9s { unsigned int v1:9; signed short v2:9; unsigned long long v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9s { unsigned int v1:9; signed short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9s_BFs9i { unsigned int v1:9; signed short v2:9; unsigned short v3:9; signed int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9s_BFs9ll { unsigned int v1:9; signed short v2:9; unsigned short v3:9; signed long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9s_BFs9s { unsigned int v1:9; signed short v2:9; unsigned short v3:9; signed short v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9s_BFu9i { unsigned int v1:9; signed short v2:9; unsigned short v3:9; unsigned int v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9s_BFu9ll { unsigned int v1:9; signed short v2:9; unsigned short v3:9; unsigned long long v4:9; };
struct __attribute__((packed)) aBFu9i_BFs9s_BFu9s_BFu9s { unsigned int v1:9; signed short v2:9; unsigned short v3:9; unsigned short v4:9; };
struct __attribute__((packed)) aBFu9i_BFu15i { unsigned int v1:9; unsigned int v2:15; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu15i { unsigned int v1:9; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu15ll { unsigned int v1:9; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu15s { unsigned int v1:9; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu16i { unsigned int v1:9; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu16ll { unsigned int v1:9; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu16s { unsigned int v1:9; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu17i { unsigned int v1:9; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu17ll { unsigned int v1:9; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu1c { unsigned int v1:9; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu1i { unsigned int v1:9; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu1ll { unsigned int v1:9; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu1s { unsigned int v1:9; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu31i { unsigned int v1:9; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu31ll { unsigned int v1:9; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu32i { unsigned int v1:9; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu32ll { unsigned int v1:9; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu33 { unsigned int v1:9; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu7c { unsigned int v1:9; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu7i { unsigned int v1:9; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu7ll { unsigned int v1:9; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu7s { unsigned int v1:9; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu8c { unsigned int v1:9; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu8i { unsigned int v1:9; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu8ll { unsigned int v1:9; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu8s { unsigned int v1:9; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu9i { unsigned int v1:9; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu9ll { unsigned int v1:9; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9i_BFu15i_BFu9s { unsigned int v1:9; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9i_BFu15i_C { unsigned int v1:9; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aBFu9i_BFu15i_D { unsigned int v1:9; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aBFu9i_BFu15i_F { unsigned int v1:9; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aBFu9i_BFu15i_I { unsigned int v1:9; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aBFu9i_BFu15i_Ip { unsigned int v1:9; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aBFu9i_BFu15i_L { unsigned int v1:9; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aBFu9i_BFu15i_S { unsigned int v1:9; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aBFu9i_BFu15i_Uc { unsigned int v1:9; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aBFu9i_BFu15i_Ui { unsigned int v1:9; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aBFu9i_BFu15i_Ul { unsigned int v1:9; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aBFu9i_BFu15i_Us { unsigned int v1:9; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aBFu9i_BFu15i_Vp { unsigned int v1:9; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll { unsigned int v1:9; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu15i { unsigned int v1:9; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu15ll { unsigned int v1:9; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu15s { unsigned int v1:9; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu16i { unsigned int v1:9; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu16ll { unsigned int v1:9; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu16s { unsigned int v1:9; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu17i { unsigned int v1:9; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu17ll { unsigned int v1:9; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu1c { unsigned int v1:9; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu1i { unsigned int v1:9; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu1ll { unsigned int v1:9; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu1s { unsigned int v1:9; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu31i { unsigned int v1:9; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu31ll { unsigned int v1:9; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu32i { unsigned int v1:9; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu32ll { unsigned int v1:9; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu33 { unsigned int v1:9; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu7c { unsigned int v1:9; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu7i { unsigned int v1:9; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu7ll { unsigned int v1:9; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu7s { unsigned int v1:9; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu8c { unsigned int v1:9; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu8i { unsigned int v1:9; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu8ll { unsigned int v1:9; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu8s { unsigned int v1:9; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu9i { unsigned int v1:9; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu9ll { unsigned int v1:9; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9i_BFu15ll_BFu9s { unsigned int v1:9; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9i_BFu15ll_C { unsigned int v1:9; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll_D { unsigned int v1:9; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll_F { unsigned int v1:9; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll_I { unsigned int v1:9; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll_Ip { unsigned int v1:9; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll_L { unsigned int v1:9; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll_S { unsigned int v1:9; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll_Uc { unsigned int v1:9; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll_Ui { unsigned int v1:9; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll_Ul { unsigned int v1:9; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll_Us { unsigned int v1:9; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aBFu9i_BFu15ll_Vp { unsigned int v1:9; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aBFu9i_BFu15s { unsigned int v1:9; unsigned short v2:15; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu15i { unsigned int v1:9; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu15ll { unsigned int v1:9; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu15s { unsigned int v1:9; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu16i { unsigned int v1:9; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu16ll { unsigned int v1:9; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu16s { unsigned int v1:9; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu17i { unsigned int v1:9; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu17ll { unsigned int v1:9; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu1c { unsigned int v1:9; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu1i { unsigned int v1:9; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu1ll { unsigned int v1:9; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu1s { unsigned int v1:9; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu31i { unsigned int v1:9; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu31ll { unsigned int v1:9; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu32i { unsigned int v1:9; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu32ll { unsigned int v1:9; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu33 { unsigned int v1:9; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu7c { unsigned int v1:9; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu7i { unsigned int v1:9; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu7ll { unsigned int v1:9; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu7s { unsigned int v1:9; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu8c { unsigned int v1:9; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu8i { unsigned int v1:9; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu8ll { unsigned int v1:9; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu8s { unsigned int v1:9; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu9i { unsigned int v1:9; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu9ll { unsigned int v1:9; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9i_BFu15s_BFu9s { unsigned int v1:9; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9i_BFu15s_C { unsigned int v1:9; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aBFu9i_BFu15s_D { unsigned int v1:9; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aBFu9i_BFu15s_F { unsigned int v1:9; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aBFu9i_BFu15s_I { unsigned int v1:9; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aBFu9i_BFu15s_Ip { unsigned int v1:9; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aBFu9i_BFu15s_L { unsigned int v1:9; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aBFu9i_BFu15s_S { unsigned int v1:9; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aBFu9i_BFu15s_Uc { unsigned int v1:9; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aBFu9i_BFu15s_Ui { unsigned int v1:9; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aBFu9i_BFu15s_Ul { unsigned int v1:9; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aBFu9i_BFu15s_Us { unsigned int v1:9; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aBFu9i_BFu15s_Vp { unsigned int v1:9; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aBFu9i_BFu16i { unsigned int v1:9; unsigned int v2:16; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu15i { unsigned int v1:9; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu15ll { unsigned int v1:9; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu15s { unsigned int v1:9; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu16i { unsigned int v1:9; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu16ll { unsigned int v1:9; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu16s { unsigned int v1:9; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu17i { unsigned int v1:9; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu17ll { unsigned int v1:9; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu1c { unsigned int v1:9; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu1i { unsigned int v1:9; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu1ll { unsigned int v1:9; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu1s { unsigned int v1:9; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu31i { unsigned int v1:9; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu31ll { unsigned int v1:9; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu32i { unsigned int v1:9; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu32ll { unsigned int v1:9; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu33 { unsigned int v1:9; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu7c { unsigned int v1:9; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu7i { unsigned int v1:9; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu7ll { unsigned int v1:9; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu7s { unsigned int v1:9; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu8c { unsigned int v1:9; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu8i { unsigned int v1:9; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu8ll { unsigned int v1:9; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu8s { unsigned int v1:9; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu9i { unsigned int v1:9; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu9ll { unsigned int v1:9; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9i_BFu16i_BFu9s { unsigned int v1:9; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9i_BFu16i_C { unsigned int v1:9; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aBFu9i_BFu16i_D { unsigned int v1:9; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aBFu9i_BFu16i_F { unsigned int v1:9; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aBFu9i_BFu16i_I { unsigned int v1:9; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aBFu9i_BFu16i_Ip { unsigned int v1:9; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aBFu9i_BFu16i_L { unsigned int v1:9; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aBFu9i_BFu16i_S { unsigned int v1:9; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aBFu9i_BFu16i_Uc { unsigned int v1:9; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aBFu9i_BFu16i_Ui { unsigned int v1:9; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aBFu9i_BFu16i_Ul { unsigned int v1:9; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aBFu9i_BFu16i_Us { unsigned int v1:9; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aBFu9i_BFu16i_Vp { unsigned int v1:9; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll { unsigned int v1:9; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu15i { unsigned int v1:9; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu15ll { unsigned int v1:9; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu15s { unsigned int v1:9; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu16i { unsigned int v1:9; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu16ll { unsigned int v1:9; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu16s { unsigned int v1:9; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu17i { unsigned int v1:9; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu17ll { unsigned int v1:9; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu1c { unsigned int v1:9; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu1i { unsigned int v1:9; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu1ll { unsigned int v1:9; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu1s { unsigned int v1:9; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu31i { unsigned int v1:9; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu31ll { unsigned int v1:9; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu32i { unsigned int v1:9; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu32ll { unsigned int v1:9; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu33 { unsigned int v1:9; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu7c { unsigned int v1:9; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu7i { unsigned int v1:9; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu7ll { unsigned int v1:9; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu7s { unsigned int v1:9; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu8c { unsigned int v1:9; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu8i { unsigned int v1:9; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu8ll { unsigned int v1:9; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu8s { unsigned int v1:9; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu9i { unsigned int v1:9; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu9ll { unsigned int v1:9; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu9i_BFu16ll_BFu9s { unsigned int v1:9; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aBFu9i_BFu16ll_C { unsigned int v1:9; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll_D { unsigned int v1:9; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll_F { unsigned int v1:9; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll_I { unsigned int v1:9; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll_Ip { unsigned int v1:9; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll_L { unsigned int v1:9; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll_S { unsigned int v1:9; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll_Uc { unsigned int v1:9; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll_Ui { unsigned int v1:9; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll_Ul { unsigned int v1:9; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll_Us { unsigned int v1:9; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aBFu9i_BFu16ll_Vp { unsigned int v1:9; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aBFu9i_BFu16s { unsigned int v1:9; unsigned short v2:16; };
struct __attribute__((packed)) aBFu9i_BFu16s_BFu15i { unsigned int v1:9; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aBFu9i_BFu16s_BFu15ll { unsigned int v1:9; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu9i_BFu16s_BFu15s { unsigned int v1:9; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aBFu9i_BFu16s_BFu16i { unsigned int v1:9; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aBFu9i_BFu16s_BFu16ll { unsigned int v1:9; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu9i_BFu16s_BFu16s { unsigned int v1:9; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aBFu9i_BFu16s_BFu17i { unsigned int v1:9; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aBFu9i_BFu16s_BFu17ll { unsigned int v1:9; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu9i_BFu16s_BFu1c { unsigned int v1:9; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aBFu9i_BFu16s_BFu1i { unsigned int v1:9; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aBFu9i_BFu16s_BFu1ll { unsigned int v1:9; unsigned short v2:16; unsigned long long v3:1; };


static void Test_aBFu8ll_D_BFu15s()
{
  {
    init_simple_test("aBFu8ll_D_BFu15s");
    static STRUCT_IF_C aBFu8ll_D_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_D_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aBFu8ll_D_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aBFu8ll_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu15s, aBFu8ll_D_BFu15s)
//============================================================================



static void Test_aBFu8ll_D_BFu16i()
{
  {
    init_simple_test("aBFu8ll_D_BFu16i");
    static STRUCT_IF_C aBFu8ll_D_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_D_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aBFu8ll_D_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aBFu8ll_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu16i, aBFu8ll_D_BFu16i)
//============================================================================



static void Test_aBFu8ll_D_BFu16ll()
{
  {
    init_simple_test("aBFu8ll_D_BFu16ll");
    static STRUCT_IF_C aBFu8ll_D_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_D_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aBFu8ll_D_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aBFu8ll_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu16ll, aBFu8ll_D_BFu16ll)
//============================================================================



static void Test_aBFu8ll_D_BFu16s()
{
  {
    init_simple_test("aBFu8ll_D_BFu16s");
    static STRUCT_IF_C aBFu8ll_D_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_D_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aBFu8ll_D_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aBFu8ll_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu16s, aBFu8ll_D_BFu16s)
//============================================================================



static void Test_aBFu8ll_D_BFu17i()
{
  {
    init_simple_test("aBFu8ll_D_BFu17i");
    static STRUCT_IF_C aBFu8ll_D_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aBFu8ll_D_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aBFu8ll_D_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aBFu8ll_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu17i, aBFu8ll_D_BFu17i)
//============================================================================



static void Test_aBFu8ll_D_BFu17ll()
{
  {
    init_simple_test("aBFu8ll_D_BFu17ll");
    static STRUCT_IF_C aBFu8ll_D_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aBFu8ll_D_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aBFu8ll_D_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aBFu8ll_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu17ll, aBFu8ll_D_BFu17ll)
//============================================================================



static void Test_aBFu8ll_D_BFu1c()
{
  {
    init_simple_test("aBFu8ll_D_BFu1c");
    static STRUCT_IF_C aBFu8ll_D_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aBFu8ll_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu1c, aBFu8ll_D_BFu1c)
//============================================================================



static void Test_aBFu8ll_D_BFu1i()
{
  {
    init_simple_test("aBFu8ll_D_BFu1i");
    static STRUCT_IF_C aBFu8ll_D_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aBFu8ll_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu1i, aBFu8ll_D_BFu1i)
//============================================================================



static void Test_aBFu8ll_D_BFu1ll()
{
  {
    init_simple_test("aBFu8ll_D_BFu1ll");
    static STRUCT_IF_C aBFu8ll_D_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aBFu8ll_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu1ll, aBFu8ll_D_BFu1ll)
//============================================================================



static void Test_aBFu8ll_D_BFu1s()
{
  {
    init_simple_test("aBFu8ll_D_BFu1s");
    static STRUCT_IF_C aBFu8ll_D_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aBFu8ll_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu1s, aBFu8ll_D_BFu1s)
//============================================================================



static void Test_aBFu8ll_D_BFu31i()
{
  {
    init_simple_test("aBFu8ll_D_BFu31i");
    static STRUCT_IF_C aBFu8ll_D_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_D_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aBFu8ll_D_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aBFu8ll_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu31i, aBFu8ll_D_BFu31i)
//============================================================================



static void Test_aBFu8ll_D_BFu31ll()
{
  {
    init_simple_test("aBFu8ll_D_BFu31ll");
    static STRUCT_IF_C aBFu8ll_D_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_D_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aBFu8ll_D_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aBFu8ll_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu31ll, aBFu8ll_D_BFu31ll)
//============================================================================



static void Test_aBFu8ll_D_BFu32i()
{
  {
    init_simple_test("aBFu8ll_D_BFu32i");
    static STRUCT_IF_C aBFu8ll_D_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_D_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aBFu8ll_D_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aBFu8ll_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu32i, aBFu8ll_D_BFu32i)
//============================================================================



static void Test_aBFu8ll_D_BFu32ll()
{
  {
    init_simple_test("aBFu8ll_D_BFu32ll");
    static STRUCT_IF_C aBFu8ll_D_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_D_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aBFu8ll_D_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aBFu8ll_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu32ll, aBFu8ll_D_BFu32ll)
//============================================================================



static void Test_aBFu8ll_D_BFu33()
{
  {
    init_simple_test("aBFu8ll_D_BFu33");
    static STRUCT_IF_C aBFu8ll_D_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aBFu8ll_D_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aBFu8ll_D_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aBFu8ll_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu33, aBFu8ll_D_BFu33)
//============================================================================



static void Test_aBFu8ll_D_BFu7c()
{
  {
    init_simple_test("aBFu8ll_D_BFu7c");
    static STRUCT_IF_C aBFu8ll_D_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aBFu8ll_D_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aBFu8ll_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu7c, aBFu8ll_D_BFu7c)
//============================================================================



static void Test_aBFu8ll_D_BFu7i()
{
  {
    init_simple_test("aBFu8ll_D_BFu7i");
    static STRUCT_IF_C aBFu8ll_D_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aBFu8ll_D_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aBFu8ll_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu7i, aBFu8ll_D_BFu7i)
//============================================================================



static void Test_aBFu8ll_D_BFu7ll()
{
  {
    init_simple_test("aBFu8ll_D_BFu7ll");
    static STRUCT_IF_C aBFu8ll_D_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aBFu8ll_D_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aBFu8ll_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu7ll, aBFu8ll_D_BFu7ll)
//============================================================================



static void Test_aBFu8ll_D_BFu7s()
{
  {
    init_simple_test("aBFu8ll_D_BFu7s");
    static STRUCT_IF_C aBFu8ll_D_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aBFu8ll_D_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aBFu8ll_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu7s, aBFu8ll_D_BFu7s)
//============================================================================



static void Test_aBFu8ll_D_BFu8c()
{
  {
    init_simple_test("aBFu8ll_D_BFu8c");
    static STRUCT_IF_C aBFu8ll_D_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aBFu8ll_D_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu8c, aBFu8ll_D_BFu8c)
//============================================================================



static void Test_aBFu8ll_D_BFu8i()
{
  {
    init_simple_test("aBFu8ll_D_BFu8i");
    static STRUCT_IF_C aBFu8ll_D_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aBFu8ll_D_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu8i, aBFu8ll_D_BFu8i)
//============================================================================



static void Test_aBFu8ll_D_BFu8ll()
{
  {
    init_simple_test("aBFu8ll_D_BFu8ll");
    static STRUCT_IF_C aBFu8ll_D_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aBFu8ll_D_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu8ll, aBFu8ll_D_BFu8ll)
//============================================================================



static void Test_aBFu8ll_D_BFu8s()
{
  {
    init_simple_test("aBFu8ll_D_BFu8s");
    static STRUCT_IF_C aBFu8ll_D_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aBFu8ll_D_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu8s, aBFu8ll_D_BFu8s)
//============================================================================



static void Test_aBFu8ll_D_BFu9i()
{
  {
    init_simple_test("aBFu8ll_D_BFu9i");
    static STRUCT_IF_C aBFu8ll_D_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_D_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aBFu8ll_D_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aBFu8ll_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu9i, aBFu8ll_D_BFu9i)
//============================================================================



static void Test_aBFu8ll_D_BFu9ll()
{
  {
    init_simple_test("aBFu8ll_D_BFu9ll");
    static STRUCT_IF_C aBFu8ll_D_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_D_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aBFu8ll_D_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aBFu8ll_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu9ll, aBFu8ll_D_BFu9ll)
//============================================================================



static void Test_aBFu8ll_D_BFu9s()
{
  {
    init_simple_test("aBFu8ll_D_BFu9s");
    static STRUCT_IF_C aBFu8ll_D_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_D_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aBFu8ll_D_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aBFu8ll_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_BFu9s, aBFu8ll_D_BFu9s)
//============================================================================



static void Test_aBFu8ll_D_C()
{
  {
    init_simple_test("aBFu8ll_D_C");
    static STRUCT_IF_C aBFu8ll_D_C lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_C");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_C.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_C, aBFu8ll_D_C)
//============================================================================



static void Test_aBFu8ll_D_D()
{
  {
    init_simple_test("aBFu8ll_D_D");
    static STRUCT_IF_C aBFu8ll_D_D lv;
    check2(sizeof(lv), 17, "sizeof(aBFu8ll_D_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_D");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_D.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_D, aBFu8ll_D_D)
//============================================================================



static void Test_aBFu8ll_D_F()
{
  {
    init_simple_test("aBFu8ll_D_F");
    static STRUCT_IF_C aBFu8ll_D_F lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_D_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_F");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_F.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_F, aBFu8ll_D_F)
//============================================================================



static void Test_aBFu8ll_D_I()
{
  {
    init_simple_test("aBFu8ll_D_I");
    static STRUCT_IF_C aBFu8ll_D_I lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_D_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_I");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_I.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_I, aBFu8ll_D_I)
//============================================================================



static void Test_aBFu8ll_D_Ip()
{
  {
    init_simple_test("aBFu8ll_D_Ip");
    static STRUCT_IF_C aBFu8ll_D_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aBFu8ll_D_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_Ip");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_Ip.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_Ip, aBFu8ll_D_Ip)
//============================================================================



static void Test_aBFu8ll_D_L()
{
  {
    init_simple_test("aBFu8ll_D_L");
    static STRUCT_IF_C aBFu8ll_D_L lv;
    check2(sizeof(lv), 17, "sizeof(aBFu8ll_D_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_L");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_L.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_L, aBFu8ll_D_L)
//============================================================================



static void Test_aBFu8ll_D_S()
{
  {
    init_simple_test("aBFu8ll_D_S");
    static STRUCT_IF_C aBFu8ll_D_S lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_D_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_S");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_S.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_S, aBFu8ll_D_S)
//============================================================================



static void Test_aBFu8ll_D_Uc()
{
  {
    init_simple_test("aBFu8ll_D_Uc");
    static STRUCT_IF_C aBFu8ll_D_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_D_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_Uc");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_Uc.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_Uc, aBFu8ll_D_Uc)
//============================================================================



static void Test_aBFu8ll_D_Ui()
{
  {
    init_simple_test("aBFu8ll_D_Ui");
    static STRUCT_IF_C aBFu8ll_D_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_D_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_Ui");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_Ui.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_Ui, aBFu8ll_D_Ui)
//============================================================================



static void Test_aBFu8ll_D_Ul()
{
  {
    init_simple_test("aBFu8ll_D_Ul");
    static STRUCT_IF_C aBFu8ll_D_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aBFu8ll_D_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_Ul");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_Ul.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_Ul, aBFu8ll_D_Ul)
//============================================================================



static void Test_aBFu8ll_D_Us()
{
  {
    init_simple_test("aBFu8ll_D_Us");
    static STRUCT_IF_C aBFu8ll_D_Us lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_D_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_Us");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_Us.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_Us, aBFu8ll_D_Us)
//============================================================================



static void Test_aBFu8ll_D_Vp()
{
  {
    init_simple_test("aBFu8ll_D_Vp");
    static STRUCT_IF_C aBFu8ll_D_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aBFu8ll_D_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_D_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_D_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_D_Vp");
    check_field_offset(lv, v2, 1, "aBFu8ll_D_Vp.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_D_Vp, aBFu8ll_D_Vp)
//============================================================================



static void Test_aBFu8ll_F()
{
  {
    init_simple_test("aBFu8ll_F");
    static STRUCT_IF_C aBFu8ll_F lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F");
    check_field_offset(lv, v2, 1, "aBFu8ll_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F, aBFu8ll_F)
//============================================================================



static void Test_aBFu8ll_F_BFu15i()
{
  {
    init_simple_test("aBFu8ll_F_BFu15i");
    static STRUCT_IF_C aBFu8ll_F_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_F_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aBFu8ll_F_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aBFu8ll_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu15i, aBFu8ll_F_BFu15i)
//============================================================================



static void Test_aBFu8ll_F_BFu15ll()
{
  {
    init_simple_test("aBFu8ll_F_BFu15ll");
    static STRUCT_IF_C aBFu8ll_F_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_F_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aBFu8ll_F_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aBFu8ll_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu15ll, aBFu8ll_F_BFu15ll)
//============================================================================



static void Test_aBFu8ll_F_BFu15s()
{
  {
    init_simple_test("aBFu8ll_F_BFu15s");
    static STRUCT_IF_C aBFu8ll_F_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_F_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aBFu8ll_F_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aBFu8ll_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu15s, aBFu8ll_F_BFu15s)
//============================================================================



static void Test_aBFu8ll_F_BFu16i()
{
  {
    init_simple_test("aBFu8ll_F_BFu16i");
    static STRUCT_IF_C aBFu8ll_F_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_F_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aBFu8ll_F_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aBFu8ll_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu16i, aBFu8ll_F_BFu16i)
//============================================================================



static void Test_aBFu8ll_F_BFu16ll()
{
  {
    init_simple_test("aBFu8ll_F_BFu16ll");
    static STRUCT_IF_C aBFu8ll_F_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_F_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aBFu8ll_F_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aBFu8ll_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu16ll, aBFu8ll_F_BFu16ll)
//============================================================================



static void Test_aBFu8ll_F_BFu16s()
{
  {
    init_simple_test("aBFu8ll_F_BFu16s");
    static STRUCT_IF_C aBFu8ll_F_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_F_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aBFu8ll_F_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aBFu8ll_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu16s, aBFu8ll_F_BFu16s)
//============================================================================



static void Test_aBFu8ll_F_BFu17i()
{
  {
    init_simple_test("aBFu8ll_F_BFu17i");
    static STRUCT_IF_C aBFu8ll_F_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu8ll_F_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aBFu8ll_F_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aBFu8ll_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu17i, aBFu8ll_F_BFu17i)
//============================================================================



static void Test_aBFu8ll_F_BFu17ll()
{
  {
    init_simple_test("aBFu8ll_F_BFu17ll");
    static STRUCT_IF_C aBFu8ll_F_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu8ll_F_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aBFu8ll_F_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aBFu8ll_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu17ll, aBFu8ll_F_BFu17ll)
//============================================================================



static void Test_aBFu8ll_F_BFu1c()
{
  {
    init_simple_test("aBFu8ll_F_BFu1c");
    static STRUCT_IF_C aBFu8ll_F_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aBFu8ll_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu1c, aBFu8ll_F_BFu1c)
//============================================================================



static void Test_aBFu8ll_F_BFu1i()
{
  {
    init_simple_test("aBFu8ll_F_BFu1i");
    static STRUCT_IF_C aBFu8ll_F_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aBFu8ll_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu1i, aBFu8ll_F_BFu1i)
//============================================================================



static void Test_aBFu8ll_F_BFu1ll()
{
  {
    init_simple_test("aBFu8ll_F_BFu1ll");
    static STRUCT_IF_C aBFu8ll_F_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aBFu8ll_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu1ll, aBFu8ll_F_BFu1ll)
//============================================================================



static void Test_aBFu8ll_F_BFu1s()
{
  {
    init_simple_test("aBFu8ll_F_BFu1s");
    static STRUCT_IF_C aBFu8ll_F_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aBFu8ll_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu1s, aBFu8ll_F_BFu1s)
//============================================================================



static void Test_aBFu8ll_F_BFu31i()
{
  {
    init_simple_test("aBFu8ll_F_BFu31i");
    static STRUCT_IF_C aBFu8ll_F_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_F_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aBFu8ll_F_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aBFu8ll_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu31i, aBFu8ll_F_BFu31i)
//============================================================================



static void Test_aBFu8ll_F_BFu31ll()
{
  {
    init_simple_test("aBFu8ll_F_BFu31ll");
    static STRUCT_IF_C aBFu8ll_F_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_F_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aBFu8ll_F_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aBFu8ll_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu31ll, aBFu8ll_F_BFu31ll)
//============================================================================



static void Test_aBFu8ll_F_BFu32i()
{
  {
    init_simple_test("aBFu8ll_F_BFu32i");
    static STRUCT_IF_C aBFu8ll_F_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_F_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aBFu8ll_F_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aBFu8ll_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu32i, aBFu8ll_F_BFu32i)
//============================================================================



static void Test_aBFu8ll_F_BFu32ll()
{
  {
    init_simple_test("aBFu8ll_F_BFu32ll");
    static STRUCT_IF_C aBFu8ll_F_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_F_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aBFu8ll_F_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aBFu8ll_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu32ll, aBFu8ll_F_BFu32ll)
//============================================================================



static void Test_aBFu8ll_F_BFu33()
{
  {
    init_simple_test("aBFu8ll_F_BFu33");
    static STRUCT_IF_C aBFu8ll_F_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_F_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aBFu8ll_F_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aBFu8ll_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu33, aBFu8ll_F_BFu33)
//============================================================================



static void Test_aBFu8ll_F_BFu7c()
{
  {
    init_simple_test("aBFu8ll_F_BFu7c");
    static STRUCT_IF_C aBFu8ll_F_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aBFu8ll_F_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aBFu8ll_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu7c, aBFu8ll_F_BFu7c)
//============================================================================



static void Test_aBFu8ll_F_BFu7i()
{
  {
    init_simple_test("aBFu8ll_F_BFu7i");
    static STRUCT_IF_C aBFu8ll_F_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aBFu8ll_F_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aBFu8ll_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu7i, aBFu8ll_F_BFu7i)
//============================================================================



static void Test_aBFu8ll_F_BFu7ll()
{
  {
    init_simple_test("aBFu8ll_F_BFu7ll");
    static STRUCT_IF_C aBFu8ll_F_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aBFu8ll_F_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aBFu8ll_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu7ll, aBFu8ll_F_BFu7ll)
//============================================================================



static void Test_aBFu8ll_F_BFu7s()
{
  {
    init_simple_test("aBFu8ll_F_BFu7s");
    static STRUCT_IF_C aBFu8ll_F_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aBFu8ll_F_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aBFu8ll_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu7s, aBFu8ll_F_BFu7s)
//============================================================================



static void Test_aBFu8ll_F_BFu8c()
{
  {
    init_simple_test("aBFu8ll_F_BFu8c");
    static STRUCT_IF_C aBFu8ll_F_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aBFu8ll_F_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu8c, aBFu8ll_F_BFu8c)
//============================================================================



static void Test_aBFu8ll_F_BFu8i()
{
  {
    init_simple_test("aBFu8ll_F_BFu8i");
    static STRUCT_IF_C aBFu8ll_F_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aBFu8ll_F_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu8i, aBFu8ll_F_BFu8i)
//============================================================================



static void Test_aBFu8ll_F_BFu8ll()
{
  {
    init_simple_test("aBFu8ll_F_BFu8ll");
    static STRUCT_IF_C aBFu8ll_F_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aBFu8ll_F_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu8ll, aBFu8ll_F_BFu8ll)
//============================================================================



static void Test_aBFu8ll_F_BFu8s()
{
  {
    init_simple_test("aBFu8ll_F_BFu8s");
    static STRUCT_IF_C aBFu8ll_F_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aBFu8ll_F_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu8s, aBFu8ll_F_BFu8s)
//============================================================================



static void Test_aBFu8ll_F_BFu9i()
{
  {
    init_simple_test("aBFu8ll_F_BFu9i");
    static STRUCT_IF_C aBFu8ll_F_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_F_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aBFu8ll_F_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aBFu8ll_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu9i, aBFu8ll_F_BFu9i)
//============================================================================



static void Test_aBFu8ll_F_BFu9ll()
{
  {
    init_simple_test("aBFu8ll_F_BFu9ll");
    static STRUCT_IF_C aBFu8ll_F_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_F_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aBFu8ll_F_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aBFu8ll_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu9ll, aBFu8ll_F_BFu9ll)
//============================================================================



static void Test_aBFu8ll_F_BFu9s()
{
  {
    init_simple_test("aBFu8ll_F_BFu9s");
    static STRUCT_IF_C aBFu8ll_F_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_F_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aBFu8ll_F_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aBFu8ll_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_BFu9s, aBFu8ll_F_BFu9s)
//============================================================================



static void Test_aBFu8ll_F_C()
{
  {
    init_simple_test("aBFu8ll_F_C");
    static STRUCT_IF_C aBFu8ll_F_C lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_C");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_C.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_C, aBFu8ll_F_C)
//============================================================================



static void Test_aBFu8ll_F_D()
{
  {
    init_simple_test("aBFu8ll_F_D");
    static STRUCT_IF_C aBFu8ll_F_D lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_F_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_D");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_D.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_D, aBFu8ll_F_D)
//============================================================================



static void Test_aBFu8ll_F_F()
{
  {
    init_simple_test("aBFu8ll_F_F");
    static STRUCT_IF_C aBFu8ll_F_F lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_F_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_F");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_F.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_F, aBFu8ll_F_F)
//============================================================================



static void Test_aBFu8ll_F_I()
{
  {
    init_simple_test("aBFu8ll_F_I");
    static STRUCT_IF_C aBFu8ll_F_I lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_F_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_I");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_I.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_I, aBFu8ll_F_I)
//============================================================================



static void Test_aBFu8ll_F_Ip()
{
  {
    init_simple_test("aBFu8ll_F_Ip");
    static STRUCT_IF_C aBFu8ll_F_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_F_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_Ip");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_Ip.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_Ip, aBFu8ll_F_Ip)
//============================================================================



static void Test_aBFu8ll_F_L()
{
  {
    init_simple_test("aBFu8ll_F_L");
    static STRUCT_IF_C aBFu8ll_F_L lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_F_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_L");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_L.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_L, aBFu8ll_F_L)
//============================================================================



static void Test_aBFu8ll_F_S()
{
  {
    init_simple_test("aBFu8ll_F_S");
    static STRUCT_IF_C aBFu8ll_F_S lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_F_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_S");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_S.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_S, aBFu8ll_F_S)
//============================================================================



static void Test_aBFu8ll_F_Uc()
{
  {
    init_simple_test("aBFu8ll_F_Uc");
    static STRUCT_IF_C aBFu8ll_F_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_F_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_Uc");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_Uc.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_Uc, aBFu8ll_F_Uc)
//============================================================================



static void Test_aBFu8ll_F_Ui()
{
  {
    init_simple_test("aBFu8ll_F_Ui");
    static STRUCT_IF_C aBFu8ll_F_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_F_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_Ui");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_Ui.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_Ui, aBFu8ll_F_Ui)
//============================================================================



static void Test_aBFu8ll_F_Ul()
{
  {
    init_simple_test("aBFu8ll_F_Ul");
    static STRUCT_IF_C aBFu8ll_F_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_F_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_Ul");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_Ul.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_Ul, aBFu8ll_F_Ul)
//============================================================================



static void Test_aBFu8ll_F_Us()
{
  {
    init_simple_test("aBFu8ll_F_Us");
    static STRUCT_IF_C aBFu8ll_F_Us lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_F_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_Us");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_Us.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_Us, aBFu8ll_F_Us)
//============================================================================



static void Test_aBFu8ll_F_Vp()
{
  {
    init_simple_test("aBFu8ll_F_Vp");
    static STRUCT_IF_C aBFu8ll_F_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_F_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_F_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_F_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_F_Vp");
    check_field_offset(lv, v2, 1, "aBFu8ll_F_Vp.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_F_Vp, aBFu8ll_F_Vp)
//============================================================================



static void Test_aBFu8ll_I()
{
  {
    init_simple_test("aBFu8ll_I");
    static STRUCT_IF_C aBFu8ll_I lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I");
    check_field_offset(lv, v2, 1, "aBFu8ll_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I, aBFu8ll_I)
//============================================================================



static void Test_aBFu8ll_I_BFu15i()
{
  {
    init_simple_test("aBFu8ll_I_BFu15i");
    static STRUCT_IF_C aBFu8ll_I_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_I_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aBFu8ll_I_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aBFu8ll_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu15i, aBFu8ll_I_BFu15i)
//============================================================================



static void Test_aBFu8ll_I_BFu15ll()
{
  {
    init_simple_test("aBFu8ll_I_BFu15ll");
    static STRUCT_IF_C aBFu8ll_I_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_I_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aBFu8ll_I_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aBFu8ll_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu15ll, aBFu8ll_I_BFu15ll)
//============================================================================



static void Test_aBFu8ll_I_BFu15s()
{
  {
    init_simple_test("aBFu8ll_I_BFu15s");
    static STRUCT_IF_C aBFu8ll_I_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_I_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aBFu8ll_I_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aBFu8ll_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu15s, aBFu8ll_I_BFu15s)
//============================================================================



static void Test_aBFu8ll_I_BFu16i()
{
  {
    init_simple_test("aBFu8ll_I_BFu16i");
    static STRUCT_IF_C aBFu8ll_I_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_I_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aBFu8ll_I_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aBFu8ll_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu16i, aBFu8ll_I_BFu16i)
//============================================================================



static void Test_aBFu8ll_I_BFu16ll()
{
  {
    init_simple_test("aBFu8ll_I_BFu16ll");
    static STRUCT_IF_C aBFu8ll_I_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_I_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aBFu8ll_I_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aBFu8ll_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu16ll, aBFu8ll_I_BFu16ll)
//============================================================================



static void Test_aBFu8ll_I_BFu16s()
{
  {
    init_simple_test("aBFu8ll_I_BFu16s");
    static STRUCT_IF_C aBFu8ll_I_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_I_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aBFu8ll_I_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aBFu8ll_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu16s, aBFu8ll_I_BFu16s)
//============================================================================



static void Test_aBFu8ll_I_BFu17i()
{
  {
    init_simple_test("aBFu8ll_I_BFu17i");
    static STRUCT_IF_C aBFu8ll_I_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu8ll_I_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aBFu8ll_I_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aBFu8ll_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu17i, aBFu8ll_I_BFu17i)
//============================================================================



static void Test_aBFu8ll_I_BFu17ll()
{
  {
    init_simple_test("aBFu8ll_I_BFu17ll");
    static STRUCT_IF_C aBFu8ll_I_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu8ll_I_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aBFu8ll_I_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aBFu8ll_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu17ll, aBFu8ll_I_BFu17ll)
//============================================================================



static void Test_aBFu8ll_I_BFu1c()
{
  {
    init_simple_test("aBFu8ll_I_BFu1c");
    static STRUCT_IF_C aBFu8ll_I_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aBFu8ll_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu1c, aBFu8ll_I_BFu1c)
//============================================================================



static void Test_aBFu8ll_I_BFu1i()
{
  {
    init_simple_test("aBFu8ll_I_BFu1i");
    static STRUCT_IF_C aBFu8ll_I_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aBFu8ll_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu1i, aBFu8ll_I_BFu1i)
//============================================================================



static void Test_aBFu8ll_I_BFu1ll()
{
  {
    init_simple_test("aBFu8ll_I_BFu1ll");
    static STRUCT_IF_C aBFu8ll_I_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aBFu8ll_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu1ll, aBFu8ll_I_BFu1ll)
//============================================================================



static void Test_aBFu8ll_I_BFu1s()
{
  {
    init_simple_test("aBFu8ll_I_BFu1s");
    static STRUCT_IF_C aBFu8ll_I_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aBFu8ll_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu1s, aBFu8ll_I_BFu1s)
//============================================================================



static void Test_aBFu8ll_I_BFu31i()
{
  {
    init_simple_test("aBFu8ll_I_BFu31i");
    static STRUCT_IF_C aBFu8ll_I_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_I_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aBFu8ll_I_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aBFu8ll_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu31i, aBFu8ll_I_BFu31i)
//============================================================================



static void Test_aBFu8ll_I_BFu31ll()
{
  {
    init_simple_test("aBFu8ll_I_BFu31ll");
    static STRUCT_IF_C aBFu8ll_I_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_I_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aBFu8ll_I_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aBFu8ll_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu31ll, aBFu8ll_I_BFu31ll)
//============================================================================



static void Test_aBFu8ll_I_BFu32i()
{
  {
    init_simple_test("aBFu8ll_I_BFu32i");
    static STRUCT_IF_C aBFu8ll_I_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_I_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aBFu8ll_I_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aBFu8ll_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu32i, aBFu8ll_I_BFu32i)
//============================================================================



static void Test_aBFu8ll_I_BFu32ll()
{
  {
    init_simple_test("aBFu8ll_I_BFu32ll");
    static STRUCT_IF_C aBFu8ll_I_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_I_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aBFu8ll_I_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aBFu8ll_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu32ll, aBFu8ll_I_BFu32ll)
//============================================================================



static void Test_aBFu8ll_I_BFu33()
{
  {
    init_simple_test("aBFu8ll_I_BFu33");
    static STRUCT_IF_C aBFu8ll_I_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_I_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aBFu8ll_I_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aBFu8ll_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu33, aBFu8ll_I_BFu33)
//============================================================================



static void Test_aBFu8ll_I_BFu7c()
{
  {
    init_simple_test("aBFu8ll_I_BFu7c");
    static STRUCT_IF_C aBFu8ll_I_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aBFu8ll_I_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aBFu8ll_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu7c, aBFu8ll_I_BFu7c)
//============================================================================



static void Test_aBFu8ll_I_BFu7i()
{
  {
    init_simple_test("aBFu8ll_I_BFu7i");
    static STRUCT_IF_C aBFu8ll_I_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aBFu8ll_I_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aBFu8ll_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu7i, aBFu8ll_I_BFu7i)
//============================================================================



static void Test_aBFu8ll_I_BFu7ll()
{
  {
    init_simple_test("aBFu8ll_I_BFu7ll");
    static STRUCT_IF_C aBFu8ll_I_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aBFu8ll_I_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aBFu8ll_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu7ll, aBFu8ll_I_BFu7ll)
//============================================================================



static void Test_aBFu8ll_I_BFu7s()
{
  {
    init_simple_test("aBFu8ll_I_BFu7s");
    static STRUCT_IF_C aBFu8ll_I_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aBFu8ll_I_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aBFu8ll_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu7s, aBFu8ll_I_BFu7s)
//============================================================================



static void Test_aBFu8ll_I_BFu8c()
{
  {
    init_simple_test("aBFu8ll_I_BFu8c");
    static STRUCT_IF_C aBFu8ll_I_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aBFu8ll_I_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu8c, aBFu8ll_I_BFu8c)
//============================================================================



static void Test_aBFu8ll_I_BFu8i()
{
  {
    init_simple_test("aBFu8ll_I_BFu8i");
    static STRUCT_IF_C aBFu8ll_I_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aBFu8ll_I_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu8i, aBFu8ll_I_BFu8i)
//============================================================================



static void Test_aBFu8ll_I_BFu8ll()
{
  {
    init_simple_test("aBFu8ll_I_BFu8ll");
    static STRUCT_IF_C aBFu8ll_I_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aBFu8ll_I_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu8ll, aBFu8ll_I_BFu8ll)
//============================================================================



static void Test_aBFu8ll_I_BFu8s()
{
  {
    init_simple_test("aBFu8ll_I_BFu8s");
    static STRUCT_IF_C aBFu8ll_I_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aBFu8ll_I_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu8s, aBFu8ll_I_BFu8s)
//============================================================================



static void Test_aBFu8ll_I_BFu9i()
{
  {
    init_simple_test("aBFu8ll_I_BFu9i");
    static STRUCT_IF_C aBFu8ll_I_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_I_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aBFu8ll_I_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aBFu8ll_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu9i, aBFu8ll_I_BFu9i)
//============================================================================



static void Test_aBFu8ll_I_BFu9ll()
{
  {
    init_simple_test("aBFu8ll_I_BFu9ll");
    static STRUCT_IF_C aBFu8ll_I_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_I_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aBFu8ll_I_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aBFu8ll_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu9ll, aBFu8ll_I_BFu9ll)
//============================================================================



static void Test_aBFu8ll_I_BFu9s()
{
  {
    init_simple_test("aBFu8ll_I_BFu9s");
    static STRUCT_IF_C aBFu8ll_I_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_I_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aBFu8ll_I_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aBFu8ll_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_BFu9s, aBFu8ll_I_BFu9s)
//============================================================================



static void Test_aBFu8ll_I_C()
{
  {
    init_simple_test("aBFu8ll_I_C");
    static STRUCT_IF_C aBFu8ll_I_C lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_C");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_C.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_C, aBFu8ll_I_C)
//============================================================================



static void Test_aBFu8ll_I_D()
{
  {
    init_simple_test("aBFu8ll_I_D");
    static STRUCT_IF_C aBFu8ll_I_D lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_I_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_D");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_D.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_D, aBFu8ll_I_D)
//============================================================================



static void Test_aBFu8ll_I_F()
{
  {
    init_simple_test("aBFu8ll_I_F");
    static STRUCT_IF_C aBFu8ll_I_F lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_I_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_F");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_F.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_F, aBFu8ll_I_F)
//============================================================================



static void Test_aBFu8ll_I_I()
{
  {
    init_simple_test("aBFu8ll_I_I");
    static STRUCT_IF_C aBFu8ll_I_I lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_I_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_I");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_I.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_I, aBFu8ll_I_I)
//============================================================================



static void Test_aBFu8ll_I_Ip()
{
  {
    init_simple_test("aBFu8ll_I_Ip");
    static STRUCT_IF_C aBFu8ll_I_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_I_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_Ip");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_Ip.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_Ip, aBFu8ll_I_Ip)
//============================================================================



static void Test_aBFu8ll_I_L()
{
  {
    init_simple_test("aBFu8ll_I_L");
    static STRUCT_IF_C aBFu8ll_I_L lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_I_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_L");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_L.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_L, aBFu8ll_I_L)
//============================================================================



static void Test_aBFu8ll_I_S()
{
  {
    init_simple_test("aBFu8ll_I_S");
    static STRUCT_IF_C aBFu8ll_I_S lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_I_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_S");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_S.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_S, aBFu8ll_I_S)
//============================================================================



static void Test_aBFu8ll_I_Uc()
{
  {
    init_simple_test("aBFu8ll_I_Uc");
    static STRUCT_IF_C aBFu8ll_I_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_I_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_Uc");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_Uc.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_Uc, aBFu8ll_I_Uc)
//============================================================================



static void Test_aBFu8ll_I_Ui()
{
  {
    init_simple_test("aBFu8ll_I_Ui");
    static STRUCT_IF_C aBFu8ll_I_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_I_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_Ui");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_Ui.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_Ui, aBFu8ll_I_Ui)
//============================================================================



static void Test_aBFu8ll_I_Ul()
{
  {
    init_simple_test("aBFu8ll_I_Ul");
    static STRUCT_IF_C aBFu8ll_I_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_I_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_Ul");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_Ul.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_Ul, aBFu8ll_I_Ul)
//============================================================================



static void Test_aBFu8ll_I_Us()
{
  {
    init_simple_test("aBFu8ll_I_Us");
    static STRUCT_IF_C aBFu8ll_I_Us lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_I_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_Us");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_Us.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_Us, aBFu8ll_I_Us)
//============================================================================



static void Test_aBFu8ll_I_Vp()
{
  {
    init_simple_test("aBFu8ll_I_Vp");
    static STRUCT_IF_C aBFu8ll_I_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_I_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_I_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_I_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_I_Vp");
    check_field_offset(lv, v2, 1, "aBFu8ll_I_Vp.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_I_Vp, aBFu8ll_I_Vp)
//============================================================================



static void Test_aBFu8ll_Ip()
{
  {
    init_simple_test("aBFu8ll_Ip");
    static STRUCT_IF_C aBFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip, aBFu8ll_Ip)
//============================================================================



static void Test_aBFu8ll_Ip_BFu15i()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu15i");
    static STRUCT_IF_C aBFu8ll_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Ip_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aBFu8ll_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aBFu8ll_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu15i, aBFu8ll_Ip_BFu15i)
//============================================================================



static void Test_aBFu8ll_Ip_BFu15ll()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu15ll");
    static STRUCT_IF_C aBFu8ll_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Ip_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aBFu8ll_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aBFu8ll_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu15ll, aBFu8ll_Ip_BFu15ll)
//============================================================================



static void Test_aBFu8ll_Ip_BFu15s()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu15s");
    static STRUCT_IF_C aBFu8ll_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Ip_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aBFu8ll_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aBFu8ll_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu15s, aBFu8ll_Ip_BFu15s)
//============================================================================



static void Test_aBFu8ll_Ip_BFu16i()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu16i");
    static STRUCT_IF_C aBFu8ll_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Ip_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aBFu8ll_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aBFu8ll_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu16i, aBFu8ll_Ip_BFu16i)
//============================================================================



static void Test_aBFu8ll_Ip_BFu16ll()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu16ll");
    static STRUCT_IF_C aBFu8ll_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Ip_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aBFu8ll_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aBFu8ll_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu16ll, aBFu8ll_Ip_BFu16ll)
//============================================================================



static void Test_aBFu8ll_Ip_BFu16s()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu16s");
    static STRUCT_IF_C aBFu8ll_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Ip_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aBFu8ll_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aBFu8ll_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu16s, aBFu8ll_Ip_BFu16s)
//============================================================================



static void Test_aBFu8ll_Ip_BFu17i()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu17i");
    static STRUCT_IF_C aBFu8ll_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu8ll_Ip_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aBFu8ll_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aBFu8ll_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu17i, aBFu8ll_Ip_BFu17i)
//============================================================================



static void Test_aBFu8ll_Ip_BFu17ll()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu17ll");
    static STRUCT_IF_C aBFu8ll_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu8ll_Ip_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aBFu8ll_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aBFu8ll_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu17ll, aBFu8ll_Ip_BFu17ll)
//============================================================================



static void Test_aBFu8ll_Ip_BFu1c()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu1c");
    static STRUCT_IF_C aBFu8ll_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aBFu8ll_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu1c, aBFu8ll_Ip_BFu1c)
//============================================================================



static void Test_aBFu8ll_Ip_BFu1i()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu1i");
    static STRUCT_IF_C aBFu8ll_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aBFu8ll_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu1i, aBFu8ll_Ip_BFu1i)
//============================================================================



static void Test_aBFu8ll_Ip_BFu1ll()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu1ll");
    static STRUCT_IF_C aBFu8ll_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aBFu8ll_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu1ll, aBFu8ll_Ip_BFu1ll)
//============================================================================



static void Test_aBFu8ll_Ip_BFu1s()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu1s");
    static STRUCT_IF_C aBFu8ll_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aBFu8ll_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu1s, aBFu8ll_Ip_BFu1s)
//============================================================================



static void Test_aBFu8ll_Ip_BFu31i()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu31i");
    static STRUCT_IF_C aBFu8ll_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Ip_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aBFu8ll_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aBFu8ll_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu31i, aBFu8ll_Ip_BFu31i)
//============================================================================



static void Test_aBFu8ll_Ip_BFu31ll()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu31ll");
    static STRUCT_IF_C aBFu8ll_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Ip_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aBFu8ll_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aBFu8ll_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu31ll, aBFu8ll_Ip_BFu31ll)
//============================================================================



static void Test_aBFu8ll_Ip_BFu32i()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu32i");
    static STRUCT_IF_C aBFu8ll_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Ip_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aBFu8ll_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aBFu8ll_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu32i, aBFu8ll_Ip_BFu32i)
//============================================================================



static void Test_aBFu8ll_Ip_BFu32ll()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu32ll");
    static STRUCT_IF_C aBFu8ll_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Ip_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aBFu8ll_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aBFu8ll_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu32ll, aBFu8ll_Ip_BFu32ll)
//============================================================================



static void Test_aBFu8ll_Ip_BFu33()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu33");
    static STRUCT_IF_C aBFu8ll_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu8ll_Ip_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aBFu8ll_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aBFu8ll_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu33, aBFu8ll_Ip_BFu33)
//============================================================================



static void Test_aBFu8ll_Ip_BFu7c()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu7c");
    static STRUCT_IF_C aBFu8ll_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aBFu8ll_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aBFu8ll_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu7c, aBFu8ll_Ip_BFu7c)
//============================================================================



static void Test_aBFu8ll_Ip_BFu7i()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu7i");
    static STRUCT_IF_C aBFu8ll_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aBFu8ll_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aBFu8ll_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu7i, aBFu8ll_Ip_BFu7i)
//============================================================================



static void Test_aBFu8ll_Ip_BFu7ll()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu7ll");
    static STRUCT_IF_C aBFu8ll_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aBFu8ll_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aBFu8ll_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu7ll, aBFu8ll_Ip_BFu7ll)
//============================================================================



static void Test_aBFu8ll_Ip_BFu7s()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu7s");
    static STRUCT_IF_C aBFu8ll_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aBFu8ll_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aBFu8ll_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu7s, aBFu8ll_Ip_BFu7s)
//============================================================================



static void Test_aBFu8ll_Ip_BFu8c()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu8c");
    static STRUCT_IF_C aBFu8ll_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aBFu8ll_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu8c, aBFu8ll_Ip_BFu8c)
//============================================================================



static void Test_aBFu8ll_Ip_BFu8i()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu8i");
    static STRUCT_IF_C aBFu8ll_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aBFu8ll_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu8i, aBFu8ll_Ip_BFu8i)
//============================================================================



static void Test_aBFu8ll_Ip_BFu8ll()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu8ll");
    static STRUCT_IF_C aBFu8ll_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aBFu8ll_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu8ll, aBFu8ll_Ip_BFu8ll)
//============================================================================



static void Test_aBFu8ll_Ip_BFu8s()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu8s");
    static STRUCT_IF_C aBFu8ll_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aBFu8ll_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu8s, aBFu8ll_Ip_BFu8s)
//============================================================================



static void Test_aBFu8ll_Ip_BFu9i()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu9i");
    static STRUCT_IF_C aBFu8ll_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Ip_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aBFu8ll_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aBFu8ll_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu9i, aBFu8ll_Ip_BFu9i)
//============================================================================



static void Test_aBFu8ll_Ip_BFu9ll()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu9ll");
    static STRUCT_IF_C aBFu8ll_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Ip_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aBFu8ll_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aBFu8ll_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu9ll, aBFu8ll_Ip_BFu9ll)
//============================================================================



static void Test_aBFu8ll_Ip_BFu9s()
{
  {
    init_simple_test("aBFu8ll_Ip_BFu9s");
    static STRUCT_IF_C aBFu8ll_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Ip_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aBFu8ll_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aBFu8ll_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_BFu9s, aBFu8ll_Ip_BFu9s)
//============================================================================



static void Test_aBFu8ll_Ip_C()
{
  {
    init_simple_test("aBFu8ll_Ip_C");
    static STRUCT_IF_C aBFu8ll_Ip_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_C");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_C, aBFu8ll_Ip_C)
//============================================================================



static void Test_aBFu8ll_Ip_D()
{
  {
    init_simple_test("aBFu8ll_Ip_D");
    static STRUCT_IF_C aBFu8ll_Ip_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aBFu8ll_Ip_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_D");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_D, aBFu8ll_Ip_D)
//============================================================================



static void Test_aBFu8ll_Ip_F()
{
  {
    init_simple_test("aBFu8ll_Ip_F");
    static STRUCT_IF_C aBFu8ll_Ip_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Ip_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_F");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_F, aBFu8ll_Ip_F)
//============================================================================



static void Test_aBFu8ll_Ip_I()
{
  {
    init_simple_test("aBFu8ll_Ip_I");
    static STRUCT_IF_C aBFu8ll_Ip_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Ip_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_I");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_I, aBFu8ll_Ip_I)
//============================================================================



static void Test_aBFu8ll_Ip_Ip()
{
  {
    init_simple_test("aBFu8ll_Ip_Ip");
    static STRUCT_IF_C aBFu8ll_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aBFu8ll_Ip_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_Ip");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_Ip, aBFu8ll_Ip_Ip)
//============================================================================



static void Test_aBFu8ll_Ip_L()
{
  {
    init_simple_test("aBFu8ll_Ip_L");
    static STRUCT_IF_C aBFu8ll_Ip_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aBFu8ll_Ip_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_L");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_L, aBFu8ll_Ip_L)
//============================================================================



static void Test_aBFu8ll_Ip_S()
{
  {
    init_simple_test("aBFu8ll_Ip_S");
    static STRUCT_IF_C aBFu8ll_Ip_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Ip_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_S");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_S, aBFu8ll_Ip_S)
//============================================================================



static void Test_aBFu8ll_Ip_Uc()
{
  {
    init_simple_test("aBFu8ll_Ip_Uc");
    static STRUCT_IF_C aBFu8ll_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Ip_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_Uc");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_Uc, aBFu8ll_Ip_Uc)
//============================================================================



static void Test_aBFu8ll_Ip_Ui()
{
  {
    init_simple_test("aBFu8ll_Ip_Ui");
    static STRUCT_IF_C aBFu8ll_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Ip_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_Ui");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_Ui, aBFu8ll_Ip_Ui)
//============================================================================



static void Test_aBFu8ll_Ip_Ul()
{
  {
    init_simple_test("aBFu8ll_Ip_Ul");
    static STRUCT_IF_C aBFu8ll_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aBFu8ll_Ip_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_Ul");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_Ul, aBFu8ll_Ip_Ul)
//============================================================================



static void Test_aBFu8ll_Ip_Us()
{
  {
    init_simple_test("aBFu8ll_Ip_Us");
    static STRUCT_IF_C aBFu8ll_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Ip_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_Us");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_Us, aBFu8ll_Ip_Us)
//============================================================================



static void Test_aBFu8ll_Ip_Vp()
{
  {
    init_simple_test("aBFu8ll_Ip_Vp");
    static STRUCT_IF_C aBFu8ll_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aBFu8ll_Ip_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ip_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ip_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ip_Vp");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ip_Vp, aBFu8ll_Ip_Vp)
//============================================================================



static void Test_aBFu8ll_L()
{
  {
    init_simple_test("aBFu8ll_L");
    static STRUCT_IF_C aBFu8ll_L lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L");
    check_field_offset(lv, v2, 1, "aBFu8ll_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L, aBFu8ll_L)
//============================================================================



static void Test_aBFu8ll_L_BFu15i()
{
  {
    init_simple_test("aBFu8ll_L_BFu15i");
    static STRUCT_IF_C aBFu8ll_L_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_L_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aBFu8ll_L_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aBFu8ll_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu15i, aBFu8ll_L_BFu15i)
//============================================================================



static void Test_aBFu8ll_L_BFu15ll()
{
  {
    init_simple_test("aBFu8ll_L_BFu15ll");
    static STRUCT_IF_C aBFu8ll_L_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_L_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aBFu8ll_L_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aBFu8ll_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu15ll, aBFu8ll_L_BFu15ll)
//============================================================================



static void Test_aBFu8ll_L_BFu15s()
{
  {
    init_simple_test("aBFu8ll_L_BFu15s");
    static STRUCT_IF_C aBFu8ll_L_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_L_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aBFu8ll_L_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aBFu8ll_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu15s, aBFu8ll_L_BFu15s)
//============================================================================



static void Test_aBFu8ll_L_BFu16i()
{
  {
    init_simple_test("aBFu8ll_L_BFu16i");
    static STRUCT_IF_C aBFu8ll_L_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_L_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aBFu8ll_L_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aBFu8ll_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu16i, aBFu8ll_L_BFu16i)
//============================================================================



static void Test_aBFu8ll_L_BFu16ll()
{
  {
    init_simple_test("aBFu8ll_L_BFu16ll");
    static STRUCT_IF_C aBFu8ll_L_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_L_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aBFu8ll_L_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aBFu8ll_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu16ll, aBFu8ll_L_BFu16ll)
//============================================================================



static void Test_aBFu8ll_L_BFu16s()
{
  {
    init_simple_test("aBFu8ll_L_BFu16s");
    static STRUCT_IF_C aBFu8ll_L_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_L_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aBFu8ll_L_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aBFu8ll_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu16s, aBFu8ll_L_BFu16s)
//============================================================================



static void Test_aBFu8ll_L_BFu17i()
{
  {
    init_simple_test("aBFu8ll_L_BFu17i");
    static STRUCT_IF_C aBFu8ll_L_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aBFu8ll_L_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aBFu8ll_L_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aBFu8ll_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu17i, aBFu8ll_L_BFu17i)
//============================================================================



static void Test_aBFu8ll_L_BFu17ll()
{
  {
    init_simple_test("aBFu8ll_L_BFu17ll");
    static STRUCT_IF_C aBFu8ll_L_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aBFu8ll_L_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aBFu8ll_L_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aBFu8ll_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu17ll, aBFu8ll_L_BFu17ll)
//============================================================================



static void Test_aBFu8ll_L_BFu1c()
{
  {
    init_simple_test("aBFu8ll_L_BFu1c");
    static STRUCT_IF_C aBFu8ll_L_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aBFu8ll_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu1c, aBFu8ll_L_BFu1c)
//============================================================================



static void Test_aBFu8ll_L_BFu1i()
{
  {
    init_simple_test("aBFu8ll_L_BFu1i");
    static STRUCT_IF_C aBFu8ll_L_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aBFu8ll_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu1i, aBFu8ll_L_BFu1i)
//============================================================================



static void Test_aBFu8ll_L_BFu1ll()
{
  {
    init_simple_test("aBFu8ll_L_BFu1ll");
    static STRUCT_IF_C aBFu8ll_L_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aBFu8ll_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu1ll, aBFu8ll_L_BFu1ll)
//============================================================================



static void Test_aBFu8ll_L_BFu1s()
{
  {
    init_simple_test("aBFu8ll_L_BFu1s");
    static STRUCT_IF_C aBFu8ll_L_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aBFu8ll_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu1s, aBFu8ll_L_BFu1s)
//============================================================================



static void Test_aBFu8ll_L_BFu31i()
{
  {
    init_simple_test("aBFu8ll_L_BFu31i");
    static STRUCT_IF_C aBFu8ll_L_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_L_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aBFu8ll_L_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aBFu8ll_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu31i, aBFu8ll_L_BFu31i)
//============================================================================



static void Test_aBFu8ll_L_BFu31ll()
{
  {
    init_simple_test("aBFu8ll_L_BFu31ll");
    static STRUCT_IF_C aBFu8ll_L_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_L_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aBFu8ll_L_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aBFu8ll_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu31ll, aBFu8ll_L_BFu31ll)
//============================================================================



static void Test_aBFu8ll_L_BFu32i()
{
  {
    init_simple_test("aBFu8ll_L_BFu32i");
    static STRUCT_IF_C aBFu8ll_L_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_L_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aBFu8ll_L_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aBFu8ll_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu32i, aBFu8ll_L_BFu32i)
//============================================================================



static void Test_aBFu8ll_L_BFu32ll()
{
  {
    init_simple_test("aBFu8ll_L_BFu32ll");
    static STRUCT_IF_C aBFu8ll_L_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_L_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aBFu8ll_L_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aBFu8ll_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu32ll, aBFu8ll_L_BFu32ll)
//============================================================================



static void Test_aBFu8ll_L_BFu33()
{
  {
    init_simple_test("aBFu8ll_L_BFu33");
    static STRUCT_IF_C aBFu8ll_L_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aBFu8ll_L_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aBFu8ll_L_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aBFu8ll_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu33, aBFu8ll_L_BFu33)
//============================================================================



static void Test_aBFu8ll_L_BFu7c()
{
  {
    init_simple_test("aBFu8ll_L_BFu7c");
    static STRUCT_IF_C aBFu8ll_L_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aBFu8ll_L_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aBFu8ll_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu7c, aBFu8ll_L_BFu7c)
//============================================================================



static void Test_aBFu8ll_L_BFu7i()
{
  {
    init_simple_test("aBFu8ll_L_BFu7i");
    static STRUCT_IF_C aBFu8ll_L_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aBFu8ll_L_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aBFu8ll_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu7i, aBFu8ll_L_BFu7i)
//============================================================================



static void Test_aBFu8ll_L_BFu7ll()
{
  {
    init_simple_test("aBFu8ll_L_BFu7ll");
    static STRUCT_IF_C aBFu8ll_L_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aBFu8ll_L_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aBFu8ll_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu7ll, aBFu8ll_L_BFu7ll)
//============================================================================



static void Test_aBFu8ll_L_BFu7s()
{
  {
    init_simple_test("aBFu8ll_L_BFu7s");
    static STRUCT_IF_C aBFu8ll_L_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aBFu8ll_L_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aBFu8ll_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu7s, aBFu8ll_L_BFu7s)
//============================================================================



static void Test_aBFu8ll_L_BFu8c()
{
  {
    init_simple_test("aBFu8ll_L_BFu8c");
    static STRUCT_IF_C aBFu8ll_L_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aBFu8ll_L_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu8c, aBFu8ll_L_BFu8c)
//============================================================================



static void Test_aBFu8ll_L_BFu8i()
{
  {
    init_simple_test("aBFu8ll_L_BFu8i");
    static STRUCT_IF_C aBFu8ll_L_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aBFu8ll_L_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu8i, aBFu8ll_L_BFu8i)
//============================================================================



static void Test_aBFu8ll_L_BFu8ll()
{
  {
    init_simple_test("aBFu8ll_L_BFu8ll");
    static STRUCT_IF_C aBFu8ll_L_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aBFu8ll_L_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu8ll, aBFu8ll_L_BFu8ll)
//============================================================================



static void Test_aBFu8ll_L_BFu8s()
{
  {
    init_simple_test("aBFu8ll_L_BFu8s");
    static STRUCT_IF_C aBFu8ll_L_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aBFu8ll_L_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu8s, aBFu8ll_L_BFu8s)
//============================================================================



static void Test_aBFu8ll_L_BFu9i()
{
  {
    init_simple_test("aBFu8ll_L_BFu9i");
    static STRUCT_IF_C aBFu8ll_L_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_L_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aBFu8ll_L_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aBFu8ll_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu9i, aBFu8ll_L_BFu9i)
//============================================================================



static void Test_aBFu8ll_L_BFu9ll()
{
  {
    init_simple_test("aBFu8ll_L_BFu9ll");
    static STRUCT_IF_C aBFu8ll_L_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_L_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aBFu8ll_L_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aBFu8ll_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu9ll, aBFu8ll_L_BFu9ll)
//============================================================================



static void Test_aBFu8ll_L_BFu9s()
{
  {
    init_simple_test("aBFu8ll_L_BFu9s");
    static STRUCT_IF_C aBFu8ll_L_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_L_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aBFu8ll_L_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aBFu8ll_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_BFu9s, aBFu8ll_L_BFu9s)
//============================================================================



static void Test_aBFu8ll_L_C()
{
  {
    init_simple_test("aBFu8ll_L_C");
    static STRUCT_IF_C aBFu8ll_L_C lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_C");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_C.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_C, aBFu8ll_L_C)
//============================================================================



static void Test_aBFu8ll_L_D()
{
  {
    init_simple_test("aBFu8ll_L_D");
    static STRUCT_IF_C aBFu8ll_L_D lv;
    check2(sizeof(lv), 17, "sizeof(aBFu8ll_L_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_D");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_D.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_D, aBFu8ll_L_D)
//============================================================================



static void Test_aBFu8ll_L_F()
{
  {
    init_simple_test("aBFu8ll_L_F");
    static STRUCT_IF_C aBFu8ll_L_F lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_L_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_F");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_F.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_F, aBFu8ll_L_F)
//============================================================================



static void Test_aBFu8ll_L_I()
{
  {
    init_simple_test("aBFu8ll_L_I");
    static STRUCT_IF_C aBFu8ll_L_I lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_L_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_I");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_I.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_I, aBFu8ll_L_I)
//============================================================================



static void Test_aBFu8ll_L_Ip()
{
  {
    init_simple_test("aBFu8ll_L_Ip");
    static STRUCT_IF_C aBFu8ll_L_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aBFu8ll_L_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_Ip");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_Ip.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_Ip, aBFu8ll_L_Ip)
//============================================================================



static void Test_aBFu8ll_L_L()
{
  {
    init_simple_test("aBFu8ll_L_L");
    static STRUCT_IF_C aBFu8ll_L_L lv;
    check2(sizeof(lv), 17, "sizeof(aBFu8ll_L_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_L");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_L.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_L, aBFu8ll_L_L)
//============================================================================



static void Test_aBFu8ll_L_S()
{
  {
    init_simple_test("aBFu8ll_L_S");
    static STRUCT_IF_C aBFu8ll_L_S lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_L_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_S");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_S.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_S, aBFu8ll_L_S)
//============================================================================



static void Test_aBFu8ll_L_Uc()
{
  {
    init_simple_test("aBFu8ll_L_Uc");
    static STRUCT_IF_C aBFu8ll_L_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_L_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_Uc");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_Uc.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_Uc, aBFu8ll_L_Uc)
//============================================================================



static void Test_aBFu8ll_L_Ui()
{
  {
    init_simple_test("aBFu8ll_L_Ui");
    static STRUCT_IF_C aBFu8ll_L_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_L_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_Ui");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_Ui.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_Ui, aBFu8ll_L_Ui)
//============================================================================



static void Test_aBFu8ll_L_Ul()
{
  {
    init_simple_test("aBFu8ll_L_Ul");
    static STRUCT_IF_C aBFu8ll_L_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aBFu8ll_L_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_Ul");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_Ul.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_Ul, aBFu8ll_L_Ul)
//============================================================================



static void Test_aBFu8ll_L_Us()
{
  {
    init_simple_test("aBFu8ll_L_Us");
    static STRUCT_IF_C aBFu8ll_L_Us lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_L_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_Us");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_Us.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_Us, aBFu8ll_L_Us)
//============================================================================



static void Test_aBFu8ll_L_Vp()
{
  {
    init_simple_test("aBFu8ll_L_Vp");
    static STRUCT_IF_C aBFu8ll_L_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aBFu8ll_L_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_L_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_L_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_L_Vp");
    check_field_offset(lv, v2, 1, "aBFu8ll_L_Vp.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_L_Vp, aBFu8ll_L_Vp)
//============================================================================



static void Test_aBFu8ll_S()
{
  {
    init_simple_test("aBFu8ll_S");
    static STRUCT_IF_C aBFu8ll_S lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S");
    check_field_offset(lv, v2, 1, "aBFu8ll_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S, aBFu8ll_S)
//============================================================================



static void Test_aBFu8ll_S_BFu15i()
{
  {
    init_simple_test("aBFu8ll_S_BFu15i");
    static STRUCT_IF_C aBFu8ll_S_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_S_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu8ll_S_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu8ll_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu15i, aBFu8ll_S_BFu15i)
//============================================================================



static void Test_aBFu8ll_S_BFu15ll()
{
  {
    init_simple_test("aBFu8ll_S_BFu15ll");
    static STRUCT_IF_C aBFu8ll_S_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_S_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu8ll_S_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu8ll_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu15ll, aBFu8ll_S_BFu15ll)
//============================================================================



static void Test_aBFu8ll_S_BFu15s()
{
  {
    init_simple_test("aBFu8ll_S_BFu15s");
    static STRUCT_IF_C aBFu8ll_S_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_S_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu8ll_S_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu8ll_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu15s, aBFu8ll_S_BFu15s)
//============================================================================



static void Test_aBFu8ll_S_BFu16i()
{
  {
    init_simple_test("aBFu8ll_S_BFu16i");
    static STRUCT_IF_C aBFu8ll_S_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_S_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu8ll_S_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu8ll_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu16i, aBFu8ll_S_BFu16i)
//============================================================================



static void Test_aBFu8ll_S_BFu16ll()
{
  {
    init_simple_test("aBFu8ll_S_BFu16ll");
    static STRUCT_IF_C aBFu8ll_S_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_S_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu8ll_S_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu8ll_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu16ll, aBFu8ll_S_BFu16ll)
//============================================================================



static void Test_aBFu8ll_S_BFu16s()
{
  {
    init_simple_test("aBFu8ll_S_BFu16s");
    static STRUCT_IF_C aBFu8ll_S_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_S_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu8ll_S_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu8ll_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu16s, aBFu8ll_S_BFu16s)
//============================================================================



static void Test_aBFu8ll_S_BFu17i()
{
  {
    init_simple_test("aBFu8ll_S_BFu17i");
    static STRUCT_IF_C aBFu8ll_S_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_S_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu8ll_S_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu8ll_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu17i, aBFu8ll_S_BFu17i)
//============================================================================



static void Test_aBFu8ll_S_BFu17ll()
{
  {
    init_simple_test("aBFu8ll_S_BFu17ll");
    static STRUCT_IF_C aBFu8ll_S_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_S_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu8ll_S_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu8ll_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu17ll, aBFu8ll_S_BFu17ll)
//============================================================================



static void Test_aBFu8ll_S_BFu1c()
{
  {
    init_simple_test("aBFu8ll_S_BFu1c");
    static STRUCT_IF_C aBFu8ll_S_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu8ll_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu1c, aBFu8ll_S_BFu1c)
//============================================================================



static void Test_aBFu8ll_S_BFu1i()
{
  {
    init_simple_test("aBFu8ll_S_BFu1i");
    static STRUCT_IF_C aBFu8ll_S_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu8ll_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu1i, aBFu8ll_S_BFu1i)
//============================================================================



static void Test_aBFu8ll_S_BFu1ll()
{
  {
    init_simple_test("aBFu8ll_S_BFu1ll");
    static STRUCT_IF_C aBFu8ll_S_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu8ll_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu1ll, aBFu8ll_S_BFu1ll)
//============================================================================



static void Test_aBFu8ll_S_BFu1s()
{
  {
    init_simple_test("aBFu8ll_S_BFu1s");
    static STRUCT_IF_C aBFu8ll_S_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu8ll_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu1s, aBFu8ll_S_BFu1s)
//============================================================================



static void Test_aBFu8ll_S_BFu31i()
{
  {
    init_simple_test("aBFu8ll_S_BFu31i");
    static STRUCT_IF_C aBFu8ll_S_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_S_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu8ll_S_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu8ll_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu31i, aBFu8ll_S_BFu31i)
//============================================================================



static void Test_aBFu8ll_S_BFu31ll()
{
  {
    init_simple_test("aBFu8ll_S_BFu31ll");
    static STRUCT_IF_C aBFu8ll_S_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_S_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu8ll_S_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu8ll_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu31ll, aBFu8ll_S_BFu31ll)
//============================================================================



static void Test_aBFu8ll_S_BFu32i()
{
  {
    init_simple_test("aBFu8ll_S_BFu32i");
    static STRUCT_IF_C aBFu8ll_S_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_S_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu8ll_S_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu8ll_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu32i, aBFu8ll_S_BFu32i)
//============================================================================



static void Test_aBFu8ll_S_BFu32ll()
{
  {
    init_simple_test("aBFu8ll_S_BFu32ll");
    static STRUCT_IF_C aBFu8ll_S_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_S_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu8ll_S_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu8ll_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu32ll, aBFu8ll_S_BFu32ll)
//============================================================================



static void Test_aBFu8ll_S_BFu33()
{
  {
    init_simple_test("aBFu8ll_S_BFu33");
    static STRUCT_IF_C aBFu8ll_S_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aBFu8ll_S_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aBFu8ll_S_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aBFu8ll_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu33, aBFu8ll_S_BFu33)
//============================================================================



static void Test_aBFu8ll_S_BFu7c()
{
  {
    init_simple_test("aBFu8ll_S_BFu7c");
    static STRUCT_IF_C aBFu8ll_S_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu8ll_S_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu8ll_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu7c, aBFu8ll_S_BFu7c)
//============================================================================



static void Test_aBFu8ll_S_BFu7i()
{
  {
    init_simple_test("aBFu8ll_S_BFu7i");
    static STRUCT_IF_C aBFu8ll_S_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu8ll_S_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu8ll_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu7i, aBFu8ll_S_BFu7i)
//============================================================================



static void Test_aBFu8ll_S_BFu7ll()
{
  {
    init_simple_test("aBFu8ll_S_BFu7ll");
    static STRUCT_IF_C aBFu8ll_S_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu8ll_S_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu8ll_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu7ll, aBFu8ll_S_BFu7ll)
//============================================================================



static void Test_aBFu8ll_S_BFu7s()
{
  {
    init_simple_test("aBFu8ll_S_BFu7s");
    static STRUCT_IF_C aBFu8ll_S_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu8ll_S_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu8ll_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu7s, aBFu8ll_S_BFu7s)
//============================================================================



static void Test_aBFu8ll_S_BFu8c()
{
  {
    init_simple_test("aBFu8ll_S_BFu8c");
    static STRUCT_IF_C aBFu8ll_S_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu8ll_S_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu8c, aBFu8ll_S_BFu8c)
//============================================================================



static void Test_aBFu8ll_S_BFu8i()
{
  {
    init_simple_test("aBFu8ll_S_BFu8i");
    static STRUCT_IF_C aBFu8ll_S_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu8ll_S_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu8i, aBFu8ll_S_BFu8i)
//============================================================================



static void Test_aBFu8ll_S_BFu8ll()
{
  {
    init_simple_test("aBFu8ll_S_BFu8ll");
    static STRUCT_IF_C aBFu8ll_S_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu8ll_S_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu8ll, aBFu8ll_S_BFu8ll)
//============================================================================



static void Test_aBFu8ll_S_BFu8s()
{
  {
    init_simple_test("aBFu8ll_S_BFu8s");
    static STRUCT_IF_C aBFu8ll_S_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu8ll_S_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu8s, aBFu8ll_S_BFu8s)
//============================================================================



static void Test_aBFu8ll_S_BFu9i()
{
  {
    init_simple_test("aBFu8ll_S_BFu9i");
    static STRUCT_IF_C aBFu8ll_S_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_S_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu8ll_S_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu8ll_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu9i, aBFu8ll_S_BFu9i)
//============================================================================



static void Test_aBFu8ll_S_BFu9ll()
{
  {
    init_simple_test("aBFu8ll_S_BFu9ll");
    static STRUCT_IF_C aBFu8ll_S_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_S_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu8ll_S_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu8ll_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu9ll, aBFu8ll_S_BFu9ll)
//============================================================================



static void Test_aBFu8ll_S_BFu9s()
{
  {
    init_simple_test("aBFu8ll_S_BFu9s");
    static STRUCT_IF_C aBFu8ll_S_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_S_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu8ll_S_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu8ll_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_BFu9s, aBFu8ll_S_BFu9s)
//============================================================================



static void Test_aBFu8ll_S_C()
{
  {
    init_simple_test("aBFu8ll_S_C");
    static STRUCT_IF_C aBFu8ll_S_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_C");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_C.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_C, aBFu8ll_S_C)
//============================================================================



static void Test_aBFu8ll_S_D()
{
  {
    init_simple_test("aBFu8ll_S_D");
    static STRUCT_IF_C aBFu8ll_S_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_S_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_D");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_D.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_D, aBFu8ll_S_D)
//============================================================================



static void Test_aBFu8ll_S_F()
{
  {
    init_simple_test("aBFu8ll_S_F");
    static STRUCT_IF_C aBFu8ll_S_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_S_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_F");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_F.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_F, aBFu8ll_S_F)
//============================================================================



static void Test_aBFu8ll_S_I()
{
  {
    init_simple_test("aBFu8ll_S_I");
    static STRUCT_IF_C aBFu8ll_S_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_S_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_I");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_I.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_I, aBFu8ll_S_I)
//============================================================================



static void Test_aBFu8ll_S_Ip()
{
  {
    init_simple_test("aBFu8ll_S_Ip");
    static STRUCT_IF_C aBFu8ll_S_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_S_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_Ip");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_Ip.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_Ip, aBFu8ll_S_Ip)
//============================================================================



static void Test_aBFu8ll_S_L()
{
  {
    init_simple_test("aBFu8ll_S_L");
    static STRUCT_IF_C aBFu8ll_S_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_S_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_L");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_L.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_L, aBFu8ll_S_L)
//============================================================================



static void Test_aBFu8ll_S_S()
{
  {
    init_simple_test("aBFu8ll_S_S");
    static STRUCT_IF_C aBFu8ll_S_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_S_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_S");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_S.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_S, aBFu8ll_S_S)
//============================================================================



static void Test_aBFu8ll_S_Uc()
{
  {
    init_simple_test("aBFu8ll_S_Uc");
    static STRUCT_IF_C aBFu8ll_S_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_S_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_Uc");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_Uc.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_Uc, aBFu8ll_S_Uc)
//============================================================================



static void Test_aBFu8ll_S_Ui()
{
  {
    init_simple_test("aBFu8ll_S_Ui");
    static STRUCT_IF_C aBFu8ll_S_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_S_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_Ui");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_Ui.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_Ui, aBFu8ll_S_Ui)
//============================================================================



static void Test_aBFu8ll_S_Ul()
{
  {
    init_simple_test("aBFu8ll_S_Ul");
    static STRUCT_IF_C aBFu8ll_S_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_S_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_Ul");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_Ul.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_Ul, aBFu8ll_S_Ul)
//============================================================================



static void Test_aBFu8ll_S_Us()
{
  {
    init_simple_test("aBFu8ll_S_Us");
    static STRUCT_IF_C aBFu8ll_S_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_S_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_Us");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_Us.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_Us, aBFu8ll_S_Us)
//============================================================================



static void Test_aBFu8ll_S_Vp()
{
  {
    init_simple_test("aBFu8ll_S_Vp");
    static STRUCT_IF_C aBFu8ll_S_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_S_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_S_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_S_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_S_Vp");
    check_field_offset(lv, v2, 1, "aBFu8ll_S_Vp.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_S_Vp, aBFu8ll_S_Vp)
//============================================================================



static void Test_aBFu8ll_Uc()
{
  {
    init_simple_test("aBFu8ll_Uc");
    static STRUCT_IF_C aBFu8ll_Uc lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc, aBFu8ll_Uc)
//============================================================================



static void Test_aBFu8ll_Uc_BFu15i()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu15i");
    static STRUCT_IF_C aBFu8ll_Uc_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Uc_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8ll_Uc_BFu15i");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8ll_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu15i, aBFu8ll_Uc_BFu15i)
//============================================================================



static void Test_aBFu8ll_Uc_BFu15ll()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu15ll");
    static STRUCT_IF_C aBFu8ll_Uc_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Uc_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8ll_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8ll_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu15ll, aBFu8ll_Uc_BFu15ll)
//============================================================================



static void Test_aBFu8ll_Uc_BFu15s()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu15s");
    static STRUCT_IF_C aBFu8ll_Uc_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Uc_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 2, 0, 15, 1, "aBFu8ll_Uc_BFu15s");
    set_bf_and_test(lv, v3, 2, 0, 15, hide_ull(1LL<<14), "aBFu8ll_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu15s, aBFu8ll_Uc_BFu15s)
//============================================================================



static void Test_aBFu8ll_Uc_BFu16i()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu16i");
    static STRUCT_IF_C aBFu8ll_Uc_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Uc_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8ll_Uc_BFu16i");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8ll_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu16i, aBFu8ll_Uc_BFu16i)
//============================================================================



static void Test_aBFu8ll_Uc_BFu16ll()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu16ll");
    static STRUCT_IF_C aBFu8ll_Uc_BFu16ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Uc_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8ll_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8ll_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu16ll, aBFu8ll_Uc_BFu16ll)
//============================================================================



static void Test_aBFu8ll_Uc_BFu16s()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu16s");
    static STRUCT_IF_C aBFu8ll_Uc_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Uc_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 2, 0, 16, 1, "aBFu8ll_Uc_BFu16s");
    set_bf_and_test(lv, v3, 2, 0, 16, hide_ull(1LL<<15), "aBFu8ll_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu16s, aBFu8ll_Uc_BFu16s)
//============================================================================



static void Test_aBFu8ll_Uc_BFu17i()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu17i");
    static STRUCT_IF_C aBFu8ll_Uc_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Uc_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu8ll_Uc_BFu17i");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu8ll_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu17i, aBFu8ll_Uc_BFu17i)
//============================================================================



static void Test_aBFu8ll_Uc_BFu17ll()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu17ll");
    static STRUCT_IF_C aBFu8ll_Uc_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Uc_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 17, 1, "aBFu8ll_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 2, 0, 17, hide_ull(1LL<<16), "aBFu8ll_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu17ll, aBFu8ll_Uc_BFu17ll)
//============================================================================



static void Test_aBFu8ll_Uc_BFu1c()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu1c");
    static STRUCT_IF_C aBFu8ll_Uc_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8ll_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu1c, aBFu8ll_Uc_BFu1c)
//============================================================================



static void Test_aBFu8ll_Uc_BFu1i()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu1i");
    static STRUCT_IF_C aBFu8ll_Uc_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8ll_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu1i, aBFu8ll_Uc_BFu1i)
//============================================================================



static void Test_aBFu8ll_Uc_BFu1ll()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu1ll");
    static STRUCT_IF_C aBFu8ll_Uc_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8ll_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu1ll, aBFu8ll_Uc_BFu1ll)
//============================================================================



static void Test_aBFu8ll_Uc_BFu1s()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu1s");
    static STRUCT_IF_C aBFu8ll_Uc_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 2, 0, 1, 1, "aBFu8ll_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu1s, aBFu8ll_Uc_BFu1s)
//============================================================================



static void Test_aBFu8ll_Uc_BFu31i()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu31i");
    static STRUCT_IF_C aBFu8ll_Uc_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Uc_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu8ll_Uc_BFu31i");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu8ll_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu31i, aBFu8ll_Uc_BFu31i)
//============================================================================



static void Test_aBFu8ll_Uc_BFu31ll()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu31ll");
    static STRUCT_IF_C aBFu8ll_Uc_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Uc_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 31, 1, "aBFu8ll_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 2, 0, 31, hide_ull(1LL<<30), "aBFu8ll_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu31ll, aBFu8ll_Uc_BFu31ll)
//============================================================================



static void Test_aBFu8ll_Uc_BFu32i()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu32i");
    static STRUCT_IF_C aBFu8ll_Uc_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Uc_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu8ll_Uc_BFu32i");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu8ll_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu32i, aBFu8ll_Uc_BFu32i)
//============================================================================



static void Test_aBFu8ll_Uc_BFu32ll()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu32ll");
    static STRUCT_IF_C aBFu8ll_Uc_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Uc_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 32, 1, "aBFu8ll_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 2, 0, 32, hide_ull(1LL<<31), "aBFu8ll_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu32ll, aBFu8ll_Uc_BFu32ll)
//============================================================================



static void Test_aBFu8ll_Uc_BFu33()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu33");
    static STRUCT_IF_C aBFu8ll_Uc_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Uc_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 2, 0, 33, 1, "aBFu8ll_Uc_BFu33");
    set_bf_and_test(lv, v3, 2, 0, 33, hide_ull(1LL<<32), "aBFu8ll_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu33, aBFu8ll_Uc_BFu33)
//============================================================================



static void Test_aBFu8ll_Uc_BFu7c()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu7c");
    static STRUCT_IF_C aBFu8ll_Uc_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8ll_Uc_BFu7c");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu7c, aBFu8ll_Uc_BFu7c)
//============================================================================



static void Test_aBFu8ll_Uc_BFu7i()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu7i");
    static STRUCT_IF_C aBFu8ll_Uc_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8ll_Uc_BFu7i");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu7i, aBFu8ll_Uc_BFu7i)
//============================================================================



static void Test_aBFu8ll_Uc_BFu7ll()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu7ll");
    static STRUCT_IF_C aBFu8ll_Uc_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8ll_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu7ll, aBFu8ll_Uc_BFu7ll)
//============================================================================



static void Test_aBFu8ll_Uc_BFu7s()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu7s");
    static STRUCT_IF_C aBFu8ll_Uc_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 2, 0, 7, 1, "aBFu8ll_Uc_BFu7s");
    set_bf_and_test(lv, v3, 2, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu7s, aBFu8ll_Uc_BFu7s)
//============================================================================



static void Test_aBFu8ll_Uc_BFu8c()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu8c");
    static STRUCT_IF_C aBFu8ll_Uc_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8ll_Uc_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu8c, aBFu8ll_Uc_BFu8c)
//============================================================================



static void Test_aBFu8ll_Uc_BFu8i()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu8i");
    static STRUCT_IF_C aBFu8ll_Uc_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8ll_Uc_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu8i, aBFu8ll_Uc_BFu8i)
//============================================================================



static void Test_aBFu8ll_Uc_BFu8ll()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu8ll");
    static STRUCT_IF_C aBFu8ll_Uc_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8ll_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu8ll, aBFu8ll_Uc_BFu8ll)
//============================================================================



static void Test_aBFu8ll_Uc_BFu8s()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu8s");
    static STRUCT_IF_C aBFu8ll_Uc_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8ll_Uc_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu8s, aBFu8ll_Uc_BFu8s)
//============================================================================



static void Test_aBFu8ll_Uc_BFu9i()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu9i");
    static STRUCT_IF_C aBFu8ll_Uc_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Uc_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8ll_Uc_BFu9i");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8ll_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu9i, aBFu8ll_Uc_BFu9i)
//============================================================================



static void Test_aBFu8ll_Uc_BFu9ll()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu9ll");
    static STRUCT_IF_C aBFu8ll_Uc_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Uc_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8ll_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8ll_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu9ll, aBFu8ll_Uc_BFu9ll)
//============================================================================



static void Test_aBFu8ll_Uc_BFu9s()
{
  {
    init_simple_test("aBFu8ll_Uc_BFu9s");
    static STRUCT_IF_C aBFu8ll_Uc_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Uc_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 2, 0, 9, 1, "aBFu8ll_Uc_BFu9s");
    set_bf_and_test(lv, v3, 2, 0, 9, hide_ull(1LL<<8), "aBFu8ll_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_BFu9s, aBFu8ll_Uc_BFu9s)
//============================================================================



static void Test_aBFu8ll_Uc_C()
{
  {
    init_simple_test("aBFu8ll_Uc_C");
    static STRUCT_IF_C aBFu8ll_Uc_C lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_C");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_C.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_C, aBFu8ll_Uc_C)
//============================================================================



static void Test_aBFu8ll_Uc_D()
{
  {
    init_simple_test("aBFu8ll_Uc_D");
    static STRUCT_IF_C aBFu8ll_Uc_D lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Uc_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_D");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_D.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_D, aBFu8ll_Uc_D)
//============================================================================



static void Test_aBFu8ll_Uc_F()
{
  {
    init_simple_test("aBFu8ll_Uc_F");
    static STRUCT_IF_C aBFu8ll_Uc_F lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Uc_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_F");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_F.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_F, aBFu8ll_Uc_F)
//============================================================================



static void Test_aBFu8ll_Uc_I()
{
  {
    init_simple_test("aBFu8ll_Uc_I");
    static STRUCT_IF_C aBFu8ll_Uc_I lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Uc_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_I");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_I.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_I, aBFu8ll_Uc_I)
//============================================================================



static void Test_aBFu8ll_Uc_Ip()
{
  {
    init_simple_test("aBFu8ll_Uc_Ip");
    static STRUCT_IF_C aBFu8ll_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Uc_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_Ip");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_Ip.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_Ip, aBFu8ll_Uc_Ip)
//============================================================================



static void Test_aBFu8ll_Uc_L()
{
  {
    init_simple_test("aBFu8ll_Uc_L");
    static STRUCT_IF_C aBFu8ll_Uc_L lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Uc_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_L");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_L.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_L, aBFu8ll_Uc_L)
//============================================================================



static void Test_aBFu8ll_Uc_S()
{
  {
    init_simple_test("aBFu8ll_Uc_S");
    static STRUCT_IF_C aBFu8ll_Uc_S lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Uc_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_S");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_S.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_S, aBFu8ll_Uc_S)
//============================================================================



static void Test_aBFu8ll_Uc_Uc()
{
  {
    init_simple_test("aBFu8ll_Uc_Uc");
    static STRUCT_IF_C aBFu8ll_Uc_Uc lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Uc_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_Uc");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_Uc.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_Uc, aBFu8ll_Uc_Uc)
//============================================================================



static void Test_aBFu8ll_Uc_Ui()
{
  {
    init_simple_test("aBFu8ll_Uc_Ui");
    static STRUCT_IF_C aBFu8ll_Uc_Ui lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Uc_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_Ui");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_Ui.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_Ui, aBFu8ll_Uc_Ui)
//============================================================================



static void Test_aBFu8ll_Uc_Ul()
{
  {
    init_simple_test("aBFu8ll_Uc_Ul");
    static STRUCT_IF_C aBFu8ll_Uc_Ul lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Uc_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_Ul");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_Ul.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_Ul, aBFu8ll_Uc_Ul)
//============================================================================



static void Test_aBFu8ll_Uc_Us()
{
  {
    init_simple_test("aBFu8ll_Uc_Us");
    static STRUCT_IF_C aBFu8ll_Uc_Us lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Uc_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_Us");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_Us.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_Us, aBFu8ll_Uc_Us)
//============================================================================



static void Test_aBFu8ll_Uc_Vp()
{
  {
    init_simple_test("aBFu8ll_Uc_Vp");
    static STRUCT_IF_C aBFu8ll_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Uc_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Uc_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Uc_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Uc_Vp");
    check_field_offset(lv, v2, 1, "aBFu8ll_Uc_Vp.v2");
    check_field_offset(lv, v3, 2, "aBFu8ll_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Uc_Vp, aBFu8ll_Uc_Vp)
//============================================================================



static void Test_aBFu8ll_Ui()
{
  {
    init_simple_test("aBFu8ll_Ui");
    static STRUCT_IF_C aBFu8ll_Ui lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui, aBFu8ll_Ui)
//============================================================================



static void Test_aBFu8ll_Ui_BFu15i()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu15i");
    static STRUCT_IF_C aBFu8ll_Ui_BFu15i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Ui_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aBFu8ll_Ui_BFu15i");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aBFu8ll_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu15i, aBFu8ll_Ui_BFu15i)
//============================================================================



static void Test_aBFu8ll_Ui_BFu15ll()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu15ll");
    static STRUCT_IF_C aBFu8ll_Ui_BFu15ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Ui_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aBFu8ll_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aBFu8ll_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu15ll, aBFu8ll_Ui_BFu15ll)
//============================================================================



static void Test_aBFu8ll_Ui_BFu15s()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu15s");
    static STRUCT_IF_C aBFu8ll_Ui_BFu15s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Ui_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 5, 0, 15, 1, "aBFu8ll_Ui_BFu15s");
    set_bf_and_test(lv, v3, 5, 0, 15, hide_ull(1LL<<14), "aBFu8ll_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu15s, aBFu8ll_Ui_BFu15s)
//============================================================================



static void Test_aBFu8ll_Ui_BFu16i()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu16i");
    static STRUCT_IF_C aBFu8ll_Ui_BFu16i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Ui_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aBFu8ll_Ui_BFu16i");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aBFu8ll_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu16i, aBFu8ll_Ui_BFu16i)
//============================================================================



static void Test_aBFu8ll_Ui_BFu16ll()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu16ll");
    static STRUCT_IF_C aBFu8ll_Ui_BFu16ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Ui_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aBFu8ll_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aBFu8ll_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu16ll, aBFu8ll_Ui_BFu16ll)
//============================================================================



static void Test_aBFu8ll_Ui_BFu16s()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu16s");
    static STRUCT_IF_C aBFu8ll_Ui_BFu16s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Ui_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 5, 0, 16, 1, "aBFu8ll_Ui_BFu16s");
    set_bf_and_test(lv, v3, 5, 0, 16, hide_ull(1LL<<15), "aBFu8ll_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu16s, aBFu8ll_Ui_BFu16s)
//============================================================================



static void Test_aBFu8ll_Ui_BFu17i()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu17i");
    static STRUCT_IF_C aBFu8ll_Ui_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu8ll_Ui_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aBFu8ll_Ui_BFu17i");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aBFu8ll_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu17i, aBFu8ll_Ui_BFu17i)
//============================================================================



static void Test_aBFu8ll_Ui_BFu17ll()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu17ll");
    static STRUCT_IF_C aBFu8ll_Ui_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu8ll_Ui_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 17, 1, "aBFu8ll_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 5, 0, 17, hide_ull(1LL<<16), "aBFu8ll_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu17ll, aBFu8ll_Ui_BFu17ll)
//============================================================================



static void Test_aBFu8ll_Ui_BFu1c()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu1c");
    static STRUCT_IF_C aBFu8ll_Ui_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aBFu8ll_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu1c, aBFu8ll_Ui_BFu1c)
//============================================================================



static void Test_aBFu8ll_Ui_BFu1i()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu1i");
    static STRUCT_IF_C aBFu8ll_Ui_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aBFu8ll_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu1i, aBFu8ll_Ui_BFu1i)
//============================================================================



static void Test_aBFu8ll_Ui_BFu1ll()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu1ll");
    static STRUCT_IF_C aBFu8ll_Ui_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aBFu8ll_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu1ll, aBFu8ll_Ui_BFu1ll)
//============================================================================



static void Test_aBFu8ll_Ui_BFu1s()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu1s");
    static STRUCT_IF_C aBFu8ll_Ui_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 5, 0, 1, 1, "aBFu8ll_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu1s, aBFu8ll_Ui_BFu1s)
//============================================================================



static void Test_aBFu8ll_Ui_BFu31i()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu31i");
    static STRUCT_IF_C aBFu8ll_Ui_BFu31i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_Ui_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aBFu8ll_Ui_BFu31i");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aBFu8ll_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu31i, aBFu8ll_Ui_BFu31i)
//============================================================================



static void Test_aBFu8ll_Ui_BFu31ll()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu31ll");
    static STRUCT_IF_C aBFu8ll_Ui_BFu31ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_Ui_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 31, 1, "aBFu8ll_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 5, 0, 31, hide_ull(1LL<<30), "aBFu8ll_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu31ll, aBFu8ll_Ui_BFu31ll)
//============================================================================



static void Test_aBFu8ll_Ui_BFu32i()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu32i");
    static STRUCT_IF_C aBFu8ll_Ui_BFu32i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_Ui_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aBFu8ll_Ui_BFu32i");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aBFu8ll_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu32i, aBFu8ll_Ui_BFu32i)
//============================================================================



static void Test_aBFu8ll_Ui_BFu32ll()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu32ll");
    static STRUCT_IF_C aBFu8ll_Ui_BFu32ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_Ui_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 32, 1, "aBFu8ll_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 5, 0, 32, hide_ull(1LL<<31), "aBFu8ll_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu32ll, aBFu8ll_Ui_BFu32ll)
//============================================================================



static void Test_aBFu8ll_Ui_BFu33()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu33");
    static STRUCT_IF_C aBFu8ll_Ui_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ui_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, 5, 0, 33, 1, "aBFu8ll_Ui_BFu33");
    set_bf_and_test(lv, v3, 5, 0, 33, hide_ull(1LL<<32), "aBFu8ll_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu33, aBFu8ll_Ui_BFu33)
//============================================================================



static void Test_aBFu8ll_Ui_BFu7c()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu7c");
    static STRUCT_IF_C aBFu8ll_Ui_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aBFu8ll_Ui_BFu7c");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu7c, aBFu8ll_Ui_BFu7c)
//============================================================================



static void Test_aBFu8ll_Ui_BFu7i()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu7i");
    static STRUCT_IF_C aBFu8ll_Ui_BFu7i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aBFu8ll_Ui_BFu7i");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu7i, aBFu8ll_Ui_BFu7i)
//============================================================================



static void Test_aBFu8ll_Ui_BFu7ll()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu7ll");
    static STRUCT_IF_C aBFu8ll_Ui_BFu7ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aBFu8ll_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu7ll, aBFu8ll_Ui_BFu7ll)
//============================================================================



static void Test_aBFu8ll_Ui_BFu7s()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu7s");
    static STRUCT_IF_C aBFu8ll_Ui_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 5, 0, 7, 1, "aBFu8ll_Ui_BFu7s");
    set_bf_and_test(lv, v3, 5, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu7s, aBFu8ll_Ui_BFu7s)
//============================================================================



static void Test_aBFu8ll_Ui_BFu8c()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu8c");
    static STRUCT_IF_C aBFu8ll_Ui_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aBFu8ll_Ui_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu8c, aBFu8ll_Ui_BFu8c)
//============================================================================



static void Test_aBFu8ll_Ui_BFu8i()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu8i");
    static STRUCT_IF_C aBFu8ll_Ui_BFu8i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aBFu8ll_Ui_BFu8i");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu8i, aBFu8ll_Ui_BFu8i)
//============================================================================



static void Test_aBFu8ll_Ui_BFu8ll()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu8ll");
    static STRUCT_IF_C aBFu8ll_Ui_BFu8ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aBFu8ll_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu8ll, aBFu8ll_Ui_BFu8ll)
//============================================================================



static void Test_aBFu8ll_Ui_BFu8s()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu8s");
    static STRUCT_IF_C aBFu8ll_Ui_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "aBFu8ll_Ui_BFu8s");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu8s, aBFu8ll_Ui_BFu8s)
//============================================================================



static void Test_aBFu8ll_Ui_BFu9i()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu9i");
    static STRUCT_IF_C aBFu8ll_Ui_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Ui_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aBFu8ll_Ui_BFu9i");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aBFu8ll_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu9i, aBFu8ll_Ui_BFu9i)
//============================================================================



static void Test_aBFu8ll_Ui_BFu9ll()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu9ll");
    static STRUCT_IF_C aBFu8ll_Ui_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Ui_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aBFu8ll_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aBFu8ll_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu9ll, aBFu8ll_Ui_BFu9ll)
//============================================================================



static void Test_aBFu8ll_Ui_BFu9s()
{
  {
    init_simple_test("aBFu8ll_Ui_BFu9s");
    static STRUCT_IF_C aBFu8ll_Ui_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Ui_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 5, 0, 9, 1, "aBFu8ll_Ui_BFu9s");
    set_bf_and_test(lv, v3, 5, 0, 9, hide_ull(1LL<<8), "aBFu8ll_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_BFu9s, aBFu8ll_Ui_BFu9s)
//============================================================================



static void Test_aBFu8ll_Ui_C()
{
  {
    init_simple_test("aBFu8ll_Ui_C");
    static STRUCT_IF_C aBFu8ll_Ui_C lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_C");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_C.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_C, aBFu8ll_Ui_C)
//============================================================================



static void Test_aBFu8ll_Ui_D()
{
  {
    init_simple_test("aBFu8ll_Ui_D");
    static STRUCT_IF_C aBFu8ll_Ui_D lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_Ui_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_D");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_D.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_D, aBFu8ll_Ui_D)
//============================================================================



static void Test_aBFu8ll_Ui_F()
{
  {
    init_simple_test("aBFu8ll_Ui_F");
    static STRUCT_IF_C aBFu8ll_Ui_F lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_Ui_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_F");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_F.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_F, aBFu8ll_Ui_F)
//============================================================================



static void Test_aBFu8ll_Ui_I()
{
  {
    init_simple_test("aBFu8ll_Ui_I");
    static STRUCT_IF_C aBFu8ll_Ui_I lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_Ui_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_I");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_I.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_I, aBFu8ll_Ui_I)
//============================================================================



static void Test_aBFu8ll_Ui_Ip()
{
  {
    init_simple_test("aBFu8ll_Ui_Ip");
    static STRUCT_IF_C aBFu8ll_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Ui_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_Ip");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_Ip.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_Ip, aBFu8ll_Ui_Ip)
//============================================================================



static void Test_aBFu8ll_Ui_L()
{
  {
    init_simple_test("aBFu8ll_Ui_L");
    static STRUCT_IF_C aBFu8ll_Ui_L lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_Ui_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_L");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_L.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_L, aBFu8ll_Ui_L)
//============================================================================



static void Test_aBFu8ll_Ui_S()
{
  {
    init_simple_test("aBFu8ll_Ui_S");
    static STRUCT_IF_C aBFu8ll_Ui_S lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Ui_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_S");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_S.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_S, aBFu8ll_Ui_S)
//============================================================================



static void Test_aBFu8ll_Ui_Uc()
{
  {
    init_simple_test("aBFu8ll_Ui_Uc");
    static STRUCT_IF_C aBFu8ll_Ui_Uc lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Ui_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_Uc");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_Uc.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_Uc, aBFu8ll_Ui_Uc)
//============================================================================



static void Test_aBFu8ll_Ui_Ui()
{
  {
    init_simple_test("aBFu8ll_Ui_Ui");
    static STRUCT_IF_C aBFu8ll_Ui_Ui lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_Ui_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_Ui");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_Ui.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_Ui, aBFu8ll_Ui_Ui)
//============================================================================



static void Test_aBFu8ll_Ui_Ul()
{
  {
    init_simple_test("aBFu8ll_Ui_Ul");
    static STRUCT_IF_C aBFu8ll_Ui_Ul lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_Ui_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_Ul");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_Ul.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_Ul, aBFu8ll_Ui_Ul)
//============================================================================



static void Test_aBFu8ll_Ui_Us()
{
  {
    init_simple_test("aBFu8ll_Ui_Us");
    static STRUCT_IF_C aBFu8ll_Ui_Us lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Ui_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_Us");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_Us.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_Us, aBFu8ll_Ui_Us)
//============================================================================



static void Test_aBFu8ll_Ui_Vp()
{
  {
    init_simple_test("aBFu8ll_Ui_Vp");
    static STRUCT_IF_C aBFu8ll_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Ui_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ui_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ui_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ui_Vp");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ui_Vp.v2");
    check_field_offset(lv, v3, 5, "aBFu8ll_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ui_Vp, aBFu8ll_Ui_Vp)
//============================================================================



static void Test_aBFu8ll_Ul()
{
  {
    init_simple_test("aBFu8ll_Ul");
    static STRUCT_IF_C aBFu8ll_Ul lv;
    check2(sizeof(lv), 9, "sizeof(aBFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul, aBFu8ll_Ul)
//============================================================================



static void Test_aBFu8ll_Ul_BFu15i()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu15i");
    static STRUCT_IF_C aBFu8ll_Ul_BFu15i lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Ul_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aBFu8ll_Ul_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aBFu8ll_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu15i, aBFu8ll_Ul_BFu15i)
//============================================================================



static void Test_aBFu8ll_Ul_BFu15ll()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu15ll");
    static STRUCT_IF_C aBFu8ll_Ul_BFu15ll lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Ul_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aBFu8ll_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aBFu8ll_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu15ll, aBFu8ll_Ul_BFu15ll)
//============================================================================



static void Test_aBFu8ll_Ul_BFu15s()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu15s");
    static STRUCT_IF_C aBFu8ll_Ul_BFu15s lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Ul_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "aBFu8ll_Ul_BFu15s");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "aBFu8ll_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu15s, aBFu8ll_Ul_BFu15s)
//============================================================================



static void Test_aBFu8ll_Ul_BFu16i()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu16i");
    static STRUCT_IF_C aBFu8ll_Ul_BFu16i lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Ul_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aBFu8ll_Ul_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aBFu8ll_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu16i, aBFu8ll_Ul_BFu16i)
//============================================================================



static void Test_aBFu8ll_Ul_BFu16ll()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu16ll");
    static STRUCT_IF_C aBFu8ll_Ul_BFu16ll lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Ul_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aBFu8ll_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aBFu8ll_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu16ll, aBFu8ll_Ul_BFu16ll)
//============================================================================



static void Test_aBFu8ll_Ul_BFu16s()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu16s");
    static STRUCT_IF_C aBFu8ll_Ul_BFu16s lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Ul_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "aBFu8ll_Ul_BFu16s");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "aBFu8ll_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu16s, aBFu8ll_Ul_BFu16s)
//============================================================================



static void Test_aBFu8ll_Ul_BFu17i()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu17i");
    static STRUCT_IF_C aBFu8ll_Ul_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(aBFu8ll_Ul_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aBFu8ll_Ul_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aBFu8ll_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu17i, aBFu8ll_Ul_BFu17i)
//============================================================================



static void Test_aBFu8ll_Ul_BFu17ll()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu17ll");
    static STRUCT_IF_C aBFu8ll_Ul_BFu17ll lv;
    check2(sizeof(lv), 12, "sizeof(aBFu8ll_Ul_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "aBFu8ll_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "aBFu8ll_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu17ll, aBFu8ll_Ul_BFu17ll)
//============================================================================



static void Test_aBFu8ll_Ul_BFu1c()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu1c");
    static STRUCT_IF_C aBFu8ll_Ul_BFu1c lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aBFu8ll_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu1c, aBFu8ll_Ul_BFu1c)
//============================================================================



static void Test_aBFu8ll_Ul_BFu1i()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu1i");
    static STRUCT_IF_C aBFu8ll_Ul_BFu1i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aBFu8ll_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu1i, aBFu8ll_Ul_BFu1i)
//============================================================================



static void Test_aBFu8ll_Ul_BFu1ll()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu1ll");
    static STRUCT_IF_C aBFu8ll_Ul_BFu1ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aBFu8ll_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu1ll, aBFu8ll_Ul_BFu1ll)
//============================================================================



static void Test_aBFu8ll_Ul_BFu1s()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu1s");
    static STRUCT_IF_C aBFu8ll_Ul_BFu1s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "aBFu8ll_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu1s, aBFu8ll_Ul_BFu1s)
//============================================================================



static void Test_aBFu8ll_Ul_BFu31i()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu31i");
    static STRUCT_IF_C aBFu8ll_Ul_BFu31i lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_Ul_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aBFu8ll_Ul_BFu31i");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aBFu8ll_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu31i, aBFu8ll_Ul_BFu31i)
//============================================================================



static void Test_aBFu8ll_Ul_BFu31ll()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu31ll");
    static STRUCT_IF_C aBFu8ll_Ul_BFu31ll lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_Ul_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "aBFu8ll_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "aBFu8ll_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu31ll, aBFu8ll_Ul_BFu31ll)
//============================================================================



static void Test_aBFu8ll_Ul_BFu32i()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu32i");
    static STRUCT_IF_C aBFu8ll_Ul_BFu32i lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_Ul_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aBFu8ll_Ul_BFu32i");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aBFu8ll_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu32i, aBFu8ll_Ul_BFu32i)
//============================================================================



static void Test_aBFu8ll_Ul_BFu32ll()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu32ll");
    static STRUCT_IF_C aBFu8ll_Ul_BFu32ll lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_Ul_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "aBFu8ll_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "aBFu8ll_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu32ll, aBFu8ll_Ul_BFu32ll)
//============================================================================



static void Test_aBFu8ll_Ul_BFu33()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu33");
    static STRUCT_IF_C aBFu8ll_Ul_BFu33 lv;
    check2(sizeof(lv), 14, "sizeof(aBFu8ll_Ul_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "aBFu8ll_Ul_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "aBFu8ll_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu33, aBFu8ll_Ul_BFu33)
//============================================================================



static void Test_aBFu8ll_Ul_BFu7c()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu7c");
    static STRUCT_IF_C aBFu8ll_Ul_BFu7c lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aBFu8ll_Ul_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu7c, aBFu8ll_Ul_BFu7c)
//============================================================================



static void Test_aBFu8ll_Ul_BFu7i()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu7i");
    static STRUCT_IF_C aBFu8ll_Ul_BFu7i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aBFu8ll_Ul_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu7i, aBFu8ll_Ul_BFu7i)
//============================================================================



static void Test_aBFu8ll_Ul_BFu7ll()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu7ll");
    static STRUCT_IF_C aBFu8ll_Ul_BFu7ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aBFu8ll_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu7ll, aBFu8ll_Ul_BFu7ll)
//============================================================================



static void Test_aBFu8ll_Ul_BFu7s()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu7s");
    static STRUCT_IF_C aBFu8ll_Ul_BFu7s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "aBFu8ll_Ul_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu7s, aBFu8ll_Ul_BFu7s)
//============================================================================



static void Test_aBFu8ll_Ul_BFu8c()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu8c");
    static STRUCT_IF_C aBFu8ll_Ul_BFu8c lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aBFu8ll_Ul_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu8c, aBFu8ll_Ul_BFu8c)
//============================================================================



static void Test_aBFu8ll_Ul_BFu8i()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu8i");
    static STRUCT_IF_C aBFu8ll_Ul_BFu8i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aBFu8ll_Ul_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu8i, aBFu8ll_Ul_BFu8i)
//============================================================================



static void Test_aBFu8ll_Ul_BFu8ll()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu8ll");
    static STRUCT_IF_C aBFu8ll_Ul_BFu8ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aBFu8ll_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu8ll, aBFu8ll_Ul_BFu8ll)
//============================================================================



static void Test_aBFu8ll_Ul_BFu8s()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu8s");
    static STRUCT_IF_C aBFu8ll_Ul_BFu8s lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "aBFu8ll_Ul_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu8s, aBFu8ll_Ul_BFu8s)
//============================================================================



static void Test_aBFu8ll_Ul_BFu9i()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu9i");
    static STRUCT_IF_C aBFu8ll_Ul_BFu9i lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Ul_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aBFu8ll_Ul_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aBFu8ll_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu9i, aBFu8ll_Ul_BFu9i)
//============================================================================



static void Test_aBFu8ll_Ul_BFu9ll()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu9ll");
    static STRUCT_IF_C aBFu8ll_Ul_BFu9ll lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Ul_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aBFu8ll_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aBFu8ll_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu9ll, aBFu8ll_Ul_BFu9ll)
//============================================================================



static void Test_aBFu8ll_Ul_BFu9s()
{
  {
    init_simple_test("aBFu8ll_Ul_BFu9s");
    static STRUCT_IF_C aBFu8ll_Ul_BFu9s lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Ul_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "aBFu8ll_Ul_BFu9s");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "aBFu8ll_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_BFu9s, aBFu8ll_Ul_BFu9s)
//============================================================================



static void Test_aBFu8ll_Ul_C()
{
  {
    init_simple_test("aBFu8ll_Ul_C");
    static STRUCT_IF_C aBFu8ll_Ul_C lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_C");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_C.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_C, aBFu8ll_Ul_C)
//============================================================================



static void Test_aBFu8ll_Ul_D()
{
  {
    init_simple_test("aBFu8ll_Ul_D");
    static STRUCT_IF_C aBFu8ll_Ul_D lv;
    check2(sizeof(lv), 17, "sizeof(aBFu8ll_Ul_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_D");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_D.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_D, aBFu8ll_Ul_D)
//============================================================================



static void Test_aBFu8ll_Ul_F()
{
  {
    init_simple_test("aBFu8ll_Ul_F");
    static STRUCT_IF_C aBFu8ll_Ul_F lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_Ul_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_F");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_F.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_F, aBFu8ll_Ul_F)
//============================================================================



static void Test_aBFu8ll_Ul_I()
{
  {
    init_simple_test("aBFu8ll_Ul_I");
    static STRUCT_IF_C aBFu8ll_Ul_I lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_Ul_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_I");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_I.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_I, aBFu8ll_Ul_I)
//============================================================================



static void Test_aBFu8ll_Ul_Ip()
{
  {
    init_simple_test("aBFu8ll_Ul_Ip");
    static STRUCT_IF_C aBFu8ll_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aBFu8ll_Ul_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_Ip");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_Ip.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_Ip, aBFu8ll_Ul_Ip)
//============================================================================



static void Test_aBFu8ll_Ul_L()
{
  {
    init_simple_test("aBFu8ll_Ul_L");
    static STRUCT_IF_C aBFu8ll_Ul_L lv;
    check2(sizeof(lv), 17, "sizeof(aBFu8ll_Ul_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_L");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_L.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_L, aBFu8ll_Ul_L)
//============================================================================



static void Test_aBFu8ll_Ul_S()
{
  {
    init_simple_test("aBFu8ll_Ul_S");
    static STRUCT_IF_C aBFu8ll_Ul_S lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Ul_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_S");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_S.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_S, aBFu8ll_Ul_S)
//============================================================================



static void Test_aBFu8ll_Ul_Uc()
{
  {
    init_simple_test("aBFu8ll_Ul_Uc");
    static STRUCT_IF_C aBFu8ll_Ul_Uc lv;
    check2(sizeof(lv), 10, "sizeof(aBFu8ll_Ul_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_Uc");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_Uc.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_Uc, aBFu8ll_Ul_Uc)
//============================================================================



static void Test_aBFu8ll_Ul_Ui()
{
  {
    init_simple_test("aBFu8ll_Ul_Ui");
    static STRUCT_IF_C aBFu8ll_Ul_Ui lv;
    check2(sizeof(lv), 13, "sizeof(aBFu8ll_Ul_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_Ui");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_Ui.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_Ui, aBFu8ll_Ul_Ui)
//============================================================================



static void Test_aBFu8ll_Ul_Ul()
{
  {
    init_simple_test("aBFu8ll_Ul_Ul");
    static STRUCT_IF_C aBFu8ll_Ul_Ul lv;
    check2(sizeof(lv), 17, "sizeof(aBFu8ll_Ul_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_Ul");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_Ul.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_Ul, aBFu8ll_Ul_Ul)
//============================================================================



static void Test_aBFu8ll_Ul_Us()
{
  {
    init_simple_test("aBFu8ll_Ul_Us");
    static STRUCT_IF_C aBFu8ll_Ul_Us lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Ul_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_Us");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_Us.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_Us, aBFu8ll_Ul_Us)
//============================================================================



static void Test_aBFu8ll_Ul_Vp()
{
  {
    init_simple_test("aBFu8ll_Ul_Vp");
    static STRUCT_IF_C aBFu8ll_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aBFu8ll_Ul_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Ul_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Ul_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Ul_Vp");
    check_field_offset(lv, v2, 1, "aBFu8ll_Ul_Vp.v2");
    check_field_offset(lv, v3, 9, "aBFu8ll_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Ul_Vp, aBFu8ll_Ul_Vp)
//============================================================================



static void Test_aBFu8ll_Us()
{
  {
    init_simple_test("aBFu8ll_Us");
    static STRUCT_IF_C aBFu8ll_Us lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us, aBFu8ll_Us)
//============================================================================



static void Test_aBFu8ll_Us_BFu15i()
{
  {
    init_simple_test("aBFu8ll_Us_BFu15i");
    static STRUCT_IF_C aBFu8ll_Us_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Us_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu8ll_Us_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu8ll_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu15i, aBFu8ll_Us_BFu15i)
//============================================================================



static void Test_aBFu8ll_Us_BFu15ll()
{
  {
    init_simple_test("aBFu8ll_Us_BFu15ll");
    static STRUCT_IF_C aBFu8ll_Us_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Us_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu8ll_Us_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu8ll_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu15ll, aBFu8ll_Us_BFu15ll)
//============================================================================



static void Test_aBFu8ll_Us_BFu15s()
{
  {
    init_simple_test("aBFu8ll_Us_BFu15s");
    static STRUCT_IF_C aBFu8ll_Us_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Us_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu8ll_Us_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu8ll_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu15s, aBFu8ll_Us_BFu15s)
//============================================================================



static void Test_aBFu8ll_Us_BFu16i()
{
  {
    init_simple_test("aBFu8ll_Us_BFu16i");
    static STRUCT_IF_C aBFu8ll_Us_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Us_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu8ll_Us_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu8ll_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu16i, aBFu8ll_Us_BFu16i)
//============================================================================



static void Test_aBFu8ll_Us_BFu16ll()
{
  {
    init_simple_test("aBFu8ll_Us_BFu16ll");
    static STRUCT_IF_C aBFu8ll_Us_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Us_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu8ll_Us_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu8ll_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu16ll, aBFu8ll_Us_BFu16ll)
//============================================================================



static void Test_aBFu8ll_Us_BFu16s()
{
  {
    init_simple_test("aBFu8ll_Us_BFu16s");
    static STRUCT_IF_C aBFu8ll_Us_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Us_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu8ll_Us_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu8ll_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu16s, aBFu8ll_Us_BFu16s)
//============================================================================



static void Test_aBFu8ll_Us_BFu17i()
{
  {
    init_simple_test("aBFu8ll_Us_BFu17i");
    static STRUCT_IF_C aBFu8ll_Us_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Us_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu8ll_Us_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu8ll_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu17i, aBFu8ll_Us_BFu17i)
//============================================================================



static void Test_aBFu8ll_Us_BFu17ll()
{
  {
    init_simple_test("aBFu8ll_Us_BFu17ll");
    static STRUCT_IF_C aBFu8ll_Us_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu8ll_Us_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu8ll_Us_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu8ll_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu17ll, aBFu8ll_Us_BFu17ll)
//============================================================================



static void Test_aBFu8ll_Us_BFu1c()
{
  {
    init_simple_test("aBFu8ll_Us_BFu1c");
    static STRUCT_IF_C aBFu8ll_Us_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu8ll_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu1c, aBFu8ll_Us_BFu1c)
//============================================================================



static void Test_aBFu8ll_Us_BFu1i()
{
  {
    init_simple_test("aBFu8ll_Us_BFu1i");
    static STRUCT_IF_C aBFu8ll_Us_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu8ll_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu1i, aBFu8ll_Us_BFu1i)
//============================================================================



static void Test_aBFu8ll_Us_BFu1ll()
{
  {
    init_simple_test("aBFu8ll_Us_BFu1ll");
    static STRUCT_IF_C aBFu8ll_Us_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu8ll_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu1ll, aBFu8ll_Us_BFu1ll)
//============================================================================



static void Test_aBFu8ll_Us_BFu1s()
{
  {
    init_simple_test("aBFu8ll_Us_BFu1s");
    static STRUCT_IF_C aBFu8ll_Us_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu8ll_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu1s, aBFu8ll_Us_BFu1s)
//============================================================================



static void Test_aBFu8ll_Us_BFu31i()
{
  {
    init_simple_test("aBFu8ll_Us_BFu31i");
    static STRUCT_IF_C aBFu8ll_Us_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Us_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu8ll_Us_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu8ll_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu31i, aBFu8ll_Us_BFu31i)
//============================================================================



static void Test_aBFu8ll_Us_BFu31ll()
{
  {
    init_simple_test("aBFu8ll_Us_BFu31ll");
    static STRUCT_IF_C aBFu8ll_Us_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Us_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu8ll_Us_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu8ll_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu31ll, aBFu8ll_Us_BFu31ll)
//============================================================================



static void Test_aBFu8ll_Us_BFu32i()
{
  {
    init_simple_test("aBFu8ll_Us_BFu32i");
    static STRUCT_IF_C aBFu8ll_Us_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Us_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu8ll_Us_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu8ll_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu32i, aBFu8ll_Us_BFu32i)
//============================================================================



static void Test_aBFu8ll_Us_BFu32ll()
{
  {
    init_simple_test("aBFu8ll_Us_BFu32ll");
    static STRUCT_IF_C aBFu8ll_Us_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Us_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu8ll_Us_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu8ll_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu32ll, aBFu8ll_Us_BFu32ll)
//============================================================================



static void Test_aBFu8ll_Us_BFu33()
{
  {
    init_simple_test("aBFu8ll_Us_BFu33");
    static STRUCT_IF_C aBFu8ll_Us_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aBFu8ll_Us_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aBFu8ll_Us_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aBFu8ll_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu33, aBFu8ll_Us_BFu33)
//============================================================================



static void Test_aBFu8ll_Us_BFu7c()
{
  {
    init_simple_test("aBFu8ll_Us_BFu7c");
    static STRUCT_IF_C aBFu8ll_Us_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu8ll_Us_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu7c, aBFu8ll_Us_BFu7c)
//============================================================================



static void Test_aBFu8ll_Us_BFu7i()
{
  {
    init_simple_test("aBFu8ll_Us_BFu7i");
    static STRUCT_IF_C aBFu8ll_Us_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu8ll_Us_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu7i, aBFu8ll_Us_BFu7i)
//============================================================================



static void Test_aBFu8ll_Us_BFu7ll()
{
  {
    init_simple_test("aBFu8ll_Us_BFu7ll");
    static STRUCT_IF_C aBFu8ll_Us_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu8ll_Us_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu7ll, aBFu8ll_Us_BFu7ll)
//============================================================================



static void Test_aBFu8ll_Us_BFu7s()
{
  {
    init_simple_test("aBFu8ll_Us_BFu7s");
    static STRUCT_IF_C aBFu8ll_Us_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu8ll_Us_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu8ll_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu7s, aBFu8ll_Us_BFu7s)
//============================================================================



static void Test_aBFu8ll_Us_BFu8c()
{
  {
    init_simple_test("aBFu8ll_Us_BFu8c");
    static STRUCT_IF_C aBFu8ll_Us_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu8ll_Us_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu8c, aBFu8ll_Us_BFu8c)
//============================================================================



static void Test_aBFu8ll_Us_BFu8i()
{
  {
    init_simple_test("aBFu8ll_Us_BFu8i");
    static STRUCT_IF_C aBFu8ll_Us_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu8ll_Us_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu8i, aBFu8ll_Us_BFu8i)
//============================================================================



static void Test_aBFu8ll_Us_BFu8ll()
{
  {
    init_simple_test("aBFu8ll_Us_BFu8ll");
    static STRUCT_IF_C aBFu8ll_Us_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu8ll_Us_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu8ll, aBFu8ll_Us_BFu8ll)
//============================================================================



static void Test_aBFu8ll_Us_BFu8s()
{
  {
    init_simple_test("aBFu8ll_Us_BFu8s");
    static STRUCT_IF_C aBFu8ll_Us_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu8ll_Us_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu8s, aBFu8ll_Us_BFu8s)
//============================================================================



static void Test_aBFu8ll_Us_BFu9i()
{
  {
    init_simple_test("aBFu8ll_Us_BFu9i");
    static STRUCT_IF_C aBFu8ll_Us_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Us_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu8ll_Us_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu8ll_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu9i, aBFu8ll_Us_BFu9i)
//============================================================================



static void Test_aBFu8ll_Us_BFu9ll()
{
  {
    init_simple_test("aBFu8ll_Us_BFu9ll");
    static STRUCT_IF_C aBFu8ll_Us_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Us_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu8ll_Us_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu8ll_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu9ll, aBFu8ll_Us_BFu9ll)
//============================================================================



static void Test_aBFu8ll_Us_BFu9s()
{
  {
    init_simple_test("aBFu8ll_Us_BFu9s");
    static STRUCT_IF_C aBFu8ll_Us_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Us_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu8ll_Us_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu8ll_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_BFu9s, aBFu8ll_Us_BFu9s)
//============================================================================



static void Test_aBFu8ll_Us_C()
{
  {
    init_simple_test("aBFu8ll_Us_C");
    static STRUCT_IF_C aBFu8ll_Us_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_C");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_C.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_C, aBFu8ll_Us_C)
//============================================================================



static void Test_aBFu8ll_Us_D()
{
  {
    init_simple_test("aBFu8ll_Us_D");
    static STRUCT_IF_C aBFu8ll_Us_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Us_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_D");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_D.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_D, aBFu8ll_Us_D)
//============================================================================



static void Test_aBFu8ll_Us_F()
{
  {
    init_simple_test("aBFu8ll_Us_F");
    static STRUCT_IF_C aBFu8ll_Us_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Us_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_F");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_F.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_F, aBFu8ll_Us_F)
//============================================================================



static void Test_aBFu8ll_Us_I()
{
  {
    init_simple_test("aBFu8ll_Us_I");
    static STRUCT_IF_C aBFu8ll_Us_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Us_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_I");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_I.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_I, aBFu8ll_Us_I)
//============================================================================



static void Test_aBFu8ll_Us_Ip()
{
  {
    init_simple_test("aBFu8ll_Us_Ip");
    static STRUCT_IF_C aBFu8ll_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Us_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_Ip");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_Ip.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_Ip, aBFu8ll_Us_Ip)
//============================================================================



static void Test_aBFu8ll_Us_L()
{
  {
    init_simple_test("aBFu8ll_Us_L");
    static STRUCT_IF_C aBFu8ll_Us_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Us_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_L");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_L.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_L, aBFu8ll_Us_L)
//============================================================================



static void Test_aBFu8ll_Us_S()
{
  {
    init_simple_test("aBFu8ll_Us_S");
    static STRUCT_IF_C aBFu8ll_Us_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Us_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_S");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_S.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_S, aBFu8ll_Us_S)
//============================================================================



static void Test_aBFu8ll_Us_Uc()
{
  {
    init_simple_test("aBFu8ll_Us_Uc");
    static STRUCT_IF_C aBFu8ll_Us_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8ll_Us_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_Uc");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_Uc.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_Uc, aBFu8ll_Us_Uc)
//============================================================================



static void Test_aBFu8ll_Us_Ui()
{
  {
    init_simple_test("aBFu8ll_Us_Ui");
    static STRUCT_IF_C aBFu8ll_Us_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8ll_Us_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_Ui");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_Ui.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_Ui, aBFu8ll_Us_Ui)
//============================================================================



static void Test_aBFu8ll_Us_Ul()
{
  {
    init_simple_test("aBFu8ll_Us_Ul");
    static STRUCT_IF_C aBFu8ll_Us_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8ll_Us_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_Ul");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_Ul.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_Ul, aBFu8ll_Us_Ul)
//============================================================================



static void Test_aBFu8ll_Us_Us()
{
  {
    init_simple_test("aBFu8ll_Us_Us");
    static STRUCT_IF_C aBFu8ll_Us_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8ll_Us_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_Us");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_Us.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_Us, aBFu8ll_Us_Us)
//============================================================================



static void Test_aBFu8ll_Us_Vp()
{
  {
    init_simple_test("aBFu8ll_Us_Vp");
    static STRUCT_IF_C aBFu8ll_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Us_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Us_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Us_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Us_Vp");
    check_field_offset(lv, v2, 1, "aBFu8ll_Us_Vp.v2");
    check_field_offset(lv, v3, 3, "aBFu8ll_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Us_Vp, aBFu8ll_Us_Vp)
//============================================================================



static void Test_aBFu8ll_Vp()
{
  {
    init_simple_test("aBFu8ll_Vp");
    static STRUCT_IF_C aBFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(9,5), "sizeof(aBFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp, aBFu8ll_Vp)
//============================================================================



static void Test_aBFu8ll_Vp_BFu15i()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu15i");
    static STRUCT_IF_C aBFu8ll_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Vp_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu15i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aBFu8ll_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aBFu8ll_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu15i, aBFu8ll_Vp_BFu15i)
//============================================================================



static void Test_aBFu8ll_Vp_BFu15ll()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu15ll");
    static STRUCT_IF_C aBFu8ll_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Vp_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu15ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aBFu8ll_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aBFu8ll_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu15ll, aBFu8ll_Vp_BFu15ll)
//============================================================================



static void Test_aBFu8ll_Vp_BFu15s()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu15s");
    static STRUCT_IF_C aBFu8ll_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Vp_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu15s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, 1, "aBFu8ll_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 15, hide_ull(1LL<<14), "aBFu8ll_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu15s, aBFu8ll_Vp_BFu15s)
//============================================================================



static void Test_aBFu8ll_Vp_BFu16i()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu16i");
    static STRUCT_IF_C aBFu8ll_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Vp_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu16i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aBFu8ll_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aBFu8ll_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu16i, aBFu8ll_Vp_BFu16i)
//============================================================================



static void Test_aBFu8ll_Vp_BFu16ll()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu16ll");
    static STRUCT_IF_C aBFu8ll_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Vp_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu16ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aBFu8ll_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aBFu8ll_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu16ll, aBFu8ll_Vp_BFu16ll)
//============================================================================



static void Test_aBFu8ll_Vp_BFu16s()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu16s");
    static STRUCT_IF_C aBFu8ll_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Vp_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu16s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, 1, "aBFu8ll_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 16, hide_ull(1LL<<15), "aBFu8ll_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu16s, aBFu8ll_Vp_BFu16s)
//============================================================================



static void Test_aBFu8ll_Vp_BFu17i()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu17i");
    static STRUCT_IF_C aBFu8ll_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu8ll_Vp_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu17i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aBFu8ll_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aBFu8ll_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu17i, aBFu8ll_Vp_BFu17i)
//============================================================================



static void Test_aBFu8ll_Vp_BFu17ll()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu17ll");
    static STRUCT_IF_C aBFu8ll_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu8ll_Vp_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu17ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, 1, "aBFu8ll_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 17, hide_ull(1LL<<16), "aBFu8ll_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu17ll, aBFu8ll_Vp_BFu17ll)
//============================================================================



static void Test_aBFu8ll_Vp_BFu1c()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu1c");
    static STRUCT_IF_C aBFu8ll_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu1c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aBFu8ll_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu1c, aBFu8ll_Vp_BFu1c)
//============================================================================



static void Test_aBFu8ll_Vp_BFu1i()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu1i");
    static STRUCT_IF_C aBFu8ll_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu1i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aBFu8ll_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu1i, aBFu8ll_Vp_BFu1i)
//============================================================================



static void Test_aBFu8ll_Vp_BFu1ll()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu1ll");
    static STRUCT_IF_C aBFu8ll_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu1ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aBFu8ll_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu1ll, aBFu8ll_Vp_BFu1ll)
//============================================================================



static void Test_aBFu8ll_Vp_BFu1s()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu1s");
    static STRUCT_IF_C aBFu8ll_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu1s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 1, 1, "aBFu8ll_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu1s, aBFu8ll_Vp_BFu1s)
//============================================================================



static void Test_aBFu8ll_Vp_BFu31i()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu31i");
    static STRUCT_IF_C aBFu8ll_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Vp_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu31i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aBFu8ll_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aBFu8ll_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu31i, aBFu8ll_Vp_BFu31i)
//============================================================================



static void Test_aBFu8ll_Vp_BFu31ll()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu31ll");
    static STRUCT_IF_C aBFu8ll_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Vp_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu31ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, 1, "aBFu8ll_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 31, hide_ull(1LL<<30), "aBFu8ll_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu31ll, aBFu8ll_Vp_BFu31ll)
//============================================================================



static void Test_aBFu8ll_Vp_BFu32i()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu32i");
    static STRUCT_IF_C aBFu8ll_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Vp_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu32i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aBFu8ll_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aBFu8ll_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu32i, aBFu8ll_Vp_BFu32i)
//============================================================================



static void Test_aBFu8ll_Vp_BFu32ll()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu32ll");
    static STRUCT_IF_C aBFu8ll_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Vp_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu32ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, 1, "aBFu8ll_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 32, hide_ull(1LL<<31), "aBFu8ll_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu32ll, aBFu8ll_Vp_BFu32ll)
//============================================================================



static void Test_aBFu8ll_Vp_BFu33()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu33");
    static STRUCT_IF_C aBFu8ll_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu8ll_Vp_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu33");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, 1, "aBFu8ll_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 33, hide_ull(1LL<<32), "aBFu8ll_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu33, aBFu8ll_Vp_BFu33)
//============================================================================



static void Test_aBFu8ll_Vp_BFu7c()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu7c");
    static STRUCT_IF_C aBFu8ll_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu7c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aBFu8ll_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aBFu8ll_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu7c, aBFu8ll_Vp_BFu7c)
//============================================================================



static void Test_aBFu8ll_Vp_BFu7i()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu7i");
    static STRUCT_IF_C aBFu8ll_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu7i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aBFu8ll_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aBFu8ll_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu7i, aBFu8ll_Vp_BFu7i)
//============================================================================



static void Test_aBFu8ll_Vp_BFu7ll()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu7ll");
    static STRUCT_IF_C aBFu8ll_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu7ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aBFu8ll_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aBFu8ll_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu7ll, aBFu8ll_Vp_BFu7ll)
//============================================================================



static void Test_aBFu8ll_Vp_BFu7s()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu7s");
    static STRUCT_IF_C aBFu8ll_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu7s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, 1, "aBFu8ll_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 7, hide_ull(1LL<<6), "aBFu8ll_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu7s, aBFu8ll_Vp_BFu7s)
//============================================================================



static void Test_aBFu8ll_Vp_BFu8c()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu8c");
    static STRUCT_IF_C aBFu8ll_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu8c");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aBFu8ll_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu8c, aBFu8ll_Vp_BFu8c)
//============================================================================



static void Test_aBFu8ll_Vp_BFu8i()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu8i");
    static STRUCT_IF_C aBFu8ll_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu8i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aBFu8ll_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu8i, aBFu8ll_Vp_BFu8i)
//============================================================================



static void Test_aBFu8ll_Vp_BFu8ll()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu8ll");
    static STRUCT_IF_C aBFu8ll_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu8ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aBFu8ll_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu8ll, aBFu8ll_Vp_BFu8ll)
//============================================================================



static void Test_aBFu8ll_Vp_BFu8s()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu8s");
    static STRUCT_IF_C aBFu8ll_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu8s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, 1, "aBFu8ll_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu8s, aBFu8ll_Vp_BFu8s)
//============================================================================



static void Test_aBFu8ll_Vp_BFu9i()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu9i");
    static STRUCT_IF_C aBFu8ll_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Vp_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu9i");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aBFu8ll_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aBFu8ll_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu9i, aBFu8ll_Vp_BFu9i)
//============================================================================



static void Test_aBFu8ll_Vp_BFu9ll()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu9ll");
    static STRUCT_IF_C aBFu8ll_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Vp_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu9ll");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aBFu8ll_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aBFu8ll_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu9ll, aBFu8ll_Vp_BFu9ll)
//============================================================================



static void Test_aBFu8ll_Vp_BFu9s()
{
  {
    init_simple_test("aBFu8ll_Vp_BFu9s");
    static STRUCT_IF_C aBFu8ll_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Vp_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_BFu9s");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, 1, "aBFu8ll_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(9,5), 0, 9, hide_ull(1LL<<8), "aBFu8ll_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_BFu9s, aBFu8ll_Vp_BFu9s)
//============================================================================



static void Test_aBFu8ll_Vp_C()
{
  {
    init_simple_test("aBFu8ll_Vp_C");
    static STRUCT_IF_C aBFu8ll_Vp_C lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_C");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_C, aBFu8ll_Vp_C)
//============================================================================



static void Test_aBFu8ll_Vp_D()
{
  {
    init_simple_test("aBFu8ll_Vp_D");
    static STRUCT_IF_C aBFu8ll_Vp_D lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aBFu8ll_Vp_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_D");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_D, aBFu8ll_Vp_D)
//============================================================================



static void Test_aBFu8ll_Vp_F()
{
  {
    init_simple_test("aBFu8ll_Vp_F");
    static STRUCT_IF_C aBFu8ll_Vp_F lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Vp_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_F");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_F, aBFu8ll_Vp_F)
//============================================================================



static void Test_aBFu8ll_Vp_I()
{
  {
    init_simple_test("aBFu8ll_Vp_I");
    static STRUCT_IF_C aBFu8ll_Vp_I lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Vp_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_I");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_I, aBFu8ll_Vp_I)
//============================================================================



static void Test_aBFu8ll_Vp_Ip()
{
  {
    init_simple_test("aBFu8ll_Vp_Ip");
    static STRUCT_IF_C aBFu8ll_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aBFu8ll_Vp_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_Ip");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_Ip");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_Ip, aBFu8ll_Vp_Ip)
//============================================================================



static void Test_aBFu8ll_Vp_L()
{
  {
    init_simple_test("aBFu8ll_Vp_L");
    static STRUCT_IF_C aBFu8ll_Vp_L lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aBFu8ll_Vp_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_L)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_L");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_L");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_L, aBFu8ll_Vp_L)
//============================================================================



static void Test_aBFu8ll_Vp_S()
{
  {
    init_simple_test("aBFu8ll_Vp_S");
    static STRUCT_IF_C aBFu8ll_Vp_S lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Vp_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_S)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_S");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_S");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_S, aBFu8ll_Vp_S)
//============================================================================



static void Test_aBFu8ll_Vp_Uc()
{
  {
    init_simple_test("aBFu8ll_Vp_Uc");
    static STRUCT_IF_C aBFu8ll_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(10,6), "sizeof(aBFu8ll_Vp_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_Uc");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_Uc");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_Uc, aBFu8ll_Vp_Uc)
//============================================================================



static void Test_aBFu8ll_Vp_Ui()
{
  {
    init_simple_test("aBFu8ll_Vp_Ui");
    static STRUCT_IF_C aBFu8ll_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(13,9), "sizeof(aBFu8ll_Vp_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_Ui");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_Ui");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_Ui, aBFu8ll_Vp_Ui)
//============================================================================



static void Test_aBFu8ll_Vp_Ul()
{
  {
    init_simple_test("aBFu8ll_Vp_Ul");
    static STRUCT_IF_C aBFu8ll_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(17,13), "sizeof(aBFu8ll_Vp_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_Ul");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_Ul");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_Ul, aBFu8ll_Vp_Ul)
//============================================================================



static void Test_aBFu8ll_Vp_Us()
{
  {
    init_simple_test("aBFu8ll_Vp_Us");
    static STRUCT_IF_C aBFu8ll_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu8ll_Vp_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_Us)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_Us");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_Us");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_Us, aBFu8ll_Vp_Us)
//============================================================================



static void Test_aBFu8ll_Vp_Vp()
{
  {
    init_simple_test("aBFu8ll_Vp_Vp");
    static STRUCT_IF_C aBFu8ll_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(17,9), "sizeof(aBFu8ll_Vp_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8ll_Vp_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8ll_Vp_Vp");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8ll_Vp_Vp");
    check_field_offset(lv, v2, 1, "aBFu8ll_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(9,5), "aBFu8ll_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8ll_Vp_Vp, aBFu8ll_Vp_Vp)
//============================================================================



static void Test_aBFu8s()
{
  {
    init_simple_test("aBFu8s");
    static STRUCT_IF_C aBFu8s lv;
    check2(sizeof(lv), 1, "sizeof(aBFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s, aBFu8s)
//============================================================================



static void Test_aBFu8s_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8c lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c, aBFu8s_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8c, aBFu8s_BFs8c_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8c_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8c_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8c_BFs8c, aBFu8s_BFs8c_BFs8c_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8c_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8c_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8c_BFs8i, aBFu8s_BFs8c_BFs8c_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8c_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8c_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8c_BFs8ll, aBFu8s_BFs8c_BFs8c_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8c_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8c_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8c_BFs8s, aBFu8s_BFs8c_BFs8c_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8c_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8c_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8c_BFu8c, aBFu8s_BFs8c_BFs8c_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8c_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8c_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8c_BFu8i, aBFu8s_BFs8c_BFs8c_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8c_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8c_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8c_BFu8ll, aBFu8s_BFs8c_BFs8c_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8c_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8c_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8c_BFu8s, aBFu8s_BFs8c_BFs8c_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8i, aBFu8s_BFs8c_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8i_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8i_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8i_BFs8c, aBFu8s_BFs8c_BFs8i_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8i_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8i_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8i_BFs8i, aBFu8s_BFs8c_BFs8i_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8i_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8i_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8i_BFs8ll, aBFu8s_BFs8c_BFs8i_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8i_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8i_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8i_BFs8s, aBFu8s_BFs8c_BFs8i_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8i_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8i_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8i_BFu8c, aBFu8s_BFs8c_BFs8i_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8i_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8i_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8i_BFu8i, aBFu8s_BFs8c_BFs8i_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8i_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8i_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8i_BFu8ll, aBFu8s_BFs8c_BFs8i_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8i_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8i_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8i_BFu8s, aBFu8s_BFs8c_BFs8i_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8ll, aBFu8s_BFs8c_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8ll_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8ll_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8ll_BFs8c, aBFu8s_BFs8c_BFs8ll_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8ll_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8ll_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8ll_BFs8i, aBFu8s_BFs8c_BFs8ll_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8ll_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8ll_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8ll_BFs8ll, aBFu8s_BFs8c_BFs8ll_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8ll_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8ll_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8ll_BFs8s, aBFu8s_BFs8c_BFs8ll_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8ll_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8ll_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8ll_BFu8c, aBFu8s_BFs8c_BFs8ll_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8ll_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8ll_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8ll_BFu8i, aBFu8s_BFs8c_BFs8ll_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8ll_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8ll_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8ll_BFu8ll, aBFu8s_BFs8c_BFs8ll_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8ll_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8ll_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8ll_BFu8s, aBFu8s_BFs8c_BFs8ll_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8s, aBFu8s_BFs8c_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8s_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8s_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8s_BFs8c, aBFu8s_BFs8c_BFs8s_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8s_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8s_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8s_BFs8i, aBFu8s_BFs8c_BFs8s_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8s_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8s_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8s_BFs8ll, aBFu8s_BFs8c_BFs8s_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8s_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8s_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8s_BFs8s, aBFu8s_BFs8c_BFs8s_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8s_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8s_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8s_BFu8c, aBFu8s_BFs8c_BFs8s_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8s_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8s_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8s_BFu8i, aBFu8s_BFs8c_BFs8s_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8s_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8s_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8s_BFu8ll, aBFu8s_BFs8c_BFs8s_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFs8s_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFs8s_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFs8s_BFu8s, aBFu8s_BFs8c_BFs8s_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8c, aBFu8s_BFs8c_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8c_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8c_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8c_BFs8c, aBFu8s_BFs8c_BFu8c_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8c_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8c_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8c_BFs8i, aBFu8s_BFs8c_BFu8c_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8c_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8c_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8c_BFs8ll, aBFu8s_BFs8c_BFu8c_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8c_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8c_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8c_BFs8s, aBFu8s_BFs8c_BFu8c_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8c_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8c_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8c_BFu8c, aBFu8s_BFs8c_BFu8c_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8c_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8c_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8c_BFu8i, aBFu8s_BFs8c_BFu8c_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8c_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8c_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8c_BFu8ll, aBFu8s_BFs8c_BFu8c_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8c_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8c_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8c_BFu8s, aBFu8s_BFs8c_BFu8c_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8i, aBFu8s_BFs8c_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8i_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8i_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8i_BFs8c, aBFu8s_BFs8c_BFu8i_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8i_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8i_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8i_BFs8i, aBFu8s_BFs8c_BFu8i_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8i_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8i_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8i_BFs8ll, aBFu8s_BFs8c_BFu8i_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8i_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8i_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8i_BFs8s, aBFu8s_BFs8c_BFu8i_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8i_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8i_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8i_BFu8c, aBFu8s_BFs8c_BFu8i_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8i_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8i_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8i_BFu8i, aBFu8s_BFs8c_BFu8i_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8i_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8i_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8i_BFu8ll, aBFu8s_BFs8c_BFu8i_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8i_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8i_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8i_BFu8s, aBFu8s_BFs8c_BFu8i_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8ll, aBFu8s_BFs8c_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8ll_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8ll_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8ll_BFs8c, aBFu8s_BFs8c_BFu8ll_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8ll_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8ll_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8ll_BFs8i, aBFu8s_BFs8c_BFu8ll_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8ll_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8ll_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8ll_BFs8ll, aBFu8s_BFs8c_BFu8ll_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8ll_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8ll_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8ll_BFs8s, aBFu8s_BFs8c_BFu8ll_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8ll_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8ll_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8ll_BFu8c, aBFu8s_BFs8c_BFu8ll_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8ll_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8ll_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8ll_BFu8i, aBFu8s_BFs8c_BFu8ll_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8ll_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8ll_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8ll_BFu8ll, aBFu8s_BFs8c_BFu8ll_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8ll_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8ll_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8ll_BFu8s, aBFu8s_BFs8c_BFu8ll_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8s, aBFu8s_BFs8c_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8s_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8s_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8s_BFs8c, aBFu8s_BFs8c_BFu8s_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8s_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8s_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8s_BFs8i, aBFu8s_BFs8c_BFu8s_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8s_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8s_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8s_BFs8ll, aBFu8s_BFs8c_BFu8s_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8s_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8s_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8s_BFs8s, aBFu8s_BFs8c_BFu8s_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8s_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8s_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8s_BFu8c, aBFu8s_BFs8c_BFu8s_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8s_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8s_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8s_BFu8i, aBFu8s_BFs8c_BFu8s_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8s_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8s_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8s_BFu8ll, aBFu8s_BFs8c_BFu8s_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8c_BFu8s_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8c_BFu8s_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8c_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8c_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8c_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8c_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8c_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8c_BFu8s_BFu8s, aBFu8s_BFs8c_BFu8s_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8i lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i, aBFu8s_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8c, aBFu8s_BFs8i_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8c_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8c_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8c_BFs8c, aBFu8s_BFs8i_BFs8c_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8c_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8c_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8c_BFs8i, aBFu8s_BFs8i_BFs8c_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8c_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8c_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8c_BFs8ll, aBFu8s_BFs8i_BFs8c_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8c_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8c_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8c_BFs8s, aBFu8s_BFs8i_BFs8c_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8c_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8c_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8c_BFu8c, aBFu8s_BFs8i_BFs8c_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8c_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8c_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8c_BFu8i, aBFu8s_BFs8i_BFs8c_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8c_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8c_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8c_BFu8ll, aBFu8s_BFs8i_BFs8c_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8c_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8c_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8c_BFu8s, aBFu8s_BFs8i_BFs8c_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8i, aBFu8s_BFs8i_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8i_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8i_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8i_BFs8c, aBFu8s_BFs8i_BFs8i_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8i_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8i_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8i_BFs8i, aBFu8s_BFs8i_BFs8i_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8i_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8i_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8i_BFs8ll, aBFu8s_BFs8i_BFs8i_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8i_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8i_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8i_BFs8s, aBFu8s_BFs8i_BFs8i_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8i_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8i_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8i_BFu8c, aBFu8s_BFs8i_BFs8i_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8i_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8i_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8i_BFu8i, aBFu8s_BFs8i_BFs8i_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8i_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8i_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8i_BFu8ll, aBFu8s_BFs8i_BFs8i_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8i_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8i_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8i_BFu8s, aBFu8s_BFs8i_BFs8i_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8ll, aBFu8s_BFs8i_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8ll_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8ll_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8ll_BFs8c, aBFu8s_BFs8i_BFs8ll_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8ll_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8ll_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8ll_BFs8i, aBFu8s_BFs8i_BFs8ll_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8ll_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8ll_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8ll_BFs8ll, aBFu8s_BFs8i_BFs8ll_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8ll_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8ll_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8ll_BFs8s, aBFu8s_BFs8i_BFs8ll_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8ll_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8ll_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8ll_BFu8c, aBFu8s_BFs8i_BFs8ll_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8ll_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8ll_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8ll_BFu8i, aBFu8s_BFs8i_BFs8ll_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8ll_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8ll_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8ll_BFu8ll, aBFu8s_BFs8i_BFs8ll_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8ll_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8ll_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8ll_BFu8s, aBFu8s_BFs8i_BFs8ll_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8s, aBFu8s_BFs8i_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8s_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8s_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8s_BFs8c, aBFu8s_BFs8i_BFs8s_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8s_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8s_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8s_BFs8i, aBFu8s_BFs8i_BFs8s_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8s_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8s_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8s_BFs8ll, aBFu8s_BFs8i_BFs8s_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8s_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8s_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8s_BFs8s, aBFu8s_BFs8i_BFs8s_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8s_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8s_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8s_BFu8c, aBFu8s_BFs8i_BFs8s_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8s_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8s_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8s_BFu8i, aBFu8s_BFs8i_BFs8s_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8s_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8s_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8s_BFu8ll, aBFu8s_BFs8i_BFs8s_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFs8s_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFs8s_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFs8s_BFu8s, aBFu8s_BFs8i_BFs8s_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8c, aBFu8s_BFs8i_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8c_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8c_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8c_BFs8c, aBFu8s_BFs8i_BFu8c_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8c_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8c_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8c_BFs8i, aBFu8s_BFs8i_BFu8c_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8c_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8c_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8c_BFs8ll, aBFu8s_BFs8i_BFu8c_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8c_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8c_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8c_BFs8s, aBFu8s_BFs8i_BFu8c_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8c_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8c_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8c_BFu8c, aBFu8s_BFs8i_BFu8c_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8c_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8c_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8c_BFu8i, aBFu8s_BFs8i_BFu8c_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8c_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8c_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8c_BFu8ll, aBFu8s_BFs8i_BFu8c_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8c_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8c_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8c_BFu8s, aBFu8s_BFs8i_BFu8c_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8i, aBFu8s_BFs8i_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8i_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8i_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8i_BFs8c, aBFu8s_BFs8i_BFu8i_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8i_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8i_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8i_BFs8i, aBFu8s_BFs8i_BFu8i_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8i_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8i_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8i_BFs8ll, aBFu8s_BFs8i_BFu8i_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8i_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8i_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8i_BFs8s, aBFu8s_BFs8i_BFu8i_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8i_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8i_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8i_BFu8c, aBFu8s_BFs8i_BFu8i_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8i_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8i_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8i_BFu8i, aBFu8s_BFs8i_BFu8i_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8i_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8i_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8i_BFu8ll, aBFu8s_BFs8i_BFu8i_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8i_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8i_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8i_BFu8s, aBFu8s_BFs8i_BFu8i_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8ll, aBFu8s_BFs8i_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8ll_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8ll_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8ll_BFs8c, aBFu8s_BFs8i_BFu8ll_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8ll_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8ll_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8ll_BFs8i, aBFu8s_BFs8i_BFu8ll_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8ll_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8ll_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8ll_BFs8ll, aBFu8s_BFs8i_BFu8ll_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8ll_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8ll_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8ll_BFs8s, aBFu8s_BFs8i_BFu8ll_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8ll_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8ll_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8ll_BFu8c, aBFu8s_BFs8i_BFu8ll_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8ll_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8ll_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8ll_BFu8i, aBFu8s_BFs8i_BFu8ll_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8ll_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8ll_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8ll_BFu8ll, aBFu8s_BFs8i_BFu8ll_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8ll_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8ll_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8ll_BFu8s, aBFu8s_BFs8i_BFu8ll_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8s, aBFu8s_BFs8i_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8s_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8s_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8s_BFs8c, aBFu8s_BFs8i_BFu8s_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8s_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8s_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8s_BFs8i, aBFu8s_BFs8i_BFu8s_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8s_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8s_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8s_BFs8ll, aBFu8s_BFs8i_BFu8s_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8s_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8s_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8s_BFs8s, aBFu8s_BFs8i_BFu8s_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8s_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8s_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8s_BFu8c, aBFu8s_BFs8i_BFu8s_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8s_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8s_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8s_BFu8i, aBFu8s_BFs8i_BFu8s_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8s_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8s_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8s_BFu8ll, aBFu8s_BFs8i_BFu8s_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8i_BFu8s_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8i_BFu8s_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8i_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8i_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8i_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8i_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8i_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8i_BFu8s_BFu8s, aBFu8s_BFs8i_BFu8s_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll, aBFu8s_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8c, aBFu8s_BFs8ll_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8c_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8c_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8c_BFs8c, aBFu8s_BFs8ll_BFs8c_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8c_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8c_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8c_BFs8i, aBFu8s_BFs8ll_BFs8c_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8c_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8c_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8c_BFs8ll, aBFu8s_BFs8ll_BFs8c_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8c_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8c_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8c_BFs8s, aBFu8s_BFs8ll_BFs8c_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8c_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8c_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8c_BFu8c, aBFu8s_BFs8ll_BFs8c_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8c_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8c_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8c_BFu8i, aBFu8s_BFs8ll_BFs8c_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8c_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8c_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8c_BFu8ll, aBFu8s_BFs8ll_BFs8c_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8c_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8c_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8c_BFu8s, aBFu8s_BFs8ll_BFs8c_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8i, aBFu8s_BFs8ll_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8i_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8i_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8i_BFs8c, aBFu8s_BFs8ll_BFs8i_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8i_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8i_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8i_BFs8i, aBFu8s_BFs8ll_BFs8i_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8i_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8i_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8i_BFs8ll, aBFu8s_BFs8ll_BFs8i_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8i_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8i_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8i_BFs8s, aBFu8s_BFs8ll_BFs8i_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8i_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8i_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8i_BFu8c, aBFu8s_BFs8ll_BFs8i_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8i_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8i_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8i_BFu8i, aBFu8s_BFs8ll_BFs8i_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8i_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8i_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8i_BFu8ll, aBFu8s_BFs8ll_BFs8i_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8i_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8i_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8i_BFu8s, aBFu8s_BFs8ll_BFs8i_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8ll, aBFu8s_BFs8ll_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8ll_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8ll_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8ll_BFs8c, aBFu8s_BFs8ll_BFs8ll_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8ll_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8ll_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8ll_BFs8i, aBFu8s_BFs8ll_BFs8ll_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8ll_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8ll_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8ll_BFs8ll, aBFu8s_BFs8ll_BFs8ll_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8ll_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8ll_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8ll_BFs8s, aBFu8s_BFs8ll_BFs8ll_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8ll_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8ll_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8ll_BFu8c, aBFu8s_BFs8ll_BFs8ll_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8ll_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8ll_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8ll_BFu8i, aBFu8s_BFs8ll_BFs8ll_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8ll_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8ll_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8ll_BFu8ll, aBFu8s_BFs8ll_BFs8ll_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8ll_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8ll_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8ll_BFu8s, aBFu8s_BFs8ll_BFs8ll_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8s, aBFu8s_BFs8ll_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8s_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8s_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8s_BFs8c, aBFu8s_BFs8ll_BFs8s_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8s_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8s_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8s_BFs8i, aBFu8s_BFs8ll_BFs8s_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8s_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8s_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8s_BFs8ll, aBFu8s_BFs8ll_BFs8s_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8s_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8s_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8s_BFs8s, aBFu8s_BFs8ll_BFs8s_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8s_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8s_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8s_BFu8c, aBFu8s_BFs8ll_BFs8s_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8s_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8s_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8s_BFu8i, aBFu8s_BFs8ll_BFs8s_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8s_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8s_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8s_BFu8ll, aBFu8s_BFs8ll_BFs8s_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFs8s_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFs8s_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFs8s_BFu8s, aBFu8s_BFs8ll_BFs8s_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8c, aBFu8s_BFs8ll_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8c_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8c_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8c_BFs8c, aBFu8s_BFs8ll_BFu8c_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8c_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8c_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8c_BFs8i, aBFu8s_BFs8ll_BFu8c_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8c_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8c_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8c_BFs8ll, aBFu8s_BFs8ll_BFu8c_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8c_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8c_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8c_BFs8s, aBFu8s_BFs8ll_BFu8c_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8c_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8c_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8c_BFu8c, aBFu8s_BFs8ll_BFu8c_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8c_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8c_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8c_BFu8i, aBFu8s_BFs8ll_BFu8c_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8c_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8c_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8c_BFu8ll, aBFu8s_BFs8ll_BFu8c_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8c_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8c_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8c_BFu8s, aBFu8s_BFs8ll_BFu8c_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8i, aBFu8s_BFs8ll_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8i_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8i_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8i_BFs8c, aBFu8s_BFs8ll_BFu8i_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8i_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8i_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8i_BFs8i, aBFu8s_BFs8ll_BFu8i_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8i_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8i_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8i_BFs8ll, aBFu8s_BFs8ll_BFu8i_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8i_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8i_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8i_BFs8s, aBFu8s_BFs8ll_BFu8i_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8i_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8i_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8i_BFu8c, aBFu8s_BFs8ll_BFu8i_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8i_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8i_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8i_BFu8i, aBFu8s_BFs8ll_BFu8i_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8i_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8i_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8i_BFu8ll, aBFu8s_BFs8ll_BFu8i_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8i_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8i_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8i_BFu8s, aBFu8s_BFs8ll_BFu8i_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8ll, aBFu8s_BFs8ll_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8ll_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8ll_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8ll_BFs8c, aBFu8s_BFs8ll_BFu8ll_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8ll_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8ll_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8ll_BFs8i, aBFu8s_BFs8ll_BFu8ll_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8ll_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8ll_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8ll_BFs8ll, aBFu8s_BFs8ll_BFu8ll_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8ll_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8ll_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8ll_BFs8s, aBFu8s_BFs8ll_BFu8ll_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8ll_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8ll_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8ll_BFu8c, aBFu8s_BFs8ll_BFu8ll_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8ll_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8ll_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8ll_BFu8i, aBFu8s_BFs8ll_BFu8ll_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8ll_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8ll_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8ll_BFu8ll, aBFu8s_BFs8ll_BFu8ll_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8ll_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8ll_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8ll_BFu8s, aBFu8s_BFs8ll_BFu8ll_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8s, aBFu8s_BFs8ll_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8s_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8s_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8s_BFs8c, aBFu8s_BFs8ll_BFu8s_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8s_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8s_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8s_BFs8i, aBFu8s_BFs8ll_BFu8s_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8s_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8s_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8s_BFs8ll, aBFu8s_BFs8ll_BFu8s_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8s_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8s_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8s_BFs8s, aBFu8s_BFs8ll_BFu8s_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8s_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8s_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8s_BFu8c, aBFu8s_BFs8ll_BFu8s_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8s_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8s_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8s_BFu8i, aBFu8s_BFs8ll_BFu8s_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8s_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8s_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8s_BFu8ll, aBFu8s_BFs8ll_BFu8s_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8ll_BFu8s_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8ll_BFu8s_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8ll_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8ll_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8ll_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8ll_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8ll_BFu8s_BFu8s, aBFu8s_BFs8ll_BFu8s_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8s lv;
    check2(sizeof(lv), 2, "sizeof(aBFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s, aBFu8s_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8c, aBFu8s_BFs8s_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8c_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8c_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8c_BFs8c, aBFu8s_BFs8s_BFs8c_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8c_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8c_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8c_BFs8i, aBFu8s_BFs8s_BFs8c_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8c_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8c_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8c_BFs8ll, aBFu8s_BFs8s_BFs8c_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8c_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8c_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8c_BFs8s, aBFu8s_BFs8s_BFs8c_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8c_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8c_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8c_BFu8c, aBFu8s_BFs8s_BFs8c_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8c_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8c_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8c_BFu8i, aBFu8s_BFs8s_BFs8c_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8c_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8c_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8c_BFu8ll, aBFu8s_BFs8s_BFs8c_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8c_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8c_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8c_BFu8s, aBFu8s_BFs8s_BFs8c_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8i, aBFu8s_BFs8s_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8i_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8i_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8i_BFs8c, aBFu8s_BFs8s_BFs8i_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8i_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8i_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8i_BFs8i, aBFu8s_BFs8s_BFs8i_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8i_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8i_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8i_BFs8ll, aBFu8s_BFs8s_BFs8i_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8i_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8i_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8i_BFs8s, aBFu8s_BFs8s_BFs8i_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8i_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8i_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8i_BFu8c, aBFu8s_BFs8s_BFs8i_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8i_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8i_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8i_BFu8i, aBFu8s_BFs8s_BFs8i_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8i_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8i_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8i_BFu8ll, aBFu8s_BFs8s_BFs8i_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8i_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8i_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8i_BFu8s, aBFu8s_BFs8s_BFs8i_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8ll, aBFu8s_BFs8s_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8ll_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8ll_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8ll_BFs8c, aBFu8s_BFs8s_BFs8ll_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8ll_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8ll_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8ll_BFs8i, aBFu8s_BFs8s_BFs8ll_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8ll_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8ll_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8ll_BFs8ll, aBFu8s_BFs8s_BFs8ll_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8ll_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8ll_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8ll_BFs8s, aBFu8s_BFs8s_BFs8ll_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8ll_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8ll_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8ll_BFu8c, aBFu8s_BFs8s_BFs8ll_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8ll_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8ll_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8ll_BFu8i, aBFu8s_BFs8s_BFs8ll_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8ll_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8ll_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8ll_BFu8ll, aBFu8s_BFs8s_BFs8ll_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8ll_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8ll_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8ll_BFu8s, aBFu8s_BFs8s_BFs8ll_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8s, aBFu8s_BFs8s_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8s_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8s_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8s_BFs8c, aBFu8s_BFs8s_BFs8s_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8s_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8s_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8s_BFs8i, aBFu8s_BFs8s_BFs8s_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8s_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8s_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8s_BFs8ll, aBFu8s_BFs8s_BFs8s_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8s_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8s_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8s_BFs8s, aBFu8s_BFs8s_BFs8s_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8s_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8s_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8s_BFu8c, aBFu8s_BFs8s_BFs8s_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8s_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8s_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8s_BFu8i, aBFu8s_BFs8s_BFs8s_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8s_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8s_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8s_BFu8ll, aBFu8s_BFs8s_BFs8s_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFs8s_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFs8s_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFs8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFs8s_BFu8s, aBFu8s_BFs8s_BFs8s_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8c, aBFu8s_BFs8s_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8c_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8c_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8c_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8c_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8c_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8c_BFs8c, aBFu8s_BFs8s_BFu8c_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8c_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8c_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8c_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8c_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8c_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8c_BFs8i, aBFu8s_BFs8s_BFu8c_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8c_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8c_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8c_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8c_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8c_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8c_BFs8ll, aBFu8s_BFs8s_BFu8c_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8c_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8c_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8c_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8c_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8c_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8c_BFs8s, aBFu8s_BFs8s_BFu8c_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8c_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8c_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8c_BFu8c, aBFu8s_BFs8s_BFu8c_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8c_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8c_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8c_BFu8i, aBFu8s_BFs8s_BFu8c_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8c_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8c_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8c_BFu8ll, aBFu8s_BFs8s_BFu8c_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8c_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8c_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8c_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8c_BFu8s, aBFu8s_BFs8s_BFu8c_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8i, aBFu8s_BFs8s_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8i_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8i_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8i_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8i_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8i_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8i_BFs8c, aBFu8s_BFs8s_BFu8i_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8i_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8i_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8i_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8i_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8i_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8i_BFs8i, aBFu8s_BFs8s_BFu8i_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8i_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8i_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8i_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8i_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8i_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8i_BFs8ll, aBFu8s_BFs8s_BFu8i_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8i_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8i_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8i_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8i_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8i_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8i_BFs8s, aBFu8s_BFs8s_BFu8i_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8i_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8i_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8i_BFu8c, aBFu8s_BFs8s_BFu8i_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8i_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8i_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8i_BFu8i, aBFu8s_BFs8s_BFu8i_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8i_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8i_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8i_BFu8ll, aBFu8s_BFs8s_BFu8i_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8i_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8i_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8i_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8i_BFu8s, aBFu8s_BFs8s_BFu8i_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8ll, aBFu8s_BFs8s_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8ll_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8ll_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8ll_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8ll_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8ll_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8ll_BFs8c, aBFu8s_BFs8s_BFu8ll_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8ll_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8ll_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8ll_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8ll_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8ll_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8ll_BFs8i, aBFu8s_BFs8s_BFu8ll_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8ll_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8ll_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8ll_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8ll_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8ll_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8ll_BFs8ll, aBFu8s_BFs8s_BFu8ll_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8ll_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8ll_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8ll_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8ll_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8ll_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8ll_BFs8s, aBFu8s_BFs8s_BFu8ll_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8ll_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8ll_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8ll_BFu8c, aBFu8s_BFs8s_BFu8ll_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8ll_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8ll_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8ll_BFu8i, aBFu8s_BFs8s_BFu8ll_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8ll_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8ll_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8ll_BFu8ll, aBFu8s_BFs8s_BFu8ll_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8ll_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8ll_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8ll_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8ll_BFu8s, aBFu8s_BFs8s_BFu8ll_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFs8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8s, aBFu8s_BFs8s_BFu8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8s_BFs8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8s_BFs8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8s_BFs8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8s_BFs8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8s_BFs8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8s_BFs8c, aBFu8s_BFs8s_BFu8s_BFs8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8s_BFs8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8s_BFs8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8s_BFs8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8s_BFs8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8s_BFs8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8s_BFs8i, aBFu8s_BFs8s_BFu8s_BFs8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8s_BFs8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8s_BFs8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8s_BFs8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8s_BFs8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8s_BFs8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8s_BFs8ll, aBFu8s_BFs8s_BFu8s_BFs8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8s_BFs8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8s_BFs8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8s_BFs8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8s_BFs8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8s_BFs8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFs8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFs8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8s_BFs8s, aBFu8s_BFs8s_BFu8s_BFs8s)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8s_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8s_BFu8c");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8c");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8s_BFu8c, aBFu8s_BFs8s_BFu8s_BFu8c)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8s_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8s_BFu8i");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8i");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8s_BFu8i, aBFu8s_BFs8s_BFu8s_BFu8i)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8s_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8s_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8ll");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8s_BFu8ll, aBFu8s_BFs8s_BFu8s_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFs8s_BFu8s_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFs8s_BFu8s_BFu8s");
    static STRUCT_IF_C aBFu8s_BFs8s_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFs8s_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFs8s_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 8, hide_sll(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 2, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, 1, "aBFu8s_BFs8s_BFu8s_BFu8s");
    set_bf_and_test(lv, v4, 3, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFs8s_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFs8s_BFu8s_BFu8s, aBFu8s_BFs8s_BFu8s_BFu8s)
//============================================================================



static void Test_aBFu8s_BFu15i()
{
  {
    init_simple_test("aBFu8s_BFu15i");
    static STRUCT_IF_C aBFu8s_BFu15i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i, aBFu8s_BFu15i)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu15i()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu15i");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8s_BFu15i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu8s_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu15i, aBFu8s_BFu15i_BFu15i)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu15ll()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu15ll");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8s_BFu15i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu8s_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu15ll, aBFu8s_BFu15i_BFu15ll)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu15s()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu15s");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8s_BFu15i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu8s_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu15s, aBFu8s_BFu15i_BFu15s)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu16i()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu16i");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8s_BFu15i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu8s_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu8s_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu16i, aBFu8s_BFu15i_BFu16i)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu16ll()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu16ll");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8s_BFu15i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu8s_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu8s_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu16ll, aBFu8s_BFu15i_BFu16ll)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu16s()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu16s");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8s_BFu15i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu8s_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu8s_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu16s, aBFu8s_BFu15i_BFu16s)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu17i()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu17i");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8s_BFu15i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aBFu8s_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aBFu8s_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu17i, aBFu8s_BFu15i_BFu17i)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu17ll()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu17ll");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu8s_BFu15i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aBFu8s_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aBFu8s_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu17ll, aBFu8s_BFu15i_BFu17ll)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu1c()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu1c");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu15i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu8s_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu1c, aBFu8s_BFu15i_BFu1c)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu1i()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu1i");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu15i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu8s_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu1i, aBFu8s_BFu15i_BFu1i)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu1ll()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu1ll");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu15i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu8s_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu1ll, aBFu8s_BFu15i_BFu1ll)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu1s()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu1s");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu8s_BFu15i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu8s_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu1s, aBFu8s_BFu15i_BFu1s)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu31i()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu31i");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8s_BFu15i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aBFu8s_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aBFu8s_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu31i, aBFu8s_BFu15i_BFu31i)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu31ll()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu31ll");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8s_BFu15i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aBFu8s_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aBFu8s_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu31ll, aBFu8s_BFu15i_BFu31ll)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu32i()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu32i");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8s_BFu15i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aBFu8s_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aBFu8s_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu32i, aBFu8s_BFu15i_BFu32i)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu32ll()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu32ll");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8s_BFu15i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aBFu8s_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aBFu8s_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu32ll, aBFu8s_BFu15i_BFu32ll)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu33()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu33");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8s_BFu15i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "aBFu8s_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "aBFu8s_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu33, aBFu8s_BFu15i_BFu33)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu7c()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu7c");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu8s_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu8s_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu7c, aBFu8s_BFu15i_BFu7c)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu7i()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu7i");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu8s_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu8s_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu7i, aBFu8s_BFu15i_BFu7i)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu7ll()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu7ll");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu8s_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu8s_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu7ll, aBFu8s_BFu15i_BFu7ll)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu7s()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu7s");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu8s_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu8s_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu7s, aBFu8s_BFu15i_BFu7s)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu8c()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu8c");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu8s_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu8c, aBFu8s_BFu15i_BFu8c)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu8i()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu8i");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu8s_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu8i, aBFu8s_BFu15i_BFu8i)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu8ll()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu8ll");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu8s_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu8ll, aBFu8s_BFu15i_BFu8ll)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu8s()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu8s");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu8s_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu8s, aBFu8s_BFu15i_BFu8s)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu9i()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu9i");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu8s_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu8s_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu9i, aBFu8s_BFu15i_BFu9i)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu9ll()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu9ll");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu8s_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu8s_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu9ll, aBFu8s_BFu15i_BFu9ll)
//============================================================================



static void Test_aBFu8s_BFu15i_BFu9s()
{
  {
    init_simple_test("aBFu8s_BFu15i_BFu9s");
    static STRUCT_IF_C aBFu8s_BFu15i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu8s_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu8s_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_BFu9s, aBFu8s_BFu15i_BFu9s)
//============================================================================



static void Test_aBFu8s_BFu15i_C()
{
  {
    init_simple_test("aBFu8s_BFu15i_C");
    static STRUCT_IF_C aBFu8s_BFu15i_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu8s_BFu15i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_C)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_C");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_C");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_C");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_C");
    check_field_offset(lv, v3, 3, "aBFu8s_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_C, aBFu8s_BFu15i_C)
//============================================================================



static void Test_aBFu8s_BFu15i_D()
{
  {
    init_simple_test("aBFu8s_BFu15i_D");
    static STRUCT_IF_C aBFu8s_BFu15i_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu8s_BFu15i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_D)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_D");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_D");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_D");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_D");
    check_field_offset(lv, v3, 3, "aBFu8s_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_D, aBFu8s_BFu15i_D)
//============================================================================



static void Test_aBFu8s_BFu15i_F()
{
  {
    init_simple_test("aBFu8s_BFu15i_F");
    static STRUCT_IF_C aBFu8s_BFu15i_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8s_BFu15i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_F)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_F");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_F");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_F");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_F");
    check_field_offset(lv, v3, 3, "aBFu8s_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_F, aBFu8s_BFu15i_F)
//============================================================================



static void Test_aBFu8s_BFu15i_I()
{
  {
    init_simple_test("aBFu8s_BFu15i_I");
    static STRUCT_IF_C aBFu8s_BFu15i_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu8s_BFu15i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu8s_BFu15i_I)");
    set_bf_and_test(lv, v1, 0, 0, 8, 1, "aBFu8s_BFu15i_I");
    set_bf_and_test(lv, v1, 0, 0, 8, hide_ull(1LL<<7), "aBFu8s_BFu15i_I");
    set_bf_and_test(lv, v2, 1, 0, 15, 1, "aBFu8s_BFu15i_I");
    set_bf_and_test(lv, v2, 1, 0, 15, hide_ull(1LL<<14), "aBFu8s_BFu15i_I");
    check_field_offset(lv, v3, 3, "aBFu8s_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu8s_BFu15i_I, aBFu8s_BFu15i_I)
//============================================================================



static void Test_aBFu8s_BFu15i_Ip()
{
  {
    init_simple_test("aBFu8s_BFu15i_Ip");
    static STRUCT_IF_C aBFu8s_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "