// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu15i { unsigned long long v1:16; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu15ll { unsigned long long v1:16; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu15s { unsigned long long v1:16; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu16i { unsigned long long v1:16; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu16ll { unsigned long long v1:16; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu16s { unsigned long long v1:16; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu17i { unsigned long long v1:16; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu17ll { unsigned long long v1:16; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu1c { unsigned long long v1:16; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu1i { unsigned long long v1:16; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu1ll { unsigned long long v1:16; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu1s { unsigned long long v1:16; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu31i { unsigned long long v1:16; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu31ll { unsigned long long v1:16; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu32i { unsigned long long v1:16; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu32ll { unsigned long long v1:16; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu33 { unsigned long long v1:16; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu7c { unsigned long long v1:16; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu7i { unsigned long long v1:16; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu7ll { unsigned long long v1:16; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu7s { unsigned long long v1:16; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu8c { unsigned long long v1:16; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu8i { unsigned long long v1:16; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu8ll { unsigned long long v1:16; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu8s { unsigned long long v1:16; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu9i { unsigned long long v1:16; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu9ll { unsigned long long v1:16; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu1c_BFu9s { unsigned long long v1:16; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu1c_C { unsigned long long v1:16; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu1c_D { unsigned long long v1:16; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu1c_F { unsigned long long v1:16; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu1c_I { unsigned long long v1:16; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu1c_Ip { unsigned long long v1:16; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu1c_L { unsigned long long v1:16; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu1c_S { unsigned long long v1:16; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu1c_Uc { unsigned long long v1:16; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu1c_Ui { unsigned long long v1:16; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu1c_Ul { unsigned long long v1:16; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu1c_Us { unsigned long long v1:16; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu1c_Vp { unsigned long long v1:16; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i { unsigned long long v1:16; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu15i { unsigned long long v1:16; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu15ll { unsigned long long v1:16; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu15s { unsigned long long v1:16; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu16i { unsigned long long v1:16; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu16ll { unsigned long long v1:16; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu16s { unsigned long long v1:16; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu17i { unsigned long long v1:16; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu17ll { unsigned long long v1:16; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu1c { unsigned long long v1:16; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu1i { unsigned long long v1:16; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu1ll { unsigned long long v1:16; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu1s { unsigned long long v1:16; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu31i { unsigned long long v1:16; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu31ll { unsigned long long v1:16; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu32i { unsigned long long v1:16; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu32ll { unsigned long long v1:16; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu33 { unsigned long long v1:16; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu7c { unsigned long long v1:16; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu7i { unsigned long long v1:16; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu7ll { unsigned long long v1:16; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu7s { unsigned long long v1:16; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu8c { unsigned long long v1:16; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu8i { unsigned long long v1:16; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu8ll { unsigned long long v1:16; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu8s { unsigned long long v1:16; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu9i { unsigned long long v1:16; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu9ll { unsigned long long v1:16; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu1i_BFu9s { unsigned long long v1:16; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu1i_C { unsigned long long v1:16; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i_D { unsigned long long v1:16; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i_F { unsigned long long v1:16; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i_I { unsigned long long v1:16; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i_Ip { unsigned long long v1:16; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i_L { unsigned long long v1:16; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i_S { unsigned long long v1:16; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i_Uc { unsigned long long v1:16; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i_Ui { unsigned long long v1:16; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i_Ul { unsigned long long v1:16; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i_Us { unsigned long long v1:16; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu1i_Vp { unsigned long long v1:16; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll { unsigned long long v1:16; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu15i { unsigned long long v1:16; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu15ll { unsigned long long v1:16; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu15s { unsigned long long v1:16; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu16i { unsigned long long v1:16; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu16ll { unsigned long long v1:16; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu16s { unsigned long long v1:16; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu17i { unsigned long long v1:16; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu17ll { unsigned long long v1:16; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu1c { unsigned long long v1:16; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu1i { unsigned long long v1:16; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu1ll { unsigned long long v1:16; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu1s { unsigned long long v1:16; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu31i { unsigned long long v1:16; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu31ll { unsigned long long v1:16; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu32i { unsigned long long v1:16; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu32ll { unsigned long long v1:16; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu33 { unsigned long long v1:16; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu7c { unsigned long long v1:16; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu7i { unsigned long long v1:16; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu7ll { unsigned long long v1:16; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu7s { unsigned long long v1:16; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu8c { unsigned long long v1:16; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu8i { unsigned long long v1:16; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu8ll { unsigned long long v1:16; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu8s { unsigned long long v1:16; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu9i { unsigned long long v1:16; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu9ll { unsigned long long v1:16; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_BFu9s { unsigned long long v1:16; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_C { unsigned long long v1:16; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_D { unsigned long long v1:16; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_F { unsigned long long v1:16; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_I { unsigned long long v1:16; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_Ip { unsigned long long v1:16; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_L { unsigned long long v1:16; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_S { unsigned long long v1:16; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_Uc { unsigned long long v1:16; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_Ui { unsigned long long v1:16; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_Ul { unsigned long long v1:16; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_Us { unsigned long long v1:16; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu1ll_Vp { unsigned long long v1:16; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s { unsigned long long v1:16; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu15i { unsigned long long v1:16; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu15ll { unsigned long long v1:16; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu15s { unsigned long long v1:16; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu16i { unsigned long long v1:16; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu16ll { unsigned long long v1:16; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu16s { unsigned long long v1:16; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu17i { unsigned long long v1:16; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu17ll { unsigned long long v1:16; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu1c { unsigned long long v1:16; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu1i { unsigned long long v1:16; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu1ll { unsigned long long v1:16; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu1s { unsigned long long v1:16; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu31i { unsigned long long v1:16; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu31ll { unsigned long long v1:16; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu32i { unsigned long long v1:16; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu32ll { unsigned long long v1:16; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu33 { unsigned long long v1:16; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu7c { unsigned long long v1:16; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu7i { unsigned long long v1:16; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu7ll { unsigned long long v1:16; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu7s { unsigned long long v1:16; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu8c { unsigned long long v1:16; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu8i { unsigned long long v1:16; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu8ll { unsigned long long v1:16; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu8s { unsigned long long v1:16; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu9i { unsigned long long v1:16; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu9ll { unsigned long long v1:16; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu1s_BFu9s { unsigned long long v1:16; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu1s_C { unsigned long long v1:16; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s_D { unsigned long long v1:16; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s_F { unsigned long long v1:16; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s_I { unsigned long long v1:16; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s_Ip { unsigned long long v1:16; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s_L { unsigned long long v1:16; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s_S { unsigned long long v1:16; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s_Uc { unsigned long long v1:16; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s_Ui { unsigned long long v1:16; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s_Ul { unsigned long long v1:16; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s_Us { unsigned long long v1:16; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu1s_Vp { unsigned long long v1:16; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i { unsigned long long v1:16; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu15i { unsigned long long v1:16; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu15ll { unsigned long long v1:16; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu15s { unsigned long long v1:16; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu16i { unsigned long long v1:16; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu16ll { unsigned long long v1:16; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu16s { unsigned long long v1:16; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu17i { unsigned long long v1:16; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu17ll { unsigned long long v1:16; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu1c { unsigned long long v1:16; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu1i { unsigned long long v1:16; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu1ll { unsigned long long v1:16; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu1s { unsigned long long v1:16; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu31i { unsigned long long v1:16; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu31ll { unsigned long long v1:16; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu32i { unsigned long long v1:16; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu32ll { unsigned long long v1:16; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu33 { unsigned long long v1:16; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu7c { unsigned long long v1:16; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu7i { unsigned long long v1:16; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu7ll { unsigned long long v1:16; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu7s { unsigned long long v1:16; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu8c { unsigned long long v1:16; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu8i { unsigned long long v1:16; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu8ll { unsigned long long v1:16; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu8s { unsigned long long v1:16; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu9i { unsigned long long v1:16; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu9ll { unsigned long long v1:16; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu31i_BFu9s { unsigned long long v1:16; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu31i_C { unsigned long long v1:16; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i_D { unsigned long long v1:16; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i_F { unsigned long long v1:16; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i_I { unsigned long long v1:16; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i_Ip { unsigned long long v1:16; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i_L { unsigned long long v1:16; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i_S { unsigned long long v1:16; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i_Uc { unsigned long long v1:16; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i_Ui { unsigned long long v1:16; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i_Ul { unsigned long long v1:16; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i_Us { unsigned long long v1:16; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu31i_Vp { unsigned long long v1:16; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll { unsigned long long v1:16; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu15i { unsigned long long v1:16; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu15ll { unsigned long long v1:16; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu15s { unsigned long long v1:16; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu16i { unsigned long long v1:16; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu16ll { unsigned long long v1:16; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu16s { unsigned long long v1:16; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu17i { unsigned long long v1:16; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu17ll { unsigned long long v1:16; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu1c { unsigned long long v1:16; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu1i { unsigned long long v1:16; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu1ll { unsigned long long v1:16; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu1s { unsigned long long v1:16; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu31i { unsigned long long v1:16; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu31ll { unsigned long long v1:16; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu32i { unsigned long long v1:16; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu32ll { unsigned long long v1:16; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu33 { unsigned long long v1:16; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu7c { unsigned long long v1:16; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu7i { unsigned long long v1:16; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu7ll { unsigned long long v1:16; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu7s { unsigned long long v1:16; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu8c { unsigned long long v1:16; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu8i { unsigned long long v1:16; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu8ll { unsigned long long v1:16; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu8s { unsigned long long v1:16; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu9i { unsigned long long v1:16; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu9ll { unsigned long long v1:16; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_BFu9s { unsigned long long v1:16; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_C { unsigned long long v1:16; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_D { unsigned long long v1:16; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_F { unsigned long long v1:16; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_I { unsigned long long v1:16; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_Ip { unsigned long long v1:16; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_L { unsigned long long v1:16; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_S { unsigned long long v1:16; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_Uc { unsigned long long v1:16; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_Ui { unsigned long long v1:16; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_Ul { unsigned long long v1:16; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_Us { unsigned long long v1:16; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu31ll_Vp { unsigned long long v1:16; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i { unsigned long long v1:16; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu15i { unsigned long long v1:16; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu15ll { unsigned long long v1:16; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu15s { unsigned long long v1:16; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu16i { unsigned long long v1:16; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu16ll { unsigned long long v1:16; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu16s { unsigned long long v1:16; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu17i { unsigned long long v1:16; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu17ll { unsigned long long v1:16; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu1c { unsigned long long v1:16; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu1i { unsigned long long v1:16; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu1ll { unsigned long long v1:16; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu1s { unsigned long long v1:16; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu31i { unsigned long long v1:16; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu31ll { unsigned long long v1:16; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu32i { unsigned long long v1:16; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu32ll { unsigned long long v1:16; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu33 { unsigned long long v1:16; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu7c { unsigned long long v1:16; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu7i { unsigned long long v1:16; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu7ll { unsigned long long v1:16; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu7s { unsigned long long v1:16; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu8c { unsigned long long v1:16; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu8i { unsigned long long v1:16; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu8ll { unsigned long long v1:16; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu8s { unsigned long long v1:16; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu9i { unsigned long long v1:16; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu9ll { unsigned long long v1:16; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu32i_BFu9s { unsigned long long v1:16; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu32i_C { unsigned long long v1:16; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i_D { unsigned long long v1:16; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i_F { unsigned long long v1:16; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i_I { unsigned long long v1:16; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i_Ip { unsigned long long v1:16; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i_L { unsigned long long v1:16; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i_S { unsigned long long v1:16; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i_Uc { unsigned long long v1:16; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i_Ui { unsigned long long v1:16; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i_Ul { unsigned long long v1:16; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i_Us { unsigned long long v1:16; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu32i_Vp { unsigned long long v1:16; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll { unsigned long long v1:16; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu15i { unsigned long long v1:16; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu15ll { unsigned long long v1:16; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu15s { unsigned long long v1:16; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu16i { unsigned long long v1:16; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu16ll { unsigned long long v1:16; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu16s { unsigned long long v1:16; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu17i { unsigned long long v1:16; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu17ll { unsigned long long v1:16; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu1c { unsigned long long v1:16; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu1i { unsigned long long v1:16; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu1ll { unsigned long long v1:16; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu1s { unsigned long long v1:16; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu31i { unsigned long long v1:16; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu31ll { unsigned long long v1:16; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu32i { unsigned long long v1:16; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu32ll { unsigned long long v1:16; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu33 { unsigned long long v1:16; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu7c { unsigned long long v1:16; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu7i { unsigned long long v1:16; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu7ll { unsigned long long v1:16; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu7s { unsigned long long v1:16; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu8c { unsigned long long v1:16; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu8i { unsigned long long v1:16; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu8ll { unsigned long long v1:16; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu8s { unsigned long long v1:16; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu9i { unsigned long long v1:16; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu9ll { unsigned long long v1:16; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_BFu9s { unsigned long long v1:16; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_C { unsigned long long v1:16; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_D { unsigned long long v1:16; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_F { unsigned long long v1:16; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_I { unsigned long long v1:16; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_Ip { unsigned long long v1:16; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_L { unsigned long long v1:16; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_S { unsigned long long v1:16; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_Uc { unsigned long long v1:16; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_Ui { unsigned long long v1:16; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_Ul { unsigned long long v1:16; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_Us { unsigned long long v1:16; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu32ll_Vp { unsigned long long v1:16; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu33 { unsigned long long v1:16; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu15i { unsigned long long v1:16; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu15ll { unsigned long long v1:16; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu15s { unsigned long long v1:16; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu16i { unsigned long long v1:16; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu16ll { unsigned long long v1:16; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu16s { unsigned long long v1:16; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu17i { unsigned long long v1:16; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu17ll { unsigned long long v1:16; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu1c { unsigned long long v1:16; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu1i { unsigned long long v1:16; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu1ll { unsigned long long v1:16; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu1s { unsigned long long v1:16; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu31i { unsigned long long v1:16; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu31ll { unsigned long long v1:16; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu32i { unsigned long long v1:16; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu32ll { unsigned long long v1:16; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu33 { unsigned long long v1:16; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu7c { unsigned long long v1:16; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu7i { unsigned long long v1:16; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu7ll { unsigned long long v1:16; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu7s { unsigned long long v1:16; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu8c { unsigned long long v1:16; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu8i { unsigned long long v1:16; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu8ll { unsigned long long v1:16; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu8s { unsigned long long v1:16; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu9i { unsigned long long v1:16; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu9ll { unsigned long long v1:16; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu33_BFu9s { unsigned long long v1:16; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu33_C { unsigned long long v1:16; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu33_D { unsigned long long v1:16; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu33_F { unsigned long long v1:16; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu33_I { unsigned long long v1:16; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu33_Ip { unsigned long long v1:16; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu33_L { unsigned long long v1:16; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu33_S { unsigned long long v1:16; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu33_Uc { unsigned long long v1:16; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu33_Ui { unsigned long long v1:16; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu33_Ul { unsigned long long v1:16; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu33_Us { unsigned long long v1:16; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu33_Vp { unsigned long long v1:16; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c { unsigned long long v1:16; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu15i { unsigned long long v1:16; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu15ll { unsigned long long v1:16; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu15s { unsigned long long v1:16; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu16i { unsigned long long v1:16; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu16ll { unsigned long long v1:16; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu16s { unsigned long long v1:16; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu17i { unsigned long long v1:16; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu17ll { unsigned long long v1:16; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu1c { unsigned long long v1:16; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu1i { unsigned long long v1:16; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu1ll { unsigned long long v1:16; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu1s { unsigned long long v1:16; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu31i { unsigned long long v1:16; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu31ll { unsigned long long v1:16; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu32i { unsigned long long v1:16; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu32ll { unsigned long long v1:16; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu33 { unsigned long long v1:16; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu7c { unsigned long long v1:16; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu7i { unsigned long long v1:16; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu7ll { unsigned long long v1:16; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu7s { unsigned long long v1:16; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu8c { unsigned long long v1:16; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu8i { unsigned long long v1:16; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu8ll { unsigned long long v1:16; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu8s { unsigned long long v1:16; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu9i { unsigned long long v1:16; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu9ll { unsigned long long v1:16; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu7c_BFu9s { unsigned long long v1:16; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu7c_C { unsigned long long v1:16; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c_D { unsigned long long v1:16; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c_F { unsigned long long v1:16; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c_I { unsigned long long v1:16; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c_Ip { unsigned long long v1:16; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c_L { unsigned long long v1:16; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c_S { unsigned long long v1:16; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c_Uc { unsigned long long v1:16; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c_Ui { unsigned long long v1:16; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c_Ul { unsigned long long v1:16; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c_Us { unsigned long long v1:16; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu7c_Vp { unsigned long long v1:16; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i { unsigned long long v1:16; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu15i { unsigned long long v1:16; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu15ll { unsigned long long v1:16; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu15s { unsigned long long v1:16; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu16i { unsigned long long v1:16; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu16ll { unsigned long long v1:16; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu16s { unsigned long long v1:16; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu17i { unsigned long long v1:16; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu17ll { unsigned long long v1:16; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu1c { unsigned long long v1:16; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu1i { unsigned long long v1:16; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu1ll { unsigned long long v1:16; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu1s { unsigned long long v1:16; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu31i { unsigned long long v1:16; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu31ll { unsigned long long v1:16; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu32i { unsigned long long v1:16; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu32ll { unsigned long long v1:16; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu33 { unsigned long long v1:16; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu7c { unsigned long long v1:16; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu7i { unsigned long long v1:16; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu7ll { unsigned long long v1:16; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu7s { unsigned long long v1:16; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu8c { unsigned long long v1:16; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu8i { unsigned long long v1:16; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu8ll { unsigned long long v1:16; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu8s { unsigned long long v1:16; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu9i { unsigned long long v1:16; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu9ll { unsigned long long v1:16; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu7i_BFu9s { unsigned long long v1:16; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu7i_C { unsigned long long v1:16; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i_D { unsigned long long v1:16; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i_F { unsigned long long v1:16; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i_I { unsigned long long v1:16; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i_Ip { unsigned long long v1:16; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i_L { unsigned long long v1:16; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i_S { unsigned long long v1:16; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i_Uc { unsigned long long v1:16; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i_Ui { unsigned long long v1:16; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i_Ul { unsigned long long v1:16; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i_Us { unsigned long long v1:16; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu7i_Vp { unsigned long long v1:16; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll { unsigned long long v1:16; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu15i { unsigned long long v1:16; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu15ll { unsigned long long v1:16; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu15s { unsigned long long v1:16; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu16i { unsigned long long v1:16; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu16ll { unsigned long long v1:16; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu16s { unsigned long long v1:16; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu17i { unsigned long long v1:16; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu17ll { unsigned long long v1:16; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu1c { unsigned long long v1:16; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu1i { unsigned long long v1:16; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu1ll { unsigned long long v1:16; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu1s { unsigned long long v1:16; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu31i { unsigned long long v1:16; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu31ll { unsigned long long v1:16; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu32i { unsigned long long v1:16; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu32ll { unsigned long long v1:16; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu33 { unsigned long long v1:16; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu7c { unsigned long long v1:16; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu7i { unsigned long long v1:16; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu7ll { unsigned long long v1:16; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu7s { unsigned long long v1:16; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu8c { unsigned long long v1:16; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu8i { unsigned long long v1:16; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu8ll { unsigned long long v1:16; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu8s { unsigned long long v1:16; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu9i { unsigned long long v1:16; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu9ll { unsigned long long v1:16; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_BFu9s { unsigned long long v1:16; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_C { unsigned long long v1:16; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_D { unsigned long long v1:16; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_F { unsigned long long v1:16; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_I { unsigned long long v1:16; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_Ip { unsigned long long v1:16; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_L { unsigned long long v1:16; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_S { unsigned long long v1:16; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_Uc { unsigned long long v1:16; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_Ui { unsigned long long v1:16; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_Ul { unsigned long long v1:16; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_Us { unsigned long long v1:16; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu7ll_Vp { unsigned long long v1:16; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s { unsigned long long v1:16; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu15i { unsigned long long v1:16; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu15ll { unsigned long long v1:16; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu15s { unsigned long long v1:16; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu16i { unsigned long long v1:16; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu16ll { unsigned long long v1:16; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu16s { unsigned long long v1:16; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu17i { unsigned long long v1:16; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu17ll { unsigned long long v1:16; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu1c { unsigned long long v1:16; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu1i { unsigned long long v1:16; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu1ll { unsigned long long v1:16; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu1s { unsigned long long v1:16; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu31i { unsigned long long v1:16; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu31ll { unsigned long long v1:16; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu32i { unsigned long long v1:16; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu32ll { unsigned long long v1:16; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu33 { unsigned long long v1:16; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu7c { unsigned long long v1:16; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu7i { unsigned long long v1:16; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu7ll { unsigned long long v1:16; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu7s { unsigned long long v1:16; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu8c { unsigned long long v1:16; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu8i { unsigned long long v1:16; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu8ll { unsigned long long v1:16; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu8s { unsigned long long v1:16; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu9i { unsigned long long v1:16; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu9ll { unsigned long long v1:16; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu7s_BFu9s { unsigned long long v1:16; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu7s_C { unsigned long long v1:16; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s_D { unsigned long long v1:16; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s_F { unsigned long long v1:16; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s_I { unsigned long long v1:16; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s_Ip { unsigned long long v1:16; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s_L { unsigned long long v1:16; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s_S { unsigned long long v1:16; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s_Uc { unsigned long long v1:16; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s_Ui { unsigned long long v1:16; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s_Ul { unsigned long long v1:16; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s_Us { unsigned long long v1:16; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu7s_Vp { unsigned long long v1:16; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c { unsigned long long v1:16; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu15i { unsigned long long v1:16; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu15ll { unsigned long long v1:16; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu15s { unsigned long long v1:16; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu16i { unsigned long long v1:16; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu16ll { unsigned long long v1:16; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu16s { unsigned long long v1:16; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu17i { unsigned long long v1:16; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu17ll { unsigned long long v1:16; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu1c { unsigned long long v1:16; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu1i { unsigned long long v1:16; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu1ll { unsigned long long v1:16; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu1s { unsigned long long v1:16; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu31i { unsigned long long v1:16; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu31ll { unsigned long long v1:16; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu32i { unsigned long long v1:16; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu32ll { unsigned long long v1:16; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu33 { unsigned long long v1:16; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu7c { unsigned long long v1:16; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu7i { unsigned long long v1:16; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu7ll { unsigned long long v1:16; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu7s { unsigned long long v1:16; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu8c { unsigned long long v1:16; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu8i { unsigned long long v1:16; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu8ll { unsigned long long v1:16; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu8s { unsigned long long v1:16; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu9i { unsigned long long v1:16; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu9ll { unsigned long long v1:16; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu8c_BFu9s { unsigned long long v1:16; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu8c_C { unsigned long long v1:16; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c_D { unsigned long long v1:16; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c_F { unsigned long long v1:16; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c_I { unsigned long long v1:16; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c_Ip { unsigned long long v1:16; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c_L { unsigned long long v1:16; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c_S { unsigned long long v1:16; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c_Uc { unsigned long long v1:16; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c_Ui { unsigned long long v1:16; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c_Ul { unsigned long long v1:16; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c_Us { unsigned long long v1:16; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu8c_Vp { unsigned long long v1:16; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i { unsigned long long v1:16; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu15i { unsigned long long v1:16; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu15ll { unsigned long long v1:16; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu15s { unsigned long long v1:16; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu16i { unsigned long long v1:16; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu16ll { unsigned long long v1:16; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu16s { unsigned long long v1:16; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu17i { unsigned long long v1:16; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu17ll { unsigned long long v1:16; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu1c { unsigned long long v1:16; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu1i { unsigned long long v1:16; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu1ll { unsigned long long v1:16; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu1s { unsigned long long v1:16; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu31i { unsigned long long v1:16; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu31ll { unsigned long long v1:16; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu32i { unsigned long long v1:16; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu32ll { unsigned long long v1:16; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu33 { unsigned long long v1:16; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu7c { unsigned long long v1:16; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu7i { unsigned long long v1:16; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu7ll { unsigned long long v1:16; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu7s { unsigned long long v1:16; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu8c { unsigned long long v1:16; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu8i { unsigned long long v1:16; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu8ll { unsigned long long v1:16; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu8s { unsigned long long v1:16; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu9i { unsigned long long v1:16; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu9ll { unsigned long long v1:16; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu8i_BFu9s { unsigned long long v1:16; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu8i_C { unsigned long long v1:16; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i_D { unsigned long long v1:16; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i_F { unsigned long long v1:16; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i_I { unsigned long long v1:16; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i_Ip { unsigned long long v1:16; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i_L { unsigned long long v1:16; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i_S { unsigned long long v1:16; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i_Uc { unsigned long long v1:16; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i_Ui { unsigned long long v1:16; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i_Ul { unsigned long long v1:16; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i_Us { unsigned long long v1:16; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu8i_Vp { unsigned long long v1:16; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll { unsigned long long v1:16; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu15i { unsigned long long v1:16; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu15ll { unsigned long long v1:16; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu15s { unsigned long long v1:16; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu16i { unsigned long long v1:16; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu16ll { unsigned long long v1:16; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu16s { unsigned long long v1:16; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu17i { unsigned long long v1:16; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu17ll { unsigned long long v1:16; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu1c { unsigned long long v1:16; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu1i { unsigned long long v1:16; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu1ll { unsigned long long v1:16; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu1s { unsigned long long v1:16; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu31i { unsigned long long v1:16; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu31ll { unsigned long long v1:16; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu32i { unsigned long long v1:16; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu32ll { unsigned long long v1:16; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu33 { unsigned long long v1:16; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu7c { unsigned long long v1:16; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu7i { unsigned long long v1:16; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu7ll { unsigned long long v1:16; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu7s { unsigned long long v1:16; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu8c { unsigned long long v1:16; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu8i { unsigned long long v1:16; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu8ll { unsigned long long v1:16; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu8s { unsigned long long v1:16; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu9i { unsigned long long v1:16; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu9ll { unsigned long long v1:16; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_BFu9s { unsigned long long v1:16; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_C { unsigned long long v1:16; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_D { unsigned long long v1:16; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_F { unsigned long long v1:16; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_I { unsigned long long v1:16; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_Ip { unsigned long long v1:16; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_L { unsigned long long v1:16; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_S { unsigned long long v1:16; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_Uc { unsigned long long v1:16; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_Ui { unsigned long long v1:16; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_Ul { unsigned long long v1:16; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_Us { unsigned long long v1:16; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu8ll_Vp { unsigned long long v1:16; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s { unsigned long long v1:16; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu15i { unsigned long long v1:16; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu15ll { unsigned long long v1:16; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu15s { unsigned long long v1:16; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu16i { unsigned long long v1:16; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu16ll { unsigned long long v1:16; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu16s { unsigned long long v1:16; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu17i { unsigned long long v1:16; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu17ll { unsigned long long v1:16; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu1c { unsigned long long v1:16; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu1i { unsigned long long v1:16; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu1ll { unsigned long long v1:16; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu1s { unsigned long long v1:16; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu31i { unsigned long long v1:16; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu31ll { unsigned long long v1:16; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu32i { unsigned long long v1:16; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu32ll { unsigned long long v1:16; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu33 { unsigned long long v1:16; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu7c { unsigned long long v1:16; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu7i { unsigned long long v1:16; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu7ll { unsigned long long v1:16; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu7s { unsigned long long v1:16; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu8c { unsigned long long v1:16; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu8i { unsigned long long v1:16; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu8ll { unsigned long long v1:16; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu8s { unsigned long long v1:16; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu9i { unsigned long long v1:16; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu9ll { unsigned long long v1:16; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu8s_BFu9s { unsigned long long v1:16; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu8s_C { unsigned long long v1:16; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s_D { unsigned long long v1:16; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s_F { unsigned long long v1:16; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s_I { unsigned long long v1:16; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s_Ip { unsigned long long v1:16; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s_L { unsigned long long v1:16; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s_S { unsigned long long v1:16; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s_Uc { unsigned long long v1:16; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s_Ui { unsigned long long v1:16; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s_Ul { unsigned long long v1:16; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s_Us { unsigned long long v1:16; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu8s_Vp { unsigned long long v1:16; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i { unsigned long long v1:16; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu15i { unsigned long long v1:16; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu15ll { unsigned long long v1:16; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu15s { unsigned long long v1:16; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu16i { unsigned long long v1:16; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu16ll { unsigned long long v1:16; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu16s { unsigned long long v1:16; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu17i { unsigned long long v1:16; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu17ll { unsigned long long v1:16; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu1c { unsigned long long v1:16; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu1i { unsigned long long v1:16; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu1ll { unsigned long long v1:16; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu1s { unsigned long long v1:16; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu31i { unsigned long long v1:16; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu31ll { unsigned long long v1:16; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu32i { unsigned long long v1:16; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu32ll { unsigned long long v1:16; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu33 { unsigned long long v1:16; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu7c { unsigned long long v1:16; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu7i { unsigned long long v1:16; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu7ll { unsigned long long v1:16; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu7s { unsigned long long v1:16; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu8c { unsigned long long v1:16; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu8i { unsigned long long v1:16; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu8ll { unsigned long long v1:16; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu8s { unsigned long long v1:16; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu9i { unsigned long long v1:16; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu9ll { unsigned long long v1:16; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu9i_BFu9s { unsigned long long v1:16; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu9i_C { unsigned long long v1:16; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i_D { unsigned long long v1:16; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i_F { unsigned long long v1:16; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i_I { unsigned long long v1:16; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i_Ip { unsigned long long v1:16; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i_L { unsigned long long v1:16; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i_S { unsigned long long v1:16; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i_Uc { unsigned long long v1:16; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i_Ui { unsigned long long v1:16; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i_Ul { unsigned long long v1:16; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i_Us { unsigned long long v1:16; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu9i_Vp { unsigned long long v1:16; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll { unsigned long long v1:16; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu15i { unsigned long long v1:16; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu15ll { unsigned long long v1:16; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu15s { unsigned long long v1:16; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu16i { unsigned long long v1:16; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu16ll { unsigned long long v1:16; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu16s { unsigned long long v1:16; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu17i { unsigned long long v1:16; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu17ll { unsigned long long v1:16; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu1c { unsigned long long v1:16; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu1i { unsigned long long v1:16; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu1ll { unsigned long long v1:16; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu1s { unsigned long long v1:16; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu31i { unsigned long long v1:16; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu31ll { unsigned long long v1:16; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu32i { unsigned long long v1:16; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu32ll { unsigned long long v1:16; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu33 { unsigned long long v1:16; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu7c { unsigned long long v1:16; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu7i { unsigned long long v1:16; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu7ll { unsigned long long v1:16; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu7s { unsigned long long v1:16; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu8c { unsigned long long v1:16; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu8i { unsigned long long v1:16; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu8ll { unsigned long long v1:16; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu8s { unsigned long long v1:16; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu9i { unsigned long long v1:16; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu9ll { unsigned long long v1:16; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_BFu9s { unsigned long long v1:16; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_C { unsigned long long v1:16; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_D { unsigned long long v1:16; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_F { unsigned long long v1:16; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_I { unsigned long long v1:16; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_Ip { unsigned long long v1:16; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_L { unsigned long long v1:16; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_S { unsigned long long v1:16; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_Uc { unsigned long long v1:16; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_Ui { unsigned long long v1:16; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_Ul { unsigned long long v1:16; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_Us { unsigned long long v1:16; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu9ll_Vp { unsigned long long v1:16; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s { unsigned long long v1:16; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu15i { unsigned long long v1:16; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu15ll { unsigned long long v1:16; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu15s { unsigned long long v1:16; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu16i { unsigned long long v1:16; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu16ll { unsigned long long v1:16; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu16s { unsigned long long v1:16; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu17i { unsigned long long v1:16; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu17ll { unsigned long long v1:16; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu1c { unsigned long long v1:16; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu1i { unsigned long long v1:16; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu1ll { unsigned long long v1:16; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu1s { unsigned long long v1:16; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu31i { unsigned long long v1:16; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu31ll { unsigned long long v1:16; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu32i { unsigned long long v1:16; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu32ll { unsigned long long v1:16; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu33 { unsigned long long v1:16; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu7c { unsigned long long v1:16; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu7i { unsigned long long v1:16; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu7ll { unsigned long long v1:16; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu7s { unsigned long long v1:16; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu8c { unsigned long long v1:16; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu8i { unsigned long long v1:16; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu8ll { unsigned long long v1:16; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu8s { unsigned long long v1:16; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu9i { unsigned long long v1:16; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu9ll { unsigned long long v1:16; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu9s_BFu9s { unsigned long long v1:16; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_BFu9s_C { unsigned long long v1:16; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s_D { unsigned long long v1:16; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s_F { unsigned long long v1:16; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s_I { unsigned long long v1:16; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s_Ip { unsigned long long v1:16; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s_L { unsigned long long v1:16; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s_S { unsigned long long v1:16; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s_Uc { unsigned long long v1:16; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s_Ui { unsigned long long v1:16; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s_Ul { unsigned long long v1:16; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s_Us { unsigned long long v1:16; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_BFu9s_Vp { unsigned long long v1:16; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aBFu16ll_C { unsigned long long v1:16; char v2; };
struct __attribute__((packed)) aBFu16ll_C_BFu15i { unsigned long long v1:16; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_C_BFu15ll { unsigned long long v1:16; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_C_BFu15s { unsigned long long v1:16; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_C_BFu16i { unsigned long long v1:16; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_C_BFu16ll { unsigned long long v1:16; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_C_BFu16s { unsigned long long v1:16; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_C_BFu17i { unsigned long long v1:16; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_C_BFu17ll { unsigned long long v1:16; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_C_BFu1c { unsigned long long v1:16; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_C_BFu1i { unsigned long long v1:16; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_C_BFu1ll { unsigned long long v1:16; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_C_BFu1s { unsigned long long v1:16; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_C_BFu31i { unsigned long long v1:16; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_C_BFu31ll { unsigned long long v1:16; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_C_BFu32i { unsigned long long v1:16; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_C_BFu32ll { unsigned long long v1:16; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_C_BFu33 { unsigned long long v1:16; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_C_BFu7c { unsigned long long v1:16; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_C_BFu7i { unsigned long long v1:16; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_C_BFu7ll { unsigned long long v1:16; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_C_BFu7s { unsigned long long v1:16; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_C_BFu8c { unsigned long long v1:16; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_C_BFu8i { unsigned long long v1:16; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_C_BFu8ll { unsigned long long v1:16; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_C_BFu8s { unsigned long long v1:16; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_C_BFu9i { unsigned long long v1:16; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_C_BFu9ll { unsigned long long v1:16; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_C_BFu9s { unsigned long long v1:16; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_C_C { unsigned long long v1:16; char v2; char v3; };
struct __attribute__((packed)) aBFu16ll_C_D { unsigned long long v1:16; char v2; double v3; };
struct __attribute__((packed)) aBFu16ll_C_F { unsigned long long v1:16; char v2; float v3; };
struct __attribute__((packed)) aBFu16ll_C_I { unsigned long long v1:16; char v2; int v3; };
struct __attribute__((packed)) aBFu16ll_C_Ip { unsigned long long v1:16; char v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_C_L { unsigned long long v1:16; char v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_C_S { unsigned long long v1:16; char v2; short v3; };
struct __attribute__((packed)) aBFu16ll_C_Uc { unsigned long long v1:16; char v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_C_Ui { unsigned long long v1:16; char v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_C_Ul { unsigned long long v1:16; char v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_C_Us { unsigned long long v1:16; char v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_C_Vp { unsigned long long v1:16; char v2; void * v3; };
struct __attribute__((packed)) aBFu16ll_D { unsigned long long v1:16; double v2; };
struct __attribute__((packed)) aBFu16ll_D_BFu15i { unsigned long long v1:16; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_D_BFu15ll { unsigned long long v1:16; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_D_BFu15s { unsigned long long v1:16; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_D_BFu16i { unsigned long long v1:16; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_D_BFu16ll { unsigned long long v1:16; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_D_BFu16s { unsigned long long v1:16; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_D_BFu17i { unsigned long long v1:16; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_D_BFu17ll { unsigned long long v1:16; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_D_BFu1c { unsigned long long v1:16; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_D_BFu1i { unsigned long long v1:16; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_D_BFu1ll { unsigned long long v1:16; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_D_BFu1s { unsigned long long v1:16; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_D_BFu31i { unsigned long long v1:16; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_D_BFu31ll { unsigned long long v1:16; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_D_BFu32i { unsigned long long v1:16; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_D_BFu32ll { unsigned long long v1:16; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_D_BFu33 { unsigned long long v1:16; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_D_BFu7c { unsigned long long v1:16; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_D_BFu7i { unsigned long long v1:16; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_D_BFu7ll { unsigned long long v1:16; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_D_BFu7s { unsigned long long v1:16; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_D_BFu8c { unsigned long long v1:16; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_D_BFu8i { unsigned long long v1:16; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_D_BFu8ll { unsigned long long v1:16; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_D_BFu8s { unsigned long long v1:16; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_D_BFu9i { unsigned long long v1:16; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_D_BFu9ll { unsigned long long v1:16; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_D_BFu9s { unsigned long long v1:16; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_D_C { unsigned long long v1:16; double v2; char v3; };
struct __attribute__((packed)) aBFu16ll_D_D { unsigned long long v1:16; double v2; double v3; };
struct __attribute__((packed)) aBFu16ll_D_F { unsigned long long v1:16; double v2; float v3; };
struct __attribute__((packed)) aBFu16ll_D_I { unsigned long long v1:16; double v2; int v3; };
struct __attribute__((packed)) aBFu16ll_D_Ip { unsigned long long v1:16; double v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_D_L { unsigned long long v1:16; double v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_D_S { unsigned long long v1:16; double v2; short v3; };
struct __attribute__((packed)) aBFu16ll_D_Uc { unsigned long long v1:16; double v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_D_Ui { unsigned long long v1:16; double v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_D_Ul { unsigned long long v1:16; double v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_D_Us { unsigned long long v1:16; double v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_D_Vp { unsigned long long v1:16; double v2; void * v3; };
struct __attribute__((packed)) aBFu16ll_F { unsigned long long v1:16; float v2; };
struct __attribute__((packed)) aBFu16ll_F_BFu15i { unsigned long long v1:16; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_F_BFu15ll { unsigned long long v1:16; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_F_BFu15s { unsigned long long v1:16; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_F_BFu16i { unsigned long long v1:16; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_F_BFu16ll { unsigned long long v1:16; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_F_BFu16s { unsigned long long v1:16; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_F_BFu17i { unsigned long long v1:16; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_F_BFu17ll { unsigned long long v1:16; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_F_BFu1c { unsigned long long v1:16; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_F_BFu1i { unsigned long long v1:16; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_F_BFu1ll { unsigned long long v1:16; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_F_BFu1s { unsigned long long v1:16; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_F_BFu31i { unsigned long long v1:16; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_F_BFu31ll { unsigned long long v1:16; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_F_BFu32i { unsigned long long v1:16; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_F_BFu32ll { unsigned long long v1:16; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_F_BFu33 { unsigned long long v1:16; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_F_BFu7c { unsigned long long v1:16; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_F_BFu7i { unsigned long long v1:16; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_F_BFu7ll { unsigned long long v1:16; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_F_BFu7s { unsigned long long v1:16; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_F_BFu8c { unsigned long long v1:16; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_F_BFu8i { unsigned long long v1:16; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_F_BFu8ll { unsigned long long v1:16; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_F_BFu8s { unsigned long long v1:16; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_F_BFu9i { unsigned long long v1:16; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_F_BFu9ll { unsigned long long v1:16; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_F_BFu9s { unsigned long long v1:16; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_F_C { unsigned long long v1:16; float v2; char v3; };
struct __attribute__((packed)) aBFu16ll_F_D { unsigned long long v1:16; float v2; double v3; };
struct __attribute__((packed)) aBFu16ll_F_F { unsigned long long v1:16; float v2; float v3; };
struct __attribute__((packed)) aBFu16ll_F_I { unsigned long long v1:16; float v2; int v3; };
struct __attribute__((packed)) aBFu16ll_F_Ip { unsigned long long v1:16; float v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_F_L { unsigned long long v1:16; float v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_F_S { unsigned long long v1:16; float v2; short v3; };
struct __attribute__((packed)) aBFu16ll_F_Uc { unsigned long long v1:16; float v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_F_Ui { unsigned long long v1:16; float v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_F_Ul { unsigned long long v1:16; float v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_F_Us { unsigned long long v1:16; float v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_F_Vp { unsigned long long v1:16; float v2; void * v3; };
struct __attribute__((packed)) aBFu16ll_I { unsigned long long v1:16; int v2; };
struct __attribute__((packed)) aBFu16ll_I_BFu15i { unsigned long long v1:16; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_I_BFu15ll { unsigned long long v1:16; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_I_BFu15s { unsigned long long v1:16; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_I_BFu16i { unsigned long long v1:16; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_I_BFu16ll { unsigned long long v1:16; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_I_BFu16s { unsigned long long v1:16; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_I_BFu17i { unsigned long long v1:16; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_I_BFu17ll { unsigned long long v1:16; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_I_BFu1c { unsigned long long v1:16; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_I_BFu1i { unsigned long long v1:16; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_I_BFu1ll { unsigned long long v1:16; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_I_BFu1s { unsigned long long v1:16; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_I_BFu31i { unsigned long long v1:16; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_I_BFu31ll { unsigned long long v1:16; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_I_BFu32i { unsigned long long v1:16; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_I_BFu32ll { unsigned long long v1:16; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_I_BFu33 { unsigned long long v1:16; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_I_BFu7c { unsigned long long v1:16; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_I_BFu7i { unsigned long long v1:16; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_I_BFu7ll { unsigned long long v1:16; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_I_BFu7s { unsigned long long v1:16; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_I_BFu8c { unsigned long long v1:16; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_I_BFu8i { unsigned long long v1:16; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_I_BFu8ll { unsigned long long v1:16; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_I_BFu8s { unsigned long long v1:16; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_I_BFu9i { unsigned long long v1:16; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_I_BFu9ll { unsigned long long v1:16; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_I_BFu9s { unsigned long long v1:16; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_I_C { unsigned long long v1:16; int v2; char v3; };
struct __attribute__((packed)) aBFu16ll_I_D { unsigned long long v1:16; int v2; double v3; };
struct __attribute__((packed)) aBFu16ll_I_F { unsigned long long v1:16; int v2; float v3; };
struct __attribute__((packed)) aBFu16ll_I_I { unsigned long long v1:16; int v2; int v3; };
struct __attribute__((packed)) aBFu16ll_I_Ip { unsigned long long v1:16; int v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_I_L { unsigned long long v1:16; int v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_I_S { unsigned long long v1:16; int v2; short v3; };
struct __attribute__((packed)) aBFu16ll_I_Uc { unsigned long long v1:16; int v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_I_Ui { unsigned long long v1:16; int v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_I_Ul { unsigned long long v1:16; int v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_I_Us { unsigned long long v1:16; int v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_I_Vp { unsigned long long v1:16; int v2; void * v3; };
struct __attribute__((packed)) aBFu16ll_Ip { unsigned long long v1:16; int * v2; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu15i { unsigned long long v1:16; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu15ll { unsigned long long v1:16; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu15s { unsigned long long v1:16; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu16i { unsigned long long v1:16; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu16ll { unsigned long long v1:16; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu16s { unsigned long long v1:16; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu17i { unsigned long long v1:16; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu17ll { unsigned long long v1:16; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu1c { unsigned long long v1:16; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu1i { unsigned long long v1:16; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu1ll { unsigned long long v1:16; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu1s { unsigned long long v1:16; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu31i { unsigned long long v1:16; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu31ll { unsigned long long v1:16; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu32i { unsigned long long v1:16; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu32ll { unsigned long long v1:16; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu33 { unsigned long long v1:16; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu7c { unsigned long long v1:16; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu7i { unsigned long long v1:16; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu7ll { unsigned long long v1:16; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu7s { unsigned long long v1:16; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu8c { unsigned long long v1:16; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu8i { unsigned long long v1:16; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu8ll { unsigned long long v1:16; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu8s { unsigned long long v1:16; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu9i { unsigned long long v1:16; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu9ll { unsigned long long v1:16; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_Ip_BFu9s { unsigned long long v1:16; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_Ip_C { unsigned long long v1:16; int * v2; char v3; };
struct __attribute__((packed)) aBFu16ll_Ip_D { unsigned long long v1:16; int * v2; double v3; };
struct __attribute__((packed)) aBFu16ll_Ip_F { unsigned long long v1:16; int * v2; float v3; };
struct __attribute__((packed)) aBFu16ll_Ip_I { unsigned long long v1:16; int * v2; int v3; };
struct __attribute__((packed)) aBFu16ll_Ip_Ip { unsigned long long v1:16; int * v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_Ip_L { unsigned long long v1:16; int * v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_Ip_S { unsigned long long v1:16; int * v2; short v3; };
struct __attribute__((packed)) aBFu16ll_Ip_Uc { unsigned long long v1:16; int * v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_Ip_Ui { unsigned long long v1:16; int * v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_Ip_Ul { unsigned long long v1:16; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_Ip_Us { unsigned long long v1:16; int * v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_Ip_Vp { unsigned long long v1:16; int * v2; void * v3; };
struct __attribute__((packed)) aBFu16ll_L { unsigned long long v1:16; long long v2; };
struct __attribute__((packed)) aBFu16ll_L_BFu15i { unsigned long long v1:16; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_L_BFu15ll { unsigned long long v1:16; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_L_BFu15s { unsigned long long v1:16; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_L_BFu16i { unsigned long long v1:16; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_L_BFu16ll { unsigned long long v1:16; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_L_BFu16s { unsigned long long v1:16; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_L_BFu17i { unsigned long long v1:16; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_L_BFu17ll { unsigned long long v1:16; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_L_BFu1c { unsigned long long v1:16; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_L_BFu1i { unsigned long long v1:16; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_L_BFu1ll { unsigned long long v1:16; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_L_BFu1s { unsigned long long v1:16; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_L_BFu31i { unsigned long long v1:16; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_L_BFu31ll { unsigned long long v1:16; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_L_BFu32i { unsigned long long v1:16; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_L_BFu32ll { unsigned long long v1:16; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_L_BFu33 { unsigned long long v1:16; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_L_BFu7c { unsigned long long v1:16; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_L_BFu7i { unsigned long long v1:16; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_L_BFu7ll { unsigned long long v1:16; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_L_BFu7s { unsigned long long v1:16; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_L_BFu8c { unsigned long long v1:16; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_L_BFu8i { unsigned long long v1:16; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_L_BFu8ll { unsigned long long v1:16; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_L_BFu8s { unsigned long long v1:16; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_L_BFu9i { unsigned long long v1:16; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_L_BFu9ll { unsigned long long v1:16; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_L_BFu9s { unsigned long long v1:16; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_L_C { unsigned long long v1:16; long long v2; char v3; };
struct __attribute__((packed)) aBFu16ll_L_D { unsigned long long v1:16; long long v2; double v3; };
struct __attribute__((packed)) aBFu16ll_L_F { unsigned long long v1:16; long long v2; float v3; };
struct __attribute__((packed)) aBFu16ll_L_I { unsigned long long v1:16; long long v2; int v3; };
struct __attribute__((packed)) aBFu16ll_L_Ip { unsigned long long v1:16; long long v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_L_L { unsigned long long v1:16; long long v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_L_S { unsigned long long v1:16; long long v2; short v3; };
struct __attribute__((packed)) aBFu16ll_L_Uc { unsigned long long v1:16; long long v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_L_Ui { unsigned long long v1:16; long long v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_L_Ul { unsigned long long v1:16; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_L_Us { unsigned long long v1:16; long long v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_L_Vp { unsigned long long v1:16; long long v2; void * v3; };
struct __attribute__((packed)) aBFu16ll_S { unsigned long long v1:16; short v2; };
struct __attribute__((packed)) aBFu16ll_S_BFu15i { unsigned long long v1:16; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_S_BFu15ll { unsigned long long v1:16; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_S_BFu15s { unsigned long long v1:16; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_S_BFu16i { unsigned long long v1:16; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_S_BFu16ll { unsigned long long v1:16; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_S_BFu16s { unsigned long long v1:16; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_S_BFu17i { unsigned long long v1:16; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_S_BFu17ll { unsigned long long v1:16; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_S_BFu1c { unsigned long long v1:16; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_S_BFu1i { unsigned long long v1:16; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_S_BFu1ll { unsigned long long v1:16; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_S_BFu1s { unsigned long long v1:16; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_S_BFu31i { unsigned long long v1:16; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_S_BFu31ll { unsigned long long v1:16; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_S_BFu32i { unsigned long long v1:16; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_S_BFu32ll { unsigned long long v1:16; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_S_BFu33 { unsigned long long v1:16; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_S_BFu7c { unsigned long long v1:16; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_S_BFu7i { unsigned long long v1:16; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_S_BFu7ll { unsigned long long v1:16; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_S_BFu7s { unsigned long long v1:16; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_S_BFu8c { unsigned long long v1:16; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_S_BFu8i { unsigned long long v1:16; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_S_BFu8ll { unsigned long long v1:16; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_S_BFu8s { unsigned long long v1:16; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_S_BFu9i { unsigned long long v1:16; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_S_BFu9ll { unsigned long long v1:16; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_S_BFu9s { unsigned long long v1:16; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_S_C { unsigned long long v1:16; short v2; char v3; };
struct __attribute__((packed)) aBFu16ll_S_D { unsigned long long v1:16; short v2; double v3; };
struct __attribute__((packed)) aBFu16ll_S_F { unsigned long long v1:16; short v2; float v3; };
struct __attribute__((packed)) aBFu16ll_S_I { unsigned long long v1:16; short v2; int v3; };
struct __attribute__((packed)) aBFu16ll_S_Ip { unsigned long long v1:16; short v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_S_L { unsigned long long v1:16; short v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_S_S { unsigned long long v1:16; short v2; short v3; };
struct __attribute__((packed)) aBFu16ll_S_Uc { unsigned long long v1:16; short v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_S_Ui { unsigned long long v1:16; short v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_S_Ul { unsigned long long v1:16; short v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_S_Us { unsigned long long v1:16; short v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_S_Vp { unsigned long long v1:16; short v2; void * v3; };
struct __attribute__((packed)) aBFu16ll_Uc { unsigned long long v1:16; unsigned char v2; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu15i { unsigned long long v1:16; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu15ll { unsigned long long v1:16; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu15s { unsigned long long v1:16; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu16i { unsigned long long v1:16; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu16ll { unsigned long long v1:16; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu16s { unsigned long long v1:16; unsigned char v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu17i { unsigned long long v1:16; unsigned char v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu17ll { unsigned long long v1:16; unsigned char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu1c { unsigned long long v1:16; unsigned char v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu1i { unsigned long long v1:16; unsigned char v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu1ll { unsigned long long v1:16; unsigned char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu1s { unsigned long long v1:16; unsigned char v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu31i { unsigned long long v1:16; unsigned char v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu31ll { unsigned long long v1:16; unsigned char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu32i { unsigned long long v1:16; unsigned char v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu32ll { unsigned long long v1:16; unsigned char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu33 { unsigned long long v1:16; unsigned char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu7c { unsigned long long v1:16; unsigned char v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu7i { unsigned long long v1:16; unsigned char v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu7ll { unsigned long long v1:16; unsigned char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu7s { unsigned long long v1:16; unsigned char v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu8c { unsigned long long v1:16; unsigned char v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu8i { unsigned long long v1:16; unsigned char v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu8ll { unsigned long long v1:16; unsigned char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu8s { unsigned long long v1:16; unsigned char v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu9i { unsigned long long v1:16; unsigned char v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu9ll { unsigned long long v1:16; unsigned char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_Uc_BFu9s { unsigned long long v1:16; unsigned char v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_Uc_C { unsigned long long v1:16; unsigned char v2; char v3; };
struct __attribute__((packed)) aBFu16ll_Uc_D { unsigned long long v1:16; unsigned char v2; double v3; };
struct __attribute__((packed)) aBFu16ll_Uc_F { unsigned long long v1:16; unsigned char v2; float v3; };
struct __attribute__((packed)) aBFu16ll_Uc_I { unsigned long long v1:16; unsigned char v2; int v3; };
struct __attribute__((packed)) aBFu16ll_Uc_Ip { unsigned long long v1:16; unsigned char v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_Uc_L { unsigned long long v1:16; unsigned char v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_Uc_S { unsigned long long v1:16; unsigned char v2; short v3; };
struct __attribute__((packed)) aBFu16ll_Uc_Uc { unsigned long long v1:16; unsigned char v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_Uc_Ui { unsigned long long v1:16; unsigned char v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_Uc_Ul { unsigned long long v1:16; unsigned char v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_Uc_Us { unsigned long long v1:16; unsigned char v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_Uc_Vp { unsigned long long v1:16; unsigned char v2; void * v3; };
struct __attribute__((packed)) aBFu16ll_Ui { unsigned long long v1:16; unsigned int v2; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu15i { unsigned long long v1:16; unsigned int v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu15ll { unsigned long long v1:16; unsigned int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu15s { unsigned long long v1:16; unsigned int v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu16i { unsigned long long v1:16; unsigned int v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu16ll { unsigned long long v1:16; unsigned int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu16s { unsigned long long v1:16; unsigned int v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu17i { unsigned long long v1:16; unsigned int v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu17ll { unsigned long long v1:16; unsigned int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu1c { unsigned long long v1:16; unsigned int v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu1i { unsigned long long v1:16; unsigned int v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu1ll { unsigned long long v1:16; unsigned int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu1s { unsigned long long v1:16; unsigned int v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu31i { unsigned long long v1:16; unsigned int v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu31ll { unsigned long long v1:16; unsigned int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu32i { unsigned long long v1:16; unsigned int v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu32ll { unsigned long long v1:16; unsigned int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu33 { unsigned long long v1:16; unsigned int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu7c { unsigned long long v1:16; unsigned int v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu7i { unsigned long long v1:16; unsigned int v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu7ll { unsigned long long v1:16; unsigned int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu7s { unsigned long long v1:16; unsigned int v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu8c { unsigned long long v1:16; unsigned int v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu8i { unsigned long long v1:16; unsigned int v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu8ll { unsigned long long v1:16; unsigned int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu8s { unsigned long long v1:16; unsigned int v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu9i { unsigned long long v1:16; unsigned int v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu9ll { unsigned long long v1:16; unsigned int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_Ui_BFu9s { unsigned long long v1:16; unsigned int v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_Ui_C { unsigned long long v1:16; unsigned int v2; char v3; };
struct __attribute__((packed)) aBFu16ll_Ui_D { unsigned long long v1:16; unsigned int v2; double v3; };
struct __attribute__((packed)) aBFu16ll_Ui_F { unsigned long long v1:16; unsigned int v2; float v3; };
struct __attribute__((packed)) aBFu16ll_Ui_I { unsigned long long v1:16; unsigned int v2; int v3; };
struct __attribute__((packed)) aBFu16ll_Ui_Ip { unsigned long long v1:16; unsigned int v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_Ui_L { unsigned long long v1:16; unsigned int v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_Ui_S { unsigned long long v1:16; unsigned int v2; short v3; };
struct __attribute__((packed)) aBFu16ll_Ui_Uc { unsigned long long v1:16; unsigned int v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_Ui_Ui { unsigned long long v1:16; unsigned int v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_Ui_Ul { unsigned long long v1:16; unsigned int v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_Ui_Us { unsigned long long v1:16; unsigned int v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_Ui_Vp { unsigned long long v1:16; unsigned int v2; void * v3; };
struct __attribute__((packed)) aBFu16ll_Ul { unsigned long long v1:16; unsigned long long v2; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu15i { unsigned long long v1:16; unsigned long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu15ll { unsigned long long v1:16; unsigned long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu15s { unsigned long long v1:16; unsigned long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu16i { unsigned long long v1:16; unsigned long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu16ll { unsigned long long v1:16; unsigned long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu16s { unsigned long long v1:16; unsigned long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu17i { unsigned long long v1:16; unsigned long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu17ll { unsigned long long v1:16; unsigned long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu1c { unsigned long long v1:16; unsigned long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu1i { unsigned long long v1:16; unsigned long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu1ll { unsigned long long v1:16; unsigned long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu1s { unsigned long long v1:16; unsigned long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu31i { unsigned long long v1:16; unsigned long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu31ll { unsigned long long v1:16; unsigned long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu32i { unsigned long long v1:16; unsigned long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu32ll { unsigned long long v1:16; unsigned long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu33 { unsigned long long v1:16; unsigned long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu7c { unsigned long long v1:16; unsigned long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu7i { unsigned long long v1:16; unsigned long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu7ll { unsigned long long v1:16; unsigned long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu7s { unsigned long long v1:16; unsigned long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu8c { unsigned long long v1:16; unsigned long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu8i { unsigned long long v1:16; unsigned long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu8ll { unsigned long long v1:16; unsigned long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu8s { unsigned long long v1:16; unsigned long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu9i { unsigned long long v1:16; unsigned long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu9ll { unsigned long long v1:16; unsigned long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_Ul_BFu9s { unsigned long long v1:16; unsigned long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_Ul_C { unsigned long long v1:16; unsigned long long v2; char v3; };
struct __attribute__((packed)) aBFu16ll_Ul_D { unsigned long long v1:16; unsigned long long v2; double v3; };
struct __attribute__((packed)) aBFu16ll_Ul_F { unsigned long long v1:16; unsigned long long v2; float v3; };
struct __attribute__((packed)) aBFu16ll_Ul_I { unsigned long long v1:16; unsigned long long v2; int v3; };
struct __attribute__((packed)) aBFu16ll_Ul_Ip { unsigned long long v1:16; unsigned long long v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_Ul_L { unsigned long long v1:16; unsigned long long v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_Ul_S { unsigned long long v1:16; unsigned long long v2; short v3; };
struct __attribute__((packed)) aBFu16ll_Ul_Uc { unsigned long long v1:16; unsigned long long v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_Ul_Ui { unsigned long long v1:16; unsigned long long v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_Ul_Ul { unsigned long long v1:16; unsigned long long v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_Ul_Us { unsigned long long v1:16; unsigned long long v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_Ul_Vp { unsigned long long v1:16; unsigned long long v2; void * v3; };
struct __attribute__((packed)) aBFu16ll_Us { unsigned long long v1:16; unsigned short v2; };
struct __attribute__((packed)) aBFu16ll_Us_BFu15i { unsigned long long v1:16; unsigned short v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_Us_BFu15ll { unsigned long long v1:16; unsigned short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_Us_BFu15s { unsigned long long v1:16; unsigned short v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_Us_BFu16i { unsigned long long v1:16; unsigned short v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_Us_BFu16ll { unsigned long long v1:16; unsigned short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_Us_BFu16s { unsigned long long v1:16; unsigned short v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_Us_BFu17i { unsigned long long v1:16; unsigned short v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_Us_BFu17ll { unsigned long long v1:16; unsigned short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_Us_BFu1c { unsigned long long v1:16; unsigned short v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_Us_BFu1i { unsigned long long v1:16; unsigned short v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_Us_BFu1ll { unsigned long long v1:16; unsigned short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_Us_BFu1s { unsigned long long v1:16; unsigned short v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_Us_BFu31i { unsigned long long v1:16; unsigned short v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_Us_BFu31ll { unsigned long long v1:16; unsigned short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_Us_BFu32i { unsigned long long v1:16; unsigned short v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_Us_BFu32ll { unsigned long long v1:16; unsigned short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_Us_BFu33 { unsigned long long v1:16; unsigned short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_Us_BFu7c { unsigned long long v1:16; unsigned short v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_Us_BFu7i { unsigned long long v1:16; unsigned short v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_Us_BFu7ll { unsigned long long v1:16; unsigned short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_Us_BFu7s { unsigned long long v1:16; unsigned short v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_Us_BFu8c { unsigned long long v1:16; unsigned short v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_Us_BFu8i { unsigned long long v1:16; unsigned short v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_Us_BFu8ll { unsigned long long v1:16; unsigned short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_Us_BFu8s { unsigned long long v1:16; unsigned short v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_Us_BFu9i { unsigned long long v1:16; unsigned short v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_Us_BFu9ll { unsigned long long v1:16; unsigned short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_Us_BFu9s { unsigned long long v1:16; unsigned short v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_Us_C { unsigned long long v1:16; unsigned short v2; char v3; };
struct __attribute__((packed)) aBFu16ll_Us_D { unsigned long long v1:16; unsigned short v2; double v3; };
struct __attribute__((packed)) aBFu16ll_Us_F { unsigned long long v1:16; unsigned short v2; float v3; };
struct __attribute__((packed)) aBFu16ll_Us_I { unsigned long long v1:16; unsigned short v2; int v3; };
struct __attribute__((packed)) aBFu16ll_Us_Ip { unsigned long long v1:16; unsigned short v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_Us_L { unsigned long long v1:16; unsigned short v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_Us_S { unsigned long long v1:16; unsigned short v2; short v3; };
struct __attribute__((packed)) aBFu16ll_Us_Uc { unsigned long long v1:16; unsigned short v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_Us_Ui { unsigned long long v1:16; unsigned short v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_Us_Ul { unsigned long long v1:16; unsigned short v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_Us_Us { unsigned long long v1:16; unsigned short v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_Us_Vp { unsigned long long v1:16; unsigned short v2; void * v3; };
struct __attribute__((packed)) aBFu16ll_Vp { unsigned long long v1:16; void * v2; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu15i { unsigned long long v1:16; void * v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu15ll { unsigned long long v1:16; void * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu15s { unsigned long long v1:16; void * v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu16i { unsigned long long v1:16; void * v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu16ll { unsigned long long v1:16; void * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu16s { unsigned long long v1:16; void * v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu17i { unsigned long long v1:16; void * v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu17ll { unsigned long long v1:16; void * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu1c { unsigned long long v1:16; void * v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu1i { unsigned long long v1:16; void * v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu1ll { unsigned long long v1:16; void * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu1s { unsigned long long v1:16; void * v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu31i { unsigned long long v1:16; void * v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu31ll { unsigned long long v1:16; void * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu32i { unsigned long long v1:16; void * v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu32ll { unsigned long long v1:16; void * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu33 { unsigned long long v1:16; void * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu7c { unsigned long long v1:16; void * v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu7i { unsigned long long v1:16; void * v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu7ll { unsigned long long v1:16; void * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu7s { unsigned long long v1:16; void * v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu8c { unsigned long long v1:16; void * v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu8i { unsigned long long v1:16; void * v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu8ll { unsigned long long v1:16; void * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu8s { unsigned long long v1:16; void * v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu9i { unsigned long long v1:16; void * v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu9ll { unsigned long long v1:16; void * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16ll_Vp_BFu9s { unsigned long long v1:16; void * v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16ll_Vp_C { unsigned long long v1:16; void * v2; char v3; };
struct __attribute__((packed)) aBFu16ll_Vp_D { unsigned long long v1:16; void * v2; double v3; };
struct __attribute__((packed)) aBFu16ll_Vp_F { unsigned long long v1:16; void * v2; float v3; };
struct __attribute__((packed)) aBFu16ll_Vp_I { unsigned long long v1:16; void * v2; int v3; };
struct __attribute__((packed)) aBFu16ll_Vp_Ip { unsigned long long v1:16; void * v2; int * v3; };
struct __attribute__((packed)) aBFu16ll_Vp_L { unsigned long long v1:16; void * v2; long long v3; };
struct __attribute__((packed)) aBFu16ll_Vp_S { unsigned long long v1:16; void * v2; short v3; };
struct __attribute__((packed)) aBFu16ll_Vp_Uc { unsigned long long v1:16; void * v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16ll_Vp_Ui { unsigned long long v1:16; void * v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16ll_Vp_Ul { unsigned long long v1:16; void * v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16ll_Vp_Us { unsigned long long v1:16; void * v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16ll_Vp_Vp { unsigned long long v1:16; void * v2; void * v3; };
struct __attribute__((packed)) aBFu16s { unsigned short v1:16; };
struct __attribute__((packed)) aBFu16s_BFs16i { unsigned short v1:16; signed int v2:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16i { unsigned short v1:16; signed int v2:16; signed int v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16i_BFs16i { unsigned short v1:16; signed int v2:16; signed int v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16i_BFs16ll { unsigned short v1:16; signed int v2:16; signed int v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16i_BFs16s { unsigned short v1:16; signed int v2:16; signed int v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16i_BFu16i { unsigned short v1:16; signed int v2:16; signed int v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16i_BFu16ll { unsigned short v1:16; signed int v2:16; signed int v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16i_BFu16s { unsigned short v1:16; signed int v2:16; signed int v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16ll { unsigned short v1:16; signed int v2:16; signed long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16ll_BFs16i { unsigned short v1:16; signed int v2:16; signed long long v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16ll_BFs16ll { unsigned short v1:16; signed int v2:16; signed long long v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16ll_BFs16s { unsigned short v1:16; signed int v2:16; signed long long v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16ll_BFu16i { unsigned short v1:16; signed int v2:16; signed long long v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16ll_BFu16ll { unsigned short v1:16; signed int v2:16; signed long long v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16ll_BFu16s { unsigned short v1:16; signed int v2:16; signed long long v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16s { unsigned short v1:16; signed int v2:16; signed short v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16s_BFs16i { unsigned short v1:16; signed int v2:16; signed short v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16s_BFs16ll { unsigned short v1:16; signed int v2:16; signed short v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16s_BFs16s { unsigned short v1:16; signed int v2:16; signed short v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16s_BFu16i { unsigned short v1:16; signed int v2:16; signed short v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16s_BFu16ll { unsigned short v1:16; signed int v2:16; signed short v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFs16s_BFu16s { unsigned short v1:16; signed int v2:16; signed short v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16i { unsigned short v1:16; signed int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16i_BFs16i { unsigned short v1:16; signed int v2:16; unsigned int v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16i_BFs16ll { unsigned short v1:16; signed int v2:16; unsigned int v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16i_BFs16s { unsigned short v1:16; signed int v2:16; unsigned int v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16i_BFu16i { unsigned short v1:16; signed int v2:16; unsigned int v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16i_BFu16ll { unsigned short v1:16; signed int v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16i_BFu16s { unsigned short v1:16; signed int v2:16; unsigned int v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16ll { unsigned short v1:16; signed int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16ll_BFs16i { unsigned short v1:16; signed int v2:16; unsigned long long v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16ll_BFs16ll { unsigned short v1:16; signed int v2:16; unsigned long long v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16ll_BFs16s { unsigned short v1:16; signed int v2:16; unsigned long long v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16ll_BFu16i { unsigned short v1:16; signed int v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16ll_BFu16ll { unsigned short v1:16; signed int v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16ll_BFu16s { unsigned short v1:16; signed int v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16s { unsigned short v1:16; signed int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16s_BFs16i { unsigned short v1:16; signed int v2:16; unsigned short v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16s_BFs16ll { unsigned short v1:16; signed int v2:16; unsigned short v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16s_BFs16s { unsigned short v1:16; signed int v2:16; unsigned short v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16s_BFu16i { unsigned short v1:16; signed int v2:16; unsigned short v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16s_BFu16ll { unsigned short v1:16; signed int v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16i_BFu16s_BFu16s { unsigned short v1:16; signed int v2:16; unsigned short v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll { unsigned short v1:16; signed long long v2:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16i { unsigned short v1:16; signed long long v2:16; signed int v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16i_BFs16i { unsigned short v1:16; signed long long v2:16; signed int v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16i_BFs16ll { unsigned short v1:16; signed long long v2:16; signed int v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16i_BFs16s { unsigned short v1:16; signed long long v2:16; signed int v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16i_BFu16i { unsigned short v1:16; signed long long v2:16; signed int v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16i_BFu16ll { unsigned short v1:16; signed long long v2:16; signed int v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16i_BFu16s { unsigned short v1:16; signed long long v2:16; signed int v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16ll { unsigned short v1:16; signed long long v2:16; signed long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16ll_BFs16i { unsigned short v1:16; signed long long v2:16; signed long long v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16ll_BFs16ll { unsigned short v1:16; signed long long v2:16; signed long long v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16ll_BFs16s { unsigned short v1:16; signed long long v2:16; signed long long v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16ll_BFu16i { unsigned short v1:16; signed long long v2:16; signed long long v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16ll_BFu16ll { unsigned short v1:16; signed long long v2:16; signed long long v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16ll_BFu16s { unsigned short v1:16; signed long long v2:16; signed long long v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16s { unsigned short v1:16; signed long long v2:16; signed short v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16s_BFs16i { unsigned short v1:16; signed long long v2:16; signed short v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16s_BFs16ll { unsigned short v1:16; signed long long v2:16; signed short v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16s_BFs16s { unsigned short v1:16; signed long long v2:16; signed short v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16s_BFu16i { unsigned short v1:16; signed long long v2:16; signed short v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16s_BFu16ll { unsigned short v1:16; signed long long v2:16; signed short v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFs16s_BFu16s { unsigned short v1:16; signed long long v2:16; signed short v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16i { unsigned short v1:16; signed long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16i_BFs16i { unsigned short v1:16; signed long long v2:16; unsigned int v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16i_BFs16ll { unsigned short v1:16; signed long long v2:16; unsigned int v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16i_BFs16s { unsigned short v1:16; signed long long v2:16; unsigned int v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16i_BFu16i { unsigned short v1:16; signed long long v2:16; unsigned int v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16i_BFu16ll { unsigned short v1:16; signed long long v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16i_BFu16s { unsigned short v1:16; signed long long v2:16; unsigned int v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16ll { unsigned short v1:16; signed long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16ll_BFs16i { unsigned short v1:16; signed long long v2:16; unsigned long long v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16ll_BFs16ll { unsigned short v1:16; signed long long v2:16; unsigned long long v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16ll_BFs16s { unsigned short v1:16; signed long long v2:16; unsigned long long v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16ll_BFu16i { unsigned short v1:16; signed long long v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16ll_BFu16ll { unsigned short v1:16; signed long long v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16ll_BFu16s { unsigned short v1:16; signed long long v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16s { unsigned short v1:16; signed long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16s_BFs16i { unsigned short v1:16; signed long long v2:16; unsigned short v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16s_BFs16ll { unsigned short v1:16; signed long long v2:16; unsigned short v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16s_BFs16s { unsigned short v1:16; signed long long v2:16; unsigned short v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16s_BFu16i { unsigned short v1:16; signed long long v2:16; unsigned short v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16s_BFu16ll { unsigned short v1:16; signed long long v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16ll_BFu16s_BFu16s { unsigned short v1:16; signed long long v2:16; unsigned short v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s { unsigned short v1:16; signed short v2:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16i { unsigned short v1:16; signed short v2:16; signed int v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16i_BFs16i { unsigned short v1:16; signed short v2:16; signed int v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16i_BFs16ll { unsigned short v1:16; signed short v2:16; signed int v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16i_BFs16s { unsigned short v1:16; signed short v2:16; signed int v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16i_BFu16i { unsigned short v1:16; signed short v2:16; signed int v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16i_BFu16ll { unsigned short v1:16; signed short v2:16; signed int v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16i_BFu16s { unsigned short v1:16; signed short v2:16; signed int v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16ll { unsigned short v1:16; signed short v2:16; signed long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16ll_BFs16i { unsigned short v1:16; signed short v2:16; signed long long v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16ll_BFs16ll { unsigned short v1:16; signed short v2:16; signed long long v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16ll_BFs16s { unsigned short v1:16; signed short v2:16; signed long long v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16ll_BFu16i { unsigned short v1:16; signed short v2:16; signed long long v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16ll_BFu16ll { unsigned short v1:16; signed short v2:16; signed long long v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16ll_BFu16s { unsigned short v1:16; signed short v2:16; signed long long v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16s { unsigned short v1:16; signed short v2:16; signed short v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16s_BFs16i { unsigned short v1:16; signed short v2:16; signed short v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16s_BFs16ll { unsigned short v1:16; signed short v2:16; signed short v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16s_BFs16s { unsigned short v1:16; signed short v2:16; signed short v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16s_BFu16i { unsigned short v1:16; signed short v2:16; signed short v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16s_BFu16ll { unsigned short v1:16; signed short v2:16; signed short v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFs16s_BFu16s { unsigned short v1:16; signed short v2:16; signed short v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16i { unsigned short v1:16; signed short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16i_BFs16i { unsigned short v1:16; signed short v2:16; unsigned int v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16i_BFs16ll { unsigned short v1:16; signed short v2:16; unsigned int v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16i_BFs16s { unsigned short v1:16; signed short v2:16; unsigned int v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16i_BFu16i { unsigned short v1:16; signed short v2:16; unsigned int v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16i_BFu16ll { unsigned short v1:16; signed short v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16i_BFu16s { unsigned short v1:16; signed short v2:16; unsigned int v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16ll { unsigned short v1:16; signed short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16ll_BFs16i { unsigned short v1:16; signed short v2:16; unsigned long long v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16ll_BFs16ll { unsigned short v1:16; signed short v2:16; unsigned long long v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16ll_BFs16s { unsigned short v1:16; signed short v2:16; unsigned long long v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16ll_BFu16i { unsigned short v1:16; signed short v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16ll_BFu16ll { unsigned short v1:16; signed short v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16ll_BFu16s { unsigned short v1:16; signed short v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16s { unsigned short v1:16; signed short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16s_BFs16i { unsigned short v1:16; signed short v2:16; unsigned short v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16s_BFs16ll { unsigned short v1:16; signed short v2:16; unsigned short v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16s_BFs16s { unsigned short v1:16; signed short v2:16; unsigned short v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16s_BFu16i { unsigned short v1:16; signed short v2:16; unsigned short v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16s_BFu16ll { unsigned short v1:16; signed short v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFs16s_BFu16s_BFu16s { unsigned short v1:16; signed short v2:16; unsigned short v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu15i { unsigned short v1:16; unsigned int v2:15; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu15i { unsigned short v1:16; unsigned int v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu15ll { unsigned short v1:16; unsigned int v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu15s { unsigned short v1:16; unsigned int v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu16i { unsigned short v1:16; unsigned int v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu16ll { unsigned short v1:16; unsigned int v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu16s { unsigned short v1:16; unsigned int v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu17i { unsigned short v1:16; unsigned int v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu17ll { unsigned short v1:16; unsigned int v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu1c { unsigned short v1:16; unsigned int v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu1i { unsigned short v1:16; unsigned int v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu1ll { unsigned short v1:16; unsigned int v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu1s { unsigned short v1:16; unsigned int v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu31i { unsigned short v1:16; unsigned int v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu31ll { unsigned short v1:16; unsigned int v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu32i { unsigned short v1:16; unsigned int v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu32ll { unsigned short v1:16; unsigned int v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu33 { unsigned short v1:16; unsigned int v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu7c { unsigned short v1:16; unsigned int v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu7i { unsigned short v1:16; unsigned int v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu7ll { unsigned short v1:16; unsigned int v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu7s { unsigned short v1:16; unsigned int v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu8c { unsigned short v1:16; unsigned int v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu8i { unsigned short v1:16; unsigned int v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu8ll { unsigned short v1:16; unsigned int v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu8s { unsigned short v1:16; unsigned int v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu9i { unsigned short v1:16; unsigned int v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu9ll { unsigned short v1:16; unsigned int v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu15i_BFu9s { unsigned short v1:16; unsigned int v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu15i_C { unsigned short v1:16; unsigned int v2:15; char v3; };
struct __attribute__((packed)) aBFu16s_BFu15i_D { unsigned short v1:16; unsigned int v2:15; double v3; };
struct __attribute__((packed)) aBFu16s_BFu15i_F { unsigned short v1:16; unsigned int v2:15; float v3; };
struct __attribute__((packed)) aBFu16s_BFu15i_I { unsigned short v1:16; unsigned int v2:15; int v3; };
struct __attribute__((packed)) aBFu16s_BFu15i_Ip { unsigned short v1:16; unsigned int v2:15; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu15i_L { unsigned short v1:16; unsigned int v2:15; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu15i_S { unsigned short v1:16; unsigned int v2:15; short v3; };
struct __attribute__((packed)) aBFu16s_BFu15i_Uc { unsigned short v1:16; unsigned int v2:15; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu15i_Ui { unsigned short v1:16; unsigned int v2:15; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu15i_Ul { unsigned short v1:16; unsigned int v2:15; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu15i_Us { unsigned short v1:16; unsigned int v2:15; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu15i_Vp { unsigned short v1:16; unsigned int v2:15; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll { unsigned short v1:16; unsigned long long v2:15; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu15i { unsigned short v1:16; unsigned long long v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu15ll { unsigned short v1:16; unsigned long long v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu15s { unsigned short v1:16; unsigned long long v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu16i { unsigned short v1:16; unsigned long long v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu16ll { unsigned short v1:16; unsigned long long v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu16s { unsigned short v1:16; unsigned long long v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu17i { unsigned short v1:16; unsigned long long v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu17ll { unsigned short v1:16; unsigned long long v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu1c { unsigned short v1:16; unsigned long long v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu1i { unsigned short v1:16; unsigned long long v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu1ll { unsigned short v1:16; unsigned long long v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu1s { unsigned short v1:16; unsigned long long v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu31i { unsigned short v1:16; unsigned long long v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu31ll { unsigned short v1:16; unsigned long long v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu32i { unsigned short v1:16; unsigned long long v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu32ll { unsigned short v1:16; unsigned long long v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu33 { unsigned short v1:16; unsigned long long v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu7c { unsigned short v1:16; unsigned long long v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu7i { unsigned short v1:16; unsigned long long v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu7ll { unsigned short v1:16; unsigned long long v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu7s { unsigned short v1:16; unsigned long long v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu8c { unsigned short v1:16; unsigned long long v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu8i { unsigned short v1:16; unsigned long long v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu8ll { unsigned short v1:16; unsigned long long v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu8s { unsigned short v1:16; unsigned long long v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu9i { unsigned short v1:16; unsigned long long v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu9ll { unsigned short v1:16; unsigned long long v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu15ll_BFu9s { unsigned short v1:16; unsigned long long v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu15ll_C { unsigned short v1:16; unsigned long long v2:15; char v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll_D { unsigned short v1:16; unsigned long long v2:15; double v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll_F { unsigned short v1:16; unsigned long long v2:15; float v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll_I { unsigned short v1:16; unsigned long long v2:15; int v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll_Ip { unsigned short v1:16; unsigned long long v2:15; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll_L { unsigned short v1:16; unsigned long long v2:15; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll_S { unsigned short v1:16; unsigned long long v2:15; short v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll_Uc { unsigned short v1:16; unsigned long long v2:15; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll_Ui { unsigned short v1:16; unsigned long long v2:15; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll_Ul { unsigned short v1:16; unsigned long long v2:15; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll_Us { unsigned short v1:16; unsigned long long v2:15; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu15ll_Vp { unsigned short v1:16; unsigned long long v2:15; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu15s { unsigned short v1:16; unsigned short v2:15; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu15i { unsigned short v1:16; unsigned short v2:15; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu15ll { unsigned short v1:16; unsigned short v2:15; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu15s { unsigned short v1:16; unsigned short v2:15; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu16i { unsigned short v1:16; unsigned short v2:15; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu16ll { unsigned short v1:16; unsigned short v2:15; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu16s { unsigned short v1:16; unsigned short v2:15; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu17i { unsigned short v1:16; unsigned short v2:15; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu17ll { unsigned short v1:16; unsigned short v2:15; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu1c { unsigned short v1:16; unsigned short v2:15; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu1i { unsigned short v1:16; unsigned short v2:15; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu1ll { unsigned short v1:16; unsigned short v2:15; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu1s { unsigned short v1:16; unsigned short v2:15; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu31i { unsigned short v1:16; unsigned short v2:15; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu31ll { unsigned short v1:16; unsigned short v2:15; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu32i { unsigned short v1:16; unsigned short v2:15; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu32ll { unsigned short v1:16; unsigned short v2:15; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu33 { unsigned short v1:16; unsigned short v2:15; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu7c { unsigned short v1:16; unsigned short v2:15; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu7i { unsigned short v1:16; unsigned short v2:15; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu7ll { unsigned short v1:16; unsigned short v2:15; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu7s { unsigned short v1:16; unsigned short v2:15; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu8c { unsigned short v1:16; unsigned short v2:15; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu8i { unsigned short v1:16; unsigned short v2:15; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu8ll { unsigned short v1:16; unsigned short v2:15; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu8s { unsigned short v1:16; unsigned short v2:15; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu9i { unsigned short v1:16; unsigned short v2:15; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu9ll { unsigned short v1:16; unsigned short v2:15; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu15s_BFu9s { unsigned short v1:16; unsigned short v2:15; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu15s_C { unsigned short v1:16; unsigned short v2:15; char v3; };
struct __attribute__((packed)) aBFu16s_BFu15s_D { unsigned short v1:16; unsigned short v2:15; double v3; };
struct __attribute__((packed)) aBFu16s_BFu15s_F { unsigned short v1:16; unsigned short v2:15; float v3; };
struct __attribute__((packed)) aBFu16s_BFu15s_I { unsigned short v1:16; unsigned short v2:15; int v3; };
struct __attribute__((packed)) aBFu16s_BFu15s_Ip { unsigned short v1:16; unsigned short v2:15; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu15s_L { unsigned short v1:16; unsigned short v2:15; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu15s_S { unsigned short v1:16; unsigned short v2:15; short v3; };
struct __attribute__((packed)) aBFu16s_BFu15s_Uc { unsigned short v1:16; unsigned short v2:15; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu15s_Ui { unsigned short v1:16; unsigned short v2:15; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu15s_Ul { unsigned short v1:16; unsigned short v2:15; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu15s_Us { unsigned short v1:16; unsigned short v2:15; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu15s_Vp { unsigned short v1:16; unsigned short v2:15; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu16i { unsigned short v1:16; unsigned int v2:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16i { unsigned short v1:16; unsigned int v2:16; signed int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16i_BFs16i { unsigned short v1:16; unsigned int v2:16; signed int v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16i_BFs16ll { unsigned short v1:16; unsigned int v2:16; signed int v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16i_BFs16s { unsigned short v1:16; unsigned int v2:16; signed int v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16i_BFu16i { unsigned short v1:16; unsigned int v2:16; signed int v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16i_BFu16ll { unsigned short v1:16; unsigned int v2:16; signed int v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16i_BFu16s { unsigned short v1:16; unsigned int v2:16; signed int v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16ll { unsigned short v1:16; unsigned int v2:16; signed long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16ll_BFs16i { unsigned short v1:16; unsigned int v2:16; signed long long v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16ll_BFs16ll { unsigned short v1:16; unsigned int v2:16; signed long long v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16ll_BFs16s { unsigned short v1:16; unsigned int v2:16; signed long long v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16ll_BFu16i { unsigned short v1:16; unsigned int v2:16; signed long long v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16ll_BFu16ll { unsigned short v1:16; unsigned int v2:16; signed long long v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16ll_BFu16s { unsigned short v1:16; unsigned int v2:16; signed long long v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16s { unsigned short v1:16; unsigned int v2:16; signed short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16s_BFs16i { unsigned short v1:16; unsigned int v2:16; signed short v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16s_BFs16ll { unsigned short v1:16; unsigned int v2:16; signed short v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16s_BFs16s { unsigned short v1:16; unsigned int v2:16; signed short v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16s_BFu16i { unsigned short v1:16; unsigned int v2:16; signed short v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16s_BFu16ll { unsigned short v1:16; unsigned int v2:16; signed short v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFs16s_BFu16s { unsigned short v1:16; unsigned int v2:16; signed short v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu15i { unsigned short v1:16; unsigned int v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu15ll { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu15s { unsigned short v1:16; unsigned int v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16i { unsigned short v1:16; unsigned int v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16i_BFs16i { unsigned short v1:16; unsigned int v2:16; unsigned int v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16i_BFs16ll { unsigned short v1:16; unsigned int v2:16; unsigned int v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16i_BFs16s { unsigned short v1:16; unsigned int v2:16; unsigned int v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16i_BFu16i { unsigned short v1:16; unsigned int v2:16; unsigned int v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16i_BFu16ll { unsigned short v1:16; unsigned int v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16i_BFu16s { unsigned short v1:16; unsigned int v2:16; unsigned int v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16ll { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16ll_BFs16i { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16ll_BFs16ll { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16ll_BFs16s { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16ll_BFu16i { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16ll_BFu16ll { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16ll_BFu16s { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16s { unsigned short v1:16; unsigned int v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16s_BFs16i { unsigned short v1:16; unsigned int v2:16; unsigned short v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16s_BFs16ll { unsigned short v1:16; unsigned int v2:16; unsigned short v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16s_BFs16s { unsigned short v1:16; unsigned int v2:16; unsigned short v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16s_BFu16i { unsigned short v1:16; unsigned int v2:16; unsigned short v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16s_BFu16ll { unsigned short v1:16; unsigned int v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu16s_BFu16s { unsigned short v1:16; unsigned int v2:16; unsigned short v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu17i { unsigned short v1:16; unsigned int v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu17ll { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu1c { unsigned short v1:16; unsigned int v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu1i { unsigned short v1:16; unsigned int v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu1ll { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu1s { unsigned short v1:16; unsigned int v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu31i { unsigned short v1:16; unsigned int v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu31ll { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu32i { unsigned short v1:16; unsigned int v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu32ll { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu33 { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu7c { unsigned short v1:16; unsigned int v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu7i { unsigned short v1:16; unsigned int v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu7ll { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu7s { unsigned short v1:16; unsigned int v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu8c { unsigned short v1:16; unsigned int v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu8i { unsigned short v1:16; unsigned int v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu8ll { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu8s { unsigned short v1:16; unsigned int v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu9i { unsigned short v1:16; unsigned int v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu9ll { unsigned short v1:16; unsigned int v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu16i_BFu9s { unsigned short v1:16; unsigned int v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu16i_C { unsigned short v1:16; unsigned int v2:16; char v3; };
struct __attribute__((packed)) aBFu16s_BFu16i_D { unsigned short v1:16; unsigned int v2:16; double v3; };
struct __attribute__((packed)) aBFu16s_BFu16i_F { unsigned short v1:16; unsigned int v2:16; float v3; };
struct __attribute__((packed)) aBFu16s_BFu16i_I { unsigned short v1:16; unsigned int v2:16; int v3; };
struct __attribute__((packed)) aBFu16s_BFu16i_Ip { unsigned short v1:16; unsigned int v2:16; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu16i_L { unsigned short v1:16; unsigned int v2:16; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu16i_S { unsigned short v1:16; unsigned int v2:16; short v3; };
struct __attribute__((packed)) aBFu16s_BFu16i_Uc { unsigned short v1:16; unsigned int v2:16; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu16i_Ui { unsigned short v1:16; unsigned int v2:16; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu16i_Ul { unsigned short v1:16; unsigned int v2:16; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu16i_Us { unsigned short v1:16; unsigned int v2:16; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu16i_Vp { unsigned short v1:16; unsigned int v2:16; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll { unsigned short v1:16; unsigned long long v2:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16i { unsigned short v1:16; unsigned long long v2:16; signed int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16i_BFs16i { unsigned short v1:16; unsigned long long v2:16; signed int v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16i_BFs16ll { unsigned short v1:16; unsigned long long v2:16; signed int v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16i_BFs16s { unsigned short v1:16; unsigned long long v2:16; signed int v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16i_BFu16i { unsigned short v1:16; unsigned long long v2:16; signed int v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16i_BFu16ll { unsigned short v1:16; unsigned long long v2:16; signed int v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16i_BFu16s { unsigned short v1:16; unsigned long long v2:16; signed int v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16ll { unsigned short v1:16; unsigned long long v2:16; signed long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16ll_BFs16i { unsigned short v1:16; unsigned long long v2:16; signed long long v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16ll_BFs16ll { unsigned short v1:16; unsigned long long v2:16; signed long long v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16ll_BFs16s { unsigned short v1:16; unsigned long long v2:16; signed long long v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16ll_BFu16i { unsigned short v1:16; unsigned long long v2:16; signed long long v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16ll_BFu16ll { unsigned short v1:16; unsigned long long v2:16; signed long long v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16ll_BFu16s { unsigned short v1:16; unsigned long long v2:16; signed long long v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16s { unsigned short v1:16; unsigned long long v2:16; signed short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16s_BFs16i { unsigned short v1:16; unsigned long long v2:16; signed short v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16s_BFs16ll { unsigned short v1:16; unsigned long long v2:16; signed short v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16s_BFs16s { unsigned short v1:16; unsigned long long v2:16; signed short v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16s_BFu16i { unsigned short v1:16; unsigned long long v2:16; signed short v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16s_BFu16ll { unsigned short v1:16; unsigned long long v2:16; signed short v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFs16s_BFu16s { unsigned short v1:16; unsigned long long v2:16; signed short v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu15i { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu15ll { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu15s { unsigned short v1:16; unsigned long long v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16i { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16i_BFs16i { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16i_BFs16ll { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16i_BFs16s { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16i_BFu16i { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16i_BFu16ll { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16i_BFu16s { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16ll { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16ll_BFs16i { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16ll_BFs16ll { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16ll_BFs16s { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16ll_BFu16i { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16ll_BFu16ll { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16ll_BFu16s { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16s { unsigned short v1:16; unsigned long long v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16s_BFs16i { unsigned short v1:16; unsigned long long v2:16; unsigned short v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16s_BFs16ll { unsigned short v1:16; unsigned long long v2:16; unsigned short v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16s_BFs16s { unsigned short v1:16; unsigned long long v2:16; unsigned short v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16s_BFu16i { unsigned short v1:16; unsigned long long v2:16; unsigned short v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16s_BFu16ll { unsigned short v1:16; unsigned long long v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu16s_BFu16s { unsigned short v1:16; unsigned long long v2:16; unsigned short v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu17i { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu17ll { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu1c { unsigned short v1:16; unsigned long long v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu1i { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu1ll { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu1s { unsigned short v1:16; unsigned long long v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu31i { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu31ll { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu32i { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu32ll { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu33 { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu7c { unsigned short v1:16; unsigned long long v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu7i { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu7ll { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu7s { unsigned short v1:16; unsigned long long v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu8c { unsigned short v1:16; unsigned long long v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu8i { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu8ll { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu8s { unsigned short v1:16; unsigned long long v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu9i { unsigned short v1:16; unsigned long long v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu9ll { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu16ll_BFu9s { unsigned short v1:16; unsigned long long v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu16ll_C { unsigned short v1:16; unsigned long long v2:16; char v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll_D { unsigned short v1:16; unsigned long long v2:16; double v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll_F { unsigned short v1:16; unsigned long long v2:16; float v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll_I { unsigned short v1:16; unsigned long long v2:16; int v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll_Ip { unsigned short v1:16; unsigned long long v2:16; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll_L { unsigned short v1:16; unsigned long long v2:16; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll_S { unsigned short v1:16; unsigned long long v2:16; short v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll_Uc { unsigned short v1:16; unsigned long long v2:16; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll_Ui { unsigned short v1:16; unsigned long long v2:16; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll_Ul { unsigned short v1:16; unsigned long long v2:16; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll_Us { unsigned short v1:16; unsigned long long v2:16; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu16ll_Vp { unsigned short v1:16; unsigned long long v2:16; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu16s { unsigned short v1:16; unsigned short v2:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16i { unsigned short v1:16; unsigned short v2:16; signed int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16i_BFs16i { unsigned short v1:16; unsigned short v2:16; signed int v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16i_BFs16ll { unsigned short v1:16; unsigned short v2:16; signed int v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16i_BFs16s { unsigned short v1:16; unsigned short v2:16; signed int v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16i_BFu16i { unsigned short v1:16; unsigned short v2:16; signed int v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16i_BFu16ll { unsigned short v1:16; unsigned short v2:16; signed int v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16i_BFu16s { unsigned short v1:16; unsigned short v2:16; signed int v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16ll { unsigned short v1:16; unsigned short v2:16; signed long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16ll_BFs16i { unsigned short v1:16; unsigned short v2:16; signed long long v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16ll_BFs16ll { unsigned short v1:16; unsigned short v2:16; signed long long v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16ll_BFs16s { unsigned short v1:16; unsigned short v2:16; signed long long v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16ll_BFu16i { unsigned short v1:16; unsigned short v2:16; signed long long v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16ll_BFu16ll { unsigned short v1:16; unsigned short v2:16; signed long long v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16ll_BFu16s { unsigned short v1:16; unsigned short v2:16; signed long long v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16s { unsigned short v1:16; unsigned short v2:16; signed short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16s_BFs16i { unsigned short v1:16; unsigned short v2:16; signed short v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16s_BFs16ll { unsigned short v1:16; unsigned short v2:16; signed short v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16s_BFs16s { unsigned short v1:16; unsigned short v2:16; signed short v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16s_BFu16i { unsigned short v1:16; unsigned short v2:16; signed short v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16s_BFu16ll { unsigned short v1:16; unsigned short v2:16; signed short v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFs16s_BFu16s { unsigned short v1:16; unsigned short v2:16; signed short v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu15i { unsigned short v1:16; unsigned short v2:16; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu15ll { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu15s { unsigned short v1:16; unsigned short v2:16; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16i { unsigned short v1:16; unsigned short v2:16; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16i_BFs16i { unsigned short v1:16; unsigned short v2:16; unsigned int v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16i_BFs16ll { unsigned short v1:16; unsigned short v2:16; unsigned int v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16i_BFs16s { unsigned short v1:16; unsigned short v2:16; unsigned int v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16i_BFu16i { unsigned short v1:16; unsigned short v2:16; unsigned int v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16i_BFu16ll { unsigned short v1:16; unsigned short v2:16; unsigned int v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16i_BFu16s { unsigned short v1:16; unsigned short v2:16; unsigned int v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16ll { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16ll_BFs16i { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16ll_BFs16ll { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16ll_BFs16s { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16ll_BFu16i { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16ll_BFu16ll { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16ll_BFu16s { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16s { unsigned short v1:16; unsigned short v2:16; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16s_BFs16i { unsigned short v1:16; unsigned short v2:16; unsigned short v3:16; signed int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16s_BFs16ll { unsigned short v1:16; unsigned short v2:16; unsigned short v3:16; signed long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16s_BFs16s { unsigned short v1:16; unsigned short v2:16; unsigned short v3:16; signed short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16s_BFu16i { unsigned short v1:16; unsigned short v2:16; unsigned short v3:16; unsigned int v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16s_BFu16ll { unsigned short v1:16; unsigned short v2:16; unsigned short v3:16; unsigned long long v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu16s_BFu16s { unsigned short v1:16; unsigned short v2:16; unsigned short v3:16; unsigned short v4:16; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu17i { unsigned short v1:16; unsigned short v2:16; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu17ll { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu1c { unsigned short v1:16; unsigned short v2:16; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu1i { unsigned short v1:16; unsigned short v2:16; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu1ll { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu1s { unsigned short v1:16; unsigned short v2:16; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu31i { unsigned short v1:16; unsigned short v2:16; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu31ll { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu32i { unsigned short v1:16; unsigned short v2:16; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu32ll { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu33 { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu7c { unsigned short v1:16; unsigned short v2:16; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu7i { unsigned short v1:16; unsigned short v2:16; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu7ll { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu7s { unsigned short v1:16; unsigned short v2:16; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu8c { unsigned short v1:16; unsigned short v2:16; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu8i { unsigned short v1:16; unsigned short v2:16; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu8ll { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu8s { unsigned short v1:16; unsigned short v2:16; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu9i { unsigned short v1:16; unsigned short v2:16; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu9ll { unsigned short v1:16; unsigned short v2:16; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu16s_BFu9s { unsigned short v1:16; unsigned short v2:16; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu16s_C { unsigned short v1:16; unsigned short v2:16; char v3; };
struct __attribute__((packed)) aBFu16s_BFu16s_D { unsigned short v1:16; unsigned short v2:16; double v3; };
struct __attribute__((packed)) aBFu16s_BFu16s_F { unsigned short v1:16; unsigned short v2:16; float v3; };
struct __attribute__((packed)) aBFu16s_BFu16s_I { unsigned short v1:16; unsigned short v2:16; int v3; };
struct __attribute__((packed)) aBFu16s_BFu16s_Ip { unsigned short v1:16; unsigned short v2:16; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu16s_L { unsigned short v1:16; unsigned short v2:16; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu16s_S { unsigned short v1:16; unsigned short v2:16; short v3; };
struct __attribute__((packed)) aBFu16s_BFu16s_Uc { unsigned short v1:16; unsigned short v2:16; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu16s_Ui { unsigned short v1:16; unsigned short v2:16; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu16s_Ul { unsigned short v1:16; unsigned short v2:16; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu16s_Us { unsigned short v1:16; unsigned short v2:16; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu16s_Vp { unsigned short v1:16; unsigned short v2:16; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu17i { unsigned short v1:16; unsigned int v2:17; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu15i { unsigned short v1:16; unsigned int v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu15ll { unsigned short v1:16; unsigned int v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu15s { unsigned short v1:16; unsigned int v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu16i { unsigned short v1:16; unsigned int v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu16ll { unsigned short v1:16; unsigned int v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu16s { unsigned short v1:16; unsigned int v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu17i { unsigned short v1:16; unsigned int v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu17ll { unsigned short v1:16; unsigned int v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu1c { unsigned short v1:16; unsigned int v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu1i { unsigned short v1:16; unsigned int v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu1ll { unsigned short v1:16; unsigned int v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu1s { unsigned short v1:16; unsigned int v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu31i { unsigned short v1:16; unsigned int v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu31ll { unsigned short v1:16; unsigned int v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu32i { unsigned short v1:16; unsigned int v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu32ll { unsigned short v1:16; unsigned int v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu33 { unsigned short v1:16; unsigned int v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu7c { unsigned short v1:16; unsigned int v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu7i { unsigned short v1:16; unsigned int v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu7ll { unsigned short v1:16; unsigned int v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu7s { unsigned short v1:16; unsigned int v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu8c { unsigned short v1:16; unsigned int v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu8i { unsigned short v1:16; unsigned int v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu8ll { unsigned short v1:16; unsigned int v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu8s { unsigned short v1:16; unsigned int v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu9i { unsigned short v1:16; unsigned int v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu9ll { unsigned short v1:16; unsigned int v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu17i_BFu9s { unsigned short v1:16; unsigned int v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu17i_C { unsigned short v1:16; unsigned int v2:17; char v3; };
struct __attribute__((packed)) aBFu16s_BFu17i_D { unsigned short v1:16; unsigned int v2:17; double v3; };
struct __attribute__((packed)) aBFu16s_BFu17i_F { unsigned short v1:16; unsigned int v2:17; float v3; };
struct __attribute__((packed)) aBFu16s_BFu17i_I { unsigned short v1:16; unsigned int v2:17; int v3; };
struct __attribute__((packed)) aBFu16s_BFu17i_Ip { unsigned short v1:16; unsigned int v2:17; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu17i_L { unsigned short v1:16; unsigned int v2:17; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu17i_S { unsigned short v1:16; unsigned int v2:17; short v3; };
struct __attribute__((packed)) aBFu16s_BFu17i_Uc { unsigned short v1:16; unsigned int v2:17; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu17i_Ui { unsigned short v1:16; unsigned int v2:17; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu17i_Ul { unsigned short v1:16; unsigned int v2:17; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu17i_Us { unsigned short v1:16; unsigned int v2:17; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu17i_Vp { unsigned short v1:16; unsigned int v2:17; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll { unsigned short v1:16; unsigned long long v2:17; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu15i { unsigned short v1:16; unsigned long long v2:17; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu15ll { unsigned short v1:16; unsigned long long v2:17; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu15s { unsigned short v1:16; unsigned long long v2:17; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu16i { unsigned short v1:16; unsigned long long v2:17; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu16ll { unsigned short v1:16; unsigned long long v2:17; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu16s { unsigned short v1:16; unsigned long long v2:17; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu17i { unsigned short v1:16; unsigned long long v2:17; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu17ll { unsigned short v1:16; unsigned long long v2:17; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu1c { unsigned short v1:16; unsigned long long v2:17; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu1i { unsigned short v1:16; unsigned long long v2:17; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu1ll { unsigned short v1:16; unsigned long long v2:17; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu1s { unsigned short v1:16; unsigned long long v2:17; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu31i { unsigned short v1:16; unsigned long long v2:17; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu31ll { unsigned short v1:16; unsigned long long v2:17; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu32i { unsigned short v1:16; unsigned long long v2:17; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu32ll { unsigned short v1:16; unsigned long long v2:17; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu33 { unsigned short v1:16; unsigned long long v2:17; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu7c { unsigned short v1:16; unsigned long long v2:17; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu7i { unsigned short v1:16; unsigned long long v2:17; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu7ll { unsigned short v1:16; unsigned long long v2:17; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu7s { unsigned short v1:16; unsigned long long v2:17; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu8c { unsigned short v1:16; unsigned long long v2:17; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu8i { unsigned short v1:16; unsigned long long v2:17; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu8ll { unsigned short v1:16; unsigned long long v2:17; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu8s { unsigned short v1:16; unsigned long long v2:17; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu9i { unsigned short v1:16; unsigned long long v2:17; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu9ll { unsigned short v1:16; unsigned long long v2:17; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu17ll_BFu9s { unsigned short v1:16; unsigned long long v2:17; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu17ll_C { unsigned short v1:16; unsigned long long v2:17; char v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll_D { unsigned short v1:16; unsigned long long v2:17; double v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll_F { unsigned short v1:16; unsigned long long v2:17; float v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll_I { unsigned short v1:16; unsigned long long v2:17; int v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll_Ip { unsigned short v1:16; unsigned long long v2:17; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll_L { unsigned short v1:16; unsigned long long v2:17; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll_S { unsigned short v1:16; unsigned long long v2:17; short v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll_Uc { unsigned short v1:16; unsigned long long v2:17; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll_Ui { unsigned short v1:16; unsigned long long v2:17; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll_Ul { unsigned short v1:16; unsigned long long v2:17; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll_Us { unsigned short v1:16; unsigned long long v2:17; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu17ll_Vp { unsigned short v1:16; unsigned long long v2:17; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu1c { unsigned short v1:16; unsigned char v2:1; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu15i { unsigned short v1:16; unsigned char v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu15ll { unsigned short v1:16; unsigned char v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu15s { unsigned short v1:16; unsigned char v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu16i { unsigned short v1:16; unsigned char v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu16ll { unsigned short v1:16; unsigned char v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu16s { unsigned short v1:16; unsigned char v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu17i { unsigned short v1:16; unsigned char v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu17ll { unsigned short v1:16; unsigned char v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu1c { unsigned short v1:16; unsigned char v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu1i { unsigned short v1:16; unsigned char v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu1ll { unsigned short v1:16; unsigned char v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu1s { unsigned short v1:16; unsigned char v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu31i { unsigned short v1:16; unsigned char v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu31ll { unsigned short v1:16; unsigned char v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu32i { unsigned short v1:16; unsigned char v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu32ll { unsigned short v1:16; unsigned char v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu33 { unsigned short v1:16; unsigned char v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu7c { unsigned short v1:16; unsigned char v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu7i { unsigned short v1:16; unsigned char v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu7ll { unsigned short v1:16; unsigned char v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu7s { unsigned short v1:16; unsigned char v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu8c { unsigned short v1:16; unsigned char v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu8i { unsigned short v1:16; unsigned char v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu8ll { unsigned short v1:16; unsigned char v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu8s { unsigned short v1:16; unsigned char v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu9i { unsigned short v1:16; unsigned char v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu9ll { unsigned short v1:16; unsigned char v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu1c_BFu9s { unsigned short v1:16; unsigned char v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu1c_C { unsigned short v1:16; unsigned char v2:1; char v3; };
struct __attribute__((packed)) aBFu16s_BFu1c_D { unsigned short v1:16; unsigned char v2:1; double v3; };
struct __attribute__((packed)) aBFu16s_BFu1c_F { unsigned short v1:16; unsigned char v2:1; float v3; };
struct __attribute__((packed)) aBFu16s_BFu1c_I { unsigned short v1:16; unsigned char v2:1; int v3; };
struct __attribute__((packed)) aBFu16s_BFu1c_Ip { unsigned short v1:16; unsigned char v2:1; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu1c_L { unsigned short v1:16; unsigned char v2:1; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu1c_S { unsigned short v1:16; unsigned char v2:1; short v3; };
struct __attribute__((packed)) aBFu16s_BFu1c_Uc { unsigned short v1:16; unsigned char v2:1; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu1c_Ui { unsigned short v1:16; unsigned char v2:1; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu1c_Ul { unsigned short v1:16; unsigned char v2:1; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu1c_Us { unsigned short v1:16; unsigned char v2:1; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu1c_Vp { unsigned short v1:16; unsigned char v2:1; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu1i { unsigned short v1:16; unsigned int v2:1; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu15i { unsigned short v1:16; unsigned int v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu15ll { unsigned short v1:16; unsigned int v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu15s { unsigned short v1:16; unsigned int v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu16i { unsigned short v1:16; unsigned int v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu16ll { unsigned short v1:16; unsigned int v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu16s { unsigned short v1:16; unsigned int v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu17i { unsigned short v1:16; unsigned int v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu17ll { unsigned short v1:16; unsigned int v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu1c { unsigned short v1:16; unsigned int v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu1i { unsigned short v1:16; unsigned int v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu1ll { unsigned short v1:16; unsigned int v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu1s { unsigned short v1:16; unsigned int v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu31i { unsigned short v1:16; unsigned int v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu31ll { unsigned short v1:16; unsigned int v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu32i { unsigned short v1:16; unsigned int v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu32ll { unsigned short v1:16; unsigned int v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu33 { unsigned short v1:16; unsigned int v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu7c { unsigned short v1:16; unsigned int v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu7i { unsigned short v1:16; unsigned int v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu7ll { unsigned short v1:16; unsigned int v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu7s { unsigned short v1:16; unsigned int v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu8c { unsigned short v1:16; unsigned int v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu8i { unsigned short v1:16; unsigned int v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu8ll { unsigned short v1:16; unsigned int v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu8s { unsigned short v1:16; unsigned int v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu9i { unsigned short v1:16; unsigned int v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu9ll { unsigned short v1:16; unsigned int v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu1i_BFu9s { unsigned short v1:16; unsigned int v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu1i_C { unsigned short v1:16; unsigned int v2:1; char v3; };
struct __attribute__((packed)) aBFu16s_BFu1i_D { unsigned short v1:16; unsigned int v2:1; double v3; };
struct __attribute__((packed)) aBFu16s_BFu1i_F { unsigned short v1:16; unsigned int v2:1; float v3; };
struct __attribute__((packed)) aBFu16s_BFu1i_I { unsigned short v1:16; unsigned int v2:1; int v3; };
struct __attribute__((packed)) aBFu16s_BFu1i_Ip { unsigned short v1:16; unsigned int v2:1; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu1i_L { unsigned short v1:16; unsigned int v2:1; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu1i_S { unsigned short v1:16; unsigned int v2:1; short v3; };
struct __attribute__((packed)) aBFu16s_BFu1i_Uc { unsigned short v1:16; unsigned int v2:1; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu1i_Ui { unsigned short v1:16; unsigned int v2:1; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu1i_Ul { unsigned short v1:16; unsigned int v2:1; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu1i_Us { unsigned short v1:16; unsigned int v2:1; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu1i_Vp { unsigned short v1:16; unsigned int v2:1; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll { unsigned short v1:16; unsigned long long v2:1; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu15i { unsigned short v1:16; unsigned long long v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu15ll { unsigned short v1:16; unsigned long long v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu15s { unsigned short v1:16; unsigned long long v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu16i { unsigned short v1:16; unsigned long long v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu16ll { unsigned short v1:16; unsigned long long v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu16s { unsigned short v1:16; unsigned long long v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu17i { unsigned short v1:16; unsigned long long v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu17ll { unsigned short v1:16; unsigned long long v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu1c { unsigned short v1:16; unsigned long long v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu1i { unsigned short v1:16; unsigned long long v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu1ll { unsigned short v1:16; unsigned long long v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu1s { unsigned short v1:16; unsigned long long v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu31i { unsigned short v1:16; unsigned long long v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu31ll { unsigned short v1:16; unsigned long long v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu32i { unsigned short v1:16; unsigned long long v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu32ll { unsigned short v1:16; unsigned long long v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu33 { unsigned short v1:16; unsigned long long v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu7c { unsigned short v1:16; unsigned long long v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu7i { unsigned short v1:16; unsigned long long v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu7ll { unsigned short v1:16; unsigned long long v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu7s { unsigned short v1:16; unsigned long long v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu8c { unsigned short v1:16; unsigned long long v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu8i { unsigned short v1:16; unsigned long long v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu8ll { unsigned short v1:16; unsigned long long v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu8s { unsigned short v1:16; unsigned long long v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu9i { unsigned short v1:16; unsigned long long v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu9ll { unsigned short v1:16; unsigned long long v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu1ll_BFu9s { unsigned short v1:16; unsigned long long v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu1ll_C { unsigned short v1:16; unsigned long long v2:1; char v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll_D { unsigned short v1:16; unsigned long long v2:1; double v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll_F { unsigned short v1:16; unsigned long long v2:1; float v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll_I { unsigned short v1:16; unsigned long long v2:1; int v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll_Ip { unsigned short v1:16; unsigned long long v2:1; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll_L { unsigned short v1:16; unsigned long long v2:1; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll_S { unsigned short v1:16; unsigned long long v2:1; short v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll_Uc { unsigned short v1:16; unsigned long long v2:1; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll_Ui { unsigned short v1:16; unsigned long long v2:1; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll_Ul { unsigned short v1:16; unsigned long long v2:1; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll_Us { unsigned short v1:16; unsigned long long v2:1; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu1ll_Vp { unsigned short v1:16; unsigned long long v2:1; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu1s { unsigned short v1:16; unsigned short v2:1; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu15i { unsigned short v1:16; unsigned short v2:1; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu15ll { unsigned short v1:16; unsigned short v2:1; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu15s { unsigned short v1:16; unsigned short v2:1; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu16i { unsigned short v1:16; unsigned short v2:1; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu16ll { unsigned short v1:16; unsigned short v2:1; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu16s { unsigned short v1:16; unsigned short v2:1; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu17i { unsigned short v1:16; unsigned short v2:1; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu17ll { unsigned short v1:16; unsigned short v2:1; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu1c { unsigned short v1:16; unsigned short v2:1; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu1i { unsigned short v1:16; unsigned short v2:1; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu1ll { unsigned short v1:16; unsigned short v2:1; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu1s { unsigned short v1:16; unsigned short v2:1; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu31i { unsigned short v1:16; unsigned short v2:1; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu31ll { unsigned short v1:16; unsigned short v2:1; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu32i { unsigned short v1:16; unsigned short v2:1; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu32ll { unsigned short v1:16; unsigned short v2:1; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu33 { unsigned short v1:16; unsigned short v2:1; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu7c { unsigned short v1:16; unsigned short v2:1; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu7i { unsigned short v1:16; unsigned short v2:1; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu7ll { unsigned short v1:16; unsigned short v2:1; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu7s { unsigned short v1:16; unsigned short v2:1; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu8c { unsigned short v1:16; unsigned short v2:1; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu8i { unsigned short v1:16; unsigned short v2:1; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu8ll { unsigned short v1:16; unsigned short v2:1; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu8s { unsigned short v1:16; unsigned short v2:1; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu9i { unsigned short v1:16; unsigned short v2:1; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu9ll { unsigned short v1:16; unsigned short v2:1; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu1s_BFu9s { unsigned short v1:16; unsigned short v2:1; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu1s_C { unsigned short v1:16; unsigned short v2:1; char v3; };
struct __attribute__((packed)) aBFu16s_BFu1s_D { unsigned short v1:16; unsigned short v2:1; double v3; };
struct __attribute__((packed)) aBFu16s_BFu1s_F { unsigned short v1:16; unsigned short v2:1; float v3; };
struct __attribute__((packed)) aBFu16s_BFu1s_I { unsigned short v1:16; unsigned short v2:1; int v3; };
struct __attribute__((packed)) aBFu16s_BFu1s_Ip { unsigned short v1:16; unsigned short v2:1; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu1s_L { unsigned short v1:16; unsigned short v2:1; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu1s_S { unsigned short v1:16; unsigned short v2:1; short v3; };
struct __attribute__((packed)) aBFu16s_BFu1s_Uc { unsigned short v1:16; unsigned short v2:1; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu1s_Ui { unsigned short v1:16; unsigned short v2:1; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu1s_Ul { unsigned short v1:16; unsigned short v2:1; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu1s_Us { unsigned short v1:16; unsigned short v2:1; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu1s_Vp { unsigned short v1:16; unsigned short v2:1; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu31i { unsigned short v1:16; unsigned int v2:31; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu15i { unsigned short v1:16; unsigned int v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu15ll { unsigned short v1:16; unsigned int v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu15s { unsigned short v1:16; unsigned int v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu16i { unsigned short v1:16; unsigned int v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu16ll { unsigned short v1:16; unsigned int v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu16s { unsigned short v1:16; unsigned int v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu17i { unsigned short v1:16; unsigned int v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu17ll { unsigned short v1:16; unsigned int v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu1c { unsigned short v1:16; unsigned int v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu1i { unsigned short v1:16; unsigned int v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu1ll { unsigned short v1:16; unsigned int v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu1s { unsigned short v1:16; unsigned int v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu31i { unsigned short v1:16; unsigned int v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu31ll { unsigned short v1:16; unsigned int v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu32i { unsigned short v1:16; unsigned int v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu32ll { unsigned short v1:16; unsigned int v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu33 { unsigned short v1:16; unsigned int v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu7c { unsigned short v1:16; unsigned int v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu7i { unsigned short v1:16; unsigned int v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu7ll { unsigned short v1:16; unsigned int v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu7s { unsigned short v1:16; unsigned int v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu8c { unsigned short v1:16; unsigned int v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu8i { unsigned short v1:16; unsigned int v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu8ll { unsigned short v1:16; unsigned int v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu8s { unsigned short v1:16; unsigned int v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu9i { unsigned short v1:16; unsigned int v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu9ll { unsigned short v1:16; unsigned int v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu31i_BFu9s { unsigned short v1:16; unsigned int v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu31i_C { unsigned short v1:16; unsigned int v2:31; char v3; };
struct __attribute__((packed)) aBFu16s_BFu31i_D { unsigned short v1:16; unsigned int v2:31; double v3; };
struct __attribute__((packed)) aBFu16s_BFu31i_F { unsigned short v1:16; unsigned int v2:31; float v3; };
struct __attribute__((packed)) aBFu16s_BFu31i_I { unsigned short v1:16; unsigned int v2:31; int v3; };
struct __attribute__((packed)) aBFu16s_BFu31i_Ip { unsigned short v1:16; unsigned int v2:31; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu31i_L { unsigned short v1:16; unsigned int v2:31; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu31i_S { unsigned short v1:16; unsigned int v2:31; short v3; };
struct __attribute__((packed)) aBFu16s_BFu31i_Uc { unsigned short v1:16; unsigned int v2:31; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu31i_Ui { unsigned short v1:16; unsigned int v2:31; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu31i_Ul { unsigned short v1:16; unsigned int v2:31; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu31i_Us { unsigned short v1:16; unsigned int v2:31; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu31i_Vp { unsigned short v1:16; unsigned int v2:31; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll { unsigned short v1:16; unsigned long long v2:31; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu15i { unsigned short v1:16; unsigned long long v2:31; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu15ll { unsigned short v1:16; unsigned long long v2:31; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu15s { unsigned short v1:16; unsigned long long v2:31; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu16i { unsigned short v1:16; unsigned long long v2:31; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu16ll { unsigned short v1:16; unsigned long long v2:31; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu16s { unsigned short v1:16; unsigned long long v2:31; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu17i { unsigned short v1:16; unsigned long long v2:31; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu17ll { unsigned short v1:16; unsigned long long v2:31; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu1c { unsigned short v1:16; unsigned long long v2:31; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu1i { unsigned short v1:16; unsigned long long v2:31; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu1ll { unsigned short v1:16; unsigned long long v2:31; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu1s { unsigned short v1:16; unsigned long long v2:31; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu31i { unsigned short v1:16; unsigned long long v2:31; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu31ll { unsigned short v1:16; unsigned long long v2:31; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu32i { unsigned short v1:16; unsigned long long v2:31; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu32ll { unsigned short v1:16; unsigned long long v2:31; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu33 { unsigned short v1:16; unsigned long long v2:31; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu7c { unsigned short v1:16; unsigned long long v2:31; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu7i { unsigned short v1:16; unsigned long long v2:31; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu7ll { unsigned short v1:16; unsigned long long v2:31; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu7s { unsigned short v1:16; unsigned long long v2:31; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu8c { unsigned short v1:16; unsigned long long v2:31; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu8i { unsigned short v1:16; unsigned long long v2:31; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu8ll { unsigned short v1:16; unsigned long long v2:31; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu8s { unsigned short v1:16; unsigned long long v2:31; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu9i { unsigned short v1:16; unsigned long long v2:31; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu9ll { unsigned short v1:16; unsigned long long v2:31; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu31ll_BFu9s { unsigned short v1:16; unsigned long long v2:31; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu31ll_C { unsigned short v1:16; unsigned long long v2:31; char v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll_D { unsigned short v1:16; unsigned long long v2:31; double v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll_F { unsigned short v1:16; unsigned long long v2:31; float v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll_I { unsigned short v1:16; unsigned long long v2:31; int v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll_Ip { unsigned short v1:16; unsigned long long v2:31; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll_L { unsigned short v1:16; unsigned long long v2:31; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll_S { unsigned short v1:16; unsigned long long v2:31; short v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll_Uc { unsigned short v1:16; unsigned long long v2:31; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll_Ui { unsigned short v1:16; unsigned long long v2:31; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll_Ul { unsigned short v1:16; unsigned long long v2:31; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll_Us { unsigned short v1:16; unsigned long long v2:31; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu31ll_Vp { unsigned short v1:16; unsigned long long v2:31; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu32i { unsigned short v1:16; unsigned int v2:32; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu15i { unsigned short v1:16; unsigned int v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu15ll { unsigned short v1:16; unsigned int v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu15s { unsigned short v1:16; unsigned int v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu16i { unsigned short v1:16; unsigned int v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu16ll { unsigned short v1:16; unsigned int v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu16s { unsigned short v1:16; unsigned int v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu17i { unsigned short v1:16; unsigned int v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu17ll { unsigned short v1:16; unsigned int v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu1c { unsigned short v1:16; unsigned int v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu1i { unsigned short v1:16; unsigned int v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu1ll { unsigned short v1:16; unsigned int v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu1s { unsigned short v1:16; unsigned int v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu31i { unsigned short v1:16; unsigned int v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu31ll { unsigned short v1:16; unsigned int v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu32i { unsigned short v1:16; unsigned int v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu32ll { unsigned short v1:16; unsigned int v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu33 { unsigned short v1:16; unsigned int v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu7c { unsigned short v1:16; unsigned int v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu7i { unsigned short v1:16; unsigned int v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu7ll { unsigned short v1:16; unsigned int v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu7s { unsigned short v1:16; unsigned int v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu8c { unsigned short v1:16; unsigned int v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu8i { unsigned short v1:16; unsigned int v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu8ll { unsigned short v1:16; unsigned int v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu8s { unsigned short v1:16; unsigned int v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu9i { unsigned short v1:16; unsigned int v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu9ll { unsigned short v1:16; unsigned int v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu32i_BFu9s { unsigned short v1:16; unsigned int v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu32i_C { unsigned short v1:16; unsigned int v2:32; char v3; };
struct __attribute__((packed)) aBFu16s_BFu32i_D { unsigned short v1:16; unsigned int v2:32; double v3; };
struct __attribute__((packed)) aBFu16s_BFu32i_F { unsigned short v1:16; unsigned int v2:32; float v3; };
struct __attribute__((packed)) aBFu16s_BFu32i_I { unsigned short v1:16; unsigned int v2:32; int v3; };
struct __attribute__((packed)) aBFu16s_BFu32i_Ip { unsigned short v1:16; unsigned int v2:32; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu32i_L { unsigned short v1:16; unsigned int v2:32; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu32i_S { unsigned short v1:16; unsigned int v2:32; short v3; };
struct __attribute__((packed)) aBFu16s_BFu32i_Uc { unsigned short v1:16; unsigned int v2:32; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu32i_Ui { unsigned short v1:16; unsigned int v2:32; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu32i_Ul { unsigned short v1:16; unsigned int v2:32; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu32i_Us { unsigned short v1:16; unsigned int v2:32; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu32i_Vp { unsigned short v1:16; unsigned int v2:32; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll { unsigned short v1:16; unsigned long long v2:32; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu15i { unsigned short v1:16; unsigned long long v2:32; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu15ll { unsigned short v1:16; unsigned long long v2:32; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu15s { unsigned short v1:16; unsigned long long v2:32; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu16i { unsigned short v1:16; unsigned long long v2:32; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu16ll { unsigned short v1:16; unsigned long long v2:32; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu16s { unsigned short v1:16; unsigned long long v2:32; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu17i { unsigned short v1:16; unsigned long long v2:32; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu17ll { unsigned short v1:16; unsigned long long v2:32; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu1c { unsigned short v1:16; unsigned long long v2:32; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu1i { unsigned short v1:16; unsigned long long v2:32; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu1ll { unsigned short v1:16; unsigned long long v2:32; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu1s { unsigned short v1:16; unsigned long long v2:32; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu31i { unsigned short v1:16; unsigned long long v2:32; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu31ll { unsigned short v1:16; unsigned long long v2:32; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu32i { unsigned short v1:16; unsigned long long v2:32; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu32ll { unsigned short v1:16; unsigned long long v2:32; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu33 { unsigned short v1:16; unsigned long long v2:32; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu7c { unsigned short v1:16; unsigned long long v2:32; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu7i { unsigned short v1:16; unsigned long long v2:32; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu7ll { unsigned short v1:16; unsigned long long v2:32; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu7s { unsigned short v1:16; unsigned long long v2:32; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu8c { unsigned short v1:16; unsigned long long v2:32; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu8i { unsigned short v1:16; unsigned long long v2:32; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu8ll { unsigned short v1:16; unsigned long long v2:32; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu8s { unsigned short v1:16; unsigned long long v2:32; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu9i { unsigned short v1:16; unsigned long long v2:32; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu9ll { unsigned short v1:16; unsigned long long v2:32; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu32ll_BFu9s { unsigned short v1:16; unsigned long long v2:32; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu32ll_C { unsigned short v1:16; unsigned long long v2:32; char v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll_D { unsigned short v1:16; unsigned long long v2:32; double v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll_F { unsigned short v1:16; unsigned long long v2:32; float v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll_I { unsigned short v1:16; unsigned long long v2:32; int v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll_Ip { unsigned short v1:16; unsigned long long v2:32; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll_L { unsigned short v1:16; unsigned long long v2:32; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll_S { unsigned short v1:16; unsigned long long v2:32; short v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll_Uc { unsigned short v1:16; unsigned long long v2:32; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll_Ui { unsigned short v1:16; unsigned long long v2:32; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll_Ul { unsigned short v1:16; unsigned long long v2:32; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll_Us { unsigned short v1:16; unsigned long long v2:32; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu32ll_Vp { unsigned short v1:16; unsigned long long v2:32; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu33 { unsigned short v1:16; unsigned long long v2:33; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu15i { unsigned short v1:16; unsigned long long v2:33; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu15ll { unsigned short v1:16; unsigned long long v2:33; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu15s { unsigned short v1:16; unsigned long long v2:33; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu16i { unsigned short v1:16; unsigned long long v2:33; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu16ll { unsigned short v1:16; unsigned long long v2:33; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu16s { unsigned short v1:16; unsigned long long v2:33; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu17i { unsigned short v1:16; unsigned long long v2:33; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu17ll { unsigned short v1:16; unsigned long long v2:33; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu1c { unsigned short v1:16; unsigned long long v2:33; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu1i { unsigned short v1:16; unsigned long long v2:33; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu1ll { unsigned short v1:16; unsigned long long v2:33; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu1s { unsigned short v1:16; unsigned long long v2:33; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu31i { unsigned short v1:16; unsigned long long v2:33; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu31ll { unsigned short v1:16; unsigned long long v2:33; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu32i { unsigned short v1:16; unsigned long long v2:33; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu32ll { unsigned short v1:16; unsigned long long v2:33; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu33 { unsigned short v1:16; unsigned long long v2:33; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu7c { unsigned short v1:16; unsigned long long v2:33; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu7i { unsigned short v1:16; unsigned long long v2:33; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu7ll { unsigned short v1:16; unsigned long long v2:33; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu7s { unsigned short v1:16; unsigned long long v2:33; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu8c { unsigned short v1:16; unsigned long long v2:33; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu8i { unsigned short v1:16; unsigned long long v2:33; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu8ll { unsigned short v1:16; unsigned long long v2:33; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu8s { unsigned short v1:16; unsigned long long v2:33; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu9i { unsigned short v1:16; unsigned long long v2:33; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu9ll { unsigned short v1:16; unsigned long long v2:33; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu33_BFu9s { unsigned short v1:16; unsigned long long v2:33; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu33_C { unsigned short v1:16; unsigned long long v2:33; char v3; };
struct __attribute__((packed)) aBFu16s_BFu33_D { unsigned short v1:16; unsigned long long v2:33; double v3; };
struct __attribute__((packed)) aBFu16s_BFu33_F { unsigned short v1:16; unsigned long long v2:33; float v3; };
struct __attribute__((packed)) aBFu16s_BFu33_I { unsigned short v1:16; unsigned long long v2:33; int v3; };
struct __attribute__((packed)) aBFu16s_BFu33_Ip { unsigned short v1:16; unsigned long long v2:33; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu33_L { unsigned short v1:16; unsigned long long v2:33; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu33_S { unsigned short v1:16; unsigned long long v2:33; short v3; };
struct __attribute__((packed)) aBFu16s_BFu33_Uc { unsigned short v1:16; unsigned long long v2:33; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu33_Ui { unsigned short v1:16; unsigned long long v2:33; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu33_Ul { unsigned short v1:16; unsigned long long v2:33; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu33_Us { unsigned short v1:16; unsigned long long v2:33; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu33_Vp { unsigned short v1:16; unsigned long long v2:33; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu7c { unsigned short v1:16; unsigned char v2:7; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu15i { unsigned short v1:16; unsigned char v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu15ll { unsigned short v1:16; unsigned char v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu15s { unsigned short v1:16; unsigned char v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu16i { unsigned short v1:16; unsigned char v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu16ll { unsigned short v1:16; unsigned char v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu16s { unsigned short v1:16; unsigned char v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu17i { unsigned short v1:16; unsigned char v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu17ll { unsigned short v1:16; unsigned char v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu1c { unsigned short v1:16; unsigned char v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu1i { unsigned short v1:16; unsigned char v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu1ll { unsigned short v1:16; unsigned char v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu1s { unsigned short v1:16; unsigned char v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu31i { unsigned short v1:16; unsigned char v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu31ll { unsigned short v1:16; unsigned char v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu32i { unsigned short v1:16; unsigned char v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu32ll { unsigned short v1:16; unsigned char v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu33 { unsigned short v1:16; unsigned char v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu7c { unsigned short v1:16; unsigned char v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu7i { unsigned short v1:16; unsigned char v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu7ll { unsigned short v1:16; unsigned char v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu7s { unsigned short v1:16; unsigned char v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu8c { unsigned short v1:16; unsigned char v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu8i { unsigned short v1:16; unsigned char v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu8ll { unsigned short v1:16; unsigned char v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu8s { unsigned short v1:16; unsigned char v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu9i { unsigned short v1:16; unsigned char v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu9ll { unsigned short v1:16; unsigned char v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu7c_BFu9s { unsigned short v1:16; unsigned char v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu7c_C { unsigned short v1:16; unsigned char v2:7; char v3; };
struct __attribute__((packed)) aBFu16s_BFu7c_D { unsigned short v1:16; unsigned char v2:7; double v3; };
struct __attribute__((packed)) aBFu16s_BFu7c_F { unsigned short v1:16; unsigned char v2:7; float v3; };
struct __attribute__((packed)) aBFu16s_BFu7c_I { unsigned short v1:16; unsigned char v2:7; int v3; };
struct __attribute__((packed)) aBFu16s_BFu7c_Ip { unsigned short v1:16; unsigned char v2:7; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu7c_L { unsigned short v1:16; unsigned char v2:7; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu7c_S { unsigned short v1:16; unsigned char v2:7; short v3; };
struct __attribute__((packed)) aBFu16s_BFu7c_Uc { unsigned short v1:16; unsigned char v2:7; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu7c_Ui { unsigned short v1:16; unsigned char v2:7; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu7c_Ul { unsigned short v1:16; unsigned char v2:7; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu7c_Us { unsigned short v1:16; unsigned char v2:7; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu7c_Vp { unsigned short v1:16; unsigned char v2:7; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu7i { unsigned short v1:16; unsigned int v2:7; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu15i { unsigned short v1:16; unsigned int v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu15ll { unsigned short v1:16; unsigned int v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu15s { unsigned short v1:16; unsigned int v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu16i { unsigned short v1:16; unsigned int v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu16ll { unsigned short v1:16; unsigned int v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu16s { unsigned short v1:16; unsigned int v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu17i { unsigned short v1:16; unsigned int v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu17ll { unsigned short v1:16; unsigned int v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu1c { unsigned short v1:16; unsigned int v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu1i { unsigned short v1:16; unsigned int v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu1ll { unsigned short v1:16; unsigned int v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu1s { unsigned short v1:16; unsigned int v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu31i { unsigned short v1:16; unsigned int v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu31ll { unsigned short v1:16; unsigned int v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu32i { unsigned short v1:16; unsigned int v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu32ll { unsigned short v1:16; unsigned int v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu33 { unsigned short v1:16; unsigned int v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu7c { unsigned short v1:16; unsigned int v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu7i { unsigned short v1:16; unsigned int v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu7ll { unsigned short v1:16; unsigned int v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu7s { unsigned short v1:16; unsigned int v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu8c { unsigned short v1:16; unsigned int v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu8i { unsigned short v1:16; unsigned int v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu8ll { unsigned short v1:16; unsigned int v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu8s { unsigned short v1:16; unsigned int v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu9i { unsigned short v1:16; unsigned int v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu9ll { unsigned short v1:16; unsigned int v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu7i_BFu9s { unsigned short v1:16; unsigned int v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu7i_C { unsigned short v1:16; unsigned int v2:7; char v3; };
struct __attribute__((packed)) aBFu16s_BFu7i_D { unsigned short v1:16; unsigned int v2:7; double v3; };
struct __attribute__((packed)) aBFu16s_BFu7i_F { unsigned short v1:16; unsigned int v2:7; float v3; };
struct __attribute__((packed)) aBFu16s_BFu7i_I { unsigned short v1:16; unsigned int v2:7; int v3; };
struct __attribute__((packed)) aBFu16s_BFu7i_Ip { unsigned short v1:16; unsigned int v2:7; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu7i_L { unsigned short v1:16; unsigned int v2:7; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu7i_S { unsigned short v1:16; unsigned int v2:7; short v3; };
struct __attribute__((packed)) aBFu16s_BFu7i_Uc { unsigned short v1:16; unsigned int v2:7; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu7i_Ui { unsigned short v1:16; unsigned int v2:7; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu7i_Ul { unsigned short v1:16; unsigned int v2:7; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu7i_Us { unsigned short v1:16; unsigned int v2:7; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu7i_Vp { unsigned short v1:16; unsigned int v2:7; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll { unsigned short v1:16; unsigned long long v2:7; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu15i { unsigned short v1:16; unsigned long long v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu15ll { unsigned short v1:16; unsigned long long v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu15s { unsigned short v1:16; unsigned long long v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu16i { unsigned short v1:16; unsigned long long v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu16ll { unsigned short v1:16; unsigned long long v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu16s { unsigned short v1:16; unsigned long long v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu17i { unsigned short v1:16; unsigned long long v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu17ll { unsigned short v1:16; unsigned long long v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu1c { unsigned short v1:16; unsigned long long v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu1i { unsigned short v1:16; unsigned long long v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu1ll { unsigned short v1:16; unsigned long long v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu1s { unsigned short v1:16; unsigned long long v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu31i { unsigned short v1:16; unsigned long long v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu31ll { unsigned short v1:16; unsigned long long v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu32i { unsigned short v1:16; unsigned long long v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu32ll { unsigned short v1:16; unsigned long long v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu33 { unsigned short v1:16; unsigned long long v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu7c { unsigned short v1:16; unsigned long long v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu7i { unsigned short v1:16; unsigned long long v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu7ll { unsigned short v1:16; unsigned long long v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu7s { unsigned short v1:16; unsigned long long v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu8c { unsigned short v1:16; unsigned long long v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu8i { unsigned short v1:16; unsigned long long v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu8ll { unsigned short v1:16; unsigned long long v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu8s { unsigned short v1:16; unsigned long long v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu9i { unsigned short v1:16; unsigned long long v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu9ll { unsigned short v1:16; unsigned long long v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu7ll_BFu9s { unsigned short v1:16; unsigned long long v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu7ll_C { unsigned short v1:16; unsigned long long v2:7; char v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll_D { unsigned short v1:16; unsigned long long v2:7; double v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll_F { unsigned short v1:16; unsigned long long v2:7; float v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll_I { unsigned short v1:16; unsigned long long v2:7; int v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll_Ip { unsigned short v1:16; unsigned long long v2:7; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll_L { unsigned short v1:16; unsigned long long v2:7; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll_S { unsigned short v1:16; unsigned long long v2:7; short v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll_Uc { unsigned short v1:16; unsigned long long v2:7; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll_Ui { unsigned short v1:16; unsigned long long v2:7; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll_Ul { unsigned short v1:16; unsigned long long v2:7; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll_Us { unsigned short v1:16; unsigned long long v2:7; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu7ll_Vp { unsigned short v1:16; unsigned long long v2:7; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu7s { unsigned short v1:16; unsigned short v2:7; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu15i { unsigned short v1:16; unsigned short v2:7; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu15ll { unsigned short v1:16; unsigned short v2:7; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu15s { unsigned short v1:16; unsigned short v2:7; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu16i { unsigned short v1:16; unsigned short v2:7; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu16ll { unsigned short v1:16; unsigned short v2:7; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu16s { unsigned short v1:16; unsigned short v2:7; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu17i { unsigned short v1:16; unsigned short v2:7; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu17ll { unsigned short v1:16; unsigned short v2:7; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu1c { unsigned short v1:16; unsigned short v2:7; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu1i { unsigned short v1:16; unsigned short v2:7; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu1ll { unsigned short v1:16; unsigned short v2:7; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu1s { unsigned short v1:16; unsigned short v2:7; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu31i { unsigned short v1:16; unsigned short v2:7; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu31ll { unsigned short v1:16; unsigned short v2:7; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu32i { unsigned short v1:16; unsigned short v2:7; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu32ll { unsigned short v1:16; unsigned short v2:7; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu33 { unsigned short v1:16; unsigned short v2:7; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu7c { unsigned short v1:16; unsigned short v2:7; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu7i { unsigned short v1:16; unsigned short v2:7; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu7ll { unsigned short v1:16; unsigned short v2:7; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu7s { unsigned short v1:16; unsigned short v2:7; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu8c { unsigned short v1:16; unsigned short v2:7; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu8i { unsigned short v1:16; unsigned short v2:7; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu8ll { unsigned short v1:16; unsigned short v2:7; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu8s { unsigned short v1:16; unsigned short v2:7; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu9i { unsigned short v1:16; unsigned short v2:7; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu9ll { unsigned short v1:16; unsigned short v2:7; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu7s_BFu9s { unsigned short v1:16; unsigned short v2:7; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu7s_C { unsigned short v1:16; unsigned short v2:7; char v3; };
struct __attribute__((packed)) aBFu16s_BFu7s_D { unsigned short v1:16; unsigned short v2:7; double v3; };
struct __attribute__((packed)) aBFu16s_BFu7s_F { unsigned short v1:16; unsigned short v2:7; float v3; };
struct __attribute__((packed)) aBFu16s_BFu7s_I { unsigned short v1:16; unsigned short v2:7; int v3; };
struct __attribute__((packed)) aBFu16s_BFu7s_Ip { unsigned short v1:16; unsigned short v2:7; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu7s_L { unsigned short v1:16; unsigned short v2:7; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu7s_S { unsigned short v1:16; unsigned short v2:7; short v3; };
struct __attribute__((packed)) aBFu16s_BFu7s_Uc { unsigned short v1:16; unsigned short v2:7; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu7s_Ui { unsigned short v1:16; unsigned short v2:7; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu7s_Ul { unsigned short v1:16; unsigned short v2:7; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu7s_Us { unsigned short v1:16; unsigned short v2:7; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu7s_Vp { unsigned short v1:16; unsigned short v2:7; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu8c { unsigned short v1:16; unsigned char v2:8; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu15i { unsigned short v1:16; unsigned char v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu15ll { unsigned short v1:16; unsigned char v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu15s { unsigned short v1:16; unsigned char v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu16i { unsigned short v1:16; unsigned char v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu16ll { unsigned short v1:16; unsigned char v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu16s { unsigned short v1:16; unsigned char v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu17i { unsigned short v1:16; unsigned char v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu17ll { unsigned short v1:16; unsigned char v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu1c { unsigned short v1:16; unsigned char v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu1i { unsigned short v1:16; unsigned char v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu1ll { unsigned short v1:16; unsigned char v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu1s { unsigned short v1:16; unsigned char v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu31i { unsigned short v1:16; unsigned char v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu31ll { unsigned short v1:16; unsigned char v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu32i { unsigned short v1:16; unsigned char v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu32ll { unsigned short v1:16; unsigned char v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu33 { unsigned short v1:16; unsigned char v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu7c { unsigned short v1:16; unsigned char v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu7i { unsigned short v1:16; unsigned char v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu7ll { unsigned short v1:16; unsigned char v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu7s { unsigned short v1:16; unsigned char v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu8c { unsigned short v1:16; unsigned char v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu8i { unsigned short v1:16; unsigned char v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu8ll { unsigned short v1:16; unsigned char v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu8s { unsigned short v1:16; unsigned char v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu9i { unsigned short v1:16; unsigned char v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu9ll { unsigned short v1:16; unsigned char v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu8c_BFu9s { unsigned short v1:16; unsigned char v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu8c_C { unsigned short v1:16; unsigned char v2:8; char v3; };
struct __attribute__((packed)) aBFu16s_BFu8c_D { unsigned short v1:16; unsigned char v2:8; double v3; };
struct __attribute__((packed)) aBFu16s_BFu8c_F { unsigned short v1:16; unsigned char v2:8; float v3; };
struct __attribute__((packed)) aBFu16s_BFu8c_I { unsigned short v1:16; unsigned char v2:8; int v3; };
struct __attribute__((packed)) aBFu16s_BFu8c_Ip { unsigned short v1:16; unsigned char v2:8; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu8c_L { unsigned short v1:16; unsigned char v2:8; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu8c_S { unsigned short v1:16; unsigned char v2:8; short v3; };
struct __attribute__((packed)) aBFu16s_BFu8c_Uc { unsigned short v1:16; unsigned char v2:8; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu8c_Ui { unsigned short v1:16; unsigned char v2:8; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu8c_Ul { unsigned short v1:16; unsigned char v2:8; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu8c_Us { unsigned short v1:16; unsigned char v2:8; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu8c_Vp { unsigned short v1:16; unsigned char v2:8; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu8i { unsigned short v1:16; unsigned int v2:8; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu15i { unsigned short v1:16; unsigned int v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu15ll { unsigned short v1:16; unsigned int v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu15s { unsigned short v1:16; unsigned int v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu16i { unsigned short v1:16; unsigned int v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu16ll { unsigned short v1:16; unsigned int v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu16s { unsigned short v1:16; unsigned int v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu17i { unsigned short v1:16; unsigned int v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu17ll { unsigned short v1:16; unsigned int v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu1c { unsigned short v1:16; unsigned int v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu1i { unsigned short v1:16; unsigned int v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu1ll { unsigned short v1:16; unsigned int v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu1s { unsigned short v1:16; unsigned int v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu31i { unsigned short v1:16; unsigned int v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu31ll { unsigned short v1:16; unsigned int v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu32i { unsigned short v1:16; unsigned int v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu32ll { unsigned short v1:16; unsigned int v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu33 { unsigned short v1:16; unsigned int v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu7c { unsigned short v1:16; unsigned int v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu7i { unsigned short v1:16; unsigned int v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu7ll { unsigned short v1:16; unsigned int v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu7s { unsigned short v1:16; unsigned int v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu8c { unsigned short v1:16; unsigned int v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu8i { unsigned short v1:16; unsigned int v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu8ll { unsigned short v1:16; unsigned int v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu8s { unsigned short v1:16; unsigned int v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu9i { unsigned short v1:16; unsigned int v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu9ll { unsigned short v1:16; unsigned int v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu8i_BFu9s { unsigned short v1:16; unsigned int v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu8i_C { unsigned short v1:16; unsigned int v2:8; char v3; };
struct __attribute__((packed)) aBFu16s_BFu8i_D { unsigned short v1:16; unsigned int v2:8; double v3; };
struct __attribute__((packed)) aBFu16s_BFu8i_F { unsigned short v1:16; unsigned int v2:8; float v3; };
struct __attribute__((packed)) aBFu16s_BFu8i_I { unsigned short v1:16; unsigned int v2:8; int v3; };
struct __attribute__((packed)) aBFu16s_BFu8i_Ip { unsigned short v1:16; unsigned int v2:8; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu8i_L { unsigned short v1:16; unsigned int v2:8; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu8i_S { unsigned short v1:16; unsigned int v2:8; short v3; };
struct __attribute__((packed)) aBFu16s_BFu8i_Uc { unsigned short v1:16; unsigned int v2:8; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu8i_Ui { unsigned short v1:16; unsigned int v2:8; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu8i_Ul { unsigned short v1:16; unsigned int v2:8; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu8i_Us { unsigned short v1:16; unsigned int v2:8; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu8i_Vp { unsigned short v1:16; unsigned int v2:8; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll { unsigned short v1:16; unsigned long long v2:8; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu15i { unsigned short v1:16; unsigned long long v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu15ll { unsigned short v1:16; unsigned long long v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu15s { unsigned short v1:16; unsigned long long v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu16i { unsigned short v1:16; unsigned long long v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu16ll { unsigned short v1:16; unsigned long long v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu16s { unsigned short v1:16; unsigned long long v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu17i { unsigned short v1:16; unsigned long long v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu17ll { unsigned short v1:16; unsigned long long v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu1c { unsigned short v1:16; unsigned long long v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu1i { unsigned short v1:16; unsigned long long v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu1ll { unsigned short v1:16; unsigned long long v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu1s { unsigned short v1:16; unsigned long long v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu31i { unsigned short v1:16; unsigned long long v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu31ll { unsigned short v1:16; unsigned long long v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu32i { unsigned short v1:16; unsigned long long v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu32ll { unsigned short v1:16; unsigned long long v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu33 { unsigned short v1:16; unsigned long long v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu7c { unsigned short v1:16; unsigned long long v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu7i { unsigned short v1:16; unsigned long long v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu7ll { unsigned short v1:16; unsigned long long v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu7s { unsigned short v1:16; unsigned long long v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu8c { unsigned short v1:16; unsigned long long v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu8i { unsigned short v1:16; unsigned long long v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu8ll { unsigned short v1:16; unsigned long long v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu8s { unsigned short v1:16; unsigned long long v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu9i { unsigned short v1:16; unsigned long long v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu9ll { unsigned short v1:16; unsigned long long v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu8ll_BFu9s { unsigned short v1:16; unsigned long long v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu8ll_C { unsigned short v1:16; unsigned long long v2:8; char v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll_D { unsigned short v1:16; unsigned long long v2:8; double v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll_F { unsigned short v1:16; unsigned long long v2:8; float v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll_I { unsigned short v1:16; unsigned long long v2:8; int v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll_Ip { unsigned short v1:16; unsigned long long v2:8; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll_L { unsigned short v1:16; unsigned long long v2:8; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll_S { unsigned short v1:16; unsigned long long v2:8; short v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll_Uc { unsigned short v1:16; unsigned long long v2:8; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll_Ui { unsigned short v1:16; unsigned long long v2:8; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll_Ul { unsigned short v1:16; unsigned long long v2:8; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll_Us { unsigned short v1:16; unsigned long long v2:8; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu8ll_Vp { unsigned short v1:16; unsigned long long v2:8; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu8s { unsigned short v1:16; unsigned short v2:8; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu15i { unsigned short v1:16; unsigned short v2:8; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu15ll { unsigned short v1:16; unsigned short v2:8; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu15s { unsigned short v1:16; unsigned short v2:8; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu16i { unsigned short v1:16; unsigned short v2:8; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu16ll { unsigned short v1:16; unsigned short v2:8; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu16s { unsigned short v1:16; unsigned short v2:8; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu17i { unsigned short v1:16; unsigned short v2:8; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu17ll { unsigned short v1:16; unsigned short v2:8; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu1c { unsigned short v1:16; unsigned short v2:8; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu1i { unsigned short v1:16; unsigned short v2:8; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu1ll { unsigned short v1:16; unsigned short v2:8; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu1s { unsigned short v1:16; unsigned short v2:8; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu31i { unsigned short v1:16; unsigned short v2:8; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu31ll { unsigned short v1:16; unsigned short v2:8; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu32i { unsigned short v1:16; unsigned short v2:8; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu32ll { unsigned short v1:16; unsigned short v2:8; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu33 { unsigned short v1:16; unsigned short v2:8; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu7c { unsigned short v1:16; unsigned short v2:8; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu7i { unsigned short v1:16; unsigned short v2:8; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu7ll { unsigned short v1:16; unsigned short v2:8; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu7s { unsigned short v1:16; unsigned short v2:8; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu8c { unsigned short v1:16; unsigned short v2:8; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu8i { unsigned short v1:16; unsigned short v2:8; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu8ll { unsigned short v1:16; unsigned short v2:8; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu8s { unsigned short v1:16; unsigned short v2:8; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu9i { unsigned short v1:16; unsigned short v2:8; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu9ll { unsigned short v1:16; unsigned short v2:8; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu8s_BFu9s { unsigned short v1:16; unsigned short v2:8; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu8s_C { unsigned short v1:16; unsigned short v2:8; char v3; };
struct __attribute__((packed)) aBFu16s_BFu8s_D { unsigned short v1:16; unsigned short v2:8; double v3; };
struct __attribute__((packed)) aBFu16s_BFu8s_F { unsigned short v1:16; unsigned short v2:8; float v3; };
struct __attribute__((packed)) aBFu16s_BFu8s_I { unsigned short v1:16; unsigned short v2:8; int v3; };
struct __attribute__((packed)) aBFu16s_BFu8s_Ip { unsigned short v1:16; unsigned short v2:8; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu8s_L { unsigned short v1:16; unsigned short v2:8; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu8s_S { unsigned short v1:16; unsigned short v2:8; short v3; };
struct __attribute__((packed)) aBFu16s_BFu8s_Uc { unsigned short v1:16; unsigned short v2:8; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu8s_Ui { unsigned short v1:16; unsigned short v2:8; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu8s_Ul { unsigned short v1:16; unsigned short v2:8; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu8s_Us { unsigned short v1:16; unsigned short v2:8; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu8s_Vp { unsigned short v1:16; unsigned short v2:8; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu9i { unsigned short v1:16; unsigned int v2:9; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu15i { unsigned short v1:16; unsigned int v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu15ll { unsigned short v1:16; unsigned int v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu15s { unsigned short v1:16; unsigned int v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu16i { unsigned short v1:16; unsigned int v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu16ll { unsigned short v1:16; unsigned int v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu16s { unsigned short v1:16; unsigned int v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu17i { unsigned short v1:16; unsigned int v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu17ll { unsigned short v1:16; unsigned int v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu1c { unsigned short v1:16; unsigned int v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu1i { unsigned short v1:16; unsigned int v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu1ll { unsigned short v1:16; unsigned int v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu1s { unsigned short v1:16; unsigned int v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu31i { unsigned short v1:16; unsigned int v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu31ll { unsigned short v1:16; unsigned int v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu32i { unsigned short v1:16; unsigned int v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu32ll { unsigned short v1:16; unsigned int v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu33 { unsigned short v1:16; unsigned int v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu7c { unsigned short v1:16; unsigned int v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu7i { unsigned short v1:16; unsigned int v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu7ll { unsigned short v1:16; unsigned int v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu7s { unsigned short v1:16; unsigned int v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu8c { unsigned short v1:16; unsigned int v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu8i { unsigned short v1:16; unsigned int v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu8ll { unsigned short v1:16; unsigned int v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu8s { unsigned short v1:16; unsigned int v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu9i { unsigned short v1:16; unsigned int v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu9ll { unsigned short v1:16; unsigned int v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu9i_BFu9s { unsigned short v1:16; unsigned int v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu9i_C { unsigned short v1:16; unsigned int v2:9; char v3; };
struct __attribute__((packed)) aBFu16s_BFu9i_D { unsigned short v1:16; unsigned int v2:9; double v3; };
struct __attribute__((packed)) aBFu16s_BFu9i_F { unsigned short v1:16; unsigned int v2:9; float v3; };
struct __attribute__((packed)) aBFu16s_BFu9i_I { unsigned short v1:16; unsigned int v2:9; int v3; };
struct __attribute__((packed)) aBFu16s_BFu9i_Ip { unsigned short v1:16; unsigned int v2:9; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu9i_L { unsigned short v1:16; unsigned int v2:9; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu9i_S { unsigned short v1:16; unsigned int v2:9; short v3; };
struct __attribute__((packed)) aBFu16s_BFu9i_Uc { unsigned short v1:16; unsigned int v2:9; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu9i_Ui { unsigned short v1:16; unsigned int v2:9; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu9i_Ul { unsigned short v1:16; unsigned int v2:9; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu9i_Us { unsigned short v1:16; unsigned int v2:9; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu9i_Vp { unsigned short v1:16; unsigned int v2:9; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll { unsigned short v1:16; unsigned long long v2:9; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu15i { unsigned short v1:16; unsigned long long v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu15ll { unsigned short v1:16; unsigned long long v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu15s { unsigned short v1:16; unsigned long long v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu16i { unsigned short v1:16; unsigned long long v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu16ll { unsigned short v1:16; unsigned long long v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu16s { unsigned short v1:16; unsigned long long v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu17i { unsigned short v1:16; unsigned long long v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu17ll { unsigned short v1:16; unsigned long long v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu1c { unsigned short v1:16; unsigned long long v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu1i { unsigned short v1:16; unsigned long long v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu1ll { unsigned short v1:16; unsigned long long v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu1s { unsigned short v1:16; unsigned long long v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu31i { unsigned short v1:16; unsigned long long v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu31ll { unsigned short v1:16; unsigned long long v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu32i { unsigned short v1:16; unsigned long long v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu32ll { unsigned short v1:16; unsigned long long v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu33 { unsigned short v1:16; unsigned long long v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu7c { unsigned short v1:16; unsigned long long v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu7i { unsigned short v1:16; unsigned long long v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu7ll { unsigned short v1:16; unsigned long long v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu7s { unsigned short v1:16; unsigned long long v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu8c { unsigned short v1:16; unsigned long long v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu8i { unsigned short v1:16; unsigned long long v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu8ll { unsigned short v1:16; unsigned long long v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu8s { unsigned short v1:16; unsigned long long v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu9i { unsigned short v1:16; unsigned long long v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu9ll { unsigned short v1:16; unsigned long long v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu9ll_BFu9s { unsigned short v1:16; unsigned long long v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu9ll_C { unsigned short v1:16; unsigned long long v2:9; char v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll_D { unsigned short v1:16; unsigned long long v2:9; double v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll_F { unsigned short v1:16; unsigned long long v2:9; float v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll_I { unsigned short v1:16; unsigned long long v2:9; int v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll_Ip { unsigned short v1:16; unsigned long long v2:9; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll_L { unsigned short v1:16; unsigned long long v2:9; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll_S { unsigned short v1:16; unsigned long long v2:9; short v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll_Uc { unsigned short v1:16; unsigned long long v2:9; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll_Ui { unsigned short v1:16; unsigned long long v2:9; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll_Ul { unsigned short v1:16; unsigned long long v2:9; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll_Us { unsigned short v1:16; unsigned long long v2:9; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu9ll_Vp { unsigned short v1:16; unsigned long long v2:9; void * v3; };
struct __attribute__((packed)) aBFu16s_BFu9s { unsigned short v1:16; unsigned short v2:9; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu15i { unsigned short v1:16; unsigned short v2:9; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu15ll { unsigned short v1:16; unsigned short v2:9; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu15s { unsigned short v1:16; unsigned short v2:9; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu16i { unsigned short v1:16; unsigned short v2:9; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu16ll { unsigned short v1:16; unsigned short v2:9; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu16s { unsigned short v1:16; unsigned short v2:9; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu17i { unsigned short v1:16; unsigned short v2:9; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu17ll { unsigned short v1:16; unsigned short v2:9; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu1c { unsigned short v1:16; unsigned short v2:9; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu1i { unsigned short v1:16; unsigned short v2:9; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu1ll { unsigned short v1:16; unsigned short v2:9; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu1s { unsigned short v1:16; unsigned short v2:9; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu31i { unsigned short v1:16; unsigned short v2:9; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu31ll { unsigned short v1:16; unsigned short v2:9; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu32i { unsigned short v1:16; unsigned short v2:9; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu32ll { unsigned short v1:16; unsigned short v2:9; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu33 { unsigned short v1:16; unsigned short v2:9; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu7c { unsigned short v1:16; unsigned short v2:9; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu7i { unsigned short v1:16; unsigned short v2:9; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu7ll { unsigned short v1:16; unsigned short v2:9; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu7s { unsigned short v1:16; unsigned short v2:9; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu8c { unsigned short v1:16; unsigned short v2:9; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu8i { unsigned short v1:16; unsigned short v2:9; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu8ll { unsigned short v1:16; unsigned short v2:9; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu8s { unsigned short v1:16; unsigned short v2:9; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu9i { unsigned short v1:16; unsigned short v2:9; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu9ll { unsigned short v1:16; unsigned short v2:9; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_BFu9s_BFu9s { unsigned short v1:16; unsigned short v2:9; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_BFu9s_C { unsigned short v1:16; unsigned short v2:9; char v3; };
struct __attribute__((packed)) aBFu16s_BFu9s_D { unsigned short v1:16; unsigned short v2:9; double v3; };
struct __attribute__((packed)) aBFu16s_BFu9s_F { unsigned short v1:16; unsigned short v2:9; float v3; };
struct __attribute__((packed)) aBFu16s_BFu9s_I { unsigned short v1:16; unsigned short v2:9; int v3; };
struct __attribute__((packed)) aBFu16s_BFu9s_Ip { unsigned short v1:16; unsigned short v2:9; int * v3; };
struct __attribute__((packed)) aBFu16s_BFu9s_L { unsigned short v1:16; unsigned short v2:9; long long v3; };
struct __attribute__((packed)) aBFu16s_BFu9s_S { unsigned short v1:16; unsigned short v2:9; short v3; };
struct __attribute__((packed)) aBFu16s_BFu9s_Uc { unsigned short v1:16; unsigned short v2:9; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_BFu9s_Ui { unsigned short v1:16; unsigned short v2:9; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_BFu9s_Ul { unsigned short v1:16; unsigned short v2:9; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_BFu9s_Us { unsigned short v1:16; unsigned short v2:9; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_BFu9s_Vp { unsigned short v1:16; unsigned short v2:9; void * v3; };
struct __attribute__((packed)) aBFu16s_C { unsigned short v1:16; char v2; };
struct __attribute__((packed)) aBFu16s_C_BFu15i { unsigned short v1:16; char v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_C_BFu15ll { unsigned short v1:16; char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_C_BFu15s { unsigned short v1:16; char v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_C_BFu16i { unsigned short v1:16; char v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_C_BFu16ll { unsigned short v1:16; char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_C_BFu16s { unsigned short v1:16; char v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_C_BFu17i { unsigned short v1:16; char v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_C_BFu17ll { unsigned short v1:16; char v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_C_BFu1c { unsigned short v1:16; char v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_C_BFu1i { unsigned short v1:16; char v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_C_BFu1ll { unsigned short v1:16; char v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_C_BFu1s { unsigned short v1:16; char v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_C_BFu31i { unsigned short v1:16; char v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_C_BFu31ll { unsigned short v1:16; char v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_C_BFu32i { unsigned short v1:16; char v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_C_BFu32ll { unsigned short v1:16; char v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_C_BFu33 { unsigned short v1:16; char v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_C_BFu7c { unsigned short v1:16; char v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_C_BFu7i { unsigned short v1:16; char v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_C_BFu7ll { unsigned short v1:16; char v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_C_BFu7s { unsigned short v1:16; char v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_C_BFu8c { unsigned short v1:16; char v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_C_BFu8i { unsigned short v1:16; char v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_C_BFu8ll { unsigned short v1:16; char v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_C_BFu8s { unsigned short v1:16; char v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_C_BFu9i { unsigned short v1:16; char v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_C_BFu9ll { unsigned short v1:16; char v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_C_BFu9s { unsigned short v1:16; char v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_C_C { unsigned short v1:16; char v2; char v3; };
struct __attribute__((packed)) aBFu16s_C_D { unsigned short v1:16; char v2; double v3; };
struct __attribute__((packed)) aBFu16s_C_F { unsigned short v1:16; char v2; float v3; };
struct __attribute__((packed)) aBFu16s_C_I { unsigned short v1:16; char v2; int v3; };
struct __attribute__((packed)) aBFu16s_C_Ip { unsigned short v1:16; char v2; int * v3; };
struct __attribute__((packed)) aBFu16s_C_L { unsigned short v1:16; char v2; long long v3; };
struct __attribute__((packed)) aBFu16s_C_S { unsigned short v1:16; char v2; short v3; };
struct __attribute__((packed)) aBFu16s_C_Uc { unsigned short v1:16; char v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_C_Ui { unsigned short v1:16; char v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_C_Ul { unsigned short v1:16; char v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_C_Us { unsigned short v1:16; char v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_C_Vp { unsigned short v1:16; char v2; void * v3; };
struct __attribute__((packed)) aBFu16s_D { unsigned short v1:16; double v2; };
struct __attribute__((packed)) aBFu16s_D_BFu15i { unsigned short v1:16; double v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_D_BFu15ll { unsigned short v1:16; double v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_D_BFu15s { unsigned short v1:16; double v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_D_BFu16i { unsigned short v1:16; double v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_D_BFu16ll { unsigned short v1:16; double v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_D_BFu16s { unsigned short v1:16; double v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_D_BFu17i { unsigned short v1:16; double v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_D_BFu17ll { unsigned short v1:16; double v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_D_BFu1c { unsigned short v1:16; double v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_D_BFu1i { unsigned short v1:16; double v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_D_BFu1ll { unsigned short v1:16; double v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_D_BFu1s { unsigned short v1:16; double v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_D_BFu31i { unsigned short v1:16; double v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_D_BFu31ll { unsigned short v1:16; double v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_D_BFu32i { unsigned short v1:16; double v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_D_BFu32ll { unsigned short v1:16; double v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_D_BFu33 { unsigned short v1:16; double v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_D_BFu7c { unsigned short v1:16; double v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_D_BFu7i { unsigned short v1:16; double v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_D_BFu7ll { unsigned short v1:16; double v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_D_BFu7s { unsigned short v1:16; double v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_D_BFu8c { unsigned short v1:16; double v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_D_BFu8i { unsigned short v1:16; double v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_D_BFu8ll { unsigned short v1:16; double v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_D_BFu8s { unsigned short v1:16; double v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_D_BFu9i { unsigned short v1:16; double v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_D_BFu9ll { unsigned short v1:16; double v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_D_BFu9s { unsigned short v1:16; double v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_D_C { unsigned short v1:16; double v2; char v3; };
struct __attribute__((packed)) aBFu16s_D_D { unsigned short v1:16; double v2; double v3; };
struct __attribute__((packed)) aBFu16s_D_F { unsigned short v1:16; double v2; float v3; };
struct __attribute__((packed)) aBFu16s_D_I { unsigned short v1:16; double v2; int v3; };
struct __attribute__((packed)) aBFu16s_D_Ip { unsigned short v1:16; double v2; int * v3; };
struct __attribute__((packed)) aBFu16s_D_L { unsigned short v1:16; double v2; long long v3; };
struct __attribute__((packed)) aBFu16s_D_S { unsigned short v1:16; double v2; short v3; };
struct __attribute__((packed)) aBFu16s_D_Uc { unsigned short v1:16; double v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_D_Ui { unsigned short v1:16; double v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_D_Ul { unsigned short v1:16; double v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_D_Us { unsigned short v1:16; double v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_D_Vp { unsigned short v1:16; double v2; void * v3; };
struct __attribute__((packed)) aBFu16s_F { unsigned short v1:16; float v2; };
struct __attribute__((packed)) aBFu16s_F_BFu15i { unsigned short v1:16; float v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_F_BFu15ll { unsigned short v1:16; float v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_F_BFu15s { unsigned short v1:16; float v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_F_BFu16i { unsigned short v1:16; float v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_F_BFu16ll { unsigned short v1:16; float v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_F_BFu16s { unsigned short v1:16; float v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_F_BFu17i { unsigned short v1:16; float v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_F_BFu17ll { unsigned short v1:16; float v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_F_BFu1c { unsigned short v1:16; float v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_F_BFu1i { unsigned short v1:16; float v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_F_BFu1ll { unsigned short v1:16; float v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_F_BFu1s { unsigned short v1:16; float v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_F_BFu31i { unsigned short v1:16; float v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_F_BFu31ll { unsigned short v1:16; float v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_F_BFu32i { unsigned short v1:16; float v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_F_BFu32ll { unsigned short v1:16; float v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_F_BFu33 { unsigned short v1:16; float v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_F_BFu7c { unsigned short v1:16; float v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_F_BFu7i { unsigned short v1:16; float v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_F_BFu7ll { unsigned short v1:16; float v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_F_BFu7s { unsigned short v1:16; float v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_F_BFu8c { unsigned short v1:16; float v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_F_BFu8i { unsigned short v1:16; float v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_F_BFu8ll { unsigned short v1:16; float v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_F_BFu8s { unsigned short v1:16; float v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_F_BFu9i { unsigned short v1:16; float v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_F_BFu9ll { unsigned short v1:16; float v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_F_BFu9s { unsigned short v1:16; float v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_F_C { unsigned short v1:16; float v2; char v3; };
struct __attribute__((packed)) aBFu16s_F_D { unsigned short v1:16; float v2; double v3; };
struct __attribute__((packed)) aBFu16s_F_F { unsigned short v1:16; float v2; float v3; };
struct __attribute__((packed)) aBFu16s_F_I { unsigned short v1:16; float v2; int v3; };
struct __attribute__((packed)) aBFu16s_F_Ip { unsigned short v1:16; float v2; int * v3; };
struct __attribute__((packed)) aBFu16s_F_L { unsigned short v1:16; float v2; long long v3; };
struct __attribute__((packed)) aBFu16s_F_S { unsigned short v1:16; float v2; short v3; };
struct __attribute__((packed)) aBFu16s_F_Uc { unsigned short v1:16; float v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_F_Ui { unsigned short v1:16; float v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_F_Ul { unsigned short v1:16; float v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_F_Us { unsigned short v1:16; float v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_F_Vp { unsigned short v1:16; float v2; void * v3; };
struct __attribute__((packed)) aBFu16s_I { unsigned short v1:16; int v2; };
struct __attribute__((packed)) aBFu16s_I_BFu15i { unsigned short v1:16; int v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_I_BFu15ll { unsigned short v1:16; int v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_I_BFu15s { unsigned short v1:16; int v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_I_BFu16i { unsigned short v1:16; int v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_I_BFu16ll { unsigned short v1:16; int v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_I_BFu16s { unsigned short v1:16; int v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_I_BFu17i { unsigned short v1:16; int v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_I_BFu17ll { unsigned short v1:16; int v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_I_BFu1c { unsigned short v1:16; int v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_I_BFu1i { unsigned short v1:16; int v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_I_BFu1ll { unsigned short v1:16; int v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_I_BFu1s { unsigned short v1:16; int v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_I_BFu31i { unsigned short v1:16; int v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_I_BFu31ll { unsigned short v1:16; int v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_I_BFu32i { unsigned short v1:16; int v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_I_BFu32ll { unsigned short v1:16; int v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_I_BFu33 { unsigned short v1:16; int v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_I_BFu7c { unsigned short v1:16; int v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_I_BFu7i { unsigned short v1:16; int v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_I_BFu7ll { unsigned short v1:16; int v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_I_BFu7s { unsigned short v1:16; int v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_I_BFu8c { unsigned short v1:16; int v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_I_BFu8i { unsigned short v1:16; int v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_I_BFu8ll { unsigned short v1:16; int v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_I_BFu8s { unsigned short v1:16; int v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_I_BFu9i { unsigned short v1:16; int v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_I_BFu9ll { unsigned short v1:16; int v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_I_BFu9s { unsigned short v1:16; int v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_I_C { unsigned short v1:16; int v2; char v3; };
struct __attribute__((packed)) aBFu16s_I_D { unsigned short v1:16; int v2; double v3; };
struct __attribute__((packed)) aBFu16s_I_F { unsigned short v1:16; int v2; float v3; };
struct __attribute__((packed)) aBFu16s_I_I { unsigned short v1:16; int v2; int v3; };
struct __attribute__((packed)) aBFu16s_I_Ip { unsigned short v1:16; int v2; int * v3; };
struct __attribute__((packed)) aBFu16s_I_L { unsigned short v1:16; int v2; long long v3; };
struct __attribute__((packed)) aBFu16s_I_S { unsigned short v1:16; int v2; short v3; };
struct __attribute__((packed)) aBFu16s_I_Uc { unsigned short v1:16; int v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_I_Ui { unsigned short v1:16; int v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_I_Ul { unsigned short v1:16; int v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_I_Us { unsigned short v1:16; int v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_I_Vp { unsigned short v1:16; int v2; void * v3; };
struct __attribute__((packed)) aBFu16s_Ip { unsigned short v1:16; int * v2; };
struct __attribute__((packed)) aBFu16s_Ip_BFu15i { unsigned short v1:16; int * v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_Ip_BFu15ll { unsigned short v1:16; int * v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_Ip_BFu15s { unsigned short v1:16; int * v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_Ip_BFu16i { unsigned short v1:16; int * v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_Ip_BFu16ll { unsigned short v1:16; int * v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_Ip_BFu16s { unsigned short v1:16; int * v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_Ip_BFu17i { unsigned short v1:16; int * v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_Ip_BFu17ll { unsigned short v1:16; int * v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_Ip_BFu1c { unsigned short v1:16; int * v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_Ip_BFu1i { unsigned short v1:16; int * v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_Ip_BFu1ll { unsigned short v1:16; int * v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_Ip_BFu1s { unsigned short v1:16; int * v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_Ip_BFu31i { unsigned short v1:16; int * v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_Ip_BFu31ll { unsigned short v1:16; int * v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_Ip_BFu32i { unsigned short v1:16; int * v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_Ip_BFu32ll { unsigned short v1:16; int * v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_Ip_BFu33 { unsigned short v1:16; int * v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_Ip_BFu7c { unsigned short v1:16; int * v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_Ip_BFu7i { unsigned short v1:16; int * v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_Ip_BFu7ll { unsigned short v1:16; int * v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_Ip_BFu7s { unsigned short v1:16; int * v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_Ip_BFu8c { unsigned short v1:16; int * v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_Ip_BFu8i { unsigned short v1:16; int * v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_Ip_BFu8ll { unsigned short v1:16; int * v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_Ip_BFu8s { unsigned short v1:16; int * v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_Ip_BFu9i { unsigned short v1:16; int * v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_Ip_BFu9ll { unsigned short v1:16; int * v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_Ip_BFu9s { unsigned short v1:16; int * v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_Ip_C { unsigned short v1:16; int * v2; char v3; };
struct __attribute__((packed)) aBFu16s_Ip_D { unsigned short v1:16; int * v2; double v3; };
struct __attribute__((packed)) aBFu16s_Ip_F { unsigned short v1:16; int * v2; float v3; };
struct __attribute__((packed)) aBFu16s_Ip_I { unsigned short v1:16; int * v2; int v3; };
struct __attribute__((packed)) aBFu16s_Ip_Ip { unsigned short v1:16; int * v2; int * v3; };
struct __attribute__((packed)) aBFu16s_Ip_L { unsigned short v1:16; int * v2; long long v3; };
struct __attribute__((packed)) aBFu16s_Ip_S { unsigned short v1:16; int * v2; short v3; };
struct __attribute__((packed)) aBFu16s_Ip_Uc { unsigned short v1:16; int * v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_Ip_Ui { unsigned short v1:16; int * v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_Ip_Ul { unsigned short v1:16; int * v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_Ip_Us { unsigned short v1:16; int * v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_Ip_Vp { unsigned short v1:16; int * v2; void * v3; };
struct __attribute__((packed)) aBFu16s_L { unsigned short v1:16; long long v2; };
struct __attribute__((packed)) aBFu16s_L_BFu15i { unsigned short v1:16; long long v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_L_BFu15ll { unsigned short v1:16; long long v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_L_BFu15s { unsigned short v1:16; long long v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_L_BFu16i { unsigned short v1:16; long long v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_L_BFu16ll { unsigned short v1:16; long long v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_L_BFu16s { unsigned short v1:16; long long v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_L_BFu17i { unsigned short v1:16; long long v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_L_BFu17ll { unsigned short v1:16; long long v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_L_BFu1c { unsigned short v1:16; long long v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_L_BFu1i { unsigned short v1:16; long long v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_L_BFu1ll { unsigned short v1:16; long long v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_L_BFu1s { unsigned short v1:16; long long v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_L_BFu31i { unsigned short v1:16; long long v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_L_BFu31ll { unsigned short v1:16; long long v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_L_BFu32i { unsigned short v1:16; long long v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_L_BFu32ll { unsigned short v1:16; long long v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_L_BFu33 { unsigned short v1:16; long long v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_L_BFu7c { unsigned short v1:16; long long v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_L_BFu7i { unsigned short v1:16; long long v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_L_BFu7ll { unsigned short v1:16; long long v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_L_BFu7s { unsigned short v1:16; long long v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_L_BFu8c { unsigned short v1:16; long long v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_L_BFu8i { unsigned short v1:16; long long v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_L_BFu8ll { unsigned short v1:16; long long v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_L_BFu8s { unsigned short v1:16; long long v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_L_BFu9i { unsigned short v1:16; long long v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_L_BFu9ll { unsigned short v1:16; long long v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_L_BFu9s { unsigned short v1:16; long long v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_L_C { unsigned short v1:16; long long v2; char v3; };
struct __attribute__((packed)) aBFu16s_L_D { unsigned short v1:16; long long v2; double v3; };
struct __attribute__((packed)) aBFu16s_L_F { unsigned short v1:16; long long v2; float v3; };
struct __attribute__((packed)) aBFu16s_L_I { unsigned short v1:16; long long v2; int v3; };
struct __attribute__((packed)) aBFu16s_L_Ip { unsigned short v1:16; long long v2; int * v3; };
struct __attribute__((packed)) aBFu16s_L_L { unsigned short v1:16; long long v2; long long v3; };
struct __attribute__((packed)) aBFu16s_L_S { unsigned short v1:16; long long v2; short v3; };
struct __attribute__((packed)) aBFu16s_L_Uc { unsigned short v1:16; long long v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_L_Ui { unsigned short v1:16; long long v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_L_Ul { unsigned short v1:16; long long v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_L_Us { unsigned short v1:16; long long v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_L_Vp { unsigned short v1:16; long long v2; void * v3; };
struct __attribute__((packed)) aBFu16s_S { unsigned short v1:16; short v2; };
struct __attribute__((packed)) aBFu16s_S_BFu15i { unsigned short v1:16; short v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_S_BFu15ll { unsigned short v1:16; short v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_S_BFu15s { unsigned short v1:16; short v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_S_BFu16i { unsigned short v1:16; short v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_S_BFu16ll { unsigned short v1:16; short v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_S_BFu16s { unsigned short v1:16; short v2; unsigned short v3:16; };
struct __attribute__((packed)) aBFu16s_S_BFu17i { unsigned short v1:16; short v2; unsigned int v3:17; };
struct __attribute__((packed)) aBFu16s_S_BFu17ll { unsigned short v1:16; short v2; unsigned long long v3:17; };
struct __attribute__((packed)) aBFu16s_S_BFu1c { unsigned short v1:16; short v2; unsigned char v3:1; };
struct __attribute__((packed)) aBFu16s_S_BFu1i { unsigned short v1:16; short v2; unsigned int v3:1; };
struct __attribute__((packed)) aBFu16s_S_BFu1ll { unsigned short v1:16; short v2; unsigned long long v3:1; };
struct __attribute__((packed)) aBFu16s_S_BFu1s { unsigned short v1:16; short v2; unsigned short v3:1; };
struct __attribute__((packed)) aBFu16s_S_BFu31i { unsigned short v1:16; short v2; unsigned int v3:31; };
struct __attribute__((packed)) aBFu16s_S_BFu31ll { unsigned short v1:16; short v2; unsigned long long v3:31; };
struct __attribute__((packed)) aBFu16s_S_BFu32i { unsigned short v1:16; short v2; unsigned int v3:32; };
struct __attribute__((packed)) aBFu16s_S_BFu32ll { unsigned short v1:16; short v2; unsigned long long v3:32; };
struct __attribute__((packed)) aBFu16s_S_BFu33 { unsigned short v1:16; short v2; unsigned long long v3:33; };
struct __attribute__((packed)) aBFu16s_S_BFu7c { unsigned short v1:16; short v2; unsigned char v3:7; };
struct __attribute__((packed)) aBFu16s_S_BFu7i { unsigned short v1:16; short v2; unsigned int v3:7; };
struct __attribute__((packed)) aBFu16s_S_BFu7ll { unsigned short v1:16; short v2; unsigned long long v3:7; };
struct __attribute__((packed)) aBFu16s_S_BFu7s { unsigned short v1:16; short v2; unsigned short v3:7; };
struct __attribute__((packed)) aBFu16s_S_BFu8c { unsigned short v1:16; short v2; unsigned char v3:8; };
struct __attribute__((packed)) aBFu16s_S_BFu8i { unsigned short v1:16; short v2; unsigned int v3:8; };
struct __attribute__((packed)) aBFu16s_S_BFu8ll { unsigned short v1:16; short v2; unsigned long long v3:8; };
struct __attribute__((packed)) aBFu16s_S_BFu8s { unsigned short v1:16; short v2; unsigned short v3:8; };
struct __attribute__((packed)) aBFu16s_S_BFu9i { unsigned short v1:16; short v2; unsigned int v3:9; };
struct __attribute__((packed)) aBFu16s_S_BFu9ll { unsigned short v1:16; short v2; unsigned long long v3:9; };
struct __attribute__((packed)) aBFu16s_S_BFu9s { unsigned short v1:16; short v2; unsigned short v3:9; };
struct __attribute__((packed)) aBFu16s_S_C { unsigned short v1:16; short v2; char v3; };
struct __attribute__((packed)) aBFu16s_S_D { unsigned short v1:16; short v2; double v3; };
struct __attribute__((packed)) aBFu16s_S_F { unsigned short v1:16; short v2; float v3; };
struct __attribute__((packed)) aBFu16s_S_I { unsigned short v1:16; short v2; int v3; };
struct __attribute__((packed)) aBFu16s_S_Ip { unsigned short v1:16; short v2; int * v3; };
struct __attribute__((packed)) aBFu16s_S_L { unsigned short v1:16; short v2; long long v3; };
struct __attribute__((packed)) aBFu16s_S_S { unsigned short v1:16; short v2; short v3; };
struct __attribute__((packed)) aBFu16s_S_Uc { unsigned short v1:16; short v2; unsigned char v3; };
struct __attribute__((packed)) aBFu16s_S_Ui { unsigned short v1:16; short v2; unsigned int v3; };
struct __attribute__((packed)) aBFu16s_S_Ul { unsigned short v1:16; short v2; unsigned long long v3; };
struct __attribute__((packed)) aBFu16s_S_Us { unsigned short v1:16; short v2; unsigned short v3; };
struct __attribute__((packed)) aBFu16s_S_Vp { unsigned short v1:16; short v2; void * v3; };
struct __attribute__((packed)) aBFu16s_Uc { unsigned short v1:16; unsigned char v2; };
struct __attribute__((packed)) aBFu16s_Uc_BFu15i { unsigned short v1:16; unsigned char v2; unsigned int v3:15; };
struct __attribute__((packed)) aBFu16s_Uc_BFu15ll { unsigned short v1:16; unsigned char v2; unsigned long long v3:15; };
struct __attribute__((packed)) aBFu16s_Uc_BFu15s { unsigned short v1:16; unsigned char v2; unsigned short v3:15; };
struct __attribute__((packed)) aBFu16s_Uc_BFu16i { unsigned short v1:16; unsigned char v2; unsigned int v3:16; };
struct __attribute__((packed)) aBFu16s_Uc_BFu16ll { unsigned short v1:16; unsigned char v2; unsigned long long v3:16; };
struct __attribute__((packed)) aBFu16s_Uc_BFu16s { unsigned short v1:16; unsigned char v2; unsigned short v3:16; };


static void Test_aBFu16ll_BFu1c_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aBFu16ll_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu15i, aBFu16ll_BFu1c_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aBFu16ll_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu15ll, aBFu16ll_BFu1c_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aBFu16ll_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu15s, aBFu16ll_BFu1c_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aBFu16ll_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu16i, aBFu16ll_BFu1c_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aBFu16ll_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu16ll, aBFu16ll_BFu1c_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aBFu16ll_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu16s, aBFu16ll_BFu1c_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aBFu16ll_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu17i, aBFu16ll_BFu1c_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aBFu16ll_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu17ll, aBFu16ll_BFu1c_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu1c, aBFu16ll_BFu1c_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu1i, aBFu16ll_BFu1c_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu1ll, aBFu16ll_BFu1c_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu1s, aBFu16ll_BFu1c_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu1c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aBFu16ll_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu31i, aBFu16ll_BFu1c_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu1c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aBFu16ll_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu31ll, aBFu16ll_BFu1c_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aBFu16ll_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu32i, aBFu16ll_BFu1c_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aBFu16ll_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu32ll, aBFu16ll_BFu1c_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "aBFu16ll_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "aBFu16ll_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu33, aBFu16ll_BFu1c_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu7c, aBFu16ll_BFu1c_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu7i, aBFu16ll_BFu1c_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu7ll, aBFu16ll_BFu1c_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu7s, aBFu16ll_BFu1c_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu8c, aBFu16ll_BFu1c_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu8i, aBFu16ll_BFu1c_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu8ll, aBFu16ll_BFu1c_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu8s, aBFu16ll_BFu1c_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aBFu16ll_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu9i, aBFu16ll_BFu1c_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aBFu16ll_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu9ll, aBFu16ll_BFu1c_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu1c_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu1c_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu1c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aBFu16ll_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_BFu9s, aBFu16ll_BFu1c_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu1c_C()
{
  {
    init_simple_test("aBFu16ll_BFu1c_C");
    static STRUCT_IF_C aBFu16ll_BFu1c_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_C");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_C");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_C, aBFu16ll_BFu1c_C)
//============================================================================



static void Test_aBFu16ll_BFu1c_D()
{
  {
    init_simple_test("aBFu16ll_BFu1c_D");
    static STRUCT_IF_C aBFu16ll_BFu1c_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu1c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_D");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_D");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_D, aBFu16ll_BFu1c_D)
//============================================================================



static void Test_aBFu16ll_BFu1c_F()
{
  {
    init_simple_test("aBFu16ll_BFu1c_F");
    static STRUCT_IF_C aBFu16ll_BFu1c_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_F");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_F");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_F, aBFu16ll_BFu1c_F)
//============================================================================



static void Test_aBFu16ll_BFu1c_I()
{
  {
    init_simple_test("aBFu16ll_BFu1c_I");
    static STRUCT_IF_C aBFu16ll_BFu1c_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_I");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_I");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_I, aBFu16ll_BFu1c_I)
//============================================================================



static void Test_aBFu16ll_BFu1c_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu1c_Ip");
    static STRUCT_IF_C aBFu16ll_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu1c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_Ip");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_Ip");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_Ip, aBFu16ll_BFu1c_Ip)
//============================================================================



static void Test_aBFu16ll_BFu1c_L()
{
  {
    init_simple_test("aBFu16ll_BFu1c_L");
    static STRUCT_IF_C aBFu16ll_BFu1c_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu1c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_L");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_L");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_L, aBFu16ll_BFu1c_L)
//============================================================================



static void Test_aBFu16ll_BFu1c_S()
{
  {
    init_simple_test("aBFu16ll_BFu1c_S");
    static STRUCT_IF_C aBFu16ll_BFu1c_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_S");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_S");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_S, aBFu16ll_BFu1c_S)
//============================================================================



static void Test_aBFu16ll_BFu1c_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu1c_Uc");
    static STRUCT_IF_C aBFu16ll_BFu1c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_Uc");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_Uc");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_Uc, aBFu16ll_BFu1c_Uc)
//============================================================================



static void Test_aBFu16ll_BFu1c_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu1c_Ui");
    static STRUCT_IF_C aBFu16ll_BFu1c_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_Ui");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_Ui");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_Ui, aBFu16ll_BFu1c_Ui)
//============================================================================



static void Test_aBFu16ll_BFu1c_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu1c_Ul");
    static STRUCT_IF_C aBFu16ll_BFu1c_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu1c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_Ul");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_Ul");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_Ul, aBFu16ll_BFu1c_Ul)
//============================================================================



static void Test_aBFu16ll_BFu1c_Us()
{
  {
    init_simple_test("aBFu16ll_BFu1c_Us");
    static STRUCT_IF_C aBFu16ll_BFu1c_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_Us");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_Us");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_Us, aBFu16ll_BFu1c_Us)
//============================================================================



static void Test_aBFu16ll_BFu1c_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu1c_Vp");
    static STRUCT_IF_C aBFu16ll_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu1c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1c_Vp");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1c_Vp");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1c_Vp, aBFu16ll_BFu1c_Vp)
//============================================================================



static void Test_aBFu16ll_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i, aBFu16ll_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aBFu16ll_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu15i, aBFu16ll_BFu1i_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aBFu16ll_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu15ll, aBFu16ll_BFu1i_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aBFu16ll_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu15s, aBFu16ll_BFu1i_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aBFu16ll_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu16i, aBFu16ll_BFu1i_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aBFu16ll_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu16ll, aBFu16ll_BFu1i_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aBFu16ll_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu16s, aBFu16ll_BFu1i_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aBFu16ll_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu17i, aBFu16ll_BFu1i_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aBFu16ll_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu17ll, aBFu16ll_BFu1i_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu1c, aBFu16ll_BFu1i_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu1i, aBFu16ll_BFu1i_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu1ll, aBFu16ll_BFu1i_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu1s, aBFu16ll_BFu1i_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu1i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aBFu16ll_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu31i, aBFu16ll_BFu1i_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu1i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aBFu16ll_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu31ll, aBFu16ll_BFu1i_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aBFu16ll_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu32i, aBFu16ll_BFu1i_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aBFu16ll_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu32ll, aBFu16ll_BFu1i_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "aBFu16ll_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "aBFu16ll_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu33, aBFu16ll_BFu1i_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu7c, aBFu16ll_BFu1i_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu7i, aBFu16ll_BFu1i_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu7ll, aBFu16ll_BFu1i_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu7s, aBFu16ll_BFu1i_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu8c, aBFu16ll_BFu1i_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu8i, aBFu16ll_BFu1i_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu8ll, aBFu16ll_BFu1i_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu8s, aBFu16ll_BFu1i_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aBFu16ll_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu9i, aBFu16ll_BFu1i_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aBFu16ll_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu9ll, aBFu16ll_BFu1i_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu1i_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu1i_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu1i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aBFu16ll_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_BFu9s, aBFu16ll_BFu1i_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu1i_C()
{
  {
    init_simple_test("aBFu16ll_BFu1i_C");
    static STRUCT_IF_C aBFu16ll_BFu1i_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_C");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_C");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_C, aBFu16ll_BFu1i_C)
//============================================================================



static void Test_aBFu16ll_BFu1i_D()
{
  {
    init_simple_test("aBFu16ll_BFu1i_D");
    static STRUCT_IF_C aBFu16ll_BFu1i_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu1i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_D");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_D");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_D, aBFu16ll_BFu1i_D)
//============================================================================



static void Test_aBFu16ll_BFu1i_F()
{
  {
    init_simple_test("aBFu16ll_BFu1i_F");
    static STRUCT_IF_C aBFu16ll_BFu1i_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_F");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_F");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_F, aBFu16ll_BFu1i_F)
//============================================================================



static void Test_aBFu16ll_BFu1i_I()
{
  {
    init_simple_test("aBFu16ll_BFu1i_I");
    static STRUCT_IF_C aBFu16ll_BFu1i_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_I");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_I");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_I, aBFu16ll_BFu1i_I)
//============================================================================



static void Test_aBFu16ll_BFu1i_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu1i_Ip");
    static STRUCT_IF_C aBFu16ll_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu1i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_Ip");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_Ip, aBFu16ll_BFu1i_Ip)
//============================================================================



static void Test_aBFu16ll_BFu1i_L()
{
  {
    init_simple_test("aBFu16ll_BFu1i_L");
    static STRUCT_IF_C aBFu16ll_BFu1i_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu1i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_L");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_L");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_L, aBFu16ll_BFu1i_L)
//============================================================================



static void Test_aBFu16ll_BFu1i_S()
{
  {
    init_simple_test("aBFu16ll_BFu1i_S");
    static STRUCT_IF_C aBFu16ll_BFu1i_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_S");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_S");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_S, aBFu16ll_BFu1i_S)
//============================================================================



static void Test_aBFu16ll_BFu1i_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu1i_Uc");
    static STRUCT_IF_C aBFu16ll_BFu1i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_Uc");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_Uc, aBFu16ll_BFu1i_Uc)
//============================================================================



static void Test_aBFu16ll_BFu1i_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu1i_Ui");
    static STRUCT_IF_C aBFu16ll_BFu1i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_Ui");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_Ui, aBFu16ll_BFu1i_Ui)
//============================================================================



static void Test_aBFu16ll_BFu1i_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu1i_Ul");
    static STRUCT_IF_C aBFu16ll_BFu1i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu1i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_Ul");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_Ul, aBFu16ll_BFu1i_Ul)
//============================================================================



static void Test_aBFu16ll_BFu1i_Us()
{
  {
    init_simple_test("aBFu16ll_BFu1i_Us");
    static STRUCT_IF_C aBFu16ll_BFu1i_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_Us");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_Us");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_Us, aBFu16ll_BFu1i_Us)
//============================================================================



static void Test_aBFu16ll_BFu1i_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu1i_Vp");
    static STRUCT_IF_C aBFu16ll_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu1i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1i_Vp");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1i_Vp, aBFu16ll_BFu1i_Vp)
//============================================================================



static void Test_aBFu16ll_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll, aBFu16ll_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aBFu16ll_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu15i, aBFu16ll_BFu1ll_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aBFu16ll_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu15ll, aBFu16ll_BFu1ll_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aBFu16ll_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu15s, aBFu16ll_BFu1ll_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aBFu16ll_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu16i, aBFu16ll_BFu1ll_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aBFu16ll_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu16ll, aBFu16ll_BFu1ll_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aBFu16ll_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu16s, aBFu16ll_BFu1ll_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aBFu16ll_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu17i, aBFu16ll_BFu1ll_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aBFu16ll_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu17ll, aBFu16ll_BFu1ll_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu1c, aBFu16ll_BFu1ll_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu1i, aBFu16ll_BFu1ll_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu1ll, aBFu16ll_BFu1ll_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu1s, aBFu16ll_BFu1ll_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu1ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aBFu16ll_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu31i, aBFu16ll_BFu1ll_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aBFu16ll_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu31ll, aBFu16ll_BFu1ll_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aBFu16ll_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu32i, aBFu16ll_BFu1ll_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aBFu16ll_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu32ll, aBFu16ll_BFu1ll_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "aBFu16ll_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "aBFu16ll_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu33, aBFu16ll_BFu1ll_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu7c, aBFu16ll_BFu1ll_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu7i, aBFu16ll_BFu1ll_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu7ll, aBFu16ll_BFu1ll_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu7s, aBFu16ll_BFu1ll_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu8c, aBFu16ll_BFu1ll_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu8i, aBFu16ll_BFu1ll_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu8ll, aBFu16ll_BFu1ll_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu8s, aBFu16ll_BFu1ll_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aBFu16ll_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu9i, aBFu16ll_BFu1ll_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aBFu16ll_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu9ll, aBFu16ll_BFu1ll_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu1ll_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu1ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aBFu16ll_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_BFu9s, aBFu16ll_BFu1ll_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu1ll_C()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_C");
    static STRUCT_IF_C aBFu16ll_BFu1ll_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_C");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_C");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_C, aBFu16ll_BFu1ll_C)
//============================================================================



static void Test_aBFu16ll_BFu1ll_D()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_D");
    static STRUCT_IF_C aBFu16ll_BFu1ll_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu1ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_D");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_D");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_D, aBFu16ll_BFu1ll_D)
//============================================================================



static void Test_aBFu16ll_BFu1ll_F()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_F");
    static STRUCT_IF_C aBFu16ll_BFu1ll_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_F");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_F");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_F, aBFu16ll_BFu1ll_F)
//============================================================================



static void Test_aBFu16ll_BFu1ll_I()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_I");
    static STRUCT_IF_C aBFu16ll_BFu1ll_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_I");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_I");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_I, aBFu16ll_BFu1ll_I)
//============================================================================



static void Test_aBFu16ll_BFu1ll_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_Ip");
    static STRUCT_IF_C aBFu16ll_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu1ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_Ip");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_Ip, aBFu16ll_BFu1ll_Ip)
//============================================================================



static void Test_aBFu16ll_BFu1ll_L()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_L");
    static STRUCT_IF_C aBFu16ll_BFu1ll_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu1ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_L");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_L");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_L, aBFu16ll_BFu1ll_L)
//============================================================================



static void Test_aBFu16ll_BFu1ll_S()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_S");
    static STRUCT_IF_C aBFu16ll_BFu1ll_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_S");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_S");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_S, aBFu16ll_BFu1ll_S)
//============================================================================



static void Test_aBFu16ll_BFu1ll_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_Uc");
    static STRUCT_IF_C aBFu16ll_BFu1ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_Uc");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_Uc, aBFu16ll_BFu1ll_Uc)
//============================================================================



static void Test_aBFu16ll_BFu1ll_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_Ui");
    static STRUCT_IF_C aBFu16ll_BFu1ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_Ui");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_Ui, aBFu16ll_BFu1ll_Ui)
//============================================================================



static void Test_aBFu16ll_BFu1ll_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_Ul");
    static STRUCT_IF_C aBFu16ll_BFu1ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu1ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_Ul");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_Ul, aBFu16ll_BFu1ll_Ul)
//============================================================================



static void Test_aBFu16ll_BFu1ll_Us()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_Us");
    static STRUCT_IF_C aBFu16ll_BFu1ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_Us");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_Us, aBFu16ll_BFu1ll_Us)
//============================================================================



static void Test_aBFu16ll_BFu1ll_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu1ll_Vp");
    static STRUCT_IF_C aBFu16ll_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu1ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1ll_Vp");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1ll_Vp, aBFu16ll_BFu1ll_Vp)
//============================================================================



static void Test_aBFu16ll_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s, aBFu16ll_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aBFu16ll_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu15i, aBFu16ll_BFu1s_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu15ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aBFu16ll_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu15ll, aBFu16ll_BFu1s_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "aBFu16ll_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu15s, aBFu16ll_BFu1s_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aBFu16ll_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu16i, aBFu16ll_BFu1s_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aBFu16ll_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu16ll, aBFu16ll_BFu1s_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "aBFu16ll_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu16s, aBFu16ll_BFu1s_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aBFu16ll_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu17i, aBFu16ll_BFu1s_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "aBFu16ll_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu17ll, aBFu16ll_BFu1s_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu1c, aBFu16ll_BFu1s_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu1i, aBFu16ll_BFu1s_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu1ll, aBFu16ll_BFu1s_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "aBFu16ll_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu1s, aBFu16ll_BFu1s_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu1s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aBFu16ll_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu31i, aBFu16ll_BFu1s_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu1s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "aBFu16ll_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu31ll, aBFu16ll_BFu1s_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aBFu16ll_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu32i, aBFu16ll_BFu1s_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "aBFu16ll_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu32ll, aBFu16ll_BFu1s_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "aBFu16ll_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "aBFu16ll_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu33, aBFu16ll_BFu1s_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu7c, aBFu16ll_BFu1s_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu7i, aBFu16ll_BFu1s_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu7ll, aBFu16ll_BFu1s_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu1s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "aBFu16ll_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu7s, aBFu16ll_BFu1s_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu8c, aBFu16ll_BFu1s_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu8i, aBFu16ll_BFu1s_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu8ll, aBFu16ll_BFu1s_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "aBFu16ll_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu8s, aBFu16ll_BFu1s_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aBFu16ll_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu9i, aBFu16ll_BFu1s_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aBFu16ll_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu9ll, aBFu16ll_BFu1s_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu1s_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu1s_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu1s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "aBFu16ll_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_BFu9s, aBFu16ll_BFu1s_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu1s_C()
{
  {
    init_simple_test("aBFu16ll_BFu1s_C");
    static STRUCT_IF_C aBFu16ll_BFu1s_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_C");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_C");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_C, aBFu16ll_BFu1s_C)
//============================================================================



static void Test_aBFu16ll_BFu1s_D()
{
  {
    init_simple_test("aBFu16ll_BFu1s_D");
    static STRUCT_IF_C aBFu16ll_BFu1s_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu1s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_D");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_D");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_D, aBFu16ll_BFu1s_D)
//============================================================================



static void Test_aBFu16ll_BFu1s_F()
{
  {
    init_simple_test("aBFu16ll_BFu1s_F");
    static STRUCT_IF_C aBFu16ll_BFu1s_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_F");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_F");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_F, aBFu16ll_BFu1s_F)
//============================================================================



static void Test_aBFu16ll_BFu1s_I()
{
  {
    init_simple_test("aBFu16ll_BFu1s_I");
    static STRUCT_IF_C aBFu16ll_BFu1s_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_I");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_I");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_I, aBFu16ll_BFu1s_I)
//============================================================================



static void Test_aBFu16ll_BFu1s_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu1s_Ip");
    static STRUCT_IF_C aBFu16ll_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu1s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_Ip");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_Ip, aBFu16ll_BFu1s_Ip)
//============================================================================



static void Test_aBFu16ll_BFu1s_L()
{
  {
    init_simple_test("aBFu16ll_BFu1s_L");
    static STRUCT_IF_C aBFu16ll_BFu1s_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu1s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_L");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_L");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_L, aBFu16ll_BFu1s_L)
//============================================================================



static void Test_aBFu16ll_BFu1s_S()
{
  {
    init_simple_test("aBFu16ll_BFu1s_S");
    static STRUCT_IF_C aBFu16ll_BFu1s_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_S");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_S");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_S, aBFu16ll_BFu1s_S)
//============================================================================



static void Test_aBFu16ll_BFu1s_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu1s_Uc");
    static STRUCT_IF_C aBFu16ll_BFu1s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu1s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_Uc");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_Uc, aBFu16ll_BFu1s_Uc)
//============================================================================



static void Test_aBFu16ll_BFu1s_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu1s_Ui");
    static STRUCT_IF_C aBFu16ll_BFu1s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu1s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_Ui");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_Ui, aBFu16ll_BFu1s_Ui)
//============================================================================



static void Test_aBFu16ll_BFu1s_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu1s_Ul");
    static STRUCT_IF_C aBFu16ll_BFu1s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu1s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_Ul");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_Ul, aBFu16ll_BFu1s_Ul)
//============================================================================



static void Test_aBFu16ll_BFu1s_Us()
{
  {
    init_simple_test("aBFu16ll_BFu1s_Us");
    static STRUCT_IF_C aBFu16ll_BFu1s_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu1s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_Us");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_Us");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_Us, aBFu16ll_BFu1s_Us)
//============================================================================



static void Test_aBFu16ll_BFu1s_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu1s_Vp");
    static STRUCT_IF_C aBFu16ll_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu1s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu1s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu1s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu1s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "aBFu16ll_BFu1s_Vp");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu1s_Vp, aBFu16ll_BFu1s_Vp)
//============================================================================



static void Test_aBFu16ll_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu31i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i, aBFu16ll_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aBFu16ll_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu15i, aBFu16ll_BFu31i_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aBFu16ll_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu15ll, aBFu16ll_BFu31i_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aBFu16ll_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu15s, aBFu16ll_BFu31i_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aBFu16ll_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu16i, aBFu16ll_BFu31i_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aBFu16ll_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu16ll, aBFu16ll_BFu31i_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aBFu16ll_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu16s, aBFu16ll_BFu31i_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aBFu16ll_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aBFu16ll_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu17i, aBFu16ll_BFu31i_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aBFu16ll_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aBFu16ll_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu17ll, aBFu16ll_BFu31i_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu31i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aBFu16ll_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu1c, aBFu16ll_BFu31i_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu31i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aBFu16ll_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu1i, aBFu16ll_BFu31i_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu31i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aBFu16ll_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu1ll, aBFu16ll_BFu31i_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu31i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aBFu16ll_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu1s, aBFu16ll_BFu31i_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aBFu16ll_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu31i, aBFu16ll_BFu31i_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aBFu16ll_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu31ll, aBFu16ll_BFu31i_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aBFu16ll_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aBFu16ll_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu32i, aBFu16ll_BFu31i_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aBFu16ll_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aBFu16ll_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu32ll, aBFu16ll_BFu31i_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, 1, "aBFu16ll_BFu31i_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, hide_ull(1LL<<32), "aBFu16ll_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu33, aBFu16ll_BFu31i_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aBFu16ll_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu7c, aBFu16ll_BFu31i_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aBFu16ll_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu7i, aBFu16ll_BFu31i_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aBFu16ll_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu7ll, aBFu16ll_BFu31i_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aBFu16ll_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu7s, aBFu16ll_BFu31i_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aBFu16ll_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu8c, aBFu16ll_BFu31i_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aBFu16ll_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu8i, aBFu16ll_BFu31i_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aBFu16ll_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu8ll, aBFu16ll_BFu31i_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aBFu16ll_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu8s, aBFu16ll_BFu31i_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aBFu16ll_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu9i, aBFu16ll_BFu31i_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aBFu16ll_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu9ll, aBFu16ll_BFu31i_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu31i_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu31i_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu31i_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aBFu16ll_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_BFu9s, aBFu16ll_BFu31i_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu31i_C()
{
  {
    init_simple_test("aBFu16ll_BFu31i_C");
    static STRUCT_IF_C aBFu16ll_BFu31i_C lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_C");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_C");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_C");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_C, aBFu16ll_BFu31i_C)
//============================================================================



static void Test_aBFu16ll_BFu31i_D()
{
  {
    init_simple_test("aBFu16ll_BFu31i_D");
    static STRUCT_IF_C aBFu16ll_BFu31i_D lv;
    check2(sizeof(lv), 14, "sizeof(aBFu16ll_BFu31i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_D");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_D");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_D");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_D, aBFu16ll_BFu31i_D)
//============================================================================



static void Test_aBFu16ll_BFu31i_F()
{
  {
    init_simple_test("aBFu16ll_BFu31i_F");
    static STRUCT_IF_C aBFu16ll_BFu31i_F lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_F");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_F");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_F");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_F, aBFu16ll_BFu31i_F)
//============================================================================



static void Test_aBFu16ll_BFu31i_I()
{
  {
    init_simple_test("aBFu16ll_BFu31i_I");
    static STRUCT_IF_C aBFu16ll_BFu31i_I lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_I");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_I");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_I");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_I, aBFu16ll_BFu31i_I)
//============================================================================



static void Test_aBFu16ll_BFu31i_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu31i_Ip");
    static STRUCT_IF_C aBFu16ll_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu16ll_BFu31i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_Ip");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_Ip, aBFu16ll_BFu31i_Ip)
//============================================================================



static void Test_aBFu16ll_BFu31i_L()
{
  {
    init_simple_test("aBFu16ll_BFu31i_L");
    static STRUCT_IF_C aBFu16ll_BFu31i_L lv;
    check2(sizeof(lv), 14, "sizeof(aBFu16ll_BFu31i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_L");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_L");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_L");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_L, aBFu16ll_BFu31i_L)
//============================================================================



static void Test_aBFu16ll_BFu31i_S()
{
  {
    init_simple_test("aBFu16ll_BFu31i_S");
    static STRUCT_IF_C aBFu16ll_BFu31i_S lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_S");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_S");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_S");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_S, aBFu16ll_BFu31i_S)
//============================================================================



static void Test_aBFu16ll_BFu31i_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu31i_Uc");
    static STRUCT_IF_C aBFu16ll_BFu31i_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_Uc");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_Uc, aBFu16ll_BFu31i_Uc)
//============================================================================



static void Test_aBFu16ll_BFu31i_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu31i_Ui");
    static STRUCT_IF_C aBFu16ll_BFu31i_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_Ui");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_Ui, aBFu16ll_BFu31i_Ui)
//============================================================================



static void Test_aBFu16ll_BFu31i_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu31i_Ul");
    static STRUCT_IF_C aBFu16ll_BFu31i_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aBFu16ll_BFu31i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_Ul");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_Ul, aBFu16ll_BFu31i_Ul)
//============================================================================



static void Test_aBFu16ll_BFu31i_Us()
{
  {
    init_simple_test("aBFu16ll_BFu31i_Us");
    static STRUCT_IF_C aBFu16ll_BFu31i_Us lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_Us");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_Us");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_Us");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_Us, aBFu16ll_BFu31i_Us)
//============================================================================



static void Test_aBFu16ll_BFu31i_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu31i_Vp");
    static STRUCT_IF_C aBFu16ll_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu16ll_BFu31i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31i_Vp");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31i_Vp, aBFu16ll_BFu31i_Vp)
//============================================================================



static void Test_aBFu16ll_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu31ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll, aBFu16ll_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aBFu16ll_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu15i, aBFu16ll_BFu31ll_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aBFu16ll_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu15ll, aBFu16ll_BFu31ll_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "aBFu16ll_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu15s, aBFu16ll_BFu31ll_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aBFu16ll_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu16i, aBFu16ll_BFu31ll_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aBFu16ll_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu16ll, aBFu16ll_BFu31ll_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "aBFu16ll_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu16s, aBFu16ll_BFu31ll_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aBFu16ll_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aBFu16ll_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu17i, aBFu16ll_BFu31ll_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "aBFu16ll_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "aBFu16ll_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu17ll, aBFu16ll_BFu31ll_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu31ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aBFu16ll_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu1c, aBFu16ll_BFu31ll_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu31ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aBFu16ll_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu1i, aBFu16ll_BFu31ll_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aBFu16ll_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu1ll, aBFu16ll_BFu31ll_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu31ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "aBFu16ll_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu1s, aBFu16ll_BFu31ll_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aBFu16ll_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu31i, aBFu16ll_BFu31ll_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, 1, "aBFu16ll_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, 5, 7, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu31ll, aBFu16ll_BFu31ll_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aBFu16ll_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aBFu16ll_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu32i, aBFu16ll_BFu31ll_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, 1, "aBFu16ll_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, 5, 7, 32, hide_ull(1LL<<31), "aBFu16ll_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu32ll, aBFu16ll_BFu31ll_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu33 lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, 1, "aBFu16ll_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, 5, 7, 33, hide_ull(1LL<<32), "aBFu16ll_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu33, aBFu16ll_BFu31ll_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aBFu16ll_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu7c, aBFu16ll_BFu31ll_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aBFu16ll_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu7i, aBFu16ll_BFu31ll_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aBFu16ll_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu7ll, aBFu16ll_BFu31ll_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "aBFu16ll_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu7s, aBFu16ll_BFu31ll_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aBFu16ll_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu8c, aBFu16ll_BFu31ll_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aBFu16ll_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu8i, aBFu16ll_BFu31ll_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aBFu16ll_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu8ll, aBFu16ll_BFu31ll_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "aBFu16ll_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu8s, aBFu16ll_BFu31ll_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aBFu16ll_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu9i, aBFu16ll_BFu31ll_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aBFu16ll_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu9ll, aBFu16ll_BFu31ll_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu31ll_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "aBFu16ll_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_BFu9s, aBFu16ll_BFu31ll_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu31ll_C()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_C");
    static STRUCT_IF_C aBFu16ll_BFu31ll_C lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_C");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_C");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_C");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_C, aBFu16ll_BFu31ll_C)
//============================================================================



static void Test_aBFu16ll_BFu31ll_D()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_D");
    static STRUCT_IF_C aBFu16ll_BFu31ll_D lv;
    check2(sizeof(lv), 14, "sizeof(aBFu16ll_BFu31ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_D");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_D");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_D");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_D, aBFu16ll_BFu31ll_D)
//============================================================================



static void Test_aBFu16ll_BFu31ll_F()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_F");
    static STRUCT_IF_C aBFu16ll_BFu31ll_F lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_F");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_F");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_F");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_F, aBFu16ll_BFu31ll_F)
//============================================================================



static void Test_aBFu16ll_BFu31ll_I()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_I");
    static STRUCT_IF_C aBFu16ll_BFu31ll_I lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_I");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_I");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_I");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_I, aBFu16ll_BFu31ll_I)
//============================================================================



static void Test_aBFu16ll_BFu31ll_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_Ip");
    static STRUCT_IF_C aBFu16ll_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu16ll_BFu31ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_Ip");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_Ip, aBFu16ll_BFu31ll_Ip)
//============================================================================



static void Test_aBFu16ll_BFu31ll_L()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_L");
    static STRUCT_IF_C aBFu16ll_BFu31ll_L lv;
    check2(sizeof(lv), 14, "sizeof(aBFu16ll_BFu31ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_L");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_L");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_L");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_L, aBFu16ll_BFu31ll_L)
//============================================================================



static void Test_aBFu16ll_BFu31ll_S()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_S");
    static STRUCT_IF_C aBFu16ll_BFu31ll_S lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_S");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_S");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_S");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_S, aBFu16ll_BFu31ll_S)
//============================================================================



static void Test_aBFu16ll_BFu31ll_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_Uc");
    static STRUCT_IF_C aBFu16ll_BFu31ll_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu31ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_Uc");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_Uc, aBFu16ll_BFu31ll_Uc)
//============================================================================



static void Test_aBFu16ll_BFu31ll_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_Ui");
    static STRUCT_IF_C aBFu16ll_BFu31ll_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu31ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_Ui");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_Ui, aBFu16ll_BFu31ll_Ui)
//============================================================================



static void Test_aBFu16ll_BFu31ll_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_Ul");
    static STRUCT_IF_C aBFu16ll_BFu31ll_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aBFu16ll_BFu31ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_Ul");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_Ul, aBFu16ll_BFu31ll_Ul)
//============================================================================



static void Test_aBFu16ll_BFu31ll_Us()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_Us");
    static STRUCT_IF_C aBFu16ll_BFu31ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu31ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_Us");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_Us, aBFu16ll_BFu31ll_Us)
//============================================================================



static void Test_aBFu16ll_BFu31ll_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu31ll_Vp");
    static STRUCT_IF_C aBFu16ll_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu16ll_BFu31ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu31ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu31ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "aBFu16ll_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu31ll_Vp");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu31ll_Vp, aBFu16ll_BFu31ll_Vp)
//============================================================================



static void Test_aBFu16ll_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu32i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i, aBFu16ll_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aBFu16ll_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu15i, aBFu16ll_BFu32i_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aBFu16ll_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu15ll, aBFu16ll_BFu32i_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aBFu16ll_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu15s, aBFu16ll_BFu32i_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aBFu16ll_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu16i, aBFu16ll_BFu32i_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aBFu16ll_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu16ll, aBFu16ll_BFu32i_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aBFu16ll_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu16s, aBFu16ll_BFu32i_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu16ll_BFu32i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aBFu16ll_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu17i, aBFu16ll_BFu32i_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu16ll_BFu32i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aBFu16ll_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu32i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu17ll, aBFu16ll_BFu32i_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aBFu16ll_BFu32i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu1c, aBFu16ll_BFu32i_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aBFu16ll_BFu32i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu1i, aBFu16ll_BFu32i_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aBFu16ll_BFu32i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu1ll, aBFu16ll_BFu32i_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aBFu16ll_BFu32i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu1s, aBFu16ll_BFu32i_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aBFu16ll_BFu32i_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu32i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu31i, aBFu16ll_BFu32i_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aBFu16ll_BFu32i_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu32i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu31ll, aBFu16ll_BFu32i_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aBFu16ll_BFu32i_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu32i, aBFu16ll_BFu32i_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aBFu16ll_BFu32i_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu32ll, aBFu16ll_BFu32i_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu32i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "aBFu16ll_BFu32i_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu32i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu33, aBFu16ll_BFu32i_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aBFu16ll_BFu32i_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu32i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu7c, aBFu16ll_BFu32i_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aBFu16ll_BFu32i_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu32i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu7i, aBFu16ll_BFu32i_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aBFu16ll_BFu32i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu32i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu7ll, aBFu16ll_BFu32i_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aBFu16ll_BFu32i_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu32i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu7s, aBFu16ll_BFu32i_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aBFu16ll_BFu32i_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu32i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu8c, aBFu16ll_BFu32i_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aBFu16ll_BFu32i_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu32i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu8i, aBFu16ll_BFu32i_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aBFu16ll_BFu32i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu32i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu8ll, aBFu16ll_BFu32i_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aBFu16ll_BFu32i_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu32i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu8s, aBFu16ll_BFu32i_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aBFu16ll_BFu32i_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu32i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu9i, aBFu16ll_BFu32i_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aBFu16ll_BFu32i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu32i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu9ll, aBFu16ll_BFu32i_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu32i_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu32i_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu32i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aBFu16ll_BFu32i_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu32i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_BFu9s, aBFu16ll_BFu32i_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu32i_C()
{
  {
    init_simple_test("aBFu16ll_BFu32i_C");
    static STRUCT_IF_C aBFu16ll_BFu32i_C lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_C");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_C");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_C");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_C, aBFu16ll_BFu32i_C)
//============================================================================



static void Test_aBFu16ll_BFu32i_D()
{
  {
    init_simple_test("aBFu16ll_BFu32i_D");
    static STRUCT_IF_C aBFu16ll_BFu32i_D lv;
    check2(sizeof(lv), 14, "sizeof(aBFu16ll_BFu32i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_D");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_D");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_D");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_D, aBFu16ll_BFu32i_D)
//============================================================================



static void Test_aBFu16ll_BFu32i_F()
{
  {
    init_simple_test("aBFu16ll_BFu32i_F");
    static STRUCT_IF_C aBFu16ll_BFu32i_F lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_F");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_F");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_F");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_F, aBFu16ll_BFu32i_F)
//============================================================================



static void Test_aBFu16ll_BFu32i_I()
{
  {
    init_simple_test("aBFu16ll_BFu32i_I");
    static STRUCT_IF_C aBFu16ll_BFu32i_I lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_I");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_I");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_I");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_I, aBFu16ll_BFu32i_I)
//============================================================================



static void Test_aBFu16ll_BFu32i_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu32i_Ip");
    static STRUCT_IF_C aBFu16ll_BFu32i_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu16ll_BFu32i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_Ip");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_Ip, aBFu16ll_BFu32i_Ip)
//============================================================================



static void Test_aBFu16ll_BFu32i_L()
{
  {
    init_simple_test("aBFu16ll_BFu32i_L");
    static STRUCT_IF_C aBFu16ll_BFu32i_L lv;
    check2(sizeof(lv), 14, "sizeof(aBFu16ll_BFu32i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_L");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_L");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_L");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_L, aBFu16ll_BFu32i_L)
//============================================================================



static void Test_aBFu16ll_BFu32i_S()
{
  {
    init_simple_test("aBFu16ll_BFu32i_S");
    static STRUCT_IF_C aBFu16ll_BFu32i_S lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_S");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_S");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_S");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_S, aBFu16ll_BFu32i_S)
//============================================================================



static void Test_aBFu16ll_BFu32i_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu32i_Uc");
    static STRUCT_IF_C aBFu16ll_BFu32i_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_Uc");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_Uc, aBFu16ll_BFu32i_Uc)
//============================================================================



static void Test_aBFu16ll_BFu32i_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu32i_Ui");
    static STRUCT_IF_C aBFu16ll_BFu32i_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_Ui");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_Ui, aBFu16ll_BFu32i_Ui)
//============================================================================



static void Test_aBFu16ll_BFu32i_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu32i_Ul");
    static STRUCT_IF_C aBFu16ll_BFu32i_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aBFu16ll_BFu32i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_Ul");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_Ul, aBFu16ll_BFu32i_Ul)
//============================================================================



static void Test_aBFu16ll_BFu32i_Us()
{
  {
    init_simple_test("aBFu16ll_BFu32i_Us");
    static STRUCT_IF_C aBFu16ll_BFu32i_Us lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_Us");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_Us");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_Us");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_Us, aBFu16ll_BFu32i_Us)
//============================================================================



static void Test_aBFu16ll_BFu32i_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu32i_Vp");
    static STRUCT_IF_C aBFu16ll_BFu32i_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu16ll_BFu32i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32i_Vp");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32i_Vp, aBFu16ll_BFu32i_Vp)
//============================================================================



static void Test_aBFu16ll_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu32ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll, aBFu16ll_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aBFu16ll_BFu32ll_BFu15i");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu32ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu15i, aBFu16ll_BFu32ll_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aBFu16ll_BFu32ll_BFu15ll");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu32ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu15ll, aBFu16ll_BFu32ll_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "aBFu16ll_BFu32ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu32ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu15s, aBFu16ll_BFu32ll_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aBFu16ll_BFu32ll_BFu16i");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu16i, aBFu16ll_BFu32ll_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aBFu16ll_BFu32ll_BFu16ll");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu16ll, aBFu16ll_BFu32ll_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "aBFu16ll_BFu32ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu16s, aBFu16ll_BFu32ll_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu16ll_BFu32ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aBFu16ll_BFu32ll_BFu17i");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu32ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu17i, aBFu16ll_BFu32ll_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu16ll_BFu32ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, 1, "aBFu16ll_BFu32ll_BFu17ll");
    set_bf_and_test(lv, v3, 6, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu32ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu17ll, aBFu16ll_BFu32ll_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu1c");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aBFu16ll_BFu32ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu1c, aBFu16ll_BFu32ll_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu1i");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aBFu16ll_BFu32ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu1i, aBFu16ll_BFu32ll_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu1ll");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aBFu16ll_BFu32ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu1ll, aBFu16ll_BFu32ll_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu1s");
    set_bf_and_test(lv, v3, 6, 0, 1, 1, "aBFu16ll_BFu32ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu1s, aBFu16ll_BFu32ll_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aBFu16ll_BFu32ll_BFu31i");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu32ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu31i, aBFu16ll_BFu32ll_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, 1, "aBFu16ll_BFu32ll_BFu31ll");
    set_bf_and_test(lv, v3, 6, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu32ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu31ll, aBFu16ll_BFu32ll_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu32i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aBFu16ll_BFu32ll_BFu32i");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu32i, aBFu16ll_BFu32ll_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu32ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, 1, "aBFu16ll_BFu32ll_BFu32ll");
    set_bf_and_test(lv, v3, 6, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu32ll, aBFu16ll_BFu32ll_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu32ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, 1, "aBFu16ll_BFu32ll_BFu33");
    set_bf_and_test(lv, v3, 6, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu32ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu33, aBFu16ll_BFu32ll_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aBFu16ll_BFu32ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu32ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu7c, aBFu16ll_BFu32ll_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aBFu16ll_BFu32ll_BFu7i");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu32ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu7i, aBFu16ll_BFu32ll_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aBFu16ll_BFu32ll_BFu7ll");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu32ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu7ll, aBFu16ll_BFu32ll_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "aBFu16ll_BFu32ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu32ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu7s, aBFu16ll_BFu32ll_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu8c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aBFu16ll_BFu32ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu32ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu8c, aBFu16ll_BFu32ll_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu8i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aBFu16ll_BFu32ll_BFu8i");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu32ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu8i, aBFu16ll_BFu32ll_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu8ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aBFu16ll_BFu32ll_BFu8ll");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu32ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu8ll, aBFu16ll_BFu32ll_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu8s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "aBFu16ll_BFu32ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu32ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu8s, aBFu16ll_BFu32ll_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aBFu16ll_BFu32ll_BFu9i");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu32ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu9i, aBFu16ll_BFu32ll_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aBFu16ll_BFu32ll_BFu9ll");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu32ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu9ll, aBFu16ll_BFu32ll_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu32ll_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu32ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "aBFu16ll_BFu32ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu32ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_BFu9s, aBFu16ll_BFu32ll_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu32ll_C()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_C");
    static STRUCT_IF_C aBFu16ll_BFu32ll_C lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_C");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_C");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_C");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_C, aBFu16ll_BFu32ll_C)
//============================================================================



static void Test_aBFu16ll_BFu32ll_D()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_D");
    static STRUCT_IF_C aBFu16ll_BFu32ll_D lv;
    check2(sizeof(lv), 14, "sizeof(aBFu16ll_BFu32ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_D");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_D");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_D");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_D, aBFu16ll_BFu32ll_D)
//============================================================================



static void Test_aBFu16ll_BFu32ll_F()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_F");
    static STRUCT_IF_C aBFu16ll_BFu32ll_F lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_F");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_F");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_F");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_F, aBFu16ll_BFu32ll_F)
//============================================================================



static void Test_aBFu16ll_BFu32ll_I()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_I");
    static STRUCT_IF_C aBFu16ll_BFu32ll_I lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_I");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_I");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_I");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_I, aBFu16ll_BFu32ll_I)
//============================================================================



static void Test_aBFu16ll_BFu32ll_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_Ip");
    static STRUCT_IF_C aBFu16ll_BFu32ll_Ip lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu16ll_BFu32ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_Ip");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_Ip, aBFu16ll_BFu32ll_Ip)
//============================================================================



static void Test_aBFu16ll_BFu32ll_L()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_L");
    static STRUCT_IF_C aBFu16ll_BFu32ll_L lv;
    check2(sizeof(lv), 14, "sizeof(aBFu16ll_BFu32ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_L");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_L");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_L");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_L, aBFu16ll_BFu32ll_L)
//============================================================================



static void Test_aBFu16ll_BFu32ll_S()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_S");
    static STRUCT_IF_C aBFu16ll_BFu32ll_S lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_S");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_S");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_S");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_S, aBFu16ll_BFu32ll_S)
//============================================================================



static void Test_aBFu16ll_BFu32ll_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_Uc");
    static STRUCT_IF_C aBFu16ll_BFu32ll_Uc lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu32ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_Uc");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_Uc, aBFu16ll_BFu32ll_Uc)
//============================================================================



static void Test_aBFu16ll_BFu32ll_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_Ui");
    static STRUCT_IF_C aBFu16ll_BFu32ll_Ui lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu32ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_Ui");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_Ui, aBFu16ll_BFu32ll_Ui)
//============================================================================



static void Test_aBFu16ll_BFu32ll_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_Ul");
    static STRUCT_IF_C aBFu16ll_BFu32ll_Ul lv;
    check2(sizeof(lv), 14, "sizeof(aBFu16ll_BFu32ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_Ul");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_Ul, aBFu16ll_BFu32ll_Ul)
//============================================================================



static void Test_aBFu16ll_BFu32ll_Us()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_Us");
    static STRUCT_IF_C aBFu16ll_BFu32ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu32ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_Us");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_Us, aBFu16ll_BFu32ll_Us)
//============================================================================



static void Test_aBFu16ll_BFu32ll_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu32ll_Vp");
    static STRUCT_IF_C aBFu16ll_BFu32ll_Vp lv;
    check2(sizeof(lv), ABISELECT(14,10), "sizeof(aBFu16ll_BFu32ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu32ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu32ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 32, 1, "aBFu16ll_BFu32ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu32ll_Vp");
    check_field_offset(lv, v3, 6, "aBFu16ll_BFu32ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu32ll_Vp, aBFu16ll_BFu32ll_Vp)
//============================================================================



static void Test_aBFu16ll_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33, aBFu16ll_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu33_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "aBFu16ll_BFu33_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu33_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu15i, aBFu16ll_BFu33_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu33_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "aBFu16ll_BFu33_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu33_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu15ll, aBFu16ll_BFu33_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu33_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "aBFu16ll_BFu33_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu33_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu15s, aBFu16ll_BFu33_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu16i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu16ll_BFu33_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "aBFu16ll_BFu33_BFu16i");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu16i, aBFu16ll_BFu33_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu16ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu16ll_BFu33_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "aBFu16ll_BFu33_BFu16ll");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu16ll, aBFu16ll_BFu33_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu16s lv;
    check2(sizeof(lv), 9, "sizeof(aBFu16ll_BFu33_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 6, 1, 16, 1, "aBFu16ll_BFu33_BFu16s");
    set_bf_and_test(lv, v3, 6, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu16s, aBFu16ll_BFu33_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu17i lv;
    check2(sizeof(lv), 9, "sizeof(aBFu16ll_BFu33_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 6, 1, 17, 1, "aBFu16ll_BFu33_BFu17i");
    set_bf_and_test(lv, v3, 6, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu33_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu17i, aBFu16ll_BFu33_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu17ll lv;
    check2(sizeof(lv), 9, "sizeof(aBFu16ll_BFu33_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 6, 1, 17, 1, "aBFu16ll_BFu33_BFu17ll");
    set_bf_and_test(lv, v3, 6, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu33_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu17ll, aBFu16ll_BFu33_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu1c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu33_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu1c");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aBFu16ll_BFu33_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu1c, aBFu16ll_BFu33_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu1i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu33_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu1i");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aBFu16ll_BFu33_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu1i, aBFu16ll_BFu33_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu1ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu33_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu1ll");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aBFu16ll_BFu33_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu1ll, aBFu16ll_BFu33_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu1s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu33_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu1s");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "aBFu16ll_BFu33_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu1s, aBFu16ll_BFu33_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu31i lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu33_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 6, 1, 31, 1, "aBFu16ll_BFu33_BFu31i");
    set_bf_and_test(lv, v3, 6, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu33_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu31i, aBFu16ll_BFu33_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu31ll lv;
    check2(sizeof(lv), 10, "sizeof(aBFu16ll_BFu33_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 6, 1, 31, 1, "aBFu16ll_BFu33_BFu31ll");
    set_bf_and_test(lv, v3, 6, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu33_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu31ll, aBFu16ll_BFu33_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu32i lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu33_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 6, 1, 32, 1, "aBFu16ll_BFu33_BFu32i");
    set_bf_and_test(lv, v3, 6, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu33_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu32i, aBFu16ll_BFu33_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu32ll lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu33_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 6, 1, 32, 1, "aBFu16ll_BFu33_BFu32ll");
    set_bf_and_test(lv, v3, 6, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu33_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu32ll, aBFu16ll_BFu33_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu33 lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu33_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu33");
    set_bf_and_test(lv, v3, 6, 1, 33, 1, "aBFu16ll_BFu33_BFu33");
    set_bf_and_test(lv, v3, 6, 1, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu33, aBFu16ll_BFu33_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu7c lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu33_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aBFu16ll_BFu33_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu33_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu7c, aBFu16ll_BFu33_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu7i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu33_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aBFu16ll_BFu33_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu33_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu7i, aBFu16ll_BFu33_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu7ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu33_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aBFu16ll_BFu33_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu33_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu7ll, aBFu16ll_BFu33_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu7s lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu33_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "aBFu16ll_BFu33_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu33_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu7s, aBFu16ll_BFu33_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu33_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aBFu16ll_BFu33_BFu8c");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu33_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu8c, aBFu16ll_BFu33_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu33_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aBFu16ll_BFu33_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu33_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu8i, aBFu16ll_BFu33_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu33_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aBFu16ll_BFu33_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu33_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu8ll, aBFu16ll_BFu33_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu33_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "aBFu16ll_BFu33_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu33_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu8s, aBFu16ll_BFu33_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu33_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "aBFu16ll_BFu33_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu33_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu9i, aBFu16ll_BFu33_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu33_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "aBFu16ll_BFu33_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu33_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu9ll, aBFu16ll_BFu33_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu33_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu33_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu33_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu33_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "aBFu16ll_BFu33_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu33_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_BFu9s, aBFu16ll_BFu33_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu33_C()
{
  {
    init_simple_test("aBFu16ll_BFu33_C");
    static STRUCT_IF_C aBFu16ll_BFu33_C lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu33_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_C");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_C");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_C");
    check_field_offset(lv, v3, 7, "aBFu16ll_BFu33_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_C, aBFu16ll_BFu33_C)
//============================================================================



static void Test_aBFu16ll_BFu33_D()
{
  {
    init_simple_test("aBFu16ll_BFu33_D");
    static STRUCT_IF_C aBFu16ll_BFu33_D lv;
    check2(sizeof(lv), 15, "sizeof(aBFu16ll_BFu33_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_D");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_D");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_D");
    check_field_offset(lv, v3, 7, "aBFu16ll_BFu33_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_D, aBFu16ll_BFu33_D)
//============================================================================



static void Test_aBFu16ll_BFu33_F()
{
  {
    init_simple_test("aBFu16ll_BFu33_F");
    static STRUCT_IF_C aBFu16ll_BFu33_F lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu33_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_F");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_F");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_F");
    check_field_offset(lv, v3, 7, "aBFu16ll_BFu33_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_F, aBFu16ll_BFu33_F)
//============================================================================



static void Test_aBFu16ll_BFu33_I()
{
  {
    init_simple_test("aBFu16ll_BFu33_I");
    static STRUCT_IF_C aBFu16ll_BFu33_I lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu33_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_I");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_I");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_I");
    check_field_offset(lv, v3, 7, "aBFu16ll_BFu33_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_I, aBFu16ll_BFu33_I)
//============================================================================



static void Test_aBFu16ll_BFu33_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu33_Ip");
    static STRUCT_IF_C aBFu16ll_BFu33_Ip lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aBFu16ll_BFu33_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_Ip");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_Ip");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_Ip");
    check_field_offset(lv, v3, 7, "aBFu16ll_BFu33_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_Ip, aBFu16ll_BFu33_Ip)
//============================================================================



static void Test_aBFu16ll_BFu33_L()
{
  {
    init_simple_test("aBFu16ll_BFu33_L");
    static STRUCT_IF_C aBFu16ll_BFu33_L lv;
    check2(sizeof(lv), 15, "sizeof(aBFu16ll_BFu33_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_L");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_L");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_L");
    check_field_offset(lv, v3, 7, "aBFu16ll_BFu33_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_L, aBFu16ll_BFu33_L)
//============================================================================



static void Test_aBFu16ll_BFu33_S()
{
  {
    init_simple_test("aBFu16ll_BFu33_S");
    static STRUCT_IF_C aBFu16ll_BFu33_S lv;
    check2(sizeof(lv), 9, "sizeof(aBFu16ll_BFu33_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_S");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_S");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_S");
    check_field_offset(lv, v3, 7, "aBFu16ll_BFu33_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_S, aBFu16ll_BFu33_S)
//============================================================================



static void Test_aBFu16ll_BFu33_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu33_Uc");
    static STRUCT_IF_C aBFu16ll_BFu33_Uc lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu33_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_Uc");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_Uc");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_Uc");
    check_field_offset(lv, v3, 7, "aBFu16ll_BFu33_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_Uc, aBFu16ll_BFu33_Uc)
//============================================================================



static void Test_aBFu16ll_BFu33_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu33_Ui");
    static STRUCT_IF_C aBFu16ll_BFu33_Ui lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu33_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_Ui");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_Ui");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_Ui");
    check_field_offset(lv, v3, 7, "aBFu16ll_BFu33_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_Ui, aBFu16ll_BFu33_Ui)
//============================================================================



static void Test_aBFu16ll_BFu33_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu33_Ul");
    static STRUCT_IF_C aBFu16ll_BFu33_Ul lv;
    check2(sizeof(lv), 15, "sizeof(aBFu16ll_BFu33_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_Ul");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_Ul");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_Ul");
    check_field_offset(lv, v3, 7, "aBFu16ll_BFu33_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_Ul, aBFu16ll_BFu33_Ul)
//============================================================================



static void Test_aBFu16ll_BFu33_Us()
{
  {
    init_simple_test("aBFu16ll_BFu33_Us");
    static STRUCT_IF_C aBFu16ll_BFu33_Us lv;
    check2(sizeof(lv), 9, "sizeof(aBFu16ll_BFu33_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_Us");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_Us");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_Us");
    check_field_offset(lv, v3, 7, "aBFu16ll_BFu33_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_Us, aBFu16ll_BFu33_Us)
//============================================================================



static void Test_aBFu16ll_BFu33_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu33_Vp");
    static STRUCT_IF_C aBFu16ll_BFu33_Vp lv;
    check2(sizeof(lv), ABISELECT(15,11), "sizeof(aBFu16ll_BFu33_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu33_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu33_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu33_Vp");
    set_bf_and_test(lv, v2, 2, 0, 33, 1, "aBFu16ll_BFu33_Vp");
    set_bf_and_test(lv, v2, 2, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu33_Vp");
    check_field_offset(lv, v3, 7, "aBFu16ll_BFu33_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu33_Vp, aBFu16ll_BFu33_Vp)
//============================================================================



static void Test_aBFu16ll_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu7c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c, aBFu16ll_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu16ll_BFu7c_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu7c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu15i, aBFu16ll_BFu7c_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu16ll_BFu7c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu7c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu15ll, aBFu16ll_BFu7c_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu16ll_BFu7c_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu7c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu15s, aBFu16ll_BFu7c_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu16ll_BFu7c_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu16i, aBFu16ll_BFu7c_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu16ll_BFu7c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu16ll, aBFu16ll_BFu7c_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu16ll_BFu7c_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu16s, aBFu16ll_BFu7c_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aBFu16ll_BFu7c_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aBFu16ll_BFu7c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu17i, aBFu16ll_BFu7c_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aBFu16ll_BFu7c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aBFu16ll_BFu7c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu17ll, aBFu16ll_BFu7c_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu1c, aBFu16ll_BFu7c_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu1i, aBFu16ll_BFu7c_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu1ll, aBFu16ll_BFu7c_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu1s, aBFu16ll_BFu7c_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aBFu16ll_BFu7c_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aBFu16ll_BFu7c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu31i, aBFu16ll_BFu7c_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aBFu16ll_BFu7c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aBFu16ll_BFu7c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu31ll, aBFu16ll_BFu7c_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aBFu16ll_BFu7c_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aBFu16ll_BFu7c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu32i, aBFu16ll_BFu7c_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aBFu16ll_BFu7c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aBFu16ll_BFu7c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu32ll, aBFu16ll_BFu7c_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "aBFu16ll_BFu7c_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "aBFu16ll_BFu7c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu33, aBFu16ll_BFu7c_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7c_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu7c, aBFu16ll_BFu7c_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7c_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu7i, aBFu16ll_BFu7c_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu7ll, aBFu16ll_BFu7c_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7c_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu7s, aBFu16ll_BFu7c_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7c_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu8c, aBFu16ll_BFu7c_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7c_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu8i, aBFu16ll_BFu7c_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu8ll, aBFu16ll_BFu7c_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7c_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu8s, aBFu16ll_BFu7c_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu16ll_BFu7c_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu7c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu9i, aBFu16ll_BFu7c_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu16ll_BFu7c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu7c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu9ll, aBFu16ll_BFu7c_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu7c_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu7c_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu7c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu16ll_BFu7c_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu7c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_BFu9s, aBFu16ll_BFu7c_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu7c_C()
{
  {
    init_simple_test("aBFu16ll_BFu7c_C");
    static STRUCT_IF_C aBFu16ll_BFu7c_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_C");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_C");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_C, aBFu16ll_BFu7c_C)
//============================================================================



static void Test_aBFu16ll_BFu7c_D()
{
  {
    init_simple_test("aBFu16ll_BFu7c_D");
    static STRUCT_IF_C aBFu16ll_BFu7c_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu7c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_D");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_D");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_D, aBFu16ll_BFu7c_D)
//============================================================================



static void Test_aBFu16ll_BFu7c_F()
{
  {
    init_simple_test("aBFu16ll_BFu7c_F");
    static STRUCT_IF_C aBFu16ll_BFu7c_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_F");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_F");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_F, aBFu16ll_BFu7c_F)
//============================================================================



static void Test_aBFu16ll_BFu7c_I()
{
  {
    init_simple_test("aBFu16ll_BFu7c_I");
    static STRUCT_IF_C aBFu16ll_BFu7c_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_I");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_I");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_I, aBFu16ll_BFu7c_I)
//============================================================================



static void Test_aBFu16ll_BFu7c_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu7c_Ip");
    static STRUCT_IF_C aBFu16ll_BFu7c_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu7c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_Ip");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_Ip, aBFu16ll_BFu7c_Ip)
//============================================================================



static void Test_aBFu16ll_BFu7c_L()
{
  {
    init_simple_test("aBFu16ll_BFu7c_L");
    static STRUCT_IF_C aBFu16ll_BFu7c_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu7c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_L");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_L");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_L, aBFu16ll_BFu7c_L)
//============================================================================



static void Test_aBFu16ll_BFu7c_S()
{
  {
    init_simple_test("aBFu16ll_BFu7c_S");
    static STRUCT_IF_C aBFu16ll_BFu7c_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_S");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_S");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_S, aBFu16ll_BFu7c_S)
//============================================================================



static void Test_aBFu16ll_BFu7c_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu7c_Uc");
    static STRUCT_IF_C aBFu16ll_BFu7c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_Uc");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_Uc, aBFu16ll_BFu7c_Uc)
//============================================================================



static void Test_aBFu16ll_BFu7c_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu7c_Ui");
    static STRUCT_IF_C aBFu16ll_BFu7c_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_Ui");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_Ui, aBFu16ll_BFu7c_Ui)
//============================================================================



static void Test_aBFu16ll_BFu7c_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu7c_Ul");
    static STRUCT_IF_C aBFu16ll_BFu7c_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu7c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_Ul");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_Ul, aBFu16ll_BFu7c_Ul)
//============================================================================



static void Test_aBFu16ll_BFu7c_Us()
{
  {
    init_simple_test("aBFu16ll_BFu7c_Us");
    static STRUCT_IF_C aBFu16ll_BFu7c_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_Us");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_Us, aBFu16ll_BFu7c_Us)
//============================================================================



static void Test_aBFu16ll_BFu7c_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu7c_Vp");
    static STRUCT_IF_C aBFu16ll_BFu7c_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu7c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7c_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7c_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7c_Vp");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7c_Vp, aBFu16ll_BFu7c_Vp)
//============================================================================



static void Test_aBFu16ll_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu7i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i, aBFu16ll_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu16ll_BFu7i_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu7i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu15i, aBFu16ll_BFu7i_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu16ll_BFu7i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu7i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu15ll, aBFu16ll_BFu7i_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu16ll_BFu7i_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu7i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu15s, aBFu16ll_BFu7i_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu16ll_BFu7i_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu16i, aBFu16ll_BFu7i_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu16ll_BFu7i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu16ll, aBFu16ll_BFu7i_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu16ll_BFu7i_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu16s, aBFu16ll_BFu7i_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aBFu16ll_BFu7i_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aBFu16ll_BFu7i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu17i, aBFu16ll_BFu7i_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aBFu16ll_BFu7i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aBFu16ll_BFu7i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu17ll, aBFu16ll_BFu7i_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu1c, aBFu16ll_BFu7i_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu1i, aBFu16ll_BFu7i_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu1ll, aBFu16ll_BFu7i_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu1s, aBFu16ll_BFu7i_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aBFu16ll_BFu7i_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aBFu16ll_BFu7i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu31i, aBFu16ll_BFu7i_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aBFu16ll_BFu7i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aBFu16ll_BFu7i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu31ll, aBFu16ll_BFu7i_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aBFu16ll_BFu7i_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aBFu16ll_BFu7i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu32i, aBFu16ll_BFu7i_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aBFu16ll_BFu7i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aBFu16ll_BFu7i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu32ll, aBFu16ll_BFu7i_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "aBFu16ll_BFu7i_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "aBFu16ll_BFu7i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu33, aBFu16ll_BFu7i_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7i_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu7c, aBFu16ll_BFu7i_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7i_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu7i, aBFu16ll_BFu7i_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu7ll, aBFu16ll_BFu7i_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7i_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu7s, aBFu16ll_BFu7i_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7i_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu8c, aBFu16ll_BFu7i_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7i_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu8i, aBFu16ll_BFu7i_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu8ll, aBFu16ll_BFu7i_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7i_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu8s, aBFu16ll_BFu7i_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu16ll_BFu7i_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu7i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu9i, aBFu16ll_BFu7i_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu16ll_BFu7i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu7i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu9ll, aBFu16ll_BFu7i_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu7i_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu7i_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu7i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu16ll_BFu7i_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu7i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_BFu9s, aBFu16ll_BFu7i_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu7i_C()
{
  {
    init_simple_test("aBFu16ll_BFu7i_C");
    static STRUCT_IF_C aBFu16ll_BFu7i_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_C");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_C");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_C, aBFu16ll_BFu7i_C)
//============================================================================



static void Test_aBFu16ll_BFu7i_D()
{
  {
    init_simple_test("aBFu16ll_BFu7i_D");
    static STRUCT_IF_C aBFu16ll_BFu7i_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu7i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_D");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_D");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_D, aBFu16ll_BFu7i_D)
//============================================================================



static void Test_aBFu16ll_BFu7i_F()
{
  {
    init_simple_test("aBFu16ll_BFu7i_F");
    static STRUCT_IF_C aBFu16ll_BFu7i_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_F");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_F");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_F, aBFu16ll_BFu7i_F)
//============================================================================



static void Test_aBFu16ll_BFu7i_I()
{
  {
    init_simple_test("aBFu16ll_BFu7i_I");
    static STRUCT_IF_C aBFu16ll_BFu7i_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_I");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_I");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_I, aBFu16ll_BFu7i_I)
//============================================================================



static void Test_aBFu16ll_BFu7i_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu7i_Ip");
    static STRUCT_IF_C aBFu16ll_BFu7i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu7i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_Ip");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_Ip, aBFu16ll_BFu7i_Ip)
//============================================================================



static void Test_aBFu16ll_BFu7i_L()
{
  {
    init_simple_test("aBFu16ll_BFu7i_L");
    static STRUCT_IF_C aBFu16ll_BFu7i_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu7i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_L");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_L");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_L, aBFu16ll_BFu7i_L)
//============================================================================



static void Test_aBFu16ll_BFu7i_S()
{
  {
    init_simple_test("aBFu16ll_BFu7i_S");
    static STRUCT_IF_C aBFu16ll_BFu7i_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_S");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_S");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_S, aBFu16ll_BFu7i_S)
//============================================================================



static void Test_aBFu16ll_BFu7i_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu7i_Uc");
    static STRUCT_IF_C aBFu16ll_BFu7i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_Uc");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_Uc, aBFu16ll_BFu7i_Uc)
//============================================================================



static void Test_aBFu16ll_BFu7i_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu7i_Ui");
    static STRUCT_IF_C aBFu16ll_BFu7i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_Ui");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_Ui, aBFu16ll_BFu7i_Ui)
//============================================================================



static void Test_aBFu16ll_BFu7i_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu7i_Ul");
    static STRUCT_IF_C aBFu16ll_BFu7i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu7i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_Ul");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_Ul, aBFu16ll_BFu7i_Ul)
//============================================================================



static void Test_aBFu16ll_BFu7i_Us()
{
  {
    init_simple_test("aBFu16ll_BFu7i_Us");
    static STRUCT_IF_C aBFu16ll_BFu7i_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_Us");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_Us, aBFu16ll_BFu7i_Us)
//============================================================================



static void Test_aBFu16ll_BFu7i_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu7i_Vp");
    static STRUCT_IF_C aBFu16ll_BFu7i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu7i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7i_Vp");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7i_Vp, aBFu16ll_BFu7i_Vp)
//============================================================================



static void Test_aBFu16ll_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu7ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll, aBFu16ll_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu16ll_BFu7ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu7ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu15i, aBFu16ll_BFu7ll_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu16ll_BFu7ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu7ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu15ll, aBFu16ll_BFu7ll_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu16ll_BFu7ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu7ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu15s, aBFu16ll_BFu7ll_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu16ll_BFu7ll_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu16i, aBFu16ll_BFu7ll_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu16ll_BFu7ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu16ll, aBFu16ll_BFu7ll_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu16ll_BFu7ll_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu16s, aBFu16ll_BFu7ll_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aBFu16ll_BFu7ll_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aBFu16ll_BFu7ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu17i, aBFu16ll_BFu7ll_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aBFu16ll_BFu7ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aBFu16ll_BFu7ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu17ll, aBFu16ll_BFu7ll_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu1c, aBFu16ll_BFu7ll_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu1i, aBFu16ll_BFu7ll_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu1ll, aBFu16ll_BFu7ll_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu1s, aBFu16ll_BFu7ll_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aBFu16ll_BFu7ll_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aBFu16ll_BFu7ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu31i, aBFu16ll_BFu7ll_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aBFu16ll_BFu7ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aBFu16ll_BFu7ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu31ll, aBFu16ll_BFu7ll_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aBFu16ll_BFu7ll_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aBFu16ll_BFu7ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu32i, aBFu16ll_BFu7ll_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aBFu16ll_BFu7ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aBFu16ll_BFu7ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu32ll, aBFu16ll_BFu7ll_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "aBFu16ll_BFu7ll_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "aBFu16ll_BFu7ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu33, aBFu16ll_BFu7ll_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu7c, aBFu16ll_BFu7ll_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu7i, aBFu16ll_BFu7ll_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu7ll, aBFu16ll_BFu7ll_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu7s, aBFu16ll_BFu7ll_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7ll_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu8c, aBFu16ll_BFu7ll_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu8i, aBFu16ll_BFu7ll_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu8ll, aBFu16ll_BFu7ll_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu8s, aBFu16ll_BFu7ll_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu16ll_BFu7ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu7ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu9i, aBFu16ll_BFu7ll_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu16ll_BFu7ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu7ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu9ll, aBFu16ll_BFu7ll_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu7ll_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu7ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu16ll_BFu7ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu7ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_BFu9s, aBFu16ll_BFu7ll_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu7ll_C()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_C");
    static STRUCT_IF_C aBFu16ll_BFu7ll_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_C");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_C");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_C, aBFu16ll_BFu7ll_C)
//============================================================================



static void Test_aBFu16ll_BFu7ll_D()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_D");
    static STRUCT_IF_C aBFu16ll_BFu7ll_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu7ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_D");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_D");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_D, aBFu16ll_BFu7ll_D)
//============================================================================



static void Test_aBFu16ll_BFu7ll_F()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_F");
    static STRUCT_IF_C aBFu16ll_BFu7ll_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_F");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_F");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_F, aBFu16ll_BFu7ll_F)
//============================================================================



static void Test_aBFu16ll_BFu7ll_I()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_I");
    static STRUCT_IF_C aBFu16ll_BFu7ll_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_I");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_I");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_I, aBFu16ll_BFu7ll_I)
//============================================================================



static void Test_aBFu16ll_BFu7ll_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_Ip");
    static STRUCT_IF_C aBFu16ll_BFu7ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu7ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_Ip");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_Ip, aBFu16ll_BFu7ll_Ip)
//============================================================================



static void Test_aBFu16ll_BFu7ll_L()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_L");
    static STRUCT_IF_C aBFu16ll_BFu7ll_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu7ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_L");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_L");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_L, aBFu16ll_BFu7ll_L)
//============================================================================



static void Test_aBFu16ll_BFu7ll_S()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_S");
    static STRUCT_IF_C aBFu16ll_BFu7ll_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_S");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_S");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_S, aBFu16ll_BFu7ll_S)
//============================================================================



static void Test_aBFu16ll_BFu7ll_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_Uc");
    static STRUCT_IF_C aBFu16ll_BFu7ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_Uc");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_Uc, aBFu16ll_BFu7ll_Uc)
//============================================================================



static void Test_aBFu16ll_BFu7ll_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_Ui");
    static STRUCT_IF_C aBFu16ll_BFu7ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_Ui");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_Ui, aBFu16ll_BFu7ll_Ui)
//============================================================================



static void Test_aBFu16ll_BFu7ll_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_Ul");
    static STRUCT_IF_C aBFu16ll_BFu7ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu7ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_Ul");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_Ul, aBFu16ll_BFu7ll_Ul)
//============================================================================



static void Test_aBFu16ll_BFu7ll_Us()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_Us");
    static STRUCT_IF_C aBFu16ll_BFu7ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_Us");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_Us, aBFu16ll_BFu7ll_Us)
//============================================================================



static void Test_aBFu16ll_BFu7ll_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu7ll_Vp");
    static STRUCT_IF_C aBFu16ll_BFu7ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu7ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7ll_Vp");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7ll_Vp, aBFu16ll_BFu7ll_Vp)
//============================================================================



static void Test_aBFu16ll_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu7s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s, aBFu16ll_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu16ll_BFu7s_BFu15i");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu7s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu15i, aBFu16ll_BFu7s_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu16ll_BFu7s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu7s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu15ll, aBFu16ll_BFu7s_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, 1, "aBFu16ll_BFu7s_BFu15s");
    set_bf_and_test(lv, v3, 2, 7, 15, hide_ull(1LL<<14), "aBFu16ll_BFu7s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu15s, aBFu16ll_BFu7s_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu16ll_BFu7s_BFu16i");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu16i, aBFu16ll_BFu7s_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu16ll_BFu7s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu16ll, aBFu16ll_BFu7s_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, 1, "aBFu16ll_BFu7s_BFu16s");
    set_bf_and_test(lv, v3, 2, 7, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu16s, aBFu16ll_BFu7s_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu17i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aBFu16ll_BFu7s_BFu17i");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aBFu16ll_BFu7s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu17i, aBFu16ll_BFu7s_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu17ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, 1, "aBFu16ll_BFu7s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 7, 17, hide_ull(1LL<<16), "aBFu16ll_BFu7s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu17ll, aBFu16ll_BFu7s_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu1c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu1c");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu1c, aBFu16ll_BFu7s_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu1i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu1i");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu1i, aBFu16ll_BFu7s_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu1ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu1ll, aBFu16ll_BFu7s_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu1s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu7s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu1s");
    set_bf_and_test(lv, v3, 2, 7, 1, 1, "aBFu16ll_BFu7s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu1s, aBFu16ll_BFu7s_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aBFu16ll_BFu7s_BFu31i");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aBFu16ll_BFu7s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu31i, aBFu16ll_BFu7s_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, 1, "aBFu16ll_BFu7s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 7, 31, hide_ull(1LL<<30), "aBFu16ll_BFu7s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu31ll, aBFu16ll_BFu7s_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aBFu16ll_BFu7s_BFu32i");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aBFu16ll_BFu7s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu32i, aBFu16ll_BFu7s_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, 1, "aBFu16ll_BFu7s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 7, 32, hide_ull(1LL<<31), "aBFu16ll_BFu7s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu32ll, aBFu16ll_BFu7s_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu33 lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, 1, "aBFu16ll_BFu7s_BFu33");
    set_bf_and_test(lv, v3, 2, 7, 33, hide_ull(1LL<<32), "aBFu16ll_BFu7s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu33, aBFu16ll_BFu7s_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7s_BFu7c");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu7c, aBFu16ll_BFu7s_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7s_BFu7i");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu7i, aBFu16ll_BFu7s_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu7ll, aBFu16ll_BFu7s_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, 1, "aBFu16ll_BFu7s_BFu7s");
    set_bf_and_test(lv, v3, 2, 7, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu7s, aBFu16ll_BFu7s_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7s_BFu8c");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu8c, aBFu16ll_BFu7s_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7s_BFu8i");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu8i, aBFu16ll_BFu7s_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu8ll, aBFu16ll_BFu7s_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, 1, "aBFu16ll_BFu7s_BFu8s");
    set_bf_and_test(lv, v3, 2, 7, 8, hide_ull(1LL<<7), "aBFu16ll_BFu7s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu8s, aBFu16ll_BFu7s_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu16ll_BFu7s_BFu9i");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu7s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu9i, aBFu16ll_BFu7s_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu16ll_BFu7s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu7s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu9ll, aBFu16ll_BFu7s_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu7s_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu7s_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu7s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, 1, "aBFu16ll_BFu7s_BFu9s");
    set_bf_and_test(lv, v3, 2, 7, 9, hide_ull(1LL<<8), "aBFu16ll_BFu7s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_BFu9s, aBFu16ll_BFu7s_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu7s_C()
{
  {
    init_simple_test("aBFu16ll_BFu7s_C");
    static STRUCT_IF_C aBFu16ll_BFu7s_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_C");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_C");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_C");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_C, aBFu16ll_BFu7s_C)
//============================================================================



static void Test_aBFu16ll_BFu7s_D()
{
  {
    init_simple_test("aBFu16ll_BFu7s_D");
    static STRUCT_IF_C aBFu16ll_BFu7s_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu7s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_D");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_D");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_D");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_D, aBFu16ll_BFu7s_D)
//============================================================================



static void Test_aBFu16ll_BFu7s_F()
{
  {
    init_simple_test("aBFu16ll_BFu7s_F");
    static STRUCT_IF_C aBFu16ll_BFu7s_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_F");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_F");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_F");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_F, aBFu16ll_BFu7s_F)
//============================================================================



static void Test_aBFu16ll_BFu7s_I()
{
  {
    init_simple_test("aBFu16ll_BFu7s_I");
    static STRUCT_IF_C aBFu16ll_BFu7s_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_I");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_I");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_I");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_I, aBFu16ll_BFu7s_I)
//============================================================================



static void Test_aBFu16ll_BFu7s_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu7s_Ip");
    static STRUCT_IF_C aBFu16ll_BFu7s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu7s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_Ip");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_Ip, aBFu16ll_BFu7s_Ip)
//============================================================================



static void Test_aBFu16ll_BFu7s_L()
{
  {
    init_simple_test("aBFu16ll_BFu7s_L");
    static STRUCT_IF_C aBFu16ll_BFu7s_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu7s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_L");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_L");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_L");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_L, aBFu16ll_BFu7s_L)
//============================================================================



static void Test_aBFu16ll_BFu7s_S()
{
  {
    init_simple_test("aBFu16ll_BFu7s_S");
    static STRUCT_IF_C aBFu16ll_BFu7s_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_S");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_S");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_S");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_S, aBFu16ll_BFu7s_S)
//============================================================================



static void Test_aBFu16ll_BFu7s_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu7s_Uc");
    static STRUCT_IF_C aBFu16ll_BFu7s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu7s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_Uc");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_Uc, aBFu16ll_BFu7s_Uc)
//============================================================================



static void Test_aBFu16ll_BFu7s_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu7s_Ui");
    static STRUCT_IF_C aBFu16ll_BFu7s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu7s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_Ui");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_Ui, aBFu16ll_BFu7s_Ui)
//============================================================================



static void Test_aBFu16ll_BFu7s_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu7s_Ul");
    static STRUCT_IF_C aBFu16ll_BFu7s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu7s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_Ul");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_Ul, aBFu16ll_BFu7s_Ul)
//============================================================================



static void Test_aBFu16ll_BFu7s_Us()
{
  {
    init_simple_test("aBFu16ll_BFu7s_Us");
    static STRUCT_IF_C aBFu16ll_BFu7s_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu7s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_Us");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_Us");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_Us, aBFu16ll_BFu7s_Us)
//============================================================================



static void Test_aBFu16ll_BFu7s_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu7s_Vp");
    static STRUCT_IF_C aBFu16ll_BFu7s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu7s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu7s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu7s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu7s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, 1, "aBFu16ll_BFu7s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu7s_Vp");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu7s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu7s_Vp, aBFu16ll_BFu7s_Vp)
//============================================================================



static void Test_aBFu16ll_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu8c lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c, aBFu16ll_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8c_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu16ll_BFu8c_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu8c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu15i, aBFu16ll_BFu8c_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8c_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu16ll_BFu8c_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu8c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu15ll, aBFu16ll_BFu8c_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8c_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu16ll_BFu8c_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu8c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu15s, aBFu16ll_BFu8c_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8c_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu16ll_BFu8c_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu16i, aBFu16ll_BFu8c_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8c_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu16ll_BFu8c_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu16ll, aBFu16ll_BFu8c_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8c_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu16ll_BFu8c_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu16s, aBFu16ll_BFu8c_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu8c_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu16ll_BFu8c_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu8c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu17i, aBFu16ll_BFu8c_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu8c_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu16ll_BFu8c_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu8c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu17ll, aBFu16ll_BFu8c_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu1c, aBFu16ll_BFu8c_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu1i, aBFu16ll_BFu8c_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu1ll, aBFu16ll_BFu8c_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu1s, aBFu16ll_BFu8c_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8c_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu16ll_BFu8c_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu8c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu31i, aBFu16ll_BFu8c_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8c_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu16ll_BFu8c_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu8c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu31ll, aBFu16ll_BFu8c_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8c_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu16ll_BFu8c_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu8c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu32i, aBFu16ll_BFu8c_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8c_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu16ll_BFu8c_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu8c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu32ll, aBFu16ll_BFu8c_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu8c_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aBFu16ll_BFu8c_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu8c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu33, aBFu16ll_BFu8c_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8c_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu7c, aBFu16ll_BFu8c_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8c_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu7i, aBFu16ll_BFu8c_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8c_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu7ll, aBFu16ll_BFu8c_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8c_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu7s, aBFu16ll_BFu8c_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu8c, aBFu16ll_BFu8c_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8c_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu8i, aBFu16ll_BFu8c_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8c_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu8ll, aBFu16ll_BFu8c_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8c_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu8s, aBFu16ll_BFu8c_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8c_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu16ll_BFu8c_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu8c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu9i, aBFu16ll_BFu8c_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8c_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu16ll_BFu8c_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu8c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu9ll, aBFu16ll_BFu8c_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu8c_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu8c_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu8c_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8c_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu16ll_BFu8c_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu8c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_BFu9s, aBFu16ll_BFu8c_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu8c_C()
{
  {
    init_simple_test("aBFu16ll_BFu8c_C");
    static STRUCT_IF_C aBFu16ll_BFu8c_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_C");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_C");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_C");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_C, aBFu16ll_BFu8c_C)
//============================================================================



static void Test_aBFu16ll_BFu8c_D()
{
  {
    init_simple_test("aBFu16ll_BFu8c_D");
    static STRUCT_IF_C aBFu16ll_BFu8c_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu8c_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_D");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_D");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_D");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_D, aBFu16ll_BFu8c_D)
//============================================================================



static void Test_aBFu16ll_BFu8c_F()
{
  {
    init_simple_test("aBFu16ll_BFu8c_F");
    static STRUCT_IF_C aBFu16ll_BFu8c_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8c_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_F");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_F");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_F");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_F, aBFu16ll_BFu8c_F)
//============================================================================



static void Test_aBFu16ll_BFu8c_I()
{
  {
    init_simple_test("aBFu16ll_BFu8c_I");
    static STRUCT_IF_C aBFu16ll_BFu8c_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8c_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_I");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_I");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_I");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_I, aBFu16ll_BFu8c_I)
//============================================================================



static void Test_aBFu16ll_BFu8c_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu8c_Ip");
    static STRUCT_IF_C aBFu16ll_BFu8c_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu8c_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_Ip");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_Ip, aBFu16ll_BFu8c_Ip)
//============================================================================



static void Test_aBFu16ll_BFu8c_L()
{
  {
    init_simple_test("aBFu16ll_BFu8c_L");
    static STRUCT_IF_C aBFu16ll_BFu8c_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu8c_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_L");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_L");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_L");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_L, aBFu16ll_BFu8c_L)
//============================================================================



static void Test_aBFu16ll_BFu8c_S()
{
  {
    init_simple_test("aBFu16ll_BFu8c_S");
    static STRUCT_IF_C aBFu16ll_BFu8c_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8c_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_S");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_S");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_S");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_S, aBFu16ll_BFu8c_S)
//============================================================================



static void Test_aBFu16ll_BFu8c_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu8c_Uc");
    static STRUCT_IF_C aBFu16ll_BFu8c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8c_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_Uc");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_Uc, aBFu16ll_BFu8c_Uc)
//============================================================================



static void Test_aBFu16ll_BFu8c_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu8c_Ui");
    static STRUCT_IF_C aBFu16ll_BFu8c_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8c_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_Ui");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_Ui, aBFu16ll_BFu8c_Ui)
//============================================================================



static void Test_aBFu16ll_BFu8c_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu8c_Ul");
    static STRUCT_IF_C aBFu16ll_BFu8c_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu8c_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_Ul");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_Ul, aBFu16ll_BFu8c_Ul)
//============================================================================



static void Test_aBFu16ll_BFu8c_Us()
{
  {
    init_simple_test("aBFu16ll_BFu8c_Us");
    static STRUCT_IF_C aBFu16ll_BFu8c_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8c_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_Us");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_Us, aBFu16ll_BFu8c_Us)
//============================================================================



static void Test_aBFu16ll_BFu8c_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu8c_Vp");
    static STRUCT_IF_C aBFu16ll_BFu8c_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu8c_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8c_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8c_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8c_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8c_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8c_Vp");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8c_Vp, aBFu16ll_BFu8c_Vp)
//============================================================================



static void Test_aBFu16ll_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu8i lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i, aBFu16ll_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu16ll_BFu8i_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu8i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu15i, aBFu16ll_BFu8i_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu16ll_BFu8i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu8i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu15ll, aBFu16ll_BFu8i_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu16ll_BFu8i_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu8i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu15s, aBFu16ll_BFu8i_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu16ll_BFu8i_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu16i, aBFu16ll_BFu8i_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu16ll_BFu8i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu16ll, aBFu16ll_BFu8i_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu16ll_BFu8i_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu16s, aBFu16ll_BFu8i_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu8i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu16ll_BFu8i_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu8i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu17i, aBFu16ll_BFu8i_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu8i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu16ll_BFu8i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu8i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu17ll, aBFu16ll_BFu8i_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu1c, aBFu16ll_BFu8i_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu1i, aBFu16ll_BFu8i_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu1ll, aBFu16ll_BFu8i_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu1s, aBFu16ll_BFu8i_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu16ll_BFu8i_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu8i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu31i, aBFu16ll_BFu8i_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu16ll_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu31ll, aBFu16ll_BFu8i_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu16ll_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu32i, aBFu16ll_BFu8i_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu16ll_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu32ll, aBFu16ll_BFu8i_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu8i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aBFu16ll_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu33, aBFu16ll_BFu8i_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu7c, aBFu16ll_BFu8i_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu7i, aBFu16ll_BFu8i_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu7ll, aBFu16ll_BFu8i_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu7s, aBFu16ll_BFu8i_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu8c, aBFu16ll_BFu8i_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu8i, aBFu16ll_BFu8i_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu8ll, aBFu16ll_BFu8i_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu8s, aBFu16ll_BFu8i_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu16ll_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu9i, aBFu16ll_BFu8i_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu16ll_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu9ll, aBFu16ll_BFu8i_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu8i_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu8i_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu8i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu16ll_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_BFu9s, aBFu16ll_BFu8i_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu8i_C()
{
  {
    init_simple_test("aBFu16ll_BFu8i_C");
    static STRUCT_IF_C aBFu16ll_BFu8i_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_C");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_C");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_C");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_C, aBFu16ll_BFu8i_C)
//============================================================================



static void Test_aBFu16ll_BFu8i_D()
{
  {
    init_simple_test("aBFu16ll_BFu8i_D");
    static STRUCT_IF_C aBFu16ll_BFu8i_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu8i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_D");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_D");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_D");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_D, aBFu16ll_BFu8i_D)
//============================================================================



static void Test_aBFu16ll_BFu8i_F()
{
  {
    init_simple_test("aBFu16ll_BFu8i_F");
    static STRUCT_IF_C aBFu16ll_BFu8i_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_F");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_F");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_F");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_F, aBFu16ll_BFu8i_F)
//============================================================================



static void Test_aBFu16ll_BFu8i_I()
{
  {
    init_simple_test("aBFu16ll_BFu8i_I");
    static STRUCT_IF_C aBFu16ll_BFu8i_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_I");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_I");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_I");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_I, aBFu16ll_BFu8i_I)
//============================================================================



static void Test_aBFu16ll_BFu8i_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu8i_Ip");
    static STRUCT_IF_C aBFu16ll_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu8i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_Ip");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_Ip, aBFu16ll_BFu8i_Ip)
//============================================================================



static void Test_aBFu16ll_BFu8i_L()
{
  {
    init_simple_test("aBFu16ll_BFu8i_L");
    static STRUCT_IF_C aBFu16ll_BFu8i_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu8i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_L");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_L");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_L");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_L, aBFu16ll_BFu8i_L)
//============================================================================



static void Test_aBFu16ll_BFu8i_S()
{
  {
    init_simple_test("aBFu16ll_BFu8i_S");
    static STRUCT_IF_C aBFu16ll_BFu8i_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_S");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_S");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_S");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_S, aBFu16ll_BFu8i_S)
//============================================================================



static void Test_aBFu16ll_BFu8i_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu8i_Uc");
    static STRUCT_IF_C aBFu16ll_BFu8i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_Uc");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_Uc, aBFu16ll_BFu8i_Uc)
//============================================================================



static void Test_aBFu16ll_BFu8i_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu8i_Ui");
    static STRUCT_IF_C aBFu16ll_BFu8i_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_Ui");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_Ui, aBFu16ll_BFu8i_Ui)
//============================================================================



static void Test_aBFu16ll_BFu8i_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu8i_Ul");
    static STRUCT_IF_C aBFu16ll_BFu8i_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu8i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_Ul");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_Ul, aBFu16ll_BFu8i_Ul)
//============================================================================



static void Test_aBFu16ll_BFu8i_Us()
{
  {
    init_simple_test("aBFu16ll_BFu8i_Us");
    static STRUCT_IF_C aBFu16ll_BFu8i_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_Us");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_Us, aBFu16ll_BFu8i_Us)
//============================================================================



static void Test_aBFu16ll_BFu8i_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu8i_Vp");
    static STRUCT_IF_C aBFu16ll_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu8i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8i_Vp");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8i_Vp, aBFu16ll_BFu8i_Vp)
//============================================================================



static void Test_aBFu16ll_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu8ll lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll, aBFu16ll_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu16ll_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu15i, aBFu16ll_BFu8ll_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu16ll_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu15ll, aBFu16ll_BFu8ll_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu16ll_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu15s, aBFu16ll_BFu8ll_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu16ll_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu16i, aBFu16ll_BFu8ll_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu16ll_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu16ll, aBFu16ll_BFu8ll_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu16ll_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu16s, aBFu16ll_BFu8ll_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu8ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu16ll_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu17i, aBFu16ll_BFu8ll_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu16ll_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu17ll, aBFu16ll_BFu8ll_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu1c, aBFu16ll_BFu8ll_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu1i, aBFu16ll_BFu8ll_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu1ll, aBFu16ll_BFu8ll_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu1s, aBFu16ll_BFu8ll_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu16ll_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu31i, aBFu16ll_BFu8ll_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu16ll_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu31ll, aBFu16ll_BFu8ll_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu16ll_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu32i, aBFu16ll_BFu8ll_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu16ll_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu32ll, aBFu16ll_BFu8ll_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu8ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aBFu16ll_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu33, aBFu16ll_BFu8ll_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu7c, aBFu16ll_BFu8ll_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu7i, aBFu16ll_BFu8ll_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu7ll, aBFu16ll_BFu8ll_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu7s, aBFu16ll_BFu8ll_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu8c, aBFu16ll_BFu8ll_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu8i, aBFu16ll_BFu8ll_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu8ll, aBFu16ll_BFu8ll_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu8s, aBFu16ll_BFu8ll_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu16ll_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu9i, aBFu16ll_BFu8ll_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu16ll_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu9ll, aBFu16ll_BFu8ll_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu8ll_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu8ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu16ll_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_BFu9s, aBFu16ll_BFu8ll_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu8ll_C()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_C");
    static STRUCT_IF_C aBFu16ll_BFu8ll_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_C");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_C");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_C");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_C, aBFu16ll_BFu8ll_C)
//============================================================================



static void Test_aBFu16ll_BFu8ll_D()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_D");
    static STRUCT_IF_C aBFu16ll_BFu8ll_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu8ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_D");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_D");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_D");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_D, aBFu16ll_BFu8ll_D)
//============================================================================



static void Test_aBFu16ll_BFu8ll_F()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_F");
    static STRUCT_IF_C aBFu16ll_BFu8ll_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_F");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_F");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_F");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_F, aBFu16ll_BFu8ll_F)
//============================================================================



static void Test_aBFu16ll_BFu8ll_I()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_I");
    static STRUCT_IF_C aBFu16ll_BFu8ll_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_I");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_I");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_I");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_I, aBFu16ll_BFu8ll_I)
//============================================================================



static void Test_aBFu16ll_BFu8ll_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_Ip");
    static STRUCT_IF_C aBFu16ll_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu8ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_Ip");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_Ip, aBFu16ll_BFu8ll_Ip)
//============================================================================



static void Test_aBFu16ll_BFu8ll_L()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_L");
    static STRUCT_IF_C aBFu16ll_BFu8ll_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu8ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_L");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_L");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_L");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_L, aBFu16ll_BFu8ll_L)
//============================================================================



static void Test_aBFu16ll_BFu8ll_S()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_S");
    static STRUCT_IF_C aBFu16ll_BFu8ll_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_S");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_S");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_S");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_S, aBFu16ll_BFu8ll_S)
//============================================================================



static void Test_aBFu16ll_BFu8ll_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_Uc");
    static STRUCT_IF_C aBFu16ll_BFu8ll_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_Uc");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_Uc, aBFu16ll_BFu8ll_Uc)
//============================================================================



static void Test_aBFu16ll_BFu8ll_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_Ui");
    static STRUCT_IF_C aBFu16ll_BFu8ll_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_Ui");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_Ui, aBFu16ll_BFu8ll_Ui)
//============================================================================



static void Test_aBFu16ll_BFu8ll_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_Ul");
    static STRUCT_IF_C aBFu16ll_BFu8ll_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu8ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_Ul");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_Ul, aBFu16ll_BFu8ll_Ul)
//============================================================================



static void Test_aBFu16ll_BFu8ll_Us()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_Us");
    static STRUCT_IF_C aBFu16ll_BFu8ll_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_Us");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_Us, aBFu16ll_BFu8ll_Us)
//============================================================================



static void Test_aBFu16ll_BFu8ll_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu8ll_Vp");
    static STRUCT_IF_C aBFu16ll_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu8ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8ll_Vp");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8ll_Vp, aBFu16ll_BFu8ll_Vp)
//============================================================================



static void Test_aBFu16ll_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu8s lv;
    check2(sizeof(lv), 3, "sizeof(aBFu16ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s, aBFu16ll_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu16ll_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu15i, aBFu16ll_BFu8s_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu16ll_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu15ll, aBFu16ll_BFu8s_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, 1, "aBFu16ll_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 3, 0, 15, hide_ull(1LL<<14), "aBFu16ll_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu15s, aBFu16ll_BFu8s_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu16i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu16ll_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu16i, aBFu16ll_BFu8s_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu16ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu16ll_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu16ll, aBFu16ll_BFu8s_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu16s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, 1, "aBFu16ll_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 3, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu16s, aBFu16ll_BFu8s_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu8s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu16ll_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu17i, aBFu16ll_BFu8s_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu8s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, 1, "aBFu16ll_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 0, 17, hide_ull(1LL<<16), "aBFu16ll_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu17ll, aBFu16ll_BFu8s_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu1c, aBFu16ll_BFu8s_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu1i, aBFu16ll_BFu8s_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu1ll, aBFu16ll_BFu8s_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 3, 0, 1, 1, "aBFu16ll_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu1s, aBFu16ll_BFu8s_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8s_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu16ll_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu31i, aBFu16ll_BFu8s_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8s_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, 1, "aBFu16ll_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 0, 31, hide_ull(1LL<<30), "aBFu16ll_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu31ll, aBFu16ll_BFu8s_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu32i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8s_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu16ll_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu32i, aBFu16ll_BFu8s_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8s_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, 1, "aBFu16ll_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 0, 32, hide_ull(1LL<<31), "aBFu16ll_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu32ll, aBFu16ll_BFu8s_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu8s_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, 1, "aBFu16ll_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 3, 0, 33, hide_ull(1LL<<32), "aBFu16ll_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu33, aBFu16ll_BFu8s_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu7c, aBFu16ll_BFu8s_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu7i, aBFu16ll_BFu8s_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu7ll, aBFu16ll_BFu8s_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, 1, "aBFu16ll_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 3, 0, 7, hide_ull(1LL<<6), "aBFu16ll_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu7s, aBFu16ll_BFu8s_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu8c, aBFu16ll_BFu8s_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu8i, aBFu16ll_BFu8s_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu8ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu8ll, aBFu16ll_BFu8s_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "aBFu16ll_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu8s, aBFu16ll_BFu8s_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8s_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu16ll_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu9i, aBFu16ll_BFu8s_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8s_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu16ll_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu9ll, aBFu16ll_BFu8s_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu8s_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu8s_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu8s_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8s_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, 1, "aBFu16ll_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 3, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_BFu9s, aBFu16ll_BFu8s_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu8s_C()
{
  {
    init_simple_test("aBFu16ll_BFu8s_C");
    static STRUCT_IF_C aBFu16ll_BFu8s_C lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_C");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_C");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_C");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_C, aBFu16ll_BFu8s_C)
//============================================================================



static void Test_aBFu16ll_BFu8s_D()
{
  {
    init_simple_test("aBFu16ll_BFu8s_D");
    static STRUCT_IF_C aBFu16ll_BFu8s_D lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu8s_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_D");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_D");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_D");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_D, aBFu16ll_BFu8s_D)
//============================================================================



static void Test_aBFu16ll_BFu8s_F()
{
  {
    init_simple_test("aBFu16ll_BFu8s_F");
    static STRUCT_IF_C aBFu16ll_BFu8s_F lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8s_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_F");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_F");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_F");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_F, aBFu16ll_BFu8s_F)
//============================================================================



static void Test_aBFu16ll_BFu8s_I()
{
  {
    init_simple_test("aBFu16ll_BFu8s_I");
    static STRUCT_IF_C aBFu16ll_BFu8s_I lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8s_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_I");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_I");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_I");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_I, aBFu16ll_BFu8s_I)
//============================================================================



static void Test_aBFu16ll_BFu8s_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu8s_Ip");
    static STRUCT_IF_C aBFu16ll_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu8s_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_Ip");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_Ip, aBFu16ll_BFu8s_Ip)
//============================================================================



static void Test_aBFu16ll_BFu8s_L()
{
  {
    init_simple_test("aBFu16ll_BFu8s_L");
    static STRUCT_IF_C aBFu16ll_BFu8s_L lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu8s_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_L");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_L");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_L");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_L, aBFu16ll_BFu8s_L)
//============================================================================



static void Test_aBFu16ll_BFu8s_S()
{
  {
    init_simple_test("aBFu16ll_BFu8s_S");
    static STRUCT_IF_C aBFu16ll_BFu8s_S lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8s_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_S");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_S");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_S");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_S, aBFu16ll_BFu8s_S)
//============================================================================



static void Test_aBFu16ll_BFu8s_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu8s_Uc");
    static STRUCT_IF_C aBFu16ll_BFu8s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu8s_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_Uc");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_Uc, aBFu16ll_BFu8s_Uc)
//============================================================================



static void Test_aBFu16ll_BFu8s_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu8s_Ui");
    static STRUCT_IF_C aBFu16ll_BFu8s_Ui lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu8s_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_Ui");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_Ui, aBFu16ll_BFu8s_Ui)
//============================================================================



static void Test_aBFu16ll_BFu8s_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu8s_Ul");
    static STRUCT_IF_C aBFu16ll_BFu8s_Ul lv;
    check2(sizeof(lv), 11, "sizeof(aBFu16ll_BFu8s_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_Ul");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_Ul, aBFu16ll_BFu8s_Ul)
//============================================================================



static void Test_aBFu16ll_BFu8s_Us()
{
  {
    init_simple_test("aBFu16ll_BFu8s_Us");
    static STRUCT_IF_C aBFu16ll_BFu8s_Us lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu8s_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_Us");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_Us");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_Us, aBFu16ll_BFu8s_Us)
//============================================================================



static void Test_aBFu16ll_BFu8s_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu8s_Vp");
    static STRUCT_IF_C aBFu16ll_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(11,7), "sizeof(aBFu16ll_BFu8s_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu8s_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu8s_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu8s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, 1, "aBFu16ll_BFu8s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 8, hide_ull(1LL<<7), "aBFu16ll_BFu8s_Vp");
    check_field_offset(lv, v3, 3, "aBFu16ll_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu8s_Vp, aBFu16ll_BFu8s_Vp)
//============================================================================



static void Test_aBFu16ll_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i, aBFu16ll_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9i_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aBFu16ll_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu15i, aBFu16ll_BFu9i_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9i_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aBFu16ll_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu15ll, aBFu16ll_BFu9i_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9i_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aBFu16ll_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu15s, aBFu16ll_BFu9i_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9i_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aBFu16ll_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu16i, aBFu16ll_BFu9i_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9i_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aBFu16ll_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu16ll, aBFu16ll_BFu9i_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9i_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aBFu16ll_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu16s, aBFu16ll_BFu9i_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9i_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aBFu16ll_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu17i, aBFu16ll_BFu9i_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9i_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aBFu16ll_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu17ll, aBFu16ll_BFu9i_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9i_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aBFu16ll_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu1c, aBFu16ll_BFu9i_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9i_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aBFu16ll_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu1i, aBFu16ll_BFu9i_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9i_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aBFu16ll_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu1ll, aBFu16ll_BFu9i_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9i_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aBFu16ll_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu1s, aBFu16ll_BFu9i_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu9i_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "aBFu16ll_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu31i, aBFu16ll_BFu9i_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu9i_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "aBFu16ll_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu31ll, aBFu16ll_BFu9i_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu9i_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "aBFu16ll_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu32i, aBFu16ll_BFu9i_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu9i_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "aBFu16ll_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu32ll, aBFu16ll_BFu9i_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu9i_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "aBFu16ll_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "aBFu16ll_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu33, aBFu16ll_BFu9i_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9i_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aBFu16ll_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu7c, aBFu16ll_BFu9i_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9i_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aBFu16ll_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu7i, aBFu16ll_BFu9i_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9i_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aBFu16ll_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu7ll, aBFu16ll_BFu9i_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9i_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aBFu16ll_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu7s, aBFu16ll_BFu9i_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9i_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aBFu16ll_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu8c, aBFu16ll_BFu9i_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9i_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aBFu16ll_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu8i, aBFu16ll_BFu9i_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9i_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aBFu16ll_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu8ll, aBFu16ll_BFu9i_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9i_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aBFu16ll_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu8s, aBFu16ll_BFu9i_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9i_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aBFu16ll_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu9i, aBFu16ll_BFu9i_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9i_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aBFu16ll_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu9ll, aBFu16ll_BFu9i_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu9i_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu9i_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu9i_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9i_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aBFu16ll_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_BFu9s, aBFu16ll_BFu9i_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu9i_C()
{
  {
    init_simple_test("aBFu16ll_BFu9i_C");
    static STRUCT_IF_C aBFu16ll_BFu9i_C lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9i_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_C");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_C");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_C");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_C, aBFu16ll_BFu9i_C)
//============================================================================



static void Test_aBFu16ll_BFu9i_D()
{
  {
    init_simple_test("aBFu16ll_BFu9i_D");
    static STRUCT_IF_C aBFu16ll_BFu9i_D lv;
    check2(sizeof(lv), 12, "sizeof(aBFu16ll_BFu9i_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_D");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_D");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_D");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_D, aBFu16ll_BFu9i_D)
//============================================================================



static void Test_aBFu16ll_BFu9i_F()
{
  {
    init_simple_test("aBFu16ll_BFu9i_F");
    static STRUCT_IF_C aBFu16ll_BFu9i_F lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu9i_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_F");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_F");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_F");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_F, aBFu16ll_BFu9i_F)
//============================================================================



static void Test_aBFu16ll_BFu9i_I()
{
  {
    init_simple_test("aBFu16ll_BFu9i_I");
    static STRUCT_IF_C aBFu16ll_BFu9i_I lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu9i_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_I");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_I");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_I");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_I, aBFu16ll_BFu9i_I)
//============================================================================



static void Test_aBFu16ll_BFu9i_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu9i_Ip");
    static STRUCT_IF_C aBFu16ll_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu16ll_BFu9i_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_Ip");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_Ip, aBFu16ll_BFu9i_Ip)
//============================================================================



static void Test_aBFu16ll_BFu9i_L()
{
  {
    init_simple_test("aBFu16ll_BFu9i_L");
    static STRUCT_IF_C aBFu16ll_BFu9i_L lv;
    check2(sizeof(lv), 12, "sizeof(aBFu16ll_BFu9i_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_L");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_L");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_L");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_L, aBFu16ll_BFu9i_L)
//============================================================================



static void Test_aBFu16ll_BFu9i_S()
{
  {
    init_simple_test("aBFu16ll_BFu9i_S");
    static STRUCT_IF_C aBFu16ll_BFu9i_S lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9i_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_S");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_S");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_S");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_S, aBFu16ll_BFu9i_S)
//============================================================================



static void Test_aBFu16ll_BFu9i_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu9i_Uc");
    static STRUCT_IF_C aBFu16ll_BFu9i_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9i_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_Uc");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_Uc, aBFu16ll_BFu9i_Uc)
//============================================================================



static void Test_aBFu16ll_BFu9i_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu9i_Ui");
    static STRUCT_IF_C aBFu16ll_BFu9i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu9i_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_Ui");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_Ui, aBFu16ll_BFu9i_Ui)
//============================================================================



static void Test_aBFu16ll_BFu9i_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu9i_Ul");
    static STRUCT_IF_C aBFu16ll_BFu9i_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aBFu16ll_BFu9i_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_Ul");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_Ul, aBFu16ll_BFu9i_Ul)
//============================================================================



static void Test_aBFu16ll_BFu9i_Us()
{
  {
    init_simple_test("aBFu16ll_BFu9i_Us");
    static STRUCT_IF_C aBFu16ll_BFu9i_Us lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9i_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_Us");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_Us");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_Us");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_Us, aBFu16ll_BFu9i_Us)
//============================================================================



static void Test_aBFu16ll_BFu9i_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu9i_Vp");
    static STRUCT_IF_C aBFu16ll_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu16ll_BFu9i_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9i_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9i_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9i_Vp");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9i_Vp, aBFu16ll_BFu9i_Vp)
//============================================================================



static void Test_aBFu16ll_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu9ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll, aBFu16ll_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9ll_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aBFu16ll_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu15i, aBFu16ll_BFu9ll_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aBFu16ll_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu15ll, aBFu16ll_BFu9ll_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9ll_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aBFu16ll_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu15s, aBFu16ll_BFu9ll_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9ll_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aBFu16ll_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu16i, aBFu16ll_BFu9ll_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aBFu16ll_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu16ll, aBFu16ll_BFu9ll_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9ll_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aBFu16ll_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu16s, aBFu16ll_BFu9ll_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9ll_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aBFu16ll_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu17i, aBFu16ll_BFu9ll_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aBFu16ll_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu17ll, aBFu16ll_BFu9ll_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu1c");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9ll_BFu1c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu1c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu1c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aBFu16ll_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu1c, aBFu16ll_BFu9ll_BFu1c)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu1i()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu1i");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9ll_BFu1i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu1i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu1i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aBFu16ll_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu1i, aBFu16ll_BFu9ll_BFu1i)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu1ll()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu1ll");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu1ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aBFu16ll_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu1ll, aBFu16ll_BFu9ll_BFu1ll)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu1s()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu1s");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9ll_BFu1s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu1s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu1s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 1, 1, 1, "aBFu16ll_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu1s, aBFu16ll_BFu9ll_BFu1s)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu31i()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu31i");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu9ll_BFu31i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu31i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu31i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "aBFu16ll_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu31i, aBFu16ll_BFu9ll_BFu31i)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu31ll()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu31ll");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 7, "sizeof(aBFu16ll_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu31ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, 1, "aBFu16ll_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 1, 31, hide_ull(1LL<<30), "aBFu16ll_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu31ll, aBFu16ll_BFu9ll_BFu31ll)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu32i()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu32i");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu9ll_BFu32i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu32i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu32i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "aBFu16ll_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu32i, aBFu16ll_BFu9ll_BFu32i)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu32ll()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu32ll");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu32ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, 1, "aBFu16ll_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 1, 32, hide_ull(1LL<<31), "aBFu16ll_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu32ll, aBFu16ll_BFu9ll_BFu32ll)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu33()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu33");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu9ll_BFu33)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu33)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu33");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, 1, "aBFu16ll_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 3, 1, 33, hide_ull(1LL<<32), "aBFu16ll_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu33, aBFu16ll_BFu9ll_BFu33)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu7c()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu7c");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9ll_BFu7c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu7c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu7c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aBFu16ll_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu7c, aBFu16ll_BFu9ll_BFu7c)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu7i()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu7i");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9ll_BFu7i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu7i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu7i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aBFu16ll_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu7i, aBFu16ll_BFu9ll_BFu7i)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu7ll()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu7ll");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu7ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aBFu16ll_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu7ll, aBFu16ll_BFu9ll_BFu7ll)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu7s()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu7s");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9ll_BFu7s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu7s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu7s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, 1, "aBFu16ll_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 3, 1, 7, hide_ull(1LL<<6), "aBFu16ll_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu7s, aBFu16ll_BFu9ll_BFu7s)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu8c()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu8c");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu8c lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9ll_BFu8c)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu8c)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu8c");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aBFu16ll_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu8c, aBFu16ll_BFu9ll_BFu8c)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu8i()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu8i");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu8i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9ll_BFu8i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu8i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu8i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aBFu16ll_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu8i, aBFu16ll_BFu9ll_BFu8i)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu8ll()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu8ll");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu8ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aBFu16ll_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu8ll, aBFu16ll_BFu9ll_BFu8ll)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu8s()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu8s");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu8s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9ll_BFu8s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu8s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu8s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, 1, "aBFu16ll_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 3, 1, 8, hide_ull(1LL<<7), "aBFu16ll_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu8s, aBFu16ll_BFu9ll_BFu8s)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu9i()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu9i");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu9i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9ll_BFu9i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu9i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aBFu16ll_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu9i, aBFu16ll_BFu9ll_BFu9i)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu9ll()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu9ll");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu9ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aBFu16ll_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu9ll, aBFu16ll_BFu9ll_BFu9ll)
//============================================================================



static void Test_aBFu16ll_BFu9ll_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu9ll_BFu9s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, 1, "aBFu16ll_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 3, 1, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_BFu9s, aBFu16ll_BFu9ll_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu9ll_C()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_C");
    static STRUCT_IF_C aBFu16ll_BFu9ll_C lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9ll_C)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_C)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_C");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_C");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_C");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_C");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_C, aBFu16ll_BFu9ll_C)
//============================================================================



static void Test_aBFu16ll_BFu9ll_D()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_D");
    static STRUCT_IF_C aBFu16ll_BFu9ll_D lv;
    check2(sizeof(lv), 12, "sizeof(aBFu16ll_BFu9ll_D)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_D)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_D");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_D");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_D");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_D");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_D, aBFu16ll_BFu9ll_D)
//============================================================================



static void Test_aBFu16ll_BFu9ll_F()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_F");
    static STRUCT_IF_C aBFu16ll_BFu9ll_F lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu9ll_F)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_F)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_F");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_F");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_F");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_F");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_F, aBFu16ll_BFu9ll_F)
//============================================================================



static void Test_aBFu16ll_BFu9ll_I()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_I");
    static STRUCT_IF_C aBFu16ll_BFu9ll_I lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu9ll_I)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_I)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_I");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_I");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_I");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_I");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_I, aBFu16ll_BFu9ll_I)
//============================================================================



static void Test_aBFu16ll_BFu9ll_Ip()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_Ip");
    static STRUCT_IF_C aBFu16ll_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu16ll_BFu9ll_Ip)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_Ip)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_Ip");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_Ip");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_Ip, aBFu16ll_BFu9ll_Ip)
//============================================================================



static void Test_aBFu16ll_BFu9ll_L()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_L");
    static STRUCT_IF_C aBFu16ll_BFu9ll_L lv;
    check2(sizeof(lv), 12, "sizeof(aBFu16ll_BFu9ll_L)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_L)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_L");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_L");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_L");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_L");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_L, aBFu16ll_BFu9ll_L)
//============================================================================



static void Test_aBFu16ll_BFu9ll_S()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_S");
    static STRUCT_IF_C aBFu16ll_BFu9ll_S lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9ll_S)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_S)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_S");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_S");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_S");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_S");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_S, aBFu16ll_BFu9ll_S)
//============================================================================



static void Test_aBFu16ll_BFu9ll_Uc()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_Uc");
    static STRUCT_IF_C aBFu16ll_BFu9ll_Uc lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9ll_Uc)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_Uc)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_Uc");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_Uc");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_Uc, aBFu16ll_BFu9ll_Uc)
//============================================================================



static void Test_aBFu16ll_BFu9ll_Ui()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_Ui");
    static STRUCT_IF_C aBFu16ll_BFu9ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(aBFu16ll_BFu9ll_Ui)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_Ui)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_Ui");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_Ui");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_Ui, aBFu16ll_BFu9ll_Ui)
//============================================================================



static void Test_aBFu16ll_BFu9ll_Ul()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_Ul");
    static STRUCT_IF_C aBFu16ll_BFu9ll_Ul lv;
    check2(sizeof(lv), 12, "sizeof(aBFu16ll_BFu9ll_Ul)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_Ul)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_Ul");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_Ul");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_Ul, aBFu16ll_BFu9ll_Ul)
//============================================================================



static void Test_aBFu16ll_BFu9ll_Us()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_Us");
    static STRUCT_IF_C aBFu16ll_BFu9ll_Us lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9ll_Us)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_Us)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_Us");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_Us");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_Us, aBFu16ll_BFu9ll_Us)
//============================================================================



static void Test_aBFu16ll_BFu9ll_Vp()
{
  {
    init_simple_test("aBFu16ll_BFu9ll_Vp");
    static STRUCT_IF_C aBFu16ll_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(12,8), "sizeof(aBFu16ll_BFu9ll_Vp)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9ll_Vp)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9ll_Vp");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9ll_Vp");
    check_field_offset(lv, v3, 4, "aBFu16ll_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9ll_Vp, aBFu16ll_BFu9ll_Vp)
//============================================================================



static void Test_aBFu16ll_BFu9s()
{
  {
    init_simple_test("aBFu16ll_BFu9s");
    static STRUCT_IF_C aBFu16ll_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(aBFu16ll_BFu9s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9s, aBFu16ll_BFu9s)
//============================================================================



static void Test_aBFu16ll_BFu9s_BFu15i()
{
  {
    init_simple_test("aBFu16ll_BFu9s_BFu15i");
    static STRUCT_IF_C aBFu16ll_BFu9s_BFu15i lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9s_BFu15i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9s_BFu15i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9s_BFu15i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aBFu16ll_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9s_BFu15i, aBFu16ll_BFu9s_BFu15i)
//============================================================================



static void Test_aBFu16ll_BFu9s_BFu15ll()
{
  {
    init_simple_test("aBFu16ll_BFu9s_BFu15ll");
    static STRUCT_IF_C aBFu16ll_BFu9s_BFu15ll lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9s_BFu15ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9s_BFu15ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9s_BFu15ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aBFu16ll_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9s_BFu15ll, aBFu16ll_BFu9s_BFu15ll)
//============================================================================



static void Test_aBFu16ll_BFu9s_BFu15s()
{
  {
    init_simple_test("aBFu16ll_BFu9s_BFu15s");
    static STRUCT_IF_C aBFu16ll_BFu9s_BFu15s lv;
    check2(sizeof(lv), 5, "sizeof(aBFu16ll_BFu9s_BFu15s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9s_BFu15s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9s_BFu15s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, 1, "aBFu16ll_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 3, 1, 15, hide_ull(1LL<<14), "aBFu16ll_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9s_BFu15s, aBFu16ll_BFu9s_BFu15s)
//============================================================================



static void Test_aBFu16ll_BFu9s_BFu16i()
{
  {
    init_simple_test("aBFu16ll_BFu9s_BFu16i");
    static STRUCT_IF_C aBFu16ll_BFu9s_BFu16i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9s_BFu16i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9s_BFu16i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9s_BFu16i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aBFu16ll_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9s_BFu16i, aBFu16ll_BFu9s_BFu16i)
//============================================================================



static void Test_aBFu16ll_BFu9s_BFu16ll()
{
  {
    init_simple_test("aBFu16ll_BFu9s_BFu16ll");
    static STRUCT_IF_C aBFu16ll_BFu9s_BFu16ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9s_BFu16ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9s_BFu16ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9s_BFu16ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aBFu16ll_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9s_BFu16ll, aBFu16ll_BFu9s_BFu16ll)
//============================================================================



static void Test_aBFu16ll_BFu9s_BFu16s()
{
  {
    init_simple_test("aBFu16ll_BFu9s_BFu16s");
    static STRUCT_IF_C aBFu16ll_BFu9s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9s_BFu16s)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9s_BFu16s)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9s_BFu16s");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, 1, "aBFu16ll_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 3, 1, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9s_BFu16s, aBFu16ll_BFu9s_BFu16s)
//============================================================================



static void Test_aBFu16ll_BFu9s_BFu17i()
{
  {
    init_simple_test("aBFu16ll_BFu9s_BFu17i");
    static STRUCT_IF_C aBFu16ll_BFu9s_BFu17i lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9s_BFu17i)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9s_BFu17i)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9s_BFu17i");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aBFu16ll_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9s_BFu17i, aBFu16ll_BFu9s_BFu17i)
//============================================================================



static void Test_aBFu16ll_BFu9s_BFu17ll()
{
  {
    init_simple_test("aBFu16ll_BFu9s_BFu17ll");
    static STRUCT_IF_C aBFu16ll_BFu9s_BFu17ll lv;
    check2(sizeof(lv), 6, "sizeof(aBFu16ll_BFu9s_BFu17ll)");
    check2(__alignof__(lv), 1, "__alignof__(aBFu16ll_BFu9s_BFu17ll)");
    set_bf_and_test(lv, v1, 0, 0, 16, 1, "aBFu16ll_BFu9s_BFu17ll");
    set_bf_and_test(lv, v1, 0, 0, 16, hide_ull(1LL<<15), "aBFu16ll_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 9, 1, "aBFu16ll_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 9, hide_ull(1LL<<8), "aBFu16ll_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, 1, "aBFu16ll_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 1, 17, hide_ull(1LL<<16), "aBFu16ll_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_aBFu16ll_BFu9s_BFu17ll, aBFu16ll_BFu9s_BFu17ll)
//============================================================================



static void Test_aBFu16ll_BFu9s_BFu1c()
{
  {
    init_simple_test("aBFu16ll_BFu9s_BFu1c